

#The History of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The History of Ireland
======================


Author: Geoffrey Keating
------------------------


### File Description

translated and preface by David Comyn, Patrick S. Dinneen

Electronic edition compiled by the CELT Team

Funded by University College, Cork and  
Professor Marianne McDonald via the CELT Project 1. First draft, revised and corrected.Extent of text: 173970 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland. — http://www.ucc.ie/celt

 (2002) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T100054Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

You can purchase the book(s) containing this text via the ITS website (http://www.irishtextssociety.org/). Click on the link to the RIA shop.

#### Sources


**Selected manuscript sources (a full list is given in Cunningham, The World of Geoffrey Keating).**- UCD-OFM A 14; begun in convent of Kildare on a 4th of September. Though undated, but believed to be one of the oldest existing transcripts. This was the exemplar kept in the Franciscan Library, Donegal; taken to Louvain, and used by Colgan; later taken to Rome.- TCD 1397 (H 5 26); by Seán mac Torna Ó Maolchonaire, c 1650.- TCD 1403 (H 5 32). 1645 at Donegal (?), scribe of first part Seán mac Torna Ó Maolchonaire; second part written in archaic style; perhaps by M. Ó Cléirigh?- Dublin, King's Inns, copied in July 1657, by Seán mac Torna Ó Maolchonaire for Domhnall Ó Cearbhaill. This text was used by Haliday, and differed "considerably in places from those named."- A MS which was in the possession of D. Comyn, written by Séamas Ó Maolchonaire of Ballymecuda, Co. Clare, dated 1643.- A MS which was in the possession of D. Comyn, written in Dublin by Tadhg Ó Neachtáin dated 1704.**Editions, translations and adaptations**2. The general history of Ireland ... Collected by the learned Jeoffrey Keating, D.D. Faithfully translated from the original Irish language, with many curious amendments taken from the Psalters of Tara 
and Cashel, and other authentic Records by Dermod O'Connor. Dublin, 1723.
3. The Second edition. With an appendix, collected from the Remarks of the learned Dr. Anthony Raymond of Trim, not in the former edition. Westminster, 1726.
4. [Another ed.] 2 vols, Newry, 1817.
5. [Another ed.] Dublin, 1854.
6. Forus Feasa ar Eirinn, mar a nochtar príomhdhala na hinnse o Pharthalon go Gabhaltus Gall, ar na chnuasach, & air na thiomsúghadh o phríomhlebhraibh Shenchusa Eirenn, 
agas o iliomad d'ughdaraibh baranthamhla coigcríche le Seathrún Ceitin, ollamh-diadhachta, An 1 chuid. (A complete History of Ireland ... Vol. I). 411 pp, Dublin, 1811.
7. Díonbhrollach Fórais Feasa ar Éirinn: or Vindication of the Sources of Irish History by Rev. Dr. Geoffrey Keating, being the Introduction to his 'Groundwork of Knowledge of 
Ireland'. Edited (from MSS) with new translation, notes, vocabulary, etc. by David Comyn. 112pp, Dublin, 1898.
8. Forus Feasa ar Éirinn. Keating's History of Ireland. Book I, Part I. Edited with Gaelic text (from a MS of T.C.D [H. 5. 26]), literal translation, explanation of Gaelic idioms, complete 
vocabulary, etc., by P. W. Joyce. 8 + 168 pp, Dublin, 1900.
9. Foras Feasa ar Eirinn do réir an Athar Seathrun Céiting, ollamh ré diadhachta. The history of Ireland, from the earliest period to the English invasion. Translated from the 
original Gaelic, and copiously annotated, by John O'Mahony. With topographical appendix. 20 + 746 pp, New York, 1866.
10. Sgélaigheacht Chéitinn. Stories from Keating's History of Ireland. Edited with Introduction, Notes and Vocabulary, by O.J. Bergin. 20 + 132 pp, Dublin 1909. Second edition, revised and 
enlarged, 1925. Third edition, revised and enlarged, 1930; reprinted 1981.
11. Sir John T. Gilbert, Facsimiles of National manuscripts of Ireland. Pt. IV. [Pl LXXIII. History of Ireland by Geoffrey Keating. Trinity College. Commencement of Preface transcr. by John O'Maelchonaire. Text 
and transl. Pl. LXXIV. Michael Kearney's English version, 1668. Irish and Engl.] London, 1882.
12. P. S. Dinneen, The history of Ireland. Foras Feasa ar Éirinn. Vol. IV. Containing the genealogies and synchronisms. With an index which includes the elucidation of place names and annotations to 
text of vols. I. II. III. Compiled and edited by Rev. Patrick S. Dinneen. (Irish Texts Society Vol XV.) 483 pp, London, 1914.
13. Pádraig de Barra/Seathrún Céitinn, 'Foras feasa ar Éirinn', athnua le Pádraig de Barra. Imleabhar 1: .i. An díonbhrollach agus an chéad leabhar de Foras 
feasa ar Éirinn Seathrún Céitinn. Dublin 1982. Imleabhar II .i. an dara leabhar de Foras feasa ar Éirinn le Seathrún Céitinn. Dublin 1983.
**Further reading: a selection**2. Ulick de Burgh, Earl of Clanricarde (ed), Memoirs of the Right Honourable The Marquis of Clanricarde, Lord Deputy General of Ireland, containing Several Original Papers and Letters of King Charles II, Queen Mother, the Duke of York, the Duke of Lorrain, the Marquis of Ormond, Archbishop of Tuam, Lord Viscount Taaffe, &c. relating to the Treaty between the Duke of Lorrain and the Irish Commissioners, from February 1650, to August 1653. Publish'd from his Lordship's Original MSS. To which is Prefix'd, a Dissertation, wherein some Passages of these Memoirs are illustrated. With a Digression containing several curious Observations concerning the Antiquities of Ireland. London: Printed for James Woodman, at Camden's Head, under Will's Coffee-House, in Bow-Street, Covent-Garden, 1722.
3. John O'Donovan, Annala Rioghachta Eireann: Annals of the kingdom of Ireland by the Four Masters, from the earliest period to the year 1616. Edited from MSS in the Library of the Royal Irish Academy and of Trinity College Dublin with a translation and copious notes. (Dublin 1848–51).
4. Eugene O'Curry, Lectures on the manuscript materials of ancient Irish history (Dublin and New York 1861; repr. Dublin 1878; repr. Dublin 1995). [comments on Keating's FFE].
5. Thomas D'Arcy McGee, A popular History of Ireland: from the earliest Period to the Emancipation of the Catholics, 2 vols. (New York 1863).
6. William P. Burke, 'Geoffry Keating', Journal of the Waterford and South-East of Ireland Archaeological Society 1, no. 4 (1895) 173–82.
7. William P. Burke, 'Correspondence', Journal of the Waterford Archaeological Society 2 (1896) 238–239.
8. Douglas Hyde, Literary History of Ireland. From earliest tiems to the present day [general remarks about Keating's work and style in relation to other writers] (2nd impression, New York 1901) 556–557; 580.
9. Eoin Cathmhaolach Mac Giolla Eáin (=John MacErlean), Dánta Amhráin is Caointe Shethrúin Chétinn; Dochtúir diadhachta (1570-1650 A.D.) (Baile Átha Cliath [Dublin] 1900).
10. Ris[t]eárd Ó Foghludha (=Richard Foley), Saoghal-ré Sheathrúin Céitinn: Sacart is dochtúir san diadhacht, staruidhe, file, ughdar, &c. Risteard Ó Foghludha (Richard Foley or 'Fiachra Éilgeach') do scríbh, (Dublin 1908. Reprinted from Gaelic Journal XVIII, 1–12, 47–57, 1908.)
11. Richard Henebry, 'Geoffrey Keating', in: Journal of the Ivernian Society 5 (1913) 197–202.
12. Gerald O'Nolan, A critical analysis of Keating's prose (Dublin: Educational Co. of Ireland 1922).
13. Geoffrey Coulter, 'Dr. Geoffrey Keating. A learned outlaw. History written in a cave', Irish Times, 25 October 1929, p. 4.
14. Anne Cronin, 'The sources of Keating's Forus feasa ar Éirinn', in: Éigse 4, 1943/44 (1945) (pt. 4) 235–79, 1945/47 (1948) (pt. 2, 1946) 122–35 [no
more publ.] 1. The printed sources; 2. Manuscript sources, (1) The manuscript sources of book 1, chaps. 4–23).
15. M. J. Connellan, 'The see of Tuaim in Rath Breasail synod', in: Journal of the Galway Archaeological and Historical Society 24 (1950/51) 19–26. (ad FF iii, 302–5).
16. Pádraig Ó Súilleabháin, 'Céitinn agus Caesarius Heisterbacensis', in: Éigse 9 (1958/61), (pt. 4) 242 (Varia, no. 4).
17. Brian Ó Cuív, (ed), An eighteenth-century account of Keating and his Foras feasa ar Éirinn, in: Éigse 9 (1958) 263–69.
18. Cainneach Ó Maonaigh, Scríbhneoirí Gaeilge an seachtú haois déag. Studia Hibernica 2 (1962) 182–208.
19. Brian Ó Cuív (ed), 'A seventeenth-century criticism of Keating's Forus Feasa ar Éirinn', in: Éigse 11/ 2 (1965) 119–140. [From MS 
RIA. 23 M 40; with notes].
20. Brian Ó Cuív (ed), l. Labraid Loingsech [incl. ed. of relevant scholia to ACC, 
from MS NLI G 50; on Keating's use of source material for the Labraid Loingsech section in FF] in: Éigse 11, (1964/66) (pt. 3, 1965) 167–187, 290.
21. Aidan Clarke, The Old English in Ireland 1625–42 (London 1966).
22. Pádraig Ó Fiannachta, 'Stair finnscéal agus annála', in: Léachtaí Cholm Chille 2/1 (1971) 5–13.
23. Francis John Byrne, 'Senchas: The nature of Gaelic historical tradition,' Historical Studies, 9 (1974) 137–59 (esp. 147–148: 'FFÉ as an example of pseudo-history and blending of seanchas with continental models of history).
24. Brian Ó Cuív, 'The Irish language in the early modern period', in: Theodore William Moody; Francis Xavier Martin; F. J. Byrne (eds), A new history of Ireland, vol. 3: Early Modern Ireland, 1534–1691 (Oxford 1976) 509–545.
25. Kathleen Hughes, The Early Celtic Idea of History and the Modern Historian (Cambridge: Cambridge University Press 1977), esp. 19–22: 'FFÉ as an example of pseudo-history and blending of seanchas with continental models of history'.
26. Seán Ó Dúshláine, Nóta ar cheapadóireacht an Chéitinnigh, in: Éigse 18 (1980–81) 87–92.
27. Patrick J. Corish, The Catholic Community in the Seventeenth and Eighteenth Centuries (Dublin 1981).
28. Muireann Ní Bhrolcháin, 'A possible source for Keating's Forus feasa ar Éirinn', in: Éigse 19 (1982–83) 61–81.
29. Nicholas Canny, 'The Formation of the Irish Mind: Religion, Politics and Gaelic Irish Literature 1580–1750', Past & Present 95 (1982) 91–116.
30. Breandán Ó Buachalla, 'Annála Ríoghachta Éireann' agus 'Foras Feasa ar Éirinn': an Comhthéacs Comhaimseartha, in: Studia 
Hibernica 22–23 (1982–83) 59–105.
31. Seán Ó Dúshláine, 'More about Keating's use of the simile of the Dung-Beetle', in: Zeitschrift für Celtische Philologie 40 (1984) 282–285.
32. Seán Ó Dúshláine, 'Seathrún Céitinn agus an stíl bharócach a thug sé go h-Éirinn', in: Feasta 37/10 
(1984) 10–15.
33. Donnchadh Ó Corráin, 'Seathrún Céitinn (c.1580–c.1644): an cúlra stairiúil', in: Liam Prút (ed) Dúchas 1986–1989 (Baile Átha Cliath 1990).
34. Bernadette Cunningham, 'Seventeenth-century interpretations of the past: the case of Geoffrey Keating', Irish Historical Studies 25/ (1986) 116–128.
35. Joseph Th. Leerssen, Mere Irish and Fíor-Ghael: Studies in the idea of Irish nationality, its development and literay expression prior to the nineteenth century (Amsterdam/Philadelphia 1986).
36. Diarmaid Ó Catháin, Dermot O'Connor: translator of Keating, in: Eighteenth-Century Ireland. Iris an Dá Chult�r 2 (1987) 67–87.
37. James Stewart, 'Topographia Hiberniae', Celtica 21 (1990) 642–657.
38. Michelle O'Riordan, The Gaelic mind and the collapse of the Gaelic world (Studies in Irish history) (Cork 1991).
39. Brendan Bradshaw, 'Geoffrey Keating: apologist of Irish Ireland', in: Brendan Bradshaw, Andrew Hadfield and Willy Maley (eds), Representing Ireland: literature and the origins of the conflict, 1534–1660, (Cambridge 1993) 166–190.
40. Michael Olden, 'Geoffrey Keating – Seathrún Céitinn: Tipperary priest and scholar, 1570–1649', in: Michael Hallinan (ed), Tipperary county: people and places: an anthology of the evolution of county Tipperary, some historical events and the history of the principal towns in the county (Dublin 1993) 14–22.
41. Marc Caball, 'Providence and exile in early seventeenth-century Ireland', in: Irish Historical Studies, 29 (1994) 174–188.
42. Michelle O'Riordan,'"Political" poems in the mid-seventeenth-century crisis', in: Jane H. Ohlmeyer (ed), Ireland from Independence to Occupation 1641–1660 (Cambridge: Cambridge University Press 1995) 112–27.
43. Mícheál Mac Craith, 'Creideamh agus athartha: idéeoloaíocht pholaitíochta agus aos léinn na Gaeilge i dthús an seachtú haois déag', in: Máirín Ní Dhonnchadha (ed), Nua-léamha: gnéithe de chultúr, stair agus polaitíocht na hÉireann, c1600–c1900 (Aspects of Irish Culture, History, and Politics) (Baile Átha Cliath/Dublin 1996) 7–19.
44. Bernadette Cunningham, 'Representations of king, parliament and the Irish people in Geoffrey Keating's Foras feasa ar Éirinn and John Lynch's Cambrensis eversus (1662)', in: Jane Ohlmyer (ed), Political thought in seventeenth-century Ireland, Cambridge 2000, 131–54.
45. Nicholas Canny (ed), Making Ireland British, 1580–1650 (Oxford 2001).
46. Bernadette Cunningham, The World of Geoffrey Keating. History, myth and religion in seventeenth century Ireland (Dublin 2000; paperback ed. 2004).
47. Bernadette Cunningham and Raymond Gillespie, Patrick Logan and 'Foras Feasa ar Éirinn', Éigse 32 (2000) 146–152.
48. Bernadette Cunningham, 'Geoffrey Keating's Foras Feasa ar Érinn', History Ireland, 9/1, 
Spring 2001.
49. Bernadette Cunningham, 'Geoffrey Keating's family connections', in: Tipperary Historical Journal (2002) 59–67.
50. David Berman & Alan Harrison, 'John Toland and Keating's History of Ireland', in: Donegal Annual 36 (1984) 25–29.
51. Marina Keating, 'Geoffrey Keating's Foras Feasa ar Eirinn: an exercise in historical preservation or historiographical production?' Galway: National University of Ireland, 2002. (M.A. Thesis (Minor) Dept of English).
52. Ray Cashman, 'Ethnohistorical Preservation and Persuasion in Foras Feasa ar Éirinn', in: New Hibernia Review 5.4 (2001) 147–152.
53. Alan Harrison, Ag Cruinniú Meala: Anthony Raymond (1625–1726), ministéir protastúnach agus léann na Gaeilge i mBaile Átha Cliath (Dublin 1988).
54. Katharine Simms, 'Bards and barons: the Anglo-Irish aristocracy and the native culture', in: Robert Bartlett and Angus Mackay (eds) Medieval frontier societies. Oxford (1989) 177–197.
55. Pádraig Ó Riain, 'The Psalter of Cashel: a preliminary list of contents', in: Éigse 23 (1989) 107–130.
56. Máire Ní Mhurchú & Diarmuid Breathnach (éag.), 1560–781 Beathaisnéis, uimhir a seacht, Leabhair Taighde, an 89ú Imleabhar (Baile Átha Cliath: An Clóchomar Teoranta 2001).
57. Joseph Francis Kukhta 'Sources for further Research: Michael Kearney: a missing link to the mysterious Geoffrey Keating?', Canadian Journal of Irish Studies 31/2 (Fall 2005) 50–53.
58. Edwards, David, 'A haven of popery: English Catholic migration to Ireland in the age of plantations', in: Alan Ford and John Mc Cafferty (eds), The origins of sectarianism in early modern Ireland (Cambridge: Cambridge University Press, 2005) 95–126.
59. Breandán Ó Buachalla, The Crown of Ireland (Galway 2006).
60. Bernadette Cunningham, O'Donnell histories: Donegal and the Annals of the Four Masters, (Rathmullan: Rathmullan & District Local History Society 2007).
61. Pádraig Ó Riain (ed), Geoffrey Keating: Reassessments, ITS, Subsidiary Series 19 (London 2008).
62. Beatrix Färber, 'Bedeutung und Rezeptionsgeschichte des 'Foras Feasa ar Éirinn', Zeitschrift für celtische Philologie 59 (2012) 97–118.
63. Beatrix Färber, Geoffrey Keating's Foras Feasa ar Éirinn in manuscripts, print and electronic edition, MPhil by Independent Research, School of History, University College Cork (2013).
64. Benjamin Hazard and Marc Caball (eds), 'A late seventeenth-century, partial English translation of the preface to Geoffrey Keating's Foras Feasa ar Eirinn, in Analecta Hibernica 44 (2013), 15-49.
65. Johannes Boemus (=Hans Böhm), 'Mores, leges, et ritus omnium gentium' (Augsburg 1520, often reprinted). [Mentioned by Keating p. 228, Bk 1. Haliday's and O'Mahony's reading 'Johannes Baronius' is incorrect.]
66. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
67. Colm Lennon, Primate Richard Creagh and the Beginnings of the Irish Counter-Reformation, Archivium Hibernicum 51 (1997) 74–86. [On the scholarly works of bishop Richard Creagh].
68. Aided Néill Nóigiallaig (The Death of Niall of the Nine Hostages), ed. by Kuno Meyer, Archiv für Celtische Lexikographie 3 (1907) 323–324 (text available online at CELT in file G302021). For another version of the same text, see Kuno Meyer, Otia Merseiana 2 (1900–1901), 84–92. (Text and English translation available online at CELT in files G302003 and T302003.)
**The edition used in the digital edition**2. The History of Ireland by Geoffrey Keating, D.D. . David Comyn (ed), Patrick S. Dinneen (ed), First edition [The first three of four volumes in the series.] David Nutt, for the Irish Texts SocietyLondon (1902–1914) . Irish Texts Society [Comann na Sgríbheann Gaedhilge]. , No. 4; 8 and 9

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text represents pages iii-xviii and 3-237 of vol. 1; 3-413 of vol. 2; 3-369 of vol. 3. Notes and indexes have been omitted; editorial corrigenda are integrated into the electronic edition. Missing text supplied by the editor is tagged *SUP*.


#### Editorial Declaration


##### Correction


Text has been checked and proofread twice (vol.3 three times) and parsed using NSGMLS. All regularizations are tagged. The History of Ireland is a large and complex work. Any corrections of errors in the original text, as edited by Comyn and Dinneen, or in this digital edition are welcome and will be credited to the scholars who submit them.


##### Normalization


The electronic text represents the edited text.


##### Quotation


Quotation marks are rendered q. Quotations taken from written works of reference, rendered qt, usually occur within cit tags. Where he says or the like occurs within a quotations from a written source, it is enclosed in round brackets.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break, the page-break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the history; div1=the book; div2=the section; div3=the subsection; paragraphs are marked; passages of verse occurring within paragraphs
are treated as embedded texts; the stanzas are marked lg; metrical lines are marked l. Page-breaks are marked pb n="nn".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Personal, collective and place names have not been tagged. Neither have social and professional roles. Obsolete names, however, have been supplied with the regularized form given in the editor's footnotes. Some
cultural terms of special importance mentioned in the text, like Leabhar Gabhála and the Lia Fáil, have been tagged. Titles of works/names of books mentioned by Keating have been tagged. Further encoding is envisaged in a future edition.


#### Canonical References


This text uses the DIV2 element to represent the Section. ### Profile Description


Created: Translated by David Comyn and Patrick S. Dinneen
 Date range: c. 1898-1908.#### Use of language


##### Language: [EN] The translation is in English.


##### Language: [GA] Some quotations, terms and phrases are in Irish.


##### Language: [LA] Some quotations, terms and phrases are in Latin.


##### Language: [GR] One term is in Greek (latinised).


### Revision History


* (2016-02-12) Beatrix Färber (ed.)

* Minor update made.
* (2015-10-01) Beatrix Färber (ed.)

* Correction made (missing translation added) in section 23, p. 237.
* (2014-07-11) Beatrix Färber (ed.)

* Content markup refined and revised to p. 336 of Book 2.
* (2014-04-30) Beatrix Färber (ed.)

* Markup of names (of persons, groups, places) refined and revised to p. 239 of Book 2; typos corrected; additions made to bibliographical details.
* (2012-10-15) Beatrix Färber (ed.)

* Additions to bibliography made.
* (2010-12-13) Beatrix Färber (ed.)

* Additions to bibliography made; new SGML and HTML files created.
* (2008-10-22) Beatrix Färber (ed.)

* Keywords added, file validated.
* (2008-07-23) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, content of 'langUsage' revised, minor changes to bibliography, encoding of titles in header and text revised.
* (2007-12-14) Beatrix Färber (ed.)

* Note inserted in header.
* (2007-12-10) Beatrix Färber (ed.)

* Typos in electronic file corrected, as noted by Dr R. Keatinge; new SGML and HTML files created.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T16:35:57+0100) Peter Flynn (ed.)

* Converted to XML
* (2002-06-19) Beatrix Färber (ed.)

* Minor changes to markup of quotations and header; vol. 3 appended to file; reparsed; HTML file created.
* (2002-03-20) Beatrix Färber (ed.)

* Vol. 3 parsed using NSGMLS.
* (2002-03-01) Marcos Balé (ed.)

* Third proofing of vol. 3.; markup of Irish terms and words.
* (2002-02-01) Ruth Murphy (ed.)

* Structural markup and proof corrections applied to vol. 3.
* (2001-08-25) Pádraig Bambury (ed.)

* First proofing and some structural markup applied to vol. 3.
* (2001-08-20) Pádraig Bambury (ed.)

* Vol. 3 scanned.
* (2002-03-06) Beatrix Färber (ed.)

* Minor changes to header; more proofing; vol. 2 appended to vol. 1; file parsed, HTML file created.
* (2002-02-28) Ruth Murphy (ed.)

* Second proofing of vol. 2.
* (2002-01-23) Benjamin Hazard (ed.)

* Structural markup of vol. 2 according to Irish version.
* (2001-13-07) Beatrix Färber (ed.)

* Header for vol. 2 created; markup of direct speech, quotations from written works and titles; Irish terms.
* (2001-15-05) Pádraig Bambury (ed.)

* First proofing and application of structural markup to vol. 2.
* (2001-08-05) Pádraig Bambury (ed.)

* Vol. 2 scanned; missing portions keyed in.
* (2001-06-07) Beatrix Färber (ed.)

* Second proofing of vol. 1; header created; structural markup completed; Latin quotes inserted; content markup applied. File parsed; HTML file created.
* (2001-05-05) Julianne Nyhan (ed.)

* First proofing of vol. 1; structural markup added.
* (2001-04-25) Julianne Nyhan (ed.)

* Vol. 1 scanned.




---


#### Corpus of Electronic Texts Edition: T100054


### The History of Ireland: Author: Geoffrey Keating




---

p.iii


### Editor's Preface


GEOFFREY KEATING stands alone among Gaelic writers: he has had neither precursor nor successor nor, in his own domain, either equal or second. His works show the fullest development of the language, and his historical treatise, with which we are here concerned, marks an epoch in our literature, a complete departure from the conventional usage of the annalists. From the last and greatest of these, even from his illustrious contemporaries the Four Masters, he is, in his style and mode of using his materials, as far removed as is Gibbon from earlier English writers on European affairs. The period, however, with which the English author deals is one for the history of which ample authentic materials existed, and nothing remained for the writer but to select and present the facts in his own style to the reader. But our author has to give an account of a country apart from the general development of European Civilisation, and to treat chiefly of remote ages without the support of contemporary documents or monuments. In this respect his field of inquiry resembles somewhat that of the portion of Dr. Liddell's work relating to the Kings and early Consuls of Rome, where the author, in a pleasing style, does his best with scanty and unsatisfactory materials, not altogether throwing aside, like the German critics, all data which cannot be confirmed by inscriptions or authentic records, yet skilfully exercising his discretion in the use of legend and tradition which had by earlier writers been received as trustworthy evidence.


It will be seen, in the course of this work, that Keating, though often accused of being weakly credulous, and though he was


---

p.iv



perhaps inclined to attach undue importance to records which he believed to be of extreme antiquity, while carrying on his narrative by their help (he had no other), yet shows as much discrimination as writers on the history of other countries in his time. He recounts the story, in his own happy manner, as it was handed down in annals and poems, leaving selection and criticism to come after, when they have a 'basis of knowledge' to work upon. By this term he accurately indicates the contents of his principal work, in which not merely history, but mythology, archaeology, geography, statistics, genealogy, bardic chronicles, ancient poetry, romance, and tradition are all made to subserve the purpose of his account of Ireland, and to increase the reader's interest in the subject. From his style and method, his freedom from artificial restraint and his extensive reading, it may well be conjectured that, but for the unhappy circumstances of our country, he might have been the founder of a modern native historical school in the Irish language, the medium employed by him in all his works. We may well be glad of his choice, and much is due to him for this good service. He might have written in Latin like his friend Dr. John Lynch, or Rev. Stephen White, or Philip O'Sullivan, his contemporaries, or like O Flaherty in the next generation; or in French, like the later Abbé Mac Geoghagan; or in English, like Charles O'Conor, and so many other vindicators of their country and her history. He was shut out from any opportunity of printing or publishing his work; but his own industry, and the devoted zeal of his literary friends and admirers who undertook the duty, secured its preservation.


Printing in Gaelic was then rare and difficult, especially in Ireland, but the reproduction of manuscripts was an honourable calling actively pursued, and the copies were so clearly and beautifully executed by professional scribes that the native reader was never so bereft of literature as the absence of printed books might suggest.


---

p.v




Keating's works are *veritably Irish uncontaminated by English phrases and written by a master of the language while it was yet a power,’’*

 as Dr. Atkinson puts it. His vocabulary is so full and varied that one of a translator's difficulties must be to find equivalents for what appear on the surface to be synonymous terms or merely redundant phrases: and though we may admit an occasional lapse into verbiage unpleasing to critics, yet his style has a charm of its own which quite escapes in any translation, and can only be fully appreciated by native readers, among whom his works have always enjoyed an unrivalled popularity; and, in a less degree, by sympathetic students of Gaelic. His wealth of reference and illustration too, the result of much wider reading than thought possible under his circumstances, gives zest to the perusal of his books, and enhances their interest for people accustomed to a fuller and more extended range of inquiry than our ancient annals afford. The general neglect Gaelic language and of Irish history for more than two centuries has hindered that careful and critical study of Dr. Keating's narrative, to which the works of writers of his period and standing have, in other countries, been subjected, whereby difficulties have been cleared up, errors corrected and hasty conclusions modified; while the books themselves, where they are not absolutely superseded as texts, have been in parts rewritten, and furnished with accessories to enable students of other generations to use and value them. All this has yet to be done for Keating.


‘To live is to change’, and the Irish language, like everything living, has changed, passing from what scholars know as 'old' Irish to 'middle' and 'modern' Irish. Modern begins with Keating, and his model has been followed the good writers of the seventeenth and eighteenth centuries, including O'Nachtan and O'Donlevy; and it still guides us, allowance being made for inevitable change, not more noticeable in Irish than in any other language cultivated 


---

p.vi




during the same period. Save where ancient documents are cited, there is in Keating's writings, to quote Dr. Atkinson again, scarcely a line which, at this day, *an Irish-speaking native will not at once get a grip of.’’*




The language used by our author is described by O'Curry as *the modified Gaedhlic of Keating's own time’’*

: which merely means that Keating elected to write in the living language, not (like the O'Clerys and Mac Firbis) continuing to employ forms long obsolete, and to copy strictly ancient models. O'Curry says further of Keating, whom he elsewhere calls *a most learned Gaedhlic scholar’’*

:—*Although he has used but little discrimination in his selections from old records, and has almost entirely neglected any critical examination of his authorities, still, his book is a valuable one, and not at all, in my opinion, the despicable production that it is often ignorantly said to be.’’*

 In another passage, however, O'Curry rather tones down this censure, and thus appreciates Keating:— *It is greatly to be regretted that a man so learned as Keating (one who had access, too, at some period of his life, to some valuable and ancient MSS. since lost) should not have had time to apply to his materials the rigid test of that criticism so necessary to the examination of ancient tales and traditions criticism which his learning and ability so well qualified him to undertake. As it is, however Keating's book is of great value to the student, ... so far as it contains at least a fair outline of our ancient history, and so far as regards the language in which it is written, which is regarded as a good specimen of the Gaedhlic of his time.’’*

 From O'Curry's standpoint, and taking into account the purpose of his work, we cannot expect a more favourable estimate.


But O'Donovan himself says of Keating's History of Ireland:— *This work, though much abused by modern writers, on account of some fables which the author has inserted, is, nevertheless, of great authority, and has been 


---

p.vii




drawn from the most genuine sources of Irish history, some of which have been since lost. ... The most valuable copy of it ... is now preserved in the Library of Trinity College, Dublin (H. 5. 26.). It is in the handwriting of John, son of Torna O'Mulconry, of the Ardchoill family, in the county of Clare, a most profound Irish scholar, and a contemporary of Keating.’’*


In his Literary History of Ireland, Dr. Douglas Hyde thus contrasts the O'Clerys and Keating:—*As if to emphasise the truth that they were only redacting the Annals of Ireland from the most ancient sources at their command, the Masters wrote in an ancient bardic dialect, full at once of such idioms and words as were unintelligible, even to the men of their own day, unless they had received a bardic training. In fact, they were learned men writing for the learned, and this work was one of the last efforts of the esprit de corps of the school-bred shanachy which always prompted him to keep bardic and historical learning a close monopoly amongst his own class. Keating was Michael O'Clery's contemporary, but he wrote—and I consider him the first Irish historian and trained scholar who did so—for the masses, not the classes, and he had his reward in the thousands of copies of his popular History made and read throughout all Ireland, while the copies made of the Annals were quite few in comparison, and after the end of the seventeenth century little read.’’*


Dr. Hyde further says: *What Keating found in the old vellums of the monasteries and the brehons, as they existed about the year 1630—they have, many of them, perished since—he rewrote and redacted in his own language, like another **Herodotus**. He invents nothing, embroiders little. What he does not find before him, he does not relate ... though he wrote currente calamo, and is in matters of fact less accurate than they [the Four Masters] are, yet his history is an independent compilation made from the same class of 


---

p.viii




ancient vellums, often from the very same books from which they also derived their information, and it must ever remain a co-ordinate authority to be consulted by historians along with them and the other annalists.’’*

 The lists of ancient books, given by Keating himself in the course of his work, afford ample evidence of this. The great annalists mentioned were more rigid in their conception of their duty, and more stiff in composition than some earlier Gaelic writers; the compilers of the Annals of Loch Cé, for instance, display a much freer treatment of their materials and an easier style. Indeed, the gradual modification of the language, and the development of good prose narrative form, to which in early times not much attention was given, may be traced from the Irish Nennius, in the twelfth century, through the Passions and Homilies of the Leabhar Breac, some of the Lives of the Book of Lismore and the Loch Cé Annals, to the translators of the Bible, to Carsuel, and to Keating when the evolution was complete. The various publications, chiefly religious, issued at Louvain, Rome, and Paris, during the seventeenth and eighteenth centuries by O'Molloy, O'Donlevy, and others, afford good examples of a similar style: and at home the sermons of Dr. O'Gallagher, and the writings of the O'Nachtans, and others, show that the language, while undergoing some inevitable modification, had still the same literary standard. To their influence, and to the efforts of humble scribes and teachers in Ireland it is due that, through the darkest period of our history, the native language, at least, was preserved uncontaminated and undegraded till the approach of better days; a marvellous fact when we consider the persecution, misery, and hardship the Irish-speaking people, for the most part, had then to endure.
The present will be the first complete edition of Keating's History. Outside the restricted circle of Irish scholars, nothing was known of the work, save through Dermod 


---

p.ix




O'Connor's unsatisfactory translation, published in 1723, and often reprinted, until, in 1811, William Haliday published a good text of the Díonbhrollach or vindicatory Introduction, and about one-fourth of the Foras feasa, the body of the historical work, with a readable translation, fairly conveying the author's meaning, but vague, and in parts too wide of the original to be useful. This book was never reprinted, and has become very rare. In 1857, John O'Mahony, a competent Irish scholar and native speaker of the language, published, in New York, a faithful translation of the entire work with copious and valuable notes in a large volume, now also rare. Dr. P. W. Joyce, in 1881, edited, for the use of students, the first part of the Foras feasa, with a close, almost word-for-word translation, and a vocabulary; and I have recently edited the Díonbhrollach for the same purpose. Both these texts, and the first volume of the present edition fall within the limits of Haliday's publication. I shall not, therefore, until my work is considerably advanced, have actually to break new ground; and, as I do not hesitate to make use of the work of my predecessors, it would be unfair not to admit this, and ungrateful not to acknowledge their assistance. More especially I have to thank Dr. Joyce for the use of his accurate transcript (made some years ago with a view to publication) of part of O'Mulconry's great manuscript of Keating, so highly prized by O'Donovan, Todd, and others, which has greatly helped the present volume. An unpublished Latin translation of Keating exists, by Dr. John Lynch: there is also an English translation much abridged, and rather vague and inaccurate, in manuscript (date about 1700); to this, perhaps, it is that Harris refers in his edition of Ware, and Haliday seems to allude to more than one. These and other very interesting points, on which I have a good deal of information most kindly furnished by friends, I shall refer to more fully in the concluding volume, to which I must also defer my own notes and comment on 


---

p.x




the text, my historical doubts and inquiries, and my further acknowledgments.


Dr. Joyce says:—*To publish text, translation, and annotations of old Keating—whom I revere and love—would be a great work, enough to place all Irishmen, present and future, under deep obligations to you. A grand ambition, enough to make a man's whole life pleasant and healthy.’’*

 I too can claim that I have always had a like deep veneration and affection for our good old author, and to do this work has been with me the desire and dream of half a lifetime: in fact, since I was first able to read the Irish language, and took part, now more than a quarter of a century ago, in the movement for its preservation. I even then hoped to have commenced this undertaking, but other matters, in themselves of minor interest, were more pressing needs for the time: now, however, the Irish Texts Society gives me the opportunity so long wished for; and from Dr. Hyde, the President, Miss Eleanor Hull, the Hon. Sec., my colleagues on the Committee, and other members and friends, I have received such encouragement and assistance, as give me hope that I may be able, under their auspices, to complete so great and useful a work.
As to Dr. Keating's other works, Dr. Atkinson's splendid edition, published by the Royal Irish Academy, in 1890, of the text of the Three Shafts of Death, a moral and philosophic treatise, with an exhaustive vocabulary, has been of great service in the preparation of the present volumes: and the text of An Explanatory Defence of the Mass has been issued by Mr. Patrick O'Brien, and is important and has been issued by Mr. Patrick O'Brien, and is important and useful. It was Keating's earliest work, and the language is simpler than in the other text named. These two texts, together with the present edition of the History, furnish an ample store of classical Gaelic prose, and to these works, since their first production, so far as they were known, everyone has been satisfied to appeal as to authoritative 


---

p.xi




standards. A valuable edition of Keating's poems has been lately issued by Rev. J. C. Mac Erlean, S.J., for the Gaelic League.


A sketch of the life of the author prefixed to Halidays edition of Keating, has been in part reprinted by Mr O'Brien: O'Mahony also wrote a life for his translation; and other brief narratives have been published, though authentic materials are scanty. A full biography of Keating, however, with an account of the time in which he lived and the conditions under which he worked, is still a desideratum for the numerous and increasing class who now feel interest in him, his work, and his language.


I must content myself with a few approximate dates. Neither the year of his birth nor of his death is exactly known; but between 1570 and 1650 may be assumed as his period. He was born at Burges, and is buried at Tubrid, both in Co. Tipperary, and distant only a few miles. He was educated at Bordeaux, and returned to Ireland about 1610. His first known work, the treatise on the Mass, was written about 1615; though there is in the Franciscan MSS. a small religious tract, attributed to him, which may be of earlier date, as also some of his poems. The Three Shafts of Death was written about 1625, and the History was completed about 1634, certainly before 1640. In 1644 he built the little church of Tubrid in which he is interred, though the exact spot is not known.


From D'Arcy McGee's position in literature, an opinion from him on Keating's History of Ireland is of some interest. He writes:— *It is a semi-bardic and semi-historic work. It is full of faith in legends and trust in traditions. But its author has invented nothing. If it contain improbabilities or absurdities, they are not of his creation. He had gathered from manuscripts, now dispersed or almost unknown, strange facts wildly put, which jar upon our sense as downright fictions. They are not such. Ignorance has criticised 


---

p.xii




what it knew not of, and condemned accounts which it had never examined. Hence Keating's name has grown to be almost synonymous with credulity. He may have been to blame for giving us the statements and traditions which he found in their old age dwelling in the hearts of the people, but we must remember that the philosophic or sceptic era in history had not then set in. The school of Machiavelli had not yet superseded that of **Herodotus**.’’*


Hardiman, who was a first-rate Irish scholar, and familiar with the original, writes thus of Keating's work:—*Our Irish Herodotus was both a poet and an historian. Indeed the flowery style of his Foras Feasa ar Éirinn or History of Ireland, shows that he must have paid early and sedulous court to the muses; and, that he was rewarded for his attentions, appears from the pleasing poems which he has left behind. ... As an historian and antiquary, he has acquired much celebrity for profound knowledge of the antiquities of his country, vir multiplicis lectionis in patriis antiquitatibus ... It is an irreparable loss to Irish history that he did not continue his work. ... Of all men, he was best qualified to give a true domestic picture of this country, from a knowledge of its civil affairs, manners, customs, poetry, music, architecture, &c., seldom equalled and never surpassed; besides his intimate acquaintance with many ancient MSS. extant in his time, but since dispersed or destroyed. The English edition by which his history, so far as it extends, is known to the world, is a burlesque on translation. In innumerable passages it is as much a version of Geoffrey of Monmouth as of Geoffrey Keating.’’*


Dr. Todd says: *O'Mahony's translation, (before referred to), is a great improvement upon the ignorant and dishonest one published by Mr. Dermod O'Connor ... which has so unjustly lowered in public estimation the character of Keating as a historian; but O'Mahony's translation has been taken from a very imperfect text, and has evidently been 


---

p.xiii




executed, as he himself confesses, in great haste; it has, therefore, by no means superseded a new and scholarlike translation of Keating, which is greatly wanted. Keating's authorities are still almost all accessible to us, and should be collated for the correction of his text; and two excellent MS. copies of the original Irish, by John Torna O'Mulconry, a contemporary of Keating, are now in the Library of Trinity College, Dublin.’’*

 Though I may not hope to do all that the learned writer here quoted lays down, or to rival his own scholarlike edition of the War of the Gael with the Gall, from which this passage is cited, I shall be well pleased if I do not fall greatly short of O'Mahony's mark, whose work has done so much to rehabilitate our author in the opinion of those who have to depend on a translation. His best vindication, however, will be the publication of an authoritative text of his complete work, based on the MSS. named by Dr. Todd, and others at least equally authentic, carefully edited and revised, and printed with the accuracy and style which have characterised the Press of his University since Dr. O'Donovan's Four Masters was produced there, fifty years ago.
A few words will be in place here concerning the authorities for the text of the present volume. The chief are:—


I.—A MS., believed to be in the handwriting of the author, most accurate and valuable, now in the Franciscan Convent Library, Dublin. This volume is stated to have been written in the convent of Kildare, and is shown by another entry to have belonged to the famous convent of Donegal, whence it was transferred to Louvain, where it was included among Colgan's collection, thence conveyed to Rome, and ultimately restored to Ireland some twenty-eight years ago. Its date unfortunately is not traceable, but in all probability it is the oldest existing transcript of Keating's History and written before 1640. This manuscript will be cited in this edition as F. There is another important 


---

p.xiv




Keating MS. in the same collection, a copy made, as appears from entries, before 1652, which I have consulted occasionally. These manuscripts were not known to Dr. O'Donovan. The first is referred to in Sir John T. Gilbert's catalogue, on the authority of a list made in 1732, as an autograph: but I see no evidence of the date 1636, which some scholars have assigned for one of these manuscripts. I have to return thanks to the learned librarian, Rev. Father O'Reilly, and the Franciscan Fathers for access to their unique collection, and for much information given me and trouble taken on my behalf.


II.—MS. H. 5, 26, by O'Mulconry, referred to in this edition as C, with the aid of Dr. Joyce's transcript, and printed edition of part of same, compared, in doubtful and difficult passages, and to supply omissions, with MS. H. 5, 32; both in Trinity College, Dublin, being Nos. 1397 and 1403 in the printed catalogue. I have to express my thanks to the authorities of Trinity College for permission to use the University Library, and to the Library officers for their courtesy and kindness.


III.—Haliday's text, stated to have been printed from a MS. also by O'Mulconry, dated 1657, but differing considerably in places from those named.


IV.—The next is an older MS., dated 1643, in my own possession, unfortunately in bad preservation, but still legible for the body of the work, written by James O'Mulconry, of Ballymecuda, in the county of Clare. These two authorities will be referred to in this edition as H, and M, respectively.


By the letter N, I shall indicate a MS., also my own, written in Dublin by Teig O'Nachtan, and dated 1704, with which has been carefully compared a copy made in 1708 by Hugh Mac Curtin, and various readings noted. This I have occasionally consulted, and found to be a very useful text. All the writers named were well-known Irish scholars. I have, besides, a transcript made by Peter O'Dornin, the Gaelic Poet, in 1750; another, dated 1744, and written in a 


---

p.xv




very good hand; and others: but of these I have made no special use.


I shall note at the foot of each page, for the present, only such various readings as appear to me to be important. Space, after all, is an object, and the whole volume might easily be filled with matter which would be little help, but rather a distraction, to the reader. The author himself is believed to have made several transcripts of his work; and to have inserted from time to time, passages or quotations relating to the events recorded. In this way there is some inevitable discrepancy between the best manuscripts. I have followed, in the main, the recension of the O'Mulconrys, adhered to strictly by Dr. Joyce, and which is also the basis of Haliday's text. I have not modernized their system of inflection, or altered the orthography, save in certain mannerisms, which I have not felt bound to adopt. It is probable that this family of professional scribes and antiquaries would have adhered more rigidly than Keating himself to classic but obsolescent usages. In fact, the important MS. cited as F, prefers living forms such as tugadar where C has tugsad, &c. The authentic copies differ occasionally from each other, and where I have had to choose between them, or prefer another authority, the ancillary manuscript and other sources from which omissions have been supplied and various readings drawn, will be indicated wherever necessary. The MSS., here and there, retain antiquated forms of spelling from which I have felt at liberty to depart when their use in other places of more modern forms gives sanction to the innovation. Thus, for instance, O'Mulconry uses the obsolete doridisi and aridhisi almost side by side with the living arís. The latter I have uniformly adopted, as it exists in texts much older than Keating's time, such as the Homilies in the Leabhar Breac: and so I have, where authority was equal, endeavoured to attain uniformity of spelling, and given the preference to 


---

p.xvi




the simplest forms and those still in living use. No substitution of words has, however, been admitted, and there is over the whole text a slightly archaic flavour, not too unfamiliar, and by no means unpleasing, but such as a great classic work in any other living tongue presents to readers three centuries later than its author.


I have endeavoured to prepare a closely literal translation, though not actually word for word: thus, while not unreadable, it will aid students in the better understanding of the text, to which object it is entirely subsidiary: no attempt being made to draw away the reader's attention from the plain meaning of the author, by a sophisticated version for the sake of superficial correctness or elegance of style. Any such considerations must give place to the necessity for the study and understanding of Keating's text by the native reader and the Gaelic student, who will be alike unwilling to substitute any translation, however successful, for the original language of this standard work. This view has also guided me in the forms of personal and place names in the translation. I should prefer to retain the correct spelling in every instance, especially when so many are now studying the language and becoming familiarized with its phonetics: however, in the case of some very familiar names, I have adopted no hard and fast rule, but wherever I follow the usual corrupt spelling, I point out the correct Irish form also. The few foot-notes, here and there, on the translation, must of necessity be brief: but I hope, later, to give a full Index, and, for the present, will merely indicate, in loco, the place or person alluded to, where this may be necessary, or not obvious from the context.


The Latin quotations used by Keating are here relegated to the margin to avoid disturbing the continuity of the text, and distracting the reader's attention. In each case our author gives the Gaelic equivalent, and from this the English translation has been made. A letter will indicate the reference 


---

p.xvii




at the foot, and, in the case of the notes to the present volume, which are chiefly 'various readings', the number of the line to which they refer will be given, and so the appearance of our text, which is of some importance, will not be marred by the insertion of too many figures.


Not only among the *strange facts wildly put’’*

, and the traditions gathered by Keating, but also in the more authentic portions of his narrative, there will be found recorded occurrences which may offend certain readers who would fain judge every age and people by the standards of modern European civilization; or, rather, by their own narrow experience and reading, and their ill-informed prepossessions. Persons whose susceptibilities are so easily shocked, and who cherish their convictions so tenderly, have no business studying the history of human progress in ancient times, or during the middle ages, or among people who have developed under special conditions; or, indeed, any subject outside of the commonplace.
Among the many writers who have censured Geoffrey Keating's work and method, as the introduction to Haliday points out, Roderick O'Flaherty, at least, had a sufficient knowledge of the language and the subject: but, without this title to a hearing, Isaac Disraeli presumes to denounce Keating and O'Flaherty, alike, in the most sweeping manner, among the various literary cranks and humbugs whom he criticises. We need not wonder, therefore, though we may regret, that Thomas Moore, in his History of Ireland, speaks slightingly of Keating, whose text he could not read, but there is reason to believe that Moore subsequently recognised the need of acquaintance with the native records; as it is well known that he expressed to O'Curry and Petrie his conviction, that without this knowledge he should not have undertaken to write a History of Ireland, a work, now, in its turn, notwithstanding its fascinating style, almost as much neglected as, and of far less value than, either Keating or O'Flaherty.




---

p.xviii


Our author concludes his vindicatory introduction by affirming that if there be anything in his history inviting censure, it is there not from evil intent but from want knowledge or ability. Being a descendant of the old foreign settlers, Keating cannot be said to have inherited a prejudice in favour of the native Irish; and his testimony on their behalf, as he himself argues, ought on that account to be the more readily received. While indignantly refuting the calumnies of ignorance and malice, his honesty of purpose is yet such as impels him to relate some strange facts which his keenly sensitive regard for his country's honour must have induced him to wish could be related differently. But not less is this the case with the native annalists of Ireland. Having had the advantage of writing their own history, for their own people, in their own language, they did not attempt to make the facts bend to preconceived theories, but, to the best of their ability and according to their lights, they delivered the stories as they found them, not condescending to pander to any mistaken patriotic zeal, or to insert and omit with a purpose in view, and so colour their narrative as to place the ancestors before their own fellow-countrymen and the world in any better light than they felt was warranted by the authorities available. Though occasionally vain-glorious, and by no means free from clan predilections, they do not conceal faults or errors, or extenuate crimes: they are, in general, too candid. In this way the ancient history of Ireland often appears to the modern reader at a disadvantage, compared with the nicely adjusted narratives told by historians of remote times in other countries.


In closing these remarks I have to express my great regret at the delay in the publication of this annual volume owing to unforeseen difficulties and unavoidable interruptions.
DAVID COMYN.
  
43, BRIGHTON-SQUARE, RATHGAR, DUBLIN,


1st October, 1901.


---

p.3


Introduction. The Author to the Reader.
---------------------------------------

I.
--


WHOSOEVER proposes to trace and follow up the ancient history and origin of an country ought to determine on setting down plainly the method which reveals most clearly the truth of the state of the country, and the condition of the people who inhabit it: and forasmuch as I have undertaken to investigate the groundwork of Irish historical knowledge, I have thought at the outset of deploring some part of her affliction and of her unequal contest; especially the unfairness which continues to be practised on her inhabitants, alike the old foreigners who are in possession more than four hundred years from the Norman invasion down, as well as the native Irish who have had possession during almost three thousand years. For there is no historian of all those who have written on Ireland from that epoch that has not continuously sought to cast reproach and blame both on the old foreign settlers and on the native Irish.


Whereof the testimony given by Cambrensis, Spenser,


---

p.5




Stanihurst, **Hanmer**, Camden, Barckly, Moryson, Davies, Campion, and every other new foreigner who has written on Ireland from that time, may bear witness; inasmuch as it is almost according to the fashion of the beetle they act, when writing concerning the Irish. For it is the fashion of the beetle, when it lifts its head in the summertime, to go about fluttering, and not to stoop towards any delicate flower that may be in the field, or any blossom in the garden, though they be all roses or lilies, but it keeps bustling about until it meets with dung of horse or cow, and proceeds to roll itself therein. Thus it is with the set above-named; they have displayed no inclination to treat of the virtues or good qualities of the nobles among the old foreigners and the native Irish who then dwelt in Ireland; such as to write on their valour and on their piety, on the number of abbeys they had founded, and what land and endowments for worship they had bestowed on them; on the privileges they had granted to the learned professors of Ireland, and all the reverence they manifested towards churchmen and prelates: on every immunity they secured for their sages, and the maintenance they provided for the poor and for orphans; on each donation they were wont to bestow on the learned and on petitioners, and on the extent of their hospitality to guests, insomuch that it cannot truthfully be said that there ever existed in Europe folk who surpassed them, in their own time, in generosity or in hospitality according to their ability. Bear witness the literary assemblies which were proclaimed by them, a custom not heard of among any other people in Europe, so that the stress of generosity and hospitality among the old foreigners and the native Irish of Ireland was such that they did not


---

p.7




deem it sufficient to give to any who should come seeking relief, but issued a general invitation summoning them, in order to bestow valuable gifts and treasure on them. However, nothing of all this is described in the works of the present-day foreigners, but they take notice of the ways of inferiors and wretched little hags, ignoring the worthy actions of the gentry: yet as far as regards the old Irish, who were inhabiting this island before the Norman invasion, let it appear whether there has been in Europe any people more valiant than they, contending with the Romans for the defence of Scotland. For they compelled the Britons to make a dyke between their portion of Britain and Scotland, to protect (Roman) Britain from the incursion of the Irish; and notwithstanding that there were usually fifty-two thousand of a Roman army defending the dyke, and two hundred (scouts) riding about, and twenty-three thousand foot and thirteen hundred horse with them (besides), defending the frontier and harbours of the country against the violent attacks of the Scots and of the Picts; yet, with all that, the Irish would burst over the dyke, and the country would be harried by them, despite these great hosts, according to Samuel Daniel in his chronicle. Cormac, son of Cuileannan, says also in his Saltair, that, as a result of the violence of the Irish (or Scots) and of the Crutheni (who are called Picts) against Britain, the Britons three times conspired against the Roman governors set over them, as a means of purchasing peace with the Scots and Picts. Observe, moreover, the straits in which the Irish had placed the Britons whilst Vortigern was king over them, whence it arose that he subsidised Hengist, with his German


---

p.9




host, as may be read in Geoffrey of Monmouth. It is stated by Samuel Daniel that the Romans had fourteen garrisons to oppose the Scots and Picts, and that the Scots and Picts kept disturbing Britain, despite the Romans, from the time of **Julius Caesar** to that of the **Emperor Valentinian the Third**, during the space of five hundred years; and the year of the Lord was four hundred and forty-seven when the Romans abandoned the suzerainty of Britain: and it is before that epoch a dispute arose between Theodosius and Maximus, whence it resulted that Maximus led with him a great body of the people of Britain to [French] Armorica, which is called [little] Brittany, and having banished the people who were before them in the land, he gave the country to the company who went with him to inhabit, so that some of their posterity are still there.


II.
---


There are some ancient authors who lay lying charges against the Irish; such as **Strabo**, who says in his fourth book that the Irish are a man-eating people. My answer to **Strabo** is, that it is a lie for him to say that the Irish are a people who eat human flesh; for it is not read in the ancient record that there was ever one in Ireland who used to eat human flesh, but Eithne the loathsome, daughter of Criomhthann, son of Eanna Cinnsiolach, king of Leinster, who was in fosterage with the Deisi of Munster: and she was reared by them on the flesh of children, in hope that thereby she would be the sooner marriageable. For it had been promised to them that they should receive land from the man to whom


---

p.11




she would be married; and it is to Aonghus, son of Nadfraoch, king of Munster, she was married, as we shall relate hereafter in the body of the history. Understand, reader, since the antiquaries do not suppress this disgusting fact, which was a reproach to the daughter of a king of Leinster, and the wife of a king of Munster, that they would not conceal, without recounting it in the case of lesser people than they, if it had been a custom practised in Ireland: wherefore it is false for **Strabo** to say that it was a custom for the Irish to eat human flesh, since this was never done among them but by the aforesaid girl, and even that in time of paganism. My answer also to St. Jerome, who relates this same thing, writing against Jovinian, is that it must have been a base asserter of lies who informed him, and therefore it ought not be brought as a charge against the Irish.


Solinus, in the twenty-first chapter, says that there are no bees in Ireland; and he says, that it is from the point of a sword the first bit is tasted by a male child in Ireland. He says, moreover, that the Irishman is wont, when his enemy is slain by him, to bathe himself in the blood. It is clear from the ancient record, which will be (found) in the history, that every one of these things is false. Pomponius Mela, in the third book, says these words, speaking of the Irish, *a people ignorant of all the virtues {Omnium virtutum ignari}’’*

: and so of many other ancient foreign authors who wrote rashly without evidence concerning Ireland, on the lying statements of false witnesses, whom it would not be right to trust in such a matter: wherefore Camden, setting down the testimony of these people concerning Ireland, says these words: *We have not (says he)


---

p.13




credible witness of these things. {Horum quae commemoramus, dignos fide testes non habemus.}’’* It is clear that it is false to say that there were not bees in Ireland, according to the same Camden, where he says, speaking of Ireland: *Such is the quantity of bees there, that it is not alone in apiaries or in hives they are found, but (also) in trunks of trees, and in holes of the ground.{Apum est tanta multitudo, ut non solum in alveariis sed etiam in arborum truncis et terrae cavernis reperiantur.}’’*
III.
----


We shall set down here a few of the lies of the new foreigners who have written concerning Ireland, following Cambrensis; and shall make a beginning by refuting Cambrensis himself where he says that Ireland owed tribute to King Arthur, and that the time when he imposed the tax on them at Caerleon was, when the year of the Lord was five hundred and nineteen, as Campion sets forth in his chronicle in the second chapter of the second book, where he says that Gillamar was then king of Ireland. Howbeit, notwithstanding that (the author of) Polychronicon, and (Geoffrey of) Monmouth, and others of the new foreigners assert this Gillamar to have been king of Ireland, I defy any of their followers (to show) that there is a lay or a letter from the ancient record of Ireland in which there is mention or account of Gillamar having ever been king of Ireland: unless it be to Muircheartach the Great, son of Earc, they call it, who was king of Ireland, and was a contemporary of King Arthur; and Muircheartach could not have been tributary to King Arthur, because, that he himself was mighty in Ireland and in Scotland, and that it was he who sent his six brothers into Scotland, and that it was one of them became the first king 


---

p.15




of the Scotic race in Scotland, namely, Feargus the Great, son of Earc; and moreover, that it was by the Scots and the Picts King Arthur himself was slain. This Feargus, whom I have mentioned, was the first king of Scotland of the Scotic race: for, notwithstanding that **Hector Boetius**, in his history of Scotland, enumerates thirty-nine kings tohave ruled over Scotland before this Feargus, yet, according to the ancient record, there was not any king of the Scotic race in Scotland before him: and it is not true for him where he says that it is Feargus, son of Fearchar, king of Ireland, who was the first king of Scotland of the Scotic race, for there never was a king of Ireland named Fearchar, and so Feargus, son of Fearchar, was not king of Scotland, as **Hector Boetius** says: and, granted that Muircheartach the Great wished his brother Feargus (son of Earc) to become king of Scotland, yet, withal, the title which is given to Muircheartach himself in the annals of Ireland, is 'King of Scots', to signify that he had supremacy over the Scots, both in Ireland and in Scotland; and it is not conceivable that he, who was in so much power, should have been tributary to King Arthur. And, moreover, Speed says in his chronicle, that it was not tribute King Arthur had from the king of Ireland, but an alliance of friendship in war, so that whichever of them should be attacked by enemies, it was obligatory on the other party to send an auxiliary force to him who should be attacked: and the name Speed calls this co-operation is *mutual obligation of war, {Jus belli socialis}’’*

 such as exists between the king of Spain and the Emperor; for each of these sends aid in time of need to the other, and it is not to be understood from this that the Emperor is tributary to the king of Spain, or the king of Spain to the Emperor. In like manner, if there existed a close alliance of


---

p.17




war between King Arthur and Muircheartach, son of Earc, king of Ireland, so that they were accustomed to aid each other whenever an attack was made on either of them, it must not be thence inferred that either was tributary to the other. The truth of this matter is still more to be understood from what (William of) Newbury says in the twenty-sixth chapter of the second book of his history, where he speaks of Ireland: here is what he says:— *Ireland never lay under foreign dominion. {Hibernia nunquam subiacuit externae ditioni.}’’* Cambrensis himself corroborates this matter in his twenty-sixth chapter, where he says:— *From the first, Ireland has remained free from the invasion of any foreign nation. {Hibernia ab initio ab omni alienarum gentium incursu libera permansit.}’’* From these words it is evident that neither Arthur, nor any other foreign potentate, ever had supremacy over Ireland from the beginning till the Norman invasion: and, moreover, it is not conceivable that the Britons had any control over Ireland, since even the Romans did not venture to meddle with it, and it is not alone that the Romans, or other foreigners, had no control over Ireland, but it is Ireland that was a refuge to the other territories to protect them from the violence of the Romans and other foreigners.
Here we may see how Camden corroborates this in the book called Camden's 'Britannia', where he says:—*When the Romans had widely extended their dominion, there came, without doubt, many hither (speaking of Ireland) from Spain, from France, and from Britain, in order to extricate their necks from the most grievous yoke of the Romans. {Cum suum Romani imperium undique propagassent, multi, procul dubio, ex Hispania, Gallia, et Britannia hic se receperunt, ut iniquissimo Romanorum iugo, colla subducerunt.}’’*

 From this it may be understood that it is not alone that the Romans did not come to Ireland, but even that it is there the people


---

p.19




of other countries were protected from the Romans. Here also is what the same Camden says, refuting the folk who say, according to (their) opinion, that the Romans had power over Ireland:— *I should find it difficult to persuade myself that Ireland had ever been under the authority of the Romans. {Ego animum vix inducere possum ut hanc regionem in Romanorum potestatem ullo tempore concessisse credam.}’’*
Cambrensis says, in his ninth chapter, that in Ireland the men used to marry the wives who had been married to their brothers, upon the death of their brothers: and he says that the tithe used not to be paid in Ireland, and that there was no regard for marriage there till the coming of Cardinal John Papiron; this, however, is not true for him, as we shall prove in the body of the history, and as will be evident from this same introduction shortly hereafter. He says, in his seventh chapter, where he treats of the wonders of Ireland, that there is a well in Munster which presently makes a man grey when he washes his hair or his beard in its water, and that there is likewise a well in Ulster which prevents greyness. Howbeit, there are not the like of these wells in Ireland now, and I do not think there were in the time of Cambrensis, but these wonders were (merely) set forth as a colouring for his lies.


Cambrensis says, in his twenty-second chapter, that whenever the nobles of Ireland are making a compact with each other, in presence of a bishop, they kiss at that time a relic of some saint, and that they drink each others blood, and at that same time they are ready to perpetrate any treachery on each other. My answer to him here (is), that there is not a lay nor a letter, of old record or of ancient text, chronicle or annals, supporting him in this lie: and, moreover, it is evident that it was obligatory on the antiquaries not to 


---

p.21




conceal the like of this evil custom, and even to put it in (their) manuscript on pain of losing their professorship, if it had been practised in Ireland. Wherefore it is clear that it is a lie Cambrensis has uttered here. Cambrensis says, in his tenth chapter, that the Irish are an inhospitable nation here is what he says:— *Moreover, this nation is an inhospitable nation {Est autem gens haec, gens inhospita.}’’*

 (says he). However, I think Stanihurst sufficient in his history by way of reply to him in this matter; here is what he says, speaking of the generosity of the Irish:—*Verily (he says), they are a most hospitable people; and there is no greater degree in which you may earn their gratitude, than freely, and of your own will, to make your resort to their houses. {Sunt sane homines hospitalissimi, neque illis ulla in re magis gratificari potes, quam vel sponte ac voluntate eorum domos frequentare.}’’* Hence it may be inferred, without leave of Cambrensis, that they are hospitable people, (and) truly generous in regard to food. Cambrensis says, where he writes concerning Ireland, that it was the wife of the king of Meath who eloped with Diarmuid of the foreigners; yet this is not true for him, but she was the wife of Tighearnan O'Ruairc, king of Brefny, and daughter to Murchadh, son of Flann, son of Maoilseachlainn, king of Meath, and Dearbhforgaill was her name. He says, moreover, that it is from Sliev Bloom the Suir, Nore, and Barrow take their rise, though that is not true for him, for it is clear that it is from the brow of Sliev Bloom, on the east side, the Barrow springs, and that it is from the brow of Sliev Aldun, which is called the mountain of the Gap in Ikerrin, the Suir and the Nore rise.
Again, he says, in the twenty-fifth chapter of his narration concerning Ireland, that the king of Cinéal Conaill, i.e.


---

p.23




O'Donnell, used to be inaugurated in this wise: an assembly being made of the people of his country on a high hill in his territory, a white mare being slain, and being put to boil in a large pot in the centre of the field, and, on her being boiled, he to drink up her broth like a hound or a beagle with his mouth, and to eat the flesh out of his hands without having a knife or any instrument for cutting it, and that he would divide the rest of the flesh among the assembly, and then bathe himself in the broth. It is manifest that this thing Cambrensis tells is false, according to the ancient record of Ireland, for it is thus it describes the mode in which O'Donnell was proclaimed, to wit, by his being seated in the midst of the nobles and of the council of his own territory; and a chief of the nobility of his district used to stand before him with a straight white wand in his hand, and on presenting it to the king of Cinéal Conaill, it is this he would say to him, to receive the headship of his own country, and to maintain right and equity between each division of his country: and, wherefore the wand was appointed to be straight and white, was to remind him that so ought he to be just in his administration, and pure and upright in his actions. I marvel at Cambrensis reporting this lie, and I conceive that it was through malice he inserted it in his work. For it is well known that they have been at all times devout and religious people; and that many of them forsook the world, and finished their lives under religious rule, and, moreover, that from them came many saints, such as Columcille, Baoithin, Adhamnan, and many other saints whom we shall not mention here. Besides, it is not credible that the nobility of Ireland would permit the king of Cinéal Conaill to have in use that barbarous custom 


---

p.25




which Cambrensis mentions, seeing that the Catholic religion has lived among them from the time of Patrick to the Norman invasion, and, accordingly, I consider that it is a malicious unwarranted lie Cambrensis has uttered here.


IV.
---


Spenser, in his narrative, says that Egfrid, king of the Northumbrians, and Edgar, king of Britain, had authority over Ireland, as may be read in the thirty-third page of his history: yet this is not true for him, because the old records of Ireland are opposed to that, and, moreover, British authors themselves confess that the Saxons did not leave them any ancient texts, or monuments, by which they might know the condition of the time which preceded the Saxons. For Gildas, an ancient British author says, that the monuments, and consequently the history of the Britons, were destroyed by the Romans and by the Saxons. Samuel Daniel, in the first part of his chronicle, agrees with this author on the same matter, and Rider, in the Latin dictionary he wrote, where he treats of this word Britannia; moreover he says, that it is not from Brutus Britain is called Britannia, and, if it were, that it should be Brutia or Brutica it should be called; and it were likely, if it had been from Brutus it was named, that **Julius Caesar**, **Cornelius Tacitus**, Diodorus Siculus, or Bede, or some other ancient author would have stated whence is this word Britannia; and since they knew not whence is the name of their own country, it was no wonder they should be in ignorance of many of the ancient concerns of Britain, and, therefore, it is not strange that Spenser likewise should be ignorant of them.


It is a marvellous thing Spenser took in hand to trace up


---

p.27




antiquity concerning some of the nobles of Ireland, and to assert that they are foreigners in regard to their origin. Seven surnames, in especial, of the nobles of the Gael are mentioned by him, to wit, Mac Mahon, Mac Sweeny, Mac Sheehy, Macnamara, Cavanagh, Toole, and Byrne. He says that it is from Ursula (or Fitz Urse, a surname which is in England) Mac Mahon is derived, and that 'ursula' and 'bear' are equal, and that 'bear' and 'mahon' are alike (in meaning), and, accordingly, that it is from that house Mac Mahon of Ulster came. My answer to this reasoning is, that it is not more probable that Mac Mahon of Oriel should have come from that house, in such fashion, according to the derivation of the word, than Mac Mahon of Thomond, or O'Mahony of Carbry, and as neither of these is from the house of Fitz Urse, or Bear, in England, neither is Mac Mahon of Ulster: but truly he is of the posterity of Colla-dá-Chríoch, son of Eochaidh Doimhléan, son of Fiachadh Sraibhtheine, son of Cairbre Lifeachar of the race of Eireamhón. The second race, the Mac Sweenys, he says that it is from a house in England which is called 'Swyn', they have come; howbeit, 'Swyn' and 'Sweeny' are not equal, and, accordingly it is not from that house Mac Sweeny has sprung, but truly he is of the race of Niall: for it is from the posterity of Aodh Athlamh son of Flaithbheartach of the pilgrim-staff Mac Sweeny comes. He also says that the Mac Sheehys are of the foreigners; however, that is not true, for it is known that they are of the posterity of Colla Uais, and that they have sprung from Sitheach, son of Eachdunn, son of Alastar, son of Dómhnall, from whom are named the Mac Donnells of Ireland and Scotland. Again he says that the Macnamaras


---

p.29




are of the foreigners, and that they came from a family of the Normans called Mortimer; however, that is not true, for it is from a person named Cúmara they are called children of Cúmara: the proper surname for them is the race of Aodh, and it is from Caisin, son of Cas, son of Conall of the swift steeds, of the race of Eibhear, they are derived, as may be read in the genealogical account of the Dal Cas. He states, likewise, that it is from Great Britain came these three following surnames, Byrne, Toole, and Cavanagh; and the proof which he offers for this statement is unreliable, where he says that these three words are British words. First, he says that 'brin' and 'woody' are alike (in meaning); I allow that 'brin' and 'woody' are the same, yet it is not from this word 'brin' the Byrnes are called, but from the name of a young warrior called Brannút. Secondly, he says that 'tol' and 'hilly' are alike, and that it is from it the Tooles are named; I allow that 'tol' and 'hilly' are equal, yet 'tol' and 'Tuathal' are not like each other, for it is from the name of a warrior called Tuathal they are (called): wherefore the opinion of Spenser is false. Once again he says that 'caomhan' and 'strong' are alike, and that it is from it the Cavanaghs are named. My answer to him is, that 'caomhan' is the same as a 'mild' or pleasant person, and that the Cavanaghs were so named from Dómhnall Caomhanach, son of Diarmuid of the foreigners. The epithet adhered to Domhnall himself from his having been nurtured in Kilcavan, in the lower part of Leinster; and it is from the Kinsellachs they are by descent. Moreover, it is manifest, according to genuine record, that these three


---

p.31




peoples are of the Gael, and that these three surnames are of the posterity of Fiachadh Aiceadh, son of Cathaoir the Great, king of Leinster, as may be read in the genealogical account of Leinster. I am surprised how Spenser ventured to meddle in these matters, of which he was ignorant, unless that, on the score of being a poet, he allowed himself license of invention, as it was usual with him, and others like him, to frame and arrange many poetic romances with sweet-sounding words to deceive the reader.


V.
--


Stanihurst asserts that Meath was the allotted portion of Slainghe, son of Deala, son of Loch; howbeit, that is not true for him. For, according to the Book of Invasion, there was of Meath, in Slainghes time, but one district of land only, which lies hard by Usna, (and so) till the time of Tuathal the Welcome: and where he says that it is from Slainghe the town of Slane is called, and, consequently, that Meath was the allotted share which came to him from his brothers, it is not more reasonable to suppose that it was his share than to suppose that it was the province of Leinster that was allotted to him, and that it is from him is named Inver Slaney which flows through the midst of Leinster to Lochgarman (or Wexford); and that it is from him is named Dumha Slainghe, otherwise called Dionnriogh, on the bank of the Barrow, between Carlow and Leighlin, on the west side of the Barrow, and that it was his fortified residence, and that it was there he died.




---

p.33


It is no marvel that Stanihurst should be without knowledge of this matter, since he had never seen the records of Ireland, from which he might have known her previous condition; and I fancy he did not make any great inquiry after them, since he is so ignorant about Irish affairs that he asserts Rosmactriuin to be in Munster, and that Meath is a province, (or 'fifth'), in opposition even to Cambrensis, who does not reckon Meath as a province, and contrary to the Book of Invasion of Ireland. As Stanihurst divides Ireland, he makes up one half from the race of the foreigners apart, and the other half of Ireland outside that (jointly) between Gall and Gael; and, moreover, he says that the least colonist among the race of the foreigners would not deem it fitting to form a matrimonial alliance with the noblest Gael in Ireland; thus, he says, in his chronicle:—*The most lowly of the colonists who dwell in the foreign province would not give his daughter in marriage to the greatest prince among the Irish. {Colonorum omnium ultimus qui in Anglica provincia habitat filiam suam vel nobilissimo Hibernorum principi in matrimonium non daret.}’’*

 I ask Stanihurst which were the more honourable, the more noble, or the more loyal to the crown of England, or which were better as securities for preserving Ireland to the crown of England, the colonists of Fingall, or the noble earls of the foreigners who are in Ireland, such as the earl of Kildare, who contracted alliance with Mac Carthy riabhach, with O'Neill, and with others of the nobles of the Gael; the earl of Ormond with O'Brien, with Mac Gil Patrick, and with O'Carroll; the Earl of Desmond with Mac Carthy mór, and the earl of Clanricard with O'Ruarc. I do not reckon the viscounts nor the barons, who were as noble as any settler who was ever in Fingall, and by whom 


---

p.35




frequently their daughters were given in marriage to the nobles of the Gael. It is, moreover, manifest that it is more frequently the English authorities entrusted the care of defending and retaining Ireland to the charge of the earls [whom we have mentioned] who made alliance with the native Irish, than to the charge of all the settlers that ever were in the English pale. Wherefore I conceive not whence it is that they do not contract alliance with the nobles of Ireland, unless it be from disesteem for their own obscurity, so that they did not deem themselves worthy to have such noble Gaels in their kinship.
From the worthlessness of the testimony Stanihurst gives concerning the Irish, I consider that he should be rejected as a witness, because it was purposely at the instigation of a party who were hostile to the Irish that he wrote contemptuously of them; and, I think, that hatred of the Irish must have been the first dug he drew after his first going into England to study, and that it lay as a weight on his stomach till, having returned to Ireland, he ejected it by his writing. I deem it no small token of the aversion he had for the Irish, that he finds fault with the colonists of the English province for that they did not banish the Gaelic from the country at the time when they routed the people who were dwelling in the land before them. He also says, however excellent the Gaelic language may be, that whoever smacks thereof would likewise savour of the ill manners of the folk whose language it is. What is to be understood from this, but that Stanihurst had so great an hatred for the Irish, that he deemed it an evil that it was a Christian-like conquest the Gaill


---

p.37




achieved over Ireland and the Gael, and not a pagan conquest. For, indeed, he who makes a Christian conquest thinks it sufficient to obtain submission and fidelity from the people who have been subdued by him, and to send from himself other new people to inhabit the land over which his power has prevailed, together with the people of that country. Moreover, it is the manner of him who makes a pagan conquest, to bring destruction on the people who are subdued by him, and to send new people from himself to inhabit the country which he has taken by force. But he who makes a Christian conquest extinguishes not the language which was before him in any country which he brings under control: and it is thus William the Conqueror did as regards the Saxons. He did not extinguish the language of the Saxons, seeing that he suffered the people who used that language to remain in the country, so that it resulted therefrom that the language has been preserved from that time down among the Saxons. Howbeit, it is a pagan conquest which Hengist, the chief of the Saxons made over the Britons, since he swept them from the soil of Britain, and sent people from himself in their places; and having altogether banished everyone, he banished their language with them. And it is the same way Stanihurst would desire to act by the Irish; for it is not possible to banish the language without banishing the folk whose language it is: and, inasmuch as he had the desire of banishing the language, he had, likewise, the desire of banishing the people whose language it was, and, accordingly, he was hostile to the Irish; and so his testimony concerning the Irish ought not to be received.


---

p.39




Stanihurst also finds fault with the lawgivers of the country, and with its physicians: although I wonder how he ventured to find fault with them, seeing that he understood neither of them, nor the language in which the skill of either class found expression, he being himself ignorant and uninformed as regards the Gaelic, which was their language, and in which the legal decisions of the Country and the (books of) medicine were written. For he was not capable of reading either the law of the land or the medicine in their own language, and if they had been read to him, he had no comprehension of them. Accordingly, I think that it is the same case with him, depreciating the two faculties we have mentioned, and the case of the blind man who would discriminate the colour of one piece of cloth from another: for as the blind man cannot give a decision between the two colours, because he does not see either of them, in like manner, it was not possible for him to form a judgment between the two aforesaid faculties, inasmuch as he never understood the book in which they were written, and did not even understand the doctors whose arts these were, because the Gaelic alone was their proper language, and he was out and out ignorant of it.


He finds fault also with those who play the harp in Ireland, and says, that they have no music in them. It is likely that he was not a judge of any sort of music, and especially of Irish music, he being unacquainted with the rules which appertain to it. I think Stanihurst has not understood that it is thus Ireland was (being) a kingdom apart by herself like a little world, and that the nobles and the learned who were there long ago arranged to have 


---

p.41



jurisprudence, medicine, poetry, and music established in Ireland with appropriate regulations: and, therefore, it was not seemly for him to have formed and delivered a hasty rash judgment censuring the music of Ireland. It is a marvel to me that he had not read Cambrensis in the nineteenth chapter, where he praises the music of the Irish, unless it were that he had determined to attain a degree beyond Cambrensis in disparaging the Irish: for there is nothing at all in which Cambrensis more commends Irishmen than in the Irish music. Here is what he says in the same chapter:—*In instruments of music alone I find the diligence of this nation praiseworthy, in which, above every nation that we have seen, they are incomparably skilful. {In musicis solum instrumentis commendabilem invenio gentis istius diligentiam, in quibus, prae omni natione quam vidimus incomparabiliter est instructa.}’’*

 As he says further, according to the same chapter, here is the information he gives concerning Irish music, praising it:— *Their melody, says he, is perfected and harmonized by an easy quickness, by a dissimilar equality, and by a discordant concord. {Tam suavi velocitate, tam dispari paritate, tam discordi concordia, consona redditur et completur melodia.}’’* From this it may be understood, on the testimony of Cambrensis, that it is false for Stanihurst to say that there is no music in Irish melody. It is not true for him, either, what he says, that the greater part of the singing folk of Ireland are blind; for it is clear that, at the time he wrote his history, there was a greater number of persons with eyesight engaged in singing and playing than of blind people, so from that down, and now, the evidence may rest on our contemporaries.
Understand, reader, that Stanihurst was under three deficiencies for writing the history of Ireland, on account of which it is not fit to regard him as an historian. In the first 


---

p.43




place, he was too young, so that he had not had opportunity for pursuing inquiry concerning the antiquity of this country, on which he undertook to write. The second defect, he was blindly ignorant in the language of the country in which were the ancient records and transactions of the territory, and of every people who had inhabited it; and, therefore, he could not know these things. The third defect, he was ambitious, and accordingly, he had expectation of obtaining an advantage from those by whom he was incited to write evil concerning Ireland: and, moreover, on his having subsequently become a priest, he promised to recall most part of the contemptuous things he had written concerning Ireland, and I hear that it is now in print, to be exhibited in Ireland.


Stanihurst says that when Irishmen are contending, or striking each other, they say as a shout with a loud voice, ‘Pharo, Pharo,’ and he thinks that it is from this word Pharao, which was a name for the king of Egypt, they use it as a war-cry: howbeit, that is not true for him, for it is the same as ‘watch, watch O’, or, ‘O take care’, telling the other party to be on their guard, as the Frenchman says, ‘gardez, gardez’, when he sees his neighbour in danger.


VI.
---


**Dr. Hanmer** states in his chronicle that it was Bartholinus who was leader of the Gaels at their coming into Ireland, and it is to Partholon he calls Bartholinus here. However, according to the ancient record of Ireland, there were more than seven hundred years between the coming of Partholon and the 


---

p.45




coming of the children of Mileadh to Ireland. For at the end of three hundred years after the deluge came Partholon, and at the end of a thousand and four score years after the deluge came the sons of Mileadh to Ireland. And in the opinion of Camden, it is more fitting to rely on the history of Ireland in this matter than on the words of **Hanmer**. Here is what he says:—*Let its due respect be given to antiquity in these things, {In his detur sua antiquitati venia.}’’*

 (says he): and if it should be given to any record in the world on the score of being ancient, the antiquity of Ireland is indeed worthy of respect, according to the same Camden, in the book which is called Camden's Britannia, where he says, speaking of Ireland:— *Not unjustifiably was this island called ‘Ogygia’ by Plutarch, i.e. most ancient. {Non immerito haec insula Ogygia, id est perantiqua, Plutarcho dicta fuit.}’’* Camden furnishes a reason for this, and here is what he says:—*From the most profound memory of antiquity they derive, their own history (speaking of the Irish), insomuch that there is not in all antiquity of all other nations but newness or almost infancy, {A profundissima enim antiquitatis memoria historias suas auspicantur, adeo ut prae illis omnis omnium gentium antiquitas sit novitas aut quodammodo infantia.}’’* beside the antiquity of Ireland: and, therefore, that it is more fitting to rely on it than on **Dr. Hanmer**, who never saw the old record of Ireland.
The same author says that it was a king of Scandinavia, whose name was Froto, was king of Ireland when Christ was born; however, that is not true for him, for according to the ancient bistory, it is during the time of Criomhthann Nia Náir being in the sovereignty of Ireland that Christ was 


---

p.47




born; and according to that, it was not Froto, king of Scandinavia, who was king of Ireland at that time. It is marvellous how **Hanmer**, an Englishman, who never either saw or understood the history of Ireland, should know who was king of Ireland at the time Christ was born, he being without definite information as to who was king of Great Britain itself. For Samuel Daniel, Gildas, Rider, and Nennius, and many other authors who have written the history of Great Britain, acknowledge that the old account they have themselves on the ancient condition of Britain was inexact, because the Romans and Saxons deprived them of their records and their ancient texts; insomuch that they had but a conjecture or an opinion to offer concerning the ancient affairs of Britain before the Saxons and the Romans: and, therefore, the learned Camden himself says that he knew not whence it was that Britain was called Britannia, but to give his opinion like any man. He says also that he did not know when the Picts came to inhabit the northern part of Great Britain; and since there were many of the ancient transactions of Great Britain obscure to him, it was no wonder their being still more obscure to **Hanmer**, and that there should be greater obscurity than that in his case concerning the ancient affairs of Ireland: and, accordingly, he is not a trustworthy warrant as regards the king of Scandinavia having been king of Ireland at the time of the birth of Christ.


He says, likewise, that it is not Patrick, the apostle of Ireland (he by whom the Catholic faith was first propagated in the country), who discovered the cave of Patricks purgatory in the island of purgatory, but another Patrick, an abbot,


---

p.49




who lived in the year of the Lord, eight hundred and fifty. Nevertheless, this is not true for him according to holy Caesarius, who lived within six hundred years of Christ, and consequently flourished two centuries and a half before this second Patrick. Here is what he says in the thirty-eighth chapter of the twelfth book he wrote, entitled Liber dialogorum:—*Whoever casts doubt on purgatory, let him proceed to Ireland, let him enter the purgatory of Patrick, and he will have no doubt of the pains of purgatory thence-forward. {Qui de purgatorio dubitat, Scotiam pergat, purgatorium Sancti Patricii intret, et de purgatorii poenis amplius non dubitabit.}’’*

 From this it may be understood that it is not that second Patrick whom **Hanmer** mentions, who discovered Patrick's purgatory in the beginning, but the first Patrick. For how could it be possible that it should have been the second Patrick who discovered it, seeing that two centuries and a half elapsed from the time Caesarius wrote on the purgatory of Patrick to the time the second Patrick lived; and moreover, we have the record and the tradition of Ireland stating, that it was Patrick the apostle who discovered purgatory at first in Ireland. Wherefore, it is clear that it is a malicious lie **Hanmer** has stated here, in hope that thereby the Irish would have less veneration for the cave of Patrick.
Another thing he says, in his twenty-fourth page, that Fionn, son of Cumhall, was of the Scandinavians of Denmark; though this is not true for him, according to the chronicle, but he is of the posterity of Nuadha Neacht, king of Leinster, who came from Eireamhón, son of Mileadh. He says also, in the twenty-fifth page, that the person whom authors call Gillamar, king of Ireland, was son to the king of Thomond; howbeit, we deem the confutation we have already given this thing sufficient.




---

p.51


I think that it is mockingly **Hanmer** inserts the battle of Ventry, deceitfully ridiculing the antiquaries, so that he might give the reader to understand that there is no validity in the history of Ireland, but like the battle of Ventry. However, it is clear that the 'shanachies' do not, and did not, regard the battle of Ventry as a true history, but that they are assured that it is a poetical romance, which was invented as a pastime. The same answer I give to every other story he recounts concerning the Fianna. It is untrue for him also where he says that Sláinghe, son of Deala, was thirty years in the sovereignty of Ireland, whereas, according to the record, he reigned but one year only.


It is untrue, likewise, for him to say that the archbishop of Canterbury had jurisdiction over the clergy of Ireland from the time of Augustine the monk. For it is certain that the archbishop of Canterbury had no jurisdiction over the clergy of Ireland until the time of William the Conqueror, and even then he had not jurisdiction, except over the clergy of Dublin, Wexford, Waterford, Cork, and Limerick; and it is those clergy themselves who placed themselves under the control of the archbishop of Canterbury, through affection of kinship with, the people of Normandy, they being themselves of the remnant of the Danes usually called Normans, and also through dislike of the Irish;, and I do not think there was authority over those same (clerics), but during the time of three archbishops who were in Canterbury, namely, Radulph, Lanfranc, and Anselm. Therefore it is false for him to say that the archbishop of Canterbury had jurisdiction


---

p.53




over the clergy of Ireland from the time of Augustine the monk.


It is also false what he says that Murchadh Mac Cochlain was king of Ireland in the year of the Lord one thousand one hundred and sixty-six, for it is certain that it was Ruaidhri Ua Conchubhair who was at that time assuming the headship of Ireland, and that that time was four years before the Norman invasion.


Again, he says, that it is in Great Britain Comhghall, abbot of Beannchar in the Aird of Ulster, was born: yet that is not true for him, for it is read in his life that it was in Dal n-aruidhe in the north of Ulster he was born, and that he was of the race called Dal n-aruidhe. It is wherefore **Hanmer** thought to make a Briton of Comhghall, because that it was Comhghall founded the abbey of Beannchar in the Aird of Ulster, which was the mother of the abbeys of all Europe, and that he founded another abbey in England beside west Chester, which is called Bangor: and if it should happen to **Hanmer** to convince the reader that Comhghall was a Briton, that he would give him consequently to understand that every excellence which adorned the abbey of Beannchar of Ulster would tend to the renown of the Britons in regard to Comhghall belonging to them; or that all the fame which Beannchar of Ulster had earned would be imputed to the abbey named Bangor, which is in England.


**Hanmer** says that Fursa, Faolan, and Ultan were bastard children of a king of Leinster; although truly they were children of Aodh Beannan, king of Munster, according to the account of the saints of Ireland. So also for many other of 


---

p.55




the lies of **Hanmer** writing on Ireland, and I pass on without pursuing them further, because it would be tedious to mention them all.


VII.
----


John Barckly, writing on Ireland, says these words:— *They build (says he, speaking of the Irish) frail cabins to the height of a man, where they themselves and their cattle abide in one dwelling. {Fragiles domos ad altitudinem hominis exitant, sibi pecorique communes.}’’*

 I think, seeing that this man stoops to afford information on the characteristics and on the habitations of peasants and wretched petty underlings, that, his being compared with the beetle is not unfitting, since he stoops in its fashion to give an account of the hovels of the poor, and of miserable people, and that he does not endeavour to make mention or narration concerning the palatial princely mansions of the earls and of the other nobles who are in Ireland. I consider also that the repute of an historian ought not to be given to him, nor to any body else who would follow his track in the same degree: and thus, with one word, I discard the witness of Fynes Moryson who wrote jeeringly on Ireland; for, though his pen was skilful for writing in English, I do not think that he intended by the power of the pen to disclose the truth, and so I do not consider that it is worth (while) giving him an answer. For, the historian who proposes to furnish a description of any people who may be in a country, ought to report their special character truthfully [on them], whether good or bad; and because that it was of set purpose, through evil and through a bad disposition (at the suggestion of other people, who had the same mind towards the Irish), he has left in oblivion,


---

p.57




without estimating the good qualities of the Irish, whereby he has abandoned the rule most necessary for an historian to preserve in his narrative, and therefore the status of history ought not to be accorded to his wrtiting. These are, indeed, the rules which should be most observed in writing history, according to Polydorus, in the first book he has written de rerum inventoribus, where he treats of the fittest rules for writing history: here is the first rule he sets down —*That he should not dare to assert anything false. {Prima est, nequid falsi dicere audeat.}’’* The second rule:—*That he should not dare to omit setting down every truth’’*: here are the author's words:—*in order (says he) that there should be no mistrust of friendship or unfriendliness in the writing. {Deinde nequid veri dicere non audeat, neque suspitio gratiae sit in scribendo, neque simulatis.}’’* He says, moreover, in the same place, that the historian ought to explain the customs and way of life, the counsels, causes, resolves, acts, and development, whether good or bad, of every people who dwell in the country about which he has undertaken to write: and, inasmuch as Fynes Moryson, has omitted to notice anything good of the Irish, he has neglected to observe the aforesaid rules, and accordingly, the dignity of history cannot be allowed to his composition.
Whoever should determine to make a minute search for ill customs, or an investigation into the faults of inferior people, it would be easy to fill a book with them; for there is no country in the world without a rabble. Let us consider the rough folk of Scotland, the rabble-rout of Great Britain, and the plebians of Flanders, the insignificant fellows of France


---

p.59




the poor wretches of Spain, the ignoble caste of Italy, and the unfree tribe of every country besides, and a multitude of ill-conditioned evil ways will be found in them; howbeit, the entire country is not to be disparaged on their account. In like manner, if there are evil customs among part of the unfree clans of Ireland, all Irishmen are not to be reviled because of them, and whoever would do so, I do not think the credit of an historian should be given him; and since it is thus Fynes Moryson has acted, writing about the Irish, I think it is not allowable he should have the repute of an historian: and so I say also of Campion.


Camden says that it is usual in Ireland for the priests with their children and concubines to dwell in the churches, and to be drinking and feasting in them: and moreover, that it is a habit there to call the children of these clerics, son of the bishop, son of the abbot, son of the prior, and son of the priest. My answer to him here is, that the time the clergy of Ireland began that bad system was after the eighth Henry had changed his faith, and, even at that time and thenceforward, there did not practise that bad habit but such of them as followed their own lusts, and denied the lawful superiors who were set over them. Camden himself concurs with this reply, where he says, speaking of Ireland:— *Whoever among them (says he) give themselves to a religious life, restrain themselves even to miracle in a condition of austerity, governed by rule, watching, praying, and fasting for their mortification. {Si qui religioni se consecrant, religiosa quadam austeritate ad miraculum usque se continent, vigilando, orando, et jejuniis se macerando.}’’*

 Here is what Cambrensis says in the twenty-seventh chapter, speaking also of the clergy of 


---

p.61




Ireland:— *The clergy of this land (says he, speaking of Ireland) are abundantly commendable as to the religious life, and amongst every other virtue which they possess, their chastity excels all the other virtues. {Est autem terrae illius clerus satis religione commendabilis, et inter varias quibus pollet virtutes, castitatis praerogativa praeeminet atque praecellit.}’’* From this it may be understood that chastity prevailed among the clergy of Ireland in Cambrensis' time: and, moreover, it may be inferred from this, that it is not *everybody* of the clergy of Ireland who followed that evil custom, but only the lustful set who broke their obligation, and went schismatically in disobedience to their ecclesiastical superiors. Stanihurst agrees with this thing in the narrative which he wrote concerning Ireland, in the year of the Lord one thousand five hundred and eighty-four. Here is what he says:— *The most part of the Irish (says he) have great regard for devotion or the religious state. {Hibernici etiam magna ex parte sunt religionis summe colentes.}’’* From this it may be understood that that bad practice which Camden mentions was not common in Ireland, except only among the clergy who rejected their obligation as we have said above.
Camden says that the marriage bond is not strictly observed in Ireland, outside of the great towns: however, this is not true for him, and casts great discredit on the true aristocracy of Ireland, both native and foreign, because that it is in the country they mostly reside. Howbeit, I say not that there be not some of them lustful, as there be in every country, those who are not obedient to their ecclesiastical superiors: and, accordingly, it is unjust for Camden to charge this offence, rarely occurring, as a reproach against the Irish who reside in the rural districts. For, if there were one or


---

p.63




two, or a few, of them unruly, the inhabitants of the entire country should not be censured because of these: and, consequently, it is not fair of Camden to say that marriage is seldom regarded among the Irish, except among the people of the large towns and cities: and as for the folk who say that a marriage contract for a year is customary in Ireland, it is certain that it was never practised there, but by misguided people who were not submissive to their ecclesiastical superiors, and, for that reason, a general reproach should not be flung at the Irish because a few indocile unrestrained individuals practise this.


Campion says, in the sixth chapter of the first book of his narrative, that the Irish are so credulous, in a manner, that they will regard as truth whatever their superior may say, however incredible, and he propounds a dull fabulous tale in support of this. That is to say, that there was a greedy prelate in Ireland who was capable of imposing on his people anything he might say, and, being straitened for money, and in hope that he might obtain assistance from them, he made known to them that, within a few years, Patrick and Peter had been contending with each other concerning an Irish 'galloglass' whom Patrick wanted to have admitted into the kingdom of Heaven, and that Peter became angry, and with that he struck Patrick on the head with the key of Heaven, so that he broke his pate, and Campion says that the prelate obtained a subsidy by this story. My answer to him here is, that he is like a player who would be recounting jeering stories on a platform rather than an historian. For, how 


---

p.65




could: it be possible that any Christian who was in Ireland would believe that Patrick's crown could be broken, and he having died more than a thousand years before: and more-over, as everybody knows, that it is a key of authority Peter had, and not an iron key by which any headpiece could be broken. Wherefore I think it was a silly lie Campion invented in making up this thing about the Irish; and forasmuch as he admits himself in the epistle he writes at the beginning of his book, that he spent but ten weeks in writing the history of Ireland, I think that it is not worth making a reply to any more of his lies.


Here is the testimony which Mr. Good, an English priest who was directing a school in Limerick, gives concerning the Irish in the year of the Lord fifteen hundred and sixty-six:—*A nation this, (he says) which is strong of body, and active, which has a high vigorous mind, an acute intellect, which is warlike, lavish of its substance, which is gifted with endurance of labour, cold, and hunger, which has an amorous turn, which is most kind towards guests, steadfast in love, implacable in enmity, which is credulous, greedy of obtaining renown, impatient of enduring insult or injustice. {Gens haec corpore valida et in primis agilis, animo forti et elato, ingenio acri, bellicosa, vitae prodiga, laboris, frigoris et inediae patiens, veneri indulgens, hospitibus perbenigna, amore constans, inimicis implacabilis, credulitate levis, gloriae avida, contumeliae et iniuria impatiens.}’’*

 Here is also the testimony which Stanihurst gives of them:—*A people much enduring in labours, beyond every race of men, and it is seldom they are cast down in difficulties. {In laboribus ex omni hominum genere patientissimi, in rerum angustiis raro fracti.}’’*
Spenser says that it was from the Irish the Saxons first


---

p.67




received the alphabet, and, according to that, the Saxons had no knowledge whatever of literature till they acquired it from Irishmen.


VIII.
-----


John Davies finds fault with the legal system of the country, because, as he thinks, there are three evil customs in it. The first custom of these is that the **tanist** takes precedence of the son of the lord of the soil. The second custom is the division which was made on, the land between brethren, which the Galls call **gavalkind**, where a subdivision of the land is made between the kinsmen. The third custom is to take **eric** for the slaying of man. My answer in this matter is, that there is not a country in the world in which a change is not made in statutes and customs, according as the condition of the, country alters. For, those customs were not sanctioned in the law of the land until the Irish had entered upon war and conflict between every two of their territories, so that they were usually slaying, harrying, and plundering each other: and as it was apparent to the nobles of Ireland, and to their **ollavs**, the damage which ensued from the disunion among the inhabitants, they deemed it expedient to ordain those three customs.


In the first place, they understood that the **tanistry** was suitable in order that there should be an efficient captain safeguarding the people of every district in Ireland, by defending their spoils and their goods for them. For, if it


---

p.69




were the son should be there, instead of the father, it might happen, occasionally, for the son to be in his minority, and so that he would not be capable of defending his own territory, and that detriment would result to the country from that circumstance. Neither was it possible to dispense with the second custom obtaining in Ireland at that time, that is to say, to have fraternal partnership in the land. For, the rent of the district would not equal the hire which would fall to the number of troops who would defend it: whereas, when the territory became divided among the associated brethren, the kinsman who had the least share of it would be as ready in its defence, to the best of his ability, as the tribal chief who was over them would be. No more was it possible to avoid having the **eric** established at this time: for, if any one slew a man then, he would find protection in the territory nearest to him, and since it was not in the power of the friends of him who was slain to exact vengeance or satisfaction from him who did the deed, they would sue his kin for the crime, as punishment on the slayer; and inasmuch as his kin had no privity of the slaying, it would not be lawful to shed their blood; nevertheless, a fine was imposed on them as punishment for him who had committed the crime, and I notice the same custom obtaining among the Galls now, where the **kin-cogaish** is adopted by them. Indeed, **eric** and **kin-cogaish** are alike; for cion and coir (i.e. a crime) are equal, and comghlas and gaol (i.e. kinship) are equal, and what **kin-cogaish** signifies is to exact a tax or payment in **eric** or **honour-price** for the hurt or the loss which anyone causes (though it be slaying or other evil deed), from his 


---

p.71




friend, or from his kindred; and I perceive that the Galls keep up that system now, since the **kin-cogaish** is adopted by them. Wherefore, it is not honest in John Davies to find fault with the native jurisprudence because of it; and, as far as regards the other two customs, there was no way of doing without them in Ireland when they were appointed, and, therefore, the native law of the land, should not be censured on their account. For, though they are not suitable for Ireland now, they were necessary at the time they were established.


Camden says it is a system among the Irish for their nobles to have lawgivers, physicians, antiquaries, poets, and musicians, and for endowments to be bestowed on them, and also their persons, lands, and property to enjoy immunity. Here is what he says, speaking of them:—*These princes (he says) have their own lawgivers, whom they call 'brehons', their historians for writing their actions, their physicians, their poets, whom they name 'bards', and their singing men, and land appointed to each one of these, and each of them dwelling on his own land, and, moreover, every one of them of a certain family apart; that is to say, the judges of one special tribe and surname, the antiquaries or historians of another tribe and surname, and so to each one from that out, they bring up their children and their kinsfolk, each one of them in his own art, and there are always successors of themselves in these arts. {Habent hi magnates suos iuridicos, quos vocant Brehonos, suos historicos, qui res gestas describunt, medicos, poetas, quos bardos vocant, et citharaedos, quibus singulis sua praedia assignata sunt, et singuli sunt in unoquoque territorio, et é certis et singulis familiis; scilicet, brehoni unius stirpis et nominis, historici alterius, et sic de coeteris, qui suos liberos sive cognatos in sua qualibet arte erudiunt, et semper successores habent.}’’*




---

p.73


From these words of Camden it is clear that the order is good which the Irish had laid down for preserving these arts in Ireland from time to time. For they assigned professional lands to each tribe of them, in order that they might have sustenance for themselves for the cultivation of the arts, that poverty should not turn them away; and, moreover, it is the most proficient individual of one tribe or the other who would obtain the professorship of the prince of the land which he held; and it used to result from that that every one, of them would make his best efforts to be well versed in his own art in hope of obtaining the professorship in preference, to the rest of his tribe: and it is thus it is done beyond the sea now by many who go to obtain (college) chairs in consideration of their learning. It was all the more possible to preserve these arts, as the nobility of Ireland had appointed that the land, the persons and the property of the ollavs should enjoy security and protection; for when the native Irish and the foreigners would be contending with each other, they should not cause trouble or annoyance to the professors, or to the pupils who were with them for instruction, hindering them from cultivating the arts. It is read in Julius Caesar, in the sixth book of his history, that the 'druids' who came from the west of Europe to direct schools in France enjoyed a similar immunity, and I think that it was from Ireland they brought that custom with them.




---

p.75


IX.
---


The refutation of these new foreign writers need not be pursued by us any further, although there are many things they insert in their histories which it would be possible to confute; because, as to the most part of what they write disparagingly of Ireland, they have no authority for writing it but repeating the tales of false witnesses who were hostile to Ireland, and ignorant of her history: for it is certain that the learned men who were conversant with antiquity in Ireland did not undertake to enlighten them in it, and, so, it was not possible for them to have knowledge of the history and ancient state of Ireland. And Cambrensis, who undertook to supply warrant for everything, it is likely in his case that it was a blind man or a,blockhead who gave him such a shower of fabulous information, so that he has left the invasion of the Tuatha Dé Danann without making mention of it, although they were three years short of two hundred in the headship of Ireland, and that there were nine kings of them in the sovereignty of Ireland: and (yet) he had recounted the first invasion of Ireland, although it were only the invasion of Ceasair, and that the antiquaries do not regard it for certain as an invasion, notwithstanding that it is mentioned by them in their books. Truly I think that he took no interest in investigating the antiquity of Ireland, but that the reason why he set about writing of Ireland is to give false testimony concerning her people during his own time, and their ancestors before them: and, besides, it was but brief opportunity he had for research on the history of Ireland, since he spent but a year and a half at it before going (back) to


---

p.77




England; and his history not being finished (in that time), he left a half year's portion wanting (to be completed) of it under the care of a companion of his, named Bertram Verdon.


Wherefore, I have hope that whatsoever impartial reader shall read every refutation which I make on Cambrensis, and on these new foreigners who follow his track, will trust the refutation I make on their lies rather than the story-telling they all do, for I am old, and a number of these were young; I have seen and I understand the chief historical books, and they did not see them, and if they had seen them, they would not have understood them. It is not for hatred nor for love of any set of people beyond another, nor at the instigation of anyone, nor with the expectation of obtaining profit from it, that I set forth to write the history of Ireland, but because I deemed it was not fitting that a country so honourable as Ireland, and races so noble as those who have inhabited it, should go into oblivion without mention or narration being left of them: and I think that my estimate in the account I give concerning the Irish ought the rather to be accepted, because it is of the Gaels I chiefly treat. Whoever thinks it much I say for them, it is not to be considered that I should deliver judgment through favour,giving them much praise beyond what they have deserved, being myself of the old Galls as regards my origin.


If, indeed it be that the soil is commended by every historian who writes on Ireland, the race is dispraised by every new foreign historian who writes about it, and it is by that I was incited to write this history concerning the Irish, owing to the extent of the pity I felt at the manifest injustice which is done to them by those writers. If only indeed they had given their proper estimate to the Irish, I know not why


---

p.79




they should not put them in comparison with any nation in Europe in three things, namely, in valour, in learning, and in being steadfast in the Catholic faith: and forasmuch as regards the saints of Ireland, it needs not to boast what a multitude they were, because the foreign authors of Europe admit this, and they state that Ireland was more prolific in saints than any country in Europe; and, moreover, they admit that the dominion of learning in Ireland was so productive, that she sent forth from her learned companies to France, to Italy, to Germany, to Flanders, to England, and to Scotland, as is clear from the introduction to the book in which were written in English lives of Patrick, Columcille, and Brigid: and forasmuch as concerns the ancient history of Ireland, it may be assumed that it was authoritative, because it used to be revised at the assembly of Tara every third year, in presence of the nobility, the clergy, and the learned of Ireland; and since the Irish received the faith, it has been placed under the sanction of the prelates of the Church. These chief books following which are still to be seen, will testify to this; namely, the Book of Armagh; the 'Saltair' of Cashel, which holy Cormac, son of Cuileannan, king of the two provinces of Munster and archbishop of Cashel, wrote; the Book of Uachongbháil; the Book of Cluaineidhneach of Fionntan in Leix; the Saltair na rann, which Aonghus the 'Culdee' wrote; the Book of Glendaloch the Book of Rights, which holy Benen, son of Sesgnen wrote; the 'Uidhir' of Ciaran, 



---

p.81




which was written in Clonmacnois; the Yellow Book of Moling, and the Black Book of Molaga. Here follows a summary of the books which were written in those namely, the book of Invasion, the book of the Provinces, the Roll of Kings, the book of tribes, the book of synchronism, the book of famous places, the book of remarkable women, the book which was called 'Cóir anmann'; the book which was called 'Uraicheapt', which Ceannfaolaidh the learned wrote, and the book which is called the 'Amhra' of Columcille, which Dallan Forgaill wrote shortly after the death of Columcille. There are yet to be seen in Ireland many other histories, besides the chief books which we have mentioned, in which there is much of ancient record to be discovered, such as the battle of Magh Muccraimhe, the siege of Druim Damhghaire, the fates of the knights, the battle of Crionna, the battle of Fionnchoradh, the battle of Ros na Ríogh, the battle of Magh Léana, the battle of Magh Rath, the battle of Magh Tualaing, and many other histories which we shall not mention here. Furthermore, the historical record of Ireland should be considered as authoritative, the rather that there were over two hundred professors of history keeping the ancient record of Ireland, and every one of them having a subsidy from the nobles of Ireland on that account, and having the revision of the nobility and clergy from time to time. Because of its antiquity, likewise, it is the more worthy of trust, and, also, that it has not suffered interruption or suppression from the violence of strangers. For, notwithstanding that the Norsemen had been troubling Ireland for a period, there were such a number of Iearned men keeping the ancient record that the historical compilation 


---

p.83




was preserved, even though many books fell into the hands of the Norsemen. Howbeit, it is not thus with other European countries, because the Romans, Gauls, Goths, Vandals, Saxons, Saracens, Moors, and Danes destroyed their old records in every inroad (of their kings) which they made upon them: yet, it fell not to any of these to plunder Ireland, according to Cambrensis, in the forty-sixth chapter, where he says, speaking of Ireland:—*Ireland was, from the beginning, free from incursion of anyforeign nation. {Hibernia, ab initio, ab omni alienarum gentium incursu libera permansit.}’’*

 From this it may be understood that Ireland was free from the invasion of enemies by which her ancient history and her former transactions would be extinguished; and it is not so with any other country in Europe. Wherefore I think that it is more fitting to rely on the history of Ireland than on the history of any other country in Europe, and, moreover, as it has been expurgated by Patrick, and by the holy clergy of Ireland, from time to time.
Understand, nevertheless, O reader, that I have made a change in the computation of the years which are stated to have been in the reign of a few of the pagan kings of Ireland apart from how it is set down in the Roll of Kings, and in the poems which have been composed on them; and the reason I have for that is, that I find them not agreeing with the enumeration of the epochs from Adam to the birth of Christ, according to any reputable foreign author. I have, besides, another reason, that it seems to me that an undue number of years is assigned to some of them, such as Síorna the long-lived to whom three fifties of years are attributed, and that we may read in the old book of Invasion that Síorna was an hundred years old before he assumed the sovereignty



---

p.85




of Ireland, and if I set down his being thrice fifty years in the sovereignty, I would not be believed. Wherefore I give him one and twenty years, according to the verse which is in his reign, which gives to Síorna but a year and twenty, as will be clear to the reader. They allow fifty years of reign to Cobhthach 'Caolmbreágh', although there should be given to him but thirty: for Moiriath, daughter of Scoiriath, king of Corca Duibhne, loved Maon, who was called Labhra 'loingseach', he being then in exile in her fathers house, he a youth and she a young maiden; and, after he had returned to Ireland from his exile, and after the slaying of Cobhthach, it is she who became wife to him, and bore him children. Wherefore, if I were to give fifty years of reign to Cobhthach, she would be three-score years, when she bore children to Labhra the navigator, and since this cannot be true, Cobhthach cannot have been in the sovereignty fifty years. Also, for other reasons, I make a change in the number of years of the reign of a few of the kings of Ireland before the Faith: but I think it was not through the ignorance of the antiquaries this change became necessary, but through the ignorance of some people who copied after them, who had no skill save only to practise the art of writing: because, since the time the suzerainty of Ireland passed to the Galls, the Irish have abandoned making the revision which was customary with them every third year of the ancient record, and so the professors of archaeology have neglected its purification, having lost the immunity and the emolument which it was customary with them to obtain from the Gaels in regard of preserving the ancient record; and because, moreover, 


---

p.87




there has been continual dissension between Galls and Gaels in Ireland, by which unrest was caused to the professors— preventing them from revising and purifying the record from time to time.


And if any one be surprised at the discrepancy which exists among some of the authors of our ancient record as to the calculation of time from Adam to the birth of Christ, it is no cause for wonder, seeing that there are few of the standard authors of all Europe who agree together in the computation of the same time.


Let us take as witness of this, the disagreement which these chief authors following make with each other:— In the first place, of the Hebrew authors:—


Baalsederhelm, 3518: the Talmudists, 3784: the New Rabbis, 3760: Rabbi Nahsson, 3740: Rabbi Levi, 3786: Rabbi Moses, 4058: Josephus, 4192.


Of the Greek authors:—


Metrodorus, 5000: Eusebius, 5190: Theophilus, 5476.


Of the Latin authors:—


St. Jerome, 3941: St. Augustine, 5351: Isidore, 5270: Orosius, 5199: Bede, 3952: Alphonsus, 5984.


Here is the reckoning of the twelve men and three score on the four first ages of the world, together with the calculation which the wise learned men who have followed them in the direct track have given on the epochs from the creation of the world to the birth of Christ, dividing them into five parts, i.e. from Adam to the deluge, 2242, from the deluge to Abraham, 942, from Abraham to David, 940, from David to the captivity of Babylon, 485, from the captivity to the birth of Christ, 590:—Sum, 5199: it is why the authorities


---

p.89




who follow the seventy-two men place the fifth period as their own time, because it is thus this era is completed, 5199, from the creation of Adam to the birth of Christ: and it is to the authors who follow the seventy-two men in the four first periods, i.e. Eusebius, who counts in his history from the creation of the world to the birth of Christ, 5199; Orosius, in the first chapter of his first book, says that there are from Adam to Abraham, 3184, and from Abraham to the birth of Christ, 2015; and the sum of both is 5199. St. Jerome says, in his epistle to Titus, that six thousand years of the age of the world had not been completed to the birth of Christ. St. Augustine, too, says, in the tenth chapter of the twelfth book de civitate Dei, that six thousand years are not computed from the creation of the world to the birth of Christ. Let both be set on that part that they agree with these calculators, in the number of the count from the creation of the world to the birth of Christ nineteen years on four score, on one hundred, on five thousand. Another proof of the same computation is the Roman Martyrology, which declares the total of these epochs, from the creation of Adam to the birth of Christ, five thousand, one hundred, ninety and nine.


And since these chief authorities agree not with each other in the computation of the time which is from Adam to the birth of Christ, it is no wonder that there should be discrepancy among some of the antiquaries of Ireland about the same calculation. However, I have not found among them a computation I rather think to be accurate than the numbering which some of them make four thousand, fifty and two years, for the time from Adam to the birth of Christ; and (it is) what I desire is to follow the standard author who comes nearest to this reckoning in the synchronism of the


---

p.91




sovereigns, of the epochs, of the popes, and of the general councils at the end of the book in their own proper places.


If anyone should charge it upon me as a strange thing wherefore I give many verses as evidence for the history out of the old record, my answer to him is that my reason for that is, that the authors of the ancient record framed the entire historical compilation in poems, in order that thereby the less change should be made in the record; and also, that in this manner, it might the more be committed to memory by the students who were attending them: for it is through being in verse metre the 'saltair' of Tara was called to the chief book which was in the custody of the king of Ireland's own professors, and the 'saltair' of Cashel to the chronicle of Cormac, son of Cuileannan, and the 'saltair' of the verses to the record of Aonghus the 'culdee': for, as 'psalm' and **duan** (poem) or **dán** (song) are alike, equal are **saltair** or ‘psalterium’ and **duanaire**, in which there would be many poems or songs: and forasmuch as in the poems are the bone and marrow of the ancient record, I think that it is expedient for me to rely on it as authority in treating of the history.


Therefore I have often said, in opposing the authors who have been refuted by us, that the ancient record was against them, because I considered that the record which was common and had been frequently revised, had more of authority, as we have said, than any one solitary author of those who are in the history. Some people profess astonishment how it should be possible to trace to Adam the origin of any man. My answer to that is, that it was easy for the Gaels to keep 


---

p.93




themselves (traced) even to Adam, because they had, from the time of Gaedheal down, ‘druids’ who used to preserve their generations of descent and their transactions in every expedition (of all) that befell them up to reaching Ireland, as is clear from the history following: and, moreover, they had an affection for science, insomuch that it was owing to his learning Niul, the father of Gaedheal, obtained every possession he got; and also the length the Gaels have been without change in the possession of one and the same country, and the excellence of the order they laid down for the preservation of the record, as we have said. Here follows an example from a British author, where he gives the pedigree to Adam of a king who was over Britain, from which the reader will allow that it was possible for the Gaels to do the same thing; and the authors name is Assher: here is the name of that king Aelfred, son of Aethelwulf, son of Egbert, son of Etalmund, son of Eafa, son of Eowua, son of Ingeld, son of Coenred, son of Coelwald, son of Cudam, son of Cutwin, son of Ceawlin, son of Cenric, son of Creoda, son of Cerdic, son of Elesa, son of Gelwus, son of Brond, son of Beld, son of Woden, son of Fritilwald, son of Frealaf, son of Fritilwulf, son of Fingodwulf, son of Gead, son of Caetwa, son of Beawua, son of Sceldwa, son of Eremod, son of Itermod, son of Atra, son of Hwala, son of Bedug, son of Japhet, son of Noah, &c., &c.


Here is a vindication or defensive introduction to the groundwork of knowledge on Ireland, in which is a compendium of the history of Ireland briefly: which has been


---

p.95




gathered and collected from the chief books of the history of Ireland, and from a good many trustworthy foreign authors by Geoffrey Keating, priest and doctor of divinity, in which is a brief summary of the principal transactions of Ireland from Partholon to the Norman invasion: and whoever shall desire to write fully and comprehensively on Ireland hereafter, he will find, in the same ancient books, many things desirable to write of her which have been purposely omitted here, lest, putting these all in one work, thereby this compilation should less likely come to light from the greatness of the labour of putting them in one writing.


The history is divided into two books: the first book makes known the condition of Ireland from Adam to the coming of Patrick into Ireland; the second book from the coming of Patrick to the invasion of the Galls, or down to this time.


I think that there is not a reader, impartial and open to conviction, whom it concerns to make a scrutiny into the antiquity of Ireland, but such as will be pleased with what we have said in this introduction: and if it should happen that he deems insufficient every explanation which I have given, it is beyond my ability he would go. Wherefore, I take leave of him, and let him excuse me, if it happen to me to go out of the way in anything I may say in this book, for if there be anything blameworthy in it, it is not from malice it is there, but from want of knowledge.


Your ever faithful poor friend till death, 
GEOFFREY KEATING.


---

p.97


HISTORY OF IRELAND.
-------------------


BOOK I.
-------

SECTION I.
----------


#### In the first place, we shall set down every name that was at any time on Ireland.


The first name which was given to Ireland was **Inis na bhfiodhbhadh**, that is to say Island of the woods; and the person who called that name to it was a warrior of the people of Nin, son of Bel, who came from him to spy out Ireland, and on his coming thither he found it to be all one forest-wood, except Magh-n-ealta alone. Three times, indeed, Ireland was one continuous wood, according to this old saying, which is in the ancient record: ‘Three times Eire put three coverings and three barenesses off her.’




---

p.99


The second name was **Críoch na bhfuineadhach** from its being at the limit or end of the three divisions of the world which had then been discovered; fuin indeed, from the Latin word finis being equivalent to ‘end’.


The third name was **Inis Ealga**, that is, noble island; for inis and oiléan are equivalent, and likewise ealga and uasal: and it is during the time of the **Firbolg** it was usual to have that name on it.


The fourth name was **Eire**, and it is said that wherefore that name is called to it, according to a certain author, is from this word Aeria, which was an old name for the island which is now called **Creta** or **Candia**; and why that author thinks that is because the posterity of the Gaedheal glas dwelt in that island some space of time after Sru, son of Easru, son of Gaedheal, had been driven out of Egypt: and, moreover, Aere is given as a name for Egypt whence the Gael proceeded. However, it is the common opinion of antiquaries that why it is Eire is from the name of the queen of the Tuatha Dé Danann who was in the land a the time of the coming of the of the Clann Míleadh into it: Eire, daughter of Dealbhaoth, was her name, and it is she was wife to Mac Gréine who was called Ceathúr who was king of Ireland when the sons of Míleadh came to it.


The fifth name was Fódhla, from a queen of the Tuath Dé Danann, who was called Fódhla: it is she was wife to Mac Cécht, whose proper name was Teathúr.


The sixth name was Banbha, from a queen of the Tuatha


---

p.101




Dé Danann, that was in the land, who was called Banbha: it is she was wife to Mac Cuill, whose proper name was Eathúr. These three kings held the sovereignty of Ireland each year by turns; and it is the name of the wife of each one of them would be on the island the year he was himself king. It is why the island is called Eire oftener than Fódhla or Banbha, because that is the husband of the woman whose name was Eire was king the year the sons of Míleadh came there.


The seventh name was Inis Fail; and it is the Tuatha Dé Danann gave that name to it, from a stone they brought with them into it, which was called the Lia Fail: and Saxum fatale, i.e. 'Stone of Destiny', Hector Boece calls it in the History of Scotland; and it was a stone on which were enchantments, for it used to roar under the person who had the best right to obtain the sovereignty of Ireland at the time of the men of Ireland being in assembly at Tara to choose a king over them. However, it has not roared from the time of Conchubhar forward, for the false images of the world were silenced when Christ was born. Here is a verse of quotation proving that it is from this stone Ireland is called Inis Fail, as Cionaoth the poet said:—


> 1. The stone which is under my two heels,
>   
> from it is named Inisfail;
>   
> Between two shores of a mighty flood,
>   
> the plain of Fál on all Ireland.
> 




The eighth name was Muicinis; and it is the children of Míleadh who gave it that name before they arrived in it. When, indeed, they had come to the mouth of Innbhear Sláinghe, which to-day is called the haven of Lochgarman, the Tuatha Dé Danann, with their druids, assemble to oppose


---

p.103




them there, and they practise magic on them, so that the island was not visible to them but in the likeness of a pig, so it is, therefore, they gave (the name) Muicinis to Ireland.


The ninth name was Scotia; and it is the sons of Míleadh who gave that name to it, from their mother, whose name was Scota, daughter of Pharao Nectonibus; or it is why they called it Scotia, because that they are themselves the Scottish race from Scythia.


The tenth name was Hibernia; and it is the sons of Míleadh gave that name to it. However, it is said that it is from a river that is in Spain which is called Iberus (the name) Hibernia is given to it. It is said also that it is from Eibhear, son of Míleadh, it is called Hibernia; but, however, holy Cormac, son of Cuileannan, says, that why it is called Hibernia is from this compound Greek word 'hiberoc' (ie. occasus in Latin) and 'nyaon' (i.e. insula) that is equivalent to saying insula occidentalis, i.e. ‘western island’.


The eleventh name was Iuernia, according to Ptolemy, or Iuerna, according to Solinus, or Ierna according to Claudian, or Vernia according to Eustatius. I think there is no meaning in the difference which is between these authors concerning this word Hibernia, but that they did not understand whence came the word itself; and, accordingly, that each one of them separately gave a guess from himself at it, so that from that came this variation on the word.


The twelfth name was Irin, according to Diodorus Siculus.


The thirteenth name was Irlanda; and I think that the reason why that name was given to it is, because that


---

p.105




it was Ir, son of Míleadh, was the first man of the Clanna Míleadh who was buried under the soil of Ireland, and accordingly, the island was named from him: 'Irlanda' and 'land of Ir' being indeed equivalent, for 'land' in English, and 'fonn' or 'fearann' in Gaelic are alike. The truth of this thing is the more admissible, since the **book of Armagh** says that a name for this island is Ireo, that is to say, the grave of Ir, because that it is there is the sepulchre or grave of Ir.


The fourteenth name was Ogygia, according to Plutarch: indeed, ‘Ogygia’ in Greek and insula perantiqua, i.e. most ancient island, are equivalent; and that is a suitable name for Ireland, because that it is long since it was first inhabited, and that perfect is the sound information which its antiquaries possess on the transactions of their ancestors from the beginning of eras, one after another.


SECTION II.
-----------


#### Here follows every division which was made on Ireland.


The first division, it is Partholon who divided it into four parts among his four sons, whose names were Er, Orba, Fearon, and Feargna. He gave the first part to Er, namely, all that is from Aileach Néid in the north of Ulster to Athcliath of Leinster. He gave the second part to Orba, namely, all that is from Athcliath to Oiléan Arda Neimheadh, which is called Oiléan Mór an Bharraigh. He gave the


---

p.107




third part to Fearon, from the Great Island to Athcliath Meadhruidhe at Galway. He gave the fourth part to Feargna, namely, from Meadhruidhe to Aileach Néid.


The second division, that is, the division of the children of Neimheadh. Three leaders of the children of Neimheadh divided Ireland among them into three parts:—Beothach, Simeon, and Briotán their names. Beothach takes from Tóirinis to the Boyne. Simeon takes from the Boyne to Bealach Chonglais near to Cork. Briotán takes from Bealach Chonglais to Tóirinis in the north of Connacht.


The third division here, i.e. the division of the Firbolg. The five sons of Deala, son of Loch, divided Ireland into five parts among them, and it is those are called the five provinces, and it is that is the division which is the most permanent that was ever made in Ireland, as we shall shortly hereafter relate. Cambrensis agrees with this division in the book he wrote of an account of Ireland, where he says:—*In five parts, indeed, almost equal, (he says), this country was anciently divided, which are, the two Munsters, north Munster and south Munster, Leinster, Ulster, and Connacht. {In quinque enim portiones (inquit) fere aequales antiquitus haec regio divisa fuit; videlicet, in Momoniam duplicem, Borealem et Australem, Lageniam, Ultoniam, et Conaciam.}’’*

 Here are the five leaders of the Firbolg who took the headship of those five provinces: Sláinge, Seangann, Gann, Geanann, and Rughruidhe. Sláinge took the province of Leinster, from Droicheadátha to Cumar-na-dtrí-n-uisge Gann takes the province of Eochaidh Abhradhruaidh, from Cumar-na-dtrí-n-uisge to Bealach Chonglais: Seangann takes the province of Cúraoi, son of Dáire, from Bealach Chonglais to Luimneach;


---

p.109




Geanann takes the province of Connacht from Luimneach to Drobhaois: Rughruidhe takes the province of Ulster from Drobhaois to Droicheadátha.
Although some antiquaries hold that it is a tripartite division which was on Ireland among the three sons of Cearmad Milbheoil of the Tuatha Dé Danann, I do not think that they divided Ireland among them, but it is my opinion that it is a permutation of the sovereignty each succeeding year which they had between them, according as we have said above, in showing why Eire is called to this country more frequently than Fodhla or Banbha.


The fourth division, that is, the division of the children of Míleadh. It is the opinion of some antiquaries that it is thus Ireland was divided between Eibhear and Eireamhón:—all that is from Athcliath and from Gaillimh southwards, and Eisgir riadha for a boundary between them, to Eibhear; and what there is from that northwards to Eireamhón. However, this is not the division which was made between them, as we shall prove hereafter; but it is thus they divided Ireland:— the two provinces of Munster to Eibhear; the province of Connacht and the province of Leinster to Eireamhón; and the province of Ulster to Eibhear, son of Ir, i.e. their brothers's son: and a party of the nobles who had come with them, in the company of each one of them in his own division of the country.


The fifth division, that is, the division of Cearmna and Sobhairce. Cearmna and Sobhairce, indeed, in [two] halves between them, namely, from Innbhear Colptha at Droichead-átha to Luimneach Mumhan, and the half which was north to Sobhairce, and he built a fortress in his own half, namely


---

p.111




Dún Sobhairce. Cearmna takes the southern half, and he built a fortress beside the south sea, namely, Dún, which to-day is called Dún, in De Courcy's country.


The sixth division, that is, the division of Ugaine Mór. Ugaine Mór divides Ireland in twenty-five parts, among the five and twenty children that he had, as we shall set down in the Roll of Kings.


The seventh division, namely, the division of Conn Céadchathach and Mógh Nuadhat. Conn and Mógh Nuadhat divided Ireland into halves between them, that is to say, all that is from Gaillimh and from Athcliath northwards, and Eisgir riadha for a boundary between them to Conn: and it is from that came Leath Chuinn to be given to the side which was north; and Leath Mhógha to Mógh Nuadhat;:and it is from that was given Leath Mhógha to the half which was south.


Notwithstanding, however, that I have set down in order these seven divisions which were made of Ireland, according to the sequence of the invasions and of the epochs, I shall return to the usual division which is on Ireland from the time of the Firbolg apart, for it is it is the most permanently established, namely, five provinces to be made of it, as we have said. And it is where the common centre of these five provinces was, at a pillar-stone which is in Uisneach, until that Tuathal Teachtmhar came, into the sovereignty, and that he took away a portion of each province as mensal land for every high-king who should be in Ireland: so that it is of these Meath was formed, as we shall show in the reign of Tuathal.




---

p.113


SECTION III.
------------


#### Of the subdivision of Meath and of the provinces here.


I shall now make the subdivision of Meath and of the provinces also; and I shall give the beginning of this division to Meath until its lands are described, because it is the mensal land of the king of Ireland, according to the Gael, and that it used to be free, without obligation, without control, without tax from any one in Ireland, except from the king of Ireland alone. Eighteen 'triochas' the extent of its land; thirty 'bailes' in the 'triocha-céd' of them; twelve 'seisreachs' of land in the 'baile', according to the ancient record, and six score acres in the 'seisreach'. Three score and three hundred 'seisreachs' of land in the triocha-céd accordingly. Four score and four hundred and six thousand 'seisreachs' of land in all Meath, according to this computation. It is why it is called Meath, because that it is from the neck of each province Tuathal Teachtmhar cut it. Or it is why Meath is called to it from Midhe, son of Brath, son of Deaghfhath chief druid of the children of Neimheadh; and it is by him was kindled the first fire in Ireland, after the coming of the children of Neimheadh; and hard by Uisneach he kindled it. The children of Neimheadh bestowed on him the 'tuath' of land which was there, and from that druid it is called Midhe. And there was not, about that time, of land in Meath, but the one tuath aforesaid, until Tuathal Teachtmhar put a 'meidhe' or neck of every province with it, as we have said.




---

p.115


Of the boundary of Meath with the provinces here, as Tuathal Teachtmhar ordained; i.e. as one goes from the Shannon east to Dublin, from Dublin to the river Righe, from the river Righe west to Cluain-Connrach, from Cluain-Connrach to Ath-an-mhuilinn-Fhrancaigh, and to the confluence of Cluain-Ioraird, from that to Tóchar Cairbre, from Tóchar Cairbre to Crannach of Géisill to Druimchuilinn, to Birr, to the river which is called Abhainnchara to the Shannon northwards, to Loch Ribh, and all the islands belong to Meath: and the Shannon to Loch-Bó-dearg, from that to Maothail, thence to Athluain, thence to upper Sgairbh, to Druimleathan, till one reaches the Magh, to the confluence of Cluain-eois, to Loch-dá-eun, to Magh Cnoghbha, to Duibhir, to Linn-átha-an-daill on Sliabh Fuaid, to Magh-an-chosnamhaigh at Cillshléibhe, to Snámh Eugnachair, to Cumar, and from Cumar to Life: as the ancient writer says—


> 1. From Loch-bó-dearg to Biorra,
>   
> from the Shannon east to the sea,
>   
> To the confluence of Ciuain-ioraird,
>   
> and to the confluence of Cluain-airde.
> 



Thirteen 'triochas' in the body of Meath itself and five 'triochas' in Breagh, as is said in these verses below—


> 1. Thirteen ‘triochas’ in Meath,
>   
> as every poet says;
>   
> Five ‘triochas’ in rich Breagh's plain—
>   
> it is a memory with the learned;
>   
> The territory of Meath I will tell to you,
>   
> and the territory of Breagh most pleasant,
>   
> From Shannon of the fair gardens to the sea—
>   
> we have known it—
>   
> The men of Teathbha on the northern border,
>   
> and Cairbre of bright victory;
>   
> With abundance of bee-swarms and of oxen,(?)
>   
> the men of Breagh (possess) as far as the Casan.
> 






---

p.117


Meath was divided after this by Aodh Oirdnidhe, king of Ireland, between the two sons of Donnchadh son of Dómhnall (who was king of Ireland before Aodh Oirdnidhe); Conchubhar and Oilioll their names. He gave the western half to one of them, and the eastern half to the other man, so that that division adhered to it from that out: and it is in it is the royal seat, Tara.


#### Of the division of the province of Connacht here.


The province of Connacht from Limerick to Drobhaois: nine hundred 'bally-betaghs' that are in it, and that is thirty 'triochas'; and thirty 'bailes' in each 'triocha-céd' of them, and twelve 'seisreachs' of land in the 'baile'. Six score acres in the 'seisreach': eight hundred and ten thousand 'seisreachs' of land in all Connacht. It is why it is called Connacht: a contention of magic which took place between two druids of the Tuatha Dé Danann, Cithneallach and Conn their names. Conn brought a great snow round about the province through art magic, so that from it was named Connacht, i.e. Conn's snow. Or it is why it is called Connacht, i.e. Conn-iochta, namely, the children of Conn, for iocht and 'clann' are equivalent: and because that they are the children of Conn who inhabited the province, that is to say, the race of Eochaidh Moighmheadhón, they are called Connachta. Eochaidh Feidhleach divides the province of Connacht in three parts among three. He gave to Fidheach, son of Fiach, of the men of the Craobh, from Fidhic to 


---

p.119




Limerick. He gave to Eochaidh Alath, Iorras Domhnann, from Galway to Dubh and to Drobhaois. He gave to Tinne, son of Connrach, Magh Sainbh, and the old districts of Taoidhe from Fidhic to Teamhair brogha-niadh: it is Cruachan was its royal seat.


#### Of the division of the province of Ulster here


The province of Ulster from Drobhaois to Innbhear Cholptha, five and thirty 'triochas'; or six and thirty that are in it. Nine score and nine hundred 'bally-betaghs' in it. Three score nine hundred and twelve thousand 'seisreachs' of land in all this province. It is why they are called Ulaidh, from this word 'oll-sháith', i.e. great plenty, signifying that Ulster is very rich with regard to fish and cattle. This verse testifies that sáith and ionnmhas (treasure) are equivalent:—


> 1. Wednesday Judas transgressed his order,
>   
> following demons vengeful-fierce;
>   
> Wednesday he became eager for treasure;
>   
> Wednesday he betrayed Jesus the exalted.
> 




Or it is wherefore they are called Ulaidh, from Ollamh Fodhla, son of Fiachaidh Fionnscothach, as this verse certifies:— 


> 1. Ollamh Fodhla of prudent valour,
>   
> from him were named (the) Ulaidh,
>   
> After the real assembly of Tara of the tribes,
>   
> it is by him it was first appointed.
> 


 
And Eamhain Mácha and Aileach Néid its royal seats.


#### Of the division of the province of Leinster here.


The province of Leinster from the strand of Innbhear Cholptha to Cumar-na-dtrí-n-uisge, thirty-one 'triochas' in 


---

p.121




it. Nine hundred and thirty 'ballybetaghs' that: eleven thousand one hundred and sixty 'seisreachs' in this whole province. It is why they are called Laighin, from the broad green spears which the Dubh-Ghaill brought with them into Ireland, when they came with Labhraidh Loingseach: laighean and sleagh are, indeed, equivalent. And because that these spears had flat broad heads to them, it is from them the province was named. After the slaying of Cobhthach Caoilbhreágh, king of Ireland in Dionnriogh, Leinster took its appellation. It is to show that it is from these spears Leinster was named, that this verse was made:—


> 1. Two hundred and twenty hundred Galls,
>   
> with broad spears with them hither;
>   
> From those spears, without blemish,
>   
> of them the Laighin were named.
> 




Two chief seats were indeed in Leinster, in which its kings used to reside, namely Dionnríogh and Nás.


#### Of the division of the province of Eochaidh Abhradhruaidh here.


The province of Eochaidh Abhradhruaidh, from Cork and from Limerick east to Cumar-na-dtrí-n-uisge; thirty-five 'triochas' in it. Ten ['ballys'] seven score and nine hundred 'bally-betaghs' that are in it. Six hundred and twelve thousand 'seisreachs' of land that are in east Munster. Two royal seats of residence the kings of this province had, namely, Dún gCrot and Dún Iasgaigh.




---

p.123


#### Of the division of the province of Cúraoi son of Dáire here.


The province of Cúaoi son of Dáire from Bealach Chonglais to Limerick, and from Limerick west to the western land of Ireland. Thirty-five 'triochas' in it: one thousand and fifty 'bally-betaghs' in that. Twelve thousand six hundred 'seisreachs' of land that are in west Munster. Two royal seats of residence the kings of this province anciently had, namely, Dún gCláire and Dún Eochair Mhaighe.


There were two races who used to be in possession of these two provinces of Munster, that is to say, the race of Dáirfhine and the race of Deirgthine, up to the time of Oilioll Ólom of the race of Deirgthine who took the chieftaincy of the two provinces, having banished from Ireland Mac Con, who was of the race of Dáirfhine. And he left the chieftaincy of the two provinces with his own posterity from that out: by way of alternation to be with the race of Eoghan mór son of Oilioll Ólom, and with the race of Cormac Cas (second son of Oilioll Ólom), every generation by turns, in the sovereignty of the two provinces of Munster.


It is the four royal seats aforesaid which were the chief mansions of residence for the kings of these two provinces till the time of Corc, son of Lughaidh, being in the sovereignty of Munster. For it is during his time Cashel became known first; and Siothdhruim was the name for the place which to-day is called the Rock of Cashel. The same place used also to be called Leac na gcéad and Druim Fiodhbhuidhe, for there were many woods round about that 


---

p.125




ridge in the time of Corc. There came, however, about that time, two swineherds to feed their hogs among the woods of this ridge, namely the swineherd of the king of Éile, Ciolarn his name, and the swineherd of the king of Musgraidhe-tíre, which is called Ur-Mhumha, Duirdre his name. They were occupying the hill during a quarter, till there was shown to them a figure which was as bright as the sun, and which was sweeter (of voice) than any music they had ever heard, and it blessing the hill and the place, and foretelling Patrick to come there. And the figure that was there was Victor, Patrick's own angel. After the swineherds had returned back to their houses, they make known this thing to their own lords. These stories having reached Corc, son of Lughaidh, he comes without delay to Síothdhruim, and he built a fortress there which was called Lios-na-laochraidhe; and on his becoming king of Munster, it is on the rock which is now called Carraig Phádraic he used to receive his royal rent. It is hence that rock is called Caiseal, for Caiseal and Cíosáil are equivalent: áil, indeed, a name for a rock; so that, therefore, that place is called Caiseal, i.e. tribute rock.


Here is an assurance on this matter, from the poem which has beginning— Cashel, city of the clans of Mogha, which Ua Dubhagáin composed:—


> 1. Corc, son of Lughaidh, warrior-like the man,
>   
> first man who sat in Cashel;
>   
> Under a thick mist was the place,
>   
> till the two herdsmen found it.
>   
> The swineherd of the king of Muskerry of the gold,(?)
>   
> Duirdre his name and it is not wrong;
>   
> And Ciolarn through the plain of rue (?),
>   
> swineherd of the worthy king of Éile.
>   
> It is they who got knowledge of the place
>   
> at first in Druim Fiodhbhuidhe.
>   
> Druim Fiodhbhuidhe without fault with you,
>   
> most dear to Corc of Cashel.
> 






---

p.127


#### Of the subdivision of Munster here.


The race of Oilioll Olom having acquired the two provinces of Munster, they divide them into five parts, which are called the five Munsters. The first part which is called North Munster, its length is from Léim Chongculainn to Slighe Dála, i.e. the great road in Osraidhe, and its breadth from Sliabh Eichtge to Sliabh Eibhlinne. And notwithstanding that all that is from Sliabh Eichtge to Limerick was in the ancient division of Connacht, yet Lughaidh Meann, son of Aonghus Tíreach, son of Fear Corb, son of Mogh Corb, son of Cormac Cas, son of Oilioll Olom, made sword-land of all that is from Eichtge to Limerick, and from the Shannon west to Léim Chongculainn, so that he annexed it to Munster: and the name it was usually called was the rough land of Lughaidh, and the Dál gCais had it free without rent, without taxing, from the kings of Ireland. The second part East Munster, its length is from Gabhran to Cnámhchoill near Tipperary, and its breadth from Béarnán Éile to Oiléan O'Bric. The third part, namely, Middle Munster, its length is from Cnámhchoill to Luachair Dheaghaidh, and its breadth from Sliabh Eibhlinne to Sliabh Caoin. The fourth part South Munster, its length is from Sliabh Caoin to the sea southwards. The fifth part West Munster, its length is from Luachair Dhea-ghaidh to the sea west, and its breadth from Gleann Ua-Ruachta to the Shannon.




---

p.129


According to Breasal Ua Treasaigh, when Munster was divided into its five parts, there were five tribes in each part, and five companies in a tribe, and five hundred effective men in the company. And if the strength of all Ireland at that time be estimated, the opinion is unsound of the people who thought that the Roman with a legion or with two legions would be able to bring Ireland under power of spear and sword to himself, [and] the Irish always being valiant men.


It is why these two provinces of Munster are called Mumha [i.e. that it is greater], because that it is greater than any other province of Ireland. For there are thirty-five 'triochas' in each province of these two provinces of Munster, and not that much in any other province in Ireland. For, allowing that thirty-six are reckoned in the province of Ulster, there were but thirty-three in it till the time of the provincial kings. For it is Cairbre Nia Fear, king of Leinster, who yielded to the province of Ulster three **triocha-céads** of Leinster (that is to say from Loch an Chúigidh to the sea), in consideration of obtaining the daughter of Conchubhar son of Neasa as his wife, as we shall relate hereafter in the body of the history.


Five [**triochas**] and nine score **triocha-céads** in all Ireland: ten [**ballys**] and two score and five hundred and five thousand **bally-betaghs** there are in it: six hundred, and six thousand, and three-score thousand **seisreachs** of land in it, according to the old division of the Gael. Understand, O reader, that the acre of the measure of the Gael is greater, twice or thrice, than the acre of the division of the Gall now.




---

p.131


#### Of the situation of Ireland here.


It is the situation which is on Ireland; Spain to the south-west side of it, France to the south-east side of it, Great Britain to the east side of it, Scotland to the north-east side, and the ocean to the north-west side and to the west side of it. And in the form of an egg it is shaped, and its foot to Scotland, north-eastwards, its head to Spain, south-westwards; and, according to Maginus, writing on Ptolemy, it is four degrees and a half of the solar zone, which is called the Zodiac, that are in its breadth; and the same man says that it is sixteen hours and three-quarters that are in length in the longest day in the year in the side of Ireland which is farthest towards the south, and eighteen hours in the longest day at the northern side. The length of Ireland is from Carn Uí Néid to Cloch an Stocáin, and its breadth from Innbhear mór to Iorrus Domhnann.


Understand, O reader, that it is not through forgetfulness that I do not mention here the counties, nor the cities, nor the great towns of Ireland; but that Camden and these new chronicles give their description down clearly, and that this is not the place for inserting them, but at the beginning of the invasion the foreigners, by whom they were arranged.




---

p.133


SECTION IV.
-----------


#### Of the creation of the first father from whom we have sprung,i.e. Adam, here, and of his race to Noah, and from that to Noahs children's children, until the genealogical account of each tribe which obtained possession of Ireland is given by us completely up to Noah; and also the kinship of each people of these same with each other.


In the beginning Adam was created, the sixth day of the age of the world: the fifteenth year of the life of Adam, Cain and his sister Calmana were born: the thirtieth year of the life of Adam, Abel and his sister Delbora were born: at the end of a hundred and thirty years of the life of Adam, Seth was born, according to the Hebrews, as is read in Polychronicon.


#### Of the age of the fathers from Adam to Noah, and the length of the period from Adam to the deluge; and the genealogy of Noah to Adam.


Noah was son of Lamech, son of Mathusalem, son of Enoch, son of Iared, son of Malaleel, son of Cainan, son of Enos, son of Seth, son of Adam: for it is of the race of Seth are all those who live after the deluge, and all the race of Cain were drowned under the deluge. And, according to the Hebrews, it is the length from the creation of Adam to the deluge, one thousand six hundred and fifty-six years; it is therefore the ancient author recited this verse:—


> 1. The first period of true life,
>   
> from when Adam is to the deluge;
>   
> Six years, fifty, a clear saying,
>   
> on six hundred, on a thousand.
> 




Here is how another antiquary agrees with the same calculation:— 
 

> 1. Six years and fifty,
>   
> and six hundred, as I count,
>   
> And a thousand, as I calculate,
>   
> from Adam to the deluge.
> 






---

p.135


Yet another ancient author agrees with the same computation:— 
 

> 1. Ten hundred years, six hundred fair,
>   
> on fifty, with six years,
>   
> As I reckon, it is known without blemish,
>   
> from the deluge to the beginning of the World.
> 




Here is the age of every man from whom Noah sprang in the direct line:—Adam thirty and nine hundred years; Seth twelve years and nine hundred; Enos five years and nine hundred; Cainan ten years and nine hundred; Malaleel nine hundred but five years wanting of them; Jared two years and three score on nine hundred; Enoch five years and three score on three hundred; Mathusalem nine years, three score, on nine hundred; Lamech seventeen years, three score, on seven hundred; Noah ten years, two score, on nine hundred.


Here is the assurance of the ancient writer on the age of every patriarch of them, as is read in the poem which has for beginning:— Father of all, Ruler of Heaven, &c.:—


> 1. Thirty (and) nine hundred fair years,
>   
> The life of Adam to be narrated;
>   
> Ten years together with all that (was)
>   
> The age ofhis yellow-haired wife:
> 2. The life of Seth, that is known to me,
>   
> Twelve (years) and nine hundreds;
>   
> Five years nine hundred, it has been heard,
>   
> Until death took away Enos;
> 3. Ten years nine hundred, without reproach,
>   
> The age of the son of Enos,
>   
> Cainan: Nine hundred but five, with renown,
>   
> The life of Malaleel of mighty deed;
> 4. Two years, sixty, (and) nine hundred,
>   
> To Jared before going to death;
> 
> 
> ---
> 
> p.137
> 
> 
> Three hundred, sixty, (and) five, it has been heard,
>   
> For Enoch before going into Paradise:
> 5. Nine years sixty, with renown,
>   
> And nine hundred of years,
>   
> That is the life, glorious,
>   
> Which was given to Mathusalem;
> 6. The life of Lamech, it is mentioned to thee,
>   
> Seven hundred, seventy, and seven:
>   
> The life of Noah, pure bright his fame,
>   
> Fifty and nine hundred years.
> 




When, indeed, God saw the race of Seth transgressing his own covenant, where he had commanded them not to make intermixture or alliance with the race of the wicked Cain, and that they had not observed that injunction, he sent a deluge to drown all the people, except Noah and his wife, whose name was Coba, and his three sons, Sem, Cham, and Japheth, and their three wives, Olla, Oliva, and Olivana: for Noah had not mixed with the race of Cain, and he was righteous. After the subsiding of the deluge, Noah divides the three parts of the world among his three sons, as the antiquary says:—


> 1. Sem took his place in Asia;
>   
> Cham with his children in Africa;
>   
> The noble Japheth and his sons,
>   
> It is they who obtained Europe.
> 




#### Of the genealogical account of those three sons from whom were sprung the seventy-two tribes who were building the tower.


Twenty-seven sons had Sem, including Arphaxad, Asshur, and Persius; and it is from his seed (came) the Hebrews. Thirty sons had Cham, and of those were Cus and Canaan.


---

p.139




Fifteen from Japheth, and of those were Gomer and Magog. Here is a **rann** certifying those kindreds to have come from the three sons of Noah:—


> 1. Thirty gentle sons, a clear fact,
>   
> Sprang from Cham, son of Noe;
>   
> Seven and twenty are from Sem,
>   
> Fifteen (are) from Japheth.
> 




Many of the people of Asia, and the people of all Europe have descended from Japheth. The people of Scythia are of the posterity of Magog, son of Japheth, and especially the tribes who occupied Ireland after the deluge, before the sons of Mileadh, as we shall show in (relating) the invasions of Ireland after the deluge. Nevertheless, we shall set down here at first, concerning the invasions of Ireland before the deluge, according to some antiquaries, before we shall treat of the real occupation of it which was made after the deluge.


SECTION V.
----------


#### Of the invasions of Ireland before the deluge down here.


I. Some say that it is three daughters of the wicked Cain who inhabited it at first, so to certify that I have set down here a verse out of the poem which commences I found in the Saltair of Cashel:— 
 

> 1. Three virgin daughters of Cain,
>   
> With Seth, son of Adam,
>   
> They first saw Banbha,
>   
> Banbha, I remember their adventure.
> 






---

p.141


The book of Dromsneachta says that Banbha was the name of the first maiden who occupied Ireland before the deluge, and that Ireland is called Banbha from her. Thrice fifty women came there, and three men: Ladhra was the name of one of them, and it is from him Ard Ladhrann is named. Two score years they were in the island, till a plague fell on them, so that they all died in one week. Ireland after that, was desert, empty, without anyone alive in it, for two hundred years till after that came the deluge.


II. Some others say that it is three fishermen who were driven by a storm of wind from Spain unwillingly; and as the island pleased them that they returned for their wives to Spain; and having come back to Ireland again, the deluge was showered upon them at Tuaigh Innbhir, so that they were drowned: Capa, Laighne, and Luasad, their names. It is about them the verse was sung:—


> 1. Capa, Laighne, and Luasad pleasant,
>   
> They were a year before the deluge
>   
> On the isle of Banbha of the bays;
>   
> They were eminently brave.
> 




III. It is said, however, that it is Ceasair, daughter of Bioth, son of Noe, who came there before the deluge, so the verse was made about it:—


> 1. Ceasair, daughter of lasting Bioth,
>   
> Foster-child of Sabhail, son of Nionuall;
>   
> The first valiant woman who came
>   
> To the isle of Banbha before the deluge.
> 






---

p.143


If one should wish, indeed, to obtain knowledge what brought her to Ireland:—Bioth had sent a messenger to Noe, to know whether he himself and his daughter Ceasair would obtain a place in the ark to save them from the deluge; Noe says they should not get (that). Fionntain asks the same, and Noe says he should not get it. Whereupon Bioth, Fionntain and the maiden Ceasair go to consult. ‘Let my advice be followed by you’, says Ceasair. ‘It shall be done,’ say they. ‘Well then,’ says she, ‘take to ye an idol, and adore him, and forsake the God of Noe.’ After that they brought with them an idol, and the idol told them to make a ship, and put to sea: although he did not know what time the deluge would come. A ship was fitted, accordingly, by them, and they went to sea. Those who went into it were three men, namely, Bioth, Fionntain, and Ladhra: (also) Ceasair, Barrann, and Balbha, and fifty maidens along with them. Seven years and a quarter for them on the sea, until they put into port at Dún na mbarc, in the district of Corca Dhuibhne, the fifteenth day of the moon, as the antiquary says:—


> 1. It is there they took harbour
>   
> At Dún na-mbarc, the female company,
>   
> In Cúil Ceasrach, in the district of Carn,
>   
> The fifteenth, (being) Saturday.
> 



And that was forty days before the deluge, as is said:— 


> 1. Two score days before the deluge,
>   
> Ceasair came into Ireland,
>   
> Fionntain, Bioth, and Ladhra fierce,
>   
> And fifty beautiful maidens.
> 






---

p.145


Another poet agrees with the same thing, where he says in this verse:— 
 

> 1. Ceasair set out from the east—
>   
> Daughter of Bioth was the woman—
>   
> With her fifty maidens,
>   
> And with her three men.
> 




A ship's company were on that expedition to Dún na mbarc: Ceasair, and her ships lading, came to land there; namely, fifty women and three men, i. e. Bioth and Fionntain, and Ladhra, as we have said. It was that Ladhra, as we have said, who was the first dead person of Ireland, according to the folk who say that no people at all occupied Ireland before the deluge, but Ceasair and those who came with her. And from him is named Ard Ladhrann. From Bioth Sliabh Beatha is named; and from Fionntain is named Feart Fionntain over Tultuinne in Duthaigh Aradh, near to Loch Deirgdheirc. From Ceasair is named Carn Ceasrach in Connacht. They proceed thence to Bun Suaimhne, i.e. Cumar na dtri-n-uisge, where is the junction of Suir and Nore and Barrow. There they share their fifty women in three parts among them. Fionntain took Ceasair with him, and seventeen women along with her. Bioth took Barrann with him, and seventeen other women in her company: and Ladhra took Balbha with sixteen women likewise with him, till he reached Ard Ladhrann, and died there. Balbha and her sixteen women return to Ceasair again. Ceasair sends tidings to Bioth. Bioth comes to acquaint Fionntain, so that they shared those sixteen women equally between them. Bioth brought his own share of them with him to Sliabh Beatha in the north of Ireland, and it was


---

p.147




not long afterwards until he died there. As for these women of Bioth, they come to Fionntain after that. Howbeit, Fionntain flies before them from Leinster, across Bun Suaimhne, across Sliabh gCua into Ceann Feabhrad of Sliabh Caoin, and with left hand towards the Shannon east to Tultuinne over Loch Deirgdheirc. Ceasair goes with her female company to Cúil Ceasrach in Connacht, till her heart broke through being in estrangement from her husband, and through the death of her father and of her brother: and there were not then from her to the deluge but six days. So to attest that, this verse was spoken:— 
 

> 1. It is those—after appointed time—
>   
> Their deaths, their proceedings;
>   
> There was not, but a week alone,
>   
> From them to the forty (days' rain).
> 




IV. Know, O reader, that it is not as genuine history I set down this occupation, nor any occupation of which we have treated up to this; but because I have found them written in old books. And, moreover, I do not understand how the antiquaries obtained tidings of the people whom they assert to have come into Ireland before the deluge, except it be the aerial demons gave them to them, who were their fairy lovers during the time of their being pagans; or unless it be on flags of stones they found them graven after the subsiding of the deluge, if the story be true: for it is not to be said that it is that Fionntain who was before the deluge who would live after it, because the Scripture is against it, where it says that


---

p.149




there did not escape of the human race, without drowning, but the eight persons of the ark alone, and it is clear he was not of those. The argument is unsound which some antiquaries have concerning Fionntain to have lived during the deluge, where they said that there lived four in the four quarters of the world during the time of the deluge, namely, Fionntain, Fearon, Fors, and Andoid. However, think not, O reader, that this is the opinion of the people who are most authoritative in history. Therefore, a certain author sets this thing before us in a poem, to show that it does not accord with the truth of the faith to say that Fionntain or any of the other three should live after the pouring forth of the deluge and before it. Here is the poem:—


> 1. The names of four—in right resolved—
>   
> Whom God left (safe) throughout the deluge,
>   
> Fionntain, Fearon, Fors, just, gentle,
>   
> And Andoid, son of Eathor.
> 2. Fors in the eastern land, east, was allowed;
>   
> Fearon for [northern] coldness (in need) of clothing;
>   
> Fionntain for the west limit fairly
>   
> And Andoid for the southern part.
> 3. Though antiquaries record that,
>   
> The just canon does not record
>   
> But Noe who was in the ark, and his children,
>   
> And their wives, who obtained protection of their lives.
> 




Whence it is understood that it is not the common opinion of all the antiquaries, any of these to have lived after the deluge: however, if any antiquary should say, as a safeguard against perverting the faith, that Fionntain, a man like the rest, was drowned under the deluge, and that he was revived


---

p.151




by God after that, to save and to keep the proceedings of the ancients, with their stories, to the time of Patrick, and after that to the time of Finnian of Magh Bile; I do not understand how it would be possible to conceal throughout Europe so wonderful a thing as this, [seeing] the frequency, during the time of Finnian, and from that forth, [with which there] went accomplished parties of divines and philosophers, and many of other learned wise people from Ireland through the principal countries of Europe to instruct the clergy and congregations, and to teach public schools; and (yet) to say that there would not be [in their track] after them some disciple by whom would be left a poem or a letter in which there would be a mention or a narrative concerning Fionntain; and [considering also] the frequency that they wrote other things which are now to be seen, and, moreover, that I do not see any narrative about him in their chief authentic books: and, accordingly, I think that there is nothing but a poetical romance in the history which would relate Fionntain to have lived before the deluge and after it. However, I do not say that there was not a very aged and wise man before the coming of Patrick to Ireland, and that he lived many hundred years, and that he related to Patrick everything which he remembered, and moreover every tradition which he had got from the ancestors concerning the times which had elapsed before him: and I think that there was his like of an elder, who was called Tuan son of Caireall according to some antiquaries, and according to others Roanus, that is Caoilte son of Rónán, who lived more than three hundred years, and who made known to Patrick much of antiquity, as


---

p.153




is evident in the Dialogue of the Ancients; and it is [on] Caoilte that it is right to call Roanus or Ronanus. For it is not read in any book of the history of Ireland that Fionntain was called Roanus or Ronanus: Even though it is on him Cambrensis puts the name like every other lie of his partial history, and as he set down Roanus in his chronicle in place of Ronanus, every one of the new Galls who writes on Ireland, writes Roanus, in imitation of Cambrensis, as a name for Fionntain, because it is Cambrensis who is as the bull of the herd for them for writing the false history of Ireland, wherefore they had no choice of guide. It is the more right to think that it is to Caoilte Ronanus is given, since ancient authors set down among the works of Patrick that he wrote A History of Ireland, from Roanus or Ronanus: it is, indeed, the surname of the author which it is the custom to put over the head of every work which anyone writes, as is clear to every reader who practises reading authors.


And it is not true for **Hanmer** in his chronicle, where he says that the Gaels hold in great esteem the stories of Fionntain, whom he himself calls Roanus, where they say that he was hidden from the deluge, and that he lived after it more than two thousand years till he met with Patrick, and that he received baptism from him, and that he made known to him much of antiquity, and that he died at the end of a year after the coming of Patrick into Ireland, and that he was buried beside Loch Ribh in Urmhumha, where there is a church named or dedicated in his name, and, moreover, that he is named among the saints of Ireland. Nevertheless, it is clear that an antiquary never said, and also that he never left written this thing **Dr. Hanmer** says. For there are three persons being mentioned here in the guise of one man,


---

p.155



 

namely, Fionntain, whom Cambrensis calls Roanus, i.e. Caoilte, son of Rónán, who was baptised by Patrick, and gave much of ancient record to him; and Ruadhan, to whom Lothra in Urmhumha was dedicated (it is beside Loch Deirgdheirc and not, as **Hanmer** says, beside Loch Ribh): and Tuan, son of Caireall. We shall not follow any more of the lies of **Hanmer**, or of the authority he has. Moreover, I think that it is instead of this word Ronanus Cambrensis wrote Roanus at first, and that it was left without amendment by his followers from that forward.


SECTION VI.
-----------


#### I. Of the first occupation that was made on Ireland here.


According to some antiquaries, there came a youth of the family of Nin son of Bél (whose name was Adhna son of Bioth) to spy Ireland about seven score years after the deluge. However, it was not long the stay he made in it. He went back to give an account of the island he, had seen, to his neighbours, and with him a part or certain bulk of the grass of Ireland, as is read in the poem (to which is) beginning, I found in the Saltair of Caiseal, &c. [Here is what the poem says.]
 

> 1. Adhna, son of Bioth, with prophecy (?)
>   
> A warrior of the family of Nin son of Bél,
>   
> Came into Ireland to explore it,
>   
> So that he plucked grass in wood island:
> 2. He brought with him the full of his fist of its grass,
>   
> He goes back to tell the news:
>   
> That is the clear complete possession,
>   
> Shortest in duration which occupied Ireland.
> 






---

p.157


Howbeit, I do not think that the expedition of that man ought to be called a conquest, because he did not make any stay in it, and therefore that it is more right to reckon the conquest of Partholón as the first occupation of it after the deluge.


####  II. Of the first chief-conquest which was made on Ireland after the deluge, namely the invasion of Partholón, here.


Ireland, indeed, was desert three hundred years after the deluge, till Partholón, son of Sera, son of Sru, son of Esru, son of Fraimint, son of Fathacht, son of Magog, son of Japheth came to occupy it, according as it is found in the poem [to which is] beginning,— Adam, father, fountain of our hosts [as the poet says]:— 


> 1. Three hundred years after the deluge,
>   
> It is a tale of truth, as I reckon,
>   
> All holy Ireland was desert,
>   
> Until Partholón came.
> 




Accordingly, I think that it is twenty-two years before Abraham was born, Partholón came into Ireland, and that it is it which was the age of the world therefore, about this time a thousand, nine hundred and three score and eighteen years, as this verse states:— 
 

> 1. Eight and seventy—a clear gradation—
>   
> A thousand and nine hundred years,
>   
> From the time of Adam, virtuous, just,
>   
> To the birth of Abraham our father.
> 




However, the opinion of the people who say that it is at the end of two years and a thousand after the deluge that Partholón came to Ireland, is not truthful, and they, admitting that it is in the time of Abraham he came into it, and that it is Abraham, who was only the eighth generation from Sem,


---

p.159




son of Noe, and Sem himself to be reckoned. For it is not likely that more than a thousand years would have been spent during the time of seven generations after the deluge. Wherefore I deem the former opinion more sound than the latter opinion; and, accordingly, it is probable that it was at the end of three hundred years after the deluge Partholón came into Ireland.


From middle Greece, i.e. **Migdonia**, Partholón set out. It is the way which he took (was) through the **Torrian Sea** to Sicily, and with the right hand towards Spain till he reached Ireland. Two months and a half he was on the sea till he took harbour in Innbhear Sceine, in the western part of Munster, the fourteenth day in the month May. It is of it this verse was recited [as the poet says]:—


> 1. The fourteenth, on (day of) Mars,
>   
> They put their noble barks
>   
> Into the port of fair lands, blue, clear,
>   
> In Innbhear Scéine of bright shields.
> 




Here is the company who came with Partholón to Ireland, and with his wife, Dealgnaid her name: their three sons, namely, Rudhruidhe, Slangha, and Laighlinne, with their wives, and a thousand of a host along with them, according to Nennius, as is read in the Saltair of Caiseal.


It is the place where Partholón dwelt at first in Ireland, in Inis Saimher, near to Eirne. It is why it was called Inis Saimher; a lap-dog or hound-whelp which Partholón had, which was named Saimher; and he killed it through jealousy with his wife, who committed misconduct with her own


---

p.161




attendant, Todhga; and when Partholón accused her, it is not an apology she made, but said it was fitter the blame of that ill-deed to be on himself than on her: and she said these words: ‘O Partholón,’ says she, ‘do you think that it is possible a woman and honey to be near one another, new milk and a child, food and a generous person, flesh meat and a cat, weapons or implements and a workman, or a man and woman in private, without their meddling with each other’: and she repeats the verse:—


> 1. Honey with a woman, new milk with a child,
>   
> Food with the generous, flesh with a cat,
>   
> A workman in a house, and edge tools,
>   
> One with the other, it is great risk.
> 




After Partholón had heard that answer, his jealousy was so increased by it that he struck the dog to the ground, till it was killed: so that from it the island is named. The first jealousy of Ireland after the deluge (was) that. So for it was recited this verse:—


> 1. The king strikes the hound of the woman
>   
> With his hand—it was not sad that it was (so):— ?
>   
> The hound was dead (...)
>   
> That was the first jealousy of Ireland.
> 




The seventh year after the occupation of Ireland by Partholón, the first man of his people died, namely, Feadha, son of Tortan, from whom is named Magh Feadha.


It is the cause on account of which Partholon came to Ireland, because he had slain his father and his mother, seeking the kingdom from his brother, so that he came in flight (because


---

p.163




of) his parricide till he reached Ireland, so that it is therefore God sent a plague on his race, by which nine thousand of them were slain during one week in Beann Eadair.


Some of our authors reckon another occupation of Ireland before Partholón, namely, the invasion of Cíocal, son of Nel, son of Garbh, son of Ughmhóir, from Sliabh Ughmhóir, and Lot Luaimhneach (was) his mother: they (were) two hundred years (living) on fish and fowl till the coming of Partholón into Ireland, till the battle of Magh Iotha took place between them, in which Cíocal fell, and in which the Fomorians were destroyed by Partholón. In Innbhear Domhnann Cíocal, with his people, took harbour in Ireland: six ships their number; fifty men and fifty women the complement of each ship [of them]. It is about them it is recited:—


> 1. The seventh invasion which took
>   
> Spoil of Ireland of the high plains
>   
> (Was) by Ciocal the stunted, (of withered feet),
>   
> Over the fields of Innbhear Domhnann;
> 2. Three hundred men, the number of his host,
>   
> Who came from the regions of Ughmhór
>   
> Till they were scattered after that,
>   
> Being cut off in a week.
> 




Seven lakes burst forth in Ireland in the time of Partholón, namely, Loch Masc in Connacht; over Magh Leargna it sprang up: at the end of three years after giving battle to Cíocal, Loch Con burst over the land, and Magh Cró (was) the name of the plain over which it came: Loch Deichet at the end of twelve years after the coming of Partholón into Ireland. A year after that the fourth chieftain of his people


---

p.165




died, namely, Slangha, and it is at Sliabh Slangha he was buried. At the end of a year after that (was) the eruption of Loch Laighlinne in Ua-mac-Uais Breagh, i.e. (the lake of) Laighlinne, son of Partholón; and when his sepulchre was being built, the lake sprang forth from the earth, it is from that it is called Loch Laighlinne. At the end of a year after that (was) the eruption of Loch Eachtra, between Sliabh Mudhairn and Sliabh Fuaid, in Oirghialla. After that, the eruption of Loch Rudhruidhe, in which Rudhruidhe himself was drowned. In the same year the eruption of Loch Cuan.


Partholón did not find before him in Ireland but three lakes and nine rivers: the names of the lakes (are) Loch Luimneach in Desmond, Loch Foirdhreamhain at Tráigh-lí, by Sliabh Mis in Munster, and Fionnloch Ceara in Iorros Domhnann in Connacht. It is for them this verse was recited [as the poet says]:


> 1. Three lakes—wondrous their brilliancy,
>   
> And nine plentiful rivers;
>   
> Loch Foirdhreamhain, Loeh Luimnigh,
>   
> Fionn Loch beyond the bounds of Iorros.
> 




Here are the rivers:— The Buas, between Dal n-Áruidhe and Dalriada, i.e. the Rúta; the Rurthach, i.e. Abhann Life, between the Ui Neill, and the Leinstermen; Laoi, in Munster, through Muscraidhe to Cork; the Sligeach; the Samhaoir; the Muaidh in Connacht, through Ui Fiachrach


---

p.167




of the north; the Moghurn in Tír Eoghain; the Fionn, between Cinéal Eoghain and Cinéal Conaill; and the Banna, between Lí and Eille; as is said in the poem to which (this) is the beginning, Ye learned of the plain of fair gentle Conn:— 
 

> 1. Muaidh, Sligeach, Samhaoir of name (?)
>   
> Buas, a torrent of melodious sound;
>   
> Moghurn, Fionn, with face of brightness;
>   
> Banna, between Lí and Eille.
> 


 
Or yet in the poem which has for beginning, Adam, father, fount of our hosts, &c.:—


> 1. Laoi, Buas, Banna, lasting Bearbha,
>   
> Samhaoir, Sligeach, Moghurn, Muaidh,
>   
> And Lifé in Leinster with them,
>   
> There they are, the old rivers.
> 




At the end of four years after the eruption of Murthol, Partholón died in Sean-mhagh Ealta Eudair, and it is there he was buried. It is called Sean-mhagh, ‘old plain’, because a wood never grew on it; and, moreover, it is why it is called Magh n-Ealta, as it was there the birds of Ireland used to come to bask in the sun. At the end of thirty years from the coming of Partholón to Ireland, he died. Some antiquaries say that the age of the world when Partholón died was two thousand six hundred and twenty-eight years: nevertheless, what I think is, according to everything we have said before, that it is one thousand nine hundred and four score and six years from the beginning of the world to the death of Partholón.


---

p.169




Some others say that it is five hundred and twenty years from the death of Partholón to the plague of his people: however, the general opinion of the antiquaries is against that, since they say that Ireland was not a desert but thirty years [the time which] was from the death of Partholón's people to the coming of Neimheadh into it, as the poet says in this verse:—


> 1. During thirty years of a period
>   
> It was empty of (its) skilled warriors,
>   
> After the destruction of its host in a week,
>   
> In crowds upon Magh n-Ealta.
> 




Holy Cormac son of Cuileannan agrees with the same thing in the Saltair of Caiseal, where he says that it is three hundred years (that) were from the coming of Partholón into Ireland to the plague of his people. The poet Eochaidh Ua Floinn agrees with it likewise, according to this verse:—


> 1. Three hundred years, who know it?
>   
> Over very great [or wide] excellent corn-lands, (?)
>   
> The rank sharp-pointed stalks [or weeds] (?)
>   
> (Were) in noble Erin grass-grown.
> 




From all these things (it appears that) those who say that there was more than five hundred years from the death of Partholón till the destruction of his people, are not to be believed; and it is not probable that Ireland could have been settled so long, without more people in it than five thousand men and four thousand women.




---

p.171


#### III. Here is the division which the four sons of Partholón made on Ireland; and it is the first partition of Ireland.


Er, Orba, Fearón, and Feargna their names, and there were four their namesakes among the descendants of Míleadh, as we shall set down in (relating) their special conquest.


From Aileach Néid (in the) north to Áthcliath Laighean, the portion of Er.


From the same Áthcliath to Oiléan Árda Neimeadh [to] which is called Oiléan Mór an Bharraigh now, the portion of Orba.


From the Oiléan Mór to Meadhraidhe by Gaillimh, the division of Fearón.


From Áthcliath Meadhraidhe to Aileach Néid, the portion of Feargna, as Eochaidh Ua Floinn says in these verses: and he was the chief professor of poetry in Ireland in his time:—


> 1. Four sons, (who) were fierce of voice,
>   
> For noble children had Partholón:
>   
> They took under direction among them
>   
> The tribes of Ireland without objection:
> 2. Not easy to the kings was their division,
>   
> The island of Erin (being all) one wood,
>   
> Treasure close (? safe) in each dwelling during their time;
>   
> Each man got knowledge of his share.
> 3. Er, their eldest, (who) was free in happiness,
>   
> Pleasant his portion, long without change;
>   
> From Aileach Néid, land without treachery,
>   
> To Áthcliath Laighean full-strong.
> 4. From Áthcliath of Leinster—leap of the sea—
>   
> To the isle of Neimheadh's Height,
>   
> Without misery—not weak his conduct—
>   
> (Was) Orba's portion of the land of his race.
> 
> 
> ---
> 
> p.173
> 
> 7. From the ford where Neimheadh was slain
>   
> To Meadhraidhe of the great districts,
>   
> A cause of good content without cease there,
>   
> The portion of Fearón, long the tract.
> 8. From Meadhraidhe, (it is) long also,
>   
> To Aileaeh Néid of good customs,
>   
> If we follow the boundary in every track;
>   
> Feargna got an extensive tract.
> 9. On Erin itself, not a cause of deceit (this),
>   
> Were born the strong men (whom) I enumerate,
>   
> A noble company, who were established in fame,
>   
> Gentle (and) knightly were the four.
> 




#### IV. Of the people of Partholón here.


Here are the names of the ploughmen he had, namely, Tothacht, Treun, Iomhas, Aicheachbhéal, Cúl, Dorcha, and Damh. The names of the four oxen they had, namely, Liag, Leagmhagh, Iomaire, and Eitrighe. Beoir (was) the name of the man who gave out free entertainment or hospitality at first in Ireland. Breagha, son of Seanbhoth (it was) who established single combat first in Ireland. Samaliliath first introduced ale-drinking in it. Fios, Eolus and Fochmorc (were) his three druids. Macha, Mearan, and Muicneachán, his three strong-men. Biobhal and Beabhal his two merchants. Partholón had ten daughters and ten sons-in-law.


Section VII.
------------


#### Of the second conquest which was made on Ireland here, i.e. the conquest of the children of Neimheadh.


Ireland, indeed, was waste thirty years after the destruction of the race of Partholóon, till Neimheadh son of Agnoman, son of Pamp, son of Tat, son of Seara, son of Srú, son of 


---

p.175




Easrú, son of Framant, son of Fathacht, son of Magog, son of Japheth, came to settle in it: for every invasion which occupied Ireland after the deluge is of the children of Magog. At Srú, son of Easruacute;, Partholóon and the children of Neimheadh separate from each other: and at Seara the Firbolg, the Tuatha Dé Danann, and the sons of Míleadh separate. And it is the Scotic language every tribe of these had. That is evident from (the occasion) when Ith, son of Breogan, came into Ireland; for it is through the Scotic language he himself and the Tuatha Dé Danann spoke with each other; and they said that they were of the race of Magog on both sides. Some others say, as for Neimheadh, that he was of the posterity of the son, Adhla his name, whom Partholóon had left in the east. It is the track in which Neimheadh journeyed, coming into Ireland from Scythia on the narrow sea which reaches from the ocean called Mare Euxinum,—it is it (i.e. the narrow sea) which is the boundary between the north-west side of Asia and the north-east side of Europe,— and at the north-west part of Asia are the mountains of Riffé, according to Pomponius Mela, on the boundary line of the narrow sea we have mentioned and the northern ocean. He gave his right hand to the mountains of Riffé, till he came into the ocean to the north, and his left hand towards Europe till he came to Ireland. Thirty-four ships (was) the number of his fleet, and thirty persons in every ship of them.


Starn, Iarbhoinel Fáidh, Ainninn, and Fearghus Leithdhearg (are) the names of the four sons of Neimheadh.




---

p.177


Four lake-eruptions in Ireland in the time of Neimheadh, namely, Loch mBreunainn on Mágh n-Asail in Ui Nialláin: Loch Muinreamhair on Mágh Sola among the Leinstermen: at the end of ten years after Neimheadh had arrived in Ireland, Loch Dairbhreach and Loch n-Ainnin sprang up in Magh Mór in Meath: for when the grave of Ainnin was dug, it is then Loch Ainnin sprang forth. It is in proof that it was in Neimheadh's time these lakes burst forth that this verse was made:—


> 1. Four lakes of abundant water
>   
> Burst forth over Fodhla truly great:—
>   
> Loch Dairbhreach, Loch mBreunainn sweet sounding,
>   
> Loch Muinreamhair, Loch n-Ainnin.
> 




The wife of Neimheadh—Macha her name—died in Ireland sooner than Ainnin; and the twelfth year after their coming into Ireland this Macha died; and she was the first dead person of Ireland after the coming of Neimheadh into it. And it is from her Árd Macha is named; for it is there she was buried. Two royal forts were built by Neimheadh in Ireland, namely, Rath Chinneich in Uí Nialláin, and Rath Ciombaoth in Seimhne. The four sons of Madán Muinreamhar of the *Fomorians* built Rath Cinneich in one day, Bog, Robhog, Ruibhne, and Rodan their names: and Neimheadh slew them on the morrow in the morning, in Daire Lighe, for fear that they should resolve on the destruction of the fort again; and they were buried there.


Twelve plains were cleared from wood by Neimheadh in Ireland; namely, Magh Ceara, Magh Neara, Magh Cuile Toladh, Magh Luirg in Connacht, Magh Tochair in Tír


---

p.179




Eoghain, Leacmhagh in Munster, Magh mBreasa, Magh Lughaidh in Ui Tuirtre, Magh Seireadh in Teathbha, Magh Seimhne in Dáll n-Áruidhe, Magh Muirtheimhne in Breagh, and Magh Macha in Oirghialla.


Neimheadh won three battles on the Fomorians, namely, navigators of the race of Cham, who fared from Africa; they came fleeing to the islands of the west of Europe, and to make a settlement for themselves, and (also) fleeing the race of Sem, for fear that they might have advantage over them, in consequence of the curse which Noe had left on Cham from whom they came; inasmuch as they thought themselves to be safe from the control of the posterity of Sem by being at a distance from them: wherefore, they came to Ireland, so that the three battles aforesaid were won over them, i.e. the battle of Sliabh Bádhna; the battle of Ross Fraocháin in Connacht, in which there fell Gann and Geanann, two leaders of the Fomorians; and the battle of Murbholg in Dalriada, i.e. the Rúta, the place where Starn son of Neimheadh fell by Conaing son of Faobhar in Leithead Lachtmhaighe. Moreover, he fought the battle of Cnámhros in Leinster, where there was a slaughter (made) of the men of Ireland, including Artur, son of Neimheadh, i.e. a son born in Ireland to him; and including Iobcan son of Starn, son of Neimheadh. However, it is by Neimheadh these three battles were won over the Fomorians, as these verses below certify:—
 

> 1. Neimheadh defeated—illustrious his strength—
>   
> (Their sepulchre was satiated I think),
>   
> Gann and Geanann, by his attack.
>   
> They were slain by him, one after the other.
> 
> 
> ---
> 
> p.181
> 
> 4. Geanann by Neimheadh was worn out.
>   
> Their little grave—what tomb is greater (than it)?—
>   
> By Starn, son of Neimheadh the mighty,
>   
> Gann fell, and it is not deceit.
> 5. The battle of Murbholg—he fought it—
>   
> Till it was closed, it was stiff,
>   
> It was won by Neimheadh of the arms,
>   
> Though Starn came not back (from it).
> 6. During the battle of Cnamhros, which was very great,
>   
> It is much there was of hacking of flesh;
>   
> Artur and Iobcan fell there,
>   
> Although in it Gann was routed.
> 




After that Neimheadh died of the plague in Oiléan Árda Neimheadh in Críoch Liatháin in Munster, which is called Oiléan Mór an Bharraigh; and two thousand (of) people with him, both men and women.


There was slavery and great oppression afterwards on the race of Neimheadh by the Fomorians, revenging the battles which Neimheadh had gained over them. Morc, indeed, son of Deileadh, and Conaing, son of Faobhar, from whom is named Tor Conaing on the border of Ireland north [who] had a fleet, and they residing in Tor Conaing which is called Toirinis, enforcing a tribute on the children of Neimheadh: and the extent of that tribute was two thirds of the children, and of the corn, and of the milch-kine of the men of Ireland, to be offered to them every year on the eve of **Samhain** at Magh gCéidne between the Drobhaois and the Eirne. It is why it is called Magh gCéidne from the frequency (with which) the tribute was brought to the same plain.


The Fomorians had still more tyranny on the children of Neimheadh, to wit, three full measures from every single


---

p.183




household in Ireland of the cream of milk, of the flour of wheat, and of butter, to be brought to Morc and to Conaing to Toirinis; and a female steward who was called Liagh, enforcing that tax throughout Ireland, so that of that tax this verse was recited:—


> 1. That tax which was devised there,
>   
> Three measures which were not very scant;
>   
> A measure of the cream of rich milk,
>   
> And a measure of the flour of wheat,
>   
> The third obligation—we think it was hard—
>   
> A measure of butter over it for a condiment.
> 




Anger and rage indeed seize upon the men of Ireland by reason of the heaviness of that tribute and tax, insomuch that they went to do battle with the Fomorians. It is wherefore they used to be called Fomorians, namely, from their being committing robbery on sea: Fomhóraigh, i.e. along the seas.


There were, however, three good warriors among the children of Neimheadh at this period, namely, Beothach, son of Iarbhoineol the prophetic, son of Neimheadh; Fearghus the red-sided, son of Neimheadh; and Earglan, son of Béoan, son of Starn, son of Neimheadh, with his two brothers, namely, Manntán and Iarthacht: and their number was thirty thousand on sea, and the same number on land, as this verse shows:—


> 1. Three score thousand,—bright array—
>   
> On land and on water;
>   
> It is the number went from their dwelling
>   
> The race of Neimheadh to the demolition (of the tower).
> 




The tower was demolished then, and Conaing falls with his children by the race of Neimheadh. Afterwards, Morc, son of Deileadh, brought the crew of three score ships from Africa to Toirinis, till he gave battle to the children of


---

p.185




Neimheadh, so that they fell side by side, and that everyone of them who was not slain was drowned, but Morc and a few of his company who took possession of the island: for they did not perceive the sea coming under them with the obstinacy of the fighting, so that there escaped not of the race of Neimheadh (as many of them as were in this warfare) but the crew of one bark, in which were thirty strong men, including three chiefs, namely, Simeon Breac, son of Starn, son of Neimheadh; Iobath, son of Beothach, son of Iarbhoineol Fáidh, son of Neimheadh; and Briotán Maol, son of Fearghus Leithdhearg, son of Neimheadh, as the verse says:—


> 1. But one bark with its full company,
>   
> There escaped not of them, the entire of their hosts:
>   
> Simeon and Iobath good,
>   
> And Briotán Maol, in that ship.
> 




On their coming away from that conflict, it is the counsel on which they resolved, to fare from Ireland to fly the tyranny of the Fomorians. They were seven years making ready towards this adventure; and a fleet is prepared by each chief of them, and a party of the people who had come with Neimheadh to Ireland, and of his descendants, go with each one of the aforesaid chiefs; and some of them remain behind in Ireland, namely, ten warriors whom they left taking the headship of the remnant of the race of Neimheadh who remained under servitude of the Fomorians till the time of the Firbolg.


A chief of the three above (named), viz. Simeon Breac, son of Starn, goes to Greece, even to Thrace, and a company with him; it is there they were under bondage, and it is from him the Firbolg have come, as we shall say hereafter.




---

p.187


The second chief, namely, Iobáth, son of Beothach, goes into the regions of the north of Europe; and some antiquaries say that it is to 'Boetia' he went: it is from him the Tuatha Dé Danann have descended.


The third chief, i.e. Briotán Maol goes with a company with him to Dobhar and to Iardhobhar in the north of Scotland, so that he himself and his posterity after him dwelled there. It is the total of the fleet these chiefs, the children of Neimheadh, (had) on this expedition, between ship, bark, skiff, and small boat, one thousand one hundred and thirty vessels.


However, Briotán, son of Fearghus Leithdhearg, son of Neimheadh, and his posterity, were inhabiting the north of Scotland until the Crutheni, i.e. the Picts, went from Ireland to dwell in Scotland in the time of Eireamhón. Holy Cormac, son of Cuileannan, in his Saltair, says that it is from Briotán, Britannia is called to the island which is to-day called Great Britain: and the ancient record of Ireland is agreeing with him on that, as the poem says, which has for beginning Adam father, fountain of our hosts, where it says:—
 

> 1. Briotán went beyond sea, without stain,
>   
> Generous son of red-sided Fearghus;
>   
> The Britons all, victory with renown,
>   
> From him, without deception, they have descended.
> 


 
Another author supports him on that where he says:— 


> 1. Briotán Maol,son of the prince,
>   
> Noble the stock-branch spreading from him,
>   
> Son of Leithdheirg from Leacmhagh,
>   
> From whom are the Britons of the world.
> 






---

p.189


It is the more right to think that to be true since it is not probable that it is from Brutus it is called (Britain); for if it were from him, it is likely that it is Brutania it would be called; and, besides, it is the more its name was obscured by the children of Brutus, according to (Geoffrey of) Monmouth, since Laegrus, son of Brutus, gave Laegria for name to the part of Britain which came to him; Camber, the second son of Brutus, gave Cambria for name to the part of it that came to himself; and Albanactus, the third son of Brutus, gave Albania for name to his own portion of the same territory.


As to the remnant of the race of Neimheadh, who remained dwelling in Ireland after those chiefs; they were oppressed by the Fomorians from time to time, till the arrival of the posterity of Simeon Breac, son of Starn, son of Neimheadh, in Ireland from Greece. Two hundred and seventeen years from the coming by Neimheadh into Ireland till the coming of the Firbolg into it, as this verse certifies:—


> 1. Seventeen years and two hundred—
>   
> During their reckoning,(there is) no exaggeration—
>   
> Since Neimheadh came from the east,
>   
> Over sea with his great sons,
>   
> Till the children of Starn came
>   
> From Greece,terrifying, very rugged.
> 




SECTION VIII
------------


#### Of the invasion of the Firbolg here.


The posterity of Simeon Breac, son of Starn, son of Neimheadh, having been in Greece, i.e. Thrace, as we have said, they grew so that the people who were there of them 


---

p.191




were numerous. Howbeit, the Greeks put bondage and great tyranny on them, such as their being digging the ground, raising earth, and carrying it in bags or in sacks of leather for putting it on stony crags, until it should become fruitful soil. Great sadness seized them, and enmity to the Greeks through the slavery in which they had them: and with that it was resolved by them to leave that evil plight. Having determined on that counsel, five thousand of them get together, and they make boats of the bags or of the wallets of leather in which they used to be drawing the clay: or it is the fleet of the king of the Greeks they stole, as the Cin of Druim Sneachta says, so that this posterity of Simeon Breac, son of Starn, came back to Ireland at the end of two hundred and seventeen years after Neimheadh had occupied Ireland.


Here are the chiefs who were over them that time, namely, Sláinghe, Rughruidhe, Gann, Geanann, and Seanghann, i.e. the five sons of Deala, son of Loch, son of Teacht, son of Triobuat, son of Othorb, son of Goiste, son of Oirtheacht, son of Simeon, son of Arglán, son of Beoán, son of Starn, son of Neimheadh, son of Agnamon, &c. Their five wives, Fuad, Eudar, Anust, Cnucha, and Liobhra, their names: and it is of them it was said:—
 

> 1. Fuad wife of Sláinghe—not deceiving you—
>   
> Eudar wife of Gann the valorous,
>   
> Anust wife of Seanghann of the spears,
>   
> Cnucha was wife of Geanann bright,(?)
>   
> Liobhra wife of Rughruidhe of the way.(?)
> 




Five thousand the number of the host who came with them; one thousand one hundred and thirty ships (between 
 


---

p.193



ship, bark, skiff and small boat) the number of their fleet, as these verses of antiquity show which follow:—


> 1. Thirty ships on one hundred,
>   
> And a thousand—it is not a lie—
>   
> It is the number who came from the east,
>   
> The good Sláinghe with his hosts:
> 2. Many were the Firbolg, without a lie,
>   
> At their coming out from Greece;
>   
> Good the tribes who were not diffident (in setting out),
>   
> Nor was the fleet wooden.
> 3. Wednesday they went westward,
>   
> Over the great broad Torrian Sea;
>   
> The period of three days on a fair year (went by)
>   
> Until they reached to Spain:
> 4. From that by them to noble Ireland—
>   
> A convenient sailing from Spain—
>   
> Better then not to conceal it from all,(?)
>   
> The space of three days and ten.
> 




These five chiefs divide Ireland in five parts among them, as we have said before, speaking of the third partition which was made of Ireland; as this verse says:—
 

> 1. Five chiefs at the head of the host
>   
> Divide into five Banbha the ancient;
>   
> Geanann, Rughraidhe—a brilliant roll—
>   
> Gann, Seangann, and Sláinghe.
> 




Sláinghe (from whom is named Innbhear Sláinghe at Loch-garman, [the youngest of the children]) took the province of Leinster from Innbhear Colptha at Droichead-átha to Cumar na dtrí-n-uisge, and a thousand the number of his host. Gann takes from Cumar na dtrí-n-uisge to Bealach Chonghlais, and a thousand the number of his host. Seangann takes from Bealach Chonghlais to Luimneach, and a thousand the number of his host. Geanann takes the province of Connacht from Luimneach to Drobhais, and a thousand the number of his


---

p.195




host. Rughraidhe takes the province of Ulster, namely, from Drobhaois to Droichead-átha, and a thousand the number of his host.


It is [to] these chiefs with their companies that are called Fir Bolg, Fir Domhnann and *Gaileoin"*. Fir Bolg, indeed, from the bags of leather they used to have in Greece, carrying earth to put it on bare flags so that they might make of them flowery plains in bloom. Fir Domhnann from the pits they used to dig in the soil by carrying it to the Fir Bolg. Gaileoin, indeed, they were named from the darts; because it is these which used to be their arms defending everybody when they would be (i.e. the others) doing their work; and from the darts or the spears which were their arms, they were named.


Understand, O reader, that it is one conquest they made, and that it is in one week they came into Ireland, i.e. Sláinghe on Saturday in Innbhear Sláinghe, Gann and Seangann the Tuesday after that in Iorrus Domhnann, Geannan and Rughraidhe the Friday afterwards in Tracht Rughraidhe. (The name) Gaileoin is given to Sláinghe with his people: Fir Bolg is given to Gann and to Seangann with their people: and Fir Domhnann is given to Geanann and to Rughraidhe. And some of the antiquaries say that it is in Iorrus Domhnann (in the north-west of the province of Connacht) these two came to land with a third of the host, and that it is from them Iorrus Domhnann is called. However, they are all commonly called Fir Bolg. Thirty-six years (was) the length of the dominion of the Fir Bolg over Ireland: and no one to whom the title of high-king was given came into the island before


---

p.197




them;so it is to prove that the following **rann** was composed:—


> 1. Sixteen years and two tens,
>   
> Fir Bolg over Banbha throughout,
>   
> Till the coming of the Tuath Dé to the people,
>   
> (And) that they seized all Ireland.
> 




SECTION IX.
-----------


#### Of the first kings who took the sovereignty of Ireland; and of every king after them who assumed, it, according to the order of the periods and of the invasions, down here.


Sláinghe, son of Deala, son of Lóch, took rule of Ireland (for a year, till he died in Dionnriogh, which is called Dumha Sláinghe: and he was the first king of Ireland [ever]; and, moreover he was the first dead among the Fir Bolg.


Rughraidhe, son of Deala, son of Lóch, took the kingdom of Ireland two years till he fell in the Brugh over the Bóinn.


Gann and Geanann took the kingdom of Ireland four years till they died of the plague in Freamhainn Midhe.


Seangann held the kingship five years till he fell by Fiachaidh Ceinnfhionnán.


Fiachaidh Ceinnfhionnán, son of Starn, son of Rughraidhe, son of Deala, son of Lóch, held the kingdom five years, till he fell by Rionnal, son of Geannan, son of Deala, son of Lóch. There were white heads on the men of Ireland during his time: hence he was called Ceinnfhionnán.


Rionnal took the kingdom of Ireland six years, till he fell by Foidhbghein, son of Seangann, son of Deala, son of Lóch.




---

p.199


This Foidhbghein held the kingship four years, until he was slain by Eochaidh, son of Earc, in Magh Muirtheimhne.


Eochaidh, son of Earc, son of Rionnal, son of Geannan, held the kingship ten years. There was no rain nor bad weather during his time, nor yet a year without fruit and increase. It is in his time injustice and lawlessness were put down in Ireland, and approved and elaborated laws were ordained in it. This Eochaidh fell by the three sons of Neimheadh, son of Badhraoi (Ceasarb, Luamh, and Luachra their names), in the battle of Magh Tuireadh. It is this Eochaidh who was king of the Fir Bolg at the coming of the Tuatha Dé Danann into Ireland. It is she who was queen to him, Taillte, daughter of Madhmór, king of Spain, and in Taillte she was buried, so that from her it was named Taillte. Nuadha Airgeadlámh was king over the Tuatha Dé Danann at that time. This battle of Magh Tuireadh was very long being fought between the two kings aforesaid. Howbeit, it was gained at last over Eochaidh and over the Fir Bolg, till Eochaidh was slain, and a hundred thousand of his people cut off from Magh Tuireadh to Trá igh Eothaile. It is in this battle his hand was cut off from Nuadha Airgeadlámh, so that he was seven years being cured, until a hand of silver was put on him, whence it is that he was named Nuadha of the silver hand.


The small number of Fir Bolg who escaped out of this battle departed in flight before the Tuatha Dé Danann, so that Ára, Ilé, Reachra, Inse Gall, and many islands besides, were inhabited by them; and they dwelt there until the time of the provincial kings being in the sovereignty of Ireland, until the Cruithnigh, i.e. Picts, banished them out of those


---

p.201




islands, so that they (i.e. Fir Bolg) came to seek Cairbre Niadh-fir, king of Leinster, (and) obtained land from him under tenure. However, the heaviness of their rent was such that they were not able to endure it. They depart thence to seek Meadhbh and Oilioll so that they gave land to them, whence it is that that is the migration of the sons of Ughmhór. Aonghus son of Ughmhór was prince over them in the east. It is from them are named the lands where they took up residence in Ireland, namely, Loch Cime, from Cime Ceithircheann, Rinn Tamhain in Meadhraidhe, Loch Cútra, Rinn mBeara, Maoilinn, Dún Aonghusa in Ara, Carn Conaill in Crích Aidhne, Magh n-Aghar (i.e. the plain of Aghar) son of Ughmhór the poet, Druim n-Asail, Magh Maoin (i.e. the plain of Maon) son of Ughmhór, Loch Uair (i.e. the lake of Uar) son of *Ughmhór*: and they occupied fortresses and islands in like manner in Ireland till they were expelled by Cuchulainn, by Conall Cearnach and by the Ulstermen also. It is not recounted ‘raths’ to have been built, lakes to have burst forth, or plains to have been cleared of woods during the dominion of the Fir Bolg. Some antiquaries say that it is from them (come) these three tribes which are in Ireland but not of the Gael, namely, the Gabhraidhe of Suca in Connacht, the Uí Tairsidh in Crích Ua bhFailghe, and the Gaileoin of Leinster. Those are the proceedings of the Fir Bolg, according to the antiquary, the learned **Tanuidhe Ua Maoilchonaire**, in the **duan** of which the beginning is this **rann**: —
 

> 1. The Fir Bolg were here a while
>   
> In the great island of the sons of Míleadh:
>   
> Five chiefs they came hither,
>   
> I have knowledge of their names.
> 






---

p.203


SECTION X.
----------


#### Of the invasion of the Tuatha Dé Danann here.


The Tuatha Dé Danann are of the posterity of the third chief of the race of Neimheadh who had gone on adventures from Ireland after the destruction of the tower of Conaing, namely, Iobath son of Beothach; and, according to some antiquaries, the place which was inhabited by them was Boetia in the north of Europe. Some others say that it is in the Athenian territory they dwelt, where the city of Athens is. Understand, O reader, that Boeotia and the city of Athens, according to Pomponius Mela, are in the district of Greece which is called Achaia: and that it is there they learned their magic and their arts until they became skilled in every trick of sorcery.


It happened about that time that a great fleet came from the country of Syria to make war on the people of the Athenian country, so that there was daily warfare between them; and those of the Athenians who would be slain, it is they who would be on the morrow fighting with the people of Syria. That necromancy used to be done through the art magic of the Tuatha Dé Danann: for they would put demons into the same bodies to restore them. And when the people of Syria became aware of this, they go to take counsel with their own druid. The druid says to them, to set a watch on the site or on the place of the battle-field, and to thrust a stake [of a spit] of quicken-tree through the trunk of every dead person who would be rising up against them; and if it were


---

p.205




demons who would cause their bodies to revive, that they would be from that immediately turned into worms, while, if it were really their revival that had been brought about, the bodies would not suffer change or corruption. The people of Syria come to join battle on the morrow, and it is won by them, and they thrust the stakes of ash through the dead, as the druid had told them, and presently worms were made of them: and the people of Syria fell on the others after that, slaughtering them.


As regards the Tuatha Dé Danann, when they saw the people of Syria prevailing over the people of the country, they, in one band, depart from that territory, for fear of them, and they made no stay till they came to the country of Lochlonn, i.e. Fionn-Lochlonn, viz. the people of Norway, where they got welcome from the people of the country for the extent of their science and of their varied arts. It is Nuadha Airgeadlámh, son of Euchtach, son of Edarlámh, of the posterity of Neimheadh who was chief over them at that time. Indeed, they obtained four cities, so as to be teaching the young folk of that country in them. The names of the cities here: Fáilias, Gorias, Finias, and Murias. The Tuatha Dé Danann place four sages in those cities to teach the sciences and the varied arts they had to the youths of the country; Semias in Murias, and Arias in Finias, and Eurus in Gorias, and Morias in Fáilias. After being a while of their time in these cities, they proceed to the north of Scotland, so that they were seven years at Dobhar and at Iardobhar. They had four noble jewels, which they brought from those cities, namely, a stone


---

p.207




of virtue from Fáilias; it is it that is called Lia Fáil; and it is it that used to roar under each king of Ireland on his being chosen by them up to the time of Conchubhar (as we mentioned before), and it is to that stone is called in Latin **Saxum fatale**. It is from it, moreover, is called Inis Fáil to Ireland. So that it is therefore a certain antiquary composed this verse:—
 

> 1. The stone which is under my two heels,
>   
> From it Inis Fáil is named;
>   
> Between two shores of a mighty flood,
>   
> The plain of Fál (is for name) on all Ireland.
> 


 
[This stone which is called Lia Fáil], another name for it (is) the Stone of Destiny; for it was in destiny for this stone, whatever place it would be in, that it is a man of the Scotic nation, i.e. of the seed of Míleadh of Spain, that would be in the sovereignty of that country, according as is read, in **Hector Boetius** in the history of Scotland. Here is what he says, viz.—


> 1. The Scotic nation, noble the race,
>   
> Unless the prophecy be false,
>   
> Ought to obtain dominion,
>   
> Where they shall find the Lia Fáil.
> 


{Ni fallat fatum, Scoti quocunque locatum, invenient lapidem, regnare tenentur ibidem.}


When the race of Scot heard that the stone had this virtue, after Feargus the great, son of Earc, had obtained the power of Scotland, and after he had proposed to style himself king of Scotland, he sends information into the presence of his brother Muircheartach, son of Earc, of the race of Eireamhón, who was king of Ireland at that time, to ask him to send him this stone, to sit upon, for the purpose of being proclaimed king of Scotland. Muircheartach sends the stone to him, and he was inaugurated king of Scotland on the same stone, and he was the first king of Scotland of the Scotic nation; and although


---

p.209




some of the Cruithnigh, i.e. the Picts, had been styled kings of Scotland, before Feargus was made king, there was not one of them full king without being under tax and under tribute to the kings of Ireland from time to time; and especially from the time of Eireamhón, son of Míleadh [forward], by whom the ‘Picts’ were sent out of Leinster to inhabit Scotland, (as we shall say in the reign of Eireamhón), to the reign of this Feargus. Concerning the stone, they had it accordingly some space of time, age to age, till it reached after that to England, so that it is there now in the chair in which the king of England is inaugurated, it having been forcibly brought from Scotland, out of the abbey of Scone; and the first Edward king of England brought it with him, so that the prophecy of that stone has been verified in the king we have now, namely, the first king Charles, and in his father, the king James, who came from the Scotic race (that is to say, from the posterity of Maine son of Corc son of Lughaidh, who came from Eibhear son of Míleadh of Spain); who assumed the style of kings of England upon the stone aforesaid.


The second jewel the Tuatha Dé Danann brought into Ireland then, that is the sword which Lúgh Lámhfada had used, and from Gorias it was brought. The third jewel, namely, the spear which the same Lúgh had when prepared for battle, and from Finias it was brought. The fourth jewel, the caldron of the Daghdha: a company would not go away unsatisfied from it, and from Murias it was brought. Here is a poem from a certain *B*ook of *I*nvasion for proof on the same things:—


> 1. Tuatha Dé Danann of the precious jewels,
>   
> The place in which they acquired learning
>   
> They attained their complete culture,
> 
> 
> ---
> 
> p.211
> 
> 
> Their art magic (and) their diablerie.
> 2. Iarbhoineol fair—an excellent seer—
>   
> Son of Neimheadh, son of Aghnomon,
>   
> To whom the doughty fool-hardy Beothach was son
>   
> Who was a hero full-active, given to slaughter.
> 3. The children of Beothach—vivid their fame—
>   
> They arrived a powerful host of heroes,
>   
> After much travail and wandering,
>   
> The entire of their fleet to Lochlonn.
> 4. Four cities, justly famous,
>   
> They occupied in sway with great power,
>   
> Where they used to wage war ingeniously(?)
>   
> For learning (and) for exact knowledge.
> 5. Fáilias and Gorias bright,
>   
> Finias (and) Murias of great deeds,
>   
> To blazon their sallies abroad(?)
>   
> (And) the names of the great cities.
> 6. Morias and Euras high-placed,
>   
> Arias (and) Semias austere;
>   
> Their naming is profitable discourse,
>   
> Of the names of the sages of the noble gain.
> 7. Morias the sage of Fáilias itself,
>   
> Euras in Gorias, of good disposition,
>   
> Semias in Murias, southern stronghold(?)
>   
> Arias fair, sage of Finias.
> 8. Four gifts with them (brought) from afar,
>   
> By the nobles of the Tuatha Dé Danann:—
>   
> A sword, a stone, a shapely cadron,
>   
> A spear for facing tall champions.
> 9. Lia Fáil from Fálias hither,
>   
> Which used to roar under the king of Ireland;
>   
> The sword of the hand of Lúgh the active(?),
>   
> From Gorias -- choicest of great store.
> 10. From Finias far over the sea,
>   
> Was brought the spear of Lúgh who was not weak;
>   
> From Murias—great prodigious gift—
>   
> The caldron of the Daghdha of Iofty deeds.
> 
> 
> ---
> 
> p.213
> 
> 13. King of heaven, king of feeble men,
>   
> Protect me, king of the great stars,
>   
> Prince, who hast endurance of hateful things,(?)
>   
> And the strength of the gentle tribes.
> 




Concerning the Tuatha Dé Danann, they, having spent seven years in the north of Scotland, came to Ireland; and, on their coming to land, Monday **Bealtaine** in the north of Ireland, they burn their ships, so to certify that, this **rann** was composed:—
 

> 1. Each warrior of them burned his ship,
>   
> When he reached noble Eire:
>   
> It was a grave decision in his state(?)
>   
> The vapour of the ships being burned.
> 




After that they put of mist of druidism around them for the space of three days, so that they were not manifest to any one of the Fir Bolg till they reached Sliabh-an-iarainn. Thence they send an embassy from them to Eochaidh, son of Earc, and to the chiefs of the Fir Bolg, to demand the kingdom of Ireland or battle on its account. Whereupon, the battle of Magh Tuireadh South is fought between the Fir Bolg and the Tuatha Dé Danann, so that the battle was gained on the Fir Bolg, and that a hundred thousand of them were slain, according as we have said above.


Thirty years from the battle of Magh Tuireadh South to the battle of Magh Tuireadh North, as the verse says:—


> 1. Thirty years,it is known,
>   
> From the battle of Magh Tuireadh South,
>   
> To the battle of Magh Taireadh North,
>   
> In which fell Balor of the great host.
> 






---

p.215


Some antiquaries say that it is from the three sons whom Danann, daughter of Dealbhaoth, bore, the Tuatha Dé Danann were called, to wit, Brian, Iuchar and Iucharbha, i.e. three of the children of Dealbhaoth, son of Ealatha, son of Néd, son of Iondaoi, son of Allaoi, son of Tat, son of Tabharn, son of Enna, son of Bathach, son of Iobath, son of Beothach, son of Iarbhoineol Fáidh, son of Neimheadh: because that the aforesaid three were so accomplished [as that] in heathen arts, that these tribes with whom they were wished to style them gods, and to name themselves from them. Here is a stave of a quotation certifying it, that these three are the three gods of Danann, as the poem says, which has for beginning, Hear, ye learned without blemish, &c.:—


> 1. Brian, Iucharbha and Iuchar there,
>   
> Three gods of the Tuatha Dé Danann;
>   
> They were slain at Mana over the great sea
>   
> By the hand of Lugh, son of Eithneann.
> 




It is from [the] Danann, who was mother to these three, Dá Chích Danann is called to the two hills which are in Luachair Deaghaidh in Desmond. Others say that it is why they are called Tuatha Dé Danann, because it is in [their] three orders they were, of those who had come into Ireland on this expedition. The first order of them, which is called **Tuath**, used to be in the rank of nobility and headship of tribe: called **tuathach**, indeed, and called **tighearna** being equivalent, as called **tuath** and called **tighearnas** are equal. That is the more fit to believe, inasmuch as **Dá Bhantuathaigh** is given (as an epithet) for Beuchuill and for Danann, whom 


---

p.217




they had for female rulers: so this verse gives us to understand:— 


> 1. Beuchuill and Danann beloved —
>   
> The two female chiefs were slain;
>   
> The extinction of their magic at last
>   
> By pale demons of air.
> 




The second order (to) which used to be called **Dé**, such are their druids, whence it is the above three used to be called the three gods of Danann. Wherefore they were called ‘gods’ (is) from the wonderfulness of their deeds of magic. The third order which was called **Danann**, namely, the order which was given to **dán**, or to crafts; for **dán** and **céard** are equal.


SECTION XI
----------


#### Of the branching of the tribe that was noblest of the Tuatha Dé Danann down here.


Eochaidh Ollathar, i.e. the Daghdha, Oghma, Allód, Breas and Dealbhaoth, the five sons of Ealatha, son of Néd, son of Iondaoi, son of Allaoi, son of Tat, son of Tabharn, son of Enna, son of Báthadh, son of Iobath, son of Beothach, son of Iarbhoineol Fáidh, son of Neimheadh, son of Aghnoman.


Manannán son of Allód, son of Ealatha, son of Dealbhaoth.


The six sons of Dealbhaoth, son of Oghma: Fiachaidh, Ollamh, Iondaoi, Brian, Iuchar and Iucharbha.


*"Aonghus, Aodh, Cearmadh and Mídhir, the four sons of the Dághdha.*


Lúgh, son of Cian, son of Dianchéacht, son of Easarg, son of Néd, son of Iondaoi.




---

p.219


Goibhneann the smith and Creidhne the artist: Dianchéacht the physician and Luchtain the mechanic; and Cairbre the poet, son of Tara, son of Tuirreall.


Beigreó, son of Cairbre Caitcheann, son of Tabharn.


Fiachaidh, son of Dealbhaoth, and Ollamh, son of Dealbhaoth.


Caichér and Neachtain, two sons of Námha, son of Eochaidh Garbh, son of Duach Dall.


Siodhmall, son of Cairbre Crom, son of Ealcmhar, son of Dealbhaoth.


Eire and Fódhla and Banbha, three daughters of Fiachaidh, son of Dealbhaoth, son of Oghma. Eirnin, daughter of Eadarlámh, mother of those women.


Badhbh, Macha, and Móirríoghan, their three goddesses.


Danann and Beuchuill, the two female chiefs, and Brighid the poetess.


(Appertaining to these noble females were the two royal institutes, i.e. Fé and Meann (being) their names): it is from them is named Magh Feimhin. It is among  them also was Triath-rí-thorc, from whom is called Treitheirne Mumhan.


[Cridhinbhéal, Bruinne, and Casmhaol, the three satirists.]


It is they who won the battle of Magh Tuireadh North on the Fomórians, and the battle of Magh Tuireadh South on the Fir Bolg. It is in the first battle his hand was cut off Nuadha, and his head in the last battle.




---

p.221


SECTION XII.
------------


#### Of the kings of the Tuatha Dé Danann here, and of the length of their sovereignty over Ireland.


Nuadha Airgeadlámh, son of Euchtach, son of Eadarlámh, son of Orda, son of Allaoi, son of Tat, son of Tabharn, son of Enna, son of Iobáth, son of Beothach, son of Iarbhoineol Fáidh, son of Neimheadh, took the kingdom of Ireland thirty years, till he fell in the battle of Magh Tuireadh North.


Breas, son of Ealatha, son of Néd, son of Iondaoi, son of Allaoi, son of Tat, held the kingship seven years.


Lúgh Lámhfada, son of Cian, son of Dianchéacht, son of Easar Breac, son of Néd, son of Iondaoi, son of Allaoi, held the kingdom of Ireland forty years. It is this Lúgh who appointed the **Fair of Taillte** at first as a yearly commemoration of Taillte, daughter of Madhmór, i.e. king of Spain, who was wife to Eochaidh, son of Earc, last king of the Fir Bolg, and who was wife after that to Eochaidh Garbh, son of Duach Dall, a chief of the Tuatha Dé Danann. It is by this woman Lúgh Lámhfada was fostered and trained till he was fit to bear arms; and it is as an honourable commemoration for her Lúgh instituted the games of the **Fair of Taillte** a fortnight before **Lúghnasadh**, and a fortnight after it, resembling the games called ‘Olympiades’: and it is from that memorial which Lúgh used to make **Lúghnasadh** is given (as name) to the first day (or) to the Calends of August, i.e. the **násadh** or commemoration of Lúgh, (on which is now the feast of St. Peter's chains). He fell by (the hand of) Mac Coll at Caondruim.




---

p.223


The Daghdha Mór, son of Ealatha, son of Dealbhaoth, son of Néd, held the kingdom of Ireland seventy years. He died at Brugh of the bloody missiles of a cast which Ceithleann flung at him in the battle of Magh Tuireadh. Eochaidh Ollathar (was) the proper name of the Daghdha.


Dealbhaoth, son of Oghma Griain-éigis, son of Ealatha, son of Dealbhaoth, son of Néd, held the kingship ten years till he fell by Fiachaidh, son of Dealbhaoth.


Fiachaidh, son of Dealbhaoth, son of Ealatha, held the kingship ten years, till he fell by Eoghan at Ard Breac.


The three sons of Cearmad Milbheol, son of the Daghdha, that is to say, Mac Coll, Mac Céacht and Mac Gréine their names, assumed the dominion of Ireland thirty years; and some antiquaries say that it is a tripartite division which they made on Ireland, as is said in this verse:—


> 1. Though Eire had many thousands,
>   
> They divide the land in three;
>   
> Great nobles of glorious deeds,
>   
> Mac Coll, Mac Céacht, Mac Gréine.
> 




However, it is not a tripartite division which was among them, but the permutation of the sovereignty, that is to say, each one of them had it every succeeding year, by turns, as we have said above in (enumerating) the names of this country, [and in the battle of Taillte all three fell]. It is why these names were given to those three kings, because Coll, Céacht, and Grian were gods of worship to them. Coll, indeed, was god to Mac Cuill, and Eathúr was his proper name, and Banbha his wife. Mac Céacht, too, Céacht his god, Teathúr his name, and Fódhla his wife, Mac Gréine, lastly, Grian his god, Ceathúr his name, and Eire his wife.




---

p.225


Oirbsean (was) the proper name of Manannán: it is from him Loch Oirbsean is named: for when his grave was being dug, it is then the lake burst forth over the land. It is to make this matter clear these verses following were composed:—


> 1. Eathúr tall, who obtained dignity, fierce the man,
>   
> Coll his god, grandson of the Daghdha not gloomy, Banbha his wife;
>   
> Teathúr stout, strong his contest, sharp his stroke (?),
>   
> Fódhla his wife, great deeds he accomplished (?), in Céacht he trusted;
> 2. Ceathúr comely, fair his complexion, noble was he,
>   
> Éire his wife, generous woman she, Grian his divinity.
>   
> Manannán, son of Lear, from the **loch**, he sought the **sraith**,
>   
> Oirbsean his (own) name, after a hundred conflicts he died the death.
> 




According to the Saltair of Caiseal, it is three years wanting of two hundred (is) the length of the sovereignty of the Tuatha Dé Danann over Ireland. This verse agrees with that:— 


> 1. Seven year, ninety, and one hundred—
>   
> That reckoning is not false—
>   
> For the Tuatha Dé Danann with might,
>   
> Over Ireland in high sovereignty.
> 




SECTION XIII
------------


#### Of the origin of the children of Mileadh, of their proceedings, and of their transactions, of their genealogy, and of every occurrence that happened to them, from Fénius Farsaidh down to the invasion of Ireland by them, here below (stated).


In order, truly, that we should be able to trace the origin of the Scotic nation to its root, i.e. to Japheth (we find) the two most distinguished sons Japheth had, that is to say, Gomer 


---

p.227




and Magog. Moses, in the tenth chapter of Genesis, where he records the propagation of the posterity of Japheth, sets down [i.e.] that Gomer had three sons, namely Aschenez, Riphath, and Thogorma; however, he does not mention specially the children of Magog according to their names. Nevertheless, as it is on the antiquaries of the Scotic nation that it is incumbent to follow up the ascertained genealogy of the nobles who sprang from Magog, and particularly of the posterity of Fenius Farsaidh, we shall here set down the genealogical account of the posterity of Magog, according to the book of invasion which is called **Cin Droma Sneachta**; and that authority existed before Patrick came to Ireland. What it says is, that Magog had three sons, namely, Báath, Iobáth, and Fáthachta. From Báath came Fénius Farsaidh, the ancestor of the posterity of Gaedheal; from Iobáth came the Amazons, Bactrians, and Parthians; from Fáthachta came Partholón [he who first occupied Ireland after the deluge] and (also) Neimheadh, son of Aghnoman, and, accordingly, the Fir Bolg and Tuatha Dé Danann [as we have said above in (the account of) their conquests]. It is from the posterity of this Fathachta came the great Attila, who brought Pannonia under his sway, and was a length of time perturbing the state of Rome, destroyed and depopulated Aquileia, and made many raids on Germany. It is from Scythia also, of the posterity of Magog by origin, Zeliorbes, king of the Huns, who made war upon the emperor Justinian. It is from Scythia, too, came the Lombards, Hungarians, and Goths [all]. It is from [the] Scythia, likewise, came the Dauni, from whom is called Daunia in Italy, and the name of that country now is Apulia. It is from Scythia also that the Turks have come. But in short, **Becanus**, an investigator of the antiquity of the dissemination of the races of the


---

p.229




world, says, repeating **Epiphanius**, that the people of Scythia obtained chief rule shortly after the deluge, and that their sovereignty continued until the predominance of Babylon. The same authors say that it is from Scythia the other countries used to receive institutes and laws and ordinances, and, moreover, that it is they who were the first race which commenced to be honoured after the deluge. **Johannes Boemus**, in the ninth chapter of the second book which he wrote on the customs of every race, says that the Scythians were never subdued by any dominion. **Josephus** says that the Greeks called the people of Scythia Magogai. Johannes Nauclerus says that people have come of the race of Scythia by whom very great deeds were done. Let **Herodotus** bear witness to this in the fourth book where he says that the people of Scythia repelled Darius king of Persia contemptuously from Scythia. Let **Justin** likewise witness in his history, where he treats of the gallantry of the exploits which the people of Scythia performed: and here are the words of this author:—*The people of Scythia, he says, were always without foreign power affecting them or seizing their spoils: they drove back Darius, king of Persia, with disgrace out of Scythia; they slew Cyrus with the entire of his army; Zophyron, the leader of the army of Alexander the great, with his host, was destroyed by them: they had heard of the power of the Romans, and (yet) had never felt it. {Scythae ipsi perpetuo ab alieno imperio aut intacti aut invicti mansere: Darium regem Persarum turpi a Scythia submovere fuga; Cyrum cum omni exercitu trucidarunt; Alexandri magni ducem Zophyron a pari ratione cum copiis universis deleverunt; Romanorum audivere sed non sensere arma.}’’*

 From these words it may be understood that it was great was the bravery and the valour which was among the people of Scythia to the time of this author.
The Polychronicon says in the thirty-seventh chapter of the first book, that it is from this word Scythia, Scot is called


---

p.231




to the posterity of Gaedheal Glas, and, in my judgment, it is not more fit to give Gall (for name) to the people who are now inhabiting Ireland who are called Gall, that is to say, from Gallia or France as to their origin than to give Scot (for name) to the Gael from Scythia whence they came according to their origin: and it is therefore Greeks of Scythia is called to the posterity of Fáthachta, son of Magog, who obtained dominion in Gothia, Thracia, and Achaia, viz. Partholón, son of Seara, with his people; Neimheadh, son of Aghnoman, from whom the children of Neimheadh are called; the Fir Bolg and the Tuatha De Danann, because it is from Scythia they all came, according to their origin. And I think that it is why Scot is more especially. called to the posterity of Gaedheal, son of Niul, son of Fenius Farsaidh, because it is to Fenius Farsaidh the chief dominion of Scythia came, and to his posterity after him; and that it was Niul was the younger son of Fenius, and that he did not obtain any equal share of the territory, as the kindred of Fenius had obtained districts from which they themselves and their posterity were named. Wherefore Niul enjoined on his posterity to denominate themselves from Scythia, and for ever to call themselves Scots, because there was no land in their possession, and that his father had left him as a portion, only the acquisition of the sciences and of the several languages; having left the kingdom of Scythia undivided to Neanual, the son who was older than Niul.




---

p.233


SECTION XIV
-----------


#### Here below (we treat) definitely apart concerning the true origin from which the race of Gaedheal have sprung; and of their proceedings till the arrival of the sons of Míleadh in Ireland.


Some Latin authors say that Gaedheal was the son of Argus or of Cecrops, who obtained the sovereignty of the Argives; but that cannot be well-founded, because that St. Augustine says that the monarchy of that people commenced at the time Jacob was born, i.e. about four hundred and thirty-two years after the deluge; and, moreover, according to the same author, [that] the dominion of his posterity was maintained but two hundred and fifteen years: and, according to that, that it is at the end of six hundred and three score and seven years after the deluge the rule of that line terminated. But truly, it is not possible for that to be authentic, and to say (at the same time) that it is from Argus or Cecrops Gaedheal should have come; for **Hector Boetius** in his history of Scotland, and, moreover, all the books of invasion of Ireland, state that Gaedheal was in Egypt during the time of Moses being in the headship of the children of Israel in Egypt. Indeed, the books of invasion say that it is at that time Scota, daughter of Pharao Cingcris, bore Gaedheal to Niul, son of Fenius Farsaidh, son of Báath, son of Magog: and it is the time when Moses began to act as leader of the children of Israel in Egypt, seven hundred and four score and seventeen years (from the deluge); so that according to that reckoning of time, there were as a conjecture three hundred years and two score and five besides, from the time of Argus or Cecrops till Gaedheal was born, and, consequently, it was not possibie for him to be son to Argus or to Cecrops.




---

p.235


Whoever would say that it was from Greece Gaedheal proceeded to Egypt, and that it is why it is said that it was from Scythia he went to Egypt, because that it was from the land of ‘Cetim’ (as a certain author thinks), he journeyed, [and,] consequently [that he] says that Scythia, and **iath na sceach** are equivalent: iath, truly, when it is understood in place of this word fearann (land), has th or has dh at the end, that is to say has iath or has iadh: however, when this word Scithia is written, there is no ‘c’ in the middle, as should be in such like compound word; and, moreover, there is no ‘th’ or ‘dh’ at the end of it, and, consequently, it is but an unwarranted opinion to suppose that, according to Gaelic etymology, ‘Scithia’ is equivalent to land of thorns.


The proof, likewise, is weak concerning Gaedheal having come from Greece according to his origin, to say that the posterity of Gaedheal have a resemblance to the Greeks in (their) manners, customs, and games, and that, therefore it must be said that they came from Greece. For every invasion that came into Ireland after the deluge, except only the race of Gaedheal and the children of Neimheadh, it is from Greece they came, [that is to say, Partholón from Migdonia, the Fir Bolg from Thracia and the Tuatha Dé Danann from Achaia, where Beotia is, and the city of Athens,] according as we have shown above in their several conquests the name of every place in Greece from whence they had set out.




---

p.237


Wherefore, although the race of the Gaedheal, on their arrival in Ireland, had not the manners and customs of the Greeks, it was possible for them to have learned them from the remnant of the Fir Bolg and the Tuatha Dé Danann who were before them in Ireland, and to have left them to be practised by their posterity after them, though they themselves had never been in Greece, nor Gaedheal, nor any of those who had come before them.




---

p.3


History of Ireland.
-------------------

XV.
---


#### The doings of Feinius Farsaidh the grandfather of Gaedheal till his return from the Plain of Seanair, and till his death, as follows:


When Feinius Farsaidh became king of Scythia, he determined to become perfectly acquainted with the various languages which had sprung up after the confusion of tongues that had taken place long before at the tower of Babel, which was being erected through pride for the space of forty years by Nimrod and his followers. For before that confusion of tongues took place at the tower, the entire human race had but one common language which had existed amongst them from the time of Adam. And the name the Book of Invasions gives this language is Gortighern, as the poet says:


> 1. Gortighern the name of the language
>   
> Used by the son of God of goodly science,
>   
> And by the race of Adam erst
>   
> Ere the building of Nimrod's tower.
> 



And Latin authors call it lingua humana, that is, the human language. But when Nimrod and his kinsfolk were building the tower, as the confusion of tongues set in and prevented them from finishing a structure they had begun through pride, the human language they derived from Adam was taken from them, as many as were engaged in building the tower. However, it remained with Eibhear son of Saile, and with his tribe, so that it was named from him; for they called it Hebrew from Eibhear. Now when Eibhear had learned the cause of their erecting the tower, that it was with a view to protecting themselves against the second


---

p.5




flood which it was foretold would come upon the people—they imagined that the second flood would not be higher than the first, and proposed to make the tower so high that the flood would not reach its upper stories, and that accordingly their nobles could be securely situated in these without fear of the flood—and when Eibhear learned that that was the cause of their building the tower, he declared that he would not help them, and that it was sheer idleness on their part to have recourse to ingenuity for the purpose of resisting the fulfilment of God's will. Thereupon he separated from them without taking any part whatever with them in the building of the tower. Moreover, when the confusion came on all, God left to Eibhear alone and to his tribe after him, as a mark of good will, that human language of our ancestors.


The principal reason why Feinius Farsaidh went to the Plain of Seanair, together with his school, was that he might be with the people whose native language was Hebrew, and that it might thus come about that he and his school would acquire a full and perfect knowledge of that language.


Now, when Feinius, as we have said, had resolved to acquire the various languages, he sent, at his own expense, seventy-two disciples into the various countries of the three continents of the world that were then inhabited, and charged them to remain abroad seven years, so that each of them might learn the language of the country in which he stayed during that time. And at the end of seven years they returned to Feinius to Scythia; and Feinius went with them to the Plain of Seanair, together with a large number of the youths of Scythia, leaving his eldest son Neanual to rule Scythia in his stead, as a certain poet says, in the poem which begins, Let us relate the origin of the Gaels: 


> 1. Feinius went from Scythia
>   
> On the expedition,
>   
> A man renowned, wise, learned,
>   
> Ardent, triumphant;
> 
> 
> ---
> 
> p.7
> 
> 4. There was but one tongue in the world
>   
> When they set out;
>   
> There were seventy-two tongues
>   
> When they parted;
> 5. Feinius had a great school learning
>   
> Each science,
>   
> A man renowned, wise, learned
>   
> In each language.
> 



And some seanchas assert that there was a space of sixty years from the building of the tower until Feinius and his school came southwards from Scythia to the Plain of Seanair, as a certain poet says in this stanza:


> 1. Thrice twenty years of renown,
>   
> So every seancha says,
>   
> Till Feinius came southwards,
>   
> From the building of Nimrod's tower.
> 




Feinius established schools for the teaching of the various languages on the Plain of Seanair in the city which Cin Droma Sneachta calls Eathena, as the poet says in the following stanza:


> 1. In the Plain of Seanair after the tower,
>   
> The first school was assembled,
>   
> In the city of Eathena,
>   
> To learn the various tongues.
> 



And they assembled the youths of the countries next them to learn the various tongues from them; and the three sages who presided over this school were Feinius Farsaidh himself from Scythia, and Gaedheal son of Eathor of the race of Gomer from Greece, and Caoi Caoinbhreathach from Judea, or Iar son of Neama, as the poet says:


> 1. Here are the names of the sages—
>   
> I shall reveal them to you speedily—
>   
> Gaedheal son of Ethor of wisdom,
>   
> Iar son of Neama and Feinius.
> 



Another poet speaks thus:


> 1. Feinius the eloquent sage,
>   
> Gaedheal and Caoi Caoinbhreathaeh,
>   
> Three of the writers of the schools
>   
> Who followed in the true track of the authors.
> 




---

p.9




It was this trio who wrote on wooden tablets the alphabets of the three chief languages, namely, Hebrew, Greek, and Latin, as Ceannfaolaidh the Learned asserts in the Accidence which he wrote in the time of Columcille. The same author states that Nion son of Beil, son of Nimrod, was monarch of the world at that time. He also states that it was about this time that Niul, the tanist son of Feinius Farsaidh, was born, and that the same Feinius continued in charge of the school for twenty years in order that this son who was born to him might be acquainted with the several languages.


As some seanchas assert that it was when Nion son of Beil had reigned forty-two years that Feinius Farsaidh established a school in the Plain of Seanair, I am of opinion that he passed ten years of the reign of Nion son of Beil, and ten years thereafter, in the Plain of Seanair before he returned from the school to Scythia. For all the seanchas say that he passed twenty years in charge of the school before his return. I am also of opinion that it was two hundred and forty-two years after the Deluge that Feinius established the school in the Plain of Seanair, according to the computation **Bellarminus** makes in his chronicle, where he says that the age of the world was one thousand eight hundred and fifty-six years when Nion son of Beil began his sovereignty.


This is the same, according to the Hebrew chronology which **Bellarminus** follows, as to say that the reign of Nion began two hundred years after the Deluge, since according to the Hebrews one thousand six hundred and fifty-six years elapsed from the beginning of the world to the Deluge. Add to this forty-two years of the reign of Nion that had passed before Feinius began the school, and it thus appears that it was two hundred and forty-two years after the Deluge he began it, and that he passed twenty years directing it, namely, the ten years that remained to him of the reign of Nion, and ten years thereafter.




---

p.11


Now after twenty years Feinius returned to Scythia, and established schools there, and appointed Gaedheal son of Eathor to take charge of them. Then did Feinius command Gaedheal to arrange and regulate the Gaelic language as it is into five divisions, that is, Bearla na Feine, Bearla na bhFileadh, Bearla an Eaderscartha, Bearla Teibidhe, and Gnaithbhearla, and to name it precisely from himself; hence it is from Gaedheal son of Eathor it is called Gaelic, and not from Gaedheal Glas, as others assert. Moreover, it was through friendship for Gaedheal son of Eathor that Niul son of Feinius Farsaidh gave the name Gaedheal to the son whom Scota daughter of Pharao Cincris bore him, as Ceannfaolaidh the Learned says in the Uraicheapt.


Now, it is disputed among authors whence is this word ‘Gaedheal’. **Becanus** says that it is from the word goedin, that is, goethin, ‘noble’, and from the word all, that is, uile, that Gaedheal is named, that is, ‘all noble’; or from the Hebrew word gadhal, meaning ‘great’, because Gaedheal son of Eathor, the first who was called Gaedheal, was great in learning, in wisdom, and in the languages. However, the seanchas say that he is called Gaedheal from the two words gaoith dhil, that is, lover of wisdom; for gaoith means wise and dil loving, as the Greeks call a sage philosophos, that is, ‘a lover of wisdom’.


As to Feinius Farsaidh we are not told that he had any children except two sons, namely, Neanul and Niul, as the poet says in this stanza:


> 1. Two sons had Feinius, truth I tell,
>   
> Neanul and Niul, the valiant;
>   
> Niul was born at the tower in the east,
>   
> Neanul in shield-bright Scythia.
> 




When Feinius had been twenty-two years sovereign of Scythia, after his return from the Plain of Seanair, being at the point of death, he bequeathed the sovereignty of Scythia


---

p.13




to Neanul, his eldest son, and left to Niul, his youngest son, only what profit he derived from the sciences and the various languages which he used to teach in the public schools of the country.


XVI.
----


#### Of the journeying of Niul to Egypt from Scythia, and of his doings there until his death as follows:


Before we speak of the journeying of Niul from Scythia to Egypt, we may observe that **Herodotus** says that it was from Babylon the Greeks derived the knowledge of the position of the north star, and the division of the hours; and Solon asserts that the Greeks had not a knowledge of history until they obtained it from the Egyptians. **Josephus** says, in the first book of his History, that the Greeks had not an alphabet till the time of **Homer**. From these authors it appears that it was not from Greece, so named to-day, that Isis or anyone else went to teach the sciences to the Egyptians; but it was Niul, the son of Feinius Farsaidh, who went from Scythia to teach the sciences there. And whoever should say that there was not learning in Scythia, from whence Niul came, earlier than in Egypt, would not be stating truth, according to **Polydorus**, in the first book he has written, De rerum inventoribus, where he says: *There was a long dispute between the Egyptians and the Scythians; and, in that struggle, the Egyptians having been overcome, it appeared that the Scythians were more ancient than they were. {Magna diu inter Aegyptios et Scythas contentio fuit in quo certamine superatis Aegyptis Scythae aniquiores visi sunt.}’’*

 From this it may be inferred that the Scythians possessed education and learning earlier than the Egyptians, and since, according to the above authors, learning was earlier in Egypt than in Greece, it was not Isis of Greece or any such person who went from Greece to Egypt to conduct schools, but Niul son of Feinius Farsaidh 


---

p.15




from Scythia, who was born in the Plain of Seanair, and was then trained in learning in the first school that was established in the country of Babylon; and this was the first school after the confusion of the languages of the world, as we have stated above.
When Niul had been a long time conducting the public schools in Scythia, his fame for knowledge and wisdom spread through the nations generally, so that on account of his great reputation Pharao Cincris, king of Egypt, sent envoys to him, inviting him to Egypt to teach the sciences and the various languages to the youths of that country. Niul accordingly proceeded to Egypt, as the poet says in this stanza, which is taken from the poem beginning, Let us relate the origin of the Gaels:


> 1. Tidings reached Forann
>   
> With great acclaim
>   
> Of Niul son of Feinius knowing
>   
> The languages of the world.
> 




Niul then went to Egypt with the envoys of Pharao; and the king gave him the land called Capacyront (or Campus Circit) beside the Red Sea. He also gave his own daughter Scota in marriage to Niul, as Giolla Caomhain says in the poem beginning Gaedheal Glas, from whom are the Gaels:


> 1. He then went into Egypt
>   
> And reached the mighty Forann,
>   
> And married Scota of charms not few,
>   
> The generous, clever daughter of Forann.
> 




When Niul had married Scota, he established schools at Campus Circit for teaching the sciences and the various languages to the youths of Egypt. And it was there that Scota gave birth to Gaedheal son of Niul. Perhaps some one might wonder how Niul, the fifth in descent from Japhet, could be a contemporary of Moses, seeing that seven hundred and ninety-seven years elapsed between the


---

p.17




Deluge and the assuming by Moses of the leadership of the children of Israel. My reply to that is that it is not incredible that Niul should live several hundred years; for people used to live a long time at that period; witness Eibear son of Saile the fourth in descent from Seim who lived four hundred and sixty-four years and Seim who lived five hundred years after Arphaxad was born to him, as we read in the eleventh chapter of Genesis; that it is not to be doubted, therefore, that Niul might have lived from the forty-second year of the reign of Nion son of Beil, as we have said, to the time of Moses. And moreover, the length of life granted to Niul and that he should have survived till the time of Moses in Egypt is still less to be wondered at, if what Marianus Scotus states be true; for he says that it was three hundred and thirty-one years after the Deluge that the Confusion of Tongues took place at Babylon, while, according to what we have stated above, it was long after the Babylonian Confusion that Niul was born. From what we have said, we should trust the authors of the seanchus of the Scotic race as regards the age of Niul son of Feinius Farsaidh, and believe that he was a contemporary of Moses in Egypt.


As to Niul, it was when he was sojourning at Capacyront beside the Red Sea, and when Scota had given birth to Gaedheal, that the children of Israel escaped from Pharao and marched to the shore of the Red Sea, and made an encampment beside Capacyront where Niul dwelt. When Niul heard of this, he went to meet them and discourse with them, and to find out who they were. At the outposts of the host he met Aaron who told him the story of the children of Israel and of Moses and the witness-bearing miracles that God had wrought against Pharao and his army, because of the bondage of the children of Israel. Now Niul and Aaron entered into an alliance and friendship with one another; and Niul inquired of Aaron whether they had food or provisions, and further informed him that whatever corn and means he had would


---

p.19




all be at their service. For this Aaron was grateful to him. Then night came on; and Aaron went to Moses and told him of the offers which Niul had made to them; and Moses and Aaron were grateful to him accordingly.


Now Niul went to his own people after this, and told them that the children of Israel were nigh unto them; and he told them all that had befallen the children of Israel. And that same night a serpent came upon Gaedheal as he was swimming, and wounded him so that he was at the point of death; and others say that it was from the desert it came and wounded him in bed. His people told Niul to take the lad to Moses; and he took Gaedheal into the presence of Moses. Moses prayed to God, and applied the rod he held in his hand to the wound, and thus healed it. And Moses said that, in what place soever the stock of that youth would settle, there no serpent would ever have venom, and this is verified in Crete, an island in Greece, in which some of his posterity are; it is without serpents as Ireland is. And although there were serpents in Ireland up to the coming of Patrick, I do not think they had venom; or I imagine it is the demons that are called serpents in the *Life* of Patrick.


Some seanchas state that Moses fastened with a lock around the neck of Gaedheal the bracelet that he had on his own arm, and that it was from this he was called Gaedheal Glas. At that time each chieftain wore a bracelet on the arm as a mark of his tribal supremacy; and hence the head of a company is now called a noble fleascach or bracelet-bearer. To set forth that it was from the trail of the serpent that clung to Gaedheals neck that he is called Gaedheal GIas, and to show that it was Moses who healed him, we have the following stanzas:


> 1. Gaedheal Glas, why was the name given
>   
> To that brilliant, perfect man?
>   
> The event whence Gaedheal is Glas,
>   
> Few are those who know its history;
> 
> 
> ---
> 
> p.21
> 
> 4. While bathed in the strong stream
>   
> Gaedheal son of Niul of good disposition,
>   
> A serpent bit his skin;
>   
> It was not easy to heal it;
> 5. The grey-blue mark did not leave him
>   
> Till Moses kindly healed it.
>   
> What the learned understand from this
>   
> Is that thence comes Gaedheal Glas.
> 



Others assert that he was called Gaedheal Glas from the grey-blue colour of his arms and armour. Hence someone has composed the following stanza:


> 1. Scota bore a son to Niul the modest,
>   
> From whom sprang many noble tribes;
>   
> Gaedheal Glas was the name of the man,
>   
> From the grey-blue colour of his arms and armour.
> 



And it is from this Gaedheal that all the Gaels are named. Hence the poet composed this stanza:


> 1. The Feni are named from Feinius,
>   
> The meaning is not difficult;
>   
> The Gaels from comely Gaedheal Glas,
>   
> The Scots from Scota.
> 



Others, however, say that the mother of Gaedheal was called Scota because his father was of the Scotic race from Scythia, and that it was their custom to call the women after their husbands. Understand that this is not the Scota who was wife of Galamh, who is called Milidh of Spain, and bore him six sons. For the mother of Gaedheal was daughter to Pharao Cincris; and it was he who held the children of Israel in bondage. But the Pharao whose daughter was wife of Milidh was the fifteenth Pharao after him. He was called Pharao Nectonibus.


Now as to Niul, he told Moses that Pharao Cincris would be angry with himself for having welcomed him. ‘In that case’, said Moses, ‘come along with us; and if we reach the land which God has fore-appointed to us, thou shalt get a share of it; or, if thou wilt, we will deliver 


---

p.23




the fleet of Pharao into thy hands, and do thou go on sea in it so that thou mayest learn how we shall separate from Pharao.’ Niul followed this latter counsel. A thousand armed men were sent with him to the ships; and these were delivered over to him; and he embarked in them, and beheld the events of the ensuing day, namely, the opening of the sea before the children of Israel, and its dispersion after them on Pharao and on his host, drowning them, as the poet says in this stanza, which is taken from the poem beginning, O thou who believest not according to truth:


> 1. Sixty thousand of them on foot,
>   
> Fifty thousand on horseback,
>   
> storm of the Red Sea of Romhar
>   
> overwhelmed them all at once.
> 



Sixty thousand foot, then, and fifty thousand horse was their number. It was seven hundred and ninety-seven years after the Deluge that Pharao was drowned, as we have stated above. And Niul having seen Pharao and his host drown, remained in the same territory, as he was not afraid after the drowning of Pharao; and his children and progeny grew up until they were able to bear arms. Some time afterwards Niul died; and Gaedheal and his mother took possession of his lands. Thereafter a son was born to Gaedheal in Egypt, namely Easru son of Gaedheal, and some time after that a son was born to him in turn, Sru son of Easru, son of Gaedheal, and these possessed the same lands and dwelt thereon.


Now, as to the Egyptians, Pharao Intuir assumed sovereignty over them after the drowning of Pharao Cincris. Pharao was a name given to every king who ruled over Egypt from Pharao Cincris who was drowned in the Red Sea to Pharao Nectonibus the fifteenth king after Pharao Cincris.




---

p.25


XVII.
-----


#### Of the expulsion by Pharao Intuir of the race of Gaedheal from Egypt as follows:


As to Pharao Intuir and the Egyptians thereafter, when they had become powerful in the country,they remembered their old enmity against the children of Niul and the race of Gaedheal, that is, the friendship into which they had entered with the children of Israel, and Niul's having carried off the fleet of Pharao Cincris on the escape of the children of Israel. They accordingly made war upon the race of Gaedheal and banished them against their will from Egypt. **Thomas Walsingham** agrees with this account in *Upodigma*, where he says: *When the Egyptians had been drowned, the portion of the inhabitants who lived after them expelled a certain Scythian nobleman who dwelt amongst them, lest he might assume sovereignty over them. When he had been expelled with his tribe, he came to Spain, where he resided many years, and where his progeny multiplied exceedingly, and thence they came to Ireland. {Aegyptius in Mari Rubro submersis, illi qui superfuerunt expulerunt a se quemdam nobilem Scyticum qui degebat apud eos ne dominium super eos invaderet; expulsus ille cum familia pervenit ad Hispanium ubi et habitavit per annos multos et progenies ipsius familiae multae multiplicata est nimis et inde venerunt in Hiberniam.}’’*


Know, O reader, that this nobleman was Sru son of Easru, son of Gaedheal, and not Gaedheal himself, notwithstanding **Hector Boetius**, and notwithstanding also the opinion of the modern English authors who have written on Ireland, and who imagine that it was Gaedheal himself who came to Spain. Because, according to the truth of the seanchus of Ireland, which one should believe in this matter, it was in Egypt that Scota daughter of Pharao Cincris gave birth to Gaedheal, and it was there that he lived till his death; and he did not come from Greece, as others assert, but his father, who was called Niul, came from Scythia. And although the author whom we have quoted states that it was to Spain the nobleman to 


---

p.27




whom we have referred came, such is not the fact; for it was to Scythia he went, and it was the fifteenth in descent from him, called Bratha son of Deaghaidh, who first came to Spain. Here is the seanchas statement of the fact that it was Sru son of Easru who was the leader of this expedition on its setting out from Egypt, as Giolla Caomhain says in the poem beginning, Gaedheal Glas from whom are the Gaels:


> 1. Sru son of Easru son of Gaedheal,
>   
> Our ancestor of the joyous host,
>   
> It was he who went northwards from his house
>   
> Over the Red Sea of Romhar.
> 2. Four shipfuls were his host
>   
> Upon the Red Sea of Romhar;
>   
> Found room in each wooden dwelling, as was right,
>   
> Four and twenty wedded couples.
> 




Know, as we have said, that it was Sru son of Easru who headed this expedition till they reached the Island of Crete where he died, and that his son Eibhear Scot assumed the supreme authority till they arrived in Scythia. It is for this reason that a certain author says that Eibhear Scot was their leader in this expedition, and that it was from his cognomen, namely, Scot, that the Gaels are called the Scotic race. For, according to a certain author, Scot means archer, and there was in his time no bowman superior to him; and from this cognomen given him the name was given to his posterity; and they practised the bow as a weapon in imitation of the ancients down to a recent period within our own memory. However, we shall not adopt the view of this author, since it is the common opinion of the seanchas that the race of the Gaels were called the Scotic race from their having come originally from Scythia.


Understand, O reader, that Gaedheal was a contemporary of Moses, and that accordingly he was fourscore years of age when Pharao was drowned, and that the fourth in descent from himself, namely, Eibhear Scot son of Easru, son of


---

p.29




Gaedheal, had been born before the children of Israel passed through the Red Sea with Moses as leader over them. Certain seanchas are of opinion that there were four hundred and forty years from the drowning of Pharao in the Red Sea to the coming to Ireland of the sons of Milidh. And in confirmation of this, one of these authors thus speaks in this stanza:


> 1. Forty and four hundred
>   
> Years, it is not a falsehood,
>   
> From the going of the people of God, I assure you,
>   
> Over the surface of the sea of Romhar
>   
> Till sped across the sea of Meann
>   
> The sons of Milidh to the land of Erin.
> 




However, according to the computation made by the Book of Invasions, there were only three hundred years less by seventeen from the time that Moses assumed the leadership of the children of Israel in Egypt until the coming of the sons of Milidh to Ireland. For Moses assumed the leadership of the children of Israel in Egypt seven hundred and ninety-seven years after the Deluge; and according to the time Irish history allows to the Invasions of Ireland, it was one thousand and eighty years after the Deluge that the sons of Milidh took possession of Ireland. Thus the Book of Invasions states that it was, three hundred years after the Deluge that Parthalon came, and that his descendants remained in possession of Ireland three hundred years, and that Ireland remained a waste for thirty years, till the descendants of Neimhidh arrived there, and that these descendants ruled Ireland two hundred and seventeen years, and that the Firbolg held the sovereignty thirty-six years, and the Tuatha De Danann two hundred years less by three; and, adding all these together, they make a total of one thousand and eighty years from the Deluge to the coming of the sons of Milidh to Ireland. And if this number be taken in connexion with the seven hundred and ninety-seven years that elapsed from the Deluge to the leadership of Moses over the children of Israel,


---

p.31




it is plain that there were only three hundred years less by seventeen from that time till the coming of the sons of Milidh to Ireland; and hence that the opinion above-mentioned is false which states that it was four hundred and forty years after the children of Israel had passed through the Red Sea that the sons of Milidh came to Ireland.


Some seanchas state that the route taken by Sru son of Easru and his followers was through the Red Sea and south-eastward through the ocean, having Taprobana on their right, and Asia on their left to the east, and then turning northwards, having it still on the left, and thence to the extremity of Sliabh Rife, in the north-west part of Asia, and southward through the strait that separates Europe and Asia, and thence to Scythia. However, this was not the route Sru took as he proceeded from Egypt to Scythia with the crews of four ships, and each ship containing thirty men; but from the mouth of the Nile through the Torrian Sea to Crete, which is now called Candia, where he dwelt for a time, and where he died, and where he left succeeding generations of his descendants; and hence, according to the authors of our records there are no serpents in Crete as there are none in Ireland. And thence they proceeded to Scythia, with Eibhear Scot for their leader; and whoever should state that it was not possible to go from Egypt to Scythia by ship or vessel, considering how Scythia was bounded at that time, would not be stating a fact, since it is plain from every writer who has treated of geography that the river called Tanais flows into the Mediterranean Sea, and that that sea extends to Egypt, where the river Nile is; and according to the limits of Scythia at that time the river Tanais is reckoned among the rivers of Scythia, according to **Herodotus**, an ancient author of weight, in the fourth book, where he says: *The river Tanais, which separates Asia from Europe, is reckoned among the rivers of the Scythians. {Tanais fluvius dividens Asiam ab Europa enumeratur inter flumina quae apud Scitas sunt}’’*

 And when they had arrived in Scythia, war and strife arose between themselves and their kinsmen, namely,


---

p.33




the children of Neanul son of Feinius Farsaidh; and they contended with one another for the mastery of the country until it happened that Aghnon son of Tat, the fifth in descent from Eibhear Scot, slew his own cousin, Reafloir son of Rifill, of the race of Neanul, who was then king of Scythia, as Giolla Caomhain says in the poem beginning, Gaedheal Glas, from whom are the Gaels:


> 1. Reafloir and Aghnon without fault
>   
> Were seven years contending for mastery,
>   
> Till Reafloir fell with glory
>   
> By the successful hand of Aghnon.
> 


#### Of the expulsion of the race of Gaedheal from Scythia.


Now, as to the children of Reafloir son of Rifill, he had two sons, to wit, Neanul and Rifill, and they collected an army against the descendants of Gaedheal, to banish them completely from the country; and the descendants of Gaedheal came together, and left the country in a body, going through the land of the Breast-Seared, who are called Amazons, to the border of the Caspian Sea. There they took ship and went on sea, and landed on an island in the Caspian Sea, where they remained a year; and their leaders in that expedition were Aghnon and Eibhear, two sons of Tat son of Aghnaman, son of Beodhaman, son of Eibhear Scot, son of Sru, son of Easru, son of Gaedheal.


Aghnon had three sons with him on that expedition, namely, Ealloit, Laimhfhionn, and Lamhghlas. Eibhear son of Tat had two sons, namely Caicher and Cing. And Aghnon died on that island. And at the end of a year they all quitted the island, the crews of three ships, there being sixty in each ship, and every third man having a wife with him. They had six leaders in that expedition; and they made for the strait that leads westward from the Caspian Sea to the narrow sea that comes in from the northern ocean; and when they reached that sea, a storm


---

p.35




came upon them, and they were driven to an island called Caronia in the Pontic Sea, where they abode for a year and a quarter; and it was in that island Eibhear son of Tat and Lamhghlas son of Aghnon died. Thence they set out, having four leaders, namely Ealloit, Laimhfhionn, Cing, and Caicher; and mermaids came on the sea before them, and these used to discourse music to the sailors as they passed them, so that they might lull them to sleep, and then fall upon them and slay them; and Caicher the Druid applied a remedy to this by melting wax in their ears so that they could not hear the music lest it might put them to sleep. They went on in this way till they put into port at the extremity of Sliabh Rife in the north; and it was there that Caicher foretold them that they would not find a dwelling-place anywhere till they reached Ireland, and that it was not they themselves who would reach it but their descendants. Thence they set out and reached Gothia; and to Laimhfhionn was born a renowned son called Eibhear Gluinfhionn, and the race of Gaedhael dwelt in that country thirty years, and some of their progeny are there to this day. In proof of this Giolla Caomhain composed this stanza:


> 1. The race of skilful, beloved Gaedheal
>   
> Were thirty years in that land;
>   
> Some of their tribe remain there ever since
>   
> Until the end of the world.
> 




Other seanchas are of opinion that the race of Gaedheal dwelt in Gothia a hundred and fifty years; and this is the most probable opinion. For it is plain that the race of Gaedheal spent eight generations in Gothia, namely, from Eibhear Gluinfhionn to Bratha. These generations are as follows: Bratha son of Deaghaidh, son of Earchaidh, son of Ealloit, son of Nuadha, son of Neanul, son of Eibric, son of Eibhear Gluinfhionn, who was born in Gothia itself son of Laimhfhionn, the first leader of the race of Gaedheal that came into that country; and since so many generations could not come


---

p.37




within thirty years, I am convinced that the latter opinion is the true one.


Other seanchas assert that it was three hundred years the race of Gaedheal dwelt in Gothia. But this cannot be true, since, according to the times of the Invasions, as we have said above, there were not three hundred years in full from the time Pharao was drowned in the Red Sea until the coming of the sons of Milidh to Ireland. Hence this opinion cannot be true, since within that period the race of Gaedheal went through the whole of their wanderings from Egypt to Crete, and from Crete to Scythia, and from Scythia to Gothia, from Gothia to Spain, from Spain to Scythia, and from Scythia to Egypt, and from Egypt to Thrace, from Thrace to Gothia, and from Gothia to Spain, and from Spain to Ireland.




---

p.39


XVIII.
------


#### Of the journeying of the race of Gaedbeal from Gothia to Spain as follows.


Now Bratha son of Deaghaidh, the eighth in descent from Eibhear Gluinfhionn, proceeded from Gothia by Crete and Sicily, having Europe on the right, to Spain, there being with him the crews of four ships, as Giolla Caomhain says in this stanza:


> 1. Bratha son of Deaghaidh the beloved
>   
> Came to Crete to Sicily;
>   
> The crews of four well-rigged ships safely came,
>   
> Having Europe on the right, to Spain.
> 



From Bratha Braganza in Portugal is named, where lies the duchy of Braganza. Here are the four leaders that came with Bratha to Spain on that expedition: Oige and Uige, two sons of Ealloit son of Neanul, Manntan and Caicher. There were fourteen wedded couples and six servants in each of the ships; and they routed the natives thrice, after they had come to land, that is, the race of Tubal son of Japhet. However, a one-day's plague came afterwards upon the followers of the son of Ealloit; and they died all but ten. But after this they increased; and Breoghan son of Bratha was born.


The general chronicle of Spain, which was written by a French gentleman called Lobhaois, as we read in Edward Grimston, page 3, says that the first king who obtained sovereignty over all Spain was a person called Brigus, who built many castles; and it is he who, in the Book of Invasions, is called Breoghan, the grandfather of Milidh of Spain; and it is from him the Brigantes are so called; and, according to the same chronicle, it is from him that the country now called Castile was given the name Brigia in olden times; and a castle was the emblem on his shield, as is the case with the king of Spain now.




---

p.41


It was this Breoghan, too, who defeated Spain in many battles; and it was he who finished or built Brigansia near Corunna, and the tower of Breoghan in Corunna itself. Whence Giolla Caomhain composed this stanza: 


> 1. Many contests and battles
>   
> Over the proud host of Spain
>   
> Won Breoghan of conflicts and strifes,
>   
> Who built Brigansia.
> 




This Breoghan had ten sons, namely, Breogha, Fuad, Muirtheimhne, Cuailgne, Cuala, Bladh, Eibhle, Nar, Ioth, and Bile. And hereupon the same author composed this stanza:


> 1. The ten sons of Breoghan without faltering;
>   
> Breogha, Fuad, and Muirtheimhne,
>   
> Cuailgne, Cuala, noble Bladh,
>   
> Eibhle, Nar, Ioth, and Bile.
> 



Now Galamh, who is called Milidh of Spain, was a son of the Bile here mentioned; and although Bile be the last-named of the sons of Breoghan in the stanza given above, the authors of our records assert that he was the eldest of Breoghan's sons.


And when the race of Breoghan had multiplied and had conquered the greater part of Spain, a mighty son of renowned deeds called Galamh was born to Bile son of Breoghan; and it is he who is named Milidh of Spain; and he was seized by a desire to go to Scythia with a fleetful of the young men of Spain to visit his kinsmen and to serve under them. Having resolved on this undertaking, he equipped thirty ships, placing in them their complement of warriors, launched on the Torrian Sea, and proceeded directly northeastward to Sicily and to Crete, until he reached Scythia; and when he had landed there, he sent word to Reafloir son of Neomann, who was king of Scythia at that time; and this Reafloir son of Neomann was of the race of Reafloir son of Rifill, whom we have mentioned above. Now when Milidh


---

p.43




came into the presence of Reafloir, the latter welcomed him; and shortly afterwards that king made him commander of the forces of Scythia, and gave him in marriage his own daughter, whose name was Seang daughter of Reafloir, and she bore him two sons, namely, Donn and Airioch Feabhruadh.


And when Milidh had passed some time in Scythia, he had much success against rebels and plunderers in that country, so that the inhabitants loved him greatly. When Reafloir the king perceived this, he grew afraid lest Milidh should oppose him and deprive him of the kingdom of Scythia; and accordingly he conspired to kill him, notwith-standing that he was his son-in-law. And when Milidh heard this, he sought an opportunity and killed Reafloir the king; and he then assembled and brought together his own followers and put to sea with the crews of threescore ships, and proceeded by direct route through the Torrian Sea till he reached the mouth of the Nile; and when he had landed there, he sent messengers to Pharao Nectonibus, informing him that he had arrived in the country; and that king sent messengers to Milidh; and when the latter came into his presence, he bade him welcome, and gave territory in that country to himself and his followers to abide in. This expedition of Milidh from Scythia to Egypt is related by Giolla Caomhain in this stanza:


> 1. Milidh, whose progeny was good,
>   
> Slew Reafloir, who was not weak;
>   
> Hastily did he fly from yon land
>   
> To the river Nile, where he obtained territory.
> 




Understand, O reader, that the two sons whom Seang daughter of Reafloir bore to Mileadh, that is, Donn and Airioch Feabhruadh, were with him on his voyage to Egypt, their mother having died in Scythia.


At this time a great war took place between king Pharao and the king of Aethiopia. Pharao, when he had satisfied himself as to the valour and prowess of Milidh, made him commander of his army to


---

p.45




oppose the army of the Aethiopians, and he fought the Aethiopian army in many battles and conflicts; and Milidh was most successful, so that his fame and renown spread throughout the nations, so that, as a consequence, Pharao gave him his own daughter to wife, who was called Scota, from being the wife of Milidh, who was of the race of Scot. And she bore him two sons in Egypt, namely, Eibhear Fionn and Aimhirgin; and immediately on Milidh's reaching Egypt, he set twelve of the youths who accompanied him to learn the principal crafts of Egypt, so that each of them might become proficient in his own craft at the end of the seven years that he dwelt in Egypt.


As for Milidh, he bethought him that Caicher the Druid had foretold, long before, to his ancestor Laimhfhionn, that it was in Ireland his descendants would obtain permanent sovereignty; and accordingly he fitted out sixty ships, putting the full number of warriors into them, and bade farewell to Pharao. Thereupon, he proceeded from the mouth of the river Nile through the Torrian Sea till he landed on an island close to Thrace, which is called Irena; and it was here that Ir son of Milidh was born. Thence he proceeded to an island called Gothia, which lies in the channel leading to the northern ocean; and he dwelt there for some time, and it was there that Scota bore him a son called Colpa of the Sword. Thence they proceeded into the narrow sea which separates Asia from Europe on the north, and continued in a westerly direction, having Europe on the left, till they came to Cruithentuaith, which is called Alba. They plundered the coasts of that country, and afterwards proceeded, having Great Britain on their right, and reached the mouth of the river Rhine, and continued in a south-westerly direction, having France on the left, and after that they landed in Biscay.


Now, when they had arrived in that country, Milidh's kinsmen came to bid him welcome; and they informed him 


---

p.47




that the Goths, and many other foreign tribes, were harassing both that country and all Spain. Upon hearing this, Milidh summoned his own supporters throughout Spain; and when they had assembled in one place, he set out with them, and with the fleetful that had come into the country with him, against the Goths and the foreign tribes, and defeated them in fifty-four battles, and banished them from Spain; and he himself and his kinsmen, that is, the descendants of Breoghan son of Bratha, took possession of the greater part of that country. At this time, Milidh had thirty-two sons, as the poet says:


> 1. Thirty sons and two sons
>   
> Had Milidh of bright hands;
>   
> There came of these, we are certain,
>   
> Only a single eight to Ireland.
> 



Twenty-four of these were born to him in concubinage before he set out from Spain for Scythia, and the other eight were borne to him by the two wives he had in succession, namely, Seang daughter of Reafloir, prince of Scythia, who gave birth to two of them in Scythia, namely Donn and Aerioch Feabhruadh, and Scota, the daughter of Pharao Nectonibus, who gave birth to the remaining six of them, to wit, two in Egypt, Eibhear Fionn and Aimhirgin, Ir on the Thracian Sea, Colpa of the Sword in Gothia, Arannan and Eireamhon in Galicia, as Conaing the poet says in the following historical poem:


> 1. Eight sons of Galamh of the shouts,
>   
> Who was called Milidh of Spain,
>   
> They hewed down a thousand fields;
>   
> In what countries were they born?
> 2. Airioch Feabhruadh and Donn of conflicts
>   
> Were born in Scythia;
>   
> There were born in stream-filled Egypt
>   
> Eibhear Fionn and Aimhirgin;
> 
> 
> ---
> 
> p.49
> 
> 5. Ir, no warrior was greater,
>   
> Was born beside Thrace;
>   
> Colpa of the Sword was born
>   
> In Colpa's Glen in Gaothlaidhe;
> 6. There were born at Breoghan's tower without grief
>   
> Arannan and Eireamhon,
>   
> The two youngest of the faultless warriors;
>   
> The Son of God subdued their strength.Eight.
> 






---

p.51


XIX.
----


When the race of Breoghan son of Bratha had increased, they were strong and numerous in Spain; and because of the Greatness of their exploits, they resolved to extend their sway in other directions. They had another motive also. For, at that time, there was a scarcity of food in Spain for the space of twenty-six years, on account of the great drought that existed during that period, and also because of the many conflicts that took place between them and the Goths, and the other foreign races, with whom they were contending for the mastery of Spain. They accordingly took counsel together as to what country they should explore, and who should be sent to explore it. What they resolved on was, to elect Ioth son of Breoghan, son of Bratha, who was a valiant man, and also wise and learned in the sciences, for the purpose of exploring the island of Ireland. And the place where they adopted this counsel was at the tower of Breoghan in Galicia.


It was in this manner that they sent Ioth to Ireland, and not, as others assert, that he had seen it in the clouds of heaven on a winter's night from the summit of the tower of Breoghan. For there had been familiarity and intercourse before then between Ireland and Spain since the time when Eochaidh son of Earc, the last king of the Fir Bolg, took Taillte daughter of Maghmhor, king of Spain, to wife. They thus had been in the habit of trading with one another, and of exchanging their wares and valuables, so that the Spaniards were familiar with Ireland, and the Irish had a knowledge of Spain before Ioth son of Breoghan was born. Hence it was not from a view obtained in a single night from the summit of the tower of Breoghan that Ioth, or the children of Breoghan, acquired a knowledge of Ireland, but from there having been intercourse for a long time previously between Spain and Ireland.




---

p.53


Now, Ioth equipped a ship and manned it with thrice fifty chosen warriors, and put out to sea until they reached the northern part of Ireland, and put into port at Breantracht Mhaighe Iotha. And when Ioth landed there, he sacrificed to Neptune, the god of the sea, and the demons gave him bad omens. Thereupon, a company of the natives came and spoke with him in Scoitbhearla, that is, in Gaelic; and he replied to them in the same tongue, and said that it was from Magog he himself was descended, as they were, and that Scoitbhearla was his native language as it was theirs. Taking their cue from this passage in the Book of Invasions, the seanchas state that Scoitbhearla, which is called Gaelic, was the mother tongue of Neimhidh and his tribe, and therefore also of the Fir Bolg and the Tuatha De Danann. For this may be believed from what we have stated above, that it was Gaedheal son of Eathor, at the command of Feinius Farsaidh, king of Scythia, who regulated and set in order the Scoitbhearla; and it is from this Gaedheal that it was called Gaelic as we have said above.


Now, this Gaedheal had been teaching the public schools in Scythia before Neimhidh proceeded from Scythia on an expedition to Ireland; and since Scoitbhearla was the common tongue of Scythia when Neimhidh set out from that country,according to the seanchas, the Scoitbhearla must have been the mother tongue of Neimhidh and of his followers when they came to Ireland, and accordingly of every colony sprung from him or from his descendants who came to Ireland, not to mention the descendants of Milidh, whose native language was the Scoitbhearla from the time that Niul left Scythia to the present time. **Richard Creagh**, primate of Ireland, supports this view in the book he has written on the origin of Gaelic and of the race of Gaedheal. He speaks as follows: *The Gaelic speech, (he says,) has been in common use in Ireland from the coming of Neimidh, six hundred and thirty years after the Deluge, to this day. {Gaelica locutio est in usu in Hibernia ab adventu Nemedii anno 630 a Diluvio in hunc usque diem.}’’*

 From what we have said, it is not improbable


---

p.55




that it was in Scoitbhearla that Ioth and the Tuatha De Danann conversed with one another.
As to Ioth, he proceeded to ask them the name of the country and who held the sovereignty of it at that time. The company he had first fallen in with explained that the name of the country was Inis Ealga, and that the three sons of Cearmad Milbheoil son of the Daghaidh held the sovereignty of it yearly, in succession, as we have said above, that they were at that time at Oileach Neid, in the north of Ulster, contending with one another about the valuables of their ancestors. Upon hearing this, Ioth set out with two-thirds of the company who had come with him in the ship, the full number manning the ship being thrice fifty warriors. And when he had come into the presence of the sons of Cearmad, they bade him welcome, and made known to him the cause of their contention. He, on his part, informed them that it was through stress of weather at sea he had landed in the country, and that he did not intend to dwell there, but to return to his own country. But as they deemed Ioth a learned man, they chose him as a judge in the dispute that was between them, and his decision was that the valuables be divided into three equal parts between them; and he thereupon proceeded to praise Ireland, and said it was wrong for them to dispute with one another, seeing that the island so abounded in honey, in fruit, in fish, and in milk, in grain and corn, and that the climate was so temperate as regards heat and cold. He further said that, if a tripartite division were made of the country between them, it would be sufficient for them all. Ioth then took his leave of them, and with his hundred warriors set out for his ship.


As to the sons of Cearmad, they observed how highly Ioth had praised Ireland; and they believed that, were he to reach his own country, he would return with a large host to conquer Ireland; and they resolved to send the son of Coll with thrice fifty warriors in pursuit of him. These overtook him, and Ioth placed himself in the


---

p.57




rear of his party, and conducted them to northwards Magh Iotha; and a conflict took place between them, and Ioth fell there; and his followers took him with them in their ship, and he died at sea in their midst, and was buried in Spain, his body having been previously exhibited to the sons of Milidh in order to incite them to come to Ireland to avenge him on the sons of Cearmad. Some seanchas are of opinion that it was at Druim Lighean that Ioth was slain, and that he was buried at Magh Iotha. But the above view is better established and more probable.


#### Of the invasion of Ireland by the sons of Milidh, and of their doings, and from what country they came to Ireland.


**Hector Boetius**, in the third chapter of the History of Scotland, states that Eibhear and Eireamhon were sons of Gaedheal. Now this cannot be true, since, according to Cormac son of Cuileannan in his chronicle, Gaedheal was a contemporary of Moses; and he says, moreover, according to the Book of Invasions, that it was two hundred and eighty-three years after the drowning of Pharao that the sons of Milidh came to Ireland, and therefore Gaedheal could not have been the father of Eibhear or of Eireamhon. It is plain also, according to Cormac, in the enumeration of the generations he has made from Galamh, called Milidh of Spain, who was father of Eibhear and of Eireamhon, to Noe, that it was not Gaedheal who was their father. Here is the pedigree to Noe, according to Cormac: Galamh son of Bile, son of Breoghan, son of Bratha, son of Deaghaidh, son of Earchaidh, son of Ealloit, son of Nuadha, son of Neanul, son of Eibric Glas, son of Eibhear Gluinfhionn, son of Laimhfionn, son of Aghnon, son of Tat, son of Ogaman, son of Beodhaman, son of Eibhear Scot, son of Sru, son of Easru, son of Gaedheal Glas, son of Niul, son of Feinius Farsaidh, son of Baath, son of Magog, son of Japhet, son of Noe.




---

p.59


Whoever reads the History of **Hector Boetius** would imagine that he is of opinion that the Gaels of Alba sprang from a different Gaedheal from the Gaedheal whence the Irish sprang. However, I am content with the opinion of a reputable Scotch author, **Johannes Major**, who asserts that it is from the Gaels of Ireland the Gaels of Alba sprang. He speaks in these terms: *For this reason, I assert, (says he,) that whatever stock the Irish be from, the Albanians are from the same stock. {Dico ergo a quibuscunque Hibernici originem duxere ab iisdem Scoti exordium capiunt.}’’*

 Beda agrees with this view in the first chapter of the first book of the History of the Church of Sacsa, where he says: *In the course of time, (says he,) Britain received, after the Britons and the Picts, a third race in the portion or division of the Picts, a race that came from Ireland together with their chief Rheada, who seized on a settlement for themselves among the Picts by friendship or with arms, which they retain to the present time. {Procedente autem tempore Britannia post Britones et Pictos tertiam Scotorum nationem in Pictorum parte recepit qui duce Rheada de Hibernia egressi vel amicitia vel ferro sibimet inter eos sedes quas hactenus habent vindicarunt.}’’*Historia Ecclesiastica Gentis Anglorum,* libro primo, cap. primo*
From this it is to be inferred, in accordance with Beda, that it was from Ireland the Scotic race, together with their chief Rheada, went to Scotland, and that their descendants are there to this day, and that it is they who are called Scots. **Humphredus**, a Welsh author, speaks thus: *The Scots themselves, and all besides, know well that they are the descendants of the Irish; and our countrymen (that is, the Welsh) call them by the same name, that is, Gaels. {Scotos Hibernorum proles et ipsi et omnes optime norunt eodemque nomine a nostratibus scilicet Gaidhil appellantur.}’’*

 Moreover, Cambrensis, in the sixteenth chapter of the third distinction of the book he has written describing Ireland, points out that it was when Niall Naoighiallach held the sovereignty of Ireland that the six sons of Muiredhach, king of Ulster, went to Alba, that they acquired power and supremacy there, and that it was at this time that the name Scotia was first given to Alba, and that it is from these sons of the king of Ulster that the Albanians are called the Scotic race. Of these sons he speaks as follows:


---

p.61


*And hence, (says he,) it is from them that the Gaels of Scotland are descended, and are specially called the Scotic race to this day. {Unde et gens ab his propagata et specificato vocabulo Scotica vocata usque in hodiernum.}’’*
According to what we have said the two opinions advanced by **Hector Boetius** in the History of Scotland are false: the first in which he imagines that Gaedheal was the father of the children of Milidh; and the second in which he thinks that the Gaedheal from whom the Gaelic race of Alba are descended was a different person from the Gaedheal from whom sprang the sons of Milidh who conquered Ireland.


**Buchanan**, a Scotch author, in the History of Scotland which he has written, asserts that it was from France the sons of Milidh came to Ireland; and he advances, as he thinks, three reasons for this. The first of these reasons is that in which he says that France was so populous that the portion of it called Gallia Lugdunensis could supply three hundred thousand fighting men, and hence that it is likely that she sent out surplus forces to occupy other countries, and that accordingly she sent forth a company to occupy Ireland, namely, the tribe of Gaedheal. My reply to this reason is, that this author did not know when the sons of Milidh came to Ireland, and accordingly did not know whether France was populous or waste when the sons of Milidh came to Ireland. Moreover, granted that France was as populous as he represents it to have been when the sons of Milidh came to Ireland, it does not necessarily follow from this that it was from France the sons of Milidh came. For why should France be populous at that time rather than Spain, whence the sons of Milidh came? It thus appears how trifling is this reason that **Buchanan** advances to prove that it was from France that the sons of Milidh originally came.


The second silly argument he gives for supposing that it was from France the sons of Milidh came to Ireland is, that certain French and Irish words are identical, such as dris


---

p.63




and dun, which are identical in Irish and in French, and a few others of a similar kind. My reply to this reason is, that there are words from every language as loan-words in the fourth division of Irish which is called **Bearla Teibidhe** from the time of Fenius Farsaidh onwards. And thus as there are words from French in it, so there are words in it from Spanish, from Italian, from Greek, from Hebrew, from Latin, and from every other chief language. And hence it is no proof of the Gaels having come from France that a few words should be identical in Irish and in French; and, moreover, I believe that the few words that are common to them were taken from Ireland to France; and I hold this view all the more because **Caesar** says, in the sixth book of his History, that it was from the islands of Britain that druids went to France, where they became judges, and got **termon** lands and immunities and honour from the nobles of that country.




---

p.65


XX.
---


It is probable that this island whence the druids went to France was the island of Ireland, since Ireland was the fountain of druidism for western Europe at that time, and that accordingly Gaelic was the language of these druids. Or if it was from Manainn they went thither, it is well known that Gaelic was the mother-tongue there, according to **Ortelius**, who, treating of Manainn, says: *They use, (he says,) the Scotic language, or Gaelic, which is the same. {Lingua Scotia, seu Hibernica quae eadem est, utuntur.}’’*


Accordingly it is probable that, when these druids were teaching in France, the youth of France, from their intercourse with the druids, caught up a certain number of Irish words, and that these have ever since been in use in the French language; and, moreover, **Camden** states in the book called Britannia Camdeni, that the druids taught in their schools more from oral tradition than from writing.


Another reason why it should not seem strange that Irish words should be embodied in French is, the great intercourse that existed between the Irish and the French. For the Book of Invasions says that the wife of Ughaine Mor, high king of Ireland, was a daughter of the king of the French, and this Ughaine went to conquer France. In like manner another high king of Ireland, Niall Naoighiallach, a long time after Ughaine, went to conquer France, and was slain at the river Leor, in France, by Eochaidh son of Eanna Cinnsealach, king of Leinster. Criomhthann son of Fiodhach, king of Ireland, went to France before Niall. Another high king of Ireland also, whose name was Dathi son of Fiachraidh, went on an expedition of conquest to France; but he was slain by lightning in the east of France, beside the Alp mountains. Similarly, **Cornelius Tacitus** says that commercial


---

p.67




exchange and intercourse existed between Ireland and France. From what we have said, it is not strange that there should have been a borrowing of words from Irish into French and from French into Irish. However, it does not necessarily follow from this that it was from France the race of Gaedheal came to Ireland. Hence, the second argument that **Buchanan** advances is trivial.


False again is the third argument that **Buchanan** gives in which he says that the manners and customs of the French and of the Irish are the same. Now, whoever reads **Joannes Bohemus**, in the book which he has written on the manners and customs of all nations, will find plainly there that neither the manners nor the customs of the French and the Irish are the same at present, nor were they the same in the distant past. Accordingly false is the third reason he alleges as a proof that the race of Gaedheal came first to Ireland from France.


Some modern English writers treating of Ireland state that it was from Great Britain that the sons of Milidh first came, and their reason for that view is, that there are many words identical in Irish and Welsh. My reply to this reason is, that it is not a proof of the race of Gaedheal having first come from Great Britain. There are two reasons for this. The first reason is, that Gaelic was the mother tongue of Briotan son of Fearghus Leithdhearg, son of Neimhidh, and that it was from him Britain was called Britannia, according to Cormac son of Cuileannan and the Books of Invasion of Ireland, and that it was in Britain he and his descendants after him dwelt; that Eireamhon son of Milidh sent the Cruithnigh, who are called Picts, to share Alba with them; and that Brutus son of Silvias, if we may believe some of their own chronicles, invaded them, and after him the Romans, and then the Saxons and the **Lochlonnaigh**, and finally **William the**  and the French, so that they suffered so much oppression from foreigners that it was not


---

p.69




strange that Scoitbhearla, which was the language of Briotan and of his descendants after him, should fail. Still the little of it that remains alive without being completely extinguished is identical with Gaelic, as much of it as has remained from the time of Briotan without change.


The second reason why it is not strange that many words are the same in Irish and in Welsh, without supposing the sons of Milidh to have come to Ireland from Britain, is that Ireland was a place of refuge for Britons whenever they suffered persecution from the Romans or the Saxons, or from any other races that oppressed them, so that large companies of them, with their families and followers, and with their wealth, used to fly for refuge to Ireland; and the Irish nobles used to give them land during their stay; and the children, they had during their time of exile used to learn Irish, and there are townlands in Ireland named from them, as Graig na mBreathnach, Baile na mBreathnach, Dun na mBreathnach, etc.; and after they returned to Britain they themselves, and their descendants after them, had many Irish words in constant use. From what we have said, it is not necessarily to be inferred that it was from Britain the sons of Milidh first came, notwithstanding that there are some words identical in Welsh and in Irish. Furthermore, if anyone were to say that the Welsh and the Irish are alike in their manners and customs, since as the Irishman is hospitable in bestowing food without payment so is the Welshman; as, moreover, the Irishman loves seanchas, poets and bards and harpplayers, the Welshman has a similar love, for these classes, and in the same way they resemble one another in several other customs; this is not a proof that the Gaels came from Britain, but is rather a proof that the Welsh were familiar with Ireland, as we have said above; and hence it is not to be inferred from the forementioned reasons that it was from Great Britain the sons of Milidh first came. It may, however, be stated with truth that a company of the race of Breoghan


---

p.71




went from Ireland to settle in Great Britain, to wit, some of the descendants of the chiefs of the race of Breoghan who came with the sons of Milidh to Ireland.


The following are the names of those sons of Breoghan who came with the sons of Milidh to Ireland, namely, Breagha, Fuad, Muirtheimhne, Cuailgne, Cuala, Eibhle, Bladh, and Nar. It is precisely from the progeny of these, according to the records of Ireland, that the race called Brigantes are descended; and the truth of this should be the more readily admitted, as **Thomasius**, in the Latin Dictionary which he has written, says that the Brigantes, that is, the descendants of Breoghan, were an Irish tribe.


A Spanish author named **Florianus del Campo**, agreeing with the Irish records, says that the Brigantes were Spanish by origin, and that it was from Spain they came to Ireland, and from Ireland they went to Britain.


All that we have stated concerning the intercourse of the Britons with the Irish, and Ireland's being a place of refuge for the Britons, is the more probable, because **Caradocus**, a Welsh author, in his chronicle, and **Albion** in his chronicle, and many other Welsh authors, state that many British princes and nobles, with their families and followers, used to come to Ireland, where they were received and kindly entertained, and where they got land to settle down in, as we have said above. Moreover, **Doctor Hanmer**, in his chronicle, makes special mention of some of them. In the first place, he says that a king of Wales named **Cadualin** was banished to Ireland by **Edwin son of Athelfred** in the year of the Lord 635, and that he was kindly received there, and got a reinforcement for his army, by means of which he recovered his own kingdom. He also states that two princes from Britain, namely, Haralt and Conan, came to Ireland in the year of the Lord 1050, and that they were received and even treated in a friendly manner and protected by the Irish. He says likewise that Allgor, Earl of Chester, fled from Britain


---

p.73




to Ireland for refuge, and that the Irish sent a force with him by means of which he regained his own territory in the year of the Lord 1054. There came also for refuge to Ireland another Welsh prince whose name was Bleithin ap Conan in the year of the Lord 1087; and he was maintained during his visit there. Thus from age to age did they cultivate alliance and had intercourse with one another.


In **Hanmer**'s chronicle, also, we read that Arnulfus, Earl of Pembroke, married the daughter of Muircheartach O'Brien, King of Ireland, in the year of the Lord 1101. And his second daughter was married to Maghnus son of Aralt, king of the Isles. Moreover, when Henry the First was on the throne of England, there was a prince over Wales whose name was Griffin ap Conan, who used often boast that his mother was an Irishwoman, and also his grandmother, and that it was in Ireland he was born and educated in politeness. According to the same author there was also another prince of Wales in the time of Henry the Second, whose name was Biradus son of Guineth, who had an Irishwoman for his mother. In this manner there used to be much intercourse of friendship and of alliance between the Irish and Welsh, so that therefore it is not to be wondered at that there are many words common to their languages, and that they resemble one another in their manners and customs, without supposing that the Gaels ever came originally from Britain.


Camden says, in like manner, that the Brigantes settled in the following territories of Great Britain, to wit, the district of York, the district of Lancaster, the district of Durham, the district of Westmoreland, and the district of Cumberland; and it is not strange, from what we have said, that the Welsh and the Irish should resemble one another in their manners and customs, and that there should be many words common to both their languages without supposing the sons of Milidh to have ever come from Britain originally, notwithstanding Camden, who says that it was from Britain


---

p.75




that the first inhabitants came to Ireland. Now the seanchus of Ireland, whose function it is to investigate and preserve an exact account of every event that ever happened in Ireland, is more deserving of credit than the opinion of Camden, to whom Irish history never gave up its secret from which he could derive a knowlege of the affairs of Ireland.


Cambrensis, writing of Ireland, says that it was by permission of the King of Great Britain that the sons of Milidh came from Biscay, and that, moreover, it was at his inducement they came after him to the Orcades, and that he sent a company with them to Ireland so that they might settle down there on condition that themselves and their descendants should be subject to him and to the kings of Great Britain for ever; and Cambrensis gives the king's name as Gorguntius son of Beilin. In the same way my reply to Cambrensis is, that it is plain that his statement is false. For, whoever will read **Stowe**'s Chronicle will plainly find that there is little more than three hundred years from the reign of that Gorguntius over Great Britain till the coming of Julius Caesar to conquer it, the eighth year of the reign of Cassibellanus over Great Britain; and we read in the same author that they were only about forty-two years from Julius Caesar to the birth of Christ, so that, according to the computation of Stowe, there were not four hundred years in full from the time of Gorguntius to the birth of Christ. Now Cormac son of Cuileannan and the Books of Invasion of Ireland state that it was about thirteen hundred years before the birth of Christ that the sons of Milidh came to Ireland. And the Polychronicon agrees with them in the same computation where it treats of Ireland. It thus speaks: *There are, (it says,) one thousand eight hundred years from the arrival of the Irish to the death of Patrick. {Ab adventu Ibernensium usque ad obitum Sancti Patricii sunt anni mille octigenti.}’’*

 This is equivalent to saying that it was about thirteen hundred years before Christ that the sons of Milidh came to Ireland. For deduct the four hundred and ninety-two years from the birth of Christ to the 


---

p.77




death of Patrick from the eighteen hundred years the Polychronicon computes to be between the coming of the sons of Milidh to Ireland and the death of Patrick, and there will be one thousand three hundred and eight years from the coming of the sons of Milidh to Ireland to the birth of Christ, so that the Polychronicon, Cormac son of Cuileannan, and the Books of Invasion agree with one another in computing the time from the invasion of the sons of Milidh to the birth of Christ; and if we compare, according to the Chronicle of Stowe, the space of time between Gorguntius and the birth of Christ, and similarly the space of time the Polychronicon, and Cormac son of Cuileannan, and the Books of Invasion compute to be from the coming of the sons of Milidh to Ireland to the birth of Christ, we shall plainly find that the sons of Milidh were in Ireland more than nine hundred years before Gorguntius assumed the sovereignty of Great Britain. From what we have said it is obvious that it is a baseless falsehood Cambrensis states in his chronicle when he says that Gorguntius above-mentioned brought after him the sons of Milidh to the Orcades, and sent them thence to Ireland. For how could Gorguntius send them to Ireland, seeing he was not himself born, according to authorities we have cited here, until nine hundred years after the sons of Milidh had come to Ireland?


---

p.79


XXI.
----


#### Of the coming of the sons of Milidh to Ireland as follows:


When the sons of Milidh and all the descendants of Breoghan heard that the children of Cearmad had murdered Ioth son of Breoghan and his followers, and when they saw his body mangled and lifeless, they resolved to come to Ireland to avenge him on the children of Cearmad, and they assembled an army to come to Ireland to wrest that country from the Tuatha De Danann in retribution for the deed of treachery they had done against Ioth son of Breoghan and his followers. Some seanchas assert that it was from Biscay the sons of Milidh went to Ireland from the place which is called Mondaca beside the river-mouth of Verindo; and their reason for this opinion is that Milidh was king of Biscay after he had been banished by the violence of many foreign tribes from the very heart of Spain to Biscay, where there were many woods, hills, and fastnesses protecting Biscay from the fury of foreign races. This, however, is not the general opinion of the seanchas. What they assert is that it was from the tower of Breoghan in Galicia they came to Ireland, and this is the view I regard as the most probable. For we read in the Book of Invasions that it was at Breoghan's tower they resolved on sending Ioth son of Breoghan to explore Ireland, and that it was to it Lughaidh son of Ioth came when he returned from Ireland, and showed his father's dead body to the sons of Milidh and to the sons of Breoghan; and accordingly I believe that it was from the same place they proceeded to Ireland very soon after the death of Milidh. And it was because of the death of Milidh that Scota came to Ireland with her children, Spain being at that time a bone of contention between the tribes who inhabited Spain itself and the numerous foreign tribes who came from the north of Europe to overcome them.




---

p.81


As to the sons of Milidh, they got together an army to come to Ireland and avenge Ioth on the Tuatha De Danann and on the children of Cearmad, and to wrest Ireland from them; and the full number of leaders they had to rule the warriors was forty, as we read in the poem composed by **Eochaidh O'Floinn**, beginning, The Leaders of those oversea ships: 


> 1. The leaders of those over-sea ships
>   
> In which the sons of Milidh came,
>   
> I shall remember all my life
>   
> Their names and their fates:
> 2. Eibhle, Fuad, Breagba, excellent Bladh,
>   
> Lughaidh, Muirtheimhne from the lake,
>   
> Buas, Breas, Buaidhne of great vigour,
>   
> Donn, Ir, Eibhear, Eireamhon,
> 3. Aimhirgin, Colpa without annoyance,
>   
> Eibhear, Airioch, Arannan,
>   
> Cuala, Cuailgne, and generous Nar,
>   
> Muimhne, Luighne, and Laighne,
> 4. Fulman, Manntan, gentle Bile,
>   
> Er, Orba, Fearon, Feirghein,
>   
> En, Uu, Eatan Goistean bright,
>   
> Seadgha, Sobhairce, Suirghe,
> 5. Palap son of noble Eireamhon,
>   
> And Caicher son of Manntan,
>   
> To avenge Ioth of the steeds—
>   
> Ten and thirty leaders.
> The leaders.




Their fleet was thirty ships in all, with thirty warriors in each of the ships, besides their women and camp-followers. The following are their names: Breagha son of Breoghan, from whom Magh Breagh in Meath is called; Cuala son of Breoghan, from whom Sliabh Cuala is called; Cuailgne son of Breoghan, from whom Sliabh Cuailgne is called; Fuad son of Breoghan, from whom Sliabh Fuaid is called; Muirtheimhne son of Breoghan, from whom Magh Muirtheimhne is called; Lughaidh son of Ioth, who came to Ireland to avenge his


---

p.83




father, from him Corca Luighe in West Munster is called; Eibhlinne son of Breoghan, from whom Sliabh Eibhlinne in Munster is called; Buas, Breas, and Buaidhne, three sons of Tighearnbhard son of Brighe; Nar from whom Ros Nair in Sliabh Bladhma is called; Seadgha, Fulman, Manntan, Caicher, and Suirghe son of Caicher; Er, Orba, Fearon, and Feargna, four sons of Eibhear; En, Un, Eatan, and Goistean; Sobhairce, we do not know who was his father; Bile son of Brighe, son of Breoghan; eight sons of Milidh of Spain, to wit, Donn and Airioch Feabhruadh, Eibhear Fionn and Aimhirgin, Ir and Colpa of the Sword, Eireamhon and Arannan the youngest, and four sons of Eireamhon, to wit Muimhne, Luighne, and Laighne, and Palap, and one son of Ir, that is Eibhear. These, then, are the forty leaders of the sons of Milidh who came to Ireland. It was in Ireland itself that Irial Faidh son of Eireamhon was born.


As regards the descendants of Milidh and their fleet there is no account of them until they put into port at Innbhear Slainghe in the lower part of Leinster, which place is called the harbour of Loch Garman to-day. The Tuatha De Danann assembled and congregated round them, and spread a magic mist above them, so that they imagined that the island in front of them was a hog's back, and hence Ireland is called Muicinis. Accordingly, the Tuatha De Danann, by means of magic, drove the sons of Milidh out from the land, and so they went round Ireland and put into port at Innbhear Sceine in West Munster; and when they had landed, they proceeded to Sliabh Mis, where they met Banbha with her women and her druids. Aimhirgin asked her her name. ‘Banbha is my name,’ said she; ‘and it is from me that this island is called Inis Banbha.’ Then they proceeded to Sliabh Eibhlinne where they met Fodla, and Aimhirgin asked her her name. ‘Fodla is my name,’ said she; ‘and it is from me that this land is


---

p.85




called Fodla.’ They proceeded thence to Uisneach in Meath, where they met Eire. The poet asked her her name. ‘Eire is my name,’ said she, ‘and it is from me that this island is called Eire.’ And as a record of the above events is this stanza from the poem beginning, Let us relate the origin of the Gaels:


> 1. Banbha on Sliabh Mis, with hosts
>   
> Faint and wearied;
>   
> Fodla on Sliabh Eibhlinne, with groanings;
>   
> Eire on Uisneach.
> 



These three queens were the wives of the three sons of Cearmad, and some seanchas say that there was no division of Ireland into three equal parts among the sons of Cearmad, but that each of the sons held it for a year in turn; and the name the country bore each year was the name of the wife of him who held the sovereignty that year. Here is a proof of this alternation of sovereignty:


> 1. Every year by turns
>   
> The chiefs held the kingdom;
>   
> Eire, Fodla, and Banbha,
>   
> The three wives of the very strong warriors.
> 




The sons of Milidh proceeded thence to Tara, where they met the three sons of Cearmad, to wit, Eathur, Ceathur, Teathur, with their magic host; and the sons of Milidh demanded battle or a right to the sovereignty of the country from the sons of Cearmad, and these replied that they would act towards them according to the judgment of Aimhirgin, their own brother, and that if he delivered an unjust judgment against them, they would kill him by magic. The judgment Aimhirgin gave regarding his brothers and their host was that they should return to Innbhear Sceine, and that they should embark with all their host and go out the distance of nine waves on the high sea, and if they succeeded in coming to land again in spite of


---

p.87




the Tuatha De Danann, they were to have sway over the country. And the Tuatha De Danann were satisfied with this, for they thought that their own magic would be able to prevent them from returning ever again to the country.


XXII.
-----


As to the sons of Milidh, they returned to Innbhear Sceine, and went out on the high sea, the space of nine waves, as Aimhirgin directed them. When the druids of the Tuatha De Danann saw them on the sea, they raised a terrific magic wind which caused a great storm at sea; and Donn son of Milidh said that it was a druidical wind. ‘So it is,’ said Aimhirgin. Thereupon Arannan, the youngest of the sons of Milidh, climbed the mainmast, and, by reason of gust of wind, he fell to the ship's deck, and thus was killed. And forthwith the rocking of the tempest separated from the rest the ship in which Donn was, and soon after he was himself drowned, and the ships crew along with him, twenty-four warriors in all, and five leaders, to wit, Bile son of Brighe, Airioch Feabhruadh, Buan, Breas, and Buaidhne, with twelve women and four servants, eight oarsmen, and fifty youths in fosterage; and the place where they were drowned is Dumhacha, which is called Teach Duinn, in west Munster. And it is from Donn son of Milidh, who was drowned there, that it is called Teach Duinn. And it is the death of Donn and of those nobles who were drowned with him that Eochaidh O'Floinn narrates in the poem beginning, The leaders of those over-sea ships. Thus does he speak:


> 1. Donn and Bile and Buan, his wife,
>   
> Dil and Airioch son of Milidh,
>   
> Buas, Breas, and Buaidhne, the renowned,
>   
> Were drowned at Dumhacha.
> 



The ship in which was Ir son of Milidh was also separated from the fleet by the storm; and it was driven ashore in


---

p.89



 

the west of Desmond; and there Ir was drowned, and he was buried at Sceilig Mhichil, as the same author says: 


> 1. Aimhirgin, poet of the men,
>   
> Was killed in the Battle of Bile Theineadh;
>   
> Ir died in Sceilig of the warriors,
>   
> And Arannan died in the ship.
> 




Eireamhon, accompanied by a division of the fleet, proceeded, having Ireland on the left, to the mouth of Innbhear Colpa, which is called Droichead Atha. Now, the river is called Innbhear Colpa, from Colpa of the Sword, son of Milidh, having been drowned there as he was coming ashore with Eireamhon son of Milidh. It is plain from this that five of the sons of Milidh were drowned before they took possession of Ireland from the Tuatha De Danann; hence some poet composed this stanza:


> 1. Five of these were drowned,
>   
> Of the swift sons of Milidh,
>   
> In the harbours of Ireland of the divisions,
>   
> Through the magic of the Tuatha De Danann:
> 



these are Donn and Ir, Airioch Feabhruadh, Arannan, and Colpa of the Sword; so that when these sons wrested Ireland from the Tuatha De Danann, there were only three of them surviving, to wit, Eibhear, Eireamhon, and Aimhirgin. As to the remainder of the descendants of Milidh, to wit, Eibhear with his own division of the fleet, they landed at Innbhear Sceine. They met Eire, wife of Mac Greine, on Sliab Mis three days after they had landed, and there the Battle of Sliabh Mis took place between them and the Tuatha De Danann, in which fell Fas wife of Un son of Uige, and from her the name Gleann Fais is given to the glen which is in Sliabh Mis, and is called at present Gleann Fais; and it is to bear testimony to this that the poet composed this stanza:


> 1. Gleann Fais, true is the derivation,
>   
> Without error or difficulty;
>   
> Fas the name of the woman I refer to
>   
> Who was killed in the great glen.
> 




---

p.91




In the same battle fell Scota wife of Milidh; and it is in the north side of that glen, beside the sea, she is buried; and as a proof of her death and of her burial-place, we have the two following stanzas from the same poem:


> 1. In this battle also, I will not deny,
>   
> Scota found death and extinction;
>   
> As she is not alive in fair form,
>   
> She met her death in this glen.
> 2. Whence there is in the north side
>   
> The tomb of Scota in the clear, cold glen,
>   
> Between the mountain and the sea;
>   
> Not far did she go from the conflict.
> 



This was the first battle that took place between the sons of Milidh and the Tuatha De Danann, as the same poem says: 


> 1. The first battle of the famed sons of Milidh,
>   
> On their coming from Spain of renown,
>   
> At Sliabh Mis there was cause of woe;
>   
> It is certain history and true knowledge.
> 



The two women we have mentioned, to wit, Scota and Fas and their two most accomplished druids, that is, Uar and Eithiar, were the most celebrated of the race of Gaedheal who fell in that battle. But though three hundred of them were slain, still they slew ten hundred of the Tuatha De Danann, and thus routed them; and Eire wife of Mac Greine followed in their wake, and proceeded to Taillte, and related her story to the sons of Cearmad. Now, the sons of Milidh remained on the field of battle, burying those of their people who were slain, and in particular burying the two druids. It is with reference to this that the poet composed the following historical stanzas: 


> 1. In the morning we left Sliabh Mis;
>   
> We met with aggression and defiance
>   
> From the sons of the noble Daghadh,
>   
> With strong battle-spears.
> 
> 
> ---
> 
> p.93
> 
> 4. - We *stoutly won a* battle
>   
> *Over* the sprites of the isle of Banbha,
>   
> Of which ten hundred fell together,
>   
> By us, of the Tuatha De Danann.
> - Six fifties of our company
>   
> Of the great army of Spain,
>   
> That number of our host fell,
>   
> With the loss of the two worthy druids:
> - Uar and Eithiar of the steeds,
>   
> Beloved were the two genuine poets;
>   
> A stone in bareness above their graves,
>   
> In their Fenian tombs we leave them.
> 




Eight also of the leaders of the host fell at sea through the magic of the Tuatha De Danann, as we have said above, namely, Ir at Sceilig Mhichil; Arannan, from the mainmast; Donn with his five leaders, who were drowned at Teach Duinn. Eight royal ladies also fell there, two of them with Donn, namely, Buan wife of Bile, and Dil daughter of Milidh of Spain, wife and kinswoman of Donn. There were also drowned Sceine wife of Aimhirgin, in Innbhear Sceine and from her the nameInnbhear Sceine is given to the river which is in Kerry. Fial wife of Lughaidh son of Ioth died of shame on her husband seeing her naked as she returned from swimming; and from her that river has ever since been called Innbhear Feile; Scota and Fas were also slain in the Battle of Sliab Mis, as we have said above. Two others of them also died, namely, the wife of Ir and the wife of Muirtheimhne son of Breoghan. These then are the eight princesses and the eight leaders that perished out of the host of the descendants of Milidh from their coming into Ireland up to the Battle of Taillte. Here are the names of the seven principal women who came to Ireland with the sons of Milidh, according to the Book of Invasions: Scota, Tea, Fial, Fas, Liobhra, Odhbha, and Sceine. It is in the following manner the seancha sets forth this, and states who was


---

p.95




married to each of the women whose husband was alive on their coming to Ireland:


> 1. The seven chief women who came thither
>   
> With all the sons of Milidh,
>   
> Tea, Fial, Fas, to our delight,
>   
> Liobhra, Odhbha, Scot, Sceine;
> 2. Tea wife of Eireamhon of the steeds,
>   
> And Fial too, the wife of Lughaidh,
>   
> Fas wife of Un the son of Oige next,
>   
> And Sceine wife of Aimhirgin,
> 3. Liobhra wife of Fuad, noble her renown,
>   
> Scota the marriageable, and Odhbha
>   
> These were the women who were not giddy,
>   
> Who came with the sons of Milidh.
> 



As to the descendants of Milidh, the company of them who landed with Eibhear and fought the Battle of Sliab Mis went to meet Eireamhon to the mouth of Innbhear Colpa; and when they came together there, they gave warning of battle to the sons of Cearmad and to the Tuatha De Danann in general. It was then that the Battle of Taillte took place between them; and the sons of Cearmad were defeated by the sons of Milidh, and there fell Mac Greine by Aimhirgin, Mac Cuill by Eibhear, and Mac Ceacht by Eireamhon, as the seancha says:


> 1. The bright Mac Greine fell
>   
> In Taillte by Aimhirgin,
>   
> Mac Cuill by Eibhear of the gold,
>   
> Mac Ceacht by the hand of Eireamhon.
> 



Their three queens also fell; namely, Eire, Fodla, and Banbha. Hence, and to state by whom they fell, the seancha composed this stanza:


> 1. Fodla slain by Eatan the proud;
>   
> Banbha by Caicher the victorious
>   
> Eire then slain by Suighre:
>   
> These are the fates of this trio.
> 



Now the greater part of the host of the Tuatha De Danann also fell; and while the host of the sons of Milidh were


---

p.97




in pursuit of them towards the north, two leaders of the Milesian host were slain, namely, Cuailgne son of Breoghan on Sliabh Cuailgne, and Fuad son of Breoghan on Sliabh Fuaid.


XXIII.
------


When they had expelled the Tuatha De Danann, and brought Ireland under their own sway, Eibhear and Eireamhon divided the country between them; and, according to some historians, the division made between them was this: Eireamhon to have the northern half from the Boyne and from the Srubh Broin northwards, and Eibhear from the same boundary southwards to Tonn Cliodhna. Thus does the seancha speak of this division— Eireamhon and noble Eibhear, is the beginning of the poem:


> 1. On the northern side, an event without sorrow,
>   
> Eireamhon took sovereignty
>   
> From the Srubh Broin, noble the division,
>   
> Over every tribe to Boyne.
> 2. Eibhear, the prosperous son of Milidh,
>   
> Possessed the excellent southern half
>   
> *He obtained from* the Boyne, strong the division,
>   
> To the wave of Geanann's daughter.
> 




Now, five of the principal leaders of the host of the sons of Milidh went with Eireamhon to his division, and received territory from him; and each of them built a stronghold in his own portion of the territory. The five leaders who went with Eireamhon are Aimhirgin, Goistean, Seadgha, Sobhairce, and Suirghe. Here follow the royal forts that were built by Eireamhon and by his five leaders. In the first place he himself built Raith Beitheach in Airgeadros, on the brink of the Feoir in Osruighe. Then Aimhirgin built Turloch of Innbhear Mor; Sobhairce built Dun Sobhairce; Seadgha


---

p.99




built Dun Deilginse in the territory of Cuala; Gostean built Cathair Nair; Suirghe built Dun Eadair.


The following are the five who went with Eibhear, namely, Caicher, Manntan, En, Oige, and Fulman, and each of them similarly built a fort. First, Eibhear himself built Raith Eoamhain, in Laigheanmhagh; Caicher built Dun Inn, in the west of Ireland; Manntan built the stronghold of Carraig Bladhruidhe; En son of Oige built the fort of Ard Suird, and Fulman the fort of Carraig Feadha.


From Eibhear to Adam there were thirty-five generations, as the poet says:


> 1. With good upbringing, fifteen
>   
> And twenty generations,
>   
> The tribe of brave men lavish of herds
>   
> Up from Eibhear to Adam.
> 




Other seanchas are of opinion that the division of Ireland made by Eibhear and Eireamhon was this: Eibhear to have the two provinces of Munster; Eireamhon the province of Connaught and the province of Leinster; and Eibhear son of Ir, son of Milidh, and others of the leaders who came with the sons of Milidh, to have the province of Uster; and the cantred of Corca Laighdhe, in south Munster, they gave to Lughaidh son of Ioth, the son of their grandfather's brother. This opinion I am the more disposed to accept as true, as it was in Leinster that Eireamhon's chief stronghold was situated, namely, Raith Beitheach in Airgeadros beside the Feoir, and also because the descendants of Eibhear originally settled in Munster, the descendants of Eireamhon in Connaught and Leinster, and the descendants of Rudhruidhe son of Sithrighe, who sprang from Eibhear son of Ir, son of Milidh, in Ulster. It is from this Rudhruidhe that the name Clann Rudhruidhe is given to the real Ultonians, and to every section of their descendants who went into each others provinces to seize upon land and to make conquests, such as the coming of the children of Rudhruidhe to Leinster


---

p.101




to wit, the descendants of Conall Cearnach to Laoighis, and the descendants of Fearghus son of Rogh to Conmhaicne of Connaught, and to Corca Moruadh and Ciarraidhe in Munster and the family of Duibhidhir of the race of Cairbre Cluitheachar son of Cuchorb of the progeny of Labhraidh Loingseach, and the family of Rian of the race of Cathaoir Mor, who came from Leinster to Munster. It was long after this division which Eibhear and Eireamhon made of Ireland that these tribes went from their own territories into other districts in Ireland. It is also well known that it was in the time of Muireadhach Tireach that the three Collas with their kinsmen left Connaught to win conquests from the Ultonians, and wrested by force from them a large portion of the province of Ulster, namely, Modhairn, Ui Mac Uais and Ui Chriomhthainn; and many of their descendants hold possession of these to-day, as Raghnall son of Samhairle, Earl of Antrim, or Aondrom, descended from Colla Uais; Mag Uidhir Mag Mhathghamhna and O Hannluain descended from Colla Da Chrioch.


In the time of Cormac son of Art, also, the Deisigh, a tribe of the race of Eireamhon, came to Munster and acquired territory there. And it was while Fiachaidh Muilleathan son of Eoghan Mor, son of Oilill Olum, was king of Munster, that Cairbre Musc, a nobleman of the race of Eireamhon, brought a poem to Fiachaidh, and obtained all the land that lies between Slighe Dhala, that is, Bealach Mor Osruighe and Cnoc Aine Cliach, as a reward for his poem, as we read in the Book of Ard Macha; and it is from this Cairbre Musc that the name Muscruidhe Tire is given to the two Ormonds. And soon after this, some of the race of Eibhear came to Connaught, namely, the descendants of Cormac Gaileang, that is, the Gaileanga and the Luighni, of whom are O Headhra and O Gadhra in the northern half. And so it was with every family and tribe who migrated to another district in Ireland, it was not because of the division made by


---

p.103




Eibhear and Eireamhon they migrated; and hence I consider the last-mentioned opinion correct; for it is not likely that it was in the portion which fell to Eibhear in which Airgeadros is situated that Eireamhon would build his first royal fort, that is, Raith Beitheach in Airgeadros. Hence I think that it was in his own portion he built it, and that therefore the province of Leinster belonged to Eireamhon's portion, as the last opinion states.


A learned poet and a melodious harper, the name of the poet being Cir son of Cis, and that of the harper Onaoi, were amongst those who came with the sons of Milidh to Ireland. And Eibhear said that he should have them, while Eireamhon maintained that they should be his. Now the arrangement made between them was to share them with one another by casting lots for them, and the musician fell by lot to Eibhear and the poet to Eireamhon. And as a setting forth of this contest are the following stanzas from the Psalter of Cashel:


> 1. They cast lots fairly
>   
> For the noble poetic pair,
>   
> So that to the man from the south fell
>   
> The correct dextrous harper;
> 2. To the man from the north fell, too,
>   
> The poet of great powers;
>   
> And hence came sway
>   
> Over honour and learning,
> 3. String-harmony of music, beauty, quickness,
>   
> In the south and lower part of Ireland:
>   
> Thus shall it be for evermore,
>   
> As is recorded in the seanchus.
> 




There came to Ireland with the sons of Milidh twenty-four slaves who cleared twenty-four plains from wood after they had come into the country; and it is from themselves these plains are named. Here are the names of these men: Aidhne, Ai, Asal, Meidhe, Morbha, Midhe, Cuibh, Cliu, Ceara, Reir, Slan, Leighe, Lithfe, Line, Lighean, Trea, 


---

p.105




Dula, Adhar, Airiu, Deise, Deala, Fea, Feimhean, and Seara; and these names are precisely the names of these plains in Ireland at this day.


Moreover, Tea daughter of Lughaidh son of Ioth, the wife of Eireamhon, got a fortress built for herself in Liathdhruim which is now called Teamhair; and it is from Tea daughter of Lughaidh that this hill is called Teamhair, that is, the mur or house of Tea.


The sons of Milidh ruled Ireland jointly for a year, when a dispute arose between them about the possession of the three best hills in Ireland, namely, Druim Clasaigh in the territory of Maine, Druim Beitheach in Maonmhaigh, and Druim Finghin in Connaught. On that occasion a battle was fought between Eibhear and Eireamhon in Ui Failghe at Bru Bhriodain, at a pass between two plains in the district of Geisill. Eibhear was defeated in that battle; and he himself was slain, together with three leaders of his followers, namely, Suirghe, Sobhairce, and Goistean. The poet treats of this event, setting forth the cause of the dispute, as follows:


> 1. Banbha without grief shared
>   
> Eibhear and Eireamhon,
>   
> Till pride seized their wives,
>   
> A year without foray, without war.
> 2. The wife of Eibhear of the battles said
>   
> That unless she owned the fair Druim Clasach,
>   
> Druim Beithech, Druim Finghin bright
>   
> She would not remain a night in Erin.
> 3. Eibhear fell, great the man,
>   
> By Eireamhon son of Milidh;
>   
> He got his death-wound in the land of Geisill
>   
> In the morning on Magh Smearthoin.
> 



The poet Tanuidhe, agreeing with the same statement, speaks thus:


> 1. Ye bards of renowned Banbha,
>   
> Know ye, or can ye tell,
>   
> Why the great battle was fought
>   
> Against Eibhear by Eireamhon?
> 
> 
> ---
> 
> p.107
> 
> 4. I myself will tell you that—
>   
> The reason why he committed the fratricide,
>   
> Because of three low-lying hills,
>   
> The best that were in Erin:
> 5. Druim Finghin, fair Druim Clasaigh,
>   
> Druim Beitheach in Connaught;
>   
> In struggling for these, not bright the tale,
>   
> This slaughter was wrought, O bards.
> 




XXIV.
-----


#### Of the kings of the children of Milidh before the Faith and of the length of their sovereignty in Ireland as follows.


Eireamhon, after being a year in the joint sovereignty of Ireland with Eibhear, held the full sovereignty for fourteen years after Eibhear was slain in the Battle of Airgeadros, according to some seanchas, as this stanza says:


> 1. Fourteen years, I know it,
>   
> Did Eireamhon hold chief sovereignty
>   
> After the Battle of Airgeadros with valour,
>   
> Where Eibhear fell outright.
> 



However, the common opinion of seanchas is, that it was not in the Battle of Airgeadros that Eibhear was slain, but in the Battle of Geisill, as we have stated above. It was in the time of Eireamhon that the following events took place. The Battle of Cuil Caicheir, a year after the death of Eibhear, it was there that Caicher, leader of the followers of Eibhear, fell by Aimhirgin son of Milidh; a year after that Aimhirgin was slain by Eireamhon in the Battle of Bile Theineadh in Cuil Breagh; and in that year also the nine Brosnas of Eile and the three Uinnses of Ui nOiliolla burst over land in Ireland. The third year after that Fulman and Manntan, two leaders of the followers of Eibhear, feIl by Eireamhon in the Battle of Breoghan in Freamhainn. Eight lakes burst over land in Ireland in the reign of Eireamhon,


---

p.109




namely, Loch Cime, Magh Sreing being the name of the plain over which the lake burst, Loch Buadhaigh, Loch Bagha, Loch Rein, Loch Fionnmhaighe, Loch Greine, Loch Riach, Magh Maoin being the name of the plain over which it burst; Lough Da Chaoch in Leinster, and Loch Laogh in Ulster. The fourth year after this, Un, En, and Eatan were slain by Eireamhon in the Battle of Comhruire in Meath, and their graves were made there. In the same year the three Sucas burst over land in Connaught.


Some seanchas assert that it was Eireamhon who portioned the five provinces of Ireland among some of the leaders who were with him after the death of Eibhear. First he gave the province of Leinster to Criomhthann Sciathbheal of the Domhnanncha, a noble of the relicts of the Fir Bolg. He gave, moreover, the two provinces of Munster to the four sons of Eibhear, to wit, Er, Orba, Fearon, and Feargna. He gave besides the province of Connaught to Un son of Oige and to Eatan, two leaders who had come with him from Spain. Similarly he left the province of Ulster to Eibhear son of Ir, his own brother's son.


It was in the reign of Eireamhon also that the Cruithnigh, or Picts, a tribe who came from Thrace, arrived in Ireland; and according to Cormac son of Cuileannan, in his Psaltair, the reason of their leaving Thrace was that Policornus, king of Thrace, designed to force a beautiful marriageable daughter of Gud, chief of the Cruithnigh, while these latter were at free quarters in the country. When, however, Gud and his Cruithnigh suspected that the king was about to force the maiden, they slew him, and accordingly quitted the country, and went from country to country till they reached France, where they were quartered and got lands from the king of the French, and there they built a city called Pictavium, from the Picts or Cruithnigh who built it. And when the king of the French heard of the fame of the maiden's


---

p.111




beauty, he sought to have her as a concubine. When Gud heard this, he fled with all his people to Ireland with the maiden; and while they were on the sea the maiden died in their midst; and they themselves afterwards put into port at Innbhear Slainghe. Beda agrees with this, except that he says that it was in the north of Ireland they landed, in the first chapter of the first book of the History of the Saxon Church, where he says: *The Pictish race came from Scythia, as is stated, in a small fleet of long vessels over the ocean and being driven by the force or blowing of the winds outside all the boundaries of Britain, came to Ireland; and on finding the Scotic race before them, they asked for a place of abode there for themselves, but obtained it not. {Contigit gentem Pictorum de Scythia (ut perhibent) longis navibus non multis oceanum ingressam, circumagente flatu ventorum, extra fines omnes Britanniae Hiberniam pervenisse, eiusque septemtrionales oras intrasse, atque inventa ibi gente Scotorum sibi quoque in partibus illius sedes petiisse nec impetrare potuisse.}’’*

 However, it was not in the north of Ireland they landed, but at the mouth of Innbhear Slainghe in the harbour of Loch Garman, as we have said. And Criomhthann Sciathbheal, who held the sovereignty of Leinster from Eireamhon at that time, came to meet them there, and entered into friendship with them.
The leaders of that fleet were Gud and his son Cathluan; and the reason why Criomhthann entered into friendship with them was because some British nobles, who were called Tuatha Fiodhgha, were making conquests in the Fotharta on either side of the mouth of the Slaney. Such were these people that the weapons of every one of them were poisoned, so that, be the wound inflicted by them small or great, no remedy whatever availed the wounded man, but he must die. Criomhthann heard that there was a skilful druid called Trostan amongst the Cruithnigh who could furnish himself and his people with an antidote against the poison with which the weapons of the Tuatha Fiodhgha were wont to be charged; and he asked Triostan what remedy he should use against the poison of the weapons of those people we have mentioned. ‘Get thrice fifty white hornless cows milked,’ said Trostan, ‘and let the milk got from them be placed in a


---

p.113




hollow in the middle of the plain in which you are wont to meet them in battle, and offer them battle on that same plain; and let each one of your followers who shall have been wounded by them go to the hollow and bathe, and he will be healed from the venom of the poison.’ Criomhthann did as the druid had advised, and fought the Battle of Ard Leamhnachta against the Tuatha Fiodhgha. He defeated and executed great slaughter on them in that place. From this event, and from the battle which took place, the battle has been called the Battle of Ard Leamhnachta ever since. And in proof of this account the poet has composed the following historic poem:


> 1. Ard Leamhnachta in the southern country
>   
> Each noble and bard may inquire
>   
> Whence is derived the name of the land
>   
> Which it has borne from the time of Criomhthann;
> 2. Criomhthann Sciaithbheal it was who fought,
>   
> To prevent the slaughter of his warriors,
>   
> Protecting them from the sharp poison of the weapons
>   
> Of the hateful, horrid giants.
> 3. Six of the Cruithnigh, God so ordained,
>   
> Came from the land of Thrace,
>   
> Soilen, Ulpia, Neachtain the noble,
>   
> Aonghus, Leathan, and Trostan.
> 4. God granted them, through might
>   
> To heal them from the sharp poison of the wounds,
>   
> And to protect them from the bitter venom of the weapons
>   
> Of the powerful, very fierce giants.
> 5. The true knowledge obtained for them
>   
> By the druid of the Cruithnigh, at once, was
>   
> That thrice fifty hornless cows of the plain
>   
> Be milked in one deep hollow.
> 6. The battle was pressingly fought
>   
> Around the hollow where the new milk was,
>   
> And the battle went strongly against
>   
> The giants of high Banbha.
> 




Now as to the Cruithnigh, that is, Gud and his son Cathluan, they resolved to invade Leinster; and when


---

p.115




Eireamhon heard this, he assembled a numerous army, and went to meet them. When the Cruithnigh saw that they were not strong enough to fight Eireamhon, they entered into peace and friendship with him. Eireamhon told them that there was a country to the north-east of Ireland, and bade them go and occupy it. Then, according to Beda, in the first chapter of the first book of the History of Sacsa, the Cruithnigh asked Eireamhon to give them some of the noble marriageable ladies he had with him, some of the wives of the leaders who had come with him from Spain, and whose husbands were slain; and they bound themselves by the sun and moon that the possession of the kingdom of Cruitheantuath, which is now called Alba, should be held by right of the female rather than by that of the male progeny to the end of the world. Upon these conditions Eireamhon gave them three women, namely, the wife of Breas, the wife of Buas, and the wife of Buaidhne; and Cathluan, who was their supreme leader, took one of these women to wife; and after that they proceeded to Cruitheantuath; and Cathluan conquered that country, and was the first king of Alba of the race of the Cruithnigh. There were seventy kings of the Cruithnigh or Picts on the throne of Alba after him, as we read in the Psalter of Cashel in the poem beginning: All ye learned of Alba. Thus it speaks on this matter: 


> 1. The Cruithnigh seized it after that,
>   
> When they had come from the land of Erin;
>   
> Ten and sixty very noble kings
>   
> Of those ruled the land of the Cruithnigh.
> 2. Cathluan, the first of these kings,
>   
> I will tell you briefly;
>   
> The last king of them was
>   
> The stout champion Constantin.
> 




But Trostan the Druid and the five other Cruithnigh mentioned in the above poem, remained in Ireland after


---

p.117




Cathluan, and got lands from Eireamhon in the Plain of Breagh in Meath. The fourteenth year after the death of Eibhear, Eireamhon died in Airgeadros at Raith Beitheach, beside the Feoir, and there he was buried. The same year the river called the Eithne burst over land in Ui Neill; and the river called Freaghobhal burst over land between Dal nAruidhe and Dal Riada.


XXV.
----


The three sons of Eireamhon held the sovereignty of Ireland after him three years. These were Muimhne, Luighne, and Laighne. They held the sovereignty jointly for three years till the death of Muimhne in Magh Cruachan, and till Luighne and Laighne were slain by the sons of Eibhear in the Battle of Ard Ladhrann.


The four sons of Eibhear, Er, Orba, Fearon, and Feargna, held the sovereignty of Ireland a part of a year, when they were slain by Irial Faidh son of Eireamhon, to avenge his two brothers Luighne and Laighne.


Irial Faidh son of Eireamhon held the sovereignty of Ireland ten years, for his three elder brothers had no issue. Besides, when Irial had assumed the sovereignty and attained to greatness and power, he slew Eibhear's four sons—namely, Er, Orba, Fearon, Feargna—to avenge his two brothers who had been killed by them.


Sixteen plains were freed from wood in Ireland in the reign of Irial. The following are their names:—Magh Reichead in Laoighis; Magh Neiliu in Leinster; Magh Comair, Magh Seiliu in Uibh Néill; Magh Sanais i Connaught; Magh nlnis, in Ulster; Magh Midhe; Magh Luinge in Ciannachta; Magh Teacht in Ui Mac Uais; Magh Fearnmhuighe in Oirghialla; Magh Foithin in the west; Magh Cobha in Ui Eachach; Magh Cuma in Ui Neill;


---

p.119




Magh Cuile Feadha, Magh Riada, Magh nAirbhrioch, in Fotharta Airhbrioch, in Leinster.


Irial Faidh son of Eireamhon built seven royal forts in Ireland in his time, namely, Raith Ciombaoith in Eamhain; Raith Croichne in Magh Inis; Raith Bachaill in Lothama; Raith Coincheadha in Seimhne; Raith Mothaigh in Deagh-charbad; Raith Buireach in Sleachta; Raith Lochaid in Glascharn.


The year after that the three rivers called the three Fionns burst over land in Ulster. The following year Irial won four battles. The first battle was the Battle of Ard Ionmhaith in Teathbha, where Stime son of Dubh, son of Fomhor fell; the second battle was the Battle of Teannmhagh, which Irial fought against the Fomoraigh, where the Fomorian king, who was called Echtghe Ethcheann, fell; the third battle was the Battle of Lochmhagh, where Lughroth son of Mogh Feibhis fell; the fourth battle was the Battle of Cuil Marta, where he defeated the four sons of Eibhear. Hence, and to narrate these events, is the poem which begins with this stanza:


> 1. - Irial, the youngest of the children,
>   
> Son of the king of Fodhla of curled hair,
>   
> King of Sliabh Mis, king of Macha,
>   
> Won four hard battles.
> 



The second next year after this Irial Faidh son of Eireamhon died at Magh Muaidhe, and was buried there.


Eithrial son of Irial Faidh, son of Eireamhon, held the sovereignty of Ireland for twenty years. In the time of this Eithrial seven plains were cleared of wood in Ireland, namely, Teannmhagh in Connaught; Magh Lioghat and Magh mBealaigh in Ui Tuirtre; Magh Geisill in Ui Failghe; Magh Ochtair in Leinster; Lochmhagh in Connaught; Magh Rath in Ui Eachach; and after he had been twenty years on the throne of Ireland he was slain by Conmhaol son of Eibhear in the Battle of Raoire in Leinster.




---

p.121


Conmhaol son of Eibhear held the sovereignty of Ireland thirty years; and he was the first king of Ireland of the race of Eibhear. Now this Conmhaol defeated the descendants of Eireamhon in twenty-five battles. The following are nine of these battles: to wit, the Battle of Ucha; the Battle of Cnucha; the Battle of Eile; the Battle of Sliabh Beatha; and the Battle of Geisill, where Palap son of Eireamhon fell; the Battle of Sliabh Modhairn, where Samhra son of Ionbhoth fell; the Battle of Loch Lein, where Mughroth fell; the Battle of Beirre; and the Battle of Aonach Macha, where Conmhaol himself fell by Eibhear son of Tighearnmhas of the race of Eireamhon; and he was buried on the south side of Aonach Macha in the place which is called Conmhaol's Mound at this day.


Tighearnmhas son of Follach, son of Eithrial, son of Irial Faidh, son of Eireamhon, held the sovereignty of Ireland fifty years, or according to others sixty years; and this monarch won twenty-seven battles over the descendants of Eibhear, namely, the Battle of Eille, in which Rochorb son of Gollan fell, and the Battle of Cumar, the Battle of Magh Teacht, the Battle of Lochmhagh, in which fell Deighiarna son of Goll son of Gollan, the Battle of Cuil Ard in Magh Inis, the Battle of Cuil Fraochain, the Battle of Athghart in Seimhne, the Battle of Ard Niadh in Connaught, and the Battle of Carn Fearadhaigh, in which Fearadhach son of Rochorb, son of Gollan, fell, the Battle of Cluain Cuasa in Teathbha, the Battle of Comhnuidhe in Tuath Eibhe, the Battle of Cluain Muirisc in the north of Breithfne, the Battle of Cuil Fabhair on Earbhus, and seven battles in Lughlachta on Loch Lughdhach in one day, and the two battles of Cuil in Airgeadros, and the Battle of Reibh, where the greater part of the descendants of *Eibhear* were slain by Tighearnmhas.


The year after that nine lakes burst over land in Ireland, namely, Loch Cé, and it was over Magh Sulchair it burst; Loch Aillinne in Connaught; Loch n-Iairn, Loch n-Uair,


---

p.123




Loch Saighlionn, Loch Gabhair in Meath and in Breagh; Loch Feabhail in Tir Eoghain, over Feabhal of the son of Lodan it burst, and Magh Fuinnsighe is the name of the plain over which the lake came; Dubhloch of Ard Ciannachta and Loch Da Bhaill in Oirghialla, and the three black rivers of Ireland, namely, Fobhna, Toronn, and Callonn.


It is the same Tighearnmhas who first found a mine of gold in Ireland; and Uchadan was the name of the artificer who used to refine the gold for him; and it was in Fotharta east of Lithfe he used to smelt it. It was in the time of Tighearnmhas that clothes were first dyed purple, blue, and green in Ireland. It was also in his time that embroidery, fringes, and filigree were first put on mantles in Ireland. It was he in the same way that introduced into Ireland the custom of having but one colour in the dress of a slave, two colours in the dress of a peasant, three in the dress of a soldier or young lord, four in the dress of a **brughaidh**, five in the dress of a district chief, six in the dress of an **ollamh** and in the dress of a king or queen. And it was at Magh Sleacht that Tighearnmhas himself died and three quarters of the men of Ireland with him on the eve of Samhain while they were in the act of worshipping Crom Cruaidh, the chief idol of Ireland. For it was this Tighearnmhas who first instituted the worship of Crom Cruaidh (as Zoroastres did in Greece) about a hundred years after they had come to Ireland; and it was from the prostrations of the men of Ireland before this idol that that plain in Breithfne is called Magh Sleacht. Some seanchas state that Ireland was seven years without a king after the death of Tighearnmhas at the convention of Magh Sleacht, and that it was Eochaidh Faobharghlas son of Conmhaol who held the sovereignty of Ireland after him. But they are in error in this; for the Reim Rioghruidhe states that it was Eochaidh Eadghothach of the race of Lughaidh son of Ioth who held it.




---

p.125


Eochaidh Eadghothach son of Daire, son of Conghal, son of Eadhaman, son of Mal, son of Luighaidh, son of Ioth, son of Breoghan, son of Bratha, held the sovereignty of Ireland four years, and he fell by Cearmna son of Eibric.


Cearmna and Sobhairce, two sons of Eibric son of Eibhear, son of Ir, son of *Milidh* of Spain, held the sovereignty of Ireland forty years, and were the first Ultonian kings of Ireland; and they divided the sovereignty of Ireland between them; and the boundary of this division extended from Innbhear Colpa at Droichead Atha to Luimneach of Munster. Sobhairce obtained the northern part, and built a dun on his own division, namely, Dun Sobhairce. Cearmna obtained the southern division, and built a dun beside the southern sea, namely, Dun Cearmna; and it is now called Dun Mic Padraig in the Courcys' country. Sobhairce fell by Eochaidh Meann, son of a Fomorian king. Cearmna fell by Eochaidh Faobharghlas son of Conmhaol in the Battle of Dun Cearmna.


Eochaidh Faobharghlas son of Conmhaol, son of Eibhear Fionn, son of Milidh of Spain, held the sovereignty of Ireland twenty years. He was called Eochaidh Faobharghlas, for his two spears were bluish-green and sharp-edged; and it was he who defeated the race of Eireamhon in the following battles, namely, the Battle of Luachair Deaghaidh in Desmond; the Battle of Fosadh Da Ghort; the Battle of Cumar na dTri nUisce; the Battle of Tuaim Dreagan in Breithfne; and the Battle of Drom Liathain. He cleared seven plains from wood in Ireland, namely, Magh Smeathrach, in Ui Failghe; Magh Laighne and Magh Luirg in Connaught; Magh Leamhna, Magh n-Ionair, Magh Fubhna, and Magh Da Ghabhal, in Oirghialla. And this Eochaidh fell by Fiachaidh Labhruinne son of Smiorghull, son of Eanbhoth, son of Tighearnmhas, in the Battle of Carman.


Fiachaidh Labhruinne son of Smiorghull, son of Eanbhoth, son of Tighearnmhas, son of Follach, son of Eithrial, son of


---

p.127




Irial Faidh, son of Eireamhon, held the sovereignty of Ireland twenty-four years, or, according to others, thirty-seven years; and he was called Fiachaidh Labhruinne, for in his time Innbhear Labhruinne burst over land in Ireland; and it was in his time the three following rivers burst forth namely, Innbhear Fleisce, Innbhear Mainge, and Innbhear Labhruinne, from which he is named Fiachaidh Labhruinne. It was in his time also that Loch Eirne burst over land, and Magh Geanainn is the name of the plain over which it came.


It was the son of this Fiachaidh, namely, Aonghus Ollbhuadhach, who defeated the Cruithnigh and the old Britons who were in Alba in several battles, and who first placed Alba under the full sway of the Gaels, though from the time of Eireamhon son of Milidh the Gaels claimed a tribute from them (the Albanians). About two hundred and fifty years after the sons of Milidh came to Ireland, Alba was brought under sway and tribute by Aonghus Ollbhuadhach son of Fiachaidh Labhruinne; and this Fiachaidh Labhruinne fought four battles against the race of Eibhear, namely, the Battle of Fairrge, the Battle of Gallach, the Battle of Sliabh Feimhion, and the Battle of Sliabh Bealgadain, in which he himself fell by Eochaidh Mumho son of Mo Febhis.


Eochaid Mumho son of Mo Febhis, son of Eochaid Faobharglas, son of Conmhaol, son of Eibhear Fionn, son of Milidh of Spain, held the sovereignty of Ireland twentyone years; and he fell by Aonghus Olmucaidh in the Battle of Cliu.




---

p.129


XXVI.
-----


Aonghus Olmucaidh son of Fiachaidh Labhruinne, son of Smiorgull, son of Eanbhoth, son of Tighearnmhas, son of Follach, son of Eithrial, son of Irial Faidh, son of Eireamhon, held the sovereignty of Ireland eighteen years, and according to others twenty-one years. He was called Olmucaidh from the word oll, that is great, and muca, hogs, since he had the largest hogs that were in Ireland in his time; and it was he who fought the following battles: The Battle of Cleire; the Battle of Sliabh Cailge, where Baiscionn fell; and the Battle of Magh Einsciath in Connaught; and the Battle of Glaise Fraochain, where Fraochan Faidh fell; and fifty battles against the Cruithnigh and the Fir Bolg, and the inhabitants of the Orcades. Three lakes burst forth in his time—Loch Einbheithe in Oirghialla, Loch Sailgheadain, and Loch Gasain in Magh Luirg. It was in his time that the following plains were cleared of woods, namely: Magh Glinne Dearcon in Cineal Conaill; Magh n-Einsciath in Leinster; Magh Cuile Caol in Boghaine; Aolmhagh in Callruidhe; Magh Mucruimhe in Connaught; Magh Luachra Deaghaidh, and Magh Archaill in Ciarraidhe Luachra. And it was in the Battle of Sliabh Cua that Aonghus Olmucaidh was slain by Eanna son of Neachtain, a Munsterman; and others say that it was Eanna Airgthioch who slew him in the Battle of Carman; and this latter opinion is the more probable, according to the poem which begins, Aonghus Olmucaidh died. And moreover the Reim Rioghruidhe agrees with the same opinion.


Eanna Airgthioch son of Eochaidh Mumho, son of Mo Feibhis, son of Eochaidh Faobharghlas, son of Conmhaol, son of Eibhear Fionn, son of Milidh of Spain, held the sovereignty of Ireland twenty-seven years; and it was he who, at Airgeadros, first made silver shields in Ireland; and he bestowed them on the men of Ireland; and he fell in the Battle


---

p.131




of Raighne by Roitheachtaigh son of Maon, son of Aonghus Olmucaidh.


Roitheachtaigh son of Maon, son of Aonghus Olmucaidh, son of Fiachaidh Labhruinne, son of Smiorgholl, son of Eanbhoth, son of Tighearnmhas, son of Follach, son of Eithrial, son of Irial Faidh, son of Eireamhon, held the sovereignty of Ireland twenty-five years; and this Roitheachtaigh fell by Seadna son of Art, son of Airtre, at Raith Cruachan.


Seadna son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Ir, held the sovereignty of Ireland five years; and he was slain by his own son on the coming of ‘a black fleet’ to Cruachain.


Fiachaidh Fionscothach son of Seadna, son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Ir, son of Milidh of Spain, held the sovereignty of Ireland twenty years; and he was called Fiachaidh Fionscothach, for in his time there were wine flowers that used to be pressed into goblets; and this Fiachaidh was slain by Muineamhon son of Cas Clothach.


Muineamhon son of Cas Clothach, son of Fear Arda, son of Roitheachtaigh, son of Rossa, son of Glas, son of Nuadha, son of Eochaidh Faobharghlas, son of Conmhaol, son of Eibhear Fionn, held the sovereignty of Ireland five years; and this Muineamhon was the first to decree that collars or chains of gold should be worn round the neck by the nobles in Ireland; and he died of the plague at Magh Aidhne.


Ailldeargoid son of Muineamhon, son of Cas Clothach, son of Fear Arda, son of Roitheachtaigh, son of Rossa, son of Glas, son of Nuadha Deaghlaimh, son of Eochaidh Faobharghlas, son of Conmhaol, son of Eibhear Fionn, son of Milidh, held the sovereignty of Ireland seven years; and it was in his time that gold rings were first put on the fingers of the nobles in Ireland; and he was slain by Ollamh Fodla in the Battle of Tara.


Ollamh Fodla son of Fiachaidh Fionscothach, son of


---

p.133




Seadna, son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Ir, son of Milidh of Spain, held the sovereignty of Ireland thirty years, and died in his house. He was called Ollamh Fodla, as he was an **ollamh** in wisdom and in knowledge for the establishing of laws and regulations in Ireland in his time; and it was he first established the **Feis of Tara**, as the poet says:


> 1. Ollamh Fodla of furious valour
>   
> Built the hall of **ollamhs**;
>   
> The first noble king, happy his reign,
>   
> Who assembled the **Feis of Tara**.
> 




Now the **Feis of Tara** was a great general assembly like a parliament, in which the nobles and the **ollamhs** of Ireland used to meet at Tara every third year at Samhain, where they were wont to lay down and to renew rules and laws, and to approve the annals and records of Ireland. There, too, it was arranged that each of the nobles of Ireland should have a seat according to his rank and title. There, also, a seat was arranged for every leader that commanded the soldiery who were in the service of the kings and the lords of Ireland. It was also the custom at the **Feis of Tara** to put to death anyone who committed violence or robbery, who struck another or who assaulted another with arms, while neither the king himself nor anyone else had power to pardon him such a deed. It was also their custom to pass six days in feasting together before the sitting of the assembly, namely, three days before Samhain and three days after it, making peace and entering into friendly alliances with each other. In the following historical poem **Eochaidh Eolach** describes the customs that were in vogue at the **Feis of Tara**:


> 1. The **Feis of Tara** every third year,
>   
> For the fulfilment of laws and rules,
>   
> Was convened at that time mightily
>   
> By the noble kings of Erin.
> 
> 
> ---
> 
> p.135
> 
> 4. Cathaoir of many alliances assembled
>   
> The beauteous Feis of Royal Tara;
>   
> There came to *him*, it was a pleasure,
>   
> The men of Ireland to one place.
> 5. Three days before Samhain, according to custom,
>   
> Three days thereafter, good the practice,
>   
> Did that high-spirited company
>   
> Pass in constant feasting, a week.
> 6. Robbery, personal wounding,
>   
> Were forbidden them all that time;
>   
> Assault at arms, cutting,
>   
> Proceedings by litigation:
> 7. Whoever did any of these thing
>   
> Was a wicked culprit of much venom
>   
> Redeeming gold would not be accepted from him,
>   
> But his life was at once forfeit.
> 




Fionnachta son of Ollamh Fodla, son of Fiachaidh Fionscothach, son of Seadna, son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Ir, son of Milidh, held the sovereignty of Ireland twenty years; and he was called Fionnachta, that is, Finshneachta, because it rained showers of wine-snow in his reign; and he died in Magh Inis.


Slanoll son of Ollamh Fodla, son of Fiachaidh Fionscothach, son of Seadna, son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Ir, son of Milidh, held the sovereignty of Ireland fifteen years; and he was called Slanoll, for oll means great, and everyone in Ireland had great health during his reign, for none of the men of Ireland suffered from plague or disease in his reign. And it was in the banqueting-hall at Tara that he died; and others say that the disease that seized him is unknown.


Geidhe Ollghothach son of Ollamh Fodla, son of Fiachaidh Fionscothach, son of Seadna, son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Ir, son of Milidh, held the sovereignty of Ireland seventeen years; and he is called 


---

p.137




Ollghothach, for great was the voice of everyone in Ireland in his reign. And he was slain by Fiachaidh son of Fionnachta.


Fiachaidh son of Fionnachta, son of Ollamh Fodla, son of Fiachaidh Fionscothach, son of Seadna, son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Ir, son of Milidh, held the sovereignty of Ireland thirty years; and he fell by Bearnghal son of Geidhe Ollghothach.


Bearnghal son of Geidhe Ollghothach, son of Ollamh Fodla, son of Fiachaidh Fionscothach, son of Seadna, son of Art, son of Airtre, son of Eibric, son of Ir, son of Milidh, held the sovereignty of Ireland twelve years; and he fell by Oilill son of Slanoll.


Oilill son of Slanoll, son of Ollamh Fodla, son of Fiachaidh Fionscothach, son of Seadna, son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Milidh, held the sovereignty of Ireland sixteen years, and he fell by Sioma son of Dian.


Sioma Saoghlach son of Dian, son of Roitheachtaigh, son of Maon, son of Aonghus Olmucaidh, son of Fiachaidh Labhruinne, son of Smiorghull, son of Eanbhoth, son of Tighearnmhas, son of Follach, son of Eithrial, son of Irial Faidh, son of Eireamhon, held the sovereignty of Ireland twenty-one years; and he was called Sioma Saoghlach, from the length of life granted to him above his contemporaries; and he fell by Roitheachtaigh son of Roan, in Aillinn, as says the poem beginning, Noble Eire, island of kings:


> 1. Sioma passed in govemment
>   
> The length of thrice seven noble years;
>   
> The cutting off of Sioma with slaughter
>   
> Was in Aillinn by Roitheachtaigh.
> 




Roitheachtaigh son of Roan, son of Failbhe, son of Cas Ceadchaingneach, son of Ailldeargoid, son of Muineamhon, son of Cas Clothach, son of Fear Arda, son of Roitheachtaigh, son of Rossa, son of Glas, son of Nuadha Deaghlaimh, son of


---

p.139




Eochaidh Faobharghlas, son of Conmhaol, son of Eibhear Fionn, son of Milidh of Spain, held the sovereignty of Ireland seven years; and he was burned by a flash of lightning in Dun Sobhairce.


Eilim son of Roitheachtaigh, son of Roan, son of Failbhe, son of Cas Ceadchaingneach, son of Ailldeargoid, son of Muineamhon, son of Cas Clothach, son of Fear Arda, son of Roitheachtaigh, son of Rossa, son of Glas, son of Nuadha Deaghlaimh, son of Eochaidh Faobharghlas, son of Conmhaol, son of Eibhear Fionn, son of Milidh, held the sovereignty of Ireland one year, till he fell by Giallchaidh son of Oilill Olchaoin.


Giallchaidh son of Oilill Olchaoin, son of Sioma Saoghlach, son of Dian, son of Roitheachtaigh, son of Maon, son of Aonghus Olmucaidb, son of Fiachaidh Labhruinne, son of Smiorghull, son of Eanbhoth, son of Tighearnmhas, son of Follach, son of Eithrial, son of Irial Faidh, son of Eireamhon, held the sovereignty of Ireland nine years; and he fell in Magh Muaidhe by Art Imleach.


Art Imleach son of Eilim, son of Roitheachtaigh, son of Roan, son of Failbhe, son of Cas Ceadchaingneach, son of Ailldeargoid, son of Muinemhon, son of Cas Clothach, son of Fear Arda, son of Roitheachtaigh, son of Rossa, son of Glas, son of Nuadha Deaghlaimh, son of Eochaidh Faobharghlas, son of Conmhaol, son of Eibhear Fionn, son of Milidh, held the sovereignty of Ireland twenty-two years; and he fell by Nuadha Fionn Fail.


Nuadha Fionn Fail son of Giallchaidh, son of Oilill Olchaoin, son of Sioma Saoghlach of the race of Eireamhon, held the sovereignty of Ireland twenty years, or according to others sixty years, till he fell by Breisrigh son of Art Imleach.


Breisrigh son of Art Imleach, son of Eilim, son of Roitheachtaigh, son of Roan, son of Failbhe, son of Cas Ceadchaingneach, son of Ailldeargoid, son of Muineamhon


---

p.141




of the race of Eibhear, held the sovereignty of Ireland nine years; and in that time he defeated the Fomorians in several battles; and he himself fell at last by Eochaidh Apthach at Carn Connluain.


Eochaidh Apthach son of Fionn, son of Oilill, son of Flann Ruadh, son of Rothlan, son of Mairtine, son of Sithcheann, son of Riaghlan, son of Eoinbhric, son of Lughaidh, son of Ioth, son of Breoghan, held the sovereignty of Ireland one year; and he was called Eochaidh Apthach because of the number who died in Ireland in his time; for the plague or other disease seized upon the men of Ireland each month, from which many of them died; hence the name Eochaidh Apthach clung to him; for apthach means 'fatal'; and he himself fell by Fionn son of Bratha.


Fionn son of Bratha, son of Labhraidh, son of Cairbre, son of Ollamh Fodla, son of Fiachaidh Fionscothach, son of Seadna, son of Art, son of Airtre, son of Eibric, son of Eibhear, son of Ir, son of Milidh, held the sovereignty of Ireland twenty years, or according to others thirty years; and he fell by Seadna Ionnarraidh.


Seadna Ionnarraidh son of Breisrigh, son of Art Imleach of the race of Eibhear, held the sovereignty of Ireland twenty years; and he is called Seadna Ionnarraidh, that is, Seadna of the Wages, for he is the first king who gave pay to fighting men in Ireland; for ionnarraidh means wages. And his limbs were torn asunder by Simeon Breac, and so he died.


Simeon Breac son of Aodhan Glas, son of Nuadha Fionn Fail, son of Giallchaidh, son of Oilill Olchaoin, son of Sioma Saoghlach of the race of Eireamhon, held the sovereignty of Ireland six years, till he fell by Duach Fionn to avenge his father, and the tearing asunder of him which he had done.


Duach Fionn son of Seadna Ionnarraidh, son of Breisrigh, son of Art Imlioch of the race of Eibhear, held the sovereignty of Ireland five years; and he fell by Muiredhach Bolgrach. Muiredhach Bolgrach son of Simeon Breac, son of


---

p.143




Aodhan Glas, son of Nuadha Fionn Fail, son of Giallchadh, son of Oilill Olchaoin, son of Siorna Saoghalach, of the race of Eireamhon, held the sovereignty of Ireland four years; and he fell by Eanna Dearg son of Duach Fionn.


Eanna Dearg son of Duach Fionn, son of Seadna Ionnarraidh, son of Breisrigh, son of Art Imleach of the race of Eibhear, held the sovereignty of Ireland twelve years; he was called Eanna Dearg, for his oineach, that is his countenance, was red. It was in his time that, at Airgeadros, money was first coined in Ireland. And he died of the plague on Sliab Mis, and a large multitude with him.


XXVII.
------


Lughaidh Iardhonn son of Eanna Dearg, son of Duach Fionn, son of
Seadna Ionnarraidh, son of Breisrigh, son of Art Imleach of the race
of Eibhear, held the sovereignty of Ireland nine years. He was called
Lughaidh Iardhonn, for iardhonn means 'dark-brown'; hence through his dark-brown locks he got the name Lughaidh Iardhonn; and he was slain by Siorlamh at Raith Clochair.


Siorlamh son of Fionn, son of Bratha, son of Labhraidh, son of Cairbre, son of Ollamh Fodla of the race of Ir, son of Milidh, held the sovereignty of Ireland sixteen years. He is called Siorlamh, for síor means 'long'; and he had long hands, for when in a standing posture his hands reached the ground; and he was slain by Eochaidh Uaircheas.


Eochaidh Uaircheas son of Lughaidh Iardhonn, son of Eanna Dearg, son of Duach Fionn, son of Seadna Ionnarraidh, son of Breisrigh, son of Art Imleach of the race of Eibhear, held the sovereignty of Ireland twelve years. He was called Eochaidh Uaircheas, for he used to have bare canoes for a fleet, and ceasa means 'canoes' or 'coctaoi'; and as he was two years on sea in exile from Ireland, he used to put


---

p.145




a party of his followers in these canoes to plunder the borders of every country he passed by, and to bring the booty in these canoes to the fleet; and it was from these canoes that the name Eochaidh Uaircheas clung to him; and he fell by Eochaidh Fiadhmhuine and by Conuing Beigeaglach.



Eochaidh Fiadhmhuine and Conuing Beigeaglach, two sons of Duach Teamhrach son of Muireadhach Bolgrach, son of Simeon Breac, son of Aodhan Glas, son of Nuadha Fionn Fail, son of Giallchaidh, son of Oilill Olchaoin, son of Siorna Saoghlach of the race of Eireamhon, held conjointly the sovereignty of Ireland five years. Eochaidh Fiadhmhuine was so called, for he used to hunt and chase amidst thickets or in woods; and this Eochaidh fell by Lughaidh Laimhdheargh son of Eochaidh Uaircheas.


Lughaidh Laimhdhearg son of Eochaidh Uaircheas, son of Lughaidh Iardhonn, son of Eanna Dearg, son of Duach Fionn, son of Seadna Ionnarraidh, son of Breisrigh, son of Art Imleach of the race of Eibhear, held the sovereignty of Ireland seven years. He was called Lughaidh Laimhdhearg, as there was a red ti or spot on his hand; and he fell by Conuing Beigeaglach.


Conuing Beigeaglach son of Duach Teamhrach, son of Muireadhach Bolgrach, son of Simeon Breac, son of Aodhan Glas, son of Nuadha Fionn Fail, son of Giallchaidh, son of Oilill Olchaoin son of Siorna Saoghlach of the race of Eireamhon, held the sovereignty of Ireland ten years. He is called Conuing Beigeaglach, for he never felt a qualm of fear in battle or contest, and, moreover, he was a brave man in an onslaught; and hence the poet composed this stanza: 


> 1. Conuing of the fights of the bright spears,
>   
> Who never quailed before wight,
>   
> Passed a decade ruling over each Half
>   
> Till Art son of Lughaidh slew him.
> 




Art son of Lughaidh Laimhdhearg, son of Eochaidh Uaircheas, son of Lughaidh Iardhonn, son of Eanna Dearg,


---

p.147




son of Duach Fionn, son of Seadna Ionnarraidh, son of Breisrigh, son of Art Imleach of the race of Eibhear, held the sovereignty of Ireland six years; and he fell by Duach Laghrach son of Fiachaidh Tolgrach and by Fiachaidh himself.


Fiachaidh Tolgrach son of Muireadhach Bolgrach, son of Simeon Breac, son of Aodhan Glas, son of Nuadha Fionn Fail, son of Giallchaidh, son of Oilill Olchaoin, son of Siorna Saoghlach of the race of Eireamhon, held the sovereignty of Ireland seven years; and he fell by Oilill Fionn.


Oilill Fionn son of Art, son of Lughaidh Laimhdhearg, son of Eochaidh Uaircheas, son of Lughaidh Iardhonn, son of Eanna Dearg, son of Duach Fionn, son of Seadna Ionnarraidh, son of Breisrigh, son of Art Imleach of the race of Eibhear, held the sovereignty of Ireland nine years; and he fell by Argeadmhar and by Fiachaidh and by Duach son of Fiachaidh.


Eochaidh son of Oilill Fionn, son of Art, son of Lughaidh Laimhdhearg, son of Eochaidh Uaircheas of the race of Eibhear, held the sovereignty of Ireland seven years; and he did not yield the kingdom to Argeadmhar, but made peace with Duach Lagrach; and Duach slew him at a meeting.


Airgeadmhar, son of Siorlamh, son of Fionn, son of Bratha, son of Labhraidh, son of Cairbre, son of Ollamh Fodla of the race of Ir son of Milidh, held the sovereignty of Ireland twenty-three years, or according to others thirty-eight years; and he fell by Duach Laghrach and by Lughaidh Laighdhe.


Duach Laghrach, son of Fiachaidh Tolgrach, son of Muireadhach Bolgrach, son of Simeon Breac, son of Aodhan Glas, son of Nuadha Fionn Fail, son of Giallchaidh of the race of Eireamhon, held the sovereignty of Ireland ten years. He was called Duach Laghrach, for ladhgra is the same as luathagra, 'swift retribution'; and he used to give respite to no one who had committed injustice, but exacted retribution from such on the spot, and hence he was called by the name of Duach Laghrach.




---

p.149


Lughaidh Laighdhe son of Eochaidh, son of Oilill Fionn, son of Art, son of Lughaidh Laimhdhearg, son of Eochaidh Uaircheas of the race of Eibhear, held the sovereignty of Ireland seven years; and he fell by Aodh Ruadh, son of Badharn. The Coir Anmann states that this Lughaidh was one of the five Lughaidhs, the children of Daire Doimhtheach. The same book relates that a certain druid revealed prophetically to Daire Doimhtheach that he would have a son who would be called Lughaidh who would obtain the sovereignty of Ireland; and after this five sons were born to him in succession, and he called each of them Lughaidh. When the sons grew up, Daire had recourse to the same druid, and asked him which of the five Lughaidhs would get the sovereignty of Ireland. ‘Go to-morrow to Taillte,’ said the druid, ‘with thy five sons, and there will come to-morrow a beautiful fawn into the fair, and everyone, and thy children with the rest, will run in pursuit of it, and whichever of thy children shall outrun the fawn and kill it will be king of Ireland.’ The fawn came into the fair on the morrow; and the men of Ireland and the children of Daire pursued it till they reached Beann Eadair. A druidical mist separated the sons of Daire from the men of Ireland. The sons of Daire proceeded to hunt the fawn from thence to Dal Maschorb of Leinster, and Lughaidh Laighdhe overtook and slew it; and it was from that fawn that he was called Lughaidh Laighdhe, that is, Lughaidh Laoghdha.


Of this Lughaidh there is a curious romantic story, in which it is said that, when he was engaged in hunting in a desert place, he met a hideous hag who wore a magic mask; that he went into her bed, and took off her magic mask, and dreamt that she would be a beautiful young lady thereafter; and by this hag, with whom Lughaidh lay, Ireland is allegorically meant, for at first he endured toil and torment on her account, but afterwards enjoyed pleasure and delight.


Although the Coir Anmann states that Lughaidh Laighdhe


---

p.151




was a son of Daire Doimhtheach, I do not think that this is the Lughaidh Laighdhe the Coir Anmann refers to who was king of Ireland, notwithstanding that the druids foretold that Lughaid Laighdhe son of Daire Doimhtheach would become king of Ireland.


Aodh Ruadh son of Badharn, son of Airgeadmhar, son of Siorlamh, son of Fionn, son of Bratha, son of Labhraidh, son of Cairbre, son of Ollamh Fodla of the race of Ir son of Milidh, held the sovereignty of Ireland twenty-one years; and he was drowned at Eas Ruaidh.


Diothorba son of Deaman, son of Airgeadmhar, son of Siorlamh, son of Fionn, son of Bratha, son of Labhraidh son of Cairbre, son of Ollamh Fodla of the race of Ir son of Milidh, held the sovereignty of Ireland twenty-one years; and he fell in Corann by the Cuans, that is Cuan Mara, Cuan Muighe, and Cuan Sleibhe.


Ciombaoth son of Fionntan, son of Airgeadmhar, son of Siorlamh, son of Fionn, son of Bratha, son of Labhraidh, son of Cairbre, son of Ollamh Fodla of the race of Ir son of Milidh, held the sovereignty of Ireland twenty years, or according to others twenty-eight years; and he died of the plague in Eamhain Mhacha.




---

p.153


XXVIII.
-------


Macha Mhongruadh, daughter of Aodh Ruadh son of Badharn, son of Airgedmhar, son of Siorlamh, son of Fionn, son of Bratha, son of Labhraidh, son of Cairbre, son of Ollamh Fodla, held the sovereignty of Ireland seven years, till Reachtaidh Righdhearg slew her. And it was in her time that Eamhain Mhacha was built. Now the reason why it is called Eamhain Mhacha is this: three kings out of Ulster held the sovereignty of Ireland, namely, Aodh Ruadh son of Badharn, from whom is named Eas Ruaidh, and Diothorba son of Deaman of Uisneach in Meath, and Ciombaoth son of Fionntan from Fionnabhair; and it was with this Ciombaoth that Ughaine Mor son of Eochaidh Buadhach was brought up. And each of these kings reigned seven years in succession, until each had held the sovereignty of Ireland thrice. And the first of them to die was Aodh Ruadh; and he left no issue but one daughter named Macha. Macha demanded the sovereignty in her turn after her father's death; and Diothorba and his children said that they would not cede sovereignty to a woman; and a battle was fought between themselves and Macha; and Macha triumphed over them in that battle, and held the sovereignty of Ireland seven years; and Diothorba died and left five sons, namely, Baoth, Bedach, Bras, Uallach, and Borbchas. These demanded the sovereignty of Ireland for themselves, as it was held by their ancestors before them. Macha said she would only give them battle for the sovereignty. A battle was fought between them, and Macha defeated them. The children of Diothorba fled for safety to dark and intricate woods; and Macha took Ciombaoth son of Fionntan as her husband, and made him leader of her warriors, and went herself in pursuit of the sons of Diothorba in the guise of a leper, having rubbed her body with the dough of rye, and found them in an intricate 


---

p.155




forest in Burenn, cooking a wild boar. The sons of Diothorba asked news of her, and gave her a portion of the meat. She told them all the news she had.


And then one of the men said that the leper had a beautiful eye, and that he desired to lie with her. Thereupon he and Macha retired into the recesses of the wood, and Macha bound this man and left him there, and returned to the rest. And they questioned her, ‘Where didst thou leave the man who went with thee?’ said they. ‘I know not,’ said she; ‘but I think he feels ashamed to come into your presence after embracing a leper.’ ‘It is not a shame,’ said they, ‘since we will do the same thing.’ Thus she went into the wood with each of them in turn; and she bound them all, and so took them bound together before the men of Ulster at Eamhain; and she asked the Ulster nobles what she should do with them. They all said with one accord that they should be put to death. ‘That is not just,’ said Macha, ‘for that would be contrary to law; but let them be made slaves of and let the task be imposed on them of building a fort for me which shall be the capital of the province for ever.’ Thereupon Macha undid the gold bodkin that was in the mantle on her breast, and with it measured the site of the fort which the sons of Diothorba were obliged to build. Now, the fort is called Eamhain eo being a word for ‘a bodkin’, while muin means ‘the neck’, and hence the fort is called Eamhain, that is, eo mhuin. Or, it is called Eamhain from Eamhain Mhacha, that is, the wife of Cronn son of Adhnaman. Now this woman was forced against her will to run with the horses of Conchubhar, king of Ulster; and she, though pregnant, outran them; and at the end of the race she gave birth to a son and a daughter; and she cursed the men of Ulster, whence they were visited with the pangs of labour; and these pangs continued to afflict them during nine reigns, that is, from Conchubhar to the reign of Mal son of Rochruidhe. Eamhain accordingly


---

p.157




is the same as amhaon, amh denying that it was but one, it being two, Macha gave birth to on that occasion. And hence it was called Eamhain Mhacha, according to this opinion. After this, Macha Mhongruadh was slain by Reachtaidh Righdhearg.


Reachtaidh Righdhearg son of Lughaidh Laighdhe, son of Eochaidh, son of Oilill Fionn, son of Art, son of Lughaidh Laimhdhearg, son of Eochaidh Uaircheas of the race of Eibhear, held the sovereignty of Ireland twenty years. He was called Reachtaidh Righdhearg from his having a red fore-arm, that is, the end of a red fore-arm; and he was slain by Ughaine Mor to avenge his foster-mother.


Ughaine Mor son of Eochaidh Buadhach, son of Duach Laghrach, son of Fiachaidh Tolgrach, son of Muireadhach Bolgrach, son of Simeon Breac, son of Aodhan Glas, son of Nuadha Fionn Fail, son of Giallchaidh, son of Oilill Olchaoin, son of Siorna Saoghlach of the race of Eireamhon, held the sovereignty of Ireland thirty years, or according to others forty years. He was called Ughaine Mor, as his reign was great, since he held sway over the islands of western Europe; and this Ughaine had twenty-five children, namely twenty-two sons and three daughters. When these children grew up, each of them had a special retinue; and when they went on free circuit round Ireland, where one of the sons stayed at night, another son stayed on the morrow. Thus they went on in succession, so that wherever they directed their steps they exhausted all the food and provisions in the district. And when the men of Ireland observed this, they went to complain of this injury to Ughaine, the king. And it was mutually agreed on to divide Ireland into twenty-five parts, and to give each of these children his own part, and not to permit any one of them to be a burden to another's portion. Hence some poet composed this stanza:


> 1. Ughaine the proud, the noble,
>   
> Whose victorious dwelling was Banbha,
>   
> His children divided rightly
>   
> Erin into twenty-five portions.
> 






---

p.159


And it was according to these divisions that rents and duties used to be paid to every king who reigned in Ireland for three hundred years, that is, from the time of Ughaine to the time of the provincials who lived when Eochaidh Feidlioch was king of Ireland, as the poet says in this quatrain:


> 1. Three hundred years lasting the reproach,
>   
> Until the provincials arose,
>   
> Five without faith in their hearts,
>   
> Shared between them Ughaine's Erin.
> 




It was Eochaidh Feidhlioch who divided the provinces of Ireland amongst the following. He gave the province of Ulster to Fearghus son of Leide; he gave the province of Leinster to Rossa son of Fearghus Fairrge; he gave the two provinces of Munster to Tighearnach Teidbheannach son of Luchta, and to Deaghaidh son of Sin; similarly he gave the province of Connaught to three, namely, to Fidhic son of Feig, to Eochaidh Allad, and to Tinne son of Connraidh, as we shall hereafter set forth when we are treating of Eochaidh Feidhleach's own reign. Still this division of Ireland among the children of Ughaine held good until the children of Ughaine had died without issue, except two, namely, Cobhthach Caol mBreagh and Laoghaire Lorc, from whom come all that survive of the race of Eireamhon. And Ughaine Mor himself was slain by Badhbhchaidh son of Eachaidh Buadhach his own brother in Tealach an Choscair. But Badhbhchaidh held the sovereignty of Ireland only a day and a half when he was slain by Laoghaire Lorc to avenge his father.




---

p.161


XXIX.
-----


Laoghaire Lorc son of Ughaine Mor, son of Eochaidh Buadhach, son of Duach Laghrach, son of Fiachaidh Tolgrach, son of Muireadhach Bolgrach, son of Simeon Breac, son of Aodan Glas, son of Nuadha Fionn Fail, son of Giallchaidh, son of Oilill Olchaoin, son of Siorna Saoghalach of the race of Eireamhon, held the sovereignty of Ireland two years. Ceasair Chruthach, daughter of the king of the French, wife of Ughaine Mor, was the mother of Laoghaire Lorc and Cobhthach Caol mBreagh. And he was called Laoghaire Lorc, for lorc means 'murder of a kinsman'; and Laoghaire treacherously slew Badhbhchaid, son of Eachaidh Buadhach, whence he got the name Laoghaire Lorc. Cobhthach Caol mBreagh, his own brother, slew Laoghaire Lorc at Dionn Riogh on the brink of the Bearbha.


It happened that Cobhthach Caol mBreagh had been pining through envy of Laoghaire Lorc on account of his holding the sovereignty of Ireland; and when Laoghaire heard that he was sick, he came with an armed force to visit him. When Cobhthach saw him, he said it was sad that his brother always had a suspicion of him and would not come into his presence without an escort. ‘Not so,’ said Laoghaire; ‘I will come peacefully into thy presence the next time unattended by an armed escort.’ Thereupon, Laoghaire bade farewell to Cobhthach. Now Cobhthach took the advice of a druid who was with him as to how he could lay hold on his kinsman to kill him. ‘What thou hast to do,’ said the druid, ‘is to feign death, and go into a bier as a corpse, and to send word of this to Laoghaire; and he will come to thee with only a small escort; and when he will


---

p.163




come into thy presence, he will lie on thy body lamenting thee, and do thou stab him in the abdomen with a dirk, and thus kill him.’ When Cobhthach had in this manner finished the killing of Laoghaire, he slew also Oilill Aine son of Laoghaire; and he recovered his health after he had done these deeds. He also commanded a young lad whose name was Maon, the son of Oilill Aine, to be brought into his presence, and made him eat a portion of his father's and grandfather's hearts, and to swallow a mouse with *its tail*. But the child lost his speech from the disgust he felt, and when he became speechless Cobhthach let him go. The child proceeded to Corca Dhuibhne, where he resided for a time with Scoiriath, who was king of that country, and thence went to France with a party of nine, though some seanchas say that it was to the country of Armenia he went. And the party who accompanied him declared that he was heir to the kingdom of Ireland; and from this it came to pass that the king of the French made him leader of his household guards; and he became very successful, and so was much talked about, and his fame was great in Ireland; and consequently many Irishmen followed him to France. And he remained there a long time of his life.


Cobhthach Caol mBreagh son of Ughaine Mor, son of Eachaidh Buadhach of the race of Eireamhon, held the sovereignty of Ireland thirty years, or, according to others, fifty years. Ceasair Chruthach, daughter of the king of the French, was his mother. He was called Cobhthach Caol mBreagh, for a severe disease afflicted him through envying his brother Laoghaire Lorc, who was king of Ireland before him, so that he got into decline, and his blood and flesh melted away, so that he was thin; and Magh Breagh is the name of the place in which he lay sick, and hence he was called Caol mBreagh; and this Cobhthach was slain by Labhraidh Loingseach, son of Oilill Aine, at Dionn Riogh, on the eve of greater Christmas, to avenge his father


---

p.165




and grandfather whom he had slain. On this some poet composed this stanza: 


> 1. Labhraidh Loinseach, sufficient his army,
>   
> He slew Cobhthach in Dionn Riogh;
>   
> With the lance-armed host beyond the sea-water,
>   
> It was from these that the Lagenians were named.
> 




Labhraidh Loingseach son of Oilill Aine, son of Laoghaire Lorc, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland ten years; and he fell by Meilge son of Cobhthach Caol mBreagh. And the way in which he was allured from France to Ireland was that Moiriath daughter of Scoiriath, king of the territory of Feara Morc in west Munster, conceived a violent passion for him on account of the greatness of his name and fame. She equipped Craiftine the harper, a musician who was in Ireland at the time, that he might go after him to France with many love-presents, together with a love-lay in which she set forth the intensity of her passion for Maon; and when Craiftine arrived in France, he played a very sweet tune on his harp when he came to where Maon was, and sang the love-lay which Moiriath daughter of Scoiriath had composed for Maon. He was so delighted with Craiftine's playing that he said he considered the song and the tune melodious; and when his followers and Craiftine had heard this, they besought the king of the French to give him an auxiliary force so that he might go and regain his own territory; and the king gave him a fleetful, that is, two thousand two hundred, and they put out to sea; and no tidings whatever are given of them till they put into harbour at Loch Garman; and when they came ashore, they learned that Cobhthach Caol mBreagh was in Dionn Riogh and many of the Irish nobles with him, and thereupon they marched day and night, and attacked his fortress, and slew Cobhthach together with these nobles. It was then that a druid who was in the fortress inquired


---

p.167




who had executed that slaughter. ‘The mariner’ (An loingseach), replied the man outside. ‘Does the mariner speak?’ asked the druid. ‘He speaks’ (Labhraidh), said the other. And hence the name Labhraidh Loingseach clung to Maon ever since. And it was he who first made in Ireland spears with broad greenish blue heads; for laighne means spears having wide green-blue iron heads; and from these spears the name Laighin is given to the people of the province of Gailian, which is now called the province of Leinster. And the poet proves this, and sets forth the number of the host which came with Labhraidh Loingseach from France, in the following stanza: 


> 1. Two hundred and twenty hundred foreigners,
>   
> With broad spears they came over;
>   
> From these spears without flaw
>   
> The Leinstermen are called Laighin.
> 



Now when Labhraidh Loingseach had slain Cobhthach Caol mBreagh, and had taken possession of Ireland, he went along with Craiftine to visit Moiriath daughter of Scoiriath, king of the territory of Feara Morc, the lady-love who sent Craiftine to France to visit him. Labhraidh married her, and she was his queen during life.


Now the reason why Maon who was called Labhraidh Loingseach went to France was his relation to the king of the French. For a daughter of the king of the French called Ceasair Chruthach was the wife of Ughaine Mor and mother of his children, namely, Laoghaire Lorc and Cobhthach Caol mBreagh; and Labhradh Loingseach is a son's son to that Laoghaire Lorc. And it was on account of his relation to the French that he sought their protection.


Another reason why he went to France rather than to another country is that there was a special friendly understanding between the Leinstermen and the French. Indeed every province in Ireland had formed a special friendly alliance beyond the sea, as the alliance between clann Neill and the


---

p.169




Albanians, between the Munstermen and the Saxons, between the Ultonians and the Spanish, between the people of Connaught and the Welsh, as John son of Torna O Maolchonaire, chief professor of seanchus in Ireland, says in the following stanzas:


> 1. Each is allied to its like,
>   
> Though they be not of the same stock;
>   
> The Ui Néill and the Albanians;
>   
> The Saxons and the Munstermen;
> 2. The Ultonians and the Spaniards,
>   
> The battle-stay of every district;
>   
> The Connaughtmen and the Welsh;
>   
> The Leinstermen allied to the French.
> 




From this alliance between the provinces and the abovenamed countries they became mutually assimilated in manners according to their friendship and affection for one another.


Know, O reader, that all true Leinstermen that survive of the race of Eireamhon are descended from this Labhraidh Loingseach, except O Nuallain who sprang from Cobhthach Caol mBreagh. The following are the principal families that sprang from the Leinstermen, namely, O Conchubhar Failghe with his family branches, O Caomhanaigh, O Tuathalaigh, O Branaigh, Mac Giolla Phadraig, O Duinn, O Diomasaigh, O Duibhidhir, muinntear Riain, and every branch that sprang from these families. It was from Cathaoir Mor that most of the Leinster families sprang. But it was not from him that Mac Giolla Phadraig sprang, since Mac Giolla Phadraig and himself separated in pedigree from one another at Breasal Breac son of Fiachaidh Foibhric, the fourteenth ancestor from Cathaoir upwards. Now this Breasal had two sons, namely, Lughaidh Loithfhionn and Connla; and the province of Leinster was divided between these two: thus Lughaidh and his descendants obtained from the Bearbha eastward, and Connla and his descendants from the Bearbha westwards. These sons and


---

p.171




these divisions are set forth in the following stanza from the poem which begins, The sacred history of the saints of Inis Fail:


> 1. Lughaidh and Connla without vexation,
>   
> Two sons of Breasal Breac the noble;
>   
> The Ossorians sprang from Connla of the wounds,
>   
> Lughaidh is ancestor of the Lagenians.
> 




From Lughaidh also sprang O Duibhidhir; and they separated from Cathaoir in pedigree at the fifth ancestor from Cathaoir upwards. Now, Cathaoir Mor was son of Feidhlimidh Fiorurghlas, son of Cormac Gealta Gaoth, son of Nia Corb, son of Cu Chorb. And a son of this Cu Chorb was Cairbre Cluithiochair, from whom is O Dubhidhir; and from Nathi son of Criomhthann, son of Eanna Cinnsealach, the seventh in descent from Cathaoir Mor, came muinntear Riain.


Now, the second son of Ughaine Mor who had issue was Cobhthach Caol mBreagh. From him sprang all the race of Conn, both the descendants of Fiachaidh Sraibhtheine and of Eochaidh Doimhlen, and every other branch that sprang from Conn, as we shall set down hereafter in the genealogy of the sons of Milidh.




---

p.173


XXX.
----


We read of Labhraidh Loingseach that his ears were like those of a horse; and hence, he used to kill on the spot everyone who cut his hair, lest he or anyone else might be aware of this blemish. Now he was wont to have his hair cropped every year, that is, to have cut off the part of his hair that grew below his ears. It was necessary to cast lots to determine who should crop the king each year, since it was his wont to put to death everyone who cropped him. Now it happened that the lot fell on the only son of a widow who approached the close of her life, and who lived near the king's stronghold. And when she heard that the lot had fallen on her son, she came and besought the king not to put her only son to death, seeing he was her sole offspring. The king promised her that he would not put her son to death, provided he kept secret what he should see, and made it known to no one till death. And when the youth had cropped the king, the burden of that secret so oppressed his body that he was obliged to lie in the bed of sickness, and that no medicine availed him. When he had lain long in a wasting condition, a skilful druid came to visit him, and told his mother that the cause of his sickness was the burden of a secret, and that he would not be well till he revealed his secret to some thing; and he directed him, since he was bound not to tell his secret to a person, to go to a place where four roads met, and to turn to his right and to address the first tree he met, and to tell his secret to it. The first tree he met was a large willow, and he disclosed his secret to it. Thereupon the burden of pain that was on his body vanished; and he was healed instantly as he returned to his mother's house. Soon after this, however, it happened that Craiftine's harp got broken, and he went to seek the material for a harp, and came upon the very willow to which the widow's son had revealed the secret, and from it he took


---

p.175




the material for his harp and when the harp was made and set to tune, as Craiftine played upon it all who listened imagined that it sang, ‘Da o phill ar Labhraidh Lorc,’ that is, Labraidh Loingseach, meaning, ‘Two horse's ears on Labhraidh Lorc’; and as often as he played on that harp, it was understood to sing the same thing. And when the king heard this story, he repented of having put so many people to death to conceal that deformity of his, and openly exhibited his ears to the household, and never afterwards concealed them. I think this part of the story is a romantic tale rather than history. This Labhraidh fell by Meilge son of Cobhthach Caol mBreagh.


Meilge Molbhthach son of Cobhthach Caol mBreagh son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland seven years; and he fell by Mogh Corb son of Cobhthach Caomh.


Mogh Corb son of Cobhthach Caomh, son of Reachthaidh Ridhearg, son of Lughaidh Laighdhe, son of Eochaidh, son of Oilill Fionn, son of Art, son of Lugaidh Lamhdhearg, son of Eochaidh Uaircheas of the race of Eibhear, held the sovereignty of Ireland seven years. He was called Mogh Corb, because, as his son was one day in a chariot, a portion of the chariot got broken, and Mogh Corb repaired it, and through having done this service for his son whose name was Corb he was called Mogh Corb. He fell by Aonghus Ollamh.


Aonghus Ollamh son of Oilill, son of Labhraidh Loingseach, son of Oilill Aine, son of Laoghaire Lorc, son of Ughaine Mor of the race of Eireamhon held the sovereignty of Ireland eighteen years, and fell by Iarainnghleo son of Meilge.


Iarainnghleo Fathach son of Meilge Molbhthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland seven years; and he was called Iarainnghleo Fathach because he was wise, skilful, accomplished; and at length he fell by Fear Corb son of Mogh Corb.




---

p.177


Fear Corb son of Mogh Corb, son of Cobhthach Caomh, son of Reachtaidh Righdhearg of the race of Eibhear, held the sovereignty of Ireland eleven years; and he fell by Connla son of Iarainnghleo Fathach.


Connla Cruaidhchealgach son of Iarainnghleo Fathach, son of Meilge Molbhthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor of the race of Eireamhon, held the sovereignty four years; and he fell at Tara.


Oilill Caisfhiaclach son of Connla Cruaidhchealgach, son of Iarainnghleo Fathach, son of Meilge Molbhthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland twenty-five years, till he fell by Adhamair Foltchaoin.


Adhamair Foltchaoin son of Fear Corb, son of Mogh Corb, son of Cobhthach Caomh, son of Reachtaidh Righdhearg of the race of Eibhear, held the sovereignty of Ireland five years; and fell by Eochadh Foiltleathan.


Eochaidh Foiltleathan son of Oilill Caisfhiaclach, son of Connla Cruaidhchealgach, son of Iarainnghleo Fathach, son of Meilge Molbhthach, son of Cobhthach Caol, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland eleven years, and fell by Fearghus Fortamhail.


Fearghus Fortamhail son of Breasal Breac, son of Aonghus Gaileann, son of Oilill Bracan, son of Labhraidh Loingseach, son of Oilill Aine, son of Laoghaire Lorc, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland twelve years; and he was called Fearghus Fortamhail, for he was warlike, strong, vigorous in his own time; and he fell by Aonghus Tuirbheach.


Aonghus Tuirbheach son of Eochaidh Foiltleathan, son of Oilill Caisfhiaclach, son of Connla Cruaidhchealgach, son of Iarainnghleo Fathach, son of Meilge Molbhthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland thirty years, or, according to others, sixty years; and he was called Aonghus


---

p.179




Tuirbheach, for he felt ashamed (tuirbheach) of the son he had by his own daughter through drunkenness. This son was called Fiachaidh Fear Mara; and he was called Fiachaidh Fear Mara because he was abandoned, being put on the sea in a canoe with precious valuables around him, such as befitted the son of a king; and fishermen came upon him and brought him ashore, and put him to nurse. Aonghus Tuirbheach had also a son by his wedded wife, and his name was Eanna Aighneach, and from him came the entire race of Conn; and Aonghus Tuirbheach himself was slain at Tara; and it is from his having been slain at Tara that he is called Aonghus Tuirbheach Teamhrach.


Conall Collamhrach son of Eidirsceol Teamhrach, son of Eochaidh Foiltleathan, son of Oilill Caisfhiaclach, son of Connla Cruaidhchealgach, son of Iarainnghleo Fathach, son of Meilge Molbhthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor, held the sovereignty of Ireland five years, and fell by Nia Seaghamain.


Nia Seaghamain son of Adhamair Foltchaoin, son of Fear Corb, son of Mogh Corb, son of Cobhthach Caomh, son of Reachtaidh Righdhearg of the race of Eibhear, held the sovereignty of Ireland seven years; and he was called Nia Seaghamain, that is, seachmhaoineach 'surpassing in wealth', as his wealth far exceeded that of all others, for the wild does used to come and yield their milk kindly like any cow in his reign in Ireland through the magic of his mother, whose name was Fliodhais; and this Nia Seaghamain fell by Eanna Aighneach.


Eanna Aighneach son of Aonghus Tuirbheach Teamhrach, son of Eochaidh Foiltleathan, son of Oilill Caisfhiaclach, son of Connla Cruaidhchealgach, son of Iarainnghleo Fathach, son of Meilge Molbhthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland twenty-eight years. He was called Eanna Aighneach, for aighneach is the same as ogh oineach, that is, 'perfect generosity',


---

p.181




for he used to give away whatever came to his hand; and he fell by Criomhthann Coscrach.


Criomhthann Coscrach son of Feidhlimidh Foirthriun, son of Fearghus Fortamhail, son of Breasal Breac, son of Aonghus Gaileann, son of Oilill Bracan, son of Labhraidh Loingseach, son of Oilill Aine, son of Laoghaire Lorc, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland seven years. He is called Criomhthann Coscrach from the frequency with which he was victorious in slaughter and contest in every battle in which he was engaged; and he fell by Rudhruighe son of Sithrighe.


Rudruighe son of Sithrighe, son of Dubh, son of Fomhor, son of Airgheadmhar, son of Siorlamh, son of Fionn, son of Bratha, son of Labhraidh, son of Cairbre, son of Ollamh Fodla of the race of Ir son of Mileadh, held the sovereignty of Ireland thirty years, or, according to others, seventy years; and he died of the plague at Airgeadros.


Ionnadmhar son of Nia Seaghamain, son of Adhamair Foltchaoin, son of Fear Corb, son of Mogh Corb, son of Cobhthach Caomh, son of Reachtaidh Righdhearg of the race of Eibhear, held the sovereignty of Ireland three years; and he fell by Breasal Boidhiobhadh.


Breasal Boidhiobhadh son of Rudhruighe, son of Sithrighe, son of Dubh, son of Fomhor, son of Airgeadmhar, son of Siorlamh of the race of Ir son of Milidh, held the sovereignty of Ireland eleven years. He was called Breasal Boidhiobhadh, for a great cow-plague occurred in Ireland in his time. This Breasal fell by Lughaidh Luaighne.


Lughaidh Luaighne son of Ionnadmhar, son of Nia Seaghamain, son of Adhamair Foltchaoin, son of Fear Corb, son of Mogh Corb, son of Cobhthach Caomh, son of Reachtaidh Righdhearg of the race of Eibhear, held the sovereignty of Ireland five years, and fell by Conghal Clairingneach.


Conghal Clairingneach son of Rudhruighe, son of Sithrighe,


---

p.183




son of Dubh, son of Fomhor, son of Airgeadmhar, son of Siorlamh of the race of Ir son of Milidh, held the sovereignty of Ireland fifteen years, and fell by Duach Dallta Deaghaidh.


XXXI.
-----


Duach Dallta Deaghaidh son of Cairbre Lusc, son of Lughaidh Luaighne, son of Ionnadmhar, son of Nia Seaghamain, son of Adhamair Foltchaoin, son of Fear Corb, son of Mogh Corb, son of Cobhtbach Caomh, son of Reachtaidh Righdhearg of the race of Eibhear, held, the sovereignty of Ireland ten years. He was called Duach Dallta Deaghaidh, for Cairbre Lusc had two sons, namely Duach and Deaghaidh, and they disputed the sovereignty of Ireland with one another, for each of these sons, was a fit person for the kingship as regards shape, make, action, and valour. But Deaghaidh, the youngest of the sons, sought to supplant his elder brother Duach. When Duach perceived this, he sent messengers for his brother Deaghaidh; and Deaghaidh came to the place where Duach was; and when he came into his presence, Duach seized him, and took out his eyes, so that he was really a blind man; hence the name Duach Dallta Deaghaidh, ‘Duach who blinded Deaghaidh’, clung to him. To set forth this deed some poet composed this stanza:


> 1. Deaghaidh was seized in his house
>   
> By Duach, by his brother;
>   
> And blinded by violence was
>   
> This Deaghaidh, though sorry was the deed.
> 



This Duach fell by Fachtna Fathach son of Cas.


Fachtna Fathach son of Cas, son of Rudhruighe, son of Sithrighe, son of Dubh, son of Fomhor, son of Airgeadmhar, son of Siorlamh of the race of Ir son of Milidh, held the sovereignty of Ireland sixteen years; and he fell by Eochaidh Feidhlioch.




---

p.185


Eochaidh Feidhlioch son of Fionn, son of Fionnlogh, son of Roighnen Ruadh, son of Easaman Eamhna, son of Blathacht, son of Labhraidh Lorc, son of Eanna Aighneach, son of Aonghus Tuirbheach Teamhrach, son of Eochaidh Foiltleathan, son of Oilill Caisfhiaclach, son of Connla Cruaidhchealgach, son of Iarainnghleo Fathach, son of Meilge Molbhthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland twelve years. Benia daughter of Crioinhthann was mother of Eochaidh Feidhlioch. He was called Eochaidh Feidhlioch, for he suffered long from sighing, for feidhil means long, and uch means ‘a sigh’, hence Feidhlioch means ‘a long sigh’. For his heart was never without a sigh since he slew his sons in the Battle of Drom Criaidh until his own death. These three sons were called the three Finneamhnas. And they were called Eamhna, from the word amhaon, denying that any one of them was born alone, they being all born together. And Cloithfhionn daughter of Eochaidh Uichtleathan, wife of Eochaidh Feidhlioch, was their mother, and she gave birth to them together. Their names were Breas and Nar and Lothar. And this Eochaidh Feidhlioch it was who first divided Ireland into provinces and instituted provincials. For he divided the province of Connaught into three parts, between three, namely, Fidheac son of Feig, Eochaidh Allad, Tinne son of Connraidh. He gave to Fidheac Fir na Craoibhe, from Fidheac to Luimneach; he gave to Eochaidh Allad Iorrus Domhnann, from Gaillimh to Dubh, and to Drobhaois; he gave to Tinne son of Connraidh, Magh Sainbh and Seantuatha Taidhean, from Fidheac to Teamhair Bhrogha Niadh; he gave, moreover, the province of Ulster to Fearghus son of Leide; he gave the province of Leinster to Rossa son of Fearghus Fairrge; he gave the two provinces of Munster to Tighearnach Teadbhannach and to Deaghaidh; so that he brought all Ireland under his own sway and rule during his reign.




---

p.187


After this, however, Eochaidh went into Connaught; and the three kings and the people of the three divisions of Connaught came to meet him. Eochaidh asked of them the site of a royal fortress for himself in Connaught. Eochaidh Allad and Fidheac said they would not grant him this, and that they preferred to send him his rent and dues to Tara. Tinne son of Connraidh, however, the third king, consented to Eochaidh's having the site of a fortress. Eochaidh gave his own daughter Meadhbh to wife to Tinne; and they formed a friendly alliance with one another. Eochaidh Feidhlioch inquired of his druids where he should build the fortress; and they told him to build it at Druim na nDruadh, which is called Cruachain. The fort was then begun by the Gamhanruidh from Iorrus Domhnann; and they made the rampart of that fort of Eochaidh in one day, as the poet says:


> 1. He enjoined on the tribe of Domhnann, in one day
>   
> To make and shape the rampart;
>   
> The king of Fail of the feasts gave not
>   
> Pay to the men for the work.
> 



A residence was then built within it; and Eochaidh gave the kingdom of Connaught to Tinne son of Connraidh, and gave him his own daughter, Meadhbh, in marriage. After this Tinne slew Eochaidh Allad, and gave the kingdom of Domhnann to Oilill Fionn. Now Meadhbh gave the government of Raith Eochach to Crochain Croidhearg, her own mother; and it is from this Crochain that the name Cruachain is now given to Raith Cruachan, as the poet says in this quatrain:


> 1. Druim na nDruadh and Tulach Oichne,
>   
> And then Raith Eochach was it called;
>   
> Raith Cruachan from Crochain Croidhearg,
>   
> Who sped great wrath on the plain.
> 



Meadhbh continued for a long time afterwards to be the wife of Tinne son of Connraidh, till he fell at Tara by the hand of 


---

p.189




Monuidhir, who was called Mac Ceacht. Now Meadhbh held for ten years the sovereignty of Connaught after Tinne without living with any man publicly, but living privately with whatever man pleased her fancy. After this Meadhbh took for her husband Oilill Mor son of Rossa Ruadh, a Leinsterman. Mada Muirisc, a Connaughtwoman, was his mother. And Meadbh bore to Oilill seven sons, namely, the seven Maines. And it was Conall Cearnach who when at Cruachain, in his old age, slew Oilill by a cast of a javelin; and the men of Connaught followed and slew him to avenge that deed.


There were war and strife for a long time between the people of Connaught and those of Ulster while Meadhbh held sway over Connaught, and Conchubhar was king of Ulster. And in order that thou mayest know, O reader, the cause of the enmity that existed between them, I shall set down here how the children of Uisneach were slain in violation of the guarantee or protection of Fearghus son of Rogh, of Cormac Conluingeas, and of Dubthach Daol Uladh. The pith of the story is briefly as follows.




---

p.191


XXXII.
------


One day Conchubhar, king of Ulster, went to partake of a feast to the house of Feidhlimidh son of Dall, storyteller to Conchubhar. In the course of that feast the wife of Feidhlimidh gave birth to a beautiful daughter; and Cathbhadh the druid, who was present at the assembly on that occasion, foreboded and foretold of this daughter that great misfortune and mischief would befall the province on her account. When the warriors heard this, they sought to put her to death on the spot. ‘By no means,’ said Conchubhar; ‘but I will take her and put her to nurse so that she may become my wife.’ Deirdre was the name that Cathbhadh the druid gave her. Conchubhar placed her in a dwelling apart, with a tutor and a nurse to bring her up; and no one in the province was permitted to go into her presence but her tutor, her nurse, and Conchubhar's censorious woman, who was called Leabharcham. She continued under these regulations until she was marriageable, and until she excelled the women of the time in beauty. One snowy day it chanced that her tutor killed a calf to prepare food for her; and when the calf's blood was shed on the snow, a raven began to drink it. And when Deirdre observed this, she said to Leabharcham that she would like to have a husband having the three colours she beheld, namely, his hair of the colour of the raven, his cheek of the colour of the calf's blood, and his skin of the colour of the snow. ‘Such a man is in the household with Conchubhar; he is called Naoise, son of Uisneach.’ ‘Then,’ said she, ‘I beseech thee, O Leabharcham, send him to speak to me in secret’; and Leabharcham informed Naoise of this. Thereupon Naoise came secretly to visit Deirdre, who revealed to him how greatly she loved him, and besought him to elope with her from Conchubhar. Naoise consented to this with reluctance, as he feared Conchubhar. Himself and his two


---

p.193




brothers Ainle and Ardan, having Deirdre and thrice fifty warriors with them, proceeded to Alba, where they were maintained in service by the king of Alba till he was informed of Deirdre's beauty, and asked her for his wife. Naoise and his brothers became enraged at this, and fled with Deirdre from Alba to an island in the sea, having previously had many conflicts with the king's party. Now when the story ran in Ulster that the sons of Uisneach were in this sad plight, many of the nobles of the province said to Conchubhar that it was a pity that the sons of Uisneach should be in exile on account of a wicked woman, and that they should be sent for and brought back to the country. Conchubhar consented to this at the request of the nobles; and he gave Fearghus son of Rogh, Dubhthach Daol Uladh, and Cormac Corluingeas as sureties that he would act towards them in good faith. Upon these conditions, Fearghus son of Rogh sent his own son Fiachaidh to the children of Uisneach; and he brought them and their followers to Ireland, and Deirdre with them; and no tidings whatever of them are related till they reached the green of Eamhain.


On the green they were met by Eoghan son of Durrthacht, prince of Fearnmhagh, accompanied by a large host with intent to deal treacherously with the children of Uisneach at the direction of Conchubhar; and when the childrcn of Uisneach arrived, Eoghan went to bid Naoise welcome, and in welcoming him thrust a spear through him. When Fiachaidh son of Fearghus saw this, he sprang between Eoghan and Naoise; and Eoghan dealt his second thrust at Fiachaidh, and slew him, together with Naoise; and forthwith Eoghan and his host fell upon the children of Uisneach, and slew them, and made dreadful slaughter upon their followers.


Now when Fearghus and Dubhthach heard that the children of Uisneach had been slain in violation of their guarantee, they proceeded to Eamhain, and came into conflict with the party of Conchubhar, and they slew Maine son of


---

p.195




Conchubhar, together with three hundred warriors of his followers. They burned and plundered Eamhain, and put Conchubhar's women to death; and they and Cormac Conluingeas assembled their supporters from all sides; and their host at that time numbered three thousand warriors; and they thence marched into Connaught to Meadhbh and to Oilill, where they found welcome and were taken into service. When they had arrived there, there was no night that they did not send parties of plunderers to ravage and burn Ulster. They continued to act thus till they ravaged the district of Cuailgne—a deed from which sprang much mischief and contention between the two provinces; and in this manner they passed seven years without an hour's truce between them. Within that time Fearghus knew Meadhbh, and she conceived of him, and bore him three sons at one birth, namely, Ciar, and Corc, and Conmhac, as the poet says:


> 1. Meadhbh conceived in fair Crunchain
>   
> Of Fearghus, who deserved not reproach,
>   
> And brought forth triplets faultless, strong,
>   
> Ciar and Corc and Conmhac.
> 



From this Ciar is named Ciarraidhe in Munster, and O Conchubhair Ciarraidhe is of his progeny. From Corc is named Corca Moruadh; and from Conmhac is named every Conmhaicne in Connaught; and whoever reads the poem composed by Lughair, Oilill's poet, beginning, The children of Fearghus, children beyond all, he will plainly find that these three sons of Meadhbh wielded great power and authority in Connaught and in Munster. This is proved by the territories that are named from them in these two provinces.


Now as to Deirdre, who gave rise to the events we have narrated, she remained with Conchubhar a year after the slaying of the children of Uisneach; and little though it be to raise her head or let a smile cross her lips, she did not do it during that time. When Conchubhar saw that neither sport nor kindness had any effect on her, and neither merriment nor


---

p.197




pleasure raised her spirits, he sent for Eoghan son of Durrthacht, prince of Fearnmhagh; and when Eoghan had come into his presence, he said to Deirdre that, since he himself was unable to turn away her mind from her sorrow, she must pass another space of time with Eoghan; and she was thereupon placed behind Eoghan in his chariot. Conchubhar went to accompany them; and as they went along, she cast glances of rage at Eoghan in front of her and at Conchubhar behind her; for there were no two on earth she hated more than these. And when Conchubhar perceived her glancing by turns at himself and Eoghan, he said to her in jest, ‘Deirdre,’ said he, ‘thy glancing at me and at Eoghan is the glancing of a sheep between two rams.’ When Deirdre heard this, she started at the words, and sprang lightly from the chariot; and her head struck against a ledge of rock that stood before her on the ground. Her head was broken into fragments, and her brain straightway issued forth. Thus was brought about the banishinent of Fearghus son of Rogh, and of Cormac Conluingeas son of Conchubhar, of Dubhthach Daol Uladh, and the death of Deirdre.


As it was in the time of Conchubhar and the heroes that Meadhbh held the sovereignty of Connaught, and as she lived ten years after the death of Tinne son of Connraidh, her first husband, and for eighty years after that was the wife of Oilill Mor, and lived eight years unmarried after the death of Oilill till she was slain by Forbhuidhe son of Conchubhar, we shall briefly set down here the manner of death and some account of the more celebrated of the heroes who lived in the time of Meadhbh.




---

p.199


XXXIII.
-------


#### Here follows a first brief summary of the adventure which led to the death of Conchubhar.


Now at that time, in order to incite champions to be brave in conflict, it was customary to give a champion's prize as a token of victory to him who proved the stronger in single combat, and who vanquished his adversary in the field of valour. From this custom there arose a contest for the champion's prize between Conall Cearnach, and Cuchulainn and Laoghaire Buadhach in Eamhain. And Conall asked for the brain of Meisceadhra, a stout Leinster champion whom he had himself slain in single combat; and when the brain of that valiant man was exhibited, Laoghaire and Cuchulainn ceased from their contest with Conall, as they judged that neither of them had ever done so great a deed of bravery or valour. It was the custom at that time that when any champion slew in battle another champion of great fame, he took the brain out of his head and mixed it with lime, so that he had it in the shape of a hard round ball to show at meetings and public assemblies as a trophy of valour. And when two jesters whom Conchubhar kept noticed how highly everyone prized the brain, they stole it the next day from Conchubhar's Craobhdhearg. Now there were three dwellings in Eamhain in Conchubhar's time, namely, Broin Bhearg and Craobh Dhearg and Craobh Ruaidh. In the first house were their wounded; and it was called Broin Bhearg, because the wounded who were in it felt sorrow and distress from the piercing pain of the wounds, and of the distempers from which they suffered therein. In the second house, which was called Craobh Dhearg, were kept in safety the arms and precious valuables; and accordingly Meisceadhra's brain was placed there for security as any other


---

p.201




precious valuable. The third house that Conchubhar had was called the Craobh Ruaidh. It was in it himself and all his warriors used to be served.



As to the two jesters*,* having carried off the brain of Meisceadhra from the Craobh Dhearg as we have said, they went on the green of Eamhain, and set to bandying the brain from hand to hand like a ball, when a fierce wolf of evil to the Ultonians, to wit, Ceat son of Magha, a valiant Connaughtman, came and coaxed the brain of Meisceadhra from the jesters, and took it with him to Connaught; and as often as he went to battle or contend against the Ultonians he was wont to have the brain of Meisceadhra at his girdle in the hope of bringing disaster on the Ultonians. For it was foretold that Meisceadhra would avenge himself on the Ultoinans after his death; and he thought it was by means of the brain this prophecy would be fulfilled. Whence Ceat was wont to carry the brain of Meisceadhra about with him in the hope of slaying some one of the nobles of Ulster with it. Now Ceat, accompanied by a large host, went to plunder Ulster, and carried off a large herd of cattle from Feara Rois in Ulster; and he was pursued by a large force of Ultoinans; and the men of Connaught flocked eastward to assist Ceat, and Conchubhar went westward to help the Ultonians. And when Ceat heard that Conchubhar was in pursuit, he sent word to the women of *Connaught* who were on a hill watching the two hosts asking them to entice Conchubhar to visit them, as he was a jovial, affable man, for the Ultonians would not permit him to take part in the battle against the men of Connaught.


Now when Conchubhar heard that the women wished to see him, he set out alone from the height on which he was to visit them; while Ceat, on the other hand, went secretly and got into the midst of the women waiting in readiness to kill Conchubhar. When, therefore, Conchubhar was approaching the women, Ceat arose and arranged the brain of Meisceadhra in his sling to slay Conchubhar. But when


---

p.203




the latter saw Ceat he retreated to the midst of his own people; and as he was proceeding to Doire Da Bhaoth, Ceat hurled the brain of Meisceadhra after him from his sling, and struck him on the crown; and his brain-pan was broken by that cast, and the brain of Meisceadhra clung to his skull; and thereupon his followers came up to protect him against Ceat. They then sent for Finghin Faithliaigh; and when he arrived, he said that if that ball were extracted from his head he would instantly die. ‘We had rather,’ said they all, ‘that our king should have a blemish than that he should die.’ Finghin cured him, and then told him not to get into a passion, to avoid sexual intercourse, to avoid riding on horseback, to abstain from violent exertion—otherwise, that by the repelling motion of his own brain, he would hurl the ball from his head and die.


He was seven years in this state up to the Friday on which Christ was crucified, according to some seanchas. And when he saw the unwonted transformation of the elements and the darkening of the sun with the moon full, he inquired of Bacrach, a Leinster druid who was with him, what was the cause of that unwonted change in the luminaries of heaven and earth. ‘It is that Jesus Christ the Son of God is being put to death now by the Jews,’ replied the druid. ‘That is a pity,’ said Conchubhar; ‘and if I were present, I would slay all that are around my King putting Him to death.’ And with that he drew forth his sword, and went into an oak-wood hard by, and set to cutting and felling it, saying that, if he were amongst the Jews, he would treat them in the same way; and through the strength of the fury that seized him the ball bounded from his head, and a portion of his brain followed it, and with that he died. Coill Lamhruidhe in Feara Rois is the name of that wood-thicket.


After Conchubhar's death, the kingdom of Ulster was offered to whoever should carry his body to Eamhain without resting. A servant of Conchubnar's named Ceann Bearroide


---

p.205




was present, and in the hope of obtaining the kingdom, took up the body stoutly and carried it to Ardachadh, in Sliabh Fuaid, but there his heart broke and he died. And this event has given rise to the saw which says that one seeks the kingdom of Ceann Bearroide when one aspires ambitiously to a rank which it is beyond his power to attain.


But though authors relate this story of Conchubhar, alleging that he was a contemporary of Christ, still, according to the truth of history, Christ was not born for a long time after Conchubhar; and the truth of this story is that Bacrach, a Leinster druid, foretold through prophecy that Christ the Prophesied One, the Son of God, would be conceived, that He would assume a body, and that the Jews would put Him to death; and through Him the human race would be delivered from the tyranny of the evil one. And when Conchubhar heard this, he became enraged as we have said; and through sympathy with Christ, he set to cut down the wood of Lamhruidhe as if the trees were the Jews; and he died of that effort. And if anyone should deem it strange that Bacrach or any other druid, being Pagan, should foretell the death of Christ, how was it more fitting for the Sybils, who were Pagans, to have foretold Christ before His birth than for Bacrach or any of his kind? Hence the story is not to be thus discredited.


XXXIV.
------


#### Of the death of Ceat son of Magha, as follows.


This Ceat was a valiant man and during his life he was an enemy and constant plunderer of the Ultonians. On a certain day this Ceat proceeded to Ulster to wreak vengeance as was his wont; and there was heavy snow at that time; and as he was returning with the heads of three warriors whom he had slain on that expedition, Conall Cearnach pursued him and seized him at Ath Ceit. They fought; and Ceat fell in the conflict; and Conall was severely wounded, and lapsed into a trance on the spot after he had lost a large quantity of blood. Thereupon Bealchu of Breithfne, a Connaught champion, came to the place of conflict, where he found Ceat dead and Conall on the point of death, and said that it was well these two wolves who had caused the ruin of Ireland were in so sad a plight. ‘That is true,’ said Conall; ‘and in retribution for all the injury I have inflicted on Connaught do thou kill me.’ Now he said this because he would give the kingdom of Ireland that some other warrior should wound him so that a single Connaught warrior should not have the renown of slaying him. ‘I will not slay thee,’ said Bealchu, ‘since the plight thou art in is almost as bad as death. However, I will take thee with me and apply remedies to thee; and if thou recoverest from thy wounds, I will fight thee in single combat, so that I may avenge on thee all the injury and affliction thou hast brought on Connaught.’ Thereupon he placed him in a litter and took him to his own house, and there applied remedies to him, until is wounds were healed.


But when Bealchu saw that Conall was recovering and his natural strength growing in him once more, he became afraid of him, and arranged for three warriors, his own sons, to slay him treacherously in bed by night. But Conall got a hint of


---

p.209




this treacherous conspiracy; and on the night for which it was arranged that the sons should come to commit the murder, Conall said to Bealchu that he must exchange beds with him, else he would kill him. And accordingly Bealchu lay against his will in Conall's bed, and Conall lay in Bealchu's bed. And those three warriors, the sons of Bealchu, came to the bed in which Conall used to be and slew their father in mistake for Conall. Now when Conall observed that they had slain their father in mistake for himself, he sprang upon them and killed all three, and beheaded them and their father; and on the following day he took their heads to Eamhain in triumph, and in commemoration of this deed is the following quatrain from the seanchus:


> 1. Among the feats of Conall Cearnach
>   
> Was the sack of Manainn, the spoiling of slaves,
>   
> And the slaying of the three sons of Bealchu of Breithfne,
>   
> After he had slain Lughaidh son of three hounds.
> 



So far the murder of Ceat son of Magha and of Bealchu of Breithfne and his three sons. And there are many great deeds besides this that might be laid to the credit of Conall which we shall leave untold on this occasion.


#### Of the event which led to the death of Fearghus son of Rogh, as follows.


When Fearghus was in banishment in Connaught, it happened that he was with Oilill and Meadhbh in Magh Ai, where they had a dwelling-fortress; and one day, when they went out to the shore of a lake that was near the lios, Oilill asked Fearghus to go and swim in the lake, and Fearghus did so. Now while Fearghus was swimming, Meadhbh was seized by a desire of swimming with him; and when she had gone into the lake with Fearghus, Oilill grew jealous; and he ordered a kinsman of his called Lughaidh Dalleigheas who was with him to cast a spear at Fearghus


---

p.211




which pierced him through the breast; and Fearghus came ashore on account of the wound caused by that cast, and extracted the spear from his body, and cast it in the direction of Oilill; and it pierced a greyhound that was near his chariot, and thereupon Fearghus fell and died, and was buried on the shore of the same lake. It was this Fearghus who slew Fiachna son of Conchubhar, and the champion Geirrgheann son of Mollaidh, and Eoghan son of Durrthacht, king of Fearnmhuighe, and many heroes and warriors besides whom we shall not mention here. It was he also who carried off the great spoil from Ulster which caused much mischief and discord between Connaughtmen and Ulstermen, so that the dubhloingeas that went with Fearghus into exile from Ulster remained seven years in Connaught, or according to others ten years, spoiling and plundering Ulster on account of the death of the sons of Uisneach, while the Ulstermen were in the same way making an onslaught on them and on the men of Connaught on account of the spoil that Fearghus took from them, as well as every other injury which the dubhloingeas—: that is, the exile host who went with Fearghus to Connaught—and the men of Connaught themselves had done them; so that the injury and damage they inflicted on one another were so great that books have been written about them which it would be tedious to mention, and would take too long to describe here.


#### The cause which led to the death of Laoghaire Buadhach, as follows.


Conchubhar had a poet called Aodh son of Ainneann, who carried on an intrigue with Maghain, Conchubhar's wife; and when Conchubhar discovered this, the judgment he passed on the poet was that he be drowned in Loch Laoghaire; and at the king's command a company went with him to drown him. And when Laoghaire Buadhach's steward saw this, he went to Laoghaire and said that there was no place in Ireland where the poet could be drowned but at his own door. 


---

p.213




Thereupon Laoghaire leaped out, and his poll struck against the upper door-post of the house, and his skull was broken; after this he made a sudden onslaught on the company, and slew them, and rescued the poet; and he himself died on the spot. Such was the end of Laoghaire Buadhach.


XXXV.
-----


#### The cause of the death of Meadhbh of Cruachain, as follows.


When Oilill had been slain by Conall Cearnach, Meadhbh went to Inis Clothrann on Lough Ribh to live; and while she resided there, she was under an obligation to bathe every morning in the well which was at the entrance to the island. And when Forbuidhe son of Conchubhar heard this, he visited the well one day alone, and with a line measured from the brink of the well to the other side of the lake, and took the measure with him to Ulster, and practised thus: he inserted two poles in the ground, and tied an end of the line to each pole, and placed an apple on one of the poles, and stood himself at the other pole, and kept constantly firing from his sling at the apple that was on the top of the pole till he struck it. This exercise he practised until he had grown so dexterous that he would miss no aim at the apple. Soon after this there was a meeting of the people of Ulster and Connaught at both sides of the Shannon at Inis Clothrann; and Forbuidhe came there from the east with the Ulster gathering. And one morning while he was there, he saw Meadhbh bathing, as was her wont, in the fore-mentioned well; and with that he fixed a stone in his sling and hurled it at her, and struck her in the forehead, so that she died on the spot, having been ninety-eight years on the throne of Connaught, as we have said above.


Thus far we have digressed into accounts of the heroes who were contemporaries of Meadhbh. We shall now return


---

p.215




to Eochaidh Feidhlioch. Now, Eochaidh had three sons and three daughters, namely, Breas and Nar and Lothar, the three sons, and Eithne Uathach, Clothra, and Meadhbh Cruachan, the three daughters, as the poet says in this quatrain:


> 1. Three daughters had Eochaidh Feidhlioch,
>   
> Fame on a lofty seat:
>   
> Eithne Uathach, fair Meadhbh of Cruachain,
>   
> And Clothra.
> 




We shall come back again to Conchubhar, and set down here part of his story. His mother was the daughter of Eochaidh Salbhuidhe of Connaught, who was called Neasa, and he was named from her. And his father was Fachtna Fathach son of Cas, son of Rudhruighe of the race of Ir son of Milidh; and when the provincial kings were demanding to have the boundaries of each separate province fixed, Cairbre Nia Fear, king of Leinster, in consideration of getting Conchubhar's daughter in marriage, ceded to Ulster the tract of land that extends from Loch an Chuighidh in Breagh and from Tara to the sea; and this tract consists of three cantons, as the poet says:


> 1. In the division of Erin into fifths,
>   
> Between two seas, great the permission,
>   
> Three cantons with his portion
>   
> Took Conchubhar, no small, narrow tract.
> 



The lady through whom he gained this increase was named Feidhlim Nuachrothach; and through force of passion she eloped with Conall Cearnach from the king of Leinster.


As to Conchubhar he had twenty-one sons; and in a fit of drunkenness he committed incest with his own mother, and she bore him Cormac Conluingeas. Now, Cormac is the same as Corbmac, an incestuous son; for it was through corbadh or incest that Cormac was the offspring of Conchubhar by his own mother, whose name was Neasa. And in punishment of this misdeed all his sons died without issue except three,


---

p.217




namely, Beanna, from whom Beanntraighe is named; Lanna, from whom Lannraidhe is named; and Glaisne, from whom Glasraidhe is named. But there is no one to-day in Ireland descended from these.


It was this Conchubhar son, of Fachtna Fathach and his kinsmen that fought the Battle of Aonach Macha against Dabhall Dianbhuilleach son of the monarch of Lochloinn. An innumerable host accompanied the son of the king of Lochlainn on that occasion on an expedinon to invade Ireland. It was in the province of Ulster they landed, and after that they proceeded to Magh Macha. The clan Rudhruighe rallied round Conchubhar against the foreigners, and gave them battle. Then Geanann Gruadhsholus son of Cathbhadh said to his followers: ‘Your host is small, O men of Ulster,’ he said, ‘and ye are all young and beardless. What shall we do, then?’ said they all. ‘Well,’ said Geanann, ‘bring with you a large quantity of grey wool, and bind fast the wool to your faces, so that the foreigners may hate and fear you all the more for this, as if you were chosen warriors.’ All those who were amhulchach, that is, those who had not beards, followed the advice of Geanann. The battle was afterwards fought, and the foreigners were defeated, and they were slaughtered there; and it was from this Battle of Aonach Macha that they were called Ulaidh or Ulstermen.


#### The death of Conlach son of Cuchulainn, as follows.


It was thus his death was brought about: Cuchulainn went to learn feats of valour to Scathach, a female champion that lived in Alba; and there was a fair lady in Scotland at that time called Aoife daughter of Airdgheim, who cherished a longing affection for Cuchulainn because of his great fame; and she came to visit him; and they had intercourse with one another, and she conceived a son. Now, when Cuchulainn proceeding to Ireland after having learned the feats of agility from Scathach, he paid a farewell


---

p.219




visit to Aoife, and gave her an ornasc, that is, a chain of gold, and told her to keep it till her son should be fit for service; and when he would be fit for service, to send the chain with him to himself, as a sure token by which to know him; or, according to others, it was a gold ring, and he told her to send his son to visit him to Ireland as soon as he should be so strong that his finger would fill the ring. Furthermore he imposed three restrictions on the son before his coming to Ireland. The first restriction was that he should not give way to any hero or champion in the world; the second restriction that he should not give his name through fear to any warrior in the world; the third restriction that he should not refuse single combat to any man on earth, however strong. Now, when this youth grew up and waxed strong, and when he had learned exercises of valour and championship from Scathach, the instructress of champions, he set out for Ireland to visit Cuchulainn, his father; and when the youth reached land, Conchubhar and the nobles of Ulster were before him Tracht Eise; and Conchubhar sent a champion called Cuinnire to get an account of himself from him; and when he came into the youth's presence, he asked his name. ‘I tell my name to no warrior on earth,’ said Conlaoch. Then Cuinnire went back to Conchubhar, and made known to him this answer. Thereupon Cuchulainn went to get an account from him, but received only the same answer from Conlaoch; and they engaged in a bloody encounter, and Conlaoch was overpowering Cuchulainn, great as had been his valour and strength in every battle up to that time, so that he was forced to go to the nearest ford and direct Laogh son of Rian Gabhra to get ready the ga bolg for him, which he sent through Conlaoch's body; and it was thus he died.




---

p.221


XXXVI.
------


Know, O reader, that if I were to relate here how Cuchulainn fell by the sons of Cailitin, and Fear Diadh son of Damhan by Cuchulainn, and the death of the seven Maines sons of Oilill Mor and of Meadhbh, and of many other stout heroes who are not mentioned here, a long narrative would be needed concerning them. But if thou wishest to get a lengthy account of them, read Brisleach Mhuighe Muirtheimhne; Oidhidh na gCuradh; or Tain Bo Cuailgne; or Tain Bo Reaghamain; or Deargruathar Chonaill Cheamaigh; or Feis Eamhnan; or Tain Bo Fliodhais; or similar tales which are now to be seen in Ireland; and thou shalt find therein a copious account of the above-mentioned persons and of many other champions and warriors of their history and adventures.


Nevertheless I think I should not omit mention of Curaoi son of Daire here but should set down the cause of his as he was a valiant man, and a contemporary of Conchubhar and of the heroes. Morann Mhanannach was mother of Curaoi son of Daire, as the poet says in this quatrain:


> 1. Morann Mhanannach of honour pure,
>   
> Daughter of Ir son of Uinnseach,
>   
> Sister of Eochaidh Eachbheoil was she,
>   
> Mother of Curaoi son of Daire.
> 




There were three orders of champions in Ireland at the same time; and there lived neither before their time nor ever since a body of the sons of Milidh who were bigger, stronger, braver, more skilled, more intrepid on the field of battle, and in exercises of valour and bravery than they; for the Fian of Leinster were not to be compared with them. The first order of these were the champions of the Craobh Ruadh under Conchubhar; the second order the Gamhanruidh of Iorras Domhnonn under Oilill Fionn; and the third order


---

p.223




clanna Deaghaidh under Curaoi son of Daire in west Munster.


It was thus that the death of Curaoi came about. The champions of the Craobh Ruadh went *on an expedition* to pillage an island in the ocean near Alba called Manainn, where where was much gold and silver and wealth of various kinds, and many precious valuables besides; and the lord of the island had a comely, marriageable daughter who surpased the women of her time in form and beauty. Her name was Blanaid. And when Curaoi heard that the champions were setting out on that expedition, he put on a disguise by magic, and went with the party; and when they were about to plunder the island in the guise of jugglers they apprehended great difficulty in seizing on the dun which was in the island in which was Blanaid, and all the precious valuables of the island, both on account of its strength and of the great skill in magic of those who were defending it. Then Curaoi, who was disguised as a man with a grey cloak, said that if he got his choice of the valuables in the dun he would capture it for them. Cuchulainn promised him this; and thereupon they attacked the dun with the man in the grey cloak at their head. He stopped the magic wheel that was in motion at the door of the fortress, and enabled all to enter; and they plundered the dun, and took from it Blanaid and all the precious valuables it contained. They thence set out for Ireland and reached Eamhain, and as they were dividing the valuables, the man in the grey cloak asked for the valuable he should choose as was promise to him. ‘Thou shalt have it,’ said Cuchulainn. ‘Well, then,’ said he, ‘Blanaid is my choice of the valuables.’ ‘Thou mayst have thy choice of the other valuables excepting only Blanaid.’ ‘I will not accept any but her,’ said the man of the grey coat. Thereupon Curaoi sought an opportunity of carring off Blanaid, and, seizing her unperceived, he bore her off in an enchanted mask. When Cuchulainn noticed that the lady was missing, he concluded that it was


---

p.225




Curaoi who carried her off, and he pursued them by direct route to Munster, and overtook them at Solchoid; and the champions grappled with one another and engaged in strong, valorous wrestling and Cuchulainn was brought to the ground by Curaoi, who inflicted on him the binding of the five smalls, and left him there a bound captive, having cut off his hair with his sword; and, leaving Cuchulainn bound as we have said, he took Blanaid with him to west Munster. But after this Laogh son of Rian of Gabhra came and unbound Cuchulainn; and they proceeded thence to the north of Ulster, and settled down beside Beanna Boirche for a year without coming to a meeting of the men of Ulster until Cuchulainn's hair grew and at the end of that year Chuchulainn happened to be on Beanna Boirche and he saw a large flock of black birds coming southwards from the surface of the ocean; and when they reached land he pursued them, and slew with his sling, by the exercise called taithbheim or ‘return-stroke’, a bird out of each country, till he killed the last black bird of them at Sruibh Broin in west Munster; and as he was returning eastwards, he found Blanaid alone beside Fionnghlaise in Ciarraidhe, where Curaoi's dwelling-fortress stood, at that time. A conversation then took place between them, and she made known to him that there was not on the face of the earth a man loved more than him, and asked him to come on the following Samhain with a full host and carry her off by fraud or force, and that he might the more easily do this, she would bring about that Curaoi should at that time have but few warriors and attendants. Cuchulainn promised to come to fetch her at that time. Thereupon he bade her farewell, and proceeded to Ulster, and gave Conchubhar an account of the incident.


As to Blanaid, she told Curaoi that he ought to build a stone fortress for himself which would excel all the royal fortresses of Ireland, and that the way in which that could be done was to send the clanna Deaghaidh to collect and bring together all the large stones that were standing in Ireland for 


---

p.227




the purpose of making a stone fortress for himself. And Blanaid's object in this was that clanna Deaghaidh might be scattered through the distant regions of Ireland far from Curaoi when Cuchulainn should come to carry her off. Now when Cuchulainn heard that clanna Deaghaidh were thus dispersed throughout Ireland, he set out secretly from Ulster with an army, and no tidings are recorded of him till he reached the oak wood that lay beside Curaoi's fortress; and when he arrived there, he sent word privately to Blanaid that he was there with army; and the sign she sent him was that she would steal Curaoi's sword and thereupon pour a vat of new milk that was in the lios into the stream which was flowing from the homestead through the wood in which Cuchulainn was. Not long after he was informed of this token he saw the stream become white from the milk, and with that they attacked the fortress and sprang upon Curaoi in the lios and slew him alone and unarmed as he was. And the river referred to was called Fionnghlaise, through its having become white from the milk.


Curaoi's poet, who was called Feircheirtne, went after Blanaid to Ulster in the hope of getting an opportunity of slaying her to avenge Curaoi; and on reaching Ulster he found Conchubhar and Cuchulainn and Blanaid, with a large assembly round them, at Ceann Beara point; and when the poet saw Blanaid standing there on the brink of a precipice, he went towards, her and twined his arms round her and cast himself and herself suddenly down the precipice, and thus they were both killed.




---

p.229


XXXVII.
-------


Eochaidh Airiomh son of Fionn, son of Fionnlogha, son of Roighnen Ruadh, son of Easamhan Eamhna, son of Blathacht, son of Labhraidh Lorc, son of Eanna Aighneach, son of Aonghus Tuirbheach Teamhrach, son of Eochaidh Foiltleathan, son of Oilill Caisfhiaclach, son of Connla Cruaidhchealgach, son of Iarainnghleo Fathach, son of Meilge Molbthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland twelve years. He was called Eochaidh Airiomh because it was he who first dug a cave in Ireland. Now Airiomh is the same as ar uaimhe, that is, ‘the ploughing or digging of a cave’; and finally this Eochaidh fell by Siodhmall in Freamhainn Teathbha.


Eidirsceol son of Eoghan, son of Oilill, son of Iar, son of Deaghaidh, son of Sin, son of Roisin, son of Triun, son of Roithriun, son of Airndil, son of Maine, son of Forga, son of Fearadhach, son of Oilill Erann, son of Fiachaidh Fear Mara, son of Aonghus Tuirbheach Teamhrach, son of Eochaidh Foiltleathan, son of Oilill Caisfhiaclach, son of Connla Cruaidhchealgach, son of Iarannghleo Fathach, son of Meilge Molbhthach, son of Cobhthach Caol mBreagh, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland six years, and he fell by Nuadha Neacht in Aillinn.


Nuadha Neacht son of Seadna Siothbhac, son of Lughaidh Loithfhionn, son of Breasal Breac, son of Fiachaidh Foibhric, son of Oilill Glas, son of Fearadhach Foghlas, son of Nuada Fullon, son of Ealloit, son of Art, son of Mogh Art, son of Criomhthann Coscrach, son of Fearadhach Fionn, son of Feilimidh Foirthriun, son of Fearghus Fortamhail, son of Breasal Breoghaman, son of Aonghus Ollamh, son of Oilill Bracan, son of Labhraidh Loingseach, son of Oilill Aine, son of Laoghaire Lorc, son of Ughaine Mor of the


---

p.231




race of Eireamhon, held the sovereignty of Ireland half a year. He was called Nuadha Neacht, from the word nix, that is, 'snow'; for the whiteness of his skin was likened to snow. And this Nuadha fell by Conaire Mor son of Eidirsceol.


Conaire Mor son of Eidirsceol, son of Eoghan, son of Oilill, son of Iar, son of Deaghaidh, son of Sin, son of Roisin, son of Triun, son of Roithriun, son of Airndil, son of Maine, son of Forga, son of Fearadhach, son of Oilill Erann, son of Fiachaidh Fear Mara, son of Aonghus Tuirbheach Teamhrach of the race of Eireamhon, held the sovereignty of Ireland thirty years, or, according to others, seventy years.


This Conaire Mor was the first who exacted from the Leinstermen the eiric of his father, Eidirsceol. The following exacted the same eiric from the Leinstermen, namely, Oilill Olom, Eoghan son of Oilill, Fiachaidh Muilleathan, Oilill Flann Beag, Lughaidh son of Oilill Flann Beag, and Corc son of Lughaidh. The amount of this eiric was three hundred white cows, three hundred mantles, three hundred hogs, and three hundred golden swords; and they joined Osruighe with Munster, that is, from Gabhran to Grian Airbh beside Moin Eile; and they gave all the elements as guarantee that they would pay that eiric for ever, as the seancha says in this stanza:


> 1. Osruighe from Gabhran to Grian
>   
> Was joined, on account of Eidirsceol's eiric,
>   
> With Munster, select her choice,
>   
> It was Conaire who made the agreement.
> 



Understand, O reader, that the Earna of Munster, and the Dal Riada of Alba, are descendants of this Conaire, and that it was in the time of Duach Dallta Deaghaidh that the Earna came to Munster; and according to Cormac, in his Psalter, it was the clanna Rudhruighe who banished them to Munster after they had defeated them in eight battles; and they acquired great power in Munster after that from the time of Duach Dallta Deaghaidh to the time of Mogh Nuadhat; so that, according to the Book of Munster, they drove the race of 


---

p.233




Eibhear back to the territory of Ui Rathach to the borders and the islands of west Munster, having acquired the sovereignty of the region for themselves, which they held up to the time of Mogh Nuadhat, by whom they were expelled; and finally this Conaire Mor fell in Bruighean Da Bhearg by Aingceal Caoch son of the king of Britain.


Lughaidh Riabh nDearg son of the three Finneamhas son of Eochaidh Feidhlioch, son of Fionn, son of Fionnlogha, son of Roighnen Ruadh, son of Easamhan Eamhna, son of Blathacht, son of Labhraidh Lorc, son of Eanna Aighneach, son of Aonghus. Tuirbheach Teamhrach of the race of Eireamhon, held the sovereignty of Ireland twenty years, or, according to others, twenty-six years. Dearbhorgaill daughter of Fargall, king of Lochloinn, was wife of Lughaidh Riabh nDearg. He was called Lughaidh Riabh nDearg because there was a red circle round his neck, and another circle round his waist; for he was the offspring, in their drunkenness, of the three Fionns by their sister who was called Clothra daughter of Eochaidh Feidhlioch; and as a setting forth of this deed is the following historical stanza from which it will be understood that it was this Clothra who bore Lughaidh Riabh nDearg to her brothers that also bore Criomhthann Nia Nar to this same Lughaidh who was her own son. Here is the stanza:


> 1. Lughaidh Riabh nDearg to fair Criomhthann
>   
> Was father and was brother;
>   
> And Clothra of the comely form
>   
> Was grandmother to her son.
> 



At that time it was believed that what was above the upper circle of Lughaidh Riabh nDearg resembled the one of the youths who was called Nar, and that what was between the two circles resembled Breas, and that what was below the waist resembled Lotar. This Lughaidh died by falling on his sword, which cut him through.


Conchubhar Abhradhruadh son of Fionn File, son of Rossa Ruadh, son of Fearghus


---

p.235




Fairrge, son of Nuadha Neacht, son of Seadna Siothbhac, son of Lughaidh Loithfhionn, son of Breasal Breac, son of Fiachaidh Foibhric, son of Oilill Glas, son of Fearadhach Foghlas, son of Nuadha Fullon, son of Ealloit, son of Art, son of Mogh Airt, son of Criomhthann Coscrach, son of Feilimidh Foirthriun, son of Fearghus Fortamhail, son of Breasal Breoghaman, son of Aonghus Ollamh, son of Oilill Bracan, son of Labhraidh Loingseach, son of Oilill Aine, son of Laoghaire Lorc, son of Ughaine Mor of the race of Eireamhon, held the sovereignty of Ireland one year. And he was called Conchubhar Abhradhruadh because he had red eyelashes; and in the end he fell by Criomhthann Nia Nar.


XXXVIII.
--------


Criomhthann Nia Nar son of Lughaidh Riabh nDearg, son of the three Finneamhnas, son of Eochaidh Feidhlioch, son of Fionn, son of Fionnlogha, son of Roighnen Ruadh, son of Easamhan Eamhna, son of Blathacht, son of Laoghaire Lorc, son of Eanna Aighneach, son of Aonghus Tuirbheach Teamhrach of the race of Eireamhon, held the sovereignty of Ireland sixteen years. He was called Criomhthann Nia Nar, for nia is the same as 'champion' or 'brave man'; and he was called Nar, 'ashamed', for he felt ashamed of being the offspring of his brother and mother. It was in the twelfth year of the reign of Criomhthann Nia Nar that Christ was born. This Criomhthann met his death by a fall from his horse, soon after which he expired.


Fearadhach Fionn Feachtnach son of Criomhthann Nia Nar, son of Lughaidh Riabh nDearg, son of the three Finneamhnas, son of Eochaidh Feidhlioch of the race of Eireamhon, heid the sovereignty of Ireland twenty years. Nar Tuathchuach daughter of Loch son of Daire of Cruitheantuaith was the mother of Fearadhach Feachtnach. He was


---

p.237




called Fearadhach Feachtnach because justice and truth maintained in Ireland in his time. For feachtnach means 'truthful'. It was in his reign that Morann son of Maon lived, the just judge who possessed the Morann collar; and one of the virtues of this collar was that whoever wore it round his neck while delivering an unjust judgment the collar would close in tightly on his neck till he delivered a just judgment. It behaved similarly as regards one who came to give false testimony until he had confessed the truth. From this collar comes the old saw that is, when one orders that Morann's collar be round the neck of one giving evidence so that he might tell the truth and Fearadhach Feachtnach died in Liath Druim.


Fiatach Fionn, a quo the Dal bhFiatach, son of Daire, son of Dluthach, son of Deitsin, son of Eochaidh, son of Sin, son of Roisin, son of Triun, son of Roithriun, son of Airndil, son of Maine, son of Forga, son of Fearadhach, son of Oilill Earann, son of Fiachaidh Fear Mara, son of Aonghus Tuirbheach Teamhrach of the race of Eireamhon, held the sovereignty of Ireland three years; and he fell by Fiachaidh Fionnoladh.


Fiachaidh Fionnoladh son of Fearadhach Fionn Feachtnach, son of Criomhthann Nia Nar, son of Lughaidh Riabh nDearg, son of the three Finneamhnas, son of Eochaidh Feidhlioch of the race of Eireamhon, held the sovereignty of Ireland twenty-seven years. He is called Fiachaidh Fionnoladh, for oladh is a name for a cow, and most of the cows of Ireland were white (fionn) in his time; hence he was called Fiachaidh Fionnoladh. Know that, according to Stowe's Chronicle, there were Scots residing in Aiba in the year of the Lord 73, very soon after Fiachaidh Fionnoladh held the sovereignty of Ireland, and that was before Cairbre Riada lived. And this Fiachaidh was treacherously slain by the rustic tribes of Ireland.


Cairbre Chinn Chait son of Dubhthach, son of Rudhruighe, son of Diochun


---

p.239




Uairiodhnach, son of Tat Teadhmannach, son of Luaighne Laidhcinn, son of Oiris Eachlonnach, son of Earndolbh, son of Rionnal Dagharmagh, son of the king of Lochloinn, who came with Labhraidh Loingseach to the fortress of Tuaim Teannbhaoth, and others say that he was of the Fir Bolg, assumed the sovereignty of Ireland; he reigned five years, and died of the plague. And he was called Cairbre Chinn Chait because his ears were like the ears of a cat, as the poet says in this stanza:


> 1. Thus was Cairbre the hardy,
>   
> Who ruled Ireland south and north:
>   
> Two cat's ears on his fair head,
>   
> Cats fur upon his ears.
> 



Cairbre obtained the sovereignty of Ireland in this manner. The serfs or rustic tribes of all Ireland devised a treacherous plot against the king and the nobles of the country; and they resolved to carry out this plot by getting ready a feast to be given to the kings and the nobles of Ireland; and the place in which that feast was given was Magh Cru in Connaught; and they were three years preparing it, and during that time they set apart a third of their crops with a view to the feast; and the free tribes of Ireland came to partake of it; and with them came three kings, namely, Fiachaidh Fionnoladh, king of Ireland, whose wife was Eithne daughter of the king of Alba; Feig son of Fidheic Caoch, king of Munster, whose wife was Beartha daughter of Goirtniad, king of Britain; Breasal son of Firb, king of Ulster, whose wife was the daughter of the king of Sacsa; her name was Aine, and her father's name was Cainneall. The rustic tribes had three chiefs, namely, Monach, Buan, and Cairbre Caitcheann; and this Cairbre was chief of them all. They had been partaking of the feast for nine days when at length the rustic tribes sprang upon the free tribes of Ireland and slew them, so that they all fell by them on the spot, except the three unborn children who were in the wombs of the 


---

p.241




three wives of the three kings we have mentioned. Now the women fled to Alba, and there gave birth to three sons, namely, Tuathal Teachtmhar, Tiobraide Tireach, and Corb Olom. As to Ireland great famine and failure of crops and much adversity came upon that country. And this continued to be her lot till the three sons of the three kings they had treacherously slain were able to bear arms. And when the men of Ireland heard that the three sons of these kings were living, they sent envoys to them asking them to assume the sovereignty which their ancestors had held before them; and they gave the sun and moon as surety or guarantee that they would yield them obedience and be faithful to them evermore. Upon this the youths came, and accepted the inheritance of their fathers; and this brought back again her usual prosperity to Ireland. And Cairbre Chinn Chait died of the plague.


Eilim son of Connra, son of Rossa Ruadh, son of Rudhruighe, son of Sithrighe, son of Dubh, son of Fomhor, son of Airgeadmhar, son of Siorlamh, son of Fionn, son of Bratha, son of Labhraidh, son of Cairbre, son of Ollamh Fodla of the race of Ir son of Milidh, held the sovereignty of Ireland twenty years; and he fell by Tuathal Teachtmhar in the Battle of Aichill.




---

p.243


XXXIX.
------


Tuathal Teachtmhar son of Fiachaidh Fionnoladh, son of Fearadhach Fionn Feachtnach, son of Criomhthann Nia Nar, son of Lughaidh Riabh nDearg, son of the three Finneamhnas, son of Eochaidh Feidhlioch of the race of Eireamhon, held the sovereignty of Ireland thirty years. He was called Tuathal Teachtmhar, as every good came in his time. Now Fiachaidh Fionnoladh left no issue but one son, who was called Tuathal Teachtmhar; and that son was in the womb of Eithne daughter of the king of Alba, who escaped by flight from the destruction of Magh Cru in Connaught, when the Athachthuaith slew Fiachaidh Fionnoladh and the free tribes of Ireland. And after the birth of Tuathal in Alba he was brought up and educated in politeness there till he had reached the age of twenty-five years; and during that time Ireland had been in adversity; and the Athachthuaith being in a great difficulty went and consulted their druids as to the cause and origin of the adversity in which Ireland was at that time, and as to the way in which she might be freed from it. The druids replied that the cause of her adversity was that they had acted treacherously towards the kings and the free tribes of Ireland, and added that her wonted prosperity would not come back to Ireland until some one of the descendants of those kings who were slain assumed the sovereignty of the country. And it was about this time that the Athachthuaith heard that there was in Scotland a son of Fiachaidh Fionnoladh, whose name was Tuathal Teachtmhar; and a large party of the Athachthuaith took counsel together, and they agreed to send envoys to Tuathal to Alba. There were also companies of the remnant of the free races of Ireland, namely, clann an Duinn Deasa of Leinster, Fiachaidh Casan and Fionnbhall his brother, and six hundred pirates with them, devastating Ireland to avenge the treachery


---

p.245




of the Athachthuaith towards the kings and free tribes of Ireland.


When Tuathal Teachtmhar heard these tidings, he set out for Ireland with his mother, Eithne daughter of the king of Alba, accompanied by a large host. Tuathal was twenty-five years of age at that time. And they put into port at Iorrus Domhnann, where they met Fiachaidh Casan with his brother. Thence they proceeded to Tara, and there assembled their supporters from all parts of Ireland to meet Tuathal, and they proclaimed him king of Ireland. Eilim son of Connra, who at that time held the sovereignty of Ireland, having been elected by the Athachthuaith after the death of Cairbre Chinn Chait, came and fought the Battle of Aichill against Tuathal. In that battle Eilim and the Athachthuaith were defeated, and himself and the greater part of his army slain. Then Tuathal and his supporters went against the Athachthuaith throughout Ireland, and defeated them in twenty-five battles in Ulster, and twenty-five battles in Leinster, and twenty-five battles in Connaught, and thirty-five battles in Munster.


When Tuathal had won these battles, and rescued the free races of Ireland from the tyranny of the Athachthuaith, he convened the **Feis of Tara**; as it is customary for every king in the beginning of his reign to convene and bring together a great general assembly to regulate the laws and customs of the country. Then the nobles of the Gael from every province in Ireland came to him, and accepted him as their king, as he had delivered them from the slavery of the serfs and the Athachthuaith; and they pledged themselves by the elements, that they would leave the sovereignty of Ireland to himself, and to his children, as had formerly been promised to Ughaine Mor.


It was then, too, that he was given four portions of the provinces, out of which he made the present Meath, as the peculiar territory of the successive high kings of Ireland.


---

p.247




For, although Meath was the name of the territory which is beside Uisneach from the time of the children of Neimhidh to the time of Tuathal, still Meath was not the name of the portions that were taken from the provinces until the time of Tuathal, and he made it into a territory distinct from the provinces.


Now, when Tuathal had put these four parts together and made them into one territory called Meath, he built therein four chief fortresses, that is, a fortress in each of the portions. Accordingly he built Tlachtgha in the portion of Munster which goes with Meath; and it was there the Fire of Tlachtgha was instituted, at which it was their custom to assemble and bring together the druids of Ireland on the eve of Samhain to offer sacrifice to all the gods. It was at that fire they used to burn their victims; and it was of obligation under penalty of fine to quench the fires of Ireland on that night, and the men of Ireland were forbidden to kindle fires except from that fire; and for each fire that was kindled from it in Ireland the king of Munster received a tax of a screaball, or three-pence, since the land on which Tlachtgha is belongs to the part of Munster given to Meath.


On the portion he had acquired from the province of Connaught he built the second fortress, namely Uisneach, where a general meeting of the men of Ireland used to be held, which was called the Convention of Uisneach, and it was at Bealltaine that this fair took place, at which it was their custom to exchange with one another their goods, their wares, and their valuables. They also used to offer sacrifice to the chief god they adored, who was called Beil; and it was their wont to light two fires in honour of Beil in every district in Ireland, and to drive a weakling of each species of cattle that were in the district between the two fires as a preservative to shield them from all diseases during that year; and it is from that fire that was made in honour of Beil that the name of Bealltaine is given to the noble


---

p.249




festival on which falls the day of the two Apostles, namely, Philip and James; Bealltaine, that is Beilteine, or the fire of Beil. The horse and the trappings of every chieftain who came to the great meeting of Uisneach were to be given as a tax to the king of Connaught, as the place in which Uisneach is belongs to the part of the province of Connaught given to Meath.


The third fortress which Tuathal built, called Taillte, is in the portion of the province of Ulster joined to Meath; and it was here the fair of Taillte was held, in which the men of Ireland were wont to form alliances of marriage and friendship with one another. And a most becoming custom was observed in that assembly, namely, the men kept apart by themselves on one side, and the women apart by themselves on the other side, while their fathers and mothers were making the contract between them; and every couple who entered into treaty and contract with one another were married, as the poet says:


> 1. The men must not approach the women,
>   
> Nor the women approach the fair bright men,
>   
> But every one modestly biding apart
>   
> In the dwelling of the great fair.
> 



Although it was Lughaidh Lamhfhada that first instituted the fair of Taillte as a yearly commemoration of his own foster-mother, Taillte daughter of Maghmor, king of Spain, who was the wife of Eochaidh son of Earc, the last king of the Fir Bolg, as we have said above—now when Taillte had been buried by Lughaidh in that mound he inaugurated the fair of Taillte as a nasadh or commemoration of her; it was for that reason that the name of Lughnasa, that is the *gracious nasadh* or commemoration, was given to the first day of August, on which is now held the feast of the Chains of Peter—although the mound and fair of Taillte existed from the time of Lughaidh Lamhfhada, still Taillte was not a royal fortress till the time of Tuathal Teachtmhar. Now


---

p.251




since the place in which Taillte is belongs to the part that was taken from the province of Ulster, the tax on the fair of Taillte went to the king of Ulster. This was the amount of that tax, namely, an ounce of silver for each couple that got married there.


The fourth royal fortress, Tara, is situated in the part of Leinster given to Meath, and there the **Feis of Tara** was held, every third year after the sacrifice had been offered to all the gods at Tlachtgha (as we have said) as a prelude to that royal assembly called the **Feis of Tara**, at which they were wont to institute laws and customs, and to confirm the annals and the records of Ireland, so that the **ardollamhs** might inscribe all that was approved of them in the **Roll of the kings**, which was called the Psalter of Tara; and every custom and record that was in Ireland that did not agree with that chief book were not regarded as genuine. We shall not give here in detail the laws or the customs that were severally ordained at the **Feis of Tara**, for the books of the **Breithemhnas Tuaithe** are full of them. I shall only give here the custom that was instituted at the **Feis of Tara** regarding the placing of the nobles and warriors for meals in the banquet-halls when they met for a feast.


There was indeed no doctor of seanchus in Ireland who did not write in the **Roll of Tara** the names of the nobles who were lords of territories, each according to his rank and title as regulated at the **Feis of Tara**, and every leader of those bands of warriors who had free quartering for the defence and protection of the lands of Ireland, had his name similarly inscribed by the **ollamh**; and there was none of these, either territorial lords or leaders of bands of warriors, who was not accompanied by a shield-bearer. Moreover, the banquet halls they had were narrow and long, with tables along the side-walls. Along each of these side-walls there was placed a beam in which there were numerous hooks above the seats on which the company used to sit, with only the breadth of a


---

p.253




shield between each two of the hooks, and on these hooks the seancha hung the shields of the nobles and of the warriors before they sat down, each under his own shield, both nobles and warriors. But the territorial lords had the choice of a side, and the leaders of warriors had the other side; the upper end of the hall was occupied by the **ollamhs**, and the other end by the attendants who waited on the company.


It was also their custom that no one should sit immediately opposite to another, but that all, both territorial lords and leaders of warriors, should have their backs to the wall and sit each under his own shield. It was their custom also not to have women in the banquet-halls, but they were given a separate apartment in which they were served. It was, moreover, their custom, before the company were served, to clear out or empty the banquet-hall, so that only three remained in it, namely, a seancha, a bollsaire, that is a marshal of the house, and a trumpeter who had a trumpet or horn to call all the guests to the banquet-hall. He sounded his trumpet three times. The first time he sounded it, the shield-bearers of the nobles assembled at the door of the banquet-hall; and the bollsaire took the shield of each noble according to his title, and placed, according to the direction of the seancha, each of the shields in its own appointed place. The trumpeter sounded his trumpet a second time and the shield-bearers of the leaders of warriors assembled at the door of the banquet-hall; and the bollsaire took the shields from them and placed each shield, according to the direction of the seancha, at the other side of the house, over the warrior's table. Then the trumpeter sounded his trumpet the third time; and thereupon the nobles and warriors assembled in the banquet-hall, and each of them sat beneath his own shield, so that there was no contention or disagreement between them as to their seats.




---

p.255


XL.
---


It was this Tuathal Teachtmhar of whom we are speaking who imposed, the Boraimhe on the people of Leinster, as a tax to avenge the death of his two daughters, whose names were Fithir and Dairine. Now, there was a king over Leinster whose name was Eochaidh Aincheann, and he married Dairine, daughter of Tuathal Teachtmhar, and took her to Leinster to his own fortress, that is to Magh Luadhat; and some time after that he went to Tara and told Tuathal thatDairine had died, and asked him to give him his other daughter, that is Fithir, and Tuathal gave her to him, and he took her to Leinster to his own fortress; and when Fithir saw her sister Dairine alive before her, her soul quitted her body suddenly through shame; and Dairine having come to lament her died of her grief on the spot. And it was to relate this that the poet composed the following stanza:


> 1. Fithir and Dairine
>   
> Two daughters of princely Tuathal;
>   
> Fithir died of shame,
>   
> Dairine died of her grief.
> 




Now when Tuathal heard of the death of the two ladies he became enraged, and sent out messengers in all directions to the nobles of Ireland to complain of the treachery which the king of Leinster had practised against him; and accordingly the nobles of Ireland gave aid in warriors and auxiliaries to Tuathal with a view to avenge this outrage; and when Tuathal resolved to plunder and despoil the people of Leinster though they were unable to meet him in the field, they agreed to pay a tribute, themselves, and their descendants to Tuathal, and to each king who should succeed him, as a retribution for the death of these ladies.


The following is the amount of the tribute that was paid every second year by the Leinstermen to the kings of Ireland


---

p.257




as a penalty for the death of the children of Tuathal, namely, three score hundred cows, three score hundred ounces of silver, three score hundred mantles, three score hundred hogs, three score hundred wethers, three score hundred bronze caldrons. And this tribute was thus divided:—a third part of it to the men of Connaught, a third to the Oirghialla, and a third to the Ui Neill. The tract entitled Boraimhe Laighean speaks thus in the following verses:


> 1. Three score hundred kine with spancels,
>   
> Gifts without fault,
>   
> With three score hundred ounces
>   
> Of silver in addition.
> 2. With three score hundred fine mantles
>   
> Of largest measure,
>   
> With three score hundred large hogs
>   
> Of lusty strength,
> 3. With three score hundred wethers,
>   
> Generous gift,
>   
> With three score hundred brazen caldrons
>   
> As a bright ornament.
> 4. A third part to the men of Connaught,
>   
> The ancient law,
>   
> A third part to the Oirghilla,
>   
> A third to the Ui Neill,
> 




This was the tribute called Boraimhe Laighean, and it was in force during the reigns of forty kings who ruled Ireland, that is from the time of Tuathal Teachtmhar to the time that Fionnachta held the sovereignty of Ireland as the poet says in this stanza:


> 1. There were forty kings
>   
> Who carried off the Boromha
>   
> From the time of Tuathal Tlachtgha
>   
> To the time of Fear Fionnachta.
> 




It was Moling who got it remitted by means of the respite until Monday which he got from Fionnachta; but the Monday Moling meant was the Monday of the Day of Judgment. The Leinstermen paid this tribute submissively


---

p.259




at times, but at other times they would not consent to pay it, whence arose much strife and conflict between both parties, in which a great number of the nobles of Ireland fell on either side. And Tuathal Teachtmhar fell by Mall son of Rochruidhe.


Mal son of Rochruidhe, son of Cathbhadh, son of Giallchaidh Fionn, son of Fionnchadh, son of Muireadhach, son of Fiachna Fionnamhnas, son of Irial Glunmhar, son of Conall Cearnach, son of Aimhirgin Iairghiunach, son of Cas Trillseach, son of Cas, son of Fachtna, son of Capa, son of Gionga, son of Rudhruighe Mor from whom clanna Rudhruighe are called, of the race of Ir son of Milidh, held the sovereignty of Ireland four years, and he fell by Feidhlimidh Reachtmhar.


Feidhlimidh Reachtmhar son of Tuathal Teachtmhar, son of Fiachaidh Fionnoladh, son of Fearadhach Fionn Feachtnach, son of Criomhthain Nia Nar, son of Lughaidh Riabh nDearg, son of the three Finneamhnas, sons of Eochaidh Feidhlioch of the race of Eireamhon, held the sovereignty of Ireland nine years. Baine daughter of Scal Balbh, wife of Tuathal Teachtmhar, was the mother of Feidhlimidh Reachtmhar, and he was called Feidhlimidh Reachtmhar through the excellence of the legal judgments delivered in Ireland in his time. Now, the law Feidhlimidh ordained in his own time in Ireland resembled the law which is called in Latin **lex talionis**; this means that when one injures or wounds another a similar infliction would be visited on himself in retribution; thus trespass for trespass, a cow for a cow, a hand for a hand, a leg for a leg, an eye for an eye, and so on for every other injury beginning from these. And the result of this law was that the men of Ireland improved in their behaviour in the time of Feidhlimidh, whence he was called Feidhlimidh Reachtmhar. And at length this man died on his pillow.


*Cathaoir* Mor son of Feidhlimidh Fiorurghlas, son of Cormac Gealta Gaoth, son of Nia Corb, son of Cu Corb, son of Mogh Corb, son of


---

p.261




Conchubhar Abhradhruadh, son of Fionn File, son of Rossa Ruadh, son of Fearghus Fairrge, son of Nuadha Neacht, son of Seadna Siothbhac,son of Lughaidh Loithfhionn, son of Breasal Breac, son of Fiachaidh Foibhric, son of Oilill Glas, son of Fearadhach Foghlas, son of Nuadha Fullon, son of Ealloit, son of Art, son of Mogh Airt, son of Criomhthann Coscrach,son of Feidhlimidh Foirthriun, son of Fearghus Fortamhail, son of Breasal Breodhamhan, son of Aonghus Ollamh, son of Oilill Bracain, son of Labhraidh Loingseach of the race of Eireamhon, held the sovereignty of Ireland three years. Now Cathaoir had thirty sons, as the poet says in this stanza:


> 1. Thirty sons, good the progeny,
>   
> Sprang from Cathaoir of Cuala;
>   
> Thrice ten—a beauteous company,
>   
> A troop of champions with stout spears.
> 



But twenty of these children went without issue, and the other ten had issue. Here are the names of the sons who had issue:—Rossa Failgheach senior of the sons who had issue, Daire Barrach, Breasal Einiochghlas, Fearghus, Oilill, Criomhthann, Deargmhosach, Eochaidh Teimhin, Aonghus, and Fiachaidh Aiceadha, the youngest of the children, although it was his descendants who mostly held the sovereignty of Leinster. From Fiachaidh Aiceadha son of Cathaoir Mor sprang O Broin and O Tuathail; from Breasal Bealach son of Fiachaidh Aiceadha sprang Mac Murchadha; from Rossa Failgheach son of Cathaoir Mor sprang O Conchubhair Failghe and O Diomasaigh and O Duinn and clan Colgan, as we shall afterwards state when we are giving the genealogy of the sons of Milidh. And this Cathaoir Mor fell by Conn Ceadchathach in the Battle of Magh hAgha.


Conn Ceadchathach son of Feidhlimidh Reachtmhar, son of Tuathal Teachtmhar of the race of Eireamhon, held the sovereignty of Ireland twenty years, and was treacherously slain in the district of Tara, being found alone there by Tiobraide Tireach son of Mal, son of Rochruidhe, king of


---

p.263




Ulster. Indeed, Tiobraide sent fifty warriors disguised as women to slay him; and it was from Eamhain they set out to do that treacherous deed. Una daughter of the king of Lochloinn was the mother of this Conn. Mogh Nuadhat wrested half of Ireland from this Conn, having defeated him in ten battles. Sioda daughter of Flann son of Fiachaidh, one of the Earna, was the mother of Mogh Nuadhat. The contest between Mogh Nuadhat and Conn arose in this way: The Earna of the race of Fiachaidh Fear Mara of the race of Eireamhon had gained supremacy in Munster over the race of Eibhear, so that three of them held conjointly the sovereignty of all Munster, namely, Lughaidh Eallaightheach, Daire Dornmhar, and Aonghus. And when Mogh Nuadhat saw the race of Eireamhon holding the sovereignty of Munster, he proceeded to Leinster, where he had been brought up by Daire Barrach son of Cathoir Mor, and brought thence a numerous host from Daire to assist him in recovering the kingdom of Munster, which was his birthright. He first turned to Ui Liathain in the south of Munster, where the above-mentioned Aonghus had established his sway, and Mogh Nuadhat defeated him, and drove him from the territory, so that he went to seek the aid of Conn, who gave him five battallions, that is fifteen thousand fighting men. With this host he proceeded to the territory of Ui Liathain, where Mogh Nuadhat fought against him the Battle of Ard Neimhidh, in which he defeated him with great slaughter of his followers.


After this Mogh Nuadhat expelled the Earna from Munster, as many of them as would not submit to him, whence arose a great war between Mogh Nuadhat and Conn, and Mogh Nuadhat defeated him in ten battles: namely, the Battle of Brosnach and the Battle of Samhpait; the Battle of Sliabh Musach; the Battle of Gabhran; the Battle of Suama and the Battle of Grian and the Battle of Ath Luain; and the Battle of Magh Croich, wherein fell Fiachaidh


---

p.265




Rioghfhada son of Feidhlimidh Reachtmhar; the Battle of Asal and the Battle of Uisneach; and this conflict lasted till Mogh Nuadhat wrested half of Ireland from Conn, that is, the part of Ireland to the south of Gaillimh and Ath Cliath, Eiscir Riada being the boundary between them; and that half is called Leath Mogha, from Eoghan who was called Mogh Nuadhat; and the northern half is called Leath Cuinn, from Conn Ceadchathach. In declaration of this division some poet composed this stanza:


> 1. Eoghan Mor, great was his success,
>   
> Was as exalted as Conn Ceadchathach.
>   
> These two, noble was their fame,
>   
> Shared Ireland between them.
> 




Another reason, also, why Mogh Nuadhat wrested half of Ireland from Conn is that there was a great famine in Ireland for seven years in his time; and, before the time of this famine came, Eoghan's druid foretold, long before the coming of the famine, that it would come upon all Ireland; and Eoghan, to make provision for the famine, used venison and fish for food, and stored the corn, and, moreover, he spent on corn all the rents and tributes he received, so that he filled his granaries; and, when the time of scarcity arrived, many of the men of Ireland came to him from all sides, and laid themselves under rent and tribute to Eoghan for his supporting them during that time of distress, as we read in the poem which begins, Eoghan Mor, great was his success:


> 1. Eoghan transcended Conn,
>   
> Not in number of battles and conflicts—
>   
> More plenteously the food of adventurous Eoghan
>   
> Was being distributed according to laws of peace.
> 2. Lean famine rained on them—
>   
> Its visitation was good for Eoghan—
>   
> So that men eat their kind
>   
> Throughout distressful Erin.
> 
> 
> ---
> 
> p.267
> 
> 5. When men heard—far it spread—
>   
> That Eoghan had ale and food in plenty,
>   
> They bound themselves as vassals—good the custom—
>   
> To Eoghan for their sustenance.
> 




Mogh Nuadhat had four names, namely, Eoghan Fidhfheacach, Eoghan Mor, Eoghan Taoidhleach, and Mogh Nuadhat, as the poet says in this stanza:


> 1. Four names without grief
>   
> Had Eoghan Mor,
>   
> Eoghan Fidhfheacach, the generous, the hospitable,
>   
> Eoghan Taoidhleach, Mogh Nuadhat.
> 




Now, if thou desirest, to learn the reason of each of these names mentioned in this stanza, read the Coir Anmann and thou wilt find it there. Eoghan Mor's wife was Beara daughter of Eibhear Mor son of Modhna, king of Castile, and she bore him a son and two daughters; the son's name was Oilill Olom, and the two daughters' names Scoithniamh and Coinneal. Here is the seancha's proof of this:


> 1. Beara daughter of great Eibhear
>   
> Was mother of Oilill Olom,
>   
> And mother of the two pure ones,
>   
> Coinneal and Scoithniamh.
> 



Moreover, Conn Ceadchathach slew Mogh Nuadhat in his bed, having treacherously, according to some seanchas, attacked him at early morning, as they were on the point of engaging in battle against each other on Magh Leana. This king of whom we are treating was called Conn Ceadchathach, from the hundreds of battles he fought against the provincial kings of Ireland, as this stanza sets forth:


> 1. A hundred battles against great Munster
>   
> Won Conn Ceadchathach the just,
>   
> A hundred battles against Ulster with valour,
>   
> Sixty battles against the Leinstermen.
> 




Conn was treacherously slain by Tiobraide Tireach at Tara.




---

p.269


Conaire son of Mogh Lamha, son of Lughaidh Allathach, son of Cairbre Cromcheann, son of Daire Dornmhar, son of Cairbre Fionnmhor, son of Conaire Mor, son of Eidirsceol of the race of Eireamhon, held the sovereignty of Ireland seven years, and fell by Neimhidh, son of Sraibhgheann. This Conaire's mother was Eithne daughter of Lughaidh son of Daire. From this Conaire are descended the Dal Riada of Alba and of Ulster, the Baiscnigh from Leim Chon gCulainn, and the Muscruidhe, as the poet says in this stanza: 


> 1. The Albanians of Riada from the promontory,
>   
> The Baiscnigh from Leim Chon gCulainn,
>   
> The Muscruidhe beyond, without reproach,
>   
> Sprang from the fair Conaire.
> 




XLI.
----


Art Aoinfhear son of Conn Ceadchathach, son of Feidhlimidh Reachtmhar, son of Tuathal Teachtmhar of the race of Eireamhon, held the sovereignty of Ireland thirty years; and his wife was Meadhbh Leithdhearg daughter of Conan Cualann, and from her is called Raith Meadhbha beside Tara. He was called Art Aoinfhear, for of his father's sons he alone survived, as his two brothers, namely, Connla and Crionna were slain by Eochaidh Fionn brother of Conn. For Conn had two brothers, namely, Eochaidh Fionn and Fiachaidh Suighdhe, and by them were slain Art's two brothers; and in testimony of this are these two quatrains from the seanchus:


> 1. The two brothers of Conn witbout faults
>   
> Were Eochaidh Fionn and Fiachaidh Suighdhe;
>   
> They slew Connla and Crionna,
>   
> Conn's two sons, two fair youths;
> 2. Art hated Eochaidh Fionn
>   
> After the two sons had been slain;
>   
> He took the name of Art Aoinfhear
>   
> After his,two brothers were slain.
> 




---

p.271




Conn, indeed, had six children, namely, Art Aoinfhear, Connla, and Crionna, Maoin, Sadhbh, and Saruit, as we read in the poem which begins with the following stanza:


> 1. I can name Conn's six children:
>   
> Maoin, Sadhbh, Saruit, mother of the race of Olom;
>   
> The fair, valiant, bright-skinned men,
>   
> Connla, Crionna, Art Aoinfhear.
> 



As we have said, Connla and Crionna were slain by Eochadh Fionn and by Fiachaidh Suighdhe. Saruit was married to Conaire son of Mogh Lamha, and she bore him the three Cairbres, namely, Cairbre Rioghfhada and Cairbre Baschaoin and Cairbre Musc. It was the descendants of Cairbre Rioghfhada who went to Alba; and it is they who are called Dal Riada. For Eochaidh Muinreamhar, a descendant of Cairbre Rioghfhada, had two sons, namely, Earc and Olchu. From Earc are descended the Dal Riada of Alba, and from Olchu the Dal Riada of Ulster, from whom the Ruta is called. Similarly Sadhbh daughter of Conn was married to Maicniadh son of Lughaidh of the race of Lughaidh, son of Ioth, and she bore him a son called Lughaidh, that is, Mac Con son of Maicniadh. And after the death of Maicniadh she was married to Oilill Olom, and bore him nine sons, namely, the seven who fell in the battle of Magh Muchruimhe, as Oilill Olom himself says in this stanza:


> 1. Mac Con has slain my seven sons;
>   
> Pitiful is my bitter, grievous cry,
>   
> Eoghan, Dumbhmearchon, Mogh Corb,
>   
> Lughaidh, Eochaidh, Diochorb, Tadhg,
> 


 
and the two sons of Oilill who returned from the Battle of Magh Muchruimhe, namely, Cormac Cas and Cian. Now, although Oilill Olom had nineteen sons, that is nine by Sadhbh daughter of Conn, and ten by other women, still


---

p.273




only three of them left issue, as the poet says in this stanza:


> 1. Nineteen pleasant sons had the chief—
>   
> The beauteous Oilill Olom;
>   
> Of one sole trio the race did not decay,
>   
> From whom have sprung the progeny of the free-born.
> 




These three who left issue were children of Sadhbh daughter of Conn. The first of them, Eoghan Mor son of Oilill, fell in the Battle of Magh Muchruimhe, by Beinne Briot, son of the king of Britain; and Fiachaidh Muilleathan, from whom clann Charrthaigh and the tribe of Suilleabhan, with their branches, are sprung, was the son of this Eoghan; and his mother was Moncha daughter of Dil son of Da Chreaga the druid; and he was born at Ath Uiseal on the Siuir, and was called Fiachaidh Fear-da-Liach. For líach means sad event; and sad were the two events that took place with regard to him, namely, the slaying of his father in the Battle of Magh Muchruimhe very soon after his conception in the womb, and the death of his mother immediately after his birth. Hence the name Fiachaidh Fear-da-Liach clung to him. Thus does Oilill Olom himself refer to this matter as we read in the Battle of Magh Muchruimhe —


> 1. A two-fold woe to thee their death
>   
> Together, and a great disaster,
>   
> Thy father and thy mother —
>   
> Grief has overwhelmed thee.
> 2. Thy father and thy mother,
>   
> Two great permanent losses:
>   
> The man in battle was struck down,
>   
> Died the wife at thy birth.
> 



Moreover he was called Fiachaidh Muilleathan, because when the time of his birth arrived his grandfather the druid said to Moncha that if she delayed the birth of her son for twenty-four hours, he would be a king; but if she brought him forth within that time, he would be only a druid.


---

p.275




‘Then,’ said Moncha, ‘in the hope that my son may become a king, I will not bring him forth for twenty-four hours unless he come through my side.’ And then she went into the ford of the Siuir that was beside her father's dun, and there sat upon a stone, and remained twenty-four hours seated on the stone. And at the end of that time she came out of the river and gave birth to a son, and she herself died immediately after having brought him forth. It was this son, then, that was called Fiachaidh Muilleathan; and he was called Muilleathan from the crown of his head being broad. For while his mother was sitting on the flag-stone in the ford, on the point of bringing him forth, the child's crown grew broad by the pressure of the flag-stone on which his mother sate in the ford; hence the name Fiachaidh Muilleathan clung to him.


The second son of Oilill Olom who left issue was Cormac Cas, from whom sprang the Dal gCais and siol Aodha,that is, clan Mac na Mara and siol Flannchuidhe. It was to this Cormac Cas that Oilill Olom had left the inheritance of Munster, until he was informed that Fiachaidh Muilleathan had been born to Eoghan Mor; and when he heard this, he directed that the sovereignty be left after him to Cormac during his life, and that it belong after Cormac's death to Fiachaidh Muilleathan during his life; and in this way that the sovereignty belong alternately in each succeeding reign to the descendants of Cormac Cas and those of Fiachaidh, Muilleathan for ever. And for some generations they held the sovereignty of Munster according to this arrangement.


This Cormac Cas son of Oilill Olom was the fifth best champion in Ireland in his own time; the other four were Lughaidh Lamha, Fionn son of Cumhall, Lughaidh Mac Con, Cairbre Gailin, the fifth champion being Cormac Cas; and there was no one in Ireland fit to fight with any of them outside of their own number. This Cormac Cas was the first to impose a rent-tax on the districts of Munster. He gave in one


---

p.277




day nine ounces and five hundred ounces of silver to bards and learned men for praising him. He brought thirty preys from Britain when he was in exile, stirring up war against the Leinstermen; and the Leinstermen submitted to him.


The third son of Oilill who left issue was Cian. From this Cian are descended O Cearbhaill and O Meaghair, O hEadhra and O Gadhra and O Cathasaigh and O Conchubhar of Ciannachta.


Oilill Olom was the first king of the race of Eibhear who is named in the Reim Rioghruidhe as having held the sovereignties of the two provinces of Munster. Oilill held the sovereignty of Munster twenty-three years. For before Oilill banished Mac Con there were two races holding sway over Munster, namely, the descendants of Dairine of the race of Lughaidh son of Ioth, from whom sprang Mac Con, and the descendants of Deirgthine of the race of Eibhear, from whom sprang Oilill Olom. And whenever the sovereignty of Munster was held by the descendants of Dairine, the brehonship and tanistship were held by the descendants of Deirgthine; and when the descendants of Deirgthine held supreme power, the descendants of Dairine held the other offices, until Mac Con transgressed the command of Oilill Olom, as may be understood from what we are about to say. For Oilill ordered him not to take sides with Neimhidh son of Sraibhgeann against Eoghan son of Oilill, his own kinsman, and the three Cairbres. And in order that the cause of Mac Con's banishment may be better understood, I shall set down here the event that led to Mac Con's expulsion from Ireland, namely, the fall of Aingceal son of Deigheall, who was with Neimhidh son of Sraibhgheann; and by Neimhidh, in his struggle for the possession of Ireland, Conaire son of Mogh Lamha was slain; and it was because of Aingceal that the three Cairbres slew Neimhidh son of Sraibhgheann, the husband of their own mother, Saruit daughter of Conn. For it was Neimhidh who


---

p.279




slew Conaire, their father. On account of this Conaire's three sons were with Art son of Conn.


Cairbre Riada went to Munster, to the house of Neimhidh and Saruit daughter of Conn, his own mother, for she married Neimhidh after Conaire son of Mogh Lamha, and Aingceal happened to be in Neimhidh's house at that time; and there was a strong wrestler there with him, called Dartadha, and whenever a party who were not known came to the house of Neimhidh, one of their men was forced to engage in wrestling with Dartadha. And as Cairbre Riada was going to the house of Neimhidh to visit his mother, he engaged in wrestling with Dartadha, and laid him on the great caldron of the house, and thus he slew him. Thereupon he returned to Tara; and on his relating his adventure to Art Aoinfhear, Art said that it was on a quick errand that he went westward yesterday, seeing that he returned eastward to-day, and hence he is called Cairbre Riada.


When the other two Cairbres, namely, Cairbre Musc and Cairbre Baschaoin, heard that Aingceal, with whom they were at enmity, was at the house of Neimhidh, they exclaimed, ‘That is pleasanter than to pursue him to Britain.’ And upon this the three Cairbres set out for Munster with a company of warriors; and when they came to the house of Eoghan Mor son of Oilill Olom, Eoghan and themselves marched against Neimhidh, and Neimhidh approached in the company of Mac Con, and the Battle of Feabhra then took place between them. Cairbre Musc wounded Mac Con in that battle, and Aingceal was slain there, and Neimhidh fled till he came to where Saruit was. ‘Protection, O my sons,’ said Saruit, extending her arms round Neimhidh. ‘As much of him as is within thy arms will be protected,’ said Cairbre Musc; and forthwith he dealt him a blow that cut off his head, and dealt him a second blow by which he cut off his legs. ‘That is a great disgrace, O Cairbre,’ said she; and


---

p.281




hence he used to be called Cairbre Musc, that is, greater his disgrace than that of his brethren, for it was he who slew his mother's husband.


And on account of Mac Con's forming an alliance of friendship with Neimhidh son of Sraibhgheann, and because of his opposing Eoghan Mor and his kinsmen, namely, the three Cairbres, he was banished out of Ireland by Oilill, and was for a time in exile; and in the course of his exile he gained supporters and made friends for himself, so that himself and Beinne Briot, son of the king of Great Britain, and many other foreigners with them, came to Ireland and declared war on Art Aoinfhear king of Ireland, because of his having helped Oilill Olom; and the Battle of Magh Muchruimhe was arranged between them, to which Art came with all his host and the nine sons of Oilill with the seven battalions of Munster to help Art, while Mac Con with his foreigners were against them on the other side; and the Battle of Magh Muchruimhe was fought between them, and Art and his host were beaten, and Art himself slain by the hand of the champion Lughaidh Lamha, kinsman of Oilill Olom, who was taking part with Mac Con; and seven of the children of Oilill Olom fell there.


Oilill Olom's first name was Aonghus, and he was called Oilill Olom because he had intercourse with Aine daughter of Eoghabhal, and as she slept with Oilill she bit his ear off his head in retribution for his rape of her and for his having slain her father. Hence he was called Oilill Olom, that is ear-cropped. He was called Oilill also, because Oilill is the same as oil oll, ‘a great blemish’; and he had three deforming blemishes which clung to him till death, namely, he was ear-cropped, his teeth had become black, and his breath was foul, which blemishes he thus came by: when he had lost his ear through the means of Aine, as we had said, he got enraged, and forthwith he drove his spear through her body into the earth, and the point of the spear struck against a stone and got


---

p.283




bent, and he put the point between his teeth to straighten it, and the venom of the spear's point got into his teeth and blackened them at once, and thence foulness of breath came upon him, which clung to him till death, for he had violated the three **geasa** that were upon that spear, namely, not to allow its point to come against a stone, not to put its point between the teeth, and not to slay a woman with it. And it was from the violation of these **geasa** that the forementioned blemishes came upon him, and it was from these great blemishes that he was called Oilill—that is, oil oll, or great blemish. And Art Aoinfhear was slain in the Battle of Magh Muchruimhe.


XLII.
-----


Lughaidh, that is, Mac Con son of Maicniadh, son of Lughaidh, son of Daire, son of Fear Uillne, son of Eadbholg, son of Daire, son of Siothbholg, son of Fear Uillne, son of Deaghamhrach, son of Deaghaidh Dearg, son of Deirgthine, son of Nuadha Airgtheach, son of Luchtaire, son of Logha Feidhlioch, son of Eireamhon, son of Eadaman, son of Gosaman, son of Sin, son of Maitsin, son of Logha, son of Eadaman, son of Mal, son of Lughaidh, son of Ioth, son of Breoghan, held the sovereignty of Ireland thirty years. Sadhbh daughter of Conn was Mac Con's mother, as we have said above. Lughaidh son of Maicniadh was called Mac Con because Oilill Olum had a hound called Eloir Dhearg, and when Mac Con was an infant in the house of Oilill, the child used to creep on his hands to the hound, and the hound used to take him to her belly, and he could not be prevented from going constantly to visit her, whence he was called Mac Con.


When Mac Con had become powerful and had returned from his exile, and had fought the Battle of Magh Muchruimhe, as we have said above in treating of Art


---

p.285




Aoinfhear, he obtained for himself the sovereignty of Ireland in a single week, and kept it for thirty years, as we read in the poem which begins Cnucha, a hill over Lithfe. It thus speaks in these two stanzas:


> 1. In the space of seven days, no slight cause of joy,
>   
> Lughaidh became ruler of the land of Erin;
>   
> He came to his strong kingdom
>   
> The ruler of Erin in one week.
> 2. Thirty years without flagging
>   
> Was Mac Con in supreme sovereignty,
>   
> Till the nimble champion fell
>   
> With his supremacy unimpaired.
> 




This Mac Con of whom we are treating was not of the descendants of Eanna Munchaoin of the race of Eibhear, as is stated in the poem which begins Fair Conaire, son-in-law of Conn, but of the race of Lughaidh son of Ioth, son of Breoghan. Now Lughaidh son of Ioth, son of Breoghan, and Milidh of Spain, who is called Golamh son of Milidh, son of Breoghan, were sons of two brothers, so that, though the descendants of Lughaidh son of Ioth are of the race of Gaedheal, still they are not of the progeny of Milidh, but only kinsmen to them, as the poet says, speaking of three branches of the descendants of Lughaidh son of Ioth in this stanza:


> 1. O Cobhthaigh of the feast-serving goblets,
>   
> O Floinn of Ard, O hEidirsceoil,
>   
> A trio who traced not the genealogy of their ancestors (?),
>   
> A trio not sprung from the sons of Milidh.
> 




Here follow some of the other families who sprang from Lughaidh son of Ioth, namely, O Laoghaire of Ros, O Baire of Ara in Rinn Muinntire Baire in Cairbreacha, and O Cuirnin and Mac Ailin in Alba, who was descended from Fathadh Canann son of Mac Con, son of Maicniadh. This Mac Con was the third king of the race of Lughaidh son of Ioth who held the sovereignty of Ireland. The first of these kings was 


---

p.287




Eochaid Eadghothach, son of Daire, son of Conghal, son of Eadaman, son Mal, son of Lughaidh, son of Ioth, son of Breoghan, who held the sovereignty of Ireland four years till he fell by Cearmna son of Eibric; the second was Eochaid Apthach son of Fionn, son of Oilill, who held the sovereignty of Ireland nine years, when he fell by Fionn som of Bratha; the third of the race of Lughaidh son of Ioth who held the sovereignty was the Mac Con of whom we are now speaking. And it is in testimony of this that we have this stanza from the seanchus:


> 1. Three kings sprung from the proud son of Ioth,
>   
> Two Eochaidhs, the ferocious Lughaidh,
>   
> It is not a deed that displeases us,
>   
> The way in which pleasant Ioth was avenged.
> 




Feircheas son of Coman Eigeas at the command of Cormac son of Art slew, with the spear called ringcne, Mac Con, as he stood with his back against a pillar-stone at Gort-an-oir, beside Deargraith in Magh Feimhean, to the west of Ath na gCarbad, while he was there distributing gold and silver to bards and **ollamhs**. When Feircheas son of Coman Eigeas, who resided at Ard na nGeaimhleach, which is now called An Chnocach, he came to to the meeting among the rest, having the ringcne; and when he had come into the presence of Mac Con, he drove that spear through him into the pillar-stone against which his back rested, and this caused his death without delay. From that time to this the plain on which Mac Con was slain is Gort-an-Oir, from the quantity of gold he there bestowed on bards and **ollamhs**. The reason why Mac Con came to Munster was that his druids foretold to him that he would not live half a year on the throne of Ireland unless he left Tara. Hence he came to Munster, to seek aid of of his kinsmen—that is, the descendanst of Oilill Olom; but they remembered their old grudge against him, namely, that he had slain Eoghan Mor and his kinsmen in the battle of Magh Muchruimhe. And


---

p.289




it thus happened that he was returning to Leinster when he was slain.


Fearghus Duibhdheadach son of Fionnchaidh, son of Oghaman, son of Fiatach Fionn, son of Daire, son of Dluthach, son of Deitsin, son of Eochaidh, son of Sin, son of Roisin, son of Triun, son of Roithriun, son of Airndil, son of Maine, son of Forga, son of Fearadhach, son of Oilill Earann, son of Fiachaidh Fear Mara, son of Aonghus Tuirbheach Teamhrach of the race of Eireamhon, held the sovereignty of Ireland a single year. He was called Fearghus Duibhdheadach, as he had two large black teeth. This Fearghus came inside Cormac son of Art in the sovereignty of Ireland, when Cormac was expelled by the Ultonians to Connaught after they had taken his hostages, and he had made the feast for them in the north of Magh Breagh, whereat and attendant of the King of Ulster held a lighted candle to Cormac's hair, and scorched him severely.


Now it was the three sons of Fionnachaidh, son of Oghaman, son of Fiatach Fionn, namely, Feaghus Duibhdheadach, Fearghus Caisfhiaclach, and Fearghus Fuiltleabhair, who committed this outrage on Cormac; and Cormac went to ask the help of Tadhg son of Cian, who was powerful in Eile at that time. Tadhg said to him that he would give his help if he got territory from him. ‘I will give thee,’ said Cormac, ‘as much of Magh Breagh as thou canst go round with thy chariot on the day on which thou shalt have overcome the three Ferghuses in battle.’ ‘Then,’ said Tadhg, ‘I can tell you where you will find the champion Lughiadh Lamha, my grandfather's brother, who, if you bring him to the battle, will in all likelihood slay the three Fearghuses, and the place where you will find him is in Eatharlach beside Sliabh gCrot.’ Upon this Cormac set out for Eatharlach, where he found Lughaidh Lamha lying down in a hunting-booth. Cormac stuch his javelin through the hunting-booth and wounded Lughaidh in the back. 


---

p.291




‘Who wounds me?’ asked Lughaidh. ‘Cormac son of Art,’ replied the other. ‘It is well thou didst wound me,’ said Lughaidh, ‘for it is I who slew thy father, that is, Art Aoinfhear.’ ‘Give me an eric for him,’ said Cormac. ‘A king's head in battle for thee,’ said Lughaidh. ‘Then,’ said Cormac, ‘give me the head of the king of Ulster, namely, Fearghus Duibhdheadach, who is coming between me and the sovereignty of Ireland.’ ‘It shall be given thee,’ said Lughaidh. Upon this Cormac proceeded to Eile to Tadhg son of Cian,and himself and Tadhg marched with their full forces to Brugh-Mic-an-Oigh at Crionna Chinn Chomair, where the Battle of Crionna was convened between Cormac and the three Fearghuses.


Tadhg had, moreover, another reason for going against Ulster, as it was this Fearghus Duibhdheadach who slew his father in the Battle of Samhain. But Tadhg did not permit Cormac to go into the battle, but left him on a hill to the rear of the battle, and an attendant with him there. Now, Tadhg and Lughaidh Lamha attacked the three Fearghuses and their host; and Lughaidh Lamha slew Fearghus Fuiltleabhair and beheaded him, and took the head to the hill on which Cormac was. Now, Cormac, when all were on the point of going to the battle, clothed himself in the garments of Deilionn Druit, his attendant, and put his own clothes on the attendant; for he was certain that when his warrior frenzy should come upon Lughaidh, and when the rage of battle should seize him, he could not be trusted by anyone.


As to Lughaidh, he came with the head which he had into the presence of the attendant who was disguised as Cormac, and asked him whether that was not the head of Fearghus Duibhdheadach. ‘It is not,’ said the attendant, ‘it is the head of his brother.’ Upon this Lughaidh went into the battle again, and cut off the head of Fearghus Caisfhiaclach, and took it in his hand to the hill on which was the attendant disguised as Cormac. ‘Is this the head of the king of Ulster?’ asked 


---

p.293




Lughaidh. ‘It is not,’ said the attendant, ‘it is the head of his other brother’. He went the third time into the battle and brought the head of Fearghus Duibhdheadach with him, and he asked the same question of the attendant. The attendant answered and said that it was the head of the king of Ulster. Upon this Lughaidh aimed a blow at the attendant with the head and struck him in the chest, and the attendant died on the spot; and Lughaidh himself fell into a swoon because of the quantity of blood he had lost through his many wounds.


As to Tadhg, son of Cian, he defeated the Ulster host so that he routed them seven times in the same day between Crionna and Glas Neara on the side of Drom Ineasclain, as the poet Flannagan says in the following stanza:


> 1. Tadhg son of Cian in raith Cro in the north
>   
> Won seven battles in one day,
>   
> Against Ulster, with brilliant success,
>   
> From Ath Crionna to Ard Cein.
> 




After this Tadhg went into his chariot, having three wounds from three spears; and he told his attendant to direct the chariot towards Tara, so that he might include the walls of Tara within the circuit made by his chariot on that day. They drove straight on, though Tadhg fainted several times through loss of blood from his wounds, and as they were approaching Ath Cliath, Tadhg asked the attendant if they had included Tara in that circuit. ‘We have not,’ replied the attendant. Upon this Tadhg struck him dead; and when the attendant had been slain, Cormac son of Art came up, and seeing Tadhg's three great wounds, he ordered the physician who was with him to put an ear of barley into one of his wounds, and a live worm into another of them, and a splinter of a javelin-head into the third wound, and to heal the wounds externally, so that Tadhg was a year in a wasting condition from this treatment, until Lughaidh Lamha went to Munster to fetch the surgeon. The surgeon came with his three pupils, and they heard


---

p.295




Tadhg's moaning as they approached the dun. The surgeon asked the first of the three pupils when they had heard from Tadhg a moan arising from the first wound, what was the cause of that moan. ‘This is the moan caused by a prickle, as there is a barley-prickle in his wound.’ On hearing a moan caused by the second wound, he asked the second pupil what was the cause of that moan. ‘This is the moan caused by a live creature,’ said he, ‘for a live worm has been put into the second wound.’ When the surgeon heard the third moan, he inquired of the third pupil what was the cause of that moan. ‘This is the moan caused by a weapon-point,’ said the third pupil. And when the surgeon reached the house in which Tadhg was, he placed an iron coulter in the fire until it became red hot and then got it in readiness in front of Tadhg. When Tadhg saw the red hot iron put in readiness for the purpose of thrusting it into his body, his heart trembled greatly; and, as a result of the terror that seized him, he violently ejected from his wounds the ear of barley, the worm, and the splinter of javelin-head, and thereupon the surgeon completely healed his wounds; and after that Tadhg was well without delay.


This Tadhg made large conquests in Leath Cuinn afterwards. For Tadhg son of Cian, son of Oilill Olom, had two sons, namely, Connla and Cormac Gaileang. From Iomchaidh son of Connla comes O Cearbhaill, and from Fionnachta son of Connla comes O Meachair. From Cormac Gaileang son of Tadhg, son of Cian, comes O Eadhra and O Gadhra and O Conchubhair Ciannachta. The following are the territories they acquired, namely: Gaileanga, east and west; Ciannachta, south and north; Luighne, east and west.


Moreover, another company of the race of Eibhear took possession of other territories in Leath Cuinn: these are the descendants of Cochlan son of Lorcan, son of Dathan, son of Treachuire, son of Trean, son of Sidhe, son of Ainbhile, son


---

p.297




of Beag, son of Aodhan, son of Dealbhaoth, son of Cas, son of Conall Eachluath, son of Lughaidh Meann (who reduced to swordland the territory between Luimneach and Sliabh Echtghe), son of Aonghus Tireach, son of Fear Corb, son of Mogh Corb, son of Cormac Cas, son of Oilill Olom. Here are the territories, namely, the seven Dealbhnas, that is Dealbhna Mhor, Dealbhna Bheag, Dealbhna Eathra, Dealbhna Iarthair Mhidhe, Dealbhna Shithe Neannta, Dealbhna Chuile Fabhair, and Dealbhna Thire da Loch in Connaught. To describe these the poet sets down the following stanzas taken from the seanchus:


> 1. The seven Dealbhnas of brown spears,
>   
> The race of Dealbhaoth of brown arms,
>   
> They are in Leath Cuinn of the feasting,
>   
> Where there is great honour for **ollamhs**:
> 2. Dealbhna Mhor, Dealbhna Bheag of Breagha,
>   
> Dealbhna of Eathra of strong headlands;
>   
> A race of pleasant customs,
>   
> Dealbhna of the tall-peaked Brugh;
> 3. Dealbhna of the brilliant Sith Neannta,
>   
> Dealbhna of harmless Nuadha;
>   
> Dealbhna of fair bright Cul Fobhair,
>   
> Which never was without good lakes.
> 




Know that it was Lughaidh Lamha, by the direction of Cormac son of Art, who slew this Fearghus of whom we are treating, and that it was at the Battle of Crionna he was slain.




---

p.299


XLIII.
------


Cormac Ulfhada son of Art Aoinfhear, son of Conn Ceadchathach, son of Feilimidh Reachtmhar, son of Tuathal Teachtmhar of the race of Eireamhon, held the sovereignty of Ireland forty years. He is called Cormac Ulfhada, for he had a long ulcha, that is 'a long beard', or from the word Ulfhada, meaning 'Ultonians afar'; for he sent Ultonian chiefs into exile for sixteen years out of Ulster, on account of the injury they had done him before he attained the sovereignty of Ireland. And the mother of this Cormac was Eachtach daughter of Uilceathach the smith; and it was when the Battle of Magh Muchruimh was on the point of being fought that Art Aoinfhear became the father of Cormac by the smith's daughter, who was then his dowered mistress. For it was a custom at that time in Ireland, that whatever king or king's son coveted the daughter of a farmer or biadhtach, desiring to have her as a mistress or paramour, should get her, provided he gave her a marriage portion or dowry of cattle. And it was in this manner that Art obtained Cormac's mother, for it was not she who was his wedded wife, but Meadhbh Leithdhearg, daughter of Conan of Cuala, and from this latter Raith Meadhbha near Tara is named.


Strange was the vision which this Eachtach, that is the mother of Cormac, beheld. She imagined indeed, as she lay asleep beside Art, that her head was severed from her body and that a great tree grew out of her neck which extended its branches over all Ireland, and the sea came over this tree and laid it low; and after this another tree grew out of the roots of the first, and a blast of wind came from the west and felled it; and at the sight of this vision the woman started and awoke from her sleep, and she told the substance of the vision to Art. ‘That is true,’ said Art, ‘the head of every woman is her husband and I shall be taken from thee in the


---

p.301




Battle of Magh Muchruimhe; and the tree that will grow out of thee is a son which thou wilt bear to me, who will be king of Ireland; and the sea that will overwhelm him is a fish-bone which he will swallow, and he will be choked on that occasion. And the tree that will grow out of the roots of the first is a son that will be born to him who will be king of Ireland; and the blast of wind from the west that will overthrow him is a battle that will be fought between himself and the Fian; and he will fall by the Fian in that battle. But the Fian will not prosper thenceforth.’ And this vision was fulfilled in Cormac and his son Cairbre Lithfeachair, since the demons choked Cormac as he was swallowing a fish-bone, and Cairbre Lithfeachair fell by the Fian at the Battle of Gabhra.


Some seanchas state that Cormac's wife was Eithne Thaobhfhada daughter of Cathaoir Mor. But this cannot be true, seeing that she was the mother of Cairbre Lithfeachair. Since there were eighty-eight years from the death of Cathaoir till Cormac assumed the sovereignty of Ireland, namely, the twenty years Conn Ceadchathach held the sovreignty of Ireland, and the seven years Conaire son of Mogh Lamha held it, and the thirty years of Art Aoinfhear, the thirty years of Mac Con, and the one year of Fearghus Duibhdheadach in the sovereignty of Ireland up to the time Cormac assumed the supreme rule of that
country.


It is, however, true that Eithne Ollamhdha daughter of Dunlaing son of Eanna Nia was the mother of Cairbre Lithfeachair; and it is she who was the foster child of Buicead, a farmer with hundreds of kine, who lived in Leinster, who kept a hospitable pot over a fire to give food to everyone of the men of Ireland who visited his house. Now this Buicead was thus circumstanced: he had vast wealth, for he had seven herds, and seven score kine in each herd, together with a corresponding number of horses and cattle of every other description, so that the


---

p.303




nobles of Leinster, with companies of their followers, used to frequent his house, and some of them took away from him a number of his kine, and others some of his brood-mares, others again a number of his steeds, and thus they despoiled him of all his wealth, so that there remained to him only seven cows and a bull; and he fled by night with his wife and Eithne, his foster-child, from Dun Buicead, to an oak grove near Ceanannus na Midhe, where Cormac used to reside at that time; and Buicead built a hut, in which himself and his wife and foster-child then resided. And Eithne used to serve or wait upon her foster-father and her foster-mother as a maid-servant.


Now on a certain day Cormac went out alone on horseback to travel through the lands that surrounded the town, and he saw the fair maiden, Eithne, milking these seven cows of Buicead. And this was her way of doing it: she had two vessels, and she milked the first portion of each cow's milk into the first vessel, and the second portion into the second vessel, and she acted thus till she had milked the seven cows while Cormac kept watching her, through his great love for her. She then went into the hut in which her foster-father was, and left the milk there, and took out in her hand two other vessels and a cup to the stream which was near the town or the hut, and with the cup filled the first vessel from the water which was near the brink, and the second vessel from the water which was in the middle of the stream, and then she returned to the hut. She came out the third time, having a reaping-hook to cut rushes, and as she cut the rushes she used to put each long wisp of fresh rushes that she cut on one side, and the short rushes on the other side. Now Cormac, through his great love for her, was watching her during each of these practices; and Cormac asked for whom she was making the special selection of the water, the milk, and the rushes. ‘He, for whom I am making it,’ said she, ‘is


---

p.305




worthy of a greater kindness from me were it in my power to do it.’ ‘What is his name?’ asked Cormac. ‘Buicead the farmer,’ she replied. ‘Is that Buicead, the Leinster **biadhthach**, who is celebrated throughout Ireland?’ asked Cormac. ‘It is,’ said she. ‘Then,’ said Cormac, ‘thou art Eithne daughter of Dunlaing, his foster-child?’ ‘I am,’ replied Eithne. ‘It is well,’ said Cormac; ‘for thou shalt be my wife.’ ‘It is not I who can dispose of myself,’ said she, ‘but my foster-father.’ Upon this, Cormac went with her to Buicead, and promised him presents if he got Eithne as his wife. Buicead consented to give Eithne to Cormac as his wife; and Cormac gave him the district of Odhran beside Tara, with its stock of cattle, during his life. And then Cormac knew Eithne, and she conceived of him, and after that she bore him an illustrious son, who was called Cairbre Lithfeachair.


Now this Cormac was one of the wisest kings that ever ruled Ireland; witness the Teagasc Riogh he wrote for Cairbre Lithfeachair; and many laudable customs and laws devised by him, which are recorded in the Breitheamhnas Tuaithe. Moreover, of all the kings that ever ruled Ireland, Cormac was one of those who kept the most princely household, and the largest number of attendants and followers. The truth of this may be the more readily admitted from the account which Aimhirgin son of Amhalghaidh son of Maoilrian, the filé of Diarmaid son of Cearbhall, gives of the Teach Miodhchuarta, which Cormac himself renewed and regulated, though it was long before Cormac the Teach Miodhchuarta was built. For it was in it that Slanoll king of Ireland died, long before Cormac's time. This is what we read in the book of **Dinnseanchas**, which the above-mentioned Aimhirgin wrote, namely, that it was in Cormac's time it was made into a banquet-hall. It was three hundred feet in length, thirty cubits high, and fifty cubits in breadth. There was a torch kept constantly lighting in it. It had fourteen doors; thrice fifty beds, besides Cormac's bed; thrice fifty


---

p.307



warriors in each bed. Cormac had thrice fifty stewards. There were fifty warriors standing in the king's presence as he sat at his meal. There were three hundred cup-bearers in that dun, and thrice fifty goblets of carbuncle, of gold, and of silver. The total number of that household amounted to one thousand and fifty men; so that on the greatness and goodness of Cormac, the poet composed this stanza:


> 1. Of children Art left
>   
> Only Cormac of the district of Corann.
>   
> In dispensing jewels he was not close-fisted;
>   
> Better Cormac than a hundred children.
> 




Cormac had ten daughters, and three sons, as the poet says in this stanza:


> 1. Ten daughters had gentle Cormac,
>   
> And three most prosperous sons,
>   
> Plunderers of Claire of the spoils,
>   
> Daire, Cairbre, and Ceallach.
> 




Daire was slain in Dubhros on the Boyne, in Breagha, and Ceallach was slain by Aonghus Gaoibuaibhtheach, as the poet says:


> 1. It was Aonghus Gaoibuaibhtheach of fame
>   
> Who slew Ceallach son of Cormac:
>   
> Daire and noble Tadhg son of Cian died
>   
> In Dubhros of the Boyne in Breagha.
> 




And that the sequence of these events may be better understood by setting down here a short genealogical account of these persons, know that Feidhlimidh Reachtmhar had three sons, namely, Conn Ceadchathach, Eochaidh Fionn, and Fiachaidh Suighdhe, as we have said above. The descendants of Conn were at Tara, and held the sovereignty; and the second brother of Conn, namely, Eochaidh Fionn, went to Leinster, and his descendants multiplied there; and it was his descendants that possessed the seven Fotharta of Leinster. It was in his time that Cu Chorb son of Mogh Corb held the sovereignty of Leinster. It was,


---

p.309




moreover, by this Eochaidh Fionn that Laoighseach Ceannmhor son of Conall Cearnach was brought up and educated in politeness. It happened at that time that the Munstermen gained great sway in Leinster, so that they were in possession of Osruighe and Laoighis as far as Mullach Maistean.


Now, when Cu Chorb saw the Munstermen gaining power in Leinster, he asked Eochaidh Fionn to help him in expelling them from Leinster. Eochaidh consented to this; and he assembled his friends from all sides, and thus brought together a large army, and made his fosterson Laoighseach Ceannmhor leader of the host; and he himself and Cu Chorb king of Leinster, with their hosts, marched against the Munstermen, having Laoighseach Ceannmhor as commander-in-chief of the forces; and they drove the Munstermen from Mullach Maistean to the Bearbha, and routed them at Ath Troistean, which is called Ath I, on the Bearbha; and they followed up this rout till they defeated them a second time at Coirtheine in Magh Riada, which is called Laoighis Riada; and they continued the rout thence till they overthrew them a third time at Slighe Dhala — that is, Bealach Mor Osruighe; and thus they delivered the province of Leinster from the bondage of the Munstermen; and, in consideration of this, Eochaidh obtained the seven Fotharta of Leinster for himself and his descendants; and, similarly, his foster-son got the seven Laoighises for himself and for his descendants as a handsel in consideration of his leadership in expelling the Munstermen from the places we have mentioned.


Moreover, the king of Leinster ordained on his own behalf and on behalf of every king who should succeed him that the back of every beef and the ham of every hog slaughtered in the house of the king of Leinster be given as a champion's portion to the king of Laoighis, and that an axe-man should be in the house of the king of Leinster constantly, at the expense of that king, to receive that tribute


---

p.311




for the king of Laoighis. Besides, the king of Laoighis belonged to the council of the king of Leinster; and he took the fourth next place to the king at a general assembly; and it was to him was given in charge every present made by the king of Leinster for distribution to nobles and to **ollamhs**; and it was to the king of Laoighis that every gift made to the king of Leinster was given to be presented to the king of Leinster.


In addition to this, there were seven of the king of Laoighis's men in the pay of the king of Leinster;and they always attended the king to dress his body. And when the king of Leinster went on tour with his host, the only provision the king of Laoighis was bound to give him was seven beeves which he sent to the king's own camp. But the king of Laoighis was bound to maintain seven score warriors at his own expense for the king's host, and he had also the right of leading the van of the king of Leinster's host when entering hostile territory and in positions of danger. Again, the king of Laoighis was bound to make muster at general assemblies along with the king of Fotharta, because Eochaidh Fionn son of Feidhlimidh Reachtmhar, ancestor of the king of the Fotharta, was tutor to Laoighseach Ceannmhor, from whom sprang the king of Laoighis. And this custom was ever observed by them till the Norman Invasion.




---

p.313


XLIV.
-----


As to Conn's other brother, namely, Fiachaidh Suighdhe, he got land near Tara, namely, the Deise Teamhrach; and he did not become king of Ireland.


Now he had three sons, namely, Rossa and Aonghus, called Aonghus Gaoibuaibhtheach, and Eoghan, the third son. But Aonghus Gaoibuaibhtheach surpassed his contemporaries in valour. And Cormac at that time was at enmity with a powerful personage, and no one protected him from Cormac but Aonghus Gaoibuaibhtheach; and the king gave Aonghus to him as a security. Aonghus took this nobleman under his protection. But after this, Ceallach son of Cormac took this nobleman prisoner in violation of the security of Aonghus, and took out his eyes without the king's permission. When Aonghus Gaoibuaibhtheach heard this, he proceeded to Tara, accompanied by a numerous host, and slew Ceallach by a cast of his spear, as he stood behind king Cormac in the court, and wounded the king himself in the eye, leaving him with only one eye. Cormac assembled a large host and banished Aonghus and his kinsmen.


These descendants of Fiachaidh Suighdhe involved Cormac in much fighting. However, Cormac drove them into Leinster, and they remained there a year; and thence they went to Osruighe, and thence they came to Oilill Olom, whose wife, Sadhbh daughter of Conn, was their kinswoman. Oilill Olom gave them the Deise in Munster, for their native territory was the Deise Teamhrach, before they were banished by Cormac.


These three sons of Fiachaidh Suighdhe divided that territory between them into three parts; and they are called the descendants of Oilill Earann, and the Earna. However, they are not the Earna, but the descendants of Conaire son of Mogh Lamha it is these that were styled the Earna. It is


---

p.315




Corc Duibhne son of Cairbre Musc who was chief over the descendants of Fiachaidh Suighdhe who came to Munster; and it was these descendants that were called the Deise; and Aonghus son of Eochaidh Fionn son of Feidhlimidh Reachtmhar was their leader when coming to Munster, and with him were the three sons of Fiachaidh Suighdhe, namely, Rossa, Eoghan, and Aonghus. About that time Cairbre Musc had acquired great power in Munster; and in his time adversity and crop-failure had come upon Munster. Nor was this strange, for it was by incest and crime that he became father of Corc by Duibhfhionn, his own sister; for they were the children of Conaire son of Mogh Lamha and of Saruit daughter of Conn Ceadchathach. When the Munster nobles observed the adversity that came with Cairbre's reign, they asked him what had deprived the country of its produce and its prosperity. Cairbre replied that it was because he had committed incest with his sister Duibhfhionn, and she had borne him two sons, to wit Corc and Cormac; and when the Munster nobles heard this, they demanded the sons, in order to destroy them—to burn them, and let their ashes go with the stream. ‘Act in that way towards Cormac,’ said Dinneach the Druid; ‘but do not kill Corc, but let him be given to me, that I may take him out of Ireland.’ This was granted to him; and he took him with him to sea, to Inis Baoi; and he found a house on the island in which was a crone called Baoi; and the druid placed Corc under her protection, and he remained with her for a year, and at the end of the year the druid took Corc and placed him under the protection of Saruit daughter of Conn, who was grandmother to the child, both on his father's and mother's side.


As to the Deise, they inquired of their filés whether they were fated to have rest or dwelling in Munster; and the filés told them in reply to stay in the country, and that the wife of Criomhthann son of Eanna Cinnsealach, king of Leinster, whose name was


---

p.317




Congain, was pregnant, and that it was a daughter she would bring forth, and that they should ask the daughter in fosterage, and give a fee in order to obtain her. After this the daughter was born; and she was fostered by the Deise. The daughter's name was Eithne Uathach, and she was fed by the Deise on the flesh of infants that she might grow up the more quickly; for a certain druid had foretold that they would get territory from the man whose wife she would be. And when she was of age to wed, she was married to Aonghus son of Natfraoch, king of Munster. And Aonghus gave them, in consideration of getting her to wife, Magh Feimhean, that is, Trian Chluana Meala, and the Trian Meadhonach after the expulsion of the Osruighigh from these territories. And a long time after this Aonghus and Eithne were slain by the Leinstermen in the Battle of Ceall Osnadh, four miles east of Leithghlinn.


These descendants of Fiachaidh Suighdhe, who are called the Deise, possessed only the district known as Deise Dheisceirt, that is, from the Siuir southwards to the sea, and from Lios Mor to Ceann Criadain, up to the time when Eithne Uathach was married to Aonghus son of Natfraoch, king of Munster. For it was about that time that Aonghus gave them Deise Thuaisceirt, that is, from the same Siuir to Corca Athrach, which is called the Plain of Cashel. And O Faolain, who came from that stock, was king of Deise Thuaisceirt; and the place in which his residence was situated was on the brink of the Siuir to the west of Inis Leamhnachta; and Dun Ui Fhaolain is the name it is called to-day. Another kinsman of his occupied Deise Dheisceirt, and he was called O Bric; and he had his stronghold beside the sea, in the south, in the place which is now called Oilean Ui Bhric. And the Deise were divided thus between these two races until the race of O Bric became extinct; and O Faolain obtained the chieftainship of the two territories, and held it for a long period afterwards, until the race of


---

p.319




Eibhear took Deise Thuaisceirt from him; and so he possessed only Deise Dheisceirt on the coming of the Foreigners to Ireland.


Understand that it was Aonghus Osruighe and his followers that obtained sway over Magh Feimhean, which is called Deise Thuaisceirt, and that it was this sept of Fiachaidh Suighdhe who expelled Aonghus Osruighe and his followers from Magh Feimhean; and from the defeat they inflicted on Aonghus are named Baile Orluidhe, and Mullach Inneona in Magh Feimhean at this day; Baile Orluidhe from the urlaidhe or long hair of the warriors in the battle, and Mullach Inneona from the Osruighigh having been driven from it to Leinster against their will.


About this time Cormac son of Art, king of Ireland, felt a scarcity of meat, having spent the rents of the provinces because of the extent of his household staff and he took counsel with his high-steward, how he could obtain supplies for his staff until the time of his rent-taking; and the steward advised him to assemble a large host, and go ino Munster to levy the head rent of the king of Ireland. ‘For they only pay thee,’ said he, ‘the rent of one province while there are two provices in Munster, and each of these provinces should pay the rent of a province to the king of Ireland.’ Cormac acted on that advice, and sent envoys to Fiachaidh Muilleathan, who was then king of Munster, demanding from him the rent of the second province. Fiachaidh answered the envoys, and said that he would not pay a higher rent to Cormac than was paid to the kings who preceded him. And when this answer reached Cormac, he assembled a large host, and marched with them, and halted not till he reached Druim Damhghaire in Munster, which place is now called Cnoc Luinge. And there he fixed his tent or camp; and Fiachaidh Muilleathan, king of Munster, came on the other side against him front to front.


At that time Cormac was thus circumstanced: he had


---

p.321




druids from Alba with him there, who practised much magic against the king of Munster and his followers, and in particular, not a drop of water was left near the camp of the king of Munster, and so people and cattle were on the point of death through want of water, and the king of Munster was obliged to send for Mogh Ruith, a druid, who was in Ciarraidhe Luachra; and this Mogh Ruith lived in the time of nineteen kings, as the poet says in this stanza:


> 1. The reign of nineteen successive kings
>   
> Was the life of Mogh Ruith with much fighting
>   
> From Roth son of Rioghall, great the fame,
>   
> To Cairbre Lithfeachair the strong.
> 



And when Mogh Ruith came, the king was obliged to give him two cantreds of Feara Muighe, which are called the country of the Roistigh and the country of the Condunaigh. And thereupon Mogh Ruith removed the barrier that had been put to the water withholding it, and at the same time threw up into the air a magic spear which he had, and in the place in which the spear fell there burst forth a well of spring water which relieved the men of Munster from the thirst that afflicted them and hereupon the king of Munster with his host made a sudden onset on Cormac and his followers, and expelled them from Munster, without their having fought a battle or carried off a spoil. And they pursued them to Osruighe, so that Cormac was forced to give pledges and securities that he would send hostages from Tara to Raith Naor, which is called Cnoc Rathfonn, to Fiachaidh Muilleathan, as a guarantee that he would make compensation for all the injury he had done to Munster in that expedition; and as a declaration of this, the poet composed this stanza:


> 1. Fiachaidh Muilleathan, good the king,
>   
> From the land of Aibhle in Leitre Craoi,
>   
> Hostages from great Tara were sent him
>   
> To bright Rathfonn to Raith Naoi.
> 



This Fiachaidh had two sons, to wit, Oilill Flann Mor and Oilill Flann Beag. Oilill Flann Mor had no issue, and


---

p.323




it is from Oilill Flann Beag that all who survive of the race of Fiachaidh Muilleathan are descended. And hence the poet indites this stanza:


> 1. The sons of great Fiachaidh Muilleathan
>   
> Were Oilill Flann Mor of the mead-drinking,
>   
> And Oilill Flann Beag of the hosts;
>   
> His progeny are great in Munster.
> 




Now, as Oilill Flann Mor was without issue, he adopted his brother Oilill Flann Beag as a son, and left him his personal effects and his inheritance on condition that he and his descendants should place his name in the genealogy between his own name and that of Fiachaidh Muilleathan; and so it is in the Psalter of Cashel, and in other ancient books. It is not, however, to be inferred from them that Oilill Flann Mor was the father of Oilill Flann Beag. But the reason why the chroniclers used to put the name of Oilill Flann Mor in the genealogical tree of Fiachaidh Muilleathan was to commemorate the compact that existed between himself and Oilill Flann Beag, as we have said above. Fiachaidh Muilleathan was treacherously slain by Connla Clamh son of Tadhg, son of Cian, ancestor of the siol Cearbhaill and of the siol Meachair at Ath Uiseal, which is called Ath Aiseal on the Siuir at the present time. And the reason why he did that deed of treachery was that when Connla was a youth with Cormac son of Art, learning manners and accomplishments, leprosy or mange came upon him, and no medical treatment whatever availed him. Cormac told him on that occasion that there was no cure destined for him, until he should wash himself in the blood of a king, and that were he to do that he would be healed of his mange. Soon after this Connla took his leave of Cormac, and went into Munster to visit his kinsman, Fiachaidh Muilleathan, who was then king of Munster. And at that time Fiachaidh Muilleathan resided at Raith Rathfainne, which is nov called Cnoc Rathfonn, with his foster-mother, whose name was 


---

p.325




Rathfonn; and when Connla came into his presence, he bade him welcome.


Now, on a certain day soon after this, Fiachaidh went out beside the Siuir with all his household, attended by Connla, who carried his spear; and he went as far as Ath Aiseal, and proceeded to swim in the stream; and Connla bethought him of Cormac's instructions. And thereupon he went to the verge of the bank, and stabbed Fiachaidh with his spear as he swam, and thus slew him. Fiachaidh, however, before he died, protected Connla, and forbade his household to slay him. And he died immediately after that. And it was in this way the life of Fiachaidh Muilleathan ended.


XLV.
----


We said above, following the seanchus, that Cormac had ten daughters. We shall, however, refer only to two of them here, to wit, Grainne, who was wife of Fionn son of Cumhall, *and who eloped with Diarmaid Ó Duibhne,* and Aillbhe daughter of Cormac, who was wife of Fionn afterwards.


And whoever should say that Fionn and the Fian never existed would not be stating truth. For, to prove that the Fian existed we have the three things that prove the truth of every history in the world except the Bible, namely, oral tradition of the ancients, old documents, and antique remains, called in Latin monumenta. For it has been delivered to us from mouth to mouth that Fionn and the Fian existed; and, moreover, there are numerous documents that testify to this. There are also antique remains named after them, as Suidhe Finn on Sliabh na mBan, called from Fionn descendant of Baoiscne, and Gleann Gharaidh in Ui Faithche, called from Garaidh son of Morna, and Leabaidh Dhiarmada Ui Dhuibhne agus Ghrainne at Poll Tighe Liabhain in Ui Fiachrach Eidhne, which is 


---

p.327




now called the country of O Seachnasaigh, and so, too, of many other places in Ireland. And should anyone say that much of what has been written about the Fian is not to be believed, he would certainly state the truth; for there was no kingdom in the world in which there were not written tales called fabulae in Pagan times, for example, the Knight of the Sun, Bevis of Hamton, Huon of Burdex, and other such like, which were written even in the time of the Faith. But there is no country in the world in which also true and credible histories have not been written. In the same manner, although many imaginative romances have been written about Fionn and the Fian, such as Cath Fionntragha, Bruighean Chaorthainn, and Imtheacht an Ghiolla Dheacair, and others of a similar kind, for the sake of amusement, still it is certain that true credible accounts of them were also written. And it is also certain that their bodies were not abnormally large, but only like those of their contemporaries; and they were nothing more than hired warriors of the Kings of Ireland, to defend and to protect the country for them, as every king has now captains and soldiers to defend his own dominions.


Now the Fian used to be quartered on the men of Ireland from Samhain to Bealltaine; and it was their duty to uphold justice, and to prevent injustice, for the kings and the lords of Ireland; and also to guard and preserve the harbours of the country from the violence of foreigners; and from Bealltaine to Samhain to be engaged in hunting, and the chase, and in every other duty the king of Ireland might impose upon them, such as putting a stop to robbery, exacting the payment of tribute, putting down malefactors, and so of every other evil in the country. For this, they had a certain pay, as every king in Europe gives pay to the captains and to the generals who serve under him. However, from Bealltaine until Samhain, the Fian were obliged to depend solely on the products of their hunting and of the chase as 


---

p.329




maintenance and wages from the Kings of Ireland; thus, they were to have the flesh for food, and the skins of the wild animals as pay. But they only took one meal in the day-and-night, and that was in the afternoon. And it was their custom to send their attendants about noon with whatever they had killed in the mornings hunt to an appointed hill, having wood and moorland in the neighbourhood, and to kindle raging fires thereon, and put into them a large number of emery stones; and to dig two pits in the yellow clay of the moorland,and put some of the meat on spits to roast before the fire; and to bind another portion of it with suagans in dry bundles, and set it to boil in the larger of the two pits, and keep plying them with the stones that were in the fire, making them seethe often until they were cooked. And these fires were so large that their sites are to-day in Ireland burnt to blackness, and these are now called Fulacht Fian by the peasantry.


As to the Fian, when they assembled on the hill on which was the fire, each of them stripped off, and tied his shirt round his waist; and they ranged themselves round the second pit we have mentioned above, bathing their hair and washing their limbs, and removing their sweat, and then exercising their joints and muscles, thus ridding themselves of their fatigue; and after this they took their meal; and when they had taken their meal, they proceeded to build their hunting-tents, and so prepare themselves for sleep. Each of them made himself a bed of three things: the tops of trees, moss, and fresh rushes; the tree-tops at the bottom on the ground, the moss upon these, and the fresh rushes on top; and it is these are called in the old books, the three tickings of the Fian.


The following is an account of Fionn son of Cumhall, and of the branch of the Gaels whence he sprang. Now, Campianus says, in his chronicle, that some authors say that it was Fionn son of Cumhall who was called Roanus. 


---

p.331




But this assertion of his is not true. Know that it was Cumhall son of Treanmhor, the fourth in descent from Nuadha Neacht, king of Leinster, who was his father, and that his mother was Muirn Mhunchaomh daughter of Tadhg son of Nuadha, druid of Cathaoir Mor; and Almha of Leinster was the native inheritance of Tadhg son of Nuadha; and hence Alma of Leinster came to belong to Fionn in right of his mother. However, it was the king of Leinster who gave him Formaoil na bhFian in Ui Cinnsealaigh, where Luimneach Laighean is at this day.


Hector Boetius, in the History of Alba, unjustly calls Fionn son of Cumhall a giant; and besides he falsely asserts that he was fifteen cubits in height. For it is plain from the old books of the seanchus that he was not of abnormal size as compared with his contemporaries; and it is plain that there were some of the Fian of greater size, more powerful, and stronger than he. Now, the reason why he was made Ri Feinnidh over the warriors of Ireland was that his father and grandfather before him were leaders of the warriors of Ireland. Another reason also why he was made Ri Feinnidh was that he surpassed his contemporaries in knowledge and in learning in skill and in strategy, and also in wisdom and valour in fields of battle, so that it was on this account he was appointed Ri Feinnidh, and not because he surpassed all others in strength of body and size of person. The ordinary host that served under Fionn consisted of the three battalions of the Gnathfhian, having three thousand in each battalion, when the men of Ireland were at peace with one another. But whenever any party of the nobles of Ireland were at enmity with the high king, or whenever it was necessary to send a host to Alba to help Dal Riada against foreigners, Fionn used to have seven battalions, so that he had a sufficiently large host to go to Alba to assist Dal Riada, as well as to guard Ireland from the oppression of the foreigners.


There were many chief leaders under Fionn in command of the Fian, thus: 


---

p.333




a caithmhileadh in command of the battalion, as a colonel is in command of a regiment, the leader of a hundred like the modern captain, the chief of fifty like the lieutenant, and the head of thrice nine like the corporal, and the head of nine like the decurion of the Romans. For when the hundred were divided into ten divisions, or ten ranks, there was an officer over each, who was called a leader of nine. And when mention is made in the records of Ireland of a man match in battle for a hundred, or fifty, or nine, or such like as belonging to the Fian, we are not to understand from them that such a man would kill a hundred, or fifty, or nine, with his own hand; but what we are to understand from them is that he was leader of a hundred, or fifty, or nine, and was, with his following, a match in battle for a similar leader in command of a like following. There were four injunctions placed on everyone admitted to the ranks of the Fian. The first injunction was not to accept a dowry with a wife, but to choose her for her good manners and her accomplishments; the second injunction, not to force a woman; the third injunction, not to refuse a man asking for valuables or food; the fourth injunction, that none of them should flee before nine warriors.


The following are the other conditions which Fionn son of Cumhall attached to the degrees in bravery which each one was bound to obtain before being received into the Fian. The first condition: no man was received into the Fian or the great Assembly of Uisneach, or the Fair of Taillte, or the **Feis of Tara**, until his father and mother and clan and relatives gave guarantees that they would never demand any retribution from anyone for his death, so that he might look to no one to avenge him but to himself; and that if he should inflict great injuries, retribution should not be visited on his kinsmen. The second condition: no one was admitted into the Fian until he had become a filé, and had made up the twelve books of Filidheacht. The third condition: no one was admitted 


---

p.335




into the Fian until a large pit reaching above his knees had been made for him, and he was placed in it with his shield and a hazel staff as long as a warrior's arm in his hand; and nine warriors, with nine spears, were to approach him, leaving the space of nine furrows between him and them; and they hurled nine spears together at him, and if he were wounded in spite of his shield and his hazel staff, he would not be received into the Fian. The fourth condition: no man was admitted into the Fian until, having his hair plaited, he was sent through several woods with all the Fian in pursuit of him with a view to wounding him, while he got but the odds of a single tree over them, and if they overtook him, they would wound him. The fifth condition: no man was admitted into the Fian whose weapons trembled in his hand. The sixth condition: no man was admitted among them if a branch of a tree in the woods unloosed from its plait a single braid of his hair. The seventh condition: no man was admitted among them if he broke a withered bough beneath his feet. The eighth condition: no man was admitted among them unless he leaped over a tree as high as his forehead, and unless he stooped beneath a tree as low as his knee, through the great agility of his body. The ninth condition: no man was received into the Fian unless he could pluck a thorn from his foot with his hand without stopping in his race for the purpose. The tenth condition: no man was admitted among them unless he had sworn to the Ri Feinnidh that he would be faithful and submissive to him.


While Cormac held the sovereignty of Ireland some Ulster nobles made a raid on the coasts of Alba, and they came upon Ciarnait daughter of the king of the Cruithnigh, and brought her as a captive across the sea. And when Cormac heard of her beauty, he demanded her publicly, and took her to his own house; and she surpassed the women of her time in beauty; and for this Cormac loved her. But when Eithne Ollamhdha 


---

p.337




daughter of Dunlaing, Cormac's lawful wife, heard that Ciarnait lived with him, she said that he must not have them both at the same time; and Eithne insisted on getting charge of her; and she imposed on her as work of slavery that she should grind with a quern nine pecks or nine measures of corn every day. Notwithstanding this, Cormac met her in secret; and she conceived of him; and when she became pregnant, she was unable to grind; and she went privately to Cormac and told him so. Cormac sent to Alba for an artificer who could construct a mill. The artificer came to him, and made the mill to release Ciarnait from her slavery under Eithne; and it is on this theme the poet composed the following stanzas:


> 1. Ciarnait, handmaid of just Cormac,
>   
> Fed many hundreds from a quern;
>   
> Nine pecks she had each day to grind;
>   
> It was not work for a frivolous person.
> 2. Then meets she the noble king
>   
> In his house, where she is alone;
>   
> And she conceived in secret,
>   
> And after that she refused to grind.
> 3. Conn's grandson went to visit her;
>   
> He brought a millwright from over seas;
>   
> The first mill of Cormac son of Art
>   
> Was a help to Ciarnait.
> 






---

p.339


XLVI.
-----


It was in the time of Cormac that Fitheal lived; and he was his chief brehon; and as Fitheal was about to die, he sent for his son namd Flaithri; and this Flaithri was a wise and learned man. Fitheal left him his blessing, and advised him to observe four things most carefully, and that it would be to his advantage to do so, namely, not to nurse or take in fosterage a king's son, not to impart a dangerous secret to his wife, not to raise the state of a serf's son, not to commit his purse or his treasure to his sister's keeping. And after Fitheal's death, Flaithri resolved to test each of these points. And to make trial of them he took in fosterage the son of Cormac son of Art; and some time after he took the child with him into a wood, and gave him to one of his people, a swineherd, who lived in the recesses of the wood; and he asked him to conceal the child well until himself should send him a certain token, and then he returned to the town to his own house, and feigned much trouble and distress; and his wife inquired of him the cause of his trouble and distress. He said it was nothing. But when she saw his distress continue, she began to importune him to find out from him the cause of his trouble. He said that, if she would keep it a secret, he would tell her the cause of his distress.


She swore that whatever he should tell her as a secret she would not reveal it. ‘Then,’ said he, ‘I have committed a dreadful act of treachery, that is, the slaying of my fosterson, the king's son.’ Upon hearing this, the wife screamed and called the house-folk, and told them to bind the parricide because he had killed the king's son. And they did accordingly, and they took him bound to the king. Flaithri also had raised the state of the son of one of his own stewards so that he became a rich man. Similarly 


---

p.341




very soon after his father's death he committed some of his wealth to his sister's keeping, so that none of the four counsels his father had given him should go unstested by him. Now, when, the steward's son found that he was a prisoner, and the king about to put him to death, none of them was more bitter and severe against him than he, as he hoped to acquire Flaithri's inheritance for himself.


Flaithri, finding himself in this difficulty, sent a message to his sister, asking her to send him the treasure he had give her to keep, that he might make friends for himself around the king's person. But when the messenger reached her, she denied that she had ever received any such thing from him. And when that reply reached Flaithri, as he was about to be put to death, he asked to be permitted to go before the king, in order to speak to him on a secret matter; and when he had come into Cormac's presence, he told him that the child was safe, and asked to be kept in his bonds till his foster-son should be brought in. The son was sent for; and when the child had come in from the swineherd who had been keeping him in safety, as he beheld Flaithri in bonds, he wept without ceasing until he was set free. And when Flaithri had been set free, Cormac asked him privately why he had permitted himself to be placed in this predicament. ‘It was to test the four counsels my father gave me I did so,’ said Flaithri; ‘and I found on testing them that my father's four counsels to me were wise. In the first place, it is not wise for anyone to take upon him the bringing up of a king's son lest he may be guilty of neglect resulting in the injury or loss of the fosterchild, while the life or death of the foster-father who had been negligent was in the power of the king. As to the second counsel my father gave me, the keeping of a dangerous secret is not by nature in the power of women in general; hence it is not prudent to commit such a secret to them. The third counsel my father gave me was not to raise or make 


---

p.343




wealthy the son of a serf or of a lowly person; for such persons are usually unmindful of the benefit conferred on them; and moreover, they are hurt that the party who raised them should be aware of the meaness and lowly state whence they rose. Good,’ said he, ‘is the fourth counsel my father gave me: not to give my treasure to my sister; for it belongs to the nature of women to regard as spoil whatever valuables their friends give them to keep in safety.’


It was ordained in Cormac's time that every high king of Ireland should keep ten officers in constant attendance on him, who did not separate from him as a rule, namely, a prince, a brehon, a druid, a physician, a bard, a seancha, a musician, and three stewards: the prince to be a bodyattendant on the king; the brehon to explain the customs and laws of the country in the king's presence; a druid to offer sacrifices, and to forebode good or evil to the country by means of his skill and magic; a physician to heal the king and his queen and the rest of the household; a filé to compose satire or panegyric for each one according to his good or evil deeds; a seancha to preserve the genealogies, the history, and transactions of the nobles from age to age; a musician to play music, and to chant poems and songs in the presence of the king; and three stewards with their company of attendants and cupbearers to wait on the king, and attend to his wants. This custom was kept from the time of Cormac to the death of Brian son of Cinneide without change, except that, since the kings of Ireland received the Faith of Christ, an ecclesiastical chaplain took the place of the druid, to declare and explain the precepts and the laws of God to the king, and to his household. Thus does the seancha set forth the matter just stated:
 

> 1. There are ten round the king,
>   
> Without rivalry, without anxiety—
>   
> I can name them all,
>   
> Both prince and official.
> 
> 
> ---
> 
> p.345
> 
> 4. There are appointed to attend on gracious kings,
>   
> A brehon, a filé, and a prince;
>   
> The king who has not the three named,
>   
> His honour-price is not sanctioned by Fenian law.
> 5. A chaplain to expound the gospels,
>   
> A seancha who sets right every mishap,
>   
> A musician skilled in harp-strings also:
>   
> For these fine and honour-price are appointed.
> 6. The fourth person is a physician,
>   
> To look to each one's disease;
>   
> Three stewards to serve famous companies,
>   
> I shall record for the hosts of Erin.
> 7. The king who shall not have all these
>   
> Has no right to be in the Reim Rioghruidhe;
>   
> In the house of Tara shall not pass his time
>   
> A king not having the ten.
> 




On account of the excellence of Cormac's deeds and judgments, and laws, God gave him the light of the Faith seven years before his death. And, accordingly, he refused to adore gods made with hands; and he set himself to reverence and honour the true God; so that he was the third man in Ireland who believed before the coming of Patrick. Conchubhar son of Neasa was the first to receive the faith when he heard from Bacrach the druid that the Jewish people would put Christ to death by torment; Morann son of Maon was the second person; and Cormac son of Art was the third. It was at Tara that Cormac usually resided, according to the practice of his predecessors, until his eye was desroyed by Aonghus Gaoibuaibtheach, as we have said above; and thenceforward he abode in Achaill, in the house of Cleiteach, and in Ceanannus. For the men of Ireland considered it neither becoming nor auspicious that a king with a blemish should abide in Tara; and for this reason Cormac gave over the sovereignty to his son Cairbre Lithfeachair; and he gave up Tara to him, retiring himself to the house of Cleiteach and to Achaill not far from Tara. And it was there he 


---

p.347




composed the Teagaisc Riogh, setting forth what a king should be, as we have said above, and how he should rule the people through their laws. And from the time that Cormac gave over the sovereignty, he believed only in the one God of heaven.


On a certain day, when Cormac was in the house of Cleiteach, the druids were worshipping the golden calf in his presence; and the general body of the people were worshipping it after the manner of the druids. Maoilgheann the druid asked Cormac why he was not adoring the golden calf and the gods like the rest. ‘I will not,’ said Cormac, ‘worship a stock made by my own artificer; and it were better to worship the person who made it; for he is nobler than the stock’ Maoilgheann the druid excited the golden calf so that he made a bound before them all. ‘Dost thou see that, O Cormac?’ said Maoilgheann. ‘Although I see,’ said Cormac, ‘I will worship only the God of heaven, of earth, and of hell.’


After this his food was cooked for the king, and he began to eat a portion of a salmon from the Boinn. Thereupon the demon sprites came, at the instigation of Maoilgheann the druid, and they killed the king. Others say that it was a salmon-bone that stuck in his throat and choked him. For it was eating fish he was when the sprites, or demons of the air, choked him.


When the king was in the throes of death, he directed his officers not to bury his body at the Brugh, where the kings of Tara had been buried up to then. But when the people were conveying his body to the Brugh to be buried, the sprites put it into the greatly swollen river thrice before them; for they did not wish to let his body into the burial place of the idolaters, since he believed in the true God. And the fourth time its bearers carried the body into the river, and it was snatched away from them by the current of the Boinn, and it reached Ros na Riogh and 


---

p.349




became separated from the fuad, or bier, whence the ford Ath Fuaid on the Boinn is named. They mourned for him there; and
his grave was made; and he was buried at Ros na Riogh. A long time after this, Columcille came to that place, and found the head of king Cormac there, and buried it. Columcille remained in the place till he had said thirty Masses above his grave, and there is now a church in the place.


As we have spoken of the druids here, I think it will be meet to give some account of them, and especially of their sacrifices, and of their **geasa**, as will appear below. There are, indeed, to be seen in Ireland to-day in many places, as relics of the Pagan times, many very wide flag-stones, and pillarstones supporting them; and these are called idol-altars in the old books, while the general populace call them beds of the Fian, as they are ignorant of the reason of their construction. On these altars the druids were wont to make their sacrifices in the olden time, and slay their he-goats, their bulls, and their rams; and the druids themselves went on their knees under the blood as it dropped from their victims, to cleanse themselves from the uncleanness of their sins, as the high priest did among the Jewish people when he went under the sacrificial bridge to let the blood of the victims flow over him, and hence he was called Pontifex, that is, bridge-wright.


As to the druids, the use they made of the hides of the bulls offered in sacrifice was to keep them for the purpose of making conjuration, or laying **geasa** on the demons; and many are the ways in which they laid **geasa** on them, such as to keep looking at their own images in water, or gaze on the clouds of heaven, or keep listening to the noise of the wind or the chattering of birds. But when all these expedients failed them, and they were obliged to do their utmost, what they did was, to make round wattles of the quicken tree, and to spread thereon the 


---

p.351




offered in sacrifice, putting the side which had been next the flesh uppermost, and thus relying on their **geasa** to summon the demons to get information from them, as the conjurer does nowadays in the circus; whence the old saw has since been current which says that one has gone on his wattles of knowledge when he has done his utmost to obtain information.


Formerly, in the times of Paganism, there were two chief cemeteries in Ireland, in which most of the kings of Ireland were buried, namely, the Brugh of the Boinn, and the Cemetery of the Kings near Cruachain. It is plain, from the narrative given above, that the Brugh of the Boinn was a burial-place for the kings of Tara, and it is certain that the Cemetery of the Kings at Cruachain was a common cemetery for the kings of Ireland, according to Torna Eigeas in the following poem:


> 1. A fair king of Fail lies beneath thee,
>   
> Dathi son of Fiachraidh, a man of dignity;
>   
> O Cruacha, thou hast concealed this
>   
> From foreigners and from Gaels.
> 2. Beneath thee lies strenuous Dunghalach,
>   
> Who brought the hostages across the sea from the west;
>   
> There is beneath thee, make known the gift,
>   
> Conn Tuathal and Tomaltach.
> 3. Three sons of Eochaidh Feidhlioch the fair,
>   
> They are beneath thy wall as I aver;
>   
> Eochaidh Aireamh lies prostrate,
>   
> Slain by the mighty great Maol.
> 4. Eochaidh Feidhleach the prince
>   
> Is beneath thee, and worthy Deirbhri,
>   
> And Clothra, not reproachful the dignity,
>   
> And Meadhbh and Murasc.
> 5. Eire Fodla and Banbha,
>   
> Three beauteous noble young ladies,
>   
> Are in Cruacha of the clans,
>   
> Three women of the Tuath De Danann,
> 
> 
> ---
> 
> p.353
> 
> 8. The three sons of Cearmad, from Sith Truim,
>   
> And Lughaidh from Liathdhruim,
>   
> The sons of Aodh son of the Daghadh,
>   
> And tall brave Midhir.
> 9. Beneath thy pillar-stones are lying
>   
> Graceful Cobhthach and Ughaine,
>   
> And Badhbhcha of the prosperous reign,
>   
> And proud, haughty Ollamh.
> A fair.




Eochaidh Gunnat son of Fiach, son of Iomchaidh, son of Breasal, son of Siorchaidh, son of Fiatach Fionn from whom the Dal bhFiatach are named, son of Dluthaidh, son of Deitsin, son of Eochaidh, son of Sin, son of Roisin, son of Triun, son of Roithriun, son of Airndil, son of Maine, son of Forga, son of Fearadhach, son of Oilill Earann, son of Fiachaidh Fear Mara, son of Aonghus Tuirbheach Teamhrach of the race of Eireamhon, held the sovereignty of Ireland one year, and he fell by Lughna Feirtre.




---

p.355


XLVII.
------


Cairbre Lithfeachair son of Cormac, son of Art Aoinfhear, son of Conn Ceadchathach, son of Feidhlimidh Reachtmhar, son of Tuathal Teachtmhar, son of Fiachaidh Fionnoluidh of the race of Eireamhon, held the sovereignty of Ireland twenty-seven years; and he was called Cairbre Lithfeachair because it was near the Lithfe in Leinster that he was brought up. And his mother was Eithne Ollamhdha daughter of Dunlaing son of Eanna Nia. And Cairbre was slain at the Battle of Gabhra by Simeon son of Cearb, one of the Fortuatha of Leinster; and the reason why the Battle of Gabhra was fought was: Samhaoir daughter of Fionn son of Cumhall was the wife of Cormac Cas son of Oilill Olom, and she was the mother of Tinne and Connla and Mogh Corb; and it was by reason of that relationship that Mogh Corb protected his mother's brother, that is, Oisin son of Fionn, and the clanna Baoiscne from being overpowered by Cairbre Lithfeachair and Aodh Caomh son of Garaidh Glundubh of the race of Morna; and at that time the clanna Morna formed the regular army of Ireland; and they were at enmity with Fionn and with the clanna Baoiscne for seven years. Hence the party of Garaidh Glundubh incited Cairbre Lithfeachair and the provincial kings of Ireland to dethrone Mogh Corb in the hope that, as a consequence of this, the clanna Baoiscne would be banished. And this led to the Battle of Gabhra.


This Mogh Corb, with the manning of 300 ships, went with two brothers of his mother (they were sons of the king of Lochloinn) to obtain for them the sovereignty of Lochloinn from the king of Lochloinn, whose name was Iarus son of Iarnmhor, and he defeated the king in battle, and slew him 


---

p.357




and his four sons and his eight brothers, and the majority of the nobles of Lochloinn, and left his mother's two brothers in the possession of the country of Lochloinn.


Fothaidh Airgtheach and Fothaidh Cairptheach, two sons of Mac Con, son of Macniadh, son of Lughaidh, son of Daire, son of Fear Uileann of the race of Lughaidh son of Ioth, assumed the sovereignty of Ireland. They both reigned conjointly one year. And Fothaidh Cairptheach fell by Fothaidh Airgtheach, and Fothaidh Airgtheach fell by the Fian in the Battle of Ollarbha.


Fiachaidh Sraibhthine son of Cairbre Lithfeachair, son of Cormac, son of Art Aoinfhear, son of Conn Ceadchathach of the race of Eireamhon, held the sovereignty of Ireland thirty-three years, and fell by the three Collas in the Battle of Dubhchumair. Aoife, daughter of the king of the Gallghaedheal, was the wife of Fiachaidh Sraibhthine, and mother of Muireadhach Tireach; and he was called Fiachaidh Sraibhthine, for it was at Dun Sraibhthine i Connaught he was fostered. Now in order that this event may be better understood, we shall set down here, from the Psalter of Cashel, the cause of the Battle of Dubhchumair, and an account of the relationship that existed between the Collas and Fiachaidh Sraibhthine.


It is at Cairbre Lithfeachair that the Oirghialla—that is, the family of the Collas—separate in their pedigree from the clanna Neill and the Connachtaigh. And Fiachaidh Sraibhthine son of Cairbre Lithfeachair was grandfather of Eochaidh Muighmheadhon son of Muireadhach Tireach, son of Fiachaidh Sraibhthine; and it is from this Muireadhach that the clanna Neill and the men of Connaught are descended. Eochaidh Doimhlean son of Cairbre Lithfeachair was brother to Fiachaidh Sraibhthine; and this Eochaidh had three sons, to wit, the three Collas, and from these are descended the Ui Mac Uais, the Ui Criomhthainn, and the Modhornaigh. The real names of the three Collas referred to were Cairioll, 


---

p.359



Muireadhach, and Aodh. Here is the seancha's statement of this matter:


> 1. The three sons of Eochaidh, great their fame,
>   
> The three Collas we have heard of;
>   
> Colla Meann, Colla fo Chri,
>   
> And Colla Uais the high king.
> 2. The names of the three I know,
>   
> And they slew the high king
>   
> On yon wide bright plain,
>   
> Aodh Muireadhach and Cairioll.
> 3. Cairioll, Colla Uais the king,
>   
> Muireadhach, Colla fo Chri,
>   
> Aodh, Colla Meann, great his fame;
>   
> These three were mighty beyond all strength.
> 




Aileach daughter of Udhaire king of Alba, wife of Eochaidh Doimhlean, was the mother of the three Collas. It was Fiachaidh Sraibhthine these three Collas slew, though a kinsman, which resulted in the sovereignty of Ireland being lost to themselves. Now this was the cause of that murder of a kinsman. When Fiachaidh was king of Ireland, he had a good son called Muireadhach Tireach, and he was leader in battle for his father, for the king himself would not be allowed into battle. On a certain occasion Muireadhach went into Munster accompanied by a host and carried off hostages and spoils. Fiachaidh Sraibhtine happened then to be at Dubhchumair, beside Taillte on the south side, and a host with him there. His brother's three sons, that is the Collas, had another host at Dubhchumair near Taillte helping Fiachaidh Sraibhthine. When they heard of the success of Muireadhach in Muster, people generally said that he was the heir-presumptive to the sovereignty of Ireland. ‘What shall become of us,’ said the Collas, ‘if Muireadhach become king of Ireland after Fiachaidh?’ ‘What we had better do,’ said they, ‘is to give battle to the old king; and when we have slain himself and his host, we shall overcome his son when he will come against us.’ 


---

p.361




Fiachaidh at that time had a druid with him called Dubhchumair; and he spoke thus: ‘O king,’ said he, ‘if thou overcomest the Collas and slayest them, there will never be a king of thy offspring after thee in Ireland; and if it be they who shall succeed and slay thee there will never be a king of Ireland of their progeny.’ ‘Well then,’ said the king, ‘I prefer to fall by the Collas, and the kingdom to pass to my descendants after me, than that I should slay the Collas, and that the sovereignty of Ireland should go to their descendants after them.’ Thereupon the two hosts got ready for battle, and made onslaught on each other from either side; and Fiachaidh Sraibhthine was defeated and slain in that battle, as Dubhchumair had foretold of him.


Colla Uais son of Eochaidh Doimhlean, son of Cairbre Lithfeachair, son of Cormac, son of Art Aonfhear, son of Conn Ceadchathach of the race of Eireamhon, held the sovereignty of Ireland four years, and was then with his brothers banished into Alba by Muireadhach Tireach son of Fiachaidh Sraibhthine, where they were taken into military service by their kinsmen. For Aileach daughter of Udhaire, king of Alba, the wife of Eochaidh Doimhlean, was the mother of the three Collas. Cairioll was called Colla Uais from his being distinguished above the other Collas, since he held the sovereignty of Ireland, and the others did not.


Muireadhach Tireah son of Fiachaidh Sraibhthine, son of Cairbre Lithfeachair, son of Cormac, son of Art Aoinfhear, son of Conn Ceadchathach of the race of Eireamhon, held the sovereignty of Ireland thirty-three years, and fell by Caolbhach son of Cronn Badhraoi. Muireann daughter of Fiachaidh, king of Cineal Eoghain, the wife of Muireadhach Tireach, was mother of Eochaidh Muighmheadhon. As to the Collas they were banished by Muireadhach into Scotland, as we have said; and their host numbered three hundred; and the king of Alba received them with affection, and took them into military service on account of their 


---

p.363




valour; and they remained there three years. They came thence to Ireland—that is, Colla Meann and Colla da Chrioch and Colla Uais—in the hope that Muireadhach Tireach might slay them, though being his kinsmen, and that in consequece of this parricide the sovereignty of Ireland might go to their descendants. And they brought with them, as an escort, only nine warriors each, and they neither halted nor rested till they reached Tara and came into the presence of the king, Muireadhach Tireach. ‘Have ye news for us, O kinsmen?’ said the king. ‘We have no news,’ said they, ‘that would affect thee more than the deed we ourselves have done, that is, that we have slain thy father.’ ‘We have that news ourselves,’ said Muireadhach; ‘and it matters not to you, as it shall not be avenged on you; but the misfortune it has brought upon you will not pass away from you.’ ‘That is the reproach of a coward,’ said the Collas. ‘Be ye not dejected; ye are welcome,’ said he. They spent a long time after this in close friendship; and the Collas were leaders in battle for the king.


The king told them, then, that it was time they should win territory for their descendants. ‘In what territory dost thou wish us to make sword-land?’—there were no more daring youths in Ireland in their time than they. ‘Rise out against the Ultonians,’ said he; ‘for ye have just cause of battle with them, since an attendant of the king of Ulster burned the beard or hair of Cormac son of Art with a candle in Magh Breagh. Now, when Cormac had become king of Ireland, a strong force of the Ultonians came against him and drove him into Connaught, having carried off hostages from him., After that they made peace with Cormac and got ready a feast for him in north Magh Breagh. And it was there that an attendant of the king of Ulster burned Cormac's hair. And that deed is still unavenged.’


Upon this, king Muireadhach gave them a large host; and the Collas went thence 


---

p.365




into the province of Connaught, and the men of Connaught took them into military fostege. After this, the men of Connaught joined in their march with a force of seven battalions; and they reached Carn Achuidh Leithdheirg in Fearnmhagh. From that hill they fought seven battles against the Ultonians, that is a battle each day for a week. Six of these battles were fought by the Connaughtmen, and by the Collas was fought the seventh, in which Fearghus Fogha,king of Eamhain, was slain; and the Ultonians were defeated and pursued from Carn Achuidh Leithdheirg to Gleann Righe, and, after inflicting great slaughter on them, the Collas returned and attacked Emhain, which they plundered and burned, so that it has ever since remained without a king to inhabit it. On that occasion, the Collas wrested the following territory from the Ultonians, namely, Modharnuigh, Ui Criomthainn, and Ui Mac Uais. Colla Meann took possession of Modharnuigh, and Colla da Chrioch of Ui Criomhthainn, and Colla Uais of Ui Mac Uais. And Muireadhach Tireach fell by Caolbhaidh son of Cronn Badhraoi.


Caolbhaidh son of Cronn Badhraoi, son of Eochaidh Cobha, son of Lughaidh, son of Rossa, son of Iomchaidh, son of Feidhlimidh, son of Cas, son of Fiachaidh Aruidhe, son of Aonghus Gaibhnionn, son of Fearghus Foghlas, son of Tiobraide Tireach, son of Breasal, son of Fearb, son of Mal, son of Rochruidhe, son of Cathbhadh, son of Giallchaidh, son of Cunnchaidh, son of Fionnchaidh, son of Muireadhach, son of Fiachaidh Fionnamhnus, son of Irial Glunmhar, son of Conall Cearnach of the race of Ir son of Milidh, held the sovereignty of Ireland one year. Inneacht daughter of Lughaidh was the mother of Caolbhaidh son of Cronn Badhraoi; and he was slain by Eochaidh Muighmheadhon.


Eochaidh Muighmheadhon son of Muireadhach Tireach, son of Fiachaidh Sraibhthine, son of Cairbre Lithfeachair, son of Cormac Ulfhada son of Art Aoinfhear, son of Conn 


---

p.367




Ceadchathach, held the sovereignty of Ireland seven years. Moingfhionn daughter of Fiodhach, wife of Eochaidh Muighmheadhon, was mother of Brian and of Fiachhaidh Fearghus and Oilill. And Cairrionn Chasdubh daughter of the king of Britain, another wife of Eochaidh's, was mother of Niall Naoighiallach. And he was called Eochaidh Muighmheadhon because, as to his head and breast, he resembled the king, and, as to his waist, he resembled a slave called Mionghadhach, and hence he was called Muighmheadhon.



It was over Eochaidh Muighmheadhon that Eanna Cinnsealach, king of Leinster, won the Battle of Cruachan Claonta; and therein Ceadnathach, filé to Eochaidh Muighmheadhon, was taken prisoner. But when Eanna came up, he inquired of his party why they had spared the druid. ‘Thou wouldst never,’ said the druid, ‘conquer from this hill on which I am, if I were to live.’ Upon this Eanna transfixed him with his spear; and, as the spear pierced his body, a laugh broke forth from Eanna. ‘Alas,’ said the druid, ‘that is a foul laugh and it is this that will be given as a name to thy posterity after thee for ever’; and hence that tribe are since called Ui Cinnsealaigh. Eanna Cinnsealach was powerful in his time, as may be seen from the poem composed by Dubhthach son of O Lughair, who was chief **ollamh** of Ireland when Patrick came to propagate the Gospel in Ireland. A battle fought by the Leinstermen, is the beginning of that poem. But I shall here quote only these two stanzas of it, from which it may be inferred that Eanna was powerful in his time. Here are the stanzas:—


> 1. The tribute which was given to Eanna,
>   
> From Leath Cuinn of the feasts,
>   
> Was a screaball from each house,
>   
> All of fionndruine.
> 2. The tribute which was given to Eanna,
>   
> From Mumha with insults
>   
> Was an ounce of gold from each lios
>   
> In the ensuing year.
> 




---

p.369




And according to the Psalter of Cashel this Eanna defeated the clann Cuinn in thirteen battles.


Criomhthann son of Fiodhach, son of Daire Cearb, son of Oilill Flann Beag, son of Fiachaidh Muilleathan, son of Eoghan Mor, son of Oilill Olom of the race of Eibhear, held the sovereignty of Ireland seventeen years. Fidheang, daughter of the king ofConnaught, was his wife. This Criomhthann gained victories and obtained sway in Alba, Britain, and France, as the seancha says in the following stanza:— 


> 1. Criomhthann son of Fiodhach swayed
>   
> The lands of Alba and of Erin;
>   
> He swayed likewise beyond the clear blue sea
>   
> Even the Saxons and the French.
> 




It was also Criomhthann son of Fiodhach who gave the kingdom of Leath Mogha or Munster to his foster-son, namely, to Conall Eachluaith son of Lughaidh Lamhdhearg; and the descendants of Fiachaidh Muilleathan were displeased at this; and they said that Conall did not show himself a good kinsman by accepting it, while there was at the time among the descendants of Fiachaidh one qualified to be a good king, namely, Corc son of Lughaidh. And the arbitration the learned sages of Munster made between them at the time was that Corc son of Lughadh was to have the sovereignty of Munster in the first instance, as he was the senior, and that it was finally to go to the descendants of Cormac Cas. The descendants of Fiachaidh Muilleathan gave sureties and guarantees that they would allow the sovereignty of Munster to pass on the death of Corc to Conall Eachluaith or to his son should Conall himself be not living, as Oilill Olom ordained that it should belong to these two families in alternate generations, that is, the family of Fiachaidh Muilleathan and that of Cormac Cas. It was on that agreement, then, that Conall Eachluaith allowed the sovereignty of Munster to go to Corc son of Lughaidh; and, on 


---

p.371




the death of Corc, Conall Eachluaith himself took up the sovereignty of Munster; and Criomhthann son of Fiodhach gave the hostages of the men of Ireland, of Alba, Britain, and France into the hands of Conall Eachluaith. And accordingly Cormac son of Cuileannan composed the following stanzas:— 


> 1. Eachluaith received the tribute of Ireland
>   
> After Criomthann, it was a tribute from abroad;
>   
> Though he had not gone beyond the Sea of Manainn,
>   
> Never did a better king receive it.
> 2. As many as great Criomhthann son of Fiodhach brought
>   
> Of hostages over the brimming sea,
>   
> He gave into the hand of the red-speared champion,
>   
> Illustrious noble Conall Eachluaith.
> 3. Conall Eachluaith set out on an expedition
>   
> Into every territory after pleasant Criomhthann;
>   
> To Dun Liamhna, illustrious was the warrior,
>   
> Where noble companies were slain.
> 4. To him belonged Fearta Conaill in Feimhion,
>   
> Druim Chormaic Aine Dun Gair,
>   
> Cashel Coincheann strong Raith Leamhna,
>   
> Fochair Mhaigh fair Dun Cearmna.
> E.




Moingfhionn daughter of Fiodhach, Criomhthann's own sister, gave him a poisoned drink in Inis Dornghlas on Muaidh, in the hope that the sovereignty would pass to her favourite son, that is, Brian son of Eochaidh Muighmheadhon; and Criomhthann son of Fiodhach died of the poison of that drink on Sliabh Uidhe an Riogh, on the north side of Luimneach; and Mongfhionn herself died of the poison of the same drink in Inis Dornghlas on Muaidh, having taken some of it to urge her brother to drink it.




---

p.373


XLVIII.
-------


Niall Naoighiallach son of Eochaidh Muighmheadhon, son of Muireadhach Tireach, son of Fiachaidh Sraibhthine, son of Cairbre Lithfeachair, son of Cormac Ulfhada, son of Art Aoinfhear, son of Conn Ceadchathach of the race of Eireamhon, held the sovereignty of Ireland twenty-seven years. Cairionn Chasdubh, daughter of the king of Britain, was Niall's mother. Inne daughter of Lughaidh, wife of Niall, was the mother of Fiachaidh. A second wife of Niall's was Rioghnach, who bore him seven sons, namely, Laoghaire and Eanna, Maine, Eoghan, two Conalls, and Cairbre, as the poet says in this stanza:—
 

> 1. Joyous was the bright Rioghnach
>   
> When she bore Laoghaire son of Niall,
>   
> Eanna, Maine of bright deeds,
>   
> Eoghan, two Conalls, Cairbre.
> 




This Niall went into Alba with a large host to strengthen and to establish the Dal Riada and the Scotic race in Alba, who were at this time gaining supremacy over the Cruithnigh, who are called Picti; and he was the first to give the name Scotia to Alba, being requested to do so by the Dal Riada and the Scotic race, on the condition that she should be called Scotia Minor or Lesser Scotia, while Ireland should be termed Scotia Major or Greater Scotia; and it was through veneration for Scota daughter of Pharao Nectonibus, who was wife of Galamh called Milidh of Spain, from whom they themselves sprang, that the Dal Riada chose the name of Scotia for Alba, instead of calling her Hibernia.


Camden states in his chronicle of Britain that Lesser Scotia was the name of Alba, and Greater Scotia the name of Ireland, and says that it cannot be proved by documents that the Albanians were called Scots till the time of the emperor 


---

p.375




Constantine the Great. Moreover, Camden gives the Irish the name of Scotorum Attavi, that is, the Forbears of the Scots, thus declaring that the Scots of Alba sprang from the Irish. Thus too he speaks on the same subject: *The Scots,(says he,) came from Spain to Ireland in the fourth age. {Scoti ex Hispania in Hiberniam quarta aetate venerunt.}’’*

 Besides, Nennius, a British author says, according to Camden, that it was in the fourth age of the world that the Scithae—that is, the Scotic race—took possession of Ireland. Moreover, it is plain from the annals of Ireland that Alba was the name of that country up to the time of Niall Naoighiallach; and when the Dal Riada were permitted to call it Scotia, themselves and their descendants kept on that name. Before that time Alba or Albania was the country's name, from Albanactus, third son of Brutus, since it was Alba that fell to him as his share from his father. Now Brutus had three sons according to Monomotensis, namely Laegrus, Camber, and Albanactus; and Brutus divided the island of Great Britain between them; and to Laegrus he gave Laegria, which derives its name from him, and it is this country which is now called Anglia; to Camber he gave Cambria, which is now called Wales; and the third portion to Albanactus, from whom Alba is called Albania.
Niall marched after this with his full host from Alba to Laegria, and made an encampment there; and he sent a fleet to Brittany in France, which is called Armorica, for the purpose of plundering that country; and they brought two hundred noble youths as captives to Ireland with them; and it was in this captivity that they brought Patrick, who was sixteen years old, with them, and his two sisters Lupida and Darerca and many other captives besides.


Many authors testify that Scota was the name of Ireland, and that it was the Irish who were called the Scotic race. Thus does Jonas the abbot, in the second chapter, treating of Columcille, speak: *Colman,(he says,) who is called Colum, 


---

p.377




was born in Hibernia, which is inhabited by the Scotic race. {Columbanus qui et Columba vocatur in Hibernia ortus est; eam Scotorum gens incoluit.}’’*

 Beda also, in the first chapter of the first book of the History of Sacsa, says that Ireland was the native land of the Scots. He speaks thus: *Hibernia is the true fatherland of the Scots. {Hibernia propria Scotorum patria est.}’’* The same author, writing about the saints, makes a remark which agrees with this. He speaks thus: *It was from Hibernia, the island of the Scots, that St. Kilian and his two companions came. {Sanctus Kilianus et duo socii eius ab Hibernia Scotorum insula venerunt.}’’* From this it is to be inferred that the Irish were called the Scotic race in the time of Beda, who lived 700 years after Christ. Orosius also, who lived within 400 years after Christ, agrees with the same statement. He thus speaks in the second chapter of the first book: *It is the Scotic races that inhabit Ireland. {Hibernia a Scotorum gentibus colitur.}’’* And it is plain that the country which is called Ireland used to be called by authors Scotia. Serarius, writing of St. Kilian, speaks thus: *Holy Kilian of the Scotic race, etc.’’*; and immediately after he uses these words, *Scotia, which is also called 'Hibernia'. {Beatus Kilianus Scotorum genere et *relqa*.}’’* From this it may be inferred that Scotia was a name for Ireland in constant use like Hibernia. The truth of this matter will be seen from the words of Capgrave, writing of St. Colum; he speaks thus: *Scotia was an ancient name of Ireland, whence came the Scotic race, who inhabit that part of Alba which lies nearest to greater Britain; and that Alba is now for this reason called Scotia from Ireland, from which they derive their origin, and whence they immediately came. {Hibernia enim antiquitus Scotia dicta est, de qua gens Scotorum Albaniam Britanniae maiori proximam quae ab eventu modo Scotia dicitur inhabitans, originem duxit et progressum habuit.}’’* Marianus Scotus, a Scotic author, writing of St.Kilian, agrees with this. He speaks thus: *Although that part of Britain which adjoins Sacsa on the north is now properly called Scotia, nevertheless Beda shows that Ireland was 


---

p.379




formerly known by that name; for when he states that the Pictish race came from Scythia to Ireland, he adds that it was the Scotic race they found there before them. {Etiamsi hodie Scotia proprie vocetur ea Britanniae pars quae ipsi Angliae contigens ad Septentrionem vergit, olim tamen eo nomine Hiberniam notatam fuisse ostendit D. Beda, cum Scythia Pictorum gentem in Hiberniam venisse ait ibique Scotorum gentem invenisse.}’’* And since it was from the Scotic race the country was named, Scotia was its name at that time.
It is to be inferred also from the words of Caesarius, who lived within 500 years after Christ, that Scotia was the name of Ireland. He thus speaks in the twelfth book of the Dialogues, chap 38: *Whoever doubts the existence of Purgatory, let him go to Scotia, and go into the Purgatory of St. Patrick, and he will no longer doubt of the pains of Purgatory. {Qui de Purgatorio dubitat, Scotiam pergat, Purgatorium Sancti Patricii intret, et de Purgatorii poenis amplius non dubitabit.}’’*

 From the words of this author it is to be inferred that Scotia was a common name for Ireland at that time, as there is no place in Alba called Patrick's Purgatory; and it is plain that the place so called is in Ireland; and hence that it was Ireland Caesarius called Scotia. Serarius, writing on St. Bonifacius, is in accord with this: *Scotia was also a name for Ireland. However, since there came from the same land of Ireland a certain race to the east of Britain, where the Picti were dwelling, and there they settled down along with them, and at first were called Dalrheudini (that is, Dal Riada), from their own leader Rheuda (that is, Cairbre Rioghfhada), as Beda affirms. But after this they routed the Picti themselves; and they occupied the entire northern portion of that country; and they gave it the old name of their race, so that there is but one Scotic race. There are, however, two Scotias: one of them, the elder and proper Scotia, is Ireland, and the other, which is recent, is the northern part of Britain. {Hibernia Scotiae sibi nomen etiam vindicabat, quia tamen ex Hibernia ista Scotorum pars quaedam egressa est in eaque Britanniae ora quam Picti iam habebant consederunt; ii quidem principio a duce suo Rheuda Dalrheudini dicti fuerunt, ut ait V. Beda; postea tamen Pictos inde ipsos exegerunt, et boreale totum illud latus obtinuerunt, eique vetus gentus suae nomen indiderunt. Ita ut Scotorum gens una fuerit, sed Scotia duplex facta sit, una vetus et propria in Hibernia, recentior altera in septentrionali Britannia.}’’*
I note three things from the words of the author. The first of these is that the Irish are truly the Scots; the 


---

p.381




second is that it was the Dal Riada that were first called Scots in Alba, since it was they who first conquered the Picti in Alba. The third is that he says that Ireland was the older Scotia, and Alba the new Scotia, and that it was the Scotic race who first called it Scotia. **Buchanan**, a Scotch author, in the second book of the History of Scotland, makes a statement which bears out the author quoted above. He speaks thus: *The inhabitants of Ireland were called Scots, as Orosius points out, and as our own annals record; it was not once only the Scots migrated from Ireland to Alba. {Scoti omnes Hiberniae habitatores initio vocabantur ut indicat Orosius, nec semel Scotorum ex Hibernia transitum in Albiam factum nostri annales referunt.}’’*

 From this it is to be inferred that it was not the Dal Riada alone who went from Ireland to settle in Alba, but numerous other tribes as well from time to time.


---

p.383


XLIX.
-----


We read in the seanchus of Ireland that the following tribes went to Alba in succession to conquer that country.


First Aonghus Ollbhuadhach son of Fiachaidh Labhruinne went to impose on the Cruithnigh their headrent to the kings of Ireland two hundred and fifty years after the coming of the sons of Milidh to Ireland. A long time after that, Reachtaigh Rioghdhearg, king of Ireland, went to impose rent on them. Similarly Cairbre Rioghfhada with his host went to invade the north of Alba; and it is the race of Cairbre Rioghfhada that Beda calls the Dalrheudini of Alba. Mac Con went to conquer Alba and Britain; and it was from these countries he came to Ireland to fight the Battle of Magh Muchruimhe in which Art Aoinfhear fell, and Mac Con assumed the sovereignty of all Ireland, as we have said. After this Fathaidh Canann son of Mac Con went to Alba, and took possession of lands there; and from his posterity Mac Cailin and the correlative branches of that family have sprung. Also Colla Uais and his brothers went to Scotland, and they acquired large territories there; and from this Colla Uais sprang the clann Domhnaill of Alba and of Ireland. Criomhthann son of Fiodhach, king of Ireland, went to Scotland to make conquests; and Earc son of Eochaidh Muinreamhar, son of Aonghus Feart of the race of Cairbre Rioghfhada, and his posterity are called clann Eirc and Cineal Gabhran in Alba, and also Cineal Lodhairn, Cineal Comhghaill, and Cineal nAonghusa and the Cineal Con *Criche* of the Isle, with their branches.


Corc son of Lughaidh went to Alba with an army; and the reason of his going thither was that he had a stepmother named Daol daughter of Fiachaidh son of Niall (king of South Eile); and she was enamoured of him. And when Corc refused to have intercourse with her, she made a complaint of him to his father 


---

p.385



Lughaidh, in whose presence she wept; and he asked why the maiden wept: ‘For Corc has forced me,’ said she. Lughaidh grew jealous at this, and banished Corc to Alba, where he was welcomed by Fearadhach Fionn or by Fionn-Chormac, king of Alba, and where he was much beloved by reason of his refined manners. He got his own daughter called Moingfhionn married to Corc; and she bore him three sons in Alba, namely, Maine Leamhna, from whom are the Leamhnaigh of Alba; and Cairbre Cruithneach, from whom are the Eoghanacht of Magh Geirrghinn in Alba; and Cronan, from whom are the Cuircnigh in West Meath; and Cronan remained abroad till the time of Laoghaire son of Niall; and he then came to Ireland; and Laoghaire gave him his own daughter called Cairche, and from her is named Machaire Chuirchne; and Niall son of Eochaidh held four other sons of Corc as hostages. The names of the four sons were Corc, Greagha, Dula, and Maine. Corc the younger died in this captivity; and the father released the other three, and took them with him to Munster. In the time of Niall Naoighiallach, Corc son of Lughaidh went to Alba; and long after Niall, six sons of Muireadhach son of Eoghan, son of Niall, went to Alba, namely, two Lodharns, two Aonghuses, and two Fearghuses.


Conall was the first name of Corc son of Lughaidh; and Bolgbhain Breathnach, a censorious woman, was his mother; and she was not his father's wedded wife, since Daol daughter of Fiachaidh son of Niall, king of South Eile, was his wife. Here is a stanza by Giolla an Choimdhe O Corain in proof of this:


> 1. Conall was before Corc
>   
> The name of Lughaidh, faultless hero;
>   
> Fire which a caldron preserves through the day,
>   
> It was that purpled his fair ear.
> 



And the reason why he was called Corc was: there were two simpletons in Munster destroying infants; and they made an attack on the place in which Conall, who is called Corc, was, for the purpose of destroying him, and he was hidden under an inverted caldron; and the 


---

p.387




simpletons traced him, and removed the caldron from over him, and they burned the child's ears, and from the purpling they gave his ears he was called Corc.


Maine Leamhna son of Corc, son of Lughaidh, went from Ireland to Alba, and there occupied territory which is called Magh Leamhna, whence the **Mormhaor** of Leamhain in Alba is named; and it is he is now called the Duke of Lenox; and it is from this Maine Leamhna son of Corc of the race of Eibhear sprang the noble families of the house of Lenox. It is from a brother of this Maine called Cairbre Cruithneachan sprang the Eoghnacht of Magh Geirrghinn in Alba; and it was after the time of Niall Naoighiallach they went there.


It may similarly be stated of every other tribe of Gaels in Alba that it was from the Gaels of Ireland their nobles sprang. However, the portion of them that are nearest Sacsa who were driven by William the Conqueror over the Saxon borders into Alba, and whose posterity have continuously inhabited the **Galldacht** of Alba, these are not of the Gaels but of the race of the Saxons; and the same holds of another tribe which we shall mention later on, according to Stow in his annals, page 153. He bears out the same statement where he relates that William, king of Alba, was taken prisoner by Henry the Second, king of England, and then sent by him as a captive to the city of Rouen in Normandy, where he was kept by king Henry in captivity until he was forced to pay four hundred pounds for his ransom. Then, when he was returning, being at peace with the king, he took with him to Alba a large number of young English nobles from whom he had received friendly attentions during his captivity; and he gave much land and territories to them and to their descendants after them; and many of these are in possession of the Galldacht of Alba at this day. Here are some of the surnames of the people who went with him at that time who inhabit Alba at present, and it is they are called the Galldacht of Alba; here are some of these surnames: Baliol, Brus, Soully, 


---

p.389




Mowbri, Sentcler, Hay, Gifford, Ramsey, Landell, Bisey, Barclay, Wellegen, Boys, Montgomery, Walley, Collomille, Frizer, Grame, Gurlay, and many others; the age of the Lord 1174.


**Buchanan** agrees with the above, in the thirty-fourth page of the second book of the History of Alba, where he says: *Because both the inhabitants of Ireland and the colonists they sent to Alba were originally called Scots, in order that by some difference they might be distinguished from one another, people from the first called the one race Irish Scots, and the other Albanian Scots. {Principio cum utrique, id est Hiberniae incolae et coloni eorum in Albiam missi, Scoti appellarentur, ut discrimine aliquo alteri ab alteris distinguerentur, initio coepere alteri Scoti Ierni, alteri Scoti Albani, vocari.}’’*

 From these words of **Buchanan** two things are to be inferred; the first is that it was from Ireland the Scots went to occupy Alba; and the second is that the Irish were ordinarily called Scots from the beginning.
Before we treat of Niall Naoighiallach, we shall give here some events taken from the annals of Stow's Chronicle in confirmation of the truth of all that we have said above, as I imagine that the account we shall give of Niall from the seanchus of Ireland will appear the more credible if I set down these things from a foreign chronicle. Stow speaks as follows: *When Marius son of Arviragus was king of Britain in the year of the Lord 73, Rudhruighe, king of the Pictish tribe from Scythia, together with the Scotic race, came to conquer Britain and to waste it with sword and fire; and Marius, above mentioned, gave them battle, and slew Rudhruighe and a large number of his host; and to those of them who survived, he gave lands in the north of Alba to settle down in; and they asked wives of the Britons, but these were unwilling to give them to them. They asked wives of the Irish, and obtained them from them.’’*

 As to this incident which Stow records of Rudhruighe, king of the Picts, it happened when the Pictish leader took women from Ireland in the time of 


---

p.391




Eireamhon, as we have said above, and that was more than thirteen hundred years before Marius was king of Britain.
The same author states that it was in the above year of the age of the Lord that Vespasian was made emperor, and that it was ten years before that time that the abbey of Glastonbury was founded. He also states that it was two hundred and seventy-six years after the birth of Christ that the emperor called Aurelianus first wore the imperial crown; and he was the first emperor who wore the imperial crown.


In the year of the Lord 395, Pelagius, a Briton, first began to sow heresy; and at this time the Scotic race and the Picti were wasting and destroying Great Britain; and the Britons sent envoys to the emperor Honorius asking assistance of him; and he only wrote to them requesting them to do all they could for themselves; and hence it came to pass that the Britons were a long time afterwards under the oppression of the Scots and the Picti. And again the Britons sent envoys to Rome; and they made a pitiful complaint of the cruelty towards them of the Scots and the Picts. The Romans sent an armed legion to relieve them; and when these reached Britain, they had several engagements with the Scots and the Picti; and the Roman host, growing weary, told the Britons to build a wall or fence between themselves and their bad neighbours, and that they themselves could not avoid returning to Rome.




---

p.393


L.
--


As to the Britons, when the Romans had left them, they built a fence of earth from sea to sea between themselves and the Scots and the Picti. And when the Scotic race and the Picti had heard that the Romans had forsaken the Britons, they made a sudden attack on the latter, and broke down the wall and pillaged the country, so that the Britons were forced to send envoys to the Romans a third time, beseeching them not to permit their enemy to despoil them vengefully as they were doing. Upon this the Romans sent another legion to help them; and when these had reached Britain, they had several engagements with the Scots and Picti; and the Romans drove them across the boundary wall of which we have spoken. And when they had thus relieved the Britons, the Romans told them that it was of no advantage to themselves to come on any further expedition of relief to them, and that they should consider how they might protect or guard themselves against the enemy. Accordingly when the Roman army had left them, they began to build the wall that stretches from sea to sea between Britain and Alba, of stonework eight feet thick, and twelve feet high, according to Beda, in the fifth chapter of the first book of the History of Sacsa. When the Scots and the Picti heard that the Romans had refused to come any more to the aid of the Britons, they collected and assembled a large host, and marched towards the wall referred to, and overpassed it and devastated all Britain, so that the Britons were obliged to abandon their stone fortresses and dwellings and betake themselves for refuge to woods and wildernesses, where their sole food was the flesh of the wild beasts they hunted; and the remnant of them that survived wrote piteously to the consul who was in Rome whose name was Boetius, soliciting him for aid; and 


---

p.395




what they said was that they were hemmed in between the enemy and the sea, for as many of them as took to the sea, fleeing from the enemy, were drowned; and as many of them as turned from the sea were slain by the enemy, as Beda says in the thirteenth chapter of the first book of the History of Sacsa, quoting the words of the Britons when complaining to the Romans of the oppression they suffered from the Scots and Picti. These are the words:


*The barbarians force us to the sea, (said they, speaking of the Scots and the Picti;) the sea throws them [us] back upon the barbarians; and by this twofold death, we are either slain or drowned, said they. {Repellunt barbari ad mare, repellit mare ad barbaros, inter haec oriuntur duo genera funerum, aut iugulamur aut mergimur.}’’*

 From this it may be inferred that the oppression exercised by the Scots of Ireland over the Britons was very great. Nennius, an ancient British author says, according to Speed's Chronicle, that the Scots and the Picti oppressed Britain for a period of forty years; and Camden, agreeing with this, says: *Five hundred years after Caesar came to Britain, that country was left to the barbarity of the Scots and the Picti. {Anno 500 a Caesaris ingressu Britannia Pictorum et Scotorum immanitati relinquitur.}’’* This may also be inferred from the words of Beda in the fourteenth chapter of the same first book, in which, speaking of the Irish, he says: *The shameless Irish plunderers return to their homes, (says he,) to come back soon again. {Revertuntur impudentes grassatores Hiberni domum post non longum tempus reversuri.}’’* From these words of Beda it may be inferred that the Irish would often go on expeditions of plunder into Britain.
As to the Britons, they were a long time without being pillaged or plundered by the Scots and the Picti after the Romans had left them. But this oppression was not the only misfortune the Britons suffered from at that time. The Pelagian heresy was then deluding the people; and the Britons determined to send to the French clergy, asking them to send prelates and preachers to them from France to put 


---

p.397




down the Pelagian heresy. Upon this, the French clergy sat in council, and resolved to send two holy bishops to propagate the pure faith amongst them, namely, Germanus, bishop of Auxerre, and Lupus, bishop of Troyes; and when they arrived, they vanquished the heretics.


Notwithstanding what we have said, a constant warfare existed between the Scots and the Britons to the time of Vortigern, who was king of Britain in the year of the Lord 447. However, on account of the evil passions and the pride and the sins of the Britons at that time, God gave the Scots and the Picti the victory over them, so that they were obliged to bring over Horsus and Hingistus with their German host to assist them against the Scots and the Picti. And God used these Germans as a scourge to deprive the Britons of the sovereignty of all Britain ever since. The chroniclers of Britain relate, as Stow notes in the fifty-third page of the first part of his Chronicle, which was printed in London in the year of the Lord 1614, that 480 of the British nobles were treacherously slain by the Saxons, and that Aurelius Ambrosius, the king of Britain at that time, ordered that of the stones which Merlin took over to Britain from Sliabh gClaire in Munster a monument be raised on the spot on which these nobles were slain. It was, moreover, in the same place that he himself was buried. And the place was then called Chorea Gigantum; and it is now called Stone Henge on Salisbury Plain. And the same author says that it was from Africa the Gaels brought these stones; and Monomotensis says that no two of the stones were taken from the same country.


From this we may infer that the Gaels were wont to go to Africa to plunder that country, and that they were therefore powerful in other countries besides Ireland; and whoever should be surprised at these events or disbelieve them let him blame himself for it, for not having seen or searched the records. For often one is ignorant of the truth through 


---

p.399




not having made himself familiar with the old books of the ancients, as Macrobius points out in the sixth book of the Saturnalia, in which he says: *We are ignorant of many things which should not be hidden from us if we were accustomed to read the ancients {Multa ignoramus quae non laterent si veterum lectio nobis esset familiaris.}’’*

; thus, when we state that the Scots and the Picti exacted a tribute from the Britons, if the reader disbelieves us, let him read Camden's chronicle, and he will find therein these words: *The Britons were made to pay tribute to the Scots in the year of the Lord 446 {Britanni facti sunt tributuarii Scotis et Pictis anno Christi 446.}’’*; or if we state that the Picti were extinguished by the Scots when Cinneide son of Ailpin was king of Alba 839 years after the birth of Christ, let him read Camden's chronicle, and he will find there testimony to the same event; or were we to assert that no foreign nation ever acquired full supremacy over Ireland except the tribes that successively occupied it, namely, Partholon, the clanna Neimidh, the Fir Bholg, and the Tuatha De Danann, and the sons of Milidh, perhaps we should not be believed unless the reader had seen what Gulielmus Nubrigensis has written, treating of Ireland, in the twenty-sixth chapter of the second book of his history, in which he says, *Ireland never submitted to a foreign power. {Hibernia nunquam externae subiacuit ditioni.}’’* Similarly, if I make statements here concerning Niall Naoighiallach which the reader has not heard hitherto, let him know that I have song or story to prove every statement I advance here.


---

p.401


.LI.
----


We read in a *Life* of Patrick, which we found written in an old vellum book, together with the *Life* of Mochuda and 
Abban, and other saints, that Patrick was a Briton. These are the words of the old book: *Patrick, (it says,) a Briton, born in the town called Nemptor, in the Plain of the Tabernacles, of pious and religious parents. {Patricius Brito natus in oppido Nemptor in Campo Taburno .i. tabernaculorum, ex parentibus devotis et religiosis ortus.}’’*

 In the same place it uses these words: *After the Scots from Ireland, together with their king Niall Naoighiallach, had plundered many territories in opposition to the Roman sovereignty, they severely pillaged Britain—the northern portion of it at first; and when they had banished the old tribes from it, they themselves dwelt in it. {Cum Scoti de Hibernia sub rege suo Niall Naoighiallach diversas provincias Britanniae contra Romanum imperium multum devastabant, contendere incipientes aquilonalem Britanniae plagam tandem, ejectis veteribus colonis, ipsi Hibernenses eam occupaverunt et habitaverunt.}’’*
The same author says in the same place that it followed from this that there were three kingdoms in Great Britain, namely, Scotia, Anglia, and Britannia. The same author states that it was at this time, when Niall Naoighiallach was on this expedition planting the Dal Riada in Alba, an Irish fleet went to the place where Patrick dwelt. These are the author's words: *An Irish fleet, (he says,) went at this time to the place where St. Patrick was, to pillage the country, and, as was the custom with the Irish, they brought a large number of captives with them, together with St. Patrick, then aged sixteen years, and his two sisters, namely Lupida and Darerca; and St. Patrick was brought as a captive to Ireland in the ninth year of the reign of Niall, king of Ireland, who held strenuously the sovereignty of Ireland twenty-seven years, 


---

p.403




and who pillaged Wales and Anglia to the sea that lies between Anglia and France. {Hoc autem tempore quaedam classis Hibernica depredavit patriam in qua morabatur D. Patricius et, consueto Hibernorum more, multi inde captivi ducti sunt, inter quos erant D. Patricius aetatis suae anno decimo sexto et duae eius sorores Lupida et Darerca; et ductus est Patricius in Hiberniam captivus anno nono Néill regis Hiberniae qui potenter 27 annis regnavit ac Britanniam et Angliam usque ad mare quod est inter Angliam et Galliam devastavit.}’’*

 From the above words we may believe that Niall Naoighiallach entered Great Britain, and that he made conquests there.
I am also of opinion that it was while Niall was making conquests in Great Britain that he sent a fleet to pillage the borders of France, to the country which is called Armorica, which is now called Little Britain, and that it was thence Patrick and his two sisters were brought as captives. I am the more convinced of the truth of this from the fact that Patrick's mother was sister to Martin, who was bishop of Tours in France, and because I read in an old book, in which is the *Life* of Patrick in Irish, that it was from Armorica Patrick and his two sisters were brought into captivity.


It is moreover likely that, since Niall was making conquests in Great Britain at that time, it was from Britain he sent a fleet to the borders of France, where Patrick and those who came with him into captivity resided. And besides I read in the old books of the seanchus that hostages were brought from France to Niall, and amongst these I believe was Patrick.


Now as to Niall, having taken many captives from Britain, he arrived in Ireland with a large host of Britons and of Irish; and he assembled additional forces, and sent word to Alba, to the chief of Dal Riada, requesting him to follow him with all his host to France.


Niall proceeded forthwith to France with a numerous host; and the chief of Dal Riada with his host overtook him as he was plundering France in the neighbourhood of the river Loor. And at that time the king of Leinster, having been banished by Niall to Alba, was under the protection of Gabhran son of Domhanghurt, chief of Dal Riada; and when this Gabhran went after Niall to France, Eochaidh (the king of Leinster) accompanied him. But Eochaidh did 


---

p.405




not dare to go into Niall's presence; and when Niall had sat down on the brink of the river, Eochaidh went to the other side of the river, into an oak grove which was there, and got ready an arrow in his bow, and cast it at Niall, and sent it through his body, so that he immediately expired.


The enmity between Eochaidh and Niall arose from Eochaidh's conspiring to settle down in Tara as king in the room of Niall; and when he had been nine days in Tara, a learned druid came into his presence and said to him that it was not lawful for him to violate the **geasa** of Tara; ‘for it is one of his **geasa**,’ said he, ‘that no king should settle down in Tara with a view to assuming the sovereignty of Ireland till he should first wear the **nasc niadh** round his neck.’ This was the same as to say that he should have received the degree of Knight of Chivalry. For as the Knight of Chivalry is called **Miles Torquatus**, so also Nia Naisc is applied in Irish to the champion who wore a nasc or chain round his neck. For nia means 'champion' or 'valiant man', and nasc means 'a chain'.


As to Eochaidh, when he heard the druid's instruction, he quitted Tara and relinquished the sovereignty. Niall came after that and settled down in Tara, and assumed the sovereignty of Ireland; and he banished Eochaidh to Alba after he had met him in several engagements; and it was for this reason that Eochaidh slew Niall as we stated above. Another cause of enmity between them was that when Eochaidh was going from Tara to Leinster, he went into the house of Laidcheann son of Bairrchidh, Niall's druid; and while he was there, the druid's son used defamatory language towards him, and on that account Eochaidh slew him.


Now, the druid made a complaint of this to Niall, and asked him to come and avenge the death of his son on the men of Leinster; and incited by the druid, Niall went into Leinster with a strong and imposing host to waste Leinster. And when they reached Leinster, the druid would not consent to Niall's accepting gifts or cattle from the 


---

p.407




Leinstermen until they had delivered the person of Eochaidh into the hands of Niall. And, to prevent the spoiling of Leinster, Eochaidh put himself in the power of Niall; and the druid ordered him to be tied to a pillar-stone which is to be seen to the west of the Slaine, between Cill Brighde and Tulach O Feidhlimidh; and that stone is in a standing position; it is high and broad, and perforated near the very top; and Eochaidh was obliged to stand with his back against the stone and an iron chain round his waist, with both ends of the chain passing through a hole that was in the pillar, and a stout iron spindle-bolt stuck through the two loops at the ends of the chain; and when the druid observed him in this position, he got ready nine warriors to put him to death.


When Eochaidh perceived the warriors approach, with intent to slay him, he stoutly shook himself in champion fashion, and forthwith strained the chain and broke the bolt, and escaped from the warriors with difficulty, after he had slain some of them; and no account is given of his proceedings till he reached Alba, under the protection of Gabhran son of Domhanghart, as we have said. And this was the second reason why he was at enmity with Niall.




---

p.409


LII.
----


Now, when Eochaidh was thus an exile in Alba, some say that the wife of Gabhran, who was called Ingheanach, and the wife of Eochaidh Feidhlim, daughter of Cobhthach son of Dathi, were both pregnant at the same time, and were brought to bed on the same night. The two women were shut up in the same house, no one being with them, but both being together, while there was a guard placed on the outside by Gabhran. As to these women, Gabhran's wife gave birth to a daughter, and the wife of Eochaidh to twin sons. Now, Gabhran's wife never brought forth any children but daughters; and as the wife of Eochaidh had brought forth twin sons, she asked her to give her one of them, and Eochaidh's wife consented to this. When the household, who were on guard, perceived that the women had been delivered, they asked the queen what offspring she had given birth to; she said that she had given birth to a son and daughter, and that the wife of Eochaidh had given birth to a son. All were delighted at this; and this son which the queen got from Eochaidh's wife had a name given him, and he was called Aodhan son of Gabhran; and Eochaidh's second son was called Brandubh son of Eochaidh. And after this, Eochaidh and his son came to Ireland, and he himself assumed the sovereignty of Leinster.


And a long time after this, Gabhran, chief of Dal Riada, who was king of Alba, died; and Aodhan assumed the sovereignty of Alba after him, and came to spoil and plunder Ireland, and endeavoured to conquer it, as he was of the posterity of Cairbre Rioghfhada. A large company of the men of Anglia[1](javascript:footNote('T100054/note001.html')), Alba, and Wales came with him; and when they landed in Ireland, they set to plunder Leinster in 


---

p.411



 
the first instance. Brandubh son of Eochaidh at that time held the sovereignty of Leinster; and Aodhan sent envoys demanding hostages from him as securities for his paying tribute to him, saying that otherwise he would waste the whole territory of Leinster. While Brandubh was in trouble at this message, his mother told him to take courage, and that she would avert the attack of Aodhan from him. Upon this the mother went to the camp of Aodhan; and when she had reached it, she inquired of Aodhan why he had come to waste Leinster. ‘Thou hag,’ said he, ‘I am not obliged to give thee any information on that matter.’ ‘If I be a hag,’ said she, ‘thy mother is a hag; and I have something to say to thee in secret.’ Thereupon he went with her apart. ‘Aodhan,’ said she, ‘I told thee that thy mother was a hag; and I tell thee now that I am she, and that accordingly Brandubh is thy brother. Therefore, send to Alba for thy supposed mother, and she will confess, in my presence, that I am thy mother; and until we meet, do thou refrain from spoiling Leinster.’


He acted as the woman directed; and when the women came together, the queen of Alba admitted that it was Brandubh's mother who gave birth to Aodhan; and when he heard this, he bound the women to keep the matter a close secret lest he should lose the sovereignty of Alba at the hands of the Dal Riada should they become aware of the affair. Thereupon, he sent for Brandubh; and they both formed a friendly alliance; and Aodhan left the country without inflicting injury on it. However, the Brandubh who was king of Leinster was not a son of this Eochaidh son of Eanna Cinnsealach, as will clearly appear in the second book of this history.


As to Niall, of whom we are treating, numerous are his descendants in Ireland sprung from his eight sons. But we shall not enumerate them here, because we intend to speak of them at length in the genealogy of the sons of Milidh. Now this king is called Niall Naoighiallach, from his having received nine hostages or nine captives, five of them 


---

p.413




from the provinces of Ireland, and four from Alba; and it was on this subject that the poet composed the following stanzas:


> 1. Son of the noble Eochaidh of honour
>   
> Was Niall, modest in each high distinction;
>   
> He held the sovereignty of successions
>   
> In Erin and in Alba.
> 2. He got a hostage from each province
>   
> In Erin through high valour;
>   
> He brought under his sway, without blemish,
>   
> Four hostages from Alba.
> 3. Hence he was called
>   
> In the mansions of the great,
>   
> Through the gold of the prosperous kings,
>   
> Niall of the nine hostages, the heroic.
> 




Dathi son of Fiachraidh, son of Eochaidh Muighmheadhon, son of Muiredhach Tireach, son of Fiachraidh Sraibhthine, son of Cairbre Lithfeachair, son of Cormac, son of Art Aoinfhear, son of Conn Ceadchathach of the race of Eireamhon, held the sovereignty of Ireland twenty-three years. Fial daughter of Eochaidh, from whom is named Cruachan Feile, was his first wife. His second wife was Eithne daughter of Orach and mother of Oilill Molt. His third wife, Ruadh daughter of Airteach Uichtleathan son of Fear Congha, was mother of Fiachraidh Ealgach; and she died in bringing him forth. Fearadhach was his proper name at first; and he was called Dathi, for dathi} means ‘quick’; and it was because of the quickness with which he put on his armour that he was called Dathi. And the manner in which Dathi was slain was this: a flash lightning descended from heaven on his crown when he was engaged in conquering France; and it was near the Alp mountains he was slain by the vengeance of God, since he had pillaged the penitentiary of a holy hermit called Parmenius who cursed him. And when he was slain in this manner, his friends brought his body to Ireland and buried it in Roilig na Riogh at Cruachain.


End of the First Book.


---

p.3


HISTORY OF IRELAND
------------------

I
-


#### Of the kings of Ireland and of their history after the Faith and of its annals 
to the coming of the Normans hither, and to their acquiring supremacy over the country, as follows:


**Sanderus** says in the first book on the English Schism that the Gaels, immediately on their accepting the Faith, put themselves and all they had under the power and government of the Bishop of Rome; and that they had no other chief prince over them but the Bishop of Rome until the Normans gained the supremacy of Ireland. These are the authors words: *The Irish, (says he,) immediately on their accepting the 
Faith, put themselves and all they had under the obedience and government of the Bishop of Rome, and they 
did not acknowledge any other chief prince over Ireland but the Bishop of Rome until that 
time, {Hiberni initio statim post *Christianum* Religionem acceptam se suaque 
omnia in Pontificis Romani ditionem dederant, nec quemquam alium supremum principem Hiberniae ad illud usque 
tempus praeter unum Romanum Pontificem, agnoverant.}’’*

 that is, until the Norman Invasion. But this statement of Sanderus is not true, as is plain from the Psalter of Cashel, where it speaks of Irial Faidh, son of Eireamhon, and where it gives the number of the kings of the race of Eireamhon who ruled Ireland before Patrick planted the Faith in Ireland and afterwards. Irial Faidh ruled the kingdom of Ireland ten years, and before the rule of Christ was planted by Patrick in Ireland fifty-seven kings of the stock of that king held the sovereignty of Ireland; and 


---

p.5




moreover, there were fifty kings of the descendants of the same man ruling the kingdom of Ireland after 
Patrick.’’ {Írial propheta per decem annos regnavit, et antequam regula Christi per 
Patricium seminata esst in Hibernia, de semine eiusdem Regis quinquaginta septem reges regnaverunt super 
Hiberniam, et post Patricium de prole illius quinquaginta reges.} And this is plain from the ancient 
annals of Ireland and from the Reim Rioghruidhe.
Thus does the Polycronicon treat of the same matter where it says: *From the coming of Patrick to the time of king Feidhlimidh (i.e., king of Munster), there were thirty-three kings on the throne of Ireland in the space of four hundred years. And in the time of Feidhlimidh the Fionnlochlonnaigh, who are called Norwegians, together with their leader Turgesius, came to Ireland. {Ab adventu Sancti Patricii usque ad Feldemidii Regis tempora triginta tres reges per quadringentos in Hibernia regnaverunt; tempore autem Feldemidii Noruaegienses duce Turgesio terram hanc occuparunt}’’*

 From this it is to be inferred that there were kings over Ireland of the Gaelic race after the time of Patrick. And the same author uses these very words in the same place, *From the time of Turgesius to the last king Ruaidhri, king of Connaught, there were seventeen kings over Ireland. {A tempore Turgesii usque ad ultimum monarchum Rodericum Conatiae Regem septemdecem reges in Hibernia fuerunt.}’’*
From all these facts it is plain that it is not true to say that there was no king over Ireland from the 
time of Patrick to the Norman Invasion. And with this agrees what we read in the thirty-sixth epistle 
written by St. Anselmus, archbishop of Canterbury, in which he writes to Muircheartach O'Briain, king of 
Ireland, as we read in Doctor Ussher in the gleaning he has made of the letters written to one another by the 
holy clerics of Ireland and of England, and according to the same author, where Anselmus writes to the same 
Muircheartach in the year of the Lord 1100, where he says, *Anselmus, servant of the Church of 
Canterbury, to the glorious Muircheartach by the grace of God king of Ireland, {Moriardacho 
glorioso gratia Dei Regni Hiberniae, Anselmus servus Ecclesiae Cantuariensis.}’’*

; and as Lanfrancus, archbishop of Canterbury, writes to Toirrdhealbhach O Briain, king of Ireland, in the year of the Lord 1074, according to Doctor 


---

p.7


*Ussher* in the passage we have quoted: *Lanfrancus a sinner and 
unworthy archbishop of the holy Church of Dorobernia, benediction with service and prayers to 
Toirrdhealbhach, king of Ireland. {Lanfrancus peccator et indignus Dorobernensis Ecclesiae 
archiepiscopus magnifico Regi Hiberniae Terdeluaco benedictionem cum servitio et orationibus.}’’*
The truth of the same position is strengthened by what we read in the forty-first letter in the same 
book, where Henry the First of England writes to Radulphus, archbishop of Canterbury, asking him to give 
orders to a priest called Gregorius and consecrate him bishop in Dublin by the direction of the king of 
Ireland. *Here are* the words of the English king in the year of the Lord 
1123: *The king of Ireland in writing, and the burgesses of Dublin have made known to me that they have elected this Gregorius bishop, and have sent him to thee to be consecrated. Therefore, I command thee to 
grant their petition and to perform his consecration without delay. {Mandavit mihi Rex Hiberniae 
per breve suum et Burgenses Dublinae quod elegerunt hunc Gregorium in Episcopum et eum tibi mittunt 
consecrendum. Unde tibi mando ut pettioni eorum satisfaciens eius conscreationem sine dilatione 
expleas.}’’*


From all we have said it is plain that it is not true to say that there was neither king nor chief ruler 
over Ireland until the Norman Invasion; and it is moreover plain that the Roman Pontiff had never definite 
authority over Ireland any more than he had over Spain or France or other countries until the time of 
Donnchadh, son of Brian Boraimhe, who went to Rome about seventy-seven years before the Normans came to 
Ireland. But when Donnchadh, son of Brian, went to Rome, as we have said above, himself and the nobles of 
Ireland consented to the Bishop of Rome's having authority over them, because they were wont to contend with 
one another for the mastery of Ireland. For, although authors generally write that the Emperor Constantine, 
after his baptism, bestowed the islands of western Europe on Pope Sylvester, that did not give the Pope 
possession of Ireland, since no emperor that was ever in Rome, nor Constantine, had possession of Ireland. 


---

p.9




How, then, could there be any force in the right which the emperor might give to the Pope, to what was 
neither in his own possession nor in that of any emperor that succeeded him since? And hence, it is not to 
be supposed that so large a kingdom as Ireland -Doctor Sanderus notwithstanding- would have no 
high chief or high king over it from the time of Patrick to the Norman Invasion, but the Pope alone.


Before we speak of the kings of Ireland after the Faith, we shall set down here from the seanchus the 
manner in which kings were inaugurated in Ireland, and for what object they were inaugurated, including high 
kings and provincial kings and territorial high chiefs. Know that formerly in Ireland the only title the 
territorial chiefs had was that of king, as was the custom among the Jewish nation (except that the Jewish 
nation had dukes), and amongst many other nations; thus the Dal Riada in Scotland had a leader, taoiseach 
until Fearghus Mor, son of Earc, was made king over them.


Now, the reason why one person is made king over tribes and over districts is in order that each one in 
his own principality should be obedient to him, and that none of them should have power to resist or oppose 
him during his sovereignty, an to have it understood that it was by God who is Lord and ruler over all that 
he has been appointed king over the peoples to govern them, and hence that they are bound to obey him and to 
bear in mind that it is the same only God who is Lord of heaven and of earth and of hell that gave him that 
authority, and that it was from Him he obtained sovereignty; and frequently it was the cleverest and most 
learned people in Ireland who were chosen to reign, to repress evil, to adjust tribute, to make treaties of 
peace, such as Slainghe, son of Deala, son of Loch, who was chief judge in Ireland in his time, Ollamh 
Fodla, who was learned, and Tighearnmhus, his son, who was likewise 


---

p.11




well-informed, and Cormac, son of Art, who was learned in the Breitheamhnas Tuaithe and who wrote the 
Instruction for Kings; and thus in the beginning of the ages it was the learned and those who were most 
zealous for the aggrandisement of the public weal that the men of Ireland elected to rule the districts 
until Patrick came with the power of the Church. And since the coming of Patrick, it was the bishops and the 
nobles and the chroniclers who elected the kings and lords until the Norman Invasion; and the titles that 
are in use now, as baron, viscount, earl, marquess, or duke, were not in vogue in Ireland, but triath (chief), tighearna (lord), flaith (prince) or ri (king), and they were surnamed from the districts they possessed.


Now, on the occasion of their being inaugurated, the chronicler came forward bearing the book called the 
Instruction for Kings, in which there was a brief summary of the customs and laws of the country, and where 
it was explained how God and the people would reward the doing of good, and the punishment that awaited the 
king and his descendants if he did not carry out the principles of justice and equity which the Book of 
Kings and the Instruction for Kings direct to put in practice.


Often also some of them had to give sureties from amongst their friends for the carrying out of the laws 
of the country in accordance with the Instruction for Kings, or else to forego the sovereignty without a 
struggle, as the Tuatha De Danann might take sureties from Breas, son of Ealathan, on the occasion of giving 
him the sovereignty of Ireland.


It was the chronicler's function to place a wand in the hand of each lord on his inauguration; and on 
presenting the wand he made it known to the populace that the lord or king need not take up arms thenceforth 
to keep his country in subjection, but that they should obey his wand as a scholar obeys his master. For, as 
the wise scholar 


---

p.13




loves and obeys and is grateful to his master, in the same way subjects are bound to their kings, for it is 
with the wand of equity and justice he directs his subjects, and not with the edge of the weapon of 
injustice.


The wand which the **ollamh** places in the king's hand is altogether white, as a token 
of truth as symbolised by the whiteness of the rod, since whiteness is likened to truth, and blackness to 
falsehood.


The reason why the wand is straight is to signify to the people and the tribes that the king is bound to 
be straight and faultless, without bias in his words and judgments between friends and enemies, between the 
strong and the weak, as if there were a contention between both his hands.


The reason it is ordained that the wand be without knot or excrescence, but be altogether smooth, is to 
signify to the people that the lords are bound to be free from unevenness or roughness in dealing justice 
and equity to all, to friend and enemy, according to their deserts, etc.


It was at Tara on Leic na Riogh that every one of the kings of Ireland who possessed the kingdom of all 
Ireland, by the consent of the **ollamhs** and of the nobles, used to be inaugurated before the Faith, and by 
the consent of the Church and of the **ollamhs** ever since the Faith.


It was at Tulach Og that O Neill was inaugurated, and it was O Cathain and O Hagain who inaugurated him; 
O Donnghaile was his marshal of the hosts and muinntir Bhrislein and clann Biorthagra were the 
**brehons** of **feineachas** of all Ulster.


At Cill Mic Creannain O Domhnaill was inaugurated, and it was O Fiorghail who inaugurated him, and O 
Gallchubhair was his marshal of the hosts.


At Magh Adhar O Briain was inaugurated; it was Mac na Mara who inaugurated him. O Duibhidhir of Coill na 
Manach and Mag Cormain were his marshals of the hosts; 


---

p.15




muinntear Flannchuidhe were his **brehons** of **feineachas**; clann Chraith his **ollamhs** in poetry; clann Chruitin or clann Bhruaideadha his **ollamhs** in **seanchus**.


On Lios Beannchair Mac Carrtaigh was inaugurated. It was O Suilleabhain Mor and O Donnchada Mor who 
inaugurated him. Muinntear Ruairc were his marshals of the host; clann Aodhagain were his **brehons**; muinntear Dhalaigh were his **ollamhs** in poetry, and muinntear 
Dhuinnin were his **ollamhs** in **seanchus**.


On Cnoc an Bhogha Mac Murchadha was inaugurated; and it was O Nuallain who inaugurated him; his steed and 
trappings for O Nuallain. O Deoradhain was his **brehon** and Mac Eochadha his 
**ollamh** in poetry.


On Leac Mic Eochadha the lord of Ui Cinnsealaigh was inaugurated, and it was Mac Eochadha who inaugurated 
him.


On Dun Caillighe Beirre O Brain was inaugurated, and it was Mac Eochadha who inaugurated 
him.


II.
---


#### On the kings of Ireland after the Faith as follows:


Laoghaire, son of Niall Naoighiallach, son of Eochaidh Muighmheadhon, son of Muireadhach Tireach, son of 
Fiacraidh Sraibhthine, of the race of Eireamhon, held the sovereignty of Ireland thirty years; and his 
mother was Rioghnach; and it was in the fourth year of his reign that Pope Coelestinus sent Patrick to 
Ireland to plant the Faith, in the year of the Lord 431 and Patrick was sixty-one years of age then. For 
when he was taken into captivity in the ninth year of the reign of Niall his age was sixteen years, and he 
lived the remaining eighteen years of the reign of Niall, so that he was thirty-four years at the close 


---

p.17




of that reign. Add to this the twenty-three years Dathi held the kingdom of Ireland, and it leaves Patrick 
fifty-seven years when Dathi was slain. Add four years of Laoghaire's reign to this, and it gives sixty-one 
years as Patrick's age on his coming to Ireland. And this is rendered the more probable, as we read in the 
book called the Roman Martyrology that Patrick's age was six score and two years at his death. This is 
equivalent to saying that he had completed his sixty-first year when he came to Ireland as bishop. For it is 
certain that he spent sixty-one years in planting the faith in Ireland before his death. But before 
Patrick, Coelestinus sent Paladius as bishop to plant the Faith in Ireland in the year of the Lord 430, 
according to Beda in the annals of the History of Sacsa. Thus does he speak: *In the year of the Lord 
430 Pope Coelestinus sent Paladius as first bishop to the Scots who believed in Christ. {Anno 
quadringentesimo tricesimo Paladius ad Scotos in Christum credentes a Coelestino Papa primus mittitur 
episcopus.}’’*

 And that was the third year of the reign of Laoghaire and the year before Patrick came to 
Ireland. And when he reached Ireland with twelve clerics he landed in the lower part of Leinster at Innbhear 
Deaghaidh, and blessed three churches there, to wit, Ceall Fine, where he left his books and a portion of 
the relics of Paul and Peter; the second church, the House of the Romans, and the third church, Domhnach 
Arda. And when he had blessed these churches, Nathi, son of Garrchon, lord of that country, came and 
banished him from that district, and he went to Alba and died there.
As to Patrick, he came to Ireland a year after Paladius, with twenty-four holy clerics, or, according to 
Henricus Antisiodorensis in the life of St. Germanus, as we read in the 168th chapter. Patrick brought 
thirty bishops with him to Ireland. Here are the author's


---

p.19




words: *Blessed Patrick, (says he,) having come a long journey and from a distant country, first 
gladdened his own people by his presence, and having got together thirty bishops, whom he himself had 
consecrated beyond the seas, he sent them into the Lord's harvest, for the harvest was great and the 
labourers few. {Benedictus Patricius itinere longo de regione longinqua peracto, praesentia sui 
suos exhilarabat et triginta episcopos ex transmarinis partibus congregatos et a se consecratos in Dominicam 
messem, eo quod esset multa et operarii pauci, destinabat.}’’*

 From this it is to be inferred that a number of prelates came with Patrick to Ireland to plant the Faith.
Moreover, we read in the seanchus that when Patrick was coming to Ireland he brought hither with him as 
many as he could find of the Scotic race who had received the light of the Faith; and learning and faith and 
law were maintained in Ireland for four hundred years after the coming of Patrick until the coming hither of 
the Lochlonnaigh. Besides, silver was struck at Ard Macha and at Cashel at that time. Henricus above says in the 174th chapter that Patrick made an apportionment of Ireland, as to land, people and cattle, and that he set aside a tithe of these for the Church, to wit, a tithe of the people, the land, and the cattle, and made monks of the men and nuns of the women, and built monasteries for them. Thus does the same author speak referring to these people who formed the tithe: *He made monks of all the men and nuns of the women, and he built many monasteries and he set apart a tithe of the land and a tithe of the cattle for their maintenance. {Omnes ergo mares monachos, feminas sanctimoniales, efficiens, numerosa monasteria aedificavit, decimamque portionem terrarum ac pecudum eorum sustentationi assignavit.}’’*


The same author also says that as a result of the regulation laid down by Patrick, there was not a nook 
or corner or desert in Ireland that was not full of pious persons and of saints, so that it came to pass 
that the name by which Ireland was distinguished among the nations in general was the Island of Saints. 
Nennius, a British author, in the History of Britain, speaking of Patrick, uses these 


---

p.21




words: *He built, (says he,) 355 churches, he consecrated the same number, 355, of bishops, and he 
ordained priests to the number of three thousand. {Ecclesias 355 fundavit, episcopos ordinavit eo 
numero, 355, presbiteros autem usque ad tria millia ordinavit.}’’*

 Thus does the seanchus agree with Nennius as to the number of bishops consecrated by Patrick: 


> 1. Five and fifty learned bishops
>   
> Did the holy man consecrete,
>   
> With three hundred young clerics
>   
> On whom he conferred orders.
> 


Should anyone be surprised at there being so many bishops together in Ireland in the time of Patrick, 
let him read what St. Bernard says in the life of Malachias of the custom of Ireland regarding her bishops. 
Thus does he speak: *Bishops are changed and multiplied at the will of the archbishop, so that a single diocese is not content with a single bishop, but they have almost a bishop for each church. 
{Mutantur et multiplicantur Episcopi pro libitu Metropolitani, ite ut unus episcopatus uno non esset 
conentus, sed singulae pene ecclesiae singulos haberunt episcopos}’’*

 From these words of St. Bernard it 
is to be inferred that it is not strange that so great a number of bishops as we have mentioned should be in 
Ireland in the time of Patrick, as the Church was then flourishing. The number of bishops we have above 
mentioned is the less to be wondered at, since we read in old books that there was a bishop in Ireland for 
every deanery in the country.
Moreover, it is certain from the Irish annals that Patrick made two archbishops in Ireland, to wit, the 
archbishop of Ard Macha the primate of Ireland, and the archbishop of Cashel; the primate of Ard Macha being 
over all Ireland and especially over Leath Cuinn, and the archbishop of Cashel directly over Leath Mogha, 
while the primate had higher authority over him. And the reason of that arrangement was that the supreme 
sovereignty of Ireland was in the possession of the race of Eireamhon, being in the possession of Laoghaire, 
son of Niall; and Eoghan and 


---

p.23




Conall and the other nobles of that race, who were baptized by Patrick, insisted that the principal church 
in the kingdom should be in their own half of Ireland, to wit, in Leath Cuinn, and that it should have 
authority over the churches of Ireland after the manner of the supreme sovereignty which was then in their 
possession. As to the race of Eibhear, they were permitted by Patrick to found the second principal church 
in Leath Mogha, namely, in Cashel, because to them belonged Leath Mogha under the king of Ireland from the 
time of Conn up to then. This should with the greater reason be believed from the fact that the archbishop 
of Cashel is called not only archbishop of Munster, but also archbishop of all Leath Mogha in the old books 
of chronicles and annals of Ireland.


But as regards another statement made by some writers of the present time that Imleach Iobhair was the 
seat of an archbishop, it is to be understood in this way: the archbishop and the clergy of Cashel were for 
a time banished from Cashel in these days, through the oppression of the Lochlonnaigh, when Maoilseachlainn, 
son of Maolruanaidh, was king of Meath, and Niall Caille king of Ireland, and Olchobhar king of Munster, and 
while Turgesius the Lochlonnach tyrant was harassing Ireland. For the expulsion of Forannan, primate of 
Ireland, from Ard Macha by Turgesius, so that he was forced into banishment in Munster, was not a more 
likely event than that the archbishop of Cashel and his clergy should be driven from Cashel by the 
Lochlonnaigh, and should betake themselves for refuge to Imleach Iobhair, where there were then woods and 
bogs and morasses. And there did they spend some of their time while they were subject to the persecution of 
the Lochlonnaigh.


We find in the annals of Ireland only mention of two archbishops being in Ireland, to wit, the archbishop 
of Ard Macha and the archbishop of Cashel, down to the time 


---

p.25




when Cardinal Johannes Papiron came to Ireland together with Giolla Criost O Conairce, bishop of Lios Mor, 
then the Papal legate in Ireland, in the year of the Lord 1152. For in that year they convened a National 
Council at Ceanannus na Midhe, in which an archbishop was consecrated for Ath Cliath and an archbishop for 
Tuam, and where each of the archbishops received a pallium, as we shall hereafter set down from the ancient 
annals of Ireland which were written at Cluain Eidhneach.


III.
----


While Patrick was planting the Faith in Ireland in the time of Laoghaire, Aonghus, son of Natfraoch was 
king of Munster, and when Patrick proceeded to Munster to preach, this Aonghus, son of Natfraoch, came to 
Magh Feimhean in the northern Deise to welcome him, and conducted him to the royal residence of Cashel in 
Eoghanacht, which is now called Middlethird, and there Aonghus accepted faith and baptism from him. Thus 
speaks an old Life of Patrick which we quoted above in treating of Niall: *As he was going into Munster, Aonghus, son of Natfraoch, king of Munster, came to meet him to Magh Feimhean in the country of the Deise, and joyfully conducted him to the royal seat which is called Cashel in the district of Eoghanacht, and there king Aonghus believed and was baptized. {Dum vero in Momoniam proficisceretur, venit obviam ei 
Rex Momoniae, Aonghus mac Natfraoich in campo Feimhean in terra na nDéise, eumque duxit gaudens in 
civitatem regalem nomine Caiseal, quae est in regione Eoghanacht, ibique credidit rex Aonghus et baptisatus 
est.}’’*

 And in the same passage it is stated that it was through the foot of Aonghus that St. Patrick 
drove the point of his crozier. Here is what we read therein: *As St. Patrick was standing and giving a blessing to the king, he drove the point of his blessed crozier into the king's foot. {Cumque 
Sanctus Patritius regem stando benedixisset cuspis baculi Sancti fixa est in pede regis.}’’* From this it is to be inferred that it was through the foot of Aonghus, son of Natfraoch, king


---

p.27




of Munster, that Patrick drove the point of his crozier, and not through the foot of Eoghan, son of Niall, 
king of Ulster. Even a learned seancha of Leath Cuinn, to wit, Torna, son of Muiris O Maolconaire, agrees 
with the above in a poem beginning, The bishop's blessing on the race of Eibhear. Thus does 
he speak:


> 1. Through the foot of Aonghus, great the discomfort,
>   
> Went the point of Patrick's crozier;
>   
> So that the floor was covered with his blood,
>   
> The deed is no whispered gossip.
> 


This Aonghus had twenty-four sons and twenty-four daughters, and of these he gave twelve sons and twelve 
daughters to the Church. It was this Aonghus also who imposed Patrick's capitation 
**screaball**, that is, three pence for each person who should receive baptism in Munster, and this tax was paid in the following manner, to wit, five hundred cows, five hundred balls of iron, five 
hundred mantles, five hundred inner garments and five hundred sheep to be given every third year to the 
**comhorba** of Patrick as rent from the kings of Munster. And this rent was paid up to the time 
of Cormac, son of Cuileannan. Moreover, we read in the Red Book of Mac Aodhagain that Aonghus, son of 
Natfraoch, used to keep in constant attendance on himself two bishops and ten priests and seventy-two young 
clerics for the purpose of saying Masses and of Divine prayer.


When Patrick was planting the Faith in Ireland in the time of Laoghaire, Brian, son of Eochaidh 
Muighmeadhon, had twenty-four sons, who were contemporaries of Laoghaire, son of Niall; and as Patrick was 
blessing Ireland he went into Connaught and went to meet the son amongst them who was their leader, whose 
name was Eichen. When this man saw Patrick coming into his presence he mounted his horse and proceeded to 
lash it, and directed his brothers to do likewise and not to show reverence to the 


---

p.29




cleric; and they acted accordingly, except the youngest son, whose name was Duach Galach. This man kept on 
foot, and advanced to meet Patrick and bade him welcome and paid him homage and respect. Upon this Patrick 
went forward and came into the presence of Eichen, who was their leader, and asked him if he were not 
Eichen. ‘I am not,’ said Eichen. ‘If thou beest,’ replied Patrick, ‘I deprive of success and of 
sovereignty both thee and as many of they brothers as are with thee, except the one youth who paid me 
reverence and honour for my Lord's sake.’ And that youth said if he were king over them he would do 
Patrick's bidding. ‘Then,’ said Patrick, ‘I bless thee, and thou shalt be king, and thy seed shall 
have the kingdom after thee.’ And Patrick's prophecy came true, for Patrick with twelve bishops attended 
at the inauguration of Duach Galach as king, and it was the custom with the kings of Connaught ever since to 
have the **comhorbas** of these twelve bishops and twelve chiefs of the race of Muireadhach 
and Ui Maolconaire at their inauguration on the hill called Carn Fraoich.


There were 431 years from the birth of Christ to the coming of Patrick to Ireland in the fourth year of 
the reign Laoghaire, son of Niall, as we have said; and he was sixty-one years in Ireland up to his death, 
and if this number be added to the previous number, we get four hundred and ninety-two years; and in 
testimony of this the seanacha composed this stanza:



> 1. Since Christ was born, pleasant reckoning,
>   
> Four hundred and ninety also
>   
> And two full years added thereto
>   
> Till the death of Patrick our chief Apostle.
> 




We read in the life of Patrick that he passed sixty-one years in Ireland after he had come hither as 
bishop, planting and preaching the gospel and working wonders and 


---

p.31




miracles, as we read in a Life of Patrick by a certain author. Thus does he speak:


> 1. Three score years and one,
>   
> Few there are to whom it is not a mystery,
>   
> In Ireland with many prodigies 
>   
> Did Patrick continue to preach.
> 




And should anyone say that this stanza is not in the Life of Patrick, let him know that we have read in 
an ancient hÌstorical record that there were sixty-four Lives of Patrick written, each of them being 
distinct from the others. And it is likely that each writer wrote something new about Patrick which none of 
the others had written. Hence, one who has read the life of Patrick by one author, must not deem it strange 
if he happen on a story or miracle of Patrick in another book which he did not find in that life.


It was in Laoghaire's time that Dubhthach Ua Lughair and Fearghus File and Ros son of Trichim, brought 
the Seanchus of Ireland to Patrick to be approved and purified by him. And from this it arose that Laoghaire 
was empowered to call a general assembly in which the kings, clerics, and **ollamhs** of 
Ireland should meet for the purpose of purifying the Seanchus. And when they had all come together nine were 
chosen from among them to purify the Seanchus, to wit, three kings, three bishops, and three ollamhs in seanchus. The three kings were Laoghaire, son
of Niall, king of Ireland, Daire, king of Ulster, and Corc, son of Lughaidh, king of Munster. The three 
bishops were Patrick, Beinen and Cairneach. The three **ollamhs** in seanchus were 
Dubhthach, Fearghus and Ros. And these nine men purified and arranged and established the Seanchus, and it 
was this that was called the Seanchus Mor. The poem which begins Aimhirgin Gluingheal confirms this account. Here follow the stanzas from the poem that bear out this account: 


> 1. The authors of the Seanchus Mor
>   
> Were nine who set it in order rightly,
>   
> Naoimhfhios is its fair noble name,
>   
> By reason of the sacred learning of that nine.
> 
> 
> ---
> 
> p.33
> 
> 4. Patrick, Beinen, noble *Cairineach*,
>   
> Laoghaire, son of Niall the strong.
>   
> Fearghus File, laughter pure,
>   
> And Daire king of Ulster.
> 5. And the king of Munster without stain,
>   
> Corc, son of Lughaidh of the red hand,
>   
> Dubhthach Ua Lughair of the lake,
>   
> The professor of language, Ros son of Trichim.
> 6. Nine sages, of wise aspect,
>   
> By whom the Seanchus was set in order
>   
> After they had examined it with excellent skill
>   
> Through every generation from Aimhirgin.
> 




IV.
---


Now when the Seanchus had been purified in this way the nobles of Ireland decreed that the charge of it 
should be entrusted to the prelates of Ireland, and these prelates ordered that it should be copied in their 
own chief churches. And some of the old books are still extant, or the copies made from them, such as the 
Book of Ard Macha, the Psalter of Cashel, the Book of Gleann da Loch, the Book of Ui Congmhala, the Book of 
Cluain Mic Nois, the Book of Fiontan of Cluain Eidhneach, the Yellow Book of Moling and the Black Book of 
Molaga, and the rest of the chief books of Ireland where the Seanchus was preserved without doing injustice 
to any one Irish noble as against another.


Moreover, there was a summary of the records in all these books in the Psalter of Tara, and they used to 
be approved every third year at the **Feis of Tara**, as we have said above in treating of the reign of Cormac. 
But in the pagan period the following were the chief authors of the Seanchus from age to age, to wit, 
Aimhirgin Gluingheal, Sean son of Aighe, Bridhe an authoress, from whom is the expression 
*Briathra Bridhe* *the sayings of Bridhe*.


---

p.35




Connla Caoinbhriathrach a Connaught sage, Seancha son of Cuil Claon, Fachtna his son, Seancha son of Oilill, 
Morann son of Maon, Fearghus Fiannaithe from the country of Ciarraidhe Luachra, Feircheirtne File, Neidhe 
son of Adhna, Aithirne, Amhnas, Fearghus File son of Aithirne, Neara son of Fionncholl from Siodha, 
Seadhamus son of Morann, Fearadach Fionn Feachtnach chief author for skill in Ireland, Fitheal, Fearghus 
File, Ros son of Trichim, and Dubhthach son of Ua Lughair, and it was this last trio who brought the 
Seanchus to Patrick to be approved and purified.


Now in Pagan times in Ireland no professor of seanchus could rank as an **ollamh** or 
author in seanchus who had been known once to falsify historical truth. Moreover, no one could hold the rank of **breitheamh** who had given a partial judgment; and besides some of them were bound by **geasa** in the Pagan times. First, when Sean, son of Aighe, delivered a partial judgment, blisters grew on his right cheek, and when he delivered a just judgment they did not grow.


Connla Caoinbhriathrach never delivered an unjust judgment, for he was a virtuous truly upright man 
according to the light of nature; Seancha son of Cul Claon never gave judgment without having fasted the 
night before. When Fachtna, his son, delivered an unjust judgment, if it was in the autumn he delivered it, 
the fruit fell to the ground that night in the country in which he was. But when he delivered a just 
judgment, the fruit remained in full on the trees; or if in the spring he delivered an unjust judgment, the 
cattle forsook their young in that country. Morann son of Maon gave no judgment without having the Morann 
collar round his neck, and when he gave an unjust judgment the collar grew tight round his neck, and when he 
gave a just judgment the collar stretched out over his shoulders, as we have said above. And so it was with 
several Pagan authors, they were subject to **geasa**, preventing 


---

p.37




them from partiality in history or judgment. From what we have said, the Irish records are to be believed 
like the records of any other country, seeing that they are borne witness to by the writings of old Pagan 
authors and by their having been approved by the holy clerics and prelates of the Irish Church.


Laoghaire, son of Niall, convened the **Feis of Tara** to renew the customs and the laws of Ireland, as the 
kings who went before him were wont to do at that Feis. Now when the nobles and the 
**ollamhs** of Ireland came together in that assembly the high king of Ireland and his party had a separate chief residence, to wit, the Teach Miodhchuarta. Each provincial king in Ireland had also a chief residence, to wit, the king of Munster had the Long Mhuimhneach; now long means 
house, as the poet says:



> 1. Not more inhospitable is Donn Cuan
>   
> With a bad house for his people than with a full house;
> 




and hence a village where people dwell is called a longphort, that is, the port or embankment of the houses; and the king of Leinster had the Long Laighneach, and 
the king of Connaught the Coisir Chonnachtach, and the king of Ulster the Eachrais Uladh. There were besides 
three other residences at Tara at that time, to wit, Carcair na nGiall, where the hostages or captives of 
the king were kept. The second was called Realta na bhFileadh, where the **brehons** and 
bards of Ireland assembled to fix a tax on those who violated the laws and customs of the country. The third 
house was called Grianan na nInghean, where the provincial queens dwelt, each of these queens with her 
female attendants having a separate place in the dwelling. But when the entire assembly sat for the purpose 
of determining and completing the laws and customs of the country, the great Teach Miodhchuarta was their 
hall of public debate.


Now they were arranged in that hall in this manner. First the king of Ireland himself sat in his royal 
chair in 


---

p.39




the very middle of the hall facing westwards, with the king of Munster to the south of him, for the ends of 
the house looked east and west, the king of *Leinster* opposite to him, 
and the king of Connaught behind him, and the **ollamhs** of Ireland behind the king of Connaught,and the king of Ulster to the north of him at his right hand, while each king had a party of real nobles of his own province beside him. Here is a pithy account by the **seancha** of these rules of precedence observed in the hall of Tara: 



> 1. The Munstermen on the south side,
>   
> Without falsehood, without injustice;
>   
> And the Leinstermen, sufficient in strength.
>   
> Face to face with the high king.
> 2. The Connaughtmen behind the king,
>   
> To preserve history truly;
>   
> The under king of Aruidhe near him
>   
> In a special high seat,
> 3. On the right of the king of mighty Tara,
>   
> Without falsehood, without churlishness,
>   
> The Oirghialla, a defence were they,
>   
> Without overlapping, without strife.
> 




It was against Laoghaire that the Leinstermen and Criomhthann, son of Eanna, fought the Battle of Ath 
Dara, wherein Laoghaire was made prisoner by them, and he gave the sun and moon and stars as sureties that 
he would fulfil his promise not to exact the Boraimhe from them; but he did not fulfil this promise in their 
regard. However, to avenge this falsehood Laoghaire was soon afterwards killed by a lightning flash at 
Greallach Dabhaill beside the Lithfe, as the poet says:



> 1. Laoghaire, son of Niall, died
>   
> Beside Lithfe, green its land,
>   
> The elements of God whose guarantee he had violated 
>   
> Inflicted the fate of death on the king.
> 




Anghus, daughter of Tasach, king of Ui Liathain, was Laoghaire's wife and the mother of Lughaidh, son of 


---

p.41




Laoghaire, and, unlike Laoghaire, she received the faith from Patrick. Now, on a certain day when Patrick 
went to visit the queen she bade himself and his company of clerics welcome, and ordered food to be prepared 
for them; and Lughaidh, son of Laoghaire, her son and heir, set to eating the meal with them greedily, and a 
portion stuck in his throat which choked him, and he died on the spot. The queen gave a start, and committed 
the youth to Patrick's protection. Patrick went into an unoccupied house and ordered the child's body to be 
brought to him, and prayed to God with fervour, and continued thus in constant prayer without food or sleep 
for three days, and at the close of the third day Michael the Archangel, in the form of a dove, appeared 
before him in the house in which he was, and he greeted Patrick and said it was God's will that the child be 
brought back to life through Patrick's intercession. Upon this, as the child lay on his back with his mouth 
open, the Archangel, who was in the form of a dove, went and put his bill into the child's throat and took 
out the morsel, and thereupon life came to him at once. And immediately on this the angel became invisible 
to them, and the child Lughaidh arose. And when the queen heard that the child was alive, she came joyfully 
to meet Patrick and cast herself on her knees before him, and proceeded to thank him for bringing her son 
back to life. ‘O princess,’ answered he, ‘it is not I whom thou shouldst thank for thy son, but 
Michael the Archangel, by whom he was brought back to life.’ And he told her the story in substance as we 
have given it. When the queen heard that it was Michael the Archangel who brought back her son to life, she 
bound herself to give a sheep out of every flock she possessed each year and a portion of every meal she 
should take during her life to the poor of God in honour of Michael the Archangel; and, moreover, she 
enjoined this as a custom throughout Ireland on all who received baptism 


---

p.43




and the Faith from Patrick, whence is the custom of the Michaelmas sheep and the Michael's portion in 
Ireland ever since.


Oilill Molt, son of Dathi, son of Fiachraidh, son of Eochaidh Muighmheadhon, of the race of Eireamhon, 
held the sovereignty of Ireland twenty years. Uichtdhealbh, daughter of Aonghus, son of Natfraoch, was the 
wife of Oilill Molt, and he was called Oilill Molt because of a craving for wether's flesh that his mother 
Eithne, daughter of Oraidh, felt when she was pregnant with Oilill; and a lady who was with her named Fial, 
daughter of Eochaidh Seideadh, called him by the name of Oilill Molt after he was born. It was in the reign 
of Oilill that Amhalghuidh, son of Fiachraidh, son of Eochaidh Muighmheadhon, who was king of Connaught 
twenty years, died, and there died also Muireadhach Muindearg, son of Feargna, son of Dallan, son of 
Dubhthach, son of Mianach, son of Lughaidh, son of Aonghus Fionn, son of Fearghus Duibhdheadach, son of 
Iomchaidh, son of Fionnchaidh, son of Oghamhal, son of Fiatach Fionn, a quo Dal 
bhFiatach, who was twelve years king of Ulster.


V.
--


Oilill Molt convened the **Feis of Tara**. There used to be three general assemblies in Ireland in the olden 
time, to wit, the **Feis of Tara**, the **Feis of Eamhain**, and the **Feis of Cruachain**. We have set down above the things that were treated of at the **Feis of Tara**. Now the chief object for which the **Feis of Eamhain** and the **Feis of Cruachain** were convened was to approve those who practised mechanical crafts in Ireland, such as smithwork, woodwork or stonework and the like handicrafts. And the nobles and **ollamhs** who were at these two assemblies selected from each assembly three score masters of each craft, and these 
were then distributed throughout Ireland, and no fellowcraftsman to these was permitted to practise 


---

p.45




his craft without permission from the master of that craft who was in that district; and the master must 
examine whether he be competent to practise the craft. And these masters were called ioldanaigh; now ioldanach means iolcheardach, or skilled in many crafts, for dan means ceard or craft.


The Leabhar Irsi calls Oilill Molt the king of the Scots. It was in his time that Benignus, the 
**comhorba** of Patrick, died. It was also against Oilill that the Leinstermen fought the Battle of Dumha Aichir, where many fell on both sides. It was about this time that a war was waged between 
Ambrosius, king of Britain, and the Picts and Scots. It was also in the reign of Oilill that Conall 
Creamhthainne died, and Iarlaithe the third bishop of Ard Macha after Patrick. Simplicius was Pope at that 
time. It was against Oilill Molt, king of Ireland, that the Battle of Ocha was fought by Lughaidh, son of 
Laoghaire, and by Muircheartach, son of Earc, and by Fearghus Ceirrbheoil, son of Conall Creamhthainne, and 
by Fiachaidh Lonn, son of Caolbhadh, king of Dal nAruidhe, as the poet says:


> 1. By Lughaidh and by Fiachaidh Lonn,
>   
> And by the great Muircheartach
>   
> And by blameless Fearghus,
>   
> Was the noble Oilill Molt slain.
> 




Twenty years after this battle was fought the six sons of Earc, son of Eochaidh Muinreamhar, went to 
Alba, to wit, two Aonghuses, two Lodharns, and two Fearghuses. Three hundred and seven years are reckoned 
from the time of Conchubhar, son of Neasa, to the time of Cormac, son of Art; two hundred and four years 
from the time of Cormac till the Battle of Ocha was fought; and twenty years after that the sons of Earc, 
son of Eochaidh Muinreamhar, went to Alba. Duach Teangumha, son of Fearghus, son of Muireadhach Mal, son of 
Eoghan Sreibh, son of Duach Galach, son of Brian, son of Eochaidh Muighmeadhon, 


---

p.47




was king of Connaught seven years at this time, and he fell by Eochaidh Tiormcharna.


Lughaidh, son of Laoghaire, son of Niall Naoighiallach, of the race of Eireamhon, held the sovereignty of 
Ireland twenty years. Anghus, daughter of Tasach of Ui Liathain, was the mother of Lughaidh. The king of 
Leinster at that time was Fraoch, son of Fionnchaidh. About this time took place the Battle of Ceall Osnadh 
in Magh Fea in the county of Ceithearlach, four miles east of Leithghlinn, where Aonghus, son of Natfraoch, 
who was king of Munster thirty-six years, and Eithne Uathach, daughter of Criomhthann, son of Eanna 
Cennsealach, his wife, both fell by Muircheartach, son of Earc, and by Oilill, son of Dunluing; hence the 
poet composed this stanza:


> 1. There died the spreading branch of a great tree,
>   
> Aonghus Molbhthach, son of Natfraoch;
>   
> He lost his success by Oilill
>   
> In the Battle of Ceall Osnadh the vile.
> 




After this, Fraoch, son of Fionnchaidh, was slain in the Battle of Graine by Eochaidh, son of Cairbre. 
Felix the third Pope of that name, it was in the tenth year of the reign of Lughaidh, son of Laoghaire, that 
he was made Pope. It was about this time that the Battle of Sleamhain Mhidhe was won by Cairbre, son of 
Niall, over the Leinstermen, and the Battle of Seaghais was fought, in which Duach Teangumha, king of 
Connaught, was slain by Muircheartach, son of Earc, as the poet says in this stanza: 


> 1. The Battle of Dealga, the Battle of Muchromha,
>   
> And the Battle of Tuaim Drubha,
>   
> And also the Battle of Seaghais,
>   
> In which fell Duach Teangumha.
> 




It was about this time that the Leinstermen won the Battle of Lochmhagh over Ui Neill, in which fell many 
people, and Fearghus Mor, son of Earc, went to Alba with the Dal Riada and they assumed sovereignty there. 
It was in the nineteenth year of the reign of Lughaidh, son of Laoghaire, 


---

p.49




that Patrick died, having passed six score and two years in this life, as we have said above. After this 
Lughaidh, son of Laoghaire, died in Achadh Fharcha, from lightning which fell from heaven on him for 
disobeying Patrick. Gelasius was Pope the last year of the reign of Lughaidh.


Muircheartach, son of Earc, son of Muireadhach, son of Eoghan, son of Niall Naoighiallach, of the race of 
Eireamhon, held the sovereignty of Ireland twenty-four years. Earc, daughter of Lodharn king of Alba, was 
the mother of Muircheartach, son of Earc, and it was in the beginning of his reign that Ciaran 
mac-an-tSaoir, who was of the race of Corc, son of Fearghus, son of Rogh, was born. The fourth year of the 
reign of Muircheartach Anastasius the second Pope of that name was made Pope. About this time was born St. 
Comhghall of Beannchair, the holy abbot, a man who had forty thousand monks under his obedience or under his 
authority, as we read in the Red Book of Mac Aodhagan; and this is the more to be believed because we read 
in an author of repute, namely, St. Bernard, in the Life of Malachias, that there was a disciple of the 
abbot Comhghall called Soanus, who built a hundred monasteries; and this Comhghall is of the race of Irial, 
son of Conall Cearnach, son of Aimhirgin, of clanna Rudhruighe. In testimony of this, the poem on 
saint-history speaks thus: 


> 1. Comhghall of Beannchair, son of Seadna,
>   
> Whom fear of death troubled not,
>   
> Was of Uladh's stock, who were not caught napping,
>   
> Of the race of Irial, son of Conall.
> 




It was about this time that the emperor Anastasius died, and Cainneach of Achadh Bo, the saint, and this 
saint was of the race of Fearghus, son of Rogh; and Columcille, son of Feidhlimidh, son of Fearghus, son of 
Conall Gulban, son of Niall Naoighiallach, was born. It was about this time that Brighid, daughter of 
Dubhthach, son of Dreimhne, son of Breasal, son of Dian, son of Connla, son of Art, son of Cairbre Nia, son 
of Cormac, son of Aonghus Mor, son of 


---

p.51




Eochaidh Fionn Fuath nAirt, son of Feidhlimidh Reachtmhar, son of Tuathal Teachmhar, of the race of 
Eireamhon, died, at the age of eighty-seven years, or, according to others, at the age of seventy years. Now 
Brighid is the equivalent to Breo-shaighead, that is, an arrow 
of fire; and she is not inaptly so called, for she was as a fire lighting with the love of God, ever darting 
her petitions towards God. And according to the Feilire, it was she who composed this stanza: 


> 1. A morsel of fair barley bread,
>   
> This is my part of the table.
>   
> A cress-stalk and hot water
>   
> Is my portion each night.
> 




VI.
---


The sixth year of the reign of Muircheartach, son of Earc, Symmachus was made Pope, and he was Pope for 
fifteen years and eight months; and the thirty-first year of the reign of Muircheartach, Hormisdas was made 
Pope, and he was nine years Pope. It was about this time that the holy body of the monk Antonius was 
miraculously discovered, and it was taken to Alexandria, and it was enshrined in the church of John the 
Baptist. Muircheartach, son of Earc, fought the following battles in one year according to what the poet 
says in this stanza: 


> 1. The Battle of Ceann Eich, the Battle of Almhain,
>   
> In a famous glorious time;
>   
> The Plunder of Clu, the Battle of Eibhlinn,
>   
> And the Battle of Magh Ailbhe.
> 




Soon after having fought these battles Muircheartach died in the house of Cleiteach; and Ailbhe of 
Imleach died.


Tuathal Maol Garbh, son of Cormac Caoch, son of Cairbre, son of Niall *Naoighiallach*, of the race of Eireahmon, held the sovereignty of Ireland thirteen 
years. He is called Tuathal Maol Garbh, for Comain, daughter of Dall Bronach, was his mother, and 
when she gave birth to 


---

p.53




Tuathal she struck his head against a stone as a ceremony foreboding success for him, and the stone made a 
hollow in his head, and no hair grew in that hollow; hence he was called Tuathal Maol Garbh.


It was in the reign of Tuathal that Moctaeus, disciple of Patrick, died, and he had lived three hundred 
years; and Baoithin, disciple of Columcille, was born; and Baoithin and Columcille were the children of 
brothers; and Comhghall, king of Alba, died, and Mobhi, who is called Bearchan of Prophecy, of the race of 
Fiachaidh Aiceadha, son of Cathaoir Mor, died. It was also in the reign of Tuathal that the Leinstermen 
fought the Battle of Tortan, where Earc, son of Oilill Molt, was slain, and from him the Fir Cheara sprang. 
It was about this time that the Battle of Sligeach was fought by Fearghus and by Domhnall, two sons of 
Muircheartach, son of Earc, where they slew Eoghan Beal, who was king of Connaught thirty-five years; and 
Odhran, the saint of Leathrach, of the race of Conaire, son of Mogh Lamha, died, and Ciaran mac-an-tSaoir at 
the age of thirty-one years died; and Beoaidh was his father's name, and his mother's name was Dairearca, as 
he himself says in this stanza:


> 1. Dairearca was my mother,
>   
> *No poor woman was she*;
>   
> Also Beoaidh, the artificer, was my father,
>   
> From Latharna Molt.
> 




It was about this time that his head fell off Abacuc at the fair of Taillte, for having sworn falsely by 
the hand of Ciaran; and he lived thus headless four years amongst the monks. After that Tuathal Maol Garbh, 
king of Ireland, was slain by Maol Mor, uterine brother to Diarmaid, son of Fearghus Ceirrbheoil, in 
Greallach Eilte.


It was also in the reign of Tuathal that Guaire, son of Colman, became sovereign of Connaught in 
succession to Eoghan Beal; and at that time the eldest son of Eoghan was a pupil under Ciaran with a view to 
becoming a monk; 


---

p.55




his name was Ceallach, and Eoghan's friends enticed him to quit Ciaran's community that he might be their 
leader in opposition to Guaire. But on Ceallach's going out, Ciaran cursed him and besought God that he 
might be carried off by a violent death. Now, when he had been for some time outside, he considered that he 
had acted amiss in disobeying Ciaran, and he paid Ciaran a visit and acknowledged his guilt to him, and 
promised that he would do his will during his life. Ciaran gave him his blessing, but said that a violent 
death would carry him off. Ceallach remained in the community thenceforwards, and was in course of time made 
bishop; and while he was in the district as bishop he was making partisans and friends for a brother who was 
younger than himself, with a view to his obtaining the sovereignty of Connaught; and when Guaire heard this 
he suborned three of Ceallach's own friends who slew him, and thus the prophecy which Ciaran had made for 
him was fulfilled, for he had foretold that Ceallach would meet a violent death.


Diarmaid, son of Fearghus Ceirrbheoil, son of Conall Creamhthainne, son of Niall Naoighiallach, of the 
race of Eireamhon, held the sovereignty of Ireland twenty-two years. Corbach, daughter of Maine, a 
Leinsterwoman, was the mother of Diarmaid, son of Fearghus. It was in the reign of this king that 
Tighearnach, bishop of Cluain Eoais, of the race of Daire Barrach, son of Cathaoir Mor, and Oilill, son of 
Muireadhach, who was nine years king of Leinster, died. And Cormac, son of Oilill, son of Eochaidh, son of 
Daire Cearb, son of Oilill Flann Beag, was king of Munster.


It was about this time that Fearghus and Domhnall, two sons of Mac Earc, fought the Battle of Cuil 
Chonaire, where Oilill Anbhann, king of Connacht, and his brother, Aodh Fortamhail, were slain; and it was 
in the reign of this Diarmaid that a plague came on Ireland, which was 


---

p.57




called the Crom Chonaill, and many saints died of it, and in particular Mac Tail of Cill Chuilinn. At this 
time the Battle of Cuil took place, where many of the people of Corcach fell through the prayer of Midhe, 
that is, a noble female saint of the race of Fiachaidh Suighdhe, son of Feidhlimidh Reachtmhar, to whom 
these people showed disrespect.


It was at this time that Eochaidh, son of Connlo, son of Caolbhach, son of Crann Badhraoi, son of 
Eochaidh Cobha, son of Lughaidh, son of Rossa, son of Iomchaidh, son of Feidhlimidh, son of Cas, son of 
Fiachaidh Aruidhe, who was king of Ulster twenty-two years, died, and he was the first king of the Dal 
nAruidhe. And Cormac, son of Oilill, king of Leinster, and Beag Mac De, the seer, died, and St. Molua, son 
of Sineall, son of Aimhirgin, son of Eirnin, son of Duach, son of Brian, son of Eochaidh Mogh, was born; and 
Cathfuidh, bishop of Achadh Chuinnire and St. Neasan, the Leper, died; and St. Breanainn, of the race of 
Cear, son of Fearghus, built the Church of Cluain Fearta; and Gabhran, king of Alba, died; and Gruige, son 
of Maolchu, king of the Cruithnigh, defeated and routed the Albanians.


It was about this time that Fearghus and Domhnall, two sons of Muircheartach Mac Earc, won the Battle of 
Cuil Dreimhne over Diarmaid, son of Fearghus, and he was routed and most of his people were slain, through 
the prayer of Columcille. For he had slain, in violation of Colum's protection, Cuarnan, son of Aodh, son of 
Eochaidh Tiormcharna, and God avenged that deed on him in this battle. Aodh, son of Breanainn, king of 
Teathbha, defeated Diarmaid in the Battle of Cuil Uinnseann, in Teathbha, where many of his followers were 
slain; and after this Columcille went to I, in Alba, when he was forty-three years of age; and the Battle of 
Moin Doire, in Alba, was fought by clanna Neill of the North, wherein seven minor kings of the Cruithnigh 
fell by them. It was about this time that 


---

p.59




Colman Mor, son of Cairbre, son of Oilill, son of Dunlaing, who was thirty years king of *Leinster*, died.


It was while Diarmaid, son of Cearbhall, was king of Ireland that a poet of Alba, called Labhan Draoi, 
came to Ireland; and having heard tidings of the generosity of Eochaid Aontsula, ancestor of siol 
Suilleabhain, he came to visit him and ask him for a gift, and he would not accept any gift from him but one 
of his eyes; and Eochaidh gave him one of his eyes lest the druid might satirise him. Ruadhan of Lothra 
happened to be present at the time, and when he heard the unjust request he asked of God to put Labhan's 
eyes in Eochaid's head, and that they might perform the same function for him that they did for Labhan; and 
it came of the saint's petition that Labhan's eyes passed into Eochaidh's head and performed that function 
for him during his life.


VII.
----


The seventh year of the reign of this Diarmaid, king of Ireland, a nun named Sineach Chro came to 
Diarmaid to make a complaint to him against Guaire, son of Colman, for having taken her only cow from her. 
Diarmaid assembled a numerous host with the object of obtaining satisfaction from Guaire for the nun's cow, 
and he at once marched to the Sionainn. Now Guaire had assembled a host and multitude on the other side to 
oppose him, and he sent Cuimin Foda, son of Fiachna, to ask Diarmaid not to go westward beyond the Sionainn 
for the space of twenty-four hours. ‘That is not a great request to grant thee,’ said Diarmaid, ‘and 
a greater would be granted thee had'st thou asked it.’ Now they were on either side of the Sionainn, King 
Diarmaid on the east side and Guaire on the west side until the following morning. ‘I wonder,’ said 
Cuimin, ‘at the smallness of this host of thine seeing how great the host is which is against thee.’ 
‘Understand, O cleric,’ said Diarmaid ‘that a 


---

p.61




battle is not won by large armies, but according to God's will; and if thou contemnest my host, know that it 
is not fair forms but stout hearts that win battles.’


The battle was set on foot between them, the king and his host on one side and Guaire, with the Connaught 
and Munster forces, on the other. But Guaire and his host were defeated, and many Connaught nobles and 
Munstermen were slain. And it was at the intercession of Caimin, who lived and blessed in Inis Cealltrach, 
that the battle went against Guaire; for Caimin fasted three days against Guaire in order that he might lose 
the battle. This St. Caimin is of the race of Fiachaidh Aiceadha, son of Cathaoir Mor. Now Guaire went to 
Caimin and paid him respect and homage and bowed down before him. ‘There is no avoiding defeat in battle 
for thee,’ said Caimin.


Now when Guaire had lost the battle he came alone to a little monastery, in which there was a solitary 
pious woman, and the woman asked who he was. ‘I am *one of 
Guaire's officers*,’ said he. ‘I am very sorry,’ said she, ‘that defeat should have 
overtaken this king, who is the most charitable and humane and hospitable in Ireland, and that his followers 
should be visited with dreadful slaughter.’ The pious woman went to a stream hard by and saw a salmon 
therein. She came back to Guaire with this news. Guaire went out to the stream and killed the salmon, and 
gave God thanks for having only the salmon that night, though he had often ten beeves other nights. Guaire 
went the next day to meet his friends, and took counsel of them as to whether he should give battle again to 
the king of Ireland or swear submission to him on a javelin's point. What Guaire and his friends resolved on 
was that he should go to Diarmaid and make his submission to him. Now the way in which he made his 
submission to him was to put the point of the king's javelin or sword in his mouth, between his teeth, while 
on bended knees. And while Guaire was in 


---

p.63




this position the king said secretly to some of his own people: ‘We will find out,’ said he, ‘whether 
it was through vain glory that Guaire practised such great generosity.’ He caused a druid from among his 
friends to ask him for something for the sake of science, but Guaire did not heed him. He sent a leper to 
ask him for an alms for God's sake; he gave the poor man the gold bodkin that held his mantle. The poor man 
left him; and one of king Diarmaid's people met him and took the gold bodkin from him and gave it to 
Diarmaid. The poor man again came back to Guaire and complained of this to him, and Guaire gave him the gold 
belt that was round him, and Diarmaid's people took the belt also from the poor man; and he came again to 
Guaire, who had the point of Diarmaid's sword between his teeth, and, as Guaire beheld the poor man 
troubled, a flood of tears came from him. ‘O, Guaire,’ said the king, ‘is it distress at being under 
my sway that makes thee thus weep?’ ‘I solemnly declare that it is not,’ said he, ‘but my distress 
at God's poor one being in want.’ Thereupon Diarmaid told him to arise and that he would not be 
thenceforth under his own authority, and that the King of all the elements was over him if he were to make a 
submission, and that he considered that sufficient on his part. They made a treaty of peace with one 
another, and Diarmaid asked him to come to the fair of Taillte, into the presence of the men of Ireland; 
‘and,’ added he, ‘I will give thee my lordship to be thine from my death onwards.’


Guaire then went to the fair of Taillte, having with him a budget or bag of silver to dispense to the men 
of Ireland. Now Diarmaid charged the men of Ireland that none of them should ask anything of Guaire at the 
fair. Two days passed in this manner; on the third day, however, Guaire asked Diarmaid to send for a bishop 
for him that he might make his confession and be anointed. ‘How is that?’ enquired Diarmaid. ‘As I am 
near death,’ 


---

p.65




said Guaire. ‘How dost thou know that?’ asked Diarmaid. ‘I know it,’ said Guaire, ‘for the men 
of Ireland are assembled and none of them asks me for anything.’ Then Diarmaid gave Guaire leave to make 
gifts. Guaire proceeded to make gifts to everyone, and, if the tale be true, the hand with which he made 
gifts to the poor was longer than that with which he made gifts to the bards. Then Diarmaid made peace and 
agreement with Guaire in presence of the men of Ireland, and they were thenceforth on friendly terms with 
each other.


Now Guaire had a brother called Mochua, a holy virtuous man, and on a certain occasion he went to observe 
Lent to a well of spring water, which is a little to the south-west of Buirenn, five miles from Durlus 
Guaire, attended only by one young cleric, who used to serve him at Mass, and neither himself nor the young 
cleric took more than a meal every day-and-night, and then they took only a little barley bread and spring 
water. And when Easter day had come, and Mochua had said Mass a desire for meat seized the young cleric, and 
he said to St. Mochua that he would go to Durlus to visit Guaire in order to get enough of meat. ‘Do not 
go,’ said Mochua, ‘stay with me, and let me pray to God for meat for thee.’ And on this he knelt on 
the ground and prayed with fervour to God, asking for meat for the young cleric. At the same time while food 
was being served to the tables of Guaire's house, it came to pass through Mochua's prayer that the dishes 
and the meat they contained were snatched from the hands of those who were serving them and were carried out 
over the walls of the dwelling, and by direct route reached the desert in which Mochua was; and Guaire went 
with all his household on horseback in quest of the dishes; and when the dishes came into the presence of 
Mochua he set to praise and magnify the name of God, and told the young cleric to eat his fill of meat.




---

p.67


The latter thereupon looked up and saw the plain full of mounted men, and said that it was of no 
advantage to him to get the meat, seeing how many there were in pursuit of it. ‘Thou needest not fear,’ 
said Mochua, ‘these are my brother and his household, and I beseech God to permit none of them to advance 
beyond that point until thou hast had thy fill.’ And on this the horses' hoofs clung to the ground so 
that they could not go forward till the young cleric had had his fill. Then Mochua prayed God to set his 
brother and his household free. On this they were set free, and they came into Mochua's presence. Guaire 
knelt before St. Mochua and asked his forgiveness. ‘Thou needest not fear, brother; but eat ye your meal 
here.’ And when Guaire and his people had taken their meal they bade farewell to Mochua and returned to 
Durlus. It is a proof of the truth of this story that the Road of the Dishes is the name given to the five 
miles path that lies between Durlus and the well at which Mochua then was.


VIII.
-----


It was in the time of Diarmaid, son of Fearghus, king of Ireland, that St. Beacan lived. Some 
**seanchas** say that Eoghan Og had a son besides Fiachaidh Muilleathan, to wit, Diarmaid, and 
it was from this Diarmaid's progeny that St. Beacan, who lived and blessed in *Cill Bhéacáin in* Muscruide Chuirc, sprang. 
And, moreover, the **seanchas** say that Fiachaidh Muilleathan himself had three sons, to 
wit, Oilill Flann Mor and Oilill Flann Beag and Deachluath. Here is a proof of this:


> 1. Beacan, noble saint, from Diarmaid sprung,
>   
> Let us celebrate the children of Fiachaidh;
>   
> A race who ruled country and district,
>   
> Of them were two Oilills and Deachluath.
> 




About this time Breasal, son of Diarmaid, son of Fearghus, that is, son of the king of Ireland, wished to 
prepare a feast for his father at Ceanannus na Midhe, and he was 


---

p.69




not pleased with anything he had for that feast as long as he had not fat beef to give to his father on the 
occasion. He, however, could find no such beef in his neighbourhood except one beef that belonged to a 
female recluse at Cill Ealchruidhe; and Breasal gently and humbly asked the woman to give him the beef, and 
offered her seven cows and a bull instead of the one beef. The woman refused his offer. On this he took the 
cow from her against her will and killed it for the feast. And when the king of Ireland and his people were 
enjoying the feast, the nun came and made a complaint against Breasal to the king. Now when Diarmaid, the 
king, heard this complaint he became furious, and said he would kill Breasal for having wronged the nun of 
Cill Ealchruidhe, and he took him to the brink of the river Lorcach, and thus he drowned Breasal. Diarmaid 
repented of having drowned his son, and he went to Columcille to express his sorrow for the deed, and 
Columcille told him to go to visit the aged man, Beacan, to Munster; and he set out, accompanied by 
Columcille, and they reached Cill Bheacain, on north side of Sliabh gCrot. And they found the saint making a 
fence round his cemetery and his habit wet upon him. When Beacan got sight of Diarmaid he said, ‘Get thee 
beneath the ground, parricide,’ said he. Upon this Diarmaid sank in the ground up to his knees. ‘It is 
to ask thy protection on account of the deed he has done that he has come,’ said Columcille, ‘and to 
ask thee to beseech God to bring back his son to life.’ Upon this Beacan prayed to God fervently thrice, 
by the direction of Columcille; and it was in this way that the son of the king of Ireland, to wit, Breasal, 
was brought back to life through the prayer of St. Beacan; and God's name and that of Beacan were magnified 
through that miracle.


It happened that Guaire, son of Colman, who was a contemporary of this Diarmaid, and Cumin Foda, son of 


---

p.71




Fiachtna, and Caimin of Inis Cealtrach, were in the principal church of the island, and three questions were 
proposed between them. First, Caimin said, ‘O Guaire, what wouldst thou wish to have?’ ‘Gold and 
wealth to bestow,’ answered Guaire. ‘And thou, O Cuimin,’ said Guaire, ‘what wouldst thou like to 
have?’ ‘Many books containing the word of truth,’ said Cuimin. ‘And thou, O Caimin,’ said 
Cuimin, ‘what is thy wish?’ ‘Many diseases in my body,’ answered Caimin. And the three got their 
wishes, save that at the end of his life Cuimin was cursed by Mochua, who took all prosperity from him, if 
we may trust the seanchus.


Guaire, son of Colman, with three battalions of the Connaught host, came to plunder Munster, and they met 
Dioma, son of Ronan, son of Aonghus, who was king of Cashel at that time, in Ui Fidhghinnte, which is now 
called Clar Chonntae Liumnigh, and Dioma and Guaire gave battle to one another at Carn Fearadhaigh, and 
Guaire and the Connaughtmen were defeated there, and a countless number of them were slain, together with 
six leaders of the Connaught nobility. The reason why Guaire came with that host was to claim the territory 
from Sliabh Echtghe to Luimneach, which belonged to Connaught formerly, until Lughaidh Meann, son of Aonghus 
Tireach, defeated the Connaughtmen in seven battles, in which he slew seven of their kings, though he had no 
host except mercenaries and attendants, and he made sword-land of all the land from Bearn tri gCarbad, at 
Carn Fearadhaigh, to Luchad, that is, Bealach an Luchaide, and from Ath na Boraimhe to Leim an Chon, and it 
is as a setting forth of this that Cormac, son of Cuileannan, composed this stanza: 


> 1. It was this Lughaidh Lamhdhearg 
>   
> Who lopped off from the fair Province of Connaught 
>   
> From Carn Fearadhagh, it was a choice, 
>   
> To Ath Luchad abounding in valour.
> 




Mochua and Columcille were contemporaries, and when 


---

p.73




Mochua or Mac Duach was a hermit in the desert the only cattle he had in the world were a cock and a mouse 
and a fly. The cock's service to him was to keep the matin time of midnight; and the mouse would let him 
sleep only five hours in the day-and-night, and when he desired to sleep longer, through being tired from 
making many crosses and genuflexions, the mouse would come and rub his ear, and thus waken him; and the 
service the fly did him was to keep walking on every line of the Psalter that he read, and when he rested 
from reciting his psalms the fly rested on the line he left off at till he resumed the reciting of his 
psalms. Soon after that these three precious ones died, and Mochua, after that event, wrote a letter to 
Columcille, who was in I, in Alba, and he complained of the death of his flock. Columcille wrote to him, and 
said thus: ‘O brother,’ said he, ‘thou must not be surprised at the death of the flock that thou hast 
lost, for misfortune exists only where there is wealth.’ From this banter of these real saints I gather 
that they set no store on worldly possessions, unlike many persons of the present time.


After that Diarmaid, son of Fearghus Ceirrbheoil, king of Ireland, was slain at Raith Bheag, in Magh 
Line, by Aodh Dubh, son of Suibhne Aruidhe; and his head was brought to Cluain Mic Nois, and his body was 
buried at Cuinnire.


Fearghus and Domhnall, two sons of Muircheartach Mac Earc, son of Muireadhach, son of Eoghan, son of 
Niall Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland one year. Duinnseach, 
daughter of Duach Teangumha, king of Connaught, was mother of these two sons. It was about this time that 
the Battle of Gabhra Lithfe was won by Fearghus and Domhnall over the Leinstermen, wherein four hundred 
Leinstermen fell, and Dioman, son of Caireall, son of Muireadhach Muindearg, who was ten years king of 
Ulster, was slain by the boors of Buirren. And after this Fearghus and Domhnall died.




---

p.75


Eochaidh, son of Domhnall, son of Muircheartach Mac Earca, and Baodan, son of Muircheartach Mac Earca, of 
the race of Eireamhon, held the sovereignty of Ireland. They reigned three years. It was about this time 
that Cairbre Crom, son of Criomhthann Sreibh, son of Eochaidh, son of Aonghus, son of Natfraoch, who was 
king of Munster three years, died. It was, moreover, this Cairbre Crom who, before his death, fought the 
Battle of Feimhean against Colman Beag, son of Diarmaid, wherein Colman was defeated and many of his 
followers slain. And he was called Cairbre Crom from his having been educated or brought up at Cromghlaise, 
as the poet says in this stanza: 


> 1. Straight was he from head to foot,
>   
> A truly brave man was Cairbre Crom;
>   
> The reason why he received his name
>   
> Was that he was reared at Cromghlais.
> 




It was this Cairbre Crom who gave Cluain Uama to God and to the son of Leinin.


Some **seanchas** say that it was about this time Breanainn of Biorra died. And he 
lived nine score years according to the **seanchus** in this stanza:



> 1. Woe to him who reaches not great prosperity!
>   
> Breanainn, excellent was his race,
>   
> One hundred and eighty years
>   
> Was the time he was in the world.
> 




After this Fiachaidh, son of Baodan, fought the Battles of Tola and Forthola against the men of Eile and 
of Osruighe, where many of the Elians and the Ossorians fell; and Conall, son of Comhghall, king of 
Dalriada, in Alba, died, having been sixteen years on the throne of Alba; and it was this Conall who gave 
the island of I in Alba to Columcille. After this Eochaidh and Beodan fell by Cronan, son of Tighearnach, 
king of Ciannachta Ghlinne Geimhean.


Ainmire, son of Seadna, son of Fearghus Ceannfhoda, son of Conall Gulban, son of Niall Naoighiallach, of 
the race of Eireamhon, held the sovereignty of Ireland three years.




---

p.77


Brighid, daughter of Cobhthach, son of Oilill, one of the Lagenians, of Ard Ladhrann, was the wife of 
Ainmire and mother of Aodh, son of Ainmire. After this Ainmire fell by Fearghus, son of Niall, at the 
instigation of Baodan, son of Ninnidh, at Carrig Leime an Eich.


Baodan, son of Ninnidh, son of Fearghus Ceannfhoda, Son of Conall Gulban, son of Niall Naoighiallach, of 
the race of Eireamhon, held the sovereignty of Ireland one year. Cacht, daughter of the king of Fionnghall, 
was the wife of Baodan; and it was in Baodan's reign that Breanainn of Cluain Fearta, the saint, died, also 
Aodh son of Eochaidh Tiormcharna, king of Connaught, who was killed in the Battle of Bagha, and Baodan, son 
of Caireall, king of Ulster, and Ruadhan, of Lothra, the saint. This latter was of the race of Oilill Flann 
Beag, son of Fiachaidh Muilleathan. And Baodan, son of Ninnidh, king of Ireland, was slain by the two 
Cuimins, to wit, Cuimin, son of Colman Beag, and Cuimin, son of Libhrean, at Carraig Leime an Eich, in 
Iomairg. According to Beda, in the fourth chapter of the third book of the History of Sacsa, the age of the 
Lord when Columcille went to Alba was 565.


IX.
---


Aodh, son of Ainmire, son of Seadna, son of Fearghus Ceannfhoda, son of Conall Gulban, son of Niall 
Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland twenty-seven years. Brighid, 
daughter of Cobhthach, son of Oilill, a Lagenian, was the mother of this Aodh. It was Aodh, son of Ainmire, 
who fought the Battle of Beal Dathi, where Colman Beag, son of Diarmaid, and five thousand with him fell 
through the prophecy of Columcille. It was about this time that Seanach, bishop of Cluain Ioraird, died, 
also Fiachaidh, son of Baodan, son of Caireall, son of Muireadhach Muindearg, who was king of Ulster 
twenty-five years, but who now fell at the Battle 


---

p.79




of Beatha by Fiachaidh, son of Dearman. And Feidhlim, son of Tighearnach, king of Munster, died.


It was Aodh, son of Ainmire, who convened the great assembly of Drom Ceat, where there was a convention 
of the nobles and of the clergy of Ireland. And Aodh had three chief reasons for calling together that 
assembly. The first reason was to banish the **filés** from Ireland, because of their being so great a burden and because it was so difficult to rule 
them. For the **ollamh**'s retinue numbered thirty, and there were fifteen in the retinue 
of the **anroth**, that is, the person who was next to the **ollamh** 
in poetic rank; and about that time nearly a third of the men of Ireland belonged to the poetic order, and 
they quartered themselves from Samhain to Bealltaine on the men of Ireland. Now Aodh, son of Ainmire, 
judging that they were a heavy burden to Ireland, decided to banish them from the entire kingdom. Another 
reason, too, that Aodh had for banishing the **filés** was that they went to 
demand a gold bodkin that was in his mantle. Now this was a bodkin that each king left as an heirloom to 
each succeeding king, and it was their inordinate demand of this bodkin that incited Aodh to drive them out, 
so that they were banished to Dal Riada of Ulster. The **filés** had been 
dismissed before then in the time of Conchubhar, son of Neasa, king of Ulster, on account of their unjust 
demands.


At that time the **filés** of Ireland assembled and held a meeting; and their 
number at that meeting was ten hundred **filés** who had retinues, and they were 
at that time deliberating on going to Alba, and when Conchubhar heard this, Cuchulainn went to meet them, 
and he retained them for seven years, as the poet says in this stanza which is taken from the poem beginning 
 Dear to me is Eamhain of Ulster: 


> 1. The Ulstermen arise, noble the host,
>   
> Led by Conchubhar of the red sword;
>   
> Maintenance for seven years with renown
>   
> We give to the **filés**.
> 






---

p.81


After this they let the **filés** scatter all over Ireland, and they were not 
banished from that time forward until the time of Fiachna, son of Baodan, king of Ulster, nor from the time 
of Fiachna to the time of Maolcobha, son of Deaman, son of Caireall, king of Ulster, nor from the time of 
Maolcobha to the time of Aodh son of Ainmire. Thrice then did the men of Ireland cast off the **filés**, and the Ulstermen retained them on each of these occasions. The first time 
they were banished they numbered a thousand; and Conchubhar and the nobles of Ulster maintained them seven 
years, as we have said. On their second banishment Fiachna, son of Baodan, king of Ulster, maintained them a 
year, and seven hundred was their number under Eochaidh Righeigeas, as the poet says, in the above-mentioned 
poem: 


> 1. Eochaidh Righeigheas of noble laws,
>   
> Went to Fiachna, son of Baodan;
>   
> He gave him great welcome,
>   
> And he retained the **filés**.
> 




The third time they were banished, when Maolcobha, king of Ulster, retained them, they amounted to twelve 
hundred, under Dallan Forgaill and Seanchan, as the poet says in the same poem. Thus he speaks: 


> 1. When Maolcobha of the companies was once
>   
> At Iobhar Cinn Trachta on the west side,
>   
> Twelve hundred **filés** he found
>   
> Behind the Yew to the north-west;
> 2. Maolcobha, the chief, gave them
>   
> Maintenance for three fair years.
>   
> It shall live to the day of pale judgment
>   
> For the well-shaped race of Deaman.
> 




The second reason why the convention of Drom Ceat was held was in order that Aodh might impose a tribute 
on the Dal Riada of Alba, as he had no tribute from them up to that time except that they were bound to 
raise an army by land and sea and pay an **eiric** to the king of Ireland, as 


---

p.83




Colman, son of Coimhgheallach ordained, as he says himself in this stanza: 


> 1. A host on land always,
>   
> A fleet on sea as a perpetual custom—
>   
> My skilled oral judgment without harm—
>   
> And an **eiric** for kindred blood.
> 




The third reason why the convention of Drom Ceat was held was to oust Scannlan Mor, son of Ceannfaolaidh, 
from the kingdom of Osruighe, because of his not having paid tribute to Aodh, and to install his son, 
Iollann son of Scannlan, in his place as king over the Ossorians on account of his being obedient to Aodh as 
regards tribute. And these are the three reasons why the convention of Drom Ceat was ordained, as Dallan 
Forgall says in this stanza: 


> 1. There were three reasons for the convention:
>   
> In order to depose Scannlan from kingship,
>   
> The case of the Dal Riada, kingly the battle,
>   
> And the extermination of the bards.
> 




The following are the provincial kings and the territorial princes who were at the convention of Drom 
Ceat: First Criomhthann Cearr, king of Leinster; Iollann, son of Scannlan, son of Ceannfaolaidh, king of 
Osruighe; Maolduin, son of Aodh Beannain, king of West Munster; Finghin, son of Aodh Dubh, son of 
Criomhthann, king of all Munster; Criomthann Deilgneach, king of the south of Ireland; Guaire, son of 
Colman, from the kingdom of clann Fiachrach, south and north; Raghallach, son of Uadaidh, who was king of 
Tuatha Taidhion and of Breithfne Ui Ruairc as far as Cliabhan Modhairn; Ceallach son of Cearnach, son of 
Dubh Dothra, king of Breithfne Ui Raghallaigh; Conghalach Chinn Maghair, king of Tir Chonaill; the kings of 
Oirghiall, to wit, Daimhin, son of Aonghus, from Clochar Deasa to Fionncharn on Sliabh Fuaid; Aodh, son of 
Duach Galach, from Fionncharn on Sliabh Fuaid to the Boinn.


When Columcille heard in Alba of the summoning of this 


---

p.85




convention and the three reasons for which it was summoned, to wit, the deposition of Scannlan, the 
banishment of the **filés**, and the laying tribute on the Dal Riada, he proceed 
from I to Ireland with a company of holy clerics; and the number of clerics he had with him as he came to 
this convention was forty priests, twenty bishops, fifty deacons, and thirty minor clerics, as the Amhra 
Choluim Chille says in this stanza:


> 1. Forty priests, the full number,
>   
> Twenty priests noble strong
>   
> To chant psalms, faultless the repute,
>   
> Fifty deacons, thirty minor clerics.
> 




The reader may possible disbelieve what has been here stated, to wit, that bishops should be among the 
following of an abbot. If, however, one reads the second chapter of the History of Sacsa which Beda has 
written, where he speaks of the privileges of the island of I, in Alba, it will appear that the bishops of 
Alba were subject to the abbot of I in olden times. It is thus, indeed, he speaks: *It was ever the 
custom in this island, (says he,) to have as superior an abbot who was a priest, and who had 
jurisdiction and authority over the entire country, and even the bishops themselves were subject to him, 
though the custom was unusual, according to the example of the first doctor who was in the island, who was 
not a bishop but a priest and a monk. {Habere autem solet (inquit) ipsa Insula rectorem semper 
Abbatem presbiterem cuius iuri et omnis provincia et ipsi etiam episcopi ordine inusitato debeant esse 
subiecti iuxte exemplum primi doctoris illius qui non episcopus sed presbiter extitit et monachus.}’’*

 And it is plain the Columcille was the first doctor, who was first given the privilege in I as Beda says in the tenth chapter of the fifth book of the same History. *Colum, (says he,) was the first doctor of the Catholic faith to the Picts of the mountains in the north, and the first to build a monastery in the island of I, which was long venerated by many congregation of the Scots and Picts. {Columba erat primus doctor fidei Catholicae Transmontanis Pictus ad aquilonem primusque fundator monasterii quod in Hii Insula multis diu Scotorum Pictorumque populis venerable mansit.}’’* From these words of Beda it is to be understood 


---

p.87




that Columcille was the first doctor who went to plant the Faith among the Picts in the north of Alba, and 
that it was for this reason that not only the priests and monks undertook to be subject to Columcille and to 
the abbot of I after him but even the bishops themselves took this yoke on them because it was Columcille 
first gave them the light of the Faith. And it was for this reason that bishops came to Ireland accompanying 
Columcille to the convention of Drom Ceat.
X.
--


Columcille came to Ireland having a cerecloth over his eyes, so that he might not see the soil of 
Ireland. For he was forbidden to look at the soil of Ireland from the time that Molaise imposed as penance 
on him to go to Alba and not to see the land of Ireland till death, and it was for this reason that he kept 
the cerecloth over his eyes while he was in Ireland until his return to Alba; and it is to relate 
Columcille's fulfillment of this penance that Molaise composed this stanza:


> 1. Though Colum came from the east
>   
> In a bark across the great sea,
>   
> He saw nothing in noble Ireland
>   
> On his coming to the convention.
> 




Now the reason why Molaise imposed on Columcille the penance of going to Alba was that Columcille caused 
three battles to be fought in Ireland, to wit, the Battle of Cuil Dreimhne, the Battle of Cuil Rathan, and 
the Battle of Cuil Feadha. The cause of the Battle of Cuil Dreimhne, according to the old book called Uidhir 
Chiarain, was this: Diarmaid, son of Fearghus Ceirrbheoil, king of Ireland, held a **Feis** of Tara, and a nobleman was slain at that **feis** by Cuarnan, son of Aodh, son of Eochaidh Tiormcharna; and the reason why Diarmaid slew this Cuarnan was that he had slain the nobleman at the **feis** in violation of the law 


---

p.89




and sanctuary of the **feis**. And before Cuarnan was slain he put himself under the 
protection of the two sons of Mac Earca, to wit, Fearghus and Domhnall, and they put him under the 
protection of Columcille, and Diarmaid slew him in violation of Columcille's protection for having 
transgressed the law of Tara, and the result of this was that Columcille assembled clanna Neill of the north 
(on account of his own protection and that of the children of Mac Earca having been violated), and the 
Battle of Cuil Dreimhne was fought against Diarmaid and the men of Connaught, and they were defeated through 
the prayer to Columcille.


The Black Book of Molaga gives another reason why the Battle of Cuil Dreimhne was fought, to wit, through 
the unjust judgment Diarmaid gave against Columcille, when he secretly copied the Gospel from Fionntain's 
book, and Fionntain claimed for his own the copy which was written from his own book. Accordingly, both 
sides chose Diarmaid as a judge between them; and the judgment Diarmaid gave was that to every cow belonged 
her calf and that to every book belonged a copy of it; and that was the second reason why the Battle of Cuil 
Dreimhne was fought.


The reason why Columcille caused the battle of Cuil Rathan to be fought against the Dal nAruidhe and the 
Ultonians was because a contention had arisen between Columcille and Comghall, when the Dal nAruidhe showed 
themselves partial in the contention.


The reason why Columcille had caused the Battle of Cuil Feadha to be fought against Colman, son of 
Diarmaid, was to avenge the affront given him in the murder of Baodan, son of Ninnidh, king of Ireland, at 
Leim an Eich by Coman, son of Colman, in violation of Colum's protection.


Now Colum, with his holy clerics, proceeded from Alba to Ireland, as we have said, and when he was 
approaching the convention the queen, Aodh's wife, told her son, Conall, 


---

p.91




not to show any reverence to the heron-cleric or to his company. And when Colum was informed of this before 
he arrived at the place he said: ‘It is my will that the queen and her handmaid, in the shape of two 
herons, be over that ford below until Doom.’ Here is a proof from the Amhra repeating the words of Colum in 
this stanza:


> 1. Let her become a heron,
>   
> Said the cleric in a great rage,
>   
> And let her handmaid exactly be
>   
> A heron in her company.
> 




And the reason why he ordered that the handmaid become a heron together with the queen was that it was 
she who came with a message from the queen to Conall, telling him not to show any reverence to the 
heron-cleric or to his company. And I hear from many people that ever since two herons are usually seen on 
the ford which is beside Drom Ceat.


As to Columcille, when he arrived at the convention the party of Conall, son of Aodh, son of Ainmire, was 
the nearest to him in the assembly, and when Conall saw the clerics he incited the rabble of his party 
against them, thrice nine their number, and they pelted them with clods of clay, and they bruised and hurt 
the clerics. And Colum asked who were thus beating them. Colum was told that it was Conall, son of Aodh, who 
was inciting them to do this deed, and he ordered that thrice nine bells be rung on the spot against Conall, 
whom he cursed and deprived of royalty, of authority, of senses, of memory, of his understanding. And from 
these bells that were rung against him he is called Conall Clogach.


After this Colum went to the party of Domhnall, son of Aodh, and Domhnall went to meet him and bade him 
welcome, and kissed his cheek and seated him in his own place. Colum gave his blessing to Domhnall, son of 
Aodh, and prayed God that he might attain the sovereignty of


---

p.93




Ireland; and it happened ultimately that he held the sovereignty of Ireland for thirteen years before he 
died.


Colum, accompanied by Domhnall, proceeded thence to the king's party, and when he had come into the 
king's presence the latter welcomed him—the king dreaded him greatly on account of what he had done to 
Conall, to the queen, to her handmaid, as we have said. ‘My welcome is compliance with my wish,’ said 
Colum. ‘It shall be granted thee,’ said the king. ‘Then,’ said Colum, ‘what I wish is this: I 
make three requests of thee, namely, to keep the **filés** whom thou art 
banishing from Ireland, and to free Scannlan Mor, son of Ceannfaolaidh, king of Osruighe, from the bondage 
in which thou keepest him, and not to go to impose a tribute on the Dal Riada in Alba.’ ‘I do not wish 
to keep the **filés**,’ said the king, ‘so unjust are their demands and so 
numerous are they. For there are usually thirty in the train of an **ollamh**, and 
fifteen in that of an **anroth**, and so on for the other grades of the **filé** down to the lowest.’ Each of them used to have a separate train of 
attendants according to his degree, so that nearly the third of the men of Ireland followed the bardic 
profession.


Columcille said to the king that it was right to set aside many of the **filés**, as they were so numerous. But he advised him to maintain a **filé** as his own chief **ollamh** after the example of the kings who went before him, and that each provincial king should have an **ollamh**, and, moreover, that each lord of a 
**cantred** or district in Ireland should have an **ollamh**, and Columcille proposed this plan and Aodh assented to it; and it was to celebrate this benefit which Columcille conferred on the **filés** that Maolsuthain composed 
this stanza:


> 1. The **filés** were saved by this means
>   
> Through Colum of the fair law;
>   
> A **filé** for each district is no heavy charge.
>   
> It is what Colum ordained.
> 






---

p.95


From this regulation, which was made by Aodh, son of Ainmire, and Columcille, it followed that the king 
of Ireland and every provincial king and every lord of a **cantred** had a special **ollamh**, and that each of these **ollamhs** had free land from his own lord, and, moreover, the lands and worldly possessions of each of these **ollamhs** enjoyed general exemption and sanctuary from the men of Ireland. It was also ordained that a common estate should be set apart for the **ollamhs** where they could give public instruction after the manner of a University, such as Raith Cheannait and Masruidhe Mhuighe Sleacht, in Breithfne, where they gave free instruction in the sciences to the men of Ireland, as many as desired to become learned in **seanchus** and in the other sciences that were in vogue in Ireland at that time.


The **ardollamh** of Ireland at that time was Eochaidh Eigeas, son of Oilill, son of 
Earc, and it was he who was called Dallan Forgaill, and he sent out **ollamhs** and set 
them over the provinces of Ireland, namely, Aodh Eigeas over the district of Breagh and over Meath, Urmhaol 
chief **eigeas** over the two provinces of Munster, Sanchan, son of Cuairfheartach, over 
the province of Connaught, and Fear Firb, son of Muireadhach, son of Mongan, in the ollamhship of Ulster; and, moreover, an **ollamh** in every **cantred** in Ireland under these high **ollamhs**, and they were to have free land from their territorial chiefs, as well as sanctuary, as we have said; and each of them was to get certain rewards for their poems and compositions.


The second request Colum asked of Aodh was to set Scannlan Mor, king of Osruighe, free, and let him go to 
his own country. This the king refused. ‘I shall not press it further,’ said Colum, ‘if it be God's 
will may Scannlan untie my thongs or take off my shoes to-night when I am at matins.’


‘The third request I make of thee,’ said Columcille, ‘is to grant a respite to the Dal Raida and not to go to 


---

p.97




Alba to plunder them with a view to laying a tribute on them, for you have a right only to a head-rent from 
them and a levy of forces on land and sea.’ ‘I shall not grant them respite, but shall pay them a 
visit,’ said Aodh. ‘Then,’ said Colum, ‘they will have a respite from thee for ever,’ and so 
it was.


Thereupon Columcille, with his clerics, took leave of the king and of the convention, and the Book of 
Glendalough states that Aodhan, son of Gabhran, son of Domhanghurt, king of Alba, was at that convention, 
and that he took his leave of the king and of the assembly along with Columcille. The same book says that 
the convention of Drom Ceat sat for a year and a month instituting laws and regulating tributes and forming 
friendly alliances between the men of Ireland.


XI.
---


As to Columcille, when he had taken his leave of the assembly he proceeded to Duibheaglais, in Inis 
Eoghan, and on the next night, after nightfall, a brilliant flame of fire came upon the guards at the 
convention, who kept the cell in which Aodh had Scannlan Mor confined, bound by twelve iron chains, so that 
the guards put their faces to the ground because of the greatness of the blaze which they saw. And a bright 
dazzling flame came to Scannlan in the place where he was, and a voice in the flame said to him, ‘Arise, O 
Scannlan, and quit thy chains and thy cell, and come forth and follow me, and place thy hand in mine.’ 
After this Scannlan came forth with the angel in front of him. His guards observed him, and asked who was 
there. ‘Scannlan,’ said the angel. ‘If it were he, he would not tell,’ said they. Thereafter the 
angel and Scannlan went after Columcille; and when Colum was at matins, as he was passing through the 
sanctuary railing it was Scannlan who was taking off his shoes; and Columcille asked who 


---

p.99




was there, and he replied that he was Scannlan. When Columcille asked news of him, he answered ‘a 
drink,’ so great was his thirst, for it was salted meat they gave him in the cell, with no drink after. 
From the frequency with which he gave that answer to Columcille, the latter left an impediment in speech on 
every king of his progeny who should rule in Osruighe. Now Columcille directed Baoithin to give three drinks 
to Scannlan, and then Scannlan told his story to Colum, as we have said above. Columcille directed Scannlan 
to proceed to Osruighe. ‘I cannot,’ said Scannlan, ‘through fear of Aodh.’ ‘Thou needest have 
no fear,’ said Colum; ‘take my staff with thee as a protection, and leave it with my community at 
Durmhagh, in Osruighe.’ Upon this Scannlan proceeded to Osruighe, and ruled over his own country during 
his life; because fear of Columcille prevented Aodh from troubling him thereafter.


In return for his liberation in this manner, Scannlan imposed a yearly tax of a 
**screaball**, or threepence, on every household in his country from Bladhma to the sea, to be paid to the community of Columcille at Durmhagh, in Osruighe, as we read in the Amhra Choluim Chille, which 
quotes the promise which Scannlan made to Colum:


> 1. Thy share of my lands, of my house,
>   
> Be they numerous as rushes or herbs,
>   
> It is **screaball** from each house,
>   
> The portion from Bladhma to the sea.
> 




Columcille, moreover, gave his blessing to all the Ossorians on condition that they and their king should 
be obedient to himself and to his community at Durmhagh in succeeding times as regards the payment of the 
tax which Scannlan imposed on themselves and on their posterity, as we read in the Amhra: 


> 1. A blessing from me on the Ossorians,
>   
> On their pure-handedness and wisdom;
>   
> A blessing on sea and on land
>   
> From me, because of their kings submission to me.
> 






---

p.101


Criomhthann was the baptismal name of the Columcille we are treating of here, and Axal was the name of 
his guardian angel, and Demal was the name of the demon that specially troubled him, as we read in the 
Amhra. Thus it speaks: 


> 1. Criomhthann Ua Cuinn, fair consummation,
>   
> Was the baptismal name of Columcille; 
>   
> Axal the name of his angel, without fault,
>   
> And Demal his demon.
> 




Now Columcille clung to him as a name, because when he was a child under instruction at Dubhghlaise, in 
Tir Luighdheach, in Cineal Conaill, he was permitted to go out into the village one day each week to play 
with his equals in age as a privilege, as he was of the royal blood. And as he was wont to go out thus a day 
in each week, the children of the district used to assemble to meet him on the day on which he was wont to 
go out, and, being together waiting for him, when they beheld him coming towards them from the monastery, 
they used to lift their hands for joy, and say with one voice, ‘Here comes the Colum or dove of the 
Church,’ and when the teacher heard that the children were in the habit of calling him Columcille he 
deemed it to be God's will that he should be always called by that name which was in the mouths of the 
innocent children, and that his baptismal name, to wit, Criomhthann, should lapse. And a change of name of 
this kind has often been the lot of the saints, witness the case of Mochuda, who was first called Carrthach, 
and of St. Caomhan, a disciple of Patrick, who was first called Mac Neise, and of Patrick himself, whose 
baptismal name was Sochet, and whom Germanus called Magonius, when he imposed hands on him, and whom Pope 
Coelestinus called Patrick on the occasion of his sending him to Ireland to propagate the Faith, and that of 
Fionnbharr, of Cork, whose baptismal name was Luan, and of the bishop of Iobhar, whose name was Loichead, 
and who lived 


---

p.103




and blessed in Beigeirinn, in the lower part of Leinster, and of St. Connlaoch, bishop of Cill Dara, whose 
first name was Roincheann, and of Moling, whose first name was Dairchill, and similarly of many others like 
them; so that it cannot be doubted that Criomhthann was the baptismal name of Columcille, notwithstanding 
that Columcille clung to him as his common name for the above reason.


Know, O reader, that Columcille was a genuine Irishman on his father's and mother's side, and not an 
Albanian, as some Albanians say. For it is evident that he was Irish on his father's side, as we read in the 
history of the saints of Ireland that Feidhlimidh, son of Fearghus Ceannfhoda, son of Conall Gulban, son of 
Niall Naoighiallach, who was high king of Ireland, was father to Columcille. Here is the **seanchas** statement of this, as we read in the poem which begins: The sacred history of the saints of Inis Fail: 


> 1. Columcille, of the land of Conn,
>   
> Son of Feidhlimidh, over every tribe,
>   
> Son of Fearghus, of the fierce action,
>   
> Son of the very noble Conall Gulban.
> 




It is also certain that Columcille was Irish on his mother's side, according to the account given in the 
Amhra, where it states that Eithne, daughter of Dioma, son of Naoi, of the race of Cairbre Nia Fear, king of 
Leinster, was his mother. Thus speaks the Amhra:


> 1. Eithne, who is mighty,
>   
> The queen out of the Dal Cairbre,
>   
> Mother of Colum, who was thence pious,
>   
> Was daughter of Dioma, son of Noe.
> 




Columcille mortified his body by fasting and prayer and prostration to such a degree that he grew so 
emaciated through pious austerity that when he lay in the sand in his cell as the wind rushed in through the 
roof his ribs were distinguishable through his habit, as the Amhra says in this stanza: 


---

p.105



> 1. Plain he used to lie on the sand,
>   
> In his bed was great suffering;
>   
> The form of his ribs through his dress
>   
> Was distinct as the winds blew.
> 




Columcille's age when he died was seventy-seven years, as Dallan Forgaill says in Amhra Choluim Chille itself, which was written by Dallan soon after the death of Columcille: 


> 1. While Colum was in the fair world
>   
> His body laboured beneath the yoke,
>   
> He went to angels out of his body
>   
> After seven and seventy years,
> 



namely, forty-three years of his life he spent in Ireland, and after that thirty-four years in Alba, as the 
 Amhra says in this stanza: 


> 1. He was three years and forty of them
>   
> In Ireland, without anxiety,
>   
> Four and thirty strong years
>   
> In Alba after Erin.
> 




The three places in which Columcille used to dwell are in I in Alba, in Derry, in Dun da Leathghlas where 
he was buried, as he says himself in this stanza, in which he reveals his love for these three places:


> 1. My happiness in I, without fault,
>   
> And my soul in Derry.
>   
> And my body beneath the stone
>   
> Under which are Patrick and Brighid.
> 




When Columcille said Mass or sang psalms or preached, his voice was heard at a distance of a mile and 
a-half, and a demon could not endure his voice, but fled before it, as the Amhra says in this stanza:


> 1. The sound of his voice, of Columcille's,
>   
> High its melody above every company;
>   
> As far as fifteen hundred paces,
>   
> Mighty courses, was it distinct.
> 






---

p.107


There was a priest in Tir Chonail in the time of Columcille who built or erected a church of precious 
stones, and he made an altar of glass therein, and he had images of the sun and moon set up in the church. 
Soon afterwards this priest fell into a deep swoon, after which a demon came to him and took him with him 
into the air. And when they came near Columcille overhead, he caught sight of them and made the sign of the 
cross above him in the air, and thereupon the priest fell down. And for that reason the priest made an 
offering of the church he had built to Columcille on account of his having rescued him from the hands of the 
demon, and he joined an order of monks himself, and led a good life thenceforward.


There was a saint in Ui Faircheallaigh, in Osruighe, called Coisfhionn, and Columcille went on a certain 
occasion to see him in the hope that he might let him see his books, for he was a very learned man and had 
many books. And he refused to let Columcille see them. And Columcille prayed God to grant that no person 
alive might be able to read any one of these books; and from that time not a word of them could be read, and 
they decayed.


Baoithin saw in a vision three chairs in heaven, namely, a chair of gold a chair of silver, and a chair 
of glass; and Columcille explained to him that the chair of gold was for Ciaran mac an tSaoir for his great 
hospitality to guests, ‘and the chair of silver is for thyself, O Baoithin, for the purity of thy piety; 
but the chair of glass is for me, for though my piety be pure, I am often frail and worldly.’


The following are the four rules of Ireland, to wit, the rule made by Patrick forbidding the killing of 
clerics; the rule of Adhamnan forbidding the killing of women; the rule of Doire Choluim Chille, forbidding 
the killing of milch cows; and the rule of Sunday forbidding a journey on that day.




---

p.109


XII.
----


It was in the reign of this Aodh son of Ainmire that Columcille died. Understand, O reader, that the 
Colum of whom we have been speaking up to this is Columcille son of Feidhlimid, son of Fearghus. But the Red 
Book of Mac Aodhagan and the sacred history of the saints of Ireland say that many of the saints, male and 
female, of Ireland bore the same name. For they say that there were twenty-two St. Colums in Ireland, and 
Columcille was the first Colum of them; and further, it was in commemoration of the sanctity of Columcille 
that each of them was called Colum. There were twenty-five St. Ciaran's in Ireland, and amongst them were 
Ciaran of Cluain Mic Nois, and Ciaran of Saighir, and Ciaran of Tiobraid Naoi. There were thirty-two St. 
Aodhan's in Ireland. There were seven St. Bairrfhionn's in Ireland, and amongst these was Bairrfhionn, or 
Fionnbharr, of Corcach. And this Fionnbharr was the son of Aimhirgin, son of Dubh Duibhne, son of Ninnidh, 
son of Eochaidh, son of Cairbre Ard, son of Brian, son of Eochaidh Muighmheodhon, who was king of Ireland. 
And there were seventeen holy bishops and seven hundred religious in the community of Corcach along with 
Fionnbharr. There were four St. Baoithins in Ireland, to wit, Baoithin son of Breanainn, Baoithin son of 
Fionnach, Baoithin son of Alladh, and Baoithin son of Cuanaidh. There were fifteen St. Brighids in Ireland, 
and amongst them was Brighid, daughter of Dubhthach, of Leinster, who is celebrated throughout Europe; and 
it is clear that she is of the stock of Eochaidh Fionn Fuath nArt; and that Eochaidh Fionn was brother to 
Conn Ceadchathach, who was king of Ireland. Here is the testimony of the sacred history of Ireland on this 
point, as we read in the poem which begins: The sacred history of the saints of Inis Fail: 


---

p.111



> 1. Brighid, daughter of Dubhthach Donn,
>   
> Son of Dreimhne, son of Breasal Borr,
>   
> Son of Dein, son of Connla, son of Art,
>   
> Son of Cairbre Nia, son of Cormac,
> 2. Son of Aonghus Mor, of high dignity,
>   
> Son of Eochaidh Fionn, hated of Art,
>   
> Son of Feidhlimidh Reachtmhar the noble,
>   
> Son of Tuathal Teachtmhar, the excellent.
> 




The following are the fourteen St. Brighids who were in Ireland besides the Brighid spoken of above: 
Brighid, daughter of Dioma; Brighid, daughter of Mianach; Brighid, daughter of Moman; Brighid, daughter of 
Eanna; Brighid, daughter of Colla; Brighid, daughter of Eachtar Ard; Brighid of Inis Brighde; Brighid, 
daughter of Damhar; Brighid of Seanbhoth; Brighid, daughter of Fiadhnat; Brighid, daughter of Aodh; Brighid, 
daughter of Luinge (or Long?).


It was in the time of Aodh son of Ainmire, of whom we are treating, and of Aodhan son of Gabhran, king of 
Alba, who was very old at the time, that the Gaels lost Manainn.


It was, moreover, in the time of Aodh son of Ainmire, that St. Cainneach, of Achadh Bo, died, aged 
eighty-four years; and this Cainneach was of the stock of Fearghus, son of Rogh. It was about this time that 
Colman Rimhidh fought the Battle of Sleamhain, in which Conall, son of Aodh, was defeated, and the Battle of 
Cuil Caoil against Fiachaidh, son of Baodan, in which Fiachaidh, son of Deman, was defeated and his people 
slaughtered.


After that Conall son of Suibhne defeated in battle the three Aodhs in one day, namely, Aodh Slaine, and 
Aodh Buidhe, king of Ui Maine, and Aodh Roin, king of Ui bhFailghe. It was at Bruighean da Choga he defeated 
them, as the poet says in this stanza: 


> 1. Dreadful was the bloody state
>   
> Of the kings of all Ireland,
>   
> Aodh Slaine with a host,
>   
> Aodh *Roin* and Aodh Buidhe.
> 






---

p.113


Now there was constant dissension between the two Fiachaidhs we have just mentioned, to wit, Fiachaidh, son 
of Baodan and Fiachaidh, son of Deaman, and through the prayer of St. Comhgall the son of Baodan often got 
the upper hand; and when the son of Deaman charged the saint with this, Comhgall asked him in turn whether 
he preferred heaven and to be slain to gaining a victory and living for a time and hell in the end. The son of Deaman said he preferred to gain a victory over his enemy so that his slaughter of them and exploits against them might be recited at general assemblies from age to age. Comhghall disapproved of the choice he made, and the other Fiachaidh chose heaven and defeat in battle, and 
this he obtained through the prayers of Comhghall.


Indeed every great tribe of the nobles of Ireland had an attendant guardian saint. In testimony of this 
take the following tribes: For the Tuathalaigh and the Branaigh had Caoimhghin of Glenn da Loch; the Ui 
Cinnsealaigh had Maodhog of Fearna; the Caomhanaigh had Moling; the siol Mordha had Fionntain of Cluain 
Eidhneach; the Ossorians had Cainneach of Achadh Bo; the siol gCinneidhidh had Ruadhan of Lothra; the Deise 
had Deaglan; the clann Briain of Eatharla had Seanna; Gobnuid was for Muscraidhe Mic Diarmada; Colman for Ui 
Mac Coile; and similarly there was no district or tribe in Ireland without the special protection of a male 
or female saint, whom they venerated and honoured. But there are other saints more generally known than 
those we have mentioned, such as Columcille, Finnen of Magh Bile, Ciaran of Cluain, Comhghall of Beannchair, 
Brighid of Cill Dara, Ailbhe of Imleach, and St. Patrick, as Aonghus Ceile De says in the book which is 
called Psaltair na Rann. Thus does he speak: 


> 1. The Ui Neill, all protected by Colum,
>   
>  Are not in the shade of a bramble;
>   
> Protected by Finnen of Magh Bile
>   
>  Are all the Ultonians;
> 
> 
> ---
> 
> p.115
> 
> 
> The tribes of Connanght are protected by Ciaran,
>   
> Though it be not an equal division;
>   
> The Dal nAruidhe, the noble, the amiable,
>   
> Are protected by Comhghall;
>   
> The Leinstermen are protected by Brighid,
>   
> Fame and riches;
>   
> All Munster, with its produce,
>   
> Is protected by Ailbhe.
>   
> The chief saints of Ireland, with her monks,
>   
> It is their care,
>   
> Whatever path they walk in, to be all under the shield
>   
> Of Patrick.
> 




It was while Aodh son of Ainmire, held the sovereignty of Ireland that Brandubh, son of Eochaidh, son of 
Muireadhach, son of Aonghus, son of Feidhlimidh, son of Eanna Cinnsealach, was king of Leinster for one 
year. And he and the Leinstermen slew Aodh son of Ainmire, in the Battle of Bealach Duin Bolg. It is also 
said that it was the Leinstermen themselves who slew Brandubh in the Battle of Camcluain, or that it was by 
Saran Saobhdhearg, the **airchinneach** of Seanbhoth Sine, he fell, as the poet says in 
this stanza:


> 1. Saran Saobhdhearg, noble guide!
>   
> The **airchinneach** of Seanbhoth Sine,
>   
> 'Tis no falsehood, though he was seldom in battle,
>   
> He slew Brandubh, son of Eochaidh.
> 




It was about this time that St. Colman of Eala died.


Aodh Slaine, son of Diarmaid, son of Fearghus Ceirrbheoil, son of Conall Creamhthainne, son of Niall 
Naoighiallach, and Colman Rimhidh, son of Muircheartach Mac Earca, of the race of Eireamhon, held the 
sovereignty of Ireland. They were six years in joint sovereignty. Mughainn, daughter of Cucharainn, son of 
Duach, a Connaughtwoman, was the mother of Aodh Slaine; and Eithne, daughter of Breanainn Dall, a 
Connaughtwoman, was his wife; and she bore him six sons, to wit, Diarmaid, Donnchadh, Maolbreasail, 
Maolodhar, Comhghall, and Oilill. He was called Aodh Slaine, for it was on the river which is named 


---

p.117




Slaine he was born. It was in the reign of this pair that Gregory the Great of Rome sent St. Augustine, the 
monk, together with a community of holy clerics, to propagate the Catholic Faith in Britain. Colman Rimhidh 
fell by Lochan Diolmhain. Aodh Slaine was slain by Conall Guithbhinn, son of Suibhne.


Aodh Uairiodhnach, son of Domhnall, son of Muircheartach, son of Muireadhach, son of Eoghan, son of Niall 
Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland twenty-seven years. Brigh, daughter 
of Orca Mac Eirc, son of Eochaidh, was the mother of Aodh Uairiodhnach. And he is called Aodh Uairiodhnach, 
for he was subject to cold fits of pain, and if he owned the wealth of the world he would give it to get a 
moment's relief. Now uara eidhnigh means readhg fuar, or a 'cold pang', and hence he was called Aodh Uairiodhnach. It was in the reign of this Aodh that Aonghus, son of Colman, fought the Battle of Odhbha, in which Conall Laoghbhreagh, son of Aodh Slaine, fell. And Aodh Uairiodhnach, king of Ireland, fell in the Battle of da Fhearta.


Maolcobha, son of Aodh, son of Ainmire, son of Seadna, son of Fearghus Ceannfhoda, son of Conall Gulban, 
son of Niall Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland four years. 
Croinseach, daughter of Aodh Fionn, king of Osruighe, was the wife of this Maolcobha, Maolcobha fell by 
Suibhne Meann in the Battle of Sliabh Bealgadain.




---

p.119


XIII.
-----


Suibhne Meann, son of Fiachna, son of Fearadhach, son of Muircheartach, son of Muireadhach, son of 
Eoghan, son of Niall Naoighiallach, held the sovereignty of Ireland thirteen years. It was in the reign of 
Suibhne Meann that Caoimhghin of Gleann da Loch died, aged six score years. Caoimhghin was the son of 
Caomhlogha, son of Caoimhfhiodh, son of Corb, son of Fearghus Laoibdheargh, son of Fothach, son of Eochaidh 
Laimhdhearg, son of Meisin Corb, of the race of Labhraidh Loingseach. It was about this time that Aodh 
Beannain, king of Munster, died, and St. Adhamnan, son of Ronan, son of Tinne, son of Aodh, son of Colum, 
son of Seadna, son of Fearghus, son of Conall Gulban, son of Niall Naoighiallach, who was abbot of I in 
Alba. Rona, daughter of Dunghal, king of Ui Turtaire, was the wife of Suibhne Meann, king of Ireland. 
Suibhne Meann, king of Ireland, was slain by Conghal Claon, son of Scannlan Sciathleathan.


Domhnall, son of Aodh, son of Ainmire, son of Seadna, son of Fearghus Ceannfhoda, son of Conall Gulban, 
son of Niall Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland thirteen years. And it 
was this Domhnall who won the Battle of Dun Ceitheirn against Conghal Claon, in which he overthrew him and 
slew many of his people. It was, moreover, in the reign of Domhnall that the saint who was called Munna 
died, and that Carrthach, that is, Mochuda, were banished from Rathain to Lios Mor. And Mochuda was of the 
stock of Ciar, son of Fearghus.


Now when Mochuda went from Ciarraidhe on a pilgrimage to Rathain he built a monastery there, and he 
placed a community of monks in the monastery; so that there were seven hundred and ten monks with him there, 
who passed their lives so piously that an angel used to converse with every third monk of them, and thus it 
came to 


---

p.121




pass that the fame and renown for great sanctity of the community of Rathain grew apace. For this reason the 
saints of the clann Neill became very envious, and they sent word to Mochuda directing him to abandon 
Rathain and betake himself to his own country, that is, to Munster. Mochuda replied to the messengers who 
brought him these instructions and said that he would not leave Rathain unless he were put out of it by the 
hand of a bishop or of a king. When this message reached the pious men of the clann Neill they besought 
Blathmhac and Diarmaid Ruanuidh, two sons of Aodh Slaine, who were of the clann Neill, to go and expel 
Mochuda from Rathain; and at the instigation of this body, Blathmhac and Diarmaid Ruanuidh, along with a 
company of clerics from the northern side, visited Rathain.


When Mochuda heard that they had come close to him he sent a lord of the Picts, or Cruitnigh, from Alba, 
called Constantine, who was a lay-brother in the community, to beseech these nobles to give a year's respite 
to Mochuda and to his community before expelling them from Rathain. And he got this request from them. And 
when the year passed the same nobles came in a year's time, along with a company of the same clerics, and 
when they had come close to Rathain, Blathmhac sent word to Mochuda asking him to come out of the monastery; 
and thereupon Mochuda sent the same Constantine to beseech them to give him another year's respite, and they 
granted this, though unwillingly. And at the end of the third year the same nobles and the same clerics were 
incited by the lawless folk of the Ui Neill to come and expel Mochuda the third year from Rathain; and when 
that company had come near the village they, of one accord, sent Diarmaid Ruanuidh and the **airchinneach** of Cluain Conghusa, along with a party, to bring Mochuda by the hand out of the 
monastery; and when these had reached the church the **airchinneach** went in and 
Diarmaid remained outside at the doorpost. When 


---

p.123




Mochuda heard that Diarmaid was at the door he went to welcome him and ask him into the church. ‘I will 
not go in,’ said Diarmaid. ‘Is it to carry me off from the monastery thou hast come?’ said Mochuda. 
‘It is,’ said Diarmaid, ‘but I dare not do it, and I repent of having come on this expedition, by 
reason of thy great sanctity and of the honour God gives thee.’ ‘Honour in heaven and on earth be 
thine,’ said Mochuda, ‘and power and the sovereignty and the kingdom of Ireland be thine, and may thy 
progeny prosper after thee; and when thou shalt have returned to thy company, the youths who are there will 
give thee the name Diarmaid Ruanuidh in reproach. But that nickname will redound to thy honour and to that 
of thy offspring.’ Thereupon Diarmaid returned to the company, and when he came before them Blathmhac 
asked him why he did not lay hands on Mochuda and bring him out of the monastery. ‘I dared not do it,’ 
said Diarmaid. ‘That, O Diarmaid, is a bashful behaviour.’ And when the company heard this they dubbed 
him Diarmaid Ruanuidh. Now ruanuidh means deargthach or 'bashful', so that his descendants are called the descendants of Diarmaid Ruanuidh ever since.


As to Blathmhac, he went with a party to the monastery and laid hands on Mochuda, and brought him and his 
community out of the monastery against their will. And Mochuda cursed Blathmhac. And Mochua proceeded 
thence, with his community of monks, performing wonders and miracles till he arrived at the Deise; and when 
he arrived there the king of the Deise went to meet him, and reverenced and honoured him, and commended his 
body and soul to his protection; and they both proceeded to Dun Scinne, which is now called Lis Mor. There 
Mochuda and his community dwelt, and there they built a church, so that the place has been honoured and 
celebrated for piety and learning ever since. Thus far the going of Mochuda from Rathain to Lis Mor.




---

p.125


It was Domhnall, son of Aodh, son of Ainmire, king of Ireland, who fought the Battle of Magh Rath, where 
Conghal Claon, who had been ten years king of Ulster, was slain. And from the tract called the Battle of 
Magh Rath it may be readily seen that the array and order of the Irish troops as they went into conflict or 
engaged in battle were well regulated. For there was a leader of the entire host, and a leader of each 
division of the host under his charge, and an emblem on the standard of each leader, from which the 
divisions of the army were distinguished from one another by the **seanchas**, who were 
bound to be with the nobles whenever they engaged with one another in conflict or battle, so that the **seanchas** might be eyewitnesses of the exploits of the nobles, and thus be able to give a 
true account of their deeds on either side. And hence Domhnall, son of Aodh, king of Ireland, had his own 
**seancha** with him when he was about to engage in the Battle of Magh Rath. For when 
Domhnall was marching against Conghal, king of Ulster, and they were on either side of the river, and when 
they were in sight of each others host Domhnall asked his **seancha** to name every one 
of the standards separately, and its emblem, and the **seancha** told him what they 
were, as we read in the poem which begins: Mightily advance the battalions of Conghal, in 
which is this stanza on the king of Ulster's own emblem: 


> 1. A yellow lion upon green satin,
>   
> The emblem of the Craobh Ruadh,
>   
> Such as was held by noble Conchubhar
>   
> Conghal now holds.
> 



It is a long time since the Gaels began the practice of having emblems, in imitation of the children of 
Israel, who employed them in Egypt, in the life-time of Gaedheal, when the children of Israel passed through 
the Red Sea, with Moses as their chief leader. Now there were twelve tribes of them, and each tribe had a 
separate division of an army and a separate emblem.




---

p.127



> 1. The tribe of Ruben, a mandrake on its standard as an emblem;
>   
> The tribe of Simeon, a javelin on its standard as an emblem;
>   
> The tribe of Levi, the Ark on its standard as an emblem;
>   
> The tribe of Juda, a lion on its standard as an emblem;
>   
> The tribe of Isacar, an ass on its standard as an emblem;
>   
> The tribe of Zabulon, a ship on its standard as an emblem;
>   
> The tribe of Nephtalem, the figure of a wild ox on its standard as an emblem;
>   
> The tribe of Gad, the figure of a lioness on its standard as an emblem;
>   
> The tribe of Joseph, a bull on its standard as an emblem;
>   
> The tribe of Benjamin, a wolf on its standard as an emblem;
>   
> The tribe of Dan, a serpent on its standard as an emblem;
>   
> The tribe of Aser, an olive branch on its standard as an emblem.
> 




Here follows the **seanchas** account of the emblems of the children of Israel, as we 
read in the old Book of Leacaoin, in Urmhumha, and in many other old books, in the poem below: 


> 1. I know each great ensign
>   
> That the proud children of Jacob had,
>   
> Few are the people thereafter
>   
> Who know their names.
> 2. The tribe of Ruben, prosperity helped them,
>   
> Their ensign was a mandrake;
>   
> The spirited tribe lasted a long time,
>   
> A good host followed its ensign.
> 3. The tribe of Simeon asked no ensign
>   
> But a stern avenging javelin;
>   
> Simeon, the guileful wise one,
>   
> Who was vindictive in the affair of Dionna.
> 4. The tribe of Levi, the people of the Ark,
>   
> Numerous their flocks and great herds;
>   
> It was a guarantee of their welfare
>   
> To see the Ark with them.
> 5. The ensign of the noble tribe of Juda,
>   
> The figure of a powerful lion;
>   
> The tribe of Juda, in the hour of wrath
>   
> Proud hosts following a good ensign
> 6. The tribe of Isacar, of the pure gold,
>   
> Had an ensign like an ass;
>   
> Often a host with ruddy face,
>   
> Followed the great beautiful ensign.
> 
> 
> ---
> 
> p.129
> 
> 9. The tribe of Zabulon, of the bright girdles,
>   
> The figure of their ensign was a laden ship;
>   
> It was usual on the shallow waves
>   
> For all to be in their laden ships.
> 10. The figure of a wild ox, short-flanked, swift,
>   
> Had the tribe of Neptalem, the venemous;
>   
> Of the tribe that practised the fury of wrath
>   
> The warriors round their ready ensign were not few.
> 11. The ensign of the tribe of Gad, in conflict,
>   
> Was as the figure of a lioness;
>   
> Nor have we deemed timorous in the time of wrathful fury
>   
> Each warrior following the great ensign.
> 12. An ensign like a bull with constant strength,
>   
> In the east had the tribe of renowned Joseph;
>   
> It is well known that vultures sought
>   
> The bold, glorious race.
> 13. The tribe of Benjamin, of swift vigour,
>   
> Its ensign was above ensigns;
>   
> An ensign like the ravening wolf,
>   
> Ruddiness in the glorious feast.
> 14. The tribe of Dan, stubborn the race,
>   
> A venemous family of a sinister house,
>   
> Powerful to strike back, as it implies,
>   
> Like a great serpent, its ensign.
> 15. The tribe of Aser, not stinted in herds,
>   
> An ensign they clung to like a garment;
>   
> Its choice was identical with
>   
> A beautiful fair olive branch.
> 16. I have enumerated their tribes above,
>   
> I have enumerated their ensigns;
>   
> The enumeration of the abodes of the spirited tribes,
>   
> How many men are ignorant of? I know.
> 




It was in the reign of Domhnall, son of Aodh, king of Ireland, of whom we are treating, that the 
following saints died, to wit, Mochua, of the race of Oilill, son of Cathaoir Mor, who lived and blessed in 
Teach Mochua in Laoighis, and Mochudha and Maolaise of Leithghlinn, who were of the race of Conall Gulban, 
son of Niall Naoighiallach and 


---

p.131




Comhdhan, son of Da Cearda, and Cronan, bishop of Caondrom. And Domhnall, son of Aodh, son of Ainmire, king 
of Ireland, died.


XIV.
----


Conall Caol and Ceallach, two sons of Maolcobha, son of Aodh, son of Ainmire, son of Seadna, son of 
Fearghus Ceannfhoda, son of Conall Gulban, son of Niall Naoighiallach, of the race of Eireamhon, assumed the 
sovereignty of Ireland. They reigned together for thirteen years. It was in their reign that Cuanna, son of 
Cailchin, king of Fearmaighe, that is, Laoch Liathmhaine, died, and this Cuanna was a contemporary of 
Guaire, son of Colman, and there was a rivalry between them in hospitality and charity; and hence the two 
jesters, Comhdan and Conall, composed between them this stanza on their rivalry, in which they say: 


> 1. Everything that is in his hand;
>   
> Guaire son of Colman bestows,
>   
> What each one covets is given him
>   
> By the Warrior of Liathmhain.
> 




It was, moreover, in their reign that Raghallach, son of Udaidh, who was king of Connaught twenty-five 
years, was slain by Maoilbrighde, son of Mothlachan, and by his slaves. It happened thus: this Raghallach 
was full of hatred and envy towards the son of an elder brother, fearing lest he might oppose him and 
deprive him of the kingdom of Connaught. Still he found no opportunity of slaying his brother's son, so that 
he was wasting away through not taking food because of his envy of his brother's son. Moreover, he sent a 
messenger to his kinsman, asking him to come and see him. As to the kinsman, he understood Raghallach's 
deceit, and he assembled a company and went to meet his kinsman Raghallach; and as he went into his 


---

p.133




presence he directed his party to wear their swords unsheathed at their waists, and when Raghallach saw this 
he said: ‘It is sad that he whom I love most dearly on earth, and whom I wish to make my heir, trusts me 
not, though I am at the point of death.’ Now, when his kinsman heard this he was greatly afflicted at 
heart, and he came alone next day to see him, and Raghallach's party sprang upon him and slew him. Thereupon 
Raghallach got up in health on the spot and set to feasting merrily and most pleasantly. But Muireann, that 
is, Raghallach's wife, inquired of her druid after Raghallach had slain his kinsman whether there was 
trouble in store for her. The druid said that since Raghallach had slain his kinsman, both their deaths 
would be speedily brought about by their own children; and, moreover, that it was the child in her womb who 
would bring about their death. She made this known to Raghallach, and he told her to kill the child 
immediately after its birth.


Muireann gave birth to a daughter, and put her into a bag with a view to giving her to one of her people, 
a swineherd, that he might kill her. When the swineherd saw the face of the infant his heart yearned towards 
it, and he put it in the same bag in which he got it from its mother and took it privately to the door of a 
pious woman, who was near at hand, and left the bag on one of the arms of a cross that was near the pious 
woman's house. The pious woman came upon the bag, and when she found the infant in it she loved it greatly 
and reared it religiously. And there was not in Ireland in her time a more beautiful girl, so that her fame 
reached Raghallach, and he sent messengers asking her of her nurse. But the nurse did not grant this 
request. After this she was brought to him by force, and when he saw her he became greatly in love with her 
and he had her as a concubine. Now his own wife, Muireann, became jealous, and went to the king of Ireland 
to complain of this 


---

p.135




deed. And the scandal of this evil deed spread through Ireland, and the saints of Ireland were pained 
thereat, and Feichin Fabhair came to Raghallach and charged him, and many saints came with him and entreated 
him to give up this sin. But he did not give it up for them all, though they fasted on his account. However, 
as a warning to other people of inordinate desires, the saints prayed God that he should not be alive the 
Bealltaine following, and that he should fall by wicked people, and, moreover, by puny arms and in a squalid 
spot; and all these things befell him on the approach of Bealltaine. For a wild deer which had been wounded 
came helter skelter into the island in which Raghallach was, and which he was guarding, and as he saw the deer he laid hold of his javelin and 
made a cast of it at the animal and pierced it through therewith. The deer swam away from him and he 
followed it in a skiff, and the deer went some distance from the lake and came upon slaves, who were cutting 
turf, and they slew the deer and divided it between them. Ragallach came up to them and threatened them for 
having divided the deer, and asked them to give back the venison. But the slaves resolved to slay the king, 
and thereupon they attacked him with their oars and other implements, and slew him as was foretold regarding 
him by the saints. And Muireann, his wife, died through jealousy of her own daughter.


It was about this time that the Battle of Carn Conaill was fought by Diarmaid, son of Aodh Slaine, 
wherein Cuan, son of Amhalghuidh, who was king of Munster ten years, and Cuan, son of Conall, king of Ui 
Fidhgheinnte, and Talamonach, king of Ui Liathain, were slain; and it was through the prayer of Ciaran's 
community at Cluain Mic Nois that Diarmaid won that battle. And when Diarmaid returned to Cluain Mic Nois he 
bestowed land on that church as altar-land. And the name of that land at this day is Liath Mhanchain, and it 
was at Cluain Mic Nois 


---

p.137




that Diarmaid willed that he should be buried after his death. It was about this time that St. Fursa, of the 
race of Lughaidh Lamha, brother of Oilill Olum, died, and also Moicheallog, the saint, who lived and blessed 
at Cill Moicheallog; and this saint was of the race of Conaire, son of Eidirsceol. After this Ceallach fell 
at the Brugh on the Boyne, and Conall Caol was slain by Diarmaid, son of Aodh Slaine.


Blathmac and Diarmaid Ruanuidh, two sons of Aodh Slaine, son of Diarmaid, son of Fearghus Ceirrbheoil, 
son of Conall Creamthainne, son of Niall Naoighiallach, of the race of Eireamhon, held jointly the 
sovereignty of Ireland seven years; and it was in their reign that Hossa fought the Battle of Pancti, where 
fell the king of Sacsa and thirty lords of his people. It was about this time that St. Ulltan died, and 
Maodhag of Fearna, son of Seadna, son of Earc, son of Fearadhach, son of Fiachraidh, son of Amhalghuidh, son 
of Muireadhach, son of Carrthann, son of Earc, son of Eochaidh, son of Colla Uais, and Cumin Foda, son of 
Fiachna the saint, and Maonach, son of Finghin, king of Munster. Diarmaid Ruanuidh and Blathmhac died of the 
plague called the Buidhe Conaill.


Seachnasach, son of Blathmac, son of Aodh Slaine, son of Diarmaid, son of Fearghus Ceirrbheoil, son of 
Conall Creamthainne, son of Niall Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland 
six years. It was in the reign of this king that the Battle of Feart took place between the Ulstermen and 
the Cruithnigh, wherein there were many slain on both sides. It was about this time that Baoithin, abbot of 
Beannchair, died. After this Seachnasach, king of Ireland, fell by Dubh nDuin, of the Cineal Cairbre.


Ceannfaolaidh, son of Blathmac, son of Aodh Slaine, son of Diarmaid, son of Fearghus Ceirrbheoil, son of 
Conall Creamthainne, son of Niall Naoighiallach, of the race of 


---

p.139




Eireamhon, held the sovereignty of Ireland four years. And it was in his reign that Beannchair was burned, 
and its community slain by foreigners. And the reason why this place is called Beannchair is this, Breasal 
Breac, king of Leinster, went with a full host to plunder Alba, and brought much cattle and herds with him 
to Ireland, and when himself and his host came to land they built a camp in the place which is now called 
Beannchair, and they killed many of the cows for meat, and many of the cows' horns, or beanna, remained throughout the plain; and hence the place was given the name of Magh Beannchair. And a long time after that, when the holy abbot Comhghall built a monastery in the same place he ordered that it be names from the place in which it was built, and hence it is called the Monastery of Beannchair. Soon after the foreigners had burned this monastery, Ceannfaolaidh, king of Ireland, was slain by Fionnachta Fleadhach, son of Donnchadh, in the Battle of Cealltair.


Fionnachta Fleadhach, son of Donnchadh, son of Aodh Slaine, of the race of Eireamhon, held the 
sovereignty of Ireland seven years; and in his reign many banquets and feasts used to take place in Ireland, 
hence he is called Fionnachta Fleadhach. It was too, in his reign that Colman, bishop of Inis Bo Finne, 
died, and Fionan, who lived and blessed in Ard Fionain; and this Fionan was of the race of Fiachaidh 
Muilleathan; and St. Arannan died. It was Fionnachta who won the Battle of Loch Gabhair against the 
Leinstermen, where many of the Leinstermen fell by him. It was in his reign that Ceannfaolaidh, the learned, 
died, and Dunghal, son of Scannal, king of the Cruithnigh, and Ceannfaolaidh, king of Ciannachta Ghlinne 
Geimhean, were burned by Maolduin, son of Maoilfithrigh, in Dun Ceitheirn. It was in his reign, moreover, 
that the British made an incursion into Ireland, according to Beda in the 26th chapter of the fourth book. 
The leader of the 


---

p.141




host of the king of Sacsa, whose name was Egberthus, the leader's name being Berthus, came and plundered a 
large part of Ireland, in the age of the Lord 684. Thus does Beda lament this deed: *Berthus plundered deplorably an inoffensive nation and one ever most friendly to the people or race of Sacsa. {Berthus vastavit misere gentem innoxam et nationi Anglorum semper amicissimam.}’’*

 And they fought the Battle of Raith Mor in Magh Line, wherein they slew Cumascach, king of the Cruithnigh, together with a large body of Gaels. Moreover, the Britons went thence on an expedition to the Orcades and plundered that island. A company of them also landed in the east of Leinster, and they plundered churches and country districts, and they returned after having committed much spoiling and plundering. Here is a stanza that Adhamnan composed for Fionnachta when he remitted the Boraimhe to Molaing:


> 1. Fionnachta, son of Donnchadh,
>   
> Remitted much to a saint:
>   
> Thrice fifty hundred chained cows,
>   
> And each cow with her calf.
> 



Soon after that Fionnachta, king of Ireland, was slain by Aodh, son of Duitheach, and by Conghalach, son of 
Conaing, at Greallach Doluidh.


---

p.143


XV.
---


Loingseach, son of Aonghus, son of Domhnall, son of Aodh, son of Ainmire, of the race of Eireamhon, held 
the sovereignty of Ireland eight years. It was in his reign that Adhamnan came from Alba to Ireland to 
preach, and Moling, of Luachair, died, and Magh Muirtheimhne was plundered by the Welsh. It was in the reign 
of this king that a great cow-plague existed in Sacsa and in Ireland, and there was a famine for three years 
in Ireland, so that the people devoured one another there at this time. It was about this time that St. 
Egberthus went to preach to Alba, and Muireadhach Muilleathan, king of Connaught, died, and the Ulstermen 
won the Battle of Magh Cuilinn over the Britons, where many Britons fell. It was about this time that 
Adhamnan, abbot of I, died, aged seventy-seven years, and the Saracens, with a numerous host, laid siege to 
Constantinople and built a three years encampment around it. After this they raised the siege. After this 
Coibhdhean, bishop of Ard Srath, died. Soon after this the Battle of Corann was fought by Ceallach, son of 
Raghallach, who was king of Connaught for seven years, wherein he slew Loingseach, son of Aonghus, king of 
Ireland.


Conghal Ceannmhaghair, son of Fearghus Fanad, son of Conall Gulban, son of Niall Naoighiallach, of the 
race of Eireamhon, held the sovereignty of Ireland nine years. It was this Conghal who burned all Cill Dara, 
both church and district. But he himself got a sudden and instant death after this event.


Fearghal, son of Maoilduin, son of Maoilfhithrigh, son of Aodh Uairiodhnach, son of Domhnall, son of 
Muircheartach, son of Muireadhach, son of Eoghan, son of Niall Naoighiallach, of the race of Eireamhon, held 
the sovereignty of Ireland seventeen years. Ceacht, daughter of Ceallach, son of Maolcobha, king of Cineal 
Conaill, was this Fearghal's mother. And it was in his reign that Baodan, bishop of 


---

p.145




Inis Bo Finne, died, and a battle was fought between the Dal Riada and the Britons in the place called Cloch 
Mhionnuirc, and the Britons were defeated there. It was about this time that Neachtain, king of Alba, 
expelled a community of monks from Britain for animadverting on his vices.


It was in the reign of this king that there fell the three showers from which Niall Frasach is named, as 
he was born when these freasa or showers fell; a shower of 
honey on Fothain Bheag and a shower of silver on Fothain Mhor and a shower of blood on Magh Laighean. It was 
about this time that the Battle of Almhuin was fought between Murchadh, son of Bran, who was fifteen years 
king of Leinster, and Fearghal, son of Maolduin, king of Ireland; and the host the king of Ireland brought 
to that battle amounted to twenty-one thousand, and the host the king of Leinster brought there amounted to 
nine thousand and eight score chosen warriors as a bodyguard to the king himself when going into the battle. 
And the king of Ireland was defeated in the battle, and two hundred and sixty-nine of his people were seized 
with frenzy, and three thousand two hundred of them were slain; and others say that seven thousand of them 
were slain. The reason why this disaster befell the king of Ireland was that when he was on the point of 
setting out to fight the Battle of Almhain a party of his followers went to plunder a church called Cillin, 
and carried off by force the one cow that the solitary hermit of that church had and the hermit cursed the 
king and his host, and hence they met reverse in battle; and the king of Ireland fell there with many of his 
people, as we have said above.


Fogharthach, son of Niall, son of Cearnach Sotal, son of Diarmaid, son of Aodh Slaine, of the race of 
Eireamhon, held the sovereignty of Ireland one year, and fell by Cionaoth, son of Iorghalach, in the Battle 
of Beilge.


Cionaoth, son of Iorghalach, son of Conuing Currach, 


---

p.147



 
son of Conghal, son of Aodh Slaine, of the race of Eireamhon, held the sovereignty of Ireland four years. It 
was in the reign of this king that the relics of Adhamnan were brought from Alba to Ireland. After that the 
Battle of Drom Corrain was won by Flaithbhearthach, son of Loingseach, against Cionaoth, son of Iorghalach, 
where Cionaoth, king of Ireland, fell, and many of his people along with him.


Flaithbhearthach, son of Loingseach, son of Aonghus, son of Domhnall, son of Aodh, son of Ainmire, of the 
race of Eireamhon, held the sovereignty of Ireland seven years. Muireann, daughter of Ceallach, was the 
mother of this Flaithbhearthach. It was in the reign of this king, according to Beda, that the Battle of 
Drom Dearg, in Alba, was fought between Drust and Aonghus, two kings of the Cruithnigh, for the mastery of 
the country, and Drust and many of his people fell there.


And soon after that was fought the Battle of Murbholg between the Dal Riada and the Picts, that is, the 
Cruithnigh, wherein many of the Picts were killed. It was about this time that the Battle of Fotharta, in 
Muirtheimhne, was won by Aodh Ollan and by the clann Neill against the Ultonians, wherein Aodh Roin, who was 
thirty years king of Ulster, and Conchadh, son of Cuana, king of Cobha, were slain. After this 
Flaithbhearthach, son of Loingseach, king of Ireland, died at Ard Macha.


Aodh Ollan, son of Fearghal, son of Maolduin, son of Maoilfithrigh, son of Aodh Uairiodhnach, son of 
Domhnall, son of Muirchearthach, son of Muireadhach, son of Eoghan, son of Niall Naoighiallach, of the race 
of Eireamhon, held the sovereignty of Ireland nine years. Brige, daughter of Orca, son of Carrthann, was 
mother of Aodh Ollan. It was in the reign of this Aodh that the Battle of Bealach Feile was fought between 
Munster and Leinster, wherein fell many Munstermen and Leinstermen, together with Ceallach, son of Faolchur, 
king of Osruighe. It was 


---

p.149




Cathal son of Fionghaine, king of Munster, who won that battle.


After this Aonghus, son of Fearghus, king of the Picts, routed and defeated the Dal Riada in Scotland, 
and he plundered and robbed them and burned Dun Creige; and he seized Donnghal and Fearghus, two sons of 
Sealbhuidhe, king of Dal Riada, and put them in prison. It was about this time that a meeting took place 
between Aodh Ollan, king of Ireland, and Cathal, son of Fionghaine, king of Munster, at Tir Daghlas, in 
Urmhumha, where they imposed Patrick's rule and law and tribute on Ireland. Soon after that the Battle of 
Ath Seannaigh, that is, the Battle of Uchbhadh, was fought between Aodh Ollan, king of Ireland, and Aodh, 
son of Colgan, king of Leinster, wherein Aodh Ollan, was severely wounded, and wherein fell Aodh, son of 
Colgan, and Bran Beag, son of Murchadh, half-king of Leinster, together with many Leinster nobles, and nine 
thousand Leinstermen fell there. After that Flann, son of Cronnmhaol, bishop of Reachruinne, and Cathal son 
of Fionnghaine, king of Munster, and Aodh Balbh son of Innreachtach, who was the king of Connaught seven 
years, died; and Aodh Ollan, king of Ireland, was slain in the Battle of Seiridmheadh, that is at Ceanannus,
by Domhnall son of Murchadh.


Domhnall, son of Murchadh, son of Diarmaid, son of Airmeadhach Caoch, son of Conall Guithbhinn, son of 
Suibhne, son of Colman Mor, son of Diarmaid, son of Fearghus Ceirrbheoil, son of Conall Creamhthainne, son 
of Niall Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland forty-two years. Ailpin, 
daughter of Comhghall, of the Dealbhna Mor, was mother of Domhnall, son of Murchadh, king of Ireland. It was 
in his reign that Colman, bishop of Laosan, was slain by the Ui Turtaire, and Cormac, bishop of Ath Truim, 
died. It was about this time that the form of a serpent was seen in motion in 


---

p.151




the air; and Seachnasach, son of Colgan, king of Ui Cinnsealaigh died; and Caitheasach, son of Oilioll, king 
of the Cruithinigh, was slain at Raith Beitheach by the Leinstermen. It was in the reign of this king that 
Suairleach, bishop of Fobhar, died, also Osbhran, bishop of Cluain Chreamhuidh.


After that was fought the Battle of Bealach Cro by Criomhthann, son of Eanna, where fell Fionn, son of 
Arb, at Tiobraid Fhinn, and the Dealbhna were slaughtered around him; and it is from this event that the 
lake in that place is called Loch an Bhealaigh Chro, and the well that is in the same place is called Tobar 
Finn. It was about this time that Cumascach, king of Ui Failghe, fell by Maolduin, son of Aodh Beannan, king 
of Munster, and Aonghus, king of Alba, died; and Mac Coinchearca, king of Osruighe, won the Battle of 
Bealach Gabhran against Dungal, son of Laidhghein, king of Ui Cinnsealaigh, wherein Dunghal was slain, 
together with many of the Leinster nobles. And Muirchearthach, son of Murchadh, king of Leinster, died. 
After this Domhnall, son of Murchadh, first king of Ireland of the clann Colmain, died.


Niall Frasach, son of Fearghal, son of Maolduin, son of Maoilfithrigh, son of Aodh Uairiodhnach, son of 
Domhnall, son of Muircheartach, son of Muireadhach, son of Eoghan, son of Niall Naoighiallach, of the race 
of Eireamhon, held the sovereignty of Ireland four years. Aithiochta, daughter of Cian O Conchubhair king of 
Ciannachta, was the mother of Niall Frasach. And the reason why he is called Niall Frasach is that there 
fell three showers in Ireland when he was born—a shower of honey on Fothain Bheag and a shower of 
silver on Fothain Mhor and a shower of blood on Magh Leighean. And frais means a shower. It was in the reign of this Niall that Duibhionnracht, son of 
Cathal, son of Muireadhach Muilleathan, who was five years king of Connaught, died; and there was an 
earthquake and a great famine in Ireland, and Dunghal, 


---

p.153




son of Ceallach, king of Osruighe, died. After that was fought the Battle of Achadh Liag between Ui mBriuin 
and Ui Maine, where many fell on either side, and Cronnmhaol, bishop of Cill Mhor, and Ailpin, king of the 
Picts, and Aolgnat, bishop of Ard Breacain, died. Soon after that Artghaile, son of Cathal, went on a 
pilgrimage to I Columcille, in Alba, and Fearghus, bishop of Daimhliag, died; and at Corann there was a 
battle fought between Cineal Conaill and Cineal Eoghain, wherein Maolduin, son of Aodh Ollan, king of the 
Fochla, was victorious, and Domhnall, son of Aodh Muindearg, was defeated and many of his people slain 
there. After this Niall Frasach, king of Ireland, died in I Columcille, in Alba.


XVI.
----


Donnchadh, son of Domhnall, son of Murchadh, son of Diarmaid, son of Airmeadhach Caoch, son of Conall 
Guithbhinn, son of Suibhne, son of Colman Mor, son of Diarmaid, son of Fearghus Ceirrbheoil, son of Conall 
Creamhthaine, son of Niall Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland 
twenty-seven years, and it was on his pillow he died.


Aodh Oirndighe, son of Niall Frasach, son of Fearghal, son of Maolduin, son of Maoilfithrigh, son of Aodh 
Uairiodhnach, son of Domhnall, son of Muircheartach, son of Muireadhach, son of Eoghan, son of Niall 
Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland twenty-four years. Dunlaith, 
daughter of Flaithbheartach, son of Loingseach king of Cineal gConaill, was the mother of *Aodh* Oirndighe. And he is called Aodh Oirndighe, for when he was weaned from his nurse's 
breasts he set to suck his fists as if he were sucking his nurse's breasts; hence he was called Aodh 
Oirndighe or Aodh Doirndighe.




---

p.155


It was in the reign of Aodh Oirndighe that the Lochlonnaigh first came to Ireland in the year of the Lord 
820. And twelve years after that the tyrant Turgesius came to Ireland, and it was Olchobhar, son of 
Cionaoth, son of Conghal, son of Maolduin, son of Aodh Beannain, who was king of Munster at that time 
according to certain chroniclers. But the Policronicon where it treats of Ireland in its chronicle says that 
it was when Feidhlimidh, son of Criomhthann, reigned in Munster that the Lochlonnaigh first came to Ireland. 
Thus it speaks: *From the coming of Patrick to the time of Feidhlimidh, son of Criomhthann, king of 
Munster, thirty-three kings held the sovereignty of Ireland during the period of the four hundred years that 
elapsed from the coming of Patrick to Ireland till Feidhlimidh assumed the sovereignty of Munster; and in 
the time of Feidhlimidh came the Norwegians with their leader Turgesius to conquer that country, (that 
is, Ireland).{Ab adventu Sancti Patricii usque ad Feilimidii regis tempora 33 reges per quadringentos 
annos in Hibernia regnaverunt, Tempore autem Feilimidii Noruaegienses duce Turgesio terram hanc 
occuparunt.}’’*

 Others say that it was when Airtre, son of Cathal, reigned in Munster, the Lochlonnaigh began to come to plunder Ireland. And in this they are right. However, they did not get a grip of Ireland though they harassed the country. Moreover what the Policronicon states is true where it says that it was in the reign of Feidhlimidh, son of Criomhthann, over Munster that the tyrant Turgesius, who reduced Ireland to slavery, came. True also is the statement of those who assert that the Lochlonnaigh came to Ireland in the reign of Olchobhar over Munster, but the tribe who came hither then were the Dainfhir or Danes from Dania, that is Denmark, and it is these are called Duibhgheinnte or Dubhlochlonnaigh in the old books of the **seanchus**, while the Norwegians are called Finngheinnte or Fionnlochlonnaigh.
Understand now, O reader, that Lochlonnaigh in Irish is not a specific name for any 
particular tribe, but 


---

p.157




Lochlonnach means a man who is strong at sea; for lonn means strong and loch means the sea; and since the inhabitants of those countries of the north of Europe held for a time powerful sway over Ireland, as we shall hereafter relate, the Irish called them Lochlannaigh, that is men strong at sea, because of the great sway they acquired over the Gaels as we shall show below on the authority of the book which is called Cogadh Gall re Gaedhealaibh. Here follows a short summary of the history.


While Aodh Oirndighe reigned over Ireland and Airtre son of Cathal was king of Munster, the foreigners 
came to Caoin-inis O bhFathaidh, their number being the manning of sixty ships, and they ravaged the country 
and plundered and burned Inis Labhrainne and Dairinis; and the *Eoghanacht* of Loch Lein gave them battle, and therein were slain four 
hundred and sixteen foreigners. Another fleet bringing Fionnlochlonnaigh, that is Norwegians, came to 
Ireland the second year of Feidhlimidh son of Croimhthann's reign over Munster, and they ravaged and 
plundered Inis Teimhin and Beannchair and Cluain Uama and Ros Maolaidh and Sceilig Mhichil. 
Another fleet came to the north of Ireland and they plundered Beannchair in Ulster and slew its bishop, and 
its learned people, and they broke the shrine of Comhghall. Another fleet of the same people came to Ui 
Cinnsealaigh, and they plundered Teach Munna, Teach Moling and Inistiog; and they went thence to Osruighe 
and they plundered the country; and the Ossorians gave them battle and seven hundred and seven of the 
Lochlonnaigh fell. Similarly Dun Deargmhuighe and Inis Eoghanain and Disirt Tiobraide and Lios Mor were 
spoiled by them. They burned and spoiled Ceall Molaise, Gleann da Loch, and Cluain Ard Mobheadhog and Sord 
Cholum Chille and the Daimhliag Chiarain and Slaine and Cealla Saile and Cluain Uama and Mungairid and the 
greater number of the churches of all Ireland.




---

p.159


Another fleet of them entered the harbour of Luimneach and spoiled and plundered Corca Baiscinn and 
Tradruidhe and Ui Conaill Gabhra, and the Ui Conaill gave them battle at Seannaid, and many of the 
Lochlonnaigh were slain therein, but we do not know the full number. After that Turgesius the tyrant came 
with a large fleet to the north of Ireland and became ruler of all the Lochlonnaigh that were then in 
Ireland, and they spoiled all the north of Ireland, and they let the Danair loose on the entire of Leath 
Cuinn; and they put some of their vessels on Loch nEachach and others in Lughmhuigh and on Loch Ribh, and 
they plundered Ard Macha thrice in a single month. And Turgesius took possession of the abbacy of Ard Macha, 
as Columcille had foretold, as he himself says:


> 1. A fleet on Loch Ribh,
>   
> The Gentiles will be greatly uplifted;
>   
> Of them will be the abbot of Ard Macha,
>   
> And the tyranny of a despot.
> 




The saints of Ireland foretold that evil would befall Ireland through the pride of their rulers, and 
through their tyranny, hence the oppression of the Lochlonnaigh came on them in the reign of Airtre son of 
Cathal over Munster, and of Aodh Oirndighe over all Ireland. And it was with the tyrant Turgesius that the 
Lochlonnaigh came again to Ireland when Feidhlimidh, son of Criomhthann, was king of Munster; and it was 
this Turgesius who banished Farannan the primate and his clergy from Ard Macha, as we have said, and he took 
their place himself, and he was seized by Maoilseachlainn afterwards, who drowned him in Loch Ainninn, as 
we shall relate below. It was in the reign over Ireland of Aodh Oirndighe that the Lochlonnaigh plundered 
Inis Phradraig and many of the islands that lie between Ireland and Alba.


It was about this time that Patrick's tribute was imposed on the people of Connaught by Gormghal, son of 


---

p.161




Din Dathaidh, and Aodh Oirndighe divided Meath between the two sons of Donnchadh, son of Domhnall, to wit, 
Conchubhar and Oilill; and I Coluimcille in Alba was burned by the Lochlonnaigh at this time, and Laighin 
was twice plundered in one month by Aodh Oirndighe, king of Ireland. In the following year, after the Feast 
of St. Patrick, there were great thunder and lightning in Ireland, which killed one thousand and ten 
persons, male and female, between Corca Baiscinn and the sea, and Inis Fide burst itself into three parts, 
and in that place as much land as would support twelve cows was deluged, the sea having come over it.


It was about this time that Aodh Oirndighe, king of Ireland, together with a numerous host went into 
Leinster to Dun Cuair; and he divided the province of Leinster between two, that is between Muireadhach, son 
of Ruaraidh and Muireadhach, son of Bran. After that the Lochlonnaigh burned Inis Muireadhaigh. About this 
time Eochaidh, bishop of Tamhlacht, died; and the Lochlonnaigh wreaked great slaughter on the men of Umhall, 
on which occasion Coscrach, son of Flonn Abhradh and Dunadhach, king of Umhall, died; and Eidirsceol, son of 
Ceallach, bishop of Gleann da Loch, and Siadhal, bishop of Ros Commain, died. After that Aodh Oirndighe, 
king of Ireland, was slain in the Battle of Da Fearta by Maolcanaigh.




---

p.163


XVII.
-----


Conchubhhar, son of Donnchadh, son of Domhnall, son of Murchadh, son of Diarmaid, son of Airmeadhach 
Caoch, son of Conall Guithbhinn, son of Suibhne, son of Colman Mor, son of Diarmaid, son of Fearghus 
Ceirrbheoil, son of Conall Creamhthaine, son of Niall Naoighiallach, of the race of Eireamhon, held the 
sovereignty of Ireland fourteen years. It was in the reign of this Conchubhar over Ireland that 
Ceannfaolaidh, bishop of Ath Truim, died, and Eochaidh O Tuathail, bishop of Lughmhagh; and Inis Daimhli and 
Corcach were plundered by the Lochlonnaigh; and Patrick's tribute was imposed on Munster by Feidhlimidh son 
of Criomhthann, and by Airtre son of Conchubhar, and Patrick's tribute was imposed on Connaught by the same 
Airtre; and Beannchair and Dun Leathghlaise were plundered by the Lochlonnaigh; and they burned Magh Bile 
and its penitential cells. About this time Muireadhach, son of Eochaidh, was king of Ulster, and Conchubhar, 
son of Donnchadh, king of Ireland, inflicted the Defeat of Aonach Tailltean on the Gaileanga, wherein many 
of them fell; and the Lochlonnaigh inflicted a great defeat on the Leinstermen at Drom Connla, where 
Conuing, son of Cu Choingiolt, king of the Forthuath, fell, and several others with him. After that Ard 
Macha was plundered by the Lochlonnaigh, and a month afterwards Lughmhagh and Finé Chiannachta and 
Lios Mor with all their churches were plundered by them.


Now up to this time there were four chief schools in Ireland, to wit, a school at Ard Macha in which there were seven thousand students according to an old scroll which was found in Oxford, and a school at 
Cashel, a school at Dun da Leathghlais and a school at Lios Mor, together with numerous colleges as well. But they were now 


---

p.165




broken up. After this Conchubhar son of Donnchadh, king of Ireland, died.


Niall Caille, son of Aodh Oirndighe, son of Niall Frasach, son of Fearghal, son of Maolduin, son of Maolfithrigh, son of Aodh Uairiodhnach, son of Domhnall, son of Muircheartach, son of Muireadhach, son of 
Eoghan, son of Niall Naoighiallach, of the race of Eireamhon, held the sovereignty of Ireland fifteen years. Meadhbh, daughter of Innreachtach, son of Muireadhach, king of Connaught, was the mother of this Niall. And 
he is called Niall Caille, for one day when Niall with a large host of cavalry approached the river which is called Callann, and there was a great flood in the river at that time, a youth of the king's party went 
before them to explore the river and was drowned. The king asked the party to go to his relief and he got no one to go. The king himself went on his horse to relieve him, and as the horse's feet touched the bank of 
the river, the bank gave way and the river carried away the king, and he was drowned, as it was foretold him that he would die by being drowned at Callann. For this reason he is called Niall Caille.


It was in the reign of this Niall that Diarmaid, son of Tomaltach, king of Connaught, died, and Loch Bricirnne was plundered against Conghalach, son of Eochaidh, and he himself was slain by the Lochlonnaigh; 
and Niall Caille, king of Ireland, went with a large host to Leinster to appoint a king over them, that is Bran, son of Faolan. After that Fearna Maodhog was plundered by the Lochlonnaigh, and Mungairid and many 
churches in Urmhumha were burned by them; and similarly Cill Dara was plundered by the Lochlonnaigh. It was 
about this time that the crews of sixty ships came from Normandy to the Boyne, and forty ships to the river Lithfe, and that fleetful plundered Magh Lithfe, that is the county of Ath Cliath, and Magh Breagh, that is 
Fine Ghall, their churches, fortresses and dwellings. 


---

p.167




After this the Lochlonnaigh won a battle over the Ui Neill at Inbhear na mBarc, between the Sionainn and the 
sea, wherein many fell though only their chief leaders are mentioned; and Inis Cealltra and Cluain Mic Nois 
and all the churches of Loch Eirne were burned by the Lochlonnaigh.


It was about this time that Feidhlimidh, son of Criomhthann, was king of Munster and archbishop of Leath Mogha, and he went to plunder Leath Cuinn from Biorra to Teamhair Bhreagh, and he was detained at Teamhair; 
and Innreachtach, son of Maolduin, was slain by Feidhlimidh's party at Teamhair, and soon after that Feidhlimidh, son of Criomhthann, died, having been then twenty seven years king of Munster; and the 
character the Leabhar Irsi gives of him is: *the excellent, wise man and anchorite of the Scots, rested in peace. {Optimus sapiens et anachorita Scotorum quievit.}’’*

 From this it is to be inferred that Feidhlimidh, son of Criomhthann, was a wise and pious man in his own time.
This Feidhlimidh made the circuit of Leath Cuinn, and paid the rents that by law its kings were entitled 
to from the king of Cashel—*and* the food-supply that they 
were bound to give in exchange for them—and the wages that the kings of Cashel were bound to pay to 
the kings of Leath Cuinn and to the kings of Leinster, and to the chief territorial lords that were under 
them, as St. Beinen, son of Seiscnen, primate of Ireland, sets it down in the Book of Rights in the poem 
which begins: Every king is entitled to get from the king of Cashel. Now the following are the rent and wages of these kings from the king of Cashel, and his circuit amongst them and his seasons for 
getting provisions from them on the occasion of it; a hundred swords, a hundred goblets, a hundred steeds 
and a hundred mantles for the king of Cruachain, and provision for two quarters from the king of Cruachain 
for the king of Cashel, and that he should escort him to Tir Chonaill; twenty bracelets or rings, twenty 
chess-boards, twenty steeds for 


---

p.169




the king of Cineal Conaill, and provision for a month from the king of Cineal Conaill, and that he should 
escort him to Tir Eoghain; fifty gob1ets, fifty swords for the king of Oileach, and provision for a month, 
and that he should escort him to Tulach Og; thirty goblets, thirty swords for the prince of Tulach Og, 
provision for twelve days from him for the king of Munster, and that he should escort him to Oirghialla; 
eight coats of mail, three score tunics and three score steeds for the king of Oirghialla, and provision for 
him for a month in Eamhain, and that he should escort him to Ulster to the clann Rudhruighe; a hundred 
goblets, a hundred mantles, a hundred swords, a hundred steeds and ten ships for the king of Ulster and 
provision for two months from the clann Rudhruighe for him, and that he should escort him to Tara; thirty 
coats of mail, thirty rings, a hundred steeds and thirty chess-boards for the king of Tara, and provision 
for a month from the king of Tara for him and the four tribes of Tara to escort him to Ath Cliath; ten 
women, ten ships, ten steeds for the king of Ath Cliath and provision for a month for him from the king of 
Ath Cliath, and that he should escort him to Leinster; thirty cows, thirty ships, thirty steeds, thirty 
female slaves or maidens for the king of Leinster, and provision for two months for him from Leinster, to 
wit, a month from Upper Leinster and a month from Lower Leinster; thirty steeds, thirty coats of mail, 
thirty swords for the chief for Lower Leinster from the king of Cashel. Understand, O reader, that I am not 
the author of these things, but St. Beinen, as is plain from the Book of Rights.




---

p.171


XVIII.
------


And after the death of Feidhlimidh, son of Criomhthann, Olchobhar, abbot of Imleach Iobhair, assumed the 
sovereignty of Cashel; and in that year Maoilseachlainn, king of Meath, won a battle over the Lochlonnaigh 
at Casan Brige in Meath, where seven hundred of them fell, and Tighearnach defeated them at Doire Dhisirt 
dha Chonna. It was about this time that Saxolbh, leader of the Lochlonnaigh, was slain by the Ciannachta of 
Gleann Geimhean, and great slaughter was made of the Lochlonnaigh at Carn Fearadhach and terrible slaughter 
also at Eas Ruadh.


After this Ath Cliath was first taken by the Lochlonnaigh. It was also about this time that Cormac son of 
Cuileannan, who was king of Munster seven years, and was at the same time archbishop at Cashel, was born, 
and the bishop of Tealach, whose name was Exnich, was slain, and the Lochlonnaigh won a battle over the 
Connaughtmen, in which fell Maolduin, son of Muirgheas, and many Connaughtmen with him; and Brian, son of 
Faolan, king of Laoighis, died. After that the Lochlonnaigh came with a large fleet on Loch nEachach, and 
they plundered the districts and churches of the north of Ireland and similarly they burned Fearna and 
Corcach.


Niall Caille, king of Ireland, went at this time with a numerous host to plunder and spoil Feara Ceall 
and Dealbhna Eathra; and Murchadh, son of Aodh, king of Connaught, died at this time, also Joseph, bishop of 
Cluain Uais. It was about this time also that the Lochlonnaigh built a camp on Linn Duachaill from which 
they plundered the districts of Teathbha. Similarly the Lochlonnaigh built another camp at Duibhlinn from 
which they plundered Leinster and Ui Neill and their districts and churches to Sliabh Bladhma. And after 
that they plundered Cluain


---

p.173




Eidhneach and Cluain Ioraird and Cluain Mic Nois; and Fearghus, son of Fothach, king of Connaught, died; and 
Turgesius, chief of the Lochlonnaigh, built a dun and a fortress on Loch Ribh; and they plundered Cluain Mic 
Nois again, and Cluain Fearta of Breanainn and Tir da Ghlas and Lothra and many other stone fortresses. And 
after that Gormghall, son of Din Dathaidh, bishop of Lann Leire, died. And Niall Caille, king of Ireland, 
gave the Lochlonnaigh battle on Magh Iotha wherein many of them fell by him. And it was soon after this that 
Niall Caille, king of Ireland, was drowned at Callan, as we have said.


The tyrant Turgesius of Norway with his army of Fionnlochlonnaigh held the supremacy of Ireland thirteen 
years, after he had been harassing the country for seventeen years; and during that time he was oppressing 
and coercing Ireland, a large fleet having come from Norway to help him; and they put into harbour in the 
north of Ireland; and they plundered that country and got hostages thence, and they sent boats manned to 
spoil Loch nEachach and Loch Ribh, as we have said, in accordance with what Columcille prophesied in the 
stanza already given.


Bearchan of the Prophecy also foretold that a tyrant of the Lochlonnaigh would be king of Ireland, and 
similarly that every church in Ireland would have an abbot of the Lochlonnaigh. Thus does he speak in the 
following stanza: 


> 1. The Gentiles will come over the stuttering sea,
>   
> They will commix with the men of Ireland;
>   
> An abbot of their race will rule each church;
>   
> Of them will be a king of Ireland.
> 




When the nobles of Ireland saw that Turgesius was upsetting the country, and that he had it in his power, 
and that he was enslaving and tyrannising over it, these nobles assumed a magnanimous courage and a valorous 
steadfast spirit, and they underwent great hardship and


---

p.175




distress in their conflict with these tyrants. Here follow some of the defeats which the Gaels inflicted on them, namely, their defeat by the Cineal Conaill at Eas Ruadh where many of them were slain; and their 
defeat by the Dal gCais at Ard Breacain; and when Saxolbh, an earl of the Lochlonnaigh with his party was 
slain by the Ui Colgan; and when Olchobhar, son of Cionaoth, king of Munster, and Lorcan, son of Ceallach, king of Leinster, won the Battle of Sciath Neachtain over them, wherein they slew Earl Tomar, **tanist** to the king of Lochlonn, together with twelve hundred of the nobles of the 
Lochlonnaigh. Moreover, the same Olchobhar and the Eoghanacht of Cashel overthrew them near Cashel, where 
five hundred of them fell at Dun Mhaoile Tuile. Three hundred and sixty of them fell by the Ui Fidhghinnte, and two hundred by the Ciannachta, and twelve hundred at Drom da Chon by Tighearnach, king of Loch Gabhair; 
and also Maoilseachlainn, son of Maolruanuidh, king of Meath, overthrew them in the Battle of Glaslinn in which seventeen hundred Lochlonnaigh were slain.


Though there were many battles and skirmishes fought between the Gaels and Turgesius with his Lochlonnaigh, still by reason of the numerous fleets and the many hosts that came to his aid from Norway and from other countries in the north of Europe, he conquered the Gaels and reduced them to subjection and to slavery to himself and to his foreigners.


Here is a short account of the slavery of the Gaels under the Lochlonnaigh, and of the rent and tribute 
imposed on them, to wit, a Lochlonnach king over every **cantred** in Ireland, and a chief 
over every district and an abbot over every church, a steward over every townland, and a mercenary or hired 
soldier over every house, while the householder had not the disposal of as much as a hen of his own 
property; and were there but one 


---

p.177




stripper in the house neither the babe one night old nor the sick person would get her milk, but it was kept 
for the soldier, and if he were not satisfied he took the householder with him to the assembly in pledge for 
his maintenance. The Lochlonnaigh exacted an ounce of gold each year from every man in Ireland or else the 
nose from his head. And neither lord nor lady wore a mantle or dress but the cast-off clothes and mantles of 
the Lochlonnaigh; they were not permitted to give instruction or frequent church—but the Lochlonnaigh 
were in their churches and in their duns—with no professors or clergy, without books or jewels in the 
abbey-churches and monasteries through fear of them; without a **filé**, without a 
philosopher, without a musician according to the laws of the country; without the daughter of a king or lord 
or chief wearing silk or embroidery; without the son of a king or a chief learning feats of agility or 
casting; with no feast or banquet held among friends, but what remained after the foreigners had been sated 
therefrom.


The severity of the servitude to which the Lochlonnaigh had brought the Gaels was the cause of great 
trouble to all the men of Ireland; and the remnant of their clergy that survived, and that were wont to hide 
themselves in woods and in secret places leading pious lives in wretchedness, earnestly prayed God to 
release them from the tyranny of Turgesius. They fasted also against him, and directed each of the faithful 
laity who were subject to them to do the same. And God heard their prayer, and put Turgesius in the power 
of the Gaels as we shall here immediately relate.


While Turgesius thus held oppressive sway, and while the Gaels were submissive to him in unwilling 
obedience, he built a fortified residence for himself near the duinlios of 
Maoilseachlainn, son of Maoilruanaidh, king of Meath;


---

p.179




and on a certain day when he came to the house of Maoilseachlainn he cast eyes on Maoilseachlainn's 
daughter, a beautiful marriageable maiden; and aged and self-indulgent as he was, he requested her father to 
give the maiden to him as his mistress. ‘My lord,’ replied Maoilseachlainn, ‘I am certain that thou 
wouldst not be content with my daughter as thy wedded wife, but wouldst deem it sufficient to have her for a 
time. I therefore beseech thee not to ask for her publicly lest she may be baulked of a husband; and as thy 
fortress happens to be near this **lios** in which I reside, I will send my daughter 
privately to meet thee, together with the fifteen most beautiful and loveable maidens in all Meath; and I am 
certain that when thou shalt see these ladies thou wilt pay neither heed nor attention to my own daughter, 
so far do they excel her in beauty.’ Turgesius approved of this, and they fixed a certain night on which 
the maiden with her attendant ladies was to be sent to meet Turgesius to his fortress. About this time there 
was a gathering and assembly of all the Lochlonnach chiefs in Ireland to meet Turgesius at Ath Cliath, with 
the view to take counsel as to maintaining and preserving their sway in the country; and while they were 
there Turgesius made known to some of the chiefs the agreement he had come to with Maoilseachlainn, and 
promised women to those of them who would go with him; and fifteen of the most daring and lustful of these 
chiefs went with him, and they did not rest or tarry till they reached the fortress of Turgesius together 
with their lord.


As to Maoilseachlainn he sent privately for fifteen of the most daring beardless youths that were in 
Meath, and directed that they be dressed in women's clothes, and wear a short sword each at the waist, and 
that they be thus sent disguised as women to accompany his daughter. And when the night came on which she 
was to be sent to meet Turgesius according to promise, 


---

p.181




the maiden set out, attended by her ladies, and went close up to the fortress, and sent a private message to 
Turgesius to inform him that herself and her ladies were near the house for the purpose of paying him a 
visit; and when he heard this, he directed the chiefs who were with him to go to their rooms, saying that he 
would send them women as he had promised. Thereupon they piled their arms into one heap on the table which 
was in the hall, and went to their rooms, each of them occupying a separate bed, waiting for these ladies to 
be distributed among them.


Now at this time Maoilseachlainn with a body of soldiers was with his daughter, and he directed a number 
of those youths who were with her disguised as women, the moment Turgesius should lay hands on his daughter 
for the purpose of detaining her with him, to seize him by force and take him captive, and another party to 
take possession of the arms that were in the house, and to spring upon the chiefs who were within; and he 
said that he himself with his body of soldiers would be near the house, and that he would rush into the 
house at the first cry to help them slay the Lochlannaigh. Thereupon the maiden with her ladies went in by a 
back door of the house and reached the room of Turgesius; and when they had come into his presence, he 
glanced at the maiden and her ladies and none of them pleased him but herself, and then he laid hands on her 
to detain her with him. When the youths who were with her saw this, a party of them seized Turgesius by 
force and made him captive; the remaining party seized the arms and held them in their possession, and then 
Maoilseachlainn with his party of soldiers came in, and they sprang on the party of Lochlonnaigh that were 
in the fortress, and slew them all, both chiefs and underlings except Turgesius alone; and when they had 
stripped the fortress bare they led Turgesius


---

p.183




to the duinlios of Maoilseachlainn where they kept him for a time in captivity.


Now when the Lochlonnaigh who were in Ireland heard that their chiefs were slain, and that Turgesius the tyrant had been captured by Maoilseachlainn, king of Meath, they grew dispirited and discouraged, so that 
every party of them who were in the interior of the country far from seaports used to escape secretly by 
night and make for their ships for the purpose of leaving Ireland; and those parties of them that were in 
the seaports used to fly to their ships to protect themselves from the onslaught of the Gaels who were in 
pursuit of them; so that the Lochlonnaigh were all banished from Ireland on that occasion except a small 
remnant of them who remained under the rule of the Gaels. And after they were banished Maoilseachlainn 
drowned Turgesius in Loch Ainninn, and this deed led to the nobles of Ireland choosing with one accord 
Maoilseachlainn as high king of Ireland, since the country had been freed by him from the slavery of the 
Lochlonnaigh.


**Buchanan** says that Greaghoir, king of Alba, with a numerous host came to plunder Ireland in the year of 
the Lord 877, and that he slew Brian and Conchubhar, two guardians of the king of Ireland, as the king of 
Ireland was a child. But this cannot be true; since we do not read in the **seanchus** 
that there was ever any king of Ireland, from the time of Slainghe to the Norman Invasion, but a king who 
obtained sovereignty of Ireland by the choice of the people, by the excellence of his exploits, and by the 
strength of his hand. And moreover, it was Turgesius the tyrant who was king of Ireland at that 
time.




---

p.185


XIX.
----


Maoilseachlainn, son of Maolruanuidh, son of Donnchadh, son of Domhnall, son of Murchadh, son of 
Diarmaid, son of Airmeadhach Caoch, son of Conall Guithbhinn, son of Suibhne Meann, son of Colman Mor, son 
of Diarmaid, son of Fearghus Ceirrbheoil, of the race of Eireamhon, held the sovereignty of Ireland sixteen 
years. Arog, daughter of Cathal, son of Fiachraidh, king of Feara Cul, was the mother of this 
Maoilseachlainn.


When the Lochlonnaigh had been banished by Maoilseachlainn, as we have said, and by the nobles of 
Ireland, the Fionnlochlonnaigh took counsel together in Norway as to how or by what means they might obtain 
a footing in Ireland in the hope of attaining to the mastery of Ireland once more. The plan they adopted was 
to get ready three leaders, who were brothers and of the noble blood of Norway, with a view to sending them 
with a fleet to Ireland on pretence of trading, and with many desirable commodities and many valuable jewels 
to bestow on and sell to the men of Ireland, in order to secure peace and alliance with them; so that they 
might thus deceitfully get a hold on the country and harass it once more. The Polycronicon refers to this 
affair thus: *After the death of Turgesius there came from the *regions* of 
Norway seeking for peace and on the pretext of trading three brothers, Amhlaoibh, Sitric and Iomhar to this 
island with their followers, and by the consent of the Irish who were fond of ease they set in order or 
built three seaports for their own residence, namely, Port Lairge, Ath Cliath and Luimneach. And after that, 
as the companies who came with them increased, they often made sudden attacks on the natives. {Post obitum Turgesii de Noruaegiae partibus, quasi sub pacis intuitu et mercaturae exercendae 
praetextu, tres fratres Amelanus, Cyracus et Iuarus cum sua sequela in hanc insulam appulerunt, et de 
consensu Ibernorum otio deditorum, maritima loca occupantes, tres civitates, viz., Waterfordiam, Dubliniam 
et Limericum construxerunt; qui tamen numero succrescentes contra indigenas frequenter 
insultabant.}’’*




---

p.187


From these words it is to be inferred that it was by the deceit of these three leaders the 
Fionnlochlonnaigh from Norway found an opportunity once more of depredating Ireland. And they grew in 
strength once again in Ireland for two reasons. The first of these reasons was the abundance of help they 
got from Norway in soldiers and ships time after time; and the second reason was the disagreement and the 
constant dissension that existed among the Gaels themselves at that time, and in which they mutually spent 
much of their force. And, moreover, they were accustomed to give free quarters man for man to the 
Lochlonnaigh, whence came to pass that these obtained sway once more in Ireland, and that they held the 
Gaels once again in servitude from this time till the death of Brian, as we shall show from the annals of 
Ireland in the following narrative.


While the Fionnlochlonnaigh were harassing Ireland in this manner a large fleetful of Dubhlochlonnaigh 
came from Dania or Denmark to Ath Cliath, and they plundered the coast of the country and slew many people; 
and thereupon the Fionnlochlonnaigh assembled to meet them, and a battle was fought between them at Linn 
Duachuill where the Fionnlochlonnaigh were defeated and a thousand of them were slain; and the 
Dubhlochlonnaigh in consequence obtained great sway in Ireland. And soon after this Amhlaoibh, son of the 
king of Lochloinn, came to Ireland to become chief ruler of the Danes or Dubhlochlonnaigh, and he imposed a 
rent-tax on a great number of the men of Ireland.


It was about this time that Olchobhar, son of Cionaoth, king of Munster, died, also Flaithnia, bishop of 
Biorar, and Cormac, bishop of Latrach Briuin, and Niall, son of Giollan, this latter having lived thirty 
years without food or drink. It was about this time that a great assembly or convention of the men of 
Ireland was held at 


---

p.189




Rath Aodha mic Bric under Maoilseachlainn, king of Teamhair, and Etgna, **comhorba** of 
Patrick, to make peace between the men of Ireland, and it was there Cearbhall, king of Osruighe, made 
submission to the **comhorba** of Patrick.


It was there also that Maolguala, son of Donnghal, king of Munster, and Cearbhall, king of Osruighe, made 
peace with Leath Cuinn. After this the people of Normandy stoned to death Maolguala, king of Munster. It was 
about this time that Maoilseachlainn, king of Ireland, fought the Battle of Drom Damhuighe, wherein he 
wreaked great slaughter on the Lochlonnaigh of Ath Cliath; and Domhnall, son of Ailpin, king of the Picti, 
died. Soon after this Maoilseachlainn, king of Ireland, died.


Aodh Finnliath, son of Niall Caille, son of Aodh Oirndighe, son of Niall Frasach, son of Fearghal, son of 
Maolduin, son of Maoilfithrigh, son of Aodh Uairiodhnach of the race of Eireamhon, held the sovereignty of 
Ireland sixteen years. Gormflaith, daughter of Donnchadh, son of Domhnall, was mother of Aodh Finnliath, and 
Maolmuire, daughter of Cionaoth, son of Ailpin, king of Alba, his wife, mother of Niall Glundubh.


It was in the reign of Aodh Finnliath that the following events took place, to wit, Conchubhar, son of 
Donnchadh, half-king of Meath, was slain by Amhlaoibh, son of the king of Lochloinn at Cluain Ioraird. After 
that this Amhlaoibh went with a numerous host of Lochlonnaigh to Foirthren in Alba, and pillaged and 
plundered the Picti and carried off hostages from them. It was about this time that Aodh Finnliath, king of 
Ireland, fought a great battle against the Lochlonnaigh of Loch Feabhail, and took away with him forty heads 
severed from the bodies of their leaders after he had slain twelve thousand of their number; and he robbed 
and plundered the fortress, spoiling it both of cattle and treasure. Soon after this Conall, bishop of Cill 


---

p.191




Scire, died; and the **dun** of Amhlaoibh, king of Lochloinn, was burned in Cluain Dolcain 
by the son of Gaoithin and by the son of Ciaran, son of Ronan; and they slew a hundred leaders of the 
Lochlonnaigh. After that Amhlaoibh plundered and spoiled Ard Macha, and slew a thousand Gaels and took much 
wealth and a large tribute therefrom. It was about this time that Ceannfaolaidh, son of Moichthighearn, who 
was thirteen years of age, died, and Donnchadh son of Dubh dha Bhuireann, held the sovereignty of Munster 
fourteen years; and a battle was fought between the Picti and the Dubhlochlonnaigh in which many of the 
Picti were slain. After this Rudhruighe, son of Moirmhinn, king of Britain, came to Ireland, fleeing from 
the Dubhlochlonnaigh, and the relics of St. Columcille were brought from Alba to Ireland to save them from 
the same people.


It was about this time, according to Cormac son of Cuileannan, that Lorcan son of Lachtna, was king of 
Thomond; and when the Dal gCais possessed only Thomond, the northern side of the palace of Cashel from the 
extreme corner to the door belonged to them; and they had twelve **cantreds** of land to 
share among them, to wit, from Leim Chon gCulainn to Bealach Mor in Osruighe and from Sliabh Echtghe to 
Sliabh Eibhlinne, and it was they were in the van of the Munster host when going to meet the enemy, and in 
the rear when returning from them, as Cormac son of Cuileannan says in this stanza: 


> 1. They are first marching into the enemy's country,
>   
> They are last when returning,
>   
> Through the greatness of their valour in every adversity,
>   
> This it is that distinguishes the Dal gCais.
> 



Aodh Finnliath, king of Ireland, died at Drom Ionascluinn in the district of Conall; and Tighearnach, son of 
Muireadhach, bishop of Drom Ionasclainn, died at this time.


Flann Sionna, son of Maoilseachlainn, son of Maolruanuidh, son of Donnchadh, son of Domhnall, son of 


---

p.193




Murchadh, son of Diarmaid, son of Airmeadhach Caoch, son of Conall Guithbhinn, son of Suibhne Meann of the 
race of Eireamhon, held the sovereignty of Ireland thirty-eight years. Lann, daughter of Dunghal, son of 
Fearghal, king of Osruighe, was the mother of Flann, son of Maoilseachlainn.


It was in the reign of Flann Sionna, king of Ireland, that the following events took place. For this king 
plundered and wasted all Munster and carried off captives therefrom. It was in his reign too that Domhnall, 
son of Muireigen was slain by his own companions, and Fiachna, son of Ainbhioth, son of Aodh Roin, who was 
king of Ulster for one year, and Donnchadh, son of Dubh dha Bhuireann, king of Munster, died. It was about 
this time that Cill Dara and Cluain Ioraird were plundered by the Lochlonnaigh; and Flonn Sionna, king of 
Ireland, convened the fair of Taillte; and Dubhlachtna, son of Maolguala, son of Donnghal, who was king of 
Munster seven years, died; and Sitric, son of Iomhar, was slain by a party from Normandy; and Aidheit, son 
of Laighneach, who was king of Ulster, was treacherously slain by his own companions; and Ard Macha was 
wasted by the Lochlonnaigh of Loch Feabhail, and there they seized on Cumuscach, king of Ulster, and Aodh 
mac Cumuscaigh, his son; and Domhnall, son of Constantin, king of Alba, died.




---

p.195


XX.
---


It was about this time that Cormac, son of Cuilennan, son of Sealbhach, son of Ailghionan, son of 
Eochaidh, son of Breasal, son of Aonghus, son of Natfraoch, son of Corc, son of Lughaidh Gaot, son of Oilill 
Flann Beag, son of Fiachaidh Muilleathan, son of Eoghan Mor, son of *Oilill* Olom, 
held the sovereignty of Munster seven years. And great was the prosperity of Ireland while Cormac reigned 
over Munster. For Ireland was filled with divine favour and worldly prosperity and constant peace in his 
time, so that cattle were without a herd and flocks without a shepherd during his reign; and cemeteries were 
protected in his time, and many churches and monasteries and public schools to teach letters, law and 
**seanchus** were built in his time; and there was much tilled land, many bees, many 
beehives, much fasting and prayer and piety of every kind; and many guest houses were being built and many 
books were being written in his time. And every good deed he asked others to do he did himself first, as 
almsgiving, mercy, prayer, Mass and every other such good action. And, moreover, he was fortunate in this 
that the party of Lochlonnaigh who were in Ireland for purposes of plunder abandoned the country while he 
reigned over Munster.


Now it happened that Cormac son of Cuileannan, was dwelling at Cashel on the approach of Easter, and he 
made proclamation throughout the Eoghanachts asking them to send to him to Cashel food and provisions with a 
view to the noble festival, and they refused him. But when the Dal gCais heard this they sent abundance of 
food and provisions to Cormac so that he was grateful to them. Cormac again sent messengers to the race of 
Eoghan asking them to send him jewels and valuables with a view to bestowing them on strangers since they 
did not send him food, but what the race of Eoghan did 


---

p.197





was to send him the worst arms and apparel they had, and hence he was displeased with them. Now when the Dal 
gCais heard this they sent him the choicest arms and apparel and jewels to make gifts of, and he was 
grateful to them and gave them his blessing, as he himself says in this stanza: 


> 1. May our sincerest wish be given them,
>   
> To the powerful race of Tal,
>   
> Fair sovereignty enduring for ever,
>   
> Heroism, honour, comeliness, cleric virtues.
> 




We read in the **seanchus** that there were forty kings on the throne of Munster from 
the time of Aonghus, son of Natfraoch, to Mathghamhain, son of Cinneide, and that during that time the Dal 
gCais possessed only Thomond (except Lorcan, who reigned a year and a half after Cormac son of Cuileannan, 
according to O Dubhagain, and died at the end of that time), namely, from Slighe Dhala which is called 
Bealach Mor Osruighe to Leim Chon gCulainn in the west of Corca Baiscinn; and it was the same Dal gCais who 
used to serve in the wars for the king of Cashel against Leinster and Leath Cuinn. Hence some poet says in 
this stanza: 


> 1. It is the right of the host of the race of Lughaidh
>   
> To lead in battle the Munster hosts,
>   
> And to be in the rear afterwards,
>   
> Coming from proud unknown lands.
> 




Now when Cormac son of Cuileannan, had been ten years on the throne of Munster in peace and prosperity, 
as we have said, he was egged on by some of the nobles of Munster, and in particular by Flaithbheartach, son 
of Ionmhainen, abbot of Inis Cathach, who was of the royal blood, to exact head tribute from the province of 
Leinster since it belonged to Leath Mogha. Accordingly he assembled and brought together the Munster forces, 
and when their nobles had come together they resolved to go and demand head tribute from the Leinstermen by 
right of the 


---

p.199




partition which was made between Mogh Nuadhat and Conn. But Cormac was reluctant to go on this expedition as 
he had a foreboding that he was to fall in the adventure. Still he consented to go, and just before he set 
out he left legacies for the sake of his soul to the principal churches of Ireland, to wit, an ounce of 
silver and an ounce of gold and his trappings and his steed to Drom Abhrad, that is Ard Fionain. A chalice 
of gold and silver and a satin chasuble to Lis Mor; a chalice of gold and silver and four ounces of gold and 
a hundred ounces of silver to Cashel; three ounces of gold and a missal to Imleach Iobhair; an ounce of gold 
and an ounce of silver to Gleann da Loch; trappings and a steed, an ounce of gold, and a satin cope to Cill 
Dara; twenty-four ounces of silver and of gold to Ard Macha; three ounces of gold to Inis Cathaigh; three 
ounces of gold and a satin chasuble to Mungairid and the blessing of Cormac.


High, indeed, was the testimony Cormac bore to the community of Mungairid, as we read in the poem which 
begins: O servant bind our provisions, in which he gives the number of the monks who were in 
the community serving the six temples that were in the church. The cathair of Neasan, 
the Deacon, that church is called. Here is the number of the monks that were in it, to wit, five hundred 
learned monks for preaching, six hundred psalm-singers to attend choir, and four hundred aged men for 
contemplation.


As to Cormac when he was about to set out for Leinster he sent for Lorcan, son of Lochtna, king of Dal 
gCas, and when he reached the palace at Cashel, Cormac bade him welcome, and he made it known to the nobles 
of the race of Eoghan who were with him that it was Lorcan who had the true title to the kingdom of Munster 
after him according to the will of Oilill Olom, by which it was ordained that the sovereignty of Munster 
should each alternate generation 


---

p.201




be held by the race of Fiachaidh Muilleathan and the race of Cormac Cas. But the wish of Cormac was not 
given effect to in this matter.


Now as to Cormac when he and Flaithbheartach, son of Ionmhainen, had got together a large army of 
Munstermen, they proceeded to Leinster to demand hostages or rent for the king of Munster, as the people of 
Leinster belonged to Leath Mogha. While the Munster host were in one camp before setting out on that 
expedition, Flaithbheartach, son of Ionmhainen, abbot of Inis Cathaigh, went on his horse through the 
laneway of the camp, and his horse fell under him into a deep trench and that was an ill-omen for him. This 
caused a large number of his followers and of the entire host to abandon this march, as they regarded the 
holy man's fall as a bad omen before their setting out on an expedition.


Now noble envoys from the Leinstermen and from Cearbhall, son of Muireigen, came to interview Cormac 
first, and brought him an offer of peace from the Leinstermen, to wit, that there should be general peace in 
Ireland until the coming Bealltaine, for a fortnight of autumn was just then over, and hostages were to be 
given into the hands of Maonach, abbot of Disirt Diarmada, who was a holy, wise, pious man, and the 
Leinstermen were to give Cormac and Flaithbheartach a large amount of valuables and wealth in consideration 
of that peace. Cormac was well pleased to make this peace, and went and made known to Flaithbheartach that 
there had come to him envoys from the king of Leinster asking for peace until the coming Bealltaine, and 
offering both of them valuables and wealth from the Leinstermen if they returned to Munster in peace. When 
Flaithbheartach heard this he became greatly enraged and said: ‘From thy feeble courage it is very easy to 
judge how miserable thy mind and spirit,’ and he 


---

p.203




poured out much abuse and insult on Cormac on that occasion.


Cormac answered him thus: ‘I know well,’ said he, ‘what will come of this, to wit, battle will be 
given to the Leinstermen and I shall be slain, and it is likely that thy death will also come of it.’ And 
when Cormac had said these words he went into his own tent troubled and sad, and when he sat down a vessel 
of apples was brought to him and he began to distribute them among his people, saying: ‘My beloved 
people,’ said he, ‘I shall not distribute apples among you from this time forth for ever.’ ‘O 
beloved lord,’ said his people, ‘thou hast made us sad and sorrowful, and thou has often forboded ill 
for thyself.’ ‘How is this, O people of my heart,’ said Cormac, ‘for it is no great wonder that 
even though I should not give you apples with my own hand there will be some one else with me to give them 
to you.’ After this Cormac ordered that a guard be set round him, and that the pious man Maonach, namely 
the **comhorba** of Comhghall, be brought to him so that he might make his confession and 
his will in his presence; and he partook of the Body of Christ in his presence, and he renounced the world 
before Maonach, for Cormac felt sure that he himself would be slain in that battle, still he did not like 
his people to know this.


Now he ordered that his body be taken to Cluain Uama, if it could be taken there with general 
convenience, and if not that it be taken to the churchyard of Diarmaid, son of Aodh Roin, that is Disirt 
Diarmada where he was a student for a long time. However, he preferred to be buried at Cluain Uama with the 
son of Leinin. But Maonach preferred he should be buried at Disirt Diarmada where there was a community of 
the monks of Comhghall, and Maonach was then Comhghall's **comhorba**, and he was a pious 
wise man, and he endured great hardship and labour in his endeavour to arrange peace between 


---

p.205




the Leinstermen and the king of Munster on that occasion.


Now many Munstermen deserted the expedition without leave when they heard that Flann, son of 
Maoilseachlainn, king of Ireland, was in the camp of the Leinstermen with a numerous host of infantry and 
cavalry. Thereupon Maonach said: ‘Good people of Munster you should be acting wisely in giving the good 
hostages offered you into the hands of virtuous people until Bealltaine, to wit, the son of Cearbhall, king 
of Leinster, and the son of the king of Osruighe.’ All the Munstermen replied with one voice that it was 
Flaithbheartach, son of Ionmhainen, who forced them to go to Leinster.


After this contention the Munstermen proceeded eastward over Sliabh Mairge to Droichead Leithghlinne. Now Tiobraide the **comhorba** of Ailbhe and a large party of clerics rested at Leithghlinn 
as well as the camp-followers and the baggage horses. After this the Munstermen sounded their trumpets and 
gave the alarm of battle and proceeded to Magh nAilbhe. They rested there in the bosom of a wood and 
fastness awaiting the enemy. The Munstermen divided themselves into three equal battalions with 
Flaithbheartach, son of Ionmhainen, and Ceallach, son of Cearbhall, king of Osruighe, in command of the 
first battalion, Cormac, son of Cuileannan, king of Munster, in command of the second battalion, and Cormac, 
son of Mothla, king of the Deise, and a party of Munster nobles in command of the third battalion. Now in 
this array they reached Magh nAilbhe, and they were complaining of the multitude of the enemy and of the 
smallness of their own host. For authors write that the Leinstermen had a host four times as numerous as the 
Munstermen. Pitiful indeed was the cry from this battle as the learned relate, that is, the cry of the 
Munstermen who were being slain, and the cry of the Leinstermen who were exulting over that slaughter.




---

p.207


Now the sudden defeat of the Munstermen was owing to two causes, namely, Ceileachair, kinsman of Ceann 
Gheagain, one time king of Munster, mounted his horse, and when he had mounted he said: ‘O freemen of 
Munster,’ said he, ‘fly this awful battle and leave the clerics themselves to fight, as they accepted 
no other offer but to give battle to the Leinstermen.’ With that Ceileachair and a multitude with him 
quitted the battlefield. Another cause of the defeat of the Munstermen was that when Ceallach, son of 
Cearbhall, saw his people being smitten stoutly in the battle he suddenly mounted his horse and said to his 
followers: ‘Mount your horses,’ said he, ‘and dismiss those that are opposed to you,’ and though 
he said this it was not to fighting he referred, but to flight. It followed from these two causes that there 
was general rout of the men of Munster. Alas, great was the slaughter throughout Magh nAilbhe on that 
occasion. For clerics were no more spared than laics, but were slain equally with them 
on either side; and when they spared a cleric or a laic, it was not through mercy but 
through avarice they did so, in the hope of getting ransom-money on their account.


Cormac son of Cuileannan went to the forefront of the leading battalion. But his horse jumped into a 
drain under him and he got unhorsed, and a party of his followers who were fleeing from the battle saw him 
and came to his aid and placed him on his horse. Then did Cormac notice a freeborn foster-son of his own, 
whose name was Aodh, a man learned in wisdom, in law, in history and in Latin, and king Cormac spoke to him 
thus: ‘Beloved son,’ said he, ‘do not stay with me, but escape as best thou canst; and I told thee 
that I should be slain in this battle.’ Cormac advanced, and much blood of men and steeds lay along his 
path, and the hind legs of the horse under him slipped through the slipperiness of 


---

p.209




the way which was marked with blood. Thereupon the horse fell backwards and Cormac fell under it and his 
neck and back were together broken in that fall; and as he fell he said: ‘Into Thy hands, O Lord,’ etc. 
He died on the spot, and the unruly folk came and assailed him with javelins and his head was cut off.


**Dr. Hanmer** says in his chronicle that it was by the Lochlonnaigh that Cormac son of Cuileannan, and Cearbhall son of Muireigen, king of Leinster, fell in the year of the Lord 905. But this statement of **Hanmer**'s is false, for Cearbhall did not fall on this occasion, and it was not the Lochlonnaigh who fought 
the battle but Flann Sionna, king of Ireland, as is evident from the historic tract called the Battle of Bealach Mughna, in which battle the son of Cuilleanna fell.


Now in the very beginning of this battle Ceallach, son of Cearbhall, king of Osruighe, and his son were 
slain. Many were the good clerics, the kings, the chiefs and the warriors that were slain in this battle. 
There were slain there Foghartach son of Suibhne, king of Ciarraidhe, and Oilill son of Eoghan, a young 
prudent noble, and Colman, abbot of Ceann Eiteach, chief judicial **ollamh** of Ireland, 
and a large crowd with them. The following are the nobles who fell there, namely, Cormac, king of the Deise, 
Dubhgan, king of Fear Maighe, Ceannfaolaidh, king of Ui Conaill, Conn of Adhar, Aineislis of Ui 
Toirrdhealbhaigh, Eidhion king of Eidhne, who had been banished to Munster, Maolmuaidh, Madagan, Dubh dha 
Bhuireann, Conall, Fearadhach, Aodh king of Ui Liathain, and Domhnall king of Dun Cearmna. And those who won 
the victory over the Munstermen are Flann, son of Maoilseachlainn, king of Ireland, and Cearbhall, son of 
Muireigen, king of Leinster, and Tadhg, son of Faolan, king of Ui Cinnselaigh, and Teimheanain, king of Ui 
Deaghaidh, Ceallach and Lorcan two kings of the Cineals, and Inneirghe, son of


---

p.211




Duibhghiolla, king of Ui Drona, Follamhain son of Oilill, king of Fothorta Feadha, Tuathal son of Ughaire, 
king of Ui Muireadhaigh, Odhran son of Cinneide, king of Laoighis, Maolcallann son of Fearghal, king of the 
Forthuath, and Cleircen, king of Ui Bairrche.


XXI.
----


After this Flann Sionna, king of Ireland, came with a large royal host of cavalry to place Diarmaid, son 
of Cearbhall, on the throne of Osruighe in the room of his brother Ceallach, son of Cearbhall, who reigned 
in Osruighe before him and who fell in this battle as he was helping Cormac, to whom as king of Leath Mogha 
he was subject as to the payment to him of tribute. It was then that a party came to Flann Sionna, king of 
Ireland, bringing with them the head of Cormac, son of Cuileannan, and they said to Flann: ‘Life and 
health be thine, O slaughtering powerful king; behold we have the head of Cormac, king of Munster, for thee, 
and according to the custom of the other kings lift thy thigh and put the head under it and press it beneath 
thy thigh. For it was the custom of the kings that preceded thee, when they had slain a king in battle to 
cut off his head and to press it beneath their thighs.’ But instead of thanking this party he reproached 
them severely for this deed, and said that it was a pity to behead the holy bishop and added that he would 
not press it; and Flann took the head in his hand and kissed it, and thrice turned round in full circle with 
the blessed head of the holy bishop.


And then the head was reverently carried from him to the body, at which was Maonach, son of Siadhal, 
**comhorba** of Comhghall, and he took the body of Cormac to Disirt Diarmada, and it was 
there buried with honour.


What heart but must rue this deed, the slaying and 


---

p.213




hewing of the holy man, the wisest of the men of Ireland in his time, a man learned in Irish and in Latin, 
and a most virtuous chaste, pure, prayerful, pious archbishop, leader in teaching in true wisdom and good 
morals and high king of the two provinces of Munster!


And Flann Sionna, king of Ireland, returned, having left Diarmaid son of Cearbhall on the throne of 
Osruighe, and having made peace between himself and his kinsmen. The Leinstermen similarly returned in the 
flush of victory. After this Cearbhall son of Muireigen, king of Leinster, proceeded on his way to Cill Dara 
bringing with him in charge a large body of Munstermen and with them Flaithbheartach, son of Ionmhainen. 
Then Flaithbheartach was brought into Cill Dara, and the Leinster clergy fell to reproaching him greatly, 
for they knew well that it was through his fault the battle was fought.


But on the death of Cearbhall, king of Leinster, Flaithbheartach was set free; and a year after Muireann 
**banchomhorba** of Brighid accompanied him out of the town and sent a large party of 
Leinster clergy to escort him till he reached Magh nAirbh, and when he had thus arrived in Munster he went 
into his own monastery to Inis Cathaigh, and there he passed some time in virtue and devotion, and came out 
of Inis Cathaigh again to assume the sovereignty of Munster after the death of Dubh Lachtna, son of 
Maolguala, who was king of Munster seven years after Cormac; and he was for some years after that king of 
Munster, as is stated in the old book of the Annals of Cluain Eidhneach Fionntain in Laoighis which gives an 
account of the Battle of Bealach Mughna, as we read in the historic
poem which Dallan, the **ollamh** of Cearbhall, king of Munster, composed in which he gives an abridged summary of 
this battle, and in which he enumerates the nobles and gives the numbers of the hosts that fell therein. But 
I shall


---

p.215




set down here only the first stanza of the poem, since I have mentioned the nobles by name above. Here is 
the stanza: 


> 1. Cormac, of Feimhean, Foghartach,
>   
> Colman, Ceallach of hard combats,
>   
> With six thousand, fell
>   
> In the Battle of proud Bealach Mughna.
> 



After this Flann Sionna, king of Ireland, died.


Niall Glundubh, son of Aodh Finnleith, son of Niall Caille, son of Aodh Oirndighe, son of Niall Frasach, 
son of Fearghal, son of Maolduin, son of Maoilfrithrigh, son of Aodh Uairiodhnach of the race of Eireamhon, 
held the sovereignty of Ireland three years. He renewed the fair of Taillte. It was this Niall who went with 
a force of Gaels to give battle to the Lochlonnaigh of Loch da Chaoch in Ulster, and many Lochlonnaigh and 
Gaels were slain in that battle. It was also in the reign of Niall that the Battle of Ceann Fuaid was won 
over the Leinstermen by Iomhar, a Lochlonnach chief, wherein fell six hundred Leinstermen under Maolmordha, 
son of Muireigen, king of Iarthar Lithfe, under Ughaire son of Oilill, under Mughron son of Cinneide, king 
of the Three Comanns and of Laoighis, and under many other nobles not mentioned here.


It was about this time that Oitir, a Lochlonnach chief, with a numerous host went from Loch da Chaoch to 
Alba, and Caus, son of Aodh, gave them battle, wherein Oitir and many Lochlonnaigh fell. *It* was in the reign of Niall Glundubh that a great fleet of Lochlonnaigh came to Ireland 
together with Sitric and the children of Iomhar, and they seized on the town of Ath Cliath in spite of the 
men of Ireland.


Niall Glundubh, king of Ireland, assembled the main host of Leath Cuinn and gave battle to the 
Lochlonnaigh at Ath Cliath, wherein he himself was slain together with 


---

p.217




Conchubhar, son of Maoilseachlainn, royal heir to the sovereignty of Ireland, and Aodh, son of Eochagan, 
king of Ulster, and Maoilmithidh, son of Flannagan, king of Breagha, Maolcraoibhe O Duibhshionnaigh, king of 
Oirghiall, and many other leaders and men as well.


Donnchadh, son of Flann Sionna, son of Maoilseachlainn, son of Maolruanuidh, son of Donnchadh, son of 
Domhnall, son of Murchadh, son of Diarmaid, son of Airmeadhach Caoch, son of Conall Guithbhinn, son of 
Suibhne Meann of the race of Eireamhon, held the sovereignty of Ireland twenty years. Gormfhlaith, daughter 
of Flann, son of Conaing, was the mother of this Donnchadh, and his wife was Sadhbh, daughter of Donnchadh, 
son of Ceallach, king of Osruighe. And according to the book of Ard Macha this Donnchadh, son of Flann, king 
of Ireland, went with a large party to build a wall or fence round Saighir Chiarain by the direction of his 
wife, namely, Sadhbh, daughter of Donnchadh, son of Ceallach; for she felt envious at there being a wall or 
fence round every principal church in Ireland, while her own church, that is Saighir, was without a wall; 
for the burying place of the kings of Osruighe was at Saighir Chiarain at that time. Accordingly the men of 
Meath came to Donnchadh's mound beside Saighir to the west, and they set themselves to build the fence round 
the church day by day; and at this time the body of Donnchadh, son of Ceallach, king of Osruighe, was 
brought to Saighir to be buried; and after it was buried, when the darkness of night had set in, nine hairy 
jet-black crosans came upon the grave and set to choir-chanting as crosans are wont to do ever since, and their eyes and their teeth were whiter than snow, and 
all their other limbs blacker than blacksmith's coal.


They had come, it seems, bringing with them a lay for the king of Osruighe. And all who saw them grew 
sick a day and a night at the sight. Here is the lay:


---

p.219



> 1. The people of Donnchadha Mor son of Ceallach,
>   
> A proud quarterage,
>   
> Melodious bands who are calling out
>   
> Are we when on a hosting:
> 2. Hosts hunting, full plains,
>   
> Houses for drinking,
>   
> Fair young women, hospitable princes,
>   
> Great nobles;
> 3. The shout of his companies and his troops,
>   
> The quarterage of a good host;
>   
> Ranks of skirmishers in the summer sun,
>   
> Drinking cups, feast-shouts;
> 4. Harps and pipes in harmony.
>   
> Filés of Faibhle
>   
> With a fair new poem they used to come
>   
> To the gracious king of Raighne;
> 5. Dod dor dod dan, O son of the king of Raighne,
>   
> With prosperity,
>   
> Where are the goblets where the friendship
>   
> That thy father had?
> 6. May a pang seized us for the man
>   
> Whom all *amused*,
>   
> Excellent the course on which he was
>   
> In the fair world;
> 7. Baptais baptain on his soul
>   
> Since it is heard,
>   
> Great his reward after going to the other world,
>   
> We are his people.
> 




Now this band used to keep chanting this lay from nightfall till morning every night over the grave of 
Donnchadh, so that a doubt arose in the minds of clergy and laity, for they were surprised that demons 
should be openly attending the body of that most virtuous king. Indeed among the pious practices of the king 
were frequent confession and the receiving of the Body of Christ and fervent prayers; and among his 
exercises of holy zeal was to send food and provisions to be given to God's poor in each principal church in 
Osruighe on each of the apostles' feasts. Moreover, he used to place an orphan or a poor man to be 
maintained for God's sake in every


---

p.221




household throughout Osruighe, and had besides three purses or three leather bags, to wit, a bag in which 
each person of the household put a tithe of the food he ate, and a bag in which each put his Michael's 
portion, and a third bag in which a portion of beeswax was put, which was at the disposal of the housewife 
to dispense to the poor who had got no share of the tithes or of the Michael's portion.


As to the clerics, they fasted and prayed for three days that it might be made known to them why the 
demons attended the king's body; and an angel of God appeared in a vision to a servant of God of the race of 
Fiachaidh son of Niall, who was in that assembly. ‘Ye have done well in keeping that fast,’ said the 
angel, ‘now these are nine of the company of Ui Coingheoidh, and this is the third time they have come to 
Ireland from hell; and since they could not find an occasion against this king during his life, they are 
causing a disturbance over his body after his death; and do ye have Mass said and water blessed 
to-morrow,’ continued the angel, ‘and let it be sprinkled on the grave and throughout all the 
churchyard, and all the demons will go away.’


This was done and the company of Ui Coingheoidh appeared in the air above, in the form of jet black 
birds, and they did not venture to light on the churchyard ground because of its having been blessed; and 
they said that the fasting and the bleesing of the grave by the clergy were necessary, ‘for we would be 
after his body on earth since we have not power over his soul in heaven’. And thereupon they went out of 
sight of all and they did not see them ever since. It was about this time that the crosan Fionn O Cionga and Mac Rionntach O Connorain lived, and it was they who learned by 
rote the above mentioned lay from the company of Ui Coinghaoidh while they were chanting it above the grave 
of Donnchadh, son of Ceallach, king of Osruighe, and the two referred to practised **crosantacht** as an art until death.




---

p.223


XXII.
-----


It was in the reign of Donnchadh son of Flann Sionna, king of Ireland, that the following events took 
place. For it was in the beginning of his reign that Ceallachan, son of Buadhachan, who is called Ceallachan 
of Cashel held the sovereignty of the two provinces of Munster ten years. Now Cinneide, son of Lorcan, came 
to Gleannamhain to an assembly of the nobles of Munster before Ceallachan was inaugurated, and Cinneide 
sought to come between Ceallachan and the sovereignty of Munster. But Ceallan's mother came from Cashel, for 
it was there she dwelt with her tutor, Patrick's **comhorba**, and coming into the 
assembly she asked Cinneide to remember the agreement come to between Fiachaidh Muilleathan and Cormac Cas 
that the descendants of both should alternately inherit Munster, and this is expressed by this stanza on the 
woman's words: 


> 1. Remember, O pleasant Cinneide,
>   
> The agreement of Fiachaidh and Cormac Cas!
>   
> How they left Munster to be shared
>   
> Justly among their fair offspring.
> 



And as a result of the woman's discourse Cinneide left the sovereignty of Munster to Ceallachan.


After this the Lochlonnaigh seized on Ceallachan by treachery, and the siol Eoghain and the Dal gCas 
rescued him in spite of them. But when Ceallachan and the Munster nobles had defeated the Lochlonnaigh in 
many battles and had driven them out of Munster, Sitric, son of Turgesius, who was their leader, hit upon 
the plan of arranging a match with Ceallachan, to wit, to give him his own sister Beibhionn, daughter of 
Turgesius, to wife, and to allow him to possess free the two provinces of Munster, without retribution or 
claim respecting them on 


---

p.225




the part of the Lochlonnaigh; in order that when Ceallachan should go under his own protection to marry his 
sister, himself and all the Munster nobles who were with him might be slain; and he communicated the secret 
of this plot to Donnchadh, son of Flann, king of Tara, who was at enmity with Ceallachan through his not 
having paid him the rent for Munster, and hence he consented to Sitric's carrying out his treacherous design 
on Ceallachan and the Munster nobles. Thereupon Sitric sent envoys to Ceallachan to give tidings of the 
match, and when they came into his presence, what he proposed to do was to take a large host with him when 
going to marry the lady. ‘That is not right,’ said Cinneide, son of Lorcan, ‘for it is not right to 
leave Munster without defence; and what thou shouldst do is leave a force to hold Munster and to take four 
score lords' sons with thee on going to marry the lady.’


And this was the counsel they adopted. And as Ceallachan was going on this journey; the night before he 
arrived in Ath Cliath, Mor, daughter of Aodh, son of Eochaidh, daughter of the king of Inis Fionnghall, wife 
of Sitric, asked why he was making a match with Ceallachan, seeing he had slain so many Lochlonnach nobles. 
‘It is not for his good this match is arranged by me,’ he answered, ‘but with a view to practising 
treachery against him.’


At these words the lady started, as she had been long secretly in love with Ceallachan from the time she 
saw him at Port Lairge; and she rose early the next morning and went secretly along the path on which she 
thought Ceallachan was coming; and when he came up to her she took him aside and informed him of the plot 
which Sitric was hatching against him in order to kill him; and when Ceallachan thought of returning he was 
unable to do so, as the fields on either side of the road were full of companies of Lochlonniagh ambushed 
for the purpose of capturing him. As he made an effort to return they sprang


---

p.227




upon him from all sides, and a body of nobles who were with him were slain, and these in their turn slew a 
number of the Lochlonnaigh. But the bulk of the host bore down on Ceallachan, and there captured himself and 
Donn Cuan, son of Cinneide, and they were taken to Ath Cliath as prisoners, and thence to Ard Macha, where 
nine Lochlonnach earls with their detachments detained them.


As to the company of Munster nobles who escaped from this conflict, they proceeded to Munster and told 
the news to Cinneide, who thereupon got ready two hosts to go in quest of Ceallachan, that is, a land force 
and a sea force, and he made Donnchadh, son of Caomh, king of the two Fearmaighes, leader of the land force, 
and Cinneide proceeded to encourage him, telling him that eleven of his ancestors were kings of Munster, to 
wit, Airtre, Cathal son of Fionghaine, Fionghaine son of Cathal, Cu gan Mhathair, Cathal who was called 
Ceann Geagain, Aodh, Flann Cathrach, Cairbre, Criomhthann, Eochaidh, and Aonghus son of Natfraoch. Besides, 
Cinneide sent ten hundred of the Dal gCais along with him with three leaders over them, to wit, Coscrach, 
Longargan and Conghalach, as says the poem: Let twenty hundred go northwards.


Here is the stanza of this poem which quotes the words of Cinneide:


> 1. Let Coscrach, of the battles, go there,
>   
> And Longargan, the lovable,
>   
> Let Conghalach, from the lake, go;
>   
> I mean my three brothers.
> 




Moreover, Cinneide sent thither five hundred more of the Dal gCais with Sioda, son of Sioda of the clann 
Cuilein, and five hundred more of the Dal gCais with Deaghaidh, son of Domhnall, besides the fighting men 
that went thither from the other free-born tribes of Munster. The second great force he sent by sea with 
Failbhe Fionn, king of Desmond, as their leader.


As to the land-force they proceeded from Munster to 


---

p.229




Connaught; and they sent skirmishers to Muaidh and to Iorrus and to Umhall to bring cattle preys to the 
Munster camp, and the camp were not long waiting for the return of the skirmishers when they saw a host in 
good array approach them, and their *number* was ten hundred, and a 
single youthful warrior at their head; and when they came up, Donnchadh, son of Caomh, asked what force was 
that. ‘A body of Munstermen,’ he replied, ‘to wit, the Gaileanga and the Luighne of the race of Tadhg 
son of Cian, son of Oilill Olom, and the men of Dealbhna, of the race of Dealbhaoth, son of Cas, son of 
Conall Eachluaith, who are giving you a helping hand through brotherly sympathy in opposing the foreigners 
and in rescuing Ceallachan from them. And there are three valiant leaders at the head of this force, to wit, 
Aodh, son of Dualghus, having all the Gaileanga under him, Diarmaid, son of Fionnachta, having the Luighnigh 
under him, and Donnchadh, son of Maoldomhnaigh, at the head of the men of Dealbhna’; and as a testimony of 
this is the historical poem which begins with this stanza:


> 1. The clanna Cein are there,
>   
> And the Dealbhaoith all together
>   
> Coming to the hosting,
>   
> And they will fight on your side.
> 




Now this host was thus constituted. Five hundred of them had swords and shields, and five hundred were 
archers. The Munster host and this force who had come to help them proceeded thence to Tir Chonaill and they 
spoiled the country. Muircheartach, son of Arnaladh, came to Donnchadh son of Caomh, and asked him to 
restore the cattle preys with good will; and Donnchadh replied that he would only give him what remained of 
the preys after the hosts had been satisfied. Upon this Muircheartach left the host and sent envoys secretly 
to the sons of Turgesius to Ard Macha informing them that the


---

p.231




Munster host were in quest of Ceallachan and intended to rescue him.


As to the sons of Turgesius, they set out from Ard Macha, nine earls with their host of Lochlonnaigh, and 
Ceallachan and Donn Cuan with them as prisoners. And the Munster host proceeded to Ard Macha and slew all 
that came in their way of the Lochlonnaigh, and when on the next day they heard that Sitric and his host had 
gone to Dun Dealgan with Ceallachan they set out in pursuit of them, and when Sitric observed them coming 
near the town he himself and his host betook themselves to their ships, having Ceallachan and Donn Cuan with 
them, and the Munster host came on the verge of the strand in front of them and held a parley with the 
Lochlonnaigh. And thereupon they saw a large fleet approach them in the harbour, and the Munstermen knew 
that it was Failbhe Fionn and his fleet that were there.


Failbhe and his fleet proceeded by direct route to meet the Lochlonnaigh, and he made an attack on the 
ships in which were Sitric and Tor and Maghnus, and he boarded Sitric's ship, having a sword in either hand, 
and set to cutting the ropes that bound Ceallachan to the mast, with the sword that was in his left hand, 
and set Ceallachan free, and let him down on the ship's deck, and then gave Ceallachan the sword he held in 
his left hand. Ceallachan went from Sitric's ship to that of Failbhe; and Failbhe continued to hew down the 
Lochlonnaigh until they overpowering him, slew him and cut off his head. Fianghal, a leader of his 
followers, took his place in the conflict, and seizing Sitric by the breast by force, cast both of them 
overboard, and they went to the bottom and thus were drowned.


Seaghdha and Conall, two other leaders, came on and seized Sitric's two brothers, to wit, Tor and 
Maghnus, and threw them overboard, so that the four were 


---

p.233




drowned in that manner. And in like manner acted every other company of the Gaels; they sprang on the 
Lochlonnaigh and broke them up, made gaps through them, slew them, and threw them into disorder, so that 
there escaped from them only a few who were saved by the swiftness of their ships, and they went on land 
with Ceallachan who had thus been rescued from Lochlonnach captivity by the valour and prowess of the 
Munstermen; and thence they proceeded to Munster with Ceallachan, and he resumed the government of his own 
country.


And as they were setting out from Ath Cliath for Munster, Murchadh son of Flann, king of Leinster, sought 
to give them battle for having slain so many Lochlonnaigh in rescuing Ceallachan from them. But when they 
saw how brave and valiant the Munstermen were, they allowed them to pass without giving them 
battle.


XXIII.
------


But when Ceallachan returned to Munster he considered how severely the Lochlonnaigh oppressed Munster, 
and he himself and the nobles of Munster resolved to attack them with a view to banishing them; and they 
first made a sudden attack on Luimneach, and Ceallachan and his host slew five hundred of them and took away 
hostages from them. After this he plundered Corcach and brought hostages and treasures therefrom. He also 
plundered Cashel, and three hundred Lochlonnaigh were slain there. Thence he went to Port Lairge and took 
possession of the town and plundered it, and he inflicted a severe defeat on Sitric, son of Iomhar, and slew 
five hundred of his people; and Sitric himself took flight in his fleet; and Ceallachan returned to Domhnall 
O Faolain, king of the Deise, and gave him his own sister Gormfhlaith, daughter of Baudhachan, to wife. Soon 
after that Ceallachan died, 


---

p.235




and after his death Feargraidh, son of Ailghionan, son of Donnghal, held the sovereignty of Munster till his 
own tribe slew him by treachery. After this Mathghamhain, son of Cinneide, held the sovereignty of Munster 
twelve years, and in his time Echthighearn, son of Cinneide, was chief of Thomond.


It was Mathghamhain, son of Cinneide, king of Munster, and his brother Brian, son of Cinneide, who was 
then a stripling, who won the Battle of Sulchoid over the Lochlonnaigh wherein Teitill Treinmhileadh Ruamonn 
and Bearnard Muiris of Luimneach and Torolbh and twelve hundred Lochlonnaigh were slain, and Mathghamhain 
and Brian and the Dal gCais pursued them as they retreated in through the streets of Luimneach, and many of 
them were slain in the streets and in the houses, and they gave up much gold and silver, valuables and 
goods; and also their duns and fortresses were burned and thrown down. Soon after this Donnabhan seized on 
Mathghamhain by treachery in his own house and gave him over to the son of Bran and to the foreigners in 
violation of the protection of Colam, son of Ciaragan, the **comhorba** of Bairre; and 
the son of Bran, slew Mathghamhain in violation of the saint's protection.


It was in the time of Donnchadh, son of Flonn Sionna, king of Ireland, of whom we are treating, that the 
following events took place, to wit, the death of Ciaran, bishop of Tuilen, and the going of this Donnchadh 
to plunder and spoil Connaught. However, many of his followers were slain in Duibhthir Atha Luain, where 
Cionaoth, son of Conchubhar, king of Ui Failghe fell. It was about this time that Cluain mic Nois was 
plundered by the Lochlonnaigh, and they went thence on Lough Ribh and plundered the country on either side 
of it. The Lochlonnaigh also plundered and spoiled Eininse, and two hundred Gaels were slain there. After 
this twelve hundred Lochlonnaigh


---

p.237




were drowned in Lough Rudhruighe, and the Lochlonnaigh of Ath Cliath seized on Faolan, son of Muireadhach, 
king of Leinster, and his children; and Dun Sobhairce was plundered by the Lochlonnaigh of *Loch Cuan and Cill Dara was plundered by the Lochlonnaigh of* Port Lairge. Soon 
after this the Ultonians made great slaughter on the Lochlonnaigh in which eight hundred of them, together 
with three of their leaders, to wit, Albdan, Aufer and Roilt, fell by Muircheartach, son of Niall.


About this time there was a large trading business carried on with Ireland when the Lochlonnach earl 
Oilfinn came with the Lochlonnach forces of Luimneach and Connaught to the fair of Ros Cre on the feast of 
Peter and Paul; and the people at the fair stood up against them, and three or four thousand Lochlonnaigh 
were slain there, and the earl himself was slain with them, according to Finghin Mac Carrthaigh in the 
booklet which he has written giving a brief account of Irish affairs from the beginning to this time. At 
this period Tadhg, son of Cathal, was king of Connaught twenty years; and Sitric, son of Iomhar, king of the 
Fionnlochlonnaigh and the Dubhlochlonnaigh, died. About this time the Connaughtmen wrought great slaughter 
on the Lochlonnaigh of Loch Oirbsean; and Conaing, son of Niall, wrought dreadful slaughter on the 
Lochlonnaigh of Loch nEeachach wherein two hundred of them fell. After this a party of Lochlonnaigh came on 
Loch Eirne and they plundered churches and districts; and Gothfraidh, chief of Loch Cuan, plundered Ard 
Macha; Cill Chuilinn was plundered by Amhlaoibh, son of Gothfraidh, and he took thence ten hundred 
prisoners. Oileach Neid was plundered by the Lochlonnaigh, and Muircheartach, son of Niall, was captured 
there, but God set him free by a miracle. Soon after this Aralt, son of Iomhar, chief of the Lochlonnaigh of 
Luimneach, was slain by the Connaughtmen; and Amhlaoibh, son of Gothfraidh, king of 


---

p.239




the Fionnlochlonnaigh and of the Dubhlochlonnaigh, died, and Lorcan, son of Faolan, king of Leinster, was 
slain by the men of Normandy. It was at this time that the son of the prince of Wales, whose name was 
Rodoricus, came to plunder Ireland; and he was slain by the Irish according to **Hanmer** in the year of the 
Lord 966. It was about this time that Ath Cliath was plundered by Conghal, son of Maoilmithidh, and one 
hundred and forty Lochlonnaigh were there slain, and their valuables and their goods were taken from them. 
After this Donnchadh, son of Flann Sionna, king of Ireland, died.


Conghalach, son of Maoilmithidh, son of Flanagan, son of Ceallach, son of Conaing, son of Conghal, son of 
Aodh Slaine, of the race of Eireamhon, held the sovereignty of Ireland ten years. Muire, daughter of 
Cionaoth, son of Ailpin, king of Alba, was the mother of this Conghalach. It was in his reign the following 
events took place. For it was then that Etimonn, king of Sacsa, and Blathchuire, son of Iomhar, king of 
Normandy, died; and Conghalach, son of Maoilmithidh, king of Ireland, fought the battle of Muine Brogain 
against the Lochlonnaigh where seven thousand of them fell, as well as many Gaels on the other side.


The fourth year of the reign of this Conghalach, son of Maoilmithidh, Brian Boroimhe, son of Cinneide, 
assumed the sovereignty of Munster; and the second year after he had become king of Munster he gave notice 
to Maolmhuaidh, son of Bran, king of Ui nEachach, that he would give him battle at Bealach Leachta to avenge 
his brother Mathghamhain who was treacherously slain by the followers of the son of Bran. The son of Bran 
assembled a great host of foreigners and of Gaels; so that he had one thousand four hundred Lochlonnaigh and 
a large battalion of Gaels. Still Brian and the Dal gCais defeated them, so that many of them, of whom we 
have no mention, were slain, and


---

p.241




those who were not slain were captured by Brian. After this Domhnall O Faolain, king of the Deise, and 
Iomhar of Port Lairge made war on Brian, and they plundered the greater part of Munster. But when Brian came 
up to them and a battle took place between them at Fan mic Connrach, he defeated the Lochlonnaigh and the 
king of Deise, and Brian and the Dal gCais pursued the defeated host to Port Lairge, and Domhnall O Faolain 
and most of the foreigners of Port Lairge were slain by Brian on that occasion. He plundered and burned the 
town.


When Brian had been eight years king of Munster the whole of Leath Mogha were forced to give him 
hostages. But after the death of Domhnall Claon, son of Domhnall, king of Leinster, both the Lochlonnaigh 
and the Gaels of Leinster refused to submit to him. Brian assembled the main host of Munster to oppose the 
foreigners and the Leinstermen, and the Battle of Gleann Mama was set on foot between them. And Brian 
defeated the Lochlonnaigh and the Leinstermen, and four thousand of them were slain in that battle. In 
short, Brian defeated the Lochlonnaigh in twenty-five battles, from the first battle he fought against them 
to the last, that is the Battle of Cluain Tarbh, in which himself was slain.


After this Conghalach, son of Maoilmithidh, king of Ireland, went to plunder and spoil Munster, and he 
slew two sons of Cinneide, son of Lorcan, to wit, Echthighearn and Donn Cuan. After that Gothfriadh, son of 
Sitric and the Lochlonnaigh of Ath Cliath plundered Ceanannus and Domhnach Padraig and Ard Padraig and Cill 
Scire and many other churches, and they seized on three thousand people in this place and took away with 
them much gold and silver and booty. It was about this time that Eithne, daughter of Fearghal, queen of 
Ireland, that is, the wife of Conghalach son of Maoilmithidh, and Maolcolum, son of Domhnall, king of Alba, 
and Gaoithinne, bishop of 


---

p.243




Dun Leathghlaise, and Tadhg, son of Cathal, king of Connaught, died. Soon after this, Conghalach son of 
Maoilmithidh, king of Ireland, was slain at Ard Macha by the Lochlonnaigh of Ath Cliath and by the 
Lagenians.


Domhnall, son of Muircheartach, son of Niall Glundubh, of the race of Eireamhon, held the sovereignty of 
Ireland ten years. It was in this king's reign that Cill Dara was plundered by Amhlaoibh, son of Sitric, and 
the Lochlonnaigh of Ath Cliath; and Domhnall son of Muircheartach, king of Ireland, went to spoil and 
plunder Connaught, and took preys of cattle and hostages from Fearghal O Ruairc, who was then king of 
Connaught.


It was also about this time that the principal church of Tuaim Greine and its tower were built by Cormac 
Ua Cillin, bishop of Tuaim Greine; and Fearghal O Ruairc, king of Connaught, was slain by Domhnall, son of 
Conghalach, son of Maoilmithidh; and Brian, son of Cinneide, king of Munster, plundered and burned Luimneach 
against the Lochlonnaigh. After this, Domhnall O Neill with a numerous host went into Leinster and plundered 
the country from the Bearbha eastwards to the sea, and encamped there for two months in spite of the 
Lochlonnaigh and the Leinstermen; and Maoilfinnein, son of Uchtan, bishop of Ceanannus and **comhorba** of Ulltan, died, and Ceanannus was plundered by Amhlaoibh Cuaran, and the 
Lochlonnaigh of Leinster, who took thence a large prey of cattle and much booty; and they inflicted a great 
and dreadful defeat on the Ui Neill when many fell on either side. It was about this time that the Battle of 
Cill Mona was won by Domhnall, son of Conghalach, and the Lochlonnaigh of Ath Cliath over Domhnall, son of 
Muircheartach, king of Ireland, wherein fell Ardghal, son of Madagan, who was king of Ulster seventeen 
years, and Donnagan, son of Maolmuire, king of Oirghiall, with many other nobles. Soon after this Beacan, 


---

p.245




bishop of Finne, and Cionaoth O Hartagain, primate of Ard Macha, died; and Ughaire, son of Tuathal, king of 
Leinster, was captured by the Lochlonnaigh of Ath Cliath. After this Inis Cathaigh, which was in the hands 
of the Lochlonnaigh, was plundered by Brian, son of Cinneide, king of Munster, and there fell eight hundred 
of the Lochlonnaigh; and three Lochlonnach chiefs were captured there, to wit, Iomhar, Amhlaoibh and 
Duibhgheann; hence the poet says: 


> 1. The slaughter at Inis Cathaigh
>   
> Was thy work, no wastrel's deed,
>   
> In which thou didst slay the leaders of the foreigners
>   
> Around Iomhar and around Duibhgheann.
> 




It was about this time that the Battle of Biothlann was won from the Leinstermen by the Lochlonnaigh of 
Ath Cliath, wherein Ughaire, son of Tuathal, king of Leinster, was slain. Soon after this Domhnall, son of 
Muircheartach, king of Ireland, died at Ard Macha.


XXIV.
-----


Maoilseachlainn, son of Domhnall, son of Flann Sionna, son of Maoilseachlainn, son of Maolruanuidh, of 
the race of Eireamhon, held the sovereignty of Ireland twenty-three years. Dunlaith, daughter of 
Muircheartach, son of Niall, was the mother of this Maoilseachlainn, and Gluiniarann was the king of the 
Lochlonnaigh in Ireland. It was in the reign of this Maoilseachlainn that the following events took place. 
For it was Maoilseachlainn himself who won the Battle of Tara over the sons of Amhlaoibh and the 
Lochlonnaigh of Ath Cliath, wherein Raghnall, son of Amhlaoibh, heir apparent to the sovereignty of the 
Lochlonnaigh, with five hundred Lochlonnaigh were slain. After this Maoilseachlainn, king of Ireland, and 
Eochaidh, 


---

p.247




son of Ardghal, who was thirty-five years king of Ulster, went to spoil and plunder Ath Cliath against the 
Lochlonnaigh, and they encamped there three days and three nights, and brought thence as many as were held 
as captives by the Lochlonnaigh, to wit, Domhnall Claon, king of Leinster, and the sureties of the Ui Neill 
in general, and they forced the Lochlonnaigh to acknowledge their independence, and to allow them have their 
lands from the Sionainn to the sea free of Lochlonnach tribute or impost. It was about this time that 
Amhlaoibh, son of Sitric, chief leader of the Lochlonnaigh in Ireland, was banished and exiled to I 
Columcille in Alba, the Gaels having driven him out of Ireland.


Maoilseachlainn, king of Ireland, went to plunder and spoil the Dal gCais, and he cut down the tree of 
Magh Adhar. But, O reader, see whether he escaped punishment from Brian, as will appear later on. And Gleann 
da Loch was plundered by the three sons of Cearbhall, son of Lorcan. But the three were slain in one night 
soon after through the power of Caoimhghin who had lived and blessed there. It was about this time that Mor, 
daughter of Donnchadh, son of Ceallach, queen of Ireland, and Iorard mac Coise, primate of Ard Macha, died; 
and Domhnach Padraig was plundered by the Lochlonnaigh of Ath Cliath and by Muircheartach O Conghalaigh. But 
God avenged this deed on them, for their death took place at the end of that very month. After this, 
Maoilseachlainn, king of Ireland, carried off by force a collar or ring of gold from a Lochlonnach leader 
called Tomair and a sword from another leader called Carlus.


Nevertheless, when the nobles of Leath Mogha and of the greater part of Connaught considered that it was 
Brian son of Cinneide who was undergoing the labour and hardship of expelling the Lochlonnaigh from Ireland, 
and that Maoilseachlainn, who was the king of Ireland, gave himself 


---

p.249




up to luxury and comfort and ease, a line of action that was useless for the defence of Ireland at that 
juncture, Brian and the nobles who were with him resolved for these reasons to send envoys to 
Maoilseachlainn, king of Ireland, to inform him that it was not right that anyone should hold the 
sovereignty of Ireland but one who should devote his energies to banishing the foreigners from the country, 
and that, as it was Brian who was undergoing the labour of banishing them, it was right he should get the 
sovereignty of Ireland for having relieved the country from the oppression of the foreigners. They also 
asked of the king to meet them at Magh da Chaomhog, but he did not agree to this. After this Brian, son of 
Cinneide, assembled and brought together the nobles of Leath Mogha both Lochlonnaigh and Gaels, for as many 
of the Lochlonnaigh as were in Leath Mogha were forced to submit to him at this time, and he marched with 
them to Tara of the Kings.


Thereupon he sent envoys to *Maoilseachlainn* who was king of Ireland, 
asking him to send him sureties for his being obedient and submissive to him as king of Ireland, or to meet 
him in battle. So Brian gave Maoilseachlainn his choice of these courses. Maoilseachlainn's answer to the 
envoys was that if Brian gave him a month's respite to summon to him to one place the forces of Leath Cuinn 
he would give either hostages or battle to him, and he charged the envoys not to permit Brian to waste or 
plunder Meath, but that he should remain at Tara during that month, and that he himself would give him 
either battle or hostages as soon as he had got a reply from Leath Cuinn. The envoys returned to Brian and 
told him the answer they had got from Maoilseachlainn. ‘Then,’ said Brian, ‘I grant them that 
respite.’


Now what Maoilseachlainn resolved on was to send Giolla Comhghaill O Sleibhin, his own **ollamh**, to Aodh 


---

p.251




O Neill, and Eochaidh, son of Ardghal, king of Ulster, and Cathal O Conchubhair, king of Connaught, asking 
them to come without delay to do battle with him against Brian and the Dal gCais, and pointing out that if 
all of these did not come to maintain the freedom of Tara for their own race, who possessed it such a long 
time, he himself would give sureties to Brian for his submission to him, as he was not strong enough to 
fight him. ‘And indeed,’ added Maoilseachlainn, ‘it will be no greater shame for me not to defend 
Tara than it will be for the clanna Neill and for the host of Leath Cuinn in general.’ The **ollamh** went with this message to the nobles of Leath Cuinn, and he made known to them the 
object of his journey and his mission. But Aodh O Neill's answer to him was, ‘When the Cineal Eoghain 
possessed Tara,’ said he, ‘they defended it themselves, and let him who holds it now stand out for its 
freedom;’ and he added that he would not set the Dal gCais at enmity with him by defending a sovereignty 
for another. The **ollamh** came back to Maoilseachlainn and repeated Aodh O Neill's answer 
to him. However, Maoilseachlainn went himself to Aodh and entreated him to go with him to do battle against 
the Dal gCais, and he said to him, ‘Hold Tara for thyself,’ said he, ‘and I will give thee hostages 
for the delivering up to thee of Tara, for I prefer this to Brian's having it. But if thou wilt not come 
with me I must submit to Brian, as I am not strong enough to fight him.’


Aodh O Neill assembled and brought together to one place to him the Cineal Eoghain, and told them of 
Maoilseachlainn's visit to their country and of the offers he had made himself, on condition of his going 
with him to fight Brian and the Dal gCais. The Cineal Eoghain made answer, and said there was nothing but 
deceit in Maoilseachlainn's promise to him, ‘for he is certain that himself is older and better than thou 
art, and hence that thou wouldst not


---

p.253




demand the kingdom of Ireland from him during his life. But,’ they added, ‘he would like that we and 
thou should go with him to fight the Dal gCais.’ Nevertheless Aodh asked them to take counsel amongst 
themselves on that question, and to give a favourable answer to Maoilseachlainn, ‘lest,’ he added, 
‘his visit to us may not mean the loss of a kingdom to us.’ Then the Cineal Eoghain secretly took 
counsel and deliberated amongst themselves on this question, and it was their opinion that if they went to 
fight the Dal gCais it was not likely that even a small number of them would return from that conflict. For 
this reason they declared that it would be necessary for them to obtain property for their children after 
them, ‘for we should have hope neither of property nor of wealth for ourselves,’ added they, ‘ if we 
were to go and fight the Dal gCais, the bravest and stoutest race in fields of battle, and a race, too, that 
never fled from the Lochlonnaigh; it is certain that neither would they flee from us.’ Therefore they 
came to the resolution of demanding from Maoilseachlainn one half of Midhe and of the demesne of Tara for 
themselves and for their children after them in consideration of their going with him on that expedition, 
and they made known to Maoilseachlainn that this was what they had resolved on. When Maoilseachlainn heard 
this he became furious and returned home from them with indignation, and summoned to him the clann Colmain 
and made known to them the answer he had got from Aodh O Neill and the Cineal Eoghain.


Upon this the resolution they came to was that Maoilseachlainn should go straight to Brian's house, where 
his camp had been fixed for a month previously at Tara, the men of Meath supporting him there. 
Maoilseachlainn then proceeded to Tara accompanied by two hundred and twenty horsemen, and thus alighted on 
the green of Tara, and went immediately to Brian's house 


---

p.255




without either surety or protection, relying on the generosity of Brian himself and of the Dal gCais; and he 
told Brian all that had befallen him from beginning to end, and said that if he himself were able to fight 
Brian, battle was what he would give him; but as he was not, he had come now to give him sureties and 
hostages. When Brian heard this he said, ‘Since thou hast come into my house without surety or protection 
I grant thee a year's respite, during which I shall demand neither sureties nor hostages from thee, and I 
will go myself to visit these northerns, to wit, Aodh O Neill and Eochaidh, son of Ardghal, king of Ulster, 
that I may learn what answer they will give me; and if they give me battle then do thou not go against me 
with them.’ Maoilseachlainn promised that he would not go against him, and said that he would not advise 
Brian to go northwards on that occasion, but that he had better repair to his house until another time, 
‘for my doing homage to thee is enough for thee this time.’ They agreed on this point, and the Dal 
gCais were glad of it, for they had nearly consumed their provisions; and as Brian was returning home he 
bestowed twelve hundred horses on Maoilseachlainn, and gave a large amount of gold and silver to his 
followers as well.


A year after this, Brian son of Cinneide, assembled and brought together the general forces of all Leath 
Mogha both Gaels and Lochlonnaigh. There came there the Lochlonnaigh of Ath Cliath and of Port Lairge, of 
Loch Garman, of Ui Eachach Mumhan, Corca Luighdheach, and Ui Cinnsealaigh, and Brian proceeded with this 
great host to Ath Luain, and the nobles of Connaught gave hostages for their submission to him as high 
king.


Now Brian sent envoys to Maoilseachlainn asking him to send hostages to him to Ath Luain, and 
Maoilseachlainn himself came and gave him hostages and sureties. It was then that Brian brought together the 
main forces of 


---

p.257




Munster, of Connaught, and of Leinster, and of Meath, and he went with them to Dun Dealgan where he received 
the hostages and sureties of all Ulster. And it was in this way that Brian Boraimhe obtained the kingdom of 
Ireland, by the strength and bravery of his feats of valour and championship, driving the foreigners and the 
Danair out of the country, and not by treachery as others assert. For it was not the custom in Ireland that 
the son should succeed the father in the sovereignty of Ireland, as is plain from the history up to this 
point, but the sovereignty of Ireland was given to him who was the most powerful in action and exploit. And 
since Brian was the most powerful in action of the Irish in his own time, the majority of the nobles of 
Ireland chose him to be sovereign of the country, and as many of them as did not consent that the 
sovereignty of Ireland should be given to him were forced to submit to him against their will, and 
Maoilseachlainn was obliged to abandon the sovereignty of Ireland and cede it to Brian as we have 
said.


XXV.
----


Brian Boraimhe, son of Cinneide, son of Lorcan, son of Lachtna, son of Corc, son of Annluan, son of 
Mathgamhain, son of Toirrdhealbhach, son of Cathal, son of Aodh Caomh, son of Conall, son of Eochaidh 
Bailldhearg, son of Carrthann Fionn, son of Blod, son of Cas, son of Conall Eachluaith, son of Lughaidh 
Meann, son of Aonghus Tireach, son of Fear Corb, son of Mogh Corb, son of Cormac Cas, son of Oilill Olom, of 
the race of Eibhear, held the sovereignty of Ireland twelve years. Beibhionn, daughter of Archaidh, son of 
Murchadh, son of Maonach, king of West Connaught, was the mother of Brian. The descent of Beibhionn was as 
follows: Cianog, daughter of Ciocharan, a Connaughtman, bore a son and daughter to a Leinster chief called


---

p.259




Criachan through the prayer of Caireall, abbot, and of seven hundred monks with him, who prayed together to 
God that this couple who were barren a long period of their time may have progeny, and God heard the prayer 
of Caireall and of his community, and Cianog bore a son and daughter to Criachan. The son's name was 
Maoilmithidh and the daughter's name was Osnadh; and the daughter was given in marriage to Archaidh, son of 
Murchadh, son of Maonach, king of West Connaught, and she bore him Beibhionn, that is the mother of Brian 
Boraimhe, son of Cinneide.


It was in the reign of Brian that the following events took place, to wit, Sitric, son of Amhlaoibh, went 
to spoil Ulster in a large fleet, and he plundered Cill Chleite and Inis Cumhscraigh and took many sureties 
and much wealth therefrom. After this Naomhan, son of Maoilciarain, chief artificer of Ireland, and 
Raghnall, son of Gothfraidh, son of Aralt, king of the Isles, a Lochlonnach, died. It was about this time 
that Brian Boraimhe, son of Cinneide, king of Ireland, went with a numerous host to Cineal Eoghain in Ulster 
and thence to Meath, and they remained a night at Taillte, thence they went to Ard Macha, and remained there 
a week, and Brian left twenty ounces of gold on the altar of Ard Macha.


They proceeded thence to Dal nAruidhe, and Brian got sureties for the keeping of peace from the entire 
province of Ulster. Soon after this Brian went with another large host to Cineal Eoghain and Tir Chonaill 
and brought many hostages thence as sureties for maintaining peace.


It was about this time that Maolruanuidh, son of Ardghal, king of Ulster, died, also Clothna, son of 
Aonghus, chief poet of Ireland, and Cathal, son of Conchubhar, who was king of Connaught twenty years, and 
he died in Iorras Domhnann. After this Murchadh, son of Brian,


---

p.261




with the men of Munster and Leinster and the Ui Neill of the south, and Flaithbheartach, son of Muireadhach, 
with the young men of the Fochla went to plunder and spoil Cineal Luigdheach and brought thence three 
hundred in captivity.


Brian, son of Cinneide, king of Ireland, made a hosting to Magh Corainn and brought with him Maolruanuidh 
O Maoldoraidh, king of Cineal Conaill, to Ceann Choradh in captivity. Murchadh son of Brian spoiled and 
burned the province of Leinster as far as Gleann da Loch, and thence to Cill Mhaighnionn. It was about this 
time that the Lochlonnaigh with a large fleet went to Munster and plundered and burned Cork; and God 
requited them for this, for Amhlaoibh, son of Sitric, king of the Lochlonnaigh, and Mathghamhain, son of 
Dubhghall, son of Amhlaoibh, were treacherously slain by Cathal, son of Domhnall, son of Dubh da Bhuireann, 
soon afterwards. After this the Lochlonnaigh and the Leinstermen went into Meath, and they plundered 
Tearmonn Feichin and took thence many captives, and God took vengeance upon them soon afterwards, as is 
plain from the above account of the incursion which Murchadh, son of Brian, made into Leinster, in which he 
spoiled the Leinstermen and the Lochlonnaigh, as we have said.


As to Brian, son of Cinneide, when he was king of Ireland and had crippled the Lochlonnaigh, very great 
were the benefits he conferred on Ireland as we read in the books of the **seanchus**. 
Here follow briefly some of these benefits.



In the first place he restored and built churches, and gave every cleric his own temple according to his 
rank and his right to it. He built and set in order public schools for the teaching of letters and the 
sciences in general, and he also gave the price of books and expenses to each one who could not defray the 
expenses and who desired to devote himself to learning. He 


---

p.263




also gave freedom to the lords and territorial chiefs of the people; and all the spoil he had taken from the 
Lochlonnaigh he gave to the Gaels, and he freed all the Gaels from every species of oppression to which the 
Lochlonnaigh subjected them; and every territory which he took from the Lochlonnaigh by the strength of his 
arm, he gave it not to any of his own tribe, but gave each territory to the tribe in Ireland to whom it 
belonged of right.


It was Brian, too, who gave the men of Ireland distinct surnames by which each separate sept of them is 
distinguished from the rest. It was Brian also who built the church of Cill Dalua and the church of Inis 
Cealltrach, and restored the tower of Tuaim Greine. Moreover, Brian built many bridges and causeways and 
highways, and he built and repaired duns and fortresses and river banks and islands. He also built Cashel of 
the Kings and Ceann Abhrad, Inis Locha Ce and Inis Locha Gair, Dun Eochair Mhaighe, Dun Iasc and Dun Tri 
Liag, Dun gCrot and Dun Cliach, Inse an Ghaill Duibh and Inis Locha Saighlionn, Ros na Riogh, Ceann Choradh 
na Bhoraimhe, and the royal fortresses of Munster generally. It was also in the reign of Brian that a lone 
lady travelled from Tonn Tuaidhe to Tonn Cliodhna in the south, carrying with her a wand with a gold circlet 
or ring on it, and she was neither robbed nor violated, by reason of the rigour of Brian's rule in Ireland; 
and hence the poet composed this stanza:


> 1. From Toruidh to pleasant Cliodhna,
>   
> Having a circlet of gold by her side,
>   
> In the reign of bright-limbed, intrepid Brian,
>   
> A lone lady went round Erin.
> 




Ireland was thus rich, prosperous, peaceful during the twelve years that Brian reigned over her, and for him 
the poet composed this stanza: 


> 1. The boiling of the sea, a rapid flood,
>   
> Was Brian of Breagha over Banbha of variegated flowers,
>   
> Without sadness, without calumny, without suspicion,
>   
> Twelve years lasted his prosperity.
> 




---

p.265




It is very easy to see from this character which the **seanchas** give of Brian that it #
would not be right to call him a tyrant, for it was not according to his will or his strength that he governed 
the country during his reign, but according to the country's constitution and law. For a tyrant is one who 
governs and rules according to might and not according to right; and since it was not thus Brian acted, but 
according to right and the constitution, he cannot be called a tyrant.


Or if he should be called a tyrant (usurper) for supplanting Maoilseachlainn in the 
sovereignty of the country, having been chosen by the majority of the Irish nobles, let the reader judge 
whether it be more just to call him a tyrant (usurper) than to call the majority of the 
kings of Ireland who sprang from the children of Milidh tyrants (usurpers). For not one 
in every seven of them gained the sovereignty who did not do so by killing the king who came before him; and 
since they are not called tyrants (usurpers), being of the royal blood, for killing the 
king who came before them, in the same way, since Brian was of the royal blood he should not be called a 
tyrant (usurper) for having supplanted Maoilseachlainn, whom, though he was in his 
power, he did not kill, as other kings killed those who came before them in the sovereignty of Ireland, as 
we have said.


Here follow the tribute and dues that Brian Boraimhe claimed from the provincial kings of Ireland outside 
of Munster for the upkeep of the house of Ceann Choradh as stated by Mac Liag, chief **ollamh** of Ireland, in the poem which begins: Boraimhe town of the kings. In the first place he got from the province of Connaught eight hundred cows and eight hundred hogs; he got from 
Tir Chonaill five hundred mantles and five hundred cows; he got from Tir Eoghain three score cows and three 
score pigs and three score bars of iron; he got from the clann Rudhruighe of Ulster thrice fifty cows and 
thrice fifty hogs; he got 


---

p.267




eight hundred cows from Oirghialla; three hundred hogs, three hundred beeves and three hundred bars of iron 
from the province of Leinster; three score cows, three score pigs and three score bars of iron from 
Osruighe; he got from the Lochlonnaigh of Ath Cliath thrice fifty vats of wine; and he got from the 
Lochlonnaigh of Luimneach a tun of red wine every day in the year. And when Brian sat in his royal seat it 
was the king of Munster that sat at his right hand, just as it was customary with all the kings of the race 
of Eireamhon to place the kings of Ulster at their right hand. None of the men of Ireland were permitted to 
bear arms in Brian's house, but the Dal gCais alone as the above-mentioned poem says in this stanza: 


> 1. None of the men of Erin,
>   
> Only the Dal gCais of battle triumphs,
>   
> Were permitted to use their arms there
>   
> In the same house with the king of Erin.
> 



It is to be inferred from the amount of meat and wine that was fixed for the support of the household of the 
court of Ceann Choradh, that with the exception of Cormac son of Art, and Conaire Mor son of Eideirsceol, 
there was none among the kings of Ireland who had a larger household and more followers and who kept up a 
more princely house than Brian.


When Brian Boraimhe was residing at Ceann Choradh without strife or discord he besought the king of 
Leinster, Maolmordha, son of Murchadh, to send him three masts of excellent wood from Fiodh Gaibhle. The 
king of Leinster had the masts cut down and went with himself to Ceann Choradh where Brian then was; and he 
ordered the Ui Failghe to carry one of the masts and the Ui Faolain another and Ui Muireadhaigh the third, 
and a war of words arose between them as they were going up Sliabh an Bhogaigh; and thereupon as the king of 
Leinster himself put his shoulder under the mast assigned to the Ui Faolain, wearing a satin tunic which 
Brian had given


---

p.269




him sometime before, and which had gold borders to it and a silver clasp. And so greatly did the king of 
Leinster exert himself in bearing up the mast that the clasp of his tunic snapped; and when they reached 
Ceann Choradh the king of Leinster took off his tunic and gave it to his sister Gormfhlaith, daughter of 
Murchadh (that is Brian's wife), to fix a clasp in it. The queen took the tunic and cast it in the fire that 
was in front of her, and proceeded to reproach her brother for being in slavery or subjection to anyone on 
earth, ‘a thing,’ said she, ‘which neither thy father nor thy grandfather brooked;’ and she added, 
that Brian's son would make the same demand of his son. Now Maolmordha kept in mind the queen's remarks; and 
the next day Murchadh, son of Brian, and Conaing, son of Donn Cuan, happened to be playing chess, or 
according to others it was the **comhorba** of Caoimhghin of Glenn da Loch that was 
playing with Murchadh, and taught him a move which caused the game to go against him. ‘It was thou who 
gavest advice to the Lochlonnaigh which caused them to be defeated at the Battle of Gleann Mama,’ said 
Murchadh. ‘If I gave them advice which caused them to be defeated there,’ said Maolmordha, ‘I will 
give them another advice through which they will defeat thee in turn.’ ‘I defy thee to do so,’ said 
Murchadh.


Maolmurdha was enraged at this and he went to his sleeping apartment, and could not be got to come to the 
drinking hall that night, and he took his departure early the next morning without bidding farewell to 
Brian.


Now when Brian heard that the king of Leinster left the mansion without bidding him farewell, he sent a 
page of his household to detain him that he might give him wages and gifts. The place at which the page 
overtook him was at the end of the plank bridge of Cill Dalua on


---

p.271




the east side of the Sionainn, as he was mounting his steed, and he delievered to him the message Brian had 
sent him. Maolmordha, the king of Leinster, turned on the page and gave him three blows with the yew wand he 
held in his hand, so that he broke the bones of his skull, and it was in a litter that he was carried to 
Brian's house. The page's name was Cogaran and from him are the Ui Cogarain of Munster.


A party of the household of Ceann Choradh desired to pursue the king of Leinster and not to allow him to 
go to Leinster until he had submitted to Brian. Brian, however, said that it would not be permitted to 
practise treachery against him in his own house. ‘But,’ added he, ‘it is from the door-post of his 
own house that justice will be required of him.’


Maolmordha, king of Leinster, went into his own country, and summoned and brought together to him the 
Leinster nobles, and told them that himself and all his province had been dishonoured and treated to abusive 
speech at Ceann Choradh. Accordingly what they agreed on was that they themselves and a Lochlonnach force 
should go against Brian, so that the Battle of Cluain Tarbh was set on foot between them; and since Brian 
had not left in Ireland as many of the Lochlonnaigh as could fight a battle, having left only the party he 
suffered, on the excuse of trading, to remain in Ath Cliath, in Loch Garman, in Port Lairge, in Corcach and 
in Luimneach, for the purpose of attracting commerce from other countries to Ireland, what the king of 
Leinster and the Lochlonnaigh decided on was to send to the king of Lochloinn for a force with which to meet 
Brian in battle on Magh nEalta at Cluain Tarbh. And when the message reached the king of Lochloinn he sent 
his two sons Carolus Cnutus and Andreas with a host of twelve thousand Lochlonnaigh to help the king of 
Leinster to fight the Battle of Cluain Tarbh, and when they landed at Ath Cliath the king of Leinster 


---

p.273




sent word to Brian to give notice that he would give him battle at Cluain Tarbh.


As to Brian, son of Cinneide, king of Ireland, he assembled the forces of Munster and Connaught and 
proceeded to Ath Cliath to fight the Battle of Cluain Tarbh, as we have said. And there went thither with 
him the race of Fiachaidh Muilleathan with their branches of descendants a great bulky stately host. Thither 
went also the descendants of Cas, son of Conall Eachluaith, to wit, the Ui Bloid and the Ui Caisin, and the 
descendants of Aonghus Chinn nAthrach, and the Cineal Baoth and the Cineal Cuallachtaigh, the Cineal 
Failbhe, and the clann Eachach under Ceallach, son of Duibhgheann, and the clann Choilein under Meanman, son 
of Eisidh, son of Sidh, son of Maolcluiche, and the Cineal Fearmhaic under Maolmeadha, son of Baodan. 
Thither went also the sons of Cinneide son of Lorcan, Annluan, Lachtna, Coscrach, Lorcan, Seanchan, Ogan, 
Maolruanuidh and Aingidh, Murchadh son of Brian, and his son Toirrdhealbhach and five brothers of Murchadh, 
to wit, Tadhg, Donnchadh, Domhnall, Conchubhar and Flann. Thither went in like manner the sons of Donn Cuan 
son of Cinneide, to wit, Longargan, Ceileachair, Cinneide, Fianghalach, Innreachtach, Eochaidh, son of 
Innreachtach, and Duibhgheann son of Eochaidh and Beallan and as many of the servants and followers of these 
as came with them. Thither also went a great host of Connaughtmen under Tadhg son of Murchadh O Ceallaigh, 
king of Ui Maine, and under Maolruanuidh na Paidre O Eidhin, king of Eidhin, with many of the Connaught 
nobles, through a feeling of kinship with Brian, for Beibhionn, his mother, was a Connaughtwoman. In like 
manner Maoilseachlainn son of Domhnall, with the strength of Meath under him, went to meet Brian to help 
him.


And when they came together to one place on Magh nEalta they prepared and arranged themselves for battle 


---

p.275




on either side, the king of Leinster and the Lochlonnaigh on one side, the two sons of the king of 
Lochloinn, to wit, Carolus Cnutus and Andreas being their leaders; Brian with the nobles of Munster, 
Connaught and Meath on the other side, with Murchadh, son of Brian, as their leader. Maoilseachlainn, 
however, did not wish to help them.


The battle was bravely fought between them, and the Lochlonnaigh and the Leinstermen were defeated; and 
the two sons of the king of Lochloinn and the nobles of the fleet who came with them fell there, together 
with six thousand and seven hundred Lochlonnaigh. There also fell the men of Ath Cliath and another company 
of the Lochlonnaigh of the fleet about four thousand. In like manner fell the king of Leinster and most of 
the nobles of Leinster together with three thousand one hundred Leinstermen.


Now on the other side fell Murchadh, son of Brian, the heir apparent to the throne of Ireland, and the 
majority of the Munster and Connaught nobles around him together with four thousand men. And a party of 
Lochlonnaigh who were fleeing into the country from the slaughter came upon Brian's tent, and some of them 
knew that it was Brian who was in it, and Bruadar, their leader, who was of the party, went towards Brian, 
and they slew him, but Brian's people slew Bruadar and his people. Here follow other supporters of Brian who 
were slain in that battle, to wit, Toirrdhealbhach, son of Murchadh, son of Brian, and Conaing, son of Donn 
Cuan, son of Cinneide, and Mothla, son of Domhnall, son of Faolan, king of Deise Mumhan, Eochaidh son of 
Dunadhach, prince of the clann Scannlain and Niall Ua Cuinn, and Cu Doiligh son of Cinneide, three 
companions of Brian, and Tadhg, son of Murchadh O Ceallaigh, king of Ui Maine, and Maolruanuidh na Paidre O 
Heidhin, king of Eidhin, and Geibheannach, son of Dubhagan, king of Feara Muighe, and Mac Beathaidh, son of 
Muireadhach Claon, king of Ciarraidhe Luachra, 


---

p.277




Domhnall, son of Diarmaid, king of Corca Baiscinn, Scannlan, son of Cathal, king of the Eoghanacht of Loch 
Lein, and Domhnall, son of Eimhin, son of Cainneach, and Mormhaor Marr, that is Muireadhach Mor of Alba, and 
many other nobles that are not mentioned here. The year of the Lord when the Battle of Cluain Tarbh was 
fought was 1034, the Friday before Easter. Here is the **seanchas** setting forth of the 
number of years that had elapsed from the birth of Christ to the death of Brian: 


> 1. Four years and thirty,
>   
> With a thousand without deceit,
>   
> From the springing up of a Physician to help us
>   
> To the death of Brian in Breagha.
> 



And Brian's age at that time was eighty-eight years, as the poet says in this stanza:


> 1. The life of Brian with victories
>   
> Up to the conflict with shouts,
>   
> Four score years
>   
> And eight are counted.
> 




Moreover, Murchadh, son of Brian, was sixty-three years when he fell in this battle.




---

p.279


XXVI.
-----


Now when the Battle of Cluain Tarbh was over and Brian and Murchadh with many Gaels slain, and the 
Lochlonnaigh and the Leinstermen defeated and the majority of them slain in that battle, and when the Dal 
gCais and race of Fiachaidh Muilleathan, had reached Mullach Maistean on their return journey, then the race 
of Fiachaidh formed themselves into a distinct host and separated from the Dal gCais; and as the Dal gCais 
were weak in hosts and contingents, they formed the resolution of sending envoys to Donnchadh, son of Brian, 
to ask hostages from him and to point out to him that his father and his father's brother had hostages from 
them, and they said they had a right to the sovereignty of Munster in alternate succession. ‘It was not 
with your consent ye were under my father or kinsmen,’ said Donnchadh, ‘it was they who made ye submit 
against your will and the men of Ireland with you.’ And Donnchadh added that he would give neither 
hostages nor sureties to them or to anyone else, and said that if he had enough of men to fight them he 
would not let them go without getting hostages from them for their being submissive to him as they were to 
his father.


When the Desmond host heard this message they arose promptly and suddenly, and seized their arms and went 
to give battle to the Dal gCais. Donnchadh, son of Brian, then directed his people to put their wounded men 
into Raith Maistean with a third of the host in charge of them, ‘and let the other two-thirds,’ added 
he, ‘meet that party in battle.’ Now the Dal gCais numbered then only one thousand, the remnant of a 
slaughter, while the Desmond host were three thousand strong. When the 


---

p.281




wounded heard this speech of Donnchadh's they arose quickly and put moss in their wounds and sores, and they 
grasped their weapons in their hands, and their counsel was to engage in the battle. When the race of 
Fiachaidh Muilleathan observed this courage on the part of the Dal gCais, both sound and wounded, they 
ceased to speak of engaging in the battle, and marched onwards to their homes without getting hostages from 
the Dal gCais.


As to the Dal gCais they marched on thence to Ath I on the *brink* of 
the Bearbha and began to drink water there. Donnchadh Mac Giolla Phadraig, king of Osruighe, was there to 
meet them with his full host and reserves, to wit, the Leinstermen and the Ossorians, on Magh Cloinne 
Ceallaigh, and he had set a watch on the Dal gCais to find what way they would take, by reason of his great 
enmity against them. For Brian had tied and bound Donnchadh's father and kept him a year in bondage, and had 
spoiled and wasted all Osruighe and slain many of its people. Hence Mac Giolla Phadraig kept up the enmity 
against the Dal gCais, and he sent envoys to them to Ath I, to ask them to send him hostages as a condition 
of his allowing them to pass from that place unmolested. But Donnchadh son of Brian's answer to the envoys 
was that he would not give hostages. ‘Then,’ said the envoys, ‘Mac Giolla Phadraig would have to be 
met in battle.’ ‘He will get battle,’ said Donnchadh, ‘and it is a pity that I did not meet the 
death my father met, before I was overtaken by the misfortune of these people demanding hostages from 
me.’ The envoys told him not to get angry, seeing that he was not strong enough to fight Mac Giolla 
Phadraig. ‘Now if it were the custom to give affront to any envoys whatever on account of their 
message,’ said Donnchadh, ‘I would have your tongues plucked out of your heads, for if I had but a 
single page as a following I would not refuse battle to Mac Giolla Phadraig and to the Ossorians.’




---

p.283


Then Donnchadh son of Brian set the third of the host in charge of their wounded and the remaining 
two-thirds to give the battle. When the wounded heard this, they sprang up suddenly, and their wounds and 
gashes burst open, and they filled them with moss, and they seized their lances and their swords and came in 
this guise into the midst of their comrades, and they besought the son of Brian to send men into the wood to 
fetch strong stakes which were to be stuck in the ground, ‘and let us be tied to these,’ said they, 
‘and let our arms be given into our hands and let our sons and kinsmen be placed beside us, to wit, two 
unwounded men around each of us wounded, so that we may act together with the greater earnestness. For the 
unwounded man will be ashamed to leave his post until the wounded man of our company who is bound leaves 
it.’ They were arrayed in that way; and that array into which the Dal gCais put themselves was a surprise 
for the mind, and a very great wonder.


When the Leinstermen and the Ossorians observed this extraordinary courage rising in the Dal gCais they 
conceived fear and terror of them, and what they said was: ‘It is not a retreat in disorder or panic that 
may be expected from the Dal gCais,’ said they, ‘but the fighting of a close firm battle in 
self-defence. For this reason we will not give them battle, for they are indifferent as to whether they 
shall endure death or life.’ Mac Giolla Phadraig replied: ‘It is cowardly of you to say that, seeing 
that you are numerous enough to eat yonder company if they were cooked food.’ ‘That is true,’ they 
replied, ‘but though it be true, none of these will be slain without his having slain five or six, and how 
is it to our advantage to be slain with them?’ ‘Since you do not wish to give them battle,’ said Mac 
Giolla Phadraig, ‘harass them by pursuit;’ and the Dal gCais were less pleased at this than they would 
have been to give them battle. After this the


---

p.285




Dal gCais proceeded unto their own country in want and in difficulties, and only eight hundred and fifty 
reached home with the son of Brian, for they lost a hundred and fifty through this harassing pursuit of the 
Ossorians on their failing to give battle.


The following is the account of the Battle of Cluain Tarbh which Maoilseachlainn son of Domhnall, king of 
Meath, gave a month after the battle was fought; for the clann Cholmain were asking him for tidings of the 
battle. Thereupon Maoilseachlainn said that he had never seen such a battle or an approach to it. 
‘For,’ said he, ‘if God's angel from heaven were to give you an account of it his account would seem 
incredible. Now I and my host were looking at them at the distance only of a fallow field and a fence. But 
when these battalions had faced one another and stood breast to breast, they set to flail and to lash one 
another; and like unto a heavy flock of white sea-gulls over the coast, when the tide is coming up into the 
land, were the white showers of shields above their heads; and if we wished to go to the assistance of 
either side it was not in our power to do so, for our lances and our arms were bound and fastened above our 
heads by the firm closely set wisps of hair which the wind blew to us from the heads and beards of the 
warriors as they were being hacked and cut down by the edge of the swords and strong weapons on every side, 
so that we found it difficult to keep the handles of our weapons from getting entangled in one another. And 
we thought that those who were in the fight did not suffer more than we did who had to look on without 
running wild and mad.’


Observe, O reader, that though it was as part of the host of Brian that Maoilseachlainn and the men of 
Meath came to the field of battle, still through a plot between himself and the Lochlonnaigh, he did not 
come into the battle array amongst Brian's host, but what he did was 


---

p.287




to remain with his host beside the battle, as the Lochlonnaigh had directed him.


Neither the Cineal Eoghain nor the siol Conaill were at the battle, but it was not that they did not 
offer to come there, but that Brian said in his high courage that it was without them he gained any success 
he had ever gained, ‘and so it will be now,’ said he.


Maoilseachlainn held the sovereignty again after Brian nine years. It was in his reign that the following 
events took place. Maoilseachlainn, king of Ireland, with a numerous host, together with O Neill and O 
Maoldoraidh, went to Ath Cliath, and they plundered and burned the town against the remnant of the 
Lochlonnaigh who lived at that time not having fallen by Brian at the Battle of Cluain Tarbh. Thence they 
proceeded to Ui Cinnsealaigh, and they spoiled and burned the entire country, and many people were slain 
there. After that Maoilseachlainn went to Ulster and brought thence many captives. It was about this time 
that Donnagan, king of Leinster, and Tadhg O Riain, king of O Drona, and many other persons were slain by 
Donnchadh Mac Giolla Phadraig in the field of Leithghlinn; and Mac Liag, high **ollamh** of 
Ireland, died. Maoilseachlainn, king of Ireland, made a hosting in Osruighe, and there slew Dunghal Mac 
Giolla Phadraig, son of Donnchadh, and many other persons with him.


It was this Maoilseachlainn of whom we are treating who founded the monastery of St. Mary's in the town 
of Ath Cliath in the year of the Lord 1039. And this Maoilseachlainn was a pious man in his latter days. For 
when the power of the Lochlonnaigh had been broken at the Battle of Cluain Tarbh so that they had only the 
wardenship of seaport towns, while it was their wont to make incursions into the country at times to spoil 
and ravage, as they were not numerous enough to give battle to the Gaels, Maoilseachlainn began to restore 
schools and to


---

p.289




build and set in order churches, after the example of Brian. We also read that he maintained three hundred students at his own 
expense.


It was in the reign of this Maoilseachlainn that Brian, son of Maolmordha, son of Murchadh, who was king 
of Leinster two years, was treacherously blinded by Sitric son of Amhlaoibh, in Ath Cliath. The same Sitric 
plundered and spoiled Ceanannus, slaying many people there and taking many captives thence. It was about 
this time that Ughaire son of Dunlaing, son of Tuathal, son of Ughaire, son of Oilill, son of Dunlaing, who 
was king of Leinster three years, inflicted a great defeat on Sitric son of Amhlaoibh, and the Lochlonnaigh 
of Ath Cliath, and dreadful slaughter was made of the Lochlonnaigh there. And Donn Sleibhe, son of 
Maolmordha, son of Muireigen, burned the house of Ughaire, so that Ughaire was burned in it at Dubhloch 
Leasa Cuile. After this, Sitric son of Iomhar, leader of the Lochlonnaigh of Port Lairge, was slain by the 
king of Osruighe, and Maoilseachlainn, king of Ireland, died at Cro-inis in Loch Ainninn.


Although the **seanchas** enumerate high kings as having ruled Ireland after Maoilseachlainn, I do not think 
that there was a king over the country without opposition until the Norman Invasion, notwithstanding that 
some of them assumed the sovereignty of Ireland. Here is the testimony of the **seancha** on this point in this 
stanza:


> 1. After prosperous Maoilseachlainn,
>   
> Son of Domhnall, son of Donnchadh,
>   
> To no tribe remained a fair king,
>   
> And no one king ruled Erin.
> 






---

p.291


XXVII.
------


Donnchadh, son of Brian Boraimhe, held the sovereignty of Leath Mogha and the greater part of Ireland 
fifty years according to Finghin Mac Carrthaigh, in the booklet he has written on the History of Ireland, 
and others learned in the **seanchus**; and I think this opinion is more likely to be true than the opinion of 
those who say that Donnchadh reigned only twelve years. For Finghin's opinion is in accordance with the 
number of years that are from the death of Brian to the Norman Invasion, while the latter opinion is not. 
Hence I think that Finghin's opinion is the true one, which says that fifty years was the length of 
Donnchadh's reign. It was in the reign of Donnchadh that Harolt Conan, prince of Wales, fled to Ireland 
where he found shelter in the year of the Lord 1050. It was in Donnchadh's time that the following events 
took place. For it was then that Mathghamhain O Riagain, king of Breagha, took captive Amhlaoibh, son of 
Sitric, leader of the Lochlonnaigh in Ireland, and got a ransom of twelve hundred cows and six score steeds 
on his account.


It was about this time, also, that Flaithbheartach O Neill went on a pilgrimage to Rome the year of the 
Lord then being 1073. After this Tadhg, son of Lorcan, king of Ui Cinnsealaigh, died at Gleann da Loch while 
he was there as a penitent; and Gormfhlaith, daughter of Murchadh son of Flann king of Leinster, mother of 
Sitric, son of Amhlaoibh, leader of the Lochlonnaigh of Ireland, died, and she was the mother of Donnchadh, 
son of Brian Boraimhe. It was about this time that Cluain Fearta Breanainn was plundered by Art Coileach O 
Ruairc, king of Breithfne; and on the same day, Donnchadh, son of Brian, came upon him and made dreadful 
slaughter of his people in vengeance for that sacrilege they had committed. Soon after this, Cathal, 


---

p.293




son of Ruaidhri, king of west Connaught, went on a pilgrimage to Ard Macha. After this, Port Lairge was 
plundered and burned by Diarmaid son of Maol na mBo, king of Leinster, and Cluain Mic Nois was plundered by 
the Conmhaicne; and God and Ciaran avenged this on them, that is, most of their people and their cattle died 
soon afterwards.


It was about this time that Carrthach, son of Saoirbhreathach, king of Eoghanacht Chaisil, was burned, 
together with many other nobles, in a fire-house by the son of Longargan, son of Donn Cuan. After this 
Donnchadh, son of Brian, was deposed from his sovereignty, and went on a pilgrimage to Rome, where he died 
in the monastery of St. Stephen. And as to what many assert that the Pueraigh Eustasaigh and the 
Pluingceadaigh are descended from Donnchadh, I have found neither lay nor letter to prove that any of them 
were descended from him, except one stanza which is in the poem beginning: I will confer a favour on the clann Tail, which Maoilin Og Mac Bruaideadha a contemporary of our own has composed. Moreover as to the tradition that exists among many of the rustics who say that when Donnchadh went on a pilgrimage to 
Rome he had intercourse with the daughter of the emperor who was there then, and that she bore him a son, 
and that from that son might have sprung the three septs we have mentioned; this story cannot be true, for 
before setting out on that expedition he was a very old decrepid man of over eighty years of age, and it is 
not likely that an emperor's daughter would covet intercourse with such a veteran, and, moreover, it would 
have been unbecoming in him who went for the sake of pilgrimage and penance to covet any woman whatever.


And from what I have said, I judge that Donnchadh did not have intercourse with the emperor's daughter, 
and that she did not bear him a son from whom the septs referred to could have sprung.




---

p.295


The truth of this statement will be the more readily admitted as we read in an old book of annals, which 
was copied from the Speckled Book of Mac Aodhaghain about three hundred years ago, that Donnchadh, after 
having performed his pilgrimage to Rome, went to live in the monastery of St. Stephen in Rome, and that he 
took upon himself the yoke of piety, and passed the remainder of his life until death in penance in the same 
place.


We also read in the chronicles of the Normans, where the Norman nobles who came first to Ireland are 
enumerated, that it was at the beginning of the Norman Invasion that Robert le Power, from whom sprang the 
Pueraigh and the Eustasaigh in Ireland, first came, and the same authors say that the Pluingceadaigh are of 
Lochlonnach origin.


Toirrdhealbhach, son of Tadhg, son of Brian Boraimhe, held the sovereignty of Munster and of the greater 
part of all Ireland twelve years. Mor, daughter of Giolla Brighde O Maolmuaidh, king of Cineal Fiachaidh and 
and of Feara Ceall, was mother of this *Toirrdhealbhach* O Briain. It was in his reign that the following events took place. For it was then that Conchubhar, son of Maoilseachlainn, king of Meath, was treacherously 
slain by his own brother's son, to wit, Murchadh, son of Flann, and his head was forcibly carried off from 
where he was buried at Cluain Mic Nois to Ceann Choradh by Toirrdhealbhach O Briain the Friday before 
Easter, and the same head was taken back northwards to *Cluain* Mic Nois the next 
Sunday, and this happened through the wonderworking of Ciaran.


It was in the reign of this Toirrdhealbhach that William Rufus, king of England, by the permission of 
Toirrdhealbhach O Briain, king of Ireland, sent to Ireland for timber with which to roof Westminster Hall in 
the year of the Lord 1098; and the year before that the first 


---

p.297




bishop, his name was *Malchus*, was consecrated at Port Lairge, by 
Anselmus, archbishop of Canterbury. It was about this time that Dearbhforgaill, daughter of Tadhg Mac Giolla 
Phadraig, wife of Toirrdhealbhach O Briain, king of the greater part of Ireland, died. After this 
Toirrdhealbhach O Briain, king of the greater part of all Ireland, died after he had reigned twelve 
years.


Muircheartach, son of Toirrdhealbhach, son of Tadhg, son of Brian Boraimhe, held the sovereignty of Leath 
Mogha and the greater part of all Ireland twenty years. Cailleach Dhe, daughter of O Heidhin, was mother of 
Muircheartach O Briain and mother of Ruaidhri O Conchubair. It was in his reign that the following events 
took place. In the first place it was he bestowed Cashel on the Church as an offering to God and to Patrick 
the first year of his reign, in the year of the Lord 1106; and about this time there was a general assembly 
of the men of Ireland, both lay and cleric, around Muircheartach O Briain, king of Leath Mogha in Fiadh Mic 
Aonghusa. Here follows the number of clerics that were at this assembly, namely, Maolmuire O Dunain, 
archbishop of Munster, and Ceallach son of Aodh, **comhorba** of Patrick, that is the 
vicar-general of the primate, and eight bishops, three hundred and sixty priests and seven score deacons, 
and many clerics that are not enumerated here. And they made regulations and laws and customs for the Church 
and the laity. After this, Maolmuire O Dunain, archbishop of Munster, died.




---

p.299


XXVIII.
-------


It was also in the time of this Muircheartach that a synod or National Council was convened in Ireland at 
Raith Breasail in the year of the Lord 1100, according to an old book of annals of the church of Cluain 
Eidhneach Fionntain in Laoighis, in which are recorded the principal things done at that synod; and Giolla 
Easpuig, bishop of Luimneach, who was the Pope's legate in Ireland at that time, was president of that 
council. Now here follow the regulations that were made therein.


Just as twelve bishops were fixed under Canterbury in the south of England, and twelve bishops in the 
north under the city of York, a similar arrangement was made at the synod of Raith Breasail in Ireland, to 
wit, twelve bishops in Leath Mogha and twelve bishops in Leath Cuinn and also two bishops in Meath. It was 
at this synod that the churches of Ireland were given up entirely to the bishops free for ever from the 
authority and rent of the lay princes. It was there also were regulated the sees or dioceses of the bishops 
of Ireland. Here is the full number of the bishops of Leath Cuinn: six in the province of Ulster, including 
the primate; five in the province of Connaught, and two in Meath. And this gives the full twelve bishops of Leath Cuinn excluding the primate. The following are the dioceses of the province of Ulster, to wit, Ard 
Macha, the see of the archbishop of Ard Macha and primate over the bishops of all Ireland, Clochar, Ard 
Sratha, Doire, Cuinneire, and Dun da Leathghlas; the sees of Meath, Daimhliag and Cluain Ioraird; the sees 
of the province of Connaught, namely, Tuaim da Ghualann, Cluain Fearta Breanainn, Conga, Cill Aladh, and Ard 
Charna; the sees of Munster, Cashel held by the archbishop of Leath Mogha, Lios Mor or Port Lairge, Corcach, 


---

p.301




Raith Mhaighe Deisceirt, Luimneach, Cill Dalua, Imleach Iobhair. These were the seven sees which were 
decreed to Munster at this synod. Five sees in Leinster, Cill Chainnigh, Leithghlinn, Cill Dara, Gleann da 
Loch, Fearna or Loch Garman. Adding these five sees to the seven sees of Munster they make twelve sees in 
Leath Mogha. The reason why Ath Cliath is not counted here is that it was not customary with its bishop to 
receive consecration except from the archbishop of Canterbury in England.


**Hanmer** states falsely that the archbishop of Canterbury had jurisdiction over the Irish clergy from the 
time of Augustine the monk until the Norman Invasion. For you will not find that the prelates of Canterbury 
had jurisdiction over the Irish clergy except in the time of Lanfrancus Ranulphus and Anselmus; and even 
then the portion of the clergy of Ireland over whom they had jurisdiction were the clergy of Ath Cliath, 
Port Lairge, Loch Garman and Luimneach who were descended from the remnant of the Lochlonnaigh who were 
called Normani, and it was through a feeling of friendship for the people of Normandy who sprang from their 
own race that the prelates of these places gave jurisdiction and authority to the archbishop of Canterbury 
over them, as is clear from the booklet written by Dr. *Ussher*, for they 
considered if there were to be an election by the people between themselves and one of the Gaels who sought 
the same dignity, that their side would not have an equal chance, as in the election the Gael would have a 
larger popular vote than any of them.


I think that although the old book does not so state, it was six bishops that were in Munster and six in 
Leinster, with the archbishop of Cashel over them all as chief prelate of Leath Mogha after the manner of 
the temporal sovereignty as we have said above in treating of this matter in the reign of Laoghaire.




---

p.303


Here follow the sees or dioceses and their boundaries as they were regulated in this synod of Raith 
Breasail.


The see of the archbishop of Ard Macha, from Sliabh Breagh to Cuaille Ciannachta and from Bior to the 
Abhann Mhor.


The see of Clochar, from the Abhann Mhor to Gabhail Liuin and from Sliabh Beatha to Sliabh Largha.


The see of Ard Sratha, from Sliabh Largha to Carn Glas and from Loch Craoi to Beann Foibhne.


The see of the bishop of Doire or Raith Both, from Eas Ruadh to Srubh Broin and from Carn Glas to Srubh 
Broin.


The see of the bishop of Cuinnire, from Beann Fhoibhne to Torbhuirg, and from Port Murbhoilg to Ollorbha 
and to Cuan Snamha Aidhne, and from Gleann Riogh to Colbha Gearmainn.


The see of the bishop of Dun da Leathghlas, its boundary is not found in the old book.


The see of the bishop of Daimhliag, from Sliabh Breagh to Carn Duin Cuair and from Lochan na hImrime 
eastward to the sea.


The see of Cluain Ioraird, from Clochan westward to the Sionainn, and from Iubhar Coillte to Cluain 
Conaire.


The see of Cluain Fearta, from the Sionainn to Buireann and from Echtghe to the Succa.


The see of Tuaim, from the Succa to Ard Charna, and from Ath an Tearmainn to
the Sionainn.


The see of Conga, from Abhann Ui Bhriuin northwards to Neimhtheann, and from Ath an Tearmainn westward to 
the sea.


The see of Cill Aladh, from Neimhtheann to Eas Ruadh, and from Cill Airdbhile to Sraith an Fhearainn.


The see of Ard Charna or of Ardachadh, from Ard Carna to Sliabh an Iarainn, and from Ceis Chorainn to 
Iobhar Coilltean. If the Connaught clergy agree to this division, 


---

p.305




we desire it, and if they do not, let them divide it as they choose, and we approve of the division that 
will please them, provided there be only five bishops in Connaught.


The see of the archbishop of Cashel, from Sliabh Eibhlinne to the Siuir and from Cnamhchoill at Tiobrad 
Arann eastward to Grian Airbh, that is Cros Ghreine.


The see of Lios Mor or Port Lairge, from Mileadhach on the brink of the Bearbha at Cumar na dtri 
nUisceadh to Corcach, and from the Siuir southward to the sea.


The see of Corcach, from Corcach to Carn Ui Neid, and from the Abhann Mhor southwards to the sea.


The see of Raith Mhaighe Deisceirt, from Baoi Bheirre to Ceann Beara, and from the Feil to Dairbhre.


The see of Cill Dalua, from Slighe Dhala to Leim Chon gCulainn, and from Echtghe to Sliabh Uidhe an 
Riogh, and from Sliabh Uidhe an Riogh to Sliabh Caoin or Gleann Caoin.


The see of Luimneach, the Maoilchearn eastward, Ath ar Choinne, Lodan and Loch Gair, and the Laitheach 
Mhor from Aine westward, and Ard Padraig to the south and Bealach Feabhradh and Tulach Leis, the Feil 
westward and Tairbeart and Cuinche in Thomond, and Crossa in Sliabh Uidhe an Riogh and the Dubhabhann. 
Whoever shall go against these boundaries goes against the Lord and Peter the Apostle and St. Patrick and 
his **comhorba** and the Christian Church. And the Church of Mary in Luimneach is its 
principal church.


The see of Imleach Iobhar, from Cluain Caoin to the Abhann Mhor, and from Cnamhchoill at Tiobrad Arann to 
Abhann Ealla.


The see of Cill Chainnigh, from Sliabh Bladhma to Mileadhach, and from Grian Airbh to Sliabh Mairge.


The see of Leithghinn, from Sliabh Bladhma to Sliabh Uidhe Laighean, from Sliabh Mairge to Bealach 
Carcrach, and from Bealach Mughna to Teach Moling and its termon lands.




---

p.307


The see of Cill Dara, from Ros Fionnghlaise to Nas Laighean, and from Nas to Cumar Chluana Ioraird and to 
Sleibhte Ghlinne da Loch.


The see of Gleann da Loch, from Grianog to Beig-Eire, and from Nas to Reachruinn.


The see of Fearna or Loch Garman, from Beig-Eire to Mileadhach on the west of the Bearbha, and from 
Sliabh Uidhe Laighean south to the sea; and if the Leinster clergy agree to this it is our pleasure, 
provided they have only five bishops.


The blessing of the Lord and of Peter the Apostle and of St. Patrick be on everyone of these twenty-five 
bishops who shall let no Easter pass without consecrating oil.


And there are many other good decrees of this holy synod which we have not set down here for brevity.


The cross of the **comhorba** of Peter and of his legate, that is Giolla Easpuig, bishop 
of Luimneach,


The cross of Giolla Ceallaigh the **comhorba** of Patrick and primate of Ireland,


The cross of Maoiliosa O Ainmire, archbishop of Cashel,


The crosses of all the bishops and of all the laity and clergy who were at this holy synod of Raith 
Breasail against whomsoever shall transgress these decrees, and the malediction of them all on whomsoever 
shall oppose them.




---

p.309


XXIX.
-----


We read in the chronicle of Hackluite that when Muircheartach O Briain held the sovereignty of Ireland 
the people of the Isles sent envoys to him to request him to send some one of his kinsmen of the royal blood 
to rule over the Isles during the nonage of Olanus or Amhlaoibh son of Gothfruidh, who had an hereditary 
right to be king of the Isles; and Muircheartach sent a nobleman of his own kindred named Domhnall son of 
Tadhg O Briain to rule over them, and he held sovereignty over them three years, when he began to tyrannise 
over them, and for this reason the people of the Isles sent him back to Ireland.


We read in the same author that Maghnus, son of Amhlaoibh, son of Aralt, who was king of Norway, sent 
envoys to Muircheartach O Briain, and sent his own shoes with them, to command Muircheartach to place the 
shoes on his shoulders; and when the envoys had come into his presence they gave him their message. 
Muircheartach took the shoes from them and put them on his shoulders; and when the nobles who were with him 
saw this, they became greatly enraged, and they reproached him for having done this deed. ‘I prefer to do 
this,’ said Muircheartach, ‘to Maghnus's plundering any province of Ireland.’ After this Maghnus got 
ready a large fleet and came from Norway to Ireland to injure and ruin that country, and when he had come 
near Ireland he came to land himself with a wing of the fleet through his great hurry to work havoc; and 
when they had landed, the inhabitants of the country were in readiness for them; and when Maghnus and his 
detachment came on land the inhabitants sprang upon them, and Maghnus and his party were slain on that 
expedition. And when the men of the fleet he had left 


---

p.311




behind heard that Maghnus their leader was slain, they returned to Norway.


This Muircheartach O Briain of whom we are treating after he had spent five years in trouble died 
repentant at Ard Macha, and was buried at Cill Dalua in the principal church.


Toirrdhealbhach Mor, son of Ruaidhri O Conchubhair, held the sovereignty of the greater part of Ireland 
after Muircheartach O Briain for the space of twenty years. It was in his reign the following events took place. This Toirrdhealbhach built three chief bridges in Connaught, to wit, the bridge of Ath Luain and the 
bridge of Ath Crochdha on the Sionainn and the bridge of Dun Leoghdha on the Succa. This Toirrdhealbhach 
made a hosting into Munster and plundered Cashel and Ard Fionain, and when he was marching to spoil Ard 
Fionain a body of Munstermen came upon the rear of the host and slew Aodh O hEidhin, king of Ui Fiachrach, 
and Muireadhach O Flaithbheartaigh, king of west Connaught, and many other nobles not enumerated here.


Thereafter this Toirrdhealbhach with a large land and sea force went to Corcach, and set to plunder all 
Munster; and he divided Munster into two parts, and gave the southern part to Donnchadh Mac Carrthaigh, and 
the northern half to Conchubhar O Briain, and he took thirty hostages from them both. It was about this time 
that Cormac's church was consecrated at Cashel in the presence of many clerics and nobles of Ireland, the 
year of the Lord at that time being 1134. After that Cormac Mac Carrthach, king of Munster, was 
treacherously slain by Toirrdhealbhach O Briain, that is, his own son-in-law and gossip; and Maolmaodhog, 
that is Malachias, who was archbishop of Ireland and of Alba, died, the year of the Lord then being 1135. 
Toirrdhealbhach O Conchubhair with the strength of Connaught, Leinster and Meath, and 


---

p.313




of Feara Teabhtha and of O Ruairc's country, made another hosting into Munster, and they made a free circuit 
of Munster until they reached Gleann Maghair, where they met Toirrdhealbhach O Briain, king of Munster, and 
the son of Conchuhbar O Briain, and the men of Munster with them. They were three battalions in all. The 
Battle of Moin Mhor was fought between them and the Dal gCais, and the Munstermen were defeated there and a 
countless number of them fell. Toirrdhealbhach O Briain was banished to Tir Eoghain, and Toirrdhealbhach O 
Conchubhair divided Munster between Tadhg O Briain and Diarmaid son of Cormac Mac Carrthaigh.


Soon after this, Toirrdhealbhach O Conchubhair, king of the greater part of Ireland, died, and he was 
sixty-eight years of age at that time, and he was buried at the high altar of Ciaran at Cluain Mic Nois; and 
great was the legacy he left to the clergy for his soul's sake, to wit, five hundred and forty ounces of 
gold, and forty marks of silver, and all the other valuables he had, both goblets and precious stones, both 
steeds and cattle, clothes, chess and backgammon, bows and quivers, sling and arms, and he himself gave 
directions how each individual church's share should be given to it according to its rank. It was about this 
time that Tadhg O Longargain, bishop of Cill Dalua, died.


Muircheartach, son of Niall, son of Lochlann, held the sovereignty of Leath Cuinn and of the greater part 
of Ireland eighteen years till he fell by the men of Fearnmhagh and by O Briuin. And it was in the seventh 
year of this man's reign that an assembly and general council of the church of Ireland was convened at 
Ceanannus na Midhe in the year of the Lord 1152, to set forth the Catholic faith and to purify it and to 
correct the customs of the people, and to consecrate four archbishops and to give them four pallia. For 
there had been up to


---

p.315




then in Ireland only two archbishops, to wit, the primate of Ard Macha and the archbishop of Cashel. And 
those who presided at this council on behalf of the Pope, were Giolla Criost O Conairce, bishop of Lios Mor, 
and head of the Irish monks, as legate, and a cardinal with him, whose name was John Papiron, for the 
purpose of making rules and regulations in Ireland, and for doing a thing which Ireland regarded with 
greater concern that this, to wit, the giving of four pallia. For Ireland thought it enough to have a 
pallium in Ard Macha and a pallium in Cashel, and particularly it was in spite of the church of Ard Macha 
and the church of Dun da Leathghlas that other pallia were given besides one to Ard Macha and one to Cashel, as 
the old book of annals of the church of Cluain Eidneach in Laoighis, which gives a summary of the 
transactions of this council, explains the matter.


Now, when the council met in session, they made praiseworthy regulations and customs on the occasion of 
the giving of these four pallia. Here follow the words of the old book of chronicles which was written in 
Cluain Eidhneach Fionntain in Laoighis.


In the year 1152 from the Incarnation of our Lord Jesus Christ, being a bissextile and embolismal year, a 
famous council was held as Ceanannus in the season of spring about the time of "Laetare Jersualem" Sunday, in 
which Lord John Cardinal Priest of St. Lawrence in Damascus, presiding over many abbots and priors, on 
behalf of the holy apostles Peter and Paul, and of the Apostolic Lord Eugenius, entirely rooted out and 
condemned simony and usury, and commanded by Apostolic authority the payment of tithes. He gave four pallia 
to the four archbishops of Ireland, to wit, to those of Dublin, Cashel, Tuaim and Ard Macha. Moreover, he 
appointed the archbishop of Ard Macha as primate over the other bishops as was meet.


---

p.317




And this Cardinal John, immediately after the council was over, took his departure, and on the ninth of the 
calends of April set sail. The following are the bishops who were present at this council, to wit, Giolla 
Criost O Conairce, bishop of Lios Mor and legate of the Pope in Ireland; Giolla Mac Liag, **comhorba** of Patrick and primate of Ireland; Domhnall O Longargain, archbishop of Munster; 
Greine, bishop of Ath Cliath; Giolla na Naomh Laigneach, bishop of Gleann da Loch; Dunghal O Caolluidhe, 
bishop of Leithglinn; Tostius, bishop of Port Lairge; Domhnall O Foghartaigh, vicar-general to the bishop of 
Osruighe; Fionn, son of Cianan, bishop of Cill Dara; Giolla an Choimdheadh O hArdmhaoil, vicar to the bishop 
of Imleach; Giolla Aodha O Maighin, bishop of Corcach; Mac Ronain, **comhorba** of 
Breanainn, bishop of Ciarraidhe; Torgestius, bishop of Luimneach; Muircheartach O Maoilidhir, bishop of 
Cluain Mic Nois; Maoiliosa O Connachtain, bishop of East Connaught; Ua Rudain, bishop of Luighne; Mac Craith 
O Mugroin, bishop of Conmhaicne; Etras O Miadhchain, bishop of Cluain hIoraird; Tuathal O Connachtaigh, 
bishop of Ui Briuin; Mureadhach O Cobhthaigh, bishop of Cineal Eoghain; Maolpadraig O Banain, bishop of Dal 
nAruidhe; Maoiliosa Mac an Chleirigh Chuirr, bishop of Ulidia. On the day before the Nones of March this 
synod closed in which the bishoprics of Ireland were set in order and determined.


After this council had concluded Domhnall O Longargain, archbishop of Munster, died, and some time after 
this Muircheartach, son of Niall, who was in the sovereignty of Leath Cuinn and of the greater part of 
Ireland at that time, died, having been slain by the men of Fearnmhagh and by O Briuin, as we have said 
above.




---

p.319


XXX.
----


Ruaidhri O Conchubhair assumed the sovereignty of Connaught and the greater part of Leath Cuinn, because 
the king of Oirghiall, the king of Meath and the king of Breithfne submitted to him, and, moreover, he is 
called king of Ireland in the **seanchus**. Still he was only a king with opposition, that is, a king to whose 
possession of the sovereignty of Ireland a great many of the Irish nobles were opposed. And it was while 
Ruaidhri reigned in this manner that the wife of Tighearnan Caoch O Ruairc (Dearbhforgaill was her name, and 
she was daughter to Murchadh Mac Floinn, king of Meath, and not wife of the king of Meath as Cambrensis 
says) sent messengers in secret to Diarmaid Mac Murchadha asking him to come to meet her and take her with 
him as his wife from Tighearnan; and she told the messengers to make known to Diarmaid that Tighearnan had 
gone on a pilgrimage to the cave of Patrick's Purgatory, and that, therefore, he would have an opportunity 
of quietly carrying her with him to Leinster.


There had been indeed an illicit attachment between them for many years previously. As to Diarmaid, when 
this message reached him he went quickly to meet the lady, accompanied by a detachment of mounted men, and 
when they reached where she was, he ordered that she be placed on horseback behind a rider, and upon this 
the woman wept and screamed in pretence, as if Diarmaid were carrying her off by force; and bringing her 
with him in this manner, he returned to Leinster. As to Tighearnan, when he returned to Breithfne and heard 
that it was against her consent his wife was taken from him, he made a complaint of this outrage to Ruaidhri 
O Conchubhair and to his friends in general.




---

p.321


Upon this Ruaidhri made a muster of the men of Connaught, Breithfne, Oirghialla and Meath, and set out 
with a large host to waste Leinster to avenge this evil deed Diarmaid had done.


When Diarmaid heard that Ruaidhri was marching to waste Leinster, he assembled and brought together the 
nobles of Leinster from all sides, and when they came to one place their answer to Diarmaid was that they 
would not go to defend the evil deed he had done, and thereupon many of them deserted him and put themselves 
under the protection of Ruaidhri, and made known to him that Diarmaid before that time had committed many 
acts of injustice and tyranny against them.


As Diarmaid was not strong enough to fight Ruaidhri, the latter set about spoiling the territories of all 
the Leinstermen who sided with Diarmaid; and he went on to Fearna and levelled Diarmaid's house, and broke 
his fortress, and banished him out of Ireland altogether. And Diarmaid went to Henry II., king of England, 
who was then in France; and when he had come into the king's presence, the latter welcomed him and showed 
him much friendship; and when he made known to the king the cause of his visit, the king wrote friendly 
letters to be taken by him to England, in which he gave permission to all who so wished to go with him to 
Ireland to help him to recover his own territory. Diarmaid, on this, bade farewell to the king, and 
proceeding to England arrived at Bristol, and caused his letters to be read there publicly; and he made 
large promises to those who would go with him to Ireland to recover his own territory.


It was there he met Richard Fitz Gilbert, son of earl Stranguell; and he made a compact with him, to wit, 
to give his own daughter, that is, Aoife, daughter of Diarmaid, to wife to him, and with her the inheritance 
of Leinster after his own death, Richard to be obliged to follow him 


---

p.323




to Ireland to recover his territory for him. After they had made a compact on these conditions, Diarmaid 
went to Wales to a prince who was there called Ralph Griffin, who ruled the country under king Henry, and 
made his case known to him. At that time the prince kept in prison a powerful nobleman of great achievements 
called Robert Fitz Stephen, for having disobeyed the king, and there was no relief forthcoming to him unless 
he chose to go to Ireland to aid Mac Murchadha by the strength of his arm in the recovery of his territory. 
And when the bishop of St. David's and Maurice Fitz Gerald heard that Mac Murchadha had visited this prince 
requesting him to free Robert Fitz Stephen from his captivity, they themselves came to request him in like 
manner to set Robert at liberty, and let him go to Ireland with Mac Murchadha. Now that bishop and Robert 
Fitz Stephen and Maurice Fitz Gerald were uterine brothers.


The prince then released Robert on condition that he would follow Mac Murchadha to Ireland the next 
summer. Diarmaid, on the other side, promised Robert Fitz Stephen Loch Garman and the two 
**cantreds** next it, as his property for ever, in return for his coming to help him to fight his enemy; and after this compact was made, Diarmaid bade farewell to these people and proceeded with only a 
small force to Ireland. Having landed in a place where he had many enemies and few friends, he went secretly 
to Fearna Mor Maodhog, putting himself under the protection of the clergy and community of Fearna; and he 
stayed with them sad and wretched during the time that elapsed until the coming of summer.


As to Robert Fitz Stephen he came to fulfil his promise to Mac Murchadha, and the number of the host that 
came with him to Ireland was thirty knights, three score esquires and three hundred foot; and the place 
where they landed was at Cuan an Bhainbh on the south coast of the County 


---

p.325




of Loch Garman in the place which is called Baginbun, and it was then the year of the Lord 1170, and the 
seventh year of the reign of Ruaidhri O Conchubhair. There was also a distinguished knight with Robert Fitz 
Stephen at that time, to wit, Herimont Morti, a knight of the party of the earl of Stranguell, whom he sent 
before him to Ireland to study the country, and when they landed Robert sent word to Diarmaid to make it 
known to him that he had arrived in Ireland.


When Diarmaid heard this he rejoiced, and went to meet them with five hundred warriors; and when they had 
come together they proceeded by agreement to attack Loch Garman with a view to getting possession of it; and 
when they were approaching the town, the burgesses came to the decision of submitting to Diarmaid, and of 
giving him four of the nobles of the town as hostages for their maintaining peace and paying him rent and 
tribute and for their being obedient to him as their lord. It was then that Diarmaid bestowed Loch Garman 
and the two **cantreds** next it on Robert Fitz Stephen, and, moreover, he bestowed the two 
**cantreds** next again to these on Herimont Morti, according to the promise he had made 
them in Wales; and after he had fulfilled this promise Diarmaid assembled his own people and the foreigners 
to one place; and the number of the host that assembled there was three thousand men, counting Gaels and 
foreigners; and they proceeded thence of one accord to plunder and spoil Osruighe; and the king of Osruighe 
at that time was Donnchadh, son of Domhnall Reamhar, an inveterate enemy of Diarmaid, and as they had come 
to waste Osruighe, while Donnchadh could not defend himself, he, with the nobles of his country, decided to 
give Diarmaid hostages for the payment to him of head rent; and thus Diarmaid was prevented from wasting the 
country.


Now when the nobles of Ireland heard of the arrival of Diarmaid and of these foreigners and of all the 
successes 


---

p.327




they had met with, they went to take counsel with Ruaidhri O Conchubhair, king of Connaught, who then held 
the sovereignty of Ireland; and what they agreed upon was to give him an auxiliary force from every province 
of Ireland; and when these forces had assembled in one place Ruaidhri marched with them to Ui Cinnsealaigh 
in the hope of driving Diarmaid and the foreigners from Ireland; and when Ruaidhri went into Leinster, 
Diarmaid and the foreigners, and as many of the Leinstermen as followed him, went into the dark fastnesses 
of the woods near Fearna Mor Maodhog to shield themselves from the great force of Ruaidhri's hosts. But as 
Ruaidhri saw that they were not going to give him battle he sent envoys to Robert Fitz Stephen asking him to 
quit the country, saying that he had neither right nor hereditary claim to be in it. Robert said, in reply 
to the envoys, that he would not desert the lord with whom he had come to Ireland. The envoys returned with 
this answer to Ruaidhri, and when he heard it, and heard also that Mac Murchadha would not on any account 
forsake the foreigners, he resolved to make a sudden attack with all his forces regular and contingent on 
Diarmaid and the foreigners and upset and destroy them.


When the Leinster clergy saw that the country was in danger of being thrown into disorder and destroyed 
by this conflict, they did their best to bring about peace between Ruaidhri and Diarmaid; and these were the 
terms in which this peace was concluded, to wit, Diarmaid to have the province of Leinster which he had 
inherited, and to be obliged to be obedient and faithful to Ruaidhri, as every king of Leinster was bound to 
be to the kings of Ireland, and in pledge for the fulfilling of the terms of this peace Diarmaid gave one of 
his sons named Art to Ruaidhri as a hostage. Moreover Ruaidhri promised to give his own sister to Diarmaid 
to wife; and on these terms they


---

p.329




separated from one another in peace; but Diarmaid promised Ruaidhri not to bring any more of the foreigners 
to Ireland; and soon after this Maurice Fitz Gerald came to Ireland in the beginning of the summer according 
to the promise he had given to Mac Murchadha, and also because of the reward which Mac Murchadha had 
promised to himself and to Robert Fitz Stephen the previous autumn on condition of their coming to Ireland 
to help him to recover his own territory; and the number of the hosts who came with Maurice on that occasion 
was ten knights, thirty esquires and one hundred foot, and the place where they landed was at Loch 
Garman.


XXXI.
-----


When Mac Murchadha and Robert Fitz Stephen heard that Maurice had come to Ireland, they went to meet him 
to Loch Garman; and it was then Mac Murchadha called to mind all the outrages that the people of Ath Cliath 
had committed on himself and on his father before him. Accordingly Mac Murchadha brought together this host 
with a view to marching to plunder Ath Cliath, and he left Robert Fitz Stephen building a fortress in the 
place which is now called Carrick, which is two miles outside of Loch Garman, and Mac Murchadha and Maurice 
Fitz Gerald with the majority of these foreigners proceeded to Fine Ghall, and they plundered and burned 
that country.


Now when the burgesses of Ath Cliath heard that the country round them was plundered and spoiled, they 
took counsel together, and the decision they came to was to send valuables and large presents of gold and 
silver to Mac Murchadha with a view to obtaining peace and a settlement from him, and with these treasures 
they sent him hostages over the walls of the town, and they promised 


---

p.331




to pay Mac Murchadha all claims and dues they owed him up to then.


Now when Mac Murchadha saw that he was succeeding in all his undertakings, he reflected in his mind that 
his ancestors before him possessed the sovereignty of Ireland, to wit, Cathaoir Mor, Conchubhar 
Abhradhruadh, Labhruidh Loingseach, Laoghaire Lorc, and Ughaine Mor and every other king of that race that 
had held the sovereignty of Ireland before him, and he said to himself that the strength or might of all 
these kings to hold Ireland was not greater than his own. Hence Mac Murchadha took Maurice Fitz Gerald and 
Robert Fitz Stephen aside and unfolded to them his design in this matter and asked their advice as to what 
he should do. They answered him with one voice, and said it would be very easy for him to carry out this 
design were he to send envoys to England to ask for more men; however Mac Murchadha asked them to send 
envoys from themselves inviting their kinsmen and friends; and he promised to give his own daughter to wife 
to Maurice Fitz Gerald or to Robert Fitz Stephen, whichever of them would accept her, and his princedom from 
his own death onwards. But neither of them consented to accept her, for both remembered that Mac Murchadha 
had promised that lady and the sovereignty of Leinster with her to the earl of Stranguell in return for his 
bringing with him his forces to recover his patrimony for him; and Maurice and Robert requested Mac 
Murchadha to send a letter to the earl requesting him to come over in fulfilment of the promise he had made 
him in England, ‘and make known to him,’ added they, ‘that thou art ready to fulfil thy promise to 
him, and will give him thy daughter to wife and the sovereignty of Leinster from thy death on; and, 
moreover, as to the four divisions of Ireland that thou dost not possess, make known to him that thou hast 
hopes of their becoming subject and paying rent to thee.’




---

p.333


Mac Murchadha sent envoys and letters to the earl of Stranguell in reference to this affair, and when the 
envoys had come into his presence and he had read the letters, and when, moreover, he had heard of the 
conquests Mac Murchadha and Robert Fitz Stephen and Maurice Fitz Gerald had made in Ireland, he went to 
where the king of England was, and asked leave of him to go and make conquests wherever he liked. But when 
the king understood the mind and intention of the earl, he did not give him full consent, neither did he 
give him a refusal. But the earl went away with the permission he had got, and he got himself and his 
followers ready to go to Ireland, and before he could himself get ready to go on this expedition he sent 
Raymond le Gros, son of William Fitz Gerald, an elder brother of Maurice Fitz Gerald, with an armed party 
before him to Ireland, and on reaching that country the place where he put into port was Dun Domhnaill, four 
miles south of Port Lairge; and according to the chronicle of Stanihurst the number of his followers was ten 
knights and seventy foot. And when they had landed they built a strong embankment of stones and clay in that 
place.


Now when news reached Port Lairge and Maoilseachlainn O Faolain, king of the Deise, that these foreigners 
had arrived in their neighbourhood, they were all seized with hatred and fear of them, and they came to one 
place to take counsel in reference to this matter, and the decision they came to was to attack the strangers 
in the stronghold in which they were, and to slaughter and destroy them.


After this they came (with their forces) to one place, and their number was three thousand men when going 
to oppose these foreigners. When Raymond saw them approach him he went out quickly and unwisely with his 
small party to meet that large host with a view to


---

p.335




engaging them in battle and conflict. But when he saw that he was not strong enough to fight them, he 
retreated to the fortress he had himself raised. When the Gaels saw the foreigners retreating, they followed 
them vehemently and boldly to the fortress. But when Raymond de la Gros observed that his enemy were boldly 
in pursuit of him he turned on them and made indescribable slaughter upon that great host of Gaels, so that 
apart from all he slew of them he maimed and wounded five hundred of them on the spot.


Now after the feast of St. Bartholomew in the succeeding autumn in the year of the Lord 1170, the earl of 
Stranguell came to Ireland, and the full number of the host that came with him was two hundred knights and a 
thousand esquires and bowmen and men of valour of every description; and it was at Port Lairge they put into 
port. And when the news spread over the country that the earl of Stranguell had come to Ireland, Mac 
Murchadha and the nobles of Leinster and Robert Fitz Stephen and Maurice Fitz Gerald and Raymond de la Gros 
came to meet and join the earl with joy and in high spirits, and on the morrow they went by common consent 
to capture Port Lairge; and when they arrived at the town they made a united assault on it with a view to 
capturing it, and having it in their power; and notwithstanding the evils and hardships endured by the 
townspeople in maintaining and defending themselves, they sprang on them over the walls of the town, and 
slew of the townspeople as many as they came upon, and they captured Maoilseachlainn O Faolain, king of the 
Deise, and it was through Mac Murchadha's intercession that his life was spared.


Now Mac Murchadha took his daughter, whose name was Aoife, to meet the earl at this time, and she was 
married to him, and when they had made and ratified that match on both sides, the earl left a strong 
garrison in Port Lairge 


---

p.337




and marched at once with his host against Ath Cliath; and there was no man on earth whom the people of Ath 
Cliath hated more to see coming towards them than Mac Murchadha accompanied by these foreigners; and Mac 
Murchadha on his part was full of rage and enmity against them. For it was they who slew his father; and 
they buried him with dishonour and contempt, and buried a dead dog in the same grave with him as an insult 
to him. When the people of Ath Cliath saw these foreigners and the strength of Leinster, a large army, 
making towards them, they were seized with fear and alarm, and sent an envoy, to wit, Labhras O Tuathail, 
archbishop of Ath Cliath, to the earl to request peace and a settlement from him. And the archbishop 
promised the earl gifts and hostages from the people of Ath Cliath in consideration of their obtaining peace 
and protection.


But while the settlement was being made between them, Raymond de la Gros and Myles Cogan, with a company 
of young knights, were on the other side of the town, and they found an opportunity of breaking and gapping 
the walls of the town, and they entered the town suddenly, and there slew every person they laid hold of. 
But when the foreigners and Mac Murchadha had thus captured Ath Cliath, they remained in it only a short 
time, and the earl left Myles Cogan and a company of men to hold the town. Now there were enmity and ill 
will between O Ruairc, king of Breithfne, and Mac Murchadha, and the latter took this great host of 
foreigners and Gaels to Breithfne, and they spoiled and burned the country and gained great advantages over 
O Ruairc and over all whom they fell in with in Ireland.




---

p.339


XXXII.
------


When Ruaidhri, son of Toirrdhealbhach O Conchubhair king of Connaught and of the greater part of Ireland, 
saw that Mac Murchadha had broken the peace that had up to then existed between them, he sent envoys to him 
to reproach him for violating the terms of peace which had been agreed on between them, by his having 
brought over these foreigners without his own consent or advice. And when the envoys came into the presence 
of Mac Murchadha they said: ‘Now we know,’ said they, ‘that thou hast neither regard nor respect for 
thine oaths, nor for thy son whom thou didst give as a hostage for the maintenance of peace; and the king of 
Connaught, Ruaidhri O Conchubhair, tells thee that if thou wilt not dismiss those foreigners who are with 
thee, he will send thee thy son's head, and that he will not rest till he has sent thyself a second time to 
England to banishment and exile.’ Mac Murchadha replied that he would not dismiss the foreigners on the 
advice of Ruaidhri, and added that he would bring over more foreigners in addition to them, and he would not 
make peace or agreement with anyone of the Gaels until all Ireland should be his. The envoys returned to 
Ruaidhri and made known to him Mac Murchadha's answer to them. When Ruaidhri heard what Mac Murchadha had 
said he became enraged.


But now the fame and renown of these foreigners spread over all Ireland, so that the men of Ireland 
conceived a horror and dread of them. And tidings from the earl and from these foreigners reached England, 
and when the king of England heard these tidings he issued a command that neither ship nor bark from any 
land belonging to himself should go to Ireland, and that no intercourse or exchange should be carried on 
with that company; and he also commanded those who had gone from England to Ireland to


---

p.341




return under penalty of being disinherited for ever. When the earl saw that his followers were obliged to 
leave him by reason of the king's proclamation, he and they took counsel together on this matter, and what 
they resolved upon was to send Raymond de la Gros to the king of England, to point out to him that it was by 
his own will and consent that the earl and the foreigners had come to Ireland to help one who had promised 
obedience and vassalage to him, to wit, Diarmaid Mac Murchadha, king of Leinster; and that whatever conquest 
they had made in Ireland and whatever benefits they had derived from Mac Murchadha they desired to hold 
subject to his will. Raymond conveyed this statement to the king of England, and it was in Gascony he was at that time; and it 
was in that year that Thomas, archbishop of Canterbury, was murdered the fifth day of Christmas, and the 
year of the Lord at that time was 1171; and it was at the Bealltaine of that year, *i.e. the 
ensuing Bealltaine* that Mac Murchadha, that is Diarmaid, king of Leinster, died; and he was buried at 
Fearna Mor Mhaodhog.


As to the king, he returned to England, and when he had arrived there, he sent one of his people, a 
knight named Herimont Morti, together with Raymond de la Gros, to Ireland with letters to the earl of 
Stranguell, commanding the earl to repair to England without delay; and when they had arrived in Ireland, 
Herimont delivered his message to the earl, and the earl together with Herimont proceeded at once to 
England, and when he had come into the king's presence he promised that he would give Ath Cliath and Port 
Lairge and the ports of Leinster to him and to his heirs after him, the remainder of the province of 
Leinster to go to the earl himself and to his descendants.


Now when they had concluded this treaty between them, the king proceeded to Ireland with a numerous host 
and put into port at Port Lairge.There came with 


---

p.343




him five hundred knights, as well as a large number of horsemen and foot-soldiers, the year of the Lord then 
being 1172. Now the king remained at Port Lairge after this, and the foreign nobles who were in Ireland 
before him and the burgesses of Loch Garman came to do him homage and pay him respect. There also came into 
his presence the king of Corcach, to wit, Diarmaid Mor Mac Carrthaigh, and he pledged himself to submit to 
him and become his vassal. The king went thence to Cashel and Domhnall O Briain, king of Limerick, went 
thither to meet him, and submitted to him, as Mac Carrthaigh had done.


After this the king of England placed a garrison of his own in Corcach and in Luimneach. After this the 
Munster nobles came to him and did him homage and paid him respect in like manner. The king returned to Port 
Lairge, and the king of Osruighe came to him there and did him homage and paid him respect as the other 
king's had already done. The king proceeded thence to the town of Ath Cliath, and the Gaels of Leinster came 
to him there to do him homage and pay him respect.


Now when Ruaidhri O Conchubhair, king of Connaught and of Ireland, heard that his provincial king's and 
those who paid him rent and tribute, and those to whom he himself gave wages and stipends, had put 
themselves under the protection of the king of England he judged in his own mind that it would be less an 
indignity for him to submit to the king of England voluntarily than to do so against his will. And then the 
king sent two of his people to meet Ruaidhri O Conchubhair, and those who went were Hugo de Lacy and William 
Mac Aldelmel. Ruaidhri went to meet them to the bank of the Sionainn, and he made peace and friendly 
alliance with the king in their presence, and he pledged himself to be obedient to him and to pay him 
respect. Murchadh Mac Floinn, king of Meath, also came to him and gave himself up to him as 


---

p.345




all the others had done; so that there was no king or leader or lord in Ireland who did not at that time 
make submission to the king of England and acknowledge him as their lord.


On the setting in of winter after this, the weather became very cold and dreadfully inclement, so that 
neither ship nor bark could come to Ireland with news from England to the king until the middle month of 
spring had come. After this ships came to Ireland, and they brought to the king news from England and from 
France which did not please him, and above all he was informed that the Pope had sent two cardinals to 
England to inquire how Thomas of Canterbury had been done to death, and they had said that if the king did 
not appear in person to give them satisfaction for this murder, they would subject to *an interdict* both himself and every land that sided with him. 
Though this was sad news to the king, sadder still for him was the news that reached him afterwards from his 
son, namely, that his eldest son had taken possession of the English crown in the hope of being able to hold 
it in spite of his father. An indescribable sadness seized on the king by reason of these tidings. Still he 
was more affected by the murder of St. Thomas than by all that his children and his people had done against 
him. Accordingly he summoned to him the nobles of his people to take counsel with them, and he made known to 
them every danger that hung over him, and the decision they came to
 was that he should send a large party of his followers before him to England, himself to follow them 
speedily. They acted accordingly, and the king remained behind to garrison and fortify Ireland.


And when the king thought it time to go to England he left a party to hold the country, to wit, Hugo de 
Lacy in Meath, together with twenty knights, and, moreover, he granted the fee simple of Meath to Hugo and 
to his 


---

p.347




descendants after him. He also entrusted the keeping of the town of Ath Cliath to Robert Fitz Stephen and 
Maurice Fitz Gerald, who had with them forty knights and their dependants. In the same way he left William 
Fitz Aldelmel and Philip de Hastings and Philip de Brus with twenty knights at Loch Garman to guard the 
town. He also left at Port Lairge Humphrey Bolum and Hugo de Gandeville and Robert Fitz Bearnard with forty 
knights. After this the king proceeded to England, and when he had come into the presence of the cardinals 
he said that he would grant them anything they desired as an **eiric** for the death of St. Thomas though he was not in the secret of his taking 
off, and for making peace between himself and the king of France with whom he was in conflict at that 
time.


XXXIII.
-------


If thou desirest to be informed, O reader, why Diarmaid Mac Murchadha, king of Leinster, went to the king 
of England to France to complain and protest against his expulsion from Ireland, instead of protesting to 
the king of France or to some other king, know that it was because Donnchadh, son of Brian Boraimhe, and the 
real nobles of Ireland were at enmity with one another concerning the mastery of Ireland from the time of 
Brian to that of Donnchadh, and hence they bestowed with one accord the possession of Ireland on Urbanus, 
the second Pope of that name, in the year of the Lord 1092; and the Pope of Rome had possession of and 
authority and sovereignty over Ireland from that time to the time when Adrianus, the fourth Pope of that 
name, assumed the successorship of Peter in the year of the Lord 1154; and this Pope was an Englishman, and 
his baptismal name was Nicholas Breakespeare; and Stow says in his Chronicle that this Pope bestowed the 
kingdom of Ireland on Henry II., king of England, 


---

p.349




in the first year of the said Henry's reign, in the year of the Lord 1155. And the same author says that the 
conditions on which the Pope bestowed Ireland on the king of England were that he should build up the Faith 
which had fallen to the ground in that country, and that he should correct the evil habits of the people, 
and that he should maintain and protect every privilege and every termon land that was in the country, and 
that the king should pay Peter's penny every year for every house in Ireland to the Pope. When Henry II received this gift in writing from the Pope he sent John, bishop of Salisbury, with this authorization to 
Ireland, and he landed at Port Lairge, and when the Irish clergy heard that he had come with the 
authorization of the Pope they came from all sides to meet him, and when they had come to one place, John, 
the bishop we have referred to, read the granting of Ireland by the Pope to Henry II and to his 
descendants, and the conditions laid down in the document; and when the clergy had considered the conditions 
they all agreed to them, and they gave their assent then with their signatures in writing to this John; and 
he returned to England to the king, and the king sent him to the Pope with this document, and when the Pope 
saw the assent of the Irish clergy he sent a ring as a token of the possession of Ireland to Henry II.


Bellarminus agrees with the above in his chronicle where he says: *Adrianus, the fourth Pope of that name, a native of England, a wise and pious man, bestowed the island of Ireland on Henry II, king of 
England, on condition that he would plant virtues in that island and root out vices, that he should see that 
Peter's penny was paid every year from each house, and that he should preserve the rights of the Church 
inviolate there. The bull in which these things are is to be seen in the twelfth book of the annals of 
Cardinal Baronius. {Adrianus Papa quartus natione Anglus vir sapiens et pius Hiberniam insulam 
Henrico secundo regi Anglorum concessit ea conditione ut in ea insula virtutes plantaret et vitia
eradicaret; ut a singulis domibus quottannis denarium Sancto Petro pendi curaret, et iura ecclesiastica illibata servaret. Extat Diploma Tom. 12 Annalium Cardinalis Baronii.}’’*




---

p.351


The English chronicle of Stanihurst agrees with this where it says that Henry II procured a bull from 
Pope Adrianus in which he commanded the clergy and the real nobles of all Ireland, under penalty of 
excommunication, to pay homage and be obedient to Henry, king of England, under pretext of his reforming the 
religion of the country and improving the habits of the people; and this bull came from the king to Ireland 
and was read at a general assembly of genuine nobles and clerics at Cashel. We read also in the same author 
that Alexander, the third Pope of that name, sent a cardinal called Vivianus to Ireland to make known to the 
Irish the grant of Ireland to the king of England and to his descendants, which he himself and the Pope who 
preceded him had made on condition that he and every Pope who should come after him would get out of Ireland 
each succeeding year Peter's penny for every household in the country.


Judge, O reader, that the reason why Diarmaid Mac Murchadha went to meet the king of England to France 
instead of going to meet any other king was because of the grant the Pope had previously made of Ireland to 
the king of England, and for that reason that it was the king of England who had authority over Ireland from 
the Pope and that it was his duty to demand amends or satisfaction for the injury done to Mac Murchadha.


Here I must express astonishment at a condition in the bull of Pope Adrianus in which he granted Ireland 
to Henry II. Here is the condition according to Stow's Chronicle, to wit, that Henry II was bound to reform 
and build up the Catholic Faith which had fallen down in Ireland. For it is not likely that the Pope would 
put that condition in his bull unless some party had given him to understand that the Faith had lapsed in 
Ireland. But whatever party told him this told a lie. For it is plain that the faith Patrick brought to 
Ireland did not lapse up to 


---

p.353




this time, and many foreign authors of weight bear testimony to this from age to age. For although, 
according to Beda in the History of Sacsa, there was a contention between some of the Irish clergy and the 
clergy of Sacsa concerning Easter, and, moreover, though some of the Irish were stained with the Pelagian 
heresy, still the greater number of the Irish were free from either stain; and as regards the Faith, from 
the time of Brian down to the Norman Invasion, it is clear that it was alive unimpaired in Ireland, and 
hence that those who informed the Pope that it had lapsed in Ireland when he bestowed that country on Henry 
II. lied. In testimony of this are the examples which we shall set down here.


In the first place it is plain, from the number of genuine Irish nobles who, towards the close of their 
lives, betook themselves to the principal churches of Ireland to end their days in penance, from the time of 
Brian to the Norman Invasion, that the Faith was then alive in Ireland. Here follow some of these, to wit, 
Flaithbheartach O Neill, who was called Flaithbheartach of the Pilgrim's Staff; he first began to do penance 
in Ireland, and after that he went to Rome on a pilgrimage in the year of the Lord 1073; and Donnchadh, son 
of Brian Boraimhe, who went on a pilgrimage to Rome and who ended his days in penance in the monastery of 
St. Stephen; and Tadhg, son of Lorcan, king of Ui Cinnsealaigh, who ended his days in penance in the church 
of Caomhghin in Gleann da Loch; and Cathal, son of Ruaidhri, king of west Connaught, who closed his days in 
penance at Ard Macha; and Muircheartach O Briain, king of Leath Mogha, and of the greater part of all 
Ireland, who went to Ard Macha and spent five years in penance there until his death; and so it was with 
many others of the true nobles of Ireland who closed their days in piety and as Catholics from the time of 
Brian to the Norman Invasion. Hence did those persons lie who told 


---

p.355




Pope Adrianus IV. that the Catholic Faith was not alive or in a state of preservation in Ireland before the 
coming hither of the Normans.


The second proof I advance to show that the Catholic Faith was in a state of preservation before the 
Normans came to Ireland is that there were many abbeys built there shortly before the Normans came, and that 
the Gaelic nobles built them. In the first place Maoilseachlainn, king of Meath and of all Ireland, built 
the abbey of St. Mary in the town of Ath Cliath, in the year of the Lord 1139. Donnchadh O Cearbhaill, king 
of Oirghialla, at the instance of Malachias, bishop of Dun, built the abbey of Meillifont in the county of 
Lughmhagh in the year of the Lord 1142. St. Malacias, bishop of Dun, built the abbey of Iobhar Cinn Tragha 
in the county of Dun, the year of the Lord then being 1144. The year of the Lord when the abbey of Buill was 
built was 1161. Diarmaid Mac Murchadha, king of Leinster, built the abbey of the Bealach alias Baltinglas in the year of the Lord 1151. The descendants of Maoilseachlainn, king 
of Meath, built the abbey of Bectif alias De Beatitudine in Meath in the year of the 
Lord 1151. The year of the Lord when the abbey of Maigh in the county of Luimneach was built was 1151. The 
year of the Lord when the abbey of O Dorna in the county of Ciarraidhe was built was 1154. Domhnall O 
Briain, king of Luimneach, built the abbey of the Holy Cross in the county of Tiobrad Arann in the year of 
the Lord 1169; and the said Domhnall O Briain built seventeen other abbeys in Munster. The year of the Lord 
when the abbey of Feara Muighe in the county of Corcach was built was 1170; and in that period there were 
built many temples and abbeys in Ireland which we do not mention here. Hence it is plain that the Catholic 
Faith was alive in Ireland just before the Normans came hither.




---

p.357


The third proof that the Faith was alive in Ireland just before the Normans came hither is that we read 
in the ancient annals of Ireland that, from the time of Donnchadh, son of Brian, to the coming of the 
Normans, the prelates and nobles of Ireland organized three national councils in Ireland in which laws 
pertaining to the clergy and laity were laid down and approved.


The first council was held at Fiadh Mic nAonghusa the first year of the reign of Muircheartach O Briain 
in the year of the Lord 1105, and in it laws and regulations were laid down, and religion was reformed in 
Ireland.


Another national council was convened in Ireland the fifth year of the reign of the said Muircheartach, 
when the nobles and the ecclesiastics of Ireland came together at Raith Breasal, in the year of the Lord 
1110, where sees or dioceses and their boundaries were regulated, and a fixed number of bishops placed over 
them, as we have said.


The third national council held in Ireland by the clergy and the genuine nobles of Ireland was at 
Ceanannus na Midhe, at which were Christianus, that is Giolla Criost O Conaire, bishop of Lios Mor, the 
Pope's legate in Ireland at the time, together with a cardinal called John Papiron, for the purpose of 
presenting four pallia to four archbishops in Ireland and of putting down simony and usury, and enforcing 
the payment of tithes, and of putting down robbery and rape and bad morals and evils of every kind 
besides.




---

p.359


XXXIV.
------


It is plain from the examples given above that the Catholic Faith was alive in Ireland just before the 
Normans came hither; and as regards the bad morals of the Gaels before the Normans came amongst them, it is 
certain that there came with the Norman Invasion five leaders who did more evil deeds than all the Gaels 
that lived from the time of Brian to the Norman Invasion as regards the plundering of churches and clerics, 
bloody deeds of treachery and violent tyranny. Here are their names, the earl of Stranguell, Robert Fitz 
Stephen, Hugo de Lacy, John de Courcy and William Fitz Aldelmel. It will be easy to see the truth of this 
from what we shall hereafter state, and in particular from the chronicle of Stanihurst, and moreover from 
the fact that the majority of these persons on account of their own misdeeds left behind them no son to take 
up his father's inheritance.


As a proof of this take the earl of Stranguell, Robert Fitz Stephen, John de Courcy and some other 
leaders whom we shall not mention here who came in the beginning of the conquest. And as regards Richard 
Stranguell, according to Stanihurst's chronicle after he had committed many robberies and sacrileges against 
the laity and the church, he died in Ath Cliath seven years after he had come to Ireland, in the year of the 
Lord 1177; and the only progenny by Aoife, daughter of Diarmaid, that survived him was one daughter called 
Isabella, and that daughter was married to William Maruscal, and she bore him five sons and five daughters, 
and the sons died one after another, no offspring or heir remaining after any of them, and the daughters 
were married to a number 


---

p.361




of English nobles, and in that way the earl did not leave a son to become his heir.


As regards Hugo de Lacy, when he received the government of Meath from Henry II he set to slay and 
behead the clann Colmain and the nobles of Meath, as many of them as he could lay hold on, and as he was 
building a fortified residence in Durmhagh in Meath a young nobleman of Meath came in the guise of a clown 
to do work for him, and he slew Hugo. The chronicle of Stanihurst says that the said Hugo was a lustful and 
very avaricious man. It also states that young Hugo his son and John de Courcy set about committing many 
robberies and murders and deeds of violence upon the people of Meath to avenge the death of Hugo. The same 
chronicle says that William Fitz Aldelmel was deceitful, treacherous and of evil disposition, and also 
relates how he took by treachery from the children of Maurice Fitz Gerald manors which were their own 
property, and adds that he was ever envious of Maurice and of his children. Moreover, we read in the ancient 
annals of Ireland that when William Fitz Aldelmel was ruling in Luimneach on behalf of the king of England 
there arose a confiict between two brothers of the family of Conchubhar for the sovereignty of Connaught, to 
wit, Cathal Croibhdhearg and Cathal Carrach; and William took the part of Cathal Carrach against Cathal 
Croibhdhearg; and John de Courcy took the other Cathal's part. This disagreement between the two Cathals was 
fed on both sides by William and by John until the entire country was destroyed and plundered by them, and 
till many of the nobles of Connaught were beheaded in that conflict as a result of that disagreement, and a 
battle took place between the two Cathals, the foreigners helping them on either side, and Cathal Carrach 
and his followers were defeated and himself was slain in that conflict.


After that William Fitz Aldelmel built a castle in 


---

p.363




Milioc Ui Mhadagain, and left a large garrison there and went himself to Luimneach. Cathal Croibhdhearg 
encamped in front of them to lay siege to them; but the garrison escaped by night and followed William to 
Luimneach; and Cathal Croibhdhearg razed the castle of Milioc. After this William Fitz Aldelmel got 
together a host and invaded Connaught, and spoiled and plundered churches and country districts, and made 
dreadful slaughter on all he encountered of them, so that the Connaught clergy cursed him, as we read in the 
ancient annals of Ireland which were written about three hundred years ago in a chief book of
seanchus which 
was called the Leabhar Breac of Mac Aodhagain. And in the same book we read that God, on account of his 
misdeeds, in a miraculous manner, inflicted a foul deformity and an incurable disease on him through which 
he died a loathsome death, and that he received neither Extreme Unction nor Penance, and that he was not 
buried in any churchyard but in a deserted grange.


After this a quarrel commenced between John de Courcy and young Hugo de Lacy, and many of the men of 
Ulster and of Meath fell in the conflict, and both these regions were plundered and spoiled by reason of 
their quarrel. And the end of this quarrel was that John de Courcy was treacherously taken prisoner by young 
Hugo de Lacy and that he was delivered into the hands of the Normans; and Hugo de Lacy undertook to prefer a 
charge of treason against him. He was sent as a prisoner to England, where he was for a time in captivity. 
The king granted him a pardon after that, and gave him leave to return to Ireland, and he went to sea to 
proceed to Ireland, when a storm arose against him and he was put back to land, and so it befell him fourteen 
times, putting out to sea and being put back again to England, according to Stanihurst's chronicle; and the 
fifteenth time he went to sea the storm drove him to France, and he died in that country.




---

p.365


We read in the same narrative that a nobleman of the family of John de Courcy who dwelt in Ireland was 
slain by young Hugo de Lacy and by Walter de Lacy his brother, so that many quarrels and conflicts arose 
between the nobleman's friends and the sons of Hugo de Lacy to whom we have referred, so that king John was 
forced to go with a great host of foreigners and Gaels to Meath to chastise these sons. And when they heard 
this they proceeded to Carraig Fhearghusa, and the king pursued them thither, and they took ship there and 
fled to France, and both went in disguise as two gardeners to work in the garden of an abbot in the abbey of 
S. Taurin in Normandy, and they passed some time in that disguise, remaining concealed; and some time 
afterwards they made their secret known to the abbot and asked him to beseech the king of England to make 
peace with them and forgive them; and the abbot obtained this for them, and they came to Ireland under these 
circumstances, the king having restored them to their rank and to their lands; and king John died after this 
in the year of the Lord 1216.


After this also in the time of Henry III there arose a great war between young Hugo de Lacy and William 
Maruscal, and they destroyed all Meath, and many Gaels fell on either side helping them. A great war also 
took place between Myler and Geoffrey Moireis and William Maruscal; and many men of Leinster and Munster 
were destroyed between them on either side.


**Hanmer** says in his narrative that William Maruscal was cursed by the bishop of Fearna for his having taken from him two manors which he possessed as his private property; and, having been excommunicated, he 
died in England; and since his children did not wish to restore that property the five sons died one after 
another, none of them having left an heir. And the above-mentioned Myler went to Cluain Mic Nois with a 
numerous host, where they encamped twelve nights, and they plundered the 


---

p.367




town, carrying off cattle and food, and also they plundered its temples and churches.


When indeed the Gaels observed the tyranny and injustice, the spoliation and sacrilege the people I have 
referred to had committed, and also how Lios Mor with its termon lands was plundered by Herimont Morti and 
by Raymond de la Gros, according to Stanihurst's chronicle, although the said Herveus or Herimont donned a 
monk's habit and built the abbey of Dun Broith in the county of Loch Garman in the year of the Lord 1179 to 
expiate the evil he had done in Ireland, and in like manner how William Fitz Aldelmel plundered the church 
of Inis Cathach and its termon lands, as well as many other churches, and, moreover, that what these same 
Normans, through the excess of vanity, pride and haughtiness that had grown up in them, paid attention to, 
was to keep up constant dissension among themselves and to destroy and waste the Gaels between each of their 
pairs of factions, and that they had no mind, as the Gaels thought, to reform religion or to correct morals 
in Ireland,—observing these things the Gaels thought to rid themselves of the oppression of these 
people. And accordingly a body of Gaelic nobles went to the house of Conchubhar of Maonmhagh, king of 
Connaught, who dwelt at Dun Leogha in Ui Maine, to make him ruler over them.


First Domhnall O Briain, king of Luimneach, and Ruaidhri Mac Duinnsleibhe, king of Ulidia, and Domhnall 
Mac Carrthaigh, king of Desmond, Maoilseachlainn Beag, king of Meath, and O Ruairc, king of Ui Briuin and 
Conmhaicne, went to his house, and whatever the counsel they adopted, Conchubhar was fatefully slain before 
they had put it into execution.


It is plain from the facts we have stated above, that it was owing to tyranny and wrong and the want of 
fulfilling their own law on the part of the Norman leaders in Ireland that there was so much resistance on 


---

p.369




the part of the Gaels to the Norman yoke. For I do not think there is a race in Europe who would be more 
obedient to law than the Irish if the law were justly administered to them. And this is the testimony which 
John Davies gives of them in the last page of the first book which he has written on Ireland. Thus does he 
speak: *There is no nation under the sun that love equal and indifferent iustice better than the Irish or will rest better satisfied with the execution thereof, although it be against themselves, provided they have the protection and benefit of the law when upon just occasion they do desire it. {There is noe 
nation of people under the sunn that doeth love equall and indifferent iustice better than the Irish, or 
will rest better satisfied with the execution thereof, although it be against themselves, soe as they maie have the protection and benefitt of the lawe when uppon iust occation they doe desire it.}’’*


From the testimony of this author it is to be inferred that it was not through evil disposition on the 
part of the Irish that they often rebelled against the law, but through the rulers often failing to 
administer the law justly to them.


Other leaders came to Ireland in the beginning of the Norman Invasion, besides the five we have named 
above, who did not commit the deeds of treachery that the said five committed, and who did much good in 
Ireland by building churches and abbeys and giving church lands to clerics for their support, together with 
many other good deeds besides, and God gave them as a return for this that there are many descendants after 
them at this day in Ireland, to wit, the Gearaltaigh and the Burcaigh, the Builtearaigh and the Barraigh, 
the Cursaigh and the Roistigh, the Puerigh and the Grasaigh, and the Prionndarghasaigh, the Pleimonnaigh, 
the Puirsealaigh and the Priosdunaigh, the Noinnsionnaigh and the Breathnaigh, the Toibinigh and the 
Suirtealaigh and the Bloinnsinigh, the clann Feorais, the Conndunaigh, the Cantualaigh, the Deibhriusaigh, 
the Dairsidhigh, the Diolmhainigh, the Easmontaigh, the Leisigh, the Brunaigh and the Keitinnigh, and many 
other descendants of the Norman nobles who sprang from other leaders
whom we shall not name here.


The END