

#The Genealogies, Tribes, and Customs of Hy-Fiachrach, commonly called O'Dowda's Country


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Genealogies, Tribes, and Customs of Hy-Fiachrach, commonly called O'Dowda's Country
=======================================================================================


Author: Duald Mac Firbis
------------------------


### File Description

John O'DonovanElectronic edition compiled by Beatrix Färber

Proof corrections by Janet Crawford, Beatrix Färber

 1. First draft.Extent of text: 163495 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T105008Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript Sources**2. Dublin, Royal Irish Academy MS 535, olim 23 P 2 olim Book of Lecan. For further details see Kathleen Mulchrone, T. F. O'Rahilly et al. (eds.), Catalogue of Irish Manuscripts in the Royal Irish Academy (Dublin 1926–70) fasc. 13, 1551–1610. This vellum MS was complied for Giolla Iosa Mór Mhic Fhir Bhisigh before his death in A.D. 1418. *Digital images of the Book of Lecan can be viewed on the website of the ISOS Project* (http://www.isos.dias.ie/english/index.html).
3. Earl of Roden's Library (i. e. Robert Jocelyn (1788–1870) third earl of Roden).
4. RIA MS 23 P 2, (The Book of Lecan), is available in digitized form on ISOS.
**Internet resources**2. The printed text on which this edition is based is available at http://www. archive.org.
3. The LOCUS Project, UCC (http://www.ucc.ie/locus/).
4. Hogan's Onomasticum online (http://publish.ucc.ie/doi/locus).
5. http://www.logainm.ie (the website of the Irish Placenames Commission).
6. Dr Katherine Simms's Bardic Poetry Database hosted on the DIAS website (http://bardic.celt.dias.ie/).
**Edition**2. See under 'The edition used in the digital edition'.
**Literature, including works mentioned by John O'Donovan:**2. Johann Böhm [Bohemus] (=Joannes Auban), Omnium gentium mores, leges et ritus (=De Moribus gentium), 3 volumes (Augsburg 1520, often reprinted).
3. Richard Verstegan (=Verstegen), A Restitution of Decayed Intelligence in Antiquities concerning the most noble and renowned English Nation (Antwerp 1605).
4. James Ussher, Antiquitates et Primordia Britannicarum Ecclesiarum (1639).
5. John Colgan, Acta Sanctorum Hiberniae (Leuven (=Louvain) 1645).
6. John Colgan, Acta Triadis Thaumaturgae, seu Divorum Patricii, Columbae et Brigidae (Leuven (=Louvain) 1647).
7. David Comyn and Patrick S. Dinneen (eds), Foras Feasa ar Éirinn le Seathrún Céitinn, D.D. The History of Ireland by Geoffrey Keating, D.D., Books I and II. Irish Texts Society, vols 4, 8, 9 (London 1902–1914).
8. Richard Cox, Hibernia Anglicana; or the History of Ireland from the Conquest thereof by the English to this present Time. With an introductory Discourse touching the Ancient State of that Kingdom; and a new and Exact Map of the same, 2 vols. (London: H. Clark and Joseph Watts, 1689–90).
9. Walter Harris (ed), The whole works of Sir James Ware concerning Ireland (Dublin 1739–64).
10. James Ware, The history of the writers of Ireland in two books, tr. & rev. by Walter Harris (2 vols, Dublin 1746), vol. 2, 145–57.
11. Charles O'Conor of Belanagare, Dissertations on the Antient History of Ireland (Dublin 1753).
12. Charles Smith, The Ancient And Present State of the County and City of Cork, 2 volumes (Dublin 1774). Available online at http://www.askaboutireland.ie/reading-room/digital-book-collection/digital-books-by-county/cork-county-1/smith-the-ancient-and-pre/.
13. Gorges Edmond Howard, A Treatise on the Rules and Practice of the Equity side of the Exchequer in Ireland, with the several Statutes relative thereto, as also several Adjudged Cases on the Practice in Courts of Equity both in England and Ireland,with the Reasons and Origin thereof, in many instances as they arose from the Civil Law of the Romans, or the Canon and Feudal Laws, 2 vols.(Dublin 1760).
14. Thomas Burke (De Burgo), Hibernia Dominicana: sive historia provinciae Hiberniae Ordinis Praedicatorum [...] (Coloniae Agrippinae (= Cologne) 1762).
15. John Lodge, The Peerage of Ireland, 4 volumes (London 1754).
16. James Cowles Prichard, Ethnography of the Celtic Race (London 1817).
17. John O'Conor of Belanagare, Rerum Hibernicarum Scriptores (London 1814–1826).
18. Sir Richard Musgrave, Memoirs of the Different Rebellions in Ireland, from the Arrival of the English (Dublin 1801).
19. William Shaw Mason, A statistical account, or parochial survey of Ireland: drawn up from the communications of the clergy, Vol. 2 (Dublin 1816).
20. John Bernard Trotter, Walks through Ireland in the years 1812, 1814, and 1817 (London: Sir Richard Phillips & Co., 1819).
21. Edward O'Reilly, A Chronological Account of Nearly Four Hundred Irish Writers (...) with a descriptive catalogue (...) (Dublin: Iberno-Celtic Society 1820).
22. John Lanigan, An ecclesiastical history of Ireland, from the first introduction of Christianity among the Irish, to the beginning of the thirteenth century, compiled from the works of the most esteemed authors (...) who have written and published on matters connected with the Irish church; and from Irish annals and other authentic documents still existing in manuscript (Dublin 1829).
23. John Collins of Myross, pedigree of the late General Richard O'Donovan of Bawnlahan (unpublished manuscript?)
24. John Collins of Myross, (John O'Cullane), Soliloquy in Timoleague Abbey, or 'The Mourner's Soliloquy in the Ruined Abbey of Timoleague', published, with translation by Thomas Furlong, in: James Hardiman's *Irish Minstrelsy*, vol. ii. p. 235. (The Irish version was edited by T.F. O'Rahilly, Measgra Dánta, Miscellaneous Irish Poems, Cork 1927, 158–161; 212–13. CELT is indebted for this reference to Prof. Seán Ó Coileáin, UCC.)
25. Patrick Knight, Erris in the Irish highlands and the Atlantic Railway (Dublin: M. Keene 1836).
26. Samuel Lewis, Topographical Dictionary of Ireland (London 1837) (available online at http://www.libraryireland.com/topog/index.php).
27. P. Louis Lainé, Généalogie de la Maison de McCarthy: Anciennement Souveraine des deux Momonies ou de l'Irlande méridionale (...) publié dans le cinquième volume des Archives généalogiques et historiques de la Noblesse de France (Paris 1839).
28. George Petrie and John O'Donovan, 'On the History and Antiquities of Tara Hill', Transactions of the Royal Irish Academy, 18 (1839) 25–232.
29. John O'Donovan (ed), The Banquet of Dun na nGedh and the Battle of Magh Rath [Fled Dúin na nGédh; Cath Maighe Rath] (Dublin 1842).
30. John O'Donovan (ed. and trans.), The Tribes and Customs of Hy-Many, commonly called O'Kelly's Country, from the Book of Lecan with translation and notes and a map of Hy-Many (Dublin 1843; reprinted by Tower Books, Cork 1976; reprinted by Irish Genealogical Foundation, Kansas City, Missouri, c. 1992).
31. George Petrie, The Ecclesiastical Architecture of Ireland anterior to the Anglo-Norman invasion, comprising an essay on the origin and uses of the Round Towers of Ireland, Transactions of the Royal Irish Academy 20 (Hodges & Smith: Dublin 1845).
32. John O'Donovan (ed. and trans.), The genealogy of Corca Laidhe, in: Miscellany of the Celtic Society, 1 (Dublin 1849) (Available on CELT).
33. Thomas Moore, The history of Ireland, 4 vols. (London 1835–1846).
34. John O'Donovan (ed. and trans.), Annala Rioghachta Eireann: Annals of the kingdom of Ireland by the Four Masters, from the earliest period to the year 1616. Edited from MSS in the Library of the Royal Irish Academy and of Trinity College Dublin with a translation and copious notes. (Dublin 1848–51; repr. 1856, 1990).
35. Historiae Catholicae Iberniae compendium: domino Philippo Austriaco III, Hispaniarum, Indiarum, aliorum regnorum atque multarum ditionum regi Catholico monarchaeque potentissimo dicatum a D. Philippo O'Sullevano Bearro, Iberno (Lisbon 1621, reprinted Dublin 1850).
36. John O'Donovan (ed. and trans.), The topographical poems of O'Dubhagain and O'Huidrin (Dublin 1862).
37. Whitley Stokes (ed), The Tripartite Life of Saint Patrick, with other documents relating to that Saint, edited with translations and indexes, 2 vols. (London 1867); vol. II, 357–375. (Available on CELT in file L201060.) Saint Patrick's Confessio is also the subject of a website hosted at the RIA, http://www.confessio.ie/#
38. Mervyn Archdall, Monasticon hibernicum; or, A history of the abbeys, priories, and other religious houses in Ireland. Edited, with extensive notes, by the Right Rev. Patrick F. Moran. (2 vols, Dublin, 1873–76).
39. Standish Hayes O'Grady, 'Betha Cellaigh', Silva Gadelica I, 49–65, English translation, 'Life of St. Ceallach', Vol. II, 50–69. (London 1892).
40. Denis Murphy (ed), The Annals of Clonmacnoise (Dublin 1896).
41. Kathleen Mulchrone, Caithréim Cellaig, Medieval and Modern Irish Series, vol. 4 (Dublin: DIAS 1933).
42. R. I. Best, The Yellow Book of Lecan, Journal of Celtic Studies 1/2 (1950) 190–192.
43. Polydore Vergil, The Anglica historia of Polydore Vergil, A.D. 1485–1537: edited, with a translation by Denys Hays (London 1950).
44. Hans P. A. Oskamp, The 'Yellow Book of Lecan' proper', Ériu, 26 (1975) 102–121.
45. William O'Sullivan, Ciothruadh's Yellow Book of Lecan, Éigse, 18 (1980–81), 177–181.
46. Sarah Sanderlin, The manuscripts of the Annals of Clonmacnoise, PRIA (C), 82 (1982), 111–123.
47. Kathryn Grabowski and David N. Dumville, Chronicles and annals of medieval Ireland and Wales: the Clonmacnoise group of texts (Woodbridge 1984).
48. Nollaig Ó Muraíle, The celebrated antiquary Dubhaltach Mac Fhirbhisigh (c.1600–71): his lineage life and learning (Maynooth 1996, revised reprint Maynooth 2002).
49. David Edwards, (ed), Regions and rulers in Ireland, 1100–1650: Essays for Kenneth Nicholls (Dublin 2004).
50. Michael Herity, 'Whitley Stokes's correspondence with John O'Donovan, 1857–1861', Studia Hibernica, 36 (2009–2010) 9–89.
51. Pádraig Ó Riain, A dictionary of Irish Saints (Dublin 2011).
**Literature: History, Genealogy and medieval society in Ireland**2. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman (Dublin 1846).
3. Roderic O'Flaherty, Ogygia seu, Rerum Hibernicarum chronologia: Ex pervetustis monumentis fideliter inter se collatis eruta, atque e sacris ac prophanis literis primarum orbis gentium tam genealogicis, quam chronologicis sufflaminata praesidiis. (...) (London 1685). (An English translation by the Reverend James Hely was published in Dublin 1793).
4. John O'Donovan ed. and tr., 'The circuit of Muircheartach mac Neill', in: Tracts relating to Ireland i (Dublin 1841).
5. Eoin Mac Neill (=John Mac Neill), 'Early Irish population-groups: their nomenclature, classification, and chronology', Proceedings of the Royal Irish Academy (C), 29, (1911–12) 59–114. (Available on CELT.)
6. Trinity College Library, MS 1440, Historia et Genealogia Familiae de Burgo. Edited by Tomás Ó Raghallaigh, Journal of the Galway Archaeological and Historical Society 13 (1926–1927)
7. Toirdhealbhach Ó Raithbheartaigh (ed), Genealogical tracts: being a collection of excerpts in the Book of Lecan (Dublin 1932).
8. Lambert McKenna (ed), Iomarbhágh na bhFileadh (The Contention of the Bards), 2 vols. (20/21) (London: Irish Text Society 1918).
9. T. F. O'Rahilly, Early Irish History and Mythology (Dublin 1946).
10. John V. Kelleher, 'The pre-Norman Irish genealogies', Irish Historical Studies 16 (1968) 138–153.
11. Francis John Byrne, Tribes and tribalism in early Ireland, Ériu 22 (1971) 128–166.
12. Gearóid Mac Niocaill, Ireland before the Vikings (Dublin 1972).
13. Donnchadh Ó Corráin, Ireland before the Normans (Dublin and London 1972).
14. Kenneth W. Nicholls, Gaelic and gaelicised Ireland in the Middle Ages (Dublin 1972, new edition 2003).
15. Kenneth W. Nicholls, The Irish genealogies: their value and defects, Irish Genealogist 5/2 (1975).
16. Michael O'Brien (ed), Corpus genealogiarum Hiberniae, reprinted Dublin 1986.
17. Francis John Byrne, Irish kings and high-kings (New York 1973, second edition Dublin 2001).
18. Francis John Byrne, 'Senchas: the nature of Gaelic historical tradition', in: John Barry (ed), Historical Studies 9 (Belfast 1974), 137–159.
19. David N. Dumville, 'Kingship, genealogies, and regnal lists', in: P. H. Sawyer & I. N. Wood (eds.), Early medieval kingship (Leeds 1977) 72–104.
20. Donnchadh Ó Corráin, An chléir agus leann dúchais anallód: an ginealas, Léachtaí Cholm Cille 16 (1986) 71–86.
21. John Bradley (ed), Settlement and society in medieval Ireland: studies presented to F. X. Martin (Dublin 1988).
22. Dáibhí Ó Cróinín, Early medieval Ireland: 400–1200 (Dublin 1995).
23. Gerard Moran and Raymond Gillespie (eds.), Galway history and society: interdisciplinary essays on the history of an Irish county (Dublin 1996).
24. Donnchadh Ó Corráin, 'Creating the past: the early Irish genealogical tradition', Peritia 12 (1998) 177–208.
25. Alfred P. Smyth (ed), Seanchas: studies in early and medieval Irish archaeology, history and literature in honour of Francis J. Byrne (Dublin 2000).
26. Patrick J. Duffy, David Edwards, and Elizabeth FitzPatrick (eds.), Gaelic Ireland, c.1250–c.1650: land, lordship, and settlement (Dublin 2001).
27. Donnchadh Ó Corráin, 'Prehistoric and Early Christian Ireland', in: Roy Foster (ed), The Oxford Illustrated History of Ireland (Oxford 2001) 1–52.
28. Nollaig Ó Muraíle (ed and trans), The great book of Irish genealogies, compiled (1645–66) by Dubhaltach Mac Fhirbhisigh. 5 vols. (Dublin 2003).
29. Elizabeth FitzPatrick, Leaca and Gaelic inauguration ritual in medieval Ireland, in: R. Welander, D. Breeze and T. Owen Clancy (eds), The Stone of Destiny: artefact and icon, Society of Antiquaries of Scotland Monograph Series 22, Historic Scotland, (Edinburgh 2003) 107–121.
30. Elizabeth FitzPatrick, Royal inauguration assembly and the Church in Medieval Ireland, in P. S. Barnwell and M. Mostert (eds), Political assemblies in the earlier middle ages, 73–93. Studies in the Early Middle Ages 7. (Turnhout 2003) (Conference Proceedings).
31. Elizabeth FitzPatrick, Royal inauguration in Gaelic Ireland c.1100–1600: a cultural landscape study. Studies in Celtic History 22. (Woodbridge 2004).
32. Elizabeth FitzPatrick, Parley sites of Ó Néill and Ó Domhnaill, in: D. Edwards (ed), Regions and rulers in Ireland, 1100–1650: essays for Kenneth Nicholls, (Dublin 2004) 201–216.
33. Elizabeth FitzPatrick, Royal inauguration mounds in medieval Ireland: antique landscape and tradition, in: A. Pantos and S. Semple (eds), Assembly places and practices in medieval Europe, 44–72. (Dublin 2004) (Conference Proceedings).
34. Elizabeth FitzPatrick, The landscape of Máel Sechnaill's rígdál at Ráith Áeda, 859 AD, in T. Condit and C. Corlett (eds), Above and beyond: essays in Memory of Leo Swan (Bray 2005) 267–80.
35. Paul MacCotter, Medieval Ireland: territorial, political and economic divisions (Dublin 2008).
36. Elizabeth FitzPatrick (with E. Murphy et. al), Evoking the white mare: the cult landscape of Sgiath Gabhra and its medieval perception in Gaelic Fir Mhanach, in: R. Schot, C. Newman and E. Bhreathnach (eds), Landscapes of cult and kingship, (Dublin 2011) 163–91 (Conference Proceedings).
**Literature: John O'Donovan and the Ordnance Survey**2. H. Richardson (ed.), Ordnance survey memoirs for the parishes of Desertmartin and Kilcronaghan 1836–1837 (Magherafelt 1986).
3. Michael Herity (ed.), Ordnance Survey letters: letters containing information relative to antiquities collected during the progress of the Ordnance Survey [by John O'Donovan, Eugene Curry, Thomas O'Connor, Patrick O'Keeffe and others], with an Introduction and prefatory matter (Dublin 2001-).
4. Gillian M. Doherty, The Irish Ordnance Survey: History, Culture and Memory. Dublin 2004.
**The edition used in the digital edition**2. The Genealogies, Tribes and Customs of Hy Fiachrach, commonly called O'Dowda's Country. Now first published from the Book of Lecan, in the Library from the Royal Irish Aademy, and from the genealogical manuscripts of Duald Mac Firbis, in the library of Lord Roden; with a translation and notes, and a map of Hy-Fiachrach. John O'Donovan (ed), First edition [524 pages] Irish Archaeological SocietyDublin (1844)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition represents the Introductory Remarks (pp v–xii); and main body, i. e. odd pages 3–339; plus odd and even pages 343–473, and 476 of the Appendix, of the translation, including extensive textual notes, which are tagged *note type="auth" n=""* and included in the wordcount above. While O'Donovan used letters of the alphabet for the footnotes, these have been numbered subsequently in the CELT edition. Care was taken to modify any cross-references given by O'Donovan accordingly. However, should you notice any errors in footnote numbers, please contact Beatrix Färber. O'Donovan's references to literature have been made consistent where necessary. In Latin passages, all diacritics used in the printed edition are omitted. U,u standing for V,v and vice versa is normalized to enhance word searches. Occasional instances of -ij have likewise been normalized to -ii. Where O'Donovan cites passages that are available in editions on CELT, these have been used, or linked to. For one or two corrections of the translation supported by the *Irish version*, *corr sic resp="orig"* has been used. Where, in the Appendix, O'Donovan supplies passages of Irish text with facing English or Latin translation, these passages could not be presented in columns, as it was done in the printed edition. However, the tag *mls unit="column" n=""* illustrates in which column the texts originally appear. Some of the paragraphs in these passages are quite long. Therefore they have occasionally been broken up into smaller segments purely to facilitate comparison. Some of the longer text extracts supplied in the Appendix may be found in separate files online at CELT (which see). A map included in the printed edition is at various points mentioned by O'Donovan. This map was not available to us, and we invite anybody who can furnish a good exemplar to contact us.


#### Editorial Declaration


##### Correction


The translation and notes have been proof-read twice.


##### Normalization


The electronic text represents the edited text in line with CELT practice. Text in Latin or Irish is marked. Normal CELT conventions have been applied in regard to text divisions, word segmentation, and capitalization in proper names. Some typographical errors in the translation are corrected using corr, with the original spelling retained in its sic attribute. The editor's Addenda et Corrigenda (pp 473ff) have been integrated, and the list is omitted from the file.


##### Quotation


Direct speech is tagged q. Citations are tagged cit. This element contains bibl and qt elements.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the genealogy; div1=the section; div2=the sub-section. Paragraphs are marked; page-breaks are marked pb n="". MS foliation is not indicated in the printed edition.


##### Interpretation


Names are not tagged.


### Profile Description


Created: 
 Date range: c.1645–c.1666 [Irish text, based on older material].
 (1844 [translation]) #### Use of language


##### Language: [EN] Introduction, translation and footnotes are in English.


##### Language: [GA] Some words are in (Middle ) Irish.


##### Language: [LA] Some words in the notes are in Latin.


##### Language: [FR] Some words in the notes are in French.


##### Language: [GR] A few words in the Introduction and notes are in Greek.


### Revision History


* (2014-03-21) Beatrix Färber (ed.)

* Items added to bibliographic details.
* (2014-02-03) Beatrix Färber (ed.)

* Corrections for pp 461 to 473 added; file re-parsed.
* (2014-01-31) Janet Crawford (ed.)

* Pages 461 to 473 proofed (2); corrections submitted.
* (2014-01-26) Beatrix Färber (ed.)

* Irish text on p. 418–25, 440–444, 455–60, and 472–73 typed in and proofed (1,2); file parsed and validated.
* (2014-01-23) Beatrix Färber (ed.)

* Remaining text scanned, proofed (1) and encoded. Corrections for pp to 460 added; file re-parsed.
* (2014-01-12) Janet Crawford (ed.)

* Pages 420 to 460 proofed (2); corrections submitted.
* (2014-01-12) Beatrix Färber (ed.)

* Text to p. 466 scanned, proofed (1) and encoded.
* (2013-11-08) Beatrix Färber (ed.)

* Corrections added.
* (2013-11-06) Janet Crawford (ed.)

* Pages 401 to 420 proofed (2); corrections submitted.
* (2013-11-04) Beatrix Färber (ed.)

* Text to p. 420 scanned, proofed (1) and encoded.
* (2013-09-23) Beatrix Färber (ed.)

* Text proofed (2); file reparsed, new SGML and HTML versions created.
* (2013-09-17) Beatrix Färber (ed.)

* Text to p. 398 scanned, proofed (1) and encoded.
* (2013-09-11) Beatrix Färber (ed.)

* Text up to p. 381 proofed (2); new SGML and HTML files created.
* (2013-09-07) Helena Klimka (ed.)

* Pages 373-81 proofed (1) and basic encoding added.
* (2013-09-02) Beatrix Färber (ed.)

* More text added, proofed (1) and encoded; new SGML and HTML files created.
* (2013-07-26) Beatrix Färber (ed.)

* More text added, proofed (1) and encoded; proof corrections by Janet Crawford integrated; new SGML and HTML files created.
* (2013-07-22) Beatrix Färber (ed.)

* Correction submitted by Janet Crawford integrated.
* (2013-07-22) Janet Crawford (ed.)

* Pages to 331 proofed (2), corrections communicated.
* (2013-07-12) Beatrix Färber (ed.)

* More text added, proofed (1) and encoded.
* (2013-07-03) Beatrix Färber (ed.)

* Corrections added; file reparsed; new SGML and XML versions uploaded.
* (2013-07-02) Janet Crawford (ed.)

* Pages to 311 proofed (2), corrections communicated.
* (2013-06-30) Beatrix Färber (ed.)

* Pages to 311 scanned, proofed, and encoded.
* (2013-06-14) Beatrix Färber (ed.)

* Corrections added; pages to 287 scanned, proofed, and encoded.
* (2013-06-12) Janet Crawford (ed.)

* Pages to 284 proofed (2), corrections communicated.
* (2013-05-27) Beatrix Färber (ed.)

* Pages to 255 scanned, proofed (1), and encoded; file validated.
* (2013-05-25) Janet Crawford (ed.)

* Pages to 240 proofed (2), corrections communicated.
* (2013-05-24) Beatrix Färber (ed.)

* Pages to 240 scanned, proofed (1), and encoded; file validated.
* (2013-05-09) Beatrix Färber (ed.)

* Pages to 231 scanned, proofed (1), and encoded; file validated.
* (2013-04-22) Beatrix Färber (ed.)

* Corrections added and new file created.
* (2013-04-19) Janet Crawford (ed.)

* Pages to 209 proofed (online) and corrections communicated.
* (2013-04-18) Beatrix Färber (ed.)

* Pages to 209 scanned, proofed (1), and encoded; pages 186 to 209 proofed (2); file validated. Editor's Addenda and Corrigenda on pp 373f. integrated.
* (2013-04-03) Beatrix Färber (ed.)

* Pages 180 to 185 scanned, proofed (1), and encoded; pages 171 to 185 proofed (2).
* (2013-04-01) Beatrix Färber (ed.)

* Pages 147 to 170 proofed (2).
* (2013-03-28) Beatrix Färber (ed.)

* Pages to 179 scanned, proofed (1), and encoded.
* (2013-03-26) Beatrix Färber (ed.)

* Pages to 171 scanned, proofed (1), and encoded.
* (2013-03-25) Beatrix Färber (ed.)

* Pages 147 to 163 scanned, proofed (1), and encoded.
* (2013-03-20) Beatrix Färber (ed.)

* Corrections up to p. 145 integrated; Editor's Addenda and Corrigenda on pp 373f. integrated.
* (2013-03-15) Janet Crawford (ed.)

* Pages 67 to 139 proofed (2) and corrections communicated.
* (2013-03-13) Beatrix Färber (ed.)

* Translation and footnotes scanned, proofed (1) and encoded to p 139; file re-parsed; preliminary HTML version created.
* (2013-02-27) Beatrix Färber (ed.)

* Corrections submitted by Janet Crawford added; translation and footnotes scanned, proofed (1) and encoded to p. 61.
* (2013-02-23) Janet Crawford (ed.)

* Introduction, translation and footnotes proofread online to p. 49.
* (2013-02-21) Beatrix Färber (ed.)

* Header created with bibliographic detail; file converted to XML; SGML and HTML file created.
* (2013-02-20) Beatrix Färber (ed.)

* Introduction, translation and footnotes proofed (1) to page 49; structural and content markup applied.
* (2013-02-05) Beatrix Färber (text capture)

* Text and footnotes captured by scanning up to page 49.




---


#### Corpus of Electronic Texts Edition: T105008


### The Genealogies, Tribes, and Customs of Hy-Fiachrach, commonly called O'Dowda's Country: Author: Duald Mac Firbis




---

p.v


### Introductory Remarks


The following account of the families, districts, and customs of Hy-Fiachrach is printed from the Genealogical MS. of **Duald Mac Firbis**, — the original of which is preserved in the Library of the **Earl of **Roden****, and a good copy in the Library of the Royal Irish Academy. The poem by **Giolla Iosa Mor Mac Firbis**, which will be found, p. 176, et seq., is edited from the Book of Lecan[1](javascript:footNote('T105008/note001.html')). For a general account of the contents of Lord Roden's manuscript the reader is referred to a paper by **Mr. Petrie**, which was published in the eighteenth volume of the Transactions of the Royal Irish Academy, and to the Stowe Catalogue, vol. 1, p. 141, et seq., where a copy of the same work is described by Dr. O'Conor.


In the account of the families of the Hy-Fiachrach race this manuscript agrees very closely with the text of the Book of Lecan, excepting that the compiler has carried the pedigrees of some branches of the O'Dowds down to his own time, and has inserted here and there, from other authorities, some genealogical and historical facts not to be found in the Book of Lecan. These additions have been noticed in every instance in the notes to this volume.




---

p.vi


Of the private history of the compiler of this manuscript but little is known. In the title of the work he calls himself Dubhaltach Mac Firbisigh of Lecan, in the year 1650; but though he may have been born there about the year 1600, when Lecan or Lacken was the freehold inheritance of his family in right of their profession as 
historiographers of their race, it does not appear that he was ever in possession of the castle or lands of the Mac Firbises, who were deprived by James I.; nor does it appear from the pedigree, as compiled by himself, that he was the head of the family, for his cotemporary and kinsman, Ferfeasa, the son of Ciothruadh Og, who was the son of Ferfeasa, who was the son of Ciothruadh, who built the castle of Lecan in 1560, would seem to be of an older branch. Be this, however, as it may, we have the direct evidence of an inquisition taken at Sligo, on the 22nd of August, 1625, that ‘Donnogh O'Dowde was then seized of the castle, towne, and quarters of Lacken M'Firbissy, and other lands which he had settled by deed, dated the 20th of August, 1617, to the use of his wife Onora Ny-Connor, for their lives, and then to the use of his own right heirs.’ It is quite clear that Donnoghe O'Dowde could not have settled Lacken in this manner in 1617, if it had been then[2](javascript:footNote('T105008/note002.html')) the freehold inheritance of the family of Mac Firbis. The most that can be believed, therefore, is, that the Mac Firbises may have farmed the townland of Lacken, 



---

p.vii



or a part of it, from Donnogh O'Dowde or his successor till the year 1641, at which period it was forfeited by O'Dowd and granted to the family of Wood.


**Charles O'Conor of Belanagare** informs us, in a private letter, published by Dr. Ledwich in his Antiquities of Ireland, second edit., Dublin, 1804, p. 303, that **Duald Mac Firbis** was instructed in the Brehon laws by the Mac Egans of Ormond, who were hereditary Brehons, and professors of the old Irish laws; but he does not say whether he had acquired any other language besides Irish. The Editor, however, has been able to gather from his works that he was well acquainted with Latin and English, and that he had some knowledge even of Greek. It appears from his account of the Anglo-Norman and Welsh families of Ireland that he had read the works of **Giraldus **Cambrensis**** and **Holingshed**, and he quotes and refutes **Verstegan**'s work, entitled Restitution of Decaied Intelligence. Also in his copy of Cormac's Glossary, preserved in the Library of Trinity College, Dublin, Class H. 2, 15, p. 161 et seq., he explains many Latin and Greek words in
the margin, always writing the Greek in the original character: thus, in a note on the word crinda, he writes krinw, which he explains ‘judico .i. brethuigim,’ I judge; at cual he writes kwla .i. cuirp marbha, dead bodies; opposite the word carr, which is explained carruca in the original, he writes ‘carrum apud Liv. et carruca Mart., et cartus’, ‘.i. carr, cairt, no carbat tairngid eich, ar a m-bíd a do no a ceathair do rothaibh’, i. e. a car, cart, or chariot, drawn by horses, to which there are two or four wheels. Again, opposite the word folach, which is derived in the original from falus, Graece, custodia Latine he writes in the margin the correct Greek form of the word " .i. coimhed, no tairge, a watching, custody. From these and many other specimens of his Greek handwriting, in the same volume, it is quite evident that he had studied that language, but where he was taught it we have no means left us to determine.




---

p.viii


He commenced his genealogical compilation in the College of St. Nicholas, at Galway, in the year 1650, and seems to have been adding to it and correcting and amending it till the year 1664, when he inserted the curious entry about the ancient celebrity of the Hy-Fiachrach race, which will be found at full length in this volume, p. 316–321.


Of this work and its author the venerable **Charles O'Conor of Belanagare**, writes the following notice in his Preface to Ogygia Vindicated, pp. ix, x:
  

‘**Duald Mac Firbis** closed the line of the hereditary antiquaries of Lecan, in Tirfiacra, on the Moy, a family whose law reports and historical collections have derived great credit to their country (many of which lye now dispersed in England and France). This last of the Firbisses was unfortunately murdered at Dunflin, in the county of Sligo, A.D. 1670, and by his death our antiquities received an irreparable blow. His historical, topographical, and genealogical collections (written by his own hand) are now in the possession of a worthy nobleman, the **Earl of **Roden****, who added this to the other collections of Irish history made by his father, our late Lord Chancellor Jocelyn. Of that work Mac Firbis intended a second draught (as he intimates) with amendments and corrections, but whether he executed his design we cannot learn. As the work stands it is valuable, by preserving the descents and pointing out the possessions of our Irish families of latter times, very accurately; but it is particularly valuable, by rescuing from oblivion the names of districts and tribes in Ireland, antecedently to the second century; since which, the Scots have gradually imposed new names of their own, as they were enabled, from time to time, to expel the old Belgic inhabitants. It is a most curious chart of antient topography, and vastly preferable to that given by the Alexandrian Geographer Ptolemy, who must know *have known* but little of Ireland, wherein the Romans never made a descent.’


‘The last years of Firbis's life were employed in drawing up a glossary for the explanation of our old law terms, the great desideratum of the present age. Of the fate of this last performance we know nothing, but we may well suppose it lost, as the author lived without a single patron, in days unfavourable to the 
arts of which he was master.’


In 1666 he drew up an abstract of his larger work, containing 



---

p.ix



some additional pedigrees; of this abridgement there is a good copy in the Library of the Marquis of Drogheda, and another in the collection of Messrs. Hodges and Smith, but the Editor has never seen the original. In this tract Mac Firbis mentions his having been acquainted with Irish chieftains who governed their septs according to the words of Fithel[3](javascript:footNote('T105008/note003.html')) and the Royal Precepts — (Do leanas do bhriathraibh Fithil gus do'n Teasgasc Rioghdha); and he also speaks of several Irish Brehons then or lately in existence, and of one in particular who was his own relative and acquaintance. He informs us himself, in the Preface to his larger genealogical work, that he wrote a copious Glossary of the Brehon Laws (which is referred to by O'Conor in the extract above given), and an account of Irish writers, but neither of these works is now known to the Editor, except a fragment or rough draft of the former, which is preserved in the Library of Trinity College, Dublin. If the **Earl of **Roden**** has either of them in his Library, his Lordship might render an essential service to Irish literature, by depositing it in some public Library, or permitting it to be copied, as he has already very kindly done with respect to MacFirbis's larger genealogical work. The Glossary would most undoubtedly save the translator of the old Irish Brehon laws much time and labour, although we may hope that their meaning is still recoverable by the aid of the copious glosses which accompany them in most of the copies.


From Harris's edition of **Ware**'s Bishops[4](javascript:footNote('T105008/note004.html')) we learn that Mac Firbis, 



---

p.x



a short time before his death, had been employed by **Sir James Ware** to collect and translate Irish documents for him. Harris writes:
  

‘One John was consecrated about the close of the year 1441 (**Sir James Ware** declares he could not discover when he died, and adds, that some called him John De Burgo, but that he could not answer for the truth of that name). But both these particulars are cleared up, and his immediate successor named by Dudley Firbisse, an Amanuensis whom **Sir James Ware** employed in his house to translate and collect for him from the Irish MSS., one of whose pieces begins thus:’
  

*This translation beginned was by Dudley Firbisse, in the House of **Sir James Ware**, in Castle-street, Dublin, 6th November, 1666, — which was twenty-four days before the death of the said Knight. The Annals, or Translation, which he left behind him begin in the year 1443, and end in 1468. I suppose the death of his patron put a stop to his further progress. Not knowing from whence he translated these Annals, wherever I have occasion to quote them I mention them under the name of Annals of Dudley Firbisse.’’*




He also translated, during the short time he was employed by **Sir James Ware**, the Registry of Clonmacnoise, which translation is now preserved in the British Museum, No. LI. of the Clarendon collection. We learn from **Charles O'Conor of Belanagare**, in his Preface to Ogygia Vindicated, p. viii, that he was the Irish instructor of **Roderic O'Flaherty**, the author of Ogygia and Ogygia Vindicated, and it would appear from a list of tracts of Brehon laws which he furnished to **Dr. Lynch**, the author of Cambrensis Eversus, that he was intimate with that distinguished scholar[5](javascript:footNote('T105008/note005.html')), but towards the latter end of his life he seems to have been in great distress, and we are informed by **Charles O'Conor**, in the passage already quoted, that he met a tragical death at Dunflin, in the county of Sligo, in the year 1670!


On the fate and general character of this remarkable man the 



---

p.xi



same writer speaks as follows in his Dissertations on the History of 
Ireland, Dublin, 1766, pp. 124, 125. — (See also first edit., Dublin, 
1753. p. 155):
  

‘**Duald Mac Firbis**, the most eminent antiquarian of the latter times, was possessed of a considerable number of the Brethe Nimhe. He alone could explain them, as he alone, without patronage or assistance, entered into the depths of this part of Scottish learning, so extremely obscure to us of the present age. When we mention Mac Firbis we are equally grieved and ashamed; his neglected abilities ignominious to his ungrateful country! his end tragical! his loss irreparable!’


The learned **Roderic O'Flaherty**, the pupil of Mac Firbis, thus speaks of his learned tutor, in the Ogygia, p. 233:
  

‘Scoticis literis quinque accidunt, in quorum singulis ab aliarum gentium literis discrepant; nimirum, Nomen, Ordo, Numerus, Character et Potestas. Et quia imperiti literarum in charta, aliave ulla materia ad memoriam pingindarum harum rerum ignarus incaute effutiit Bollandus, de materia aliquid praefabor. Ea ante pergamenae usum tabulae erant e betulla arbore complanatae, quas Oraiun et Taibhle Fileadh, .i. Tabulas Philosophicas dicebant. Ex his aliquas inter antiquitatum monumenta apud se superfuisse, ut et diversas characterum formulas, quas ter quinquagenas a Fenisii usque aetate numero, et CRAOBH-
OGHAM, .i. virgeos characteres nomine recenset, non ita pridem ad me scripsit Dualdus Firbissius rei antiquariae Hibernorum unicum, dum vixit, columen, et extinctus, detrimentum.’


Some particulars of the history of **Duald Mac Firbis** have been given in a small periodical called The True Comet, and other obscure publications in Dublin, in which it is stated that his remains were interred at the old church of Kilglass, near the castle of Lecan, and that a stone there, measuring six feet in length by three in width, exhibits on its head end, a device, representing a chisel, which was probably intended as the crest of the Mac Firbis family, and containing an Irish inscription, which states that **Duald Mac Firbis** died in the eightieth year of his age, and that he had spent thirty years 



---

p.xii



of his life in the castle of Lecan compiling the History of Ireland. But the Editor is sorry to be compelled to say, that no such inscription exists, nor ever existed at Kilglass. From a recent examination of Kilglass and an investigation of the local tradition connected with **Duald Mac Firbis**, and particularly from a copy of the real inscription and crest on the stone above alluded to, made by Dr. James Vippler O'Dowda, it appears that this stone, — exhibiting a chisel, as the country people call it, — under which, they say, many of the Mac Firbises lie interred, contains not an Irish inscription, but an English one, in the raised letter, to the memory of George Wood of Lacken, Esq.; and that what the country people take to be a representation of a naked child holding a chisel, is the crest of the family of Wood, namely, ‘a naked savage with a club resting on his shoulder.’ The inscription is now much defaced, and a great part of it illegible, but there never was any reason for supposing it to mark the tomb of the Mac Firbises except its exhibiting the name Lacken.


The Editor has to acknowledge the great assistance he has received from his friends in illustrating and editing the present volume. He is particularly indebted to James Hardiman, Esq., author of the History of Galway, and to Dr. James Vippler O'Dowda, the son and heir of the O'Dowda of Bunnyconnellan, for the use of many documents indispensably necessary to the illustration of the pedigrees of the O'Dowdas and other families of the Hy-Fiachrach race; and he has further to acknowledge his obligations to Dr. Todd of Trinity College, **Mr. Petrie**, and Mr. E. Curry, for much valuable assistance in translating and editing this work, which has been attended with much delay and difficulty, as it relates to a portion of Irish history and topography hitherto unexplored.


J. O'D >


---

p.3


Genealogy of the Hy-Fiachrach
-----------------------------


The Race of Fiachra, Son of Eochaidh Muighmheadhoin[6](javascript:footNote('T105008/note006.html')). — [These are the[7](javascript:footNote('T105008/note007.html')) Hy-Fiachrach of the Muaidh[8](javascript:footNote('T105008/note008.html')) (where we are this day, 1666), the Hy-Amhalgaidh of Iorrus[9](javascript:footNote('T105008/note009.html')), the men of Ceara[10](javascript:footNote('T105008/note010.html')), the Hy-Fiachrach Aidhne[11](javascript:footNote('T105008/note011.html')), now called Cineal Guaire[12](javascript:footNote('T105008/note012.html')), Cineal Aodha na h-Echtghe[13](javascript:footNote('T105008/note013.html')), Coill Ua bh-Fiachrach[14](javascript:footNote('T105008/note014.html')), together with other territories not considered as of the Hy-Fiachrach at the present day].




---

p.5


Fiachra, son of Eochaidh Muighmheadhoin, had five sons[15](javascript:footNote('T105008/note015.html')); namely, Earc Culbhuidhe from whom are *descended* the men of Ceara. (He was called Earc Culbhuidhe, because the smelted gold was not yellower than his hair. The territory of his descendants was great until the descendants of *his brother* Brian took it from them as eric[16](javascript:footNote('T105008/note016.html')) for their father). Breasal, whose race became extinct; and Conaire, from whom *sprung* Sechnall[17](javascript:footNote('T105008/note017.html')), the Saint.


From Amhalgaidh, the *fourth* son of Fiachra, are sprung the Hy-Amhalgaidh on the Muaidh[18](javascript:footNote('T105008/note018.html')), and the Hy-Becon. This Amhalgaidh had a large family, namely, Fedhlim; Eochaidh of the two plains, i. e. of the plain of Muirisc, daughter of Liogan[19](javascript:footNote('T105008/note019.html')), and of the plain of Muidh, or Muaidh[20](javascript:footNote('T105008/note020.html')); Eunda; Conall; Aongus; Eoghan; Cormac; and Corrdubh. These were the eight sons of Tresi, the daughter of Natfraoch, and sister of Aongus, son of Nadfraoch, king of Munster[21](javascript:footNote('T105008/note021.html')).


From Fedhlim, the son of Amhalgaidh, are *descended* the Cineal Fedhlimidh, in Hy-Amhalgaidh; that is, *the families of* O'Ceallachain[22](javascript:footNote('T105008/note022.html')), O'Caithniadh[23](javascript:footNote('T105008/note023.html')), Mac Coinin[24](javascript:footNote('T105008/note024.html')), O'Muimhneachain[25](javascript:footNote('T105008/note025.html')), Mag-Fhionain[26](javascript:footNote('T105008/note026.html')), 



---

p.7



O'Gearadhain[27](javascript:footNote('T105008/note027.html')), O'Conboirne[28](javascript:footNote('T105008/note028.html')). These are the Cineal Fedhlimidh of Iorrus.


From Aongus, the son of Amhalgaidh, are *descended* the Cineal Aongusa, in Hy-Amhalgaidh; namely, the O'Muireadhaighs[29](javascript:footNote('T105008/note029.html')), chieftains of the Lagan[30](javascript:footNote('T105008/note030.html')); and of the descendants of *this* Aongus was Diucaill the Fierce, of the hill of Budh[31](javascript:footNote('T105008/note031.html')), daughter of Bodhbh Dearg; and of the descendants of Aongus are the people of Dun Finne[32](javascript:footNote('T105008/note032.html')); namely, *the families of* O'Cuinn, Mag Odhrain, O'Comhdhan, O'Duibhlearga, O'Bearga, O'Blighe, O'Duanma, or Duanmaigh; and of the race of Aongus is *the family of* O'Radubhan of Gleann an Chairn[33](javascript:footNote('T105008/note033.html')), *who descend from* Radubhan, son of Muireadhach, son of Eochaidh, son of Aongus, son of Amhalgaidh.


Of the race of Aongus also is *the family of* Mac Conletreach, of Lios Leitreach[34](javascript:footNote('T105008/note034.html')), *who descend from* Culetreach, son of Aodh, son of Muireadhach, son of Eochaidh, son of Aongus; and of the Hy-Muireadhaigh is *the family of* O'Fionnacains[35](javascript:footNote('T105008/note035.html')), of Fionnchalamh[36](javascript:footNote('T105008/note036.html')). It was to *these* Hy-Muireadhaigh that St. Cormac[37](javascript:footNote('T105008/note037.html')) left prosperity of cattle and the gift of eloquence, success of fosterage, the gift of good counsel, and the headship of peace and protection among the Hy-Amhalgaidh; and the battle dress of the King of Hy-Amhalgaidh was given to the best man of the Hy-Muireadhaigh.




---

p.9


Eochaidh of the two plains, the son of Amhalgaidh, had a son Fiachra Fionn, from whom are *descended* the Hy-Fiachrach Finn, in Hy-Amhalgaidh, viz., *the families of* O'Congaile of Cill Achaidh Duibh[38](javascript:footNote('T105008/note038.html')), and O'Cathasaigh of Cill Achaidh Duibh also.


The descendants of Eoghan, Cormac, and Corrdubh, if they left any, are not mentioned.


From Eunda Crom, son of Amhalgaidh, are the Hy-Eunda Cruim among the Hy-Amhalgaidh.


From Conall, son of Amhalgaidh, are *descended* the Hy-Conaill, of the River Dael[39](javascript:footNote('T105008/note039.html')), with their correlatives. These were the sons of Tresi.


Earca, daughter of Eochaidh, King of Leinster, another wife of Amhalgaidh, had seven sons; namely, Fergus; Cormac Ceannfoda; Colom; Seudna; Eochaidh; Aoldobhar; and Emeach, from whom *are sprung the family of* O'h-Emeachain. Fergus, son of Amhalgaidh, had two sons, namely, Conaing and Muireadhach, King of Hy-Amhalgaidh. From Conaing are *sprung* the Hy-Airmeadhaigh, *who are* the inhabitants of Caille Conaill, in the north, that is *the tract extending* from Traigh Murbhaigh[40](javascript:footNote('T105008/note040.html')) to Fearsad Tresi[41](javascript:footNote('T105008/note041.html')), where Tresi, the daughter of Nadfraoch, and wife of Amhalgaidh, son of Fiachra, was drowned. These are the tribes of Caille, viz., *the families of* O'Derg; O'h-Aodha, of Ard O'n-Aodha[42](javascript:footNote('T105008/note042.html')); O'Maoilconaire; O'Flannabhra; and O'Tegha. And of the race of this Conaing, the son of Fergus, was Cumain Foda, from whom Cill Cumaoin[43](javascript:footNote('T105008/note043.html')) in Caille Conaing *has derived its name.*




---

p.11


The following are the descendants of Muireadhach, the son of Fergus, namely, *the inhabitants of* the cantred of Bac[44](javascript:footNote('T105008/note044.html')), and of Gleann Nemhthinne[45](javascript:footNote('T105008/note045.html')), and of the half cantred of Breudach[46](javascript:footNote('T105008/note046.html')). These are the hereditary tribes of Bac, viz., O'Lachtna[47](javascript:footNote('T105008/note047.html')), chief of the two Bacs and of the Glenn[48](javascript:footNote('T105008/note048.html')), and of them are *the families of* O'Dubhagain, and the Clann Firbisigh, the poets of Hy-Amhalgaidh and of Hy-Fiachrach; — (the Leabhar Balbh[49](javascript:footNote('T105008/note049.html')) of James Mac Firbis, says, *that* Lachtna was Mac Firbis[50](javascript:footNote('T105008/note050.html'))); — O'Maoilruaidh[51](javascript:footNote('T105008/note051.html')); of Ard Achadh[52](javascript:footNote('T105008/note052.html')), and O'Cuimin, of Lios Cuimin[53](javascript:footNote('T105008/note053.html')) on the Muaidh.


These are the families of Breudach, viz., O'Toghdha[54](javascript:footNote('T105008/note054.html')) chief of Breudach, O'Glaimin[55](javascript:footNote('T105008/note055.html')), O'Luachaibh[56](javascript:footNote('T105008/note056.html')), and O'Gilin[57](javascript:footNote('T105008/note057.html')). Of the race of *this* Muireadhach, the son of Fergus, is the family of O'Learghusa[58](javascript:footNote('T105008/note058.html')), of the west of Connaught.


The sons of Muirenn (daughter of Dubhthach, King of Hy-Many), another wife of Amhalgaidh, were the following, viz., Cairbre, from 



---

p.13



whom sprung St. Tighearnan, of Oireadh Locha Con[59](javascript:footNote('T105008/note059.html')); Aongus Fionn Mac Amhalgaidh, from whom are *the families of* O'Gaibhtheachain[60](javascript:footNote('T105008/note060.html')), O'Flainn[61](javascript:footNote('T105008/note061.html')), and O'Maoilfhiona[62](javascript:footNote('T105008/note062.html')), chiefs of Calraighe Muighe h-Eleag[63](javascript:footNote('T105008/note063.html')); Duibhindracht Mac Amhalgaidh, from whom are the Muintir Fothaigh[64](javascript:footNote('T105008/note064.html')), Muintir Culachan, and Muintir Duinncuan; Cucoingelt Mac Amhalgaidh, from whom are the Muintir Tomaltaigh; and Conchobhar Mac Amhalgaidh, from whom are the Muintir Ubain, with their correlatives.


The descendants of Cormac Ceannfada, *i. e. of the long head,* Colom, Seudna, and Aoldobhar, are not illustrious.


From Fiachra, the son of Amhalgaidh, are *descended* the Hy-Becon of Meath, *thus:*{column 1}
  

Becon,
  

son of Coman,
  

son of Seanach,
  

son of Aodh,
  

son of Fiachra,
  
{column 2}
  

  

son of Amhalgaidh, King of Connaught,
  

son of Fiachra,
  

son of Eochaidh Muighmheadhoin, King of Ireland.


Cineal Airmheadhaigh here
-------------------------


{column 1}Duiniondach,
  

son of Airmeadhach,
  

son of Baodan,
  

son of Fiachra,
  

son of Conaing,
  
{column 2}
  

son of Fergus,
  

son of Amhalgaidh,
  

son of Fiachra.




---

p.15


The Cineal Eunda, Son of Amhalgaidh
-----------------------------------


{column 1}
  
Maolbrighde,
  

son of Cnaimhghiolla,
  

son of Tomaltach,
  

son of Reachtabhra,
  

son of Clothra,
  

son of Dubhlacha,
  

son of Diarmaid,
  

son of Tighearnan,
  
{column 2}
  

son of Erc,
  

son of Maine,
  

son of Conall,
  

son of Eunda,
  

son of Amhalgaidh,
  

son of Fiachra.


{column 1}
  
[Reachtabhra[65](javascript:footNote('T105008/note065.html')),
  

son of Aeldobhar,
  

son of Laitcenn,
  

son of Fuilim,
  

son of Dima,
  
{column 2}
  

son of Ros,
  

son of Feidhlimidh,
  

son of Amhalgaidh,
  

son of Fiachra].


{column 1}
  
Fergus[66](javascript:footNote('T105008/note066.html')) and Aongus,
  

two sons of Conall,
  

son of Fionan,
  

son of Conall,
  

son of Fearadhach,
  
{column 2}
  

son of Cormac,
  

son of Aongus,
  

son of Amhalgaidh,
  

son of Fiachra.


Genealogy of the Men of Ceara
-----------------------------


{column 1}
  
Cucothaigh,
  

son of Maonach, of Ceara,
  

son of Dunchadh,
  

son of Flann Rodhba, *i. e. Flann of the River Robe,*
  

son of Maolduin,
  

son of Failbhe,
  

son of Maolumha,
  
{column 2}
  

son of Fearadhach,
  

son of Ros Doimthigh,
  

son of Maine Muinbreac,
  

son of Earc Culbhuidhe,
  

son of Fiachra Foltsnathach,
  

son of Eochaidh Muighmheadhoin.




---

p.17


{column 1}
  
[Donncathaigh[67](javascript:footNote('T105008/note067.html')),
  

Son of Maelumhai,
  

Son of Fearadhach,
  

Son of Ros Doimdigiu,
  
{column 2}
  

Son of Maine Muinbrec,
  

Son of Erc Culbhuidhi].


This Cucothaigh had five sons, namely, Tighearnach, from whom 
is *the family of* O'Tighearnaigh[68](javascript:footNote('T105008/note068.html')), Kings of Ceara[69](javascript:footNote('T105008/note069.html')), Uathmharan, from whom is *the family of* O'h-Uathmharain[70](javascript:footNote('T105008/note070.html')); Niall, a quo *the family of* Mac Neill[71](javascript:footNote('T105008/note071.html')); Uada, from whom is *the family of* O'h-Uadach; and Faghartach, from whom is *the family of* O'Faghartaigh, as *the poet* said: 

> 1. Five sons of great prosperity,
>   
> Niall and Uada, and Uathmharan,
>   
> Faghartach, who forced the gap,
>   
> And Tighearnach of the bounteous hand.
> 




[Cuan[72](javascript:footNote('T105008/note072.html')), from whom are *descended* the Clann Cuain, was,
  
{column 1}
  

Son of Eochaidh,
  

Son of Flann,
  

Son of Fearadhach,
  
{column 2}
  

Son of Ros Doimtheach,
  

Son of Maine Muinbreac,
  

Son of Earc Culbhuidhe.]


The Race of Dathi, down here
----------------------------


Dathi, son of Fiachra, was King of Erin, Alba, Britain, and as far as the mountain of the Alps; for he succeeded Niall[73](javascript:footNote('T105008/note073.html')) in the government, and reigned twenty seven years as King of Erin.




---

p.19


The following were the battles which he fought in defence of Erin *after the death of* Niall, the son of Eochaidh, viz., the battle of Ath Talmaide[74](javascript:footNote('T105008/note074.html')), the battle of Bodaighe[75](javascript:footNote('T105008/note075.html')), the battle of Rath Cruachan[76](javascript:footNote('T105008/note076.html')), and the battle of Magh Ailbhe[77](javascript:footNote('T105008/note077.html')); and many battles in Alba *i. e. Scotland*; the battle of Magh Circain[78](javascript:footNote('T105008/note078.html')), and the battle of Srath[79](javascript:footNote('T105008/note079.html')).


Dathi went afterwards with the men of Erin across Muir n-Icht[80](javascript:footNote('T105008/note080.html')) towards Leatha[81](javascript:footNote('T105008/note081.html')), until he reached the Alps[82](javascript:footNote('T105008/note082.html')), to revenge *the death of* Niall of the Nine Hostages[83](javascript:footNote('T105008/note083.html')). This was the time that Formenius (or Parmenius), King of Thrace[84](javascript:footNote('T105008/note084.html')), took up his residence in the Alps, having fled from his kingdom and retired thither for the love of God as a pilgrim. He erected there a circular tower of sods and stones sixty feet in height[85](javascript:footNote('T105008/note085.html')), and he lived in the middle of the tower, 



---

p.21



eleven feet from the light[86](javascript:footNote('T105008/note086.html')), and he saw not a ray of the sun or other light.


Dathi came to the tower. (He was called Dathi from his expertness[87](javascript:footNote('T105008/note087.html')) [daithe] at invading and shooting, for if there were one hundred *persons* shooting, *i. e. discharging arrows or javelins* at him, he would be protected against them by the activity of his hands in guarding, wherefore the name of Dathi clung unto him. Feradhach[88](javascript:footNote('T105008/note088.html')) was his name when he went to the east, and it was on his expedition in the east he was called Dathi). When the king's *(i. e. Dathi's)* people saw the tower, they went to demolish it, and they tore it down and plundered it. Formenius felt the wind coming to him, and God raised him up in a blaze of fire[89](javascript:footNote('T105008/note089.html')) one thousand paces from the tower of sods which he had built, and he prayed for King Dathi that his reign might continue no longer; and he also prayed God that his monument or tomb might not be remarkable. The life of Dathi endured no longer than until he had the tower destroyed, when there came a flash of lightning from heaven which struck him dead on the spot.[90](javascript:footNote('T105008/note090.html'))




---

p.23


When the men of Erin perceived this, they put a lighted Sbongc *[Spongia?]* in the king's mouth, in order that all might suppose that he was living, and that it was his breath that was coming out of his mouth. But the learned say that it was the same arrow with which Niall of the Nine Hostages was slain, that God permitted Formenius to discharge from his bow that by it Dathi might be killed[91](javascript:footNote('T105008/note091.html')).


Formenius then went one thousand paces down from that mountain, and there dwelt in another habitation[92](javascript:footNote('T105008/note092.html')).


Amhalgaidh, the son of Dathi[93](javascript:footNote('T105008/note093.html')), then took the command of the men of Erin, and he carried[94](javascript:footNote('T105008/note094.html')) the dead body of his father with him, and he gained nine battles by sea, and ten battles by land by means of the corpse: *for* when his people exhibited the body of the king, they used to rout the forces that opposed them. These are the names of the battles thus gained *by land*, viz., the battle of Corpar, the battle of Cinge, or Cime, the battle of Colom, the battle of Faile, the battle of Miscal, the battle of Lundunn, the battle of Coirte, the battle of Moile, 



---

p.25



the battle of Grenius, and the battle of Fermir[95](javascript:footNote('T105008/note095.html')). These were the battles gained by Dathi by exhibiting his dead body to the hosts.


The body of Dathi was carried to Erin, and interred in releg na Riogh *the cemetery of the kings* at Cruachan, where the kings of the race of Heremon were, for the most part, interred; and Amhalgaidh, the son of Dathi, died in Deisi Breagh of the venom of the deep wounds which he received in the above mentioned battles, and his tribe and progeny are in Bregia, or Breghmhagh, i. e. the Cineal Becon.


Dungal[96](javascript:footNote('T105008/note096.html')), Flannghus, Tuathal, and Tomaltach were the four servants of trust who carried with them the body of the king. [The body of Dathi was brought to Cruachan *and was interred in Roilig na Riogh, or Cemetery of the Kings, at Cruachan*, where the kings of the race of Heremon were, for the most part, interred, where, to this day, 1666, the cairrthe dhearg[97](javascript:footNote('T105008/note097.html')), *red pillar stone,* remains as a monument over his grave, near Rath Cruachan.] That the body of Dathi is interred in the middle of Aonach na Cruachna is attested by Torna Eigeas, in his poem pointing out the burial place of the kings of the race of Heremon to the men of Erin.


‘Thou hast concealed from all, o Cruacha Croidhearg, the fair king of Erin, Dathi, son of Fiachra, a generous king by sea and land; all have been informed that he was killed in royal land; from all I will not conceal it. Thou hast, &c.’


This was revealed to Torna Eigeas through poetical inspiration[98](javascript:footNote('T105008/note098.html')), 



---

p.27



after he had been requested by the men of Erin to discover where Dathi, son of Fiachra, king of Erin, was interred; so that it was on this occasion Torna Eigeas composed this rithlearg[99](javascript:footNote('T105008/note099.html')) *above given* to prove it; and he composed *also* the following quatrains:
  


> 1. Under thee lies the fair king of the men of Fail,
>   
> Dathi, son of Fiachra, man of dignity[100](javascript:footNote('T105008/note100.html'))
>   
> O Cruacha, thou hast concealed this
>   
> From the strangers, from the Gaels.
> 2. Under thee is Dungalach the vehement,
>   
> Who brought the hostages[101](javascript:footNote('T105008/note101.html')) over the boisterous sea;
>   
> Under thee are, reveal their appearance[102](javascript:footNote('T105008/note102.html')),
>   
> Conn, Tuathal, and Tomaltach.
> 3. The three sons of Eochaidh Feidhleach[103](javascript:footNote('T105008/note103.html')), the fair,
>   
> Are in thy mound, as I boast,
>   
> As *also* is Eochaidh Aireamh[104](javascript:footNote('T105008/note104.html')) feeble,
>   
> Having been slain by the great Maol.
> 4. The prince Eochaidh Feidhleach is
>   
> Beneath thee, and Derbhre[105](javascript:footNote('T105008/note105.html')) of goodly aspect,
> 
> 
> ---
> 
> p.29
> 
> 
> And Clothra[106](javascript:footNote('T105008/note106.html')), no small honour *to thee,*
>   
> And Meadhbh[107](javascript:footNote('T105008/note107.html')), and Muireasg[108](javascript:footNote('T105008/note108.html')).
> 5. Eire, Fodhla, and Banba[109](javascript:footNote('T105008/note109.html')),
>   
> Three beauteous, famous young women,
>   
> Are in Cruachan of clans,
>   
> Three queens of the Tuatha De Dananns.
> 6. The three sons of Cearmad[110](javascript:footNote('T105008/note110.html')) of Sith Truim[111](javascript:footNote('T105008/note111.html')),
>   
> And Lughaidh[112](javascript:footNote('T105008/note112.html')) of Liatruim[113](javascript:footNote('T105008/note113.html')),
>   
> The sons of Aodh, son of the Daghda[114](javascript:footNote('T105008/note114.html')),
>   
> And Midir[115](javascript:footNote('T105008/note115.html')), the great *and* brave.
> 7. Beneath thy stone are lying
>   
> Cobhthach Caol[116](javascript:footNote('T105008/note116.html')) and Ugaine[117](javascript:footNote('T105008/note117.html')),
>   
> And Badhbhchadh of prosperous career,
>   
> Brother of the haughty Ugaine.
> 8. The sons of the noble Feidhlimidh Reachtmhar[118](javascript:footNote('T105008/note118.html')),
> 
> 
> ---
> 
> p.31
> 
> 
> And the descendants of Conn[119](javascript:footNote('T105008/note119.html')) are in the assembly,
>   
> (Excepting Art[120](javascript:footNote('T105008/note120.html')) and Cormac[121](javascript:footNote('T105008/note121.html')) of battles);
>   
> It is certain that thou hast concealed them, O Cruacha.
> 9. The saint *[i. e. Formenius]*, after the destruction of his walls[122](javascript:footNote('T105008/note122.html')),
>   
> Said to him *[i. e. to Dathi]*, with prophetic spirit,
>   
> 'May not this hero's monument
>   
> Be conspicuous;' O Cruacha!
> Under, &c.
> 
> 






---

p.33


Dathi had twenty-four sons[123](javascript:footNote('T105008/note123.html')) namely, Oilioll Molt[124](javascript:footNote('T105008/note124.html')), King of Erin and Alba, and a man who exacted the Borumean tribute[125](javascript:footNote('T105008/note125.html')) thrice without a battle; Fiachra Ealgach, from whom the Hy-Fiachrach of the Moy, and various other tribes are *descended*; Eochaidh Breac, from whom are *sprung* the Hy-Eachach of the Moy, and the Hy-Fiachrach Aidhne; Eochaidh Meann; Fiachra Mac Dathi, who was detained as a hostage by Niall of the Nine Hostages, and from whom the Hy-Fiacha, or Hy-Fiachrach, of Cuil Fabhair[126](javascript:footNote('T105008/note126.html')), in Meath, are descended; Earc; Corc; Onbecc; Beccon; Mac Uais; Aongus the Long-handed; Cathal; Faolchu, from whom are the Ui Faolchon; Dunghal; Conrach; Neara; Amhalgaidh Mac Dathi, from whom are the Cineal m-Beccon, in Bregia, or Breagh-mhuigh[127](javascript:footNote('T105008/note127.html')). [The pedigree of the Clann-Firbis[128](javascript:footNote('T105008/note128.html')) is also traced to this Amhalgaidh.] Blachadh, or Bladhcadh; Cugamhna, from whom are the Mac Congamhnas, in Cineal Fechin[129](javascript:footNote('T105008/note129.html')); and Aodh, from whom are *sprung* the Hy-Aodha, in Boirinn[130](javascript:footNote('T105008/note130.html')).


Oilioll Molt, the son of Dathi, had a son Ceallach, the father of Eoghan Beul, and of Oilioll Ionbhanda, two kings of Connaught[131](javascript:footNote('T105008/note131.html')).


Eoghan Beul had two sons, namely, Ceallach, on whom the atrocious murder was committed, that is, his own four *foster sons, or pupils* killed him treacherously at Ard an Fhenneadha, at the instigation of 



---

p.35



Guaire *Aidhne*, son of Colman, through envy about the sovereignty; and Cuchongelt Mac Eoghain, the other son, was he who slew the *foster sons* of Ceallach in revenge for their fratricide; they were Maolcroin, Maolseanaigh, Maoldalua, and Mac (or Maol) deoraidh. Or, *according to others,* these were hanged at *the river of* Sal Srotha Derg[132](javascript:footNote('T105008/note132.html')), which is called the Muaidh, and it was from them the hill over the Muaidh was called Ard na ri*a*gh[133](javascript:footNote('T105008/note133.html')); and Ard na Maol[134](javascript:footNote('T105008/note134.html')) is the name of the hill on the other side of the stream, where they were interred.


### The Descendants of Eochaidh Breac, the son of Dathi, down here


Eochaidh Breac, the son of Dathi, had four sons, namely, Laoghaire, Brethe, Ailghile, and Eoghan Aidhne.


Brethe, the son of Eochaidh Breac, had issue, viz., Maolfaithche, from whom are the *family of* O'Maoilaichen[135](javascript:footNote('T105008/note135.html')); Brodubh, from whom are the *family of* O'Broduibh[136](javascript:footNote('T105008/note136.html')); Breanainn, from whom are the *family of* O'Maoilbreanainn[137](javascript:footNote('T105008/note137.html')), and the *family of* O'Creachain[138](javascript:footNote('T105008/note138.html')). Of the descendants of Breanainn, the son of Brethe, were the three O' Suanaighs, namely, Fidhmuine, Fiodhairle, and Fidhgusa, or Fiodhgus; *who were* the three sons of 



---

p.37


{column 1}
Fiodhbhadach,
  

son of Cuduiligh,
  

son of Coman,
  

son of Suanach,
  

son of Creachan of the Moy,
  

son of Bruidhe,
  
{column 2}
  

son of Brenainn,
  

son of Brethe,
  

son of Eochaidh Breac,
  

son of Dathi, King of Erin.


Fearamhla, the daughter of Dioma Dubh, son of Diarmaid, son of Seanach, son of Laoghaire, son of Eochaidh Breac, son of Dathi, was the mother of the three O'Suanaighs[139](javascript:footNote('T105008/note139.html')). She was also the mother of Aodhan, of Cluain Eochaille[140](javascript:footNote('T105008/note140.html')), in Corann, and of St. Dichlethe O'Triallaigh, whose habitation is in the country of Ciarraighe Luachra. And she was the mother of St. Colman, the son of Eochaidh, who is, i. e. *lies interred* at Sean bhothach[141](javascript:footNote('T105008/note141.html')), in Hy-Censiolaigh; and these are the saints of the Hy-Eathach, of the Moy. Of the race of Eochaidh Breac, son of Dathi, are the Saints Colman and Aodhan. The following are the saints of the race of Eochaidh Breac, viz.:
  

{column 1}
  

Colman,
  

son of Duach, from whom Ceall mhic Duach[142](javascript:footNote('T105008/note142.html'))
  

son of Ainmire,
  

son of Conall,
  

son of Cobhthach,
  
{column 2}
  

son of Goibhnenn,
  

son of Conall,
  

son of Eoghain Aidhne,
  

son of Eochaidh,
  

son of Dathi.


Also the three O'Suanaighs, *already mentioned*, who were established at the following places, viz., Fidhmuine, at Rathain[143](javascript:footNote('T105008/note143.html')); Fidhairle, at Cionn Saile[144](javascript:footNote('T105008/note144.html')); and Fiodhgus, at Glas-charraig[145](javascript:footNote('T105008/note145.html')).




---

p.39


It was Dichlethe O'Triallaigh, commonly called Triallach, that absconded from Tir Amhalgaidh, and went to Disert Ui Triallagh[146](javascript:footNote('T105008/note146.html')), on the brink of the *river* Casan Ciarraighe; and it was upon him the *following* great miracle was performed. One time, as he attempted to go away from the sons of his mother on an expedition to seek for God, they took him and fettered him, placing a lock of iron between his head and feet; and the key of the lock was cast into the sea, and a salmon took it in its mouth and swallowed it. Triallach *soon after* stole away on his expedition, and put to sea in a currach *which was* not *covered* with leather, and went round Ireland westwards, with the fetter between his head and feet, until he arrived on the coast of Ciarraighe Luachra[147](javascript:footNote('T105008/note147.html')), whither the salmon which had swallowed the key accompanied him, and by the assistance of God he landed there at Disert Ui Triallaigh, on the brink of *the river* Casan Ciarraighe, so that neither his brothers nor tribe knew in what direction he had gone.


O'Suanaigh and Aodhan afterwards went in search of their mother's son, and they knew not his fate or destiny until they found him at the Disert with his lock on between his head and feet, and he hiding himself from those clerics who were in search of him. They were not long there when they saw a fisherman[148](javascript:footNote('T105008/note148.html')) coming towards them, the man to whom the habitation belonged, who bade the clerics welcome, and made obeisance to them, for he perceived that they



---

p.41



were of the people of God, i. e. *ecclesiastics*, and that they had set out on their journey to search for the saint who was bound by the fetter. Triallach ordered that the clerics should be well entertained, ‘that strangers were entitled to attention.’ The fisherman then went to set his net for them, and O'Suanaigh said to him, ‘thou wilt take the full of thy net, that is a salmon in each mesh, but do not bring with thee more than a sufficiency for us, that is, a salmon for each man.’ The fisherman did accordingly, and he presented a salmon to each cleric; and the key was found in the belly of the salmon given to Triallach, and the lock was opened with it. That fetter is now a miraculous relic, and known by the name of *Glasan Ui* Triallaigh[149](javascript:footNote('T105008/note149.html')), *i. e. Triallachs little lock or fetter*.


Triallach was called Diclethe, from the cleth, *or concealment,* which he made of himself in escaping from his brothers, and in the house of the fisherman. And he was called Triallach[150](javascript:footNote('T105008/note150.html')) from the triall, *or voyage,* which he made on the sea in despite of his brothers.


From Ailghile, son of Eochaidh Breac, are *descended* Muinter Ailgheanain, or Ailghile, and of whom was the celebrated prophet Cutemen[151](javascript:footNote('T105008/note151.html')) Mac Ailghile.


From Cuboirne, the fifth son of Eochaidh, are descended Muinter Mochain[152](javascript:footNote('T105008/note152.html')), of Cill Athracht[153](javascript:footNote('T105008/note153.html')), i. e. the keepers of the Cross of St. Athracht.




---

p.43


Pedigree of O'Mochain
  
{column 1}
  

Gregory, Archbishop of Tuam[154](javascript:footNote('T105008/note154.html')),
  

son of Simon,
  

son of Nicholas,
  

son of Domhnall,
  

son of Donnchadh,
  

son of Muircheartach,
  

son of Muireadhach,
  

son of Finn,
  

son of Meanman,
  

son of Donnchadh,
  

son of Aitheasach,
  

son of Muircheartach,
  

son of Murchadh,
  
{column 2}
  

son of Mochan, a quo the O'Mochains,
  

son of Aongus,
  

son of Treasach,
  

son of Tighearnach,
  

son of Tadhg,
  

son of Ailgheanach,
  

son of Conchobhar,
  

son of Flann,
  

son of Cathal,
  

son of Cuboirne,
  

son of Eochaidh Breac,
  

son of Dathi, King of Ireland.


*Others say* that the Cuboirne from whom the O'Mochains are descended, was son to Eoghan Aidhne, the son of Eochaidh Breac; and this is true.


The descendants of Laoghaire, son of Eochaidh Breac, are the Muinter Muiren, of Gleann Maoilduin, at the Eidhneach[155](javascript:footNote('T105008/note155.html')), and another family called Muinter Muiren, in Umhall[156](javascript:footNote('T105008/note156.html')), and they are both the same family with respect to their descent, viz.: 



---

p.45


{column 1}
  

Maolduin,
  

son of Muiren, a quo Ui Muiren in Umhal,
  

son of Diarmaid,
  

son of Seanach,
  

son of Laoghaire,
  

son of Eochaidh Breac,
  

and Maolbrighde,
  

son of Muiren,
  
{column 2}
  

son of Maolduin, from whom is called Gleann Maoilduin,
  

son of Criomhthann,
  

son of Dioma,
  

son of Diarmaid,
  

son of Seanach,
  

son of Laoghaire,
  

son of Eochaidh Breac.


{column 1}
  
Cuimin,
  

son of Dioma,
  

son of Diarmaid,
  
{column 2}
  

son of Seanach,
  

son of Laoghaire, &c.


Whose descendants are at Cill Cuimin[157](javascript:footNote('T105008/note157.html')), that is the *family of* O'Cuimin. But he is not the *Saint* Cuimin by whom the place was first blest; for he was
  
{column 1}
  

Cuimin Foda,
  

son of Conaing or Conall,
  

son of Fergus,
  
{column 2}
  

 son of Amhalgaidh,
  

son of Fiachra.


When Cuimin, the son of Dioma, was buried he was interred in the large uluidh, *or altar-tomb,* at the feet of O'Suanaigh, and it is his descendants that have been *as comharbas* in the church[158](javascript:footNote('T105008/note158.html')) ever since.




---

p.47


O'Dorchaidhe[159](javascript:footNote('T105008/note159.html')) and O'Goirmiallaigh[160](javascript:footNote('T105008/note160.html')) (the two chiefs of Partraighe[161](javascript:footNote('T105008/note161.html'))) are of the race of Laoghaire, the son of Eochaidh Breac (or *Eochaidh* of the Moy). There are many Partraighes. — See the Genealogies of the Race of Brian, son of Eochaidh Muighmheadhoin for more of them.


O'Dorchaidhe was chief of Partraighe according to Mac Firbis (Giolla Iosa Mor), in the year of Christ 1417. — See page further on.


> 1. Well has he defended[162](javascript:footNote('T105008/note162.html')) the land of the men,
>   
> O'Dorchaidhe of the high mind,
>   
> The country of Partraighe of fine hazel trees,
>   
> With a yellow-knotted *spear-*shaft in the battle.
> 

{column 1}
  

Dorchaidhe,
  

Son of Dluthach,
  

Son of Dioma Cron,
  

Son of Diarmaid,
  

Son of Seanach,
  
{column 2}
  

Son of Laoghaire,
  

Son of Eochaidh Breac,
  

Son of Dathi.


[163](javascript:footNote('T105008/note163.html'))
### O'Dorchaidhe of Gaillimh


{column 1}
  
James Riabhach, and Dominic,
  

Sons of Nicholas,
  

Son of James Riabhach,
  

Son of Nicholas,
  

Son of Conchobhar,
  

Son of Patrick,
  

Son of Thomas,
  
{column 2}
  

Son of Walter Riabhach, the first man of the *family of* O'Dorchaidhe who came to Gaillimh, according to the people of Gaillimh themselves.




---

p.49


{column 1}
  
Martin,
  

son of Richard,
  

son of Martin,
  
{column 2}
  

son of James Riabhach,
  

son of Nicholas.


{column 1}
  
Matthew,
  

son of James Og,
  
{column 2}
  

son of James Riabhach.




---

p.51


{column 1}
  
Francis,
  

son of Anthony,
  

son of James Riabhach.


Andrew, and Patrick the lawyer[164](javascript:footNote('T105008/note164.html')), two other sons of James Riabhach, the elder.


Of the race of Laoghaire also are the Hy-Eachach of the Moy[165](javascript:footNote('T105008/note165.html')), with their correlatives, and the *family of* O'Maoilfaghmhair[166](javascript:footNote('T105008/note166.html')), comharbas of Cill Ealaidh[167](javascript:footNote('T105008/note167.html')), in Tir Eachach, or Hy-Eachach of the Moy, of whom were these seven holy bishops, viz., Mo Cele O'Maoilfaghmhair, from whom are *descended* the Mac Celes, of Cill Ealaidh[168](javascript:footNote('T105008/note168.html')); Aongus the Bishop, Muireadhach the Bishop, Aodh the Bishop, Ainmtheach the Bishop, Maolan the Bishop, and Flann the Lecturer, i. e. a pious Bishop of the Clann Cele[169](javascript:footNote('T105008/note169.html')).


Of the race of Laoghaire, in Hy-Eachach, of the Moy, are the O'Criadhchens[170](javascript:footNote('T105008/note170.html')), the O'Leanains[171](javascript:footNote('T105008/note171.html')), and the O'Flaitiles[172](javascript:footNote('T105008/note172.html')), or O'Laitiles.


The country of Hy-Eachach, of the Moy, extends from Ros Serce[173](javascript:footNote('T105008/note173.html')) to Fionnchaluim, and to Fearsad Tresi. Ros Serce is so called from Searc, the daughter of Cairbre, son of Amhalgaidh, who blessed the village and the wood which is at the mouth of the River 



---

p.53



Moy. This Searc was a miraculous female saint, and it was for her the church and duirtheach[174](javascript:footNote('T105008/note174.html')), which are at that Ros (or in that Ros), at Roserc, were erected.


### Of the Descendants of Eoghan Aidhne, the Son of Eochaidh Breac


Eoghan Aidhne, son of Eochaidh Breac, who was son of Dathi, was called Eoghan Aidhne, because it was in *the territory of* Aidhne[175](javascript:footNote('T105008/note175.html')) he was fostered by the *tribe called* Oga Beathra, the third tribe who then inhabited Aidhne, for there were three tribes in Aidhne before the Hy-Fiachrach, namely the Ciarraighe, Oga Beathra, the Tradraighe, of Dubh-ros[176](javascript:footNote('T105008/note176.html')), and the Caonraighe, of Ard Aidhne. The Oig Beathra came from the country of Ealla[177](javascript:footNote('T105008/note177.html')), and were of the race of Eoghan Taidhleach[178](javascript:footNote('T105008/note178.html')); they took possession of the northern part of Aidhne, and it was they that fostered Eoghan Aidhne, the son of Eochaidh Breac, for which he was called Eoghan Aidhne. The Oig Beathra also fostered Eoghan Beul, the son of Ceallach, son of Oilioll Molt, son of Dathi, and they were his first faction when he was assuming the government of Connaught. The Tradraighe are of the race of Geanann, the son of Deala[179](javascript:footNote('T105008/note179.html')), and the Caenraighe are of the race of Conn[180](javascript:footNote('T105008/note180.html')). Eoghan Aidhne was the foster-son



---

p.55



of these tribes, and it was the Oga Beathra (as we have already stated) that maintained the territory of Aidhne for him and his descendants after him.


Eoghan Aidhne had four sons, namely, Conall, Cormac, Seudna, and Seachnasach, who was called Ceanngamhna and Seanach Ceanngamhna, and from him are descended the Cineal Cinngamhna, i. e. the family of O'Duibhghiolla[181](javascript:footNote('T105008/note181.html')), chiefs of Cineal Cinngamhna. Of this tribe of Cineal Cinngamhna was Saint Sarnait[182](javascript:footNote('T105008/note182.html')), the daughter of Aodh Gabhalfhada, son of Seanach, son of Eoghan Aidhne, son of Eochaidh Breac.


From Conall, son of Eoghan Aidhne are sprung the Cineal Guaire, thus:
  
{column 1}
  

Aodh and Colman, two sons of Cobhthach,
  

son of Goibhnenn,
  

son of Conall,
  
{column 2}
  

son of Eoghan Aidhne,
  

son of Eochaidh Breac,
  

son of Dathi, King of Ireland.


From Aodh, son of Cobhthach[183](javascript:footNote('T105008/note183.html')), are sprung the Cineal Aodha, i. e. O'Seachnasaigh and O'Cathail, two kings of Cineal Aodha; and from Colman are the Cineal Guaire.


Seudna, son of Eoghan Aidhne, was the progenitor of the Cineal Seudna.


From Cormac, Son of Eoghan *[Aidhne]*, are the Cineal Cearnaigh.




---

p.57


The Cineal Cuaiche are sprung from Cethernach, son of Cuach, son of Criomhthann Caoin, son of Eoghan Fuileach, son of Aodh Gabhalfhada.


### O' Cathail, in Cineal Aodha



  
{column 1}
  
Cathal,
  

son of Ogan,
  

son of Bracan,
  

son of Cionaoth,
  

son of Torpa,
  

son of Conchobhar,
  

son of Comuscach,
  
{column 2}
  

son of Bec,
  

son of Aodh,
  

son of Cobhthach,[184](javascript:footNote('T105008/note184.html'))
  

son of Goibhnenn,
  

son of Conall,
  

son of Eoghan Aidhne.



  
{column 1}
  
Cian,
  

son of Conchobhar,
  

son of Uban,
  

son of Ogan,
  
{column 2}
  

son of Bruachan, or Bracan,
  

son of Cionaoth.


### Pedigree of O' Seachnasaigh



  
{column 1}
  
Sir Diarmaid (now living, 1666),
  

son of Sir Ruaidhri, i. e. Giolla dubh O'Seachnasaigh, whose brothers were Dathi and William,
  

son of Diarmaid O'Seachnasaigh,
  

son of Giolla dubh,
  

son of Diarmaid,
  

son of William,
  

son of John,
  
{column 2}
  

son of Eoghan,
  

son of William,
  

son of Giolla na Naomh,
  

son of Ruaidhri,
  

son of Giolla na Naomh,
  

son of Raghnall,
  

son of Sealbhach or Gailbhighe[185](javascript:footNote('T105008/note185.html')), 
son of Seachnasach, from whom the *family of* O'Seachnasaigh, 



---

p.59


{column 1}
  

son of Donnchadh,
  

son of Cumaighne, or Cumaighe,
  

son of Feargal,
  

son of Maolciarain,
  

son of Caisin, or Cas,
  

son of Murgal,
  

son of Maoltuile,
  

son of Simil (or Sioghmal, or Sioghmuine, or Siothmuine),
  

son of Nobile (or Nocba, or Ogba),
  

son of Cana (or Eagna, or Aghna),
  

son of Nadseudna,
  

son of Garbhan (or Gabhran),
  

son of Soghan (or Toban, or Tobach, or Toghbha),
  

son of Branan (or Bronan),
  
{column 2}
  

son of Bran, or Brian Lethdherg,
  

son of Murchadh,
  

son of Aodh,
  

[son of Artghal,
  

son of Guaire Aidhne,
  

son of Colman[186](javascript:footNote('T105008/note186.html'))],
  

son of Cobhthach,
  

son of Goibhnenn,
  

son of Conall,
  

son of Eoghan Aidhne,
  

son of Eochaidh Breac,
  

son of Dathi, King of Ireland,
  

son of Fiachra,
  

son of Eochaidh Muighmheadhoin, King of Ireland.


[187](javascript:footNote('T105008/note187.html'))
### Pedigree of Muinter Scannlain


{column 1}
  
Eoghan,
  

son of Art Buidhe,
  

son of Brian Garbh,
  

son of Maghnus,
  

son of Conchobhar,
  

son of Muirgheas,
  
{column 2}
  

son of Tadhg,
  

son of Aodh,
  

son of Toirdhealbhach,
  

son of Aodh,
  

son of Conchobhar,
  



---

p.61


{column 1}
  

son of Giolla na n-each,
  

son of Aodh,
  

son of Scannlan Og,
  

son of Ceallach,
  

son of Giolla-Bearaigh,
  

son of Domhnall,
  

son of Aodh,
  

son of Scannlan,
  
{column 2}
  

son of Feargal,
  

son of Maoilciarain,
  

son of Caisin,
  

son of Muirgeal,
  

son of Maoiltuile,
  

son of Timile,
  

son of Nobile, ut supra.


Seanach Ceann Gamhna, had three sons, namely, Aodh Gabhalfhada, *Aodh* Baill-derg, and Fearadhach, from whom are the chieftains, namely, the O'Duibhghiollas, with their correlatives, of whom I have already briefly spoken.


[Guaire, the son of Colman[188](javascript:footNote('T105008/note188.html')), son of Cobhthach, son of Goibhnenn, son of Conall, son of Eoghan Aidhne, son of Eochaidh Breac, son of Dathi, had three sons, viz., Artgal, Aedh, and Nar. This Aedh had 



---

p.63



a son Fergal; Fergal had two sons, viz., Cormac, and Enda a quo Cinel Enda. The issue of Cormac became extinct except one daughter, Righnach, the mother of St. Colman Mac Duach, a quo Ceall mic Duach, *i. e. Kilmacduagh.*


Nar, the son of Guaire, was the eldest of his sons, a quo Cinel Guaire. The Cinel Guaire are called after him for his nobleness beyond the other sons, Aedh and Artgal. Nar had one son, namely, Cobhthach; Cobhthach had a son Flann, a quo Cinel Guaire. O'Maghna[189](javascript:footNote('T105008/note189.html')) was chief of the Cinel Guaire and of the Caenraighe until Mac Giolla Ceallaigh[190](javascript:footNote('T105008/note190.html')) deprived him of his patrimonial inheritance. O'Duibhghiolla is the chief of Cinel Cinngamhna; Mac Gilla Cheallaigh is chief of Cinel Guaire; O'Cathan[191](javascript:footNote('T105008/note191.html')) is chief of Cinel Ianna, and of his followers are O'Mochan[192](javascript:footNote('T105008/note192.html')), O'h-Oirechtaigh[193](javascript:footNote('T105008/note193.html')), and the O'Marcachans[194](javascript:footNote('T105008/note194.html')). So far the Cinel Guaire.


Mag Fhiachra[195](javascript:footNote('T105008/note195.html')) is the chief of Oig Bethra, and his retainers are O'Caemhagan[196](javascript:footNote('T105008/note196.html')), O'Dubhagan[197](javascript:footNote('T105008/note197.html')), and the Mag Flannagans[198](javascript:footNote('T105008/note198.html'))].


Maolfabhaill had two sons, namely, Maolchulaird and Cugaola, the father of Giolla na Naomh and Flaithbheartach, who was the father of Giolla Iosa, and Cugaola, from whom is the family of Mac Conghaola[199](javascript:footNote('T105008/note199.html')), as also of Muireadhach and Giolla Fursa.


Giolla na Naomh, the son of Cugaola, had one son, namely, Aodh, the father of Giolla na Naomh and Giolla Ceallaigh, who was the 



---

p.65



father of Aodh (who was usually called Maol na m-bo), and also of Giolla na Naomh and Cugaola. Maol na m-bo had one son, namely Aodh.


[200](javascript:footNote('T105008/note200.html'))
### Pedigree of O'Hedhin


{column 1}
  
Eoghan and Muircheartach, two sons of Donnchadh,
  

son of Aodh,
  

son of Eoghan,
  

son of Giolla na Naomh,
  

son of Giolla Cheallaigh,
  

son of Aodh,
  

son of Giolla na Naomh of the plunder,
  

son of Cugaola,
  

son of Maolfabhuill,
  
{column 2}
  

son of Flann,
  

son of Edhin,
  

son of Clereach,
  

son of Ceadadhach,
  

son of Cumascach,
  

son of Cathmogha,
  

son of Torpa,
  

son of Feargal,
  

son of Artghal,
  

son of Guaire Aidhne.


{column 1}
  
Aodh Buidhe *[O'h-Edhin]*, 
son of Muircheartach,
  

son of Donnchadh,
  
{column 2}
  

son of Aodh,
  

son of Eoghan, &c.


[201](javascript:footNote('T105008/note201.html'))
### The Family of Laighdiagan


{column 1}
  
Eoghan [O'h-Edhin],
  

son of Aodh Buidhe,
  

son of Aodh,
  
{column 2}
  

son of Eoghan,
  

son of Edmond,
  



---

p.67


{column 1}
  

son of Flann,
  

son of Conchobhar,
  
{column 2}
  

son of Brian,
  

son of Aodh Buidhe, &c.


{column 1}
  
Conchobhar Cron,
  

son of Flann,
  

son of Conchobhar Cron, Tanist of O'h-Edhin.


{column 1}
  
Eoghan Mantach[202](javascript:footNote('T105008/note202.html')) 
son of Toirdhealbhach,
  

son of Eoghan,
  

son of Edmond,
  

son of Flann,
  
{column 2}
  

son of Conchobhar,
  

son of Brian,
  

son of Aodh Buidhe.


{column 1}
  
Edmond, airchinneach of Cill Mhic Duach[203](javascript:footNote('T105008/note203.html')),
  

son of Ruaidhri,
  

son of Eoghan,
  

son of Ruaidhri,
  

son of Flann,
  
{column 2}
  

son of Conchobhar,
  

son of Brian,
  

son of Aodh Buidhe aforesaid.


[204](javascript:footNote('T105008/note204.html'))
### The Family of Dun Eoghain


{column 1}
  
Aodh Meirgeach,
  

son of Brian,
  

son of Aodh Buidhe,
  

son of Brian na Caoraoigheachta,
  
{column 2}
  

son of Aodh Buidhe,
  

son of Flann.


[205](javascript:footNote('T105008/note205.html'))
### The Family of Dun Guaire


{column 1}
  
Aodh Buidhe,
  

son of Flann,
  

son of Flann,
  
{column 2}
  

son of Flann Buidhe.




---

p.69


[206](javascript:footNote('T105008/note206.html'))
### The Family of Lucharnach


{column 1}
  
Gerald and Brian,
  

two sons of Flann,
  

son of Conchobhar,
  

son of Brian na Caoraoigheachta,
  
{column 2}
  

son of Aodh Buidhe,
son of Flann.


[207](javascript:footNote('T105008/note207.html'))
### Pedigree of Mac Giolla Cheallaigh


{column 1}
  
Giolla Cheallaigh, son of Comaltan, from whom are the O'Comaltains, 
son of Maolchulaird,
  

son of Maolfhabhaill,
  

son of Flann,
  

son of Edhin, a quo the O'h-Edhins,
  

son of Clereach, a quo the O'Clerighs,
  
{column 2}
  

son of *Ceudadhach*, a quo Ui Ceudaghaigh,
  

son of Cumasgach,
  

son of Cathmogh, a quo the O'Cathmoghas,
  

son of Torpa, &c.


[208](javascript:footNote('T105008/note208.html'))
### [Pedigree of Mac Giolla Cheallaigh


{column 1}
  
Giolla na Naomh,
  

son of Giolla Cheallaigh,
  

son of Aedh,
  
{column 2}
  

son of Conchobhar,
  

son of Flann,
  



---

p.71



son of Giolla na Naomh,
  

son of Cugaela,
  

son of Giolla Cheallaigh, from whom the surname is called,
  

son of Comaltan,
  

son of Flann, i. e. Maelcearard,
  

son of Maelfabhaill,
  

son of Cleireach, from whom the 
  
{column 2}
  

O'Clerys,
  

son of Ceadadhach,
  

son of Cumasgach,
  

son of Cathmogh,
  

son of Torptha,
  

son of Feargal,
  

son of Artgal,
  

son of Guaire Aidhne].


{column 1}
  
Flann,
  

son of Lonan[209](javascript:footNote('T105008/note209.html')),
  

son of Conmach,
  

son of Caithniadh,
  

son of Aodh,
  
{column 2}
  

son of Torpa,
  

son of Feargal,
  

son of Artgal,
  

son of Guaire Aidhne.


{column 1}
  
Artgal,
  

son of Flaithniadh,
  

son of Feargal,
  
{column 2}
  

son of Artgal,
  

son of Guaire Aidhne.


[When the English invasion[210](javascript:footNote('T105008/note210.html')) *[recte invaders]*, namely, the Burkes of the race of William the Conqueror[211](javascript:footNote('T105008/note211.html')), prevailed over the race 



---

p.73



of Eochaidh Breac, the son of Dathi, son of Fiachra, some of the latter scattered and dispersed themselves in various territories: Mac Giolla Cheallaigh went to Iorrus Iarthair[212](javascript:footNote('T105008/note212.html')), and some of the O'Clerys into Tir Amhalgaidh mhic Fiachrach[213](javascript:footNote('T105008/note213.html')), and others into Munster, where they dwelt in the vicinity of Kilkenny[214](javascript:footNote('T105008/note214.html')); and others of them called Clann Cleirigh, went to Breifne Ui Raghallaigh[215](javascript:footNote('T105008/note215.html')). There passed also, after some time, from Tir Amhalgaidh mhic Fiachrach into Cinel Conaill mhic Neill[216](javascript:footNote('T105008/note216.html')), a wise man of the O'Clerys, whose 



---

p.75



name was Cormac Mac Diarmaid O'Clery, and who was a learned proficient in the two laws, civil and canon[217](javascript:footNote('T105008/note217.html')). The monks and ecclesiastics 



---

p.77



of the abbey of St. Bernard, called the abbey of Eas Ruaidh[218](javascript:footNote('T105008/note218.html')), loved him for his education and good morals, for his wisdom and intellect, and detained him among them for some time. He was at this time a young guest. O'Sgingin had been, for a long time before this period, the historical ollamh [219](javascript:footNote('T105008/note219.html')) to O'Donnell, the lord of Cinel Conaill, and he had first come into Cinell Conaill from Ard Carna[220](javascript:footNote('T105008/note220.html')), in Magh luirg an Daghda[221](javascript:footNote('T105008/note221.html')). Niall Garbh[222](javascript:footNote('T105008/note222.html')), son of Aodh, son of Domhnall Og, was lord of the country when the Cormac we have mentioned came thither, and O'Sgingin, viz., Matthew, was at the time Ollamh to the Niall aforesaid. And there lived not of O'Sgingin's children, nor yet of his tribe in the country, but one fair daughter, and he joined her as wife to this Cormac, and what he asked as her dower[223](javascript:footNote('T105008/note223.html')) was, that whatever male child should be first born to them should be sent to study and learn history, as all his race had become extinct in the territory except the daughter whom he wedded to him on that occasion. The other promised to comply with his request, and kept his promise indeed. A son was born of this Cormac and the daughter of O'Sgingin, named Giolla Bhrighde; and it was in commemoration and remembrance of Giolla Bhrighde O'Sgingin, the brother of his 



---

p.79



mother (the intended ollamh of Cinel Conaill, who had died before this period, in the year of the age of our Lord 1382[224](javascript:footNote('T105008/note224.html'))), that the name Giolla Bhrighde was given to him. Son to this Giolla Bhrighde O'Clery was Giolla Riabhach; son to Giolla Riabhach was Diarmaid of the three schools, *so called because he kept* a school of literature, a school of history, and a school of poetry. It was to him that O'Donnell Niall[225](javascript:footNote('T105008/note225.html')), the son of Toirdhealbhach an Fhiona, granted the lands called Craoibheach[226](javascript:footNote('T105008/note226.html')) (on which he had his dwelling and residence for some time), in addition to the other lands which his *(i. e. O'Donnell's)* ancestors had previously granted to O'Sgingin — as he was a proficient[227](javascript:footNote('T105008/note227.html')) in the science, which was hereditary to him, namely, history. Son to Diarmaid of the three schools was Tadhg Cam, who had the three celebrated sons, Tuathal, Giolla Riabhach, and Diarmaid, by whom the stone-houses were erected at Cill Barrainn[228](javascript:footNote('T105008/note228.html')), for they and their ancestors were freeholders in Cill Barrainn from 



---

p.81



the time of the Cormac we have above mentioned, the first who came to Cinel Conaill. They were also the freeholders of Ceathramh na Cuchtrach[229](javascript:footNote('T105008/note229.html')), and of Ceathramh an Tighe Cloiche[230](javascript:footNote('T105008/note230.html')), a part of the lands of the abbey of Eas Ruaidh. They had also, as a gift from O'Donnell, the quarter of Cill Domhnaigh[231](javascript:footNote('T105008/note231.html')) and the quarter of Cuil Remuir[232](javascript:footNote('T105008/note232.html')), and the quarter of Druim an Chroinn[233](javascript:footNote('T105008/note233.html')), in the plain of Magh Ene.[234](javascript:footNote('T105008/note234.html'))


The sons of Tuathal, son of Tadhg Cam, son of Diarmaid of the three schools, were Tadhg Cam, Giolla Riabhach, Mathghamhain, *and* William. Tadhg Cam left no issue, except one daughter named Celia. Giolla Riabhach, the second son of Tuathal, had issue, Tuathal, Mathghamhain, *and* Cu-Mumhan. Mathghamhain, the son of Tuathal, had a son Diarmaid. This Diarmaid had a son Maolmuire, who was with O'Neill[235](javascript:footNote('T105008/note235.html')) (Toirdhealbhach Luineach). William, son of Tuathal, son of Tadhg Cam, had *four* sons, Donnchadh, Conaire, Domhnall, and Conchobhar.


The sons of Giolla Riabhach, son of Tadhg Cam, son of Diarmaid of the three schools, were Domhnall and Maurice.


Diarmaid, son of Tadhg Cam, son of Diarmaid of the three schools, 



---

p.83



had these sons, namely, Cucoigcriche, Giolla Brighde, Cormac, the friar of the order of St. Francis, and Muirgheas.


The sons of Cucoigcriche, son of Diarmaid, son of Tadhg Cam, were Maccon, Cosnamhach, Dubhthach, Tadhg, Cormac, and Maurice Ballach[236](javascript:footNote('T105008/note236.html')). The sons of Giolla Brighde, son of Diarmaid, son of Tadhg Cam, son of Diarmaid of the three schools, were Fearfeasa, Aimirgin, and Maelmuire. The sons of Muirgheas, son of Diarmaid, son of Tadhg Cam, were Diarmaid and Cuchonnacht.


### Of the race of Diarmaid, son of Tadhg Cam


Lughaidh[237](javascript:footNote('T105008/note237.html')), Giolla-Brighde, Maccon Meirgeach, Cucoigcriche, and Duibhgeann,
  
{column 1}
  

sons of Maccon,
  

son of Cucoigcriche,
  

son of Diarmaid,
  

son of Tadhg Cam,
  

son of Diarmaid of the three schools.
  
{column 2}
  

son of Giolla Riabhach,
  

son of Giolla Brighde,
  

son of Cormac, the first man *of this family* who came to Cinel Conaill,
  



---

p.85


{column 1}
  

son of Diarmaid,
  

son of John Sgiamhach,
  

son of Domhnall,
  

son of Giolla Iosa,
  

son of Tadhg,
  

son of Muireadhach,
  

son of Tighearnach,
  

son of Giolla na Naomh,
  

son of Domhnall,
  

son of Eoghan,
  

son of Braon, *who* died in 1033,
  

son of Cugaela, 1025,
  

son of Giolla Cheallaigh, 1003,
  

son of Comhaltan, 976,
  

son of Maelcerarda, i. e. Flann, 950
  

son of Maolfabhaill, 887.
  

son of Cleireach, from whom the
  
{column 2}
  

*family of* O'Clery,
  

son of Ceadadhach,
  

son of Cumusgach,
  

son of Cathmogh,
  

son of Torpa,
  

son of Feargal,
  

son of Artgal,
  

son of Guaire Aidhne,
  

son of Colman,
  

son of Cobhthach,
  

son of Goibhnenn,
  

son of Conall,
  

son of Eoghan,
  

son of Eochaidh Breac,
  

son of Dathi,
  

son of Fiachra,
  

son of Eochaidh Muighmheadhoin.


{column 1}
  
Diarmaid and John,
  

sons of Cosnamhach,
  

son of Cu-coigcriche,
  

son of Diarmaid,
  
{column 2}
  

son of Tadhg Cam,
  

son of Diarmaid of the three schools.


{column 1}
  
Tadhg Cam, Flann, and Conchobhar,
  

sons of Dubhthach,
  

son of Cucoigcriche,
  
{column 2}
  

son of Diarmaid,
  

son of Tadhg Cam.


{column 1}
  
Maolmuire,
  

son of Fearfeasa,
  

son of Giolla Brighde,
  

son of Diarmaid,
  
{column 2}
  

son of Tadhg Cam,
  

son of Diarmaid of the three schools.




---

p.87


### Of The Race of Tuathal


{column 1}
  
Cu-Mumhan,
  

son of Tuathal,
  

son of Giolla Riabhach
  

son of Tuathal,
  
{column 2}
  

son of Tadhg Cam,
  

son of Diarmaid of the three schools.


{column 1}
  
Maolmuire,
  

son of Mathghamhain,
  

son of Giolla Riabhach,
  
{column 2}
  

son of Tuathal,
  

son of Tadhg Cam.


William, Conaire[238](javascript:footNote('T105008/note238.html')), Maolmuire, i. e. Bernardin[239](javascript:footNote('T105008/note239.html')), Tadhg of the mountain, i. e. Michael[240](javascript:footNote('T105008/note240.html')); *the* two *latter were* friars of the order de Observantia
  
{column 1}
  

sons of Donnchadh,
  

son of William,
  

son of Tuathal,
  
{column 2}
  

son of Tadhg Cam,
  

son of Diarmaid of the three schools.


### Of the Race of Giolla Riabhach


{column 1}
  
Maurice,
  
 
son of Cu-coigcriche,
  
 
son of Maurice,
  

son of Giolla Riabhach,
  
{column 2}
  

son of Tadhg Cam,
  

son of Diarmaid of the three schools.


{column 1}
  
Tuathal,
  

son of Eolus,
  

son of Maurice,
  
{column 2}
  

son of Giolla Riabhach,
  

son of Tadhg Cam.




---

p.89


{column 1}
  
Maolmuire,
  

son of Domhnall,
  

son of Tadhg,
  

son of Maolmuire,
  
{column 2}
  

son of Giolla Riabhach,
  

son of Tadhg Cam.


[241](javascript:footNote('T105008/note241.html'))
### Of the Muintir Cleirigh of Tir-Amhalgadha


{column 1}
  
John Sgiamhach, Daniel, Thomas, and Cormac, four sons of Domhnall,
  

son of Giolla Iosa,
  

son of Tadhg,
  

son of Muireadhach,
  

son of Tighearnach,
  
{column 2}
  

son of Giolla na Naomh,
  

son of Domhnall,
  

son of Eoghan,
  

son of Braen,
  

son of Cugaela, &c.


From John Sgiamhach are descended the family of O'Clery of Tir Conaill; from Daniel are the family of O'Clery of Tir Amhalgadha; 
from Thomas are the Clann Clery of Breifny O'Reilly; and from Cormac are the Muinter Clery of Cill Cainnigh[242](javascript:footNote('T105008/note242.html')).


### Of the Race of Daniel


{column 1}
  
Maolmuire,
  

son of Cormac,
  

son of Diarmaid,
  

son of Ruaidhri,
  

son of John,
  

son of Thomas,
  

son of Domhnall,
  

son of Daniel,
  
{column 2}
  

son of Domhnall,
  

son of Giolla Iosa,
  

son of Tadhg,
  

son of Muireadhach,
  

son of Tighearnach,
  

son of Giolla na Naomh, &c.




---

p.91


{column 1}
  
Thomas and Brian Og,
  

sons of Brian na Broige,
  

son of David Buidhe *[the yellow]*,
  

son of Donnchadh,
  
{column 2}
  

son of Thomas,
  

son of Domhnall,
  

son of Daniel.


{column 1}
  
Duibhgenn,
  

son of Edmond Cron,
  

son of Edmond Cron,
  

son of Cormac,
  
{column 2}
  

son of Thomas,
  

son of Domhnall,
  

son of Daniel.


{column 1}
  
Maolmuire,
  

son of Fear Dorcha,
  

son of Tuathal,
  

son of Donnchadh,
  
{column 2}
  

son of Thomas,
  

son of Domhnall,
  

son of Daniel.


{column 1}
  
Dubhaltach,
  

son of Muircheartach,
  

son of John of Cladagh,
  

son of Brian,
  
{column 2}
  

son of Muircheartach,
  

son of Domhnall,
  

son of Daniel.


{column 1}
  
David Buidhe,
  
 
son of Thomas,
  
 
son of David Buidhe,
  
 
son of Diarmaid Glas,
  
{column 2}
  

son of Muircheartach,
  

son of Domhnall,
  

son of Daniel. 


The following are the kings of the race of Fiachra Foltsnathach, who ruled Connaught and Ireland, viz., Dathi, son of Fiachra: he ruled the countries as far as the Alps, and he exacted the Borumean tribute thrice without a battle.


Olioll Molt, son of Dathi: he assumed the monarchy of Ireland, and exacted the Borumean tribute thrice without a battle. *Some* books state that Earc, the son of Oilioll Molt, assumed the monarchy of Ireland, and exacted the Borumha without a battle.




---

p.93


Amhalgaidh, son of Fiachra: he assumed the government of Connaught. Eoghan Beul, Ailill Ionbhanna, Aodh, and Crunmhaol assumed the kingship of Connaught and were resident in Ceara.


Colman, Guaire Aidhne, Muircheartach, and Laighnen, were four kings of Connaught *who dwelt* in Aidhne..


Oilioll, Cathal, Ionnrachtach, and Dunchadh were four kings of Connaught *who dwelt* in the plain of Muaidhe *[the Moy]*. To commemorate these kings the poet said:
  


> 1. Fourteen kings of the race of Fiachra,
>   
> Vigorous, successful were these kings,
>   
> Both south and north of each country,
>   
> Each tribe of them was with prosperity.
> 2. Four kings of the province of Connaught
>   
> *Dwelt* in great Aidhne, land of saints,
>   
> Muircheartach, one of the perfect breed,
>   
> Laighnen, Guaire, and Colman Caomh.
> 3. Four Connaught kings *dwelt* in Ceara,
>   
> Crunmaol and Aodh of weapons bright,
>   
> And the noble pair Ailill and Eoghan,
>   
> Of the tribe of mighty lions.
> 4. Four kings of the Hy-Fiachrach Muaidhe,
>   
> Dunchadh of Cruachan, of noble feats,
>   
> Iondrachtach, who shunned not the battle,
>   
> Oilill and Cathal Caomh.
> 5. *Of them* four monarchs governed Erin; — 
>   
> Erin they exalted without a cloud, — 
>   
> Dathi and Oilill over Erin,
>   
> Amhalgaidh *and* Earc of the noble lineage.
> 6. The Book of the Tributes of the chiefs of Hy-Fiachrach,
>   
> Are with me here one and all;
> 
> 
> ---
> 
> p.95
> 
> 
> I hear not so of any others like them,
>   
> They are the bravest men that I have seen.
> Fourteen, &c.
> 
> 




Differently from this, however, speaks the historical poem[243](javascript:footNote('T105008/note243.html')) beginning ‘Be it known to the historians of the men of Fail.’
  


> 1. Thirteen kings of kingly prosperity,
>   
> Of the generous race of Fiachra,
>   
> Potent in their countries without thirst,
>   
> *Reigned* in the same Cruachan in Connaught.
> 2. Two Flaithri's, Feargal, it is known,
>   
> Guaire, Colman with worthiness;
>   
> As a lion was each king with his spear,
>   
> Dathi, Eoghan, and Oilill.
> 3. Amhalgaidh, Iondrachtach the noble,
>   
> Donncathadh, Oilill Ionmar,
>   
> Dunchadh without treachery, without guile,
>   
> It is not by me they are not fully remembered.
> 


These *kings* will be more distinctly found in p. 298.[244](javascript:footNote('T105008/note244.html'))


It was by Dathi, the son of Fiachra and his brothers, that Brian, the son of Eochaidh Muighmheadhoin, was slain in the battle of Damh-chluain[245](javascript:footNote('T105008/note245.html')); and it was in eric *[reparation]* for it that the land of Clann Mec n-Earca was forfeited, except a small portion; and it was in Tulach Domhnann[246](javascript:footNote('T105008/note246.html')) he was interred, as stated in page 247.




---

p.97


### Genealogy of the Hy-Fiachrach of the Moy


The mother of Fiachra Ealgach, the son of Dathi, was Ruadh, the daughter of Airtech Uichtleathan, who died at his birth. From her is named Mullach Ruadha[247](javascript:footNote('T105008/note247.html')), in Tir Fiachrach of the Moy, from her being buried in the top of that hill; and over her is the carn of stones which is on the top of the hill. Tulach na molt was its name before that time, from the circumstance that the mother of Oilioll Molt, while he was in her womb, took a desire for wethermutton, and all the wethers procured for the queen were brought to this hill, whence it was called Tulach na molt *[i. e. the hill of the wethers*[248](javascript:footNote('T105008/note248.html'))]. Tulach na Maoile *[i. e. the hill of Maol]* had been its previous name, from the rest which Maol-Flidhisi took upon it during the excursion of Tain Bo Flidhisi [while Fergus[249](javascript:footNote('T105008/note249.html')) and Domhnall Dual-bhuidhe[250](javascript:footNote('T105008/note250.html')) were engaged at single combat, — in which combat Domhnall was slain, — while the Gamanradii were in pursuit of the men of Erin here after the cattle spoil. Whence the hill was called Tulach na Maili; and it was from this Fiachra, the 



---

p.99



son of Dathi, *that* Tir-Fiachrach[251](javascript:footNote('T105008/note251.html')) was named. Cnoc na n-Druadh was another name for this hill, because the Druids of Dathi, King of Erin were used to be on it obtaining knowledge
[252](javascript:footNote('T105008/note252.html')), for it was here they predicted to Dathi that he would attain to the kingdom of Erin, Alba, &c. This authority states that the same Ruadh was the mother of Oilioll Molt, the son of Dathi; but **Doctor Keating**[253](javascript:footNote('T105008/note253.html')) says that Eithne, the daughter of Orach, the *[second]* wife of Dathi, was the mother of Oilioll Molt; that the first wife of Dathi was Fial, daughter of Eochaidh, from whom Cruachan Fele is called; and that Dathi's third wife, Ruadh, the daughter of Airtheach Uichtleathan, son of Ferconga, was the mother of Fiachra Ealgach, from whom Tir Fiachrach of the Moy is named.


Fiachra Ealgach, the son of Dathi (from whom are the Hy-Fiachrach of the Moy), had two sons, namely, Amhalgaidh, from whom Inis Amhalgaidh, *an island* in Loch Con[254](javascript:footNote('T105008/note254.html')), is named, for it was on it he was born; and Maoldubh, from whom is called Dun Maoilduibh[255](javascript:footNote('T105008/note255.html')), at Iasgach [Easkey], the place where he was born and bred.


Amhalgaidh, the son of Fiachra Ealgach, had a large family, namely, Cairpre, Learghus, Fergus, Eochaidh, Fedhlimidh, Eunda, Eoghan Fionn, Trea, Aongus, a quo the Ui Aonghusa, Ronan, from whom are 



---

p.101



the Ui Ronain, i. e. the chiefs of Magh Bron[256](javascript:footNote('T105008/note256.html')), and Cuilen, from whom are the Ui Cuilen of Ath Fen[257](javascript:footNote('T105008/note257.html')).


It was Amhalgaidh, the son of Fiachra Ealgach, that raised Carn Amhalgaidh[258](javascript:footNote('T105008/note258.html')) to serve as a place of fairs and great meetings; and it was in it Amhalgaidh himself was interred, and from him the Carn was called Carn Amhalgaidh, so that it is on that Carn every man of the race of Fiachra Ealgach, that assumes the chieftainship, is inaugurated.


From Amhalgaidh, the son of Fiachra Ealgach, the son of Dathi, of whom we have just spoken, or Amhalgaidh, the son of Dathi himself, whom we left in Bregia, I find no descendants except the Clann-Firbis, who descend from either of them, as I shall set down here from the Books of the Clann Firbis themselves.


[259](javascript:footNote('T105008/note259.html'))
### Pedigree of the Clann Firbis of Lecan


Dubhaltach Og (i. e. myself,[260](javascript:footNote('T105008/note260.html')) the compiler and writer of this book in this year of the age of Christ, 1666), Patrick, Diarmaid, and James,
  
{column 1}
  

sons of Giolla Iosa Mor,
  

son of Dubhaltach Mac Firbis,
  

son of Diarmaid Caoch,
  
 
son of James Mac Firbis,
  

son of Donnchadh Mor,
  
{column 2}
  

son of Ferbisigh,
  

son of John Og,
  

son of John Carrach,
  

son of Ferbisigh,
  

son of Giolla na Naomh,
  



---

p.103


{column 1}
  

son of Domhnall of the school,
  

son of Amhlaoibh,
  

son of John,
  

son of Donnchadh,
  

son of Giolla Phadraig, by whom St. Tighearnan of Errew was fostered,
  

son of Ferbisigh, a quo Clann Firbisigh,
  

son of Domhnall Og,
  

son of Domhnall Mor,
  
{column 2}
  

son of Aongus,
  

son of Lochlainn of Loch Con,
  

son of John,
  

son of Conchobhar na Conairte *[i. e. of the pack of hounds]*,
  

son of Enna,
  
 
son of Conaing,
  

son of Muireadhach,
  

son of Feargus,
  

son of Amhalgaidh,
  

son of Dathi.


I know not but Fiachra Ealgach should come between Dathi and Amhalgaidh, because the land in which Amhalgaidh, the son of Fiachra Ealgach was born, and in which he dwelt, was the first patrimonial inheritance of the Clann Firbis, as we have already mentioned, and as we shall mention again when treating of the inheritors.


Gregory, Andreas, and Thomas Og,
  
{column 1}
  

sons of Thomas Cam,
  
 
son of Dubhaltach,
  
{column 2}
  

son of James,
  

son of Diarmaid Caoch.


{column 1}
  
Mathew,
  

son of James Og,
  

son of Dubhaltach,
  
{column 2}
  

son of James.


Fitheal, Torna, and Maolmuire, who all died without issue, were the three elder sons of Dubhaltach, son of James.


Brian Dorcha, a learned historian, who died without issue, was the second *son* of James, the son of Diarmaid Caoch.


{column 1}
  
Fearfeasa, Aodh, Maolmuire, and Diarmaid,
  

sons of Ciothruadh Og, who had a brother Fearbisigh,
  

son of Fearfeasa, whose brothers were Diarmaid Caoch, and 
  
{column 2}
  

Aodh Buidhe,
  

son of Ciothruadh,
  

son of Diarmaid Caoch,
  

son of Donnchadh Mor.




---

p.105


{column 1}
  
James and Torna,
  
 
sons of Feardorcha,
  
 
son of Torna, brother of Cuchon[261](javascript:footNote('T105008/note261.html')), [*...*]
  
 {column 2}
  

son of Diarmaid Caoch,
  

son of Donnchadh Mor.


### The Race of William, son of Donnchadh Mor Mac Firbis


{column 1}
  
Donnchadh, Maolmuire, and Lughaidh,
  

three sons of Geanann, whose brother was Forannan,
  

son of Fercertne, whose brothers were Maolmuire and Fearbisigh,
  
 {column 2}
  

son of John Og (whose brother was Giolla Iosa and Donnchadh Og, who died issueless),
  

son of William,
  

on of Donnchadh Mor.


{column 1}
  
Fionduine Og,
  

son of Fionduine,
  

son of Giolla Iosa,
  
{column 2}
  

son of William,
  

on of Donnchadh Mor.


{column 1}
  
William Og, or Beg, and John Og,
  

sons of John Og,
  

son of Giolla Iosa,
  
{column 2}
  

son of William,
  

son of Donnchadh Mor.


{column 1}
  
Donnchadh Og, who died without issue,
  

son of William,
  
{column 2}
  

son of Donnchadh Mor.


{column 1}
  
Brian Dorcha, John Og, James, Aodh, Tadhg Ruadh, Edmond Buidhe, and Maolmuire, 
sons of Aodh Og,
  

son of Ciothruadh,
  

son of Tadhg Ruadh,
  

son of Fearbisigh,
  

son of Thomas Cam,
  

son of Giolla Iosa Mor,
  
 {column 2}
  

son of Donnchadh,
  

son of Giolla Iosa Mor, who was sixty years teaching school,
  

son of Fearbisigh,
  

son of Muircheartach, 
  

son of John.




---

p.107


[It is said[262](javascript:footNote('T105008/note262.html')) the Clann Firbis of Lecan Mac Firbis in Hy-Fiachrach and Hy-Amhalgaidh, have the same surname with the two aristocratic families of Forbes of Drominoir, in Scotland, or wherever else they are to be found as Scotchmen, in the three kingdoms; as also with the Cruces, formerly of Fingal, having, in the course of the intermixtures and migrations of the Gaels from one country to another, become English, as many other tribes have become, according to the prophets, who foretold that the Galls would be Gaels, and the Gaels would be Galls].


Maoldubh, son of Fiachra Ealgach, had three sons, namely, Cobhthach, Temen, and Tiobraide.


Cobhthach, the son of Maoldubh, had one son, namely, Maolduin, from whom are descended the *families of* O'Maoilduin[263](javascript:footNote('T105008/note263.html')), with their correlatives, namely, Mac Giolla na n-each[264](javascript:footNote('T105008/note264.html')), Mac Giolla-duibh[265](javascript:footNote('T105008/note265.html')) of Corcach, O'Duibhscuile[266](javascript:footNote('T105008/note266.html')), and O'h-Almhec[267](javascript:footNote('T105008/note267.html')).


From Temen, the son of Maoldubh, are descended the Clanna Temin, namely, the *families of* O'Muirgheasa[268](javascript:footNote('T105008/note268.html')), O'Maonaigh[269](javascript:footNote('T105008/note269.html')), Mac Giolla Riabhach[270](javascript:footNote('T105008/note270.html')), O'h-Aodha[271](javascript:footNote('T105008/note271.html')), and O'Donnchadha[272](javascript:footNote('T105008/note272.html')).


{column 1}
  
Caomhan and Dubhda,
  

sons of Conmhach,
  

son of Donncatha,
  

son of Cathal,
  

son of Ailell,
  
{column 2}
  

son of Dunchadh,
  

son of Tiobraide,
  

son of Maoldubh.




---

p.109


Caomhan was older than Dubhda, and Caomhan thought that the chieftainship was his own; but God did not permit that kings should be of his posterity; and they came to the following agreement[273](javascript:footNote('T105008/note273.html')) about the chieftainship, namely, that Caomhan's[274](javascript:footNote('T105008/note274.html')) representative should always possess his choice territory in the principality, and the privilege of being at the *right* side of the king of Hy-Fiachrach; that he should get the king's steed and battle-dress at the time of his inauguration, and should walk round him thrice after his instalment. And the territory he selected was *that extending* from Tuaim da Bhodhar[275](javascript:footNote('T105008/note275.html')) to the *River* Gleoir[276](javascript:footNote('T105008/note276.html')). The steed, battle-dress, and raiment of O'Caomhain to be given to Mac Firbis, the day that Mac Firbis shall give the name of lord to O'Dubhda.


Caomhan, from whom the *family of* O'Caomhain is descended, had one son, namely, Cathal.




---

p.111


### Pedigree of O'Caomhain


David[277](javascript:footNote('T105008/note277.html')) and Domhnall,
  
{column 1}
  

sons of Aodh,
  

son of David, 
  

son of Thomas,
  

son of Giolla na Naomh,
  
 
son of Domhnall,
  
 
son of David,
  
 
son of Diarmaid,
  

son of Thomas,
  

son of Domhnall,
  

son of Thomas,
  

son of Giolla na Naomh,
  
{column 2}
  

son of Diarmaid,
  

son of Domhnall,
  

son of Cathal,
  

son of Giolla na Naomh,
  

son of Diarmaid,
  

son of Cathal*,*
  

son of Caomhan, from whom *the family of* O'Caomhain,
  

son of Connmhach,
  

son of Donncatha.


Tomaltach, Maghnus, Donnchadh, Aodh Fionn, and John, five sons of David, son of that Aodh.


Thomas Og, Tomaltach, Niall, and Cathal Riabhach, were the sons of Thomas Mor, son of David, son of Giolla na Naomh Mor.


[278](javascript:footNote('T105008/note278.html'))
### The Family of O'Dubhda down here


Dubhda (son of Connmhach) had a son, Ceallach, the father of Aodh, who was father of Maolruanaidh, the father of Maoileachlainn, 



---

p.113



father of Niall, father of Taithleach and Niall, from whom the Clann Neill; and these were they who usurped the inheritance of the O'Caomhains, on account of which mutual slaughters were committed, viz., David and Domhnall O'Caomhain were slain by Niall, son of Aodh, son of Niall; and Niall himself was slain to avenge his brother by Muircheartach Fionn O'Caomhain, who assumed the chieftainship himself.[279](javascript:footNote('T105008/note279.html'))


From Taithleach, the second son of Niall, son of Maoileachlainn, the chiefs *of the O'Dowd family* are descended, viz., Muircheartach (son of Aodh, son of Taithleach), father of Aodh, father of Taithleach, of Brian Dearg (from whom are the Clann Taithligh Oig), and of Muircheartach.


Maolruanaidh[280](javascript:footNote('T105008/note280.html')) (son of Aodh, son of Ceallach, son of Dubhda) had two sons, namely, Domhnall, from whom sprang the Clann Domhnaill, of Loch Con. This is the Domhnall[281](javascript:footNote('T105008/note281.html')) who was slain by the O'Gaibhtheachains *[O'Gaughans]*, at Bearna Domhnaill, in Magh Eleog[282](javascript:footNote('T105008/note282.html')).


From Maoileachlainn[283](javascript:footNote('T105008/note283.html')), the second son of Maolruanaidh, the chiefs are descended.


Of the sons of Domhnall, son of Maolruanaidh, was Cathbharr, 



---

p.115



the father of Domhnall Fionn[284](javascript:footNote('T105008/note284.html')) (who had no issue except a daughter), and of Aodh, father of Taithleach[285](javascript:footNote('T105008/note285.html')) (King of Hy-Amhalgaidh and Hy-Fiachrach), and of Cosnamhach Mor[286](javascript:footNote('T105008/note286.html')), the only fighter of an hundred that came in latter times, and who was treacherously slain by O'Gloinin in his own house at Inis Cua[287](javascript:footNote('T105008/note287.html')), on account of a dispute about a greyhound whelp.


Taithleach, son of Aodh, had two sons, namely, Aodh and Amhlaoibh.


Donnchadh Mor[288](javascript:footNote('T105008/note288.html')), son of Aodh (son of Taithleach, son of Aodh, son of Muircheartach, son of Aodh, son of Taithleach, son of Niall), had three sons, namely, Brian[289](javascript:footNote('T105008/note289.html')), Maolruanaidh[290](javascript:footNote('T105008/note290.html')), and Muircheartach[291](javascript:footNote('T105008/note291.html')), from whom the Clann Conchobhar are sprung.


Maolruanaidh, the son of Donnchadh Mor, had two sons, namely, Taithleach[292](javascript:footNote('T105008/note292.html')) and Cosnamhuigh, i. e. Archdeacon of Tuaim da Ghualann, and presumptive Archbishop.


Taithleach, the son of Maolruanaidh, had three sons, namely, Brian O'Dubhda[293](javascript:footNote('T105008/note293.html')), King of the Hy-Fiachrach and the Hy-Amhalgaidh, 



---

p.117



and Donnchadh Mor O'Dubhda[294](javascript:footNote('T105008/note294.html')), heir apparent of Hy-Fiachrach. Slaine, daughter of Mac Maghnus, of Tir Tuathail[295](javascript:footNote('T105008/note295.html')) was the mother of both. Maoileachlainn Carrach[296](javascript:footNote('T105008/note296.html')), the other son, was the father of Conchobhar, who was father of Muircheartach, the father of Diarmaid and Maolruanaidh.


Donnchadh Mor, son of Taithleach O'Dubhda, had three sons, namely, Donnchadh Og[297](javascript:footNote('T105008/note297.html')), heir apparent to the chieftainship of the Hy-Fiachrach; Conchobhar,[298](javascript:footNote('T105008/note298.html')) and William, Bishop of Killala[299](javascript:footNote('T105008/note299.html')). The daughter of O'Flynn was the mother of these sons of Donnchadh Mor.


Connchobhar, the son of Donnchadh, left no issue, except daughters.


William, the bishop, had two sons, namely, Cosnamhaigh[300](javascript:footNote('T105008/note300.html')), who was slain in the battle of the Strand, and William Og; both died without issue.


Donnchadh Og, the son of Donnchadh Mor, had a large family, namely, Muircheartach Cleireach[301](javascript:footNote('T105008/note301.html')), designated king and bishop, for 



---

p.119



his hospitality and valour; Taithleach[302](javascript:footNote('T105008/note302.html')); Aodh, of Corran; Lochlainn; Brian Cleireach, and Cormac. Honora, the daughter of Rickin Barrett, was the mother of all these.


Muircheartach, the son of Donnchadh Mor, had a large family, namely, Domhnall, Cathal, Conchobhar[303](javascript:footNote('T105008/note303.html')), and Cosnamhaigh, whose mother was Dearbhail, the daughter of Flaithbheartach O'Rourke; and Donnchadh[304](javascript:footNote('T105008/note304.html')), another son of his, whose mother was Dearbhail, the daughter of Tadhg Mac Donogh. William Mac Muircheartaigh was another son of his.


Brian, the son of Taithleach[305](javascript:footNote('T105008/note305.html')) O'Dowd, had a large family, namely, Domhnall Cleireach[306](javascript:footNote('T105008/note306.html')), King of Hy-Fiachrach; Maolruanaidh[307](javascript:footNote('T105008/note307.html')); Maghnus Cleireach[308](javascript:footNote('T105008/note308.html')). Barrdubh, the daughter of Domhnall O'Conor, was their mother. His other sons were Diarmaid and Aodh, whose mother was the daughter of Roibin Laighleis *[Robin Lawless]*, and Cosnamhaigh, Niall, Taithleach, and Brian Og[309](javascript:footNote('T105008/note309.html')), whose mother was Honora, the daughter of Mac Wattin Barrett.


Maolruanaidh, son of Brian, had one son, namely, Taithleach, father of William and of Brian.


Aodh, son of Brian, had good sons, namely, Brian and Diarmaid 



---

p.121



(Meadhbh, the daughter of Domhnall Ruadh O'Maille, was the mother of both). Muircheartach, Lochlainn, and Taithleach were his other sons. From this Lochlainn are the Sliocht Lochlainn of Bun Finne[310](javascript:footNote('T105008/note310.html')), whose inheritance consists of eight quarters of land. The most distinguished of this sept are Brian, Fedhlim, William, and Eoghan, the sons of Ruaidhri, son of Eoghan of Ceathramha Lochain[311](javascript:footNote('T105008/note311.html')).


Domhnall Cleireach, the son of Brian O'Dubhda, had a large family, namely, Ruaidhri[312](javascript:footNote('T105008/note312.html')), King of Hy-Fiachrach, Eoghan, Maghnus, Maoileachlainn, heir apparent of Hy-Fiachrach, Tadhg Riabhach[313](javascript:footNote('T105008/note313.html')) (Fionnghuala, the daughter of Domhnall Ruadh O'Maille, was the mother of these sons); John and Domhnall (Teamhair, the daughter of O'Muirgheasa, was their mother); Donnchadh, Diarmaid[314](javascript:footNote('T105008/note314.html')), Domhnall, and Aodh (Fionnghuala, daughter of Maghnus, son of Cathal O'Conor, was their mother). He had another son, Eoghan[315](javascript:footNote('T105008/note315.html')) (the daughter of O'Cathain was his mother).


Tadhg Riabhach had good sons, namely, Brian, Donnchadh Ulltach[316](javascript:footNote('T105008/note316.html')) (Eudoin, daughter of Domhnall, son of Muircheartach O'Conor, was their mother); Tadhg Buidhe[317](javascript:footNote('T105008/note317.html')), John (Margaret, 



---

p.123



daughter of William, son of Sir Redmond Burke, was their mother). His other sons were another John, Niall, Domhnall, Aodh, and Taithleach. Though this family, and those who branched off from them, were *once* great at Ard na Riagh[318](javascript:footNote('T105008/note318.html')), Esgir Abhann[319](javascript:footNote('T105008/note319.html')), Baile Ui Mhochaine[320](javascript:footNote('T105008/note320.html')), Baile an Chaislen[321](javascript:footNote('T105008/note321.html')), and Longphort Ui Dhubhda[322](javascript:footNote('T105008/note322.html')), not one of their descendants are now living in Tir Fhiachrach *[Tireragh]*.


The aforesaid towns were the castle-towns of the race of Tadhg Buidhe, son of Tadhg Riabhach. It was the English that erected *all* the bawn of the Longphort *[Longford]*, except Leabha an Eich Bhuidhe[323](javascript:footNote('T105008/note323.html')) which was erected by Sen Bhrian *[O' Dowd]*. Donnchadh, the son of Tadhg Riabhach, erected Baile an Chaislen *[Castletown]*. Esgir Abhann was erected by the Albanach Mor[324](javascript:footNote('T105008/note324.html')) *[Big Scotchman]*, the foster-father of Tadhg Buidhe, son of Tadhg Riabhach. Baile Ui Mhochaine *[Ballymoghany]* was erected by Tadhg Riabhach himself.




---

p.125


Baile Aird na Riagh *[Ardnarea]* was built by the English. These towns, and many others, were on the territorial division of Tadhg Buidhe.


This Tadhg had these sons, following, viz., Maghnus, Fedhlim, John Glas, Eoghan, Aodh, Conchobhar, and Donnchadh. John Glas, Eoghan, Conchobhar, and Donnchadh fell in defending their native territory. Maghnus and Fedhlim went to the Clann-William *[Burkes]*; and Aodh, from the relationship of his grandmother *to the family of O'Maille,* repaired to Umhall Ui Mhaille, and remained there for three quarters of a year, committing vengeful aggressions by land and sea upon the race of Ruaidhri, son of Domhnall Cleireach, until at length it repented him of what he had committed against God; for which reason, and by the advice of a certain pious anchorite, he betook himself to the protection of the English, to seek repose and the will of God; and where he dwelt was at a place three miles to the east of Droichead Atha[325](javascript:footNote('T105008/note325.html')), where a son was born to him whose 


---

p.127




name was Aodh Og. Three years after this Aodh Mor died, and left his son with a rich farmer of the family of O'Quin, who reared him honourably, and gave him his sister in marriage, and she brought forth for him three sons, namely, John, Thomas, and Henry, besides daughters. After the death of this wife he married the daughter of Bhaliseach[326](javascript:footNote('T105008/note326.html')) of Oldbridge, and she brought forth a son for him, namely, George, the father of William, Giolla-Patrick, John[327](javascript:footNote('T105008/note327.html')), Edward, Thomas, Richard, and Francis. These are the genealogical ramifications of the *family of* O'Dubhda,who are *now* in Ath Cliath[328](javascript:footNote('T105008/note328.html')) Duibhlinne *[Dublin]*.


It is the general tradition, and it is written in the Books of the Clann Firbis, that Dowdall, with his correlative kindred, is of the family of O'Dubhda, and that the period at which he left Tir Fiachrach was the time of the killing of Taithleach of the Moy O'Dubhda, by the English, Anno Domini *[1282]*; so that they were called Dowdalls by the English, as their own history relates[329](javascript:footNote('T105008/note329.html')), which would be tedious to be given here.




---

p.129


Domhnall Og, son of Domhnall Cleireach, had issue, namely, Ruaidhri, Diarmaid, and Edmond.


Ruaidhri, son of Domhnall Cleireach, had issue, namely, Maolruanaidh[330](javascript:footNote('T105008/note330.html')), Conchobhar, Maghnus Cleireach (Eileog, daughter of John Mac Costello, was their mother), Muircheartach, Eoghan, and William[331](javascript:footNote('T105008/note331.html')), (Anabla, daughter of Sir Redmond Burke, was their mother).


Cosnamhaigh, son of Brian, son of Taithleach O'Dowd, had issue, namely, Brian[332](javascript:footNote('T105008/note332.html')), Aodh, Muircheartach, John, and Edmond[333](javascript:footNote('T105008/note333.html')).


Maolruanaidh, son of Ruaidhri, had issue, namely, Diarmaid, Domhnall Ballach[334](javascript:footNote('T105008/note334.html')), Maoileachlainn, ancl Muircheartach Caoch, who died without issue; and *a second,* Maoileachlainn.


Eoghan[335](javascript:footNote('T105008/note335.html')), Fearadhach, Ruaidhri, Cormac the friar, Cathal Dubh[336](javascript:footNote('T105008/note336.html')), Dathi, John Glas, and Brian, were the sons of Conchobhar, son of Diarmaid, son of Maolruanaidh.


Fearadhach had a son Domhnall, father of Eoghan who died issueless.


Ruaidhri, son of Conchobhar, had a son Diarmaid, the father of Ruaidhri, Fearadhach, Domhnall, Conchobhar, and John Glas.


Dathi, son of Conchobhar, had issue, namely, Fearadhach, Donncatha, Cathaoir, Cormac, Fiachra, and Amhalgaidh of the River Daoil.




---

p.131


John Glas, son of Conchobhar, had two sons, namely, Cormac and Brian.


Eoghan, son of Conchobhar, had issue, Tadhg Riabhach[337](javascript:footNote('T105008/note337.html')), Edmond, Ceallach, and Conchobhar, the father of Tadhg Riabhach, who was the father of Eoghan and Edmond.


Tadhg Riabhach, the son of Eoghan, had issue, namely, Dathi[338](javascript:footNote('T105008/note338.html')), Tadhg Buidhe[339](javascript:footNote('T105008/note339.html')), Fearadhach (father of Cathal Dubh, a friar), Domhnall, Maolruanaidh, who died without issue, Eoghan, and John Og, father of Tadhg Riabhach and Donnchadh.


[Dathi Og[340](javascript:footNote('T105008/note340.html')) O'Dubhda, now living, 1666, 
  
{column 1}
  

son of James,
  

son of Dathi,
  

son of Dathi,
  

son of Tadhg Riabhach, 
son of Eoghan, i. e. the O'Dubhda,
  

son of Conchobhar,
  

son of Diarmaid,
  
 
son of Maolruanaidh,
  

son of Ruaidhri, i. e. the O'Dubhda,
  

son of Domhnall Clereach, i. e. the O'Dubhda,
  

son of Sen Brian, i. e. the O'Dubhda,
  

son of Taithleach of the Moy,
  

son of Maolruanaidh,
  

son of Donnchadh,
  

son of Aodh,
  
{column 2}
  

son of Taithleach,
  

son of Aodh,
  

son of Taithleach,
  

son of Aodh,
  

son of Muirchertach,
  
 
son of Aodh,
  
 
son of Taithleach,
  
 
son of Niall,
  
 
son of Maoileachlainn,
  
 
son of Maolruanaidh,
  
 
son of Aodh,
  
 
son of Ceallach,
  
 
son of Dubhda, from whom the tribe,
  

son of Connmhach,
  
 
son of Donncatha,
  



---

p.133


{column 1}
  

son of Cathal,
  

son of Oilioll,
  

son of Dunchadh,
  
 
son of Tiobraide,
  
 
son of Maolduin, i. e. Maoldubh,
  
 {column 2}
  

son of Fiachra Ealgach,
  

son of Dathi, King of Ireland,
  

son of Fiachra,
  

son of Eochaidh Muighmheadhoin,
  

King of Ireland].


{column 1}
  
William Og, Christopher, Dathi, and Fiachra, are the
  

sons of William,
  

son of Dathi,
  
{column 2}
  

son of Tadhg Riabhach, &c.


{column 1}
  
Maolruanaidh and Tadhg Buidhe, a friar,
  
 
sons of Tadhg Buidhe,
  
 {column 2}
  

son of Tadhg Riabhach, &c.


{column 1}
  
Tadhg Riabhach, Fearadhach, and Ruaidhri,
  
 
sons of Domhnall,
  

son of Tadhg Riabhach,
  
{column 2}
  

son of Eoghan.


{column 1}
  
Cathal Dubh, i. e. the O'Dubhda,
  

son of Edmond,
  
 
son of Eoghan,
  
{column 2}
  

son of Conchobhar.


{column 1}
  
Ceallach,
  

son of Brian,
  

son of Ceallach,
  
{column 2}
  

son of Eoghan,
  

son of Conchobhar.


### The Race of Ruaidhri, son of Conchobhar


{column 1}
  
Ruaidhri,
  

son of Dathi,
  

son of Ruaidhri,
  

son of Diarmaid,
  

son of Ruaidhri,
  
 
son of Conchobhar,
  
{column 2}
  

son of Diarmaid,
  
 
son of Maolruanaidh,
  
 
son of Ruaidhri,
  

son of Domhnall Clereach.




---

p.135


{column 1}
  
Brian,
  

son of Cathaoir,
  

son of Fearadhach,
  

son of Diarmaid,
  
{column 2}
  

son of Ruaidhri,
  

son of Conchobhar.


{column 1}
  
Domhnall Og and Eoghan, two sons of Domhnall, i. e. the O'Dubhda,
  

son of Diarmaid,
  
{column 2}
  

son of Ruaidhri,
  
 
son of Conchobhar.


### The Race of John Glas, son of Conchobhar


John Glas, Dathi, Diarmaid (the father of Tadhg); Maoileachlainn Caoch, Eoghan, Charles (father of Patrick, and of Donnchadh a friar); Fiachra (father of Thomas); and John (father of Diarmaid), were
  
{column 1}
  

sons of Brian,
  

son of John Glas,
  
{column 2}
  

son of Conchobhar,
  

son of Diarmaid.


{column 1}
  
Brian and Eoghan,
  

sons of John Glas,
  

son of Brian,
  
{column 2}
  

son of John Glas.


{column 1}
  
Cormac, Eoghan, and Domhnall Og, 
  

sons of Domhnall,
  

son of Cormac,
  
{column 2}
  

son of John Glas
  

son of Conchobhar.


[341](javascript:footNote('T105008/note341.html'))
### Of Dun Neill


William Og, Eoghan Carrach, who was slain at Cnoc na n-os[342](javascript:footNote('T105008/note342.html')), 
and Domhnall Ballach, three
  
{column 1}
  

sons of Fedhlim,
  

son of Edmond Buidhe,
  
{column 2}
  

son of William Og,
  

son of Domhnall Ballach,
  



---

p.137


{column 1}
  

son of Maolruanaidh,
  

son of Ruaidhri,
  
{column 2}
  

son of Domhnall Clereach.


{column 1}
  
Calbhach,
  

son of William Caoch,
  

son of Calbhach,
  

son of Tadhg,
  

son of Brian,
  
{column 2}
  

son of Diarmaid,
  

son of Maolruanaidh,
  

son of Ruaidhri,
  

son of Domhnall Clereach.


### The Race of Cosnamhach here


Ruaidhri, William Ballach, and Felim,
  
{column 1}
  

sons of Cosnamhach,
  

son of John,
  

son of Felim,
  
{column 2}
  

son of Aodh,
  

son of Cosnamhach,
  

son of Sen Brian.


### The Clann Taithligh here


{column 1}
  
Corc, Taithleach, and John, three sons of Ruaidhri,
  

son of Conchobhar,
  

son of Taithleach Og,
  

son of Muircheartach na Fuineoige,
  

son of Taithleach,
  

son of Aodh Alainn,
  
{column 2}
  

son of Maoileachlainn,
  

son of Brian Dearg,
  

son of Aodh, in whom they and the chiefs meet,
  

son of Niall,
  

son of Maoileachlainn.


{column 1}
  
Muircheartach Leghinn,
  

son of Maolruanaidh,
  

son of Conchobhar Déseach,
  

son of Aodh Alainn,
  

son of Maoileachlainn,
  
 {column 2}
  

son of Brian Dearg, who was drowned on his way from Rome after his pilgrimage.




---

p.139


Misdel *[Mitchel]*, from whom the Clann Misdel and the *family of* Mac Finn O'Dubhda, with their correlatives, 
  
{column 1}
  

son of Maolruanaidh,
  
 
son of Conchobhar Deseach,
  
{column 2}
  

son of Aodh Alainn.


Domhnall, prior of Eachros[343](javascript:footNote('T105008/note343.html')),
  
{column 1}
  

son of Tadhg,
  

son of Domhnall,
  
{column 2}
  

son of Aodh,
  

son of Muircheartach na Fuinneoige.


Aodh Ruadh, Diarmaid, and Taithleach, three sons of Conchobhar,
  
{column 1}
  

son of Taithleach,
  

son of Conchobhar Conallach,
  

son of Taithleach,
  

son of Donnchadh Mor,
  
{column 2}
  

son of Aodh,
  

son of Taithleach,
  

son of Aodh,
  

son of Muircheartach.


Thomas and Maoileachlainn Mor,
  
{column 1}
  

sons of Aodh,
  
{column 2}
  

son of Conchobhar Conallach.


Ruaidhri Mor,
  
{column 1}
  

son of Taithleach,
  
{column 2}
  

son of Conchobhar Conallach.


The privileges of the race of Caomhan, the son of Connmhach, according to the ancient literati, which were obtained by Aodh, son of Cathal O'Caomhain[344](javascript:footNote('T105008/note344.html')) from Ceallach, the son of Dubhda, and from Aodh, son of Ceallach[345](javascript:footNote('T105008/note345.html')), as a compensation and consideration of kindred, 



---

p.141



after he *[i. e. Aodh O'Caomhain]* had been cursed by Gerald, the Saxon saint (according to the Dumb Book of James Mac Firbis), with his three hundred saints, in consequence of the wife of O'Caomhain[346](javascript:footNote('T105008/note346.html')), who turned him, late in the evening, out of the door of Caomhan's fort (which is called Cathair mhor); so that St. Gerald cursed Caomhan and his seed, and prayed that there should not be a king of his race for ever. When Aodh heard this, he became sorrowful for the curse pronounced against his grandfather by the angry saint, in consequence of the misconduct of the malicious woman, who had issue; so that he went to where St. Gerald was to appease him; and though he did appease him, it was of no avail to Aodh, for Gerald did not consent to make peace with any one descended from the woman who had insulted him, but he consented that the chieftainship of the O'Caomhains should be transferred to the race of Diarmaid, son of Cathal, son of Caomhan[347](javascript:footNote('T105008/note347.html')), that is, to the 



---

p.143



son of the handmaid of the denounced woman, but that none of his race should ever expect to be kings *of all the Hy-Fiachrach*. And the compensations they obtained for this transfer of the lordship were the following, viz., a tuath of every territory which their *reigning* relative possessed from the *river* Rodhba[348](javascript:footNote('T105008/note348.html')), to the *river* Codhnach[349](javascript:footNote('T105008/note349.html')), and the privilege of first sitting in the drinking house, and of arraying the battle; *that O'Dubhda* is to stand up before him whenever he meets him, or wherever he may be; *that O'Caomhain is to take* the first drink and bath; and that whoever takes his first arms[350](javascript:footNote('T105008/note350.html')) in his territory, he should take them from the descendants of Diarmaid, son of Cathal, son of Caomhan; also that they should get the Luach leasa of every



---

p.145



king's daughter *and* the steed and battle-dress of every king among them for ever, after his being inaugurated; and that the like should be given by them to the Ollamh, that is, to Mac Firbis.


Or, *if we believe others,* it was St. Gerald that baptized Dubhda[351](javascript:footNote('T105008/note351.html')), from whom the chiefs are descended, and it was Caomhan himself that obtained these privileges, together with many others (as we have stated in the genealogy), from Dubhda, in consideration of the chieftainship.




---

p.147




---

p.149


[352](javascript:footNote('T105008/note352.html'))
Hereditary Proprietors of the Clann Fiachrach
---------------------------------------------


### Of the Men of Ceara here


Three triocha cheud[353](javascript:footNote('T105008/note353.html')) of Ceara; there were three kings over it, namely, O'Muireadhaigh, O'Gormog, and O'Tighernaigh. Its full extent[354](javascript:footNote('T105008/note354.html')) is from the Rodhba[355](javascript:footNote('T105008/note355.html')) to Rathain[356](javascript:footNote('T105008/note356.html')), and from Fionnghlais[357](javascript:footNote('T105008/note357.html')) to Maiteog[358](javascript:footNote('T105008/note358.html')) of Achadh Gabhair[359](javascript:footNote('T105008/note359.html')), as the rann states: 


> 1. From Rodhba to Rathain the red
>   
> Is the country of Ceara, which the hosts defend,
> 
> 
> ---
> 
> p.151
> 
> 
> From Fionnghlais, which the hounds frequent,
>   
> To Maiteog of Achadh gabhair.
> 




The chieftainship of O'h-Uada and O'Cinnchnamha from Maiteog to Callainn, and from Bunreamhar[360](javascript:footNote('T105008/note360.html')) to Abhainn na Mallachtan[361](javascript:footNote('T105008/note361.html')).




---

p.153


The tuath of Partraighe[362](javascript:footNote('T105008/note362.html')) extends from Ath na Mallachtan[363](javascript:footNote('T105008/note363.html')) to Glaisi Guirt na Lainne[364](javascript:footNote('T105008/note364.html')), and from Caol[365](javascript:footNote('T105008/note365.html')) to Fal[366](javascript:footNote('T105008/note366.html')). And O'Gairmiallaigh was its king and O'Dorchaidhe its toparch; or, it was the lordship of O'Dorchaidhe alone, according to the book of James and Giolla Iosa Mac Firbis.


O'Banan of Baile Ui Bhanan[367](javascript:footNote('T105008/note367.html')), and Magilin of Muine[368](javascript:footNote('T105008/note368.html')), i. e. two Mac Oglaoichs[369](javascript:footNote('T105008/note369.html')).


The tuath of Magh na Bethighe[370](javascript:footNote('T105008/note370.html')) *extends* from Callainn[371](javascript:footNote('T105008/note371.html')) to Uluidh Caolainn[372](javascript:footNote('T105008/note372.html')), that is, the seven ballys of Lughortan, the estate of Mac an Bhainbh.




---

p.155


O'h-Aodha of Baile Craoibhe, i. e. Baile an Tobair.


The estate of O'h-Uathmharain, i. e. Baile Cagail.


The estate of O'Learghusa, i. e. Baile Cille Buainne[373](javascript:footNote('T105008/note373.html')).


The chief seats of Ceara *are* Feart Lothair, Loch m-Buadhaigh, and Aonach.


The tuath of Magh Fhiondalbha, *containing* fifteen townlands, *is* the estate of O'Cearnaigh. *It extends*[374](javascript:footNote('T105008/note374.html')) from Crannan Tornaighe (or Ran Tornaighe) to Caisiol Cairpre.


The estate of O'h-Edhneachain, i. e. the three townlands of Magh na Cnocaighe, and the three townlands of Baile Riagain[375](javascript:footNote('T105008/note375.html')), viz., Baile an Chriochain Bhuidhe[376](javascript:footNote('T105008/note376.html')), Baile an Smotain[377](javascript:footNote('T105008/note377.html')), and Baile na Greallcha[378](javascript:footNote('T105008/note378.html')); and the three townlands of Fiodh Cruaiche[379](javascript:footNote('T105008/note379.html')), viz., Baile Ui Ruairc[380](javascript:footNote('T105008/note380.html')) and Baile na Leargan Moire.


The estate of O'Ciaragain, the townland of Bel na Lece[381](javascript:footNote('T105008/note381.html')).


The estate of O'Coigligh, i. e. Baile Carnan Tornaidhe[382](javascript:footNote('T105008/note382.html')), or Ran Tornaidh.


The estate of Mac Giolla Fhaolain, i. e. the townland of Magh Roisen[383](javascript:footNote('T105008/note383.html')).




---

p.157


The estate of O'Cuachain *is* Baile Lis Aiche[384](javascript:footNote('T105008/note384.html')), which is called Baile an Regles[385](javascript:footNote('T105008/note385.html')).


The estate of O'Maolraite *is* Oireamh, and Braonros, Iomaire, and Cul an Daingin.


The estate of O'Faghartaigh, the three townlands of Tulach Spealan.


The estate of O'Brogain, Tulach Spealain.


The lordship of O'Cearnaigh also *comprised* the twenty-four townlands of the Termon of Balla.


The estate of O'Caomhain, in Ceara[386](javascript:footNote('T105008/note386.html')), *comprised* the seven townlands of Ros Laogh[387](javascript:footNote('T105008/note387.html')), i. e. *the tract extending* from Cluain Lis Nellin[388](javascript:footNote('T105008/note388.html')) to Beul Atha na Lub[389](javascript:footNote('T105008/note389.html')) and from Beul Atha na g-Carr[390](javascript:footNote('T105008/note390.html')) to Muilenn Tiormain[391](javascript:footNote('T105008/note391.html')), which estate was obtained by Caomhan, son of Connmhach from Dubhda, his *own* brother, and by Aodh O'Caomhain from Aodh, son of Ceallach O'Dubhda, King of Hy-Fiachrach, for there was found no district without its hereditary proprietor of the race of Earc Culbhuidhe, except this well known Attacottic district[392](javascript:footNote('T105008/note392.html')), named Tuath 



---

p.159




Ruisen[393](javascript:footNote('T105008/note393.html')); so that it has been the hereditary patrimony of the *family of* O'Caomhain ever since, besides many other districts.


The lordship of O'Ruaidhin *extends* from Beul Atha na Lub to the causeway of Cillin na n-Garg[394](javascript:footNote('T105008/note394.html')), and of his tribe is the family of O'Culachain[395](javascript:footNote('T105008/note395.html')).


The lordship of O'Birn *extends* from the causeway of Cillin na n-Garg to Beul Atha na Sesidh, Roibin Beag being on the east side; and from Sighin Ciarain to Tobar Lughna.


The lordship of O'Goirmghiolla *extends* from Tobar Lughna to the ford of Caol Patraighe, and from the Rodhba to Raithleann. It contains seven townlands and a half.


The three townlands of Criathach *are* the estate of O'Maoilcana, and of the family of Mac Giolla Bhuidhe of Cillin na m-Buidhean, in Criathrach.


So far the hereditary proprietors of Ceara. Giolla an Ghoill Mac Neill was the last King of the Gaels, who possessed Ceara: he was cotemporary with Taithleach Mor (son of Aodh O'Dubhda), who took possession of the country extending from the River Rodhba to the Codhnach, and was interred at Baile Tobair Padraig[396](javascript:footNote('T105008/note396.html')). [And the person who was bishop[397](javascript:footNote('T105008/note397.html')) in the time of these kings was Mael Isa Mag Mailin].




---

p.161


### Clann Cuain down here.


The Clann Cuain are the next to *the men of* Ceara in point of genealogical relationship[398](javascript:footNote('T105008/note398.html')), for they are both of the race of Earc Culbuidhe, the son of Fiachra.


O'Cuinn, O'Maoilfhiona, and Mag Fhlannagain *were* the three chiefs of Clann Cuain. They are otherwise called Fir Thire, and also Fir Siuire, from a river of the name Siuir[399](javascript:footNote('T105008/note399.html')), which flows by the town, at this day called Caislen an Bharraigh[400](javascript:footNote('T105008/note400.html')).


Cuan (son of Eochaidh, son of Flann, son of Fearadhach, son of Ros Doimtheach, son of Maine Muinbreac, son of Earc Culbhuidhe, son of Fiachra) is the ancestor of the Clann Cuain with their correlatives, as the rann says: 

> 1. Cuan Mor, son of the generous Eochaidh,
>   
> From him *are* the Clann Cuain of smooth mounds,
>   
> And the Fir Thire of tribes,
>   
> A people without fault in faith.
> 






---

p.163


The cause of the separation of the Clann Cuain and the Fir Thire from the Clann Fiachrach, was this: Ruaidhri Mear[401](javascript:footNote('T105008/note401.html')), the son of Taithleach, son of Niall O'Dubhda, a king who had possession of *the country extending* from the Rodhba to the Codhnach, went on a regal visitation to the house of Domhnall O'Cuinn, chief of Clann Cuain; and it happened that O'Cuinn had at that time a beautiful marriageable daughter, and O'Dubhda did not content himself without getting her by force that night, so that O'Cuinn slew him treacherously on the next day, and went himself under the protection of the Clann Maoilruanaidh, viz., of Tomaltach Mor Mac Dermot[402](javascript:footNote('T105008/note402.html')), and they *[the Clann Cuain]* gave themselves and their patrimonial inheritance up to them, *which continues so* from that to the present day.


These are called Fir Thire upper, and Fir Siuire abhus (citra) from the river, as we have said before.


[403](javascript:footNote('T105008/note403.html'))[404](javascript:footNote('T105008/note404.html'))
### The Territorial Distribution of Hy-Amhalgaidh and Hy-Fiachrach here; with their Hereditary Proprietors.


In Iorrus first the first estate is bestowed.


O'Caithniadh *was* the chief of Iorrus, and O'Ceallachain the 



---

p.165



toiseach of Iorrus. The Brughaidhs of Iorrus *were the families of* Mac Coinin, O'Conboirne, O'Muimhneachain, O'Gearadhain, and Mag Fhionain.


The hereditary proprietors of Dun Fine *were the families of* O'Cuinn, Mag Odhrain, O'Comhdhain, O'Duibhlearga, O'Bearga, O'Blighe, O'Duanmaighe, O'Radubhain of Baile an Ghleanna, Mac Conletreach of Baile Mec Conletreach, O'Conghaile and O'Cathasaigh, airchinnechs of Cill Ardubh. The chief of the Lagan *was* O'Muireadhaigh; O'Fionnagain of Fionnchalamh[405](javascript:footNote('T105008/note405.html')).


[406](javascript:footNote('T105008/note406.html'))
### The Tribes of Breudach [etc.] here.


O'Toghdha was chief of Breadach; O'Luachain, in the western side of Breudach, and *also* O'Gilin; O'Gloinin of Rath na n-Goirmghiall; O'Gaibhtheachain and O'Maoilfhiona, *were the* two chiefs of Calraighe; O'Flainn, brughaidh of Magh h-Eleag; O'Lachtna *was* chief of the two Bacs, and of Gleann Nemhthinne; Lachtna *was* a Mac Firbis; O'Flanngaile *was* over Loch Glinne, with its land; O'Floinn in Oireamh of Loch Con; O'Maoilruaidh of Ard Achadh and of Cill Bealad, or Cill Ealad; O'h-Eineachain of Baile Ui Eineachain; O'Leathcaile of the townland of Magh Fuara; Mac Conlena of Cill Mor Muaidhe; O'Dubhagain and O'Airmeadhaigh of Loch Muighe Broin, *and* the Clann Firbisigh, the poets of Hy-Amhalgaidh of Ros Serce.


Hy-Eachach Muaidhe extends from Ros Serce to Fearsad Tresi. These are its tribes, viz., O'Maoilfaghmhair, comharbas of Cill
Allaidh, O'Leannain, O'Criaidhchen, O'Laitile, O'Mochain, O'Maoilaithghen, O'Broduibh, and O'Maoilbhrenuinn.




---

p.167


The following are the tribes of Caille (or Caoille) Conaill, which extends from Fearsad Tresi to Traigh Murbhaigh, that is, Traigh 
Ceall, and northwards to Cill Cuimin, viz., O'Derig, O'h-Aodha of Ard O'n Aodha, O'Maolchonaire, O'Flannabhra, and O'Seaghsa. And of them *also* are *the families of* O'Congadan, or O'Connagain of Magh Gamhuach, O'h-Arain of Ardgabhail. The district of Caeille is Baile na Leacan, from the Fearsad, to Traigh Murbhaigh, &c., according to another book.


[407](javascript:footNote('T105008/note407.html'))
### The Hereditary Proprietors of Tir Fhiachrach down here.


The estate of O'Morain, i. e. Ard na Riagh, and his chieftainship the district thence to Tuaim da Odhar. O'Brogain of Breachmhagh.


There *were* four chiefs over Cuil Chearnadha, *which extends* from Beul Atha na n-Idheadh[408](javascript:footNote('T105008/note408.html')) to the road of Breachmhagh, namely, O'Fionain, O'Rothlain, O'h-Iornain (or O'Tuathalain), and O'Cuinn. O'h-Eana of Imleach Loisge; O'Gealagain of Cill Iochtair, i. e. Grainseach; O'Breslen of Cill Fhaindle, or Cill Ainnle.


The country of O'Caomhain *extends* from Tuaim da Bhodhar to Gleoir, and his hereditary tribes or retainers *were the families of* Mac Cailleachan, or Caoilleachan, or Ceallachan of Carn; O'Coitil of 
Baile Ui Choitil; O'Floinn of Beartrach and of Mucdhubh; O'Mochaine of Baile Ui Mhochaine; O'h-Iomhair of Leacan; — (the 
Clann Firbhisigh were of Leacan Mhic Fhirbhisigh afterwards, where they wrote books of history, annals, poetry, and *kept* a school of history; and where, a long time after *their original settlement there,* Ciothruaidh and James, the two sons of Diarmaid Caoch Mac Firbis, 



---

p.169



and John Og, the son of William, their father's brother, erected the castle of Leacan Mac Firbis, in the year of the age of Christ 1560[409](javascript:footNote('T105008/note409.html'));) — O'Loingseachain of Mullach Ratha; O'Sbealain of Coillin, and it was he that erected the great rath[410](javascript:footNote('T105008/note410.html')); O'Fualairg of Rath Bearchain; *and* O'Connachtain of Cabrach.


The chief seat of O'Caomhain *was* Saidhin Uisge tar abhainn, which is *otherwise* called Inis Sgreabhainn[411](javascript:footNote('T105008/note411.html')). Though it is said that the Clann Neill took these lands, it was not by hereditary right they took them, but by force, after having slain David O'Caomhain and Domhnall O'Caomhain, so that the Clann Neill were for a while in the chieftainship, until Niall, son of Niall, was slain by Muircheartach Fionn O'Caomhain, in revenge for *the loss of* his land.


Of *the tract extending* from the river Gleoir to the Iasgach O'Murchadha, or O'Maolduin, *was* the chieftain. The estate of O'Ruadhrach *was* Lia Con, and Iochtar Ratha. O'Fenneadha *was proprietor* of Finnghid until the family of O'Flannghaile[412](javascript:footNote('T105008/note412.html')) took it from him, after they had been driven from their *own* estate from the lake downwards by the English. O'Maoilduin of Imleach Iseal; O'Luachain of Ros Laogh; O'Duibhscuile of Dun Maoilduibh. The 



---

p.171



estate of O'Rothlain was Cluain na g-Cliabhach and Alt Fharannain, until the family of O'Maonaigh deprived them of it by a treachery which shall not be written here[413](javascript:footNote('T105008/note413.html')); O'Beollan of Dun Ulltain; O'Conbhuidhe of Baile Mec Giollachais, and of Dun Neill, *which is called from Niall,* son of Cubuidhe[414](javascript:footNote('T105008/note414.html')), and Cuanan, from whom Rath Cuanain, was *another* son of Cubuidhe; and it is said that O'Conbhuidhe *was once* chief of the tract extending from Dun Neill to Muirisg; and the Dumb Book of James Mac Firbis states that O'Conbhuidhe was chief *of the tract extending* from Ath Cliath Muirsge[415](javascript:footNote('T105008/note415.html')) to the river Iascach. The families of Mac Eoghain and O'Cuanan of Dun m-Becin; O'Discin of Baile Ui Dhiscin; O'Dunghaile, O'Suidhlearga and O'Cuain of Dun Ui Chobhthaigh; O'Colmain of Grainseach Mor; O'Fuala of Grainseach Beag; O'Ceallaigh of Ard O'g-Ceallaigh; O'Loingsigh and O'Caomhain an Chuirrigh of Muine na bh-Fiadh [or Muine Dhiadh[416](javascript:footNote('T105008/note416.html')) at this day].


O'Flannghaile in Eachros; *the families of* Mac Giolla na n-Each, O'Flannghaile, and Mac Giolla Duibh, in the Corcachs; O'Sionna, in Lathrach. The pillars of Sgrin *were the families of* Mac Concathrach, O'h-Oilmhec, Mag Rodan, O'Sneadharna and O'Rabhartaigh.




---

p.173


The Dumb Book of James Mac Firbis *enumerates* the pillars of Sgrin *as follows*: — ‘The families of O'Rabhartaigh, Mac Carraoin[417](javascript:footNote('T105008/note417.html')), O'Flannghaile, and O'Tarpaigh[418](javascript:footNote('T105008/note418.html')), are the pillars of Sgrin, and the props of the Kings of Hy-Fiachrach if *I give them as they were* in my own time, the hereditary proprietors which I saw remaining in Sgrin, were the families of Mac Carraoin and Mac Giolla na n-Each, and there was a remnant of the O'Rabhartaighs there, but the Saxon heretics of Alba[419](javascript:footNote('T105008/note419.html')) did not leave their inheritance to them.’


O'Baothghaile of Cluain Ui Chosgraigh; Mac Giolla Finn (or Mac Finn O'Flannghaile) of Leamhach; Mac Giolla Bricin of Ard na n-Glas; Mac Giolla Mhir of Fionnabhair; Mac Giolla Riabhach of Criochan; O'Liathan of Muine Fede, or Bun Fede; Mac Conluain (or Anluain) of Cuil Cille Bricin; Mac Giolla Bhain of Lios na Reamhur; O'Duinchinn of Doire na n-Ath; O'h-Aodha of Toin re go; ODunchadha of the tract extending from Coillte Luighne to Beal Atha na Muice; Lios Ladhghuill is the chief seat of that district.


*Of the people who inhabited the tract extending* from Borrach to the Strand, O'Muirgheasa is chieftain, and of these O'Maonaigh *is one.* According to a different authority ‘*the families of* Mac Firbis, O'Maonaigh, and O'Muirgheasa were lords of the tract *extending* from Borrach to the Strand.’ From Borrach to Muirisg, O'Maoilduin is chief of that district.


### The Chief Seats of the Kings of the Hy-Fiachrach here, viz.:


Dumha Caochain, in Iorras; Inis Mochua[420](javascript:footNote('T105008/note420.html')), at Loch Con; Eanach Dubhain; Rath Branduibh, in Tir Amhalgaidh; Caislen mic Conchobhair, 



---

p.175



or Dun mic Conchobhair; Iochtar Ratha, Dun Cinn Treathain, or Dun Contreathain, the two Draighneachs [on Lios na Draighnighe is the Bawn of Ceathramh an Chaisil[421](javascript:footNote('T105008/note421.html')) at this day], and Bun Finne, in Tir Fhiachrach.


The chief seat of O'Caomhain *was* Soighen Uisge tar abhainn, which is called Inisgreabhuinn. The chief seat of O'Murchadha was Imlioch Iseal, and the chief seat of O'Conbhuidhe *was* Dun Neill.


The English drove these chieftains[422](javascript:footNote('T105008/note422.html')) from their patrimonial inheritances (which we have enumerated), but Sen Bhrian[423](javascript:footNote('T105008/note423.html')) son of Taithleach Muaidhe O'Dubhda, took the country (particularly Tir Fhiachrach) from the English; but though he did, I think that many of the same *old* chieftains did not get much hold of their hereditary districts from him, for *it is certain that* the sons, grandsons, and great grandsons of Sen Bhrian divided the land among hemselves, though they do not possess it at this day. And moreover, but very few of the *descendants of the* chieftains already mentioned *now* exist (even their very surnames, were they of any importance, do not remain[424](javascript:footNote('T105008/note424.html')); and this is not all, but the people of these *our own* times wonder that such as they should have ever been in power, in consequence of their fewness and feebleness at this day. But the cause of their wonder is small[425](javascript:footNote('T105008/note425.html')) *to one* who compares the events of the world and the subversion of ages, which brought such vicissitudes on the tribes of the world in general, driving the potent from territories, as the 



---

p.177



chieftains we have undertaken to describe were driven, as is evident from the celebrated poem[426](javascript:footNote('T105008/note426.html')) *beginning* ‘ Many a branch of the race of Conn’, which contains 231 quatrains, which was composed by **Giolla Iosa Mor Mac Firbis**, ut sequitur: 


> 1. 
> 
> Mac Firbis of Lecan Cecinit.3. Many a branch of the race of Conn[427](javascript:footNote('T105008/note427.html'))
>   
> *Is* in the land of Banba of smooth grass;
>   
> The sovereignty of the lands[428](javascript:footNote('T105008/note428.html')) was mightily seized
>   
> By Conn, who is the head of their branches[429](javascript:footNote('T105008/note429.html')).
> 
> 
> ---
> 
> p.179
> 
> 6. The race of Niall[430](javascript:footNote('T105008/note430.html')), son of the great Eochaidh,
>   
> Is a fine branch of the cluster,
>   
> No sept *has arrived at their happiness*;
>   
> They are the greatest tribe of heroes[431](javascript:footNote('T105008/note431.html')).
> 7. Of the race of great Con, son of Feidhlim,
>   
> *Are* the people of Cruachan of the level plain[432](javascript:footNote('T105008/note432.html'));
>   
> No man of the tribe is fruitless *(unmarried)*,
>   
> The kings of the plain of Muireadhach[433](javascript:footNote('T105008/note433.html')).
> 8. The seed of Feargna[434](javascript:footNote('T105008/note434.html')), men of the north,
>   
> Passing to Cruachan[435](javascript:footNote('T105008/note435.html')) of the red mounds,
> 
> 
> ---
> 
> p.181
> 
> 
> And to Cenannus, land of the heroes[436](javascript:footNote('T105008/note436.html'))
>   
> Which was the inheritance of the white-skinned Conn[437](javascript:footNote('T105008/note437.html')).
> 9. A noble branch of the race of Conn
>   
> Is the tribe of Eochaidh Doimhlen[438](javascript:footNote('T105008/note438.html')), the bright-eyed,
>   
> The host of Oirghiall, who, above every tribe,
>   
> Is a bulky blaze of heavy battle.
> 10. Another shoot of the race of Conn
>   
> Is the Clann Mailli[439](javascript:footNote('T105008/note439.html')), valiant the branch,
>   
> (Every country is heard selecting them[440](javascript:footNote('T105008/note440.html'))),
>   
> And the mild Muintir Murchadha[441](javascript:footNote('T105008/note441.html')).
> 
> 
> ---
> 
> p.183
> 
> 13. The race of the great Fiachra, son of Eochaidh,
>   
> A beauteous, sweetly-judging tribe[442](javascript:footNote('T105008/note442.html')),
>   
> The Hy-Fiachrach, north and south[443](javascript:footNote('T105008/note443.html')),
>   
> A generous battalion, who have exceeded comparison.
> 14. The race of the noble Fiachra are my care,
>   
> Let us follow the track of the heroes,
>   
> The hosts from Tara of Tuathal[444](javascript:footNote('T105008/note444.html')),
>   
> It is just to trace their noble career.
> 15. Fiachra Foltsnaitheach[445](javascript:footNote('T105008/note445.html')), the festive,
>   
> Five were the sons of that great progenitor,
>   
> To enumerate them is meet for the people,
>   
> Who were wont to distribute fame to the family[446](javascript:footNote('T105008/note446.html')).
> 16. Dathi, who won each sept,
>   
> Was contender for the plain of Europe[447](javascript:footNote('T105008/note447.html'));
>   
> He proceeded to the Alps of birds[448](javascript:footNote('T105008/note448.html')),
>   
> *It is* a part of his adventure *celebrated* in stories[449](javascript:footNote('T105008/note449.html')).
> 
> 
> ---
> 
> p.185
> 
> 19. Amhalgaidh, a prop of battle,
>   
> Was a noble son of the arch-chieftain,
>   
> Banba was enjoyed by the hero[450](javascript:footNote('T105008/note450.html'));
>   
> Bresal the brave and Conairi[451](javascript:footNote('T105008/note451.html')) *were also his sons.*
> 20. Earc Culbhuidhe[452](javascript:footNote('T105008/note452.html')), a prosperous branch,
>   
> Was son of great Fiachra, son of Eochaidh,
>   
> His steward over Ceara he placed[453](javascript:footNote('T105008/note453.html')),
>   
> Which the side of each tree confessed[454](javascript:footNote('T105008/note454.html')).
> 21. Of the descendants of Earc, who consented not to treachery,
>   
> A brave tribe, whom I will not omit,
>   
> Are the men of Ceara of beautiful fruit trees,
>   
> With a mellow top of honey on their pods[455](javascript:footNote('T105008/note455.html')).
> 
> 
> ---
> 
> p.187
> 
> 24. Let us not leave Ceara of the mounds[456](javascript:footNote('T105008/note456.html'))
>   
> Without mentioning its inheritors,
>   
> Without gently fitting them *to our verse,*
>   
> To place them in the regal list.
> 25. Over Ceara of the brown nuts[457](javascript:footNote('T105008/note457.html'))
>   
> There are three noble, laudable kings,
>   
> *Over* tribes who have not been subdued from times remote,
>   
> Whose soldiers possess high minds.
> 26. O'Tighernaigh of ready tribes[458](javascript:footNote('T105008/note458.html')),
>   
> O'Gormghail[459](javascript:footNote('T105008/note459.html')), who merited not reproach,
>   
> A host who separate not from the battle,
>   
> O'Muireadhaigh[460](javascript:footNote('T105008/note460.html')) of great mirth.
> 
> 
> ---
> 
> p.189
> 
> 29. To O'h-Uada[461](javascript:footNote('T105008/note461.html')) of extensive woods,
>   
> To O'Cinnchnamha[462](javascript:footNote('T105008/note462.html')), who was not dispraised,
>   
> *Belongs the tract stretching* from Maiteog to the hard Callainn,
>   
> And to the cool river.
> 30. Well has been defended the land of the men
>   
> By O'Dorchaidhe of the lofty mind,
>   
> The country of Partraighe[463](javascript:footNote('T105008/note463.html')) of fine hazle trees,
>   
> With the yellow-knotted *spear-*shaft in the battle.
> 31. O'Banan of his own town[464](javascript:footNote('T105008/note464.html')),
>   
> A brughaidh who merited not reproach,
> 
> 
> ---
> 
> p.191
> 
> 
> O'Gilin the swift of Muine[465](javascript:footNote('T105008/note465.html')),
>   
> Chief of a tribe who were never dispraised.
> 32. Mac an Bhainbh[466](javascript:footNote('T105008/note466.html')) of scarlet hazles,
>   
> Obtained the terrestrial fairy palace[467](javascript:footNote('T105008/note467.html'))
>   
> The sweet district of Magh na beithighe,
>   
> The most vigorous chief I mention.
> 33. Baile na Craibhi[468](javascript:footNote('T105008/note468.html')) without stain,
>   
> Which is also called the Tobar,
>   
> O'Aodha[469](javascript:footNote('T105008/note469.html')), with his tribe, obtained,
>   
> Heroes who protect us against puissant men.
> 34. O' Fuathmharan[470](javascript:footNote('T105008/note470.html')) of the swift steeds
>   
> Obtained Cacal[471](javascript:footNote('T105008/note471.html')) by plying the sword;
> 
> 
> ---
> 
> p.193
> 
> 
> The strength of his large swords and hands
>   
> Deserve renown at every time.
> 35. Cill n-Aindi of the green woods[472](javascript:footNote('T105008/note472.html'))
>   
> Belongs to O'Lerghusa[473](javascript:footNote('T105008/note473.html')) of swift steeds;
>   
> The host of Cill was never dispraised,
>   
> Youths who ought to be mentioned *in this poem.*
> 36. The district of Magh h-Indalbh[474](javascript:footNote('T105008/note474.html')) of steeds,
>   
> *Belongs* to a hero who has not pronounced false sentence,
>   
> To O'Cearnaigh[475](javascript:footNote('T105008/note475.html')), who loved not refusal,
>   
> The fame of his household I will extol.
> 37. The three townlands of Baile an Riagan[476](javascript:footNote('T105008/note476.html')) without division,
>   
> The three townlands of Cnocan[477](javascript:footNote('T105008/note477.html')), I say,
> 
> 
> ---
> 
> p.195
> 
> 
> And the land of Fidh Cruaichi[478](javascript:footNote('T105008/note478.html')) of banquets, — 
>   
> On which are shower-shaken hazles of white bark,
>   
> *And* where each round hill is protected by wattle hedges, — 
>   
> *Constitute* the ancient territory of O'h-Eidhnechan[479](javascript:footNote('T105008/note479.html')).
> 38. Baile an Bhelaigh[480](javascript:footNote('T105008/note480.html')), it is certain to me,
>   
> Is O'Ciaragan's[481](javascript:footNote('T105008/note481.html')), — I will not conceal it, — 
>   
> Neither should his virtue be concealed,
>   
> The satin-dressed ornament of each old habitation.
> 39. Over Baile Crannain[482](javascript:footNote('T105008/note482.html')), without blemish,
>   
> Are brughaidhs *(farmers)* of fierce conflict, — 
>   
> Spare ye not the acquisitions of the men, — 
>   
> The O'Coiglidhs[483](javascript:footNote('T105008/note483.html')), a brave tribe.
> 40. The Mac Gilli Fhaelains[484](javascript:footNote('T105008/note484.html')) without treachery,
>   
> Noble brughaidhs *(farmers)*, I reckon,
>   
> Whose spear-armed host have good array,
>   
> Are in Regles[485](javascript:footNote('T105008/note485.html')) of the great family.
> 
> 
> ---
> 
> p.197
> 
> 43. Cul Daingin[486](javascript:footNote('T105008/note486.html')) and Braenros[487](javascript:footNote('T105008/note487.html')) ban *[the white]*,
>   
> Oiremh[488](javascript:footNote('T105008/note488.html')) and the entire of Imairi[489](javascript:footNote('T105008/note489.html'))
>   
> *Belong* to O'Mailraite[490](javascript:footNote('T105008/note490.html')), hospitable the man,
>   
> To whom the literati and the feast were pleasing.
> 44. The three townlands of Tulach[491](javascript:footNote('T105008/note491.html')) the southern,
>   
> Belong to O'Brogan[492](javascript:footNote('T105008/note492.html')), who has enjoyed happiness,
>   
> And the northern to O'Faghartaigh, who at his house
>   
> Is praised at the time of the assembly.
> 45. The Termon of Balla[493](javascript:footNote('T105008/note493.html')), where sweetly sound the bells,
>   
> A flowery land, which Patrick blest[494](javascript:footNote('T105008/note494.html')),
> 
> 
> ---
> 
> p.199
> 
> 
> A host from Tara selecting it[495](javascript:footNote('T105008/note495.html')),
>   
> O'Cearnaigh obtained, *as his* first choice.
> 46. O'Caomhan of the ancient swords obtained
>   
> Tuath Ruisin[496](javascript:footNote('T105008/note496.html')), vigorous his career,
>   
> A princely district, soil of heroes,
>   
> Old land of lances and swords.
> 47. O'Ruaidhin[497](javascript:footNote('T105008/note497.html')) of the rapid onsets got
>   
> The tract stretching from Ath na Lub[498](javascript:footNote('T105008/note498.html')), as is reported,
>   
> To the land of fair Cill na n-Garg[499](javascript:footNote('T105008/note499.html')),
>   
> We are proudly counting them.
> 48. From the causeway of Cillin na n-Garg[500](javascript:footNote('T105008/note500.html')),
>   
> To Ath Seisidh[501](javascript:footNote('T105008/note501.html')) of the noble bards,
> 
> 
> ---
> 
> p.201
> 
> 
> And Robin[502](javascript:footNote('T105008/note502.html')) being to the east of us,
>   
> A little spot which is delightful to the strangers[503](javascript:footNote('T105008/note503.html')).
> 49. *And* from Sighin Chiarain of the bells[504](javascript:footNote('T105008/note504.html'))
>   
> To Tobar Lughna[505](javascript:footNote('T105008/note505.html')), the soft *[i. e. boggy]*,
>   
> O'Birn[506](javascript:footNote('T105008/note506.html')) obtained that festive land,
>   
> For whom the hazle[507](javascript:footNote('T105008/note507.html')) waved in hundred tendrils.
> 50. From the Tobar to Caol[508](javascript:footNote('T105008/note508.html')) of the battles,
>   
> Rodhba and Rathain under Aenach[509](javascript:footNote('T105008/note509.html')),
> 
> 
> ---
> 
> p.203
> 
> 
> O'Goirmghialla[510](javascript:footNote('T105008/note510.html')) obtained that land
>   
> *Whose* hosts *are now* under the heavy thraldom of foreigners[511](javascript:footNote('T105008/note511.html')).
> 51. The three townlands of Criathrach[512](javascript:footNote('T105008/note512.html')), without concealment,
>   
> *Belong* to O'Mailcana[513](javascript:footNote('T105008/note513.html')), who was never dispraised,
>   
> And to the melodious Mac Gilli Buidhi's[514](javascript:footNote('T105008/note514.html')),
>   
> The host of Cill[515](javascript:footNote('T105008/note515.html')) I recount.
> 
> 
> ---
> 
> p.205
> 
> 54. The chief seats of this southern territory [i. e. Ceara]
>   
> Are Feart Lothair[516](javascript:footNote('T105008/note516.html')) of much happiness,
>   
> Aenach[517](javascript:footNote('T105008/note517.html')), and the sweet Loch Buadhaigh[518](javascript:footNote('T105008/note518.html'));
>   
> Before the multitudes I early boast *of them*.
> 55. Of the race of Earc Culbhuidhi, it was heard,
>   
> Are the Fir Thire of pellucid streams,
>   
> And the Clann Cuain without stain,
>   
> Who showed no small kindness to the bard.
> 56. Over Clann Cuain[519](javascript:footNote('T105008/note519.html')) of heavy preys
>   
> Were three chieftains accustomed to conflict,
> 
> 
> ---
> 
> p.207
> 
> 
> Who deserved all Banba *[Ireland]* for selecting it[520](javascript:footNote('T105008/note520.html')) *[Clann Cuain]*,
>   
> The brave O'Cuinn[521](javascript:footNote('T105008/note521.html')) was their first choice.
> 57. Mag Lannagan[522](javascript:footNote('T105008/note522.html')) of the smooth shafts,
>   
> By whom the districts of strangers were plundered,
>   
> *And* O'Mailina[523](javascript:footNote('T105008/note523.html')), who, yonder at his house,
>   
> Was the sheltering tree of the learned.
> 58. O'Cuinn one time obtained
>   
> The chieftainship of *this* our territory[524](javascript:footNote('T105008/note524.html')),
>   
> Hardy were the conflict and career,
>   
> Of Domhnall[525](javascript:footNote('T105008/note525.html')), until he received disgrace.
> 59. O'Cuinn happened to have
>   
> A beautiful marriageable daughter *who was* wooed;
>   
> She did not receive a gift of cattle[526](javascript:footNote('T105008/note526.html'))
>   
> Though she was wooed by chieftains.
> 
> 
> ---
> 
> p.209
> 
> 62. There came at the time into the southern district[527](javascript:footNote('T105008/note527.html'))
>   
> The King of Hy-Fiachrach, who had enjoyed happiness,
>   
> Ruaidhri, son of Taithleach[528](javascript:footNote('T105008/note528.html')) of the tribes,
>   
> A *fishing* rod to whom every river was known[529](javascript:footNote('T105008/note529.html')).
> 63. To the house of O'Cuinn of fiery tribes
>   
> Went O'Dubhda of Dun Guaire[530](javascript:footNote('T105008/note530.html')),
>   
> The great pillar of the fair plain of Fail[531](javascript:footNote('T105008/note531.html')),
>   
> To get his warlike refection[532](javascript:footNote('T105008/note532.html')).
> 64. Ruaidhri of the rapid onsets viewed
>   
> The black-haired, fair-skinned daughter[533](javascript:footNote('T105008/note533.html')),
>   
> In the door of her beauteous Grianan[534](javascript:footNote('T105008/note534.html'));
>   
> The steady, modest *maiden* was brightness[535](javascript:footNote('T105008/note535.html')).
> 
> 
> ---
> 
> p.211
> 
> 67. Ruaidhri of the bright eye loved[536](javascript:footNote('T105008/note536.html'))
>   
> The splendid comely daughter;
>   
> Mightily was his attention engaged
>   
> *In what became* the cause of tears to the goodly mansion.
> 68. O'Dubhda of the fort of Conn[537](javascript:footNote('T105008/note537.html')) effected
>   
> The violation of the daughter of Domhnall,
>   
> *And* as by force he entered in
>   
> The report *of the deed* spread widely.
> 69. The King of Rath Branduibh[538](javascript:footNote('T105008/note538.html')) is slain
>   
> By O'Cuinn with sharp swords,
>   
> As this lord [O'Dubhda] indeed was found
>   
> Alone in the gap of danger.[539](javascript:footNote('T105008/note539.html'))
> 70. Early on the morrow went
>   
> O'Cuinn of affectionate hosts,
> 
> 
> ---
> 
> p.213
> 
> 
> His men worthy of any host,
>   
> To the vigorous Sil Muireadhaigh[540](javascript:footNote('T105008/note540.html'));
> 71. *To* Tomaltach Mor[541](javascript:footNote('T105008/note541.html')) of fiery tribes,
>   
> Mac Diarmada of Brugh Boinne[542](javascript:footNote('T105008/note542.html')),
>   
> *And* under his steward the tribe *[of O'Cuinn]* submitted *themselves,*
>   
> He *[Mac Diarmada]* consenting to their illegal act[543](javascript:footNote('T105008/note543.html')).
> 72. From that day down to this
>   
> The Clann Cuain and mighty Fir Thire[544](javascript:footNote('T105008/note544.html'))
>   
> Are without mention of a charter for their tributes
>   
> Among the host of the Sil Muireadhaigh[545](javascript:footNote('T105008/note545.html')).
> 
> 
> ---
> 
> p.215
> 
> 75. *But* though the clann Maoilruanaidh[546](javascript:footNote('T105008/note546.html')) of rapid onsets
>   
> Have obtained of them possession,
>   
> To cling to them is not meet for this people;
>   
> Its nut separates from the *parent* branch.
> 76. I have now brought them with me[547](javascript:footNote('T105008/note547.html')), by a reporting of knowledge
>   
> According to the genealogical relationship
>   
> From the Clann Maoilruanaidh, without division,
>   
> To the native stem, as I speak.
> 77. Let us pass, may our journey be felicitous,
>   
> From the wide territory of patron saints[548](javascript:footNote('T105008/note548.html'))
>   
> To Irrus[549](javascript:footNote('T105008/note549.html')), where we were fostered,
>   
> That border of delightful districts.[550](javascript:footNote('T105008/note550.html'))
> 78. O'Caithniadh[551](javascript:footNote('T105008/note551.html')), who spared not cattle,
>   
> *Was* the chief of Irrus, who was not satirized;
> 
> 
> ---
> 
> p.217
> 
> 
> The produce of the country is in floods[552](javascript:footNote('T105008/note552.html'));
>   
> Praise to the tribe I speak.
> 79. There are three sub-chiefs in this western country,
>   
> In Irrus of splendid aspect,
>   
> A host the most excited by metheglin[553](javascript:footNote('T105008/note553.html')),
>   
> A tribe who merited to be believed.
> 80. O'Ceallachain[554](javascript:footNote('T105008/note554.html')), head of the host,
>   
> O'Muimhneachain[555](javascript:footNote('T105008/note555.html')), who drinks the mead,
>   
> Mac Coinin[556](javascript:footNote('T105008/note556.html')), remind us not of him[557](javascript:footNote('T105008/note557.html')),
>   
> Very kind are those people to the learned.
> 81. The O'Coinminns[558](javascript:footNote('T105008/note558.html')) of right condition,
>   
> The Mag Fhionnainns[559](javascript:footNote('T105008/note559.html')) in the high roll,
>   
> The Mac Conboirnes[560](javascript:footNote('T105008/note560.html')) of prosperous name,
>   
> Tribes who have gone beyond comparison.
> 
> 
> ---
> 
> p.219
> 
> 84. The O'Geradhains[561](javascript:footNote('T105008/note561.html')) of sleek horses,
>   
> A tribe of valorous career,
>   
> A race of great hilarity,
>   
> Whose hosts are firm under their noble spears.
> 85. Thus is obvious in our book *set down*
>   
> The host of Irrus without exception,
>   
> It is meet to enumerate this people,
>   
> A host whose sons have not been dispraised.
> 86. Let us leave Irrus of the fine soil[562](javascript:footNote('T105008/note562.html')),
>   
> Let us pass to the native territory[563](javascript:footNote('T105008/note563.html')),
>   
> Let us quietly pursue our journey,
>   
> Let us observe the opportunity of each ollamh.
> 87. As bare books[564](javascript:footNote('T105008/note564.html')) relate,
>   
> I shall point out the lands
>   
> From Dun Fine[565](javascript:footNote('T105008/note565.html')) to the sluggish Muaidh[566](javascript:footNote('T105008/note566.html'));
>   
> The race of whom I speak were not penurious.
> 88. The first inheritor who shall be mentioned here,
>   
> At Dun Fine of apple trees,
>   
> Is O'Duibhlearga[567](javascript:footNote('T105008/note567.html')), who loves not the Galls[568](javascript:footNote('T105008/note568.html')),
>   
> An artifex in learning prowess[569](javascript:footNote('T105008/note569.html')).
> 
> 
> ---
> 
> p.221
> 
> 91. O'Cuinn[570](javascript:footNote('T105008/note570.html')) of the brave tribe,
>   
> *One* of the people who have not been lowered,
>   
> And O'Comhgan[571](javascript:footNote('T105008/note571.html')), without a stain,
>   
> And Mag Odhrain[572](javascript:footNote('T105008/note572.html')) is on that land.
> 92. O'Duanmuidhe[573](javascript:footNote('T105008/note573.html')) of happy success,
>   
> And O'Blighe[574](javascript:footNote('T105008/note574.html')) the warlike,
>   
> O'Berga[575](javascript:footNote('T105008/note575.html')) for whom the hazles stoop[576](javascript:footNote('T105008/note576.html')),
>   
> Who deserved not the anger of the saints.
> 93. Radubhain,[577](javascript:footNote('T105008/note577.html')) an assertion without fault,
>   
> Of Baile an Ghleanna[578](javascript:footNote('T105008/note578.html')), his fine seat[579](javascript:footNote('T105008/note579.html')),
>   
> A brughaidh[580](javascript:footNote('T105008/note580.html')) of no false fame,
>   
> A hundred-attended hero in defending.
> 94. Of their own town[581](javascript:footNote('T105008/note581.html')), it is true,
>   
> Are the Mac Conleitrechs, the heroes,
> 
> 
> ---
> 
> p.223
> 
> 
> A people without poverty as to cattle,
>   
> Who have not circumscribed the weal of the churches.
> 95. Of Cill Ardubh[582](javascript:footNote('T105008/note582.html')) — godly the tribe, — 
>   
> Are the O'Cathasaighs[583](javascript:footNote('T105008/note583.html')) of conflicts,
>   
> Going beyond every road before them,
>   
> And the fair champion O'Conghaile[584](javascript:footNote('T105008/note584.html')).
> 96. *But* the chieftainship is due to those
>   
> High-minded tribes of great hosts,
>   
> The O'Muireadhaighs[585](javascript:footNote('T105008/note585.html')) of comely chiefs,
>   
> The majestic pillars of the Lagan[586](javascript:footNote('T105008/note586.html')).
> 97. The Mag Fhinnains[587](javascript:footNote('T105008/note587.html')), who refused not a man,
>   
> *are of the Hy-Muireadhaigh of banners*,
>   
> Of the tribe who excelled all,
>   
> Of the fair sept without irrationality,
>   
> Men who are kindling *valour* in their sons:
>   
> Such is the Lagan[588](javascript:footNote('T105008/note588.html')) I say.
> 
> 
> ---
> 
> p.225
> 
> 100. From Rath Branduibh[589](javascript:footNote('T105008/note589.html')) of the sweet bells[590](javascript:footNote('T105008/note590.html'))
>   
> To Traigh Ceall[591](javascript:footNote('T105008/note591.html')), a road which we pass,
>   
> *Stretches* the country of Caeilli of no extinguished fame,
>   
> Not fairer was the plain of Cruachan[592](javascript:footNote('T105008/note592.html')).
> 101. From Conall, son of Fergus, the fair,
>   
> Sprung the musical Clann Conaill[593](javascript:footNote('T105008/note593.html'));
>   
> His race are *in* the territory of Caeille;
>   
> No time is found complaining of them.
> 102. O'h-Aodha[594](javascript:footNote('T105008/note594.html')), who never rejected a man of learning,
>   
> A people of constant liberal bestowing,
>   
> Of Ard O'n-Aodha[595](javascript:footNote('T105008/note595.html')) of steeds,
>   
> Branches of high hospitality.
> 103. The place of a chieftain in the northern district
>   
> O'h-Aodha of the cold-weapon has obtained;
>   
> His children are in the centre of Caeilli,
>   
> The fairest plain of those I mention.
> 
> 
> ---
> 
> p.227
> 
> 106. The O'Mailchonaires[596](javascript:footNote('T105008/note596.html')) without a blot,
>   
> The O'Flannabhras[597](javascript:footNote('T105008/note597.html')) without oppression,
>   
> The O'Seghdhas[598](javascript:footNote('T105008/note598.html')) of rich produce,
>   
> Heroes who reject not men of learning.
> 107. I have mentioned, it is a reporting of knowledge,
>   
> The Clann Conaill and their correlatives,
>   
> As it is no shame to all the heroes
>   
> To have them set down in the regal list.
> 108. Hy-Eathach Muaidhe[599](javascript:footNote('T105008/note599.html')) of the plains
>   
> *Extends* from Ros Seirce[600](javascript:footNote('T105008/note600.html')) of the bright streams
>   
> To Fearsad Treisi, north,
>   
> A pass of most powerful hosts.
> 109. The O'Mailfaghmhairs[601](javascript:footNote('T105008/note601.html')) who prepared the banquets,
>   
> The O'Leanains[602](javascript:footNote('T105008/note602.html')), full vigorous heroes,
>   
> Not decrepid are the hosts of the soil;
>   
> Of the descendants of Laeghaire[603](javascript:footNote('T105008/note603.html')) I speak.
> 110. Of the O'Mailfoghmhairs, who violated not bells[604](javascript:footNote('T105008/note604.html'))
>   
> Were the seven bishops of Patrick's city[605](javascript:footNote('T105008/note605.html')),
> 
> 
> ---
> 
> p.229
> 
> 
> *And* seven who were strongly elected
>   
> In the choir (chapter) who came around them.
> 111. The O'Criaidhcheins[606](javascript:footNote('T105008/note606.html')) of goodly plight,
>   
> The lofty-proud O'Flaitilies[607](javascript:footNote('T105008/note607.html')),
>   
> The O'Mochains[608](javascript:footNote('T105008/note608.html')) who have not forsaken you, once,
>   
> Who were the causeway[609](javascript:footNote('T105008/note609.html')) of the learned of Erin.
> 112. The O'Mailaithghins[610](javascript:footNote('T105008/note610.html')) of bright cheeks,
>   
> The O'Mailbhrenainns[611](javascript:footNote('T105008/note611.html')) of terrific spears,
>   
> Heroes who contended with the youths of Banba[612](javascript:footNote('T105008/note612.html')),
>   
> The brave O'Broduibhs[613](javascript:footNote('T105008/note613.html')), and the O'Creachains[614](javascript:footNote('T105008/note614.html')).
> 113. These are the Hy-Eachach of the steeds,
>   
> A people who have spoken only a just sentence,
>   
> This fair tribe have a lofty mind,
>   
> They are the most expert host I mention.
> 114. Let us pass into the soft Bredach[615](javascript:footNote('T105008/note615.html')),
>   
> Which is accustomed to battles and hardness of conflict,
>   
> To the scions from whom we shall receive information,
>   
> The Clann Fergus[616](javascript:footNote('T105008/note616.html')) of brown weapons.
> 115. O'Toghdha[617](javascript:footNote('T105008/note617.html')) is head of the battle,
>   
> Victorious chief of Bredach,
> 
> 
> ---
> 
> p.231
> 
> 
> To mention him is not grievous to me,
>   
> Pity that there is no heir of the champions[618](javascript:footNote('T105008/note618.html')).
> 116. O'Luachduibh's[619](javascript:footNote('T105008/note619.html')) part of the western side
>   
> Of Bredach is of brilliant aspect,
>   
> Chiefs *accustomed to* victory from their foundation,
>   
> The host and their chiefs are increasing.
> 117. O'Gloinin[620](javascript:footNote('T105008/note620.html')) who spared not cattle,
>   
> O'Gilin[621](javascript:footNote('T105008/note621.html')) of the victorious arms,
>   
> In Bredach powerful their pursuit,
>   
> The people who have increased mede-drinking.
> 118. Of the fine Magh Gamhnach[622](javascript:footNote('T105008/note622.html')) are
>   
> The O'Deirgs[623](javascript:footNote('T105008/note623.html')) of flowery habitations
>   
> And the O'Gadans[624](javascript:footNote('T105008/note624.html')) of pure honour,
>   
> Glowing with hospitality and valour.
> 119. Let us leave Bredach of the green *corn* fields,
>   
> We have sung of some of its inheritors,
> 
> 
> ---
> 
> p.233
> 
> 
> Let us make *our way* up into sweet Bac[625](javascript:footNote('T105008/note625.html')),
>   
> Quick *grows* its fruit as I hear.
> 120. The full chieftainship of O'Lachtna[626](javascript:footNote('T105008/note626.html')),
>   
> (Just his boast and ostentation),
>   
> *Comprises* the two Bacs and the fair Glenn[627](javascript:footNote('T105008/note627.html'))
>   
> Rich methinks its production.
> 121. Ard Achadh[628](javascript:footNote('T105008/note628.html')) of delightful woods,
>   
> Cill Belad[629](javascript:footNote('T105008/note629.html')), seat of the poets,
> 
> 
> ---
> 
> p.235
> 
> 
> Belongs to O'Maoilruain[630](javascript:footNote('T105008/note630.html')), who refused not any one,
>   
> Who marches with the wings of the army.
> 122. Of Baile Ui Emeachain[631](javascript:footNote('T105008/note631.html')) the great
>   
> Is O'h-Emeachain, who obtained respect,
>   
> A victorious Brughaidh without oppression.
>   
> Hosts to his mansion come.
> 123. O'Laechaille[632](javascript:footNote('T105008/note632.html')), a hero without misfortune,
>   
> A Brughaidh who was wont to feed the ravens,
>   
> Is lord of Magh Fuara[633](javascript:footNote('T105008/note633.html')) of banquets,
>   
> A comely hero who was never dispraised.
> 124. Of Lis Cumin[634](javascript:footNote('T105008/note634.html')) of the white *corn-*fields
>   
> *Are* the O'Cumins[635](javascript:footNote('T105008/note635.html')), a brave tribe;
>   
> Brughaidhs who acted treacherously to no people;
>   
> And worthy *of his rank* is the head of the family.
> 125. Mac Conlena[636](javascript:footNote('T105008/note636.html')) of ancient swords,
>   
> The O'Dubhagains[637](javascript:footNote('T105008/note637.html')) of good men
>   
> Were of Cill Mor Muaidhe[638](javascript:footNote('T105008/note638.html')) of the plains,
>   
> A troop hardy in *giving* succour.
> 
> 
> ---
> 
> p.237
> 
> 128. The O'Airmeadhaighs[639](javascript:footNote('T105008/note639.html')) of swift steeds,
>   
> The O'Ronains[640](javascript:footNote('T105008/note640.html')), who received respect,
>   
> *Were* of Magh Broin[641](javascript:footNote('T105008/note641.html')) of scarlet hazles;
>   
> The praise-worthy host were not few;
> 129. The Clann Firbisigh[642](javascript:footNote('T105008/note642.html')) *also,* who reported no fault,
>   
> The ollamhs of the province of Connaught;
>   
> They were at Rosseirc afterwards;
>   
> It would not be proper to conceal their lineage.
> 130. Across the lake westwards should I sail[643](javascript:footNote('T105008/note643.html')),
>   
> I need not go a longer journey;
> 
> 
> ---
> 
> p.239
> 
> 
> It is not a short excursion on the water
>   
> To *reach* the prosperous Glenn Nemthinne.
> 131. The O'Mailfhinas[644](javascript:footNote('T105008/note644.html')) who refused not any one,
>   
> The O'Gaibhtheachains[645](javascript:footNote('T105008/note645.html')) of the sharp spears,
>   
> Distributing lances to the troop,
>   
> Were the two chiefs of the plain of Calraighe[646](javascript:footNote('T105008/note646.html')),
> 132. Over Magh Eleag[647](javascript:footNote('T105008/note647.html')) of high prosperity,
>   
> As a brave and hundred-cattled[648](javascript:footNote('T105008/note648.html')) Brughaidh
>   
> Is O'Floinn[649](javascript:footNote('T105008/note649.html')), the manly champion,
>   
> Under whom a fair-faced race have risen.
> 
> 
> ---
> 
> p.241
> 
> 135. The O'Flannghailes,[650](javascript:footNote('T105008/note650.html')) who reported no fault
>   
> A people of most universal bravery,
>   
> Dwell round Loch Glinne[651](javascript:footNote('T105008/note651.html')) of hospitable men,
>   
> Youth with whom valour is a hostage.
> 136. I have composed, — it is cause of knowledge, — 
>   
> According to the genealogical ramifications,
>   
> *An account* of the tribes of the country beyond *the Moy,*
>   
> For the poets of the plain of Manann[652](javascript:footNote('T105008/note652.html')).
>   
> Even as the yoke is due to [borne by] the clergy.[653](javascript:footNote('T105008/note653.html'))
>   
> According to each book I speak.
> 137. I shall advance after my journey thither,
>   
> With a small brave company,
>   
> Who are not inexpert at the time of shooting,
>   
> Across the Muaidh[654](javascript:footNote('T105008/note654.html')) of speckled salmons.
> 
> 
> ---
> 
> p.243
> 
> 140. Throughout the region over which I have passed,
>   
> I will name for you, — it is true knowledge, — 
>   
> Quickly from the fair bright branches,
>   
> The genealogy of the discreet tribes.
> 141. Tuaim da Bodhar[655](javascript:footNote('T105008/note655.html')) which won the wagers,
>   
> Is the limit of this country I describe,
>   
> Ath Cunga[656](javascript:footNote('T105008/note656.html')) is its other limit;
>   
> The inhabitants are supporters of our bards.
> 142. There was a chief at another time
>   
> In this territory over the race of Laeghaire[657](javascript:footNote('T105008/note657.html')),
>   
> O'h-Eignigh[658](javascript:footNote('T105008/note658.html')), who was head over all,
>   
> No power oppressed the hero.
> 143. The O'Gealagans[659](javascript:footNote('T105008/note659.html')), men of banquets,
>   
> *Dwelt* in Grainseach[660](javascript:footNote('T105008/note660.html')) of bright rivers,
>   
> Cill Ichtair[661](javascript:footNote('T105008/note661.html')) is their land,
>   
> Bright soil in which sermons are sown.
> 144. Imleach Loisce[662](javascript:footNote('T105008/note662.html')) is the inheritance
>   
> Of the O'h-Endas[663](javascript:footNote('T105008/note663.html')) of heavy crowds,
>   
> From their forts did burst the shouts;
>   
> They *were* fine septs of brughaidhs.
> 
> 
> ---
> 
> p.245
> 
> 147. The O'Mongans[664](javascript:footNote('T105008/note664.html')), who were not peniurious to the clergy,
>   
> The O'Brogans[665](javascript:footNote('T105008/note665.html')), who deserved no reproach,
>   
> Swords were befitting their troops,
>   
> Two *families of* brughaidhs of the plain of Breachmhagh[666](javascript:footNote('T105008/note666.html')).
> 148. From Bel Atha Cunga[667](javascript:footNote('T105008/note667.html')) the hard,
>   
> The lands westwards to the old *river* Muaidh[668](javascript:footNote('T105008/note668.html')),
>   
> Belong to O'Cuinn[669](javascript:footNote('T105008/note669.html')) and O'Moran[670](javascript:footNote('T105008/note670.html')) the swift,
>   
> Who deserved the great esteem of the soldiers.
> 149. After O'h-Eignigh of the steeds
>   
> O'Moran goes triumphantly
>   
> To Ard na Riagh[671](javascript:footNote('T105008/note671.html')), hospitable the man,
>   
> To tend the learned and the banquets.
> 150. For O'Moran, who was accustomed to battles
>   
> In the place of the *other* arch-chieftain,
>   
> We have allotted Ard na Riagh,
>   
> A hero by whom our mind was raised.
> 151. Let us leave the race of puissant Laeghaire,
>   
> Let us traverse the roads before us,
>   
> Over Tuaim da bhodhar; sweetly
>   
> Let us boast of the host by praising them.
> 
> 
> ---
> 
> p.247
> 
> 154. Into *Callraidhe* of Cuil[672](javascript:footNote('T105008/note672.html')) na g-cneadh,
>   
> I shall proceed to describe it,
>   
> Cuil Cernogha of the knotty hazles,
>   
> Not unhappy are those in whom it is hereditary.
> 155. Four chieftains are in this upper country,
>   
> In Callraidhe of beautiful fruit-trees,
>   
> A festive party who have entered into our catalogue,
>   
> It is proper to name the noble youths.
> 156. Ma Cuinn[673](javascript:footNote('T105008/note673.html')) and O'Rothlainn[674](javascript:footNote('T105008/note674.html')) the ready,
>   
> *O'h-Iarnain*[675](javascript:footNote('T105008/note675.html')) of dreadful arms,
>   
> Who injures the choicest of the foreigners,
>   
> And O'Finain[676](javascript:footNote('T105008/note676.html')), a great sheltering tree.
> 157. [From Bel Easa[677](javascript:footNote('T105008/note677.html')) of the clear cataracts,
>   
> The extent of the country which was not oppressed,
>   
> To the Brosnach[678](javascript:footNote('T105008/note678.html')) of impetuous current,
> 
> 
> ---
> 
> p.249
> 
> 
> Which defends the head of Calraighe[679](javascript:footNote('T105008/note679.html'))].
> 158. O'Caomhain[680](javascript:footNote('T105008/note680.html')), — it is cause of gain, — obtained
>   
> *The tract* from Tuaim da Bhodhar[681](javascript:footNote('T105008/note681.html')) of flowery hills
>   
> (His tribe are best *when acting* by their own will),
>   
> To Gleoir[682](javascript:footNote('T105008/note682.html')), the head of the tribe[683](javascript:footNote('T105008/note683.html')).
> 159. Mac Cailleachain[684](javascript:footNote('T105008/note684.html')) of valorous feats,
>   
> A hero who fled not from foreign javelins
>   
> Is chief of Carn[685](javascript:footNote('T105008/note685.html')), whose fame he defended
>   
> By the valour of his arms and conflict.
> 160. O'Coitil of the naked weapons got
>   
> Baile Ui Choitil[686](javascript:footNote('T105008/note686.html')) by his valour,
>   
> A Brughaidh like him there exists not,
>   
> Clay is not fit before him[687](javascript:footNote('T105008/note687.html')).
> 161. To O'Mochaine of the sweet mouth
>   
> Belongs Baile Ui Mhochaine[688](javascript:footNote('T105008/note688.html')), I boast,
>   
> Hosts have consumed his cattle,
>   
> The goodness of O'Mochaine is exalted.
> 
> 
> ---
> 
> p.251
> 
> 164. Muc Dubh[689](javascript:footNote('T105008/note689.html')) and the flowery Beartrach[690](javascript:footNote('T105008/note690.html'))
>   
> O'Floinn[691](javascript:footNote('T105008/note691.html')) obtained, it is cause of wealth,
>   
> A hero not weak to be opposed,
>   
> The flowery Brughaidh of Beartrach.
> 165. O'h-Imhair[692](javascript:footNote('T105008/note692.html')), who was not penurious to the clergy,
>   
> Is of Leacan[693](javascript:footNote('T105008/note693.html')) of the smooth-sodded land,
>   
> A man worthy of every man,
>   
> The melodious yellow-haired chieftain.
> 166. Mullach Ratha[694](javascript:footNote('T105008/note694.html')) of the fair roads,
>   
> O'Loingseachain[695](javascript:footNote('T105008/note695.html')) of the slender swords obtained
>   
> A soil like the fair soil of Meath throughout
>   
> The land of a sept of the Hy-Fiachrach.
> 167. O'Spelan[696](javascript:footNote('T105008/note696.html')) of the golden spurs obtained
>   
> Coillin[697](javascript:footNote('T105008/note697.html')) Aedha at the time of the meeting,
>   
> His host cannot be watched,
>   
> Pity to mention him *as possessing only* a half townland.
> 
> 
> ---
> 
> p.253
> 
> 170. Rath Berchan[698](javascript:footNote('T105008/note698.html')) of flowery woods
>   
> *Is* a land in which wine banquets are found,
>   
> O'Fualairg[699](javascript:footNote('T105008/note699.html')) obtained the banquets of that soil,
>   
> By whom warlike Cera was sore plundered.
> 171. Cill Fainnle[700](javascript:footNote('T105008/note700.html')) of the soft crops
>   
> Is O'Breslens[701](javascript:footNote('T105008/note701.html')) who experienced envy,
>   
> His people are without oppression or detriment,
>   
> With whom the happiness of the Ollamhs was best.
> 172. The victorious O'Connachtan's[702](javascript:footNote('T105008/note702.html')) portion
>   
> Of the wide famous plain, — 
>   
> Each hazel is rich from the hero[703](javascript:footNote('T105008/note703.html')), — 
>   
> Is the beautiful land of Cabrach[704](javascript:footNote('T105008/note704.html')).
> 173. At one time, by force,
>   
> A sept of the regal lineage,
>   
> The Clann Neill[705](javascript:footNote('T105008/note705.html')), seized upon the land of these men;
>   
> Not feeble from the heroes was their reckoning.[706](javascript:footNote('T105008/note706.html'))
> 174. They met each other without blemish,
>   
> The Clann Neill of expert lances
>   
> And the brave Clann Caemhain
>   
> Of the slender-white warlike spear-shafts.
> 
> 
> ---
> 
> p.255
> 
> 177. Muircheartach Mac Neill[707](javascript:footNote('T105008/note707.html')) is slain
>   
> And O'Caemhain of the smooth skin,
>   
> In a contest for this southern tract,
>   
> By these tribes, the best I have mentioned.
> 178. Then mightily entered on the land
>   
> The Clann Caemhain of sharp spears,
>   
> Beyond the strength of the other sept,
>   
> By strength of charter[708](javascript:footNote('T105008/note708.html')) and conflict.
> 179. O'Caomhain of the green swords obtained
>   
> Sais Sgrebhainn[709](javascript:footNote('T105008/note709.html')) of the bright streams,
>   
> A flowery land bright-sided as the wave,
>   
> Fort of the splendid lime-doors[710](javascript:footNote('T105008/note710.html')).
>   
> As the mansion seat of his race
>   
> The hazel-yellowest field I sing of.
> 180. From Gleoir, which was not won by foreign javelins,
>   
> To Iasca[711](javascript:footNote('T105008/note711.html')) of the land of the white-blossomed apple trees,
>   
> Belongs to the O'Mailduins[712](javascript:footNote('T105008/note712.html')) of high renown,
>   
> Scions who respect the ollamh.
> 181. O'Ruarach[713](javascript:footNote('T105008/note713.html')) of the rapid onsets got
>   
> Lia Con[714](javascript:footNote('T105008/note714.html')), the support of the strangers,
> 
> 
> ---
> 
> p.257
> 
> 
> For all its produce is abundant,
>   
> Which is the best cause for praising it.
> 182. I have brought, — brave the hero, — 
>   
> O'Feinneadha[715](javascript:footNote('T105008/note715.html')), the soldier,
>   
> To Finghid[716](javascript:footNote('T105008/note716.html')), the plain of the battles,
>   
> From which the bards depart not displeased.
> 183. After the extermination of O'Feinneadha there,
>   
> O'Flannghaile[717](javascript:footNote('T105008/note717.html')) obtained the land,
>   
> A smooth soil, not rugged for tillage[718](javascript:footNote('T105008/note718.html')),
>   
> Like the smooth-mounded land of Cruachan.
> 184. Imleach Isil[719](javascript:footNote('T105008/note719.html')) of the smooth grass
>   
> Belongs to O'Mailduin, as I certify,
>   
> A mede-abounding seat by sea and land,
>   
> So that I love the surface of the land.
> 185. To Muirsce[720](javascript:footNote('T105008/note720.html')) let us go after it,
>   
> From the Iasca of the salmon-abounding soil
>   
> The O'Conbhuidhes[721](javascript:footNote('T105008/note721.html')) are the head of the tribe,
>   
> Powerful is the host protecting us.
> 
> 
> ---
> 
> p.259
> 
> 188. O'Luachain[722](javascript:footNote('T105008/note722.html')) of the thin *sword-*blade.
>   
> Over all is the active head
>   
> At Ros Laegh[723](javascript:footNote('T105008/note723.html')) of the fair smooth shafts,
>   
> A noble clan who sustained each conflict.
> 189. Cluain na g-cliabhach[724](javascript:footNote('T105008/note724.html')) of the smooth hazles,
>   
> Alt Fharannain[725](javascript:footNote('T105008/note725.html')), the miraculous,
>   
> *Belong* to O'Rothlain[726](javascript:footNote('T105008/note726.html')), not penurious of cattle,
>   
> Who freely distributes the cattle of his enemies.
> 190. Over Dun Mailduibh[727](javascript:footNote('T105008/note727.html')) of the flowery seats,
>   
> As a brave and affluent Brughaidh,
>   
> Is O'Duibhscuile[728](javascript:footNote('T105008/note728.html')), beautiful his stud,
>   
> The Earl of all the Brughaidhs[729](javascript:footNote('T105008/note729.html'))!
> 191. O'Beollain[730](javascript:footNote('T105008/note730.html')), who refused no man, obtained
> 
> 
> ---
> 
> p.261
> 
> 
> Dun Ultain[731](javascript:footNote('T105008/note731.html')) of the deep river mouth[732](javascript:footNote('T105008/note732.html')),
>   
> The Brughaidh who is mentioned by us
>   
> Is a brave hero, whom I trust.
> 192. His name from the fair townland he has received
>   
> A Brughaidh of fair and strong rath (fort),
>   
> Mac Gillachais[733](javascript:footNote('T105008/note733.html')) of the smooth hazels,
>   
> Who never slunk back from the conflict.
> 193. Of Dun m-Becin[734](javascript:footNote('T105008/note734.html')) of the white edifices
>   
> *Are* the Mag Eoghains[735](javascript:footNote('T105008/note735.html')) and the Clann Cuanan,
>   
> Two Brughaidhs in the happy rath[736](javascript:footNote('T105008/note736.html'))
>   
> On the flowery, constantly festive hill.
> 194. O'Discin[737](javascript:footNote('T105008/note737.html')), who refused not the learned, got
>   
> The townland from him *called,* entirely
>   
> The land is named from the man
>   
> For whom the fair-skinned hazel grows fair and large.
> 195. O'Conbhuidhe[738](javascript:footNote('T105008/note738.html')), who is dear to us, obtained
>   
> A wide and beauteous land,
> 
> 
> ---
> 
> p.263
> 
> 
> Dun Neill[739](javascript:footNote('T105008/note739.html')), soil of bright aspect,
>   
> It is plain in our rule before us.
> 196. Let us pass from the mede-abounding Muirsci[740](javascript:footNote('T105008/note740.html'))
>   
> To Borrach[741](javascript:footNote('T105008/note741.html')) the flowery, arborous,
>   
> There is no misfortune over the land of the man,
>   
> O'Murchadha[742](javascript:footNote('T105008/note742.html')) is its lordly chieftain.
> 197. O'Suidhlearga[743](javascript:footNote('T105008/note743.html')), O'Cuain[744](javascript:footNote('T105008/note744.html')) the comely,
>   
> O'Dunchadha[745](javascript:footNote('T105008/note745.html')), who enjoyed delight,
>   
> Dun Ui Chobhthaigh[746](javascript:footNote('T105008/note746.html')) is the land of the men
>   
> With whom a stand of noble spears is placed.
> 198. O'Colman[747](javascript:footNote('T105008/note747.html')) has a brave share obtained,
>   
> Grainseach Mor[748](javascript:footNote('T105008/note748.html')), the seat of Patrick,
>   
> Of Grainseach Beag[749](javascript:footNote('T105008/note749.html')), victorious the spot,
>   
> O'Fuala[750](javascript:footNote('T105008/note750.html')) has liberty in the land.
> 
> 
> ---
> 
> p.265
> 
> 201. O'Ceallaigh of smooth lances obtained
>   
> Ard O'g-Ceallaigh[751](javascript:footNote('T105008/note751.html')) with triumph,
>   
> He transmitted the valour of the tribe to his posterity,
>   
> A plain like Meath is under his stewards.
> 202. O'Loingsigh[752](javascript:footNote('T105008/note752.html')) of large blades
>   
> Is at Corcach[753](javascript:footNote('T105008/note753.html')) without a rival,
>   
> Hosts protect the hero,
>   
> The lawful heir of Corcach.
> 203. Dun Floinn[754](javascript:footNote('T105008/note754.html')), which none durst invade,
>   
> O'Murchadha[755](javascript:footNote('T105008/note755.html')) of the smooth plain obtained,
>   
> A white-wattled edifice[756](javascript:footNote('T105008/note756.html')) of noble polish,
>   
> Habitation of the sweet-scented branches.
> 204. From Borrach[757](javascript:footNote('T105008/note757.html')), which was not wounded by a satire[758](javascript:footNote('T105008/note758.html'))
>   
> Let us proceed to the strand[759](javascript:footNote('T105008/note759.html')) without reproach,
> 
> 
> ---
> 
> p.267
> 
> 
> To await them at the cave of the land,
>   
> O'Muirgheasa[760](javascript:footNote('T105008/note760.html')), whom I praise, obtained it.
> 205. O'Sinna[761](javascript:footNote('T105008/note761.html')) of the successful spears
>   
> Obtained Lathrach[762](javascript:footNote('T105008/note762.html')) as his full choice,
>   
> It is nobler than the old land of Sodhan[763](javascript:footNote('T105008/note763.html')),
>   
> A fresh land of fruitful produce.
> 206. Let us pass, may it be a felicitous tour,
>   
> To the habitation of the Patron,
>   
> *To* a people to whom honour and tribute have submitted,
>   
> Let us pass to the habitation of St. Adamnan[764](javascript:footNote('T105008/note764.html')).
> 207. A tribe which ought to be recorded
>   
> In Scrin[765](javascript:footNote('T105008/note765.html')) is their mighty roll [charter],
> 
> 
> ---
> 
> p.269
> 
> 
> I shall not omit a representative of the people;
>   
> Five brave men of the cluster are *these that follow*.
> 208. Mag Rodan[766](javascript:footNote('T105008/note766.html')), O'h-Oilmic[767](javascript:footNote('T105008/note767.html')), *are* there,
>   
> Mac Concathrach[768](javascript:footNote('T105008/note768.html')) of friends,
>   
> O'Snedarna[769](javascript:footNote('T105008/note769.html')), to whom valour gave a hostage,
>   
> A mightly representative clinging to an inheritance;
>   
> Their deed and their valour are praised,
>   
> Of them are the prosperous O'Rabhartaighs[770](javascript:footNote('T105008/note770.html')).
> 209. Cluain Ui Chosgraidh[771](javascript:footNote('T105008/note771.html')) of the smooth hazels,
>   
> A land not won by the strangers,
>   
> O'Baethghaile[772](javascript:footNote('T105008/note772.html')) obtained that land
>   
> By whom the meetings of foreigners were stained.
> 210. The Mac Gilli Finns[773](javascript:footNote('T105008/note773.html')) of sharp weapons,
>   
> A sept who used to supply food to the ravens[774](javascript:footNote('T105008/note774.html')),
>   
> Are in Leamhach[775](javascript:footNote('T105008/note775.html')), *and* in poetical books[776](javascript:footNote('T105008/note776.html')),
>   
> A noble comely-faced people.
> 
> 
> ---
> 
> p.271
> 
> 213. The Mac Gilli Bricins[777](javascript:footNote('T105008/note777.html')) without reproach,
>   
> A tribe of brave career
>   
> At Ard na n-glass[778](javascript:footNote('T105008/note778.html')), comely the race,
>   
> Tribes have heard it universally.
> 214. Mac Gillimir[779](javascript:footNote('T105008/note779.html')), who refused not the learned,
>   
> Obtained Finnabhair[780](javascript:footNote('T105008/note780.html')) of the fair plains,
>   
> A Brughaidh who opposed hundreds,
>   
> Who exalted the hill of Tuathal[781](javascript:footNote('T105008/note781.html')).
> 215. Mac Gilli Riabhaigh[782](javascript:footNote('T105008/note782.html')) with prosperity,
>   
> Is of Crichan[783](javascript:footNote('T105008/note783.html')) of the swift hounds,
>   
> Great his mirth and his mind
>   
> On the lands of his lord.
> 216. Muine na Fede[784](javascript:footNote('T105008/note784.html')) of banquets
>   
> *Belongs* to O'Liathain[785](javascript:footNote('T105008/note785.html')) of high mind,
>   
> A man who is brave in wounding conflicts,
>   
> Whose house is a residence for poets.
> 217. Of Cuil Cille Bricin[786](javascript:footNote('T105008/note786.html')) without bondage,
>   
> A land which enemies have not seen,
> 
> 
> ---
> 
> p.273
> 
> 
> Mac Conluain[787](javascript:footNote('T105008/note787.html')) is mentioned by us
>   
> Who bravely went beyond emulation.
> 218. Lis na Remur[788](javascript:footNote('T105008/note788.html')) of hot roads,
>   
> A land of beautiful water,
>   
> Mac Gilli Bhain[789](javascript:footNote('T105008/note789.html')) obtained the land,
>   
> Who vigorously entered the conflict.
> 219. O'Duinchinn[790](javascript:footNote('T105008/note790.html')) of just condition,
>   
> A **brughaidh** who feeds the strangers,
>   
> Doire na n-Ath[791](javascript:footNote('T105008/note791.html')) is the land of his men
>   
> On which every fair-nutted hazel is constantly found.
> 220. Ton re go[792](javascript:footNote('T105008/note792.html')), where the wave is fruitful,
>   
> Land of sloes and apples,
>   
> Belongs to O'h-Aodha[793](javascript:footNote('T105008/note793.html')) who refused not the literati,
>   
> Branches whose triumph is not concealed.
> 221. There are upon the land which I have praised
>   
> Two chiefs of powerful sway,
>   
> Whose feats have protected many,
>   
> O'Maenaigh[794](javascript:footNote('T105008/note794.html')) and O'Muirgheasa[795](javascript:footNote('T105008/note795.html')).
> 
> 
> ---
> 
> p.275
> 
> 224. Lis Ladhghaill[796](javascript:footNote('T105008/note796.html')), where the branch is purple,
>   
> The youth O'Muirghesa obtained
>   
> The head seat of the eastern district,
>   
> Where the corn-fields are quick of growth.
> 225. O'Dunchadha[797](javascript:footNote('T105008/note797.html')) of the learned men obtained,
>   
> As far as the beauteous stream of salmons[798](javascript:footNote('T105008/note798.html')),
>   
> Every book that speaks to us,
>   
> As it behoveth advantage I mention.
> 226. Let us pass into Cairbre of the battles,
>   
> Let us leave this soil of the Hy-Fiachrach,
>   
> Let us speak quickly of every side,
>   
> Let us give each district to its chieftain.
> 227. Let us speak quietly of their kings,
>   
> Of the O'Mailcluithis[799](javascript:footNote('T105008/note799.html')) of the becoming deeds,
>   
> *Of* the plunders from the Hy-Niall in the east,
>   
> To the heroes of Cairbre *belong* these acquisitions.
> 228. O'Scannail[800](javascript:footNote('T105008/note800.html')) of the sweet mouth obtained,
>   
> By sway of the land we mention,
> 
> 
> ---
> 
> p.277
> 
> 
> A *smooth* land of most extensive tillage,
>   
> Of the green land of Beinn Gulban[801](javascript:footNote('T105008/note801.html')).
> 229. Of Callraidhe Laithim[802](javascript:footNote('T105008/note802.html')) of the swords
>   
> O'Nuadhan[803](javascript:footNote('T105008/note803.html')) obtained the land,
>   
> A droppy, sandy, fine land,
>   
> An angelic pure place of meetings.
> 230. O'Ciardha[804](javascript:footNote('T105008/note804.html')) obtained heavy profit
>   
> Of the land of Cairbre, I conceal it not,
>   
> For O'Ciardha of the yellow crops
>   
> The fragrant tree was not slow in bearing.
> 231. Of the dividend of the Hy-Fiachrach themselves
>   
> Is the land of Cairbre of the level plains,
> 
> 
> ---
> 
> p.279
> 
> 
> But of the Hy-Neill is the lineage of the men[805](javascript:footNote('T105008/note805.html')),
>   
> Easy for poets to enumerate them.
> 232. Though noble the race of the men,
>   
> The Clann Cairbre of the flowery white mansions,
>   
> Are under the steward of the western people[806](javascript:footNote('T105008/note806.html')),
>   
> Noble are their people from this high submission.
> 233. From the *Rodhba*[807](javascript:footNote('T105008/note807.html')) of prosperous course
>   
> I have bravely pursued my career,
>   
> To the Codhnach of winding current,
>   
> Which serves the bovine crop[808](javascript:footNote('T105008/note808.html')).
> 234. Let us now return back
>   
> To the kings of the Rath Durlais[809](javascript:footNote('T105008/note809.html')),
>   
> To afford knowledge to the race
>   
> By the bright clear guide of genealogy.
> 235. The place of the banquet[810](javascript:footNote('T105008/note810.html')) in each powerful territory
>   
> I shall name for the tribes of the smooth sod,
> 
> 
> ---
> 
> p.281
> 
> 
> Prominent in the line of each book
>   
> Is this tribe, the best to strangers.
> 236. Oileach of the kings[811](javascript:footNote('T105008/note811.html')) west of the wave,
>   
> Dumha Caechain[812](javascript:footNote('T105008/note812.html')), as I sing,
>   
> Prodigious the shadow of their corn-fields,
>   
> Two beautiful forts over estuaries[813](javascript:footNote('T105008/note813.html')).
> 237. After my return from the cold Irrus
>   
> I shall name the habitation of the great hosts,
>   
> Dun Fine[814](javascript:footNote('T105008/note814.html')) of the spear-armed troops
>   
> Belongs to a tribe of numerous families.
> 238. Raith Branduibh[815](javascript:footNote('T105008/note815.html')) of the track of prosperity,
>   
> The noble mansion of the arch-chieftain,
>   
> Is the mansion seat of Conn's descendant[816](javascript:footNote('T105008/note816.html')),
>   
> A field where the fruit pods are yellow-bearded.
> 239. Loch Deala[817](javascript:footNote('T105008/note817.html')) not scarce of bushes,
>   
> Inis Cua[818](javascript:footNote('T105008/note818.html')) of the fair-spotted trouts.
> 
> 
> ---
> 
> p.283
> 
> 
> Are two other mansions of the tribe
>   
> Who gave not strait refusal to strangers.
> 240. Eanach Dubhain of the rapid ships[819](javascript:footNote('T105008/note819.html'))
>   
> Is a banquetting place of the fair tribes,
>   
> A very bright fort is mentioned here,
>   
> District of sloes and apples.
> 241. Dun mic Conchobhair[820](javascript:footNote('T105008/note820.html')) of plunders,
>   
> A mansion in which no false sentence was passed,
>   
> Ichtar Ratha[821](javascript:footNote('T105008/note821.html')) at which the sea is smooth,
>   
> With a prosperous griffin of the princes.
> 242. Dun Contreathan[822](javascript:footNote('T105008/note822.html')) of the frothy waves,
>   
> A mansion in which winy banquets are found,
>   
> Is the banqueting hall of the plundering descendant of Conn,
>   
> On the green of the wide-sodded land.
> 243. The two Draighneachs[823](javascript:footNote('T105008/note823.html')) of red colour,
>   
> The wide mansion of the Hy-Fiachrach,
> 
> 
> ---
> 
> p.285
> 
> 
> Bun Fhinne[824](javascript:footNote('T105008/note824.html')) is another habitation,
>   
> A white wattled pile of hosts.
> 244. Let us proceed, — may it be a prosperous journey, — 
>   
> After *giving* the genealogical ramifications,
>   
> To the lord of Durlas[825](javascript:footNote('T105008/note825.html')), with whom I am great,
>   
> From the host who have ornamented us.
> 245. I will obtain, as has each man,
>   
> The fruits, by God's permission,
>   
> Of having praised all his country,
>   
> Fruits *worthy* of Conn and Conaire[826](javascript:footNote('T105008/note826.html')).
> 246. In the time of Tadhg, who refused not a man,
>   
> O'Dubhda, who received obeisance,
>   
> Than the kernels of the fragrant hazel nuts,
>   
> Not larger were the apples of the apple trees[827](javascript:footNote('T105008/note827.html')).
> 
> 
> ---
> 
> p.287
> 
> 249. In thy time the floods have decreased[828](javascript:footNote('T105008/note828.html')),
>   
> O white-fingered tower of Maenmagh[829](javascript:footNote('T105008/note829.html')),
>   
> Every person by thy side is of heavy prosperity,
>   
> Under thy steward in the land of Hy-Fiachrach.
> 250. Fertility has come in the land
>   
> In thy time, O ruddy face of brown eye-brows,
>   
> As thou hast brought down every moistening shower[830](javascript:footNote('T105008/note830.html')),
>   
> Thou hast given milk to our milch-cows.
> 251. O son of Domhnall[831](javascript:footNote('T105008/note831.html')) of Dun Guaire[832](javascript:footNote('T105008/note832.html')),
>   
> Oft have we been relieved from distress
>   
> By the rent of Ceara to us distributed,
>   
> Which the trees and the soil confessed.[833](javascript:footNote('T105008/note833.html'))
> 252. Oft is carried from thy palace,
>   
> In the company of poets and saints,
>   
> Cattle from the fort near Leamhach[834](javascript:footNote('T105008/note834.html'))
>   
> By the fraternity of the arborous Buill[835](javascript:footNote('T105008/note835.html')),
> 
> 
> ---
> 
> p.289
> 
> 255. To Cruachan[836](javascript:footNote('T105008/note836.html')) of the purple-berried trees
>   
> Proceed in the track of thy ancestors,
>   
> Pass thy time in the fort of Meadhbh[837](javascript:footNote('T105008/note837.html')),
>   
> Remove from that fort its dejection[838](javascript:footNote('T105008/note838.html')).
> 256. Every band *of the literati* that comes to the north,
>   
> Whom thou invitest westwards across the old Muaidh,
>   
> Brings a pledge from Ara of the plain of Murbhach[839](javascript:footNote('T105008/note839.html'))
>   
> To the beauteous Tir Amhalgaidh[840](javascript:footNote('T105008/note840.html')).
> 257. Forsake not for Cruachan of the race of Conn,
>   
> The plain of the Muaidh of the defensive forts,
>   
> It would be a shame to neglect the cultivation of its fair plain
>   
> While caring the plain of Cruachan.
> 258. Though delightful is Cruachan of the plains,
>   
> And Ceara[841](javascript:footNote('T105008/note841.html')) of the full-grown bushes,
>   
> It is better to dwell in the western land,
>   
> The level soil of Maicnia's plain[842](javascript:footNote('T105008/note842.html')).
> 
> 
> ---
> 
> p.291
> 
> 261. The fort of Durlas[843](javascript:footNote('T105008/note843.html')) of lasting fame
>   
> Forsake not for the plain of Cruachan,
>   
> The white-sheeted fort of soft trees
>   
> Habitation of poets and bishops.
> 262. To Durlas shouldst thou desire to go
>   
> O son of Domhnall of the fort of Gailian[844](javascript:footNote('T105008/note844.html')),
>   
> Pursue the example of the kings before thee,
>   
> O griffin of the battle-fort of Conaire.[845](javascript:footNote('T105008/note845.html'))
> 263. There will be around thee rising out
>   
> The chieftains of this land of Hy-Fiachrach,
>   
> And the lord of this yonder country
>   
> With whom thou mayest march into the land of strangers.
> 264. To be alone is not hereditary to thee,
>   
> O O'Dubhda of the fort of Cormac[846](javascript:footNote('T105008/note846.html'))!
>   
> Thy people have satin under thy medes,
>   
> A host the most ripe for poets.
> 265. The chiefs of Ceara under thy bright aspect,
>   
> The host of Irrus to urge the conflict,
>   
> The Hy-Amhalgaidh, host of lances,
>   
> Of the great Milesian Gamanradii[847](javascript:footNote('T105008/note847.html')).
> 
> 
> ---
> 
> p.293
> 
> 268. Should a host of strangers meet thee
>   
> *To contend* for this island of Patrick's city[848](javascript:footNote('T105008/note848.html')),
>   
> That host would not recognize each other
>   
> After encountering thee in battle.
> 269. O son of Domhnall of the fort of Conn[849](javascript:footNote('T105008/note849.html')),
>   
> Thou art the heir of the daughter of Domhnall[850](javascript:footNote('T105008/note850.html'));
>   
> The fame of the two Domhnalls[851](javascript:footNote('T105008/note851.html')) follow thee,
>   
> Which will sustain thy blood in the conflict.
> 270. Not more hereditary to thee is the plain of Muaidh,
>   
> Than the land of the green-sided Tara,
>   
> As is found by my school in their writings,
>   
> And the region *eastwards to* the old Alps[852](javascript:footNote('T105008/note852.html')).
> 271. The race of Fiachra when rising out
>   
> Under this king of the land of Hy-Fiachrach,
>   
> Are a host dreaded by every tribe,
>   
> The kine of Cruachan are obtained by their chief men.
> 272. Let them proceed, — may it be a felicitous journey, — 
>   
> To Cruachan of the Clann Conchobhair[853](javascript:footNote('T105008/note853.html')),
>   
> His sway over Cruachan to enforce,
>   
> In right of the heir of Tuathal Teachtmhar[854](javascript:footNote('T105008/note854.html')).
> 
> 
> ---
> 
> p.295
> 
> 275. He does not shrink from the spear of battle,
>   
> The grandson of Brian[855](javascript:footNote('T105008/note855.html')) of splendid aspect,
>   
> In the field at the hour of valour,
>   
> The host who recognize him are timid.
> 276. In imitation of the kings before him,
>   
> O'Dubhda, hero of the fort of Laeghaire[856](javascript:footNote('T105008/note856.html')),
>   
> Has his attention fixed on the house of Tuathal[857](javascript:footNote('T105008/note857.html')),
>   
> And on every town round Cruachan of fair hazels.
> 277. The palm for beauty has his brunette-face won,
>   
> And eke for valour and submission,
>   
> He has got besides these acquirements
>   
> The gift of recognition and eloquence.
> 278. Cause of exaltation of mind
>   
> For this lord, that he has stoutly contested
>   
> A new smooth angle of the calm sea
>   
> Along the green Tir Amhalgaidh[858](javascript:footNote('T105008/note858.html')).
> 279. The bards of the world will say
>   
> To the heir of this land of saints,
>   
> Sufficiently has he expended his wealth,
>   
> It is great to exalt each goodness.
> 280. The son of Domhnall of the fort of Meadhbh[859](javascript:footNote('T105008/note859.html')),
>   
> A manly great-faced hero,
> 
> 
> ---
> 
> p.297
> 
> 
> Has in profusion spent his wealth;
>   
> That which is bestowed well is the most generously bestowed.
> 281. Not more nobly do the learned of the race of Conn
>   
> Panegyrize the good son of Domhnall,
>   
> Than does the produce of the western country
>   
> Praise that griffin of Gailian[860](javascript:footNote('T105008/note860.html')).
> 282. Had not Fearfeasa[861](javascript:footNote('T105008/note861.html')) sung
>   
> I would *now* sing the family tree
>   
> For O'Dubhda, whose house is Tara,
>   
> And his fair genealogical lineage.
> 283. I have composed for this skin like the wave,
>   
> For the just-judging heir of Domhnall,
>   
> An account, of the constant inheritance of each man
>   
> As far as the soft-feathered fort of Codhnach[862](javascript:footNote('T105008/note862.html')).
> 284. A noble queen of the race of Conn,
>   
> The white-toothed daughter of O'Donnell[863](javascript:footNote('T105008/note863.html')),
>   
> Not small is the victory of the woman of Murbhach[864](javascript:footNote('T105008/note864.html'))
>   
> From the beauty she received from the ollamhs[865](javascript:footNote('T105008/note865.html')).
> 
> 
> ---
> 
> p.299
> 
> 287. The daughter of O'Donnell of Derry[866](javascript:footNote('T105008/note866.html'))
>   
> Is a branch of the regal lineage;
>   
> The beauty of the women in the west under *our chieftain*
>   
> Approach not the mien of Raghnailt.
> 288. Many are the miracles of Mary[867](javascript:footNote('T105008/note867.html')),
>   
> Mother of Jesus of the yellow hair[868](javascript:footNote('T105008/note868.html')),
>   
> Who brought forth, without sorrow in her town;
>   
> Great is her son in miracles.
> 289. From the birth of Christ, who defended fame, *i. e. character*,
>   
> Until this poem was proved,
>   
> Are four hundred and one thousand fleeting *years*,
>   
> Not false the age that is mentioned,
>   
> *And* seventeen years[869](javascript:footNote('T105008/note869.html')) without obscurity;
>   
> Not obscure is the select flock[870](javascript:footNote('T105008/note870.html')).
> 




#### 


*Here follow* some of the chieftains of the O'Dubhdas, with the title which historical books give them, namely, the title of king, and though strange this *appears* at this day[871](javascript:footNote('T105008/note871.html')), it was not so then among the Gaels according to their own laws at that time, and according to other nations also. Behold before the coming of the children of Israel to the land of promise, how there were thirty kings together in that country, and it not more than two hundred miles in



---

p.301



length and fifty miles in breadth. This country was called the Land of Canaan from Canan, son of Cam, son of Noah, afterwards the Land of Promise, because God had promised it to Abraham and his seed; Israel after that, from the children of Israel; Judaea, from the Jews; Palestine, from the Philistines; and the Holy Land, from the work of our salvation having been effected in it, and the birth and crucifixion of Christ.


#### 


Understand that it is the Annals of the deaths of the chiefs that are written down here, as follows:


Anno Christi, 983. Aodh O'Dubhda[872](javascript:footNote('T105008/note872.html')), King of all North Connaught, died.


1005. Maolruanaidh[873](javascript:footNote('T105008/note873.html')) O'Dubhda, King of Hy-Fiachrach of Muirsge *[died]*.


1096. Muircheartach O'Dubhda[874](javascript:footNote('T105008/note874.html')), King of Hy-Amhalgaidh, Hy-Fiachrach, and Ceara, was slain.


1126. Domhnall Fionn O'Dubhda[875](javascript:footNote('T105008/note875.html')), King of Hy-Amhalgaidh, Hy-Fiachrach, and Ceara, was drowned as he was carrying off a prey from Tirconnell.


1143. Aodh, son of Muircheartach O'Dubhda[876](javascript:footNote('T105008/note876.html')), King of Hy-Amhalgaidh, and the Northern Hy-Fiachrach *[died]*. 
  

Ruaidhri Mear[877](javascript:footNote('T105008/note877.html')), son of Taithleach, son of Niall O'Dubhda, *was* King *of the country extending* from the Roba to the Codhnach.




---

p.303


1162. Cosnamhaigh[878](javascript:footNote('T105008/note878.html')) O'Dubhda, heir apparent of Hy-Amhalgaidh, was slain.


1180. In this year departed Sadhbh[879](javascript:footNote('T105008/note879.html')), daughter of Muirgheas, son of Tadhg O'Maoilruanaidh, and the wife of Taithleach O'Dubhda, who possessed the country extending from the Robhba to the Codhnach[880](javascript:footNote('T105008/note880.html')).


1181. Cosnamhaigh, son of Cosnamhaigh[881](javascript:footNote('T105008/note881.html')) O'Dubhda, heir apparent of the Hy-Amhalgaidh, was slain.


1213. Donnchadh O'Dubhda[882](javascript:footNote('T105008/note882.html')) *sailed* with a fleet of fifty-six ships from the Insi Gall[883](javascript:footNote('T105008/note883.html')), and landed on Inis Raithin[884](javascript:footNote('T105008/note884.html')), one of the Insi Modh[885](javascript:footNote('T105008/note885.html')), in Umhall[886](javascript:footNote('T105008/note886.html')), and wrested his own land free of tribute from Cathal Croibhdhearg[887](javascript:footNote('T105008/note887.html')) O'Conor.


1242. Brian Dearg O'Dubhda[888](javascript:footNote('T105008/note888.html')), son of Donnchadh, King of Hy-Fiachrach, Hy-Amhalgaidh, and Iorrus, was slain.


1282. Taithleach, son of Maolruanaidh O'Dubhda[889](javascript:footNote('T105008/note889.html')) King of Hy-Fiachrach and Hy-Amhalgaidh, was slain.




---

p.305


1291. Conchobhar Conallach[890](javascript:footNote('T105008/note890.html')) O'Dubhda, lord of Hy-Fiachrach, was drowned in the Shannon. 


1337. Donnchadh Mor O'Dubhda[891](javascript:footNote('T105008/note891.html')), heir apparent to the throne of Hy-Fiachrach, died.


1350. William O'Dubhda, Bishop of Killala[892](javascript:footNote('T105008/note892.html')), died.


1534. Brian O'Dubhda[893](javascript:footNote('T105008/note893.html')), King of Hy-Fiachrach and Hy-Amhalgaidh, died in his own house after having been eighty-four *[recte fifty-four]* years in the lordship.


1380. Domhnall Clereach[894](javascript:footNote('T105008/note894.html')), son of Brian O'Dubhda, King of Hy-Fiachrach and Hy-Amhalgaidh, died after a reign of thirty-six years.


1417. Ruaidhri[895](javascript:footNote('T105008/note895.html')), son of Domhnall Clereach O'Dubhda, King of Hy-Fiachrach and Hy-Amhalgaidh, died at Dun Neill after a reign of thirty seven years.


1432. Tadhg Riabhach[896](javascript:footNote('T105008/note896.html')) O'Dubhda, son of Domhnall Clereach King of Hy-Fiachrach, died at Esgir Abhann[897](javascript:footNote('T105008/note897.html')) after a reign of fifteen years. The daughter of O'Malley was the mother of the aforesaid Ruaidhri and Tadhg.




---

p.307


Maolruanaidh[898](javascript:footNote('T105008/note898.html')), son of Ruaidhri O'Dubhda, *was* lord of Tir Fiachrach for eighteen years. The daughter of Mac Costello was his mother. He was made O'Dubhda in the year 1432.


Domhnall of Baile Ui Choitil[899](javascript:footNote('T105008/note899.html')), was O'Dubhda for seven years, and was made O'Dubhda in the year 1447.


Tadhg Buidhe[900](javascript:footNote('T105008/note900.html')), son of Tadhg Riabhach, three years.


John Glas[901](javascript:footNote('T105008/note901.html')), his brother, fourteen years.


Edmond, son of Cosnamhach[902](javascript:footNote('T105008/note902.html')), half a year and five weeks.


Domhnall Ballach[903](javascript:footNote('T105008/note903.html')), one year.


Brian Cam, son of Cosnamhach, two years[904](javascript:footNote('T105008/note904.html')).


Eoghan Caoch[905](javascript:footNote('T105008/note905.html')), son of Ruaidhri, fourteen years.


William, son of Domhnall Ballach[906](javascript:footNote('T105008/note906.html')), half a year.


Brian Og[907](javascript:footNote('T105008/note907.html')), half a year.


Donnchadh Ultach[908](javascript:footNote('T105008/note908.html')) one year.


Maghnus, son of Tadhg Buidhe[909](javascript:footNote('T105008/note909.html')), one year.




---

p.309


Felim, son of Tadhg Buidhe[910](javascript:footNote('T105008/note910.html')), nineteen years.


Conchobhar, son of Diarmaid[911](javascript:footNote('T105008/note911.html')) , son of Maolruanaidh, thirty years.


Eoghan, son of Conchobhar[912](javascript:footNote('T105008/note912.html')), seven years.


Cathal Dubh, son of Conchobhar[913](javascript:footNote('T105008/note913.html')).


*Here follows a list* of the Kings of Connaught of the Clann Fiachrach; for though I have given them already[914](javascript:footNote('T105008/note914.html')), I wish to speak of them more fully here from the remains of other historians.


Fiachra, son of Eochaidh Muighmheadhoin[915](javascript:footNote('T105008/note915.html')), *was* twelve years in the government of Connaught. After his brother Brian had been slain by the Lagenians, Fiachra had served in his place as general of battle to their other brother, namely, Niall of the Nine Hostages, King of Ireland; Fiachra went to exact the rents of King Niall into Munster; *and* the Momonians fought the battle of Caonraighe[916](javascript:footNote('T105008/note916.html')) against Fiachra, in which battle he defeated them and took the hostages of Munster. Howbeit, Fiachra was wounded in that battle by Maighe Meascoradh, one of the Ernaans[917](javascript:footNote('T105008/note917.html')), and he returned with the hostages triumph for Tara; but the Munster hostages acted treacherously 



---

p.311



towards him, having found him unprotected in his sickness, and they buried him alive in the earth in Hy-Mac Uais, in Bregia[918](javascript:footNote('T105008/note918.html')), and thus did he fall a victim!


Dathi, son of the aforesaid Fiachra[919](javascript:footNote('T105008/note919.html')), assumed the chief governent of Connaught and of Ireland, in Connaught, for a period of twenty-three years, when he was killed at the mountain of the Alps by a flash of lightning.


Amhalgaidh, son of Fiachra[920](javascript:footNote('T105008/note920.html')), son of Eochaidh Muighmheadhoin, the first of the Connaught kings who believed on *the preaching of*  St. Patrick. Tir Amhalgaidh is named from him[921](javascript:footNote('T105008/note921.html')). He was thirty-two years in the government of Connaught when he died well.


Oilioll Molt[922](javascript:footNote('T105008/note922.html')), son of Dathi, son of Fiachra, was first, for twenty years in the kingdom of Connaught, and afterwards, twenty years more in the monarchy of Ireland. After this he was slain in the battle of Ocha, by Lughaidh, son of Laoghaire[923](javascript:footNote('T105008/note923.html')) , Muircheartach[924](javascript:footNote('T105008/note924.html')) mac Earca, Fergus Ceirrbheul, son of Conall Cremhthuinn[925](javascript:footNote('T105008/note925.html')), and Fiachra Lonn, King of Dal Araidhe[926](javascript:footNote('T105008/note926.html')).




---

p.313


Eoghan Beul, son of Ceallach, son of Oilioll Molt, was thirty years in the government of Connaught, when he fell in the battle of Sligeach[927](javascript:footNote('T105008/note927.html')) by Fergus and Domhnall
[928](javascript:footNote('T105008/note928.html')), two sons of Muircheartach Mac Earca.


Oilioll Ianbhanna[929](javascript:footNote('T105008/note929.html')), or Anbhanna, son of Muireadhach, son of Eoghan Beul, son of Ceallach, son of Oilioll Molt, nine years, when he fell by Aodh, son of Eochaidh Tiormcharna, of the race of Brian, son of Eochaidh Minghmheadhoin.


Colman, son of Cobhthach[930](javascript:footNote('T105008/note930.html')), son of Goibhnenn, son of Conall, son of Eoghan, son of Eochaidh Breac, son of Dathi, was twenty-one years in the government of Connaught, when he fell in the battle of Ceann Bugha[931](javascript:footNote('T105008/note931.html')), by Raghallach, son of Uadach, son of Aodh.


Lairgneun, son of Colman[932](javascript:footNote('T105008/note932.html')), son of Cobhthach, was seven years in the government of Connaught when he fell.


Guaire Aidhne, son of Colman[933](javascript:footNote('T105008/note933.html')), son of Cobhthach, was thirteen 



---

p.315



years in the government of Connaught when he died penitently, and was interred at Clonmacnoise with great honour and veneration.


Dunchadh Muirsge[934](javascript:footNote('T105008/note934.html')), son of *Tiobraide*, son of Maolduin (or Maoldubh), son of Fiachra Ealgach, son of Dathi, son of Fiachra, was four years in the government of Connaught, when he fell in the battle of Corann by Fergus, lord of Cinel Cairbre.


Feargal of Aidhne[935](javascript:footNote('T105008/note935.html')), son of Artghal, son of Guaire Aidhne, son of Colman, thirteen years, when he died.


Innreachtach, son of Dunchadh Muirsge[936](javascript:footNote('T105008/note936.html')), son of *Tiobraide*, was two years in the government of Connaught, when he fell by Feargal, son of Loingseach, lord of Cinel Conaill, and by Feargal, son of Maolduin, lord of Cinel Eoghain.


Oilioll, son of Innreachtach[937](javascript:footNote('T105008/note937.html')), son of Dunchadh Muirsge, was eight years in the government of Connaught when he died, after *having spent* a virtuous life.




---

p.317


Donncathaigh, son of Cathal[938](javascript:footNote('T105008/note938.html')), son of Oilioll, son of Dunchadh Muirsge, fifteen years, when he died.


Flaithri, son of Domhnall[939](javascript:footNote('T105008/note939.html')), of the race of Guaire, was four years in the government of Connaught, when he died penitently.


Another Flaithri[940](javascript:footNote('T105008/note940.html')) was two years in the government of Connaught, when he resigned his kingdom for God, and went to Hy-Columbkille to apply himself to devotion, where he died on his pilgrimage victorious over the world and the devil. [See pages 259, 260 [of **Duald Mac Firbis**'s genealogical book].


[Of the Clann Fiachrach aforesaid[941](javascript:footNote('T105008/note941.html')), in ancient times, great was the prosperity of the kings and saints, as is obvious in this book, until strangers, and the Irish themselves[942](javascript:footNote('T105008/note942.html')), attacked them, *according to* the righteous decrees of God, who hurls down from their kingly thrones the proud monarchs, who exercise their tyrannical power; according to the old saying, ‘the right of every one is according to his strength,’ by which they assume earthly glory and heavenly ingloriousness. An example of this is afforded by the ancestors of the Gaels, who were in ancient times at strife with their neighbours, when they took Alba from the Cruithni and the Britons[943](javascript:footNote('T105008/note943.html')), and who 



---

p.319



were not satisfied with this, without invading many other countries, as did Niall of the Nine Hostages[944](javascript:footNote('T105008/note944.html')) and others, and also Dathi, son of Fiachra above mentioned, who invaded Alba, Britain, the country of the Gauls, i. e. France, &c., and as far as the mountain of the Alps[945](javascript:footNote('T105008/note945.html')), for his triumphs are obvious to us at this day, as also his death and burial, as Torna Eigeas[946](javascript:footNote('T105008/note946.html')), who lived in the time of Dathi, left written after him, and other learned men have, in successive ages, transmitted a memorial of the same. For it was Flann[947](javascript:footNote('T105008/note947.html')) and Eochaidh Eolach O'Cerin[948](javascript:footNote('T105008/note948.html')) that collected these things from the book of Eochaidh O'Flannagan[949](javascript:footNote('T105008/note949.html')), at Armagh, and from the book of the Monastery[950](javascript:footNote('T105008/note950.html')), and other choice books, such as the Yellow Book[951](javascript:footNote('T105008/note951.html')), which was missed out of the prison at Armagh, and from the Leabhar Gearr[952](javascript:footNote('T105008/note952.html')), which was at Mainister, and which the student carried with him by stealth over the sea, and was never discovered afterwards, &c.




---

p.321


I am Dubhaltach Mac Firbisigh, who transcribed these authorities from the hand-writing of Lughaidh O'Clery of the Contention[953](javascript:footNote('T105008/note953.html')). It is no doubt a worldly lesson to consider how the Gaels were at this time conquering the countries far and near[954](javascript:footNote('T105008/note954.html')), and that not one in a hundred of the Irish nobles, at this day, possesses as much of his land as he could be buried in[955](javascript:footNote('T105008/note955.html')), though they expect it in this year, 1664[956](javascript:footNote('T105008/note956.html')).


This is not the time or place of compiling this book, but this extract I have added some time after.]




---

p.325


Of the Welshmen of Hy-Amhalgaidh Mic Fiachrach
----------------------------------------------

### another extract here from the Books of the Clann Firbis


#### 


The Welshmen of Ireland were the Welsh White Knight[957](javascript:footNote('T105008/note957.html')), who was the brother of William Fionn[958](javascript:footNote('T105008/note958.html')) of Cill Comain[959](javascript:footNote('T105008/note959.html')), who was called William Mor na Maighne[960](javascript:footNote('T105008/note960.html')); Laighleisioch[961](javascript:footNote('T105008/note961.html')), Clann an Fhailghe[962](javascript:footNote('T105008/note962.html')); the Seoaigh[963](javascript:footNote('T105008/note963.html')), of the west of Connaught; the Clann Heil[964](javascript:footNote('T105008/note964.html')); the Mac Uighilins[965](javascript:footNote('T105008/note965.html')) of the Ruta; the Mac Bhaillseachs[966](javascript:footNote('T105008/note966.html')); the Baroideachs of Munster[967](javascript:footNote('T105008/note967.html')); Mac Bhaitin Baired[968](javascript:footNote('T105008/note968.html')), from whom are the Baireadachs of Tir Amhalgaidh; the Clann Toimin of



---

p.327



Iorrus[969](javascript:footNote('T105008/note969.html')); the Clann Aindriu of Bac[970](javascript:footNote('T105008/note970.html')); the Clann Ricin[971](javascript:footNote('T105008/note971.html')), *who descend from* Ricin Og, son of Ricin; Toimilin, from whom are the Clan Toimilin[972](javascript:footNote('T105008/note972.html')); Hosdegh, son of Membhric, from whom are the Clan Hosdegh[973](javascript:footNote('T105008/note973.html')).


It was at the time of the arrival of the English[974](javascript:footNote('T105008/note974.html')) in Ireland with 



---

p.329



Diarmaid Mac Murchadha, King of Leinster, that the people aforesaid came to Ireland; they landed in Tir Amhalgaidh Mic Fiachrach *now Tirawley*, as did likewise *some time after* these four tribes, namely, Cisogachs[975](javascript:footNote('T105008/note975.html')), Petits[976](javascript:footNote('T105008/note976.html')), Brunachs[977](javascript:footNote('T105008/note977.html')), and Murachs[978](javascript:footNote('T105008/note978.html')), and these four tribes assayed to wrest the territory by force from the race of Fiachra; and another authority adds, that these tribes did wrest it from them.


William Fionn of Cill Comain (i. e. William Mor na Maighne) had been for a long time before this as a president over Tir Amhalgaidh guarding it. The natives of this territory remonstrated with this William about this oppression, and William sends letters to these strangers, telling them to desist from their evil deeds, and quit the country, or meet him in battle; the result was, that the great battle of Maighin[979](javascript:footNote('T105008/note979.html'))*now Moyne* was fought between them, in which the strangers *i. e. new invaders* were defeated, and in which fell the Ciosogach with many of his people[980](javascript:footNote('T105008/note980.html')). Hence this William was called William Mor na Maighne. William afterwards attacks the place where a party of these strangers had a ward to defend the country, namely, 



---

p.331



the great Court of Mileac of the lake[981](javascript:footNote('T105008/note981.html')). He took the court from them[982](javascript:footNote('T105008/note982.html')), drives them all from it, and then divides the territory between his own kinsmen; he gave to Mac Bhaitin Baired the court, and all the territory which his family have retained from that day till this, so that he, Mac Bhaitin, is chief and lord over them to this present time.


Another authority gives the name of William Mor Breathnach[983](javascript:footNote('T105008/note983.html')) to the William aforesaid, by whom fell Cusack[984](javascript:footNote('T105008/note984.html')) aforesaid, and states that when Caislen na Circe[985](javascript:footNote('T105008/note985.html')) was erected by this William Mor Breathnach na Maighne he divided the country among kinsmen of his tribe. He gave, first, Gleann Oisdegh[986](javascript:footNote('T105008/note986.html')) to Osdec Mac Meric[987](javascript:footNote('T105008/note987.html')) (or 



---

p.333



Membric); Gleann Nemhthenne[988](javascript:footNote('T105008/note988.html')) to Ricin, and the Two Bacs[989](javascript:footNote('T105008/note989.html')) to Sir Maigiu[990](javascript:footNote('T105008/note990.html')) of Bac, from whom are the Clann Andrew Barrett. He gave *the tract extending* from Fearsad Tresi to Traigh Murbhaigh[991](javascript:footNote('T105008/note991.html')) to Sir William Lawless, i. e. the Lawless[992](javascript:footNote('T105008/note992.html')); and he committed the keeping and defence of the barony of Iorris *[Erris]* to Toimin and to Philip, or Philpin, the grandson of Toimin's brother, and of his race is Mac Philip, or Mac Philbin[993](javascript:footNote('T105008/note993.html')), and from him the Clann Philip, or Philbin, are descended; and it is not to be supposed that he is the Philbin who is traced to the Burkes. Sir William Lawless, son of Robert, son of William, son of Nicholas, was the name of the Lawless to whom William Mor na Maighne[994](javascript:footNote('T105008/note994.html')) gave this tract of land extending from Fearsad Tresi to Traigh Murbhaigh[995](javascript:footNote('T105008/note995.html')).


Envious and ignorant people have said between themselves that the Clann Mac Robert are of the race of Domhnall Iorruis O'Conor[996](javascript:footNote('T105008/note996.html')), but Mac Firbis, namely, James, son of Diarmaid[997](javascript:footNote('T105008/note997.html')), says that they are 



---

p.335



not, but that *Robert, their ancestor,* was the grandson of William, the son of William Mor na Maighne, and their inheritance lies along the Daoil[998](javascript:footNote('T105008/note998.html')), in Tir Amhalgaidh.


Others say that this Clann Mac Robert, or Mac Herbert, is of the Herbeardachs (who are called Hearbardaigh), i. e. the Herberts of the county of Limerick.


From different fragments. The Carrunachs[999](javascript:footNote('T105008/note999.html')) came to Ireland with the descendants of William the Conqueror[1000](javascript:footNote('T105008/note1000.html')) (understand Burk). The Lionoideachs[1001](javascript:footNote('T105008/note1001.html')) came to Ireland with the descendants of the Red Earl[1002](javascript:footNote('T105008/note1002.html')). Another authority says that the Carrunachs came with the descendants of William the Conqueror, and that they are of Saxon origin, while others say that they are of the race of Cathaoir Mor[1003](javascript:footNote('T105008/note1003.html')), and that they came with the Red Earl.


Another authority. Of the nobles who came from the East *[England]* with the descendants of William the Conqueror were the following, viz., Philip Mor, the son of Sir Bernard Sdondun[1004](javascript:footNote('T105008/note1004.html')) a quo Mac a Mhilidh[1005](javascript:footNote('T105008/note1005.html')) of Ceara, Walter Fitz Robert, Sir David Dulpin[1006](javascript:footNote('T105008/note1006.html')), Robert Baroid[1007](javascript:footNote('T105008/note1007.html')), Sir William Carrun. It is right to observe, that as there are Burc, Baired, and Carrun, in Connaught; there are Burc, Baroid, and Carrun, in Munster.


The cause of the coming of the Burkes to take possession of 



---

p.337



lands in Tir Amhalgaidh. At one time when the Barretts had supremacy over Tir Amhalgaidh (as we have said), they sent their steward, who was called Sgornach bhuid bhearrtha[1008](javascript:footNote('T105008/note1008.html')), to exact rents from the Lynotts. The Lynotts killed this steward, and cast his body into a well called Tobar na Sgornaighe[1009](javascript:footNote('T105008/note1009.html')), near Garranard, to the west of the castle of Carns[1010](javascript:footNote('T105008/note1010.html')) in Tir Amhalgaidh. When the Barretts had received intelligence of this, they assembled their armed forces and attacked the Lynotts, and subdued them. And the Barretts gave the Lynotts their choice of *two modes of punishment,* namely, to have their men either blinded or emasculated; and the Lynotts, by advice of some of the elders among them, took the choice of being blinded, because blind men could propagate their species, whereas emasculated men could not. The Barretts then thrust needles into the eyes of the Lynotts, and accordingly as each man of them was blinded, they compelled him to cross over the stepping-stones of Clochan na n-dall, near Carns[1011](javascript:footNote('T105008/note1011.html')), to see if more or less of sight remained with them, and if any of them crossed the Clochan without stumbling he was taken back and re-blinded! Some time after this the Lynotts meditated how they could revenge their animosities on the Barretts, and the contrivance which occurred to their minds, — one derived from their ancestors[1012](javascript:footNote('T105008/note1012.html')), — was to procure a dalta[1013](javascript:footNote('T105008/note1013.html')) *[i. e. an adopted son],* from some powerful man of the Clann William Burke, who, previously to this period, *had inhabited to the south of the mountain* [Nephin]; *or were seated in the territory lying southwards of the mountain* and to this end Lynott fed a spirited horse which the Lynotts took with them to receive the adopted son, in order



---

p.339



that the Burke who should break that steed might be their adopted son. And thus they obtained Teaboid Maol Burke as an adopted son, who was afterwards killed by the Barretts[1014](javascript:footNote('T105008/note1014.html')). So that it was in eric for him that the Barretts gave up to the Burkes eighteen quarters of land[1015](javascript:footNote('T105008/note1015.html')); and the share which Lynott, the adopted father of Teaboid, asked of this eric was the distribution of the mulct, and the distribution he made of it was, that it should be divided throughout all Tir Amhalgaidh, in order that the Burkes might be stationed in every part of it as plagues to the Barretts, and to draw the country from them. And thus the Burkes came over the Barretts in Tir Amhalgaidh, and took nearly the whole of their lands from them; but at length the Saxon heretics of Oliver Cromwell took it from them all, in the year of our Lord 1652; so that now there is neither Barrett nor Burke, not to mention the Clann Fiachrach, in possession of any lands there.




---

p.341




---

p.342




---

p.343


### Addenda: A

### Pedigree of O'Dowd, or O'Dowda


The large Genealogical Table, which will be found at the end of this volume, exhibits the descent of the principal families of the Hy-Fiachrach race in the order of their seniority, as far as that has been discovered, from their great ancestor FIACHRA, the son of Eochaidh Muighmheadhoin, who was the sixth from Conn of the Hundred Battles, to as late a period as the Editor has been able to trace them by the evidence of authentic genealogical manuscripts, the Irish Annals, the English-Irish records, and family documents. As in the pedigrees of the Hy-Many race, it has been thought advisable to place all the principal lines in one view, on a single sheet, that it might be afterwards referred to in the account which will be given of each line separately.


1. *Eochaidh Muighmheadhoin* (pronounced Eochy Moyvane), King of Connaught,
was proclaimed monarch of Ireland in the year 358, and, after a reign of eight years, died at Tara. He married Mongfinn, daughter of Fidach, of the royal family of Munster, and sister of Crimhthann Mor Mac Fidaigh, who succeeded Eochaidh as monarch of Ireland, according to the Four Masters, in the year 366. — (See Battle of
Magh Rath, Additional Notes I.) By Mongfinn this monarch had four sons, namely, 1, Brian, the ancestor of the Hy-Briuin tribes, of whom the O'Conors of Connaught were the most distinguished; 2, Fiachra, the ancestor of the Hy-Fiachrach tribes, of whom the O'Dowds, O'Heynes, and O'Shaughnessys were, at least in later ages, by far the most distinguished families; 3, Fergus; and, 4, Oilioll, from whom Tir Oiliolla, now the barony of Tirerill, in the county of Sligo, received its name Queen Mongfinn, like the Empress Agrippina, actuated by motives of ambition, for the aggrandizement of her offspring, poisoned her brother, the monarch Crimthann, on Inis Dornglas, a small island in the river Moy, in the hope that her eldest son, Brian, might be immediately seated on the throne of Ireland; and in order the more effectually to deceive her brother as to the contents of the proffered cup, she drank of it herself first,



---

p.344



and died of the poison soon after; her brother, on his way home to Munster, died at a place in the south of the present county of Clare, which, from that memorable event, received the appellation of Sliabh Oighidh an righ, or the mountain of the death of the king. It has been, however, remarked by ancient and modern Irish writers that this execrable act of Mongfinn had not the desired effect, for that neither her son Brian, nor any of her posterity, was ever monarch of Ireland, except Turlogh O'Conor and his son Roderic. According to all our ancient authorities King Eochaidh had a second wife, Carinna, who is said to have been of old Saxon descent, and who was the mother of the youngest, though by far the most celebrated, of his sons, namely, Niall of the Nine Hostages, the ancestor of O'Neill of Ulster, and all the other families of the Hy-Niall race. It is stated in the Book of Ballymote, fol. 145, b, a, that the poisoning of her brother Crimthann was of no avail to Queen Mongfinn, for that Niall of the Nine Hostages, the son of King Eochaidh by his second wife, and who had been the general of King Crimthann's forces, succeeded as monarch of Ireland immediately after the poisoning of Crimthann. This clearly shows either that Carinna was Eochaidh's first wife, or that he had the two together, for Mongfinn survived him thirteen years, and Niall of the Nine Hostages, the son, as we are told, of the second wife, was of age to succeed as monarch immediately after Mongfinn had poisoned her brother and herself. However this may have been, we read that in the life-time of Niall of the Nine Hostages, Brian, his brother of the half blood, became King of Connaught, and his second eldest brother of the half blood, Fiachra, the ancestor of the O'Dowds and of all the Hy-Fiachrach tribes, became chief of the district extending from Carn Fearadhaigh, near Limerick, to Magh Mucroimhe, near Athenry. But dissensions soon arose between Brian and his brother Fiachra, and the result was that a battle was fought between them, in which the latter was defeated, captured, and delivered as a hostage into the hands of his half brother, Niall of the Nine Hostages. After this, however, Dathi, the son of Fiachra, a very warlike youth, waged war on his uncle Brian, and challenged him to a pitched battle, at a place called Damh-chluain, situated not far from Knockmaa hill, near Tuam, in the now county of Galway. In this battle, in which Dathi was assisted by Crimthann, son of Enna Cennselach, King of Leinster, Brian and his forces were routed, and pursued from the field of battle to Tulcha Domhnaill, where he was overtaken and slain by Crimthann, son of Enna Cennselach.


The body of Brian was buried at the place where he fell, but after a long lapse of years St Beo Aedli, or *Aidus vivax*, of Roscam, near Galway, removed his bones from that place, and buried them at Roscam; and the writer of the tract on the battle of Damh-cluain, preserved in the Book of Ballymote, adds, ‘the burial-place of Brian is to be seen there at this day.’




---

p.345


2. *Fiachra Foltsnathach*, i. e. *of the flowing hair, son of King Eochaidh.* — After the fall of Brian, the eldest son of King Eochaidh, as before recited, Fiachra, the second son, was set at liberty, and installed King of Connaught, and enjoyed that dignity for twelve years, during which period he was general of the forces of his brother Niall. His death happened in the following manner, according to the Lecan records: — He went on one occasion with the king's forces to raise tribute in Munster, but the inhabitants of that province, who detested him and his race, on account of the conduct of his mother in having poisoned the preceding monarch, who was of their own province and blood, refused to pay the tributes to King Niall, and defied him to battle. They met the king's forces in the territory of Caenraighe, now the barony of Kenry, situated in the county of Limerick, on the south side of the Shannon, where they were defeated, and obliged to give up hostages for their future allegiance. In this battle, however, Fiachra was severely wounded by Maighe Mescora, one of the warlike tribe of the Ernaans of Munster, and he set out in triumph for Tara; but when they had arrived in the territory of Hy-Mac Uais, in Meath, the Munster hostages found Brian unprotected and in a very feeble state from his wounds, and being suddenly actuated by motives of revenge, they seized upon his person and buried him alive in the earth! Thus fell Fiachra a victim to his own incautiousness, according to the Lecan records, which do not tell us a word about what his own chieftains were doing, when he was left thus barbarously unprotected. According to the Book of Lecan this Fiachra had five sons, and if we can rely upon the order in which they are mentioned we should feel inclined to think that the monarch Dathi was the youngest. They are mentioned in the following order: — 1., Earc Culbhuidhe, i. e. of the yellow hair, so called because his hair was of the colour of pure gold, who was the ancestor of the men of Ceara; 2., Breasal, whose race became extinct; 3, Conaire, from whom a St Sechnall is said to have sprung; 4, Amhalgaidh, or Awley, King of Connaught (and ancestor of several ancient families in Tirawley and Erris, in the county of Mayo), who died in the year 449; for some account of whom the reader is referred back to pp. 5–13 of this volume. The seven sons of this Amhalgaidh, together with twelve thousand men, are said to have been baptized in one day by St Patrick, at Forrach Mac n-Amhalgaidh, near Killala — (See Jocelin's Life of St. Patrick, c. 59, and **Colgan**, Trias Thaum. p. 141, col. 2); and, 5, Dathi, the youngest, but most illustrious, of the sons of Fiachra, and the ancestor of all the chiefs of the Hy-Fiachrach race.


3. *Dathi, son of Fiachra Foltsnathach.* — On the death of his father, Fiachra, this warlike chieftain became King of Connaught, and on the death of his uncle, Niall of the Nine Hostages, in the year 405 or 406, he became monarch of Ireland, leaving the government of Connaught to his less warlike brother Amhalgaidh, or Awley, who



---

p.346



lived to receive the doctrines of Christianity from the lips of the Irish apostle, Patrick, and who is set down in all the lists of the kings of Connaught, as the first Christian king of that province. King Dathi, following the example of his predecessor, Niall, not only ventured to invade the coasts of Gaul, but forced his way to the very foot of the Alps, where he was killed, it is said, by a flash of lightning, leaving the throne of Ireland to be filled by a line of Christian kings. His body was carried home by his son Amhalgaidh, who took the command of the Irish forces after the death of his father, and by his four servants of trust, Dungal, Flanngus, Tuathal, and Tomaltach, who carried it to the royal cemetery at Cruachan, called **Reilig na Riogh**, where it was interred, and where, to this day, the spot is marked by a red pillar stone. — Vide supra, p. 24, note *97*.


After the death of King Dathi, Laoghaire, or Leary, the son of Niall of the Nine Hostages, became monarch of Ireland, and enjoyed that dignity, as the Book of Lecan states, for thirty years after the arrival of St. Patrick.


The monarch Dathi married three wives, but the Irish authorities differ much about their order; the fact therefore probably was that he had the three together; be this, however, as it may, the Book of Lecan states that he married Ruadh, or Rufina, the daughter of Airti Uichtleathan, by whom he had Oilioll Molt, monarch of Ireland, and Fiachra Ealgach, the ancestor of O'Dowd; he married, secondly, Fia, the daughter of Eochaidh, by whom he had Eochaidh Breac, the ancestor of O'Heyne and O'Shaughnessy; and, thirdly, Eithne, the daughter of Orach, or Conrach Cas, who, according to some authorities, was the mother of his son King Oilioll Molt. But as it would be now idle to speculate on which of Dathi's sons were youngest or eldest, the Editor will here follow the authority of the Book of Lecan, which states that Dathi had twenty-four sons, of whom, however, only twenty are given by name, and set down in the following order: — 1, Oilioll Molt: he succeeded as king of Connaught in the year 449, and after the death of the monarch Laoghaire, in 463, became monarch of all Ireland, and reigned twenty years. His two grandsons, Eoghan Bel and Oilioll Inbanna, became Kings of Connaught, but his race became extinct in his great grandsons; 2, Fiachra Ealgach, the ancestor of O'Dowd, and several other families; 3, Eochaidh Breac, i. e. Eochy the Freckled, the ancestor of O'Heyne, O'Shaughnessy, and many other families; 4, Eochaidh Meann; 5, Fiachra, who is said to have been detained as a hostage in the hands of King Niall of the Nine Hostages, and who is said to have left a family called Hy-Fiachrach, at a place called Cuil Fabhair, in Meath; 6, Earc; 7, Corc; 8, Onbecc; 9, Beccon; 10, Mac Uais; 11, Aengus the Longhanded; 12, Cathal; 13, Faelchu, from whom are descended the tribe of Hy-Faelchon; 14, Dunghal; 15, Conrach; 16, Neara; 17, Amhalgaidh, the



---

p.347



son of Rufina, the daughter of Airtigh Uichtleathan, who was born on Inis Awley, in Lough Conn (Lib. Lec. fol. 247), from whom descended the tribe called Cinel Becon, in Meath, and the Mac Firbises of Lecan; 18, Blachadh; 19, Cugamhna, from whom descended the family called Mac Congamhna, who were located in Cinel Fechin, in the south of the now county of Galway: and, 20, Aedh, the ancestor of the Hy-Aedha, who were seated in Burren, in Thomond.


If the sons of Dathi be here set down according to their ages it will follow that Fiachra Ealgach was his second son, and that upon the failure of issue in the line of Oilioll Molt, the representative of Dathi is to be sought for in the line of Fiachra Ealgach. O'Flaherty, however, though he had the Book of Lecan before him, says that Eochaidh Breac, the ancestor of the Hy-Fiachrach Aidhne, was the eldest son of Dathi, that Oilioll Molt, monarch of Ireland, was the second, and Fiachra Ealgach, the ancestor of the Hy-Fiachrach of the Moy, the third son. But, as already observed, it would be now idle to conjecture which is right, and the Editor has followed the Book of Lecan, which, as being the local authority, is more likely to be correct in the genealogy of this race than any other manuscript.


4. *Fiachra Ealgach, son of Dathi.* — The Irish annals have preserved no memorial of this Fiachra, as the descendants of the monarch Oilioll Molt, the eldest son of Dathi, were dominant in Connaught in his reign, but the Lecan genealogical books inform us that he was detained as a hostage in the hands of the monarch Niall of the Nine Hostages, — which however is scarcely credible, — and that the territory of Tir Fiachrach Muaidhe, now the barony of Tireragh, on the east side of the river Moy, took its name from him. He had, according to these records, two sons, namely, 1, Amhalgaidh, or Awley, from whom descended several families formerly seated in the barony of Tirawley, among whom, according to some authorities, are to be reckoned the family of Mac Firbis, but this is very uncertain, as is every thing connected with the early history of that family. By this Amhalgaidh was erected the celebrated Carn Amhalgaidh, on which the chiefs of the northern Hy-Fiachrach were afterwards for ages inaugurated, concerning which see more in the article on the inauguration of the O'Dowds. Fiachra had, 2, Maoldubh, or Maolduin, the ancestor of the subsequent chiefs.


5. *Maoldubh, or Maolduin, son of Fiachra Ealgach.* — No memorial of this personage is preserved in the authentic Irish annals, nor in the genealogical books of the Mac Firbises, except that he is said to have given name to a fort called Dun Maolduibh, near the River Easkey, where he was born and fostered.


6. *Tiobraide.* — He was chief of Hy-Fiachrach in the time of St. Columbkille, to whom he granted a tract of land around the hill of Cnoc na Maili, now the Red Hill



---

p.348



of Skreen, and on which the church of Skreen was afterwards erected by St Adamnan. He was the father of 
  

7. *Donnchadh Muirsce,* i. e. Donogh of Muirisc, a district in the territory of Tir Fiachrach of the Moy. He was King of Connaught for four years, and was slain, according to the Four Masters, in the battle of Corann, in the year 681. ‘A. D. 681. Donnchadh Muirsce *[son of Tiobraide]*, son of Maoldubh, King of Connaught, was slain in the battle of Corann, in which were also slain Colga, the son of Blathmac, and Fergus, the son of Maolduin, chief of the Cinel Cairbre.’
  

In this entry the Four Masters state that Donnchadh Muirsce was the son of Maoldubh, but we know from the most ancient and authentic lists of the Kings of Connaught, that he was the grandson of Maolduin, and the son of Tiobraide. He had two sons, Innreachtach, King of Connaught for two years, who had a son Oilioll, King of Connaught for eight years, who had a son Cathal mac Oiliolla, who became chief of Hy-Fiachrach, and died in the year 812, but of whose race no further account is preserved. The second son of Donnchadh Muirsce was Oilioll, the ancestor of O'Dowd, through whom the line of chiefs was continued.


8. *Oilioll son of Donnchadh Muirsce.* — No memorial of him is preserved in any of our records except the mere statement that he was the son of Donnchadh Muirsce, King of Connaught, and the brother of Innreachtach, King of Connaught, who was slain in the year 718.


9. *Cathal, son of Oilioll.* — No account of him is found in history, except that he is mentioned as the grandson of a King of Connaught, and the father of another, namely, of
  

10. *Donncatha Mac Cathail.* — In the authentic lists of the Kings of Connaught this Donncatha, who is called son of Cathal, son of Oilioll, son of Donnchadh Muirsce, is said to have governed Connaught for eighteen years; and his death is entered in the Annals of the Four Masters, at the year 768.


11. *Connmhach.* — In the time of this Connmhach the government of the kingdom of Connaught was transferred to the race of Guaire Aidhne, who resided in the south of the province, and soon after wholly to the Hy-Briuin, of whom the O'Conors of Connaught were the principal family; so that Connmhach did not figure among the conspicuous characters of his age, and the Irish annalists have therefore preserved no notice of him. The genealogical books of the Mac Firbises, however, inform us that he was the ancestor of all the succeeding chiefs of the Northern Hy-Fiachrach race, whose country, before the Anglo-Norman invasion, extended from the River Robe to the River Cowney, at Drumcliff, and from the coasts of Erris, eastwards, to the boundary of O'Rourke's country. He had two sons, Caomhan, the ancestor of the 



---

p.349



O'Caomhan family, who sunk into obscurity in the fifteenth century, and Dubhda, or Dowda, the ancestor of the O'Dowd, or O'Dowda family.


The genealogical books of the Mac Firbises contain some amusing stories, purporting to give a reason why the race of Caomhan, the eldest son of Connmhach, was set aside and the race of Dubhda put in their place as chiefs of the Northern Hy-Fiachrach, but as these have been already given from the text of **Duald Mac Firbis**, it is only necessary to remark here that whatever truth there may be in the seniority of Caomhan, his race was considered in later times the senior branch of the descendants of the monarch Dathi, and therefore their chief enjoyed many privileges which no other family of the race were entitled to; such as to take the first place at the banquet, to be the chief man at the inauguration of the O'Dowd, and to give out their first arms, or military weapons, to the youth of Hy-Fiachrach. How they first lost the chieftainship of the Hy-Fiachrach it would be now useless to inquire, but it may be remarked that they are not the only senior branch of a great race in Ireland who have been laid aside by more powerful junior rivals, and we cannot now admit any reason for O'Dowd's superiority to them than that his tribe became more numerous and more warlike, and compelled them to surrender all claims to the chieftainship of the Northern Hy-Fiachrach by force of arms.


12. *Dubhda,* the second son of Connmhach. He is the ancestor after whom the family of O'Dubhda, anglice O'Dowda, or O'Dowd, have taken their surname. The name Dubhda signifies a black complexioned or black-haired man, and the prefix O' denotes grandson, and, in a wider sense, a descendant in any degree, and is translated nepos by Adamnan in his Life of St. Columbkille; so that O'Dubhda signifies nepos Doudai, or descendant of Dubhda, or Dowda, and the O' should be prefixed, not only to the name of the chieftain of the race, but also to that of each individual of the family, as well in all the collateral branches as in the direct line. The exact period at which this Dubhda, or Dowda lived, cannot now be satisfactorily ascertained, as the Irish annals preserve no memorial of him, but we have two periods fixed by the authentic annalists, between which he must have flourished, namely, that of his grandfather Donncatha, King of Connaught, who died in 768, and that of his own grandson Aodh, King of North Connaught, who died in the year 983, and by striking a mean between these two dates we shall have the year 876, which may therefore be considered the year about which this Dowda died. The genealogical books of the Mac Firbises do not give us the name of his wife, and the sum of what they have handed down respecting him is, that he had one son, namely,
  

13. *Ceallach Mac Dubhda*, of whom nothing is recorded, except that he was the father of



---

p.350



14. *Aodh,* or *Hugh* O'Dubhda, or O'Dowda, King of Lower Connaught, who died in the year 983, according to the Annals of Lecan, as quoted by **Duald Mac Firbis**. This Aodh, or Hugh, was the first who could have added the prefix O' to his surname, as being the O', nepos, or grandson of Dubhda, for his father would have been called Mac Dubhda. He seems also to have been the first who obtained sway over the descendants
of Caomhan, his grandfather's eldest brother; for the Lecan records inform us that he granted to Aodh, or Hugh, the grandson of Caomhan, the district extending from Tuaim Da Bhodhar to Gleoir, and also the tract of land in Carra, called Tuath Ruisen, which till then had been in the possession of a sept of the Firbolgs, besides other tracts in the principality of Hy-Fiachrach, in consideration of Aodh, the grandson of Caomhan, having resigned to him and his race all claims to the chieftainship of the Hy-Fiachrach. The genealogical books of the Mac Firbises give him but one son, Maolruanaidh, the ancestor of all the branches of the O'Dowd family; but we learn from the Annals of the Four Masters that he had another son, Gebhennach, who died in 1005.


15. *Maolruanaidh, or Mulrony, son of Aodh, or Hugh O'Dubhda.* — According to **Duald Mac Firbis** this Mulrony, who was chief of Hy-Fiachrach Muirisce, died in the year 1005, and the Four Masters have the following notice of his death under the same year: — ‘A. D. 1005. Maolruanaidh, son of Aodh O'Dubhda, lord of Hy-Fiachrach Muirisce, and his son Maolseachlainn, and his brother Gebhennach Mac Aodha, died.’


This Maolruanaidh, or Mulrony, had, according to the Mac Firbises, two sons, namely, 1, Maoileachlainn, or Maolseachlainn, the ancestor of the greater number of the succeeding chieftains, and, 2, Domhnall, or Donnell, the ancestor of a celebrated sept of the O'Dowds, called the Clann Domhnaill, or Clandonnell of Lough Conn, of whom were many distinguished warriors, chiefs of Tirawley, and among others Cosnamhach Mor, anglice Cosney More, who, according to the Mac Firbises, was the last of the Irish race who was called the fighter of an hundred men, but who was killed in his own house at Inishcoe, on Lough Conn, by O'Gloinin, one of his own sub-chieftains, in 1162.


16. *Maoilseachlainn,* i. e. *Melaghlin, or Malachy O'Dubhda.* — He died in 1005, the same year in which his father and uncle also died. The Mac Firbises mention but one of his sons, namely, Niall


17. *Niall, son of Maoilseachlainn O'Dubhda.* — He had three sons; 1, Niall, ancestor of the Clann Neill O'Dowd, who made strong efforts to wrest their little territory from the family of O'Caomhain, but without success; 2, Taithleach, the ancestor of nearly all the subsequent chiefs, and 3, Aodh, the ancestor of several septs, but whose pedigrees are not carried down.


18. *Taithleach, son of Niall O'Dubhda.* — He had two sons, namely, 1, Ruaidhri Mear,



---

p.351



or Rory the Swift O'Dubhda, who was lord of the country extending from the river Robe to Drumcliff, and who was murdered by Domhnall, or Donnell O'Quin, chief of Clan Cuain, whose daughter he had violated, and who renounced his allegiance to O'Dowd, and placed himself under the protection of Mac Dermot, chief of Moylurg. This must have occurred early in the twelfth century. He had, 2, Aodh, or Hugh O'Dowd, the ancestor of the subsequent chiefs.


19. *Aodh, or Hugh, son of Taithleach O'Dubhda,* father of
  

20. *Muircheartach O'Dubhda,* who was the father of
  

21. *Aodh, or Hugh O'Dubhda.* — He had three sons; 1, Taithleach, ancestor of the subsequent chiefs; 2, Brian Dearg, from whom the Clann Taithligh Oig [Clantahilly Og] O'Dowd are descended; and, 3, Muircheartach. He was probably the Aodh, son of Muircheartach O'Dubdha, lord of Tireragh and Tirawley, who died in 1143.


22. *Taithleach, or Tahilly, son of Aodh, or Hugh O'Dubhda.* — He seems to be the Taithleach O'Dubdha, lord of Tirawley and Tireragh, who was killed by his own two wicked grandsons in the year 1192. He had one son.


23. *Aodh, or Hugh, son of Taithleach,* who was father of the celebrated
  

24. *Donnchadh Mor, or Donogh More O'Dubhda.* — He appears first in the Irish annals at the year 1207, under which he is called by the Four Masters lord of Tirawley and Tireragh. In this year he joined Diarmaid, son of Maghnus O'Conor, Cormac Mac Dermot, and O'Hara, lord of Leyny, to oppose Cathal Carrach O'Conor, who had invaded and plundered Mac Dermott's country. A battle ensued between them, in which Cathal Carrach was defeated, taken prisoner, and deprived of his eyes, in order that by being maimed, he might have no further pretensions to chieftainship.


In the year 1213 he hired a fleet of fifty-six ships at the Hebrides, which he joined with his own, and sailed into the bay of Cuan Modh, now Clew Bay, where he landed on Inis Raithin, and compelled Cathal Croibhdhearg, or Charles the Redhanded O'Conor, King of Connaught, to give up to him his territory, extending from the river Robe to Drumcliff, free of tribute.


Having now carried the pedigree of this family down to a period at which their history becomes very certain, and pregnant with facts, the Editor will next glance back at the line of descent, to show that the genealogical books of the Mac Firbises have not preserved to us all the branches that sprang from the main trunk of the genealogical tree of this great race. This will be sufficiently obvious from the following passages in the Annals of the Four Masters:


‘A. D. 899. Joseph of Loch Con, abbot of Clonmacnoise, died. He was of the sept of the northern Hy-Fiachrach.’




---

p.352


‘A. D. 905. Aodh, son of Maolpatraig, lord of Hy-Fiachrach, was slain by Niall, son of Aodh.’


‘A. D. 1059. Aedhuar O'Dubhda, lord of Hy-Amhalgaidh, was slain by his own tribe.’


‘A. D. 1096. Muircheartach O'Dubhda, surnamed an Cullach, i. e. *the Boar,* lord of Hy-Amhalgaidh, was slain by his own tribe.’


‘A. D. 1126. Domhnall Fionn O'Dubhda, lord of Hy-Amhalgaidh, was drowned after having taken a prey in Tirconnell.’


‘A. D. 1128. The son of Aodh O'Dubhda, lord of Hy-Amhalgaidh, was slain at Ardee in a battle fought between the cavalries of Conchobhar, the son of Mac Loughlin, prince of Aileach, and of Tiernan O'Rourke, chief of Breifny.’


‘A. D. 1132. Conchobhar, son of Maoileachlainn O'Dubhda, was slain by his kinsman, i. e. by the son of Niall O'Dubhda.’


‘A. D. 1135. O'Maille was slain by the son of Domhnall O'Dubhda, in the Domhliag, or stone-church of Nuachongbhail.’ — Chron. Scot.


‘A. D. 1135. Amhlaoibh, son of Domhnall Fionn O'Dubhda, lord of Hy-Amhalgaidh, was slain by the northern Hy-Fiachrach.’


‘A. D. 1136. The son of Domhnall O'Dubhda, lord of Hy-Amhalgaidh, was slain.’


In 1139 Mathghamhain, or Mahon O'Dubhda, chief of the race of Flaithbheartach, is mentioned, but he was of the O'Dubhdas or Duddies of Ulster. See p. 112, note q *recte p. 111, note g, corresponding to 278 in the CELT edition*.


‘A. D. 1143. Aodh, son of Muircheartach O'Dubhda, lord of the northern Hy-Fiachrach and Hy-Amhalgaidh, died.’ This Aodh may have been Aodh, No. 21, in the above pedigree, but this is far from certain, as the number of generations from him to Maoileachlainn, No. 16, who died in 1005, would be too many.


‘A D. 1153. Brian O'Dubhda, lord of the northern Hy-Fiachrach, was slain in the battle of Craebh tinne.’


‘A. D. 1154. A fleet was sent out by King Toirdhealbhach, or Turlogh O'Conor, to coast Ireland towards the north, consisting of the fleets of Dun Gaillmhe *[Galway fort]*, Connmhaicne mara *[now Connamara]*, Hy-Amhalgaidh, and Hy-Fiachrach, over all which Cosnamhach O'Dubhda was placed as chief commander. These plundered Tirconnell and Inishowen. The Cinel Eoghain, with their chief Muircheartach, son of Niall, observing their designs, went over the sea to hire the fleets of the Gall-Gadelians of Arann, Cantire, the Isle of Mann, and of other parts of Scotland, over all which Mac Scellig was chosen as commander. When they came near Inishowen the Connacian fleet met them, and a fierce and obstinate sea fight ensued between them which continued from morning till evening, during which many of the Connacians were slain by the strangers, and among the rest their chief commander Cosnamhach O'Dubhda.



---

p.353



The strangers were however defeated and slaughtered, and deprived of their ships, and Mac Scellig, their leader, lost his teeth.’


‘A. D. 1162. Cosnamhach O'Dubhda, lord of Tirawley, was slain by his own tribe.’ This was the celebrated Cosnamhach (son of Aodh, son of Cathbharr, son of Domhnall, son of Maolruanaidh), who was killed by O'Gloinin at Inishcoe. He had a son Cosnamhach, who was slain in 1181.


‘A. D. 1182. Murchadh, the son of Taithleach O'Dubhda, was slain by Maolseachlainn O'Mulrony.’


By a comparison of these entries in the Annals with the line of the pedigree of the O'Dowds as preserved by the Mac Firbises, and as fully displayed in the large Genealogical Table, it will be seen that there were several distinguished members of the family whose names have not been entered in the pedigree. The truth evidently is, that the Mac Firbises have preserved no more than the direct line of this pedigree, from the progenitor Dubhda, or Dowda, down to Donnchadh Mor, No. 24, excepting the names of a few of the senior or junior branches, such as they knew had become the founders of distinct septs. To return to the pedigree, Donnchadh Mor, No. 24, supra, had four sons, namely, Brian Dearg O'Dubhda, lord of Tireragh, Tirawley, and Erris, who, according to the Annals of the Four Masters, was killed on the road while on his pilgrimage to the abbey of Boyle; 2, Maolruanaidh, the ancestor of the subsequent chiefs; 3, Muircheartach, or Murtogh, ancestor of the Clann Conchobhair, who, on the death of his brother, Brian Dearg, in 1242, became chief of Hy-Fiachrach, and was, during his short career, a powerful chieftain, and at constant strife with the O'Conors. In the year 1246 he slew Maelseachlainn, the son of Conchobhar Ruadh, who was son of Muircheartach Muimhneach, or Murtogh, the Momonian O'Conor, for which he was banished over sea; but in the year following, 1247, he returned, accompanied by his friend O'Boyle, with a fleet, and made a descent upon the coast of Carbury, to be revenged on the O'Conors by plundering that territory, but on this occasion the crew of one of his ships, who were under the command of Maghnus O'Boyle, were drowned at the island of Inis Tuathrass, on the coast of Carbury. But his career of glory was short; he was slain in the year 1248 by the son of Felim O'Conor, as thus recorded in the Annals of the Four Masters: — ‘A. D. 1248. Muircheartach O'Dubhda, surnamed the Aithchleireach, lord of that tract of country extending from Cill Dairbhile *[now Termon Dervilla]*, in Erris, to the Strand *[i. e. the strand of Traigh Eothuile]*, was slain by the son of Felim O'Conor.’ The fourth son of Donnchadh Mor was Taithleach, who was the father of Conchobhar, or Conor Conallach O'Dubhda, who became chief of Tireragh and was drowned in the Shannon in the year 1291, but his race seems to have become extinct in a few generations. Donnchadh



---

p.354



Mor had a daughter Mor, who became the wife of O'Boyle, the chief of the opposite coast, and who died in the year 1249.


One of the sons of this Donnchadh Mor O'Dubhda is charged with a very atrocious crime by the Irish annalists, who fortunately do not afford us the clue to discover which of the sons to brand with it. The Four Masters speak of it as follows in their Annals: — ‘A. D. 1244. Maoliosa Mac an Easpuig O'Maoilfoghmhair *[Malisa Macanespie O'Mulfover]*, parson of Tireragh and Tirawley, who, from his wisdom, was intended for the episcopal dignity, was killed by the son of Donnchadh O'Dubhda, a deed strange to his family, for none of the O'Dubhdas had ever before that time killed an ecclesiastic.’


25. *Maolruanaidh, or Mulrony, son of Donnchadh Mor O'Dubhda.* — Though this Mulroney was the progenitor of the subsequent chiefs he does not appear to have ever been chief himself, for, in the record of his death given in the Annals of the Four Masters at the year 1238, he is styled Maolruanaidh, son of Donnchadh O'Dubhda: — ‘A.D. 1238. Maolruanaidh, the son of Donnchadh O'Dubhda, was slain by Maoilseachlainn, son of Conchobhar Ruadh, who was the son of Muircheartach Muimhneach O'Conor, assisted by the son of Tighearnan, who was the son of Cathal Mac Arnain O'Conor.’


According to a modern account of the descendants of this Mulrony O'Dubhda, inserted in a modern hand in the Book of Lecan, and which shall be given in these Addenda, he had three sons, viz., Taithleach, Muaidhe, Donnchadh Mor, ancestor of the Clann Donogh O'Dubhda, formerly seated in the district of Coolcarney, and Cosnamhach, *archbishop* of Tuam; but that this genealogy is spurious is obvious from the fact that it totally differs from the original text of the Book of Lecan, as well as from the account given by **Duald Mac Firbis**; and that it appears from the Irish annals that Donnchadh Mor O'Dubhda, the ancestor of the Clann Donogh, could not have been the son of Mulrony who was slain in 1238, for Donnchadh died Tanist of Hy-Fiachrach in the year 1337, that is, ninety-nine years after the death of his supposed father. But the truth clearly is, that Donnchadh Mor was, as the original text of the Book of Lecan makes him, the grandson of Maolruanaidh, or Mulroney, and the son, not the brother, of Taithleach Muaidhe, who was slain in 1282. According to the
 Book of Lecan and **Duald Mac Firbis** this Maolruanaidh, or Mulroney, had two sons, namely, Taithleach Muaidhe, or Tahilly of the Moy, of whom presently, and Cosnamhach, archdeacon [not archbishop] of Tuam, and a daughter Dervorgilla, who was the mother of Tomalltach O'Conor, archbishop of Tuam, and died in 1265.


26. *Taithleach Muaidhe, or Tahilly of the Moy, son of Mulrony O'Dubhda.* — This
warlike chieftain, in order to be revenged of William Mor Barrett, who had wrested



---

p.355



from him the entire of the territory of Tirawley, joined Adam Cusack, — who was then making strong efforts to conquer this part of Connaught, — against the Barretts, and a fierce battle was fought between them at Moyne, near Killala (where a great monastery was a long time after erected). In this battle, wherein O'Dubhda was assisted by bis neighbour O'Boyle, William Mor Barrett was defeated, mortally wounded, and taken prisoner. But Adam Cusack, notwithstanding the assistance received from O'Dubhda in this battle, turned his arms against him the year following, and slew him at a place called, from that circumstance, **Bel Atha Tailtigh**, i. e. the mouth of Tahilly's ford, situated near the margin of Traigh Eothuile, on the lands of Coillte Luighne, near Ballysadare. These facts are stated by the Four Masters in their Annals, and are also given in the Annals of Clonmacnoise, as we learn from the following quaint translation of the two passages by **Connell Mageoghegan**:
  

‘A. D. 1281. There was a feild fought between the Barretts of the one side and the Cusackes of the other side, where the Barretts were vanquished; William Barrett and Adam Fflemyng, with many others, were slain. There were two Irishmen of Cusack's side that surpassed the companys of both sides for prowes, manhood, dexteritie of handling of arms, hardiness, and all other parts of activity, named Taihleagh O'Dowdie and Taihleagh O'Boyle.’


‘A. D. 1282. Taihleagh mac Moyleronie O'Dowdie (before spoken of), prince of the contrey of Offiaghrach Moye, one of great prowes and bounty, and of great and continuall dissention with the English, and all foreigners, in defence of his contry, was killed by Adam Cusack at Beerhaven.’


Here **Mageoghegan** renders Traigh Eothuile by Beerhaven, an error equalled only by that of **Haliday**, who, in his translation of the first part of **Keating**'s History of Ireland, renders it Youghal, and evidently takes it to be the strand of Youghal, in the south-east of the county of Cork.


This Adam Cusack was defeated by Maghnus O'Conor at Ballysadare in the year 1285, on which occasion Collin Cusack, his brother, and many others, were slain. He died in the year 1287, after which we hear of no more triumphs of the Cusacks in Connaught, and the Barretts appear to have recovered all their possessions in Tirawley, of which he seems for a time to have deprived them.


Taithleach Muaidhe O'Dubhda had three sons, viz., Sen Bhrian, of whom presently, Donnchadh Mor, ancestor of the Clann Donogh O'Dubhda, who died in 1337, and Maoileachlainn Carrach, who was slain in 1316. There were many distinguished men among this sept of the family, as William, Bishop of Killala, who died in 1350; Muircheartach Cleireach, chief of the Clann Donogh, who died in 1402, but they disappear from history about the middle of the fifteenth century.




---

p.356


27. *Sen Bhrian, or old Brian, the son of Taithleach Muaidhe O'Dubhda.* — **Duald Mac Firbis** states in his short annals of this family, that this Brian was eighty-four years chief of his name; but we must conclude from the authentic Irish annals that he could not have reigned so long, and we may well believe that fifty-four years, as given in a more modern hand in the Book of Lecan, was the true period. The first notice of this chieftain to be found in the Annals of the Four Masters is at the year 1278, in which he and Art na g-Capall [of the horses] O'Hara, lord of Leyny, gave battle to the Berminghams, and defeated them, killing the two sons of Meyler Mor, Conor Roe Bermingham and others. This was in the life-time of his father, and still he does not appear to have succeeded his father, for the Annals record the death, by drowning, of Conchobhar, or Conor Conallach O'Dubhda, lord of Tir Fiachrach, in the year 1291. In the year 1308, as we learn from the Annals of Clonmacnoise, he joined the English of Leyny and Tireragh to plunder the O'Conors of Carbury. But in 1316 he joined Felim O'Conor and the Irish in the memorable battle of Athenry, where the English had mustered the best appointed and most formidable army that they had ever before sent against the native Irish. In this battle, in which the English were well armed, and drawn up in regular military array, and the Irish without armour[1016](javascript:footNote('T105008/note1016.html')), eleven thousand of the Irish were slain, and tradition says that the O'Conors were so completely defeated that throughout all Connaught not one man of the name, Felim's brother excepted, could be found who was able to bear arms.


According to the Annals of the Four Masters Brian O'Dubhda, lord of Tireragh, commanded his people in this battle, and lost therein his brother Maoileachlainn Carrach and two of the principal men of his name. The following account of this battle is given in the Annals of Clonmacnoise as translated, in the year 1627, by **Connell Mageoghegan**:
  

‘A. D. 1316. Felym O'Connor [after having slain Rory O'Connor, who had usurped the throne of Connaught] took all the preys and spoyles of all that belonged to Rowry O'Connor, or that partaked with him before, and took himself the government and name of King of Connought, as before he had, which extends from Easroe, in Ulster, to Eaghtge; took hostages, for the preservation of allegeance, of the Breniemen, and constituted Ualargge O'Roirke as their king; alsoe he took the hostages of the



---

p.357



O'Kellys, O'Maddens, O'Dermodaes, O'Haras, O'Dowdies; and after setting himself [up] he prepared an army with whom he went to banish the English out of Connaught; immediately burnt the town of Athleathan, killed Stephen D'Exeter therein, Miles Cogan, William Prendergrass, and John Stanton, Knights, and also William Lawless, with a great slaughter of their people. He burnt all the contrey from the place called Castle Corran to Roba, took all their preys and spoyles; returned to his house with a ritch booty of his enemies, and a fortunate success in his affairs.’


‘King Felym having thus returned to his house made no long stay, but went to Milick to meet with those of Munster and Leathmoye, where he burnt and fell down the castle at first. Mortagh O'Bryen, prince of Thomond, came to his house, and all the families of the O'Briens face to face, with whom he returned to Roscomon to fall
the Castle thereof to the Earth.’


‘Felym O'Conor hearing of the returne of William Burke to Connought from Scotland, he proclaimed that all his people from all parts where they were, with such as wou'd joyn with them, wou'd gather together to banish William Burke from out of Connought, at whose command all the Irishrie of Connought from Easroe to Eghtge were obedient and came to that place of meeting. Donnogh O'Bryen, prince of Thomond, O'Melaughlyn, king of Meath, O'Royrck of the Breffine, O'Ferall, chieftain of the Analie, called the Convackne, Teig O'Kelly, king of Imaine, with many others of the nobilitie of Ireland, came to this assembly, and marched towards Athenrie to meet with William Burke, the Lord Bremyngham and others, the English of the province of Connought, where they met and gave battle in a place neer the said towne, the Irishmen in which battle were discomfitted and quite overthrowen.’


‘Felym O'Connor, King of Connaught, was therein killed, also Teig O'Kelly, King of Imaine, and eight and twenty of the chiefest of that family. Magnus mac Dermott O'Connor, Tanist of all Connaught, Art O'Hara, prince of Lwyne; Melaghlyn Carragh O'Dowdie; Connor Oge O'Dowdie; Mortagh mac Connor O'Dowdie; Dermott Mac Dermott, Tanist of Moylorge; Mortagh mac Taithleagh Mac Dermoda; Mortagh mac Dermoda O'Fferall; Mullronie Oge Mac Magnosa; John mac Morrogh O'Madden; Donnell O'Boylle; Donnogh O'Molloye of Fearkeal, with his people; the son of Murrogh Mac Mahon with a hundred of his people; Neal Ffox, prince of Teaffie-men, with his people; Ferrall mac John Gallda O'Ferall; William mac Hugh Oge O'Feralle; Thomas Mac Awley O'Fferall; Tomaltagh, Morragh, Connor, Mortagh, and Melaughlyn Mac Donnough; John Mackeigan, O'Connor's chief Judge; Connor and Gillernew, the sons of Dalredocker O'Dovelen, the man called Fear imchar na h-onchon *[i e. O'Connor's standard bearer]*, Thomas O'Connolan of the king's guard; all which persons, with many others of Munster, Meath, and Connaught (which were 



---

p.358



tedious to recite) were slain in that battle, as a certain Irish poet pitifully in an Irish verse said: ’

> 1. Mór mac rígh nach abraim ainm
>   
> Do marbhadh is an mór-mhaidhm,
>   
> Do shluagh Midhe is Mumhan,
>   
> Truagh lem chrídhi in cathughadh.[1017](javascript:footNote('T105008/note1017.html'))
> 




‘This battle was given *[fought]* upon the day of St. Lawrence the Martyre. Felym then being but of the age of twenty-three years, in the fifth year of whose reign Rowrye mac Cahall Roe O'Connor (before mentioned) deposed him for one half year, who being killed, as before is described, Felym succeeded for another half year, untill he was slain at Athenrie aforesaid.’


‘Rowry, surnamed Rowry na ffidh, mac Donnogh, mac Owen, mac Rowrie, succeeded next as King of Connaught.’


**Sir Richard Cox** states ( Hist. of Ireland, p. 97) that after this battle the Berminghams took a prey of two thousand cows from the O'Conors, and that eight thousand of the Irish were slain; and that the King of England, on receiving the news of this victory, granted to Sir Richard De Bermingham the title of Baron of Athenree, which his descendants have enjoyed ever since.


This Brian O'Dubhda died, according to the Irish annals, in the year 1354, when he must have been at least a century old, for he was in active service in the field as early as 1278. **Duald Mac Firbis** says that he recovered a great portion of the original territory, particularly Tireragh, from the English, and divided it among his own sons, grandsons, and great grandsons. He married Una, the daughter of Felim, who was the son of Cathal Croibhdhearg O'Conor, King of Connaught, and had by her eight sons, viz., Domhnall Cleireach, his successor, of whom presently; 2, Maolruanaidh, or Mulroney, who died in 1362; 3, Maghnus Cleireach, who died in 1359; 4, Diarmaid; 5, Aodh, the father of Brian Cam, and Edmond, chiefs of Tireragh; 6, Cosnamhach; 7, Niall; 8, Brian Og, who was slain by the Barretts in 1373.


28. *Domhnall Cleireach, or Donnell the Citric, son of Old Brian O'Dubhda.* — He succeeded his father in 1354, and died in 1380. In his time the English made strong efforts to get possession of his territory of Tireragh, which was all that remained with the O'Dowds at this period, though they still laid claim to Tirawley; but in the year 



---

p.359



1371 he drove the English out of his territory and took possession of the castles of Ardnarea and Castleconor, in which they had strengthened themselves, and then divided the lands among his brothers and followers. The Four Masters have the following notice of his death: — ‘A. D. 1380. Domhnall, the son of Brian O'Dubhda, lord of Tireragh and Tirawley, defender of his principality against his English and Irish enemies, died at his own mansion seat *[Dun Neill]* on the third of May, and his son Ruaidhri assumed his place.’


According to a list of the chiefs of the O'Dubhda family, inserted in a modern hand in the Book of Lecan, he was chief for forty-nine years and a half, but, according to **Duald Mac Firbis**, he reigned but thirty-six years, and if we date the commencement of his reign in 1354, when his father died, we cannot allow him a longer period than 
twenty-six years, but it is highly probable that his father had resigned the chieftainship to him several years before his death.


Domhnall Cleireach O'Dubhda married the daughter of O'Malley, chief of Umhall, and had by her ten sons, viz., 1, Ruaidhri, his successor, of whom presently; 2, Maghnus, who, in 1461, according to **Ware**, slew Connor O'Connell, Bishop of Killala; 3, Maoileachlainn; 4, Tadhg Riabhach, or Teige Reagh, who succeeded as chief of Tireragh in 1417, and died in 1432. It was in the time of this Teige Reagh that the abbey of Ardnarea, the ruins of which still remain in good preservation, was founded for monks of the order of St. Augustin, A. D. 1427. — See De Burgo Hibernia Dominicana and Archdall's Monasticon. It was in his time also the Book of Lecan was compiled by **Giolla Iosa Mor Mac Firbis**, who, in 1417, addressed to him the topographical poem, published in this volume: though it would appear from a memorandum at the bottom of folio 40, that the work had been commenced in the time of his brother Ruaidhri, who died in that year. This Teige Reagh was the ancestor of several chiefs of Tireragh, and of the famous family of the Dowds of Dublin, but the Editor being of opinion that this family is now extinct, deems it unnecessary to give their pedigree in this place, as it has been already given, though without dates, in the text of **Duald Mac Firbis**. But should the Dowds of Dublin be extant they will see the line of their descent, traced for thirty-four generations, in the large Genealogical Table hereunto prefixed. Domhnall Cleireach had, 5, John; 6, Domhnall Og; 7, Donnchadh; 8, Diarmaid, who died in 1439; 9, Aodh; and, 10, Eoghan, who was living in 1420.


29. *Ruaidhri, Rory, or Roger, son of Domhnall Cleireach O'Dubhda.* — 
He succeeded his father in the year 1380, and died in the year 1417, under which the Four Masters have the following notice of his death: ‘A. D. 1417. O'Dubhda (Ruaidhri, son of Domhnall, who was son of Brian, son of Taithleach), fountain of the prosperity and 



---

p.360



wealth of Tireragh, died at his own mansion seat *[Dun Neill]* after the festival of St. Bridget, and his brother Tadhg Riabhach assumed his place.’


This Ruaidhri married the daughter of Mac Costello, and had by her, 1, Maolruanaidh, his successor, of whom presently; 2, Conchobhar, or Conor; 3, Maghnus Cleireach; 4, Muircheartach; 5, Eoghan Caoch; 6, William, who died in 1438.


30. *Maolruanaidh, or Mulrony, son of Ruaidhri O'Dubhda.*— He was elected chief of his name in 1432, according to **Duald Mac Firbis**, and died at Liathmhuine, now Leafony, in 1447. He married the daughter of Mac Wattin Barrett, and had, 1, Diarmaid; 2, Domhnall Ballach, who was chief of the name for one year, and who was the father of William, chief of his name, who died in 1496; 3, Maoileachlainn; 4, Muircheartach Caoch.


31. *Diarmaid, son of Maolruanaidh O'Dubhda.*— He never attained to the chieftainship, though he was the senior of the race, and the ancestor of almost all the subsequent heads of the family. The name of his wife is not given, but it is stated that he had two sons, namely, 1, Conchobhar, or Conor O'Dubhda, of whom presently; 2, Brian.


32. *Conchobhar, or Conor, son of Diarmaid O'Dubhda.*— He succeeded Felim, the son of Tadhg Buidhe, or Teige Boy O'Dubhda, in the year 1508, and died in the abbey of Moyne about the year 1538, after having been thirty years chief of his name. In the year 1527 he took Mac Donogh prisoner. In 1532 his sons took the castle of Ardnarea from the sons of John Burke, in consequence of which great dissensions arose between them and the descendants of Richard Burke, and many depredations and slaughters were committed on both sides, and in the next year the Burkes got possession of Ardnarea, since which the O'Dubhdas, or O'Dowds, never recovered it. He married Margaret, daughter of Thomas Roe Burke, and had by her, 1, Eoghan, his successor, of whom presently; 2, Fearadhach; 3, Ruaidhri; 4, Cormac, a friar; 5, Cathal Dubh, who became chief of his name, and consented to pay tribute to the Lower Mac William Burke; 6, Dathi; 7, John Glas; and, 8, Brian. 


33. *Eoghan, or Owen, son of Conchobhar O'Dubhda.*— He succeeded his father about the year 1538, and was chief of his name for seven years. He married Sabia (the daughter of Walter, son of Richard) Burke, who was taken prisoner by O'Donnell in 1536. He was himself taken prisoner by Mac William of Clanrickard in 1542, as we are informed by the Four Masters, but we know no more of his history, except that he and his wife were interred in the same tomb in the abbey of Moyne. He had four sons, viz., 1, Tadhg Riabhach, or Teige Reagh, his successor; 2, Edmond; 3, Ceallach; and, 4, Conchobhar, or Conor.


34. *Tadhg, or Teige Reagh, son of Eoghan O'Dubhda.*— He seems to have succeeded his father about the year 1545, and we learn from the Four Masters that he died in 



---

p.361



the year 1580. ‘A.D. 1580. Tadhg Riabhach, son of Eoghan, son of Conchobhar O'Dowd, died.’ The name of his wife is not given by Mac Firbis, who informs us that he had seven sons: 1, Dathi, of whom presently; 2, Tadhg Buidhe, or Teige Boy, who was made O'Dubhda by O'Donnell in 1595; 3, Fearadhach; 4, Domhnall, or Donnell, the father of Teige Reagh, mentioned in the settlement of 1656, to be presently given; 5, Maolruanaidh; 6, Eoghan; 7, John Og.


35. *Dathi or David, son of Tadhg Riabhach O'Dubhda.*— He was slain in the year 1594, under which he is styled chief of his name by the Four Masters. ‘A. D. 1544. O'Dubhda of Tireragh (Dathi, son of Tadhg Riabhach, son of Eoghan) was slain by one of the queen's soldiers in one of his own castles in Tireragh of the Moy.’


He married Miss Ellenor Lyens, afterwards Lady Ellenor Ghest, by whom he had two sons, viz., Dathi, or David O'Dubhda, his heir, and William O'Dubhda. This appears from an inquisition taken at Sligo on the third of April, 1623, preserved in the Rolls Office, Dublin, which finds ‘that David O'Dowde, late of Castleconnor, Esq., deceased, was seised of that castle and several other lands; that he died, leaving David O'Dowde, junior, his son and heir; that Ellenor Lyens, *alias* Dowde (now Lady Ellenor Ghest), was the lawful wife of the said David O'Dowde, senior, and that she is dowable of the one-third of all his lands; that after the death of the said David O'Dowde she married three several husbands, viz., Sir Lionell Ghest, Knight, who died; then William May, Esq., who also died; and after his death, and in the reign of our present sovereign Lord *[Charles I.]* she married Gerald Fitz-Morrice Fitzgerald, who is now *[1633]* living.’


36. *Dathi, or David, junior, son of David, O'Dubhda.*— On the third Patent Roll of the first year of the reign of King James I., there is enrolled ‘A Grant to Lionel Geste, or Ghest, of the wardship of David O'Dowde, son and heir of David O'Dowde, late of Killinglass, in the county of Sligo, Gent., deceased, for the fine of ten pounds Irish, and an annual rent of seven pounds, retaining five pounds thereof for his (the ward's) maintenance and education in the English religion and habits, and in Trinity College, Dublin, from the twelfth to the eighteenth year of his age.— Dated 1st Nov., 1603.’


It appears that when this David, junior, came of age, in 1612, he entered upon and took possession of his father's lands without suing out livery of seisin from His Majesty, which the law then required to make his title good; upon which William Chapman of Rossleagh made a discovery of same unto His Majesty, upon which His Majesty, in consideration of such service, as was then the custom, by his letters patent under the great seal of England, dated the first day of December, in the eleventh year of his reign, granted unto the said William Chapman ‘the benefitt and profitt of three



---

p.362



fourth partes of all Intrusions, fynes for alienations, mesne profitts, and other emoluments and profitts whatsoever due unto His Majestie by reason of any warship and primer seisin, ousterlermayne, or any cause whatsoever uppon any mannors, castles, lands, and tenements of David O'Dowde of Killglasse, in the coontee of Sligo, Gent, by reason of the death of his ffather, or any other of his ancestors, or of any lands that is found by office that David O'Dowde, father unto the said David, died seised of.’


The original letters patent to William Chapman, Esq., are now in very good preservation, and in the possession of the O'Dowda of Bunnyconnellan. On the third day of December, 1613, this William Chapman sold his right to these fines to William May, of Castleconnor, Esq., who was young David O'Dowda's step-father, being, as appears from the inquisition already quoted, the third husband of his mother, Lady Ellenor Ghest.


From an original deed in the possession of the present O'Dowda, it appears that this David O'Dowda, of Castleconnor, Esq., was married to Joan Burke, by whom be had,


37. *James O'Dowda.*— He married on the 23rd *[effaced]* 1632, Evelyn Burke, daughter of Walter Burke, of Turlough, Esq., as appears by his marriage settlement, now in very bad preservation, in the possession of the present O'Dowda. This James died many years before his father. He was living in 1639, as appears by a deed in the possession of the present O'Dowda, dated 10th April, 1639, in which he is called James Dowde, of Castleconnor, Gentleman; but he was dead in 1641, as appears by another deed, dated last day of October, 1641, whereby his father, David O'Dowda, of Castleconnor, Esq., enfeoffs unto Fearil O'Garae of Moyh *[Moy O'Gara, in Coolavin]* and Walter Burke of Ardagh, in the county of Mayo, Gentleman, of the castle of Castleconnor, and three quarters of land thereunto adjoining, viz., the quarter of Slievnamesgiry, the quarter of Cloonalangy, and the quarter of Ballinaleynagh, in the barony of Tireragh, to the use of said David and Jewane Burke, his wife, during their lives, and after the death of the said David, the heirs or assigns of James O'Dowda (son and heir of the said David,) shall pass an assurance unto the said Jewane of lands to the clear yearly value of forty pounds of good, fine, pure silver, every year during her life.


By this Evelyn Burke, James O'Dowda had one son, namely,
  

38. *Dathi Og, or David, junior, O'Dowda.*— He is the last generation given by **Duald Mac Firbis**, who states in his smaller genealogical compilation that he was living in the year 1666, and we shall see presently that they were acquaintances. He married in 1656 Dorothy, daughter of Teige Reagh O'Dowda (son of Donnell, son of Teige Reagh, No. 34, supra), by whom he got a considerable fortune, though he had lost all his estate during the civil wars. His marriage articles, which are signed by the Irish



---

p.363



antiquary **Duald Mac Firbis**, are dated the 17th of April, 1656, and as they throw a curious light upon the history of the times, they are given here word for word.

> 
> ‘Indented Articles of Agreement concluded, covenanted, and agreed upon this seventeenth Day of April, Anno Domini One Thousand Six Hundred Fifty and Six, by and between David Dowda the younger, of Castleconnor, in the County of Sligo, Gentleman, of the one part, and Teig Reagh O'Dowd of Castletown, of the said County, Gentleman, of the other parte, for and concerning a Marriage to be had and solemnized between the said David and Dorothy Dowda, Daughter to the said Teig.’
> 
> 
> ‘First, it is agreed, covenanted, and graunted by and between the said parties that the said David shall, at or before the last day of May next ensuing the date hereof, wedd, marry, and take to wife the said Dorothy, according to the rites, laws, and customs of the Holy Catholic Church, and that the said Dorothy shall accordingly wedd, marry, and take to husband the said David.’
> 
> 
> ‘Item, it is covenanted and agreed upon by and between the said parties that the said Teige shall, in consideration of the said marriage, give and satisfie unto the said David, as marriage portion to and with the said Dorothy, the number of cows, sheep, cattle following, viz., fourty great cows, to be milch cows next summer, fifteen heifers of two years old, fifteen yearling heflfers, one hundred sheep, one horse, and one plough. Item, it is covenanted and agreed upon by and between the said parties, and the said David for himself, his heirs and assigns, to and with the said Teig, his executors and assigns, in consideration of the said marriage and marriage portion, doth covenant, grant, and agree to be and stand seised and possessed of and in one moyety of such proportion of lands and tenements as he the said David shall recover, and that shall be recovered, in the right, title, and interest of David O'Dowda, grandfather of the said David the younger, to the use and behoof of the said David the younger, and of the said Dorothy and the longer liver of them, for and during their or either of their natural lives, and after their decease to the use of the heirs males to be begotten on the body of the said Dorothy by the said David the younger; and for the securing, making, and confirming of the premises, according to the true meaning, purport, and intent of these presents, the said David Dowda the younger and David O'Dowda the elder, and either of them, shall, at the due request of the said Teig, his executors or assigns, make such assurance and assurances, by conveyance or otherwise, in writing, as by the said Teig, his heirs, executors, or assigns, or his and their council learned in the law shall be devised and advised. And the said David the younger, for himself, his heirs and assigns, for the considerations 
> 
> 
> 
> ---
> 
> p.364
> 
> 
> 
> aforesaid, to and with the said Teig, his heirs, executors, and assigns, doth covenant, grant, and agree that if in case the said David the younger shall dye having no issue female by the said Dorothy, the estate whereof the said David shall dye seised and possessed shall be charged with a sum of money for the preferment and livelyhood of such issue female as by the said Teig Reagh Dowd, Teibot Burk fitz Walter of Turlogh, in the county of Mayo, Esq., and Henry Albongh of Rathlee, in the said county of Sligoe, Gent., or by any two of them, or by the heirs of any two of them, shall be thought fitt and sett down.’
> 
> 
> ‘And that the said David the younger shall, at the request of the said Teig, his heirs, executors, or assigns, give such power and writing to the said Teig, Tibott, and Henry, and to any of them, and the heirs of any two of them, to that purpose, as by the said Teige, his heirs, executors, or assigns, or his or their counsil learned in the law shall be devised and advised, Procided there be no issue male surviving the said David the younger of the body of the said Dorothy.’
> 
> 
> ‘Item, it is covenanted and agreed upon by and between the said parties, and the said David the younger doth convenant and graunt for himself, his executors and admistrators, to and with the said Teig, his executors and assigns, for the considerations aforesaid, that if in case the estate in these presents mentioned shall not be recovered in manner as is above expressed, whereby a jointure may not be secured for the said Dorothy as is hereby intended, and if in case the said David the younger shall happen to dye, the said Dorothy surviving him, that then, and in such cases the said Dorothy shall be satisfied in quantity and quality the said marriage portion, and a moiety of what goods over and above the said marriage portion as shall be then in the possession of the said David the younger at the time of his death. And it is furhter covenanted and agreed upon by and between the said parties, and the said David the younger, for himself, his heirs, executors, and admistrators, to and with the said Teig, his executors and assigns, doth convenant and graunt for the considerations aforesaid, that whereas the said Teig, his executors and assigns, are by these presents graunted to have a moiety of such goods as should be in the possession of the said David the younger at the time of his death, in case he shall happen to survive the said Dorothy, having no issue by her, if in case any part of the said marriage portion shall be employed or disposed by the said David the younger in recovering his estate, whereby the marriage portion, or the value thereof in goods shall not be extant at the time of the death of the said Dorothy, as is last mentioned, without issue, that then and in such case the said David the younger shall, out of such parte of his estate as shall be recovered as aforesaid, make up such parte of the said moiety as shall be in that case wanting, and which estate shall be recovered by the help of the said marriage portion.’
> 
> 
> 
> 
> ---
> 
> p.365
> 
> 
> ‘Item, it is covenanted and graunted by and between the said parties that in case the whole real estate of the said David O'Dowda the elder, and of the said David Dowd the younger, shall be left unto them or some of them, their heirs or assigns, or other lands in lieu of them, without disallowance in respect of qualification, that then the said Dorothy shall have for her jointure but the third parte of the same, any thing
> in these presents contained to the contrary notwithstanding. In witness of all and singular the premises the said parties have to these presents interchangeably put their hands and seals the day and year above written.’
>   
> 
> THADY DOWDA.
>   
> 
> 
> 
> "Being present at the signing, sealing, and delivery of the abovewritten articles, and at the interlineing
> of the words as is hereby intended, &c., twixt the 59 and 60 lines, we whose names duely ensure."
>   
> 
> DUDLY FERBISSY. MYLES FERBISSY.
> FRANCIS DOWDA. JAMES FERBISSY.
> DANIEL DOWDE.




This Dorothy, who became the wife of this Dathi, was the daughter of Teige O'Dowd by Margery Bermingham, daughter of John, a younger son of the Lord Baron of Athenry, and this Margery being an heiress, the O'Dowds became, as would appear from the family papers, entitled to quarter the Bermingham or Athenry arms with their own, but this they have not done.


It appears from the foregoing marriage articles that David Dowda, junior, was left without any estate, but that he had a strong expectation of being soon restored, and in this he was not disappointed, for the Commissioners appointed for the setting out of Lands to the Irish in Connaught and the County of Clare, restored him in August, 1656, to a small estate in the parish of Kilgarvan, barony of Gallen, and county of Mayo, the ancient patrimony of the Clann Donogh O'Dubhda. This appears from the original grant in the possession of the present O'Dowda, which is as follows:
  

‘By the Commissioners for setting out lands to the Irish in the province of Connaught and county of Clare.’
  



‘In consequence of the Decree of the Commissioners for adjudication of the Claimes and qualifications of the Irish, graunted on behalfe of David O'Dowda, of Leafonye, in the county of Sligoe, whereby hee is adjudged to have two third partes of his estates by virtue of the right qualification wherein he is compressed, sett out to him in the province of Connaght, or county of Clare; it is ordered and heerby impowered to enter



---

p.366



into, and take possession of one thousand five hundred and forty-six acres in the land hereafter specified, viz., in the two quarters of Carowcrum and Carcacrum, one hundred and thirty-two acres; in the two quarters of Boneconelan two hundred and seventy-six acres; Carrowlaban, one quarter, one hundred and fifty-three acres; Carrowreagh, one quarter, one hundred and twenty-nine acres; Kilnegarvan one hundred and fifty acres; Raredane, two quarters, two hundred and ninety-seven acres; Carrownegloontagh, one quarter, one hundred and fifteen acres; Carrownecarra, one quarter, one hundred and ninety-nine acres; and in Carrownegloch, one quarter, ninety-five acres; all lying in the parish of Kilnegarvan, barony of Galleng, and county of Mayo, to have and to hould all and singular the said lands, with all the houses, buildings, mills, fishing weyres, water courses, and other improvements and appurtenances, to him, the said David O'Dowda, his heyres and assignes for ever, in full satisfaction of his estate, according to the tenor of the said Decree; and the High Sheriff of the said county, or his Deputye, is hereby required and authorized to put him in full and quiet possession of the premises, takinge for his paynes five shillings, and no more. Dated at Loghreagh, this 4th of August, 1656.’
  

HENRY GRENEWAY.
  

CHARLES HOLCROFT.
  

JA. CUFFE.
  

‘Entered and examined,
  

EDW. HURD.’


This David had by Dorothy, his wife, four sons, namely, 1, David, who was more than seven feet tall, was an officer in the service of King James II., and was slain at the battle of the Boyne; 2, James, who was also an officer in King James II.'s service, and fought at the Boyne, which he survived, and distinguished himself at the siege of Athlone and battle of Aughrim, in which latter engagement he was slain; when his body was discovered his sword was found in his hand, which was so swollen from exertion that the guard of his sword had to be filed off before the hand could be disengaged from it; 3, Thady, or Teige, who was an officer in the service of the King of France, and subsequently admitted to the honour of nobility in Venice, and who died of a fever in France, without issue; 4, Dominic O'Dowda, No. 39, by whom the line was continued; and 5, Francis Dowd, who left no issue. See Will of 1731, next page.


*‘In 1705, this David and his fourth son, Dominic, then the only surviving son, sold several denominations of land to a Mr. Wingfield, as appears from the original deed of sale, in the possession of the present O'Dowda.’*


*39. Dominic O'Dowda, fourth son of David.* — He married, in 1703, Ellice Dillon, daughter of Theobald Dillon, Esq., whose brother was a colonel in the service of James II., and died in 1737, leaving by her David O'Dowda, his eldest son (see Lodge's Peerage by Archdall, vol. ii. p. 182), who married Letitia Browne, daughter of James



---

p.367



Browne of Kilticolla, afterwards Brownehall, in the county of Mayo, Esq., and died without issue. This is the David mentioned by the venerable **Charles O'Conor**, in his Dissertations on the History of Ireland, in 1753, as the head of the O'Dowds. On the 6th of August, 1776, he and his wife Letitia O'Dowda, otherwise Browne, obtained a decree in Chancery against George Fitzgerald, Esq., of Turlough, in the county of Mayo; 2, James, an officer in the French service, who died without issue; and, 3, Thady O'Dowda, a colonel in the army of the Emperor Joseph.


His Will is dated 18th September, 1731, and is as follows:
  


> 
> ‘In nomine Dei. Amen.
>   
> 
> I, Dominic O'Dowd, of Bunicunilane, weak and feeble of body, and troubled by many distempers, yet of sound memorie, sence, and reason, the Lord be praised, understanding my later days to approach, and fearing lest I should be surprised by death, do order and settle my last Will and Testament as followeth:
>   
> 
> Imprimis, I bequeath my soul and body upon my Redeemer, and my body to be buried in my ancestors' Tomb, in Moyne, if allowed, otherwise where my relations will think fit.
>   
> 
> 2ndly. I order for my married wife, pursuant to the articles of intermarriage, the same forty pounds sterling per annum mentioned in said articles.
>   
> 
> 3rdly. I order for my eldest daughter Molly Dowd three hundred pounds sterling.
>   
> 
> 4thly. I order for my son James Dowd two hundred pounds sterling.
>   
> 
> 5thly. I order for my daughter Evelin Dowd hundred and fifty pounds sterling.
>   
> 
> 6thly. I order for my son Thady Dowd hundred and fifty pounds sterling.
>   
> 
> These sums I order to be paid out of my real estate.
>   
> 
> 7thly. I order for the convent of Moyne five pounds sterling, and also for the convent of Ardnaree five pounds more, and lastly, for the convent of Strade two pounds ten shillings sterling. Further, I order for my parish priest, father David Henry, the sum of two pounds sterling, and to fr. Francis Beolan twenty shillings.
>   
> 
> 8thly. I order for my niece Molly Dillon ten big cows. All these aforesaid legacies I order to be deducted, or paid out of the personal estate.
>   
> 
> 9thly. I order twenty pounds sterling to be paid towards my funeral expenses.
>   
> 
> Lastly. I do nominate and appoint Coll.l Morgan Vaughan, Counsellor Richard Cormick, and Mr. Toby Burk my true and lawful executors, to oversee my wife and children, and this my last will and testament executed. In witness, and for the true performance of all and singular the premises, I have hereunto set my hand and seal, this
> the eighteenth of September, in the year one thousand seven hundred and thirty-one.
>   
> 
> Memorandum.— I do order and bequeath to my brother Francis Dowd the sum
> 
> 
> 
> ---
> 
> p.367
> 
> 
> 
> of two hundred pounds sterling, together with three years' interest, ending the first of November next, which sum was ordered by my father, David O'Dowd, and by myself as child's portion for him; and I do appoint that it should be paid out of my real estate. In witness and for the true performance of all and singular the premises, I do hereunto set my hand and seal, this the eighteenth day of September, 1731, thirty-one.’
> 
> 
> Dominic O'Dowd.
> Signed, sealed, and delivered in presence of us,
> Henry Jordan.
> Hugh O'Donnell.
> Francis Moore.
> "A true copy."




Of David, his eldest son, the venerable **Charles O'Conor of Belanagare** wrote the following notice in the first edition of his Dissertations on the History of Ireland, published in 1753, pp. 234, 235:
  


> 
> The *Hy-Fiachras,* whose great ancestor *Dathy,* carried the Terror of the *Scotic* Name to the Foot of the *Alps*, possessed the Countries of Tir Fiachra and Tir Awly, from the fifth Century to the fifteenth. Our old Annals pay a large Tribute of Praise to this family, and it is represented at present by a Gentleman of the strictest Probity, *David,* or properly *Dathy O'Dowda,* of Ballycollanan *[rectius Bunnyconnellan]*, in the County of Mayo, Esquire.
> 
> 
> 




40. *Thady, Teige, or Thaddaeus O'Dowda, third son of Dominic O'Dowda.*— Sir Richard Musgrave states, in his Memoirs of the different Rebellions in Ireland, that this ‘Thady being a younger brother, and having neither property nor employment at home, went out a volunteer to Germany at the age of twenty-five years, and in the course of time was promoted, in the Hungarian service, to the rank of captain *[recte colonel]*, having previously married a German lady, sister to the Baron Wipler *[recte Vippler]*, of whom James O'Doude was the issue.’


According to the tradition in the family this Thaddaeus O'Dowda, who was called at home Tadhg Riabhach O'Dubhda, went out to Germany and entered the Austrian service, accompanied by Manus O'Donnell, who was promoted to the rank of general, and also by George Fitzgerald of Turlough, the father of the celebrated George Robert Fitzgerald. That he was promoted to the rank of colonel, and was one of the largest and bravest men in Germany, and that Antonia Vippler, the sister of Baron Vippler, residing in Silesia, fell in love with him, to whom, after much opposition on the part of her family, who threw many difficulties in his way, and even procured his imprisonment,



---

p.369



he was finally married, and through whom he was introduced to the highest circles in Germany. By her he had issue James O'Dowda, who was commonly called the Baron O'Dowda, of whom presently, and another son, who died young in Germany.


41. *Captain James O'Dowda,* commonly called Baron O'Dowda. Sir Richard Musgrave states, in his Memoirs of the different Rebellions in Ireland, that this James O'Dowda was born and educated in the Hungarian service, and that he had only arrived at the rank of lieutenant, ‘in which station,’ he adds, ‘he served, when the death of his uncle, David O'Doude, who possessed the family estate, and died without issue, was announced to him. In consequence of this event,’ adds this historian, ‘he left the army, came to Ireland, and took possession of the paternal property, which proved to be worth about £500 a year, and which he applied himself to the cultivation of with great attention.’


It appears from the family papers, and particularly from a letter in the handwriting of his uncle, the Baron Vippler, that this James returned to Ireland shortly before the year 1788. In the will of Letitia Browne, *alias* O'Dowda, the widow of his uncle David O'Dowda, dated 10th February, 1798, she states ‘that her late husband, David O'Dowda, lived in the Isle of Man,’ and she orders ‘that all the papers and the deeds of mortgage respecting Mac Donnell of Elaghmore shall be given to Captain O'Dowda, whose property it is, together with the copy of the map of his estate, and all other papers belonging to him.’ Her nephew, James Browne, of Browne Hall, Esq., administered to this will.


In the statistical account of the parish of Kilmactige, in the diocese of Achonry, and county of Sligo, written by the Rev. James Nelligan, Rector and Vicar, and published in Mason's Parochial Survey, vol. ii. pp. 349–398, the following curious account is given of the improvements made by this Captain James O'Dowda:
  


> 
> ‘A valuable improvement was made in this place about twenty years ago, through the exertions of a Captain O'Dowdd *[a misprint for O'Dowda]*, who possessed an estate of many thousand acres of these mountains, which were without inhabitants, except those ‘ferae naturae,’ and which were nearly impassable to the active and barefooted native. The immense rocks, steep hills, and deep caverns, which everywhere presented themselves, formed as many insuperable difficulties as the passage of the Alps did in former days; but this Hannibal by labour and perseverance overcame them all, and has now formed a road, where a coach passes six times a week, conveying passengers to and from Ballina and Castlerea, and has shortened the line from Ballina to Banada from twenty to twelve miles.’
> 
> 
> This Captain James O'Dowda, who is said to have been the godchild of the Emperor Joseph, was implicated in the rebellion of 1798, and executed at Killala in September,
> 
> 
> 
> ---
> 
> p.370
> 
> 
> 
> 1798. A very curious sketch of his character is given by Sir Richard Musgrave, in his Memoirs of the different Rebellions in Ireland, vol. ii. pp. 622, 623, 624, where he says that ‘considering himself the head of the Clan or family, he despised taking a Christian name, and always subscribed himself O'Doude, Captain, and latterly he had the vanity to assume the title of Baron, perhaps from his uncle Baron Wipler in Germany.’ Sir Richard says that this family counted twenty-five castles on their extensive estate, many of which are still in existence, and that they ‘have a burying place appropriated to them in the abbey of Moyne, where may be seen the gigantick bones of some of them, who have been very remarkable for their great stature, as one of them exceeded seven feet in height.’— Vol. ii. p. 624.
> 
> 
> This Captain James O'Dowda, who was popularly called the Baron O'Dowda, married Temperance Fitz Gerald, daughter of Robert Fitz Gerald, Esq., of Mount Tallant. This marriage took place in the year 1788 or early in 1789, when he was very young, as appears from a German letter in the handwriting of his uncle, the Baron Vippler, dated Wigstädt, the 21st November, 1788, of which the following translation, made for the Editor by that accomplished scholar, George Downes, Esq., author of Letters from Continental Countries, &c. &c., is worth preserving:
> 
> 
> > MY DEAR NEPHEW,
> > I was infinitely delighted to hear that of six letters written to you one had come to hand, and no less that you will be so kind as to admit the sincerity of my letter: you may now quite confidently believe that no one can have more sincere intentions towards you than I. You are then already quite determined to marry? To tell the truth, I would witness it with more pleasure if it were to happen a couple of years later; however, you are not to be checked; and I therefore wish you much joy. May you propitiously take this so great step, which is truly of the last importance! for every thing which is eternal ought to be undertaken with caution; and you, my good nephew, have not yet had the opportunity of acquiring sufficient experience of the world. Your future lot will therefore so much the more depend on fortune. And, dear O'Dowda, only keep religion and God constantly before your eyes; for such must be always kept in view by an honourable man. That you have become so good a manager, I am infinitely delighted to hear. God grant that you may continue in this course, and believe that the best enjoyment is one's own approbation! You can take myself as an example. How much have good friends cost me, and how little has been purchased!
> > 
> > 
> > That you have received no letter from my brother must not surprise you: you know already with what reluctance he writes. Now concerning your money. To speak
> > 
> > 
> > 
> > ---
> > 
> > p.371
> > 
> > 
> > 
> > candidly, it is better for you not to be informed. If you did not get the money [*...*] and then you must *[appear]* at our court about permission.
> > 
> > 
> > Mac Kernan is gone on an expedition against the Turks: it is about two months since he left me, but I have not yet received a letter from him. Do not forget to assure your worthy aunt of the very devoted respect I entertain for her. I am delighted that you ride indefatigably: but be on your guard to avoid meeting with an accident.
> > 
> > 
> > To conclude,
> >   
> > 
> > Your sincere uncle,
> >   
> > 
> > Yours from his heart,
> > 
> > 
> > WM. VIPPLER 
> 
> 
> 
> 
> 




This letter proves beyond a question the connexion of Captain O'Dowda with the family of Vippler; but nothing has been yet discovered to prove that he became the heir of that family, or that he had any right to the title of Baron. The following letter, written by the Honourable Thomas Dillon to him, on the 17th of January, 1795, shows that a relative in Germany had left him a handsome sum of money. This relative was probably his uncle, the Baron Vippler: 


> My Dear Friend,
> It gives me very great Pleasure to inform you that I had a Letter last Post from Lord Dillon, desiring I would send to you to give you the pleasing Intelligence of the following matter, which I give you down in his Lordship's Words. ‘Inform O'Dowda directly that there is a handsome Sum of Money left to him by a Relation in Germany; tell him to write immediately to Baron Reiyensfield, Secretary to the Imperial Minister, No. 6, Bryanton-street, Portman-square, London, or to Count Starhemberg, the Imperial Minister, Portland-place, London; but if he will take my Advice he will set out directly for London. Let him call upon me; I will give him a letter to Count Starhemberg, and that will shorten all proceedings; he may otherwise meet with great delay.’
> 
> 
> Wishing you every prosperity, I remain, My Dear O'Dowda,
>   
> 
> Your very affectionate
>   
> 
>  Humble Servant,
> 
> 
> THOS. DILLON. 
>   
> Loughglin House,
> 
> 
> 17 Jan. 1795. I send this in the care of our friend Mr. Hughes, who will lose no time in forwarding it.
>   
> O'Dowda, Bunniconilan.
> 
> 




He had issue, 1, Thaddaus O'Dowda of Bunnyconnellan, now the O'Dowda, of 



---

p.372



whom presently; 2, James Fiachra O'Dowda of Dublin, solicitor, who married, first, Anne, daughter of William Walker, Recorder of Dublin, and, secondly, Mary, daughter of Joseph Burke of Carrowkeel, county of Mayo, Esq., but had no issue by either, and died in 1843, leaving his property to the family of his eldest brother the O'Dowda; 3, Robert O'Dowda, now an advocate in the supreme court of Calcutta, who married, in 1828, Catherine Wilhelmina Fulcher of the city of London, by whom he has issue four sons, viz., Robert Charles, James William, William Hickey, Henry Cubitt, and two daughters, Kate Ellen, and Louisa Kenny.


Captain O'Dowda (No. 41) had also two daughters, viz., Antonia Letitia, and Temperance, spinsters, now living.— See Exshaw's Magazine, January, 1790, in which is the following entry under BIRTHS:— ‘At Mount Tallant, near Dublin, the Lady of Baron O'Dowda, of a daughter.’


42. Thaddaeus O'Dowda, Esq., son of Captain James O'Dowda. He married, in 1812, Ellen White, daughter of Charles White of Dublin, merchant, and has the following issue, all living at present: Dr. James Vippler O'Dowda, a practising surgeon in Dublin; 2, Thaddaeus O'Dowda, Junior, who is six feet seven inches in height; 3, John Taaffe O'Dowda; 4, David; 5, Robert Francis O'Dowda, and four daughters, namely, Ellen, now Mrs. Kelly, Caroline Victoria, Catherine Wilhelmina, and Elizabeth. He had also another son Francis, and two daughters, Harriet and Louisa, who died young.


Arms: Or, a saltier sable; in chief two swords in saltier; in base an oak leaf, vert.


Crest: Over a coronet, a hand in armour holding a dart, ppr.


Supporters: Two lions rampant.


Motto: Virtus ipsa suis firmissima nititur armis.


In a MS. about one hundred and fifty years old, the arms of O'Dowde are described thus: ‘or, a saltier sable, in chief two swords saltierways, garnished of the first.’ No supporters are mentioned.


The oldest seal of arms in the possession of the present O'Dowda belonged to the David O'Dowda mentioned by **Charles O'Conor**, in 1753, the head of the family. It exhibits the supporters and the coronet in the crest.


### B

### Pedigree of O'Shaughnessy


Of the ancient history of the O'Shaughnessys— who have been so celebrated in Ireland since the reign of Henry VIII— the Irish annals have preserved but very slight memorials. Since the period alluded to they have been much praised, not only by the Irish bards, but by the more respectable writers of the country, and they had undoubtedly



---

p.373



held high rank in Connaught, and have intermarried with the best families of English descent, as the Burkes, Berminghams, Butlers, &c. It appears from a by-law of the Corporation of Galway, passed in 1648, that ‘Lieutenant Colonel William O'Shaugnessie (in consideration of his alliance in bloode to the whole towne, and for good nature and affection that he and his whole family doe bear to it) and his posterity, shall be hereafter freemen of this corporation.’— History of Galway, p. 216. From their celebrity, high bearing, and character for integrity and honour in Ireland, De Burgo was induced, in his Hibernia Dominicana, to write of this family, ‘cujus nobilitatem, antiquitatem, et integritatem qui non novit, Hiberniam non novit.’ Notwithstanding all these testimonies, however, the truth of history obliges us to state that the O'Shaughnessys are but rarely mentioned in ancient Irish history, and that no person of the name ever became full chief of Aidhne or the south Hy-Fiachrach, the O'Heynes, O'Clerys, or Mac Gillikellys being in turn the chiefs of that territory; but upon the decay of the family of O'Cathail, or O'Cahill, shortly after the period of the English invasion, the O'Shaughnessys became chiefs of the territory of Cinel Aodha, or Kinelea, which comprised the south-eastern half of the territory of Aidhne, and this was the highest rank they ever attained to.


In a Description of the Province of Connaught, dated in the month of ‘January, 1612,’ published in the twenty-seventh volume of the Archaeologia, it is stated that the O'Heynes were then utterly banished; but that ‘the O'Shaughnesses retnayned a rich and hable family.’— p. 126.


4. *Eochaidh Breac.*— He was the third son of the monarch Dathi, according to the
 Book of Lecan, but we are told no more about him, except that he was the ancestor of the southern Hy-Fiachrach, or the Hy-Fiachrach Aidhne, and of the tribe called Hy-Eathach of the Moy, seated to the west of that river, in the barony of Tirawley, in the county of Mayo, and that he was the father of,
  


5. *Eoghan Aidhne,* i. e. Owen, or Eugenius of the territory of Aidhne, now comprised in the diocese of Kilmacduagh, in the south-west of the county of Galway; he was so called from his having been fostered in that territory by a tribe called Oga Beathra, who afterwards adopted him as their chief.— Vide supra, p. 53. He had four sons, namely, 1, Conall; 2, Cormac; 3, Sedna; 4, Seanach Ceanngamhna, from whom sprung a sept called Cinel Cinngamhna, of whom the O'Duibhghiollas were the chiefs after the establishment of surnames in the eleventh century.


6. *Conall, son of Eoghan Aidhne.*— We are told nothing about him, except that he
had one son, namely,
  

7. *Goibhnenn.*— He was chief of Hy-Fiachrach Aidhne, and in the year 531 fought
the battle of Claonloch, in the territory of Kinelea, in which was slain Maine, son of Cerbhall,



---

p.374



Cerbhall, while defending the hostages of the Hy-Maine of Connaught.— ( Annals of the Four Masters) He had one son,
  

8. *Cobhthach.*— He had three sons, namely, 1, Aodh, the ancestor of the tribe called Cinel Aodha na h-Echtghe, of whom the O'Cahills and O'Shaughnessys were the chiefs after the establishment of surnames; 2, Colman, the father of the celebrated Guaire Aidhne, King of Connaught, and ancestor of the families of O'Clery, O'Heyne, Mac Giolla Cheallaigh, now Kilkelly, and others; 3, Conall, the great grandfather of St. Colman, patron saint of Kilmacduagh, whose crozier and belt, ornamented with gold and gems, was in the possession of the O'Shaughnessy family in **Colgan**'s time (1645).


9. *Aodh, son of Cobhthach.*— Of the generations from this Aodh down to Gealbhuide (No. 27 in the Genealogical Table) our annalists have preserved no notice.


The first notice of this family which occurs in the Irish annals is at the year 1159, in which it is recorded that Gealbhuidhe, the son of Seachnasach, was slain in the memorable battle of Ardee, fought between Muircheartach Mac Loughlin. head of the northern Hy-Niall, and Roderic O'Conor, King of Connaught. The following are all the notices of the O'Shaughnessys, O'Cahills, and their territory of Cinel Aodha, or Kinelea, preserved in the Annals of the Four Masters and Clonmacnoise, down to the year 1408.


‘A. D. 1154. Toirdhealbhach O'Conor *[King of Ireland]* set out on a predatory excursion into Meath, but returned without a single cow, his son Maelseachlainn and Donnchadh O'Cathail *[Donogh O'Cahill]*, lord of Cinel Aodha na h-Echtghe *[Kinelea of Slieve Aughty]*, being killed.’— Four Masters.


‘A. D. 1159. Gealbhuidhe O'Shaughnessy *[recte Mac Shaughnessy]* was slain in the battle of Ath Fhirdia.’— Four Masters.


‘A. D. 1170. Diarmaid O'Cuinn *[Dermot O'Quin]*, chief of Clann Iffernain *[in Thomond]*, was slain by the Cinel Aodha of Echtghe.’— Four Masters.


‘A. D. 1191. Cinel Aodha na h-Echtghe was given to King Roderic O'Conor.’— Four Masters.


‘A. D. 1197. Maoileachlainn Riabhach O'Shaughnessy, lord of half the territory of Cinel Aodha, was slain by the son of Donnchadh O'Cathail *[O'Cahill]*.’— Four Masters.


‘A. D. 1221. The sons of Gillenenewe macconn *[recte Cromm]* O'Seaghnossa, took house upon Gille Mochoynne O'Cahall, prince of Kynelhagh, who killed him after his coming foorth.’— Ann. Clonmacnoise, translated by **Connell Mageoghegan**.


‘A. D. 1222. Giolla Mochoine O'Cathail, lord of Cinel Aodha, East and West, was slain by Seachnasach, the son of Giolla na Naomh O'Shaughnessy, at the instigation of his own people.’— Four Masters.




---

p.375


‘A. D. 1224. Seachnasach, the son of Giolla na naomh O'Shaughnessy, was slain by the Clann Cuilen *[the Mac Namaras]* and the bachall mor *[large crozier]* of St Colman of Kilmacduagh, was profaned by this deed.’— Four Masters.


‘A. D. 1224. Giolla na naomh Crom O'Shaughnessy, lord of the western half of Cinel Aodha na h-Echtghe, died.’— Four Masters.


‘A. D. 1240. Hugh, the son of Giolla na naomh Crom O'Shaughnessy, was slain by Conchobhar, son of Aodh, son of Cathal Croibhdhearg O'Conor and Fiachra O'Flynn.’— Four Masters.


‘A. D. 1248. Opichen Guer *[Hopkin Poer]* was slain by Giolla Mochoinne O'Cahill.’— Four Masters.


‘A. D. 1251. Giolla Mochainne, the son of Giolla Mochainne O'Cahill, was slain by Conchobhar, the son of Cathal Croibhdhearg O'Conor.’— Four Masters.


‘A. D. 1403. Mortagh Garve O'Seaghnosy, tanist of Tyre-Fiaghragh Ayne, was killed by those of Imaine.’— Annals of Clonmacnoise, translated by **Mageoghegan**.


‘A. D. 1408. John Cam O'Shaughnessy was slain by the son of O'Loughlin, in a game on the green of Clonrode.’— Four Masters.


Seeing from these extracts (and we have no more), that it is now impossible to add dates to the pedigree of O'Shaughnessy given in the Genealogical Table, from Aodh, the ancestor of the Cinel Aodha, down to Sir Dermot, who was knighted in 1533 (No. 36 in the Genealogical Table), we must be content with illustrating this pedigree from this Sir Dermot down to the last acknowledged representative of the name, and adding
a few observations to identify the present senior of the name.


36. *Sir Dermot O'Shaughnessy* was the son of William, who was the son of John Buidhe, son of Eoghan, son of William, son of Giolla na naomh, son of Ruaidhri, son of Giolla na naomh Crom, lord of the western half of Kinelea, who died in 1224, son of Raghnall, or Randal, son of Gealbhuidhe, who was slain at the battle of Ardee in 1159, son of Seachnasach, the progenitor after whom this family took the name of Ui Seachnasaigh, i. e. descendants of Seachnasach, now generally anglicised O'Shaughnessy, and pronounced in the original territory O'Shannessy, and by some corruptly anglicised Sandys.


The first notice of this chieftain is found on Patent Roll, 33–35, Henry VIII., from which it appears that the king, on the 9th of July, 1533, wrote to the Lord Deputy and Council of Ireland, saying, ‘We have made the Lord of Upper Ossory, McNemarrowe, O'Shaftnes, Denys Grady and — — Wise, Knyghtes; and woll that by virtue and warraunt hereof youe shall make out unto McNemarrowe, O'Shaftnes and Denys Grady, several patentes of all soche lands as they nowe have.’


By Letters Patent, dated 3rd December, 35 Henry VIII., A. D. 1543, the king granted to Sir Dermot Sheaghyn *[Sheaghynes]*, knight, captain of his nation, in consideration



---

p.376



of his submission, and pursuant to the king's letter, dated the 9th of June preceding, ‘All the manors, lordshipps, towns and town-lands of Gortynchegory, Dromneyll, Dellyncallan, Ballyhide, Monynean, Ardgossan, Ballyegyn, Kapparell, Clonehaghe, Tollenegan, Lycknegarishe, Crege, Karrynges, Tirrelagh, Rathvilledowne, Ardmylowan, one-third part of Droneskenan and Rath; the moiety of Flyngeston, Ardvillegoghe, Dromleballehue, Cowle, and Beke’, which lands, it is recited, the said Sir Dermot and his ancestors had unjustly possessed against the Crown, to hold to him and his heirs male in capite, by the service of one Knight's fee, with a clause of forfeiture in case of confederacy against, or disturbance to the Crown. *Inrolled* on the Patent Roll of the thirty-fifth year of Henry VIII. *Dorso.*


This Sir Dermot married Mor Pheacach, i. e. More the Gaudy, O'Brien, who died in 1569, at an advanced age. Her death is thus recorded in the Annals of the Four Masters:— ‘A. D. 1569. Mor Pheacach (daughter of Brian, son of Tadhg, son of Toirdhealbhach, son of Brian of the Battle of Nenagh O'Brian) and wife of O'Shaughnessy (Diarmaid, son of William, son of John Buidhe), a woman celebrated for her beauty and munificence, died. By Mor Pheacach he had two sons, namely, Sir Roger, his successor, and Diarmaid, or Dermot Reagh, who went to England in his youth, and became servant or companion to the Earl of Leicester, as will presently be made appear from original documents.’


37. *Sir Roger, son of Sir Dermot.*— This Sir Roger was generally called Giolla dubh, anglice Gilduff, or Gilliduff, i. e. juvenis niger, by the Irish, from his black complexion and the colour of his hair. He married the Lady Honora (daughter of Murrogh, first Earl of Thomond) who had been a professed nun and an abbess, by whom he had four sons, namely, 1, John, born four or five years before marriage, as were also two daughters, Joan and Margaret; and, 2, William; 3, Fergananim; and, 4, Dermot, who were all born in marriage. Sir Roger, who was called by the Irish Giolla dubh, died in the year 1569, as we learn from the Annals of the Four Masters, in which the following notice of his death is given:— ‘A. D. 1569. O'Shaughnessy (Giolla dubh, son of Diarmaid, who was son of William, who was son of John Buidhe), pillar of support to the English and Irish who had sought his assistance, and a man who, though not skilled in Latin or English, had been greatly valued and esteemed by the English,
died. His son John assumed his place.’


After the death of Sir Roger, his brother, Diarmaid Riabhach, anglice Dermot Reagh, or Darby the Swarthy, O'Shaughnessy, who had been servant or companion to the Earl of Leicester, returned to Ireland, having first procured a letter from Queen Elizabeth to her Deputy, **Sir Henry Sidney**, of which the following is a faithful copy although, by some unaccountable mistake, he is in it called the son of William.



---

p.377



>   
> By the Queene.
>   
> Elizabeth R.
> 
> 
> Right trusty and welbeloved we grete you well.
> Wher one Derby O'Shaghnes the youngest sonne, as he saith, of William O'Shaghnes, Lord of Kynally, in that o*u*r Realme of Ireland, hath by the meanes of his Lord and Master, o*u*r Coosen, the Erle of Leicester, humbly required us not onely to geve him leave to returne into his contry, but also to recomend his peticion unto yow for some order to be taken with hym upon the death of his brother named Roger O'Shaghnes as being next heire unto him, we being duely inforemed of his honest demeaner here and of his earnest desire to Serve us, have been content to accompt him to o*u*r Service, and do require yow to have favorable consideracion of his sute, and as you shall fynd it mete to place and settle him in the foresaid Contry, so the rather to incurrage him to persever in his fidelitie, to shewe
> him as muche favor as may accord with the good goverment of the same Contry.— 
> 
> 
>   
> Given under our Signet at o*u*r Mannor of Otelands,
> 
> 
> the xxiiird of June, 1570, in the xiith yere of our Reigne.
>   
> To o*u*r right trusty and welbeloved S*i*r Henry Sidney,
>   
> 
> Knight, of o*u*r order of the Garter, and Deputy of
>   
> 
> our Realme of Irland.
> 
> 




It is very extraordinary, that in this letter Dermot Reagh is supposed to have been the son of William O'Shaughnessy, which he most unquestionably was not, for we have the testimony of the Irish Annals, and of his cotemporaries, that he was the brother of Sir Roger, as he states himself, and as such he was not the son but the grandson of a William O'Shaughnessy, for Sir Roger was the son of Sir Dermot, and
grandson of William. It would appear from the following entry in the Annals of the Four Masters that this Derby or Dermot was made chief of his name in 1571:
  


‘A. D. 1571. John, son of Gilla dubh, who was son of Diarmaid O'Shaughnessy, who had been the O'Shaughnessy from the time of the death of his father until this year, was deprived of that title, and also of Gort Insi Guaire, by his paternal uncle Diarmaid Riabhach, the son of Diarmaid, for he was virtually the senior.’


This Dermot Riabhach, or Reagh, as we are informed by the Four Masters, continued to be the chief of the O'Shaughnessys until the year 1573, when he and Ulick, the son of Richard Burke, slew Morogh O'Brien (the son of Dermot, who was son of Morogh), in revenge for which John Burke deprived O'Shaughnessy of Gort Inse Guaire. But he held considerable sway in the territory till the year 1579, when he laid a snare for his nephew William, the second son of Sir Roger, near Ard Maoldubhain, on which occasion a fierce combat took place between them, in which he slew his nephew, but though



---

p.378



he did, he received such deep wounds himself that he died of them in less than an hour afterwards.


After the death of Dermot Reagh, John O'Shaughnessy, the eldest son of Sir Roger, but who had been born before marriage, was again set up as the O'Shaughnessy, but his brother Dermot, who having been himself born in marriage, looked upon John as a bastard, made strong efforts to depose him; and John finding that the laws of England were in favour of Dermot, fortified himself against him by conveying all the lands in O'Shaughnessy's country to Sir Geffrie Fenton, for the sole consideration of Sir Geffrie maintaining his title against Dermot, who continually disturbed him in his possession. Both appeared at the parliament convened at Dublin in the year 1585, after which we have no more of John, or any of his descendants; but Sir Dermot appears to have been chief of his name till his death in 1606.


The following abstract of Depositions will throw much light upon the genealogy and rank of the O'Shaughnessy family at this period:
  


> 
> ‘Abstract of Depositions in a cause in the Chancery of Ireland, wherein Fulk Comerford was Plaintiff, and Roger O'Shaghnes of Gort-Inchigorye, in Galway Co., Defendant, touching the town and lands of Cappafennell, or Capperell, in that Co. A. D. 1615.’
> 
> 
> ‘Donnell O'Holloran of Gilloconry, in Galway County, husbandman, deposed that Sir Roger O'Shaghnes was son and heir of Sir Dermott— that Sir Roger was married to Honora ny Brien, by whom he had four sons: 1, *John,* born about four or five years before marriage, as were also two daughters, Joan and Margaret; and, 2, *William;* 3, *Fergananym;* and, 4, *Dermott,* born in marriage— that William was married, but died without male issue, and *Fergananym* died unmarried— that John O'Shaghnes conveyed all the lands in O'Shaghnes' Country to Sir Geffrie Fenton, for the sole consideration of Sir Geffrie maintaining the title of *John* against *Dermott*— that John was continually disturbed in his possession by Dermott, the Defendant's father— that Dermott, after the death of his two brothers, and in the life-time of John, enjoyed the greatest part of the lands of which Sir Roger had died seised, and that John was always reputed to be a bastard— that Sir Roger, the Defendant's grandfather, enjoyed these lands (viz. Cappafennell) and had tillage there, having had at one time fourteen score of reapers in harvest cutting, of whom Deponent was one.’
> 
> 
> ‘Depositions to the same effect were made by the following persons, viz.:’
> 
> 
> ‘Knougher Crone O'Hyne of Ledygane, gent., 100 years old and upwards.’
> 
> 
> ‘Richard Bourke of Rahaly, in Galway county, 64 years old or thereabouts, who
> 
> 
> 
> ---
> 
> p.379
> 
> 
> 
> added, that he had seen an order of Council made by **Sir Henry Sydney** between Dermott and William, brother and son of Sir Roger, ordering that William should enjoy O'Shaghnes' lands to him and his heirs male, remainder to Dermott, Sir Roger's brother.’
> 
> 
> ‘Margaret Countess Dowager of Clanrickard, 80 years old and upwards, sister to Honora, wife of Sir Roger, who added that they were married by a dispensation from Rome.’
> 
> 
> ‘Manus Ward Dean of Kilmackoweth *[Kilmacduagh]*, 80 years old or thereabouts, who added that he knew of the controversy between Dermott and William O'Shaghnes, as above mentioned, wherein Dermott endeavoured to prove Sir Roger's sons bastards, because their mother was abbatissa and could not be wife.’
> 
> 
> ‘Sir Tirrelagh O'Brien of Dowgh, in Clare Co., Kn*igh*t, nephew of Honora ny Brien.’
> 
> 
> ‘Donell O'Heyne of Killaveragh, freeholder, aged 80 years.’
> 
> 
> ‘Richard Lord Brimigham, Baron of Athenrye, nephew to Sir Roger by his mother.’
> 
> 
> ‘Tirlagh Roe Mc Mahowne of Clare county, Esq., 44 years old, who added, that he knew the Defendant's father, Dermott, to have been in suit with John O'Shaghnes, and to have held Gort-Inshygory, the Newton, and Ardemoylenan, during John's lifetime,
> as heir of the body of Sir Roger.’
> 
> 
> ‘Nehemias Folan of Balladowgan, in Galway county, Esq., 60 years old, who added that Dermott Reogh O'Shaghnes, brother to Sir Roger, being servant to the Earl of Leyster, having come from England after Sir Roger's death, brought in question the legitimacy of Sir Roger's sons by the Lady Honora, at which time, during **Sir Henry Sydney**'s Government, it appeared that the said Honora was a professed nun when the said Sir Roger had the said John by her, and that afterwards a dispensation was procured from Rome for their marriage.’
> 
> 
> 




38. *Sir Dermot O'Shaughnessy,* the fourth son of Sir Roger. He died on the eighth of July, 1606, seised of the territory of Kinelea, *alias* O'Shaughnes's country, leaving Roger, otherwise called Gilleduffe, his heir (who was then aged twenty-three and married), and Shyly Nyn Hubert, his widow. He had also two other sons, viz. Dathi and William, the latter of whom had four sons, namely, William, Edmond, Roger, and Dermot, of whose descendants no account has been discovered. This Sir Dermot had also three daughters, namely, 1, Joan, wife of Sir William Burke, Knight, who was by him the mother of Richard Burke, sixth Earl of Clanrickard— (See Hibernia Dominicana, p. 277); 2, Julia, the wife of Teige O'Kelly of Gallagh; and, 3, Honora, the wife of Johnock Burke of Tully.


39. *Sir Roger O'Shaughnessy*, son and heir of Sir Dermot. He married two wives:



---

p.380



1, Elis, daughter of — — Lynch, by whom he had Sir Dermot, his son and heir, of whom presently, and one daughter, who married Daniel O'Donovan of Castle Donovan, chief of Clancahill in the county of Cork. This daughter of Sir Roger is not mentioned
in any pedigree of O'Shaughnessy that the Editor ever saw, but she is mentioned in Mons*igneu*r Laine's Pedigree of the Count Mac Carthy, and in the family papers of the late General Richard O'Donovan of Bawnlahan, near Castletownshend, in the county of Cork, as the daughter of Sir Roger O'Shaughnessy, Knight, and also in an ode addressed, in 1639, to her husband Daniel O'Donovan, by Muldowny O'Morrison, in which he thus praises him and his wife:
  


> 1. 1] Ua Donnabháin na n-déigh-bheart, tuilliomh garma a ghnáth-oighreacht,
>   
> 1] Cuinge ceart d'á fhréim roimhe, a theacht 'san réim rioghroidhe;
>   
> 3] Uachtaran iarthair Mumhan, urra an chirt do chothughadh,
>   
> 4] Flaith amhra d'ár g-crú Cuirc-ne, tarla an chlu fá a chomuirce.
>   
> 5] Buadh n-dealbha d'a dreich fosaigh, fuair inghion I Seachnosaigh,
>   
> 6] Réidhe gan chumga g-croidhe, úmhla, féile, is foistine.
>   
> 7] Pailm toruidh do threibh Dáithi, inghion réidh-chroidheach Ruaidhri,
>   
> 8] Fuair airghe na n-glún ór' chin, ag tnúth le h-oidhbhle an oinigh.
>   
> 9] Teist bhuan na ríoghraide roimpe, ni léig uaithe ar imirce,
>   
> 10] Tug ar ainm Ghuaire ór chin, an ghairm is buaine braithfidh.
>   
> 11] Fiu an treabh ór tuismheadh Síle, buaidh feile ar a prímh líne,
>   
> 12] Da coimhdhe ag maicne an mhíodh-óil: roighne aicme Eireamhóin.
> 2. 1] The offspring of Donovan of the good deeds, hereditary deserver of dignity,
>   
> 2] A worthy representative of the stock he sprung from, has come into the regal succession.
>   
> 3] Superintendent of the west of Munster, prop for supporting justice,
>   
> 4] Illustrious chieftain of our Corcnian blood, under whose protection our fame is placed.
>   
> 5] The palm for beauty of her sedate aspect O'Shaughnessy's daughter has obtained.
>   
> 6] Meekness without narrowness of heart, humility, generosity, firmness.
>   
> 7] A fruitful palm-tree of the race of Dathi, the kind-hearted daughter of Rory,
>   
> 8] Who inherits the attributes of the sires she sprung from, in longing to indulge the flame of hospitality.
>   
> 9] The undying character of the kings before her she has not suffered to pass away,
>   
> 10] But has reflected on the name of Guaire that lasting lustre she had derived from him.
>   
> 11] The race from whom Sheela has descended deserved the palm for hospitality,
>   
> 12] Of which the drinkers of metheglin boast: they are the choice of Heremon's race.
> 




Sir Roger married, 2, Julia, the daughter of Cormac Mac Carthy, lord of Muskerry,



---

p.381



but had no issue by her. He was living in the year 1647, as appears by a curious letter written by him to his daughter Gylles in that year, and now preserved at Bawnlahan, in the possession of Major Powell, who succeeded to the property of the late General O'Donovan in 1832. It is as follows:

> For my verie loveinge Daughter Mrs. Gyles Donovane, at Castledonovane,
> theise.
>   
> 
> DAUGHTER,
> 
> 
> I have received yours of the eighteenth of ffebruarie last, and as for your troubles you must be patient as well as others, and for my parte I taste enough of that fruite; God mend it amongst all, and send us a more happie tyme. As for the partie lately comaunded to the countree of Kiery, who may be expected to return that way, they are conducted by my Nephew (your Cuossen) Lieut. Collonell William Bourke, to whom I have written by the bearer in your behalfe. I am most Confident he will not suffer any wrong to be don unto your Dependants, Tenants, or yourself. And If in gase *[in case]* you should expect the whole Armey, you may certifie me soe much with speed, and I shall take that Course that shal be befittinge. In the meane tyme beseeching God to bless and keepe you and yours,
> 
> 
> I am,
>   
> 
> Youre assured loveing ffather,
> R. O'Shaghnissye. 
>   
> Fedan,
> 
> 
> 14. Martii, 1647.




The arms on the seal of this letter are ‘a tower crenelled in pale between two lions combatant.’ The crest, ‘an arm embowed holding a spear.’


This Gylles, who was living in May, 1676, had four sons, as appears from the O'Donovan records, namely; 1, Daniel, who was a colonel in the service of James II. and who was the great grandfather of the late General O'Donovan of Bawnlahan; 2, Cornelius; 3, Morogh; and 4, Richard, all living in 1655, but of whose descendants the Editor has not as yet discovered any satisfactory account, but believes that they are all extinct.


According to the pedigree of O'Shaughnessy given in the O'Clery MS. in the Library of the Royal Irish Academy, this Sir Roger, or Gilla-dubh O'Shaughnessy, died in the year 1650. There is a portrait of him dressed in armour preserved among the muniments of Ormond Castle, Kilkenny.


40. *Sir Dermot O'Shaughnessy.*— He married Joan, daughter of Lord Barrymore, and had by her two sons, Roger, his successor, and Cormac, or Charles. He died in
1673.


The following abstract of his Will, which is preserved in the Prerogative Court, Dublin, is well worthy of a place here, as throwing light not only on this pedigree, but upon the manners and customs of the times:


---

p.382



> 
> ‘I order my bodie to be buryed in the Cathedral Church of Kill McDuagh, in the tomb where my ancestors were buryed— I doe order, that my son and heir shall cause fyve hundred and fower skore Masses to be said or celebrated for my soule immediately after my death; and I bequeath £29 to be given to those who shall without delay celebrate those Masses, allowing 1s. for every Masse af*oresai*d, and that each of the abbye's and convents ment*ione*d hereafter do say the office of the dead for my soul and 15 masses besides,— I order 100 of my Ewes for my son Cha*rle*s O'Shaughnessy, and bequeath to my eldest son and heir Roger O'Shaughnessy all my plate and household stuff, and I do charge my said sonnes to live during their lives in brotherly affection amongst themselves without animosity or contention— I bequeath to my son Charles the £20 mortgage I have from I. Prendergast, of the 60 acres he had in Ballinekelly, provided he shall cause 200 masses to be said for my soule— I order and leave my stuffe suite with gold buttons and my rapier for my son Charles— I leave the piece of grey frize to Edmond O'Heyne. I leave the piece of grey broad-cloth to father John Mullowny, he sayinge as many masses, for my soule, as the said cloth is worth— I leave one of my shirts to John Butler, one more to Edmond Heyne, one more to my servant Lawrence Donovane, and another to Edmond M'Hugh— I leave one of my best halfe shirts and my scarlett wastcoate to Dermott Clorane— I order the gold diamond ring I have in pawne from James Devenisse, for himselfe, he saying one hundred rosaryes for my soule— I leave my white gowne to Lawrence Donovan, and the rest of all my clothes to my son and heir Roger— I leave my white horse to my daughter in law Hellean Shaughnessy, I leave three young cowes and three great cowes, with four garrans, to my daughter Gyles Salcan, and my hatt to John Buttler— I order my son Roger to pay Eight pieces of Eight towards James Dowley his ransome— I leave two cowes and a mare to my neice Nell Donovan— ’
> 
> 
> "In Witness of all which I have hereunto subscribed my hand and fixed my seal the 29th of January, 1671.
> DER. O'SHAUGHNUSSY. 
> "The Legacies I leave for my soule with some of the clergy, viz— To the Dominicans of Gallway 20s. To the Augustines of Galway 20s. To the Convent of Inish 20s. To the Vicar General, ffa. Michael Lynch, 20s. To ffa. Teige O'Meere 20s. To ffa. John Mullownee 30s. To ffa. Donogh Nelly 10s. To ffa. Thomas Kenny 10s. To ffa. John Nelly 10s. To ffa. Teige Mac Rory 10s. To ffa. Daniel Conegan 10s. To ffa. Thomas Grady 10s. To ffa. Breen Donnellan 10s. To ffa. Donogh Fahy 10s.
> To ffa. Daniel Broder 5s. To John Mac Glynn, lay-friar, 3s. To Thomas Burke,
> 
> 
> 
> ---
> 
> p.383
> 
> 
> 
> lay-frier, 5s. Memorandum, that I do bequeath to my son and heire, Roger O'Shaughnessy and his heirs, the £500 due unto me from my lo*rdship* Viscount of Clare."
>   
> 
> D. O'S. 
> Being present at the signing and sealing hereof,
> Ffr. JO. MOLOUNY. 
> LAWRENCE DONOVANE. 
> DER. CLORANE. 
> Proved — 8 July 1673, by his son Roger. 




41. *Roger O'Shaughnessy, Esq., the son of Sir Dermot.*— He married, in 1688, Helena, the daughter of Conor Mac Donogh O'Brien of Ballynue, by whom he had one son, Colonel William O'Shaughnessy, and one daughter, Helena, who married Theobald Butler, and was the mother of Francis, John, and Theobald Butler, living in 1784. Roger joined King James's forces, and was engaged at the battle of the Boyne, from which he returned home sick, though not wounded, and died in the castle of Gort on the 11th of July, 1690. His property was declared forfeited on the 11th of May, 1697, and King William granted all his estates, in custodiam to Gustavus, the first Baron Hamilton; but he having soon after obtained a grant of other lands, the king, by letters patent, dated 19th June, 1697, granted to Thomas (afterwards Sir Thomas) Prendergast, in consideration of his good and acceptable services (the discovery of the assassination plot, &c.), all the estate, real and personal, of Roger O'Shaughnessy, Esq., deceased, in Gort-Inchigorie, and several other lands in the barony of Kiltartan and county of Galway. By a subsequent patent, dated 20th September, 1698, reciting the foregoing grant, and also that his Majesty was informed that the estates were then annually worth five hundred pounds, but that they had since proved very deficient of that sum; and it being the real intention that five hundred pounds a year should have been granted, several other lands of the clear yearly value of £334 )s. 2 1/2d., situate in the several counties of Tipperary, Galway, Roscommon, and Westmeath, were granted accordingly.— Rot. Pat. 10 William III.


42. *Colonel William O'Shaughnessy.*— He died in exile in France in 1744, without issue.


41. *Cormac, or Charles O'Shaughnessy, the second son of Sir Dermot.*— The Editor has not been able to discover the name of his wife, but it appears from De Burgo's Hibernia Dominicana, p. 505, and a pedigree compiled by Peter Connell in 1784, for a Cornet Butler, that he had three sons, namely, Colman O'Shaughnessy, Titular Bishop of Ossory; Robuck, or Robert O'Shaughnessy, Esq., and Joseph, who had a daughter Mary, the mother of a Cornet Butler, who was living in 1784. He had also a daughter Mary, who, according to Peter Connell, became the wife of Mortogh Cam MacMahon, Esq.



---

p.384



After the death of his cousin german, Colonel William O'Shaughnessy, in France, in 1744, Bishop Colman instituted proceedings at law against Sir Thomas Prendergast, the son of the patentee, for the recovery of the estate of Gort, and these proceedings were continued after his decease in September"1748, by his brother Robuck O'Shaughnessy, Esq. and after his death by his (Robuck's) son, Joseph O'Shaughnessy, Esq. living in the time of De Burgo, 1762, who has the following curious notice of this family:

> 
> ‘F. Colmanus O'Shaughnessy, S. Theologiae Magister, Alumnus Athenriensis Caenobii, oriundus e praeclarissima Familia de Gort, in Galviensi Agro Conaciae, cujus Nobilitatem, Antiquitatem, et Integritatem, qui non novit, Hiberniam non novit. Lovanii in Ordinem Fratrum Praedicatorum ex Officiali Militari Cooptatus, ibidem Studia confecit, atque docere incepit Anno 1706. Missionibus Apostolicis Hiberniae maturus, eoque profectus, laudabiliter se gessit, Sermone, et peculiari Morum Candore, in plurimis Conaciae Regionibus, ingenti cum Animarum Fructu praedicans. Die 30 Aprilis 1726 in Comitiis Dublinii celebratis electus fuit Provincialis in locum Stephani nostri Mac-Egan, Episcopi tunc Clonmacnoisensis, nuperrime laudati Anno 1736 a Clemente XII., Pontifice Maximo, renunciatus fuit. Episcopus Ossoriensis, vulgo Ossory, in Lagenia, sub Metropoli Dubliniensi atque Dublinii in Monialium nostrarum Aedibus Sacris consecratus a D. Joanne Linegar, ejusdem Urbis Archipraesule, assistentibus F. Stephano Mac-Egan, mox laudato, Midensi, et F. Michael Mac-Donogh Kilmorensi Episcopis, ex ordine nostro, ut ex nuper dictis liquet, assumptis. Anno 1744 defuncto Patruele suo, Tribuno Gulielmo O'Shaghnussy, in Galliarum Partibus, quo pater ipsius Rogerius Regem Jacobum secutus fuerat Anno 1691, eam ob Causam Castro suo Allodiali Gortensi, amplissimisque circumjacentibus Praediis, ultra Summam bis Mille, et quinquies centum Librarum Sterlingarum, id est, decies Mille Scutorum Romanorum, annuatim valentibus, privatus a Principe Arausicano, nuncupato Gulielmo III., qui eadem concessit Equiti Thomae Prendergast, durante duntaxat Vita laudatorum Rogerii, et Gulielmi O-Shaghnussy; isto, inquam, Gulielmo defuncto, Colmanus noster O-Shaghnessy, etsi jam Episcopus, Litem inchoavit, qua Familiae suae Primipilus, Dublinii, in Curia Communium Placitorum, contra tunc, et adhuc existentem Equitem Thomam pariter Prendergast, primo dicti filium, ad Bona illa haereditaria recuperanda; atque Praesule nostro e vivis sublato, in jure successit Germanus ipsius Frater, Robocus O-Shaghnussy, Armiger, hujusque nunc succedit Filius Josephus O-Shaghnussy, Armiger. Eques autem Thomas Prendergast acriter se defendit, non quidem Justitia Causae suae, sed Pecunia, et Potentia, unus quippe est e Senatoribus Regni in Parlamento sedens, insuperque Regi a Sanctioribus Consiliis, ad Differentiam Domini O'Shaghnussy, qui Fidei Catholicae est Cultor, suisque haereditariis Bonis exutus.’— pp. 505, 506.
> 
> 
> 






---

p.385


42. *Roebuck, or Robert, son of Charles O'Shaughnessy.*— He had two sons, Joseph, who died in 1783, and William, and four daughters, Mary, Catherine, Ellice, and Eleanor, who were living in 1784, when Peter Connell wrote the pedigree for a Cornet Butler. Tradition states that this Joseph O'Shaughnessy, assisted by his relatives, the gentry of the county of Galway, took forcible possession of the mansion house of Gort, on which occasion they caused the bells of Athenry and Galway to be rung for joy. But O'Shaughnessy was finally defeated.


In Howard's Treatise on the Rules and Practice of the Equity side of the Exchequer in Ireland, second edition, Appendix, p. 903, the case of Smyth against O'Shaughnessy is mentioned as one of great importance. Howard says:

> 
> ‘In the case of Smyth, guardian of Prendergast and others, against O'Shaghnessy and others, in the court of Chancery here, in October, 1760, on a petition to the lords commissioners (the Lord Chancellor being then in England) on a possessory bill and affidavits, an injunction was granted to the sheriff to restore the plaintiff, as devisee of the estate in question, to the possession of the mansion-house, out of which, it had been sworn, he had been forced by the defendant O'Shaghnessy, who claimed under some old dormant title, not as heir at law; and an injunction was also granted to the party, as to the demesne, unless cause should be shewn to the contrary, in the time prescribed by the order; afterwards, in Michaelmas term following, the defendant came to shew cause against the injunction to the party, and to set aside the injunction to the sheriff upon a notice for that purpose; but as to the first point, the court disallowed the cause; and as to the second point, the court refused to set aside the injunction, for that it is an order of course, and usually granted at the first instance, as the party turned out of his place of residence, and may not have a place to go to; and on these motions the following points were determined:’
>   
> 
> ‘That the defendant should not read any affidavits to contradict the facts in the plaintiff's affidavits, or shew any other cause than appeared on the face of the plaintiff's affidavits,’ &c. &c.
> 
> 
> 




On this occasion it is said that the Lord Chancellor, Mansfield, lent Sir Thomas Prendergast Smyth eight thousand pounds to sustain him against O'Shaughnessy, which sum was charged on the Gort estate, and which has since been paid to the heirs of Lord Mansfield.


When Joseph O'Shaughnessy had taken forcible possession of the mansion-house of Gort, the whole tribe of the O'Shaughnessys believed that he had defeated Prendergast in the law suit, and a very curious song of exultation was composed on the occasion by a poor man of the family, named James O'Shaughnessy, the first quatrain of which runs as follows:



---

p.386



> 1. 1] Guais na gábhaidh nár fhághair-se, a bhile gan locht,
>   
> 2] O bhuaidh tú an bháire, is feárrde an chine tá bocht,
>   
> 3] Beidh luadh ag dáimh, a's trácht ag ollamhnaibh ort,
>   
> 4] 'S ó uaislibh Fáil gheabhair bárr clú féile 'sa n-Gort.
> 2. 1] Mayest thou meet neither peril nor danger, O hero without fault,
>   
> 2] As thou hast won the goal, the tribe that is poor will be the better of it,
>   
> 3] The poets shall spread thy fame, and the ollaves shall speak of thee,
>   
> 4] And from the nobles of Inisfail thou wilt receive at Gort the palm for hospitality.
> 




This Joseph, the last claimant of the Gort estate, died without issue in 1783, and there is no one now living that has yet traced his pedigree with certainty to the first Sir Dermot, who was knighted by Henry VIII.; some think that his race is totally extinct in the male line; but Captain Tyrrell of Kinvara has attempted to show that Mr. Bartholomew O'Shaughnessy of Galway is now the head of the name.


Captain Edward Tyrrell has compiled a pedigree of the O'Shaughnessys, from old documents which he had from Martin Colman O'Shaughnessy of Galway, in which he states that Colman, Titular Bishop of Ossory, already mentioned, but whom he incorrectly styles Lord Abbot of Cong, had several brothers; namely, Charles, Darby, ancestor of the O'Shaughnessys of the bounty of Limerick, where he settled, and Roger, ancestor of Dean O'Shaughnessy of Ennis, and of Dr. William O'Shaughnessy of Calcutta, F. R. S. Although this pedigree is, in the early part, full of errors in dates and genealogical facts, still there appears to be much truth contained in it for the last five generations, and the Editor is tempted to give that portion of it in this place, as containing the researches of a very intelligent old gentleman who was born in O'Shaughnessy's country, and who is now nearly a century old. He is, however, entirely wrong in making Dr. Colman the son of Sir Roger II. O'Shaughnessy, for we know from his contemporary De Burgo, already quoted, that he was the cousin german of Colonel William O'Shaughnessy (son of Roger, son of Sir Dermot III.), who died in France in 1744; that is, he was the eldest son of Cormac, or Charles, the second son of Sir Dermot, mentioned in the Will of 1671.


The Editor is of opinion that all the descendants of Sir Roger II. O'Shaughnessy are extinct in the male line, and that the O'Shaughnessys of Galway, Limerick, and Clare are descended from Lieut.-Colonel William O'Shaughnessy, who was made free of the corporation of Galway in 1648, and who was the third son of Sir Dermot II. This William had four sons, namely, William, Edmond, Dermot, and Ruaidhri, or Roger; and it is highly probable, though not yet proved, that his son Dermot is the ancestor of the O'Shaughnessys of the county of Limerick, and Ruaidhri, or Roger, the ancestor of
the O'Shaughnessys of the county of Clare.




---

p.387


Pedigree of the O'Shaughnessys over five generations




---

p.388


### Pedigree of Mr. Bartholomew O'Shaughnessy of Galway, as compiled by Captain Tyrrell of Kinvara


According to this pedigree, which is beautifully drawn out on vellum (and in the possession of Dr. Terence O'Shaughnessy, R. C. Dean of Killaloe, who resides at Ennis, in the county of Clare), Colman O'Shaughnessy, Abbot of Cong, was the son of Sir Roger II.; but this is not true, for we learn from Dr. Colman's cotemporary, De Burgo, and from Peter Connell of Kilrush, who drew up a pedigree of O'Shaughnessy for a Cornet Butler, in 1784, that this Colman was the cousin-german of Colonel William O'Shaughnessy, who died in France in 1744, without issue. Captain Tyrrell writes that this Colman had five brothers, namely, Joseph, the head of the family, Charles, Darby, Roger, and James, the two last being twin brothers; but Captain Tyrrell is here totally mistaken, as we learn from De Burgo that on the death of Colonel William O'Shaughnessy in France, in 1744, Bishop Colman became the head of the O'Shaughnessys, and went to law with Sir Thomas Prendergast for the family estates, and that on the death of Colman, in 1749, his next brother, Roebuck, renewed the suit, as being the next senior representative of the family; and that after his death Joseph, his son, carried it on, and that it remained undecided in his (De Burgo's) time. Peter Connell also, who was born about the year 1740, and who knew all about this law suit between the O'Shaughnessys and Sir Thomas Prendergast, gives Colman but two brothers, namely, Robert (i. e. the Roebuck of De Burgo) and Joseph. From the total omission of Roebuck in Captain Tyrrell's pedigree of the O'Shaughnessys, it is quite clear that he has committed some mistake in enumerating the brothers of Dr. Colman O'Shaughnessy, as well as in making him the son of Sir Roger II.; and although he states that he drew this pedigree from the O'Shaughnessy papers, some of which are still, as he says, in his possession, we cannot receive his compilation as correct while in opposition to the registered records of the country, and to printed books of the highest authority. We must, however, receive this gentleman's testimony as far as it regards those genealogical facts which have come under his own immediate cognizance; and as he is now nearly a century old he must have heard and seen much of this family. The Editor, therefore, feels it his duty to lay before the reader that part of Captain Tyrrell's pedigree of the O'Shaughnessys which may be true in itself, though engrafted on a false stem.


2. *Charles O'Shaughnessy.*— He was the brother of Colman, Abbot of Cong. His other brothers were, 1, Joseph, the head of the Gort family [?]; 2, Darby, who settled in the county of Limerick and had numerous issue, whose descendants are still in that county; and, 3, Roger, who settled in the county of Clare, and is the ancestor



---

p.389



of all the O'Shaughnessys of that county; and, 4, James, of whose descendants no account is preserved. This Charles married Anne, daughter of Major Walcott of Duross, in the county of Galway, and had issue by her three sons, namely, 1, Charles, of whom presently; 2, Roger, who lived at Russane, which he sold to Oliver Martin, Esq., and died without issue male; and, 3, Darby, who married Elizabeth, daughter of Thomas Taylor, Esq., of Dungorey, and died s. p. aged thirty-one. He had also four daughters, of whom the eldest married Burke of Meelick, and the second O'Flaherty of Connemara.


3. *Charles O'Shaughnessy, the son of Charles.*— He was born in 1660, and married Isabella French of Galway, called the Phoenix from her beauty, and had three sons, namely, 1, Darby, of whom presently; 2, John, who was born in 1692, and who resided at Kilmaine, in the county of Mayo, where he married Margery Kirwan, by whom he had issue male and female; 3, James, born in 1694, who went, it is supposed, to Jamaica, and was never heard of by any of his family. He had also six daughters, of whom the first married Michael French of Abbert; the second Geoffry Martin of Ross; the third Thomas French of Moycullen; the fourth R. Eyre; and two became nuns. He was an improvident man, and gave large portions to his daughters.


4. *Darby O'Shaughnessy, the son of Charles.*— He was born in the year 1690. He married, first, Cicily O'Brien, by whom he had two sons, William and John, and three daughters; and, secondly, Anne Gilmore of the county of Mayo, by whom he had Martin and James. He was reared for the Church by the Abbot of Cong, but was reduced to keep an academy in Dublin. He gave fifty pounds towards Joseph's suit with T. Prendergast Smyth, and was buried in the abbey of Galway, where he died. His son William, who was born in 1724, married Honor Lynch, by whom he had no male issue. He had three daughters. This William was barrack-master of Headford, and died at Galway *[in 1781]*, aged fifty-seven. Thus ends the male line in the second branch in the fourth generation from Roger. His second son John, who was born in 1728, married Mary Bodkin, and died in 1779, leaving one daughter. His son James died unmarried.


5. *Martin Colman O'Shaughnessy, the third son of Darby.*— He was born in 1747, and married Mary Mac Donough, by whom he had two sons, Bartholomew and Andrew. Finding little property descend to him, it having gone to the female line, he thought a trade better than be a burden on his friends, or the many relations he might boast of, and was bound to a wig-maker. He died in 1829, aged 82. Thus ends the grandeur of this ancient family!


6. *Bartholomew O' Shaughnessy, son of Martin Colman.*— He was born in the year 1789. He married Deborah Morris of Spiddle, by whom he got £900 fortune. He 



---

p.390



has issue male and female, as has also his brother Andrew, who was born in the year 1796.


Captain Tyrrell, in a letter to the Editor, dated September 15th, 1843, writes the following account of the manner in which he obtained the evidences for compiling this pedigree:
  


> 
> ‘In respect to the Galway barber, it is rather a long story, yet I will strive to get through it as distinctly as I can, for he is certainly the elder branch of that once great and ancient family, now totally gone to decay. About thirty-five or thirty-six years ago, when I lived in Galway, I had occasion to get my razors set to rights, and went to the father of the present barber, O'Shaughnessy, also a barber, and sitting in his shop; while he was so employed, his daughter came in, opened a good sized box near where I was sitting, and took out a bundle, or rather an handful of papers, on which I saw indistinct writing. I asked what she was going to do with them. She said to kindle the fire. I asked the father of the young woman what the papers related to; he replied he did not know, nor could he learn from persons who had examined them, as time had totally obliterated them. The box, he informed me, belonged to his grand-uncle, who was Abbot of Cong. This poor barber was then near seventy years of age, and spelled the name ‘O'Shoughnessy’ on his sign board, and often said it was the ancient mode of spelling the name. In short, I purchased the box, which I have to this day, and its contents, from the poor barber, and on my going to Dublin, I waited on my friend Mr. Kirwan, the highly celebrated chemist of his day, who showed me a way to enable me to read the whole of the papers.’
> 
> 
> 




In another letter, dated Kinvara, November 30th, 1843, Captain Tyrrell writes concerning the law suit between Joseph O'Shaughnessy and Sir Thomas Prendergast:

> 
> ‘This law suit was not finally closed in my memory, as it went before the Lords and Commons of England; and I remember having seen this Mr. Joseph O'Shaughnessy and his sister often, in the years 1768, 1769, and 1770, in a state nearly allied to beggary, at Gort; from thence they removed to Dublin, and before 1775 *[recte 1783]* both were dead without issue, by which the present barber's grandfather was, without dispute, the next heir to Sir Roger O'Shaughnessy.’
> 
> 
> 




Arms.— A castle triple-towered az.
  

Supporters.— Two lions or.
  

Crest.— Over a side helmet a hand in armour holding a spear.
  

Motto.— FORTIS ET STABILIS.
  

The arms of O'Shaughnessy are given in a MS. in the British Museum, Clarendon 4815, entitled ‘Copies of Grants of Arms collected for a Peerage by Aaron Crossley.’ The crest, however, is not given in this collection, but it is added here from an impression



---

p.391



of the seal of Sir Roger O'Shaughnessy, on a letter to his daughter Gylles, the wife of Daniel O'Donovan of Castle Donovan, written in 1647.


### C

### Pedigree of O'Clery


9. *Colman, son of Cobhthach.*— This Colman was King of Connaught for twenty-one years. He married the mother of St Caimin of Inis Cealltra, and was the father of Guaire Aidhne, King of Connaught, and Lairgneun, who was also King of Connaught seven years.


10. *Guaire Aidhne.*— He was King of Connaught for thirteen years, during which period he distinguished himself so much for hospitality and bounty that he became almost the god or personification of generosity among the Irish poets, and those of modern times boasted that O'Shaughnessy was his lineal descendant Thus Muldowny O'Morrison, in an ode, addressed, in 1639, to Daniel O'Donovan of Castle Donovan, who was married to O'Shaughnessy's daughter, boasts that his wife Sheela reflected honour on the name of her illustrious ancestor Guaire; but we have already seen that the Cinel Aodha, of whom O'Shaughnessy was chief, were not of the race of Guaire; but the poet was perfectly pardonable, as he had the authority of MSS. of considerable antiquity for deducing the Pedigree of O'Shaughnessy from Guaire Aidhne, King of Connaught.— See p. 54 *55 in the CELT edition*, note *183*.


In the year 645 Guaire fought the battle of **Carn Conaill** against King Diarmaid, the son of Aodh Slaine, in which he was defeated.[1018](javascript:footNote('T105008/note1018.html')) He died in the year 662, and was buried at Clonmacnoise. According to the Book of Lecan, Guaire had three sons, namely, 1, Nar, who had a son Cobhthach, who had a son Flann, the ancestor of the family of O'Maghna, chiefs of the territory of Caenraighe, in Aidhne, and who was the senior of the race of Guaire— see p. 61, supra; 2, Artghal, the ancestor of O'Clery, O'Heyne, and Mac Gilla Kelly; and, 3, Aodh, the ancestor of the tribe called Cinel Enda. It would appear from the Annals of the Four Masters that he had another son, Ceallach, who died in the year 665.


11. *Artghal.*— He was the second son of Guaire, but our annalists or genealogists have preserved no particulars about him, except that he was the father of,


12. *Fearghal Aidhne.*— He was King of Connaught for thirteen years, and died in 694, under which year the Four Masters, in their Annals, erroneously call him the son instead of the grandson of Guaire Aidhne. He had two sons, 1, Torpa, the ancestor of O'Clery, and, 2, Flaithniadh, the father of Art, or Artghal, chief of Aidhne, who was slain, according to the Four Masters, in the year 767.




---

p.392


13. *Torpa, son of King Feargal Aidhne.*— He had two sons, Cathmogh, ancestor of the subsequent chiefs, and Aodh, from whom the celebrated poet Flann Mac Lonain
was the fourth in descent.


14. *Cathmogh, son of Torpa.*— He had two sons, 1, Tighernach, lord of Aidhne, who died, according to the Four Masters, in the year 822, and Comuscach, the ancestor of the subsequent chieftains.


15. *Comuscach, son of Cathmogh*.


16. *Ceadadhach, son of Comuscach*.


17. *Cleireach, son of Ceadadhach.*— He is the progenitor after whom the family of O'Cleirigh, or O'Clery, have taken their surname. He had two sons, Maolfabhaill, of
whom presently, and Eidhin, the progenitor of the family of O'Heyne.


18. *Maolfabhaill, son of Cleireach.*— He was lord of Aidhne, and died, according to the Annals of the Four Masters, in the year 887. He was father of Tighearnach O'Clery, lord of Aidhne, who died in 916, and of,


19. *Flann, otherwise called Maolcerarda O'Clery.*— He was slain by the men of Munster in the year 950, under which he is styled, in the Annals of the Four Masters, lord of South Connaught, and **rioghdamhna**, or heir presumptive, of all Connaught. He was father of,


20. *Comhaltan O'Clery.*— He was lord of Hy-Fiachrach Aidhne, according to the Annals of the Four Masters. This very powerful chieftain, assisted by Maelseachlainn Mac Arcdai, in the year 964, defeated the celebrated Sen Fergal O'Rourke, King of Connaught, and slew seven hundred of his people, and among the rest Taichleach O'Gara, lord of South Leyny. He died in the year 976.


21. *Giolla Cheallaigh, son of Comhaltan O'Clery.*— Comhaltan O'Clery was succeeded in the lordship of Aidhne by Muireadhach O'Clery, who was probably his son, and who died, according to the Four Masters, in the year 988, after which Giolla Cheallaigh, or Kilkelly O'Clery, succeeded to the lordship. In the year 998 he slew Diarmaid Mac Dunadhaigh, lord of Siol Anmchadha, but in 1003 he was himself slain by the celebrated Tadhg O'Kelly, chief of Hy-Many, as we are informed by the Four Masters:— 


‘A . D. 1003. A battle was fought between Tadhg O'Kelly with the Hy-Many, and the Hy-Fiachrach Aidhne with the men of West Connaught, in which were slain Giolla Cheallaigh mac Comhaltain O'Clery, lord of the Hy-Fiachrach Aidhne, Conchobhar Mac Ubbain, and Cennfaoladh Mac Ruaidhri, and many others. Finn, the son of Marcan, Tanist of Hy-Many, was also slain in the heat of the conflict.’[1019](javascript:footNote('T105008/note1019.html')) This Giolla Cheallaigh is the progenitor after whom the family of Mac Giolla Cheallaigh, Kilkelly, or Killikelly, have taken their surname, so that , that family are virtually O'Clerys. He had one son,




---

p.393


22. *Cugaela, son of Giolla Cheallaigh O'Clery.*— After the death of Giolla Cheallaigh O'Clery, in 1003, it would appear that Maolruanaidh, or Mulrony na paidre *[of the prayer]* O'Heyne succeeded to the lordship of Aidhne, for he commanded the South Hy-Fiachrach in the battle of Clontarf, A. D. 1014, in which he fell. To whom succeeded Cugaela, the grandson of Comhaltan O'Clery, who seems to have ruled the territory for a period of eleven years, for he died, according to the Four Masters, in the year 1025. According to the genealogical MS. of Peregrine O'Clery, now preserved in the Library of the Royal Irish Academy, this Cugaela O'Clery had three sons, namely, 1, Braon, the ancestor of all the septs who retained the name of O'Clery; 2, Giolla na naomh, or Sanctius, the ancestor of the family who took the name of Mac Giolla Cheallaigh, now Killikelly, a family which was very respectable in the territory of Aidhne in the reign of Queen Elizabeth, and then seated in the castle of Cloghballymore, near Kinvara — see p. 68, note r, *i. e. p. 69, note 207 in the CELT edition*; but, strange to say, the pedigree of this family is not carried down lower than the twelfth century in any Irish MS. accessible in Dublin; 3, Eidhin, the progenitor, after whom the family of the O'Heynes took their surname; but this Eidhin could not have been a son of Cugaela, who died in 1025, for his grandson Mulrony na paidre O'Heyne was chief of Aidhne, and was slain in the battle of Clontarf in 1014; and we must therefore agree with **Duald Mac Firbis**, who makes this Eidhin the son of Cleireach, No. 17 in the Genealogical Table.


23. *Braon, son of Cugaela O'Clery.*— He was slain, in the year 1033, as we learn from the Annals of the Four Masters at that year. — ‘A. D. 1033. A battle was fought between the men of Eile and the Hy-Fiachrach Aidhne, in which fell Braon O'Clery and Muireadhach, the son of Giolla Padraig, and many others.’


24. *Eoghan, son of Braon O'Clery.*— In the time of this Eoghan the family of O'Heyne became chiefs of Aidhne, but it does not appear that any member of the family who retained the name O'Clery ever after obtained chief sway in the territory; and they were finally driven out by the Burkes. From this Eoghan, who must have died about the year 1063, we are presented with the following generations, of which no dates or other particulars are preserved in the Irish annals.


25. *Domhnall O'Clery.*
  

26. *Giolla na naomh O'Clery.*
  

27. *Tighernach O'Clery.*
  

28. *Muireadhach O'Clery.*
  

29. *Tadhg O'Clery.*
  

30. *Giolla Iosa O'Clery.*
  

31. *Domhnall O'Clery.*




---

p.394


By allowing thirty years to each of these generations we will find that this Domhnall may have flourished towards the close of the thirteenth century, and this seems to have been the period at which the O'Clerys were driven out of the territory of Aidhne by the Burkes. He had four sons, namely; 1, John Sgiamhach, i. e. the comely, the ancestor of the O'Clerys of Tirconnell; 2, Daniel, from whom are descended the O'Clerys of Tirawley; 3, Thomas, from whom are the O'Clerys of Briefny O'Reilly; and, 4, Cormac, from whom are the O'Clerys of Kilkenny— See Genealogical Table.


32. *John Sgiamhach (i. e. the Comely) O'Clery,* fl. circ. 1303.


33. *Diarmaid O'Clery,* fl. circ. 1333.


34. *Cormac O'Clery.*— He was the first of the family who removed to Tirconnell, which he did shortly after the year 1382, when Toirdhealbhach an fhiona O'Donnell was chief of Tirconnell. He married the only daughter and heiress of Matthew O'Sgingin, who was at the time chief historian to O'Donnell, and had by her, 


35. *Giolla Brighde O'Clery.*— He was so called after his maternal uncle, Giolla Brighde O'Sgingin, who had died in 1382, a short time before the birth of O'Clery. This Giolla Brighde O'Clery was educated in the profession of his maternal grandfather, whom he succeeded in the capacity of historical ollav or chief historian to O'Donnell. He had one son, who succeeded him, viz.


36. *Giolla riabhach O'Clery.*— The Four Masters have the following notice of his death:— ‘A. D. 1421. Giolla riabhach O'Clery, a learned historian, died after having
spent a life of virtue.’ There must be some error, however, in this date, for his father, Giolla Brighde, having been born after 1382, was only 39 years old in 1421, when the death of his son is mentioned as that of a learned historian! The truth would appear to be that Giolla riabhach is here a mistake for Giolla Brighde.


37. *Diarmaid of the three Schools, the son of Giolla riabhach.*— The year of the death of this Diarmaid, strange to say, is not recorded by his descendants, the Four Masters, in their Annals.


38. *Tadhg, or Teige Cam O'Clery.*— His death is thus recorded in the Annals of the Four Masters at the year 1492: — ‘A. D. 1492. O'Clery (Tadhg Cam), ollav to O'Donnell in science, poetry, and history, a man who had maintained a house of universal hospitality, for the mighty and the needy, died, after having subdued the world and the devil.’ This Tadhg Cam had three sons, 1, Diarmaid, of whom presently; 2, Tuathal, who died in 1512, and who was the great grandfather of Michael O'Clery and Conary O'Clery, two of the Four Masters, and of Bernardinus O'Clery, the superior of the convent of Donegal in 1632 and 1636; 3, Giolla riabhach, chief of this
family, who died in 1527.


39. *Diarmaid, son of Tadhg Cam O'Clery.*— He had four sons, namely, Cucoigcriche, or



---

p.395



or Peregrine, Giolla Bhrighde, Cormac, a friar of the order of St. Francis, and Muirgheas.


40. *Cucoigcriche, or Peregrine O'Clery.*— He was living in the year 1546, as we learn from a passage in the Annals of the Four Masters under that year. He had six sons, namely, 1, Maccon, of whom presently; 2, Cosnamhach; 3, Dubhthach;
4, Tadhg; 5, Cormac; and, 6, Maurice Ballach, who was hanged in the year 1572 by the Earl of Thomond, who wished to exterminate the Irish poets.


41. *Maccon, son of Cucoigcriche O'Clery.*— He was the chief of the Tirconnell, or literary sept of the O'Clerys, and died in the year 1595, under which year the Four Masters have preserved the following record of him:— ‘A. D. 1595. Maccon, son of Cucoigcriche, son of Diarmaid, son of Tadhg Cam O'Clery, chief historian to O'Donnell, died at Leitir Maolain, in Thomond *[now Lettermoylan, in the parish of Dysart O'Dea, in the barony of Inchiquin]*. He was a learned and erudite man, profoundly versed in history and poetry, fluent, eloquent, and gifted with the harmony and splendour of oratory, and withal, pious, devout, religious, and charitable.’ He had five
sons, namely, 1, Lughaidh of the Contention of the Bards, of whom presently; 2, Giolla Brighde; 3, Maccon Meirgeach; 4, Cucoigcriche; and, 5, Duibhgeann, who was slain at Clare in the year 1600.


42. *Lughaidh, or Lewy O'Clery, son of Maccon O'Clery.*— He was the head of the Tirconnell branch of the O'Clerys, and was in possession of all his lands in the year 1609, when he was selected as one of the ‘good and lawful’ men of the county of Donegal, appointed to inquire into the King's title to the several escheated and forfeited lands in Ulster. He was the principal disputant on the part of the northern bards in the contest with Teige Mac Dary *[Tadhg Mac Dáire]* and those of the south of Ireland, respecting the claims of the rival dynasties of the northern and southern divisions of Ireland to supremacy and renown, and his poems written during this controversy are very curious, as preserving many historical facts, and for the purity and correctness of their diction. The year of his death is not recorded by the Four Masters, and the probability is that he lived to a later period than that to which their Annals extended, for they have no entry later than the year 1616. He had two sons, Cucoigcriche, or Peregrine, of whom presently, and Cairbre.


43. *Cucoigcriche, or Peregrine O'Clery, the eldest son of Lughaidh.*— He married one of the Mac Sweenys of the county of Donegal, by whom he had two sons, Diarmaid and John. It appears from an inquisition taken at Lifford on the 25th of May, 1632, that he held the half quarter of the lands of Coobeg and Doughill, in the proportion of Monargane, in the barony of Boylagh and Bannagh, in the county of Donegal, from Hollantide, 1631, until May, 1632, for which he paid eight pounds sterling per annum



---

p.396



to William Farrell, Esq., assignee to the Earl of Annandale, but, as the document states, being ‘a meere Irishman, and not of English, or British discent or sirname,’ he was dispossessed, and the lands became forfeited to the king. Shortly after this period he removed, with many other families of Tirconnell, to Ballycroy, in the south of the barony of Erris, in the county of Mayo, under the guidance of Rory or Roger O'Donnell, the son of Colonel Manus, who was slain at Benburb in 1646, and the ancestor of the present Sir Richard Annesley O'Donnell of Newport. He carried with him his books, which were his chief treasure, which he bequeathed to his two sons, Diarmaid and John, as we learn from his autograph Will, which was written in Irish at Curr-na-heillte, near Burrishoole, and which is extant, in rather bad preservation, in his genealogical MS. now in the Library of the Royal Irish Academy. In this Will, which was made shortly before his death in 1664, he writes:— ‘I bequeath the property most dear to me that ever I possessed in this world, namely, my books, to my two sons Diarmaid and John. Let them copy from them, without injuring them, whatever may be necessary for their purpose, and let them be equally seen and used by the children of my brother Cairbre as by themselves; and let them instruct them according to the   
[*...*]  
 And I request
the children of Cairbre to teach and instruct their children.’ The injunctions here solemnly laid by him on his posterity were faithfully fulfilled, and a knowledge of the Irish language, as well as his own honesty of character, has been transmitted in the family to the present day.


44. *Diarmaid, son of Cucoigcriche, or Peregrine O'Clery.*— No memorial of him remains in the MSS. except that he was the son of Peregrine and the father of,


45. *Cairbre O'Clery.*— He married, about the year 1692, —— Maguire of Arney Bridge, in the county of Fermanagh, by whom he had two sons, namely, Cosnamhach, or Cosney, and Philip, who died without issue male, and one daughter Alice. He removed
with his children to the parish of Drung, in the county of Cavan, and was interred in the churchyard of Drung.


46. *Cosnamhach, or Cosney O'Clery, son of Cairbre.*— He was born in the year 1693 at the foot of Nephin mountain, in the county of Mayo. He removed from thence to a place called Knockbinish, in the county of Leitrim, whence he removed accompanied by his father, to the parish of Drung, in the county of Cavan, where he married Mable, daughter of Donnell Ultagh *[Donlevy]*, by whom he had one son, Patrick, and four daughters. He died in the year 1759, in the sixty-sixth year of his age, and was buried in the churchyard of Drung.


47. *Patrick, son of Cosnamhach O'Clery.*— He was born in the year 1738, and in 1759 he married Anne, daughter of Bernard O'Gowan, or Smith, of Lara, in the county of Cavan, and had by her twelve children, six sons and six daughters. He died



---

p.397



in the year 1816, aged seventy-eight years, and was interred in the churchyard of Drung.


48. *John, eldest son of Patrick O'Clery,* now living. He was born in the year 1778, and in 1812 married Alice, daughter of Patrick Smith of Ashfield, in the county of Cavan, and had by her five children, of whom only two are now living, namely, John and Anne.


This John, No. 48, removed to the city of Dublin in 1817, where he still lives, like his ancestors, a strictly honest and worthy man, and a good Irish scribe and scholar. His son, John O'Clery, Jun., has written the following remarks on the
family manuscripts, in a letter to the Editor, dated 37, Nassau-street, 12th February,
1842, which should not be omitted here:

> 
> ‘Cucogry left his books to his sons Dermod and Shane. Cairbre, son of Dermod, had them in his possession, and left them to his son Cosnamha, who left them to his son Patrick, through whom they came into the possession of his son John, my father. By an accidental fire, which occurred in the house of my grandfather, a great part of Cucogry's manuscripts was materially injured. The only ones which escaped damage were the following:— The Book of Pedigrees, the Book of Invasions, the Life of Red Hugh O'Donnell, the Amhra Choluim Chille, and Triallam timcheall na Fodhla, which were brought to Dublin by my father in 1817. He lent these books to the late Mr. Edward O'Reilly, *but did not bargain for or sell them to him.* He never got them back, however, as he did not know of Mr. O'Reilly's illness until he heard of his death, and saw that he had included these very books in his catalogue, except the Life of Hugh Roe, which, it appears, he had disposed of to Mr. Monck Mason, who resided at that time in Harcourt-street, and this he had done without letting my father know any thing about it. My father, on hearing of his books being thus advertised for sale, made an affidavit that he merely lent, but did not sell them to Mr. O'Reilly. Notwithstanding this, however, his executor, the Rev. Eugene O'Reilly of Navan proceeded with the sale of them, and it was under these circumstances that they came by purchase, at O'Reilly's auction, into the possession of the Royal Irish Academy. But although they could not perhaps be placed in better hands, or any where that they would be taken better care of, as far as their preservation is concerned, yet by all the laws of strict justice, they are as much my father's property, even at this moment, as if the Royal Irish Academy had never paid one farthing for them. Little did Cucogry think that these very books, on which he set so high a value, as is seen by his own Will, would ever, by such means, pass out of the hands of his descendants. My father has still a copy, which he made himself, of the Book of Pedigrees, and he has also some of the very books which belonged to Cucogry.’
> 
> 
> 






---

p.398


Mr. Martin Clery of Ballycroy, in the county of Mayo, also descends from this Cucogry, or Peregrine, who died in 1664, and Mrs. Conway of Doonah castle, in Ballycroy, descends from his brother; but they are unable to add dates to the different generations, having retained no manuscript memoranda.


It does not appear that this family had ever obtained any grant of arms from the Irish College of Heralds, and the Editor has not been able to find that they ever used any armorial bearings in ancient Irish times.


### D

### Pedigree of O'Heyne


18. *Eidhin, the son of Cleireach.* — We have already seen in the pedigree of O'Clery, No. 22, that **Peregrine O'Clery** errs in making this Eidhin the son of Cugaela, chief of Aidhne, who died in 1025, and we must therefore follow the authority of **Duald Mac Firbis** and of the O'Mulconrys in the Leabhar Irse, who make him the second son of Cleireach, the ancestor of the family of O'Clery. He had one son, Flann, of whom presently, and one daughter, Mor, the first wife of the monarch Brian Borumha, and the mother of his sons Murchadh, Conchobhar, and Flann, who were slain in the battle of Clontarf.


19. *Flann,* of whom we know nothing, except that from the pedigrees and the
Irish annals we must come to the conclusion that he had two sons, namely, 1, Maolruanaidh na Paidre (or Mulrony of the Prayer) O'Heyne, chief of Aidhne, who was slain in the battle of Clontarf in the year 1014, of whose issue, if he left any, no account is preserved; and, 2, Maolfabhaill, or Mulfavill O'Heyne, by whom the line was continued.


20. *Maolfabhaill, son of Flann O'Heyne.* — He became chief of the Hy-Fiachrach Aidhne, or South Hy-Fiachrach, probably after the death of Cugaela O'Clery, in the
year 1025, and if so, he was chief for twenty-three years, for his death is recorded in the Annals of the Four Masters at the year 1048. — ‘A. D. 1048. Maolfabhaill O'Heyne, lord of Hy-Fiachrach Aidhne, died.’


21. *Cugaela, son of Maolfabhaill.* — No notice of him is preserved in the Irish annals unless he be the O'Heyne, lord of the Hy-Fiachrach Aidhne, mentioned in the Annals of the Four Masters as having slain Domhnall Ruadh O'Brien in the year 1055, which he probably was.


22. *Giolla na naomh, surnamed of the Plunder, son of Cugaela O'Heyne.*


23. *Flann, son of Giolla na naomh O'Heyne.*


24. *Conchobhar, or Conor, son of Flann O'Heyne.*




---

p.399


25. *Aodh, or Hugh, son of Conchobhar O'Heyne.*— He was probably the Aodh O'Heyne, lord of Hy-Fiachrach Aidhne, mentioned by the Four Masters at the year 1121, as haying been slain in Munster, whither he had gone on a predatory excursion with Turlogh O'Conor, who was then King of Connaught, and presumptive monarch of Ireland.


26. *Giolla Cheallaigh, or Gillikelly, son of Aodh O'Heyne.*— He had two sons, Aodh and Giolla na naomh, and was slain, according to the Annals of the Four Masters, in the year 1153, together with his son Aodh.


27. *Giolla na naomh, son of Giolla Cheallaigh.*— The Irish annals have preserved no memorial of this Giolla na naomh. In his time Roderic O'Conor, monarch of Ireland, was resident in the O'Heyne territory. At the year 1180 the Four Masters mention the death of a Maurice O'Heyne, lord of Hy-Fiachrach Aidhne, and at 1187, the death of Duvesa, daughter of O'Heyne, and wife of Conor Mac Dermot, lord of Moylurg, but nothing remains to show how this Maurice, or Duvesa, stood related to the Giolla na naomh in question; but it is highly probable that the one was the son and the other the daughter of his brother Aodh, who was slain in 1153.


28. *Eoghan, or Owen, son of Giolla na naomh O'Heyne.*—At the year 1201 the Four Masters enter the death of Conchobhar, or Conor O'Heyne, the son of Maurice; at 1211 that of Cugaola O'Heyne, and at 1212 they have the following entry:— ‘A. D. 1212. Donnchadh O'Heyne had his eyes put out by Aodh, the son of Cathal Croibhdhearg O'Conor, without the permission of O'Conor himself.’ These were evidently the grandsons of Aodh, or Hugh O'Heyne, who was slain in 1153, and whose race was now laid aside, when Donnchadh was deprived of his eyes and rendered unfit for the chieftainship. After this Eoghan, the son of Giolla na naomh O'Heyne, became chief of the Hy-Fiachrach Aidhne, and one of the most conspicuous chieftains that ever ruled that territory. In the year 1225 he was one of the chiefs of Connaught who joined the sons of King Roderic O'Conor against Hugh, the son of Charles the Red-handed O'Conor, King of Connaught, who was assisted by the English; on which occasion Hugh O'Conor despatched his brother Felim and others of the chiefs of his people, and a large body of English soldiers, into Hy-Fiachrach Aidhne to plunder Eoghan O'Heyne, and they encamped one night at Ardrahin, for the purpose of plundering the country early the next morning; but when O'Flaherty of Iar-Connaught, and the other enemies of Hugh O'Conor, had heard that the English were here stationed with the intention of plundering Eoghan O'Heyne, they did not neglect their friend, but marched, as the Four Masters state, ‘with one mind and one accord,’ until they came to a place near Ardrahin, where they halted, and having held a consultation, they came to the resolution of of sending Tuathal, the son of Muircheartach, and Taithleach



---

p.400



O'Dowd, with a strong force, to Ardrahin, while O'Flaherty and the son of Muircheartach O'Conor were to remain with their forces outside. The two O'Dowds, with their soldiers, marched courageously and boldly into the town of Ardrahin, and made a vigorous and desperate attack upon the English, whom they put to flight east and west. The party who fled eastwards were pursued by the O'Dowds, and the constable, or captain of the English received two wounds, one from the javelin of Tuathal O'Dowd and the other from that of Taithleach, which left him lifeless; but the party who fled westwards met O'Flaherty and the son of Muircheartach O'Conor, and routed them to their misfortune. After this the sons of Roderic and their supporters made peace with Hugh O'Conor and his friends, which the annalists remark was an unseasonable peace, as there was no church or territory in Connaught at the time that had not been plundered or laid waste!


In ten years after this we find this Eoghan on the warmest terms of friendship with the English. In the year 1235 he joined Richard, the son of William Burke, in his famous expedition into Connaught, on which occasion he rendered the English great services both by his deeds and counsel, as will appear from the following simple narrative, extracted by the Four Masters from the older annals:
  


‘A. D. 1235. Richard, the son of William Burke, assembled the English of Ireland, the most illustrious of whom were the following, viz.—Fitz-Maurice, Lord Deputy of Ireland; Hugo De Lacy, Earl of Ulster; Walter Rittabard *[Riddlesford]*, Chief Baron of Leinster, who commanded the English of Leinster; and the Lord John Cogan, with the English of Munster, together with all the Roothes of Ireland. They crossed the ford of Athlone, and set fire to the town; then going to Elphin they burned the great church there, and proceeded from thence to the monastery of Ath Dalaarg *[Boyle]*, on the River Boyle, on the eve of Trinity Sunday. Parties of their soldiers entered the monastery, broke into the sacristy, and carried away chalices, vestments, and other treasures. But the English nobles were highly incensed at this conduct *[of the soldiery]*, and sent back as many of those articles as they found, and made restitution for such as they could not find. On the next day they sent forth parties to Creit, to Cairthe Muilchenn *[now Glencar]*, and to the tower of Glenfarne, marauding, who carried off great spoils from those places to the Lord Deputy's camp at Ardcarne. Here the English held a private consultation at the request of Eoghan O'Heyne (who wished to be revenged on the Momonians, and particularly Donnchadh Cairbreach O'Brien), and determined on returning back through Hy-Many and Moinmoy, and passing thence into Thomond, without giving the Momonians any notice of their intentions. This they accordingly did, and committed great depredations. When Felim, the son of Cathal Croibhdhearg O'Conor, saw that the English had passed out of his territories,



---

p.401



he held a council, and it was resolved that he should march with his troops in aid of the Momonians. On their arrival in Munster they had daily skirmishes with the English. At length a pitched battle took place, in which the united forces of the Connacians and Momonians fought bravely against the English, but the English troops, consisting of infantry and cavalry, who were all clad in armour, at length vanquished them, and killed numbers both of the Connacians and Momonians, but especially of the latter, in consequence of the imprudence of Donnchadh Cairbreach O'Brien. The Connacians then returned home, and on the day following O'Brien made peace with the English and gave them hostages. The English then returned to Connaught, and went first to Aodh O'Flaherty, who made peace with them rather than that they should plunder his people and carry off his cattle.’


‘Felim, the son of Cathal Croibhdhearg, finding himself beset with dangers, then resolved on taking with him to O'Donnell *[Domhnall Mor]* all the cows belonging to those who should be willing to take his advice in the territories of Conmaicne Mara and Conmaicne Cuile, together with the son of Maghnus and Conchobhar Ruadh, the son of Muircheartach Muimhneach O'Conor, and leaving the whole country desolate to the English. The English, on discovering what he had done, advanced to Dun-Mugdord, whence they despatched messengers to Maghnus, the son of Muircheartach Muimhneach, to demand hostages from him, but Maghnus refused to give them either peace or hostages. The English then sent forth from Dun Mugdord a numerous army against the sons of Roderic O'Conor, which plundered Achill and carried great spoils to Druimni. In the mean time Aodh O'Flaherty and Eoghan O'Heyne came round with their numerous forces, who carried boats with them as far as Lionan Cinn mhara *[now Leenaun]*, and thence to Druimni, to meet the Lord Deputy at the Callow of Inis Aonaigh *[Inisheany]*. Maghnus at this time was with his ships on the water close to the island, where he and the English had frequent engagements. But the English gave him rest for awhile: they repaired to their camp, where they found the boats which had been carried round by O'Flaherty and O'Heyne[1020](javascript:footNote('T105008/note1020.html')), and carried



---

p.402



them to a large strand near the place where Maghnus was. When Maghnus had perceived the boats, he landed on Inis Raithin, and sent a party of his people to the island of Inis Aonaigh. But when the English perceived Maghnus and his people landing on these islands, they launched their boats, and troops of well-armed mail-clad soldiers, and landing on the island on which Maghnus's people were, and also upon Inis Raithin, on which Maghnus himself was, they killed all the people they found on them. Maghnus and those who were with him on Inis Raithin went into their ships and fled from the island; but had Maghnus been on friendly terms with the O'Malleys they would have sent their fleet against that of the English. There was not a cow upon one of the Insi Modha islands *[the islands of Clew Bay]* which the English did not carry off to the main land in one day, and those from whom they had been taken would have been obliged to come off their islands in consequence of thirst and hunger had they not been taken prisoners.’


‘Many of the common people were put to death on that night by the English, who, on the next day, being Friday, landed on the islands north of Umhall, and the chiefs of the army issued orders that no people should be put to death on that day in honour of the crucifixion of Christ. After they had plundered and devastated Umhall, both by sea and land, they marched on with their spoils to Luffertane, thence they advanced to Ballysadare, where they plundered O'Donnell for having afforded refuge to Felim O'Conor after his expulsion. From thence they moved to the Curlieus and to Caladh Puirt na Cairge, on Lough Key, to attack a party of the people of Felim O'Conor, who were defending that place. On this occasion the English of Ireland and the Lord Deputy spared and protected Clarus Mac Mailin, herenach of Elphin, and the canons of the island of the Blessed Trinity, and the Lord Deputy himself and the chiefs of the English went to see that place, and to kneel and pray there. The English afterwards, with great art and ingenuity, constructed wonderful engines by means of which they took the fortress called the Rock of Lough Key from the people of Felim and Cormac Mac Dermot, and the Lord Deputy left guards in it with plenty of provisions and beer. On this expedition the English left the Connacians bereft of food, raiment, and cattle, and the country of peace and tranquillity; the Irish themselves plundering and destroying each other. The English, however, did not receive hostages or pledges of submission on this occasion. Felim made peace with the Lord Deputy, and the English gave him the five cantreds belonging to the king, without cattle, but free from tribute.’




---

p.403


In the year following, 1236, we find this Eoghan O'Heyne in opposition to Felim O'Conor, and assisting Brian, the son of Turlogh O'Conor, who had been set up as king of the Irish of Connaught by the English. He died, according to the Four Masters, in 1253.


29. *John, son of Eoghan O'Heyne.*


30. *Aodh, or Hugh, son of John O'Heyne.*


31. *Donnchadh, or Donogh, son of Hugh O'Heyne.*—The Irish annalists preserve no historical notice of the three last generations. At the year 1261 the Four Masters state that Maelfabhaill, or Mulfavill O'Heyne, slew Hugh, the son of Maolseachlainn O'Conor; and at 1263, that he was himself slain by the English; and at 1326 they notice the death of Nicholas O'Heyne; but nothing remains to show how these stood related to the generations above given. This Donnchadh had two sons, namely, Eoghan, who became lord of the Hy-Fiachrach Aidhne, and was slain, according to the Annals of the Four Masters, in the year 1340 by his own kinsmen, and Muircheartach O'Heyne, by whom the line was continued.


The Irish annalists preserve but very few notices of this family from the year 1340 to 1578. At the year 1377 Mac Namara and his people of Clann Coilen defeated the people of Clanrickard, and slew Theobald, son of Ulick Burke, the commander of a great body of Kerns, and O'Heyne's three sons, with many others of the chiefs of Clanrickard — Ann. Clonmacnoise.


In the year 1407 O'Heyne joined Mac William Burke of Clanrickard, and Cathal, son of Rory O'Conor, King of Connaught, and fought the battle of Killaghy against O'Conor Roe, but they were defeated and taken prisoners. The annalists do not give us the Christian name of the O'Heyne here mentioned, but we may conjecture that he was No. 33 in the pedigree, namely, Aodh Buidhe, the son of Muircheartach.


32. *Muircheartach, or Murtogh, son of Donogh O'Heyne.*


33. *Aodh Buidhe, or Hugh the Yellow, son of Muircheartach O'Heyne.*


34. *Brian, son of Hugh the Yellow, O'Heyne,*


35. *Conchobhar, or Conor, son of Brian O'Heyne.*


36. *Flann, son of Conor O'Heyne*—He had four sons, who became the founders of four distinct septs, namely, 1, Edmond, the ancestor of the succeeding chiefs, except two; 2, Ruaidhri na Coille, i. e. *Rory or Roger of the Wood,* who became chief of the Hy-Fiachrach Aidhne, and died in the year 1578, as we learn from the Four Masters: —‘A . D. 1578. O'Heyne (Ruaidhri na Coille, son of Flann, son of Conchobhar) died. He had been distinguished for his hospitality and activity in the use of arms from the beginning of his career until he was summoned from this world. His fraternal nephew, Eoghan Mantach, son of Edmond, was elected to his place.’[1021](javascript:footNote('T105008/note1021.html')) 3. His third son was



---

p.404



Aodh Buidhe, the ancestor of O'Heyne of the castle of Dunowen; and, 4, Flann O'Heyne, the ancestor of O'Heyne of the castle of Dun Guaire.


37. *Edmond, son of Flann O'Heyne.*—Nothing is recorded of this O'Heyne except that he was the father of,


38. *Eoghan Mantach O'Heyne.*— He succeeded his uncle, Ruaidhri na Coille, as chief of the Hy-Fiachrach Aidhne, in 1578. The following order of the Council of Connaught in his favour is worth inserting here, as throwing curious light upon the history of property at this period.

> Order of Council of Connaught—1586
> Whereas, it is given us to understand that Owen Mantagh O'Hein of Lydegane, in the barony of Kiltaraght, within the co*unty* of Galway, chiefe of his name, is seized amongst other lands of the q*uarter* of land called Caherkearney, & the q*uarter* of Cratnagh, w*hich* 2 q*uarters* by a reason they were not presented unto us, are not comprised within the Indentures of her Maj*esty's* Composition, & for as much as by the said Indentures there was no freedom provided for the said Owen, and that by his own confession & presentment yt is found owte the s*aid* twoe q*uarters* of land to be concealed and not presented as afforesaid, whereby he is the better worthie to engage the same. It is therefore condecended, granted & agreed in consid*eration* of the premises that the s*aid* Owen Mantagh O'Hein shall possess s*aid* lands discharged of her Ma*jesty's* Composition Rent.
> 
> 
> Given at Dublin the 13th of May, 1586.
> Rich*ard* Bingham. 
> Thomas Dillon. 
> Tho*mas*. C. Strange. 
> George Comerford. 
> Nich*olas* White. 




This Eoghan Mantach, or Owen the Toothless O'Heyne, died in the year 1588, as we learn from the Four Masters. ‘A. D. 1588. Eoghan Mantach, son of Edmond, son of Flann, son of Conchobhar O'Heyne, lord of Hy-Fiachrach Aidhne, died, and his son Aodh Buidhe *[Hugh the Yellow]* was elected to his place.’[1022](javascript:footNote('T105008/note1022.html'))


39. *Aodh Buidhe, or Hugh Boy, the son of Eoghan Mantach O'Heyne.* —Upon the surrender of his property he received a grant of an extensive estate in the original territory, as will appear from the following curious document extracted from the fourth file of Fiants:

> 
> A Graunte unto Hughe Boy O'Heine, sonne and heire of One *[Owen]* O'Heyne of Ledigan, in the co*unty* of Gallway, within the province of Conaght, upon his Surrender, bearing date the 22nd of July, in the xxxth yeare of her Ma*jesty's* raigne, of 33s. 4d. Sterlinge yerely, chief rent going out of three q*uarters* of lande in Crannaghe, of one q*uarter* of
> 
> 
> 
> ---
> 
> p.405
> 
> 
> 
> lande in Clonchie, of one q*uarter* of lande in Cahern, one q*uarter*of lande in Cahircarne, one q*uarter* of lande in Crossye, and two q*uarters* of lande in Rahassane; and also 33s. 4d. Ster. chiefe rent yerely goinge out of one q*uarter* of lande in Sisselleidigan, one q*uarter* of lande in Tuelgon, one q*uarter* of lande in Corveighe, one q*uarter* of lande in Kintierleveigh, and one quarter of lande in Dunguoire in th' aforesaid Countie: also 33s. 4d. chiefe rent yerely goinge out of one q*uarter* lande of Cahirkillen, one q*uarter* of lande in Caherglassane, one q*uarter* of lande in Keppaghbeg, one q*uarter* of lande in Cahermadorishe, one q*uarter* of lande in Powleneveigh, and one q*uarter* of lande in Rahalben in th' aforesaid Countie; also 33s. 4d. Ster. chiefe rent yerely goinge out of one q*uarter* of lande in Ballibuige, one q*uarter* of lande in Lawghcoure, one q*uarter* of lande in Kiltwyne, and one q*uarter* of lande in Caherscarlie in th' aforesaid countie; also fortie one shillings foure pence Ster. chiefe rent yerely goinge out of one q*uarter* of lande in Ballevanegrane, one q*uarter* of lande in Monescrib, one q*uarter* of lande in le Mey, one q*uarter* of lande in Fonchenbeg, one q*uarter* of lande in Keapaghmore, and one q*uarter* of lande in Clogher in th' aforesaid countie: also 35s. 8d. Ster. chiefe rent yerely going out of one q*uarter* of lande in Knocklegan, one q*uarter* of lande in Gortevallaile, one q*uarter* of lande in Dromyn, one q*uarter* of lande in Trelick, one q*uarter* of lande in Fonshenmore, one q*uarter* of lande in Rewe, one q*uarter* of lande in Dowres, one q*uarter* of lande in Townaght, one q*uarter* of lande in Agard, one q*uarter* of lande in Balliglara, one q*uarter* of lande in Killily, and one q*uarter* of lande in Cloneste in th' aforesaid countie —Summa total. x. *libra* Ster. to the said Hughe O'Heine and his heires and assignes for ever per servicium Militare, viz. per servicium xx.me partis unius feodi Militis. — Solvo jure cujuslibet. Deliberat. in Canc. Hibernie xxiiii Julii an. r. R. Eliz. xxx[ordm ], —tempore Wil. Fitzwilliams.
> 
> 
> 




This Aodh Buidhe, or Hugh Boy O'Heyne, died in the year 1594, as we learn from the Four Masters: — ‘A. D. 1594. O'Heyne (Aodh Buidhe, son of Eoghan Mantach, son of Edmond, son of Flann) died.’[1023](javascript:footNote('T105008/note1023.html')) This is the last notice of the O'Heyne family given in the Annals of the Four Masters; but **Duald Mac Firbis** gives two generations more of the pedigree of the family of Lydigane, which carry the line down to his own time, A. D. *1650*-1666. These generations are,
  


40. *Aodh Buidhe, son of Aodh Buidhe O'Heyne.*


41. *Eoghan, son of Aodh Buidhe O'Heyne, of Lydigane.*


From the Civil Survey, preserved in the Custom-House, Dublin, it appears that the following persons of the name of O'Heyne were living in the barony of Kiltartan in 1641, principally in the parish of Dawros Kinvara:
  

1. Edmond Owen O'Heyne, in Corboy.
2. Conor O'Heyne, in Kinturly.
3. Flan Boy O'Heyne, in Kinturly.


---

p.406

6. Car. Turlogh and Farro O'Heine, Ibidem.
7. Flan Boy O'Hene, in Lissurduffe and Tomareagh.
8. Teige and Edmond O'Hene, in Moinskaebo and Moigh.
9. Owen O'Hene, in Funchinmore.
10. Hugh O'Hene, in Corcarney.
11. Flan mac Edmond O'Hene, in Loughcurro.
12. Farro O'Hine, in Balligilligagh and Corconnogh.
13. Turlo O'Hine, in Cappamore.
14. Edmond O'Hine, in Drumon.
15. Teige Reagh O'Haine, in Ballimachakill.
16. Car. Henry O'Hene, in Shragh and Ballinaghan.
17. Donogh O'Heyne, in Shragh and Ballinaghan.
18. Owen mac Teige Moyle O'Heine, in Shragh and Ballinaghan.
19. Lawyhewre O'Heine, in Shragh and Ballinaghan.
20. Hugh Boy O'Heine, in Carrocurra and Crannan.



Dominick Darcy of Clonuane, Gent, by his Will (now preserved in the Prerogative Court, Dublin), dated 1st August, 1666, bequeaths to his brother *[half brother?]* Farragh O'Heyne, during his life, the cartron of Kilboren, and five pounds sterling; to his brother Flan O'Heyne three pounds, and the like to his brother Owen O'Heyne.


John Hynes, Esq., of the New Quay, in the barony of Burren, in the north of the county of Clare, who has acquired a handsome property by honest industry, is descended from Flan Boy O'Heyne of Kinturly, now Kinturlough, mentioned in the above list, from whom the generations to the present day will be seen in the following line:[1024](javascript:footNote('T105008/note1024.html'))


1. Flan Boy O'Heyne of Kinturlongh, living in 1641.


2. Peter O'Heyne.


3. Brian O'Heyne.


4. John Hynes, died 1746.


5. James Hynes, died 1802.


6. John Hynes, now living, born 1785.


7. James; 7. Dr. Patrick of London; 7. Thomas, died 1841;7. Michael of Kinvara, merchant; 7. John.




---

p.407


### E

### Pedigree of Mac Firbis


This family were originally seated in Magh Broin, in Tirawley. They were afterwards removed to Rosserk, on the west side of the Moy, in the same territory, but when the Barretts drove the O'Dowds out of Tirawley, Mac Firbis was fixed at Lecan in Tireragh. They had the privilege of holding the rod over O'Dowd at his inauguration, and of drinking at the banquet even before the acknowledged senior of the race, O'Caomhain.— See pp. 140, 141, 142. The pedigree of this family, as given by **Duald Mac Firbis** in 1666, is many generations defective, and cannot be depended upon except for about the last twelve generations. Strange! that this family, who were the hereditary historians to the O'Dowds, while they preserved so much of the history of other families, should have left us so imperfect and uncertain an account of themselves. The following is the part of this pedigree which the Editor believes to be trustworthy:—




---

p.408


Our writers have preserved but few notices of this family. The following are all that the Editor has been able to collect:
  

‘A. D. 1279. Giolla Iosa Mor Mac Firbis, Ollav of Tireragh, died.’— Four Masters.


‘A. D. 1301. Gille Issa Mac Firvissie, chief chronicler of Tyrefiaghrach, wonderful well-skilled in histories, poetry, computation, and many other sciences, died.’ — Ann. Clonmacnoise.


‘A. D. 1376. Donnchadh Mac Firbis, a good historian, died.’— Four Masters.


‘A. D. 1379. Firbis Mac Firbis, a learned historian, died.’— Four Masters.


‘A. D. 1417. Giolla Iosa Mor Mac Firbis was chief historian to O'Dowd of Tireragh, and composed a long topographical poem on the tribes and districts in the ancient territory of his ancestors.’— Duald Mac Firbis.


‘A. D. 1450. Eugene O'Cormyn and Thady Mac Firbis, Eremites of the order of St. Augustine, received a grant of the lands of Stormor, in Tirawley, from Thady O'Dowd, to erect thereon a monastery under the invocation of the Holy Trinity, and Pope Nicholas the Fifth confirmed the same by a Bull dated 12th December, 1454.’ — Archdall, from Meagher.


‘A. D. 1560. Ciothruadh and James, the two sons of Diarmaid Caoch Mac Firbis, and their cousin-german John Og, the son of William Mac Firbis, built the castle of Lecan in Tireragh.’— Duald Mac Firbis. Vide supra, pp. 168, 169.


‘A. D. *1670*. **Duald Mac Firbis**, the last of the hereditary antiquaries of Lecan, was murdered at Dunflin.’— Ch. O' Conor of Belanagare.


The present representative of this family is supposed to be John Forbes, a small farmer living in the parish of Lacken, near Killala, and barony of Tirawley. He descends from one of the brothers of Duald, the last of the antiquaries, and he has lately addressed the following letter to the Royal Irish Academy, which is inserted here for the sake of the particulars it contains of the writer's family, and as a curious assertion of his claim to be the representative of the ancient antiquaries: 

> To the Honourable the President and Associates of the Royal Irish Academy.
> The Memorial of John Mac Firbis of the parish of Lacken, in the county of Mayo, farmer,
>   
> 
> respectfully showeth,
>   
> 
> that Memorialist is descended from the family of Mac Firbis of Lecan—Mac Firbis, in the county of Sligo, hereditary antiquaries of Connaught, being the fifth in descent from the younger and only brother of **Duald Mac Firbis**, the last of the antiquaries of the family, who was brutally murdered in the county of Sligo. 
> 
> 
> 
> ---
> 
> p.409
> 
> 
> 
> That the sisters of said Duald retired into Spain, where they ended their lives in a convent, whilst his younger brother, the ancestor of memorialist, was dispossessed of the property of Lecan Mac Firbis, since which period memorialist's family have lived in poverty and indigence.
> 
> 
> That memorialist has been informed that a work on Irish antiquities called the Book of Lecan, written by one of memorialist's ancestors, is now in the Library of your honourable Society, together with the copy of another work of like nature, composed by the aforesaid **Duald Mac Firbis**, of which his family was deprived at the period of his murder.
> 
> 
> Although the lands of Lecan Mac Firbis have passed away for ever from memorialist's family, yet he humbly hopes, from the honour and humanity of the Noblemen and Gentlemen composing the Royal Irish Academy, that he will be allowed some
> consideration for these works of his ancestors, which now, as memorialist believes, form a prominent portion of ancient Irish history.
> 
> 
> Memorialist is in a state of humble poverty, and respectfully submits his case, my Lords and Gentlemen, to your humane consideration.
> 
> 
> And will for ever pray.
>   
> 
>   
> Dublin,
> 
>  15 Aug., 1842.




### F

### St. Fiacre — The Muaidh


Page 2, note c.—*i. e. p. 3, note 8 in the CELT edition.* The proper name Fiachra, making Fiachrach in the genitive case, which occurs so often throughout this volume, is well known on the Continent as that of a celebrated Irish saint, the site of whose hermitage near Meaux was deemed so sacred that to go on a pilgrimage thither was, to a late period, a frequent practice; and we are told of the pious queen Anne of Austria, that when she visited the shrine of this saint in 1641, so great was the humility of her devotion that she went the whole of the way from Monceau to the town of Fiacre on foot.


*L'ermitage de Saint Fiacre est devenu un bourg de la Brie, fameux par les pélérinages que l'on y faisait; l'église ou chapelle étoit desservie par les Bénédictins; les femmes m'entroient point dans le sanctuarie, et l'on remarque que la Reine Anne d'Austriche, y venant en pélérinage en 1641, se conforma à cet usage, et qu'elle fit même à pied le chemin depuis Monceau jusqu'a Saint-Fiacre’’*

 Hist. de Meaux — quoted by **Moore** in his History of Ireland, vol. i. p. 278., who also quotes from ‘another work,’ which he does not name, relating to this saint: —‘On a pretendu que le nom de Fiacres avait été donné aux carosses de place, parcequ'ils furent d'abord destines à voiturer jusqu'a St. Fiacre (en Brie) les Parisiens qui y allerent en pélérinage.’ —
See Butler's Lives of the Saints, in Aug. 30. Mabillon Acta SS. Ord. S. Bened. tom. ii. and the Bollandists.




---

p.410


*Ibid. — The Muaidh, called Moda by Adamnan.* — The learned **Dr. Prichard**, in his Ethnography of the Celtic race, being misled by the inaccurate work on Ireland by Dr. Wood, states that the Moda of Adamnan is Wexford harbour, and concludes that the Milesian story was written after the seventh century. The following are his words: — *The Milesians arrived in Ireland 1300, B. C., at Inmhear Slainge, or
Wexford harbour, the name of which is a *proof* that the Milesian story was written after the seventh century, since in the second that place was called ‘Modoni ostia’ by Ptolemy, and in the seventh Moda by St. Adamnan.’’*

Sect. XII. Par. 2.




Whatever truth or falsehood there may be in the Milesian story, this argument is too weak and unfounded to destroy it. The words of Adamnan are as follows, and they clearly show that he meant no other than the present River Moadh, or Moy: — *Alio quoque in tempore de Cormaco nepote Lethani, viro utique sancto, qui tribus non minus vicibus eremum in Oceano laboriose quaesivit, nec tamen inuenit, Sanctus Columba ita prophetizans ait: hodie iterum Cormac desertum reperire cupiens, enauigare incipit ab illa regione quae ultra Modam fluvium sita, Eirros domnonn dicitur: nec tamen etiam hac vice quod quaerit inveniet; et non ob aliam eius culpam, nisi quod alicuius religiosi Abbatis Monachum, ipso non permittente, discessorem secum non recte comitari, navigio susceperit.’’*

Vita S. Columbae, Cap. VI. De Sancto Cormaco. (ap. **Colgan**. Trias Thaumathurgae. p. 340.)




On the situation of the River Moda **Colgan** adds the following note, which is an additional authority against the opinion that the Moda of Adamnan was the harbour of Wexford: — ‘Fluvius est Connaciae Celebris, vulgo Muaidh, et nobis latine Moadus, sive Muadus appellatus.’


On the situation of Eirros domnon, which lies beyond the River Moda, **Colgan** says:—
  

‘Eirros —Est regio Occidentalis Connaciae vulgo Irros chlann Domnann appellata.’


Now, as the River Moda of Adamnan is not the harbour of Wexford, where is the argument to prove that Inbher Slainge, the name of the mouth of the River Slaney, is not older than Ptolemy's time? Where is the proof that the Modoni ostia of Ptolemy is the mouth of the Slaney? —See Ogygia, p. 17, where **O'Flaherty** writes:—
  

‘Nec qui nunc Slanius Modono, aut alio quam Slanio nomine cognitus a Belgarum ingressu multis seculis ante Ptolemaei natales.’ It is much more likely that the Modonus of Ptolemy is the bay of Bannow, which is said to have been anciently a safer harbour than that of Wexford.


### G

### Sith Budha


Page 6, note 1 *i. e. p. 7, note 31 in the CELT edition* — *Sith Budha*, i. e. the hill of Budh. There were three or four celebrated hills of this name in Ireland, which were believed to have been haunted by



---

p.411



fairies or demons; but it would appear from the Life of St. Cormac, as given in the Book of Lecan, and published in a Latin translation, by **Colgan** in Acta SS. that the Sith budha here referred to was in Tirawley. Speaking of Muireadhach, from whom sprung the O'Muireadhaigh of Tirawley, this life has the following words: — ‘ex cujus semine nobilis familia Muredaciorum in eadem regione olim potens.’ We find in it also the following curious reference to this hill: — ‘Ad ejus *[sc. Cormaci]* etiam Ecclesiam, tanquam ad tutum refugium *[seu]* asylum, uxor praedicti Aengussii, nomine Saba filii Fiachrii Finni, a quo Fiachrorum familia in regione Amalgadiae, duxit suum filium Muredacium nomine, laethali contagione percussum, quam contraxit ex quad am pestilenti exhalationi, quae promanabat ex monte quodam Sith Badha *[recte Sith Budha]* vulgo nuncupato, et daemonum infestationibus infecto.’ — **Colgan**, Acta SS. p. 754.


### H

### The Ancient Leatha


Leatha.—See pages 18, 19, note w, *i. e. p. 19, note 81 in the CELT edition.* — It has been much disputed by modern antiquaries what district the ancient Irish writers designated by the name Lethu, or Leatha. The translator of Fiech's Hymn on the life of St. Patrick has rendered it *Latium* in the fifth, sixth, and ninth quatrains, but Mr. Patrick Lynch, in his Life of St. Patrick, and after him **Lanigan** and Declan, have laboured to prove that *Leatha* was never applied to Latium, but was a hibernicised form of *Letavia,* the name by which a part, and sometimes the whole of Armoric Gaul was called by the writers of the middle ages. Lynch, after stating that the translator of Fiech's Hymn was in error in understanding Letha as designating Latium, or Italy, writes as follows, pp. 77, 78:
  

‘The truth is, that the word *Lethu,* in all parts of the Irish hymn where it occurs, should have been translated into LETAVIA, the name by which a part, and sometimes the whole country of Armoric Gaul was called by the writers of the middle ages.
  
In according to that, the old scholiast on this hymn says, that ‘all St. Patrick's family went on commercial business beyond the Iccian sea towards the south to Lethanian Aremorica, or Letheacensian Britain; but at that time the seven sons of
Fechtmund being banished from Britain (Albion) were committing depredations in Letha, a district of Aremoric Gaul.’’[1025](javascript:footNote('T105008/note1025.html'))
  


‘In the life of St. Ailve, Bishop of Emly, in Momonia, or Munster, and not in



---

p.412


*Menavia,* or St. David's, as **Cambrensis** would have it, it is recorded that ‘Sampson was Bishop of Dal Omhoir, in the remotest frontiers of Letha,’ that is, says Doctor Langhorne, ‘the city of Dol, in Bretayne, or *Lethania* Aremorica, for,’ continues he, ‘Aremorica was also denominated Letha, or Lethania.’’[1026](javascript:footNote('T105008/note1026.html'))


‘To the above we shall only add the testimony of **Camden**, who states that ‘this district, previously to the arrival of our countrymen from Britain, was originally called Aremorica, that is, *near the sea,* in the British dialect *Lhydaw*, importing also its maritime situation, *lying on the coast;* and in Latin *LETAVIA ,* among the writers of the middle age; whence its inhabitants, I suppose to be the LETI , a people of Gaul mentioned by **Zosimus**; and, lastly, it was denominated Britannia Minor, or Little Britain, from our British compatriots who settled there’’[1027](javascript:footNote('T105008/note1027.html')).


This reasoning would seem to be borne out by the Irish translation of Nennius, in which ‘Brittones Armorici’ is rendered by the Irish ‘Breatain Leatha,’ i. e. the Britons of *Leatha,* as in the following passage:
  

‘Septimus imperator regnavit in Britannia Maximianus. Ipse perrexit cum omnibus militibus Brittonum a Brittannia, et occidit Gratianum regem Romanorum, et imperium tenuit totius Europae, et noluit dimittere milites, qui perexerunt cum eo, ad Brittaniam ad uxores suas, et ad filios suos, et ad possessiones suas; sed dedit illis multas regiones, a stagno quod est super verticem Montis Jovis usque ad civitatem quae vocatur Cantguic, et usque ad Cumulum occidentalem, id est, Cruc Ochidient. Hi sunt Brittones Armorici, et nunquam reversi sunt huc, usque in hodiernum diem.’
— Historia Britonum, Stephenson's edit., pp. 20, 21.


Thus rendered by the Irish translator in the Book of Ballymote and H 3 17.{column 1}
‘Maiximain ro ghab rigi Bhreatain, ocus rug slogu Bhreatain a Romhánchaibh, co torchair lais Gratian in t-imper, " 



---

p.413



ocus ro gab féin rigi na h-Eorpa; ocus ní ro léig uad na sluaig rug leis do chum a m-ban, ocus a mac, nacha fearann, acht do rad fearanna imda doib ó tha in loch fil immullach Sleibi loibh co Canacuic bu deas, ocus siar co Duma Oichiden, ait a fuil in Chros eargna. Ocus is iad sin Breatain Leatha, ocus tarastair teas do ghreas.’


{column 2}‘Maximian succeeded to the government Britain into the country of the Romans, and he led the forces of Britain into the country of the Romans,[1028](javascript:footNote('T105008/note1028.html')) and Gratian, the Emperor, was slain by him, and he himself assumed the government of Europe, and he did not permit the forces which he had brought with him to return to their wives, sons, or lands, but he gave them many lands *[in the region extending]* from the lake which is on the summit of Mount Jove, southwards, to Canacuic, and westwards
to the mound of Oichiden, where the grand cross is situated. And these are the Britons of Leatha, and they remained always in the south.’


{end of column }
It looks strange that the Irish translator here seems to take the Welsh word *cruc,* a hill or mound, for the Latin word crux, a cross, and understands Cruc Ochidient, which Nennius intended as a Welsh translation of cumulum occidentalem, to signify ‘where the grand cross is situated!’


But it must nevertheless be confessed that in the Felire Aenguis, at the 27th of June, the city of Rome is styled Ruaim Letha in the original text, and Letha is explained in the Gloss by the Latin *Latium*, ‘Leatha, a nomine Latium.’ Also in a very ancient Irish stanza quoted in the same work, Pope Gregory the Great is styled
‘Abb Róma Letha,’ i. e. Abbot of Rome of Letha. These authorities are sufficient to defend the translator of Fiech's Hymn against the criticism of Lynch and his followers **Lanigan** and Declan. The following authorities are also submitted to the reader on this very curious question:{column 1}
‘Is ann sin do cuaidh Patruic do fhogluim eacna agus crabuid i n-oirtheas descert Etaile co German epscop ... iar sin ro fucc in t-aingeal e i n-Arboric Letha cus in cathraig dianad ainim Capua i Sleib Armoin, super ripam maris Terreni.’
— Vit. Patricii, in Leabhar Breac, fol. 13, b.


{column 2}‘Then Patrick went to learn wisdom and religion in the south-east of Italy, to German the Bishop. ... Afterwards an angel conducted him to Armoric Letha to the city named Capua, at the mountain of Armoin super ripam maris Tyrrheni.’


{end of column }
**Duald Mac Firbis** has the following notices of this name:


{column 1}‘Fochan daoire Phatraig, i. Patraig



---

p.414




agus a athair, agus a mháthair, agus a chúig seathra, .i. Lupait, Tigris, Raicéll, Dererca, Cinnenum agus a brathair, .i. deochuin Samian, do chuadar uile a Breathnuibh Ail Cluaide tar Muir n-Icht fo des for turus go Bhreathnuibh Armuirc Leatha, .i. go Breathnuibh Letheoch, ár ro bátar bráitre dóib ann in tan sin. Agus Fa do Frangcoibh máthoir na clainne, .i. Coinces, agus ba siursidhe coibneasda do Martain. Agus as i sin aimsir ro bátar secht meic Sechtmaide, .i. righ Bretan for longg ó Bhreatnaib. Do ronsad tra crech moir i m-Breathnuibh Armuirc Leatha, baile a m-boi Patraig co n-a mhuinntir, &c.’


‘Teit Phatraic iarum go raibhe la Gearman ab, a n-deas i n-desgert Leatha (in australi pairte Gallorum iuxta Mare Terrenum). Leatha, .i. Italia, Leatha a latitudine. German, abb na cathroch dar ab ainm Altiodorus, as aige ro légh Pátraig, agus Burgunia ainm na ceannaichthe s d-tá in cathair sin in gallis; gomadh i n-Innsibh Mara Toirren sin mar aspert Fiag Slebhte,
  

In-innsib mara Toirrian,
  

Ainis innib ad rime,
  

Leughais canoin la German,
  

Aseadh ad fiadhad line.
  

Ocus Alanensis ainm na cathroch no na hinnsi sin ar Muir Toirren.’


{column 2}‘The cause of Patrick's slavery was this. Patrick, with his father, mother, and five sisters, Lupait, Tigris, Raichell, Dererca, and Cinnenum, and his brother Deochuin Samian, all went from Britain of Ail Cluath, southwards, across the Iccian sea, to the Britons of Armuiric Leatha, that is, to the Britons of Letheoc, who were their kinsmen at that time, and the mother of these children was of the Franks, namely, Coinces, a near relative to St. Martin. This was the time that the seven sons of Sechtmad, King of Britain, were in exile from Britain. They committed a great depredation on the Britons of Armuiric Leatha, where Patrick and his people were,’ &c. — **Duald Mac Firbis**, MS. Geneal., p. 692.


‘Patrick afterwards went southwards to *German, the Abbot*, in the south of Leatha (in australi parte Gallorum juxta Mare Terrenum).
Leatha, i. e. Italia; leatha a latitudine. German was abbot of the city named Altiodorus; it is with him St Patrick read; and Burgunia is the name of the principality in Gaul, in which this city is situated; and this is in the islands of the Tyrrhenian sea, as Fiag of Sletty says,’
  

‘In the islands of the Tyrrhenian sea
  

He resided, as is related,
  

He reads his canons with German,
  

As is certified by us.’
  

‘And Alanensis is the name of the city or island in the Tyrrhenian sea.’ — Id. p. 693.


{end of column }
It should be also remarked that in the Book of Lismore, and in the Book of Fenagh the city of Rome is called *Róim Leatha,* i. e. Rome of Leatha, from which it is quite



---

p.415



clear that by Leatha the writers of these works meant Latium, which was the ancient name of that district of Italy, in which the city of Rome is situated.


### I

### Saint Ceallach


Pages 33–35—This Ceallach, who was the eldest son of Eoghan Bel, King of Connaught, was educated by St Kieran of Clonmacnoise, and became a bishop at Kilmore-
Moy, in Tirawley; but he afterwards resigned his bishopric and retired as a hermit to *Oilen Edghair,* in Loch Con, from fear of Guaire Aidhne, King of Connaught, who had conceived a mortal hatred towards him, as he was the true heir to the kingdom of Connaught. Guaire bribed four ecclesiastical students who were under Cellach's tuition in the hermitage, to murder him, namely, Mac Deoraidh, Maelcroin, Maeldalua, and Maelseanaigh. According to the life of Bishop Ceallach, of which there is a copy in the collection of Messrs. Hodges and Smith, this murder was committed in a wood situated between Loch Con and Loch Cuillinn, in the south of the territory of Tirawley, and after its perpetration King Guaire granted the territory of Tirawley to these four students as a reward for their services in despatching Ceallach, who thereupon erected a fort for themselves at Dun Fine. Soon after this occurrence Muireadhach, who was otherwise called Cucoingilt, the second son of King Eoghan Bel, came to visit his brother *[in]* Oilen Edghair, but not finding him there, and learning that certain negociations had passed between his pupils and King Guaire, he at once suspected that the bishop, his brother, had been murdered; after some inquiries and searches he found the body in the hollow trunk of an oak tree, torn by the ravens, scald crows, and wolves. Cucoingilt carried the mangled body to the church of Turloch for interment, but the clergy of that establishment, dreading the vengeance of King Guaire, would not
permit it to be buried there; upon which he carried it to the church of Lis Callain, but the clergy refused to admit it; it was next brought to the church of Eiscreacha, where it was interred with due honours. Cucoingilt, after having chanted a short dirge
over the grave of his brother, in which he vowed vengeance against the murderers, assembled an armed band of three hundred of his relatives and adherents, with whom, after
having lived one year in Hy-Many, and some time in Meath, where he married Aifi, the daughter of Blathmac, King of Ireland, he at length returned to Tirawley, his own Fleasc lamha, or patrimonial inheritance, where, by the assistance of a swine-herd, he procured admittance to the fort of Dun Fine, in which the murderers of his brother were banquetting. Here he remained at the banquet in the disguise of a swine-herd until he observed that the four murderers, and all their guests and attendants, were 



---

p.416



stupid with intoxication, upon which he sent his friend, the swine-herd, for his armed band, who were concealed in the neighbourhood, who, rushing into the fort, slew all the guards and attendants, and seized upon the four murderers of Bishop Ceallach. The guests in general, on learning that it was Cucoingilt, the second son of King Eoghan Bel, and the brother of the murdered bishop, that had thus disturbed their festivities, were more pleased than grieved at the occurrence, and finished their potations in honour of the rightful heir.


On the next day Cuncoingilt carried the four murderers, in chains, southwards, through the territory from Dun Fine to a place called Durlus Muaidhe, and across Lec Durluis, until he arrived at a place near the River Moy, since called *Ard na riadh* [now Ardnarea], i. e. the hill of executions, where he executed the four, cutting off all their limbs while they were living.


After this Cucoingilt obtained the hostages of Tir Fiachrach and Tir Amhalgaidh, and compelled Guaire to live in Tir Fiachrach Aidhne, in the south of the province.


### J

### Cnoc Na Maill


Page 96, note d, and page 267, note t *i. e. p. 97, note 247 and p. 267, note 765 in the CELT edition* — It should be here added that the district lying round the Red Hill of Skreen was originally called Cnoc na Maili, and afterwards Mullach Ruadha, which is now, strange to say, applied not to the hill itself, but to a small townland lying to the east of it. But the name was never so applied until the
original Ballybetagh was subdivided into half quarters, which constitute the present townlands, when the names were very strangely confounded. Thus the half quarter on which the church stands received the appellation of Skreen from the church, the
division to the south of it was called Lecarrow, i. e. Leith-cheathramha, the half quarter, from its quantity; the hill itself, which originally gave name to the whole district, or Ballybetagh, was called Cnoc Ruadha, i. e. Rufina's hill, now incorrectly translated Red Hill, while Mullach Ruadha, the more ancient appellation, was transferred to a subdivision to which it is by no means applicable, inasmuch as it is not a mullach, or summit, in relation to the other subdivisions, and contains no monument of the Lady Rufina with whose name it is compounded. In this manner, however, have ancient names, in many instances, been transferred and corrupted. The carn erected over the body of Ruadh, or Rufina, the wife of Dathi, still remains on this hill, but it is not on its very summit, as **Duald Mac Firbis** writes. It is thus described by Robert Jones, Esq., in a letter to R. C. Walker, Esq., of Rathcarrick, barrister-at-law, who has kindly forwarded it to the Editor:


> 
> Being here for the Christmas holidays I made a search for the cairn of Knockroe,
> 
> 
> 
> ---
> 
> p.417
> 
> 
> 
> 
> or Mullaghroe, and have discovered it. I enclose a sketch from the Ordnance Map, sheet 19. On the townland of Mullaroe there is nothing of the sort, but the district up the hill is all called Crockroe, or the Red Hill, and there is a large stone fort shown in the Ordnance Survey, called the Red Hill. This, however, is not the cairn, but lower down the hill I discovered the cairn, which had been opened, and contained several small chambers; the principal one has still the covering stones on it, but filled with smaller stones underneath. The carn is of an oval form, ninety-six paces round. The entire hill is a light soil on lime-stone rock, which every where protrudes. The cairn is formed of these stones; the first chamber has a double covering of large lime-stone flags, the sides being formed of upright flags of the same material, like a small cromlech, and is about six feet square. There appear to be several other smaller ones which have been opened and the rubbish thrown back again. From the stone fort higher up the hill there is a magnificent view: it stands just over the dark lake under Knockacrea, from whence the mountain rises at once, and the view of Knocknarea, Glencarr, and the mountains beyond the Union wood is splendid. It is a very considerable fort and has chambers underneath it.
> 
> 
> Robert Jones. 
>   
> Skreen,
> 
> 
> 27th December, 1843.




### K

### Pedigree of the Clann Donnchadha O'Dowd.


Page 116, note w, *i. e. p. 117, note 294 in the CELT edition* — The following document is taken from the Book of Lecan, fol. 85, b, where it has been inserted in a more recent hand:
  
{column 1}
‘Clann adbal mor la Maolruanaig, mac Donnchaig, meic Aodha, meic Tailtig, meic Aodha, meic Muircheartoig, i. Tailtech Muaidhi, agus Donnchadh agus in Cosnamoig, .i. Aird Espoc Tuama,’


{column 2}
Maolruanaidh, son of Donnchadh, son of Aodh, son of Taithleach, son of Aodh, son of Muircheartach, had a very great family, namely, Taithleach Muaidhe [of the Moy], Donnchadh[1029](javascript:footNote('T105008/note1029.html')) and Cosnamhach[1030](javascript:footNote('T105008/note1030.html')), Archbishop of Tuam.




---

p.418


{column 1}
‘agus as é in Tailtech Muaidhi sin do marbad a m-Bel Atha Tailtigh ar Coilltib Lughna Meic Firtri, re Gallaib. Agus ro eirgeadar clann imda ag Donnchadh Mor O'Dubhda re h-Onoruinn, ingen Meic Baitin Bairéd, .i. Donnchadh Og, agus Muircheartach, agus Taithlech, .i. cnam-fhiach na clainni ar a méd, agus ar a milidheacht agus drong eli d'á radha gur ab mac tabartais é, agus go bh-frith d'á ithe fa fiachaibh é, no go d-tuc O'Luachan d'á thig féin d'a oileamoin é; agus Lochlainn agus Aodh in Chorainn, agus Cormac, .i. Espoc Cilli h-Ealad, agus Aodh Ruadh, agus Concabar na Ceitherne.’


{column 2}
This is the Taithleach Muaidhe who was slain at Bel Atha Tailtigh, in Coillte Lughna Mac Firtri, by the English.[1031](javascript:footNote('T105008/note1031.html')) And Donnchadh Mor O'Dubhda had numerous issue by Honora, the daughter of Mac Wattin Barrett[1032](javascript:footNote('T105008/note1032.html')), namely, Donnchadh Og, Muircheartach[1033](javascript:footNote('T105008/note1033.html')), and Taithleach (*called* the cnaim-fhiach of his children, for his size and warlike character, *though* others say he was a natural son[1034](javascript:footNote('T105008/note1034.html')), and that he was found under the ravens, which were devouring him, until O'Luachain took him into his house to nurse him); Lochlainn, Aodh an Chorainn, Cormac[1035](javascript:footNote('T105008/note1035.html')), Bishop of Killala, Aodh Ruadh[1036](javascript:footNote('T105008/note1036.html')), and Conchobhar na Ceitherne[1037](javascript:footNote('T105008/note1037.html')).


{column 1}
‘Do gab Taithlech Muaidhi in tighearnus d'aimdeoin Donnchadha agus na sinnsirecht. Ro gab Donncadh Mór agus a clann ag foghail, agus ag dibearg, agus ag fir-milledh fonn O bh-Fiachrach agus O n-Amalgaid, no go n-dechaidh dith ar dhaínib, agus easbaidh ar aicmeadoib etorra, no go n-dechaidh lucht leanamhna na n-aon comairli etorra féin in tír do roinn, agus comatha comora agus fearonn fairsing do tabairt do na clannoib sin Donnchaidh Moir, agus in Tigearnus do beth ag Tailtech Muaidhi agus ag at-slicht ina deaghaidh.’


{column 2}
Taithleach Muaidhe took the chieftainship in despite of Donnchadh and his seniority.[1038](javascript:footNote('T105008/note1038.html')) Donnchadh Mor and his sons 



---

p.419




proceeded to plunder, rebel, and destroy the land of Hy-Fiachrach and Hy-Amhalgaidh, so that destruction was brought on men and want on tribes *[during the contention]* between them, until their followers consulted together and agreed to divide the country, and to give those sons of Donnchadh Mor large considerations and extensive territory, and to cede the chieftainship to Taithleach Muaidhe and his descendants after him.


{column 1}
‘Agus as í so in roinn, .i. Sineasgalacht agus seirbis in rechta righ do tabairt do Donnchadh Og, mac Donnchaidh Móir, agus ceannus ceithern agus congbal do Concabar na ceitherni, agus tigearnus ceall do Uilliam Espoc, agus cís agus dligeadh ar in g-ceathramhadh cuid do'n tir do Donnchadh Mór féin, agus mir murra ar a chinn fuas do Donnchadh Mór, .i. secht m-baile Cúile Cearnadha, featha agus caithigthe agus cosnam in tiri d'fiachaib ar Donnchadh agus ar a clann Maicni i n-a deaghaidh acht nama in mir murra d'fearann t-saor fuair Donnchadh Mor.’


{column 2}
This *was* the division: To cede the seneschalship and the service *[administration]* of the regal law to Donnchadh Og[1039](javascript:footNote('T105008/note1039.html')), the son of Donnchadh Mor, and the superintendence of the kerns and the houses to Conchobhar na Ceithirne, and the lordship of the churches to William the Bishop[1040](javascript:footNote('T105008/note1040.html')), and the rent and law of the fourth part of the territory *were ceded* to Donnchadh Mor himself, and a mir murra[1041](javascript:footNote('T105008/note1041.html')) was also ceded to him (Donnchadh Mor) for his seniority, viz., the seven townlands of Cuil Cearnadha[1042](javascript:footNote('T105008/note1042.html')); and Donnchadh Mor, and his sons after him, 



---

p.420



were obliged to sustain the battles and defence of the territory, though they have nothing for it but the mir murra of free land, which Donnchadh Mor had obtained.


{column 1}
‘Do dheanam eolus ar gach ceatramoin dibh foleith ar egla in duthchois do dol i m-bathadh, .i. Baile Cairthi in chuile, mar ata, ceathraimi in Cairthi fein, agus ceathraimi Aingilín, agus Ceathraimi na g-cloch agus ceatraimi Cilli Brigdi, oir i si cuid ronna sleachta Aodha Ruaidh, mic Donnchaidh Oig, in baile sin. Ceathraimi bec Muine Conalláin, Ceathraimi mor Muini Conalláin, agus Ceathraimi in Labáin, ag sin baile fearainn sleachta Muircheartaigh, mic Donnchaidh Móir.’


{column 2}
To preserve a knowledge of every quarter of these separately lest their patrimony might be consigned to oblivion. *They are as follows,* viz., Baile Cairthi in chuile[1043](javascript:footNote('T105008/note1043.html')), viz., the quarter of the chairthi itself[1044](javascript:footNote('T105008/note1044.html')), and Ceathramh Aingilin[1045](javascript:footNote('T105008/note1045.html')), Ceathramh na g-cloch[1046](javascript:footNote('T105008/note1046.html')), the quarter of Cill-Brighde[1047](javascript:footNote('T105008/note1047.html')), for this townland was the dividend of Aodh Ruadh, the son of Donnchadh Og. The quarter of Rath Raodain[1048](javascript:footNote('T105008/note1048.html')), the small quarter of Muine Conallain, the large quarter of Muine Conallain[1049](javascript:footNote('T105008/note1049.html')) and Ceathramha an labain[1050](javascript:footNote('T105008/note1050.html')); this was the townland of the posterity of Muircheartach,



---

p.421



The son of Donnchadh Og, who was the son of Donnchadh Mor.


{column 1}
‘Ceathraimi Cilli na n-Garbhan, in Ceathraimi Riabhach, Ceathraimi mic Conín*,* Ceathraimi na h-Oilighi, Baile fearainn sleachta Aodha in Choraind. Ceathraimi Lis Ard Mor, Ceathraimi Meic Carra, Ceathraimi na Grelligi, Ceathraimi I Dubagain, ag sin baile Concobair na Ceitherni .i. Baile na Brothlaigi*,* Ceathraimi mor Caislein, Ceathraimi Beac Caislein, agus Leith Baili Gleanna da Ghub, agsin Baile Tailtigh Moir .i. Cnaim Fhiach na Cloinni; Leith Baile Rúsgaighi, .i. Ceathraimi na Cairgi, Ceatraimi na Corra Drisighi, Ceathraimi Droma Sguabaigh, Ceathraimi Meic Geirbli agus da ceathroime ele nach airmidedh sonn.’


{column 2}
 The quarter of Cill na n-garbhan[1051](javascript:footNote('T105008/note1051.html')), Ceathramha riabhach[1052](javascript:footNote('T105008/note1052.html')), Ceathramha Mic Coinin[1053](javascript:footNote('T105008/note1053.html')), the quarter of Oileach[1054](javascript:footNote('T105008/note1054.html')), *constituting* the townland of the posterity of Aodh an Chorainn. The quarter of Lis ard mor[1055](javascript:footNote('T105008/note1055.html')), Ceathramha Meic Carra[1056](javascript:footNote('T105008/note1056.html')), the quarter of Grellach[1057](javascript:footNote('T105008/note1057.html')), Ceathramha Ui Dhubhagain[1058](javascript:footNote('T105008/note1058.html')), that is, the townland of Conchobar na Ceithirne. Baile na Brothlaighe[1059](javascript:footNote('T105008/note1059.html')), the great Castlequarter and the less Castlequarter[1060](javascript:footNote('T105008/note1060.html')), and the half townland of Gleann da ghubh[1061](javascript:footNote('T105008/note1061.html')), this is the townland of Taithleach Mor, Cnaimhfhiach na Cloinne. The half townland of Rusgach[1062](javascript:footNote('T105008/note1062.html')), the quarter of Carraig[1063](javascript:footNote('T105008/note1063.html')), the 



---

p.422



quarter of Corra drisighi[1064](javascript:footNote('T105008/note1064.html')), the quarter of Drom Sguabach[1065](javascript:footNote('T105008/note1065.html')), Ceathramha Meic Geirbli[1066](javascript:footNote('T105008/note1066.html')), and two other quarters not mentioned here.


{column 1}
‘Agus as iad slicht Taithligh do ben sin amach d'aimdeoin na cloinni oili agus da ceathromoin oile mar aon riu .i. Ceathroimi I Sgorra agus a Ceathroimi Caol.’


{column 2}
And the posterity of Taithleach got possession of these in despite of the other children, besides two other quarters, namely, Ceathramha Ui Sgorra[1067](javascript:footNote('T105008/note1067.html')) and Ceathramh Caol[1068](javascript:footNote('T105008/note1068.html')).


{column 1}
‘Agso cor agus cunnradh Tailtigh Muaidhi, .i. rí O bh-Fiachrach re Donnchadh Mor, .i. beth umal urramach do Taithlech Muaidhi ar son in ceatroimi rann do'n tír do thabairt do Donnchadh agus d'á slicht; Eirgi i mach umal, urramach do thabairt do Taithlech Muaidhi, ar son in ceathroimi rann do'n tir do tabairt do Donnchadh agus d'á slicht Eirgi imach umal innruic do thabairt do Taithlech Muaidhi ar uaisli a anma agus a inmhi, agus gach uair dá m-beidh éigean-dáil ar O'n-Dubda, Donnchadh agus a clann d'á freasdal fa n-dithcell. A chuid cuain agus caladh ag Donnchadh Mor féin agus aga slicht.’


{column 2}
The following is the compact and covenant of Taithleach Muaidhe, King of Hy-Fiachrach, with Donnchadh Mor, viz., that Donnchadh and his descendants should be obedient and submissive to Taithleach Muaidhe, in consideration of their having received the fourth part of the territory, *also* to furnish an obedient, submissive, and sincere Rising-out to Taithleach Muaidhe for the same consideration, and also for the nobility of his name and wealth; and whensoever the O'Dubhda should happen to be in jeopardy that they should assist him to the best of their ability. That Donnchadh Mor himself and his descendants should have their own portion of the harbours[1069](javascript:footNote('T105008/note1069.html')).


{column 1}
‘Dá m-beadh Goill no Gaoidhil a n-dubhthaig I Dubda Donnchadh Mór agus a chlann 


---

p.423



do thabairt uiread riú fein do Taithlech Muaidhi agus d'á cloinn agus a leitheid oili sin uadha-san agus adbert in Seancha annso:’


> 1. Callraigi Cuili na g-cnead
>   
> rachat innti d'á h-airem,
>   
> Cuil Chearnuga na g-call g-cas,
>   
> neam-dona in drong dán dúthchas.
> 2. Ceithri taisigh as tir t-suas
>   
> ag Callraigi na g-caom chnuas,
>   
> coinnmi dochaidh far g-cairt-ni,
>   
> cair sloindi na saor-maicni.
> 3. O'Cuinn is O'Rothlan reidh
>   
> ó h-Iarnan na n-arm n-aigmeil,
>   
> gan digbail do'n gleri Gall,
>   
> O'Finain in meine Mor Clann.
> 4. O bel Easa n-eas n-glan,
>   
> feadh na tuaithi si nár tubad
>   
> go Brosnaidh fa tend teni
>   
> do chosain ceann Callraigi.
> 




{column 2}
If the English or Irish should be in the country of O'Dubhda, Donnchadh 

Mor and his descendants should give as many as themselves[1070](javascript:footNote('T105008/note1070.html')) to Taithleach Muaidhe and his descendants, and the like from them to him. On which subject the historian has the following lines: 


> 1. Into Callraighi Cuile[1071](javascript:footNote('T105008/note1071.html')) na g-cneadh
>   
> I shall proceed to describe it,
>   
> Cuil Cearnadha of the knotty hazles,
>   
> Not unhappy the tribe in whom it is hereditary.
> 2. Four chieftains are in the upper country,
>   
> In Callraighi of beautiful fruit trees,
>   
> A festive party who have entered into our catalogue,
>   
> It is proper to name the noble party.
> 3. O'Cuinn and O'Rothlainn the ready,
>   
> O'h-Iarnan of dreadful arms,
>   
> Without injury to the choice of the foreigners, 
>   
> *And* O'Finain a prop of great descendants.
> 4. From Bel Easa of the clear cataracts,
>   
> The extent of the country which was not oppressed
>   
> To the Brosnach of impetuous current,
>   
> Which defends the head of Calraighi.
> 






---

p.424


{column 1}
> 1. O Bél Atha in fheadha anall
>   
> as e fairsing na b-fhearann
>   
> mar tam da d-taroill uile,
>   
> go Traigh alaind Eothailli.
> 2. Donnchadh Mor rug mar rogha
>   
> Cuil Cnama Cuil chearnumha
>   
> amarc súl is ráimhe lind
>   
> in chúil is áille d'Eirind.
> 3. O Borraig na sreabh solas, —
>   
> na bídh aon 'na amoras, 
>   
> Cúil cnáma in fearann ar fad
>   
> co tráigh nach dleagam do dearmad.
> 4. Do dhén do'n foirind éolus
>   
> in da chuil a g-comórtus
>   
> cúil ar gach ceann do'n tír
>   
> an geall ó gach cúil cluintí.
> 5. Tailtech Muaidhi, fa mór rath,
>   
> tigearna ar fonn O bh-Fiachrach,
>   
> atáid a chlann ó shoin alle
>   
> a g-ceann Donnchaidh 'sa chloinni.
> 




{column 2}
> 1. From Bel Atha an Fheadha[1072](javascript:footNote('T105008/note1072.html')), thither
>   
> Is the breadth of the lands,
>   
> As I am describing them all
>   
> To the beautiful strand of Eothuili[1073](javascript:footNote('T105008/note1073.html')).
> 2. Donnchadh Mor took as choice
>   
> Cuil Cnamha, Cuil Cearnadha,
>   
> A prospect to the eye the most delightful we deem
>   
> The most beautiful cuil *[angle]* of Erin.
> 3. From Borrach[1074](javascript:footNote('T105008/note1074.html')) of the bright streams, —
>   
> Let no one be in doubt of it, —
>   
> Cuil Cnamha embraces all the land,
>   
> As far as the strand, which we should not forget.
> 4. I shall afford intelligence to the tribe
>   
> Respecting the two cuils which are in competition,
>   
> A cuil at each extremity of the territory, 
>   
> The *palm* wager being won by each cuil was heard of[1075](javascript:footNote('T105008/note1075.html')).
> 5. Taithleach Muaidhe[1076](javascript:footNote('T105008/note1076.html')) of great success
>   
> *Became* lord of the land of Hy-Fiachrach,
>   
> *And* his descendants have been ever since
>   
> Over Donnchadh and his lineage.
> 






---

p.425


{column 1}
> 1. Ceathroimi cuid do'n tír tais
>   
> fuair Donnchadh ó Dún Durlais,
>   
> gach laoi a g-ceill da g-cuiri
>   
> mar taoi sa reim rigraidi.
> 2. Mile bliadhan, nocha brég,
>   
> annála Críst re coiméd
>   
> trí céd do bliadnaib brasa,
>   
> mar do silad in seancasa,
>   
> agus a dó re dearbad dam,
>   
> sa lo far ceangladh cunnradh.
> 




{column 2}
> 1. The fourth part of the irriguous land
>   
> Donnchadh of Dun Durlais obtained,
>   
> Which every poem makes known,
>   
> As he is in the regal catalogue.
> 2. A thousand years[1077](javascript:footNote('T105008/note1077.html')), it is no falsehood,
>   
> The era of Christ to be preserved
>   
> Three hundred of fleeting years,
>   
> As the history sets forth,
>   
> And two to be certified by me,
>   
> On the day the treaty was ratified.
> 




### L

### Inauguration of Irish Chiefs.


*See page 143.* — The inauguration of the ancient Irish kings and chieftains, has been so imperfectly described by modern Irish writers that the Editor is for this reason tempted to treat of it more fully in this place, in the hope that some readers may feel interested in the subject. We have unfortunately no minute or authentic account of the manner in which the pagan monarchs or chieftains were inaugurated or installed, the sum of what we are told on the subject being that the pagan Irish monarchs were made at Tara on a certain magical stone called the **Lia Fáil**, which was wont to emit a sound when the person about to be elected was legitimate. For some account of this stone, and the inauguration of Conaire Mor, at Tara, the reader is referred to **Petrie**'s History and Antiquities of Tara Hill, pp. 154, 155. (Transactions of the Royal Irish Academy, vol. xviii).


The oldest account of the inauguration of a king of the Irish race is that given by Cumin, who became Abbot of Iona in the year 657, who says (Vit S. Columbae; apud **Colgan**, Trias Thaum. p. 321,) that St Columba ordained Aidan King of Scotland, by imposition of hands. Adamnan also has the same statement (Vit. S. Col. lib. iii. c. 5). *Ibidemque Aidanum iisdem adventantem diebus, in regem, sicut erat jussus, ordinavit, 



---

p.426



et inter ordinationis verba, de filiis et nepotibus, pronepotibusque ejus futura prophetizavit, imponensque manum super caput ejus, ordinans benedixit.’’*

Vit. S. Col. lib. iii. c. 5


From a notice in an ancient Life of St Patrick, quoted by **Keating**, it would appear that twelve coarbs and twelve chieftains were always present at the inauguration of the King of Connaught, on Carn Fraoigh, near Tulsk; and this notice is corroborated by a passage in the Annals of Clonmacnoise, as translated by **Connell Mageoghegan**, which states that in the year 1316 Rory O'Conor, who attempted to wrest the kingdom of Connaught from Felim O'Conor, the rightful heir, ‘went to Carne Fraoigh, where he was invested King of Connaught by the twelve chieftains of Silemorrie, twelve coworbs, and other spiritualls that were accustomed to use the ceremonies usual at the time of the investiture of the king.’


From such respectable authorities, it is manifest, that since the introduction of Christianity into the country, the Irish kings and chieftains were inaugurated by the clergy, and that the ceremony was strongly marked with a religious character. But **Giraldus Cambrensis**, who came to Ireland about the year 1202, as tutor to prince John, has left on record the following very opposite account of the matter: — 
*Est in Boreali ac ulteriori Ultoniae parte apud Kenelconil gens quaedam quae barbaro nimis et abominabili ritu sic sibi regem creare solet. Collecto in unum universo populo terrae illius, in medium producitur jumentum candidum, ad quod sublimandus ille non in principem sed in belluam, non in Regem, sed exlegem, coram omnibus bestialiter accedens, non minus impudenter quam imprudenter se quoque bestiam profitetur, et statim jumento interfecto, et frustratim in aqua decocto, in eadem aqua balneum ei paratur, cui insidens, de carnibus illis sibi allatis, circumstante populo suo, et vescente, comedit ipse. De jure quo lavatur, non vase aliquo, non manu, sed ore tantum circumquaque haurit, et bibit. Quibus ita rite non recte completis, regnum illius et Dominum est confirmatum.’’*

Topographia Hibernica Dist. 3, c. 25.

 
This account of the mode of inaugurating the chief, or prince of Tirconnell, was probably never heard of in Ireland until after the publication of the works of **Giraldus**. The first who refuted it was **Keating**, who writes as follows in the Preface to his History:[1078](javascript:footNote('T105008/note1078.html'))
  

‘Ab eodem pingitur, seu potius fingitur, O'Donnelli Kinelconelliae Reguli inaugurandi ritus. Omnes (inquit) Regionis 


---

p.427




Incolae in editum quemdam collum primo convocabantur, tum equa candida mactata, amplissimaeque ollae in late patente campo collocatae injecta, et luculento subjecto igne assata, Regulus denunciatus, admotis ollae labris jusculum instar canis absorbebat; carnes nullo addito cultro dente discerpebat, et tandem devorabat, et reliquiis ad adstantes projectis, ipse jusculo instar balnei usus, totum corpus eo perfundebat, et proluebat.
  

Sed quis hoc splendidum esse mendacium inficiabitur, cum non solum nullus ejusmodi ritus ab accuratis rerum enarrationibus literis traditus deprehendatur, verum etiam disertis verbis renunciandi O'Donnelli Kinelconelliae Reguli ab iis memoriae prodatur in hunc modum: Quando quis O'Donnelli titulum insigniendus erat Kinelconneliae Nobiles et aliorum ordinum homines ad statum collum confluebant; tum e proceribus unus assurgens, peractis reverentiae debitae officiis, candidam virgam omnino directam, ac detorsionis omnis expertem, quam manu gestabat, denunciato Regulo porrigens, 'accipe, ait, auspicatum dignitatis insigne; hujusce virgae candorem, rectitudinemque moribus referre memento, ut nulla maledicendi libido factorum candorem nota ulla maculare, aut studium in amicos animum a justitiae rectitudine cuique praestande flectere possit: Imperium tibi debitum bonis avibus ini, et hujus Reipublicae fasces, securesque capesce.’


‘Haec cum ita se habeant facile adduci possum ut credam rumusculum hunc ab aliquo 



---

p.428



Hibernis infenso leviter enarratum a Cambrensi, homine nimirum ab Hibernis alieniore, avide captatum, et posteriati commendatum ad majorem infamiam Genti concilandam fuisse. Certe compertum est Nationem plagam illam incolentem, humanitate, benignitate, atque adeo pietate, per singulorum vicissitudines saeculorum sic splenduisse, ut illinc quam plurimi prodierint, qui fluxis terrae rebus desertis vitam continuato per asperiora pietatis exercitia cursu ductam faelici exitu terminaverunt; ejusmodi fuere SS. Columba, seu Columbkille, Baitinus, Adamnanus, compluresque alii; quorum a texenda hic nomenclatura modo supersedemus. Huc accedit quod nullus aequus rerum aestimator judicabit caeteros Hiberniae proceres fidei praesertim Catholicae apprime colentes, tam barbarum morem ullo pacto tolleraturos.’


And again, in the reign of Brian Borumha, he has the following more circumstantial account of the inauguration of the Irish chieftains (p. 223 of O'Mulconry's MS.):


‘Ex vetustis historiarum monumentis excerpsi, quos hic subjicio, ritus in Regum inaugurationibus adhiberi consuetos, sive ii totius Hiberniae Monarchae fuerint, sive provinciarum Reges, aut ditionum Toparchae. Nec alio quam Regum Titulo, quandam apud Hibernos provinciarum et minorum regionum domini insigniebantur; de aliarum gentium, et praesertim Judaeorum more, qui primo ducibus, deinde regibus, utebantur, sicut in Albania Dalriadi ante Fergusium, Ercae filium, Regem renunciatum Dynastis parebant. Causa vero cur 



---

p.429



unus Regia dignitate insignitus populis et regionibus praeficitur, est, ut quilibet in ejus Ditione constitutus illius jussa audiat, et impugnare non audeat. Neminem enim fugere debet supremam illam potestatem populum gubernandi Regibus a Deo, Regum Rege et Domino dominantium, conferri; ac proinde mandatis regis morem non gerere, perinde esse ac divinae ordinationi resistere. Hiberni olim quos prudentia et eruditione prae caeteris instructiores depraehendebant, eos plerumque ad dignitatem Regiam evehebant, ut gravioribus suppliciis scelera plecterentur, legum observatio securius vigeret, et pax firmius effloraret. Quibus praecipue de causis, Slangius Delae filius, Luighi nepos, supremi judicii officio per ea tempora functus; Ollamnus Follus, vir etiam eruditione clarus; et Cormacus Arturi filius jurium scientissimus, qui et opus egregium de principis institutione scriptum reliquit, Reges salutati sunt. Consuetudo itaque optima illa erat quae apud Hibernos primitus invaluit, ut quo quisque literatior et ad provehendam Rempublicam aptior et propensior videbatur, eo expeditius Regni gubernaculis admoveretur. Post autem Hiberniam fidei splendore Divi Patricii opera illustratam, et Ecclesiam suum fulgorem adeptam, ad Anglos Hibernia potitos, penes episcopos et antiquarios Regum et Dynastarum electio fuit; nec usurpati nunc honorum tituli Baronum, Vicecomitum, Comitum, Marchionum et Ducum tum erant in usu: sed similes honores adepti appellabantur *triath,* id est 



---

p.430



Dynastae seu Toparchae; *tighearna,* id est Domini, *flaith,* id est Satrape; aut *righ,* id est Reges; adjecto loco nomine cui dominabatur.’


‘Cum autem quispiam Regis aut Toparchae dignitatem inibat, Antiquarius aderat librum gestans Institutionem Regis inscriptum; Leges et Instituta Regionis illius, quam candidatus ille Regni vel Toparchiae administraturus erat, et praemia illi a Deo et populo conferenda, si Rempublicam bene gesserit, sin autem male supplicia illum et posteros manentia, complexum. In his enim rebus tractandis Liber Regum et Institutio Regis versantur.’


‘Saepius etiam ejus amici, praedes effecti, obstringebantur illum vel instituta Regionis, ex praescripto Institutionis Regum ad amussim impleturum, vel Regno se ultro, citra litem, abdicaturum. Nec Tuadedanani Bressum Magnum, Eleathani filium, regio titulo potiri ante passi sunt, quam ejus amici simili se pacto devincierint.’


‘Regi designato virgam antiquarius porrigebat, ac deinde conversus ad adstantes, arma regi ad suos in officio continendos in posterum minime necessaria pronuntiat: populum enim ei non secus ac discipulorum magistro morem genere debere adultiores discipulos et sui commodi intelligentes, semper praeceptoribus suis amorem, obsequium, et gratias deferre solere, et subditos ad similia officia Regi suo praestanda obligari, utpote qui jus iis justitiae virga, non ferri acie administrat. Virga Regi per antiquarium tradita tota



---

p.431



erat candida, ut veritatem et candorem illi mordicus observandum esse in regimine indicaret; uti enim nigredo mendacium, ita candor denotat veritatem. Illa etiam virga recta fuit, ut omnibus innotesceret Regem semper aequum et rectum spectare debere, nec verbum ullum aut judicium praeferre, quod injuriam sapere possit. Eum nimirum teneri amicis et inimicis, summis et infimis, aequitatem juxta exhibere, non secus ac si lite inter ambas manus orta, aequalem se utrique praestaret. Eadem etiam teres erat et nodi omnis expers, ut meminerit Rex irae se tubere *[aut]* asperie subditis minime praebere, sed composito sedatoque animo ac vultu, legibus sanctita suis pariter et alienis prout jus postulat, administrare.’


‘Totius Hiberniae Reges Teamoriae[1079](javascript:footNote('T105008/note1079.html')) in augurabantur, primoribus et antiquariis ante Christianismum huc illatum, assensum praebentibus: sed post Hibernos Christianismo imbutos Episcopis, proceribus et antiquariis suffragia ferentibus.’


‘Super lapidem Regium in Tulchoga[1080](javascript:footNote('T105008/note1080.html'))


---

p.432



O'Nelli nunciabantur ab O'Cathano[1081](javascript:footNote('T105008/note1081.html')) et O'Hagano[1082](javascript:footNote('T105008/note1082.html')), O'Dongholius[1083](javascript:footNote('T105008/note1083.html')) autem militiae ab O'Nello; Breslani[1084](javascript:footNote('T105008/note1084.html')) vero, et Clanbirthagri[1085](javascript:footNote('T105008/note1085.html')) rei judiciariae praeficienbantur’


‘O'Donnelli, Kilmacnenanae[1086](javascript:footNote('T105008/note1086.html')), ab O'Farghil[1087](javascript:footNote('T105008/note1087.html')) inaugurabantur, et O'Galchurum[1088](javascript:footNote('T105008/note1088.html')) militiae praefectum habebat.’


‘In Magh Adhor[1089](javascript:footNote('T105008/note1089.html')) O'Briano dignitas conferebatur a Macconmara[1090](javascript:footNote('T105008/note1090.html')): O'Duibhir de Coilnamanagh[1091](javascript:footNote('T105008/note1091.html'))et O'Gorman[1092](javascript:footNote('T105008/note1092.html')) erant



---

p.433



O'Briano a militiae praefectura; mac Glanchius[1093](javascript:footNote('T105008/note1093.html')) a jure dicendo; Clanchraith[1094](javascript:footNote('T105008/note1094.html')) a Poesi; et Clanchrutin[1095](javascript:footNote('T105008/note1095.html')) et Clanbruadein[1096](javascript:footNote('T105008/note1096.html')) a re antiquaria.’


‘Mac Cartho Magno[1097](javascript:footNote('T105008/note1097.html')) in Lisbanchor[1098](javascript:footNote('T105008/note1098.html')) insignia dignitatis porrigebat O'Sulevanus Magnus[1099](javascript:footNote('T105008/note1099.html')), et O'Donnchus Magnus[1100](javascript:footNote('T105008/note1100.html')) militaribus ejus copiis, et Ruarkus[1101](javascript:footNote('T105008/note1101.html')) suae ditionis imperabant; ad judicia exercenda Clanegani[1102](javascript:footNote('T105008/note1102.html')); ad carmina pangenda Muintir Dhali[1103](javascript:footNote('T105008/note1103.html')); Historias scribendas Muntir Dhunnin[1104](javascript:footNote('T105008/note1104.html')), ab eodem designabantur’




---

p.434


‘In colle Anbhogaidh Mac Morchuus[1105](javascript:footNote('T105008/note1105.html')) honoris sui titulum inibat; O'Nuelano[1106](javascript:footNote('T105008/note1106.html')) dignitatis eum ornamentis insigniente, et equum ejus atque paludamentum pro praestiti officii salario referente: O'Doran[1107](javascript:footNote('T105008/note1107.html')) Mac Murchuo fuit ab Historiis.’ *— **Dr. Lynch**'s translation, pp. 252, 253, 254.*


*[‘Apud Lec Mic Eochadho nominabatur Dominus de Hy-Kinselaigh, et Mac Keogh nominabat eum.
  

Apud Dun Caillighe Beirre O'Byrne nominabatur et mac Keogh nominabat eum.’]*


The next of the Irish writers who replied to **Cambrensis** and attempted formally to refute him, was the celebrated **Dr. Lynch**, author of the translation of **Keating**'s History of Ireland, which has just been quoted; his observations on **Giraldus**'s account of the inauguration of the prince of Tirconnell in his Cambrensis Eversus, are as follows:



---

p.435



‘Vides ut in huius tam faedi ritus delineatione omnes eloquentiae suae, non historicae, sed oratoriae thesauros non segniter effundit. Sicut enim oratores quem laudibus exornandum susceperunt, eulogiis ultra veri metas attollunt; sic **Giraldus** limites veri transiliens, omnes eloquentiae caninae machinas adhibet, ut istarum sordium infamia legentium animis altius infigatur. Nam *historiae severitas* (*inquit*) *nec veritati parcere novit, nec verecundiae.* Nimirum homo (si Diis placet) fidissimus verecundiae potius quam fidei jacturam facere maluit. Ut ille quem saepius infidum deprehendimus, inuerecundum etiam se hic agnoscat. Qui proinde illam Ciceronis objurgationem declinare non potest dicentis, *Qui semel verecundiae fines transierit, eum bene et graviter oportet esse impudentem.* Itaque cuius impudentiam vidimus, jactantiam etiam eiusdem videamus, *Rem hanc inhonestam venusta verborum vermilitate* (vt ipse loquitur) *depromere* pollicentis. Promissam quidem orationis *vermilitatem,* siue venustatem in superiori spurcae inaugurationis delineatione iam exeruit. Vt ex hac Giraldi ostentatione illam Stanihursti censuram prodiisse censeam dicentis: *Giraldum scriptorem meo sane indicio non ferreum suo plane aureum fuisse.*’


‘Sed qua veritate prolatae inaugurationis narratio fulciatur dispiciamus. Domestici certe scriptores eam disertis verbis funditus evertunt. Hac enim quam subjicio ratione Tirconelliae Regulos initiatos fuisse tradunt. Quando quis Odonelli titulo insigniendus erat, Tirconelliae proceres et aliorum ordinum ad statum collem confluebant. Tum e proceribus unus assurgens, peractis reverentiae consuetae officiis, candidam virgam, et omnino rectam, distortionisque omnis expertem quam manu gestabat, denunciato Regulo porrigens: accipe (ait) auspicatum dignitatis insigne, huius virgae candorem, rectudinemque moribus referre memento, ut nulla maledicendi libido factorum candorem nota illa maculare, aut studium in amicos animum a justitiae rectitudine cuique praestanda flectere possit. Imperium igitur tibi debitum bonis auibus ini, et huius Reipublicae fasces securesque secure capesse. Nunc igitur in eo controversiae cardo vertitur unine neganti, an pluribus affirmantibus illi rem auditione tantum, his aspectu comperientibus fides adhibenda sit? dispiciendum etiam si a domesticis scriptoribus veriora, quam ab uno advena producantur, et ab iis qui pro suo munere res gestas scriptis tradunt, quam peregrino falcem in alienam messem immittenti tabulis, et monumentis publicis, quam privati cuiusuis narrationi, quae non magis temere agyrtae alicui excidit, quam auide a scriptore inuido excepta, et posteritati commissa est. Certe Scriptores patrii non studio, sed officii sui adimplendi causa scriptis ista consignarunt, **Giraldus** res Hibernicas magis ex libidine, quam ex vero celebrat, obscuratque.’


‘Quis credat Divum Patricium, qui ditionem hanc accurate perlustrans, illius incolas in fidei documentis apprime instruxit, terrae principem Conallum Gulbanum



---

p.436



virtute sic informavit, ut laicum habitu, monachum vita egerit commissurum ut reliquorum scelerum surculis penitus evulsis, hanc unam spurcitiam tanquam pristinae superstitionis foecem non in obscuris aliquibus hominibus, sed in ipsis patriae luminibus inhaerere pateretur? Quod si S. Patricii vel notitiam, vel sollicitudinem tam obvia, et in tam clara luce collocata foeditas (quod credibile non est) subterfugeret; cognitionem profecto et reprehensionem plurimorum sanctorum in Tirconallia longo post temporum decursu commorantium declinare non potuit. Amplius quam quinquaginta sancti ex uno Conallo Gulbano prodiisse memorantur, quorum plurimi sedes in Tirconallia fixerunt, et caenobia plusquam viginti condiderunt. Duae praeterea sedes Episcopales Rapothensis, et Dorensis in eadem ditione constitutae sunt; in quibus quot Episcopi et monachi morabantur, tot in iis tanquam in speculis erant vigiles longe lateque prospicientes collocati, quos adeo perspicua macula tam diuturno temporis curriculo latere non potuit*.* Nec enim in latebris, sed in propatulo, nec inter plebejorum ultimos, sed in optimatum coetu sordes istae frequentabantur. Ut tam perspicacium virorum cognitionem, et purioris vitae sectatorem animadversionem effugere non potuerint.’


‘Pluribus e Dorensium Rapothensiumque Episcoporum, Abbatumque serie non solum summa consuetudo ac familiaritas cum Tirconalliae Regulis, sed etiam cognationis contiguitas intercessit. Ita ut si Principum reverentia praesules ab iis objurgandis deterrebat; certe praesulum erga cognatis studium ad eos e feritate tanta eruendos attraheret. Putabimus ne SS. Columbam, Baithenum, Laarenum, Fergnaum, Suibhneum, Adamnanum, aliosque viros sanctissimos, in his partibus natos et pietatis informationem nactos, et impertitos acerrimos vitiorum proculcatores hos sentes, et tribulos increpationis falce non demessuisse? Quos si potestas istius mali abigendi defecisset, certe SS. Moelbridius et Malachias Hiberniae Primates hinc oriundi ritum adeo perversum latius serpere non paterentur. Nec ipsi principes crebra in alios liberalitate, in Deum pietate insignes, qui se multis humanissimos pluries exhibuerunt, Principatus initium ab inhumanitate tam execrabili ducerent. Qui si hanc impudentiam non vitro ponerent, eam supremi Reges Hiberniae, severis legibus proculdubio coercerent.’


*Nullibi certe tam foeda alibi ludicra initiatione aliqui principatum auspicantur. *In Carinthia quoties novus princeps Reipublicae gubernationem init, solemnitatem nusquam alibi auditam observant. In patentibus pratis erectis lapus marmoreus est, quem cum dux creandus est rusticus quidem, cui per stirpis suae successionem haereditario id officium debetur, ascendit, ad dextram bovem habens foetam nigri coloris, ad levam equa illi sistitur strigosa macieque insigni, frequens circa populus agrestiumque turba ingens. Dux inde futurus ex adverso movet purpuratorum multitudine saeptus precedunt Principatus signa,



---

p.437



omnesque in toto comitatu egregie culti praeter futurum ducem. Is agresti habitu, pileo tectus, calceos et pastoralem baculum gerens pastorem agit, magis quam principem. Hunc venientem intuitus qui lapidem obtinet Illirica voce quis est hic exclamat, qui tam superbe incedit? Respondet circumfusa multitudo Principem regionis adventare. Tum ille iustusne iudex? Salutem patriae quaerens? liberae conditionis? Dignusne honore est? Christianae pietatis cultor, ac defensor? Clamatur: est quidem et erit. Rursus idem, quaero quo me jure hac a sede dimovebit? Respondet Ducalis aulae magister, sexaginta denariis hic a te locus emitur, iumenta haec tua erunt, ad bovem et equam manum intendens, vestimenta quae Dux exuet habebis; erisque tu cum domo tua tota liber a tributo. Quibus dictis rusticus malam percutit alapa leviter incussa, iubetque aequum iudicem esse, praemioque abducta loco cedit. Tum lapidem Dux occupat, nudum gladium vibrans ad omnem se partem vertit, populum affatur, polliceturque se aequum iudicem futurum, ferunt et aquam agresti pileo oblatam potare, in futurae sobrietatis argumentum, &c., imperium Austricae Principes obtinent, et Archiducem appellant.*’’*

Joannes Auban de Moribus gent. lib. 3, cap. 18.


*Nec mirum est in Principum inferioris ordinis inauguratione ludicros gestus adhiberi; quando Imperator ipse Romanus post coronam auream a Pontifice receptam in montis Martii bis mille passus Roma dissiti vertice manu elata se gyrat dicens: *‘Omnia quae videmus nostra sunt’* &c.’’*

Cambrensis Eversus, pp. 315, 316, 317.


To the foregoing observations of **Keating** and **Lynch** the Editor has to add, that most probably **Giraldus** never himself saw the ceremony of the inauguration of the prince of Tirconnell; and that he, therefore, repeated it from the report given him by some enemy of the Irish, as he did many other silly stories, such as the legend of the eruption of Lough Neagh, the legend of the speaking wolf, which predicted that the English would subdue the Irish, the story of the men who were wont to turn stones into red pigs and sell them at fairs, &c. &c. That he was never in Tirconnell, and therefore could not have been an eye-witness to the ceremony of the inauguration of the prince of Tirconnell, is pretty clear from his own words, in his Hibernia Expugnata, from which it can be inferred that he never dared to travel beyond the limits of the English power in Ireland, for, speaking of the English who had ventured into the territories of the Irish, he says, *‘Ubi capti decapitati, non redempti sed interrempti.’*


That **Giraldus**'s account of the inauguration of the prince of Tirconnell is a fabricated falsehood, and of a similar character with many others of his stories, is clear from the fact, that the Irish writers themselves, who often allude to Irish customs barbarous enough to modern ideas, never make any allusion to such a form of inauguration, and it is not for a moment to be supposed that the form used in inaugurating the prince of the Cinel Conaill tribe was different in any material point from that adopted by the



---

p.438



prince of the Cinel Eoghain, or any other of the ancient Irish septs. But happily for the character of the ancient Irish, the form of inaugurating their chieftains continued in full force, to its utmost acme of barbarity, till the reign of James I. of England, and we have on this subject the testimony of **Spenser**, who does not appear to have read a word of **Cambrensis**'s great work on Ireland, and who, though pretty well primed with prejudices against the native Irish, still lived so near the age of historical veracity that we may safely believe him, particularly on this point, whereon he does not materially differ from the account left us by the native Irish writers of the usual form of the inauguration of their chieftains. **Spenser** lived many years in Ireland in the reign of Queen Elizabeth, and in his curious work, entitled View of the State of Ireland (which is written in the shape of a dialogue between Irenaeus and Eudoxus), he gives the following account of the inauguration of the Irish chieftains:

> 
> ‘*Eudox.* What is this which you call Tanist and Tanistry? they be names and terms never heard of nor known to us.’
>   
> 
> ‘*Iren.* It is a custome amongst all the Irish, that presently after the death of one of their chief lords or captaines, they doe presently assemble themselves to a place generally appointed and knowne unto them, to choose another in his steed, where they do nominate and elect, for the most part, not the eldest sonne, nor any of the children of the lord deceased, but the next to him of blood, that is, the eldest and worthiest, as commonly the next brother unto him, if he have any, or the next cousin, or so forth, as any is elder in that kindred or sept; and then next to him do they choose the next of the blood to be Tanist, who shall next succeed him in the said captainry, if he live thereunto.’
>   
> 
> ‘*Eudox.* Do they not use any ceremony in this election? for all barbarous nations are commonly great observers of ceremonies and superstitious rites?’
>   
> 
> ‘*Iren.* They use to place him that shalbe their Captaine upon a stone, alwayes reserved for that purpose, and placed commonly upon a hill; in some of which I have seen formed and ingraven a foot, which they say was the measure of their first captaine's foot, whereon hee standing receives an oath to preserve all the auncient former customes of the countrey inviolable, and to deliver up the succession peaceably to his Tanist, and then hath a wand delivered unto him by some whose proper office that is; after which, descending from the stone, he turneth himself round, thrice forward and thrice backward.’
>   
> 
> ‘*Eudox.* But how is the Tanist chosen?’
>   
> 
> ‘*Iren.* They say he setteth but one foot upon the stone, and receiveth the like oath that the captaine did.’
> 
> 
> 


Dub. edit. p. 11, printed from the first edition, 1596.


Another writer who appears to have seen the ceremony of inaugurating an Irish chief with his own eyes, **Philip O'Sullevan Beare**, being born about the year 1588, and 



---

p.439




who had never read a word of **Cambrensis**'s work, thus describes the ceremony in his Historiae Catholicae Ibernicae Compendium, tom. i. lib. 3, fol. 33, p. b. 

> ### Ibernorum magnatum inauguratio, et apud eos esse novos aliarum gentium titulos
> 
> 
> ‘Inaugurantur vero Iberni optimates, vel alii ab aliis, vel ab illis, quibus more maiorum est consecrandi facultas data. Ad quod in locum inaugurationi constitutum conveniunt, longis hominum agminibus, et solemni pompa comitati. Ibi intersunt iudices, qui, cui candidatorum principatus debeatur, ex jure, legibusq*ue* pronuncient. Mox consecrandi jurare coguntur, nunquam se contra fidem Catholicam aliquid machinaturos, aut permissuros, ut clientes, obaerati et suae dictioni subjecti moliantur. Quin etiam, si necesse habeant, sanguinem pro ea effusuros, et mortem oppetituros: subjectos sibi in officio contenturos, et inter eos justitiam exercituros. Inde a sacerdote sacrum Missae peragitur, et virga consecratur, quae in sceptrum novo principi traditur, qui certis et conceptis verbis, ab eo, qui inaugurat, prolatis, vel Osullevanus, vel Orellus, vel alius creatur et appellatur, et a circumstantibus renunciatur, nec amplius proprio baptismatis nomine solet vocari. Sic vetustati placvit nec hodie etiam displicet, etsi Marchionis, Comitis, Vicecomitis et Baronis dignitates quas Ibernia diu respuit, his antiquissimis titulis posthabitis, jam sint in magno usu et honore.’
> 
> 
> 




This account of the inauguration of the Irish chieftains, by **Philip O'Sullevan Beare**, may be objected to, on the grounds that as there was no difference of religion among
the Irish until shortly before the discontinuance of the custom of electing Irish chieftains, so there could have been no necessity of swearing to defend the Catholic faith. But it is highly probable that such Irish chieftains as were inaugurated in Munster during the rebellion of the Earl of Desmond, were obliged to swear that they would defend the Catholic faith to the utmost of their ability. In this view **O'Sullevan**'s account may be regarded as correct, but it seems improbable that before the reign of Elizabeth, the chief to be elected was required to swear that he would defend the Catholic faith. This was a notion that sprang up in **O'Sullevan**'s time, which then told very well among the Spaniards, who patronized the Irish; and it will be remembered that **O'Sullevan**'s book was chiefly intended to rouse the Spaniards to sympathy with the Irish. It is highly probable, however, that the chief to be inaugurated was made to swear to the coarbs of the Church in his territory that he would preserve the rights and immunities of their churches, and to the utmost of his ability prevent the neighbouring chieftains from plundering their sanctuaries and termon lands. The next point which looks suspicious in **P. O'Sullevan Beare**'s account is the consecration of the rod by a priest. No mention is made of such a consecration by **Keating**, who was



---

p.440



coeval with **Philip O'Sullevan Beare**, and who must have seen the ceremony as well as he, and no reference to such is found in any native Irish account; and indeed it looks very strange that if the wand were consecrated by a priest, it should not have been presented to the chief by the bishop, or one of the coarbs of the churches, rather than by the bard or lay chieftain. The fact seems to be, that the rod was not consecrated by any religious ceremony, but it is highly probable that when Dr. Sanders was sent to Ireland to instruct the Geraldines, he suggested to the Earl of Desmond that such Irish chieftains as were to be inaugurated in Desmond should be called upon to swear to defend the Catholic faith, and that the wand should be consecrated to render the ceremony more solemn and sacred. That the rod, however, was handed to the chief by the **ollamh** or chief poet, or by the historian or chronicler of the district, or by another chieftain, will be sufficiently obvious from the following authorities:
  

1. In a tract entitled Teagusc Righ, preserved in the Library of Trinity College Dublin, H. 1, 17, it is stated, that the Bard read the heads of this work to the chief to be inaugurated, and asked him if he were willing to preserve inviolable the laws written in this book, which when the chieftain had answered in the affirmative, he was presented by the bard with a rod.
  

2. The following account of the inauguration of the O'Dowd, inserted in the Book of Lecan in a beautiful hand, very nearly as ancient as the original, and which is undoubtedly authentic, will show that although bishops and the coarbs of churches were present at the ceremony, still the rod was handed to the O'Dowd *or rather, as we are told by the writer of the Book of Lecan, was raised over his head by Mac Firbis, in token, no doubt, of the influence which the latter exercised over him by his advice and writings; and it is scarcely credible that the rod would have been so raised by the poet, if it had been previously consecrated by a priest, as **Philip O'Sullevan Beare** asserts.*.


{column 1}
‘Agus tús dígi d'O'Caomain ó Ua n-Dubda; agus gan O'Caomain d'a h-ibhi no go tuga sé do'n fhilidh h-í, .i. do Mac Firbhisig, agus arm agus earradh, agus eich h-I Dubhda tar eis anma do ghairm dhe d'O'Caemain, agus arm agus earradh h-I Chaomain ag Mac Firbishigh; agus ní dingmhála O'Dubhda do gairm co brath, no go n-goiridh O'Caomain’


{column 2}
‘And the privilege of first drinking *[at the banquet]* was given to O'Caomhain by O'Dubhda, and O'Caomhain was not to drink until he first presented it[1108](javascript:footNote('T105008/note1108.html')) *[the drink]* to the poet, that is, to Mac Firbis; also the weapons, battle dress, and steed of O'Dubhda, after his nomination, were given to O'Caomhain, and the weapons and battle-dress of O'Caomhain, to Mac Firbis, and it is not lawful ever to nominate the O'Dubhda until O'Caomhain’




---

p.441


{column 1}
‘agus Mac Firbisigh an t-ainm, agus nó go n-abra Mac Firbisigh corp na slaiti os cinn h-I Dubhdha; agus gach cléirech, agus gach comharba cilli, agus gach Esboc, agus gach taoisech feroind do radha an anma a n-diaigh h-I Chaomain agus Meic Firbisigh; agus ata ní cena, da tegmad a Tir Amalgaid O'Dubhda ’


{column 2}
‘and Mac Firbis *[first]* pronounce the name, and until Mac Firbis brings the body of the rod over the head of O'Dubhda; and after O'Caomhain and Mac Firbis every clergyman and comharba of a church, and every bishop[1109](javascript:footNote('T105008/note1109.html')), and every chief of a district’




---

p.442


{column 1}
‘do bu dolta dho co Carnn Amalgaid do gairm anma dhe, ach go m-beith na taoisigh faris: agus no da tegmad a Carnn’


{column 2}
‘pronounce the name. And there is one thing, should O'Dubhda happen to be in Tir Amhalgaidh *[Tirawley]* he may repair to Carn’




---

p.443


{column 1}
‘ingine Briain h-é, nír dholta do anonn do ghairm an anma, agus nir thigthi do anall ó Carnn Amalgaid, áir is é Amalgaid mac Fiachra Algaidh, do tochuil an carnn’


{column 2}
‘Amhalgaidh[1110](javascript:footNote('T105008/note1110.html')) to be nominated, so as that all the chiefs are about him: but should he happen to be at Carn Inghine Bhriain[1111](javascript:footNote('T105008/note1111.html')) *[in Tireragh]* it is not necessary’




---

p.444


{column 1}
‘do féin do cum ainm tigearna do gairm de fein agus da gach duine dá n-gebadh flaithes na diaigh, agus is ann atá Amalgaid fein adhluici, agus is uadha ainmnigter an carnn; agus gach righ do clandaib Fiachrach nach goirfeadh ainm mar sin biaidh gair seichle do, agus ní ba h-oirrdric a shil nás a seimead agus ni fhaicfe flaithius De co brath. Finit Amen.’


{column 2}
‘for him to go over *[the Moy]* to have the title given to him, and it is not necessary for him to come across *[to Carn Inghine Bhriain]* from Carn Amhalgaidh, for it was Amhalgaidh, the son of Fiachra Ealgach, that raised that carn for himself, in order that he himself, and all those who should obtain the lordship after him, might receive the style of lord upon it. And it is in this carn that Amhalgaidh himself is interred, and it is from him it is named. And every king of the race of Fiachra that shall not be thus nominated, he shall have shortness of life, and his race or generations shall not be illustrious, and he shall never see the kingdom of God[1112](javascript:footNote('T105008/note1112.html')). Finit Amen.’


3. We are informed by **Philip O'Sullevan Beare** that one chief was often inaugurated by another. Of this we have a good example on record in the Court of Chancery in Ireland, namely, an abstract of a law suit which took place in 1592, before the Lord Chancellor, Adam Loftus, between Donell O'Donovan of Castle Donovan, chief of his name, and his brother Teige O'Donovan, who attempted to depose him, but failed. This document is of great importance to this inquiry, as the case was decided according to the Irish custom of Tanistry, and as it is perhaps the only registered law document in which the custom of inauguration of the Irish chieftains is distinctly recognized. The Editor is therefore tempted to present the reader with extracts from it.


> To His Honorable Lordshipp the Lord Chancellor,
> Sheweth,
>   
> 
> Your poore Supplicant Teige O'Donovane of Castledonovane, in the county of Corke, Gente. —That whereas he was seised in his demesne as of fee of the Manors,
> 
> 
> 
> ---
> 
> p.445
> 
> 
> 
> Castells, Towneshipps, Lands, &c., of the Lordshipp of Clancahell, was wrongfullie disseised by Donell O'Donovane, comonlie called O'Donovane of Castle Donovan; and as the said Donell is a man of greater wealth and alliance in those parts your Supplicant may not have indifferent tryall at common lawe, and that the premises doe alsoe lie in a remote countrey, that therefore it may please your Lordshipp to cause the said Donell to appeare before your Lordshipp to answer to the premises.
> 
> 
> Donell O'Donovane in answer saith, that the O'Donovan for the time being hath bene tyme beyonde the Memorie of Man seised of the said Lordshipp and hereditaments of Clancahell, and that the Custom of Carebry, where the said Lordshipp lies, is, and hath bene tyme beyond Memory, that the chieftaine of the said contrie of Cairbrie, called Mac Cartie Reough, and the moste parte of the gentlemen of the said contrie have and had the ellection, nomynatinge, and appointinge of the O'Donovan, for the tyme beinge, of one of the best and worthiest of the said Name, and whosoever the said Mac Cartie Reough and the greatest part of the said Gentlemen should nominate, appoint, and ellect for O'Donovan, and signifie the same by delivering a Rodd to the person so chosen, by the hands of the said Mac Cartie Reoughe, he should have and enjoye, during his lyfe, the said Castells, Lordshipps, and other hereditaments. — By virtue whereof one Dermot O'Donovan[1113](javascript:footNote('T105008/note1113.html')), Great Grandfather to this defendant, being ellected and having received a Rodd of the said Mac Carthie Reough, enjoied the same, and after his decease one Dermond mac Conogher O'Donovan[1114](javascript:footNote('T105008/note1114.html')) beinge ellected, enjoied 
> 
> 
> 
> ---
> 
> p.446
> 
> 
> 
> the same during his life, and after his death one Donell Mac Dermott[1115](javascript:footNote('T105008/note1115.html')) being ellected, O'Donovan was also seised during his life, and after his death one Teige mac Dermond[1116](javascript:footNote('T105008/note1116.html')) O'Donovan being ellected was likewise seised of the said Contrie, and after his death one Daniel Mac Teige[1117](javascript:footNote('T105008/note1117.html')) O'Donovan, father to the Defendant, being elected, was likewise seised of the said Lordship during his life. And after his said Father's death, Sir Owen Mac Cartie, Knight, being Mac Cartie Reough, and chieftain of Carebrie, and the greatest part of the gentlemen of the said Countrie of Carebrie, have ellected, chosen, and nominated the defendant *[as]* O'Donovan, as best and worthiest of the said seapt of O'Donovans, and Mac Cartie delivered him a Rodd wherefore he entered to all the Lordshipp and Lands, and was seised without interruption these eight years past, as was and is for him lawful.
> 
> 
> Whereto Teige O'Donovan replied, that he admitted that Mac Cartie Reough being lawfullie Mac Cartie, and no intruder, by assent of most of the freeholders, did use to invest and instal the worthiest of the O'Donovans in the chieftainrie, before which installacion the right of the chieftainrie, with the freehold and inheritance, was cast upon the said Worthiest of the O'Donovans, so as the investinge or installment did yield unto him but the name of Chieftane having the freehold and inheritance cast upon him theretofore; and, therewithall, by the usage and custom of the said contrie, an illegitimate, or base sonne, was to be secluded and put besides the Chieftainrie, Signorie, and inheritance, so that he that was lawfullie borne was ever interested by Custome in them and no bastard: and Donell mac Teige O'Donovan, father to this complainant, and supposed father to Donell, was seised of all those lands, and so died, having yssue this Complainant lawfullie borne, aud after espousalls with Ellen Ny-Learie, and the Defendant Donell was borne by the said Ellen before the said intermarriadge, so as the said Donell is base borne, and by the said Custome to be secluded. And howbeit Sir Owen Mac Cartie hath invested Donell in the said Chieftainrie, yet as this Complainant at that tyme was, and is yet within twenty-one years of adge,
> 
> 
> 
> ---
> 
> p.447
> 
> 
> 
> therefore Donell being base-born, was not nor is yet capable. Besides that one Donell Mac Cartie is intituled to be Mac Cartie Reough, whereunto he had right by Her Highnes' Pattents, so as Sir Owen is an intruder, and the installment of Donell O'Donovan by said Sir Owen, who is an intruder, is avoyded, who is mightilie supported by Sir Owen by his potency and greatnes, for that Donell O'Donovane matched in marriage with a daughter of said Sir Owen: Werefore the Complainant prayeth humblie release from your Honorable Lordship.
> 
> 
> Whereto Donell O'Donovane rejoineth — that Sir Owen Mac Cartie, now Mac Cartie Reough, was lawfullie intituled to the Chieftainrie of the Contrie of Carbrie, and lawfully seised as best and worthieste of the Mac Carties of Carbrie at the tyme of delivering the Rodd to this rejoinant, whoe mainteyneth himself to be best and worthiest of the blood of the O'Donovans, and saith he was borne after espousalls betwixt Donell mac Teige, his father, and father to the Complainant, and the said Ellen Ny-Learie, their mother, and not before. He also saith that the custom of the Countrie warranteth that Bastards, especiallie Muliers, by the Civill Law, might be O'Donovans: that the last Chieftain claymed the said Contrie but durynge his lyfe by the said custome, and not as his inheritance, so as nothinge could descend from him; and therefore forasmoche as this defendant is lawfullie intituled and seised of the said contre as ‘O'DONOVAN,’ being best and worthiest of the bloud of the O'Donovans, and lawfullie is vested ‘O'DONOVAN,’ according the Custome tyme beyond the Memorie of Man, all which he is readie to averr.
> 
> 
> Teige O'Donovan to this further replies, that Sir Owen Mac Cartie is an intrudor and the Ceremony of giving a Rodd by him is not by the usadge of the said Lordshipp warrantable; further, if it fall out that Donell is illegitimate, as indeed he is, then is the averrment untrue, alledging him to be beste and worthiest of the O'Donovans, &c. &c.
> 
> 
> Uppon all which matters Commissioners were chosen of both parties to examine their wytnesses — whereupon it was directlie proved by diverse good witnesses, and especiallie by Sir Ffynen O'Driscoill, Knight, and diverse good gentlemen, that Donell was born many years after the marriadge solempnised at Dromale, in the county of Corke, betwixt Donell mac Teige and the said Ellen Ny-Learie, his mother, who had other sons elder than Donell[1118](javascript:footNote('T105008/note1118.html')), the Defendant, by reason whereof the complainant being
> 
> 
> 
> ---
> 
> p.448
> 
> 
> 
> his younger brother, he had no title against the said Donell, the said Lordshipe being customarie, and Donell having proved the custome and his ellection as O'DONOVAN; — and for that it was proved that the father of both was made O'Donovan, and died seised of the Lordship and hereditaments of Clancahell, and the said Sir Owen Mac Cartie was Chieftain of Carbrie, by right, and not by usurpation, when he delivered a Rodd to Donell, now ‘O'DONOVAN’; and Donell being the elder brother of Teige, the Complainant, being bothe born of one father and mother after marriadge dulie celebrated betwixte them accordinge to the rites and ceremonies of the holie church, he had beste right to inherit or succeede their said father, and to be O'DONOVAN, and to have and enioie the Lordship, lands, tenements, and hereditaments of Clancahell.— And it is soe adjudged and Decreed, and the said Donell shall recover his charges and costs sustayned in this cause against the said Teige.— Yeoven at Dublin the 12th daie of Ffebruarie Anno Domini, 1592.
> 
> 
> Ad*am*. Loftus, Canc.




The form of the inauguration of the O'Donovan is more circumstantially described by John Collins of Myross, in his pedigree of the late General Richard O'Donovan of Bawnlahan. It is to be feared that he has supplied some things from his own imagination, which we know was sufficiently creative, for he was a poet, and though but a rude English scholar, he was the author of the beautiful Irish poem entitled Soliloquy in Timoleague Abbey, published, with an admirable translation by Furlong, in **Hardiman**'s Irish Minstrelsy, vol. ii. p. 235. But he is entitled to some credit, as he was well acquainted with Irish history, and knew the traditions of the mountains of Carbery better than any person living in his time. The following is the account which he has given of the inauguration of Donell mac Teige O'Donovan, the father of Donell and Teige mentioned in the foregoing document; an account which, if true, presents a dreadful picture of the lawless ferocity of the times. After giving an account of the escape of Donell mac Teige in his infancy from



---

p.449



being murdered by his relatives, the friends of his father and enemies of his mother, he proceeds as follows:
  

‘Immediately after this had happened, his mother *[Helena Ny-Donovan]* took him away privately out of the reach of his enemies, and with him took refuge in Ibh Leary, at O'Leary's mansion castle Carrignacurra, where they remained in a state of concealment under borrowed names, until he came to a proper age and was well educated, as Denis na Meeny always supplied his daughter and grandson privately with money and every other necessary wanting to them. When he came to the age of twenty-one years his mother divulged his name and parentage, and consequently that he was the lawful heir to the title and lordship of O'Donovan. O'Leary gave him his daughter Helena O'Leary in marriage with a great fortune, and soon after a splendid retinue and well appointed body of his friends attended him to Carbery, there to take possession of his ancient lands and royalties. He was received with joy and congratulation by his grandfather Denis na Meeny the elder and his son Denis na Meeny the younger, and by their party, as also by Mac Conolly, who had served as captain under his father and grandfather, and whose ancestors, for a long time prior to that period, had been a kind of hereditary life guard to the O'Donovan family, and on that account had seven ploughlands assigned to them by O'Donovan in the parish of Drinagh. At the same time a Jeremiah Donovan of a collateral branch was laying in a claim for the property, and was candidate for the name. This Jeremiah, who was called *Diarmuid a Bhairc*, or of the Bark, from having been bred at sea, had a large party to espouse his claim, and amongst which was Ire Donovan of Castle Ire,’ *[recte, Castle Ivor]* ‘with his relations and followers, and the Sliocht Tioboit, or posterity of Tioboid, of which we have spoken before.’


‘The election was to be held in the town of Ross Carbery, under the superintendance of Mac Carthy Reagh, Prince of Carbery, who then dwelt at Binduff Castle, now Castle Salem, and who had the hereditary power of inaugurating the O'Donovan. The form of the inauguration was to give the chosen candidate a straight white wand in his right hand, as an emblem of unbiassed rectitude, and to cause him to swear solemnly to rule with strict justice and equity, as in those times every representative, or head of a family, was absolute in his own principality, and had a gallows and fosse, the former for the punishment of male criminals and the latter for that of the female ones.’


‘When the appointed day for the election came, Denis na Meeny and his party fell off to the south and met Ire with a division of his party at Ballaghalow, in the parish of Kilmackabea, to the west of Ross, slew himself, and cut off his party to a man. Captain Conolly, in company with Donell na g-Croiceann O'Donovan, O'Leary, and their party, 



---

p.450




took the near way from Dromaleague to Ross, through the parish of Drinagh, and on his arrival found Diarmuid a Bhairc inaugurated, with the rod of justice in his hand, in the presence of Mac Carthy; wherefore he sternly demanded of Mac Carthy the reason, and, without waiting for a reply of any kind, ran Diarmaid a Bhairc through the body, who instantly expired. On which Donell na g-Croiceann was inaugurated and saluted O'Donovan! As many of the party and supporters of Diarmuid a Bhairc as were found in the streets of Ross were slaughtered and slain. The castle of Ire’ *[Ivor]*, ‘in the parish of Myross, was partly broken down and his lands taken and possessed by O'Donovan, and what survived of that branch were forced to quit that part of the country. The castle of Gortnaclough was also stormed, taken, and partly destroyed, and its lands taken by O'Donovan,’ &c. &c.


This, however, cannot have been the original form of the inauguration of O'Donovan, neither was Ross Carbery the original locality at which the ceremony was performed, for, previously to the beginning of the thirteenth century, the sept were seated along the River Maigue, in the present county of Limerick, and the chief resided at Croom, or Bruree, and the probability is, that he was inaugurated on the moat at Bruree, not by Mac Carthy, but by his own people of Hy-Figinte. When the O'Donovans were driven out of the plains of Hy-Figinte, they encroached on O'Driscol and others, and taking their tribe name with them, transferred it to the territory over which they had acquired dominion, and which had been previously called Corca Luighe[1119](javascript:footNote('T105008/note1119.html')); and we find that in the year 1200 Auliff, or Amlaff, More O'Donovan, who was slain at Kinneigh in that year, is mentioned in the Annals of Innisfallen as chief of the territory of Carbry, a name then recently transferred to Corca Luighe. But the descendants of Donell God *[the stammering]*, the son of Donell More na Curra Mac Carthy, who died in 1185, increasing mightily in numbers and power, elected a chieftain for themselves



---

p.451



distinct from Mac Carthy More, and triumphantly obtained dominion over the whole barony of Carbery, in the county of Cork, and compelled O'Driscol, O'Donovan, O'Mahony the Western, and other septs, to pay them tribute as conquerors of the territory


Another part of the ceremony of inauguration not mentioned by any of the writers already quoted, is noticed in the Annals of the Four Masters, namely, that in many cases when a superior chief was inaugurated by an inferior chief, the latter put on his shoe or slipper — See these Annals at the years 1461 and 1488, where it is stated that at the inauguration of the chiefs of the O'Conors, Mac Dermot, chief of Moylurg, put on his shoe. It is also stated that in inaugurating the chief of the O'Neill family, O'Kane threw a shoe or slipper over the head of the prince. It is rather strange that Keating should not have noticed this ceremony.


From the foregoing authorities we may infer that the following conditions were generally requisite to constitute a legitimate instalment or inauguration of an Irish chieftain:
  

1. That he should be of the blood of the original conqueror or acquirer of the territory, and free from all personal blemishes, deformities, and defects, and be of fit age to lead the clan to the field.
2. That the greater part of his sub-chiefs and freeholders should declare in his favour.
3. That the inauguration should be celebrated at a remarkable place in the territory appointed of old for the purpose, where there was a stone with the impression of two feet, believed to be the size of the feet of the first captain, chieftain, or acquirer of the territory.
4. That the hereditary historian or chronicler of the territory should be present to read to the chief about to be installed the heads of the law relating to the conduct of the chieftain, and that the latter should swear to observe those laws and to maintain the customs of the territory inviolable.
5. That after taking this oath, the chief laid aside his sword and other weapons, upon which the historian of the district, or some other person whose proper office it was, handed him a straight white wand as a sceptre and an emblem of purity and rectitude, to indicate that his people were to be so obedient to him that he required no other weapon to command them.
6. That after receiving this straight white wand, one of his sub-chiefs put on his shoe or sandal in token of obedience, or threw a slipper over his head in token of good luck and prosperity.
7. That after the foregoing ceremonies were performed, one of his sub-chiefs pronounced



---

p.452



his surname without the christian-name in a loud voice, after whom it was pronounced in succession by the clergy according to their dignity, and by his subchiefs and freeholders according to their respective ranks. After this the chieftain turned round thrice forwards and thrice backwards, in honour of the most holy Trinity, as the Irish still do all good things, and to view his people and his territory in every direction; which being done he was the legitimate chief of his name.



On the subject of the inauguration of Christian kings, the evidence given by Cumin and Adamnan, as above noticed, is the oldest on record. The most ancient authorities given by Selden for the coronation of Christian emperors, and for that of the Kings of France and England, are subsequent to the time of Adamnan, who died on the 21st of September, 704, in the seventy-seventh year of his age. The sacred cruet of Rheims, used in anointing the Kings of France, is not mentioned previously to the ninth century. In the Notitia Episcopatuum, printed at Rome in 1533, we are told that the ancient kings usually consecrated, according to the ceremony of the Roman Ritual, were those of Castile, Arragon, Ireland, Scotland, Poland, and Hungary. It is highly probable that the monarchs of Ireland, since the introduction of Christianity, were inaugurated by the Archbishop of Armagh, attended by the four provincial kings, who took a conspicuous part in the ceremony, and there is every reason to believe that the clergy were employed in the inauguration of the chiefs of large districts, such as were called ***righa***, or kings by the ancient Irish, but that the lords of single baronies, or Triucha cheds, were appointed by the head chieftain, by consent of his tribe, with the simple ceremony of delivering him a rod. This is evident from various passages throughout the Annals of the Four Masters, which it would be too tedious to quote in the present work.


### L *recte M*

### Death of St. Gerald of Mayo.


See page 145, note a *i. e. note 351 in the CELT edition*. Dr . O'Conor, in his Rerum Hibernicarum Scriptores, denies that the Annals of Ulster and Tighernach record the death of St. Gerald at 732; he says that at this year they record the death of Muireadhach, one of his successors, and that St. Gerald himself died long before. See his notes on the Annals of Ulster at the year 731, of Tighernach at 732, and of the Four Masters at 726. It is true that Dr. O'Conor is borne out in this opinion by the Annals of the Four Masters, in which it is expressly stated that Muireadhach was Bishop of Mayo; but the Editor is of opinion that the Four Masters have mistaken the original Annals of Tighernach, in which the passage stands as follows, without any punctuation: — 
‘A. D. 732. Cath Connacht



---

p.453



in quo cecidit Muiredach Mac Indrachtaig Pontifex Muige h-Eo Saxonum Garailt obit.’


Now it is quite clear from the two verbs cecidit and obit that two distinct persons
are referred to in the entry, and that the passage should be thus punctuated: — 
  

‘A. D. 732. Cath Connacht, in quo cecidit Muiredach Mac Indrachtaig. Pontifex Muige h-Eo Saxonum, Garailt, obit,’ i. e. ‘A. D. 732. The battle of Connaught, in which fell Muiredhach, son of Indrachtach. The Pontiff of Mayo of the Saxons, Gerald, dies,’i. e. ‘Gerald, Pontiff of Mayo of the Saxons, dies.’ It is quite clear that Muiredhach was a chieftain, not a bishop, and it is more than probable that he was the son of the Indrachtach, King of Connaught, who is said to have been slain in the year 718 — Vide supra, p. 315, note h *i. e. note 936 in the CELT edition.*


**Colgan** also, at Mart. xiii. seems to think that St. Gerald of Mayo died earlier than 732; and **Ussher** thinks that he must have died before the year 697; but **Dr. Lanigan** clearly proves that both these opinions are groundless. The Four Masters enter the death of St. Gerald under the year 726, and in **Mageoghegan**'s translation of the Annals of Clonmacnoise it is entered under the year 729; but as these Annals are antedated by a few years it is obvious that the same date is intended as in Tighernach. But it should be confessed here that even **Mageoghegan** has mistaken the construction of his original, which he renders thus: —‘A. D. 729. The battle of Connaught was fought, wherein Moriegh Mac Inreaghty, Bushop of Moyoe of the English, was slain. Garalt died.’ It should be, ‘The battle of Connaught was fought, wherein Moriegh Mac Inreaghty was slain. The Bushop of Moyoe of the English, Garalt, died.’


### M *recte N*

### Of the ancient divisions of lands called Ballybetaghs.


*See page* 204. — The following notices of the ancient Irish townlands, given by the Rev. John Keogh, author of the Irish Herbal, in a short account of the county of Roscommon, written by him for **Sir William Petty**'s intended Atlas, are here presented to the reader in confirmation of what has been advanced by the Editor at p. 204, on the difference between the ancient and modern Irish townlands. This tract is preserved in MS. in the Library of Trinity College, Dublin, and is dated Strokestown, March 14th, 1683:
  


> 
> ‘Connaught (and, I suppose, other provinces) was anciently distinguished into countries called Doohie, or Tyre, named from such and such families, or nations inhabiting them, as in the barony of Athlone, Doohie Keogh, the country or nation of the Keoghs. In the barony of Ballintobber, Doohie Hanly, the country of the Hanleys,
> 
> 
> 
> ---
> 
> p.454
> 
> 
> 
> and betwixt Elphin and Jamestown, that sweet country Teer O'Ruin *[Tir Briuin]* and Teer O'Byrne, the country of the Beirns.’
> 
> 
> ‘These countries were subdivided into townlands (in some other parts of Ireland known by the denomination of plough-lands) which were called Ballys, as in Doohie Hanly, Bally nengulluh, *[or]* Gyllstown, Ballygilleclinne, the town of the Chlinnes, Ballyfeeny, &c., and each townland was divided again into quarters, which are generally known and distinguished by certain meares and bounds, and for that reason the name of quarter is used as though it signified a certain measure; and now the lands here are generally set and let, not by the measure of acres, but by the name of quarters, cartrons, and gnieves, a quarter being the fourth part of a townland, and a gnieve the sixth part of a quarter, and a cartron also the fourth part of a quarter (although in other parts of Ireland a quarter is the same part that a cartron is here, and a gnieve the fourth part of a cartron). I have been sometimes perplexed to know how many acres a quarter contains, but I have learned it is an uncertain measure, and anciently proportioned only by guess, or according to the bigness of the townland whereof it was a parcel. I have also busied myself with my own concerns to inquire what town, or general denomination of townland, each quarter belonged to, for the more convenient setting of tithes in main parcels by those general names of ballys, but therein I could not meet with satisfaction, it being a thing forgotten since the days of yore, and unknown to the most who yet still retain the names of quarters. And these ancient names of townlands have lost part of their general signification, being now applied only to some small parcells, as quarters or less pieces, and each other parcell of the ancient townland hath another name, according as the inhabitants were pleased to settle their habitations and little villages here and there sparsedly fixed and variously named. I have observed that most names of dwelling places in the beginning of them (before what other addition or surname they are distinguished by) have the following words: Bally, the town; Leghbally, the half town; Carhu, the quarter; Kill, the church; Liss, or Rath, the fort of earth; Cassel, the fort of stone; Carrig, the rock; Ath, the ford; Bealawh, the ford's mouth; Gleann, the valley; Knock, the hill; Ross, Cluain. What Ross and Cluain signify I have not yet learned, they being words not commonly used (but as parts of the proper names of towns) except in ancient times, only I take it Cluain is applied generally to a place enclosed with bog and river or the like, which is commonly the pleasantest and most commodious for habitations, but Ross, being of affinity to the Latin Rus, is applied to places of wider extent, as wildernesses and forests, places overspread with underwood, &c.’
> 
> 
> 






---

p.455


### N *recte O*

### Cathal Dubh O'Dubhda.


*See page* 309, note k *i. e. note 913 in the CELT edition*, and pages 316, 317, note n *i. e. page 316, note 942*. — It is stated in the Historia familiae De Burgo, a curious MS. preserved in the Library of Trinity College, Dublin (F. 4.13.), that every Mac William is entitled to a tribute of five marks yearly out of the country of O'Dowd, and that the then O'Dowd, namely, Cathal Dubh, consented to the payment of this tribute, which is called a cios cosanta, i. e. tribute for protection. No date appears to this document, but it states that O'Dowd was present at the writing of it, who subscribes his name to it, and it is also attested by Cosny Oge Mac an Brehon, who was Brehon to Mac Maurice of Clanmorris. It is probable, however, that this tribute was not of long standing; but the power of the O'Dowds was very much crippled at this period by the O'Conors and others, so that Cathal Dubh found it his interest to pay the lower Mac William five marks a year for assisting him against them. Notwithstanding this security of the protection of O'Dowd by the lower Mac William De Burgo, the power of O'Conor Sligo continued to increase, for in the year 1581 he was lord of that tract of country extending from the River Drowes to Ceis Corainn, and from the River Moy, eastwards, to Lough Gill.


### O *recte P*

### The Lower Mac William De Burgo's possessions in Tirawley.


*See pages* 338, 339, *i. e. p. 339*, notes f and g *i. e. 1014 and 1015 in the CELT edition*. — The following list of the Lower Mac William's townlands, tributes, &c., in Tirawley, is taken from the Historia familiae De Burgo, already quoted:
  

{column 1}
‘Ag so barúntacht Tíre Amhalgaidh: locum comitis an tír féin .i. inadh an iarla; agus do fuair Mac Uilliam so innte, ocht fichid dég d'éirghe amach innte, mar atá trí fichid marcach glésta, agus sé fichid cethernach, agus naoi bh-fichid giolla capoll, fa n-a lóntuibh féin, agus tri fichid marg cíosa agus chomha.’


{column 2}
‘This is the barony of Tirawley: the territory itself is a locus comitis, i. e. the place of the Earl. And Mac William obtained in it eighteen score of a rising-out *[i. e. forces]*, to wit, three score accoutred horse and six score kerns, and nine score horse gillys *[horseboys]*, all to subsist on their own provisions, and three score marks as rent and reward.’


{column 1}
‘Ag so na fearoinn a bh-fuil sin; ar tús ann sa Bhacc thoir, se baile comhtha; agus anns a Bhacc thiar chúig bhaile chomhtha; ceathramha agus chuig bhaile’


{column 2}
‘The following are the lands on which these are paid: — first in the eastern Bac, six townlands of reward, and in the western Bac five townlands of reward; a’




---

p.456


{column 1}
‘comhtha a n-Gleann Neimhthind, agus ag su na n-anmanda sin, .i. Baile in Chorráin, agus Baile na Craoibhidhe, agus leath-bhaile Maidheag, agus leath-bhaile Matha, agus leath-bhaile Caorthannáin, agus ceathramha Dairbhin, agus ceathramha Bhaile mhic Rémag, agus ceathramha Bhaile na Laighneach, agus ceathramha Bhaile an Bhruithneoguigh, agus leathbhaile Mhaol-átha, agus in Cheathramha chlochach, agus leath-bhaile Trintach, agus leath-bhaile Rátha Ruaidhin, agus Baile Easa Caoirigh, agus an Cheathramha riabhach, agus an Cheathramha chúigeadhach, agus leath-bhaile Ratha Toma, agus Ceathramha an charbuid, agus ceathramha Chille h-Achaidh, agus an Ceathramha mór, agus ceathramha Baile Hostin, agus cúig leith-cheathramha anns a Ros ó t-Sailin asteach, agus leathbhaile na Lagbhuaile; da uinge teasda do chúig mharg a n-Inis Cuadh, do chíos agus do chomha;’


{column 2}
‘quarter and five townlands of reward in Gleann Nemhthinn, named as follows, viz., Baile an Chorrain, Baile na Craoibhidhe, the half townland of Maidheag, the half townland of Matha, the half townland of Caorthannan, the quarter of Dairbhin, the quarter of Baile mhic Remag, the quarter of Baile na Laighneach, the quarter of Baile an Bhruithneoguigh, the half townland of Maol-atha, Ceathramha chlochach *[i. e. the stony quarter]*, the half townland of Trintach, the half townland of Rath Ruaidhin, Baile Easa Caoirigh, Ceathramha Riabhach, Ceathramha Chuigeadhach, the half townland of Rath Toma, Ceathramha an Charbuid, the quarter of Cill Achaidh, Ceathramha Mhor, the quarter of Baile Hostin; five half quarters in Ros from Sailin inwards, the half townland of Lagbhuaile; two ounces wanting of five marks in Inis Cuadh, as rent and reward;’


{column 1}
‘dá mharg dhég do chíos agus do chomhadh a dhá baile Crois Mhuidhelína; Ocht pinginne agus fiche sgillinn a m-baile an Chorrbhaile; ocht pinginne agus fiche sgillinn anns a Bhaile meadhonach; ocht pinginne agus fiche sgillinn a m-baile Locha Bron; ocht pinginne agus fiche sgillinn a m-baile Chille h-Aodhain; ocht pinginne agus fiche sgillinn a m-Baile na Cobhruidhe; bonn agus uinge d'ór a g-ceathramhain an Cháirn; dá phinginn agus trí h-uinge anns a Cheathramhain mhóir; dá phinginn agus tri h-uinge a g-ceathramhain Baile na leice; da phinginn agus tri h-uinge anns a' cheathramhain Sdiallaigh; ocht pinginne agus fiche sgilling’


{column 2}
twelve marks as rent and reward in the two townlands of Cros Muidhelina; twenty shillings and eight-pence in the townland of Corrbhaile; twenty shillings and eightpence in Bailemeadhonach; twenty shillings and eight-pence in the townland of Loch Bron; twenty shillings and eight-pence in the townland of Cill Aodhain; twenty shillings and eight-pence in the townland of Cobhruidhe; a groat and an ounce of gold in the quarter of Carn; two-pence and three ounces in Ceathramha Mhor; two-pence and three ounces in the quarter of Baile na Leice; two-pence and three ounces in Ceathramha Sdiallach; twenty shillings and eight-pence in Baile an Oireacht; twenty shillings and eight-pence 




---

p.457


{column 1}
‘a m-Baile an Oireacht; ocht pinginne agus fiche sgillinn a m-Baile Rátha Leacain; uinge d'ór a n-duthaidh Chloinne Philip; ocht b-pinginne agus naoi n-uinge a m-Baile Chille Brighde; ocht b-pinginne agus fiche sgillinn a m-Baile an Chaisill; ceathra h-uinge dhég a m-Baile Acha Liag; bonn agus uinge d'ór a m-Baile an Ghleanna; tri h-uinge a m-Baile Charna; bonn agus uinge d'ór a leatbhaile in Tobair; ceathra h-uinge dhég a m-Baile Faraidh; bond agus chuig uinge a leathbhaile Locha Deala; dá phinginn agus trí h-uinge a g-ceathramhain Chaisle; sgillinn agus uinge a m-Baile I Dubhthaigh; naoi m-boinn a g-ceathramhain Bhrechmhuidhe; da mharg am-Baile O'g-Comhain; dá phinginn agus tri h-uinge a g-ceathramhain Dairín; dá phingind agus tri h-uinge a g-Ceathramhain Chuain Néill; uinge a m-Baile Mic Cithol.’


{column 2}
in the townland of Rath Leacain; an ounce of gold in the territory of the Clann-Philip; eight-pence and nine ounces in the townland of Cill Bhrighde; twenty shillings and eight-pence in Baile an Chaisill; fourteen ounces in the townland of Acha Liag; a groat and an ounce of gold in Baile an Ghleanna; three ounces in Baile Charna; a groat and an ounce of gold in the half townland of Tobar; fourteen ounces in Baile Faraidh; a groat and five ounces in the half townland of Loch Deala; two-pence and three ounces in the quarter of Caisle; a shilling and an ounce in Baile I Dhubhthaigh; nine groats in the quarter of Breachmhaidh; two marks in Baile O'g-Comain; two-pence and three ounces in the quarter of Cuan Neill; an ounce in Baile Mic Cithol.


{column 1}
‘Atáid na maoir d'á dhénamh d'fiaghnuisi ann so do réir mar fuaradar ó na sinnsearuibh táinicc rompa, gach fearann nach tiucfa d'á oighre féin a dhíol, an fearann d'fuasgra do Mhac Uilliam; agus fós damadh lúgha cíos Mhic Uilliam anns a bh-fearann iná cíos na d-tigearnaigh eile gan ar breith do na tighearnuighibh sin a g-cíos féin d'fágháil no go bh-faghaidh Mac Uilliam a chíos ar tús. Agus ni eile fós gur ab air an bh-fearann ata cion Mhic Uilliam, agus ní bh-fuil luagh air an chur do thagra leis.’


{column 2}
‘The stewards bear testimony to this accordingly as they received it from their ancestors, that every land of which its own inheritor cannot pay this tribute is to be declared escheated to Mac William; and should Mac William's rent be less than that of the other lords, these lords cannot raise their rents until Mac William shall first receive his own rent. And moreover that Mac William's tribute is due of the land, and that there is no power of disputing it with him.’


The two documents which follow, taken from the Historia familiae De Burgo, will



---

p.458



show how the Barretts and Burkes stood in the years 1580 and 1584. The first is given in Irish[1120](javascript:footNote('T105008/note1120.html')), with an original Latin translation, and the second is in Latin only.

> 
> In Dei Nomine Amen.
> 
> 
> {column 1}
> ‘As é ádhbhar in sgíbhinn si, dhá foillsiughadh go d-tárla baile Bel Leice do Shean mac Oilbhérus, agus d'a mac na diaigh, .i. Bháiter a Búrc, ó Bhairédachaibh, mar atá Tomás na geimhli agus a chlann, agus a Braitherocha, .i. Seann Bairéd agus a mac, agus Emain mac Maia, agus Uilleag, mac Maia Ruaidh; do bádar sin seal fada a n-diaigh an dúthchais do thaobh chúirti, agus seal oile do taobh a gcarod Gaedheal amuigh, agus ni fhuaradar toradh ar cheachtar díobh sin; agus rugadar do roghuin gurbh-fhearr leó maith Bhaiter a Búrc agus a shochar aca, iná beith a n-diaigh a n-dúthchais agus an chaisléin, agus nar derbhtha leo a fhagháil dá mhéd dá g-caithfidís ris. Ar an ádhbhar sin do rinneadar conradh re chéile leath ar leath, mar atá, cuid sinnsir ag Baiter uatha-son, .i. bota Bel Leice ar tús, agus leath soileir agus tighe meadhoin aca-son ó Bhaiter, agus leath badhúin agus dúthchais, agus inmhir, agus éisg, agus coicéid mar an g-cédna. Tuilleadh eile gach taobh a d-Tír Amhalghuidh 'n-a bfuil dúthaidh na m-Bairédach sin, a leath ag Bhaither, agus a leath aca-son, agus d'fiachaibh ar Bháiter a cumhachta féin do caitheamh re n-a buain amach annsa córuigh mar a chuid féin, agus an connradh sin aga d-tiucfaidh n-diaigh go brách ar a chéile do nós a g-connartha féin, agus d'fiachaibh orra ann so bheith ag’
> 
> 
> {column 2}
> ‘Universis et Singulis pateat per presentes, quod Manerium de Bel lecce pervenit ad Johannem *[filium]* Oliveri De Burgo ej usque filium Vaterum De Burgo, sed vere heredes ipsius manerii seu Castri, viz., Thomas Cathenarum Bared et ejus filii et fratres, viz., Johannes Bared ej usque filius Edmundus fitz Mayw Gullialmus fitz Mayw ruffi longo tempore in judicio et extra judicium convocato auxiliis tam Anglorum quam Hibernicorum contendebant de recuperatione ejusdem manerii; *sed* non obtinebant, tandem pacem concordiam et favorem prefati Vateri eligentes amicabiliter concordarunt sub forma quae sequitur, viz., quod ipse habeat supremam partem dicti manerii et dimediam partem solerii et domus medie ad eorum usum et dimediam partem Muniminis seu propugnaculi et terrarum piscariorum vectigaliumque. Item dimediam partem omnium tenementorum terrarum ubicunque in baronia de Tyramhalay jacent seu situantur ad eos de jure pertinentium prefato Vatero concesserunt, sub condicione quod eos in judicio et extra judicium legittime defenderet, et ipsi similiter seprefato Vatero in omnibus consilio auxilio et favore contra omnes assistant et hoc fedus et hunc contractum ad suos heredes assignatosque extendi voluerunt. Hee sunt terre et tenementa de quibus supradictum contractum inierunt secundum’
> 
> 
> 
> 
> ---
> 
> p.459
> 
> 
> {column 1}
> ‘Báiter mar in g-cédna do nos mar is cóir dóibh bhéith aige an-aghaidh gach aoin. As í an dúthaidh ar a n-dernadar Bairéduigh agus Bhaiter a Búrc an conradh sin, do réir umhachta Thomais na geimle, mar fuaramar sgriobhtha í, .i. leath bhaile Bel Leice ar tús, agus a shochar éisg agus inbhir agus coiceid, agus naoi b-pinginne agus naoi n-uinge ar leath Baile na Cuirte, agus ceathramha Tulaigh cléibh, agus leith cheathramha na n-Guirtine, agus do fháguibh Tomás na geimhli le h-umhachta nach raibhe acht da cnoc fa geall do'n leath ceathramuin sin, .i. in Réisi, agus an Cnoc Leitheach a n-geall re x n-uinge, agus nach raibhe acht leithcheathramha anns na Guirtínibh agus anns a' Réisi agus annsa Cnoc Leitheach. Agus leath bhaile Locha Muighe Bron, .i. Trian na Scológ, agus Trian na Páirce, agus Trian an Oilean, agus leath ceathramha Chluana Alchuin agus leath ceathramha Bhaile na Leice, agus leath Ceathramha in Tuairín, agus se buin dég a cíos 'san m-bliadhuin, agus an ceathramha Sdiallach, agus leath an Charbhuid bhig, agus leath fearuinn an tighe moir, agus Cnocán Muiris, agus Tobar Tighearnáin, agus Droidhneachán agus Gargha Longain, agus leath coiceid Ratha Brannuimh, acht a trian sin ag sliocht Roibeard Baired, agus seacht n-galuin do Phíopa na Soileog as coiced Innsi na n-Gall agus x n-galuin eile do bhean Riocard mac Tomais Chaoich amach do féin agus d'á shliocht, agus leath bhaile na *Raithnighe*, agus ceathramha mor Bhel Tragha agus ’
> 
> 
> {column 2}
> ‘ultimam voluntatem predicti Thome Bared et antiquas Scripturas, viz., dimedium villate de **Bellecce** cum omnibus supradictis emolumentis Piscariorum et Vectigalium, et ix unxie cum ix denariis pro dimedio villate na **Cuirte**. Item quarta nuncupata **Twla Cleyw**, dimedia quarta na ngwrtyne. Sed predictus Thomas in suprema voluntate attestatus est quod solum duo colles predicte quarte, viz., an **Resy** et **Cnoc Leytheach** erant in pignore x unxiorum, et quod non erat in predictis particulis de **Gurtyn**, **Resy**, **Cnocleytheagh** nisi dimedia quarta. Item dimedia villata **Loghabron**, viz., **Tryan na Scolog** et **Tryan na Parke**, et **Tryan an Oylen** et dimediam quarte **Clwyn Alchwyn**. Item dimediam **Bayle na Lecce**, dimedium quarte in **Tworyn** et xvi. grotti annui census. Item quarta quod vocatur **Styallagh**, dimediam **Carbayd byg**. Dimidium predii in **Tyghe Mor**, et **Cnocan Murys**, **Tobar Tyarnayn**, **Droynechan**, **Ortus Longayn**, dimedium vectigalis in **Rathbranna**, preter terciam partem que debetur genelogie Roberti Bared, et septem galones ex **Pipa na Soleog** ex vectigali Insule na ngall, et x galones quos Richardus filius Thome Ceci sibi nomine vectigalis exegit ac sue posteritati. Et dimedia villa na **Rathny**, et quarta magna **Bel Tragha**, item ’
> 
> 
> 
> 
> ---
> 
> p.460
> 
> 
> {column 1}
> ‘Baile Acha Liag agus treas mir Baile na Cabruidhe Ruaidhe, agus Baile an Ghleanna uile. As é cor ar a bh-fhuair Baiter a' Burc in tabhartus so maille re beannacht na n-oigheredh, agus do bheíth aige fein agus ag a shliocht 'n-a dhiaigh.’
> 
> 
> {column 2}
> ‘**Bayle Achalyag**; item tertia **villa na Cabray Rway**; item tota Villa vallis. Et prefatus Vaterus Burk hanc concessionem et donacionem cum benedictionibus heredum premissorum tam sibi quam sue posteritate recepit.’
> 
> 
> {column 1}
> ‘Agus dá n-eirgeadh báthadh fine do na Bairedachuibh, sin a g-cuid duithche agus fineachuis do bheith ag Bhaiteir agus ag a shliocht 'na dhiaigh, do réir an chéd chonnartha. As í aois in tighearna in tan sa, .i. mile bliadhain, agus ccccc agus ceithri bliadhna agus ceithre xx. an Chéadaoin roimh n-Odluig, agus as é **Sir Seoin Pioroid** do ba Giuisdís a n-Eirinn o'n bainrighain Saxan .i. Elisabet, agus **Risdeard Binggam** 'na uachtarán ar cuige Connacht, agus Risdeard mac Oilbherus a Burc 'na Mac Uilliam an bliadhuin chedna sin.’
> 
> 
> {column 2}
> ‘Et si nullus ex antedictis donatioribus supervixisse act est quod hiis Vaterus jure hereditario succedat. Scriptum in **Bellecce** 1584, feria iiii. ante festum Nativitatis, Regnante Serenissimo principe Elizabetha et Johanne Perotho Deputato in Hibernia existente — Risterdo Byngam Provinchias Thomondie et Connachie gubernante — Risterdo Olivere De Burgo creato Mac William.’
> 
> 
> {column 1}
> ‘As iad fiadhnuisigh an connartha so, .i. Mac Philip, mar ata Emann Og, mac mic Pilib, agus Hiberd Meiric. Risderd Meiric sagart na fairche agus Uilliam Mac in Chleirigh, in sagart eile; agus gabha na fairche, Ricaird O'Murain; agus an Dubhaltach mac Ricaird Duibh mic Ribird, agus Tomultach Og, mac Mathgamhna I Uigin, agus Aongus mac *Aodha* Ruaidh I Uigin in sgribhneoir, agus Maolmuire mac Alasdruinn, mic Aodha Bhuidhe.’
> 
> 
> {column 2}
> ‘Hiis testibus presentibus, viz., Mac Philipp, cujus proprium nomen est Edmundus, et Risterdo Meric presbitero.’
>   
> 
> ‘Ejusque Patre Hyberto et Willielmo Clery presbitero, et Richardo O Mwrayn fabro ferrario. Et Dualdo filio Richardi nigri Mac Roberd. Thomulteo filio Mathei y Hwyginn et Enea filio Odonis Ruffi y Hwygynn, ac Mylero filio Alexandri filii Odonis aliisque clericis et laycis.’
> 
> 
> Meisi Aongus O'Huigin. 
> Meisi Maolmuire Mac Alasdruinn. 
> Meisi Uilliam O'Cleirigh, Sacerdos. 
> Meisi An Dubhalltach Mac Ricaird Duibh. 
> Meisi Ricard O'Muráin 
> Meisi Mac Philib. 
> Meisi Tomultach Og. 
> Meisi Hiberd Meiric. 
> Per me Richardum Merick, Sacerdotem Parochialem. 
> Meisi Seaan Baired. 
> 
> 
> ---
> 
> p.461
> 
> 
> Meisi Robag Baired. 
> Meisi Emonn Mc Maigiu. 
> Meisi Ulliam Baired. 
> Meisi Uilleag Mc Maigiu Tuaigh. 
> Meisi Maoilere Baired. 
> Meisi Artur Baired. 
> Meisi Risdeard Mc Riberd an Tochair. 




The second document is as follows:
  


> 
> ‘Omnibus has literas visuris et audituris innotescat, quod filii Risterdi Baired, eodem modo et eisdem condicionibus, contraherent et convenerunt cum Waltero Kytach a Burk, sicut ceteri alii eorum consanguinei, viz., quod Vaterus habebit dimediam partem omnium prediorum suorum, quocunque loco sita essent, sub condicione hac, ut Waterus eos in justitia sua defenderet pro viribus, et ipsi similiter cum fidelitate omni Vatero assistant, et presertim quod omnes qui eum erga predicta predia molestarent. Et tam Vaterus quam prefati filii Risterdi volunt extendi hunc contractum et obligacionem ad suos heredes et assignatos. Prediorum nomina sunt hec, semiquarta Clwyn Crayn, et semiquarta Clwyn na hatha, et semiquarta an Corrayncaym: Semiquarta vero na Cnoc est apud Vaterum ipsum in pignore 6 vaccarum fetosandarum, et septern vaccarum quas minores vocant, et quinque marcharum cum duabus unxiis: Item quarta de Cwan Neyll, sed ejus dimidia pars est in pignore v. Marcharum Ster. apud filios Mauritii hy Cernay, et alia dimedia pars apud eosdem in pignore unius Marche. Item sciendum est quod hec est pars que debetur predictis filiis Risterdi a suis consanguineis, viz., octava pars ejus partis quam a Vatero habent in Bellecce cum omnibus suis emolumentis et obventionibus. Insuper utraque pars contrahentium se obligat ut altera alteri pro viribus benefaciat, sive pauperes sint sive divites, sive fortes, sive debiles. Scriptum in Bellecce, A*nn* Domini M*illesi*mo. ccccc. lxxxiiii. Januarii xiii[ordm ]. Hiis Testibus presentibus, viz., Risterdo Meric ac Johanne Roday Sacerdotibus, Johanne Bared, Heberto Meric, Tomultheo Juveni O'Hwyginn, ac Enea filio Odonis Ruffi y Hugynn, aliisque quamplurimis clericis et laicis.’
> 
> 
> Misi Risdeard Meiric. 
> Misi Sean O'Rodaidh. 
> Misi Tomultach Og O'h-Uiginn. 
> Misi Aongus O'H'Uigind. 




### P *recte Q*

### St. Patrick's Travels and Acts in Tirawley, etc.


*See page* 311, note s *i. e. note 921 in the CELT edition* — ‘LXXVI. Peragratis variis Connaciae partibus ad austrum, trajectoque **Muadio** flumine, venit Patricius ad regionem de *Tir-Amhalgaidh;* ubi tunc erant duodecim filii Regis Connaciae, Amalgadii nempe, filii Fiachrii, de regno contendentes. Nomina horum filiorum erant Aengussius, Fergussius, Fethlemius;



---

p.462



Enda Crom, Enda Cullom, Corbmacus, Carbreus, Eochadius Diainimh, Eochadius alter, Eugenius Corr, Dubchonallus et Alillus Ainech. Aengussius autem aliis astutior, et in spem regni magis erectus, reliquos fratres, prasertim quos magis metuebat ut regni aemulos, curavit per suos conspiratores despicabilibus insigniri cognomentis, ut sic populi ab eis averterentur animi. Unde his moti viginti quatuor seniores, qui erant viginti quatuor veterum tribuum patriae praefecti, statuerunt neminem in suum Regem admittere, cuius honori aliquod despicabile cognomentum inferret notam. Lis ergo inter fratres orta eo vsque incrementum sumpsit, ut Temoriam ducta sit, Regis Laogarii et Eugenii eius fratris arbitrio decidenda.’


‘LXXVII. Filii igitur Amalgadii in duodecim curribus profecti sunt Temoriam: *Sed in libris Patricii invenitur quod exierint in iudicium tantum septem fratres ex eis.* Inter Temoriam venientes erat quidam spectatae indolis, et multae gratiae juvenis, nomine Conallus, Endae Cromio inter fratres primogenito, natus, causam patris acturus, eiusque loco litem prosequuturus. Hunc iuvenem ob singularem gratiam, praeclarasque animi dotes, ante alios metuebat Aengussius. Unde cum ipse esset janitoribus aulae, et ministris Regis notus (erat enim olim apud Regem Laogarium in aula Temoriensi inter Ephebos educatus) hoc ab eis obtinuit, ut Conallo introitum et accessum ad Regem intercluderent. Cum ergo alii essent in aulam admissi, et ad Regis praesentiam ducti, solus Conallus domo patrui sui mansit exclusus: qui nesciens quid ageret, quove se verteret, audivit pulsum cymbali S. Patricii pro celebrandis divinis mysteriis in loco **Tiprad Phadric** dicto symbolum dantis. Accedens ergo Conallus perhumaniter virum sanctum salutavit, et in memoriam refricavit, quomodo ante dies multos infantes suae patriae[1121](javascript:footNote('T105008/note1121.html')), in utero matrum existentes, clamaverint ad novae doctrinae quendam 



---

p.463



advenam, ignotae linguae verbis dicentes; Hibernienses omnes clamant ad te pueri[1122](javascript:footNote('T105008/note1122.html')), Patricius autem haec laeto animo audiens et excipiens, ait: ego sum ad quem illa directa sunt, et in maris Tyrrheni insulis existens ea audivi; *et nescivi utrum in me, an extra me, prolata sunt verba. Et ibo tecum in regionem tuam baptizare, docere, evangelizare.*’


‘LXXVIII. Post haec autem interrogabat Patricius, qua causa venerit Conallus 



---

p.464



Temoriam. Causam auteram sui adventus exposuit Conallus, addiditque ea non obstante sibi Temoriensis aulae ingressum esse praeclusum. *Cui dixit Patricius, ingredere nunc ianuis apertis, et ad Eugenium filium Neill amicum meum fidelem, qui te adiunabit; capiesque occulte annularem eius digitum, quod signum est inter nos semper; et factum est sic.* Eugenius autem haec advertens, petiit quid placeat S. Patricio. Respondit Conallus, ei placere, ut Eugenius in praesenti lite sibi assistat. Post haec Conallus causam dixit coram Rege; et perorando dixit, si iuventutis floridaeque aetatis, quae patriam viribus tueri posset, spectande sit ratio, sibi, qui in hoc genere omnes adspirantes superaret, regimen esse conferendum: si vero senectutis et justitiae, patrem eius, omnibus esse praeferendum, qui reliquos fratres titulo primogeniturae et maturitate iudicii superaret. Unde motus eius rationibus Laogarius Rex, licet prope inuitus, adiudicavit patri eius paternum solum et solium modo jura suffragantibus persolui consueta, prius persolvat. ’


‘LXXIX. Decisa sic lite filii Amalgadii, ne omnes bene contenti, revertuntur in patriam, quos, et praecipue dilectum suum Conallum, patriae isti fidem praedicaturus comitatur S. Patricius. Sed Aengussius pessime cum Conallo, ejusque fantore Patricio contentus, instigatus ad hoc a perfido Laogario Rege, statuit utrumque e medio tollere; impiumque conceptum fratribus suis Fergussio et Fedlimio, eorum animos ad idem facinus sollicitando, communicavit. Locus sceleri committendo condictus erat *Corann* regio Connaciae. Sed fratres eius recusarunt in tam impium facinus consentire, dicentes nolle se crimen sacrilegii in innocentem, sanctumque Dei Patricium, nec parricidii in Conallum nepotem admittere. Sed nec sic ad saniorem mentem rediit Aengussius, sed in concepta perseverans impietate, sceleris consiliarios et consortes admisit duos Magos *Roen* et *Rechet* de progenie Foelani militis: et cum duabus malefactorum turmis progrediens, in via per quam transibant, ante eos statuit insidias, laqueosque mortis: ubi et *Roen* Magus criminis socios animabat, promittens, si ipse primus ilium prodigiorum conclamatum patratorem Patricium aspiceret, eum sui visus maleficio, illico fore extinguendum. Quae impia malignantium insidiatorum consilia, diabolicaque proposita cum vir Dei in spiritu recognosceret, adhuc uno iusto milliari distans (erat enim ipse tunc in loco, ubi nunc est *Crux Patricii*[1123](javascript:footNote('T105008/note1123.html')) dicta; et insidiatores in loco, 



---

p.465



in quo jacet Ecclesia de *Kill-fhoirclann*) a Domino suo instigatus, ad Magum dixit; non ita fiet, fili Belial; sed ego te prius videbo, teque terra, quam me minaris absorpturam, prius deglutiet viventem, nisi resipiscas. Cum autem primum in eius conspectum veniret Patricius, coepit terra dehiscere, et meatu facto magum *Roen* deglutire. Ad haec Magus timore perculsus, petensque veniam, et promittens poenitentiam a terra evomente in aera inter ventos rejicitur, et mox semimortuus deorsum demittitur. Similiter etiam et socius eius impoenitens Rechet a respuente terra proiectus in altum, denuo praeceps recidens in terram, ad saxum allisit caput, et mox fulmine percussit interiit. Saxum illud, ad quod allisit caput, vulgo vocatur ail an druadh, id est lapis Druydis. Estque Ecclesia in illo loco iuxta *Coill Fochladh* ad Orientem extructa, quae *Cros Phadruic* appellatur. Locus etiam in quo tunc erant insidiatores vulgo *Tulach na n-Druadh*, id est collis Druydum, nominatur, adiacetque praedictae Ecclesiae ad occidentem.’


‘LXXX. Aengussius autem tam terribili spectaculo praemonitus valde timuit petiitque, et impetravit veniam, fidemque Christi tantis probatam prodigiis amplexus est: qui et enixe rogavit virum Dei, cui nihil putabit impossibile, ut suam sororem nomine *Felimiam* vitae dignetur restituere. Annuit Patricius et oratione ad Deum fusa, defunctam vita redonatam fratri praesentavit.’


‘LXXXI. Quidam oculorum lumine orbatus audiens mirabilia, quae per mirificum Dei servum Patricium fiebant, transeunti Patricia occursurus acceleravit gressus: et qui, visu viae monstratore carebat currens per invia cadebat, et gressum mox resumens, denuo recidebat. Cernens eum quidam de clericis S. Antistitis risit, et sine miserecordia derisit coeci cespitationes. Quod indigne ferens vir sanctus, indignatione commotus ait; Tu dignus es qui beneficio oculorum, quibus male vides, orberis; et caecus ille fide plenus, suo infortunio remedium sedulo postulans, dignus quem sol justitiae amissi luminis redonet usura. Et vix verba finivit, cum ecce ex tempore clericus coecitate percussus, oculorum lumen amisit: et coecus abstersa caligine luminibus restitutus, coepit obvia clare videre, divinamque bonitatem summis laudibus exaltare. Coeco nomen erat *Roan* filius Conchnamha, fuitque servus olim Amalgadii Regis; et locus in quo sanatus est *Roe Roain* abinde vocatus, donatus est postea S. Patricio. Clericus autem vocabatur *Midgna* et ipse et alter Patricii discipulus nomine *Donnmalius* relicti sunt in quodam eremitorio, quod *desertum* Patricii nominatur, iacetque iuxta fontem prope Ecclesiam, *Cros-Phadruic* nuncupatam.’


‘LXXXII. In loco *Huachtar Charthuinn* appellato venerunt duo claudi ad Patricium; coram quo, ut viscera eius ad misericordiam commoverent, prolixe conquesti sunt se facultate gradiendi, propter claudicantes pedes, destitutos; debere tamen propter rei familiaris curam per loca aspera, et invia inter montem et planitiem saepius iter 



---

p.466




agere. Quorum miseriis vir misericors ex corde compatiens eos divina virtute erexit, et facultate expedite gradiendi donatos dimisit.’


‘LXXXIII. Post istos claudos sic officio gradiendi restitutos, venit Patricius ad Ecclesiam de *Domnach-mor[1124](javascript:footNote('T105008/note1124.html')), ubi est episcopus Mucna*[1125](javascript:footNote('T105008/note1125.html')) et inde ad Ecclesiam de Crosphadruic[1126](javascript:footNote('T105008/note1126.html')), ubi venit ad eum quidam alius claudus genere nobilis, nomine *Aidus,* cognomento *Longus,* Aengussii ex Eochadio filio nepos, similemque imploraturus, et expectaturus gratiam. Quem et juxta expectationem, fideique meritum, vir sanctus officio pedum et facultate gradiendi restituit iuxta praedictam fontem, qui Ecclesiae de *Cros-Phadruic* ad occidentem adiacet. Aidus autem beneficio gratus dedit tunc Patricio quoddam praedium in quo fundavit Ecclesiam; e qua quietis locum duobus e discipulis Teloco et Domnaldo designauit.’


‘LXXXIV. Post tot magorum supra memoratos congressus, singulosque in publicis certaminibus victos, partimque extinctos, et partim ad poenitentiam conversos; nondum destiterunt reliqui magi, sua malitia excaecati, eius praedicationi resistere, et vitam insidiari. Et cum viderent ipsum in publicis certaminibus continuo victorem
non audentes amplius cum eo publice congredi, statuerunt eum stratis insidiis occulte e medio tollere. Unde novem ex eis in unum convenientes, in regione de *Tir-amhalguidh* occultas ei struxerunt mortis insidias. Quod cum videret vir illustris Amalgadii filius *Enda volentes occidere Patricium, dixit filio suo Conallo; vade et custodi Patricium, ne magi occidant illum. Ipse etiam Patricius sensit eos.* Pro quo pugnans, tanti sceleris ultor *ignis aethereus eos in numero novem combussit*, et illico extinxit.’


‘Peragrans postea vir Sanctus eandem regionem, venit ad locum amaenum ubi Muadius fluvius piscosus exoneratur in oceanum. In eo autem loco, pia terrae Principum liberalitate donato, ad ripam fluminis australem construxit nobilem Ecclesiam, sedemque postea Episcopalem Killaladh[1127](javascript:footNote('T105008/note1127.html')) nuncupatam: cui et unum e discipulis Muredachum nomine, primum praefecit Episcopum.’


‘LXXXVI. Ibi etiam vir sanctus baptizavit, Deoque consecravit duas celebratae sanctitatis virgines Crebream et Lassaram, Gleranno viro nobili Cuminei filio, natas. Hae sunt, quae inclusae in utero materno in regione de *Caille Fochladh* referuntur dudum ante in persona infantium Hiberniae clamasse ad S. Patricium, dum esset in insulis maris Tyrrheni efflagitando ut seposita mora ad Hibernos convertendos acceleraret:



---

p.467



earumque sacrae exuviae ut patronarum loci, in summa veneratione in Ecclesia de *Kill-fhorclann,* iuxta Muadium versus Occidentem asservantur.’


‘LXXXVII. Inde progressus venit ad locum, qui a concessu publico, in quo cum subiectis populis congregati erant filii Amalgadii Regis, vocatur *Forrach mhac n-Amhalgaidh*[1128](javascript:footNote('T105008/note1128.html')). Ingentem ibi populi multitudinem cum suis principibus collectam reperiens, vir Apostolicus in medium coetum se contulit, et ad succisionem idolatriae gladium spiritus avaginavit, et verbo Dei velut romphea bis acuta, totius multitudinis corda penetravit, et in Christianae fidei ac doctrinae amplexum voluntarios perduxit. Eo die septem Amalgadii filios cum ipso Rege et duodecim millibus hominum, Christo lucrifecit, et in fonte qui *Tobur enadharc* nuncupatur, omnes baptizavit. Populoque noviter converso *Manchenum* cognomento *Magistrum*, virum Sanctum, et in Scripturis egregie versatum, fidei et doctrinae praefecit magistrum.’


‘LXXXVIII. In eodem agro S. Patricius duo magna operatus est signa. Foeminam unam defunctam vitae restituit, et alteram cum sua prole in utero gestata, vita et mortali et aeterna, donavit. Hanc autem foeminam cum suo foetu mortuam resuscitavit vir Dei infra Ecclesiam de *Kill-aladh.* Et cum ad eam resuscitandam pergeret, eum comitati sunt Felimius, Amalgadii filius, et Conallus eius ex Enda fratre nepos; et Aengussius etiam Felimii frater, qui alia via superiori ad sepulchrum defunctae mulieris iter suscepit. Matrem autem cum prole iam resuscitatam sacra unda intinxit in fonte iam supra memorato: *Et illa suscitata praedicavit turbis de poenis Inferni, de praemiis coelestibus: et per lachrymas *rogavit* fratrem suum, ut Deo per Patricium crederet: quod factum est; et baptizatus. Et in illo die duodecim millia baptizati sunt in fonte Oenadharca ut jam supra retulimus.*’


‘LXXXIX. Retro flectens versus austrum, venit inde Patricius ad vadum quoddam iuxta lacum *Loch Deala*[1129](javascript:footNote('T105008/note1129.html')) vocatum, ubi statuit aedem sacram excitare: sed fundus erat versipellis Aengussii, qui viro Dei se opponens, animique duplicis, verbo et facto ostendens pravitatem; dixit se non ex sincera, sed ficta et turbata mente credidisse et baptismum suscepisse. Patricius haec audiens in perversum hominem, eiusque semen fulminavit maledictionis sententiam, precans et praedicens, nec ipsius nec seminis eius domicilium futurum nisi humile, eiusque posteritatem malis seditionum et homicidiorum
notis fore notandam.’


‘XC. Inde versus Orientem reflectens venit ad locum *Leac-fionnbaile* vocatum, qui est supra Ecclesiam de *Kill-mor*[1130](javascript:footNote('T105008/note1130.html')) ad ripam superiorem Muadii fluminis: ibique



---

p.468



nostrae religionis vexillum triumphale Christi crucem erexit. Sed locus iste a Monachis postea possidentibus, coepit *Lia na manach*[1131](javascript:footNote('T105008/note1131.html')), id est petra Monachorum appellari.’


‘XCI. lbi etiam baptizavit virum Principem, Eochadium Dathia, sive Davide Fiachrii filio natum: cuius et uxorem Ectram nomine, paulo ante e viris excedentem, vitae restituit ad vadum ante fores Ecclesiae Kill-morensis iacens; quod ex eius nomine *Ath-Echtra,* id est vadum Ectrae nuncupatur. Cui vado et adiacet eiusdem foeminae sepulchrum, quod et similiter ab ea denominationem retinens, *Feart Echtra*[1132](javascript:footNote('T105008/note1132.html')) id est, tumulus Ectrae, vulgo appellatur, ut periti antiquitatum istius patriae ex continua traditione referunt.’


‘XCII. Progressus inde Patricius ad alias Connaciae partes, S. Olcano discipulo suo mandavit, ut post multos labores in praedicatione Evangelii exantlatos, se ad locum quietis, et cellam construendam conferret, reliquam vitae partem in quiete et coelestium con templatione transacturus: et ut singularis obedientiae virtus in discipulo praecellens, et magistro probe nota, mundo etiam manifestaretur, iniunxit ei Ecclesiam aedificare, ubicumque Deus dignaretur ipsi de loco providere idoneo. Filius obedientiae de sui veracissimi Patris praecepti, alias incerti, seu indeterminati, certitudine nihil haesitans, absque mora, gestans in humero securim, arripit itineris initium, cuius et lineam et finem nesciebat. Cerneus pater tantam filii resignationem, voce et consolatoria et prophetica ait; Olcane fili, cum benedictione perge, et ubi securis ceciderit, securus reside et aedificia. His auditis pergit S. Olcanus, et nescius quo pergeret, vel pedem figeret, cum venisset ad locum postea *Kill-mor Uachtair Mhuaidhe* appellatum, securis inopinato e scapulis cecidit, velati coelitus proiecta. Advertens autem vir Dei locum illum esse sibi a Domino designatum, coepit aedificare: et cum sudore multo aedificavit Monasterium, ubi factus est in gentem magnam.’


‘XCIII. In cultu et irrigatione dominicae vineae indefesso studio, de die in diem progrediens vir Apostolicus, et singulos patriae non solum tractus, sed et angulos circumeundo, deflexit versus Boream, venitque ad locum *Leac Bailbene*, id est, petram Balbenii, vocatam. Ubi denuo filios Amalgadii sua benedictione munivit. Deinde per utrosque Bertlacios transiens, ab Occidentalibus ad Orientales Bertlacios profectus, venit ad Muadii fluvii ostia, ubi in Oceanum solvitur. Postquam una filia esset ibi
submersa, fertur vir sanctus ita portum ilium benedixisse, et de eo pronunciasse



---

p.469



nullum in posterum in eo fore submergendum. Praedixit et Bertlacios Orientales ad iura Ecclesiarum suarum olim spectaturos: qui et in continua habent traditione Dominum regionis illius in periculis semper S. Patricii invocatione et patrocino fore protegendum.’


‘XCIV. Ulterius progredienti viro Dei occurrit in finibus istis, et truculente occursat ei populus Gregragiorum; qui non tantum sunt conati ipsum a suis finibus excludere; sed et tanta mentis insolentia in ipsum insurrexerunt, ut ipsum et socios saxis et lapidibus impetierunt. Tunc justae indignationis spiritu motus vir Dei, fertur insolenti populo condignam factis mercedem apprecari, et sic apprecando maledictionis sententia praedixisse eos in omni conflictu caedendos, et ubique fore iugo servitutis et contemptui subiectos. Progrediens autem versus Septemtrionem, cum Muado flumine traiecto veniret in regionem Gregragiorum occurrerunt ei duo ex ilia gente Magi, qui statuerunt eum e medio tollere. Sed servus Dei virtute Domini sui instructas ab eis evadens insidias, praedixit ex eorum progenie magos et maleficos nunquam defecturos.’


‘XCV. Adiit postea vir Sanctus Conallum charissimum suum; cuius probaturus, et remuneraturus mentis pietatem et resignationem ait; Placetne mi Conalle, monasticam a me suscipere tonsuram? Conallus autem respondit se cor habere paratum ad faciendum quod viro Dei placeret. Gavisus Patricius de tanta principis resignatione, eamque larga mercede remunerans, ait; Non fiet quod dixi, sed ego tuis defendar armis; tuque de semine tuo successores habebis condignos: et multi saecularis militiae gloria famosi, multique Christiana coelestis militiae professione conspicui athletae, de eodem prodibunt semine. Et mox cum baculo suo, qui baculus Jesu dicebatur, crucis signum eius scuto impressit, asserens neminem de stirpe eius in bello vincendum, qui signum illud in suo scuto impressum gestaret; ipsumque proinde Conallum *Sciath Bachlach,* .i. scuti baculati, appellandum. Nec mirum sane quod stirpe illa minime foret imbecillis, quae baculi Jesu, omne robur quantumcumque debile fulcientis, impressum signum in suis insignibus, ut symbolum promissae victoriae, iure haereditario gestaret.’


‘XCVI. Inde progressus peragrando oram maritimam regionis de *Hui Fiachrach,* venit S. Antistes ad fluvium quendam; quem, cum ob magnam aquarum illuviem traiicere non posset, sterilitatis maledicto subiectum pronunciavit. Moram tamen iuxta eius marginem contraxit in loco, *Buaile Phadruic* appellato, in quo crux iuxta tumulum posita conspicitur. Ad ipsum in illo loco commorantem venerunt. *S. Bronius* Episcopus de *Cassel-Irra* *et S. Mac-rime* Tutelaris Ecclesiae de *Corca Raoidhe;* *et ibi eis scripsit alphabetum. Et audivi* (inquit vetustus author) *ab alio quod in illo loco dedit dentem ex ore suo Episcopo Bronio, propterea quod charus esset Patricio*’[1133](javascript:footNote('T105008/note1133.html')).




---

p.470


‘XCVII. Baptizavit vir Dei in istis partibus septem Drogenii filios unumque ex eis sibi elegit in alumnum, nomine *Mackercam*: quem videns parentibus praedilectum, quia eum in partes longinquas secum ferre non audebat, commisit S. Bronio Episcopo educandum. Et ipse est, qui praefectus est Ecclesiae de *Kill-roe-mor*[1134](javascript:footNote('T105008/note1134.html')) in regione Amalgadiae. Tunc etiam, vir sanctus iecit fundamenta Ecclesiae de *Cassel-Irra*[1135](javascript:footNote('T105008/note1135.html')); in cuius atrio est saxum, super quem cecidit dens eius supra memoratus.’


‘XCVIII. Susceptum iter prosequutus per oram maritimam Borealis Connaciae, venit Patricius ad fluvium Sligeach[1136](javascript:footNote('T105008/note1136.html')) appellatum: ubi exhaustum corpusculum volens reficere, petit a piscatoribus quatenus velint retia tendere, et suae piscationis beneficio de aliqua piscium refectione providere, qua praesentem relevet naturae necessitatem. Illi responderunt, licet res illa videretur difficilis tempore illo hyemali, se tamen velle eam in gratiam tanti hospitis attentare. Attentarunt, magnumque coeperunt salmonem, quem viro Dei laeti obtulerunt. Quorum benignum obsequium remunerans vir Dei, ipsis bene precatus est, flumenque benedixit, apprecans, et apprecando praedicens, nullo anni tempore pisces in eo defecturos. Quod veridicum oraculum rei continuo probat eventus: nam fluvius ille ita exinde abundat salmonibus, ut nullum sit anni tempus, in quo recentes in eo non reperiantur salmones.’


‘XCIX. Erat inter Patricii discipulos unus, nomine *Rodanus* vir profundae humilitatis et observantiae . Hic ut erat obedientiae singulare specimen, quia omnia ad Magistri nutum faciebat; ita bruta animantia eius nutui per omnia parebant. Praefectus enim a Magistro armentis fratrum pascendis et custodiendis, ita hanc curam obibat ut vituli ad ubera matrum sugenda non accederent, nec ab eis recederent, nisi ad eius, licentiam dantis, vel revocantis, nutum. Hunc Patricius postea iuxta virtutum 



---

p.471



et meritorum exigentiam Episcopum ordinavit, et Ecclesiae de *Kill-rodain* in regione de Muiresch-aigle[1137](javascript:footNote('T105008/note1137.html')) praefecit.’


‘C. Patricio Connaciae circuitum ad exitum prope ducenti et transeunti, constructis insidiis occurrerunt viri *Calregiae de Culechernadan*[1138](javascript:footNote('T105008/note1138.html')) armorumque ac clypeorum strepitu, clangoribus, et clamoribus excitatis satagerunt sanctum Dei, ejusque socios terrere, ac de suis finibus fugatos propellere. Ad quos vir sanctus quod in spiritu vidit, dixit; quia contra inermes armati insurrexistis; et pacis et salutis nuncios e finibus vestris effugare contendistis; vos ipsi vestrique posteri in die belli, velut oves, in fugam acti, hostibus terga dabitis. Haec illi audientes, valde consternati sunt, et super temeritate sua poenitentiam agentes, omnes praeter quinque in genua provoluti veniam humiliter postularunt. Vir misericors paululum, velut deliberans, tacuit, et mox alio praesago et consolatorio oraculo ad eos ait; stabit fixum quod Dominus per os meum loquutus est: attamen quia erroris veniam humiliter postulatis, in nullo conflictu, etiamsi omnes Counnacii vos insequantur ultra quinarium numerum ex vobis occumbent. Et hoc oraculum impleri continuo probat eventus.’ — Septima Vita S. Patricii, lib. ii. — **Colgan**, Trias Thaum. 140.


### Q *recte R*

### Eoghan Beul, King of Connaught.


*See page* 312, note y *i. e. p. 313, note 927 in the CELT edition*. — In the Life of St. Ceallach, Bishop of Kilmore Moy, who was the son of this Eoghan Beul, there is a curious account of the battle of Sligeach (Sligo), in which his father, Eoghan, fell. It makes distinct mention of this king's onchu, or banner, and of the meirgeadha, or standards, which his chieftains carried on their plundering excursions into the other provinces. It goes on to state that Eoghan lived three days, or, according to others, a week, after being mortally wounded in the battle, in which time he advised the Hy-Fiachrach to elect his son Ceallach King of Connaught, and requested of them to go to Clonmacnoise, where he was under the tuition of St. Kieran, and in treat of him to come home with them and accept of the kingdom,



---

p.472



for that his second son Muireadhach, otherwise Cuchoingeilt, was not of age to succeed him. They did so, and Ceallach was induced to go with them, contrary to the wish, and without the knowledge of his saintly tutor, who thereupon pronounced a curse against him which finally wrought his destruction; for though he was afterwards reconciled to St. Kieran, and raised to the episcopal dignity, the curse could not be revoked, and he was afterwards driven from his bishopric, and, as already stated in Addenda G, murdered by his own four pupils, at the instigation of Guaire Aidhne, King of Connaught. King Eoghan ordered himself to be interred in a standing position, with his red javelin in his hand, and with his face turned towards Ulster, as if fighting with his enemies. This was accordingly done, and the talismanic result was, that as long as the body was left in that position the Connacians could not be defeated by the Ultonians, but whenever they came in collision the Ultonians were defeated by the Connacians. The Ultonians, on learning the cause of this, disinterred the body of Eoghan Beul, and carrying it north of the River Sligo, buried it with the face under, at the cemetery of Aonach Locha Gile near Lough Gill, in the present county of Sligo. This supersittion is so curious, that the editor hopes to be excused for giving the original account of it, word for word, with a literal translation.


{column 1}
‘As bert fos Eogan a adnacul ocus a gha dearg ana láimh is in uadh. ‘Ocus tobair m'aighi ar in tuaisgirt, ar taebh na tulcha i ngebaid in tuaiscert re cath cuigedh Connacht, agus aigheadh m'uaighi-si forro, agus mé féin innti ar in corughad sin.’ Ocus do coimlead co fír an sgel sin; uair gach inadh a tegmad Clanna Neill d'á cheile ocus Connachtaidh, do muigeadh maidhm do gnúisib ar Clannaib Néill ocus ar in tuaiscirt ann; conad h-í comhairle do rinni Clanna Neill agus tuaiscirt Erenn uime sin, teacht sluaigeadh mór co Ráith O Fiachrach, ocus Eogan do thógbháil as in adhnacul, ocus a thaisi do bhreith leo tar Sligeach fo thuaidh; ocus ro h-adhnaiceadh tall h-é, a n-aenach Locha Gile, agus a bél re lár, co nach beith doib sin 'na chonair teithighthe do cinnti re Connachtaib.’


{column 2}
‘Eoghan also told them to bury himself with his red javelin in his hand in the grave. ‘Place my face towards the north, on the side of the hill by which the northerns pass when flying before the army of Connaught; let my grave face them, and place myself in it after this manner.’ And this order was stricly complied with; and in every place where the Clanna Neill and the Connacians met in conflict, the Clanna Neill and the northerns were routed, being panic stricken by the countenances of their foes; so that the Clanna Neill and the people of the North of Ireland therefore resolved to come with a numerous host to Raith O'bh-Fiachrach and raise *[the body of]* Eoghan from the grave and carry his remains northwards across the Sligo. This was done, and the body was buried at the other side *[of the river]*, at Aenach Locha Gile, with the mouth down, that it might not be the means of causing them to fly before the Connacians.’




---

p.473


The custom of thus interring Irish kings and chieftains in a standing position is often referred to in Irish historical tales. It is stated, for example, in the Leabhar na h-Uidhri, a compilation made at Clonmacnoise in the twelfth century, that the monarch Loeghaire, who was cotemporary with St. Patrick, but who had never been converted to Christianity, was interred in the external rampart of *Rath Loeghaire*, at Tara, in a standing position, with his military weapons upon him, and having his face turned southwards upon his enemies, the Lagenians, as if fighting with them, or bidding them defiance.


The following very curious allusion to the same King Loeghaire, and to the custom of the internment of kings in a standing position, with their arms, is found in the Book of Armagh, which contains perhaps all the old fragments of Irish literature now remaining to us:
  

*Perrexitque ad civitatem *Temro* ad Loigairium, filium Neill, iterum, quia apud illum foedus pepigit ut non occideretur in regno illius. Sed non potuit credere, dicens: ‘Nam Neel pater meus non sinivit mihi credere, sed ut sepeliar in cacuminibus *Temro* quasi viris consistentibus in bello: quia utuntur gentiles in sepulcris armati prumptis armis facie ad faciem usque ad diem *Erdathe* apud Magos, id est judicii diem Domini. Ego filius Neill et filius Dunlinge *im Maistin* in Campo Liphi, pro duritate odivi’&c. ’’*

Annotations of Tirechan, Book of Armagh, fol. 10, a, 2.


There is a curious little poem quoted by Duald Mac Firbis in his large genealogical work, describing the residence of King Eoghan Beul, but the Addenda to this volume having been already extended to too great a length, the Editor thinks it better to reserve it for some future work. It was situtated on the island of Inis Eoghain, in Lough Mask, on which the Editor saw distinct traces of its earthern ramparts in the year 1838.


*John O'Donovan's Addenda and Corrigenda are integrated into the electronic text; and the list (pp 473–476) is omitted from this electronic edition.*




---

p.476


Do críochnuigheadh an obair si, iar mór shaothar agus dúthracht, a n-Ath Cliath Duibhlinne, an t-ochtmhadh la déag de mhi Iuin, 'san mbliadhain d'aois ár d-Tighearna 1844, le Seaan, mac Eamainn Oig, mhic Shen Eamoinn, mhic Uilliam, mhic Chonchubhair Ui Dhonnabáin; agus má gheibheann an léightheoir ní inbhéime innte, creideadh sé gur tar díthcheall an fhir friotail do chuaidh; agus cuimhnigheadh lucht a h-inchreachta nach bh-fuil obair dhaondha fá'n ngréin saor ó lochtaibh, agus gur minic do h-inchreachadh deagh-shaothar go h-éagcórach tre fhormad agus mhiosgais n-easccarad, agus fós tre a n-aineolus.