

#The Effect of Emigration on the Irish Church


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Effect of Emigration on the Irish Church
============================================


Author: Patrick Augustine Sheehan
---------------------------------


### File Description

Electronic edition compiled by Beatrix Färber

Funded by School of History, University College, Cork 1. First draftExtent of text: 6200 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland— http://www.ucc.ie/celt

 (2013) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E880000-001Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript**2. Cork Archive?
**Canon Sheehan on the Internet**2. http://www.canonsheehanremembered.com.
**Literature**2. Herman Joseph Heuser, Canon Sheehan of Doneraile: the story of an Irish parish priest as told chiefly by himself in books, personal memoirs, and letters (New York 1917).
3. Arthur Coussens. P. A. Sheehan, zijn leven en zijn werken (Brugge/Bruges 1923).
4. Michael P. Linehan, Canon Sheehan of Doneraile: Priest, Novelist, Man of Letters (Dublin 1952).
5. Patrick J. McLaughlin, "A Century of Science in the I.E.R.: Monsignor Molloy and Father Gill," The Irish Ecclesiastical Record, vol. 102, 5th series (July—December 1964), p. 265.
6. James O'Brien (ed.), The Collected Letters of Canon Sheehan of Doneraile, 1883–1913 (Wells 2013).
7. James O'Brien, Canon Sheehan of Doneraile 1852–1913: Outlines for Literary Biography (Wells 2013). [Bibliographical references 205–11.]
8. Joachim Fischer, 'Canon Sheehan und die deutsche Kultur', In: Joachim Fischer, Das Deutschlandbild der Iren 1890–1939, (Heidelberg: Winter 2000).
**The edition used in the digital edition**2. **Robert Browne**, The Effect of Emigration on the Irish Church in Irish Ecclesiastical Record, Ed. . , Dublin, Brown & Nolan, Nassau Street (1883) series 3volume 3page 602–615

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic text represents the edited version.


#### Editorial Declaration


##### Correction


Text has been checked and proof-read twice.


##### Normalization


The electronic text represents the edited text.


##### Quotation


Direct speech is rendered q. Citations are tagged cit. This element contains bibl and qt elements.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, the page-break and line-break are marked after the completion of the hyphenated word.


##### Segmentation


div0= the essay.


##### Standard Values


There are no dates.


##### Interpretation


Some personal names and place-names are tagged. Quotes have been identified where references have not been supplied by the author.


### Profile Description


Created: By Patrick Augustine Sheehan (1852–1913)
 (1883) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] A few words and quotes are in Latin.


##### Language: [FR] A few words and phrases are in French.


### Revision History


* (2013-11-11) Beatrix Färber (ed.)

* Additions to bibliographical details made.
* (2013-07-15) Beatrix Färber (ed.)

* File parsed and validated; SGML and HTML versions created.
* (2013-07-13) Beatrix Färber (ed.)

* Header created.
* (2013-07-12) Beatrix Färber (ed.)

* Text proofed (1); structural and some content mark-up added.
* (2013-07-12) Beatrix Färber (file capture)

* Text scanned.
* (2013-07-12) Mary Lombard (file capture)

* Text photocopied for CELT.




---


#### Corpus of Electronic Texts Edition: E880000-001


### The Effect of Emigration on the Irish Church: Author: Patrick Augustine Sheehan




---

p.602


When **Emerson** on his second voyage to England, thirty-five years ago, passed along the southern coast of Ireland, looking with the eye of a poet on the green fields that clothed the bold headlands of Cork and Kerry, he observed: *As we neared the land, its genius was felt. There lay the green shore of Ireland, like some coast of plenty. We could see towns, towers, churches, harvests; but the curse of eight hundred years we could not discern.’’*

Ralph Waldo Emerson, English Traits, II. Voyage to England.

 The experience of the Irish priest differs from the experience of the American philosopher. The curse is only too visible to us. Nor is there any sign that it is about to be immediately lifted. Nay even, as the years go on, and civilization advances, and new republics are created, and new races spring into existence, and with buoyancy and vigour push along in their course of success and happiness, that awful curse seems to be sinking deeper and deeper into the fate and fortunes of our country. Strangest problem of all, to which no historian will ever find a key, which the great day of Retribution alone will solve, our people, banned, persecuted, and exiled, with the curse clinging to their very garments, are yet not only the apostles of a saving faith, but the only elements of the stability and strength with which these new races, proud but powerless, can be ever cemented together.




---

p.603


Yet Ireland has not wanted physicians to cure her temporal ills, nor seers and prophets and conjurors to exorcise the evil spirit that possessed her. With terrible iteration she has been subjected to the operation of every new method of statecraft and spiritcraft that human ingenuity could devise. Remedial measures, alternately drastic and soothing, have been applied; and yet she remains what she was made seven hundred years ago, an ‘interesting case,’ confessedly incurable, and with morbid symptoms enough to engage the attention of every fresh expert that shall come to the front during the next fifty years in the schools of English politics. In our days, however, a new departure has been made — not ‘new’ in a historical sense, but in the sense that a well-tried system has been revised and refitted with all modern improvements. It has been discovered that, notwithstanding the loss of half her life blood, three millions of her people in thirty years, Ireland is still suffering from congestion. And not only professional, but amateur politicians are hurrying forward with zeal to relieve her. A Bill has just passed through Parliament for advancing State aid to assist emigration; private speculators, very active within circumscribed limits, are carrying out the new experiment; it is urged on and warmly recommended by leader writers and pamphleteers; thousands of pounds are subscribed by philanthropists and doctrinaires; tens, and hundreds of thousands are subscribed by the landed gentry for the same purpose, and a new plantation of the country openly suggested. Now, how does all this affect us, Irish priests? How does it affect the Church with which we are so closely identified? What influence has this perpetual, never-ceasing exodus of our race upon the future fortunes of the Irish Church? We desire to discuss the question without any reference to existing controversies, except where facts are to be adduced in corroboration of principles or statements. We have no desire to import the angry elements of political strife into the calm pages of a theological journal. We simply wish to show the effect on the Church of this terrible drain on the strength of the country. It is a question in which we are deeply interested. We may belong to that section of the Irish priesthood, whose sympathies with our long suffering people are so intense, that the master passion of their lives is to see that people glorified, and its unutterable wrongs avenged; or we may belong to that milder school who believe that politics is ‘that mighty drama, where



---

p.604



men vex themselves, and God leads them;’ but whatever shades of opinion the Irish priesthood may profess, all are blended in a passionate pride at the glories of the Irish Church in the past and present, and an enthusiastic faith in the extension and perpetuity of those Christian triumphs, which form at once her martyrdom and her crown.


Now, to what extent has the Irish Church suffered in the past? Our losses for the last thirty years have been so frequently mentioned that they no longer excite either curiosity or pain. It is enough to say that the Irish Church has been shorn of half its strength during that period. It has lost half the merits that would have been accumulated in that time by a nation of saints, half the merits that would have been stored away in the treasury of Heaven, gained by the patience and the prayers, the humility and stainless purity of our people. It has lost, too, half its material strength[1](javascript:footNote('E880000-001/note001.html')) — half the assistance that might have been given to works of religion and charity by a people who would sacrifice their last shred of clothing or food for the honour of God and the glory of the Church. We are afraid we should scarcely be believed, if we drew from the experience of the present a picture of what Ireland would have been, had her three millions of children been spared her. With all her poverty and misery, she has spent on works of ecclesiastical architecture alone £4,000,000 in thirty years; and during that time she was afflicted with three famines that would have swept from the earth any nation not endued with her marvellous vitality. What would the Irish Church have been if the towns, now half deserted and impoverished, were filled with Catholic populations, full, of Celtic faith and generosity, carefully directed under the skilful hands of holy directors through the medium of confraternities and sodalities? What would she have been if her rich valleys teemed with life, the fruitful life of the ‘first peasantry in the world,’ as Lucas used to call them? What would she have been if her schools were filled with that brave, strong, bright-hued, bright-eyed youth, who have upheld the honour of Ireland and Ireland's faith in the sanctuaries, the senates, the forums, and the exchanges of the world? What would she have been if her convents were filled with those gentle, holy children, whose innocence and simplicity shining 



---

p.605



through their faces attracted the attention of **Dr. Newman** thirty years ago, and showed him what hereditary faith and holiness can do in effecting even a transfiguration of the features? What a mighty army of trained missionaries we would have sent forth if Ireland's power and the energy of her children were unimpaired! It would have been in truth the ideal of a Christian Church. Well, God's will be done! God knoweth best! We cheerfully made the sacrifice, and behold our reward! The exiles have prospered. The 3,000,000 have grown to 10,000,000. The Irish towns are deserted, but the American cities are filled. We miss many a stately spire, many a sanctuary of learning and piety; but the same hands that would have built them here, have raised them in ten-fold number and grandeur and magnificence through every city of the States. Our valleys no longer echo with the murmur of the Rosary, told in the fields and cottages, but the Indian has learned that dear prayer from the Irish exile, and it echoes from Aherlow through the gorges and canons of the Rocky Mountains. Our people no longer dwell under the ‘little span of sky, the little patch of stars,’ that covers the land of their birth; but the blue firmament springs over them from the horizon of the boundless prairies, and the eye of God is there.


Let us come back to the present. During the last three years, emigration, that might be almost said to have ceased, has set in, in a full strong tide that reminds us of the panic of the famine years. During the first four months of this year, 39,000 Irish people passed through, this port of **Queenstown** en route to America; and I think we shall not exaggerate when we state, that during the same period at least 10,000 left for America or England, through **Londonderry**, **Limerick**, **Galway**, and **Dublin**. This is a total of 50,000. During the same months of the present year, or rather during the first quarter, 7,000 persons were evicted without being reinstated as caretakers, and during the second quarter that number increased to 11,000. In the month of May alone 1,198 persons were evicted in one riding in the County **Galway**, and the evictions became so alarming, that they drew forth a protest and remonstrance from the official reticence of the Chief Secretary. Again, we are not exaggerating in stating the number of evicted persons this year as 50,000 more. That is, 100,000 of her population have been lost to Ireland this year. That means the ‘million a decade,’ which, in 1848, drew forth an



---

p.606



indignant and despairing threnody from the pen of **Speranza**. One million lost to Ireland every ten years! What will the Irish Church be in the dawn of the 20th century?


But these figures are vague. Let us apply them. The departure of 100,000 people in twelve months, means the destruction of thirty Irish parishes — it means the annihilation of an Irish diocese! If the city of Cork, with its bright intelligent population, its wonderful charitable and educational institutions, its wealth and its public buildings, were suddenly engulfed by an earthquake, or swept to destruction by a tornado, Ireland would mourn the loss for years. Yet she suffers an equivalent loss year by year, and remains apparently unconscious of it. If twenty-five towns of the size and population of **Youghal** or **Tipperary**, or **Kilkenny**, were suddenly destroyed, with their inhabitants, Ireland and the world would be appalled. Yet, so far as our country and Church are concerned, we are actually suffering this pictured calamity. The student of Irish history reads with horror the attempted extermination of the Irish people by **Cromwell**. Eviction and emigration are doing more than Cromwellian work in our day. Such, briefly, is the extent of the depopulation that is going on at present. Now, what is its character? There is a marked difference between the emigration of 1850 and succeeding years, and the emigration of 1882. During the former period, **Queenstown** was thronged with a multitude of pale, panic-stricken people, flying from that awful vision of plague and famine that had haunted them night and day for three years. They made no account of the wretched vessels that were to bear them on a tedious and perilous voyage across the Atlantic. They did not reckon their chances of reaching the shores of America alive, in those dreadful hulks, justly designated ‘coffin-ships.’ They felt as if escaping from a prison of death; and yet it was with tearful eyes and heavy hearts they turned from the dark masses that lined the quays, to the dark chambers and the dismal daily duties of an emigrant ship. For their future was very uncertain. They did not know what awaited them in the strange land beyond the waters. And the crowds of friends on shore shared their apprehensions and their fears. ‘Shall we ever see them again?’ was the question that passed from lip to lip, as they looked and strained their eyes after the vessel, until she turned to the west, and passed from their sight beyond the headland. Then arose, day after day, in the ears of the tortured



---

p.607



inhabitants those awful cries and lamentations, that even to this day are a troubled memory to our people.
  

*Continuo auditae voces, vagitus et ingens,
  

Infantumque animae flentes, in limine primo.’’*

Vergil, Aeneid VI, 426–27




All this is now changed. Instead of ‘coffin-ships’ we have now the floating palaces, where even an emigrant must be treated with humanity. Instead of a long and doubtful voyage of three months, we have a quick, short passage of seven or ten days. Instead of the shadowy country, half colonised and half civilised, there is the mighty empire with its fairy cities, its broad fertile prairies, its warm welcome to outcast humanity, and where frugality and industry are certain to lead to wealth and opulence. And, therefore, instead of the poor half-starved, emaciated emigrants of thirty years ago, the pinched and pale-faced women, the tiny weaklings, the grey and stooping veterans, we find passing through this port in the spring and summer time the very pick and choice of the land — fair women, and ‘stalwart, muscular, dauntless young braves,’ to borrow the words of an American writer, ‘brimful of push and energy, and royally endowed with every attribute that goes to make up a peerless and magnificent manhood.’ No longer labourers, with their wives and children, who, after many years and much labour, have put together the few pounds that will pay their passage; but the strong, intelligent artisans of our towns, and farmers' sons, who prefer the bustle and life of an American city to the monotony of country life at home: and farmers' daughters who sacrifice their dowries, and a certain prospect of marriage, for the pleasure of serving in a business house in New York, or even going into situation as housemaids in American families. And hence, too, there is no longer the sad weeping and melancholy farewell, but buoyancy, and cheerfulness, and hope. Nay, even, they do not carry with them, like the emigrant of 1850, one single reminder of their nationality, not a shamrock nor a ribbon, as if they were casting off all allegiance to the mother land. And the crowds on shore look with envy at the fortunate friends who are escaping. They no longer shout an everlasting farewell, but a ringing cheer, which is strengthened by the hope that when the letter and passage-money arrive, they, too, will be able to leave this land of bondage, and follow their friends to the promised land in the wake of the setting sun.




---

p.608


And this exodus threatens to become recurrent, until either the country becomes quite exhausted, and reduced to the 800,000 who survived the Cromwellian extermination, or something is done to counteract the attractions of foreign countries by giving our people a means of securing a decent maintenance at home. America must become the ultimate destination of our race, and this in an incredibly short space of time, unless something is promptly done to equalise the conditions of life in the two countries. The wonderful advantages it offers to the young, who are intelligent and enterprising, will increase as fresh contingents add to its population, its wealth, its activity. Fresh fields of enterprise are being daily opened up in the Western States, whose mineral and agricultural resources cannot be even conjectured; and when the pioneers of the coming race shall have surmounted the stubborn obstacles which untamed Nature always presents to her conquerors, a prospect of infinite prosperity will open up to the future and fortunate possessors.


Whilst America is beckoning and leading, friends at home are pushing and driving the Irish peasant in the same direction. The provisions of the Bill that has just received the Royal sanction are well known; it may not be so well known that private enterprise had anticipated the Bill, and was carrying into effect the object of the Bill, whilst it was being debated in the Commons. The Committee, of which the Duke of Bedford is president, and Mr. Tuke, the active voluntary agent, have published their report, from which we take the following extracts: —

> 
> 1. ‘The committee claim that upon the whole the results of their work have been successful. They have done the work cheaply and thoroughly, having emigrated some 1,200 persons, chiefly in families, at a cost of a little over £6 a head.’
> 2. ‘Taking into account the distressing poverty of the people in the special districts named, and their proved desire to emigrate, the committee are convinced that a vast amount of work in the way of emigration still remains to be done.’
> 3. ‘A systematic emigration judiciously assisted seems to be the only hope for the population, the best chance alike for those who go and those who remain.’
> 4. ‘The population of these districts is so large, the holdings are so small, and the soil generally so poor, that even if the tenants had no rents to pay they would for the most part be unable to maintain themselves even in good seasons.’
> 5. ‘The subscriptions to the fund already paid in of promised 
> 
> 
> 
> ---
> 
> p.609
> 
> 
> 
> amount to £9,613, including £1,000 each from the Duke of Bedford and the Duke of Devonshire, and £500 each for two years from Mr. Wm. Rathbone, M.P., and Mr. Forster, M.P.’
> 
> 
> 
> 




We cannot throw a doubt on the philanthropy of Mr. Tuke. He belongs to a family which has always taken a deep interest in Ireland. Nor shall we say a word of the propriety of scattering the population of Connemara on the deserted plains of Meath, instead of banishing them to Manitoba. Nor yet shall we deny that the members of the above-named committee are ‘all honourable men.’ We are simply quoting facts and figures to prove the extent and character of emigration. We are neither criticising motives, nor imputing intentions. Mr. Tuke's scheme is but one of the many that are working towards the same end. He is the type of the practical worker. The best example of the doctrinaire and dreamer is, we suppose, Lady Wilde. Her opinion of the present is: —


*‘The vital force of our people is wasted year by year in the bitter strife with other men as destitute as themselves, for an acre of land, more or less, some wild tract of dreary bog, or a few stacks of turf on some desolate moor, while all the time a new world is waiting to be occupied, where everything they had dreamed of vainly, and worked for sadly, from their youth up, can be realised and enforced,’ Her vision of the future is: — ‘What can be more bright or gorgeous, or better suited to the Irish nature than the golden vales and emerald plains of their fair country, covered with flocks and herds, or the silver salmon leaping in the nets under the shadow of the purple mountains of the West, where the fiords of the Atlantic bite deep into the land, and the rushing streamlets murmur a divine music through the chains of the hills? Such a landscape never should be desecrated by the tall chimneys of the factory prison, nor by the smoke of furnaces rising up to obscure heaven.’’’*




No! and, therefore, Lady Wilde would reduce the population of Ireland to 2,000,000, and make it a pleasure-ground for aesthetic Britons, for whom there should be ‘good roads, good country hotels, pleasure boats on the lakes, branch railroads for safe and rapid transit, with a line of passenger steamers to Southern Europe.’ The accomplishment of this day-dream requires the expatriation of the Celtic population, and for this purpose Lady Wilde would grant a colossal State subsidy. And this was the ‘Speranza’ of '48. How are the mighty fallen!




---

p.610


Now, while Government officials and private speculators, while politicians and philanthropists, committees and companies, by threats, promises, subsidies in money, and gilded prophecies, are vying with each other in effecting the depopulation of Ireland, what are we doing? Even some American bishops are seeking to establish and extend new dioceses in Minnesota and elsewhere by the aid of Irish colonists, and we see all this going on without a murmur. Are we fatalists, believing in the inevitable destruction of our race? Do we suppose that the traditions of Ireland and Ireland's faith are coming to an abrupt and inglorious termination? Or are we merely apathetic, leaving all things to chance, in the good old Irish way? If so, we shall be rudely awakened. For if wise men foresee the future rightly, the emigration from Ireland next spring and summer will be unprecedented in Irish history. Even now in the dull autumn season, hundreds are passing through **Queenstown**. In the spring-time of next year the emigrants will be numbered by tens of thousands!


If this state of things continue, in less than ten years, the ancient ecclesiastical divisions of Ireland will be obliterated, and parishes amalgamated with parishes. The young Irish priests of the year 1900 will have the novel experience of going fifty or sixty miles to a sick call by rail: and the few who will be left to celebrate the centenary of Catholic Emancipation, will make it the event of the day, like Cromwell's soldiers, to see smoke issuing from the hut of a Catholic peasant, and will have the gratification of hearing those splendid churches that we are building with Irish money and Irish hands echoing with the ‘grand old Puritan anthem,’ sung by the Scotch planters and English yeomen who are coming to take the place of the ‘Irishrie.’


But it has been said again and again: ‘Is not this our destiny? Do we not see that we are the ‘chosen people, the kingly nation, the missionaries of the world?’ That we are not tempted with earthly wealth, but royally endowed with all spiritual affluence; and that as the priest on Holy Saturday breathes on the consecrated water, and scatters the saving element to the four points of heaven, so God's spirit breathes on our people, and scatters them, and with them the gift of saving faith amongst the less favoured nations of the earth?’ We will not retort by asking our questioners what they have done for the Faith. For whatever be the motives of those who habitually vilify our people, but grant them at least this high prerogative,



---

p.611



we are certain that this is our destiny, and that we must accomplish it. We should be impious to disclaim it: we are proud to admit it. We see the miracle of Christian Rome under the Pagan Caesars repeated in our day. A little band of neophytes, persecuted and despised, carried the Cross under the very shadow of the eagle to victory, and saw territory after territory, and race after race, conquered by the sword, pass under the peaceful sway of the crozier. Another empire has arisen in our day, rivalling and even surpassing that of Pagan Rome in material and intellectual wealth, and another race has been the victim of oppressions that surpass the cruelties of Nero and Diocletian. Yet, wherever the mightier race has gone, the weaker race has followed, and established a spiritual empire, conterminous with that political empire, on which it is boasted the sun never sets. Nay more. We claim for Ireland the proud distinction of being the right arm of the Church in the present age. France, once so distinguished, is paralysed by the Red Terror, and has to devote all her energies to saving the faith of her people. Spain, cradle of Doctors and Saints, is lethargic and indifferent. Italy, centre of Catholicity, is disturbed by revolution. Ireland alone still sends throb after throb of energy and vitality through the Catholic world. Remove the Irish element from England, and what would the Church in England be? Take away the Irish operatives in the factories of Lancashire and York, the Irish dock labourers in Liverpool and Birkenhead, the Irish miners in Wales, and the half million Irish in London, and where would be the flourishing dioceses of Beverley and Leeds, Liverpool, Shrewsbury, and Westminster? Take the Irish element from America, and that empire-Church would consist of a few straggling dioceses, colonised by Germans and native converts. Is it not admitted by all who can look below the surface, that the Catholic Church in America would not maintain for a quarter of a century its purity of faith, its fidelity to the Holy See, its energy in withstanding the violent assaults of free-thought and atheism, its zeal for the glory of God, and the triumphs of Holy Church, were it not for that continuous stream of Irish immigration, which vitalizes a population that has the natural tendency to become torpid through excessive prosperity? Who founded, and still maintain, the Catholic Church in Australia, Tasmania, New Zealand? The Irish exiles, and their descendants, who, whatever their faults may be (and we are not disposed to deny or excuse them) 



---

p.612



must still be allowed the singular credit of having adhered with unwavering fidelity to those great principles, enunciated by our Blessed Saviour, embodied in the teaching of the Apostles, developed by the Church, and interpreted by the lives and examples of the saints. Well might the great French preacher, Montsabre, apply to Ireland the words of the Psalmist: — 

> 
> ‘The strangers have upon their lips the language of vanity, and their deeds are full of iniquity. Yet their sons spring up among them like fresh plants; their daughters are dressed out like idols; their barns are so full that they send to each other their abundance. Their oxen are sleek and fat; their walls are strong, and defy the night-prowler; no complaint or murmur is heard within their walls; and it is said — Happy the people who possess all these riches.’ Well no, brethren; happy rather are the people who have the Lord for God: ‘Beatus populus cujus Dominus Deus ejus.’
> 
> 
> 




This lofty destiny, of course, involves a mighty sacrifice — a sacrifice on the part of the people, and a sacrifice on the part of the priests. On the part of the people it involves the abandonment of home, and the rude severance of all those sacred ties that are formed in infancy and strengthened in manhood. It involves a change from the quiet holy life of the Irish mountain and valley, to the tumult and the bustle, the ambition and the sin of mighty cities. It involves that ordeal of ‘white slavery,’ through which most of our countrymen have to pass, before they reach independence — it involves the hatred and contempt that are liberally poured on our people by those who, trained in the Neo-Paganism of our century, have neither intelligence to understand Irish faith, nor grace to appreciate Irish virtue, nor charity to excuse our failings, nor humanity to sympathise with our sufferings. It involves the inevitable spiritual destruction of thousands, who would live and die in sanctity at home. It involves the melancholy belief that many of the children of Irish exiles forget their country and their faith — that many of the second or third generations, while bearing Irish names, are the enemies of the Irish race and religion.[2](javascript:footNote('E880000-001/note002.html')) And for us priests, is it no sacrifice to see our parishes depopulated, our churches deserted, and the flower of our youth passing 



---

p.613



away from us for ever? Is it not a trial for us to see the fields lying waste, and the houses unroofed, where many a pious Catholic family was worshipping its God in all humility and patience? To see the children whom we educated from their earliest years, and whom we are handing over to strange pastors as pure as we raised them from the font of regeneration, transferring their virtues and their faith to illustrate other lands, and edify an alien nation? It is a sacrifice, but necessary. The Apostles would never have evangelised the world had they yielded to the passionate love of their race, for their city and temple. Europe would not have been converted so rapidly were it not for the Irish doctors, who carried the lamp of learning and sanctity through its cities and kingdoms. Ireland itself would not possess the priceless gift of faith, had its great Apostle put the claims of his country before the wants of the people who cried to him in his dreams. It is a sacrifice, but also a glory, not that we care for glory —
  

‘No lovers of glory we;
  

Give us the glory of going on, and for ever to be.’
  

Ah! there it is. Keep the fountain running, and you may scatter its waters where you please. Keep the vestal fire of Irish faith and Irish purity burning, and let the nations come and take with them whatever they need to enkindle similar sacred fires in their own lands. Secure for us the simple certainty that the population of Ireland will not fall below its just and normal standard, and we engage to make saints and scholars for the Universe again. This we ask for the sake of the Irish Church, which cannot survive the extermination of the people; and for the sake of the Universal Church, whose faithful son Ireland has ever been.


Little though the demand be, however, it will take all the energy and activity that we can put forward to enforce it; but surely we ought to be as anxious to preserve our dioceses as foreign bishops are to create theirs. For this purpose, emigration should be strongly discountenanced in all those provinces, dioceses, and parishes, where the irremediable poverty of the people does not make it absolutely necessary. It is certain, and that certainty is confirmed by every bishop and priest to whom we have spoken on the subject here, that nowhere can our people live so wisely or so happily as at home, and that so long as an Irishman can obtain a decent maintenance in Ireland, he should not attempt to emigrate.




---

p.614


Again, let us not expect prosperity for our people so long as they are dependent on the agricultural resources of the country. Employment must be created for the surplus population of town and country by the establishment and development of local industries. The ‘whirr of the wheel, the gliding of shuttles, the ringing of steel,’ must be the Resurrection March of our people. In that very department over which we have immediate control, ecclesiastical art and architecture, it is in our power to help and even create fresh industries, and possibly revive that handicraft in which one visit to the Royal Irish Academy will prove the ancient Irish to have been proficients. A glance over a single church will show the mighty power we possess, even without travelling outside the sanctuary. Stonework and sculpture, iron and brass fittings for altar-rails, castings, pedestals, brackets, and altar-furniture; stained glass for windows; oak-carving for pulpits, sedilia, thrones and stalls; gold and silver and jewel work for the sacred vessels; embroidery and embossing with gold and silver, lace-making, &c., for vestments; organ-building, bell-founding, &c., &c.: these are but a tithe of the industries we can foster and protect, if we once learn the useful lesson of keeping our money at home, and not being too solicitous for the welfare of the artificers of Paris and Lyons, Munich and Manchester.


We commenced this paper with something like a dirge. We desire to close it more hopefully. It is highly probable that at last we are moving forward — that the patience and prayers of ages are about to be rewarded. As the poet persuades himself in all his doubts and misgivings, that ‘somehow good will be the final goal of ill,’ we, too, persuade ourselves that under the hands of a benign Providence, a mission of usefulness, and yet of happiness, is before us. Through the long period of their captivity, the Jewish exiles were cheered by the prophecies and promises that had been made them. They believed in the infallibility of the former; they trusted in the inviolability of the latter. Again and again have our priests and bards compared the Irish race to the chosen people, in their selection by Providence, in their trials, their captivities, their hopes. Perhaps it would not be quite out of place if we repeat and apply to our own beloved nation a promise, replete with joy, with hope, and with triumph: — 
  

*‘I will close thy scar, and will heal thee of thy wounds,’ said the Lord. ‘Because they have called thee, O Sion, an outcast;



---

p.615



this is she that hath none to seek her. Behold, I will bring back the captivity of the pavilion of Jacob; and out of them shall come forth praise, and the voice of them that play; and I will multiply them, and they shall not be made few; and I will glorify them, and they shall not be lessened. And their assembly shall be permanent before Me, and their leader shall be of themselves; and their prince shall come forth from the midst of them.’
  

‘The Lord will not turn away, until He shall have executed and performed the thought of His heart. In the latter days ye shall understand these things.’’’*

(Ezech. xxx.)




P. A. SHEEHAN.

