

#The conduct of the Allies


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The conduct of the Allies
=========================


Author: Jonathan Swift
----------------------


### File Description

Electronic edition compiled by Beatrix Färber

Funded by University College, Cork and  
Writers of Ireland II Project 1. Second draft, revised and corrected.Extent of text: 24600 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork.  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2008) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E700001-019Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions and secondary literature**2. An excellent bibliography covering many aspects of Jonathan Swift's Life, his writings, and criticism, compiled by Lee Jaffe, is available at http://www.jaffebros.com/lee/gulliver/bib/index.html.
3. J. Bowles Daly (ed.), Ireland in the days of Dean Swift, Irish tracts 1720–1734. (London 1887).
4. Frederick Ryland (ed.), Swift's Journal to Stella, A.D. 1710–1713. (London 1897).
- Temple Scott (ed.), A tale of a tub, and other early works. (London 1897).6. Frederick Falkiner, Essays on the portraits of Swift: Swift and Stella. (London 1908).
7. C. M. Webster, Swift's Tale of a Tub compared with Earlier Satires of the Puritans. Proceedings of the Modern Language Association 47/1 (March 1932) 171–178.
8. Stephen L. Gwynn, The life and friendships of Dean Swift. (London 1933).
9. Stanley Lane-Poole (ed.), Selections from the prose writings of Jonathan Swift with a preface and notes. (London 1933).
10. Ricardo Quintana, The mind and art of Jonathan Swift. (Oxford 1936).
11. Louis A. Landa, Swift's Economic Views and Mercantilism, English Literary History 10/4 (December 1943) 310–335.
12. R. Wyse Jackson, Swift and his circle. (Dublin 1945).
13. Herbert Davis, The Satire of Jonathan Swift (New York 1947).
14. Martin Price, Swift's rhetorical art. (New York 1953).
15. Robert C. Elliott, Swift and Dr Eachard. Proceedings of the Modern Language Association 69/5 (December 1954) 1250–1257.
16. John Middleton Murry, Jonathan Swift: A Critical Biography. (London 1954).
17. John Middleton Murry, Swift. (London: Published for the British Council and the National Book League 1955).
18. Kathleen Williams, Swift and the age of compromise. (London 1959).
19. John M. Bullitt, Jonathan Swift and the anatomy of satire: a study of satiric technique. (Harvard 1961).
20. Harold Williams (ed.), The Correspondence of Jonathan Swift. (Oxford 1963–65).
21. Herbert J. Davis (ed.), Jonathan Swift: essays on his satire and other studies. (New York 1964).
22. Herbert J. Davis (ed.), Gulliver's Travels. [based on the Faulkner edition, Dublin 1735] (Oxford 1965).
23. Herbert J. Davis (ed.), Swift: poetical works. (New York 1967).
24. R. B. McDowell, 'Swift as a political thinker'. In: Roger Joseph McHugh and Philip Edwards, Jonathan Swift: 1667–1967, a Dublin tercentenary tribute (Dublin 1967). 176–186.
25. Brian Vickers (ed.), The world of Jonathan Swift: essays for the tercentenary. (Oxford 1968).
26. Kathleen Williams, Jonathan Swift. (London 1968).
27. Morris Golden, The self observed: Swift, Johnson, Wordsworth. (Baltimore 1972.)
28. Jane M. Snyder, The meaning of 'Musaeo contingens cuncta lepore', Lucretius 1.934, Classical World 66 (1973) 330–334.
29. Claude Julien Rawson, Gulliver and the gentle reader: studies in Swift and our time. (London and Boston 1973).
30. A. L. Rowse, Jonathan Swift, major prophet. (London 1975).
31. Alexander Norman Jeffares, Jonathan Swift. (London 1976).
32. Clive T. Probyn, Jonathan Swift: the contemporary background. (Manchester 1978).
33. Clive T. Probyn (ed.), The art of Jonathan Swift. (London 1978).
34. Irvin Ehrenpreis, Swift: The man, his works, and the age (three volumes). (London 1962–83).
35. David M. Vieth (ed.), Essential articles for the study of Jonathan Swift's poetry. (Hamden 1984).
36. James A. Downie, Jonathan Swift, political writer. (London 1985).
37. Frederik N. Smith (ed.), The genres of Gulliver's travels. (London 1990).
38. James Kelly, 'Jonathan Swift and the Irish Economy in the 1720s', Eighteenth-century Ireland: Iris an dá chultúr, 6 (1991) 7–36.
39. Joseph McMinn (ed.), Swift's Irish pamphlets. (Gerrards Cross 1991).
40. Robert Mahony, Jonathan Swift: the Irish identity. (Yale 1995).
41. Christopher Fox, Walking Naboth's vineyards: new studies of Swift (University of Notre Dame Ward-Philips lectures in English language and literature, Vol. 13). (Notre Dame/Indiana 1995).
42. Claude Rawson (ed.), Jonathan Swift: a collection of critical essays. (Englewood Cliffs, New Jeresey, 1995).
43. Michael Stanley, Famous Dubliners: W. B. Yeats, James Joyce, Jonathan Swift, Wolfe Tone, Oscar Wilde, Edward Carson. (Dublin 1996).
44. Daniel Carey, 'Swift among the freethinkers'. Eighteenth-century Ireland: Iris an dá chultúr, 12 (1997) 89–99.
45. Victoria Glendinning, Jonathan Swift. (London 1998).
46. Aileen Douglas; Patrick Kelly; Ian Campbell Ross, (eds.). Locating Swift: essays from Dublin on the 250th anniversary of the death of Jonathan Swift, 1667–1745. (Dublin 1998).
47. Bruce Arnold, Swift: an illustrated life. (Dublin 1999).
48. Nigel Wood (ed.), Jonathan Swift. (London and New York 1999).
49. Christopher J. Fauske, Jonathan Swift and the Church of Ireland, 1710–24 (Portland/Oregon 2001).
50. David George Boyce; Robert Eccleshall; Vincent Geoghegan (eds.), Political discourse in seventeenth- and eighteenth-century Ireland. (Basingstoke and New York 2001).
51. Ann Cline Kelly, Jonathan Swift and popular culture: myth, media and the man. (Basingstoke 2002).
52. Dirk F. Passmann and Heinz J. Vienken, The library and reading of Jonathan Swift: a bio-bibliographical handbook. 4 vols. (Frankfurt 2003).
53. Mark McDayter, 'The haunting of St James's Library: librarians, literature, and The Battle of the Books'. Huntington Library Quarterly, 66:1–2 (2003) 1–26.
54. Frank T. Boyle, 'Jonathan Swift' [A companion to satire]. In: Ruben Quintero (ed.), A companion to satire (Oxford 2007) 196–211.
55. Harry Whitaker, C. U. M. Smith and Stanley Finger (eds.), Explorations of the Brain, Mind and Medicine in the Writings of Jonathan Swift. Springer (US) 2007.
56. Basil Williams, Stanhope. A Study in Eighteenth-Century War and Diplomacy. (Oxford 1932).
**The edition used in the digital edition**2. **D. Laing Purves**, The conduct of the Allies and of the late Ministry, in beginning and carrying

on the war in The works of Jonathan Swift D. D., Dean of St. Patrick's, Dublin. Carefully selected: with a biography of the author, by D. Laing Purves; and original and authentic notes, Ed. D. Laing Purves. , Edinburgh, William P. Nimmo & Co. (1880) page 420–442

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The text covers pages 420–442.


#### Editorial Declaration


##### Correction


The text has been proof-read once.


##### Normalization


The electronic text represents the edited text, with modernised spelling and punctuation. In three cases variants from Temple Scott's edtion have been integrated using corr sic or sup tags. The editor's notes are tagged note type="auth" n="".


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (hard or soft) crosses a line break, the break is marked after the completion of the hyphenated word (and punctuation mark).


##### Segmentation


div0=the tract; div1=the section; paragraphs are marked; page-breaks are marked pb n="".


##### Interpretation


Names of persons and places are tagged. Terms and phrases from languages other than English are tagged. Encoding is subject to revision.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: By Jonathan Swift

 (1711) #### Use of language


##### Language: [EN] The whole text is in English.


##### Language: [FR] Some words and phrases are in French.


##### Language: [LA] Some words, phrases and a poem are in Latin.


### Revision History


* (2010-08-04) Beatrix Färber (ed.)

* Conversion script run; header updated, file parsed. New SGML and HTML files created.
* (2008-09-24) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2008-07-25) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, content of 'langUsage' revised; minor modifications made to header.
* (2008-03-03) Beatrix Färber (ed.)

* File parsed. SGML and HTML version created.
* (2008-02-29) Beatrix Färber (ed.)

* Proofing completed; footnotes integrated. Bibliography inserted.
* (2008-02-01) Beatrix Färber (ed.)

* Proofing (1) begun. Structural and content markup applied.
* (2008-01-31) Beatrix Färber (ed.)

* Header constructed.
* (2007-01-30) Beatrix Färber (text capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E700001-019


### The conduct of the Allies: Author: Jonathan Swift




---

p.420


[1](javascript:footNote('E700001-019/note001.html'))The Conduct of the Allies; and of the Late Ministry, in bringing and carrying on the War
----------------------------------------------------------------------------------------



> 1. Partem tibi Gallia nostri
>   
> Eripuit: Partem duris Hispania bellis:
>   
> Pars jacet Hesperia, totoque exercitus orbe
>   
> Te vincente perit.
>   
> Odimus accipitrem quia semper vivit in armis.
>   
> Victrix Provincia plorat.
> 




Preface
-------


I cannot sufficiently admire the industry of a sort of men, wholly out of favour with the prince and people, and openly professing a separate interest from the bulk of the landed men, who yet are able to raise at this juncture so great a clamour against a peace, without offering one single reason, but what we find in their ballads. I lay it down for a maxim that no reasonable man, whether Whig or Tory (since it is necessary to use those foolish terms), can be of the opinion for continuing the war upon the footing it now is, unless he be a gainer by it; or hopes it may occasion some new turn of affairs at home, to the advantage of his party; or, lastly, unless he be very ignorant of the kingdom's condition, and by what means we have been reduced to it. Upon the two first cases, where interest is concerned, I have nothing to say; but as to the last, I think it highly necessary that the public should be freely and impartially told what circumstances they are in, after what manner they have been treated by those whom they trusted so many years with the disposal of their blood and treasure, and what the consequences of this management are likely to be upon themselves and their posterity.


Those who, either by writing or discourse, have undertaken to defend the proceedings of the late ministry, in the management of the war, and of the treaty at **Gertruydenberg**, have spent time in celebrating the conduct and valour of our leaders and their troops, in summing up





---

p.421




the victories they have gained and the towns they have taken. Then they tell us what high articles were insisted on by our ministers and those of the confederates, and what pains both were at in persuading **France** to accept them. But nothing of this can give the least satisfaction to the just complaints of the kingdom. As to the war, our grievances are, that a greater load has been laid on us than was either just or necessary, or than we have been able to bear; that the grossest impositions have been submitted to, for the advancement of private wealth and power, or in order to forward the more dangerous designs of a faction, to both which a peace would have put an end; and that the part of the war which was chiefly our province, which would have been most beneficial to us and destructive to the enemy, was wholly neglected. As to a peace, we complain of being deluded by a mock treaty; in which those who negotiated took care to make such demands as they knew were impossible to be complied with, and therefore might securely press every article as if they were in earnest.


These are some of the points I design to treat of in the following discourse; with several others, which I thought it necessary at this time for the kingdom to be informed of. I think I am not mistaken in those facts I mention; at least not in any circumstance so material as to weaken the consequences I draw from them.


After ten years' war with perpetual success, to tell us it is yet impossible to have a good peace, is very surprising, and seems so different from what has ever happened in the world before, that a man of any party may be allowed suspecting that we have either been ill used, or have not made the most of our victories, and might therefore desire to know where the difficulty lay. Then it is natural to inquire into our present condition; how long we shall be able to go on at this rate; what the consesquences may be upon the present and future ages; and whether a peace, without that impracticable point which some people do so much insist on, be really ruinous in it self, or equally so with the continuance of the war.


The Conduct &c.
---------------


The motives that may engage a wise prince or state in a war I take to be one or more of these: either to check the overgrown power of some ambitious neighbour; to recover what has been unjustly taken from them; to revenge some injury they have received, which all political casuists allow; to assist some ally in a just quarrel; or, lastly, to defend themselves when they are invaded. In all these cases, the writers upon politics admit a war to be justly undertaken. The last is what has been usually called pro aris et focis; where no expense or endeavour can be too great, because all we have is at stake, and consequently our utmost force to be exerted; and the dispute is soon determined either in safety or utter destruction. But in the other four I believe it will be found that no monarch or commonwealth did ever engage beyond a certain degree: never proceeding so far as to exhaust the strength and substance of their country by anticipations and loans, which in a few years must put them in a worse condition than any they could reasonably apprehend from those evils for the preventing of which they first entered into the war; because this would be to run into real infallible ruin, only in hopes to remove what might perhaps but appear so by a probable speculation.


And as a war should be undertaken upon a just and prudent motive, so it is still more obvious that a prince ought maturely to consider the condition he is in when he enters on it; whether his coffers be full, his revenues clear of debts, his people numerous and rich by a long peace and free trade, not overpressed with many burdensome taxes; no violent faction ready to dispute his just prerogative, and thereby weaken his authority at home and lessen his reputation abroad. For if the contrary of all this happen to be his case, he will hardly be persuaded to disturb the world's quiet and his own, while there is any other way left of preserving the latter with honour and safety.


Supposing the war to have commenced upon a just motive, next thing to be considered is, when a prince ought in prudence to receive the overtures of a peace: which I take to be, either when the enemy is ready to yield the point originally contended for; or when that point is found impossible to be ever obtained; or when contending any longer, although with probability of gaining that point at last, would put such a prince and his people in a worse

condition than the present loss of it. All which considerations are of much greater force where a war is managed by an alliance of many confederates, which, in a variety of interests among the several parties, is liable to so many unforeseen accidents.


In a confederate war it ought to be considered which party has the deepest share in the quarrel: for although each may have their particular reasons, yet one or two among them will probably be more concerned than the rest, and therefore ought to bear the greatest part of the burden, in proportion to their strength. For example: two princes may be competitors for a kingdom; and it will be your interest to take the part of him who will probably allow you good conditions of trade, rather than of the other who may possibly not. However, that prince whose cause you espouse,

although never so vigorously, is the principal in that war; and you, properly speaking, are but a second. Or a commonwealth may lie in danger to be overrun by a powerful neighbour, which in time may produce very bad consequences upon your trade and liberty: it is therefore necessary, as well as prudent, to lend them assistances, and





---

p.422




help them to win a strong secure frontier; but as they must, in course, be the first and greatest sufferers, so in justice they ought to bear the greatest weight. If a house be on fire, it behoves all in the neighbourhood to run with buckets to quench it; but the owner is sure to be undone first; and it is not impossible that those at next door may escape by a shower from heaven, or the stillness of the weather, or some other favourable accident.


But if any ally, who is not so immediately concerned in the good or ill fortune of the war, be so generous as to contribute more than the principal party, and even more in proportion to his abilities, he ought at least to have his share in what is conquered from the enemy; or, if his romantic disposition transport him so far as to expect little or nothing from this, he might however hope that the principals would make it up in dignity and respect; and he would surely think it monstrous to find them intermeddling in his domestic affairs, prescribing what servants he should keep or dismiss, pressing him perpetually with the most unreasonable demands, and at every turn threatening to break the alliance if he will not comply.


From these reflections upon war in general I descend to consider those wars wherein **England** has been engaged since the Conquest. In the civil wars of the barons, as well as those between the houses of York and Lancaster, great destruction was made of the nobility and gentry; new families raised, and old ones extinguished; but the money spent on both sides was employed and circulated at home; no public debts [were] contracted, and a very few years of peace quickly set all right again.


The like may be affirmed even of that unnatural rebellion against king Charles I. The usurpers maintained great armies in constant pay, had almost continual war with **Spain** or **Holland**; but managing it by their fleets, they increased very much the riches of the kingdom, instead of exhausting them.


Our foreign wars were generally against **Scotland** or **France**; the first, being in this island, carried no money out of the kingdom, and were seldom of long continuance. During our first wars with **France** we possessed great dominions in that country, where we preserved some footing till the reign of Queen Mary; and although some of our later princes made very chargeable expeditions thither, a subsidy and two or three fifteenths cleared all the debt. Besides, our victories were then of some use as well as glory; for we were so prudent as to fight, and so happy as to conquer, only for ourselves.


The Dutch wars in the reign of king Charles II., although begun and carried on under a very corrupt dministration, and much to the dishonour of the crown, did indeed keep the king needy and poor by discontinuing or discontenting his parliament, when he most needed their assistance; but neither left any debt upon the nation, nor carried any money out of it.


At the Revolution a general war broke out in Europe, wherein many princes joined in alliance against **France** to check the ambitious designs of that monarch; and here the emperor, the Dutch, and **England** were principals. About this time the custom first began among us of borrowing millions upon funds of interest. It was pretended that the war could not possibly last above one or two campaigns; and that the debts contracted might be easily paid in a few years by a gentle tax, without burdening the subject. But the true reason for embracing this expedient was the security of a new prince, not firmly settled on the throne. People were tempted to lend by great premiums and large interest; and it concerned them nearly to preserve that government which they trusted with their money. The person[2](javascript:footNote('E700001-019/note002.html')) said to have been author of so detestable a project, lived to see some of its fatal consequences, whereof his grandchildren will not see an end. And this pernicious counsel closed very well with the posture of affairs at that time: for a set of upstarts, who had little or no part in the Revolution, but valued themselves by their noise and pretended zeal when the work was over, were got into credit at court, by the merit of becoming undertakers and projectors of loans and funds; these, finding that the gentlemen of estates were not willing to come into their measures, fell upon those new schemes of raising money, in order to create a moneyed interest, that might in time vie with the landed, and of which they hoped to be at the head.


The ground of the first war for ten years after the Revolution, as to the part we had in it, was to make **France** acknowledge the late king, and to recover Hudson's Bay. But during that whole war the sea was almost entirely neglected, and the greatest part of six millions annually employed to enlarge the frontier of the Dutch; For the king was a general, but not an admiral; and although king of **England**, was a native of **Holland**.


After ten years' fighting to little purpose, after the loss of above a hundred thousand men, and a debt remaining of twenty millions, we at length hearkened to the terms of a peace, which was concluded with great advantages to the empire and **Holland**, but none at all to us, and clogged soon after with the famous treaty of partition, by which **Naples**, **Sicily**, and **Lorraine** were to be added to the French dominions; or, if that crown should think fit to set aside the treaty, upon the Spaniards refusing to accept it, as they declared they would to the several parties at the very time of the transacting it, then the French would have pretensions to the whole monarchy. And so it proved in the event; for the late king of **Spain**, reckoning it an indignity to have his territories cantoned out into parcels by other princes during his own life, and without his consent, rather chose to bequeath the monarchy entire to a younger son of **France**; and this prince was acknowledged





---

p.423




for king of **Spain** both by us and **Holland**.


It must be granted that the counsels of entering into this war were violently opposed by the Church party, who first advised the late king to acknowledge the duke of Anjou; and particularly it is affirmed that a certain great person,[3](javascript:footNote('E700001-019/note003.html')) who was then in the Church interest, told the king in November 1701, That since his majesty was determined to engage in a war so contrary to his private opinion, he could serve him no longer, and accordingly gave up his employment; although he happened afterwards to change his mind, when he was to be at the head of the treasury and have the sole management of affairs at home; while those abroad were to be in the hands of one[4](javascript:footNote('E700001-019/note004.html')) whose advantage, by all sorts of ties, he was engaged to promote.


The declarations of war against **France** and **Spain**, made by us and **Holland**, are dated within a few days of each other. In that published by the States they say very truly, that they are nearest and most exposed to the fire; that they are blocked up on all sides, and actually attacked by the kings of **France** and **Spain**; that their declaration is the effect of an urgent and pressing necessity; with other expressions to the same purpose. They desire the assistance of all kings and princes, &c. The grounds of their quarrel with **France** are such as only affect themselves, or at least more immediately than any other prince or state; such as the French refusing to grant the tariff promised by the treaty of Ryswick; the loading of the Dutch inhabitants settled in **France** with excessive duties, contrary to the said treaty; the violation of the partition treaty by the French accepting the king of **Spain**'s will, and threatening the States if they would not comply; the seizing of the Spanish Netherlands by the French troops, and turning out the Dutch, who, by permission of the late king of **Spain**, were in garrison there; by which means that republic was deprived of her barrier, contrary to the treaty of partition, where it was particularly stipulated that the Spanish Netherlands should be left to the archduke. They alleged that the French king governed **Flanders** as his own, although under the name of his grandson, and sent great numbers of troops thither to fright them; That he had seized the city and citadel of Liège; had possessed himself of several places in the archbishopric of **Cologne**, and maintained troops in the country of Wolfenbuttel, in order to block up the Dutch on all sides; and caused his resident to give in a memorial, wherein he threatened the States to act against them if they refused complying with the contents of that memorial.


The queen's declaration of war is grounded upon the grand alliance, as this was upon the unjust usurpations and encroachments of the French king; whereof the instances produced are, his keeping in possession a great part of the Spanish dominions, seizing **Milan** and **the Spanish Low Countries**, making himself master of **Cadiz**, &c; and instead of giving satisfaction in these points, his putting an indignity and affront on her majesty and kingdoms, by declaring the pretended prince of Wales king of **England**, &c. Which last was the only personal quarrel we had in the war; and even this was positively denied by **France**, that king being willing to acknowledge her majesty.


I think it plainly appears, by both declarations, that **England** ought no more to have been a principal in this war than **Prussia** or any other power who came afterward into that alliance. **Holland** was first in danger, the French troops being at that time just at the gates of Nimeguen. But the complaints made in our declaration do all, except the last, as much, or more, concern almost every prince in Europe.


For among the several parties who came first or last into this confederacy, there were few but who, in proportion, had more to get or to lose, to hope or to fear, from the good or ill success of this war, than we. The Dutch took up arms to defend themselves from immediate ruin; and by a successful war they proposed to have a larger extent of country and a better frontier against **France**. The emperor hoped to recover the monarchy of **Spain**, or some part of it, for his younger son, chiefly at the expense of us and **Holland**. The king of **Portugal** had received intelligence that Philip designed to renew the old pretensions of **Spain** upon that kingdom, which is surrounded by the other on all sides, except toward the sea, and could therefore only be defended by maritime powers. This, with the advantageous terms offered by king Charles, as well as by us, prevailed with that prince to enter into the alliance. The **duke of **Savoy****'s temptations and fears were yet greater: the main charge of the war on that side was to be supplied by **England**, and the profit to redound to him. In case **Milan** should be conquered, it was stipulated that his highness should have the duchy of **Montserrat**, belonging to the duke of **Mantua**, the provinces of **Alexandria** and **Valencia**, and **Lomellino**, with other lands between the **Po** and the **Tanaro**, together with the **Vigevenasco**, or in lieu of it an equivalent out of the province of **Novara**, adjoining to his own state; beside whatever else could be taken from **France** on that side by the confederate forces. Then he was in terrible apprehension of being surrounded by **France**, who had so many troops in the Milanese, and might have easily swallowed up his whole duchy.


The rest of the allies came in purely for subsidies, whereof they sunk considerable sums into their own coffers, and refused to send their contingent to the emperor, alleging their troops were already hired by **England** and **Holland**.


Some time after, the duke of Anjou's succeeding to the monarchy of **Spain** in breach of the partition treaty, the question here in **England** was, whether the peace should be continued, or a new war begun? Those who were for the former





---

p.424




alleged the debts and difficulties we laboured under; that both we and the Dutch had already acknowledged Philip for king of **Spain**; that the inclinations of the Spaniards to the house of Austria, and their aversion for that of Bourbon, were not so surely to be reckoned upon as some would pretend; that we thought it a piece of insolence as well as injustice in the French to offer putting a king upon us, and the Spaniards would conceive we had as little reason to force one upon them; that it was true the nature and genius of those two people differed very much, and so would probably continue to do, as well under a king of French blood as one of Austrian; but that if we would engage in a war for dethroning the duke of Anjou, we should certainly effect what, by the progress and operations of it, we endeavoured to prevent, I mean an union of interest and affections between the two nations; for the Spaniards must, of necessity, call in French troops to their assistance; this would introduce French counsellors into king Philip's court, and this by degrees would habituate and reconcile the two nations; that to assist king Charles by English or Dutch forces would render him odious to his new subjects, who have nothing in so great abomination as those whom they hold for heretics; that the French would by this means become masters of the treasures in the Spanish West Indies; that in the last war, when **Spain**, **Cologne**, and **Bavaria** were in our alliance, and by a modest computation brought sixty thousand men into the field against the common enemy; when **Flanders**, the seat of war, was on our side, and his majesty, a prince of great valour and conduct, at the head of the whole confederate army; yet we had no reason to boast of our success: how then should we be able to oppose **France** with those powers against us, which would carry sixty thousand men from us to the enemy, and so make us upon the balance weaker by one hundred and twenty thousand men, at the beginning of this war, than of that in 1688?


On the other side, those whose opinion, or some private motives, inclined them to give their advice for entering into a new war, alleged how dangerous it would be for **England** that Philip should be king of **Spain**; that we could have no security for our trade while that kingdom was subject to a prince of the Bourbon family, nor any hopes of preserving the balance of Europe, because the grandfather would in effect be king, while his grandson had but the title, and thereby have a better opportunity than ever of pursuing his design for universal monarchy. These and the like arguments prevailed; and so, *without offering at any other remedy,* without taking time to consider the consequences, or to reflect on our own condition, we hastily engaged in a war, which has cost us sixty millions, and, after repeated as well as unexpected success in arms, has put us and our posterity in a worse condition, not only than any of our allies, but even our conquered enemies themselves.


The part we have acted in the conduct of this whole war, with reference to our allies abroad and to a prevailing faction at home, is what I shall now particularly examine; where I presume it will appear, by plain matters of fact, that 

no nation was ever so long or so scandalously abused, by the folly, the temerity, the corruption, the ambition of its 

domestic enemies; or treated with so much insolence, injustice and ingratitude, by its foreign friends.


This will be manifest by proving the three following points:—


First, that against all manner of prudence or common reason, we engaged in this war as principals, when we ought to have acted only as auxiliaries.


Secondly, that we spent all our vigour in pursuing that part of the war which could least answer the end we proposed by beginning it; and made no efforts at all where we could have most weakened the common enemy, and at the same time enriched ourselves.


Lastly, that we suffered each of our allies to break every article in those treaties and agreements by which they were bound, and to lay the burden upon us.


Upon the first of these points, that we ought to have entered into this war only as auxiliaries, let any man reflect upon our condition at that time: just come out of the most tedious, expensive, and unsuccessful war that ever **England** had been engaged in; sinking under heavy debts of a nature and degree never heard of by us or our ancestors; the bulk of the gentry and people heartily tired of the war, and glad of a peace, although it brought no other advantage but itself; no sudden prospect of lessening our taxes, which were grown as necessary to pay our debts as to raise armies; a sort of artificial wealth of funds and stocks in the hands of those who for ten years before had been plundering the public; many corruptions in every branch of our government that needed reformation. Under these difficulties, from which twenty years' peace and the wisest management could hardly recover us, we declare war against **France**, fortified by the accession and alliance of those powers I mentioned before, and which, in the former war, had been parties in our confederacy. It is very obvious what a change must be made in the balance by such weights taken out of our scale and put into theirs; since it was manifest, by ten years' experience, that **France**, without those additions of strength, was able to maintain itself against us. So that human probability ran with mighty odds on the other side; and in that case nothing under the most extreme necessity should force any state to engage in a war. We had already acknowledged Philip for king of **Spain**; neither does the queen's declaration of war take notice of the duke of Anjou's succession to that monarchy as a subject of quarrel, but the French king's governing it as if it were his own; his seizing **Cadiz**, **Milan**, and **the Spanish Low Countries**, with the indignity of proclaiming the Pretender. In all which we 





---

p.425




charge that prince with nothing directly relating to us, excepting the last; and this, although indeed a great affront, might have easily been redressed without a war; for the French court declared they did not acknowledge the Pretender, but only gave him the title of king, which was allowed to **Augustus** by his enemy of **Sweden**, who had driven him out of **Poland**, and forced him to acknowledge Stanislaus.


It is true indeed, the danger of the Dutch by so ill a neighbourhood in **Flanders** might affect us very much in the consequences of it; and the loss of **Spain** to the house of Austria, if it should be governed by French influence and French politics, might in time be very pernicious to our trade. It would therefore have been prudent, as well as generous and charitable, to help our neighbour; and so we might have done without injuring ourselves; for by an old treaty with **Holland** we were bound to assist that republic with ten thousand men whenever they were attacked by the French, whose troops, upon the king of **Spain**'s death, taking possession of **Flanders** in right of Philip, and securing the Dutch garrisons till they would acknowledge him, the States-General, by memorials from their envoy here, demanded only the ten thousand men we were obliged to give them by virtue of that treaty. And I make no doubt but the Dutch would have exerted themselves so vigorously as to be able with that assistance alone to defend their frontiers; or if they had been forced to a peace, the Spaniards, who abhor dismembering their monarchy, would never have suffered the French to possess themselves of **Flanders**. At that time they had none of those endearments to each other which this war has created; and whatever hatred and jealousy were natural between the two nations would then have appeared. So that there was no sort of necessity for us to proceed farther, although we had been in a better condition. But our politicians at that time had other views; and a new war must be undertaken upon the advice of those who, with their partisans and adherents, were to be the sole gainers by it. A grand alliance was therefore made between the emperor, **England**, and the States-General; by which, if the injuries complained of from **France** were not remedied in two months, the parties concerned were obliged mutually to assist each other with their whole strength.


Thus we became principal in a war in conjunction with two allies, whose share in the quarrel was beyond all proportion greater than ours. However, I can see no reason, from the words of the grand alliance, by which we were obliged to make those prodigious expenses we have since been at. By what I have always heard and read, I take the whole strength of the nation, as understood in that treaty, to be the utmost that a prince can raise annually from his subjects. If he be forced to mortgage and borrow, whether at home or abroad, it is not properly speaking his own strength, or that of the nation, but the entire substance of particular persons, which, not being able to raise out of the annual income of his kingdom, he takes upon security, and can only pay the interest. And by this method one part of the nation is pawned to the other, with hardly a possibility left of being ever redeemed.


Surely it would have been enough for us to have suspended the payment of our debts contracted in the former war, and to have continued our land and malt tax, with those others which have since been mortgaged: these, with some additions, would have made up such a sum, as, with prudent management, might, I suppose, have maintained a hundred thousand men by sea and land; a reasonable quota, in all conscience for that ally who apprehended least danger and expected least advantage. Nor can we imagine that either of the confederates, when the war began, would have been so unreasonable as to refuse joining with us upon such a foot, and expect that we should every year go between three and four millions in debt (which has been our case), because the French could hardly have contrived any offers of a peace so ruinous to us as such a war. Posterity will be at a loss to conceive what kind of spirit could possess their ancestors, who, after ten years' suffering by the unexampled politics of a nation, maintaining a war by annually pawning itself, and during a short peace, while they were looking back with horror on the heavy load of debts they had contracted, universally condemning those pernicious counsels which had occasioned them, racking their invention for some remedies or expedients to mend their shattered condition; I say, that these very people, without giving themselves time to breathe, should again enter into a more dangerous, chargeable, and extensive war, for the same or perhaps a greater period of time, and without any apparent necessity. It is obvious, in a private fortune, that whoever annually runs out, and continues the same expenses, must every year mortgage a greater quantity of land than he did before; and as the debt doubles and trebles upon him, so does his inability to pay it. By the same proportion we have suffered twice as much by this last ten years' war, as we did by the former; and if it were possible to continue it five years longer at the same rate, it would be as great a burden as the whole twenty. This computation being so easy and trivial as it is almost a shame to mention it, posterity will think that those who first advised the war wanted either the sense or the honesty to consider it.


And as we have wasted our strength and vital substance in this profuse manner, so we have shamefully misapplied it to ends at least very different from those for which we undertook the war, and often to effect others which after a peace we may severely repent. This is the second article I propose to examine.


We have now for ten years together turned the whole force and expense of the war where the enemy was best able to hold us at a bay; where we could propose no manner of advantage





---

p.426




to ourselves; where it was highly impolitic to enlarge our conquests; utterly neglecting that part which would have saved and gained us many millions; which the perpetual maxims of our government teach us to pursue; which would have soonest weakened the enemy, and must either have promoted a speedy peace, or enabled us to continue the war.


Those who are fond of continuing the war cry up our constant success at a most prodigious rate, and reckon it infinitely greater than in all human probability we had reason to hope. Ten glorious campaigns are passed; and now at last, like the sick man, we are just expiring with all sorts of good symptoms. Did the advisers of this war suppose it would continue ten years, without expecting the successes we have had; and yet at the same time determine that **France** must be reduced, and **Spain** subdued, by employing our whole strength upon **Flanders**? Did they believe the last war left us in a condition to furnish such vast supplies for so long a period, without involving us and our posterity in unextricable debts? If after such miraculous doings we are not yet in a condition of bringing **France** to our terms, nor can tell when we shall be so, although we should proceed without any reverse of fortune; what could we look for in the ordinary course of things, but a **Flanders** war of at least twenty years longer? Do they indeed think a town taken for the Dutch is a sufficient recompense to us for six millions of money; which is of so little consequence to determine the war, that the French may yet hold out a dozen years more, and afford a town every campaign at the same price?


I say not this by any means to detract from the army or its leaders. Getting into the enemy's lines, passing rivers, and taking towns, may be actions attended with many glorious circumstances; but when all this brings no real solid advantage to us; when it has no other end than to enlarge the territories of the Dutch, and to increase the fame and wealth of our general; I conclude, however it comes about, that things are not as they should be; and that surely our forces and money might be better employed, both towards reducing our enemy, and working out some benefit to ourselves. But he case is still much harder; we are destroying many thousand lives, exhausting our substance, not for our own interest, which would be but common prudence; not for a thing indifferent, which would be sufficient folly; but perhaps to our own destruction, which is perfect madness. We may live to feel the effects of our own valour more sensibly than all the consequences we imagine from the dominions of **Spain** in the duke of Anjou. We have conquered a noble territory for the States, that will maintain sufficient troops to defend itself, and feed many hundred thousand inhabitants; where all encouragement will be given to introduce and improve manufactures, which was the only advantage they wanted; and which, added to their skill, industry and parsimony, will enable them to undersell us in every market of the world.


Our supply of forty thousand men, according to the first stipulation, added to the quotas of the emperor and **Holland**, which they were obliged to furnish, would have made an army of near two hundred thousand, exclusive of garrisons: enough to withstand all the power that **France** could bring against it; and we might have employed the rest much better, both for the common cause and our own advantage.


The war in **Spain** must be imputed to the credulity of our ministers, who suffered themselves to be persuaded by the imperial court that the Spaniards were so violently affected to the house of Austria, as, upon the first appearance there with a few troops under the archduke, the whole kingdom would immediately revolt. This we tried; and found the emperor to have deceived either us or himself. Yet there we drove on the war at a prodigious disadvantage, with great expense; and by a most corrupt management, the only general [5](javascript:footNote('E700001-019/note005.html'))who, by a course of conduct and fortune almost miraculous, had nearly put us into possession of the kingdom, was left wholly unsupported, exposed to the envy of his rivals, disappointed by the caprices of a young unexperienced prince, under the guidance of a rapacious German ministry, and at last called home in discontent. By which our armies, both in **Spain** and **Portugal**, were made a sacrifice to avarice, ill conduct, or treachery.


In common prudence we should either have pushed that war with the utmost vigour in so fortunate a juncture, especially since the gaining of that kingdom was the great point for which we pretended to continue the war; or at least, when we had found or made that design impracticable, we should not have gone on in so expensive a management of it, but have kept our troops on the defensive in **Catalonia**, and pursued some other way more effectual for distressing the common enemy and advantaging ourselves.


And what a noble field of honour and profit had we before us wherein to employ the best of our strength, which, against the maxims of British policy, we suffered to lie wholly neglected! I have sometimes wondered how it came to pass that the style of maritime powers, by which our allies in a sort of contemptuous manner usually couple us with the Dutch, did never put us in mind of the sea; and while some politicians were showing us the way to **Spain** by **Flanders**, others by **Savoy** or **Naples**, that the **West Indies** should never come into their heads. With half the charge we have been at we might have maintained our original quota of forty thousand men in **Flanders**, and at the same time by our fleets and naval forces have so distressed the Spaniards in the north and south seas of America as to prevent any returns of money from thence except in our own bottoms. This is what best became us to do as a maritime





---

p.427




power; this with any common degree of success would soon have compelled **France** to the necessities of a peace, and **Spain** to acknowledge the archduke. But while we for ten years have been squandering away our money upon the continent, **France** has been wisely engrossing all the trade of Peru, going directly with their ships to Lima and other ports, and there receiving ingots of gold and silver for French goods of little value; which, beside the mighty advantage to 

their nation at present, may divert the channel of that trade for the future, so beneficial to us, who used to receive annually such vast sums at **Cadiz** for our goods sent thence to the Spanish West Indies. All this we tamely saw and suffered, without the least attempt to hinder it; except what was performed by some private men at Bristol, who, inflamed by a true spirit of courage and industry, did about three years ago, with a few vessels fitted out at their own charge, make a most successful voyage into those parts; took one of the Acapulco ships, very narrowly missed of the other, and are lately returned laden with unenvied wealth, to show us what might have been done with the like management by a public undertaking. At least, we might easily have prevented those great returns of money to **France** and **Spain**, although we could not have taken it ourselves. And if it be true, as the advocates for war would have it, that the French are now so impoverished; in what condition must they have been if that issue of wealth had been stopped?


But great events often turn upon very small circumstances. It was the kingdom's misfortune that the sea was not the duke of Marlborough's element; otherwise the whole force of the war would infallibly have been bestowed there, infinitely to the advantage of his country, which would then have gone hand in hand with his own. But it is very truly objected, that if we alone had made such an attempt as this, **Holland** would have been jealous; or if we had done it in conjunction with **Holland**, the house of Austria would have been discontented. This has been the style of late years; which whoever introduced among us, they have taught our allies to speak after them. Otherwise it could hardly enter into any imagination, that while we are confederates in a war with those who are to have the whole profit, and who leave a double share of the burden upon us, we dare not think of any design (although against the common enemy) where there is the least prospect of doing good to our own country, for fear of giving umbrage and offence to our allies, while we are ruining ourselves to conquer provinces and kingdoms for them. I therefore confess with shame that this objection is true, for it is very well known that, while the design of Mr. Hill's expedition[6](javascript:footNote('E700001-019/note006.html')) remained a secret, it was suspected in **Holland** and **Germany** to be intended against Peru; whereupon the Dutch made everywhere their public complaints; and the ministers at Vienna talked of it as an insolence in the queen to attempt such an undertaking: the failure of which (partly by the accidents of a storm, and partly by the stubbornness or treachery of some in that colony for whose relief and at whose entreaty it was in some measure designed) is no objection at all to an enterprise so well concerted and with such fair probability of success.


It was something singular that the States should express their uneasiness when they thought we intended to make some attempt in the Spanish West Indies; because it is agreed between us, whatever is conquered there by us or them shall belong to the conqueror; which is the only article that I can call to mind in all our treaties or stipulations with any view of interest to this kingdom; and for that very reason, I suppose, among others, [it] has been altogether neglected. Let those who think this a severe reflection examine the whole management of the present war by sea and land, with all our alliances, treaties, stipulations and conventions, and consider whether the whole does not look as if some particular care and industry had been used to prevent any benefit or advantage that might possibly accrue to Britain?


This kind of treatment from our principal allies has taught the same dialect to all the rest; so that there is hardly a petty prince whom we half maintain by subsidies and pensions, who is not ready upon every occasion to threaten us that he will recall his troops (although they must rob or starve at home) if we refuse to comply with him in any demand however unreasonable.


Upon the third head I shall produce some instances to show how tamely we have suffered each of our allies to infringe every article in those treaties and stipulations by which they were bound, and to lay the load upon us.


But before I enter upon this, which is a large subject, I shall take leave to offer a few remarks on certain articles in three of our treaties, which may let us perceive how much those ministers valued or understood the true interest, safety, or honour of their country.


We have made two alliances with **Portugal**, an offensive and defensive: the first is to remain in force only during the present war; the second to be perpetual. In the offensive alliance the emperor, **England**, and **Holland** are parties with **Portugal**; in the defensive only we and the States.


Upon the first article of the offensive alliance it is to be observed, that although the grand alliance, as I have already said, allows **England** and **Holland** to possess for their own whatever each of them shall conquer in the Spanish West Indies, yet here we are quite cut out by consenting that the archduke shall possess the dominions of **Spain** in as full a manner as their late king Charles. And what is more remarkable,





---

p.428




we broke this very article in favour of **Portugal**, by subsequent stipulations, where we agree that king Charles shall deliver up **Estremadura**, **Vigo**, and some other places to the Portuguese, as soon as we can conquer them from the enemy. They who were guilty of so much folly and contradiction know best whether it proceeded from corruption or stupidity.


By two other articles (besides the honour of being convoys and guards in ordinary to the Portuguese ships and coasts) we are to guess the enemy's thoughts, and to take the king of **Portugal**'s word whenever he has a fancy that he shall be invaded. We are also to furnish him with a strength superior to what the enemy intends to invade any of his dominions with, let that be what it will. And until we know what the enemy's forces are, his Portuguese majesty is sole judge what strength is superior, and what will be able to prevent an invasion, and may send our fleets whenever he pleases upon his errands to some of the farthest parts of the world, or keep them attending upon his own coasts till he thinks fit to dismiss them. These fleets must likewise be subject in all things, not only to the king, but to his viceroys, admirals, and governors, in any of his foreign dominions, when he is in a humour to apprehend an invasion; which I believe is an indignity that was never offered before, except to a conquered nation.


In the defensive alliance with that crown, which is to remain perpetual, and where only **England** and **Holland** are parties with them, the same care, in almost the same words, is taken for our fleet to attend their coasts and foreign dominions, and to be under the same obedience. We and the States are likewise to furnish them with twelve thousand men at our own charge, which we are constantly to recruit, and these are to be subject to the Portuguese generals.


In the offensive alliance, we took no care of having the assistance of **Portugal** whenever we should be invaded; but in this it seems we are wiser, for that king is obliged to make war on **France** or **Spain** whenever we or **Holland** are invaded by either; but before this, we are to supply them with the same forces, both by sea and land, as if he were invaded himself. And this must needs be a very prudent and safe course for a maritime power to take upon a sudden invasion, by which, instead of making use of our fleets and armies for our own defence, we must send them abroad for the defence of **Portugal**.


By the thirteenth article we are told what this assistance is which the Portuguese are to give us, and upon what conditions. They are to furnish ten men-of-war; and when **England** or **Holland** shall be invaded by **France** and **Spain** together, or by **Spain** alone, in either of these cases those ten Portuguese men-of-war; are to serve only upon their own coasts, where, no doubt, they will be of mighty use to their allies and terror to the enemy.


How the Dutch were drawn to have a part in either of these two alliances, is not very material to inquire, since they have been so wise as never to observe them; nor I suppose ever intended it, but resolved, as they have since done, to shift the load upon us.


Let any man read these two treaties from the beginning to the end, he will imagine that the king of **Portugal** and his ministers sat down and made them by themselves, and then sent them to their allies to sign; the whole spirit and tenor of them quite through running only upon this single point, what we and **Holland** are to do for **Portugal**, without any mention of an equivalent, except those ten ships which, at the time when we have greatest need of their assistance, are obliged to attend upon their own coasts.


The **barrier treaty** between **Great Britain** and **Holland** was concluded at the Hague on the 29th of October, in the year 1709. In this treaty neither her majesty nor her kingdoms have any interest or concern farther than what is mentioned in the second and the twentieth articles; by the former, the States are to assist the queen in defending the act of succession; and by the other, not to treat of a peace till **France** has acknowledged the queen and the succession of **Hanover**, and promised to remove the Pretender out of that king's dominions.


As to the first of these, it is certainly for the safety and interest of the States-General that the Protestant succession should be preserved in **England**, because such a popish prince as we apprehend would infallibly join with **France** in the ruin of that republic. And the Dutch are as much bound to support our succession as they are tied to any part of a treaty of league[7](javascript:footNote('E700001-019/note007.html')) offensive and defensive, against a common enemy, without any separate benefit upon that consideration. Her majesty is in the full peaceable possession of her kingdoms, and of the hearts of her people, among whom hardly one in five hundred[8](javascript:footNote('E700001-019/note008.html')) is in the Pretender's interest. And whether the assistance of the Dutch, to preserve a right so well established, be an equivalent to those many unreasonable exorbitant articles in the rest of the treaty, let the world judge. What an impression of our settlement must it give abroad to see our ministers offering such conditions to the Dutch, to prevail on them to be guarantees of our acts of parliament! Neither perhaps is it right, in point of policy or good sense, that a foreign power should be called in to confirm our succession by way of guarantee, but only to acknowledge it; otherwise we put it out of the power of our own legislature to change our succession without the consent of that prince or state who is guarantee,[9](javascript:footNote('E700001-019/note009.html')) however our posterity may hereafter, by the tyranny and oppression of any succeeding princes, be reduced to the fatal necessity of breaking in upon the excellent happy settlement now in force.


As to the other article, it is a natural consequence





---

p.429




that must attend any treaty of peace we can make with **France**, being only the acknowledgment of her majesty as queen of her own dominions, and the right of succession by our own laws, which no foreign power has any pretence to dispute.


However, in order to deserve these mighty advantages from the States, the rest of the treaty is wholly taken up in directing what we are to do for them.


By the grand alliance, which was the foundation of the present war, **the Spanish Low Countries** were to be recovered and delivered to the king of **Spain**; but by this treaty that prince is to possess nothing in **Flanders** during the war; and after a peace the States are to have the military command of about twenty towns, with their dependencies, and four hundred thousand crowns a year from the king of **Spain** to maintain their garrisons. By which means they will have the command of all **Flanders**, from **Newport-on-the-Sea** to **Namur-on-the-Maese**, and be entirely masters of the **Pais de Waas**, the richest part of those provinces. Farther, they have liberty to garrison any place they shall think fit in **the Spanish Low Countries** whenever there is an appearance of war; and consequently to put garrisons into **Ostend**, or where else they please, upon a rupture with **England**.


By this treaty likewise, the Dutch will in effect be entire masters of all **the Low Countries**, may impose duties, restrictions in commerce, and prohibitions, at their pleasure; and in that fertile country may set up all sorts of manufactures, particularly the woollen, by inviting the disobliged manufacturers in **Ireland**, and the French refugees who are scattered all over **Germany**. And as this manufacture increases abroad the clothing people of **England** will be necessitated, for want of employment, to follow, and in few years, by help of the low interest of money in **Holland**, **Flanders** may recover that beneficial trade which we got from them. The landed men of **England** will then be forced to re-establish the staples of wool abroad, and the Dutch, instead of being only the carriers, will become the original possessors of those commodities with which the greatest part of the trade of the world is now carried on. And as they increase their trade, it is obvious they will enlarge their strength at sea, and that ours must lessen in proportion.


All the ports in **Flanders** are to be subject to the like duties the Dutch shall lay upon the **Schelde**, which is to be closed on the side of the States; thus all other nations are, in effect, shut out from trading with **Flanders**. Yet in the very same article it is said that the States shall be favoured in all the Spanish dominions as much as **Great Britain**, or as the people most favoured. We have conquered **Flanders** for them, and are in a worse condition, as to our trade there, than before the war began. We have been the great support of the king of **Spain**, to whom the Dutch have hardly contributed anything at all; and yet they are to be equally favoured with us in all his dominions. Of all this the queen is under the unreasonable obligation of being guarantee, and that they shall possess their barrier and their four hundred thousand crowns a year, even before a peace.


It is to be observed that this treaty was only signed by one of our plenipotentiaries,[10](javascript:footNote('E700001-019/note010.html')) and I have been told, that the other[11](javascript:footNote('E700001-019/note011.html')) was heard to say he would rather lose his right hand than set it to such a treaty. Had he spoke those words in due season, and loud enough to be heard on this side the water, considering the credit he then had at court, he might have saved much of his country's honour, and got as much to himself; therefore if the report be true I am inclined to think he only said it. I have been likewise told, that some very necessary circumstances were wanting in the entrance upon this treaty, but the ministers here rather chose to sacrifice the honour of the crown and the safety of their country than not ratify what one of their favourites had transacted.


Let me now consider in what manner our allies have observed those treaties they made with us, and the several 

stipulations and agreements pursuant to them.


By the grand alliance between the empire, **England**, and **Holland**, we were to assist the other two totis viribus by sea and land. By a convention subsequent to this treaty, the proportions which the several parties should contribute towards the war, were adjusted in the following manner: The emperor was obliged to furnish ninety thousand men against **France**, either in **Italy** or upon the **Rhine**; **Holland** to bring sixty thousand into the field in **Flanders**, exclusive of garrisons; and we forty thousand. In winter 1702, which was the next year, the duke of Marlborough proposed raising ten thousand men more by way of augmentation, and to carry on the war with greater vigour, to which the parliament agreed; and the Dutch were to raise the same number. This was upon a par, directly contrary to the former stipulation, whereby our part was to be a third less than theirs; and therefore it was granted with a condition that **Holland** should break off all trade and commerce with **France**. But this condition was never executed; the Dutch only amusing us with a specious declaration till our session of parliament was ended; and the following year it was taken off by concert between our general and the States, without any reason assigned for the satisfaction of the kingdom. The next, and some ensuing campaigns, farther additional forces were allowed by parliament for the war in **Flanders**; and in every new supply the Dutch gradually lessened their proportions, although the parliament addressed the queen that the States might be desired to observe them according to agreement, which had no other effect than to teach them to elude it by making their troops nominal corps, as they





---

p.430




did by keeping up the number of regiments, but sinking a fifth part of the men and money; so that now things are just inverted. And in all new levies we contributed a third more than the Dutch, who at first were obliged to the same proportion more than we.


Besides, the more towns we conquer for the States, the worse condition we are in toward reducing the common enemy, and consequently of putting an end to the war. For they make no scruple of employing the troops of their quota towards garrisoning every town as fast as it is taken, directly contrary to the agreement between us, by which all garrisons are particularly excluded. This is at length arrived, by several steps, to such a height, that there are at present in the field not so many forces under the duke of Marlborough's command in **Flanders** as Britain alone maintains for that service, nor have been for some years past.


The duke of Marlborough having entered the enemy's lines and taken **Bouchain**, formed the design of keeping so great a number of troops, and particularly of cavalry, in **Lille**, **Tournay**, **Douay**, and the country between, as should be able to harass all the neighbouring provinces of **France** during the winter, prevent the enemy from erecting their magazines and by consequence from subsisting their forces next spring, and render it impossible for them to assemble their army another year without going back behind the **Soam** to do it. In order to effect this project it was necessary to be at an expense extraordinary of forage for the troops, for building stables, finding fire and candle for the soldiers, with other incident charges. The queen readily agreed to furnish her share of the first article, that of the forage, which only belonged to her. But the States insisting that her majesty should likewise come into a proportion of the other articles, which in justice belonged totally to them, she agreed even to that rather than a design of this importance should fail. And yet we know it has failed, and that the Dutch refused their consent till the time was past for putting it in execution, even in the opinion of those who proposed it. Perhaps a certain article in the treaties of contribution submitted to by such of the French dominions as pay them to the States, was the principal cause of defeating this project, since one great advantage to have been gained by it, was, as before is mentioned, to have hindered the enemy from erecting their magazines; and one article in those treaties of contribution is, that the product of those countries shall pass free and unmolested. So that the question was reduced to this short issue: whether the Dutch should lose this paltry benefit, or the common cause an advantage of such mighty importance?


The sea being the element where we might most probably carry on the war with any advantage to ourselves, it was agreed that we should bear five-eighths of the charge in that service, and the Dutch the other three; and by the grand Alliance, whatever we or **Holland** should conquer in the Spanish West Indies was to accrue to the conquerors. It might therefore have been hoped that this maritime ally of ours would have made up in their fleet what they fell short in their army: but quite otherwise; they never once furnished their quota either of ships or men; or if some few of their fleet now and then appeared, it was no more than appearing, for they immediately separated to look to their merchants and protect their trade. And we may remember very well when these guarantees of our succession, after having not one ship for many months together in the Mediterranean, sent that part of their quota thither, and furnished nothing to us, at the same time that they alarmed us with the rumour of an invasion. And last year, when **sir James Wishart** was despatched into **Holland** to expostulate with the States, and to desire they would make good their agreements in so important a part of the service, he met with such a reception as ill became a republic to give that were under so many great obligations to us; in short, such a one as those only deserve who are content to take.


It has likewise been no small inconvenience to us, that the Dutch are always slow in paying their subsidies; by which means the weight and pressure of the payment lies upon the queen, as well as the blame if her majesty be not very exact. Nor will this always content our allies: for in July, 1711, the king of **Spain** was paid all his subsidies to the first of January next: nevertheless he has since complained for want of money; and his secretary threatened that, if we would not farther supply his majesty, he could not answer for what might happen; although king Charles had not at that time one-third of the troops for which he was paid, and even those he had were neither paid nor clothed.


I cannot forbear mentioning here another passage concerning subsidies, to show what opinion foreigners have of our easiness, and how much they reckon themselves masters of our money whenever they think fit to call for it. The queen was by agreement to pay two hundred thousand crowns a year to the Prussian troops; the States one hundred thousand; and the emperor only thirty thousand for recruiting, which his Imperial majesty never paid. Prince Eugene happening to pass by Berlin, the ministers of that court applied themselves to him for redress in this particular; and his highness very frankly promised them that, in consideration of this deficiency, Britain and the States should increase their subsidies to seventy thousand crowns more between them, and that the emperor should be punctual for the time to come. This was done by that prince without any orders or power whatsoever. The Dutch very reasonably refused consenting to it; but the Prussian minister here, making his applications at our court, prevailed on us to agree to our proportion before we could hear what resolution would be taken in **Holland**. It is therefore to be hoped that his Prussian majesty, at the end of this war,





---

p.431




will not have the same cause of complaint which he had at the close of the last; that his military chest was emptier by twenty thousand crowns than at the time that war began.


The emperor, as we have already said, was by stipulation to furnish ninety thousand men against the common enemy, as having no fleets to maintain, and in right of his family being most concerned in the war. However, this agreement has been so ill observed, that from the beginning of the war to this day neither of the two last emperors had ever twenty thousand men on their own account in the common cause, excepting once in **Italy**, when the imperial court exerted itself in a point they have much more at heart than that of gaining **Spain** or the Indies to their family. When they had succeeded in their attempts on the side of **Italy**, and observed our blind zeal for pushing on the war at all adventures, they soon found out the most effectual expedient to excuse themselves. They computed easily that it would cost them less to make large presents to one single person than to pay an army, and turn to as good account. They thought they could not put their affairs into better hands; and therefore wisely left us to fight their battles.


Besides, it appeared by several instances how little the emperor regarded his allies, or the cause they were engaged in, when once he thought the empire itself was secure. It is known enough that he might several times have made a peace with his discontented subjects in Hungary, upon terms not at all unbefitting either his dignity or interest; but he rather chose to sacrifice the whole alliance to his private passion, by entirely subduing and enslaving a miserable people, who had but too much provocation to take up arms to free themselves from the oppressions under which they were groaning; yet this must serve as an excuse for breaking his agreement, and diverting so great a body of troops, which might have been employed against **France**.


Another instance of the emperor's indifference, or rather dislike, to the common cause of the allies, is the business of Toulon. This design was indeed discovered here at home by a person whom everybody knows to be the creature of a certain great man, at least as much noted for his skill in gaming as in politics, upon the base mercenary end of getting money by wagers; which was then so common a practice, that I remember a gentleman in business, who, having the curiosity to inquire how wagers went upon the exchange, found some people deep in the secret to have been concerned in that kind of traffic, as appeared by premiums named for towns which nobody but those behind the curtain could suspect. However, although this project had gotten wind by so scandalous a proceeding, yet Toulon might probably have been taken, if the emperor had not thought fit in that very juncture, to detach twelve or fifteen thousand men to seize **Naples**, as an enterprise that was more his private and immediate interest. But it was manifest that his imperial majesty had no mind to see Toulon in possession of the allies; for even with these discouragements the attempt might have yet succeeded, if prince Eugene had not thought fit to oppose it, which cannot be imputed to his own judgment, but to some politic reasons of his court. The **duke of **Savoy**** was for attacking the enemy as soon as our army arrived; but when the mareschal de Thesse's troops were all come up, to pretend to besiege the place, in the condition we were at that time was a farce and a jest. Had Toulon fallen then into our hands, the maritime power of **France** would in a great measure have been destroyed.


But a much greater instance than either of the foregoing, how little the emperor regarded us or our quarrel, after all we had done to save his imperial crown and to assert the title of his brother to the monarchy of **Spain**, may be brought from the proceedings of that court not many months ago. It was judged that a war carried on upon the side of **Italy** would cause a great diversion of the French forces, wound them in a very tender part, and facilitate the progress of our arms in **Spain** as well as **Flanders**. It was proposed to the **duke of **Savoy**** to make this diversion, and not only a diversion during the summer, but the winter too, by taking quarters on this side of the hills. Only, in order to make him willing and able to perform this work, two points were to be settled: first, it was necessary to end the dispute between the imperial court and his royal highness, which had no other foundation, than the emperor's refusing to make good some articles of that treaty on the faith of which the duke engaged in the present war, and for the execution whereof **Britain** and **Holland** became guarantees at the request of the late emperor Leopold. To remove this difficulty, the earl of *Peterborough* was despatched to **Vienna**, got over some part of those disputes to the satisfaction of the **duke of **Savoy****, and had put the rest in a fair way of being accommodated at the time the emperor Joseph died. Upon which great event the **duke of **Savoy**** took the resolution of putting himself immediately at the head of the army, although the whole matter was not finished, since the common cause required his assistance, and that, until a new emperor were elected, it was impossible to make good the treaty to him. In order to enable him, the only thing he asked was that he should be reinforced by the imperial court with eight thousand men before the end of the campaign. 

**Mr. Whitworth** was sent to Vienna to make this proposal; and it is credibly reported that he was empowered, rather than fail, to offer forty thousand pounds for the march of those eight thousand men, if he found it was want of ability and not inclination that hindered the sending of them. But he was so far from succeeding, that it was said the ministers of that court did not so much as give him an opportunity to tempt them with any particular sums; but cut off all his hopes at





---

p.432




once by alleging the impossibility of complying with the queen's demands upon any consideration whatsoever. They could not plead their old excuse of the war in Hungary, which was then brought to an end. They had nothing to offer but some general speculative reasons, which it would expose them to repeat; and so, after much delay and many trifling pretences, they utterly refused so small and seasonable an assistance, to the ruin of a project that would have more terrified **France**, and caused a greater diversion of their forces, than a much more numerous army in any other part. Thus, for want of eight thousand men, for whose winter campaign the queen was willing to give forty thousand pounds, and for want of executing the design I lately mentioned of hindering the enemy from erecting magazines, towards which her majesty was ready not only to bear her own proportion, but a share of that which the States were obliged to, our hopes of taking winter quarters in the north and south parts of **France** are eluded, and the war left in that method which is likely to continue it longest. Can there an example be given in the whole course of this war, where we have treated the pettiest prince with whom we had to deal in so contemptuous a manner? Did we ever once consider what we could afford, or what we were obliged to, when our assistance was desired, even while we lay under immediate apprehensions of being invaded?


When **Portugal** came as a confederate into the grand alliance, it was stipulated that the empire, **England**, and **Holland**, should each maintain four thousand men of their own troops in that kingdom, and pay between them a million of patacoons to the king of **Portugal**, for the support of twenty-eight thousand Portuguese; which number of forty thousand, was to be the confederate army against **Spain** on the **Portugal** side. This treaty was ratified by all the three powers. But in a short time after, the emperor declared himself unable to comply with this part of the agreement, and so left the two-thirds upon us, who very generously undertook that burden and at the same time two-thirds of the subsidies for maintenance of the Portuguese troops. But neither is this the worst part of the story: for although the Dutch did indeed send their own particular quota of four thousand men to **Portugal** (which, however, they would not agree to but upon condition that the other two-thirds should be supplied by us), yet they never took care to recruit them; for, in the year 1706, the Portuguese, British, and Dutch forces, having marched with the earl of Galway into Castile, and by the noble conduct of that general being forced to retire into Valencia, it was found necessary to raise a new army on the **Portugal** side, where the queen has, at several times, increased her establishment to ten thousand five hundred men; and the Dutch never replaced one single man, nor paid one penny of their subsidies to **Portugal**, in six years.


The Spanish army on the side of **Catalonia** is, or ought to be, about fifty thousand men, exclusive of **Portugal**. And here the war has been carried on almost entirely at our cost. For this whole army is paid by the queen, excepting only seven battalions and fourteen squadrons of Dutch and Palatines; and even fifteen hundred of these are likewise in our pay; besides the sums given to king Charles for subsidies and the maintenance of his court. Neither are our troops at Gibraltar included within this number. And farther, we alone have been at all the charge of transporting the forces first sent from Genoa to Barcelona, and of all the imperial recruits from time to time; and have likewise paid vast sums as levy-money, for every individual man and horse so furnished to recruit, although the horses were scarce worth the price of transportation. But this has been almost the constant misfortune of our fleet during the present war; instead of being employed on some enterprise for the good of the nation, or even for the protection of our trade, to be wholly taken up in transporting soldiers.


We have actually conquered all **Bavaria**, **Ulm**, **Augsburg**, **Landau**, and a great part of **Alsace**, for the emperor; and by the troops we have furnished, the armies we have paid, and the diversions we have given to the enemies' forces, have chiefly contributed to the conquests of **Milan**, **Mantua**, and **Mirandola**, and to the recovery of the dutchy of **Modena**. The last emperor drained the wealth of those countries into his own coffers, without increasing his troops against **France** by such mighty acquisitions, or yielding to the most reasonable requests we have made.


Of the many towns we have taken for the Dutch, we have consented by the **barrier treaty** that all those which were not in the possession of **Spain** upon the death of the late Catholic king shall be part of the States' dominions, and that they shall have the military power in the most considerable of the rest; which is, in effect, to be the absolute sovereigns of the whole. And the **Holland**ers have already made such good use of their time, that, in conjunction with our general, the oppressions of **Flanders** are much greater than ever.


And this treatment which we have received from our two principal allies, has been pretty well copied by most other princes in the confederacy with whom we have any dealings. For instance, seven Portuguese regiments after the battle of Almanza went off with the rest of that broken army to **Catalonia**; the king of **Portugal** said he was not able to pay them while they were out of his country; the queen consented therefore to do it herself, provided the king would raise as many more to supply their place. This he engaged to do, but he never performed. Notwithstanding which, his subsidies were constantly paid him by my **Lord Godolphin** for almost four years, without any deduction upon account of those seven regiments; directly contrary





---

p.433




to the seventh article of our offensive alliance with that crown, where it is agreed that a deduction shall be made out of those subsidies in proportion to the number of men wanting in that complement which the king is to maintain. But whatever might have been the reasons for this proceeding, it seems they are above the understanding of the present lord treasurer,[12](javascript:footNote('E700001-019/note012.html')) who, not entering into those refinements of paying the public money upon private considerations, has been so uncourtly as to stop it. This disappointment, I suppose, has put the court of Lisbon upon other expedients: of raising the price of forage, so as to force us either to lessen our number of troops or be at double expense in maintaining them; and this at a time when their own product, as well as the import of corn, was never greater; and of demanding a duty upon the soldiers' clothes we carried over for those troops which have been their sole defence against an inveterate enemy; whose example might have infused courage, as well as taught them discipline, if their spirits had been capable of receiving either.


In order to augment our forces every year in the same proportion as those for whom we fight diminish theirs, we have been obliged to hire troops from several princes of the empire, whose ministers and residents here have perpetually importuned the court with unreasonable demands, under which our late ministers thought fit to be passive. For those demands were always backed with a threat to *recall* their soldiers, which was a thing not to be heard of, because it might discontent the Dutch. In the mean time, those princes never sent their contingent to the emperor, as by the laws of the empire they are obliged to do, but gave for their excuse that we had already hired all they could possibly spare.


But if all this be true; if, according to what I have affirmed, we began this war contrary to reason; if, as the other party themselves upon all occasions, acknowledge, the success we have had was more than we could reasonably expect; if, after all our success, we have not made that use of it which in reason we ought to have done; if we have made weak and foolish bargains with our allies, suffered them tamely to break every article even in those bargains to our disadvantage, and allowed them to treat us with insolence and contempt at the very instant when we were gaining towns, provinces, and kingdoms for them, at the price of our ruin and without any prospect of interest to ourselves; if we have consumed all our strength in attacking the enemy on the strongest side, where (as the old duke of Schomberg expressed it) to engage with **France** was to take a bull by the horns, and left wholly unattempted that part of the war which could only enable us to continue or to end it; if all this, I say, be our case, it is a very obvious question to ask, by what motives or what management we are thus become the dupes and bubbles of Europe? Surely it cannot be owing to the stupidity arising from the coldness of our climate, since those among our allies, who have given us most reason to complain are as far removed from the sun as ourselves.


If, in laying open the real causes of our present misery, I am forced to speak with some freedom, I think it will require no apology. Reputation is the smallest sacrifice those can make us who have been the instruments of our ruin, because it is that for which, in all probability, they have the least value. So that, in exposing the actions of such persons, I cannot be said, properly speaking, to do them an injury. But as it will be some satisfaction to the people to know by whom they have been so long abused, so it may be of great use to us and our posterity not to trust the safety of their country in the hands of those who act by such principles and from such motives.


I have already observed that, when the counsels of this war were debated in the late king's time, a certain great man was then so averse from entering into it, that he rather chose to give up his employment and tell the king he could serve him no longer. Upon that prince's death, although the grounds of our quarrel with **France** had received no manner of addition, yet this lord thought fit to alter his sentiments; for the scene was quite changed: his lordship, and the family with whom he was engaged by so complicated an alliance, were in the highest credit possible with the queen. The treasurer's staff was ready for his lordship; the duke was to command the army, and the duchess, by her employments and the favour she was possessed of, to be always nearest her majesty's person; by which the whole power at home and abroad would be devolved upon that family. This was a prospect so very inviting that, to confess the truth, it could not be easily withstood by any who have so keen an appetite for wealth or power. By an agreement subsequent to the grand alliance, we were to assist the Dutch with forty thousand men, all to be commanded by the duke of Marlborough. So that, whether this war was prudently begun or not, it is plain that the true spring or motive of it was the aggrandizing of a particular family; and, in short, a war of the general and the ministry, and not of the prince or people; since those very persons were against it, when they knew the power, and consequently the profit, would be in other hands.


With these measures fell in all that set of people who are called the moneyed men; such as had raised vast sums by trading with stocks and funds, and lending upon great interest and premiums; whose perpetual harvest is war, and whose beneficial way of traffic must very much decline by a peace.


In that whole chain of encroachments made upon us by the Dutch, which I have above deduced, and under those several gross impositions from other princes, if any one should ask why our general continued so easy to the last, I





---

p.434



 

know no other way probable, or indeed so charitable, to account for it, as by that unmeasurable love of wealth which his best friends allow to be his predominant passion. However, I shall waive anything that is personal upon this subject. I shall say nothing of those great presents made by several princes which the soldiers used to call winter foraging and said it was better than that of the summer; of two and a half per cent, subtracted out of all the subsidies we pay in those parts, which amounts to no inconsiderable sum; and lastly, of the grand perquisites in a long successful war which are so amicably adjusted between him and the States.


But when the war was thus begun, there soon fell in other incidents here at home, which made the continuance of it necessary for those who were the chief advisers. The Whigs were at that time out of all credit or consideration. The reigning favourites had always carried what were called the Tory principles at least as high as our constitution could bear; and most others in great employments were wholly in the Church interest. These last, among whom were several persons of the greatest merit, quality, and consequence, were not able to endure the many instances of pride, insolence, avarice and ambition, which those favourites began so early to discover, nor to see them presuming to be sole dispensers of the royal favour. However, their opposition was to no purpose; they wrestled with too great a power and were soon crushed under it. For those in possession, finding they could never be quiet in their usurpations while others had any credit who were at least upon an equal foot of merit, began to make overtures to the discarded Whigs, who would be content with any terms of accommodation. Thus commenced this solemn league and covenant, which has ever since been cultivated with so much application. The great traders in money were wholly devoted to the Whigs, who had first raised them. The army, the court, and the treasury, continued under the old despotic administration: the Whigs were received into employment, left to manage the parliament, cry down the landed interest, and worry the Church. Meantime, our allies, who were not ignorant that all this artificial structure had no true foundation in the hearts of the people, resolved to make the best use of it as long as it should last. And the general's credit being raised to a great height at home by our success in **Flanders**, the Dutch began their gradual impositions; lessening their quotas, breaking their stipulations, garrisoning the towns we took for them without supplying their troops; with many other infringements; all which we were forced to submit to, because the general was made easy; because the moneyed men at home were fond of the war; because the Whigs were not yet firmly settled; and because that exorbitant degree of power which was built upon a supposed necessity of employing particular persons would go off in a peace. It is needless to add, that the emperor and other princes followed the example of the Dutch, and succeeded as well, for the same reasons.


I have here imputed the continuance of the war to the mutual indulgence between our general and allies, wherein they both so well found their accounts; to the fears of the money-changers lest their tables should be overthrown; to the designs of the Whigs, who apprehended the loss of their credit and employments in a peace; and to those at home, who held their immoderate engrossments of power and favour by no other tenure than their own presumption upon the necessity of affairs. The truth of this will appear indisputable, by considering with what unanimity and concert these several parties acted towards that great end.


When the vote passed in the house of lords against any peace without **Spain** being restored to the Austrian family, the Earl of Wharton told the house that it was indeed impossible and impracticable to recover **Spain**; but however, there were certain reasons why such a vote should be made at that time. Which reasons wanted no explanation; for the general and the ministry, having refused to accept very advantageous offers of a peace, after the battle of ***Ramillies***, were forced to take in a set of men with a previous bargain to screen them from the consequences of that miscarriage. And accordingly, upon the first succeeding opportunity that fell, which was that of the prince of **Denmark**'s[13](javascript:footNote('E700001-019/note013.html')) death, the chief leaders of the party were brought into several great employments.


Thus, when the queen was no longer able to bear the tyranny and insolence of those ungrateful servants, who as they waxed the fatter did but kick the more; our two great allies abroad and our stock-jobbers at home took immediate alarm; applied the nearest way to the throne, by memorials and messages jointly, directing her majesty not to change her secretary or treasurer, who, for the true reasons that these officious intermeddlers demanded their continuance, ought never to have been admitted into the least degree of trust; since what they did was nothing less than betraying the interest of their native country to those princes, who in their turns, were to do what they could to support them in power at home.


Thus it plainly appears that there was a conspiracy on all sides to go on with those measures which must perpetuate the war; and a conspiracy founded upon the interest and ambition of each party; which begat so firm a union that, instead of wondering why it lasted so long, I am astonished to think how it came to be broken. The prudence, courage, and firmness of her majesty, in all the steps of that great change, would, if the particulars were truly related, make a very shining part in her story; nor is her judgment less to be admired, which directed her in the choice of perhaps the only persons who had skill, credit, and resolution enough to be her instruments in overthrowing so many difficulties.




---

p.435


Some would pretend to lessen the merit of this by telling us that the rudeness, the tyranny, the oppression, the ingratitude of the late favourites towards their mistress, were no longer to be borne. They produce instances to show, how her majesty was pursued through all her retreats, particularly at Windsor; where, after the enemy had possessed themselves of every inch of ground, they at last attacked and stormed the castle, forcing the queen to fly to an adjoining cottage, pursuant to the advice of **Solomon**, who tells us, ‘It is better to live on the house top, than with a scolding woman in a large house.’ They would have it that such continued ill usage was enough to inflame the meekest spirit. They blame the favourites in point of policy, and think it nothing extraordinary that the queen should be at the end of her patience, and resolve to discard them. But I am of another opinion, and think their proceedings were right. For nothing is so apt to break even the bravest spirits as a continual chain of oppressions; one injury is best defended by a second, and this by a third. By these steps the old masters of the palace in **France** became masters of the kingdom;[14](javascript:footNote('E700001-019/note014.html')) and by these steps a general during pleasure might have grown into a general for life, and a general for life into a king. So that I still insist upon it as a wonder, how her majesty, thus besieged on all sides, was able to extricate herself.


Having thus mentioned the real causes, although disguised under specious pretences, which have so long continued the war, I must beg leave to reason a little with those persons who are against any peace but what they call a good one, and explain themselves that no peace can be good without an entire restoration of **Spain** to the house of Austria. It is to be supposed that what I am to say upon this part of the subject will have little influence on those whose particular ends or designs of any sort lead them to wish the continuance of the war: I mean the general and our allies abroad, the knot of late favourites at home, the body of such as traffic in stocks, and lastly that set of factious politicians who were so violently bent at least upon clipping our constitution in Church and state. Therefore I shall not apply myself to any of those, but to all others indifferently, whether Whigs or Tories, whose private interest is best answered by the welfare of their country. And if among these there be any who think we ought to fight on till king Charles is quietly settled in the monarchy of **Spain**, I believe there are several points which they have not thoroughly considered.


For, first, it is to be observed that this resolution against any peace without **Spain** is a new incident, grafted upon the original quarrel by the intrigues of a faction among us, who prevailed to give it the sanction of a vote in both houses of parliament, to justify those whose interest lay in perpetuating the war. And as this proceeding was against the practice of all princes and states,whose intentions were fair and honourable, so is it contrary to common prudence, as well as justice; I might add that it was impious too, by presuming to control events which are only in the hands of God. Ours and the States' complaint against **France** and **Spain** are deduced in each of our declarations of war, and our pretensions specified in the eighth article of the grand alliance; but there is not in any of these the least mention of demanding **Spain** for the house of Austria, or of refusing any peace without that condition. Having already made an extract from both declarations of war, I shall here give a translation of the eighth article in the grand alliance, which will put this matter out of dispute.


*The Eighth Article of the Grand Alliance.*


When the war is once undertaken, none of the parties shall have the liberty to enter upon a treaty of peace with the enemy but jointly and in concert with the other. Nor is peace to be made without having first obtained a just and reasonable satisfaction for his Caesarean majesty, and for his royal majesty of **Great Britain**, and a particular security to the lords the States-General of their dominions, provinces, titles, navigation, and commerce, and a sufficient provision that the kingdoms of **France** and **Spain** be never united, or come under the government of the same person, or that the same man may never be king of both kingdoms: and particularly that the French may never be in possession of the Spanish West Indies; and that they may not have the liberty of navigation, for conveniency of trade, under any pretence whatsoever, neither directly nor indirectly, except it is agreed that the subjects of **Great Britain** and **Holland** may have full power to use and enjoy all the same privileges, rights, immunities, and liberties of commerce, by land and sea, in **Spain**, in the Mediterranean, and in all the places and countries which the late king of **Spain** at the time of his death was in possession of, as well in Europe as elsewhere, as they did then use and enjoy; or which the subjects of both or each nation could use and enjoy by virtue of any right obtained before the death of the said king of **Spain**, either by treaties, conventions, custom, or any other way whatsoever.


Here we see the demands intended to be insisted on by the allies upon any treaty of peace, are a just and reasonable satisfaction for the emperor and king of **Great Britain**, a security to the States-General for their deminions, &c. and a sufficient provision that **France** and **Spain** be never united under the same man as king of both kingdoms. The rest relates to the liberty of trade and commerce for us and the Dutch, but not a syllable of engaging to dispossess the duke of Anjou.


But to know how this new language, of no peace without **Spain**, was first introduced, and at last prevailed among us, we must begin a great deal higher.




---

p.436


It was the partition treaty which begot the will in favour of the duke of Anjou; for this naturally led the Spaniards to receive a prince supported by a great power, whose interest as well as affection engaged them to preserve that monarchy entire, rather than to oppose him in favour of another family, who must expect assistance from a number of confederates whose principal members had already disposed of what did not belong to them, and by a previous treaty parcelled out the monarchy of **Spain**.


Thus the duke of Anjou got into the full possession of all the kingdoms and states belonging to that monarchy, as well in the old world as the new. And whatever the house of Austria pretended from their memorials to us and the States, it was at that time but too apparent that the inclinations of the Spaniards were on the duke's side.


However, a war was resolved on; and, in order to carry it on with great vigour, a grand alliance formed, wherein the ends proposed to be obtained are plainly and distinctly laid down as I have already quoted them. It pleased God, in the course of this war, to bless the *armies* of the allies with remarkable successes; by which we were soon put into a condition of demanding and expecting such terms of a peace as we proposed to ourselves when we began the war. But instead of this, our victories only served to lead us on to farther visionary prospects; advantage was taken of the sanguine temper which so many successes had wrought the nation up to; new romantic views were proposed, and the old, reasonable, sober design, was forgot.


This was the artifice of those here who were sure to grow richer as the public became poorer, and who, after the resolutions which the two houses were prevailed upon to make, might have carried on the war with safety to themselves till malt and land were mortgaged, till a general excise was established; and the **dixième denier** raised, by collectors in red coats. And this was just the circumstance which it suited their interests to be in.


The house of Austria approved this scheme with reason, since whatever would be obtained by the blood and treasure of others was to accrue to that family, while they only lent their name to the cause.


The Dutch might, perhaps, have grown resty under their burden; but care was likewise taken of that, by a barrier treaty made with the States, which deserves such epithets as I care not to bestow, but may perhaps consider it, at a proper occasion, in a discourse by itself.


By this treaty the condition of the war with respect to the Dutch was widely altered; they fought no longer for security but for grandeur, and we, instead of labouring to make them safe, must beggar ourselves to render them formidable.


Will any one contend that if, at the treaty of **Gertruydenberg**, we could have been satisfied with such terms of a peace as we proposed to ourselves by the grand alliance, the French would not have allowed them? It is plain they offered many more, and much greater, than ever we thought to insist on when the war began; and they had reason to grant as well as we to demand them, since conditions of peace do certainly turn upon events of war. But surely there is some measure to be observed in this; those who have defended the proceedings of our negotiators at the treaty of **Gertruydenberg** dwell very much upon their zeal and patience in endeavouring to work the French up to their demands, but say nothing to justify those demands, or the probability that **France** would ever accept them. Some of the articles in that treaty were so very extravagant that, in all human probability, we could not have obtained them by a successful war of forty years. One of them was inconsistent with common reason; wherein the confederates reserved to themselves full liberty of demanding, what farther conditions they should think fit; and, in the mean time, **France** was to deliver up several of their strongest towns in a month. These articles were very gravely signed by our plenipotentiaries and those of **Holland**; but not by the French, although it ought to have been done interchangeably; nay, they were brought over by the secretary of the embassy, and the ministers here prevailed on the queen to execute a ratification of articles which only one part had signed. This was an absurdity in form as well as in reason; because the usual form of a ratification is with a preamble, showing that, whereas our ministers and those of the allies and of the enemy have signed, &c., we ratify, &c. The person[15](javascript:footNote('E700001-019/note015.html')) who brought over the articles said in all companies (and perhaps believed) that it was a pity we had not demanded more, for the French were in a disposition to refuse us nothing we would ask. One of our plenipotentiaries affected to have the same concern, and particularly that we had not obtained some farther security for the empire on the Upper Rhine.


What could be the design of all this grimace but to amuse the people, and to raise stocks for their friends in the secret to sell to advantage? I have too great a respect for the abilities of those who acted in this negotiation, to believe they hoped for any other issue from it than what we found by the event. Give me leave to suppose the continuance of the war was the thing at heart among those in power both abroad and at home, and then I can easily show the consistency of their proceedings; otherwise they are wholly unaccountable and absurd. Did those who insisted on such wild demands ever intend a peace? Did they really think that going on with the war was more eligible for their country than the least abatement of those conditions? Was the smallest of them worth six millions a year, and a hundred thousand men's lives? Was there no way to provide for the safety of Britain or the security of its trade, but by the French king turning his arms to beat his grandson out of **Spain**? If these able statesmen





---

p.437






were so truly concerned for our trade, which they made the pretence of the war's beginning as well as continuance, why did they so neglect it in those very preliminaries where the enemy made so many concessions, and where all that related to the advantage of **Holland**, or the other confederates, was expressly settled? But whatever concerned us was to be left to a general treaty; no tariff agreed on with **France** or **the Low Countries**, only the **Schelde** was to remain shut, which must have ruined our commerce with **Antwerp**. Our trade with **Spain** was referred the same way; but this they will pretend to be of no consequence, because that kingdom was to be under the house of Austria, and we had already made a treaty with king Charles. I have indeed heard of a treaty made by **Mr Stanhope** with that prince for settling our commerce with **Spain**; but, whatever it were, there was another between us and **Holland**, which went hand in hand with it,—I mean that of barrier, wherein a clause was inserted by which all advantages proposed for Britain, are to be in common with **Holland**.


Another point, which I doubt those have not considered who are against any peace without **Spain**, is that the face of affairs in Christendom, since the emperor's death, has been very much changed. By this accident the views and interests of several princes and states in the alliance have taken a new turn, and I believe it will be found that ours ought to do so too. We have sufficiently blundered once already, by changing our measures with regard to a peace while our affairs continued in the same posture; and it will be too much in conscience to blunder again, by not changing the first, when the others are so much altered.


To have a prince of the Austrian family on the throne of **Spain** is undoubtedly more desirable than one of the house of Bourbon; but to have the empire and Spanish monarchy united in the same person is a dreadful consideration, and directly opposite to that wise principle on which the eighth article of the alliance is founded.


To this perhaps it will be objected that the indolent character of the Austrian princes, the wretched economy of that government, the want of a naval force, the remote distances of their several territories from each other, would never suffer an emperor, although at the same time king of **Spain**, to become formidable: on the contrary, that his dependence must continually be on **Great Britain**, and the advantages of trade, by a peace founded upon that condition, would soon make us amends for all the expenses of the war.


In answer to this, let us consider the circumstances we must be in before such a peace could be obtained, if it were at all practicable. We must become not only poor for the present, but reduced by farther mortgages to a state of beggary, for endless years to come. Compare such a weak condition as this with so great an accession of strength to Austria, and then determine how much an emperor in such a state of affairs would either fear or need Britain.


Consider that the comparison is not formed between a prince of the house of Austria, emperor and king of **Spain**, and *between* a prince of the Bourbon family, king of **France** and **Spain**; but between a prince of the latter, only king of **Spain**, and one of the former, uniting both crowns in his own person.


What returns of gratitude can we expect when we are no longer wanted? Has all that we have hitherto done for the imperial family been taken as a favour, or only received as the due of the augustissima casa?


Will the house of Austria yield the least acre of land, the least article of strained and even usurped prerogative, to resettle the minds of those princes in the alliance who are alarmed at the consequences of this turn of affairs occasioned by the emperor's death? We are assured it never will. Do we then imagine that those princes who dread the overgrown power of the Austrian, as much as that of the Bourbon family will continue in our alliance upon a system contrary to that which they engage with us upon? For instance; What can the **duke of **Savoy**** expect in such a case? Will he have any choice left him but that of being a slave and a frontier to **France**, or a vassal, in the utmost extent of the word, to the imperial court? Will he not therefore of the two evils choose the least, by submitting to a master who has no immediate claim upon him, and to whose family he is nearly allied, rather than to another, who has already revived several claims upon him and threatens to revive more?


Nor are the Dutch more inclined than the rest of Europe that the empire and **Spain** should be united in king Charles, whatever they may now pretend. On the contrary, it is known to several persons that upon the death of the late emperor Joseph the States resolved that those two powers should not be joined in the same person, and this they determined as a fundamental maxim by which they intended to proceed. So that **Spain** was first given up by them; and since they maintain no troops in that kingdom, it should seem that they understand the duke of Anjou to be lawful monarch.


Thirdly, *those* who are against any peace without **Spain**, if they be such as no way find their private account by the war, may perhaps change their sentiments if they will reflect a little upon our present condition.


I had two reasons for not sooner publishing this discourse; the first was, because I would give way to others, who might argue very well upon the same subject from general topics and reason, although they might be ignorant of several facts which I had the opportunity to know. The second was, because I found it would be necessary, in the course of this argument, to say something of the state to which this war has reduced us; at the same time I knew that such a discovery ought to be made as late as possible, and at another juncture would not only be





---

p.438




very indiscreet, but might perhaps be dangerous.


It is the folly of too many to mistake the echo of a London coffeehouse for the voice of the kingdom. The city coffeehouses have been for some years filled with people whose fortunes depend upon the Bank, East India, or some other stock. Every new fund to these is like a new mortgage to an usurer, whose compassion for a young heir is exactly the same with that of a stock-jobber to the landed gentry. At the court end of the town, the like places of resort are frequented either by men out of place, and consequently enemies to the present ministry, or by officers of the army: no wonder, then, if the general cry in all such meetings be against any peace, either with **Spain** or without, which in other words is no more than this, that discontented men desire another change of ministry; that soldiers would be glad to keep their commissions; and that the creditors have money still, and would have the debtors borrow on at the old extorting rate while they have any security to give.


Now, to give the most ignorant reader some idea of our present circumstances, without troubling him or myself with computations in form; everybody knows that our land and malt tax amount annually to about two millions and a half. All other branches of the revenue are mortgaged to pay interest for what we have already borrowed. The yearly charge of the war is usually about six millions, to make up which sum we are forced to take up on the credit of new funds about three millions and a half. This last year the computed charge of the war came to above a million more than all the funds the parliament could contrive were sufficient to pay interest for, and so we have been forced to divide a deficiency of twelve hundred thousand pounds among the several branches of our expense. This is a demonstration that, if the war lasts another campaign, it will be impossible to find funds for supplying it without mortgaging the malt tax, or by some other method equally desperate.


If the peace be made this winter, we are then to consider what circumstances we shall be in towards paying a debt of about fifty millions, which is a fourth part of the purchase of the whole island if it were to be sold.


Towards clearing ourselves of this monstrous incumbrance, some of these annuities will expire or pay off the principal in thirty, forty, or a hundred years; the bulk of the debt must be lessened gradually by the best management we can, out of what will remain of the land and malt taxes, after paying guards and garrisons, and maintaining and supplying our fleet in the time of peace. I have not skill enough to compute what will be left, after these necessary charges, towards annually clearing so vast a debt, but believe it must be very little; however, it is plain that both these taxes must be continued, as well for supporting the government, as because we have no other means for paying off the principal. And so likewise must all the other funds remain for paying the interest. How long a time this must require, how steady an administration, and how undisturbed a state of affairs both at home and abroad, let others determine.


However, some people think all this very reasonable, and that, since the struggle has been for peace and safety, posterity, which is to partake of the benefit, ought to share in the expense; as if at the breaking out of this war there had been such a conjuncture of affairs as never happened before, nor would ever happen again. It is wonderful that our ancestors, in all their wars, should never fall under such a necessity; that we meet no examples of it in Greece and Rome; that no other nation in Europe ever knew anything like it except **Spain**, about a hundred and twenty years ago, when they drew it upon themselves by their own folly and have suffered for it ever since; no doubt we shall teach posterity wisdom, but they will be apt to think the purchase too dear, and I wish they may stand to the bargain we have made in their names.


It is easy to entail debts on succeeding ages, and to hope they will be able and willing to pay them; but how to ensure peace for any term of years is difficult enough to apprehend. Will human nature ever cease to have the same passions, princes to entertain designs of interest or ambition, and occasions of quarrel to arise? May not we ourselves, by the variety of events and incidents which happen in the world, be under a necessity of recovering towns out of the very hands of those for whom we are now ruining our country to take them? Neither can it be said that those states with whom we may probably differ will be in as bad a condition as ourselves; for by the circumstances of our situation, and the impositions of our allies, we are more exhausted than either they or the enemy: and by the nature of our government, the corruption of our manners, and the opposition of factions, we shall be more slow in recovering.


It will no doubt be a mighty comfort to our grandchildren, when they see a few rags hang up in Westminster Hall which cost a hundred millions, whereof they are paying the arrears, and boasting as beggars do that their grandfathers were rich and great.


I have often reflected on that mistaken notion of credit so boasted of by the advocates of the late ministry: was not all that credit built upon funds raised by the landed men whom they so much hate and despise? Is not the greatest part of those funds raised from the growth and product of land? Must not the whole debt be entirely paid, and our fleets and garrisons be maintained, by the land and malt tax after a peace? If they call it credit to run ten millions in debt without parliamentary security, by which the public is defrauded of almost half, I must think such credit to be dangerous, illegal, and perhaps treasonable. Neither has anything





---

p.439




 gone farther to ruin the nation than their boasted credit. For my own part, when I saw this false credit sink upon the change of the ministry, I was singular enough to conceive it a good omen. It seemed as if the young extravagant heir had got a new steward, and was resolved to look into his estate before things grew desperate, which made the usurers forbear feeding him with money as they used to do.


Since the moneyed men are so fond of war, I should be glad they would furnish out one campaign at their own charge; it is not above six or seven millions; and I dare engage to make it out than when they have done this, instead of contributing equal to the landed men, they will have their full principal and interest at six per cent remaining of all the money they ever lent to the government.


Without this resource, or some other equally miraculous, it is impossible for us to continue the war upon the same foot. I have already observed that the last funds of interest fell short above a million, although the persons most conversant in ways and means employed their utmost invention; so that of necessity we must be still more defective next campaign. But perhaps our allies will make up this deficiency on our side by great efforts on their own? Quite the contrary; both the emperor and **Holland** failed this year in several articles, and signified to us some time ago that they cannot keep up to the same proportions in the next. We have gained a noble barrier for the latter, and they have nothing more to demand or desire. The emperor, however sanguine he may now affect to appear, will I suppose be satisfied with **Naples**, **Sicily**, **Milan**, and his other acquisitions, rather than engage in a long, hopeless war for the recovery of **Spain**, to which his allies the Dutch will neither give their assistance nor consent. So that, since we have done their business, since they have no farther service for our arms, and we have no more money to give them, and lastly, since we neither desire any recompense nor expect any thanks, we ought in pity to be dismissed and have leave to shift for ourselves. They are ripe for a peace to enjoy and cultivate what we have conquered for them; and so are we to recover, if possible, the effects of their hardships upon us. The first overtures from **France** are made to **England** upon safe and honourable terms; we, who bore the burden of the war, ought in reason to have the greater share in making the peace. If we do not hearken to a peace, others certainly will, and get the advantage of us there, as they have done in the war. We know the Dutch have perpetually threatened us that they would enter into separate measures of a peace; and by the strength of that argument, as well as by other powerful motives, prevailed on those who were then at the helm to comply with them on any terms, rather than put an end to a war which every year brought them such great accessions to their wealth and power. Whoever falls off, a peace will follow, and then we must be content with such conditions as our allies, out of their concern for our safety and interest, will please to choose. They have no farther occasion for fighting, they have gained their point, and they now tell us it is our war; so that in common justice it ought to be our peace.


All we can propose by the desperate steps of pawning our land or malt tax, or erecting a general excise, is only to raise a fund of interest for running us annually four millions farther in debt, without any prospect of ending the war so well as we can do at present. And when we have sunk the only unengaged revenues we had left, our *incumbrances* must of necessity remain perpetual.


We have hitherto lived upon expedients which in time will certainly destroy any constitution, whether civil or natural; and there was no country in Christendom had less occasion for them than ours. We have dieted a healthy body into a consumption, by plying it with physic instead of food. Art will help us no longer, and if we cannot recover by letting the remains of nature work, we must inevitably die.


What arts have been used to possess the people with a strong delusion that Britain must infallibly be ruined without the recovery of **Spain** to the house of Austria! making the safety of a great and powerful kingdom, as ours was then, to depend upon an event which, after a war of miraculous successes, proves impracticable. As if princes and great ministers could find no way of settling the public tranquillity without changing the possessions of kingdoms, and forcing sovereigns upon a people against their inclinations. Is there no security for the island of Britain unless a king of **Spain** be dethroned by the hands of his grandfather? Has the enemy no cautionary towns and seaports to give us for securing trade? Can he not deliver us possession of such places as would put him in a worse condition whenever he should perfidiously renew the war? The present king of **France** has but few years to live by the course of nature, and doubtless would desire to end his days in peace. Grandfathers, in private families, are not observed to have great influence on their grandsons, and I believe they have much less among princes; however, when the authority of a parent is gone, is it likely that Philip will be directed by a brother against his own interest and that of his subjects? Have not those two realms their separate maxims of policy, which must operate in times of peace? These at least are probabilities, and cheaper by six millions a year than recovering **Spain** or continuing the war, both which seem absolutely impossible.


But the common question is, if we must now surrender **Spain**, what have we been fighting for all this while? The answer is ready: we have been fighting for the ruin of the public interest and the advancement of a private. We have been fighting to raise the wealth and grandeur of a particular family, to enrich usurers and stock-jobbers, and to cultivate the pernicious





---

p.440




designs of a faction by destroying the landed interest. The nation begins now to think these blessings are not worth fighting for any longer, and therefore desires a peace.


But the advocates on the other side cry out that we might have had a better peace than is now in agitation, above two years ago. Supposing this to be true, I do assert that, by parity of reason, we must expect one just so much worse about two years hence. If those in power could then have given us a better peace, more is their infamy and guilt that they did it not. Why did they insist upon conditions which they were certain would never be granted? We allow it was in their power to have put a good end to the war, and left the nation in some hope of recovering itself. And this is what we charge them with, as answerable to God, their country, and posterity,—that the bleeding condition of their fellow subjects was a feather in the balance with their private ends.


When we offer to lament the heavy debts and poverty of the nation, it is pleasant to hear some men answer all that can be said by crying up the power of **England**, the courage of **England**, the inexhaustible riches of **England**. I have heard a man[16](javascript:footNote('E700001-019/note016.html')) very sanguine upon this subject, with a good employment for life, and a hundred thousand pounds in the funds, bidding us take courage, and warranting that all would go well. This is the style of men at ease, who lay heavy burdens upon others, which they would not touch with one of their fingers. I have known some people such ill computers as to imagine the many millions in stocks and annuities are so much real wealth in the nation; whereas every farthing of it is entirely lost to us, scattered in **Holland**, **Germany**, and **Spain**; and the landed men who now pay the interest must at last pay the principal.


Fourthly, those who are against any peace without **Spain** have, I doubt, been ill informed as to the low condition of **France**, and the mighty consequences of our successes. As to the first, it must be confessed that after the battle of ***Ramillies*** the French were so discouraged with their frequent losses, and so impatient for a peace, that their king was resolved to comply on any reasonable terms. But when his subjects were informed of our exorbitant demands, they grew jealous of his honour, and were unanimous to assist him in continuing the war at any hazard rather than submit. This fully restored his authority; and the supplies he has received from the Spanish West Indies, which in all are computed since the war to amount to four hundred millions of livres (and all in specie), have enabled him to pay his troops. Besides, the money is spent in his own country; and he has since waged war in the most thrifty manner by acting on the defensive; compounding with us every campaign for a town, which costs us fifty times more than it is worth, either as to the value or the consequences. Then he is at no charge of a fleet farther than providing privateers, wherewith his subjects carry on a piratical war at their own expense, and he shares in the profit, which has been very considerable to **France** and of infinite disadvantage to us, not only by the perpetual losses we have suffered, to an immense value, but by the general discouragement of trade, on which we so much depend. All this, considered with the circumstances of that government, where the prince is master of the lives and fortunes of so mighty a kingdom, shows that monarch not to be so sunk in his affairs as we have imagined and have long flattered ourselves with the hopes of.


Those who are against any peace without **Spain** seem likewise to have been mistaken in judging our victories and other successes to have been of greater consequence than they really were.


When our armies take a town in **Flanders**, the Dutch are immediately put into possession, and we at home make bonfires. I have sometimes pitied the deluded people to see them squandering away their fuel to so little purpose. For example: what is it to us that **Bouchain** is taken, about which the warlike politicians of the coffeehouse make such a clutter? What though the garrison surrendered prisoners of war and in sight of the enemy? We are not now in a condition to be fed with points of honour. What advantage have we but that of spending three or four millions more to get another town for the States, which may open them a new country for contributions, and increase the perquisites of the general?


In that war of ten years under the late king, when our commanders and soldiers were raw and unexperienced in comparison of what they are at present, we lost battles and towns as well as we gained them of late since those gentlemen have better learned their trade; yet we bore up then, as the French do now: nor was there anything decisive in their successes: they grew weary as well as we, and at last consented to a peace, under which we might have been happy enough if it had not been followed by that wise treaty of partition, which revived the flame that has lasted ever since. I see nothing else in the modern way of making war but that the side which can hold out longest will end it with most advantage. In such a close country as **Flanders**, where it is carried on by sieges, the army that acts offensively is at a much greater expense of men and money, and there is hardly a town taken in the common forms where the besiegers have not the worst of the bargain. I never yet knew a soldier who would not affirm that any town might be taken if you were content to be at the charge. If you will count upon sacrificing so much blood and treasure, the rest is all a regular established method which cannot fail. When the king of **France**, in the times of his grandeur, sat down before a town, his generals and engineers would often fix the day when it should surrender: the enemy, sensible of all this, has for some years past avoided a battle where he has so ill succeeded, and taken a surer





---

p.441




way to consume us by letting our courage evaporate against stones and rubbish, and sacrificing a single town to a campaign, which he can so much better afford to lose than we to take.


Lastly, those who are so violently against any peace without **Spain**'s being restored to the house of Austria, have not, I believe, cast their eye upon a cloud gathering in the north, which we have helped to raise, and may quickly break in a storm upon our heads.


The northern war has been on foot almost ever since our breach with **France**. The success of it various; but one effect to be apprehended was always the same, that sooner or later it would involve us in its consequences, and that whenever this happened, let our success be never so great against **France**, from that moment **France** would have the advantage.


By our guaranty of the treaty of ***Travendal***, we were obliged to hinder the king of **Denmark** from engaging in a war with **Sweden**. It was at that time understood by all parties, and so declared even by the British ministers, that this engagement specially regarded **Denmark**'s not assisting **king Augustus**. But however, if this had not been so, yet our obligation to **Sweden** stood in force by virtue of former treaties with that crown, which were all revived and confirmed by a subsequent one, concluded at **the Hague** by **sir Joseph Williamson** and **Monsieur Lilienroot** about the latter end of the king's reign.


However, the war in the north proceeded; and our not assisting **Sweden** was at least as well excused by the war which we were entangled in, as his not contributing his contingent to the empire, whereof he is a member, was excused by the pressures he lay under, having a confederacy to deal with.


In this war the king of **Sweden** was victorious; and what dangers were we not then exposed to? What fears were we not in? He marched into **Saxony**, and, if he had really been in the French interest, might at once have put us under the greatest difficulties. But the torrent turned another way, and he contented himself with imposing on his enemy the treaty of ***Alt Rastadt***; by which **king Augustus** makes an absolute cession of the crown of **Poland**, renounces any title to it, acknowledges **Stanislaus**, and then both he and the king of **Sweden** join in desiring the guaranty of **England** and **Holland**. The queen did not, indeed, give this guaranty in form; but as a step towards it, the title of king was given to**Stanislaus** by a letter from her majesty, and the strongest assurances were given to the Swedish minister in her majesty's name, and in a committee of council, that the guaranty should speedily be granted, and that, in the mean while, it was the same thing as if the forms were passed.


In 1708 **king Augustus** made the campaign in **Flanders**: what measures he might at that time take, or of what nature the arguments might be that he made use of, is not known; but immediately after he breaks through all he had done, marches into **Poland**, and reassumes the crown.


After this we apprehended that the peace of the empire might be endangered; and therefore entered into an act of guaranty for the neutrality of it. The king of **Sweden** refused, upon several accounts, to submit to the terms of this treaty, particularly because we went out of the empire to cover **Poland** and **Jutland**, but did not go out of it to cover the territories of **Sweden**.


Let us therefore consider what is our case at present. If the king of **Sweden** return, and get the better, he will think himself under no obligation of having any regard to the interests of the allies, but will naturally pursue, according to his own expression, his enemy wherever he finds him. In this case, the corps of the neutrality is obliged to oppose him, and so we are engaged in a second war before the first is ended.


If the northern confederates succeed against **Sweden**, how shall we be able to preserve the balance of power in the north, so essential to our trade, as well as in many other respects? What will become of that great support of the Protestant interest in **Germany**, which is the footing that the Swedes now have in the empire? Or who shall answer that these princes, after they have settled the north to their minds, may not take a fancy to look southward, and make our peace with **France** according to their own schemes?


And lastly, if the king of **Prussia**, the elector of **Hanover**, and other princes whose dominions lie contiguous, are forced to draw from those armies which act against **France**, we must live in hourly expectation of having those troops recalled which they now leave with us; and this recall may happen in the midst of a siege, or on the eve of a battle. Is it therefore our interest to toil on in a ruinous war, for an impracticable end, till one of these cases shall happen, or get under shelter before the storm?


There is no doubt but the present ministry (provided they could get over the obligations of honour and conscience) might find their advantage in advising the continuance of the war, as well as the last did; although not in the same degree, after the kingdom has been so much exhausted. They might prolong it till the parliament desire a peace, and in the mean time leave them in full possession of power. Therefore it is plain that their proceedings at present are meant to serve their country, directly against their private interest; whatever clamour may be raised by those who, for the vilest ends, would move heaven and earth to oppose their measures. But they think it infinitely better to accept such terms as will secure our trade, find a sufficient barrier for the States, give reasonable satisfaction to the emperor, and restore the tranquillity of Europe, although without adding **Spain** to the empire; rather than go on in a languishing way, upon the vain expectation of some improbable turn for the recovery of that monarchy out of the Bourbon





---

p.442




family; and at last be forced to a worse peace, by some of the allies falling off, upon our utter inability to continue the war.


Postscript
----------


I have in this edition explained three or four lines which mentions the succession, to take off, if possible, all manner of cavil; though, at the same time, I cannot but observe how ready the adverse party is to make use of any objections, even such as destroy their own principles. I put a distant case of the possibility that our succession, through extreme necessity, might be changed by the legislature in future ages; and it is pleasant to hear those people quarrelling at this, who profess themselves for changing it as often as they please, and that even without the consent of the entire legislature.














