

#The Case for Home Rule


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Case for Home Rule
======================


Author: Stephen Gwynn
---------------------


### File Description

Electronic edition compiled by Beatrix Färber, Emer Purcell

Proof corrections by Aoife O'Brien, Beatrix Färber, Emer Purcell

 2. Second draft.Extent of text: 50150 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2006) (2011) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E900030Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Literature**2. You will find a listing of pamphlets relating to Home Rule on the following webpage maintained by the London School of Economics: http://www.lse.ac.uk/library/pamphlets/IssuesinBritishHistory/IssuesinBritishHistoryPamphlets/home\_rule\_for\_ireland\_scotland\_and\_wales.htm
3. Home government for Ireland: being a series of articles reprinted from "The Cork examiner", by John Francis Maguire. 1872.
4. Isaac Butt, Address to the people of Ireland. 1873.
5. Isaac Butt, Home government for Ireland. Irish federalism! Its meaning, its objects, and its hopes. (3rd ed. Dublin 1870; 4th ed. Dublin 1874).
6. Against Home Rule: the case for the Union by Arthur J. Balfour; J. Austen Chamberlain ... (et al.) with an introduction by Sir Edward Carson. Dublin: White 1870.
7. Proceedings of the Home Rule Conference held at Dublin on 18th, 19th, 20th and 21st November 1873 ... (Dublin, 1874).
8. H. de F. Montgomery, Correspondence with Mr. Gladstone and notes on the pamphlet, "Gladstone & Burke". 1884.
9. Thomas Maguire. England's duty to Ireland, as plain to a loyal Irish Roman Catholic. 1886.
10. A.V. Dicey. England's Case Against Home Rule (London, 1886), reprinted 1986.
11. J. Middleton. An Englishman's plea for Home Rule. 1886.
12. W.R. Young. Arguments in support of Home Rule. 1893.
13. John E. Redmond. Historical and political addresses 1883–1897. 1898.
14. T.W. Russell. England's opportunity in Ireland. 1902.
15. The ABC of home rule in three parts, 1911, Unionist Association of Ireland.
16. Erskine Childers. The framework of Home Rule. 1911.
17. Aspects of Home Rule, selected from the speeches of Arthur Balfour. 1912
18. William O'Brien. Grattan's Home Rule, Gladstone's, and Asquith's: an answer to a boast. 1915.
19. W.E. Gladstone, speech introducing the First Home Rule Bill, 8 April 1886 (Hansard iii vol. 304 1036 ff, reprinted in A.Tilney Bassett Gladstone: Speeches, Descriptive Index and Bibliography (London 1916).
20. T. M. Healy, Letters and leaders of my day (2 vols, London 1928).
21. Godfrey Vincent de Clinton Parmiter. Roger Casement. London: A. Barker, 1936.
22. J. L. Hammond, Gladstone and the Irish Nation (London 1938).
23. Terence de Vere White, The road to excess (Dublin 1946).
24. Hugh Shearman, Anglo-Irish relations. London: Faber, 1948.
25. Gerard Anthony Hayes-McCoy. 'Robert Louis Stevenson and the Irish question'. Studies; an Irish quarterly review, 39 (1950).
26. Harford Montgomery Hyde. Carson: the life of Sir Edward Carson, Lord Carson of Duncairn. London: Heinemann, 1953.
27. Conor Cruise O'Brien, Parnell and his party, 1880–90 (Oxford 1957).
28. Lawrence John McCaffrey. 'Isaac Butt and the Home Rule movement: a study in conservative nationalism'. Review of Politics 22 (1960).
29. Lawrence John McCaffrey, 'Irish Federalism in the 1870's: a study in conservative nationalism', Transactions of the American Philosophical Society, NS, 52 (1962), Part 6.
30. F. S. Leland Lyons, The fall of Parnell, 1890–91 (London 1960).
31. L. P. Curtis, Coercion and conciliation in Ireland, 1880–1892: a study in conservative unionism (Princeton NJ 1963).
32. David Thornley, Isaac Butt and Home Rule (London 1964).
33. A. T. Q. Stewart, The Ulster crisis: resistance to Home Rule, 1912–1914 (London 1967).
34. F. S. Leland Lyons. 'The two faces of home rule'. In Nowlan, Kevin Barry, The Making of 1916: studies in the history of the Rising (Dublin: The Stationery Office, 1969).
35. J. C. Beckett, 'Carson: unionist and rebel', in his Confrontations: studies in Irish history (London 1972).
36. Patrick Buckland, Irish Unionism, 1885–1923: a documentary history (Belfast 1973).
37. Ian Dalton. 'Southern Irish Unionism: a study of Cork Unionists, 1884–1914'. Transactions of the Royal Historical Society, 5th ser., 23 (1973).
38. F. S. Leland Lyons, Charles Stewart Parnell (London 1977).
39. R. A. Cosgrove, 'The relevance of Irish history: the Gladstone-Dicey debate about home rule, 1886–87'. Éire-Ireland, 13:4 (1978).
40. MacDonagh, Oliver. 'The last bill of pains and penalties: the case of Daniel O'Sullivan, 1869'. Irish Historical Studies, 19:74 (1974), 136–55.
41. Robert Fitzroy Foster. 'Parnell and his people: the ascendancy and home rule'. Canadian Journal of Irish Studies, 6 (1980).
42. Owen Dudley Edwards. 'Divided treason and divided loyalties: Roger Casement and others'. Transactions of the Royal Historical Society, 5th ser., 32 (1982)
43. James Loughlin, Gladstone, Home Rule, and the Ulster Question, 1882–93 (Dublin 1986)
44. Alan O'Day, Parnell and the first Home Rule episode 1884–87 (Dublin 1986).
45. William Michael Murphy, The Parnell myth and Irish politics 1891–1956 (New York 1986).
46. Paul Bew, Conflict and conciliation in Ireland, 1890–1910: Parnellites and radical agrarians (Oxford 1987).
47. Gearóid Ó Tuathaigh. 'From United Kingdom to divided island: aspects of the Irish experience, 1850–1922'. In: Thomas Bartlett; Chris Curtin; Riana O'Dwyer; Gearóid Ó Tuathaigh (eds.), Irish studies: a general introduction (Dublin: Gill & Macmillan, 1988) 126–151.
48. Alan O'Day, Irish Home Rule, 1867–1921 (Manchester 1998).
49. Isaac Butt on Rome Rule Hansard 3 (commons), 3rd series, ccxx, 30th June 1874, (ed) A. Mitchell & P. Ó Snodaigh, Irish Political Documents 1869–1916 (Dublin 1989).
50. Gordon Lucy, (ed.). The Ulster covenant: a pictorial history of the 1912 Home Rule crisis. Belfast: Ulster Society, 1989.
51. B. M. Walker. Ulster politics: the formative years, 1868–1886. Belfast, 1990.
52. Alan O'Day. 'Home rule and the historians'. In: David George Boyce; Alan O'Day, (eds.), The making of modern Irish history: revisionism and the revisionist controversy (London and New York: Routledge, 1996).
53. Michael Foy. 'Ulster Unionist propaganda against Home Rule 1912–14'. History Ireland, 4:1 (1996).
54. Derry Kelleher, Home rule as Rome rule: the unspoken unionist and loyalist case (Justice Books, 7). Greystones, County Wicklow: Justice Books, 1997.
55. Margaret O'Callaghan, 'Franchise reform, "first past the post" and the strange case of Unionist Ireland'. Parliamentary History, 16 (1997), 85–106. Publisher: Sutton; Edinburgh University Press.
56. Jeremy Smith. Britain and Ireland: from home rule to independence (Seminar Studies in History). Harlow: Longman, 2000
57. Carla King. 'Defenders of the union: Sir Horace Plunkett'. In Boyce, D. George; O'Day, Alan (ed.), Defenders of the union: a survey of British and Irish unionism since 1801 (London and New York: Routledge, 2001),
58. Gary Peatling. British opinion and Irish self-government, 1865–1925: from unionism to liberal Commonwealth. 2001.
59. Alan Megahey, '"God will defend the right": the protestant churches and opposition to home rule'. In Boyce, D. George; O'Day, Alan (ed.), Defenders of the union: a survey of British and Irish unionism since 1801 (London and New York: Routledge, 2001).
60. David Fitzpatrick, 'The Orange Order and the border'. Irish Historical Studies, 33:129 (2002), 52–67.
61. Brian Girvin, From union to union: nationalism, democracy and religion in Ireland – Act of Union to EU. Dublin: Gill & Macmillan, 2002.
62. Thomas C. Kennedy, 'Tory radicalism and the Home Rule crisis, 1910–1914: the case of Lord Willoughby de Broke'. Canadian Journal of History, 37:1 (2002), 23–39.
63. David George Boyce, 'Ireland and British politics, 1900–1939'. In Wrigley, Christopher John (ed.), A companion to early twentieth-century Britain (Blackwell Companions to British History) (Oxford: Blackwell Publishers, 2003), 102–17.
64. Catriona Burness, 'Strange associations': the Irish question and the making of Scottish unionism, 1886–1918. East Linton: Tuckwell, 2003.
65. Dan Jackson, '"Friends of the Union": Liverpool, Ulster, and Home Rule 1910–1914'. Transactions of the Historic Society of Lancashire & Cheshire, 152 (2003), 101–32. Publisher: Historic Society of Lancashire and Cheshire.
**The edition used in the digital edition**2. The case for Home Rule, stated by Stephen Gwynn with an Introduction by John E. Redmond. Stephen Gwynn (ed), first edition [xii + 160 pp.] Maunsel & Company Ltd.Dublin (1912)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


This electronic edition comprises pp i–ix of the Preface and 3–152, omitting the Table of Contents on xi–xii and the Index on 153–160.


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed using TEI-Emacs.


##### Normalization


the electronic text represents the edited text. Italicized sections of the text are tagged emph.


##### Quotation


Direct speech is tagged q. Quotations from written sources are tagged qt and included in cit tags, which may also contain a bibl element. 


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the whole text, div1=the section, div2=the chapter, div3=the subsection. Chapters are numbered; page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Names are not tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: by Stephen Gwynn

 (c.1911) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [FR] Some words are in French.


##### Language: [LA] A word in Latin.


### Revision History


* (2011-08-01) Beatrix Färber (ed.)

* Conversion script run; header updated; new wordcount made; file parsed.
* (2007-12-10) Beatrix Färber (ed.)

* Typos corrected, new SGML and HTML versions created.
* (2006-05-02) Beatrix Färber (ed.)

* Final checks made; file re-parsed.
* (2006-04-04) Emer Purcell (ed.)

* Second proofing of file; tables typed in or marked up; more content markup added.
* (2006-04-03) Beatrix Färber (ed.)

* Tables typed in or marked up; file re-parsed.
* (2006-03-24) Beatrix Färber (ed.)

* File checked and parsed; more proofing; header modified; additions to bibliography made.
* (2006-02) Benjamin Hazard (ed.)

* File converted to XML.
* (2005-12) Aoife O'Brien (ed.)

* Provisional header inserted, bibliography compiled.
* (2005-11-17) Aoife O'Brien (ed.)

* Text proofed (1), structural markup added.
* (2005-11-10) Aoife O'Brien (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E900030


### The Case for Home Rule: Author: Stephen Gwynn




---

p.v


### Preface


This book has been compiled at my request to put together the main arguments against continuance of the present system under which Ireland is governed, and in support of the demand for Home Rule.


The demand for Home Rule means no less and no more than this: Ireland asks for an Irish Parliament, with an executive responsible to it, to deal with purely Irish affairs, subject to Imperial supremacy.


In other words, we ask that laws relating to Ireland alone shall be made by a popularly elected assembly sitting in Ireland, having leisure to deal with the necessities of the case, and possessing first-hand knowledge of them: and that responsibility for the administration of Ireland shall be confided to a Ministry chosen by Ireland, and going out of office when Irish public sentiment demands a change.


Surely this is a common-sense proposal.


What maintenance of the present system means is this: That laws relating to Ireland shall be made by a Parliament, five-sixths of whose members have no knowledge of Ireland's special circumstances, and which, even if Irish affairs were removed from its control, would still be hopelessly overburdened with work.


That Ireland shall be administered in all its departments by one Member of an English Ministry, which may be brought in or thrown out against the wish of four-fifths, of Irishmen.


That the same laws, the same scale and method of taxation shall apply to Great Britain, a country enormously wealthy, crowded with a population, four-fifths of it urban and industrial, and to Ireland, poor, under-peopled, almost entirely agricultural.




---

p.vi


Surely this is contrary to common sense.


That under the name of Union one country shall be administered by a dozen ministers, each with his Parliamentary subordinate, while in the other the Chief Secretary shall exercise at once the functions of the Home Secretary, of the Minister for Education, of the Minister for Agriculture, of the Minister for Public Works, of the President of the Local Government Board. That, in fact, all the offices which a series of Englishmen, Welshmen, and Scotchmen perform for Great Britain shall be united for Ireland in the person of one Minister, who may be Scotch, Welsh, or English, but never Irish, and whom Ireland has no voice in selecting.


Surely this also is contrary to common sense.


All these things are certainly contrary to the usage of the British Empire.


In every other part of the King's dominions local autonomy is given, local patriotism is encouraged.


Can it be argued that the government of Ireland by England has been so successful as to justify a departure from this principle?



That is the question which is dealt with in the first part of this book. And if in answering the question what is England's record in Ireland, bitter memories are revived, that is in no wish to perpetuate bitterness.


We desire merely to bring English opinion face to face with the facts. England's record of honour, her record of service to freedom is rich and ample; but it lies elsewhere. We ask her to bring her policy in Ireland into conformity with her own record.


To-day Mr. Gladstone's name stands far otherwise than as it did in 1886; it is lifted above the vulgarities and belittlements of Party controversy; and to-day Mr. Gladstone's utterance on this matter may be heard as it merits. This is what he said in concluding his speech for his first Home Rule Bill:

‘Ireland stands at your bar, expectant, hopeful, almost





---

p.vii




suppliant. Her words are the words of truth, and soberness. She asks a blessed oblivion of the past, and in that oblivion our interest is deeper than even hers. My right hon. friend (Mr. Goschen) asks us to-night to abide by the traditions of which we are the heirs. What traditions? By the Irish traditions? Go into the length and breadth of the world, ransack the literature of all countries, find, if you can, a single voice, a single book-find, I would almost say, as much as a single newspaper article, unless the product of the day, in which the conduct of England towards Ireland is anywhere treated except with profound and bitter condemnation. Are these the traditions by which we are exhorted to stand? No, they are a sad exception to the glory of our country. They are a broad and black blot upon the page of its history, and what we want to do is to stand by the traditions in which we are the heirs in all matters except our relations to Ireland, and to make our relations to Ireland conform to the other traditions of our country. So I hail the demand of Ireland for what I call a blessed oblivion of the past. She asks also a boon for the future; and that boon, for the future, unless we are much mistaken, will be a boon to us in respect of honour no less than a boon to her in respect of happiness, prosperity, and peace. Such, sir, is her prayer. Think, I beseech you—think well, think wisely, think not for a moment but for the years that are to come, before you reject this Bill.’


These words of a great Statesman surely deserve to be weighed. The main argument against Home Rule is that Irishmen are disaffected and disloyal. Englishmen should ask themselves, as reasonable sons of liberty, whether such government as England has meted out to Ireland could produce loyalty; whether any nation but a nation of slaves could feel any sentiment but disaffection to such a rule.


Those who read these pages will find it clearly set out that attempt after attempt was made by England to 





---

p.viii




exterminate the Irish race. Is that the way to win loyalty? And although the actual proscriptions ceased long ago it is not too much to say that within living memory a view was widely held that the fewer Irishmen remained in Ireland the better it was for England. In the terrible exodus which followed the famine the Times could exclaim gleefully:—‘The Celts are going with a vengeance!’


We ask for redress; but the redress we ask for is only liberty to attempt by our own resources to cure our own diseases, to cope with our own problems. This Imperial Government is not fitted for the task. Lord Morley said finely the other day that Ireland had suffered as much from an absentee Parliament as from absentee landlords. The complaint is no new one. The Earl of Kildare wrote to Cardinal Wolsey:—‘You hear of a case as it were in a dream, and feel not the smart that vexeth us.’ We ask, as the Earl of Kildare asked, for a Government more closely in touch with, more quickly responsive to the needs of Ireland.


What we mean by Home Rule is the continuous government of Ireland according to Irish ideas carried out by Irish Ministers responsible to the Irish people—servants of the Crown, but not holding office at the will of a Parliament in Westminster.


This would constitute an entirely new departure, although it would be an act of restitution. Ireland had a Parliament, of antiquity almost as great as that of England, and possessing larger powers than are claimed under Home Rule. Yet it was far less democratic, far less representative than what we ask for, because it was based on a principle of religious exclusiveness, and because its Ministry was not responsible to its vote.


Still, under that Parliament in the brief years when it exercised real power, Ireland prospered and grew strong. It was because Ireland grew strong that Pitt and his Ministry decreed the extinction of her Parliament.




---

p.ix


It is fair to say that in Pitt's time statesmanship had scarcely reached to the conception of reconciling local autonomy with the Imperial idea. Englishmen of to-day have not that excuse, and the opposition comes only from England, Scotland, Wales, and all the oversea Dominions are united in the proposal to extend to Ireland the principles of Self-Government within the Empire. Even in England the majority against Home Rule is the bare majority of a baker's dozen of seats—it has been dwindling with extraordinary rapidity, as men have grown familiar with the idea.


The arguments that are employed now to confirm opposition to Home Rule are dealt with in the second part of this book, and I believe that candid examination will show them to be arguments of prejudice, not of reasoned belief.


What lies at the root of this whole controversy is a feeling in the ‘predominant partner’ that to concede Ireland's demand would be to accept defeat; that justice cannot be done now without admitting injustice in the past, and that Ireland's victory must be England's humiliation.


Such an attitude of mind is natural enough after a struggle so long protracted: yet it is unworthy of a great country. In such a matter statesmanship and generosity go hand in hand. That has been proven in South Africa. Ireland remains to confirm that noble example.


J. E. Redmond.


---

p.x




---

p.xi




---

p.1


PART I: Is England fit to govern Ireland? A Historical Review
-------------------------------------------------------------




---

p.2




---

p.3


### Chapter I

### Why is Home Rule withheld from Ireland?


#### What Democracy means


It is always more difficult to combat a prejudice than an argument, and English opposition to Home Rule for Ireland rests upon a deeply-seated prejudice. Yet it is easily shown that this prejudice is inconsistent with the leading political principles of the English race.


Englishmen advocate, generally, the principle of Liberty, and by Liberty they mean democracy, and they mean self-government.—Take, as example, Mr. Balfour, who said, in the great debate on Women's Suffrage in the House of Commons in July, 1910:— ‘A democracy, properly speaking, is government by consent,’ and went on to classify himself among those who believe that ‘Democracy, properly understood, is the only possible government for any nation at the stage of political evolution which we have reached.’ Yet surely Mr. Balfour would be the last to assert that the government of Ireland has the consent of the governed.—Take, again; the general indignation expressed by Englishmen of all parties when Russian autocracy suppressed the free institutions of Finland.


Nor is this only a matter of opinion or sentiment with the British people. It is their chief boast, and their chief glory, that they have learnt to reconcile Empire with Liberty. The Times wrote, in a leading article of April, 5th 1909, which was headed Local Patriotism and the Imperial Idea, and was a comment on the results which 





---

p.4




had been attained in South Africa by the concession of self-government:—

 


> 
> ‘The Imperial idea, despite the historic associations of its name, must prove its title to acceptance, not as a limitation but as a guarantee of local autonomy and local rights.   
> [*...*]  
>  Imperial thought aims at drawing closer the bonds of union between the nations of the Empire, not in any limitation of individual autonomy but as the only means by which the development of each on its own lines can be secured.   
> [*...*]  
>  Imperialism is not the enemy of those narrower and more intimate loyalties which bind each nationality within the Empire to its own way of life.’
> 
> 
> 




In other words—Home Rule is the rule of the British Empire. The one exception to this principle is found in Ireland. The argument for Home Rule as a sound, practical policy is of two kinds—positive and negative. The grant of local autonomy, wherever it has been made, has been followed by prosperity, contentment, and loyalty. That is the positive side of the argument. The negative side is seen in Ireland, where poverty, discontent, and disaffection have been consequences of denying Home Rule.


#### Ireland ‘unfit for Self-Government’


If Englishmen are asked for an answer to these arguments—for a reason why that principle of self-government, which they believe in, should not be applied to Ireland, their answer always is, in effect, That Ireland is unfit for self-government. They may say, and they sometimes do say, that to give Home Rule will be a danger to England, but if they are pressed to answer—Do you then mean that you deny to Ireland the form of government best suited to her needs because you are afraid of Ireland? they will reply that Home Rule would be an injury and not an advantage to Ireland. And they will justify this view by asserting the special incapacity of Irishmen to undertake the task.




---

p.5


Now, without the least wish to be discourteous or quarrelsome, we are forced, by way of rejoinder, to ask:—


#### Is England fit to govern Ireland?


What is the record of English government in Ireland?—If it be said that Ireland is not fit to govern herself, what is the proof that England is fit to govern Ireland? In an ordinary way, people are likely to be the best judges of their own affairs; can it be shown that the refusal to apply this principle to Ireland has been attended with special success?


#### Ireland's Claim of Right


It must not be supposed that the demand for Home Rule rests on this question of expediency. Sir Henry Campbell-Bannerman asserted, and every Irish Nationalist echoes his assertion, that ‘Good government is no substitute for self-government’; that even if a country were prospering under foreign rule, its honour and its dignity should force it to demand the privilege of freedom, which is the right to manage its own affairs. The demand for Home Rule in Ireland rests primarily on that ground. Self-government is claimed, first, as a natural right, and, secondly, by historic legal title, as a right which Ireland enjoyed, which was ratified to Ireland by a solemn declaration of the British Parliament, and which was filched from Ireland by a most corrupt and shameful transaction, to which Ireland never consented, and against which, for more than a century, Ireland has protested by every means in her power.


But setting aside all these claims of right, the question shall be argued as far as possible from the British point of view, which regards the matter as one of expediency. Has the present system, or any system employed by England, justified itself? It is to that end, and not with any desire to renew painful memories, that, before considering the problems of to-day, some attempt must be made to discern their causes.


In order to examine the question of England's fitness 





---

p.6




to govern Ireland, it is necessary to pass in review, briefly, the history of English rule in Ireland.


The name ‘England’ is here deliberately used, because, in Scotland and Wales, the majorities in favour of Home Rule for Ireland are as decisive and almost as steady as in Ireland itself, while the unanimous opinion of statesmen in the Over-sea Dominions has been publicly expressed, without regard for party, in favour of granting self-government to Ireland—that one separate part of the British Dominions, inhabited by white men, which at present does not manage its own local affairs.


#### How gas England governed Ireland?


Before entering on the review the history of British rule in Ireland may be briefly summarised.—Ireland was first treated as territory to be exploited in the interests of Great Britain. The native race were regarded as an element to be got rid of. Every effort was made to prevent their fusion with the settlers. Vast confiscations were made. Wars of extermination were undertaken again and again.


This policy may be said to have lasted up to the battle of the Boyne and final conquest under William III. and James II.


During the eighteenth century no attempt was made to kill out the Irish. The country was regarded as containing two castes, divided from each other by religion. One form of religion, that of a small minority, was highly privileged. That of the majority was cruelly proscribed. As against the Catholic Irish, who were mainly of the native race, the interest of the Protestant Irish was protected. But as against the interests of England, the interests of any class in Ireland, or of all Ireland, were deliberately sacrificed.


The governing principle of this period was to keep Ireland weak, by maintaining religious dissensions and by repressing Irish enterprise and industry.


In 1782, when the Irish Parliament gained its freedom, England still nominated the ministry, and that ministry pursued unswervingly the interest of England, and finally engineered the Union.




---

p.7


Up to this point, not the most partisan historian can affirm that England governed Ireland even tolerably.


Since 1800 the interests of Ireland have been committed to the care of the Imperial Parliament.


For half a century it cannot be said that Parliament made any attempt to consider Irish interests or Irish opinion. Then the appalling disaster of the great famine did something to awaken public conscience. Yet till 1870 no remedial legislation of any importance was undertaken. From that date frequent efforts have been made, often with the most honest intention, to promote the welfare of Ireland. Parliament has repeatedly given to Ireland the kind of legislation which England thought good for her.


#### Government according to English Ideas


The experiment of governing Ireland from Westminster, even with the best intentions, proved to be a pitiful failure. England was unfit to govern Ireland, by temperament, by tradition, and by equipment. She was legislating for a country which she did not know and with which she had no natural sympathy.


In 1902, Lord Dudley, the last Tory Viceroy, and one of the very few who has left a kind remembrance in Ireland, made a speech at Belfast in which he declared that the time had come when ‘Ireland ought to be governed according to Irish ideas.’


#### Lord Dudley's Heresy


It had taken six centuries and a quarter before a spokesman of the Tory Party in England could be brought to admit that Irish ideas were the ideas according to which Ireland should be governed; and yet the Tory Party was not convinced of this proposition. Three years later Mr. Walter Long came over as Chief Secretary under the same Government, to reverse the policy of which Lord Dudley was the exponent. He was perfectly explicit in denying the principle that Ireland should be governed according to Irish ideas.




---

p.8


This reversal of policy illustrates very well the disastrous see-saw, alternating between concession and coercion, which would have demoralised any country, and which has inflicted grave injury on Irish political life. It illustrates it all the better because this see-saw took place under a period of unbroken Tory administration. But the essential point to note is this:—Mr. Long spoke too late. The Administration, of which Lord Dudley was the head, had conceded the main point for which ‘Irish ideas’ had been contending ever since the English landed in Ireland. Mr. Wyndham's Act of 1903 established by law the principle that land in Ireland should be owned by those who occupied and worked it: that the soil of Ireland should belong to the Irish people.


The history of English rule in Ireland may be briefly exemplified in relation to land. When the English came first to Ireland their object was to take Irish land from Irish tribes and to give it to English nobles to deal with at their pleasure. Met by the difficulty of separating the Irish people from the land, they tried the expedients of killing the Irish people out altogether; of exporting them into slavery; later, of penning them into the uncultivable parts of the country; and, finally, of reducing them to a state of serfdom, under cover of religious disability. The end of the struggle was that the Irish recovered, first, the free exercise of their religion, and then the ownership of their land. But the struggle, prolonged over centuries, was disastrous to Ireland, and to England as well. The struggle is not completed, nor can it be, until the Irish have gained the full management of their own affairs; until Ireland is governed according to Irish ideas by Irishmen chosen by the Irish people in Ireland.




---

p.9


### Chapter II

### Detailed Review of English Rule in Ireland


We shall now give in somewhat more detailed form a review of these facts, based largely upon an article contributed to the British Empire Review by Sir Charles Bruce, who has been Governor of several British Colonies, who holds the Grand Cross of St. Michael and St. George, and who may be presumed to be a loyal citizen.


But, first, let it be remarked that conquest is not necessarily a disaster to the conquered. England probably gained in civilisation by the Norman Conquest. The case was very different in Ireland. Sir Charles Bruce gives the reason:—

 

‘In 1172 Henry, supported by a Bull of Pope Adrian IV., the only Englishman who ever occupied the papal chair, assumed the title of King of Ireland and consolidated his dominions by an organised system of expropriation of the Irish and re-settlement by large grants made to Norman barons. This was the origin of the land question in Ireland and of a policy designed to solve it by rooting out the Irish from the soil, confiscating the property of the septs, and planting the country with English tenants. Had Ireland been left to itself, the Norman invasion would probably have followed the course of the Norman invasion of England, and resulted in an Anglo-Irish union consolidated by intermarriage. But every step towards such a union was met by enactments of the English Government prohibiting the adoption by English settlers of Irish customs and the Irish language, while intermarriage was punished by mutilation and death.’




---

p.10


#### Fostering Divisions


Yet the tendency of nature towards union between the races was stronger than the laws which aimed at keeping them apart. These Norman barons, the Geraldines, the Burkes, and the rest, became, as was said, ‘more Irish than the Irish themselves.’ They established, in the reign of Edward I., an Irish, or Norman-Irish, Parliament. By the reign of Edward I., 1316, Irish chiefs, like the O'Briens and the O'Tooles, were attending this Parliament; but all the influence of England was used still to keep the races apart. In 1367, under Edward III., the Statute of Kilkenny prohibited, under the penalties of high treason, use of the Irish language and dress, or intermarriage with the Irish. As for the Irish themselves, they were outside the law. The King of England claimed to be King of Ireland, but it was no felony to kill one of his native Irish subjects, even if dwelling in a part of the country which was directly under English rule.


#### Irish Ideas


Gradually, however, the government of Ireland tended to become more and more in accordance with Irish ideas. Under Henry VI. the Irish Parliament formally declared its right to be bound only by its own laws. The ties between the Norman nobles and the Irish nobles were constantly strengthening: still more strongly were these Norman chiefs affected by the principles of Irish law.


The fundamental point of Irish law was that the land which the tribe occupied belonged to the people of the tribe: the King, or chief, had only his own portion. In the frequent wars between tribe and tribe cattle might be driven off, crops might be destroyed, but no one ever thought of separating the land and the people.


The English theory of government was that all land belonged to the King, that it was all held by grant from him; that the occupiers and the tillers of the soil were there simply by grace of the King, or by grace of the man to whom he granted the land. When, therefore, the 





---

p.11




King declared the estates of a Norman noble or an Irish chief forfeit, he seized the territory which, according to Irish ideas, belonged not to the offender—the chief who had rebelled—but to the people on the land.


Up to about A.D. 1500, Irish ideas were gaining ground, and the Norman nobles, speaking Irish, having in their castles Irish lawyers and Irish bards, accepted the Irish code of law. During the same period, what was called the English Pale contracted itself to a district of about thirty miles round Dublin. Within that limited area English law prevailed; outside it Normans and Irish lived under Irish law—the Normans recognising English sovereignty. This was a period, upon the whole, of real prosperity for Ireland; the country was filled with great buildings; castles, abbeys, and churches, whose ruins only remain to bear evidence of what has been destroyed.


#### The Period of Confiscations


In 1495 began the second phase of the English conquest. Henry VII. sent over a strong force, under the Lord Deputy Poynings, and caused an Act to be passed at a Parliament at Drogheda, which declared that all Acts passed by the English Parliament should be binding in Ireland, and that no Acts should be passed by the Irish Parliament without the consent of the English Privy Council. Under Henry VIII. the period of great confiscations may be said to have begun. In 1536 the Earl of Kildare, head of the great Geraldine House, was attainted for treason, and all his lands were declared forfeit to the Crown. Another Act of the same year declared that all lands which had been granted to Normans, and which had reverted to Irish owners by reconquest or otherwise, should now belong to the Crown. In 1537, the lands of the monasteries were forfeited to the Crown. Mrs. J. R. Green writes:—

 

 ‘These laws and confiscations gave to the new sovereigns of the Irish the particular advantage that if their subjects should resist the taking of the land, they were legally rebels, and as such outside the laws of war. It was this 





---

p.12




new fiction of law that gave the Tudor wars their unsurpassed horror. Thus began what Bacon called ‘the wild chase on the wild Irishmen.’ The forfeiture of land of the tribe for the crime of a chief was inconceivable in Irish law; the claim of the commonalty to unalterable possession of their soil was deeply engraven in the hearts of the people, who stood together to hold their land, believing justice and law to be on their side, and the right of near two thousand years of ordered possession. At a prodigious price, at inconceivable cost of human woe, the purging of the soil from the Irish race was begun. Such mitigations as the horrors of war allow were forbidden to these ‘rebels’ by legal fiction. Torturers and hangmen went out with the soldiers. There was no protection for any soul; the old, the sick, infants, women, scholars, anyone of them might be a landholder, or a carrier on of the tradition of the tribal owners, and was in any case a rebel appointed to death. No quarter was allowed, no faith kept, and no truce given. Chiefs were made to ‘draw and carry,’ to abase them before the tribes. Poets and historians were slaughtered, and their books and genealogies burned, so that no man ‘might know his own grandfather,’ and all Irishmen be confounded in the same ignorance and abasement, all glories gone, and all rights lost. The great object of the Government was to destroy the whole tradition, wipe out the Gaelic memories, and begin a new English life.’—(Irish Nationality, page 130.)


Sir Charles Bruce says:—

 ‘Mr. Lecky has observed that Burke gives the real clue to Irish history from this period in asserting that the genius and policy of the English Government were directed to the total extirpation of the interests of the natives in their own soil. That this was the original scheme, and that it was never departed from for a single hour during the whole reign of Queen Elizabeth.’


#### The Wars of Extermination


A new feature had been added to the process by the Reformation. In 1560 the Protestant religion was by law established. Mr. Lecky has said:— ‘In Ireland the old Faith marked the division between the 





---

p.13




two races. It was the symbol of the National spirit; it was upheld by all the passions of a great patriotic struggle, and its continuance simply attests the vitality of a political sentiment. When every other Northern nation abandoned Catholicism, the Irish still retained it, out of antipathy to their oppressors.’


#### Protestantism and Freedom


Herein lies a deep cause of mutual misunderstanding between England and Ireland. To England, the idea of Protestantism was associated with resistance to foreign conquest and domestic oppression—to the menace of the Armada, the misgovernment of the Stuarts. For Ireland, the case is reversed. The noblest thing they knew was fidelity to the persecuted Catholic religion. The basest thing they knew was the action of those Irishmen who changed their religion not merely to save their own land: but to get their neighbour's.


Protestantism came to Ireland as the religion of the oppressor. The Catholic's fidelity to his belief was used as a new plea for confiscation, even for actual extermination. Lord Grey de Wilton, Lord Deputy of Elizabeth, declared, says Sir Charles Bruce, that the only way to deal with Ireland was "by a Mahometan conquest"—that is to say, by slaughtering all those Irish who refused to conform. It is notable that Edmund Spenser, who lived and worked in Ireland, selects this Lord Grey as his type of Justice in The Faerie Queene.


In truth, Lord Grey pleaded religion as the excuse for trying to destroy a whole race.


#### Killing out the Irish


The experiment was tried most conscientiously. Mr.Froude says, speaking of the operations in Munster of Sir Waiter Raleigh:—

 ‘The entire province was utterly depopulated. Hecatombs of helpless creatures, the aged and the sick and the blind, the young mother and the babe at the breast had fallen under the English sword; and though the authentic details of the struggle have been forgotten, the memory of a vague horror remains imprinted in the national traditions.’





---

p.14




Famine was brought in to supplement the sword. Charles Bruce says:—



 ‘In 1582 Sir Warham Sentleger informed Queen Elizabeth that his friends had starved to death 30,000 in six months in the province of Munster by destroying the crops.’


In the North of Ireland a stronger resistance was offered, but Elizabeth succeeded, first, in procuring the assassination of Shane O'Neill, a most powerful opponent, and afterwards, at the end of a desperate war, in defeating the combined forces of Hugh O'Neill and Hugh O'Donnell at Kinsale. But the victory was not complete. O'Donnell went to Spain to seek for assistance. He was poisoned there by an agent of the English Government, whose account of the affair is in the State Papers. O'Neill made his submission, but early in the reign of James I. proceedings were instituted against him and against O'Donnell's successor. Both earls fled, and under James was carried out the plantation of Ulster.


#### Policy of Plantation


This was a new type of conquest; it was not merely the transference of ownership from Irish chiefs to English nobles, but it meant the driving out of Irish peasant farmers and the substitution of Scotch or English settlers—small men, who would actually themselves farm the land. Mrs. Green says:—

 

 ‘Henry VIII. had found Ireland a land of Irish civilisation and law, with a people living by tribal tenure, and two races drawing together to form a new self-governing nation. A hundred years later, when Elizabeth and James I. had completed his work, all the great leaders, Anglo-Irish and Irish, had disappeared, the people had been half exterminated, alien and hostile planters set in their place, tribal tenure obliterated, every trace of Irish law swept clean from the Irish statute-book, and an English form of State government effectively established.’—(Irish Nationality.)




---

p.15


#### 1641 and Cromwell


There followed in the reign of Charles I. the English Civil War. In 1641 the native Irish rose in Ulster and dispossessed those to whom the lands of their fathers had been given in the reign of James I. This rising was an attempt to reverse wholesale confiscations carried out in a period no more remote than that which divides us from Mr. Gladstone's land laws. There was no general plan of massacre, but undoubtedly the Protestant settlers suffered great hardships, for which terrible reprisals were made. War raged throughout the whole country until Cromwell came and crushed out resistance. The massacres of Drogheda and Wexford are indelible stains on his memory—yet a deeper disgrace attaches to his policy of exporting the captured Irish, men, women, and children, into slavery in the West Indies. Cromwell did not, however, attempt to kill out all the native Irish. He only decreed that none of them should be allowed to remain in Ulster, Leinster, or in Munster except the County of Clare. The whole Catholic population was driven across the Shannon, and herded together in the bogs and mountains of Connaught. After the Restoration, under Charles II. a Protestant Parliament practically acquiesced in all the arrangements made by Cromwell, although the Irish had gone to war in support of Charles's father.


Before the Civil War, the native Irish owned ten acres to one held by settlers (even after the Ulster plantations), and two-thirds of the good land. After Cromwell's confiscations and the Act of Settlement, strangers owned four-fifths of the whole country, and more than two-thirds of the good land.


#### An Irish Catholic Parliament


Under James II. an Irish Parliament was established which was almost entirely Catholic.


Catholics in Ireland had been subjected to almost every imaginable form of persecution for a century and a half.





---

p.16




It is notable, therefore, that their first act was to pass a law establishing liberty of conscience for all denominations. They did, however, by an Act of attainder, propose to take away from some two thousand persons the property which had been settled upon them in the Cromwellian confiscations.


#### The Period of Enserfment


The power of this Parliament was brief, and in 1690 the battle of the Boyne marked the final triumph of the settlers in Ireland. Yet the war did not end with the Boyne; and at the famous siege of Limerick a treaty was made guaranteeing to Irish Catholics, in return for submission, the free exercise of their religion. That treaty was shamefully broken. The Irish Catholics who, in their Parliament, had established freedom for all religions, were first declared incapable of sitting in Parliament, then of voting for a member of Parliament. They were declared incapable of acquiring landed property or of holding a lease longer than thirty years; they were forbidden, on the heaviest penalties, to keep a school; they were forbidden to send their children to be educated abroad; they were debarred from all the liberal professions, except medicine. Briefly, says Hallam, ‘they suffered a system of oppression under a series of laws which have scarcely a parallel in European history.’

 Burke has said of this penal code:—



 ‘It was a machine of wise and elaborate contrivance as well fitted for the oppression, impoverishment, and degradation of a people, and the debasement in them of human nature itself, as ever proceeded from the perverted ingenuity of man.’


#### British Rule up to 1690


Interrupting this review for a moment, it may be asked What are the tests of good government.—That it should give security to the governed? The government of Ireland by England began by refusing to recognise in the native





---

p.17




Irish any rights at all before the law.—That it should hold the balance evenly between the various types of conscientious belief? The Government of England attempted to enforce the religion of a small and alien minority by every conceivable penalty; it used religion as a cloak for spoliation; it deliberately maintained religious differences as a symbol of racial division.—That it should temper justice with mercy? The English people may be said to have aimed at the complete extirpation of the native race.

Sir Charles Bruce writes:—

‘The history of the English in Ireland for seven hundred years has confirmed the truth of the proposition that in the treatment of the native population in conquered territories there are only two possible policies—extermination or amalgamation. The policy of extermination having failed, it falls to consider what has been done and what remains to be done to substitute a policy of amalgamation.’


The first fact, then, about England's proved fitness or unfitness to govern Ireland is that England attempted to exterminate the native Irish and failed. It remains to be seen how, after this failure, she dealt with Ireland when Ireland was a country completely subject to British rule.




---

p.18


### Chapter III

### Period of the Penal Laws

#### The Suppression of Irish Industries


In the eighteenth century Ireland was owned virtually by the Protestant minority, nine-tenths of whom probably belonged to the settlers. But the Catholics, having been driven out of the ownership of land, threw themselves with great zeal into trade, and Ireland, having at last a period of peace, after a century and a half of devastating war, began to build up industries. This was seen with grudging eyes by English merchants, who appealed to the English Parliament to check such competition; and Parliament promptly crushed the growing trades.


#### Cattle Trade


By the Cattle Acts of 1665 and 1680 the importation into England, from Ireland, of all cattle, sheep, swine, beef, pork, bacon, mutton, or cheese was prohibited. The immediate result of these Acts was to restrict the trade with England, and to stimulate trade with foreign countries and with the English plantations, and to increase Irish shipping. In 1680 we read that for the last five years there were seldom less than twenty Irish ships at Dunkirk, laden with beef, mutton, tallow, hides, leather, and wool. Irish ships were also seen at Ostend, Naples, and La Rochelle, and in the French West Indies. The trade of these places with England herself fell off.[1](javascript:footNote('E900030/note001.html')) But Ireland was not long suffered to enjoy this provision trade

 



---

p.19




in peace. By a long series of Navigation Acts commerce was, as completely as the laws could effect their purpose, destroyed. ‘The conveniency of ports and harbours which nature bestowed so liberally upon this kingdom,’ wrote Swift, ‘is of no more use to us than to a man shut up in a dungeon.’


#### Woollen Trade


Forbidden to export cattle, Irishmen now turned their attention to wool, which had long been the staple of their internal trade. 

*The quality of the wool, [says Mr. Lecky,] was supremely good. A real industrial enthusiasm had arisen in the nation. Great numbers of English, Scotch, and even foreign manufacturers came over. Many thousands of men were employed in the trade, and all the signs of a great rising industry were visible.’’*

 History of Ireland. . Vol 1., Ch. xi, p 75.





 It was not to be. The English House of Commons petitioned William III. to discourage the woollen manufacture, and in 1699 the export from Ireland of manufactured wool to any country whatsoever was absolutely prohibited, and that of raw wool except to England.


*So ended, [continues Mr. Lecky,] the fairest promise Ireland had ever known of becoming a prosperous and happy country. The ruin was absolute and final.’’*

 History of Ireland. . Vol 1., Ch.xi, p 75.


#### Linen


Some half-hearted attempts were, indeed, made to replace the woollen by the linen industry. As early as 1672 the Irish Parliament had voted a sum of money to be applied for the encouragement of the manufacture of fine linen; and from the fourth year of Anne to the nineteenth of George II., passed no less than fourteen Acts for the encouragement of the industry. But even this trade, though confined to Ulster, and long conducted upon a very small scale indeed, was not allowed to remain unhindered. Fierce opposition arose in England when it was proposed (in 1708) to extend the manufacture to Leinster. It was feared that if Irish linen should replace Dutch linen 





---

p.20




in England, the Dutch might no longer care to admit English woollens into Holland. Prohibitive duties were laid on Irish linens, checked, striped, painted, or dyed, when imported into Great Britain.


So one might go on through the whole range of Irish industries. Every avenue for trade was deliberately blocked. Lecky writes:—‘It became evident that England possessed both the will and the power to crush every

form of Irish industry as soon as it became sufficiently prosperous to compete in any degree with her own manufacture. It appeared useless to persist, and a general commercial despondency prevailed.’ Thousands of

manufacturers emigrated to America or to the Continent. The masses of the people, denied other employment, were driven back upon the land, by their frantic competition for this, the only means by which to live, raising rents and increasing the poverty of all save a few.


These restrictions were aimed, not at Irish Catholics or at the native Irish: they were part of the government of Ireland according to English ideas. This meant the sacrificing of every Irish interest that could possibly compete with an English one. Lecky says in his History of Ireland:— 

‘Protestants then began to find that they were as little thought of as the Catholics. The suppression of the woollen trade brought ruin upon twelve thousand Protestant families in Dublin, and thirty thousand in the rest of the country. By her commercial laws England deliberately crushed the prosperity of the Protestant colony of Ireland, drove thousands of them into exile, arrested the influx of Protestant population from Great Britain, and inspired the Presbyterians of the North with a bitter hatred of her rule.’


#### Liberality of the Irish Protestants


So indiscriminating was the oppression that it began to bring Protestant and Catholic together in Ireland in defence of their common interest. This was foreseen and deplored by the English Government. Archbishop Boulter—one of the chief agents of the government of Ireland—wrote:7ndash;‘When Protestant and Papist unite,





---

p.21




goodbye to the English interest in Ireland.’ Yet, in spite of the English Government, Protestant and Papist did unite, and the Irish Parliament, representing solely the Irish Protestants, began to repeal the Penal Laws.


#### Penal Code relaxed


In 1778 the Catholics were given leave to hold landed property. In 1779 the joint action of the Catholics and Protestants secured free trade between England and Ireland. In 1781 Catholics were permitted to keep a school—if they could get leave from the Protestant Bishop of the diocese. This was not mere generosity, it was statesmanship. It was the beginning of the government of Ireland according to Irish ideas by Irishmen, who felt that Protestant and Catholic needed each other. Grattan said:—



 ‘So long as the Penal Code remains we can never be a great nation. I would not keep two millions of my fellow-countrymen in a state of slavery. I desire not a Protestant settlement, but an Irish nation.’


#### Grattan's Parliament


Political enfranchisement went hand in hand with the removal of religious disabilities. In 1782 the Irish Legislature was given sole power to make laws for Ireland. The first Act of the enfranchised Parliament was to repeal the Acts against hearing or celebrating Mass, and generally to sweep away the last restrictions of the Penal Code. Amongst its laws was one to legalise the marriages of Presbyterians, which the English Government had refused to recognise.—Judges were given security of tenure; the English Government had preferred to keep them subject to dismissal.


For, now an Irish Parliament was dealing with the Irish problem. It treated questions on their merits; it did not wait to be forced into concessions—as the English Government had been when it granted self-government under the armed menace of the Volunteers. The





---

p.22




English Parliament had for a hundred years denied to Roman Catholics practically all civil rights. The Irish Protestant Parliament, within ten years after its establishment, passed a law giving Roman Catholics the vote on a very liberal franchise. The next year saw all Catholics admitted to almost all civil and military offices. In 1795 a Bill to admit Catholics to Parliament was read for the first time. There is no manner of doubt that if the process of amalgamation had been allowed to go on, the Irish Protestant Parliament would have given full and equal rights to their Catholic fellow citizens, and that, in Ireland, which was then governed more or less according to Irish ideas, by Irishmen, living in Ireland, religious differences would have obliterated themselves. But once again England interfered to stop the process of amalgamation. Lord Fitzwilliam, the Viceroy, had gone over in 1795 to declare, like Lord Dudley, that Ireland should be governed according to Irish ideas, but the reaction set in too soon. The ‘loyal’ minority protested against this ‘betrayal’; and what a leading Ulster Unionist called, in 1904, the ‘wretched, rotten, sickening policy of conciliation’ was abandoned. Lord Fitzwilliam was recalled, and a loyal minority were given free encouragement to drive the majority into rebellion.


#### The Loyal Minority


This element of the ‘loyal minority’ has always existed, and has been the main cause of trouble between England and Ireland. In Elizabeth's day they were called specially the ‘People of the Pale,’ and they were those who deliberately encouraged the war between the races in the hope of profiting by confiscations. Even in Elizabeth's day certain rulers, notably Ormonde and Essex, showed a desire for conciliatory measures. The ‘People of the Pale’ secured their recall and impeachment. Sir John Perrott, one of the ablest among the Anglo-Irish nobles, wrote to Walsingham:—‘ There is no good meaning in the people of the Pale and Borderers towards the composition intended, or anything else that is good. They have overthrown the repeal of Poyning's





---

p.23




Act.’ In 1795 it was the people of the Pale—the ‘English garrison’—who set themselves against the peaceful policy of Fitzwilliam. Beresford, the leader of that faction, was mainly instrumental in securing Fitzwilliam's recall, as he was, in the two or three years that followed, foremost in the barbarities which goaded Ireland into insurrection; and, down to the present day, there has always been a faction in Ireland whose one remedy for Ireland's troubles has been the application of coercion whenever redress has been demanded.


Within five years after the recall of Fitzwilliam, the ‘loyal minority’ and the English Government between them had first goaded the subject race in Ireland into revolt (in. which many thousands of Protestants joined), and then, profiting by the demoralisation of the minority, had suppressed the liberties of the whole country. So we reach the Union. But before discussing it, let us recall in broad outline, first, what English government had done for Ireland in the period of the Penal Laws, and then what Ireland had done for herself in the brief era of partial freedom.




---

p.24


### Chapter IV


#### Opinions on the Period of the Penal Laws and on Grattan's Parliament


A marked feature of English government in Ireland has been the constant recurrence of famine. It was artificially produced by military means in the reign of Elizabeth.


In the eighteenth century it resulted, quite naturally, from the conditions that had been established. Again, I take some illustrative quotations, brought together by Mr. J. A. Fox in his book Why Ireland Wants Home Rule:— 


> 
> The Protestant Bishop Nicholson, an Englishman, in 1718 writes:—
> 
>  ‘Never did I behold even in Picardy, Westphalia, or Scotland, such
> 
>  dismal marks of hunger and want as appeared in the countenances of
> 
>  most of the poor creatures I met on the road.’ One of his horses,
> 
>  accidentally killed during his travels on an occasion, was surrounded
> 
>  by ‘fifty or sixty famished cottagers, struggling desperately to
> 
>  obtain a morsel of flesh for themselves and their children.’
> 
> 
> In 1727, Boulter, Protestant Archbishop of Armagh and Primate
> 
>  of Ireland, wrote to the Duke of Newcastle that since his arrival
> 
>  in that country the famine had not ceased among the poor people. The
> 
>  dearness of corn in the preceding year was such that thousands of
> 
>  families were obliged to quit their dwellings to seek means of life
> 
>  elsewhere; and ‘many hundreds perished.’
> 
> 
> Dr. Sheridan, in 1728, declares that ‘the poor are sunk to the lowest degree of misery and poverty—their houses 
> 
> 
> 
> 
> 
> ---
> 
> p.25
> 
> 
> 
> 
> dunghills, their food the blood of their cattle, or the herbs of the field.’—With reference to the expression, ‘their food the blood of their cattle,’ there is a curious Irish proverb. Kerry is one of the poorest of the Irish counties, and it was said, ‘Kerry cows know no Sundays,’ because that was the day the cattle were partly drained of their blood to give food to the peasants.
> 
> 
> In 1734 the Protestant Bishop of Cloyne, the reverend Berkeley, asked these questions in The Querist:(Q. 132.) ‘Is there on the face of the earth any Christian and civilised people so destitute of everything as the mass of the people of Ireland?’
> 
> 
> (Q. 173.) Can it be said that the quantities of beef, of butter, of wool, and of leather exported from this island are the superfluity of the country, when so great a number of the inhabitants are naked and starving?
> 
> 
> The year 1741 was called the ‘year of slaughter,’ of death and desolation. The cemeteries became too small for the burial of those who died on the roadside, or those whose bodies had to be sought for in their abandoned cabins. This, *the third famine within twenty years*, is thus referred to by Mr. Lecky (Eighteenth Century, Vol. 11., pp. 218, 219):—
> 
>  *Of that famine—the famine of 1740-41—we have many contemporaneous descriptions. According to one writer, 400,000 persons died. Bishop Berkeley has left behind touching descriptions of the misery that came before his own eyes and smote his loving heart; and another writer gives a picture as terrible as any even in the history of famines. ‘I have seen, (says this writer), the labourer endeavouring to work at his spade, but fainting from want of food, and forced to quit it. I have seen the aged father eating grass like a beast, and in the anguish of his soul wishing for his dissolution. I have seen the helpless orphan exposed on the dunghill, and none to take him in for fear of infection; and I have seen the hungry infant sucking at the breast of the already expired parent.’’’*
> 
> 




On the 16th December, 1778, in the House of Commons, Lord Nugent described the Irish people as suffering all the destitution and distress which it was possible for human nature to endure. Nine-tenths of the people earned no more than 4d. a day. In summer, their whole food consisted only of potatoes and water.


Speaking in the course of a debate in the Irish House 





---

p.26




of Commons, in 1787, the Attorney-General, Mr. Fitzgibbon, said:—

 

*I am well acquainted with the province of Munster, and I know that it is impossible for human wretchedness to exceed that of the miserable peasantry of that province. I know that the unhappy tenantry are ground to powder by relentless landlords. I know that far from being able to give the clergy their just dues (Protestant tithes), they have not food or raiment for themselves; the landlord grasps the whole. The poor people of Munster live in a more abject state of poverty than human nature can be supposed able to bear; their miseries are intolerable.’’*







#### Fertility, Industry, Squalor


In short, the majority of the population lived always on the verge of famine, and yet the country was as fertile as it is to-day. Arthur Young, who travelled through it in 1768, says of Limerick and Tipperary:—‘ It is the richest soil I ever saw, and Meath and West Meath are not less rich.’ As for the people, Lord Sheffield wrote:—


> 
> ‘The Irish people are not naturally lazy; they are, on the contrary, of an active nature, capable of the greatest exertions, and of as good a disposition as any nation in the same state of improvement; but that men who have very little to do, should appear to do little, is not strange.’— (*Observations on the Manufactures, Trade, and Present State of Ireland,* 1785.)
> 
> 
> 




Yet the condition of this race was thus described by Benjamin Franklin in 1772:—

 ‘The bulk of the people are tenants, extremely poor, living in the most sordid wretchedness, in dirty hovels of mud and straw, and clothed only in rags.. Had I never been in the American colonies, but were to form my

judgment of civil society by what I have lately seen, I should never advise a nation of savages to admit of civilisation, for I assure you that in the possession and enjoyment of the various comforts of life, compared to these people, every Indian is a gentleman, and the effect of this kind of civil society seems to be the depressing multitudes below the savage state that a few may be raised above it.’




---

p.27


#### English Policy, Irish Poverty

### Causes of Poverty


This state of things was inevitable where law, custom, and public opinion all allowed the owner of the land to raise the rent to the uttermost which he could extort, and where no other means of livelihood but the land offered itself.


The reason why there was no alternative is to be found in the government of England. Every possible Irish industry which could compete with the smallest English interest was not merely discouraged, but actually prohibited by law. Strafford, in the reign of Charles I., first laid down the policy of retaining Ireland in dependence by keeping the Irish people weak and impoverished. Being then Lord Lieutenant, he wrote to the King in 1634:—

 

 ‘I am of opinion that all wisdom advises to keep this kingdom as much subordinate and dependent upon England as is possible, and holding them from the manufacture of wool (which, unless otherwise directed, I shall by all means discourage), and then enforcing them to fetch their clothing from thence, and to take their salt from the King (being that which preserves and gives value to all their native staple commodities), how can they depart from us without nakedness and beggary? Which is of itself so mighty a consideration that a small profit should not bear it down.’


#### England's Responsibility


It was only, however, after the Williamite wars, when the main part of the fighting population of Ireland—chiefs and men alike—had been destroyed or had taken service abroad in Continental armies, that this policy was given full effect. Mr. Lecky writes:—

 *No country ever exercised a more complete control over the destinies of another than did England over those of Ireland, for three-quarters of a century after the Revolution. No serious resistance of any kind was attempted. The nation was as passive as clay in the hands of the potter,





---

p.28




 and it is a circumstance of peculiar aggravation that a large part of the legislation I have recounted was a distinct violation of a solemn treaty. The commercial legislation which ruined Irish industry, the confiscation of Irish land which demoralised and impoverished the nation, were all directly due to the English ‘Government, and the English Parliament’.’’*

—(Eighteenth Century, Vol. II., pp. 211, 212.)




Mr. Froude says:—

‘England governed for what she deemed her own interest, making her calculation on the gross balance of her trade ledgers, and leaving her moral obligations to accumulate, as if right and wrong had been blotted out of the statute-book of the universe .  
[*...*]  
 The English deliberately determined to keep Ireland poor and miserable, as the readiest means to prevent it being troublesome. They destroyed Irish trade and shipping by navigation laws. They extinguished Irish manufactures by differential duties. They laid disabilities even on its wretched agriculture, for fear that Irish importations might injure the English farmer.’


Arthur Young says:—

 ‘Of all the restrictions which England has at different times most implicitly laid upon the trade of Ireland, there is none more obnoxious than the embargoes on their provision trade. The prohibitions of the export of woollens, and various other articles, have this pretence at least in their favour, that they are advantageous to similar manufactures in England; and Ireland has long been trained to the sacrifice of her national advantage as a dependent country; but in respect to embargoes, even this shallow pretence is wanting; a whole kingdom is sacrificed and plundered, not to enrich England, but three or four London contractors!’


#### Lord Dufferin's Summing Up


But the best general summary of all this period is that given by a great Irishman, who was also one of the greatest of recent British statesmen. Lord Dufferin wrote in 1867:—

*‘‘From Queen Elizabeth's reign until the Union 





---

p.29




the various commercial confraternities of Great Britain never for a moment relaxed their relentless grip on the trades of Ireland. One by one, each of our nascent industries was either strangled in its birth, or handed over, gagged and bound, to the jealous custody of the rival interest in England, until at last every fountain of wealth was hermetically sealed, and even the traditions of commercial enterprise have perished through desuetude. The owners of England's pastures had the honour of opening the campaign. As early as the commencement of the sixteenth century the beeves of Roscommon, Tipperary, and Queen's County undersold the produce of the English grass counties in their own market. By an Act [of Parliament] Irish cattle were declared ‘a nuisance,’ and their importation prohibited. Forbidden to send our beasts alive across the Channel, we killed them at home, and began to supply the sister country with cured provisions. A second Act of Parliament imposed prohibitory duties on salted meats. The hides of the animals still remained; but the same influence put a stop to the importation of leather. Our cattle trade abolished, we tried sheep-farming. The sheep-breeders of England immediately took alarm, and Irish wool was declared contraband.’’*



Headed off in this direction, we tried to work up the raw material at home; but this created the greatest outcry of all. Every maker of fustian, flannel, and broadcloth in the country rose up in arms, and by an Act of William III. the woollen industry of Ireland was extinguished, and 20,000 manufacturers left the island. The easiness of the Irish labour market, and the cheapness of provisions still giving us an advantage, even though we had to import our materials, we next made a dash at the silk business; but the English silk manufacturer, the sugar refiner, the soap and candle maker (who specially dreaded the abundance of our kelp), and every other trade or interest that thought it worth its while to petition, was received by Parliament with the same partial cordiality, until the most searching scrutiny failed to detect a single vent through which it was possible for the hated industry of Ireland to respire. But although excluded from the markets of Great Britain, a hundred harbours gave her access to the universal sea. Alas! a rival commerce on her own element was still less welcome to England, and as early as the reign of Charles II. the Levant, the ports of Europe, and the oceans beyond the Cape of Good Hope were forbidden to the flag of Ireland. The Colonial trade alone was 





---

p.30




in a manner open, if that can be called an open trade which for a long time precluded all exports whatever, and excluded from direct importation to Ireland such important articles as sugar, cotton, and tobacco. What has been the consequence of such a system, pursued with relentless pertinacity for 250 years? This—that, *debarred from every other trade and industry*, the entire nation flung itself back upon *the land*, with as fatal an impulse as when a river whose current is suddenly impeded rolls back and drowns the valley it; once fertilised.


- 

That is briefly the story of English government in the eighteenth century. Industries everywhere destroyed; agriculture deliberately hampered; religious differences fostered and elevated into a caste system, with this further odious addition that education was denied to the inferior caste. As a result, famine was chronic among the conquered race, while even among the governing caste legitimate opportunities of enrichment were denied.


#### Ireland's Prosperous Hour


It seemed for a while as though the period of penal laws had been only that darkest hour before the dawn—since, out of oppression, freedom was born. When an Irish Parliament was given full powers, its use of them exceeded all anticipation. Lord Clare made this admission in 1798, concerning the system which he was fated to destroy:—

 ‘There is not a nation on the face of the habitable globe which has advanced in cultivation, in manufactures, with the same rapidity in the same period as Ireland’


Judge Jebb, another distinguished man, in a pamphlet published in the same year wrote:—

 

 ‘In the course of fifteen years our commerce, our agriculture, and our manufactures have swelled to an amount that the most sanguine friends of Ireland could not have dared to prognosticate.’




---

p.31


And Lord Plunket, in 1799, said:—



‘Ireland's revenues, her trade, her manufactures had thriven beyond the hope or the example of any other country of her extent, within these few years [before the Union], advancing with a rapidity astonishing even to herself.’


The bankers of Dublin held a meeting on December 18th, 1798, at which they passed the following resolution:—

 ‘Resolved, that since the renunciation of the power of Great Britain in 1782 to legislate for Ireland, the commerce and prosperity of this kingdom have eminently increased.’


The Guild of Merchants met on January 14th following, and passed a resolution declaring:—

 ‘That the commerce of Ireland has increased, and her manufactures improved beyond example, since the independence of this kingdom was restored by the exertion of our countrymen in 1782. That we look with abhorrence on any attempt to deprive the people of Ireland of their Parliament, and thereby of their constitutional right and immediate power to legislate for themselves.’


Lecky wrote in his History:— 

*From the concession of free trade in 1779 to the Rebellion of 1798, the national progress of Ireland was rapid and uninterrupted. *In ten years from 1782 the exports more than trebled*.’’*


All this might have been extended and augmented under the natural development of freedom. All this was destroyed because England would not allow Irishmen to trust their own fellow-citizens with equal rights. The recall of Lord Fitzwilliam was followed by measures of the most brutal coercion; the country was kicked into rebellion, and the advocates of Union got the excuse they wanted to suppress the liberties of Ireland.




---

p.32


### Chapter V


#### Ireland Under the Union


In 1800 the Union was carried—by what means it is superfluous to describe. A million and a quarter was spent in bribery, and, by a singular irony, this expenditure was charged to the public debt of Ireland. The sum was not widely distributed, since a very few persons controlled an enormous number of seats in the Irish Parliament. Lord Downshire, for instance, got £52,000 for his share, Lord Ely over £45,000, Lord Carrick £14,000, and so on down to the Earl of Massereene and his three brothers, each of whom received £3,750. It must be remembered that in spite of these influences the proposal of Union was at first rejected by the Parliament in 1799. Under a rational system of government the ministry would have fallen; but even when the Irish Parliament was free to legislate, its Ministers were imposed upon it by Great Britain, and went in and out in accordance with English, not Irish, public opinion.


#### The Union with Scotland compared


It is sometimes argued by Englishmen that since the Union with Scotland has been upon the whole a success, the Union with Ireland must inevitably have resulted for the good of Ireland but for the unfitness of the Irish either to govern or be governed. The best reply to this argument is found in an article written by that eminent Unionist, Professor A. V. Dicey, published in the Fortnightly Review for August, 1881, which I have summarised in a pamphlet here quoted:


> 
> ‘To the average Englishman's conception,’ says Professor Dicey, ‘the difference of results lies in the difference 
> 
> 
> 
> 
> 
> ---
> 
> p.33
> 
> 
> 
> 
> between Scotch and Irish character.’ Yet this view, so popular and so plausible, is dismissed by him as ‘a gross misrepresentation of past events which can be confuted by a simple reference to facts which lie on the very surface of history.’
> 
> 
> ‘Why did the Scotch Union succeed? First, because
> 
>  ‘The Act of Union embodied what was, not in name only, but in reality, a treaty or contract freely made between two independent states.’ Scotland accepted a bargain, made for her by ministers of her own choosing, after full deliberation, in which her material interests were richly secured. She gave up her independence; she secured full participation in the advantages of English trade. Her violent discontent and dislike to the loss of independence were worn away by a prosperity steadily growing. Before the Union, Scotland was excluded from the English Colonial trade. After the Union she enjoyed and profited to the full by all its vast opportunities.’
> 
> 
> FREE CONSENT
> 
> 
> ‘But’ (again in Dicey's own words) ‘the Union with Ireland lacked all that element of free consent between independent contracting parties which lies at the basis of every genuine contract. Of the deliberate negotiation, of the calm, satisfactory, business-like haggling for national advantages, which marked the negotiations between the Scotch and the English Commissioners; of the close consideration of minute details by competent representatives of both countries, there is not a trace in the negotiations, if negotiations they can be called, between England and Ireland.’
> 
> 
> ‘There was plenty of haggling over the details of individual bribes; none over the interests of the country. What were the driving forces?’ ‘One or two facts are patent-the Irish Protestants were dazed with horror at the massacres of the Rebellion; the Irish Catholics were lulled into acquiescence by promises which were made only to be broken; no appeal was made to the Irish constituencies; and the members of both Houses of Parliament were corrupted. *The Act of Union. was, in short, an agreement which, could have been referred to, a court of law, must at once have been cancelled as a contract hopelessly tainted with fraud and corruption.*’
> 
> 
> That is the great Unionists' verdict.
> 
> 
> 
> 
> ---
> 
> p.34
> 
> 
> THE BEST OF THE BARGAIN.
> 
> 
> ‘That is the first cause. Secondly, the Union with Scotland was carried out in a wholly different spirit.’
> 
> 
> ‘Favour was shown throughout to the weaker nation; the Scotch, from a merely mercantile point of view, got by far the best of the bargain.’
> 
> 
> ‘In Ireland the case was far different. After a century of legislation directed expressly against every industry that competed with any English interest, Ireland had, in 1782, achieved at once commercial and legislative freedom. In gaining independence, Ireland gained also those very privileges of free participation in oversea trade which Scotland sacrificed her independence to acquire. The corrupt aristocracy which sold Ireland's freedom sold also the charter of that right to protect and foster her own industrial life, under which the growth of manufacturing industry had been so swift.’
> 
> 
> THE NATIONAL CHURCH.
> 
> 
> ‘Thirdly,’ says Professor Dicey, ‘the institutions for which Scotchmen seriously cared were maintained or secured by the Union.   
> [*...*]  
>  The one great national institution— the Church of Scotland—derived new security and greatly increased power from the means which politically amalgamated Scotland with England.’ More generally, he adds: ‘The result of the respect paid to Scotch institutions was that, while Scotland became an inseparable part of Great Britain, Scotch affairs remained after, even more than before, the Union, under the control of Scotland.’
> 
> 
> ‘Contrast this with Ireland. The Church of Ireland, indeed, was secured, but it was not the Church of the Irish people. Godolphin ensured to the Scotch a cherished Institution. Pitt buttressed up in Ireland an alien anomaly. Mr.Dicey says:
> 
>  ‘The assembly which sat in Dublin had what the Scotch Parliament had not, strong claims on the sentimental interests of the people whom it represented; it had vindicated national independence; it had freed, Irish commerce; it had produced within the twenty years preceding its death a brilliant body of statesmen and orators; it had become, in short, a centre of national life.’’
> 
> 
> 
> 
> ---
> 
> p.35
> 
> 
> SPIRIT OF ADMINISTRATION.
> 
> 
> ‘Nor was political amalgamation with the United Kingdom compensated for by local independence. Ireland since, as before, the Union has been governed in the main in accordance with English notions, applied in many cases, or misapplied by English officials.’
> 
> 
> ‘Hear now Professor Dicey's summing up:—’
> 
> 
> ‘Neither Scotch nor Irish history can, except by the misreading of past events, be forced into teaching the lesson that the failure of the policy in Ireland is due to the peculiarities of Irish character. It is vain to attribute to the characteristics of any people consequences which can be explained by the neglect on the part of statesmen to make their policy conform to the nature of things.’
> 
> 
> 




#### Has the Union succeeded?


Of the passing of the Act of Union Mr. Lecky has said—‘It was not only a great crime, but was, like most crimes, a great blunder.’‘It united the Parliaments’ he says ‘and divided the nations.’


Without going into the question of England's moral title to govern Ireland—which Ireland has always denied—let us apply again the practical test of results. Has the government been successful? Has it been just? Has it been conducted on rational lines?


#### A Century of Famines


First, apply, again, the test of famine. There was famine of unusual severity in 1817. **De Beaumont**, an admirably informed observer, reported that the famine fever had affected a million and a half persons in Ireland, of whom, naturally, vast numbers perished. In 1819 a Parliamentary Committee reported:—


‘That the general distress and deficiency of employment *are so notorious* as to render the production of any particular evidence to establish the extent and variety of the evil unnecessary.’




---

p.36


Another Committee in 1823 described its condition of the people as wretched and calamitous to the last degree. I quote again from the catalogue which Mr. Fox has made of these Reports—the only remedy which England thought proper to apply:—




> 
> In 1830 a Committee of the House of Commons attested that a fourth part of the population was in want of work, and that this cause, in addition to the mode of working the land, produced destitution and suffering such as it was impossible for human tongue to describe; the tenant class having reached the last degree of distress, a great number of those who were obliged to seek refuge in the towns having died of want. Addressing the House of Commons on the 11th of November, in the same year, the Irish Solicitor-General, Mr. Doherty, said that ‘there was then in Ireland the existence of a condition of things which the lower animals in England would scarcely endure, and which, in fact, they did not endure.’
> 
> 
> In 1835, Commissioners charged with an important inquiry into the social condition of Ireland, estimated at nearly three millions the number of individuals who are every year liable to fall into absolute destitution. Besides these three millions of poor, there were also millions of other unfortunates, who were not counted, because not actually dying of hunger.
> 
> 
> In 1838, the Duke or Wellington made in Parliament this avowal, quoted in the Edinburgh Review, in 1848, that there never was a country in which poverty existed to such a degree as it exists in Ireland; that he occupied a high position in that country as Chief Secretary thirty years before, and that he must say that ever since then *there had hardly been a single year in which the Government had not had the most serious reason to fear a famine.*
> 
> 
> In the debate on the Irish Registration Bill, February, 1841, Lord Derby stated:—
> 
>  
> 
> *That persons having from fifteen to twenty acres of land are generally from April to September in a state of the greatest destitution, living on potatoes, without either milk or meat, and considering themselves very happy if they have dry potatoes enough—men who during a great part of the year lived on dry potatoes—men whom the landlords, letting their lands at a rack-rent, may upon any day turn loose upon the world, to starve in the last degree of misery.’’*
> 
> 







---

p.37


#### The Great Devastation


All this, it should be observed, is previous to the famine of 1846 and 1847, which may be regarded as the turning point in modern Irish history. Things then reached such a pitch of horror that it became apparent that the appointment of Committees would not suffice to meet the case.


The Census Commissioners wrote when the main harvest of death was over, though copious gleanings for pestilence still remained—

 ‘No pen has recorded the numbers or the forlorn and starving who perished by the wayside or in the ditches, or of the mournful groups, sometimes of whole families, who lay down and died, one after another, upon the floor or their miserable cabins, and so remained, uncoffined and unburied, till chance unveiled the appalling scene. No such amount or suffering and misery has been chronicled in Irish history since the days of Edward Bruce, and yet, through all, the forbearance of the Irish peasantry, and the calm submission with which they bore the deadliest ills that can fall on man, can scarcely be paralleled in the annals or any people.’(*Government Census of Ireland for the Year 1851-Report on Tables of Deaths,*)


In that visitation Ireland literally could not afford decent burial for her dead; the hinged coffin was a grim feature of those years. No European nation in modern times has suffered what, between 1846 and 1849, Ireland suffered under the government of England. Yet those were years when the country was exporting, weekly, shiploads of food, while the people lay starving at home. Lord John Russell admitted that in 1847 the wheat crop was above the average, and cattle were abundant. Government's main task was to protect the cargoes of food on their way to the ports.


Irishmen have always refused to believe that any Irish Government responsible for the Irish people, and sitting in Ireland, would have allowed its people starve while ships were carrying away from their shores food which the labour of their hands had produced. Nor did the decrease in the population which followed put an end to the 





---

p.38




famine. There was dearth again in 1859-60; finally, in 1879 another failure of the potato crop was a main motive cause of that revolution which has at last put an end to the system which inevitably resulted in the recurrence of these horrors.—It is quite true that the Irish people, save in some few outlying districts, are to-day in no danger of famine or starvation; but it is not the Government of England that they have to thank for the change.


They have to thank Parnell, Davitt, the Land League—agencies which England and the English Government did their utmost to stamp out.


#### Ireland of thirty Years ago


But, first, let us illustrate the condition to which eighty years of administration and law-making from Westminster had brought Ireland. In the spring of 1880, 117,454 were in receipt of poor-law relief. The Mansion House Fund, established to cope with famine, gave food or money to 512,625 (one in ten of the whole population) during the last week of February in that year. Special correspondents were sent to report. One wrote to the Daily Telegraph: 

 

 ‘I have been in many lands, and I have seen many so called oppressed people at home, but I declare that neither in the Russian steppes, nor in the most neglected Bulgarian villages, still less in the poor-est Hindoo hamlets, have I ever seen such squalid kraals as these Irish farmers inhabit. An officer of one of her Majesty's regiments, who lately served with honour in Zululand, declared to me that not even in the worst parts of Cetewayo's dominions did he come across anything so bad as here; and I am inclined to believe that he was not exaggerating in the slightest.   
[*...*]  
 It is manifestly impossible that these men can make a living off poor land so heavily burdened—land brought under cultivation by themselves or their predecessors, without the owner stirring a finger or investing a sixpence in its improvement. The rent, in point of fact, has to be made up by labour in England, and it is just this state of things which should be borne in mind by people who are disposed to complain of the Irish





---

p.39




tenant's revolt. His life is often one of slavery, for the benefit of the men who own the soil of a country where agriculture is the only industry.’


Mr. S. H. Tuke, a Quaker philanthropist, much of whose life was spent in relieving Irish famine under British Government, wrote of Camus, in Co. Galway:— 

 ‘I wish I could produce that rocky coast and wild miserable village, or, rather introduce it into England for a while, that English people might realise how, in these remote places, so many thousands of people are living. Half-a-mile away, and I will venture to say no one would think it possible that any human being could live, or even find foothold, on this rock-strewn shore; but, by degrees, you see the little smokes' arising, and here and there little dark strips of land, which show that the ground is being prepared for the potatoes they *hope* to obtain, for they have none left to plant. Then you see peering above the road little dark heads of men, women, and children, who, attracted by the unusual sight, come out of their cabins to reconnoitre. As you walk among them on landing, they watch you with curious eyes; they do not beg, and cannot answer your inquiries, for most do not understand, and few can talk, English. They are a race of wild people, poorly clad, and living with the cattle in their houses, often lying on the damp ground on hay like them. No distribution of meal had taken place last week, and several families were sitting round small quantities of the smallest (old) potatoes I ever saw, and with nothing else to eat with them. In one house which I entered three children, under one covering, ill with fever, were lying on the ground; others also were ill. For these miserable places among the rocks they were each paying from £4 to £8 a year. This would seem incredible at any time. No wonder that none had paid their rent last year.’


Mr. Fox, whose book I have so often quoted, wrote in his report to the Dublin Mansion House Committee:—

 ‘I have taken the precaution of seeing with my own eyes many of the recipients of relief in their miserable hovels, which so far as I have yet observed are a shocking reproach to the civilisation of the nineteenth century.   
[*...*]  
 I do not believe that tongue, or pen, however eloquent, could 





---

p.40




truly depict the awful destitution of some of those hovels. The children are often nearly naked. Bedding there is none, everything of that kind having long since gone to the pawn office, as proved to me by numerous tickets placed in my hands for inspection in well nigh every hovel. A layer of old straw, covered by the dirty sacks which conveyed the seed potatoes and artificial manure in the spring, is the sole provision of thousands—with this exception, that little babies sleeping in wooden boxes are occasionally indulged with a bit of thin, old flannel stitched on to the sacking. Men, women, and children sleep under a roof and within walls dripping with wet, while the floor is saturated with damp, not uncommonly oozing out of it in little pools. In one case I asked a gaunt, starved looking man, whom I found literally endeavouring to sleep away the hunger, where his little children slept, when he pointed to a corner in the moist room, in which I could see no sign of bedding. ‘Do they wear their clothes at night?’ ‘No.’ ‘How then do they keep warm?’ ‘There is,’ he replied, with the most amazing simplicity and composure, ‘a deal of warmth in children,’ signifying that they obtained warmth by huddling together like little animals. This occurred at Carrycastle.’


I invariably found them on the occasion of my visit crouching around the semblance of a fire lighted on the open hearth. And this at midsummer, showing how terribly low must be the vitality amongst them. It was only when I was accompanied by a Catholic priest I could get an insight into the appalling want. Alone, some of the most destitute tried to screen from me the poverty of their truckle beds, upon which the straw was often so thin that I could touch the bare boards with my hand. These received me with a dully passive surprise, wondering what might be the object of my curiosity in so wretched a country. And even the priest himself had occasionally to use no little persuasion to overcome this modest feeling, by assuring them that was present in the capacity of a friend. Everywhere the condition of the children was otherwise dreadful, besides, there being for them nothing but the Indian meal, badly cooked, to live upon, and the parents only too glad if the charitable funds provide the family with half enough even of that. Sometimes there was a miserable cow about the premises—for in every case I am referring to the class of small farmers, mostly residing on three to five acres of land, which in North Mayo is generally found to be reclaimed, bog or mountain 





---

p.41




slope; and this cow was supplying milk, principally *gratis*, to a small number of children other than the owner's, to mix with the Indian meal. Occasionally people appealed privately to my companion on no account to cut off the charitable supplies from the possessor of the cow, seldom worth more than a few pounds, and just then unsaleable in any market, as the animal was the hope of so many little ones. At other times cooked cabbage without a morsel of condiment save salt, was found where there was no meal, and in some instances one was found mixed with the other. But in numerous' cases there was neither milk, meal, nor cabbage, about the premises, and in those I gave temporary relief, to fill up the interval till the next general distribution of the local committee. Sometimes even charity itself had failed, and the mother of the tender young family was found absent, begging for the loan of some Indian meal from other recipients of charitable relief—the father being in almost every instance away in England, labouring to make out some provision for the coming winter. Yet in the most destitute cases hardly a word of complaint was uttered on the subject, it being a habit with, if not the nature of, the Mayo peasant submissively to ascribe his lot in times of scarcity as well as plenty to the ‘will of Providence.’ We visited more than thirty hovels of the poor, principally in the townlands of Culmore and Cashel, in which I beheld scenes of wretchedness and misery wholly indescribable. In some of these hovels evicted families had lately taken refuge, so that the overcrowding added to the other horrors of the situation. In one hovel, in the townland of Cashel, we found a little child three years old, one of a family of six, apparently very ill, with no person more competent to watch it than an idiot sister of eighteen, while the mother was absent begging committee relief, the father being in England. In another an aged mother, also very ill, lying alone and unattended, with nothing to eat save long-cooked Indian meal, which she was unable to swallow. In another, in the townland of Culmore, there were four young children, one of whom was in a desperate condition for want of its natural food—milk—without which it was no longer capable of eating the Indian meal stirabout, or even retaining anything whatever on its stomach. I took off my glove to feel its emaciated little face, calm and livid as in death, which I found to be stone cold. My companion gently stirred its limbs, and, after a while it opened its eyes, though only for





---

p.42




a moment, again relapsing into a state of coma, apparently. It lay on a wallet of dirty straw, with shreds and tatters of sacking and other things covering it. The mother was in Foxford begging for relief, the father being in England in this case also. In no Christian country in the world probably would so barbarous a spectacle be tolerated except Ireland. It is but right to add, that the mother of one of the evicted families, whose husband was in England, acknowledged with much gratitude some assistance which she had received from the funds of the Land League


Finally, I quote General Gordon, who wrote from Glengariff, in County Cork, November, 1880:—

 ‘I must say, from all accounts and from my own observation, that the state of our fellow-countrymen in the parts I have named is worse than that of any people in the world, let alone Europe. I believe that these people are made as we are—that they are patient beyond belief, loyal, but at the same time broken-spirited and desperate, living on the verge of starvation in places where we would not keep our cattle. The Bulgarians, Anatolians, Chinese, and Indians are better off than many of them are. I am not well off, but I would offer Lord — or his agent £1,000 if either of them would live one week in one of these poor devils' places, and feed as these people do.’


All this misery had grown up under English government; was, in truth, directly attributable to it. Yet England complained that the Irish were ‘disloyal.’


#### The New Order


Let it be freely and fully admitted that all this is changed. In the extreme West of Ireland people are still poor. But they pay a rent that has been fixed by a legal tribunal, and that is often less than half what they paid in 1880. If they improve their land, if by carrying soil on their backs, or by quarrying out huge stones, they create land, the benefit goes to them, not to the landlord.


In thousands of cases they own their own holdings, paying off the cost by small yearly instalments. The beginnings 





---

p.43




of prosperity are there, since no longer can all above a bare margin of subsistence be extracted from them. But who is answerable for this change? What has caused it?


#### How was it established?


The answer is, two forces acting together. First, a Party in Parliament, consisting of the ablest and most trusted men in Ireland, who in Parliament declared war on Parliament itself; who obstructed business; who created public scandal; who outraged all traditional decorum; above all, who refused to have any responsibility for the government of Ireland, or accept the smallest post save in a self-governed Ireland.


To this violent agitation in Parliament was added a still more violent agitation in Ireland. A land war was declared. Continued resistance to rent was accompanied by many terrible crimes. Under these circumstances, English Government under the Union felt that it was necessary to do something. Mr. Gladstone's great Land Act of 1881 was passed, which established the principle that fair rent must be legally assessed and that famine prices for land should no longer be extorted; and in this way gave the fixity of tenure which had been conceded to Protestant farmers in Ulster a century earlier.


Mr. Gladstone's measure was bitterly opposed by the Tory Party; but once it was passed the Tory Party adopted and extended its principles. Yet their principles were English ideas. Mr. Parnell from the first desired a policy of State-aided purchase. After twenty-two years of cumbrous and costly experiment it was seen that Parnell's policy was right, and the Unionist Party adopted it in 1903. Only since that date has any marked improvement in Ireland set in.


Yet the foundation was laid in 1879-80. The Land League and not the English Government gave to Irish labouring farmers security for the result of their labour. And the Land League was denounced by English statesmen as a ‘league of hell’; jails in Ireland were crammed with advocates of Land League policy, including every prominent Nationalist Member of Parliament. Men were 





---

p.44




punished by every means for taking the steps necessary to reform—not necessary under a rational and national Government, but necessary under the Union.


#### The Vice of English Legislation


The legislation of England for Ireland has been marked by one unfailing characteristic. One reform after another has been demanded by argument, eloquently set out by accredited speakers at Westminster, basing themselves upon expediency and justice; and every such reform has been denied until the Irish people, abandoning argument, had recourse either to open rebellion or to criminal conspiracy. In 1779 the grant of free trade between the countries and in 1782 the concession of legislative independence were made, because the Volunteers in Ireland demanded these things with arms in their hands.—In 1800 Pitt tried to make the Union acceptable by promising equality of rights to the Catholics. That promise was broken, and for twenty-nine years four-fifths of the Irish population agitated for the right to have representatives of their own religion returned to Parliament. Argument was laughed out of court, or voted down; and Catholic Emancipation was conceded ultimately by the Duke of Wellington on the admitted ground that the only alternative was civil war.


Before 1881 only one other great measure of justice to Ireland was accomplished—the disestablishment of the Irish Church in 1869. That was avowedly due to the Fenian Rising. But the whole of this case may be left on Lord Derby's statement—with this addition, that what he said before Parnell's day, might be illustrated with examples of increasing force from almost every year since the Parnell movement began:—


#### Lord Derby on England's Concessions


‘It is by no means clear to the unprejudiced observer that any gratitude has been earned [in the dealings of England with Ireland]. Why have we altered the Land Laws? To put an end to Irish agitation. Why have we cared to put an end to Irish agitation? Because it was not only discreditable to England as a ruling power, but a practical obstruction to the transaction of English business.





---

p.45




Fixity of tenure has been the direct result of two causes— Irish outrage and Parliamentary obstruction. The Irish know it as well as we. Not all the influence and eloquence of Mr. Gladstone would have prevailed on the English House of Commons to do what has been done in the matter of Irish Tenant Right if the answer to all objections had not been ready, ‘How else are we to govern Ireland?’.   
[*...*]  
 In the history of English relations with Ireland it has always been the same. By an unfortunate fatality every concession made to the weaker State has been under pressure. Take as a sample the creation of the almost wholly independent Irish Parliament in 1780-82. Was that a spontaneous gift? Notoriously it was the reverse. English resources were exhausted by the unsuccessful war with America; the Irish Volunteers mustered stronger than any force which could have been brought together at short notice to oppose them; the alternative was to yield to the Irish demands or to engage in a sanguinary civil war, exactly resembling that which had ended so disastrously on the other side of the Atlantic; and the decision taken, probably as a wise one, was to let Ireland have her own way. Not very dissimilar was the history of Catholic Emancipation, except that at that date it was a humane and rational aversion to civil war, not an actual disability to carry it on, which determined the issue. Sir R. Peel and the Duke of Wellington did not rest their cause on the alleged justice of the Catholic claims; they could not well do so, having for many years opposed these claims as unfounded. But they could and did say that the mischief of yielding to them was less than the mischief of having to put down an Irish insurrection. The same argument that had prevailed in 1782 prevailed in 1828-29. A third example of the same mode of procedure is in the memory of everybody. The Fenian movement agitated Ireland from 1864 to 1867, producing among other results the Clerkenwell explosion. Mr. Gladstone's statement as to the effect of this and similar attempts on the public mind of England, though too significant to be ignored, is too familiar to be repeated. I have too often heard that speech censured as unwise; to me it has always seemed a gain that the exact and naked truth should be spoken, though at the cost of some unpleasant criticism. A few desperate men, applauded by the whole body of the Irish people for their daring, showed England what Irish feeling really was; made plain to us the depth of a discontent whose existence we had scarcely suspected; and the rest followed of course.’




---

p.46


#### Land Reforms rejected


Few persons will now regret the Disendowment of the Irish Church or the passing of the Land Act of 1870; but it is regrettable that, for the third time in less than a century, agitation, accompanied with violence, should have been shown to be the most effective instrument for redressing whatever Irishmen may be pleased to consider their wrongs.


#### The Legislation which England rejected


Mr. Fox has compiled a list which is worth studying:

The following table (though incomplete) shows the constant rejection of Land Bills from 1829, and is in grim and melancholy contrast with another table of statistics compiled to show the facility with which Coercion Acts, almost as numerous, were passed, sometimes hurriedly, through both Houses of Parliament within the same period of half a century.






| Date | Bill | Fate |
| --- | --- | --- |
| 1829 | Brownlow's Bill dropped in Lords |  |
| 1830 | Grattan's Waste Land Bill  | refused |
| 1831 | Smith's Bill for the Relief of the Aged | dropped |
| 1835 | Sharman Crawford's Bill | dropped |
| 1836 | Sharman Crawford's Bill | dropped |
| 1836 | Lynch's Reclamation Bill | dropped |
| 1845 | Lord Stanley's Bill | dropped |
| 1845 | Sharman Crawford's Bill | dropped |
| 1846 | Mr. Sharman Crawford's Bill | abortive |
| 1846 | Lord Lincoln, Secretary for Ireland | do. |
| 1847 | Mr. Sharman Crawford | do. |
| 1847 | Sir W. Somerville | do. |
| 1848 | Mr. Sharman Crawford | do. |
| 1849 | Mr. Pusey | do. |
| 1850 | Sir W. Somerville | do. |
| 1850 | Mr. S. Crawford | do. |
| 1851 | Mr. S. Crawford | do. |
| 1852 | Mr. S. Crawford | do. |
| 1853 | Mr. Napier | do. |
| 1853 | Mr. Serjeant Shee | do. |
| 1855 | Mr. Serjeant Shee | do. |
| 1855–56 | Mr. Moore | do. |
| 1858 | Mr. Maguire | do. |






From 1870 onward, more detail is desirable. The 1870 Act showed, as every Land Act passed by the absentee Parliament has done, immediate cause for amendment. Parliament has always resented this importunity.





---

p.47





| Date | Bill | Introduced by | Fate |
| --- | --- | --- | --- |
| 1871 | Landed Property, Ireland, Act, 1847, Amendment Bill | Serjeant Sherlock | Withdrawn |
| 1872 | Ulster Tenant Right Bill | Mr. Butt | Dropped |
| 1873 | Ulster Tenant Right Bill | Mr. Butt | Dropped |
| 1873 | Landlord and Tenant Act, 1870, Amendment Bill | Mr. Butt | Dropped |
| 1873 | Landlord and Tenant Act, 1870, Amendment Bill No. 2 | Mr. Heron | Dropped |
| 1874 | Landlord and Tenant Act, 1870, Amendment Bill | Mr. Butt | Dropped |
| 1874 | Landlord and Tenant Act, 1870, Amendment Bill No. 2 | Sir J. Gray | Dropped |
| 1874 | Ulster Tenant Right Bill | Mr. Butt | Dropped |
| 1874 | Irish Land Act Extension Bill | The O'Donoghue | Dropped |
| 1875 | Landed Proprietors, Ireland, Bill | Mr. Smyth | Dropped |
| 1875 | Landlord and Tenant, Ireland, Act, 1870, Amendment Bill | Mr. Crawford | Rejected |
| 1876 | Landlord and Tenant, Ireland, Act, 1870, Amendment Bill | Mr. Crawford | Withdrawn |
| 1876 | Tenant Right on Expiration of Leases Bill | Mr. Mulholland | Dropped |
| 1876 | Land Tenure, Ireland, Bill | Mr. Butt | Rejected |
| 1877 | Land Tenure, Ireland, Bill | Mr. Butt | Rejected |
| 1877 | Landlord and Tenant, Ireland, Act, 1870, Amendment Bill | Mr. Crawford | Withdrawn |
| 1878 | Landlord and Tenant, Ireland, Act, 1870, Amendment Bill | Mr. Herbert | Dropped |
| 1878 | Tenant Right Bill | Lord A. Hill | Rejected by Lords |
| 1878 | Tenant Right, Ulster, Bill | Mr. Macartney | Withdrawn |
| 1878 | Tenants' Improvements, Ireland, Bill | Mr. Martin | Rejected |
| 1878 | Tenants' Protection, Ireland, Bill | Mr. Moore | Dropped |
| 1879 | Ulster Tenant Right Bill | Mr. Macartney | Rejected |
| 1879 | Ulster Tenant Right Bill, No. 2 | Lord A. Hill | Withdrawn |
| 1879 | Landlord and Tenant, Ireland, Bill | Mr. Herbert | Dropped |
| 1879 | Landlord and Tenant, Ireland, Act, 1870, Amendment Bill | Mr. Taylor | Dropped |
| 1879 | Landlord and Tenant, Ireland, Act, 1870, Amendment Bill, No. 2 | Mr. Downing | Rejected |
| 1880 | Landlord and Tenant, Ireland, Act, 1870, Amendment Bill | Mr. Taylor | Dropped |
| 1880 | Ulster Tenant Right Bill | Mr. Macartney | Dropped |
| 1880 | Fixity of Tenure, Ireland, Bill | Mr. Litton | Rejected |
| 1880 | Landlord and Tenant, Ireland, Act, 1870, Amendment Bill | Mr. O'C. Power | Dropped |
| 1880 | Compensation for Disturbance, Ireland, Bill (to prevent eviction under circumstances of excessive hardship) | Mr. W. E. Forster | Rejected by Lords |
| 1886 | Tenants' Relief, Ireland, Bill | Mr. C. S. Parnell | Rejected |








---

p.48


#### The Legislation which England Passed


Against this should be set another list. Parliament has always been able to find time to pass Coercion Bills for Ireland.






| Date | Bill |
| --- | --- |
| 1800–1805 | Habeas Corpus Suspension. Seven Coercion Acts. |
| 1807 | 1st February, Coercion Act. Habeas Corpus Suspension. 2nd August, Insurrection Act. |
| 1808–1809 | Habeas Corpus Suspension. |
| 1814–1816 | Habeas Corpus Suspension. Insurrection Act. |
| 1817 | Habeas Corpus Suspension. One Coercion Act. |
| 1822–1830 | Habeas Corpus Suspension. Two Coercion Acts in 1822 and one in 1823. |
| 1830 | Importation of Arms Act. |
| 1831 | Whiteboy Act. |
| 1831 | Stanley's Arms Act. |
| 1832 | Arms and Gunpowder Act. |
| 1833 | Suppression of Disturbance. |
| 1833 | Change of Venue Act. |
| 1834 | Disturbances Amendment and Continuance. |
| 1834 | Arms and Gunpowder Act. |
| 1835 | Public Peace Act. |
| 1836 | Another Arms Act. |
| 1838 | Another Arms Act. |
| 1839 | Unlawful Oaths Act. |
| 1840 | Another Arms Act. |
| 1841 | Outrages Act. |
| 1841 | Another Arms Act. |
| 1843 | Another Arms Act. |
| 1843 | Acts consolidating all Previous Coercion Acts. |
| 1844 | Unlawful Oaths Act. |
| 1845 | Additional Constables near Public Works Act. |
| 1845 | Unlawful Oaths Act. |
| 1846 | Constabulary Enlargement. |
| 1847 | Crime and Outrage Act. |
| 1848 | Treason Amendment Act. |
| 1848 | Removal of Arms Act. |
| 1848 | Suspension of Habeas Corpus. |
| 1848 | Another Oaths Act. |
| 1849 | Suspension of Habeas Corpus. |
| 1850 | Crime and Outrage Act. |
| 1851 | Unlawful Oaths Act. |
| 1853 | Crime and Outrage Act. |
| 1854 | Crime and Outrage Act. |
| 1855 | Crime and Outrage Act. |
| 1856 | Peace Preservation Act. |
| 1858 | Peace Preservation Act. |
| 1860 | Peace Preservation Act. |
| 1862 | Peace Preservation Act. |
| 1862 | Unlawful Oaths Act. |
| 1865 | Peace Preservation Act. |
| 1866 | Suspension of Habeas Corpus Act (August). |
| 1866 | Suspension of Habeas Corpus. |
| 1867 | Suspension of Habeas Corpus. |
| 1868 | Suspension of Habeas Corpus. |
| 1870 | Peace Preservation Act. |
| 1871 | Protection of Life and Property. |
| 1871 | Peace Preservation Con. |
| 1873 | Peace Preservation Act. |
| 1875 | Peace Preservation Act. |
| 1875 | Unlawful Oaths Act. |
| 1881–1882 | Peace Preservation Act (suspending Habeas Corpus). |
| 1881–1886 | Arms Act. |
| 1882–1885 | Crimes Act. |
| 1886–1887 | Arms Act. |






#### The perpetual Coercion Act


That carries the series to 1886. But Mr. Balfour, observing that the repeated introduction of these measures occupied time, and gave occasion for protest, celebrated 





---

p.49




the year of Queen Victoria's Jubilee by passing the perpetual Coercion Act which is still in force, and which can be put into operation for any part of Ireland, or the whole, by the simple issuing of an order from Dublin Castle.


#### Why Coercion was Needed


Some of those Coercion Acts, were needed to enforce the payment of tithes by Roman Catholics to the Established Church; but the object of the vast majority has been to facilitate that process of eviction which was distinctive of the Irish land system. Mr. Barry O'Brien says in his Home Ruler's Manual, p. 28:—



*‘‘The Land question, perhaps, affords the fairest test of the capacity of the Imperial Parliament to legislate for Ireland.’’*


There has been a land war in Ireland since the Union. The Imperial Parliament has been powerless to end it. Over and over again it was proved before Royal Commissions and Parliamentary Committees that the system of land tenure was a source of evil, and even danger; but Parliament did nothing to remove the evil, to avert the danger.


What was the system of land tenure? The landlord let ‘land.’ The tenant improved it—built, drained, fenced, made the land a ‘farm.’ The landlord raised the rent to the enhanced value. The tenant, who had exhausted his resources in bringing the land under cultivation, was unable to pay. The landlord evicted him, and appropriated his improvements without allowing him one shilling's compensation for them. In 1845 the Devon Commission—a Commission of landlords—condemned this system and recommended legislation in order to secure to the evicted tenant compensation for his improvements. But Parliament did nothing to carry out these recommendations until 1870, when Mr. Gladstone's first Land Bill became law.


- 

#### Evictions


The right of ejection for non-payment of rent without a special clause of re-entry in the contract was declared by Sir Charles Russell to have no existence in England. A man who owed rent could only be proceeded against as 





---

p.50




if he owed any other bill. Yet in England if a man was put out from one farm, he could get another; failing a farm, other trades were open to him. In Ireland there was nothing but the land, and for every farm there were many applicants. A sentence of ejectment was a writ of banishment, and every man whose rent was in arrears was subject to eviction. But eviction was not only undertaken for non-payment of rent. It was used as a tyrannical weapon. For instance, at Glenveagh, in Co. Donegal, because a bailiff had been killed, Mr. Adair evicted all the families from a whole district—some five hundred souls in all. —A British regiment was sent down to secure the smoother working of his decree.—But the most frequent motive of eviction at a certain period was mere hunger for gain.


#### The Great Clearances


The great famine in 1848 coincided with the repeal of the Corn Laws. Up till then Ireland had been growing corn; now corn began to come in free of duty from America and elsewhere. Under the conditions of those days, cattle and dead meat could not be imported, and, therefore, it paid the owners of land in Ireland better to produce beef and mutton than grain. Where the soil was rich enough to be left permanently in grass, many of the landlords cleared off the whole population, in order to undertake what seemed a more profitable manner of dealing with the land. This process was quickened by the fact that in many cases the distress of the famine years in which the tenants could pay no rent had ruined older landlords—men who, good or bad, had associations with the tillers of the soil. New speculators came in. Two brothers, for instance, in counties Galway and Roscommon, cleared off eleven hundred families from what has since become famous as the Pollock Estate. According to Thom' s Official Directory‘’ for 1861, the number of tenanted dwellings in Ireland was reduced from 1,328,000 in 1851 to 1,046,000. Thus, 280,000 human dwellings were destroyed within a period of ten years, and in 1861 the process was only beginning. These operations were sanctioned by the British Government 





---

p.51




which, in case of resistance, was always ready to send down troops to assist the landlord in the work. The Parliamentary Returns state that between 1849 and 1867 558,000 persons were evicted; but this must be far below the truth. Special machinery was invented in some cases to assist in the demolition of houses. This method was specially practised in the eighties, when resistance to rents had become organised as a political propaganda.


#### Government's Attitude


It is very doubtful whether any other Government in civilised history has employed its civil and military forces to assist in the wholesale extermination of its people. It is certain that no native Government, resting on the consent of the governed, would or could ever have done such a thing. English law and English administration facilitated eviction in the interests of those who were accustomed to term themselves the English garrison in Ireland.


Another peculiarity of British government in Ireland was that it welcomed, recommended, and at last actually subsidised the wholesale emigration of its subjects. In the winter of 1882-83 the Government was providing free passages for the Irish to go to America.


#### General Observations on the Period of Union


Taking the history of the Union then up to a generation ago, what do we find? First, that the administration which was controlled by England proved itself entirely powerless to meet the emergency of famine; it allowed the unlimited export of food at times when the people were starving in tens of thousands. But, during the same period, administration was always ready to provide the forces of the Crown as a protection for those who carried out the work of eviction. Secondly, let us ask what laws were made. Previous to 1870, England had passed only one great law of reform affecting Ireland—Catholic Emancipation. This measure was passed only after thirty years of agitation, and under the threat of civil war.




---

p.52


#### Legislation according to English Ideas


Further, the remedial legislation, in so far as it was attempted, was carried out in opposition to the views of those who knew Ireland. The most conspicuous case is that of the establishment of the Poor Law. The facts have thus been described by Mr. Hugh Law, M.P., in It pamphlet called The Irish Poor Law and the Blessings of English Government:—

 

 ‘All Irish grievances are commonly supposed either to have originated in the remote past, or in religious or political differences between various sections of the Irish people. We may ask, therefore, has the pretension of England to legislate for Ireland been productive of good results even in a matter which would seem remote from party strife—the administration of the relief of the poor?’


‘The persons affected, whether as recipients of relief, or as ratepayers, belong to no one political party or creed. Let us see, then, how in dealing with such a problem, the application of English ideas has worked out.’


#### The Irish Commission on Poor Law


‘For many years before the great famine of 1845, it had become evident that the poverty of great masses in Ireland must sooner or later bring about a catastrophe.’


‘In the year 1833 a Royal Commission was appointed to examine into the question. For three years the Commissioners pursued their inquiries, and then issued a very remarkable report. They came in the first place to the conclusion that the workhouse system which had recently been established in England, was radically unsuited to the different conditions obtaining in Ireland. They pointed out that, whereas that system was devised in order to make the lazy and the idle seek employment which could be obtained, in Ireland, on the contrary, able-bodied men who were willing and anxious to work, even for two pence a day, were unable to obtain any regular employment whatever. This being the case, the Commissioners saw clearly that the great need of the country was for such development of its resources as would at once afford work for the workless, and, by creating industries, would tend to raise the whole social





---

p.53




and economic condition of Ireland. With this object in view, the Commission made the following proposals:—


> 1. The reclamation of waste land.
> 2. The enforcing of drainage and fencing of land.
> 3. Building labourers' cottages.
> 4. Agricultural instruction.
> 5. Land Reform.
> 6. Transfer of powers of grand juries to County Boards, together with what is now known as the ‘direct labour’ system for county works.
> 7. Development of the county by public works.
> 

’



‘It was, however, plain that even after such measures had been taken, there would remain certain classes for whom direct relief would be required. For the physically and mentally infirm the Commissioners reported that relief and support should be afforded within and without the walls of public institutions. Thus they advised the creation of hospitals and infirmaries, extern attendance and the supply of food as well as medicine in cases where sick persons were not in a condition to be removed from their homes, the establishment of penitentiaries to which vagrants might be consigned, and maintenance of deserted children, the care of aged and infirm persons, of orphans and helpless widows and young children, of the families of sick persons, and relief of casual destitution—in short, they proposed to deal with the problem exactly on the lines which now approve themselves to most humane persons in our own day. It is worth noticing, in particular, that seventy years ago this Irish Commission recommended that vagrants, instead of being allowed to drift from one casual ward to another, should be remitted to penitentiaries, and, in suitable cases, sent abroad to non-penal colonies to work as labourers upon the land.’


#### The Irish Report rejected


But the Commission suffered from one radical defect.

 It was an Irish Commission. Its Chairman, Dr. Whateley, it is true, was an Englishman and a well-known economist. All the other Commissioners were Irishmen. Clearly, thought the Government of Lord John Russell, mere Irish men could not be trusted to know what was good for them 





---

p.54




selves or for their country. Accordingly, a single member of the English Poor Law Commission was sent to Ireland to revise the findings of the Commissioners. Mr. Nicholls, who had not previously been in Ireland, remained in the country for a period of six weeks. These six weeks, however, were more than sufficient to show him (what in any case was from the first taken for granted) that the unanimous findings of the Irish Commission were thoroughly unsound. (Their constructive recommendations above quoted were contemptuously ignored.)


‘Many sanguine persons,’ wrote Mr. Nicholls,

 ‘appear to consider it as the purpose of the Poor Law, not only to relieve destitution, but to eradicate poverty.’ As against such a method of dealing with the problem, Mr. Nicholls lays down very frankly the assumption which guided him during his six weeks' inquiry. ‘I assume as the governing principle to be observed in dealing with this portion of the subject that the Poor Law of Ireland should assimilate in all respects as nearly as possible to the Poor Law system now established in England.’ Indeed, so far from wishing to build up the social and economic conditions of the small land-holders, and enable them to do without State relief, Mr. Nicholls somewhat oddly avows as a part of his plan the detachment of the Irish peasantry from the soil, which, says he,

 ‘is necessary to restore to the landlords the power of doing what they will with their own!’


The views of Mr. Nicholls, with his six weeks' experience of Ireland, were preferred to those of the Irish Royal Commission. In December, 1837, Lord John Russell introduced a Bill drafted by Mr. Nicholls himself. The Bill was opposed by O'Connell, who, for perhaps the only and last time of his life, was supported by the Irish Unionists, headed by Lord Castlereagh.


With one exception, all the Irish Grand Juries petitioned against the Bill. A few Irish representatives in the two Houses voted for it, but, as their speeches show, hesitatingly and with reluctance. Notwithstanding this remarkable unanimity of Irish opinion, the Bill became law six months later.


#### The English Plan and its Consequences


The system thus established in the teeth of Irish public opinion, broke down hopelessly and disastrously under the shock of the Great Famine. The Government, having 





---

p.55




treated with contempt proposals of the ‘sanguine people’ who actually were for attempting to ‘eradicate poverty,’ and stop the evil at its source, found themselves faced by a truly appalling crisis. In one respect they acted with promptitude and decision. They introduced a new Coercion Bill, and ably seconded the efforts of certain landlords in ‘clearing’ their estates of the starving tenantry. Otherwise, as a recent French writer has said,

 *They did little, and that little stupidly, and in the spirit of pedants and misers.’’*

L'Irelande Contemporaine, par L. Paul Dubois. Paris, 1907.



 ‘Detached from the soil,’ and converted into ‘free labourers’, thousands upon thousands died miserably of hunger and famine fever. The workhouses in which hitherto no one would set foot, were soon overflowing. But the provision did not nearly suffice. Sir Robert Peel, therefore, sanctioned the establishment of food depots and relief works. His successor, Lord John Russell, suppressed them, then re-established them, prohibiting, however, any works of a reproductive character! Hundreds of thousands of famine-stricken men were employed at wages of five pence a day to dig holes and fill them in again, to level mounds which were forthwith re-erected. And this in a country naturally fertile, but undrained, unfenced, unplanted, and undeveloped. Did the pedantry which persuades men that they are entitled by virtue of superior education or the like, to override local knowledge and local feeling, ever produce any spectacle more ludicrous or more terrible?
Since 1849, it is true, the peculiar theories of the ‘Manchester School,’ which produced this result have passed out of fashion, but Ireland has no guarantee that the pretensions of English politicians to know (better than we do ourselves) what is good for Ireland may not again produce results which future generations will regard with the same astonishment and regret, which Englishmen to-day express with regard to these follies of the past.


#### Modern Views


In this connection, it is worth noticing, that of the recommendations of the Royal Commission of 1833, numbers 3, 4, 5, and 6 have been given effect to after the lapse of many years by legislation which has commended itself to both parties; such as the Housing of Labourers Acts, 1883-1906, the Acts establishing the Congested Districts Board 





---

p.56




and the Department of Agriculture, 1891-1899, the Land Acts, 1860-1903, and the Local Government Act, 1898.


Number 7 may also be considered to have been partially put into execution in various ways by the building of light railways and the general benevolent activities of the Congested Districts Board.


The reclamation of waste land and the proper drainage of the country still remain to be effected, though admitted to be necessary and frequently recommended since that time by competent authorities, notably by the recent Viceregal Commission on Arterial Drainage.


Irish opinion is thus justified after many years. On the one hand, the improvement of the general welfare of the country by direct measures of development which Lord John Russell regarded as a

 ‘perilous task,’ is now accepted by both parties as a first object of policy, whilst on the other, all Poor Law reformers now admit that the existing workhouse system, as a method of relieving poverty, is at once stupid, wasteful and cruel. All that John Bull's interference in this domestic Irish question of the relief of the poor and sick has achieved, is to burden the Irish ratepayers with the upkeep of huge and hideous buildings, and with the salaries of an army of officials, whose salaries and emoluments eat up a fifth of the total sum nominally available for Poor Law Relief. For every forty shillings spent upon relief of poor persons in the workhouse, twenty shillings are paid away in official salaries and ///emoluments.


The following is the official statement of the details of poor relief expenditure for the 12 months ending 30th Sept. 1907. The item ‘other expenses,’ includes, of course, the cost of maintenance of the fabrics of the workhouses, most of which, in country districts, stand always more than half empty—





| Detail | Amount |
| --- | --- |
| Cost of indoor relief | £456,474 |
| District schools: Cost of maintenance | £7,918 |
| Boarded-out children: Cost of maintenance | £16,600 |
| Cost of outdoor relief | £198,337 |
| Salaries and rations of officers, amount of | £204,307 |
| Institutions for the blind, &c., and extern hospitals: Cost of maintenance of persons sent thereto by the guardians | £21,175 |
| Medicines, &c., in workhouses: Cost | £10,861 |
| Other expenses | £125,948 |
| Total poor relief expenditure | £1,041,620 |








---

p.57


#### History repeating itself


‘One word more. An Irish Vice-Regal Commission upon the Irish Poor Law was appointed in 1903; and, after three years' careful work, during which the Commissioners visited every Poor Law Union in Ireland, reported in 1906. The report advocates the virtual abolition of the English workhouse system forced upon Ireland in 1837, and a return to the plans of the despised Irish Commission of 1833. Irish opinion, without distinction of creed or party, has expressed approval. But the old distrust of Irish capacity has again manifested itself; and this report is now shelved pending the publication of the report of an English Commission, which has within the last few months paid a brief visit to Ireland. No one doubts the desire of the members of this Commission (which includes one distinguished Irish Bishop) to do what is best for Ireland. But Irish Poor Law Reformers are anxiously asking ‘Is History going to repeat itself; and is the mature judgment of another Irish Commission again to be set on one side, if found to conflict in any degree with the views formed by Englishmen, after as brief a visit to Ireland as that of Mr. Nicholls seventy years ago?’’


#### The Contrast between Ireland under Grattan's Parliament and Ireland under the Union


The general decay of the country from the point reached while Ireland governed herself may be best illustrated by some details taken from the "Repealer's Handbook" of Mr. Battersby, published in 1833.


In the first place, the effect of the Union had been to increase absenteeism enormously. This affected country and town alike. The greater part of the tenants of Ireland paid rack-rents, which were spent in England or elsewhere. None of the money which they earned came back to them.


Its effect on the towns may be judged from the fact that before the Union ninety-eight peers and a proportionate number of wealthy commoners inhabited Dublin. In 1833 the resident peers were only twelve.—To-day there 





---

p.58




is one.—Again, in the period of Grattan's Parliament, Dublin was a great centre of artistic craftsmanship. A special Georgian Society has now been formed to reproduce and preserve the details of the domestic architecture of that day. Sheraton furniture was Dublin work of that date. Horace Walpole used to send his books to be bound by Dublin craftsmen. Irish silverwork of the eighteenth century is collected eagerly by connoisseurs, as is also the famous Waterford glass. There was a very considerable printing and publishing trade before the Union; more than twenty thousand volumes had been published in Dublin. Thirty years later, this business had shrunk to nothing; what printing remained was cheaply and badly done. The skilled arts and craftsmen all vanished.


Take the more important industries. In the village of Prosperous, before the Union, there were 500 looms, where in 1833 there were only 10. Before the Union there were 60 woollen manufactories in Dublin; in 1833 there were 10. In one parish of Kilkenny 4,000 persons, before the Union, were employed in the woollen factory; in 1833 there were under 100. In the town of Carrick 5,000 persons were employed before the Union at one trade only; in 1833 there were 40. And so on over the whole country. The tonnage of British ships employed in the trade of Ireland was 534,413 in 1792—it had increased by nearly 200,000 tons within two years after Independence. In 1831 the registered tonnage had shrunk to 112,659 tons. Even the linen trade had fallen from an export value of £3,000,000 in 1796 to half that amount in 1830. At the same period there was an enormous increase in the export of undressed flax. Generally speaking, the exports from Ireland in the thirty years after the Union changed completely in their character. Mr. Pitt, on January 31, 1799, said that Great Britain imported from Ireland manufactured produce to the amount of between £4,000,000 and £5,000,000 sterling. In 1831 the exports from Ireland into England were valued at £4,380,000. The only manufactured element in this was under the heads of bacon, butter, flour and meal. Of finished manufactures there are none recorded.




---

p.59


#### Results of the Union


In short, then, thirty years after Great Britain had assumed the complete responsibility for the government of Ireland—not being seriously impeded by the presence of 100 Irish members in a Parliament of over 600—England had succeeded in crushing out the manufacturing interests in Ireland, except the linen trade, in which she herself

 ‘was not seriously interested; and she had converted Ireland into a farm, producing raw and unmanufactured produce for the English manufacturer and the English consumer. This was the object to which all the laws in restraint of Irish trade and commerce were directed during the eighteenth century; and this object, so long as Ireland had even a subservient Parliament, was never achieved.—The result upon Ireland is remarkably shown in the record of the consumption of commodities. The population had increased between 1800 and 1830 by at least one and a half million, yet Ireland's consumption of tobacco had decreased from £6,737,000 to £4,041,000; the consumption of sugar from £355,000 to £319,000. Taking the joint heads of tea, tobacco, wines, spirits and coffee, the total quantities consumed in 1800 amounted to 12,400,000 units. In 1827, with a population increased by 25 per cent., they had shrunk to 9,800,000 units, but the taxation on the decreased amount was £1,885,000 as against £1,216,000 on the larger amount.—In other words, judged by the simplest possible test, the Irish people were much poorer, could afford to buy much less of the most ordinary articles of consumption, and were paying a greatly increased amount in taxes upon the lessened quantities that they bought.’


During the same period the rent-rolls had been steadily increasing. Considering all this, need it be asked whether fifty years of Union had drawn the two peoples closer together? In 1848 the appalling catastrophe of Irish famine undoubtedly evoked great compassion and great charity in England; but Ireland was not asking for charity or for compassion. She was asking for justice and for freedom. In the face of that sinister result of half a century's law 





---

p.60




making and administration by an alien Power, she demanded with greater fierceness than ever the right to manage her own affairs.


#### Since the Famine


It is not too much to say that hatred of English rule has been steadily growing since the Union, and Grattan's prophecy has been fulfilled:— ‘What you trample upon in Ireland will sting you in America.’ The Irish race, pouring out in fever-stricken ship-loads across the Atlantic, carried with them, into the New World, hatred of the Power which had oppressed them in the Old.


The rebellion of 1848 was easily crushed out, and Gavan Duffy, one of its leaders, left his country a few years later— ‘leaving her,’ he said, ‘stretched like a corpse upon a dissecting-table.’ He went to Australia, where he helped to found a representative Government, and became the Prime Minister of Victoria. But in his absence the ‘corpse on the dissecting-table’ revived. In 1867 the Fenian organisation spread over the whole of Ireland, and, officered largely by Irishmen who had gained military experience in the American War of Independence against slavery, created a widespread terror. It, also, failed of its military purpose, but the Disestablishment of the Irish Church was frankly attributed to it, and also the passing of Mr. Gladstone's Land Act of 1870, which first recognised the principle that a tenant had a right to the value which he had created by his labour on the land. It may be said that these two measures marked the beginning of a new spirit in British legislation. Attempts were made from this time out to remedy the evils from which Ireland was suffering. But in every case British legislators preferred their own methods to those recommended by the Irish, and British administrators persisted in treating as criminal the agitation which was necessary to produce reforms.


#### Parnell's Policy


Parnell's policy aimed at two things:—First, general land purchase, under which the occupier of the land would 





---

p.61




be made the owner of it, as had been done years before in Prussia, by State intervention. Secondly, he demanded Home Rule. Both projects were treated by the British Government as chimerical.


#### The Land


As to the land reform, Mr. Gladstone, by his Act of 1881, established the principle of dual ownership which secured the Irish tenant against the arbitrary raising of his rent, and against arbitrary eviction, and to that extent laid the foundation of settled prosperity in Ireland. But the machinery was costly and cumbrous, and it saddled every farm in Ireland with a constant series of law suits. Mr. Gladstone himself soon saw this, and in 1886, along with his Home Rule Bill, he proposed a land purchase measure, pledging one hundred millions of British credit. The idea was scouted, and was, indeed, the principal means of wrecking his proposals.


Yet in 1903 the Unionists finally adopted Parnell's policy. The Irish leader's plan was only tried after twenty-five years of agrarian war, which had embittered the whole relation between landlord and tenant, and which had driven half the gentry out of Ireland.


#### Home Rule


Home Rule, which both English parties laughed to scorn under Butt and in the early days of Parnell, was, in 1886, adopted by one of the two great English parties. The agitation to secure it is not vet at an end; but the struggle has entered on a new phase. In 1885, for the first time, an extended franchise was established in Ireland. Ever since Irishmen got the vote on a more democratic scale, four-fifths of the representation of Ireland has been returned pledged to Home Rule. There is no swing of the pendulum in Irish politics. Save in about half-a-dozen constituencies, there has been no change since 1885. At the present moment all the members for Munster, Leinster and Connaught are returned to support Home Rule, and 16 out of the 33 members in Ulster. It can hardly be said that there is an agitation for Home Rule 





---

p.62




in Ireland; there is simply a steady affirmation of a demand. But there is an agitation against Home Rule in England, and the nature of it is noticeable. It is an appeal to sectarian prejudice and to religious hate.


#### Protestant Ascendancy


The English Government has succeeded only in one object in Ireland. It has succeeded in increasing the division between religions since the Union. Within the five years before the Union, a very strong agitation was started by Protestants in Ireland for giving full equality to Catholics. The Society of United Irishmen was founded by Protestants. Since the Union most of the leaders of Irish public opinion have been Protestants—Emmet, Smith O'Brien, Mitchell, Martin, Butt, Shaw, and Parnell; but the mass of Protestants have been detached by English influences from their fellow-countrymen. This was done by maintaining the principle of Protestant ascendancy. Irish Protestants were made to feel that so long as the Union continued they would be a privileged caste; that they would have the whole government of the country and enjoy all its preferment. When the disestablishment of the Church was proposed, Irish Protestants threatened civil war, exactly as they are doing to-day, and with exactly the same seriousness of intention; but it was not for religion they were proposing to fight. The Rev. Henry Henderson, of Holywood, one of their chief spokesmen, said, before a great Orange meeting at Saintfield, County Down:—‘It was right they should tell their English brethren the truth. It was right they should tell them that so long as there was Protestantism in the land, and a Protestant Sovereign occupying the throne, so *long must there be Protestant ascendancy*.’ The maintenance of the Union meant keeping a grip on the spoils of office. Yet whenever any citadel of Protestant ascendancy was threatened, Irish Protestants came over to England and declared, as they are declaring to-day, that their lives and liberties would be in danger.


The direct effect, then, of English rule in Ireland has been to foster religious bigotry and intolerance; and the 





---

p.63




whole activity of the Unionist Party and the Unionist Press at the present moment is devoted to persuading Irish Protestants that they must regard Irish Catholics as their enemies, and to persuading English Protestants that they must regard Irish Catholics as the hereditary enemies of England and the determined oppressors of their Protestant fellow-countrymen. A later section will deal with the facts of this matter.




---

p.64


### Chapter VI

### How the Union stands to-day


To sum up, then, for the last forty years England has attempted a good deal of remedial legislation for Ireland; but it has always been undertaken in the wrong spirit— that is to say, redress has only been attempted after violent agitation has taken the place of argument; and in the wrong method, as is proved by the fact that each successive Land Act has needed repeated amendment.


The one measure, whose success is admitted on all hands, has been that universally recommended by Irish states men—namely, the establishment of a peasant proprietorship and occupying ownership.


Further, the main characteristic of English rule has been the maintenance and encouragement of religious divisions and the concentration of all political and administrative power in the hands of one favoured denomination.


The administration of justice has been discredited by the constant employment of coercion and the practice of packing juries by challenging all men on the panel, except persons whose known predispositions enabled the prosecution to count on them for a verdict.


The success of the government may be judged by the fact that the population has, during the last half century, steadily dwindled till, within fifty years, it has been reduced by 4,000,000—a fact without parallel in modern Europe.


Add to this that the amount of income assessable to income tax has remained stationary since 1895, whereas, in Great Britain it has increased by £300,000,000.


It is apparent, then, that the Act of Union shows no very splendid results.




---

p.65


#### Ireland's Improvement and its Causes


At the same time there are indications that the decline of Irish prosperity has terminated; the trade of the country is improving. The opponents of Home Rule point to this fact as a reason why the Union should be maintained. The answer is, that the improvement in the state of Ireland is due, not to Unionist policy, but to the policy which the Unionists opposed at every turn. The Unionist Party opposed, by all means, the land legislation of Mr. Gladstone. They were driven to extend its principles, as Mr. Gladstone was driven, by violent agitation which was treated as a crime. The Land Act of 1903—undoubtedly a beneficent measure—was the direct outcome of an agitation in 1902, for which a dozen Irish Members of Parliament, with numberless lesser individuals, were condemned to terms of imprisonment.


The concession of Local Government was, in the first place, a concession which, under the Act of Union, could not be denied if there was to be union. When Local Self-Government was given to England it could not logically be refused to Ireland, although it was withheld for several years, and was at last only conceded in the avowed hope of ‘killing Home Rule by kindness.’


Another important reform recently granted, was the establishment of a University suited to the needs of Irish Catholics under Mr. Birrell's Act. This has undoubtedly been an important and valuable change; but Ireland had to wait fifty years for it, and generation after generation of young Irishmen grew up without the advantages of University training. It is inconceivable that an Irish Parliament, responsible to Ireland as a whole, would have allowed this matter to remain so long unsettled.


#### Reforms still needed


Nor has the concession of Local Government, of a University, or Land Purchase, by any means exhausted the legislative needs of Ireland.


There is agreement among the Irish of all classes and 





---

p.66




creeds, that the system of Primary Education and of Secondary Education is insufficiently endowed and badly administered: the English Parliament has not the time to attend to these matters, and if it had, it would probably settle them in accordance, not with Irish, but with British opinion. Some of the details are discreditable and absurd. For instance, Intermediate Education was given the ‘whisky money’ as its revenue, with the result that the endowment of secondary schools declined from £70,000 to £40,000, and finally to £15,000, because Irishmen were drinking less whisky.—If an Irish administration had devised this plan, the English Press would have been very witty over it.


Again, there is perfect agreement that the Irish Poor Law system is disgracefully costly and inefficient, and a Vice-Regal Commission reported, many years ago, as to the lines of reform, but Parliament has had no time to attend to this matter, and there is no prospect that Parliament will have time to attend to it.


The Irish Railway System, an interest vital to the prosperity of the country, is admittedly in urgent need of reform. Again a Commission has reported and issued recommendations. There is no prospect whatever that Parliament will have time to attend to these recommendations.


And this list of necessary legislative work could be indefinitely extended. But to illustrate more fully the incompetence of British Government, both in legislation and administration, I give an extract from an article published by me in the Nineteenth Century:—

 


> 
> Let me illustrate first the mere question of convenience. Ireland is a country of wide rivers and long lakes and chains of lakes, which can only be bridged at great cost. The obvious solution is offered by pontoon ferries, and on Lough Corrib the Galway County Council proposed to establish one. Money was available, local money, and the plans were prepared; then the Local Government Board discovered that the Act of 1898 had omitted to give councils this power along with that of making roads and bridges. County councils cannot initiate private Bill legislation, and it was, 
> 
> 
> 
> 
> 
> ---
> 
> p.67
> 
> 
> 
> 
> therefore, necessary to introduce a Bill giving them the power to establish and maintain ferries, and this measure was got through the Committee stage. It was then blocked in the House by the action of a single English member, and all the entreaties and arguments addressed to him, not only by Nationalist members but by the leader of the Irish Unionists, were wholly vain. Government could not give the hour or so of public time necessary to put the Bill through, and the public inconvenience remains.
> 
> 
> I have chosen a trivial instance. But the transit question in Ireland is not a trivial thing. There is virtually general agreement that our whole railway system, and for that matter canal system also, needs to be put on a new basis; yet if we cannot get an hour of time to pass a small measure in which all Irish members are agreed, what chance is there of inducing Parliament to tackle the very large question of regulating transport all over Ireland—a question vital to the interests of an agricultural country? The same considerations apply to the huge problem of arterial drainage. No English Government is ever likely to approach it in any serious spirit; yet it is nearly as grave for Ireland as irrigation is for Egypt.
> 
> 
> Take another illustration. The city of Dublin has for many years been providing public libraries on a creditable, but by no means lavish, scale; and about three years ago, when the extraordinary ability, industry, and generosity of Sir Hugh Lane accomplished the formation of a gallery of modern art, the Corporation gladly proposed to charge on the Library Fund £500 a year for the housing and superintendence of it. While we were still congratulating ourselves on the acquisition, the Local Government Board discovered that upon a new interpretation of some clause the Corporation could not strike a library rate of more than a penny; and as a result the Board proceeded to surcharge members of the Corporation for the amount by which the existing expenditure on libraries exceeded that sum. Naturally the extra £500 for the gallery has never been paid, and for several years now the Corporation has been endeavouring to extend its powers in this matter. No one doubts that the extension should be given; but ministers, representing the Local Government Board, have endeavoured to exploit the Corporation's disabilities. They introduced an amending Bill which fixed on the county councils of Ireland certain other charges which the councils were sure to resist.
> 
> 
> 
> 
> ---
> 
> p.68
> 
> 
> Naturally, the measure is blocked; and since no legislation of this sort can pass except by unanimous consent of the House of Commons—for no time is available to discuss it—respectable citizens have been surcharged with large sums because they acted on a library committee, several public libraries are closed, and the gallery remains unprovided for, the Corporation being unable to accept what is, in great measure, Sir Hugh Lane's gift. I ask anyone, is this reasonable government?[2](javascript:footNote('E900030/note002.html'))
> 
> 
> 




#### English Administration in Ireland


I have been speaking so far of the administrative inconvenience in uncontroversial or non-party matters-which, indeed, is admitted on all hands. In graver affairs I maintain that there is also a consensus of condemnation upon the existing *regime*. Administration in Ireland is neither continuous nor consistent; it always yields to pressure and never to argument. In a word, it is of a nature certain to breed disorder and contempt for the law.


In Great Britain administration is hardly a party question. Until the Navy scare was sprung on us, the administration of this Liberal Government had hardly been challenged. In Ireland, from the moment a Tory Government takes office, or a Liberal Government, the whole spirit and direction of the administration is attacked without measure. In a word again, the existing system is condemned by both parties. Liberals declare it to be unsound, while even the most ardent Unionist will not deny that the principle of ‘resolute government,’ for which he stands, is periodically infringed by the advent of a Liberal *regime*. English ideas about the administration of England are in effect continuous, and so beyond doubt would Irish ideas be about the general administration of Ireland. But, as Mr. Long stated quite plainly in a speech just after he left office, Unionists cannot admit that Ireland should be governed according to Irish ideas; it is governed, therefore, according to English ideas of how the thing should be done, and these ideas change violently.


The Unionist inference is that you should keep Unionists continually in power. Well, as a matter of fact England

 



---

p.69




refuses to do so. But even with a long spell of Unionist government these fluctuations occur. We had, first, Mr. Gerald Balfour setting out to ‘kill Home Rule with kindness’; then came a period of reaction, and in 1902 one of these upheavals which, when a Liberal Government is in power, Unionists describe as a ‘saturnalia of crime.’ In that year about a dozen members of Parliament were in gaol; boycotting, rioting, and other forerunners of a legislative change were rampant. Then came Mr. Wyndham with his Land Act of 1903, and what Mr. Moore in a famous speech described as the ‘wretched, rotten, sickening policy of conciliation.’ After a few months Mr. Wyndham was thrown over, and Mr. Long brought in, to put the muzzling order in force.


Now let us consider these phenomena. In the first place, not one human being in Ireland believes that without the agitation—the lawless, violent agitation of 1902, centring round the de Freyne evictions—we should have got the Land Act of 1903. That is the moral writ large over a hundred years' history of the Union. Lawless agitation, which invariably at some point or other degenerates into crime, is the necessary prelude to any serious legislative reform.


That is the kernel of my case against the Union. Read the history of O'Connell's day, the Tithe War, the agitation for Emancipation; it is the same story; demands put forward in argument, argument ignored; demands put forward by violence, sooner or later acceded to. And in every case it is now apparent that the thing asked for was just and necessary.


#### Lord Salisbury on England's Government


Broadly, then, it does not seem to me that it can be denied that England, in the one hundred and ten years since the Union, has governed and is governing Ireland badly. I do not know that it is denied; it seems to have been admitted repeatedly by English statesmen of both parties. Take, for example, this utterance of Lord Salisbury—then Lord Robert Cecil—spoken in 1865:—

 ‘What is the reason that a people with so bountiful a soil, with such enormous resources (as the Irish), lag so far behind the English in the race? Some say that it is to be found in the character of the Celtic race, but I look to 





---

p.70




France, and I see a Celtic race there going forward in the path of prosperity with most rapid strides—I believe at the present moment more rapidly than England herself. Some people say that it is to be found in the Roman Catholic religion; but I look to Belgium, and there I see a people second to none in Europe except the English for industry, singularly prosperous, considering the small space of country that they occupy, having improved to the utmost the natural resources of that country, but distinguished among all the peoples of Europe for the earnestness and intensity of their Roman Catholic belief. Therefore, I cannot say that the cause of the Irish distress is to be found in the Roman Catholic religion. An hon. friend near me says that it arises from the Irish people listening to demagogues. I have as much dislike to demagogues as he has, but when I look to the Northern States of America I see there people who listen to demagogues, but who undoubtedly have not been wanting in material prosperity. It cannot be demagogues, Romanism, or the Celtic race. What then is it? I am afraid that the one thing which has been peculiar to Ireland has been the Government of England.’


No answer to the argument in this passage is given by pointing out that Lord Salisbury, in youth and age alike, was opposed to Home Rule. It has never endeared the Government of England to Ireland that those who condemn the system still advocate its continuance.




---

p.71


PART II
-------


### Is Ireland fit to Govern Herself?




---

p.72




---

p.73


### Chapter VII


#### Irish local Administration


So far we have endeavoured to show that the effects of the present and of the past prove that the government of Ireland according to English ideas has been a failure, and that the attempt to govern Ireland according to Irish ideas, from Westminster, has also failed, and must fail, owing to the fact that Parliament has not leisure to deal with Irish affairs, has not local knowledge of the local circumstances, and does not respond to the pressure of local opinion or to the sense of local grievances until those grievances find expression in desperate means.


Can we hope to establish a better arrangement? In other words, is Ireland fit to govern herself?


Well, all history points to the fact that civilised people are the best judges of their own needs, and can understand and manage their own business for themselves more efficiently than any outside power can manage those affairs for them. But in Ireland, we have the experience of Local Government since the County Councils were established in 1898. That experiment was set up among people, three-fourths of whom had been denied all share in public administration; and yet the result has been increased efficiency and economy. This can be illustrated in detail by an important pamphlet on the Irish County Councils which has been previously circulated and should be reprinted here. It was written in 1908:—




> 
> ### Self-Government in Being
> 
> 
> One of the chief complaints that Ireland makes, and has always made, against government from Westminster is its intolerable extravagance. Previous to the Union of 1801 Irish finance was most creditably managed. Before 1798 there had been practically no National Debt, and strict economy, appropriate to the circumstances of a poor country, was observed in every department of public expenditure. But ever since the Union reckless charges, possibly not 
> 
> 
> 
> 
> 
> ---
> 
> p.74
> 
> 
> 
> 
> inappropriate to the infinitely greater resources of the island of Great Britain, have been flung on the country, with such ruinous effect, that most Irish industries have been destroyed and a large proportion of the population driven into exile.
> 
> 
> ### Establishment of County Councils
> 
> 
> Until 1898, when a local council was set up in every county, there had been no opportunity of testing, under modern conditions, the justice of this complaint. Then financial autonomy was granted to each local council; they might be wasteful and extravagant, in accordance with the example which had always been set by Great Britain; or they might return to the natural instincts of the Irish people in favour of careful management of the proceeds of taxation. It is, therefore, of supreme interest to consider, now that eight years have elapsed since the new system was set up, what the course of events as regards expenditure and taxation has been.
> 
> 
> ### Difficulties in the Way of Economy
> 
> 
> Since 1839 a cumbrous, unsuitable, and costly imitation of the British Poor Law (set up on the opinion of an Englishman, in direct opposition to the findings of an Irish Commission) had to be maintained. Under Acts to build Labourers' Cottages, a rate ranging up to a shilling (now 1s. 3d.) in the £, and under Railway Guarantees, rates which frequently range up to several shillings, might have to be levied; and in other branches of county expenditure there was great extravagance, so that for many years before 1898 there had been a steady growth in the amount of local charges. Moreover, during the last eight years since they came into being, the new authorities had to cope with circumstances which made economy extremely difficult. Heavy pensions to former officials; and other burdensome initial charges of the new system, had to be paid. During the period, also, a new rate of a penny in the £ was levied for Technical Instruction. In the same period the rural rates in England and Wales had increased on the average by over 1s. in the £.
> 
> 
> ### Rates in Ireland
> 
> 
> It will be remembered that the concession of County Government in 1898 was accompanied by a grant from the Treasury to correspond with the Agricultural Rates grant made to Great Britain in 1896. Under this grant a sum 
> 
> 
> 
> 
> 
> ---
> 
> p.75
> 
> 
> 
> 
> equal to half the rates in the standard years 1898-99, was granted in respect of Agricultural Land, but not on Buildings, to each county. In the following tables the rates are shown from the first year after this allowance was made, and this accounts for the fact that two rates are levied in each county, and for the difference between the two.
> 
> 
> Only one county (Mayo) shows any considerable rise in the rates levied—1s. 4d. in the £ on Agricultural Land and 2s. 3d. in the £ on other hereditaments—during the eight years. This great rise is due, no doubt, to the fact that in Mayo the rate for 1899-1900 was abnormally low. In eight counties there were small increases from 2d. to 5d. in the £, in three counties there was no change; and in twenty counties there were such considerable reductions that, notwithstanding the large increases in certain counties just mentioned, the average total county rates for the whole country in the eight years show a reduction of 3d. in the £. The attached tables give the rates that were levied each year in every county and in the whole of Ireland, and a column is added which shows the average rate paid over the eight years. By comparing the latter with the first year, the general reduction becomes apparent.
> 
> 
> ### Imperial Taxation
> 
> 
> During the same eight years there was an increase of £825,000 in Imperial taxation, or nearly 10 per cent. of the whole amount levied. Thus, in the face of extraordinary difficulties, the portion of the nation's burdens which was entrusted reluctantly to the control of the Irish people is reduced, while that part controlled from Westminster is increased in about the same proportion as had been maintained in every decade since the Union. Not only has this notable reduction in county rates been effected, but a great improvement in efficiency has been secured. The roads have been better kept; greater local interest has been aroused in county institutions; the business part of the work has been better done; and none of the gloomy anticipations with which the new system was and is regarded by the enemies of Ireland has been realised.
> 
> 
> Could any better argument be adduced for extending to the Irish people full control over all their national affairs? [3](javascript:footNote('E900030/note003.html'))
> 
> 
> 






---

p.76


#### Table I

Showing the average Rate levied on Agricultural Land in

each County, and in the whole of Ireland, during each year from 1899–1900 to 1906–1907, and the average of the Annual Levy for the Eight Years.
*See file Countyrates1.pdf.*




---

p.77


#### TABLE II

Showing the average Rate levied on Other Heriditaments in each County and in the whole of Ireland during each year from 1899–1900 to 1906–1907, with the average of the Annual Levy for the Eight Years.
*See file Countyrates2.pdf.*




---

p.78


These calculations have only been made for the first eight years. Since then Parliament has not only added very greatly to the taxation of Ireland, but has also by legislation thrown many new burdens on the rates. But it can be said with confidence that the Irish local bodies have been as frugal in expenditure as Government allowed them to be. The Act of 1898 establishing these bodies was crammed with safeguards and checks upon the tendency to extravagance which was freely predicted by opponents of Irish liberty. Not one of all these pieces of machinery has ever needed to be brought into play.


Frugality has been the distinctive character of Irish Local Government, just as extravagance has been the special mark of English administration in Ireland.


So far, then, as Ireland has had the chance to show fitness for self-government, she has shown it fully.




---

p.79


### Chapter VIII


#### Is Home Rule Separation?


It has been established, first, that the grant of autonomy is a general principle of the British Empire; secondly, that the result of denying self-government to Ireland has been disastrous to the prosperity of Ireland and to England's prestige; and, thirdly, that there is every ground for believing that Irishmen will be at least as well able to manage their own affairs as any other people. It remains to examine the special ground upon which those who call themselves Imperialists and Unionists oppose the concession of Home Rule. The first, and main, argument is, that Ireland, if completely separated from Great Britain, will be a danger to the Empire, and that Home Rule would inevitably mean separation. The best answer to this is to define what Home Rule really means.


Mr. Redmond is often (and most unjustly) accused of putting his statement of Ireland's pretensions low in Great Britain, higher in Ireland, and highest in America. Here, then, is his definition of what Home Rule means, published in M'Clure's Magazine for October, 1910, to circulate in the United States while he was on his mission there in quest of the famous dollars:—


#### What Home Rule means—Mr. Redmond's Definition


Here, then, is ‘what Ireland wants’;

 ‘Legislative and executive control of all purely Irish affairs, subject to the supreme authority of the Imperial Parliament.’


In other words, we want an Irish Parliament, with an Executive responsible to it, created by Act of the Imperial Parliament, and charged with the management of purely Irish affairs (land, education, local government, transit, labour, industries, taxation for local purposes, law and 





---

p.80




justice, police, &c.), leaving to the Imperial Parliament, in which Ireland would probably continue to be represented, but in smaller numbers, the management, just as at present, of all Imperial affairs—army, navy, foreign relations, customs, Imperial taxation, matters pertaining to the Crown, the colonies, and all those other questions which are Imperial and not local in their nature, the Imperial Parliament also retaining an overriding supreme authority over the new Irish legislation, such as it possesses to-day over the various legislatures in Canada, Australia, South Africa, and other portions of the Empire.


This is ‘what Ireland wants.’ When she has obtained it, a new era of prosperity and contentment will arise. As happened when Lord Durham's policy was carried out in Canada, men of different races and creeds will join hands to promote the well-being of their common country. Responsibility, thrown for the first time for over a century upon the people, will have the same effect in Ireland as elsewhere.


Trust in the people will effect as startling and dramatic a transformation of feeling and sentiment in Ireland as in South Africa. Those of us who have been struggling in this cause for thirty years are thankful to feel that at last the fighting is practically over, and that all that remains is to settle the exact terms on which the Treaty of Peace is to be drawn up.


#### Is Separation conceivable?


More generally, it may be stated that separation could never be agreed to by Great Britain, and, therefore, that it is impossible, except as the result of war, in which England was completely defeated. It cannot be seriously contended that Ireland, possessing neither an army nor a navy under her own control, could defeat England in war. But Englishmen argue that, in the event of a European war, Ireland would be unfriendly, and would offer a welcome to the troops of any foreign country. The simple answer is, that, by everyone's admission, England's safety depends upon her maintaining command of the seas. While she maintains that command, no foreign Power can land a force worth considering in Ireland. If they could invade Ireland they could also invade England, 





---

p.81




and it cannot be doubted that they would choose the latter as a far more deadly stroke, whether at the prestige or the actual security of Great Britain.


#### Why should Ireland desire Separation?


From another point of view it may be asked what Ireland has to gain by separation. Her main industry is agriculture-which means the exportation of food, and for that England is not merely her nearest, but infinitely her greatest market. All possible economic ties link the two islands together. While we have, in Grattan's phrase, ‘the sea protesting against Union,’ we have also ‘the ocean protesting against separation’


#### Ireland's Position in the Empire


Secondly, it is advanced by some that to establish Home Rule for Ireland is a reactionary proposal. Although self-government for the Trans-Oceanic Dominions is a necessary condition of Empire, we are told that the whole development of the Empire is:—‘Towards federation in Blocks; that the separate position of Newfoundland, is an embarrassment to Canada; and that it would be a reactionary and unwise proceeding to dissolve the legislative union of Great Britain and Ireland at the very moment when South Africa and Australia have completed their union of local governments’


I may quote from the Nineteenth Century the answer which I have previously given to this argument:—

 ‘In so far as this argument means that the relations of England to Ireland must always be essentially different from those of Great Britain to Canada or Australia, it is unanswerable. England might very conceivably let Australia or Canada cut the painter without more than remonstrance; England could never conceivably let Ireland break away unless she herself had been defeated in war. We all recognise the geographical facts which govern the relation. It is at least arguable that Canada and Australia should have a separate military system; but, while Ireland remains subject to the British Crown, the military control of these islands must 





---

p.82




be unitary. Yet all this affords no argument against Home Rule. Those who quote against us the Union which has been effected in Australia, the Union which has been effected in South Africa, the Union which is desired between Canada and Newfoundland, ignore cardinal facts.’


#### What has Union meant in the Colonies?


What is the Union in South Africa? In the first place, it leaves the local governments existing, vested with very considerable powers for local affairs. The union with Ireland abolished the local legislature and brought Irish affairs under the control of an assembly which had neither time nor temper to consider them on their merits. In so far as it enacted separate beneficial treatment for Ireland, the Act of Union has been a dead letter. Legislation, when directed to industrial questions, has been framed solely in the interests of Great Britain; Ireland has had separate treatment only in the form of repressive enactments, and a desperate attempt to deal with the consequences of land-hunger.


Secondly, the union in the Colonies resulted from a voluntary compact between free States, and the members came together on a basis of equality. I have already quoted Professor Dicey's verdict on the character of the union with Ireland. It was not voluntary. That it does not after a century confer equality of privilege is proved beyond all possibility of argument by a single fact. The system of the Volunteer force was not, and the system of the Territorial Army is not, extended to Ireland. Ireland's position under the Union is that of a conquered country held down by force of arms. In plain language, the union between the federated Governments in Australia and Canada and South Africa is a reality: the union between Great Britain and Ireland is merely a specious name.


Thirdly, those who base an argument against Irish Home Rule upon the Colonial movement towards local union omit to consider what Home Rule means. Neither by Butt, nor by Parnell, nor by Mr. Redmond has a separate control of military affairs, or a separate interest in foreign negotiations, ever been claimed. On the contrary, these claims have been expressly repudiated. The demand for Repeal, which involved the re-establishment of a co-ordinate legislature, was formally abandoned for the offer to accept a subordinate legislature, having full control of Irish affairs.




---

p.83


‘the condition precedent’
#### The Party which desires Separation


‘We are told in reply that this cannot safely be done because there is a party in Ireland, and among Irish-Americans, which desires separation. No one denies the existence of such a party; the question is what are its numbers and influence? There are undoubtedly many men in England, there are probably some in Parliament, who would prefer a Republican Government. Yet they do not render the monarchical principle insecure, because the citizens enjoy all the reality of freedom. Under a different system of monarchy it is certain that their numbers would be very much greater. In a self-governed Ireland there would unquestionably be some Separatists; but how likely is it that they would induce the country at large to risk its freedom or its prosperity by going to war with England? For

 ‘the condition precedent’ of separation is a total destruction of the British Navy.’


Finally, upon this question of what may be called the Military Objections to Home Rule, Englishmen should be asked to consider certain aspects of it which I set out once in an article published by the Daily Mail, entitled ‘England's Broken Arm.’


#### The military Aspect of Home Rule


Englishmen very naturally pay little attention to what an Irish Nationalist may hold as to the true interest and the real glory of England. But an Irish Nationalist can perhaps direct their mind to the opinion and the feeling expressed by a great Englishman.


No man will deny that George Meredith, was a passionate lover of England, greatly jealous for her honour and her security. For her honour no less than for her security, he preached always the ideal of a people braced and





---

p.84




girded. Nevil Beauchamp, the hero of his most political novel, is Radical of the Radicals, but first and foremost sailor and fighting man. It is Meredith's insistence on this ideal—the ideal of an England, home of freedom, always alert and ready to draw the sword in defence of freedom—that gives a special weight to the utterance which I find this month in Scribner's Magazine, a poem simply entitled ‘Ireland.’ That poem is the dead man's appeal to England: For the sake of England's honour and security, he urges England to give freedom to Ireland—and, in giving freedom, to find valiant alliance where through all these years there has been only paralysed hostility. Here are the two central stanzas:—

 


> 1. She, generous, craves your generous dole;
>   
> That will not rouse the crack of doom.
>   
> It ends the blundering past control,
>   
> Simply to give her elbow room.
>   
> Her offspring feel they are a race,
>   
> To be a nation is their claim;
>   
> Yet stronger bound in your embrace
>   
> Than when the tie was but a name.
> * A nation she, and formed to charm,
>   
> With heart for heart and hands all round.
>   
> *No longer England's broken arm,*
>   
> *Would England know where strength is found.*
>   
> *And strength to-day is England's need*;
>   
> To-morrow it may be for both
>   
> Salvation: heed the portents, heed
>   
> The warnings; free the mind from sloth.
> 




I would gladly take these verses as a text from which to argue Home Rule before any audience of Englishmen, whatever their politics; but there is too much in the close packed thought to be fully expounded here. So I leave the question of the ‘blundering control,’ which unhappily is not past, nor will be so long as, under the Union, Tory and Liberal blunder alike, though in opposite directions. I make no attempt to show in detail what is meant by the need for ‘elbow room.’ I take simply the English aspect of the possibilities, what England might gain, what England is sacrificing to—I had better say, caution.


#### Irishmen and the Territorial Army


Surely there could not possibly be a more conclusive proof of the unreality of what is called the Union than the 





---

p.85




fact that while you are exhorting and entreating Great Britain to arm, you dare not even propose to raise a Territorial Force in Ireland. This demonstrates with a vengeance that ‘the tie is but a name.’


Englishmen, Scotchmen, and Welshmen who join the Territorials undertake not merely to defend their own country, but also Ireland; more than that, to hold Ireland against the Irish. If war came to-morrow, the Irish militia would be drafted out of Ireland, English Territorials would be drafted in, and would move among a population, theoretically under identical laws with themselves, yet essentially different in status.


There would, no doubt, be the Irish Yeomanry. Anybody who has read the history of 1798 will know what are the Irish associations of that honourable name. History changes little in Ireland. In 1520 Henry VIII. wrote to the Lord Deputy Surrey:

*The King's Army in England is the Commons, and the King's Army in Ireland is all such that oppress the Commons.’’*

That was literally true in 1798; it is true in its essence to-day.
Let me put my meaning in the most explicit way that I can. I personally hold it desirable, both for the individual and for the State, that every young man should learn the use of arms and undergo a period of military discipline, as he does, for instance in Switzerland. For that reason I hold with the idea of a Territorial Army, and were I an Englishman I should wish my sons to join it. But to me, as an Irish Nationalist, the British army means simply the ultimate force upon which British rule in Ireland rests; it exists to prevent Ireland from getting that which every other separate community of white men in the Empire enjoys. And that defines my attitude to the British army, and the attitude of every Irish Nationalist.


Meredith saw this. He saw that you have nominally united to you a population which by common consent produces admirable soldiers, and that under the present system you get no help from that population. The Irishmen whom you induce to take the shilling are not more numerous than the present army of occupation which you require to hold Ireland down, and which in the last resort can be ordered out to enforce, say, the legal decree under which Lord Clanricarde may propose to evict a tenant.


Meredith held that England's true interest lay, not in keeping Ireland disarmed and paralysed, but in having every 





---

p.86




man in Ireland able and ready to defend his portion of the United Kingdom—united under a true union, such as that which to-day binds the Transvaal to you. I hold with him: I hold that, although after so long a contest so swift a transformation as we have seen in South Africa is scarcely to be hoped, yet Great Britain would easily succeed in conciliating Ireland as she has conciliated her Colonies, through her interest and through her pride. But what I hold does not matter; the point is that Meredith, seeing plainly that the price of Ireland's friendship is Ireland's freedom, held that Ireland's friendship would be richly worth its price to his own country.


Not long after that article was written, Lord Roberts introduced a measure advocating universal military service. It was opposed by Lord Lansdowne amongst other grounds on this:—That if you establish general military service in England you must extend it to Ireland; and that this would endanger the State. No plainer avowal could be made of the fact that Ireland, after one hundred and eleven years of ‘union,’ is still in reality a conquered country, held down by force, whose weakness is held to be England's strength.


To learn to bear arms, to form regiments, is virtue and patriotism for Englishmen, Scotchmen, or Welshmen. It is a crime in Ireland.


#### Irish Soldiers


Yet consider the record of Irishmen in arms.


The Duke of Wellington said:—

 *It is already well-known to your lordships that of the troops which our Gracious Sovereign did me the honour to entrust to my command at various periods during the [Peninsular] war—a war undertaken for the express purpose of securing the happy institutions and independence of the country—at least one-half were Roman Catholics. My lords, when I call your recollection to this fact, I am sure all further eulogy is unnecessary. Your lordships are well aware for what length of period, and under what difficult circumstances, they maintained the Empire buoyant upon the flood 





---

p.87




which overwhelmed the thrones and wrecked the institutions of every other people; but they kept alive the only spark of freedom which was unextinguished in Europe.  
[*...*]  
 My lords, it is mainly to the Irish Catholics that we owe all our proud predominance in our military career, and that I personally am indebted for the laurels with which you have been pleased to decorate my brow.We must confess my lords, that without Catholic blood and Catholic valour no victory could have ever been obtained, and the first military talents might have been exerted in vain.’’*


There is no need to add to that illustrious testimony. It might be echoed by every general who has led England's armies in the pinch of danger, down to the latest of her wars. Thousands of graves in South Africa bear witness to its abiding truth.




---

p.88


### Chapter IX


#### Will Protestants be Persecuted under Home Rule?


The second line of argument which is commonly pursued is that if you give Home Rule to Ireland the Catholics, being in the majority, will certainly oppress and persecute the Protestants.


Now we know that the free Irish Parliament of Grattan's day consisted exclusively of Protestants—and Protestants then were as small a proportion of the people as to-day. The Irish Catholics were then labouring under far sharper grievances than at the present time; thousands of men were living whose fathers had seen the last of the great confiscations and the breaking of the Treaty of Limerick. Lord Clare said:—

 

 *The whole power and property of the country has been conferred by successive Monarchs of England upon an English colony, composed of three sets of adventurers who poured into this country at the termination of three successive rebellions. *Confiscation is their common title*; and from their first settlement they have been hemmed in on every side by the old inhabitants of the island, brooding over their discontents in sullen indignation.’’*


#### Protestant Patriot Leaders


Yet, this Irish Protestant Parliament extended political rights to their Catholic fellow-countrymen, and would undoubtedly have admitted them to full political equality. Does that look as if they were afraid of persecution?


Again, for more than a hundred years, the majority of leaders of the Irish people in the struggle for national 





---

p.89




freedom have been Protestants—and Protestants drawn from all classes.—Wolfe Tone was the son of a coachmaker; Lord Edward Fitzgerald, son of a Duke; Thomas and Robert Emmet, sons of a leading Dublin physician. All these men—three of whom lost their lives, and the fourth incurred banishment—were members of the Church of Ireland. Daniel O'Connell was a Roman Catholic, and, unlike the four I have named, refused absolutely to contemplate the idea of making war upon England. In 1848, the rebel, Smith O'Brien—an Irish landlord, brother of Lord Inchiquin—was a member of the Church of Ireland, as was Thomas Davis, the intellectual leader of the Young Ireland Movement. John Mitchel and John Martin, both convicted of high treason, were Presbyterians of County Down. The Home Rule Movement proper was headed by Isaac Butt, a Protestant barrister. Shaw, one of his ablest of his lieutenants, was of the same religion. Finally, Charles Stewart Parnell was a member of the Church of Ireland, and a landlord; Joseph Biggar, one of the best known of his followers, a wealthy Presbyterian merchant. And the Irish Party, since 1885, numbering eighty men, has always contained from eight to ten Protestants. Yet the rest of the House of Commons, numbering about six hundred, has seldom, if ever, contained more than five or six Roman Catholics; and no Ulster Unionist constituency has ever returned a Roman Catholic.


Everyone of these Protestants who took his part in the Home Rule struggle must have had many friends and relatives in Ireland of his own religion. Is it for an instant to be supposed that they would have advocated an measure which would lead to the oppression of those bound to them by such ties? But they knew and trusted the people of Ireland. One of them, Alfred Webb, who was bred in the Society of Friends, published, just before his death, in July, 1908, a small pamphlet called, Thoughts in Retirement.


#### The Views of an Irish Quaker


He gave in one sentence of that the historic reason for





---

p.90




the trust which Irish Protestant Nationalists feel in their countrymen:—



 ‘Ireland's record in the matter of religious intolerance is perhaps the best of any country. I know of but one case of *auto-da-fe* in her history.’


It is well to quote some other of the reflections set down in his old age by this Quaker philanthropist, who began his service to Ireland in 1848, fighting the famine, and sixty years later, having retired from Parliament, was still a trusted official of the National organisation.


‘Ireland's great fault is forgetfulness of past wrongs and too great easiness of temper towards those who stand between her and her rights.’


‘If the majority in Ireland knew as well how to boycott as do the minority they would long ago have obtained all they ask.’


‘How can it be feared that a Catholic majority would persecute the Protestant minority in Ireland, when Catholic minorities are anxious to live undisturbed amid Protestant majorities in other parts of the world?’


The views which he entertained were, and are, widely shared by the more intelligent and open-minded Protestants who lived in Ireland. For example, take this letter, written to the Spectator in reply to certain allegations put forward by Miss Richardson, a Quaker lady, who has since republished her statements in pamphlet form without reference to the contradiction given by members of the Society of Friends, writing from local knowledge:—


#### Letter from a Tipperary Quaker


‘Sir,—My attention has been directed to a letter from Miss Anne W. Richardson, of Moyallah, Co. Down, in your issue of March 18th last, which contained statements as to the state of feeling existing between Roman Catholics and Protestants in the South of Ireland.’


‘Miss Richardson may be an authority as to the state of affairs in the North-East of Ireland, but she has not lived in 





---

p.91




the South of Ireland, and she has not had the experience of social life there that I have had.’


‘I must be somewhat egotistical in order to establish my claim to be a competent witness, one who can give reliable evidence on this question. I am a member of the Society of Friends, and have spent my life as a trader at Carrick-on-Suir, Clonmel, &c., in the South-East of Ireland. I have taken an active part in the public life of my neighbourhood. I am a Justice of the Peace for the counties of Tipperary and Waterford, and have been for many years an elected member (and Chairman) of the County Council of Tipperary South and the Urban Council of Carrick-on-Suir and other public bodies. Ninety to ninety-eight per cent. of my constituents are Roman Catholics, and if

 ‘religious intolerance’ existed I would not have been chosen for these positions. As regards the willingness of Roman Catholics to elect Protestants to public boards, I may add that a Protestant Unionist and a Quaker lady were (the latter for many years) elected guardians of the poor at Carrick-on-Suir. A Quaker Unionist has for many years been vice-chairman of the Board of Guardians at Clonmel, and I could give instances of Roman Catholics, including priests, writing to place Protestants in posts of profit and responsibility when they were suitable for such appointments.’


‘With reference to Miss Richardson's statement about Waterford, the Salvation Army ladies there told me yesterday that they hold their open-air meetings without molestation, sometimes wearing uniform. One or two police are at times present as spectators, and this good order has prevailed for a long time.’


‘The case of the Salvation Army Officer who was injured on Waterford Quay about the year 1900 is an isolated occurrence, and if I remember rightly, tactfulness might have prevented friction. Within my own knowledge, two or more preachers, some in clerical costume, pray and preach at fairs in this district. They are listened to quietly, and are not molested, although they stand in the way of traffic, the country people drive their carts round them. It would be impossible to picture a better and more Christian reception. The fair folk are one hundred to one Roman Catholics.’


‘Three or four Protestants have, within the last few years, taken farms in this district previously occupied by Roman Catholics, and their relations with their Roman Catholic neighbours have been altogether harmonious.’




---

p.92


‘My father and mother and their family lived here through the disturbances in 1848 in William Smith O'Brien's time, and afterwards through the period of the Fenian troubles, but we never had any difficulty with our neighbours or any insult offered to us.’


‘I have, personally, no fear that whatever legislative changes may take place in the arrangements for the government of Ireland there will be anything to prevent Roman Catholics and Protestants from living harmoniously together in the land of their birth.—I am, sir, &c.,’


J. Ernest Grubb. Carrick-on-Suir, Ireland.
#### Admission of a Cork Unionist Paper


The Cork Constitution, commenting upon this letter of Mr. Grubb's, makes the following notable admission—notable, as coming from the principal Unionist journal in those parts of Ireland, where Protestants are in a small minority. Quoting Mr. Grubb's view that" whatever legislative changes might take place, there would be nothing to prevent Protestants and Roman Catholics from living harmoniously together it adds (May 2nd, 1911:—


‘Few will be found ready to take serious exception to this statement, for it is not so much religious as political intolerance that is feared by the minority in Ireland.’


What the Cork Constitution means by political intolerance is, that Irish County Councils will elect as public officers persons in sympathy with their own political views. If this be persecution, then political persecution is universally practised in Great Britain.


To illustrate more fully the widespread testimony of Protestants to the tolerance of Catholic Irishmen to-day I give some extracts from a leaflet concerning ‘Protestant Opinion and Home Rule’:—


#### Testimony by Church of Ireland Clergymen


Here is first a letter addressed to the Guardian of 30th June, 1909, by the Rev. Canon Courtenay Moore, rector of 





---

p.93




Mitchelstown, Co. Cork, replying to another in the previous issue. It will be observed that Canon Moore's instances are all drawn from one parish, which differs in no respect from the rest of the country, save perhaps in the generous candour of its rector:—


#### The Rector of Mitchelstown


Your correspondent says:—‘The introduction of local government has placed all power and patronage in hands hostile to the Church. No Protestant doctor, nurse, or other official need apply for any elective appointment.’ This generalisation is too hasty and too sweeping; it would not apply in Ulster, for instance; but even in Roman Catholic provinces it does not always hold. Let me give a few instances.


In this parish alone some time ago the Local Board or Council elected an English lady-nurse, who was also an English Churchwoman, to the chief position in the local Union.


The same authorities elected an engineer, who is a member of the Irish Church, a little later on to the position of District Surveyor.


Another young man, also a member of my congregation, was elected Petty Sessions Clerk, though there was s Roman Catholic candidate in the field.


Furthermore, a few years ago a young man from the North came here and started business as a grocer; he also is a member of the Irish Church. He has done exceedingly well; he is a good and obliging man of business, and, so far from being boycotted, he is doing the best trade in the town in his own line—even the nuns and Christian Brothers patronise him. Let me say a word about myself. I am not a Home Ruler; yet I have, without the slightest solicitation on my own part, been unanimously elected a member of the County Committee of Technical Instruction, of which the Roman Catholic Bishop of the Diocese is Chairman.


The prosperity of Protestant Shopkeepers in Catholic districts can be shown from every town in the South and West.


#### The Rector of Mallow


Once more —On October 11th, 1910, the Rev Canon Fawcett, Rector of Mallow, speaking before the Protestant 





---

p.94




Church Conference in Belfast, used these remarkable words:— *If we get Home Rule, I do not anticipate any dire disaster to the Church in the South; and I am glad to bear testimony to the kindly consideration and the cordial generosity which have always been extended to me by Catholic neighbours in the County Cork. I cannot believe that this happy relationship would be altered under a Home Rule Government. What we do fear is that some stupid Government will arise and impose upon us a bogus Home Rule, which will not satisfy Nationalist aspirations, and which will only plunge the country into another period of unrest and unsettlement.’’*


#### The Rector of Ovoca


‘The Rev. J. M. Robinson, Rector of Ovoca in County Wicklow, in a remarkable little book, Facts from Ireland, which may be heartily recommended to all Englishmen, says:—‘ I believe all that is wanted to make good friends of the North and South is for the representatives of both sides to meet together and know each other better, and this they would do in a Parliament in Dublin. They will never do it in Westminster, for there are too many side issues drawing them apart. There are hot politicians in both parties, but wherever the best men have met, the result up to the present has been friendliness, respect and co-operation. I have no doubt but that the pick of the country would be returned to a Home Rule Parliament.’’


#### The Rector of Kenmare


In the recent General Election the Rev. Geo. M'Cutchan, Rector of Kenmare, in Co. Kerry, wrote as follows to Mr. Boland, M.P. for that division:—*I have for over thirty years lived in the midst of a population chiefly Roman Catholics, and I have found them kind and obliging neighbours, from whom no sign of persecution has ever been manifested. There is absolutely no reason to distrust them in the future. I believe there is not in Ireland a locality where a Protestant clergyman may more peacefully and securely discharge all his duties than in the County Kerry. The time is close at hand when all Irishmen will be called upon to forget their controversies and live together in peace. I have no doubt that they will loyally respond to the call.





---

p.95




Everyone now expects an Irish Parliament and Self Government, and those who have had no politics desire its success.’’*


#### Testimony of free Churchmen


Thus far the testimony of Church of Ireland clergymen has been given. What adds to its weight is that every man who speaks in this sense injures his own interests. Many liberal-minded men have been deterred from entering Orders in the Irish Church because their political views would have made even the humblest advancement difficult for them.


A remarkable correspondence, prolonged over some weeks, in the Methodist Times makes it clear that the same holds good of Free Church divines in Ireland, and evidence will be found in numerous passages throughout that correspondence.


#### A Temperance Lecturer's Experience


But let us cite the eloquent speech delivered by the Rev. Charles Williams at a meeting of the Irish Association for the Prevention of Intemperance. The Churches work separately in this great cause, and the famous ‘Catch-my-Pal’ movement was started in avowed imitation of the Catholic League of St. Patrick. Yet on occasions all denominations meet, and it was at such an occasion Mr. Williams spoke in the Rotunda at Dublin on February 16th.


#### Joint Advocacy of Temperance


‘I have never,’ said the Methodist clergyman, ‘been insulted yet by an Irishman in any part of this country. We hear a lot about toleration up North, but I must say this, when I want toleration I find most of it in the South. A Catholic band paraded the streets of Dublin for two hours, and gathered a crowd of 3,000 people to listen to me, a Methodist minister, and gave me as kindly a reception as if I was one of their own priests. I got a reception that I shall remember as long as I live. A little while ago I said in the North that the men of Dublin are setting an example in toleration and in broadmindedness that all Irishmen, and particularly Northern Irishmen, would do well to copy.’




---

p.96


#### Roman Catholic Tolerance


Mr. John A. Duncan, J.P., Athy, Kildare, writes:—




> 
> I live in a part of Ireland where the proportion of Protestants to Roman Catholics is one in ten, and, lest my name should lead to a mistaken impression, let me say that I represent the fourth generation living and doing business in the town of Athy.
> 
> 
> The facts of the recent history of Ireland are against the theory of intolerance on the part of the Roman Catholic people of Ireland. Since Nationalism became a highly organised movement the Nationalists have held the Protestant population of three-quarters of Ireland in the hollow of their hands. They could have quietly squeezed us out, and they always have had a plausible excuse at hand in the bitter and often violent attitude of a section of Protestants and the Press that represents them. But instead of showing resentment, the bulk of the people, and even the much abused priests, have made allowance of Protestant fears, and have freely given even pronounced Unionists among us their support and often their sympathy. They have done more.
> 
> 
> They have supported us at the polls in local elections. At the recent Urban Council election here a Methodist local preacher headed the poll, a Church of Ireland Unionist came one behind him, and then followed three Roman Catholic members. There are nine Protestant members of the Rural Board, and several on the County Council. In Carlow, Wicklow, Wexford, Naas, Athlone, Drogheda, Kilkenny, and doubtless other towns Protestants get elected, though in none of these cases would they have even a remote chance if they had to depend on Protestant votes. Furthermore, even in positions of emolument we get an occasional chance, though it is everywhere recognised all the world over that spoils of office go to the majority. Recently we had an English Methodist and the daughter of an Irish Methodist minister employed by the Carlow County Council in good permanent posts, and both did our Church sterling service during their stay. The agricultural instructor of the County Kildare is a Protestant; one of the most efficient local preachers on this circuit is a master in the Knockbeg Roman Catholic College; there is, or was, a Protestant young lady a technical instructress in Athlone. The fact is, Irishmen of all creeds are being drawn closer together and the old suspicions and jealousies are beginning to die out, and there is 
> 
> 
> 
> 
> 
> ---
> 
> p.97
> 
> 
> 
> 
> a brighter day before us if we are allowed to work out our own salvation in our own way.
> 
> 
> 




#### The Protestant Mayor of Wexford


Of course, Protestants of Nationalist views are at no disadvantage, but rather the reverse, as is proved by the many instances in which they have been elected to the Irish Party, and by later instances, such as that of the recently chosen Mayor of Wexford, Mr. Howard Rowe.


Mr. Rowe writes to the Methodist Times:— *Allow me to say a word on the matter. In our Wexford Corporation there are only three Protestants out of twenty-four members, and those three are Methodists. By a spontaneous, unanimous and unsolicited vote I have been elected Mayor of Wexford, which is in itself an instance of kindly toleration.’’*


After asserting that the Land Purchase Act was due not to Unionist policy, but rather to constant exertions of the Irish Party, Mr. Rowe continued:—*I boldly declare that every good and useful measure passed during the last thirty years by the British Parliament for Ireland is due to the Irish Nationalists, and not to the Irish Unionists. No men worked harder to obtain relief from excessive taxation than the Nationalists, while Unionists stood by scoffing, and we would have heard nothing about deliverance from unjust landlordism or about the Labourers Acts, or the Working Class Dwellings Acts, or the Town Tenants Acts, or even the light railways or the Congested Districts Board, were it not for the action of the Irish National Parliamentary Party.’’*


#### Would Home Rule be Rome Rule?


‘On January 7th in the Rotunda at Dublin, Dr. Butler, a very learned Carmelite, lectured upon the history of the proposal that Irish Catholic bishops should be appointed subject to the veto of the British Government. Emancipation was offered as a bribe for acceptance; but three times the proposal was defeated, and on the first two occasions the Catholic laity of Ireland were led by the Protestant Burke. In its final form, it had behind it in Ireland ten Catholic Irish Bishops, three Archbishops, innumerable priests.’ It was accepted in a rescript from the Secretary of the Propaganda; Cardinal Gonsalvi, Secretary of State 





---

p.98




for the Papal Government, came to negotiate its passage; and the Pope was avowedly in its favour. How were all these influences met? They were met ‘by the mass of the Catholics of Ireland.’ That is the story which to-day an eminent Irish ecclesiastic chooses to recall in every circumstance of publicity, with Mr. Redmond (whose words have been quoted) in the chair.


#### A Maynooth Professor


Irish priests have always prided themselves on the attachment of their people; they have never prided themselves on their servility. Some of the ablest men in the Irish Roman Church have recognised that Home Rule would limit the temporal influence of the priesthood (as local government has already limited it), and they rejoice that it should be so. That view was put explicitly on December 30th by the Very Rev. Dr. Beecher, a Professor of Maynooth, in a speech at the unveiling of a memorial to Father Casey, of Abbeyfeale, a great leader in the political fight, yet none the less a true shepherd of his people.


Dr. Beecher said:—‘Friends, the constitutional battle has been fought, and, for the most part, won. Only a little while and we shall see the consummation of our hopes, limited, no doubt, as compared with those countries that are nations in the full sense, but sufficient to promote the peace and prosperity, and to satisfy the legitimate craving of a country that has ever yearned for the right to manage its own affairs. And when that day comes what will be the outcome? We often hear it said that it will be the end of the political influence of the priest, and that it will mark the alienation of priests and people. That it will mean in large part the end of the priests' political influence, personally, I have no doubt. And if I know the Irish priests aright, I should say that none will be more willing than they to forego save as citizens much of the influence they wielded in the past.’


#### Are industrial Interests opposed to Home Rule?

### Lord Pirrie's Opinion


Finally, it is alleged that all the industrial interests of the country are controlled by Protestants, and are opposed





---

p.99




to Home Rule. Yet in December, 1910, a political manifesto was issued by Ulster Liberals from which the following passage is a quotation:—


In our opinion the time has at length arrived when the question of self-government for Ireland—the fierce battleground of a hundred years' ceaseless strife—can and will be wisely settled with a due regard to the Unity and Integrity of the Empire on the one hand, and to the just desires and aspirations of the Irish people on the other.


#### The Business Reasons for Home Rule


Nor can any man exaggerate the importance of that settlement to our country. For nearly a century the question of Home Government has barred with triple steel every door of progress. It has paralysed the energies of the country and diverted the current of national activity into the unfruitful channel of incessant political struggle. But, indeed, it could not fail to do otherwise. For a hundred years the vast body of the Irish people have had neither sympathy with nor confidence in the Executive and Administrative Government of Ireland. That Government has no natural root in the soil of Ireland. Bureaucratic government cannot soar on ampler wing. Forty-two Boards without correlation or connection, and almost without responsibility, control the destinies of Ireland. As Liberals, we prefer the Government of the People. Circumstances and conditions have greatly changed since 1895. The question of Higher Education has been definitely solved and permanently settled. The greater part of the land of Ireland has passed into the hands of the tenants, and the history of landlordism has reached its concluding chapter. Serious crime as a consequence is practically unknown. But most important of all, twelve years' administration by Irish County Councils has proved by its wisdom and integrity and even-handed justice the claims of Irishmen to manage their own internal affairs.


#### Who are the Intolerant?


You will remember that Lord Salisbury declared that he would prefer Home Rule for Ireland to the system of Local Government which has since proved so successful. Events have falsified his prophecy, and demonstrate that





---

p.100




they who trust their countrymen are the best friends of their country. For our own part, zealous Protestants as we are, we have perfect confidence in our Catholic fellow-countrymen. In the South and West of Ireland, goodwill and brotherly kindness are universal. Religious dissensions are unknown. We confess with shame that it is only in Protestant Ulster that intolerance and bigotry have a vigorous growth. Yet even in Ulster many changes have taken place since 1895. Moderate men are everywhere awakening to a true sense of their responsibility, and we trust that the union of Irishmen of all creeds and classes is being slowly cemented in an enduring bond. Our position as Protestants and Ulster Liberals appears to us to be plain and clear. Our Nationalist fellow-countrymen desire no separation from the Imperial Union. We should listen to no such suggestion. We are proud of our share in the glory and renown of the Flag under which we were born, and under which we hope to die. We are true Unionists in the best sense of the word. A sullen, discontented, hostile Ireland is a source of weakness; a contented, pacified, and prosperous Ireland will give us a new strength and solidarity. Only a large and generous measure of Home Government can achieve that happy result.


#### Protestant Home Rulers


The first signatory to this remarkable document was Lord Pirrie, Chairman of Harland & Wolff's, and as such the greatest ‘captain of industry’ in Ireland. Amongst others with him were Sir Hugh Mack, one of the chief linen manufacturers in Belfast, and Mr. Shillington, head of a big spinning mill in Portadown.


Outside of Ulster, it may be noted that the woollen industry, once Ireland's chief resource before English legislation stamped it out, is reviving, and reviving in the hands of staunch Home Rulers. Mr. Smith, at Athlone, who employs hundreds of workmen in a steadily growing business, is a Protestant supporter of the Irish Party; the highly successful woollen mills at Galway are run by Catholic Nationalists, as are also Morrogh's, Mahony's, and O'Brien's mills in Cork, whose output is regaining for Ireland her place in the top of the market.


Finally, it should be observed that among Lord Pirrie's co-signatories was Mr. Edward Archdale, of Castle Archdale, a landlord whose family name has always been associated





---

p.101




with opposition to Home Rule. In the 1906 Parliament only one great resident Irish landlord was a member, Mr. Walter MacMurrogh Kavanagh, who was a member of the Irish Party. These men are notable cases in a process which is rapidly extending the conversion of the younger generation among the Irish land-owning class to Nationalist opinions. It should be remembered that Lord Dunraven, Colonel Hutcheson Poe, and their group, though opposed to Mr. Redmond's party and to the Liberal financial policy, are professedly in favour of self-government for Ireland.


Many Protestant farmers are for Home Rule; the Pirrie manifesto was signed by Mr. Joseph Kerr, one of the largest and most progressive farmers in County Down. In the South of Ireland Mr. Robert Gibson, of Limerick, a pioneer of the creamery system, and one of the greatest authorities in the butter industry, supported the Nationalist candidate in eloquent speeches from the platform last December.


#### The Record of Irish local Bodies


It is said again by those who recognise that Protestants would not be in any danger, that all the avenues of public employment would be closed to them in districts where Nationalists prevailed. Here, again, it is well to quote Mr. Alfred Webb:—


If there were not a single Protestant in a position of trust in the government of Ireland it would be less unfair, considering the relative proportion of religions in the country, than was the condition of things in the old days of complete Protestant ascendancy.


Those who announce most loudly their fears of religious intolerance are the people who, when they had the power, excluded the majority of Irishmen from all preferment, and who, in so far as they retain the control of patronage, give a monopoly of it to their own political sect. I reprint here a leaflet dealing with the comparative record of Unionist and Nationalist public bodies in Ireland:—


Mr. Balfour recently gave it as his opinion that ‘The Local Government Act is being used in every county in Ireland where the Nationalist Party have a





---

p.102




majority.   
[*...*]  
 as a great electoral machine for promoting the party interests of a particular section, even though the really essential local interests are fatally sacrificed thereby.’


Mr. Long repeated the charge, and drew the same conclusion, that it would not be safe or fair to the minority to extend in any way the power already possessed by the majority in Ireland.


Let us examine this contention in the light of facts.


#### What the Nationalists do


It is quite true that wherever Nationalists are in an electoral majority they return Nationalists to the County and District Councils.


Why not? Do Liberals elect Tariff Reformers to represent their views? Had Unionists been chosen as popular candidates, the fact would undoubtedly have been used as an argument to prove that the Irish Party does not represent the mind of Ireland.


Mr. Balfour's accusation applies with more than equal force to the Irish Unionists. Elections are everywhere in Ireland conducted on political issues: the difference between the parties lies in this, that the Unionists impose a religious test also.


No Catholic in Ireland is to-day elected by a Unionist electorate to a seat in Parliament, on a County Council, or even on a District Council.


That Irish Nationalists have no objection to be represented by a Protestant is sufficiently proved by the fact that the Irish Party of eighty-one comprises nine Protestants. Contrast this with Great Britain, which returns only five Catholics among its 567 members.


In certain cases Nationalist bodies in Ireland have agreed to give to Unionists a larger representation than they could secure at the polls; at Newcastle, in County Down,

 Nationalists agreed to leave six seats out of twelve, which they could have secured, to the Independent Unionists. At Birr, where Nationalists are eight to one, seven seats out of twenty-one are conceded to Unionists by agreement.


Individual Unionists who have shown good will and capacity are welcomed on public bodies. Thus, Lords Dunraven, Monteagle, and Killanin, Colonels Everard and Hutchinson Poe, have been repeatedly either elected or co-opted 





---

p.103




to local bodies, and have been given prominence on important committees. In Donegal, Captain Stoney, D.L., is vice-chairman of the County Council.


But the real contention of Tory critics is that Nationalists ought to elect Unionists to represent them as a general rule. That they are capably represented, that the Councils do their work economically, is admitted in all reports of the Local Government issued since 1900. Dublin Castle admits the efficiency of the local bodies. So did Mr. Gerald Balfour and Mr. Wyndham.


#### Efficiency of the Councils


In 1900, the first report said:—*The County and District Councils have, with few exceptions, properly discharged the duties devolving upon them.’’*


1903—*The general administration of the Local Government Act by County and District Councils continues on the whole to be satisfactory, and the manner in which the several local bodies transact their business calls for no special observation. The collection of the rates has been efficiently carried out. Very great and very creditable improvements have taken place in the care of the sick.’’*


Later reports naturally make no general criticism of what is now a well-established system, but the report for 1906 acknowledges, e.g., valuable suggestions made ‘by local bodies as to Rules under the Labourers Act,’ and there is not a word in it to bear out Mr. Balfour's observations.


But the real question is not one of efficiency, for the efficiency, and more specially the economy, are generally admitted. It is this:—Do the minority get fair play?


#### What the Unionists do


Wherever Unionists are the majority, they do not.


In Armagh there are 68,000 Protestants, 56,000 Catholics. The County Council has twenty-two Protestants and eight Catholics.


In Tyrone, Catholics are a majority of the population, 82,000 against 68,000; but the electoral districts have been so arranged that Unionists return sixteen as against thirteen Nationalists (one a Protestant). This Council gives to the Unionists two to one majority on its Committees, and out of fifty-two officials employs only five Catholics.




---

p.104


In Antrim, which has the largest Protestant majority (196,000 to 40,000), twenty-six Unionists and three Catholics are returned. Sixty officers out of sixty-five are good Unionists and Protestants.


Down and Derry counties exhibit the same features. Wherever Unionists have a majority on the Council, they give themselves a virtual monopoly of all lucrative employment. Only the meanest posts are conceded to Catholics.


#### Ulster Counties controlled by Nationalists


Now take the other side. Sectarian bitterness is admittedly most felt on both sides in Ulster. Consider the case of Monaghan. Catholics are 54,000, and Protestants 19,000. Nationalism shows its strength at the ballot box, as a demonstration of principle, returning twenty-five Catholic Nationalists, and only two Unionists. But how does this body administer? Of seats on Committees appointed, eighty-three are held by Catholics and thirty-six by Protestants. The paid officers are thirty-four Catholics and twenty-three Protestants.


It may be said that the County Council of Monaghan did not choose its officials. All the Counties took over the staff appointed by the old Grand Juries, which was Protestant and Unionist almost to a man, even in the most Catholic counties. That was the example which the local bodies found before them. Everyone of these officials could be dismissed by the Councils, if they choose to display intolerance. They do not. On the contrary, in Monaghan, only the other day a Protestant doctor secured, in competition with Catholics, the valuable headship of the County Asylum.


Everywhere in the Catholic parts of Ireland, Protestants hold a share of the public salaries wholly disproportioned to their numbers. Even at Ballinasloe, where a recent appointment was sharply challenged, Protestants to-day receive £1,003 out of £2,115, spent annually by the Asylum Committee.


We challenge Protestant Ulster to show a single case where a Catholic Nationalist has been elected by a public body controlled by Unionists to a post of over £200 a year.


For a final contrast take two adjacent counties, Cavan and Fermanagh.


In Fermanagh, a Protestant minority has got hold of 





---

p.105




the representation. A population of 36,000 Catholics and 29,000 Protestants return ten Catholics and seventeen Protestants. The Unionists give themselves fifty-five to twenty two seats on the Committees: and fifty-eight to seventeen on the list of officials. They pay £5,071 to Protestants and £639 to Catholics. The highest salary received by any Catholic is £55.


In Cavan, 79,000 Catholics and 18,000 Protestants return a Council exclusively Catholic and Nationalist. Yet this Council employs twenty-six Protestants as against thirty Catholics. A Protestant official gets £600 a year; no Catholic more than £300.


#### Belfast and Derry


Municipal Corporations show the same tendencies. In Belfast, Catholics are a third of the population, but the Corporation pays £51,405 in a year in salaries, of which only £640 goes to Catholics.


In Derry, where Catholics are an actual majority of the population, the Corporation pays £6,663 to Protestant employees, and £169 to Catholics.


Nothing of this unfairness can be found in Dublin. Twenty-three times since 1843 has the Lord Mayor been a Protestant. No Catholic has ever held that office in Belfast. In Dublin, at the present moment, a long list of the best paid positions are held by Unionists; while the North Dublin Union are actually being surcharged by the Local Government for insisting upon pensioning a Protestant Chaplain.


To sum up, it can be confidently asserted—


First, that Nationalist Ireland has set to Unionist Ireland a much needed example of religious and political toleration. Secondly, that wherever Protestants are in a minority, however small, they receive their full proportional share of representation on Committees, and more than their full share of salaries; and that wherever Unionists are in a majority, they use it to exclude the Catholic minority so far as possible from either influence or preferment.>


The truth is, that when Protestants declare they will not get fair play under Home Rule, what they really mean is that they will not get preferential treatment. Up to the present, of the enormous number of posts which 





---

p.106




Government can bestow in Ireland, Unionists are given more than 90 per cent. when a Unionist Government is in power, and more than 50 per cent. under a Liberal Administration. On all the mixed Boards—for instance, the Board of National Education or of Intermediate Education—Protestants, who are representing less than one-third of the population, are given half the membership. This system cannot be defended by any democratic principle, and it would certainly not be continued under a democratic Government.


#### Protestant Shopkeepers thriving on Catholic Custom


But one indisputable fact proves that Irish Protestant Unionists have no occasion to fear unfair treatment in a self-governed Ireland. In every town of the South and West of Ireland, where Protestants form one in ten to one in fifty of the population, the Protestant shopkeepers are found doing a good business, and often the best business in the place, on Catholic custom. A Methodist Minister quoted to me, with amazement, a case which had come to his notice of a Methodist tradesman in such a town. He had two Roman Catholic Bishops on his books. The fact will surprise nobody who is familiar with Ireland. Priests and nuns are frequently the best customers of Protestant shops.


English readers should ask themselves whether a Nonconformist tradesman would be likely to prosper in a town, 95 per cent. of whose inhabitants belonged to the Church of England, or whether a Church of England shopkeeper would do a good business in a town where Churchmen were only one in fifty.




---

p.107


PART III
--------




---

p.108




---

p.109


### Chapter X

### Will Ulster fight?


[A leaflet answering this question may be here

reproduced.]


When Catholic Emancipation became imminent the Orangemen talked exactly as Captain Craig talks to-day. The Dublin Morning Post of December 11th, 1828, reports Mr. Judkin Butler as concluding a speech thus:—


> 1. Surrender! no, we never will
>   
> While Brunswickers have blood to spill.
>   
> Our cause is glorious, and for that we'll fight.
> 




Well, they did not fight, and so that crisis passed away. Forty years later came Church Disestablishment. The Rev. H. Henderson said, before a great Orange meeting in Co. Tyrone:— 

 *They would sacrifice their lives before they would allow their religious rights to be taken from them. Yes, with the blessing of God, they would do what their fathers did at Derry, Aughrim, and at the Boyne. So far as he was concerned, let there be no mistake. He spoke now not rashly, but calmly and deliberately. Mr. Gladstone and his coconspirators *were driving the country into civil war*.’’*


At a meeting at Newbliss, Co. Monaghan, on March 20th, 1868, the Rev John Flanagan said:—*If they ever dare to lay unholy hands upon the Church, 200,000 Orangemen will tell them it shall never be. Protestant loyalty must make itself understood. People will say, ‘Oh, your loyalty is conditional.’ I say it is conditional, and it must be explained as such. Will you Orangemen of Ireland, endorse the doctrine of unconditional loyalty? (Repeated cries of ‘No, never!’) It appears wonderful that there is one thing upon which we can confidently throw ourselves, and which has been overlooked by





---

p.110




nearly all speakers—I mean the Queen's Coronation Oath. She should be reminded that one of her ancestors, who swore to maintain the Protestant religion, forgot his oath, and his crown was kicked into the Boyne. (He then read the oath, and the questions put to the Archbishop of Canterbury at the time of the coronation.) Will any Minister dare to ask the Queen to perjure herself? Will any Minister come and ask us to surrender our rights? We must tell our gracious Queen that if she breaks her oath, she has no longer any claim to the Crown.’’*

Northern Whig, March 21st, 1868.


Mr. Richard Lloyd, Deputy Grand Master of the Orangemen, thundered forth as follows on June 7th, 1869, on Tamnamore Hill:—*Their fathers had marched to the Boyne, and bled for their country. Their blood still ran in the veins of those whom he addressed. They were as many and *as ready, at the beat of drum, to go out and take their Minie rifles*, and march to that river, as their fathers did before them.’’*


Many other speeches were delivered to the same purpose, yet nothing came of all this bluster.


#### Judge Rentoul's Opinion

### What Captain Craig's Predecessor thinks


Perhaps memory of these historic facts prompted His Honour Judge Rentoul, an Irish Protestant Unionist, to make in 1906 (when a measure of devolution was expected) a very remarkable speech.


Judge Rentoul had heard this clamour of Ulster fighting renewed in 1886, when the first Home Rule Bill was proposed. He had helped to renew it in 1893, since from 1890 to 1902 he sat as member for East Down, the constituency which Captain Craig represents to-day. Here, then, is what Captain Craig's immediate predecessor in title thinks of the matter. The report is from the Irish Independent of August 30th, 1906, and the speech was delivered at a Presbyterian Church with a Protestant clergyman in the chair. Judge Rentoul said:—

*Inside twelve months, in all probability, there would come a very considerable change of government. Speaking as a politician of considerable experience, and speaking to 





---

p.111




the inhabitants of his native parish, he firmly expressed the belief that no change would be made that would do them harm or injury of any sort whatever (hear, hear). *He always believed that the cry of ‘Ulster will fight, and Ulster will be right,’ was a wicked and lying cry*.’’*

Irish Independent, August 30th, 1906


Ten years ago, he said he wrote to the papers on the subject, saying such a cry was not true, and trying to point the real truth out. He always held that, simply as a political argument, attacks on the Catholic Church were a foolish and ridiculous mode of procedure. They knew well that human nature lay at the bottom of the whole of them, and if the clergymen that they belonged to were attacked they would assuredly defend them, no matter whether they liked the individuals or not.


He felt that in a country where the bulk of the population professed a religion different to theirs, the throb of the Orange drum right in the faces of their countrymen was wrong. When he went over to English platforms and talked about Ulster fighting, everyone laughed at them; *the thing was ridiculous and could not be done*.


#### The Daily Mail Report


This year, after the General Election, the cry revived. Ulster was not merely going to fight: she was arming. Dozens of excited leading articles appeared in the London Press. Then one paper, the Daily Mail, had the enterprise to send over a correspondent who should collect not rumours, but facts. Here is the first paragraph of his report, published on January 19th, 1911:—
> 
> No preparations are in progress at present anywhere in Ulster for armed resistance to Home Rule. The reports that large sums of money have been subscribed and large quantities of arms purchased with the view of concerted military measures-are mere reports. No arms are being imported either openly or surreptitiously beyond the normal demand of the trade.
> 
> 
> Since then there has been very little talk of Ulster fighting. The bluff had been carried too far.
> 
> 
> 




But it is said, even if a Home Rule Bill is passed into law Ulster will resist, and it will be impossible for England to use British troops to put down the loyalist minority.

 



---

p.112




One may ask, first, if loyalty is the right word for the feelings of those who are loyal only when they get their own way. Three Parliaments in succession have been strongly in favour of Home Rule for Ireland. Can it be seriously contended that a section of the population in one corner of Ireland have the right to resist the declared will of that Imperial Parliament to which they express their allegiance. Is it loyalty to rebel, in sheer excess of loyalty?


But a threat of armed resistance in Ulster is no new thing, and it cannot be taken seriously—provided Ulster gets fair play. If she does not, she is certainly strong enough to make it difficult and dangerous to wrong her.But no one wants to. Unionists freely repeat a calumny which I take here as it appears in the A. B. C. of Home Rule:—


#### Mr. Redmond and Ulster


‘Irish Unionists also bear in mind Mr. Redmond's well known declaration not long ago, referring to those Irishmen who opposed Home Rule, that ‘after all, in reality, they are only a handful even of the Protestants of Ulster, and I fear they must be overborne by the strong hand.’’


It is a gross misrepresentation to say that Mr. Redmond spoke of ‘those who oppose Home Rule.’ What he said is here given:—


Mr. Redmond, speaking in the House of Commons on 12th February, 1907, said:—


> 
> I was pained, in reading the other day the speech of the member for North Derry, in which he seemed to accuse me of having said, at a meeting I addressed at Coalisland last October, that the opposition to Home Rule in Ulster would be put down by us with a strong hand, from which he seemed to infer that I was anxious to ride rough-shod over opinion in Ulster. Now, inasmuch as I desire to put my view in reference to Ulster before the House, I cannot do better than read an extract from that speech, which will show how completely (unintentionally, I am sure) my views were misrepresented.
> 
> 
> Speaking on that occasion, I said:—‘And, fellow-countrymen, let me say that so far as what I call
> 
> 
> 
> 
> 
> ---
> 
> p.113
> 
> 
> 
> 
> to-day the minority in Ulster is concerned, that it should be our greatest and most sacred duty to go to any length short of surrender of principle to disarm their hostility and to remove their suspicions. I admit fully that the minority in Ulster is rich and influential. I admit that it has been powerful enough in the past to stand between Ireland and Home Rule, but its power is waning. But, fellow-countrymen, while I am convinced that we can, if we are put to it, win Home Rule in spite of this minority, I confess to you that I don't want Home Rule for Ireland to come in the garb of a bitter political defeat for any intelligent and honest section of my countrymen. I know, of course,’ I said, and this is the sentence that is taken from the context—‘That I know, of course, that there is one section of the minority opposed to us that has no title to the names of honesty or intelligence.’ 
> 
> ‘ A section that it is impossible, hopeless, to conciliate or placate, a section that will, I believe, to the bitter end continue their policy of hatred and ascendancy. I am not speaking of them. After all, in reality, they are only a handful even of the Protestants of Ulster, and I fear that they must be overborne by the strong hand. But I am speaking of the overwhelming majority of those who are ranked to-day as our opponents in Ulster. For my part, I say here, that of the overwhelming majority of these men I believe that they are honest, and, according to their own sense of the word, patriotic. I believe that they are in large numbers honestly afraid to trust their property and their religious interests to their fellow-countrymen. Now, over these men, I say to-day, that if I can avoid it, I want no party triumph. I want to influence their intelligence, I want to dissipate their suspicions, and I want to soften their hearts, and, therefore, so long as it is possible for me to do so, even against hope, I will preach to them the doctrine of conciliation. I say here to-day that there are no lengths, short of the abandonment of the principles which you and I hold, to which I would not go to win the confidence of these men, and not to have them lost to Ireland. There are no safeguards which I would object to in a Home Rule Bill to-morrow to satisfy the fears which these men entertain about their religious interest, and I can say he is the best Irishman who does his best to-day by preaching toleration and conciliation to these men to bring all the sons of gallant Ulster into line in the battle for Ireland.’
> 
> 
> 




A commentary on this is supplied by the speeches of 





---

p.114




Captain Craig, M.P., who has repeatedly declared that if the Imperial Parliament carries a Home Rule Bill, Ulster will resist by force of arms. Other speakers have declared that there will be a refusal to pay taxes. In either case, what would be open to any Government but to overbear such resistance by the strong hand?


In Canada, Loyalists carried their resistance to the point of burning down the Parliament House in Ottawa. Does anyone assert that Home Rule should not have been given to Canada because the Loyalists intended to create a riot, or is it contended that they should have been allowed to burn down the Parliament House as often as it was built up?




---

p.115


### Chapter XI


#### The alleged Prevalence of Crime in Ireland


It is argued again that Home Rule should not be granted to Ireland because of the criminal tendencies of the Irish population.


This matter was very ably dealt with by Mr. E Haviland Burke, M.P., in a pamphlet entitled Police and Crime in Ireland (which can be procured from the Irish Press Agency).


#### Ireland and England Compared


Mr. Burke found that by examining the latest report then (in 1909) available, the Judicial Statistics for England and Wales and Ireland respectively in 1906, the indictable offences known to the police were 91,000 to a population of 34,500,000 in England and Wales; in Ireland, 9,400 to a population of 4,380,000. Had the Irish offences been proportionately as numerous as the English and Welsh they would have numbered 11,640.


In certain respects, notably cases of theft, and, above all, sexual offences, Ireland's superiority was amazing. Where the record told against Ireland was in that class of offences which is connected with agrarian agitation.


#### How far Law-Breaking is tolerated in Ireland


It is undeniable that ever since the Union there has been, at intervals, lawless agitation in Ireland, accompanied with crime. If it be argued that on this account Home Rule should not be conceded, the same argument 





---

p.116




would have barred the Abolition of Tithes, the Emancipation of Catholics, the Disestablishment of the Church and every remedial measure that has been attempted.


#### The Need for an Irish Administration


The truth is, that in so far as Irish opinion palliates offences against the law, the cause is, first, that breaking the law has often been a necessary means to obtain redress of grievances from a Parliament outside Ireland; and, secondly, Ireland never accepted the right of the British Parliament to legislate for Ireland. The law is not made by legislators whom we choose, nor is it administered by Ministers who depend on our confidence. Irishmen do not feel themselves responsible for making or for maintaining the law. A chief advantage of Home Rule would be to fix upon the Irish people the responsibility for maintaining that tranquility which is necessary to a prosperous people.


Take, again, a typical argument stated in the A. B. G. of Home Rule:—


> 
> The official records of Irish Nationalist disorder and lawlessness, as they are given from time to time in the House of Commons, are open to anyone who cares to have them. All this disorder is the direct result of the advice to the people given by Mr. John Redmond, Mr. John Dillon, and other Nationalist leaders and directors of the United Irish League.
> 
> 
> Mr. Redmond's own words, often quoted, have decreed a
> 
>  ‘dangerous and menacing agitation—an agitation that would make government difficult and dangerous and in the end impossible.’ So that it is no wonder that in all Ireland there is no member of the Unionist minority who places an atom of reliance on Nationalist promises and guarantees of toleration and fair government under a Home Rule Parliament.
> 
> 
> 




The simple answer is—No reasonable man desires a dangerous and menacing agitation; yet eminent Irishmen possessing admitted talents which might have been employed





---

p.117




to their own advantage have spent their lives in agitation, for the reason that without agitation necessary reforms could not be obtained.


#### Police and Crime


A word needs to be said as to the attitude of the Irish people towards the police and crime. In prosecution for a case of theft, the police have no more difficulty in getting evidence in Ireland than elsewhere. In civil disputes between one man and another, evidence is readily forthcoming, and the law is freely resorted to. Recently, when a woman was outraged and murdered, the whole country side was eager to detect and convict the committer of this crime—which is rarer probably in Ireland than in any other country in Europe.


But it has to be fairly admitted, there are certain classes of crime in regard to which the Irish people will not assist the police. The reason for this has been already given. Lawlessness has been necessary in order to get the most necessary reforms. When the whole population is defying the law, men will not denounce even those who commit acts which outrage public opinion. This disposition lasts after the necessity has disappeared, and it is improbable that, in any part of Ireland, the man who committed a crime which could even be represented as springing from an agrarian grievance would be given over to English law.


#### Lord Clanricarde


In nine-tenths of Ireland, happily, agrarian disturbance has ceased. Within the last six years only two agrarian murders have been committed, both in the same district that is the district where Lord Clanricarde has succeeded, in spite of two Acts of Parliament passed to reinstate the evicted tenants, in keeping more than a hundred evicted tenants still out of their holdings. His success in defeating the law has destroyed confidence in the law.


Where land purchase has operated, disorder in Ireland has become a thing of the past, but the attitude of the Irish people towards the law has not changed, and will not change, until they feel themselves responsible





---

p.118




to the administrators whom they themselves choose for the maintenance of the law. The enormous police force at present maintained has no power to suppress lawlessness where lawlessness does exist, as in the Clanricarde country; its only effect is to inflict a fine—and a heavy fine—upon the district, striking the innocent as well as the guilty. In those parts of Ireland where lawlessness has ceased it is a ridiculous and criminal extravagance.




---

p.119


### Chapter XII


#### The Canadian Analogy


All these arguments against the granting of Home Rule—the argument that sectarian differences will lead to oppression of the minority, the argument that the Irish are disloyal, and cannot, therefore, be trusted to main-tain the Imperial connection, the argument that political agitation has been conducted by lawless means, and the argument that the loyal minority will resist by force—are fully met and covered by the case of Canada, which may be here recalled:


When Queen Victoria ascended the throne Canadians were in armed

 rebellion against England. When the British Government of that 

 day ordered the Te Deum to be sung in Canadian Churches, to

 celebrate her accession, the congregations rose en masse and left the buildings.


Fifty years later, at Queen Victoria's Jubilee, Englishmen would hardly believe that Canada was ever disaffected.


What caused the change?


The grant of Home Rule to Canada, while Canada was still seething with unrest.


There is nothing exceptional in this. In Australia and Cape Colony, as in Canada, self-government was conceded after great and menacing movements, breaking into rebellion and bloodshed. But the case of Canada is that which offers the simplest resemblance to the symptoms which prevail in Ireland, and, therefore, the completest argument for applying the same cure.


#### Resemblances


In Canada, as in Ireland, there were two races, and two religions. The British, settlers of a more recent date,





---

p.120




exercised a political ascendancy in favour of their own race, and the Protestant religion. The minority claimed, as it claims in Ireland, to make its will prevail over that of the majority. Lord Durham, in his famous report, says:—

‘The English look upon the French with contempt.   
[*...*]  


The French look upon the English with alarm, with jealousy, and, finally, with hatred.’


Supporters of ascendancy in Canada used precisely the same arguments against Canadian Home Rule as are used in the case of Ireland. The Duke of Wellington said that—‘Local responsible government and the sovereignty of Great Britain were completely incompatible’. History has confuted the Duke.


#### The Unionist Arguments against Canadian Home Rule


Lord Stanley said in the House of Lords:—

‘What would be the consequences (of granting the Canadian demand)? The establishment of a republic the concession would remove the only check to the tyrannical power of the dominant majority—a majority in numbers only, while in wealth, education, and enterprise they are greatly inferior to the minority. The minority of the settlers are of British descent, and one thing is certain, if these settlers find themselves deprived of British protection, they will protect themselves.’


Canada, has not moved a step towards separation, nor towards republican institutions. Yet Canada is divided only by an imaginary line from the greatest Republic in the world, and could, if it rebelled, only be conquered with the utmost difficulty. The tie of free association within the Empire has held in the face of the strongest natural and political attraction.


In the case of Ireland, what did Grattan say? ‘The sea denies us union, but the ocean forbids separation.’


In Canada there has been no hint of civil war, nor has the Catholic majority oppressed the Protestant minority.

 Sir Wilfred Laurier, the French Catholic Premier, is trusted by the Protestants of Ontario no less than by the Catholics of Quebec. The cause of sectarian bitterness





---

p.121




was not theological difference, but the unfair predominance given to one creed identified with one political party.


Lord Durham said:—‘The Bench, the magistracy, the high places in the Episcopal Church, and a great part of the legal profession, are filled by this party; by grant or purchase, they have acquired nearly the whole of the unoccupied lands of the province; they are all-powerful in the chartered banks, and, till lately, they share among themselves exclusively all offices of trust and profit. The principal members of this party belong to the Church of England, and maintenance of the claims of that Church has always been one of their distinguished characteristics.’


This applies literally in every point to Ireland.


Again, with regard to the administration of justice,

Lord Durham wrote:— ‘The public have no security for any fairness in the selection of juries. They have no cheek on the sheriff. The public knew he could pack a jury whenever he pleased, and supposed that an officer holding a lucrative appointment at the pleasure of the Government would be ready to carry into effect their designs.’


Jury-packing in Canada, as in Ireland, was caused by refusal of the juries to convict. In September, 1837, the Governor-General, Lord Gosford, wrote:—

 ‘In two recent instances, where the Attorney-General preferred bills of indictment in the Court of King's Bench at Montreal, one against a Dr. Duchesnois, for publicly tearing, and treating with contempt, the proclamation issued by me on the 15th June last, and another against a certain individual in the county of the Two Mountains, for a conspiracy to drive out of the county, by means of threats, and acts of violence, several inhabitants, because they held opposite political opinions, the bills have been ignored by the Grand Jury, in the face of the strongest evidence.’


#### The Parnell of Canada


Lord Gosford was a Coercionist, and his picture of Canada in 1837 is the Tory picture of Ireland to-day. ‘The Papineau faction are not to be satisfied with any 





---

p.122




concession that does not place them in a more favourable position to carry into effect their ulterior objects—namely, the separation of this country from England, and the establishment of a Republican form of Government.’


His Attorney-General describes boycotting: ‘A system of proscription, based upon national distinctions and political prejudices, was adopted and pursued. The British inhabitants, and those loyal Canadians who adhered to the political principles of their British fellow-subjects, perceived on a sudden that all intercourse between them and those of their neighbours who professed a different political opinion, was studiously denied, all interchange of the ordinary offices or the common necessaries of life had abruptly terminated; they had incurred the penalty of social excommunication.’


Also intimidation, and even cattle-driving:— ‘Mobs assembled by night, and with shouts of intimidation and threats of personal violence endeavoured to terrify the loyal inhabitants into an adoption of their principles. The house of one, Jean Baptiste Cleval, was fired into. The British subjects (settlers) were also subjected to a series of harassing annoyances—their fences were broken down, their cattle driven astray, their horses cropped and otherwise disfigured, and a variety of petty injuries inflicted.’


#### Unscrupulous Agitators


He attributes these symptoms, as the Irish Tories do, to ‘the artful and unscrupulous misrepresentation with which they (the agitators) delude and excite their more ignorant countrymen.’


Yet in the face of all this, Canada's demand was conceded. Her demand was for full Home Rule—a legislature with an executive responsible to it. She had tried a half-measure, a Parliament without power to choose and control its own ministry, and from this, disintegration and disloyalty had arisen. The complete concession of freedom was followed by complete loyalty. Nor is that all. Prosperity replaced misery. Lord Durham wrote:—

‘The present evil is not merely that improvement is staved, and that the wealth and population of these 





---

p.123




Colonies do not increase according to the rapid scale of American progress. No accession of population takes place by immigration, and no capital is brought into the country. On the contrary, both the people and the capital seem to be quitting these distracted provinces.’


#### The End of it all


To-day Canada is united, harmonious, peaceful and prosperous. Canada to-day asks Home Rule for Ireland (by repeated resolutions of her Parliament) in the interests of the Empire. Australia does the same.


Every self-governing colony is in favour of Home Rule for Ireland because each knows that if it were governed as Ireland is, it would be, as Ireland is, discontented and miserable, and that, if Ireland were free within the Empire, as the self-governing Colonies are free, Ireland would be, as they are, prosperous and contented.


#### A Canadian Imperialist on the Irish Question


A good commentary on these facts is afforded by the speech delivered at a St. Patrick's Day in Montreal by the Chairman of the Canadian Pacific Railway Company that great Imperialist, Sir Thomas Shaughnessy. He said, replying to the toast of ‘Canada’:—

 
> 
> Our material progress, striking as it is and satisfactory, is not a source of greater gratification than the political relations between the people of the several sections of the country. The British North America Act was drawn on wise and, statesmanlike lines; it has stood the test of time, and its foundations are unshaken. Each Province has its own characteristic resources to develop, along the lines desired by its own people, but all are united in the advancement of the common good of the whole Dominion. Notwithstanding the differences in race and religion, the U. E. Loyalist of Ontario is no more loyal to the British Crown than the French Canadian of Quebec. [*...*] And now, Mr. President, I would like to devote a few words to another subject that appeals to every man of Irish birth or extraction wherever he may live, and that is the prompt and effective amelioration of what are manifestly 
> 
> 
> 
> 
> 
> ---
> 
> p.124
> 
> 
> 
> 
> Ireland's wrongs, with the improvement in the position of her people that would surely result from such a policy.
> 
> 
> For generations there has been something in the nature of a feud between the people of Great Britain, or, I should say, of the governing classes of Great Britain and the Irish.
> 
> 
> At times the feeling on one side or the other has grown so intense as to lead to lawlessness and consequent reprisals. Neither party has been free from blame. On the one hand there was the overbearing audacity of a class actuated by selfishness and assumed superiority. On the other the wrath and vindictiveness of a people who felt that they were being subjected to humiliation and cruel treatment. In both cases there were, no doubt, other motives and other incentives, to which I need not now refer, but I must declare my conviction that in the relations between Ireland and the other portions of the British Empire there is a situation that should not and cannot longer continue.
> 
> 
> The Land Purchase Act has accomplished a great deal, but why stop there? Ireland is entitled to and should have local self-government, as should England, Scotland and Wales if they want it.
> 
> 
> 




#### Separation not possible




> 
> In the case of Ireland, separation is as undesirable as it is impossible, and there may be other features of the Home Rule programme that require modification or elimination. But why should the opponents of the Irish Party dwell upon and emphasise only the features of the Irish proposals to which they have most decided objection? Why not take up and discuss the other sections about which an agreement might be possible? In the eyes of the opponents of Home Rule there are two dominating and all-absorbing bogies to the exclusion of everything else-namely, the control of affairs in Ireland by the predominating Catholic majority to the detriment and discomfort of the minority, and the certainty that the whole scheme of Home Rule aims at separation.
> 
> 
> Those of us who know our fellow-countrymen best, would give but little weight to the first of these apparitions, because the maintenance of a cohesive majority for any long period of time would be contrary to the nature and tradition of the Irishman; but even if this were not the case, it would 
> 
> 
> 
> 
> 
> ---
> 
> p.125
> 
> 
> 
> 
> be quite practicable to provide constitutional safeguards against injustice or oppression. And about the other, I have already expressed the conviction that separation would not be in the interests of the Irish people, and that for many reasons it would be impracticable, indeed impossible, and it should not stand as a bar to a rational Home Rule measure.
> 
> 
> 






---

p.126


### Chapter XIII


#### Can Ireland pay her Way?


It is further argued against the grant of Home Rule that Ireland is a bankrupt country, which does not pay her own way; that self-government could not be established without imposing on Irish taxpayers a ruinous additional burden.


Two questions are here involved—(*a*) What is the tax paying capacity of Ireland? (*b*) Can Ireland hope to effect economies?—Let us first deal with (*a*).


In support of the anti-Home Rule view, it is stated that in the year 1909-10 Great Britain contributed £2,357,000 to the cost of Irish local administration. This is represented as being only the latest instance of England's bounty under the Act of Union.


What are the facts?


First, by admission of the British Treasury, 1909-10 was the first year in which Ireland did not contribute a large sum to the cost of Imperial expenditure.


Secondly, on the British Treasury's own figures, the sums so contributed by Ireland since 1817 amount to three hundred and twenty-five millions sterling. Between 1820 and 1910 five hundred and ninety-six millions of taxation was raised in Ireland, and only two hundred and eighty-two spent there.


In the face of the tribute thus extorted— ‘more than an Empire's ransom,’ as has been justly said—Ireland must not be represented as a beggar, depending on Great Britain's charity.


Thirdly, it is demonstrably untrue to say that even in the one year since the establishment of old age pensions Irish local expenditure has exceeded Irish revenue by £2,300,000.




---

p.127


The statement is based on a misleading paper issued by the Treasury under date July 20th, 1910—misleading because it states the excess of expenditure over receipts, without the necessary explanation. In that year the Finance Act was held up. Consequently, Ireland figures as contributing only £388,000 under the head of income tax. For the previous financial year this contribution was £1,100,000. The arrears due to this accidental cause, were, of course, collected within a couple of months after the passing of the Budget.


But, further, even in 1909-10, with the addition of old age pensions, the local expenditure did not reach ten millions' and three-quarters. The average of revenue *collected in Ireland* during the ten previous years was eleven and a quarter millions.


#### 'True' Revenue


Local expenditure in 1909-10 certainly did not exceed Ireland's revenue ‘as collected.’ But it may probably have exceeded what is called Ireland's ‘estimated true revenue.’


It is necessary to explain what this means.


#### Income Tax


First, in regard to direct taxation. The income tax collected in Ireland amounted in 1908-9 to £1,019,000. But the income tax on all dividends on shares in companies registered in England and Scotland is paid at its source, and, in the first instance, goes to the credit of English or Scotch taxation, though deducted from persons or companies established in Ireland. The Treasury add, under this head, to the total of Irish Income-tax a figure of £135,000 for the year 1908-9.


This is an estimate which we in Ireland, having no exchequer of our own, have no means of testing. The writer of a very valuable pamphlet (The Financial Relations of Ireland with the Imperial Exchequer, by an Irishman. Gill & Son, Dublin, 1911. Bd. net), gives reasons for believing that Ireland's real contribution is 





---

p.128




£300,000 higher; in other words, that Ireland's true contribution of income tax is not £1,134,000, but nearly a. million and a half.


#### Tobacco


Secondly, in regard to Ireland's share of indirect taxation, take, for instance, tobacco. In the last complete year, £1,945,000 was collected in Ireland on tobacco imported direct to Ireland. But to ascertain Ireland's ‘true’ contribution, the Treasury balance two other figures: the amount of tobacco manufactured in Ireland but consumed in England, and the amount of tobacco imported into England but consumed in Ireland. They find that the balance is against Ireland, and deduct £473,000 from the amount collected in Ireland, making Ireland's ‘true’ contribution to tobacco tax only £1,472,000 instead of the £1,945.1000 which is the collected revenue.


Now, the estimate is admittedly made for 1910 ‘from proportions ascertained for 1903-4 upon inquiries made of manufacturers and dealers.’ Briefly, it is a guess; and a guess which Ireland has no means of controlling.


#### Tea


Take, again, tea. The Treasury say:— ‘For the year ending March, 1910, the duty paid in Ireland was £302,000. To this we add £244,000 for tea consumed in Ireland, but cleared of duty in England.’ They base this estimate ‘on proportions ascertained by inquiries as to quantities intercharged between Great Britain and Ireland in 1903-4.’


But the statistical branch of the Irish Department of Agriculture and Technical Instruction has been studying Irish imports and exports, and it returns the import of tea into Ireland for 1909-10 as as a figure which represents a duty paid of over £700,000. This is a Government estimate and based on first hand inquiry, not on an obsolete guess. The Treasury, as between the two figures, choose the one which is less reliable, but which lowers Ireland's ‘true’ revenue by £160,000.




---

p.129


#### Irish Finance under the Union


Who assesses Ireland's ‘true’ contribution? The British Treasury. What is the British Treasury's predisposition in this matter? Before answering that, it is well to summarise the history of financial relations between the two countries since the Act of Union. This summary is borrowed from a paper called ‘Some Suggestions concerning the Future Welfare of Ireland,’ by Lord MacDonnell, published by the Independent Newspaper in Dublin at 2d. And since it must be largely quoted here, it is well to note that Lord MacDonnell is a Catholic, son of a poor man in Connaught, who won his way by brains into the Indian Civil Service, and in that service, starting without influence or connections, earned the reputation of being probably the greatest Indian administrator since those other Irishmen, the Lawrences. In 1900 he left the Governorship of Bengal to become Under Secretary of State in Dublin, admittedly as ‘a colleague rather than a subordinate’ to Mr. Wyndham. He speaks, therefore, with eight years' official experience at the centre of Irish administration; and with a whole lifetime of official training.—Here, then, is the summary:—


From 1800 to 1817 a separate Irish Treasury existed, but the United Parliament fixed the rate of expenditure, and the Act of Union settled that two-fifteenths of it should be charged to Ireland. Under this dispensation Ireland's funded debt rose from twenty-eight to one hundred and twelve millions in seventeen years.


Demonstrably, then, the immediate result of the Union was bankruptcy for Ireland.


#### Ireland's Contributions in the Past


During the fifty-three years which followed 1817, *two thirds of Ireland's annual income* was spent year by year in Imperial purposes—army, navy, and the like. Meanwhile, Irish administration was starved; the country lay like a derelict farm, while two-thirds of Ireland's taxes were going to pay for England's wars.




---

p.130


For thirty-five years after 1817 the taxation of Ireland was kept on a different basis from that of England, income tax not being levied there. Thus, in 1849, the closing year of the famine, Ireland did not contribute to Imperial purposes quite two and three-quarter millions. Yet this might have seemed enough for a land where a million persons had died of starvation or its effects. But in 1853 Mr. Gladstone clapped on the income tax, and in 1859 Ireland's ‘estimated true revenue’ was £7,700,000, of which *only £2,300,000 was being spent in Ireland*—the balance, £5,400,000 being her ‘Imperial contribution.’ These are Treasury figures, and when we are told that Great Britain has been Ireland's milch cow, it should be remembered that between 1820 and 1870, two hundred and eighty-seven millions of taxation was raised in Ireland, and only ninety-two millions spent there, the balance of one hundred and ninety-five millions going to Imperial purposes.


So great a disparity between contribution and benefit led ultimately to inquiry, and a Committee reported in 1865. But for the year ending March 3st, 1870, the local expenditure was under three millions, the Imperial contribution nearly four and a half.—1870 marked, as has already been shown, the beginning of a period when (under the stimulus of the Fenian movement) some serious attempt was made to remedy the evils which had grown up under the Union.


In the thirty years ending in 1900 local expenditure actually exceeded Imperial contribution, being 120 millions local as against 104 millions Imperial. Since 1900 the proportion has been enormously changed. Imperial contributions only stand at fifteen millions, the local expenditure at eighty-six.


#### Lord MacDonnell's Opinion of the Treasury Estimate


Upon this Lord MacDonnell makes the following notable observations:—


‘It must be admitted that these figures exhibit a most startling change, and I confess they have given me occasion 





---

p.131




to think furiously,’ as the French say. I am old enough to remember well the Ireland of 1860 to 1865, and I have had intimate knowledge of the Ireland from 1900 up to date, but in my conscience I know of no such local expenditure, comparative or absolute, upon Ireland as the figures for the last ten years represent. It would be absurd to pretend that there is any such improvement in the material condition of Ireland as that revolution in expenditure, if it were real, must have produced. The only large increases in local expenditure which practically took effect between 1900 and 1909 are the agricultural grant of £750,000, whereby landlords were relieved of payment of poor rates; the additional grant to the Congested Districts Board under the Act of 1903, and the grant for labourers' cottages.


I admit that since 1870, at which time we may place the first faint beginnings of the better feelings towards Ireland, which have since, I am glad to say, grown apace, the expenditure upon Ireland has been on a more liberal scale than it was in the preceding years, but I am frankly incredulous that this fact suffices to explain the revolution which a comparison of the figures before and after brings to light. We must look elsewhere for the explanation.


The Treasury return makes a distinction between what it calls the ‘revenue as collected’ and what it calls ‘the estimated true revenue,’ the latter being, of course, less than the former. My belief is that since 1870, after the proceedings of the Committee of the House of Commons had drawn attention to the disparity between Irish local expenditure and Irish contributions to the Imperial Exchequer, *Ireland has been debited with charges for which she was not really liable*; the apparent effect of such debit has been to swell her expenditure and to diminish her contributions to the joint Exchequer, and consequently to exhibit her as being in a much worse financial position than she really occupies.


The highest Treasury authorities have admitted that in calculating what is called Ireland's

 ‘estimated true revenue’ the Treasury has acted largely on guess-work. Their procedure violates the view of Mr. Gladstone, who, in introducing the Home Rule Bill of 1886, laid down that

 ‘It would be equitable and just, considering the past, to give credit to Ireland for the total amounts of her revenue as collected.’ Gentlemen, that is the principle for which I contend as supplying an equitable basis for the settlement of the financial dispute between Great Britain and Ireland. Let Ireland be credited 





---

p.132




with her revenue ‘as collected’ and I believe Irishmen will be satisfied.


#### Irish Expenditure


To sum up, then, so far: Can Ireland pay her way? We maintain that on a fair system of accounting, Ireland is at present paying eleven and a quarter millions of revenue. This more than meets even what the Treasury classify as Irish local expenditure.


But, further, we object entirely to the Treasury's method, which is to charge every penny spent in Ireland as Irish expenditure, but to arrive at Ireland's revenue by deducting millions from the taxes collected in Ireland.


We ask, first, What is Ireland's ‘true’ expenditure?


The further question to be considered is, Can Ireland reduce that expenditure?


#### Can Ireland economise?


Local expenditure in Ireland has grown from £5,616,000 in 1894-5 to £10,712,000 in 1909-10.


‘Local expenditure’ here means expenditure controlled by the British Government.


Local expenditure controlled by the County Councils was reduced in the eight years ending 1908 by an average of threepence in the rates.


Economies effected in the rates benefited the Irish rate payer to their full amount. Economies in expenditure controlled by the British Government were credited to the British Treasury.


Under Home Rule we should keep our own accounts, we should profit to the full by our own economies.


In what direction could they be effected?


#### Fresh Expenditure needed

### Education


Before answering the question whether Ireland can reasonably hope to economise on the cost of civil government, it is necessary to distinguish. Nowadays a State undertakes many more duties than were previously 





---

p.133




attempted by it, and a reasonably ordered State does much which is not done in Ireland because much money is wasted in, other departments. A modern State spends lavishly on education. In Scotland, Primary Education costs the public over £4,000,000 a year—and by general consent no better investment was ever made. In Ireland only £1,300,000 is spent on Primary Education for an equally large child population. Secondary schools in Ireland are even worse endowed. Under Home Rule, more money and not less would have to be spent on education.


Again, there are great national works which cannot be undertaken by individuals.


#### Afforestation


The country is denuded of trees. This is bad for the climate, and it deprives Ireland of the prime material of many industries. Afforestation is a great State concern, which any Irish legislature, concerned primarily and solely with the interest of Ireland, would be bound to consider, would have leisure to consider, and would almost certainly undertake.


#### Drainage


Take, again, drainage. Ireland is a country of large rivers flowing through very flat land. In certain cases, notably on the Barrow and on the Bann, these rivers flood every year, with injury to the health of the people and injury to the land. Ague and similar complaints are always present in the valley of the Barrow, and it would be impossible to compute the damage to crops on land which is cultivated, or the loss by land which, under a proper system of drainage, would become cultivable.

Such national work as this, public opinion of the North and South together would force an Irish Parliament to undertake.


Enterprises of this kind are reproductive, and would ultimately pay for themselves. They would be dealt with by loans, not out of revenue. The interest and sinking fund on these loans would be a charge for a limited period.




---

p.134


In this respect, Irish administration would be hampered by the neglect of British Governments. These works ought to have been paid for by part of the 325 millions taken out of Ireland since 1817, to pay for an army to keep down Ireland, and for a navy to protect trade in which she had no share.


Ireland is in the position of an undeveloped farm. That is natural, seeing that until forty years ago twothirds of the revenue raised in Ireland was being spent on the British army or navy, or some other Imperial purpose, and, in addition to that, an enormous proportion of the rental of the country was being paid to absentee landlords. But it does not follow that a farm cannot be profitably worked because it is undeveloped.


#### Where Money Can Be Saved


Is a retrenchment, then, possible? Unquestionably it is, and on a large scale. It could be looked for under two heads—cost of police and the cost of civil servants, and of these something must be said in detail.


*Civil Servants*.—Profesor Kettle has shown, in his interesting book, ‘Home Rule Finance,’ that the number of Government officials with incomes over £160 a year in Scotland is 944, and in Ireland is 4,297. The Scotch officials receive £319,237, the Irish £1,141,131more than a million of difference.


Now, beyond all question, we could do this work more cheaply and with fewer men. Posts have been multiplied under the Union to create patronage. For example, the Board of Works—an important Public Department—is managed by three Commissioners, who receive jointly £3,200 a year. On the analogy of other departments, even in Ireland, one man at half the money could do the work. Two of these three gentlemen are Englishmen, promoted there in respect of services which had no interest for Ireland.


#### Judges


Again, the Law Courts in Scotland cost £200,000: in Ireland £360,000. The Irish Prisons Board costs £107,000: the Scotch Prisons Board £87,000. Yet the 





---

p.135




Scotch Prisons Board had 4,000 more convicts under its supervision. In Ireland, indeed, six prisons have been shut up within a few years for lack of inhabitants. It is asserted—whether rightly or wrongly—that we have more judges than we need in Ireland. What is certain is, that they receive a higher stipend than is necessary to secure their services. A judge in England gets £5,000 a year,and, as a rule, loses very largely in professional income by accepting the increased dignity and securer position. In Ireland he gives up the professional earnings as a barrister which frequently may not exceed half of his judicial salary. It is necessary to pay judges at a high scale in order to secure their perfect independence, but £2,500 was considered sufficient for the Estates Commissioners, who, in conducting the sales of land, had to occupy a position far more important and far more exposed to temptation than that of any ordinary judge.


Up to the present Ireland has had no adequate inducement to economise. If, for example, a judgeship were suppressed, £4,000 a year would be saved; but to whom? To the Imperial taxpayer; the benefit to the Irish tax payer would not be more than £200 a year. The gain is so insignificant as to be scarcely worth considering.

 Under Home Rule the Irish Chancellor of the Exchequer would be as much interested to economise £4,000 a year as the British Chancellor to economise £80,000.


It is certain then, that a Home Rule Government would retrench upon official salaries and upon the number of officials. The record of the Irish County Councils stands as an example to show the tendency of an Irish Government as more likely to be towards excessive parsimony than towards extravagance.


But, further, some of the great spending departments in Ireland will naturally cease to exist as the work of land purchase goes through. The Land Courts, which are occupied with the business of periodical rent-fixing, would cease to have occupation when the tenant becomes the owner, paying a fixed instalment to the State. The Estates Commission, which is concerned in the administration of land purchase, ought, in another fifteen years, to have completed its work. These are future economies, but they are inevitable ones.




---

p.136


#### The Period of Pensioning off


The reduction which can be made by retrenching superfluous officials, or by reducing the excessive salaries is certainly possible, but is also remote. *No civil servant must be injured in any way by the change of administration*.The Irish Government will take over the existing staffs of officials just as the County Councils did. Doubtless, it will have the power—as the County Councils have—to get rid of servants whom it does not wish to retain, but it will certainly, in that case, be obliged to pension them off, virtually, on full pay. In plain words, for a generation to come a Home Rule Government will be hampered by the extravagant system of administration which the British Government has established. Our difficulty will arise from the fact that, during one hundred and eleven years, we have not been able to control our own expenditure.


#### The Police Force


The most wasteful branch of this outlay remains to be dealt with.


The police in Scotland cost, roughly speaking, half a million; the police in Ireland, for a similar population,costs one and a half million.


The police in Great Britain are a civil force, under local control. The police in Ireland are a military force, under Imperial control. The Imperial Government constantly augments the police force where there is disturbance, but it never diminishes it where order has prevailed over a generation. English tourists must have seen with amazement villages of four hundred or five hundred people, in a county like Donegal, where trouble has always been rare, and where none has occurred for ten or fifteen years, possessing a police barrack with seven or eight stalwart men, each of whom costs 30s. a week in a country where the average wage is, perhaps, 12s.


This enormous force was created to protect the Irish Land System. It was part of the costly machinery employed for collecting rack-rents. It was needed to protect the evictor and the land-grabber.




---

p.137


Now, under any form of Government which had the confidence of the Irish people, the cost of the police could be reduced by one-half without the least danger to public order. The only thing which would prevent a Home Rule Government from at once realising half a million a year of economies in this respect would be the necessity of providing retiring allowances for those whom Ireland has not employed, nor desired to employ. It has always been recognised that the Irish police was, in part, at least, an Imperial force, and the responsibility for paying off its superfluous members should fall upon England.


#### The Present Financial Situation


To sum up, then, it has been shown—

(*a*) That the revenue collected in Ireland at the present time is more than sufficient to meet all those expenses which are set down by the Treasury as British expenditure—the revenue collected being 11 1/4 millions; the expenditure for the last year 10 3/4 millions.

 (*b*) That the police force costs 1 1/2 millions, and that a portion of this—variously estimated at half or one million by English statesmen—must be taken as Imperial expenditure, and in any reasonable settlement the cost of this excess should be borne by the Imperial Government while it exists; this charge would terminate according as retirement pensions fell in. (*c*) That the Civil Service list has been swollen by a mass of superfluous and overpaid appointments, and in the outlay needed before economies can be effected here Imperial assistance should be given to enable Ireland to increase her expenditure in useful directions.


#### Land Purchase


In regard to land purchase. When the operation has been completed some £200,000,000 will have been borrowed on the security of the British Exchequer. The security for that will be the land of Ireland. But, clearly, the responsibility for collecting the annual instalments, by which this loan will be repaid, ought to be placed upon the 





---

p.138




Irish Government, and Great Britain should have a corresponding charge upon the Irish Customs and other revenue.


As things stand, if a general failure of crops in Ireland, or any other cause produced a failure of payments, the loss would fall upon the taxpayer of the United Kingdom. Under Home Rule, the British taxpayer would hold a first charge upon the revenues of Ireland for the repayment of this loan. In other words, Home Rule would render the British taxpayer more secure and not less secure with regard to his advances on Irish land.


What the common purse of the United Kingdom contributes to the operation of land purchase in Ireland is the bonus paid to the Irish landlords. This was undertaken as an Imperial charge (much being said about imperial generosity), and, therefore, nothing in respect of a bonus must be charged against Ireland.


#### England's Interest in the Matter


Finally, in regard to the whole matter, how does the British taxpayer stand, first, from the point of view of mere expediency? Since the establishment of old age pensions it is clear that Ireland is contributing nothing to Imperial expenditure. By taking the Treasury's estimate—which counts as purely Irish expenditure every penny that is spent in Ireland, but declines to treat as Irish revenue nearly two millions of taxes collected in Ireland—it is possible to argue that Ireland is being run at a loss. At present Unionist orators declare that Ireland is costing the United Kingdom two and a half millions a year, and Irish Unionists declare that this is the best argument for maintaining the Union, because, as one of them said, Ireland is in the position of a poor man who has his hand in the rich man's pocket. Nationalist Ireland, first, refuses to accept this as a true statement of the case, and, secondly, declines to join in this desire of sponging on a richer country. But, from the Unionist point of view, what is the outlook for the British taxpayer?


#### Mr. Gladstone's Policy and its Fulfilment


Does anyone believe that Irish administration, directed from Westminster, is going to cost less in future? Mr. 





---

p.139




Gladstone, in introducing his Home Rule Bill of 1886, said:—

 ‘The civil charges *per capita* at this moment are in Great Britain 8s. 2d. and in Ireland 16s. They have increased in Ireland in the last fifteen years by 63 per cent., and my belief is that if the present legislative and administrative systems be maintained, you must make up your minds to a continual, never ending, and never to be limited augmentation.’


In 1908 the charges had risen from 16s. to 28s. 6d. a head. Since then, old age pensions have put on more than 10s. a head, and the figure is now about £2. This increase will inevitably go on while there is no incentive in Ireland to economise, and while the Union entails the adoption of similar measures for Ireland and Great Britain. And, further, modern notions of taxation tend to divide the burden between the direct and indirect taxation in such proportion that the direct taxpayer, who is, generally speaking, a rich man, pays something more than half of the total. But in Ireland rich men are so few that, when the same system is applied to Ireland as to England, the result comes out quite different. Under Mr. Lloyd George' s Budget indirect taxation produces 49 percent. of the revenue of Great Britain. It produces 70 per cent. of the revenue in Ireland.


Unless the system of taxation is altered so as to increase the burden of indirect taxation—which affects the poor—Ireland will pay less and less proportionately.


#### England stands to gain


Under the continuance of the Union, then, what the British taxpayer has to look forward to is, finding Ireland a constantly increasing drain upon his pocket. Under Home Rule, Ireland will contribute regularly in proportion to her resources to Imperial purposes; though there may be offset against this contribution, a limited charge for a transition period of some fifteen or twenty years to enable Ireland to effect the economies which have been indicated.


One more point. It is said that under Home Rule British capital will shun Ireland. It will be observed, 





---

p.140




first, that British capital invests freely in South American Republics, which cannot be regarded as a specially stable form of Government. It is further to be remarked that, under the Union, trustees are regularly prohibited from investing trust moneys in Irish securities. It is difficult to see what more injurious measure could be taken for Irish credit.


The statement that an Irish Government could not borrow money is too ridiculous to be dealt with. Every small country can borrow. Every British dependency can borrow at 4 per cent.




---

p.141


### Chapter XIV


#### Answers to Objections


A specific reply may be given here to some arguments set forward in the A. B. C. of Home Rule, published by the Unionist Association of Ireland:—

 1. *Since the time the Legislative Union was established there has been a Nationalist Party in Ireland clamouring for self-government, or Home Rule, and a Unionist Party as resolutely opposed to it. Industry, commercial progress, respect for the law, and loyalty to the British Crown, have always been the characteristics of this Irish Unionist minority. The leading features of the Nationalist majority have ever been disloyalty, evasion or defiance of the law, and political agitation in preference to industrial effort, or making the best of the agricultural and other resources of the country at their command.’’*


#### Prosperity and Nationalism


*a*) This argument amounts to the statement that Unionist Ireland has prospered industrially and agriculturally, while Nationalist Ireland has not. First, in regard to agriculture. The three counties in Ireland where farming is most satisfactory and progressive are Wexford, Louth, and Down. The two first of these are predominately Catholic and Nationalist.


(*b*) Protestant farmers in the North of Ireland have, for more than a century, enjoyed tenant right. That is to say, a man who improves his farm is entitled, on leaving his farm, to receive the value of his improvements. In other words, the Protestant farmer has, for more than a century, had that security of tenure, and that reward 





---

p.142




for exertion which the Irish Catholic farmer has only won for himself within the last generation by desperate agitation. Nationalist Ireland has, from an agricultural point of view, been demoralised by a bad land system from whose worst features Protestant Ireland was exempt.


(*c*) The Census returns show that the population has fallen in every province in Ireland except one. That exception is not Ulster, but Catholic and Nationalist Leinster.


*Industrial Effort*.—It has been shown how, in the eighteenth century industries were deliberately killed out in Ireland by British legislation. The one exception was the linen trade. This trade was fostered principally because England did not find it to her interest to compete in it, but in a less degree because it was largely in Protestant hands. Huguenot refugees were established in the North of Ireland on land taken from the Catholics, and they were given bounties to pursue the linen industry, for which the Ulster climate has special advantages, like those which make Lancashire the seat of cotton-spinning.


In this way the industrial habit, the disposition for factory work, has been maintained in the North of Ireland, and every business man knows that manufactories can much more easily be established among a population which has the inherited habit of factory work. In Belfast the great ship-building industry has in a sense been complementary to the linen trade, because the linen trade, employing more women than men under modern conditions, has given work for the female part of the population, and men's labour, in that sense, was more easily procurable. But the essential point is the continued existence, under the protection afforded by British law, of this one industry in this one part of Ireland, which maintained there, not only the industrial habit among work people, but the tendency to employ capital in industrial enterprises.


#### The Opinion of Harland & Wolff's


‘The Commercial institutions of the country have always offered the most extreme opposition to an Irish Parliament.’


It is surely an answer to say that Lord Pirrie, chairman of Messrs. Harland & Wolff's, and the Rt. Hon. Alexander 





---

p.143




Carlisle, manager of that great industrial enterprise, have declared for Home Rule, and that everyone of the woollen manufacturers in Munster, Leinster, and Connaught are of the same opinion. Twenty years ago Lord Pirrie was opposed to Home Rule. Is it not safe to say that what Harland & Wolff thinks to-day, Belfast will think to-morrow?


#### Mr. Redmond and the Irish Americans


3. ‘Like Parnell, Mr. Redmond has declared to his supporters in America that the Home Rule movement is one which aims at the complete political independence of Ireland—freed from all connections with England. On no other terms would he receive money from the Irish-American extremists.’


The answer to this is given by one fact. Last October Mr. Redmond went to America to collect the American dollars, of which so much was said. To explain precisely his aims to American people he published in M'Clure's Magazine for October—the magazine having the widest circulation in America—the following passage:—


Here, then, is ‘what Ireland wants’:

 ‘Legislative and executive control of all purely Irish affairs, subject to the supreme authority of the Imperial Parliament.’


In other words, we want an Irish Parliament, with an executive responsible to it, created by Act of the Imperial Parliament, and charged with the management of purely Irish affairs (land, education, local government, transit, labour, industries, taxation for local purposes, law and justice, police, &c.), leaving to the Imperial Parliament, in which Ireland would probably continue to be represented, but in smaller numbers, the management, just as at present, of all Imperial affairs—army, navy, foreign relations, customs, Imperial taxation, matters pertaining to the Crown, the Colonies, and all those other questions which are Imperial and not local in their nature, the Imperial Parliament also retaining an over-riding supreme authority over the new Irish legislature, such as it possesses to-day over the various legislatures in Canada, Australia, South Africa, and other portions of the Empire.




---

p.144


In other words, in his appeal to America for funds he disavowed separation in the most explicit terms.


#### Where Parnell stood


He has said that he stands where Parnell stood.


Parnell said, in the debate upon Mr. Gladstone's Home Rule Bill of 1886, speaking for Ireland:—


‘We look upon the provisions of this Bill as a final settlement of the question, and I believe that the Irish people have accepted it as such a settlement.’


Before the Pigott Commission on the 1st May, 1889, he swore:—‘I have never gone further, either in my thought or action, than the restitution of the legislative independence of Ireland.’


That is Mr. Redmond's position to-day.


#### Home Rule and Rome Rule


4. ‘The Protestant Churches of Ireland are fully alive to the dangers to them that would ensue in the event of the affairs of Ireland being handed over to an overwhelming Catholic majority.’


This is illustrated by the following quotation from the ‘Appeal of the Presbyterian Church to the Electors of Great Britain,’ which was issued in 1910:—

 ‘In the South and West of Ireland the priest is practically all-powerful, and even in Northern Protestant districts clerical control in matters that are purely civil and secular is growing more frequent.’


Now, it cannot with decency be contended that a country should be denied self-government because the majority of its inhabitants are Roman Catholics. Protestant opinion has already been amply cited above to show that Protestants are not persecuted or in any way damaged by their religious beliefs.


As to the argument that Home Rule will increase the power of the priests, the answer is, plainly, that every 





---

p.145




extension of popular control diminishes the power of the priesthood in secular matters. What is more, the policy of English Unionist statesmen has been to aggrandise the power of the clergy.


#### The Tories and the Bishops


Lord Randolph Churchill tried to persuade the Tory Party to take

 up Home Rule, and failed. He fell back upon another policy which is

 thus stated in a letter written by him on October 14th, 1885 (Life,

 by Right Hon. Winston Churchill, H., p. 3):—

 *It is the Bishops entirely to whom I look in the future to turn, to mitigate or postpone the Home Rule onslaught.

 That is my policy, and I know it is sound and good, the only possible Tory policy. It hinges on acquiring the confidence and the friendship of the Bishops. My own opinion is that if you approach the Archbishop through proper channels, if you deal in friendly remonstrances and in attractive assurances.   
[*...*]  
 the tremendous force of the Catholic Church will gradually and universally come over to the side of the Tory Party.’’*


Mr. Redmond's attitude on the matter has been stated by him in an article published by Reynolds's Newspaper, and issued as a pamphlet with the title Does Home Rule mean Rome Rule? In this he says:—

 *As a matter of historical fact, whenever Rome has openly attempted to interfere with freedom of opinion on the part of the Irish laity on political matters during the last hundred years, Ireland has resented this interference, and asserted her own independence.’’*


#### Our Politics from Rome


He gives three instances. Before Catholic Emancipation, the English Government tried to persuade the Roman Church to give it a veto on the appointment of Catholic Bishops in Ireland. His scheme was agreed to by three Archbishops of Ireland and seven Bishops. The Pope's Secretary of State, Cardinal Gonsalvi, came to





---

p.146




London and declared the Pope's acceptance of the proposal. It was defeated by the Catholic laity of Ireland, headed by O'Connell—several patriotic Bishops joining with him in his protest.


In 1883 a public testimonial to Mr. Parnell was set on foot, and subscriptions came in at a moderate rate. A Papal Rescript, dated May 11th, was issued warning Irish people, clergy and laity alike, to hold aloof from subscribing. The subscriptions were then £7,600. Within a month after the issue of the Rescript, the amount had doubled, and passed the £15,000 originally designed. The final figure reached was £37,000. All leading Irish Nationalists joined in denouncing what they regarded as an unwarrantable interference with their political rights.


In 1888 another Papal Rescript denounced the ‘Plan of Campaign’. Mr. Parnell declined to alter his policy.

 A meeting was held, at which every leading Catholic Nationalist denounced in the strongest terms this renewed interference. Mr. Sexton's words sum up their views:— ‘Our religion is independent of England and our politics are independent of Rome.’


#### Local Government and Unionists


Again, the A. B. C. says:

‘By the Local Government (Ireland) Act of 1898 Ireland has been given as full management of her own local affairs as is enjoyed by the other parts of the United Kingdom. When that Act was being passed the Nationalists promised as they are now doing—that the Unionist minority would have justice and fair play in the local councils. The Act conferred on the Irish Nationalists the power of proving their love of fair play and their professed desire to fraternise with their Unionist and Protestant fellow-countrymen. What happened? In almost every case every Protestant and Unionist was swept out of public existence, so far as it was possible, and Roman Catholics and Nationalists given entire control of those Irish counties where Protestants and Unionists found themselves in a minority. In the three provinces outside of Ulster there are only fifteen Unionists on the twenty-four County Councils of those provinces. The 





---

p.147




Nationalists number 684. In Ulster, where Unionists are better able to hold their own, the division is about equal, as between Unionists and Nationalists.’


This extract judiciously conceals the facts. There are, it appears, only fifteen cases in which a Nationalist electorate has returned a Unionist County Councillor; but there is no instance whatever in which a Unionist electorate has returned a Nationalist County Councillor. Half of Ulster is solidly Nationalist. There is this further point:—Nationalist electorates make no difficulty in returning Protestant representatives if their political opinions agree with those of the electors. No Unionist constituency has returned any Catholic.


What has happened is this. In a country where a political issue of tremendous importance has remained open, all elections have been taken with reference to opinions on that matter, but Nationalists have in some cases been willing to modify their assertions of principle by selecting men like Colonel Everard, whose services to the tobacco industry are so well known.


Under Home Rule the division would not be between Unionist and Nationalist, but, as elsewhere, between Conservative and Liberal or Radical—between the agrarian and the urban interests; the whole line of division would be altered.




---

p.148


### Chapter XV


#### Precedents for Home Rule


In conclusion, this falls to be said:—


The whole movement of the modern world is towards local autonomy. It is the guiding principle of the British Empire. Within the last twenty years no fewer than five Home Rule Parliaments with Home Rule constitutions and full responsible government have been created within the British Empire.


South Africa is the latest and most glorious example.


Even in India the beginnings of an extension of autonomy has been made.


Outside the British Empire the birth of representation and responsible government has been hailed by the whole civilised world in Turkey and in the Russian Duma. The suppression of Finland's autonomy has been regarded universally as a crime.


But most notable of all is the example of the great German Empire, concerning which Mr. Redmond has written in *Reynolds's Newsletter*:—


#### The German Empire


There are twenty-five States to-day in the German Empire, everyone of them autonomous, everyone of them with its own Parliament and Executive, with full control over all local, as distinct from Imperial, affairs.


One at least of these States, Prussia, is as large and populous as England. Another, Bavaria, closely resembles Ireland in area and population. A third, Wurtemburg, is almost identical in area and population with Wales.


Some of these States have a single-Chamber system, and some have a double-Chamber system; but in all of them local affairs are transacted quite independently of the control or interference of the German Imperial Parliament.




---

p.149


#### Difficulties which were surmounted


All the difficulties which are supposed to exist in conceding autonomy to Ireland exist to-day in Germany. Some of the German States are overwhelmingly Protestant. Others of them are overwhelmingly Catholic.


In Prussia, nearly two-thirds of the population are Protestants and rather over one-third Catholics. In 1905 the numbers were:—Protestants, 23,341,502; Catholics, 13,352,444; all others, about half a million.


In Bavaria, in 1905, there were 4,608,469 Catholics, 1,844,699 Protestants; and 55,000 Jews.


In Wurtemburg, by a strange coincidence, these proportions are almost exactly reversed, the Protestant population in 1905 being 1,582,745, and the Catholic population 695,808. And so on through these States, but in none of them has the religious difficulty, which is supposed to stand in the way of Home Rule for Ireland, caused the smallest trouble.


In Prussia, side by side with the Imperial Parliament, or Reichstadt, there stands, in Berlin, the Prussian Parliament, which as two Houses, with a Constitution in many respects exactly modelled on

the British Parliament. This Parliament, or local Legislature, deals with all internal affairs of Prussia. It cannot interfere, however, with the internal affairs of Bavaria or of Wurtemburg, or any other State, nor can it interfere in Imperial affairs, which are under the sole contol of the Imperial Parliament, in which all the States are represented. The Prussian Executive is responsible to this Parliament.


In Bavaria a similar Constitution exists, based upon what is practically manhood suffrage.


The same is true of Wurtemburg, and of the twenty two other States which go to make up the present German Empire.


#### Powers of subordinate Parliaments


These local Legislatures all through the Empire have full control of:—

1. Education.
2. Religion.
3. Police.
4. Land Tenure.
5. Local Government.
6. Direct Taxation.




---

p.150




And, in the case of the larger States, the management of railways, which are State enterprises, almost without exception, all through the Empire.


When Bismarck was framing his Constitution he declared:— ‘I am anxious that these people should go away heartily satisfied. What are treaties worth which people are forced to sign?’ Bismarck was no believer in paper Unions. A Union, to be effective for good, must be based upon mutual interest.


This great Home Rule Constitution has lasted now since 1871, and has led to freedom, contentment, and prosperity. The problem of combining national freedom with Imperial unity and strength has been completely solved by the magic of Home Rule.


#### Alsace-Lorraine


And now, after forty years of subjection as conquered provinces, Alsace and Lorraine are about to be presented with a representative Constitution.


One would fancy that any fair-minded man would admit that the difficulties and dangers surrounding the concession of Home Rule to Alsace-Lorraine were quite as great as, if not, indeed, far greater than, those which surround the Home Rule problem in Ireland, while the necessity for the granting of Home Rule to Alsace-Lorraine might easily be held not to be as urgent as is the case in Ireland, by reason of the fact that Alsace-Lorraine have shared in the general prosperity of the German Empire, whereas Ireland, for the last one hundred years, under the operation of the Union, has lost half her population, and has fallen back in every walk of industrial endeavour.


How far-reaching is the concession may be gathered from the

 correspondent of the Daily Telegraph, who writes:


> 
> The Alsace-Lorraine
> 
>  ‘Home Rule’ Bill emerges from the Reichstag Committee a much more democratic instrument than was anticipated, and, of course, immensely superior to the measure that was originally laid before the House. ‘One man, one vote’ has taken the place of a loaded plural voting system; the Reichsland, moreover, is given three votes in the Bundesrath, which is rather the Imperial 
> 
> 
> 
> 
> 
> ---
> 
> p.151
> 
> 
> 
> 
> Cabinet than an Upper House. This latter is an epoch making concession, as Prussia thereby endangers her whole hegemony in the Confederation of States and from the German Empire.
> 
> 
> Another progressive amendment effected by the Committee refers to freedom of religious belief and freedom of language. The elections will be held on Sundays. Not even the Catholic Centre was opposed to this. Subject to the control of the Imperial Government, the French language will be taught in the schools, and used in official documents in all districts where it is spoken by the preponderating majority of the population.
> 
> 
> On the whole, the Committee's decision is hailed by German Liberals with sincere rejoicings. The Berliner Tageblatt voices the universal opinion when it says that the democratic nature of the Alsace-Lorraine Constitution will have a favourable effect in the development of the political institutions in Prussia and the Empire.
> 
> 
> 




Shall England be less courageous and less liberal in her dealing with Ireland than Germany in her treatment of Alsace-Lorraine?


Every argument that is used against the granting of Home Rule to Ireland was used against the concession to Canada and to the Transvaal. These were arguments which justified themselves by appealing to the existence of old hatreds and injuries mutually inflicted; by reviving racial and religious differences. In every case the result of granting freedom has more than vindicated the wisdom of freedom's advocates.


Sir Edward Grey, speaking at a dinner given to the Colonial Premiers on Friday, April 19th, 1907, said:—



 ‘The history of our relations with our self-governing Colonies has been a great chapter in the history of freedom. Freedom gives to self-governing Colonies the power to develop their countries, and, what is more important, the special excellencies of their race and character, in the environment of the country in which they live. *That is a great gift—the power to develop—which freedom gave. But it has another gift—namely, that to healing*. In the history 





---

p.152




of one of our great Colonies we have already seen how it could heal wounds and strife, and bring races together, and we are confident, in our latest self-governing Colony, the healing gift of freedom will be equally potent, and we all feel that the tie between the mother country and the Colonies is now one which combined the advantages of union with the privileges of independence.’


There is no country in the world whose resources are more undeveloped than those of Ireland; none has deeper wounds to heal. It is time for England to listen to her courage rather than her fear, to her sympathy rather than her prejudices; it is time for her to seek to strengthen a friend rather than to keep an enemy under jealous constraint. Maintenance of the Union means a continuing of England's least honourable past; concession of freedom within the Empire means a new departure under the same inspiration as has led to England's honour and prosperity in every quarter of the world.


England has set to the world two great examples of liberty, first in perfecting democratic government for herself; secondly, in giving to her dependencies full freedom of self-government.


She has in her history one long-standing reproach, one unrighted transgression against liberty—her treatment of Ireland. It is time that she honoured her own record by giving to Ireland the opportunity once more to justify the principle of freedom.


Is Ireland fit for Self-Government?


She asks only the chance to prove her fitness. Have Englishmen, professedly advocates of freedom, the right to deny her that chance?


