

#The Battle of the Books


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Battle of the Books
=======================


Author: Jonathan Swift
----------------------


### File Description

D. Laing PurvesElectronic edition compiled by Beatrix Färber

Funded by University College, Cork and  
Writers of Ireland II Project 2. Second draft, revised and corrected.Proof corrections by Beatrix Färber

Extent of text: 13170 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork.  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2008) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E700001-012Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions and Secondary Literature**2. An excellent bibliography covering many aspects of Jonathan Swift's Life, his writings, and criticism, compiled by Lee Jaffe, is available at http://www.jaffebros.com/lee/gulliver/bib/index.html.
3. Sir William Temple, Essay on Ancient and Modern Learning, 1690.
4. William Wotton, Reflections upon Ancient and Modern Learning (1694; 2d enlarged ed. 1697; 3d enlarged ed. 1705).
5. J. Bowles Daly (ed.), Ireland in the days of Dean Swift, Irish tracts 1720–1734 (London 1887).
6. Frederick Ryland (ed.), Swift's Journal to Stella, A.D. 1710–1713 (London 1897).
7. Temple Scott (ed.), A tale of a tub, and other early works (London 1897).
8. Frederick Falkiner, Essays on the portraits of Swift: Swift and Stella (London 1908).
9. C. M. Webster, Swift's Tale of a Tub compared with Earlier Satires of the Puritans, Proceedings of the Modern Language Association 47/1 (March 1932) 171–178.
10. Stephen L. Gwynn, The life and friendships of Dean Swift (London 1933).
11. Stanley Lane-Poole (ed.), Selections from the prose writings of Jonathan Swift with a preface and notes (London 1933).
12. Ricardo Quintana, The mind and art of Jonathan Swift (Oxford 1936).
13. R. Wyse Jackson, Swift and his circle (Dublin 1945).
14. Martin Price, Swift's rhetorical art (New York 1953).
15. John Middleton Murry, Jonathan Swift: A Critical Biography. (London 1954).
16. Robert C. Elliott, Swift and Dr Eachard, Proceedings of the Modern Language Association 69/5 (December 1954) 1250–1257.
17. J. Middleton Murry, Swift. (London: Published for the British Council and the National Book League 1955).
18. Kathleen Williams, Swift and the age of compromise (London 1959).
19. John M. Bullitt, Jonathan Swift and the anatomy of satire: a study of satiric technique (Harvard 1961).
20. Harold Williams (ed.), The Correspondence of Jonathan Swift (Oxford 1963–65).
21. Herbert Davis (ed.), Jonathan Swift: essays on his satire and other studies. (New York 1964).
22. Herbert J. Davis (ed.), Gulliver's Travels [based on the Faulkner edition, Dublin 1735] (Oxford 1965).
23. Herbert J. Davis (ed.), Swift: poetical works (New York 1967).
24. R. B. McDowell, 'Swift as a political thinker'. In: Roger Joseph McHugh and Philip Edwards, Jonathan Swift: 1667–1967, a Dublin tercentenary tribute (Dublin 1967), 176–186.
25. Brian Vickers (ed.), The world of Jonathan Swift: essays for the tercentenary (Oxford 1968).
26. Kathleen Williams, Jonathan Swift. (London 1968).
27. Morris Golden, The self observed: Swift, Johnson, Wordsworth. (Baltimore 1972.)
28. Claude Julien Rawson, Gulliver and the gentle reader: studies in Swift and our time. (London and Boston 1973).
29. A. L. Rowse, Jonathan Swift, major prophet (London 1975).
30. Alexander Norman Jeffares, Jonathan Swift (London 1976).
31. Clive T. Probyn (ed.), The art of Jonathan Swift (London 1978).
32. Clive T. Probyn, Jonathan Swift: the contemporary background. (Manchester 1978).
33. Irvin Ehrenpreis, Swift: The man, his works, and the age (three volumes) (London 1962–83).
34. David M. Vieth (ed.), Essential articles for the study of Jonathan Swift's poetry (Hamden 1984).
35. James A. Downie, Jonathan Swift, political writer (London 1985).
36. Frederik N. Smith (ed.), The genres of Gulliver's travels (London 1990).
37. Joseph McMinn (ed.), Swift's Irish pamphlets (Gerrards Cross 1991).
38. Robert Mahony, Jonathan Swift: the Irish identity (Yale 1995).
39. Christopher Fox, Walking Naboth's vineyards: new studies of Swift (University of Notre Dame Ward-Philips lectures in English language and literature, Vol. 13). (Notre Dame/Indiana 1995).
40. Claude Rawson (ed.), Jonathan Swift: a collection of critical essays. (Englewood Cliffs, New Jeresey, 1995).
41. Michael Stanley, Famous Dubliners: W.B. Yeats, James Joyce, Jonathan Swift, Wolfe Tone, Oscar Wilde, Edward Carson. (Dublin 1996).
42. Daniel Carey, 'Swift among the freethinkers'. Eighteenth-century Ireland: Iris an dá chultúr, 12 (1997), 89–99.
43. Victoria Glendinning, Jonathan Swift (London 1998).
44. Aileen Douglas; Patrick Kelly; Ian Campbell Ross, (eds.). Locating Swift: essays from Dublin on the 250th anniversary of the death of Jonathan Swift, 1667–1745. (Dublin 1998.
45. Bruce Arnold, Swift: an illustrated life. (Dublin 1999).
46. Nigel Wood (ed.), Jonathan Swift. (London and New York 1999).
47. Christopher J. Fauske, Jonathan Swift and the Church of Ireland, 1710–24 (Portland 2001).
48. David George Boyce; Robert Eccleshall; Vincent Geoghegan (eds.), Political discourse in seventeenth- and eighteenth-century Ireland. (Basingstoke and New York 2001).
49. Albert J. Rivero (ed.), Gulliver's travels: based on the 1726 text by Jonathan Swift (New York 2002).
50. Ann Cline Kelly, Jonathan Swift and popular culture: myth, media and the man. (Basingstoke 2002).
51. Dirk F. Passmann and Heinz J. Vienken, The library and reading of Jonathan Swift: a bio-bibliographical handbook. 4 vols. (Frankfurt 2003).
52. Mark McDayter, 'The haunting of St James's Library: librarians, literature, and The Battle of the Books'. Huntington Library Quarterly, 66:1–2 (2003) 1–26.
53. Frank T. Boyle, 'Jonathan Swift' [A companion to satire]. In: Ruben Quintero (ed.), A companion to satire (Oxford 2007) 196–211.
54. Harry Whitaker, C. U. M. Smith and Stanley Finger (eds.), Explorations of the brain, mind and medicine in the writings of Jonathan Swift. Springer (US) 2007.
55. For the controversy of the Ancients v. Moderns between Temple and Bentley see Cambridge History of English and American Literature in 18 Volumes (1907–21) online at http://www.bartleby.com/219/1510.html
**The edition used in the digital edition**2. **D. Laing Purves**, The Battle of the Books in The works of Jonathan Swift D. D., Dean of St. Patrick's, Dublin. Carefully selected: with a biography of the author, by D. Laing Purves; and original and authentic notes, Ed. D. Laing Purves. , Edinburgh, William P. Nimmo & Co. (1880) page 98–109

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The text covers pages 98–109.


#### Editorial Declaration


##### Correction


The text has been proof-read once.


##### Normalization


The electronic text represents the edited text; with modernised spelling. The author's practice of capitalizing certain words, or writing them entirely in uppercase was abandoned. The editor has also modernised punctuation and, in one instance, omitted parts of the text due to strong language. These have been filled in from a 1750 edition and are marked sup resp="JS". The editor's notes are tagged note type="auth" n=""; and where he occasionally makes reference to footnotes outside the scope of the scanned text, the substance of these is given in square brackets.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (hard or soft) crosses a line break, the break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the satire; preceded by two Introductions and a Preface in separate divs; div1=the section. Paragraphs are marked; page-breaks are marked pb n="".


##### Interpretation


Personal names persons are not tagged. Terms for cultural and social roles are not tagged.


#### Canonical References


The *n* attribute of each text in this corpus carries a

unique identifying number for the whole text. The title of the text is held as the first *head* element within each text.


*div0* is reserved for the text (whether in one volume or many).


### Profile Description


Created: By Jonathan Swift

 (1697) #### Use of language


##### Language: [EN] The whole text is in English.


##### Language: [FR] A few words are in French.


##### Language: [LA] Some text is in Latin.


### Revision History


* (2010-08-04) Beatrix Färber (ed.)

* Conversion script run; header updated, file parsed. New SGML and HTML files created.
* (2008-09-23) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2008-07-24) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, content of 'langUsage' revised; minor modifications made to header.
* (2008-01-29) Beatrix Färber (ed.)

* Additions to bibliography and new wordcount made. New SGML and HTML version created.
* (2007-12-11) Beatrix Färber (ed.)

* Additions to bibliography made; file parsed; SGML and HTML version created.
* (2007-07-09) Beatrix Färber (ed.)

* File proofing completed; file parsed; SGML and HTML version created.
* (2007-07-04) Beatrix Färber (ed.)

* Header created. Additions to bibliography made; text of the introduction typed in; file proofed (1); footnotes typed in; file parsed; SGML and HTML version created.
* (2006-03-16) Benjamin Hazard (Text capture)

* Main body text scanned.
* (2005-08) Benjamin Hazard (ed.)

* Bibliography compiled.




---


#### Corpus of Electronic Texts Edition: E700001-012


### The Battle of the Books: Author: Jonathan Swift


### Analytical Table


The Preface informs us this piece was written in 1697, on account of a famous dispute about Ancient and Modern Learning, between **Sir William Temple**, and the **Earl of **Orrery****, on the one side, and **Mr Wotton** and **Bentley** on the other.


War and invasions generally proceed from the attacks of Want and Poverty upon Plenty and Riches. The Moderns quarrel with the Ancients about the possession of the highest top of Parnassus; and desire them to surrender it, or to let it be levelled. The answer of the Ancients not accepted. A war ensues; in which rivulets of ink are spilt; and both parties hang out their trophies, books of controversy. These books haunted with disorderly spirits; though often bound to the peace in Libraries. The Author's advice in this case neglected; which occasions a terrible fight in St James's Library. **Dr Bentley**, the Library-keeper, a great enemy to the Ancients. The Moderns, finding themselves 50,000 strong, give the Ancients ill language. **Temple**, a favourite of the Ancients. An incident of a quarrel between



---

p.99




a Bee and a Spider; with their arguments on both sides. Æsop applies them to the present dispute. The order of battle of the Moderns, and names of their leaders. The leaders of the Ancients. Jupiter calls a Council of the Gods, and consults the books of Fate; and then sends his orders below. Momus brings the news to Criticism; whose habitation and company are described. Paracelsus engages Galen; Aristotle aims at Bacon, and kills Descartes; Homer overthrows Gondibert; kills Denham and Wesley, Perrault and Fontenelle. Encounter of Virgil and Dryden; of Lucan and Blackmore; of Creech and Horace; of Pindar and Cowley. The episode of Bentley and Wotton. Bentley's armour. His speech to the modern generals. Scaliger's answer. Bentley and Wotton march together. Bentley attacks Phalaris and Æsop. Wotton attacks Temple, in vain. Boyle pursues Wotton; and, meeting Bentley in his way, he pursues and kills them both.


### The Bookseller to the Reader


The following discourse, as it is unquestionably of the same author, so it seems to have been written about the same time, with the former; I mean the year 1697, when the famous dispute was on foot about ancient and modern learning. The controversy took its rise from an essay of **Sir William Temple**'s upon that subject; which was answered by W. Wotton, B.D. with an appendix by **Dr. Bentley**, endeavouring to destroy the credit of Æsop and Phalaris for authors, whom **Sir William Temple** had in the essay before mentioned highly commended. In that appendix the doctor falls hard upon a new edition of Phalaris, put out by the honourable **Charles Boyle (now Earl of **Orrery****) to which Mr. Boyle replied at large with great learning and wit; and the doctor voluminously rejoined. In this dispute, the town highly resented to see a person of Sir William Temple's character and merits roughly used by the two reverend gentlemen aforesaid, and without any manner of provocation. At length, there appearing no end of the quarrel, our author tells us, that the BOOKS in St. James's Library, looking upon themselves as parties principally concerned, took up the controversy, and came to a decisive battle; but, the manuscript, by the injury of fortune or weather, being in several places imperfect, we cannot learn to which side the victory fell.


I must warn the reader to beware of applying to persons, what is here meant only of books in the most literal sense. So, when Virgil is mentioned, we are not to understand the person of a famous poet called by that name; but only certain sheets of paper, bound up in leather, containing in print the works of the said poet: and so of the rest.


### The Preface of the Author


Satire is a sort of glass,[1](javascript:footNote('E700001-012/note001.html')) wherein beholders do generally discover everybody's face but their own; which is the chief reason for that kind of reception it meets with in the world, and that so very few are offended with it. But if it should happen otherwise, the danger is not great; and I have learned from long experience never to apprehend mischief from those understandings I have been able to provoke: for anger and fury, though they add strength to the sinews of the body, yet are found to relax those of the mind, and to render all its efforts feeble and impotent.


There is a brain, that will endure but one scumming; let the owner gather it with discretion, and manage his little stock with husbandry; but, of all things, let him beware of bringing it under the lash of his betters; because that will make it all bubble up into impertinence, and he will find no new supply. Wit without knowledge being a sort of cream, which gathers in a night to the top, and by a skilful hand may be soon whipped into froth; but once scummed away, what appears underneath will be fit for nothing but to be thrown to the hogs.


Whoever examines, with due circumspection, into the annual records of time, will find it remarked that war is the child of pride, and pride the daughter of riches:[2](javascript:footNote('E700001-012/note002.html')) the former of which assertions may be soon granted, but one cannot so easily subscribe to the latter; for pride is nearly related to beggary and want, either by father or mother, and sometimes by both; and, to speak naturally, it very seldom happens among men to fall out when all have enough; invasions usually travelling from north to south, that is to say, from poverty to plenty. The most ancient and natural grounds of quarrels are lust and avarice; which, though we may allow to be brethren, or collateral branches, of pride, are certainly the issues of want. For, to speak in the phrase of writers upon politics, we may observe in the republic of dogs, which in its original seems to be an institution of the many,[3](javascript:footNote('E700001-012/note003.html')) that the whole state is ever in the profoundest peace after a full meal; and that civil broils arise among them when it happens for one great bone to be seized on by some leading dog, who either divides it among the few, and then it falls to an oligarchy, or keeps it to himself, and then it runs up to a tyranny. The same reasoning also holds place among them in those dissensions we behold upon a turgescency in any





---

p.100




of their females. For the right of possession lying in common, (it being impossible to establish a property in so delicate a case,) jealousies and suspicions do so abound, that the whole commonwealth of that street is reduced to a manifest state of war, of every citizen against every citizen, till some one of more courage, conduct, or fortune, than the rest, seizes and enjoys the prize: upon which naturally arises plenty of heart-burning, and envy, and snarling against the happy dog. Again, if we look upon any of these republics engaged in a foreign war, either of invasion or defence, we shall find the same reasoning will serve as to the grounds and occasions of each; and that poverty or want, in some degree or other (whether real, or in opinion, which makes no alteration in the case,) has a great share, as well as pride, on the part of the aggressor.


Now, whoever will please to take this scheme, and either reduce or adapt it to an intellectual state or commonwealth of learning, will soon discover the first ground of disagreement between the two great parties at this time in arms; and may form just conclusions upon the merits of either cause. But the issue or events of this war are not so easy to conjecture at; for the present quarrel is so inflamed by the warm heads of either faction, and the pretensions somewhere or other *are* so exorbitant, as not to admit the least overtures of accommodation. This quarrel first began, as I have heard it affirmed by an old dweller in the neighbourhood, about a small spot of ground, lying and being upon one of the two tops of the hill Parnassus; the highest and largest of which had, it seems, been time out of mind in quiet possession of certain tenants, called the Ancients; and the other was held by the Moderns. But these, disliking their present station, sent certain ambassadors to the Ancients; complaining of a great nuisance; how the height of that part of Parnassus quite spoiled the prospect of theirs, especially towards the East;[4](javascript:footNote('E700001-012/note004.html')) and therefore, to avoid a war, offered them the choice of this alternative: either that the Ancients would please to remove themselves and their effects down to the lower summit, which the Moderns would graciously surrender to them and advance into their place; or else the said Ancients will give leave to the Moderns to come with shovels and mattocks, and level the said hill as low as they shall think it convenient. To which the Ancients made answer, how little they expected such a message as this from a colony whom they had admitted, out of their own free grace, to so near a neighbourhood. That, as to their own seat, they were aborigines of it, and therefore to talk with them of a removal or surrender was a language they did not understand. That if the height of the hill on their side shortened the prospect of the Moderns, it was a disadvantage they could not help; but desired them to consider whether that injury (if it be any) were not largely recompensed by the shade and shelter it afforded them. That as to the levelling or digging down, it was either folly or ignorance to propose it if they did or did not know how that side of the hill was an entire rock, which would break their tools and hearts, without any damage to itself. That they would therefore advise the Moderns rather to raise their own side of the hill, than dream of pulling down that of the Ancients; to the former of which they would not only give licence, but also largely contribute. All this was rejected by the Moderns with much indignation, who still insisted upon one of the two expedients; and so this difference broke out into a long and obstinate war, maintained on the one part by resolution, and by the courage of certain leaders and allies; but on the other by the greatness of their number, upon all defeats affording continual recruits. In this quarrel whole rivulets of ink have been exhausted, and the virulence of both parties enormously augmented. Now, it must be here understood that ink is the great missive weapon in all battles of the learned, which, conveyed through a sort of engine called a quill, infinite numbers of these are darted at the enemy by the valiant on each side, with equal skill and violence, as if it were an *engagement* of porcupines. This malignant liquor was compounded, by the engineer who invented it, of two ingredients, which are, gall and copperas; by its bitterness and venom to suit in some degree, as well as to foment, the genius of the combatants. And as the Grecians, after an engagement, when they could not agree about the victory, were wont to set up trophies on both sides, the beaten party being content to be at the same expense, to keep itself in countenance, (a laudable and ancient custom, happily revived of late in the art of war;) so the learned, after a sharp and bloody dispute, do on both sides, hang out their trophies too, whichever comes by the worst. These trophies have largely inscribed on them the merits of the cause; a full impartial account of such a battle, and how the victory fell clearly to the party that set them up. They are known to the world under several names; as disputes, arguments, rejoinders, brief considerations, answers, replies, remarks, reflections, objections, confutations. For a very few days they are fixed up all in public places, either by themselves or their representatives,[5](javascript:footNote('E700001-012/note005.html')) for passengers to gaze at; whence the chiefest and largest are removed to certain magazines they call libraries, there to remain in a quarter purposely assigned them, and thenceforth begin to be called books of controversy.


In these books is wonderfully instilled and preserved the spirit of each warrior, while he is alive; and after his death his soul transmigrates thither to inform them. This at least is the more common opinion; but I believe it is with libraries as with other cemeteries; where some





---

p.101




 philosophers affirm that a certain spirit, which they call brutum hominis, hovers over the monument, till the body is corrupted and turns to dust or to worms, but then vanishes or dissolves; so, we may say, a restless spirit haunts over every book, till dust or worms have seized upon it; which to some may happen in a few days, but to others later: and therefore, books of controversy being of all others, haunted by the most disorderly spirits, have always been confined in a separate lodge from the rest; and, for fear of a mutual violence against each other, it was thought prudent by our ancestors to bind them to the peace with strong iron chains. Of which invention the original occasion was this: When the works of Scotus first came out, they were carried to a certain library, and had lodgings appointed them; but this author was no sooner settled, than he went to visit his master Aristotle; and there both concerted together to seize Plato by main force, and turn him out from his ancient station among the divines, where he had peaceably dwelt near eight hundred years. The attempt succeeded, and the two usurpers have reigned ever since in his stead: but, to maintain quiet for the future, it was decreed that all *polemics* of the larger size should be hold fast with a chain.


By this expedient, the public peace of libraries might certainly have been preserved if a new species of controversial books had not arisen of late years, instinct with a more malignant spirit, from the war above mentioned between the learned about the higher summit of *Parnassus*.


When these books were first admitted into the public libraries, I remember to have said, upon occasion, to several persons concerned, how I was sure they would create broils wherever they came, unless a world of care were taken: and therefore I advised, that the champions of each side should be coupled together or otherwise mixed, that, like the blending of contrary poisons, their malignity might be employed among themselves. And it seems I was neither an ill prophet nor an ill counsellor; for it was nothing else but the neglect of this caution which gave occasion to the terrible fight that happened on Friday last between the Ancient and Modern books in the King's library. Now, because the talk of this battle is so fresh in everybody's mouth, and the expectation of the town so great to be informed in the particulars, I, being possessed of all qualifications requisite in an historian, and retained by neither party, have resolved to comply with the urgent importunity of my friends, by writing down a full impartial account thereof.


The guardian of the regal library,[6](javascript:footNote('E700001-012/note006.html')) a person of great valour, but chiefly renowned for his humanity, had been a fierce champion for the 

Moderns; and, in an engagement upon Parnassus, had vowed with his own hands to knock down two of the ancient chiefs, who guarded a small pass on the superior rock; but, endeavouring to climb up, was cruelly obstructed by his own unhappy weight and tendency towards his centre; a quality to which those of the Modern party are extremely subject; for, being light-headed, they have, in speculation, a wonderful agility, and conceive nothing too high for them to mount; but, in reducing to practice, discover a mighty pressure about their posteriors and their heels. Having thus failed in his design, the disappointed champion bore a cruel rancour to the Ancients; which he resolved to gratify by showing all marks of his favour to the books of their adversaries, and lodging them in the fairest apartments; when, at the same time, whatever book had the boldness to own itself for an advocate of the Ancients was buried alive in some obscure corner, and threatened upon the least displeasure to be turned out of doors. Besides, it so happened that about this time there was a strange confusion of place among all the books in the library; for which several reasons were assigned. Some imputed it to a great heap of learned dust, which a perverse wind blew off from a shelf of Moderns into the keeper's eyes. Others affirmed he had a humour to pick the worms out of the schoolmen, and swallow them fresh and fasting; whereof some fell upon his spleen, and some climbed up into his head, to the great perturbation of both. And lastly, others maintained that, by walking much in the dark about the library, he had quite lost the situation of it out of his head; and therefore, in replacing his books, he was apt to mistake, and clap Descartes next to Aristotle; poor Plato had got between Hobbes and the Seven Wise Masters, and Virgil was hemmed in with Dryden on one side and Withers on the other.


Meanwhile, those books that were advocates for the Moderns chose out one from among them to make a progress through the whole library, examine the number and strength of their party, and concert their affairs. This messenger performed all things very industriously, and brought back with him a list of their forces: in all, fifty thousand, consisting chiefly of light-horse, heavy-armed foot, and mercenaries; whereof the foot were in general but sorrily armed and worse clad; their horses *of the cavalry* large, but extremely out of case and heart; however, some few, by trading among the Ancients, had furnished themselves tolerably enough.


While things were in this ferment, discord grew extremely high; hot words passed on both sides, and ill blood was plentifully bred. Here a solitary Ancient, squeezed up among a whole shelf of Moderns, offered fairly to dispute the case, and to prove by manifest reason that the priority was due to them from long possession, and in regard of their prudence, antiquity, and above all their great merits toward the Moderns. But these denied the premises, and seemed very





---

p.102




 much to wonder how the Ancients could pretend to insist upon their antiquity, when it was so plain (if they went to that) that the Moderns were much the more ancient of the two.[7](javascript:footNote('E700001-012/note007.html')) As for any obligations they owed to the Ancients, they renounced them all. ‘It is true,’ said they, ‘we are informed some few of our party have been so mean *as* to borrow their subsistence from you, but the rest, infinitely the greater number, (and especially we French and English,) were so far from stooping to so base an example, that there never passed, till this very hour, six words between us. For our horses were of our own breeding, our arms of our own forging, and our clothes of our own cutting out and sewing.’ Plato was by chance up on the next shelf; and observing those that spoke to be in the ragged plight mentioned a while ago, their jades lean and foundered, their weapons of rotten wood, their armour rusty, and nothing but rags underneath; he laughed loud, and in his pleasant way swore, by ——, he believed them.


Now, the Moderns had not proceeded in their late negotiation with secrecy enough to escape the notice of the enemy. For those advocates who had begun the quarrel by setting first on foot the dispute of precedency, talked so loud of coming to a battle, that Temple[8](javascript:footNote('E700001-012/note008.html')) happened to overhear them, and gave immediate intelligence to the Ancients; who thereupon drew up their scattered troops together, resolving to act upon the defensive; upon which, several of the Moderns fled over to their party, and among the rest Temple himself. This Temple, having been educated and long conversed among the Ancients, was, of all the Moderns, their greatest favourite, and became their greatest champion.


Things were at this crisis, when a material accident fell out. For upon the highest corner of a large window there dwelt a certain spider, swollen up to the first magnitude by the destruction of infinite numbers of flies, whose spoils lay scattered before the gates of his palace, like human bones before the cave of some giant. The avenues to his castle were guarded with turnpikes and palisadoes, all after the modern way of fortification.[9](javascript:footNote('E700001-012/note009.html')) After you had passed several courts, you came to the centre, wherein you might behold the constable himself in his own lodgings, which had windows fronting to each avenue, and ports to sally out upon all occasions of prey or defence. In this mansion he had for some time dwelt in peace and plenty, without danger to his person by swallows from above, or to his palace by brooms from below: when it was the pleasure of fortune to conduct thither a wandering bee, to whose curiosity a broken pane in the glass had discovered itself; and in he went, where, expatiating a while, he at last happened to alight upon one of the outward walls of the spider's citadel; which, yielding to the unequal weight, sunk down to the very foundation. Thrice he endeavoured to force his passage, and thrice the centre shook. The spider within, feeling the terrible convulsion, supposed at first that nature was approaching to her final dissolution; or else that Beelzebub,[10](javascript:footNote('E700001-012/note010.html')) with all his legions, was come to revenge the death of many thousands of his subjects whom his enemy had slain and devoured. However, he at length valiantly resolved to issue forth and meet his fate. Meanwhile, the bee had acquitted himself of his toils, and, posted securely at some distance, was employed in cleansing his wings, and disengaging them from the ragged remnants of the cobweb. By this time the spider was adventured out, when, beholding the chasms, the ruins, and dilapidations of his fortress, he was very near at his wit's end; he stormed and swore like a madman, and swelled till he was ready to burst. At length, casting his eye upon the bee, and wisely gathering causes from events (for they know each other by sight,) ‘A plague split you,’ said he; ‘*for a giddy son of a whore.* Is it you, with a vengeance, that have made this litter here? Could not you look before you, and be d——d? Do you think I have nothing else to do (in the devil's name) but to mend and repair after your a*rse*?’ ‘Good words, friend,’ said the bee (having now pruned himself, and being disposed to droll): ‘I'll give you my hand and word to come near your kennel no more; I was never in such a confounded pickle since I was born.’ ‘Sirrah,’ replied the spider, ‘if it were not for breaking an old custom in our family, never to stir abroad against an enemy, I should come and teach you better manners.’ ‘I pray have patience,’ said the bee, ‘or you'll spend your substance, and, for aught I see, you may stand in need of it all, towards the repair of your house.’ ‘Rogue, rogue,’ replied the spider, ‘yet methinks you should have more respect to a person whom all the world allows to be so much your betters.’ ‘By my troth,’ said the bee, ‘the comparison will amount to a very good jest, and you will do me a favour to let me know the reasons that all the world is pleased to use in so hopeful a dispute.’ At this the spider, having swelled himself into the size and posture of a disputant, began his argument in the true spirit of controversy, with resolution to be heartily scurrilous and angry, to urge on his own reasons without the least regard to the answers or objections of his opposite, and fully predetermined in his mind against all conviction.


‘Not to disparage myself,’ said he, ‘by the comparison with such a rascal, what art thou but a vagabond without house or home, without stock or inheritance; born to no possession of your





---

p.103




own, but a pair of wings and a drone-pipe. Your livelihood is a universal plunder upon nature; a freebooter over fields and gardens; and, for the sake of stealing, will rob a nettle as easily as a violet. Whereas I am a domestic animal, furnished with a native stock within myself. This large castle (to show my improvements in the mathematics) is all built with my own hands, and the materials extracted altogether out of my own person.’


‘I am glad,’ answered the bee, ‘to hear you grant at least that I am come honestly by my wings and my voice; for then, it seems, I am obliged to Heaven alone for my flights and my music; and Providence would never have bestowed on me two such gifts without designing them for the noblest ends. I visit, indeed, all the flowers and blossoms of the field and garden; but whatever I collect thence enriches myself without the least injury to their beauty, their smell, or their taste. Now, for you and your skill in architecture and other mathematics, I have little to say: in that building of yours there might, for aught I know, have been labour and method enough; but, by woeful experience for us both, it is too plain the materials are naught; and I hope you will henceforth take warning, and consider duration and matter, as well as method and art. You boast indeed of being obliged to no other creature, but of drawing and spinning out all from yourself; that is to say, if we may judge of the liquor in the vessel by what issues out, you possess a good plentiful store of dirt and poison in your breast; and, though I would by no means lesson or disparage your genuine stock of either, yet I doubt you are somewhat obliged, for an increase of both, to a little foreign assistance. Your inherent portion of dirt does not fail of acquisitions by sweepings exhaled from below; and one insect furnishes you with a share of poison to destroy another. So that, in short, the question comes all to this; whether is the nobler being of the two, that which, by a lazy contemplation of four inches round, by an overweening pride, feeding, and engendering on itself, turns all into excrement and venom, producing nothing at all but flybane and a cobweb; or that which, by a universal range, with long search, much study, true judgment, and distinction of things, brings home honey and wax?’


This dispute was managed with such eagerness, clamour, and warmth, that the two parties of books, in arms below, stood silent a while, waiting in suspense what would be the issue; which was not long undetermined; for the bee, grown impatient at so much loss of time, fled straight away to a bed of roses, without looking for a reply, and left the spider, like an orator, collected in himself, and just prepared to burst out.


It happened upon this emergency that Æsop broke silence first. He had been of late most barbarously treated by a strange effect of the regent's humanity, who had torn off his title-page, sorely defaced one half of his leaves, and chained him fast among a shelf of Moderns.[11](javascript:footNote('E700001-012/note011.html')) Where soon discovering how high the quarrel was likely to proceed, he tried all his arts, and turned himself to a thousand forms. At length, in the borrowed shape of an ass, the regent mistook him for a Modern; by which means he had time and opportunity to escape to the Ancients, just when the spider and the bee were entering into their contest; to which he gave his attention with a world of pleasure, and when it was ended, swore in the loudest key that in all his life he had never known two cases so parallel and adapt to each other as that in the window and this upon the shelves. ‘The disputants,’ said he, ‘have admirably managed the dispute between them, have taken in the full strength of all that is to be said on both sides, and exhausted the substance of every argument *pro* and *con*. It is but to adjust the reasonings of both to the present quarrel; then, to compare and apply the labours and fruits of each, as the bee has learnedly deduced them; and we shall find the conclusion fall plain and close upon the Moderns and us. For pray, gentlemen, was ever anything so modern as the spider in his air, his turns, and his paradoxes? He argues in the behalf of you his brethren and himself, with many boastings of his native stock and great genius; that he spins and spits wholly from himself, and scorns to own any obligation or assistance from without. Then he displays to you his great skill in architecture and improvement in the mathematics. To all this the bee, as an advocate retained by us, the Ancients, thinks fit to answer: that, if one may judge of the great genius or inventions of the Moderns by what they have produced, you will hardly have countenance to bear you out in boasting of either. Erect your schemes with as much method and skill as you please; yet, if the materials be nothing but dirt, spun out of your own entrails (the guts of modern brains), the edifice will conclude at last in a cobweb; the duration of which, like that of other spiders' webs, may be imputed to their being forgotten, or neglected, or hid in a corner. For anything else of genuine that the Moderns may pretend to, I cannot recollect; unless it be a large vein of wrangling and satire, much of a nature and substance with the spiders' poison; which, however they pretend to spit wholly out of themselves, is improved by the same arts, by feeding upon the insects and vermin of the age. As for us, the Ancients, we are content with the bee, to pretend to nothing of our own beyond our wings and our voice: that is to say, our flights and our language. For the rest, whatever we have got has been by infinite labour and search, and ranging through every corner of nature; the difference is, that, instead of dirt and poison, we have rather chosen to fill our hives with honey and wax; thus furnishing mankind with the two noblest of things, which are sweetness and light.’




---

p.104


It is wonderful to conceive the tumult arisen among the books upon the close of this long descant of Æsop: both parties took the hint, and heightened their animosities so on a sudden, that they resolved it should come to a battle. Immediately the two main bodies withdrew, under their several ensigns, to the farther parts of the library, and there entered into cabals and consults upon the present emergency. The Moderns were in very warm debates upon the choice of their leaders; and nothing less than the fear impending from their enemies could have kept them from mutinies upon this occasion. The difference was greatest among the horse, where every private trooper pretended to the chief command, from Tasso and Milton to Dryden and Withers. The light-horse[12](javascript:footNote('E700001-012/note012.html')) were commanded by Cowley and Despreaux.[13](javascript:footNote('E700001-012/note013.html')) There came the bowmen[14](javascript:footNote('E700001-012/note014.html')) under their valiant leaders, Descartes, Gassendi, and Hobbes; whose strength was such that they could shoot their arrows beyond the atmosphere, never to fall down again, but turn, like that of Evander, into meteors; or, like the cannon-ball, into stars. Paracelsus brought a squadron of stinkpot-flingers from the snowy mountains of Rhaetia[15](javascript:footNote('E700001-012/note015.html')). There came a vast body of dragoons, of different nations, under the leading of Harvey,[16](javascript:footNote('E700001-012/note016.html')) their great Aga: part armed with scythes, the weapons of death; part with lances and long knives, all steeped in poison; part shot bullets of a most malignant nature, and used white powder, which infallibly killed without report. There came several bodies of heavy-armed foot, all mercenaries, under the ensigns of Guicciardini, Davila, Polydore Vergil, Buchanan, Mariana, Camden, and others.[17](javascript:footNote('E700001-012/note017.html')) The engineers were commanded by Regiomontanus and Wilkins.[18](javascript:footNote('E700001-012/note018.html')) The rest was a confused multitude, led by Scotus, Aquinas, and Bellarmine; of mighty bulk and stature, but without either arms, courage, or discipline.[19](javascript:footNote('E700001-012/note019.html')) In the last place came infinite swarms of calones,[20](javascript:footNote('E700001-012/note020.html')) a disorderly rout led by L'Estrange; rogues and ragamuffins, that follow the camp for nothing but the plunder; all without coats to cover them.


The army of the Ancients was much fewer in number; Homer led the horse, and Pindar the light-horse; Euclid was chief engineer; Plato and Aristotle commanded the bowmen; Herodotus and Livy the foot; Hippocrates, the dragoons; the allies, led by Vossius[21](javascript:footNote('E700001-012/note021.html')) and Temple, brought up the rear.


All things violently tending to a decisive battle, Fame, who much frequented and had a large apartment formerly assigned her in the regal library, fled up straight to Jupiter, to whom she delivered a faithful account of all that passed between the two parties below; for among the gods she always tells truth. Jove, in great concern, convokes a council in the Milky Way. The senate assembled, he declares the occasion of convening them; a bloody battle just impendent between two mighty armies of ancient and modern creatures, called books, wherein the celestial interest was but too deeply concerned. Momus,[22](javascript:footNote('E700001-012/note022.html')) the patron of the Moderns, made an excellent speech in their favour; which was answered by Pallas, the protectress of the Ancients. The assembly *was* divided in their affections; when Jupiter commanded the book of Fate to be laid before him. Immediately were brought by Mercury three large volumes in folio, containing memoirs of all things past, present, and to come. The clasps were of silver double gilt, the covers of celestial turkey leather, and the paper such as here on earth might pass almost for vellum. Jupiter, having silently read the decree, would communicate the import to none, but presently shut up the book.


Without the doors of this assembly there attended a vast number of light, nimble gods, menial servants to Jupiter: those are his ministering





---

p.105




instruments in all affairs below. They travel in a caravan, more or less together, and are fastened to each other like a link of galley-slaves, by a light chain, which passes from them to Jupiter's great toe: and yet, in receiving or delivering a message, they may never approach above the lowest step of his throne, where he and they whisper to each other through a large hollow trunk. These deities are called by mortal men *accidents* or *events;* but the gods call them *second causes.* Jupiter having delivered his message to a certain number of these divinities, they flew immediately down to the pinnacle of the regal library, and consulting a few minutes, entered unseen, and disposed the parties according to their orders.


Meanwhile Momus, fearing the worst, and calling to mind an ancient prophecy which bore no very good face to his children the Moderns, bent his flight to the region of a malignant deity, called Criticism. She dwelt on the top of a snowy mountain in Nova Zembla; there Momus found her extended in her den, upon the spoils of numberless volumes half devoured. At her right hand sat Ignorance, her father and husband, blind with age; at her left, Pride, her mother, dressing her up in the scraps of paper herself had torn. There was Opinion, her sister, light of foot, hood-winked, and head-strong, yet giddy and perpetually turning. About her played her children, Noise and Impudence, Dulness and Vanity, Positiveness, Pedantry, and Ill-manners. The goddess herself had claws like a cat; her head, and ears, and voice resembled those of an ass; her teeth fallen out before, her eyes turned inward, as if she looked only upon herself; her diet was the overflowing of her own gall; her spleen was so large as to stand prominent, like a dug of the first rate, nor wanted excrescences in form of teats, at which a crew of ugly monsters were greedily sucking; and, what is wonderful to conceive, the bulk of spleen increased faster than the sucking could diminish it. ‘Goddess,’ said Momus, ‘can you sit idly here while our devout worshippers, the Moderns, are this minute entering into a cruel battle, and perhaps now lying under the swords of their enemies? Who then hereafter will ever sacrifice or build altars to our divinities? Haste, therefore, to the British isle, and, if possible, prevent their destruction; while I make factions among the gods, and gain them over to our party.’


Momus, having thus delivered himself, staid not for an answer, but left the goddess to her own resentment. Up she rose in a rage, and, as it is the form on such occasions, began a soliloquy: ‘It is I’ (said she) ‘who give wisdom to infants and idiots; by me children grow wiser than their parents, by me beaux become politicians, and schoolboys judges of philosophy; by me sophisters debate and conclude upon the depths of knowledge; and coffeehouse wits, instinct by me, can correct an author's style, and display his minutest errors, without understanding a syllable of his matter or his language; by me striplings spend their judgment, as they do their estate, before it comes into their hands. It is I who have deposed wit and knowledge from their empire over poetry, and advanced myself in their stead. And shall a few upstart Ancients dare to oppose me?—But come, my aged parent, and you, my children dear, and thou, my beauteous sister; let us ascend my chariot, and haste to assist our devout Moderns; who are now sacrificing to us a hecatomb, as I perceive by that grateful smell which from thence reaches my nostrils.’


The goddess and her train, having mounted the chariot, which was drawn by tame geese, flew over infinite regions, shedding her influence in due places, till at length she arrived at her beloved island of Britain; but in hovering over its metropolis, what blessings did she not let fall upon her seminaries of Gresham and Covent-Garden![23](javascript:footNote('E700001-012/note023.html')) And now she reached the fatal plain of St. James's library, at what time the two armies were upon the point to engage; where, entering with all her caravan unseen, and landing upon a case of shelves, now desert, but once inhabited by a colony of virtuosos, she staid a while to observe the posture of both armies.


But here the tender cares of a mother began to fill her thoughts and move in her breast: for at the head of a troup of Modern bowmen she cast her eyes upon her son Wotton, to whom the fates had assigned a very short thread: Wotton, a young hero, whom an unknown father of mortal race begot by stolen embraces with this goddess. He was the darling of his mother above all her children, and she resolved to go and comfort him. But first, according to the good old custom of deities, she cast about to change her shape, for fear the divinity of her countenance might dazzle his mortal sight, and overcharge the rest of his senses. She therefore gathered up her person into an octavo compass: her body grew white and arid, and split in pieces with dryness; the thick turned into pasteboard, and the thin into paper, upon which her parents and children artfully strewed a black juice, or decoction of gall and soot, in form of letters: her head, and voice, and spleen, kept their primitive form; and that which before was a cover of skin did still continue so. In this guise she marched on towards the Moderns, indistinguishable in shape and dress from the divine Bentley, Wotton's dearest friend. ‘Brave Wotton,’ said the goddess, ‘why do our troops stand idle here, to spend their present vigour and opportunity of the day? away, let us haste to the generals, and advise to give the onset immediately.’ Having spoke thus, she took the ugliest of her monsters, full glutted from her spleen, and flung it invisibly into his mouth, which, flying straight up into his head, squeezed out his eye-balls, gave him a distorted look, and half overturned his brain. Then she privately ordered two of her beloved children, Dulness and Ill-manners, closely to attend his person in





---

p.106




 all encounters. Having thus accoutred him, she vanished in a mist, and the hero perceived it was the goddess his mother.


The destined hour of fate being now arrived, the fight began; whereof, before I dare adventure to make a particular description, I must, after the example of other authors, petition for a hundred tongues, and mouths, and hands, and pens; which would all be too little to perform so immense a work. Say, goddess, that presidest over history, who it was that first advanced in the field of battle! Paracelsus, at the head of his dragoons, observing Galen in the adverse wing, darted his javelin with a mighty force, which the brave Ancient received upon his shield, the point breaking in the second fold [*...*] Hic pauca desunt. [*...*]


They bore the wounded Aga[24](javascript:footNote('E700001-012/note024.html')) on their shields to his chariot [*...*] Desunt nonnulla [*...*]


Then Aristotle, observing Bacon[25](javascript:footNote('E700001-012/note025.html')) advance with a furious mien, drew his bow to the head, and let fly his arrow, which missed the valiant Modern and went whizzing over his head; but Descartes it hit; the steel point quickly found a defect in his headpiece; it pierced the leather and the pasteboard, and went in at his right eye. The torture of the pain whirled the valiant bow-man round, till death, like a star of superior influence, drew him into his own vortex.[26](javascript:footNote('E700001-012/note026.html')) Ingens hiatus  
[*...*]  
 hic in MS. [*...*]when Homer appeared at the head of the cavalry, mounted on a furious horse, with difficulty managed by the rider himself, but which no other mortal durst approach; he rode among the enemy's ranks, and bore down all before him. Say, goddess, whom he slew first and whom he slew last! First, Gondibert[27](javascript:footNote('E700001-012/note027.html')) advanced against him, clad in heavy armour and mounted on a staid sober gelding, not so famed for his speed as his docility in kneeling whenever his rider would mount or alight. He had made a vow to Pallas that he would never leave the field till he had spoiled Homer of his armour: madman, who had never once seen the wearer, nor understood his strength! Him Homer overthrew, horse and man, to the ground, there to be trampled and choked in the dirt. Then with a long spear he slew Denham, a stout Modern, who from his father's side derived his lineage from Apollo, but his mother was of mortal race.[28](javascript:footNote('E700001-012/note028.html')) He fell, and bit the earth. The celestial part Apollo took, and made it a star; but the terrestrial lay wallowing upon the ground. Then Homer slew Wesley[29](javascript:footNote('E700001-012/note029.html')) with a kick of his horse's heel; he took Perrault[30](javascript:footNote('E700001-012/note030.html')) by mighty force out of his saddle, then hurled him at Fontenelle,[31](javascript:footNote('E700001-012/note031.html')) with the same blow dashing out both their brains.


On the left wing of the horse Virgil appeared, in shining armour completely fitted to his body: he was mounted on a dapple-grey steed, the slowness of whose pace was an effect of the highest mettle and vigour. He cast his eye on the adverse wing, with a desire to find an object worthy of his valour; when behold, upon a sorrel gelding of a monstrous size appeared a foe, issuing from among the thickest of the enemy's squadrons; but his speed was less than his noise; for his horse, old and lean, spent the dregs of his strength in a high trot, which, though it made slow advances, yet caused a loud clashing of his armour, terrible to hear. The two cavaliers had now approached within the throw of a lance, when the stranger desired a parley, and, lifting up the vizor of his helmet, a face hardly appeared from within which, after a pause, was known for that of the renowned Dryden. The brave Ancient suddenly started, as one possessed with surprise and disappointment together: for the helmet was nine times too large for the head, which appeared situate far in the hinder part, even like the lady in a lobster, or like a mouse under a canopy of state, or like a shrivelled beau from within the penthouse of a modern periwig; and the voice was suited to the visage, sounding weak and remote. Dryden, in a long harangue, soothed up the good Ancient; called him father, and, by a large deduction of genealogies, made it plainly appear that they were nearly related.[32](javascript:footNote('E700001-012/note032.html')) Then he humbly proposed an exchange of armour, as a lasting mark of hospitality between them. Virgil consented (for the goddess Diffidence came unseen, and cast a mist before his eyes), though his was of gold and cost a hundred beeves, the other's but of rusty iron. However, this glittering armour became the Modern yet worse than his own. Then they agreed to exchange horses; but, when it came to the trial, Dryden was afraid and utterly unable to mount 





---

p.107




[*...*] alter hiatus in MS.


Lucan appeared upon a fiery horse of admirable shape, but headstrong, bearing the rider where he list over the field; he made a mighty slaughter among the enemy's horse; which destruction to stop, Blackmore,[33](javascript:footNote('E700001-012/note033.html')) a famous Modern, (but one of the mercenaries), strenuously opposed himself, and darted his javelin with a strong hand, which, falling short of its mark, struck deep in the earth. Then Lucan threw a lance; but Æsculapius came unseen, and turned off the point. ‘Brave Modern,’ said Lucan, ‘I perceive some god protects you, for never did my arm so deceive me before; but what mortal can contend with a god? Therefore, let us fight no longer, but present gifts to each other.’ Lucan then bestowed *[on]* the Modern a pair of spurs, and Blackmore gave Lucan a bridle.[34](javascript:footNote('E700001-012/note034.html')) [*...*] Pauca desunt. [*...*]


Creech: but the goddess Dulness took a cloud, formed into the shape of Horace, armed and mounted, and placed in a flying posture before him. Glad was the cavalier to begin a combat with a flying foe, and pursued the image, threatening aloud; till at last it led him to the peaceful bower of his father, Ogleby, by whom he was disarmed and assigned to his repose.


Then Pindar slew ——, and ——, and Oldham, and ——, and Afra[35](javascript:footNote('E700001-012/note035.html')) the Amazon, light of foot; never advancing in a direct line, but wheeling with incredible agility and force, he made a terrible slaughter among the enemy's light-horse. Him when Cowley observed, his generous heart burnt within him, and he advanced against the fierce Ancient, imitating his address, his pace, and career, as well as the vigour of his horse and his own skill would allow. When the two cavaliers had approached within the length of three javelins, first Cowley threw a lance, which missed Pindar, and, passing into the enemy's ranks, fell ineffectual to the ground. Then Pindar darted a javelin so large and weighty, that scarce a dozen Cavaliers, as cavaliers are in our degenerate days,[36](javascript:footNote('E700001-012/note036.html')) could raise it from the ground; yet he threw it with ease, and it went, by an unerring hand, singing through the air; nor could the Modern have avoided present death if he had not luckily opposed the shield that had been given him by Venus.[37](javascript:footNote('E700001-012/note037.html')) And now both heroes drew their swords; but the Modern was so aghast and disordered, that he knew not where he was; his shield dropped from his hands; thrice he fled, and thrice he could not escape. At last he turned, and lifting up his hand in the posture of a suppliant: Godlike Pindar, said he, spare my life, and possess my horse, with these arms, beside the ransom which my friends will give when they hear I am alive and your prisoner. ‘Dog!’ said Pindar, ‘let your ransom stay with your friends; but your carcase shall be left for the fowls of the air and the beasts of the field.’ With that he raised his sword, and, with a mighty stroke, cleft the wretched Modern in twain, the sword pursuing the blow; and one half lay panting on the ground, to be trod in pieces by the horses' feet; the other half was borne by the frighted steed through the field. This Venus took, washed it seven times in ambrosia, then struck it thrice with a sprig of amaranth; upon which the leather grew round and soft, and the leaves turned into feathers, and, being gilded before, continued gilded still; so it became a dove, and she harnessed it to her chariot.[*...*] Hiatus valde deflendus in MS.


[38](javascript:footNote('E700001-012/note038.html'))
The Episode of Bentley and Wotton
---------------------------------


Day being far spent, and the numerous forces of the Moderns half inclining to a retreat, there issued forth, from a squadron of their heavy-armed foot a captain whose name was Bentley, the most deformed of all the Moderns; tall, but without shape or comeliness; large, but without strength or proportion. His armour was patched up of a thousand incoherent pieces; and the sound of it, as he marched, was loud and dry,[39](javascript:footNote('E700001-012/note039.html')) like that made by the fall of a sheet of lead, which an Etesian wind blows suddenly down from the roof of some steeple. His helmet was of old rusty iron, but the vizor was brass, which, tainted by his breath, corrupted into copperas, nor wanted gall from the same fountain; so that, whenever provoked by anger or labour, an atramentous quality, of most malignant nature was seen to distil from his lips. In his right hand he grasped a flail, and (that he might never be unprovided of an offensive weapon) a vessel full of ordure in his left. Thus completely armed, he advanced with a slow and heavy pace where the Modern chiefs were holding a consult upon the sum of things; who, as he came onwards, laughed to behold his crooked leg and humped shoulder, which his





---

p.108




boot and armour, vainly endeavouring to hide, were forced to comply with and expose. The generals made use of him for his talent of railing; which, kept within government, proved frequently of great service to their cause, but, at other times, did more mischief than good; for, at the least touch of offence, and often without any at all, he would, like a wounded elephant, convert it against his leaders. Such, at this juncture, was the disposition of Bentley; grieved to see the enemy prevail, and dissatisfied with everybody's conduct but his own. He humbly gave the Modern generals to understand that he conceived, with great submission, they were all a pack of rogues, and fools, and sons of whores, and 

d——d cowards, and confounded logger-heads, and illiterate whelps, and nonsensical scoundrels; that, if himself had been constituted general, those presumptuous dogs, the Ancients, would long before this have been beaten out of the field. ‘You,’ said he, ‘sit here idle, but when I, or any other valiant Modern kill an enemy, you are sure to seize the spoil. But I will not march one foot against the foe till you all swear to me that whomever I take or kill, his arms I shall quietly possess.’ Bentley having spoken thus, Scaliger, bestowing *[on]* him a sour look, ‘Miscreant prater!’ said he, ‘eloquent only in thine own eyes, thou railest without wit, or truth, or discretion. The malignity of thy temper perverteth nature; thy learning makes thee more barbarous; thy study of humanity, more inhuman; thy converse among poets, more grovelling, miry, and dull. All arts of civilising others render thee rude and untractable; courts have taught thee ill manners, and polite conversation has finished thee a pedant. Besides, a greater coward burdeneth not the army. But never despond; I pass my word, whatever spoil thou takest shall certainly be thine own; though I hope that vile carcase will first become a prey to kites and worms.’


Bentley durst not reply; but, half choked with spleen and rage, withdrew, in full resolution of performing some great achievement. With him, for his aid and companion, he took his beloved Wotton; resolving by policy or surprise to attempt some neglected quarter of the Ancients' army. They began their march over carcases of their slaughtered friends; then to the right of their own forces; then wheeled northward, till they came to Aldrovandus's tomb,[40](javascript:footNote('E700001-012/note040.html')) which they passed on the side of the declining sun. And now they arrived with fear toward the enemy's out-guards; looking about, if haply they might spy the quarters of the wounded, or some straggling sleepers, unarmed and remote from the rest. As when two mongrel curs, whom native greediness and domestic want provoke and join in partnership, though fearful, nightly to invade the folds of some rich grazier: they with tails depressed, and lolling tongues, creep soft and slow. Meanwhile the conscious moon, now in her zenith, on their guilty heads darts perpendicular rays; nor dare they bark, though much provoked at her refulgent visage, whether seen in puddle by reflection or in sphere direct; but one surveys the region round, while the other scouts the plain, if haply to discover, at distance from the flock, some carcase half devoured, the refuse of gorged wolves or ominous ravens. So marched this lovely, loving pair of friends, nor with less fear and circumspection; when at a distance they might perceive two shining suits of armour hanging upon an oak, and the owners not far off in a profound sleep. The two friends drew lots, and the pursuing of this adventure fell to Bentley; on he went, and in his van Confusion and Amaze, while Horror and Affright brought up the rear. As he came near, behold two heroes of the Ancients' army, Phalaris and Æsop, lay fast asleep. Bentley would fain have despatched them both, and, stealing close, aimed his flail at Phalaris' breast.[41](javascript:footNote('E700001-012/note041.html')) But then the goddess Affright interposing, caught the Modern in her icy arms, and dragged him from the danger she foresaw; both the dormant heroes happened to turn at the same instant, though soundly sleeping, and busy in a dream. For Phalaris was just that minute dreaming how a most vile poetaster had lampooned him, and how he had got him roaring in his bull.[42](javascript:footNote('E700001-012/note042.html')) And Æsop dreamed, that as he and the Ancient chiefs were lying on the ground, a wild ass broke loose, ran about trampling and kicking, and dunging in their faces. Bentley, leaving the two heroes asleep, seized on both their armours, and withdrew in quest of his darling Wotton.


He, in the meantime, had wandered long in search of some enterprise, till at length he arrived at a small rivulet that issued from a fountain hard by, called, in the language of mortal men, Helicon. Here he stopped, and, parched with thirst, resolved to allay it in this limpid stream. Thrice with profane hands he essayed to raise the water to his lips, and thrice it slipped all through his fingers. Then he stopped prone on his breast, but, ere his mouth had kissed the liquid crystal, Apollo came, and in the channel held his shield betwixt the Modern and the fountain, so that he drew up nothing but mud. For although no fountain on earth can compare with the clearness of Helicon, yet there lies at bottom a thick sediment of slime and mud; for so Apollo begged of Jupiter, as a punishment to those who durst attempt to taste it with unhallowed lips, and for a lesson to all not to draw too deep or far from the spring.


At the fountain-head Wotton discerned two heroes; the one he could not distinguish, but the other was soon known for Temple, general of the allies to the Ancients. His back was turned, and he was employed in drinking large draughts in his helmet from the fountain, where he had withdrawn himself to rest from the toils of the war. Wotton, observing him, with quaking knees and trembling hands, spoke thus to himself: ‘O that I could kill this destroyer of our army, what renown should I purchase among the chiefs! but to issue out against him, man against man, shield against shield, and lance against lance, what Modern of us dare? for he fights like a god, and Pallas or Apollo are ever at his elbow. But, O mother! if what Fame reports be true, that I am the son of so great a goddess, grant me to hit Temple with this lance, that the stroke may send him to hell, and that I may return in safety and triumph, laden with his spoils.’ The first part of this prayer the gods granted at the intercession of his mother and of Momus; but the rest, by a perverse wind sent from Fate, was scattered in the air. Then Wotton grasped his lance, and, brandishing it thrice over his head, darted it with all his might; the goddess, his mother, at the same time adding strength to his arm. Away the lance went whizzing, and reached even to the belt of the averted Ancient, upon which lightly grazing, it fell to the ground. 

Temple neither felt the weapon touch him nor heard it fall: and Wotton might have escaped to his army, with the honour of having remitted his lance against so great a leader, unrevenged; but Apollo, enraged that a javelin flung by the assistance of so foul a goddess should pollute his fountain, put on the shape of ——, and softly came to young Boyle, who then accompanied Temple: he pointed first to the lance, then to the distant Modern that flung it, and commanded the young hero to take immediate revenge. Boyle, clad in a suit of armour which had been given him by all the gods,[43](javascript:footNote('E700001-012/note043.html')) immediately advanced against the trembling foe, who now fled before him. As a young lion in the Libyan plains, or Araby desert, sent by his aged sire to hunt for prey, or health, or exercise; he scours along, wishing to meet some tiger from the mountains, or a furious boar; if chance a wild ass, with brayings importune, affronts his ear, the generous beast, though loathing to distain his claws with blood so vile, yet, much provoked at the offensive noise, which Echo, foolish nymph, like her ill-judging sex, repeats much louder, and with more delight than Philomela's song, he vindicates the honour of the forest, and hunts the noisy long-eared animal. So Wotton fled, so Boyle pursued. But Wotton, heavy-armed, and slow of foot, began to slack his course; when his lover Bentley appeared, returning laden with the spoils of the two sleeping Ancients. Boyle observed him well, and, soon discovering the helmet and shield of Phalaris his friend, both which he had lately with his own hands new polished and gilt,[44](javascript:footNote('E700001-012/note044.html')) rage sparkled in his eyes; and leaving his pursuit after Wotton, he furiously rushed on against this new approacher. Fain would he be revenged on both; but both now fled different ways: and, as a woman in a little house that gets a painful livelihood by spinning, if chance her geese be scattered o'er the common, she courses round the plain from side to side, compelling here and there the stragglers to the flock; they cackle loud, and flutter o'er the champaign; so Boyle pursued, so fled this pair of friends. Finding at length their flight was vain, they bravely joined and drew themselves in phalanx. First Bentley threw a spear with all his force, hoping to pierce the enemy's breast; but Pallas came unseen, and in the air took off the point, and clapped on one of lead, which, after a dead bang against the enemy's shield, fell blunted to the ground. Then Boyle, observing well his time, took up a lance of wondrous length and sharpness; and, as this pair of friends compacted stood close side by side, he wheeled him to the right, and, with unusual force, darted the weapon. Bentley saw his fate approach, and flanking down his arms close to his ribs, hoping to save his body, in went the point, passing through arm and side; nor stopped, *or* spent its force, till it had also pierced the valiant Wotton, who, going to sustain his dying friend, shared his fate. As when a skilful cook has trussed a brace of woodcocks, he with iron skewer pierces the tender sides of both, their legs and wings close pinioned to the ribs: so was this pair of friends transfixed, till down they fell, joined in their lives, joined in their deaths; so closely joined, that Charon would mistake them both for one, and waft them over Styx for half his fare. Farewell, beloved, loving pair; few equals have you left behind: and happy and immortal shall you be, if all my wit and eloquence can make you.


And now.... Desunt caetera.












