

#Rosa Anglica


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Rosa Anglica
============


Author: [unknown]
-----------------


### File Description

Winifred WulffElectronic edition compiled by Beatrix Färber , Pádraig Bambury 

Funded by University College, Cork and  
Professor Marianne McDonald via the CELT Project, formerly CURIA 3. Third draft.Extent of text: 65165 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2005) (2010) (2017) (2018) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T600008Availability [RESTRICTED] 
Available with prior consent

of the CELT project for purposes of academic research and teaching only.


#### Notes

You can purchase the book(s) containing this text via the ITS website (http://www.irishtextssociety.org/). Click on the link to the RIA shop. More information about Winifred Wulff's Life and Work is available on the CELT website at https://celt.ucc.ie//wulff.html.

#### Sources


**MS sources for Irish translations of Rosa Anglica**- Royal Irish Academy (RIA) MS 457=23 P 20, the basis of the present text. For details, see Kathleen Mulchrone, T. F. O'Rahilly et al. (eds.), Catalogue of Irish manuscripts in the Royal Irish Academy (Dublin 1926-70) vol. 2, p. 1209.- RIA MS 456=23 P 10 (iii). See ISOS website (http://www.isos.dias.ie/) for catalogue description and manuscript images). Also see Kathleen Mulchrone, T. F. O'Rahilly et al. (eds.), Catalogue of Irish manuscripts in the Royal Irish Academy (Dublin 1926-70) vol. 2, p. 1207-09.- Trinity College Dublin (TCD) MS 1321=H 3 2. See ISOS website (http://www.isos.dias.ie/) for catalogue description and manuscript images). Also see T. K. Abbott and E. J. Gwynn (eds.), Catalogue of the Irish manuscripts in the Library of Trinity College, Dublin (Dublin 1921) p. 112.- TCD MS 1318=H 2 16 (Yellow Book of Lecan). See T. K. Abbott and E. J. Gwynn (eds.), Catalogue of the Irish manuscripts in the Library of Trinity College, Dublin (Dublin 1921) pp 94-110: 101-2 (Col. 437a-99).- TCD MS 1432=E 3 3 (fragment). For details see T. K. Abbott and E. J. Gwynn (eds.), Catalogue of the Irish manuscripts in the Library of Trinity College, Dublin (Dublin 1921) p. 307.- TCD MS 1433=E 3 30 (fragment). For details see T. K. Abbott and E. J. Gwynn (eds.), Catalogue of the Irish manuscripts in the Library of Trinity College, Dublin (Dublin 1921) p. 309.- Edinburgh, National Library of Scotland, MS 20 (formerly Advocates' Library). For details see John Mackechnie (ed.), Catalogue of Gaelic Manuscripts in selected Libraries in Great Britain and Ireland (Boston 1973) vol. 1, p. 231, MS 6; vol. 2, p. 591.**MS sources for Latin Rosa Anglica**2. Edinburgh University, 168 (Laing 180); ff. 1-305, c 14.
3. Oxford, Merton College, 262, ff. 1-237, c 14.
4. Oxford, Corpus Christi College 69, ff. 1-191, c 14. late.
5. Exeter Cathedral, 35.O.6, c 14., probably spurious.
6. British Library, Sloane, 1612, ff. 125 r-430v, c 14 to 15.
7. British Library, Sloane, 134, ff. 48r-169r, c 15, abbrev.
8. British Library, Sloane, 280, ff. 9r-262r, c 15.
9. British Library, Sloane, 1067, ff. 1-280v, c 15.
10. British Library, Sloane, (Additional) 33996, ff. 148-210v, c 14, imperfect.
11. Cambridge, Corpus Christi College 261 ff. 1-232r, c 15.
12. Bodleian, E Musaeo 146 (3619), ff. 19-348v, c 15.
13. Bodleian, Bodl. 608 (2059), c 15 early, probably spurious.
**Printed sources for Latin text**2. John of Gaddesden (Johannes de Gaddesden) (1280?-1361), Rosa anglica practica medicinae. Pavia: Franciscus Girardengus and Joannes Antonius Birreta, 1492. Reprinted 1517.
3. Idem, Rosa anglica practica medicinae. Venice: [Bonetus Locatellus for Heirs of Octavianus Scotus], 1502.
4. Idem, Joannis Anglici Praxis medica, Rosa Anglica dicta, quatuor libris distincta: de morbis particularibus, de febribus, de chirurgia, et pharmacopoeia, emendatior & in meliorem redacta ordinem / recens edita opera ac studio ... Philippi Schopffii; Augustae Vindelicorum: Typis Michaëlis Mangeri, 1595.
**Select bibliography**2. Oswald Cockayne (ed. & trans.), Leechdoms, wortcunning and starcraft of early England; being a collection of documents, for the most part never before printed, illustrating the history of science in this country before the Norman Conquest. 3 vols. (Rerum Britannicarum Medii Aevi Scriptores, 35). 1864–1866.
3. George Dock, 'Printed editions of the Rosa Anglica of John of Gaddesden', in: Janus 12 (1907) 425–435.
4. Henry Patrick Cholmeley, John of Gaddesden and the Rosa Medicinae. Oxford 1912.
5. James J. Walsh, Medieval medicine. London: Black 1920.
6. Charles Singer, 'The Herbal in Antiquity and its Transmission to Later Ages', Journal of Hellenic Studies 47 (1927), 1–52.
7. John D. Comrie, History of Scottish medicine (London, published for the Wellcome historical medical museum by Baillière, Tindall & Cox 1932). Available at: https://archive.org/details/b20457273M002.
8. W. G. Lennox, 'John Gaddesden on epilepsy'. Annals of Medical History, 3rd ser., 1:3 (1939) 283–307.
9. H. E. Sigerist, A History of Medicine, 2 vols. (London 1951–1961).
10. Wilfrid Bonser, The Medical Background of Anglo-Saxon England: A Study in History, Psychology and Folklore. 1963.
11. Charles Hugh Talbot, Medicine in Medieval England. London: Oldbourne 1967.
12. Huling E. Ussery, 'Chaucer's physician: medicine and literature in fourteenth-century England'. Tulane Studies in English 19. New Orleans: Tulane University Press 1971.
13. Francis Shaw, S. J., 'Irish medical men and philosophers', in: Seven Centuries of Irish Learning, 1000–1700, ed. by Brian Ó Cuív, Cork: Mercier Press 1971, 94.
14. Norman Capener, 'Chaucer and Doctor John of Gaddesden'. Annals of the Royal College of Surgeons of England, 50 (1972) 283–300.
15. Stanley Rubin, Medieval English medicine. Newton Abbot: David and Charles 1974.
16. Edward Grant (ed.), A source book in medieval science. Cambridge, Massachussetts, Harvard University Press 1974.
17. J. Fleetwood, The History of Medicine in Ireland (Dublin: Skellig Press 1983).
18. Nessa Ní Shéaghda, 'Translations and Adaptations in Irish' (Statutory Lecture 1984, School of Celtic Studies), Dublin, Institute for Advanced Studies 1984.
19. Marilyn Deegan and D. G. Scragg (eds.), Medicine in early medieval England. Centre for Anglo-Saxon Studies, University of Manchester 1989.
20. Nancy G. Siraisi, Medieval and Early Renaissance Medicine. London: University of Chicago Press 1990.
21. Aoibheann Nic Dhonnchadha, 'Irish medical manuscripts', Irish Pharmacy Journal 69/5 (May 1991) 201–2.
22. Sheila Campbell, Bert Hall, David Klausner (eds.), Health, disease and healing in medieval culture. London: Macmillan 1992.
23. M. L. Cameron, Anglo-Saxon Medicine. Cambridge 1993.
24. Joan Cadden, Meanings of Sex Difference in the Middle Ages: Medicine, Science, and Culture (Cambridge: Cambridge University Press 1993).
25. Margaret R. Schleissner (ed.), Manuscript sources of medieval medicine: a book of essays. New York: Garland 1995.
26. Carol Rawcliffe, Medicine & society in later medieval England. [1066–1485] Stroud: Alan Sutton Pub. 1995.
27. Lawrence I. Conrad, Michael Neve, Vivian Nutton, Roy Porter, Andrew Wear (eds), The Western medical tradition: 800 BC to AD 1800 (Cambridge: Cambridge University Press 1995.
28. Faye Getz, Medicine in the English Middle Ages. Princeton 1998.
29. Mirko D. Grmek (ed.), Western Medical Thought from Antiquity to the Middle Ages. Cambridge, Massachusetts, 1999.
30. Jerry Stannard, Herbs and Herbalism in the Middle Ages and Renaissance; edited by Katherine E. Stannard and Richard Kay. Aldershot 1999.
31. Jerry Stannard, Pristina medicamenta: ancient and medieval botany; edited by Katherine E. Stannard and Richard Kay. Aldershot 1999
32. Fergus Kelly, 'Medicine and Early Irish Law', in: J. B. Lyons (ed.), Two thousand years of Irish medicine (Dublin 1999) 15–19. Reprinted in Irish Journal of Medical Science vol. 170 no. 1 (January–March 2001) 73–6.
33. Aoibheann Nic Dhonnchadha, 'Medical writing in Irish', in: J. B. Lyons (ed.), Two thousand years of Irish medicine (Dublin 1999) 21–26. Published also in Irish Journal of Medical Science 169/3 (July–September 2000) 217–20 (available online at http://www.celt.dias.ie/gaeilge/staff/rcsi1.html).
34. Helen M. Dingwall: A History of Scottish Medicine: Themes and Influences. Edinburgh: Edinburgh University Press 2003.
35. Lea T. Olsan, 'Charms and prayers in medieval medical theory and practice', Social History of Medicine, 16/3 (2003). Oxford: Oxford University Press 2003. [A link to this article is available online on http://www3.oup.co.uk/sochis/hdb/Volume\_16/Issue\_03/].
36. C. Roberts and M. Cox, Health and Disease in Britain from Prehistory to the Present Day (Stroud 2003).
37. Aoibheann Nic Dhonnchadha, 'Eagarthóir, téacs agus lámhscríbhinní: Winifred Wulff agus an Rosa Anglica', in: Ruairí Ó hUiginn (ed.), Oidhreacht na lámhscríbhinní. Léachtaí Cholm Cille 34 (Maigh Nuad [Maynooth]: An Sagart 2004) 105–47.
38. Aoibheann Nic Dhonnchadha, 'Winifred Wulff (1895–1946): beatha agus saothar', in: Léachtaí Cholm Cille 35 (Maigh Nuad [Maynooth]: An Sagart 2005) 191–250.
39. R. J. Hankinson (ed), The Cambridge Companion to Galen (Cambridge: Cambridge University Press 2008).
40. C. P. Meehan, The Rise and Fall of the Irish Franciscan Monasteries, 4th. ed., Dublin 1872.
41. Tomás Ó Con Cheanainn, 'Scríobhaí 'Leabhar Mhuintir Laidhe' agus 'Rosa Anglica', Éigse 37 (2010) 112–118.
42. Tony Hunt, Teaching and learning Latin in thirteenth-century England. First published 1991. Reprinted Woodbridge 2010.
43. Luke Demaitre, Medieval Medicine: the art of healing, from head to toe. Praeger Series on the Middle Ages (Santa Barbara, California 2013).
44. Wolfram Schmitt, Medizinische Lebenskunst: Gesundheitslehre und Gesundheitsregimen im Mittelalter (Berlin 2013).
45. Peter Wyse Jackson, Ireland's generous nature: the past and present uses of wild plants in Ireland (St. Louis, Missouri 2013).
46. Liam P. Ó Murchú (ed) Rosa Anglica: Reassessments, Irish Texts Society. Subsidiary Series, 28 (London: Irish Texts Society, 2016).
**The edition used in the digital edition**2. Rosa Anglica seu Rosa Medicinae Johannes Anglici. An early modern Irish translation of a section of the mediaeval medical text-book of John of Gaddesden. Edited with introduction, glossary and English version.. Winifred Wulff (ed), First edition [lviii + 434 pp.] Published for the Irish Texts Society by Simpkin, Marshall, Ltd.London ([1923] 1929) . Irish Texts Society [Cumann na Sgríbheann Gaedhilge]. , No. 25

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text represents even pages 2-334 of the volume. (The Introduction on pp. xiii-l and lvii-lviii are available in the Irish text. Pages l-lvi of the introduction dealing with Irish medical manuscripts is available separately as html file.) The complete hardcopy consists of Contents vii, Abbreviations ix-xii, Introduction xiii-lviii; facsimile photograph of RIA MS 23 P 20, p. 41; Text with facing translation 3-335; Vocabulary 336-415; Doctors mentioned in the text 416-419; Medical works quoted in the text 420; Works quoted in the text omitted from footnotes 420-429; Bibliography 430-434; Addenda to Vocabulary/Errata 435. The apothecary symbols used are ounce (ounce), dram/drachm, (drachm), scruple (scruple), recipe ([rx ]). .


#### Editorial Declaration


##### Correction


Text has been checked and proofread twice. All corrections and supplied text are tagged.


##### Normalization


The electronic text represents the edited text. Text supplied by the editor is marked sup resp="WW"; and where mentioned in the edition, the source for the supplied text is indicated. The hardcopy uses italics to denote Latin words; in the digital text frn and term lang="la"tags are used instead.


##### Quotation


Quotations from written works are rendered qt. Citations are tagged cit. This element contains bibl and qt elements.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break have been placed on the line on which they start.


##### Segmentation


div0=the medical tract; div1=the English translation; div2=the section. Paragraphs are numbered in line with the printed edition, page-breaks are marked pb n=""; milestones are marked mls unit="MS page/column" n="n/n".


##### Standard Values


Dates are not tagged.


##### Interpretation


Ligatures for 'ae' and accents present in the Latin footnotes are not retained; 'etc.' and other editiorial additions in author's notes are in square brackets. Names of persons are tagged and capitalized.


#### Canonical References


This text uses the DIV2 element to represent the section. ### Profile Description


Created: Translation by Winifred Wulff (for details of source see CELT file G600008).

 (c.1923) #### Use of language


##### Language: [EN] The introduction, translation and some footnotes are in English.


##### Language: [GA] Some words are in Early Modern Irish.


##### Language: [LA] Many footnotes, words and phrases are in Latin, and Graeco-Latin.


##### Language: [GR] A few words are in Greek (in Roman letters).


##### Language: [AR] A few words are in Arab, such as mirach and siphac(h).


### Revision History


* (2018-03-26) Beatrix Färber (ed.)

* Added to bibliographic details and content encoding.
* (2017-02-16) Beatrix Färber (ed.)

* Content encoding of Latin medical, pharmaceutical, botanical, and anatomical terms improved. Header updated; new SGML and HTML files created.
* (2012-06-24) Beatrix Färber (ed.)

* Added to bibliographic details.
* (2010-11-25) Beatrix Färber (ed.)

* Added to bibliographic details.
* (2010-04-21) Beatrix Färber (ed.)

* Conversion script run; personal names encoding improved; header updated; new wordcount made; file parsed.
* (2008-09-22) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2008-07-28) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, title elements streamlined, creation date inserted, content of 'langUsage' checked; minor modifications made to header.
* (2007-12-14) Beatrix Färber (ed.)

* Note inserted in header.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T16:43:45+0100) Peter Flynn (ed.)

* Converted to XML
* (2005-03-31) Beatrix Färber (ed.)

* Minor additions to bibliography; file re-parsed; html file created.
* (2004-08-10) Benjamin Hazard (ed.)

* More details of manuscripts and catalogues supplied.
* (2004-08-03) Beatrix Färber (ed.)

* Header modified; file segmentation modified; file parsed.
* (2004-07-29) Beatrix Färber (ed.)

* Bibliography compiled.
* (2004-07-02) Beatrix Färber (ed.)

* Second proofing of main text; insertion of footnotes continued; more content markup applied.
* (2002-09-18) Beatrix Färber (ed.)

* Header constructed; second proofing of main text and insertion of footnotes begun.
* (2002-06-20) Pádraig Bambury (ed.)

* First proofing of main text; structural markup applied.
* (2002-06-10) Pádraig Bambury (ed.)

* Data capture by scanning.




---


#### Corpus of Electronic Texts Edition: T600008


### Rosa Anglica: Author: [unknown]




---

p.3


Sicut dicit **Galienus** primo de ingenio sanitatis.
----------------------------------------------------

De Tertiana.
------------


*Since he speaks first of common diseases, and since it is fever that is commonest amongst them, and amongst fevers tertian fever, therefore it is meet for us to speak of it first. {Quia ergo tres primi libri erunt de morbis communibus & inter eos communior est febris & inter febres communior est colerica: ideo primo de ea tractandum est.}’’*

R. A. 3






---

p.5


*Fever is the same as natural heat turning to fieriness, {Febris, nihil est aliud, nisi calor naturalis mutatus in igneum}’’*

(1. Aph. 16) R. A. 669, 4th ed.

 according to **Hippocrates** and **Galen**. **Averroes** (says *fever is heat that afflicts and injures the works and actions, and thus it is right to understand this i.e. that in the humours   
[*...*]  
 are [humoral fevers]; [Ephem]era in the spirits and hectica [in the] close strong [members] {Febris est calor, qui totum corpus laedit; omnes videl: actiones & passiones membrorum: & hoc debet intelligi sic; febres humorales sunt in humoribus; Ephemerae in spiritibus; Hectica in membris solidis [etc.]}’’*

R. A. 670.

 *The heat that is in the [adjacent(?)] members   
[*...*]  
 is febrile and not fever   
[*...*]  
 occupies the whole body   
[*...*]  
 species unless   
[*...*]  
 prevent it, as **Avicenna** says, {Et calor qui est in partibus vicinis, est accidens morbi, & febrile, non febris: & ista occupat totum corpus secundum diversas partes, nisi impediatur, ut docet **Avicenna**.}’’*

R. A. 670

 and *choleric fever is   
[*...*]  
 of the body and phlegmatic fever   
[*...*]  
 of the body, unless other   
[*...*]  
 prevent it {Unde cholerica, est circa choleram; phlegmatica circa, vel in toto, phlegmate, nisi impediatur propter oppilationem, vel propter aliquid tale.}’’*

R. A. 670

 [*...*] thus.


#### 2


*Let us speak now of choleric fever, and there are two forms   
[*...*]  
 continual fever i.e. fever   
[*...*]  
 that seizes a man usually, such as   
[*...*]  
 the other form non-continuous, but intervals between, such as true tertian or notha tertiana {Nunc de cholerica febre dicamus: quae duplex est, continua, & interpolata. Interpolata est tertiana pura, vel notha: continua est kaûsos *(sic)*.}’’*

R. A. 670

; (and) *understand that tertian   
[*...*]  
 afflicts a man from one tierce to the other, i.e. that   
[*...*]  
 afflicts   
[*...*]  
 every third day or the third hour of every day {Dicitur tertiana, quasi tertium diem terens; hoc est invadens, seu affligens tertio die.}’’*

R. A. 670

, for it is [*...*] *choler has the dominance and moves   
[*...*]  
 of the day till noon, and it is clear from this   
[*...*]  
 there is   
[*...*]  
 or double tertiana   
[*...*]  
 the matter from three to three {sicut dicitur ... cholera rubra ab hora diei tertia, usque ad horam nonam dominatur, regnat, atque movetur. Ex his apparet, sive sint duae tertianae, sive una simplex, quod moveatur, vel de tertio die, in diem tertium: vel de tertia hora, in tertiam horam sequentis diei.}’’R. A. 670.*


---

p.7


#### 3


Let us speak now of the description of tertian fever. *This is tertian fever i.e. unnatural heat generated from increase (?) of choler which afflicts every action and   
[*...*]  
 from a third to the next third time {Est igitur Tertiana febris, calor non naturalis, generatus ex inflammatione cholerae ... laedens omnes actiones & passiones membrorum; de tertio in tertium affligens.}’’*

R. A. 671.

 Understand that *there is natural choler and unnatural, and there are species of unnatural choler, such as notha tertiana, and there are species of that, for notha tertiana is formed from the combination of phlegm and choler; and it is formed from burning, such as cholera aeruginosa and cholera prasina, and Isaac says fever is not formed from these, and **Averroes** says it is. And thus that should be understood, i.e. these kinds are deadly   
[*...*]  
 and so a fever is not formed from them that can be cured, and so both authors are saved {Naturalis, & non naturalis. Non naturalis est multiplex: notha propter adiustionem phlegmatis: & notha propter adiustionem cholerae aeruginosae, quae vocatur ... prasina: sed ex istis non fit febris, ut dicit Isaac; quod tamen Averroes ... negat. Verum ipsa est mortalis, ideo non fit ex ea febris salubris: & sic uterque autor salvatur.}’’R. A. 671*[*...*] And there is *notha tertiana from the mixture of phlegm, and there are two kinds of that. One from the combination of subtle phlegm, the which is cholera citrina, and the other of gross phlegm the which is cholera vitellina {Est & cholera notha, & non vera, propter admixtionem phlegmatis subtilis, & illa est cholera citrina: & est notha per admixtionem phlegmatis crassi, & illa cholera est vitellina.}’’R. A. 671.*
#### 4


Item understand that *fever is not formed from pure choler, but from subtle choleric blood, or choleric moisture with which phlegm is not mixed {de cholera pura non est febris: ... est subiectum salubrium: sed sanguis subtilis cholericus, aut humiditas, in qua dominatur cholera. Et si dicat Averroes, vel alius Antilogicus, quod de cholera pura non fiat tertiana pura ... Respoendeo, hoc verum esse, de sanguine cholerico, vel de humiditate cholerica, cum uqa non miscetur phlegma.}’’*

R. A. 671

, and if **Averroes** or anyone else say that tertian fever is formed from pure choler, I say that that should be understood thus, i.e. it is caused by subtle choleric blood or choleric moisture with which phlegm does not


---

p.9






mix (? is not mixed). And if anyone say it is not meet to give a laxative in tertian fever, since **Hali** says there is no laxative that purges red blood (and) *I say there is no laxative that purges pure sanguine humour without an alteration (?) though sanguine humour is purged on being changed, or else, I say that that part of choler is purged that is along with the blood {Respondeo, verum esse, quod sanguinis puri, non alterati, nec mutati non sit laxativum: attamen possibile est, ut pars cholerica in sanguine purgetur, aut alteretur.}’’R. A. 671.*
#### 5


Let us speak now of the causes of tertian fever, and understand that this is the strongest cause by which it is generated i.e. when a sanguine complexion is dominant in heat and dryness, *it has a disposition to generate heat in itself {& praeparationem, ut generetur in eol talis calor.}’’*

R. A. 672

, and this is the cause of the fever called tertiana continua, and the matter is inside the veins. *The second cause preparative to unnatural heat {Secunda caussa est praeparans ad calorem innaturalem ...}’’R. A. 672* is the excess of the third digestion in the proper members, and this is the cause of the fever called tertiana interpolata, for its matter is outside the veins.
#### 6


*And these fevers have many other particular and special causes {Sed caussae in particulari & speciali sunt multae.}’’*

R. A. 672

, such as hot, dry, immoderate foods, or that excess of this food be eaten, or too little of it, or that it be eaten fasting; for it is changed then in the stomach or in the liver to heat and strong dryness, and brings the stomach and the liver to that complexion, and the blood that is formed from that food is hot, dry, and immoderate, *and choler is increased in quantity and made immoderate in (its) quality, and it hinders the operation of the gall; it will not draw choler, and remains thus along with the blood, and will be odious to nature {& mutliplicatur cholera in quantitate, & impeditur operatio fellis, non trahens choleram; & sic remanebit cum sanguine & inflabitur: quia fiet odiosus naturae.}’’R. A. 672*,


---

p.11






and corrupts and putrefies; *for when choler goes from its natural way in quantity and quality or in both, it then turns to sanguine humour {quando exit cholera a sua via naturali ... tunc remanebit infusa sanguini.}’’R. A. 672*, and the members that are nourished on this blood go by degrees from their own natural complexion to a hot, dry, evil complexion, and form diseases from choler in this way. Another cause of this fever is hot, dry air, and too much labour and over-sleeping, *and accidents of the soul, as anger and fury, and affections of the heart, and other things like them {vigiliae multae, & accidentia animae; sicuti ira, furor, affectus cordis [etc.]}’’R. A. 673.*
#### 7


Regarding the *signs of tertian fever, and understand that there are two signs proper to the fevers caused by corruption {quod signa generalia febrium putridarum propria, tantum sint duo.}’’*

R. A. 673.

 *One sign of them is that there is no hypostasis at the beginning of the fever, for the heat is troubled, so that it cannot digest the humours. {i. est, quod urina in principio hypostasin non habet: quia calor est impeditus super humorum digestionem.}’’R. A. 673* The other sign i.e. the pulse is variable; *this variableness is on account of the excess of the humours or their malice {varietas enim fit in putridis propter humorum multitudinem ac malitiam ... [Aliud signum est, quod quando patiens ponitur in balneum, & sentit horripilationem, tunc adest putrida: si non, Ephemera.]}’’R. A. 673, cf. B par. 7.*
#### 8


*Understand that special signs, that is, certain signs of the fever called tertiana interpolata are recognised i.e. an interval between them, and by three things it is understood {Circa signa specialia febris tertianae interpolatae, est sciendum: quod ipsa cognoscitur ex tribus notis.}’’*

R. A. 673

, i.e. by naturals and by unnaturals, and by something that is against nature, as Isaac says. Naturals, such as age and complexion; unnaturals, as are air and season; and regarding the


---

p.13






thing that is against nature, *as are the *occasions* that come from the matter of the disease, like rigor that comes in the beginning of the paroxysm {sicunt occasiones quae fiunt a materia morbi: rigor, frigus, tarditas accessionis}’’R. A. 674* and things like these. This fever is recognised by naturals, for it often seizes a person who has a warm, dry complexion, young in age, and especially if he have black, curly hair, and he himself lean, and have a lax body, for the *tertiana that is formed from the agreement of these particular matters {tertiana quae fit cum convenientia istorum particularium.}’’R. A. 674* is true tertian fever. This fever is recognised by unnaturals, for it often comes in summer, and when the air turns to heat and dryness; and it is recognised by labour and the operations of the disease, for if he be a person *who does work to excess in health, it brings him to heat and dryness {si ... fuit laboriosus, aut studiosus, aut solicitus: quia solicitudo & labor excitant calorem.}’’R. A. 674.* This is recognised by *praeternaturals {res contra naturam}’’R. A. 674*, since it is formed by hot, dry, choleric matter, for when it is *near the noble sensitive members a tedious burning rigor should arise then, as if needles {vicina membris sensibilibus, necesse est ut eam praecedat rigor molestissimus, pungitivus, quasi fierit acu.}’’R. A. 674* or thorns were tormenting him, and this should come at the beginning of the paroxysm, for when the sharpness of choler, that he is not wont to, goes through the sensitive members, it irritates him and generates a sort of trembling in them, and it is of this I say ‘rigor’.
#### 9


Item *Nature goes to the interior members on account of the hurtful thing that torments her and the members, and the exterior members cool until the matter heats {Similiter natura refugit da interiora, propter rem nocivam pungentem, & tunc exteriora refrigerantur, quousque materia calefiat.}’’*

R. A. 674

 and inflames; and the heat is spread throughout the whole body, *for the heat is choked at the beginning of the disease and the paroxysm by corrupt humours {tunc in principio calor obtunditur ab humore putredinali.}’’R. A. 674*, and when it corrupts entirely



---

p.15






and is mixed with the natural heat, it spreads throughout the whole body and the heat is choked on account of this, and great is the inflammation it causes, and it causes extreme sleeplessness and pain and burning in the liver; and the sharp vapours that arise from the body destroy the appetite and cause bitterness in the mouth at the end of the fourth paroxysm, for this is the stasis of the fever. And these folk who have the fever *fling their clothes off them {pannos as se rejiciunt}’’R. A. 674*, and at this time choleric sweat comes, or choleric vomiting, or choleric faeces, for if the matter be light, it is purged by sweat, and if it be heavy and gross, it is by the faeces, and if intermediate between, them it is by vomiting.
#### 10


Signs of this disease as regards the urine i.e. *subtle thin red-brown urine {Urina in haec febre est rubicunda, ignea, subtilis.}’’*

R. A. 675

; and the cause of its being red is the heat of the body, and the cause of its thinness is the dryness of choler. Item *urine red-brown in colour and thin in substance, bright below and dark above, in a young choleric person along with the particular matters, signifies true tertian fever. Item urine black in colour and thin in substance, and dark above in a phlegmatic person and in a woman, signifies double tertiana {Urina rubra in colore, subtilis in substantia, clara inferne, obumbrata in superficie, in iuvene phlegmatico, aut muliere, duas tertianas significat. Urina rubra in colore, subtilis in substantia, obumbrata superne, in sene; duas tertianas significat.}’’R. A. 675.* Item urine red-brown in colour and thin in substance and dark above in youths, signifies the fever called Item tertiana continua. Item urine red and high in colour, and troubled in substance, and leaden-coloured above, signifies tertiana continua from natural choler.
#### 11


And **Galen** says there is no difference between tertiana and causon as regards the matter from which they are formed,


---

p.17






for it is from choler they are both formed. And *this is causon i.e. when choler has the dominance   
[*...*]  
 [burning inside the veins   
[*...*]  
 near to the heart] {Sed kaûsos [sic], est cum ipsa cholera dominatur &augmentatur ebulliens intra venas, cum sanguine mixta in locis propinquis cordi.}’’*

R. A. 675

 or to the stomach, or to the lungs. *[This is tertiana,] when choler moves [throughout the body in the places that are more remote from the heart than that ...] {tertiana vero est, cum cholera movetur per corpus in locis a corde remotioribus.}’’R. A. 675.*


---

p.19


 *Regarding Sanguine Fever etc. {De Synocho non putri, seu Febre sanguinea.}’’R. A. 810*
----------------------------------------------------------------------------------------


#### 1


i.e. the fevers caused by blood called synocha and synochus. Synochus comes from corrupt blood within the vessels, and synocha from an excess of blood without putrefaction. **Galen**[1](javascript:footNote('T600008/note001.html')) says, since the blood is the friend of nature it may be corrupted and[2](javascript:footNote('T600008/note002.html')) brought under her ruling; if it be brought on account of sharpness of choler and become corrupt, the thin part of it turns to choler and the thick part to melancholy; and the contrary of this i.e. that sanguine humour is capable of putrefaction and corruption and generates fever. The doctors agree with this statement, and it is not right to oppose their sayings, but to treat them with honour: nevertheless we have said the blood is naturally in the veins and arteries and is ruled by nature and her instruments, that is by the natural heat. When choler penetrates thither it disturbs their natural moderation, and sometimes it grows hot of itself naturally and becomes corrupted [or] the thin part is burnt and nature heats it. And when nature overcomes it, it is evacuated by crisis, or by nose-bleeding, or the haemorrhoidal or menstrual flow. At another time it cannot be evacuated from the veins, but settles in some member forming the imposthume called phlegmon.



---

p.21






Sometimes nature can do neither of these things, but [the matter] remains in the veins externally, and when brought under [the ruling of] nature it is corrupted and causes acute fever.


#### 2


If we speak [of the forms of this fever, there are three,][3](javascript:footNote('T600008/note003.html')) i.e. aumasticus which increases continually; epamasticus which decreases continually; and homotonos which remains in one state. In the first form there is [*...*] that dissipates and does not consume, and therefore it is weaker, and in the second form there is heat (?) that dissipates and is [*...*] and therefore it is stronger and is greater [*...*] according to the consumption of the matter. In the third form the dispersal and the consumption are equal, therefore it remains in one state and the judgment thereof is equal as to life or death. At another time it disperses more than it corrupts, and that is the way to health, for when the crisis comes, there is but little matter. Yet another time the putrescence is greater than the consumption, and that is bad and dangerous.


#### 3


The causes of these fevers are oppilation and repletion, much resting as well as many other signs[4](javascript:footNote('T600008/note004.html')); the consumption of food that increases sanguine humour, such as eggs, salmon[5](javascript:footNote('T600008/note005.html')), and the like; avoiding accustomed work and purging, and practising laborious exercise along with repletion of the body;


---

p.23






the mutilation (want) of a member whitherto much blood was wont to flow; much foods[6](javascript:footNote('T600008/note006.html')) that generate watery blood, and fruit, milk and fish, for such easily turn to purely watery humours[7](javascript:footNote('T600008/note007.html')) and contract putrefaction, cause oppilation and greater heat, and give rise to the fever called synocha[8](javascript:footNote('T600008/note008.html')). And should the leech be careless in opening the obstruction or evacuating it, it readily turns to the fever called synochus. Therefore **Haly**[9](javascript:footNote('T600008/note009.html')) says the excess does harm in three ways: as regards quality only, as the blood when it heats and generates the fever called ephemera; *or he takes the blood there for the spirit, which is generated from the thinnest part thereof {Vel capit sanguinem pro spiritu, qui ex parte purioris sanguinis generatur.}’’*

R. A. 811.

 Or the excess is generated as regards quantity alone, when the blood increases in quantity only, its quality only being good, and not a corrupt quality[10](javascript:footNote('T600008/note010.html')), it then causes the fever called synocha. And the pus in the imposthume injures by reason of quality and quantity [combined].
#### 4


**Galen** and **Avicenna** are against this, for **Avicenna** says there are but three simple fevers, a fever from phlegm, one from choler and one from sanguine humour; for when it (the blood) corrupts, it causes not a simple fever, but a compound fever; for the blood is moderate, and when it heats and putrefies, the thinner part turns to choler, and the thicker to melancholy. **Avicenna**[11](javascript:footNote('T600008/note011.html')) says he found much [adverse] criticism regarding this saying of **Galen**'s, and says [moreover] that sanguine humour generates one simple fever only. I say with regard to this briefly: if vapour arise on account of the


---

p.25






corruption of the blood, it turns to choler, and the blood putrefies by itself by reason of the antecedent cause of the combination. Of these **Galen** takes one view and **Avicenna** another.


#### 5


These are the indications preceding this fever: heaviness of the head, and puffiness of the eyes[12](javascript:footNote('T600008/note012.html')), **plethora** of the veins, redness of the face, fatigue of the whole body as though after labour. The concomitant symptoms[13](javascript:footNote('T600008/note013.html')) are frontal headache; *the sick man* imagines he sees a lighted candle before him[14](javascript:footNote('T600008/note014.html')); perturbation of mind; something lacking in the sight; undulating full pulse; sweetness in the mouth; urine thick, strong and leaden-coloured on top[15](javascript:footNote('T600008/note015.html')); itch in the nose, on the neck, and where the cupping horns are placed; shortness of breath; profound sleep; difficulty of conversation; and an imposthume at the base of the ears and the tongue. These symptoms are more pronounced in synochus than in synocha.


#### 6


Item no cold or horripilation precedes this fever, because the blood giving rise to it[16](javascript:footNote('T600008/note016.html')) is in the veins, excepting if it be caused by the imposthume called phlegmon, situate on the liver or the midriff[17](javascript:footNote('T600008/note017.html')); for then come paroxysms like to tertian fever[18](javascript:footNote('T600008/note018.html')), because it heats as if it were choler.


#### 7


Item **Averroes** says the signs manifesting this fever are those that signify the dominance of sanguine humour; the which are[19](javascript:footNote('T600008/note019.html')): heaviness in the head, the eyes, and the temples,


---

p.27






especially in the season of sanguine humour; sleep, yawning, perturbation of mind, sweet taste in the mouth, and a flow of blood from the nose, the anus or the womb, if the region, the season[20](javascript:footNote('T600008/note020.html')), and the age be in agreement; and itch on the place of blood-letting[21](javascript:footNote('T600008/note021.html')); he sees red objects in dreams, blood or flowers or beautiful gardens in dreams.


#### 8


These are the signs that follow this fever: swelling of the face, and flaccidity of the whole body; sometimes smallpox, or measles, or chickenpox (?)[22](javascript:footNote('T600008/note022.html')), or quinsy supervenes and other evil symptoms which are wont to come in time of plague and are caused oftenest by corruption of the blood. These symptoms are less pronounced in synocha than in synochus, on account of the putrescence; therefore the latter is like to ephemera.


#### 9


Prognosis of aumasticus[23](javascript:footNote('T600008/note023.html')); the which is a deadly kind for the most part, for it is the worst of them. The crisis comes most frequently on the seventh day, and it *the fever* is terminated[24](javascript:footNote('T600008/note024.html')) sometimes by a noticeable evacuation, and at other times by an insensible one. The crisis in this species is imperfect, for it turns sometimes to causon or frenzy, and at other times to lethargy, or smallpox, or measles: sometimes to subeth[25](javascript:footNote('T600008/note025.html')). Sometimes the belly swells and a noise *is heard* therein, like unto the voice of the tympan and thunder, and an ‘outgoing’ checks not this[26](javascript:footNote('T600008/note026.html')). It may be recognised by the *signs of* digestion on the third day, or the fourth, if the crisis will come on the seventh day; and sometimes it is ended on the fourth day, and sometimes later.




---

p.29


#### 10


Item epamasticus[27](javascript:footNote('T600008/note027.html')) is the best of these and homotonos the mean. Item should broad black pustules, or green leaden hued ones, appear on the sufferer from this fever, it is a sign of death. Item if the eyes shed involuntary *tears* in this fever, it is a sign of death, unless there be an imposthume or an itching on them in the lids.[28](javascript:footNote('T600008/note028.html')) Item heaviness after sufficiency of sleep is a bad symptom and a sign of death, and likewise great difficulty in drawing breath on account of the violence of the disease. Item when small black pustules[29](javascript:footNote('T600008/note029.html')) arise on the tongue of sufferers from this disease, or any other acute sickness, it signifies death, and especially if they desire hot things. Item if on the knee of the sufferer a little black pustule[30](javascript:footNote('T600008/note030.html')) arise with redness round it, it is a sign of death; and though these pustules disappear suddenly, unless they were wont to be on him in health, it is a cause for fear. A red imposthume on any principal member is dangerous, more especially if it appear on a place whither that member sends its excess,[31](javascript:footNote('T600008/note031.html')) or near thereunto.


#### 11


The cure of this fever demands the evacuation of the matter, alteration thereafter, and rationing of food and drink. The evacuation is ordered first here, but not so in other fevers, except those from blood, if it be pure, as in synochus.[32](javascript:footNote('T600008/note032.html')) Note, much purging is demanded in this fever, such as blood-letting, cupping, *scarification*[33](javascript:footNote('T600008/note033.html')) of the small of the foot and the nose, and by the haemorrhoidal and menstrual flow: and laxative medicaments avail here, and clysters, and suppositories. The letting of a vein is the last and the best of them; and if the


---

p.31






force and the age and the season permit it not, let the horn be applied to him, and the blood of the small of the foot[34](javascript:footNote('T600008/note034.html')) is best here. If he abide that not, reduce his food and drink, employ sweating, and rub the members; the which **Hali** teaches when he speaks of superfluous repletion. This is manifest in synocha, for **Hali**[35](javascript:footNote('T600008/note035.html')) says, it has no other cause but **plethora** and excessive oppilation, produced by red blood, wherein the excessive quantity is at fault.[36](javascript:footNote('T600008/note036.html'))


#### 12


Since we have spoken of phlebotomy, it may be asked, is it meet to let a vein here, till weakness seize the sick man? They say it is meet, for **Galen** says, when we bleed a patient in acute fevers, it is till weakness seizes him, for that cools the whole body at once, quenches the fever, and relaxes the bowels; the sweat breaks out, and many folk have I cured entirely thereby. Therefore it is meet to bleed a sick man usque ad syncopen. Item **Avicenna** says the same, but **Averroes** is against it, and says, the patient should not be bled to the point of faintness. **Avicenna** says that it is better to remain within the limit in drawing off superfluities than not to perform the letting. Item he says again, it is better to increase the *number of* times, than the quantity. Item he says again, in excessive repletion it is meet for the evacuating to be equable,[37](javascript:footNote('T600008/note037.html')) by drawing off the matter gradually, and such purging does no harm to the weakened body, and therefore still less to a strong[38](javascript:footNote('T600008/note038.html')) body. To this I say, with **Averroes**, that it is imprudent to continue the letting till the sick man is at the point of collapse; for **Galen** says:[39](javascript:footNote('T600008/note039.html')) ‘See, O learned man, that weakness seize not thy patient under thy hands.’ Thou mayest


---

p.33






continue till slight weakness of the branches lay hold of him, according to **Constantine**. Or as **Avicenna** says: ‘Cease not, till he be approaching faintness’; and there he speaks of the weakness of the branches and not of that of the force.[40](javascript:footNote('T600008/note040.html'))


#### 13


However, since Nature hates a sudden change, let the matter be drawn off gradually, to evacuate that which is superfluous. If it be asked of you what amount is excessive in physic,[41](javascript:footNote('T600008/note041.html')) since all the blood is good here, *and* therefore if one part of it is rightly excessive, then the other part is excessive *too*, and so it should all be drawn, if one part is drawn; I say, for example as follows, that one pound only is excessive, and if it be drawn off, Nature arranges the remaining part thereof; and since she gets help from the things nearest, she makes good what is lacking.[42](javascript:footNote('T600008/note042.html')) Neither is the reasoning correct[43](javascript:footNote('T600008/note043.html')) that all *the blood* is peccant and therefore it were right to draw it all off, for if some be evacuated, the other parts do not err; or else it is the parts farthest from the heart that are to blame, and the blood should be drawn from them. So the evacuation is in the branches and the deficiency likewise, and not in the root.


#### 14


If it be asked what is the right time to let blood, **Avicenna**[44](javascript:footNote('T600008/note044.html')) says, heed not the number of the days, but consider the force of the patient. If it be strong, let a vein on the fifth day, and not only on that day, but on every day thou shalt visit him.[45](javascript:footNote('T600008/note045.html')) Nevertheless **Avicenna** says, if a vein be not opened at the outset of this sickness, there is no use in bleeding *him at all*, and therefore it is not right to bleed him every time thou visitest him. I reply, in the case of putrid fever that


---

p.35






comes to increase after inception, there is no use[46](javascript:footNote('T600008/note046.html')) in bleeding; for he suffers laxatives more readily then than phlebotomy,[47](javascript:footNote('T600008/note047.html')) because the matter is digesting: (as) there is no digestion at the beginning of this fever; and therefore a vein may be opened then, if the force, the age and the season permit. Open first the medial vein in the right arm, then the medial vein in the left,[48](javascript:footNote('T600008/note048.html')) and thereafter *that* in the right. Whereupon let the Basilic vein in the right arm, and if needs must the same in the left. If that avail not, let the cupping horn and scarification be applied between his shoulders, and do the same to his calves and both sides of the hips; and let the saphenic vein be opened on both sides in these two cases, as well as the lower vein in the arm on both sides, but first from the right arm, because of the liver, which is the source of the blood.


#### 15


If the sufferer be a plump infant, he may be bled a little then, for **Averroes** says **Avenzoar** bled his son at the age of three years. If it be a woman et menstrua retinentur, it may be relieved by a vein of the inner ankle,[49](javascript:footNote('T600008/note049.html')) and if the haemorrhoidal flow be withheld, relieve it by the same. I say it is better to open them externally, and if the veins of the anus be so relieved, apply boiled onions to the heads thereof. To him who is constipated, give a clyster in which are boiled violets,


---

p.37






mallows, mercurial, great mallows, bran, **cassia fistula**, and a little salt.


#### 16


The proper purgatives to give here are those that purge choler, and *purify* the blood from burnt humours, as **cassia fistula**, tamarind, violets, borage flowers; the juice of bugloss, of rue, and of roses[50](javascript:footNote('T600008/note050.html')) (?); **myrobalani citrini**, **chebuli**, **emblici**, **bellirici**, and **indi**. If he have taken food previously, or be drunken[51](javascript:footNote('T600008/note051.html')), give him but little of these, and also if he be a person that consumes many cold things, as cold water, cold fruit and the like. The compound purgatives that avail in this case are: **oxylaxativum**, **diaprunis**, and **triphera saracenica**.


#### 17


Let us now consider the cold things, and amongst these, cold water is most recommended for them, on the further conditions added thereto;[52](javascript:footNote('T600008/note052.html')) the matter should be *digested* in the intestines, and no hard imposthume present in the same: the upper and the lower part of the stomach should be neither weak, nor cold, nor any humoral putrescence therein, neither be there oppilation, nor excessive repletion. On these conditions the sick man (he) may drink as much as he please of the water, without taking breath;[53](javascript:footNote('T600008/note053.html')) having first been purged by bloodletting, for in every case this is best, unless drunkenness, or nausea (excessive filling) prevent it, and if so a clyster is more beneficial, or diet of food and drink, or suppositories, or rubbing.[54](javascript:footNote('T600008/note054.html'))


#### 18


Item if the blood be thin, it should be thickened by these: **plantago**, poppy seed, and that of coltsfoot. If thick, let it be thinned by endives, scariole, chicory, **lactuca** (i.e. lettuce) if the sick man cannot sleep, and burnt ivory turnings. Item the following thicken the blood: **diatragacanthum**[55](javascript:footNote('T600008/note055.html')),


---

p.39


**gummi arabicum**, **berberis**, sorrel, **coriandrum**, and sugar of roses. Item these are the comfortatives: **diatrionsantalon**; and if he cannot sleep, **diapapaver**; and **diatragacanthum frigidum** if he have difficulty in drawing breath, nevertheless it is advantageous (?).


#### 19


The cure of this fever called synochus is accomplished in two ways, by bleeding, and by *cold* water. **Galen** says a vein avails always if the force be strong, but it is not good as a rule to use cold water unless there be signs of digestion of food in the flux,[56](javascript:footNote('T600008/note056.html')) in the pulse or in the urine, and when the fever is greatest and sharpest. And therefore it is that if the blood be choleric *cold* water avails before the digestion of the matter, as it digests by cooling and by checking the malice, on the before-mentioned conditions, because cold water increases oppilation at times, and when a man drinks his fill thereof; for sometimes it cures, or at other times it turns to phlegmatica. **Averroes**[57](javascript:footNote('T600008/note057.html')) says, this is preferable to death, and therefore he says it is better and more proper to give him camphor in electuaries and foods and drinks; for a drink of barley water, and andivia mixed with camphor, is made against the thirst, because it greatly cools.


#### 20


Item it is proved that it avails not in either of these (?), for **Galen** says it is not conceived (?) that the fulness that is in


---

p.41






the veins can be purged by laxatives, or it is not possible, and the veins of him who has great thirst[58](javascript:footNote('T600008/note058.html')) are full. I reply absolute fulness is when *all* the humours increase equally in the veins, the which truly cannot be purged by any simple laxative medicament, though perchance it might by a compound one; and fulness and repletion outside of the veins is when one humour alone increases, and the name thereof is the ‘fulness of an evil humour’,[59](javascript:footNote('T600008/note059.html')) the which may be purged by laxative medicine.


#### 21


If it be said with **Galen**, that the increase of *all* the humours should be evacuated by blood-letting, and if it be only of one humour, then by laxatives, and therefore, that it follows that purgative medicine is for sanguine humour alone; I agree, but we should not use it without preparing with the following[60](javascript:footNote('T600008/note060.html')): aloes, centaury, juice of honeysuckle and agaric. Regarding the word **Averroes** spake, that it were impossible to purge the fulness in the veins with laxative medicaments, I say this is how that should be understood: ‘impossible’, that is, ‘not easy’ or ‘difficult’. When one humour alone increases outside the veins, it is easy to purge it with laxatives, but *in* the case of fulness of the body in

the veins, it is not good for them.[61](javascript:footNote('T600008/note061.html'))


#### 22


These are the foods[62](javascript:footNote('T600008/note062.html')) that avail in this *fever*. Pottage made of oatmeal and chicken broth; barley sowens[63](javascript:footNote('T600008/note063.html')), and bread seethed in milk of almonds; and chicken broth with lettuce, if the force be weak; fresh water fish and meat that


---

p.43






is close-grained and free from taint, with juice of sorrel, and acid syrup[64](javascript:footNote('T600008/note064.html')), or *syrup* of violets or nenufar.


#### 23


As we have spoken of blood-letting, note that it is most proper and avails most for persons of robust and stout habit, and from whom but little is dissipated. Not thus for the folk who have thin bodies and dominance of choler in the pit of the stomach, as for them it avails not. In cold wet weather it avails most, and for dark folk who are wont to consume much meat.[65](javascript:footNote('T600008/note065.html')) It may be asked here—if there be little good blood in the body, and many crude humours, does a vein avail in that case? It is proven according to **Galen** that it does avail, and **Hippocrates** says, regarding the people that fill themselves excessively and are drunken (?), who cannot but have crude humours, and where there is little good blood and a **plethora** of raw humours, blood-letting is beneficial.


#### 24


Item I suppose, for example, that there comes an imposthume of the breast or lungs from phlegm, along with drunkenness, and rawness of humours, and there is little good blood present then, because of the quantity of phlegm and the fever; no one denies that in such a case, letting a vein is not good nor any other sudden quenching; if any one say bloodletting avails not in this case, it is true, for the good blood would go out and leave the bad within. I say against this that Nature is wise, and there is no limit to her skill in ruling the animal, and if that is true, she will retain the good blood inside for herself, and let the bad go. Item **Galen** says, it is the blood that Nature purges ultimately from the superfluous substance of the humours; therefore she retains the good blood for herself at last, through her skill: the bad blood will go out and the good blood will remain within. **Galen**(?)


---

p.45






says the contrary of this in The Regimen of Health, where he says blood-letting avails not in this case. This is the reason: because a vein is only beneficial in two cases, i.e. when red blood alone has the dominance, or else all the other humours combined, according to **Galen**; and sanguine humour has not the dominance here, for it does not increase (?), but diminishes, nor the other humours combined, but the crude humours only *hold sway*; and so in this case, according to the rule of **Galen**, blood-letting does not avail.


#### 25


Item **Galen** allows that it would avail, but it does not because the humours are crude and viscous, and though the aperture be big, they could not emerge because of their thickness. Therefore if there be but little good blood, that is[66](javascript:footNote('T600008/note066.html')) what gets out first, because of its thinness, and the wider the opening the easier is the exit. From this it is clear that in acute putrid choleric fevers, where there is not so much thickness, if the opening be narrow, the good thin blood comes out first, and if it be increased thereafter, the corrupt blood emerges.


#### 26


Item if a vein be opened in this case, it will do great harm, which **Galen** warns *us* to avoid; namely, it draws the crudeness of the humours from the little veins to the big veins, and if they be in the big veins it draws them to the members; and it were great harm to nourish the members by the crude humours; and therefore a vein avails not in this case. Nor yet lesser things, for a bath is not beneficial, nor labour, nor coition; but rather abstinence, solitude, long sleeping, light rubbing on the members, and things that comfort them.


#### 27


As to the first reason, I say a thing can be over-filled in the absence of crude humours, though they be old in the filling (?); and there are people who have narrow veins and


---

p.47






who though they eat little food, digest it well in the stomach and the liver, and none the less do they fatten excessively. Or else we may say: there is so much matter undispersed, because of its (?) labour, that if it be not purged suddenly it would choke *them*: and nothing evacuates with greater suddenness than a vein; so if it avail not for its own sake, it avails for the excess. In the same way I answer the reasoning he made regarding an imposthume of the breast or lungs. As regards the other argument, that Nature is skilful in her works, I say that is true, when she is greatly troubled therein; and for the *other* reason, I say the comparison is not right, because there is a big opening in the veins, which the laxative medicaments have not, but they go from the big veins to the narrow veins which are at the back of the liver, and from thence to the still narrower veins called meseraic. Thus it is easy to retain it finally, and therefore at last that thing is expelled which increases most, or which nature needs least.




---

p.49


[67](javascript:footNote('T600008/note067.html'))[68](javascript:footNote('T600008/note068.html'))
B. Non-material sicknesses i.e. Ephemera and Hectica.
-----------------------------------------------------


#### 1


These are two fevers and since the cause of a species[69](javascript:footNote('T600008/note069.html')) of hectica is ephemera, we should rightly speak of it *first* according to **Averroes**. Ephemera is so-called, because efemiron in Greek is the same as a *certain* fish in Latin, the which fish[70](javascript:footNote('T600008/note070.html')) is only alive for one single day; and in the same way this fever does not continue beyond one day in its own course. Ephemera is a fever resulting from exceptional immoderation of the spirits[71](javascript:footNote('T600008/note071.html')) which does not last beyond twenty four hours, as regards its own nature. And therefore note, there is true ephemera, and false: the true ephemera does not continue beyond a natural day without finishing; the false continues at times till the third and at other times till the fourth day, and the cause of it is the grossness of the matter in the body, or the blocking up of the pores, the which prevents opening; or because of the oppilation of the pores from an external cause.


#### 2


**Gilbert**[72](javascript:footNote('T600008/note072.html')) says that it is not because there is no matter in it that this fever is said to be non-material, but because it has no *peccant* humoral cause that precedes it, (like hectica). And[73](javascript:footNote('T600008/note073.html')) though **Avicenna** puts down this fever as coming from many causes, such as excessive flux, coition, or excessive


---

p.51






drinking, hunger, syncope, want of sleep, and many more of the like; nevertheless these may be reduced to four causes[74](javascript:footNote('T600008/note074.html')) alone. The first of these from an external cause which heats and blocks the pores actually or potentially, as is the heat of the sun or of a fire, or a bath with hot things in it, or one wherein is sulphur or cold water; briefly everything that closes the pores and prevents the escape of the vapours. Note, the diversity of fever is understood according to the diversity of the bodies and the vapours; for if the body be hot and dry, and the vapour(s) likewise, this stoppage is caused by the blocking of the pores and the like; then this fever called ephemera is easily generated. And if the body be hot and moist, the vapour is thus retained, and therein putrid fever is easily generated.


#### 3


The second cause:[75](javascript:footNote('T600008/note075.html')) *hot* food and drink; and warm dry medicines; as are strong, old, pure wine, garlic, onions, pepper and **euphorbium**, without being used to them. The third cause:[76](javascript:footNote('T600008/note076.html')) disturbance as regards the body or the soul, such as anger, immoderate exercise and the like. Should there be *causes* present, they can be broken and brought hereunto.




---

p.53


#### 3


The fourth cause[77](javascript:footNote('T600008/note077.html')): imposthumes that arise in the inwards, whither are banished the surplus of the chief organs.


#### 4


See now why diseases are said to be non-material. Since a humour is peccant in every sickness in the world, if the matter be harmful, the member is injured; therefore since blood is in every member,[78](javascript:footNote('T600008/note078.html')) a perceptible injury cannot be made therein unless the humoral matter be infected or injured.[79](javascript:footNote('T600008/note079.html')) Item **Averroes** says, in truth, no disease whether simple or compound is without matter[80](javascript:footNote('T600008/note080.html')); *no simple disease* for there is no one cause in the body which is hot only or cold only, without matter; nor compound, for there are composite causes (diseases) in the body, hot and moist, hot and dry, cold and moist, cold and dry.


#### 5


Item I say that the fever called ephemera injures the vital spirit first, and the animal spirit or the natural spirit thereafter, the which are in the humours; or the humours adjacent to them are infected, but the spirits are infected soonest, but not so that it is necessary to undertake some other operation against them, that was not done against the humours, or vice versa. It is sufficient to effect one change only, and ephemera heats it. Hence **Avicenna** says there is no fever therein, until fiery heat seizes the entire heart; the which is not material, as there


---

p.55






is no peccant matter[81](javascript:footNote('T600008/note081.html')) there in its substance to be purged by medicine. Therefore **Isidorus** says, in the same way purging does not necessarily avail in every sickness wherein is a peccant humour, such as causon from burnt choler.


#### 6


Note[82](javascript:footNote('T600008/note082.html')) that there is an external cause ... the fault of a humour or humours, because of their quantity; the letting of a vein avails there. In one kind there is the fault of a humour on account of causon or putrid substance or quality wherein drawing avails; and in another kind it is the fault of humours, as regards their[83](javascript:footNote('T600008/note083.html')) own sharpness and vehemence; wherein a change avails. Therefore there is the fault of a humour in every disease, nevertheless it is not material, that is it has no *matter* in it, which is subservient to, or necessary for, evacuation.


#### 7


**Avicenna** says, these are the ordinary signs of this fever i.e. it comes from a primitive cause, and not from an antecedent cause, unless it be false ephemera, and it does not begin with *horripilation* and shivering (?), unless it be true ephemera, which is produced by oppilation of the pores through humoral matter, for this is intermediate between true ephemera *and


---

p.57






putrid matter* called putrida. And the pulse and the urine vary little from the normal and the heat neither irritated nor burning to the touch, but is like the heat of a man labouring and angry, and is terminated by natural, moderate sweat oftimes. **Avicenna** *applies* another sign to it, as follows.[84](javascript:footNote('T600008/note084.html')) Let the sick man be put in a bath, and if unwonted horripilation and shivering (?) result therefrom after a space, understand that it is putrida, and if a change come not to him then but such as is wont, understand that it is ephemera.


#### 8


Draw special indications of the primitive causes from the patient himself, i.e. should the head[85](javascript:footNote('T600008/note085.html')) be hot from the sun to the touch; if the colour of the skin[86](javascript:footNote('T600008/note086.html')) turn *dark and livid, it is from cold, and if it become* hard and dry, as though it were stretched, that is produced by styptics; should there be heat round the liver in the natural spirit[87](javascript:footNote('T600008/note087.html')), it is caused by drink or food, and the urine is highly coloured; if it come from hard labour, *the body* is weaker and there is pain in the joints; if from anger, the eyes are protruding[88](javascript:footNote('T600008/note088.html')) and the face red, unless the anger be mixed with depression, because he cannot wreak vengeance[89](javascript:footNote('T600008/note089.html')); and in that case he turns pale, and undergoes many changes of colour. If it come from depression alone, the eyes are sucked back (sunken); and if from poison, there is great heat and dryness internally, which causes violent thirst, and they say these are the people of melancholic humour.


#### 9


Prognosis of this sickness. Understand, it is difficult to recognise this fever, but once recognised the cure is so



---

p.59




much the easier. Thus, if the pulse be variable and the urine undigested, he passes into putrid *fever*, particularly[90](javascript:footNote('T600008/note090.html')) if the urine be evil-smelling. If the body be dry and hard to the touch and this not resulting from styptics externally, there is danger of its turning to hectica, and for that reason let there be no delay in curing him.


#### 10


Item[91](javascript:footNote('T600008/note091.html')) the people who fall oftenest into the disease called hectica, or tertian fever, are those who have a hot *dry* complexion, but they whose complexion is *hot* and moist, fall quicker from ephemera into the complexion of putrid fever; thereafter those in whom heat is greater, and again those in whom dryness is greater, and if the complexion be hot and dry, and the sick man suffering from hunger, want of sleep, or bodily labour, he falls swiftly[92](javascript:footNote('T600008/note092.html')) (?) into ephemera; and unless he get food at once, he passes into putrid fever.


#### 11


The cure of these cases is brought about in two ways. The first of these, by changing the hot dry complexion; the other, in that something may be done against the extrinsic causes whence this fever is produced, along with a regimen of food and drink.[93](javascript:footNote('T600008/note093.html')) The first thing is accomplished by cold moist remedies according to particular matters[94](javascript:footNote('T600008/note094.html')), such as complexion, age, habit etc., and the causes it produces (?); the cooling is produced by itself or by accident. By itself i.e. cold foods or medicines that cool internally: by accident, that is by a bath of hot or tepid water. A bath avails much in this fever, for it disperses the vapour, which if it were not dissipated would throw the body into acute heat and turn to corruption;


---

p.61






so the bath is a common remedy for all who have this fever, and especially if it be on the decrease; and it should[95](javascript:footNote('T600008/note095.html')) be avoided by those ready for the corruption of the matter (putrid fever).


#### 12


The following is a special cure for this case: to do something against the external cause whence the fever comes; whether it be caused by fire or by the sun. Put the sick man in a cold place and cool the air with a linen cloth, in the same way as a bellows cools *it*. If the pain [96](javascript:footNote('T600008/note096.html')) be in the head, let cold water be poured thereon, for it cools quickly; and put him in a bath of hot water and let him remain long therein; thereafter let it (the cure) be accomplished by rubbing *with* oil of roses or water rue (?) or violets.


#### 13


If the cause be styptic, a bath of hot water relieves; and let the whole body be rubbed with oils that are aperient without being styptic, and other things such as camomile oil and do not rub it in until he has had the bath. And do not give the bath more than once unless the fever return. And if it be seen that it does not avail him, understand there is **plethora** present or that he has an internal stoppage; then let a vein and move the bowels with laxatives, for that remedy is medial between ephemera and putrida. If the cause be cold, put him


---

p.63






in his bed[97](javascript:footNote('T600008/note097.html')) with boiled herbs beside him, so that he sweat, for this is better than putting him in a bath of hot water, and let him be rubbed with hot things, according to hot action (?)[98](javascript:footNote('T600008/note098.html')).


#### 14


If the cause be produced by hot food, give him a vinegar syrup and cold things, that cool the stomach and the liver within and without; bread made with vinegar, triasandal (diatrionsan:) along with camphor. If the cause be labour or motion, let him rest and rub oil of camomile and violets to his joints; and apply fomentations thereto, of roses, violets and camomile. Give them (the patients) food that nourishes well, such as eggs, small fish, and the genitals of a cock. To escape this fever coming from fatigue[99](javascript:footNote('T600008/note099.html')), know ye, whatever man may make a long journey, if he carry ragweed in his hand, the walking will not hurt him, as[100](javascript:footNote('T600008/note100.html')) **Alibertus** says.


#### 15


Give roots of ragweed tempered by subtle wine, or with good broth, at the end of the day, to him who is tired after walking, and the fatigue will go from him, as though it had never been—so says Dioscorides. And whoever goes a journey, if he carry a staff of tutsan[101](javascript:footNote('T600008/note101.html')) he will not stumble against a stone, or anything else, nor will walker's abrasion (?)[102](javascript:footNote('T600008/note102.html')) seize him; and if it do, he need only rub on oil of roses, or the yolks of eggs, raw or heated. This is useful for friars, who walk the country, or the people of pilgrimage, or for envoys, according to **Serapion**.


#### 16


[If it be caused by want of sleep and he have constipation],[103](javascript:footNote('T600008/note103.html'))


---

p.65






give him a clyster or honey suppository;[104](javascript:footNote('T600008/note104.html')) and if the food be swimming in the stomach, make him vomit[105](javascript:footNote('T600008/note105.html')): let him not take food till it be digested, and thereafter pay no heed to the fever, but comfort the stomach so that it digest the superfluities. If the bowels be relaxed, apply hot wormwood juice to the mouth of the stomach, and give easily digested foods, tending to coldness with some astringency, such as rose and nutmeg, and the like. If the matter come from hunger, give him food, and especially if choler be the peccant humour, or be dominant therein, for they are unable to take any meal.[106](javascript:footNote('T600008/note106.html')) If it be produced by imposthumes, let them be cured in the way *stated* in the treatise on imposthumes[107](javascript:footNote('T600008/note107.html')): therefore the nutriment of food and drink of those suffering from these fevers should tend towards cold and moisture, except when it is caused by consuming too much food.


#### 17


Since[108](javascript:footNote('T600008/note108.html')) we have spoken much concerning water in these diseases, it may be asked whether it avails in fevers in every age. It is asserted that it avails not in any age, for it does not help youths as they need much nourishment to increase their growth, and there is not that nourishment in water; so it avails them not. Item it does not help young people, for by their like they are maintained, while water is contrary to their complexion; and so it avails them not. Item it is not good for the old, as it is like their complexion; in those immoderate people when like is put to like, it increases it, makes it vehement; and so it is not good for the old. **Galen** is against this in Regimen, where he says, good water avails for every age. And I say there is nothing in the world more efficacious for every age, in general, than water; and therefore we should


---

p.67






take much pains to find good, pure, cold water. Let us take for example food and air and the other particular matters in turn, and I say they are the moderate things that benefit moderate things, and that they are common to immoderate things. I say also, though the age be moderate or immoderate, it i.e. water (?) is not *merely* advantageous, but necessary or almost so; for when the food is thick in comparison with water, it cannot penetrate to the members, if it be not thinned; therefore since water is thin and fluid, it makes a way for the food to the members without doing the least harm. Neither wine nor milk nor any other simple does the like, and therefore there is nothing more beneficial to every age than good water. As to the reasons given against this part, I allow them; for in the way he gives the reasons, it does not avail; nevertheless it benefits in making a way for the food to the members, as aforesaid.


#### 18


Note, these are the conditions of good water. One condition is that it heats easily and cools suddenly. Another that there be no foreign bodies visible therein. Another that it be not turbid. Another that it be not ugly and evil-tasting. Another condition is: if two waters be taken and a little lixivium [109](javascript:footNote('T600008/note109.html')) mixed therein, then whichever does not become turbid, is the better of them. Another condition: take two identical cloths and wet them entirely in two *different* waters equally, and dry them equally; whichever cloth dries quickest, that water, wherein it was *wet*, is the best water. Another condition: take equal quantities of two *different* waters, and which ever is lightest is the best. He says *also* not to use water that goes through pipes, for according to all true doctors it is not good.




---

p.69


[110](javascript:footNote('T600008/note110.html'))
C. Hectica
----------


#### 1


Etica or Hectica is a non-material sickness. It is moreover a wasting fever, and they say that it is a continuous fever,[111](javascript:footNote('T600008/note111.html')) without the fault of a putrescent humour, which has its origin in the heart[112](javascript:footNote('T600008/note112.html')) and the close members; and thereof are three varieties.


#### 2


The first of them is light,[113](javascript:footNote('T600008/note113.html')) that is, when the external heat is kindled in the natural and radical juices, and in the roots that are in the substance of the little veins, at the time the moisture called rose is kindled. The second is in the moisture which is in the flesh, and when it is dispersed, it can be cured at times by food alone, and that is when the fluid called cambium is kindled.[114](javascript:footNote('T600008/note114.html')) The third[115](javascript:footNote('T600008/note115.html')) form is the worst of them, when the external heat deepens itself in the close spermatic members; and this is when the moisture called gluten is corroded (?), for it binds the members together.


#### 3


The following are the causes of hectica. Everything that heats, and dries, and burns the heart, and the close members; and it also comes from other diseases preceding it, such as ephemera and causon and their like. And especially to those to


---

p.71






whom abstinence is ordered in a wrong season,[116](javascript:footNote('T600008/note116.html')) or who are refused a drink of cold water at a time when they should drink it; for it is easy for them, and those of a hot dry complexion to pass into hectica; also for lean people. It comes also through the fault of the heart, the lungs, and the chest, as are phthisis, and **apostema**, and their like. It is produced by accidents of the soul, which are long and puissant[117](javascript:footNote('T600008/note117.html')), and especially pain and depression and oppression of mind, anger, and labour that fatigues body and soul, and long lying in prison. Therefore **Avicenna** says, he who leaves his usual work[118](javascript:footNote('T600008/note118.html')) passes into hectica; the which is surprising, for they who avoid labour, rest for the most part, and resting moistens the body.


#### 4


Item he who does this, takes to himself a disease from fulness of humours; so it is not a wasting sickness he contracts.[119](javascript:footNote('T600008/note119.html')) Item he who forsakes his work, becomes cold thereby, *therefore* I say there are two hecticas: hectica that comes from old age, and that which comes accompanied by fever. He who avoids his work, contracts the hectica of old age, for the excess remains in the body, and that weakens it and the digestion, and causes diseases from fulness of humours: that being so, it throws a man into old age, the which age is cold and dry as the heat is weakened on account of the excess remaining in the body, and so the digestion is weakened, and the food is not sufficiently digested in the stomach or the liver: for the error produced in the first digestion is not corrected in the second, according to **Isidorus**; nor in the third, therefore the members receive neither plentiful nor sufficient nourishment, and are impoverished, and so hectica follows the


---

p.73






swelling.[120](javascript:footNote('T600008/note120.html')) Through this we should say, the first thing to be consumed in hectica is the recent fattening surrounding the firm solid members internally (the which is not the fat bordering on the skin), and thereafter the older fattening is consumed.[121](javascript:footNote('T600008/note121.html')) Or the species of hectica are defined (?)[122](javascript:footNote('T600008/note122.html')), not according to the consumption[123](javascript:footNote('T600008/note123.html')) of the various liquids, but because of that of the various members, such as the fat and flesh first, the arteries and veins thereafter, the bones and the cartilages in part.[124](javascript:footNote('T600008/note124.html')) Thus he who contracts hectica passes into diseases produced by fulness of humours[125](javascript:footNote('T600008/note125.html')) per accidens, into accidental flux, and moisture, such as dropsy.


#### 5


Speaking of the hectica that comes (along) with fever; sometimes it comes accidentally, for he who avoids his work, retains the superfluities, which through want of windiness go to heat, and corrupt. Hectica follows every putrid fever that comes frequently, or continues and remains long. In this way, I grant that heavy labours and weak immoderate exercise produce hectica of themselves, while long lying *in prison* and avoiding regular occupation cause it accidentally. Excessive coitus does the same, also great flux of the belly (diarrhoea), excessive haemorrhoidal or catamenial flow, or that of urine, or excessive vomiting; constant vigil, or excessive meditation; and everything that heats and dries the body unduly. **Avicenna** says, fever is frequently generated by too violent purging, and especially hectica.


#### 6


Signs of hectica. The pulse *and the heat*[126](javascript:footNote('T600008/note126.html')) of the sick


---

p.75






man should be noted at the end of three hours after taking food, and observe whether it (the heat) is greater in the nerves (?) than in the veins[127](javascript:footNote('T600008/note127.html')) *or in* the places nearest to them; for when the heat is equal there is no difference between them, as regards its own nature. The skin becomes withered, the which is a sign of the first form of hectica, which is hard to recognise and easy to cure, according to **Avicenna**; for he says, the first form may be recognised through its want of dryness.[128](javascript:footNote('T600008/note128.html')) And **Galen** says, the heat increases in sufferers from hectica when they eat food; and **Averroes** says, this occurs three hours thereafter, that is, when it is digesting.[129](javascript:footNote('T600008/note129.html')) And[130](javascript:footNote('T600008/note130.html')) I say, when the patient consumes food, i.e. extra food, it cools the body forthwith, and when he consumes *food in the natural way of* digestion in the stomach, along with a kind of digestion in the liver, then it is *dispersed* throughout the members, so that it heats then, and *thereafter heats* the members as a cloth that is in the day about a man, takes heat from the body, and *itself heats* the body thereafter. In the second variety of hectica *understand that dryness is* apparent therein, and whatever time he takes food, *so much the greater is* the inflammation and his pulse is the less thereof, *and there is no* sign of hectica *more certain* than that. *In the third form of hectica,* the eyes are sunken, *the skin drawn,* and the belly adheres to the back, the pulse is hard and taut as it were a 


---

p.77






cord being stretched, the urine is like oil, and should it strike against a stone it emits a dull sound.[131](javascript:footNote('T600008/note131.html')) Therefore when the fever sets in, it impoverishes the body, dries the skin, the face becomes deformed, and the eyes deepen. When it reaches the last stage of hectica, you will see his eyes as though there were ashes scattered on them, and the lids are drawn down like one who has spasmus;[132](javascript:footNote('T600008/note132.html')) the skin of the forehead is drawn and dry; the ears become yellow, and the skin of that part called mirach is dry and wrinkled. Mirach is the membrane that lies outside siphac on the belly, with siphac within, the which separates the nutritive organs from those of generation, and the intestines are contained therein. The pulse is stretched like a cord, weak and rapid, and the urine like oil.


#### 7


Item[133](javascript:footNote('T600008/note133.html')) the bodies called crimnodes are present in the urine from the burning of blood and flesh, in the first form of hectica, and also in its combination with the second form. The bodies come like scales from the surface of the strong members, but the bodies like bran from their centre, which is a sign of the third form of hectica, and these are the worst therein: and the smaller they are, the worse; for then they come from the strongest members. If the bodies called crimnodes should come from one member only, then the bigger they are the worse; and so **Egidius** was not right in saying that the bodies called crimnodes signified the third form of hectica. *Sometimes* the bodies like bran come from the bladder,[134](javascript:footNote('T600008/note134.html')) then the urine is a good colour; and at other times should they come from the whole body, as in hectica, then it is evil-coloured.




---

p.79


#### 8


Crimnodes are fat particles[135](javascript:footNote('T600008/note135.html')) like wheat broken large or badly ground. When there is fat in the urine, if it come from the whole body, and appear slowly, it will be like a fishing net, in the first form of hectic fever. If it come suddenly, it comes from the kidneys, and the colour of fever will not be on the urine. If the sediment[136](javascript:footNote('T600008/note136.html')) be as thick as a spider's web, it is a sign of the second form of hectic fever, and if it be like oil it typifies the third form. For **Averroes** says, it is seldom this fever comes except after the fever called ephemera; save in bodies predisposed to it, or else after a putrid fever. Therefore it is necessary to know what are the signs of the combining of this fever *i.e. ephemera* with hectic fever,[137](javascript:footNote('T600008/note137.html')) and they are as follows: excess of vigour on the third day particularly as regards heat, as ephemera often begins to decrease after twelve hours, and when it goes beyond twelve hours with no signs of decreasing, but continues every day till the end of the third day,[138](javascript:footNote('T600008/note138.html')) then it is hectic fever.


#### 9


These are the signs of the combination of hectic fever with putrid fever: the urine and the faeces are fatty, and paroxysms[139](javascript:footNote('T600008/note139.html')) come, accompanied by shrivelling of the skin, which remains hot and dry after the decrease of the fever and the paroxysm*s*. Understand there is only one paroxysm[140](javascript:footNote('T600008/note140.html')) in true hectic fever, in which are the four stages of disease. If true hectic fever come from an *inflammatory imposthume[141](javascript:footNote('T600008/note141.html')) the pulse will be very rapid*.


#### 10


These are the signs of stasis in this fever: if hectic fever come, the nails bend and sharpen; the skin appears as


---

p.81






though there were dust thereon from sunburn, and dried *mucus* matter[142](javascript:footNote('T600008/note142.html')) *from the eyes*. The eyes are not opened because of the difficulty of raising the eyelids and the brows, but remain shut as though the patient were asleep. The nose becomes pinched,[143](javascript:footNote('T600008/note143.html')) and the hair of the eyebrows grows long, the shoulders are drawn up, and then is the stasis of the second form of hectic fever; and when at the decrease the cartilages[144](javascript:footNote('T600008/note144.html')) dissolve, then comes the third form of hectica. Item in the first form of hectic fever, the patient is better after a meal than before. In the second form, he is better before it. In the third form it is equal.


#### 11


Prognostics of this fever which is called hectic. Note, it is easy to cure the first form of it after it is recognised, though its recognising is difficult. The diagnosis of the second form is easy, but its cure is difficult. And for no power in the worid can the third form be cured,[145](javascript:footNote('T600008/note145.html')) for it is not possible to moisten the strong members, that is, especially, the spermatic, once they get dry. Item when the nails bend, and the hair falls, death will be near; and if diarrhoea come, the strength will collapse suddenly. A flux is almost always bad at the end of every long sickness; and if the calves swell, it is probable that the patient will die before the third day. When the palms are dry to the touch, and hot after food, the matter has turned to phthisis. Item if the appetite fail, and he is not able to take or swallow food, on account of the dryness of the gullet, and can only consume wet things, then death is near.


#### 12


Item when hectic fever[146](javascript:footNote('T600008/note146.html')) comes from the stomach,


---

p.83


**Hali** says it is curable: for when hiccup is produced by dryness of the same, it is *likewise* curable. And **Galen** says, the cause is the same when either hiccup or hectic fever is produced by dryness of the stomach, as[147](javascript:footNote('T600008/note147.html')) hiccup is only an unreal spasmus of the stomach: and therefore when it comes from dryness of the nutritive juices, it is curable. The same is true in hectic fever *arising* from the stomach in the first form; nevertheless, when hiccup or cramp arises from inanition of the spermatic juice, it is incurable; this is not the case in the stomach, except it suffer consumption or labour (?), as in the case of hectic fever and phthisis patients.


#### 13


The cure of this fever is accomplished first by cold moist things, and by cold wet foods; then by electuaries; then by baths; then unguents; and then by regimen of food and drink; and after that by things[148](javascript:footNote('T600008/note148.html')) that correct the air, *and* through the cure of the accidents. These are the cold wet thin things: food and medicaments. These are the medicines: common syrups, syrup of water rue, syrup of roses, and of violets. If it be accompanied by *putrid*[149](javascript:footNote('T600008/note149.html')) fever, then a vinegar syrup is good, and simple and compound **oxymel**.[150](javascript:footNote('T600008/note150.html'))


#### 14


Item make this drink for hectic fever patients.




---

p.85


#### 14


Take a portion of water rue roots; a fistful of each of these: andivia, liverwort, bear's-foot, and water rue (?). If inflammation of the liver or putrid fever follow, take half a fistful of scariole, dandelion and chicory; and unless the sick man suffer from a loathing of food[151](javascript:footNote('T600008/note151.html')), it is good *to give* a handful and a half of violets and lettuce. Since sleep greatly moistens sufferers from hectica, lettuce seed[152](javascript:footNote('T600008/note152.html')) is good, and **lactuca** therein, and **lactuca** itself, and white poppy seed, and coltsfoot; and the four large cold seeds, ½ ounce of each of these things, and 1/4 lb. figs; ½ quart of almonds; an ounce of roses if the stomach be too hot; ounceii of sanders, red and white, if the liver be too hot; ouncei of calcined ivory turnings if the heart be too hot, and ½ ounce of camphor. Flowers of water rue and violets are advantageous here; if he have constipation[153](javascript:footNote('T600008/note153.html')), and give ½ quart of each of these and ½ ounce of **cassia fistula**, if it be the first form of hectic fever, and a quarter of licorice, and a pound of cleaned barley, if the lungs be too hot. A pound or two of sugar,[154](javascript:footNote('T600008/note154.html')) or *more* according to the means of the patient; though the more sugar there is in it, the better. Make him this syrup, with well water or rain water or barley water, on a slow fire without smoke, to be taken at bedward, or on rising. If the stomach be cold, and the season winter, give it tepid, and if not give it cold, but not so in other fevers, as the heat is in the solid members here. Item this syrup is good for sufferers from hectic fever, and phthisis, and the cough; and for those recovering from some other long hot sickness, and especially for those who indulge in an excess of sexual intercourse and study,[155](javascript:footNote('T600008/note155.html')) and therefore I call it ‘the Golden Syrup’.




---

p.87


#### 15


The following are the thin foods[156](javascript:footNote('T600008/note156.html')) that cure: barley water, filtered tisane, white wine, watery and sweet-tasting; broth of capons and hens; milk, barley or oaten sowens unflltered, cullis,[157](javascript:footNote('T600008/note157.html')) and water of meat. These things are good here, for **Galen** says that it is easier for a man to fill himself with drink than with food,[158](javascript:footNote('T600008/note158.html')) and this should be understood of thin food, or of fat, as the digestion in these is weak. (And) **Averroes** says, tisane is the best food for folk who have a warm dry complexion to take after bathing, if the weather be warm and dry, because it cools, moistens, and helps the expulsion of excess in every weather, and in every way. I say likewise, a hot, dry complexion is accidental here. And if you say there is no excess matter in this case, because it is not a material sickness, then I reply that superfluities are generated therein, through the excessive weakness of force, or the want of digestion, though they be scarce and not the matter of this disease.[159](javascript:footNote('T600008/note159.html'))


#### 16


The tisane should be made of barley thus: let it be cleaned and boiled until it is broken up, and *then* strain it, or else put barley in a glass vessel[160](javascript:footNote('T600008/note160.html')) full of water, and boil it without smoke. Some people put the following quantity in: 3[161](javascript:footNote('T600008/note161.html')) lbs. barley, and 6 lbs of water, others put in 20[162](javascript:footNote('T600008/note162.html')) lbs. of water, but there is nothing in it but that it must be boiled down to 2 lb.


#### 17


And **Averroes** says, wine is good for sufferers from hectic fever, watery white wine, sweet-smelling, and every other watery wine, along with barley water, provided that it


---

p.89






be drunk after the digestion of the food. It will give greater relief than syrup,[163](javascript:footNote('T600008/note163.html')) for the wine prevents the food from swimming about in the stomach, disperses the flatulence, provokes the urine and the sweat; and helps nature to expel excess matter, when those who have this fever suffer from want of digestion, and especially when they suffer from want of sleep and worry. **Avicenna** says moist things do harm in hectic fever, as they are heating, and wine should be understood here, for it is wet. But **Isidorus** says, wine is wet as regards melancholy, and dry as regards phlegm. It is wet according to complexion, *but* since it provokes the sweat and the urine, it is easily turned to choler; therefore it is dry as regards virtue, and not as regards material dominion,[164](javascript:footNote('T600008/note164.html')) wherein it is wetter, nor as regards formal dominion, wherein it is drier; as is said, for example, that it is wet in substance, i.e. thin, or otherwise that it moistens according to its substance (substantially) because it is easily converted to red blood; nevertheless since it is dry, it is not good here, except thin watery wine *taken* seldom and in small quantities when the force is weak.


#### 18


**Bernard** says[165](javascript:footNote('T600008/note165.html')), note that new wine is hot in the first degree, old wine hot in the third degree, and medium wine in the second degree. Old wine is good [*...*] as a remedy only;[166](javascript:footNote('T600008/note166.html')) and new wine is neither good as food nor as a remedy; but medium wine is good as food, and drink, and remedy. Wine is good for hot people, for it purges them; and for moist people, for it moderates the moisture and ripens *it*; and for cold people, for it brings them to moderation; and it is good for


---

p.91






dry people, as it moistens and cheers them. According to this it is good for every complexion—that is, good wine.


#### 19


It is not good for every age as it is only adding fire to fire to give it to youths, according to **Avicenna**; and as much as it comforts the old, so much also it injures the young. *Galen[?]* says, if wine be drunk in moderation when it is required, it comforts the natural and animal forces, and gives good cheer and confidence. However much it gives relief if taken in moderation, it does still more harm if taken immoderately, for if the stomach be choleric, it turns it to choler; and if cold, it turns it to acidity and causes paralysis and cramp; and he who has a weak head gets drunk easily. Drunkenness comes from weakness of the brain, or excessive strength of the wine, or emptiness of the stomach, or from its being full of humours; therefore it is a rule that it is not right to drink wine without eating something first.


#### 20


It is not proper for a man who has a weak head to drink wine, except a little with water; so anyone who is at a feast, or drinking with friends, if he cannot keep his head, let him eat pears or the stalks (?) of cabbage, or its seed after his meal. If ill hap cause him to get drunk, as he will notice first by his tongue stumbling, let him get up and vomit. If it be a man, wash his extremities and rub them *and his testicles with salt*; and if a woman, wash her extremities and her breasts; let water be dashed on the face, and rub the head with rose water, and let him be a day and a night without food or drink. On the following day, let him do work and bathe, and let him eat something late, avoiding things hard to digest: and I say


---

p.93






it is not seemly for a Christian to get drunk with his own knowledge. For though there come vomiting and sweat thereafter, yet it is very dangerous to vomit, for fear lest he fall into epilepsy, or apoplexy, or in the case of a woman, **suffocatio hysterica**. So there is many a way that is better than this of purging the body, and it is all against God and reason.


#### 21


Let those of hot complexion drink white wine, thin, and tempered with water, for there are no comforts in wine but for moderate or cold bodies; and let no one drink wine after coition or heavy work, unless he take a rest thereafter, or unless he eat something that will bring comfort to the stomach.


#### 22


Note, thin[167](javascript:footNote('T600008/note167.html')) food is the remedy that avails most in this sickness, e.g. milk, according to **Averroes**. The best milk here is firstly breast milk, then ass's milk, then goat's milk, and then cow's milk, and it were better the butter be taken off it. When putrid fever is joined to hectic, **Galen** says, milk is no use then, for it is easy to corrupt milk, and sperm, and blood.[168](javascript:footNote('T600008/note168.html')) He (**Galen**) says, indeed, sperm is not out of the vessels an hour, or a moment, till it is corrupted.


#### 23


The milk should be drunk from the breast by sucking, and if this be loathsome to the patient, let him take it as hot as possible.[169](javascript:footNote('T600008/note169.html')) Take a vessel full of hot water, and put another *vessel washed with* hot water on top of it, and milk the milk into the latter; let it be drunk in haste, and it should be taken fasting, as much thereof as a man will be expected


---

p.95






to digest, because it turns to curds easily in the stomach, and then it is nothing but poison. Therefore it is best only to give a little of it at first, and increase it by degrees until it reaches a pound, according to **Averroes**. Otherwise bring it to the boil, and add a little water, and honey, and salt, or else *add* mint, or its juice, and quench red hot river stones or hot iron therein, and thereby so much the longer it will be without corruption; it will not curdle,[170](javascript:footNote('T600008/note170.html')) and so much the quicker will it leave the stomach; if it curdle, that will be known by the pulse, which is then weak and tight; if it does not curdle, then the pulse is strong and full, according to **Galen**. He says it is recognised by the smallness of the belly, that the milk is digested, and if it be ass's milk it is longer in curdling there. He teaches that the ass should be fattened with barley and lettuce and the like.


#### 24


Note, these are the best broths in this sickness: broth of beef, chicken, capon, mutton (ram's meat), soup of cabbage and peas. These are good for those who have hectic fever, or whatever fever they have, except ague (sharp trembling).[171](javascript:footNote('T600008/note171.html')) And note, though people say that meat water *and broth*[172](javascript:footNote('T600008/note172.html')) are the same, yet that is not true. Meat water consists in cutting the meat fine, and boiling it, bruising it and squeezing and extracting the juice therefrom: it is generally known what


---

p.97






the broth of meat is ... (?) Do not give soup of cabbage or peas in this fever if there be flux.


#### 25


Two remedies are ordered here, called **ordeatum** and **avenatum**; one made from barley and one from oats. To make **ordeatum**, take the husks off the barley, and wash it well in frequent changes of water, and boil it as long as you would boil beef.[173](javascript:footNote('T600008/note173.html')) Then bruise it well in a mortar, and add almond milk to it, strain it through a cloth, and boil till it begins to thicken; it is improved by boiling meat with it. In the same way **avenatum**[174](javascript:footNote('T600008/note174.html')) *proper is made, the which is naught* but a kind of pottage, of oatmeal *along with* water and meat, and that forms the gruel that *the English* make with gross oatmeal and water and meat, which is a good thin pottage with ale. *It is good for* hectic patients and people *going into a decline*, and for almost all people.


#### 26


*An electuary*[175](javascript:footNote('T600008/note175.html')) is good in these fevers, early, *called violet sugar* [*...*] rose sugar, *given* after a meal and made as follows: [rx ] 1 lb. of sugar; drachm i[176](javascript:footNote('T600008/note176.html')) of pearls; and drachm i t of white and red coral; make a powder of them, and mix with sugar of roses, to be taken with rosewater. Give this electuary at bedward[177](javascript:footNote('T600008/note177.html')) and on rising: [rx ] ounce ii of each of these: **diatragacanthum frigidum**, **diapenidii frigidi** without cinnamon. Mix them well and drink with barley water. If putrid fever[178](javascript:footNote('T600008/note178.html')) be combined with hectica, rosata novella is good [*...*] in the first form of the combination of putrida


---

p.99






with hectica. If possible let a little blood then, because we[179](javascript:footNote('T600008/note179.html')) ought to check the putrid matter first, as it kills a man quickest, and here **diatriosant:** and **diarrhodon abatis** are advantageous.


#### 27


Understand, unless putrida be in conjunction, or there be an imposthume on the intestines, or the sick man have a cough, a bath is good in this fever twice a day, after the food is digested, if he be used to it;[180](javascript:footNote('T600008/note180.html')) but it should only be tepid, because heat resolves and heats and purges, and therefore it is no use in this non-material[181](javascript:footNote('T600008/note181.html')) fever. He should also not be *in the bath* so long that he sweat[182](javascript:footNote('T600008/note182.html')) therein, but cold water should be poured on him at once, or else sprinkled, so that it hurt him not. A bath of tepid or hot water does not avail them for the purging of their bodies, so that they might endure cold[183](javascript:footNote('T600008/note183.html')) *water* at the end of the bath, according to **Galen**.


#### 28


**Averroes** says cold water is best therein, if he be able to endure it with equanimity, and rub the extremities and the spinal column afterwards with oils, compounded of oil of violets, and water rue, or of roses or some styptic thing in which is some cold,[184](javascript:footNote('T600008/note184.html')) in order to retain the moisture of the bath inside. Let him be dried then with a soft linen cloth, and put to bed with cloths[185](javascript:footNote('T600008/note185.html')) round him; then give milk as before mentioned. When that is digested, bathe him again as before mentioned. When that is digested, bathe him again as before, and put him and put him in an empty[186](javascript:footNote('T600008/note186.html')) dwelling, lonely and sweet-smelling, in which is little air, and thereafter open the windows to cool the air,


---

p.101






for the air should be tempered[187](javascript:footNote('T600008/note187.html')) where he has no clothes on, while he goes into the bath. Let there be a cold bright cloth in sight of his bed, on which is sprinkled rose water, after the bath and the unguents. Have a vessel full of cold water in which are sally leaves and rose and vine leaves near to his bed, and spread sally leaves round it, gathered before sunrise, whereon rose water[188](javascript:footNote('T600008/note188.html')) is sprinkled, and let him sleep after eating. If the weather be hot,[189](javascript:footNote('T600008/note189.html')) let the air be cooled by water violently shaken, raised up in a vessel, and let down again into a vessel that is low.


#### 29


If it come from the stomach, or the chest, or the kidneys, or the intestine called **jejunum**, the evil complexion spreads throughout the whole body. If from the heart, give cold cordials, such as roses, camphor, flowers of water rue, bone of stag's heart and the like. If it be caused by an imposthume, let it be cured *as before mentioned*.[190](javascript:footNote('T600008/note190.html')) If from heat of the liver, or from the midriff, the lungs, the womb, or the intestine called colon, or the veins called meseraie, then allay the matter whence it came first.


#### 30


The following is the most appropriate and best bath here, a bath of warm milk,[191](javascript:footNote('T600008/note191.html')) and as it would be too costly for poor people, let them boil three gallons, or four of new milk, soak a sheet folded in three therein, and before it begins to cool, put it about the sick man. Have milk slightly heated, at hand[192](javascript:footNote('T600008/note192.html')) to pour on him for fear of his being injured by cold, and dry him


---

p.103






thereafter with a fine linen cloth. This is good for everyone who is in consumption, unless[193](javascript:footNote('T600008/note193.html')) fever or an imposthume be present.


#### 31


Note, the cold of milk does less harm to the body than the cold of water, though cold of any kind is harmful to sufferers from hectic fever, according to **Galen**, on account of their leanness; and as he says, no cold thing gives help without harm;[194](javascript:footNote('T600008/note194.html')) therefore give cold things in the best order possible. Item take a large number of yolks of eggs, mix them well with new milk, and make a bath of them; it is not necessary to rub in unguents after this, as the yolks keep in the moisture of the milk.


#### 32


The following plasters[195](javascript:footNote('T600008/note195.html')) are good for the stomach, the liver, and the warm dry members: rose, mastych, sanders, and wax for the stomach; hepatica, mastych, **lignum aloes**, and calcined ivory[196](javascript:footNote('T600008/note196.html')) for the liver. These are the juices[197](javascript:footNote('T600008/note197.html')) that are good for them: juice of houseleek, liverwort, sorrel, coltsfoot, lettuce, endive, **plantago**, and flour of barley meal; or put the substance of these in a linen cloth, and apply them to the part in which is heat, and it should be *frequently*[198](javascript:footNote('T600008/note198.html')) changed; and if you do not this (frequent changing), it will do harm.


#### 33


This is the nourishment (diet) that is ordered them: milk to be drunk as aforesaid; a bath to be taken after digesting food, and let him eat a little easily-digested food with moist substance[199](javascript:footNote('T600008/note199.html')). On digesting this he should bathe, and be anointed as above.




---

p.105


#### 34


These are the meats best in this case: chickens[200](javascript:footNote('T600008/note200.html')) fattened on wheat, and yolks of eggs are good here, and a custard[201](javascript:footNote('T600008/note201.html')) made of them with a little wine. Capons are good fattened on wheat; partridges, and pheasants,[202](javascript:footNote('T600008/note202.html')) and lean pork. **Averroes** says, the latter is most nourishing, but only give a little of it, well pounded and well chewed.[203](javascript:footNote('T600008/note203.html')) Give especially the meat of the back, a little of which is good along with bread.


#### 35


Item take barley or wheat, and boil it well in milk, or water, with many snails,[204](javascript:footNote('T600008/note204.html')) and feed the hens thereon; *in this way they* are good for lean people, as they fatten them. Item fatten a capon on the flowers of a tree that bears fruit in the first month[205](javascript:footNote('T600008/note205.html')) of summer; the which is good for sufferers from hectica. Item make small portions[206](javascript:footNote('T600008/note206.html')) of figs, and give to the hens to fatten them. Piglings[207](javascript:footNote('T600008/note207.html')) and flesh of kids roasted, can also be given in this sickness, on taking off the hard, outer parts (crackling) that are on them; and flesh of lambs and kids[208](javascript:footNote('T600008/note208.html')) is good here; and I do not say to give meat to them, except that which has been mentioned hitherto.


#### 36


These are the herbs that are good for their pottage: liverwort, mallows, violets, lettuce, patience, but lettuce is specially good for sufferers from hectic fever, as they need it to make them sleep. As their powers are weak and they cannot eat much at a time, their food should be divided, and a little given often. The fish that is best for them is freshwater fish, on which are scales.




---

p.107


#### 37


The best bread for them is bread of barley and wheat mixed;[209](javascript:footNote('T600008/note209.html')) and add a little salt to it, and wash it in water or wine before it is eaten. Let it not be so new that it be hot.[210](javascript:footNote('T600008/note210.html')) It may be soaked in new milk, in which way it forms a good food, and very fattening. Let him not eat marrow or brains.[211](javascript:footNote('T600008/note211.html')) Nevertheless an ointment may be made and rubbed on the chest and joints of marrow of deer and calves, mixed with unsalted butter, fresh pig's lard, and that of hens; and add a little wax and gum arabic. This is very good, if hectic fever come from the midriff.[212](javascript:footNote('T600008/note212.html'))


#### 38


These are the symptoms thereof, delirium (want of sense[213](javascript:footNote('T600008/note213.html'))) and shortness of breath; for in the delirium that is caused by the midriff, the breathing is short and quick, and in that that comes from the brain there is no great harm to the breathing, but rather to the eyes and nose, and drops of blood drip from them. **Galen** says, if this fever come from the midriff, the breathing[214](javascript:footNote('T600008/note214.html')) is now too short, now too long, and now too slow, and sometimes when he breathes in[215](javascript:footNote('T600008/note215.html')) the air, he has to draw in twice and do the same to expel it.


#### 39


Item in this sickness the following are good: maidenhair, mint, **pollitricum**, together with liquorice and mallow flowers, also roses along with the large, cold seeds, and sugar. Rub salt and vinegar to his veins and feet, and wash them with sally and vine leaves. A laxative clyster is good in hectic fever, of violet oil and salt. Rub violet oil round the midriff,


---

p.109






and soak a linen cloth in cold juices and lay it thereon. It is not meet to cool that part too much, lest it provoke the cough. Put lettuce, poppy and coriander in their food. Cold air, *produced* naturally or artificially, is useful here, and is all but sufficient cure. In all hectic fevers where a man cannot take food, it is good to give a clyster made of cullis of chickens and capons, together with beef-tea, as[216](javascript:footNote('T600008/note216.html')) the attractive force draws away from the navel. This is clear in pregnancy; that is, it draws back (?) in the intestine called jejunum, for the clyster goes so far, and not beyond, except by violence.


#### 40


Concerning the accidents[217](javascript:footNote('T600008/note217.html')) that come in this fever, understand that flux is dangerous in this case, as also in phthisis and dropsy. If it occur, give sugar of roses, red coral and

pearls, together with mastych. Item take two handfuls of each of the following: **plantago**, ribwort, and shepherd's purse; ouncei of roses, and 3 handfuls of lettuce, and parched barley and make a drink thereof *with water wherein* is quenched red hot iron, together with sugar. Item *it is possible* to give *a pottage* of ram's flesh, and almond milk, and **plantago**, and liverwort, and cabbage leaves *boiled in water* and squeezed out.


#### 41


Item take small white pullets, for *those are the coldest*, and feed them on barley *boiled in sumach* and violets: let him drink the broth of *these birds and eat their substance*.[218](javascript:footNote('T600008/note218.html')) Item if the sick man suffer from heat *or burning along with* the flux, let him take pills made of camphor along


---

p.111






with rose water, or **plantago**[219](javascript:footNote('T600008/note219.html')), as follows: [rx ] drachm i burnt ivory; drachm i of armenian bole; drachm iii of roses, and drachm ii of coltsfoot; and make pills of them, with poppy juice, or that of **plantago**; add drachm ii of camphor, and red coral. Item in this flux, milk is good, wherein are quenched river stones, heated red-hot two or three times, unless putrid fever be present; nevertheless, sufferers from hectic fever ought only to take milk before food. It is meet for them to use it from the beginning of spring to the end of summer, and *though* it is good for them at other times, *yet* not as good as then.


#### 42


Here it is to be noted that an astringent bath is good for them, and **Averroes** says it is in the decrease of flux that it avails, and not in the static condition, as it would draw the matter of the disease all over the body. This bath is good here: take young cats[220](javascript:footNote('T600008/note220.html')), cut their entrails out, and put their extremities with cold wet herbs, such as rose, willow, and vine leaves, and lettuce. Add **plantago** by reason of the flux, and ribwort, tartary,[221](javascript:footNote('T600008/note221.html')) and leaves of the pear tree or oak, and boil them *together* in water, and bathe the sick man in it, as often as you wish, since it is not a material sickness, unless an imposthume, or putrid fever, be joined thereto, or raw humours, or corruption.


#### 43


Regarding the hectic fever that comes from old age, following the consumption of the strong close members; note, it is found in old people and cold consumptive people,[222](javascript:footNote('T600008/note222.html')) and dry people and melancholics and young people; and honey and milk avail for the most part. However, **Galen** says honey does great harm to those who have hectic fever resulting


---

p.113






from old age, and he says he saw himself an old man[223](javascript:footNote('T600008/note223.html')) of a hundred years, and the food he would take oftenest was goat's milk, and sometimes he would eat a little bread, and other times he would mix it with honey, and boil it with bread or blackberries or mint.


#### 44


It[224](javascript:footNote('T600008/note224.html')) is asked whether milk is good for old people, and it is certain that it is not; for hot moist things are best for the old. **Galen** says milk is cold, and therefore is not suitabie for them. Item milk is among the foods which corrupt easiest, for it is a susceptible thing; and such is not suitable for old people; and therefore it is found that it is not right to give it to them.


#### 45


There are three substances in *milk*: curds, whey, and butter; and that is not suitable when the strength is weak, as in the case of old people; therefore milk is not good for them. **Galen** is against this in his book concerning the maintaining of health. I say, according to the intellect of **Galen** and his mind, that milk is good for old people, and there have been people who lived a hundred years *on milk* as food; though it is necessary to digest it well in the stomach, without letting it form curds nor turn to windiness nor cause oppilations, hence it is not good for those who have narrow veins naturally unless salt and honey be mixed with it, that it form not curds nor oppilations nor turn to windiness and in this way it is good, for it is easy to digest, and penetrates easily and agrees, though it is not easy to eat anything else after it, till it be digested.


#### 46


Regarding his first reason, when he says milk is cold, I say that there are two cold parts in milk and one hot; namely, the butter, which is more nutritive in that way, than when it is separated from it, for the whey helps *it* to penetrate; and the curd


---

p.115






stimulates the strength when it is not separated, though the danger is that it curdle in the stomach. If this be prevented, it is good, for it is hot as regards the butter, though the other two parts be cold. I say regarding the other two, that they can be saved from corruption by salt after it has been put into the body on digesting it well; for it is not good any other way. This is soon recognised by the weight, the contortions (?) and the like. With regard to the third reason, I say that there are not three substances actually present in milk, but only theoretically and potentially (i.e. in latency); and it is all the better for this, as the whey helps to penetrate before the butter, and clears the passage of urine and faeces; while the curd is present in latency[225](javascript:footNote('T600008/note225.html')), and helps the weak members.


#### 47


Gaddesden says milk is not good for all old people, but only for those who can sleep and digest it well, and who do not feel any pain in the sides,[226](javascript:footNote('T600008/note226.html')) especially the right side; whose veins are wide, and who do not suffer from sour eructations or flatulence after it. Give sweet-tasting milk to them, from an animal pastured in a good meadow.[227](javascript:footNote('T600008/note227.html'))


#### 48


The following herbs are good for them: woodbine, parsley, mallows, endives, smallage, yellow-flag, not kail;[228](javascript:footNote('T600008/note228.html')) and fresh meat is good for them; and they should eat dried figs, ginger and cassia,[229](javascript:footNote('T600008/note229.html')) as these purge them well; kneaded[230](javascript:footNote('T600008/note230.html')) bread,


---

p.117






boiled well with honey or wine, is good for them; also a bath of sweet water and wine, as it moistens them well. Also moderate exercise and sleep, for **Galen** says, they suffer much from want of sleep, hence they should get lettuce, cinnamon, nutmeg, ginger, spikenard, and **lignum aloes**. Wine, new or old, is not good, but only medium wine, and let them drink plenty of it; for **Galen** says, to give wine to youths is naught but adding fire to fire when the fuel is weak[231](javascript:footNote('T600008/note231.html')): and he says to give it in moderation to young folk, but to the old as much as they wish, unless the head and the nerves be weak. Those whose veins are wide should take milk along with honey and salt, and dried figs with nettle seeds the first day: good claret helps them, made from sweet-smelling spices;[232](javascript:footNote('T600008/note232.html')) and let them avoid blood-letting and coition, or too much of the same, or meditation or cogitation,[233](javascript:footNote('T600008/note233.html')) though occasionally anger suits them well, as it heats them; but in moderation. **Galen** says no man ever died of it; and neither depression,[234](javascript:footNote('T600008/note234.html')) nor repression, nor work is good for them, except a little, but instead of the work let them take a bath.


#### 49


If you say wine helps them, therefore milk does not, because preservation is brought about by likes, not by contraries[235](javascript:footNote('T600008/note235.html')); then I say it is proper to preserve healthy people *in health* and rule them by their likes, but old folk are not well except with complaining. **Galen** says they should be called neutral, and therefore they should be kept on moderate things, in which is some heat and some moisture.


#### 50


Item a laxative clyster is good for them, of oil of


---

p.119






violets or common oil, in order that the bowels may be kept relaxed, and if necessary give a little senna, as it is good for the sight. Item if fattening[236](javascript:footNote('T600008/note236.html')) be desired, take pitch and soften it between your fingers beside the fire, and apply it to the sufferer after bathing, and change it often, the which draws the blood to the surface of the skin. The bath that is desired for fattening, should be taken after food, before the digestion is complete, unless the closing of the veins or an imposthume be feared. In that case, let them be rubbed with oil of roses or lilies, and again apply the pitch, and repeat often; otherwise let the body be slapped frequently with little rods,[237](javascript:footNote('T600008/note237.html')) and apply a poultice of pitch; and it is right to do this in order to fatten the members that have gone to wasting: and both the bath and the emplaister should be local. Note that vinegar is not suitable for lean old men to take, nor any acid things, as they reduce flesh. In the same way winelees, which people take often as a laxative, and old people should only take a little, as they are but lights ready for extinguishing.[238](javascript:footNote('T600008/note238.html'))


#### 51


Item **Galen** says, boiled[239](javascript:footNote('T600008/note239.html')) onions are good for them, and garlic, if they be used to it, and make them a sauce of ginger, mustard, and cinnamon, anise, cucumber, mint, parsley, mace, cloves, and the like; or this sauce: mint, parsley, sage, dittany and pellitory; and this is good against cold, and flatulence of the stomach, its weakness, and that of the intestines: if he suffer from hiccup, let him use anetho, and let him hold his breath, and let hot things be applied to the stomach, as for instance,[240](javascript:footNote('T600008/note240.html')) a hot hand, a hot pillow, or a hot plate [*...*].




---

p.121


[241](javascript:footNote('T600008/note241.html'))
D. Cardiaca Passio etc.
-----------------------


#### 1


Cardiaca is a tremulous movement of the heart, praeter naturam which is caused by fear, or compression, or depression.[242](javascript:footNote('T600008/note242.html')) The cardiaca that is called syncope is a movement[243](javascript:footNote('T600008/note243.html')) whereby motion and sensation are removed from the body for the greater part, through weakness of the heart; and syncope is synonymous with little death.


#### 2


There are two causes of cardiaca, an internal, and an external. The following are the external causes: excess of heat that comes suddenly, or excess of cold, or excessive weakness of nature, such as excess of sweat; a bath made of rotten wood[244](javascript:footNote('T600008/note244.html')) as **Galen** says, and everything that causes nature to collapse suddenly; coitus superfluus, accidents of the soul, and everything that disperses the heat suddenly from the heart, and drives unnatural heat in suddenly to it. Poison, on being taken, has the same effect, and the bite of a poisonous reptile,[245](javascript:footNote('T600008/note245.html')) and everything that weakens the heart and its force; worms, and excess of food and drink; pestilential air, and bad time of plague, intercourse with a woman suffering from lepra, and too much meditation.[246](javascript:footNote('T600008/note246.html'))


#### 3


These are the internal causes:[247](javascript:footNote('T600008/note247.html')) diseases which have affinity


---

p.123






with the medial members, such as the heart; and therefore cardiaca comes from diseases of the brain, such as the falling sickness and apoplexy. It also comes from diseases of the stomach, such as distension and exhaustion, and stomach ache, for **Galen** says, the mouth of the stomach is more sensitive than any other member; and colica and iliaca have the same result. The same is true of every flux, whether it be diarrhoea; *haemorrhage, either* haemorrhoidal or catamenial; or sweat, if it be excessive.


#### 4


Item the same effect is caused by anything that drives bad vapour to the heart, such as worms;[248](javascript:footNote('T600008/note248.html')) matrix in qua retinentur menstrua corrupta; *corrupt humours* in the liver, or the spleen; and it is produced by the clogging of the pores and the passages; through *excessive* heat of the heart, and thinness, or heat, or cold of the humours; and through excessive pains of the teeth, the head, or any other part of the body; or through ulcers, imposthumes and pus; and because of sickness that comes from[249](javascript:footNote('T600008/note249.html')) aches of the teeth, or nerves.


#### 5


**Galen** gives manifest causes for this disease, such as diarrhoea, haemorrhage, weakness, hectic fever, and long sickness, for then the weakness is great and consumes the spirits, as those recovering from a long sickness have but little blood and heat and spirit in them, and natural heat. Therefore the heart is weak, and when a burden is put on anything weak, it trembles suddenly, and is very unsteady (?)[250](javascript:footNote('T600008/note250.html')) because of it.


#### 6


For **Avicenna** says that the spirit is the root and the heart the branch, and when the fundament is injured, every instrument that comes from it is injured; but there is a


---

p.125






doubt, is it the spirit that is the root of the heart? It has been affirmed that it is not, for the spirit is engendered in the heart.


#### 7


**Avicenna** says the heart is the prime (earliest)[251](javascript:footNote('T600008/note251.html')) thing in the body, and the spirit whence it comes; therefore it is the heart that is the root, and the spirit the branch. Item the heart can be, although the spirit is not,[252](javascript:footNote('T600008/note252.html')) prior to the existence of the spirit, for it is said in Prognostica that it is into the heart life comes first, and goes from it last; therefore the heart is the root of the spirit.


#### 8


**Avicenna** is against this, when he says the spirit is root, and the heartis branch. **Galen** is against this in Prognostica, where he says the body[253](javascript:footNote('T600008/note253.html')) is compounded of the carrier, and the carried; the spirit or the force is the carrier, and the body the carried; and therefore the spirit is the root.


#### 9


We say in this connection, that ‘spirit’ can be understood in two ways, one with regard to the natural heat, and the other with regard to the vapour that is subtler than it. For there are two vapours in the heart: the denser vapour, that is[254](javascript:footNote('T600008/note254.html')) the natural heat, and the vapour that is subtler and hotter, which is the spirit, and it is of this that **Galen** speaks in Prognostica.


#### 10


I say, as **Isidorus** says, that there are two lives: the life called nutritive, and the life called sensory.[255](javascript:footNote('T600008/note255.html')) Taking the spirit as the life force, it is said that it is the first instrument of the soul. And thus **Galen** says that *the body* consists of that which carries, and that which is carried. The force is the carrier or


---

p.127






the active spirit along with the force which it carries; therefore I say, the body is heavier dead than living, because of the loss of the spirit that carries and lightens it. In the same way **Galen** says there is erective force in the body of a man standing, for if there were not, he would fall. This is clear in *the case of* weak people, for through the weakness of their erective force, they cannot remain standing. He says in like

wise, of the bird which when flying through the air lingers hovering *by virtue of* that spirit, for **Avicenna** says, the spirit is the carrier of the force. Having regard to these facts, we say the spirit maintains and is root, and the heart is branch.


#### 11


Heart is taken in two ways: one improperly,[256](javascript:footNote('T600008/note256.html')) of the lump of flesh from which the heart proper is generated. The shape of this mass is as is the shape of a *cone*, a little before the soul is put in. Heart is taken properly after it has been formed in such wise, on the addition of the soul, and according to the former mode the heart is prior quoad generari to the other members of the body; but not prior quoad generatum esse, by priority of time but only by priority of nature. However, it is prior by priority of time to those other members that are required for the well-being of the body such as arms and legs.[257](javascript:footNote('T600008/note257.html'))




---

p.129


#### 11


Or it could be said, the force is in the spirit as *in the* root,[258](javascript:footNote('T600008/note258.html')) and in the body of the heart as *in the* branch, and therefore the heart is a branch of the force, for it is from the force heart is said to be heart. *But spirit is spirit* as long as that[259](javascript:footNote('T600008/note259.html')) vapour lasts which is called the spirit according to **Galen**, that is, the temperate vapour, and this *statement* is not amiss;[260](javascript:footNote('T600008/note260.html')) but taking the spirit as brother to the natural heat, as **Damascenus** says, it only lives as long as the man lives, for it then grows cold, and the natural heat corrupts, and putrescent vapour takes its place. Or I say, the spirit is the root which forms the heart and the heart is comforting branch, for when it (the spirit) helps the heart, the heart helps the members.


#### 12


I say now as a first reply,[261](javascript:footNote('T600008/note261.html')) that this spirit is generated in the heart, however it (the spirit) is the co-formative[262](javascript:footNote('T600008/note262.html')) root of the instrument (i.e. the heart) coming with it (i.e. the spirit) in which it works, for it (the spirit) is generated in *another* place *than* the heart, if we mean to speak of the secondary and accidental generation, for instance the animal spirit in the head; for that takes to itself there the power on account of which it is called ‘animal’ by which it sets in motion the animal forces which are called sensation and movement.


#### 13


I reply secondly,[263](javascript:footNote('T600008/note263.html')) that it is into the heart that life comes soonest of all the constant members, although not of the fluid members, such as the spirit and the humours, according to **Averroes**. Or else I say they could come together, that is


---

p.131






to say, that the heart is prior as regards sovereignty, and that the spirit is *prior* as instrument, and is the root of the instruments[264](javascript:footNote('T600008/note264.html')) of the heart. If it be said that it is the work[265](javascript:footNote('T600008/note265.html')) of nourishing that is first used (?), and therefore the liver is prior, I answer that the liver is (merely) the first to exercise (?) the first (i.e. primary) function, and not (first) by priority of universal dominance[266](javascript:footNote('T600008/note266.html')) and dignity, for there the heart is prior, nevertheless as regards the priority of partial dominance,[267](javascript:footNote('T600008/note267.html')) the liver, the brain and the testicles are prior; that is, they are principal as regards dominance and superiority of office. There are many principal members, such as the stomach, and the lungs, for **Galen** says there are seven principal members, according to the number of the seven planets.


#### 14


The external causes are known by the patients own indications. If cardiaca come from the defect[268](javascript:footNote('T600008/note268.html')) of another member, it is recognised by that sickness and its signs. If it come from the blood,[269](javascript:footNote('T600008/note269.html')) it will be recognised by those things, that are natural, unnatural or contrary to nature. If the urine be red and thick, the pulse undulating, the face red, and there be heat round the neck,[270](javascript:footNote('T600008/note270.html')) and the patient suffer extreme thirst, and he be young, liberal,[271](javascript:footNote('T600008/note271.html')) and jolly, and favour foods that increase sanguine humour, then it is right to say the cardiaca comes from sanguine humour. If the urine be thin and yellow, the pulse rapid, accompanied by great heat, and the patient be used to hard work and running, and foods that engender


---

p.133






choler, then it is right to say the cardiaca comes from that humour.


#### 15


If it come from phlegmatic humour, the urine will be thick, scant, *the pulse* irregular,[272](javascript:footNote('T600008/note272.html')) and the patient somnolent, and if he be young, and it be winter time, the phlegmatic fluids will be seen to go to the heart, preventing its natural movement, and therefore it beats in an irregular and tremulous *manner*.


#### 16


If the cardiaca come from melancholic humour, and the season be autumn, the patient will be low-spirited[273](javascript:footNote('T600008/note273.html')) and timorous, and it is not surprising that melancholics be fainthearted, for they bear the cause of fear in them, according to **Galen**; therefore it is seen to be caused by the melancholic vapours invading the heart. For **Galen** says the heart is noble[274](javascript:footNote('T600008/note274.html')) and deems it degrading to endure those loathsome vapours, and therefore it beats irregularly; and there is trembling in the head,[275](javascript:footNote('T600008/note275.html')) the hands and the feet whenever the force cannot control the matter or the member,[276](javascript:footNote('T600008/note276.html')) for it is a compound motion, as opposed to natural motion, for a limb to tremble.


#### 17


If the cardiaca come from worms, it is worse before food than after, for whenever the patient begins to take food, the worms flee up before it. If it come from inanition, it is worse before food than after, and if from repletion it is worse after food. If it come from sudden flatulence, it will leave him suddenly; and if from heat, the pulse and the breathing are rapid and irregular; and *if from cold*,[277](javascript:footNote('T600008/note277.html')) the breathing is slow and irregular.




---

p.135


#### 18


The following are the signs of the weakness of the heart, called syncope. The patient will have a slow, uneven pulse; the colour of the face changing; the eyes closed as if for sleep; and sweat round the neck. On seeing him thus, you may say the weakness called syncope is at hand.


#### 19


There are three signs of the weakness called syncope, prognostica, demonstrativa and memorativa. These form the prognosis: trembling of the heart, the colour of the face changing to an unnatural hue, the pulse fluctuating to slowness, and cold of the extremities. These are the demonstrative symptoms of syncope: want of sensation and motion, and the hue of the face as of one dead. These are the symptoms as to memory: the things which recall and signify the internal and external causes already mentioned. If syncope come suddenly without external or internal cause, that is a sign then that it is caused by diseases proper to the heart itself, and this form is bad and is fatal.[278](javascript:footNote('T600008/note278.html')) The patient should be asked if he feel density or rarity of the heart, or heat or cold, and the causes can be recognised therefrom. If it come from poison, *it is recognised by* a bad taste in the mouth, and by other symptoms of poison.[279](javascript:footNote('T600008/note279.html'))


#### 20


If trembling of the heart continue long in this disease, it signifies death.[280](javascript:footNote('T600008/note280.html')) Item if a man suffer from continued tremor cordis in this illness, and syncope come suddenly, bleed him (?). When the evil complexion is excessive, it weakens the force, and the weakened force induces tremor, and tremor causes syncope, and syncope causes death.


#### 21


Item if a man suffer prolonged syncope, and the hue of the face turn to the colour of ashes or green, or black, that is a sign of sudden death. Item when anyone has syncope,


---

p.137






if powder be put in (up) his nose to make him sneeze, and he does not sneeze, it is a sign that there is no manner of cure for him.


#### 22


Item whether the imposthume of the heart be big or small, if it be big or if it be small, if it be cold or hot.[281](javascript:footNote('T600008/note281.html')) If it be hot, it kills on the first day; if cold, on the second day; if small like a pimple, on the fourth day it causes nose-bleeding and kills.[282](javascript:footNote('T600008/note282.html'))



#### 23


Item accidental mental pain comes to the heart, weakening it,[283](javascript:footNote('T600008/note283.html')) such as depression, worry (mental oppression) or anger; but physical pain comes to it less; and if it come, he will not endure it long, for death intervenes before pain is confirmed in the heart.


#### 24


Item if there be a wound in the heart, look whether it be in the right half or the left. If in the right half, whether it be big or small. If it is big, it kills forthwith; if it is small, it kills the first day. If in the left half, it kills the first day, or whatever time it comes, whether it be big or small. For **Galen** says, the split that is made in the heart is deadly undoubtedly; but not necessarily *so* a gash in the other organs, unless it be big; and he says (also), a split is not worse in the other organs, such as the lungs, for they are always in motion.[284](javascript:footNote('T600008/note284.html'))


#### 25


Item **Avicenna** says, the heart cannot suffer injury or imposthume, and he[285](javascript:footNote('T600008/note285.html')) says in the book De Animalibus, that the heart cannot endure heavy sickness. He


---

p.139






says on the other hand, the heart suffers syncope, i.e. ‘little death’, and it suffers imposthume, according to the reasoning of **Avicenna**, which is, that an imposthume can exist in every member; as everything that can be increased naturally by taking nutriment to itself,[286](javascript:footNote('T600008/note286.html')) can be increased unnaturally by excess of nourishment.


#### 26


I say that the heart endures serious disease often, that is, it suffers it a short time, but not for long, as do the other members, for the heart does not suffer a heavy illness, except from a slight cause.[287](javascript:footNote('T600008/note287.html')) I say also, an imposthume can be on the heart, but it does not suffer it to be confirmed therein, for death comes without delay before the static period; and therefore, I say that pain seizes the heart for a time, but constant pain does not seize it; or it could be said that the heart suffers pain through ‘sympathy’ with the other members, and the union (?) therewith, and not from its own proper disease.[288](javascript:footNote('T600008/note288.html')) It can be said that the heart does not contract an imposthume in its own substance, for if it did, its own function would be impeded, that is, life, and death would come. For **Avicenna** says, the heart contributes to every member, and does not receive from them.[289](javascript:footNote('T600008/note289.html'))


#### 27


Much is needed for the cure of this case. The first thing, is to comfort the heart, and then to digest the matter, then its evacuation, thereafter dieting and then particular treatment at the time of the paroxysm.




---

p.141


#### 28


As to the first of these, understand that sweet-smelling things are meet in every case of **tremor cordis**. If the cause be hot, cold sweet-smelling things should be given, along with a few hot things: so that they may be the more penetrating. If the cause be cold, hot sweet-smelling things should be given, along with a few cold aromatics; unless the cause be too strong,[290](javascript:footNote('T600008/note290.html')) for in that case only contrary things should be given.


#### 29


There are many [*...*] simples that are required for relieving the heart, and many compound things, and there are hot simples and cold simples and medium compounds.[291](javascript:footNote('T600008/note291.html')) The following are the hot simples that relieve the heart: amber, i.e. the sperm of the whale, and storax, and calamint, **lignum aloes**, nutmeg, cinnamon, cloves, sweet-smelling wine, elecampane, saffron, **melissa**, mace and setwall.


#### 30


The following are the cold simple cordials: rose, nenuphar, camphor, sorrel, vinegar, rose water, and coriander, sweet pears, peony,[292](javascript:footNote('T600008/note292.html')) and sour milk, tisane, violets, coral, dandelion,[293](javascript:footNote('T600008/note293.html')) camphor, burnt ivory, tamarind, and silver.


#### 31


The following are the temperate cordials: pure gold, and borage flowers, provided they make for heat,[294](javascript:footNote('T600008/note294.html')) also bugloss and its juice. The following are the temperate cordials, verging

towards cold:[295](javascript:footNote('T600008/note295.html')) ivory turnings, bone of stag's heart and burnt silk,[296](javascript:footNote('T600008/note296.html')) although they incline to heat and dryness: they *lit. it*


---

p.143






can be taken thus, or raw; they lighten the sight if they are rubbed on the eyes, and refresh the memory, therefore it comforts the animal spirit, and the natural spirit also, as it fattens the body, and the life spirit, according to its property, as it illumines it.


#### 32


These things are good in those two cases: coral, pure silver,[297](javascript:footNote('T600008/note297.html')) pearls, borage, bugloss, saffron, burnt ivory, **melissa**, **lingua avis**, spikenard, and **lignum aloes**. Of compound things, there are cold and hot; the following are the cold composites: syrup of roses, and of violets, and nenuphar; **diatrionsantalon**; sugar of roses, and of violets; and **diadragacanthum frigidum**. The following are the hot compound things: **diamargariton**, **mithridatum**, and **rosata novilla**. The following are the temperate composites: **diaboraginatum**,[298](javascript:footNote('T600008/note298.html')) **diarrhodon abatis**.


#### 33


Give him my own electuary, [rx ] drachm i ½ of cinnamon, and drachm i of each of these: spikenard, **lignum aloes**, sanders, anise, endive; drachm ½ of each of these: red roses, gariofil, cummin, and red sanders; a scruple of each of these: **cardamomum**, **spodium**, *i.e.* burnt ivory; drachm ½ of each of these: **storax**, calamint, borage flowers, bone of stag's heart, unbored pearls; and 1 lb. of sugar. Make this with two parts of honey and rose water and the third part of water of borage; and it is good in every weakness of the heart, whatever time it occurs;[299](javascript:footNote('T600008/note299.html')) and I have often proved its goodness myself.


#### 34


Item in (cases of) weakness of the heart, drachm ii of juice of bugloss[300](javascript:footNote('T600008/note300.html')) is good regularly if the cause be cold; and it improves it to add gariofles. Item against syncope and palpitation of the heart give drachm i of gold filings; and drachm iv of these: been albi, and been rubri; drachmiii of red and white coral; drachm i of


---

p.145






pierced pearls; drachm ½ of bone of stag's heart; make a powder and use in food and drink. I do not know of a better cure than it for diseases of the heart, and it is called ‘Golden Powder’; and it is not known how often it has been approved in this case(?).[301](javascript:footNote('T600008/note301.html'))


#### 35


Item **lignum aloes** is good, and good sweet-smelling wine, wherein **lignum aloes** is steeped for a time, and it should be given to drink in **tremor cordis** and syncope. The sign of trembling cardiaca is to put the hand on the left breast; and if there be tremor, then it is trembling cardiaca; and if not, it is syncope, which is called ‘little death’. Item bone of stag's heart is good along with good wine, in which has been put water of roses and bugloss,

[302](javascript:footNote('T600008/note302.html')) and it avails in every kind of cardiaca, for it purges melancholy from the pericardium, and so comforts the heart.


#### 36


Understand that a thing is said to comfort the force in five ways.[303](javascript:footNote('T600008/note303.html')) One by strengthening the spirits, and restoring them, as do sweet-smelling things. Another way by restoring the humours and strengthening them, as do wine and easily digestible foods. According to this, bread[304](javascript:footNote('T600008/note304.html')) soaked in wine or capon broth strengthens the force through nourishment. Another way, by increasing the natural heat, as do hot things. Another way, by contracting and uniting parts of the stomach and the heart moderately, as do styptics. So rose and other styptic things comfort internally and externally as emplaisters, for every force is stronger by union than by division. Another way, by evacuation of excess matter, as do laxatives; and so agaric is a cure that affects the heart, and **myrobalanum**, for


---

p.147






they purge the gross, melancholic, corrupt vapours of black bile from it.[305](javascript:footNote('T600008/note305.html'))


#### 37


So treacle is good against poison, for it helps the heart in fighting against it, that is, against a drink of poison, or the bite of a poisonous reptile[306](javascript:footNote('T600008/note306.html')) or of a mad dog. In the same way tormentil is good, along with a fatty broth or juice of bugloss, against every poison. The force can be comforted aiso by dilating the heart moderately, as does saffron, but it is not proper to give more than a little of it; for **Avicenna** says, if much of it is given, it kills him who takes it, by the excess of mirth it causes and incites.[307](javascript:footNote('T600008/note307.html'))


#### 38


Item let a powder be made of roses, **lignum aloes**, saffron and gariofles; and mix rose water with it, and soak a new linen shirt therein, and let the person who has the disease wear it, for it renews and comforts and vivifies the heart; and this is good for hectics, consumptives, melancholics, and other trist folk.[308](javascript:footNote('T600008/note308.html')) Understand that it is not proper to give a simple medicine in affections of the heart, unless some cordial be given with it.


#### 39


The second thing mentioned is accomplished by the varying of digerents according to the changes of the peccant matter. If sanguine humour be responsible,[309](javascript:footNote('T600008/note309.html')) digest the matter with borage and bugloss, by making a syrup of them, and with syrup of roses, in which is put black sanders and camphor; and take their flowers, and put them in a linen bag. If choler be responsible, digest the matter with syrup of borage, bugloss, violets, and nenuphar to which is added sanders, and roses and camphor, and take the flowers of these herbs [*...*][310](javascript:footNote('T600008/note310.html')) after


---

p.149






putting them into a bag. If phlegm be responsible, digest it by syrup of borage and bugloss, and by oximel of squills,[311](javascript:footNote('T600008/note311.html')) in which is put nutmeg and marjoram; and let him smell[312](javascript:footNote('T600008/note312.html')) an apple made of the sperm of the whale, and **lignum aloes**, and nutmeg. If melancholy be responsible, digest it with syrup of borage and bugloss, and syrup of fumitory, and with oximel of squills in which is **lignum aloes**, and cinnamon, and gariofil.


#### 40


If the matter come from flatulence, the member should be rubbed, and let the sick man take diagalanga, **garyophyllatum**, **diacyminum**; and avoid all things that cause flatulence, such as peas and beans and the like. If the matter come from worms, give ounceiii of juice of elecampane, along with juice of smallage, for these kill the worms, when given with vinegar syrup or sour milk; and cabbage seed and hemp seed do the same, and ounceiii of roots of elecampane kills them.


#### 41


The third of the things we mentioned is fulfilled by laxatives,[313](javascript:footNote('T600008/note313.html')) and things that purge the matter of the disease, and that bring comfort to the heart, according to their property; such are, in the case of sanguine humour: **cassia fistola**, violets, bugloss and borage flowers, to be given along with capon broth or whey of cow's milk after straining. A vein should be opened in this case, provided that it purge the cause,[314](javascript:footNote('T600008/note314.html')) the heat, and the spirit; and though this causes greater weakness than any other purging, according to **Galen**, nevertheless it avails. This is how that should be understood: that purging by blood causes greater weakness than purging by any other medicament.[315](javascript:footNote('T600008/note315.html')) Where he speaks of a vein, this


---

p.151






is how that should be understood: when a vein is let excessively it causes greater weakness than any other purging through medicine, for the vein purges every humour and the heat and the spirit, and no other purging does as much; neither is the spirit purged to the same extent by any other purging, except it be a remedy of poison which brings a man to syncope.[316](javascript:footNote('T600008/note316.html')) It is of the purging that does not speak of (cause?) syncope[317](javascript:footNote('T600008/note317.html')) and does not exhaust the force, that I speak. Indeed, no other purging causes the patient weakness as does letting a vein, because of the suddenness with which the blood comes out, and the heat and the spirit *also*. For in the other purgings, the humours, the heat and the force are purged more gradually, unless the retentive (?) force be impeded,[318](javascript:footNote('T600008/note318.html')) or a laxative be given in excess.


#### 42


If the matter come from choler, let it be purged with violet, tamarind and **cassia fistula**; for **Avicenna** says, tamarind comforts the heart in people of evil complexion with a tendency to choler, for it moderates the heat of choler, and cleanses it by the laxative power it has. In the same way, **myrobalani** comfort the heart when there is depression present or weakness from thinness of the blood. For **Avicenna** says, they cool according to complexion, and according to force they purge the burnt matter therein. Similarly rhubarb comforts the heart by relieving the liver first, as the heart is life to the liver, according to **Aristotle**.[319](javascript:footNote('T600008/note319.html')) The following are the composites that purge choler: violet-sugar, **diaprunus**,[320](javascript:footNote('T600008/note320.html')) **diarhabarbarum**, and electuaries of juice of roses.




---

p.153


#### 43


If the matter come from phlegm, let it be purged by agaric and **turpeth**, along with a little ginger, and give him a drachm or two with sweet-smelling wine. These are the compound things that purge phlegm: **hiera picra** **Galeni**, and ***hiera Logodion***. If the matter come from melancholy, let it be purged with senna and polypody, and of the latter **Avicenna** says it rejoices the heart per accidens by drawing off melancholy[321](javascript:footNote('T600008/note321.html')) from *the brain, the heart* and the whole body, but anise and cummin should be boiled therewith to overcome the flatulence. These are the compound things that purge it: diaboraginatum [*...*][322](javascript:footNote('T600008/note322.html'))


#### 44


The fourth thing mentioned is accomplished by digestible foods, which easily turn to the nature of spirit;[323](javascript:footNote('T600008/note323.html')) and therefore **Avicenna** says, water of meat is good here, as it turns easily to the nature of spirit. And know, according to **Avicenna**, that the force is increased by wine, and subtle foods, and by sweet odour, by joy and tranquillity, and by avoiding depression and anger, and by rejoicing in pleasant things, and by remaining with friends. Therefore **Constantine** says, on the authority of **Galen**, that conversation between lovers and sages removes trouble from people, and from the interior members.[324](javascript:footNote('T600008/note324.html'))


#### 45


Item roasted chickens are good, larded and sprinkled with wine and syrup of roses, the wine to be sweet-smelling.




---

p.155


#### 45


If the cause be cold, let him drink[325](javascript:footNote('T600008/note325.html')) it hot with gariofles; and if hot, let him take it cold; and if he can eat meat [*...*][326](javascript:footNote('T600008/note326.html'))


#### 46


This is the nutriment that is good in the weakness called syncope, if the cause be hot: sour milk, when the butter has been taken off it, cold fish, sugar,[327](javascript:footNote('T600008/note327.html')) ripe (black)berries, good pears, and sweet-smelling apples. If the cause be cold give warm yolks of eggs, and a custard,[328](javascript:footNote('T600008/note328.html')) and meat, and eggs whipped up with milk, and saffron prepared with broth of capon, and beef. Squeeze the soup out of them then, and pour wine over it, the which food is very good.


#### 47


Item roast chickens, partridges, or mutton, or pheasants, and put therein gariofles, and lard, and sprinkle rose water with sweet-smelling wine thereon; let the patient smell it for long; then bruise it well, and put in a linen cloth, and squeeze the juice out of it, heat it, and give to the sick man, and he will get great comfort therefrom.


#### 48


Item give nutritious easily-digested foods to those who suffer from wasting of their flesh (consumptives), and give aromatics by degrees in small quantity; and give these sweet-smelling things upwards[329](javascript:footNote('T600008/note329.html')) to a woman suffering from syncope through **suffocatio matricis**, and give them downwards to the men who suffer from weakness. Give these nutritious and easily-digested foods to those who suffer from wasting of their flesh, and give a little of the sweet-smelling things by


---

p.157






degrees to them who are weakened by[330](javascript:footNote('T600008/note330.html')) *inanition, not by* repletion; for they err who give wine, and sweet-smelling things internally to people suffering from heart-weakness and loss of force through distention; so food should not be given in every weakness called syncope, for there is more need of purging by clysters and vomiting and abstinence, and to cure them by rubbing and by bandaging the extremities.[331](javascript:footNote('T600008/note331.html'))


#### 49


The fifth thing mentioned is fulfilled by sneezing, and by rubbing[332](javascript:footNote('T600008/note332.html')) the extremities, and by sweet-smelling things. Therefore when a man is in a paroxysm of this sickness, let a hen-feather soaked in strong vinegar be put up his nose; to compel him to sneeze, and it will check the paroxysm.


#### 50


Item let rose water, or any other water, be poured suddenly *about his face, the which avails* in the paroxysm, although it does harm thereafter if it remain long on his body, as in the case of syncope caused by crude humours and by fear.[333](javascript:footNote('T600008/note333.html')) For that increases the crudity of the matter and keeps it and the spirit inside, and therefore the water shouid be poured on him suddenly and not be permitted to remain on him. Sometimes the water should be poured on gradually and allowed to remain, as in the case of syncope caused by joy, or by fiux; thereafter he should be made to vomit, and rub the nose[334](javascript:footNote('T600008/note334.html')) and shoulder-blades, and fumigate them, and the belly,[335](javascript:footNote('T600008/note335.html')) according to **Galen**.[336](javascript:footNote('T600008/note336.html')) Cold water avails poured suddenly in this case, because of the shock which excites the heat, but[337](javascript:footNote('T600008/note337.html')) it were better then to excite


---

p.159






it by rubbing and sweet odours. In a cold case, however, resulting from repletion, it is not good[338](javascript:footNote('T600008/note338.html')) to pour the water at first, but at the end, not on account of the complexion, but of the shock it gives. Then let sweet-smelling things be applied in this case,[339](javascript:footNote('T600008/note339.html')) such as sanders, violets, and nenuphar, placed in a linen cloth; but in a cold cause add **lignum aloes** and **laudanum**. If it come from phlegm, give **alipta moschata**, and rub the extremities, and especially when the matter comes from repletion. If the matter come from poison, give tormentil with wine or milk in it, or nuts with figs, and warm juice of milfoil. Put a broad stick between his teeth, and call him loudly by his proper name,[340](javascript:footNote('T600008/note340.html')) and give treacle to him, and **diamargariton** and wine.


#### 51


In the case of trembling cardiaca, rubbing of the extremities and round the heart avails; and let him smell the following:[341](javascript:footNote('T600008/note341.html')) ambergris, and roses, for cold things should be mixed with hot and dry here, so that they may last the longer, also hot things with cold, so that they may penetrate the easier. Let a linen cloth be soaked in rose water and put round the heart,[342](javascript:footNote('T600008/note342.html')) and it will relieve it, and give mace and gariofles to cornfort it. A light bath is good in cardiaca or syncope.


#### 52


If it come from flatulence, it is good to rub the extremities with a hot cloth, and to put reddened[343](javascript:footNote('T600008/note343.html')) oats round the stomach, and use dianthos (?) and diamasum, and let everything


---

p.161






that engenders flatulence be avoided, as peas and beans and hot bread. Hot bread[344](javascript:footNote('T600008/note344.html')) *though* is good on being soaked in wine, for it increases the force and the heat, and preserves a man from poison and from plague etc.




---

p.163


[345](javascript:footNote('T600008/note345.html'))
E. Apostema est, etc.
---------------------


#### 1


**Galen** says an imposthume is the same as a swelling according to the ancients[346](javascript:footNote('T600008/note346.html')) and **nescoid** in Gaelic is the same as **apostema** in Latin; **apostema** is the same as *a tumour after leaving its natural disposition. {Dicitur enim apostema a post & tumor .i. posterius tumor .i. tumor superveniens post dispositionem naturalem.}’’*

[R. A. 943.]

 And therefore it is called tumour, so that it might not be thought that the superfluous fat the body takes to itself because of nourishment of food and drink is imposthume.
#### 2


Another doctor says **apostema** is the same as a swelling beyond nature.[347](javascript:footNote('T600008/note347.html')) **Hali** says **apostema** is a compound sickness, that comes from malice of the complexion, and quantity, and form.[348](javascript:footNote('T600008/note348.html')) **Avicenna** says **apostema** is a compound disease in which is found every kind of sickness, for *a* malicious complexion and composition are therein; and it errs[349](javascript:footNote('T600008/note349.html')) in its position and quantity, because of excess of malice and repletion (and) separating the parts one from another,[350](javascript:footNote('T600008/note350.html')) as an imposthume is never without malice of complexion, and composition, along with matter, i.e. peccant humour.


#### 3


**Constantine** says that this is not true, for he says in the ninth book of Pantechnes that *a hot imposthume arises from malice of complexion, without peccant humour. {... quasdam phlegmonas nasci a mala complexione.}’’*

8 Pantechnes cap. 12 [R. A. 944.]

 I say


---

p.165






in this regard, as does **Galen**, that a *hot* imposthume[351](javascript:footNote('T600008/note351.html')) may be understood in two ways; one of them regarding acute hot imposthumes, that are formed often by sanguine humour, and *the* other, because of excess of heat and burning; and it is thus **Constantine** understands it; for he says, a limb suffers heat and redness in this disease, as in fever.
#### 4


And **Constantine** says on the eighth book of his Pantechnes, that **apostema** is the same as fatness or swelling, that a member suffers on account of excess of humours. And **Galen** says, regarding the fifth section **Hippocrates** wrote, that **apostema** is swelling and fatness beyond nature in bodies;[352](javascript:footNote('T600008/note352.html')) therefore since unnatural swelling can be in every member, so also an imposthume can be in every member. And it is clear, according to **Galen**, that swelling in excess of nature can be in every member, for **Avicenna** says thus: every member that can be increased naturally by taking nourishment to itself, can be increased unnaturally and every member can be increased naturally by taking nourishment, because it is nourished; therefore it can also be increased unnaturally, (and) therefore, an imposthume can be in every member.[353](javascript:footNote('T600008/note353.html'))


#### 5


And **Avicenna** reasons in the same way with regard to the teeth and the bones; and regarding imposthumes of the brain called frenzy accordingly:[354](javascript:footNote('T600008/note354.html')) I grant that imposthumes can be on the brain, but **Serapion** says they can not, for it is a soft, wet, fluid member and so does not suffer matter *to remain*,[355](javascript:footNote('T600008/note355.html')) therefore imposthumes cannot be thereon.


#### 6


To this we answer and say, there remain four things proper for an imposthume to form in a member: the first is the flowing of excess towards the member; the second the member absorbing it; the third its retention there; the


---

p.167






fourth fatness or swelling:[356](javascript:footNote('T600008/note356.html')) and of these the first three can be in the brain, *but* the fourth cannot occur there obviously, i.e. the swelling. Nevertheless I say **Avicenna** allows that imposthumes can be on the brain in its own substance, for it is a tough, earthy[357](javascript:footNote('T600008/note357.html')) member, and therefore it retains the matter of the imposthume; the which is true.


#### 7


Still greater is the doubt as to whether an imposthume can be in the heart, for **Avicenna** says the heart does not suffer imposthume, and **Hali** says a man dies before the pain is confirmed in the heart. And I say with regard to that, that every imposthume is fatal in the substance of the heart, and therefore it does not suffer it to be stabilized therein, that is its stasis, for it is with regard to its stabilizing he says stasis, or the end of its increasing, because a man dies before *he reaches the ‘static’ period*.[358](javascript:footNote('T600008/note358.html'))


#### 8


These are the causes[359](javascript:footNote('T600008/note359.html')) of imposthume: Firstly, matter flowing or being sent from one member to another. Secondly, excess of nourishment collecting in the same member.


#### 9


The first of these is produced by six causes. First, the strength of the member that expels the matter, for **Galen** says, the strong members send their excess to the weak members, and the noble members to the ignoble. Second, the weakness of the evacuatory force in the member that receives the matter. Third, the quantity of the matter. Fourth, the width of the pores. Fifth, the want of nutritive force and *power of*[360](javascript:footNote('T600008/note360.html')) conversion in the member, to which the matter has been sent. Sixth, that the members[361](javascript:footNote('T600008/note361.html')) which receive the matter are subject to the members that put it from them. **Constantine** puts these causes


---

p.169






in the eighth book of Pantechnes, and[362](javascript:footNote('T600008/note362.html')) these two further causes may be added to them:—namely, the movement of the member to which the matter is sent, and its heat. [363](javascript:footNote('T600008/note363.html')) For **Galen** says, it is easier to pour the matter to a member that moves and heats, than to other members; therefore the imposthumes that move and are caused by crisis are oftener formed in the joints, than in *other* places, because of the amount of movement and space *therein*.


#### 10


The cause of imposthumes formed from excess of nutriment gathering in a member,[364](javascript:footNote('T600008/note364.html')) is the want of nutritive force in the member, that cannot digest perfectly the food that comes to it; and the excess matter grows gradually until it fills the member.


#### 11


This is how an imposthume grows in a member when it comes from malice of complexion therein, or through excess that is sent to it from another member, stronger than itself; and it cannot expel or digest in itself: the excess remains *in the member* and forms an imposthume in the following manner; if sanguine humour [365](javascript:footNote('T600008/note365.html')) or any other humour is drawn to the member in such quantity that it fills the veins entirely, then the veins are stout and full, like a vessel, and some of it flows from the pores to the space in the member surrounding it, which it fills, and separates the parts, forming the swelling there that is called imposthume.




---

p.171


#### 12


There are six species of imposthumes in general[366](javascript:footNote('T600008/note366.html')) according to the *matter*[367](javascript:footNote('T600008/note367.html')) from which they are made, i.e. the four humours, wateriness and flatulence. From sanguine humour is formed the imposthume called phlegmon, i.e. great swelling;[368](javascript:footNote('T600008/note368.html')) and so there is a difference between it and the imposthume formed from choler,[369](javascript:footNote('T600008/note369.html')) for in that there is only a little swelling, and it is sharp without being broad. If therefore sanguine humour is strongest, phlegmon is its name, and if phlegm is strongest, a soft imposthume is generated there called zimia.[370](javascript:footNote('T600008/note370.html'))


#### 13


[371](javascript:footNote('T600008/note371.html')) If it be choler; the imposthume engendered is called **erysipelas**. If it be inflammatory melancholy that is strongest, the imposthume called **cancer ulceratus** is formed (at first?). If acid melancholic humour is strongest therein, then is formed the imposthume called **sclerosis**, that is a hard imposthume. If sanguine humour is strongest, the imposthume called carbuncle is formed, for it reddens like a coal of fire, the which is a compound imposthume.


#### 14


Note that there are imposthumes *both* compound and simple, *the latter* from one humour only. **Avicenna** says: is the blood thick or thin? If it be thick, it forms an imposthume *phlegmon*, that affects the flesh and the skin together, accompanied by throbbing; if it be thin, it forms an imposthume that affects the skin only, without throbbing, and **spina** is its name. If it be formed from sanguine humour and choler, and sanguine humour be the stronger, there is


---

p.173






formed the imposthume called phlegmon, or **erysipelas**. If choler, then is formed that called **erysipelas phlegmonides**.[372](javascript:footNote('T600008/note372.html'))


#### 15


**Avicenna** also says that *hot* imposthumes are formed *from choler*[373](javascript:footNote('T600008/note373.html')) and that there is thin choler, thinner choler, and very thin choler. From thin choler,[374](javascript:footNote('T600008/note374.html')) the imposthume called **formica corrosiva** is formed; from thinner choler, that called **formica miliaris**, the which is more in the flesh than in the skin, and is like a big ant. From very thin choler is formed the imposthume called **formica deambulativa**.


#### 16


Let us speak now of the cold imposthumes, and of the four things of which they are formed, i.e. of phlegm, and melancholy, flatulence, and wateriness. In the imposthumes formed by phlegm, some are made of thin phlegm along with a little choler, of such are (the) pimples that grow in the night, and they are called ‘daughters of the night’.[375](javascript:footNote('T600008/note375.html')) Others are formed of gross phlegm,[376](javascript:footNote('T600008/note376.html')) such as neck boils, and imposthumes of the armpit, and the groin, and of this kind are warts. Of medium phlegmatic humour is formed a soft imposthume, without pain.[377](javascript:footNote('T600008/note377.html'))


#### 17


From melancholic humour is formed **sclerosis**, that is a hard imposthume, and cancer, that is a canker, and glandules, that is imposthumes which are like acorns and which separate themselves from the member and are wrapped up in


---

p.175






skin;[378](javascript:footNote('T600008/note378.html')) and **scrophulae**[379](javascript:footNote('T600008/note379.html')) — *they also* adhere to the skin, and not to the member. The two other imposthumes mentioned, cancer and **sclerosis**, stabilize themselves in the substance of the member, and there is a difference between them, for **sclerosis** remains in the member without pain and hinders sensation,[380](javascript:footNote('T600008/note380.html')) *while cancer is mobile and painful, and does not hinder sensation* unless it be *there* too long, and kill the member.


#### 18


These are the watery imposthumes, dropsy, hernia (i.e. the dipping), and sometimes there is a watery imposthume on the **peritoneum**.[381](javascript:footNote('T600008/note381.html'))


#### 19


These are the imposthumes formed from windiness, that is one[382](javascript:footNote('T600008/note382.html')) in which there is a swelling, as there were breath *in it*, and the flesh and the skin separate one from the other, and when it is seized, it so to speak gives with you: another imposthume called cachexy has windiness in it, in the substance of the member and when it is seized it does not give with you, but disperses through the pores.


#### 20


And know ye, that the imposthumes formed from the four humours have four seasons, inception, increase, stasis, and decrease.[383](javascript:footNote('T600008/note383.html')) Inception, when the matter begins to move to the surface of the member and begins to increase. Increase, when it enlarges and swells. Stasis, when it remains and does not increase any more. Decrease, when it begins to diminish and ripen, and then turns to pus, or disperses without sensation, or becomes hard, for these are the four[384](javascript:footNote('T600008/note384.html')) ways in which imposthumes finish.




---

p.177


#### 21


These are the signs whereby is recognised the matter from which the imposthumes arise; colour and pain and accompanying fever, speed or slowness of movement, the feel[385](javascript:footNote('T600008/note385.html')) when touched by finger or palm, as **Hali** says.


#### 22


These are the signs of the imposthumes that are formed from sanguine humour, *redness*[386](javascript:footNote('T600008/note386.html')) and swelling round them, fulness of the veins, throbbing, flaccidity, and leaping. **Averroes** says the signs are red colour along with extreme heat, and great pain. These are the signs of the imposthumes that are formed from choler, the member becoming yellow, violent pain, and thinness of the humours; and of this kind is the imposthume called **formica deambulativa**. Symptoms of the imposthume formed from phlegm: the member white, without great pain even on pressure, and it is soft: and swollen with a broad base. Symptoms of the imposthume formed

from melancholy; no great pain, colour black, dark and swarthy, earthy (?) and the veins round it are full of melancholic humour.


#### 23


If the imposthume come from matter poured from member to member,[387](javascript:footNote('T600008/note387.html')) it comes suddenly, and if from excess of nourishment[388](javascript:footNote('T600008/note388.html')) in the member, it comes slowly, by degrees. If the imposthumes be compound, they will have compound signs, according to the humours of which they are formed. If sanguine humour be responsible, and be strongest therein, the colour of the imposthume will turn to dull red.[389](javascript:footNote('T600008/note389.html')) If choler dominate, it turns to bright red unless it become purulent. If salt phlegm be strongest therein, it will become white, with a kind of yellowness, because of the mixing of phlegm with choler, for choler is bright when it is not mixed with any other


---

p.179






humour: usually there is itching in the place wherein is salt phlegm. If melancholy be strongest, the colour is black and blue and heaviness, insensibility, and great hardness are present, for if there be sensation it would not be formed from pure melancholy. No imposthume is formed from pure melancholy, but from dense, black, earthy (melancholic) blood only, for **Averroes** assents that it does not cause fever unless it be mixed with phlegm, or red blood; therefore it does not form an imposthume, for the matter of both is the same.[390](javascript:footNote('T600008/note390.html')) And Isaac says in the treatise he himself wrote on the urine, if an imposthume were formed of corrupt burnt humours turning to the nature of poison, such as **formica**, carbuncle, **anthrax**, and **noli me tangere**, it will be evil-smelling, with pain and itch, a blue black colour, corruption and mortification of the member.


#### 24


Note, imposthumes are generated in the internal members, as they are in the external, and some of them kill suddenly on account[391](javascript:footNote('T600008/note391.html')) of the nobility of the humours, and the members and *the violence of* the fever and the pain; such are diseases of the heart, and its imposthume: other things kill more slowly, such as imposthumes of the liver, the spleen, the reins, and the stomach. There are other things *again* that have special names, such as imposthume of the ribs, called pleurisy, and this is why it is so called: — pleur in Greek is the same as easna in Latin (sic)[392](javascript:footNote('T600008/note392.html')) and in Gaelic, and ‘sis’ is the same as position, therefore it is called pleurisis from its position on the rib, or near if, on the midriff. Peri-pneumony,


---

p.181






i.e. imposthume of the lungs. Frenzy, i.e. imposthume of the brain.


#### 25


And there are four signs[393](javascript:footNote('T600008/note393.html')) by which an internal imposthume is recognised, swelling, pain, injury to the functions, and the things we have mentioned, as are urine, faeces, and their like. And there are five special signs of true pleurisy, that cannot be separated from it, as are difficulty of drawing breath, continuous fever, cough (and) pain in the side; and **Avicenna** adds the fifth sign to these, a serrated pulse, like the teeth of a saw,[394](javascript:footNote('T600008/note394.html')) striking at long intervals with a pause between.


#### 26


Note, a *hot* imposthume is said to arise in two ways, i.e. it may come from hot matter naturally, or it may assume heat accidentally, through putrefaction, as **Avicenna** says.


#### 27


These are the symptoms of imposthumes on the lungs, undulating pulse, heat between the shoulders, redness of the cheeks, puffiness of the eyes, very high fever, and difficulty in drawing breath, as though ‘he’ were being suffocated.


#### 28


Symptoms of imposthume on the liver: the pulse[395](javascript:footNote('T600008/note395.html')) less than that above mentioned, pain along with heaviness, dry cough, frequent change of appearance, blood in faeces, and the patient does not lie on his right side; the urine turbid, like water that meat has been washed in; the shape of the imposthume is like the new moon, and the body is lean.


#### 29


Symptoms of imposthume of the spleen: swelling, and hardness[396](javascript:footNote('T600008/note396.html')) in the left side only; it is otherwise as regards oppilation and hardness if no imposthume be present, for then


---

p.183






there is hardness in them both; for the spleen is a long loose member situate in the left side, and ordained to purify sanguine humour, though **Averroes** says, the spleen is sometimes found on the right side, and the liver on the left (side), but since it is seldom found physicians pay no heed to it.[397](javascript:footNote('T600008/note397.html'))


#### 30


Symptoms of imposthumes of the reins:—pain, heaviness, steady fever; and if it be in the right kidney, the pain rises till it reaches the liver; and if in the left, it sinks to the bladder.[398](javascript:footNote('T600008/note398.html')) If the cause be hot, the pain is acute and darting; if cold, the pain is heavy, unless the cause be windy, for in that case the pain is light, and moves about from one place to another.


#### 31


Symptoms of imposthumes formed through crisis,[399](javascript:footNote('T600008/note399.html')) that turn to pus: when the sickness[400](javascript:footNote('T600008/note400.html')) is not acute, without hot matter present from hot humours, and the force is neither strong nor weak, but between them. These imposthumes come out in medial diseases[401](javascript:footNote('T600008/note401.html')) that do not cause death suddenly, nor quick recovery; for it is necessary where this imposthume arises, that the disease be of long (chronic)[402](javascript:footNote('T600008/note402.html')) duration, and the humours gross and hard to digest, and that the matter be not wholly purged, as **Galen** says in the second book of Prognostica, for then the matter is *terminated through the imposthume or by degrees[403](javascript:footNote('T600008/note403.html')) or through an insensible dissolution.* **Galen** says in the third book of Prognostica, when the humours are hot, the


---

p.185






force cannot be strong, and this is how that should be understood: in a disease that comes from hot humours, and finishes by *this* imposthume; the force cannot be strong, but weak, for if[404](javascript:footNote('T600008/note404.html')) it were weak, it would be bad, and[405](javascript:footNote('T600008/note405.html')) if it were strong it would finish the matter by diarrhoea or sweat, or insensibly (?) and that is the way in cold humours.[406](javascript:footNote('T600008/note406.html'))


#### 32


If the disease come in winter or[407](javascript:footNote('T600008/note407.html')) on an old person, and if no crisis or other purging come to him, by the end of twenty days, and the sick man improving, then it is a sign that it will finish in an imposthume,[408](javascript:footNote('T600008/note408.html')) and where most sweat comes, there the imposthume will form. If the veins of the *temples dilate*[409](javascript:footNote('T600008/note409.html')) and beat, and the breath *be* quick, it is certain there will come an imposthume at the base of the ear, or the cheek, or in the throat. If there be strong tension below the midriff, or in the groin, or in the thighs,[410](javascript:footNote('T600008/note410.html')) accompanied by pain and inflammation, that is a sign that the imposthume is in the lower members.


#### 33


**Galen** says in[411](javascript:footNote('T600008/note411.html')) laborious fevers the imposthume is formed chiefly in the joints and in the cheeks because of the weakness, the movement, and the looseness of the members, and their flaccidity. For the movement draws the *excess* matter to itself, and the fever sends *it* to the weak members; as the doctor says,[412](javascript:footNote('T600008/note412.html')) nature readily sends the matter and the excess of the humours, towards the weak members.




---

p.187


#### 34


Let us speak now of the urine, that is, of the urine of those who have this disease, i.e. imposthumes. Note, if there be two colours on the urine, the colour of camel[413](javascript:footNote('T600008/note413.html')) wool on top, and the lower part of the colour of inopus, that is the sign of an imposthume. If the urine be like that of a brutish beast, that is a sign[414](javascript:footNote('T600008/note414.html')) of frenzy; if the matter be dense and watery, it signifies lethargy.


#### 35


Item if the urine be red-brown,[415](javascript:footNote('T600008/note415.html')) turning one day to the colour of inopus, and leaden on top, with saffron-coloured foam; that is a sign of a hot imposthume on the liver. Item if the urine be turbid, scant, and raw, that is a sign of a cold imposthume on the liver. Item if the urine be thick in substance, and somewhat high (?) coloured,[416](javascript:footNote('T600008/note416.html')) together with many little bright granules in its midst, that is a sign of an imposthume of the stomach, from phlegm.


#### 36


Item if the urine be low[417](javascript:footNote('T600008/note417.html')) in colour, according to **Egidius**, and thin in substance, and much radiance in it like a sunbeam, with little bodies like ashes underneath; that is a sign of imposthume or stoppage of the spleen. Item if the urine be black in colour like the hue inopus, at the beginning of the disease, that is a sign that death will result[418](javascript:footNote('T600008/note418.html')) *therefrom*; at other times it typifies an imposthume on the kidneys, if it be scant.


#### 37


Item if the urine be of the colour called cyanose,[419](javascript:footNote('T600008/note419.html')) which is a composite colour of white, black, and red along


---

p.189






with fatty corpuscles, that signifies an ulcer in the bladder *arising* from an imposthume therein. If there be red sand in it, that shows the kidneys[420](javascript:footNote('T600008/note420.html')) are not sound; sometimes this sand comes from the burning of sanguine humour in the veins, and then the urine is high-coloured: if it come from the kidneys it is not high-coloured, but whitish, being drawn from them before it is digested: in this way the sand results from the burning of blood,[421](javascript:footNote('T600008/note421.html')) and is soft; at other times it signifies a stone in the kidneys, and is not soft, but hard, as is generally clear in the matter of stone.


#### 38


Let us speak now of the prognosis of this disease of imposthumes. **Hippocrates** says, the pain is stronger when ripening, than when they are matured; **Galen** says this is true, especially if the pus be expelled.[422](javascript:footNote('T600008/note422.html')) Note, some imposthumes are terminated by the end of twenty days, others by the end of twice twenty, and others by the end of three times twenty days. If the matter be hot and the member hot, it is finished by the end of twenty days: if the matter be hot and the member cold, or *the matter cold and* the member hot, it is finished by the end of twice twenty days; and if the matter and the member be both cold, that finishes by the end of three times twenty days. Let that be counted from the day on which these accidents appear, and become stronger or more serious than they were at first; i.e. shivering,[423](javascript:footNote('T600008/note423.html')) and horripilation, and sharp fever. Expect that the imposthume will break by the end of *twenty days or* twice twenty days from then, or by the end of three times twenty.


#### 39


Item if the matter of an imposthume on the surface (?)[424](javascript:footNote('T600008/note424.html')) disappear suddenly, it means one of two things: the


---

p.191






matter resolves itself imperceptibly, or else it goes back inside to gather again *in the entrails,*[425](javascript:footNote('T600008/note425.html')) and that is bad and dangerous; for if the matter turn in again, the fever continues together with the other accidents,[426](javascript:footNote('T600008/note426.html')) that the matter gave rise to at first, and the sick man is none the easier; but when the matter is dispersed imperceptibly, the fever ceases and the sick man gets relief.


#### 40


Note that there are five causes by which the matter of the disease disperses imperceptibly (i.e. the matter of the imposthume). These are, the thinness of the humours, the rarity of the member, the heat of the air, the virtue of the remedy, and the strength of the patient's vigour, as **Galen** says in the second book of Prognostica.


#### 41


Item all imposthumes occur more frequently in winter, than at any other time, and remain longer, and if they be relieved they do not come back again, as **Hippocrates** says in the third book of Prognostica; and it is of the imposthumes occurring in crisis,[427](javascript:footNote('T600008/note427.html')) caused by cold humours, that he speaks; for those humours are more numerous in winter, and it is then these imposthumes are most frequent and most plentiful.


#### 42


Item an imposthume that is in a principal member, *and is* without pain, signifies that nature has lost the guiding force[428](javascript:footNote('T600008/note428.html')) *there* and especially if it be formed of sanguine humour or choler. And **Damascenus** says,[429](javascript:footNote('T600008/note429.html')) a painful imposthume is seldom caused, except by hot humours, and **Hippocrates** says in the first book of Prognostica that the hard imposthume which is formed painlessly, is not dangerous, *but* if it be formed


---

p.193






with acute pain, it is dangerous; excepting such imposthumes formed *from a humour in which are hardness and dull pain. Item[430](javascript:footNote('T600008/note430.html')) the imposthume that does not turn to running does not cause unnatural external heat*[431](javascript:footNote('T600008/note431.html')) such as that formed by flatulence which[432](javascript:footNote('T600008/note432.html')) becomes hard. The imposthumes that are on the noble internal members cause fever, and some of them cannot be easily felt, as are imposthumes of the chest, or lungs; and there are others hard to take hold of, such as imposthumes of the liver, the spleen, the stomach, the small intestines, the kidneys and the bladder, as says Averoes.


#### 43


Item the imposthume that appears below the navel, seldom turns to running, because of the coldness of the place wherein it is. Item the imposthume that has a sharp head, and is not broad below is better than the imposthume that has a broad base without a pointed head;[433](javascript:footNote('T600008/note433.html')) for the former shows the strength of the force that expels the running (pus).


#### 44


Item when an imposthume of the side[434](javascript:footNote('T600008/note434.html')) turns to one of the lungs, or frenzy to lethargy it is bad; but it is less harmful if it be an imposthume of the lungs that turns to one of the side, or lethargy to frenzy —as **Avicenna** says. He says also, when the matter goes from a noble member to an ignoble member, that it is a good sign; *but* when it goes from an ignoble member to a noble member, or to a member that cannot digest it properly, it is a bad sign. Note, fever and trembling, come often when the pus is formed, because of the matter breaking and burning the skin.[435](javascript:footNote('T600008/note435.html'))


#### 45


Item hard imposthumes that are on the liver[436](javascript:footNote('T600008/note436.html')) can be cured at the beginning of the matter, with great difficulty;


---

p.195






thereafter it is not possible, for it turns to dropsy within fifteen days; and then the hardness is not apparent to the touch, and that is the dropsy that cannot be cured. Note, the imposthume that is at the back[437](javascript:footNote('T600008/note437.html')) of the liver is usually cleared up by three things, by urine, by sweat, and by nose-bleeding; and an imposthume inside the liver is most[438](javascript:footNote('T600008/note438.html')) times terminated by flux, by sweat, or by vomiting.


#### 46


Item a hot imposthume, that is in fleshy places[439](javascript:footNote('T600008/note439.html')) is occasionally terminated by dissolution, for the nature of the flesh is weak and loose, and it is near to moisture:[440](javascript:footNote('T600008/note440.html')) an imposthume that is in a sinewy member[441](javascript:footNote('T600008/note441.html')) gathers slowly, and disperses more slowly; for the gathering is slow there, and the harder it is, the slower does it disperse, as **Galen**[442](javascript:footNote('T600008/note442.html')) says on the 3rd section that **Hippocrates** wrote, and **Isidorus**[443](javascript:footNote('T600008/note443.html')) says in the 3rd part that **Damascenus** made ‘that which comes easily goes easily’.


#### 47


Item every imposthume that is formed from contraries, the more direct it is the worse it is, for it shows the amount and the badness of the matter which nature cannot control or endure, because of its contrariety. For **Galen** says the disease in which are many and diverse *kinds of* matter is longer than the disease in which is one *kind of* matter *only*, though it be much, for nature cannot digest much and diverse matter, in a short time. This is how that should be understood, of compound diseases caused by heat and cold, as compared with diseases caused by heat only; and it is not right to take it of diseases compounded of heat and cold, as compared with


---

p.197






those caused by cold[444](javascript:footNote('T600008/note444.html')) only, for simple quotidian fever is longer than hybrid (?) tertian, caused by choler and phlegm.


#### 48


*All imposthumes caused by burnt matter,[445](javascript:footNote('T600008/note445.html')) such as anthrax, formica, carbuncle and the like are worst and deadliest, and if accompanied by fever, the patient seldom recovers; and therefore* they greatly err who open the black pustules, before they are ripe: if they are opposite the heart or near it, it is fatal, and if they vanish suddenly without relieving the patient, it is a sign of death.


#### 49


Item every imposthume, out of which blood or yellow matter comes before the seventh day, unless it be broken by force, is fatal; for *nature* cannot evacuate the matter (of the imposthume) suddenly, by the digestion of a certain thing outside of nature, for the digestion that nature does at the beginning of the matter does not avail. Nevertheless if many good signs come from it afterwards, there is a chance (?) that he will not die quickly.[446](javascript:footNote('T600008/note446.html'))


#### 50


Note, moreover these are good signs in every disease; the sick man's force strong and he himself constant[447](javascript:footNote('T600008/note447.html')) and the breathing good, and he evacuates easily and entirely the matter of the disease; equal heat in the body; and no violent thirst; that he be right as regards urine, faeces, sweat and sleep. And whoever is thus, will get over any material sickness. The author of this treatise puts that into Latin verse; and these are his words in Gaelic,[448](javascript:footNote('T600008/note448.html')) (i.e.) force, mind, lightness, spirit, sleep, and beating. Gaddesden says, these signs are good in


---

p.199






this disease, and this is how he explains them: the force to be strong and powerful; lightness,[449](javascript:footNote('T600008/note449.html')) that is, the patient finds relief from the sickness after the signs of digestion; [450](javascript:footNote('T600008/note450.html')) and speaks with reason; spirit (?) i.e. the species of heat or cold evenly *balanced*; of *sound* mind i.e. he should be sane with no ravings arising therefrom; sleep, i.e. to be good, and untroubled by imaginings or ugly visions; beating, i.e. a strong beat apparent in the pulse, for unless it were thus the symptoms would be bad.[451](javascript:footNote('T600008/note451.html')) But although **Avicenna** says we did not know how many good signs we viewed with horror, such as the heaviness of sleep, the exhaustion of the pulse, and the want of sweat; yet the patient came out of it at last to the crisis. Nevertheless that happens seldom, and therefore these signs are dubious, and therefore an accurate prophecy cannot be made here, as happens often in acute sicknesses. This word ‘beating’ can be explained another way; i.e. the beating of food on being chewed in the mouth: for it is a good sign if the sick man can masticate his food well, and beat it hard with the teeth, and swallow it properly.[452](javascript:footNote('T600008/note452.html'))


#### 51


Since we spoke above of the symptoms and causes of imposthumes, let us speak now of their cure. The cure is varied according to the stages of the disease,[453](javascript:footNote('T600008/note453.html')) for it is meet in the beginning to give repercussives; and in the increase, when it grows and broadens, repercussives along with maturatives but more of the repellents. At the stasis *give* maturatives


---

p.201






only, or more of them, and less of the repercussives or an equal amount of both, and in the decrease, things that disperse the matter.


#### 52


Item it is proper in the beginning to apply repellents to them (i.e. the imposthumes) except in certain cases. One case, when it is clear that the body is full of evil humours, *and again when the matter is poisonous as in anthrax and carbuncle for then it should rather be drawn off than repelled, or if the imposthume be near to a principal member. Another case is if the force be weak as in those rising from a long sickness, old people, children and pregnant women*,[454](javascript:footNote('T600008/note454.html')) for **Damascenus** says the repulsion is hindered in imposthumes in three ways: by a humour, if it be poisonous or raging, for there is beating[455](javascript:footNote('T600008/note455.html')) then according to (the) force, or by a humour that errs as regards quantity, because of its amount, so that it fills the vessels;[456](javascript:footNote('T600008/note456.html')) and it is not right to cause repercussion then, but to reduce[457](javascript:footNote('T600008/note457.html')) it according to its force, because if the force be weak, a repercussive should not be given. Another case where a repercussive should not be applied: if the imposthumes be in the groin, or the throat, or in the armpits; for it is thither the noble members send their surplus, and if the repellent be given there the matter is returned to themselves then, and that is a great danger. Another case is, if there be an imposthume on the anus, a repellent should not be given, for it is thither all expel their excess. Another case: if it be an imposthume resulting


---

p.203






from crisis, a repellent should not be given *except if the matter flow towards a painful noble member, such as the eye for then it is meet to apply it*.[458](javascript:footNote('T600008/note458.html'))


#### 53


The cure of hot imposthumes is effected in two ways: by the purging of the humour of which the imposthume is formed, and by removing the evil complexion. If the imposthume is caused by choler, it is necessary then to alter the evil complexion; if the imposthume is caused by phlegm, or corruption, then it is meet to give purgings. And **Averroes** adds a third method here, to remove the antecedent cause.


#### 54


Note, imposthumes have antecedent causes, such as repletion[459](javascript:footNote('T600008/note459.html')) and primitive causes, i.e. external causes, such as a fall, a blow, or the bite of an animal. The imposthumes that are formed from primitive causes are sometimes formed with repletion of the body, and at other times without it, although there is local **plethora** in the member wherein is the imposthume, the which **plethora** is caused by the dispersal of the matter to the member. And this dispersal is caused by the repletion of the whole body, or by that of a member that is near to the imposthume, or by the strength of a member that expels its excess to another weak member, and the tying[460](javascript:footNote('T600008/note460.html')) of the members together helps to this end, or the wideness of the passages. Sometimes the cause of the drawing of the matter to the place of the imposthume is the hot evil complexion of the member, for attraction is the property of heat.


#### 55


Another cause thereof, is the very great pain[461](javascript:footNote('T600008/note461.html')) of the member wherein is the imposthume; and the pain is caused by *the bad complexion which generates it, or because


---

p.205






of the bad complexion* which is caused by the *excessive* movement of the evacuatory force, when it expels its excess from it, as **Galen** says. It may be said according to this, that pain draws,[462](javascript:footNote('T600008/note462.html')) for it is the cause, according to **Galen**, whereby nature puts the matter to expel the injurious *products*; and so it *only* does harm by accident.


#### 56


If repletion be the cause of that drawing, and if it come from sanguine humour, let a vein; and if it be because of the malice of another humour, purge him with a purgative or by vomiting. If both be responsible, let those three things be done; and let the drawing be done to the member that is farthest from you opposite it, such as, if there be a hot imposthume on the eye,[463](javascript:footNote('T600008/note463.html')) apply the (cupping) horn, along with scarification, to the back of the head; for this purges the matter, and draws it strongly in the opposite direction. **Galen**[464](javascript:footNote('T600008/note464.html')) says if there be an imposthume on the right hand, let the blood be drawn to the left; and vice versa,[465](javascript:footNote('T600008/note465.html')) regarding the right, that is, if it be the right foot let (it) be drawn *to the left foot*.[466](javascript:footNote('T600008/note466.html'))




---

p.207


{R. A. page 985}*Regarding the cure of warts etc.*
----------------------------------


*Let the patient abstain from all melancholic foods,[467](javascript:footNote('T600008/note467.html')) such as* beef (and) duck, (and) ganders, old salt-meat, kail, peas, cheese, meat fried in fat, entrails of animals; then take hens' feet and put them under cinders until the*ir* flesh and skin separate, then rub the hot skin on them (the warts) three or four times, and then extract the blood all round, with your nail.[468](javascript:footNote('T600008/note468.html'))


#### 58


Item take burnt willow bark and mix it with vinegar; this will cure warts on being applied to them, and **porrigo** and **ficcus** i.e. soft warts near the anus; there are a number of little granules in them as are in figs, and therefore they are called **ficcus**, for **ficcus** is the same as fig; and on whomsoever they be, let him drink the juice of **pipinella**, and apply it whole to them as an emplaister, and it heals.


#### 59


Item a thing I have proved myself often on my own body, is to rub acrimony on them[469](javascript:footNote('T600008/note469.html')) (the warts) frequently and bruise with salt and vinegar, and apply it to them every day as an emplaister, and rub on **portulaca** every other day; the juice of willow leaves has the same effect.


#### 60


Item droppings of goats and vinegar applied to them[470](javascript:footNote('T600008/note470.html')) avails; if it is put on hot to them often, it heals. **Calsidus**[471](javascript:footNote('T600008/note471.html')) says a proper common remedy for them is to rub common burdock[472](javascript:footNote('T600008/note472.html')) and urine on them: if they be like acorns (glandulous) or like knots on a joint (nodular) then ashes of snails[473](javascript:footNote('T600008/note473.html')) along with stale unsalted lard helps them, and there is nothing


---

p.209






better for them than that, and it heals *all* the imposthumes that are like acorns. And **Johannes de Sancto Amando** says, that unripe figs mixed with vinegar cure them, and he calls this ‘the King's Remedy’. Item a cure in which is no deceit, is to wash them in the water in which a dead man has been washed.[474](javascript:footNote('T600008/note474.html'))


#### 61


And there are many kinds of these (warts), such as **lupia**, and **acrochordones**, and note, it is good to cut them, and cauterize the place, so that too much blood may not flow from them; or let garlic be broken together with salt, and change it between the day and the night three times, and continue using it well for nine days thus, and press them out with a plate.[475](javascript:footNote('T600008/note475.html')) If it be desired that blood shall not flow from them after the cutting, apply cobwebs to them, or white of egg along with the hair of a hare. And a common cure is to tie them round the base with a strand of horse hair, or a thread of silk, until they fall off.[476](javascript:footNote('T600008/note476.html'))


#### 62


And **Averroes** says that the imposthume called carbuncle is most frequent in time of plague when the air is corrupt, and therefore the blood boils[477](javascript:footNote('T600008/note477.html')) and putrefies; and an evil complexion and putrid fever composed of diverse humours come(s) thereafter. **Formica** is as follows: an imposthume that travels in the skin[478](javascript:footNote('T600008/note478.html')) and is not broad: sometimes there are broad[479](javascript:footNote('T600008/note479.html')) pustules, which *move* from one place to another, and form sores; they have wide roots and are of the colour of ashes (yellowish), and fiery choler is the cause thereof.


#### 63


Anthrax[480](javascript:footNote('T600008/note480.html')) is a poisonous imposthume formed from


---

p.211






burnt humours, and felon is its name in English; the humours in this do not burn as much as in the imposthume called carbuncle. In it are many colours, such as yellow, *red*, blueblack, and *black* like a wheel (rainbow?)[481](javascript:footNote('T600008/note481.html')) because of burnt sanguine humour[482](javascript:footNote('T600008/note482.html')) and burnt choler which turn to the nature of poison and melancholy, and form ulcers. And for this it is called **anthrax**; antrum in Latin is the same as umha or clais[483](javascript:footNote('T600008/note483.html')) in Gaelic, for they make a furrow in the place wherein they are. Their cure is similar *to the above and consists* of blood-letting and purgatives, and it is necessary to purge all the humours, for they are all to blame in this case. Understand it is not proper to open them (the imposthumes) until the matter is purged, for it does not find a channel for evacuation because of the amount of matter, therefore it goes to the heart, and because of the excessive pain, it kills;[484](javascript:footNote('T600008/note484.html')) as I once saw a man die on whom was a black pustule of this kind, on opening it with a needle.


#### 64


Item in the case of these, let cold things and strong styptic things be avoided, and repercussives that repel the matter towards the principal interior members, and do not thicken the matter too much. Item avoid over-hot dispersives so that the hot matter be not inflamed; but apply dry cold non-corrosive things to them in which are some attractives,[485](javascript:footNote('T600008/note485.html')) such as **plantago**, barley meal, and bread of bran and alum along with vinegar. Note, as a general rule, every remedy for felon, cures carbuncle.




---

p.213


#### 65


Since[486](javascript:footNote('T600008/note486.html')) we are speaking of felon, these are its prognostics: vomiting, strong pulse, cold sweat, heart weakness, and if that increase it signifies death. Item the felon which has the colour of flame is not curable. Item dry some pig's gall and apply a piece the size of the opening to the ulcer, and if none of it adhere to the sore, it is a sign of death, and if it do, it heals the felon: and likewise the bite of a mad dog.


#### 66


Item for the cure of felon; open a vein in the same Curatio. member,[487](javascript:footNote('T600008/note487.html')) for it is a common rule that the matter should not be drawn to its contrary.[488](javascript:footNote('T600008/note488.html')) Put then, repercussives round it, and resolvents that be not too hot, on the imposthume itself. Give things against the poison internally, such as violet, and **hypericon**, and scabious; let the bowels be kept constantly relaxed with senna, and **cassia fistula**, and violets. In order to ripen and break the felon, let yolks of eggs, with a little salt and honey well pounded together, be applied frequently during the day; or let an emplaister be made of figs, or of sour dough, with oil (spurge?)[489](javascript:footNote('T600008/note489.html')) and salt.


#### 67


Item if peacock's droppings be applied, it breaks, ripens, and heals *the anthrax*. Item bruise daisies between two stones, and put them on it and raw yolks of eggs, and burnt salt mixed well, and this will break it by the end of the third day. Item bruise **pimpinella**, along with **linaria**, the which is very potent in this case. Item bruise scabious along with lard, it is approved potent in this case, and clean the spot then, with juice of smallage, and pure honey,[490](javascript:footNote('T600008/note490.html')) and wheaten meal. If the pain be intolerable, take lily roots bruised and boiled in water, and apply them, or roots of lily and daisy, with


---

p.215






white of egg, and add a healing powder of mastyche, dragon's blood, roses, and the like. If it be desired to draw the matter from a noble member to an ignoble one, rub with juice of savory,[491](javascript:footNote('T600008/note491.html')) from the place where the felon is, to the place where it is desired it should go, and apply a resolvent poultice to it then.


#### 68


Item against the Fire of God,[492](javascript:footNote('T600008/note492.html')) that is, the imposthume called **erysipelas**, take new cheese and bruise (?) it strongly,[493](javascript:footNote('T600008/note493.html')) and mix with honey, and rub thereon. Put leaves of kail on it after that, and it heals.


#### 69


Let us speak now of imposthumes of the testicles;[494](javascript:footNote('T600008/note494.html')) sometimes the vessels harden, and imposthumes appear on them,[495](javascript:footNote('T600008/note495.html')) and (from this) there is swelling in their own substance at other times there is swelling[496](javascript:footNote('T600008/note496.html')) in them because of rupture and this has the appearance of an imposthume, but it is not so. And the following is the cause of it: *Est aliquando sperma, quod est in via, non habens completum exitum; sicut accidit illis, qui loquuntur cum mulieribus, & tangunt eas, amplexantur fortiter, cupiuntque coire, & tamen desiderio non satisfaciunt. Aliquando accidit induratio propter equitationem incommodam equi succusantis, vel propter saltum super sellam ascendendo, ante vel post sellam, super lignum. Aliquando propter pollutionem nocturnam inchoatam & impeditam.’’*

[R. A. 930]


#### 70


If it be caused by sanguine humour, then the colour will be red: if it be from semen the colour will be swarthy.


#### 71


The following are the cures: give a clyster of rue and tutsan, cummin, pellitory, lovage, walwort, oil of roses, and benedict, sharpened with vinegar, and with agaric. Item 


---

p.217






it is good to make him vomit with the middle bark of elder,[497](javascript:footNote('T600008/note497.html')) and he should eat but little food, and that easily digested.


#### 72


If the evil be in the right half,[498](javascript:footNote('T600008/note498.html')) let a vein of the right arm for him; if in the left half open a vein in the left arm likewise: mix together cummin, flower of beans, oil of walwort and pellitory, and let it be applied to them, or whole beans, and wine, and bran. Item [rx ] take pellitory, rue, camomile, mallows, pansy,[499](javascript:footNote('T600008/note499.html')) a fistful of each, and boil in water; put a stupe about the testicles of these; to be applied fasting.


#### 73


If the cause be hot, let oil of roses be rubbed on it; if cold, rub on oil of camomile.[500](javascript:footNote('T600008/note500.html')) If the place be red, take tepid juice of plantain and dip a linen cloth[501](javascript:footNote('T600008/note501.html')) therein, and apply. Open the medial vein of the joint internal to it.[502](javascript:footNote('T600008/note502.html')) Apply the blood of a hare, hot, to it, and **cassia fistula** thereon, which ripens it and every *other* hot or cold imposthume *also*.


#### 74


Item henbane[503](javascript:footNote('T600008/note503.html')) boiled in wine is good for every hot imposthume of the kidneys and testicles, on being applied to them and an emplaister of mallows. Item kail[504](javascript:footNote('T600008/note504.html')) ripens the imposthumes of sanguine humour, and softens their hardness, and duckweed (?) does the same. If the imposthume be phlegmatic or watery, let the matter be digested with the roots of smallage and radishes, and with watercress, hyssop, calamint, liquorice, and honey; let it also be purged with agaric, and again repeat the clyster, and the vomit. Then apply to them things that penetrate, as are southernwood, boiled in wine and vinegar.


#### 75


Item moss of a tree (lichen?) boiled in wine or in


---

p.219






oil is good for every imposthume that is in a sinewy member: the **scrotum** is sinewy,[505](javascript:footNote('T600008/note505.html')) therefore it is good for it. Item watercress with water, honey, and salt avails for *swollen* testicles, if the cause be cold; and for every *cold* watery imposthume. Item turpentine and salted pig's lard is good for hard imposthumes. Item wallwort, and rue, and bean meal, is good as a poultice in every windy imposthume.


#### 76


Item[506](javascript:footNote('T600008/note506.html')) turpentine and flax seed, fenugreek, seed of mallows, saffron and finely sifted bran is good for every hardness and for every cold imposthume, though it be soft:[507](javascript:footNote('T600008/note507.html')) if there be pain in it apply anise to it, as it stops the aching.[508](javascript:footNote('T600008/note508.html')) Item fenugreek,[509](javascript:footNote('T600008/note509.html')) fried in butter or oil, is good for hard imposthumes, and it is hotter than flax seed. If you wish it to have a stronger effect, add lily leaves to them; for they stop the pain better than the roots, nevertheless there is a ripening, dispersive force in the roots, and **Avicenna** says lily leaves are good for hot imposthumes.


#### 77


Let us speak now of the hot imposthumes[510](javascript:footNote('T600008/note510.html')) that are in the uterus, which are formed by an external cause, such as a blow, or a fall; or from an internal cause, such as retention of the menses, or difficulty of child-birth.


#### 78


These are its symptoms: weakness of the heart, syncope, pains *in the* head and neck, heaviness of the eyes; flaccidity of the extremities; constant thirst;[511](javascript:footNote('T600008/note511.html')) the nature of the urine [*...*] the disease called **dysuria**, and fever for the most part.


#### 79


A cold imposthume is formed from external causes, as are a bath in cold water, a cold wind, sitting on a cold stone, and from cold viscous foods,[512](javascript:footNote('T600008/note512.html')) such as milk, or too much fruit. It is formed also from internal causes, such as retention of


---

p.221






urine, or excess of *cold* humours; the symptoms are, heaviness in the lower limbs, and occasional fever; and cold things afflict the person who has it. If it be a hard imposthume, there is hardness in the share,[513](javascript:footNote('T600008/note513.html')) and in the mouth of the womb, heaviness in moving the members, and especially in saphena and[514](javascript:footNote('T600008/note514.html')) veins of the ankle (?). It is not the same as mola matricis, for if a hand be placed on it hard, it moves from place to place, as though pregnancy were present.


#### 80


Hot imposthume of the womb is cured[515](javascript:footNote('T600008/note515.html')) by *letting* the vein of the liver,[516](javascript:footNote('T600008/note516.html')) and the vein called **saphena**, for the catumenial flow is withheld *therein* in this tumour: cause vomiting afterwards, and make a tisane in which are boiled violets, and coltsfoot. Let the patient consume but little food and drink, and make long vigils, and place sweet-smelling things in the place wherein she is. Then put **cassia fistula** in her remedies;[517](javascript:footNote('T600008/note517.html')) boil mallows, flax seed, and plantain,[518](javascript:footNote('T600008/note518.html')) and mix oil of roses therein, then soak wool in it, and apply the wool thereto. Let it be ripened with mallows, and dactylis (?) and with gander's fat and barley meal; and put it as an emplaister on the share and the place where the pain is. If it be ripe, break it with figs and mustard, and with droppings of goats or doves, and clean the ulcer then with honey water.


#### 81


Cold imposthume of the womb is cured by vomiting, by *an attractive* clyster, and by agaric; and digest the matter with fennel roots, smallage, maiden hair, caeterach, pollitrich, plantain roots, and scabious, a fistful of each of these; columbine, pimpernel, daisy, mulberries, fumitory, **hypericon** (?), half a fistful of each of these; a quart of liquorice, one ounce of fennel


---

p.223






seed, half an ounce of camomile seed or flowers,[519](javascript:footNote('T600008/note519.html')) and a drachm of violet flowers. *Make a syrup of this with water and let it be used* early, at noonday, and at bedward, and this syrup cures every imposthume and felon in cold weather, and delivers from poison; and from the columbine it is named. It is also good in hot weather provided one thing, that the cold things be increased in hot weather and the hot lessened. Violet water is good in the case of every hot imposthume mixed with nightshade (?)[520](javascript:footNote('T600008/note520.html')) and roses, and therefore bear this in mind for the use of every imposthume, except the imposthume of the brain called **phrenesis**.


#### 82


And if the imposthume be hard, take marrow of stag, lard of gander and duck, beef marrow, hardened yolk of egg, butter, and red wax[521](javascript:footNote('T600008/note521.html')) drachm 2 of each; and take then fennel seed and flax seed, equal parts of each, and boil them in water or in wine, along with the things we said before, and let it be applied to the womb by[522](javascript:footNote('T600008/note522.html')) a pessary.


#### 83


Item, in the same case, vine leaves are good, and oil and *honey* water, and leaves of kail. And **Avicenna** says, if a hard imposthume go uncured beyond a month, and[523](javascript:footNote('T600008/note523.html')) the pain be not checked *then*, it cannot be dispersed by treatment.


#### 84


Item take old pig's lard drachm i½,[524](javascript:footNote('T600008/note524.html')) and the same amount of wax; drachm i of gander's fat, and drachm iv of honey and of butter, and drachm ii of galbarnum. Break the galbarnum in a mortar, along


---

p.225






with drachm iv of oil; melt all these things, and pass them through a cloth, and use this against every swelling and hardness, and against every cold disease and pain of the nerves.


#### 85


Note the best marrow here is stag marrow, because of the thinness of their humours,[525](javascript:footNote('T600008/note525.html')) and after that calf marrow; the best fat[526](javascript:footNote('T600008/note526.html')) is duck, because it is thin, and not sharp; and after that hen fat; and the best fat among the fourfooted animals is lions', because of its thinness, then cows' grease,[527](javascript:footNote('T600008/note527.html')) and goats' thereafter.


#### 86


Item another thing for dispersing and ripening imposthumes is flax seed, fenugreek, barley meal, wheaten meal, figs, droppings of doves, and oil, and sour dough boiled along with them; and apply it as an emplaister.


#### 87


Item let a powder be made of doves' droppings, and mix it with oil, and that expels every hardness and every pain. If there be windiness in the womb, make the patient to sneeze,[528](javascript:footNote('T600008/note528.html')) and give **diacyminum** for that is good against flatulence.[529](javascript:footNote('T600008/note529.html'))




---

p.227


F. De Lethargo.
---------------


#### 1


Let us speak now of Lethargy. Lethargy is an imposthume on the posterior brain, as frenzy is on the facial cranium, the which is true lethargy, for lethargia non vera is produced by vapours that confound the memory, or by choler mixed with phlegm. Lethargia vera is produced by corrupt phlegm in the posterior brain, and fever accompanies it.[530](javascript:footNote('T600008/note530.html'))


#### 2


These are the causes thereof:—everything that increases phlegm and choler in the body and in the brain, such as leeks, and onions, and garlic, and watery fruits, wine, **plethora** of food and drink, ‘crapula’, drunkenness, much food, great consumption of white meat, bread soaked in fatty broth, fish, pork, and much resting; and it never comes alone, but follows another sickness, such as continuous quotidian fever,[531](javascript:footNote('T600008/note531.html')) which is usual. This imposthume is situated in the passages (?), and holes of the cranium (?), and seldom in the substance of the brain.[532](javascript:footNote('T600008/note532.html'))


#### 3


Its symptoms are as follows:—continuous slow fever, and little pain, forgetfulness, confusion of reason, the urine somewhat thick and turbid, as it were the urine of a brutish beast; much false sleep, and sometimes he forgets to evacuate urine and faeces.[533](javascript:footNote('T600008/note533.html'))


#### 4


If the matter be compound and phlegm be dominant,


---

p.229






the sleep is the heavier thereof, and the patient is taciturn, and dislikes moving,[534](javascript:footNote('T600008/note534.html')) and keeps his eyes closed as though he were devoid of life. If choler be strongest, then the patient is restless and sleepless,[535](javascript:footNote('T600008/note535.html')) and keeps his eyes open, gazing at one object for long. If both these humours be equal, the symptoms will be intermediate. If produced by phlegmatic humour only, the patient is yawnful at the beginning of the matter, and he suffers from an excess of saliva, and heavy sleep, and keeps his eyes and mouth shut, and if these be opened, he forgets to close them. The faeces are frequent, copious and moist, and the pulse and breathing scant and oppressed,[536](javascript:footNote('T600008/note536.html')) and if the sufferers from this disease be addressed in a loud voice, and called by their proper names, they answer;[537](javascript:footNote('T600008/note537.html')) but if permitted they relapse into sleep without delay, and that is not real sleep, but heaviness and stupor.


#### 5


These are the symptoms of this sickness, as regards its prognosis:—blue black colour[538](javascript:footNote('T600008/note538.html')) of the face, swelling, and disorderly movements, for these things are proper thereto.[539](javascript:footNote('T600008/note539.html')) Item if he be morbid,[540](javascript:footNote('T600008/note540.html')) eating much, and have a voracious desire to eat more, say things that are not comely, and expel his spittle constantly, it is a sign of death; and more especially if there be cold sweat on the face and neck. If these signs do not appear, it is certain he can be cured.


#### 6


Note there is a difference between this disease and the disease called **suffocatio matricis**, for in the former one can speak, and in **suffocatio matricis** one cannot, and if one attempt


---

p.231






to speak to anyone, one cannot.[541](javascript:footNote('T600008/note541.html')) And there is *also* a difference between it[542](javascript:footNote('T600008/note542.html')) and apoplexy and epilepsy, for those sicknesses come suddenly, while this comes but slowly, by degrees. There is another difference between it and the weakness called syncope, for in lethargy the face is as the face of a healthy man, and in syncope, it is as the face of one dead.


#### 7


Note, it is necessary for lethargics, that people talk loudly in their presence. Tie their extremities tightly, (and) rub their palms and soles hard; and let their feet be put in salt water up to the middle of their shins, and pull the hair and nose, and squeeze the toes and fingers tightly, and cause pigs to squeal (?)[543](javascript:footNote('T600008/note543.html')) in his ears; give him a sharp clyster at the beginning of the case, in which is **hiera picra** **Galeni**, centaury, southern wood and wormwood, and the like, and open the vein of the head, or nose, or forehead, and draw blood from the nose with the bristles of a boar.[544](javascript:footNote('T600008/note544.html')) Put a feather, or a straw in his nose to compel him to sneeze, and do not ever desist from hindering him from sleeping; and let human hair, or other evil-smelling thing, be burnt under the nose. Apply moreover the cupping horn between the shoulders, and let a feather be put down the throat, to cause vomiting, and shave the back of the head, and rub oil of roses and vinegar, and smallage juice thereon. On the imposthumes consolidating on the third day, or the fourth, take **castoreum**, and juice of red mint(?), water, vinegar *and* smallage juice, and let them simmer together, and rub them on the back of the head, so that they,


---

p.233






and the matter therein, are digested,[545](javascript:footNote('T600008/note545.html')) or soak a cloth in it, and apply to the back of the head, and change frequently.


#### 8


Item apply a poultice of pigeon's droppings, and honey, to the back of the head, which relieves it greatly. Item if he have some sense,[546](javascript:footNote('T600008/note546.html')) and desire to take a remedy, it is sufficient to cure if he drink mustard and beaver powder and mint juice frequently; and let **galbanum** and *stag's* horn be burnt, and let its smoke go *up* under his nose on waking. And if he have a little of his reason, let the matter be digested with a syrup, in which shall be put sage juice, and betony, and rue, and mint, calamint, anise, fennel seed, cummin, nettles, seed of rue, vinegar, a little honey *and* sugar. If the fever be acute, give him a little of the syrup in which maidenhair has been boiled. If it be slight or the matter composite, give syrup of violets, and digest with **oxymel** of squills.


#### 9


If the matter be produced by phlegm,[547](javascript:footNote('T600008/note547.html')) the eyes are open, and the gaze fixed, accompanied by signs of motion (twitching?);[548](javascript:footNote('T600008/note548.html')) and let the matter be digested, then, by **oxymel** of squills, and by syrup of fumitory, and purged by **hiera picra**, sharpened with a little colocynthis, and with **hiera logodium**. If melancholy be responsible here, let it be purged with **hiera ruphi** and with diasene (senna). If the matter be composite, let the remedy be compounded of **hiera picra** and an electuary made of oil of roses.[549](javascript:footNote('T600008/note549.html'))


#### 10


Item let things be given to drink, and a gargarism, and then put treacle on the tongue, and if he can, let him swallow it. In order to restore their memory to them, make an electuary of *two parts* of lign aloes, and **cassia linea**, and the third part of **euphorbium** mixed with pellitory and honey,


---

p.235






and give them a little at a time. Shave the back of the head, then rub it hard, and scarify it and immediately rub in the same things boiled. If the cause be compound, take roses and violets, and camomile, and mellilot (?), and boil them, and let them be rubbed in briskly to the back of the head, and dry at once.


#### 11


Item if frenzy turn to lethargy, it is a sign of death; and if vice versa, the sick man often recovers.


#### 12


[550](javascript:footNote('T600008/note550.html'))Item take the heart of a robin redbreast, and put it round the neck of him who has this disease, and while it remains there he will not sleep. Item take the same heart,[551](javascript:footNote('T600008/note551.html')) and the heart of an owl, and hang them up above the man on whom is this disease, and who has lost his memory, and it will give it back to him. Item the heart of a swallow *cooked* with honey, the which compels him who eats it to tell things that happened, and things that did not happen *yet*.[552](javascript:footNote('T600008/note552.html'))




---

p.237


G. Hernia i.e. Dipping (?)
--------------------------


#### 1


Hernia is a disease in which *that part of* the **peritoneum** called siphac breaks, or is stretched, and widened, and because of this, the intestines fall into the **scrotum**, or swell in the groin with pain, and prevent a man from walking.[553](javascript:footNote('T600008/note553.html'))


#### 2


Note that there are many varieties of this disease; a form *caused* by flatulence, another *caused* by wateriness, one produced from humours, and one from flesh, another from *varicose* veins, and another from the entrails. And this is true hernia, for it is that form where the **peritoneum** called siphac breaks, and in it the entrails fall into the **scrotum**: *yet* another form is from that *part of the* **peritoneum** called zirbus.


#### 3


Note that there is on the belly, first the outer skin, inside that the **peritoneum** called **mirach**,[554](javascript:footNote('T600008/note554.html')) *then siphac*, inside that **zirbus**, and inside that *again* the intestines themselves. And as the midriff forms a wall between the digestive organs, and the respiratory organs, so does **siphac** between the intestines and the organs of nutrition and generation. It is like a sack which keeps up the entrails, and therefore when it is broken, they fail down; and when it is stretched, there is swelling and pain in the groin.[555](javascript:footNote('T600008/note555.html')) They seldom fall into the **scrotum**[556](javascript:footNote('T600008/note556.html')) then but when this happens without pain, fever, *or an imposthume*; that is true rupture.


#### 4


Sometimes windiness penetrates into the **scrotum** and causes it to swell; at another time there is wateriness there, and sometimes one of the humours swells in it; another time


---

p.239






there is superfluous flesh *present*, and yet again the veins are filled with melancholic humour and they become swollen, the size of a finger.[557](javascript:footNote('T600008/note557.html')) Another time the **peritoneum** called zirbus falls, and the sinews[558](javascript:footNote('T600008/note558.html')) which propel the semen towards the testicles thicken when they stretch too much.


#### 5


These are the external causes of rupture: — labour, much shouting, jumping, especially after food when the belly is full; excessive sexual intercourse, riding an unsafe horse immediately after food, laborious coughing and an overviolent sneeze. Another[559](javascript:footNote('T600008/note559.html')) cause thereof is the semen breaking away for expulsion and being prevented by some cause, and stretching the sinews by which it is propelled towards the testicles, and causing the sinews of the latter to swell, which produces the same disease: it is also caused by prolonged constipation *and* by the retention of flatulence, as in the disease called **colica passio**.


#### 6


To prove whether the **peritoneum** is broken or stretched,[560](javascript:footNote('T600008/note560.html')) the patient lies supine, squeezes the swelling, and puts it in with his finger: then let him sit up, and tell him to cough, and if the **viscera** fall, it (the **peritoneum**) is broken, and if not it is stretched.


#### 7


Item let a fire be made him of elder wood, and *when* he who suffers from this disease smells the smoke thereof, the entrails fall down, and there is great hacking pain[561](javascript:footNote('T600008/note561.html')) and (roaring) rumbling in the abdomen and intestines, which is heard throughout the house.




---

p.241


#### 8


If it be caused by windiness, there is flatulence in the intestines and rumbling, and the flatulence moves from one side to the other; if a finger be put on it, no undulation (?)[562](javascript:footNote('T600008/note562.html')) is felt, neither is heaviness present, but lightness compared to the other varieties. If it be caused by wateriness, the **scrotum** increases *in size*, accompanied by heaviness, and brightness;[563](javascript:footNote('T600008/note563.html')) if you take hold of it with your fingers and feel the watery fluid in it, which yields to the touch, and does not yield *when it is (?)* flatulence then the sufferer is disposed to dropsy. If it be caused by fleshiness, the testicles increase without pain, or imposthume, together with a certain hardness, and when handled, hard flesh is felt round about them.


#### 9


If it be caused by [564](javascript:footNote('T600008/note564.html')) varicose veins, the veins are hard and long, as though they were crooked rods, like those seen in the calves of beggars who carry great burdens. If it be from *that part of* the **peritoneum** called zirbus, though the sufferer lie supine the matter is *not* returned.[565](javascript:footNote('T600008/note565.html')) If it be the true form it returns easily if he lie supine. If it be the sinews, by which the semen is propelled that are relaxed, because the holes in them are large and loose, it is easy for the **viscera** to fall into the **scrotum**, and the name of these sinews is**didimi**. If it come from the humours, the body is full of evil humours, without pain, and if the matter be grasped, it so to speak ‘comes with you’ i.e. yields to the touch, and there is an intermediate softness[566](javascript:footNote('T600008/note566.html')) between the variety caused by fleshiness, and that caused by wateriness.


#### 10


Prognosis of this sickness: when the rupture is old, and the mouth of the wound blistered and hard inside, by


---

p.243






the end of a year, or half a year, it cannot be cured. Every form of rupture is easily cured at the beginning, especially in children, but it cannot be cured in old people, and moderately (?) in young people.[567](javascript:footNote('T600008/note567.html')) When it comes from the intestines, and is old, it cannot be cured, [568](javascript:footNote('T600008/note568.html')) except by chirurgerie, *i.e* by cauterising, together with a truss, *or* cutting, but that incision cannot be performed on old folk, and it is seldom resorted to without causing death. And if the stretched form *of rupture* continue beyond six months,[569](javascript:footNote('T600008/note569.html')) it must be left to chirurgerie.


#### 11


Many things are required for the cure of this sickness; first of these, diet: the second, to put the **viscera** in their proper place: the third, to keep them there; the fourth, to heal the wound; the fifth, cicatrizing and firing, or cutting.[570](javascript:footNote('T600008/note570.html')) The first of these is carried out by keeping the sufferer for six months without repletion of food and drink, or allowing him too much exercise; and let him not eat fresh fruit or things that cause flatulence, such as peas, and beans, and new ale; and let him not eat his fill at one time, nor rise from the place he is in *after food*, except he have very great need *of performing* the works of nature: let him not go a journey, nor go up and down stairs, nor jump, nor shout. And if he ride, let him *not mount by the stirrup but*[571](javascript:footNote('T600008/note571.html')) be in a high place sloping down, so that it (the horse) be below him, and he


---

p.245






come down on to it. If he must walk or do work, let it be finished before food, and keep the bowels relaxed with a clyster or a laxative pottage; avoid coition, and bathing, except there be so much swelling in the entrails that they cannot be put back, for then a bath may be taken to prepare him for that.


#### 12


The second thing mentioned for the cure is carried out in this manner; the patient lies supine with his hips high and his head low, and *he, the doctor* puts the guts up very gently with his finger, until they go in by degrees to their own place. The third stage before mentioned, i.e. the retaining of the entrails in their own place, is carried out by means of a special truss made for this case, the width of four fingers; let it be made of linen cloth (and) with many folds in it, and with cotton inserted between, sew it well, and make a tie[572](javascript:footNote('T600008/note572.html')) by which it can be closed and opened, and let there be a hard wedge (?) of linen cloth attached to it, and put it between his thighs.[573](javascript:footNote('T600008/note573.html'))




---

p.247


H. Paralysis est et cetera.
---------------------------


#### 1


This is paralysis according to the author: —a disease of the nerves that comes, sometimes, after the falling sickness, or similar diseases. And ‘paralysis’ is the same as to say the ‘wounding of a member’.[574](javascript:footNote('T600008/note574.html')) Sometimes the entire half of the body is afflicted, from the head to the foot, and[575](javascript:footNote('T600008/note575.html')) it affects a part of the tongue or the whole and prevents speech, and that is called general paralysis. Sometimes it affects but the tongue only, or one foot only, or the finger only, and that is called partial paralysis.


#### 2


Therefore there are two *kinds* of paralysis, general paralysis, and partial. According to that, paralysis consists in the softening of the nerves (sinews?) by taking from them their movement and perception, the which is true paralysis; in false paralysis only the sensation is taken away, or the perception, or the movement, as though a limb were asleep, or were frozen, or *suffer from* excess of cold; so that the sick man cannot stretch his finger, nor close it, nor clench it.


#### 3


And **Avicenna** says the term paralysis is used in general,[576](javascript:footNote('T600008/note576.html')) whereby it means the softening of any member it seizes, and therein both sides agree, with the exception


---

p.249






of parts of the head. For if the parts of the head agree, it is not paralysis, but apoplexy, which hinders movement and perception. Paralysis is used specially to mean softening of either side throughout the body, and so when half the body is affected with the exception of half the head, it is general paralysis. And there is a more general species than that, when it affects the whole half of the body, and half the head; for the parts of the body and the head are divided, so that one part may be affected without the other part, and for that reason nature has arranged two eyes, and two hands. There is *also* a most general paralysis when it affects the whole body, with the exception of the head, as we said before.


#### 4


The external causes are: falling, percussion of the nerves, attrition, and cutting across of the nerves; also anger, fear and excess of cold that compresses, excess of heat that scatters; also taking hold of the fish called ‘tarcon’.[577](javascript:footNote('T600008/note577.html')) And **Avicenna**, with profitable briefness, calls everything paralysis which binds and compresses the end and origin of the nerves, so that the spirit cannot pass through them. It comes oftenest from the following; phlegm, and less often from melancholy, still less often from sanguine humour, and least of all from choler, except it be mixed with another humour. Also it is caused by an imposthume, or by the crisis of the four sicknesses, namely, the falling sickness, colic, **suffocatio matricis**, and apoplexy.


#### 5


And I say briefly, there are eight general causes that hinder the passage of the spirit to the nerves. The first cause is poverty and scantiness of spirit and heat, so that they cannot increase and spread themselves to the nerves.[578](javascript:footNote('T600008/note578.html')) The second cause is excess of cold, which retains[579](javascript:footNote('T600008/note579.html')) and binds together the nerves.




---

p.251


#### 5


The third is excess of heat, which dissipates the spirit, such as burning fevers,[580](javascript:footNote('T600008/note580.html')) and remaining too long in an overhot bath. The fourth cause is dryness,[581](javascript:footNote('T600008/note581.html')) that twists the nerves, the which cause is bad. The fifth cause is moisture, without[582](javascript:footNote('T600008/note582.html')) matter having come to block it up. The sixth cause is excessive tightening and binding of the member. The seventh cause, a stoppage from whatever cause it come; whether from red blood, because of its quantity, or phlegm because of its sluggishness, or melancholy because of its toughness and denseness, or from choler on account of its thinness, which causes the other humours, with which it is mixed, to proceed so that they penetrate throughout.[583](javascript:footNote('T600008/note583.html')) Therefore since melancholy causes stoppage, there is no clear passage through the nerves, except those of the eye[584](javascript:footNote('T600008/note584.html')) and the **virga**, as **Galen** says. The eighth cause is hardening and thickening of the nerves.


#### 6


Note however that there is a difference between paralysis, and cramp; for movement and perception are prevented in paralysis, but in cramp only movement is prevented. Item in paralysis there is pain in the sick side, and in cramp in the healthy side. Item in cramp the sick side draws the healthy side *towards it* but not so in paralysis. Item in paralysis the oppilation is in the origin of the nerve, and in cramp it is in the whole nerve.


#### 7


Signs *as to* which humour the paralysis is caused by. If from sanguine humour, the pulse is full, and the colour of the body ruddy; the veins full, and it will have been preceded by causes of increase of sanguine humour. If from phlegm the body will be white, and phlegmatic signs are manifest before that in the *whole* body, for cold afflicts it; and it is relieved by heat;


---

p.253






it is also a sign if the sick man use those things that increase phlegm, such as white meat, fish and fruits, and excessive drinking (crapula). If from melancholy, the body is leaden-hued, black and scabby and (he) the sick man is lean and the season favourable thereto, and if he use things that increase melancholy,[585](javascript:footNote('T600008/note585.html')) such as excessive meditation, and depression; beef and hare, and duck, and gander, and peas, and kail, or other things prepared with salt. If *it come* from choler, though that occurs[586](javascript:footNote('T600008/note586.html')) but seldom and then only from a mixture of other humours, its symptoms are compound, i.e. heat, and yellowness in the body, and a kind of bitterness in the mouth and spittle; and if he *be wont to take* roasted things prior *thereto*, and garlic, pepper *with* fish, or (with) moist things, for that produces a compound humour from choler and phlegm.


#### 8


If the paralysis come from an imposthume, it is accompanied by fever, with hardness in the member, *and the pulse* is obscure, weak and disorderly, the urine is white, thin, and sometimes like the urine of a brutish beast;[587](javascript:footNote('T600008/note587.html')) another time it is high*-coloured* on account of disease of the reins, or fever, or other illness that accomplishes[588](javascript:footNote('T600008/note588.html')) it. The sick side is cold and freezing, as though it were in ice, and the other healthy side, hot as though it were on fire; sometimes the eye gets smaller, and the mouth becomes crooked; at another time the hand shakes on account of the conflict there is between nature and the disease, as **Galen** says; for the heaviness and matter of the disease press down and the weakened force cannot resist it altogether, but it does what it can and gives a heave upwards, but since it cannot keep the weak member


---

p.255






in its own proper place, forthwith it *i.e. the member* trembles.


#### 9


Prognosis of paralysis here. If trembling come to the paralytic, it is a good sign. Item if he become feverish, is a good sign. Item if he on whom is the sickness be old, the cure is difficult, or impossible. Item if the paralysis come from the crushing of the nerves, or their cutting across, it cannot be cured.


#### 10


Item *if* young people have fever, and have green urine, it shows that paralysis, or cramp, is coming. Item if one have a fever, with great pain in the head, and when the fever ceases the pain remain,[589](javascript:footNote('T600008/note589.html')) with **plethora** and heaviness; then paralysis often follows; for nature expels[590](javascript:footNote('T600008/note590.html')) the matter from the brain to the nerves, with evacuation of heaviness, but not with complete purging. Item the cold in the first stage tends to confusion[591](javascript:footNote('T600008/note591.html')) *of mind* and spirit; and moisture in the second stage, after the cold, and therefore paralysis is seldom produced by heat.


#### 11


Item the man who has frequent nightmares perceives[592](javascript:footNote('T600008/note592.html')) it by apoplexy, or paralysis, or epilepsy. Item he who suffers from jumping[593](javascript:footNote('T600008/note593.html')) in the body (throbbing?) usually accompanied by weakness, and confusion of perception, and stupor of the members, is ripe for paralysis, unless the phlegmatic humours be purged.


#### 12


The cure of paralysis is accomplished generally *and

specifically*. The general regimen[594](javascript:footNote('T600008/note594.html')) is sometimes completed by 


---

p.257






a part of the disease according to its property; and at other times by diet. The first of these[595](javascript:footNote('T600008/note595.html')) is carried out by putting things on the back of the head; for this disease comes mostly from the origin of the nerves which is the back of the head; and this cure is possible for other diseases of the nerves, such as tortura, cramp, and tremor.


#### 13


The second thing is accomplished by medicaments possessing virtue and specific properties that comfort the nerves; as wolf's lard which comforts the cold nerves, and the dregs of oil made from flax, and agaric; and other moderate operations, such as laurel oil, and oil of **costus**.[596](javascript:footNote('T600008/note596.html')) And he says, treacle[597](javascript:footNote('T600008/note597.html')) is good in every disease of the nerves that comes from cold, if it be boiled in water of anise, and leaves of rue, and sage, the which avails in every season against these diseases. **Mesue** says, it is good at the beginning of these sicknesses, as it digests and thins the matter, and corrects the malice of the cold complexion;[598](javascript:footNote('T600008/note598.html')) they avail after the digestion, as they purge, and disperse the remainder of the matter, and have specific properties for comforting the nerves: the proper amount to give thereof is drachm 1½.


#### 14


The third of the above-mentioned thing is carried out by a paucity of food and drink, and a diet that makes for dryness, and contains some comforting specific for the nerves, such as the brain of a hare, and thyme, hyssop, pepper, pelletory, or the broth of an old cock which shall be driven about[599](javascript:footNote('T600008/note599.html')) till it is buried.




---

p.259


#### 15


The following are the things to be avoided in this case: coitus frequens, sleeping after much food, drunkenness, and drinking cold water, a drink immediately after food, and much wine when fasting, because it causes the matter to penetrate to the nerves.[600](javascript:footNote('T600008/note600.html')) Every sour thing should be avoided, or *the letting of* a vein, or remaining long in a bath; the fumes of quick-silver; vinegar, apples, or heavy work after food. Avoid cold air, and every very cold thing especially to the feet, hands, and head, and drink but little, and suffer hunger.[601](javascript:footNote('T600008/note601.html'))


#### 16


The proper regimen is carried out by four things.[602](javascript:footNote('T600008/note602.html')) The first of them, is the digesting of the matter; the second, its expelling; the third, the converting of the remains of the matter to its contrary;[603](javascript:footNote('T600008/note603.html')) the fourth, the correcting of the accidents. The first of these is accomplished by things that transform the matter;[604](javascript:footNote('T600008/note604.html')) and let this digestive syrup be made to that end. [rx ] Fennel seed, parsley, wild carrot, anise, sage, mountain sage (lavendula), calament, primrose, betony, southernwood and avens: a fistful of each; ginger, pellitory, burdock, long and black pepper, dried rue, **aristolochia**, laurel berries, mustard, gentian; drachm i of each. Stamp, and boil, and strain them, and make thereof a syrup as is meet with honey.


#### 17


Item another syrup that is good against every cold

disease of the nerves, according to **Johannes Mesue**. [rx ][605](javascript:footNote('T600008/note605.html')) Foxglove drachm4&12frac;; thyme and calamint ounce i of each; anise, and pellitory, scruple6 of each; long pepper drachmiii; ginger, cinnamon, calamus aromaticus and saffron drachm1&12frac; of each. Tie up the latter[606](javascript:footNote('T600008/note606.html')) things in a linen cloth, and make a syrup of them, along with honey


---

p.261






and sugar, and the amount that is meet for him thereof is drachmii with water wherein is boiled spikenard and sage.


#### 18


Item a piment,[607](javascript:footNote('T600008/note607.html')) which is made thus *avails*. Take a galon of good old wine, and 2 lbs of honey, removing its froth, sprinkle on this drachmiii. of cinnamon; spincanard drachmi; ginger drachmiv, drachmi of mace; and drachmiv (quart. i.?) lign aloes]; drachmii of dried sage; and drachm1 of saffron. Give them a little pounding;[608](javascript:footNote('T600008/note608.html')) and put them in a close linen cloth *to strain*, the which is good for cold of the stomach and liver, against their softening, and windiness, and it sweetens the breath.


#### 19


If it be produced by melancholy, let it be digested in the following manner:— [rx ] Take roots of radishes and water plantain,[609](javascript:footNote('T600008/note609.html')) lily, peony, equal quantities of each; bruise, and soak in vinegar and wine for a day and a night. Then take sage, and mountain sage, and great germander, thyme, calamint, cinquefoil, hyssop, a fistful of each; drachmi of anise and seed [*...*] fennel seed, yellow flag; ouncei of nutmeg ouncei½ of cinnamon; ounce1 of borage flowers, and ounce1½ of ashen wood bark and ounce1½ of bark of aspen; and 1½ lbs of honey; and boil in water wherein is quenched red-hot iron. If the weather be hot, and the person young, hart's-tongue may be mixed with it; and that is syrup of radishes. If it proceed from sanguine humour, let it be digested with **oxymel diuretica**, or **pliris dianthos**; **diacastoreum** in cold age and cold weather, after purging.


#### 20


The second partial thing mentioned, is accomplished by appropriate evacuations; but administer not strong purging at the beginning of the matter, lest the force turn to weakness; nor draw off the thin things and leave the gross undrawn. Give the sick man a laxative clyster at first, if he have constipation.




---

p.263


#### 20


[rx ] centaury, and the two kinds of mallows, mercurial, southernwood, rue, an equal quantity. of each: boil, and add drachmiii of common oil; drachm (?) ix, salt[610](javascript:footNote('T600008/note610.html')) and bran; and drachm1 ½ of **hiera pikra** **Galeni**. Make of these up to a pound and a half, and the matter may be digested again separately by degrees.[611](javascript:footNote('T600008/note611.html'))


#### 21


Item let the matter be evacuated without injury with agaric, and **turpeth**, and **hiera pikra** **Galeni**, and after the purging make the following clyster for him:— [rx ] primrose, and watermint (?),[612](javascript:footNote('T600008/note612.html')) calamint, wormwood, mustard, avens,[613](javascript:footNote('T600008/note613.html')) polypody, mallows, mercurial; and make of them a clyster, together with a little salt, and butter and oil.


#### 22


The third method mentioned, is carried out by a gargarism, and things that purge the head.[614](javascript:footNote('T600008/note614.html')) A head-purging gargarism is made, by boiling mustard, and pellitory, flag flower, **staphisagria**, hyssop, and calamint, along with a little vinegar.


#### 23


The fourth intention is accomplished by rubbing the limbs; and by ointments, emplaisters, and bathing. Rub the back of the head often, and extreme parts frequently,[615](javascript:footNote('T600008/note615.html')) and dry[616](javascript:footNote('T600008/note616.html')) the head with lily roots and a clean cloth.


#### 24


Item when a remedy is applied to the sick limb, it is proper to observe and change it frequently; for it sometimes ulcerates and heats overmuch, but with the cold of the limb it is not noticed. If the member be red and swollen, and when lain on become white, that is a good sign, but if it do not that, and its own redness remain therein, it shows the limb has been *too much*[617](javascript:footNote('T600008/note617.html')) heated, and if there be sores on it, so much 


---

p.265






the more certain that the cure should be changed. If he can endure it, rub the limb with fenugreek, and ground ivy, together with urine, as the unnatural things should be drawn to dryness. So *things* roasted with spices are good for them,[618](javascript:footNote('T600008/note618.html')) and moist meat powdered, and let them consume but little food and drink, for the space of six days. Then take calamint, and camphor,[619](javascript:footNote('T600008/note619.html')) sage, onions, wild sage, avens, primrose, ground ivy, plenty of them, bruise them, and add gander's lard, that of a dog and a black cat; pepper, drachm1½.[620](javascript:footNote('T600008/note620.html')) Then place them in the belly of a black cat, having removed the inwards and its skin from it. Roast the whole, and collect the juice that comes out of it in this way, and rub it on the sick limb. The comfort derived therefrom is marvellous, and the ointment is named after the cat.[621](javascript:footNote('T600008/note621.html')) Ointment of gander is good in a cold disease, as in cold gout.[622](javascript:footNote('T600008/note622.html'))


#### 25


Item there are members in paralysis that ointment cannot be rubbed on, such as the tongue, the womb, and the nerves[623](javascript:footNote('T600008/note623.html')) of the bladder; in this case they say to rub the remedy on the back of the head, and to rub[624](javascript:footNote('T600008/note624.html')) the tongue and wash frequently with usque*baugh* and a gargarism. Let the **usque baugh** be rubbed often on the back of the head, the tongue, and the paralysed limb, and it restores the speech, as has been proved on many people. A little of this water[625](javascript:footNote('T600008/note625.html')) is meet with honey, or wine, at times to reduce the disease and at times in the middle of a meal, mixed with soup or syrop, or an electuary.




---

p.267


#### 26


Then make an emplaister round the member, with mustard, and honey, and rue, and coarse salt;[626](javascript:footNote('T600008/note626.html')) or let it be compounded of hot gums gathered in one place; such as **galbanum**, **opopanacum**, **serapinum**, **bdelium**, myrrh, masdix, **laudanum**, **euphorbium**, **castoreum**, and other gums, and the like. Make a bath[627](javascript:footNote('T600008/note627.html')) for the sick man then with the following herbs: sage, and wood sage (lavendula), primrose, penny royal, yellow flag, hoarhound, fennel, nettle, camomile, and ground ivy.


#### 27


And make this wet bath for him after the emplaister; and scour the body with water wherein an entire fox is boiled until its flesh separate from the bones; *and with* rue and flagflower, and caroway, and peony, herb of paralysis and vervain. Then let the horn[628](javascript:footNote('T600008/note628.html')) be still frequently applied to the roots of the nerves, and finally a little wine, hot, may be given, and let the member be raised and rubbed often with the hand, and hap it up well in the skin of a fox or with other skins(?).[629](javascript:footNote('T600008/note629.html'))




---

p.269


I. Idropis est et cetera.
-------------------------


#### 1


Hydrops is an error of the unifying force in the entire body, following the change of the *digestive* force[630](javascript:footNote('T600008/note630.html')) *in the liver* [*...*] of the nutritive *force*[631](javascript:footNote('T600008/note631.html')) this attractive force is, and the nutritive force completes its work because of these four forces; and when one of them is wanting, then all are astray, as such is the liver on account of the gall bladder; and **Averroes** says *if* one force be strong and uncorrupted, the body is in its proper state, without a doubt.


#### 2


Indication of the approach of dropsy, and more especially tympanitis. **Galen** says on the 4th section he wrote:[632](javascript:footNote('T600008/note632.html')) Whosoever says he, has a griping[633](javascript:footNote('T600008/note633.html')) pain, below the navel, and below the reins, which does not cease on going out,[634](javascript:footNote('T600008/note634.html')) or with other remedies, he passes into a dry swelling called tympanitis. Another indication that it has begun, is swelling in the stomach after food, which remains long there; and if the belly resound on being struck like a tympanon, or drum, and flux does not ease


---

p.271






the sick man, nor reduce the belly, according to its weakness (?), that is a sign that it (dropsy) is consolidated therein.[635](javascript:footNote('T600008/note635.html'))


#### 3


Item the urine in this species, is thin and sometimes high-*coloured*, but less often high here, than in the species called **ascites**; for **Galen** says this form is produced by heat, not by great heat, nor great cold, but by medium heat. Usually there is more heat in the liver, and the urine is thicker in **ascites**, because of the humours present therein. Item the pulse is rapid and hard, on account of flatulence.


#### 4


Signs of the approach of *that form of* dropsy called **ascites**: an evil hue on the face, turning to yellowness; the urine frequently high-coloured, nor does he notice much inconvenience[636](javascript:footNote('T600008/note636.html')) thereby; yellowness in the eyes often, and oppression in the right side below the rib*s* after walking, or riding, or after food, or travelling on foot,[637](javascript:footNote('T600008/note637.html')) or any other labour.


#### 5


Item a sign that the swelling called **ascites** has set in, is swelling in the feet, and lower limbs; the rising up of the navel; the upper members alter[638](javascript:footNote('T600008/note638.html')) i.e. the face, neck, breast and hands. Item the urine is high-coloured, thick, and scant, frequently with saffron-coloured froth on it, and is of two colours: sometimes the eyes swell through the fumes rising towards them from the liver.[639](javascript:footNote('T600008/note639.html')) The sick man has difficulty in drawing breath, a dry cough, unquenchable thirst, lack of appetite[640](javascript:footNote('T600008/note640.html')) for food on account of the excess of drink, and the appetite therefor. If the abdomen be struck, it resounds like a tympan, or two vessels half full.


#### 6


Indications of the approach of the swelling called **hyposarca**: stoppage of the excess matter that is wont to flow, such


---

p.273






as haemorrhage, *haemorrhoidal* and catamenial, sweat, and urine; the face becoming paler than usual; excessive appetite for food, or lack of the same; a kind of swelling in the testicles; and **plethora** of humours in the whole body.


#### 7


Indications that the disease known as **hyposarca** has set in: soft swelling thoughout the whole body, and if you take hold of it hard with your finger, it forms a furrow.[641](javascript:footNote('T600008/note641.html')) The abdomen is not so swollen as in the other forms; the pulse undulating and broad; the first digestion[642](javascript:footNote('T600008/note642.html')) whitish and excessive, whereas in the other two forms it is of the colour of blood; the urine is high-coloured at times, not from heat, but from weakness of the digestive force in the liver, which cannot separate the blood from the wateriness of the urine.


#### 8


Therefore the symptoms of dropsy show but two varieties; special symptoms and general symptoms. We have spoken already of the special symptoms.[643](javascript:footNote('T600008/note643.html')) There are but three general symptoms i.e. swelling of the feet and soles, an evil colour on the whole body, swelling in the eyes from the weakness of the natural heat; and because the vapour is not expelled to the pores of the body by reason of the weakness of the evacuatory force, it is banished to the upper[644](javascript:footNote('T600008/note644.html')) limbs, the force being tired.[645](javascript:footNote('T600008/note645.html')) And because the digestion and the natural heat are weak there, it returns to the feet, and causes windiness and swelling.


#### 9


If it be asked, whence it comes that the feet swell more in hydrops, than the hands, I say as does **Serapion**, that the hands are near the heart, and therefore the pulse is taken at


---

p.275






the wrist (hand); the heart is the source of the natural heat, and the feet are far off therefrom, and so they are far from the source of heat and therefore death starts from the feet, as **Galen** says. For this reason surplus matter is better digested and consumed in the hands than in the feet. Another cause: as it is proper and natural for gross matter to fall down, therefore swelling is more proper to the feet than to the hands.


#### 10


Signs of the proper causes of dropsy, the which are not signs of the species. Dropsy produced by the stomach, the intestines, and the veins known as meseraic, is recognised by continued diarrhoea beforehand, having no colour of blood. When it comes from the liver, it is recognised by a hard cough and by the excess of the first digestion being hard.[646](javascript:footNote('T600008/note646.html')) The dropsy that comes from an imposthume is known by the bloody colour of the flux: that from the spleen by the colour turning livid, or ashen, and preceded by pain in the spleen. When it proceeds from the reins, the appetite is strong,[647](javascript:footNote('T600008/note647.html')) and there is pain and oppression round the kidneys, behind them, and just a very little above the belt of the trousers, or a little below it.


#### 11


Note, **Galen** says **tympanites** commences in the stomach, with which the liver suffers jointly. **Ascites** is formed in the liver, and the other members are in sympathy. **Hyposarca** is caused by the faultiness of the third digestion, with which the liver is in sympathy, but I maintain neither of them is produced without default on the part of the liver.


#### 12


Prognosis of dropsy. **Averroes** says tympany is the worst form, but **Avicenna**[648](javascript:footNote('T600008/note648.html')) maintains that **ascites** is the most


---

p.277






malicious, **hyposarca** the slightest, and tympany medium. And to this I say, **tympanites** is the most malicious form, and the hardest to cure of them all; for it is produced by (weak) cold that weakens the heat, and by restless[649](javascript:footNote('T600008/note649.html')) heat. Therefore many a time, nor leech, nor physician knows what he should do, for if he apply hot things thereunto it increases the matter in the liver and stomach, and causes extreme thirst: if *cold things* be applied the windiness is retained, and the limbs fatten, and if he put cold things on the liver it increases *flatulence* for the liver helps the stomach to digest, and if the liver be weakened, the digestion is weakened, and from this is produced flatulence. *But* **ascites** is worse than **tympanites**, as regards accidents,[650](javascript:footNote('T600008/note650.html')) or it may be said, **ascites** is worse as regards internal cure, and **tympanites**, as regards external,[651](javascript:footNote('T600008/note651.html')) for the swelling is in the stomach, and if it be cut in the thin part, it is death without a doubt.


#### 13


Item the swelling accompanied by fever[652](javascript:footNote('T600008/note652.html')) is worst. Item every sickness is bad that occurs in ague or the swelling, or follows thereafter. Item **Avicenna** says if flux come with the swelling along with blood, it is death. Item should it come in the swelling, without relieving the sick man, it is death.[653](javascript:footNote('T600008/note653.html')) Item a bloody flux,[654](javascript:footNote('T600008/note654.html')) or one as it were congealed blood, is a sign of death, and more especially if the swelling be of long duration. Item if a watery bloodless flux come, it is an indication of health, but if it be immoderate it signifies death.


#### 14


If a *cough* seize him who has the swelling, it is a hopeless sign.[655](javascript:footNote('T600008/note655.html')) And **Serapion** says, it is a bad sign, should


---

p.279






ill-coloured, evil-smelling sputum come with the cough. And to this I say, there are two *varieties of* cough, a dry cough, and a moist, according to whichever it is produced by, rheum, or the matter of the disease. If it come from rheum, it is not deadly,[656](javascript:footNote('T600008/note656.html')) but it is, if produced by the matter of the disorder; therefore **Hippocrates** says, if the cough follow the swelling it is injurious, but not if it precede it. **Serapion**[657](javascript:footNote('T600008/note657.html')) says when the matter of the disease (i.e. the swelling) has the dominance, so much that it causes constriction of the chest and breathing, it is a sign of death, before the end of the third day.


#### 15


Item the dropsy that comes after a hardness in the spleen, is more a sign of health, than that which comes after a hardness in the liver;[658](javascript:footNote('T600008/note658.html')) for the cure is possible in the first case, but not so in the latter, unless he who performs it, be skilful and attentive, and the patient submissive to him.


#### 16


Note that there is no doubt that every dropsy produced by cold can be cured, whereas **Serapion**[659](javascript:footNote('T600008/note659.html')) says no man may be cured of a hot dropsy. I say, this is true as regards its own nature, but it may be cured by skill; or else I say thus: that hot dropsy is not cured *but* with difficulty and great labour, the force of the patient being strong, and he having a good strong complexion. Or else I put it this way: dropsy can be cured at its inception, and when on the increase, but this is not possible[660](javascript:footNote('T600008/note660.html')) later than the static period. This doctor[661](javascript:footNote('T600008/note661.html')) says, he has


---

p.281






seen people in every kind of dropsy who had a waist measurement of 25" more than their wont, whom God willing, he cured; but he took no one of them to cure him for certain, as it is not proper in this case to promise, except on condition. Should a man suffer from madness and dropsy befall him, it cures the causes of the madness, for the dropsy[662](javascript:footNote('T600008/note662.html')) moistens it (?) according to **Averroes**.


#### 17


Item it is better at the inception of the swelling for the belly to be dry, than moist and lax, for it shows that the force is active, unless there be a hot imposthume[663](javascript:footNote('T600008/note663.html')) in it, which dries the refuse. Item should a sore appear on the body through the evil complexion of the blood, or in the mouth, through the malice of the vapours and flatulence, that is a sign of death. Item in dropsy, should an evil odour come from the whole body, the breath, the spittle, the sweat and other things that proceed from the body, it is a sign of death; for the fetid smell signifies corruption therein.


#### 18


Item **Hippocrates** says, if ulcers break out on the body[664](javascript:footNote('T600008/note664.html')) in dropsy it is not easy to cure them, for ulcers do not heal till they are dried, and it is not easy to heal these wounds, nor to dry them, as they themselves (the sufferers) are full of evil ‘accidental’ liquid. **Avicenna** says if there be ulcers in a member of evil complexion, or sores, they are not curable, or if they are cured, it is long in doing, for instance, *in the case of* the sufferer from dropsy or lepra.[665](javascript:footNote('T600008/note665.html'))


#### 19


Item should there be two colours on the urine of him who has the swelling, it is a sign of death; that is, were


---

p.283






it red below[666](javascript:footNote('T600008/note666.html')) and leaden-coloured on top, or ruddy on top and black below. Item **Hippocrates** says, if in dropsy there be a pain round the liver caused by flatulence, and there come fever thereafter, it cures it.[667](javascript:footNote('T600008/note667.html')) So it may be said, **tympanites** may be cured, if fever *come* in its wake,[668](javascript:footNote('T600008/note668.html')) for there is pain under the liver, and round it, proceeding from windiness. [669](javascript:footNote('T600008/note669.html'))It is false to say that **tympanites** is cured through fever, for it increases the flatulence by weakening the digestion, and that is a dry dropsy, and the fever likewise is dry; therefore what **Hippocrates** said is untrue.[670](javascript:footNote('T600008/note670.html'))


#### 20


I say with regard to this, that pain is produced in the liver from a hot imposthume or by reason of oppilation or of flatulence. There[671](javascript:footNote('T600008/note671.html')) is fever with the pain that comes from an imposthume, and little pain is caused by oppilation, as there is more heaviness therein than pain. As to[672](javascript:footNote('T600008/note672.html')) the pain that comes from gross flatulence without fever, if fever supervene, without a doubt it cures it. Now as to the reason. I say there is no pain in the liver in **tympanites**, but only in the stomach, and in the guts, and the fever does not benefit the flatulence[673](javascript:footNote('T600008/note673.html')) in the stomach.


#### 21


Item dropsy attacks the child in its mothers womb, through her eating much cold fruit, and whitemeat, the which is recognised by the size of the abdomen, and the excessive motion of the pregnancy; and when the time of birth comes


---

p.285






unless she be relieved, they will both die.[674](javascript:footNote('T600008/note674.html')) Therefore it is a great error for a pregnant woman to eat much fruit, and whitemeat. Item if the swelling seize a woman, and she get over it *and later become pregnant*[675](javascript:footNote('T600008/note675.html')) the pregnancy is wont to fall into dropsy, for the blood whereof it is formed is entirely watery, wherefore it is easy for it to fall into dropsy.


#### 22


Of the cure of dropsy here, the which is twofold: proper and common. The proper consists in varying many species (spices?)[676](javascript:footNote('T600008/note676.html')) and herbs proper to it, and arranging meetly for the cure. The common remedy consists in drawing off the watery fluid, and drying it up. **Constantine** says this drawing off is done in four ways. The first, by giving things that excite the urine, such as spikenard, and **cassia linea**; the second by drawing off the wateriness by sweats, by vomiting, and by clysters, which are made of agaric and juice of iris.[677](javascript:footNote('T600008/note677.html')) The bath for drawing the sweat[678](javascript:footNote('T600008/note678.html')) is made with sulphurous[679](javascript:footNote('T600008/note679.html')) or sea water, or by the fumes of water wherein are boiled pellitory, lovage and bran, or by hot ointments, as arraton abatis and agripa.[680](javascript:footNote('T600008/note680.html'))


#### 23


The third way whereby it is purged, is for him on whom is the swelling,[681](javascript:footNote('T600008/note681.html')) to drink his own urine, which heals it forthwith, and also jaundice when it comes from the spleen; and whey of goat's, or cow's milk clears off this same water *likewise*. The fourth way of drawing off the water is by making an incision of the breadth of three fingers, below the navel; or


---

p.287






by scarifying between the joints of the back,[682](javascript:footNote('T600008/note682.html')) or on it itself, or on the soles. Nevertheless this cutting is dangerous, and does not avail but in the swelling called **hyposarca**; as **Avicenna** saith, when the belly is full of water, and the force strong, *let the incision be made* and let the matter be emptied by degrees, so that it be not all evacuated at the same time.


#### 24


Concerning the things we said a while ago, may ye know (that) the following are the hot things which induce urine: anise, fennel seed, cumin, peony, spikenard, **cassia linea**, asarabacca,[683](javascript:footNote('T600008/note683.html')) balsam, squinancy, and spica Celtica. These are the hot diuretic herbs: watercress,[684](javascript:footNote('T600008/note684.html')) walwort, hyssop, smallage, yellow flag, lovage, mountain sage (?),[685](javascript:footNote('T600008/note685.html')) parsley, fennel, juniper(?), the two ragweeds, wild carrot, orchis, dittany, wormwood, and the 1ike.


#### 25


Item cold things having the same effect:— sanders, endive, and its seed, dandelion (endive?),[686](javascript:footNote('T600008/note686.html')) scariole, liverwort, maidenhair, lettuce, coltsfoot; the four *greater* cold seeds, melon, citrul, cucumber and gourd; gromwell along with ivory turnings. Item things that avail in either case, the cold or the hot; spikenard, wood sage, maidenhair, endive, hart's tongue,[687](javascript:footNote('T600008/note687.html')) liverwort, sanders, cinnamon, mastyche, nutmeg (**nux muscata**), whey of goat's milk, rhubarb, agaric, and **cassia linea**.[688](javascript:footNote('T600008/note688.html'))


#### 26


Let the special cure be made as follows for the dropsy called **ascites**, which is caused by heat, for it is more dangerous than **hyposarca**: if he have constipation, make him laxative clysters, wherein these things shall be added to the ordinary ones: wormwood, centaury, cumin, parietary, salt, bran and common



---

p.289






oil.[689](javascript:footNote('T600008/note689.html')) Then make him this alterative digestive drink,[690](javascript:footNote('T600008/note690.html')) for it helps dropsical persons, while excess of thirst, and astringents kill them: [rx ] take roots of fennel, smallage, and parsley, an *equal* portion of each: endive, scariole, lettuce, liverwort, maidenhair, a fistful of each; red and white sanders, and the four greater cold seeds, and the four lesser cold seeds, as are, the seeds of lettuce, coltsfoot, endive and scariole, ounce ½ of each; ivory turnings, *roses* ounce 1 of each; nutmeg, drachm 2; cinnamon drachm 3; ½ quart. of liquorice, or 4 pounds of the juice of **plantago**, or else mix it entire therein; ounce ½(?) of sugar, and make three or four ounces thereof, unless he have a cough; add a little vinegar thereto; and should he have diarrhoea, make it with milk, wherein a red-hot iron is quenched. If the sick man be old, add anise, and hyssop, and watercress, and let it be used every day. If a specific purgative be needed, give **triphera saracenica** with rhubarb in clarified whey of goat's milk, with water of endivia; or some of the syrup before mentioned;[691](javascript:footNote('T600008/note691.html')) nevertheless I think little of every laxative medicine in this case, except clysters and rhubarb[692](javascript:footNote('T600008/note692.html')) in purified whey of goat's milk, because all these things do harm, unless there be present very excessive wateriness, and constipation.


#### 27


[693](javascript:footNote('T600008/note693.html')) If the sick man be weak give him any remedy, except that boiled in whey of goat's milk. Nevertheless I maintain, rhubarb does not avail much in this case, for, if taken, it purges choler especially; therefore, *only* a little is meet to give thereof, unless he be jaundiced in the dropsy, or have a fever from choleric humours, or a hot imposthume, when the greatest amount may be given, and it is proper to give it, as it is said


---

p.291






to be life to the liver.[694](javascript:footNote('T600008/note694.html')) It is a clear error for cold people, unless it happen to suit them as regards complexion, and then only a little thereof. And I have often seen it, taken with whey, relax them who suffer from jaundice, because of the amount of choler in them; yet **Avicenna** says in the chapter on the flux called dysentery, that rhubarb is binding to the bowels. This is true when a little is roasted with fire,[695](javascript:footNote('T600008/note695.html')) or else it has that effect per accidens, by comforting[696](javascript:footNote('T600008/note696.html')) the liver, or by drawing the choler which causes the flux.


#### 28


Item this electuary[697](javascript:footNote('T600008/note697.html')) is frequently given: [rx ] sanders drachm 2 of each; *ivory and* charred ivory turnings, drachm 1½ of each; cubebs ounce ½: if there be great heat present, drachm 2 of each seed of the four great cold seeds, and drachm 2 of endive seed; **portulaca**, **lignum aloes**, nutmeg, drachm 1½ of each; and 1 lb. of sugar, the which to be made with water wherein is boiled andivia. Let him use a good measure of it at dawn, but not at bedward, save when he have not supped; for it is not meet to give medicine to the liver, except when the stomach is empty, as is best possible.[698](javascript:footNote('T600008/note698.html')) Sometimes I put in spikenard, in place of **lignum aloes**, the which electuary I have proved in *the case of* many people,[699](javascript:footNote('T600008/note699.html')) and it is a special secret of my own which should be neither prepared for or taught to any one but on first receiving the price of treatment, for it cures within a short space.


#### 29


Then be this emplaister made for him: [rx ] roses, sanders, endives, plantain, barley meal, and vinegar; and let the sick man not lie down;[700](javascript:footNote('T600008/note700.html')) or he may be purged with juice of plantain, **solatrum** or sorrel, the which warm, and add a


---

p.293






little vinegar; soak a linen cloth therein, and apply to the liver, but not to any other part; give him a drachm or two of spikenard every day, along with purified whey of goat's or cow's milk.


#### 30


Should there be fever combined with the hydrops or an imposthume, or if it be caused by stoppage of the menses or of haemorrhoidal flux, a little blood may be let occasionally, for the wasting of blood cools the liver, and carries off the nourishment from the members. **Avicenna** says when there is much evil in the body, and little good, the letting of a vein steals the good with it, and leaves the evil in its own dominion, where it was at first; or understand what he says thus; when the *good* blood is thin, and the humours dense and viscous, and far off from the place where the vein is let, then the vein steals the good blood, and leaves the bad within.


#### 31


And know ye, for all that, that it is good to let much blood often, in these sicknesses caused by **plethora**, in the fever caused by red blood, called synocha, and others of that ilk. It is good at times to let a vein *often* without drawing much *blood* from it, so as to maintain health;[701](javascript:footNote('T600008/note701.html')) for **Avicenna** says it is better to increase the number of times *rather* than the quantity *of blood*; and at times it is good to let much seldom; as in the case of sicknesses accompanied by violent pain, such as quinsy and its like; it is good not to let much blood, neither to let it often, but in dropsy only a little and seldom.


#### 32


Then make an emplaister for the stomach of these herbs: [rx ] mint, wormwood, mastich, camomile flowers, cumin soaked in vinegar, betony, roots of lily, roses *and* sour bread. Do not apply another to him the following day, but let him do this exercise early on rising (?);[702](javascript:footNote('T600008/note702.html'))—let him


---

p.295






lie prostrate, and turn often from one side to the other, and, let him rub himself often with his hands,[703](javascript:footNote('T600008/note703.html')) or let him mount a while on a horse that carries him gently, and when he comes down let him walk in a sandy level place. If he sweat, dry him, and put him in a place where the sun is hot, and let his head be well covered; or he may be put in hot sand, not in a hot oven, as do the people, for there were against that, that he would suffocate, unless his head were outside of it.


#### 33


Then apply a poultice of these to the belly: [rx ] rue, parietary, walwort, cumin, cowdung, and oyster shells; seethe them well together (?)[704](javascript:footNote('T600008/note704.html')) and put hot, on a thin piece of woollen cloth (?), and apply round the navel, as far as the share. When it cools, heat it and put it about him again: this is more efficacious fasting than after food.


#### 34


Then of the following, make a bath[705](javascript:footNote('T600008/note705.html')) for the sick man,[706](javascript:footNote('T600008/note706.html')) but let his head be outside: [rx ] rue, parietary, walwort, calament, camomile, pennyroyal, wormwood, horehound, fennel, ground ivy and tree ivy; equal parts of each. Boil in a well-closed cauldron,[707](javascript:footNote('T600008/note707.html')) from which is a pipe, so that it burn him not, being shut, for want of a place where the head shall go out. The sick man sits on a cushion well filled with bran, or cotton, or unwashed wool, till he sweat, and let him be rubbed with a linen cloth; nor let him consume food nor drink thereon. When the pulse shall be felt to weaken, put him in his own bed, and when cold begins *to be noticed* give him some of the afore-mentioned electuary.




---

p.297


#### 35


Should any of the swelling remain till the morrow, give him a clyster, and the following day apply a partial dry bath (stupe) to his feet and testicles and if there be swelling therein, make a fomentation for him of these herbs: parietary, lovage, parsley, yellow flag, watercress, walwort and meadowsweet. Dry him *lest*[708](javascript:footNote('T600008/note708.html')) the water that rises like vapour from the stupe adhere to him, for it is not meet for those who suffer from dropsy to be washed with water. **Avicenna** says they should not see water, and if so still less should they drink it.


#### 36


If necessary apply an emplaister to the *afore-mentioned* members, of cowdung, saffron and cumin seed, the which cures them: it is not proper to give them any kind of medicine[709](javascript:footNote('T600008/note709.html')) in this case, and many people I have cured here with drinks and digestive clysters in turn, and with partial stupes to the feet *and calves*, and by rubbing water of roses or andivia to these members and the liver,[710](javascript:footNote('T600008/note710.html')) without anything further. But I was long in doing it, for the disease cannot be cured in a little time.


#### 37


Item a remedy approved in a hot case. Take the juice of plantain, and liverwort, and fill it almost full in an earthen pot, the which is closed with a thin hide, and tied up tight. Put ashes on the hide, and put it in an oven, having

taken the bread from out of it; make a low fire beneath the sides of the pot to keep the heat in the oven,[711](javascript:footNote('T600008/note711.html')) and open it thereafter, when it is boiled, and filter, to extract its juice from it; add sugar, and give to drink early and at bedward, which cures, as I have proved on a man whom no other remedy helped; and on giving a little spikenard with it, he passed a gallon of urine on the first day, on the second day another, and another gallon on the third day. I permitted him, not to drink during


---

p.299






that time, but *to have a piece of* candy in his mouth.[712](javascript:footNote('T600008/note712.html'))


#### 38


Note it is not meet to drink these cold things in every *case of the* dropsy called **ascites**,[713](javascript:footNote('T600008/note713.html')) nor to give hot things in all cases of the dropsy called **hyposarca**, without cold things mixed therewith; as ***Avicenna*** says when he speaks of dropsy, that there are varieties of **hyposarca** and *likewise* of **tympanites** and **ascites**; for he says **hyposarca** comes *both* from a hot cause and a cold, and in like wise, **ascites** and **tympanites**.


#### 39


This is **ascites**:—when the lower limbs are swollen, and not the upper, accompanied by a watery sound in the belly.[714](javascript:footNote('T600008/note714.html')) This is **hyposarca**:—when there is general swelling. This is **tympanites**:—when the belly and the navel rise up, and the stomach resounds like a tympanum, from whatsoever cause it come. Therefore it is necessary to look for some indication other than the swelling,[715](javascript:footNote('T600008/note715.html')) such as the pulse, the urine, and pricking (?)[716](javascript:footNote('T600008/note716.html')), pain, and oppression, and see if cold things harm, and hot things comfort; then the cause is cold: this the authors prescribe when they know not the cause of the disease.[717](javascript:footNote('T600008/note717.html')) Therefore, give them weak things at first, that can do no great harm, if the cause be not recognised; when it is not known in the beginning, give common things that avail in every dropsy, as beforesaid.


#### 40


The following medicine can be made up in every *case of* dropsy, whether it be hot, or whether it be cold, provided it be watery dropsy: [rx ] Take roots of fennel and iris, a little of each, endive, maidenhair, liverwort, wood sage, a fistful of each; red and white sanders; drachm 2 of each of these:—


---

p.301






cinnamon and spikenard, a little wormwood leaf, as it is bitter, anise and andivia seed, drachm 3 of each; drachm 1½ of sugar, and make a pound of them. Should it be desired to make it stronger, add [*...*][718](javascript:footNote('T600008/note718.html')) of the limbs because of its penetration.[719](javascript:footNote('T600008/note719.html'))




---

p.303


K. Varioli sunt parva opostema.
-------------------------------


#### 1


Herein is smallpox little imposthumes or pustules, seen in the skin, the which are oft times of a red colour, and dig themselves into the flesh; they are produced from corruption of the catamenia,[720](javascript:footNote('T600008/note720.html')) and are often preceded by. continuous sanguine fever.


#### 2


The cause of this sickness, as **Hali** says, is when nature expels towards the surface of the body, the excess of sanguine humour[721](javascript:footNote('T600008/note721.html')) or *continuous fever arising from a* peccant humour, in one in whom something of the menstrual flow or corrupt boiling blood *remains*; therefrom results the sickness called **variolae** i.e. smallpox, and from the menstrual blood it is formed: and **Averroes** says there is no man who does not contract smallpox, and these are his words:—as an evacuatory force is in every member which sends its surplus from it to another member thence is formed smallpox, and measles, and therefore no man escapes them, and if any one be conceived[722](javascript:footNote('T600008/note722.html')) at the time of the catamenial flow, he seldom escapes without lepra or *other* hateful disease.


#### 3


[723](javascript:footNote('T600008/note723.html'))Avoiding customary exercise sometimes causes smallpox, to seize a man twice,[724](javascript:footNote('T600008/note724.html')) when the matter is not expelled 


---

p.305






entirely the first time. Thereafter let him eat figs frequently, for they expel the matter. *Smallpox* occurs oftener in a hot moist complexion than in a hot dry one, and in little children and youths, rather than in maturity, or old age; for it is not produced in old age but through strength,[725](javascript:footNote('T600008/note725.html')) and in a hot moist land. Isaac says, it never seizes old folk: it comes oftener in spring than in winter, and in a south wind *rather* than a north wind; and staying long in the sun[726](javascript:footNote('T600008/note726.html')) disposes a man to smallpox.


#### 4


And note, it does not seize the child in its mother's womb, for heat is not intense therein, and so it does not cause *the blood* to boil. Yet another reason; the menstrual blood is retained by the heat of the womb, therefore it is neither corrupted nor does it boil. Another reason; that nature gives her attention to the thing she is doing, that is, to creating the limbs.[727](javascript:footNote('T600008/note727.html'))


#### 5


So we understand there are two kinds of smallpox, proper and improper.[728](javascript:footNote('T600008/note728.html')) Smallpox proper is produced by the blood that boils, and this form occurs principally in children, and youths. Improper smallpox is caused by *corrupted* foods


---

p.307






which strong heat[729](javascript:footNote('T600008/note729.html')) draws outward from the inner members to the extremities, and this can occur at any age; and therefore **Avicenna** says smallpox seizes men twice, i.e. proper smallpox and improper smallpox.


#### 6


If the smalipox be caused by sanguine humour, the pustules are pointed on top and broad below, ripen at once, and escape through running;[730](javascript:footNote('T600008/note730.html')) the which is a sign of health; for sanguine humour is the cause thereof, and it is subject to the digestion and is a friend of nature.[731](javascript:footNote('T600008/note731.html')) If the complexion be hot and moist and the wind south in spring, it is certain that it comes from red blood.


#### 7


If from choler[732](javascript:footNote('T600008/note732.html')) the pustules are red in hue, turning to yellow; they are small and round with sharp heads, and prick as though it were a needle, because of the sharpness of the matter. Should there be signs of digestion[733](javascript:footNote('T600008/note733.html')) in the urine, on the day of the crisis, accompanied by a lessening of the pain, fever and the violent thirst; and the pustules define themselves (open?), and liquid come therefrom, that is a *good* sign, and if the contrary *be the case* it is bad.


#### 8


If it be from phlegm *the pustules* are white and broad and hard to digest, the matter corrupting under the skin, causing great itching,[734](javascript:footNote('T600008/note734.html')) more especially if it be from salt phlegm. If a running begin of the colour of copper rust,[735](javascript:footNote('T600008/note735.html')) accompanied by itching, and the urine be raw, that signifies death.


#### 9


If it be caused by melancholy, *the pustules* are leaden-hued at first *becoming* blackish[736](javascript:footNote('T600008/note736.html')) thereafter, and then black;


---

p.309






and moisture gathers not in them; they are large and hard like large warts, the which is bad, for there is no quality in them by which they could mature;[737](javascript:footNote('T600008/note737.html')) therefore they dry and split, causing heart weakness, delirium,[738](javascript:footNote('T600008/note738.html')) and lack of energy, and when this happens, the leech can say, death is at hand. And sometimes two large pustules appear so that one of them is in the middle of the other, the which is bad, for it shows the amount and toughness of the matter; so if the force be weak, it is a sign of death.


#### 10


Prognosis of him on whom is smallpox. It may be said that the white pustules are best when they are few and large; for they come out *easily*[739](javascript:footNote('T600008/note739.html')) the fever accompanying them is low, and lessens on their being opened. If they be white, large, and dense *in number* and do not come one after the other, then it is less serious, than if they come by degrees.[740](javascript:footNote('T600008/note740.html')) If they be white, small and hard, close together, and come out with difficulty, it is bad, for they are produced by thick matter, which kills often quicker than they can be ripened. Should the pustules appear now, and go in again, and be purplish[741](javascript:footNote('T600008/note741.html')) accompanied by weakness of the force, it typifies death; if the force be strong, there is hope of escape,[742](javascript:footNote('T600008/note742.html')) and it is better that the fever[743](javascript:footNote('T600008/note743.html')) precede *the pustules* than that they come first and the fever after.


#### 11


Item if the breathing be good, and the fever lightening, it is a good sign, but should the fever and thirst be acute, with constriction of the chest, it is a sign of death. Item if weakness of the heart supervene, it is a sign of death, for it


---

p.311






shows that the matter has gone to the heart. Item if the matter go to the lungs, it is an indication that death or **phthisis** is approaching; and if it go to the eyes, it takes away the sight, or leaves a web on them; and if they (the patients) be cured badly, it leaves ugly pits on the body.


#### 12


Item smallpox pustules come out gradually, while those of measles come suddenly; if they be green or purplish, heart weakness follows. Item when the breath is evil in this case, an imposthume[744](javascript:footNote('T600008/note744.html')) of the chest is frequent thereafter. Item *cold* air[745](javascript:footNote('T600008/note745.html')) and cold things applied externally cause the matter to return to the guts, and so produce the flux called dysentery.


#### 13


Many things are sought for the cure hereof, but first the matter must be purged by *letting* a vein, and with a little laxative that softens, but not one that draws or dissipates. Second: the matter must be surrounded (?) and changed internally,[746](javascript:footNote('T600008/note746.html')) with acids, unless tightness of the chest prevent it. Third: it is meet to give comfortatives that relieve the sick man, so that they[747](javascript:footNote('T600008/note747.html')) be evacuated, i.e. the peccant matter. Fourth: things should be applied to them to dry them, before they are entirely ripened.[748](javascript:footNote('T600008/note748.html'))


#### 14


If it be from the first thing mentioned, may ye know, should the body be full of humours, or excessive blood, or the force puissant, and the age and other local matters agreeing, then it is meet to let a vein at the inception of the matter, that is, the medial vein, and that at the top of the nose thereafter, (especially in the case of youths) for they preserve the upper members from the malice of the pustules. There is no danger in letting them (i.e. the veins) in children. If it


---

p.313






come from **plethora** of blood, a vein may be let, from the fourth day till the seventh; then let the bowels be moved with **cassia fistula** and violets along with sugar of roses and their juice, and do not give a laxative there, the which is puissant, as in this case it easily turns to flux.


#### 15


As regards the second thing we mentioned, know ye that cold things and styptics are good in this case, and bitters at the outset; therefore sorrel juice is good, and juice of garlic, and of apples, and juice of bitter sloes; but do not give very cold things internally, for they do not avail given *later than* the second day after the appearance *of the pustules*.


#### 16


The diet of smallpox patients should be increasingly cold,[749](javascript:footNote('T600008/note749.html')) composed of barley and oats; and let the sick man take *milk of* almonds. If the fever be strong, make this pottage, wherein is put liverwort, **lactuca**, and scariole; and if the bowels be relaxed, mix with a little plantain. Then a pottage of bugloss may be made, which cleans the blood well, and he may eat figs and almonds, on removing their skins.


#### 17


If it be caused by sanguine humour, violet syrup may be taken,[750](javascript:footNote('T600008/note750.html')) and still more syrup of fumitory. If it be produced by choler, increase the violet syrup, and lessen that of fumitory, as *that* syrup (of fumitory) is common to them both. Sometimes these syrups are thick and hard to drink; if that be so, make this drink to digest them. [rx ] take sorrel juice, liverwort and sampsuchine, a fistful of each; a quarter pound of fumitory juice; borage flowers, violets, roses ounce 1 of each; a quarter and a half of sugar, and a quarter of dried figs;[751](javascript:footNote('T600008/note751.html')) make therefrom a syrup and use, the which digests the matter, whether it be from sanguine humour or choler.


---

p.315





#### 18


It if be caused by phlegm,[752](javascript:footNote('T600008/note752.html')) the matter may be digested with syrup of fumitory and **oxysacchara**,[753](javascript:footNote('T600008/note753.html')) and thus it is prepared. [rx ] take ounce 1 (?) of sugar, 8 lbs of sour apple juice, drachm 3(?) of vinegar, and put in a tin vessel on a fire. Mix well till they come to the quantity of the sugar; then put them in a pipkin: this decoction to be used as an electuary; and is good in quotidian fever, quartan, tertian, and ague. It purges the choler in the stomach; and give it early with wine in hot water.


#### 19


As to the third thing mentioned, know ye, that the following drink serves to expel them. [rx ] ounce 1½ of dried figs, 2 of fennel seed, and saffron, if you fear syncope; boil in 2 lb. of water until it reach the half,[754](javascript:footNote('T600008/note754.html')) sweeten with honey and use: **Avicenna** says it expels the unnatural heat from the heart.


#### 20


Item the following expel the matter to the surface of the body, fennel, smallage *with* sugar, and their juice, roots and seed, together with scented saffron,[755](javascript:footNote('T600008/note755.html')) and elm (?) wherein are boiled dried figs. Then take a scarlet or other red cloth, and put it about the pox; as I did to the King of England's[756](javascript:footNote('T600008/note756.html')) son when this disease seized him, and I permitted only red things to be about his bed, by the which I cured him, without leaving a trace of the smallpox pustules on him.


#### 21


It is necessary to take care not to apply ointments to them, as these would clog the pores; nor to let cold air get at them, unless the weather be warm. If it be,


---

p.317






then let the [757](javascript:footNote('T600008/note757.html')) air be moderated within by sally leaves, and by sprinkling water throughout the house. Tie the sick mans hands or let him have g1oves[758](javascript:footNote('T600008/note758.html')) on regularly, nor let him scratch them (i.e. the pox,) nor touch them with his nails, for that makes the skin ugly. Then take smallage and fennel, warm them by the fire, dip a linen cloth therein, and wrap it round the whole body, for that draws all the matter out and consumes it(?);[759](javascript:footNote('T600008/note759.html')) or else boil fennel and smallage in water with dried figs.


#### 22


If the matter come from melancholy, let it be digested with **oxymel diureticum**, syrup of fumitory, and borage.[760](javascript:footNote('T600008/note760.html'))




---

p.319


[761](javascript:footNote('T600008/note761.html'))
L. Arthritica Passio
--------------------


#### 1


**Arthritica** is a grief of the binding of the limbs, the which sickness the country folk call ‘the pangs’,[762](javascript:footNote('T600008/note762.html')) because it drips to the joints of the members, in the same way that rheum falls, for the passage is narrow through which the matter passes to the members, although there is a kind of rarity therein.


#### 2


There are three varieties of this sickness called **arthritica**:—**sciatica**, **podagra**, and, **cheiragra**. **Sciatica** is a grief in the haunch,[763](javascript:footNote('T600008/note763.html')) and therefore it is called **sciatica**, because scia in Latin is the name of that sinew, and that is the same[764](javascript:footNote('T600008/note764.html')) as the sinew of the hip; this sickness keeps this sinew taut or painful. Therefore is it called **sciatica** (i.e. hip cramp) and the upper end of the thigh-bone moves in the hollow of the upper bone.[765](javascript:footNote('T600008/note765.html')) The name of this bone in Latin is **ancha**, and **vertebrum** is the other name of the bone, from the turning it does in the upper bone, and the sinew mentioned binds these two bones together: though the doctors say that this sinew (?)[766](javascript:footNote('T600008/note766.html')) is insensible to pain, *yet* it spreads to the empty (?) places nearest it, and causes pain therein, and the disease


---

p.321






called **sciatica** is said of this pain. If this sinew were not insensible to pain, there would be pain therein constantiy, from the continuous rubbing together of these parts, and therefore the healthiest man in the world when he moved, would have pain in that member, the which is a lie, for where pain is, there it indicates disease, according to the author.[767](javascript:footNote('T600008/note767.html'))


#### 3


**Podagra** is a pain in the joints of the feet, and in the soles,[768](javascript:footNote('T600008/note768.html')) and from the foot it takes its name, for it is to the foot it goes.[769](javascript:footNote('T600008/note769.html')) And there is swelling in the member in which it is, but not so in the one wherein is **sciatica**, for it becomes emaciated.


#### 4


**Cheiragra** is a pain in the joints of the hands, and the fingers, along with swelling, from the mobility of the matter, and its rarity, and the movement of the hands. And therefore it is called **cheiragra**, as cheiros in Greek is the same as ‘hand’,[770](javascript:footNote('T600008/note770.html')) and it is in the hands it occurs. If there be pain in another member of the body, or in a joint apart from these, such as the back, or the neck, it has no special name, but pang of that member.


#### 5


This is the definition by the author of the disease called **sciatica**: a pain commencing at the two bone-binds (joints) mentioned and descending behind to the buttocks,[771](javascript:footNote('T600008/note771.html')) preventing due movement, and it comes from matter falling in drops. When it is of long standing, it falls (extends) to the knees, to the feet, and to the joints *thereof*, emaciating the member more than is wont, and causing greater pain therein than the pain of any other joint.


#### 6


The description of that disease which is called **podagra**


---

p.323






here: i.e. pain in the lower joints, the feet and the toes, the which spreads to the soles, and increases upward to the hips. It causes swelling in the feet, impeding walking and standing, and softens the soles overmuch; and disposes a man to dropsy.


#### 7


**Cheiragra** is thus described:— pain in the joints of the hands from the fingers to the wrists, spreading till it reach the elbow, accompanied by swelling, the which causes difficulty in bending the fingers. And in my opinion, **cheiragra** and **podagra** are of that species of lepra which is called **elephantia**; and it is the more fitting that their healing should be difficult[772](javascript:footNote('T600008/note772.html')) seeing that they are all caused for the most part by rheum.


#### 8


There are two causes of this sickness, one external and one internal.[773](javascript:footNote('T600008/note773.html')) The passive cause of the disease is: the member takes the sickness to itself by reason of its own weakness, or through the malice of a cold, evil complexion, or through excessive heat, caused by movement[774](javascript:footNote('T600008/note774.html')) or by some external cause that heats the member. As **Galen** says in the second book of Prognostica, it is easy (easier) for the humours to move and flow to members that are moved and heated (?).[775](javascript:footNote('T600008/note775.html'))


#### 9


Another cause is for the member that contracts the disease to be situate below the others,[776](javascript:footNote('T600008/note776.html')) whereby the matter increases in the hips and the feet. Another cause is the weakness of the member whence it arises, not on the part of the complexion, but on the part of its weak, rare composition. Another cause is the width and laxity of the passages. The cause whereby the matter runs to the joints, is by reason of their wideness and emptiness, whereby they take the matter to themselves.[777](javascript:footNote('T600008/note777.html'))




---

p.325


#### 10


This sickness is also[778](javascript:footNote('T600008/note778.html')) caused by sanguine humour or choler, or melancholy; but most often by phlegm, mixed with choler,[779](javascript:footNote('T600008/note779.html')) for otherwise it would not penetrate well. Then, it is also caused by crude humours, and then by choler, rarely by melancholy, the which by reason of its paucity, compared with the other humours, cannot penetrate to the joints because of its hardness, nor to the passages approaching them because of its grossness.


#### 11


The general causes thereof[780](javascript:footNote('T600008/note780.html')) are [*...*] the consuming of viscous foods, such as eels, for these when they are handled cause the fingers to stick together; and windy things, such as peas and beans, for the windiness draws the matter to the veins. Another cause, figs and fried foods, such as rice[781](javascript:footNote('T600008/note781.html')) and boiled wheat; things that give rise to vapours,[782](javascript:footNote('T600008/note782.html')) such as leeks, and onions, and garlic; and every fat indigestible food, such as beef, hard-boiled eggs, and inwards of animals, and every water-fowl possessing web-feet[783](javascript:footNote('T600008/note783.html')): and things that cause eructations, such as new ale, fruits and watery things; lack of evacuation, repletion of food, especially at supper, and a late drink with food.[784](javascript:footNote('T600008/note784.html')) A great cause of this sickness is bad order of meals, that is to eat gross food *first*, then subtle food, and finally gross food again;[785](javascript:footNote('T600008/note785.html')) for the alternation is harmful to them, as also eating to excess.


#### 12


Another cause is much resting, and avoiding customary exercise, coition on the top of much food: hence **Galen** says


---

p.327






eunuchs[786](javascript:footNote('T600008/note786.html')) do not suffer from **podagra**, neither do they become bald. And it is proved that doing this is a great cause of this disease, for **podagra** does not seize youths, until they reach the age of manhood. Another cause thereof is the retention of those superfluities that are wont to be expelled, such as, the catamenia in the case of women, and flux, and avoiding wonted bloodletting. Amongst its causes are running or jumping, excessive horse-riding, or violent walking after repletion, and much wine on an empty stomach, for **Avicenna** says that that injures the nerves.


#### 13


Another cause is when there are crude humours in the body, and they are not expelled by the urine, the faeces, or other arts[787](javascript:footNote('T600008/note787.html')) whereby a man evacuates his excess matter from the body; and if they be expelled to the joints and remain therein, they putrefy.[788](javascript:footNote('T600008/note788.html')) If they be evacuated in the urine, it will have a crude gross deposit;[789](javascript:footNote('T600008/note789.html')) and the man who has this, will not contract the disease, for **Avicenna** and **Galen** say, those who fear an imposthume of the joints, if they give copious crude, raw urine, it saves them therefrom.


#### 14


These are the external causes: violent walking, falling, beating (percussion), sitting long in an over-cold spot, compression of long standing, and custom of overheavy loads[790](javascript:footNote('T600008/note790.html')) and other similar things, the which turn the force to weakness, such as anger and want of sleep. It is a cause thereof when the excess of the second digestion or the third remains in the


---

p.329






body, until expelled. Age (too) helps in generating this sickness, for old folk are more susceptible to it, than the young. Another cause is weakness of the digestion, for when folk arise from a long sickness (are convalescing), they make the error in regimen, also when the disease is checked before enough has been evacuated; for people whose forces are weak on account of long sickness are wont to fall into this disease.[791](javascript:footNote('T600008/note791.html'))


#### 15


Item the seasons of the year aid in the generating of this sickness, for it[792](javascript:footNote('T600008/note792.html')) often comes in the autumn through malice of digestion, and the humours, on account of dilation of the pores in the summer preceding it; and through the violence of the heat in mid-summer at mid-day,[793](javascript:footNote('T600008/note793.html')) and the excessive cold at the beginning and end thereof. It comes in the summer through the dissolution of the humours, and in the winter through the strength of the cold humours shutting in the matter, and by reason of the paucity of evacuation of excess then from the body. So it is clear that these sicknesses come from changes in the weather,[794](javascript:footNote('T600008/note794.html')) and the people of the pangs (gouty subjects) can tell then, that rain and foul weather will come before it does. The cause thereof is frequently sought of leeches, and this is the answer, as **Philaretus** says: wherever there is anything,[795](javascript:footNote('T600008/note795.html')) that that is there, changes to the complexion of the place wherein it is, and therefore when wet turbid weather is at hand, the air becomes moist, gross, cold and turbid, by reason of the higher cause.[796](javascript:footNote('T600008/note796.html')) The sign that


---

p.331






the which is true, is that walls and stones drip, as they were sweating, not from themselves, but from the air becoming gross; and *this air* goes into the mouth and the nose and through the pores of the body, and, as **Galen** says, it changes the body to its own disposition. For the active thing equates[797](javascript:footNote('T600008/note797.html')) the passive to itself;[798](javascript:footNote('T600008/note798.html')) and this is clear in the joints, as it is easier for the air to go into them on account of their emptiness, dilatation, and looseness than into any other part; this[799](javascript:footNote('T600008/note799.html')) is the reason they ache soonest.


#### 16


Item amongst the causes of this sickness is *pain*[800](javascript:footNote('T600008/note800.html')) in another part of the body, such as the griefs of childbed, and menstrual pains; stone in the kidneys, **torsio** (hacking), **rugitus** (wounding) and **tenesmus** (piles),[801](javascript:footNote('T600008/note801.html')) for when the matter disperses, and resolvent medicaments are applied thereto, they consume part of the matter, and the other part becomes attenuated and mobile, and when the pain is not permitted to remain in that spot, it passes to the empty place nearest to itself, that is it penetrates the joint.[802](javascript:footNote('T600008/note802.html')) Item rheum dripping is a cause thereof, and a wrong habit of lying,[803](javascript:footNote('T600008/note803.html')) that is one part up and the other part down, or lying on an over-hard place.


#### 17


Let us speak now of the signs of this sickness. **Avicenna** says it is necessary where there is this disease, to find out whether *it arise* from an evil complexion along with matter, or without it; though it is rarely caused without matter, and without evil humours. If it be produced without matter, it


---

p.333






will be accompanied by pain, but no heaviness or swelling, nor discoloration of the skin; and if caused by matter it is meet to look whether it be simple or composite. If it come from simple matter, then see whether it be caused by phlegm, or choler, or melancholy, or sanguine humour, or by flatulence.


#### 18


If it be caused by sanguine humour, there is great pain in the head, and heaviness according to the amount of the matter; the skin ruddy, except the pain be deep-seated, and therefore [Galen] says, the pain[804](javascript:footNote('T600008/note804.html')) of the body signifies excess of humours, unless it be too deep-seated; the urine is red and thick; the pulse rapid and full; and the pain is greater at the time of red blood, than at any other season. If it be spring time, the same is the more certain;[805](javascript:footNote('T600008/note805.html')) and if the sick man favour foods that increase sanguine humour, and be wont to be jolly[806](javascript:footNote('T600008/note806.html')) with a cheery laugh (?), have a plump body without being fat, and see red objects in dreams, and the age agree with red blood, then it is evident that the matter is caused by sanguine humour. The hip cramp (**sciatica**) produced by sanguine humour, causes pain as far as the knee, and some times to the soles of the feet, the which the letting of a vein helps, provided it be done straightway.


#### 19


If the matter be caused by choler, there is great heat (?)[807](javascript:footNote('T600008/note807.html')) present, and acute tingling pain, though not of long duration, neither is there great heaviness, as the humour whence it arises is light. The colour of the skin tends to yellowness or a clear red; for in the grief caused by red blood, the colour of the skin is darker red than the hue of the body prior thereto, and is relieved by applying cold things, and aggravated by hot.


---

p.335






If the urine be high-coloured and thin, the pulse swift, the faeces yellow, and the season summer, the patient young with a choleric complexion, i.e. lean, brown (?)[808](javascript:footNote('T600008/note808.html')) and light, and make use of foods that increase red bile (i.e. eat choleric foods) [809](javascript:footNote('T600008/note809.html')) and be more afflicted at the hour of choler than at any other [then it is evident that choleric matter is at fault].


