

#Researches in the South of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Researches in the South of Ireland
==================================


Author: Thomas Crofton Croker
-----------------------------


### File Description

Electronic edition compiled by Ruth Murphy , Beatrix Färber

Funded by University College, Cork and  
The College of Arts via the Writers of Ireland II Project 3. Third draft, with enhanced encoding and enlarged bibliographical detailExtent of text: 
114360 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2008) (2014) (2015) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E820000-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions**2. Thomas Crofton Croker, Researches in the south of Ireland illustrative of the scenery, architectural remains, and the manners and superstitions of the peasantry, with an appendix containing a private narrative of the rebellion of 1798; introduction by Kevin Danaher (Shannon: Irish University Press, 1969).
**Further reading**2. Thomas Churchyard, Worthines of Wales (first published London 1587; reprinted London 1776).
3. Edmund Borlase, The history of the excrable Irish rebellion: trac'd from many preceding acts, to the grand eruption the 23d of October, 1641. And thence pursued to the act of settlement, MDCLXII (London: Printed for Robert Clavel, in St. Pauls Churchyard, 1680).
4. Gerard Boate, Ireland's Naturall History (London 1652. Reprinted as 'Gerard Boate's natural history of Ireland', edited, with an introduction, by Thomas E. Jordan, New York 2006).
5. Richard Cox, Hibernia Anglicana; or the History of Ireland from the Conquest thereof by the English to this present Time. With an Introductory Discourse touching the Ancient State of that Kingdom; and a new and Exact Map of the same, 2 vols. (London: H. Clark and Joseph Watts 1689–90).
6. Jonathan Swift, Carberiae Rupes (Dublin 1723).
7. John Loveday, Diary of a Tour in 1732, through parts of England, Wales, Ireland and Scotland, made by John Loveday of Caversham, and now for the first time printed from a manuscript in the possession of his great-grandson John Edward Taylor Loveday, with an Introduction and an Itinerary (Edinburgh 1890).
8. Charles Smith, Natural and Civil History of Waterford (Dublin 1746).
9. William Rufus Chetwood (ascribed), A Tour through Ireland. In several entertaining letters. Wherein the present state of that kingdom is consider'd: and the most noted cities, towns, seats, rivers, buildings, &c. are described ... To which is prefix'd, a description of the road from London to Holy-Head. By two English Gentlemen, (J. Roberts: London, 1748).
10. Charles Smith, Antient and Present State of the County and City of Cork (Dublin 1750).
11. John Lodge, The Peerage of Ireland, 4 volumes (London 1754).
12. Thomas Burke, Hibernia Dominicana: sive historia provinciae Hiberniae Ordinis Praedicatorum [...] (Coloniae Agrippinae (= Cologne) 1762).
13. Edmund Spenser, A view of the state of Ireland as it was in the reign of Queen Elizabeth: written by way of dialogue between Eudoxus and Ireneus [...] to which is prefix'd the author's life, and an index added (Dublin 1763). [A later edition is available online at CELT.]
14. John O'Brien, Focalóir gaoidhilge-sax-bhéarla, or An Irish-English dictionary [...] (Paris 1768).
15. John Bush, Hibernia Curiosa, a letter from a gentleman in Dublin, to his friend at Dover in Kent: giving a general view of the manners, customs, dispositions, &c. of the inhabitants of Ireland [...] collected in a tour through the kingdom in the year 1764, ornamented with a map of the city of Dublin and several copper plates (Dublin 1769).
16. William Lithgow, Travels and Voyages through Europe, Asia and Africa, for nineteen years [...] (Edinburgh 1770) [According to copac.ac.uk first published in 1614 as 'A most delectable, and true discourse, of an admired and painefull peregrination from Scotland, to the most famous kingdomes in Europe, Asia and Affricke'.]
17. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (Dublin 1778). [Available online at CELT.]
18. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom: made in the years 1776, 1777, and 1778. And brought down to the end of 1779. London, printed by H. Goldney, for T. Cadell and J. Dodsley, 1780; Dublin, printed by George Bonham, for Messrs. Whitestone, Sleater, Sheppard, Williams, Burnet, Wilson Jenkin, Wogan, Vallance, White, Beatty, Byrn, and Burton, 1780. [Available online at CELT.]
19. Reverend Mervyn Archdall, Monasticum Hibernicum; or an History of the Abbies, Priories, and other Religious Houses in Ireland, 2 volumes (London 1786).
20. Joseph Cooper Walker, Historical memoirs of the Irish bards, interspersed with anecdotes of the music of Ireland. Also, an appendix. (Dublin 1786).
21. John Ferrar, The history of Limerick, ecclesiastical, civil and military, from the earliest records, to the year 1787, illustrated by fifteen engravings. To which are added the charter of Limerick and an essay on Castle Connell spa, on water in general and cold bathing (Limerick 1787).
22. The Antiquities of Ireland: by Francis Grose (ed. and for the most part written by Edward Ledwich) 2 vols., (London 1791[–94].
23. Charles Jackson, A narrative of the sufferings and escape of Charles Jackson, late resident at Wexford in Ireland: including an account, by way of journal, of several barbarous atrocities committed in June 1798 by the Irish rebels in that town while it was in their possession, to the greater part of which he was an eye-witness (Dublin: J. Milliken 1798).
24. George Holmes, Sketches of some of the Southern Counties, Collected During a Tour in the Autumn, 1797. In a Series of Letters (London 1801).
25. Isaac Weld, Illustrations of the Scenery of Killarney and the surrounding Country (London 1805).
26. Horatio Townsend, A general and statistical survey of the county of Cork (...) (Dublin 1810).
27. T. F. Dillon Croker, 'Memoir of the Late Thomas Crofton Croker, Esq.,' Gentleman's Magazine (October 1854). [Reprinted in 'Fairy Legends and Traditions of the South of Ireland', editions of 1859 and 1862.]
28. Thomas Crofton Croker, Fairy Legends and Traditions of the South of Ireland. First published 1825; republished with a Memoir of T. C. Croker by his son, T. F. Dillon Croker (London: William Tegg 1862).
29. Charles John Robinson, 'The family of Croker', The Herald and Genealogist 8, edited by J. G. Nichols (London 1874) 377–391.
30. John Derricke, The image of Irelande: with a discoverie of woodkarne, 1581; with the notes of Sir Walter Scott, edited, with introduction, by John Small (Edinburgh 1883).
31. John T. Gilbert (ed), A Jacobite narrative of the war in Ireland. First published 1892; facsimile Shannon 1971. [Available online at CELT.]
32. Robert O'Connell, Richard O'Ferrall, Commentarius Rinuccinianus de Sedis apostolicae legatione ad Foederatos Hiberniae catholicos per annos 1645–1649 ed. Stanislaus Kavanagh et al. (6 vols, Dublin 1932–49).
33. Edmund Curtis (ed.), 'The unpublished letters of T. Crofton Croker', Irish Book Lover 28 (1941) 6–12, 27–33.
34. B. G. MacCarthy, 'Thomas Crofton Croker, 1798–1854', Studies 32 (1943) 539–556.
35. John Hennig, 'The Brothers Grimm and T. C. Croker', The Modern Language Review 41/1 (January 1946) 44–54.
36. Richard M. Dorson, 'The First Group of British Folklorists', The Journal of American Folklore 68, no. 267 (January to March 1955) 1–8.
37. Gerard J. Lyne (ed), Lewis Dillwyn's Visit to Kerry, 1809, Journal of the Kerry Archaeological and Historical Society 15-16 (1983) 83–111. [Available online at CELT]
38. Gerard J. Lyne and M. E. Mitchell (eds), 'A scientific tour through Munster: the travels of Joseph Woods, architect and botanist, 1809', North Munster Antiquarian Journal 27 (1985) 15–61. [Available online at CELT]
39. Gerard J. Lyne (ed), 'Rev. Daniel A. Beaufort's tour of Kerry, 1788', Journal of the Kerry Archaeological and Historical Society 18 (1985) 183–214. [Available online at CELT]
40. Gerard J. Lyne (ed), 'Lewis Dillwyn's visit to Waterford, Cork and Tipperary in 1809', Journal of the Cork Historical and Archaeological Society 91 (1986) 85–104. [Available online at CELT]
41. Michelle O'Riordan, The Gaelic mind and the collapse of the Gaelic world (Studies in Irish history) (Cork 1991).
42. R. O'Donnell and B. Reece, 'A clean beast: Crofton Croker's fairy tale of General Holt', Eighteenth-Century Ireland 7 (1992) 7–42.
43. Morfydd E. Owen, 'A Cambro-Hibernian alliance: Maria Jane Williams and Thomas Crofton Croker', Archaeologia Cambrensis 143 (1994 [1996]), 1–36.
44. W. J. McCormack, 'Croker, Thomas Crofton (1798–1854)', Oxford Dictionary of National Biography, Oxford University Press, Sept 2004.
45. Hiram Morgan, The Battle of Kinsale (Bray 2004).
46. Thomas Crofton Croker, The keen of the south of Ireland as illustrative of Irish political and domestic history, manners, music, and superstitions; collected, edited, and chiefly translated by T. Crofton Croker; edited and with an introduction and notes by Neil C. Hultin and Warren U. Ober. Scholars' Facsimiles & Reprints Series, v. 552 (Ann Arbor: 2005).
47. Michelle O'Riordan, Irish Bardic Poetry and Rhetorical Reality (Cork 2007).
48. Thomas Crofton Croker, Legends of the lakes: or, sayings and doings at Killarney: collected chiefly from the manuscripts of R. Adolphus Lynch; by T. Crofton Croker; a facsimile reproduction edited and with an introduction and notes by Neil C. Hultin and Warren U. Ober. Scholars' Facsimiles & Reprints Series v. 557 (Ann Arbor: 2008).
49. Eoin Bourke, Poor Green Erin (Frankfurt am Main 2011).
**The edition used in the digital edition**2. Researches in the south of Ireland: illustrative of the scenery, architectural remains, and the manners and superstitions of the peasantry; with an appendix containing a private narrative of the Rebellion of 1798. Thomas Crofton Croker First edition [385 pages] John MurrayLondon (1824)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the author's introductory *advertisement* and pp 3–344 of the volume.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text represents the edited text.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section (of which there is one); page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Some place-names, personal names, and terms are tagged. Titles of books and poems are tagged. More complete tagging is envisaged in the third draft (2015). Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: By Thomas Crofton Croker (1798–1854)
 Date range: 1812–1822.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] Some words and phrases are in Irish.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [FR] Some words and phrases are in French.


##### Language: [IT] A phrase is in Italian.


### Revision History


* (2014-12-18; 2015-01-07; 2015-01-08) Beatrix Färber (ed.)

* Bibliographic details and names encoding updated; file parsed and validated; header modified.
* (2014-06-17; 2014-07-14) Beatrix Färber (ed.)

* Additions made to bibliographic details.
* (2012-10-29) Beatrix Färber (ed.)

* Encoding of names refined; addition made to bibliographic details.
* (2012-06-14) Beatrix Färber (ed.)

* Encoding of names refined; new wordcount made.
* (2008-09-25) Beatrix Färber (ed.)

* Keywords added; file validated. New wordcount made.
* (2008-01-17) Beatrix Färber (ed.)

* File parsed; header completed with bibliographic details; SGML and HTML files created.
* (2007-12-17) Beatrix Färber (ed.)

* Markup checked; more proofing; file parsing begun.
* (2007-10-04) Ruth Murphy (ed.)

* file proof-read (1), structural and content mark up applied.
* (2007-10-04) Ruth Murphy (ed.)

* Header created.
* (2007-07-09) Beatrix Färber (data capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E820000-001


### Researches in the South of Ireland: Author: Thomas Crofton Croker


### Advertisement


The pretensions of this Volume are very humble, as it consists of little more than an arrangement of notes made during several excursions in the South of Ireland between the years 1812 and 1822. — These I have endeavoured to condense into a popular shape rather than extend by minute detail.


Politics have been carefully avoided; whether this will be considered a recommendation, or a defect, I have yet to learn; but on a subject which has called forth so much angry discussion, I feel neither qualified nor inclined to offer an opinion.


In a Tour through part of the counties of **Cork**, **Waterford**, and **Limerick**, in 1821, Miss Nicholson and Mr. Alfred Nicholson were my companions: — to their pencils this Volume is chiefly indebted for its illustrations; and my best acknowledgments are likewise due to Mr. W. H. Brooke, for the careful manner in which he has prepared my sketches for the Wood Engravings printed with the text.


22d December, 1823.


---

p.3


History and national character
------------------------------



> 1. All only for to publish plaine,
>   
> Tyme past, tyme present both:
>   
> That tyme to come, may well retaine,
>   
> Of each good tyme, the troth.
> 


**Thomas Churchyard**'s Worthines of Wales.


Intimately connected as are the Sister Islands of Great Britain and Ireland, it is an extraordinary fact that the latter country should be comparatively a terra incognita to the English in general, who, notwithstanding their love of travel and usual spirit of inquiry, are still contented to remain very imperfectly acquainted with the actual state of so near a portion of the British empire.


To the facility of its access may in some measure be ascribed the 



---

p.4




regal splendour of **Tara**, the scholastic learning of **Lismore**, or the achievements of Brian and of Malachi, that unfairly usurp the sympathies awakened in our childhood for magic banquets, enchanted castles and the chivalry of the Seven Champions; although the veracity of these marvellous stories, aided by a deceptive precision of date, has been maintained by many Irish historians with a sophistry at once ingenious and absurd. Whether the matter of such old chronicles be false or true, there is now little to be gleaned from those repositories of monkish labour, either of an amusing or an instructive nature.


I have made use of the Journal of a Tour through some of the Southern Counties, as the most convenient means of combining and conveying information derived from various sources, with topographical remarks, and observations on the manners and superstitions of the peasantry. Taking the broad outline of rational and authentic history, since the connection of England with Ireland, my object has also been to illustrate the cause of existing distinctions between their respective children — a difference of so strong and peculiar a nature as decidedly to separate those who should feel united in one common interest, and which, under slight modifications, still threatens to render Ireland the scene of serious disaffection. My labours may be imperfect, and have unavoidably been limited to the districts treated on; yet I can with confidence claim the merit of having been an impartial observer and a faithful narrator of such events as have occurred within my own knowledge.


A general review of the History of Ireland presents few features that will gratify the pride of a native or the feelings of an Englishman. Conquered, without being subdued, a wild and unruly spirit of independence flickered amongst the chieftains from age to age, unextinguished by a deluge of blood: — the faith pledged to the victors was broken at every favourable opportunity; revolt succeeded revolt, and what was by one party considered as treason and rebellion, 



---

p.5




was by the other regarded as just, or at least justifiable: this proceeded from an imperfect and individual, rather than an universal conquest.


The invasion of Ireland by **Strongbow** and **Raymond le Gros** originated more in private speculation than from public circumstances; and it was not until Henry II. had observed the progress made by these adventurers, that he afforded them assistance, which even then was granted with jealousy and suspicion.


A series of centuries present numberless struggles on the part of the Irish to throw off their subjugation to England, the results of which were partial and ineffectual, while the invaders maintained their newly acquired dominion with unyielding grasp, and, confined within a district termed ‘the Pale,’ were continually harassed by ‘the Irish enemy,’ whose internal feuds rendered them unable to follow up any advantage which they obtained.


When Elizabeth ascended the throne of England, foreign invasion and domestic security rendered it necessary to end this protracted system of temporizing, and to complete the conquest of Ireland; and those empowered by the English government carried this intention into effect with unrelaxed severity: ‘These deputies, and the deputies of the deputies, were strangers and soldiers, needy and tyrannical — their duty, conquest, — their reward, plunder, — their residence, an encampment, — their administration, a campaign.’


It would seem that the utter extirpation of the native population was the object proposed: — those entrusted with the prosecution of this desolating policy declare in the public despatches of their proceedings addressed to the queen, that ‘they have endeavoured to make Ireland as a rased table whereon her Majesty might write her own laws;’ and again, ‘that nothing but the sword held over their heads could contain the remaining Irish in subjection;’ — but it is both needless and painful to multiply quotations, when a volume might be filled with similar effusions.




---

p.6


Scenes of massacre and bloodshed, too horrible for relation — of treacherous and wanton murder, where every bond and tie of nature, of honour and humanity were violated, were circumstances of so common occurrence in Irish history at the close of the sixteenth century, as scarcely to excite attention, or awaken feeling, in those who have detailed the events of that era, and who by familiarity with horror seem to have become callous to it.


In the historians of these times, and whose language has been adopted by latter writers, the epithets ‘perfidious traitor’ and ‘notorious rebel’ are applied to every Irish chieftain — terms that almost silence further inquiry; but if the Irish were rebels and traitors, the English were at the same time plunderers and tyrants; their rapacity awakened by the hope of spoil, and their ferocity increased by the view of that property, which violence alone could wrest from its original possessors.


This stage of unprincipled warfare was dignified by a crowd of illustrious men, amongst whom 
**Spencer** and **Raleigh** are conspicuous; the latter commenced his extraordinary and ill-fated career in these scenes of butchery and carnage, and in almost the first action recorded of that young soldier his arms were sullied by the execution of a piece of deliberate cruelty, which called down the censure of his royal mistress on Lord Grey, and will ever remain a stain on the page of British history, notwithstanding **Spencer**'s vindication or rather apology for such conduct.


With the ground obtained from the native chieftains, who were literally hunted down for their possessions, the perpetrators of these atrocities were rewarded; and on the accession of James I., Ireland laid ‘breathless, exhausted and peaceable, only because incapable any longer to raise the arm of war.’


The English settlers now became of advantage to the country which had been so long the field of contest and devastation, and during the tranquillity produced by this exhaustion important and 



---

p.7




beneficial changes were effected: agriculture received attention, manufactures were introduced, gloomy towers were replaced by comfortable mansions, churches were built, and boundaries constructed.


A wish to conciliate seems also to have existed amongst the English; and **Lord Baltimore**, on his return from Ireland to the court of James I., is said to have replied to his Majesty's inquiry respecting the state of that kingdom, ‘That the Irish were a wicked people, but they had been as wickedly dealt withal.’


Still the ancient fire of hatred towards the conquering nation burned in secrecy and silence, nourished by opposing religions, and deriving fresh vigour from this new cause. The fatal dissensions between **Charles I.** and his people awoke the Irish from their trance of allegiance.


The history of this interesting period abounds with perplexity and misrepresentation: the most inhuman actions are charged by each party against the other, but a dispassionate review of these revolutionary events as they now appear mellowed by time into truth, will place some sanguinary points in at least a doubtful shape.


When the forgery of state commissions and other important documents is acknowledged on all sides to be no unusual practice; when the solemnity of an oath was regarded a mere matter of convenience, or a form to serve some particular purpose, which might be absolved or abjured if necessary, and when the actors in these matters are viewed as animated by the irritation of party feuds and feeling, excited by political intrigue, and inflamed by religious rancour and bigotry, should we not pause and investigate every statement with the most scrutinizing strictness?


The conduct of the Irish generally has been severely stigmatized and condemned, too often by those unacquainted with the niceties of the case. A long catalogue of cold blooded murders naturally excites horror, but a series of provocations may rouse the tamest spirit to measures of revenge and desperation; and it will be found 



---

p.8




that there are various and contradictory evidences which require investigation before an impartial opinion can be formed.


‘That Ireland was never conquered has been her pride, but it has also been her misfortune;’ and I believe it will be found that her children have been alternately treated as allies, as rebels, or as slaves; perhaps it may be urged that they have conducted themselves as such; but have the measures of those who formerly governed them been unexceptionable, and has that faith, that honour, and that humanity been inviolably observed, which would call forth reciprocal virtues in a people whose traducers even have not denied their warmth of heart, and capability of ardent and devoted attachment?


The circumstances of **Charles I.**'s reign contain many features of historical importance. It will be recollected amongst the charges most loudly urged against **Lord Strafford** was his arbitrary and rigorous administration in Ireland, regarding that island as a conquered county; a position received with acclaim by the English parliament, and tacitly acknowledged by Charles himself.


The Irish shortly after took up arms and declared their independence, and were proclaimed traitors and rebels by the very same assembly for presuming to maintain the doctrine they had themselves first asserted; nor is this monstrous inconsistency less remarkable for being slurred over and unnoticed by almost every historian.


A few words on the number and character of the parties in Ireland during the insurrection of 1641, emphatically termed by the natives, ‘the troubles’ may not be misplaced, as it is necessary to consider them collectively to form an adequate idea of the confusion which must have prevailed, and as they are oftener found treated in detail with a tedious minuteness than brought under one general view.


**Charles** had a small band of attached followers, headed by the **Duke of **Ormond****, struggling with difficulties, and suffering the severest checks and privations, yet still loyal and faithful in an almost 



---

p.9




hopeless cause. Directly opposed to the Royalists were the Parliamentarians or Republicans, and midway between these were the Irish or Rebels, vindicating their independence and opposed to both, but more strongly to the latter: these were the three great parties. The subdivisions of the Irish are innumerable, and almost appear to be ‘tot homines, tot animi.’ The ‘mere Irish,’ or ancient Septs, had associated to throw off the dominion of England, and establish a monarch of their own nation and religion. ‘The Lords of the Pale,’ or the descendants of the English long settled in the country, who had intermarried with the Irish, less violent than ‘the old Rebels,’ having already too much, sought more power; of these again some were more temperate than others, and, though siding with the Independents, would have readily maintained the cause of Charles on certain, and not unreasonable terms; more were compelled to take up arms in their own defence; and others, chiefly Scots and Northerns, were soldiers of fortune, and adventured their life in the speculative expectation of booty. These various factions were wrought on by the influence and promises of foreign courts, by the agency of papal missionaries, by the claims of kindred and the bond of feudal clanship. Such were the materials out of which that heterogeneous mass called the Confederate Assembly was formed — each jealous and suspicious of the other — influenced by private dissensions and fearful of reposing confidence in their associates.


Some of those who composed the league anticipated the result of this disunion. It is related that early in their proceedings one of the members who had seldom spoken stood up, and, after a profound silence and much expectation, gravely advised the meeting by all means to join with **Cromwell** and espouse his interest heartily, as the only expedient to ruin him; and closed his ironical address by the deduction of former instances where the Irish defeated every cause in which they had embarked, and destroyed those joined with them by their internal contentions.




---

p.10


To perfect the knowledge of these discords and harmonies, the terms ‘claims of kindred and bond of feudal clanship’ may require illustration. Amongst the ancient Irish there existed two laws, termed **Tanistry** and **Gavelkind**, well adapted to an uncivilized state of society, and therefore unfairly styled by Dr. Warner ‘absurd:’ by the first of these laws, possessions descended not according to birthright but to the strongest and most skilful; and by the other, women were excluded from any participation in the property of a deceased relative. These laws, amongst a barbarous people governed by ‘the strong hand,’ proceeded from the necessity of possessing leaders with superior power and courage, and the clan or dependents of each chief were bound together by a double tie called Fosterage and Gossipred — customs that still prevail and affinities that are still acknowledged in Ireland.


The child of every chief was placed out as soon as born, to be nursed by some of his dependents, and the connection of fosterage was thus formed between that child and those of his nurse, who were termed foster-brothers and sisters to the young lord, and the nurse's husband became the foster-father. Sir John Davies mentions that ‘fosterage was considered a stronger alliance than blood, and that foster-children do love and are beloved of their foster-fathers and their septs more than of their natural parents and kindred.’ Campion also tells us, that ‘the Irish love and trust their foster-brethren more than their own,’ and examples Turlogh O'Neale.


The sponsors of the child became likewise united in the relationship of gossip or godsips — a spiritual affinity acknowledged by the canon law.


Such were the ties which cemented clans or factions into an almost indissoluble combination, it being the invariable custom for fosterers and gossips to support each other in all quarrels of whatever nature.


With the Confederate assembly the Duke of Ormond temporized 



---

p.11




until the circumstances of Charles became desperate, when the Irish, with an indifference to the real merits of the question between the Sovereign and the subject, supported that unfortunate Monarch, because he was opposed by those whom they considered as their oppressors, and with a stipulating, yet careless, profligacy, ranged themselves under the royal banner, merging for a time their national views in a chaos of unaccountable contradictions. But the fierce and hasty strides of **Cromwell** awed the Irish spirit into submission; — his commands were decisive and effective, for his cannon were his arguments; and the shattered castles to be seen in every direction are memorials of his astonishing progress, or, to use the canting language of the times, are ‘evidences of the divine vengeance against such perfidious traitors as the Irish — whose name and nation might, with a little more time and treasure, have been utterly extirpated.’


At the present day the common malediction in the mouth of every Irish peasant is, ‘the curse of **Cromwell**,’ being their strongest expression for entire ruin and desolation; and minute circumstances, that occurred nearly two centuries since, are as fresh in popular recollection as the events of the preceding year.


The contest between James and William is well known; — William was victorious because he imitated the rapidity of **Cromwell**; his own declaration was, ‘that he did not come to Ireland to let the grass grow under his feet;’ and by such cheering observations as ‘This is a country worth fighting for!’ — as well as his personal exertions, William inspired his troops with confidence and energy, while James, encircled by bigots, loitered over trivial and ceremonious details, and was overtaken by the day of action. By his individual example William gave a superiority to his soldiers which his enemies felt and acknowledged. — ‘Change Monarchs with us and we would fight the battle over again,’ — were the emphatic words of one of James's most distinguished generals.


The attainder and ruin of some of the ancient nobility followed 



---

p.12




each commotion; — driven into exile, they became the miserable pensioners of foreign courts, and their confiscated estates were lavishly bestowed on English soldiers, from whom most of the present Irish families of distinction are descended. A nation, therefore, whose population is composed of two such distinct parts, requires ages and skilful treatment to become united and to feel a common interest: the one part drooping under the recollection of the loss of ancient wealth and honors, (for such was the feeling of clanship that the peasant identified with his own the fortunes of his lord,) — the other suspicious and unconciliating to those by whom they are surrounded, and fearing the reprisal of what their ancestors had violently seized. It was an observation of the illustrious **Bishop Berkeley**, when speaking of the two nations, that ‘although evidently their mutual advantage to become one people, yet neither seemed apprized of this important truth.’


The difference of relative situation which the English and the Irish have so long held towards each other, the former as conquerors, the latter as the conquered, mutually affected their national character, and both felt proud of marking their dislike to the other on every occasion.


*The one in fear to lose what they enjoy, The other to enjoy by rage and war.’’*

Shakespeare, King Richard II, II, iv




When Castle More, the residence of Barrett, a chieftain of some consequence in the county **Cork**, was pointed out to O'Neil as that of a good Catholic whose ancestors had been settled in Ireland upwards of four hundred years, his reply was, ‘No matter, I hate the English churl as much as if he landed but yesterday!’


The present Irish character is a compound of strange and apparent inconsistencies, where vices and virtues are so unhappily blended that it is difficult to distinguish or separate them. Hasty in forming opinions and projects, tardy in carrying them into effect, they are 



---

p.13




often relinquished before they have arrived at maturity, and are abandoned for others as vague and indefinite. An Irishman is the sport of his feelings; with passions the most violent and sensitive, he is alternately the child of despondency or of levity; his joy or his grief has no medium; he loves or he hates, and hurried away by the ardent stream of a heated fancy, naturally enthusiastic, he is guilty of a thousand absurdities. These extremes of temperament **Giraldus Cambrensis** has correctly depicted when he says, ‘When they (the Irish) be bad, you shall no where meet with worse; if they be good, you can hardly find better.’ With a mind inexhaustible in expedient to defeat difficulties and act as a substitute for the conveniencies of life which poverty denies, the peasant is lively in intellect, ardent in disposition, and robust in frame; nor does he readily despond under disaster, or yield to obstruction; but moves forward in his rugged course with elevated crest and a warm heart: with a love of combat and of inebriation, he is fond of excitement and amusement of any nature.


The virtues of patience, of prudence, and industry seldom are included in the composition of an Irishman: he projects gigantic schemes, but wants perseverance to realise any work of magnitude: his conceptions are grand and vivid, but his execution is feeble and indolent: he is witty and imprudent, and will dissipate the hard earnings of to-day regardless of to-morrow: an appeal made to his heart is seldom unsuccessful, and he is generous with an uninquiring and profuse liberality.


Such is an outline of the Irish character, in which there is more to call forth a momentary tribute of admiration, than to create a fixed and steady esteem. When excitement is withdrawn, a state of sullenness and apathy succeeds, and hence an Irishman surrounded by difficulties and dangers, associated with strangers in a foreign land, is full of energy and expedient; but herding with his own countrymen he no longer appears the same person, and were it not 



---

p.14




for the occasional flash of wit or invention elicited by some unexpected occurrence the casual spectator would pronounce him to be an essence of stupidity and perverseness — yet the strength of attachment to their native land is wonderful, and in banishment or even emigration there is an air of romance thrown around every recollection of the country where they have toiled for mere existence.


In the secluded Irish mountaineer the nobleness of savage nature has merged into the dawn of civilization, that without conferring one ray to cheer or ameliorate his condition, affords him imperfect glimpses of the superior happiness enjoyed by the inhabitants of other countries.


When turbulent and disaffected men agitate such a body, it becomes difficult to tranquillize those who have only life to lose, and every thing to gain. Continued and petty insurrections render this sufficiently obvious. It is not personal dislike to the British monarch, or political objections to the British constitution that have induced the Irish cottagers to appear in arms against both; but the want of superiors to direct and encourage their labours, and to whom they might with confidence look up for support and protection.


A Narrative in which some of the transactions of 1798 are detailed occupies many pages of this volume; written at the time, it contains a faithful picture of the excesses committed by an intoxicated multitude, and the individual privations related in it will not appear singular or peculiarly severe to those who retain the painful recollection of the sanguinary events of that period. The Rebellion of 1798, however, was neither a momentary effort nor an unpremeditated proceeding of the Irish people; it was the result of an organization of considerable standing, and two generations of the peasantry had been trained up to become actors in this event.


As far back as the middle of the last century the peasantry entered into a secret association in the North of Ireland, under the name of **Heart of Oak Boys**, at first professing to resist demands which 



---

p.15




they considered oppressive and unjust; and other associations soon sprung up in imitation of their example, as the **Steel Boys** **Defenders**, &c. In the South appeared the **White Boys**, so called from their practice of parading the country at night in white frocks, committing acts of violence and destruction on the persons and property of the opulent and well affected. The formation of these lawless parties was followed by the Rebellion of 1798, which devastated large tracts and excited in all classes a temporary madness that rivals in detail of cruelty the horrors of the French Revolution, on which event the projectors seem to have modelled their plans, and founded their expectations of success on that of America.


The Political Creed of an ‘United Irishman’ is exhibited in a curious form of examination which took place in the Gaol of **Wexford** and is preserved in **Jackson**'s Narrative. 

> 
> Question. Are you straight?
> 
> 
> Answer. I am.
> 
> 
> Question. How straight?
> 
> 
> Answer. As straight as a rush.
> 
> 
> Question. Go on then.
> 
> 
> Answer. In truth, in trust, in unity, and in liberty.
> 
> 
> Question. What have you in your hand?
> 
> 
> Answer. A green bough.
> 
> 
> Question. Where did it first grow?
> 
> 
> Answer. In America.
> 
> 
> Question. Where did it bud?
> 
> 
> Answer. In France.
> 
> 
> Question. Where are you going to plant it?
> 
> 
> Answer. In the crown of Great Britain.
> 
> 
> 




The associations of Caravat and Shanavest have since the Rebellion disturbed the Southern Counties. It would be difficult to discover the precise object which these wretched men had in view. The collection of arms appears to have been their principal aim; and numerous instances might be mentioned of their refusal to possess themselves of other property when completely in their power. In 



---

p.16




the Central Counties, the Carders, on the contrary, (a name derived from their inhuman practice of inflicting punishment on the naked back with a wool-card,) were in a great measure inflamed by a desire to punish informers and those who took or let land at a high rent. Harassed by the unavoidable distresses of the times, and inflamed by ‘spokesmen’ who had travelled in England in search of harvest work, had seen, and invidiously compared the comforts of the English husbandman with their own privations, the Irish labourer, attributes his sufferings to a partial and oppressive government. ‘Worse nor I am I can't be’ is the result of his reasoning on his present situation and future prospects. Various prophecies and mysterious bodings of the overthrow of the English dominion are also industriously circulated by secret agency throughout the country, that, with such causes, keep alive the embers of rebellion.


During my last visit to the South of Ireland (1821) it was not difficult to discover the lurking mischief which has since developed itself under the direction of the ideal Captain Rock — the modern representative of Captain Right, the Chief of the Whiteboys. Much distress is the natural consequence of such commotions, as those sources are neglected on which the population are dependent for subsistence; and it is in vain to hope for produce where agriculture has not received attention, and where the labourer wields the sword instead of guiding the ploughshare.


In 1780, the Patriots of Ireland, at once numerous and endowed with superior talents, supported by a volunteer army fifty thousand strong, demanded a free trade and a free constitution. **Lord North** was then Prime Minister of England, humiliated by the success of the Americans, and feeling that it would be imprudent to resist claims so well founded, so well advocated in the senate, and so loudly called for by an armed people, acquiesced in the wishes of the Irish nation; obnoxious statutes were repealed, and the independence of the country, as far as was consistent with the British connection, acknowledged. 



---

p.17




Ireland, after shaking off the chains that so long had fettered her, stood for a time upright, and wore a happy and rather a commanding aspect. It was supposed that she would become rich by commerce and well governed by her laws, and that such a season of prosperity would bloom over the land as should blot out the recollection of past miseries, and cause flowers to spring up where weeds and thorns flourished. These predictions were soon blasted, and her horizon became again overcast; popular discontent again reared its head. The French Revolution encouraged faction to grow daring, and patriotism degenerated into rebellion, and rebellion was followed by the Union, which annihilated the constitution of 1780, took from Ireland her parliament, her nobles and her nominal independence; and although it has been questioned whether it has conferred countervailing benefits, none can doubt that since the Union, England looks towards her with a more gracious aspect; many abuses also in the mode of legislation have been removed; and the measure having taken place it must be the wish of every honest mind that it will be made as beneficial to both as possible, and that the bonds of mutual interest and reciprocal justice, will cement the two countries.




---

p.18


Scenery and travelling
----------------------



> 1. These high wild hills, and rough uneven ways,
>   
> Draw out our miles, and make them wearisome:
>   
> And yet your fair discourse hath been as sugar,
>   
> Making the hard way sweet and delectable.
> 


King Richard II. *Act 2 Scene 3*.



The fashionable attractions of Paris, the beauty of the Swiss lakes, and the classic richness of Italy, are inducements of so strong a nature for an excursion of amusement, that patriotism alone can venture to recommend the Sister Isle to the tourist's notice.


It must be acknowledged, when compared with other countries, that Ireland does not afford the same means of gratification; yet the singular character of the people, the romantic tales of their former greatness, contrasted with their present abject state, and the spirit of chivalry, which still survives amongst them, seldom fail, when aided by novelty of situation and incident, to create enthusiasm in a stranger; but the known difficulties of travelling, and want of accommodation, are of themselves sufficient to prevent its selection for the performance of a mere tour of pleasure.


The South of Ireland, to which the remarks in this volume are confined, contains many scenes that may with justice be termed 



---

p.19




picturesque and beautiful as well as stupendous and sublime. Although the immense tracts of barren or imperfectly cultivated country, which spread in wearying extent and impress the mind with melancholy ideas of neglect and dreary grandeur, are unfavourable to the pursuits of an artist, such tracts, by dividing the beauties, probably enhance the value of the scenery where it becomes closer and more rich.


The character of the coast is bold and steep, containing numerous bays and harbours formed by arms of land breasted by rocky cliffs, that proudly rebuff the angry waves which 
*Boil and gnash their white teeth on the shore.’’*


**Dean Swift**, in a Latin poem entitled Carberiae Rupes, has left us at once a correct and poetical picture of the south-west coast of Ireland.


The neighbourhood of the rivers **Lee** and **Blackwater** are highly cultivated, and afford the most favourable combinations of objects and forms. Opposed to their delicious and woody banks, the western districts of the county **Cork**, and the entire of **Kerry**, are wild and mountainous; and the Galtees, an extensive range of many miles, stretch along the borders of the counties **Limerick**, **Cork**, **Tipperary**, and **Waterford**, conferring a dignity on the landscape, which level or unbroken ground cannot possess. The general outline of these mountains is happily varied; though heavy and inelegant shapes are by no means uncommon, yet they are seldom found alone, and rather improve than injure the effect of the sharp and irregular forms with which they are combined.


*Dame Nature drew, these mountaynes in such sort, 
As though the one, should yeeld the other grace.’’*

Churchyard's Worthies of Wales. , p. 109.




Many of their glens and passes possess a sublime sterility that inspires feelings of awe and reverence. Masses of rock are heaped together in unprofitable barrenness, clothed only with the humble 



---

p.20




lichen, and unyielding to vegetation, receive from year to year in vain the alternate changes of rain and sunshine. A stream, broken into several little falls, often foams along the centre of these rugged defiles, or tumbles precipitately over a steep crag with ceaseless plash. In some places, vast stones, rounded by the action of the atmosphere, hang in fantastic elevation as if ready to be rolled down with overwhelming crash upon the spectator beneath, and have been poetically described in Irish song as the marbles that Time and Nature played with when they were young and the world in its infancy. Surrounded by some of the grandest of these mountains lies **Killarney**, 

> 1. Where woody glens in sweetness smile
>   
> As Echo answers from their breast,
>   
> And lakes with many a fairy isle,
>   
> That on a mirror seem to rest.
> 




The beauties of this celebrated spot have been so often and so fully described as to render any thing I could say on the subject superfluous. Although the noble expanse of water and the vast hills that tower in giant strength and pride excite general admiration, to me the great magic of **Killarney** has ever been its seclusion and retirement. The quietude of sequestered dells — still, glassy lakes — and overhanging woods dipping into the water, is unbroken; and the silent spirit of the place diffuses a profound tranquillity over the senses.


The shore of Mucruss Lake is perhaps the most romantic. Worn by the action of the water into numerous grotesque caves, that repose beneath the leafy gloom of luxuriant trees, every irregularity out of which fancy has imaged forth a form is referred with a marvellous tale to O'Donoghue, and each object receives a local importance from antiquated legend. Nor should the less trodden shore of Glengarriff, about ten miles from Bantry, and seated at the head of that bay, remain unexplored by admirers of the ‘magnificently 



---

p.21




rude’ in nature, to whose attention it may be recommended without fear of disappointing their most sanguine expectation.


It has been remarked by more than one artist of eminence, as a comment on the Irish landscape, that the forms of the trees are more graceful and capricious than in England. ‘Your trees,’ said a gentleman to me, ‘partake of your national character, wild and irregular they both assume extraordinary ramifications, that treated with justice by a master hand appear noble features, but of which an unskilful delineator produces only clumsy caricature.’


The oak of Ireland in particular has long been famous. — Popular tradition not only derives the cudgel of every Pat, or as it is figuratively termed, his ‘sprig of Shillela,’ from woods of that name in the county Wicklow, but also the roof of Westminster Hall, and other buildings of the same age; — the timbers which support the leads of the Chapel of King's College, Cambridge, built in 1444, as well as the roof of Henry the VIIth's Chapel, in Westminster Abbey, are said to be of Irish oak; and to these may be added the Wainscotted Chambers of the Royal Library at Paris, founded, *in* 1365, by Charles V. An extensive purchase of the timber of Shillela was made in Charles the II's time by the Dutch, to pile the ground on which the stadt-house is built; and pipe staves were largely exported about that period from Dublin to London.


So late as the close of the seventeenth century, Commissioners were sent over to **Waterford** and **Wexford** by the English government, ‘nigh which places, and in the county of **Wickloe**,’ **Dean Story** tells us, ‘there is good store of suitable timber and other advantages for building ships at easier rates than in England.’


Mr. Hayes, of Avondale, who has written a delightful little volume on Planting, containing much information on the growth and value of Irish timber, observes, that the superior density and closeness of grain, the character of the Irish oak, especially in high situations and a dry soil, (apparent from comparison of its specific 



---

p.22




gravity with that of other oak,) added to the inattention of the Irish respecting the article of bark, permitted the tree to be felled in winter when free from sap, which might have induced English architects to give it a preference in material works; ‘and it must be allowed,’ adds Mr. Hayes, ‘that the present unimpaired state of these roofs, after so many centuries, seems very well to warrant the conjecture.’ Notwithstanding this former abundance of timber in Ireland, trees are at present the grand desideratum of its scenery; and the shattered tower and riven arch of ‘works of old defence’ are often seated in the midst of such unvaried bleakness, that they become worthless in the eye of a painter, as formal and unassociated objects — the general pictorial effect of the landscape is however much assisted by the numerous ruins of abbeys and castles with which it abounds.


To whom shall I dedicate my prints? once asked a publisher, about to produce some Irish views: the reply was, If your dedication is prompted by gratitude, I know of no one more deserving it than **Oliver Cromwell**, whose cannon has made so many dilapidated buildings for you.


Although without the limits of the present work, some notice of the county Wicklow may be expected, its scenery having been so much extolled. Glendalough, Luggielau, and the more southern and remote parts, equal or exceed the descriptions that have been given of their charms. — Aided by many tender associations which crowd upon the memory, my friend C — thus elegantly unfolds them, whilst, with rapid but faithful outline, he delineates the prospect from the eminence of Broomfield overlooking Rossana, the seat of the Tighe family.


‘In the extreme distance ocean and sky mingle together, the gloom of the far promontory that breaks upon the sea-horizon, contrasted with the gay town that smiles upon its side, and the fleet of 



---

p.23




fishing smacks bent upon their evening cruize under its protection — then the line of hills rising beyond the wooded domain of Rossana, and the immense vale, thirty miles in length, terminating in the Croaghan, or Gold Mine Mountain, relieved at intervals by some glittering spire or ambitious mansion that breaks the sameness and vastness of the view. Towards the west rears the Carrig Morilliah, or the beautiful rock, deservedly so called; its extended summit, which is a perfect *sierra*, and graceful descent to the vallies that separate it from the chain of mountains, in the midst of which it stands perfectly isolated, make one of the most singular objects of the picturesque. From its summit as well as from Cronroe, which is beneath and of easier access, may be descried the enchanting Vale of Avoca, ‘the Meeting of the Waters,’ hallowed not only by having inspired the muse of Moore, but for having given to one of Ireland's noblest and most upright sons, the title he so proudly merited — the early friend of **Curran** — **Lord Avonmore**.’


‘Below the rock of Cronroe is the sweet cottage of Mont Alta, where the unfortunate Trotter composed the life of his friend and patron **Charles James Fox**.’


‘And then to conclude this panoramic enthusiasm, the sun sets behind the most beautiful and most terrific of ravines — the Devil's Glen — a torrent breaks into it in cataract from the further extremity, continues its furious course under the walls of Glenmore Castle, and recovers its tranquillity in the silent shades of Rossana, where the fair minstrel of Psyche sung.’


**Powerscourt** and the **Dargle** have certainly been overpraised, and a stranger conjures up in his own imagination very superior features to those of which they are composed. An excursion into the county Wicklow is generally made from **Bray**, a village on the sea-coast, ten miles distant from **Dublin**, where there is an excellent hotel, much frequented by lovers of suburban rustication. The **Dargle** is to **Dublin** what Richmond is to London — the resort of 



---

p.24




holiday folk; but here the similitude ends. It is a little woody dell, and in summer has an inconsiderable stream gurgling amongst rocks of a good colour, but without size sufficient to render them effective or impressive. The trees on the banks are small and stunted, growing very close and straight; and there are shady walks pleasant enough to stroll through with the expected reward of a basket of good prog, to be discussed at the far-famed Waterfall of **Powerscourt**, where a verdant carpet, equal to that of fair Twickenham's meadows, is improved by the shade of high rocks, under which the numerous parties busily commence their eating operations. After a hasty glance around them, and a quickly dismissed ejaculation of ‘How beautiful!’ they prepare to enjoy the water when it shall mix with their wine, and certainly feign no devotion but to the main object of their excursion. Such are those 


> 1. Who on jaunting cars travel to visit the **Dargle**,
>   
> Oh! no 'tis their throats with good liquor to gargle.
> 




The Waterfall of **Powerscourt** has been enumerated amongst the wonders of Ireland, but the extravagant admiration lavished in **Bushe**'s Hibernia Curiosa and other works, on ‘One of the most beautiful Waterfalls in Great Britain or Ireland, and, perhaps, the World,’ for so is **Powerscourt** styled, can only call forth a smile. On beholding it for the first time, I was forcibly reminded of some lines in which it is more correctly pourtrayed. 


> 1. Then thro' Powerscourt we went, to the high waterfall,
>   
> And we saw it and thought nothing of it at all,
>   
> Down the black rock it tumbles like skeins of white thread,
>   
> All fuzzy with spray from the foot to the head.
> 




This cascade is situated in a fine park belonging to Lord Powerscourt, and may be described rather as a steep water-slide than a fall. Miss Nicholson's drawing will convey the most favourable 



---

p.25




idea of it, being sketched immediately under the fall, which thus becomes foreshortened, and is more pleasing than the unbroken effect of its vast height in almost every other situation. It was with considerable difficulty this sketch was gained, as on attempting to reach the most picturesque point of view, we were prevented crossing the stream to the opposite bank, by a man stationed there to express the proprietor's orders, that no person should proceed farther. Having already passed about six gates, where we were detained until they were unlocked by the charm of a silver key, we thought the usual fee only was necessary, but this was refused; by repeated entreaties and his native allantry, the man at length allowed Miss Nicholson alone to proceed to the desired position. On our return we had again to pay at each gate before we were let out of the park; and it would seem there must be a good sum of money distributed here during the summer, as we met more than twenty parties, all apparently receiving the same checks.[1](javascript:footNote('E820000-001/note001.html')) This locking of gates is however but little resorted to in Ireland, as, with the present exception and Lord Doneraile's Park at **Doneraile**, admission was everywhere cheerfully granted and a gratuity unlocked for; but there is generally an inquisitiveness to know who you are, and a stranger sketching is closely watched and followed, to ascertain the reason of his ‘taking off the place,’ as it is termed. Amongst the numerous ludicrous and amusing dialogues produced by this troublesome spirit, one which took place on crossing the River **Blackwater** in the public ferry-boat, may be cited as expressive of the shrewdness and pertinacity usually displayed in pursuit of this object. The boat was crowded with 



---

p.26




passengers, one of whom, an old woman, appeared inclined to enter into conversation with me, by offering several general remarks, to which I made no reply, when, turning round to her companion, she said in Irish that ‘in her opinion I was no stranger in the country, though I wore an English coat, for it was like one which young Mr. Odell had brought with him from London, and that she would soon find out if I had a drop of Irish blood in my veins.’ So far passed in Irish, of which the speaker supposed me ignorant. She then fixed her eyes on me, and with a penetrative look commenced a story in English of a young Irishman ‘who went to foreign parts — to Newfoundland every step of the way, where he wished to be thought a Londoner, and held himself so high that he never would throw a word to one of his own people; and in his endeavours to disguise his native accent, cut up the king's English till there was no substance at all left in it — to qualify it sure;’ and how ‘he was once met by one Mr. Jeremiah Coughlan, an undoubted gentleman 'of the real ould stock,' who gave him, with the advice of never being ashamed of his own country, a sound drubbing.’ Here pointed the moral of her tale, a contrivance to rouse my patriotic feelings, and induce me to speak. The attempt was rendered still more vigorous, and the scene more comic, by the silent assistance of the remaining passengers, who appeared, as if by some tacit agreement, to have deputed the old crone to put me to the question, while they remained mute spectators of the event, only betraying their interest by a fixed gaze, and occasionally a mysterious and approving nod, when the discourse appeared to bear home upon me.


Another subject of unceasing inquiry with the peasantry is the hour. It is generally allowed that those who make the least use of their time are most curious in time-keepers, and you never meet an idle peasant but his first question is — Would your honour be after telling me what's o'clock? No reciprocal information can be gained until satisfaction on this point is given. — And one of my companions used frequently to amuse us by taking out his watch on 



---

p.27




the approach of any person, and as soon as they arrived within speaking distance, would proclaim — It is two o'clock — how far are we from — ? This was, however, a joke to be avoided in cases of emergency, as we found it difficult, with our *most engaging* manners, sometimes to make our way.


In the wild parts of Ireland the pictorial traveller will receive little assistance in his researches from the peasantry, and must rely on his own exertions and enterprize for the attainment of his object. Should he happen to have a slight knowledge of the Irish language, or can get the names of places translated to him, they will often convey a clearer and more correct idea of the spot than can be extorted by dint of cross-examination — ‘Conveniunt rebus Nomina saepe suis.’


Sometimes our united efforts to extort information met with no better success than the following dialogue: — 


‘Pray is this the nearest road to — ?’


‘Is it to — you are going? fait and that's not the nearest road — being 'tis no road at all.’


‘Then had I better go yon way?’


‘Och! indeed and I would'nt advise your going that way at all. 'Tis few people goes that way, for there's a big black dog there, and he'll *ate* you up entirely.’


‘Which way then can I go?’


‘*Fait!* and the best way you'd go is just to be staying where you are.’


The lower classes are generally unwilling to serve as guides in the wild parts of the country, declining the offers made them for such service with all that indifference and quiet humour which **Miss Edgeworth** so admirably delineates; and the difficulty of obtaining assistance appears to increase in proportion with the necessity of the demand.


‘Och! I'd have no objection in life to go *wid* your honour if 



---

p.28




supposing I could just *lave my troat at home*,’ is no uncommon reply to your request, and is intended to express a doubt as to the safety of the expedition; which, considering the period of this visit being that immediately preceding the late disturbances, may be readily supposed to have some foundation; but in vain you seek to learn the cause or extent of their fears, or, in short, to dive below the surface of their thoughts.


‘Do you then fear any danger?’


‘Och! indeed, no particular danger, your honours — only 'tis an ugly way that way, any way I'm thinking — but your honours knows best to be sure *if ye've bisness* there — I'm just *contint* to stay in a whole skin — and there's *ould* Judy, your honours, and the *childer* all looking up to me, and small blame to them — sure its much pace I should get *wid* them in regard of risking their bread, not to mention my own, and maybe I'd be *laving* my bones to whiten out yonder. Och! its out of the way entirely.’


It is not easy to detect the real degree of fear here expressed from the evident exaggeration; yet it would appear there must be some strong motive to deter these very poor people from earning a sum so easily, something more powerful than *the want of taste* for exploring — though it is certain they are, to use their own expression, ‘contint,’ without much exertion. Nothing can be more difficult than to obtain information in point of road, distance, or situation of any object. You seldom arrive within five miles of the truth. When crossing the mountains from Gougaun Lake to Inchegeela, I was told that village was ‘worse’ (more) than three miles from me. After walking about an hour and a half I again inquired — ‘it was worse than four miles.’ The actual distance was about ten. The contradictory answers you get as you proceed are not a little annoying, and at times made us almost hopeless. One of my party, more from curiosity than the prospect of gaining a satisfactory reply, accosted a man respecting the length of a glen from a road on which 



---

p.29




we met him, and where we had reason to believe were some fine waterfalls.


‘How far is it up yonder glen before you come to the waterfalls?’


‘The waterfalls is it? indeed, and its a cross way, and your ladyship would never be getting there.’


‘We heard they were within half-a-mile.’


‘Och! they are not — and no road.’


‘Is there a great fall of water?’


‘I never was there myself, but I know 'tis a great way.’


‘Is it three miles?’


‘Fait! and three miles would see you but a small part of the way.’


‘Is it six miles, do you think?’


‘Och! 'tis up entirely!’


This up entirely, or out of the way entirely, is the conclusion at which you arrive; it seems to imply beyond reach or knowledge, and is frequently used instead of ‘*I don't know*’ to which the Irish cottager has a peculiar aversion, perhaps from the phrase being applied as a term of reproach to any stupid or simple person, coupling it with the Christian name, as Shane Neather, literally John I don't know, implies John the Fool.


The higher classes in Ireland are ever willing to entertain the traveller and assist in the advancement of his journey, *when he has clearly proved it absolutely necessary to proceed*, for it is not a matter of question how to get admittance to the first houses in the country, the dilemma is, how to leave them. To a tourist, with sufficient time at his disposal, this may be agreeable enough; if otherwise circumstanced, he will find it requisite to avoid the delivery of letters of recommendation; for however gratifying a warm and hospitable reception may be, the sacrifice of time to be made in return is beyond all calculation. The over-abundant kindness of the host (for an immediate invitation always follows an introduction) seldom permits his guest the free use of his own senses, and to expostulate is vain. If, 



---

p.30




Dr. Syntax like, he travels with a sketch-book, and states himself in search of the picturesque, he is hurried from one eminence to another, and assured it affords the best view in the country, as extent and beauty, when applied to the landscape, are generally confounded. A party is arranged to meet him at dinner, each of whom requests a visit; one assures him that a most celebrated castle is on his grounds, while another urges the charms of a glen near his residence in a tone it is impossible to refuse. After a journey of some miles and the loss of an entire morning, this renowned castle may prove but the naked walls of an old tower, dismantled of even its ivy garb, and the ‘charming glen’ perhaps turns out to be neither more nor less than the best fox earth in the country. Thus the circle of acquaintances caused by a single introduction, every one leading to others, goes on increasing like the circles produced by a stone when flung into the water.


Letters, however, are needless in obtaining all the attention and assistance requisite; a respectable appearance is a sufficient recommendation to the nobility and gentry, but towards the cottagers a certain courteousness of approach must be observed, ere you can win them to usefulness. If you seek information, the tone of interrogation must be conciliatory, not dictatorial; if shelter or protection, throw yourself at once on their hospitality and you secure a warm and welcome reception.


The most romantic parts of Ireland are little frequented and travellers unlocked for, hence it becomes necessary to study the art of pleasing, which is in this case more valuable than ‘house and land.’ The poorest peasant will freely offer to share his cabin and divide his potatoes with you, though at the same time eying you very suspiciously, inasmuch as, being unable to account for your appearance, he usually supposes you belong either to the army or to the excise — two bodies equally disliked by them. Yet their greatest fears never destroy the national spirit of hospitality.




---

p.31


Having hired a car at **Lismore** to take us to **Fermoy**, and wishing to walk part of the way along the banks of the Blackwater, we desired the driver to meet us at a given point. On arriving there, the man pretended not to have understood we were three in party, and demanded, in consequence, an exorbitant addition to the sum agreed on. Although we were without any other means of conveyance for eight Irish miles, it was resolved not to submit to this imposition, and we accordingly withdrew our luggage and dismissed the car, intending to seek another amongst a few cabins that appeared at a little distance from the road side. A high dispute ensued with the driver, who, of course, was incensed at this proceeding, and endeavoured to enlist in his cause the few straggling peasants that had collected around us, but having taken refuge and placed our trunks in the nearest cabin, ourselves and property became sacred, and the disposition to hostility which had been at first partially expressed, gradually died away. — When we began to make inquiries for a horse and car of any kind to take us into **Fermoy**, our endeavours were for some time fruitless. One person had a car, but no horse. Another a car *building*, which, if Dermot Leary were as good as his word, would be finished next week some time, ‘God willing.’ At length we gained intelligence of a horse that was ‘only two miles off, drawing turf. Sure he could be fetched in less than no time.’ But then again, ‘that big car of Thady Connor's was too great a load for him entirely. Sure the *baste* would never draw the *car* into **Fermoy**, let alone their honours and the trunks.’ After some further consultation, a car was discovered more adapted to the capabilities of the miserable animal thus called upon to ‘leave work and carry wood,’ and though of the commonest kind we were glad to secure it. By means of our trunks and some straw we formed a kind of lodgment on the car, which being without springs and on the worst possible of roads, was not exactly a bed of down. The severe contusions we received on precipitating into the numerous cavities, though no joke, 



---

p.32




caused some laughter, on which the driver turned round with a most facetious expression of countenance, suggesting that ‘May be the motion did not just agree with the lady, but never fear, she would soon get used to it, and be asleep before we were half-way to **Fermoy**.’ This prediction, it will readily be supposed, was not fulfilled, and I believe it was three days before we recovered from the bruises of that journey. It is difficult to say whether our situation will excite mirth or sympathy in the minds of our readers, but a sketch may do no injury to the description.


Many Irish villages boast a post-chaise, the horses for which are not unfrequently taken from the plough, and the chaise itself submitted to a temporary repair before starting, to render it, if the parody of a nautical phrase may be allowed, road-worthy; but the defects are never thought of one moment before the chaise is required;



---

p.33




and the miseries of posting in Ireland have, with justice, afforded subject for the caricaturist. Tired horses or a break-down are treated by a driver, whose appearance is the very reverse of the smart jockey-like costume of an English postilion, with the utmost resignation, as matters of unavoidable necessity. With a slouched hat — slovenly shoes and stockings — and a long, loose great coat wrapped round him, he sits upon a bar in front of the carnage and urges on his horses by repeated applications of the whip, accompanied with the most singular speeches, and varied by an involuntary burst of his musical talent, whistling a tune adapted to the melancholy pace of the fatigued animals, as he walks slowly beside them up the ascent of every hill.


‘Did you give the horses a feed of oats at the village where we stopped to sketch?’ inquired one of my fellow-travellers of the driver, who for the last three or four miles had with much exertion urged on the jaded hacks.


‘I did not, your honour,’ was his reply, ‘but sure and they know I promised them a good one at **Limerick**.’.


Nor is this instance of pretended understanding between man and horse singular. Riding once in company with a poor fanner from **Cork** to **Mallow**, I advised him to quicken the pace of his steed as the evening was closing in, and the lurid appearance of the sky foreboded a storm.


‘Sure then that I would with the greatest pleasure in life for the honour I have out of your company, sir; but I promised the *baste* to let him walk, and I never would belie myself to any one, much less to a poor creature that carries me — for, says the *baste* to me, I'm tired, as good right I have, and I'll not go a step faster — and you won't make me — I scorn it, says I, so take your own way.’


A verbatim dialogue on an Irish break-down happily characterises that accident: the scene, a bleak mountain, and the time, the return 



---

p.34




of the driver with another chaise from the nearest station which afforded one — seven miles distant.


‘Is the carriage you have brought us safe?’


(One of the travellers attempts to get in.)


‘Oh never fear, sir; wait till I just bail out the water and put a little sop of hay in the bottom — and sure now and 'tis a queer thing that the *ould* black chaise should play such a trick, and it has gone this road eleven years and never broke down afore. But no wonder, poor *cratur*, the turnpike people get money enough for mending the roads, and bad luck to the bit of it they mend, but put it all in their pockets.’


‘What, the road?’


‘*Noe*, your honour, the money.’


To such as can bear with composure and indifference lesser and temporary misfortunes, those attendant on an Irish tour become objects of merriment; the very essence of the innate ingenuity and wit of the people is called out by such evils; and the customary benediction muttered by the peasant on meeting a traveller, is changed into the whimsical remark or shrewd reply that mock anticipation.


Of late, jingles, as they are termed, have been established between the principal towns. These are carriages on easy springs, calculated to contain six or eight persons. The roof is supported by a slight iron frame capable of being unfixed in fine weather, and the curtains, which may be opened and closed at will, afford complete protection from sun and rain; their rate of travelling is nearly the same as that of the stage-coach, and they are both a cheaper and more agreeable conveyance.


On our way from **Cork** to **Youghall** in one of these machines, we were followed by a poor wretch ejaculating the most dreadful oaths and imprecations in Irish. His head was of an uncommonly large and stupid shape, and his idiotic countenance was rendered fierce and wild 



---

p.35




by a long and bushy red beard. On our driver giving him a piece of bread, for which he had run beside the jingle at least half-a-mile, he uttered three or four terrific screams, accompanied by some antic and spiteful gestures. I should not remark this circumstance here were it one of less frequent occurrence; but on most of the public roads in the South of Ireland, fools and idiots (melancholy spectacles of humanity!) are permitted to wander at large, and in consequence of this freedom have acquired vicious habits, to the annoyance of every passenger; throwing stones, which they do with great dexterity, is amongst the most dangerous of their practices; and a case is known to me where the wife of a respectable farmer, having been struck on the temple by a stone thrown at her by an idiot, died a few days after. Within my recollection, Cove Lane, one of the most frequented parts of **Cork**, as leading to the **Cove**, Passage, **Carrigaline** and **Monkstown** roads, was the station of one of these idiots, who seldom allowed an unprotected woman to pass without following her and inflicting the most severe pinches on her back and arms; yet this unfortunate and mischievous being for many years was suffered by the civil power to remain the terror of every female, and that too within view of a public asylum for the reception of such. But to return from this digression.


The charges at inferior towns and villages are extravagant in an inverse proportion to the indifference of their accommodation, and generally exceed those of the first hotels in the metropolis. Our bill at **Kilmallock** was any thing but moderate, and yet the house, though the best the town afforded, appeared to be one where carmen were oftener lodged than gentry. The landlady stood at the door, and with a low curtsey and a good-humoured smile welcomed us to ‘the ancient city of **Kilmallock**;’ in the same breath informed us that she was a gentlewoman born and bred, and that she had a son, ‘as fine an officer as ever you could set eyes on in a day's walk, who was a *patriarch* (a patriot) in South America;’ then leading us 



---

p.36




up a dark and narrow staircase to the apartment we were to occupy, wished to know our names and business, whence we came and where we were going; but left the room on our inquiring, in the first place, what we could have to eat. After waiting a reasonable time, our demands were attended to by a barefooted female, who to our anxiety respecting what we could have for supper, replied with perfect confidence, ‘Just any thing you like, sure!’


‘Have you any thing in the house?’


‘Indeed and we have not, but it's likely I might be able to get an egg for ye.’


An examination of the bedrooms will not prove more satisfactory; a glass or soap are luxuries seldom found. Sometimes one coarse and very small towel is provided; at **Kilmallock** the measurement of mine was half-a-yard in length and a quarter in breadth; its complexion, too, evinced that it had assisted in the partial ablutions of many unfastidious persons. Mr. Arthur Young's constant ejaculation when he lighted on such quarters in Ireland usually occurred to my mind, ‘Preserve me, Fate, from such another!’ and I have no doubt he would agree with me that two very essential requisites in an Irish tour are, a stock of linen, and a tolerable partiality for bacon. But travellers, any more than beggars, cannot always be chusers, and those who will not submit with patience to the accidents and inconveniences of a journey must sit at home and read the road that others travel. 


> 1. Who alwaies walkes, on carpet soft and gay,
>   
> Knowes not hard hills, nor likes the mountaine way.
> 






---

p.37


Limerick
--------



> **King Philip:**1. Then, tell us, shall your city call us Lord,
>   
> In that behalf which we have challeng'd it?
>   
> Or shall we give the signal to our rage,
>   
> And stalk in blood to our possession?
> 
> **Citizen:**1. In brief, we are the King of England's subjects;
>   
> For him and in his right we hold this town.
> 
> **K. John:**1. Acknowledge then the king, and let me in.
> 
> **Citizen:**1. That can we not: but he that proves the king,
>   
> To him will we prove loyal: till that time
>   
> Have we ramm'd up our gates against the world!
> 
> 
> 
> 
> 
> 
> 
> 
> 


King John. *Shakespeare, Act II, scene I*



In the revolutions of five centuries, the hardy chivalry of Wales, the sternness of a republican army, and the troops of a victorious monarch, have successively appeared before the walls of **Limerick**. In that city, Ireton and Tyrconnel, two distinguished characters, perhaps the most opposite in British history, both terminated their mortal career; nor, added to these military and political events, will it be found altogether destitute of literary recollections, as, in the last siege it sustained, **Story**, the historian of that period, was actively engaged, and **Rapin**, the historian of England, was severely wounded.




---

p.38


Situated on the noble River Shannon, thence enjoying maritime freedom and support, and with tracts of wild and rugged country on the North and West, that afforded a secure retreat to the conquered, **Limerick** was a position naturally wrested with difficulty from the Irish, and, when gained, was held by the captors with watchfulness and uncertainty. Like **Cork**, and the most noted sea-ports of Ireland, it was a Danish settlement in the ninth and tenth centuries, until recovered by Donald O'Brien, an active and powerful chieftain, who assumed the style and dignity of King of Lumneach, (as it is written) or North Munster — contrasted to Desmond, or South Munster, Mac Carthy the king of which was the first Irish prince that swore fealty to Henry II. Donald O'Brien followed his example, but only held his vow of allegiance sacred until the departure of the English Monarch; when, availing himself of the unsettled state of the country and the private jealousies which existed between the original leaders of the invasion, he suddenly declared his independence, and having surprised, defeated a detachment of the English troops that had inarched against him. This defeat caused such a panic in the main body, commanded by **Hervey de Montmorries**, that they retreated precipitately to **Waterford**, and it seemed to be the signal for warfare and revolt to the Irish. The **Earl Strongbow**, under whose direction the affairs of the recently obtained country had been placed, acted on the defensive only, and found it necessary to recall to his assistance **Raymond le Gros**, the former favourite and successful general of the English adventurers, by the promise of the hand of his sister in marriage, which had been before refused him, and was the cause of his retiring into Wales.


**Raymond** returned with a small reinforcement, but his personal appearance, rather than the number of his troops, restored confidence to the dispirited soldiers of **Strongbow**; and scarcely were his nuptials celebrated, when the bridegroom marched against the Irish enemy. Intimidated by his former success, present rapidity and self-confidence, 



---

p.39




little resistance was made by the Irish to the progress of **Raymond**, and he appeared before **Limerick** at the head of six hundred chosen men. The river by which the city was surrounded was broad and rapid in the point of attack selected. Two knights succeeded in fording it, but one of them, in his return to lead over his associates in this enterprize, was swept away by the force of the current and drowned: another made good his passage; but the majority hesitated at the great danger, when Raymond, plunging into the water, was instantly followed to a man, and **Limerick** surrendered without resistance.


The death of **Strongbow**, however, of which Raymond was informed by an enigmatical letter from his wife, rendered it necessary for him to withdraw his forces from the post he had so lately gained, as their presence was required in other parts of the kingdom; and having no alternative, he formally committed the city to O'Brien to hold for the King of England; informing him that, having by submission become a subject of England, the king fully confided in the fidelity and zeal with which he would perform the trust reposed in him. But no sooner had Raymond evacuated **Limerick**, than it was set on fire in four places by order of O'Brien, with the declaration that it should no longer be a nest to harbour strangers. **Leland** adds, when this transaction was reported to Henry II., as prejudicial to Raymond, that prince generously remarked — ‘the first gaining of **Limerick** was a noble exploit, the recovery of it still nobler, but the only act of wisdom was the abandoning this conquest.’


Until the death of Donald O'Brien, in 1194, the English cannot be said to have regained **Limerick**, as the possession was obstinately disputed by the Irish, who again secured their triumph by reducing the city to ashes. With the faithless and untractable O'Brien this mode of ruinous warfare terminated; and **Ferrar**, in his Civic History, tells us, as a proof of the importance of **Limerick**, that King Richard, 



---

p.40




in the ninth year of his reign, granted it a charter to elect a mayor: an honour, which London did not obtain until ten years after, and **Dublin** not before the year 1318.


King John, who came to Ireland in 1210, is said to have visited **Limerick**; and, as memorials of his visit, caused the present Thomond Bridge, and a castle still distinguished by his name, to be erected; both of these buildings appear conspicuously in Mr. Nicholson's view of the place; the former is perfectly level, and, although exceedingly narrow, an admirable piece of masonry, having withstood without much injury the rapid current of the Shannon above six hundred years.

*an auncient bridge of stone,
  

A goodly worke, when first it reared was,
  

And yet the Shiere can shewe no such a one)
  

Makes men to know, old buildings were not base.’’*




The confusion of parties and the distracted state of Ireland during the reign of **Charles I.** has been already noticed.


On the breaking out of these disturbances, Captain Courtney headed the adherents of Charles in **Limerick**, not amounting to more than two hundred, and though short of ammunition and provisions, maintained the castle for several days, trusting to supplies by water from **Sir Henry Stradling**, and that **Sir William St. Leger, the Lord President of **Munster****, would be enabled to raise the siege. But Sir William, depressed by the neglect which the emergencies of Charles rendered unavoidable, and exhausted by his ineffectual devotion and personal exertions in the cause of his monarch, became a victim to them, surviving only to hear that the gallant Captain Courtney had been compelled to surrender **Limerick**, after defending his post until it was no longer tenable. Lord Muskerry, **Garret Barry**, and other leaders of the Irish, immediately took possession of the town; a capture of much benefit to their cause, as they obtained by it some 



---

p.41




cannon, one of which was a thirty-two pounder, that terrified all the castles of the county **Limerick** into immediate submission, with the exception of Askeaton, which was however soon reduced.


In August, 1646, the Irish having stipulated for a treaty with the Marquess Ormond, it was agreed that hostilities should be mutually suspended, and Dr. Roberts, the Ulster King of Arms, was sent to the principal towns to proclaim the peace; he arrived at **Limerick** on the 20th of the same month, but his appearance tended only to excite opposition and outrage. When Dr. Roberts reached the market cross, attended by the mayor and aldermen of the city, for the purpose of reading the proclamation, a vast mob was assembled and a serious riot ensued. Burke the mayor was trodden under foot, and severely wounded; and Dr. Roberts, having received several dangerous cuts, narrowly escaped with his life. These disorderly proceedings, which are ascribed to the religious intrigues of **Rinuccini**, the papal nuncio, were followed by the deposition and imprisonment of the mayor, whose office was bestowed on **Dominick Fanning**, the leader of the rioters.


Lord Ormond, however, considering the possession of **Limerick** to be of the utmost consequence, endeavoured by various means to become master of it; but although professing amity to Charles, the confederate Irish, over whom the nuncio and his party had now obtained complete influence, flushed by their momentary superiority, and regardless of future consequences, conducted themselves with insolence and intemperance towards Lord Ormond, meanly doubting and idly hesitating at all offers made by that nobleman, whom they insulted by mock conferences and vexatious quibbles, whilst they openly set his and all other authority at defiance. All endeavours made by Ormond, whether to command or to conciliate, were equally vain. The mandate of a single friar was sufficient with the soldiery to counteract the orders of their leader, and the most trivial 



---

p.42




occurrence became a pretext for popular tumult, which the magistracy rather encouraged than suppressed.


Wearied by such obstinate conduct, and unable longer even to temporize with the garrison of **Limerick**, Lord Ormond embarked at **Galway** for France, and the small body of Royalists which he had headed, merged into the Irish ranks and became sharers in the defence of **Limerick**, against the Parliamentary army.


Sir Hardress Waller had already threatened it, but early in 1651, Ireton appeared before the city, which he closely besieged for six months, and exerted all his energies to gain.


The victory obtained by **Lord Broghill** over the forces of Lord Muskerry, who had marched towards **Limerick** with a view of relieving it, (of which action a more particular notice will be found in a subsequent paper,) hastened its surrender, and added to this discouraging event, a contagious fever raged within the walls, to the violence of which many had fallen victims. Contrary to the calculation and advice of O'Neil, the governor, who had before so bravely defended Clonmell against the troops of **Cromwell**, and the threat of excommunication uttered by the Bishops of **Limerick** and Emly, a treaty was determined on, but, says **Leland**, ‘in the hour of terror and danger, their spiritual authority was utterly disregarded.’


Colonel Fennel, who early in these transactions was reputed to have betrayed the pass of Killaloe to Ireton, thus affording a safe and easy communication with the county Clare, and the western parts of Ireland, having obtained from the mayor the keys of the city, seized John's Tower, and refused to obey the directions of the governor. In this treacherous conduct he was supported by the mayor, who furnished him with powder, when, turning the cannon on the town, and having admitted two hundred of Ireton's soldiers, Colonel Fennel declared that he would not quit his post, until the garrison surrendered. An hopeless option only remaining, articles 



---

p.43




were signed on the 2?th October, 1651, granting to the inhabitants their lives and property, with the exception by name of twenty of the most prominent characters, most of whom had been the active opponents of Ormond.


Of these, O'Dwyer, Bishop of **Limerick**, who marched out in the disguise of a soldier amongst the troops, and O'Neil, the governor, escaped execution. The latter, who had exasperated the Republicans by the spirit he had formerly evinced, fearlessly met Ireton at the city gates, and pointed out to him sufficient ammunition and provisions to have lasted three months longer, at the same time adverting severely on the treacherous proceeding of Colonel Fennell. Ireton caused O'Neil to be tried by a court-martial, which sentenced him to death; but, on a remonstrance founded on some informality, he was again tried, and his life saved by the majority of a single voice.


Of O'Brien, Bishop of Emly, **Dr. Bourke** gives the following account in the Hibernia Dominicana.


*He was so active in persuading the Irish to hold out against **Cromwell**'s forces that Ireton, during the siege of **Limerick**, offered him forty thousand pounds to desist from his exhortations and quit the city, with a passport to any other kingdom. This offer he refused heroically; in consequence of which he was exempted from pardon, tried, and condemned to be hanged and beheaded; he bore the sentence with resignation, and behaved to his last moments with manly fortitude. He addressed Ireton with a prophetic spirit, accusing him of the highest injustice, threatening him with life for life, and summoning him to the Tribunal of God in a few days. Ireton caught the plague in eight days, and died soon after, (26th November, 1651,) raging and raving of this unfortunate prelate, whose unjust condemnation he imagined hurried on his death.’’*

Thomas Bourke, Hibernia Dominicana, Cologne (1752)




In 1690 **Limerick** again received the Irish forces, as they may be more justly termed than those of James, who had abandoned them.




---

p.44


After the defeat which that monarch experienced at the Boyne, the remains of his army, under the Duke of Berwick, Colonel Sarsfield, and Boislieu, the French general, retreated to **Limerick** as their last resource, and its defence was entrusted to the latter officer. When King William (who in person appeared before the walls) summoned it to surrender, the governor made the following memorable reply in a letter to **Sir Robert Southwell**, Secretary of State; ‘not sending directly to the king,’ says **Story**, ‘because he would avoid giving him the title of Majesty;’ that he was surprised at the demand, and thought the best way to gain the Prince of Orange's good opinion was by a vigorous defence of the town for his master King James.


Some delay taking place in the arrival of the artillery to commence the siege, Colonel Sarsfield made a secret and rapid sally from **Limerick** with five hundred dragoons, crossing the Shannon at Killaloe; and succeeded, by his knowledge of the country, in surprising and capturing the ammunition-waggons and cannon, which latter he filled with powder, and placing their mouths in the ground fired a train that burst them with a terrific explosion, and announced their destruction to a party under Sir John Lanier, who had been sent to protect them. Nor was the bravery displayed in the enterprize less conspicuous than the skill with which Sarsfield effected his retreat without coming to an action, notwithstanding the efforts made to intercept him.


This event threw a severe damp on the confidence of the besiegers, whom it compelled to suspend the vigour of their operations for a week, until the arrival of another supply of ordnance from **Waterford**, and had at the same time the effect of inspiring the besieged with fresh spirit.


During the siege, William persevered in his wonted activity and example of personal exposure, having several narrow escapes from the enemy's shot.




---

p.45


A breach about twelve yards in length near John's Gate being effected on the 27th August, orders were issued for the assault. At a given signal five hundred grenadiers ran towards the counterscarp, ‘firing their pieces, throwing their grenades,’ and were fiercely opposed by the Irish; ‘so that in less than two minutes the noise was so terrible that one would have thought the very skies ready to rent in sunder.’ ‘This was seconded with dust, smoke, and all the terrors that the art of man could invent to ruine and undo one another; and to make it the more uneasie, the day itself was excessively hot to the bystanders, and much more sure in all respects to those in action.’


The Irish retreating before the storming party, their ardour hurried them on into the town, whilst the regiments ordered to support them stopped short at the counterscarp, and they who led the attack were all either killed or wounded. The defenders, having rallied, returned with renewed and desperate valour to the breach, the women even mingling in their ranks, and sharing in the fight; and, after three hours uninterrupted firing, ‘insomuch that the smoke that went from the town reached in one continued cloud to the top of a mountain at least six miles off,’ the besiegers were forced to retire to their trenches, having expended all their ammunition. Some powder taking fire in a small work called the Black Battery, that had been seized by the Brandenburgh Regiment, most of these soldiers were blown into the air. A truce demanded by King William the next morning, for burying the dead, was refused; and, notwith-standing he offered the Irish favourable terms, to which Lord Tyrconnell was willing to accede, Boislieu, the governor, determined to hold out to the last, justly regarding, although the cause of James was desperate, the capitulation of **Limerick** to be fatal to it.


**Dean Story** has left us an animated account of the siege, and in some measure relieved its horrors by the occasional quaintness of his style. ‘I remember,’ writes he, ‘we were all as well 



---

p.46




pleased to see the town flaming as could be, which made me reflect upon our profession of soldiery not to be overcharged with good-nature.’


The unsettled state of public affairs in England requiring William's personal attention, he embarked for that country immediately after this severe repulse at **Limerick**, and that garrison became the refuge of all the smaller ones which successively surrendered to his troops.


Early in the year 1691, St. Ruth, a meritorious but arrogant officer, arrived from France to replace Boislieu, with a small sum of money, and the promise of extensive succours; and Tyrconnell, the former agent of despotism and bigotry, also returned from the same country, with inconsiderable supplies, accompanied by Sir Richard Nagle and Sir Stephen Rice. Dissension and intrigue arose between the French and Irish leaders (military as well as civil), and the contagion was communicated to those under their controul. The French reproached the Irish with their treachery, meanness and barbarous condition; and the Irish retorted on the French foppishness, insincerity, and frivolity of disposition, terming the large boots in which they strutted, ‘leathern trunks;’ the result was, the most violent disputes and factions, to which Tyrconnell became a victim, poison, as it is believed, having been administered to him in a cup of ratafia. According to Sir John Dalrymple, he died, ‘lamenting with his last breath the miseries he had brought on his country.’ Such was the end of him, whom Lord Bellasis describes as ‘fool and madman enough to ruin ten kingdoms.’ But of whatever unconstitutional and arbitrary measures Tyrconnell may formerly have been guilty, and he is no doubt with justice accused, his latter conduct appears that of a real patriot, alive to the ruinous effects of civil warfare, and willing to sacrifice his own feelings for the restoration of tranquillity and the general advantage of the nation.


On the retreat of William, and the successful defence of **Limerick**, the Irish, ever ardent and enthusiastic, anticipated confidently a 



---

p.47




favourable and victorious campaign, and the French officers were willing by every means in their power to protract the war. One more effort was therefore made in the field under the direction of St. Ruth, who fell in the battle of **Aughrim** on the 12th July, 1691, and whose fate decided that of the day. A misunderstanding which existed between that general and Sarsfield, (created by James, Lord Lucan,) on whom the command devolved, prevented the mutual understanding and co-operation so necessary to the success of an army; and the Irish were completely routed by the troops of William, commanded by General Ginkell.


As a last resource **Limerick** became again the retreat of the adherents of James; and its former defence encouraged the hope that it might a second time be maintained with equal success. Ginkell, warned by the defeat of William, made his approaches with caution, endeavouring by proclamations of pardon and protection to induce the Irish to lay down their arms. Of this second siege, which occupied about six weeks, the severest feature was an action that took place on Thomond Bridge, where many lives were lost, and in which the conduct of a French officer, who hastily ordered the drawbridge to be raised, thus sacrificing a considerable body of the Irish, confirmed the dislike that had existed on the popular side towards their allies.


As the winter was fast approaching, Ginkell determined if possible to secure the place, and on the 23d September, the garrison having beat a parley, a cessation of hostilities was agreed to. Terms were offered by him of so favourable a nature that they were gladly accepted by the besieged, and the articles of the capitulation bear date the 3d October, 1691. These conditions may be found at length in almost every work on Irish history, and their supposed violation has occasioned much political discussion of so severe and intemperate a character that it is difficult even to comment with impartiality on these transactions.


Colonel Luttrell, an officer in the Irish army, although completely 



---

p.48




vindicated in Lord Westmeath's letter to Mr. Harris of the charge, is still stigmatized as the betrayer of an important passage of the Shannon. On stormy nights, when gusts of wind agitate the river, while Foaming and fierce it rolls with fury on,’’

 the neighbouring fisherman or peasant usually execrates ‘that traitor Luttrell, whose spirit is abroad shrieking on the waters.’


After the surrender of **Limerick** nineteen thousand men embarked for France, and were embodied into twelve regiments, which became distinguished in the history of Europe as the Irish Brigade. Amongst the charges strongly brought against the English is the breach of faith in preventing the women from emigrating with their husbands. There is a melody, as yet unpublished, which I have heard **Mr. Bunting** perform, said to have been sung on this occasion; it consists of a lamentation, and a chorus that interrupts, as it were, by a passionate burst of grief, the mournful wildness of the air.


The gallant Sarsfield was killed in the battle of Landen, and the following lines are to be found under an engraving of his ‘Portraiture.’


> 1. Oh! Patrick Sarsfield, Ireland's wonder,
>   
> Who fought in field like any thunder,
>   
> One of King James's chief commanders,
>   
> Now lies the food of crows in Flanders!
> 




On the 3d March, l692, the war was declared by proclamation to have terminated in Ireland, and **Limerick** slowly recovered from its violent effects. That city was long regarded by the English government with peculiar watchfulness and distrust, lest the exiled family of the Stuarts might still find adherents within its walls. Sixty years were allowed to elapse after the siege before this strictness was relaxed, its gates thrown open, and its bastions permitted to remain without sentinels. No less than seventeen gates were in existence 



---

p.49




about the middle of the last century, which were guarded and regularly locked every night.


A statement of the military arrangement of Ireland transmitted from **Dublin** to Mr. Edgar, Secretary to the Pretender, in 1726, contains the following paragraph:


‘In **Limerick** there are twenty-two, and in **Cork** eleven companies of soldiers stationed. The companies selected for these garrisons are all English Protestants and other foreigners.’


Gloves are modern articles that have conferred celebrity on **Limerick**, and were not neglected in my inquiries; but I found them dearer than in London, and the reason given was, ‘that they had to be brought from **Cork**, where they were principally made.’


**Limerick** is divided, like almost every town in Ireland, into English Town and Irish Town; the former, generally called New Town Perry, has some well-built and handsome streets; the best houses are of red brick, much in the style of London, with areas and a flagged pavement, which makes the place more agreeable to the pedestrian than **Cork**. The old, or Irish Town, ‘which Shanon,’ saith **Camden**, ‘a most famous river, by parting his chanell, compasseth round about,’ is picturesque, narrow and dirty, the houses high, with peculiar old-fashioned gable ends towards the street.


After the inns and uncertain accommodations we had met with in our circuitous journey, Swinburne's Hotel, which is excellent, appeared so to us in an eminent degree; rooms furnished with carpets and sofas having become quite a luxury.


The custom-house and barracks are respectable buildings, and these, with the cathedral, form the architectural boast of **Limerick**. The latter is dedicated to St. Mary, and was founded by the O'Brien family on the site of the palace of Donald O'Brien, King of **Limerick**. It is a large and heavy edifice, and has from without an appearance of clumsiness and neglect; nor will an examination of the interior dissipate this impression. The whole pavement of the church 



---

p.50




seemed composed of a jumble of inscribed flag stones, many of which had been cut to fit a required space, and on others such inscriptions and tracery as happened to have been in high relief were chiseled down in the most wanton manner; two or three ornamented fleury crosses, which had escaped this general mutilation, were so placed that the step of every passenger along the nave assisted to obliterate them; in the aisle leading to the vestry-room an ancient Gothic tomb, richly wrought, was rapidly falling to decay from the most unfeeling neglect. Whilst I was engaged in viewing it, the guide, with a large heavy key, stood idly chipping away some of the minutely carved ornaments; — never did I feel more forcibly the nothingness of human vanity than in this cathedral. The defaced ‘Hic Jacet’ and the worn ‘Obiit,’ the last effort at distinction, marking, even in death, the superiority of the feudal lord and the mitred abbot over their dependents, were daily trampled into oblivion without a thought! — Respect for the dead ought to be encouraged; it is in harmony with all the gentler and social virtues of our nature; and, although the effort to perpetuate our memory by means of stone or brass be idle, it is painful to see the silent movements of decay accelerated by the ignorant or the listless.


The great east window is large, but every way inelegant; near the Communion Table is a monument of considerable size, to Donough, Lord Thomond, who was Lord President of **Munster**, and died in 1624, which, the inscription informs us, having been injured and defaced in the commotions of **Charles I.**'s time, was restored in 1678.


Against pillars in the nave are two singular inscriptions: 
  


> 
> ***Dan Hayes** an honest 
>   
> 
> man and lover of his country.*
> 
> 
> 




This **Mr. Hayes** was a gentleman of some fortune and very eccentric habits, who died in London, in 1767, whence his remains were brought to be interred at **Limerick**, and the foregoing lines, by his 



---

p.51




own direction, were placed over them. He bequeathed his entire property to the support of the public hospital of the city; but his heirs opposed the will by law, and obtained a verdict in their favour. **Hayes**'s Poetical Works have been collected, and underwent two editions; but, judging from the specimens which I have seen quoted, his verses were extremely pompous and insipid, and are now scarcely remembered.


The other inscription is
  


> 
> *Memento mory
>   
> 
> Here lieth little Samuell
>   
> 
> Barington that great under
>   
> 
> taker, of famous cittis
>   
> 
> clock and chime maker
>   
> 
> he made his one time goe
>   
> 
> early and latter. But now
>   
> 
> he is returned to God his Crea
>   
> 
> tor.
> 
>   
> 
> The 19 of November then de
>   
> 
> scest and for his memory
>   
> 
> this here is pleast by his
>   
> 
> son Ben 1693.*
> 
> 
> 




During the several sieges, the cathedral was considered an important station, being, from the necessities of the times, converted to military purposes. In 1642, the Irish threw their shot from thence into John's Tower defended by Captain Courtney; and the garrison of **Limerick**, consisting of 2500 men, laid down their arms to Ireton in the cathedral when he became master of the place. In the last resistance of the city, the troops of William were much annoyed by a skilful fire from the steeple, against which they directed their cannon, until checked by the orders of General Ginkell, who was anxious to preserve so venerable a structure. At Mungret, a short distance from **Limerick**, was a monastic foundation, of which the Psalter of Cashel gives an almost incredible account — that it had 



---

p.52




‘within its walls six churches, containing, exclusive of scholars, 1500 religious, 500 of whom were learned preachers, 500 psalmists, and the remaining 500 wholly applied themselves to spiritual exercises.’


‘As wise as the women of Mungret’ is a common local proverb; and **Ferrar**, in his History of Limerick, gives the subjoined explanation:


‘A deputation was sent from the college at Cashel to this famous seminary at Mungret, in order to try their skill in the dead languages. The heads of the house at Mungret were somewhat alarmed lest their scholars should receive a defeat, and their reputation be lessened; they therefore thought of a most humorous expedient to prevent the contest, which succeeded to their wishes. They habited some of their young students like women, and some of the monks like peasants, in which dresses they walked a few miles to meet the strangers, at some distance from each other. When the Cashel professors approached and asked any question of the distance of Mungret, or the time of day, they were constantly answered in Greek or Latin, which occasioned them to hold a conference, and determine not to expose themselves at a place where even the women and peasants themselves could speak Greek and Latin.’


The appellations of Tory and Rapparee frequently occur in the periods of Irish history connected with **Limerick**, and as the former is one by which a political party is at present distinguished, some account of these terms may not be unacceptable.


In the civil wars under Elizabeth the epithet Tory is supposed to have originated, and was applied only to the peasantry. Sir Henry Sydney, the Lord Deputy, according to **Sir Richard Cox**, ‘cursed, hated and detested Ireland above all other countries; not that he had any dislike to the country, but that it was most difficult to do any service there, where a man must struggle with famine and fastnesses, inaccessible bogs and light-footed Tories.’ During the rebellion of 1641, the name was bestowed on such individuals as at 



---

p.53




first professed to remain neutral in the contention, but who ultimately — perhaps urged by their loss of property and consequent distress — took up arms with a view of reprisal or revenge on those by whom they had been reduced to absolute ruin. English and Irish — Protestant and Catholic Republican and Loyalist, were alike their common enemies; and Tories, being joined by men of desperate fortunes, united themselves into bodies; and, in fact, became formidable gangs of freebooters, who harassed the regular troops of all parties without distinction. The name, therefore, was one of reproach, and ‘Tory hunting’ was almost viewed in the light of a pastime. An old rhyme in allusion to this sport is still orally current in the South of Ireland, and a decided favourite in the nursery collection. 


> 1. Ho! Master Teague what is your story?
>   
> I went to the wood and I killed a Tory.
>   
> I went to the wood and I killed another.
>   
> Was it the same, or was it his brother?
> 2. I hunted him in, and I hunted him out,
>   
> Three times through the bog about and about;
>   
> When out of a bush I saw his head,
>   
> So I fired my gun, and I shot him dead.
> 




Defoe has accounted for the introduction of the name into England, by telling us that the famous Titus Oates may be considered as its real godfather, and relates the following anecdote respecting it.


‘There was a meeting (at which I was present) in the City, upon the occasion of the discovery of some attempt to stifle the evidences of the witnesses (about the Popish plot), and tampering with Bedlow and Stephen Dugdale. Among the discourse, Mr. Bedlow said, he had letters from Ireland, that there were some Tories to be brought over hither, who were privately to murder Dr. Gates and the said Bedlow. The doctor, whose zeal was very hot, could never hear any man talk after this against the plot or against the witnesses, but 



---

p.54




he thought he was one of these Tories, and called almost every man who opposed him in discourse, a Tory — till at last the word Tory became popular.’


Rapparee has much the same meaning as Tory, and is derived from an Irish word signifying a half-stick or broken beam resembling a half-pike, from whence the name was given to such as carried this weapon and did not belong to the regular troops of either army, but provided themselves, in the best way they could, with pikes, daggers or skeins, and such instruments of offence as could be readily manufactured.


The Tories in the time of **Charles I.**, however, appear to have originally received more provocation, and their conduct can be better vindicated than that of the Rapparees of William's. It is asserted, (and with strong claims to belief,) that the Irish commanders of James's army encouraged, by written protections, the Rapparees to surprise and plunder the straggling and detached parties of William's forces — particularly during the winter, when general hostilities were suspended, — by which means they not only harassed them extremely, but accumulated a supply of horses and muskets that enabled the Irish to bring an additional number of men into the field the ensuing season.


When a Rapparee became a prisoner, the gallows instantly terminated his fate, and it is stated by Mr. Lesley that many poor harmless country people became victims to military legislation; but the necessity is obvious that no quarter should be given to men who lurked in ambush, ready to spring on their prey at every favourable opportunity, and whose acquaintance with the country enabled them to lie concealed in the most artful and treacherous manner.


‘When the Rapparees have no mind to show themselves upon the bogs, they commonly sink down between two or three little hills grown over with long grass, so that you may as soon find a hare as 



---

p.55




one of them; they conceal their arms thus — they take off the lock and put it in their pocket, or hide it in some dry place; they stop the mussel close with a cork and the touchhole with a small quill, and then throw the piece itself into a running water or a pond; you may see an hundred of them without arms, who look like the poorest, humblest slaves in the world, and you may search till you are weary before you find one gun; and yet when they have a mind to do mischief they can all be ready in an hour's warning, for every one knows where to go and fetch his own arms though you do not.’


This account, although ridiculed by some writers, I see no reason to question, as, during the years 1793 and 1794, the disaffected in the north of Ireland concealed both themselves and their arms from the soldiery sent to disperse their meetings in a similar manner.


The White Serjeant, Galloping Hogan, Redmond O'Hanlon, Ned of the Hills, and Iron Mac Kabe are the names and titles by which some of the most noted Rapparee leaders were distinguished.


 A History of the Irish Rogues and Rapparees is at present one of the most popular books amongst the peasantry, and has circulated to an extent that almost seems incredible; nor is it unusual to hear the adventures and escapes of highwaymen and outlaws recited by the lower orders with the greatest minuteness, and dwelt on with a surprising fondness.


Killaloe, a pass of the Shannon thirteen miles above **Limerick**, (the consequence of which has been mentioned more than once in the preceding Historical Sketch,) is a bishop's see of considerable antiquity. The town is built upon the ascent of a hill, and surrounded by well shaped mountains; a long bridge of many arches extends across the river, which is here wide and shallow. Mr. Nicholson's drawing combines the most important features of the place, which wears a poor appearance and seems to be little frequented by strangers, as the inn, if it deserves the name, included the business 



---

p.56




of publican, linendraper, hosier and chandler under the same roof. One room was appropriated for a table d'hote, where my companion and myself joined a noisy good-humoured clerical party, none of whom could be accused of fastidiousness. On my rising to ring the bell, a jolly looking parson, observing that I sought for one in vain, exclaimed, ‘May be 'tis a bell you're looking for; and are you so 
unreasonable then as to expect to find one, sir?’


Killaloe, in former days, was the resort of many religious pilgrims attracted by its reputed sanctity; and the walls of some old buildings are still to be seen in its vicinity. Little more is known of the cathedral than the name of the founder, St. Molua, (whom **Dr. Ledwich** declares an imaginary saint,) and his disciple and successor St. Flannan, who was consecrated bishop about the year 639. The building of the present cathedral is attributed to the O'Brien family, many of whom are buried here. A Saxon arch in the wall on the south side of the nave, although evidently a portal, is called the tomb of Brien Boru'; it is enriched by some florid and beautiful carving, which affords a whimsical display of ornament. In the churchyard stands an oratory, or stone roofed chapel, supposed to be of remote construction, and certainly of a much earlier date than the cathedral. Both gable ends contain portals; that on the west side is adorned with mouldings, and the east side, here sketched, appears to have had a building with a lower roof attached to it.


An excursion which I made from **Limerick** to visit the Rev. R. Dickson of Vermont, enabled me to examine two of the most considerable 



---

p.57




architectural remains in the western part of the county: the castle of Carrigogunnel, and the ecclesiastical ruins at Adair. The former is five miles distant from **Limerick**, and is one of the largest castles I remember to have seen in Ireland. It stands on an abrupt limestone rock, and commands an extensive view, across the Shannon, of the County Clare and the low grounds termed ‘Corcass Land,’ which form the banks of that river. Its building is ascribed to the O'Brien family;[2](javascript:footNote('E820000-001/note002.html')) and, according to Archdall, it belonged at one period to the Association of Knight Templars. From its situation and extent, this pile must have been formerly a place of much importance, 


> 1. A fort of strength, a strong and stately hold
>   
> It was at first, though now it is full old.
>   
> On rock alone full farre from other mount
>   
> It stands, which shews it was of great account.
> 




About the year 1537, Cox informs us that, through stipulation and treachery, Carrigogunnel was lost and won more than once by the followers of the Earl of Desmond and those sent to reduce that turbulent chieftain and the country to tranquillity. At the siege of 



---

p.58


**Limerick**, after the battle of **Aughrim**, it was garrisoned by 150 men, adherents of James II., but surrendered without resistance to Major General Scravenmore, ‘the leaving these detachments in such places,’ remarks **Story**, ‘being very unaccountable, since they had a mind to defend them no better. This seems,’ continues the same writer, ‘rather a want of instructions what to do than courage to perform it, for, to give the Irish their due, they can defend stone walls very handsomely.’ The castle was considered so tenable a position, that it was deemed expedient to destroy it, and it was accordingly blown up, together with Castle Connell; **Dean Story** receiving no less a sum than 160£ for the purchase of gunpowder to ruin these fortresses.


The violent effect of the explosion is still evident in the dilapidated remains of Carrigogunnel. Massive fragments of the walls and towers lie scattered around in a confusion not unpicturesque, and it is a matter of some difficulty to trace the original plan. A drawing of its distant effect is annexed.


Near this castle Charles Johnson, the author of Chrysal, or the Adventures of a Guinea, and other works, was born in 1719, and received his education at the diocesan school of **Limerick**.


At Faha, the seat of Mr. Tuthill, between Carrigogunnel and Adair, a meteoric stone of considerable size, which fell there in 1815, was shown me by Mrs. Tuthill. It weighs, I imagine, nearly half a hundred weight, although there is an appearance of a piece having been struck off it.


Adair is a small and neat village, eight miles west of **Limerick**, and deserving the particular notice both of the antiquary and the artist from its assemblage of ancient monastic edifices. It is well situated on the River Maig, which passes through the richly wooded and extensive park of Mr. Quin, and is navigable for small vessels.


One of these abbeys is at present converted into a Roman Catholic chapel, and another, larger and more perfect, into a Protestant 



---

p.59




church, the cloisters of which latter are in excellent preservation, but it contains little more that merits examination.


The third abbey stands within Mr. Quin's demesne, and, surrounded by venerable trees, becomes a most impressive and romantic object. The seclusion and beauty of its situation are calculated to excite poetic feelings in the mind, which are heightened by the gloom of ash and ancient yew trees, that almost darken the cloisters at noon-day.


Some years since, the ground within its walls was levelled, and most of the tombs and inscriptions destroyed by order of the proprietor, to prevent the abbey being used as a burial ground. A pious superstition deterred the peasantry from disturbing the ashes of the dead, and no one could be procured to perform so sacrilegious an act — as if they feared the fulfilment of Shakspeare's threatening epitaph would be the consequence of the violation: 

*Blest be the man that spares these stones,
  

And curst be he that moves my bones.’’*

Shakespeare's epitaph


A party of soldiers were brought from **Limerick** for the purpose, who soon completed the work, and ‘the trim grassy aisle’ replaced the legends commemorative of the old fathers and feudal chiefs. Some monumental and confessional niches have escaped, and may still be seen. In the cloisters I found two little carved fragments; one of these was an escutcheon charged with a cross saltire; the other, a figure in rude bas-relief about eighteen inches high, representing a grey friar, as appears from the costume. These abbies were founded by the Earls of Kildare, and were granted, on the dissolution of monasteries, to Sir Henry Wallop. The ruins of an extensive castle also stand within Mr. Quin's demesne. In the wars of Elizabeth's time it was a post warmly contested by the Irish and Spanish followers of Desmond with the English, who were driven to extremes by a blockade, and out of necessity compelled 



---

p.60




to hazard a desperate excursion into the Knight of Glen's country, where a severe skirmish of eight hours took place, in which the English came off without much loss, having killed fifty of their opponents. Shortly after the death of Desmond it was seized by the Lord Kerry, and the garrison put to the sword, but Captain Zouch obliged him to abandon it.




---

p.61


Kilmallock
----------



> 1. Castles high fall in decay,
>   
> And the Lords who once did hold them;
>   
> Lords and castles pass away
>   
> As our beads when we have told them.
> 



Translation from an Irish MS.


The road leading from **Limerick** towards **Cork** is for some miles flat and uninteresting, though the horizon is bounded by mountains with an agreeable outline. The cabins of the peasantry are most deplorable; and the state of filth in which the owners live, inconceivable to an Englishman who has not travelled in Ireland. Twenty of these hovels sometimes succeed each other without a chimney; and invariably a stagnant black puddle is seen close to the door, appointed receiver-general of all kinds of filth, streams from which issue in every direction, one generally entering at the cabin door and trickling down over its mud floor: — ‘*Such* habitations,’ to use the words of **Sir Richard Hoare**, ‘teeming with a numerous population of children, pigs and poultry, present a truly deplorable and affecting sight to every man of feeling and humanity.’


About nine miles distant from **Limerick**, not far from the road, lies **Lough Gur**, formerly a place of consideration; its castle, which 



---

p.62




stood on an island, being out of the reach of musketry, and the ruggedness of the surrounding country rendering the approach of cannon a matter of difficulty. Sir George Carew, in the beginning of 1600, shortly after he assumed the government of **Munster**, reconnoitered Lough Gur Castle, and found it garrisoned by more than two hundred soldiers, commanded by James Fitz Thomas, a near relative of the Earl of Desmond, to the history of whose ruinous fate the present chapter is chiefly devoted. On observing the President's approach, a few shots were fired from the castle, but without effect, and Sir George Carew returned to **Limerick**, where, after much parade in the preparation of ordnance to reduce Lough Gur, its surrender was purchased for sixty pounds from Owen Grome, who had been entrusted with its defence by James Fitz Thomas.


An Irish topographical manuscript without date, the writer of which I have reason to believe was **John M'Donald**, or **Shane Clarah**, mentioned hereafter, is at present in my possession, and lies before me with a translation. In it ‘**Lough Guir**’ is described as more than eight miles distant from **Limerick**, and remarkable on account of a beautiful and verdant hill, almost in the centre of the lake. ‘On the foot of this hill,’ (I copy literally the translation,) ‘at the north side, is a stately castle in the Gothic fashion. The hill is about an English mile and a half in circumference, and on its south-west side is the largest part of the lough; there, at the distance of three or four hundred yards from the shore, formerly stood a square castle rising out of the water, on the vault of which was planted, as I was told by Mr. Baily the owner of the place, five or six apple trees which then bore fruit; and on the edges of the vault he caused battlements to be raised to prevent their destruction by the undulation of the waters. I have been,’ continues the writer, ‘at this extraordinary orchard and vault, the owner of which partly supports himself by what money he receives from the curious who visit this place; there is but one causeway to the hill, *no doubt*


---

p.63


*fortified by the ever-memorable Brien Boroïmhe in the Danish times*, which has yet the remains of two out-works upon it.’


Near Lough Gur, and close to the road-side, a large Druidical circle of stones is to be seen, of which some description may be found in **Mr. Twiss**'s Tour and **Trotter**'s Walks through Ireland, but a severe fall of rain prevented my examination of this rude monument.


Two miles farther brought us to Bruff, or Brough, a wretched village, with the ruins of an old castle, mentioned in the Pacata Hibernia. Continuing our route we arrived at **Kilmallock**, sixteen miles from **Limerick**, and entered the town, under a dark and massive gateway, late in the evening. The gloom which partially obscured every object, as we drove along a street composed of mean cabins, mingled with the ancient stateliness of towers and embattled wails, produced rather a mournful impression on the mind not unfavourable to useful thought, but it was soon dispelled by the prospect of miserable accommodations and the consequential officiousness of our landlady.


From its present fallen condition and former greatness, **Kilmallock** has been called ‘the Irish Balbeck,’ by **Dr. Campbell**, whose description of the plate in his Philosophical Survey, (which, by the by, has very little if any likeness to **Kilmallock**,) proves him to be, though an agreeable and intelligent writer, no artist. — ‘There was something,’ says that author, ‘so *picturesque* in the *perspective* of this place that I could not help attempting to delineate it; I send you my essay, done, as you see it, in less than an hour; *I must, however, remark to you, that I began upon a scale too large for my paper, and was not able to get in the whole town!*emph>’


**Kilmallock** seems to have been gradually sinking into decay since the time of **Cromwell**, when it was dismantled and received much injury from the parliamentary army. Two (of the four) gateways still exist, and have a solid heavy effect, with a strong resemblance to Spanish or Moorish architecture. But it is from the main street 



---

p.64




that a just idea of its ancient consequence may be formed; on each side are the remains of houses built of hewn stone, which seem to have been constructed on an uniform plan; and so excellent is the workmanship, the walls of many of them are now in perfect preservation, only wanting roofs and floors to make them as complete as when inhabited. These houses are three stories high, ornamented with an embattlement and a tasteful stone moulding on the outside, of this pattern: [*...*][3](javascript:footNote('E820000-001/note003.html')). The square window frames and large fire-places are well carved, in a bold and massive style; and such is the durability of the limestone, though exposed to the weather and casual injuries, that it retains the sharpness of the chisel as if only yesterday from the hands of the sculptor.


A chimney-piece in the shell of one of these buildings bears the inscription 
‘SH 16 IHS 38 EH’


These initials I was told were those of Simon and Edward (more probably Elizabeth or Elinor) Healy; and as these houses were evidently built about the same time, this date satisfactorily points out the period.


The annexed sketch of the ground-plan of **Kilmallock** I have made from recollection, to assist the reader in comprehending the description; and have distinguished in it, by a deeper shade, such ancient edifices as still exist, from the cabins and mean houses of modern formation.


Little attention is paid by its present inhabitants to the preservation of the remains of its former importance. On the contrary they are daily destroyed. Whenever a hovel is required to be built, the materials are procured by breaking down part of these once splendid mansions, some of which have been lowered and fitted up in accordance with the neglect and desertion of the place, and the interior of others is occupied by sheds for cattle, or more loathsome pigsties.




---

p.65


The town walls, still retaining in some places their original height, may be traced uninterruptedly from the gate on the **Charleville** side to that on the **Limerick**, which I am inclined to consider a fourth part of their former extent.


A stream, named the Cummogue, runs close to the town, and falls into the river Maig; on its opposite banks are the ruins of two abbeys, which complete the vestiges of ancient **Kilmallock**. That on the same side with the town contains monuments to members of the Fitzgerald, Verdon, Blakeney, and Haly families, erected during the seventeenth century, and it is difficult to imagine more barbarous or grotesque pieces of sculpture than some of them exhibit; indeed it is surprising, after beholding the beautiful masonry of that time so conspicuous in the town, to find tombs of the same date, on which much labour has been bestowed — such unskilful productions. The bas reliefs copied from the Verdon tomb, bearing the years 1614 and 1626, may serve as an illustration; yet **Ferrar**, in his History of Limerick, says — ‘*This monument was of excellent workmanship, and esteemed one of the best in **Munster**;*’ and speaking of the uncouth figures I have sketched, says, they are ‘*done in a masterly style in alto relievo.*’ Were it not for the coincidence of name and dates I should doubt the identity of the monument. The singularity of a Fitzgerald tomb (equally rude with the Verdon) perhaps requires mention. A figure of Death is conspicuously engraven on it, with the hexameter verse 

‘Non fugiam! prius experiar — Non Mors mihi terror.’


The chancel of this abbey has been fitted up and is used as a church. The ruined abbey on the other side of the water is of greater extent, but has too lonely and stern an appearance to be picturesque, circumstances which render it more sublime. The architecture, though solid, is graceful, and the great altar window, a 



---

p.66




fine specimen of the chaste lightness of the pure Gothic style. In the centre of its chancel stands the family tomb of the White Knight, a title assumed by a branch of the Fitzgeralds, or, as they are frequently called, Geraldines, and, according to **Camden**, originating from the grey hairs of the founder of that line. In the pedigree of the Fitzgerald family, the titles of some of the branches settled in the south of Ireland are so romantic that they carry us completely back to the days of chivalry, as we find, beside the White Knight, the Knight of Glen, sometimes called the Knight of the Valley, the Black Knight, and the Knight of Kerry; appellations that continue to be bestowed on the lineal representative at the present day.


The ponderous slab that covered the White Knight's tomb is broken in two parts, one of which lies overturned beside it, and bears the following inscription: 
  


> 
> I. H. S. 
>   
> 
> Hic tvmvlvs erectvs fv
>   
> 
> it in memoriam illivs ste
>   
> 
> mmatis Geraldinorvm qvi
>   
> 
> vvlgo vocantvr eqvites
>   
> 
> albi.
> 
>   
> 
> Iohannes cvm filio svo
>   
> 
> Edmvndo et Mavricio fi
>   
> 
> lio preefati Edmvndi
>   
> 
> etmvlti alii eivsdem famil
>   
> 
> iee hic tvmvlantvr preef
>   
> 
> atvs
> 
> 
> 




A boy tending some cattle, that had sheltered from the noon-tide heat in the shade of the abbey walls, seeing me examining this mutilated tomb, introduced himself with the exclamation, ‘The curse of **Cromwell** be on the White Knight. — He was the cruel and 



---

p.67




bad man, Sir!’ and added, ‘They say 'twas the black bull that tattered it in this way, your honour; but 'tis my belief it was none of his doing, but the work of some kind of evil spirit or other. It was just broken and left as it is now four nights ago, and in my opinion 'tis a judgment on the White Knight, for he was the cruel and bad man!’


My new bare-footed acquaintance showed me an inscribed stone lying in the dilapidated cloisters which, with the armorial fragment copied near the Geraldine tomb, are the only monumental remains to be discerned in this abbey. The inscription in the cloisters has already been printed in **Ferrar**'s Limerick and **Mr. Weld**'s Account of Killarney; but being in itself curious I will not omit it, particularly as there is some slight variation in my transcript from that of the latter gentleman.


> 
> *1642.
>   
> 
> Tertia. lux. cæsos. memorat. Septembris. in. anno.
>   
> 
> quem. legis. heu. nondum. tres. tenet. urna. senes.
>   
> 
> marte. nepos. fratesque. ruunt. tria. pignora. justo.
>   
> 
> jus . patriæ. causam . rexque. fidesque. probant.
>   
> 
> integer. attritis. reperitir. candor. in. extis.
>   
> 
> virginis. et. veri. purpura. martyrii.
>   
> 
> lilia. purpureos. inter. sudantia. fluctus.
>   
> 
> tres. meruere. trium. nomina. marmor. habe.
>   
> 
> Frés: Geor:
>   
> 
> Edw: Burgate.
>   
> 
> Nep.: Alex:*
> 
> 
> 




M'Donald, (better known by the name of Ollistrum,) the leader of a party of Highlanders in the commotions of **Charles the First**'s time, and who was treacherously murdered at Knocknisross, near 



---

p.68


**Buttevant**, according to tradition was buried in this abbey, but the spot is unknown.[4](javascript:footNote('E820000-001/note004.html'))


**Kilmallock**, as the scene of many historical events, has numerous interesting recollections connected with it. In particular, the fate of the Desmond family, a melancholy picture that assumes even a more mournful tinge since the irritation of party feeling has subsided. — With possessions of nearly four counties, extending above 100 miles, and containing more than 570,000 acres, the Earls of Desmond, when actuated by private motives, were enabled to take the field 




---

p.69




with an armed force so considerable as to excite just apprehensions in those who had the government of an imperfectly subdued country. But the history of Gerald, the sixteenth earl, who has been called Ingens rebellibus exemplar, is briefly given in **Baker**'s Chronicle, and with so much affecting simplicity, that I am induced to transcribe the words.


‘Desmond possessed whole countries, together with the County Palatine of **Kerry**, and had, of his own name and race, at least five hundred gentlemen at his command, all whom and his own life also he lost within the space of three years, very few of the house being left alive.’


If, on the one side, it was necessary for the well-being of the country to suppress such desolating feuds in a question of individual property as that at Affane, (noticed in a subsequent paper,) and to prevent the oppressive and cruel extortion established by an Earl of Desmond, in the reign of Edward the Second, called coigne and livery, or the power of levying indiscriminately and at will whatever victuals, provender, and money, his necessities required; so, on the other, the Earl of Desmond seems to have been driven into rebellion by the unrelenting policy of those who had the direction of public affairs. — And it is to be feared there is too much truth in Dr. Curry's opinion, that ‘his vast estate was a strong inducement to the chief governors of Ireland to make or to proclaim him a rebel, their prey being insured to them in either case by his forfeiture.’


As securities for her husband's conduct and pledges of his innocence, their only son, an infant, together with O'Healy, Bishop of Mayo, and O'Rourke, a Franciscan friar of noble descent, were presented to Sir William Drury by the Countess of Desmond; but the Earl, though with expressions of loyalty, declining to comply with the summons of Sir William Pelham, (the successor to Drury as Lord Justice,) and hesitating in obeying the unnatural command to bear arms against his brother, who had been declared a traitor, was 



---

p.70




also proclaimed one himself on the 2d of November, 1579, if he did not surrender within twenty days.


Desmond naturally doubted the faith of those who had already deceived him, by whom his property had been injured, his complaints neglected, and his grievances unredressed. When he complied with the summons of Drury to appear at Kihnallock, whither he came ‘with a well-appointed company of horse and foot, he was committed to custody,’ says Leland, ‘on bare suspicion; but upon making the most solemn promises of loyalty and fidelity, he obtained his liberty, retired from the camp, but refused to attend the deputy, and was therefore still considered as a favourer of foreign invaders and their cause. Upon this bare suspicion, (Sir Nicholas) Malby attacked his town of Rathkeal. — This the Earl considered as an unprovoked and unwarrantable attempt which he was justified in repelling.’


Two members of the council, the Lords Gormanstown and Delvin, refused to sign the proclamation against Desmond, and one hour after it was published, his Countess, we are told, ‘came to the camp to intercede for her unhappy Lord; but the forces had marched towards her husband's country, which they entered with fire and sword.’


The fathers 0'Healy and O'Rourke, who had become sureties for Desmond's loyalty, were executed, and his infant son was sent a state-prisoner to the Tower of London. Even as an additional goad to drive Desmond to desperate measures, the Earl of Ormond, his former rival, was named to take the field against him. So violent was the animosity existing between these two noblemen, that when, on a former occasion, they had agreed to a public reconciliation under the decision of a Special Commission, an aperture was cut in a door for them to shake hands through, ‘each fearing to be poignarded by the other.’


To state Desmond's case with impartiality, it is necessary to point 



---

p.71




out that his haughty and tyrannic disposition made him regard the acts of others with suspicion; and though of English extraction, in common with most Irish chieftains, he knew not how to demean himself as a subject, and resisted every encroachment on his feudal dignity. A more dangerous man, therefore, to any peaceable government could not have existed — arrogant, oppressive, and ferocious. Irritated at the severe conduct of the English governors towards him, whom an invasion compelled to adopt decisive measures, the enraged Earl, collecting his followers on the Ballyhoura 
mountain, for the first time appeared as the avowed enemy of Queen Elizabeth, and proceeded to attack the town of **Youghall**, which he captured without much opposition, and deposited the plunder in his castles of Strancally and Lisfinneen, having garrisoned them with the invading Spanish troops. Elated by this success, the Earl, with a view to intimidate Sir William Pelham, wrote to him, stating that he had entered into a league for the defence of the catholic religion with the King of Spain, under the sanction of the Pope, and invited Sir William to co-operate with them. Immediately on such a declaration, Lord Ormond and Sir Warham St. Leger made a fierce attack on the estates of Desmond, destroying the tillage, burning and ruining his castles, and murdering, in cold blood, the foreigners by whom they were garrisoned.


A series of acts of devastation on the part of the English, that were vainly opposed by Desmond, ensued for six months, at the end of which time that nobleman, his Countess, and Saunders the Papal Legate, escaped with their lives only from the royal troops, and Lady Desmond once more appeared before the Lord Justice, beseeching him in tears and on her knees, forgiveness and pity for her consort. But Sir William Pelham remained inexorable; and coldly speaking of the Queen's clemency, referred to her Majesty's mercy, at the moment when Lord Desmond's brother, Sir James, was condemned 



---

p.72




and executed by martial law, and his reeking limbs exposed to the public gaze on the gates of **Cork**.


A mutiny amongst the English army was suppressed by openly giving up Desmond's country to plunder instead of their pay; and the greater part of the population, to escape the revolting cruelties attendant on military exaction, fled for protection and found it, from the bravest and most noble of enemies — a British seaman — Sir William Winter, the Vice-Admiral of England, who was stationed off the coast of **Kerry** to intercept reinforcements from Spain, receiving many of the despairing fugitives on board his squadron.


During this time, the garrison of **Kilmallock** kept the adherents and forces of Desmond in check, so as to prevent their forming an union with the disaffected of the northern provinces, particularly with Lord Baltinglass, notwithstanding an effort made by Sir John of Desmond and Dr. Saunders. in which their attendants were made prisoners; and shortly after, Captain Zouch, the companion in arms of **Raleigh**, surprised, near Castle Lyons, Sir John, with his relative James Fitz John, of Strancally, both of whom were executed, and their mangled remains displayed in barbarous triumph.


Pursued from one retreat to another, the Earl of Desmond, after many ineffectual efforts at reprisal, and several narrow escapes, was forced ‘to keep his Christmas (1582) in Kilquegg wood, near **Kilmallock**,’ where being attacked, his followers were all put to the sword, and he and his Countess escaped by remaining concealed under a bank of the river, up to their chins in water. About the middle of the following year, Desmond's chief force, consisting only of sixty gallowglasses, was surprised in the act of boiling horse-flesh, and half of them slain by a party from **Kilmallock**, in Harlow or Agherlow wood. On the death of Dr. Saunders, who perished miserably, having fallen a victim to famine and the effects of exposure to the weather, and whose body was discovered partially 



---

p.73




devoured by wolves, an intimation was made to Desmond that, on submission, his individual pardon would be granted; but the same unyielding spirit that animated this Earl at Affane inspired his reply — ‘Tell the Lords Justices,’ said Desmond, ‘that I would rather forsake my God than forsake my men!’


In September following, the Earl, accompanied by three horsemen and a priest, encountered a party of Lord Roche's followers, from whom, being well mounted, they escaped, except the priest, who gave a lamentable account of the extremes to which Desmond was reduced.


The last scene of the Earl's life is, however, the most tragical. His necessities having compelled him to take some cattle belonging to a poor woman, he was pursued by a few musketeers and kerns in the English pay, who on entering a little grove, in a lonely and mountainous glen, four miles east of **Tralee**, about midnight, discovered, seated round the fire of a ruinous hovel, four or five of Desmond's known adherents, all of whom immediately fled on their entrance, leaving one venerable and powerless old man: a soldier, named Daniel Kelly, made a blow at him with his sword, and wounded him so severely as almost to dissever his arm; repeating the blow, the old man ejaculated, ‘Spare me, spare me, I am the Earl of Desmond.’ But the appeal was made in vain; for Kelly struck off his head and conveyed it to the Earl of Ormond, by whom it was sent over, ‘pickled in a pipkin,’ to England, where it was spiked on London Bridge; and his body, after eight weeks concealment, obscurely interred in the little chapel of **Killanamana** in **Kerry**. For this service Elizabeth's ‘well-beloved subject and soldier, Daniel Kelly,’ was rewarded with a pension of twenty pounds yearly, which he enjoyed for many years, but was ultimately hanged at Tyburn.


The account given by **Spencer** of the state of Desmond's country, who was a spectator of it, exhibits a dreadful and impressive picture of the calamitous effects of civil warfare. He tells us, that ‘any 



---

p.74




stony heart would rue the same. Out of every corner of the woods and glynns they’ (the people of **Munster**) ‘came creeping forth upon their hands, for their legs could not bear them — they looked like anatomies of death. They spake like ghosts crying out of their graves; they did eat the dead carrions, happy where they could find them, yea, and one another soon after, insomuch, as the very carcases they spared not to scrape out of their graves; and if they found a plot of water-cresses or shamrocks, there they flocked as to a feast for the time, yet not able to continue there withal; — that in short space there was none almost left, and a most populous and plentiful country suddenly became void of man and beast.’


In the Earl of Ormond's services against Desmond, the destruction of 46 captains, 800 notorious traitors, and 4000 common soldiers is enumerated; yet a letter that has been preserved in the Scrina Sacra, from Desmond to Lord Ormond, is written in that tone of submission which renders it but too probable that vindictive motives alone urged the latter to refuse every overture of Desmond's to obtain mercy.


Neither the death of Desmond nor the depopulation of the country restored tranquillity to the south of Ireland; and Elizabeth, by the advice of Sir Robert Cecil, sent over James, the only son of the late Earl, who had been educated in the Tower, under the eye of the English government, in expectation that the adherents of his father would rally around their young Lord and become peaceable subjects. This was the more desirable, as a remaining member of the family, termed in history the Sugan Earl, had assumed the title of Desmond, and appeared in arms against the Queen.


Reared in confinement, inexperienced in popular tumult, and ignorant of political intrigue, the young Earl James arrived at **Youghall** on the 14th of October, 1600, under the guardianship of Captain Price, and submissively waited on the Lord President of **Munster**, to whom he delivered dispatches explanatory of the purpose 



---

p.75




of his journey into Ireland, and his patent of creation as Earl of Desmond, copies of which may be found in the Pacata Hibernia. The President sent the young Earl to **Kilmallock**, whither the news of his coming had preceded him, and the followers of the Desmond family crowded to welcome their chief, ‘insomuch as all the streets, doores, and windowes, yea the very gutters and tops of the houses were filled.’ — ‘That night the Earle was invited to supper to Sir George Thornton's, who then kept his house in the town of **Kilmallock**; and although the Earle had a guard of soldiers which made a lane from his lodgings to Sir G. Thornton's house, yet the confluence of the people that flockt thither to see him was so great, as in half an hour he could not make his passage through the crowd, and after supper he had the like encounters at his returne to his lodging.’ Old and young hurried into **Kilmallock** from the surrounding districts, the former showered their blessings on the Earl, the latter offered their vow of allegiance; and, according to an ancient custom, every one flung upon him handfuls of wheat and salt, as a prediction of future peace and plenty, so powerful was the bond of feudal clanship.


James, the young Earl, had been brought up a protestant in England, and the day following his arrival at **Kilmallock**, being Sunday, he attended service in the parish church. On his return his followers collected around him, and with tears and groans reproached him with his apostasy. They implored him on their knees not to forsake the religion of his fathers. James meekly urged, in reply to their vehement entreaties, the plea of religious toleration to be the true spirit of the Gospel; but this reasoning did not satisfy his adherents; they looked on him as an agent of the English government, sent amongst them to sap the foundation of their faith; and the very voices that yesterday were loudest in acclamations of joy, swelled the uproar of imprecations poured upon James Fitzgerald, for they denied his right to the title of his ancestors, whose 



---

p.76




religion he had renounced. Every mark of ignominy and insult was heaped upon him by the infuriated crowd — they cursed him, they spit upon him; and abandoning **Kilmallock**, left the Earl of Desmond to return to England, where he died in obscurity a few months after. His dissolution is announced in the Pacata Hibernia, with an air of the greatest sang-froid. — ‘The eleventh (January, 1601) the Lord President had intelligence from England that James (the late restored Earle of Desmond) was dead, and that eighteen hundred quarters of oates were sent into **Munster** for the reliefe of our horses.’


The fate of the Sugan Earl, as he is styled, was little more fortunate than that of his predecessor. After one or two defeats he was hunted from place to place, and so closely followed that it was often known to his pursuers where he had been concealed the preceding night.[5](javascript:footNote('E820000-001/note005.html')) The **Galtee mountains** were the chief retreat of the Sugan Earl; and his kinsman, the White Knight, being induced by money or fear, perhaps both, betrayed and seized him as he lurked in the cave of **Skeenarinky**, not far distant from **Mitchelstown**. Being forcibly carried to **Kilmallock**, he was thence conveyed to **Cork**, where he was tried and found guilty of being a traitor, on the 14th of August, 1601. But his life was spared by a piece of state policy; and the Earl, transmitted to the Tower of London, died there a prisoner, after seven years confinement, and was buried in its chapel. His brother John emigrated to Spain, and was distinguished as Earl or Count of Desmond, which title was also given to his son, Gerald, 



---

p.77




who died in the service of a foreign court, without issue, about the year 1632.


The inhabitants of **Kilmallock** received a charter from Elizabeth, dated the 15th of April, 1584, granting them some valuable privileges on account of their good services against that ‘arch-traitor’ Desmond, during whose rebellion the place had been more than once plundered and set on fire. In the subsequent contests which have distracted Ireland, the town was used as a garrison, but there is nothing memorable recorded of it.


The title of Viscount Kilmallock was bestowed on Sir Dominick Sarsfield; and the circumstances attendant on that creation are somewhat remarkable from the title of Viscount Kinsale having been first conferred on him, notwithstanding its existence in the De Courcy family, who immediately petitioned the King on this usurpation of their right; and the Privy Council having confirmed it, Sir Dominick was forbidden to use the name of Kinsale and styled Viscount Sarsfield, with permission to make choice of any other, and he accordingly took that of **Kilmallock**, which was confirmed by letters patent, dated the 17th of September, 1627.




---

p.78


Fairies and supernatural agency
-------------------------------



> 1. Such airy beings awe th' untutored swain,
>   
> Nor thou, tho' learn'd, his homelier thoughts neglect.
> 


**Collins**. *Verse II, Ode on the popular superstitions of the Highlands of Scotland considered as the subject of poetry, William Collins*


In common with other countries, particularly the Highlands of Scotland, a traditional belief exists amongst the Irish peasantry in those romantic little sprites denominated Fairies; and it is wonderful, considering their being creatures of imagination, that the superstitions respecting them should have remained so much confined, and so very similar. Whether the fairy mythology of Ireland has been derived from the East, and transmitted thence through the medium of Spain, or has, as some believe, a northern origin, it is of little import to inquire, particularly as nothing more than conjecture can now be advanced on the subject. It is, however, evident, that the present fairies of Ireland, if not Gothic creations, were at least modelled in the same school and age with the elves of northern Europe.


There is an odd mixture of the ridiculous and the sublime in the prevalent notions respecting such beings. Nor could there have been invented a more extraordinary medium between Man and his Maker. 



---

p.79




The most esteemed novelist of the present day has happily described these curious creations of the mind, as 


> 1. That, which is neither ill nor well;
>   
> That, which belongs not to Heaven or Hell;
>   
> A wreath of the mist, a bubble of the stream,
>   
> 'Twixt a waking thought, and a sleeping dream,
>   
> A form that men spy
>   
> With the half-shut eye,
>   
> In the beams of the setting sun am I!
> 

 *Sir Walter Scott, The Monastery Chapter 9.*


Partaking both of the human and spiritual nature, having immaterial bodies, with the feelings and passions of mortality, fairies are supposed to possess both the power and the inclination to revenge an affront; and the motive of fear, which induces some savage nations to worship the Devil, prompts the vulgar in Ireland to term fairies ‘good people,’ and in Scotland ‘guid folk;’ nor is it uncommon to see a rustic, before drinking, spill a small part of his draught upon the ground, as a complimentary libation to the fairies. Such as use the word fairy, are often corrected in a whisper, which caution arises from conceiving that these beings are invisibly present, and the appellation is considered offensive, as denoting an insignificant object. Thus, hoping to deceive by flattery, the maxim most attended to in the intercourse with these ‘little great ones,’ is, that ‘civility begets civility.’ Doubtless, on the same principle, the Greeks, as observed by **Augustus Schlegel**, called their fairies Eumenides, or the benevolent, and assigned for their habitation a beautiful grove. ‘I cannot think of this policy,’ said my friend C — , ‘without fancying a grin on Medusa, and those little urchins the northern fairies, holding their sides with laughter.’ The same system of fear and flattery seems to have existed amongst the Irish, even towards animals, in the time of Elizabeth; for **Camden** tells us, ‘they take unto them wolves, ta be their *godsibs* (gossips), whom 



---

p.80




they tearme *Chari Christ*, praying for them, and wishing them well, and so they are not afraid to be hurt by them.’


The circular intrenchments and barrows, known by the name of Danish forts,[6](javascript:footNote('E820000-001/note006.html')) in Ireland, are pointed out as the abode of fairy communities, and to disturb their habitation, in other words to dig, or plough up a rath or fort, whose construction the superstitious natives ascribe to the labour and ingenuity of the ‘good people,’ is considered as unlucky and entailing some severe disaster on the violator and his kindred. An industrious peasant, who purchased a farm in the neighbourhood of **Mallow**, from a near relative of mine, commenced his improvements by building upon it a good stone house, together with a lime kiln. Soon after, he waited on the proprietor, to state ‘the trouble he was come to by reason of the old fort, the fairies not approving of his having placed the lime-kiln so near their dwelling; — he had lost his sow with nine *bonniveens* (sucking pigs), his horse fell into a quarry and was killed, and three of his sheep died, ‘all through the means of the fairies’.’ Though the lime-kiln had cost him five guineas, he declared he would never burn another stone in it, but take it down, without delay, and build one away from the fort, saying, he was wrong in putting that kiln in the way of the ‘good people,’ who were thus obliged to go out of their usual track. The back door of his house unfortunately also faced the same fort, but this offence was obviated by almost closing it up, leaving only a small hole at the top, to allow the good people free passage, should they require it. In these raths, fairies are represented as holding their festive meetings, and entering into all the fantastic and wanton mirth that music and glittering banquets are capable of inspiring. A fairy chieftain, of much local celebrity, named Knop, is supposed to hold his court in a rath, on the road side between **Cork** and **Youghall**, 



---

p.81




where often travellers, unacquainted with the country, have been led astray by the appearance of lights, and by alluring sounds proceeding from within; but when 


> 1. The village cock gave note of day,
>   
> Up sprang in haste the airy throng;
>   
> The word went round, 'away! away!'
>   
> The night is short, the way is long.
> 

 

and the delicious viands change into carrion. The crystal goblets become rugged pebbles, and the whole furniture of the feast undergoes a similar metamorphosis.[7](javascript:footNote('E820000-001/note007.html'))


An eddy of dust, raised by the wind, is attributed to the fairies journeying from one of their haunts to another; on perceiving which, the peasant will obsequiously doff his hat, muttering, ‘God speed ye, God speed ye, Gentlemen;’ and returns it to his head, with the remark, ‘good manners are no burthen,’ as an apology for the motive, which he is ashamed to acknowledge. Should he, however, instead of such friendly greeting, repeat any short prayer, or devoutly cross himself, using a religious response, the fairy journey is interrupted, and if any mortals are in their train, the charm by which they were detained is broken, and they are restored to human society. On these occasions, the production of a black-hafted knife is considered as extremely potent in dissolving the spell. This weapon is believed to be effective not only against fairy incantation, but also against any supernatural being; and accounts of many twilight 



---

p.82




rencontres between shadowy forms and mortals are related, to establish its power, gouts of blood or jelly being found in the morning on the spot where the vision had appeared. A respectable farmer has been pointed out to me, whose familiar appellation in Irish was ‘Kill the Devil,’ from the report of his having quelled, by means of a black-hafted knife, a phantom that long had haunted him.


A stanza, containing the truck of a fairy procession, is preserved by **Dr. Neilson** in his Irish Grammar; and, as a curiosity, the translation may be worth copying:


Paying a fleeting visit to many an ‘airy castle, rath, and mount,’ Finvar and his troop hold their course, from dawn of morn till fall of night, on beautiful winged coursers 


> 1. Around Knock Grein and Nock na Rae,
>   
> Bin Builvin and Keis Corain
>   
> To Bin Eachlan and Loch Da can,
>   
> From thence north-east to Sleive Guilin
>   
> They traversed the lofty hills of Mourne,
>   
> Round high Sleive Denard, and Balachanèry,
>   
> Down to Dundrin, Dundrum and Dunardalay,
>   
> Right forward to Knock na Feadalea
> 

 

the latter name signifying in English, the Musical Hill, so called from the supernatural strains supposed occasionally to proceed from it.


The most romantic dells are also pointed out as scenes of fairy resort, and distinguished by the term, ‘gentle places;’ beetling linen by the side of a rocky stream that murmurs through an unfrequented glen, is represented as a favourite, or rather common female fairy occupation, where they chaunt wild and pathetic melodies, beating time with their beetles. The herbs and plants, with which such glens abound, are considered as under fairy influence, and are collected, with many ceremonies, for charms, by cunning old women, termed ‘Fairy Doctors,’ or, sometimes, from their professed knowledge of surgery, ‘Bone Setters’ A confidence in superstitious 



---

p.83




quackery exists so strongly amongst the lower orders in Ireland, that many instances are known to me where patients have been carried a distance of several miles to a ‘*Bone Setter*,’ to whom a fee was given; when they might have received, without removal, and free of expense, every attendance from the most skilful surgeons. ‘I would not, if all the doctors in Ireland told me so, treat the poor sufferer thus,’ is the prefatory sentence used by these ‘wise women.’ ‘What do doctors know about sick people? — but take the herbs which I shall give you, bury them at sun-set in the north-east corner of the fort-field, and when you return, tie a thread three times round the left-hand upper post of the sick person's bed, and let it remain there for nine nights,’ — &c. **Camden**, it would seem, had some faith in the efficacy of these ‘skilful women,’ who, ‘by means of charms,’ to use his own words, ‘gave more certain judgment of the disease than many of our physicians can.’


Fairies are represented as exceedingly diminutive in their stature,having an arch and malicious expression of countenance, and generally habited in green, with large scarlet caps; hence the beautiful plant Digitalis Purpurea is named ‘Fairy Cap’ by the vulgar, from the supposed resemblance of its bells to this part of fairy dress. To the same plant, many rustic superstitions are attached, particularly its salutation of supernatural beings, by bending its long stalks in token of recognition.


Old and solitary thorns, in common with the digitalis, are regarded with reverence by the peasantry, and considered as sacred to the revels of these eccentric little sprites, whose vengeance follows their removal. Any antique implement casually discovered by the labourer is referred to the fairies, and supposed to have been dropped or forgotten by them; small and oddly-shaped tobacco pipes, frequently turned up by the spade or the plough, the finder instantly destroys, to avert the evil agency of their former spiritual owners. Amongst those remains may be noticed the flint arrowheads,



---

p.84




said to be sportively shot at cattle, by the fairies; and in compliance with the popular superstition termed, even by antiquarians, ‘elf arrows.’


The fairies are believed to visit the farm-houses in their district on particular nights, and the embers are collected, the hearth swept, and a vessel of water placed for their use before the family retire to rest. But these dubious divinities seem to preside more especially over cattle, corn, fruits, and agricultural objects. Milking the cows, upsetting the dairy pans, and disarranging whatever may have been carefully placed in order, are amongst their mischievous proceedings. Cluricaune or Leprehaune is the name given to the Irish Puck. The character of this goblin is a compound of that of the Scotch Brownie and the English Robin Good fellow. He is depicted (for engraved portraits of the Irish Leprehaune are in existence) as a small and withered old man, completely equipped in the costume of a cobler, and employed in repairing a shoe. A paragraph recently appeared in a Kilkenny paper stating, that a labourer, returning home in the dusk of the evening, discovered a Leprehaune at work, from whom he bore away the shoe which he was mending; as a proof of the veracity of his story it was further stated, that the shoe lay for the inspection of the curious at the newspaper office. The most prominent feature in the vulgar creed respecting the Leprehaune is, his being the possessor of a purse, supposed to be, like that of Fortunatus, inexhaustible; and many persons, who have surprized one of these fairies occupied in shoe-making, have endeavoured to compel him to deliver it; this he has ingeniously avoided, averting the eye of his antagonist by some stratagem, when he disappears, which it seems he has not the power of doing as long as any person's gaze is fixed upon him.


Fairy children, I have been assured, are frequently seen in lonely glens, engaged in mimic fights and juvenile gambols. A story, related by **Gervase of Tilbury**, in the Otia Imperialia, and mentioned 



---

p.85




in the Minstrelsy of the Scottish Border as current, with only slight variations, both in the highlands and lowlands of Scotland, is equally so in the south of Ireland, and is perhaps the most common of fairy fictions.


A woman, who had been abstracted to nurse a young fairy, during her residence amongst the supernatural community, accidentally anointed one of her eyes with a substance entrusted to her for the use of her infant charge. On being emancipated from captivity, the ‘good people’ still remained visible to the eye which had been touched by the magic ointment, and hence she daily beheld them engaged (like the sylphs in **Pope**'s Rape of the Lock) in their various fairy avocations. The woman, however, remained a silent spectator, until, happening to recognise, sporting amongst others, the fairy child whom she had nursed, in all the delicate bloom and beauty of unearthly youth, her prudence forsook her, and, at the sight, she was betrayed by her feelings into an exclamation of delight; on hearing which, the young fairy approached his nurse, and inquired by what means she was conscious of his presence. — She pointed to the anointed eye, into which he instantly darted a spear that he held in his hand, and thus, by destroying the organ, shut out for ever the secrets of the invisible world from the mortal eye to which they had been revealed.


When a child appears delicate, or a young woman consumptive, the conclusion is, that they are carried off to be made a playmate or nurse to the young fairies, and that a substitute, resembling the person taken away, is deposited in their place, which gradually declines, and ultimately dies. The inhuman means used by ignorant parents to discover if an unhealthy child be their offspring or a changeling:, *The following text is reproduced from a note:*

> 1. From thence a fairy thee unweeting reft,
>   
> There as thou slepst in tender swadling band,
>   
> And her base elfin brood there, for thee left:
>   
> Such, men do *changelings* call, so chang'd by fairies theft.
> 




*Spenser* (the name given to the 



---

p.86




illusitory image,) is, placing the child, undressed, on the road side, where it is suffered to lie a considerable time exposed to cold. After such ceremony, they conclude a natural disorder has caused the symptoms of decay; and the child is then treated with more tenderness, from an idea, that had it been possessed by a fairy, that spirit would not have brooked such indignity, but made its escape. Paralytic affections are attributed to the same agency, whence the term ‘fairy struck;’ and the same cruel treatment is observed towards aged persons thus afflicted.


A pleasing ballad, by my friend Mr. Anster, has been founded on this superstition; the mother is supposed to speak. 


> 1. The summer sun was sinking
>   
> With a mild light calm and mellow,
>   
> It shone on my little boy's bonny cheeks,
>   
> And his loose locks of yellow.
> 2. The robin was singing sweetly,
>   
> And his song was sad and tender;
>   
> And my little boy's eyes, as he heard the song,
>   
> Smiled with a sweet soft splendour.
> 3. My little boy lay on my bosom,
>   
> While his soul the song was quaffing;
>   
> The joy of his soul had ting'd his cheek,
>   
> And his heart and his eye were laughing.
> 4. I sat alone in my cottage,
>   
> The midnight needle plying;
>   
> I feared for my child, for the rush's light
>   
> In the socket now was dying.
> 5. There came a hand to my lonely latch,
>   
> Like the wind at midnight moaning,
>   
> I knelt to pray — but rose again
>   
> For I heard my little boy groaning!
> 6. I crossed my brow, and I crossed my breast,
>   
> But that night my child departed!
>   
> They left a weakling in his stead,
>   
> And I am broken-hearted!
> 
> 
> ---
> 
> p.87
> 
> 9. Oh! it cannot be my own sweet boy,
>   
> For his eyes are dim and hollow,
>   
> My little boy is gone to God,
>   
> And his mother soon will follow.
> 10. The dirge for the dead will be sung for me,
>   
> And the mass be chaunted meetly;
>   
> And I will sleep with my little boy
>   
> In the moon-light churchyard sweetly.
> 

 *John Anster, The Fairy Child*



Sometimes an intricate legal question arises in the case of a young woman being carried off by the fairies, and returning after an absence of several years, which is by no means uncommon, when she finds her husband married to a second wife. More than one instance of this unexpected re-appearance has come within my own knowledge, and I select the relation contained in a letter which I received during the present year, from its being the most recent case. — ‘The day before I left Island Bawn,’ says the writer, ‘I heard of an Irish Kilmeny, in the person of the wife of a labouring cottager, who, having died about twenty years since, and been buried with the usual ceremonies, the poor man allowed a reasonable period to elapse, and subsequently took unto himself another helpmate, with whom he had since continued to live; when one night last winter (1820), they were disturbed by a woman vociferously claiming admission into their cabin, and asserting her right to the full and undisturbed sovereignty of the same, inasmuch as she was the owner's true and lawful wife, whom he supposed deceased and interred, whereas she had only been with the fairies, from whose power she had now emancipated herself. So minute and clear (if not satisfactory) did she make out her title, that both the husband and his second spouse quailed before this unwelcomed visitant from the ‘good people.’ The first wife allowed her locum tenens to remain in the house while she behaved herself respectfully, and all went on smoothly for some time, the stranger supporting the truth of her story by mysteriously telling the 



---

p.88




fortunes of those who flocked to see so wonderful a woman. Being,’ continues the writer, ‘unable to pay her a visit myself, I requested a young lady who was staying at my sister's to do so, and who was much more qualified than I should have been to elicit, if possible, the truth. With her usual kindness, she undertook the task; and I cannot do better than copy her letter to my sister: 


> Ballyhogan, 6th January, 1821.
> My dear Mrs. L.
> 
> 
> In compliance with your brother's request, I have sat down to give you an account of my visit to the fairy woman. On Thursday morning last, having procured a guide to show me the way to her house, I departed on my mission, and, after a walk of about four miles, arrived at the little village of Castle Town, on the Shannon. ‘That white house *younder*, Miss, is the one the fortune-teller lives in,’ said my guide. I was readily admitted, and found the inside thronged with visitors, to whom the diviner talked in the common gipsy strain. Being more anxious to hear her own story than any thing she could tell me of myself, I asked her if the report respecting her having recently returned from the fairies was correct. Her reply was, that she had been with the ‘good people’ many years, and, as a reward for her conduct while amongst them, they had bestowed the gift of fortune-telling. I then begged her to inform me of some further particulars; and, after considerable hesitation on her part, and persuasion on mine, she gave me the following history, which I will recount verbatim, as highly illustrative of fairy superstition and Irish manners:
> 
> 
> My Father, whose name was Thady Donohoe, lived in a little place they call Mount Shannon, near Slain; he was a shoemaker, and supported his family by his work until he lost his health through grief at my folly in not being led by his advice; and I'm *sartin shure* (certain sure, confident) I suffered all I did for going against my father! He loved me *bitter* (better) than any of his *childer* (children), 
> 
> 
> 
> ---
> 
> p.89
> 
> 
> 
> 
> because he had no *deaghter* (daughter) but myself; and at eighteen he thought to get me married to a neighbour's son, who was *a neat boy* (a handsome fellow); and, indeed, not that I say it, I was a neat, clean skinned girl at that time, though I may deny it to-day; but I was fond of a young man who was working as a labouring boy at a farmer's house *handy by* (adjacent). Well, when I *tould* (told) Paddy Doody, for that was my lover's name, what my father wished me to do, he said, if I did not run away with him, my father and my brothers would make me marry the other boy, and he should kill himself or go distracted: so I went off with him *shure enough* (without hesitation), and we were married by his parish priest as soon as we came to Castle Town. I never saw my father till he was dying, which was about six months after: he gave me his blessing and a cow before he died. After the funeral I came back to my husband, and we lived very happily for four years. My eldest little boy died, and I was nursing my second, when one night, about Midsummer, as we were sitting at our supper, I was fairy struck, and fell off my chair. So *with that* (instantly), poor Paddy ran out for one of the neighbours, who desired him send for the priest, which he did *to be shure* (as a matter of course). But when he came, he did not know what to do, but said prayers over me, and anointed me for death; and when the holy oil was put on me I was better, and continued to mend for several days, but I was still very weak and low; I had an *impression about* (oppression on) the heart, and a dimness in my eyes, and a ringing in my ears, and my face was greatly altered. Well, one night after we all lay down to sleep, it was about twelve o'clock, I heard a great noise, and saw a light in the room. I called Paddy, but he could not hear me. My little child was about three months old, and lay asleep by my side. In one minute the house was full of people, men and women, but no one saw them but myself; and one of the women came to the side of the bed, and said, ‘Judy, get up, you are to come with us, and I will put one in your place to nurse your child.’ So with 
> 
> 
> 
> ---
> 
> p.90
> 
> 
> 
> 
> that they dragged me out of bed, and put an old woman in my place, who took my *cratur of a child* (creature, a term of endearment) in her arms! I thought I should die, but I could not speak a word. They took me off with them, and there were several horsemen with red caps outside the door, and the women who sat behind them on the horses had blue cloaks. There was a piper on a grey pony that led the way; and when I got to their dwelling I was given a child to nurse. I am not allowed to tell any thing that happened while I was there, all I can say is that I never ate one mouthful of their food: if I did I never could have left them. I came every night to my own house for cold potatoes, and I lived on them. Paddy buried, as he thought, the old woman that was put in my place, but she came away to us. I am twenty years from home, and my husband is married again. This is my son's house. When I came home Paddy would not own me, but I soon *made him sinsible* (convinced him) I was his wife. I have suffered more than I can tell any one while I was with the ‘good people’; and I promised the Blessed Virgin, if she would release me, to do six months' *pinnance* (penance) at a holy well in the King's County, where I am going next week; if I live to return, my son will let me pass the rest of my days with him should my husband not allow me.
> 
> 
> 

’


Dr. Neilson gives us, with every appearance of authenticity, a more intricate matrimonial case than the foregoing, where the woman, on her return from Fairyland, finding her first husband married, marries again herself. The second wife of the first husband dies, and he, having discovered his former spouse, claims her; but her second husband being unwilling to part with her, denies the claim. The question is referred to an ecclesiastical tribunal, where fairy agency will not be acknowledged, and which, under conflicting testimony, is unable to determine the matter. It, however, ultimately terminates in the friendly arrangement, ‘That both doors of the woman's second husband's house should be set open; that Joyce (her 



---

p.91




former husband) should stand seven steps from the street-door, and Thady, in the garden, seven steps from the back-door; that she should take her choice, and abide by it thenceforward.’ — ‘The child was sleeping in the cradle, and as Mary was about to depart she went to the child to take leave of it and shed a tear. She went then towards the street-door, when she heard the child cry after her; presently she returned, and remained without murmuring or uneasiness with Thady Hughes till her death.’


A curious spirit, and one I believe peculiar to Ireland, is the Banshee, or White Fairy, sometimes called She Frogh, or the House Fairy. The derivation of both these names appears to me obvious from the credulous personification, that of a small and shrivelled old woman with long white hair, supposed to be peculiarly attached to ancient houses or families, and to announce the approaching dissolution of any of the members by mournful lamentations. This fairy attendant is considered as highly honourable, and in part of an elegy on one of the knights of Kerry, still extant, the family Banshee is introduced as deploring, with wailing accents, the knight's impending fate; when every trader at **Dingle** who hears the strain becomes alarmed lest it should forebode his own death; but the bard assures them, with an air of humorous sarcasm, they have no cause for uneasiness, such warning being given only to those of illustrious descent.


Another species of Irish fairy is the Phooka, the descriptions given of which are so visionary and undefined it is impossible to reduce them to detail. The name of many lonely rocks and glens in Ireland declares them sacred to this spirit. In the county **Cork** there are two castles called Carrig Phooka, or the Phooka's Rock, one near **Doneraile**, the other not far from **Macroom**; and in the county Wicklow, the celebrated waterfall of Poula Phooka, or the Phooka's Cavern, is well known.


Notwithstanding the universal belief in fairy influence, the credence 



---

p.92




given to witchcraft amongst the vulgar Irish is by no means proportionate. Some few instances are historically preserved, but, considering the extent and reputation which witchcraft obtained during the reigns of Elizabeth and James I. in England, these may be viewed as imported rather than primitive superstitions. The admirable account of Moll White given in the Spectator presents a collection of the popular notions respecting the sorcery of old women; and those who are inclined to investigate the subject further may find some hundred volumes written upon it.


The most remarkable Irish witch on record is Dame Alice Ketyll (whose history is to be found at length in **Camden**). Amongst the charges made against her, when examined in 1325, was the sacrificing nine red cocks to her familiar spirit or imp, named Robyn Artysson, ‘at a stone bridge in a certaine foure crosse high-way. Item, that she swept the streets of Kilkenny with beesomes between Complin and Courefew, and in sweeping the filth towards the house of William Utlaw her sonne, by way of conjuring uttered these words: 

  

Unto the house of William, my sonne,
  

Hie all the wealth of Kilkenny town.’


And, amongst ‘the goods and implements of the said Alice, there was a certain holy wafer cake found, having the name of the divell imprinted upon it; there was found also a boxe, and within it an ointment, wherewith she used to besmear or grease a certain piece of wood called coultree, which, being thus anointed, the said Alice, with her complices, could ride and gallop upon the said coultree whithersoever they would, all the world over, through thick and thin, without either hurt or hindrance.’ These things, we are told, were notorious, and dame Ketyll, to avoid punishment, escaped to England; but one of her accomplices, Pernill or Parnell, was burned at Kilkenny, who avouched that Alice's son William ‘deserved 



---

p.93




death as well as herself, affirming that he, for a year and a day, wore the divell's girdle upon his bare bodie.’ Kilkenny seems to have been peculiarly fatal to witches. In October, 1578, Cox relates that Sir William Drury, the Lord Deputy, caused thirty-six criminals to be executed there, ‘one of which was a blackamoor, and two others were witches, and were condemned by the law of nature, for there was no positive law against witchcraft in those days.’


Some more recent account of witches is traditionally preserved in Ireland, particularly of Nanny Steer, whose malign glance produced madness, and the malady of many a wretched lunatic, who wandered about the country, was attributed to her baneful influence.


In the Queen's county a young man, named Rutlidge, on the day of his marriage, is said to have become a victim to one of these dreadful looks, from his having neglected to invite Nanny Steer to the wedding — who appeared an unbidden guest, and casting an evil eye on the bridegroom, he immediately became a maniac.


‘In no case,’ says **Camden**, speaking of Irish superstitions, ‘must you praise an horse or any other beast, until you say, ‘God save him,’ or unless you spit upon him. If any harm befall the horse within three dayes after, they seeke him that praised him, that he may mumble the Lord's Prayer in his right eare. They think that there bee some that bewitch their horses with looking upon them, and then they use the help of some old hagges, who, saying a few prayers with a loud voice, make them well again.’ This belief in the fatal effects of an evil eye is as prevalent at the present day as when **Camden** wrote; and few, if any, of the lower orders will speak to or of a child without spitting out, and excusing himself, should a superior be present, with — ‘It's for good luck sure.’ — ‘And God bless the boy, and make a fine man of him.’ So powerful is this superstition that even people of education and above the ordinary rank, are obliged, from policy, to accommodate themselves to it in 



---

p.94




their intercourse with the peasantry, as few things are considered more dangerous and unfriendly, or are longer remembered, than the omission of such ceremony.


Another vulgar superstition regarding witches, is, their power of assuming the shape of some insect or animal — the most favourite forms are those of a fly or a hare; under the latter disguise they are supposed to suck the teats of cows, and thus either deprive them of their milk or communicate an injurious effect to it.


Of the following story numberless variations are in circulation amongst the Irish peasantry. A herdsman having wounded a hare which he discovered sucking one of the cows under his care, tracked it to a solitary cabin, when he found an old woman smeared with blood and gasping for breath, extended almost lifeless on the floor, having, it is presumed, recovered her natural shape.


In churning, should not the milk readily become butter, the machinations of some witch are suspected. As a test, the iron coulter of the plough is heated in the fire, and the witches name solemnly pronounced, with the following charm, on whom this spell is supposed to inflict the most excruciating tortures, 


> 1. Come butter, come,
>   
> Come butter, come,
>   
> Peter stands at the gate
>   
> Waiting for a buttered cake,
>   
> Come butter, come.
> 




And if the milk has lost its good qualities by means of incantations, it immediately turns to excellent butter.


In the sixteenth century the same opinion existed in Ireland, somewhat tinged with a relic of Pagan or Druidical rites, fire being considered, before the introduction of Christianity, the immediate representative of the Deity, and the first of May as peculiarly sacred to these rites, many relics of which may still be discovered.




---

p.95


‘They take her for a wicked woman and a witch, whatever she be, that commeth to fetch fire from them on May-day, (neither will they give any fire then, but unto a sicke body, and that with a curse,) for because they thinke the same woman will, the next summer, steale away all their butter. If they finde an hare amongst their heards of cattell on the said May-day, they kill her, for they suppose shee is some old trot, that would filch away their butter. They are of opinion that their butter, if it be stollen, will soone after bee restored againe, in case they take away some of the thatch that hangeth over the doore of the house, and cast it into the fire.’


Amongst some Irish manuscripts in my possession, the composition, I apprehend, of the sixteenth and seventeenth centuries, there is a long description, possessing considerable poetic merit, of a contest between Eogan and ‘Conn of the Hundred Battles,’ part of which presents a picture of the appearance of some supernatural hags to the contending chieftains the night previous to the engagement; the translation is extremely literal.


‘When Eogan came back from the council, three witches stood before him; frightful beyond description, with red and fiery-looking eyes, and long, lank, grizzly hair hanging down dishevelled over cadaverous countenances. The eye-brows of these fiends were large, rough, and grim, growing into each other and forming two curvatures of matted bristles. Their cheeks were hollow, shrivelled, and meagre; and their beaked noses, covered with parched skin, issued forth prominently from the deeply-wrinkled and knobby foreheads of these monstrous and filthy she-devils! — Their blasting tongues with flippant volubility held ceaseless gabble, and their crooked yellow hairy hands and hooked fingers resembled more the talons of an eagle or foul-feeding harpy, than the fingers of a human creature. Thus, supported by small inbent and bony legs, they stood before Eogan.’


‘Whence come ye, furies? asked the chief.’


‘We come from afar by our powers, replied they.’




---

p.96


‘I demand to know your powers? said Eogan, leader of the mighty bands.’


‘We cause the sea to run higher than the mountain tops by our breath; we bring snow on the earth by the nodding of our white heads; we spread flames in dwellings by our words; we alter and change the shape of every person, nay of those in our own occupation, by the rolling of our eyes; we — ’


‘Enough! cried the mighty Eogan. I now demand your names.’


‘Our names, returned the hags, are Ah, Lann and Leana; we are daughters of Trodan the magician, and we have come from remote countries to warn you of your approaching death. — For Eogan shall fall by the keen-edged and bone-cleaving sword of the ever-victorious ‘Conn of the Hundred Battles’.’


‘On your own heads may this prophetic warning light, ye hags of hell, returned Eogan; may your forebodings of Conn sink into nothing on the air, and be unanswered by the voices of the mountains. May the trees bear the brunt of your evil words, the venom of your lips fall harmless on the rocks of the valley, and your malice be given to the waves of the ocean.’


‘It is inevitable destiny we speak, said they. — We have spoken without precipitation or without reward; and muttering of their horrid spells they vanished from Eogan.’


‘That night came the same three hags to the tent of the King of Spain's son, and they boded ill to him; and thence they came where the hostes of Conn of the Hundred Battles lay incamped, and they roused that hero with these words: — ’


‘In thy arm be thy strength; in thy sword be thy safety; in thy face be thy foes; in thy strides thy prosperity. — The pride of Ireland is against thee, in life and in motion. Be thou restless as the treacherous light that gleams to benighted travellers.’[8](javascript:footNote('E820000-001/note008.html'))




---

p.97


In the preceding part of the same poem the support and assistance received by Eogan and his tribe from a sorceress named Eadoin, is mentioned; who, in a former engagement, so fascinated the eyes of Eogan's adversaries by her enchantments, that some rocks on the field of battle assumed the appearance of formidable bodies of armed men; and while Goll and the sons Moirne, with their valiant associates, attacked these flinty phantoms, and were occupied in contest with invulnerable and senseless stones, the sorceress conveyed the unwilling Eogan and his followers from the scene of warfare, and embarked them for Spain. ‘The rock,’ adds an English note on this passage of the manuscript, ‘which was converted into the resemblance of Eogan and his troops, is, at this day, called the Scalped Rock — in Irish, Cloch Bhearrha, — in Glean Rogh, near Kin-mare, from the indenture made in it by the arms of Goll, which were shivered and broken into pieces thereon.’


As in England, a worn horseshoe nailed on the threshold, or near the entrance of a house, is considered as a security against witchcraft, but this remedy is used only in the better description of cabins.


Many of the ancient Irish chieftains have received deification, and the credulous believe in their frequent reappearance on earth as the messengers of good tidings, such as a fine season or an abundant harvest. Other shades are compelled to perform certain penitential ceremonies in expiation of crimes committed during life; of the latter may be mentioned an Earl of Kildare, doomed to ride septennially round the Curragh (an extensive common) until the silver shoes of his supernatural steed are worn out. To the former class belongs O'Donoghue, a chief of much celebrity, whose May-day visit on a milk white horse, gliding over the lake of **Killarney**, to the sound of unearthly music, and attended by troops of spirits scattering delicious spring flowers, has been lyrically preserved by Mr. Moore, and is accurately recorded in a poem by **Mr. Leslie** on **Killarney**, and in **Mr. Weld**'s account of that Lake, as also in **Derrick**'s Letters, 



---

p.98




where some additional particulars may be found from the pen of **Mr. Ockenden**.[9](javascript:footNote('E820000-001/note009.html')) — *‘There is a farmer now alive,’ says that gentleman, ‘who declares, as I am told, that riding one evening near the lower end of the Lake he was overtaken by a gentleman, who seemed under thirty years of age, very handsome in his person, very sumptuous in his apparel, and very affable in conversation. After having travelled for some time together, the nobleman (for such he judged him, by his appearance, to be) observed, that as night was approaching, the town far off, and lodging not easy to be found, he should be welcome to take a bed that night at his house, which he said was not very distant. The invitation was readily accepted, they approached the Lake together, and both their horses moved upon the surface without sinking, to the infinite amazement of the farmer, who thence perceived the stranger to be no less a person than the great O'Donoghue. They rode a considerable distance from shore, and then descended to a delightful country under water, and lay that night in a house much larger in size and much more richly furnished than even Lord Kenmare's at **Killarney**.’’’*


Second sight, so common in the Highlands, I believe is unknown in the South of Ireland. Story relates a mysterious appearance of stars, accompanied by heavy groans, that preceded the landing of the rival monarchs William and James, seen by ‘one Mr. Hambleton, of Tollymoore, a justice of the peace in his county, and a sober, rational man;’ in company with others who were journeying towards **Dundalk**; adding, ‘They have a great many tales of this kind in Ireland, and the Inniskilling men tell you of several such things before their battles.’ I should, however, consider these visions, on account of their northern limits, as derived from Scotland, and not genuine Irish superstitions.


I fear it may be considered that I have dwelt too long upon, and 



---

p.99




entered too minutely into the notions of the ignorant; but early associations have tempted me to linger over these marvellous relations, and have, perhaps, misled my maturer judgment. 


> 1. Such fancies are the coinage of the brain,
>   
> Which oft rebellious to more sober thought
>   
> Will these strange phantoms shape; the idle prate
>   
> Of fools and nurses, who in infant minds
>   
> Plant such mishapen stuff, the scorn and scoff
>   
> Of settled reason and of common sense!
> 




On the whole, from what may be collected, the present state of Irish superstition closely resembles that of England during the age of Elizabeth; a strong proof of the correct measurement of those who have stated a space of two centuries to exist between the relative degree of popular knowledge and civilization attained by the sister kingdom.




---

p.100


**Charleville**, Doneraile, and **Buttevant**
---------------------------------------------



> 1. Old father Mole, (Mole hight that mountain gray
>   
> That walls the north side of Armulla dale,)
>   
> He had a daughter fresh as flower of May
>   
> Which gave that name unto that pleasant vale;
>   
> Mulla, the daughter of old Mole so hight,
>   
> The nymph which of that water-course has charge,
>   
> That, springing out of Mole, doth run downright
>   
> To **Buttevant**, where spreading forth at large,
>   
> It giveth name unto that ancient city
>   
> Which Kilnemullah cleeped is of old,
>   
> Whose cragged mines breed greath ruth and pity
>   
> To travellers, which it from far behold!
> 


*Spenser, Colin Clouts come home againe, lines 104-111 (1595).*


**Charleville** is a poor town on the borders of the county **Limerick**, and contains many wretched cabins. It was incorporated, through the interest of the first Earl of Orrery, Lord President of **Munster**, in the reign of **Charles II.**, who gave it, in compliment to that monarch, the name of **Charleville**, being called before, to use his lordship's own expression, ‘by the heathenish one of Rathgogan.’


Lord Orrery held his presidential court here; and possibly in imitation of the example of his predecessor **Sir William St. Leger**, at 



---

p.101


**Doneraile**, built the parish church, enclosed an extensive park, and erected a noble mansion, described by **Story** as ‘one of the second rate houses of these kingdoms,’ which suffered a fate similar to that built by Sir William, being burned in 1690 by a party of James II.'s troops, under the command of the Duke of Berwick, who, having dined there, ordered it, in the most wanton manner, to be set on fire, and remained to see it reduced to ashes. John Exham, the prophetic quaker, hereafter mentioned as the religious associate of **William Penn**, is reported to have predicted this destruction. A large company, on some particular occasion, was assembled at Lord Orrery's, when Exham, with a great crowd of his enthusiastic followers, stood before the door of that nobleman's house, and exhorted the guests to repentance, denouncing the judgment of the Lord upon them, should they not comply, and predicting ruin on the scene of their festivity, which should become an habitation for the fowls of the air.


The Earl's servants, supposing Exham mad, attempted to drive him from the place, but Lord Orrery interfered, commanding them to let the honest man speak. Exham, having concluded his harangue, went away, but in a short time returned, and calling the Earl aside, said to him, ‘Because thou hast been kind and loving to the servant of the Lord, the evil shall not be in thy days;’ the event verified his words, and not a little contributed to raise the character of Exham as a prophet.


A resident of **Charleville**, who appeared well versed in local history, related, with exceeding minuteness, an account of the conflagration as traditionally preserved; and respecting the education of the poor, gave us the gratifying information, that notwithstanding the neglected and inconsiderable appearance of the town, no less than 300 boys and 400 girls were at present pupils in the poor school.


Within a short distance of **Charleville** are the ruins of an old church, called Ballyslough, which we visited; and having loitered 



---

p.102




about the cemetery, we were departing, when a decently dressed man came up, and seeing our sketch books, observed, there was little worth our notice in the churchyard, except that ‘one M'Donald the poet was interred there;’ after some search we found his grave, cleared away the concealing nettles, and I transcribed the almost defaced inscription on a small stone that marked the narrow bed of this unknown bard. 


> 
> I. H. S. 
>   
> 
> Johanes McDonald cogno 
>   
> 
> minatus Clarag vir vere
>   
> 
> Catholicus et quibus linguis
>   
> 
> ornatus nempe Græca Latina,
>   
> 
> et Hybernica non Vulgaris
>   
> 
> Ingenii poeta tumulatur
>   
> 
> ad hunc Cippum obiit Ætatis
>   
> 
> Anno 63 Salutis 1754
>   
> 
> Requiescat in pace.
> 
> 
> 




In addition to the particulars mentioned in his epitaph, all I could learn respecting M'Donald was, that he made a translation of Homer into Irish; and probably, from the appellative Clarah, or Minstrel, being in the Irish character, his poetical compositions were in that language.


When at **Mallow**, I obtained an Irish MS. written by **Shane Clarah,** or ‘John the minstrel.’ It is a small thick quarto of about 400 pages, and the contents are chiefly topographical; from this MS. I have made some quotations in the present work.


Crossing the Ballyhoura mountains towards **Doneraile**, the huts of the peasantry had so cheerless and deplorable an aspect as to awaken a thousand painful ideas. In the smoke and dirt of an Irish cabin, there is a great and positive want of comfort; yet, on observing the neglected means by which the labouring classes might improve their condition, it would almost lead to the belief that they 



---

p.103




are happier in their own way than they could be made by any innovation. Much censure has been thrown upon absentee landholders, whom I will not vindicate; but there seems to be an inherent spirit of indolence and obstinacy in the lower order of Irish, which even the presence of their lord would with difficulty overcome, that thus enables them to live without any apparent notion of comfort or even common decency. They seem indeed to feel some degree of pride in being destitute of wants, and evidently prefer the exclusion of light from their dwellings. When a window of a foot square has been made by their landlord, they usually close it up with turf, boards, or rags, leaving perhaps a strip of an inch broad; in many instances it is closed entirely, and the only light admitted is by the door, to which the women bring their needle work or spinning, on rare occasions of industry when they can forsake the *fascinating* smoke of their turf fires. They are consequently exposed to the weather, and have to rise whenever any inmate requires to pass, or when the pig (who considers himself lord of the mansion) chooses to alter his position; but ‘it just does well enough *sure* — it answered our fathers before us *why*’ They will even defend the filthy practice of having these animals constantly in their dwellings. I recollect once trying to convince a man that he might with very little trouble improve the state of his cabin, by building a shed for his pig and banishing him the chimney corner; but he coolly answered, ‘Sure then and who has a better right to be in it? Isn't he the man of the house? and isn't it he that will pay the rent?’


Most cabins have a small patch of ground attached, where potatoes and winter cabbages are the only vegetables cultivated. An Irish labourer has no idea of planting a bush, or fruit tree, or of raising a flower; and his ignorance renders him too stubborn to make trial of improved agricultural implements. The beneficial effects of Baronial Farming Societies, formed under the Cork Institution, are, however, obvious in many districts of the southern counties.




---

p.104


**Doneraile** is twelve miles distant from **Charleville**, and was described as a neat village; the residence of Viscount Doneraile, whose mansion, surrounded by a park of considerable extent, is close to the village, and said to be worth seeing; we were unable to judge of this fact, the porter at the park gate pleading his lordship's positive orders to admit no strangers. This was the only occasion on which we met with difficulty in seeing any gentleman's grounds, though not personally acquainted with the owner. After exploring the unpicturesque and miserable town we returned to our dirty inn. It being the 19th of July, his Majesty's coronation was celebrated by illuminations, which, considering the poverty of the place, were very respectable. Every window, even those of the meanest cabins, added their mite towards the general display of rush lights; but a smart shower of rain about ten o'clock dispersed the crowd of admiring peasantry, some of whom had walked many miles to witness this little jubilee. This display of loyalty accorded well with the history of the St. Legers, maternal ancestors to the present noble proprietor of **Doneraile**, a family distinguished in Irish history for their active and persevering support of the English interest, and faithful discharge of the trust reposed in them by that government, which was justly rewarded by titles and considerable estates. Sir Anthony St. Leger, one of the commissioners sent over for arranging the affairs of Ireland by Henry VIII. in 1537, was the founder of the family in Ireland; and so satisfied was Henry with his conduct as commissioner, that three years after he was appointed to the important office of Lord Deputy. Under his administration, and chiefly through his exertions, an act was passed that may be said to have laid the foundation of the Union between the Sister Islands.


Since the conquest of Ireland by Henry II., the English monarchs had been only styled *Lords* of Ireland, but in 1541, a statute was enacted declaring Henry VIII. and his successors *Kings* of that country.




---

p.105


The change of title immediately appeared on Henry's Irish coinage, remarkable from being impressed with the earliest known representation of the harp, as symbolic of Ireland; since which time that instrument has been preserved as the national arms, an emblem at once complimentary and judiciously selected, that, to use the words of a celebrated antiquary, ‘neither reminds us of our present dependence, nor upbraids us with our former rebellions.’


Amongst the important services rendered by Sir Anthony St. Leger to the English cause, may be enumerated the inducing Con O'Neil (who still retained the dignity of a prince) to repair to England, and formally receive his possessions from the King at Greenwich, who conferred on him the title of Earl of Tyrone: his example was soon followed by other Irish chieftains. Through the exertions of Sir Anthony, the lords of most of the Irish clans, and such of the English settlers as had become naturalized, made a formal submission to the English government; and kneeling at the Lord Deputy's feet without their girdles, skeins, and caps, acknowledged Henry as their ‘only true and liege lord,’ being the fourth general declaration of the Irish to the same effect.


At the instance of Sir Anthony, many statutes were likewise enacted, and officers appointed to carry them into effect, a measure intended to subvert the Brehon, or Druidical laws, and compel the Irish to relinquish their primitive customs, and assimilate to English manners. The attachment, however, of all nations to usages sanctioned by antiquity, and laws that have descended from their forefathers, is too deeply rooted to be destroyed at pleasure; and, when a stigma is thrown upon peculiarities, they are often preserved with an inflexible obstinacy, proportioned to the rigor of the measures used for their suppression. Lenient and conciliating proceedings alone are capable of overcoming national prejudices, that resist any sudden, or apparent innovation, with a proud and sullen perversity.


In 1544, Sir Anthony St. Leger raised a troop of 700 Irish, by 



---

p.106




order of Henry VIII., to assist at the siege of Boulogne; these men, we are told, mustered under the command of Lord Poer in St. James's Park, from whence they proceeded to Boulogne, where, according to **Hollinshed**, they performed good service.


A political dispute having arisen between Lord Ormond and Sir Anthony St. Leger, they, according to the practice of the times, mutually accused each other of high treason, and were consequently both summoned to England, where, on an investigation before the council, their charges proved to be of so trivial a nature, that a reconciliation followed, and Sir Anthony returned to **Dublin** as Lord Deputy. Soon after, he was again impeached by the Archbishop of **Dublin**, but being acquitted once more arrived in Ireland on the 11th November, 1553, as Lord Deputy to Queen Mary, having held that office under two preceding reigns; but, to use Campion's phraseology, ‘sundry noblemen pelted and lifted at Sir Anthony, till they shouldered him out of all credit;’ and being recalled from Ireland he closed his days in domestic retirement. His son, Sir Warham St. Leger, who served as sheriff of the county of Kent, and had been knighted for his conduct in that office, ten years after the recal of his father, received the appointment of Chief Governor of **Munster**, under the Lord Deputy Sidney, who strongly commended the zeal and watchfulness displayed by Sir Warham, in the suppression of a continental intrigue that stimulated the Irish chieftains to rebellion.


In 1580, Sir Warham was invested by commission with the power of executing martial law, which, jointly with **Sir Walter Raleigh**, he first carried into effect at **Cork**, on Sir James of Desmond, whom they condemned to be hanged and quartered as a rebel. After many services against the disaffected Irish, Sir Warham, in February, 1599, riding with a few attendants about a mile out of **Cork**, was attacked by Hugh Mac Guire, the leader of a small body of rebels, whom he shot, but Mac Guire wounded Sir Warham so severely in the head, that he died soon after; and his son, **Sir William**, as a return for the services both of his father and grandfather, was created Lord 



---

p.107




President of **Munster** by **Charles I.** in 1627, who at the same time bestowed on him considerable possessions, in addition to the six thousand acres of the Earl of Desmond's forfeited lands granted to his father.


During the contentions of 1641, Sir William sustained the double character of statesman and soldier with considerable credit to himself, and his personal actions afforded fine examples to the men under his command. One anecdote related of him deserves mention: when his little army was lying at Kildorary, in expectation of an attack from the Irish forces under Lord Montgarret, having suffered much fatigue and privation, and being without tents or shelter of any kind to protect them from the inclemency of the weather, a young officer, observing Sir William stretched on the bare ground under a heavy fall of snow, presented his cloak to him, and requested that he would use it. The Lord President thanked him, but nobly declined his offer, adding that he stood more in need of it himself, being less accustomed to the hardships of a soldier's life.


Devoted to the unfortunate Charles, in whose cause his eldest son fell at the battle of Newbury, Sir William thus expresses himself in a letter to Lord Ormond, a short time before his death. ‘It grieves me beyond any earthly sorrow for the great distance and difference betwixt his majesty and the parliament; and if all the measures of the times, joined with my long and violent sickness, were not of force to subject me to the grave, yet the sorrow for these unhappy variances would crack a much stronger heart than your servant hath now left in him.’


There is much to admire in the character of **Sir William St. Leger**: surrounded by contentions and temptations, his principles remained unshaken; and his bravery in the field was only surpassed by his pacific disposition and impartial administration of justice. Ambition by him was sacrificed to gratitude, and incapable of supporting the royal cause by his unaided efforts, he became a martyr to it.




---

p.108


**Doneraile** was the principal residence of this illustrious man, who held his presidential court here, and built the parish church, together with a mansion which was burned by the Irish in 1645. As the town possessed little to detain us, we set out from thence, immediately after breakfast, on an excursion to **Kilcolman**, the residence of the poet **Spencer**. We were told it was the first ruined castle to be seen from the mail coach road to **Charleville**, and following this direction, bent our steps towards an old tower called Carrig Phooky (or the Spirit's Rock), which appeared in view immediately after leaving **Doneraile**; but, discovering our mistake, regained the **Charleville** road, and, after about an hour's walk, arrived at the object of our search.


**Kilcolman Castle** is distant three English miles from **Doneraile**, and is seated in as unpicturesque a spot as at present could have been selected. Many of the delightful and visionary anticipations I had indulged, from the pleasure of visiting the place where the Fairy Queen had been composed, were at an end on beholding the monotonous reality of the country. Corn fields, divided from pasturage by numerous intersecting hedges, constituted almost the only variety of feature for a considerable extent around; and the mountains bounding the prospect, partook even in a greater degree of the same want of variety in their forms. The ruin itself stands on a little rocky eminence. Spreading before it lies a tract of flat and swampy ground, through which, we were informed, the ‘River Bregog hight’ had its course, and though in winter, when swoln by mountain torrents, a deep and rapid stream, its channel at present was completely dried up.


> 1. Sometimes, misguided by the tuneful throng,
>   
> I look for streams immortalized in song,
>   
> That lost in silence and oblivion lie;
>   
> Dumb are their fountains and their channels dry.
> 

*Joseph Addison, A Letter from Italy, to the Right Honourable Charles Lord Halifax, lines 31-34 (1704).*


Judging from what remains, the original form of **Kilcolman** was 



---

p.109




an oblong square, flanked by a tower at the south-east corner. The apartment in the basement story has still its stone arched roof entire, and is used as a shelter for cattle; the narrow screw-like stairs of the tower are nearly perfect, and lead to an extremely small chamber, which we found in a state of complete desolation. On ascending the highest point, I observed the word ‘MULLA’ deeply scratched over an arched recess by some sentimental visitor who has thus partially realised the concluding wish of that topographer to whom so many writers are indebted for their account of **Kilcolman**: ‘Pity it is,’ says Smith, ‘that some friendly stone, which might be placed at a small expense in the ruin of the castle, does not point out its (once)immortal inhabitant.’ The correct **Dr. Smith** seems to have been inspired with a poetic spirit, and deviated from his usual antiquarian accuracy in describing the abode of **Spencer**, so far as to tell us that **Kilcolman Castle** ‘is now almost level with the ground, and was situated on the north side of a fine lake in the midst of a large plain, commanding a view of above half the breadth of Ireland.’


Since the foregoing account was written, this ruin has braved the storm of more than seventy winters; and that its walls have still some stateliness, the annexed drawing will prove. The ‘fine lake’ mentioned, I presume must have been an inundation of the River **Bregogue**; and the ‘view of above half the breadth of Ireland,’ a prospect certainly not exceeding fifteen miles!


I consider **Dr. Smith**'s County Histories as the best authorities, and yet in this instance it is difficult to reconcile what I saw with his account of **Kilcolman**, particularly as that author writes as if he had carefully examined its lake; he tells us, that ‘the country people use the water to cure warts,’ in common with ‘another lake in the neighbourhood, called Lough Au Ulla, which, they say, has better success; but there seems to be a good deal of superstition in those sort of cures, as I could discover nothing in the water whereby they might be effected.’




---

p.110


**Kilcolman** was granted by Queen Elizabeth, on the 27th June, 1586, to **Spencer** (who went into Ireland as secretary to Lord Grey), with 3,028 acres of land, at the rent of 17l. 3s. 6d.; on the same conditions with the other undertakers (as they were termed) between whom the forfeited Desmond estate was divided. These conditions implied a residence on the ground, and their chief object seems to have been the peopling **Munster** with English families; a favourite project of Elizabeth's, for strengthening the English influence in Ireland, by creating the tie of consanguinity between the two countries.


It is supposed that this castle was the principal residence of **Spencer** for about ten years, during which time he composed the works that have chiefly contributed to his fame. But the turbulent and indignant spirit of the Irish regarded not the haunts of the muse as sacred, and wrapped the poet's dwelling in flames. An infant child of **Spencer**'s, together with his most valuable property, were consumed, and he returned into England; where, dejected and broken-hearted, he died soon after, at an inn in King Street, Westminster.


The visits of **Sir Walter Raleigh** to **Spencer** at **Kilcolman** increase the interest attached to the place, and are not in the slightest degree questionable. To the advice of **Raleigh** the publication of the first books of the Fairy Queen has been ascribed; and the existence of a poetical intercourse between such minds, and in such distracting scenes, is a delightful recollection that almost warms the heart into romance.


Amongst the literary pilgrims whose veneration for **Spencer** has prompted them to examine **Kilcolman** was the celebrated **Edmund Burke**; nor should the imprudent and enthusiastic Trotter be forgotten; the account given by him of his visits, in 1817, are very pleasing, though highly tinged with that fanaticism to which he ultimately became a victim.




---

p.111


**Dr. Smith** informs us, (1750) that there was ‘an original painting, well executed, of the poet **Spencer**’ at Castle Saffron, one mile east of **Doneraile**, where Mr. Trotter, in 1817, commenced his inquiries respecting this interesting relic, and received the same answer as was given me two years before — that it had been removed. Soon after, Mrs. Stawell of **Kilbrack** hinted to Mr. Trotter the possibility of the picture having been carried to **Limerick**; and immediately on his arrival there, he continued the search after it amongst a collection of paintings belonging to Alderman Vincent, ‘but we sought,’ says that gentleman, ‘the bard of **Kilcolman** in vain.’


In the Anthologia Hibernia, (Vol. I. for 1793,) a correspondent (whom, from the signature, I take to have been one of the Ouseley family of **Limerick**,) writes thus: ‘I have heard that, within a few years, a lineal descendant and namesake of the poet **Spencer**[10](javascript:footNote('E820000-001/note010.html')) was



---

p.112




resident at **Mallow**; that he was in possession of an original portrait of the poet, which he valued so highly as to refuse five hundred pounds which had been offered for it, with many curious papers and records concerning his venerable ancestor.’


To this account I can add, from my own recollection, that a Mrs. Sherlock lived in **Cork** not more than six or seven years since, who used frequently to boast of her descent from **Spencer**; and I have been told possessed his picture, which she had more than once refused to dispose of, though by no means in affluent circumstances.


**Buttevant** is four miles from **Doneraile**, and situated on the **Awbeg** river; its name is derived from the exclamation of David de Barry in a contest with the Mac Carthies, when he urged his men on to victory with ‘Boutez en avant,’ — Push forward; — since used as the family motto by the Lords Barrymore, who derive the title of Viscount from Buttevant.


About a mile from **Buttevant** the road to **Mallow** runs through a rocky glen called **Ballybeg**, the beauty of which would be considerably increased by some trees: at its opening are the ruins of Ballybeg Abbey, founded and endowed by the Barries; and close by this building appears the stump of an ancient round tower.


Adjoining Ballybeg Abbey is a large field, called the Pigeon Field; in digging which some years since, a vault was discovered ‘lined with images.’ The person from whom I received the information added, that these images ‘being *handy* to the road,’ were broken up and thrown thereon to repair it. In 1815, the landlady 



---

p.113




of the inn, at **Buttevant**, gave me an account of a curious discovery made at Ballybeg Abbey, about five-and-twenty years back, by a blacksmith named Supple, who was induced, from a dream, to dig amongst the ruins in search of money, a superstition so prevalent with the lower orders of Irish, as to cause them, like the Arabs, to excavate near almost every ancient building, in expectation of finding concealed treasure. Supple, after some laborious days spent in disturbing the bones of the old Fathers, came to a stone coffin, containing a skeleton adorned with a cross and chains of gold, and a thin plate of the same precious metal stamped with a representation of the crucifixion. These relics were carried by the finder to **Cork**, and disposed of to a goldsmith, by whom they were consigned to the crucible; and the stone coffin converted to a pig-trough at the cabin of a farmer near the abbey. The accuracy of this narrative has been corroborated by a son of Supple's, whom I met accidentally, and entered into conversation with on the spot.


**Buttevant**, called by **Borlase** ‘an old nest of abbots, priests, and friars,’ though formerly a town of importance and opulence, is now a poor place. It was walled, and governed by a corporation, and traces of its consequence may still be seen in the solid old walls and ruins scattered amongst the mean houses of which it is at present composed. The abbey is rapidly sinking into decay; its present exterior appearance Miss Nicholson's drawing will illustrate: but the fall, about three years since, of a high square tower that stood on a light and graceful arch in the centre of the building has lessened its dignity, and covered, with a mass of confused rubbish, great part of the interior 


> 1. Once the seat
>   
> Of monkish ease and dark religious pomp:
>   
> There many an antique monument is found
>   
> Illegible and faithless to its charge;
>   
> That, deep insculped, once held, in measured phrase,
>   
> The mighty deeds of those who sleep below:
> 
> 
> ---
> 
> p.114
> 
> 
> Of hero, sage, or saint, whose pious hands
>   
> Those ponderous masses — raised forgotten now
>   
> They and their monuments alike repose.
> 

 *Walter Thornbury, Old and New London: A Narrative of its History, its People and its Places. Illustrated with Numerous Engravings from the Most Authentic Sources. Volume 6 London, New York, Cassell, Peter & Galpin (1872-78)*


The vault of the founder, David de Barry, is mentioned as being in the middle of the chancel, and is now only marked by some dissevered pieces of hewn stone that indicate a square enclosure. — Being recently opened to inter a descendant, a man who went down with the coffin described the interior to me as lined with the figures of different saints, the name engraven under each, and having at the upper end a tablet, on which was a long inscription. On the south side of the nave is a chapel dedicated to the Virgin Mary, of beautiful proportions, containing many tombs and inscriptions to the memory of the Barries, O'Dulins, Fitzgeralds, and Butlers. Attached to the stone cornice, a lion or wolf courant, sculptured on an armorial shield, is pointed out to visitors, with a traditional story too long and too absurd for relation. — In the nave, choir, and chancel, there are also tombs to those families, and to the Lombards and Mahers. Smith mentions the tombs of several other distinguished names, since destroyed or concealed by the ruins of the fallen tower. A fragment of closed tracery which I observed in the choir is here copied.




---

p.115


Some traces of fresco painting are yet to be seen on the wall of one or two recesses in the nave: — a patchwork halo of red and yellow, confined by a strongly marked black outline, and part of an orange-coloured ladder with a bit of green drapery, however the antiquary may regard them, did not give my companions very high ideas of the state of excellence attained by the monastic professors of this art in Ireland.


**Sir Richard Cox** states, that Buttevant Abbey was repaired by the Roman Catholics, as a place of worship, in 1604, between which date and the year 1625 the greater number of tombs and inscriptions now existing in the interior were put up. In more than one legend, about this period, the soft sounding name of Kathelina is used for Catherine; and Redmond, Garet, Eugene, Philip, and Maurice, appear to have been the favourite names amongst the families interred here.


The naked walls of this abbey are looked upon by the peasantry with the highest reverence, and thither many still resort to perform rites of solitary devotion. A small grave-stone, marked with the cross, is placed on the shattered altar; and at the time of our entrance, an old man was kneeling before it, counting his rosary with an intense piety; having repeated there a certain number of prayers, he went from grave to grave, and from one recess to another, observing the same ceremony, and during the time of our stay, two or three devotees performed similar pious rounds.


It is a common practice for the peasant, as an atonement for his sins, to impose on himself the saying, at particular places of reputed sanctity, a given number of rosaries, according to the supposed heinousness of the offence, and this is executed with the most scrupulous nicety; every other business is neglected for the purpose, and long and difficult journeys are often solely made on that account.


The chancel of Buttevant Abbey, being built on a steep bank of 



---

p.116




the **Awbeg**, is raised to the level of the nave by three crypts or vaults, the middle of which is supported by a single pillar, so constructed as to resemble four, with fanciful and well-wrought capitals. — Close to the entrance of the abbey is a large square pile of skulls and bones, the relics of those who perished at the battle of Knockninoss, five miles distant from hence. It was fought on the 13th of November, 1647, between the English or parliamentary forces under the command of Lord Inchiquin, who was complimented by a pecuniary vote for his conduct on that occasion, and the Irish under Lord Taaffe; the latter were completely routed, and four thousand (half their number) left dead on the field.


A party of Scotch highlanders, in the Irish army, headed by Sir Alexander Mac Donnell or Mac Allisdrum, contested their ground in the most determined and gallant manner, and were inhumanly butchered by the victors. The spot of Mac Allisdrum's assassination is pointed out by the country people to this day, who pretend to show the stains of his blood.


That wild and monstrous piece of music known by the name of Ollistrum's March, so popular in the south of Ireland, and said to have been played at Knockninoss, should not, it appears to me, be considered as an Irish air. **Mr. Walker**, in his History of the Irish Bards, justly remarks its similarity to the pibroch or war tune of the Scotch; and had he more carefully perused the passage in Smith, alluded to by him, he would have had no hesitation in assigning to this singular strain its northern origin. The estimation in which it is held in Ireland is wonderful. I have heard this march, as it is called, sung by hundreds of die Irish peasantry, who imitate the drone of the bagpipe in their manner of singing it. On that instrument I have also frequently heard it played, and occasionally with much pleasure, from the peculiar and powerful expression given by the performer. ‘It was not without much difficulty,’ said the lady who gave me the annexed copy, ‘that I took down Ollistrum's 



---

p.117




March, from the manner in which it is played. Not one of our native musicians understand a note of music, as the pipers in general are blind, and yet the air has been handed, or rather (if I may use the expression) *eared* down, I imagine, with very little alteration, having heard numbers perform it in the same irregular way. I should find it much easier to write a piece of music in score, than to set down the notes used by these blind minstrels, though they vary but little in all the movements and manner of playing; however, I have done my best to retain the character. In Walker's Irish Bards, provincial cries, strongly resembling the lamentations of the **Munster** and **Leinster** women, are well given.’


A little to the north-west of **Buttevant Abbey**, within its burial ground, and close to the road, there is a high square tower named Cullin. Its construction has been ascribed to an Earl of Desmond, but tradition is silent as to its use.


The Castle of Buttevant is boldly seated on a rock above the **Awbeg**, and has been so modernized as to lose much of the contour of antiquity. A legend relates, that this castle was the chief residence of the Clan of Donegan, who rejected every offer of the English to surrender it, and repulsed every attempt made to take it; but it was ultimately surprized and captured by David de Barry, who gained it through the treachery of a soldier of the garrison. De Barry, having made himself master of the place, put its sleeping inmates to the sword, and rewarded the perfidy of the betrayer by striking off his head also. There was a small addition to this story related to me as possessing equal claims to belief; — the dissevered and ghastly head of the betrayer, as it went bounding down the stairs of one of the towers, yelled forth, in a sepulchral and terrible tone, the word — treachery! — treachery! — treachery!


About the year 1812, in planting part of the castle grounds the labourers discovered, a little way below the surface, a human skeleton, with the appearance of a wig on the skull, which mouldered 



---

p.118




when exposed to the air; and apparently concealed in the caul were several shillings and sixpences of Elizabeth's: three or four of these coins are now in the possession of my friend, Mr. Samuel Richardson of **Cork**, and I recollect as many more being offered to me to purchase. There was no case or coffin round the body, nor was it buried in what is considered consecrated ground.


Nearly a mile to the north-east of Buttevant is a considerable mound or tumulus, probably about twenty feet in height, called Knockaneabouhilla (or the Boy Hills); and about the breadth of a field from it is a smaller one, called Knockanea Collihine (or the Girls' Hill), nearly half of which has been cut down to make way for a new road.




---

p.119


The river **Blackwater**
------------------------




> 1. The grassy court — the mossy wall
>   
> Vault — barbacan — and turret tall
>   
> With weeds that have o'ergrown them;
>   
> Though silent as the desert air,
>   
> Yet have their eloquence, and bear
>   
> Mortality upon them.
> 2. Yes! these are talismans that break
>   
> The sleep of visions, and awake
>   
> Long silent recollections;
>   
> That kindle in the mental eye
>   
> Romantic feelings long gone by,
>   
> And glowing retrospections.
> 

 
Anonymous.


The scenery of the **Blackwater**, where it falls into the sea at **Youghall**, is bold and rocky; but the character gradually changes to one of richness and fertility.


In the progress up this river, at every bend made by the course of the boat, attractive objects are continually presented to the eye, or renewed and improved by a change of position. Several ruins, to each of which historical or traditionary recollections are attached, 



---

p.120




overhang its banks; some clothed in ivy rising out of wood, whilst others appear sternly elevated on a naked point of rock: these are agreeably relieved by many seats and hamlets scattered on the shore, and the distant Galtee Mountains form a noble termination.


Rincrew is the first ruin approached from **Youghall**; it stands on an eminence immediately over the river, and may be distinctly seen from thence. It is reputed to have belonged to the Military and Religious Association of Knight Templars, and being forfeited to the crown, was granted, in 1586, with Strancally, Ballynatra, and other lands, to **Sir Walter Raleigh**, who afterwards disposed of his Irish estates to the first Earl of **Cork**. I have been told that the river here is fished and navigated by means of small square boats called corracles, similar to those used in Wales, composed of basket work and covered with skin or oil cloth; of these we saw none, but passed more than one bark of fragile texture and pigmy dimensions, in which a rosy-cheeked lass tugged stoutly at the oar. — A boat, sharp pointed both at bow and stern, and somewhat resembling a canoe, attracted our particular notice; it was guided by two young countrymen with paddles, and kept alongside our barge for about three miles, though the movement of the paddlers, when compared with that of our boatmen, appeared playful and insignificant.


The castle of Temple Michael, at present a complete section of a heavy square tower, is about a mile from Rincrew, and adjoins the house of Mr. Smith, situated close to the river, which here spreads into an extensive sheet of water, and formerly encompassed an island, called Dar Inis or Molana.


On this island, recently united to the main land, some ivied walls induced us to leave our boat, but they did not present a subject worth sketching; as some hand, certainly not that of an artist, has been busy here clearing away congenial weeds and brambles, and 



---

p.121




the fragments of ancient tombs have given place to a grassy neatness. This destruction of monuments is the more to be regretted, from popular tradition naming Molana as the burial place of Raymond le Gross,[11](javascript:footNote('E820000-001/note011.html')) to whose personal skill and bravery the conquest of Ireland is mainly owing, and of whom **Giraldus Cambrensis** has left us so noble a character. A modern tablet has been put up in the interior, with an inscription recording the circumstance. In **Archdale**'s Monasticon may be found the names of many abbots, with some particulars relating to the monastery of the little island of Molana. — According to **Smith**, it was founded by St. Molanfide, for regular 



---

p.122




canons, in the sixth century, and, being forfeited, was amongst the lands granted to **Sir Walter Raleigh**.


Ballinatry, the seat of another Mr. Smith, is close to Molana; — from the water the gardens appear conspicuous, and seem laid out in the taste of the last century. In the next reach of the river, the remains of Strancally Castle break boldly on the view: Strancally was one of the strong holds of the Desmond family, and the atrocious cruelties committed in this castle called down the particular vengeance of Elizabeth's government, by whose orders it was blown up; the forcible effects of the explosion may still be easily discerned in its shattered fragments; and it is probable, the semi-destruction of Temple Michael was effected by the same means and at the same period. Our boatman pointed out the mouth of a passage excavated in the rock, which is reported to have communicated with a dungeon, stained by 

*Many a foul and midnight murder’’*

Thomas Gray, The Bard II. 3, Line 11.

 

and from whence the bodies of slaughtered victims were precipitated into the tide. Numerous arbitrary and despotic acts of the Earls of Desmond are minutely related to the present day by the peasantry; and if an impartial history of their times could now be drawn up, it would present a catalogue of tyrannical and savage deeds, at the mention of which humanity must shudder.
Drumana, recently the seat of the Earl of Grandison, is placed on a precipitous rock above the water, some distance, and at the opposite side from Strancally. The present house was built on the site of a castle that belonged, with those already described, to the Fitzgeralds, and is the reputed birth place of the long lived Countess of Desmond, the number of whose years approached so near those of old Thomas Parr. This wonderful lady, being deprived of her jointure by the attainder of the Earl of Desmond, at the advanced age of one hundred and forty, crossed the Channel to Bristol, and, travelling 



---

p.123




to London, solicited, and obtained relief from James the First. In this part of the country her death is attributed to a fall whilst in the act of picking an apple from a tree in an orchard at Drumana.


Drumana, richly surrounded with wood, is decidedly the most beautiful picture on the passage to **Lismore**. Strancally is more striking, as part of the ruin still retains nearly its original height, and the dark stateliness of its ‘time tinted’ walls bestows an air of desolation and solemnity which the adjacent scenery is calculated to increase, the appearance of the ground being barren and neglected.



> 1. Brown in the rust of time it stands sublime,
>   
> With over hanging battlements and towers,
>   
> And works of old defence — a massy pile!
>   
> And the broad river winds around its base
>   
> In bright unruffled course.
> 




The views of **Drumana**, on the contrary, exhibit the strongest marks of industry and improvement. Extensive plantations meet the eye in every direction, and the distance is closed by a range of mountains with a particularly well-shaped outline. The loftiest of these is Knockmeledown; its height is reckoned at two thousand seven hundred English feet above the level of the sea, and, on the top, Major Eeles,[12](javascript:footNote('E820000-001/note012.html')) of eccentric memory, lies buried, with his horse and gun beside him. About Drumana, for some space, rocks and trees hang beautifully over the water, and form a variety of delightful combinations.


Proceeding forward, the village of Affane appears on the right, remarkable in Irish history from having been the scene of a severe conflict, about the middle of the sixteenth century, between the clans of Butler and Fitzgerald, in which three hundred of the latter were 



---

p.124




killed, and their leader (Gerald, Earl of Desmond) wounded. An anecdote of this fight is related by many writers, remarkable for the dignified and spirited retort of the wounded Desmond, who was made prisoner, and as his antagonists were bearing him on their shoulders from the field, a leader of the Ormond party rode up, and exultingly exclaimed, ‘Where is now the great Earl of Desmond?’ when raising himself, indignantly he replied, ‘Where, but in his proper place, on the necks of the Butlers!’ The lands of Affane are said to have been given by Garret Fitzgerald, for a breakfast to **Sir Walter Raleigh**, who introduced cherries into Ireland, and, according to **Smith**, first planted them here, having brought them from the Canary Islands.


Two miles farther is Cappoquin, a neat village, with a pretty church spire, rising above a cluster of cabins, and wearing altogether a more inviting aspect than most Irish villages can boast: here is the first bridge across the **Blackwater**, and although wooden, of some antiquity, as an act was passed to repair it in the reign of **Charles the Second**.


At Cappoquin, the course of the river changes from due east to due south, which direction it follows between eleven and twelve English miles, when it falls into the sea at **Youghall**, about sixty miles from its source; **Ptolemy** calls this river the Daurona, and the Irish name of Awin-dubh or the Black River, used by **Spencer**, probably originated in the peculiar strength and gloominess of its reflections, an effect we observed more than once during our excursion. The depth of the **Blackwater** is unequal, and the navigation impeded by beds of gravel. Lord Orrery in his Letters speaks of a communication by water to **Mallow**, a distance of forty miles, for boats of tolerable burthen; but this at present is impossible beyond **Lismore**, even for the smallest craft. Some years since, a canal was commenced above **Mallow**, and extensive remains of the undertaking are to be seen in that neighbourhood; to pecuniary causes the failure of this plan is 



---

p.125




attributed, and no effort has since been made to obtain the important advantage of inland water carriage.


From Cappoquin to **Lismore** the banks of the river become still richer and more close; magnificent ash trees dip their waving branches in the stream, and have attained a surprising growth and beauty. Within about two miles of **Lismore**, the frequent stoppages occasioned by locks induced us to land, and pursue the remainder of the way on foot; a walk of increasing beauty brought us within view of its fine castle, rising out of trees, above an extensive bridge with numerous arches, and one of striking dimensions. Of this approach the annexed drawing by Miss Nicholson will convey a correct idea.


**Lismore** is recorded to have been one of the most distinguished seats of learning in Ireland, and the existence of numerous monasteries and colleges here is boasted by modern authors on the faith of early annalists. The traveller, however, who expects to find remains of ancient building at **Lismore**, will feel disappointed, as few if any vestiges of its former greatness are now to be discerned.


From the earliest period its history presents a catalogue of destructive conflagrations, and these, in some measure, account for its being almost totally destitute of ancient edifices. In the seventh century, **Lismore** is described as a famous and holy city, full of monasteries and cells, the resort of pious men from Britain, and half of it an asylum into which no woman was permitted to enter. It is, however, chiefly memorable from the council held by Henry II. in 1172. Take the words of old Matthew Paris, which have occasioned so much discussion: ‘Rex, antequam ab Hibernia redibat, concilium congregavit apud **Lismore**, ubi leges Angliæ ab omnibus gratenter sunt acceptæ et juratoria cautione præstita confirmatæ.’


At present, **Lismore** is a small and inconsiderable town, though a bishop's see, united to that of **Waterford** in 1363. The cathedral has nothing attractive in exterior appearance; about a third part has recently been fitted up for service, in the florid Gothic style, and the 



---

p.126




carving of the oaken throne, pulpit, desks, and stalls, together with the entire effect, superior to any thing similar that I remember having seen in Ireland.


The entrance to the castle is under an old gateway, with towers, from whence a level walled avenue, shaded on one side by a row of aged and stately pine trees, leads to a second gateway, over which are sculptured the arms of the Earl of **Cork**, with the often quoted motto, ‘God's providence is my inheritance.’ This is the entrance into an extensive court yard, the north and east sides of which, if not recently erected, are so disguised as to have a modern appearance.


A tame eagle was pluming his feathers in the sun beside the door of the castle, and the sight of that monarch bird in its present situation, chained to a slight wooden perch, seemed a fine emblem of the wild and lawless spirit of feudal days, controlled if not subdued by the power of civilization, beyond the reach of which it had long soared in proud and fancied security. There was no difficulty in obtaining permission to see the interior. A book lay on the hall table where strangers write their names, and a servant is in attendance to conduct them from room to room. The guide, though particularly civil, was totally ignorant of any anecdotes connected with the place; in vain I inquired for the apartment consecrated by the memory of the philosophic Robert Boyle, who was born here; for that, where the feeble monarch James II. is said to have started back from the window, appalled at beholding its height above the river; or for any of those places identified with **Raleigh** or Broghill. Had I not been previously aware of the association of these names with Lismore Castle, I should have gone through its chambers with as little interest as through those of any other well furnished house; in fact, it is no more, and the local association of such sacred titles as soldier and statesman, philosopher and poet, is never once recalled to the memory, a visionary charm that should be religiously preserved. Little will therefore be found attractive in Lismore Castle, beside the 



---

p.127




natural beauty of its situation. It was built by King John when he visited Ireland in 1185, and four years after destroyed by the Irish, who regarded, both with fear and jealousy, the construction of every English fortification. On being rebuilt, Lismore Castle became an episcopal residence, until granted with the manor and other lands, at the yearly rent of 13£. 6s. 8d., to **Sir Walter Raleigh**, to whom **Lismore** is indebted for the foundation of a free school. From Sir Walter, this estate past into the possession of the first Earl of **Cork**, and in the rebellion of 1641, the castle was bravely defended by his third son, **Lord Broghill**, against the Irish. The conclusion of a letter from that young nobleman to his father on this occasion has been much eulogized: ‘My Lord,’ says the gallant writer, ‘fear nothing for **Lismore**, for if it be lost, it shall be with the life of him that begs your lordship's blessing, and styles himself, your lordship's most humble, most obliged, and most dutiful son and servant,’ **Broghill.**


The manuscripts in **Lismore Castle** are frequently referred to by **Smith**, but I could learn nothing respecting them; my inquiries were answered by a positive assurance that no such collection ever existed; but from **Dr. Smith**'s character for correctness, as well as from the internal evidence of such parts as have been printed in his works, there can be no doubt of their authenticity. These manuscripts appear to have been title-deeds and letters of the Boyle family, the latter replete with extensive historical and biographical materials relative to the intrigues and troubles of 1641, and it is to be hoped were removed and are preserved by order of the Duke of Devonshire, the present possessor of the castle.[13](javascript:footNote('E820000-001/note013.html'))


The visitor of **Lismore** should make a point of seeing Balleen, the 



---

p.128




seat of the Rev. Dean Scott, about a mile distant from thence. By the kindness of Lady Listowel, Miss Nicholson was furnished with a letter of introduction to Mrs. Scott, and an evening ramble in these charming grounds was one of much enjoyment.


The **Blackwater** is here deep, and though rapid, pursues its course quietly, gliding amidst knotted stumps and twisted roots that skirt the banks, and which with the trees appear to have resolved as with one consent to grow in the most romantic forms imaginable. Every group might become a study for the pencil, and the river, like a black mirror, is of that dark, transparent quality, which I have frequently observed to reflect forms even more distinctly than they appear. The opposite woods and ‘castled eminence’ of **Lismore** give additional beauty to the scene, and its magic is completed by the lulling sound of the river murmuring amongst distant weirs.



> 1. the fretful melody
>   
> Of water, gurgling through the rugged weir,
>   
> Brought on the breeze.
> 




Between **Lismore** and **Fermoy** the carriage road is indifferent, and the character of the **Blackwater** less worthy the notice of the pictorial tourist.


We explored one wild glen called Ballydouve, three miles from **Lismore**, where a few miserable cabins (if I may speak paradoxically) stood in lonely association; an adequate idea of the wretchedness of these habitations can scarcely be formed from description. From these hovels the smoke of the turf fire has seldom the option of escape by a chimney, in default of which it issues from the door; sometimes they possess a window, but this is a luxury not general. The floor is bare earth, so uneven that the four legs of a chair are seldom of use at one time, and baskets and utensils lie around in an indiscriminate litter; a pig, the wealth of an Irish peasant, roams about with conscious importance, and chickens hop over every part like tame 



---

p.129




canaries. Such is a picture of dwellings within twenty miles of the principal trading city in Ireland. Few of the smoke dried inmates understood English, and I was not only surprized, but shocked, at finding the deplorable want of comfort exhibited in the condition of these poor people. A wooden bridge was constructing across the river at the time of our visit, and it is to be hoped that the increase of communication may be conducive to improvement.


The dilapidated towers, or, as they are called, castles of Liclash and Carrickabrick, are at opposite sides of the **Blackwater**, within a short distance of **Fermoy**, a town indebted for its importance to the extensive barrack and mail coach contracts of the late Mr. Anderson. At the last peace, the government works were discontinued, and the military withdrawn; since when, its rapid prosperity has as rapidly declined. A spirit of industry and enterprize no longer animates the place; the once busy inhabitants have comparatively relapsed into indolent habits; and with the speculations of Mr. Anderson, the vital strength of **Fermoy** seems to have departed.


About a mile and half distant is Castle Hyde, the seat of Mr. Hyde, to whose ancestor, a grant of six thousand acres of the Earl of Desmond's forfeited ground was made by Elizabeth, as a reward for his military services in England, during the commotion caused by the ‘invincible Armada.’ The lyric production of a drunken cobler, descriptive of Castle Hyde, is so popular as to require notice, which its originality perhaps merits, and also from the well known song of the Groves of Blarney being an acknowledged imitation of this composition, of which the following quotation may serve as a specimen.



> 1. The bees perfuming — the fields with music,
>   
> As you rove down by th' **Blackwater**'s side.
>   
> The trout and salmon, play at back gammon,
>   
> All to adorn sweet Castle Hyde.
> 





Rising behind **Fermoy** is seen the mountain of Cairn na Thierna, in 



---

p.130




English the Lord's heap, a name expressive of the Cairn or heap of rude stones on its summit, a monument of remote ages, and generally believed to mark the burial-place of some primitive chief.


To enjoy, indeed to see the scenery of the **Blackwater** between **Mallow** and **Fermoy**, a tract dignified by the name of the garden of Ireland, frequent detours must be made from the carriage road, as it is otherwise impossible to form an adequate idea of the adjacent country. Sir Richard Hoare complains feelingly of this circumstance.


The grounds of Castle Hyde join those of Creg, the residence of Colonel Stewart, which are laid out in good taste, with steep and shadowy walks beside the river, and contain an old castle that formerly belonged to the family of Roche, feudal lords of the district of **Fermoy**.


Two miles beyond Creg is Ballyhooley, an inconsiderable village, dignified by the ruins of another and more extensive castle of the Roches, standing on a rock with the present parish church, and the remains of the ancient one — a combination seen to great advantage from Convamore, the domain of Lord Ennismore, whence it affords an excellent subject for the pencil; as these structures give a poetic relief to the massive richness of the surrounding wood which overhangs the winding course of the river.


About a mile above Convamore, the **Awbeg**, named by **Spencer** the Mulla, meets the **Blackwater**, and their mingled currents glide onward beneath the rocky cliffs of Renny, part of the estate granted to that poet. On the low ground between the conflux of these rivers are the venerable remains of Bridgetown Abbey, dedicated to the Virgin Mary, and founded by the Roche family, who at various periods added considerably to its endowments. In 1375, Thomas, the Prior of Bridgetown, was selected to proceed to England, in compliance with a writ of Edward III., directing that chosen persons should be sent from Ireland to advise on the government of that 



---

p.131




kingdom, and other important matters. This circumstance and the demolition of a bridge by **Cromwell**, from whence its name was derived, are the only historical facts recorded of Bridgetown Abbey. It contains few monuments of importance, except one on the south side of a large chapel near the site of the altar. It is a Gothic arch, of light and elegant proportions, within a considerable and heavy projection. The extreme wildness of construction in this arch is remarkable, the termination of one side being square and massive, the other slight and sharp. Irregularity seems to have been the designer's chief object, and yet an uniformity of effect is preserved. About the middle of the corner moulding, on the altar side, a head in high relief is most unaccountably placed, without any thing similar to correspond as a balance, and an inverted armorial shield, charged with one fish (the present Roche arms are three) is deeply marked in outline on the front of this monument, supposed to be that of the founder, Alexander Fitz Hugh Roche, but no vestige of an inscription can be discovered.


In a small chapel parallel to and adjoining the greater one, there is another tomb belonging to the same family, simply inscribed
  

‘A. D. 1634
  

THEOBALD. ROCH.’


And in both chapels numerous architectural fragments and gravestones lie scattered on the ground. Amongst these fragments, some grotesque corbels and pieces of highly wrought tracery were to be seen. On many of the old grave-stones was sculptured a cross, enriched in various ways by means of intersecting circles and fleurs de lis; several were without lettering, but on such as had a legend, it generally ran along the border; I observed one in the great chapel covered with a Latin inscription, in the Roman character, but so oddly confused that I was totally unable to decipher it, although every letter and many words could be distinctly made out, some of 



---

p.132




the words mingled with the ornamented cross, attached to which were two busts in bas-relief of the rudest workmanship. Of these uncouth works I have copied the most striking, together with a few architectural remains which I observed lying on the ground.




---

p.133



> 1. Thus in a corner of some ruin'd pile
>   
> Lie name and titles — fragile to the touch
>   
> Of curious finger, that perhaps may try,
>   
> Once in an age, those antique characters
>   
> And rudely chissel'd chyphers to explore,
>   
> Perhaps in vain! — Yes, poor Ephemera,
>   
> This is the end of all your hoped renown,
>   
> To be forgotten, and unknown!
> 




The cloisters and refectory may be traced without difficulty; the former is now a naked square court used as a ball alley by the neighbouring peasantry.


Leaving the **Blackwater**, and following the course of the **Awbeg** through a wild and rocky glen, for about a mile and a half, we reached the village of **Castle Town Roche**. Its appearance was romantic, and, comparatively speaking, cleanly; the greater part is built upon the side of a thickly wooded eminence, crowned 



---

p.134




by an ancient embattled tower, that rises with an air of command. Through the valley, or rather glen, beneath, ripples the **Awbeg**, whose natural beauty is enhanced from the endearing appellation applied to it by **Spencer** in his Fairy Queen, 

**And Mulla mine*, whose waves I whilom taught to weep.’’*

**Spenser**, Fairy Queen. Book 4 Canto XI.


The village church is modern, and without pretensions; from a stone imbedded in the outside wall, I copied this inscription: 

Orate 
  

Pro Bono Statu 
  

Domini Maurici 
  

Roche viceco 
  

mes de **Fermoy** et 
  

Domine Elinorie 
  

Maurici et 
  

Pro Anima ejus 
  

Anno Domini 1585.


The castle is conspicuous at a considerable distance; the present owner is Mr. Widenham, who recently resided in an adjoining house. It was formerly the chief seat of the Roches, whose loyalty having fallen under suspicion in Elizabeth's reign, **Sir Walter Raleigh** was instructed to secure the head of the family, an enterprize of considerable difficulty and danger, which he executed with extraordinary calmness and resolution. The policy of this act has been stigmatized 
as treacherous and disgraceful; but in whatever light it may be viewed, the personal courage and self-possession of **Raleigh** appear still the same.


Being aware that Fitzgerald, the Seneschal of Imokilly, at the head of seven or eight hundred men, intended to intercept his march, **Raleigh** left **Cork**, with a small troop of only ninety, so unexpectedly, between ten and eleven o'clock at night, that he escaped any engagement, and arrived at Castle Town Roche the next morning. 



---

p.135




Alarmed at the approach of English soldiers, a show of defence was immediately made by the inhabitants, that subsided when **Raleigh**, attended only by six men, confidently advanced to the castle gates, and requested permission to speak with Lord Roche, who, though surprized at the visit, received him with apparent cordiality; and while Sir Walter detained that nobleman in conversation on indifferent matters, the men admitted with him contrived to give the entire of **Raleigh**'s party entrance, each of whose muskets, we are told, was loaden with two balls. Lord Roche, perceiving his castle occupied by an overpowering force and resistance impossible, addressed Sir Walter with increased kindness, ordered refreshments for his men, and invited him to dinner. After the banquet, **Raleigh** informed his entertainer of the cause of his coming, and exhibited a commission for his apprehension. Lord Roche made some slight remonstrances, but ultimately surrendered; and Sir Walter, with the same promptness of manner that had already proved so eminently successful, carried his noble prisoner, together with his lady, across the mountains to **Cork** the same night, which proved dark and stormy in the extreme, and thus again escaped encountering the Seneschal of Imokilly. But the charge of disloyalty against Lord Roche proved unfounded, and he afterwards became distinguished for his support of the English cause in Ireland, three of his sons and many of his followers having lost their lives in the service of Elizabeth.


During the rebellion of 1641, the greater part of the estates of this family were forfeited, and Maurice Lord Roche was attainted and outlawed, having refused a composition offered by **Cromwell**. His lady, in 1649, defied the parliamentary forces, and heroically defended Castle Town Roche for some days, until compelled to surrender by a heavy fire from a battery raised in a field on the opposite side of the river, still called the Camp Field, and from whence Mr. Nicholson's drawing was made.


Lord Roche's attachment to **Charles II.**, with whom he is said to 



---

p.136




have shared his pay derived from a military command in Flanders under a foreign government, was only rewarded on the restoration of that monarch, after considerable delay, by a trifling pension, notwithstanding the impressive memorial of Lord Orrery[14](javascript:footNote('E820000-001/note014.html'))My Lord,The lady that waits upon your Grace with these is relict of Lord Roche, as he was commonly called, whose ancestor was attainted and lost his title and a large estate about the rebellion of 1641. His late Majesty was pleased to give him a pension here during his life — I think it was £200 per annum, which I believe was the only support of him and his family. Since his death, his widow, being destitute of support, made application to his present Majesty for a pension, for the maintenance of herself; and, as I understood by her, my Lord Carteret gave her hopes, that his Majesty would grant her request; but, as nothing is yet done in it, she thought proper to go over to England to solicit in person. I believe she has some friends there who will assist her with their interest, but as your Grace's good will must be of the greatest service to her, I humbly recommend her to your Grace to help her to somewhat that may be a subsistence for her, since I am fully persuaded she is at present without one. As for the particulars of her case, I refer your Grace to her own relation. in his behalf to the Duke of Ormond, and the exertions of the latter nobleman and Lord Clanrickard to obtain an adequate remuneration for conduct so loyal and so generous.


It is a melancholy fact, that after the Restoration, Lord Roche, with a wife and six children, were reduced to such abject poverty that it is stated they would have starved had it not been for the private charity of individuals.


Necessity, therefore, and the loss of ancient wealth and honours, seem to have compelled this family, like many others, to enter into the service of continental powers, in which they distinguished themselves on various occasions. About the middle of the last century, a lineal descendant, employed by the King of Sardinia, became 



---

p.137




particularly conspicuous for his bravery, in sustaining at Casal, with only six hundred men, a siege of thirty-two days, against a body of twenty-five thousand; and on his capitulation, as a tribute to such gallant conduct, the French and Spanish generals received him in the most complimentary manner.


The eccentric Sir Boyle Roche was a scion of the Fermoy family; he was, for several years, a member of the Irish parliament, and so renowned for his propensity to blunder, that as many bulls are attributed to him as witticisms to Curran, or puns to Lord Norbury; Sir Boyle however possessed, in addition, a large share of shrewdness, and his absurdities have often quelled the storm of political debate, when the eloquence of the most highly gifted orator would have but augmented the tempest.


From Castle Town Roche we returned to the **Blackwater**, and visited Clifford, the seat of Mr. Martin, about a mile beyond Bridgetown, and midway between **Fermoy** and **Mallow**. The **Blackwater**, if not flooded, may be forded with safety beneath the house, from which circumstance, and a large limestone rock that overhangs the river, it has received the appropriate and descriptive name of *Cliff-ford*.


Highly cultivated and improved, planted with peculiar taste and care, and surrounded by picturesque objects, it is difficult to conceive a more fascinating spot. The house is small, and completely concealed by trees; from a tablet in the hall, I transcribed these beautiful lines: 


> 1. Parva domus! nemerosa quies
>   
> Sis tu quoque nostris hospitium laribus
>   
> Subsidium diu: postes tuas Flora ornet
>   
> Pomonaque mensas.
> 




Rambling through the domain, we came to a retired rocky hollow, containing an urn of considerable size, upon a proportionate pedestal, and shaded by trees so closely planted as to cast, even at noon-day, 



---

p.138




a congenial monumental gloom. I have heard that the hospitable owner of Clifford erected this urn, intending his heart to be deposited in it after his death, which the inscriptions on the pedestal seem to confirm.[15](javascript:footNote('E820000-001/note015.html'))


In the path along the river side, from **Clifford** to Killavullan Bridge, pasturage, wood and water are finely arranged in the landscape, and form a luxuriant contrast to a heathy, barren-looking mountain that ascends behind the ruined castle of **Carrignaconny** (the Rabbit's Rock) and its surrounding plantation. Carrignaconny was the estate of Sir Richard Nagle, attorney general to James II., and speaker of the House of Commons, whose bigotry has been condemned by all parties, and even reproached by James himself.


The pass of **Killavullan** is singular and romantic; on the descent to it are some ruins, called Monanimy, reputed to have belonged to the Knights of St. John of Jerusalem. After crossing the bridge, the road winds round a mass of steep limestone rock, in which are 



---

p.139




natural caverns, used as habitations by the peasantry. One of these was the dwelling of the village smith, the light from whose forge threw a broad and vivid reflection across the road, that lay in the solemnity of deep shadow. The evening closed in so fast as to urge our rapid advance towards **Mallow**, and the remark before made on the difficulty of obtaining correct information respecting distance, may be illustrated by giving a dialogue verbatim, which occurred on our walk:


How far is it to **Mallow**?


Och! I don't know.


Do you live there?


Is it at **Mallow**? I do.


Do you think it two miles from hence?


Indeed, and two miles would not take you to **Mallow**.


Is it ten miles?


It is not; it may be four and a bit when you get over the 
mountain you will be there in less than no time.


Rockforest, Sir James Cotter's seat, and Carrig, that of the Franks family, on opposite sides of the **Blackwater**, were passed in twilight; but our ‘weary way’ was cheered by a magnificent sun-set.


**Mallow** has been called the Bath of Ireland, not from any striking resemblance between the buildings of these towns, but from a similarity in the society — invalid water drinkers, and those who, with moderate incomes and easy dispositions, prefer passing through life in the gaiety of a genteel circle, to exertion or study.


Pleasure is therefore the object pursued by the inhabitants of **Mallow**, and the morning visit and nightly assembly, to those who are of listless habits and fond of amusement, would doubtless make the place very agreeable. Strangers of respectability require but a slight introduction to receive attention; and the genuine kindness and hospitality shown by the residents to such, must long be remembered with gratitude. The appearance of the town is ancient and 



---

p.140




and irregular; there are some good modern houses in the upper part, but the lower principally consists of mean looking shops, with old fashioned projecting windows over them; the first floor is let as lodgings, which enables the shopkeepers to pay heavier rents than I apprehend the sale of their goods would justify, as the trade of **Mallow** is necessarily very limited. It has a well built, though a narrow bridge, mentioned as the only one across the **Blackwater**, in 1666, by Lord Orrery, who recommended the repairs of the castle that commanded it. Under some of its arches are several most unaccountable inscriptions which I can make nothing out of. The walls of a castle still remain in the grounds, and close to the dwelling house of Mr. Jephson, to whom the proprietorship of **Mallow** has descended from Sir John Jephson.


The district of **Mallow** was part of the forfeited Desmond property, and bestowed by Elizabeth on Sir John Norris, Lord President of **Munster**, whose memory has been embalmed by **Spencer**, in a sonnet addressed to him with a copy of the Fairy Queen.



> 1. Whose warlike prowess, and manly true courage,
>   
> Temper'd with reason, and advisement sage,
>   
> Hath fill'd sad Belgia with victorious spoil,
>   
> In France and Ireland left a famous gage,
>   
> And lately shak'd the Lusitanian soil.
> 

 *Spenser, To the right noble Lord and most valiaunt Captaine, Sir John Norris knight, Lord president of Mounster.*


Sir John Jephson having married the daughter of the lord president, the estate was granted to her heirs by letters patent, in the reign of James I.


Lord Strangford has inscribed his translation of Camoens to the late possessor (his kinsman), for many years the representative of **Mallow** in parliament; the present member is Mr. Wrixon Beecher, whose recent marriage with Miss O'Neill has deprived the stage of that accomplished and amiable actress.


**Mallow** was the scene of a smart conflict, in the commotions of 



---

p.141




1641, and also of 1690.[16](javascript:footNote('E820000-001/note016.html')) Lord Montgarret marched into it with the Irish forces in February, 1642, when the town ‘consisted of two hundred English houses, thirty of which were strongly built and slated,’ beside its two castles.


In the census taken this year (1821,) the number of the houses is stated to be 607, and the inhabitants 4,146.


A walk with stately trees beside a canal leads to a tepid spa. It has a neglected appearance, from which may be inferred, that the salubrious effects of this fountain are not now held in so much estimation as some years back, when I recollect the Spa Walk mentioned as the favourite promenade, and much praised for its neatness.


The spring is estimated to discharge twenty gallons per minute, and the temperature of water at about sixty-eight degrees of Farenheit. The taste I found soft and rather agreeable.


Miss Nicholson's drawing of **Mallow** was made from the suburbs on the south side, whence the castle appears, backed by trees of well varied forms; but the chief entrance to the town is through rows of wretched cabins, every way calculated to create an impression unfavourable to the place. The vicinity abounds with gentlemen's seats, which possess an aspect of comfort and elegance, but the surrounding hovels create a melancholy comparison.


The new line of road between **Cork** and **Limerick** passes through **Mallow**, and is of noble proportions; the principal point considered has been an uninterrupted level, to accomplish which, the road is carried round the base of hills and over the intervening glens on bridges 



---

p.142




having much the appearance of aqueducts; but too little attention has been paid to the convex formation, and the construction of drains for carrying off the water, a matter of importance when we consider the lowness of situation, as well as the general wetness of the Irish climate. It would also be an improvement if the stones used in the repairs were more broken than at present, and distributed in a more careful and judicious manner.


A long time is now required to produce a proper surface, as it takes many months to effect an union between large lumps of stone, thrown together without the aid of gravel or smaller pieces to fill up the interstices; and one side, much cut up, and with numerous ruts, is travelled in preference to the other covered by a rough and heavy coat of stones. The old roads in Ireland were invariably constructed over the highest points of ground, and, until lately, a journey was performed by a series of ascents and descents. Road making, or rather jobbing, at one period (and that not very remote), formed a regular matter of traffic to the country gentry, who, being generally on the county grand jury, had influence in obtaining presentments. It has been facetiously said that the Irish squires of the rack-rent school usually bequeathed a law-suit and a score of mortgages with the estate to their eldest son, and left their road contracts as a provision for the younger children — to be serious, the fact of the misapplication of large sums of money voted to improve the country by roads, that might facilitate the conveyance of produce and means of travelling, is notorious.




---

p.143


Youghall
--------


[17](javascript:footNote('E820000-001/note017.html'))

> 1. Lament, lament, old abbies
>   
> The fairies lost command!
>   
> They did but change priests babies,
>   
> But some have chang'd your land:
>   
> And all your children stol'n from thence
>   
> Are now growne Puritanes,
>   
> Who live as changelings ever since,
>   
> For love of your domains.
> 

 
Bishop Corbet.*The Fairies' Farewell*


Youghall, twenty-four miles east of **Cork**, is situated at the mouth of the River **Blackwater**, near a fine open beach of smooth sand, but its harbour has the disadvantage of a bar, which renders the entrance often dangerous, and sometimes impossible.


The town consists of one long street, with smaller streets leading off on each side, and is a fashionable place of resort for sea bathing. 



---

p.144




It would seem persons with limited incomes might live comfortably in **Youghall**, as I learned that the price of provisions in general is low; a pair of green geese may be bought for ten-pence; a large hake for five-pence; twenty -three pounds of potatoes, termed a weight, for two-pence; mutton five-pence per pound; fowls ten-pence the pair; a Michaelmas goose, a shilling to eighteen-pence; and so on in proportion.


The Inn (or hotel as it is called) was dirty, and ill provided for the reception of travellers; but as there was much to be seen in the place, and we had some letters of introduction, its accommodations were of little comparative consequence to us.


The remains of ancient buildings in **Youghall** are sufficiently numerous and conspicuous to demand notice, even from the casual visitor; and the result of an inquiry into their history will not prove uninteresting.


The house of the ill fated **Sir Walter Raleigh**, who was mayor of the town in 1588, is still to be seen nearly in the same state as when inhabited by him; and many objects are pointed out, to which the charm of traditional anecdote is attached.


The town walls, with their towers, continue in some places their original height, although in a very ruinous condition; and now terminate the gardens of a few good houses, that are elevated above the main street, by the natural rise of the ground, and command a charming view, over the town, of the river and harbour. In these gardens the myrtle flourishes with surprizing luxuriance, having, in many instances, attained the growth of twenty feet.


On digging close to the town walls about five or six years ago, four curious pieces of stamped pewter were turned up, which appear to have been used as coins, or promissory counters, but are without any inscription or mark that might determine their history and use. Two of these pieces were of a triangular, and two of a circular shape, the largest of the latter about the size of an old half-crown, the other 



---

p.145




nearly that of a shilling, and the triangular bits seemed to be two quarters of a large circular one. With them was also found a very small base metal coin, of that kind technically named by collectors, black, or maille money. On the obverse it has, in an oval, a full faced head, with a mitre, and the inscription Patricivs; the reverse has the common cross with a single pellet in each quarter, something like those found on most of the coins of our Edwards and Henrys, and some legend, probably the moneyer's name, which I am unable to decipher. This coin appears to be one of those called Turney's, a corruption of the word Tournois, from being struck at Tours in France, which circulated generally in Ireland, until forbidden by Edward III., in 1338.


Many monkish remains have been occasionally found at **Youghall**. I remember seeing amongst others a hollow bronze cross, about seven inches in length, which opened, and was divided into several compartments, or chambers, for the deposition of relics.


The town of **Youghall** is indebted to the Earls of Desmond for its former distinction, the chief buildings having been erected by them. In 1579 it was besieged by the famous rebel earl, who, without excepting the religious foundations, gave up the place to unrestrained pillage, a sacrilegious proceeding, that, according to Irish historians, drew down on him the signal vengeance of Heaven. Some Spanish soldiers, who were associated with Desmond's followers in this exploit, strongly reprobated these excesses, and one of the foreigners is said to have so deeply commiserated the sufferers in this scene of wanton havoc, that he divided his cloak amongst five children, who had been stripped of their clothes, and left naked by some of the Irish kearns.


On the news of the capture of **Youghall** by the rebel party, Lord Ormond sent a small troop from **Waterford**, under the command of Captain White, to recover it; but, though an entrance was effected at the Water Gate, they were repulsed with the loss of their leader and 



---

p.146




several men, by the Seneschal of Imokilly, who defended the town for his relative the Earl of Desmond — at which temporary success that nobleman was prodigiously elated — but as, in consequence of being plundered, the place was deserted by its inhabitants, only one poor friar remaining within the walls, Fitzgerald the Seneschal was obliged to abandon it for want of provisions, and it was immediately garrisoned with three hundred men by order of Lord Ormond, who invited the fugitive citizens to return, and Sir William Pelham directed Mr. Coppinger the mayor, who had surrendered the town to Desmond, to be hanged at his own door.


Three years afterwards (1582) the Seneschal of Imokilly endeavoured to regain **Youghall**, but was defeated with the loss of fifty of his followers. In 1645, **Lord **Cork**** maintained the town for nearly ten weeks, against a large body of the Irish forces under Lord Castlehaven, and compelled him to raise the siege.


As a matter of course **Youghall** submitted to **Cromwell**, who embarked here for England, after his almost incredible progress through Ireland, that, like a resistless torrent, overwhelmed every attempt at opposition.


Two religious houses were built here by the Geraldines about the middle of the thirteenth century, one on the north, the other on the south side of the town, and although only a small fragment of the former now exists, romantic associations are attached to the memory of both. The foundation of the south abbey, according to Sir James Ware, the first Franciscan friary in Ireland, originated in the following circumstance: Maurice Fitzgerald, being about to raise a castle, was requested by the artificers engaged in marking out the site on the eve of some festival, to bestow a piece of money on them and their fellow labourers for the prosperity of the undertaking, which he directed his son to do, but who, instead of obeying the command of his parent, violently abused the workmen. His conduct so much affected the father that he changed his intention, and assuming the 



---

p.147




habit of that order, caused a house for grey friars to be erected, in place of his intended castle. The other abbey was founded by Thomas Fitzgerald, commonly called the Ape, a name bestowed on him in consequence of the tradition that a tame baboon or ape, at his father's castle in **Tralee**, had snatched him from his cradle, and ascending the highest part of the walls, carried the infant about in his arms for a considerable time, to the terror of the spectators, but at last brought the child down safely, and deposited him again with much care in his cradle. The crest and supporters of the Duke of **Leinster**, who claims descent from Thomas the ape, are monkies, in remembrance, as the heralds state, of this event.


The college of **Youghall**, now the property of the Duke of Devonshire, is a tolerably perfect remain, and one that merits attention, were it merely from its history, which gives us a striking picture of the times. It was founded in 1464, by Thomas Earl of Desmond, for a warden, eight fellows, and as many choristers, endowed with several livings, and a landed estate of 600l. per annum. It continued to increase in revenue and patronage, and had the good fortune to escape the general plunder at the reformation; — Dr. Witherhead, who held the wardenship *in commendam* with his bishopric of **Waterford**, preserved it for some years; but the next warden, Nathaniel Baxter, was served with an order from Queen Elizabeth to resign, within forty days, to Thomas Southwell, Esq. of Norfolk, and Mr. Fitz Harris of Ballycremane, who had obtained a grant of it from her, for the purpose of passing away the lands to themselves and their friends, as had been the case with so many other ecclesiastical foundations. Dr. Baxter, seeing the object of this order, which they took little pains to conceal, and supposing it lawful to cheat a robber of his prey, took advantage of the forty days, summoned his fellows, and passing a long lease of the whole college estate to Sir Thomas Norris, Lord President of **Munster**, obeyed strictly the letter of the royal order, and resigned his wardenship without its revenues to Fitz Harris and Southwell. In a rage, they 



---

p.148




refused to accept of it, and both Baxter and Sir Thomas Norris died before the affair was settled. Upon this the fellows elected Dr. Hanmer, who, three years after, renewed Norris's lease to Jones, in trust for **Sir Walter Raleigh**, reserving only to themselves the parsonage of Carrigoline, and the impropriated rectory of **Mallow**. Such, however, was the facility with which the church was then deprived of its possessions, that another rapacious courtier, Sir George Carew, ‘nil actum reputans dum quid superesset agendum,’ posted over to London the very next year, and obained a patent for the whole ecclesiastical property of the college, from James I.; a sweeping grant, including the advowson of **Youghall**, which the warden had kept for his own maintenance, and the two reserved livings.


**Sir Richard Boyle, afterwards Earl of **Cork****, one of the most sagacious men of his day, lived all this time quietly at **Youghall**, no inattentive observer of the scene passing before him, and when the claimants on all these different and discordant grounds began to be tired of their disputes and unable to settle them, he stepped calmly in and bought up all their titles for a trifle; then getting Hanmer to resign the wardenship in favour of his relative Dr. Richard Boyle, Bishop of **Cork**, Cloyne, and Ross, obtained a grant in fee-farm for ever of all the property temporal and spiritual, to himself and his heirs, including the warden's house and garden, and the site of the college itself.


The Earl did not enjoy this property without a struggle with Lord Stratford's attorney-general, Sir William Ryves, who obliged him to give up the living and three hundred acres of land; but he eventually succeeded (in 1640) in obtaining a fresh patent from the crown, for full possession of the college and all its revenues.


The tithes of **Youghall** parish, which amount at present to 500l., and three hundred acres of land, much underlet (fine included) at 75l. per annum, are still in possession of the warden. The college and warden's house, both large and handsome buildings, have been 



---

p.149




long since alienated by **Lord **Cork****'s family; but three smaller tenements (settled no doubt in lieu of them) go with the wardenship, which office, now in the gift of the crown, has been, ever since Lord Strafford's time, united, as part of its possessions, with the see of Cloyne; but the only remaining proof of its former large property is its payment to the First Fruits office of 100 marks (sixty-six pounds), while the bishopric itself is only rated at ten guineas.


The noble Gothic window in the ruinous gable end of the present parish church, that stands close to the college, invites examination, and is pointed out as the richest and most perfect specimen of the kind in Ireland. Although the effect of its original graceful proportions is destroyed by the lower part being built up some feet, it is certainly a fine piece of workmanship, and is formed by a double Gothic window, each consisting of two slight munnions surmounted by open circular tracery, and terminating in a trefoil ornament. These windows become one by the outside line of their arches uniting in a common point over the double massive munnion, which is thus the centre, and this diamond shaped space is occupied by a Catherine wheel.


There are some monuments in the interior of the church deserving notice. The south transept was purchased in 1606, by **Lord **Cork****, from the corporation of Youghall, and contains the monument of that 



---

p.150




nobleman, with several effigies and escutcheons painted and tricked out in the manner of James I.'s time. As six pages have been devoted by **Dr. Smith** in his History of Cork to the account of this monument and its inscriptions, I must refer to that work, particularly as I could obtain only a peep at it through a keyhole, the chapel in which it is being walled off from the church, and the door unlocked only on particular occasions, and by express permission.



> 1. For as the tombe, is built in sumptuous guise,
>   
> So to the same, a closet fayre is wrought,
>   
> Where lords may sit in stately solemne wise,
>   
> *As though it were a fine device of thought,*
>   
> To beautifie both tombe and every part
>   
> Of that fayre worke, that there is made by arte.
> 

 *Leland*


In the same chapel there is an epitaph on Sir Richard Villers, Lord President of **Munster**, who died in l626, which bears a strong resemblance in style to those written by Ben Jonson. 


> 1. Munster may curse the time that Villers came
>   
> To make us worse, by leaving such a name
>   
> Of noble parts, as none can imitate,
>   
> But those whose hearts are married to the state;
>   
> But, if they press to rival him in fame,
>   
> Munster may bless the time that Villers came!
> 




In the north transept, part of which I think forms the vestry room, are some curious old monuments — I remarked two recumbent effigies lying on the ground, that were once apparently placed on tombs; the feet of each rested on a lion or some animal, and one, in the robes of an ecclesiastic, held a bird in his hand; at the edge of the other stone was an inscription in Gothic letters, which might be read without difficulty. Near these figures, and forming part of the pavement, is one of 



---

p.151




those ornamented crosses, of which such an endless and whimsical variety are to be found in almost every old abbey and church in Ireland. This, which bears the date (a very singular circumstance) of 1517, in a circle on the shaft of the cross, is accurately copied: along the edge is an inscription, but I could only read with ease 
‘Mayor Ville de You  
[*...*]  
’


In the nave, half concealed by one of the pews, there is another of these crosses, with a head sculptured in bold relief, and without any inscription, which I sketched as affording an uncommon difference. Tradition names it as the tomb of Roynane, who was Mayor of **Youghall** in the early part of Elizabeth's reign.


There is much more to detain a monumental antiquary in this church than I have the means of enumerating, as the difficulty of getting at some tombs and the injured state of others precluded the thoughts of an effort at a complete investigation, without considerably more leisure and facilities than I could command.


The church has side aisles formed by a row of Gothic arches, supported on heavy square columns; and at the east end, close to the transepts, a wall is built across the former chancel. The space between the present interior and the ancient splendid window is used as a burial-place, and filled with rubbish and broken grave-stones, amid which the rank nettle shoots up, and the briar, in entangling embrace, flings its long arms around fallen architectural decorations. Here too are some costly monuments, particularly a sepulchral niche 



---

p.152




in the north wall, carved and richly adorned with trefoil compartments; and over it is the inscription, 
  


‘Hic Jacet
  

Thomas Fleming;’


It would be unpardonable to omit noticing the house of **Sir Walter Raleigh** adjoining the churchyard, and at present the residence of Sir Christopher Musgrave. It is long and low, the exterior plain and heavy, resembling the common English manor-house of his time. In the interior, those rooms which we saw were completely lined with small oaken pannels, and had large wooden chimney pieces, embellished with very beautiful carved work; nor should it be forgotten that potatoes were first introduced into Ireland by **Raleigh**, who, it is reported, brought them from Virginia, and planted them in his own garden at **Youghall**. However his military exploits deserve execration in the history of Ireland, the benefit conferred on the country by the introduction of this nutritive and prolific root, which at present constitutes almost the entire food of its peasantry, ought to redeem his memory and consecrate his name. A wellknown and not improbable anecdote is related respecting the person to whom the care of the first crop was entrusted: supposing that the apples, as they are called, which grow on the stalks, were the part to be used, he tasted them, but finding the flavour insipid and rather nauseous, threw them away; nor was it until he dug the ground to root out this apparently worthless plant that its value was discovered.


Amongst the distinguished names connected with the history of **Youghall**, the most eminent is that of **Richard Boyle**, or, as he is commonly styled, the great Earl of Cork, who landed in Ireland a needy and speculative adventurer, and in a short time acquired honours, titles, and wealth; by what means, affords a fair subject for inquiry, 



---

p.153




and one which most writers have been willing to record on his own assertion, as **Lord **Cork**** has left a memoir of his success in life, written by himself, in a tone of humility that ill accords with his known arrogant and haughty demeanour, when he had no purpose to serve by a contrary behaviour.


Richard Boyle had been brought up to the law; but perceiving ‘that his employment would not raise a fortune,’ he set out for Ireland as the scene of revolutionary confusion, and landed at **Dublin** the 23d of June, 1583, all his wealth then being ‘27l. 3s. in money, and two tokens which his mother had given him, viz. a diamond ring and a bracelet of gold, worth about 101.; a taffety doublet cut with and upon taffety; a pair of black velvet breeches laced; a new Milan fustian suit laced and cut upon taffety; two cloaks and competent linen, and necessaries, with his rapier and dagger.’


If the 500l. a year, obtained by marriage, be excepted, how **Lord **Cork**** acquired in a few years estates sufficient to awaken the attention of the principal officers of the Irish government, does not appear; but a representation of the number of castles and abbeys of which he had possessed himself with such limited means, was made to Queen Elizabeth, by Sir Henry Wallop, treasurer at war; Sir Robert Gardiner, chief justice of the King's Bench; Sir Robert Dillon, chief justice of the Common Pleas; and Sir Richard Bingham, chief commissioner of **Connaught**. Nor is it likely that these men would unite to ruin an industrious individual without sufficient cause; and it does not seem improbable that Mr. Boyle was secretly supplied with money from Spain, and employed as an agent by that government, about this time meditating the invasion of the country, to secure the principal places of strength in the south of Ireland. Be the matter as it may, Mr. Boyle immediately fled into England, where he was arrested, and confined for a short time a close prisoner; but having rendered some services to the Earl of Essex, then Lord Lieutenant of 



---

p.154




Ireland, he was liberated through his influence with Elizabeth, and appointed to the office of clerk of the council of **Munster**, by a political arrangement resigned for the purpose, the 31st March, 1600, by Ludovic Briskett, an English author of some celebrity, and the successor of the poet **Spencer** in that situation.


As clerk of the council he accompanied the Lord President of **Munster** in his various efforts to reduce the province to submission, and was sent over to London by the Lord Deputy Mountjoy, who assisted the President at the siege of **Kinsale**, with the news of the victory obtained at that place over the Irish, under the Earl of Tyrone, and the invading Spaniards, on the 24th December, 1601, ‘in which employment,’ says **Lord **Cork****, ‘I made a speedy expedition to the court, for I left my lord president at Shandon Castle near **Cork** on Monday morning, about two of the clock, and the next day, being Tuesday, I delivered my pacquet, and supped with Sir Robert Cecil, being then principal secretary, at his house in the Strand, who after supper held me in discourse, till two of the clock in the morning, and by seven that morning, called upon me to attend him to the court, when he presented me to her Majesty in her bed-chamber,’ &c. This very passage, in **Lord **Cork****'s account of his fortunes, is sufficient to throw a doubt upon the other statements made by him, as the performance of a journey from **Cork** to London, in the space of time mentioned (thirty-four hours), must then have been a matter of impossibility, since it is now barely practicable, under the most favourable combination of circumstances; yet so miraculous a journey is dwelt upon by most of his biographers with unhesitating admiration. **Mr. Budgell**, in his Lives of the Boyles, adds, indeed, as a comment on this extraordinary piece of travelling, that he ‘should have made some difficulty of believing the fact, if he had not seen it in his (**Lord **Cork****'s) own memoirs, which are evidently wrote without the least *affectation*, and with a great regard to *truth*.’


Having kissed the Queen's hand, Mr. Boyle returned to Ireland, 



---

p.155




where he purchased from **Sir Walter Raleigh** the forfeited estates of Lord Desmond, granted to him by the crown; Sir Walter, then anxious to dispose of these barren tracts, with his ambitious mind fixed upon his American expedition, sold them to Mr. Boyle for the trifling sum of 1500l., which purchase, as it is called, was concluded on the 7th December, 1602. The transaction, however, seems to have something mysterious about it, as **Lord **Cork**** continued afterwards, from time to time, to supply **Raleigh** with various sums of money, without any apparent return; and it is obvious from **Lord **Cork****'s general conduct, that he read character and understood the value of money too well, to bestow it, without an object, on a daring and unprincipled adventurer like **Raleigh**.


These estates, which **Lord **Cork**** lost no time in getting confirmed to him by the crown, included the manors of Ballynatra, Strancallie, Lysfinneen, Mogeyley, Sheane, **Lismore**; the new college of the Virgin Mary at **Youghall**, the Commendatorship of **Lismore**, the Abbey of Molana, and the town of Tallow, containing above 12,000 acres, in the counties of **Cork** and **Waterford**. Such indeed appears to have been the general fear of **Lord **Cork****'s grasping abilities, that a by-law was actually made by the corporation of **Cork**, forbidding any transaction with him in the disposal or exchange of lands, fearing that he should outwit them in the dealing.


An extract from the letter of a contemporary, **Sir Christopher Wandesford**, lord chief justice of Ireland, addressed to the Earl of Cumberland on the subject of his daughter the Lady Elizabeth Clifford's marriage with Lord Dungarvon, afterwards Lord Burlington, and eldest son of **Lord **Cork****, supports the opinion I am inclined from various evidences to entertain of ‘the great earl.’


‘I pass by the remoteness of the place, cutting off a great part of that comfort indulgent parents promise to themselves, by frequent enjoying and visiting their children and grandchildren. But that a branch sprung from honorable and famous ancestors should be 



---

p.156




grafted into a newly planted and barely rooted stocke of honor, that a considerable part of ancyent possessions acquired and preserved by noble atchevements, shold be suffred to devolve and be mingled with a hastily gotten and suspitiously kept fortune, I confess, in my judgment, requires very good conditionns to followe after, such as might probabely render a more comfortable life for the future to your swete daughter here then in another place. But, my lord, the comforts and blessings of marradg are not so plentifully sowen upon this land that wee may promiss she shall assuredly gather them, for it passeth under observation here, that from thoss nine daughters of his now living and bestowed in marradg, the comforte and fatherhoode that old age promiss to themselves from their children, is not reaped by him, and how much the quiet and composed condition of your daughter's swete and gentile affectionns may be perturbed and disordered by a harsh and incivill conversation, or what disanimation and distemper the discovery and prosecution of my Lord of **Corke**, by the quicke and impartiall sight of my Lord Deputy, may bring with it, I most humbly submit to your lordship's more serious consy deration; for if the day of retribution never come when the rest of his estate shal be questioned, yet it is not to be doubted that there will be a tyme given for the complaints of the church: for I am very confydent, since the suppression of abbeys, no one man in either kingdome hath so violently, so frequently layde prophane hands, hands of power, upon the church and her possessions, (even almost to demolition where he hath come) as this bold **Earle of **Corke****. Of that 6000l. per annum estated nowe upon his sonn, I take full a third part to be spiritual deduction. **Lismore**, his principall house and seate, with lands worth near 2000l. per annum, the possessions of the bishop of **Lismore**, reserving a free rent of 20l. per annum for the bishop, torne from that sea by the poure of Sir Walter Rawley. **Yughall** (nowe to be the jointure-house of your swete daughter), a colledge consisting of a warden and eight personnes, all presentative and endowed, in value 800l. per annum, depopulated 



---

p.157




by himselfe (the incumbent warden yet living) and turned into a laye possession. And the better to support thess dignityes of the church, he hath, in commendam, nere one hundred spiritual livings, some impropriations, divers vicaridges, which he supplyeth by small stipendaryes.’


**Lord **Cork**** naturally dreaded the investigation of titles to the Church lands by **Lord Strafford**, and we find him the avowed enemy of that unfortunate nobleman, many of whose actions seem to have arisen purely from motives of justice. **Lord **Cork**** in his own writing says, that he was prejudiced no less than 40,000l. in his personal estates, and in his inheritance 2000 marks yearly, by the arbitrary proceedings of 
**Lord Strafford**, on whose execution we find the following note in one of his diaries.


‘This day the **Earl of Strafford** was beheaded; no man died more universally hated, or less lamented by the people.’ The bitter uncharitableness of this comment on the death of a fallen enemy may perhaps be excused, had not the writer, after Strafford's attainder, meanly endeavoured to become reconciled to that minister, ‘fearing the king would still have protected him from the resentment of the commons.’


The exertions of **Lord **Cork**** in raising and equipping men at his own expense, during the turbulent period of 1641, for which so much praise has been lavished upon his zeal and loyalty, can be regarded as nothing more than an act of self-defence, and the mere protection of his private property; for it must be remembered every individual at that time was of necessity obliged to appear in arms; and as the possessor of an extensive district, it was impossible to avoid heading his own clan, or body of tenantry, if he wished to retain his estates or influence.


This is placing **Lord **Cork****'s zeal and loyalty in the most favourable point of view; for the eagerness with which he impeached as rebels the Lords Roche, Montgarret, Skerrin, Muskery, Dunboyne, Castleconnell, 



---

p.158




Loughmore, and above eleven hundred persons of consequence, indictments against whom he submitted to the speaker of the English House of Commons, for the opinion of the law officers of the crown, as a security against any legal informality, cannot appear disinterested when we recollect the rapacious hint with which they were accompanied, that should the house direct the proceeding against all these individuals to outlawry, the value of their lands and possessions would be found to amount to more than 200,000l., and that he had been compelled to sell his plate for the support of the king's service, and had spent, ‘with a free heart and a liberal hand,’ all that he had, and was ‘able to do no more.’


**Sir Richard Cox** (in the preface to his second volume of the History of Ireland) bestows a long panegyric upon ‘the noble Earl of Cork,’ whom he describes as one of the most extraordinary persons either that or any other age has produced, with respect to the great and just acquisitions of estate that he made, and the public works he began and finished for the advancement of the English interest and the Protestant religion in Ireland, as churches, alms-houses, free-schools, bridges, castles and towns; viz. **Lismore**, Tallow, Cloghnakilty, Iniskeen, Castletown and Bandon, which last place cost him 14,000l. insomuch that when **Cromwell** saw these prodigious improvements, which he little expected to find in Ireland, he declared that if there had been an Earl Cork in every province, it would have been impossible for the Irish to have raised a rebellion.


But it is evident, from what has been said, that the justice with which **Lord **Cork**** obtained his vast estates has not been questioned without reason; and it will be seen that these prodigious improvements were the only means by which it was possible for him to render his newly acquired property productive, or give a value to tracts of country literally depopulated, by the desolating measures used for the suppression of Desmond's rebellion.


Proof may be required of the vaunting tone in which **Lord **Cork****


---

p.159




constantly spoke of himself. Can a stronger be given than the severe rebuke with which **Archbishop Laud** concludes a letter addressed by him to this nobleman?


‘And whereas your Lordship writes at the latter end of your letters that you bestow a great part of your estates and time in charitable works, I am heartily glad to hear it; but, withal, your Lordship will, I hope, give me leave to deal freely with you; and then I must tell your Lordship, if you have done as you write, you have suffered strangely, for many years together, by the tongues of men, who have often and constantly affirmed that you have not been a very good friend to the church in the point of her maintenance. I hope these reports are not true; but if they be, I cannot call your works charitable, having no better foundation than the livelihood of the church taken away to do them.’


I stand too far removed from the times of **Lord **Cork**** to be suspected of any indirect motive in representing his character in an unfavourable light, nor is it now a matter of much importance; but so many points may be adduced to establish a contrary estimation to that we should naturally form of ‘the illustrious earl’ from the statements of his biographers, that it would not be impartial to omit them in glancing at his history; and many reflections of a more severe nature, couched in opprobrious terms, may be produced, which are omitted, as possibly originating in the jealousy often excited by posterity.


**Lord **Cork**** is said to have powerfully advanced the English interest in Ireland, and it must be granted, if the severest intolerance has been beneficial to the cause of Union: the bigotry of the Protestants against their Roman Catholic brethren in those towns under his influence reached a degree of marked violence unknown in any other part of the kingdom, and which feeling is not entirely eradicated at the present hour; I need only instance the town of 



---

p.160




Bandon, where, over the principal gate, an inscription once stated that 

  

‘Jew, Turk or atheist
  

may enter here
  

but not a Papist.’[18](javascript:footNote('E820000-001/note018.html'))


At **Youghall** it was forbidden, in 1678, and remains on record, that a Papist should buy or barter any thing in the public market; and the manuscript annals of the town, from which I have been favoured with extracts, afford evidence of the illiberality of its corporation towards those of the Catholic persuasion; nor is it without regret that I add the enactments quoted were made during the mayoralties of ancestors of my own.


In 1696, it was ordered that any person but a Protestant freeman, presuming to go to the mayor's feast, should pay five shillings, or be set in the stocks.


1702. Several Papists, who had been admitted freemen, were disfranched, and it was ordered that no Papist should be made free again.


1744. Gregory Grimes, victualler, was disfranched, for having a Popish wife.


I am tempted to notice, as curiosities, two other enactments of the same body. In the years 1680 and 1700, a cook and a barber were made freemen, on condition that they should severally dress the mayor's feasts, and shave the corporation, gratis.


During our stay at **Youghall**, Miss Nicholson accompanied me in a morning excursion to **Ardmore**, celebrated for its round tower. We crossed the river **Blackwater**, here dividing the counties of **Cork**


---

p.161




and **Waterford**, in the public ferry-boat; from shore to shore is nearly an English mile, and it is perhaps the cheapest ferry in the kingdom, the charge for crossing and returning on the same day being only one penny each passenger; yet this brings in a considerable revenue to the corporation of **Youghall**, to whom the right of passage or ferry-boat was granted by a charter of Elizabeth, dated the 3d July, 1559, at the annual rent of 6s. 8d. We were told that the average number of persons who pass daily may be estimated at more than five hundred; nor does this statement appear exaggerated, though in Ireland you seldom receive correct verbal information respecting space, distance, numbers, time, money or locality, almost every account being at variance.


The walk to **Ardmore** was about four English miles, over a rough and hilly road. Its round tower, the chief object of our visit, stands in a little churchyard, on a rocky eminence, near a sandy cove or bay, and rises gigantically above smaller buildings — these are, the church, and dormitory, or shrine, of St. Declan, which I examined, and sketched a ground-plan, explanatory of their relative situations, whilst Miss Nicholson made the annexed drawing.[19](javascript:footNote('E820000-001/note019.html')) The church is evidently very ancient, from the massive irregularity of its architecture, 



---

p.162




and the clumsiness of the buttresses. At present, part of it only is roofed and used for service.


On the exterior of the wall at the west end are twelve figures in bas-relief, I presume intended for the twelve Apostles, much decomposed by age and the weather, each under a small Saxon arch; beneath these are two semi-circular projections, within which various bas-reliefs appear, executed without much attention to regularity. I have copied the entire effect, and three of the most perfect of these sculptures on a larger scale; the subjects appear to be, the Baptism, a Sacrifice, and the Judgment of Solomon.




---

p.163


Rude figures of Adam and Eve, with the Tree of Knowledge between them, are also to be distinctly seen.


The dormitory or shrine is a mere stone hut, lighted by one small square window. In a corner of the gloomy interior are the remains of a tomb, over which, on a stone cross, is placed the decayed capital of a pillar; but enthusiasm and superstition have converted it into a head of St. Declan. Many virtues are attributed to the earth taken out of this tomb, supposed to contain the ashes of that saint, which is made up in packets and sold to those who have faith in charms, as a preventive against various diseases.




---

p.164


A painting of our Saviour, the unskilful production of some village artist, hung against the wall, and near it was a wooden cross; both, I presume, viewed with strong feelings of veneration; but there is always considerable reserve in the communication of any particulars respecting relics or similar objects.


The Tower is constructed, with particular care, of hewn stone, and has four projecting belts round it, a circumstance of rather uncommon occurrence, as if to mark the stories, each of which gradually diminishes in circumference. The conical cap is considerably shaken, but still remains entire; and **Smith**, whose History of Waterford appeared in 1746, mentions ‘a kind of cross like a crutch’ on the top, that is not now to be seen. In a tract lately published, on the Irish Pillar Tower, by **Colonel de Montmorency Morres**, it is said to have been brought down by repeated discharges of musket-balls, and the writer adds, he was informed on the spot, by persons who saw it, that this curious fragment resembled a shoe or monk's sandal. The height of **Ardmore Tower** is stated by **Smith** to be one hundred feet; but Dr. Dartnell, of **Youghall**, informed me he found it on measurement only ninety-one. The entrance, as nearly as I could judge, is between twelve and thirteen feet from the ground, and the circumference of the base about fortyfive feet. In the upper story are four opposite windows, considerably larger than any other apertures in the building except the entrance.


At present I will leave the theories of antiquarian speculators on the Irish Round Tower, for ‘legendary lore’ as probable and more amusing than many opinions gravely advanced on the subject. These edifices are universally regarded by the peasantry as the produce of supernatural agency. ‘As *auld* as the hills, your honour, and troth an' they say it was all built in a night,’ is the general reply to any question about them; a saint or a devil, a fairy or a giant, are alternately the constructors, and the period of the 



---

p.165




work never exceeds one night. **Latocnaye**, in his Promenade d'un Francois dans l'Irelande, speaking of that at Cloyne, remarks, ‘si c'est le Diable qui l'a bâtie le Diable est un bon maçon.’ The visitor of **Ardmore** will hear abundance of tales, in which the patron saint, Declan, appears as the ‘minister of miracles.’ That pious personage of course built the tower, which, it is affirmed, would possibly have reached the sky, if his operations had not been interrupted by an inquisitive old woman, when he hastily concluded his work, and, seizing the intruder, flung her with one twirl to the top, where the remains of her bones continued, until within a few years, a warning to her sex. The ‘cross like a crutch’ has doubtless given rise to this legend. On the shore, a mass of rock is pointed out, equally under the patronage of St. Declan, beneath which it is possible to creep at low water, and the ceremony, if performed on the saint's day, is supposed to relieve the most grievous rheumatic pains, provided the patient, with becoming faith, can insinuate himself through the cavity three times, repeating certain prayers. This rock is reported to have floated from Rome, bearing the consecrated vestments of St. Declan, and a bell for the tower; on whose second journey from thence into Ireland, says **Dr. Hanmer**, in his Chronicle, he ‘arrived in a place called Ard-na ciored, in Latine Altitudo ovium, now called **Ardmore**, the which soile the Lord of Nandesi gave him, where goodly buildings have beene, and as the record runneth — 'Civitas sancti Declani quæ in eo loco posita est, vocatur **Ardmore**, id est altitudo magna.'’


Many Irish manuscripts mention St. Declan; and extracts from a manuscript life were published by Archbishop Usher, in which the good saint is stated to have converted several of the Irish to Christianity some years before the arrival of St. Patrick. On the 24th of July (called St. Declan's Day), vast numbers of the country people flock to **Ardmore** for the purposes of penance and prayer; and I was informed that a skull, encased with silver, is then exhibited as the genuine cranium of that saint.




---

p.166


Keens and death ceremonies
--------------------------



> 1. The women mix their cries, and clamour fills the fields.
>   
> The warlike wakes continued all the night,
>   
> And funeral games were played at new returning light.
> 

 
Dryden. *Palamon and Arcite or; The Knight's Tale from Chaucer. Book III by John Dryden*


‘An easy death and a fine funeral’ is a proverbial benediction amongst the lower orders in Ireland. Throughout life the peasant is accustomed to regard the manner and place of his interment as matters of the greatest importance; ‘to be decently put in the earth, along with his own people,’ is the wish most frequently and fervently expressed by him. When advanced in life, it is usual, particularly with those who are destitute and friendless, to deny themselves the common necessaries of life and to hoard up every trifle they can collect for the expenses of their wake and funeral. Looking forward to their death as to a gala given by them to their acquaintances, every possible preparation is made for rendering it, as they consider, ‘creditable;’ their shroud and burial dress are often provided many years before they are wanted; nor will the owners use these garments whilst living, though existing in the most abject 



---

p.167




state of wretchedness and rags. It is not unusual to see even the tombstone in readiness, and leaning against the cabin wall, a perpetual ‘memento mori’ that must meet the eye of its possessor every time he crosses his threshold.


There is evidently a constitutional difference in the composition of the English and Irish peasant; but this peculiarity may be more satisfactorily accounted for by the prevailing belief with the latter of a future state being a material one, and subject to wants even more urgent than those of this life; under this impression, shoes, considered a luxury quite unworthy a thought, are believed almost indispensable after death, when it is supposed much walking has to be performed, probably through rough roads and inclement weather. The superstition evidently proceeds from the tenet of purgatory or qualification for heaven, held by the Romish church; and on this particular, the general belief of the Irish peasantry is somewhat at variance with the representations of their pastors: the priest describes it as a place of fire, but the people imagine it to be a vast and dreary extent, strewed with sharp stones and abounding in thorns and brambles.


The influence of this doctrine affects rich and poor, according to their circumstances, and is a most valuable one, for I have been assured the emolument it yields to the Catholic church of Ireland, by a late limited calculation, exceeds 650,000l. per annum.


The attachment manifested towards particular burial-places arises from the same cause; and the anxiety amongst the vulgar to be interred with their deceased relatives, bestows even on death a feeling of social interest.


A remarkable instance occurred not long since. An old beggar woman, who died near the city of **Cork**, requested that her body might be deposited in White Church burial ground. Her daughter, who was without the means to obtain a hearse or any other mode of conveyance, determined herself to undertake the task, and, having 



---

p.168




procured a rope, she fastened the coffin on her back, and, after a tedious journey of more than ten miles, fulfilled her mother's request.


This national trait may be recognized in an advertisement copied from the Sydney Gazette of the 1st October, 1814, the existing regulations of which colony oblige every person to give public notice of their departure.


‘Dennis Hurley, intending to quit the colony in the Seringapatam, to visit the land of his forefathers, where he hopes, after this life of toil and trouble, to rest under his native turf, requests that all claims against him may be presented for payment.’ Mr. Hurley, I presume, was one of those ‘real patriots’ 

*who, be it understood,
  

Have left their country for their country's good.’’*


Separate interests (as in the case of marriage) often cause disputes at funerals; and as no acknowledged rule exists in such cases, a battle usually ends the dissension, and the corpse is borne away in triumph by the victorious party to a cemetery perhaps twenty miles distant from that originally intended.


At a Roman Catholic clergyman's funeral, which took place recently in the South of Ireland, the fathers of his order were opposed by the relations of the deceased, who wished the coffin to be conveyed to their family vault, but the attempt proved fruitless, as the fathers, anticipating opposition timely, procured so strong a force that the assailing faction was beat off, and a guard was stationed on the grave for some weeks after to prevent the dead man's resurrection, should it be attempted.


I remember once overhearing a contest between a poor man and his wife, respecting the burial of their infant. The woman wished to have the child laid near some of her own relations, which the husband strongly opposed, concluding her attachment to her friends 



---

p.169




was superior to her love for him; but he was soon convinced by his wife's argument, that as her sister had died in child-birth only a few days previous, she would afford their poor infant suck, which nourishment it might not have if buried elsewhere.


Another instance of similar superstition occurred in the case of a woman, who presented several beggars with a loaf and porringer, that her deceased child might not want a porringer or bread in the next world. She accounted for her knowledge of the wants of an after-state by saying that a very good man, who used to have occasional trances, in which it was known his soul left his body and became familiar with disembodied spirits, returning to its former habitation after a short absence, told her, on his recovery from one of these fits, that children, dying at an early age, whose parents' neglect deprived them of the use of a porringer, were obliged to lap milk out of their hands; whilst others, who were provided in life with one, had a similar article prepared for their comfort in a future state; and ‘now,’ continued the woman, as she bestowed her last loaf and porringer on a mendicant, ‘my mind is eased of its burthen, and my poor child is as happy as the best of them.’


Many other anecdotes of the same nature might be related, but these are sufficient for the purpose of illustration.


The belief also of a similarity between spiritual and mortal existence extends, not merely to necessities, but to points of etiquette.


It is a general opinion amongst the lower orders, that the last buried corpse has to perform an office like that of ‘fag’ in our public schools by the junior boy, or at a regimental mess by the youngest officer; and that the attendance on his churchyard companions is only relieved by the interment of some other person. The notion may seem too absurd, yet serious consequences have sometimes resulted from it; and an instance comes within my recollection where two funerals, proceeding to the same burial-ground, arrived within view of each other a short distance from their place of destination. 



---

p.170




Both immediately halted, and a messenger was mutually despatched to demand precedence; their conference terminated in blows, and the throng on both sides forsaking the coffins, rushed impetuously forward, when a furious contest ensued, in which some lives were lost.


It is a prevalent notion that the ghost of a stranger is seldom well received by the ancient possessors of a churchyard, particularly if it has long been reserved to a clan or sept, when the ‘cuggeriegh,’ or intruder, is sadly annoyed by his associates. There is in this a strange variation between life and death in the Irish character, as the trait of hospitality towards strangers is proverbially predominant while living.


When priests, or others noted for their sanctity, die, their graves are resorted to for some of the clay, which is mingled with water and drank for the cure of various diseases.


Sir Richard Musgrave mentions that earth from the grave of Father Sheehy, who was executed about the middle of the last century as the leader of some White Boy outrages, was held in great repute, and taken away so rapidly, on account of its supernatural powers, that the sexton had more than once to renew the covering. Recent cases may be named, where this custom has been carried to such lengths that it was interdicted under the threat of exemplary punishment.


The wake of a corpse is a scene of merriment rather than of mourning. The body lies exposed in the coffin for two or three nights previous to interment, surrounded by many candles, and with the face uncovered. To avert misfortune arising from the death of the heads of families, when a man dies his head is placed at the foot of the bed; but this ceremony is not deemed necessary with women, and they are allowed to remain in the usual position. In the evening a general assembly of the neighbours takes place, when they are entertained with whiskey, tobacco and snuff. On these occasions songs are sung and stories related, while the younger part of the 



---

p.171




company beguile the time with various games, and sports, such as blind man's buff, or hunt the slipper. Dancing, or rather running in a ring, round an individual, who performs various evolutions, is also a common amusement; and four or five young men will sometimes, for the diversion of the party, blacken their faces, and go through a regular series of gestures with sticks, not unlike those of the English morris dancers. Amongst the games played at wakes, are two which I have never observed out of Ireland, and from their being so universal with the peasantry, they are probably of considerable antiquity. One of these is called ‘the walls of Troy,’ and the other ‘short castle.’ Of the former, although I took some pains to acquire it, I now find myself unable to give a satisfactory description; the latter is played on lines (usually marked with chalk) in this form. Each player is provided with three counters, (small black and white pebbles, or shells,) which are singly deposited on the board in turn: the game is won by getting these three counters in a straight line. The centre point is considered the most advantageous, and is always taken by the first player; when all the counters are deposited, moves arc made from one point to the next, should it be unoccupied, and so on, until a careless move on either side decides the game, by allowing the adversary to form his three counters in a row.


An Irish funeral procession will present to the English traveller a very novel and singular aspect. The coffin is carried on an open hearse, with a canopy supported by four pillars, not unlike the car used at Lord Nelson's funeral; it is adorned with several devices in gold, and drawn by four horses, and is, perhaps, more impressive to the beholder, than the close caravan-like conveyance used in England; but what is gained in solemnity by the principal feature, is suddenly destroyed by the incongruity of the rest of the train, generally composed of a few postchaises, the drivers in their daily costume of a long great coat and slouched hat. In addition to these, I have seen a gig 



---

p.172




in which the clergyman (I imagine, by his being equipped in a white scarf and hat-band) drove a friend; afterwards came a crowd of persons of all descriptions on foot. No noise, no lamentations were to be heard; but the figure in the flowing white scarf brandishing his whip, gave it, at a little distance, very much the effect of an electioneering procession.


The open hearse is common throughout Ireland, and that used by the poorer classes becomes perfectly grotesque, from the barbarous paintings of saints and angels with which it is bedizened. The concourse of persons who attend the funeral of an opulent farmer, or a resident landlord, is prodigious. Not only those to whom the deceased was known, but every one who meets the procession, turns to accompany it, let his haste be ever so great, for a mile or two, as nothing is accounted more unlucky, or unfriendly, than to neglect doing so.


The funeral of a gentleman acknowledged as the head of a clan (now an event of rare occurrence, and almost solely confined to the county **Kerry**) is one of those sights it is impossible to behold without feeling sublime sensations. The vast multitude, winding through some romantic defile, or trailing along the base of a wild mountain, while the chorus of the death-song, coming fitfully upon the breeze, is raised by a thousand voices. On a closer view, the aged nurse is seen sitting on the hearse beside the coffin, with her body bent over it; her actions dictated by the most violent grief, and her head completely enveloped in the deep hood of her large cloak, which falls in broad and heavy folds, producing altogether a most mysterious and awful figure.


Then at every cross-road, such roads being considered symbolic of their faith, there is a general halt; the men uncover their heads, and a prayer is offered up for the soul of their departed chief.


The Irish funeral howl is notorious, and although this vociferous expression of grief is on the decline, there is still, in the less civilized 



---

p.173




parts of the country, a strong attachment to the custom, and many may yet be found who are keeners or mourners for the dead by profession.


In the fourth volume of the Transactions of the Royal Irish Academy, the musical notation of one of these lamentations may be seen; and **Dr. O'Brien**, in his Irish Dictionary, describes the keen[20](javascript:footNote('E820000-001/note020.html')) as — ‘a cry for the dead, according to certain loud and mournful notes, and verses, wherein the pedigree, land, property, generosity and good actions of the deceased person, and his ancestors, are diligently and harmoniously recounted, in order to excite pity and compassion in the hearers, and to make them sensible of their great loss in the death of the person whom they lament.’


Having a curiosity to hear the Keen more distinctly sung than over a corpse, when it is accompanied by a wild and inarticulate uproar as a chorus, I procured an elderly woman, who was renowned for her skill in keening, to recite for me some of these dirges. This woman, whose name was Harrington, led a wandering kind of life, travelling from cottage to cottage about the country, and though in fact subsisting on charity, found every where not merely a welcome, but had numerous invitations, on account of the vast store of Irish verses she had collected, and could repeat. Her memory was indeed extraordinary; and the clearness, quickness, and elegance with which she translated from the Irish into English, though unable to read or write, is almost incredible. Before she commenced repeating, she mumbled for a short time, probably the beginning of each stanza, to assure herself of the arrangement, with her eyes closed, rocking her body backwards and forwards, as if keeping time to the measure of 



---

p.174




the verse. She then began in a kind of whining recitative, but as she proceeded and as the composition required it, her voice assumed a variety of deep and fine tones, and the energy with which many passages were delivered, proved her perfect comprehension and strong feeling of the subject, but her eyes always continued shut, perhaps to prevent interruption to her thoughts, or her attention being engaged by any surrounding object.


From several keens which I took down from this woman's dictation, I have selected four, and to each I have attached a short explanatory introduction. They will doubtless appear to the English reader odd combinations of the sublime and vulgar..


1. A keen composed on **Sir Richard Cox** the historian, who died in 1733; the first verse presents a curious picture of Irish hospitality.


‘My love and darling, though I never was in your kitchen, yet I have heard an exact account of it. The brown roast meat continually coming from the fire; the black boilers continually boiling; the cock of the beer-barrel for ever running; and if even a score of men came in, no person would inquire their business; but they would give them a place at your table, and let them eat what they pleased, nor would they bring a bill in the morning to them.’


‘My love and friend, I dreamed through my morning slumbers, that your castle fell into decay, and that no person remained in it. The birds sung sweetly no longer, nor were there leaves upon the bushes; all was silence and decay! — the dream told me that our beloved man was lost to us — that the noble horseman was gone! the renowned Squire Cox!’


‘My love and darling, you were nearly related to the Lord of Clare, and to O'Donovan of Bawnlehan; to Cox with the blue eyes 



---

p.175




and to Townsend of White Court. This is the appointed day for your funeral, and yet I see none of them coming to place even a green sod over you.’


2. Is the lamentation of a man named O'Donoghue, of Affadown, or Roaring Water, in the west of the county **Cork**, for his three sons and son-in-law, who were drowned. ‘*The wild geese,*’ an idiom used in the last verse, was a popular name given to such young men as volunteered into the Irish brigade.


‘It was on a rainy Monday; a fair gale blew, and my sons left the shore an half an hour before sun-rise to fish in the sea; my children were driven far away to be drowned. This year has been the year of my ruin for ever!’


‘Cormick (Charles), my eldest child, he could kill with his gun every bird that flew in air, — the wild duck, and the partridge, and the grouse, and black plover of the lonesome mountains!’


‘Cormick, my dear! — flower of young men, who was mild and well educated, who was just and pure and good! — Oh! glorious King of Heaven, if thou hadst but spared him to me! — It was the loss of him that broke my heart entirely; I might — I could have parted with the rest.’


‘Daniel, my dear Daniel, the youngest of my sons, it was this day fortnight he was washed on shore, without strength or life in his body. I saw him as he lay lifeless upon the shore, and my heart was cold and dumb and motionless at the sight!’


‘Children, dear children, do you pity me? do you see me? look on me, your poor father crying and lamenting for the sunshine of his eyes; for the life of his life, for the soul of his soul; what is he now? — a poor broken hearted old man, weeping alone in the cold corner of a stranger's house!’


‘Great is my grief and sorrow! sadness and tears weigh heavy on 



---

p.176




my Christmas. To have my four young and stout men thrown on the will of the waves! If the great ocean, or the dark caves of the ocean would restore the three bodies that now lie in its depths, how beautifully they would be keened and lamented over in Affadown!’


‘Great is my grief and sorrow that you did not all go from your father on board ship! — or if my sons had left me for a season, like the wild geese, to go to a foreign land, then might I have expected from my Maker the help of my four mild and clever young men at some future time.’


3. About the middle of the last century, Mr. O'Sullivan the younger, of **Beerhaven**, or, as he was called, Morty Oge O'Sullivan, possessed considerable influence in the west of the county **Cork**. The chief of a rude and mountainous district, and supported by a numerous and hardy body of dependants, he had long set both the laws and magisterial authority at defiance. Grown confident in his own strength, and fearless of legal punishment, he became an agent for the French and Spanish governments, enlisting men for their service in Ireland, and transporting them in a vessel of his own to the continent. Mr. Puxley, a neighbouring gentleman of respectability, laid informations before the secretary of state, of such notoriously disloyal conduct, and O'Sullivan, actuated by revenge, having by some means gained intelligence, waylaid and shot Mr. Puxley on his return from church. This daring assassination called for a particular visitation, and on the 2d May, 1754, a party of military, commanded by Lieutenant Appleton, was despatched from **Cork** to **Beerhaven**, where they arrived on the Saturday following about midnight. O'Sullivan, expecting an attack, had fortified his residence, and posted sentinels, who were surprised; but the barking of a dog alarmed the inmates, and they obstinately defended themselves for some time, until the house was set on fire, when O'Sullivan, appearing at the door, was shot through the heart.



---

p.177




Many of his men were killed or severely wounded in this engagement, and two were made prisoners, one of whom was Council, the reputed author of the following lamentation.


The vessel employed by O'Sullivan in carrying on his illegal traffic with France was immediately sunk by a king's cutter sent round for the purpose, to the stern of which his body being lashed, was towed through the water to **Cork**; his head was afterwards spiked on the south gaol of that city, and his remains interred in a bastion of the New Fort.


Connell was the confidential servant of this disaffected character, and is reported to have composed and sung the present threnody, the night previous to his execution.


‘Murty, my dear and loved master, you carried the sway for strength and generosity. It is my endless grief and sorrow — sorrow which admits of no comfort, that your white head should be gazed at as a shew upon a spike, and that your noble frame is without life.’


‘I have travelled with you, my dear and much loved master, in foreign lands, and through various provinces and counties, and in the royal prince's army, when we moved with kings. But it is through the means of Puxley that I am left in grief and confinement in **Cork**, locked in heavy irons, and without the hope of being released.’


‘The great God is good and merciful! I ask his grace and pardon, and his support, for I am to be hanged at the gallows to-morrow without doubt; the rope will squeeze my neck, and thousands will lament my fate, but may the Lord have mercy upon my master! it was for his sake that I am now in their power.’


‘Kerryonians (Kerrymen), pray for us! sweet and melodious is your voice, my blessing I give to you, but you will never see me again amongst you alive; our heads will be upon a spike as a shew, 



---

p.178




under the cold snow of the night, and the burning sun of the summer, and every other change of weather.’


‘Oh! that I was ever born! — oh! that I ever returned to **Beerhaven**! Mine was the best of masters that Ireland could produce; may our souls be floating to-morrow in the rays of endless glory!’


‘The lady his wife, heavy is her grief, and who may wonder at that, were her eyes even made of green stone; when he, her dear husband, was shot by that ball? If he had retreated, our grief might have been lighter, but the brave man would not, for the pride of his country, retreat.’


‘He has been in kings' palaces, and in Spain he got a pension; the lady of Clare gave him robes bound with gold lace as a token of remembrance. He became a captain on the coast of France, and yet should he return to Ireland for us to lose him.’


‘There is a lady in London who expects him every day with his vessel.’


The rest wanting.[21](javascript:footNote('E820000-001/note021.html'))

> 1. The sun on Ivera no longer shines brightly;
>   
> The voice of her music no longer is sprightly;
>   
> No more to her maidens the light dance is dear,
>   
> Since the death of our darling, O'Sullivan Bear.
> * Scully! thou false one, you basely betrayed him,
>   
> In his strong hour of need when thy right hand should aid him;
>   
> He fed thee, he clad thee, you had all could delight thee,
>   
> You left him, you sold him, may Heav'n requite thee!
> + Scully! may all kinds of evil attend thee!
>   
> On thy dark road of life may no kind one befriend thee!
>   
> May fevers long burn thee, and agues long freeze thee!
>   
> May the strong hand of God in his red anger seize thee!
> - Had he died calmly I would not deplore him;
>   
> Or if the wild strife of the sea-war closed o'er him;
>   
> But with ropes round his white limbs through oceans to trail him,
>   
> Like a fish after slaughter, 'tis therefore I wail him.
> * Long may the curse of his people pursue them;
>   
> Scully, that sold him, and soldier that slew him!
>   
> One glimpse of Heav'n's light, may they see never;
>   
> May the hearth-stone of hell be their best bed for ever.
> + In the hole, which the vile hands of soldiers had made thee;
>   
> Unhonoured, unshrouded, and headless they laid thee;
>   
> No sigh to regret thee, no eye to ram o'er thee,
>   
> No dirge to lament thee, no friend to deplore thee.
> - Dear head of my darling! how gory and pale
>   
> These aged eyes see thee, high spik'd on their gaol!
>   
> Thy cheek in the summer sun ne'er shall grow warm;
>   
> Nor that eye e'er catch light, but the flash of the storm.
> * A curse, blessed ocean, is on thy green water,
>   
> From the haven of Cork, to Ivera of slaughter;
>   
> Since thy billows were dyed with the red wounds of fear,
>   
> Of Muiertach Oge, our O'Sullivan Bear.
> * *The Lament for O'Sullivan Beare (made by his Nurse), Jeremiah Joseph Callanan*
> 






---

p.179


The account given of this lamentation, called the ‘Smith's Keenan,’ is at once simple and romantic. A young man (a smith) left his widowed mother and sisters, who resided at Killavullian on the **Blackwater**, and married in a distant part of the country. Some time after, one of his sisters, hearing that he was ill, set out to see him, but before she reached her destination, the night came on, which compelled her, being ignorant of the way, to seek shelter at a cottage on the road side; here she found the inmates preparing to proceed to a wake in the village where her brother resided, and going forward with them, on arrival discovered it to be her brother's wake, at the sight of whose 



---

p.180




lifeless body she burst into the following exclamations. The conclusion is singular; nor is it possible for a translation to do justice to the strain of powerful sarcasm in the original, directed against the wife of the deceased.


‘Brother, dear brother! your long absence from home did not raise you in this world, you left us, and you found a wife who knew not how to love you. No one here knows your family, you are in the midst of strangers; they only know that you were a smith, and son of a smith, from the **Blackwater**'s side!’


‘Oh! if I had your cold limbs by the **Blackwater**'s side, or on the banks of the small river (the **Awbeg**), or by the Bride; Mary and Kate and Julia would cry over you, and our mother would cry most sweetly for you; and I, oh! I would cry more than them all for you!’


‘Oh! brother, dear brother — I might have known that you were laid low, when I did not hear the sound of your forge, or of your sledges, striking strong and noisy!’


‘Dear brother, and my darling brother, you have the marks of a wife that did not love you; she left my brother hungry in the winter, and dry in the summer; without a Sunday dress, and the sufferer from long fasting:’


‘You woman, his wife! my brother's wife, you woman with the dry eyes; you woman who are both dumb and deaf; go home! go any where, leave your husband to me, and I will mourn for my brother.’


‘You woman above with the dry eyes! my brother's wife, come down, and I will keen you; you will get another husband if you are young enough: but I can never get a brother!’


(The priest comes forward and speaks.)


‘Hold your tongue, stubborn stranger, why will you provoke your brother's wife?’




---

p.181


(She answers.)


‘Hold your tongue, stubborn priest! read your Litany and Confiteor: earn your half-crown and begone: I will keen my brother.’


‘These examples of the keen, notwithstanding their inequality of sentiment, and the injury sustained by a literal translation, will not, I am confident, appear wholly destitute of merit, although it is evident there are many passages and allusions, which those unacquainted with local manners and history, can neither feel nor understand correctly. But under any circumstances, the natural expression of sorrow awakens our sympathy, for the simple language of grief is always poetical.’


The national exclamations used on the death of a friend or an acquaintance are often very figurative: ‘May the heavens be his perch to-night!’ is no uncommon ejaculation, on first hearing of the loss of such. What an original metaphor is this, and what a fine allegorical picture does it present! the soul springing upwards like a bird, and resting its weary wings after the flight, in some ‘bower of bliss.’


Nor are keens merely orally preserved amongst the peasantry. I have three original Irish death-songs in M.S. now lying before me, the most recent of which, on a namesake of my own, is dated 21st January, 1822, and consists of thirteen verses, not worth translating, but the English preface prefixed to it is curious, as a specimen of the modern bardic spirit, and is transcribed verbatim.


‘I can most undoubtedly testify that since the death of Captain O'Sullivan Beer Haven, I did not see nor hear any man died so much regretted for, nor even so free from the least stain or blemish attached to his character, as the most worthy and much lamented Edward Croker, Esq. near Curriglass.’ ‘Declared and certified by me the poet, William Cremon.’


Keens are also a medium through which the disaffected circulate 



---

p.182




their mischievous principles, and this they do without much attempt at concealment, the Irish language being a sufficient cloak for the expression of seditious sentiments; few, if any, of the gentry being acquainted with it, as they consider it too vulgar and inelegant to form a part of their studies.


Those criminals whose lives have been forfeited in the cause of rebellion, derive no small consolation from the idea of martyrdom, which they imagine they have attained, and in this they are encouraged by the popular voice, apostrophising their shade as that of an hero and a patriot. Their countrymen are called upon to revenge their death, and to recover the estates of their Milesian ancestors, whose spirit has alone descended to them; on that spirit and what it will achieve, many verses are frequently bestowed. It is compared to the mountain-eagle, that, even in bondage, the hand of strangers could not tame; to the mountain-torrent, that would suddenly burst forth with overwhelming inundation, and destroy the lands where the cold hearted Saxons revelled.


When the awful sentence of death has been pronounced by the judge on an Irish culprit, it is not unusual for him to petition that his body may be given to his friends after execution, and, if this is granted, he meets his fate with fortitude and resignation. Those, who from their official capacity have been obliged to witness such distressing scenes, have often expressed their surprize at the dying declaration of men who were convicted on the clearest and most unquestionable evidence, that they were innocent of the crime for which they were about to suffer, and this assertion has been supported by the most solemn appeals to the Deity. It is only charitable to consider so palpable a falsehood uttered by those on the very brink of eternity, as the result of absolution on the ignorant mind; the doctrine by which the murderer can conscientiously declare his innocence has something in it irreconcilably opposed to truth and reason.




---

p.183


If a complete account of the crimes and conduct at the place of execution of those who had been convicted by the law in Ireland since the Articles of Limerick, could now be drawn up, I am persuaded it would afford a moral and political view of the country, the result of which would surprize even the best acquainted with these subjects. **Dean Swift** appears to have entertained the same idea, and he accordingly made a collection of the printed dying speeches of Irish culprits, which he enriched with his own invaluable comments: one of the volumes of this series was in my possession for a short time, whence I take some extracts, to give an idea of the general tenour of the dying speeches of the last century. The first of these explains the point of copyright in such matters, the others are distinguished by their soundness of reasoning.


‘The last speech and dying words of Valentine Kealy and Cornealus Sulivan, who is both to be executed near St. Stephen's green, this present Saturday, being the 13th instant, March, 1724-5, for robberys committed by them.’



> Good people,
> I am advised by several of my acquaintances to give my speech from my own mouth to some printer, in order to prevent others of that trade from printing sham speeches of me; therefore (*by their perswations*) I sent for the printer in Montrath Street, to whom I made the following true speech, and if any other prints it, I assure you it is false, &c.
> 
> 
> 





> Dear Christians,
> I at first had no thoughts to make any speech, by reason I am far from my friends or relations, but seeing my fellow sufferer doing it I thought fit to do the same, which is in manner following &c.
> 
> 
> 






---

p.184


Captain M'Dermot, who was hanged at Cavan on the 30th March, 1725, for murder, explains his situation thus: ‘And I, who was taught to read the Latin, English, and Irish tongues, and was naturally complaisant to all mankind, am here made an example for the sins of my forefathers.’


As a companion to this, is ‘an elegy on the death of Mr. Jo. Foe, *who unfortunately departed this life* at Kilmainham gallows, October 20th, 1725.’


The first edition of the Cork Remembrancer, a book which should rather be entitled the Cork Criminal Recorder, published in 1783, and compiled by a Mr. Fitzgerald, contains the particulars of almost every execution in that city, during the preceding half century. I have been told that the author of this singular chronicle made a point of being present at the death of every criminal whose exit he has recorded, and he generally marched in the procession from the gaol to the gallows: on one occasion it is reported of Mr. Fitzgerald, that, being confined to his bed by a severe illness, he actually petitioned the judge to postpone an execution, until he was sufficiently recovered to become a spectator.




---

p.185


Cork
----



> 1. Then towns he quicken'd by mechanic arts,
>   
> And bade the fervent city glow with toil;
>   
> Bade social commerce raise renowned marts,
>   
> Join land to land, and marry soil to soil.
> 

 
Thomson. *The Castle of Indolence: an Allegorical Poem. Written in imitation of **Spenser**, Canto II, James Thomson (1859)*


Cork is entirely a commercial city, and the principal town for exports in Ireland. From the traffic carried on here, and the natural advantages of its situation for trade, an old rhyme may possibly prove prophetic. Alluding to the military consequence of **Limerick** at the close of the seventeenth century, it tells us that 


> 1. **Limerick** was — **Dublin** is — but **Cork** will be
>   
> The greatest city of the three.
> 




Places of trade, however important to the prosperity of a country, seldom possess attractions for strangers who may visit them on other than mercantile pursuits; nor will the origin of the name of **Cork** excite expectations, its supposed derivation being from the Irish word Corcagh or Curkig, signifying a swamp or morass; the city standing 



---

p.186




on several marshy islands. Some, however, derive the name from Corrogh, the Irish for a boat or small vessel; while tradition draws it from Corc, a native monarch, whose palace stood on the ground now inundated by the Lough, immediately without the suburbs on the **Kinsale** road; but whatever the name may have originated in, it has been the subject of many witticisms. When Foote was asked by an Irish nobleman, at whose table the bottle had circulated freely, if he had ever been at **Cork**? his reply was, ‘*No, my lord, but I have seen many drawings of it this evening;*’ and an apology of Curran's, to a foppishly dressed packet companion, when coming from Ireland to England in his old fashioned and shabby coat, was a declaration, that he made it a point to go to sea in a *cork jacket*.


The foundation of **Cork** has been attributed to a Danish colony in the ninth or tenth century. Its buildings are neither curious from their antiquity, or beautiful as specimens of architecture, a few recent edifices excepted, built under the direction of Mr. Thomas Deane, to whose liberality and talent, aided by indefatigable exertions, **Cork** is indebted for numerous improvements.


The Parade, South Mall, and some of the modern streets are of good proportions, but the irregularity of the houses destroys that appearance of uniformity so necessary to constitute a fine city; this irregularity is even increased in its effect by variety of colour, the stone used for building in the northern suburbs being of a reddish brown, and in the southern of a cold grey tint. One side of the most conspicuous church steeple, that of St. Anne's or Upper Shandon, has been actually built with red stone, and the other three of limestone; add to this opposition of colours, houses sheathed with deep blue and purple slates, as a protection from the weather, some built entirely of red brick, others stained with a dark yellow wash, and an idea of the harmony, or rather discord, may be formed. Few cities, therefore, are more calculated than **Cork**, to impress a traveller with an opinion of the independent feeling of its inhabitants.




---

p.187


The streets are ill-paved with small sharp stones, and the footways (except parts of the main street) unflagged. By the measurement made for a Paving Board lately established in **Cork**, from whose labours much public good may proceed, there appeared to be 600,530 square yards occupied by the streets and lanes of that city, a space equal to about one hundred and twenty-four acres.


The quays, when finished according to the plan laid down by the Harbour Commissioners, who are embodied by act of parliament, promise to be a splendid improvement in the appearance of **Cork**; and the opening of a new street to the western part of the town, which before could only be gained by narrow and dirty lanes, will be a considerable advantage, as affording a desirable communication to an agreeable walk called the Mardyke, the Mansion House, and some good streets which had fallen into disrepute in consequence of the former approach.


The main street is the most ancient; it was divided into north and south by a bridge and a castle, on the site of the latter stands the Exchange that 


> 1. cringing from the northern blast,
>   
> Hides half its ample front in Castle Street.
> 





It is a heavy, inelegant building, and being no longer used for commercial purposes ought to be removed. A picture of this street, at once just and humorous, is given in an admirable little satire which I once met with. 


> 1. here you may see
>   
> New houses, proudly eminent o'er old,
>   
> Confus'dly interspersed — the old are clad
>   
> In sober state — the new are gay with brick,
>   
> Like new red buttons on an old blue coat.
>   
> Time may perchance — long time with chance conspire
>   
> To deck them all in livery of brick.
>   
> So worsted stockings (I have heard) a pair
>   
> By constant darning have been changed to silk!
> 






---

p.188


This street may be said to have constituted the city of **Cork** until the year 1600; take **Camden**'s account of the place:


‘Enclosed within a circuit of walls in forme of an egge with the river flowing round about it, and running betweene, not passable through but by bridges, lying out in length as it were in one direct broad street, and the same having a bridge over it.’


Blackpool and Old Cork were detached villages on the northern and southern sides of the river, and had little intercourse with the city except as receptacles for the produce of the country, which consisted chiefly of provisions, brought into the city on market days under a military escort.


It was not until the year 1670, about which time the south channel of the river was rendered navigable, that any improvements were made. Some of the eastern marshes, on which the best part of **Cork** now stands, were then drained, and a bowling-green and gardens with temporary buildings formed on the reclaimed ground; but these works were trampled and destroyed during the siege in 1690, under the celebrated Duke (then the Earl) of Marlborough. Immediately after that event **Cork** rapidly extended; almost all the marshy islands adjacent to the one on which it stood, were recovered, and portions of the city are still known by the names of the individuals who first reclaimed them, as Hammond's marsh, Pike's marsh, Dunscombe's marsh, &c. Stretching westward from the first of these marshes, a public walk called the Mardyke, consisting of an embankment nearly an English mile in length, was constructed across a swamp in 1719, at the expense of Mr. Edward Webber, who built at its termination a brick house, (whence it was vulgarly termed the Red House Walk,) and enclosed a tea garden adjoining, which was much frequented by the citizens during the summer.


> 1. the city viewed,
>   
> Likest a watch it seemed, — the dyke a chain,
>   
> A flaunting chain, — a trinket the dyke house,
> 






---

p.189


Hammond's marsh also possessed public gardens, and a ‘large and pleasant bowling-green, planted on its margin with trees kept regularly cut,’ of which some still remain near the present Mansion House, and annexed to these gardens were Assembly rooms. The formation of such insular places of public resort and amusement seems to have been encouraged, and they were the first steps towards improvement.


The east marsh, and that drained by Captain Dunscombe, were formed into the parish of St. Paul, and a church erected in 1723. Christ Church,[22](javascript:footNote('E820000-001/note022.html')) which had suffered severely during the siege, a bomb having fallen through its roof, was rebuilt in 1720, and St. Anne's Shandon in 1722, the old church having been destroyed by the burning of the suburbs, at the same time. The Cathedral also, on account of the injuries it had sustained in 1690, as well as its age, was taken down and rebuilt between the years 1725 and 35. St. Peter's Church was likewise rebuilt in 1782, and scarcely one of the present ecclesiastic or civic buildings of **Cork** were in existence at the commencement of the last century.


[23](javascript:footNote('E820000-001/note023.html'))The old castles and gates that terminated the main street having become ruinous, were replaced by prisons; the north gate built in 1715, for a City Gaol, and the south gate, in 1728, for a County Gaol, the latter of which has been recently removed, as will be the former, on the completion of a more extensive and eligible structure, now building for the purpose, a short distance from the city. These gaols were ill contrived masses, without even the recommendation of superior security, and their removal is attended with advantage to 



---

p.190




the main street already mentioned, which is populous and confined.


The canals intersecting **Cork** were gradually arched over, and the many little marshy islands thus consolidated in one. The channel running through the middle of the present Henry Street was arched in 1774, and four years after, that between Hammond's quay and the west side of the city walls was converted into a street, named after the distinguished patriot Grattan.


Between Tuckey's Quay and the Mall, the present Grand Parade was formed in 1780, and the union of the Long Quay with Colville's Quay became Patrick Street in 1783, about the same time the Potatoe Quay Dock, between the present Corn-Market and Bridewell, was covered in; Nile Street was formed in 1795; 


> 1. once called
>   
> Fenn's Quay, but now being arched 'tis 'clep'd a street;
> 



and subsequently the South Mall, the best street in **Cork**, and Nelson's Place, were created in the same manner.


The description given of **Cork** by Lord Orrery in a letter to **Dean Swift**, dated 1736, does not say much for the attractions of the place or the people; but it appears rather to proceed from a splenetic mood than impartial observation. ‘The butchers are as greasy,’ writes his lordship, ‘the quakers as formal; and the presbyterians as holy and full of the Lord as ever; all things are in statu quo; even the hogs and pigs grunt in the same cadence as of yore; unfurnished with variety, and drooping under the natural dulness of the place, materials for a letter are as hard to be found, as money, sense, honesty, or truth!’ A curious little book printed in **Cork** the following year (1737), and entitled, Remarks upon the Religion, Trade, Government, Police, Manners, and Maladies of the City of Corke, would probably afford an amusing picture of its state. I have never met with a copy of this work, but it has been described to me by a 



---

p.191




dealer in old books, who recently sold one, as an ‘agreeable, witty, and entertaining tract,’ and I presume was written by Dr. Rogers, who is quoted by **Smith** and other authors. In glancing at civic manners and amusements, the stage will naturally be the first point adverted to. The present theatre in Georges Street was built by Spranger Barry, and opened in 1760, with an excellent company of performers, when the works of the best dramatic authors were represented; but the patronage not supporting the expenses of the undertaking, the management soon passed into other hands, and a theatrical monopoly, or contract by a **Dublin** patentee, has been fatal to the drama in **Cork**. This theatre (now the only one) is literally in a state of ruin, where, for a few weeks in the course of every summer, some stock plays are listlessly performed by an inferior corps dramatique; and once in every three or four years the most popular London actor appears, engaged at an enormous salary, but unsupported by even mediocre talent.


A few years after the present Cork theatre was opened, the most singular exhibition took place on its stage, perhaps to be found in theatrical records.


One of the performers named Glover had attended in the morning the execution of Patrick Redmond, a man who was sentenced to be hanged for robbery. After hanging a short time, the body was cut down and delivered to his friends, when Glover, having some knowledge of surgery, and believing the vital spark not to be extinct, recommended the usual methods for recalling animation, which were applied, and proving effectual Redmond speedily recovered. That very evening, inspired by gratitude as well as whiskey, he went to the play-house, and on Glover's appearance, jumped upon the stage and returned thanks to his preserver, to the no small terror and astonishment of the audience.


Derrick, who always gives his opinion as a person of ton, in one of his letters to **Lord **Cork****, mentions having visited Barry's theatre, 



---

p.192




during the first season of the performances in it, and speaks of the scenery as finely painted, and the band of music beyond any thing that could be expected. The same writer describes a public assembly held every fortnight ‘in a large room with white walls, badly lighted, and not encumbered with ornament,’ frequented by ‘very handsome females, dressed in the pink of the mode,’ and compliments **Cork**, on having seen more pretty women in it, than in any other town.


Besides these assemblies, there were weekly meetings termed Drums, which are said to have been extremely social and agreeable, the admission was trifling, the company danced, played cards, talked or promenaded without restraint, and the attendance was generally numerous and respectable. These Drums were much resorted to by the military, and the hospitality of the citizens towards the officers in the garrison, (whom they ever seemed to consider as their guests,) created the most cordial feeling between both, which only once experienced a slight interruption. This was in 1762, when severe and unpleasant bickerings arose between Colonel Molesworth, the Lieutenant Govenor of **Cork**, and Mr. Franklyn the Mayor of the city, in support of the civic power, who obliged the commanding officer to cause a serjeant and twelve men to mount guard daily at his house in Cove Lane, during the last three months he remained in office; but with his successor an entire reconciliation between the military and civil authorities ensued. Concerts and meetings of musical societies were frequent in **Cork**, and the recollection still survives of the excellence attained by several of the amateur, as well as professional members. Amongst the latter, the name of De la Main, many years organist at the Cathedral, ought to be more generally known from the merit of his compositions, particularly of his church music, and it is a reproach to **Cork**, that no effort has been made to collect and publish his works; inaccurate copies of some of which are to be found in print.




---

p.193


The unpopular **Mr. Twiss**, in his Irish Tour, sneers at the florid account given by **Dr. Smith** of the extent and excellence of musical taste in **Cork**, which it must be acknowledged is somewhat bombastic; but **Mr. Twiss**'s irony may have proceeded from another cause, as his reception at **Cork** did not equal his expectations. Few travellers came with more letters of recommendation to Ireland; amongst others he brought one to Mr. Comerford, and was in consequence invited to spend a day at his house. Meeting Mr. Comerford some days after, in a public room, he expressed his surprise in an indelicate manner, (intended as a reflection on the hospitality of his entertainer,) that he had never been invited a second time, by one of the many to whom he had brought introductions. — ‘Sir,’ replied Mr. Comerford, ‘since you wish to know the cause, I will explain it. When a gentleman brings a letter of introduction, he is invited as a matter of course, in compliment to the writer, but if he is asked a second time, it must be on account of his own merit.’


The alarming character of the events of the years 1797 and 98 abruptly terminated the public and private amusements of **Cork**, and imperatively called on all classes to take up arms in defence of their lives and property. The arrival of a French Fleet in Bantry Bay naturally produced a panic in a city not forty miles distant from the scene of invasion, and during the emergencies of that period, the loyalty and zeal of the inhabitants of **Cork** were particularly noticed and approved by the English government. The merchants of the place, at their private expense, kept twenty horses ready for the conveyance of information to the proper authorities; refreshed such troops as passed through the city; and humanely made an allowance to the wife and children of every soldier who had marched against the invading enemy. In 1798, religious and party feeling was excited to the extreme, and ran so high as to create distinctions, the existence of which are not forgotten to the present hour, that 



---

p.194




have checked friendly intercourse and cordiality of sentiment, and destroyed the source of much innocent enjoyment.


Cork first became noted in English history from its connection with the fortunes of Perkin Warbeck, who, under the title of Richard IV., endeavoured to depose Henry VII. from his throne. Warbeck personated Richard, Duke of York, the second son of Edward IV., supposed to have been murdered in the Tower with his brother Edward V., and although the imposture is now generally admitted, many have expressed their belief of his identity, and some curious arguments have been produced in favour of this opinion.


According to Warbeck's confession, or the one made for him on the eve of his execution, he was a Fleming by birth, and in 1492, having landed in Ireland with an adventurer named Pregant Meno, was hailed at **Cork** as heir to the crown, by John Walters, an opulent trader, afterwards mayor of the city, and Stephen Poytou, a disaffected Englishman, who caused him to be instructed in the English language, and promised to assist him in the recovery of his assumed dignity. Having endeavoured to engage the Irish chieftains, particularly the Earls of Desmond and Kildare, in his cause, (noblemen seldom unwilling to enter into any scheme opposed to the reigning king of England,) Perkin left Ireland for France, from whence, on the declaration of peace between that country and England, he passed into Flanders, and three years after, with a small body of followers, made a futile descent on the Kentish coast. After this defeat, Perkin retreated to **Cork**, where he remained some months, but finding his Irish friends unable to render him any effectual assistance, proceeded to Scotland, with a view to excite an invasion of England in his favour.


Although Warbeck was kindly received by the Scottish monarch, who is said to have been instrumental in his marriage with a daughter of the Earl of Huntley, the conclusion of peace between England and Scotland obliged him with his young wife to fly from the 



---

p.195




northern court, and he once more returned to **Cork**, where, chiefly through the Earl of Desmond's influence, having raised a few soldiers and procured vessels to transport them to England, Warbeck rashly appeared with his small troop before Exeter, and laid siege to that city; this last effort was as ineffectual as his former expedition, for the King's army obliged him to raise the siege. Exhausted by disappointments, and seeing no hope of success, he surrendered himself, and was conducted a prisoner to the Tower of London. Walters, the Mayor of **Cork**, with his son, who was Dean of **Limerick**, were arrested as traitors, and being transmitted to England, were tried at Westminster with Warbeck, in November, 1499. Walters the elder and Warbeck being found guilty were executed, and their heads spiked on London Bridge.


In consequence of the conduct of the chief magistrate, and from having so repeatedly afforded a refuge to the rebellious Warbeck, **Cork** was deprived of its charter; but the displeasure of Henry was transitory, for in August, 1500, a new charter was granted with increased privileges, and a promise of the King's forgiveness.


**Camden**, about the close of the sixteenth century, describes **Cork** as ‘a pretty town of merchandize, well peopled and much resorted to, but so beset on every side with rebels neighbouring upon it, that they are faine to keepe alwaies a set watch and ward, as if they had continual siege laid unto the city, and dare not marrie their daughters forth into the country, but make marriages one with another among themselves, whereby all the citizens are linked together, in some degree of kindred and affinity.’ Coppinger, Galway, Gold or Gould, Murrogh or Morrogh, Skiddy, Roche and Terry, were the principal families in **Cork**, and though all of the catholic persuasion continued loyal to the government of Elizabeth. This feeling was evinced by their conduct in 1570. A report, or rather a prophecy, having been generally circulated, that that year should be the last of the queen's reign, and the prediction proving false, the citizens testified their joy 



---

p.196




by ringing bells, lighting bonfires, and tilting; said to be the first public rejoicings in **Cork**.


On the death of Elizabeth in 1603, the inhabitants, like those of many English cities, were not reconciled to the accession of James the First, being averse to the government of a Scottish king. Although several Protestants, and some of English birth, opposed the authority of James, the Catholics were by far the most violent and numerous, and the affair assumed a character of religious distinction. Sarsfield, the mayor, in answer to the commands of Sir George Thornton, directing the proclamation of the king, stated, that their charter gave the citizens a right to consider if such a proceeding were adviseable, and, to a mild remonstrance on his conduct, insolently replied, that Perkin Warbeck had been proclaimed King of England in the city of **Cork**, and the consequences of that step were warfare and disaffection. A formidable party, headed by Mead, the Recorder, broke into open rebellion and committed many outrages; disarmed all the English and Protestants who would not join them; burned the bibles and common prayer books; and, during these riotous proceedings, several harmless persons were put to death. On the arrival of the Lord Deputy Mountjoy, the insurgents were divided amongst themselves. The Meads, Golds, and Murroghs, who were the popular leaders, advised the defence of the city against the Lord Deputy; but the aldermen, Terry, John and Walter Coppinger, with the families of Galway, Verdon, and Martel dissented, and on the 11th of May, 1603, **Cork** was formally surrendered to Lord Mountjoy, who entered it at the head of a large body of troops.


A variety of causes were urged in excuse of this civic revolt, of which the most plausible were, the oppressive conduct of the military, and the injury of property sustained by being obliged to receive the base money issued by Queen Elizabeth the preceding year.


Mercy was extended by the Lord Deputy to all concerned in these transactions, except the ringleaders. Lieutenant Murrough, and two others, were executed by martial law; and the Recorder (Mead) was 



---

p.197




tried, but acquitted, and died at Naples a pensioner of the King of Spain. Mead was the author of a tract, entitled, ‘An Advice to the Catholics of **Munster**, grounded on the Act of Parliament anno 2 Eliz.’ ‘a copy of which,’ says **Smith**, ‘is preserved at Oxford among the MSS. given to the Bodleyan Library by Archbishop Laud.’


In 1605 the city of **Cork**, with its liberties, were separated from the county of **Cork**, and made a distinct jurisdiction; but its improvement was retarded by two severe fires, in 1612 and 1622, which destroyed the greater part of the city. During the confusion of politics and parties in the struggle between **Charles the First** and his subjects, the citizens of **Cork** remained firm to the royal cause, and even after the situation of that monarch's affairs had become desperate, continued to oppose the parliament. Such conduct may possibly be ascribed to the example of **Sir William St. Leger, Lord President of **Munster****, whose unshaken attachment to Charles has consecrated his memory as a faithful servant and an honest man.


The resistance of **Cork**, however, before **Oliver Cromwell** was, like that of most other places in Ireland, nominal. Oliver was a sojourner of a few days within its walls, during which time he directed the church bells to be taken down and converted into battering cannon, and is said to have answered a remonstrance on the subject with the facetious remark, ‘that since gunpowder was invented by *a Priest*, he thought the best use for bells would be to promote them into *Cannons*.’ **Charles the Second** was proclaimed in **Cork** by Prince Rupert in 1649; but the inhabitants, awed by the parliamentary fleet commanded by Admiral Blake, then off the harbour, and being under a military government established by **Cromwell**, remained passive, until, instigated by **Lord Broghill**, they openly declared for the parliament.


On the cessation of hostilities in 1655, the civil government of **Cork** was re-established. Protestant magistrates were chosen, and some severe enactments made against the Roman Catholic inhabitants, who were for a time expelled the city.




---

p.198


About this period the sect called Quakers appeared in **Cork**, and there one of its most eminent members first became a convert to those opinions, which he afterwards carried into legislative effect — I speak of the illustrious **William Penn**. Curiosity induced him to visit a religious meeting where the doctrines of Quakerism were explained by **Thomas Lowe**, who expatiated with so much force on the text — ‘There is a faith that overcomes the world, and there is a faith that is overcome by the world’ as to make a proselyte of **Penn**, who constantly afterwards attended their meetings, and assumed the garb of the society. Colonel Phaire, the Governor of **Cork**, and several of the Republican soldiers in the garrison, also became converts to the same tenets.


On the 3d of September, 1667 **Penn**, being at a meeting in that city, was apprehended, with many others, and carried before the Mayor, who, observing his dress was less primitive than that of his companions, or perhaps recollecting that his father, Sir Wm. Penn, was a man of considerable power and influence both in the county and in England, would have set him at liberty upon giving bond for his future good behaviour, which **Penn** refused to do, and was committed with eighteen others to the common prison. Immediately on his commitment he wrote a manly letter to Lord Orrery, President of Minister, then at **Charleville**, who ordered his discharge, but suffered his fellow prisoners to remain until released in the due course of law.


Amongst the early religious associates of **Penn** was John Exham, distinguished by the name of the Quaker Prophet, an eccentric fanatic, originally a soldier under **Cromwell**, but who, on the appearance of Quakerism, took a leading part in the dissemination of its pacific doctrines. His enthusiasm was so great, about the time of **Penn**'s imprisonment, that he walked through the streets, his head covered with sackcloth and ashes, preaching repentance and amendment of life, for which he suffered a long and severe imprisonment; but undismayed by such usage, he took a second exercise of the same kind in **Cork**, during the year 1698, being then above seventy. 



---

p.199




At the time of his death he was upwards of ninety years of age, and persevered in the same conduct to the last.


The restless and enterprising Broghill, dissatisfied with the conduct of **Cromwell**, probably conceiving that his services were not sufficiently rewarded, became the strenuous partizan of royalty, and secretly excited the south of Ireland in favour of the Restoration of **Charles the Second**. Lord Shannon was sent to wait on the exiled King at Brussels, with a minute despatch of eight lines neatly quilted in the collar of his doublet, written by his brother, Broghill, informing his Majesty that 5000 Protestant subjects, and tried men, were assembled in and near **Cork**, ready to assist him in the recovery of his crown. The declaration of General Monk in England, to the same effect, is said to have prevented Charles from going into Ireland, where Sir Charles Coote had formed a numerous party in the north, on whose coalition with **Lord Broghill** their design was openly avowed, and **Charles the Second** was again proclaimed King at **Cork**, the 18th of May, 1660, eleven days before his restoration in England.


The trade of **Cork** and its commercial importance rapidly increased after the accession of Charles, until Ireland became involved in the contest between James II. and his son-in-law. The greater part of the inhabitants being Roman Catholics, supported the cause of James, and **Cork** was garrisoned by Irish troops in favour of that monarch. As the question at issue was one of a religious as well as political nature, the adherents of James disarmed and confined such of the citizens as were Protestants, to prevent their joining the forces of William, and the arrival of James at **Cork**, who in person was obliged to countenance these and other unconstitutional proceedings, rendered that place the scene of religious intolerance and persecution.


Notwithstanding the victory of the Boyne, **Cork** still held out for the abdicated monarch, and William found it necessary to reduce 



---

p.200




it to obedience. This undertaking was committed to the Duke of Marlborough; he arrived in Cork Harbour on the 22d September, 1690, and was received at the entrance with a few shots, and a show of resistance from a fort which was abandoned on the landing of a small party, who possessed themselves of the guns. The following day was spent in disembarking the troops, and on the 24th, the ordnance were drawn towards the city by the seamen and marines, led on by the young Duke of Grafton. Two troops of dragoons and a small body of infantry, posted a short distance out of **Cork**, immediately retreated within the walls when fired at, and the cannon were scarcely planted on Fair Hill to the north of the city, when the suburbs at that side were in a blaze, and two small forts with Shandon Castle evacuated.


On the 26th, Prince Wirtemburgh arrived at the head of 4000 Danes, and took up a position in the north of the town. General Scravinmore, who commanded the cavalry, gained the elevated ground of Gill Abbey at the south side; and, seizing the Cathedral, which commanded the old fort or citadel, posted two files of musketeers, under Lieutenant Horace Townsend, in its tower, whose fire became so galling to the fort that two guns were pointed against the church and shook its steeple considerably. Some of the men attempting to descend, Lieut. Townsend struck away the ladder by which they had mounted, thus cutting off the means of retreat, and continued with his men in the steeple until the next day, when the fort surrendered.


This instance of bravery is surpassed by the almost miraculous achievement of two sailors, in the capture of a strong redoubt on the south side of **Cork**, called ‘the Catt,’ the fire from which, and a battery not far distant in the same line, formed at the Red Abbey, effected a breach in the city walls. — A truce was granted for the night, but the offered conditions being declined, on the following morning, the 28th, a heavy fire continued to play upon the town. 



---

p.201




At noon a body of the Danes crossed the northern branch of the river, and four regiments of English under Brigadier Churchill, at the south side, waded to the East Marsh up to their chins in water, but both the detachments were retarded by the swampiness of the ground, and prevented storming the breach by a deep channel that passed down the centre of the present Grand Parade, and served as a counterscarp to the city wall. During the delay caused by these obstructions, the Duke of Grafton (natural son of **Charles II.**) was mortally wounded by a musket shot from the walls; the ball entered at the point of his shoulder, and he died in a few hours after; the place where this nobleman fell is now distinguished by the name of Grafton's Alley, a narrow passage leading from the South Mall into George's Street.


Two vessels were also moored off the city, and threw bombs into it. ‘In the midst of which puther,’ to use the expression of **Story**, Lord Tyrone beat a parley, and surrendered at mercy. The garrison consisted of 4,500 men, and amongst the prisoners of note were the Earls of Clancarty and Tyrone, and many Irish chieftains. About 1,500 of the prisoners were embarked for England, 200 of whom perished in the Breda man of war, which was blown up in Cork harbour, an event that, for the honour of human nature, it is to be hoped has falsely been attributed to the treachery of Colonel Barrett — he and his servant only escaping.


Although Ireland generally remained inactive in the cause of the Stuarts, some exertions in their favour appear to have been made at **Cork**.


In 1722, Captain Henry Ward and three others were hanged there for raising men for the service of the Pretender, and William Roe was pilloried for repeating the seditious sentence, ‘May King James III. enjoy his own again!’ The pillory was again the award of treasonable expressions in 1746. The Cork post-boy, who to the inquiry — ‘What news?’ replied, ‘Good news, the Pretender is 



---

p.202




crowned in Scotland;’ and a man named Coughlan, accused of toasting the health of Lord Clare, then an officer in the French service, suffered that punishment, and during the ten following years four or five men were executed for enlisting soldiers for the French King; but with these individual exceptions **Cork** appears to have been well affected towards the Hanoverian succession.


The ancient trade of **Cork** was very limited, and entirely confined to England and the ports in the Bay of Biscay — the principal import was wine from France and Spain, and in return it exported staves, hides, fish, skins, and wool. All the traffic was carried on in foreign bottoms; for **Cork**, in the reign of Elizabeth, only possessed a few fishing barks, nor were there warehouses established for the reception of merchandize, and every trader therefore brought his goods at his own risk and disposed of them in the best manner he could from on board his vessel.


Foreign vessels were received in a canal which flowed nearly where the present Castle Street stands, and were enclosed, by means of a portcullis, between the Queen's Castle and the King's Castle, on the site of which are built the present Corn Market and Exchange. Descriptive of this locality the city arms is a ship between two castles, with the motto, ‘Statio bene fida carinis.’


In the year 1634, at a period when the trade began to increase, only nine small vessels arrived with wine from Bourdeaux and St. Maloes, which together did not import more than 100 tons, out of which 10 tons were paid in duty. The preceding year a speculation of exporting some corn and butter to Spain was attended with so much success, as to induce the traders to barrel up their beef and butter, in imitation of the English manner, and brand it with the Bristol mark, B. C. which found good markets, and proved highly advantageous to the shippers; but the political events of 1641 were inimical to commercial prosperity, and the subsequent transactions destroyed every vestige of industry.




---

p.203


On the restoration of tranquillity under William III. **Cork** soon recovered from the effects of domestic warfare. The trade with the American and West Indian colonies created a demand for provisions highly beneficial to the place, and contracts were formed for supplies both with the merchant service and the government, which afforded employment to a vast number of persons and circulated large sums of money in the country. Although the most eminent contractors suspended payment more than once, and produced serious temporary embarrassments, yet such was the spirit of enterprise, that after each stoppage, business seemed to be carried on with renewed energy. The third failure of Mr. Paul Benson (whose crest was a rainbow) occasioned a satirical epigram by **Dr. De la Cour**, which is perhaps worth repeating, as it is not to be found in any printed edition of his poems. 


> 1. How like thy crest was once thy power,
>   
> Thou shone the rainbow of the hour,
>   
> What Christ to Paul said — Cork may say to thee,
>   
> Paul, Paul, why persecutes! thou me?
> 




Considerable fortunes, however, have been amassed during the late war by some speculative individuals, with much credit to themselves and advantage to the place. The convenience of Cork harbour in time of war rendered it the rendezvous where all vessels trading with the new world assembled for convoy, and the victualling of such fleets alone created an extensive consumption for its staple commodities — few cities therefore felt the transition to peace more severely, being without manufactures, and solely dependent on trade for the support of its inhabitants.


The failure of several banking and commercial houses produced a depression of credit, and checked the means by which **Cork** had attained its commercial eminence. Vacant stores and untenanted houses are melancholy proofs of the declension of its prosperity; 



---

p.204




and to those who remember what that city was previous to 1815, its present appearance is extremely cheerless — this gloomy effect, it is to be hoped, may prove of a temporary nature, and confidence and prosperity be again restored without the renewal of hostilities.


In estimating the present rank which **Cork** is entitled to hold from other causes than its commercial celebrity, the names of Barry, Butts, and Grogan[24](javascript:footNote('E820000-001/note024.html')) are marshalled in conjunction with reference to the Fine Arts. What local credit these names reflect, I have never been able to discover. It is true that city was the birth-place of the two former, and the residence of the latter, where he lingered through a laborious professional existence without patronage or encouragement. Barry, it will be recollected, left **Cork** when a boy, and never returned to it. His genius developed itself in Italy, assisted by directions from Edmund Burke, the works of the old masters having roused his expansive but uncouth mind into a ferocious rivalship; and his surly reply, when reminded of his birthplace, was — ‘Cork gave me breath, 'tis true, but it never would have given me bread.’ Jonathan Butts, less known than Barry, painted compositions of landscape and ruins, something in the manner of Claude, with a rich and flowing pencil, and, emigrating to **Dublin**


---

p.205




as a scene-painter to the theatre, earned for many years an itinerant subsistence. It is, therefore, an injudicious and idle boast to revert to the past.


The exertions of some amateurs produced, in 1815, a small exhibition of their own works, jointly with those of the few resident artists, which, perhaps, on account of its novelty, was well attended, and led to the formation of a society for the promotion of the fine arts. Circumstances having placed the management in unqualified and indolent hands, exhibitions were, for two or three seasons produced, so worthless as rather to offend than attract the public. A small subscription had been raised towards its support, sufficient to keep it in existence; but the society has gradually sunk into insignificance, notwithstanding some laudable exertions in its behalf by Lord Listowell, who was chiefly instrumental in obtaining from the King the presentation of a good collection of plaster casts.


The state of literature in **Cork** is certainly more promising than that of the arts; and there is, if not a profound spirit of research, at least a general love of reading. The **Cork** Library, the earliest literary institution, founded in 1790, is a truly valuable and well-regulated establishment. It is supported by the small annual subscription of one guinea from each member, and the collection of books on subjects of popular interest is extensive and admirably selected.


The Institution derives its chief support from an annual parliamentary grant, and was founded by charter in 1807. From the individual exertions of the Rev. Mr. Hincks it may be said to have emanated, and that it has conferred important benefits on the south of Ireland is evident; but at present, like many other chartered bodies, a lethargic, or rather an illiberal party-spirit seems to have benumbed the inclination to be of public service.


Three or four professors are attached to the Institution, each of whom delivers an annual course of lectures on various branches of 



---

p.206




natural history, chemistry, and agriculture, which being fashionable are numerously attended by the ladies. Its library also contains an excellent collection of scientific works; and the Museum (the only one in the city) possesses some minerals, and efforts have been made towards a geological arrangement of the specimens. In other branches of natural history the Museum is extremely defective, and its antiquities undeserving any notice. Several literary and scientific societies have recently sprung up in **Cork**, which have been spiritedly supported by young men whose abilities promise to excite a revolution favourable to the advancement of literature.




---

p.207


Cork Harbour
------------



> 1. Within a long recess there lies a bay.
>   
> An island shades it from the rolling sea,
>   
> And forms a Port secure for ships to ride,
>   
> Broke by the jutting land on either side.
>   
> In double streams the briny waters glide
>   
> Between two rows of rocks. A sylvan scene
>   
> Appears above, and groves for ever green.
> 

 
Dryden's Virgil. *The Aeneid of Virgil translated by John Dryden, Book 1*


Cork Harbour is considered one of the best and most frequented ports in Ireland; its mouth is narrow, probably not more than half a mile from side to side, and is commanded by two forts named Camden and Carlisle, passing which the view opens on a magnificent expanse of water resembling a bay.


[25](javascript:footNote('E820000-001/note025.html')) Spike Island, on which extensive and regular works have lately been erected, is considered its principal defence; and lies between 



---

p.208




the entrance and the town of **Cove**, seated on an island anciently called Barrymore, but now the Great Island, which extends four miles in length, and forms the north shore of the harbour. **Cove** is built on a hill, and the houses rising one above another produce an imposing appearance; the effect in gliding past it towards **Cork** is prepossessing, but a closer examination does not justify any agreeable expectations, and a distant view will be found the most satisfactory. Derrick, in one of his letters, written nearly seventy years since, mentions the same apparent cleanliness when seen from the water, adding, that it was true hypocrisy, for within the houses were very dirty. A church with a pretty spire has been lately built in the town, and this, with a good market-place and a fine quay, are great improvements to the place.


The old parish church is named Clonmell and stands about a mile from **Cove**. Here Tobin, the dramatic writer whose comedy of the Honeymoon has long been a favourite on the British stage, lies buried; having died in the harbour on his passage to the West Indies.


From the hill above the town of **Cove**, the prospect on a clear and sunny day is extremely beautiful and animated. A sheet of water, whose extent appears capable of receiving the entire naval force of England, specked as it always is with some ships of war, and many merchant vessels at their moorings, is enlivened by the graceful movements of numerous pleasure-boats and hookers, and studded with islands of various forms and colour. Behind these to the south-west is seen the main-land of Ringaskiddy, and to the east lies Rostellan, the mansion of the Marquis of Thomond, with many other beautiful seats.


A small fort was built on Haulbowline Island, (now the depôt of naval and ordnance stores, and situated north-west of Spike,) by order of the Lord Deputy Mountjoy, in 1601, for the defence of the river, which, with a noble sweep between a point of the Great 



---

p.209




Island and Haulbowline, proceeds to Passage, five miles distant from **Cork**, a town where merchant vessels of burthen are obliged to unload, and from whence their cargoes are conveyed in smaller craft to the city. On this reach of the river lies the quiet village of **Monkstown** with its castle, built by the Archdeacon family in 1638, and now converted into a barrack. A row of good houses upon the beach, are backed by a rich plantation, which stretches along the shore towards Ballybricken, the delightful residence of Mr. Connor, nearly opposite Haulbowline.


The Barony of Kerricurrichy forms the western side of the harbour, and opposes its rocky southern coast to the sea. Its principal village is **Carrigaline**, which tradition states the first **Earl of **Cork**** intended should rival **Cork** in commerce, and had actually proceeded so far in his gigantic undertaking as to have marked out the groundplan of an extensive city; but the scheme, which originated in the comparative distance of their situations from the sea, ended with the life of its projector.


The **Carrigaline** river is called Annabuoy or Avonbuoy, in English signifying the Yellow River, from the colour of its waters, to which the floods caused by heavy rains give a muddy yellow tinge. Although of a considerable breadth, it is easily forded in two or three places at low water, and is not navigable any great distance except by small boats, though within its mouth, which more resembles and is sometimes called a creek, there is good anchorage for vessels of considerable burthen; and it is related that five ships of war under the command of Sir Francis Drake, being closely pursued by the Spanish fleet, ran up this river a short way to a part named Tubberavoid (the well of safe anchorage), since called Drake's Pool, where the little squadron lay land-locked and completely concealed from their pursuers, who, sailing into Cork Harbour without discovering their prey, gave up the chase.


The Castle of Carrigaline is seated on an immense mass of limestone 



---

p.210




rock commanding the principal ford of this river about four miles from its mouth; its present appearance is nothing more than the ruined and ivy-covered walls of two inconsiderable buildings resembling the wings of an old house, which, I should suppose, were formerly united and inclosed by an embattled wall. There is nothing interesting, that I am aware of, connected with this Castle, although at one period, in the reign of Elizabeth, it must have been considered of importance, being termed ‘impregnable.’ As it stands rather high, and the surrounding country is flat, it is visible in many situations at the distance of two or three miles, and in some points of view assumes a picturesque character, which is lost on a nearer approach.


The fishing village of **Crosshaven** lies at the mouth of the river, nearly facing the town of **Cove**, and sheltered by a large hill called Currabinnagh, that rises from the opposite shore, crested with a rude cairn.


The most extensive demesne in this district is **Coolmore**, the residence of Mr. Newenham, which contains above 500 acres.


The Hodder and Daunt families are the principal landed proprietors, and have several seats, the best of which are Hoddersfield and Ringabella, belonging to the former, and Gurtegreennan and Myrtleville to the latter: the ground, in general, is extremely barren and requires much labour and expense to cultivate. A farm not far from Hoddersfield was described to me by its proprietor as ‘the back bone of the world picked by the devil,’ on account of the inveterate obduracy of the soil. The **Carrigaline** road to **Monkstown** leads through a romantic defile called **Glenathauwk**, or the Hawk's Glen, and the return to Passage is over a steep hill named the Giant's Stairs, derived from twelve or fourteen projecting rocks, rising one above the other like a flight of steps, with a rude and ponderous air of regularity resembling a Druidical work.


The town of Passage, which possesses little to detain the visitor, is 



---

p.211




much frequented, in consequence of a ferry to the Great Island, as it is the only regular one established on the river.


**Douglas**, a village mid-way between **Passage** and **Cork**, is surrounded by many fine seats, the largest of which is **Maryborough**, containing nearly 400 acres. These houses are generally judiciously placed as to prospect, but seldom possess much ground. ‘This will not be deemed extraordinary,’ says Mr. Townsend in his Statistical History of Cork, ‘when it is considered that any thing of good demesne land in this quarter brings from eight to ten pounds per acre. A price so far exceeding the actual value of farm land arises for the great demand for villas amongst the opulent inhabitants of **Cork**.’


The hills on each side of the river afford so many inviting situations that they are now literally studded with villas encompassed by ten or twenty acres each.


On the road side between **Passage** and **Douglas** is Ronaynes Court, the residence of Alderman Evanson, an old mansion, and easily recognised as such by its lofty chimneys and numerous gable-ends. A large stone chimney-piece in one of the rooms bears the following inscription: 

‘Morris Roulan and Margaret Gould builded this house in the yeare of our Lorde
  

1627, and in the third yeare of Kinge Charles M R Love God and neighbours IHS M G’


**Blackrock** is amongst the most beautiful outlets of **Cork**. It is a little peninsula thickly covered with the houses and neat cottages of the gentry and traders. The Castle of Blackrock, about three English miles from **Cork**, was built in the early part of the reign of James I. by the Lord Deputy Mountjoy, for the defence of the river which washes its base; it was a single circular tower, and in 1722 the corporation added some buildings and placed an octagon room and cupola on it. Here the mayors held an Admiralty Court, 



---

p.212




being appointed by several charters Admirals of the Harbour, a right which they annually assert on the first of August, when the mayor and corporation sail to the entrance of the harbour, and perform the ceremony of throwing a dart into the sea, as a testimony of their jurisdiction. On the authority of the city council book, **Dr. Smith** mentions that, in 1627, the question of the Mayor of Cork being Admiral of the Harbour was contested with the corporation by Edward Champion, for the Lord Barry.


Thirty years since, **Blackrock** contained only the cottages of a few revenue officers, and the huts of some fishers and boatmen. The only buildings with any claims to antiquity beside its Castle, being an ivy-mantled tower in Mr. Murphy's grounds, called Ring Mahon, and Dundanion Castle, about half a mile nearer **Cork** than that of **Blackrock**, which has the appearance of an old mansion, and is laid down on the plan of **Cork** given in the Pacata Hibernia as ‘Galwaies Castell,’ being probably a seat of that family. The neighbouring houses are modern, and many of them possess an air of neatness and comfort, nearly approaching those of the English merchants. Having the advantage of sea-bathing on the verge of their gardens, they are extremely pleasant and healthy, and hence the place has now become populous. Near Blackrock Castle is Castle Mahon, the residence of Lady Chatterton, beautifully placed, and which it would be ungrateful to pass without the acknowledgment of having spent many of my happiest hours there.


Lakelands, the seat of Mr. Crawford, and Beaumont, that of Mr. Beamish, are the most extensive demesnes at Blackrock.


About half way between **Cork** and its Castle lies the village of **Ballintemple**, (in English, Church Town,) and adjacent to it is a little burial ground, from which it has probably originally been named. The situation of this cemetery is retired and romantic, and the few tombstones that rise above the large dock leaves and nettles with which it is overgrown, record the names of such villagers as have 



---

p.213




died in more opulent circumstances than their neighbours. The remains of the humble farmer and the poor fisherman occupy this secluded spot, with the exception of one grave, containing a pair whose melancholy fate and early death throw an interest over the simple tablet that marks their abode, and on which is inscribed, 

  

‘Lieut. Henry Richard Temple,
  

Son of
  

Lieut.-Col. Henry Richard Temple,
  

Died August 16th 1799,
  

Aged 22.’ 

The simplicity of this tomb, when contrasted with the uncouth and sometimes grotesque orthography of those which surround it, naturally excites a degree of curiosity, and a wish to become acquainted with some particulars respecting this youth. Residing very near this cemetery, it was my frequent custom to stroll amidst its humble mounds, and to clear away the weeds from this tomb, in which occupation I was one evening accosted by an elderly woman, a resident of many years in the adjoining village, who, after looking at me very earnestly, exclaimed — ‘Ah! I see your honour bears a respect to the young strangers' grave; and I never pass it myself without a look and a sigh; for I'll never forget the noble looking gentleman their father, standing where you do now, Sir, and gazing on the earth as though his heart would break. 'Twas he caused that stone to be placed at their head.’ On expressing a wish to hear more of their story, the old woman continued: ‘It may be about twenty years ago, Sir, that a West India ship arrived in our harbour, and a young man, who was an officer, came passenger in her; he was in a bad state of health, and was closely attended by a sweet young lady, a Creole, who was his wife. A rough and tedious passage had increased his illness so much, that he determined to remain on shore 



---

p.214




whilst the ship waited in harbour for some repairs, which would enable her to proceed more safely to her destination.’


‘As the ship lay some miles down the river, he was rowed up in one of her boats towards the city, that he might have medical advice and such attendance as he required, but being pleased with the appearance of our village from the water, resolved on stopping here. He remained at **Blackrock** about a week; his health, instead of improving, every day became worse and worse, and oh, Sir, it would be impossible to tell how tenderly the poor young lady nursed him, and how she watched by his bed-side day and night; but it was all in vain; he was so exhausted from the effects of the fever which he had in the West Indies, that he died on the eighth day after his landing.’


‘The dear lady sunk under her affliction; his loss, her destitute situation, alone and in a foreign land, added to the fatigue of her constant attendance on him, altogether so preyed on her that in two days she was a corpse by his side; and the black servant, who had come over with them, seeing how things were, packed up every article, even their very clothes, and went off on board ship the same night.’


‘The bodies of this poor young couple were put in two common deal coffins, and buried in one grave, and the expenses of their wake and funeral paid by a subscription made amongst the inhabitants. None of us could tell their name nor who were their friends, for the black servant had carried off every thing, (God forgive him!) and every paper belonging to them. The affair was talked of for a month or two after, but the fate of these young people, like most other things, was forgotten in a short time.’


‘It was two or three years after their death, that an elderly gentleman one morning knocked at my door, asking if this was not the village of **Ballintemple**. On my answering that it was, he inquired if I knew any thing respecting a young officer who had died here; 



---

p.215




when I repeated just what I have told you, Sir. Poor gentleman! he seemed deeply affected, and begged of me to point out to him the spot where his son lay. We walked towards the burial ground without exchanging one word, and when I showed him the grave, he stood for a long, long time, silently, and I think unconsciously, gazing upon it, for I came away without his perceiving me. I saw no more of this gentleman, nor have I since heard any person even speak of him; but soon after his visit I observed the small stone, that had been put up, I suppose, by his orders.’


The delicacy which had induced this untutored old woman to refrain from intrusion on the father's melancholy duty would have pleaded her excuse for the minuteness of her narrative, had not my age at that time rendered one unnecessary; and should the reader require an apology for the relation, I can only refer him to the feelings of his boyish days.


A large portion of the ground at **Blackrock** being held under a precarious ecclesiastical tenure, has no doubt prevented its improvement. The total want of places of worship for a district so numerously inhabited is very striking, there being neither church nor chapel, until within a few months, when, through the exertions of Doctor Murphy, the Titular Bishop of Cork, a Roman Catholic chapel was erected.


Adjoining the Blackrock road, in a field about a mile from **Cork**, amethysts have been found, but of an inferior quality to those procured in foreign countries. The quarry was discovered more than twenty years since, and after being worked for a short time the question of proprietorship got into Chancery, where it still remains.


Many tons of earth were thrown over the excavations which had been made, and a guard placed to prevent farther search; but notwithstanding these precautions, I have seen some good crystals recently picked up there.


It is the opinion of those more conversant than myself with geology, 



---

p.216




that a few months further work would have completely exhausted this amethystine mine, as from its situation it cannot be extensive.


Many curious anecdotes are told relating to its first discovery, which of course created what may be termed a sensation in **Cork**, and induced some of the jewellers to speculate largely in the purchase of amethysts. One of these stories partakes so much of the spirit of waggery ever superabundant in **Cork**, that I cannot resist its insertion. A lump of sugar-candy was procured by two or three of those mortals who are fond of enjoying a laugh at the expense of others, and carefully bedaubed with clay, through which the delicate glistening points of its crystals projected. This, being placed in the hands of a boy well instructed in his part, was offered for sale to a lapidary, who had, for some days previous, eagerly bought up every amethyst brought into his shop. ‘Some of them find purple stones,’ said the boy, with an air of simplicity, ‘but here is a yellow stone, and I'll not sell it under a guinea.’ The bargain was soon struck, the money paid, and the lapidary, imagining he had obtained a fine topaz, and rejoicing in his good fortune, hastened to throw it into a basin of water to soften the clay which concealed its lustre. His astonishment and dismay were somewhat great on finding the gem dissolved, and the muddy water delicately sweetened! — but all was not lost — he received an invitation that evening to a supper provided with his guinea, and on the entrance of a bowl of punch was asked if he did not usually sweeten it with ‘syrop of topaz.’ Finding the laugh against him, he had no resource but to join in it with the best grace he could.


The beauty of Cork Harbour renders it an exceedingly attractive excursion for strangers, and one no less agreeable than easy in its performance, as steam-vessels, for the accommodation of passengers, ply between **Cork** and **Cove**.


Rising immediately from the northern shore of the river, below **Cork**, a richly wooded hill extends about three miles, studded with 



---

p.217




elegant mansions and villas; and at the head of a romantic valley that interrupts its continuance, the village of **Glenmire** is situated, on a small river of the same name which flows through this picturesque defile.


The probable derivation of the name **Glenmire** appears to be from two Irish words signifying the Vale of Pleasantry, although **Dr. O'Brien** in his Irish Dictionary has drawn it from a less obvious source. The village of **Riverstown**, formerly called Bally rosheen, or the Town of the Little Rose, joins that of **Glenmire**, and is principally inhabited by poor weavers and other manufacturers.


A severe skirmish took place here, on the 16th January, 1716, occasioned by a mutiny amongst the garrison of **Cork**, who left their barracks and encamped on the north side of the city for a few days, whence they proceeded to **Glenmire**, where they took up a position. On being attacked by some troops with two field-pieces that had arrived in the harbour the same morning, the mutineers, headed by a Dutchman named Garvy, made a desperate stand near the bridge, and their supply of ball cartridge failing, they made use of their buttons as a substitute for bullets, but were obliged at last to give way, and retreated in disorder. Garvy was afterwards tried and shot, with two others of the ringleaders. Numerous relics of this action were ploughed up in 1807, of which I remember having seen a rusty halberd and several grapeshot.


**Glenmire** with its surrounding scenery affords many pleasing subjects for the pencil, which, although excellent studies, are without any important or peculiar feature. The old parish church, about a mile distant from the village, is called **Rathcooney**, or the Rabbit's Rath, probably from the number of raths or intrenchments to be seen in its neighbourhood. This church is in ruins and has been long disused for service, yet the little burial-ground attached to it continues to be a favourite place of interment.


The oldest date I could find amongst the tombs was 1680, on the 



---

p.218




Galway vault; but the following inscription appeared worth transcribing for the enigmatical account of a blind man, respecting whom I am unable to gain any further information. 

  

‘IHS
  

Erect*e*d by Jn[ordm ] M*a*c Nemara
  

Silk & his brothers for
  

a memor*ia*l of their burial
  

place. Their parents are 
  

entard here & their Uncle
  

Cornel*iu*s M*a*c Nemara Silk
  

the most wonderful blind
  

man, work*e*d at his trade
  

40 y*ea*rs; being bles*se*d with
  

sight thow perfect blind.
  

God be mercifull to all
  

their souls.’


A small volume, purporting to be a picturesque description of **Glenmire**, was published at **Cork** in 1814, by a singular personage named Alexander, and is perhaps the most extraordinary literary compound in existence. This person, who is since dead, held some inferior situation under the excise, which had been bestowed on him as a reward for his conduct as Town Major of **New Ross** in the rebellion of 1798. He had been, as he once told me, a soldier and a sailor, a methodist preacher and a player, an excise officer and the author of many excellent and moral works — had been in the four quarters of the globe, and was the esteemed and acknowledged cousin-german of Sir W. S—, Bart, and Lord Mayor of the city of **Dublin**.


The **Little Island** or **Lisle**, so called in opposition to the **Great Island** or **Barrymore**, is situated below **Glenmire**, and forms, with the **Great Island**, the north-east shore of the **Cork** river. Behind these islands, which are separated from the main land by a shallow and scarcely navigable channel, lie **Carrigtohill**, an inconsiderable 



---

p.219




village, and **Middleton**, a poor town of one street about a quarter of a mile in length. Beyond these, on the eastern side of the harbour, is **Castle Martyr**, a neat and rather picturesque village, apparently thriving without manufactures; every house and person in the place wore a cleanly and happy appearance, which may be justly ascribed to the residence of **Lord Shannon**, whose extensive pleasure grounds and gardens are objects of much local celebrity.


On the 16th October, 1679, **Lord Broghill** (then Earl of Orrery), so frequently mentioned in this volume, died at **Castle Martyr**: I am induced to mention the circumstance from having procured accidentally some singular verses on his death, with other old papers, at a cottage in this neighbourhood. These verses were printed in London, for Rowland Reynolds, at the Middle Exchange in the Strand, 1680, and are entitled Minerva's Check to the Author, for attempting to write an Elegy upon the Right Honourable and much to be lamented Roger, first Earl of Orrery. A few lines will probably be quite sufficient to satisfy the reader's curiosity: 



> 1. That news hath wings, we every day do find,
>   
> And ill doth ever leave the best behind;
>   
> Admire not then the death of Orrery,
>   
> Renown'd all 's days, should in a moment flie
>   
> Both far and near, the world to terrific,
>   
> At **Cork**, at **Dublin**, **London**, and at **Paris**
>   
> Too soon 't arrives, and **Rome**, but there ne'er tarries,
>   
> Till at both Indies, or where e'er more far is.
> * His care to breed brave horses thou wouldst write,
>   
> In peace for pleasure, and in war for fight:
>   
> Thou fain wouldst talk on 's victory at Knockny Clarshy,
>   
> And praise him (next to God) the God-a-mercy.
> + His sacred Poems, now but in the press,
>   
> Will speak his noble praise in fairer dress.
> 






---

p.220


Manners and customs
-------------------



> 1. A hardy race, inured to toil,
>   
> But proud of heart, impatient of offence,
>   
> With passions strong, and bold, and full of fire,
>   
> Yet kind in speech, and to the stranger's call
>   
> Their doors are never closed.
> 

 
Anonymous.


From the relative situation of the northern and eastern parts of Ireland to Scotland and Wales, it is evident, even were history and tradition silent on the subject, that these districts became the first settlements of adventurers from the shores of Britain. The original inhabitants gradually retired, as the invaders, either by conquest or treaty, extended their dominion, which was distinguished by a line of demarcation called the Pale: and all who remained without the Pale were excluded from the protection of the English laws. The project of confining the native Irish within the province of **Connaught**, by the boundary of the Shannon, has been ascribed to **Cromwell**, and hence the phrase but too well remembered in Ireland ‘To Hell, or **Connaught** with the rebel!’




---

p.221


The southern and western counties are, therefore, unquestionably those in which, at present, national peculiarities should be sought, and where primitive manners have been least affected by foreign innovation, although the intercourse between the south of Ireland and Spain appears to have been extensive from the earliest period to the close of the sixteenth century. Both the fanciful eye of the antiquary and the more sober one of the agricultural tourist have observed the Spanish contour of feature in the peasantry of **Kerry**, and, indeed, it is impossible not to be struck with the resemblance; but the discussion of the colonization of remote ages does not fall within the object of this chapter, which is rather an attempt to detail such customs amongst the Irish peasantry as will appear most striking to the English reader, and to illustrate them with any occasional anecdotes they may suggest. The difference of costume and personal appearance in the lower orders of different districts can scarcely fail of being remarked, and the inhabitants of one barony are easily distinguished, by their peculiar dress, from those of another. On the border of the counties **Cork** and **Limerick**, the women are generally short and plump figures; the men well-proportioned, tall and rather handsome. In some of the southern parts of **Cork** and **Kerry** the very reverse is the case; and, in the latter county, the race of small and hardy mountaineers, with light hair, gray eyes and florid complexion, added to a circular form of countenance, are strangely contrasted with the tall, spare persons of the Spanish race, if I may so term them, with sallow visage, dark, sunken eye, and jet-black hair, falling loosely over their shoulders; wearing the great-coat in the fashion of a mantle, fastened by one button under the chin, and its sleeves hanging down unoccupied by the arms.


In the county **Limerick**, the men's dress is invariably of a gray (or pepper and salt colour) produced by a mixture of black and white wool without any process of dying. In the eastern parts of the 



---

p.222




county **Cork**, dark blue is the predominant colour; whilst, in the western parts and in the county **Kerry**, light or powder blue is almost universally worn. The same peculiarity, but in a less degree, extends to female dress. In the eastern baronies of the county **Cork** and county **Limerick**, cloaks of the brightest red are seen. In the west of **Cork** and **Kerry**, dark blue and gray prevail. Previous to the rebellion of 1798, the former colour was more commonly worn than it has been since, and about that period red became generally disused. A contemptuous expression of the English soldiers at that time, after any contest, was ‘now a woman seen at a distance in her scarlet cloak would strike a panic throughout the whole country.’


The cloak is a part of dress apparently never superfluous to an Irish woman, and is constantly used with the hood over the head, even during the hottest days of summer; those who are not so fortunate as to possess a cloak turn the skirt of their gown or an apron over their shoulders, and in this *huddled* style proceed about their out-door occupations with as little alacrity as might be expected. A brown stuff gown and green petticoat is the popular costume, with stockings of the brightest blue, but these latter are by no means an indispensable part of dress, and, truth to say, are not often seen; neither are shoes considered of any importance, but rather a fatiguing incumbrance, gladly dismissed when opportunity offers, and scarcely ever worn but on the Sabbath and other holidays. Journies are invariably performed barefooted, the shoes and stockings tied together and thrown across the arm. There is, however, a strong desire to possess a pair of silver buckles or a silver clasp for the cloak, such ornaments being considered as marks of consequence, and they are handed down from mother to daughter with the greatest care. Bonnets are quite unknown, the hood of the cloak answering all demands for the head, which is, however, sometimes adorned by a high cauled mob cap. The fodaheen, or little 



---

p.223




hood, is also a favourite head-dress, more particularly with those advanced in life, and is formed by a handkerchief carefully folded round the head and tied in a knot under the chin.


The custom of greeting with a benediction has been practised in Ireland from time immemorial. It is perhaps of eastern origin. (**General Vallancey** would certainly have derived it from thence.) Persons on a journey are saluted with various and peculiar phrases, appropriate to the time of day, the nature of the road they are pursuing, or other circumstances. Early in the morning, or on the approach of night, you hear such as ‘God speed you,’ ‘God and the Blessed Virgin attend you,’ ‘The blessed Patrick go with you,’ &c.; but if the traveller has to apprehend danger on his route, the expressions are more energetic, as ‘Safe home to you by the help of God,’ ‘God guide and protect you, and lead you in safety to your own home, with the blessing of all the Saints.’


The maledictions of the peasantry are very powerful, and embrace a climax of evils, gradually ascending to the most dreadful imprecations, from ‘May the grass grow upon the threshold of your dwelling,’ or ‘May you stand friendless and alone in this world.’ Their exclamations and apostrophes are singular and figurative, often poetical, and sometimes touching on the sublime. An Irish appeal is ever made to the feelings, not to the judgment, and the passions are assailed by a burst of thought that, 

*Like unexpected light, surprises.’’*

Lesbia Hath a Beaming Eye to the melody of 'Nora Creina'


An instance of the effect produced by one of these vigorous exclamations occurred in an affair at a place called **Ballyhacket**, where some men were attacked by a party of police, sent to deprive them of a farm of which they were keeping forcible and illegal possession. On their trial at **Limerick**, it appeared in evidence that 



---

p.224




the resistance was chiefly owing to the interference of a woman, who, perceiving the advance of the peace-officers and military, ran towards her husband and his brothers, ‘shouting out,’ said the witness ‘Ballyhacket for ever, with the blue sky over it!’ Thus calling forcibly into their minds the gloomy contrast of imprisonment, and sweeping, with a wild and rapid touch, the strings of freedom that master-chord of an Irish heart!


There is something remarkable in the ideas of freedom and independence vaguely floating in the mind of an Irish peasant; they seem only inferior to his pride, which exists in a degree wholly irreconcilable with his condition; a thousand evils are the result. ‘I would, since your honour bids me, but that I scorn to demean myself,’ is a reply proof against any argument that reason or propriety can suggest — **Bishop Berkeley** has mentioned a kitchen wench in his family who refused to carry out cinders, because she was descended from the ancient kings of Ireland; and it would be ludicrous, were it not melancholy, to observe the consequence derived from this ‘pride of ancestr.’. The usual language of condolence on a change of fortune is ‘He, whose father was a real and undoubted gentleman, and whose mother was born and bred a gentlewoman, aye, and her mother before her.’ Every person therefore in Ireland is a gentleman, or was a gentleman, or is related to a gentleman;[26](javascript:footNote('E820000-001/note026.html')) and hence unfortunately arises a self-conviction that they are privileged to the enjoyment of ‘otium cum dignitate,’ and that their ancestors having formerly possessed estates, they are therefore entitled to them. Commenting on this visionary importance, the writer of a memoir of Lord Ormond acutely remarks; ‘it may well deserve the diligence of politicians, to inquire whether the 



---

p.225




remembrance of high birth and remains of hereditary honours, unsupported by wealth and power, have not been more frequently incentives of daring wickedness, than motives of heroic actions, and whether more have not endeavoured to restore the dignities of their families, by shaking the government of their country, than by studying its interest or promoting its welfare.’


Poor, proud and sensitive, the Irish character is one to excite our pity, were not those feelings in some measure deadened by the counteraction of others, and yet, no doubt can be entertained of their innate existence. In communicating with the peasantry, every account given by them is in a strain of hyperbole; I have heard the resident of a mud cabin speak with perfect assurance of his ‘*drawingroom*’ — an apartment in the roof, to which he ascended by means of a ladder; and the foot-way through his half acre of cabbage garden, has become the ‘*road through his farm.*’ As a fair specimen of what Mr. Bush not unaptly terms ‘Hibernian importance,’ perhaps I may be excused for the introduction of the well known answer, ‘*Timber and fruit,*’ given from a coasting-vessel freighted with birch-brooms and potatoes, when hailed by a revenue cruizer off Cork Harbour to ascertain her cargo.


The letter of a village piper requesting payment for his professional exertions at some little fête given by the lady of the manor, is a curiosity in its way, and I can vouch for its genuineness, being acquainted with the parties. 


> To the Hon. Mrs. B — .
> Madam,
> 
> 
> The Bearer hereof is the piper that played for your Lordable family at the Terrace on the 12th inst., and I am referred to your Honour for my hire. Your Ladyship's pardon for my boldness would be almost a sufficient compensation for my labour.
> 
> 
> Patrick Walsh.






---

p.226


It is to be hoped the ideal consequence which this strain of hyperbole produces may lighten at least the mental wretchedness of the Irish labourer's condition; for to whatever causes the present abject state of the peasantry has been ascribed, no one can doubt the fact; nor can it be more effectively pictured, than in the account given me by one of those speculative wanderers who annually migrate to England in search of harvest work.


My informant had travelled from near **Limerick** to Dublin, on foot, with another young man; they had saved up twelve shillings and sixpence for their travelling expenses, and he and his companion had paid 2s. 6d. each for their passage from **Dublin** to Liverpool, and would have double that sum to pay on returning. Some, he told me, made money by coming to England — others did not — for his own part, he had been better than a week in the strange country, and had only got one day's work, for which he received two shillings. ‘I am,’ said he, ‘a bachelor, but married men also come over to make the harvest. In my own country I should have at this time (Midsummer), if I could get work, ten-pence or a shilling a-day, besides my *bit and sup* (potatoes and milk); but, indeed, your honour, I looked to better myself by seeking my fortune this side the water — the times are so bad at home, although I have no wife — and the people, God help them, so poverty struck. When a married man comes over,’ (he replied to my interrogatory,) ‘he leaves his wife and family enough of the potatoes to last them during his absence, and lets them get the kitchen (that's any relish, your honour, in the shape of a herring or so) the best way they can. Should their stock of potatoes not last till his return, the wife and children have just to shut up their bit of a cabin and go about the country begging for God's sake.’


The average annual rent of a cabin may be about forty shillings, or, with a patch of ground, perhaps fifty shillings. These hovels have been already described; yet miserable and destitute of comfort as they are, the benighted peasant or houseless mendicant, who raises 



---

p.227




the latch with the benediction, ‘God save all here!’ is confident of receiving shelter and every rite of hospitality as far as it is in the power of the inmates to bestow them. He is welcomed to the best seat the cabin affords, the largest potatoe is selected from the dish and placed before him, and that ‘reserve towards strangers which alike characterize the Englishman and his mastiff,’ is unknown. This hospitality is not confined solely to the cottage, but seems a national trait, which those who have visited the country, whatever may be their condition, are bound in gratitude to acknowledge. **Smith**, in his History of Cork, tells us of a stone which was formerly set up on the west side of the high road near **Dunusky**, *(Dunisky)* not far from **Macroom**, bearing an inscription in Irish, desiring all travellers to repair to the house of Mr. Edmund Mac Swiney for entertainment. ‘This stone,’ adds **Dr. Smith**, ‘now lies in a ditch, and the Irish say that the person of this family who overthrew it, never throve after.’ A later period has witnessed the hospitality of Mr. Mathews, at **Thomastown**, in the county of **Tipperary**, a gentleman of moderate fortune, who constructed a mansion and maintained an establishment for the reception of forty guests; to whom, no doubt, the prolonged visit of **Dean Swift**, in company with Dr. Sheridan, is remembered.


Intemperance is the result of indiscriminate hospitality, and it has too frequently happened, that the tranquil comforts of domestic life are sacrificed to the glory of occasional drunken triumphs. **Sir Richard Cox** relates an anecdote of **Turlogh Lynogh**, an Irish chieftain, in the reign of Elizabeth, who went to **Newry** to meet the Lord Deputy for the purpose of swearing submission to the Queen of England, bringing with him no less a sum than 400l. in money, ‘the entire of which, he and his followers spent in tippling and carousing in three days time’ — ‘and so,’ continues that historian, ‘having received some small presents from the Deputy, he returned joyfully home,’ to meet the poverty occasioned by this excess: but we need not turn to the page of history for instances where acres of paternal 



---

p.228




property have been yielded to gratify an inordinate desire of popularity.


It is, however, only just to remark, that such occasions of display are long remembered; an English tourist, who visited Ireland in 1748, mentions, that hearing frequently, during his stay at Kilkenny, the expression ‘I have not seen or done such a thing since the Review at Bennett's bridge,’ became curious to learn what this review was, that it should be referred to as an era; when he was informed, ‘that the Duke of Ormond reviewed the army there in 1704, during which period he resided in the Castle of Kilkenny, with all the splendour of a royal court,’ and that no officer was wanting that may be found in the palaces of sovereign princes.


A love of drinking, which is said to be a prevailing passion with the Irish, may readily be ascribed to a variety of causes; to a natural fondness of excitement, to convivial feelings, or the extravagant notions too generally encouraged of universal hospitality. Added to the causes already enumerated, the cheap rate at which illicit spirit is sold in Ireland, and the facility of procuring this potent beverage, which comes 


> 1. From a still,
>   
> Just under the hill,
>   
> Where the eye of the ganger saw it not,
> 

 

are strong temptations to indulgence; and indeed the patrons, or meetings on saint days, equal, if not exceed, the riot of an ancient Bacchanalia.


A peasant, after suffering from the ill consequences of intoxication, will often forswear liquor of any kind for a given period; or will take an oath not to taste spirits within a certain barony, or ‘in any house,’ or ‘either in or out of a house,’ and though these vows are sometimes religiously observed, yet are they as frequently avoided by various and amusing stratagems: for instance, a man will walk ten 



---

p.229




miles with the whiskey in his hand until arrived without the prescribed boundary; or, in the second case, drink it in the open air; and even where he has pledged himself to drink ‘neither in nor out of a house,’ his ingenuity has devised a mode of doing so, with one foot within the door and the other without; and, when he swears by all he considers holy, to drink ‘not a drop at all at all,’ he surmounts his difficulty by eating the bread he has sopped in ‘*the cratur*.’


It is not surprising that wine or spirits should be considered an infallible remedy for every complaint, since the seat of every disease is believed to be in the heart. The universal comment beside the bed of an invalid is — ‘His poor heart just wants a little drop of comfort to nourish it;’ and accordingly, the doors of the country gentry are daily beset with squalid applicants, each presenting a vial bottle and beseeching a drop of wine ‘for a poor man lying down in his sick bed yonder;’ and, whatever may be the state of his pulse, a refusal is considered as little short of barbarity. This faith in the medicinal properties of wine reminds me of a story related by Stanyhurst, respecting a dispute concerning the Ormond title, between Sir James of Ormond and Sir Pierce Butler, it having been assumed and the annexed property seized by the former, notwithstanding its rightful descent to the latter. In 1518, Sir Pierce, who was afterwards the eighth earl, became reduced to extreme indigence; and his wife, the Lady Margaret Fitzgerald, (now remembered as the great Countess of Ormond,) falling ill, requested him to procure some wine for her; unable to comply with her wishes, and affected by her miserable condition, he vowed that she should have wine within four-and-twenty hours, or that she might look forward to sup on milk alone, without a husband. Sir Pierce accordingly went in search of the usurper of the Ormond title, attacked and slew him, and succeeded to his inheritance.


The violent proceeding of Sir Pierce Butler will not appear remarkable in the unsettled reign of Elizabeth, when the anecdotes of 



---

p.230




O'Leary the outlaw and Morty Oge O'Sullivan, related in this volume, are sufficient to prove the want of legal restraint in Ireland within the last century. The feudal system survived in the hearts of the people to such an extent, that the laws were seldom carried into effect without the most violent popular excitement; ‘Might, not Right,’ was the motto of the times; many estates were seized by force, and held until possession constituted a claim which could not be successfully opposed. Tracts of ground were granted to leading men for their protection, and compromises for seizure were often made by the weaker party. Of this, one instance is lying before me in an indenture dated at Cashel, 1734, where a farm of 85 acres, with the privilege of cutting turf on an adjoining common, is granted for 999 years, in consideration of the sum of one penny and the future security of several lands in the counties of **Tipperary**, **Cork** and **Limerick**. Nor was personal security more certain than that of property. Females were carried off by force from their dwellings, and compelled to become the wife or mistress of the man in whose power they were. It was enough that any farmer's daughter was supposed to possess a dowry (one of five guineas being often considered a sufficient inducement); she was immediately seized and taken forcibly away from her father's house, by some young man at the head of a gang of twenty or thirty associates. With the peasantry, this violent measure was commonly adjusted by marriage, and it was sometimes the conclusion of a rustic courtship.


Amongst the most striking remains of feudal manners are the contests between clans or factions, which so frequently occur, in open defiance of the civil authority. A fair, a patron or other public meeting seldom concludes without a pitched battle, and the loss of three or four lives; the weapons are commonly cudgels and stones; but in 1813, I witnessed ‘the gathering,’ as it was called, of a faction, for the purpose of deciding some matter of right, which had been thus disputed annually for more than forty years; where about 



---

p.231




twenty men were armed with muskets and fowling-pieces, and others with scythes and bayonets stuck on poles. I think it was three years afterwards the same parties met at Ballyvourney,[27](javascript:footNote('E820000-001/note027.html')) in the west of the county **Cork**, when the sub-sheriff, having notice of their intended meeting, arrived with a few dragoons for the purpose of preserving the peace: on his appearance, the contending parties seemed to forget their former animosity, and uniting into one body, made so unexpected an attack with stones and other missiles, (the women and children even joining in the assault,) that the officers empowered to disperse the assembly were compelled to make a rapid retreat.


After the patron (a meeting particularly described in a subsequent paper) has concluded, it is not unusual to seek a quarrel sufficient to authorise a general fight, and so inherent is the spirit leading to this kind of pastime, that rather than remain an idle spectator of moderate enjoyment, or return quietly home with a head unbroken, a man will sometimes, from a mere love of combat, and without any malice, take off his coat, and holding it by the collar, trail it through the assembly, challenging or beguiling any one to step on it; which insult he no sooner succeeds in obtaining, than he feels justified in knocking down the offender, and *the sport begins*. The pleasure derived from this sort of occupation may doubtless be felt by men 



---

p.232




who will tell you, they carry a cudgel ‘just to keep the cold out of their hands.’


The mode in which a farmer obtains his supply of fuel for the winter is somewhat singular. His intention of cutting turf on a particular day in the ensuing week is generally announced at the parish chapel, and on the appointed morning all his neighbours and friends (some of whom have perhaps travelled ten or twelve miles) assemble for the purpose of assisting in the labour. Emulation produces exertion, and, owing to the number of hands employed, the work is quickly performed — four or five hours being the usual time devoted to the purpose. No wages are given on these occasions, but, to compensate for non-payment, there is always a feast (if it may be so called) prepared, with the addition of a piper. These are termed Mihill meetings and the same custom prevails at haymaking.


A gentleman resident in the west of county **Cork** described to me a meeting of this kind which occurred in 1820, and subsequent transactions have impressed the account on my memory. He represented that a party of horsemen, about five-and-twenty, each carrying his spade on his shoulder, arrived at full trot at the house of a farmer, who had announced the cutting of his turf for that day; the order in which this band rode my friend remarked as being particularly regular; three a-breast, and having altogether an air of military discipline, but little in accordance with their avocation. On coming up to the door of the house, the word halt was given by the leader, who was styled captain, and instantly obeyed, when he advanced to the farmer and apologized for the lateness of his visit, by stating, that he and his merry men had been detained at another Mihill meeting six miles off, but that, having finished their work there, they had come to help him with his.


The festivities and customs peculiar to certain seasons of the year are many of them curious, and may be novel to the English reader. 



---

p.233




They resemble in a great degree those of the Scottish peasantry, and are, as in the Highlands, more vigorously observed than in England, where civilization has destroyed most of the ancient and mysterious feelings productive of such rites.


On the last night of the year, a cake is thrown against the outside door of each house by the head of the family, which ceremony is said to keep out hunger during the ensuing one; and the many thousand practical illustrations of the fallacy of this artifice have not yet succeeded in producing conviction of the same. On the anniversary of St. Stephen, (the day. after Christmas day,) it is customary for groups of young villagers to bear about a holly bush adorned with ribbons, and having many wrens depending from it. This is carried from house to house with some ceremony, the ‘Wren boys’ chaunting several verses, the burthen of which may be collected from the following lines of their song. 


> 1. The Wren, the Wren, the king of all birds,
>   
> St. Stephen's day was caught in the furze,
>   
> Although he is little, his family's great,
>   
> I pray you, good landlady, give us a treat.
> 2. My box would speak if it had but a tongue,
>   
> And two or three shillings would do it no wrong,
>   
> Sing holly, sing ivy — sing ivy, sing holly,
>   
> A drop just to drink, it would drown melancholy.
> 3. And if you draw it of the best,
>   
> I hope in Heaven your soul may rest;
>   
> But if you draw it of the small,
>   
> It won't agree with the Wren boys at all. [&c &c.]
> 



A small piece of money is usually bestowed on them, and the evening concludes in merry-making with the money thus collected.



On the eve of St. John and some other festivals, a broom stick dressed up as a figure, and called a Bredogue, is borne about in the 



---

p.234




twilight from one cabin to another, and suddenly pushed in at the door. The alarm or surprize occasioned by this feat produces some mirth.


The superstitions of the Irish are generally of a harmless kind, that the mind rather lingers on with pleasure than turns from in disgust; but there is one superstition I have not yet named, of so horrible and diabolic a nature, it was long before I could believe in its extensive existence; of which fact, however, minute inquiry and subsequent evidence have fully convinced me. I allude to the belief that the left hand of a corpse, if dipped into the milk-pail, has the effect of making the milk produce considerably more cream and of a richer and better kind than it would have done without this spell. In the year 1816, I saw a woman who had been apprehended and taken into custody, on a charge of raising cream by means of a dead man's hand, and two hands, in a shocking state of putrefaction, were exhibited as evidences of the fact; it was afterwards, however, proved that these hands had been conveyed into the dairy by some persons who wished to injure the poor woman; but the circumstance was sufficient to prove the existence of the superstition, which then became a general subject of conversation in the neighbourhood where it occurred.


Courtship is generally commenced soon after the parties attain their teens, and the bashfulness of the youthful lover is sometimes very amusing.


‘As I was within three bits of miles of Tim Haggerty's cabin,’ replied a fine lad of fourteen, when asked why he had loitered on an errand, ‘and Tim Haggerty was a relation of mine, for his mother was a second cousin of my grandfather's gossip, and as I thought your honour would not be wanting me, I just stept across, I could'nt do less why! to inquire after his welfare; and finding only Honny at home, I could'nt but wait a little, as he would soon be in, she said; but as for my thinking of Honny, your honour, I that's not out of my time, and that has but less than nothing to begin the world with, 



---

p.235




it is only those that seeks to belye me that spreads the report; but Honny for all that is as proper and clean a girl as any in the country, and if your honour did but know her, you'd not say that was a bold word, for nobody could gainsay it.’


A numerous offspring is the result of early marriage; and it frequently happens that the appearance of father and son is more like that of brothers, and they associate together rather with a fraternal feeling, than with that usually existing between parent and child.


A house with three contiguous apartments is selected for a wedding; the reason of this is to preserve a distinction between the classes of company expected. The best apartment is reserved for the bride and bridegroom, the priest, the piper, and the more opulent and respectable guests, as the landlord, his family and the neighbouring gentry, who are always invited and usually attend on such occasions. The second apartment is appropriated for the neighbours in general; and the third, or an out-house, is devoted to the reception of **buckaughs**, shulers, and other beggars. When the marriage is celebrated two collections are raised amongst the guests, the first for the priest, the other for the piper. The assembly does not take place until late in the evening, when the marriage ceremony is performed, and the festivities seldom conclude before day-break the next morning.


**Buckaughs** are a description of mendicants that within these few years have considerably diminished. The name implies a lame or mutilated person; but vigorous young men may be found, who, having assumed the ragged garb, crave the privileges of the impotent and aged. In Ireland there are no gipsies, but their place is filled by **buckaughs**, who have the same wandering habits and adopt the same unsettled mode of life, without however entering into associations or troops.


A **buckaughs** is a solitary and isolated being, one who seems to stand alone in the world without apparent occupation or pursuit. 



---

p.236




He is met travelling both on the high road and in unfrequented paths, at all hours and in all seasons, his beard unshaven, and his body encased in a garment composed of, shreds and patches, or, to use the more expressive local idiom, ‘a coat all stitches and packthread.’ Loaded with innumerable bags and wallets, he strides on, assisted by a long walking pole shod with iron, and terminated by a formidable spike. ‘In the evening the **buckaugh** is seen seated beside the turf fire of the poor cottager's hearth, partaking of his humble fare, the wallets and staff deposited in a corner of the cabin, and at night he reposes beside them on a bundle of straw. It is not uncommon to find these men with considerable literary acquirements; they are generally the possessors of several books and Irish manuscripts, which they have collected, and bear about from place to place with incredible fondness, nor can money always purchase part of their travelling library; their knowledge of writing renders them acceptable guests to many farmers, whose correspondence is often entirely carried on by such agency. By the younger members of the family, **buckaughs** are looked upon with much regard, and made the mutual confidant of their rustic amours. These persons write love-letters and then secretly deliver them, commend the youth to his mistress and the girl to her lover, and are consequently caressed and consulted by all parties. A **buckaugh** is the umpire of rural disputes, and the ambassador from one clan or faction to another, in which diplomatic capacity he is termed ‘the spokesman.’ The superabundance of potatoes and broken victuals bestowed upon them from motives of gratitude or charity, they usually sell to the family of the poor peasant or to city mendicants, whom they consider as an inferior order of persons, and in fact they are so, as their respective means of gaining a livelihood are essentially at variance. Deeply conversant with character, this singular class of mendicants are quick, artful and intelligent, but assume a careless and easy 



---

p.237




manner, seldom hesitating when it is for their own advantage, duping those who have confided in them, and yet I have heard instances of the almost chivalrous honour of a poor **buckaugh**.’


Beggars crowd round strangers at every town or village, in a manner that to the English traveller appears quite marvellous, always urging their demands in the imperative mood. ‘Ah then, if you have one half-penny in the world you shall give it me till I get some food for a sick child.’ ‘Remember the poor, your honour; and may God increase you; a fivepenny, your honour, would be nothing to the likes of ye; a tenpenny, your honour, amongst us, and we will not grumble.’ At least twenty of these demands at once assail you; and if you give to some, the reinforcement of applicants becomes so numerous as to be quite deafening, invoking the most singular blessings on you and yours for ever; but if you are ‘hard hearted,’ bestowing as liberally their curses. The eloquence of an Irish mendicant is very peculiar and sometimes incredible. I remember a poor blind woman, who for many years took her station every evening on George's Quay in **Cork**, whose appeals to the passengers were made in the most figurative manner, and never perhaps was more poetry on the subject of blindness uttered than I have heard from her lips.




---

p.238


Cloyne
------



> 1. Suche temporal war and bate
>   
> As nowe is made of late
>   
> Against holy Church estate!
> * God of his miseracion
>   
> Send better reformacion.
> 


**Skelton**.


**Cloyne** is a small town situated about two miles from the eastern shore of Cork Harbour, and a Bishop's See of considerable antiquity, St. Colman having founded its cathedral in the sixth century. Close to the cathedral stands a round tower, the most remarkable feature of the place. The town is straggling and miserable, composed of mud cabins and an inferior description of houses. Its name is derived from Cluaine, which signifies in Irish a cave, the surrounding limestone rock abounding with caverns and subterranean passages; Cluain, however, according to Dr. Ledwich, was a general term for any Druidical retreat. As there is no other market town for the whole of the well peopled peninsula, from Ballycotton to Rostellan, the influx of persons on a fair or market-day is very considerable.




---

p.239


In 1800 **Cloyne** was calculated to contain 308 inhabited houses, and rather more than 1600 souls. In 1813, the number of inhabitants was stated to be above 2000.


A branch of the Fitzgerald family, distinguished by the title of Seneschals of Imokilly, had formerly two or three castles here, and were the chief proprietors of the adjacent district, from which their title was derived; one that was first bestowed in 1420 by James, Earl of Ormond, Lord Lieutenant of Ireland, on Lord Desmond, after whose death it was assumed by the head of his descendants resident in the district.


Hooker gives us an account of a skirmish that took place near **Cloyne**, between the Seneschal of Imokilly and **Sir Walter Raleigh**, in which the intrepidity and skill of **Raleigh** were remarkable. **Raleigh** afterwards accused the Seneschal of cowardice on the occasion; and such were the manners of the times, that Lord Ormond and Sir Walter more than once publicly challenged Sir John of Desmond, and the Seneschal, both of whom were in open rebellion, to decide the matter by single combat.


We are informed by the writer of the Pacata Hibernia, that the Lord Deputy Mountjoy, on his return from the siege of **Kinsale** to **Dublin** by way of **Waterford**, came out of his road to pay a visit to **Cloyne**, where he slept on the 7th of March, 1601, and was received by Master John Fitz Edmonds,[28](javascript:footNote('E820000-001/note028.html')) who held the town and manorhouse in fee-farm, and who ‘gave cheereful and plentiful entertaynment



---

p.240




to his lordship, and all such of the nobilitie, captaines, gentlemen and others as attended upon him;’ when the ‘the lord deputy, as well as to requite his perpetual loyaltie to the crown of England, as also to encourage others in the like, at his departure did honour him with the order of knighthood.’


The cathedral of **Cloyne** is a small, heavy building, without any pretension to ornament, and is supposed, by the late Bishop Bennett, to have been built between the middle and the close of the thirteenth century; ‘having,’ says the bishop, who was an eminent antiquary, ‘no mouldings of the zigzag, nail headed, or billeted kind, nor round arched windows, which distinguish what is called the Saxon, or rather Norman architecture, before the introduction of the Gothic in the time of Henry III., and which appear, for instance, in Cormac's chapel at Cashell. It is not evidently so early as that time, nor, on the other hand, has it the splendid arch or oak-leaved ornaments so common in the middle of Edward I.'s reign, therefore it is not so late as that period. I should be inclined to fix the era of its building to the latter years of the first of these princes, or the beginning of the reign of the last. The windows, though since altered, were evidently of that sort called lancet windows, which were so common in the time of Henry III.; see the great west window, and that of the south transept; the latter on the outside, an additional argument for the date I have chosen; as is also the circumstance that, about this time, three prelates out of four were Englishmen, in whose country monastic and cathedral architecture was in high estimation.’


Bishop Bennett's reason for attributing the erection of the cathedral of **Cloyne** to the thirteenth century is clear and certainly decisive, if we allow the detail of any piece of Irish architecture to determine the date of its foundation. But the conclusion of the English antiquary, who systematically assigns dates, will often prove erroneous 



---

p.241




in Ireland, where the distinctions and peculiarities of the Saxon and Gothic styles were imperfectly understood, and the result was a confused and barbarous irregularity.


The Bishops Johnson and Woodward are buried in the cathedral. The latter died in 1794, and was distinguished by a controversy on White-Boyism, with the well known Father O'Leary. ‘May the Heavens be his bed!’ ejaculated the poor woman, who showed me the interior of the church, on pointing out Bishop Woodward's monument; ‘when he died the poor lost a good friend.’ A large and rather injured tomb of black marble near it, was pointed out as that of the Fitzgeralds, converted by the Earls of Thomond, since the decline of the Fitzgerald family, to their own use. The original epitaph in Latin may be found in **Smith**; it commemorates the hospitality, learning and valour of John, a Geraldine, who died in 1611, probably the same person as John Fitz Edmunds, knighted by Lord Mountjoy, and whose initials appear on an engraved stone in the wall of the bishop's palace.


Before erecting the present cross wall at the entrance of the choir, which was done by Bishop Agar in 1776, as the workmen dug deep in the nave to lay the foundation, they came on a row of graves rather singularly constructed, consisting of brick cells, exactly suited to the size and shape of the body contained in each, and what is rather curious one of them ended at the shoulders, nor were any of the bones of the skull to be found with the body. ‘It is therefore not improbable,’ adds Bishop Bennett, who has recorded this discovery, ‘that the head of the owner may have been fixed on **Cork** gates in the times of turbulence, as they appear in the print given us in the Pacata Hibernia to be full of such kind of trophies.’ I cannot leave the cathedral of **Cloyne**, without noticing the monument of Miss Adams, an accomplished and elegant young woman, whose premature death was peculiarly melancholy. In the circle of my earliest 



---

p.242




friends, her numerous acquirements and faultless disposition were dwelt upon as a darling theme, and her monument was contemplated with feelings of almost painful interest. The Epitaph is from the pen of the well known Mrs. Piozzi: 


> 1. From this vault shall
>   
> at the last day ascend
>   
> the reanimated body of
>   
> Susan Adams!
>   
> More fair, more lovely, and more excellent
>   
> (since with our God all things are possible)
>   
> than when at 18 years of age
>   
> she left a circle of admiring friends
>   
> to seek the wreath bestowed
>   
> on meekness, piety and virtue.
>   
> whilst by setting up this sublunary token of remembrance
>   
> a momentary consolation has been lent
>   
> to her afflicted mother.
> 

 *Hester Lynch Piozzi. June, 1804.*


In the East part of the church yard, are the remains of a small
 stone edifice called St. Colman's Chapel. It stands East and West,
 its length is thirty feet, and its breadth nineteen. 

> 
> A manuscript in the British Museum, which appears to have belonged to Sir James Ware, as I apprehend some notes upon it are in his writing, (No. LI of the Clarendon Collection 4796,) contains a very curious account of the ancient celebrity of **Cloyne** as a place of sepulchre, followed by a tedious enumeration of the lands given to the See, in purchase for places of interment: it commences thus — 
> 
> 
> ‘In the life of Ryyan it is sett downe, that the best blouds of Ireland have choosen their bodyes to be buried in Cluaine, which choice, for that Ryyan had such power being a holy bishop through the will of God, that what soules harboured in the bodies buried under that dust may never be adjudged to damnation, wherefore those of the said bloud have divided the church yard amongst themselves by the consent of Ryyan and his holy clearks.’
> 
> 
> A specimen of the other parts of this manuscript, may be acceptable, as I believe it has never before been noticed, I shall therefore give a short extract with the conclusion: ‘Thus hath Mac Carthy, first Great Finyn Mac Carthy pay'd for his sepulture there viz. for a proportion of nyne cells or chapels, that is to say 48 daies[29](javascript:footNote('E820000-001/note029.html')) for every chapell, the chapels were these, Kill Kyran in Desmond, Kill Cluain, Kill Torssair and Killatbebhe, and the other five kills of cells cannot be reade.’ &c.
> 
> 
> ‘And it was the Bishop Muirchertagh O'Muridhe, that caused this to be written and drawen out of the auncient life of Ryyan in this easie language, fearing least it should be obscured or lost, together with what other things yt were bestowed upon Cluain during his life, when the year of ye Lord was 20, three hundred and a thousand years, uppon the stone of whose tomb was engraven in Irish, Muriertach O'Murrid B*isho*p of Clone, head of all * * (*one word which cannot be deciphered*) Shanan his foster brother erected this stone monument for him.’
> 
> 
> ‘The Friary of Kilconnell mentioned in this life,’ (says a note which I take to be by Sir James Ware,) ‘founded about the year 1400, sheweth there is a mistake in the yeare here set downe. Qy. if it should not be 1420?’
> 
> 
> 




The round tower 



---

p.243




is on the opposite side of the street from the church, situated, as these buildings almost invariably are, near the west door. Miss Nicholson's drawing will convey a better idea of this curious structure, than a description however minute could do. Whilst engaged in sketching the tower, Miss Nicholson was surrounded by more than a hundred of the inhabitants, who flocked to the spot with a curiosity so great as scarcely to be credited, and, to use her own words, ‘closed on me with such overwhelming pressure, that I could scarcely draw either that or my breath.’


This building received considerable damage from lightning: the following account of which is chiefly collected from **Dr. Smith**'s County History. **Bishop Berkeley** also relates the circumstance in a letter dated the 2d February, 1749. A thunder storm with lightning passed through the county **Cork**, on the night of the 10th January, 1749, in a line from west to east, and after killing some cows in a field south of **Cork**, struck the round tower of **Cloyne** used as a belfry to its cathedral. The electric matter first rent the vaulted arch at the top, threw down the great bell presented by Dean Davies, together with the three lofts, and, descending perpendicularly 



---

p.244




to the lowest floor, forced its way, with a violent explosion, through one side of the tower, and drove some of the stones, which were admirably well jointed and locked into each other, through the roof of a neighbouring stable. The door, though held by a strong iron lock, was thrown to a distance of sixty yards and shattered to pieces, and a few pigeons that used to roost in the top of the steeple were scorched to death, not a feather being left unsinged. The conical stone roof destroyed by this accident was never replaced, but the height of the tower was lowered more than six feet, and an embattlement substituted. The stones of which the tower is composed have been mostly brought from the sea shore, and were prepared with much care, though about half way up the building there is an evident difference in the stones themselves as well as in the mode of placing them. The steps to the door are modern, like the embattlement; for these towers, whatever may have been their use, were entered by means of a rope or ladder, the door being generally eight or nine feet from the ground. In this at **Cloyne** it is about thirteen, and at **Kilmacduagh**, in the county **Galway**, no less than twenty-four. The height of the Round Tower of **Cloyne** is stated to be ninety-two feet, and the thickness of the wall forty-three inches: the first story has projecting stones for the joists of a floor to rest upon.


The Bishop's Palace adjoins the town, and was rebuilt in the early part of the last century by Bishop Crowe, a descendant of the notorious **Sir Sackville Crowe**. It is an old fashioned and clumsy building, without any claims to architectural beauty; but, as the residence of the amiable **Bishop Berkeley**, possesses a superior attraction: the most profound metaphysician of his time, he was distinguished by the disinterestedness of his character and the purity of his mind, and truly merited the commendation of **Pope**, who ascribes 

*To Berkeley every virtue under Heaven.’’*

Alexander Pope

 

His Essay on the Virtues of Tar-water was perhaps his most popular 



---

p.245




work. This discovery excited an extraordinary sensation in the medical world, and tar-water, for a considerable period, was administered as an infallible specific for almost every complaint. — But it may be considered impertinent to dwell on the life and writings of one so well known as **Berkeley**. — When appointed Bishop of **Cloyne**, in 1733, he gave up the distinguished circles of London in which he had moved, and became the constant resident of a remote and inconsiderable town in Ireland, where, with real patriotism, he expended within his diocese the income derived from it; and his exertions to improve the habits and condition of the people by whom he was surrounded render him as illustrious an example to Irishmen of rank and property, as do his studies and inquiring habits to those engaged in literary or scientific pursuits.[30](javascript:footNote('E820000-001/note030.html'))
The bishop's demesne is rather picturesque, and considered to be the most fertile land in the district. Some fine ash-trees that overhang a pretty dell afford the artist good studies of close scenery, improved by jutting masses of well-coloured rock. In the grounds, not far from the palace, are the entrances of two natural limestone caverns, into neither of which it was possible to advance far, both being choked up by weeds and filled with water. The ancient name of this spot was **Monelusky**, or the Field of Caverns; and the names of the adjacent grounds speak the savageness of the place in early times; **Knocknamodree** is the Hill of the Gray Dog or Wolf; **Park na Drislig**, the Field of Briers; **Monecranisky**, the Meadow of the Wild Boars. Of the hills surrounding the town, that on the north is called **Bohermore**, or the Great Highway, from a tradition that a road passed over it, from the sea on the south to the sea on the north of the kingdom.[31](javascript:footNote('E820000-001/note031.html')) The hill on the north is **Knocknamodree**, or the 



---

p.246




Hill of the Wolf, already mentioned; and to the north-east is **Curloum**, or the Hill with the naked Turn, which expresses its present appearance with much precision.


**Cloyne** is indebted to Bishop Crowe for its poor-school; the original foundation was endowed by that prelate for twelve boys. The present number of children exceeds seventy, boys and girls, and the system followed appears to be that recommended by the Society for Promoting National Education.


Bishop Crowe is stated to have expended a large sum of money on the improvement of **Cloyne**, and he recovered for the see the lands of **Donoughmore**, containing 8000 acres. The value of the bishoprick is now estimated at between six and seven thousand pounds per annum. Ecclesiastical property, however, has felt the fluctuation of the times. During the Reformation, the Church of England suffered severely in its temporal affairs, more than half the clerical property in the kingdom being vested in lay hands; but that of Ireland was in a manner annihilated. Bishopricks, colleges, glebes and tithes were divided without mercy amongst the great men of the time, or leased out on small rents for ever to the friends and 



---

p.247




relations of the incumbents. Many Irish bishopricks never recovered this devastation, as **Aghadoe**, **Kilfenora** and others. The Bishoprick of **Ferns** was left not worth one shilling. **Killala**, the best in Ireland, was worth only 300l. per annum; **Clonfert**, 200l.; the Archbishoprick of **Cashel**, 100l.; **Waterford**, 100l.; **Cork**, only 70l.; **Ardagh**, 1l. 1s. 8d.; and the rest at even a lower rate. **Cloyne**, situated at a distance from the capital, an appendage to the neighbouring see of **Cork**, and without head or guardian, had very little chance of escaping in the general plunder; the out-lying estates of the see became immediately the prey of the nobility near them. The **Earl of **Cork**** seized the manor of Inchiquin; Lord Barrymore formed pretensions to Kilcolman: Lord Clancarty got possession of Donoughmore, and the family of the Fitzgeralds, who were extremely powerful, and had already obtained the manor and greater part of the burgery of **Cloyne**, cast their eyes on the remaining possessions of the see. As the plan was a bold one, it was necessary to proceed with caution. In order to make the leases of the bishop's lands valid in those days, it was proper to have them confirmed by the dean and chapter, the church having thus, as it were, two securities that estates should not be wantonly granted away.


To surmount this difficulty, Maurice Fitzgerald, though a layman, had himself appointed to the deanery of 
**Cloyne**, and filled the chapter with his dependents; lay prebends as well as deans being not uncommon in the time of Queen Elizabeth. He then applied to Roger Skiddy, Bishop-elect of **Cork** and **Cloyne**, to grant him the possessions of the latter in fee-farm, to which Skiddy is said to have consented in 1557; but there seems to have been some irregularity or obstacle to the quiet succession both of Skiddy, who is stated to have resigned in 1566, and Dixon, who was deprived in 1571; so that it was not until eighteen years after this that the business was perfected, when Mathew Shehan, who was then bishop, in consideration of 40l. (equal to 500l. at present), leased out, on the 14th July, 1575, at the annual rent of five marks, for ever, the whole demesne of 



---

p.248


**Cloyne** (four plough lands), with six other plough lands, the extended value of which must be now nearly 5000l. per annum, and an inscribed stone in the wall of the palace, which is here copied, seems to have been set up immediately after the Fitzgeralds obtained possession, as an evidence of their right.


In order to give some colour to the transaction, it was performed in this manner: Bishop Shehan granted the fee-farm of all the temporalities of the see of **Cloyne** for ever to Richard Fitz Maurice and his heirs on the above conditions. The dean and chapter, under their common seal, confirmed the grant, and then Fitz Maurice, who seems to have been merely an agent, is stated to have sold his right and title to Master John Fitz Gerald of **Cloyne**.


Bishop Lyon, who succeeded Shehan in 1606, was the first Protestant bishop, and held the united sees of **Cork**, **Cloyne** and **Ross**; he is said to have been in the naval service, and having distinguished himself by his valour, was promised promotion to the first situation which should become vacant in the gift of the crown; this happening to be the bishoprick of **Cork**, he was appointed to it. As an ecclesiastic, he was more esteemed for his benevolence and charity than for eloquence or learning. Almost the only sermon Bishop Lyon was ever known to have delivered being a very laconic one on the death of Queen Elizabeth, the language of which would have better suited the quarter-deck than the pulpit of a cathedral. **Lithgow**, the Scotch pilgrim, who visited Ireland in 1619 seems to allude to the appointment of this ecclesiastic in his complaint against the corruption of the time. *‘Yea,’ exclaims he, ‘and rude-bred soldiers, whose education was at the musket-mouth, are become church-men!’’’*

William Lithgow, Rare Adventures in Ireland in 1619.. 


Bishop Lyon, in 1618, petitioned council unsuccessfully for a 



---

p.249




restoration of the see-lands of **Cloyne**; and the fee-farm rent being all the property he derived from the see, he was nicknamed ‘Episcopus quinque marcorum.’ In this hopeless situation, the interference of a higher power gave a favourable turn to the cause. The ravages of the Irish church, which had been carried on in the most open manner during the reigns of Henry VIII., Edward VI. and Elizabeth, and more covertly, though almost as effectually, in the time of James I. were stopped on the accession of **Charles I.**; and it is to the credit of this prince not only to have checked this disgraceful and ruinous practice, but, in many instances, to have forced the plunderers to make restitution. Lord Strafford, a minister of great virtues, as well as great faults, had the honour of saving the remains of the Irish church. He found it, on his arrival in 1631, in a state of ruin: many of the bishoprics, as **Ferns**, **Lismore** and **Cloyne**, entirely destroyed, and the revenues of the others reduced to a trifle; the churches pulled down, or in a state of desolation, and the glebes and tithes in the hands of laymen; so that one nobleman in the western part of the kingdom (the Earl of Clanricarde) had no less than 100 livings in his own possession; and the Earl of Cork, in the south, besides all the landed estates of **Lismore** and the College of **Youghall**, had impropriated all the livings belonging to both of them.


The lord deputy began first to recover the lands which had been usurped from the bishoprics, and the mode he seems to have adopted for this purpose was by no means destitute of equity. He threatened the possessors with inquiring strictly into their titles, and fining them severely for their injustice if any fraud should be discovered; but, to such as were willing to resign their fee-farms and consent to take a fresh lease from the see, at a higher and more equitable rent, though still very advantageous to the tenant, he promised to prevail on the bishops to grant such leases for the term of sixty years, thus, in fact, allowing the lessees a reasonable advantage 



---

p.250




for any improvement they might have made on the lands, but reserving the lands themselves for the benefit of the church.


The title-deeds and other papers belonging to the see of **Cloyne**, being either lost or intentionally destroyed by the Fitzgeralds, while the see was in the possession of that family, there is no early record now in the registry except that called ‘Pipam Colmani,’ which is a list of the estates and manors belonging to the bishopric in 1364. It was composed by order of Bishop Swaffham, who was a Carmelite monk and a great opponent of Wickliffe, and who seems to have had some political importance in his day, being deputed by the parliament, in conjunction with the Bishop of Meath, the Prior of St. John's, and Sir R. Holwood, Baron of the Exchequer, to sail to England and lay the state of the kingdom before Richard II. This document was missing when **Smith** wrote his History of Cork, and is said to have been recovered by accident some years after. **Sir James Ware** expressly mentions that it was not to be found when he wrote. The earliest paper except this is a sort of voluntary deposition by James Fitz John Gerald of Ballyfin, dated 1635, purporting to give evidence of the ancient state of the town. The evidence goes to prove that Bishop Francis Daniel, about 1260, gave the burial-ground and passed the manor, with many immunities, to the citizens and burgesses of **Cloyne**, they paying certain sums agreed upon by Bishop David, his predecessor; that a charter was then solemnly given to the inhabitants; that the city was divided into English Town or Street, and Irish Town or Street; the manorhouse stood near the church, the bishops not having a foot of land reserved in the town; that the bishop's house was in Irish Street, but of late, in the last Sir John's time, they had got one in English Street, &c. The authority of this paper was considered by the late Bishop Bennett doubtful, because brought forward by one of the parties interested in usurping the property, and alluding to transactions stated to have occurred nearly 400 years before, unsupported 



---

p.251




by any evidence but hearsay tradition deposed by one of the possessors of the ground, and the paper being produced or fabricated at the very time when Lord Strafford was beginning to question the Fitzgeralds' title to the estates of the see, and being the only record left in the registry. Bishop Bennett has collected many curious particulars respecting the history of the see of **Cloyne**, which he directed should be given, on his death, to the Registry, for the use of his successors, and of this manuscript, for the communication of which I am indebted to the Rev. Francis Kirchhoffer, I have freely availed myself in compiling the present paper.


Of the caves in the neighbourhood of **Cloyne**, I particularly visited that called Carrig a crump; the entrance is in a limestone quarry belonging to the Messrs. Fitzgerald, where the stone used in building the new quays and custom-house at **Cork** has been chiefly raised. One of the proprietors, with much kindness, furnished me with lights and a very original personage named Larry to serve as a guide.


The descent was difficult, through a narrow and steep crevice of the rock, and the footing extremely slippery. At the end of this passage was a perpendicular fall of about seven feet. My guide sprung nimbly down into the profundity of gloom that expanded before us, and I followed by throwing myself into his arms. Proceeding a short distance, the cave became higher and more extensive, and we advanced some way, stepping from one large mass of stone to another, the bases of which were completely concealed by deep water. As our lights were, in many places, but sufficient to make ‘darkness visible,’ Larry, when I moved before him, repeatedly begged ‘my honour not to be too *bould*.’ We soon found ourselves in a chamber of considerable size, the roof of which seemed supported by a ponderous stalactical pillar, on a base proportionably massive, ornamented with clustering knobs of small stalactites that hung over each other like hands with the fingers spread out. Above, appeared gloomy galleries with entrances resembling rich Gothic 



---

p.252




archways, but we were without the means of ascent, and consequently unable to explore any of them. Whilst I was gazing upwards, my guide, with a true knowledge of effect, placed the lights on the opposite side of the central pillar to that on which I stood, leaving me in darkness, and illuminating half the chamber. Under this management, a projecting point of rock, without much effort of fancy, assumed the appearance of a colossal figure in repose, leaning on a club, that, to the vivid imagination, might seem the genius of the cave, slumbering in his favourite grotto of spar.


We turned away into another part of the cave, adorned with fewer stalactites and somewhat circular in shape; nearly in the centre, a single stalactical column rose with an air of elegant lightness out of water, the cool and sparkling appearance of which can be assimilated only to liquid crystal. Having succeeded in crossing it, we ascended a kind of terrace, so smooth and level as almost to appear artificial, where lay two circular masses of spar resembling fragments of an enormous broken column; from this terrace four or five passages struck off, but they were so full of deep water and so narrow that I did not venture down any of them. Larry, however, whilst I remained on the terrace, had penetrated some distance into the largest, and commenced whistling an old Irish ditty, the effect of which appeared to me where I stood, as if many flutes were playing in unison. My guide spoke of a passage into a large chamber which he called ‘the White Hall;’ but it was so narrow, low and muddy, he recommended my not exploring it. On my return I passed near the entrance by which the cave had been formerly visited. It was, I understood, of such dimensions that a man on horseback might ride in some distance; but the falling of a quantity of earth had closed up this mouth, and it was not without repeated efforts that we emerged from darkness into daylight. The cave of Carrig a crump is little known, even to those resident in its immediate vicinity; its extent is probably very great, yet few I believe have penetrated much 



---

p.253




farther than I did. A story is related, but with slight claims to belief, of a trumpeter, belonging to a dragoon regiment quartered in **Cloyne**, being left behind by a party of his comrades, with whom he had entered one of the passages in the Bishop's Meadow, and the next morning surprizing the labourers in Carrig a crump quarry by the sound of his bugle issuing from the crevices of the rock, to which instrument he was indebted for his preservation, as they immediately extricated him, after having travelled in his subterranean journey about a mile in a direct line.


Throughout the whole of this district the limestone rock abounds with natural caverns, and, in 1805, a curious discovery was made not far from **Castle Martyr** by a quarry-man, in consequence of his crow-bar having accidentally fallen through a fissure of the rock; he widened the aperture and descended in search of the instrument into a cavern, where he was not a little surprized to behold a human skeleton, partly covered with exceedingly thin plates of stamped or embossed gold, connected by bits of wire; he also found several amber beads. The annexed sketch of one of these gold plates is the same size as the original, which is in the possession of Mr. Lecky of **Cork**, with the fragments of a bead. The remainder of the gold was sold and melted in **Cork** and **Youghall**, and a jeweller who purchased the greater part told me the quantity he had melted to use his own words was ‘rather more than the contents of half a coal-box.’


The bones of the skeleton were eagerly sought after by the superstitious peasantry, as those of St. Colman, and carried away for charms: there is a tradition in the country, of a battle having been fought near this spot in a very remote period, and of four kings having fallen in the conflict. It is, perhaps, worth remarking, that the first account 



---

p.254




of this discovery appeared in the Moniteur of the 25th August, 1806, and was copied thence into the Irish provincial papers.


Not far distant from **Cloyne** is Castle Mary — a seat belonging to the Longfield family: it was formerly called Carrig Cotta, supposed to be a corruption of Carrig Croith, or the Rock of the Sun, from a cromlech or Druidical altar, that is still to be seen not far from the house. This remain of paganism consists of a rough and massive stone, twelve feet in length: one end elevated about six feet from the ground, by two smaller stones, from which its name of Cromlech, signifying a bending or inclined stone, is derived. Close by it is a smaller stone or altar, supported in a similar diagonal position by a single stone. There is a tradition that nothing will grow under either of these altars, an opinion that originates from the total absence of verdure, incident to a want of sufficient light and air. The top of the larger altar was richly covered with the plant familiarly called the Wood Geranium, (Geranium Robertianum, or Robert's Crane's Bill,) the light feathery leaves and delicate pink blossoms of which, formed a pleasing contrast to the solemnity and breadth of the altar.


The plantations of Castle Mary are venerable and extensive, arranged in the taste of the last century: few situations can be more imposing or romantic than that of the Druid's Altar, the descent to which is overshadowed by some luxuriant ash trees of singularly beautiful form and growth; the gigantic size attained by some, surprizes the English traveller, and their long graceful branches, reaching to the ground, produce an effect not unlike the famed banyan groves of the east. Whilst Miss Nicholson was sketching the altar, a figure emerged from this depth of foliage, in costume, which, had it been a tint whiter, might well have passed for that of a Hindoo — but the innocent deception was soon destroyed by the irresistible accent in which the following exclamation was uttered, after coolly surveying that lady's work and the subject of it.




---

p.255


‘Och! *fait*, and sure the *darlint* lady isn't putting down the *ould* stones — may be! and as like as themselves it is, long life to her! well to be sure, and a power of trouble to be taking — *a wisha* God help us!’


Rostellan, the other principal seat in the neighbourhood of **Cloyne**, is that of the Marquis of Thomond, and commands a noble view of Cork Harbour, of which it forms part of the eastern shore. The present house is built upon the site of a castle of the Fitzgeralds, and contains a small armoury. ‘The sword of the great Brian Boru, my lord's ancestor, King of all **Munster**, your honour, and *his fowling-piece!* are there to be seen,’ said one of the gate-keepers, who accompanied us through the grounds, and seemed anxious to display the wonders of the place to strangers.[32](javascript:footNote('E820000-001/note032.html')) This anachronism of assigning to an old musket a period of four or five centuries before its probable construction, is amusing enough, were it not so very common in Ireland; for Fion Mac Cuil, (the Fingal of Ossian,) St. Patrick, and Brian Boru, are personages to whom anything ancient, wonderful or curious, is without hesitation referred. Queen Ann granted to one of the former Earls of Inchiquin, by letters-patent, dated 20th April, 1708, with many privileges, to the manor of Rostellan, a considerable portion of land adjoining, which his lordship had embanked from the tide.


On a terrace close to the water is a statue of Lord Hawke, chiefly remarkable from its position, the admiral's face being turned away from the element on which he had acquired his fame; **Sir Richard Hoare**, in his Irish Tour, relates the following anecdote as the cause:


‘Upon the defeat of the French fleet commanded by Conflans, in the year 17 59, the city of **Cork** ordered a statue to be cast of the English admiral Hawke; but on its completion, some objections were made by the citizens, upon which the noble Inchiquin said, 'that he would pay for it;' which he did, and, as a rebuke, placed the admiral's



---

p.256




figure on a pedestal with his back turned towards the ungrateful city. Mr. O'Brien,’ continues Sir Richard, ‘told me a curious circumstance relating to this same statue, and which, in a less enlightened age than the present, might have been considered as ominous; that the admiral's right arm which grasped a sword, fell off on the very day that the French landed on the coast of Ireland at Bantry Bay.’


The O'Briens are one of the few original Irish families, that a series of revolutions have not entirely deprived of possessions in their native country. Until the reign of Henry VIII., they were distinguished as kings of Thomond, when the hereditary heir to the title, being a child, was dispossessed by his uncle Murrough, according to an ancient and barbarous Irish custom named Tannistry, a species of popular election of leaders or chiefs, that gave the right of possession to the strongest; as a living poet has happily defined it: 


> 1. the simple plan,
>   
> That they should take, who had the power,
>   
> And they should keep who can
> 

 

a custom finally abolished by James I., in 1605. From this event perhaps the present Irish motto of the O'Briens originates, literally in English, ‘The strong hand uppermost,’ which has been absurdly enough rendered ‘Vigueur du dessus.’


King Murrough, feeling the insecurity of the title he had usurped, when his nephew Donough arrived at years of maturity, determined on surrendering it to the King of England, and of securing a lesser dignity, in which he was encouraged by the English governor of Ireland, who was anxious to destroy the feeling of monarchical independence. Murrough accordingly sailed for England, where he arrived on the 3d June, 1543, and waited upon Henry VIII. at his palace at Greenwich, to whom he formally resigned his pretensions to royalty, and received in lieu the title of Earl of Thomond for his own life, 



---

p.257




and Baron of Inchiquin for his descendants, by letters-patent dated the 1st July, following; at the same time covenanting to assimilate to English manners, to obey the English laws, and to cause his children to be instructed in the English language. Donough, the nephew of Murrough, was also created by Henry, to prevent any future disputes, Baron of Ibrackan for himself and male issue, and Earl of Thomond for life on the decease of his uncle. After some severe family feuds, which were suppressed by the interference of Lord Sussex, Donough, Baron of Ibrackan, succeeded his uncle as Earl of Thomond, and received a new patent of nobility from Edward VI., continuing the title of Thomond to his heirs, whilst that of Inchiquin remained to the descendants of his uncle. The illustrious actions and descent of the O'Briens have been a favourite theme with the bards of Ireland. At the commencement of the seventeenth century, most of the senachies in the kingdom were engaged in a poetical controversy respecting the claims to superiority between the great northern family of O'Neal and the great southern one of O'Brien, a subject on which several thousand verses were employed. These have been collected, and are termed by Irish scholars, ‘the Contention of the Bards;’ the contest arose out of a composition of **Teige Mac Daire**'s, who was retained as poet by Donogh O'Brien, the fourth Earl of Thomond, and was answered by **Louis O'Clery**, poet to O'Neal. Rejoinder and reply almost innumerable ensued, and the majority of the bards of that period became involved in the dispute.


The most prominent member of the O'Brien family in Irish history since the conquest by England, was Murrough, the sixth baron of Inchiquin; but he appears to have been so ambitious, selfish, and time-serving a character, that it is impossible either to admire him, or become interested in his fortunes. Lord Inchiquin married a daughter of **Sir William St. Leger, the President of **Munster****, whose attachment to the unfortunate **Charles I.**, and stability of principle, is a noble contrast to the veering conduct of Lord Inchiquin. On the death of 



---

p.258




his father-in-law, Lord Inchiquin, being disappointed in his expectations of succeeding to the presidency, declared for the parliamentary party, and accepted an important command under them, meanly endeavouring to conceal his mortification, and account for the change of his political creed, by a variety of insignificant excuses.


From what can be collected, Lord Inchiquin's career during the civil war was intemperate in the highest degree, ‘not sparing his own kindred,’ says Ludlow, ‘but if he found them faulty,’ (that is, in arms for the cause he had abandoned,) ‘hanging them up without distinction.’ His ‘memorable service’ at Cashel partakes of the same spirit, where, regarding neither sex nor age, three thousand were put to the sword by his orders; and the priests, literally torn from the altars of God, were butchered before them in the cathedral. Had Lord Inchiquin acted from the enthusiastic feeling of the times, his character would have retrieved itself on the page of history, for he was personally brave and frequently victorious; but he seems to have studiously corrupted the well-inclined, and endeavoured to elevate himself by undermining the nobleness of others.


The parliament of England, feeling that no dependence could be placed on such a man, voted him a traitor the 14th April, 1649: and **Charles II.**, with a view of creating a revolution in his favour, immediately by letters from the Hague appointed him President of **Munster**; but the soldiers under his command, disgusted by the inconsistency of his conduct, revolted. Lord Inchiquin, for safety, fled to France, and was soon after raised by Charles to the dignity of an earl; on whose restoration, when the claims of unbroken allegiance were unrewarded, the sum of 8000l. was bestowed on Lord Inchiquin — ‘as a mark of his majesty's favourable and gracious consideration of his losses and sufferings.’




---

p.259


Architecture and ancient buildings
----------------------------------



> 1. O tract of tyme, that all consumes to dust,
>   
> We hold thee not, for thou art bald behinde:
>   
> The fairest sword, or mettall, thou wilt rust,
>   
> And brightest things bring quickly out of minde.
>   
> The trimmest towers, and castles great and gay
>   
> In processe long at length thou doest decay:
>   
> The bravest house, and princely buildings rare
>   
> Thou wasts and weares and leaves the walles but bare.
> 


**Thomas Churchyard**'s Worthines of Wales.*The Worthines of Wales (1587), a valuable antiquarian work in prose and verse, anticipating Michael Drayton.*


In the foregoing papers considerable space has been devoted to descriptions of such architectural antiquities as have come under my immediate observation. Monuments of former ages are identified with national history, and are objects, not only of interest but importance to every country, as the unquestionable and faithful record of the past. The character of nations and of governments lives in the edifices reared under them; and had the annals of Egypt, of Greece, or of Rome descended to us without the glorious structures that still ennoble these fallen countries, how many casuists would have flung the odium of barbarism on their former population!




---

p.260


The origin of the Irish round tower is involved in as profound obscurity as that of the Egyptian pyramids, and if the latter extraordinary monuments excite our curiosity in a country where the same gigantic taste pervaded every work of sculpture as well as architecture, how much more impressive is this solitary remain, that stands 


> 1. Sublime and sad,
>   
> Bearing the weight of years!
> 




A recent writer on the subject, warmed into enthusiastic declamation, apostrophises — ‘The unrivalled pillar tower in all its primitive beauty, venerated, undisturbed, and, after a reign of fourteen hundred years, still the pride and the ornament of modern, as it heretofore had been of ancient Ireland.’


Beside these buildings, of which more than fifty are at present standing, none others in Ireland deserve notice as works of art, the date of whose formation is not known. On the Round Tower, therefore, rests the only proof of the skill and knowledge of the early inhabitants of Ireland: ponderous masses of uncouth stones, tumuli and mounds being works equally common to the rude state of other nations.


The vulgar belief that these pillar towers were the produce of supernatural agency has been already mentioned. ‘Travellers into the east,’ says Sir Joshua Reynolds in his Discourses, ‘tell us that when the ignorant inhabitants of these countries are interrogated concerning the ruins of stately edifices yet remaining amongst them, the melancholy monuments of their former grandeur and long lost science, they always answer that they were built by magicians. The untaught mind finds a vast gulph between its own powers and those works of complicated art, which it is utterly unable to fathom, and 
it supposes that such a void can only be passed by supernatural means.’




---

p.261


The conjectures offered as to the use of the Round Tower are at once numerous and unsatisfactory.[33](javascript:footNote('E820000-001/note033.html')) By some they are supposed to have been the abodes of solitary anchorites; by others, to have contained the sacred fire worshipped before the Christian era; some, again, maintain that they were places of temporary penance, and others state them to have been belfries; nor does any peculiarity of situation, except the vicinity of a church, assist the antiquary in his inquiry. It may be tiresome, and would answer little purpose, to recapitulate the various arguments produced in favour of these several opinions, but the latter, that of their being belfries, is the one commonly received.


It is needless also to enter into particular descriptions, as the drawings and measurement of those at **Cloyne** and **Ardmore** convey a general idea of Irish round towers, and embrace the most remarkable difference between them, that of circular stone belts, which are rather unusual. All that seems certain about these buildings is, their existence before the invasion of the English in the time of Henry II. as **Giraldus Cambrensis** expressly mentions ‘turres ecclesiasticæ, quæ more patrio arctæ sunt et altæ necnon et rotundæ.’ From their very great similarity it is evident that they were the work of the same age and the same people, and they have been attributed to the missionaries who first introduced Christianity into Ireland. There are many almost conclusive arguments in favour of this conjecture; one, however, which I have not heard, is, that every round tower has 



---

p.262




its patron saint, whose legendary fame still survives in the surrounding districts as well as in old chronicles: St. Colman and St. Declan are the tutelary guardians of those at **Cloyne** and **Ardmore**.


After the round towers should be noticed the oratories, or stoneroofed chapels, so often to be found near them. These are very small heavy buildings, with wedge-like shaped roofs of stone, of which the one at Killaloe affords a characteristic specimen.


When King Henry II. visited **Dublin** in 1171, we are told by historians that there was no house there capable of containing that monarch's retinue; ‘and therefore,’ to use the words of **Sir Richard Cox**, ‘he was necessitated to build a long cabin with smoothed wattles after the fashion of the country, and almost in the nature of a tent, which (being well furnished with plate, household stuff and good cheer) made a better appearance than ever had been seen in Ireland before that time, and accordingly it was admired and applauded by the Irish potentates, who flocked thither to pay their duty to the king.’


Having such models as the round tower, it is evident that the want of stone buildings in Ireland cannot be ascribed to ignorance. Sir John Davies appears to point at the real cause in the customs of tannistry and gavelkind, both of which rendered the inheritance and division of property a matter of much uncertainty, and the cause of frequent disputes. It was certainly, remarks that writer, ‘against all common sense and reason’ to expect any man ‘would plant, or improve, or build upon that land which a stranger whom he knew not should possess after his death.’


The English adventurers seem, immediately after their landing, to have built castles for their defence and the protection of the districts they had overcome, there being few if any fortifications in the country the work of the Irish. The towns of **Dublin**, **Cork** and **Waterford** were walled, and probably founded by the Danes. The Irish appear to have been the inhabitants of forests and of mountains, where they 



---

p.263




dwelt in a kind of savage freedom, despising restraint, from their ignorance of its advantage.


When Sir John De Courcy, one of the first English settlers who built many castles in the north of Ireland, gave two of them as a mark of friendship to Mac Mahon, a native chieftain, the latter almost immediately destroyed these buildings, declaring that he valued not stones like land, and that it was contrary to his nature to live within cold walls whilst the green woods were within his reach. **Story** mentions that the first castle ever built in Ireland, ‘as to any pile of lime and stone,’ was at Tuam, in the year 1161, by Roderick O'Connor, which was called, on account of its rarity, 
‘Castrum Mirificum.’ So long after this as 1584, **Stanihurst** tells us that such of the Irish chieftains as possessed castles annexed to them a large mud cabin, in which they dwelt, only retreating to the castle at night for security. To the present day the same feeling exists; and it is no uncommon circumstance for a peasant, on a principle of comfort, to strip the slates off the cottage of which lie has become the tenant and replace them with thatch, alleging as his reason ‘the *couldness* of the slates,’ though most probably, owing to his slovenly method of thatching, the wind and rain are admitted through numerous crevices. To an English observer this practice must appear absurd — but it is nevertheless characteristic.


‘The fern forms and fern tables’ of O'Neil, spread under the stately canopy of heaven, are mentioned by Sir John Harrington, who wrote about fifteen years after **Stanihurst**.


**Dr. Smith**, in his History of Cork, gives an inscription discovered on a chimney-piece in throwing down some old walls at Castle Lyons. ‘Lehan O'Cullane Hoc fecit MCIIII.’ This has been repeatedly produced as proof that stone dwellings were used by the Irish in the twelfth century; but the inscription on which an assertion so important has been grounded appears to me either to have been inaccurately copied, the C being substituted for D, or that letter having 



---

p.264




been reversed in the original, thus , and the perpendicular line defaced, as neither the style nor expression of this legend belongs to the period to which **Dr. Smith** would refer it; had it been engraven at that time, the characters (waving the probability of the inscription being in Irish) could not have been deciphered with so much facility by the Doctor; and if the reading of 1504 be admitted it will be found in accordance with the taste and manner of that age.


From the landing of the English, down to the time of Elizabeth, castles rapidly multiplied in Ireland — the English settlers gradually connected themselves with the natives and assimilated to most of their habits; but the Irish seem to have availed themselves of the English mode of defence, and at every opportunity to have destroyed or possessed themselves of the castles and fortifications formed by the English colonists, whom they regarded as invaders, and from whose dominion they sought, by a series of insurrections, to emancipate themselves.


In 1438 an act was passed directing the inclosure of all towns and villages within the Pale, as a protection against the frequent attacks of the Irish.


The achievements of Thomas O'Reilly, a native chieftain, who ruined no less than eighteen castles belonging to the English, are celebrated in some Irish verses still extant, commencing ‘The wailing of the English mourner over the losses of Englishmen is a sound that I lament not.’ And when the town of Athenry in the county **Galway** was burned by a party of Irish in the reign of Elizabeth, whose fury spared not even the church, the leader, on being told that this building contained the bones of his mother, ferociously replied, ‘I care not — were she alive I would sooner burn her and it together than that any English churl should fortify there.’ It was even proposed in the parliament assembled at **Dublin** by James II. during his last struggle for the crown of England, and the motion is upon record, ‘that all the fine houses and every thing that looked 



---

p.265




like improvement should be destroyed,’ that Ireland might thus seem a country unworthy of conquest. Notwithstanding this system of destruction, every defile became protected and every important position occupied by towers that, in a time when the art of gunnery was imperfectly understood, appeared to present impregnable barriers. These fortresses, though numerous, were inconsiderable, and few of them now deserve notice except as picturesque and romantic objects.


From some elevated stations the ruins of so many as ten or twelve castles may be often comprehended in the same view. When one of these towers is within sight of another, the peasant who follows the visitor usually relates a traditionary anecdote of their being built by two sisters who held a kind of telegraphic communication. Dean Story has recorded the legend with great minuteness: ‘they say,’ writes that author, ‘in former times two Brehons, or Irish judges, lived in those two castles, who happened at last to have some disputes about their properties, and their wives, though they were sisters, used to stand upon the battlements of their own houses and scold at one another for several hours together: which at length one of them being weary of, she found out a trick only to appear and begin the fray, then she would place an image that she had dressed up in her own clothes in such a posture as her sister could not discern it from herself at that distance, who not sensible of the cheat, used to scold on, and at last fretted herself to death because she could not be answered in her own language. But I am afraid,’ adds the Dean, ‘the women in this country will scarce pardon this story.’


Throughout the majority of Irish castles there is the same uniformity of plan; their extent seldom exceeded a single square tower of three or four stories, the confined and gloomy chambers of which were lighted through a massive wall by narrow loop holes. An intrenched or walled plot of ground called the bawn surrounded or adjoined the tower, into which the cattle were driven at night to 



---

p.266




secure them from wolves, or the almost as rapacious neighbouring chieftains. The bawn also afforded protection, in times of danger, to the followers of the owner of the castle; and, in the internal feuds which continually harassed and distracted Ireland, when one chief invaded or appeared with a hostile disposition on the possessions of another, the clan immediately fled with their cattle to the bawn of their lord's castle for refuge.



> 1. By force not law men held uncertain wealth,
>   
> And neighbouring chiefs for plunder or for pride,
>   
> Their vassals mustering on each other's powers,
>   
> Waged petty war! Hence all those tall remains
>   
> Of former strength that mid our verdant fields
>   
> Stand venerable!
> 




In the square tower, tradition points out, and probably with correctness, the upper story as the best or state apartment; for each story seldom contained more than one room, having, in the thickness of the wall, recesses for sleeping in.


Such were the dwellings of the leading men of Ireland for nearly four centuries, many of which were attacked and ruined during the turbulent reign of Elizabeth.[34](javascript:footNote('E820000-001/note034.html')) The fact that the massive walls of a dismal tower afforded but feeble protection against an enemy before whose cannon the embattled keep crumbled into ruins, seems to have given rise to a new species of national architecture, modelled upon the ancient English manor-house, retaining, however, the same solidity of style as these castles, which, about the year 1600, began to be disused, from the faith in their security being 



---

p.267




destroyed. Of the taste at this period the town of **Kilmallock** is perhaps the finest specimen in Ireland, that town 


> 1. most fayre, that long a building was,
>   
> Where now, God wot, there growes nothing but grasse,
>   
> The stones lye waste, the walles seeme but a shell
>   
> Of little worth, where once a prince might dwell.
> 




Scattered through the south of Ireland the walls of these castellated houses, or courts as they are sometimes called, may be seen in the proportion to the single tower of one to four, the commanding situations selected for which still implied a feeling of insecurity. Their most peculiar feature is a large marble chimney piece, about twelve feet in height and ten in breadth, well carved, and generally bearing the date of the building and initials of the builder's name, the family arms and a religious or historical inscription. These houses gave place, in the reign of William III., to the heavy red brick mansion, with its avenues of venerable trees, which is now the hospitable abode of the resident landholder, or the forsaken and neglected patrimony of the absentee.


So numerous are abandoned edifices in Ireland, that they keep alive a train of melancholy ideas in the mind of the traveller. They who reared these piles and filled their rooms with mirth, who gave plenty and employment to the poor, are now in their tombs; and their living successors, dead to their patriotism, dwell in other lands, and leave the home of their ancestors a wilderness, where long rows of majestic oak and elm appear destined only for the axe. Every one must wish such absentees could be made to reside in their own country — to enrich it with their fortunes, ornament it with their taste, improve the morals of the people by their example, refine them by their politeness, and protect them by their authority — then might we hope to see the laws respected, the rich beloved, and Ireland tranquil and happy.[35](javascript:footNote('E820000-001/note035.html'))


---

p.268




The monastic buildings of Ireland, to those accustomed to the magnificence of similar continental or English works, are coarse and meagre, and in their style set classification completely at defiance. Every architect seems to have pursued his own taste rather than that of any particular period, and in some instances to have built in opposition to every thing approaching to system. The manner of masonry followed in most of the old religious houses is accurately described in **Mr. Townshend**'s Statistical Survey of the County of Cork, and I cannot do better than quote the words of that gentleman.


‘Each wall is composed of a double range of large stones, having one fair or flat side, which, being brought to the face of the wall both within and without, gives it at a little distance the appearance of being built with hewn stone. In other respects, the stones are of an unfavourable shape for laying, being of a lumpish and irregular form, except on the flat side. As none of them reach far into the wall, or have what masons call a good bed, it was necessary to its durability that they should be well cemented; this was effectually done by means of a very strong mortar, composed of small stones, gravel and lime, with which the central part of the wall is filled.’ The same kind of masonry is found in many of the old castles, and, when the thickness of the wall was considerable, the centre was merely filled by small rubbish stones thrown loosely between the crevices.


The number of monastic foundations in Ireland, including hospitals, friaries and chantries, may be estimated at about 1500; the ruins of between seven and eight hundred of which are still in existance. Both hospitals and friaries were simple, heavy buildings, 



---

p.269




without ornament or embellishment of any kind. The former were houses under the direction of monks of the order of St. Augustine, and, as their name implies, were intended as retreats for the indigent and impotent. Many buildings of this description were devoted solely to the reception of lepers, and fell into disuse and ruin on the disappearance of leprosy in the country.[36](javascript:footNote('E820000-001/note036.html'))


The old name of **Castle Martyr**, a village in the county **Cork**, was **Leper's Town**, and in particular the province of **Munster** is stated to have formerly abounded with persons afflicted by this loathsome disease. **Dr. Boate**, in his Natural History of Ireland, attributes the miserable state of leprosy that prevailed in **Munster**, to ‘the foul gluttony of the inhabitants in the devouring of unwholesome salmons;’ and accounts for its suppression by the strict observance of severe laws made by the English, against taking that fish during the spawning season. Some authors have ascribed so severe a national affliction to the almost raw state in which the Irish used to eat their animal food. 


> 1. 'Twas blood-raw meat
>   
> Which they for constant food did eat,
>   
> Affirming that all meat was spoil'd,
>   
> That either roasted was, or boil'd!
> 

 

It is also known, that pork induces cutaneous diseases, and of this meat, it appears from many writers, the Irish possessed abundance and were insatiably fond. An anecdote is related of a guest of O'Neil's, who asked one of that chieftain's attendants whether veal was not more delicate than pork — The reply was, ‘that question is, as if you asked me, am I more noble than O'Neil?’




---

p.270


Friaries were the dwellings of mendicants, and had seldom any endowment; notwithstanding which, they were respectably supported by the ingenuity of the fraternity. An instance of this occurs in a memorial from some Irish friars to the Pretender, beseeching his majesty to pay a debt of a thousand crowns due by their order; and, to enforce their request, they add, ‘when that sum is paid, we will then be in a condition to pray more devoutly — more fervently — and more effectually for your majesty's restoration and welfare.’ It may not be irrelevant to add, that, as a piece of policy, the money was paid by the Stuarts, and it is evident their cause derived considerable support from such agency.


Chantries were shrines or little chapels, attached to larger buildings, or standing unconnected and alone; they were founded and endowed by the opulent for the maintenance of a priest, to perform masses for the benefit of the founder's soul; and hence their name, from the chaunting of the ceremony.


The old parochial chapels should not be forgotten in enumerating the buildings of Ireland; the roofless walls and gable ends of which are very generally to be seen, 


> 1. the grandeur-loving ivy wound,
>   
> In folds of never-fading green around,
>   
> Preserving the rude mass it crowns.
> 

 

The dimensions of these chapels are extremely confined; the measurement of one at Rathcooney near **Glenmire** will serve as an example. It is forty-two feet in length, and twenty-one in breadth, and has, beside that at the east end, two small and narrow windows on the south, and one on the north side: some chapels are of still lesser dimensions. In the thickness of the wall on the right hand side of the altar is commonly a hollow space, three or four feet square, about eighteen or twenty inches in depth, where the 



---

p.271




priest's vestments, the mass books and the holy chalice were deposited.


The **Rock of Cashel** and the Abbey of **Holy Cross**, both in the county **Tipperary**, are said to be the finest architectural remains in the south of Ireland. The former I have visited, but, as it is many years since, and my examination was hurried, I am not enabled to speak of it with as much precision as I could wish. As far as my recollection serves, it is the most extensive building with any claim to antiquity that I have seen in Ireland. Seated on a rocky eminence close to the town of Cashel, this venerable pile is supposed to have been at once a regal and monastic edifice, and from the want of regularity in plan, as well as peculiarities in the manner of ornamenting and style of workmanship, appears to have been the work of several different periods.


The form of the main body, like that of most cathedrals, is a cross; its extreme length from west to east about two hundred feet. Joining the eastern angle of the north transept is a round tower, similar to those usually found detached, and evidently constructed at a much earlier date than most other parts of the building with which it is connected. The entrance to this tower is by a long gallery or passage in the wall of the transept, about twenty feet above the ground. On the opposite side, sheltered under the other transept or arm of the cross, and at an angle with the choir and chancel, is Cormac's chapel, ‘itself an host,’ to use the expression of Sir Richard Hoare, in point of remote and singular antiquity. Semi-circular arches ornamented with an abundance of carving, and small, heavy, circular columns form the peculiarities of Cormac's chapel, the interior of which is in excellent preservation, being protected from exposure to the weather by its stone roof. I know not where to refer the reader for an accurate and satisfactory account of the **Rock of Cashel**, although there are few writers on Irish history, topography, or antiquity, by whom it is not frequently mentioned.




---

p.272


The ‘right famous’ abbey of **Holy Cross**, as **Camden** calls it, is so minutely described in a letter addressed to me by a friend whose general correctness may be depended on, that I transcribe his words, as the best description I am acquainted with.


‘The main body of **Holy Cross** Abbey is still in tolerable preservation, its tower forming a fine centre. To the right of the ancient entrance were the cloisters, of which no vestiges are visible, except two rows of cells; the ground once occupied by them is now planted with potatoes, which an old woman, 

*The sad historian of the pensive place,’’*

The Deserted Village, Oliver Goldsmith

 

with the usual ignorance of such persons, points out as having been the monks' flower-garden.’
‘Beyond the cloisters were various other buildings, the naked walls of which remain, but the rain prevented our ascertaining their former destinations. To the left are also considerable ruins, which we were equally unable to visit. The extreme length of the Abbey church is about one hundred and sixty-two feet, and that of the transepts eighty-seven feet.[37](javascript:footNote('E820000-001/note037.html')) The nave has four arches on each side, which were originally built sharp pointed and then rounded. The roof of the transepts and the four chapels off them is still perfect, and formed by Gothic arches resting on corbels, with from seven to eleven cross-springers or ribs.’


‘Unaccustomed to any thing of the kind, Irish visitors look up to this roof as the perfection of architecture; but to the English traveller it will appear clumsy, and, from the want of ornament, comparatively poor. The cross-springers in the north transept indeed are curious, having a prickly surface like the stem of a briar. Possibly this part was consecrated to some peculiar commemoration of our Saviour's passion. The east window is very fine and remains in good preservation. 



---

p.273




Not far from the altar against the south wall is a tomb profusely ornamented, above and below, with rich tabernacle work coarsely executed. Beneath this, the bones of the founder, Donald or Donough O'Brien, king of **Limerick**, are said to rest.’


‘The division between the small chapels on the south side of the choir is by a double row of pillars, forming a kind of open tomb, called the Priest's Wake, from a tradition that the coffins of the clergy remained in it the night previous to interment, which is not improbable. From hence we ascended by a narrow staircase to the apartments over the chapels, to which various, and possibly very erroneous names are now attached, and with some difficulty we made our way to the top of the tower. It commands an extensive and beautiful prospect, including the **Rock of Cashel**, distant about twelve miles. But the stormy sky cautioned us to seek for shelter, and we had scarcely reached the choir when the storm was renewed with increased violence. The old woman, our guide, crouched on a low tomb to tell her beads, and my companion and I were left to our silent meditations. The rain poured down in torrents, rattling over our heads, beating and splashing against the walls in front, and streaming from off them and the flat grave-stones which covered the whole surface of the abbey; while the wind in furious gusts drove it in clouds of mist through the open tracery of the chapel window upon us; and the slow, harsh, hollow creaking of the boughs of the old trees was an accompaniment in unison with the dreary and melancholy scene around us.’


In closing these remarks on the ancient buildings of Ireland, it is scarcely necessary to observe, that, notwithstanding their number, little exists to reward the inquiry of the architect. The agitated state of the country for a series of ages may be read in the works of defence with which Ireland is said to have been ‘sown,’ and this very circumstance appears to be a fair reason why so little attention was paid to architectural embellishment. The irregularity observable 



---

p.274




in the ancient ecclesiastical edifices may be attributed to the same cause; as it is highly probable, that the unsettled state of the times produced continual interruptions to the execution of any extensive works, and that they were performed at various periods and by different hands, the architects building according to their own plan, instead of falling into that of their predecessor; this appears to be the only mode of reconciling the wild and whimsical varieties of style that are to be found. Moorish and Grecian, Saxon and Gothic peculiarities are sometimes jumbled in the strangest combinations, and with the most singular effect. To a mind schooled in the knowledge of orders and the classification of relative ages, such associations are frequently very ludicrous, as much so as the appearance at the present day of a school-boy with 

*A wisdom-giving wig — from barber bought 
For judge’’*

 

or of a grave prelate in the cap and coat of a Christ's Hospital scholar.


---

p.275


The River **Lee**
-----------------



> 1. The river side I choose
>   
> And all its mazes, from the secret spring
>   
> Along the grassy bank and shrubby bourne
>   
> By cliff and crag, to where the freighted barque
>   
> Rides fearless.
> 


**Millikin**'s River Side.


A pilgrimage to the source of the River **Lee** is one frequently performed by two very different classes of persons, the superstitious and the curious; the first led by a traditional sanctity attached to the place, the latter by the reputed sublimity of its scenery, and a desire of witnessing the religious assemblies and ceremonies of the peasantry.


This river, the Luvius of **Ptolemy**, has its origin thirty-three miles west of **Cork**, in a lake called Gougaun Barra, in English, Barry's Hermitage; St. Fineen Bar, or Barry, having, it is said, lived a recluse here, before he founded the cathedral of **Cork**. A popular legend ascribes the foundation of that building to the following circumstance: St. Patrick, at his general banishment of all venemous creatures out of Ireland, forgot an enormous monster described as a 



---

p.276




dragon or winged serpent, which wasted the surrounding country, and power was deputed to a holy man named Fineen Bar, to drown this monster in Gougaun Lake, on the condition of his erecting a church where its waters met the tide; and the saint, having destroyed the monster, fulfilled the agreement by founding the present cathedral of **Cork**.


The scenery of Gougaun Lake is bold and rugged, yet will scarcely afford the artist a suitable return for the labour of his journey. Surrounded by rocky and barren mountains, which rise with an air of desolate grandeur above the lake, in its centre is a small and solitary island, connected with the shore by a narrow artificial causeway, constructed to facilitate the rites of religious devotees, who annually flock thither on the 24th of June, (St. John's day,) to the celebration of a pious festival.


On this island, shaded by a few fine trees, some old walls may be seen, chiefly the work of an ascetic named O'Mahony, who retired from the world, and dwelt a recluse here for eight-and-twenty years, and who lies buried under a little arched recess on the shore of the lake.


**Smith**, in his History of Cork, mentions an inscription on this tomb, which I copy from that author, but could not discover the original. 

*Hoc sibi et successoribus suis in câdem vocatione monumentum imposuit dominus Doctor Dyonisius O'Mahony presbyter licet indignus, An. Dom. 1700.’’*

**Smith**, History of Cork. (1750)


The principal building on the island is a rudely formed circular wall of considerable solidity, in the thickness of which are nine arched recesses or cells, called chapels, severally dedicated to particular saints, with a plain flag stone set up in each as an altar.


In the centre of this enclosure, on a grassy elevation, that appears to have been formerly surrounded by stone steps, stands a wooden pole, the upright remains of a large cross, braced with many pieces 



---

p.277




of iron. Hundreds of votive rags and bandages are nailed against it, and hung upon it, by those whose faith has made them whole, intended as acknowledgments of their cure. Also the spancels of cattle that have been driven through the lake, as a preventive against the murrain.


Without this circular wall are the ruins of Father O'Mahony's dwelling; the gable ends and tottering chimneys still remain, covered with stonecrop, a variety of rich lichens, and that hardy little plant the London pride, which is here indigenous, and seems to grow more luxuriantly in the crevices and upon the naked rocks about Gougaun Lake, than when cultivated in a garden. The digitalis also flourishes profusely on the neighbouring mountains.


My first visit to Gougaun Lake was on the 23d of June, 1813, the eve of St. John. Feeling a strong wish to be present at the celebration of an Irish patron, or religious meeting in remembrance of a particular saint — a mere boy at the time, I had toiled through a long and an arduous walk in company with one whose pen would more ably than mine have done justice to the scene.


For the last three miles, our road, or rather path, was up the side of steep acclivities, thence upon ranges of stone steps, over dreary mountainous swamps, and we were frequently obliged to quit the common track, in order to seek amongst the rushes for more secure footing. Large blocks of schistus rock lay scattered around, many of which at a little distance appeared like vast ruins; nor was there one tree or bush within view to destroy the appearance of entire neglect and desolation. After a walk of about seven Irish miles from the village of Inchegeela, we gained the brow of a mountain, and beheld the Lake of Gougaun with its little wooded island beneath us; one spot on its shore, swarming with people, appeared, from our elevated situation, to be a dark mass surrounded by moving specks, which continually merged into it. On our descent we caught the distant and indistinct murmur of the multitude; and as we approached and 



---

p.278




forded the eastern extremity of the lake, where its waters discharge themselves through a narrow and precipitous channel, an unseemly uproar burst upon us, though at a distance of nearly half a mile from the assembly. It was not without difficulty that we forced our way through the crowd on the shore of the lake, to the wall of the chapels on the island, where we stood amid an immense concourse of people: the interior of the cells were filled with men and women in various acts of devotion, almost all of them on their knees; some, with hands uplifted, prayed in loud voices, using considerable gesticulation, and others, in a less noisy manner, rapidly counted the beads of their rosary, or, as it is called by the Irish peasant, their pathereen, with much apparent fervour; or, as a substitute for beads, threw from one hand into the other, small pebbles to mark the number of prayers they had repeated; whilst such of the men as were not furnished with other means kept their reckoning by cutting a notch on their cudgel, or on a piece of stick provided for the purpose.


To a piece of rusty iron, shaped thus, considerable importance seems to have been attached; it passed from one devotee to another with much ceremony. The form consisted in placing it three times, with a short prayer, across the head of the nearest person, to whom it was then handed, and who went through the same ceremony with the next to him, and thus it circulated from one to the other.


The crowd in the chapels every moment increasing, it became a matter of labour to force our way towards the shore, through the throng that covered the causeway. Adjoining the causeway, part of the water of the lake was inclosed and covered in as a well, by which name it was distinguished. On gaining the back of the well we observed a man, apparently of the mendicant order, describing, on a particular stone in its wall, the figure of a cross, with small pieces of 



---

p.279




slate, which he afterwards sold to such devotees as were desirous of possessing these relics.[38](javascript:footNote('E820000-001/note038.html'))Small printed Prayers were also sold at these meetings; one which I purchased is copied verbatim. 

> 
> ‘Copy of a prayer to be said at the well of St. John's.’
> 
> 
> ‘O almighty God, as I have undertaken this journey by way of Pilgrimage in and through a penitential spirit, in the first place, I hope to render myself worthy of the favor I mean to ask, to avoid drunkenness, and licentiousness, and hope to find favor in thy sight. I therefore pay this tribute and fulfil the promise I have made, I ask you, therefore, thro' the intercession of Saint John, to grant me the following favor — (here mention your ailment, the particular favor you stand in need of) — I know how unworthy I am of being heard, but I resolve, with thy gracious assistance, henceforward to render myself worthy of your favor, I implore this gift, through the intercession of St. John, and the sufferings of Christ our Lord. Amen.’
> 
> 
> ‘N.B. You must be careful to avoid all excess in drinking — dancing in tents — for it is impossible characters can find favor in the sight of God, such as these. — Fasting going there had formerly been the custom.’
> 
> 
> 




The number of slates thus treated at various periods, had worn in the stone to which they were applied a cross nearly two inches in depth, and which every new sign served to deepen. The door or opening to the front of the well was so narrow as scarcely to admit two persons at the same time. Within, the well was crowded to excess, probably seven or eight persons, some with their arms, some with their legs thrust down into the water, exhibiting the most disgusting sores and shocking infirmities. When those within came out, their places were as instantly filled by others. Some there were who had waited two or three hours before they could obtain access to this ‘healing fount.’ The blind, the cripple, and the infirm jostled and retarded each other in their efforts to approach; whilst women and boys forced their way about, offering the polluted water of the well for sale, in little glass bottles, the bottom of broken jugs and scallop shells, to those whose strength did not permit them to gain this sacred spot. The water so offered was eagerly purchased, in 



---

p.280




some instances applied to the diseased part, and in others drank with the eagerness of enthusiasm. In the crowd, mothers stood with their naked children in their arms, anxiously waiting the moment when an opening might allow them to plunge their struggling and shrieking infants into the waters of the well. Were this all, I could have beheld the assembly with feelings of devotion mixed with regret at their infatuation and delusion; but drunken men and the most depraved women mingled with those whose ideas of piety brought them to this spot; and a confused uproar of prayers and oaths, of sanctity and blasphemy sounded in the same instant on the ear.


We left this scene, so calculated to excite compassion and horror, and turned towards the banks of the lake, where whiskey, porter, bread and salmon were sold in booths or tents resembling a gipsy encampment, and formed by means of poles or branches of trees meeting at angles, over which were thrown the proprietor's great coat, his wife's cloak, old blankets, quilts, and occasionally a little straw. Above the entrance of each was suspended the name of the owner, if he happened to possess a license; when this was not the case, a jug, a bottle, or pipe were displayed to indicate that spirits and porter might be had within, and not unfrequently were added a piece of ribbon, and an old shoe, the first to distinguish some popular party, the latter emblematic of dancing, to which amusement the lower orders of Irish are immoderately attached.


Almost every tent had its piper, and two or three young men and women dancing the jig, or a peculiar kind of dance, called the rinkafadah, which consists of movements by no means graceless or inelegant. The women invariably selected their partners, and went up to the man of their choice, to whom they freely presented their hand. After the dance was concluded, the men dropped a penny each, or, such as were inclined to display their liberality, something more, into an old hat which lay at the piper's feet, or in a hollow made in the ground for the purpose. The piper, who seldom makes 



---

p.281




a moment's pause, continues playing, and another dance immediately commences. I recollect having seen, in **Cork**, a painting by **Grogan**, (a native artist,) of the breaking up of an Irish fair, in which he has happily expressed the ceaseless motion of the musician's fingers on such occasions by the introduction of a man holding a jug of porter to the piper's lips, which he drinks without interruption to the dance.


The tents are generally so crowded that the dancers have scarcely room for their performance: from twenty to thirty men and women are often huddled together in each, and the circulation of porter and whiskey amongst the various groups is soon evident in its effects. All become actors, — none spectators, — rebellious songs, in the Irish language, are loudly vociferated, and received with yells of applause: towards evening the tumult increases, and intoxication becomes almost universal. Cudgels are brandished, the shrieks of women and the piercing cry of children thrill painfully upon the ear in the riot and uproar of the scene; indeed the distraction and tumult of a patron cannot be described. At midnight the assembly became somewhat less noisy and confused, but the chapels were still crowded: on the shore, people lay ‘heads and points’ so closely, that it was impossible to move without trampling on them; the washing and bathing in the well still continued, and the dancing, drinking, roaring, and singing were, in some degree, kept up throughout the night. The effect produced by fires lighted early in the evening on the highest points of the surrounding mountains, and reflected in the dark bosom of the lake, was very impressive. Lighting fires, however, on the eve of St. John has not any peculiar reference to the celebration of the patron, being a popular custom of remote antiquity and a remain of Pagan rites in honour of the sun. The eve of St. John, (the longest day,) and May eve, are still marked by a variety of superstitious ceremonies. Formerly, the fire in every peasant's habitation was extinguished on the annual festival of May eve, and 



---

p.282




rekindled with a spark obtained from the sacred fire of Beal, so was the Spirit of Flame termed, and hence the month of May is called, in the Irish language, ‘mi na Beal-tine.’ This scene I have minutely described, as it affords a faithful picture of the patron, or well-worship of the Irish peasantry. In the rural superstition attached to wells there is something highly poetic; and however these ceremonies may have fallen into abuse, I cannot regard with indifference or scepticism the devotional rites performed by the humble cottager at those sequestered spots. The belief of a latent healing virtue in the trickling lymph of a fountain is that of a mind naturally innocent and pious. In the early ages of Christianity such lonely places, remote from the hand of persecution, were selected by the inspired teachers of religion to unfold their glorious doctrine, and at these primitive fonts converts received the first rites of the church.


‘Hence came those wells in many countries to bear the name of some patron saint, who, while the gorgeous temples of the earth were devoted to falsehood and licentiousness, e'rected on their grassy margin the shrine of immortality.’


Consecrated or holy wells are very numerous throughout Ireland, and are usually situated in solitary nooks, shaded by a group of venerable ash, elm, or sycamore trees; the spring is walled, or, if I might use the term, hooded over; and above the entrance is a large flag-stone embedded in the wall, marked with the figure of a cross or some piece of devout sculpture; near these wells little altars or shrines are frequently constructed, often in the rudest manner, and, kneeling before them, the Irish peasant is seen offering up his prayers with that worldly abstraction which proceeds only from the strength of religious faith, undisturbed by the casual visitor, and seemingly unconscious of the presence of an intrusive spectator. There is so little ostentation in these rites, and so much solemnity, silence, and beauty in the secluded scenes where they are performed, that the heart cannot refuse to sympathize in feelings of devotion: but these 



---

p.283




are destroyed by the disgraceful riot of the patron, a meeting that seems established only to profane all that is impressive, simple, and pious.


On my second visit to **Gougaun**, in 1815, I perceived a large stone which had been set up on the island, with a long inscription stating the number of prayers to be repeated at each of the cells, or chapels, and other directions of a similar kind: but about this time, these meetings were publicly discountenanced by the Roman Catholic clergy, and in 1818, Dr. Murphy, the titular Bishop of Cork, expressly forbad that of **Gougaun**. This special interference became necessary, from the fatal consequences attendant on them, as one seldom concluded without the loss of many lives; and patrons were professedly selected for the purpose of contest, by hostile factions or clans that met, and, when the rites of devotion were ended, fought 


> 1. in all the rage
>   
> Of family dissension kindled fell,
>   
> Through wide-extended consanguinity!
> 




The rocky outlet of the water of the lake, in some places, is not more than three or four feet wide 


> 1. Amid heaps
>   
> Of mountain wreck, on either side thrown high,
>   
> The wide-spread traces of its wintry might,
>   
> The tortuous channel winds o'er beds of sand:
>   
> Here silently it flows — there from the rock
>   
> Rebutted, curls and eddies — plunges here
>   
> Precipitate — there, roaring among crags,
>   
> It leaps and foams and whirls and hurries on.
> 




This stream is increased by the accession of several mountain rills, which after heavy rains become formidable torrents, and proceeding over a tract of low ground spreads into a large sheet of water, called Lough Allua or Lua, extending nearly four miles in 



---

p.284




length, and in some parts about a mile in breadth. The new road to Bantry winds beautifully along the shore of this lake, but the want of wood and cultivation give an air of savageness to the scenery. Having a boy with us who carried a blunderbuss, we tried the effect of several discharges at Gougaun Lake, and found the echo produced by the reverberations astonishingly fine; the sound rolling like peals of the loudest thunder around the whole amphitheatre of mountains, again and again returning, until at last it died away in the distance. We proved the power of the echoes from almost every position on the surrounding hills; the best appeared to be from the point whence we first saw the lake.


It is remarkable, that the river **Lee**, as far as Inchegeela, is never muddy, even in the most violent floods; the cause is probably owing to the rocky nature of the ground through which its course lies. The little village of Inchegeela, as nearly as I can judge, is distant from Gougaun Lake ten English miles, and is the usual approach to it. The walls of a barrack, which has been long disused, are all that speak the former consequence of Inchegeela; its church and parsonage are inconsiderable and ruinous, and at the distance of a mile, on a small height above the river, stands the Castle of Carrinacurra, now called Castle Masters, being the property of Mr. Masters, who built a dwelling house close by. It is backed by considerable mountains; the most prominent is Sheehy, whose blue peak 

*A doubtful object mingling with the clouds!’’*



towers above all the others, the chief of which are Douse, an enormous and heavy lump, and Coolnagreenane, or the mountain unknown to the sunbeams, a name highly descriptive of its general gloomy appearance: behind these, the rugged points of Carrigaprehaun, or the Raven's Rock, may be distinguished boldly eminent over Lough Lua.


---

p.285


Carrinacurra Castle belonged to the O'Learies, and the barony of Ivelary, in which it is situated, has received its name from this family, notwithstanding the Learies were a dependent or minor clan, having neither numbers nor possessions sufficient to render them important.


Dermot Oge O'Leary, of Carrinacurra, was accused of being concerned in the Earl of Desmond's rebellion; and, in 1588, was 
attainted, amongst others, by act of parliament: and Conogher O'Leary again forfeited this castle and estate in 1641, when it was garrisoned by order of **Cromwell**.


Following the course of the river **Lee**, in its progress nearly due east towards the ocean, the ruins of Drumcaragh Castle may be seen, another fortress erected by the O'Learies; and not far distant is Toomb Bridge, a long and narrow pass over an extensive and swampy flat, through which the **Lee** meanders, embracing numerous little islands covered with the bog myrtle and stunted timber. Rising above Toomb Bridge is a steep and considerable hill, on the top of which stands Dundarerk Castle, built by the Mac Carthies, and forfeited by Dermot Mac Carty in 1641. It commands a view of an immense tract of country, in which the appearance of cultivation is scattered and unequal. 


> 1. To the extended gaze
>   
> Is seen the river wandering far away
>   
> Through sun and shade, with peopled bank or bare,
>   
> Verdant, or brown.
> 




Leaving the **Lee** for a short space, as its course here becomes less interesting, and descending the opposite side of the hill, the river Sullane, which falls into the **Lee** below **Macroom**, appears winding through the low ground beneath, and not far from its craggy channel the ruin of a large square tower becomes an imposing and important object. This ruin is the Castle of Carrig a Phooky, or the 



---

p.286




Rock of the Spirit, a fortress of the Mac Carthies, to which the repentant Teg Mac Cormac Carty retreated, after his desertion to the Spaniards at **Kinsale**, and from whence he petitioned Sir George Carew, the Lord President of **Munster**, for pardon; which was followed by the impeachment of his cousin, the Lord Muskery. A rocky stream, called the Foherish, not far distant, falls into the Sullane, and affords many picturesque subjects for the pencil.


**Macroom**, eighteen miles west of **Cork**, is a straggling town composed almost entirely of mud cabins. Its castle, bridge and church, however, form rather a respectable group. The castle is a considerable pile, and its building has been attributed to King John, when he visited Ireland; soon after, it became a fortress of the Mac Carthies, Lords of Muskery, and its history is identified with the fortunes of that family.


The mail coach road to **Cork** from **Macroom** runs on the south side of the River **Lee**, and passes near the walls of Castle More, an extensive ruin formerly belonging to the clan of Barrett. There is also a road on the north of the river, which leads through a wooded and romantic defile, called Glen Caum or the crooked Glen, to the miserable village of Carrigadrohid, or the rock of the bridge, where the walls of a castle stand on a rock in the centre of the river, over which is a stone bridge that adjoins the castle.


Conflicting traditions name Carrigadrohid Castle as belonging both to the Mac Carthies and to the O'Learies, and it does not appear improbable that both may be correct, as the O'Learies, compared with the Mac Carthies, were an inconsiderable clan and dependent on them; this castle, therefore, may have been bestowed by the former, to secure the attachment of the latter. The choice of the situation is attributed in a chivalric anecdote to the lady O'Carroll, wife of one of the Mac Carthies. In 1641, Carrigadrohid, according to **Smith**, was considered a pass of much importance, and was often taken and retaken by the contending parties of that period.




---

p.287


Crossing the river **Lee**, and following the mail coach road to **Cork**, the castle and abbey of **Kilcrea** are seen on the southern bank of the River Bride, which falls into the **Lee** at **Inniscarra**.


**Kilcrea Abbey** was founded by Cormac Lord Muskery, towards the close of the fifteenth century, for Franciscans, and is an extensive building without much architectural embellishment. It seems to have been the favourite burial-place of most of the neighbouring Irish septs, the Mac Carthies, Barretts, O'Learies, Reardins, and Sweenys having tombs here. The grave of Arthur O'Leary, the outlaw, is particularly pointed out to the attention of visitors; and there is a long epitaph in verse engraven on it: 


> 1. Low Arthur Leary, handsome, young and brave,
>   
> Slain in his prime, lies in this lowly grave, [&c.]
> 




The early part of O'Leary's life was spent in the military service of France. He returned to his native country about fifty years since, and soon possessed so much influence amongst the peasantry, as to excite the jealousy of a gentleman named Morris; a quarrel originating in some private circumstances ensued, which terminated in the most deadly enmity on the part of Mr. Morris towards O'Leary.


By the penal laws against the Catholics, it was forbidden any one of that persuasion to possess a horse whose value should be more than five pounds; and this law, though it had fallen into disuse, remained unrepealed.


O'Leary was a Catholic, and distinguished for his skill in horsemanship, as well as being the owner of the finest and most spirited horse in the country.


Mr. Morris, in company with a party of his friends, meeting 



---

p.288




O'Leary on some public occasion, rode up to him, and in the most taunting manner offered him five pounds, and desired him to dismount.


O'Leary refused to comply with this insulting proposal, a struggle followed, and he, being surrounded by the friends of Mr. Morris, was glad to owe his escape to the speed of the animal he rode; but this rencounter, being represented to government in the light of a violent and open resistance to the laws, O'Leary was proclaimed an outlaw, and a considerable reward offered for his apprehension; notwithstanding which, he continued for many months to ride publicly through the country, armed at all points, and even appeared in the city of **Cork**, where he attempted to assassinate Mr. Morris, as he stood at the window of his lodgings in Duncan Street, by firing a pistol at him.[39](javascript:footNote('E820000-001/note039.html'))


So beloved was O'Leary amongst the peasantry, that it became impossible to take him, although his retreats were well known to the military and police; and for three or four years, his popularity baffled the most active efforts of the parties constantly in pursuit of him. He was at last surprized near **Macroom**, but soon distanced his pursuers by such a space, that he conceived himself completely out of reach of their muskets, when, turning round, he waved his hat in token of defiance, and in that act was shot through the heart by a soldier.


An avenue of fine old trees leads to the entrance of Kilcrea Abbey, close to which are piled up a vast number of skulls and bones. The castle is near the abbey, and appears to have been built to protect it.


The course of the River Bride is through a small village called the Ovens, and opposite its junction with the **Lee**, stands the parish 



---

p.289




church of **Inniscarra**, beautifully situated on a bend of that river, its spire rising gracefully out of a clump of trees. The ancient name of **Inniscarra** was **Tuaimnava**, and here the celebrated St. Senant of ****Inniscattery**** founded a house, in which he placed eight of his austere disciples, but not the slightest vestige of this establishment can now be traced. Behind the church, rises an extensive and uncultivated hill called **Gorrovagh**, signifying in English rugged; I was told it was once the property of a gentleman named Dwyer, who, continued the narrator, ‘drank it acre by acre, your honour.’ ‘How could that be?’ ‘Why he just sold acre after acre for drink, until he did not leave himself one foot of all the ground as far as you can see.’


At **Ballincollig**, about four miles from **Cork**, are extensive artillery barracks, and a manufactory of gunpowder; there is also the ruin of a considerable castle that belonged to the **Barretts**, and was garrisoned both in the wars of **Cromwell** and of James II.


**Carrigrohan Castle**, a mile and a half nearer **Cork** than that of **Ballincollig**, is a castellated house, and stands on an abrupt rocky eminence over the **Lee**, from which it probably derives its name; **Carrigrohan** signifying in English a rocky, sharp pointed hill. It suffered considerable dilapidation in the disturbances of 1641, but was shortly after repaired, and became the residence of Captain Cape, a notorious Tory or Rapparee, who with a gang of desperate associates plundered travellers, and laid the neighbouring country under contribution in the most daring manner.


About twenty years since, a remarkably fine sycamore tree stood near it.


In this neighbourhood, a curious fragment, now in my possession, was dug up; it is a grotesque carving minutely executed on bone, (supposed to have been part of a human skull,) representing a dragon stirring with a pole an emaciated human figure or corpse, and between them is a label bearing the legend ‘*mittet malos in caminuignis*.’ 



---

p.290




To assign correctly the object or use of this piece of monkish labour is now a matter of impossibility, although it may once have attained extensive celebrity.


The view from **Carrigrohan Castle** is very pleasing. On the opposite hill are some respectable seats, and through a richly planted glen murmurs the **Awbeg**, a stream that passes near **Blarney** and falls into the **Lee**, which holds its tranquil course towards **Cork**, where **Spencer**, with topographical accuracy, describes 

> 1. The spreading **Lee**, that like an island fair
>   
> Encloseth Cork with his divided flood.
> 






---

p.291


**Blarney**
-----------



> 1. Slow as some miner saps th' aspiring tower,
>   
> When working secret with destructive aim,
>   
> Unseen, unheard, thus moves the stealing hour,
>   
> But works the fall of empire, pomp, and name.
> 


**Ogilvie**.


**Blarney**, so famous in Irish song and story, is situated about four miles north-west of **Cork**, and was, within these few years, a thriving manufacturing village; but it no longer wears the aspect of comfort or of business, and appears much gone to decay.


The alteration struck me very forcibly. In 1815, I remember a large square of neat cottages, and the area, a green shaded by fine old trees. Most of the cottages are now roofless; the trees have been cut down, and on my last visit, in 1821, a crop of barley was ripening in the square. 


> 1. the clam'rous rooks
>   
> Ask for their wonted seat, but ask in vain!
>   
> Their ancient home is level'd with the earth,
> 
> 
> ---
> 
> p.292
> 
> 
> Never to wave again its leafy head,
>   
> Or yield a covert to the feather'd choir,
>   
> Who now, with broken song, remote and shy,
>   
> Seek other bowers, their native branches gone!
> 




This prepared me to expect a similar change in the grounds of the castle, where much timber has been also felled; but the grounds still are beautiful, rock and water being features in the landscape, the picturesque effect of which neglect cannot injure.


The castle consists of a massive square tower, that rises broad and boldly above surrounding trees, on a precipitous rock over a stream called the **Awmartin**; and attached to the east side is an extensive dwelling-house, erected about a century since by **Sir James Jeffreys**, who purchased or obtained this estate from the crown, and in whose family it still continues.


**Blarney Castle** was built about the middle of the fifteenth century, by Cormac Mac Carty, or Carthy, surnamed Laider, or the Strong. He was descended from the Kings of Cork, and was esteemed so powerful a chieftain that the English settlers in his part of **Munster** paid him an annual tribute of forty pounds to protect them from the attacks and *insults* of the Irish. To him is also ascribed the building of the Abbey and Castle of **Kilcrea**, the Nunnery of **Ballyvacadine**, with many other religious houses; in the former of which he was buried.[40](javascript:footNote('E820000-001/note040.html')) It would be a matter of little importance and considerable labour to trace the Castle of Blarney from one possessor to another. The genealogical table in **Keating**'s History of Ireland will enable those addicted to research to follow the Mac Carty pedigree; but a tiresome repetition of names, occasioned by the scantiness of them in an exceedingly numerous family, present continual causes of perplexity 



---

p.293




to the general reader. The names of Donough, Cormac, Teig, Florence, Dermot, Owen and Donnell, constitute almost the whole catalogue used by the Mac Carties for a period exceeding six hundred years.[41](javascript:footNote('E820000-001/note041.html')) This difficulty is heightened from the entire sept being, in point of fact, without a sirname, as the followers of most chieftains in Ireland as well as Scotland assumed that of their lord. In the reign of Edward IV. a statute was enacted, commanding each individual to take upon himself a separate sirname, ‘either of his trade and faculty, or of some quality of his body or mind, or of the place where he dwelt, so that every one should be distinguished from the other.’ But this statute did not effect the object proposed, and **Spenser**, in his View of Ireland, mentions it as having become obsolete, and strongly recommends its renewal.


As a sketch of the history of the Muskery branch of the Mac Carty family affords an opportunity of illustrating many important events in the south of Ireland, perhaps no apology will be necessary for the introduction of it in the account of **Blarney**, which was their principal residence.


The original name of a sept or clan was Carty, supposed to be derived from Cartheigh, which signifies an Inhabitant of the Rock; and Mac, denoting ‘*son of*,’ was used before the father's Christian name for the purpose of distinction, as, Mac Cormac Carty expressed Carty, son of Cormac; this manner of designation appears discontinued on the introduction of a greater variety of names, and the Mac alone retained by the elder branches.


It is also necessary to remark, that the title of Muskery was 



---

p.294




assumed by the chief of that district from being lord of the soil. This also creates much confusion, as the same person is frequently called Carty, Mac Carty and Lord Muskery; and when knighthood had been conferred, the title of Muskery was still retained with that of Sir, as, Cormac Mac Teig Carty, we find styled Sir Cormac Mac Teig Carty Lord Muskery. I offer as a matter of conjecture, that the title of Earl Clancarty, conferred on the Mac Carties by **Charles II.**, had its origin in Lord of the Clan of Carty.


In 1542, an indenture of allegiance to the English laws was signed by Teig Mac Cormac Carty (*Dom de Muskery*) amongst other Irish chieftains; and in 1558, his son Dermod was knighted at **Limerick** on his submission, by Thomas Earl of Sussex, (the Lord Deputy,) who at the same time presented him with a gold chain and a gilt pair of spurs. This mark of favour was certainly merited, for the Muskery Mac Carties, unlike most other Irish clans, appear to have strictly maintained their faith with the English since the original submission of their ancestor the King of Cork to Henry II.


In 1580, Sir James of Desmond, brother to the notorious earl, entered the district of Muskery, probably stimulated, in addition to his love of plunder, by envy of Cormac Mac Teig Carty, whom the Lord Deputy Mountjoy, in a letter to the council of England, mentions, ‘for loyalty and civil deportment, to be the rarest man that ever was born among the Irishry.’ **Camden** also notices him as a person ‘of great name’ in Muskery, which is ‘a wild and woody country.’[42](javascript:footNote('E820000-001/note042.html')) But Sir James of Desmond sought his own destruction, as 



---

p.295




the Mac Carties not only defeated his party, leaving a hundred and fifty dead on the field, but took Sir James prisoner, who was delivered by order of the Lords Judges to Sir Warham St. Leger and Captain (afterwards Sir) **Walter Raleigh**, by whom, in virtue of a special commission directed to them, he was tried as a traitor, and, being found guilty, was executed, and his head and quarters fixed on the gates of Cork.


For this service Cormac Mac Teig Carty was knighted by the Lord Justice, and made High Sheriff of the County Cork, with a commission of martial law, and power to grant protection for fifteen days to any but principal rebels.


On the 21st October, 1601, Cormac Mac Dermod Carty, commonly called Lord Muskery, attacked the Spanish trenches at **Kinsale**, in command of a party of Irish, by order of Sir George Carew, (the Lord President,) and though at first he drove the invaders before him, yet his men soon retreated without much apparent cause, on which Sir William Godolphin (who went into Ireland with the unfortunate Earl of Essex) advanced and forced the Spaniards to retire. This circumstance, when so many Irish chieftains were in open rebellion, was sufficient to throw strong suspicions on the attachment of the Mac Carties to the English; and about the same time, Teg Mac Cormac Carty, cousin to the Lord Muskery, deserted from Sir George Carew's troop to the enemy; but shortly after, either through policy or repentance, he addressed a letter to the Lord President, dated from ‘Carrigafuky,’ the 9th June, 1602; a copy of which may be found in the Pacata Hibernia, expressing contrition for his conduct, and requesting, through Sir George's mediation, to be received again to the Queen's favour.


The Lord President, naturally feeling that little dependence could be placed on such a person, gave a decided refusal to his petition, and Teg Mac Cormac Carty had recourse, for procuring his pardon, to the dishonourable means of betraying the confidence of his kinsman 



---

p.296




Lord Muskery, and accused him of corresponding with the Spanish and Italian governments, and of having received from the former eight thousand ducats, for which sum he had promised to deliver his Castle of Blarney into their hands.


This information corroborating that derived from other sources, and strengthened by many circumstances, completely served to establish Lord Muskery's disaffection in the mind of the President, who concluded on apprehending him as a traitor, yet dreaded using forcible measures, knowing his clan to be one of the most powerful in Ireland, and capable of offering an obstinate resistance which would doubtless receive foreign as well as internal support. Lord Muskery was stated to have a thousand well-armed followers in readiness for action, and it was known could command the services of the clans of Reardin, Murphy, and Sweeny of Muskery, with the O'Learies, O'Mahonies, and O'Driscolls of Carbery. He was also possessed of many castles, particularly those of **Kilcrea**, **Macroom** and **Blarney**, which latter is described, at that time, as being one of the strongest in the province of **Munster**; ‘for it is four piles joined in one, seated upon a main rock, so as it is free from mining, the wall eighteen feet thick, and flanked at each corner to the best advantage.’


Stratagem was therefore resorted to, and Sir Charles Wilmot and Captain Roger Harvey with part of their companies dispatched from Cork to endeavour and surprize Blarney, but in this they failed, the warders being on the alert, who compelled them to receive without the walls some refreshment which they requested.


Lord Muskery was, however, taken, and brought before the President and council at Cork. He repelled with indignation the charge of treason — called himself a slandered and injured man — declared the whole a conspiracy of his enemies — and concluded, by renouncing all claim to favour or pardon if the charge could be supported by lawful testimony. The President replied coolly to his vehement protestations, 



---

p.297




and urged him, if guilty, freely to confess his guilt and entreat the Queen's mercy; or, if innocent, that he should deliver his Castle of Blarney into the hands of trustees, who would hold it until the charges against him were disproved. Lord Muskery hesitated, and was in consequence committed to gaol where he was detained heavily ironed. Finding himself so much in the Lord President's power, and perhaps somewhat intimidated by his temperate yet inflexible conduct, Lord Muskery at length consented to surrender up **Blarney** to Captain Taffe, in whom he reposed much confidence, on a promise of its being restored to him in an unaltered condition. His Abbey and Castle of **Kilcrea** were delivered to Capt. Francis Slingsbie, and a considerable force was sent under Captain Flower and Sir Charles Wilmot to reduce **Macroom**, from which, on account of its situation, an obstinate resistance was expected.


In the mean time Lord Muskery's wife and younger children were taken and confined at Cork, and his followers employed a confidential man named John O'Healy to convey the eldest son, Cormac Oge[43](javascript:footNote('E820000-001/note043.html')) Carty, (then a student at Oxford,) secretly from England, and to communicate with the Spanish government. The President, having received information of these plans, seized O'Healy on ship-board as he was leaving Cork Harbour, who, to prevent discovery, flung into the sea a bag containing his despatches and money, so that no secret was divulged, and no further proof than the act existed to criminate him. O'Healy was thrown into prison, and Lord Muskery more closely guarded than ever. ‘If shackles of iron, walls of stone, and force of men can make him sure,’ said his gaoler in reply to the Lord President's charge, ‘then shall my prisoner be forthcoming whensoever the state may be pleased to call for him.’ Sir George Carew's 



---

p.298




charge was repeated and enforced to the gaoler both by the Bishop of Cork and Dominick Sarsfield, the Queen's Attorney for **Munster**, who commanded him to keep Lord Muskery ‘in a handlock with his own servant, or some soldier of especial trust.’ Two days after this last caution Lord Muskery escaped! He contrived, between eight and nine o'clock in the evening, to force himself out of a window and descend into the street, where ‘were divers mantlemen to receive him.’ The alarm was given almost instantly and a vigorous pursuit commenced, but in vain — favoured by a dark night and with a perfect knowledge of the country, protected by a select band of men, (each of whom would have laid down his life in defence of their lord,) and surrounded by hundreds who were willing to favour and assist his flight, it is not surprising that having once passed the iron grate of his prison he should baffle even the most active pursuit. The President immediately issued letters to Sir Charles Wilmot (who still lay before **Macroom**) that if he could not gain the castle that night he should raise the siege and retreat the next morning; but almost in the same hour these orders arrived, Macroom Castle accidentally caught fire, and the besieged as a last resource took refuge in the bawn, where most of them (about fifty) were put to the sword.


On the news of Lord Muskery 's escape, O'Sullivan of Beare, Captain Terril and others in rebellion, offered to support him against the Lord President; but Lord Muskery, after a conference with the latter, considering that he had little prospect of ultimate success, and that both his family and estates were in the President's power, determined on making terms, and wrote requesting permission to throw himself at Sir George Carew's feet; which request was granted.


This submission was both sincere and permanent, as we find him and his clan shortly afterwards actively employed under Sir Charles Wilmot in various military exploits; and it would appear some confidence was placed in Lord Muskery, he being summoned to parliament as Baron of **Blarney**.




---

p.299


History is silent respecting the Mac Carties for about forty years. The first information, in the south of Ireland, of the insurrection of 1641, was communicated to **Lord **Cork****, during dinner time, at Castle Lyons, his son-in-law the Earl of Barry more's house, where a large company of Irish chiefs were assembled. Donough, Lord Muskery, was amongst the number, and treated the account as an exaggerated tale; but the other guests, anticipating serious consequences, separated abruptly, and returned immediately to prepare their respective residences for defence. Lord Muskery's conduct on this occasion appears an act of the deepest dissimulation; for, in a few days, he was at the head of several thousand Irish. On the death of **Sir William St. Leger**, Lord Muskery, whom Ludlow styles ‘an Irish rebel,’ assumed, or was appointed to the Presidency of **Munster** by **Charles I.**, notwithstanding the solicitations and claims of Lord Inchiquin, son-in-law to the former President, for that office, which mortified Lord Inchiquin so much, that he immediately declared for the Parliament. The character of Lord Muskery during this distracting period, when the royal and parliament parties were subdivided into many others, that more than once changed sides, and fought against the banners under which they had first appeared, was marked by a love of discipline, a high sense of honour, and strong feelings of humanity. Personal bravery can scarcely be enumerated as a virtue, when every man of that day was of necessity a soldier; and Ireland presented a scene of petty and treacherous, certainly the most dreadful state of warfare. In the beginning of 1646, **Lord Broghill, afterwards the celebrated Earl of **Orrery****, took the Castle of Blarney, which he seems subsequently to have occasionally made his quarters. A printed letter to William Lenthall, the Speaker, from **Lord Broghill**, is preserved in the British Museum, dated *Blairney*, 1st August, 1651, giving an account of a battle between him and Lord Muskery. **Smith**, in his History of Cork, also mentions a manuscript at **Lismore**


---

p.300




in his lordship's own writing, containing an account of the same battle; which is exceedingly curious and interesting.


Muskery, who had been obliged to abandon his castles and retire from the parliamentary forces into the fastnesses of **Kerry**, made an attempt to relieve **Limerick**, which was closely besieged by Ireton, when **Lord Broghill**, after manoeuvring some days, intercepted him on his march near Courtstown, sometimes called Knocknaclashy.


The features of this action are so full of romantic reality, that I cannot pass them over without a short notice, though at the risk of my narrative being considered tedious. Broghill came up with the advanced part of Musker 's force ‘about midnight, in the midst of a dreadful storm of rain and wind;’ and that night the opposing troops lay so near ‘as to see each other's fires reciprocally.’ In the morning, **Lord Broghill** advanced and crossed the river **Blackwater**, when he was met by many groups of peasantry, some of whom he questioned as to the cause of their assembling, and received for answer, that it was to witness a battle which had long been prophesied should be fought on that ground. When his lordship asked them which side was to gain the victory, they shook their heads, and said, ‘The English are to get the day.’ — ‘Our word,’ adds **Lord Broghill**, ‘was prosperity their's, St. James our signall, white, in hats — their's, greene fearne.’


It was a desperately contested fight; at one time the Irish advanced on **Lord Broghill**'s right wing with a thousand musketeers, and, to use his lordship's words, ‘with their horse, fought horse head to horse head, hacking with their swords. Not a horse officer of the Irish,’ continues **Lord Broghill**, ‘(except one) but he or his horse was killed or wounded. All the first rank in my squadron, being thirty-three, were either killed or wounded. We resolved not to give or take quarter; however, several had quarter after the battle. — Among the baggage was found a peck full of charms, relicks, &c. besides an infinite quantity taken from the dead, with a peculiar one 



---

p.301




on paper, said to be the exact measure of Our Lady's foot, and written in it, — ‘Whoever wears this, and repeats certain prayers, shall be free from gun-shot, sword, and pike,’ respectively, as each desired. Like the battle of Naesby, from a fair day it rained hard during the fight, with thunder and lightning, and afterwards cleared up again.’ **Lord Broghill** tells us, that his ‘boldest horse, being twice wounded, became so fearful, that he was turned to the coach.’


From this account it is evident the conflict was sanguinary in the extreme. Muskery is reported to ‘have escaped narrowly, and Lieutenant-Colonel Mac Gillicuddy, (who commanded young Muskery's regiment, and a man more popular than Muskery himself in his own country,) was made prisoner, with Major Mac Gillariagh, an old Spanish soldier, and other officers of note.’


‘We had a very fair execution for above three miles,’ writes **Lord Broghill**, in his letter to the Speaker, ‘and, indeed, it was bloody; for I gave orders to kill all, though some few prisoners, of good quality, were saved. All their foot field-officers charged on foot with pikes in their hands, so that few of them got off, it being too farre from any bogs or woods, which they say they selected purposely that their men might have no confidence but in their courages — but we relyed on a better strength than the arm of flesh, and when their strength failed them, our's did not fail us. Their priests, all the way before they came to fight, encouraged them by speeches, but especially by sprinkling holy water on them, and by charms, of which I herewith send you a copy,[44](javascript:footNote('E820000-001/note044.html')) (many of them were found 



---

p.302




quilted in the doublets of the dead.) Certainly they are a people strangely given over to destruction, who, though otherwise understanding enough, let themselves be still deluded by ridiculous things and by more ridiculous persons. Had I been one of the charmed, I would have first tryed mine on the priest which gave it.’


This battle hastened the surrender of **Limerick** to Ireton, who received **Lord Broghill**, on his arrival there, with a complimentary feu-de-joie. Shortly after, Lord Muskery was apprehended, and tried for his life, on the charge of having murdered several English, but, being acquitted, was allowed to pass into Spain, and an order was made by the commissioners for the parliament that Lord Muskery's lady should enjoy all her husband's estates, except a thousand a year, which had been granted to **Lord Broghill**, for his services, by order dated 8th September, 1656.


An exile, and deprived of fortune, Lord Muskery endeavoured to procure a commission in the French service, but was recalled on the Restoration, and the active part he had taken in the royal cause rewarded by his being created, in 1658, Viscount Muskery and Earl of Clancarty; and four years after, a bill of indemnity was passed by both houses of parliament, through the interest of Lord Ormond, securing all his honours and estates to him and his posterity, with the exception of that part in the possession of **Lord Broghill**, who had become a firm partizan of **Charles II.**


Lord Clancarty had three sons — Charles, Callaghan, and Justin. Charles, Lord Muskery, (a great favourite of the Duke of York, afterwards James II.) was killed in a sea-fight against the Dutch, on the 3d of June, 1665, and was buried with honours in Westminster 



---

p.303




Abbey.[45](javascript:footNote('E820000-001/note045.html')) His father survived him only two months, and the title of Clancarty descended, on the death of Charles James, the infant son of Lord Muskery, to his brother Callaghan, who had retired into a convent in France. — Callaghan, the third Earl, was succeeded by his only son, Donough. He was educated at Oxford, under the Archbishop of Canterbury, and privately married, when not sixteen, to the Earl of Sunderland's daughter, after which he went into Ireland, where he continued a protestant until the arrival of James II.


James landed at **Kinsale** on Wednesday the 12th of March, 1688, and was received and entertained by Lord Clancarty, whom he created one of the Lords of his bed-chamber, and, by letters patent, clerk of the crown and peace for **Munster**. James also gave him a troop of horse, in command of which, he is charged with having committed many acts of wanton cruelty. On the Sunday following his arrival, James, supported by two Franciscan friars, and attended by Lord Clancarty and many priests in their orders, publicly heard mass performed in Cork; and Lord Clare, the governor, caused all protestants who remained in the city to be committed to prison — the churches in Cork, the castles of **Blarney**, **Macroom**, and the others belonging to Lord Clancarty, being used as places of confinement.


On the surrender of Cork to the Duke of Marlborough, in 1691, Lord Clancarty, amongst others, was taken at the capture of the old fort, and, notwithstanding the exertions made by his father-in-law, the Earl of Sunderland, to procure his pardon, a representation, drawn up by **Sir Richard Cox**, (the historian, then second justice of 



---

p.304




the Common Pleas,) stating the excesses of which Lord Clancarty had been guilty, and the conspicuous part he had taken in support of the arbitrary measures of James, was not to be overruled, and the estates and title of Clancarty were declared forfeited to the crown.


It should be mentioned, to the honour of King William's government, that a considerable tract of the forfeited ground was granted to a poor butcher at **Mallow**, who had fallen a victim to Lord Clancarty's ferocity; the remainder was sold, with other property similarly circumstanced, at Chichester-house, Dublin: and the Sale Book is preserved in the library of the king's inns.


A pension of three hundred a year was allowed to this unfortunate nobleman, on condition of his leaving the kingdom. ‘With this,’ says **Smith**, ‘he retired to Hamburgh on the Elbe, and purchased a little island in the mouth of that river from the citizens of Altona, which went by his name.[46](javascript:footNote('E820000-001/note046.html')) There he erected a convenient dwelling-house, with a range of store-houses, and formed an useful garden. In this place he made a considerable profit by shipwrecks, but continued to give the distressed all the assistance in his power, and saved the lives of many. His profit arose from the goods thrown on his island, which he placed in his store-houses; and if demanded by the right owners, within the year, he returned them, requiring only two percent, for the store-room; if not, he made use of them as his own. He died here October 22, 1734, aged 64;’ leaving two sons, Robert, a captain in the English navy, commonly called Lord Muskery, and Justin Mac Carty, Esq. Lord Muskery, having fallen under suspicions of being attached to the House of Stuart, ‘which had on a former occasion,’ remarks **Charnock**, in his Biographia Navalis, 



---

p.305




‘proved the ruin of his father, was ordered to be struck off the list of naval officers, on the 16th July, 1749: he afterwards entered into a foreign service.’


Such is the history of the once powerful Mac Cartys of Muskery; that of the other branches of the same family, as well as of most Irish clans, closely resemble it; attainder, forfeiture of property and exile form the melancholy termination of each, and the circumstances and situations which have arisen and still arise out of such violent events are numerous and deeply affecting. Instances have occurred where the lineal descendants of the most distinguished houses have laboured from day to day for precarious support on the lands over which their ancestors exercised unlimited sovereignty. A pathetic incident connected with the Mac Cartys has such claims on the feelings that I will not conclude this narrative of their fortunes without the mention of it. A considerable part of the forfeited estates of that family, in the county **Cork**, was held by Mr. S[*...*]about the middle of the last century. Walking one evening in his demesne, he observed a figure, apparently asleep, at the foot of an aged tree, and, on approaching the spot, found an old man extended on the ground, whose audible sobs proclaimed the severest affliction. Mr. S- inquired the cause, and was answered — ‘Forgive me, sir; my grief is idle, but to mourn is a relief to the desolate heart and humbled spirit. I am a Mac Carry, once the possessor of that castle, now in ruins, and of this ground; — this tree was planted by my own hands, and I have returned to water its roots with my tears. Tomorrow I sail for Spain, where I have long been an exile and an outlaw since the Revolution. I am an old man, and to-night, probably for the last time, bid farewell to the place of my birth and the home of my forefathers.’


The military and historic recollections connected with **Blarney** are doubtless of sufficient importance to give an interest to the place: but to a curious superstition it is perhaps more indebted for celebrity. 



---

p.306




A stone in the highest part of the castle wall is pointed out to visitors, which is supposed to give to whoever kisses it the peculiar privilege of deviating from veracity with unblushing countenance whenever it may be convenient — hence the well-known phrase of ‘*Blarney.*’


The grounds attached to the castle, as I before observed, though so little attended to, are still beautiful. Walks, which a few years since were neat and trim, are now so overrun with brambles and wild flowers as to be passed with difficulty. Much wood has also been cut down, and the statues, so ridiculously enumerated in a popular song, removed. A picturesque bridge too, which led to the castle, has been swept away by the wintry floods, and, with the exception of a small dell called the Rock Close, every thing seems changed for the worse. In this romantic spot nature and art (a combination rather uncommon in pleasure grounds) have gone hand in hand. Advantage has been taken of accidental circumstances to form tasteful and characteristic combinations; and it is really a matter of difficulty at first to determine what is primitive, and what the produce of design. The delusion is even heightened by the present total neglect. You come most unexpectedly into this little shaded nook, and stand upon a natural terrace above the river, which glides as calmly as possible beneath. Here, if you feel inclined for contemplation, a rustic couch of rock, all festooned with moss and ivy, is at your service; but if adventurous feelings urge you to explore farther, a discovery is made of an almost concealed, irregularly excavated passage through the solid rock, which is descended by a rude flight of stone steps, called the ‘Witches' Stairs,’ and you emerge *sul margine d'un rio*, over which depend some light and graceful trees. It is indeed a fairy scene, and I know of no place where I could sooner imagine these little elves holding their moonlight revelry.


A short distance to the south west of the castle is a lake, said to abound with a species of leech. It does not afford one good subject 



---

p.307




for the pencil, being without islands, the margin swampy, and the adjacent trees planted with two much attention to regularity. It is a very generally believed tradition that, before **Blarney** surrendered to King William's forces, Lord Clancarty's plate was made up in an oaken chest, which was thrown into this lake, and has not since been recovered; nor does this appear improbable, as I understand repeated attempts have in vain been made to drain it. In 1814, the late Mr. Milliken, whose well-known song of ‘ the Groves of Blarney’ has identified his memory with the place, gave me a clumsy silver ring for the finger, which had been taken out of the lake by a boy who was fishing in it. About the same time, the signet ring of Donogh Mac Carty More was sold by a peasant to a watchmaker in Cork named Brooks, from whom I obtained an impression, and which is copied double the size of the original.


Since I am on the subject of discoveries, it may be worth notice that, in a quarry close to the castle, where some men were working, we picked up several human bones, and that one of the labourers informed us so many as twenty horse loads of these bones had been thrown into the lake; he also spoke of two or three spear-heads being found with them. Groats and pennies of the Edwards and Henries have frequently been dug up here; but I believe never in any quantity.


The interior of the castle contains little worth notice except a full length portrait of Charles XII. of Sweden, said to be an original, and brought here by one of the Jeffreys family who was envoy to that monarch.


At Killowen, near **Blarney**, the Rev. James De la Cour was born, whose ‘ Prospect of Poetry,’ unfortunately for him, was much admired. It is reported that some complimentary lines addressed 



---

p.308




to him on this publication, by **Thomson**, the author of the Seasons, commencing with 

*Hail, gently warbling De la Cour,’’*

James Thomson, The Seasons London: Henry Woodfall for A. Millar (1744)

 

affected his reason, so as to render him guilty of many irregularities, for which he was deprived of his gown.
The Prospect of Poetry (evidently an imitation of Pope) was first published in 1?33, and has since been reprinted in Cork more than once, with some of De la Cour's other poems, the beauties and faults of which closely resemble those of the compositions on which they were modelled.


Many epigrams by Dr. De la Cour are exquisitely satirical: but few are to be seen in print owing to their being founded chiefly on temporary and local circumstances, and most of them consequently requiring a long prosaic introduction. Many are known to me, and, as a fair example, I select one, the history of which has been orally preserved.


De la Cour frequented a coffee-house kept by a man named Connor, who had been servant to Mr. Carleton, a merchant distinguished in Cork by the nickname of ‘King Carleton,’ on account of his wealth and influence, and who patronised his old servant.


Connor, soon after he had commenced business, married a daughter of the city jailor, and the poet, having accumulated a long bill, was refused further credit by the prudent landlady. When De la Cour inquired indignantly for *Jack* Connor, he was haughtily answered by his spouse with ‘Is it *Mr.* Connor you ask for, sir? Upon *my honour* I don't know where he is, unless with *Frank* Carleton!’ This was about the time of the breaking out of the American war, and on that occasion civic politics ran high. Two addresses were drawn up to the government, called the Pro and Con; the one principally signed by the corporation, expressive of their willingness to support the cause of England with their lives and fortunes; the other was 



---

p.309




from the merchants, praying for pacific measures, and stating how injurious war would be to the commercial prosperity of the nation. Mr. Connor, to make himself popular, signed both, and was of course despised by both sides of the question. Soon after, severe losses on extensive speculations caused the failure of Mr. Carleton; and Connor, finding himself involved with his patron, became also a bankrupt, when De la Cour is said to have chalked the following lines on a window-shutter of his coffee-house: 


> 1. So now, *Dame Jail*,
>   
> Your pride must fail,
>   
> Likewise your boasted honour,
>   
> For '*Frank*' is gone,
>   
> And '*Pro and Con*'
>   
> Are signed by '*Mr. Connor*.'
> 




Another epigram of De la Cour's I copy from a Cork newspaper of the time: occasioned by the capture of the Bellona, a French frigate of thirty-two guns, by the Vestal of the same force: 


> 1. In vain Bellona mounts the Gallic gun
>   
> To take the honour of the British Nun;
>   
> Chaste as she lives, so brave she will expire,
>   
> There's no extinguishing a Vestal's fire.
> 






---

p.310


Mines and minerals
------------------



> 1. Now those profounder regions they explore
>   
> Where metals ripen in vast cakes of ore:
>   
> Here sullen to the sight at large is spread
>   
> The dull unwieldy mass of lumpish lead.
> * The copper sparkles next in ruddy streaks
>   
> And in the gloom betrays its glowing cheeks.
> 


**Dr. Garth**.


Although it does not come within the design of this work to treat on the geology of the south of Ireland, yet I feel satisfied that a brief account of its mines and minerals will not be misplaced, and may tend to direct some attention to an important though neglected pursuit. There are few countries richer in mineral deposits; out of the thirty-two counties, nineteen are known to contain iron; seventeen copper; eighteen lead, and sixteen coal; and from what has been done and is at present doing, it will, I think, appear evident that Ireland still holds out the hand of invitation for the further operations of the miner.


The most ancient work in the country probably is that on Ross 



---

p.311




Island, bordering on the lower Lake of **Killarney**. It is situated on the south side of the island, in limestone, of which this, as well as all the other islands in the Lower Lake, are entirely composed. The remote antiquity of Ross Mine is established by a discovery made on clearing out the old shafts when it was re-opened a few years since, at which time several rude implements of stone were found buried under decayed vegetable matter and rubbish, the accumulation of many centuries: two or three of these relics are in my possession, but their construction is so barbarous that it is evident, with such tools, the process of mining must have been very slow as well as laborious. From appearances, however, it may be inferred, that the workmen endeavoured to facilitate their operations by kindling large fires on the limestone, thereby reducing it to a caustic state; and the timber from the immediate vicinity was, most probably, the fuel used for this purpose. Marks of the fires were distinctly to be seen when the rock was exposed to view, which, with the discovery of the stone implements, affords satisfactory evidence of the mine having been originally worked at a period prior to the knowledge of either iron or gunpowder, and hence local tradition has attributed these operations to the Danes.


There is reason to think that this work was again opened in the reign of James I., as some coins of that monarch were found in another and a distinct part of the mine; but why it was relinquished, if then worked, must remain a subject for conjecture.


About the year 1804, Colonel Hall, who had been some time quartered at **Killarney**, conceiving a favourable opinion of Ross Mine, induced one or two gentlemen in the vicinity to join him in re-opening it. Having succeeded in clearing out the water and rubbish, the little company were encouraged by the flattering appearance to proceed to work it, which they did on rather an extensive scale, notwithstanding the unfavourable circumstance of its situation — nearly close to the lake, the ground not rising much 



---

p.312




above it, and dipping towards it at an angle of about 30 degrees from the horizon, so that, in a short time, the workmen had excavated completely under the lake, with every fear of its waters breaking in on them: the richness and abundance of the ore was, however, a sufficient inducement to counteract this danger and inconvenience, as, during the four years that Ross Mine was worked, nearly 80,000l. worth of copper was disposed of at Swansea, some cargoes producing 40l. per ton. But this very richness was the ultimate cause of its destruction, as several small veins of pure oxyde of copper split off from the main load and ran towards the surface; the ore of these veins was much more valuable than the other, consequently the miners (who were paid by quality as well as quantity) pursued the smaller veins so near the surface, that the water broke through into the mine in such an overwhelming degree that an engine of thirty horse power could make no sensible impression on the inundation; and thus a forcible stop was put to all further proceedings.


It would be reasonable to conceive, from the above statement, that the proprietors derived considerable advantage from this mine; such, however, was not the case, and it has been asserted that money was sunk in the speculation; but having made particular inquiry into the circumstances, it appears evident a result so unfavourable was by no means attributable to the mine itself, but to the manner in which it was conducted, and it adds one more proof to thousands of others that inattention or mismanagement may ruin the most promising undertaking.


Another old copper-mine is to be seen on the Mucruss estate, situated on the south side of the peninsula which divides the Lower Lake of **Killarney** from Turk Lake. This mine was worked about seventy or eighty years since, and its value spoken of in very high terms even to the time of its discontinuance, an event which has been solely attributed to differences amongst the parties engaged. Colonel Hall, with his usual zeal in the pursuit of mines, jointly with 



---

p.313




another gentleman, went to considerable expense in ascertaining the truth of this report, and cleared the old workings of the water and rubbish; but, on coming to the bottom, the vein was found so reduced in size as to offer little prospect of success in prosecuting it. Some tons of good yellow ore from the pillars left to support the roof and on the surface were obtained, which sold at Swansea for 15l. per ton. There was also a rich vein of cobalt combined with arsenic, of about two or three inches wide, lying on one side of the copper vein, some of the specimens of which, found on the surface, were completely covered with a peach bloom efflorescence; from the smallness of the quantity, however, little notice was taken of it as an article of value.


There is another vein of yellow copper ore on a small island in the Lower Lake called Crow Island, which was worked for a short time by the Ross Island Company; but the produce proving inferior to that mine it was not prosecuted to any extent.


The road from **Killarney** to **Kenmare** by Glen Flesk passes over limestone, which borders one side of the River **Kenmare** for several miles, but in no part exceeds a mile in breadth. In this limestone are several appearances of mineral veins, both of lead and copper, specimens of which are easily obtained, as partial attempts have been made to work them; and it is reported that, about sixty years ago, several cargoes of copper ore were shipped for England from one spot, where there is a considerable excavation. Amongst the rubbish on the surface, specimens of good yellow ore, containing about twenty per cent, of metal, may be picked up. A vein of lead was also worked not far from this, but the specimens now to be procured are mixed with a considerable portion of blende; yet the appearances along this line warrant further and careful examination.


At **Beerhaven**, near the mouth of the river **Kenmare**, on the county **Cork** side, a most gratifying sight presents itself in a large coppermine at full work. This mine was discovered about nine years since 



---

p.314




by Mr. Puxley, one of the proprietors of the property on which it is situated, who soon after sent to Cornwall for an experienced captain, and it has now been in successful operation for more than eight years, with every appearance of long continuing a prosperous work. A gentleman who visited it in 1822 informed me, that it was giving constant employment to about six hundred persons, of both sexes, and of all ages from ten years upwards. The monthly expenditure was from 900l. to 1000l., and the mine produced from 150 to 200 tons of ore in the same time.


Besides paying the proprietors very handsomely, the blessing which this mine has been to the surrounding country can only be appreciated by those who have witnessed such a scene. The place where, but a few years since, the barren and rocky mountains could scarcely sustain the lives of a few half-starved sheep, is now the scene of busy and useful employment, dispensing competence and comfort to hundreds. The principal works are carried on about a mile and a half from the water, and the ground rises to a considerable elevation. The vein crosses the regular strata of the country, which is a hard rock of graywacke, at a small angle, taking a direction about two points to the south of east and the same to the north of west. The matrix of the vein is a white opaque quartz, in part of its course of the amazing width of sixty feet (which has been proved by cutting through it), but the ore has seldom exceeded three feet in breadth.


Mineral appearances have likewise been discovered on the opposite side of the river **Kenmare**, in the county **Kerry** and along the coast as far as **Dingle**, which might prove worth the attention of persons acquainted practically with the subject. Veins of lead and copper have been partially worked at **Milltown**, between **Killarney** and **Tralee**, on the properties of Sir John Godfrey and Lord Head ford; and they certainly encourage further proceedings.


The next metallic veins deserving notice are those on the estate of Lord Audley, in the county **Cork**, about ten miles west of Skibbereen, 



---

p.315




which were discovered and opened by Colonel Hall about the year 1814. Three distinct veins presented themselves at no very considerable distance from each other. The first worked was a bright yellow ore of iron pyrites, containing in general about 8 per cent, of copper. The second has been scarcely attended to, as it chiefly consisted of green carbonate of copper disseminated through a slate clay, with small nodules of gray or purple ore appearing here and there. In the third, which has been more extensively pursued than either of the others, the ore is a very rich sulphuret of copper, containing from 55 to 65 per cent, of that metal, and, near the surface, gave every promise of being a very valuable vein; but it degenerated in depth, and was, as well as the others, relinquished. Lord Audley has lately re-opened this vein himself; but whether the undertaking will be attented with success remains to be proved.


In this neighbourhood other veins were also opened by Colonel Hall, and one was worked for a short time on an extensive scale; but it has been given up. This enterprising gentleman likewise engaged in rather an extraordinary undertaking, that of burning out a bog not far from Glandore Harbour, which contained particles of copper; the ashes he shipped for Swansea, and obtained a considerable price for them. These particles of copper are supposed to have been conveyed into the bog by a stream from one of the surrounding hills, which, passing through a copper vein, took them up in a state of sulphate, but meeting with some iron ore in its progress, or in the bog, became deposited in the metallic state, though a large proportion contained in the turf was still in a state of sulphate, which was proved by allowing a knife to remain in it a few seconds, when it became incrusted with a coat of copper.


This was called by the country people ‘the Stinking Bog;’ and when, for want of other fuel, they were obliged to burn the turf from it, the greatest precaution was used in placing the ashes where their fowls, dogs or eats could not get near them, as any offal thrown 



---

p.316




upon the ashes and eaten by these animals invariably produced death.


Several attempts were made, by cross-cutting the strata in the vicinity, to discover the original vein, but these efforts were without success, and the bog being entirely burnt out, nothing further has been done, although there can be little doubt but that an extensive and rich vein must be somewhere in the neighbourhood. Another bog of the same description is distant about a mile from the one just mentioned. It belongs to Mr. Jervis, but being of small dimensions the expense and trouble of building kilns for the purpose of burning it was considered to be too great for the expected produce.


There are many indications of the existence of copper in the vicinity of **Ross Carbery**; one may be seen about two miles from thence, close to the Cork road, where green carbonate of copper appears on the surface. Continuing along the coast from **Ross Carbery** to **Clonakilty**, there are several excavations where mines have been formerly worked, but no distinct account of the period or of their nature can be obtained; they appear from their rubbish to have contained copper ore, except one, which was worked by an English company about twenty years since, but was relinquished after an insufficient trial. This vein consists of galena and blende.


It was stated by a gentleman of respectability to a friend of mine, who has paid much attention to geological pursuits, that, not long since, some miners who were sinking in search of copper in the vicinity of **Clonakilty** cut through a rich vein of coal. There is little doubt but coal might be found in many other parts of the county **Cork** than the district north of the river **Blackwater**, to which coal works are at present entirely confined, and where the produce cannot be of much benefit from the want of water carriage.


The same observation will apply to the county **Kerry**, where no search for coal has yet been attempted, although within five miles of **Killarney**, near a place called Five Mile Bridge, three distinct veins 



---

p.317




are perceptible rising to the surface; and I have just learned, with much pleasure, that the attention of some of the Welsh coal companies has been lately turned towards the South of Ireland.


Two veins of lead, which had been partially worked before one, near the mouth of Cork Harbour, at Ringabella, on the estate of Mr. Hodder; the other on adjacent property belonging to Lord Shannon — were re-opened in 1822. The latter was shortly after discontinued; but the former promised, with skill and attention, to become an extensive and profitable concern.


There are several other mineral appearances in this neighbourhood, as well as on the eastern side of the harbour; but in this necessarily limited sketch it would be impossible to take even a passing notice of each particular spot. In various parts of the counties of **Waterford**, **Wexford** and **Limerick** efforts have been made to work numerous veins of copper and lead; but, either from want of the suitable means or knowledge of the business, and often both, these undertakings have rarely been either successful or permanent.


In the county **Tipperary**, at Silver mines, veins of lead have been worked at various periods; but mismanagement seems to be the order of the day in Ireland, and, at the present moment, not more than a few hands are employed at this place, which certainly presents strong inducements for the investment of capital to make it an extensive mine. Many places may be mentioned where mineral treasures expose themselves to the view of the passing traveller; but a repetition of circumstances that admit of little or no variation occasion a tiresome monotony, and enough has probably been said to show what an extensive field for speculation and research the south of Ireland presents: indeed, as useful employment is acknowledged to be the grand desideratum in that unhappy country, and as England has proved herself so nobly solicitous in every effort to raise the indolent and misguided Irish peasantry from their present state of wretchedness and discontent, what better opportunity could be 



---

p.318




wished for than this subject presents? — Companies of wealthy individuals might be formed at this side of the water; and, if qualified persons were engaged to superintend the works, such associations would not only be attended with every probability of profit to those concerned, but they would at once administer extensive employment, and, no doubt, greatly tend to tranquillize the peasantry.


There is scarcely a known metal which Ireland has not produced; mercury,[47](javascript:footNote('E820000-001/note047.html')) tin,[48](javascript:footNote('E820000-001/note048.html')) platina, and the rarer metals lately discovered in South America, are, I believe, the only exceptions. The purity of its gold has been long noted, and, judging from the numerous and massive ornaments which are almost daily dug up, this metal appears to have been manufactured at a very early period.


**Doctor Campbell**, in his entertaining Survey of the South of Ireland, particularizes three golden vessels, three ingots weighing about a pound, and more than a dozen pieces of gold of various shapes and dimensions, which were found in a small bog near Cullen. Some more recent discoveries of golden ornaments are mentioned in the 



---

p.319




sixth volume of the Transactions of the Royal Irish Academy; amongst these a small crown which weighed more than a pound. The golden crown or cap dug up in 1692 at the Devil's Bit in the county **Tipperary**, and supposed to be still extant, is probably familiar to the reader from the numerous engravings which have appeared of it in various works, from **Keating**'s History of Ireland to **Mr. Phillips**'s Emerald Isle.


To enumerate even slightly the several pieces of ancient wrought gold which I have seen at various times in Ireland would occupy many pages; nor do I think that a thousand pounds would purchase the entire: most of them have been consigned to the crucible; rings, chains, fibulæ, tiaras, bracelets, and other articles that completely silence conjecture as to their use.


The best informed and most rational antiquaries strongly oppose the idea that the gold manufactured into these relics was native produce; and even the discovery of gold in the county Wicklow has not been sufficient to shake their opinions.


The Croghan, or Gold-mine Mountain, first became publicly known in September, 1795, although it had long been a secret source from whence a family named Byrne, resident in its vicinity, derived much wealth. Six weeks elapsed before a party of the military arrived to take possession of it by directions from government, and during this time it is calculated that above 10,000l. worth of ore was collected and disposed of by the peasantry. The largest piece which is known to have been obtained weighed twenty-two ounces and sold for 88l.; indeed, so pure was the metal generally, that it was the custom of the **Dublin** goldsmiths to put gold coin into the opposite scale, and give weight for weight.


After a trial of about five years, supported by an inconsiderable grant, the working of Croghan mine was discontinued, as the produce appeared to be only barely sufficient to cover the expense incurred; but the scale of this undertaking was altogether so limited that it 



---

p.320




becomes a question of some national importance whether the mine has not been given up prematurely.


Silver was formerly procured in three, out of the four provinces:[49](javascript:footNote('E820000-001/note049.html')) in **Ulster**, — in the county **Antrim**, which mine was, to use the words of **Dr. Boate**, ‘very rich, forasmuch, as with every thirty pounds of lead it yieldeth a pound of pure silver; another was in **Connaught**, upon the very harbour-mouth of Sligo, in a little demi-island, commonly called Conny Island; and a third, in **Munster**.’


The discontinuance of these works was caused by the turbulent state of the country: that in **Munster** has been already mentioned as a lead mine; it was discovered early in the seventeenth century, and notice was given to Donough, Earl of Thomond, then Lord President of **Munster**, who covered part of his castle, at **Bunratty**, in the county **Clare**, with lead procured from Silver mines. Lord Strafford seems to have anticipated favourably of the produce of this mine; and in 1633, besides transmitting to **Charles I.** an ingot of silver which weighed three hundred ounces,[50](javascript:footNote('E820000-001/note050.html'))With this new year these first-fruits of your royal mines crave admission into your Majesty's presence, and let them be the good omens that this kingdom now at length, in these latter ages, may not only fill up the greatness and dominion, but even the coffers and exchequer of the crown of England. Sure I am it becomes not this little one that her breasts should ever be dry, nor ought she with a sparing hand to communicate of her strength and wealth there, considering with what mass of treasure and streams of blood she hath been redeemed and preserved by that her elder and more excellent sister.May your Majesty's days be as lasting and glorious as the best and purest of metals, and God Almighty prosper and accomplish all your princely thoughts and counsels, be they old or new, he writes the Lord 



---

p.321




Treasurer that ‘the King's duty forth of the royal mines in **Munster** will be 500l. a year, besides what be thence raised forth of the three other provinces.’


**Dr. Boate** describes the silver of this mine, in the county **Tipperary**, as ‘very fine, so as the farmers sold it at **Dublin** for five shillings two-pence sterl: the ounce: — as for the lead, that, they sold on the place for eleven pounds sterl: the tun, and for twelve pounds at the city of **Limerick**. The king had the sixth part of the silver for his share, and the tenth part of the lead, the rest remaining to the farmers, whose clear profit was estimated to be worth 2000l. sterl: yearly.’


The sequel to this little history of the work at Silver Mines forms a dreadful episode of the rebellion of 1641.


The Irish, headed by Hugh O'Kennedy, brother of John Mac Dermot O'Kennedy, on whose lands the mine was situated, ‘not content to lay waste the mine, and to demolish all the works thereunto belonging, did accompany this their barbarousness with bloody cruelty against the poor workmen, such as were employed about the melting and refining of the ore, and in all offices thereunto belonging: the which, some of them being English, and the rest Dutch, (because the Irish, having no skill at all in any of those things, had never been employed in this mine otherwise than to dig it, and to do other labours,) were all put to the sword by them, except a very few, who by flight escaped their hands.’


Iron is abundant in Ireland. During the comparatively tranquil reign of James the First many mines were opened, and iron works, particularly in the province of **Munster**, became exceedingly numerous; 



---

p.322




but the renewal of warfare, towards the close of his successor's reign, proved fatal to the prosperity of these establishments, most of which, being the property of English settlers, were wantonly demolished by the Irish. An improvident consumption of timber was also another cause of the discontinuance of many of them, as it became impossible to procure the necessary supply of charcoal. Those who are curious respecting the details of this subject will find nearly two chapters, in **Dr. Boate**'s Natural History of Ireland, devoted to an account ‘of the iron works, their fashion, charge of erecting and maintaining them, and profit coming from them; with an exact description of the manner of melting iron.’


Among the rarer minerals may be classed a vein of sulphate of Barytes, (commonly called terra ponderosa, from its great specific gravity,) situated between **Ross Carbery** and **Clonakilty**, part of which is exposed to view on the coast running into the sea; it is several yards in thickness, and, from its apparent compactness and beautiful white colour, may not be unworthy the attention of the statuary; as with sufficient tenacity to retain any impression, it is likewise soft enough to admit of being easily turned or chiselled into form. A vein of sulphuret of iron (iron Pyrites) almost adjoins it.


There are also other smaller veins of sulphate of Barytes in the county **Cork**.


I have seen many specimens of Asbestos from **Beerhaven**. This is a singular mineral, which divides into long threads or fibres, and is said to have been manufactured into a kind of cloth, capable of resisting the action of fire. The specimens at **Beerhaven** are, however, neither sufficiently long or tenacious to admit of being thus woven.


The Cork amethyst has been already mentioned: crystals of quartz, some very large and highly transparent, are found in the western districts of the county **Cork**, and on the mountains of **Kerry**, 



---

p.323




particularly in the vicinity of **Dingle**. By the country people they are named **Kerry** diamonds, from their brilliancy, and, when well cut and set, form handsome ornaments.


A. genealogical MS. by a village poet, named Bryan O'Connor, is mentioned in the Anthologia Hibernica, in which its author refers to his ‘Poetical Description of Kerry;’ where he celebrates in *heroics* the passion of Thomas, the first Earl of Kerry, for wearing Kerrystones as buttons, having several suits embellished with them: 


> 1. Here gems unwrought send forth such lively rays,
>   
> That paler stars confess a feebler blaze;
>   
> The brilliant mass our noble Lord admir'd,
>   
> The gems he pohsh'd and new charms inspir'd:
>   
> And Foreign Courts, tho' envious, forc'd to own,
>   
> He wanted of a Monarch — but the Crown.
> 




The last mineral I shall notice is the Hydrargillite, called also Wavellite, from the circumstance of its discovery in Devonshire by Dr. Wavell. This production is of very rare occurrence, having before been discovered (exclusive of Devonshire) only in South America. It is found about ten miles south of Cork, near Minane Bridge, which crosses a small rivulet that falls into the creek of Ringabella. The rocks in the neighbourhood are of a soft schistus or slaty nature, and flag-stones, of a tolerable size, are obtained near the spot; the specimens in question have not yet been found connected with any rock; they are dug or ploughed up out of the soil, nor is there any adjacent hill from whence they could have been washed down. This mineral appears in the form of small globular nodules, from the size of a pea to that of a walnut; each of these nodules is composed of thin spiral crystals which radiate from the centre, and, when broken, present a silky appearance, generally of a greenish hue and translucent at the edges; but the crystals, when separated, possess a considerable degree of transparency, nor do they adhere 



---

p.324




together with much tenacity, being easily separable by the nail, and without difficulty reduced to powder.


It is sometimes disseminated through a hard opaque quartz, and sometimes occurs in single nodules, though generally found with the nodules conglomerated together.




---

p.325


Literature
----------



> 1. Then I our own Historians did peruse;
>   
> The Greek and Latin too, and with the Muse
>   
> I did converse.
> * Homer and Virgil, Horace, Sophocles
>   
> I read, yet hate none like Thucyclides:
>   
> He says democracy's a foolish thing;
>   
> May I have a Republic — he a King!
> 

 
The Innocent Traytor — 1679.


The literary superiority of Ireland over the rest of Europe, in remote ages, has been a subject of national exultation. We are told of an Establishment at Armagh for seven thousand students; of Greek princes who were educated at the University of **Lismore**, and of numerous foreigners having visited the schools of Ireland for instruction.


At the English Conquest, however, Ireland was unquestionably in a state of profound ignorance; the pride of her schools and colleges had disappeared; and ‘to the present day,’ says **Sir Richard Cox**, ‘very few of the Irish aim at any more than a little Latin, which every cow-boy pretends to, and a smattering of logic which very few of them know the use of.’ This passage, although intended to convey little commendation of Irish learning, is certainly a strong 



---

p.326




evidence of a literary taste, and may excite some curiosity to become better acquainted with mountaineers who even aim at ‘a little Latin.’


Amongst the peasantry, classical learning is not uncommon; and a tattered Ovid or Virgil may be found even in the hands of common labourers.[51](javascript:footNote('E820000-001/note051.html')) In **Munster**, the village schoolmaster forms a peculiar character; and, next to the lord of the manor, the parson, and the priest, he is the most important personage in the parish. His ‘academic grove’ is a long thatched house, generally the largest in the place; surrendered, when necessary, for the waking of a dead body, or the celebration of mass whilst the chapel is undergoing repairs; and on Sundays, when not otherwise engaged, it is used as a jig or dancing house.


The highest class of scholars is composed of men as full grown, and often as old as the master himself, distinguished by the name of ‘poor scholars,’ or ‘strangers.’ These strangers are, generally, the sons of reduced farmers and natives of **Ulster** and **Connaught**, who, having swallowed all the classical information within their immediate reach, range through the bogs of **Munster** to complete their knowledge of Latin, and to acquire the Greek tongue. The village schoolmaster gains little from this class of students; but the glory of possessing pupils who, when they return to their native provinces, will spread his fame, appears to him an adequate recompense. Nor is his generosity confined to their education; he also contributes his exertions towards their subsistence, and obtains for them gratuitous lodging in some neighbour's cabin.


The enterprising spirit of these literary adventurers is surprizing; they will start from the home of their infancy — traverse the southern parts of the island — visit every village — sojourn in every school 



---

p.327




examine every local curiosity, and return to their birth-place, after perhaps a year's absence, without having, for that space of time, expended, or indeed possessed a single half-crown; so warm is the hospitality of the peasantry, and so high their respect for learning! With the schoolmaster, too, it is a matter of special pride to be visited from remote distances; and it is not unusual to hear the respectability of a school estimated by the number of its ‘stranger pupils.’


But it may be asked, what can be the object or use of a classical education to the children of Irish peasants? The mass of the population is Roman Catholic.[52](javascript:footNote('E820000-001/note052.html')) By the penal statutes the wealthier part of that persuasion were deprived of their property, and the general exercise of their religion subjected to severe penalties and restrictions. In this state of things, the clerical profession had nothing to tempt the ambition of ancient Catholic families. It was a life of privations, difficulties, and suiferings; those who enjoyed even competence would not embrace it, and hence it fell into the hands of peasants. The cottager reared one or more of his children in the expectation of their obtaining holy orders, and prided himself in the hope of seeing one of them, at some future day, the priest of his native parish. After wandering in search of learning through the 



---

p.328




country, they made their way to France, Spain, or Portugal; — studied, and were ordained in the colleges of these countries, and returned to exercise their profession in Ireland, where the Roman Catholic clergy are, with few exceptions, sprung from the humblest ranks of the people.


These circumstances, and this feeling, crowd the country schools with learners of the classical languages, and there are few families, however lowly their condition, that do not boast a young aspirant for clerical distinction.


To return to the preceptor. In an evening assembly of village statesmen he holds the most distinguished place, from his historical information, pompous eloquence, and classical erudition. His principles verge very closely indeed on the broadest republicanism; he delivers warm descriptions of the Grecian and Roman commonwealths; the ardent spirit of freedom and general equality of rights in former days and then comes down to his own country, which is always the ultimate political subject of discussion. He praises the Milesians — curses ‘the betrayer Dermod’ — abuses ‘the Saxon strangers’ lauds Brien Boru utters one sweeping invective against the Danes, Henry VIII., Elizabeth, **Cromwell** ‘the Bloody’ William ‘of the Boyne,’ and Anne; he denies the legality of the criminal code; deprecates and disclaims the Union; dwells with enthusiasm on the memories of Curran, Grattan, ‘Lord Edward,’ and young Emmet; insists on Catholic emancipation; attacks the *Peelers*, horse and foot; protests against tithes, and threatens a separation of the United Kingdoms! These are his principles, which he pronounces with a freedom proportioned to the patriotic feelings of his auditory: before congenial spirits he talks downright treason; in the presence of a yeomanry serjeant, an excise officer, or parson's clerk, he reasons on legitimate liberty; he is an enemy to royalty and English domination. Nor do these political sentiments confine themselves to the limits of mere declamation: he is frequently the promoter 



---

p.329




of insurrectional tumults; he plans the nocturnal operations of the disaffected; writes their threatening proclamations, studiously mis-spelled and pompously signed, Captain Moonlight, Lieutenant Firebrand, Major Hasher, Colonel Dreadnought; and General Rock, *Night* Errant and Grand Commander of the Order of the Shamrock Election.


Our schoolmaster is a poet too, and consecrates his powers to the diffusion of patriotic aspirations — songs, treasonable, amatory, and 
laudatory, on his Green Erin, 

*Like an emerald set in the ring of the sea.’’*

 

Nor are his effusions confined merely to manuscript, but pass into print, and, in the shape of penny ballads, obtain considerable and important circulation.
The songs of the people are always worth attention, and it appears to me extraordinary that the most positive treason should for many years past have been published in Ireland, apparently without notice. Of about four hundred popular ballads (chiefly printed at **Limerick**) which I purchased without selection, in 1821, more than one-third were of a rebellious tendency, particularly a song entitled Cathaleen Thrail, (Catherine the Slave,) so is Ireland allegorically styled. The first, second, and third verses describe the meeting of the author with Cathaleen Thrail, the genius of the country; the fourth, sixth, and part of the last verse I shall copy, on account of the prophetic strain which runs through them: 


> 1. You, Sons of poor Erin, therefore don't fail
>   
> From Cork to **Kinsale**, and off to Cape Clear,
>   
> Come excite your parties, its no time to bewail,
>   
> Tho' bad alterations we've plenty this year;
>   
> Now the year 21 is drawing in by degrees
>   
> In the year 22 the Locusts will weep;
>   
> But in the year 23 we'll begin to reap
>   
> And divorce the *Black-weed* from Cathaleen Thrail.
> 
> 
> ---
> 
> p.330
> 
> 
> I conversed with many in my circuit most pleasing
>   
> Until I came to my native land, sweet Donoughmore,
>   
> Tracing old tradition, down from the creation,
>   
> And how the Milesians were conquered of yore!
>   
> How laws were enacted to slacken their force
>   
> How they were wrongfully oppressed and opposed,
>   
> And how they were trodden and tossed by the *Toads*
>   
> Who made an encroachment on Cathaleen Thrail.
> * Good people, take courage, don't perish in fright,
>   
> For Notes will be nothing in the year 25.
>   
> As I am O'Healy, we then will contrive
>   
> To daily drink beer by laws of Catheleen Thrail!
> 





I shall quote a few lines from another song, which was so extensively sung amongst the lower orders in **Dublin**, that it must still be distinctly remembered by many; the subject was the Banishment of Napoleon Bonaparte to St. Helena: 


> 1. Now he is confined, and no hope of releasement,
>   
> Before the year twenty-five he'll surprize them in earnest.
>   
> This truth we are told, and that by Pastorini,
>   
> That the sword it will fall, and perhaps from St. Helena.
> * Now you that belong to a certain great kingdom,
>   
> I would have you beware lest your fate be impending,[&c.]
> 




Verses, however, more polished than the foregoing, have been employed in the dissemination of the same sentiments, and I venture to select one specimen to prove my assertion. 


> 1. Despair not, sweet Erin, thy sun is not set
>   
> In the dark shades of discord — but still there remains
>   
> A hope that 'twill rise in mild splendour as yet,
>   
> A hope that my country may shake off her chains!
>   
> The spirit of Freedom still hovers above
>   
> To foster thy children, and dares to inspire
>   
> Their bosoms with valour, with glory — with love
>   
> The patriot's soul — and the patriot's fire!
> 






---

p.331


Modern manuscripts, in the Irish character, may be met with in almost every village, and they are usually the produce of the leisure hours of the schoolmaster: there is little variation in their contents, which consist of verses wherein Fingal, Oscar, Ossian and St. Patrick are important characters. A dialogue in particular between Ossian and St. Patrick, in which the latter endeavours to convert the bard to Christianity,[53](javascript:footNote('E820000-001/note053.html')) 
and one of some length between Death and a Sick Man, are amongst the most common. In addition to these are found translations from the classics, and frequently from some of **Dean Swift**'s verses into the Irish, with a variety of receipts, prayers[54](javascript:footNote('E820000-001/note054.html'))‘O Jesus Christ, the incorporated wisdom of God, be my aid! — O blessed Virgin, listen unto me — Mother of the Saviour of the world, assist me — Mother of God — Lady of Heaven — Sweetly beloved Queen — and Advocate of all human lineage, I beseech you come! — Amiable and mild Lady — Lady of Angels — Flower of the Patriarchs — Desire of the Prophets — Treasure of the Apostles — Mother of the Confessors — Ornament of Virgins — O sweet Virgin Mary, pray for me! — Lady, who art heard above the company of Angels, preserve me from all evils, past, present, and to come; — do not abandon me this day, nor at that dreadful hour when my soul shall be separated from my body, but obtain for me, Sweet Virgin, at the time of my death and judgment, that my soul may come to the heavenly paradise before your Child Jesus, and that I may be worthy to see his grace and everlasting glory with you, O Gate of Paradise — Palace of Jesus Christ — Star of the Sea, Consolation of Mankind — beginning without end! — Take pity on me, O sweet and blessed Virgin Mary — Daughter of God the Father — Mother of Jesus Christ, and Spouse of the Holy Ghost. — Gate of Heaven — Door of the Firmament — Hope of Christians — Fountain of Piety — Safeguard of Peace — Glory of Virgins — Honoured above all Angels — Mother of Mercy — Miracle of Virginity — Virgin above all Virgins — Temple of the Most Holy Trinity — Beautiful above all creatures! — O Lady of Meekness — Abyss of Mildness — Hope of the Sorrowful — Consolation of the Afflicted — in you the angels do rejoice! — O sweet Lady of Mercy, turn your merciful eyes unto me, and obtain for me, by thy powerful intercession, mercy, grace, and peace, in this life, and eternal happiness in the next. — Amen.’ and 



---

p.332




charms. The possessor of such manuscript regards it with a degree of affection bordering on veneration, and only on particular occasions is it produced.


To hear the contents of one of these monotonous olios read aloud, is considered by the peasantry a treat of the highest order, and large numbers will assemble on a winter's evening around the turf fire of a farmer's cabin for that purpose.


The merit of such remains of Irish literature as have descended to us, is a question which has seldom been examined without prejudices so violent as to render a just conclusion almost impossible. The opinion of Mr. Flood, supported by the bequest of his fortune to Trinity College, **Dublin**, for the purchase of Irish books and manuscripts and the cultivation of that language, is often referred to; and Lord Rosse (then Sir Lawrence Parsons) has recorded his 



---

p.333



 

coincidence of opinion in observations, published by his Lordship, on Mr. Flood's bequest.


‘Many Irish manuscripts, in the reign of Elizabeth,’ says the noble writer of this volume, ‘were in Denmark; many were lately in libraries in France, some also in the Vatican: and, if diligent search were made, and large prices offered, probably many more might now be saved from the depredations of time, and which will otherwise very soon be lost irretrievably.’ Every one must agree in the inference drawn from this — that ‘it is time to save what remain’ and it would doubtless be desirable that some one, qualified for the task, should translate such works as were considered worthy of it.


Unfortunately, however, the admirers of Irish literature are either so learnedly abstruse, or so profoundly ignorant and illiterate, that their very commendation is injurious to the cause they advocate.


The pages of O'Connor and O'Halloran appear, to use the expression of a friend of mine, ‘marvellously cumbersome;’ and the illustration of Irish antiquities and verbal derivations by the ‘erudite Vallancey’ rather tend to confuse the general reader by their remoteness from the subject, and to confound the unlearned by a display of orientalism.


The late Mr. Joseph Cooper Walker is, perhaps, the most pleasing writer on Irish literature and antiquity; but, if the genius of Vallancey laboured to derive every thing Irish from the east, so Mr. Walker's ingenuity was on the alert to trace its Italian origin, which I have been told he afterwards regretted and ascribed to a partiality for Italian literature, acquired during his residence on the continent.


The Relics of Irish poetry, by Miss Brooke, is an exception to my former remark; and, had the volume in question been written at a different period, when the antiquarian junto formed by Vallancey, O'Halloran, and O'Flanagan, and supported by Messrs. Walker, Beaufort and Ousley, was less despotic in the circle of Hibernian belles-lettres, it would have been a performance of the first class: 



---

p.334




As it is, this work will continue to hold an eminent place when the productions of those who condescend to patronize the writer, are forgotten, or remembered only as collections of ill-digested fables.


The more ancient Irish manuscripts are the Monkish Chronicles; of some of these, the names only have descended to us: they are generally called after the monastery in which they were written, and those most frequently quoted are the Psalter of Cashel — The Annals of Innisfallen — The Ulster Annals — The Book of Ballymote and the Annals of the Four Masters; but to any of these I believe it impossible to assign, with certainty, an earlier date than the thirteenth or fourteenth century; and it is a question if the original of one of these manuscripts is now in existence: copies of them are preserved, and may be found in various libraries, both at home and abroad.


A manuscript of some antiquity was found, about six or seven years since, in an iron chest, which was discovered on taking down one of the walls of Lismore Castle. If I remember correctly, it was on vellum, of large folio size, well written in double columns, and nearly half of the outside column, from top to bottom, had been cut off, or destroyed by fire: it appeared to contain about two hundred pages, and was clumsily bound in oak.


The volume passed through the hands of several persons in Cork, some of whom were both poor and illiterate; and I mention the circumstance, as it possibly may lead to some inquiry respecting this manuscript.


Although we feel anxious for the preservation of such relics, yet it almost appears an idle amor patriæ to suppose that Irish literature or history can suffer, even by the total loss of the legendary records of an age of ignorance and superstition.


The overabundant use of epithet is a striking peculiarity of most compositions in the Irish language: by some writers this has been ascribed to the nature and structure of the language; by others, to the taste of the people. In a conversation which I once had with 



---

p.335




some Irish scholars, I well remember one of them stepping forward in the formidable gesture of an excited orator, and addressing me in an exalted tone of voice in defence of epithets. ‘Worshipful Sir,’ said he, with outstretched arm, ‘these epithets are numerous in the original Irish, because they are enlivening and expressive, and are introduced by historians to decorate their histories, and to raise the passions of the reader. Thus were the youth at once instructed in the grand records of their lofty nation, — in eloquence of style and in sublimity of composition!’


Picture this declaration coming from a poor, ragged schoolmaster, or, as he styled himself, ‘Philomath,’ whose miserable habitation, of sods, cemented with mud, and constructed in a ditch, scarcely seemed a human abode: yet, before the door of this hovel, surrounded by a group of admiring compeers and disciples, he harangued, with almost the energy of inspiration, on the superiority of the literature of his country; declaring, ‘that some scribbling pretenders to knowledge had made it a determined point and standing rule to calumniate and throw as much dirt as they could on Irish history, laws, and morals; thereby imagining that they did a mighty piece of service to England and the King of England, by traducing the people, who were once the terror of the Danes, and who gave kings to Scotland, and even to England itself.’


As a fair example of the use of epithets, the following literal translation of some well-known Irish verses may be produced.


‘Mineid (in Irish, Moighneid) the son of Deirg, and Goll, the active, the magnanimous and martial son of Moirne, met in this dreadful field of slaughter: the contest between these two intrepid champions was furious, foaming and frightful — manly, mighty and mortal, insomuch that broken, battered and gory were the corslets, shields and helmets of those impetuous chiefs; and their beamy swords of broad metal did wide-spread havoc in the strained grasp of their sinewy arms.’




---

p.336


**Miss Brooke**, in the preface to her Relics of Irish Poetry, extols the copiousness of the language, and remarks, that ‘the number of synonyma, in which it abounds,’ enables the poet ‘to repeat the same thought without tiring the fancy or the ear;’ and mentions, as an illustration, ‘that there are upwards of forty names to express a ship; and nearly an equal number for a house.’


Specimens are afforded to us, in this volume, of the Ode, Elegy and Song; and, to prevent doubt, the originals are given, with translations, elegantly versified, and literal in the extreme.


Most Irish odes are ascribed to Oisin, the same person as Mac Pherson's Ossian, whose well-known poems they resemble in style and subject. A similar mistiness to that in which many of his heroes are clothed, envelopes the identity of this bard, whose personal history is as imaginary and undefined as the descriptions contained in the verses attributed to him. These odes represent the kings and chiefs as terrific in war, and fond of the chase; in short, excelling in those virtues and qualifications esteemed by Indian nations at this day, and possessing, in addition, a great love for song and banquets. Little more than a savage splendour can be discovered in these banquets, notwithstanding the vaunting assertions respecting ancient Irish civilization, for which similar bardic or monkish verses are the foundation.


Irish songs are abundant and may be easily procured, but few have been committed to paper: this may be ascribed to two causes; first, being short compositions, they are easily remembered, and secondly, their treasonable nature. Many of these songs are extremely comic, from a richness of humour delivered with a peculiar quaintness, which it is impossible to convey in translation. Allusions to the Greek and Roman mythology are occasionally introduced with propriety and good taste, but more frequently in the most absurd way: one village bard has described his mistress as looking ‘*just like Venus or Jove.*’




---

p.337


Passages, closely imitated from the classics, may be observed in many Irish verses. The resemblance between the commencement of Carolan's Song on Mable Kelly, and one of Sappho's Fragments is evident; and Fitzgerald's Ode to his Ship on leaving Dunboy was doubtless suggested by the third Ode of Horace.


The following translation of a spirited Irish song, which has not before been printed, may be worth preserving: it was composed for, or on, some of the piratical sept of O'Driscoll, a clan that, with the O'Sullivans, possessed a considerable part of the coast of the county **Cork**, and urged their trade of maritime plunder to such a formidable and fearless extent, as to rival the Algerines, who became jealous of them, and made a descent, in 1631, on their country; burning Baltimore, the principal town belonging to the O'Driscolls, and carrying off the inhabitants into slavery. This event created the greatest consternation in Ireland, and more effectually checked the piracies of the O'Driscolls than the repeated expeditions fitted out against them by the city of **Waterford**; as they appeared only to become more daring after each attack, notwithstanding the destruction of their vessels and the ruin of their castles. 


> 1. Our oars we ply, when seas run high,
>   
> And loud the winds are roaring,
>   
> Now down the depths, now up the sky,
>   
> On eagle billow soaring!
> * And when we hail, the gentler gale,
>   
> With glee our stout hearts glowing,
>   
> Abroad we spread the spritted sail,
>   
> And catch it while 'tis blowing.
> + For us enough, or fair or bluff,
>   
> Waves calm or wildly foaming,
>   
> So we may launch, thro' smooth or rough,
>   
> Adventurously roaming!
> 
> 
> ---
> 
> p.338
> 
> - Unknown to fear, the Buccanier,
>   
> Self-crown'd the Ocean Ranger,
>   
> Blow high — blow low — his course will steer,
>   
> His element is danger!
> 





Descriptions of female beauty are often very pleasing in the Irish: part of the song, already mentioned, on Mable Kelly, by Carolan, which has been sweetly versified by Miss Brooke, may serve as an example. 


> 1. As when the softly blushing rose
>   
> Close to some neighbouring lily grows,
>   
> Such is the glow thy cheeks diffuse
>   
> And such their bright and blended hues!
> * The timid lustre of thine eye
>   
> With nature's purest tints can vie,
>   
> With the sweet blue-bell's azure gem
>   
> That droops upon its modest stem!
> + Even he whose hapless eyes no ray
>   
> Admit from beauty's cheering day,
>   
> Yet, tho' he cannot see the light,
>   
> He feels it warm, and knows it bright!
> 





In a composition of an earlier date, we find the following. 


> 1. On her soft cheek, with tender bloom,
>   
> The rose its tint bestowed,
>   
> And in her richer lips' perfume,
>   
> The ripen'd berry glowed.
> * Her neck was as the blossom fair,
>   
> Or like the cygnet's breast,
>   
> With that majestic graceful air,
>   
> In snow and softness drest.
> + Gold gave its rich and radiant die,
>   
> And in her tresses flowed,
>   
> And like a freezing star, her eye
>   
> With heaven's own splendour glowed.
> 






---

p.339



Miss Brooke gives a striking, and to me, novel simile from one of Carolan's songs, composed for Miss Mary O'Neil. ‘Her eyes (says he) are to her face, what a diamond is to a ring; throwing its beams around, and adorning the beauty of the setting.’ The fine expression of ‘the mind illumined face’ is a favourite one in Irish verse; and amongst the most generally used comparisons, is that of Maiden's Lip — to the Wild Strawberry.


The description of Bridget Brady, by her lover Thaddeus Ruddy, a bard who lived about the middle of the seventeenth century, is perhaps unique as a specimen of local simile. 


> 1. She's as straight as a pine on the mountains of Kilmannan,
>   
> She's as fair as the lilies on the banks of the Shannon;
>   
> Her breath is as sweet as the blossoms of Drumcallan,
>   
> And her breasts gently swell like the waves of Lough Allan;
>   
> Her eyes are as mild as the dews of Dunsany,
>   
> Her veins are as pure as the blue-bells of Slaney;
>   
> Her words are as smooth as the pebbles of Terwinny,
>   
> And her hair flows adown like the streamlets of Finny.
> 





I recollect once having seen a curious Irish Romance, (to which Miss Brooke alludes in a note,) where the heroine is introduced to the hero by means of a series of comparisons. This lady, of course a princess, looking from the window of her chamber one wintry day, saw a raven feeding on some animal that had been recently killed, and the marks of whose blood tinged some newly fallen snow. ‘Is there any one in the world,’ asked this princess of her attendant, ‘whose hair is black as that raven's wing, whose complexion is as pure as that blood, and whose skin is as fair as that snow?’ To this her highness's attendant replies in the affirmative; and, in order to convince the princess, who, in consequence of some old druidical prophecy, had been shut up all her life in a dismal tower, secretly introduces a handsome young prince to her apartment: on their first meeting, they are deeply in love with each other; he carries her off — and so commences their eventful history!




---

p.340


These romantic tales are abundant; but there is a great poverty of fancy and sameness of incident in them, notwithstanding **Spencer**'s commendation: ‘Yea truly,’ says the poet, in his View of Ireland, ‘I have caused divers of them to be translated unto me that I might understand them, and surely they savoured of sweet wit and good invention.’ Fingal and Ossian generally perform leading parts, and the adventures of a chief detained by spells in a magician's power, and a lady transformed into a swan or a deer, whose natural form is restored on the introduction of Christianity, are amongst the most common. On the latter fiction **Mr. Moore** has founded the song of Silent, O Moyle in his Irish Melodies; but the less refined author of Hesperi-neso-graphia gives us, in a few lines, all the spirit of this tedious legend: 


> 1. The next strange story which his ears
>   
> Receiv'd, was of some wolves and bears,
>   
> Who once were men of worth and fame,
>   
> But by enchantment brutes became;
>   
> And would (if tales sung truth) obtain
>   
> Their former human shape again.
>   
> That then, through all the western ground,
>   
> The crooked harp with joy shall sound;
>   
> And that a monarch of their own
>   
> Shall sit upon the western throne,
>   
> And drive from thence by force, all those
>   
> That would his powerful arms oppose.
> 





It has been said that a similarity of feeling exists between the music and poetry of Ireland, as in common both excel in the expression of plaintive sorrow; 


> 1. And sure if to thy harp belong
>   
> One dearer — one exclusive tone,
>   
> The mournful cadence of thy song
>   
> Proclaims the chord of grief thine own.
> 






---

p.341


Hence the Irish elegy is considered to be superior to heroic compositions, from the variety of tender and endearing appellations with which the language abounds. Amongst the elegies given by Miss Brooke, that ascribed to Edmund Ryan, or Ned of the Hills as he was familiarly styled, is worthy of being better known.


Ryan, according to tradition, was one of the partizans of James II., and the confiscation of his estate followed the defeat of that monarch at Boyne. Obliged to retire before the victorious forces of William, Ryan headed a party of freebooters termed Rapparees. To a mind capable of producing compositions of exquisite pathos, how revolting must the association with a gang of lawless plunderers have been! Many songs are still extant in Ireland, attributed to Ned of the Hills, and a beautiful popular melody is distinguished by his name.


The elegy translated by Miss Brooke is addressed by Ryan to his mistress, who appears to have forsaken him on his loss of fortune. Although I have quoted so largely from the Relics of Irish poetry, I cannot resist copying a few stanzas. 


> 1. Bright her locks of beauty grew,
>   
> Curling fair and sweetly flowing,
>   
> And her eyes of smiling blue,
>   
> Oh how soft — how heavenly glowing!
> * Ah poor plundered heart of pain,
>   
> When wilt thou have an end of mourning;
>   
> This long, long year I look in vain
>   
> To see my only hope returning?
> + Why art thou false to me and love?
>   
> (While health and joy with thee are vanish'd)
>   
> Is it because forlorn I rove,
>   
> Without a crime, unjustly banish'd?
> 
> 
> ---
> 
> p.342
> 
> - Why do I thus my anguish tell
>   
> Why pride in woe — why boast of ruin?
>   
> Oh! lost treasure, fare thee well,
>   
> Lov'd to madness — to undoing!
> * Yet oh hear me fondly swear
>   
> Though thy heart to me is frozen,
>   
> Thou alone, of thousands fair,
>   
> Thou alone should'st be my chosen!
> + Every scene with thee would please,
>   
> Every care and fear would fly me,
>   
> Wintry storms and raging seas
>   
> Would lose their gloom if thou wert nigh me.
> - Such, oh Love! thy cruel power,
>   
> Fond excess and fatal ruin;
>   
> Such, oh Beauty's fairest flower,
>   
> Such thy charms and my undoing!
> 




The Iberno-Celtic Society, recently established in **Dublin** for the preservation of Irish literature, have published, under the title of their Transactions, a Chronological Account of Irish Writers, with a Catalogue of their Works. This is not an uninteresting volume, although it abounds in historical and literary inaccuracies, which would be more pardonable had the compiler or editor commented with less severity on the errors of others; one example may serve: speaking of **Carolan** — ‘Some accounts of the life of this bard,’ says the editor, ‘have been published by different authors; but all are erroneous so far as relates to the place of his nativity and some circumstances belonging to his early life. The biographers of O'Carolan, say, ‘He was born in the village of Nobber, in the county of West Meath, on the lands of Carlanstown, which were wrested from his ancestors by the family of the Nugents on their arrival in this kingdom in the reign of Henry II.’ ‘He must be deprived of sight at a very early period of his life, for he remembered no impression of 



---

p.343




colours.’ In these two short extracts there are nearly as many *falsehoods* as lines; and yet these errors have been repeated in a History of ‘Irish Worthies’ lately published in London. This is inexcusable in an editor who had the means of obtaining better information,’ &c. After some vaunting remarks we come to a breathless continuity of negatives to these assertions.


‘**Torlogh O'Carolan**, then, was not born in Nobber; nor is Nobber on the lands of Carlanstown; nor is Carlanstown in the county West Meath; neither did the Nugents ever wrest those lands from the ancestors of Carolan; nor was he deprived of sight so early in life as to have no recollection of colours.’ The result, however, of the ensuing half page devoted to correct this important matter is that Carolan was born at Newton, a small village *three miles and a half from Nobber*, and that, on entering his fifteenth year, he lost his sight in consequence of the small-pox. I will now venture to point out one or two errors which struck me on glancing over the Transactions of the Iberno-Celtic Society.


‘In 1565, **Donald M'Carthy, created first Earl of **Clancarty****,’ is mentioned as the author of some poems. It will be remembered by the reader that this title was first bestowed on the M'Carthies by **Charles II.**, on account of the services of Lord Muskery, whose actions were conspicuous during the revolutionary events subsequent to 1641. Again, John M'Donald, or Shane Claragh, is stated to have presided at the **Munster** Bardic Sessions held at **Charleville** in the county **Cork**, in 1755. The inscription on his tomb, copied at page 102 of this volume, proves him to have died in 1754; and I believe it will be found that the **Munster** Bardic Sessions or Meetings were held at Brury in the county **Limerick**, and not at **Charleville** in the county **Cork**. These instances may be sufficient to establish the statement I have made of inaccuracy, and I have been induced to notice them in case the next volume of Transactions may question my correctness in these particulars.




---

p.344


It is almost impossible for any historical or topographical work to be free from error, and individually I beg to acknowledge the advantages I have derived from the volume, on some details of which I have ventured to remark; but it must be felt that the repetition of such trivial errors as those in the biography of Carolan did not call for the application of coarse and ungenerous epithets. Under any circumstances, it is a degrading and illiberal retort of a public body to depreciate the labours of a young man who published a valuable and useful book, The Irish Worthies, without assistance in the compilation, and under the most disheartening and unaccountable neglect. It is only necessary for me to state a fact which has come within my own knowledge, that Mr. Ryan, who is an Englishman, was allowed by two noblemen, for some months, a certain number of franks to enable him to solicit information from individuals resident in Ireland, and who might naturally be supposed to feel an interest in his undertaking. Of an incredible number of letters so addressed, I believe not more than three received any reply; but this was not all; insult was added to contempt, and Mr. Ryan's letters, in some instances, after being opened, were inclosed back to him, for the satisfaction of causing him to pay double postage!


