

#Portions of a manuscript history relating to Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Portions of a manuscript history relating to Ireland
====================================================


Author: Meredith Hanmer
-----------------------


### File Description

Hiram MorganDonated and introduced by Hiram Morgan

Encoded in TEI-XML/SGML by Beatrix Färber

 1. First draft.Extent of text: 19630 words#### Publication


CELT: Corpus of Electronic Texts: a project of the History Department, University College Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2021) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E590002Availability [RESTRICTED] 
Material in the preamble is copyrighted to its author. The text is available with prior consent of the CELT programme for purposes of academic research and teaching only. 


#### Sources


**Manuscript Sources**2. 'Portions of some manuscript history of the time', TNA, SP63, 202, pt.3, no.140 ff.281-8.
3. 'Memoranda concerning certain rebels of Munster', TNA, SP63, 202, pt.3, no.112, f.212.
4. 'Memorandum concerning the affairs of Munster', TNA, SP 63, 202, pt.4, no.57, ff.122-3.
5. 'Portion of some manuscript history', TNA, SP 63/203, no.106, ff.263-5.
6. 'Rough notes of a manuscript history', TNA, SP 63/205, no.70, f.109.
7. 'Portion of a manuscript history', TNA, SP63/205, no.74, ff.117-21.
8. 'A note of certain events in Irish History, TNA, SP 63/208, pt.3, no.89, f.239.
**Calendars (Editions)**2. Ernest G. Atkinson, Calendar of State Papers relating to Ireland, of the reign of Elizabeth, 1598, January - 1599, March (VII, London, 1895).
3. Ernest G. Atkinson, Calendar of State Papers relating to Ireland, of the reign of Elizabeth, 1599 April - 1600, February (VIII, London, 1899).
4. Robert Pentland Mahaffy, Calendar of State Papers, relating to Ireland, of the reign of Elizabeth, 1 November 1600 - 31 July 1601, (IX, London, 1905).
5. Robert Pentland Mahaffy, Calendar of State Papers, relating to Ireland, of the reign of Elizabeth, 1601-03, with addenda 1565-1654 and of the Hanmer Papers (X, London, 1912).
**Books and Pamphlets**2. M. Hanmer, The Great Bragge and Challenge of M. Champion ... confuted and answered by M.H. (London, 1581).
3. M. Hanmer, The Jesuites Banner ... With a Confutation of a late Pamphlet ... entitled A Brief Censure upon two Books written in Answeare to M. Champion's offer of disputation, &c., (London, 1581).
4. M. Hanmer, The Baptizing of a Turke, a sermon (on Matt, v. 16), preached 2 October 1586 at the collegiate church of St. Katharine (London, 1586).
5. M. Hanmer, The Chronicle of Ireland in Sir James Ware (ed.) The Historie of Ireland, collected by three learned authors (Dublin, 1633).
6. Judy Barry, 'Hanmer, Meredith',�Dictionary of Irish Biography, (ed.)�James McGuire, James Quinn (Cambridge, 2009).
7. Alan Ford, 'Hanmer, Meredith (1543–1604), Church of England and Church of Ireland clergyman and historian', Oxford Dictionary of National Biography (Oxford, 2008).
8. Angela Andreani & Andrew Hadfield, 'The Clergy and the Military in Early Modern Ireland' in Matthew Woodcock & Cian O'Mahony (eds), Early Modern Military Identities (Woodbridge, 2019), 121-37.
9. Angela Andreani, Meredith Hanmer and the Elizabethan Church: A Clergyman's Career in 16th Century England and Ireland (London, 2020).
**The edition used in the digital edition**2. Meredith Hanmer, Portions of a manuscript history relating to Ireland. Meredith HanmerHiram Morgan (ed), Electronic [7 documents] Corpus of Electronic TextsCork (2021)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers seven documents found the Irish State Papers. They were calendared separately under 1598, 1599 and 1601.


#### Editorial Declaration


##### Correction


Text has been proof-read once at CELT and parsed.


##### Normalization


The electronic text represents the edited text. "Apart from switching the first two documents, the rest have been put in the same order as they appear in the calendar. The rough and incomplete nature of the work, still plainly in the early stages of research by the author, is indicated in a host of ways. There are gaps on various pages for information to be filled in, a large number of interlineations including some on flaps pasted to the relevant page, deletions some of which were later reused elsewhere and blanks left for details such as Christian names to be added. The deletions are here shown crossed out whilst blanks are indicated by two hyphens. Where marginal annotations originally occurred, they have now been set adjacent in the body of the text in square brackets. Minor additions to make sense of the text in certain places have been underlined. All the documents are now fully transcribed. Commissions and letters inserted by the author that were summarized in the calendars appear in italics. The long list of Irish - mostly Ryans - in revolt in Tipperary and Kilkenny previously truncated is complete. Also omitted text, indicated by a long ellipsis in the calendar, relating to the colonists being stripped naked has been restored." (Hiram Morgan)


##### Quotation


Direct speech is indicated using q tags.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the group of documents;div1=the individual document; paragraphs are marked; ///page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Names of persons (given names), places and group names are not tagged. 


#### Canonical References


This text uses the DIV1 element to represent the document. ### Profile Description


Created: by Meredith Hanmer
 (1598–1601) #### Use of language


##### Language: [EN] The text is in late sixteenth-century English.


##### Language: [LA] Some words are in Latin.


### Revision History


* (2021-02-09) Beatrix Färber (ed.)

* Preliminary XML and HTML files created.
* (2021-02-08) Beatrix Färber (ed.)

* More structural and content markup applied, file reparsed and validated.
* (2021-02-05) Beatrix Färber (ed.)

* Basic structural and content encoding applied; header created; file parsed, file proofed (1).
* (2020-12-16) Hiram Morgan (ed.)

* Texts edited, proofed (1); preamble and bibliographic details supplied, file donated to the CELT Project.




---


#### Corpus of Electronic Texts Edition: E590002


### Portions of a manuscript history relating to Ireland: Author: Meredith Hanmer




---

p.i


### Preamble


This is a series of seven documents found the Irish State Papers. They were calendared separately under 1598, 1599 and 1601 to represent certain events then taking place or where the date seemed most convenient but they make more sense when they are combined and analysed together and indeed acquire significance as such. As recognized by the titles given by the calendar editors to some of the documents, they are in fact passages and notes for a projected history. Apart from an account of the Battle of the Yellow Ford in Ulster, these writings mainly concern the 1598 revolts in Munster and South Leinster and their aftermath. What they amount to is an apology for the actions of Thomas Butler, earl of Ormond, as Lord Lieutenant General of Ireland in this crisis period. Indeed they incorporate a number of documents, relating to Ormond or which passed to and from him at this time that serve to justify the actions he took. Most notably it includes an explanation of why Field Marshal Sir Henry Bagenal rather than Ormond led crown forces to relieve the Blackwater Fort in Ulster as well as the earl's own role immediately after that disaster in saving the Munster towns from the spread of revolt in the South. Specifically these documents carry unique information about the terror campaign of the McSheehys against the Munster plantation, about the outbreak of 1598 revolt in Munster, the failure of the provincial presidency's response, the flight of the planters to the towns, the state the towns were then in and the twists and turns of Mountgarrett and other gentry across the south as Ormond sought to restore order. The execution of Murrogh Óg McSheehy in Cork city and flights of Justice William Saxey and Bishop William Lyon out of harm's way are vividly portrayed. There is also a reference to Edmund Spenser's property at Kilcolman in North County Cork being attacked not in 1598 but in 1597. Interestingly, although the author makes reference to the massacre of fleeing planters, he does not recite the atrocity stories luridly told by English commentators at the time of the 1598 revolt.


In stylometric tests of the first six documents along with other Munster revolt-related manuscripts, the author was revealed as the conservative Welsh churchman, Dr Meredith Hanmer (1544/5–1604).[1](javascript:footNote('E590002/note001.html')) These documents matched exactly with text from his early Irish history entitled The Chronicle of Ireland, which was published posthumously by Sir James Ware in 1633. This is made more obvious when one recognizes that that the author of both lots of text uses 'Anno' to introduce a new year and refers to the audience as 'gentle reader'. Furthermore the apologetic element and access to archival materials is easily explained when one realizes that Hanmer was Ormond's military chaplain in this period and went on campaign with him. This determination permits the addition of the seventh document from 1601 - 'Notes of certain events' which also has Ormond information and uses 'anno' - that the calendar editor Robert Pentland Mahaffy supposed to be by Hanmer. Although Mahaffy had not edited the manuscript portions in the previous two volumes and made no retrospective linkage, he clearly recognized Hanmer's handwriting as he was responsible for calendaring the Hanmer papers at the end of the following 1601-03 volume. The identification of the author of these seven documents also dates their writing to sometime between the Battle of Kinsale and Hanmer's death in 1604. Overall the documents reveal considerable knowledge of the plantation of Munster and a scurrilous view of the planters, Protestant clergy and English administrators of the province. Here Hanmer had personal experience as a holder of benefices in Waterford and Cork, though he may also be echoing the opinions of Ormond himself. Added into the mix with the rest of the Hanmer's papers on medieval matters, it looks like these documents were intended to form part of a second follow-up chronicle by him on Ireland since the Norman conquest. In it Hanmer was plainly setting out to repay the patronage he had received from Ormond by presenting a positive picture of him to posterity following the latter's captivity and effective retirement from politics. Hanmer's death prevented this exercise coming to fruition. In the event Ormond's historical image was burnished by a Neo-Latin epic by Irish poet Dermot O'Meara but it is a great pity that Hanmer's history was never completed as his might otherwise have provided us with a marvellous gutting of the Tudor Conquest of Ireland from inside the belly of beast.[2](javascript:footNote('E590002/note002.html'))


Apart from switching the first two documents, the rest have been put in the same order as they appear in the calendar. The rough and incomplete nature of the work, still plainly in the early stages of research by the author, is indicated in a host of ways. There are gaps on various pages for information to be filled in, a large number of interlineations including some on flaps pasted to the relevant page, deletions some of which were later reused elsewhere and blanks left for details such as Christian names to be added. The deletions are here shown crossed out whilst blanks are indicated by two hyphens. Where marginal annotations originally occurred, they have now been set adjacent in the body of the text in square brackets. Minor additions to make sense of the text in certain places have been underlined. All the documents are now fully transcribed. Commissions and letters inserted by the author that were summarized in the calendars appear in italics. The long list of Irish — mostly Ryans — in revolt in Tipperary and Kilkenny previously truncated is complete. Also omitted text, indicated by a long ellipsis in the calendar, relating to the colonists being stripped naked has been restored. The idea of ‘the women covering with their hands that which nature commanded to be kept secret’ was obviously too indecorous for Victorian editor Ernest George Atkinson!


Hiram Morgan,
  
School of History, UCC

Portions of some manuscript history of the time
-----------------------------------------------


### TNA, SP63, 202, pt.3, no.140 ff.281-8, calendared under [October] 1598, Cal. S.P. Ireland, 1598-99, pp. 319-26.


*[1598]* In August great consultation was had about victualling the fort at the Blackwater, and relieving the garrison there, greatly distressed for lack of victual. It was thought good that letters should be directed to Captain Thomas Williams, then chief commander of the fort, that he should parley with the Earl of Tyrone, and depart upon honourable conditions, the which then might easily have been concluded; the which letters were effected and signed by the Lords Justices, Lord Lieutenant, and Council. But the Lord Lieutenant had no sooner left Dublin, but the Lords Justices called back the letters, and wrote to the Lord Lieutenant (so did Sir Harry Bagnall also, the 8th of July) for his presence, and direction in any wise not to give over the fort, but, maugre the beard of the enemy, to victual the same; which advice turned to the great dishonour of the Englishry, and the loss of many a brave man's life. The Lord Lieutenant, upon the said letters, returned shortly after to Dublin, conferred with the Lords Justices and Council, mustered three thousand nine hundred and odd able men, well appointed, with victuals sufficient, and directed them towards the north, with commission granted to Sir Harrie Bagnall, bearing date the 23rd of June 1598, as followeth:

> 
> ‘Thomas Baron of Arklow, Viscount Thurles, Lord of the liberty and regality of the county of Tipperary, Earl of Ormond and Ossory, Lord Treasurer of Ireland, Knight of the most noble order of the Garter and Lord Lieutenant general of Her Majesty's Army and forces in and throughout the said Realm, by land and sea to Sir Henry Bagenall knight and marshall of the said Army and forces, greeting. Where it hath pleased her most excellent majesty by her most gratious letters patent under the great seal of England to ordain, constitute & make the said Earl to be her highness' lieutenant general, captain of the said army and forces, giving and granting to him full power and authoriry to command all her majesty's captains, constables of her highness' castles, & commanders of any forces, in any part of the said realm to serve her Majesty in any such places as his lord shall think meet and convenient to appoint and limit them for the defence of the said realm, against rebels or any other foreign enemies, giving also to the said Lord Lieutenant full power & authority in his own person, to levy and lead or cause to be led, all and singular her highness people and subjects of that Realm for her majesty's service, for the resisting and subduing of the said rebels and enemies, and further to do and execute, all and every other thing as Lord Lieutenant general, as by the said letters patent dated at Westminister the XIXth day of October, last past before the date hereof may appear. Forsomuch as the said Lord Lieutenant cannot be in person in all places of this Realm, needful for his presence for the prosecution of the said rebels and enemies, considering the dangerous revolt in the diverse places in the same. Therefore for the better effect of her majesty's services in this behalf and for conferring some part of his authority in some other meet person, the said Lord Lieutenant having special considerance in the approved valour, fidelity, circumspection and experience, of you the said marshal in her majesty's service and upon the imparting hereof to the Lords Justice and Council and their good liking of the same, have and do by virtue of her majesty's said letters patents, and by those patents, do ordain, constitute and make, you the said Sir Henry Bagnall, knight in the absence of the said Lord Lieutenant general to be chief and general commander of all such her majesty's forces of Ardmagh, Antrim, Down, Louth, Meath, Westmeath and the county of Drogheda or in any of them or the borders of the said counties, or any of them, aswell within liberties as without, and aswell by sea and by land. Giving to you by or any of them, in the said seven counties and every of them, and for the prosecuting of the said rebels and enemies into any other county or borders in the absence as aforesaid, and to use and employ, the said last receyted (sic) forces, against the said rebels and enemies, as well for the defence of those parts of the realm as for the prosecution of the said rebels and enemies as to you shall seem best for her majesty's service, And therein in the absence as aforesaid to deal and employ and absolutely to all respects and purposes and with as full power and authority, aswell for the defence and suppressing as aforesaid, as if the said Lord Lieutenant were there personally present, or may or might do, by virtue of her majesty's said letters patents, or any other letters patents in this behalf, and for taking of victual and carriages for the said service. Requiring not only you the said Sir Henry Bagnall to attend her Majesty's said services, and such directions as the said Lord Lieutenant shall from time to time give or direct you on this behalf. But also hereby requiring all manner of lords, captains, mayors, sheriffs, gentlemen as well within liberties as without, to be to you obeying, aiding, assisting and to perform you direction and commandments on this behalf, as if the said Lord Lieutenant were personally present. Provided always that the grants and authority by those present made and given to the said Sir Henry Bagnall shall no longer continue but during the absence and pleasure of the said Lord Lieutenant and until the contrary thereof shall be signified from the said Lord Lieutenant to the said Sir Henry Bagnall in writing under the hand and seal of the said Lord Lieutenant for the revocation of the same.’
> [3](javascript:footNote('E590002/note003.html'))
> 
> 
> 




Whereunto the Lord Lieutenant subscribed his name and put to his seal of arms at Dublin the 23rd of June, in the presence of divese witnesses, together a proportion of the Lords Justices and Council well liking of the aforesaid grant and authority made to Sir Henrie Bagnall. The which circumstances I do the rather more largely insert, because of the accidents which in this behalf befell, contrary to all their expectations, the which the reader hereafter shall be better acquainted withal. The Earl of Tyrone, understanding of these forces coming against him, called the chiefs of his country, laid before them all that might be with them and against them. Many he found with him, and many against his purpose; yet they, for fear of him, promised to yield and join with him. They made preparation, and marched to meet the Queen's forces. When Her Highness's forces were come within a mile and somewhat more of the fort, and that the garrison within the fort had descried the English colours, they threw up their caps for joy, hoping to have a better supper than the dinner they had that day. To be short, the enemy lay all at an advantage, suffering the forces to pass by, and set first upon the rearward, assaulting them very fiercely, which were withstood very valiantly by Captain John Parker and others of that regiment. Then the rest of the traitors set upon the vanguard, and every man lying in ambush played their parts. That which came to pass is a grief to the Englishry. Two barrels of powder by unfortunate means in the regiments of Her Highness's forces were set on fire, spoiling our own men; a great field piece, which cleared the way, lost in a bog; Sir Henry Bagenal, Knight, General of the said forces, by a bullet which pierced his skull, falling down for dead. The whole army was discomfited. They fell to retire, and more perished in the retreat and trenches, which the enemy had made, than by force of arms; that day being Monday, and the 14th of August. Beside the general aforesaid, the Englishry lost Captain Moyle Moore O'Reilly, a gentleman of Irish birth, but a man, and a most valiant soldier every way; Captain Harry Street; Captain -- Pettitt; Captain -- Morgan; Captain Matthew Evans; Captain -- Henshaw; Captain -- Bethell; Captain Thomas Lee; Captain Henry Turner; Captain -- Fortescue; Captain -- Elsdon. Captain -- Rumney escaped the battle, went to a bush to ease himself, and there was knocked on the head. Captain -- Ratcliffe was taken by the enemy, but there died of his wounds. Captain--Cosby taken by the enemy. Captain -- Burke was killed. A young gentleman, one James Harrington, son and heir to Sir Henry Harrington, Knight, being not employed but voluntarily, going only to see the service, was there left for dead. There many a brave soldier, not by force of arms, but by misfortune and unskilful leading of new comers and unexperienced Captains, were cast away. The traitors and rebels like dogs lay dead in every bush. What then? The enemy triumphed, and after parley had with some of the English Captains, gave the army leave to depart, upon condition they should not go to the Newry, but straight to Dundalk. Contrary to this they went to the Newry, for, if they had gone to Dundalk (he having, according to his wonted treasons laid ambush for them), his determination was to cut them off every one. To be short, the fort upon good advertisement was yielded up by Captain Thomas Williams, and all to depart, leaving behind them the ordnance and munition. This was no sooner done, but horseboys and Irish cursitors carried it about the land, animated the enemy, and discouraged the true subject. Tidings hereof came to Her Majesty, who was mightily displeased. The Lords Justices and Council excused themselves, and signified that the victualling of the fort pretended was by the Lord Lieutenant General, without their privity. He cleared himself, and continued his honourable credit. Her Majesty, being wonderfully moved and sorry for the loss of her worthy subjects, wrote to the Lords Justices and Lord Lieutenant as followeth. Directed 
  


>   
> To the most reverend father in God our right trusty and right well-beloved the Lord Archbishop of Dublin and to our right trusty and well-beloved Sir Robert Gardiner kinght, Lords Justices of our realm of Ireland now being and to rest of our council there.
> 
> 
> Most reverend father in God our right trusty and right well-beloved and trusty and right well-beloved, we greet you well.
> 
> 
> Having been moved by divers letters from yourselves, amongst other your lacks to supply that Council with some principal persons of experience and judgment, because you found yourselves unprovided of such as were able either to advise or execute in so many actions of importance, as by the several rebellions in that kingdom were necessary, we are pleased to make choice of our servant Richard Bingham, Knight, whom we have also appointed to be Marshal of that realm, to repair thither for the better furtherance of our service; of whose experience and sufficiency every way, because itis so well known to yourselves, we need say now no more than this, that he doth return with our favour and gracious opinion, of which we do require you to take notice, and to use him and hear him lovingly and friendly, in all things concerning our service. Wherein we know that you, our cousin of Ormond, our Lieutenant, will find great ease and contentment every way, it being neither fit nor possible that you should spend your body in all services at all times; and yet we must plainly tell you that we did much mislike (seeing this late action was undertaken) that you did not above all other things attend it, thereby to have directed and countenanced the same. For it was strange to us, when almost the whole forces of our kingdom were drawn to head, and a main blow like to be stroken for our honour against the capital rebel, that you, whose person would have better daunted the traitors, and would have carried with it another manner of reputation, and strength of the nobility of the kingdom, should employ yourself in an action of less importance, and leave that to se mean a conduction. And therefore, whosoever of our Council should dissuade you from that course, lacked both judgment and affection to our service and did that which is repugnant to the writings of divers of the best and greatest of them in that kingdom.
> 
> 
> *[The Lord Chancellor disuaded him only to grace Sir Henry Bagenal in the service.]*
> 
> 
>  With which particularity we will not now trouble ourselves further, because we are so uncertainly informed of the circumstances of that action; only this we may not hide, that it doth not a little trouble us to find so hard effects of all things from thence, considering the notable supplies of men, treasure, and victuals, more plentifully sent than ever heretofore; wherein, although we do not deny but many things concur to make that State more difficult to be recovered than in former time, yet is there no person, be he never of so vulgar judgment, but doth plainly see notorious errors in that Government. Amongst which we have observed this proceeding for one, upon divers certificates, that, when there was great importunities for lacks of pay for the common soldier, occasioned by contrariety of winds, which kept back the treasure, we did never find that any one of the principal officers did ever forbear taking up their own allowance aforehand, in as plentiful manner as ever they did, a matter wherein they showed small consideration of the necessity of the time, when they were sure that at the next treasure they might be holpen. And for the numbers there maintained, we have great cause to be displeased with this great abuse, from which hath ensued notorious mischiefs, by the Captains entertaining of Irish, only to cover their frauds, and to make gain by licensing English to depart, whereby not only the places which ought to be defended by them are wasted and spoiled in their absence, but also at all times of service they are ready to turn our own arms against our own armies; as hath lately fallen out in this late accident at the Blackwater; wherein we may not pass over this foul error to our dishonour, when you of our Council framed such a letter to the traitor, after the defeat, as never was read the like, either in form or substance, for baseness, being such as we persuade ourself, if you shall peruse it again, when you are yourselves, that you will be ashamed of your own absurdities, and grieved that any fear or rashness should ever make you authors of an action so much to your Sovereign's dishonour, and to the increasing of the traitor's insolency. For other things past, we have well observed, that all the journeys and attempts upon the North have had these successes, that not only our armies have come back with loss, or doing nothing, but in their absence, other parts of our kingdom have been left to be spoiled and wasted by the rebels; and though the universality of the rebellion may be used as a reason of the mischief, yet it is almost a miracle that, with the charges of an army of eight or nine thousand men, the provincial rebels of Leinster and Wexford, and other places, should not be mastered, though the capital rebels have not there been reduced, a matter cried out on by all that either write or come out of Ireland, so as there can be no more token of ill carriage of all things, than where no one thing is reformed. With these things we cannot forbear to charge you in generalities, to the end that you may examine all particulars curiously, and attend the reformation. For the present we think fit only to prescribe you this much, that with all such forces as you have, and shall have by the late increase of those that were appointed for Lough foile, you see all our frontier towns strengthened and provided to defend themselves, especially those that are maritime in all places, because you can well consider that those must be staples of victuals, and retreat for such forces as shall be sent at any time to his prosecution. In the mean time you shall follow the wars of Leinster, which is in the heart of our kingdom, this winter, to the end that those inward provinces of the realm may be freed; and, above all things, seeing you have these late supplies of 4,000 men (when the last of Loghfoile shall be arrived), and that your own books did certify so great numbers in pay before those supplies, that you do use all convenient means to clear our army of the Irish, and so to order it, as for this winter it may be reduced to a list of eight thousand; which numbers, as in all men's opinions they are more than ever were seen needful there, so if we shall pay them, and not have them, we think yourselves will imagine that we shall have no small cause to be offended, having often written hereof, without any answer returned what is done in it. Further also, yourselves well know that, though some soldiers may run from the army to the rebel, it being upon the same continent (which are not many), yet all the rest must return by sea, which is not easy, if such good orders were taken as should be, that no soldier were suffered to embark in any our port towns, without good warrant for their passage. Since the writing of this letter, we have understood that your letter, which we heard from you was sent to the traitor by you, hath since been stayed by accident; whereof, for our own honour, we are very glad, though for yourselves, the former purpose still deserves the same imputation.
> 
> 
> Given under the signet 
>   
> at our manor of Greenwich,
> 
> 
> the 12th day of September in the fortieth year of our reign


[4](javascript:footNote('E590002/note004.html'))


Immediately upon the death of the Marshal of Ireland news came that the Lord Treasurer of England (the Lord Burghley) was dead. Ireland did not mourn for them; for the Marshal (said they) contended with the Earl of Tyrone, and was in some part a cause that he went into action, which bred great woe to the true subjects. The Lord Treasurer in England (said they) hindered the service of Ireland upon the information of some Captains that would not be out of entertainment, and persuaded the Queen's Majesty from time to time (as a good husband for her treasure) to send a handful of money and a handful of men; both which no sooner landed in Ireland, but melted away like hoar frost before the sun; and as the service continued, rebellion increased, and the true subjects went to wreck.


Upon good deliberation, advice, and counsel had in England by Her Majesty, together with her most honourable Council, her pleasure and most gracious favour was signified unto Sir Samuell Bagnall, knight, that he should be employed for the service of Ireland. And this seemeth to be afore their intelligence in England of the former misfortune at the Blackwater; for the accident at Blackwater was the 14th of August, as the reader may gather before, and Her Highness's commission granted to Sir Samuell Bagnall beareth date as followeth, at Westminster, the 12th of August:

> Elizabeth by the grace of God queen of England, France and Ireland, defender of the faith. To our trusty and well-beloved Sir Samuell Bagnall Knight greeting.
> 
> 
> Whereas for the speedier suppressing and chastising of our rebels in the north parts of our realm of Ireland, we have thought meet that some good strength of our forces should be planted upon the river of Loghfoile in our province of Ulster, to be there entrenched and fortified in some place convenient, both for there lesidence (sic) and for the annoying of the said rebels. Which our force we have appointed to be the number of 2,000 footmen and one hundred horse. Ever when we think it meet that some person of valour and experience in military services be appointed to have the charge and conduct of them such as we know you to be. We have therefore upon the special confidence, we have in your judgement and experience made choise of you therein in manner following, viz we do hereby make constitute and appoint you to be colonel general and chief commander of the said two thousand footmen and 100 horsemen, as well colonel captain as others. And do give you full power and authority to receive them into your charge and to use, employ and command them, and every of them, in all things concerning this our service, according to such directions as you shall receive in writings by instruction from us or our privy council at your departure, or here after from time to time by any letters, or other signification of our pleasure, from ourselves, our said council, or from our deputy or chief justices and council of our said realm of Ireland or from the lord lieutenant general of our forces, there for the time being. And we do hereby straightly charge and command all colonels, captains and lieutenants and soldiers that shall be under your conduct, charge and commandment, to give all due obedience and respect unto you, as their colonel general and chief commander. Authorizing you to lay upon all persons disobedient and offending against the laws of military discipline, according to need, in any other our armies and forces, being in our service such punishments as you shall think meet, according to the quality of their offences, using therein the advise of the other colonel and some convenient number of captains in the regiment, whereof the rule of our people committed to execute martial law. And upon trial by an orderly martial court, where necessary cause shall require, to inflict punishment of life or member, upon any heinous offender. And to further we do hereby give you full power and authority, to employ all our subjects, now being under your charge, to invade burn, spoil and destroy and to do all manner hostile act, upon our said rebels, or any their aiders, abettors or adherents and to lead them to such services, as you shall be required by our deputy, justices or chief governor and council of our said realm, or by the lieutenant general of our army and forces, there for the time being, not being repugnant to such instructions as you shall have from us or our council, for your direction in the use of this commission. And we do also hereby make and appoint, Charles Egerton Esquire, having charge of a regiment of 1,000 under you to be our lieutenant over all our forces under your charge. Requiring you that if ought shall happen to you by sickness or death, to commit to him the charge of our said forces, in such manner as we commit them to you, until our pleasure shall be made known unto him. And for that it may be for the advantage of our service, thast you do give ear to such of our rebels or to Scots or others being in arms against us within our province of Ulster as shall be willing to submit themselves and seek our grace, or otherwise be apt to be employed in some spial service. We do therefore give you full power and authority and warrant as well to treat and parley with any our rebels within our said province, or with any Scots or others being in arms against us, within the limits thereof, as also to them and any of them, to grant, safeguard and protection and safe conduct to repair unto you, and likewise to depart from you again, at their pleasure, as you shall agree with them. In which time or as soon as you may, you shall advertise our deputy, justice or chief governor of our said realm and our council there, or the lord lieutenant general of our forces in our said realm for the time being, whom you shall protect and the reasons moving you thereto and shall receive direction from them from time to time as there shall be cause, in what sort you have or shall proceed with such persons to the good of our service.
> 
> 
> In witness whereof we have caused our letters of commission to sealed with our great seal, witness our self at Westminster, the XII day of August in the XL year of our reign.


[5](javascript:footNote('E590002/note005.html'))


He received also instructions at Greenwich, the 17th of August, from the Lords of the Council, the which I need not insert[6](javascript:footNote('E590002/note006.html')), for that the said commission and the whole formerly course, upon some accident, was by Her Majesty altered, as the Lords of the Council signified unto Sir Samuell Bagnall from Greenwich, the 23 of August, as followeth:

> 
> Whereas her Majesty was purposed to send the number of 2,000 soldiers unto Loughfoile in the North of Ireland under your charge, as chief colonel of those companies, whereof 1,000 were levied lately in sundry countries of the realm and the rest were taken out of the West Country being of old soldiers heretofore drawn out of the garrison in the Low Countries, to which end you had your instructions delivered you for your better direction in that service uppon some accident lately happened near to Armagh in Ireland, by the overthrow of the marshal, Her Majesty hath altered her determination, for sending these men to Loughfoile, for this present, and dothe now purpose that as well the horse raised by you as the 2000 foot shall be directed to the port of Carlingford, wherein the like order is given to Colonel Egerton to carry the 1,400, appointed to be embarked at Plymouth withal speed and expedition, first unto Lambay near to the city of Dublin in Ireland and there to stay a tide or two. And in the mean season, if he receive not other direction, from the Lord Justices and Council, then to make his repair to the haven of Carlingford, there to attend such direction, as he receive from the said Lord Justices and Council or Lieutenant-general of Her Majesty's army.
> 
> 
> Therefore whereas of these 2,000 men 600 were appointed to be embarked at the port of Chester, where the horse provided by you are also to be transported Her Majesty's pleasure is you shall in like manner make your immediate repair first to the city of Chester, and uppon your arrival of that port, direct your course with all deligence, with those men that are there, with their captains and officers unto Lambay before Dublin, and there to stop a tide or two. And if in the mean season you can conveniently send word to the state of your arrival, whom we doubt not by our letters already sent thether shall have intelligence thereof and will use the means to give you advise, what course you are to hold. But if in that time you shall hear nothing from them, then you shall proceed directly to go to Carlingford, with your companies of horse and foot, whereupon your landing, you shall advertise the Lord Justices and Council and the Lord Lieutenant General of your arrival in that place, with the number of your forces and bestow your soldiers in the mean season in the towns of Carlingford and Dundalk and the Newry, until you shall receive other order from them or his Lordship what course you are to hold, what directions you are to follow, the government of that realm and of all martial causes being committed to them and to his lordship.[7](javascript:footNote('E590002/note007.html'))
> 
> 
> 




Sir Samuell Bagnall arrived at Dublin the 11th of September (and Colonel Egerton's regiment landed at Youghal in Munster), and took his directions and instructions all new again from the Lord Lieutenant General, with warrants of entries and entertainment to the Clerk of the Check, for him, the Captains of his regiment, officers and companies, to garrison themselves on the northern frontiers with this special caveat, that he should bend his course rather to a defensive war than to an offensive, unless it were with that advantage and care, that he stood always in safety of himself and the forces under him, and in that case to lose no opportunity. The Captains of that regiment were these: Captain Charles Eggerton, second Colonel, Sir Urian Lee, knight, chief commander of the horse company under the Colonel-General, Captain Francis Croftes, Captain Edward Trevor, Captain Edmond Leigh, Captain Francis Roe, Captain Ralph Bingley, Captain Geoffrey Dutton, Captain Walter Rogers, Captain John Burtall, Captain John Owen Tuder, Captain John Sidney, Captain Nicolas Panier, Captain Fulke Conway, Captain John Jesson, Captain Augustine Heath, Captain Edward Blayney, Captain Toby Caulfield, Captain Josias Bodley.


Sir Richard Bingham, Knight, as by Her Majesty's letters formerly appeareth, bearing date the 12th day of September, was made Marshal of Ireland, and arrived at Dublin the 8th day of October, with 200 foot and 50 horse, to be directed in all his course by the Lord Lieutenant General; but, being often written for by the most honourable Lord Lieutenant, to be employed in present service, excused himself, partly with the let by sickness, and also that the Lords Justices stayed him. So commonly they did stay others, more for the safeguard of their private persons than the service of the Prince.


In Munster, anno --,[8](javascript:footNote('E590002/note008.html')) Donnell McCarthy, a bastard of the Earl of Clancarr, grieved as he said that his father allotted him no maintenance, fell into open rebellion, preyed and spoiled many, and got many rogues to follow him. Sir Thomas Norris, then Vice-President of the Province, protected him and procured him his pardon.


~~Thomas Butler lord baron of Cahir with his brethren, kindred and all his country went to open rebellion. The Lord lieutenant wrote unto him that he shold with speed repair unto him with his forces and show his loyalty the which he refused. He wrote the 2nd time, viz the 26 of November 1598 but he came not. For he was bewitched (a fool he was before) by his wife that was Mountgarrett's sister, Doctor Cragh and Father Archer.~~*[9](javascript:footNote('E590002/note009.html'))*


~~In Ormond -- dies.~~


Murtogh Oge McShee, and his brothers Rory and Edmund, from the cradle inclined to mischief, as all that sept hath been, being oft apprehended and imprisoned, and having broken prisons (Murtogh at Limerick, Rory at Kilkenny), after many favours went into open action, and in the end were cut off. Murtogh was grieved (as he said) that he was oft protected, but could never get his pardon; that when the date of his protection was expired, he must pay money for the continuance of it to Sir Thomas Norris from time to time; and that he was no longer able to feed him. This rebel was marked by nature; he had a stump arm; a desperate villain, and a skilful targeteer. He was taken in a wood, killing of porks and making provision to entertain the rebels of Leinster, Tyrrell the traitor and his company. Being brought to Cork, and arraigned, evidence was given against him that he had preyed, spoiled, and murdered about fourscore English families. Small resistance to the rebel, and small aid to the subject, did the President give. When any came to complain that he had lost his cows, ‘Why’ (saith he) ‘must I keep thy cows?’ In the end sentence was given upon this traitor, that he should have his arms and his thighs broken with a sledge, and hang in chains; so was he executed without the north gate of Cork. Anno 1597. Rory was killed by an Irish kern, and Edmund was killed by an Englishman at the spoil of Kilcolman. At this time David Lacy, with his brethren Piers, Ulick, and William, played the rebels. David, being once pardoned, was after killed in service. Piers was hanged at Limerick, Ulick and William were hanged at Kilkenny, by the commandment of the Earl of Ormond; fair riddance of such rebels.


*[October 1598]* In the beginning of October, the unfortunate news of rebellion in Munster, and the general combination of the Irishry thoughout the land against the Englishry, came to Dublin; where the most honourable Earl of Ormond, Lord Lieutenant, understanding thereof, according to Her Majesty's direction formerly mentioned preparing himself for the service in Leinster for the winter following, and having appointed sufficient garrisons for the northern frontiers, directed his course through the Province of Leinster for Munster, to subdue the rebels there lately combined into open action. He took with him from Dublin, the 4 of October, these companies: Sir Harrie Power, Knight, Captain of 200 foot; Captain Harrie Sheffield, Sergeant-Major, leader of 100 foot; Captain Lawrence Esmond, 100 foot; Captain Thomas Lee, his company, 100 foot; Captain John Parker, 100 foot; Captain Richard Greame, 100 foot; Captain Henry Folliot, 100 foot; Captain William Warren's company, 100 foot; Captain William Eustace, 100 foot; Captain Edmund Tobyn, Lieutenant -- Eustace, of the Earl of Kildare's horse. The horsemen at his appointment met him, viz., Sir Walter Butler, Knight, with 50 horse; William Taaff, Lieutenant to Sir Harrie Norris, with 50 horse; Captain John Butler, with 20 horse. When he came to Kilkenny (where he stayed but one night with the sweet lady, the Countess, his wife), he sent for the noblemen and gentlemen of the country to accompany him. And there came the Lord Power, the Lord of Dunboyne, with others. The Lord Lieutenant, understanding that Piers Lacy, a gentleman sometime of good sort in the county of Limerick, but then in open action against Her Highness, had drawn unto him the traitors of Leinster, Captain Tyrrell, Wony McRory, and others, and were ready to lay siege to Kilmallock; marched thither with all haste, and wrote unto the Lord President of Munster, and to the noblemen and gentlemen of Munster to meet him at Kilmallock with all the forces and strength they could make.


The 11th of October, the Lord Lieutenant came to Kilmallock unlooked for. The rebels had determined to assault them, the town had warning thereof, and finding themselves weak (faint hearts and white livers had they, yea, and a number of false hearts) determined to yield up the town for the safeguard of their lives. But when the Lord Lieutenant's trump sounded, and that they understood it was the most noble Earl of Ormond, they opened their gates, and for joy threw up their caps, signifying their lives and goods were saved.


The Lord President of Munster, being sent for, durst not, no, not in the Province committed to his charge (as he said) travel without convoy and strong guard from the Lord Lieutenant (so he wrote unto him and such was the weak sight of that government), who satisfied his request. And so the Lord President come to him to Kilmallock, and the crew of the Englishry followed him saying, his cowardise disposition was the cause of all their overthrow, the which, gentle reader, shall afterwards more at large appear.


There came also to Kilmallock noblemen and gentlemen of Munster, as followeth: the Lord Roche, the Lord Barry, with others.


At Kilmallock, news came to the Lord Lieutenant that Ormond, Ossory, the county of Kilkenny, and all his country, was a burning, preying, and upon destroying by the rebels (Donnell Spainagh, William McHubbert, Phelim McHugh), and that the traitors in Munster determined to burn Mallow, where the Lord President dwelt. The Lord Lieutenant's answer was, that he would be revenged of them that spoiled his country upon his return, but then that he would have special care of the service in Munster. He left a strong garrison at Kilmallock, and marched towards Mallow, the traitor's camp being but three miles off them still as they marched. Afore he came thither, the rebels had burned Buttevant, a town of the Lord Barry's, and were within a mile of him, but he (leaving the foot companies behind) for all the swiftness of his horsemen could not overtake them. They took the woods and bogs, and ran away. At Mallow he took order that the thatch of the houses should be pulled down and burned, to save the rebel a labour; for the whole town, being English, ran away, to their shame. Donnell, called there McCarty Reogh, Lord of Carberry, met with him with threescore foot and twenty horse, ill furnished. The 17 of October he came to Cork, mustered the town, viewed their strength. The townsmen, fearing a further burthen and charge to be imposed upon them, undertook to defend their town. The Lord Lieutenant dealt with the best of the inhabitants of Kinsale, and they in like sort undertook their defence. He came to Youghal the 20th day, mustered the town, found them weak, but great store of beef to be salted, which he commanded to be stayed for the army, and left there, for their defence, Captain Ferdinando Kingsmill and Captain George Flower with their companies. The Lord Lieutenant found generally that cities and corporate towns, few excepted, were very badly or not at all furnished with weapons and munition, neither did they fortify themselves (such was their negligence) in this late time of peace; as, thinking they lived in all security, they never sought to prevent the mischief that might, and then on the sudden, rise, among them.


The misery of the Englishry was great. The wealthier sort, leaving their castles and dwelling-houses, and their victual and furniture, made haste into walled towns, when there was no enemy within ten miles. The meaner sort (the rebellion having overtaken them), were slain, man, woman, and child; and such as escaped came all naked to the towns, the women covering with their hands that which nature commanded to be kept secret.[10](javascript:footNote('E590002/note010.html')) Their moan was great, the sight lamentable; the Lord Lieutenant was therewith much moved. And specially, seeing how shamefully the undertakers in general (very few, not past three or four, excepted) did forsake their castles and strong houses before any enemy entered the county of Limerick, which so animated the traitors in pride to go forwards, no resistance being made or one shot discharged out of any castle, as the very Irish churls, their tenants, and country people, took the spoil of their landlords, and ran to the enemy, furnished with the arms and munition which the undertakers had in their castles, to Her Highness's great dishonour and their own deserved shame and discredit for ever.


*[Castles in Limerick forsaken]* In the county of Limerick these castles were forsaken: Meane, Pallice, Ballenwylly, of Sir Henry Ughtred, Knight, who together with his lady fled to Limerick, left sixteen men in his house, who within two days ran away; Edward Fitton, Sheriff of the county, fled to England, left Glanogher, his house, and lands to the rebels; Sir George Bourchier, having Richard Rowley for his tenant in Loughgirre, put in Ulick Browne, who by treachery gave all to the rebel; Newcastle, Glancuyn, and Portneard, of Sir William Courtney, Knight, who neglected his seignory, put servants in trust that were careless of the defence; Corgrag, Foyne, Shanytt, of Mr. Trenchard, his executors after his decease left all open to the enemy; Tarbert, Bellanecory, of Justice Goold forsaken; Mr. Aylmer left Killfinien without men or victual; Captain Colvin left his house and fled to Asketyn; the abbey of Adare of Mr. George Thornton, where he had thirty men shot, munition, and victual, yet was forsaken, for they all ran away, and the Bruff, which he had in lease from Piers Lacy, wherein the President had put eighteen men in ward, upon their running away, was given up to Piers Lacy; Fannyngton, of William Mainwaring, I marvel at him more than at all the rest, considering his old occupation in England, acquainted with all robbers and thieves in the land, that the rebels in Ireland, brought up in the same school, would not favour him, or at least that he had none of his school-points to defend himself.


*[Castles in Kerry and Desmond forsaken]* In the county of Kerry and Desmond, the island of Kerry, the seignory of Sir William Herbert, after his death was forsaken by one Mr. Williams; Furryes, of Nicholas Browne his seignory; Tralee, a town of Sir Edward Denny's seignory. Generally, all the English in Kerry ran away, when there was no rebel within forty miles of them. Castlemayne was long defended by the ward without any means but their own shifts, which cost John Middleton, a fine clerk, his life, not having his natural diet. They sware to James Desmond the traitor, in parley, that they had victuals for half a year. Hereupon they yielded the castle, and saved their lives, whereas they had not one iota of any food.


*[Castles in Cork forsaken]* In the county of Cork, Mallow, and the town, being Sir Thomas Norris's; and he, President of the Province, ran away first, together with his lady, into Cork, and discouraged all the Englishry about him. Mr. Waynman left Doneraile, and fled away. He was a great sheep-master, and in that trouble ye might buy an English mutton for 12d. Tarregeroghan, where both the Clavells, English gentlemen, dwelt, was forsaken. Mr. Cuff made haste to Kilmallock, left his castle Nyeckill to a young Irishman of his bring up, who sent his master some two wain-load of stuff afterwards, shut the castle, and kept all to himself. Carregaleyn of Henry Ditton; Tractan Abbey, of the seignory of Sir Warham Sentleger, where Mr. Daunt and Mr. Sampson dwelt; 


Ballengary, of Mr. Walter Sentleger;


Castle Mahon of Mr. Beecher;


Derywyllans, Carreganedey of Mr. Hyde's he being in England, his wife fled to Cork, (Patrick Condon was there his own carver); Tallow, a great town, all English, man, woman, and child, where there were about three score householders, thirty good shot, and in all about six score able men, ran away every one. The enemy came after, and burned all to the ground. Balabegg, a town hard by Mallow, of some twenty families, did the like. All the English of the seignory of Sir Walter Ralegh, viz., John Harris, William Andrew -- with others, ran away.


The inhabitants of the lands of Gosbryd, of the seignory of Sir Warham Sentleger, took their flight.


Arundel Castle was forsaken by Walter Grant.


Bostock, lieutenant of Sir Thomas Norris his horsemen, forsook his castle a sevennight afore the enemy came.


William Lions, Bishop of Cork, was loath to be a martyr. First, he forsook a strong house, all of stone, which he had at Ross in Carberry, afterwards left a fine and a strong house he had without the walls of Cork, and fled into the city.


William Saxey, Chief Justice of Munster, urchin-wise, like Harry Pyne of Mogylie, afore presaging the mischief to come, which he no doubt secretly learned and concealed, made haste for England cum pannis, as commonly we term it, with bag and baggage, got a bark, embarked together with him his wife, family, and all that he had, and left the charge committed unto him from Her Majesty at six and seven.[11](javascript:footNote('E590002/note011.html'))


In the county of Waterford, Mistress Dalton, an English gentlewoman and a widow, forsook her castle of Knockmone.


Mr. Hayles forsook his castle of Capperquin, and fled away.


Captain Fitton played the coward, hearing of rebels coming to the country, forsook his castle of Kylmahanyn, in the county of Tipperary, and ran away.


Memoranda concerning certain rebels of Munster
----------------------------------------------


### TNA, SP63, 202, pt.3, no.112, f.212, calendared under Oct. 12 1598, Cal. S.P. Ireland, 1598-99, pp.286-88.


*[Piers Lacy a rebel]* In Munster, about the beginning of October, 1598, Piers Lacy, of the county of Limerick, a gentleman of good sort afore this rebellion, and so accounted of in his country, a justice of peace, Captain of 60 kern, and had been High Sheriff, grew malcontented, went into open action, and after him in manner the whole country. He complained of Sir Thomas Norris, the President of the Province, and of George Thornton, his own tenant. The 10th of August before, he, Gibbon McThomas, and Cadagh O'Magher, came to the Lord Lieutenant, showed their griefs and wrongs offered them in Munster. He protected them, and stayed them for that time from rebellion. This Lacy had done good service, and had gotten letters in his favour for England. Sir Thomas Norris, prying into him at Thornton's suit, stayed the course, wrote to the Lords Justices that he might not be pardoned. The Earl of Ormond wrote oft for his pardon, at length obtained it, sent it to Lacy. Lacy answered the Earl that it came too late, that he was sworn to the rebels in Leix, and received the sacrament upon it, the which he would not break. When the Earl of Essex came to Limerick, Lacy made means to come in; Sir Thomas Norris hindered the service, and told the Earl that he would shortly fetch him in by the ears. After he had practised with Wony McRory, Captain Tyrrell, and the Leinster rebels, and drawn them into that Province, the fear of them was so great, blazed by the horseboys and spies of Ireland, the messengers of the devil, that the whole county of Limerick became mutinous.


*[John of Desmond a rebel]* Next after, John of Desmond, second son to Sir Thomas of Desmond, brother to the late traitor, the Earl of that name, followed him. His grievances.


The Earl of Tyrone sent unto the Province, if James his brother would not be Earl of Desmond, they should choose this John, and take him for their Earl.


*[James calling himself earl of Desmond writeth to the Lord Lieutenant]* James FitzThomas, the elder son of the aforesaid knight and traiterous house burning with the fire of ambition, and desirous to climb to the title of an Earl, concealing in his bosom (as sparkles of fire covered with ashes) his discontentments, brake out, drew after him as many as he could, and from the traitors' camp (though formerly advised by the Lord Lieutenant to the contrary), wrote to the Earl of Ormond, who was then at Kilmallock of his greivances and in excuse of his lewd enterprises, as followeth:

> Right Honourable,
> 
> 
> I have received your letters, wherein your Honour doth specify that you think it very strange that I should go in action with these gentlemen of Leinster. It is so that I have ever at all times behaved myself dutifully, and as true a subject to Her Majesty as ever lay in me; and, as it is well known to your Honour, I have showed my willingness in service against my uncle and his adherents, whereby I have been partly a mean of his destruction. Before my uncle's decease, it may be remembered by your Lordship that I have been in England from my father, claiming title to his inheritance of the house of Desmond, which is manifestly known to be his right. Whereupon Her Majesty hath promised of her gracious favour to do me justice upon the decease of my uncle, who then was in action, and have allowed me a mark sterling per diem towards my maintenance, until Her Majesty's further pleasure were known; of which I received but one year's pay; and, ever since my uncle's decease, I could get no hearing concerning my inheritance of the Earldom of Desmond, but have bestowed the same upon divers undertakers, to disinherit me for ever, having all this while stayed myself in hope to be graciously considered by Her Majesty. Seeing no other remedy, and that I could get no indifferency, I will follow by all the means I can to maintain my right, trusting in the Almighty to further the same. My very good Lord, I have seen so many bad examples in seeking so many gentlemen's bloods, by false and sinister accusations cut off and executed to death, that the noblemen and chief gentlemen of this Province cannot think themselves assured of their lives, if they were contented to lose their lands and livings. As, for example, Redmond FitzGerald, upon the false information of a scurvy boy for safeguard of his life, was put to death, being a gentlemen of good calling, being threescore years of age, and innocent of the crime charged withal, Donogh McCreagh also was executed upon the false information of a villanous kern, who, within a sevennight was put to death within your Lordship's liberty at Clonmel, who took upon his salvation that all that he said against the said Donogh was untrue, that he was suborned by others. Of late, a poor cousin of yours, James FitzMorris, of Mochollapa, is so abominably dealt withal, upon the false information of an Englishman accusing him of murder, who never drew sword in anger all the days of his life, and is manifestly known that he never gave cause to be suspected of the like. Piers Lacy, who was an earnest servitor, and had the killing of Rory McMorrogh, and the apprehension of Morrogh Oge, till he left him in the gaol of Limerick, and after all his services was driven for the safeguard of his life to be a fugitive. To be brief with your Lordship, Englishmen were not contented to have our lands and livings, but unmercifully to seek our lives by false and sinister means under colour of law; and, as for my part, I will prevent it as well as I may.
> 
> 
> Committing your Lordship to God, I end,   
> from the camp at Carrigrowe,
> 
> 
> the 12th of October, 1598,
> your Honour's loving cousin, James Desmond.




All his grievances and allegations aforesaid are found unjust and untrue. The parties that were cut off were by due course of law tried, convicted, and executed. And this traitor James, proceeding in his malicious practices, wrote for aid and munition to the King of Spain, the which letter (gentle reader) thou shalt find laid down in March following. This James and his brother combined with Tyrone, and swore unto him such faith and truth as is among traitors. He repented himself, and made means to come in to the Earl of Essex, but Sir Thomas Norris withstood it, saying: ‘He is but a rascal; I will shortly subdue him with the forces which I have.’


Memorandum concerning the affairs of Munster
--------------------------------------------


### TNA, SP 63, 202, pt.4, no.57, ff.122-3, calendared under [1598], Cal. S.P. Ireland, 1598-99, pp. 428-31.


The Lord Lieutenant, being at Kilmallock, called certain of the undertakers and demanded of them the cause why they, being strong if they had held together, would forsake their houses and castles and lands, which they held of Her Majesty, to her dishonour, their great shame, and the animating of roguish rebels and rascal traitors. There was a great fault in Sir Thomas Norris that, having special direction out of England, and from the Earl of Ormond, afore this rebellion grew ripe, to take pledges and good security of the noblemen, gentlemen, and suspected men throughout Munster, for their loyalty, from time to time; he took slender bonds, he took bastards and children, all not worth a rush. When the rebellion came, then it appeared to his shame, and he could render no good answer to the Earl of Ormond. Again, if he, in discretion, had drawn to a head and had animated the inhabitants of the Province, he had found of the Englishry and Irishry a sufficient number of able men to withstand the forces of the rebels. For in the year 1590, eight years before these troubles, by virtue of a commission directed to the President and Council of the Province, there were mustered in Munster, able men furnished, 9,331; able men furnished and unfurnished, 10,490; and, in this later time, the country was better peopled than in many years before.


The Lord Lieutenant, from Corrabbey, wrote to the Lord President of Munster to call before him such undertakers as he had not formerly met withal, and take assurance from them to appear when called for, to yield reason of their flight.


*[The causes of the misery of the Englishry]* I may not (gentle reader) with silence pass over the misery of the Englishry in their flight, and, in examining the causes, neither enter into God's judgment, neither write in disgrace of the nation.


First of all, I note their great wickedness formerly rooted, not purged, by change of air, but found still procuring the wrath of God, according to that of the poet, ‘coelum non animum mutant, qui trans mare currunt’, they change the air and not the mind that cross the seas. Notwithstanding many wise, godly and virtuous, yet there were out of England, and other countries, traitors, murderers, thieves, coseners, conycatchers, shifting mates, runners away with other men's wives, some having two or three wives, persons divorced living loosely, bankrupts, carnal gospellers, Papists, Puritans, and Brownists. If the enemy, by the permission of God, had not come with a scourge against them (as Josephus said some time of the Jews in Jerusalem), it is like with other plagues, the earth would have gaped, and swallowed them up.


~~Now gentle reader I am to acquaint thee with the principal traitors and rebels in Leinster and Munster, their grievances as they allege and such as practised the combination. In Leinster~~


Secondly, division, contention, and emulation, among themselves, a great cause of their misery. They could not be content to scrape from the Irishry, but one inveighing and suing the other, troubling the courts, and disquieting the country. The English gentlemen in Leix and Offally contended among themselves. In Munster they jarred one with another, so that the Mayor of Cork gave forth that most suits depending before him were between the Englishry. The inhabitants of Curryglasse were so famous; they were never quiet, while they had a penny in their purses, but arresting and binding to the peace, that they were called the clampers of Curryglasse. The prophecie of --


One great fault they found in the President of that Province, that, if they had just cause of complaint against the Irishry, the President, laying aside English sympathy, favoured the Irish more than the English; for he brought somewhat in his hand, and the English came empty, and empty he went away. They were so imperious, that every gentleman would be in commission of the peace; the Lord Chancellor's fault was to grant it. There was one in Munster, a great swearer, they called him Justice God's Wounds; another, killing of Irish cows, selling hides and tallow, they called him Justice Tripes; another, having no land, but a stock of money, hunting, and hawking, and gaming, and coming once a year, they called him Justice When-ye-will. Such insufficiency there was in their service.


Thirdly, it cannot be but the wickedness, insufficiency, and lewdness of the clergy procured this plague; and to say the truth, as it was delivered in the late Council of Trent, ‘omne malum a pontificio culmine,’ all the mischief cometh from the high prelates; such archbishops, bishops, deans, and men of unworthy dignities, as no kingdom hath the like; very few learned and reverend; of the rest, some weavers, some tapsters, and men of occupation out of England; others, mere Irish, having neither learning nor honesty, going in mantles and Irish trous, tippling of ale and aqua vitae, getting of bastards, and never giving themselves to study or preaching; yet these have been by the Governors and magistrates, for rewards and affection, commended into England, Her Majesty therein mightily abused, and God's people disappointed. What shall I say of the inferior sort of priests, English and Irish, all alike for the most part lewd and ignorant. Divers of the English have not one word of Latin, divers of the Irish, broken Latin, meeter for the tavern than for the temple. A scholar meeteth one of them and saith, ‘Come out of the alehouse, Domine;’ he, thinking it was, ‘quomodo vales, Domine,’ answereth, ‘ago tibi gratias.’ The bishops, given to gain and covetousness, and being ignorant themselves, will have no learned and sufficient men, but Irish priests, in their dioceses; for the English ministers will see unto them, will not bribe them, as the Irish do, therefore call they the Irish priests, good milch cows. The bishops grow infamous; by authority and countenance, they will carry things away and doubtful oftentimes it is where to find them and how to trust them. Richard Meredith, Bishop of Leighlin, being charged by an honest gentleman, Mr. Thorneborowe, then newly come from England to be Bishop of Limerick, that there were found great fault with him for breach of promise, answered, ‘My Lord of Limerick, when you have been here a twelvemonth, no man will believe one word that you speak.’ Shameless dealings have shameless answers, and such was the corruption of the time. The Bishops have winked for gain at laymen, children, their own kindred and household servants, and granted them sequestrations and faculties to hold sundry ecclesiastical livings. The Bishops have suffered Papists, Puritans, Brownists, atheists, in their dioceses and households, to preach, to reason, to prate, to gather conventicles, without contradiction or reformation. The example of Derby Cragh, calling himself a Doctor of Divinity, whom the Pope made Bishop of Cork, and graced with the title of **Nuncius Apostolicus**, and James Archer, of Kilkenny, a cosening mass priest, is fresh in memory. This Derby confessed among the traitors, that he had been in Ireland the space of eighteen years, day and night, among them, persuading to rebellion, which he termed the Catholic faith. He wrought the combination, and effected the whole mischief over Ireland, which then took place. Yet no Governor, no Bishop, weighed this matter, and when massing priests and friars were apprehended and brought afore the State, as the Bishop of Dromore and others were, they were quickly set at liberty, and found more grace and favour than they that furthered the service.


Fourthly, and lastly, the corruption of the Governors, magistrates, and Council in general hath deserved this plague. The Irishry desireth no better than a bad cause, and a great bribe to give; then doubteth he not but he shall speed; and such is the nature of them that, when they have corrupted any, they will be the first that will betray it.


Portion of some manuscript history
----------------------------------


### TNA, SP 63/203, no.106, ff. 263-5, calendared under [March 26] 1599, Cal. S.P. Ireland, 1598-99, pp. 499-501.


*[Patrick Condon a rebel]* Patrick Condon and his son followed the former rebels. This Patrick, a foul great lubber, was born when his mother was but eleven years old. He was in rebellion once before with David Barry. Notwithstanding, Her Majesty dealt graciously with them both, giving them both life and lands; yet this Patrick fell to lick up his former vomit of rebellion. He found himself grieved with Arthur Hyde, an English gentleman, whom the Queen's Majesty graced with great favours for his due desert. There was long suit between them in England and Ireland. This Patrick, being weak, was mightily backed by one Henry Pine, of Moghelly, an English gentleman, which furnished the Spaniards with pipe-staves, and Patrick with money, enriched himself, and forgot English sympathy. Patrick was still in his purse, James Desmond, his gossip, in his bosom, both traitors, and at length Henry suddenly goeth for England, leaving with them the charge of all he left behind (as it may be conjectured), to prevent the subsequent mischiefs which the former traitors afterwards practised. When the Lord Lieutenant General was in Munster, he sent his son and heir unto him with his submission, which was received, and shortly he came himself. This Patrick was then lame, for he and other rebels fell out, and there he took his maim.


*[McDonogh a rebel in Duhallow]* McDonogh, a rebel in Duhallow.


*[Finnin McOwen and the O'Mahons rebels in Carbery]* Finnin McOwen McDermond and the O'Mahons, a great sept of that country.


*[Lord of Lixnaw with other in Kerry rebels]* Patrick McMorrish, Lord of Lixnaw in Kerry, and his son, and Thomas Oge of the island. He wrote to the Lord Lieutenant, excusing himself, in June 1598, that he was not able to come to the general hosting, neither perform the things expected at his hands. This Patrick, being in England, was greatly graced by Her Majesty. He was made a pensioner, and sent over into Ireland with letters of great credit, and employed in service of great trust. No sooner was he landed, but he went into open action. Shortly after he was taken, and brought to the Castle of Limerick, where he became, in dishonest sort, too familiar with the keeper's wife, and by her means made an escape. But she with her husband were recompensed for it shortly after, for they both lovingly hanged together. In a while after, this Patrick was taken again, and brought to the Castle of Dublin. Sir William Fitzwilliams, being Lord Deputy, had his hands oiled with the oil of angels, and away goeth Patrick. Last of all, this rebellion no sooner began, but he was forward in action as the forwardest.


*[Donell McCarty & Oswlevan rebels in Desmond]* Donnell McCarthy, a bastard of the Earl of Clancar, once in rebellion before and pardoned, and Owen Oswlevan More, in Desmond. This Oswlevan excused himself for not coming to the general hosting.


*[The Lord Roche and his country rebels]* Maurice, Lord Roche, Viscount Fermoy, with all his country, together with David his son, as the Lord Lieutenant was certified the 21st of November. This Lord Roche practised with Captain Edmund Tobin's company, to repair to him, promising them good usage. David, his son, after a subtle sort, would be of his father's counsel, practise with the rebels, and make fair weather with the President.


*[The Lord Roche to the Lord Lieutenant, in excuse of his rebellion]* This Maurice Lord Roche sent his grievances in writing to the Lord Lieutenant as followeth:

> 
> My duty remembered to your honourable lordship. I had written to your honour before, touching the injuries offered me here and the state I stood in, but that my jealousy with your honour for denying my request made to your lordship for provision of munition, whereby I might defend myself from oppression of enemies, stayed me hetherto, I made brief rehearsal of the intolerable injuries offered me here, to my Lord of Thomond, supposing he would acquaint your honour with the same, according the special intention of my letters sent him, occasioned partly thereto by his vigorous opinion conceived against me in his letters written to his daughter Margaret. He never since wrote unto me an answere, neither do I know whether he have acquainted your honour with the contents of my said letters or no. I thought good therefore to signify unto your honourable lordship how I have been oppressed and mightily abused of the one side and the other. For it is well known that the Lord President, not content to usurp upon my lands, sought also mine own life very earnestly, spoiled my tenants, killed both men, women, and children, and hath been the only overthrow of this country and cause of revolt; all which I am able and ready to prove before your Honour or any competent judge. On the other side, by the adversaries' part, my whole country was ransacked and spoiled, without spare of churches, monasteries, no, nor so much as mine own mansion houses were left, without utter ruin and spoil of all that came to their hands, without spare of place or persons. If I should ask my Lord of Thomond what he or any reasonable man might do in this sudden and cruel perplexity, surely he would not answer with more indifferency than that, in such rare and sudden chances, men (by natural instinct) are to take the next means to preserve themselves and save their lives. It was time for me, where all the chattel and goods of my country were taken, castles and towns were rifled, burned, the ward slain, and mine own life sought for, to look to myself in extreme necessity, being refused of aid and help, as your Honour and the Lord President know. I entered into no action, nor did anything against the duty of a loyal subject, if it be not disloyal to seek that is natural to every one, his own preservation, and to entreat for the same of an enemy. I thought to acquaint your honour herewith and with the oppression and extremity I suffer by this Lord President seeking my overthrow by all means that possible he may, praying your lordship's letters to stay his proceedings against me until such time as I may justify mine own doings before your lordship or any competent judge, as I have said before. So praying your lordship's careful providence to me in this cause and expecting your speedy answer and confortable.
> 
> 
> I take my leave, 
>   
> Castletown,
> 
> , 
> the XVIII of March 1598.
> Your lordship's very loving cousin, M. de Rupe et Fermoy.




*[The Lord Lieutenant's answer to the Lord Roche.]* To the which for answer the Lord Lieutenant wrote.

> 
> We received your letters containing matters whereby you would excuse yourself for entering into the condition wherein you now stand in, having changed your name from a viscount to a traitor, whereby we are sorry. There ought no cause to have drawn you into such action, and you maynot but condemn yourself of the greatest folly that ever man of your sort entered into, who so well knew of Her Majesty's powerable forces, and that upon just complaint you be assured to have justice. As for your jealousy towards me, denying your request for munition (as the world goeth) we are glad you had none. And yet you may not deny that we graunted you a warrant at Cork for a barrel of powder, which you said you could not get there, whereupon we wished you to return the warrant and that it should be renewed at Waterford, since which time we heard nothing from you of that matter and therefore the allegation is frivolous, and not serving your turn. Now it will stand with you to put yourself wholly to Her Majesty's mercy (if it will be accepted) which we see no way for you to obtain, but by doing first some special service, that shall deserve the same.
> 
> 
> And so we end. 
>   
> From Kilkenny,
> 
> , 
> the xxvith of March 1599.
> Thomas Ormond & Ossorie.




*[The White Knight his country in rebellion]* Edmund FitzGibbon, called the White Knight, his John his brother and his country. He was once before in rebellion in his time.


John Barry, brother to David, Lord Barry


Harry Barry oge Lord Kynalea with his brother John Barry


Tegg McDermond brother to Cormack McDermond Lord of Muskerry with the McShees and McSwynes his followers ancient rebels and traitors.


~~William Saxey, Chief Justice of Munster, urchin-wise, like Harry Pyne of Mogylie, afore presaging the mischief to come, which he no doubt secretly learned and concealed, made haste for England cum pannis, as commonly we term it, with bag and baggage, got a bark, embarked together with him his wife, family, and all that he had, and left the charge committed unto him from Her Majesty at six and seven. As the wonted guise of laws is, 'When the thieves go to execution, the Judges ride away.'~~


Base brother of Gerrot FitzJames of the Decies, with all that country, but Gerrot himself took a corporal oath the 17th of December 1598 before the Lord Lieutenant that he would continue his loyalty to his sovereign.


Brother to the Lord Power with the Lord Power, his kerne and all his country.


Rough notes of a manuscript history
-----------------------------------


### TNA, SP 63/205, no.70, f.109, calendared under [May] 1599, Cal. S.P. Ireland, 1599-1600, p.45.


*[November 1598]* the beginning of November Teig O'Brien brother of the Earl of Thomond together with the eldest son of Turlough O'Brien with with all Thomond combined with the rebels.


*[November 4th]* Odwyre having delivered his son in pledge for his loyalty began to revolt.


Patrick Pursell vide Journal the 2 August and 12th.


Sir Terence O'Dempsy knighted by the Earl of Essex.


Portion of a manuscript history
-------------------------------


### TNA, SP63, 205, no.74, ff.117-21, calendared under May 1599, Cal. S.P. Ireland, 1599-1600, pp. 51-8.


Traitors in Leinster, Leix and Offaly. Wony McRory, son of the Rory Og the traitor calling himself O'Moore, with all that traitorous sept, went into action to revenge his father's death, and to recover, as he said, his father's land by the sword.


The O'Connors in Offally followed.


The bastard Geraldines in the county of Kildare, reported by the Lords Justices unto Sir Garrett Aylmer knight and he to the lord Lieutenant from them to be the worst sort of traitors in the kingdom; their ill bringing up, their wicked lives, and shameful disloyalty, to be a slander and shame to the house of Kildare.


Phelim McFeagh, the wolf of the mountain, son of Feagh McHugh, an ancient sept of rebels of which Phelim O'Toole said that ‘they never were nor never would be true’.


Following the steps of his father together with Redmond his brother, oft protected, oft pardoned and many graces and favours offered him yet still in rebellion.


Brian Reogh, brother to Walter the traitor, who was executed at Dublin, and the sons of Garrett Owre, with certain of the Walshes. It is found that he was nine times protected, and twice pardoned, yet never true.


Donnell Kavanagh, chief of the Kavanaghs, called Donnell Spainagh, for that he a boy waited upon Stuckley into Spain, of a stubborn and ambitious sept, descending as they say from McMorrogh, King of Leinster, whose daughter and heir Strongbow married. When the race of noble English birth neglected their possessions, and deputed of their alliance some of the Kavanaghs in their absence and room as tenants to enjoy the same. These Kavanaghs in short space (so did the Moores in Leix) drew sword, and with strong hand claimed the possessions as their own, and from time to time opposed themselves against the English nation, disquieted the land, and continued the rebellion. Dr. Weston, Lord Chancellor of Ireland, was of opinion that, unless Her Majesty would remove them from Ireland, and give them land somewhere else, she would never have her kingdom quiet. This Donnell made claim to Enniscorthy, which Sir Harry Wallop knight possessed, and the rebellious rogues his followers took him for their King of Leinster. Hovenden, an Englishman, but a papistical traitor, took Donnell's son, and carried him to the Earl of Tyrone, with the consent of his father, as a pledge of his fidelity in league of rebellion with him to and blazed abroad that the son was stolen away, full sore against Donnell's will, and that the State might might assure themselves of his faithful loyalty and subjection. Thus he wrought underhand, until the rebellion was ripe, and growen to the height and then he broke out to all kind of mischief. It is found that he was protected and pardoned 14 times. Vide the mischief Phelim did about Dublin. After all this, he came in to the Earl of Essex, who received him in the chamber of presence with more honour and grace than became the Earl to shew him, or he to receive. For the Earl was no sooner gone for England, than Donnell fell to his old vomit.


James FitzPiers, of the county of Kildare, the son of an honest gentleman and true servitor to Her Majesty, Sir Piers FitzJames, having his father with his whole family (as I said before) by Walter Reogh and his rebellious associates burned to ashes, wanting grace, and forgetting his father's injury and villany of traitors, went into open action, and became a malicious rebel. Immediately after the burning of his father, he went into England, delivered his grief and great losses. Her Majesty, according unto her wonted clemency, graced him divers ways, and gave him ten horse in pay. After his return, he behaved himself civilly, and was made Sheriff of that county, kept much company with Captain Thomas Lee, who was a great favourer of the Earl of Tyrone (and then in question and disgrace therefore); and, as it may be gathered, infected with that company, underhand this James practised a long time with the Earl of Tyrone, but at length broke out, and his practices were revealed to the Lords Justices. Captain Lee and he making merry together, said Lee, 'James, thou and I will be shortly McRustclyns,' that is to say Robin Hoods, 'for we can get nothing as we are.' These words were brought to the Lords Justices. They were both sent for by a pursuivant. Lee appeared, was charged with treasons, and was committed to the Castle; but James would not shew himself. He practised to betray the fort in Leix, but failed of his purpose. He made claim to the Lordship of Cloncurry, which was the jointure of the Lady Baltinglas, and, because he could not prevail, he practised with the ward there to betray the same, and so it came to pass. He complained unjustly, as traitors did, of the Earl of Ormond, Lord Lieutenant; the which complaint Sir Garrett Aylmer (in the absence of the Lord Lieutenant) answered, and satisfied the Lords Justices, delivering upon his credit and certain knowledge, that the Earl did him no wrong, and that he was void of any gall towards him. The cause of his knowledge was that he had travailed between them, and found the Lord Lieutenant most honourable, and ready to show him any favour. He feared the Lord Archbishop of Dublin, for that he in England was examined whether the said Bishop had kept Rose O'Toole, wife to Feagh McHugh; as malefactors fearing everybody, and dare not trust themselves. After many mischiefs by him done, when both the Earls met at Athy, the 12 of May, anno 1599, with their forces, to pass into Leix for the victualling of the new fort, he pulled the bridge of Athy upon the river of the Barrow down, manned the castle at the bridge foot, trenched the fords on the river side, to hinder the passage of the horsemen. But when there was a passage found, and horsemen conveyed over to compass the town, the ward ran away, and he, seeing himself in distress, came to the Earl of Essex upon his knees, and desired mercy, and so he was received into favour.


In Upper Ossory, the Baron's nephews.


John McCoghlan joined with Con O'Neill, yet he excused himself in a letter to the Lord Lieutenant, and sent therein enclosed a letter which the traitor of Tyrone sent unto him, to withdraw him from his loyalty.


Redmond Burke, Sir Charles O'Carroll with Con O'Neill and purpose to besiege Roscrea.


The O'Mulrians in Tipperary.


The O'Kennedys in Ormond.


In October 1598 Edmund, Viscount Mountgarrett, having long covered the sparkles of rebellion in the hid ashes of dissimulation, began to break out, having matched his son and heir with the traitor of Tyrone's daughter, his sister with Thomas, Baron of Cahir and, sworn to the general combination of rebellion, practised by Derby Cragh, the Pope's nuncio, first in the county of Kilkenny he acquainteth his followers with his purpose, next he worketh very subtly with the county of Wexford, and writeth to Sir Thomas Colclogh, knight, James Furlong, Robert Codd with others as followeth:
  

*[The Lord Mountgarrett to the gentlemen in Wexford]*

> I commend me unto you.
> I have dealt with all the Cavenaghs in your behalfs, whose promise I have no to meddle or spoil any of your county for the space of one fortnight, so as neither your not any of yours give them or me any cause in the meantime to the contrary and in the meantime I would have you meet me when I shall send you word that we may have further conference together.
> 
> 
> And so I commit you to God, 
> October 1598. 




*[The Lord Mountgarrett to the sheriff &c of Wexford]* Again he writeth to the sheriff and gentlemen of the county of Wexford.

> Gentlemen of the County of Wexford,
> 
> 
> I have entreated peace for you hitherto of all the Irishry in Leinster and now can procure it no longer than Wednesday except you contribute to bear part of their charges in this action as you and they shall agree & if you be so mynded to do or as many as shall let them assemble themselves in some place of the borders and advertise me thereof by Wednesday next.
> 
> 
> In the meantime I commit you to God,Sunday 1598.




*[The Lord Mountgarrett to James Devereux and others]* Again he writeth to James Devereux and the rest of the gentlemen in the aforesaid county. 

> 
> Where the rebels now of late have spoiled me utterly in the County of Kylkenny & now do begin to use you in that sort, therefore I have thought good to do my best in furthering the queen's service, as also to do my commonwealth and neighbour's good. Therefore I am to let you understand that if it shall please you to assist me therein and to bear the charge of two hundred men both in meat and wages for one fortnight I will keep garrison in some convenient place upon the borders, where I will not only bestow myself in the service, but also will undertake whatsoever the country shall lose during that time, to pay it myself or else to venture both mine own person and my companies in pursuit of any of their losses & ever so I commit you to God, this present Friday.
> 
> 
> 




All this while he went about the bush, and pretended the Queen's service, as it appeareth when as he durst confer with the traitorous Kavanaghs and the Irishry of Leinster and to plant garrisons without commission. When he perceived this would not take effect, that the gentlemen of Wexford weighed him not, and that the whole county defied him, out he went into open action, gathered his rebellious forces together, and joined with all the traitors in Leinster and Munster, and sent his agent to Ulster to the Archtraitor of Tyrone, to send him aid thence to strengthen his forces. Then his rogues ran about like the devil's scouts, preying, burning, and killing. The Mayor of Waterford wrote to the Lord Lieutenant-General to that effect, and withal of the death of Philip, King of Spain, and how that Sorleboy took shipping at Lough Foyle to go for Spain. His Lordship likewise was certified from Thomastown how that Mountgarrett stayed all boats, and threatened to kill the boatmen that passed along the Barrow for Waterford. Also intelligence was given that he went about to match one of his daughters, Piers Baccagh his widow, to James Desmond; a second to Donnell Spainagh his son; and third to Gerald McMurtogh Oge his son; a fourth to O'Donnell; the fifth to Wony McRory; the faster to hold by the link of rebellion. The Lord Lieutenant wrote unto him, marvelling what he meant to fall into that outrage of disloyalty to his prince, infamy to his name and utter ruin of his house. For answer, he desired to parley. That granted, and the day and place agreed upon, viz., the 13 of November, beside Gowran, upon the top of a hill called Crossmans, Mountgarrett, with Wony McRory, Morgan McBrian Kavanagh, his son-in-law, Donnell Spainagh, and others, shewed themselves. He sent two horsemen before, and two to second them, at length came himself to a riverside, where the Lord Lieutenant of the other side being come, demanded of him what he had to say. Mountgarrett answereth, 'A day of meeting was appointed as now in this place, and I am come accordingly.' To cut off his preface, said the Lord Lieutenant, 'What say ye to me?' Then began he with trifling matters and long speeches, that he was not regarded according to his calling; that, when the Justices of Assize came to the country, he sat among inferior persons; that the Lord Lieutenant, rejecting his kindred, took base fellows of his counsel, the Sheas and Rouths of Kilkenny; that his Lordship, since his last coming from England, held a hard hand over him; that he wronged him a little before in sending him prisoner to the Castle of Dublin; that he commanded the horsemen to cut off his head by the way; and that he was given to understand that there was a warrant issued from the Lords Justices to his Lordship to apprehend him, that he stood in fear of himself, which moved him to take the course he had. The Lord Lieutenant replied, 'I am sorry to behold the sight that is before mine eyes this day; you, being of my house, and of that creation Lord of Parliament, to be in company with such rascal traitors. As for your grievances, if they were in substance true, yet are they slender causes to induce you into such great extremities. For answer unto you, I do know that every one of discretion, that knoweth you, reverenceth your person. I am not therewith to be charged. You know I have, of my part, used you ever most kindly. As for sitting with the Judges of Assize, none must assist them but such as are of the Commission of Oyer and Terminer. Touching my kindred, they know I love them well. If they be good, I will endeavour to advance them; if they be nought, I will be a mean to cut them off. Where you scorn my counsel, I will hearken unto them that directs me for the best. Since my coming last from England, I have showed you all the favours I could. No marvel you were apprehended upon suspicion, and committed to the Castle of Dublin, having matched with Tyrone, and secretly combined with traitors, by the practices of Dr. Cragh, the which then was concealed, but now come to light. And in that journey, there was no sinister dealing meant towards you, as the Earl of Thomond, your keeper (who used you most honourably), is at all times ready to witness. Lastly, you greatly mistake yourself. For what should I do with the Lords Justices' warrant to apprehend you, when as I had authority sufficient of myself, under the broad Seal of England, to all such effects? But in fine, deceive not yourself. Remember what you have is of the gracious gifts of the Kings of England. Devise how to call yourself back to your duty.' Saith Mountgarrett, 'If you mean it for peace, I will not consent to any without O'Neill.' Hold being taken of that, he most arrogantly added thereto, that he would not do the contrary for all them of the one side and the other side of the river, and that he was not as then sworn to O'Neill, but had sent his agent to him about his affairs. 'Put it down in paper' (saith he) 'if ye please.' The next day, Mountgarrett desired peace for a month or three weeks, until he might hear from Tyrone, upon these conditions, that his tenants and ploughs might not be disturbed; if they were, then would he do his worst; that he and his followers might have license to take meat and drink from Her Majesty's subjects; that there should no more garrisons be drawn into his country, than were at that time. To the which the Lord Lieutenant answered, 'Your proud (sic) and threatenings I weigh not; the course of Her Majesty's service will I not stop, neither so much dishonour Her Majesty as to license any traitor to oppress Her Highness' subjects, for I used not to exact the same myself for Her Majesty's forces, but paid for that I took.' Being demanded what assurance he would give for the observance of the peace, if it were granted, he scornfully answered, 'the gentlemen on this side and that side of the water, and all Leinster to the north, to depend of the same.' One whispered him in the ear, whereupon he explained himself, saying he meant it of all such as would take his part. In the end, peace (without the former conditions) was concluded for three weeks; and Mountgarrett sent, the 15 of November, to the Lord Lieutenant the names of all those that should stand upon his dependence during the said truce by John FitzRichard, whose names for mememy of their rebellions and treasons unto the posterity are these: all the Ryans and Brenans his followers, his sons, daughters and kindred. Lieutenant Burke who with some 50 soldiers came to him from Captain John Masterson, Lieutenant William McKervick who came to him the 14 of November from Captain Thomas Loftous. The same John FitzRichard the 20 of November delivered more particularly these names following, viz his sons Richard Butler, James, Edward, Thomas, Tibald, John and Gilbert. The Lady Mountgarrett with her daughters Margaret, Marie, Marget, Elish, Joan, Mary and Ellen Butler daughter to the Lord of Dunboyne married to her son James. John Butler Fitz Richard brother to Mountgarrett of the rebellious sept of Ryans, Walter Boy O'Rian, Pierse O'Rian, Daniel O'Rian, Teig O'Rian, Lysagh O'Rian, David FitzWalter O'Rian, Teig FitzWalter O'Rian, Teig Mc-- O'Rian, Dermot McMorogh O'Rian, James McJohn O'Rian, Morogh FitzPeirse O'Rian, Richard FitzPierce O'Rian, Richard Fitz Murtagh O'Rian, Dermot McMurtagh O'Rian, Turlough McEdward O Rian, Teig McEdmond O'Rian, Teig McEdmond O'Rian, John McDavid O'Rian, Murtagh FitzDavid O'Rian, John McDavid of Ullard, Turlough McEdmond O'Rian, Cahir O'Rian, Richard Boy O'Rian, James Fitz Henry O'Rian, Pierce FitzMelaughlin O'Rian, Conogher Duff that chiefest shott that kept with Pierse Butler Baccagh. Turlough O'Rian another son to O'Rian, Dermot Roe McMurogh O'Rian, Seron Reagh McDavid O'Rian, Donnell McEdmund O'Rian, Shane Caragh O'Rian. Such a rabble of Ryan rebels (gentle reader) thou hast not read before. Notwithstanding the truce formerly taken, yet Mountgarrett ceased not, but travelled from place to place, animating his confederates and strengthening his complices.


*[The messenger Morgan McBrian from Mountgarrett]* The 5th of December following, Morgan McBrian Kavanagh, his son-in-law, came to Kilkenny in the absence of the Lord Lieutenant, and left in writing this message:


First, the Lord Mountgarrett is content to be at peace for the space of 14 dayes ensuing the date hereof and the said peace to be kept to the Lord Lieutenant and all his both in the county of Kilkenny and Tipperarie and nowhere else.


Item he doth undertake for those which he undertook for already in his last peace.


Item where he is joined and linked both to Oneale, therle of Desmond and divers others in the realm, if he can obtain licence from them, he will then take the order of the lord of Dunboyne, the Lord of Cahir, the Lord Power and the Erle of Desmond, provided that during the said peace if any the queen's forces enter to annoy any of the Irish countries or any of his partakers therein than he to be at his own liberty to help and assist the said partakers during that enterprise.


Further during the aforesaid peace that it shall be lawful for him or any of his to carry, bring away any of his provision or stuff from place to place without lett or impediment, and also to buy or sell in any port town any of his necessaries, armour and munition excepted.


Also that it shall be lawful for those that he doeth undertake for, to buy and sell within his cities or port towns, such necessaries or wares as they shall need, they having his warrant thereunto.


And where it is said and supposed that his breach of peace hath been committed by those that he undertook for, now whether it be wars or peace, if it shall please the lord lieutenant to send any gentleman in his name to prove any breach upon any of those whom he hath undertaken for, then he is ready to make satisfaction according to the quality of the hurt done. So as if he shall prove any breach of the contrary side, he may have the like.


Lastly he doth undertake for those of the Graces and Famagh which are out, and for Thomas FitzWalter, Edmund FitzPierse, Pierse and Richard FitzRichard and with such as follow them.[12](javascript:footNote('E590002/note012.html'))


*[The Lord Lieutenant answereth the message of Mountgarrett]* When the Lord Lieutenant came to Kilkenny and had read this insolent message the 13 of December, he wrote for answer as followeth: 

> 
> ‘Being of late in Her Majesty's service, in the county of Tipperary in prosecution of the traitor your brother-in-law, the Baron of Cahir, Doctor Cragh, and other his complices, I received a paper of your demands, left (in my absence) at my house in Kilkenny, by your son-in-law, Morrogh McBrian Kavanagh; which I perused, and the more I considered of your demands therein, the less I found in you, either loyal regard of bounden duty to the Queen's Most Excellent Majesty, or yet so much as any provident consideration of the shameful and headlong race you have run, to your own utter destruction, and perpetual subversion of your offspring and posterity: so as now your wickedness must denounce you to the world for a most malicious traitor to Her Highness's sacred person. And I cannot but be sorry that so unnatural and degenerate a member is descended from the house you are come of. Now for your demands, which you desire to be answered in particular; wherein, among others, you expressly declare yourself to be (as you term it) joined and linked with the Archtraitor Tyrone, and the rest of the rebels now in action in this kingdom. For one general answer to all I say, that as I account all your demands most wicked, odious, and most traitorous, so do I absolutely resolve to yield to neither of them, not doubting but the just reward of your deserts will heavily light upon you and the rest; to effecting whereof assure yourself that my best endeavour shall not be wanting, to the shedding of the last drop of my blood.’[13](javascript:footNote('E590002/note013.html'))
> 
> 
> 




*[The malapert message of Mountgarrett]*


The 22 of December by David Hickey that delivered, the Lord Mountgarrett refusing to write, sent by word of mouth ‘Let the Lord Lieutenant do what he can for the Queen and I will do on the other side what I can for O'Neill.’ After that the northern rebels, under the conduct of Con O'Neill, the bastard, had met with Mountgarrett and others the Lords of Leinster and Munster then in action, and conferred together on sundry points, they could not agree, but jarred among themselves. For every one (such was their aspiring humours) would be General and Commander of the rest. Redmond Burke challenged the generalty, Con O'Neill, challenging that style to himself, snuffed at his fellow traitors, and charged them with breach of promise; that they had sent unto his father (the traitor) for aid, promised great favours, kindness, and entertainment, but then denied him his style, and his followers cess; and so he departed from them in great rage. Then Mountgarrett was in great perplexity, not knowing whom to trust, fain would become a subject, and wist not how to compass it; for he had sworn to the rebels, and received the sacrament upon it. Yet he used secret means to speak with the Lord Lieutenant; at length wrote unto him that, if his Lordship would not vouchsafe himself to come and meet him, it would please him to send the Earl of Thomond, who then was at Kilkenny. The Earl of Thomond, by direction from the Lord Lieutenant, met him the 23 of February, who received of him but shifts and slender excuses (after his wonted manner), and that fear of his person drove him to the course he held. He entreated for peace, which was then granted him for 14 days; but he, notwithstanding, in that time (traitor like), sent 200 of his men into Leix, to hinder the Lord Lieutenant in prosecution of the rebels. After that the Lord Lieutenant had victualled the fort in Leix, foiled the rebels, and preyed Upper Ossory, Mountgarrett's castles and country lying in his way, and fearing the Lord Lieutenant's whip, the 15th of March he sent two of his horsemen unto him, as he was at Aghmocartie in Upper Ossory, desiring he might come and speak with him, which the Lord Lieutenant refused in his own person, yet sent Sir Christopher St. Lawrence, Sir Walter Butler, Sir James Butler, and certain other Captains unto him, to understand what he had to say, with instructions accordingly. He entreated for peace. They demanded a pledge for performance of the conditions that should be agreed upon. He offered land; it was refused. They demanded one of his sons and two castles; that he denied. He offered his own word and honour; they said it was worth little. He craved time to be advised by his learned counsel. They, perceiving all was but shifts and delays, left him as they found him, among a company of rascal traitors. In the evening, that day, William FitzNicholas came from Mountgarrett, desiring the Lord Lieutenant to vouchsafe to speak with him; the which he would not grant, unless he made his penitent submission, submitting himself absolutely to Her Majesty's mercy; adding withal that, if the cause were between the Earl of Ormond and Mountgarrett, he would look to have both pledge and obedience at his hands, being chief of the house whence Mountgarrett descended. Shortly after he sent his son -- to Dunmore, where the Lord Lieutenant was, desiring peace for five days, which was granted. Yet all that while was he practising mischief. The 26 of April he came to the castle of Kilkenny, kneeled down before the Earl of Ormond, and desired two things; first, the benefit of Her Majesty's proclamation, the which the Earl of Essex had lately brought over with him; secondly, that he might, by the Earl's means, be safely brought to the Earl of Essex's presence; both which were granted him. On the 12 of May, at Athy, the two Earls meeting together, the Earl of Ormond presented him and the Lord of Cahir to the Earl of Essex, who, as they kneeled, gave them a long and a sharp exhortation touching their rebellion, their subjection and loyalty being of them forgotten. The Earl of Essex, Lord Lieutenant-General, committed them to the Marshal, took them with him to Dublin, where he pardoned Mountgarrett and his ungracious children, and gave him all his lands, with great favours. But in a short while after (small account being made of Mountgarrett himself, a man unwieldy), his sons were as far in rebellion as they were before.


Thomas Butler, Lord Baron of Cahir, with his brethren, kindred, and all his country, went to open rebellion. The Earl of Ormond, Lord Lieutenant, wrote unto him that he should with speed repair unto him with his forces, and shew his loyalty; the which he refused. He wrote the second time, viz., the 26 of November, 1598, to the same effect, but he came not. The man was simple and foolish, carried away by his wife, that was Mountgarrett's sister, Dr. Cragh, the Pope's Nuncio, and Father Archer. The 9 of May (remembering himself after the example of Mountgarrett) he came to the castle of Kilkenny, kneeled before the Earl of Ormond, and desired the benefit of Her Majesty's proclamation, which the Earl of Essex had late brought over with him. ‘Now goodman fool’ (said the Earl of Ormond), ‘what would you have? the benefit of Her Majesty's proclamation? Your father was a wise man, an honest gentleman, a good subject; but you have combined with traitors and rebels, and overrun your wits. That which you desire I grant you. Stand up, and I will bring you to the Earl of Essex, Lord Lieutenant-General, and let him dispose of you, as seemeth best unto him.’ At Athy he was delivered unto him, and there committed to the Marshal, and carried along the journey. His castle of Cahir, after he had forsaken it, was kept by his brother James, and other traitors, against the Queen's forces, and the simple man could not command his own house; so that the Earl of Essex was driven to convey by water thither from Waterford a cannon and a culverin, to batter the house. Upon Whitsun Sunday, in the evening, the ordnance being mounted, they began to play and batter the castle. The Lord of Cahir and his wife, being then in camp and prisoners, beholding the battery of their house, wept like children. So sore was the castle assaulted and battered, that Her Majesty's forces determined, upon Tuesday in the morning, to enter; but the night before, the Lord of Cahir's brother, and a few with him, got away through a sink and under a water-mill; the rest of the rebels were pitifully mangled and slain along the river. Sir Christopher St. Lawrence and Captain Lawrence Esmond, with their forces, entered, took the spoil, and kept it, until the Earl of Essex had appointed a ward.


Notes of certain events in Irish history, 1601, March-July
----------------------------------------------------------


### TNA, SP 63/208, pt.3, no.89, f.239, calendared under Cal. S.P. Ireland, 1600-1, pp.446-7, July [21] 1601.

[14](javascript:footNote('E590002/note014.html'))
1600[15](javascript:footNote('E590002/note015.html')) The lord president's journal


*[March 20]* Sir George Carew, Lord President, commended William McHubbert, by the name of a gentleman, whose father and son himself had been well acquainted withal, and for dutifulness, valour, and service deserved favour; and for that there was no use of his employment in Munster, he sent him to Leinster with his kinsmen and followers, desiring the Earl of Ormond to grace him, and employ him, if occasion required, &c.; which turned to no small hurt, as after shall appear.


1601
  

*[June 22]* At Carrickbane, the Lord Deputy with others of the Council hearing, as they termed it, an indisposition in the Earl of Ormond, being Lord Lieutenant of the army, and not to the prejudice of his authority, sent unto the aforesaid Earl a project or disposal of the Queen's forces for that summer's service, very providently as followeth:
  

1. To keep at Galway and Athlone, 350 foot.
2. At the Abbey of Boyle 1,000 foot, 62 horse, which will very much further the plantation at Ballyshannon.
3. At the Annaly, on Leinster side the Shannon, 800 foot, 62 horse, lying fitly to join with the forces of Leinster either northward or southward, to stop the passage of the Ulster rebels into Leinster.
4. In Offally, foot companies under the command of the Earl of Kildare, 150; Sir George Bourchier, 100; Sir Edward Herbert, 100; Sir Henry Warren, 100; Captain Carroll, 100; horse company under the command of the Earl of Kildare, 25; Sir Edward Herbert, 12.
5. In Leix, foot companies under the command of Sir Henry Power, 150; Sir Francis Rush, 150; Sir Thomas Loftus, 100; horse companies under the command of Mr. Marshal[16](javascript:footNote('E590002/note016.html')), 20; Captain Pigott, 12.
6. In Kilkenny, under the command of the Earl of Ormond, 50 horse, 150 foot.
7. In Westmeath, foot companies under the command of the Lord of Delvin, 150; Sir Francis Shane, 100.
8. In Kells, foot companies under the command of Captain Roper, 150; horse under the command of the Earl of Kildare, 25; Sir Henry Harrington, 25.
9. At Liscannon in the Brenny, foot companies under the command of the Lord of Dunsany, 150; Sir Henry Harrington, 100; Sir William Warren, 100; Captain Lawrence Esmonde, 150; horse under the Lord of Dunsany, 50.
10. At Dundalk, under the command of Captain Freckleton, 100 foot.
11. 11. At the Moyerie, under the command of Captain Hansard, 100 foot.



The 14th of July, anno 1601, the Lord Deputy took the Blackwater, with the trenches and strength which Tyrrell and Mostian undertook to hold for the rebels; and the same month the Earl of Ormond forewarned him and the Lord President of Munster of the coming of the Spaniards for Ireland. Shortly after the Lords of the Council of England sent forewarnings, dated the 20 of July, to the Lord Deputy of Ireland, the Earl of Ormond, and to the Lord President of Munster, of the preparation of 5 or 6,000 Spaniards at Lisbon for Ireland, and that her Highness would with all expedition send 2,000 men to join with her forces there to receive them, which landed shortly after.












