

#Narrative of a residence in Ireland during the Summer of 1814, and that of 1815


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Narrative of a residence in Ireland during the Summer of 1814, and that of 1815
===============================================================================


Author: Anne Plumptre
---------------------


### File Description

Electronic edition compiled and proof corrections by Beatrix Färber 

Funded by School of History, UCC 1. First draft.Extent of text: 
169450 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2015) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E810001-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

Anne Plumptre (1760–1818) was an English writer and translator from Norwich. Her father was prebendary of Norwich and president of Queen's College, Cambridge. She and her sister were very well educated and became members of a literary circle around William Enfield. Anne wrote various novels and translated plays and tales from German to English. She spent three years (1802–1805) in Napoleonic France where she showed sympathies with Napoleon's government, publishing an account of her residence in France in 1810. She also translated travel literature from German and French before travelling to Ireland. Her narrative about Ireland shows the abiding interest in geology and mineralogy of a well-connected, mature and self-assured personality who was au fait with the literature of the day. Anne died in Norwich in November 1818. More details about her life are available in an article by Elinor Shaffer, the Oxford Dictionary of National Biography, Oxford University Press, 2004; online edn, Sept 2010 (http://www.oxforddnb.com/view/article/22399). 

#### Sources


**Works, including translations, by Anne Plumptre (1760-1818)**2. Antoinette: a novel, in two volumes (London 1796).
3. The rector's son: in three volumes (London 1798).
4. The natural son: a play in five acts, by Augustus von Kotzebue; translated from the German by Anne Plumptre, who has prefixed a preface explaining the alterations in the representation and has also annexed a life of Kotzebue (Dublin 1798) [German title: Das Kind der Liebe].
5. The Count of Burgundy: a play; in four acts, by Augustus von Kotzebue (London 1798) [German title: Der Graf von Burgund].
6. The horse and the widow: a dramatic piece, translated from the German of F. von Kotzebue (Dublin 1799) [German title: Die Witwe und das Reitpferd].
7. The virgin of the sun: a play, in five acts, by Augustus von Kotzebue; translated from the German, by Anne Plumptre (London 1799). [German title: Die Sonnenjungfrau].
8. Letters written from various parts of the continent, between the years 1785 and 1794: containing a variety of anecdotes relative to the present state of literature in Germany, and to celebrated German literati. With an appendix, in which are included, three letters of Gray's, never before published in this country, translated from the German of Frederick Matthisson, by Anne Plumptre, translator of several of Kotzebue's plays (London 1799).
9. La-Peyrouse, a drama, in two acts ... Translated from the German by Anne Plumptre (London 1799).
10. Pizarro. The Spaniards in Peru; or, the Death of Rolla. A tragedy ... Translated from the German by Anne Plumptre (London 1799) [German title: Die Spanier in Peru].
11. The force of calumny. A play, in five acts ... Translated from the German, by Anne Plumptre (Dublin 1799) [German title: Die Verläumder].
12. A selection of the best plays of Augustus von Kotzebue ... , translated from the German by Anne Plumptre (London 1800).
13. Sketch of the Life and Literary Career of August von Kotzebue [from "Die jüngsten Kinder meiner Laune," Bdchn. 5]; with the Journal of his tour to Paris ["Meine Flucht nach Paris"]. Translated from the German by A. Plumptre. To which is subjoined an appendix, including a general abstract of Kotzebue's Works (London 1800).
14. Physiognomical Travels, preceded by a physiognomical journal. Translated from the German of J. C. A. Musaeus, by Anne Plumptre. To which is prefixed, a short sketch of the life and character of the author, by his pupil Kotzebue (London 1800).
15. Something new or, Adventures at Campbell-House: In three volumes. By Anne Plumptre (London 1801).
16. A historical relation of the plague at Marseilles in the year 1720 containing a circumstantial account of the rise and progress of the calamity, and the ravages it occasioned; with many curious and interesting particulars relative to that period / Translated from the French manuscript of Mons. Bertrand, physician at Marseilles who attended during the whole time of the malady, by Anne Plumptre, with an introduction and a variety of notes. By the translator (London 1805).
17. A Narrative of a three years' residence in France, principally in the Southern departments, from ... 1802 to 1805: including some authentic particulars respecting the early life of the French Emperor, and a general inquiry into his character (London 1810). This was reprinted in volume 5–7 of Stephen Bending and Stephen Bygrave (eds), Women's travel writings in revolutionary France (London 2007).
18. Travels in Southern Africa, in the years 1803, 1804, 1805, and 1806, by Henry Lichtenstein, translated from the original German by Anne Plumptre (London 1812). [German title: Reisen im südlichen Afrika, in den Jahren 1803, 1804, 1805 and 1806]
19. Travels in the Morea, Albania, and other parts of the Ottoman Empire, comprehending a general description of those countries; their productions; the manners, customs, and commerce of the inhabitants: a comparison between the ancient and present state of Greece: and an historical and geographical description of the ancient Epirus, Translated from the French by Anne Plumptre. Illustrated with engravings (London 1813).
20. The history of myself and my friend, a novel: by Anne Plumptre. In four volumes (London 1813).
21. Historical & literary memoirs and anecdotes, selected from the correspondence of Baron de Grimm and Diderot with the Duke of Saxe-Gotha, and many other distinguished persons, between the years of 1753 and 1790, translated from the French [by Robert Bland and Anne Plumptre] (London 1815).
22. Narrative of a residence in Ireland during the summer of 1814, and that of 1815, by Anne Plumptre (London 1817).
23. Tales of wonder, of humour, and of sentiment; original and translated. By Anne and Annabella Plumptre. In three volumes (London 1818).
**Other descriptions, and books mentioned by Anne Plumptre**2. Thomas Fuller, The historie of the holy warre: by Thomas Fuller, B.D. prebendarie of Sarum, late of Sidney Colledge in Cambridge (Cambridge 1639).
3. Sir George Buck, The history of the life and reign of Richard the Third: Composed in five bookes (...) (London 1646).
4. Richard Bulkely (of Dunlavin, Co. Wicklow), "A Letter to Dr. Martin Lister concerning the nature of the pillar formations in the Causeway", Philosophical Transactions for April 1693, vol. 17, no. 199, p. 708.
5. Samuel Foley, On the Giant's Causeway, Philosophical Transactions, vol. 18, no. 212, (London 1694) p. 169.
6. Thomas Molyneux, "A Letter from Dr. Thomas Molyneux to Dr. Martin Lister, Fellow of the Colledge of Physicians and R. S., containing some additional observations on the Giant's Causeway in Ireland', Philosophical Transactions of the Royal Society, for June 1695, vol. 20, no. 241, (London 1698) 209–223; doi 10.1098/rstl.1698.0041.
7. Henry Rowlands, Mona antiqua restaurata: An archaeological discourse on the antiquities, natural and historical, of the isle of Anglesey, the antient seat of the British druids. In two essays. With an appendix, containing a comparative table of primitive words, ... Together with some letters, and three catalogues, ... (Dublin 1723).
8. Jonathan Swift, Carberia Rupes in Comitatu Corgagensi apud Hybernicos (1723).
9. Richard Pococke, "An Account of the Giants Causeway in Ireland, in a Letter to the President from the Rev. Richard Pococke, LL. D. Archdeacon of Dublin, and F. R. S.", Royal Society, Philosophical Transactions, vol. 45 (January 1748).
10. Charles Smith, The antient and present state of the county and city of Cork: in four books. I. Containing, the antient names of the territories and inhabitants, with the civil and ecclesiastical division thereof. II. The topography of the county and city of Cork. III. The civil history of the county. IV. The natural history of the same (. . .) (Dublin 1750. Reprinted Dublin 1774. Reprinted by the Cork Historical and Archaeological Society, with the addition of numerous original notes, etc., from the MSS. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W.A. Copinger. Cork 1893–1894).
11. James Macpherson, Temora, an ancient epic poem: in eight books: together with several other poems composed by Ossian, the son of Fingal. Translated from the Gaelic language by James Macpherson (London 1763).
12. George Lyttelton, The history of the life of King Henry the Second, and of the age in which he lived: in five books; to which is prefixed, a history of the revolutions of England from the death of Edward the Confessor to the birth of Henry the Second (London, 2d ed. 1767–71).
13. Horace Walpole, Historic doubts on the life and reign of King Richard III. (Dublin 1768).
14. Charles Vallancey, Collectanea de Rebus Hibernicis (Dublin 1770–1804). 6 volumes.
15. James Roberts, A journal of a voyage to the Hebrides or Western Isles of Scotland, Ireland and the Orkneys undertaken by Joseph Banks Esq., in the year 1772 (1772).
16. Sylvester O'Halloran, A general history of Ireland: from the earliest accounts to the close of the twelfth century, collected from the most Authentic Records. In which New and interesting Lights are thrown on the remote Histories of other Nations as well as of both Britains (...). two volumes (London 1778).
17. Laurence Sterne, The life and opinions of Tristram Shandy, gentleman (London 1781).
18. William Withering, "An analysis of two mineral substance, vz. the Rowley rag-stone and the toad stone", Philosophical Transactions 72 (1782) 327–336.
19. William Hamilton, Letters concerning the northern coast of the county of Antrim, containing observations on the antiquities, manners, and customs of that country (. . .) illustrated by an accurate map of the County of Antrim, and views of the most interesting objects on the coast (Dublin 1786; various reprints 1790, 1822).
20. Joseph Cooper Walker, An historical essay on the dress of the ancient and modern Irish: addressed to the Right Honourable the Earl of Charlemont, to which is subjoined a memoir on the armour and the weapons of the Irish (Dublin 1788).
21. George Tyner, The traveller's guide through Ireland: Being an accurate and complete companion to Captain Alexander Taylor's map of Ireland, giving the distance by the great roads from Dublin to every town in the kingdom, the cross roads, and description of the gentlemans' seats near the roads. Ornamented with a map of the roads. To which are added, the roads from London to Chester, Holyhead, &c. (Dublin 1794).
22. Isaac Weld, Travels through the states of North America and the provinces of Upper and Lower Canada, during the years 1795, 1796, and 1797. Second edition. Illustrated and embellished with sixteen plates. In two volumes (London 1799).
23. Richard Lovell Edgeworth, and Maria Edgeworth, Essay on Irish bulls (London 1802).
24. The Post-Chaise Companion, or, travellers directory, through Ireland ... William Wilson, third edition, corrected and enlarged. (Dublin 1803).
25. Edward Ledwich, The antiquities of Ireland: with additions and corrections. To which is added a collection of miscellaneous antiquities. 2nd ed. (Dublin 1804.)
26. Matilda Betham, A Biographical Dictionary of the Celebrated Women of Every Age and Country. (London 1804).
27. Mary Tighe, Psyche, or the Legend of Love (London 1805).
28. Malcolm Laing, The Poems of Ossian, Containing the poetical Works of James Macpherson in Prose and Verse, with Notes and Illustrations (Edinburgh 1805).
29. James Beresford, The miseries of human life: or, the groans of Samuel Sensitive, and Timothy Testy; with a few supplementary sighs from Mrs Testy, in twelve dialogues (London 1806).
30. Sir John Carr, The stranger in Ireland: or, A tour in the southern and western parts of that country in 1805 (London 1806).
31. Isaac Weld, Illustrations of the scenery of Killarney and the surrounding country (London 1807).
32. Sir Richard Colt Hoare, Journal of a Tour in Ireland, AD 1806 (Dublin and London 1807).
33. Edward Dubois, My pocket book; or, Hints for "a ryghte merrie and conceitede" tour, in quarto: to be called "The stranger in Ireland," in 1805 (London 1808).
34. Maria Edgeworth, Tales of fashionable life, vol 1. Ennui (London 1809).
35. Thomas Newenham, A view of the natural, political, and commercial circumstances of Ireland (London 1809).
36. Gregory Watt, Observations on Basalt, and on the Transition from the vitreous to the stony Texture, which occurs in the gradual Refrigeration of melted Basalt; with some geographical Remarks. To the Right Hon. Charles Greville, V. P. R. S., Nicholson's Journal, vol. 10, March 1805 (London 1810) 165–179. [Identical to the article in Philosophical Transactions of the Royal Society of London vol. 94 (1804), pp. 279-314].
37. William Hamilton Drummond, the Giants' Causeway: a poem (Belfast 1811).
38. Thomas Garnett, Observations on a tour through the Highlands and part of the Western isles of Scotland: particularly Staffa and Icolmkill: to which are added, a description of the falls of the Clyde: of the country round Moffat, and an analysis of its mineral waters (2 vols.) (new ed. London 1811).
39. Martin Hinrich Lichtenstein, Reisen im südlichen Afrika in den Jahren 1803, 1804, 1805 und 1806 (Berlin 1811–12).
40. Torquato Tasso, La Gerusalemme liberata, [ed.] by G. B. Boschini (London 1813).
41. Lady (Sydney) Morgan, O'Donnell: a national tale (London 1814).
42. Matthew Weld Hartstonge, Marion of Drymnagh: a tale of Erin in two cantos (Dublin 1814).
43. Matilda Betham, The Lay of Marie. (London 1816).
44. Abraham Rees, The Cyclopaedia, or Universal Dictionary of Arts, Sciences, and Literature (...) thirty-nine volumes (Dublin 1802–1820).
45. John Pinkerton, A general collection of the best and most interesting voyages and travels in all parts of the world: many of which are now first translated into English. Digested on a new plan (London 1812).
46. George Newenham Wright, A Guide to the county of Wicklow (London 1822).
47. James Norris Brewer, The Beauties of Ireland (London 1825–26).
48. George Benn, A History of the town of Belfast from the earliest times to the close of the eighteenth century, 2 vols. (London 1877).
49. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
50. Glenn Hooper, Anne Plumptre: an independent traveller, in: Margaret Kelleher & James H. Murphy (eds), Gender perspectives in nineteenth-century Ireland: public and private spheres (Blackrock, Co. Dublin 1997) 129–39.
51. John McVeagh (ed.), Irish Travel Writing. A Bibliography (Dublin 1996).
52. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
53. Philip MacDonald, Barrie Hartwell, 'Anne Plumptre and the Giant's Ring, County Down: an account of a possible bleach-green watch-tower', Ulster Journal of Archaeology 68 (2009) 152–157.
**The edition used in the digital edition**2. Narrative of a residence in Ireland during the Summer of 1814, and that of 1815. Anne Plumptre First edition [398 pages] Printed for Henry Colburn London (1817)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 1–379 and the integration of the author's errata on p. 398. The additional notes starting on p. 380 have not been captured. Any other typos are corrected using *corr sic="" resp="BF"*. The illustrations of the printed edition have not been reproduced, but can be viewed in the pdf file of the printed text available at www.archive.org.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


In some instances, where hyphens occur in place names, but inconsistently, these have been removed from place names to normalize the spelling.


##### Quotation


Direct speech has not been tagged. Some citations have been tagged as such, and referenced added.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the description; div1=the part; div2=the chapter; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd, and tagged.


##### Interpretation


Place-names, most personal names, most place names, titles (of books etc.) and terms are tagged. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV2 element to represent the entry. ### Profile Description


Created: By Anne Plumptre 
 (1815) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [GA] Some words and phrases are in Irish.


##### Language: [FR] Some words and phrases are in French.


##### Language: [GR] Some words are in Ancient Greek.


##### Language: [DE] One word is in German.


##### Language: [IT] Some terms are in Italian.


##### Language: [BOT] Some of the Latin and English terms are from botany.


### Revision History


* (2015-11-25) Beatrix Färber (ed.)

* More content markup applied; bibliography finished; SGML and HTML files created.
* (2015-11-23) Beatrix Färber (ed.)

* File parsed.
* (2015-11) Beatrix Färber (ed.)

* Proofing (1, 2) and application of structural and content markup of first part finished.
* (2015-10-30) Beatrix Färber (ed.)

* Proofing (1, 2) and application of structural and content markup of second part finished; provisional header created; first part captured.
* (2015-10-12) Beatrix Färber (data capture)

* Second part captured.




---


#### Corpus of Electronic Texts Edition: E810001-001


### Narrative of a residence in Ireland during the Summer of 1814, and that of 1815: Author: Anne Plumptre




---

p.1


COMPRISING THE JOURNEY AND VOYAGE TO DUBLIN AND STAY IN THAT CITY, AND A TOUR ROUND THE COUNTY OF ANTRIM, PART OF THE COUNTY OF DOWN, AND PART OF THE COUNTY OF WICKLOW.
------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Commentary on the Maxim "When we are at Rome, we should do as they 
do at Rome." — Friendly Advice. — Determination to embark at Bristol. — Visit to **Bath**. — The Hampton Stone Quarries near **Bath**. — Rejoicings for the Peace. — An Ox roasted whole. — Visit to Bristol. — Result of friendly Advice. — Determination to proceed and embark at Liverpool. — Mineralogical Anecdote. — Birmingham.
#### 1


When we are at Rome, we should do as they do at Rome. — This is a long-established maxim, founded so much on reason and good sense that it is in 
every body's mouth, and, though not always followed, is universally extolled. 
I even went so far, when I was to visit **Ireland**, as to follow it, in the true 
Irish style, by anticipation, and did not wait for my arrival in the country to do 
as they do in **Ireland**, but commenced my journey with a practical Bull, and 
went first to **Bath** and Bristol in order to embark at Liverpool.


The case was this. — In the summer of 1814 I was led from a combination 


---

p.2



 
of circumstances to be extremely desirous of visiting **Dublin** and the North of 
**Ireland**, and therefore gladly accepted a proposal made me by my friends Mr. 
and Mrs. C ... ..., who were going to **Dublin**, to join their party for the journey and voyage. Liverpool was the place they had fixed on for embarkation; and as I had no preference for any place, I readily coincided with their wishes. Before we quitted London, Mr. C ... ... meeting accidentally with an eminent 
merchant of Bristol, an acquaintance of his, was induced by him to propose 
an alteration in our plan. This gentleman urged that by embarking at Bristol 
we should save full half our journey by land, and he assured us that merchant-ships were perpetually passing between Bristol and **Dublin**, so that we might 
be almost sure of sailing within a day or two after our arrival at Bristol, and 
we should find much more comfortable accommodations in a merchant-ship 
than in the packets. He was going back to Bristol, he said, the next day, 
and would speak to a friend very much connected with some of the principal 
ship-owners, who would look out a nice and convenient vessel for us; in short, 
he had no doubt that by the time of our arrival at Bristol, which could not be 
sooner than a week, every thing would be settled, and a comfortable passage 
secured for us.


All this sounded so extremely plausible, that no hesitation was made by any 
of the party in accepting what appeared so very obliging an offer. As far as 
I was concerned I rejoiced in the alteration; I had never been either at **Bath** 
or Bristol, and thought with pleasure of seeing places so celebrated; I had, 
besides, at that time, a sister living at **Bath**, and to spend a few days with her 
was adding in no small degree to the gratification I expected in my proposed 
tour. I accordingly set off for **Bath** on Sunday the 3rd of July, attended by 
a servant whom I had hired for the excursion, leaving my friends to follow me 
in the course of a few days.


Though mineralogical researches were not among the primary objects which 
I now had in view, yet as I had for some time been much interested by acquiring a slight acquaintance with the mineral kingdom, to combine with the 
other objects of my tour, as much addition as I could obtain to my stock of 
knowledge on this delightful subject became a leading feature among my remoter pursuits. I had often heard that in the vicinity of **Bath** many organic 
remains were to be found, and I was anxious to procure specimens of them. 


---

p.3



 
The first day of my stay at **Bath** having been devoted — as all due respect for 
established custom required — to seeing the lions of the city, that is to say, the 
rooms, the circus, the crescents, the parades, the principal squares and streets, 
the pump-room, the baths, the market, &c. &c. not omitting to taste the waters; — the first day having been thus spent, on the second I set off on a mineralizing walk, attended by my faithful squire; who having like myself acquired a 
little smattering of mineralogical knowledge, was not less eager in the pursuit 
of aliment to increase and nourish it.


We pursued our course along the side of the Kennet and Avon canal to the 
village of Hampton about three miles from **Bath**, where is a very pretty rural 
church with a tower most picturesquely overgrown with ivy; then crossing the 
canal, we arrived at the foot of the hill on the summit of which are the Hampton stone quarries, the largest in the neighbourhood of **Bath**. Here I first became acquainted with what I had afterwards several opportunities of seeing, 
the mode of conveying the stone from the quarry above, to the canal below, 
by means of an iron railway down an inclined plane, with machinery which in 
conveying the loaded cart down makes that draw the empty cart up. To enter 
upon any description of this machinery were useless; — to those who have never seen any thing of the kind no description could make it understood, and 
to those who are acquainted with it, description would be superfluous. Indeed, 
though a very modern invention, it is come so much into use, that probably 
few persons to whom such a subject would be interesting are unacquainted 
with the nature of it. Now first presented to my observation, it was impossible not to be struck with the ingenuity displayed in the whole apparatus, and I 
stood for some time contemplating and admiring it. I was offered a ride up 
the hill in an empty cart, which I had accepted; but at the moment when I 
was about to ascend my vehicle, it set off, and then to stop it was impossible. 
I believe in this as in most cases, perhaps I might say in every case, all was 
for 
the best, since, from what I saw, an inference might easily be drawn that the 
ride would have proved extremely shaking, and once in the vehicle there was 
no possibility of getting out till the journey's end. I therefore toiled up the 
hill; and being a very hot day it was indeed toiling, but I was amply repaid for 
my labours. I procured at the quarry some very beautiful stalactitic incrustations, with several very good specimens of organic remains of different kinds. 


---

p.4



 
The stone of this quarry is esteemed of a better quality than any other for stone 
engravings. Another recompense of my toils was afforded by the very fine and 
extensive view spread before me over the beautiful country around. I had understood the hills about **Bath** to be bare and naked; but I found them every 
where well clothed with verdure, and finely interspersed with wood. The city 
itself is not to be seen from this point. I returned home by a very pleasant 
path along the slope of the hill, whence there were many fine points of view.


The third day of my stay at **Bath**, the 6th of July, I was occupied by an 
object of a very different nature. It happened to be the moment of rejoicing 
for the peace just concluded, and an ox was to be roasted whole, with another 
in quarters, and four whole sheep, on Claverton Downs, two miles from the 
city, to be given away to the populace. Such a spectacle had never before 
fallen in my way, and novelty seldom fails to awaken curiosity. — A temporary 
building for the cookery was run up on the Downs, and at twelve o'clock at 
night the hero of the feast was laid down; the quarters of beef, and the sheep, 
were not to follow him till six in the morning. At that hour I set off to walk 
to the spot: the weather was beautiful, and I was gratified by the novelty of 
the sight, but felt no wish to partake of the regale. Indeed there is nothing 
very inviting in the appearance of the animals thus cooked. At twelve the 
meat was distributed to any one who chose to apply for some, bringing a knife and 
fork to cut off his portion, and a plate to receive it. No beer was given away; 
but several publicans from the town had erected booths where it was sold, 
under shelter of which the people sat down to eat their repast. The whole 
afforded a cheerful and exhilarating spectacle. The rest of the day was devoted to seeing more about the town, and the evening was concluded with a 
pleasant walk in Sydney Gardens, the Vauxhall of **Bath**.


The next day, Thursday July 7th, I visited Prior Park, and went on to 
Coombe Down, where, in a neglected stone quarry, I found again several interesting mineralogical objects, as stalactites, crystallizations, and organic remains. From the Weston quarries I also procured fossil shells of several kinds. In 
the evening of this day my friends Mr. and Mrs. C ... arrived from London; 
and on the 8th I took my leave of **Bath**, accompanying them to Bristol, in the 
full expectation that here was to be the utmost extent of our land travelling on 
this side of the Irish Channel.




---

p.5


#### 1


But the very first inquiries made at Bristol were sufficient to convince us that 
our loquacious merchant was a man of words much rather than of deeds, and 
that far too easy credit had been given both to his representations and professions; 
that he was totally deficient in knowledge upon the subject on which he 
had so readily given his advice, — a disease but too prevalent with mankind in general, — and that his offers of service had about as much sincerity in them 
as the compliments paid by the parasite of Pennaflor to Gil-Blas, upon the 
celebrity he had acquired. In the first place he was not himself at Bristol; 
he was residing at his country-house four miles off; and in order to learn whether he had taken any steps towards the performance of his promises we must 
have gone thither to seek him. Other information, however, obtained in the 
town, soon satisfied us that we could gain nothing by pursuing him into his rural retreat, except perhaps the chance of being again misled. Direct communication between Bristol and **Dublin**, we found from the concomitant testimony of several well-informed persons, was a very rare thing, — we might in all 
probability wait a month, nay five or six weeks, before any vessel would sail 
for that port; and supposing a passage at length procured, the voyage was always very tedious; it was very likely to last a week or ten days; while the accommodations for passengers on board merchant vessels were so bad, that it 
was even perverting the term accommodations to apply it to them.


The only mode of going to **Ireland** then from **Bristol**, practicable for us, appeared to be the packet to **Cork** or to **Waterford**. To either of these places 
the passage was three guineas, and there was then a considerable journey by 
land to arrive at **Dublin**. On the whole therefore, after spending two days in 
possessing ourselves of these important truths, in all that time not seeing any 
thing of our merchant, we at length determined that, all circumstances duly 
weighed, the best thing we could now do was to follow our original plan of embarking at Liverpool. As the price of the passage from thence is only a guinea, 
the expense would scarcely be greater than going by the Waterford packet, and 
the passage much more certain. Thus by listening to our Bristol merchant we 
were out of pocket just the expense of a journey thither, since we were now 
about the same distance from Liverpool that we were when in London.


Yet I was not disposed wholly to quarrel with him; for I had been very, 
much gratified with my visit to **Bath**, and was perfectly charmed with the Clifton 


---

p.6



 
rocks; the latter no less than the **Bath** quarries furnished me many very 
interesting additions to my mineralogical collection. I have already mentioned 
that my servant was a zealous mineralogist. At the inn where we were staying 
he inspired such a taste all around him for his favourite science, that one morning he set off at four o'clock at the head of a party of the waiters and chambermaids, on a mineralizing excursion, and by our breakfast hour I found him returned richly laden with the spoils he had procured. Before I quitted Bristol, all 
the treasures I had hitherto collected were sent off by the canal to London.


On our route to Liverpool we stopped one day at Birmingham, where 
among other objects we were much pleased with the sight of Thomasine's showrooms, and surprised at the variety and beauty of his manufactures. His excellent imitations of precious stones more particularly excited our admiration.




---

p.7


Tedious Voyage to **Ireland**. — Arrival in **Dublin Bay**. — Obliged to anchor 
there. — Importunities of the Boatmen to row the Passengers on Shore, and 
their exorbitant Demands. — The Pier. — The Light-House. — The shelly 
Bank. — The North and South Bull. — The Bathing-Houses. — The Pigeon-House. — Beautiful Scenery round the Bay. — Arrival in the City of **Dublin**.
#### 2


On the 14th of July about eight in the evening we arrived at Liverpool. We 
had intended stopping a day to look about the town, but found so excellent a 
packet, the Loftus, about to sail the next morning, that we agreed unanimously 
it was better to relinquish this intention, and secure a passage on board it. 
From the state of the weather there appeared every reason to expect a long 
passage: thus it became of some importance not to lose the opportunity of 
going in a vessel much more commodious than the generality of packets. We 
had here a very neat little stern cabin, with stern lights, for the ladies; a thing 
I never found in any other packet where it has been my lot to be a guest; 
very little attention is paid in general to the accommodation of female 
passengers.


On the 15th at nine in the morning we embarked, having joined company 
for the voyage with two very pleasant officers going to **Ireland**, who had travelled with us all the way from **Birmingham**.


That the voyage would be tedious we knew was to be expected, but we were 
told that thirty-six hours was the longest ever known; and in providing ourselves 
with sea stores, we did not think of calculating upon a longer term, but made 
what we thought an ample provision, supposing it to run to the utmost of that 
extent. The first day however we made very little progress, and at the expiration of twenty-four hours were no further than off **Holyhead**. About noon 
the second day we were entirely becalmed for three hours; and the tide setting 
against us we rather lost than gained way, so that the Welch coast was still in 
sight as evening closed in. In the night we had rather more wind, and at daybreak 


---

p.8



 
the **Hill of Howth**, the north point at the entrance of **Dublin Bay**, and 
**Bray-head**, a conspicuous height a little below the south point, were both in 
sight. About two o'clock we had advanced as far into the bay as the state of 
the tide at that time would permit, and were obliged to come to anchor till 
there should be water sufficient to go over the bar into the harbour: this we 
were informed would be about six in the evening.


We were immediately beset by a number of boats soliciting to carry us on 
shore, offering their services at the moderate rate of only five shillings a head. 
Some wanted to carry us to **Dunleary**, a small harbour on the bay for fishing-boats; 
others proposed to carry us to the more general place of landing, the 
Pigeon-house; but all agreeing in the same exorbitant demand. As however, 
according to the expectation held out, the ship would get into the harbour at 
a sufficiently early hour, we were not disposed to make this addition to the 
price of our passage. Our captain was somewhat importunate with us to go 
on shore immediately, — impertinently, as we thought, — and this only made us 
the more determined not to comply. We had just provisions left for a dinner, 
and were not sorry to contemplate at our leisure the beautiful scene around. 
Some of the passengers being in a greater hurry began to bargain with the 
boatmen, but could get no abatement whatever in their demands. After a 
long altercation between one man in the ship above and another in the boat 
below, the former having made offers so much beneath the price required as to 
excite the utmost indignation in the bosom of the latter, he turned to his comrades and said, That fellow would kill a louse, and live upon the fat. The majority of the passengers were however at length obliged to yield, since the sons 
of Neptune would not; for their stock of provisions not holding out so well as 
ours, they had no other resource against dining with a certain gentleman, 
Duke Humphry yclep'd, — one whose table d'hôte is by no means in general request.


In another respect our party, or I must rather here take the whole credit to 
myself and say, I had been more provident than the rest of the passengers; for 
I had made a little provision of food for the mind, which they did not seem to 
have thought of, and had put up some books with my other sea stores: 
among these was Lady Morgan's excellent novel of O'Donnel. — As I was going to visit a part of **Ireland** admirably described in this work, the county of 


---

p.9


**Antrim**, and had besides a letter of introduction to the amiable authoress at 
Dublin, it received great additional interest from being read as I was crossing 
the Irish Channel. Now this being a species of food which happily does not 
diminish by use, my stock served for the whole company on board the ship, and 
I believe by the conclusion of the voyage there were few of the passengers who had not read O'Donnel.


When six o'clock arrived, a different story was told from what had been 
given out when the ship came to anchor; we were now informed that the water 
would not serve for going over the bar before nine. In short we found that, 
for reasons best known to himself, our captain was determined not to go into 
the harbour that night: and since against this determination, though a gross 
and flagrant imposition, no redress could be obtained, we were obliged at length 
to take a boat, or we must have remained on board till the next morning, 
without provisions, or, what was still worse, without a dish of tea to console 
us. Thus much however was gained by holding out so long against the unreasonable demands of the boatmen, that they were now content to carry us to the 
Pigeon-house for one shilling each instead of five.


**Dublin Bay** is six Irish miles[1](javascript:footNote('E810001-001/note001.html')) in breadth at its mouth, measuring from the 
**Hill of Howth**, the northernmost point, to **Dalkey Island**, the most southern, 
and seven in depth from the entrance to the mouth of the Liffey. The inner 
part, called the harbour, is divided off by a stupendous stone pier which 
stretches all together three miles from the shore, beginning at the village of 
Ringsend upon the bay. The former part from Ringsend to the Pigeon-house 
was begun in 1748, and finished in less than seven years: the remaining mile 
and quarter from the Pigeon-house to the Light-house was begun about the 
year 1760, and was completed in eight years. The Light-house by which it is 
terminated, and which stands nearly in the centre of the bay, is a circular stone 


---

p.10



 
building rising eighty feet above the pier, and one hundred above low-water mark. 
A gallery with an iron balustrade encircles it on the outside about half way up, 
the ascent to which is by a narrow steep winding stone staircase, also on the 
outside. From this gallery is the best point for taking a survey over the bay and 
the fine country round it. In order to obviate the objection to the sandy foundation on which this structure was of necessity to be raised, it is built on empty 
wool-packs; an idea for which the engineer was indebted to the ingenuity of 
his wife. The great sand-bank, called the bar, runs from the end of the pier 
to the north shore of the bay; vessels of any size can cross it only at the flow 
of the tide: a flag is kept flying upon the top of the Light-house during the time 
it may be passed, so that a vessel immediately on entering the bay knows the state of the water.


The new part of the pier with the Light-house is constructed of granite 
from Bullock, a village on the southern shore of the bay about six miles from 
Dublin. This stone is remarkable for the quantity of mica it contains, which 
is sometimes to be found in flakes as large as a sixpence. The stone has a soft 
and crumbly appearance, and is so when first cut from the quarry, — consequently 
it is very malleable, — but it hardens exceedingly by the operation of the outward air, till it becomes an extremely solid and durable material for building: the vast mixture of mica gives it a very glittering appearance. The heights to 
the south at the entrance of the bay, extending through a considerable tract, 
are all of this granite. It is much used for mending the roads, to which its 
soft and crumbly nature when first taken from the quarry renders it well adapted, 
and it is ground to pieces before the air has had time sufficient to produce the 
effect of hardening it.


Carriages can come no further along the pier than to the Pigeon-house; the 
remainder is only a footway; it is twenty feet in breadth, but has no parapet 
or defence of any kind, so that in stormy weather it is difficult to stand against 
the force of the wind. A large sand-bank runs along the side of this pier next 
the bay, which at low-water is entirely uncovered; and rising in some places to 
a level with the pier itself, any one may step immediately from the one to the 
other. A profusion of shells are always deposited here; the large Solens are 
in such abundance, that one spot is as it were paved with them: there are besides several sorts of the Venus, Ostrea, Donax, and others. But it is remarkable 


---

p.11



 
that a live shell is very rarely to be found; the greater part are 
commonly in a state of absolute decay. A large tract of the bay on the north 
side, at the end towards the city, is at low water entirely uncovered, and displays little better than a vast expanse of mud. There is no doubt that by the 
aid of embankments it might soon be completely drained; and converted into 
cultivable land: this tract bears the name of the North Bull. On the south 
side of the bay, but at some distance from the town, beyond the pier, is another 
large tract equally uncovered at low-water, which has the name of the South 
Bull. This is a fine sand, and is a great resort for walkers and riders. In 
this and various other parts round the bay are a number of small boxes, like 
sentry boxes, for the use of bathers to dress and undress. For ladies these 
are extremely inconvenient, since instead of plunging from them immediately 
into the water, as with English bathing machines, they must walk some way 
from the sentry box in the bathing dress before the water is reached. I never saw 
a bathing machine to go into the sea any where in **Ireland**.


The appellation of the Pigeon-house will perhaps be thought a truly Irish 
one, since it is applied to a little cluster of houses at the junction between the 
old pier and the new one. At this place passengers from vessels coming into the 
harbour land, and here is a custom-house for the examination of goods. A long 
coach is always waiting against the arrival of the Holyhead packets, to carry 
passengers to **Dublin**; and there are besides a number of coaches, jaunting-cars, 
and jingles, which may be hired by those who do not choose the long coach, so 
that a ready conveyance into the city may always be depended on. The Pigeon-house was so called from a man by name Pigeon being the first person who 
kept a public house upon the spot. Here is a quay, alongside of which formerly all the packets were allowed to come; but the Liverpool packets taking 
passengers at the same price as the Holyhead, though double the distance, had 
for some time engrossed the custom so much that the owners of the Holyhead 
packets grew jealous, and in a fit of spleen petitioned against this indulgence 
being allowed them any longer; and being in the Government service they had 
interest sufficient to obtain their suit. But this piece of spite falls much more 
on the passengers than on the ship-owners, against whom it was directed. Their 
custom is not diminished by it; while the passengers, instead of being able to step 


---

p.12



 
from the quay to the vessel, are now obliged to be rowed nearly a mile to it. 
This regulation was made very soon after our arrival at **Dublin**.


The scenery round the bay is every way extremely beautiful. To the north 
is the **Hill of Howth**, with the little islands or rocks of **Lambay** and **Ireland's 
Eye**, the village of **Clontarf**, and a number of delightful villas scattered about. 
To the south are the villages of **Blackrock**, **Dunleary**, **Dalkey**, **Monkstown**, 
Bullock, and others, running in succession along the shore, with the Wicklow 
mountains in the back-ground, among which **Bray-head** and two conical summits called the Sugar-loaves are the most conspicuous; while in the centre, though seen at a distance, lies the city of **Dublin** itself. Yet when the extent 
of the bay is considered, it must appear obvious that the bolder features of the 
landscape alone can be very distinguishable, looking from the centre; that to 
obtain an accurate idea of the minuter, it would be necessary to coast round it[2](javascript:footNote('E810001-001/note002.html')).


This bay is often compared with the bay of Naples, and is generally considered as yielding in beauty to that alone. Never having been at Naples, I 
cannot judge of them by comparison: but beautiful as I think **Dublin Bay**, I 
must prefer to it one which I had previously seen, the bay of Toulon, and 
another which I did not see till afterwards, the bay of **Belfast**, or, as it is more 
commonly called, Belfast lough[3](javascript:footNote('E810001-001/note003.html')). Toulon bay has always appeared to me one 
of the most enchanting scenes that the imagination can picture to itself, and, 
from being much less extensive than the bay of **Dublin**, every object around is 
distinctly seen from the centre, or even from shore to shore. The same may 
be said of Belfast lough; the scenery round is equally beautiful with that 
round **Dublin Bay**, and the shores approaching so much nearer to each other, 
though it runs as far inland, every object is seen clearly and distinctly. But 
the bay of Toulon has one great and decided advantage over any thing in these 
northern climes, in the brilliancy which the delicious sun of Provence casts over 


---

p.13



 
all its scenery: this gives landscapes of that country a superiority of which 
those who have been accustomed only to our atmosphere, loaded as it too commonly is with vapours, can scarcely form an idea.


The drive from the Pigeon-house to **Dublin** is not calculated to give a 
stranger a very favourable impression of the new country he is come to visit. 
Nothing can be more filthy and disgusting than the town of Ringsend at which 
the pier terminates, nor can much be said for the remainder of the way till 
the suburbs of the city are passed. To compensate, if he has then any way 
to go into the city, he must necessarily pass through some of the best parts of 
it. At the recommendation of our fellow-travellers, the two Irish officers, we 
went to Levin's hotel in Mary's street on the north side of the river, by which 
means we saw sufficient to remove the unfavourable impression first made 
upon us. Here we found comfortable accommodations, very civil attendance, 
and for a hotel in a large city not unreasonable charges. In ordering supper 
we desired to have a roasted chicken, begging that it might not be a very small 
one. "No, no," said the waiter, "I understand: it shan't be a mere sucking 
chicken." — The next day I was settled very pleasantly in a lodging in Frederick-street South, from which I had a side view into the gardens of Trinity College.




---

p.14


Origin of the City of **Dublin** and of its Name — Present Extent of the City, — The National Bank — The Custom-House — The Four Courts. — Trinity College — The Library. — The Fagel Library — The Manuscript-Room — The Quin Library. — Curious Work undertaken by Dr. *Barret* — The College Chapel. — The Examination-Room — Monument to Dr. Baldwin — The Museum — The Moose Deer — The new Botanic Garden.
#### 3


It is not my intention to carry my readers through a long discussion of the 
various opinions concerning the original foundation of **Dublin**. Like all other 
great cities its origin is involved in much fable and obscurity; and the sources 
from which the different opinions are derived being accessible to every one, it would rather be impertinence to dilate upon them. The great antiquity 
claimed by some writers is disputed by others; but the probability seems that 
the first establishment of any thing that might be called a town, that is, an assemblage of houses with a number of people congregated together into something approaching to a civilized society, is of very remote date. If the **Eblana Civitas** mentioned by **Ptolemy** the geographer, who wrote in the second century 
of the Christian aera, really designate **Dublin**, as there seems sufficient reason 
to believe, it must even then have been a place of considerable note, to be 
mentioned by one who wrote in so distant a part of the world. 
The first settlers on the spot appear to have been fishermen, who established 
their huts on the eminence where now stands the castle: and these men being 
of a tribe called the **Eblani**, the town was called after them **Eblana Civitas**, 
or the city of the **Eblani**: the transition from thence to the present name of 
Dublin will appear obvious and easy. Such seems the most probable derivation 
of the name; though by others it is derived from Dubh-Leana, which in the ancient Irish language signifies the place of the black harbour, the bay of Dublin being anciently called, as they affirm, the black lake.


By the tenth century the settlement had arrived at so much distinction that it is styled in the charter granted by King Edgar in the year 964, called Oswalds 


---

p.15



 
Laws, the most noble city of **Dublin**. Still it does not appear that the 
buildings were of sufficient consequence to give it, according to our modern 
ideas, any claim to such an appellation, since two centuries after, at the conquest 
of the island by Henry the Second, he had a palace erected in the form of a 
long cabin, and the materials employed in its construction were only smooth 
wattles. Hence it may fairly be presumed that the general architecture of the 
country had not risen to any thing superior, but that the houses of the then 
great were humble as the cabins which now shelter, or scarcely shelter, the 
common classes of the Irish. But however simple and humble was this palace 
in its exterior, it was fitted up in the interior with so much taste and splendour 
as to excite general admiration. Here the victor monarch gave a grand Christmas 
entertainment to several petty princes of the island who had submitted to 
him; and here he held a parliament in the year 1173, where he granted his 
first charter to the city of **Dublin**, holding out strong encouragement for colonizers 
from England to settle there. The site of this palace is supposed to 
have been where now runs the south side of Dame-street.


Before the conquest of **Ireland** by Henry, the Danes were for a considerable 
period in possession of **Dublin**; but the precise time either of their obtaining 
such possession, or of their being expelled from it, is not accurately 
ascertained. While there, they surrounded it with a wall and some fortifications; 
but since this wall is not supposed to have been more than an Irish 
mile in length, the circuit which it inclosed must have been very small. There 
are now in the very heart of the city some trifling remains of old wall which 
were evidently once a part of the city walls: but it is to be presumed they are 
not fragments of those erected by the Danes, since they must have inclosed a 
circuit of much greater extent. 


The first habitations in **Dublin** were confined to the south side of the Liffey: 
when establishments were formed on the north side is not certainly ascertained. 
It is generally supposed to have been first inhabited by the Danes, who being 
called by the natives Ostmen, that is Eastmen, this part of the city was called, 
after them, Ostmenstown, whence is derived Oxmanstown, the more modern 
appellation given to a certain portion of the north side of **Dublin**. 


Since the time when, from the subjugation of **Ireland** to the English government, 
Dublin has become better known in this country, it has been in a progressive 


---

p.16



 
state of improvement; and within the last century its extension and 
embellishment have been most rapid, so that it has now a just claim to a high 
rank among the fine cities of Europe. Its form is nearly a square of two miles 
and a half each way, which makes its circumference extend to ten miles. The 
eastern part towards the bay is that which contains the principal public buildings, 
with the best houses, streets, and squares. Before the Reformation there 
were a great number of monastic institutions, the buildings of which, on the 
abolition of the religious orders, were consigned to more useful purposes. The 
first ever erected was in 1146, consequently not long before the English 
conquest; but the country had then been for several centuries converted to 
Christianity. 


Among the public buildings by which **Dublin** is now embellished, the first 
place must indisputably be allotted to the National Bank. This beautiful edifice 
was originally erected for the meeting of the houses of parliament; and it must 
be acknowledged that, while they sat there, the representatives of the younger 
sister country had a much more splendid place of assemblage than those of the 
elder. The building was begun in the year 1729 under the administration of 
Lord Carteret, and was ten years in being completed. At the union of the two 
countries, when the Irish were no longer to have a parliament of their own, and 
the edifice was rendered nugatory as to its original destination, it was sold to 
the bank directors, and after various necessary alterations was opened in the 
year 1808 for the new purpose to which it was destined.


Over this building I was shown very completely, through the obliging attentions of Sir Arthur Clarke, who, being connected with some of the proprietors, 
procured me entrance to places not commonly shown. In one room is a model 
of the building on the scale of an eighth of an inch to a foot, which shows it, 
as it is, almost a little town of itself. A considerable part of the roof constitutes a platform, on which a whole regiment might be stationed if necessary for 
the defence of the place, while a large armory within would abundantly furnish 
arms for their equipment. The room where the House of Lords sat remains 
in its original state; it is ornamented with two well executed pieces of tapestry 
representing the siege of Londonderry and the battle of the **Boyne**; they are the 
production of a Dutch artist. To these decorations has lately been added a 
very vilely executed statue of King George the Third by Bacon. Why it was 


---

p.17



 
placed in a room now wholly neglected, and where it is scarcely ever seen, 
those who placed it there best can tell: perhaps they thought — and if so they 
thought justly — that this would be more for the credit of the artist. There is 
certainly no building in London to be compared for architectural beauty with 
the Bank of Ireland. It is built of Portland stone, as are most of the modern 
buildings of note in **Dublin**.


Next to it must be mentioned two other very handsome modern buildings, 
the Custom-house, and the Four-Courts, as it is called, where the principal 
courts of law are held. The former stands on the quay, thence called Custom-house Quay, on the north side of the river, and almost at the eastern extremity of the town. It was begun in the year 1781, and finished in 1791. It 
is said to be no less commodiously arranged in the interior for transacting business, than it is handsome in the exterior. One defect, however, must not pass 
unnoticed, since it is very striking — that it is placed much too near the river; 
had it been thrown backwarder, it would have been seen to tenfold advantage. 
Situated as it now is, no good view of it can be obtained but from the other 
side of the water; and that, unfortunately, is a dirty disagreeable badly inhabited 
part of the town, abounding with those minor public-houses which are the great 
resort of the sailors.


The Four-Courts stands also on the north side of the Liffey, much more to 
the west, on a part called King's Inn Quay. The same defect which has 
been noticed at the Custom-house is no less striking here — that it is placed 
much too near the river; a spacious area before it is wanted for the architecture to be seen to advantage. It is also, unfortunately, no less to be remarked, 
that while no good view of the building can be obtained but from the other 
side of the water, that other side is a very dirty disagreeable part of the town. 
The first stone of this building was laid by the Duke of Rutland when he was 
Lord Lieutenant, in March 1786, and the courts were opened for the administration of justice in November 1796. The four courts are those of the 
King's Bench, Chancery, Exchequer, and Common Pleas; but there are many 
other law offices here.


Trinity College is not less one of the great ornaments of **Dublin** as a public 
building, than as a learned institution. Among a great deal of most pleasing 
and agreeable society to whom I was introduced during my stay in this city, 
 


---

p.18



 
must be mentioned Mr. Hamilton Rowan and his family. Upon this gentleman's political character and opinions a diversity of sentiments may be entertained: a man who has taken the warm and decided part in the political world 
which he has done, will of course be an object of eager admiration among those 
whose opinions coincide with his own, while those who differ from him will regard him with almost equal reprobation. Of his manners in private life I 
should think but one opinion can be entertained, — that he is most truly the polished gentleman, a character not very common even in the sphere where most 
it might be expected to abound. To his and Mrs. Hamilton Rowan's polite 
attentions I was indebted for seeing the college much more completely than 
would have been possible without such patronage. At their request Dr. Magee, 
at present dean of Cork, one of the Fellows of the college, whose name it is 
almost superfluous to mention as one of high note in the literary world, went 
over the library with us, and introduced to my notice every thing most deserving 
the attention of a stranger. 


The principal room is a very fine one, two hundred and seventy feet in length 
by forty in breadth; a length exceeding any other single room for the reception 
of books in the United Kingdoms. It is fitted up entirely with the dark old 
Irish oak, which gives it a truly dignified and venerable appearance. A gallery 
with a balustrade of the same oak runs round it, which is decorated with a 
profusion of busts. Down one side are those of celebrated characters of antiquity, as Homer, Plato, Socrates, Aristotle, Demosthenes, Cicero, Euripides, 
Sophocles, &c. &c. Along the other side are modern characters, as Lord Bacon, Sir Isaac Newton, Mr. Locke, **Dean Swift**, **Shakespeare**, Milton, Dr. 
Baldwin, Dr. Delaney, Archbishop Usher, and many others. The latter was 
a very liberal contributor to the library. This room contains about forty thousand volumes of the best works in all branches of literature. At the upper end 
it is crossed by a smaller room, the two making together the form of a T, where 
is now deposited the celebrated Fagel library from Amsterdam. This library 
was among the spoils brought over to England at the revolution in Holland 
when the Stadtholderian government was overthrown. It was offered for sale 
to both the English Universities at the price of fourteen thousand pounds, but 
the purchase was declined by both as too expensive; it was then proposed to 
the University of Dublin, and at first declined by them upon the same grounds. 


---

p.19



 
But very soon after a discovery was made of a large sum of money due to the 
College, till then unknown to them, and it was agreed to appropriate this sort of 
deodand to a purchase which had not been declined without great reluctance 
and regret.


Bonaparte, who was then at the head of the French government, had just 
about the same time sent over a commission to have the most select works 
in this collection purchased for the National Library at Paris; but the University 
of Dublin proposing to take the whole, the bargain was concluded with them 
for the sum originally proposed. The collection consists of about twenty thousand volumes, among which are a number of very valuable classical and historical works in a great variety of languages. There is a very fine copy of **Madame 
Merian**'s celebrated drawings of the insects and plants of Surinam. This collection was made by three successive heads of the family of Fagel: the son of the last, 
whom the necessity of the times compelled to part with it, has visited **Dublin** since 
the books were transferred thither. He expressed himself greatly consoled, 
under the mortification which he could not but feel at seeing this monument of 
the taste of his forefathers transferred to a foreign country, in reflecting that 
the collection was preserved entire, and occupied so conspicuous a station in so 
noble an university.


Before the purchase of this library the apartment which it occupies was appropriated to manuscripts; they are now removed into a room over it. Here 
I saw some fine specimens of ancient penmanship, among them a beautiful 
Missal the writing and splendid illuminations of which were all executed by 
nuns. Another remarkable work is a topographical description of all the provinces in **France**, in manuscript, in thirty-two volumes folio. In this room is a 
small collection of very curious books bequeathed to the College by a remarkable 
character of the name of Quin, and called after him the Quin Library: among 
them are some of the most choice editions of the Classics, in the most expensive 
and elegant bindings. I was also shown some curious old Irish manuscripts, 
which of course were not intelligible to me, and indeed there are very few 
persons now in existence to whom they are so; but as relics of remote antiquity I could not but regard them with extreme veneration. One of them was 
a copy of the old Brehon laws.


But among the greatest curiosities in the library is a work executed by Dr. 


---

p.20



 
Barret, one of the Fellows of the college, a very remarkable character, in whom 
a passion for books and learning even rises above another very prevailing feature, the love of money. In looking over the manuscripts he discovered 
one which upon a close inspection he perceived to be written over another 
of much older date, the former writing having been effaced, though not 
so effectually but that faint traces of it were discernible. He immediately 
applied himself to making out as much of the original manuscript as could 
be deciphered, and succeeded so far as to ascertain it to be a Greek manuscript of St. Matthew's Gospel. He has since had the text printed as far as 
sufficient remains of the characters can be traced to admit of it, for some are 
wholly effaced, supplying the blanks with points. In front of the page it is 
printed in a fac-simile of the original characters, and on the back in those of 
the modern Greek. The whole has been a work of immense labour, but from the 
peculiar turn of the Doctor's mind has afforded him no less gratification than toil. 
This gentleman never stirs beyond the college walls excepting twice in the 
year to the Bank, which is close by, to receive his half-yearly dividends, an office 
which he would not on any consideration depute to another; and on an annual 
visit with the Board to the College Observatory at Dunsink four miles from 
Dublin. The consequence of this secluded life is excessive simplicity of manners and utter ignorance of the world. He has been forty years Fellow, and 
for many years his fellowship has produced an income of 2000 l. a year, of which 
he perhaps scarcely spends twenty pounds, excepting in books; of these he buys 
a great number, and often very expensive ones. At the same time his penuriousness in other respects is such, that were not his dinner provided free of expense 
by the College, he would run some hazard of being starved. His memory is 
astonishing: not long since, in answer to some question which was asked him, 
he not only ran over a list of all the gentlemen who had been provosts and vice-provosts 
 of the college since its foundation, but gave every circumstance attending the election of each individual. He knows every book that has been 
brought into the library since he became Fellow.


The college is divided into two courts, the library occupying one entire side 
of the interior court; a piazza runs underneath it, which affords a sheltered 
walk in wet weather. This building is of stone, but unfortunately of such a 
soft and mouldering nature that though not a hundred years old it seems falling 


---

p.21



 
rapidly to decay. In the first court are the chapel and the theatre, standing opposite 
to each other, both very handsome buildings; the interior of the chapel, 
like the library, is fitted up with old Irish oak. The theatre, or examination-room, 
where the principal college exercises are performed, is eighty feet in length by 
forty in breadth. On one side is a marble monument to the memory of Dr. 
Baldwin, formerly provost of the college and a great benefactor to it, leaving it 
by his will property to the amount of eighty thousand pounds. The monument 
represents the Doctor expiring, having a scroll in his hand intended as his will, 
and bending over him is an allegorical figure of Learning in deep affliction at the 
loss of one of her favourite sons. The monument was executed at Rome by a 
Mr. Hewetson a native of **Ireland**, but who deserted his own country for that 
centre of the arts, Italy. Round the room are whole-length portraits of **Queen Elizabeth** (the foundress of the college), Archbishop Usher, Archbishop King, 
Bishop Berkeley, **Dean Swift**, Mr. Molyneux, Dr. Baldwin, Lord Clare, and 
the Right Honourable Sir John Foster. 


The museum is a good room, and contains a tolerable collection of Irish minerals, with some specimens of the basaltic columns from the **Giants' Causeway**. 
Of other natural curiosities the most conspicuous and rare is a stuffed giraffe 
or camelopard. Among the most interesting objects of art are a model of the 
**Giants' Causeway**, as it is called, and the harp of the celebrated Irish patriot 
king, Brian Boroimhe, or Brian Boru as the name is commonly pronounced. 
This object is alike interesting from having belonged to so noted a character, 
and from being an undoubted specimen of the true ancient Irish harp. The 
model called that of the **Giants' Causeway** I afterwards ascertained to be, as I 
then suspected, not of that extraordinary natural phaenomenon itself, but of the 
promontory of **Pleaskin** in its vicinity. It is carved in wood, and very well 
executed. 


At the bottom of the staircase leading up to the museum, there are among 
other objects a curious model, in plaster of Paris, of an ancient Roman galley, 
and a pair of horns with the skeleton of the head and some other bones of the 
moose deer. This is the name given to an animal now only known, like the 
mammoth, by the remains of him occasionally discovered in digging in the 
earth; in the Irish language he is called vamh-alca, or the wild ox, but the form 
of the head and the horns are those of the deer not the ox species. These 


---

p.22



 
remains are generally found at a great depth, in a stratum of marle covered 
with bog. About forty or fifty years ago a pair of these horns with the skull 
were dug up in some lands belonging to the see of Dromore, the largest ever 
discovered, they measured fourteen feet from tip to tip: the bones of a fore 
leg were also discovered, from which it was conjectured that the animal to which 
they belonged must have been twenty hands high. The horns at the college 
museum cannot approach near to this measurement; still they are very large, 
and the weight of them must be prodigious, while the size of the head seems 
wholly incompetent to supporting them. No entire skeleton of this animal, 
any more than of the mammoth, has ever been found. When it existed in 
**Ireland**, or when the race disappeared, no tradition pretends to determine, 
though some people will take upon themselves decidedly to affirm that it disappeared 
at the deluge: these must forget the command given to Noah, to 
carry with him into the ark two of every species of living creature, or must 
charge the patriarch with negligence in obeying the command. That a creature wearing these enormous horns did once exist, the horns themselves attest, 
and this is all that is known about him: they are seldom found singly, — that is, 
if one pair are found, it has rarely happened but that by digging near more have 
been discovered. Sir Edward Bellew is said to have at his seat near Dunleer 
in the county of Louth, the best preserved pair that have ever been found.


The College park is spacious, and is a great advantage to the young students, 
to whom it is open. The Fellows have a garden to themselves, which affords 
such as love retirement a nice secluded walk. But I must observe, that the 
same attention is not paid as in England to keeping the gardens, lawns, and 
shrubberies neat, and in nice order: this is more particularly the case in and 
about the capital; in the remoter parts of the country I found much more 
attention to this object; indeed in the neighbourhood of **Dublin** I never saw 
any thing that could fairly be called a lawn. The grass in the college garden 
was long and straggling, as if left growing for hay, and the borders were full 
of weeds. The gravel of the country is besides of a dark hue, unpleasant to 
the eye, and at the first glance appearing scarcely better than cinder ashes; 
yet it is fine, binds well, and is firm and pleasant to the foot.


The foundation of the College consists of a provost and twenty-two fellows, 
seven seniors and fifteen juniors. By an old statute the Fellows were not allowed 


---

p.23



 
to marry; but this they had for a long time found the means to evade, 
till in the year 1812, at the suggestion of Dr. Hall the provost, and Chief Justice 
Downes the vice-chancellor, an order was made by the Government that 
in future the Fellows should at their election take an oath that, in case of their 
marrying, notice of the marriage should be given to the provost within fifteen 
days; the consequence of which is, that the fellowship is immediately vacated. 
There are a great many livings in the gift of the College, some very valuable 
ones, as much as 2000l. a year, which must be given to the Fellows. Five royal 
professorships also belong to this foundation, viz. for divinity, common law, 
civil law, physic, and Greek; with three medical ones, established by the will 
of a Sir Patrick Dunn, for the theory and practice of physic, for surgery and 
midwifery, and for pharmacy and the **materia medica**. Besides these there are 
professors of mathematics, astronomy, the Oriental tongues, the Irish language, 
oratory, history, and natural philosophy: also a great number of scholarships 
and exhibitions for the encouragement and assistance of the young students. 
The number of students is generally from six to seven hundred. The former 
buildings having been found insufficient for the purposes of the College, new 
ones are now erecting to a considerable extent. The provost's house is detached from the college, but standing close by it. The students wear a black 
gown and square cap, as at the English universities, but at present only in 
college; formerly they were obliged to wear them at all times, but that practice 
has been gradually laid aside.


There is a very fine Observatory belonging to the College, at Dunsink four 
miles from the city. It contains an astronomical circle eight feet in diameter, 
the work of Mr. Ramsden, the finest instrument of the kind ever made, with a 
remarkably fine transit instrument. The present professor of astronomy, Dr. 
Brinkley, is considered as one of the first mathematicians of the age, and is no 
less remarkable for the mildness and urbanity of his manners than for his profound learning and deep scientific knowledge. By the assistance of the noble 
apparatus here, he has been enabled to solve some very important problems in 
astronomy, which had for a long time been the subject of research among the 
most distinguished mathematicians all over Europe — A piece of ground just 
out of **Dublin** has been recently purchased by the College for a botanic garden; 
but it was at this time too much in its infancy to be worth seeing.




---

p.24


Renewal of an old Acquaintance — The **Dublin Society** — Mr. Prior its 
Founder — Collection of Minerals — Meteoric Stone — Carthaginian Axes. — The Library — Collection of Casts — Exhibition-Room — Botanic Garden. — Removal of the Society to Leinster-House — The Dublin Institution — The 
Royal Irish Academy — The Castle — The Exchange — The Commercial 
Buildings — The Post-Office.
#### 4


I had not been many days in **Dublin** when I was most fortunately furnished 
with an opportunity of renewing an acquaintance from which many years before I had derived great pleasure; this was with **Mr. Weld** the ingenious 
author of Travels in America, and of an excellent description of the **Lakes of Killarney**. We met by chance in the street; and, though nearly twenty years had 
elapsed since our last meeting, we had no difficulty in recognising each other. 
Such an encounter was the more fortunate since **Mr. Weld** was not an inhabitant of **Dublin**, he was only come from the country for a few days. He 
very obligingly expressed great pleasure in the interview; and, to prove that 
these expressions were not empty sounds, anxiously inquired how he could 
contribute towards doing the honours of his country to a stranger. Finding 
that I had not been at the **Dublin Society**, of which he is a very zealous and 
active member, he insisted upon carrying me thither at the instant; and thither 
we accordingly went.


This Society, such as it now is, has varied very considerably from its original institution. So long ago as in the year 1731, a number of gentlemen, 
at the head of whom was Mr. Prior of Rathdowney in the Queen's 
County, associated themselves together for the purpose of improving the agriculture and husbandry of their country; and this was the first association ever 
formed, in the British dominions at least, — perhaps it might be said, all the 
world over, — expressly for such purposes. Mr. Prior afterwards, in the year 1749, 
when Lord Chesterfield was Lord Lieutenant of Ireland, through his interest 


---

p.25



 
with that nobleman procured a charter of incorporation for the Society, with a 
grant of 10,000 l. per annum for the better promotion of its views.[4](javascript:footNote('E810001-001/note004.html'))


It has however in the lapse of time, by first enlarging the objects it embraced, 
at length lost sight of its original and primary one; so that while agricultural societies have in the course of a few years started up almost with the 
rapidity of mushrooms, throughout the British dominions, — this, the father of 
them all, is scarcely one any longer: 
 — a new society is formed for agricultural 
purposes, while the original one is principally devoted to the promotion of the 
arts and sciences. The stipend granted by the Government is not the less continued to it. 


 
The collection of minerals is esteemed one of the most complete and the 
most scientifically arranged that any country can boast. The Museum Hibernicum — Regnum Minerale — contains, as its title denotes, the minerals of **Ireland** 
alone; and few countries yield a more abundant harvest to the mineralogist: 
they are very judiciously selected, and admirably arranged. Among them is a 
piece of the Wicklow gold, and with it a model in brass of the largest piece 
ever found, weighing twenty-two ounces. But the great collection is the Leskean 


---

p.26



 
Museum, as it is called, after **Mr. Leske** by whom it was made. This 
gentleman was Professor of Natural History at **Marpurg** in Germany, and was 
a pupil of the celebrated Werner, according to whose system the minerals are 
arranged. They consist of between seven and eight thousand specimens, from 
all parts of the world. At the death of **Mr. Leske**, his heirs not inheriting 
his taste, or perhaps wanting the money, the collection was offered to sale, 
and was purchased by the **Dublin Society** for twelve hundred guineas.


Among the Irish minerals are specimens of all the different forms assumed 
by the basaltic columns at the **Giants' Causeway**; and a meteoric stone which 
fell in the county of Tipperary, the fall of which is too well authenticated to 
admit of a doubt. Two men were at work upon the top of a house, when they 
heard a whizzing noise as if a cannon-ball were passing rapidly over their 
heads, and in a few instants saw something strike the ground at no great distance. They hastened immediately to the spot, when they perceived that the 
earth had the appearance of being recently ploughed up; and raking in it with 
their hands they soon found this stone. It was then so hot that they could 
scarcely bear to touch it, and retained the same heat for nearly four hours. 


A large collection of specimens of different woods forms another very interesting object in this Museum. There is also a piece of wood from a tree, 
which when cut down was found to have letters carved in it, so far within, as 
to prove incontestably the truth of **Mr. Forsyth**'s theory, that the bark forms 
over and over the trunk of the tree in repeated coats. The collection of stuffed 
birds and other animals is by no means large or very select; there are some 
remains of the moose deer, but not so good as at the College museum.


Among the relics of antiquity are several heads of axes, which were dug 
up in the south of **Ireland**, corresponding exactly with some that have been 
found in the plain of Cannae and in Egypt, and which are considered as Carthaginian. This seems strongly to corroborate the idea that the Carthaginians, 
the most adventurous navigators of ancient days, actually traded to **Ireland**. 
Here is also a spur found in digging in some remote part of the country, of a 
size so enormous, and with a rowel so enormous, that it really seems as if it 
had belonged to a giant. Models of Stone-henge such as it is now, and 
such as it is supposed to have been when perfect, are among the curiosities 
shown. With them is a model of a circular erection in some part of **Ireland**, — 


---

p.27



 
I do not recollect where, — which seems to have been of the amphitheatre kind 
An esplanade runs round the top, and within, all round, are steps up to it in the 
annexed form. 


No tradition speaks of this, or throws any light upon the purpose for which it 
was destined. 


The Society has a very good library, particularly in works relative to the 
arts and sciences; and a collection of casts from some of the most celebrated 
works of the antique, as the Apollo, the Laocoon, the Gladiator, &c. &c. intended principally for the assistance of students in the beautiful art of sculpture. 
This collection is always open to any one who shows a taste for the arts and is 
desirous of improving it, whatever may be his rank and situation in life. I saw 
some specimens of the works of the pupils very well executed. There is a very 
complete chemical laboratory, with a theatre for lectures. The board-room, 
where the meetings of the Society are held, is large and handsomely fitted up: 
in it are whole-length portraits of **Sir John Foster** and **General Vallancey**; the 
latter is well known for his researches into the antiquities of **Ireland**.


The Exhibition-room is spacious and handsome. It was originally appropriated solely to exhibiting the works of living artists; but this year for the 
first time, in imitation of the British Institution in London, the principal noblemen and gentlemen of the country, who had in their possession good pictures 
by the ancient masters, had lent them to form an exhibition, for the benefit of 
young students. The pictures were to remain for three months. To students 
this gallery was open gratis till eleven in the morning: from that time till five 
in the afternoon it was open for the reception of company; each person paying 
an English shilling admittance, that is thirteen pence Irish money. There were 
some very fine pictures: particularly a St. Sebastian by **Guercino**, a St. Jerome 
by **Spagnoletto**, a landscape by **Claude Lorraine**, and one by **Cuyp**; from the 
duke of Leinster's collection: a portrait of Caesar Borgia by **Titian**, from the 


---

p.28


**Earl of **Charlemont****'s; the Martyrdom of St. Stephen by **L. Carracci**, from 
Trinity College; a St. Francis by Guido, from **Sir T. Newcomen**. These 
I mention as among the most striking, but there were many other very good 
ones. The principal contributors to the exhibition were, the Duke of Leinster, 
who sent nineteen pictures; **Lady Harriet Daly**, eighteen; Dr. Tuke, thirteen; 
Trinity College, six. These are the largest numbers sent by any contributors 
but the list of names by whom pictures were sent amounted to twenty-five, and 
the number of pictures to a hundred and thirteen.


Added to all these things the Society have a most noble botanic garden at 
Glasnevin, a village just out of **Dublin** to the north. It is much larger than 
any other that I have seen either in the British dominions or in **France**, beyond which my knowledge does not extend; comprising more than sixteen Irish 
acres of ground, or about twenty-two English acres, and is laid out with great 
taste and judgement. The conservatories, however, and the collection of 
exotic plants, are not so good as in the King's garden at Kew. It stands very 
high; and there is a fine view from the eminence, over the city and bay. 
Nothing, in short, can be conducted upon a more complete and liberal plan 
for the promotion of its various objects, than this Society is. The number of 
members at present is about five hundred: they are elected by ballot; each 
member, the honorary ones excepted, paying 50l. on admission, which constitutes them members for life. By these deposits, and the grant from Government, the institution is supported. There are no annual subscribers.


The house in which I saw it in 1814 was in Hawkins-street, near the College. Before my second visit to **Ireland** in the following year, Leinster-house, 
in Kildare-street, the town-residence of the Duke of Leinster, had been purchased by the Society, and the collections were all removed thither, but not 
arranged; so that, to my great regret, I could not renew and enlarge my acquaintance with objects so multifarious and well deserving the attention of every one visiting **Dublin**. 


The Dublin Institution in Sackville-street has a very good library, which is 
open to the proprietors and members from seven in the morning till ten at 
night, with a second collection of books for circulation among the members, 
from which each may have two out at a time. There is also a news-room, 
where are English, Irish, Scotch, and French newspapers. It was originally 


---

p.29



 
intended to have lectures on different branches of science and literature; but 
this part of the plan has not yet been accomplished. A lecture-room was 
built, and a philosophical apparatus purchased; but so much money was expended on the library and these things, that it has been thought prudent to 
withhold the lectures awhile; with the intention, however, of resuming the idea 
whenever it shall be found practicable: and as the number of members is 
rapidly increasing, it is hoped this may be at no very distant period. The 
Institution was commenced only in 1811, by three hundred subscribers at 50l. each. A subscription of that sum constitutes a proprietor: and these shares 
are transferable; only that the person to whom the share is to be transferred 
must be elected by ballot among the proprietors. Besides the three hundred 
proprietors, there may be members without limit, who pay three guineas entrance, and three guineas a-year; but they must also be elected by ballot. The Institution is managed by a committee of proprietors; but, this excepted, the 
members share all advantages equally with the proprietors.


The Royal Irish Academy was founded by the late **Earl of **Charlemont****, and 
was incorporated by charter in the year 1786. Its objects are the advancement of science and polite literature, and the study of antiquities. In each of 
these departments there is a committee of seven, chosen for carrying on the 
purposes of the Academy. That for science meets on the first Monday in every 
month; that for polite literature on the second Monday; that for antiquities 
on the third; and a meeting of the Academy at large is held on the fourth. 
The Council, which consists of the three committees, meet from time to time 
by adjournment. An annual prize of a gold medal worth 50l., or that sum in 
money, is given by the Academy on a subject which is agreed among themselves. 
Twelve volumes of the Transactions of this Academy have already been published.


I was favoured by a gentleman, with whom I had the pleasure of passing 
many very pleasant hours in my second visit to **Dublin**, Mr. Kernan, a person 
of very extensive knowledge and science, with a copy of an essay by his sister 
which had obtained a prize from the Academy. The subject is  *The Influence of fictitious History on modern Manners*. It is a work of great erudition and sound 
reasoning; and though the modest author, in printing the work, has not affixed 
her name to it, she has proved that name deserving of a high place among the 


---

p.30



 
literary characters of her sex. Since I was last at **Dublin** Mr. Kernan has also 
distinguished himself so much by a course of chemical lectures, as to have been 
complimented for them by the Company of Apothecaries in **Dublin** with a piece 
of plate bearing an inscription suited to the occasion.


The Castle, as it is called, the seat of government, and town-residence of the 
Lord-lieutenant, was in former times actually a fortress, flanked with bastions, 
and having a ditch round it. The latter has long been filled up, and no vestige 
now remains of a castellated appearance, except one tower used as a repository 
for keeping the national archives, records, &c. The wall of this building is said 
to be fourteen feet thick. This loss of the venerable remains of antiquity is not 
compensated by any beauty of modern architecture. The deputy's residence in 
this country bears indeed a striking affinity in its outward appearance with that of 
the principal in London; 
 — neither of them possesses a single one of those features 
which the idea of a palace immediately presents to the imagination. **Dublin Castle** is an ugly, shabby, red-brick building; and an uglier material for building was never invented by the ingenuity of man, till the architects of Brighton 
thought of using the still more hideous black composition of which so many houses in that town are constructed.


The whole range of building is divided into two courts. In the interior 
court, which is called the Upper Castle-yard, are the state apartments, with 
the private apartments of the Lord-lieutenant, and those of most of the great 
officers of state. In the outer court, or Lower Castle-yard, are the treasury, 
the offices of the board of ordnance, of the quartermaster-general, of the secretary-at-war, and other public offices, with an arsenal, and an armoury containing 
arms sufficient for eighty thousand men. But the most beautiful part of the 
castle is the new Gothic chapel, which occupies a conspicuous place in the 
Lower Castle-yard. It was not completed at the time of my first visit to 
Dublin, but was so at my second; and though not open promiscuously to all, 
through the politeness and patronage of **Sir William Betham**, the herald-at-arms, I was shown all over it. It is in the true Gothic style of the days when 
that mode of building was arrived at its highest perfection; and is indeed a 
beautiful specimen of modern taste and industry. The ornaments are copied 
principally from York cathedral.


The Exchange is a handsome but not large modern building, close to the 


---

p.31



 
Castle. Of late years it has been found so insufficient for the increasing trade 
of the country, that a building at least equally spacious, called the Commercial 
Building, has been erected near it by private subscription, as an auxiliary. It 
has a neat stone front, without any attempt at ornamental architecture. 


The Post-office has at present nothing to boast of as to outward show; but the 
first stone of a new one in Sackville-street was laid this year by the Lord-lieutenant on the twelfth of August, the centenary of the Hanover accession to the 
throne of England. The plan is said to be of equal beauty with the other 
modern buildings of **Dublin**; and being placed in the widest street of the city, 
where it will be seen with every advantage, it will be a great additional ornament.




---

p.32


Saint Patrick's Cathedral — **Dr. Marsh**'s Library — Bust and Picture of 
**Dean Swift** at the Deanery — Mr. Monk Mason — Cathedral of Christ-Church — Earl Strongbow's Monument — Lord Bowes's — Lord Kildare's. — Mr. Priors — Ruins of the Four-Courts — Ancient Archway — Saint 
Werburgh's Church — Saint George's Church — Saint Andrew's or the 
Round Church — Other Places of Worship.
#### 5


Such are the associations connected with Saint Patrick's cathedral, that no 
one can visit **Dublin** without feeling his attention early and eagerly directed 
towards it. I have mentioned that I had a letter of introduction to Sir Charles 
and **Lady Morgan**; to their politeness I was obliged for several other very 
agreeable acquaintance to whom I was introduced. Among them was that distinguished scholar and zealous antiquarian, **Mr. William Monk Mason**, with his 
beautiful and amiable wife. When I talked of going to Saint Patrick's, **Mr. Mason**, with the same disposition that I every where found to do the honours 
of the country in the politest manner to a stranger, proposed accompanying me 
thither the next Sunday, when he would explain all the antiquities, and would 
speak to the Dean that I might hear the best voices in the choir; — the party was 
joined by **Sir Charles** and **Lady Morgan**. A very fine Cantate Domino and 
 Deus misereatur were performed, with an anthem from the hundred-and-thirty-ninth Psalm, by three voices. The first singer, Mr. Spray, is indeed a very fine 
one; and the other two, though not perhaps equal to him, were such as would 
be an ornament to any choir. 


Saint Patrick's is a Gothic building of the twelfth century: it is not large, 
and is very plain, devoid of that profusion of ornament bestowed upon the generality of our Gothic buildings in England, and which renders them so magnificent. Indeed none of the Gothic remains in **Ireland** are to be compared with 
those in England. I believe some of the latter are allowed to be the best in existence in any part of the world; I saw none in **France** equal to them. The 


---

p.33



 
choir at Saint Patrick's is handsomely fitted up with Irish oak, and has some 
very good carved work about it. The tower is the handsomest part of the exterior; but it is exceedingly deformed by the addition of a spire so totally defective in taste and workmanship, that it looks like a vast extinguisher: it was 
added so lately as the year 1750, **Dr. Stearne**, bishop of Clogher, having left 
a legacy for the purpose. In the nave of the church stands the monument to 
**Dean Swift**, which is an object of almost sacred veneration to the inhabitants; 
yet has he a more lasting monument than could be formed in brass or marble, 
in the bosoms of a grateful nation, to whom he was so generous a benefactor, 
of whose rights he was such a strenuous supporter. Near his monument is one 
to **Stella**, and another erected by the Dean to **Alexander Magee**, a faithful servant of his, who died in the year 1722. Since the monument to the Dean was 
first erected, a bust of him, esteemed a very good likeness, has been placed over 
it by Mr. Faulkner, the nephew and heir of **George Faulkner**, the dean's bookseller and the publisher of his works.


Besides these there is in the nave a monument to **Dr. Marsh**, formerly archbishop of Dublin, who bequeathed a very valuable library to the use of the public. 
This library is kept in a room near the cathedral. The Doctor's intention appears to have been that it should be perfectly free to every-body: but this valuable 
privilege being, as is but too often the case with such institutions, in some instances greatly abused, it has been found necessary to lay certain restrictions 
upon the use of the books. The library is open every day from eleven to three 
o'clock, Sundays and holidays excepted, when all graduates and gentlemen are 
admitted to read; but no one is allowed to take a book down himself, he must 
apply to the librarian for what he wants. Since this donation, the access to 
books has become so much more easy by means of reading-societies and other 
literary establishments, that it is now but little resorted to: not having a fund 
to add new publications to the present stock, it is become rather more an object 
to the learned few than to the general mass of readers. 


Opposite to **Dr. Marsh**'s monument is one to **Dr. Smith**, another archbishop 
of Dublin, who died in 1771; and on one side of the great west door is a very 
curious old monument again to an archbishop of Dublin, but at a much earlier period, a **Dr. Michael Tregury**, who died in 1471. The prelate is represented in the full canonical dress of those times, with his crosier, and an 


---

p.34



 
angel is fastened by rings to his fingers. In the choir, on the south side of the 
communion-table, is an immense ugly massive monument of painted wood to 
the family of Boyle, earls of Cork, on which are effigies of different members 
of the family to the amount of sixteen. On the other side of the communion-table is a monument to the Marshal **Duke de Schomberg**, who was killed at the 
memorable battle of the **Boyne**. It was erected in the time of **Dean Swift** at 
the expense of the Chapter. There are many other monuments in different 
parts of the church, but these are the most distinguished.


 
The Chapter-room forms the south transept. In it are suspended the banners with the other insignia of the deceased knights of St. Patrick; those of the 
living knights are suspended in the choir of the church. Near the chapter-room, in a niche in the south wall of the church, is a little basin of water called 
St. Patrick's well, to which are ascribed so many virtues, that it is very much frequented by the lower classes of the people. The Chapter consists of twenty-six 
members; the dean, twenty prebendaries, two archdeacons, the chancellor, the 
chanter, and the treasurer. One of the prebendal stalls, that of Cullen, is annexed to the archbishopric.


Though this edifice has no peculiar beauty of architecture to be displayed, 
yet as a venerable relic of antiquity, and as being rendered still more venerable by the revered name of Swift now attached to it, so indissolubly that the 
church cannot be adverted to without the idea of that extraordinary and comprehensive mind presenting itself; — for these reasons it is much to be regretted 
that it stands in so bad a part of the town, and that there is no good access to 
it from any quarter. The best is by the west door; but this is never opened 
except on extraordinary occasions, such as an installation of the knights of St. 
Patrick, or some other grand ceremonial. Added to this, it is so inclosed round 
with miserable houses, that it is really difficult to make out where the walls of 
the church are. This is a fault also to be regretted in some of our most magnificent cathedrals in England. Something has of late been done towards removing the nuisance, for so it must be termed, from Westminster Abbey, honour 
and praise be to those who have presided at the improvement! but much still 
remains to be done. St. Patrick's cathedral would make an infinitely more respectable appearance standing in a large area.


After we had looked over the church, the Dean obligingly carried us into the 


---

p.35



 
Deanery, to see a bust of **Dean Swift**, and an original full-length picture of him. 
The bust cannot be supposed a likeness; it is very unlike all other representations of this celebrated character, and bears by no means the stamp of genius 
the forehead is remarkable for sloping back very rapidly from the eye-brows, 
in direct opposition to that fine arched forehead which is the distinguishing feature of intellect. The picture, however, makes ample amends: in that countenance may indeed be traced the genius capable of writing those travels, which 
alone are sufficient to confer immortality on a man, supposing that he had 
never been otherwise distinguished; — those travels which must ever be ranked 
among the first of human productions for true philosophical reflection, and for 
the most refined wit and humour. In saying that we trace in this countenance 
the mind capable of producing such a work, every thing is said. The frame is 
a curious piece of carving, having the harp on each side with a variety of other 
emblems; it is of the fine Irish bog oak: but, O sacrilege! one of the deans 
had it gilt over, so that the true beauty of the wood, which is almost equal to 
ebony, is wholly lost. What shall be said of the taste of such a man? This 
picture, with three dining-tables of very fine mahogany used by the Dean, are 
left as heir-looms to the Deanery. The house in which this celebrated man 
resided was some years ago destroyed by fire, but the present Deanery stands 
on the same site.


Another very high treat was afforded me by **Mr. Mason** during my stay in 
Dublin, in looking over his most extensive and valuable library. Ardent almost to enthusiasm in his researches into the antiquities of his country, particularly the ancient literature, he has amassed a very large collection both of 
printed books and manuscripts relative to them; among them are several manuscripts relating to the Brehon laws. But one great object of his ardour is 
collecting all the old manuscript pieces of poetry in the Irish language which 
he can possibly procure. Of these fragments he has already a considerable 
number, and he is confident that he shall at length prove irrefutably the claims 
of **Ireland** to the Ossianic heroes, which **Scotland** has so long arrogated to herself, since he will be able to produce poems in manuscript to substantiate the 
Irish claims, while **Scotland** has only oral tradition to justify hers. **Mr. Mason**'s ardour in pursuing the objects by which he is thus deeply interested has 
a very able and admirable support, in one of the happiest and most *retentive*


---

p.36



 
of memories: the minute details which are stored in his mind, and which he 
puts forth in conversation in the most instructive manner, are really astonishing. Besides his rich collections relative to Irish antiquities, he has a number 
of scarce and valuable books in a great variety of languages both ancient and 
modern, with books of prints, &c. &c. in short, his library is an inexhaustible 
source of instruction and entertainment. I saw it in a state of great disorder, 
as he was but just removed into a new house in Harcourt-street, and half the 
books were lying scattered about the floor. Mrs. Mason, a most lovely and 
amiable woman, alike in person and disposition, has a few very fine specimens of old china.


The see of **Dublin** has two cathedrals attached to it, St. Patrick's and Christ-church. This latter, as the more ancient, ought perhaps to have had precedence, 
but St. Patrick's has by association a value stamped upon it which almost precludes the possibility of not adverting to it the first. The original foundation 
of Christ-church is ascribed to the son of one of the Danish kings of **Dublin**, 
early in the eleventh century, more than a hundred-and-fifty years before the 
foundation of St. Patrick's. It was then a college of regular canons dedicated 
to the blessed Trinity, but was converted into a Chapter at the Reformation. 
The church was probably in its original state, though built so long prior to 
St. Patrick's, much its superior as a piece of architecture. About two centuries and a half ago, from the decay of the roof, the south side of the nave fell 
down, and a mere blank wall has been built up in its place, which gives an air 
of deformity to the whole building; but the other side of the nave is much handsomer than any part of St. Patrick's: — this accident is commemorated by the 
following inscription on the new wall.
  
 
THE: RIGIHT: HONORABL: T: ERL: OF: SVSSEX: L: LEVTNT: THIS: WAL: FEL: DOWN: IN: AN: 1562 x THE: BILDING: OF: THIS: WAL: WAS: IN: AN: 1570.


The style of the building is for the greater part Gothic; but there is one arch 
in the south transept of the form generally called in this country Saxon.


Near the wall which fell is a monument to the noted Earl Strongbow, the 
great agent, in conjunction with Dermod Mac Murrough, then king of Leinster, 
in the subjugation of **Ireland** to Henry the Second. On a tablet of marble 
now not raised more than two feet above the pavement, lie the figures of a 


---

p.37



 
man in armour with a woman by his side, representing the earl and his wife: 
above is the following inscription: 
  
 
THIS: AVNCYENT: MONVMENT: OF: RYCHARD: STRANGBOWE: CALLED: COMES: STRANGVLENSIS: LORD: OF: CHEPSTO: AND: OGNY: THE: FYRST: AND: PRINCYPALL: INVADER OF: IRLAND: 1169: QUI: OBIIT 
1177: THE: MONVMENT: WAS: BROCKEN: BY: THE: FALL: OF: THE 
ROFF: AND: BODYE: OF: CHRISTES: CHVRCHE: IN: AN: 1562: AND: SET: VP: AGAYNE: AT: THE:CHARGYS: OF: THE: RIGHT: HONORABLE: SR: 
HENIRI: SYDNEY: KNYGHT: OF: THE: NOBLE: ORDER: E: PRESIDENT: OF: WAILES: L: DEPUTY: OF: IRLAND: 1570. 


The church was enlarged by Earl Strongbow in conjunction with the then 
Archbishop of Dublin and others, soon after **Dublin** surrendered to the English. 
The Chapter consists of a dean, three prebendaries, a chancellor, and a chanter. 
The Bishop of Kildare for the time being is dean, and one of the prebendal 
stalls is appropriated to the Archdeacon of Dublin. **Lambert Simnel** was 
crowned king in this church in the year 1468, by the title of Edward the Sixth. 
It was here that the liturgy was performed for the first time in **Ireland** in the 
English tongue, on Easter Sunday 1550. 


In the nave is also a handsome monument to Lord Bowes, who served several great law offices in **Ireland**, under the three kings of the House of Hanover. 
He attained the highest dignity in his profession, that of Lord Chancellor, in 
1757, and the following year was created a baron: he died in 1767. On the 
north side of the communion-table is a very fine monument to the Earl of Kildare, the nineteenth in succession who had borne that title, and whose son became Duke of Leinster. Another of the ornaments of this church is the monument to **Mr. Prior** the founder of the **Dublin Society**. On the top is his 
bust, below which stand two boys, one pointing to a bas-relief representing 
Minerva leading the Arts towards Hibernia, while the other holds in his hand 
a scroll, on which is the following inscription: — This monument was erected to **Thomas Prior**, esquire, at the charge of several persons who contributed 
to honour the memory of that worthy patriot, to whom his veracity, actions, 
and unwearied endeavours in the service of his country, have raised a monument 
more lasting than marble. — There are several other monuments in the 
church, but these are the principal.




---

p.38


#### 5


The pavement of the church has been so much raised since its first erection, 
that the basements of the pillars are now sunk several inches beneath it: the 
earth has, however, been removed all round the foot of one, to show what they 
were in their original state. To this cause must it probably be ascribed 
that the monument to Earl Strongbow appears now so little raised above the 
pavement; it may reasonably be presumed that it was higher originally; but has, 
like the pillars, been earthed up. The choir is rather handsome, and is fitted 
up with Irish oak. In it is a gallery for the Lord-lieutenant, who is obliged 
to attend service here on Christmas-day and on Easter-Sunday. The same 
singers perform the service here as at St. Patrick's; in the former at half past 
ten in the morning, in the latter at three in the afternoon.


This cathedral stands, like St. Patrick's, in a very bad part of the town. 
On the south side, joined to it, are a number of miserable ruins of the building where formerly the Four-Courts were held, before the erection of the present noble edifice. At the original foundation of the church, the episcopal 
palace was on this spot; but whether the Four-Courts were formed out of this 
building, or another was erected upon the same site, is not known. One part of 
the ruins is still inhabited, but only by the poorest class, and appears likely to 
fall at any moment. Close by is an archway of perhaps forty or fifty feet in 
length, which appears evidently to have formed part of a cloister; but it is now 
so earthed up within, that little more than the vaulted roof remains aboveground. The memory, on seeing it, recurs irresistibly to the stupendous ruins 
of ancient Egypt, so many of which are described as earthed up in like manner. 
The woman who showed us about took great pains to impress upon our minds 
the much greater antiquity of this church than St. Patrick's; the latter she 
seemed to hold in sovereign contempt, as a thing but of yesterday. 
  

*Beauties with beauties are in arms, 
  
 
And scandal pelts each other's charms, ’’*

John Gay, the Rat-Catcher and Cats

 
says the poet; and it should seem that the same is the case with rival churches, 
or at least they are made to do so by those who exhibit them.


Of the parochial churches, **St. Werburgh's** is the principal. There the Lord-lieutenant and Court used to attend divine service before the new chapel to 
the Castle was opened, St. George's is a very neat pretty new-built church, 


---

p.39



 
near Mountjoy-square, a quarter where within a few years almost a new town
has sprung up. The portico and spire are both handsome; 
over the portico is 
inscribed:
  
 
DOXA EN YPSISTOIS THEOO.


Saint Andrew's, or the Round Church as it is more commonly called, is 
remarkable for the circular form whence it has its name. Its external appearance is indeed so unlike any of our usually received ideas of a church, that no 
one, till informed, could possibly conjecture it to be one: besides its singular 
form, it has no tower or spire, though a foundation is prepared on which hereafter it is purposed to build a spire. The building is brick stuccoed over to 
have the appearance of stone; over the principal door is a group representing 
the martyrdom of the patron saint. There are sixteen other parish churches, 
but none particularly worthy of notice.


Dublin also contains sixteen meeting-houses for protestant dissenters of 
different persuasions, ten catholic chapels, six friaries, and six nunneries, but 
no synagogue for the Jews.




---

p.40


The Lying-in Hospital — The Rotunda — The Foundling Hospital — The Blue-Coat Hospital — Kilmainham Hospital — Other charitable Institutions — 
The House of Industry — The Beggars — The Black Cart — Sir Arthur Clarke and his Baths — Singular Talent 
of Lady Clarke — College 
of Surgeons — Markets — Potatoes.
#### 6


The charitable institutions of Dublin are very numerous, and well regulated: 
none among them is more deserving of particular notice than the Lying-in Hospital. This excellent charity owes its origin to the exertions of **Dr. Bartholomew Mosse**, once a celebrated surgeon and accoucheur in **Dublin**. Struck 
with the unfortunate and comfortless situation of poor women at such a moment, of which, probably, from the nature of his profession he had too often 
ocular demonstration, in the year 1745 he took a house in George's-street for 
their reception, and supported it for some time entirely at his own expense. 
Like many other patriotic undertakings, the utility of which has in the end 
been universally acknowledged and applauded, a great popular clamour was at 
first raised against this institution; but at length the benefit derived from it was 
so palpable, that not only was the voice of opposition silenced, but the popular cry became as warm in its favour as it had once been against it; and the 
number of patients applying for admission was so great, that the original house 
was by no means competent to receiving them. Many charitable and well-disposed persons now came forward to aid the Doctor's benevolent purpose; some 
with benefactions, others with annual subscriptions, till at length he formed the 
plan of erecting the present Hospital. He took a long lease of the ground on 
which it stands, and the first stone of the building was laid in 1751, by the then 
lord-mayor of Dublin; while, the better to secure the probability of supporting his new foundation, he expended a considerable sum of money in laying 
out a portion of the ground as a garden for public amusement. 
But in the prosecution of plans so extensive he had soon exhausted his own 
means, and was obliged to have recourse to raising money on credit, as well as 


---

p.41



 
to devise other schemes for procuring it. In a lottery he was tolerably successful; 
but, another scheme entirely failing, in the year 1755 he applied to Parliament for assistance, and obtained a grant of 6000l. The following sessions, 
on renewing his application, another grant was afforded him of a like sum; and 
at the same time a vote was passed giving him 2000l. for his own use, as an 
acknowledgement of his laudable and benevolent exertions. The same year he 
obtained a charter from **King George the Second**, incorporating a number of 
the principal noblemen and gentlemen of **Ireland** as governors of his new establishment, and appointing him Master for life. On the 8th of December 1757 
it was opened for the reception of patients. 


To the Hospital has since been attached a building, of a circular form, thence 
called the Rotunda, where are rooms for public amusements, as balls, concerts, 
or exhibitions of any kind, with a theatre for public lectures; and from the 
profits yielded by these different objects, combined with those afforded by the 
gardens, and collections made at the time of service in the chapel, the Hospital 
is principally supported. The gardens are open every night during the summer 
as a promenade, with a band of music and lights, each person paying sixpence 
at entrance, and they are much frequented even by very good company. About 
seventy thousand patients have been admitted since the opening of the Hospital, nineteen of whom have had three children at a birth, and one four. The 
building exhibits in the exterior a happy medium between excessive plainness 
and idle ornament, and nothing can be neater or more comfortable than the 
wards for the reception of the poor women. The chapel is very prettily fitted up; 
and as it is open to the public on Sundays, is much attended. The square in 
which this Hospital and garden stand is now called Rutland-square, from its 
having been much improved and embellished under the patronage of the Duke of Rutland when he was Lord Lieutenant. Since the death of 
**Dr. Mosse**, a 
new master of the Hospital is elected every seven years. 


The Foundling Hospital is a very extensive institution, established upon a 
truly noble and liberal principle, — the idea of removing every inducement to the 
neglect or destruction of infant innocence, which poverty or shame might 
prompt. But since the best of purposes must unavoidably be liable to perversion, so abuses had crept in here, which rendered it necessary some years since 
to establish such restraints as might at least very much correct, if not totally 
 


---

p.42



 
 
prevent them. Till that time all children were indiscriminately taken in; nothing was requisite but to deposit the child in a cradle fixed for the purpose at 
the principal entrance. This facility of admission occasioned children to be 
sent thither from all parts of the country; nay, they were even brought from 
England; the importation of them was, as I have been credibly informed, become a regular branch of traffic among the inferior traders between **Dublin** and 
Liverpool. By the present regulation, the person must knock at the door and 
deliver in the child; and though it is received without any questions being 
asked, yet the bearer being obliged to show him- or herself, has been found a very great check upon the former illicit practices.


The Hospital stands in a very airy situation, on the south side of the river, 
quite at the western extremity of the town. It was first founded in 1704; and, 
after various experiments for supporting it, a tax of one shilling in the pound 
upon the rent of all houses within the city was granted, with some additional 
duty upon inns, taverns, porter-houses, and the like. The establishment is extremely well conducted, and the children all look perfectly clean, healthy, and 
happy. The infants are for the most part sent into the country, to the care of 
nurses provided for the purpose, where they remain till they are six years old; 
but the nurses are required to present them at the hospital once a year, when 
they come for their salaries, that the directors may be assured proper care is 
taken of them.


The Blue-coat Hospital was originally intended for the support of the aged 
and infirm poor of the city, as well as for the education of children; but the 
funds proving inadequate to the support of so enlarged a plan, it is now confined 
to the education of boys. The sons of reduced freemen have the preference before all others, with the exception of about fifty, who being on particular foundations, the persons appointing them are left entirely at liberty in their choice. 
The children are lodged, fed, clothed, and instructed in reading, writing, and 
arithmetic, till they arrive at a proper age to be bound as apprentices. A mathematical-school is supported in the hospital by the corporation of merchants, 
for instructing a certain number of boys in navigation, who at a proper age 
are apprenticed to merchants or captains of ships, to be trained to the sea-service. 
Kilmainham Hospital is a fine institution, standing in a delightful airy situation, 


---

p.43



 
 just without the western end of the town. It is for the reception of invalid soldiers, and will hold four hundred pensioners. A great number of out-pensioners are also supported by it — The land on which this hospital stands 
formerly belonged to the Knights of St. John of Jerusalem, who, as well as the 
Knights Templars, had in their days of prosperity possessions in almost every county in **Ireland**. A stone fountain adjoining the burying-ground of the hospital is 
dedicated to the first-mentioned knights. **Tasso**, in his Gierusalemme Liberata, 
enumerates the Irish as among the nations that followed his hero to the crusade. 
**Fuller**, in his Holy Warre, mentions the priory of **Kilmainham** for hospitalers, 
and says that the Irish after Henry the Second's conquest of their country soon 
began to look towards Palestine; "Yea," he adds, "the concert of Christendom could have made no musick in these wars if the Irish harp had been wanting." 


St. Stephen's Hospital supports seventy aged persons, decayed housekeepers, 
tradesmen, and servants, besides being an infirmary for the sick. 


Swift's or St. Patrick's Hospital, founded by Dean Swift, is well known as an 
asylum for unfortunate lunatics and idiots. 


The Royal Military Infirmary in the Phoenix Park is for the reception of sick and wounded soldiers. 


Mercer's Hospital, founded by Mrs. Mary Mercer, is an infirmary for the sick poor: so also is Meath Hospital, but confined to those belonging to the 
Earl of Meath's liberty.


There are two Fever Hospitals, one in Cork-street, the other in Saint George's parish; — two Lock Hospitals, in Townsend-street and in Dorset-street; 
two Magdalen Asylums; — an Asylum for female orphans between five and ten years of age; 
 — an Hospital for blind and gouty men; — and one for persons labouring under incurable diseases, which holds fifty patients.


Near **Clontarf** is a Charter School, where a hundred-and-twenty boys are 
lodged, fed, clothed, and educated in the Protestant religion. 


Lately have been instituted schools for the education of the children of soldiers and of seamen. 


There are, besides, several Dispensaries, with an Institution for promoting 
Vaccination; and a variety of minor associations for different purposes of benevolence. 




---

p.44


#### 6


The Asylum for Instructing the Blind, instituted by the Duke of Richmond, 
must not be passed over without being particularized. 


Nor must the House of Industry. This is a most excellent, extensive, and 
well regulated establishment for the reception of the poor; — all are admitted 
who desire it, no recommendation is required; but they must submit to the rules 
of the house. They are not permitted to live in idleness: they are classed according to their abilities, conditions and deserts, and are employed in a variety 
of occupations. The children are kept separate from the grown persons; and 
there is an infirmary for the sick, considerably removed from the receptacles 
of the healthy. There are also a number of cells for lunatics; 
 — I think about fifty. 
The people are entirely maintained here; and the works carried on nearly support the establishment: many things manufactured or made in the house are 
to be purchased there.


With an asylum like this to resort to, it is a shame that such an object as a 
beggar should be seen in the streets; yet are there swarms; and so wretched and 
tattered is their appearance, that it is impossible not to recur immediately to the 
celebrated saying recorded of that arch-wit Foote, "that he used to wonder 
what the English beggars could do with their cast-off rags, till he went over 
to **Ireland**, and then he perceived that they were sent to the Irish beggars." 
Scarcely can a carriage stop at a shop, or a well-dressed person enter one, but the 
door is immediately surrounded by a number of these miserable-looking beings, 
whose clamours and importunities exceed those of the English beggars in equal 
proportion with the wretchedness of their appearance. A sort of caravan is 
often sent round the town, known by the cant name of the Black Cart, to take 
up persons found begging, and carry them to the House of Industry. The 
moment the beggars spy this vehicle at a distance, away they sculk into some 
place where they can lie concealed, nor venture forth again till a long time after 
it has disappeared. Sometimes, however, it will catch them unawares, and they 
are carried away: but there is nothing they dread so much; — to them working 
and being well kept, is greater misery than their rags and wretchedness, while 
indulged in their beloved indolence. The cart is always followed by a great 
mob of people, particularly children.


It is indeed a truth too striking to be passed over unnoticed, how much 
worse is the appearance of the lower classes in **Ireland** than in England! 


---

p.45



 
That in sending their cast-off rags to **Ireland**, the English beggars should forget the shoes and stockings, might not excite much astonishment, nor would 
it perhaps appear a subject of remark; but a stranger, from the southern division of Great Britain at least, — though the same impression might not be 
made on one from the northern, — must be exceedingly struck at seeing people 
walking about the streets without shoe or stocking, though not otherwise very 
poor and wretched in their appearance. This is more especially the case with 
the women, among whom such a spectacle is the most revolting. I have even 
seen in the north of **Ireland**, very well dressed women, in clean white gowns 
and smart bonnets, walking along the public road without shoes or stockings; they were tied up in a handkerchief and carried in their hands, ready to be put 
on when they touched on the place of their destination, which perhaps was a 
fair. I did not observe this among well-dressed women in the south; but the 
north is half peopled by Scotch families, it is therefore not surprising that Scotch 
manners should prevail so much more among them. Another peculiarity which 
I observed in the dress of the women is, that, alike in the heat of summer as in 
the cold of winter, they walk about in long cloth cloaks; and that not only such 
as come absolutely under the definition of the poor, but women who rise a step 
higher in society, as inferior tradespeople and the like.


Though not coming under the description of charitable institutions, yet as an 
object of great public utility must be mentioned the Baths established within 
a few years by Sir Arthur Clarke. Too far from the Bay to obtain a supply of 
sea-water, unless by means of very expensive works, he forms, as a substitute, 
an artificial sea-water, by dissolving rock-salt in fresh water, which is said to 
be equally efficacious with the salt element itself. There are both hot and cold 
baths fitted up with the utmost neatness, and with every accommodation that 
can be wished by those who are to use them. He has also medicinal baths, 
made by imitating certain natural springs, the composition of which is well 
known. This establishment was thought to reflect so much credit on the undertaker, that it obtained him the honour of knighthood, which occasions the 
wags to give him the appellation of the Knight of the Bath, while on Lady 
Clarke,?since the publication of Mr. Walter Scott's poem,?has been conferred 
the title of the Lady of the Lake. 


---

p.46



 
Sir Arthur is by profession a surgeon, and is of great eminence. His lady 
was a Miss Owenson, sister to **Lady Morgan**. She is very musical, and possesses a singular talent, approaching to ventriloquism, of imitating in singing 
two very different voices, so that it is scarcely possible to suppose they do not 
proceed from separate performers. The first time that I was entertained with 
a specimen of this talent, was in a large party at the house of her sister **Lady Morgan**, a few days after my arrival in **Dublin**. The company were in two. 
rooms; and I happened to be engaged earnestly in conversation in the different 
room from that where the music was, when I heard, as I thought, rather an 
extraordinary kind of duet, in the form of an eclogue between a man whose 
voice was become rough from advance in years, and a squeaking little girl. I 
own this appeared to me rather an odd performance to introduce, since there 
was nothing in the singing of either party very much to amuse or gratify the 
company. How was I astonished when I found the whole to be executed by 
the same person, and that a lady whose natural voice, unlike either of the characters she assumed, is pleasing and melodious! 
Like the College of Surgeons in London, whose establishment is in the 
largest square of that large city, Lincoln's-Inn- Fields, the incorporated Surgeons 
of Dublin have theirs in the largest square of this metropolis, Stephen's Green. 
The College of Surgeons is a handsome modern building, and one of the great 
ornaments of the square. It includes a good library, a theatre for lectures, a 
dissecting-room, and a museum for anatomical curiosities. **Dublin** possesses 
men of great talents and eminence in every branch of medical science. 
There are eleven markets in this city: Ormond market, on Ormond Quay; 
Castle market, in George's street; Patrick's market, in Patrick-street; Clarendon market, in William-street; Meath market, in Hanbury-lane; and Norfolk 
market, in Great-Britain-street. These are all general markets, and are plentifully supplied with butchers' meat, poultry, fish, vegetables, fruit, &c. &c, at a 
cheaper rate than in London, particularly the fish, poultry, and eggs. Besides 
these there is the City market, in Blackhall-row, where little else is sold than 
mutton, lamb, and pork;?Fleet market, in Townsend-street, which on the contrary is principally a beef-market, and supplies the shipping;?Spitalfields market, chiefly for bacon;?Smithfield, for live cattle, hay and straw;?and lastly 


---

p.47



 
the Corn market. This is now held near the Great Canal harbour. Potatoes, 
as the staple article of food throughout **Ireland**, are of course in profusion in 
all the markets; they are much cheaper than in London: the yearly consumption in **Dublin** alone is computed at about thirty-five thousand tons. This vegetable forms no less a constant dish at the tables of the rich, than the poor; 
the only difference is, that they are served in a more luxurious way, fresh ones 
being brought in hot two or three times in the course of the dinner; they are 
always served up with the skins on. Eggs are equally a constant part of an 
Irish breakfast.




---

p.48


The River Anna Liffey — The Bridges — Carlisle Bridge — Essex Bridge — 
Sarah Bridge — Richmond Bridge. — Stephens-Green — Embellishments 
there — Shelburne House. — The Mansion-House — Equestrian Statue of 
George the First — Merrion-Square — Leinster-House — College-Green — 
Statue of William the Third — Sackville-Street — Pillar to Lord Nelson — 
Other Squares and Streets. — Catholic Priest's Funeral. — Jingles, and 
*J*aunting Cars.
#### 7


Whoever sees the river Liffey, such as it is running through **Dublin**, must 
smile at the recollection of Tickel's poem, beginning 

> 1. Of Leinster fam'd for maidens fair,
>   
> Bright Lucy was the grace;
>   
> Nor e'er did Liffey's limpid stream
>   
> Reflect a fairer face; —
> 

 
since nothing can be more black, dirty, and in every way the reverse of limpid, 
than is the complexion of these waters as they traverse the metropolis. Instead of being an ornament to the town, as a river ought to be, it is really rather a revolting sight. From what cause this may proceed I know not; but 
it should seem that it must be from very great mismanagement of some kind. 
Are no pains ever bestowed in cleaning it? or do the sewers of the town run 
into, and thus contaminate it? I know not whether either of these causes 
may have any share in the evil, but I know that the magistrates of the town 
would do well to exert their influence in having the cause thoroughly investigated, and proper remedies applied. It is generally expected that a tide river 
should be sweet and pure; that the constant ebb and flow should keep it free 
from impurities: — at any rate it should seem as if the cause might with ease be 
ascertained, and the effect remedied.


When the spot on which **Dublin** stands was first inhabited, and for a long 
series of years after, the river seems to have spread into a much wider channel, 
and the ground on each side was altogether marshy and swampy. It may, 


---

p.49



 
perhaps, be made a question whether in imbedding the river the channel may 
not have been too much confined, so that more mud accumulates than the tide 
can carry away: but still, if this be so, assistance might be given in clearing 
it by artificial means. It is by a gradual process that the river has been confined within its present limits. Three centuries ago the whole extent of ground 
from near the back of the College on to Ringsend appears to have been under 
water at the flow of the tide; to have been in fact much such another tract as 
what is now termed the North Bull. Even a century later there was a sort of 
petty harbour, where is now Townsend-street, at which passengers from England used frequently to land. At the latter period, that is two centuries ago, 
the part where now stands the Custom-house, the two Ormond Quays, and 
a considerable tract beyond on the north side of the river, was in the same predicament. The making the quays has certainly given a very handsome appearance to the town; but if it has been in any degree the occasion of the evil 
I have noticed, that much more than counterbalances the advantage. The 
walls of the quays are built of the same granite, from Bullock, that has been 
mentioned in speaking of the pier. 


The name of this river has been curiously perverted: its original appellation was the ***Auin Louiffa***, that is, in the Irish tongue, the rapid river. It 
was so called because, having its source in mountainous regions, the waters 
will sometimes, on occasion of heavy rains, come down with the rapidity of 
a mountain torrent. The **Anna Liffey** is the name by which it is now designated in public documents, though in common conversation the former part of 
the name is usually dropped, and it is called simply the Liffey. **Sir John Carr**, 
in his Stranger in Ireland, makes a very odd confusion about the course of this 
river, since he places its source only *four or five miles to the west of **Dublin**,* 
yet says that *it meanders beautifully through the whole county of Kildare.* The 
fact is, that it has its source among the **Wicklow mountains**, near a celebrated 
spot which will be noticed in its proper place, **Loch Hela**, that is, the lake of 
Hela; or, as by corruption it is now usually pronounced, **Luggelaw**. From 
thence it pursues a very winding course before it reaches **Dublin**; and in two 
spots, as will be mentioned hereafter, pours down rocks, forming fine cascades. 
It is only navigable up to the first bridge in **Dublin**; and at a very short distance 
beyond the town it becomes quite a small shallow stream, and really limpid. 




---

p.50


#### 7


It is crossed in the town by several bridges, three of which are very handsome. The first, (that is the nearest to the mouth of the river,) Carlisle-bridge, 
has only been built between twenty and thirty years: it forms the communication between two of the widest and best streets in **Dublin**, Sackville-street 
to the north, and Westmoreland-street to the south. It is two feet broader 
between the balustrades than Westminster-bridge, but is very far short of it 
in length. Essex-bridge, the next, has been built somewhat more than half 
a century: it is the perfect model in miniature of Westminster-bridge. The 
other bridges, to the last, quite at the western extremity of the town, are not 
of any note. The last was begun in the year 1791 , while the Earl of Westmoreland was Lord-lieutenant; and the first stone being laid by his countess, 
it was called after her Sarah-bridge. It is also called the Rialto of **Dublin**, 
since it consists, like that at Venice, of only one elliptical arch. The whole 
length of the bridge is 256 feet; the span of the arch is 104 feet; the breadth 
thirty-eight, and the key-stone is twenty-two feet above high-water. It is indeed 
a beautiful piece of architecture. A new bridge is planned directly opposite the 
Four-Courts, to be called (after the duke of Richmond) Richmond-bridge: but 
this is not yet begun; and indeed there seems no great object to be attained in 
making a more immediate communication with a part of the town occupied only 
by the poorer class of the community, since there is no probability of much intercourse ever being carried on between them and the highest courts of law. 


Both to the north and to the south such vast additions have of late years 
been made to the city, that they may almost be called new towns. The largest 
square in **Dublin** has the appellation of Stephen's Green. It is somewhat 
singular, that among the Irish, of whom three-fourths may probably, upon 
a moderate computation, be considered as adhering to the Catholic persuasion, — a religion abounding so much with saints, that not only does it furnish 
one for every day in the year, but, if any thing occasions one to be degraded 
from his station in the calendar, there is always another ready to supply his 
place, — it is rather extraordinary, that, among a people adhering so much to 
a religion thus abounding with saints, when the names of these saints are applied to a street or a square, they are deprived of their sanctity. Thus instead of 
Saint Stephen's Green, as might be expected, this square is simply called Stephen's-green: and we hear of Patrick's street, Mary's street, George's street, &c. 


---

p.51



 
without the Saint being ever prefixed to them. It is even common enough to 
hear the churches called only Patrick's, George's, Mary's, &c. 


The area of Stephen's-green is larger than that of any square in London: 
it is really a square, and is considered as a quarter of an English mile every 
way. On my first arrival in **Dublin**, the centre was a green enclosed round 
with a live hedge, without which was a ditch; and between that and the road 
round the square was a row of very fine elms. This was in July 1814. The 
twelfth of August, the centenary of the Hanover accession to the British 
throne, was to be celebrated with great rejoicings, one part of which was a display of fire-works on Stephen's-green. Having been absent from **Dublin** upon 
a visit into the country, from the sixth to the tenth, at my return I observed 
a most lamentable and sacrilegious havoc which had been made among these 
trees; they had been stripped almost naked to the trunks, that the fireworks 
might be the better seen from the houses. To the credit of some of the inhabitants of the square it must be said, that there were persons who highly 
disapproved of the sacrilege, and remonstrated against it: but the order came 
from authority, and disobedience was not to be thought of. 


The following year, when I revisited **Dublin**, not a tree was left standing. 
A plan was then almost completed for the improvement and embellishment of 
the square; the first part of which was to deprive it of its greatest embellishment, these fine trees. I could almost call this an Irish way of embellishing. 
Thus much, however, must be confessed, that, such as they had been made in 
honour of the former twelfth of August, they had almost ceased to be ornamental. For the rest, the square was certainly exceedingly improved; the hedge 
was removed, and the ditch filled up; while instead of them the green was to 
be inclosed with a handsome iron pallisade, and to be laid out with walks and 
shrubberies after the manner of the squares in London: — still I must think that 
the trees, such as they were when I first saw them, would have given great additional beauty to the whole. There are many very good houses in this square. 
On the north side, at the corner of Kildare-street, is Shelburne-house, now 
a scene of ruins. In its prosperity it was a venerable pile of building; but as 
an excellent preparatory step to its utter desolation, it had been for some years 
converted into barracks. Near the Green, in Dawson-street, is the Mansion-house, the residence of the Lord-mayor. The house itself would scarcely attract 


---

p.52



 
notice; but the eye is irresistibly caught by an equestrian statue of George the First, which stands in the garden, so close to the wall next the street, with the 
head towards the street, that it appears as if stationed there to furnish His Majesty with all the amusement that could be contrived, in looking over the wall 
at the passers-by. This statue was originally placed on Essex-bridge: why it 
was transferred to the very odd situation in which it now stands I do not 
know. In the middle of Stephen's-green is an equestrian statue in brass of 
**King George the Second**. 
Near Stephen's-green is Merrion-square, a large area about the dimensions, 
or perhaps even larger than Portman-square in London. It is modern, and 
handsomely built: the centre is inclosed with an iron palisade, within which 
shrubs are planted, and beyond them is a gravel walk; the remainder should 
be a lawn, but when I first saw it the grass had just been cut down for hay. 
The west side is entirely occupied by the back of Leinster-house and the 
grounds belonging to it. Here again I must observe that in England such a 
piece of ground would be a fine velvet lawn; in the present instance it was a 
field where cows and horses were feeding, to which might have been added donkeys, since in one part there was a right noble grove of thistles. 


Leinster-house was, as the name imports, the town-residence of the Duke 
of Leinster, now the only duke in **Ireland**. Is it not rather a reflection upon 
the first nobleman of the country, the only one of so high a rank, that he 
should alienate the town-residence of his ancestors, transferring to another 
country the advantages that accrue to tradespeople, mechanics, and others, 
from having a large fortune spent among them — True, the duke keeps up an 
establishment at his country-residence in the county of Kildare — But ought not 
a person of his high distinction to consider it almost as a duty to let the metropolis also be benefited by a part of his fortune being spent there? The 
front of Leinster-house is in Kildare-street; it is a fine building within a court, 
which is entered by a very handsome gateway. I have mentioned elsewhere 
that the premises were purchased by the **Dublin Society**, where their establishment will undoubtedly be carried on upon a very splendid scale. 


Not far from either of the above-mentioned squares, a new one is begun 
called Fitzwilliam-square; the ground laid out for it is not large, and but a 
small part is as yet built. These are all on the south side of the river. In 


---

p.53



 
the same quarter a great many new streets are laid out; some are in considerable forwardness, others still but in embryo.


College Green, though not properly a square, is a handsome area, and comprises within it two of the finest buildings in the city, the College and the Bank. 
In the middle is an equestrian statue in brass of King William the Third, which 
was erected by the citizens in memorial of their deliverance from the tyranny of 
James the Second. It stands upon a marble pedestal, on which is the following inscription: 

> 
> Gulielmo Tertio,
>   
>  
> Magnae Brittanniae, Franciae et Hiberniae 
>   
>  
> Regi, 
>   
>  
> Ob Religionem Conservatam, 
>   
>  
> Restitutas Leges, 
>   
>  
> Libertatem Assertam, 
>   
>  
> Cives Dublinienses hanc Statuam posuere. 
> 
> 
> 




It was finished in the year 1701; and on the first of July that year, the anniversary of the victory at the **Boyne**, a commemoration of that event was celebrated with great rejoicings round the statue. Ever since, till within a few 
years, the first of July and the fourth of November (King William's birthday) were always in like manner celebrated; but latterly, as the memory of 
that illustrious monarch has grown somewhat out of fashion, less zeal has 
been shown in doing honour to it. The statue is, however, as I understood, 
on these days still dressed in an orange mantle, and decorated with orange ribbands, at the expense of the Corporation; but not with love and from the heart as formerly. Different times, different manners. 


From this Green runs Westmoreland-street down to Carlisle-bridge, over 
which is Sackville-street. This is the most spacious street in **Dublin**, and is a 
hundred-and-twenty feet wide. I believe there are none wider in London, not 
even Portland-place: but I judge only by my own eye, for I do not know the 
width of the latter. Be this as it may, I can safely venture to say that Portland-place in London, Sackville-street in **Dublin**, and the Canebiere at Marseilles, are the three widest streets I have any where seen, and I should think 
all nearly of an equal width. A mall formerly ran down the middle of Sackville-street, which within a few years has been removed, and the whole laid 
open. About the centre stands a lofty fluted column, rising from a square pedestal, 


---

p.54



 
 erected in honour of Lord Nelson, a statue of whom finishes the column. Round the statue is a gallery, to which a winding staircase within, as in 
the Monument of London, leads up. The whole height of the pillar from the 
ground to the top of the figure is 144 feet; from the gallery to the top is 30 
feet; the figure is thirteen feet high. From the gallery is the best view any 
where to be obtained over the city and the bay. At the end of this street are 
seen the Rotunda and the Lying-in Hospital, but in an oblique direction, not 
exactly as the termination of it. Beyond is Rutland-square, and ascending 
further Mountjoy-square, with a great number of new streets, like those to the 
south, some nearly completed, others as yet very straggling and unfinished. The 
town is well paved, with trottoirs for foot-passengers, and tolerably well lighted.


It was walking down Sackville-street one day with some friends, that we saw 
a great crowd coming over Carlisle-bridge: we stopped to inquire at a shop 
what was the occasion of it, when we were informed that it was the funeral of 
a Catholic priest, going out of town to the place of interment about four miles 
off: the master of the shop added very civilly, that we might perhaps be incommoded by the crowd if we attempted to proceed on our way, and if we would 
walk up into his drawing-room we should have a better view of the procession. 
This obliging offer we thankfully accepted, and indeed it would scarcely have 
been possible to have crossed the bridge till the crowd was gone by. An immense concourse of people walking two-and-two, wearing white linen scarfs 
and hatbands, preceded and followed the hearse; after them came a long train 
of carriages, coaches, and chariots, and last of all an almost equally long train 
of jaunting-cars and jingles. The priest was a man extremely beloved among 
his flock, and they had united to do honour to his memory by making this splendid funeral. The persons walking and riding in the procession could scarcely 
be less than five hundred, and a vast concourse of people besides kept company 
with them. 


It has been mentioned that the philanthropic **Mr. Prior**, for the promotion of 
the linen manufactory, procured a regulation that no other material but Irish 
linen should be used for scarfs and hatbands at funerals; and among the undertakers it is a regulation that each scarf and hatband shall contain linen sufficient to make a shirt and a cravat; so that the quantity used on this occasion 
must have been far from inconsiderable. Not that the whole company attending 


---

p.55



 
had them, only those who walked — they were the proper bidden guests; the 
carriages were filled with persons going unbidden, merely for the sake of doing 
honour to their pastor; but the walkers must have been from two to three hundred.


Having again mentioned jaunting-cars and jingles, I must no longer omit to 
say a few words upon these carriages. They were for a long time peculiar to 
**Ireland**, though the jaunting-cars are now much introduced into England, particularly the inside ones; for it must be observed there are two species of these 
cars. Both kinds are two-wheeled open carriages drawn by one horse. The inside 
cars hold four, or sometimes six are crammed in, sitting sideways, and the driver 
has a seat in front. The outside cars have a space down the middle for holding 
packages of any kind, at the extremity of which is a sort of little dickey for 
the driver, and on each side is a seat for the company, who thus sit back to 
back with their feet at the outside of the carriage; the wheels are underneath 
the seats. These vehicles, from the position in which the company sit with regard to each other, are called by the saucy English, Irish vis-à-vis's. Many 
persons object to them on account of alleged danger of the feet being hurt by 
other carriages as they pass: for my own part I have travelled many and many 
a mile in one, and never could find the force of this objection. When first we 
landed, my friend Mr. C ..., who was with me, turned up his nose, — if I 
may be allowed the use of so familiar a phrase, but I know of no other equally 
expressive for such an occasion, — he turned up his nose, and said, *I am sure 
you shall never catch me in such a heathenish kind of vehicle.* — But again I say, 
*When we are at Rome, we must do as they do at Rome.* — We had not been a week 
at **Dublin** before he mounted one with as much complacency as if he had been trained to it all his life. 


A jingle is a four-wheeled carriage, with one horse and a body like a sociable, 
to which is affixed in front a little seat for the driver; 
 — not, however, calculated 
to hold one of the dimensions of Daniel Lambert: I have seen some so diminutive that I wondered how any driver could contrive to rest upon it at all. 
These carriages are not in general particularly well hung, so that in going they 
make a clattering kind of noise, to which they owe their name.




---

p.56


**Mr. Kean**, and his first Appearance on the Dublin Stage — Remarks on the 
comparative Merit of this Gentleman and Mr. Kemble — The Theatre in 
Crow-Street — Some Particulars of the Rise and Progress of the Irish 
Stage — Other Theatres — Government Nights.
#### 8


When I first reached **Dublin** I found the town big with expectation of the 
arrival of that extraordinary meteor which had then recently risen in the theatrical hemisphere, **Mr. Kean**. With the powerful talents of this gentleman 
I was already well acquainted. I cannot absolutely say that I had seen and 
admired them from the first moment of his appearance in London; but I can 
assume to myself the credit of having early learned to feel and confess the 
wonderful magic of his genius. Tis true that the voice of Fame had loudly 
preceded his appearance in the metropolis: — we were told that we were to expect a star of no common brilliance. But we had been so often called upon to 
admire stars by anticipation, which, when seen, far from shining with the dazzling 
splendour of a Jupiter, scarcely beamed with even the puny lustre of the remotest planet in our system, — this tune had been played so often, that the notes 
now passed almost unheeded, or were heeded only to be ridiculed. Thus in 
the present instance, though I heard the sounds of the well-known trumpet, 
I was not disposed to be led by them; nor thought of attending the first appearance of the new phenomenon. Nay, if I must confess the truth, I even 
asked with something like a sneer, of a gentleman who I knew was then to 
be at the theatre — a person of whose taste and judgement I had a high opinion; 
" Well, what say you to the blazing comet with which we are all to be so much 
dazzled?" — "I say," he replied, "by all means go to the theatre the very 
next time he appears, for I will venture to affirm that you can never have 
seen such a performer; there has certainly been none in your days in any 
way to be compared with him."


This satisfied me; — I well knew my gentleman to be a nice critic in theatrical matters, more disposed to being over-fastidious than too easily pleased 


---

p.57



 
and I felt assured that such commendation would not be bestowed by him but 
upon merit of a very superior kind. I accordingly attended **Mr. Kean**'s second appearance, and only regretted that my scepticism had deprived me of so 
much gratification as would have been afforded by seeing him on the first. 
From that moment I have never missed attending the theatre on his appearance in any new character, and in most that he has performed I have seen 
him repeatedly and repeatedly; while, far from finding the enchantment created 
by his talents diminish on repetition, I can truly say that every time I see him 
it is with increased pleasure. 


Thus, notwithstanding the ardour with which I had followed him through 
his first campaign in London, it was not among the least objects of gratification to which I looked forward in my visit to **Dublin**, that I was to see him 
again there. I had besides been so fortunate as to become personally acquainted with him and his excellent and amiable wife, and was happy in the 
opportunity afforded, by meeting in a new country, of improving and increasing our acquaintance. They arrived a few days after me, and I had soon the 
pleasure of seeing **Mr. Kean** make his début upon the Dublin stage in his 
favourite character of King Richard the Third. I never saw a more crowded 
house, or an audience among whom expectation might more truly be said to 
be on the tiptoe.


**Mr. Kean**'s situation was an arduous one. Mr. Kemble had been a frequent performer at **Dublin**, and was a great favourite there; he was even in 
some sort a child of that theatre, since it was from thence he came to assume 
the high station he so long maintained on the London boards. I would by no 
means wish to depreciate the talents, or detract from the well-earned fame, of 
any man; but while I always felt that great merit must be allowed Mr. 
Kemble, I equally felt that there was a something wanting to constitute him 
a finished performer, and that something appears to me strikingly conspicuous 
in **Mr. Kean**. Mr. Kemble's is undoubtedly fine acting; yet it is but acting: 
it is impossible to lose for a moment the idea that it is Mr. Kemble we 
see; — we can never be deluded into fancying that we have really before us 
Hamlet, Othello, Richard: we have only Mr. Kemble's ideas, finely painted 
'tis true, of what **Shakespeare** designed in drawing those characters: — whereas 
such is the identification thrown by **Mr. Kean** into whatever he performs, that 


---

p.58



 
we can scarcely persuade ourselves it is acting. In short, to me it appears 
that the difference between the two performers may be summed up in few words — Mr. Kemble acts the character, **Mr. Kean** is the character.


If an anecdote recorded of Mr. Kemble be true, — and I have reason to think 
that it comes from good authority, — he himself strongly feels the art **Mr. Kean** 
possesses in so wonderful a degree of identifying himself with the character assumed — Mr. Kemble, having been present at **Mr. Kean**'s performance of Richard 
the Third, was asked by one who met him coming out of the theatre when the play was over: "Well, sir, how did you like **Mr. Kean**?" — to which he replied — "I did not see **Mr. Kean** at all, I saw only Richard." I relate this because if true, as I believe it to be, it reflects equal honour upon him who said 
it, and him of whom it was said. 


Waving the question, however, of the comparative merits of these two performers, thus much is certain, that their style of acting is almost as opposite the 
one to the other, as light is to darkness; consequently that where the one had 
been very greatly the object of admiration, the other had a formidable dike to 
bear down before he could hope to please. But though art may have her votaries, and the mind may awhile be dazzled with the factitious splendour she 
can find the means of throwing around her, nature must and will in the end 
prevail. The illuminated ball-room is grand, shows magnificent in the absence 
of the sun; but let the bright beams of that resplendent orb once intrude, farewell to the glitter of these artificial aims at splendour! they are vanished, thrown 
into eclipse in a moment. While numbers at **Mr. Kean**'s first appearance in 
London bestowed all due admiration on his talents, the rigid votaries of art, 
half-astonished, half-dismayed, hung back as doubtful whether they could be 
justified in admiring pure nature alone. At length, however, almost all who 
were not too proud to recant, felt the force of nature too powerfully not to confess that the actor who follows that unerring guide, and that alone, must bear the 
palm from him who looks to the meretricious form of art as his polar star. 


Not very different was the case at **Dublin**. That such talents should not 
make a powerful impression was impossible: yet so different was what the audience now saw, from what they had long been accustomed to admire, that even 
when strong bursts of applause were irresistibly drawn from them, they seemed, after the moment of enthusiasm had subsided, ready to question their own 


---

p.59



 
feelings, and half to wish that the applause could he retracted. But ere many 
nights had passed, the question was fully decided. In **Dublin**, as in London, 
some few of those who are determined not to be convinced, — and spirits of that 
description are of the growth of every country, though I never knew but one 
man openly profess it: — he, in a warm political dispute, when his antagonist 
said: "Only hear me, sir, and I will soon convince you," replied, "Sir, I won't 
be convinced." — Too many I fear there are every where who won't be convinced, though they are afraid to own such a feeling even to themselves: and 
such made the notable discovery that **Mr. Kean** never could be as good an 
actor as Mr. Kemble, because he was not so tall. But all who were ready to 
yield to conviction, soon felt powerfully that if once they thought they had 
seen the perfection of acting, they were now assured of it, and his popularity 
became as great in the metropolis of **Ireland** as it had been in that of England. 
Among no description of persons was this conversion more striking, than 
among the College students. Mr. Kemble had been so much with them the 
criterion of all that was excellent in his art, that, knowing from the voice of 
Fame they were now to see something very different, they went exceedingly disposed to censure, but they remained to applaud — they became some of Mr. Kean's most enthusiastic admirers.


I have now at different times and in different places seen this accomplished 
actor play twenty-two different characters; — twenty in London, and two others 
at **Dublin**. Among so many, some must have a decided preference over others, 
but I think it may truly be said that the most arduous are those in which he 
most excels. The more strongly the characters are drawn, the higher wrought 
are the feelings and passions, so much the finer is his representation of them. 
Richard the Third was generally considered as his masterpiece till he played 
Sir Giles Overreach; this is now thought to dispute the palm with Richard. 
For my own part, finely as I think both these characters played, there are 
others which afford me still higher gratification; not perhaps that the playing 
is intrinsically superior, but that the characters speak so much more forcibly to 
the heart and feelings. If I were to select that which of all others appears to 
me the most surprising effort of genius, I should say it is Othello. I do not 
indeed conceive it possible for acting to be carried beyond **Mr. Kean**'s performance in the third act, when Iago is working the noble generous nature of 


---

p.60



 
the Moor into a phrensy of jealousy. Every feature of the countenance, every 
muscle, every limb display the extremity of agony; — the working of the fingers 
is agony, the quivering of the lip is agony; not an atom of the whole frame but 
seems agonized almost beyond what human nature is capable of sustaining: it 
is scarcely possible to convince oneself that what appears such true nature is 
but assumed. By some persons it is objected that **Mr. Kean** wants height for 
this character: — In the great warrior, they say, in the noble Moor, we expect a 
tall, majestic, commanding figure. But let the annals of history both ancient 
and modern be searched, we shall find that a large majority of the most celebrated warriors have been little men: and let the tragedy of Othello be attentively examined, we shall find the author making his hero say,
  

*I've known the time when with this little arm 
  
 
And this good sword, &c.’’*

Adapted from Othello 5.2.

 
every where, besides, carefully impressing upon the reader that there was nothing in Othello's person to charm, but the reverse, — that it was by his mind 
alone Desdemona was captivated: — we shall find too wherever he is called the 
noble Moor, that quality applied solely to his disposition, his noble nature, never to his figure. One of **Mr. Kean**'s very striking excellencies in this character 
is, that all his actions, all his gestures are truly Moorish, differing wholly from 
his action in other characters. He never throughout gives the idea of an European made up to represent a Moor, as is too palpably the case with most who 
attempt the character; he appears truly a native of another clime.


If, however, I would give the first place to Othello, there are two other of 
**Mr. Kean**'s performances which I must rank very, very, little below it, — Hamlet and Richard the Second. If the former be not generally esteemed one of his 
most successful efforts, I cannot the less think it so. The exquisite, the almost 
morbid sensibility of the character, — the deep affection, respect, veneration, 
almost adoration in which he holds his father's memory, increased in proportion 
to the slights he sees shown to it by others, and the suspicions hovering about 
his mind, he scarcely knows himself on what founded, that this revered father 
did not come fairly by his end, — his high-wrought moral feelings insupportably 
wounded, at the violation of moral principle he is witnessing, and that in one 
so deeply interesting to him as his own mother, — of these feelings, all resulting 


---

p.61



 
from the utmost purity of soul, the utmost refinement of manners, I can 
scarcely conceive it possible for a more finished portrait to be given. It is not 
however strange that a diversity of opinions should prevail on **Mr. Kean**'s 
performance of this character, since scarcely any two persons are exactly agreed 
upon what **Shakespeare** intended the character of Hamlet to be. Those who 
take the same view of it that **Mr. Kean** does, will of course admire his personation of it; while those who view it in a different light, will find many things 
they do not approve; — the question then remains, which takes the most just view. 


Long as the play of Richard the Second had lain upon the shelf, wholly neglected and disregarded, it may almost be called a part of **Mr. Kean**'s own creating, as much as if it had been a new piece. The character of Richard, such 
as it is described in history, is so perfectly contemptible, that we are altogether 
astonished to find it possible for the utmost sympathy and compassion towards 
him to be excited; — yet such is the case. The sublime sadness of the deposed 
monarch, his pathetic reflections upon his own fallen state, depicted as they are 
by **Mr. Kean**, strike to the very soul. Indeed I think the latter half of this play 
has a just claim to be classed among the most extraordinary proofs of genius he 
has given. That it has not become as universal a favourite as Richard the 
Third, can only be accounted for from the former part of the play being heavy 
and dragging, and that there is too long an interval when the principal character, 
the soul of the piece, does not appear on the stage. 


In the strong passions **Mr. Kean** is grand, astonishing — in the last scene of 
Sir Giles Overreach he is almost terrifying: but, in my opinion, the still more 
beautiful parts of his acting are his exquisite touches of nature and feeling. By 
these the heart is dissolved; in these the pathetic tones of his voice, than which 
nothing can be finer, give him every possible support: from want of power he 
fails in voice sometimes, where long and violent exertion is required; and this 
gives many people the mistaken idea that his voice is bad. It is not so essentially; it may occasionally be rendered so by circumstances.[5](javascript:footNote('E810001-001/note005.html')) — — However, this 


---

p.62



 
is scarcely the proper place to enter upon a critical examination of **Mr. Kean**'s 
performances; and, with an apology for the digression, I close it.


The Crow-street Theatre is a very shabby-looking building on the outside, 
and stands in the midst of so many wretched dirty lanes that there is no good 
access to it any way. Within, it is handsomely fitted up with a profusion of 
paintings: — on the ceiling is Hibernia protected by Jupiter and crowned by 
Mars, with Mercury attending; near Hibernia is a figure representing Industry. Round the boxes are paintings, chiefly subjects from the works of 
Homer and from Telemachus. But paintings of this description are not well 
suited to decorations for a theatre; the lights are unfavourably disposed for 
showing them, while by a sort of reaction the dark shades indispensable in 
them absorbing the light, cast a gloom around which not any power of light 
can dispel. The Theatre is, besides, not a good one for hearing; it has too 
many angles, which break the sound of the voice. Notwithstanding that the 
size of Drury Lane is complained of, as such that it is scarcely possible for any 
performer to be well seen or heard, yet I must say that I have always heard 
**Mr. Kean** better there, from the superior manner of its construction, than in 
smaller theatres constructed less scientifically: — fine acting will always appear 
to greater advantage in a large theatre, where there is ample scope to give it 
entire effect; 
genius is cramped by not having sufficient space to display itself.


Though at present a great fondness for dramatic representations prevails 
among the Irish, it does not appear that it was a very early taste in the country; it has arisen within the last two centuries. The annals of the city mention 
the performance of some plays in the time of Henry the Eighth upon Hoggin 
Green, now College Green; but nothing is said of the nature of them: and 
it is likely they were no more than the mysteries or moralities about that period 


---

p.63



 
much in vogue in England. No tradition is extant of any dramatic entertainments in **Dublin** from that time till the year 1601, when the play of Gorboduc 
was performed at the Castle in honour of **Queen Elizabeth**'s birth-day. This 
play is said to have been a great favourite with Her Majesty; it had been represented before her at Whitehall by the gentlemen of the Inner Temple some 
time before the sun of **Shakespeare** rose in the theatrical horizon.


It is worthy of remark, that great as was the passion of the ancient Irish for 
poetry, there is nothing amid all the fragments remaining of the productions of 
their bards like an attempt at a dramatic composition. Content to sing the 
praises of their heroes, they thought not of representing their great deeds by 
action; though this is indisputably a far more forcible means of exciting the 
feelings and rousing the soul to emulate the glories celebrated. But dramatic 
representations seem only to arise out of a considerable advance in civilization 
we never find them introduced in the early and barbarous ages of any country 
such at least as depend on dialogue, and have for their object rather a delineation of the passions than the actions of mankind, or giving the actions only 
as exemplifications of the passions. As far as mere action goes, we certainly 
do find in the dances of savage nations a sort of pantomimic representations of 
their battles and other events. 


There is no account of any regular theatre established in **Dublin** earlier than 
the year 1635. One was then built in Werburgh-street, and the undertaking 
was carried on by John Ogilby, Esq. historiographer to the king, and master 
of the revels under the Earl of Stafford, then Lord-lieutenant of **Ireland**. Here 
were produced two new plays, by natives of the country, The Royal Master, 
acted in 1638, the author of which was Mr. Shirley, an intimate friend of Mr. 
Ogilby the manager; and Langartha, written by Henry Burnell, Esq. Neither 
possessed sufficient merit to be handed down to posterity; I believe the names 
alone are all that remain of them now extant. Langartha was taken from the 
Danish History of Saxo Grammaticus; it was introduced with a prologue spoken 
by an Amazon armed with a battle-axe, pleading in this martial array for the candour of the audience, which, if not granted freely, she seemed prepared to seize 
vi et armis. It is supposed that this was one of the pieces at which the Duke of Buckingham's satire was particularly levelled, in his prologue of Thunder and Lightning to The Rehearsal. 




---

p.64


#### 8


In the Great Rebellion, which broke out shortly after, the theatre, which had 
begun to assume a very flourishing aspect, suffered in common with the rest of 
the country; it was shut up by order of the Lords Justices, and never more 
opened. Mr. Ogilby, after experiencing much ill-fortune, went to England, 
where he remained till the restoration of Charles the Second, when, through the 
intervention of his friends, he obtained a patent for building a new theatre in 
Smock-alley, then called Orange-street. Two tragedies, translated from Corneille by **Mrs. Catherine Phillips**, Pompey the Great and The Horatii, were 
performed here, both of which were afterwards brought upon the London stage, 
but not during the life of the translator. She died in 1664. 


This theatre was run up in such haste, that before the end of the year in 
which the patent was dated, 1662, we find it opened. In consequence, it was 
very slightly constructed, and only nine years after a part fell down during the 
time of performance. This accident, by which two persons lost their lives, 
occasioned another cessation of dramatic exhibitions, which was prolonged by 
the times of trouble that preceded the Revolution. Not till after that great 
event do we find any notice of their being resumed; but among the public rejoicings by which it was to be celebrated, the representation of a play was resolved on. As the regular actors had been so long dispersed, and could not 
be hastily re-assembled, a number of gentlemen, most of them persons in office 
about the Castle, agreed to take it upon themselves, and the tragedy of Othello was fixed on as the performance. 


The most remarkable circumstance attending this revival of the drama was, 
that it was the occasion of first bringing the talents of Wilks before the public. 
That great performer then appeared only as an amateur; but he gained such 
applause in his representation of Othello, that he determined to abandon his 
former pursuits, and devote himself to the stage. 


A taste for the drama being thus rekindled, the patent which Mr. Ogilby had enjoyed (he having now been long dead) was obtained by Mr. Ashbury, under whose 
management the theatre flourished exceedingly for several years. He opened it in 
1692 with Othello, the principal character, performed by Wilks. Some other performers, afterwards of great eminence on the London boards, also commenced 
their career under Mr. Ashbury's management, as Booth and Quin. He was 
himself respectable as an actor; but his reputation was higher as a critic and instructor. 


---

p.65



 
Such was the opinion entertained of him in the latter capacity, that 
he was honoured with having the Princess, afterwards Queen Anne, as his pupil, 
when she was studying the part of Semandra, in Mithridates King of Pontus, in 
which she was to perform with persons of the first rank and distinction at the 
Banqueting-house, Whitehall. 


The greatest interruption experienced by Mr. Ashbury during his management was from an accident which happened in 1701. **Shadwell**'s Libertine 
was to be performed for the first time; and, being a holiday, the house was 
uncommonly crowded, so that unfortunately the gallery gave way: no lives 
were lost, but many people were much hurt in crowding to get out. The play 
being very licentious, improper to have been produced upon the stage, the people, who are commonly much addicted to superstition, — and who at this period, 
from the troubles through which the British empire had passed during so many 
years, were more particularly so, — asserted that the accident was a judgement 
alike upon the manager for suffering such a play to be represented, and upon 
the audience for going to see it. Some even asserted that the lights burned blue 
the whole evening; while others observed an extraordinary figure more than 
once among the dancers, beneath whose disguise the cloven foot was plainly to 
be discerned; and they were confident that with this foot a little kick had been 
given to the gallery, which occasioned all the mischief. The effect of these superstitions was, that the theatre remained for some time almost deserted; while 
the play was so universally reprobated that no attempt was made for twenty 
years to introduce it again upon the stage; even then so much disapprobation 
was shown that it was soon laid aside, and no subsequent essay ever made to 
bring it forward. The only subject of regret in its suppression is, that it was 
a superstitious, not a moral feeling which occasioned it: thus much may, however, be said, that the very superstition had its origin in a sentiment of morality and religion, shocked at the immoral scenes represented: — it was a great 
reflection upon the manager ever to suffer the representation of such a piece. 
Upon the death of Mr. Ashbury in 1720 the management devolved upon Mr. 
Elrington, who had married his daughter. 


The theatre in Smock-alley appears to have reigned without a rival till the 
year 1727, when a theatrical booth was opened by a foreigner, Madame Violante, for tumbling, rope-dancing, and other *performances* of a similar description. 


---

p.66



 
This booth was erected upon a spot which touches on the ground 
where now stands the Crow-street theatre. The tumblers were much followed 
at first; but the novelty over, they ceased to please, and our adventuress then 
converted her booth into a theatre for acting plays and farces. But not finding 
the company she had collected attractive, she adopted a new idea, and assembled a troop of children, none exceeding ten years of age. The first piece 
performed by them was the Beggar's Opera, then in the zenith of its popularity 
in London; and being now for the first time brought forward in **Dublin**, between the novelty of the performance and the performers, who went through 
their parts in a manner that excited universal astonishment, the houses were for 
a considerable time uncommonly crowded. Here the celebrated **Mrs. Woffington** first made her appearance in a character for which she was afterwards 
eminently distinguished — Polly.


After a successful career of some years, Madame Violante, beginning to find 
her reputation, and consequently her profits, on the decline, sold her theatre to 
three of her young élèves; and they, being joined by some other young performers, kept it open for a short time, not being gainers either on the score of 
fame or emolument; and had they not been suppressed compulsorily, would 
probably soon have been obliged to abandon their scheme. The proprietors 
of the Smock-alley theatre, alarmed at the idea of a rival, could not wait the 
natural death to which it was hastening, but petitioned the Lord-mayor to issue 
his anathemas against the performances; and His Lordship obligingly complied, 
without giving the matter a moment's consideration. 


Though these repeated unsuccessful attempts proved incontrovertibly that 
Dublin was not able to support two theatres, yet the very means taken by 
Smock-alley to disencumber herself from one rival, was the occasion of raising 
her up a more powerful one on its ruins. So much were people offended at 
the interference of the judiciary power in a matter of public amusement, and so 
warmly had their sense of the indignity been expressed, that some adventurous 
spirits were encouraged to undertake the building of another theatre, in full confidence that the indignation which had hitherto been unavoidably confined to 
empty words, would joyfully embrace such an opportunity of making itself 
felt more forcibly. Rainsford-street was the place fixed on for this new erection. It was indeed liable to objection as a remote and inconvenient spot, 


---

p.67



 
being quite at the western extremity of the town: but it was chosen because, 
being in the Earl of Meath's liberty, it was out of the Lord-mayor's jurisdiction, 
consequently secure from the fate to which the other had fallen a victim. This 
theatre was opened the latter end of 1732 or beginning of 1733, under the 
management of a Mr. Husband. 


Mr. Elrington did not long enjoy the sovereignty of the Smock-alley theatre, 
which had devolved to him upon the death of his father-in-law: he died in 1732, 
being only forty-four years of age. Before his death the theatre, slightly built at 
first, appeared falling exceedingly to decay; and he had projected the building 
a new one in Aungier-street. He was even consulting with an architect upon 
the subject when he was seized with the first symptoms of his last illness, a malignant fever. His intentions being known, at his death a number of noblemen 
and gentlemen of the first distinction for fortune, talents, and learning, strongly 
impressed with the importance and utility of a well-conducted theatre, entered 
into a subscription for prosecuting the plan. A large piece of ground in Longford-street, adjoining to Aungier-street, was purchased; and not the first stone alone 
but the first four stones were laid with great ceremony in May 1733 by four of 
the principal subscribers. Under each stone were deposited medals struck for 
the occasion: a prodigious concourse of people was assembled; and a flourish 
of drums and trumpets, accompanied with the acclamations of the multitude, 
announced the laying of each stone. An elegant dinner for the company, with 
plenty of beer for the workmen and populace, concluded the ceremony. 


So great was the expedition with which this building was constructed, under 
the superintendance of its noble projectors, that it was completely finished in 
ten months, and was opened with the comedy of The Recruiting Officer in 
March 1734. Never was public expectation raised higher than on this occasion. The proprietors and conductors were noblemen and gentlemen of the 
first rank and distinction in the country; they had agreed to take the supreme 
direction of every thing upon themselves, actuated by no views of private advantage or emolument, but solely by public spirit; for no part of the profit 
was to be theirs, all was to be devoted to the public service. A committee 
was to be chosen, who were to meet once a week for regulating the business 
of the theatre, and settling the pieces to be played the ensuing week. In the 
choice of the pieces represented they were to be particularly select; none but 


---

p.68



 
those of the most decided merit and unexceptionable morality were to be admitted, whether of new productions or from among the old stock pieces; — every 
thing, in short, was to be expected that taste and judgement could direct for 
the advantage of the theatre; and under omens so auspicious nothing but the 
most complete success was looked for. 


Alas! how often does it happen in worldly affairs, that projects which seem 
commenced under the most favourable auspices terminate in disappointment 
while others, over which no sun appears to shed its benignant influence, but 
dark and lowering clouds prognosticate overwhelming evils, resist the menaced 
storm, till the clouds dispersing and clearing away, all terminates in prosperity 
and sunshine! By what extraordinary fatality it happened never could be thoroughly understood; but, flattering as these prospects appeared, not one promise held out was realized. In the first place, sad experience showed that the 
architect employed in the building was wholly incompetent to the undertaking; 
for the house was eminently defective in the two most essential points — the 
audience could neither see nor hear. Another mistake was, that the committee 
appointed a person to act under them as manager, who was almost unacquainted 
with theatrical affairs; — a gentleman, Mr. Swan, who might be a very good 
gentleman, but who showed himself wholly devoid of capacity as manager of 
a theatre. Mr. Swan was exceedingly fond of the drama, and had been an 
amateur performer; but it was soon evident that something more than mere 
love of the drama was requisite to fill with credit to himself, and advantage to 
the theatre, the arduous office he had undertaken. Even the taste and refinement of the committee began to be called in question, when they were found 
opening the theatre with a play which involves so little of either as The Recruiting Officer.


Here was for a while an end of the Smock-alley theatre. The rivals in Aungier- and Rainsford-street pursued their careers with unvaried emulation and 
varied success. The Aungier-street managers got up Henry the Eighth (with 
the coronation) in a style of splendour never before seen on the Irish stage. 
The Rainsford-street company answered this by producing The Beggars' Bush of Beaumont and Fletcher, under the title of The Royal Merchant, or Beggars' Bush, in which a mock pageant of the coronation of King Clause threw such 
complete ridicule on the serious one in Henry the Eighth, that the latter ceased 


---

p.69



 
to attract. Thus the keen edge of the satire being blunted, King Clause also 
speedily sunk into oblivion. This was but one among many attempts which have 
failed to raise this motley production into a standard piece. 


Those who had still an interest in the Smock-alley theatre were not deterred 
by seeing how much their neighbours were engaged in a ruinous concern, from 
determining once more to tempt fortune. Reinforced by some fresh adventurers, they had the old building pulled down, and a new one which rose from 
the ruins was opened on the eleventh of December 1735. This theatre is the 
same that exists at the present day. Thus **Dublin**, which had shown itself incompetent to maintaining two theatres, was now called upon to support a third. 
As this was impossible, one at least must fall to the ground; and the *Rainsford*-street was the first to experience such a fate: — from this time it was never 
heard of more. Aungier-street and Smock-alley both kept the field for a considerable time, like the two buckets to a well, sometimes the one uppermost, 
sometimes the other, running races perpetually which could first bring out any 
piece that had acquired popularity at the London theatres; as other theatres 
have since been inspired with a noble emulation which can first bring forward 
the melo-dramatic productions of the Boulevards at Paris. At length the managers of the Smock-alley theatre, finding themselves baffled in almost all their 
efforts to attain the superiority, had recourse to the introduction of rope-dancers 
and tumblers; and though such exhibitions were considered by all persons of 
taste and judgement, by all who felt interest for the honour and credit of the 
drama, as a profanation of the boards over which the genius of **Shakespeare** 
had long presided, yet they pleased the gaping multitude, and so far answered 
the purpose designed: — while it was thought a reproach to be seen in the 
boxes, the galleries were almost broken down by the crowds that thronged to 
them. To the credit of the Aungier-street managers, they abstained here from 
entering into a competition with their antagonists; to them alone they resigned 
the glory of mingling the vaulting genius of **Shakespeare** with the vaulting of 
those whose genius lay in their heels rather than their heads. 


At length, after vainly pursuing this contest for some years, a compromise 
took place; the two companies united, and for awhile played alternately at the 
two theatres: in the end Aungier-street was finally closed, and Smock-alley for 
a long time reigned without a rival. An attempt to raise one was made in 1747 


---

p.70



 
by opening a little theatre in Capel-street, but its reign was at that period very 
transient. The time, however, was to arrive when another contest, and a more 
formidable one than ever, was to be sustained. The first embryo of the Crow-street theatre appeared in 1731, under the form of a music-hall, in which ridottos were given. After being for some years devoted only to purposes of this 
kind, in 1757 Barry and Woodward, though then in the meridian of their fame 
in London, chose to abandon the certainty they were enjoying, upon the uncertain speculation of purchasing the music-hall in Crow-street, and building a 
theatre there — a folly which they had afterwards ample reason to repent. Mr. Sheridan, who had long been proprietor of the Smock-alley theatre, offered 
to part with it to our adventurers on very moderate terms; an offer which it 
would have been wise in them to embrace, for then at least they might have 
hoped to reign with undisputed sovereignty. They chose, however, to prosecute the less prudent plan: their theatre was built, and with the foundation-stone was laid the foundation of their own ruin. It was opened in October 1758. 


A long rivalship was then maintained between the two, with varied success; 
nor till after a thousand vicissitudes, till after ruining not only its founders, but 
several other proprietors in succession, was Crow-street finally settled in its 
present pre-eminence. For a time the little theatre in Capel-street, — through 
the excessive activity of a manager, Mr. Dawson, through the intuitive tact he 
seemed to possess of discerning at one glance what would suit the public taste, 
was raised to a distinction far above what, from its diminutive size, it could ever 
be thought entitled to. Such was the ascendancy it gained, that Barry, the 
Crow-street proprietor, after running for a considerable time a losing race 
against it, was glad at length to sell his property to Mr. Dawson; and he, having attained this great object of his ambition, kicked down, without ceremony, 
the ladder by which he had risen; — Capel-street was abandoned, and once more 
sunk into obscurity. It still exists as a theatre; so does Smock-alley, and a 
small theatre in Fishamble-street, — but they are scarcely ever opened. The 
latter had its origin, like Crow-street, in a music-hall, and in that character was 
remarkable for Handel's first Oratorio being performed there in 1741; Mrs. 
Cibber sang several of the songs. There is also a theatre in Peter-street, called 
The Royal Hibernian Theatre, originally the property of Astley, and intended 


---

p.71



 
only for equestrian exercises, with the other exhibitions by which they are usually 
accompanied.


The prices of the Dublin theatre have remained the same for very near a 
century, perhaps much longer. In bills of that date we find the boxes five-and-fivepence, the pit three-and-threepence, the gallery two-and-twopence; that is, 
five, three, and two English shillings. These are the present prices, with the 
difference only that all the boxes are now the same price; the upper ones were 
then a shilling less. 


A certain sum is paid annually by Government to the manager of the Theatre Royal for performing plays on particular nights in the year; such as the King's 
and Queen's birth-days, the King's accession, and others; when the ladies are 
complimented with the freedom of the boxes: these are called Government 
plays. This custom is coeval with the first establishment of a regular theatre. 
A century back these were the most fashionable nights in the year, constantly 
attended by the Lord-lieutenant, the Court, and all the ladies of the first fashion 
and distinction. So indispensable was His Lordship's attendance considered, 
that once on occasion of celebrating King William's birth-day, when a splendid entertainment was given by the Lord-mayor, an order was sent to the 
theatre for the play not to begin till the Lord-lieutenant with the nobility and 
gentry present could leave the Mansion-house. After Woodward and Barry 
had the theatre, the Government nights, for what reason no one could tell, began to decline in fashion; and they have gradually sunk, till at present no person of fashion would on any account be then seen at the theatre.




---

p.72


**Black-rock**, and Sunday Parties to it. — **Sir Edward Newenham** and his two Daughters — Sea-Point — Villages of 
**Dunleary** and **Dalkey** — Chapel-Isod — Lucan — **Leixlip** and the Salmon Leap — Excursion to **Howth** — Battle of **Clontarf** — Family of **Lord Howth** — His Castle — The Square 
Round-Tower — New Pier at **Howth** — Projected Canal. — The Quarries — The Light-House. — **Ireland's Eye**. — Island 
of **Lambay** — Malahide — Church of Saint Doulach — The Circular Road, — The Grand Canal — The Phoenix Park.
#### 9


In the neighbourhood of **Dublin**, as of most large towns, there are a number 
of places exceedingly frequented by the citizens on parties of pleasure, particularly on Sundays; and which strangers, if they have any ambition to be 
classed among curious or inquisitive travellers, must not fail to visit. Among 
these **Black-rock** holds a high rank. This is a village on the southern shore 
of the Bay, about three miles from the east end of the city. But those who 
from the name would expect to see a sublime rock majestically beetling o'er its 
base upon the sea, would be cruelly disappointed. As at Bognor-rocks, and 
other places which might be mentioned on the English coast, these rocks are 
nothing but a few large blocks of stone in the sea, overgrown with weeds, covered at high water, though laid open at the ebb of the tide. Nor is there anything so attractive either in the place itself, or the drive to it, as to account for 
the predilection with which it is regarded by almost all the inhabitants of **Dublin**. By the inhabitants I must be understood to mean the good citizens — the 
tradespeople, mechanics, and others; for **Black-rock** is not the resort of the 
quality. During the summer, on a Sunday, the village and the road to it are 
thronged with people, as if it were a fair. Of course there are abundance of 
public-houses, where dinner, tea, and above all the beloved whiskey, are flying 
about in all directions. Such is the passion of the Dublinites for Sunday parties hither, that a woman whose circumstances were indifferent, was once holding forth to a lady, her benefactress, upon the sacrifices she made to support her 


---

p.73



 
family: — "I do assure you, madam," she said, "I hav'n't so much as been at 
**Black-rock** one Sunday this whole year." She seemed to think it the greatest 
instance of forbearance and self-denial that could be adduced. 


In this quarter are several very pretty seats of noblemen and gentlemen; one 
of which is inhabited, or was so within the last two years, by that venerable patriot **Sir Edward Newenham**, a name well known and honourably distinguished 
in the public annals of his country; if still living, it is at a very advanced age. 
Among the many pleasures which I owe to my travels in different countries, it 
has not been one of the least, that to them I am indebted for the acquaintance 
of two daughters of this gentleman's, living however very remote from each other, **Madame Folsch** of **Marseilles**, and **Mrs. Hughes** of **Hollywood**, near **Belfast**. The former I have had occasion to mention with grateful recollections in my 
 Travels in France; to the latter I shall have occasion to advert when I speak 
of the very pleasant time I passed at **Belfast**.


A much prettier spot than **Black-rock** is Sea-point, about half a mile further 
along the Bay, and commanding a beautiful view over it. Here people go in 
the summer to bathe: there is a handsome lodging-house, and hotel where sometimes balls are given. Both at this place and **Black-rock** there are a number 
of bathing-machines, as they are called; that is, the little sentry-boxes already 
noticed. At the end of Bagot-street in **Dublin**, from whence goes off the road 
to **Black-rock**, is a very large stand of jaunting-cars and jingles, which carry 
people at fixed prices to certain places in the neighbourhood. To **Black-rock** 
the fare is sixpence-halfpenny each person, that is, an English sixpence; on a 
fine Sunday they are all kept in full employ. These cars and jingles also run to 
the Pigeon-house, I believe at the same price. **Dunleary** and **Dalkey**, — the 
former a mile beyond **Black-rock**, the latter three miles further, — are much prettier villages; but being at a greater distance, are not so much frequented.


The western side of the city also furnishes a succession of places coming 
somewhat under the same description, but not of such general resort. Beyond 
Chapel-Isod, which is two miles and a half from the Castle, on the banks of the 
Liffey, for a considerable way is a succession of strawberry-gardens, whither, 
in the season, parties are made to go and eat strawberries and cream. **Mr. Hamilton Rowan** was so obliging as to carry me one day, accompanied by **Sir 
Charles** and **Lady Morgan**, a delightful drive in his car along this road. We 


---

p.74



 
went through the Phoenix Park for a mile and half, along the ridge of a hill looking down upon the Liffey and the meadows through which it meanders, till, quitting the Park at a steep descent called Knock Maroon, we came upon the bank 
of the river at Chapel-Isod. The chapel, or rather church, is beautifully and 
picturesquely overgrown with ivy, and the Irish ivy is beyond all comparison 
finer and more luxuriant in its growth than the English; it is now indeed much 
cultivated in England. Isod or Isoud, after whom the chapel was named, was 
the daughter of Anguish, one of the ancient kings of **Ireland**. She was distinguished par excellence as *La Belle Isoud*, and is celebrated in the notes to the 
metrical romance of Sir Tristram, edited by **Walter Scott**. There was once in 
the heart of the city an old tower called, after her, Isod's tower, which about a 
century and half ago was pulled down to clear the ground for some improvements then going forward. 


Above the road for some way beyond Chapel-Isod are very high slopes covered with strawberry- plants, which furnish the regales I have mentioned; while 
at the foot of the road runs the river. Quitting these strawberry-banks, the 
road, quite on to the village of Lucan, runs through a delightful dell with only 
the river and road in the bottom, and high wooded slopes on each side; or at 
intervals the dell somewhat expanding allows space for a small portion of 
meadow between the wood and the water. This is called the low road to Lucan: the high or turnpike road runs along a height on the different side of the 
river: it is the great north-west road through the counties of Kildare, Meath, 
Longford, &c. to Sligo. In many parts of this dell the river is so shallow that 
a person might walk through it and the water would scarcely be over his ancles; 
its course is besides very much broken by large masses of stone. At Lucan, in 
the grounds of **Mr. Vesey**, there is a medicinal spring resembling the springs at 
Harrowgate, and many people take lodgings here during the summer for the sake 
of drinking the waters. A spacious hotel has within a few years been built for 
the reception of company, and there are several lodging-houses scattered about;, 
yet there is nothing very pretty in the spot, except the grounds of **Mr. Vesey**; 
they run along the bank of the river, and are well wooded.


**Leixlip** is a mile beyond Lucan. Here the Liffey is joined by another small 
river called the **Rye**; and they form together a spreading expanse of water, 
though still very shallow. About a mile from this place the Royal Canal 
 


---

p.75



 
from **Dublin** to Mullingar, in the county of Westmeath, is carried over the **Rye**, 
and the deep valley through which it runs, by an aqueduct eighty-five feet above 
the river, — twenty-feet higher than that on the Clyde navigation in **Scotland**, and 
nearly as high as the **Pont-du-Gard**, the celebrated Roman aqueduct over the 
river **Gardon** in the south of **France**; — that is eighty French feet above the river, which is equal to eighty-six feet eight inches English and Irish measure. 
I do not know the height of the nearly as high as the **Pont-du-Gard**, the celebrated Roman aqueduct over the 
**Pont-y-Caselte** in **Wales**, (an aqueduct of the 
same kind,) but I believe it is nearly equal to either of the above mentioned. All 
these, however, are pygmies to the great aqueduct of **Alcantara** near Lisbon; this, 
if I am not mistaken, is two-hundred-and-thirty feet high. The aqueduct over 
the **Rye** I did not visit; — probably had I been by myself I had not been so near 
without going thither; but when with company we must bend to them, and the natives have never half the curiosity about the sights of their own country that strangers have. 


The village of **Leixlip** is prettily and picturesquely scattered about at the edge 
of the basin formed by the confluence of the two rivers. The Liffey about a 
quarter of a mile from hence enters a charming wild romantic dell, where high 
slopes covered with wood rise on each side directly above the water. In the midst 
of this dell the water falls over some rocks, forming a very beautiful though not 
very high cascade. The scene is altogether of a wild and romantic nature, unlike any thing one expects to see so near a large capital. Several paths are 
made through the wooded heights, by which the cascade is reached, — an access 
altogether suited to the wildness and solitude of the whole scene. The rush 
of water is abundant; though the fall is not high; and the effect is equally fine 
whether viewed from the edge of the water below or from a small temple above. 
A broken fragment of a bridge on one side of the fall adds much to the picturesque effect of the whole. This is called a Salmon-leap; but I rather think 
that those who would expect to see here that singular operation of nature would 
be entirely disappointed. About the rocks was a profusion of the large **St. John's Wort** (**Hypericum calycinum**) now in full flower; it was the first time I had 
ever seen that beautiful plant growing wild. We returned home by the high 
road, highly gratified with our excursion, the latter part of which was as new 
to **Sir 
Charles** and **Lady Morgan** as to myself; — so true is it that it is by means 


---

p.76



 
of strangers the natives principally become acquainted with the beauties of their 
own country.[6](javascript:footNote('E810001-001/note006.html'))


Another very pleasant day during my stay in **Dublin** was spent in a party 
to **Howth**, my companions being Mr. and Mrs. C ... and a very intelligent 
young Prussian with whom we had become acquainted. The road runs for a 
long way at the edge of the North Bull, and about a mile from the town passes 
by **Marino**, a delightful seat of the **Earl of **Charlemont****. In the grounds, and 
visible from the road, is a beautiful little temple called the Casino, built from a 
design by **Sir William Chambers**, after an Italian model. At **Raheny**, a village 
about half way, two roads divide off, the one going through the country, the 
other by the strand. This latter is the most interesting, as it passes through 
the village of **Clontarf**, rendered for ever memorable in the annals of **Ireland** 
by the battle fought here in the year 1014, between the Irish under their celebrated monarch and patriotic leader Brian Boroimhe, or Boru, and their Danish 
oppressors; in which, though the Irish monarch and his son both fell victims, 
a blow never recovered was given to the Danish power. It is not adviseable, however, to take this road at the flow of the tide, since it is at the very edge 
of the water, and in some places scarcely wide enough for two carriages to pass; at low water there is an ample space of sand, enough for a legion of carriages to go abreast. 


The **Hill of Howth** has been already mentioned as the northern point forming the entrance of the Bay. It is a remarkable peninsula, the perfect rock of 
Gibraltar in miniature, joined to the main land by an isthmus not more than a 
quarter of a mile over. It was anciently called **Ben-hader**, that is The bird's 
promontory. Tradition says that here once stood an edifice called Dun Criomthan, the palace of Criomthan, who was chief or king of the district, whence in 
the days of the Roman Agricola he made several successful descents on the coast 
of Britain. Though now nearly stripped of trees, the hill is said to have been 
formerly covered with venerable oaks, and to have been a great theatre of Druidical superstition. The only trees remaining are in the demesne of **Lord Howth**, on the western side of the hill. The Howth family is a very ancient 


---

p.77



 
one, descended from Sir Armoricus Tristram, who in times long past gained a 
great victory over the Danes on Saint Laurence's day, whence the family name 
was changed to Saint Laurence, which it has borne ever since. The house has a 
sort of castellated appearance, and is considered as the remains of a very large 
castle built by the same Sir Armoricus. A sword, as I was informed, is preserved in the house as the same which the knight wore in the battle; but I did 
not go into the house, so did not see it. Near the house, and not far from the 
road-side, is an odd kind of square building whitened over, which some suppose 
to have been a part of the ancient castle. When we asked our driver what it was, 
he very quaintly answered, "Plase your honour, and I suppose 'tis an Irish round tower."[7](javascript:footNote('E810001-001/note007.html'))


The village of **Howth** does not stand on that side of the promontory towards 
**Dublin Bay**, but on the opposite side of the hill facing the north. An immense 
work has been here undertaken, which had been at this time carried on for eight 
years, and to all appearance it was likely to continue eight years longer before 
it would be completed. This was to form an artificial harbour, by means of 
a mole or pier of stone-work. The stone principally used is from vast quarries 
made for the purpose in the rock itself; but a great deal has also been brought 
from **Bullock** on the other side of the Bay, and some even from the quarries at 
**Runcorn**, near **Liverpool**. The idea in making this harbour, — the ostensible one 
at least, — was to obviate the inconvenience experienced by vessels, particularly 
the packets from England, in being so frequently obliged to wait for a long 
time in the Bay till the tide will serve to go over the bar. Here, the projectors said, there would at all times be a sufficient depth of water to receive them, 
with effectual shelter from all winds. Some of the men, however, who were at 
work upon the pier looked wise, shook their heads, and shrugged their shoulders 
with a significant sneer when we talked with them upon the subject; and the 
tide being low pointed significantly to the rocky bottom, between which and 
the surface the space certainly did not appear very considerable: "Oh, by 


---

p.78



 
Jasus," one said, taking off his hat and bowing respectfully to the water, "and look ye there, I fancy it will answer." 
In a very different story were the people at work in the quarries when we 
went up to them. They were eloquent in praise of the undertaking, and the 
vast benefits which had accrued from it; but it must be owned that their encomiums were confined to dwelling on the number of poor to whom the works 
had so long furnished bread; they did not in any way enter into the question 
whether the end proposed would be answered. In fact, ill-natured little birds 
have whispered that, — since according to the theory of that great master in the 
art of diplomacy, Sir Robert Walpole, every man has his price, — this job was 
the price of **Lord Howth**'s concurrence in the Union. It is certain that it has 
put no inconsiderable sum of money into His Lordship's pocket, not only in the 
advantages derived from quarrying the stone upon his estate, but that it has so 
long furnished employment to a very large number of workmen, his tenants, 
that he has been enabled to raise his rents considerably, without fear of their 
being unable to support the addition.


Thus much is certain, that it has not been found an easy task to make the 
works of sufficient strength to resist the waves, which come with prodigious force 
round the head of the promontory; and 'tis thought that, even if the depth of 
water within the mole be found to answer, great risk must often be incurred by 
vessels in attempting to make the harbour. All agree that with a quarter of the 
expense a much more safe and commodious harbour might have been made on 
the south side of the Bay between **Dalkey Island** and the main land, where 
there is never less than eight fathom of water, and where vessels might always 
enter with safety and lie in perfect security.


Another scheme has been projected, which some are of opinion would render 
nugatory all other plans, by removing the impediment that now obstructs the 
entrance to Dublin harbour, and rendering that accessible at all times. This 
is to insulate the **Hill of Howth**, by cutting abroad and deep channel across the 
isthmus, when, as is affirmed, a current would be created of such force as to 
carry away the sands by which **Dublin Bay** is so much choked. Many, however, are of opinion, that this channel might be cut; but in carrying away the 
sands from the Bay, the probability is they would rest by the way, and the channel in a very short time be entirely filled up again. In fine, the only plan 


---

p.79



 
against the efficacy of which there does not seem one dissenting voice, is the 
establishing the harbour at **Dalkey Island**.


The stone of this hill is a hard limestone very much veined with quartz, and 
exceedingly impregnated with ferruginous matter, furnishing many crystallizations: some of the siliceous ones are of an acicular figure, small, and exquisitely 
transparent; they are called here (as I perceived siliceous crystallizations were 
called wherever found) Irish diamonds. The workmen preserve them carefully, 
and have always some to sell to the curious in such matters, for which they take 
care not to ask a price below their value. The quarries are pretty high up the hill, 
and the stone is brought down by the same kind of machinery as has been noticed 
at the Hampton quarries near **Bath**. The rocks are blown up with gunpowder, as 
the readiest means of separating the masses. One of these explosions took place 
while we were there; — the sound is grand, but it is not very safe to be near the spot 
where the explosion takes place; we were careful to keep at a proper distance. 
Below the quarries is a curious piece of rock insulated at high water, though 
when the tide is down the narrow channel by which it is separated is laid dry. 
The lowermost part of this rock appears to be schistose; it is of a deep red 
colour resulting from the presence of iron, while the uppermost part, of a bluish-gray colour, has much the character of gray wacke slate. 


On the highest point of the promontory is a light-house, from which there is 
as noble a sea-view as can be imagined. This is now no longer used; the rocks 
shelve off very much below it, and it has been found more eligible to build a 
new light-house upon a shelf more than half way down. Though not seen to 
so great a distance as the former, this is conspicuous as far as it is wanted, and 
is a safer and surer guide. In the village of **Howth** are the ruins of an abbey, 
but not affording any interest. 


Opposite to **Howth** are two small islands, **Ireland's Eye** and **Lambay**. The 
former is only three-quarters of a mile from the shore, and is supposed to have 
been rent from it by the force of the currents, yet here is the very spot chosen 
for constructing the mole. Are the works of man likely to resist the mighty 
power of the waters, when the works of the Creator did not? — This little 
island produces many odoriferous and medicinal herbs. On the east side 
is a perpendicular mass of rock called The Stags, considered as very dangerous 
to shipping; — an additional recommendation of the spot chosen for the new harbour, since ships making it must pass almost close to this rock.




---

p.80


#### 9


**Lambay**, three leagues to the north of **Howth**, is a much larger island, the 
resort of a vast number of sea-fowl, and producing abundance of rabbits. It 
is the property of a Mrs. Usher, a descendant of Archbishop Usher. This 
family came over to **Ireland** under the reign of King John, when they obtained a grant of the island of **Lambay**, which they have retained ever since. 
At a time when the plague raged in **Dublin**, Archbishop Usher retired hither 
with his family; and afterwards in leasing out the island, a clause was inserted 
in the lease, that if the city should be again visited by the plague, the lease 
was to be void; so that in case of such a calamity the family have always 
a safe retreat. There are now upon it the remains of a curious old building, supposed to have been erected at that time as a dwelling-house and fortress. One part is inhabited by some servants of the tenant who hires the 
property of Mrs. Usher, and they are the only human inhabitants of the island. 
The form of this building was a polygon, and it has no timber, but is built 
entirely on arches. There is a well on the island dedicated to the Holy Trinity, which is very much visited on Trinity Sunday. Great quantities of kelp 
are made here, and plenty of oysters, crabs, and lobsters, are caught.


A bay sweeps from the north side of **Howth** promontory round for a considerable extent of coast, called **Malahide Bay** from the town and castle of **Malahide** standing upon it. This latter, the seat of **Mr. Talbot**, is situated on a 
rocky eminence, a sort of peninsula, commanding a fine view of the town and 
bay. It is a large irregular building round a court, but is thought an object 
well worth the attention of a traveller, particularly from its bold and commanding situation; as such I always talked of seeing it, but it was one of the few 
objects which I talked of and did not accomplish. On the beach here, and 
at **Port Marnock** near it, abundance of shells are found. 
The road to **Malahide** passes through a village called **Saint Doulach's**, about 
four miles from **Dublin**, where is a curious old church, one of the very few remaining in **Ireland** built between the eighth and eleventh centuries, in a style 
of architecture to which there is nothing similar in Great Britain, or any of the 
western parts of Europe. The idea is supposed to have been taken from the 
Greek and Roman temples, since there is a manifest attempt at columns and 
pilasters of the ancient Doric order, which support a stone roof. A second 
stone roof finishes the building, between which and the first there is a considerable space. This style appears to have been a sort of intermediary one between 


---

p.81



 
the ancient architecture and the Gothic, for these buildings are prior to 
any of the known Gothic structures. The few churches that remain of such a 
description are small, none exceeding forty feet in length.


While several of my evenings were passed delightfully in witnessing the extraordinary talents of **Mr. Kean**, some others were passed very pleasantly in 
drives to different parts with Mrs. Kean, sometimes in the Phoenix-park, or 
round the Circular Road, or through some of the pretty villages which abound 
near **Dublin**. The Circular-road has its name from nearly encompassing the 
town. To go from the eastern part, where we were, to the Phoenix-park, which 
is at the western extremity, this road, though very circuitous, is generally taken 
to avoid going through some of the worst parts of the city. In pursuing it the 
Grand Canal is twice crossed. This great work, great both from its magnitude 
and from the important public object it embraces, affords an inland navigation 
directly across the island, from **Dublin** on the eastern coast to the Shannon 
which pursues its course to the western. The work was begun in 1756; so that 
it claims a priority over the canal system in England, which has been so much 
more the subject of public notice, and the theme of public admiration. I beg 
not to be understood here to mean any reflection upon the canal system; I 
think it one of great public utility, and claiming the utmost public eulogium: 
I mean only to observe, what I believe is not generally understood, that **Ireland** took the lead of Great Britain in it. In the neighbourhood of **Dublin** 
trees are planted on each side the canal, with a gravel walk between them and 
the water: where the trees are well grown up, this makes a very pleasant promenade. Passage-boats for conveying passengers and goods are constantly 
passing and repassing, and those who have no occasion to travel rapidly speak 
well of them as a mode of conveyance; but they take two days to go from 
**Dublin** to Shannon harbour upon the Shannon, where the canal terminates, 
a distance of only sixty-three miles. There is an excellent hotel now established at Portobello in **Dublin**, where the canal boats stop, which is found a 
great convenience to passengers coming by them.


The Phoenix-park is extensive, but there is nothing strikingly pretty in it. 
Here the Lord-lieutenant has a summer residence. Near the centre is a Corinthian column with a phoenix rising from the flames on the top. This was 
erected in 1747 by **Lord Chesterfield**, who was then Lord-lieutenant.




---

p.82


Visit to **Ravenswell** — The **Dargle** — Mr. Grattans Seat at **Tinnahinch**. — 
Lord Powerscourt's Seat at **Powerscourt** — Unfortunate End of the Duke of Dorset — The Waterfall at Powerscourt — The Hermitage — The **Glen of the Downs** — Mr. Latouche's House at Belle-Vue — Village of **Delgeny** — **Bray-Head** — Great Sandbank — Mr. Weld Hartstonge — Mr. Henry Mason — Origin of My Pocket-Book.
#### 10


On the renewal of my acquaintance with **Mr. Weld**, (as mentioned at the beginning of the fourth chapter,) he very obligingly invited me to visit him at 
**Ravenswell**, a house he had lately purchased near **Bray**, when he would introduce me to his wife and one of his sisters. Thither I accordingly went on the 
6th of August, the latter lady, Mrs. Cuthbert, a most delightful woman, the wife 
of a barrister then absent on the circuit, carrying me over; and here I passed 
four days most agreeably. I found Mrs. Weld a very sweet and pleasing woman, every way worthy of her husband and his sister.


**Ravenswell** is but just out of the town of **Bray**. It stands very pleasantly, 
not more than a furlong from the sea, the space between being occupied by a 
little paddock. The house is a very good one, the gardens and grounds very 
pretty, and the country about abounding with beauty. Here I first learned to 
understand how much milder the climate of **Ireland** must be in winter than that 
of England. In **Mr. Weld**'s gardens the **Hydrangea** and the **Fuchsia coccinea** 
were growing in the open ground, in a much more thriving and luxuriant manner 
than in the conservatories, where they are always kept in England. Surprised 
at what I saw, I inquired whether any means were taken to protect them in the 
winter, and was answered, — None at all, they were not even matted over. I 
afterwards saw many other instances of these plants thus growing in shrubberies, 
as healthy and flourishing as if they were natives of the soil. The Hydrangeas 
were even large spreading shrubs.


The **Dargle**, the name of which is well known to every body who knows any 


---

p.83



 
thing about **Ireland**, is not more than a mile from **Ravenswell**. It is a spot well 
deserving all the celebrity it has acquired. At the bottom of a deep glen runs 
a stream, which having a channel broken with blocks of stone, the water rushing and foaming over them charms alike the eye and the ear. The steep banks 
on each side are clothed with beautiful woods; the branches in some places 
meeting and entwining with each other, form lovely green arches over the water. 
Among the woods wind the most enchanting walks, sometimes carried down to 
the very edge of the water, sometimes rising to a great height above it. In one 
place is a vast rock which towers abruptly from the stream to a great elevation; 
this has the name of the Lovers' Leap; — to how many rocks in the world has 
the unhappy fate of poor Sappho furnished a name! — About half-way in the 
glen the stream has a considerable fall down the rocks, at the foot of which it 
expands to a sort of basin, the woods forming a little amphitheatre round it: 
in this lovely spot is placed a pretty little mossy hermitage, and in different 
parts about the woods are several other similar rustic and sequestered bowers.


The name of the **Dargle** is differently derived. Some will have it to be the Dark-glen, others contend for the Darra-glen; — Darra signifying an oak in the Irish language, and oaks being the trees of which the woods are principally 
composed. This dell is more than a mile in length. A little way beyond the 
end of it is **Tinnahinch**, the beautiful seat of **Mr. Grattan**. One side of the 
**Dargle** is the property of this gentleman; the other belongs to **Lord Powerscourt**. The latter is the side most frequented. On **Mr. Grattan**'s side, at the 
summit of the rocks, in a very beautiful spot, is a sweet little rustic cottage built 
by Mrs. Grattan. Here, while she was in health, parties to dinner or to tea were frequently made by her, the better to furnish her friends with an opportunity of enjoying this delightful retreat. Unfortunately she has fallen into 
ill health, is become almost a cripple, the parties have ceased, and the cottage 
has fallen very much to decay. Both the proprietors of the **Dargle**, with true 
liberality, with the true spirit of gentlemen, allow the public free access to this 
demesne, and parties are often made in the summer to dine in the woods, the 
visitors bringing a cold dinner with them. On Sundays in particular, if the 
weather be fine, the place is often full of these parties, many of them coming 
even from **Dublin**, though a distance of eleven miles. From **Lord Powerscourt**'s 
side of the **Dargle** the conical heads of the two mountains called the Sugarloaves 


---

p.84



 
 are seen rising just above the trees on the other side, looking as if directly 
behind them, though they are in fact at a considerable distance.


Another object of universal admiration in this quarter is **Powerscourt**, the 
beautiful seat of **Lord Powerscourt**. The house is a handsome modern edifice, delightfully situated, commanding a fine prospect every way. The ceiling 
of the hall by which it is entered is singular and whimsical; it is divided into 
small square compartments, each square having round it a cornice of shells in 
stucco. One cannot help immediately thinking of the Ossianic heroes banqueting in their hall 
of 
shells. Upstairs there is a handsome saloon and suite of 
apartments, but upon the whole the house has nothing in it very remarkable. 
It was while hunting with **Lord Powerscourt** that the young Duke of Dorset 
came to his unfortunate end. He took a leap over a low stone fence, not aware 
that on the other side was a pit; he and his horse fell together, and when taken 
up he was wholly senseless; he was brought alive to Powerscourt-house, but 
expired in less than an hour. A messenger was sent off at the moment of the 
accident to Lord Whitworth and the Duchess, but long before they could reach 
**Powerscourt** all was over. **Lord Powerscourt** was so deeply affected with this 
catastrophe, that he immediately disposed of his hounds and has never hunted since.


The most remarkable feature of the demesne is the celebrated waterfall. It is not in the grounds immediately surrounding the house, but at some distance 
from it, I think five miles, in the heart of a mass of wild and romantic mountains. At the foot of a pretty considerable descent, after passing through a 
gate, a shallow stream running over broken blocks of stone is crossed, and a 
valley is entered through which this stream winds, still over the same rocky bottom. One side of the stream is occupied by **Lord Powerscourt**'s deer-park, 
which lies on a considerable but not very steep acclivity and abounds with fine 
oak-trees. This part is forbidden ground; the other side of the stream is open to 
every one who chooses to visit the waterfall, and a road runs along the valley 
quite up to it. But a much more advantageous distant view of the fall is to be 
obtained on the deer-park side of the river: and desire to have the best possible 
view of it being a more powerful feeling with our party than fear of wetting our 
shoes, we made no hesitation to commit a little trespass, trusting that the recording angel would not enrol it in the great book, under the head of heavy sins, 


---

p.85



 
but only under that of minor peccadilloes: — in this confidence we quitted our 
car, and sent that on to the fall, while we very successfully, assisted by the 
fragments of stone, waded through the stream, almost without the forfeiture of 
wet shoes, and pursued our route along the forbidden side; I believe, like true 
descendants of Eve, enjoying our walk the more for its being taken in opposition 
to the imposed taboo. 


Indeed the spectacle presented as we advanced along the valley was truly 
enchanting. Of a different nature from the **Dargle**, there is some extent of 
pasture on each side the stream before the slopes begin to rise. At length the 
valley expands into a beautiful amphitheatre surrounded by the wooded slopes, 
in the centre of which is the waterfall, rushing profusely down an almost perpendicular rock from a very great height, said to be three hundred feet. Nor 
do I believe this an exaggerated estimate, including the whole height that the 
water descends; but the whole cannot be seen looking from the valley below. 
The stream by which it is fed comes from a small plain above among the 
heights of the mountains, and after meandering through this plain it falls into 
a very narrow thickly wooded little dell, where running a short distance it then 
rushes down the great cascade. At this time I only saw it from the valley: it 
is possible to climb from thence to the head of the cascade; but the rocks are 
very steep, the ascent very slippery, and petticoats are ugly troublesome things 
in climbing, — so we did not attempt the adventure: in an excursion, however, 
the following year to another part, going over the high grounds at the top of 
these mountains I was gratified with a sight of it.


After falling a considerable way almost perpendicularly, it comes to a number of broken masses of rock, among which it dashes and bounds till it terminates finally in the little stream below. Another stream coming from a dell 
which branches off from the principal valley joins the cascade stream at the 
distance of about a quarter of a mile, when both together form the rivulet we 
had waded through. It appears very astonishing, nay even incomprehensible, 
when one stands contemplating an object of this kind, how that body of water 
constantly rushing down with such astonishing velocity can be supplied, and 
one almost expects at every moment that the great jug above must be emptied 
and the pouring out of the water cease. If this be the sensation at the humble 
fall of Powerscourt, what must be felt at beholding the Falls of Niagara? I 


---

p.86



 
know not whether it be possible to compute the quantity of water that pours 
clown here at every minute; but considering the steepness of the descent, and 
the consequent velocity with which the water rushes, it must be prodigious. 
The summer had been rather a wet one, so that there was plenty of water, 
though at a time of year when it often fails. Altogether this is a truly enchanting spot. 
Another place to which my kind host at **Ravenswell** carried me was the 
Hermitage, a beautiful but now deserted spot, the owner, who married a 
daughter of **Mr. Grattan**'s, having removed to **Altidore**, a seat lately purchased by him in the neighbourhood. At the Hermitage is a beautiful dell in 
the style of the **Dargle**, but not near its length, having high wooded slopes on 
each side, a streamlet in the bottom, and pretty walks ascending and descending 
among the woods. The rocks here are a schist coloured by chlorite, and 
richly veined with quartz. We returned by the **Glen of the Downs**, another 
dell of the same kind, through which runs the new mail-coach road from **Dublin** 
to **Wicklow** and Wexford. In this glen the road lies directly at the foot of the 
slope on one side. Down this slope a few days before an immense mass of stone 
had rolled from the summit to the bottom, where it was then lying. On its course 
it swept down every thing that lay in its way, leaving the track by which it descended as distinctly marked as if a road had been cut through the thicket. The 
other side of the glen is a part of the grounds of Peter Latouche, Esq.; a little 
lawn, shrubbery, and rivulet course the foot of the slope, and along the slope 
are beautiful plantations. Just at the mouth of the glen a road turns off to the 
village of **Delgeny**; and above this road, at a considerable height, stands **Belle Vue**, Mr. Latouche's house, in a situation which renders it truly worthy the 
name it bears. Few people with the means of Mr. and Mrs. Latouche have 
the same spirit of employing their wealth in diffusing happiness around them. 
They are alike distinguished for hospitality to their equals and liberality to their 
dependants. The village of **Delgeny**, the parish in which **Belle Vue** stands, is 
prettily situated upon the slope of a hill; there is a neat new church built by 
Mr. Latouche, and a school maintained by Mrs. Latouche. The children educated there sing at the church on a Sunday, and people in the neighbourhood 
come thither very much to hear them.


The road from hence to **Bray** by the coast is very pretty: the latter part 


---

p.87



 
skirts along the land side of **Bray-head**; a stupendous height, rising by degrees 
almost to a ridge, which runs out into the sea, forming a bold and majestic 
promontory: it is seen by vessels at a great distance. The rocks here are 
a very close-grained limestone, of various shades of gray. **Bray** is a neat little 
town, standing prettily upon the shore, and having the stream from the **Dargle** 
running at its foot. This, after pursuing its course some way over a wide, 
shallow, pebbly channel, here empties itself into the sea. It is celebrated for 
fine trout. Off this part of the coast, some way out at sea, is a great sandbank, where a vessel is always moored, as at the Goodwin Sands off the 
Kentish coast, with lights at night. Some pretty pebbles are occasionally 
found here, and plenty of weed; but I saw no shells, and no corallines except 
two small pieces of the sickle. The counties of **Dublin** and **Wicklow** are 
divided by the river; so that while **Bray** is in the latter county, **Ravenswell** is in the former.


**Mr. Weld** has here a very beautiful table of the yew-tree wood, which is 
occasionally found in the bogs. A striking and remarkable feature of the bogs of **Ireland**, is the quantity of wood dug up from them at a great depth below 
the surface. Whole trunks of trees are found, which must have lain there, 
probably for centuries; but far from having any appearance of decay, the 
wood acquires additional hardness from being thus submerged. It also becomes of a very dark hue: the oak, in particular, will sometimes be turned nearly as black as ebony, and will bear an equal polish. This and fir are the 
principal woods dug up, but others are occasionally found, — yew among them. 
The table I saw at **Ravenswell** was turned nearly as dark as old mahogany, 
retaining all the beautiful veining of the wood with the utmost distinctness, 
and having as fine a polish as could be given to the finest mahogany.


On the road between **Dublin** and **Bray** stands a house, now a gentleman's 
seat, which having been formerly an inn was placed almost at the road-side. 
In its converted state the front has been turned away from the road, and a wall 
is run up behind, not many feet from the house, between that and the road, 
which wall is continued to the end of the grounds, with agate of entrance more 
than a furlong from the house. An English gentleman was walking by this 
place in company with an Irish one, while the people were at work making 
the gate of entrance; when the former said that he had heard much of the 


---

p.88



 
quaintness of the lower orders among the Irish, but though he had been some time in the country, he had not met with any traits of it. 
"You shall not be long without one," said the Irish gentleman; and going up to the men at work at the gateway, he said, "What are you doing there, my friends?" — "Plase your honour," answered one with a significant nod of his head towards the house, "making an entrance to that house." "What, to that house yonder?" said the 
Englishman. "Yes," replied the man, taking off his hat, and bowing respectfully towards the house, "to that very house."


In the hospitable mansion at **Ravenswell** I met two poets of the country, **Mr. Weld Hartstonge**, a relation of my hosts, and **Mr. Henry Monk Mason** — 
brother to **Mr. William Monk Mason**, whom I have already had occasion to 
mention. The former is the author of a poem entitled Marion of Drymnagh, a tale of Erin, written in imitation of the style and manner of **Walter Scott**, 
with whom the author is in habits of intimacy. It is founded on a legendary 
tradition annexed to Drymnagh castle, formerly the seat of the ancient family 
of Barnewall, viscounts of Kingsland and barons of Trimletston, now the 
property of the Marquis of Lansdown. The castle is a venerable remnant of 
antiquity, standing in a romantic spot not more than three miles west of 
**Dublin**. The legend on which the poem is founded has its origin in the Crusades; and that prince of crusaders, Richard Coeur de Lion, occupies a conspicuous place in it. From this circumstance the author takes occasion to mention in a note a derivation of the name of Plantagenet, which from its excessive 
whimsicalness, and to show how some persons will run all lengths after a derivation, deserves notice. It is this: The first Earl of Anjou, who bore the name, 
having been stung with remorse for some wicked action which he had committed, in atonement of his offence undertook a pilgrimage to Jerusalem. Here, 
as a part of his penance, he caused himself to be plentifully scourged with twigs 
of the broom-plant (genista), and thence he afterwards assumed the name of 
Plantagenet (broom-plant), which was ever after borne by his royal successors[8](javascript:footNote('E810001-001/note008.html')).




---

p.89


#### 10


**Mr. Henry Monk Mason** has also directed his poetical talents to the legends 
of his country: his poem refers to St. Kevin, a saint of whom we shall have 
occasion hereafter to make much more ample mention when we come to speak of the valley of Glendaloch and the remains of the seven churches there. Of these **Mr. Mason** has treated somewhat at large in the notes to his poem.


It was at the house of a gentleman in this neighbourhood that that excellent 
piece of humour, My Pocket-Book, had its origin. The good-natured, but 
perhaps rather superficial traveller, at whom the wit is aimed, was dining at the 
house of this person with a large party both gentlemen and ladies, when he 
was observed to draw out his pocket-book very frequently, and take down memoranda of what he heard in conversation; and that, as some of the company 
thought, rather more of the trivialities and frivolities which passed, than of 
more important matters, whence real instruction and information might have 
been derived. This awakened the attention, and rather gave a spur to the 
satire of some of the gentlemen present, who immediately took advantage of 
any opportunity presented to throw in an anecdote, no matter whether true or 
drawn from their own imagination, such as they thought the traveller would minute down; and seeing with delight that the bait took, their assiduities were 
redoubled. Laughing together afterwards at what had passed, the idea suggested itself of the publication in question. The effect it produced is well 
known, and was probably much more than they intended; 
their only idea was 
to afford a momentary amusement to themselves and to the public: they had 
no conception that they were to be the means of injuring the traveller's reputation as a writer. Nor, in all probability, would they have been so, but for 
the folly of the publisher in prosecuting the work: this only, as is invariably 
the case, occasioned it to be the more sought after, and gave additional poignancy to the satire. In **Ireland**, particularly, My Pocket-Book acquired so 
much celebrity, that while I scarcely met with any one who was not well read 


---

p.90



 
in that, I met with few who were acquainted with the work it ridicules. No 
tourist could now venture to write down a memorandum in the presence of 
company: I carefully avoided it, and reserved till evening, when I had retired 
to my own apartment, the task of taking down my notes and observations upon 
what I had heard or seen in the day. If any one should choose to make a 
sketch of me, either with pen or pencil, at this my nocturnal occupation, I resign myself to them freely; they may rest assured that they will not be prosecuted.




---

p.91


Departure from **Dublin**. — **Swords**. — **Drogheda**. — **Dundalk** Bay. — The Weeping-ash Tree. — Town of 
**Dundalk**. — **Hilsborough**. — **Lisburn**. — The Valley 
of the **Lagan**. — Arrival at **Belfast**. — Flourishing State 
of this Town. — Places 
of Worship. — The New Chapel. — Charitable Institutions. — Literary Societies. — Manufactories. — Belfast Lough. — Dr. Macdonnell. — His Collection of Drawings, Minerals, &c. — Mr. Ryan. 
#### 11


As the principal object of my journey was to visit the North of **Ireland**, I had 
not intended staying more than a fortnight at **Dublin**, but I was detained there 
nearly a month by the illness of my servant. It was not till the eleventh of August that I could set off on my remoter travels. The country on this side of 
Dublin is flat, dull, and monotonous; and the weather being unfortunately very 
wet, it was seen to particular disadvantage. The road runs near the coast, and 
to a considerable distance has the **Hill of Howth**, with **Lambay** and **Ireland's 
Eye**, constantly in view. When these are lost, some other little islets lying off 
the coast succeed, as the **Skerries**, **Racabitt**, and **Patrick's Island**. 


At **Swords**, seven miles from **Dublin**, are very extensive ruins. Here was 
originally a monastery, which at the abolition of religious houses was converted 
into a palace for the Archbishop of Dublin; nothing now remains but walls 
overgrown with ivy: a round tower stands only fifty feet from the church, so 
that at a little distance it has the appearance of a turret belonging to it. This 
tower is between seventy and eighty feet in height. On account of the rain I did 
not stop to examine it; but I am informed that the upper part for several feet 
was rebuilt within the last half century; if so, though to appearance one of the 
most perfect in **Ireland**, it is not one of the best specimens remaining of these 
extraordinary structures. At **Balruddery**, twenty miles from **Dublin**, upon the 
very edge of the sea, are the ruins of a church, which have a very picturesque 
effect. 


The town of **Drogheda** is twenty-four miles from **Dublin**; 
it stands on the 
river **Boyne**, only five miles from its mouth, and vessels of a considerable size 


---

p.92



 
come up to it. The approach to this town is rather striking, having the river with 
the vessels lying in it and the bridge at the bottom, while the town rises in a 
slope above them. Both the town and river, from association, excite a considerable degree of interest; the town from the remarkable siege it sustained in 
**Oliver Cromwell**'s time, the river from the still more memorable battle fought 
on its banks by that illustrious monarch King William the Third. Before the 
Reformation, **Drogheda** abounded with monastic institutions; the buildings of 
many are still standing, though no longer the abodes of religion, as they were 
called, one excepted, which is now a nunnery. But we read of so many murderers and malefactors of various descriptions taking sanctuary at different times 
in one or other of these monasteries, that they seem rather to have been harbours for the wicked than receptacles for the pious. The Catholic Primate of 
Ireland has a house here, which is a conspicuous object in approaching the town. 
The **Boyne** is celebrated for the excellence and abundance of the salmon and 
trout that it yields.


Just beyond **Castle Bellingham**, which is ten miles from **Drogheda**, the road 
comes directly to the edge of **Dundalk Bay**. This bay is very extensive, but 
the water is so extremely shallow that no vessel, scarcely even a fishing-boat, can 
at any time come near the shore. When the tide is down, the extent of sand 
is so great as immediately to suggest the idea, (like the North Bull in **Dublin Bay**,) that by industry a vast tract might be rescued entirely from the water, 
and rendered cultivable land. But sufficient encouragement is not given to Irish 
industry to induce such speculations. Vast quantities of cockles are gathered 
in this bay. On the shore are extensive salt-marshes, where a number of sheep 
and cattle are always feeding; the sheep thrive here particularly well. The 
marshes and sands abound with sea-fowl, as wild-geese, barnacles, gulls, and 
many others.


The road continues along the Bay for three miles, when at **Lurgan Green** it 
turns to a greater distance from the coast. Between that place and **Dundalk** 
my attention was arrested by seeing in a hedge-row, among a number of ash-trees with which it was interspersed, two of the kind now well known in England 
as the weeping-ash. One of these was of a great height, and was evidently a tree 
of many years growth; it must have been much, much more ancient than the date 
when these trees came into general notice in this country; it had, however, been 


---

p.93



 
stripped of its long branches, and only a few young shoots were now growing 
from the top. The other was of a considerable size, larger than any I ever saw 
in England, the parent stock excepted.


It is remarkable that this tree, now to be seen in almost all plantations, was 
scarcely known till within somewhat more than the last thirty years. At that 
time the existence of the parent tree, though then of a great age, was known to 
very few; — chance led to my becoming acquainted with it. It stands in the village of Gamlingay in the county of Cambridgeshire, where a woman, who had 
been servant in my father's family, went to live with her husband. Seeing this 
woman occasionally, she talked to us very much of a great curiosity in their village, a weeping-ash tree; and one day when some of the family were at the village she carried us to see it. It was then in a field close by a farm-house, a large 
forest-tree, the trunk growing to a great height quite straight, without a shoot, and 
from the head the long branches hung sweeping to the ground, forming a perfect 
arbour within; it did indeed appear to us a great curiosity. She said that her 
husband had taken some grafts from it which he had grafted upon common ash 
stocks, and if the experiment should succeed, she would request my father's acceptance of one. In due time one was brought and presented to him at his 
living of **Wimpole** in **Cambridgeshire**; and the man having been servant in Lord 
Mardwicke's family, another was presented to His Lordship's steward to be 
planted in the grounds. These I have good reason to think were the first two 
known out of **Gamlingay**. 


Since that time the breed has spread very much; but I believe it may with 
truth be affirmed, that all are descendants in a direct or remote line from the 
same parent. The dispersion of the family has brought the parent into more 
notice, and occasioned investigations to ascertain if possible its origin and age; 
but the oldest people in the place, one man eighty-eight years of age, could only 
say that he remembered the tree ever since he was a boy, and always a large 
and well grown one. The last time I saw it was about three years ago. A 
very neat small house had been built close by it, where lived the curate of the 
parish, and the tree was enclosed in his garden; he had rescued it from the axe, 
to which it had been sacrilegiously doomed. It was not in so great beauty as 
when I first knew it; one side had suffered exceedingly in a hard winter, and 
so much had died, that on that side the arbour was quite laid open; on the 


---

p.94



 
other side the branches hung with as fine and majestic a sweep as ever. A remarkable thing is, that if the seeds of this tree are sown they come up common 
ash trees, the only way of propagating the species is by grafts. The same casualty that first produced this tree must probably have operated to produce those 
in the hedge-row on the **Dundalk** road; but no such chance as that I have mentioned ever drew these into the same notice, they seemed to stand here wholly 
unheeded. 


**Dundalk** is a large town, forty miles from **Dublin**, having one street running 
through it to the extent of a mile, from which diverge several smaller ones. 
The last coronation that took place of a monarch of all **Ireland** was at **Dundalk**; 
it was for a long time a royal residence. There is a good port, and a 
cambrick manufactory, the principal one in **Ireland**. The country beyond this 
place becomes much more hilly and stony, interspersed with some tracts of bog. 
The road passes a very fine seat of **Lord Clermont**'s, well wooded, but having 
the air of a deserted and abandoned place. 


**Newry**, fifty miles from **Dublin**, is a large and very commercial town, standing on a river called the Newry-water, which runs up from **Carlingford Bay**. 
A canal goes from this town to **Lough Neagh**. A singular kind of pitch-stone 
is found in the neighbourhood, but in one particular spot only. About seven 
miles from **Newry** the road passes a small fresh-water lake called **Lough Brickland**. 


**Dromore**, sixty-six miles from **Dublin**, is a very ancient city standing on the 
river **Lagan**. For many years it had been declining exceedingly, since, though 
a bishop's see, it was deserted by its shepherd; 
his residence was fixed at **Magheralin**, a village at a little distance. But **Dr. Beresford** when he was bishop 
built a house in the town, at which he came to reside in 1781, and ever since it 
has revived, and is now in a tolerably flourishing state. It is ancient as a see, 
its first foundation dating as far back as the sixth century, but it was refounded 
by King James the First with extraordinary privileges. Among other marks 
of his royal favour, he ordered that the bishops should be distinguished as by 
divine providence Bishops of **Dromore**; all the other bishops in **Ireland**, excepting those of **Meath** and **Kildare**, are only styled Bishops by divine permission.


**Hilsborough** is sixty-nine miles from **Dublin**. This is one of the neatest towns 
I saw in all **Ireland**, which it owes principally to the cares, the attentions, and 


---

p.95



 
the liberality of the **first Marquis of **Downshire****, grandfather to the present marquis. By him a very handsome church was built. The Marquis has a house 
in the town with a fine library. All the way from **Newry** nearly to **Belfast**, 
the **Mourne mountains**, some of the highest in **Ireland**, are seen in the distance 
raising their towering summits behind, and far above all the lesser hills of the county of **Down**. Since mail coaches have been established, the roads have 
been turned in many places to carry them round the bases of the hills instead of going over their summits; following the old maxim, that ‘the furthest way about is the nearest way home.’


**Lisburn**, four miles beyond **Hilsborough** and seventy-three from **Dublin**, is 
a very neat town situated on the river **Lagan**. It has every appearance of a place of much industry and commerce, and has long been celebrated as one of the principal marts of the Irish linen manufactory. Much of its present flourishing state is ascribed to the number of French refugees who settled here at 
the revocation of the edict of **Nantes**; and they, coming from the parts where were the best linen manufactories in the French dominions, improved by their knowledge those of the country which afforded them an asylum. — But more of 
this place and of its manufactures hereafter.


Here the road enters the county of **Antrim**, and continues along the valley 
of the **Lagan** quite to **Belfast**, where the river joins the **Bay of Belfast**, or **Belfast Lough**. This valley and the lough run in a direction from south-west to 
north-east, and the valley is skirted from a very little way beyond **Lisburn** by a 
continued chain of mountains. The country constantly improves, till in the 
neighbourhood of **Belfast** it becomes very beautiful, being scattered over with a 
number of villas, the summer residences of the citizens of **Belfast**. The town 
stands exactly at the junction of the river with the bay, or perhaps it should rather be said that the bay from its mouth is constantly contracting itself till at 
**Belfast** it is narrowed to the breadth only of a river; when it assumes the 
name of the **Lagan**. The same is the case with **Carlingford Bay** in the county 
of **Down**; it narrows up to the river called **Newry-water**; and such also is the 
**Kenmare river** in the county of **Kerry**, a bay narrowing gradually till it becomes 
no wider than a river. The **Lagan** is crossed at **Belfast** by a very old bridge of 
twenty-one arches, which, like most old bridges, is very narrow, with the arches 


---

p.96



 
very small. Three of the arches are in the county of **Antrim**, the remainder of 
the bridge is in the county of **Down**. 


**Belfast** is one of the most opulent towns in **Ireland**: it is the largest town 
in the county of **Antrim**, though not the county town, and is a principal 
deposit of the linen-trade. It has increased in wealth and size very much 
within a few years; there are many streets entirely new-built, and nearly at 
the entrance of the town is a spacious and handsome linen-hall almost new. 
For its present flourishing state it is much indebted to the late **Marquis of 
**Donegal****: this family has a large property in the town; many of the new 
streets are upon ground leased from them. The late Marquis built at his own 
expense a handsome assembly-room over the Exchange. Large as the town is, 
it contains only one parish; the church is a neat one, but has nothing in it particularly striking. A very large portion of the inhabitants are not, however, of 
the church of England. This county and **Down**, approaching the nearest to 
**Scotland** of any part of the island, have been very much colonised by Scotch 
families, consequently dissenters from the church of England; 
yet many do 
not adhere to the religion they brought over with them, but have adopted other 
persuasions. Unitarianism is more prevalent here than in any part of **Ireland**; 
the catholics are not numerous, though they have two chapels. There are 
eight congregations of protestant dissenters of different descriptions, including 
a quakers and a methodists meeting.


As the church had become too small for the increased size of the town, a 
chapel of ease was in considerable forwardness when I was there. It was raised 
from the spoils of one out of the many houses built by the late **Earl of **Bristol**, 
and Bishop of **Derry****. Besides that at **Ickworth** in the county of **Suffolk**, he 
built two in the county of **Derry**; **Down Hill**, now the property of **Sir Hervey 
Bruce**, and that in question, I think, near **Derry**. The heir to his estates has 
thought proper to pull down the latter, and selling the materials, sufficient 
were purchased by the town of **Belfast** to build a chapel; among these materials were some fluted Ionic columns, which form a very handsome portico. 


The principal charitable institutions at **Belfast** are, a general infirmary for 
the sick poor, a fever hospital, a lying-in hospital, an asylum for the blind where, 
as in similar institutions in other places, they are taught such works as they are 


---

p.97



 
capable of executing, particularly basket-making; — an asylum for aged men 
and women and orphan children; the latter are fed, clothed, and educated, till 
of age to be bound out as apprentices; — a house of industry intended to abolish mendicity, — and indeed in no part of **Ireland** are so few beggars to be seen; 
perhaps this is rather to be ascribed to the country hereabouts being in a more 
Nourishing state than most other parts. 


A plan was formed some years ago for establishing an university, principally 
with a view to the education of protestant dissenters. Not much progress had at this time been made in it, and it seemed probable that the scheme would fall 
entirely to the ground. There are literary societies for the promotion of philosophy, the medical sciences, and music: — the latter has principally in view the 
revival of that ancient national instrument, the harp, such as it was in former 
days, not with any of those modern *improvements* which entirely deprive the 
instrument of its true national character. This town is considered as a very literary place, it is a sort of metropolis of the north. Besides the great staple article 
of manufactory — the linen, there are large manufactories of cotton, sail-cloth, 
sugar, glass, and earthenware. The streets are well paved with trottoirs, and 
well lighted. All round the town there are very large bleaching-grounds. 


The Bay at the flow of the tide is truly beautiful, scattered over on each 
side for a short distance from the water with country-seats finely wooded, and 
high hills rising behind them; the hills on the northern shore are much the 
highest. When the tide is down, a very large portion of the Bay is but a continued sand or rather mud, with a small channel winding through it up to the 
town. This channel is marked by posts for the direction of vessels coming 
up at high water, and the depth is then sufficient to admit vessels of a considerable size. Oysters, muscles, and cockles, abound in the Bay, and the 
shores at low water are scattered over with the shells; but there are no other 
shells, and no weed or pebbles worth notice. Further down the Bay, towards 
**Carrickfergus**, the shore becomes more pebbly, and some shells are to be 
found of the genera **Buccinum**, **Venus**, and **Area**. 


By the kindness of **Mr. Hamilton Rowan**, I had a letter of introduction to **Dr. Macdonnell**, one of the principal physicians in **Belfast**, and a zealous geologist 
and mineralogist. To this gentleman I was particularly obliged for a vast deal of 
 


---

p.98



 
information which proved of infinite use to me in going round the county of 
**Antrim**, and for seeing many very interesting objects in the neighbourhood of 
**Belfast** which might otherwise have escaped my notice. In his possession I 
saw a collection of drawings of all the most remarkable points round the coast 
of **Antrim**, taken by an Italian, who went out repeatedly in a boat along the 
coast for this purpose. I examined them now with very great pleasure, as giving 
me an excellent idea of what I was going to see: — I saw them with redoubled 
pleasure at my return to **Belfast** after having visited the several spots. They 
are taken with perfect accuracy, exhibiting a series of wonders of which those 
who have never seen any thing of the kind cannot form an idea. 
**Dr. Macdonnell** has a large collection of minerals, with many other objects 
of curiosity; among them two arrow heads of carved flint, worked in a way 
which nobody now is able to execute, nor can anybody that sees them imagine 
with what kind of instrument it could be performed. There are also some axes 
similar to those that have been mentioned in the **Dublin Society** Museum, called 
there Carthaginian axes. The Doctor is, however, not very much disposed 
to believe them so: he says they are found in such numbers, in districts so 
very remote from each other, and from any part the Carthaginians are ever 
supposed to have visited, that they must have been an implement in common 
use among the natives, though it is difficult to surmise for what purpose. The 
metal of which they are composed appears a composition of copper and tin.


Among many other topics of conversation with the Doctor, he was very particular in his inquiries about our new theatrical meteor, **Mr. Kean**; whether I 
thought his merits really deserving the encomiums bestowed upon him in the 
newspapers, and the enthusiasm which he seemed to have excited in London. 
After the opinion I have already given of this great actor, my answer will be 
readily anticipated. Upon this the Doctor said: "I understand it to be a well 
ascertained fact that he was playing at **Belfast** a few years ago almost unnoticed. What a reflection upon a town which pretends to so much taste and 
literature that we could not discover such talents!"


Breakfasting with **Dr. Macdonnell** the day that I was to quit **Belfast** on my 
progress round the country, I met a great miner, Mr. Ryan, almost inevitably, 
therefore, a great mineralogist. He had in his possession a piece of wood, 


---

p.99



 
part of a perfect wheel which had been found at a great depth in a bog; 
and he mentioned having heard of a boat which had recently been found entire 
at a great depth in another bog not very far from **Portrush**, the north-western 
extremity of the county of **Antrim**. This he knew only from report, he had 
not been able positively to ascertain the fact; but he heard it from authority 
which he had very good reason to credit. He was making inquiries by which 
he hoped to arrive at the truth, but I never learnt the result of them. He 
gave me a small piece of uranium which he had obtained from the **Gunnis Lake** at **Calstock** in **Cornwall**, in a vein of quartz four hundred and fifteen 
feet from the surface of the earth. It is of a brilliant green colour, and has 
the lustre of what is known by the name of foil.




---

p.100


The Valley of the **Lagan**. — Divis Mountain. — The Gypsum Quarry. — The 
Cave-Hill. — **Carrickfergus**. — **Island Magee**. — The Town and **Bay of Larne**. — .The Gobbins. — Reputed Massacre there. — Promontory 
of Ballygelly. — Cairn-Castle. — Town of Glenarm — Enormous marine Plants. — Garron-Point, and steep Descent there. — **Red Bay**. — **Cushendall**. — Civil Attentions of a Scotchman there. — Adventures 
of the Night. — **Cushendun**, and its Caves. — Vast Tract of 
Bog. — Arrival at **Ballycastle**.
#### 12


At the valley of the **Lagan** commences the curious basaltic region which I 
was now going to explore. It is the first of a range of valleys which intersects 
at certain distances the eastern coast of the county of **Antrim**, each having 
a stream running down to the sea, with stupendous mountains extending along 
their sides. In most of these the upper stratum of the mountains on both 
sides is basaltic, resting upon a limestone base: they are only so on the north 
side of the **Lagan** valley; on the south side, which is in the county of **Down**, 
they assume a wholly different character. Along the north side run in succession the mountains of **Colin**, **Divis**, the **Cave-Hill**, **Carnmoney**, and **Knockagh**. 
They constitute one chain, but these are the principal points. The **Cave-Hill** 
has the appearance of being the highest, since it rises abruptly to its extremest 
point; **Divis**, on the contrary, which is really the highest, alter rising to a considerable height shelves off, and runs level for some way; then again rises 
what may almost be termed another mountain. This form is, however, only 
to be observed at a distance; — looking up from the foot nothing more than the 
first rising is seen, nor in ascending is the second discernible till the summit 
of the first is reached. The two divisions include a height of 1400 feet above 
the level of the Lough; the **Cave-Hill** is only 1140.


Along the side of a small stream which runs at the foot of **Divis** is a vast 
quarry of gypsum. The prevailing rock mass here is schistose; it is crossed 
by a whin dyke.[9](javascript:footNote('E810001-001/note009.html')). The gypsum is accompanied by a bed of indurated clay, 


---

p.101



 
the prevailing tints of which are gray or dull red, and of these the gypsum 
occasionally partakes. It exhibits a beautiful glimmering lustre, and a splintery fracture; 
in many places it is fibrous, forming extensive veins, and constituting 
the variety commonly known as satin-spar. The veins are occasionally as 
much as two feet in thickness, from which they run along the bed of clay 
wherein they are formed, shooting out into a variety of ramifications like the 
roots of a tree, till they are lost at length in a wedgy termination. The stream 
which runs through the quarry abounds with chalcedonic flints variously coloured 
with red and gray, having a whitish coating, the result of partial decomposition. In ascending the mountain we come to a stratum of limestone of a 
moderately clear blueish gray colour and close texture, which is susceptible of a 
polish not of the highest kind; 
this stone is called here blue marble. Adjoining is a compound stratum of calcareous and other matter, containing numerous small pebbles, which is distinguished provincially by the appellation of 
*mulatto*, it being for the most part nearly white, minutely dotted with black 
and gray. In the more simple calcareous matter shells and various marine 
**exuviae** are by no means rare. I ascended this hill to a height sufficient to gratify my curiosity by procuring on the spot specimens of these several constituent 
parts, but did not ascend far enough to see the upper region and examine of 
what that is composed; in figure it is very much rounded. This mountain 
rises directly above the town of **Belfast**. 


The **Cave-Hill** is between three and four miles east of the town, along the 
north shore of the Bay. It is composed of a white limestone, with a summit 
of basalt, or trap as it is here more commonly called, an appellation derived 
from the German treppe, a staircase — the form which the basalt assumes in 
parts where it is not columnar, having often the appearance of vast steps. 
This mountain as well as **Divis** is intersected by a whin dyke. I ascended about 
half way up to a large limestone quarry, but did not reach the basaltic region, 
which is indeed only accessible by making a very long and toilsome circuit. The 
chalk is abundantly furnished with beautiful crystallizations of nearly pure carbonate of lime, which present themselves in veins: it abounds also with flints 


---

p.102



 
in a state of partial decomposition, they are mostly of a brownish-red colour 
approaching to hornstone. Amygdaloid is a prominent feature in several parts 
of this hill; its cavities arc chiefly filled with common quartz. The basalt 
approaches in its general character to the greenstone of the Wernerian school. 
The caves whence the name of the hill is derived are in a higher region than 
that to which I ascended. Great doubts are entertained whether they are the 
work of nature or of art. **Dr. Drummond** of **Belfast**, in the notes to his 
pleasing poem of The Giants' Causeway, is decidedly of opinion that they are 
the work of art, and his poetic imagination is disposed to render them the 
ancient habitations of some of the mighty warriors for which the country was 
celebrated, — some Ossianic hero; or perhaps the country-seat of the great 
Brian Boroimhe. I saw them not, so can form no opinion about them. 


While I was upon this hill I enjoyed the sight of a most beautiful phenomenon, of which I had often heard, but had never before seen it. A very 
heavy shower of rain came on, and the sun shining at the same time formed 
a most beautiful rainbow below, which seemed to lie upon the water in the 
Bay. The colours were particularly bright and vivid; and the breadth appeared double, or even treble that which the rainbow ordinarily appears. Even 
had I not been protected from the rain by a good plaid cloak, I would most 
gladly have purchased the gratification I experienced from so enchanting 
a spectacle at the expense of being wet through. It continued for a full 
quarter of an hour, so that ample leisure was afforded to contemplate it. A 
very fine view is presented from hence to the town of **Belfast**, and a considerable way beyond up the valley of the **Lagan** eastward, over the Bay to the 
county of **Down**, with the majestic **Mourne mountains** in the distant scene 
southward; and westward to **Carrickfergus** and the mouth of the Bay. From 
the top of the mountain in a clear day may be seen the **Isle of Man**, with the 
shores of **Galloway** and **Ayrshire**.


This hill I explored in my way from **Belfast** to **Carrickfergus**. I had intended 
setting out early in the morning, but found so much entertainment at **Dr. Macdonnell**'s breakfast-table, that I did not quit the town till twelve at noon. 
Between this delay and the time I spent upon the hill the day was so far advanced when I reached **Carrickfergus**, that I had thought of stopping there for 
the night; but I found the inn such a deplorably dirty disgusting place, that 
I determined — contrary to my usual practice of never risking being in the 


---

p.103



 
dark — to go on that night to **Larne**, and only stop at **Carrick** to bait the horse. 


It is needless to observe, that this town was once a place of very great note, 
giving name to the bay, which now has its name from **Belfast**. It stands upon 
the northern shore of the bay, not very far from its mouth. Here King William 
landed when he came to the defence of the country against the expelled monarch 
James the Second, and the foreign forces he brought with him; and the stone 
on which he first set his foot on landing is still shown as an object of veneration. 
There are large remains of an old castle, standing on a rock, not a very lofty one, 
of greenstone; once a very strong fortress: there are still guns mounted, with 
a small garrison, and stock of ammunition; but as no apprehensions of a siege 
are now entertained, the provision is not very ample. In the war of 1756 this 
castle was for two days in possession of the French under the celebrated adventurer 
**Thurot**; but it was soon retaken, and the cause amply revenged by the capture of 
the whole attacking squadron. At the time when I was at **Belfast**, three vessels 
belonging to the town had very recently been captured by American privateers. — 


The views all along the bay from **Belfast** to **Carrickfergus** are very beautiful. 


I had for many reasons taken a jaunting-car for this tour, as the most eligible mode of travelling. The road I was now going was not a very frequented one, and ill-suited to a four-wheeled carriage; 
in some places, indeed, it would have been scarcely passable for one; 
nor would a two-wheeled carriage, unless of the low construction of a jaunting-car, have been very safe. It had, besides, the recommendation, that, as I very often found occasion to dismount from my 
vehicle, the better to examine some object which engaged my attention, I should 
not have found any other so conveniently constructed for the purpose. The 
greatest inconvenience I experienced was, that I had by this means a driver 
unacquainted with the country; and as we were now to travel principally 
through bye-roads, they were not well furnished with direction-posts to guide 
us on our way. At **Carrickfergus** my servant had made inquiries concerning 
the road we were to take to **Larne**, and we set off accordingly. As I had 
studied the map of our route very attentively, we had not gone far before I began to suspect that we were not in the right road; we appeared going not sufficiently in a northern direction; and I observed to the servant that I thought 
we were wrong. He assured me that he had made very particular inquiries, 
and that we were certainly going the road we were directed. I was still not 


---

p.104



 
perfectly satisfied; but I suffered the carriage to go on nearly a mile further, 
when coming to the point of the estuary which separates a remarkable tongue 
of land, called **Island Magee**, from the main, between which and **Belfast-bay** there is only a very narrow isthmus, I saw plainly that we must be wrong; that 
we were going to the east of the estuary, whereas **Larne** was on the western 
shore. I had, therefore, just insisted upon turning about and measuring back 
our steps till some means of inquiry should present itself, when we spied two 
women coming towards us. When they came up I inquired whether we were 
in the right road to **Larne**. "Oh, by Jasus, no, my lady," they replied, "you 
are come quite the wrong way; and the clouds of the night will come over you entirely before you can get at all at all to **Larne**." They then gave us very 
ample directions for finding the proper road, such that no fears could be entertained of missing our way a second time; 
but we had to return two full miles 
in order to get into the road. To the honour of the Irish I must here observe, 
that in every part of the island through which I have travelled, whenever an 
occasion occurred in which we were obliged to inquire our way, the utmost 
anxiety was always shown to set us right, to give such ample directions as could 
not be misunderstood, and to assure themselves that they were perfectly comprehended; — unlike John Bull, who is far too much disposed to think he is showing great wit and humour under such circumstances by leading a person astray.


Our directors were perfectly right with regard to the clouds 
of the night; they 
did indeed overtake us entirely before we got to our destined quarters. One 
object had, however, been gained by going out of our way, to compensate, in 
some sort, the travelling for a full hour in the clouds 
of 
the night — that we had 
seen a very fine point of view round the northernmost entrance of Belfast lough. We had just sufficient light to see the view over the **Bay of Larne** in 
descending to the shore, and it would indeed have been a great loss to miss it. 
The descent is here very abrupt; and as the road takes a sudden turn before 
it comes to the shore, which cannot be seen from the top of the hill, especially 
as it began to be duskish, we seemed driving down directly into the water.


To make amends for what I had lost in entering **Larne** in the dark, the 
next morning I set off very early to walk along the bay, going as far back as 
**Glen Larne**, a little village at the distance of about a mile and a half, most 
beautifully situated on the borders of the bay, and mingled among trees in a 


---

p.105



 
manner to form a truly picturesque object from a point of the road about half 
a mile distant. Between this village and the town are considerable salt-works. 
The whole form of the coast here is very singular. From the bay of Larne 
runs down, in a southward direction, the estuary or loch which separates **Island Magee**, as it is called (though it is in reality not an island but a peninsula), 
from the main land; while from the northern part of the bay a neck of land, 
in the form of a sickle, called the **Peninsula of Curran**, runs down into the bay. This has often been likened to the celebrated Sicilian cape, **Drepanon**: 
nearly at its extreme point stand considerable ruins of Olderfleet-castle. This 
point comes within three quarters of a mile of the eastern shore of the bay, 
forming as it were a smaller bay within the large one. But it is at high water 
only that it is a bay; at low water it is a tract of mud. I was looking at it, the 
tide then being down, when a man accosted me with supposing I was a stranger. 
I replied in the affirmative: he then entered into conversation with me upon different subjects, till at length he adverted to the tract of mud spread before us. "Ah," said he, "what use is it now, neither land nor water — — if it was in England it wou'dn't long be thus." 
"What do you mean?" I asked. "What an easy thing," he said, "it would be to make an embankment along that narrow part; and all this tract, which is about 1600 acres, might then be thoroughly drained, and soon brought into cultivation: — so it would be in England, 
but there is no encouragement in **Ireland** to undertake such a work; the great people here think of nothing but getting their rents, they never think of improving the country." Indeed I thought the man was perfectly right in his 
idea of the practicability of rendering this now unproductive tract productive; how far he was right as to the rest I do not take upon me to say. For a short 
distance from the town the road runs along a sort of terrace, with fine meadow-ground sloping down to the very edge of the water, and a row of lofty ash-trees 
on each side of the road. The town of **Larne** is very prettily situated at the 
north-west corner of the bay. It is a much neater town than I expected to have 
found, according to the reports I had heard of this part of the country; and at 
the Antrim Arms I had a very clean comfortable sitting-room and bed-chamber, 
with the best bread I had met with since I had been in **Ireland**, and the most 
civil and attentive maid possible to wait. A small stream called the **Kilwalter** runs into the bay just at the entrance of the town.




---

p.106


#### 12


At the north-east end of **Island Magee** is a precipice known by the name of 
The Gobbins, varying from 200 to 230 feet in height. It is said to be a mass of 
basaltic rock, having a tendency to columnarity. I did not see it. This spot has 
been made by tradition the theatre of a dreadful massacre committed in 1641 
by the Puritan garrison of **Carrickfergus**, under their leader Munro, upon a number of Catholics inhabiting the peninsula. Three thousand persons, according 
to some accounts, thirty families, according to others, were precipitated over 
these rocks; and spots are still shown, called the blood of the unfortunate 
victims. That a dreadful atrocity was perpetrated by the garrison of **Carrickfergus** in this place is true; but from depositions made by the relations of the 
sufferers, which are now extant in Trinity-college at **Dublin**, it is ascertained 
that not more than thirty persons, instead of thirty families, fell, and that they 
were massacred in their own houses, not precipitated over the Gobbins. It is 
unnecessary to aggravate an outrage in itself sufficiently disgraceful. The 
circumstance of the massacre is mentioned by **Leland** the historian, in the 
third chapter of his fifth book, but he does not mention the precipitation over the rocks.


The **Bay of Larne** will admit vessels of between four and five hundred tons 
burthen. This is the only place in the long range of coast between **Belfast Lough** and **Lough Foyle**, in the county of **Derry**, where vessels can find shelter 
from the tempestuous north winds so prevalent in these seas. The rocks hereabouts are limestone; and in a large quarry near the town ammonites and 
pentacrinites are to be found in abundance. Gryphites are said also to be 
common, but I did not see any. To the north-west of the town are to be 
seen the towering and precipitous cliffs of **Agnew's Hill**, which are considered 
as the loftiest summits in the county of **Antrim**. 


Quitting **Larne**, a hill is soon ascended, whence there is a very fine view 
over the bay and the hills around it. The bold promontory of **Ballygelly** soon 
after appears to the right, and continues frequently in view till near **Glenarm**. Below the promontory are the ruins of Cairn-castle, situated upon a rock 
which at high-water is insulated. Here, according to tradition, one of the 
mighty chieftains of old shut up his daughter, considering her secure against the 
attempts of a lover, who, as has been very often the case, and probably ever 
will continue often to be the case, did not find so much favour in the eyes of 


---

p.107



 
the old gentleman an as in those of the young lady; but, as also most commonly 
happens in these cases, the ardour of youth was mightier than the vigilance of age; 
paternal cruelty was baffled, and notwithstanding the massive walls of the 
castle, and the mighty force of the billows which dashed against their rocky basement, the lover at length succeeded in bearing his mistress away triumphantly 
in a vessel. To the left of the road here the **Salagh braes** sweep majestically 
from north to south in an amphitheatral form; these are limestone mountains 
topped with basalt, the articulation of the masses being in some places very distinct. 


A very high hill is ascended about a mile and half from **Glenarm**, and descending it again, at a turn of the road, the town appears suddenly in view at 
the end of a beautiful deep wooded dell which runs by the road side, through 
which flows a very pretty little stream murmuring down the declivity. The chateau and grounds belonging to the Antrim family form a distinguished feature in this scene; the deer-park runs beautifully along the opposite side of 
the dell. The town is a shabby one, full of ruined houses, not venerable remnants of antiquity, but buildings, comparatively modern, fallen to decay, giving 
the melancholy idea of a town in a state of complete decadence. I however 
found a very decent inn, and got excellent chickens ham and pease for dinner. 
Indeed in all these small places I found chickens much easier to be obtained 
than butchers' meat. I had intended attempting to see the castle, where are 
some curious ancient swords, and part of the vertebrae of a whale; but going 
first upon the shore of the little bay, my attention was so much arrested by other 
objects that the time was soon past which I had allotted to stopping here. 
As if every thing connected with the shores of this extraordinary corner of the 
globe was of a gigantic nature, I found marine plants of a size so enormous 
that every thing of the kind, which before I had thought vast, were dwindled into pigmies; — they were besides of a totally different kind from any I had seen 
before. Part of the principal stem of a leaf which I picked up and carried away 
with me, but afterwards unfortunately lost, measured nearly four inches in circumference. I was not more fortunate with two immense leaves which I brought 
away, one measuring above three yards in length; in consequence of being continually moving from place to place, they could not any where be hung up for 
a length of time sufficient to dry them, and before I got to my journey's end 


---

p.108



 
they were in a state of entire decay. The shore is very pebbly, without any 
land. A number of women and children were occupied in gathering up 
pebbles and making little heaps of them out of reach of the water. I inquired whether they were intended for mending the roads; 
they said No, they were to be sent to Liverpool for making china. On inquiry afterwards at Liverpool I 
learnt that this was very true. I found them upon examination, to be both of 
flint and of amygdaloid. The latter seems to form an essential component 
part of the hills hereabouts, since abundance was laid upon the roads to mend them.


From hence the road continues close along the shore all the way to **Newtown-Glens**, as it is now called, formerly known by the name of **Cushendall**. 
On quitting the inn at **Glenarm** I observed a gentleman standing by the door, 
who made me a very civil bow as I passed, and wished my servant a good journey. 
This led me to inquire of the latter who he was; when he told me that he was 
a Scotch gentleman, who had landed two or three days before at **Donaghadee**, 
and had come that morning from **Belfast**; that seeing my vehicle at the door 
his curiosity was awakened, and that he had made many inquiries about me and 
my mode of travelling. At some distance from **Glenarm** in ascending a considerable hill my attention had been attracted by some mineralogical objects, 
and having descended from my car I was loitering about to examine them. At this moment the same Scotchman passed on horseback, and again saluted me by taking off his hat; he rode on, and when I had satisfied my curiosity I remounted my car and pursued my course.


Till Garron-point, which is about half-way between **Glenarm** and **Newtown-Glens**, the mountains do not come to the very edge of the shore, but the road 
runs upon a sort of terrace at some height above the sea, with a little space of 
corn-field between that and the water's edge, and the towering basaltic summits 
rising on the other side. **Garron-point**, which forms the southern boundary of 
**Red Bay**, is one of the most remarkable spots along this eastern coast of **Antrim**; perhaps it may be called as extraordinary a sport of nature as can any 
where be seen. Rising from the beach is an enormous mass of rock, which, 
though in the limestone region, seems to be basaltic; it has exactly the appearance of having glided gently from the mass above, and one end having reached 
the ground the side has rested against the rocks below, where it remains in the 


---

p.109



 
maimer of an inclined plane, the other end rising above the rocks against which 
it rests, leaving a hollow space between that and the mass above just sufficient 
for the road. Down this hollow is I think the steepest piece of carriage-road 
I ever saw, unless it be another corresponding with it on the opposite side of the 
Bay. I did not attempt to go down in the car; in fact we all dismounted, and 
while the driver led the horse my servant held back the carriage as much as he 
was able. We were informed that not very long before, two gentlemen in a gig; 
not having used the same precaution, had narrowly escaped with their lives, from 
not being able to keep the horse up properly. From this point the road runs 
along the south side of **Red Bay** at the foot of the mighty rocks. 
by which it it 
bounded, and which are nearly perpendicular masses of basalt. The whole 
shore is overstrewed with broken fragments of rock, which look like the ruins of 
nature; sometimes the road is at the very edge of the water, at others it is 
carried over a steep crag or ledge of rock. On the summit of one of these 
short but steep ascents is a most remarkable rock, which at a little distance 
has the appearance of being the colossal statue of a venerable bishop sitting 
with his canonical three-cornered hat and episcopal wig upon his head, and 
the full lawn sleeves on his arms. The highest points of this chain are distinguished as **Craig Murphy** and Sliabh (pronounced Slieve, and meaning a mountain) Barraghad. After coasting the south side of the Bay the chain continues to run along a wild and romantic valley called **Glenariff**, the scene, according to tradition, of some of the great achievements performed by the hero 
Oisin or Ossian; and indeed such is the wild appearance of this valley that it 
seems the proper theatre for feats so wild and romantic.


After having continued for a length of way along this broken rugged road, 
one is not a little surprised immediately on turning round the south-west corner 
of the Bay, to find for a short distance a broad strand of fine hard sand, and 
for about half a mile a deep sandy road. Coming to the northern shore of the 
Bay the rocky country is renewed; but it is no longer the vast perpendicular 
masses of basalt, they are exchanged for rocks of a deep red calcareous sandstone. Among them are several natural excavations, looking like the arches of 
a bridge; in two of them the fishermen have formed themselves habitations, 
but it must be owned they are very wretched ones. In the smallest, water is 
continually dropping from the little vaulted roof above into a bason below, so 


---

p.110



 
that the whole arch is incrusted over with stalactite, from which minute inverted 
pillars already hang, and will in time no doubt, if not molested, reach to the 
ground. After remounting a very steep ascent, corresponding with that at Garron-point, the road runs along heights till it descends to the little town of **Cushendall** or **Newtown-Glens**. This town, like **Glenarm**, bursts all on a sudden 
upon the view at turning an angle of the descent; but its situation is not by any 
means so beautiful and picturesque as **Glenarm**: the dell in which it stands has nothing particularly striking in it.


As we approached the town we perceived that it was thronged with people, 
and on inquiry learnt that it was the time of a fair. We proceeded to the principal inn, if inn a very paltry public-house might be called, where the first object 
that presented itself was the Scotch gentleman whom we had seen at **Glenarm**. "Madam," he addressed me, "I am sorry that my efforts to serve you have not been more successful. As I passed you on the road I observed you to be much occupied with some objects which had engaged your attention, and it struck me that it might perhaps be late before you would reach **Cushendall**: I hastened forwards, in hopes that arriving in good time I might have the satisfaction of securing you a bed, but there is not one to be had at any public-house 
in the town." I was struck with this very kind piece of attention in an entire stranger, and made proper acknowledgments for it: the intelligence, however, which accompanied it was not pleasant, since it was already quite dusk, and 
time to think of stopping for the night. In thanking my Scotchman I therefore consulted with him, as I found he was acquainted with the country, what was to be done. He advised if possible to get a private lodging, as he said there 
was no place nearer than **Cushendun**, which could not be reached for more than 
an hour, and there was only one very poor public-house, where perhaps we might 
not get accommodations; while the place was so small that there was no ressource if we could not. Inquiry for a private lodging was then made; but every 
bed in the town was engaged, and I began to think that the night must be passed 
in the street sitting in my car. At length, however, a miserable little parlour, as 
it was called, was procured through the interest of the landlady of the inn, and 
thither I went. The question now was, what was to become of our kind and 
attentive Scotchman, and of my servant and driver, since accommodations for 
them were no more to be had at the inn than for myself: it was with some difficulty 


---

p.111



 
that room in a stable had been made for the Scotchman's horse and 
mine. I requested the Scotchman to sit down with me in my parlour; but it 
was not without difficulty that two chairs were procured with a table and apparatus for tea; and for a time it appeared as if we must have sat together here for 
the night, or perhaps have been joined by my servant and driver sitting on 
the floor, who would otherwise run the risk of being left without a roof to shelter them. However, at length another arrangement was made; a bed and bedding was found for me which were deposited upon the floor, while the Scotchman and the two servants retired to a straw-loft. My Scotchman and I, however, drank tea together and entered into conversation, when I found him a very 
pleasant intelligent man, well acquainted with the country I was exploring; 
he indeed pointed out to me two or three objects of interest in my route, which 
I had not heard of before, and of which but for this whimsical interview I had never known. 


At six the next morning, August 17th, we both quitted our lodging-rooms, 
and wishing each other a more prosperous continuance of our respective journeys, 
he mounted his horse to proceed directly to **Ballycastle**, while I ascended my 
car taking the road to **Cushendun**, a place I wished to visit on account of some 
curious caves there. I had indeed been much advised at **Belfast**, if the weather 
should be favourable when I reached **Cushendun** to send my car on to **Ballycastle**, and taking a boat myself to sail to the little island of **Rathlin** off the 
coast opposite to **Ballycastle**. By pursuing this navigation I should have had an 
opportunity of seeing some remarkable parts of the coast which could not be 
seen in going to **Ballycastle** by land, particularly a bold and fine head called 
**Tor Point**. Upon it stand the ruins of an old tower, that of **Dunavarre**, which 
according to the traditions of the country was built by giants: at a little distance is a sort of tumulus which has the appellation of **Sleacht-na-Barragh**, or the Giants' Grave. This tower is believed to be very ancient, and supposed by 
some antiquarians to have been consecrated to the sun, the worship of which 
there is very strong reason to believe anciently prevailed in **Ireland**. **Tor Point**, however, I could only see at a great distance; — all question of undertaking the 
aquatic excursion purposed was soon settled on my arriving at **Cushendun**, since 
there was no boat to be had. If for a moment I regretted missing a navigation 
which I had been taught to believe would prove extremely interesting, when I 


---

p.112



 
afterwards became better acquainted with the sea which I must have traversed, 
I found ample reason to bless my fortunate stars which had put so decided a 
negative upon it.


The country between **Cushendall** and **Cushendun** exhibits a very different 
character from that over which I had travelled the day before. The acclivities 
are much less abrupt; there are no masses of naked rock; the slopes are all 
well clothed and cultivated: the whole face of the country, for the four miles 
between these two places, brought very much to my mind the district of **Le Forez** in **France**. **Cushendun-bay** is the termination of one of the numerous 
little valleys that intersect this coast. A rapid stream runs through the valley, 
which empties itself into the bay. This stream is remarkable for its waters 
having the same dark hue that is almost always observable in streams rolling at 
the bottom of wooded dells, over broken masses of rock: though the same 
cause does not exist here to produce the effect; for the sides of the stream are 
neither abrupt nor wooded, and the depth of water at the mouth is considerable, notwithstanding which it has the same dark hue. On one side of this 
stream the shore is flat and sandy; on the other, but not directly above it, are 
lofty rocks of breccia, or pudding-stone, consisting of quartzy pebbles embedded in a very hard reddish sandstone cement. Some of these pebbles are 
extremely large. The caves run for a considerable way within the rocks; but 
no part of the interior presents any other appearance than the same pudding-stone material. To the eye it would appear as if the pebbles might be easily 
removed; but when the hand is applied, they are discovered to be so firmly 
fixed in their rocky bed, that without tools, and very strong tools, it is impossible for them to be wrenched out. Vast masses of the rock occasionally fall; 
many were lying on the shore: but the pebbles are not loosened by the shock, 
they still remain firmly fixed. Such of these rocks as are covered at high 
water were studded all over with small shells-of the nerite tribe. Here again 
were lying on the shore seaweeds of the same gigantic nature that I had seen 
at **Glenarm**. This is an excellent part of the country for game; on which 
account Lord O'Neale, the proprietor of Shanes Castle, has built a little 
shooting-box very near the shore, whither in the season he often comes to 
shoot. I found that I had done very right in not attempting to come on hither 
the night before; for so many people had come on account of the difficulty of 


---

p.113



 
finding lodging at **Cushendall**, that the greatest part had been obliged to sit up 
in the kitchen all night. The New Travellers Guide in Ireland, published in 1815, gives a list of all the fairs held in the different parts of the country. A traveller would do well to consult this list; and wherever he is going, arrange 
his journey so that he may not fall in with a fair at any place where he proposes stopping for the night. The mass of fairs all over the country is prodigious.


Quitting the valley which runs down to **Cushendun-bay**, a very different 
character of mountain is presented, strewed all over with broken masses, 
chiefly of micaceous slate. These blocks exhibit great variety in their colouring, from the different matter with which they are impregnated; some, from 
the presence of oxydated iron, are of a bright red; while mixed with the 
quartz, with which they are everywhere veined, pyrites is occasionally to be 
found. With the masses of mica-slate are many of sand stone, both calcareous and siliceous; the latter frequently containing a considerable quantity of ferruginous matter. They appear referable to the primitive class of rocks, and 
have sometimes a close resemblance to granite. 
After a long-continued ascent, all among these scattered fragments, and 
having at length attained a pretty considerable height, an immense extent of 
boggy country is presented to the view — over a widely-extended horizon nothing but continued bog is to be seen; not any thing like a village or human 
habitation, all is dreary waste. This continues for three or four miles, in all 
which distance only one object presented itself that engaged my attention; 
this was the species of **juncus**, vulgarly styled the cotton-plant, from its emitting 
a substance of a cottony nature. It was a plant wholly new to me, and was 
growing in great abundance. Such is the loose nature of the soil here, that in 
looking attentively at the road, a gentle undulation is evidently discernible from 
the motion of the carriage. 


About three miles from **Ballycastle** the face of the country begins somewhat 
to mend, and some appearance of cultivation is to be seen: the waste is, besides, relieved by the view of the sea on the north shore of **Antrim** opening, 
with the noble promontory of **Benmore**, or **Fairhead**, and the little island of 
**Rathlin**. About half a mile from the town I was again surprised, in a region 
where I expected to find nothing but rock, with coming upon a short space of 


---

p.114



 
entire sandy beach, and a very heavy sandy piece of road. The approach to 
**Ballycastle** is pretty, the road running for about a quarter of a mile under a 
verdant archway, formed by two rows of ash-trees which border the road. 
Here I arrived about two o'clock, most fortunately just as a heavy rain commenced, which continued for the rest of the day, detaining me a close prisoner. 
It afforded me, however, an excellent opportunity for looking over, arranging, 
and packing the minerals I had hitherto collected. I found a very comfortable 
hotel; and had from my window a full view of the noble promontory of **Benmore**, distant about four miles.




---

p.115


Ascent of the Mountain **Knock-Laid**. — The Limestone Quarries, and Organic Remains. — Plants and Mosses. — Promontory of **Benmore**, or **Fairhead**. — Alarming Adventure of a Gentleman and Lady there. — Migration of the Eels. — The Island of **Rathlin**. — Its turbulent Sea. — **Doon-Point**, and its Basaltic Pillars. — **Ushut**. — Burning Kelp. — Visit from Mr. Conolly, Minister of **Ballycastle**. — The Fata Morgana. — The Collieries.
#### 13


A striking feature in the scenery, on approaching **Ballycastle**, is the mountain **Knock-Laid**, which rises close to the town, towering far above all the 
other summits by which it is surrounded. This mountain had never been mentioned by any one who had talked to me of the county of **Antrim**; perhaps, therefore, being a very conspicuous feature, it caught my attention the more 
earnestly, and having rather a taste for ascending mountains, I began immediately to speculate in my mind upon visiting its utmost height. Upon this subject I held a conference in the course of the afternoon with my landlord at the 
hotel. He said that the mountain was perfectly accessible, going to a certain 
point with the car, when I must quit that and walk the rest of the way. Not 
many people, he said, chose the trouble of going to the top; but if the day 
happened to be clear, there was a very fine view to the **Isle of Man** and coast 
of **Scotland**, one way; to **Lough Neagh**, another; and to the mountains in the 
county of **Donegal**, another. He offered, at the same time, to accompany me as 
a guide, since without some one to direct I might not take the best way. All was 
soon arranged; it remained only to see whether the weather, which had not then 
a very favourable appearance, would permit the execution of the scheme. 


The sun did very good-humouredly shine upon it: to the wet evening succeeded a very fine morning; and after an early breakfast we set off. The 
track, for road it could not be called, from the foot of the hill to about halfway up, was certainly practicable for a carriage, for mine did get over it with 
safety; but indeed between the stony parts, which we had sometimes to jumble 
over, and the deep sloughs through which we had to wade at others, I was 
 


---

p.116



 
rather surprised that no accident happened. At a farm-house we quitted the 
car, leaving it there for protection, and commenced the pedestrian part of the 
expedition. On this we had not proceeded far before we perceived a man 
running 
hastily after us. We stopped till he came up, and then learnt that 
he was son to the farmer where we had left the car. He had seen us at **Cushendun** the day before, and had fallen into conversation with my servant; and the 
moment he saw the car again recognized it: when, finding we were going up 
the mountain, he very civilly came to offer his assistance in directing us the 
best way; since he, living as he did upon the spot, was perfectly acquainted with every part of it. Indeed he was of essential service: but for the 
assistance I received from him and Mr. Fullerton, (the master of the hotel,) I never could have reached the summit. A considerable part of the mountain is 
so boggy, that it is no easy matter to pick a way over it: not unfrequently my 
two squires stood half-way up their boots in water, to assist me in jumping from 
one spot where there was firm footing to another. More than once I was half-disposed to abandon my undertaking; but my guides piqued themselves so 
much upon conducting me through it, that I persevered, and at length reached 
the **cairn**, as it is called, a heap of stones piled up pyramidally, which marks 
the highest spot on the mountain. It is called cairn-an-truir, or the cairn of 
the three, but no tradition records who the three were. 


I sat myself down upon the stones, and indeed enjoyed a rich reward of 
my toils in the noble view spread before me: not that it was quite as clear as 
might have been wished; for **Lough Neagh** was not visible, nor was the **Isle of Man**, but I could nevertheless see over an immense extent of country, including some very interesting objects. **Benmore**, which appeared so magnificent 
as I saw it from my window at the hotel, here seemed nothing; that is 631 
feet above the level of the sea, and we were now at the height of 1500 feet. 
We could see over the whole island of **Rathlin** as if it had been in a map, and 
the wide waste of bog over which we had travelled the day before, while appearing extremely contracted in extent, had at the same time lost half its dreariness. Westward, the whole line of coast with its numerous broken basaltic 
promontories was to be seen distinctly, as far as the **Innishowen mountains** 
in the county of **Donegal**. But what I most eagerly sought, the **Giants' Causeway**, was not visible, it was concealed by the two lofty promontories between 


---

p.117



 
which it runs. The **Mull of Cantire** and some other parts of the Scotch 
coast appeared close by. I took two pieces of stone from the cairn, on each 
of which I engraved my name with the day of the month and year; one I left 
for the information of any future wanderer who may be seized with a wish of 
undertaking the same adventure, the other I brought away to preserve as a 
relic. The head of this mountain is very much rounded, so that it was only by 
taking a mathematical measurement that the highest point could be determined. 
In ascending, repeated disappointments are experienced, when in reaching 
what at a little distance appears the summit, instead of proving so, it is found 
to be only a shelving of the mountain leading to another and more arduous 
ascent. On the declivity are two small quarries of limestone remarkably pure 
and white; the stone abounds with belemnites, but I found no other organic 
remains. In some of the most boggy parts pieces of quartz were scattered about, 
remarkably white and transparent, scarcely inferior in beauty to alabaster. I 
also found a great variety of mosses, one of a description I have never seen 
elsewhere. Here too the cotton-plant was growing very luxuriantly, and there 
were abundance of whortle-berries and bilberries; — the former of these are called in the country **Fruckogs**, the latter **Monags**.


The weather did not remain wholly favourable, we had two pretty smart 
showers while we were upon the mountain, so that between the wet from above 
and that I had to wade through below, I was obliged entirely to new dress myself when I got back to **Ballycastle**. This done, I once more mounted the car 
and proceeded to the summit of **Benmore**. Near the road going thither are 
some trifling remains of an abbey once of great note in these parts, that of 
**Bona-Marga**, but they are so insignificant as to be scarcely deserving of notice. 
Before the Rock-heads were reached I was again obliged to quit the car, and 
pursue my way on foot. Two boys ran after us from a cottage which we had 
just passed, who we found considered themselves as privileged guides; and 
under their conduct we went round the whole head of the promontory, which I 
found much more extensive than could have been supposed from seeing it at a distance. 


This promontory is better known by the name of **Fairhead** than of **Benmore**. 
It is improperly called by the former name; that really belongs to another 
head, two miles to the west of **Ballycastle**, **Kenbann**, which signifies *Whitecliff*. 


---

p.118



 
It is a limestone rock, with the ruins of a castle on the summit. **Benmore** has the same signification as *Penmaur* (for so, and not *Penmanmaur*, 
ought the rock in **Wales** to be called), that is, *high mountain*, a name very 
properly applied to such an object; whereas **Fairhead** ill applies to a dark 
towering mass of basalt. It is indeed awful to look down this precipice: I 
could not have done it standing, I was obliged to go upon my hands and 
knees to get near the edge. On a superficial view it might be pronounced that 
the basalt here is not columnar, but on an accurate survey it is evidently seen 
to be so. The columns are prisms of four sides; and being closely wedged 
together, they present a level front which easily deceives. The tallest of these 
columns measures 233 feet in height; two of the sides measuring thirty-three 
feet in breadth, the other two thirty-six. It appears to be the highest mass of 
stone so perfectly characterized at present known in the mineralogical world. 
The base on which this enormous mass of pillars rests, rises 398 feet above the 
sea, so that the whole height of the promontory at this point is 631 feet. In 
one part is a fissure in the basaltic mass, down which a path called the Gray 
Man's Path, leads to the foot of the precipice; a vast pillar has fallen and 
rested on the other side, forming an arch over it, but it is fixed so immovably 
that there is no danger to be apprehended in passing underneath it. From 
the foot of the basalt the rock slopes down to the sea, and the whole of this 
part is scattered over with broken fragments, which really appear like the ruins 
of some structure formed by the hands of giants. The regular prismatic 
forms of these fragments serve to confirm the columnarity of the mass from 
which they have fallen. I did not go down the Gray Man's Path, as both the 
descent and ascent are fatiguing; and having the intention of sailing round the 
Head the next day, there was no object to be attained by taking a less perfect view of it.


About a twelvemonth before, a gentleman and lady came to visit this promontory, but would not suffer any of the people about to accompany them as guides. 
They descended the Gray Man's Path; it was then growing dusk: when they 
had satisfied their curiosity below, and sought the path to reascend, they could 
not find it: in vain did they wander backwards and forwards, the path was not 
to be discerned: complete darkness soon came on, and the night was passed 
by them among this ruined heap of fragments, with the sea roaring at a great 


---

p.119



 
depth below, they afraid to stir lest a false step might have proved their destruction; — as the climax of the adventure, the lady was considerably advanced 
in pregnancy. What must have been their sensations at seeing daylight again 
dawn upon them! — what a blessed deliverer must the glorious sun have been 
hailed! — It is very unwise to go about places where danger may be incurred, without a proper guide. 


The basalt here is not so pure as in many other parts; 
it is coarse-grained, 
having sometimes almost the appearance of granite, and occasionally containing augite. I know not what kind of stone constitutes the base of the rocks; 
probably sandstone, since that occurs both to the east and west of the promontory. Not far from it, on the western side, lie the collieries, but I did not visit 
them till two days after. Upon the head of the promontory, and near the brow, are two small pools of water, or lochs as they are called, connected together. 
From that nearest to the edge of the rock a small rill trickles down to the sea, 
up which the young eels, when not thicker than a small packthread, ascend to 
the lochs, where they remain and thrive exceedingly. This migration of the 
little fry, extraordinary as it may appear, up so great a height and so rapid an 
ascent, is a well established fact. The thing is so notorious and occurs so regularly, that against the time when they may be expected the peasantry lay 
haybands down along the rill to assist the tender navigators in their course. 
The same thing occurs at other places along the coast. A variety of heath plants 
grow on the tops of the rocks, and mingled with them cranberries, though not 
in great abundance; — they were now just beginning to turn red. 


The next day, as I was told by the fishermen (the only mariners of the place) 
that the weather was remarkably favourable for sailing round the Head and to 
the island of **Rathlin**, I engaged a boat and set out on my voyage. Though 
very desirous of visiting this island, and very glad when I was safe back again 
that I had been there, yet I believe if I had previously had any idea of the sea 
I was to navigate, I should entirely have relinquished the idea of venturing 
upon it. Round the Head the swell of the sea was very powerful, sufficient to 
*give me* a sensation of fear, to which I am not subject upon the water; but 
once round, all was calm again, and the rocks form a most sublime spectacle indeed; a boat can go almost close to their foot. We landed on the other side 
of the promontory, and walked about for near an hour till the tide would serve 


---

p.120



 
for going to the island. If I thought the swell round the Head extraordinary 
and awful, how much more tremendous appeared the monstrous waves by which 
we were now surrounded for the greater part of the voyage. I was disposed to 
be very angry with the boatmen for having, as indeed I thought they had, deceived me in the state of the weather, and enticed me out when the sea was so 
violently agitated. They assured me that what I saw was nothing, that they 
considered the sea as very quiet, and begged me to notice that there really was 
no wind, scarcely sufficient to fill the sails. So far was certainly true, the breeze 
was as light as possible, but the sea notwithstanding rolled in mountains; 
 — of 
such a swell without wind I could not have formed an idea if I had not seen 
it. To add to the misery of the thing, we were obliged to tack repeatedly in 
order to make the island, so that we were thus tossed about for a most tedious 
length of time. Indeed, I began to think that instead of being off the coast of 
**Ireland** I was off that of **Sicily**, and had fallen into the vortex of Charybdis. 
To the fishermen who are accustomed to this sea its present state was mere 
play, and they seemed astonished that anybody could be alarmed; but I, who now 
saw it for the first time, could almost say that what was play to them was death 
to me. I do not know that I ever felt so alarmed upon the water, inadequate 
as our frail bark appeared to stemming such a mighty force: but we did stem 
it, and I am alive to recount my fears. It should seem that the true cause of 
this extraordinary effect is yet among the hidden secrets of the deep, for no attempt hitherto made to explain it is by any means satisfactory. To ascribe it 
to the narrowness of the channel is far from being so, since that is eight miles 
over[10](javascript:footNote('E810001-001/note010.html')), and no such effect is seen in many a channel not approaching to that 
breadth. A great conformity is said to exist between this sea and the straits 
of **Reggio** which divide **Sicily** from **Italy**. The same occult causes may very 
probably subsist in both, and, yet undiscovered, will most likely ever remain so.




---

p.121


#### 13


This island is variously named by different writers; — the most common name 
is **Rathlin**, it is considered as the **Ricina** of Ptolemy. By some it is called 
**Raughlin**, by others **Raghery**. **Mr. Newenham**, who seems not to have informed himself better with regard to its name, than its distance from the Irish coast, 
calls it **Rachlin** or **Rachree**. Its form may be designated as that of a half 
horse-shoe; its length from one extremity to the other is five miles, in no part 
does its breadth exceed a mile. It is a very commonly received opinion that 
it was at a remote period torn from the adjacent coast of **Ireland** by some violent convulsion of nature, this theory being chiefly drawn from urged analogies 
between the geological construction of the island and the parallel shores of **Antrim**. Against this it may be urged, that the character of the basalt which constitutes the upper stratum in the greater part of the island, is very different 
from that at **Benmore**: the stone is of a much finer and closer texture; and 
instead of being divided into vast quadrangular prisms, we have here the regular columnar formation that distinguishes the **Giants' Causeway**. **Doonpoint**, which is a small promontory at the east end of the island, and lying directly opposite to **Benmore**, is composed entirely of these pillars: the great difference between them and those at the Causeway is, that whereas the latter all 
stand perpendicular, here some are curved, others lie horizontally, others again 
rest in an inclined position without any curve: the whole promontory bears a 
strong resemblance to the ribs which form the keel of a vessel standing inverted[11](javascript:footNote('E810001-001/note011.html')). Nothing is to be seen above the water but the pillars; it is probable that 
they rest on a base of white limestone, since northward of the promontory appear cliffs of that stone. In going from **Ushut-point**, where we landed, to 
**Doonpoint**, I got from the cliffs which surround a small loch, pure gneiss, and 
imperfectly-formed red ochre. Near **Ushut-point** is a considerable range of 
pillars all lying horizontally. **Mr. Hamilton**, in his Letters on the County of Antrim, says, that at Church Bay, which lies at the bend of the island, "there is 
a heterogeneous mass of freestone, coals, iron ore, &c. the same as is to be found on the east side of Ballycastle Bay." I did not go so far into the island, so can say nothing of it. The broken fragments of rock scattered over the 
 


---

p.122



 
beach at **Doonpoint** were many of them studded all over with shells of the **nereis** tribe, and a profusion of small corallines of the **gorgonia** genus were adhering to other masses. About **Ushut** I collected shells of the genera **Buccinum**, 
**Cerithium**, **Patella**, **Venus**, **Helix**, and **Nereis**. To the north-east of the island, 
half way between that and the Scotch coast, it is said that a group of basaltic 
pillars is seen rising just above the sea.


The surface of the island is estimated at two thousand acres, and the number of inhabitants at twelve hundred. Inhospitable as it appears, standing in 
the midst of such a turbulent and tempestuous sea, the inhabitants are not less 
attached to their dreary and desolate home than those that dwell under the most 
auspicious and benignant sun; they would consider being sent to live in **Ireland** 
as a painful exile. A small but delicious breed of sheep are fed here, and some 
barley is grown; but the great support of the island is the quantity of kelp 
burnt. The export of it is estimated at not less than a hundred tons annually, 
which is chiefly bought by the linen-bleachers at the price of five guineas the 
ton; the manufacture of it is carried on principally by the women and children. 
The sea-weed is cut from the rocks at low water, and spread out in the sun to 
be dried. At night it is made up into heaps, which are spread out again in the 
morning; and this process is continued till it is dried sufficiently to be burnt. 
A hole is then made in the ground and a temporary kiln constructed of loose 
stones for burning it: in this process the vegetable salt separates from the 
other matter, which is destroyed by the fire, and coagulates at the bottom of the 
kiln. This is the state in which it is exported; — the islanders have not yet learnt 
the art of purifying the alkaline salt from the marine salt with which it is incorporated. The shores are frequented by a vast number of sea-fowl.


A monastery was of old established here by Saint Columba, which was destroyed by the Danes: and barren and inhospitable as the island is, it has often 
been made the subject and theatre of contention between the Irish and Scotch. 
A tradition is preserved that at a place called **Sloc-na-Calleach**, all the old women of the island were once precipitated over the rocks, at the command of a 
Scotchman of the Campbell clan, by name MacNalreavy. Some people may 
perhaps think there was no great harm done, since the atrocity fell only upon 
the old women. During the contest for sovereignty in Scotland between **Robert Bruce** and **John Baliol**, the former sought an asylum here in a castle at the 


---

p.123



 
north-east part of the island, which was thenceforward called after him **Bruce Castle**; some remains of it are still standing. Spear-heads and ancient swords 
have occasionally been dug up in a small plain about the centre of the island. 
From **Doonpoint** the Scotch coast was seen so plain, that without the assistance of glasses we could distinguish the white foam dashing up against the cliffs. 
Our mariners, in amusing themselves with my apprehensions of the tremendous 
sea, said, that the women of **Rathlin** would row themselves over from thence to 
**Ballycastle**, in a much more frail vessel and with much worse weather, without having the least idea of danger, or that they were engaged in an adventurous undertaking: — such is the force of custom.


As I embarked in the morning I observed standing on the shore a lame gentleman having the appearance of a clergyman, who seemed rather occupied 
with the embarkation; and as I was sitting in the evening after my return home 
I was surprised by a visit from him. He was, I found, the clergyman of the 
place, by name Conolly, and having learnt who I was, and that I was travelling 
to explore the country, he came very politely to offer me his services in anyway that they might be rendered useful, expressing regret that he had not 
sooner known of my being in the place, so that his offers might have been better timed. I found that he was the author of some pretty little poetic tales founded 
on the legends of his country, with a copy of which he was so obliging as to 
present me. With him I had a great deal of conversation on that extraordinary catoptric phenomenon the Fata Morgana, which is occasionally seen on 
this coast as well as in the Straits of **Reggio**, to which it is so often compared. 
He said that he could not boast himself of ever having seen this beautiful delusion, but he had talked with persons of great credibility by whom it had been 
witnessed. It was in summer evenings, when the clouds appeared remarkably 
electric; appearances then exactly resembling castles, ruins, tall spires, groves 
of trees, rocks, and other terrestrial objects seemed to sail rapidly along the 
surface of the sea from the east to the west, remaining for a length of time sufficient to give assurance that such appearances actually existed, that they were 
not the mere effect of strong imagination; — at sunset they wholly disappeared. 
This curious optical delusion seems to bear a strong analogy with one described 
by **Professor Lichtenstein** in his Travels in Southern Africa, (see English Translation, page 169.) as seen by him and his party, and which he learnt from some 


---

p.124



 
of the inhabitants of the country was not exceedingly uncommon in those parts. 
A long account of the Fata Morgana may be seen in Dr. Rees's Cyclopedia, to 
which the reader is referred. Various particulars relative to it are also given 
in the notes to **Dr. Drummond**'s poem of The Giants' Causeway. It is probable that many fables now in general circulation along this coast owe their 
origin to these actual appearances. In 1748 a book was published by a 
gentleman residing near the **Giants' Causeway**, in which a curious detail is 
given of an *enchanted island* seen annually floating along the coast of **Antrim**, 
of which it is said that a sod thrown on it from the terra-firma would fix it 
for ever. Attempts have been made at various times to throw this sod, but 
hitherto all have proved abortive. At **Rathlin** a belief prevails that a green 
island rises every seventh year out of the sea between their island and the promontory of **Bengore**. The inhabitants assert that many of them have distinctly 
seen it, and that it is crowded with people selling yarn and engaged in various 
other occupations common to a fair. As I purposed leaving **Ballycastle** the 
following day, Mr. Conolly obligingly desired that I would first breakfast with 
him. He observed that in ascending **Knock-Laid**, and going over to **Rathlin**, 
I had done two things scarcely ever thought of by travellers in those parts.


The next morning I set off at six o'clock to visit the collieries, which lie about 
two miles east of the town, between that and **Benmore**: the road lies along 
the strand at the foot of the cliffs. Within less than half a mile of the collieries we found it completely blocked up by an immense downfall of the cliffs 
which had happened in the night, between three o'clock, when the road was perfectly clear, and the time that I saw it; 
 — fortunate indeed was it that it did happen in the night when no one was near, since inevitable destruction must have 
been the fate of any one on the spot. Indeed it was at once an awful and 
sublime spectacle to contemplate, accompanied with a grateful feeling to Providence that the accident had not happened just at the moment when I was 
passing beneath. Immense masses of stone had fallen, which could not be removed again but at the expense of vast labour. It was impossible for the car 
to proceed any further; so quitting that, I was obliged to go on foot round the 
sort of promontory formed by the ruins, which extended over the rugged stony 
beach to the very edge of the water; indeed had not the tide been down, it 
would have been scarcely possible to get round it at all.




---

p.125


#### 13


My wish and intention had been to penetrate into the recesses of the mines; 
but upon inquiry into the practicability of doing so, I found it expedient to 
abandon my purpose. When I mentioned the idea to the surveyor who was 
walking about with me, he stared, and seemed quite astonished that such an one 
should ever have entered my head. "Madam," said he "I wouldn't for all the 
coals in the country have you abuse yourself in such a way." The veins of coal 
lie at some height in the steep rocks which rise above the sea, but the entrances 
to the shafts are on a terrace raised but little above the beach, so that it is by a 
dark narrow passage hollowed within the rock and having a very rapid ascent 
that the veins are reached; the coals are brought down in a sort of small carts 
constructed on purpose, drawn by men. The rock mass in which they lie is a 
dull white sandstone; in this stone are numerous impressions of vegetable bodies, the prototypes of which for the most part have never been seen in a recent state; — one of the specimens which I procured has very much the appearance of 
an **Euphorbia**. Above the coal in some parts is an imperfectly characterized 
aluminous mass, containing traces of organic bodies, possibly the detached 
members of zoophytes, similar to those which have produced the entrochites, 
trochites, and marine stars. The sandstone, as is very commonly the case in 
coal districts, contains insulated nodules of iron pyrites; and near the collieries, 
as is also common in coal districts, mica is almost a principal constituent of the 
sandstone. This stone also abounds with crystallizations of calcareous matter. 
The upper part of the coal mines is of a slaty character, and of a very inferior 
quality for burning; the coal itself is not heavy, and has many characteristics 
of vegetable origin.


It is a subject of debate among the learned and scientific, at what time these 
collieries were first known and worked. Some attribute the discovery of them 
to the Danes, when they had obtained possession of such large portions of the 
island — that is, previous to its being conquered by the English. Upon this subject I shall beg leave to quote a passage from **Mr. Hamilton**'s Letters on the County of Antrim. "I have already mentioned," he says, "some reasons which 
might induce the belief that these collieries were wrought at a very remote period 
of time; but an accidental discovery has lately put that matter beyond doubt, 
and has laid open a very curious circumstance in the ancient history of this 
country. About twelve years ago, the workmen in pushing forward a new 


---

p.126



 
adit[12](javascript:footNote('E810001-001/note012.html')) towards the coal, unexpectedly broke through the rock into a cavern. The 
hole which they opened was not large, and two young lads were made to creep 
in with candles to explore this new region. They accordingly went forward, and 
entered an extensive labyrinth branching off into numerous apartments, in the 
mazes and windings of which they were at last completely lost. After many 
vain attempts to return, their lights were extinguished, and they sat down in 
utter despair of ever escaping from their dreary dungeon. In the mean time the 
people without in the drift were alarmed for their safety, fresh hands were employed, a passage was at last made for the workmen, and the two unfortunate 
adventurers were extricated after a whole night's imprisonment.


"On examining this subterraneous wonder, it was found to be a complete 
gallery, which had been driven forward many hundred yards to the bed of coal 
that it branched off into various chambers where the miners had carried on their 
different works; that pillars were left at proper intervals to support the roof; 
in short, it was found to be an extensive mine, wrought by a set of people at least 
as expert in the business as the present generation. Some remains of the tools, 
and even the baskets used in the works were discovered, but in such a state that 
on being touched they immediately fell to powder. The antiquity of this work 
is evident from the circumstance that not the most remote tradition of it remains 
in the country; but it is still more strongly demonstrated from a natural process which has taken place since its formation, stalactite pillars having been generated reaching from the roof of the pit to the floor; the sides and supports 
were besides covered with sparry incrustations, which the present workmen do 
not observe to be deposited in any definite portion of time."


**Mr. Hamilton** goes on to say that the people of the country attribute this 
work to the Danes; but he employs many arguments to prove that it must have 
been anterior to their time, thus referring it to a period of a thousand years back. 
On this question I am far from pretending even to give an opinion: 
 — that a great 
degree of civilisation existed at that time in **Ireland**, more than in most parts of 
Europe, does certainly appear probable; but to arrive at any certainty upon the 


---

p.127



 
subject scarcely appears within the scope of probability[13](javascript:footNote('E810001-001/note013.html')). The surveyor who 
walked about with me asserted, without any manner of doubt or hesitation, that 
the mines had been worked by the Danes; and added, that when they found they 
could no longer keep possession of the country, they determined, before they 
quitted it, to do all the mischief in their power, among other things to set fire to 
these coal-mines. This they attempted, but succeeded no further than to burn 
the stratum above the coals, the fire never penetrated to the coals themselves: 
and he added, all above the coals is a vein of ashes, the remains of this conflagration. If I would like to have some of the ashes, he said, there was plenty 
to be had at a spot which he pointed out, high up in the cliff, and he would go 
and get me some. Without regarding his story as gospel, I was curious to see 
what the material might be which he thus designated, and I signified my acceptance of the offer. He immediately climbed up the cliff, and soon descended 
with his waistcoat-pocket filled with pieces of the aluminous mass which has 
been noticed as above the coal, and which he seemed most seriously to consider 
as the relic he had described of Danish vengeance. From him I also got a magnificent piece of the stalactite from the old mine.


These collieries are believed capable, if they were properly worked, of furnishing such abundance of coal as, in conjunction with the other mines in different 
parts of the island, amply to supply it with fuel without having recourse to 
foreign importation. But the difficulty of conveyance forms at present a fatal 
barrier against their being made the resource to the country of which they are 
capable. The tempestuous sea and the want of a harbour preclude all idea of 
their being transported through that medium. Would it be practicable to make 
an inland navigation by means of a canal communicating with 
**Lough Neagh**, 
and thence with the whole interior of the island? — I know not; but he would be 
a true patriot who would use his exertions to ascertain this point, and promote 
the work should it appear within the bounds of possibility.


After partaking of Mr. Conolly's hospitable breakfast, in a nice neat little 
cottage pleasantly situated near the edge of the cliff, about twelve o'clock I left 
**Ballycastle** and proceeded on my route towards the Causeway.




---

p.128


The Rock, and curious Rope-Bridge at **Carrick-a-Rede**. — **Ballintoy**. — **Dunseveric Castle**. — Walk round the Rock-Heads. — Promontory of **Pleaskin**, with its beautiful Colonnades. — The **Giants' Causeway**. — Remarks on its Length and Extent. — Inaccuracy of the Plates generally given of it. — Different Minerals found about it. — **Port Noffer**. — The Chimney-tops. — Legend respecting the Causeway. — **Port Coane**, Cave and remarkable Rock there.
#### 14


On leaving **Ballycastle** the road for some way diverges considerably from the 
shore. The first object of particular interest in this route is the remarkable 
rock called **Carrick-a-Rede**. The road runs at the distance of a quarter of a 
mile, nor can a carriage get up to it; but it well repays the trouble of walking 
over two or three enclosures. It is an entire mass of basalt, separated from the 
coast by a chasm sixty feet in breadth and eighty-four in depth. Over this is 
thrown a bridge of a peculiar construction, to facilitate the communication with 
the rock, which is much frequented at the time of the salmon-fishery. Vast 
iron rings are morticed into the rocks on each side, to which are fastened two 
ropes running parallel to each other, connected together with cross bars of rope 
at equi-distances, in the manner of a ladder, and over these boards are tied; a 
railing of rope to hold by, runs along one side[14](javascript:footNote('E810001-001/note014.html')); — a frail species of machinery to 
all appearance for crossing a chasm of so formidable a depth; yet during the 
season it is crossed and recrossed fifty times in the day, with perfect unconcern, 
by men, women, and children, carrying heavy baskets upon their heads: its undulating motion under the feet adds not a little to the feeling of insecurity which 
the contemplation of it necessarily inspires; and indeed, though generally crossed 
with safety, dreadful accidents have sometimes happened. I felt no disposition 
to go over it; yet a boy often or twelve years of age, who had followed us from 
the road, ran backwards and forwards several times with perfect unconcern. 


---

p.129



 
The bridge is taken down in winter, when from the turbulence of the sea the 
fisheries are entirely stopped.


Between **Kenbann** and **Carrick-a-Rede** is a remarkable fissure in the rock, 
which the legends of the country say was made by the great hero Cuchullin 
with a stroke of his sabre. West of **Carrick-a-Rede** are the caves of **Lirrybann**, in limestone cliffs, the roofs incrusted over with stalactite. At **Ballintoy** 
is a vein of coal, if coal it may be called, which has more the appearance of 
burnt or charred wood. This is the only village of any note between **Ballycastle** and the **Giants' Causeway**. Near it are the now trifling remains of 
**Dunseveric Castle**, standing on a rock of basalt. It was once a place of great 
extent and great strength; but the rock and the castle have mouldered away 
together, and remain only a monument of the ravages committed by that universal destroyer, Time. Vestiges of extraordinary manual labour may, however, be traced on an accurate examination, since it is evident that the sides 
of the rock have been hewn to render it perpendicular with the outward wall of the castle. 


At this place I quitted my car; and sending that on to meet me at the 
**Giants' Causeway**, took a guide from **Ballintoy**, who had been recommended 
to me, to accompany me in a walk along the rock-heads, the only means by 
which they can be examined. I had thus an excellent sight of the fine promontory of **Bengore**, the northernmost point of the county of **Antrim**, of **Pleaskin**, and all the most remarkable spots of this extraordinary line of coast. Of 
these **Pleaskin** is beyond all comparison the most striking. A base of rock, 
fringed with the white foam constantly dashing against it, rises in a somewhat 
rapid slope above the sea, to the height of two hundred feet. It is a mixture 
of red ochre and of the species of basalt called trap, in alternate strata, strewn 
over with fragments of broken pillars and other masses, variegated with intervals of grass, the fragments being many of them covered with gray lichens. 
Above this base a row of basaltic pillars, about forty feet high, runs all round 
the head of the promontory, extending a considerable way on each side. They 
are ranged with such perfect order and regularity, that it is difficult to conceive 
the whole to have been an operation of nature; greater symmetry in the formation and order in the arrangement could hardly have been exhibited by the 
nicest hand of art. Above tins rises again a mass of trap; and then comes 


---

p.130



 
another colonnade, encircling the promontory with the same regularity, and still 
more lofty, measuring in height about sixty feet. Above them is another stratum 
of trap, to the height of about twelve feet; the whole being overtopped with 
a thin coat of soil bearing a green herbage. The entire height of the promontory is nearly four hundred feet, presenting one of the most striking fronts imaginable, in which the wonderful, the beautiful, and the sublime may fairly be 
said to contend for pre-eminence. **Benmore** appears a grand ruin of nature. 
**Pleaskin** is one of her most perfect, most highly finished fortresses. If the 
idea of our Gothic buildings was inspired by the arching foliage of an avenue 
of trees, surely it must have been something like **Pleaskin** that inspired the idea 
of the regular and beautiful Grecian colonnade.


After stopping to contemplate and admire this majestic object till it began 
to be time to recollect that I had yet some way to walk before I could rejoin 
my car, and that by the time it could be reached the clouds of the night would 
be beginning to come on, I proceeded forwards, when I soon perceived three 
or four men, one after the other, running towards me, as if emulous which should 
have the start of the other. "Here they come by dozens," said my companion. "Who are they?" I asked. "The guides of the Causeway," he replied: — "I suppose they have seen the car, and heard somebody was coming, and they 
are all running to try which can get hold of you first." It was even so: these 
men are like a parcel of hungry eagles, always hovering about, watching for 
prey, and the moment any is espied, the contest is commenced which can first 
pounce upon it. I had been warned of this, and had been recommended by 
my good friend, **Dr. Macdonnell**, to put myself under the guidance of a man 
named Currie, far the most intelligent of any among the guides — not loitering 
about the Causeway like the tribe by whom I was now assailed, but living at 
the town of **Bushmills** ready to be employed by any body who may apply to 
him. I therefore peremptorily rejected the solicitations of the rest, though 
I was not the less followed by them, and molested with their officious offers of 
services for the rest of my walk. They said they heard that I was recommended to Currie, but they could any of them show me about as well as he 
could; — I found, indeed, that he was a great object of jealousy among them. 


To those who disregard a little bodily fatigue for the sake of gratifying curiosity, — or I would fain give the feeling a more respectable appellation, since 


---

p.131



 
it appears to me that a love of such research may be considered as of a superior nature to mere curiosity, — to those in whom this feeling rises above the 
sensation of bodily fatigue, I would earnestly recommend not omitting the walk 
I had now taken. Their toils will be well repaid by the opportunity so afforded 
of minutely examining these bold and majestic features of nature, which must 
be minutely examined to be justly appreciated. But it is a walk of some toil: the distance is considerable, not less I believe than six miles (Irish miles); and 
that distance is very much increased by the nature of the ground, constantly 
up and down; sometimes through high grass, at others through bog; rarely 
with a smooth, even, and firm footing. I often sat down when there was any 
point that I more particularly wished to contemplate. By the time, however, 
that I arrived at the little public-house near the Causeway, where the car was 
waiting for me, I was too much tired even to go and take a casual glance at 
this desired object; but set off immediately to **Bushmills**, distant about two 
miles, the general lodging-place of visitors to the Causeway. I found Currie 
waiting at the inn, which seemed to be his stand for way-laying travellers, and 
engaged his attendance for the next day. 


Juliet says, "What's in a name?" and the poet who puts this sentiment in 
her mouth was deeply read in human nature. Yet a name has very great influence not merely upon the imagination but even upon the judgement. We 
hear of the **Giants' Causeway**; we know that the term Giant is applied to a 
being which the imagination has figured, though of human form, immensely 
beyond all human stature and size, and we immediately figure to ourselves that 
every thing referable to these extraordinary imaginary beings must be of a vastness almost beyond all human conception. It is probable that at least three fourths of the visitors to the Causeway approach it impressed with these ideas 
and to such, disappointment must almost inevitably be the first sensation experienced[15](javascript:footNote('E810001-001/note015.html')). Had I seen it five years earlier in my life, such had probably been my 
sensations; but led within that time to direct some part of my attention towards 
the mineral kingdom, I had imbibed more sobered ideas with regard to this mineralogical phaenomenon; and in one respect only did I find it falling short of 


---

p.132



 
my expectations as to the mere point of its vastness; — this was in the length that 
it runs from the foot of the cliffs into the sea; I expected to have found that much greater. 


Yet if instead of being presented with a work so enormous that the execution of it seems immeasureably beyond the reach of human powers, we behold an object which in reference merely to its size might easily be supposed the work of mortal hands, its extraordinary construction must awaken feelings of such astonishment and admiration that every other sensation is absorbed in them alone. Let the Volcanists and the Neptunists, the Huttonians and the Wernerians, *waste the midnight oil* in labouring to establish their respective theories on the cause and origin of an effect so wonderful — all must bow with the deepest the most sacred veneration to the hand that could ignite the volcano, or direct the motion of the heaving billows in its formation.


The reader's attention is particularly requested to the annexed Plate; it is 
from a drawing taken on the spot by my friend Mr. Hare, surgeon, of Argyll-street; and I think I may safely venture to say that it gives a more accurate representation of the Causeway than any engraving yet before the public. It exhibits some of the most remarkable groups of the basaltic pillars, as they appear in descending from the rock-heads. The central group is provincially called the **Giants' Loom**; the extremity to the right is a part of the Causeway properly so called. It is a fault but too common among draughtsmen in taking sketches of scenery, if the objects as they actually exist do not form as pretty 
a landscape as they wish to produce, they add any little embellishments of their own which they think will supply the deficiency. I have had occasion in my Travels in France to advert to this practice in speaking of the **Pont-du-Gard**, and again I must reprobate it. If a painter only wishes to make a fine 
landscape, let him give free scope to his imagination — let not a tree, a building, 
a piece of water, be placed but where it will produce the most picturesque 
effect; but if he pretends to give a view, let it be the spot such as it really is, 
without deduction or addition. Sketches of actual scenery should be considered in the light of history, the most essential feature of which is a strict adherence to truth; while pieces of imagination are the novels of the graphic art, 
in which the artist is at liberty to give the fullest scope to his inventive powers. 
Whoever sees and studies this plate would afterwards approach the Causeway 
 


---

p.133



 
with ideas properly arranged for what he is to see, not embued with expectations widely estranged from the reality. The best engravings hitherto given 
are undoubtedly the two celebrated ones from drawings made by **Mrs. Drury** in 
1 743, engraved by Vivarés, and published under the patronage of the Earl of 
Antrim. Yet even in these, truth has in more than one instance been sacrificed too much to picturesque effect. A something more towering than the 
fact will justify is represented; while no impression is given of the broad surface of pillars, so much spread out in extent, over the angled tops of which 
not the eye only, but the steps are conducted. 


The usual description given of the Causeway is, that it is a mole projecting from the foot of a towering basaltic rock some way into the sea. So far 
the description is very proper; but care should be taken at the same time to 
explain that the mole itself is not towering, that it does not in any part rise 
to a considerable height above the water. The tallest pillars are in the group 
called the **Giants' Loom**, and none of them exceed thirty-three feet in height. 
**Mr. Hamilton** says that the Causeway runs from the foot of the rock some hundred feet into the sea: this is a very loose and indefinite mode of description. I 
had heard before I saw it that it projected three-quarters of a mile into the sea; 
estimating it at the utmost possible extent to which it could be taken, I believe 
it would be found scarcely to run to a sixth part of that length[16](javascript:footNote('E810001-001/note016.html')). But the accounts 
are so extremely varied that one thing only is to be inferred, which is, that no 
accurate measurement of it has ever yet been taken. My guide, whom in many 
respects I found very intelligent, seemed wholly at a loss when I questioned 
him on this subject. Indeed in computing the length of the Causeway, the 
first thing to be determined is the point from which the measurement is to 
commence. The whole length from the foot of the rock is commonly comprehended in it; whereas, in fact, the Causeway properly so called commences 
only at the range of low columns seen in the print to the right: 
 — hence may 
very much arise the contradiction in the accounts. Something will also depend upon the state of the tide when the measurement is made. The mole 


---

p.134



 
slopes gradually down till it is lost at the water's edge; but as far as the eye 
can discern, the same mass of pillars is continued under the water; consequently at a very low ebb the Causeway will have the appearance of much 
greater length than at high water. **Sir R. C. Hoare** says, that from the flattened surface of the Causeway it would be entirely overlooked if not pointed 
out by the guides. This is going much too far; — if the eye fails of discovering 
the gigantic wonder which the imagination had conceived, it seems wholly impossible that it should not be caught by the actual wonder spread before it. 
Two smaller moles project from the same mass of rock, the three being each 
divided from the other by a whin dyke, vast masses of which rise many feet 
above the water; they are conspicuous features in **Mrs. Drury**'s print of the 
western side of the Causeway. The three moles together are said to include a 
mass of 30,000 pillars[17](javascript:footNote('E810001-001/note017.html')). 


I wish I may have succeeded here in endeavouring to give more just ideas 
than are generally entertained as to the extent and height of this phaenomenon. 
Though I cannot assent to **Sir R. C. Hoare**'s position, that it would be overlooked if not pointed out to observation, yet I am exceedingly disposed to 
think that the impression which its wonderful construction would naturally 
make if the imagination had not been led astray, is extremely weakened by the 
disappointment experienced in not finding it awfully gigantic. But I must persuade myself that the astonishment and admiration of every contemplative mind 
will increase in proportion as its construction is more and more minutely examined. It is now sufficiently known that the whole is a mass of naturally-formed pillars of basalt; 
 — upon their nature and origin the opinions of men of 
science vary exceedingly, nor does my little knowledge suffice to authorize my 
having any decided opinion of my own. In the following chapter, however, 
I present my readers with some ideas upon so extraordinary an operation of 
nature, which will be found both new and ingenious. For the whole chapter I 
am indebted to my friend Mr. Hare, already mentioned as having favoured me 
with the drawing of the Causeway. As a man of science, a member of the 


---

p.135



 
Linnaean and other learned Societies, he is much more competent to write upon 
the subject than I am; and I flatter myself that my readers will derive far 
greater satisfaction from the scientific manner in which they will there find it 
treated, than they would from any thing I could say; I am sure they will derive much more instruction. 


A striking and remarkable feature of the whole line of coast even from **Benmore** to **Portrush**, the whole northern coast of **Antrim**, is the number of small 
bays into which it is broken. This is more particularly the case in the part 
lying between **Bengore**-head, and the river **Bush**, in which division the 
 **Giants' Causeway** is included. The rock from which that projects is nearly in the 
centre of one of these bays, which has the name of **Port Noffer**. The entire 
mass of rock with which this bay is surrounded is basalt, and in a variety of 
places clusters of columns appear emerging from the mass, some, small ones, 
only peeping out from among the green sod which covers a great part of these 
rocks. Several of these clusters may be observed in the plate, appearing in different parts of the rock above the Causeway. One of them, in the sweep of 
the bay eastward of the Causeway, has the name of the **Giants' Organ**, from 
the similarity found in the arrangement of the group to the pipes of an organ. 
Round the eastern point of **Port Noffer** sweeps another small bay, which is 
terminated by a remarkable rock, having at its point a little cluster of pillars, 
standing free from the rock and having the appearance of chimneys; from thence 
the group is called the **Chimney-tops**: this is one of the features of the scenery 
to which a stranger's attention is always particularly directed by the guides. 
Round **Port Noffer** there is for the most part a small level space between the 
foot of the rocks and the sea, overgrown with herbage, and strewed all over with 
loose blocks of stone, — fragments, as they appear, fallen from the rocks above. 
Many of these are in a state of extreme decomposition, and are readily broken 
to pieces with a few strokes of the hammer, when they display a variety of 
beautiful crystallizations. A remarkable rock in this little bay, called the **Lion-rock**, which is insulated at high water but perfectly accessible when the tide is 
down, is full of crystallizations. In going over the head of the Causeway, just 
below the rocks, is a spring of very pure and pleasant-flavoured water, to which 
is given the name of the Giants' Well; here sits an old woman with a glass, 


---

p.136



 
who invites people to drink, not without expecting a remuneration. After 
having well examined the Causeway below, it may be recommended to go to 
the rock-heads, and take a bird's-eye view over it from above; the trouble is 
not great, and is amply repaid. 


On the nature of the several mineral productions to be found about the 
Causeway, it may be said, that where the basalt is not formed into columns, 
the masses possess a considerable variety of texture as well as colour; — in 
colour, they are to be found from various shades of gray and brown to a dull red. All these varieties are attributable to the iron contained in the mass 
under various circumstances of chemical influence. The basalt often approaches 
in its general character to amygdaloid, the cavities being sometimes very considerable, and either coated or filled entirely with various minerals. In the 
former instance, the interior surfaces have always a crystalline character, which 
when entire not uncommonly constitutes a hollow sphere, to which the name of 
geode has been applied: this is principally the case with such as are of a siliceous nature. Zeolite occurs in every known variety; and that which is usually termed fibrous, or mealy zeolite, is particularly deserving of attention from 
its extreme delicacy and brilliancy of character, resembling the fine down of a 
thistle. Calcareous spar is exceedingly common, steatite and green earth are 
occasionally found; chalcedony approaching to opal, and agates, are not rare. 
The basalt, which is decomposed to such an extreme degree as nearly to have 
lost the whole of its metallic matter, has much the appearance and the specific 
gravity of limestone or similar matters which have been submitted to the action 
of fire. In various parts of this district are also found numerous specimens of 
wood which has all the appearance of charcoal, excepting that it is rather more 
glossy. These circumstances have been upon many occasions adduced in support of the idea that basalt is of volcanic origin. At **Port-na-Baw**, a bay adjoining to that in which is the **Giants' Causeway**, iron pyrites occurs very much 
in the basaltic masses, and carbonate of strontites, or strontian, is by no means 
uncommon. The **Statice Armeria** was growing in many parts about among the 
pillars.[18](javascript:footNote('E810001-001/note018.html')).




---

p.137


#### 14


Since the Causeway has become so strongly the subject of public curiosity, 
which is little more than a century back, much investigation has been employed 
in endeavouring to ascertain the precise time and manner of its first coming into 
notice. It would scarcely be a less curious subject of inquiry to endeavour to 
trace out the time when the legend to which it owes its name was first brought 
into circulation, and the name of *The Giants Causeway* in consequence affixed 
to it. As it is possible that my work may fall into the hands of some readers 
to whom the legend is not known, it may not be mal-à-propos to present them with a sketch of it. 


Fion Mac Cumhal, or Fin Mac Cool as he is sometimes called, thence by 
corruption converted into Fingal, was the sovereign of a race of giants inhabiting the interior of **Ireland**. In his days the Scots had made frequent descents 
upon the northern coast of **Ireland**, plundering and ravaging it. Fion at length 
undertook to avenge the cause of the sufferers, and not only to defend their 
country, but to carry his giant train across the ocean and repay tenfold the ravages which had been committed. To facilitate his purpose, he conceived the 
idea of building a bridge or rather causeway across the ocean, and made his followers hew from the mighty rocks along the coast the materials for constructing 
it. These blocks were hewn in the geometrical figures which compose the pillars of the Causeway, and the mole formed of these masses rose above the ocean 
till it reached the Scottish coast at the island of **Staffa**; — here a palace was 
built for the chief, of the same extraordinary materials. A route thus opened, 


---

p.138



 
the giant race poured like a torrent upon the devoted country of Albin, as 
Scotland was then called. Their march is thus described by **Dr. Drummond**: 

> 1. Now armed for war along their iron road
>   
> Stern in their ire the giant warriors strode. — 
>   
> As files on files advanced in serried might, 
>   
> How flash'd their arms' intolerable light; 
>   
> Casques, shields and spears, and banners floating gay, 
>   
> And mail-clad steeds, and chariots' proud array, 
>   
> Bright glancing as the fires which heaven adorn 
>   
> When fair Aurora brings the Boreal morn.
>   
> [Giants' Causeway, p. 12.]
> 

 


The Scotch beheld the progress of this stupendous work with terror and dismay: What could their feeble might avail against a power thus more than mortal! — the only hope was in matching against them powers supernatural as 
their own. The Druids and Bards were summoned: nine days successively 
did the altars smoke with human victims sacrificed to Odin; nine days were 
prayers and supplications addressed to him to assemble all his terrors and baffle 
the efforts of these mighty invaders. Odin, from the hall of Valhalla where he 
was quaffing the blood of the victims out of the sculls of redoubted heroes slain 
in battle, heard their prayers, and arming himself with his thunders, his lightnings, his winds, his hail, his sleet and his darkness, standing in the centre of 
the mole commanded these engines of his wrath to hurl destruction upon it. 
The mole sunk accordingly into the bosom of the abyss, and nothing remains 
of it but the fragments standing on the Irish coast and at **Staffa**. 


From this fabulous legend, — from being the reputed work of giants, not from 
being in itself gigantic, — the **Giants' Causeway** derives its name. By this name 
alone does it appear ever to have been distinguished, it is the name given to it 
by the earliest writers at present known to us as mentioning it. Now it is worthy of *observation* that the legend does not bear the stamp of being one of modern 
date; legends of this nature are much rather the coinage of ancient days; — of those days when all religion being defaced by superstition, the imagination 
was ever at work to create objects for satisfying this leading propensity, and attributed to supernatural agents, the offspring of their own fancies, every thing 
either in the physical or moral world which their limited knowledge precluded 
them from referring to the regular ordinary processes of nature. But such a legend 


---

p.139



 
having been framed plainly shows the object of it to have then existed, and to have 
been regarded as one of great astonishment and admiration; had it not been so regarded, the work would never have been ascribed to a race so celebrated as Fin and 
his gigantic followers. To what period the existence of this great hero may be 
supposed referable is immaterial; the question is, — when the traditions respecting 
him first began to obtain general currency. The late **Joseph Cooper Walker, 
Esq.** in his laborious research into the history of the ancient bards of his country, thinks that these tales were productions of the eleventh and twelfth centuries; — a time of ignorance and incivilisation very propitious to the growth of 
fables of such a wild and extravagant nature. From these premises a probable 
inference may be drawn that the **Giants' Causeway** has existed such, or nearly 
such, as it does now for not less than six centuries, — the wonder and admiration 
of the simple natives round about, however recent may be the period that it has 
attracted the notice of the traveller and the naturalist. It is remarkable that in 
the south of **France** and in Italy the name of Pavé des Géans is given to some 
of the basaltic masses which there present themselves. 
It is also evident that Fingal's grotto and the other basalts of the island of 
**Staffa** must have been well known in **Ireland** at the time the legend was framed, 
though their existence seems to have been entirely unknown in England till **Sir Joseph Banks**'s visit to the western islands of Scotland in 1772. But near as 
the north of **Ireland** is to some parts of Scotland, particularly to the most 
southerly among the western islands, and little as any English person, or indeed 
Scotchman of science, thought of visiting those islands till within the last half 
century, it is not surprising that Superstition should have laid her hands upon a 
spot which spread out its treasures in vain to the eye of philosophy.


The oldest document known to us which pretends to giving any thing like a 
philosophical account of this wonder of nature is one dated anno 1693, in the 
form of a letter from **Sir Richard Bulkely** to Dr. Lister[19](javascript:footNote('E810001-001/note019.html')). It is a report made 
by a Cambridge Master-of-Arts, and reflects little credit on the writer; nothing 
can be more unlike the reality than his description of it. The next account is 
one dated 1694, by **Dr. Samuel Foley**, drawn up in a very superior manner 
to the former[20](javascript:footNote('E810001-001/note020.html')) About the same period we find it also noticed by **Dr. Thomas Molyneux**, 


---

p.140



 
Fellow of the Royal Society and of the College of Physicians[21](javascript:footNote('E810001-001/note021.html')). From this period we do not find it again noticed in the Philosophical Transactions, till the account given by **Dr. Pococke**, which was fifty years after. Since 
that time the visits to it have been numerous, and the accounts various; while 
the lovers of science have been eagerly occupied in endeavouring to discover 
the wonderful process of nature by which it is formed. 


There are no less than twelve whin dykes in the short space between the 
mouth of the river **Bush** west of the Causeway, and **Port-na-Spania** east. 
This port sweeps round eastward from the **Chimney-tops**. After the dispersion 
of the Spanish Armada, one of the vessels is said to have wandered about till 
at length it was driven into this port and there wrecked; hence it has its name. 
Two whin dykes have been already mentioned as separating the different divisions of the Causeway. Another is to be seen at **Port-na-Baw**, the next port 
westward of **Port Noffer**, and divided from it by some, not very high, rocks 
covered with green sod, called the **Stookans**. It takes a remarkable form here, 
a large piece of wall standing detached from the adjacent rocks, and it is composed of horizontal prisms having an axe-like form: about this mass the iron 
pyrites are principally found. But the most remarkable of the whin dyes 
is at **Port Coane**, the next port westward of **Port-na-Baw**. An engraving of 
it is annexed: the sketch was taken on the spot by Mr. Hare, who kindly 
obliged me with the use of it. From this a very accurate idea of its singular 
appearance may be obtained: seen at a distance it has very much the appearance of a ship with all the sails up. **Sir R. C. Hoare**, after expressing his disappointment from not finding all the picturesque beauty he expected at the Causeway, goes on to say: — "We afterwards visited a cavern in a little bay to 
the westward; here the artist will find a grand subject for his pencil, which I 
was prevented taking by a violent and dangerous fall in getting into the cavern." 
**Port Coane** is the bay here alluded to; and this rock, or whin dyke, may fairly 
be pronounced the subject which he recommends so strongly to the artist's pencil. The cavern of which he speaks could not be introduced in the plate; it 
lies behind the projecting rock to the right, and is consequently not in sight 
at the point of view whence the sketch is taken; indeed there is no point from 


---

p.141



 
which the rock and cavern could both be included, so as to give an adequate 
idea of the rock. The rocks round this bay, except the whin dyke, are principally composed of globular laminated concretions of basalt, which from their 
figure and construction are called provincially onion-stones. The dyke exhibits horizontal fissures. 


The cave is entered by a lofty arch, on the right side of which large stalactitic incrustations are formed by the constant dripping of water down from the 
higher regions of the rock. The arch of the cave lowers considerably in proceeding into the interior, and at the back is an opening, not a very large one, 
and not coming quite down to the ground, through which is another cave 
crossing the first in the manner of a T. One end of this is open to the sea, 
which rushes in with great force, the sound being finely reverberated by the 
echo within the cave. The floor of the cave rises in a regular slope from the 
sea, so that the majestic rush of the water may be contemplated in the most 
perfect security. It was no doubt going from one cave to the other that **Sir R. C. Hoare** got his fall; for the passage is dark, the footing slippery, and, unless 
directed and assisted by a guide accustomed to it, a false step is very easily 
made. I had been told that a beautiful little species of **patella** was to be procured here, and I accordingly inquired for them. The guide said they were 
not abundant, but the place to find them was plucking the large **fuci** from the 
stones to which they adhere, and the creatures were lodged beneath. Several 
of these plants he plucked off, but only two shells were found. Westward of 
this cave is one said to be much more worth visiting, that of **Runkerry**; but 
it is only accessible by water. The whole depth that it runs within the rocks 
is not known, since there is a bar of stones at some distance from the entrance, 
over which no boat can pass. 


The visit to **Port Coane** and its caves concluded a day to which I shall 
always recur as one of the most interesting I have ever passed. Nor can I persuade myself but that the same would be the feeling of every traveller visiting 
this extraordinary phenomenon, if he could only divest himself previously of 
the ideas of immensity which have been unwarrantably attached to it. I cannot, 
however, finally take my leave of it without a word in favour of my guide 
Currie. I found him civil, obliging, intelligent; and as he saw me anxious to 
procure specimens of all the different mineralogical productions, he took every 


---

p.142



 
possible pains to seek me out the best that were to be had. But the troop of 
guides by which the Causeway is infested are always upon the look-out to 
collect every thing they can find worth seizing, which they keep for sale to travellers, taking care not to ask a price for them below their value. One of the 
guides early in the day offered me a fine specimen undoubtedly of crystallization, for which he modestly asked a guinea; this I had no disposition to give. 
In the course of the day he gradually lowered his price, till as I was going away 
he offered it for five shillings; — had it been offered at this price in the first instance, 
I had perhaps purchased it; but he had made me angry with his aim at extortion, 
so I left him with his specimen, and retained the five shillings in my pocket. Notwithstanding my peremptory rejection of their services, a whole flock of these 
cormorants would continue to follow me about the whole day, and then made 
their impertinent intrusion a pretence for wanting some remuneration at the 
conclusion. I was pleased to learn from a gentlemen of my acquaintance, 
who was at the Causeway two years after, that Currie remembered me, and 
seemed much pleased at seeing one to whom I was known.[22](javascript:footNote('E810001-001/note022.html'))




---

p.143


On the general Characters of Basalt, with an Attempt to account for its Columnar Structure. — Remarks on Rocks of a similar Nature. — And an Idea of the original Etymology of the word Basalt. (By Thomas Hare, Esq. F.L.S. &c. &c. &c.)
#### 15


The singular tendency which Basalt evinces to assume a columnar figure is 
familiar to the commonest observer: and no constituent material of the solid 
globe has more frequently been an object of geological speculation in recent 
times; theories of equivalent ingenuity having contended as vehemently for its 
igneous, as its aqueous arrangement.


Although various parts of Europe and Asia are abundant with examples of 
Basaltic Columns, yet the island of **Staffa** and the 
**Giants' Causeway** appear 
to be the most striking and extensive in the known world. It is extraordinary 
that the former should scarcely have been known before the year 1772, when 
it was admirably described by **Sir Joseph Banks**, on his visit to the **Scottish Hebrides**. The latter had been better known by the previous description of the **Bishop of **Ossory****. 


Basaltic Hills are particularly characterized by a sweeping or undulating outline of their upper surfaces, which are usually clothed with rich verdure, while 
the sides are steep, naked, and in many instances, literally perpendicular. 
The most rude and massy rocks of this nature generally exhibit somewhat of 
a prismatic figure; and in numerous instances, Pillars are formed with the most 
geometrical exactness. These occur upon the lateral surface of hills, or flank 
their extremities, commonly perpendicular, sometimes obliquely, and sometimes curvilinear. Occasionally they form recesses, or, by uniformity in height, 
a causeway, of which the upper surface presents the structure of a Mosaic 
pavement. They are in some instances the partial courses of *rivers, in* others, 
the bosom of the main Ocean. 


These columns, which, on the average, vary in height, from three or four to 
fifty and sixty feet, and in diameter from one foot to two, vary also in the 


---

p.144



 
number and breadth of their lateral plane surfaces, which are from three to 
eight; but of all others, five and six are the most prevailing. They have also 
horizontal intersections of uncertain depth, which on examination, are found to 
result from distinct bodies. In reality, a single column of basalt consists of 
many prismatic joints, piled one upon another with the utmost nicety. Each 
lateral edge of the prism terminates in a trihaedral angular process continued 
from the lateral planes; and the uppermost horizontal surface rises from a narrow margin into a convex surface, while the surface of the base has also a 
narrow margin, and rises into a concavity; the base of each lateral edge having 
the solid angles truncated. Thus the convexity of a joint, and the terminating 
processes of its lateral edges corresponding with precision to the concavity and 
truncations of that which is placed upon it, a column of basalt exhibits numerous prismatic articulations wedged firmly together. And such, to my apprehension, may be regarded as a genuine crystallization. 


The laws of Attraction which naturally influence the geometrical figures of 
those mineral solids, commonly known as Crystals, appear to be exerted in 
a similar manner for effecting the prismatic character, for which basalt is 
so truly remarkable. The demonstrable formation of those bodies in the 
common processes of chemistry, no less than the natural appearances hereafter 
to be noticed, seem eminently calculated to shew that basalt owes its characteristic figure to the influence of water. This peculiar property of the mass 
frequently evinces itself in the process of exsiccation, or remains dormant until 
acted on by the air of the atmosphere. Contrary, then, to the probable operation of volcanic fires, it would appear that the power of heat, suddenly exerted, would not be likely to effect a figure so symmetrical as the more gradual 
influence of water; since, admitting the prismatic figure of basalt to be truly 
the result of crystallization, it will be remembered that crystals are more regular the more slowly they are formed. 


It may be observed, that numerous substances, when submitted to heat crystallize with considerable symmetry, if that power be not suddenly withdrawn; 
but of such, the result is not so generally and so geometrically crystalline as of 
those which have been acted on by a watery menstruum.


Where basalt does not divide itself precisely after the manner of prismatic 
columns, or evince a tendency to that figure on a great and general scale, it 
 


---

p.145



 
often forms laminated spheroidal bodies, which varying in their diameters, constitute, by aggregation, rocks of considerable magnitude. 


The latter circumstance, in addition to the occurrence of basaltic fragments, 
in which a sphere appears to be enveloped by a polyhedral figure, suggested the 
hint for an opinion which I have been led to adopt — that a compressible laminated sphere is the primitive figure of each prismatic articulation, composing a 
column of basalt: and that the lateral plane surfaces, as well as the corresponding concavity and convexity of the horizontal surfaces, the trihedral processes 
of the lateral edges, and the corresponding truncations of the superimposed 
joint, result from the assemblage of spheres, under the influence of gravitation, while the component particles are in a yielding state; their laminated 
structure being a mechanical accommodation to the filling of those interstitial 
spaces, which must result from an aggregation of spheres. 


These ideas may be in some degree elucidated by the annexed Plate, in 
which the first figure exhibits a basaltic fragment from the vicinity of Belfast, 
where the sphere is developed by a partial decomposition of the prism; while 
the group shows the prevailing character of basaltic columns in general, two of 
the constituent prisms being detached, to show the alternate concavity and 
convexity of the horizontal surfaces, with the angular processes and truncations 
of their edges. 


My view of this phenomenon is not widely different from that of Monsieur 
Allau, which having previously appeared in the Journal de Physique, was published, as a translation, in the 23d volume of Nicholson's Journal. 


In concluding a paper on the contraction of artificial sandstones by fire, the 
natural division of basalt is alluded to, without any decided reference to the influence of fire or water; conceiving "that cracks will determine spheres of attraction, round which the particles will agglomerate; and the centres will be so much the more numerous, and the radii less as the attractive force is more considerable." 


But according to the idea which has occurred to me, it is the central attraction of individual nuclei, which determines the number and figure of the cracks 
or fissures; or in other words, that laminated spheres of basalt chemically 
formed by the attractive power of its constituent particles, are mechanically altered by juxta-position under the same influence.




---

p.146


#### 15


**Mr. Gregory Watt** by his excellent paper in the Philosophical Transactions 
appears to have adopted an opinion that a spheroidal figure is concerned in the 
determination of the basaltic column. But I am not aware that any theory 
has been suggested similar to that which is here attempted.


Where rocks of basalt, as is well instanced at **Port Coane** on the coast of 
**Antrim**, exhibit simply a spheroidal structure, it appears possible that the phenomenon may have depended upon an imperfect process of crystallization; an 
inference deducible from the uneven distribution of the constituent particles 
and, perhaps, also from consideration of the physical qualities of those which 
are predominant. For example, where alumine prevails, it does not seem impossible that this earth may influence a rapid crystallization. However, it is needless to observe that the characteristic figure of all solids is often either indeterminate, or mutilated, as the disposition of their parts to geometrical arrangement has been opposed or unfavoured by adventitious causes.


Those spheres of basalt, which constitute rock-masses, clearly exhibit numerous concentric laminae, after the manner of a coated bulb: hence, in the 
north of **Ireland**, they are vulgarly known as Onion-stones. The laminae are, 
generally, of a coarse grain, and the globular figure considerably mutilated. 
In short, it may be said to possess every variety of appearance which different 
degrees of mechanical compression, exerted on a sphere, can possibly effect 
and the remark applies equally to the spheroidal basaltes of the southern parts 
of Europe, and other districts where such minerals prevail.


On the side of **Mount Pleaskin** or Placekin, near the **Giants' Causeway**, 
there is a remarkable appearance of imperfect crystallization, between the two 
principal ranges of pillars, much resembling the diverging figure of radiated 
Zeolite. The varieties of zeolite are well known to abound in basaltic regions, 
particularly the most northern; and that alluded to, impresses the idea of a 
rapid crystalline process. Intense cold and frost most frequently produce a 
figure more or less resembling it.


The memorable frost in the beginning of 1814 covered the trees and 
shrubs of the plantations in London with a beautiful condensation, so exactly 
resembling tufts of radiated zeolite, that it does not seem unworthy of remark in this place, since I have never observed similar appearances in more 
open stations; and I am inclined to think the figure was much influenced by 


---

p.147



 
the confined atmosphere of the metropolis, in addition to the weight of an 
unusually cold air: for the radii of crystallization in zeolite, as in some instances of frost, appear to have been suddenly arrested, and thus to account, 
in a considerable degree, for the circular figure with crowns diverging, or radiated zeolite.


On the islands of **Staffa** and **Rathlin** curvilinear prisms of basalt present 
themselves, which so much resemble the ribs of a ship, that every spectator 
at first sight expresses the same comparison. I think it possible that this 
appearance may have been effected by a successive arrangement of compressible laminated spheres, after the manner of a string of beads. Near the 
Cascade of Vestena, in the territory of **Verona**, where a similar appearance 
exists, irregular aggregated bodies (some approaching to a sphere, and some 
to an imperfect prism) rest within the uppermost segment of the circle. 
The influence of the laminated sphere seems no less applicable to the various degrees of inclination exhibited by basaltic columns in several parts of 
the world.


I would now take a comparative view of external resemblances between certain widely distributed masses, of which the constituent materials, differing not 
in chemical properties, but only in individual proportion, admit of their being 
termed, with propriety, Basaltic Rocks. Such are Green-stone, Grey-wacke, 
Porphyry-slate, and Schistus or Clay-slate; conceiving that analogies of external character are at all times worthy of consideration in common with those 
of chemical composition. 
The variety of basalt named green-stone is probably next to it the most remarkable for evincing a tendency to the columnar figure. The most familiar 
examples with which I am acquainted, in Great Britain, are afforded by the 
rock of Stirling-castle, and others near that town; and by some parts of the hill named Arthur's Seat, near **Edinburgh**. 
A small chain of rocks at **Linton**, in the North of **Devon**, which flanks the border of the **Bristol Channel**, commonly known as the **Valley of Rocks**, to 
my apprehension, affords the best English example of grey-wacke. These rocks 
evince a strong tendency to the prismatic figure, and appear in blocks upon the 
summits of the hills, much after the manner of decomposed granite: their edges 
and angles are, however, generally more acute, and their texture particularly 


---

p.148



 
firm and compact. The loose fragments which cover the sides of the valley are 
vulgarly known under the name of Rubble-stone, or Rag-stone. It appears but 
little different from the well-known Rowley rag-stone of **Staffordshire**; and this 
has been seen to divide itself into articulated prisms.


In the Philosophical Transactions for 1783, where **Dr. Withering** has given 
an account of the Rowley rag-stone, he seems to consider the prevailing figure 
rhomboidal. The rhomb is, of course, but a modification of the four-sided 
prism; and the rag-stone of **Staffordshire** has, in some instances, been seen in 
articulated columns of five and six sides, similar to the most genuine basalt.


I am not aware that marine **exuviae**, or other organized bodies, have been 
found or described in the grey-wacke of **Linton**; but, on a specimen, which 
I struck with difficulty from one of the most indurated blocks, there is distinctly the impression of a bivalve shell, much resembling the genus **Cardium**. 
Numerous other fractures were not successful in exposing similar appearances[23](javascript:footNote('E810001-001/note023.html')).


Of the many varieties of schistus, or clay-slate, some in general appearance, 
as well as in chemical composition, have so close a resemblance to grey-wacke, 
that certain mineralogists have distinguished them by that name. The great repository of the metallic treasures of **Cornwall** has, in many instances, been so 
named. Certain hills near the **Lizard-point**, on proceeding from the town of 
**Helstone**, have broken and naked summits, remarkably like those of the Valley 
of Rocks, both in figure and composition, apparently passing into clay-slate, 
which, in a compact form, constitutes the **Lizard-point**, and joins a mass of Serpentine. The natural decomposition of certain rocks, near the well-known, 
slate quarries of **Boscastle**, are also worthy of notice, as resembling those of the **Linton Valley**.


There is certainly an analogy of external character, between tabular basalt 
and that form of clay-slate which is employed for the roofs of houses; and 
still more, between a form of clay-slate occurring near **Taunton** in Somersetshire, and that kind of basalt which forms the walls of Whin-dykes; the former 


---

p.149



 
dividing itself into horizontal prisms, precisely after the manner of the latter. 
In the many slate quarries which I have visited in various parts of Great Britain, a similar appearance has never met my eye. 


In whatever part of the world basalt or any of its varieties have been found, 
phenomena have also been observable which tend, by their similarity, to establish a general distinctive character. The ranges of columns are often accompanied by strata of an ochreous nature, which probably result from the oxydation of a large proportion of iron in their original mass. Some have the appearance of **terra cotta**, and abound with vesicated cavities; and some are no 
other than altered Amygdaloids, the base of which is essentially of a basaltic 
nature. 


These appearances, which are common in **Ireland**, are described also in **Auvergne**, by Mons. Desmarest.


In the great basaltic district of the North of **Ireland**, wherever the columnar 
figure is not effected, the tufted masses which diversify the surfaces of the 
heights, show much of the tendency on a reduced scale; and such is equally 
remarkable on many schistose mountains in **North Wales**, particularly at **Pont y Aberglasslyn**, and over the whole surface of **Cader Idris**. 


The basaltes which are abundant in Italy and the South of **France** exhibit 
various inclinations and curvatures in the prismatic form, like those of **Antrim** 
and the Isle of **Staffa**. Many of the groups are there termed Pavé des Géans. 
Like the former, also, they bear a relation to Limestone: and this, in the 
territory of **Verona**, is crowded with animal remains. They also frequently exhibit laminated spheres: and it is remarkable that **Faujas de St. Fond**, who 
adopts the volcanic theory, does not consider this variety as of igneous arrangement. 


It appears, by tradition, that basalt was employed extensively by the Egyptians and other nations of antiquity for the purposes of statuary; and it is not 
improbable that in those days, when the recondite operations of Nature were 
less explored by man, superstition was so far credited as to have made the ancient naturalists nearly silent upon the subject of columnar basalt as an unaltered production of Nature. **Pliny** is, apparently, the first whose mention of it exists. He speaks of it as a hard stone of Ethiopia, of which **Strabo** had 
seen pillars and pieces of great dimensions.




---

p.150


#### 15


The circumstance of the celebrated sculpture, which by command of Titus Vespasian was dedicated to Nilus in the Temple of Peace, having been hewn out of a single column of basalt, derives corroboration from the vast dimensions 
of those pillars which form the grand façade at **Benmore**, and also the immense 
prismatic divisions in the rock-mass on the west side of **Mount Pleaskin**, 
whence an extraordinary quadrangular pillar separated itself in the winter of 
1811, falling on the shore beneath. 


It has, not without reason, been supposed that the **Lapis Lydius**, and **Lapis 
Metallorum**, or touchstone of the ancients, was a kind of basalt; for it is sometimes rendered magnetic by the physical qualities of the iron, which is an essential ingredient, and under various degrees of chemical influence, the cause of 
those numerous shades of black, grey, and yellowish and reddish brown which it exhibits. 


Basalt is the **Basanos maximus Hibernicus** of old times. The Greek básanos 
is as the Latin probatio; and **Pliny**, in the 8th chapter of his 33d book, defines básanos "lapis index, seu Lydius et Heraclius, quem coticulam vocant:" and a very common definition of the word is, "lapis quo probatur aurum."


I am, however, inclined to believe that the pillared structure of basalt must 
have been the object considered for the purposes of its appellation; and that 
the word basalt, possibly at first basilt, is a mutilated derivative of the Greek basiliké 
regia domus, and edificium amplum, since a royal residence, or other 
stately edifice, is rarely destitute of pillars: and besides this, the Latin word 
, scarcely altered from the Greek basiliké, has, among other definitions, 
that of a piazza, which in Italian seems to imply a colonnade, or at least a building to the character of which pillars are essential.


It is remarkable that a late writer should have been disposed to adduce "a reason why the basaltic pillars are not produced at this day as they were 
formerly" since instances are no where wanting of their development before 
living witnesses. Many facts are well authenticated of basalt, which on the 
removal of the superficial soil, or on being worked as a common stone-quarry, 
appeared a shapeless mass, having divided itself, on the free accession of atmospheric air, into prismatic columns, from a height of many feet, to small specimens fitted for the cabinet. The latter is well instanced by Mr. Kirwan in 
a fragment of that basaltic rock known in **Ireland** under the name of **calp**, or 


---

p.151



 
black quarry-stone, which amongst many others, having been brought to **Dublin** 
for use, was observed "to burst," after "it was brought there, into regular pillars; some of an hexagonal, and some of an octagonal form; and some articulated exactly like the pillars of the **Giants' Causeway**." They were 
"about six inches long, and one fourth of an inch in diameter." I have further collected, without any extraordinary research, many interesting illustrations, on 
a small scale, of the omnipresent disposition of basalt to divide itself prismatically. 


By due observation it is sufficiently evident that the members of the mineral 
kingdom experience slow and unceasing revolutions, in concordance with the 
other admirable provisions of nature. While certain masses are decomposing 
and becoming fitted for the purposes of vegetation, others are arranging themselves, either by the acervation of materials unfitted for the service of organic 
life, or by the accession of sand and similar matters from the bosoms of the 
waters, thereby maintaining those diversities of surface essential to the health 
of animals at large, and delightful to the sense of man. Basaltic rocks of all 
others are productive of the richest soils; and they are no less remarkable for 
the purity and clearness of their waters. But it would seem as hopeless to expect that a mountain like **Chimboraco** should start up before our eyes, as that 
we may witness the formation of such piles as the **Giants' Causeway**, and the 
Cave of Fingal.




---

p.152


**Dunluce-Castle**. — **Craig-in-Ullar**. — **Coleraine**. — Salmon-Leap and Fishery — **Sir Hervey Bruce**'s Seat at **Down-Hill**. — **Ballymoney** and the Races there. — Specimen of Irish Play-Bills. — Divorce between the Car and one of its Wheels. — Conversation over the Fire-side of a Village Public-House. — The 
Wonders of the Town of **Kilcock**. — Christian Charity of a Saint. — The 
Moravian Village at **Grace-Hill**. — **Shanes-Castle**. — **Antrim**. — Return to 
**Belfast**.
#### 16


On the 22d of August I set off early in the morning from **Bushmills** to proceed on my route. The ruins of **Dunluce-Castle** are well known as a striking 
object in these parts: they lie about four miles west of the **Giants' Causeway**. 
A part stands on a rock, separated from the coast by a chasm eighty feet wide, 
much like **Carrick-a-Rede**: this is supposed to have been the whole of the original structure. The rock on which it stands is an entire mass of basalt, rising 
150 feet above the sea; within it is a large cave. The only access to the rock 
is by a narrow piece of wall over the chasm, just wide enough for a footway, 
and without any guard on either side. This is generally said to be one wall 
of a bridge: but some are of opinion that there never was any regular bridge 
that this is one of two parallel walls which crossed the chasm, serving as supports 
to boards occasionally thrown over, when any communication with the coast 
was wanted. The castle is supposed to have been built by MacQuillan, a powerful 
chieftain, from whose family it came by marriage into that of the Macdonnells, 
the ancestors of the Antrim family. It has long ceased to be the habitation of 
any other being than Mave Roe, a **Bansheigh**, very likely a descendant of some 
of the Finnian heroes, who built the Causeway. She is a neat little personage, 
for she sweeps the room she inhabits clean every day. After the murder of the 
Duke of Buckingham by Felton, his duchess, marrying the Marquis of Antrim, 
came to live at **Dunluce**, then the family mansion: but a part of the castle 
falling in a violent storm, she was so alarmed that she quitted it immediately, 
vowing never to enter it again: a suite of apartments was accordingly built for 


---

p.153



 
her on the terra-firma. Such, at least, is the account given of that part of the 
ruins which stand upon the coast. Its accuracy I very much doubt, since their 
appearance has much rather that of a no less remote date than the ruins on 
the rock; — they are in an equally dilapidated state. 
These ruins are not visible at any distance; they burst on a sudden upon 
the view when within about a quarter of a mile of them, and really have a very 
grand appearance. From the midst of a small bay running up at the foot of 
the rock on which the castle stands, rises a very remarkable mass of rock, 
almost a cone; the sides being much broken, in one part a sort of figure is 
formed which has strongly the appearance of a Turk sitting with his turban on his head.


I had originally intended visiting **Portrush**, and had a letter of introduction 
to **Dr. Richardson**, a name well known for his ardent researches into the geology of the country, though thought by most persons of science somewhat wild 
and fantastic in his theories. But having learnt that he was not in the country, 
as I could not see the owner of the place I did not go to the place itself. In an 
old quarry to the left, close by the road-side, about half-way between **Bushmills** 
and **Coleraine**, is a row of basaltic pillars as perfectly characterized as any in 
these parts. This spot is called **Craigahuller**, or **Craig-in-Ullar**, I know not 
which, for I have seen it spelt and heard it called both ways. Excepting **Dunluce-Castle** and this colonnade, nothing can be more uninteresting than 
the drive from **Bushmills** to **Coleraine**.


Neither is there much to attract attention in the town of **Coleraine** itself. 
The river **Bann** runs through it; and about a mile from the town is a salmon-leap, but I did not go thither. Salmon indeed abounds all along the northern 
coast of **Ireland**, and the best I ever tasted. From **Ballycastle** hither it was 
always the first thing proposed, when the question of dinner was brought upon 
the tapis. As a specimen of the amazing prolific nature of fish, it may be 
mentioned, that a naturalist had the curiosity once to examine the roe of a 
salmon caught in the river **Bush**, and found it to contain eleven thousand eggs. 
The salmon-leap near **Coleraine** is the property of **Sir George Hill**, who lets 
it at the rent of 1000l. a-year. 


From hence I went to **Down-hill**, the seat of **Sir Hervey Bruce**. The house, 
as I have already noticed, was built by the late **Bishop of **Derry** and Earl of **Bristol****. 
 


---

p.154



 
He has, indeed, fixed on a most extraordinary spot for building a 
house. It stands upon an eminence directly above the sea; — with a noble sea-view, it is true, and fine bold rocks rising almost perpendicularly above the 
water; but so miserably exposed to the turbulent north winds blowing along 
this coast, that one shivers involuntarily at the very idea of stirring without the 
door of the mansion, excepting during a few weeks in the middle of summer. 
The hill upon which the house stands is a sort of knoll: all round it is a plantation; very thriving, but so low down that scarcely can any thing of it be seen 
from the windows. The house stands, as it were, insulated from every other 
object. There is a good strand here; and a little to the west, at **Magilliganpoint**, the entrance of **Lough Foyle**, (which is plainly seen from the top of the 
rocks,) there is an extent of fine hard sand, sufficient for exercising a regiment 
of soldiers. On the strand I found shells of the genera **Venus**, **Arca**, **Solen**, 
**Voluta**, **Buccinum**, and **Nereis**. Near the entrance to the grounds is a very 
pretty little water-fall. In the house are some good pictures and sculptures, 
brought from Italy by the former owner of the house; but every thing was 
now in confusion: **Sir Hervey**, having pulled down the other house built by 
the bishop, had transferred a variety of things from thence to **Down-hill**, and 
was making great alterations in the house for their reception. Among the 
pictures are two called original Correggios, but their being really so is very much doubted.


Returning to **Coleraine**, I proceeded from thence to **Ballymoney**, which was 
to be my night-quarters. Here I found that I had fallen unluckily upon 
the time of the races; and at first there seemed some reason to apprehend 
a repetition of the night-adventures at **Cushendall**: however, the landlady of 
the inn (the Antrim Arms) was extremely civil, and exerting herself to make 
room for me, an arrangement was at length made, by which I was to have a 
bed-chamber. As the landlady thought I might be lonely, and want some 
amusement, she came and announced that there were players in town, for the 
races, if I would like to go to the theatre, and presented me with a bill of 
the performances for the evening. As this was the only opportunity which 
had fallen in my way of seeing an Irish itinerant company, I should most 
probably have gone, had I not been very much fatigued from a succession of 
days of pretty considerable exertion. I beg, however, to present my readers 


---

p.155



 
with a correct copy, verbatim et literatim, of the play-bill, by which they will see that in the art of lengthening out the bills of fare, and setting forth the dishes 
offered to the best advantage, the Irish itinerarians are not behind-hand with 
the English ones. 

> 
> On Tuesday Night, 
>   
>  
> By particular Desire and under the Patronage of the Stewards of the Races. 
>   
>  
> Theatre Ballymoney. 
>   
>  
> BY PERMISSION. 
>   
>  
> This present Tuesday Evening Augt. 23, 
>   
>  
> will be Presented the admired 
>   
>  
> and celebrated Play of 
>   
> 
> Inkle and Yarico. 
>   
>  
> Or Love in a Forest. 
> Inkle Mr. Loftus Monro, — Medium Mr. Davison,
>   
>  
> Sir Christopher Curry Mr. Heney, 
>   
>  
> Planter, Mr. Bennett, — Trudge Mr. Heney, Junr.
>   
>  
> Yarico Mrs. L. Monro, Wowski Mrs. Heney Junr. 
>   
>  
> Between the Play and Farce the following 
>   
>  
> ENTERTAINMENTS, 
>   
>  
> A Comic Song By Mr. Heney, Junr.
>   
>  
> Paddy Whack by Mr. Monro. 
>   
>  
> A New Ballet Dance called the
>   
>  
> Village Ghost, 
>   
>  
> Or all For 
>   
>  
> Ballymoney Races. 
>   
>  
> Old Snap (a Cobler, with a Comic Dance) — Mr. Loftus Monro,
>   
>  
> Ben Block, (with an Hornpipe in Character of a Sailor) — Mr. Heney, Junr. 
>   
>  
> Tom Clueline — Mr. Davison, 
>   
>  
> Fanny — Mrs. Loftus Monro,
>   
>  
> Jenny — Mrs. Heney, Junr.
>   
> 
> 
> 
> ---
> 
> p.156
> 
> 
> 
>  
> To Conclude with the celebrated Farce of 
>   
> 
> Love's Masquarade,
>   
>  
> Or the Intrigueing Baron. 
>   
>  
> Fredrick Baron Willinghurst — Mr. L. Monro! 
>   
>  
> Mr. Friz (a Hair Dresser) — Mr. L. Monro!! 
>   
>  
> Hannibal Whiskirisky (an old Invalid,) Mr. L. Monro!!! 
>   
>  
> Barn'by Almutz (an old Trooper) — Mr. L. Monro!!!!
>   
>  
> Mrs. Almutz an old Housekeeper) — Mr. L. Monro!!!!!
>   
>  
> Baron Piffleberg — — Mr. Heney.
>   
>  
> Hair Dresser — — Mr. Bennett. 
>   
>  
> Hans Mockus (an old Invalid) — Mr. Heney, Junr. 
>   
>  
> Lady Brumback — — Mrs. Heney, Junr. 
>   
>  
> Sophia Miss Bennett — Maria — Mrs. L. Monro. 
>   
>  
> BOXES, 2s. 6d. PIT, 1s. 8d. GALLERY, l0d. 
>   
>  
> Doors open at 7, begin Precisely at 8 o'Clock — No 
>   
>  
> admittance on any pretence whatever behind the scenes. — 
>   
>  
>  — A PLAY EVERY EVENING DURING THE RACES — 
>   
>  
> Henry Loftus Monro, respectfully hopes during his short stay,
>   
>  
> by a strict attention to the Comfort and Amusement of the Ladies 
>   
>  
> and Gentlemen of the Town and it Vicinity, to merit their support. 
>   
>  
> WEDNESDAY EVENING, THE POINT OF HONOR
>   
>  
> AND THE WAGS OF WINDSOR. 
>   
>  
> Note: Tickets may be had and Places taken of Mr. Monro, at 
>   
>  
> the Antrim Arms.
> 
> 
> 

 


I think some hints might even be taken by the cooks of English play-bills 
from their sister-country: the gradation in the number of points of admiration 
at the astonishing versatility of Mr. L. Monro's genius appears to me a perfectly 
novel idea, and one capable of being improved upon exceedingly. For example, 
in recording the enthusiastic shouts of applause with which a new piece, or a 
new performer, is always received, and which increases every night of the actor's 
performing, or of the play being performed, a regular daily increase of admiration-points at the conclusion of the record would, in giving a more elevated idea 
of the merits celebrated, at the same time have novelty to recommend it; — no 
trifling consideration in the satiety which begins rather to attend upon reading 
over a mere ringing of changes upon repeated reiterated shouts of applause, enthusiastic admiration, unbounded raptures, &c. &c. — For the rest there is nothing particular to notice in **Ballymoney** or the country about it.




---

p.157


#### 16


In the course of my conversation with the Scotchman at **Cushendall**, he 
asked whither it was my intention to direct my course after the **Giants' Causeway**? I said that I proposed returning to **Belfast** by **Coleraine** and **Antrim**. 
He then earnestly recommended my visiting a Moravian village in my route 
which I might do without lengthening the way, only by taking a road somewhat 
more in the interior of the country than the high-road from **Coleraine** to **Antrim**. My intended day's journey therefore on quitting **Ballymoney** was to visit 
this village, and go on to **Antrim** for the night. When we were about three 
miles from **Ballymoney**, I perceived on a sudden the wheel of the car on the side 
which I sat going rather oddly, and I was about to bid the driver stop and to 
desire the servant to get down and examine it, when before I could speak I 
found myself upon my knees in the road, the wheel flying off behind the carriage, 
and the driver thrown to some distance the other way, while the horse stopped 
in a moment, shaking and appearing wholly terrified: the cause of all was, that 
the linch-pin of the wheel had broke. Happily no one was hurt; my own 
fall was so very light that I was not even frightened: there was indeed in the 
manner of it something so approaching to the ludicrous, that I should have 
been disposed to laugh, had I not been alarmed for the driver, whose fall was of 
a much more serious nature; but he was a youth light and active, and fortunately 
received no injury. The great difficulty was, how we were to proceed. We saw, 
however, two or three cabins by the road side at the distance of not more than 
a quarter of a mile, and from one of them a large strong nail was procured as 
a substitute for the broken linch-pin; the people also told us that about two 
miles further on the road we should come to a smith's forge, where we could get a new one made. 


Thither we accordingly proceeded; but it was then discovered that some other 
part of the iron work was in a state so worn as to be in danger of breaking at 
every moment, and my servant said he thought it so unsafe that it was better to 
have the whole repaired, which the smith assured us he could do in two hours 
or two hours and a half. Nothing then remained, as a heavy shower at this 
moment came on, but to take refuge in a small public-house close by, and there 
wait till the son of Vulcan had concluded his operations, or till the rain would 
allow me to walk about and see whether any thing interesting or amusing was 
furnished by the spot. I sat myself down in the *kitchen* of the public-house, 


---

p.158



 
for parlour there was none, on one side of the fire where was a cauldron of potatoes making ready for the dinner of mine host, his family, the pigs and the fowls. 
After a little while, when mine host had surveyed me accurately, and I had asked 
two or three questions which seemed to encourage him to be talkative, he began 
by supposing that I had been at the **Giants' Causeway**. 
I replied in the affirmative. 
  
 
"A curious place, madam, a very curious place, — quite wonderful!"
  
 
"Yes indeed, it is very wonderful."
  
 
"Now, madam, I hope you'll excuse my freedom; but do you think it was really made by giants, or that it came of itself?"
  
 
"Oh certainly, I think it is a work of nature, not of giants."
  
 
"And yet, madam,'tis very odd: — Now do you know there's a place not a great 
way off from here, a sort of a hill like, and when they dig into it they turn up 
sometimes such monstrous great bones it would quite surprise you?they never could be common men's bones." 
  
 
"But where is this place, — couldn't I go and see it?"
  
 
"'Tisn't above two or three miles off"; and if it wasn't for the rain I should be quite proud to go and show it to you."


Indeed it was raining very hard; and had it not been so, I should scarcely 
have ventured to take the walk, not feeling any confidence as to the distance 
which he stated it to be. From experience I well knew that no dependence 
was to be placed upon these reputed distances, that the two or three miles might 
very likely be five or six. Sometimes in inquiring the distance of a place, the 
answer would be — so many miles and a wee-bit, but I always found the wee-bit 
was as much as all the rest. I therefore contented myself with hearing all my 
host had to say upon these great bones, which seemed to occupy his mind very 
much. When he had descanted upon them sufficiently, he mentioned two or 
three other places and things which he assured me were quite worth seeing; 
and at length said, "But there's one place, madam, which above all others you 
should see, for that is a curious place indeed." 
  
 
"And where is that?" 
  
 
"Tis Kilcock, madam." 
  
 
"What is there so very curious in it?" 
  
 
"Why now, madam, perhaps you won't believe me, but I can assure you 'tis 


---

p.159



 
quite true; and it isn't only such poor folks as I that say it, for you might laugh 
at us, but quite learned people will tell you the same — Now do you know, madam, that no cock ever will crow there; and not only that, but if you was to 
bring a cock there from ever so far off, even from England, though he crowed 
ever so well before, he'd never after *crow another word."*
  
 
"Indeed." 
  
 
"Yes, 'tis quite true I can assure you, madam."
  
 
"Well, but what's the reason of it? — for there must be something very extraordinary that occasions it."
  
 
"To be sure, madam; and I'll tell you how it is. A great many years ago there was Saint Columbkill; he was quite a great saint, and he came to preach here in **Ireland**; and so he went about first to one place, then to another, till at last he came to **Kilcock**. Well, he stopped at an inn for the night, but he 
made a vow that he'd get up the next morning at cock-crowing and set out 
again preaching, so he bid the landlady call him when the cock crowed. Well, 
the cock he crowed quite early, a long time before it was light; so the landlady 
she went and called the saint; but he never looked that the cock should crow 
so early, and he didn't much like to get up; but as he had made a vow that he 
would, why he got up, because he wouldn't break his vow. However, he was 
so angry with the cock, that as he went out of the town he cursed all the cocks, 
and prayed that they might never crow there again: — no more they ever have."


This legend he related with the utmost seriousness, and seemed to be impressed 
with the most perfect conviction both of the effect and its cause. I found in 
more instances than this that St. Columbkill was a saint in great repute in the 
country, second only to St. Patrick. His name, properly Columba, has been 
converted into Columbkill from the island in which he was buried, one of the 
Hebrides. In consequence of his remains being deposited there, it was called 
I-Columb-Kill, that is the burying place of Columba; till in process of time the 
meaning of the addition kill (burying-place) being lost, the whole was considered 
as the name of the saint.


The job of two hours or two hours and a half lasted four; but for this I was 
well prepared, so was not much disconcerted by it. The whole delay, however, 
occasioned by the accident was such that to get to **Antrim** that night became 


---

p.160



 
entirely out of the question; the only question was — whither we could go; and I 
learned with great satisfaction that there was a very comfortable inn at **Grace-Hill**, the Moravian village: this we reached some little time before dark. The 
country through which we had travelled the whole day was very dull and barren 
of interest in any way. **Grace-Hill** is however a pretty little spot formed by the 
**Moravians** in this dreary country. The approach is prepossessing, through an 
avenue of ash-trees nearly meeting and forming an arch over the road. Two 
short streets go off at an angle from the road, and run parallel to each other up 
to a green, round three sides of which is the principal part of the village. In 
their neat appearance, and the neatness of every thing about them, these people 
strongly resemble the **Quakers**. The upper end of the green is occupied by the 
chapel, a boys school, and the house for the **single sisters**. They are, as the 
name imports, a society of unmarried women. Their number was at this time 
about sixty, and they were of all ages. They live all together, having lodging-rooms in common, full of small beds like the wards of an hospital; they eat 
their meals together, sit and work together, and have a seat appropriated to them 
in the chapel. No vow is taken against marriage; but any one marrying quits 
the society immediately, and establishes herself with her husband in some of the 
houses of the village. A variety of works are carried on among them; working 
muslin, making lace, spinning, knitting, plain-work of every kind, fancy pin-cushions, housewives, purses, and the like, child-bed linen, &c. &c. There are 
manufactories of various kinds carried on in the village; as stuffs, linens, cords, 
and others. On one side of the green is a large shop for the sale of these articles, where are also sold groceries, earthenware, and a variety of things such as 
are of general and constant want among them, and they have in the village a 
baker, a butcher, &c. &c of their own. Many of the things made here, particularly the works of the **single sisters**, are sent all about the country, even as far 
as **Dublin**, for sale. The green is inclosed with a paling, and trees are planted 
all round: within is a gravel walk for general recreation and relaxation. There 
are also very good schools both for girls and boys. I attended their evening 
service at seven o'clock; it consisted principally of singing hymns, in which the 
whole congregation joined; the minister besides read parts of the Scriptures, the 
prayers were very short. I found the inn very comfortable, every thing extremely 


---

p.161



 
neat, and the people very civil and attentive. Indeed I was, as my 
Scotchman predicted, exceedingly pleased with the whole society, and was very glad he had mentioned it to me.


The worst part of the story was, that either a wrong direction was given us 
at the inn as to the road we were to take to **Randall's-Town**, or we misunderstood it; for we got into a most deplorable road indeed, far worse than any 
I had yet seen, unless that in going to **Knock-Laid**. At length, however, 
**Randall's-Town** was reached in safety; and having breakfasted there, I proceeded to **Shanes-Castle**, the seat of **Lord O'Neale**, on the borders of **Lough Neagh**. This lake is said to be in extent the third in Europe: but the accounts of its 
size vary exceedingly; by some it is called twenty miles long and fifteen broad, by 
others fifteen in length and twelve in breadth. The shores are every where flat, presenting no beauty to the eye; and as the distance from one shore to the other is too 
great for the eye to reach, considering the flatness of the shores, nothing is presented but a vast expanse of water. Petrified wood is occasionally found about the 
lake, but in very small quantities, and naturalists are extremely divided in their 
opinions whether this effect is produced by the waters of the lake or by peculiar 
properties in the soil round about. On the shore I found pebbles of several 
varieties of basalt, of common quartz, of chalcedony some of them having an 
opaline tendency, with some few agates; all these were evidently produced from 
masses of amygdaloid or basalt. There were besides flint pebbles of various 
colours.


**Lord O'Neale**'s family claims to be one of the oldest in **Ireland**, they trace 
their descent from the ancient kings of **Ireland**. A pedigree had just been made 
out from the Heralds' Office by **Sir William Betham Ulster King at Arms**, very 
finely written on vellum, beautifully illuminated and most splendidly bound, 
doing all together infinite credit to the several persons concerned in the execution 
of it. Great alterations were going forward at this time in the house: a fine 
conservatory was built, to which a grand eating-room was to be joined, the windows commanding an extensive view over the lake. There was a very fine collection of old china arranged in a closet with great taste, which had glass doors opening to the breakfast-room; also some good pictures. By order of the owner, a 
great deal of venerable old furniture, which had been thrown aside for the more 
light and frippery decorations of modern days, was now replaced. Alas! since 


---

p.162



 
this time all has been destroyed by a fatal fire. — What a severe trial, to see the relics of so many years in one moment fall a prey to that all-consuming element! All the appendages to the house, as kitchen-gardens, conservatories, stables, dairy, every thing belonging to a farm, were at a little distance from the 
house, all in a style worthy of an ancient nobleman; every thing in short displayed 
a spirit of true nobility. One division of the garden was entirely devoted to rose-trees, of which there were above four hundred different species.


From hence we proceeded to Antrim, which is not more than two miles from 
**Shanes-Castle**; and after visiting the Round-Tower about half a mile from the 
town, arrived in the evening at **Belfast**. In crossing the mountains between 
**Antrim** and **Belfast** we were enveloped for half an hour in the thickest fog I 
ever saw; the so much celebrated fogs of London might well hide their diminished heads before it. Happily it cleared away in time to allow of our seeing 
the fine view presented from these heights over the town and **Bay of Belfast** 
and the fertile valley of the **Lagan**. Seldom have I passed ten days of higher 
gratification than those in which I made this circuit; I had only to regret that 
I could not devote more time to it. If any one should think that I have suffered the delight I felt to betray me into being too diffuse in the above relation, 
and should wish for a more concise account of the same tour, I beg leave to 
refer him to **Sir John Carr**'s work. Though conciseness is not in general the 
distinguishing characteristic of his writings, in this instance he seems to have 
been studious to dismiss his narrative in the fewest words possible. "After a 
very interesting tour," he says, " in the north, in which I visited **Lough Neagh**, the marvellous pillars of the **Giants' Causeway**, the basaltic shores of the county 
of **Antrim**, **Belfast**, and the principal towns in that flourishing part of the country, I returned to **Dublin**, and prepared to quit a country which delighted and 
astonished me, &c. &c." — I really do not think it could have been possible for 
any writer to have expended less time, less thought, and less paper, in going 
over so many miles of ground.




---

p.163


Visit to **Hollywood** near **Belfast**. — Sail upon the Lough. — Mr. Coulson's Manufactory of Table-Linen at **Lisburn**. — The **Giants' Ring**. — Drumbo Steeple. — Final Departure from **Belfast**. — **Newcastle**, a great Bathing-place. — Mountain of **Slieve Donard**. — **Kilkeele**. — **Bay of Carlingford**. — Beautiful Scenery of **Rostrevor**. — The Town of **Carlingford** and its Antiquities. — 
Great Limestone Quarry there. — The Obelisk near **Drogheda**. — Return to **Dublin**.
#### 17


On the morning after my entering **Belfast** I was presented by **Dr. Macdonnell** 
to a lady who he said had been very solicitous for my return; and I soon found that she was **Mrs. Hughes**, the daughter of **Sir Edward Newenham**, and sister 
to **Madame Folsch** of **Marseilles**, in whose society I had passed so many pleasant hours during my residence in the South of France. **Mrs. Hughes** had 
done me the honour of reading and liking my Narrative of my Residence in France; and learning from it how much I was then acquainted with her sister, when she heard I had been and was to be again at **Belfast**, became 
anxious to see me, and talk with me about the family. She was living with her 
only daughter, who is married to Mr. Kennedy, a gentleman of fortune having 
a very pretty seat at **Hollywood** on the edge of **Belfast Lough**, upon the Downshire side, about four miles from the town. Thither she would fain have carried me to stay some days, but I could spare no more time than to spend that 
day with her and return the next. Though nearly ten years had then elapsed 
since my quitting France, it was so much longer since she had seen her sister, 
that she said my intelligence seemed comparatively recent, and it was quite a treat to question me about her.


Mr. Kennedy has a nice little schooner, in which he took me a very pleasant 
sail about the Lough before dinner. The water was high, the day was particularly fine, and nothing could be more beautiful than the scenery every way. A 
sort of stone here presents itself very different from any thing I had found on the 
other side of the bay; — a yellow magnesian-limestone. It abounds much 


---

p.164



 
with crystallizations. **Mrs. Hughes** was so obliging as to contribute to my 
mineralogical collection a piece of beautiful sparry incrustation from the **Graysheep's Cave** in the county of **Tipperary**, and some from **St. Michael's Cave** at **Gibraltar**.


On the twenty-seventh of August, the last day before my finally quitting 
**Belfast**, I went over to **Lisburn** to see Mr. Coulson's manufactory of damask 
table linen,


On the morning after my entering **Belfast** I was presented by **Dr. Macdonnell** 
 furnishing me with a recommendation, as it is never 
shown without one. It is, indeed, a most beautiful manufacture, and well 
worth seeing, though the machinery of the vast looms in which it is wove, is 
so complicated that it is not at all to be understood by merely looking on at 
the people as they are working. The linen manufactured here is in no way inferior to the foreign manufactures. 


I went to **Lisburn** by a road on the different side of the river **Lagan** from 
that by which I had come to **Belfast**, and stopped by the way to see two objects very near the road. One was a curious place called the **Giants' Ring**. 
It is a very large circle inclosed round with a high bank of earth not wrought 
up to a point, but having a walk along the top. In the centre of this ring is a 
Cromlech, consisting of four large masses of stone, not all of equal height, 
standing perpendicular, with a much larger laid horizontally upon them; but 
from the height of the supports being unequal, it is not perfectly level like a 
table, but lies in an inclined position. Upon the bank are the remains of, a 
round-tower, of which not more than perhaps fifteen feet from the ground remain standing. It is strange, but this spot seems scarcely an object of attention to any one, though it ought in my opinion to be a very interesting one to 
the researchers into the antiquities of the country. Its existence even is not 
much known at **Belfast**, though it is not more than four or five miles from the 
town. I had heard of it by chance; but when I asked about it of the master 
of the hotel, he said he knew of no such place, I must have made some mistake. I was perfectly assured, however, that I had made no mistake, that such 
a thing did exist; and when I asked **Dr. Macdonnell** about it, he could tell me 
in what direction it lay, but even he had never seen it, nor was at all aware that 
there were remains of a round-tower as well as the cromlech. The existence 
of a round-tower on a spot manifestly a remnant of Druidical superstition, 
seems strongly to support the idea that these extraordinary structures were connected 


---

p.165



 
with that ancient religion, and that so many being near churches was 
owing to the preachers of the new religion choosing to erect their religious 
edifices on spots already consecrated in the eyes of the multitude, which 
they would probably always regard with reverence, and it was therefore wise 
to give that reverence its proper direction. That they were ever erected as 
belfries, may do very well for an hypothesis to those who have never seen them; I cannot conceive how any body that has, can for a moment subscribe to such an opinion. 


The second object which I turned aside to see in my way to **Lisburn** was 
part of another round-tower in the church-yard of Drumbo, and called in the 
country Drumbo steeple. This is a very imperfect one; not more of it remains 
than perhaps between thirty and forty feet in height. I have not found either 
of these mentioned any where as among the number of these structures still in 
existence whether wholly or partially. The Post-Chaise Companion, in general 
a very excellent guide about the country, does not notice them, nor indeed does 
it mention the **Giants' Ring**. 


On the 28th of August I finally took my leave of **Belfast**; — of the civilities I received there I shall ever retain a grateful recollection. Instead of returning to **Dublin** by the way I had come, I determined on making a little circuit to see the beautiful **Bay of Carlingford**, and the scenery around it. In 
this route, no object particularly worthy of notice presented itself on the first day's journey till the ruins of **Dundrum-castle**. They are boldly situated 
on a high rock, very near the little bay of the same name. The castle was 
originally a strong fortress, and belonged to the Knights Templars, after which 
it was transferred to the Prior of Down, from whose hands it passed early in the 
sixteenth century into the hands of the crown: after various fates it was dismantled by order of Cromwell, and has ever since been falling more and more 
to decay. 


**Newcastle**, a small village directly on the sea-shore, and at the foot of **Slieve Donard**, the loftiest of the Mourne mountains, was the place on which I had 
fixed for my night quarters. Here again I was in some danger of being obliged 
to bivouac out in the air upon my car. Not that there was either fair or races 
to interfere with my having a bed; but poor as the village is, it is the principal 
sea-bathing place in the county of **Down**, and during the bathing season it is 


---

p.166



 
thronged with company on a Sunday from the neighbourhood for many miles 
round, as if it were the time of a fair. Now it happened unluckily to be Sunday evening, and there was not a corner in any public house, scarcely in any 
private one, that was not preoccupied. I was assured, however, I might depend upon a bed, since very few would stop for the night; but the bedchambers 
were all transformed into rooms of entertainment where were parties at tea, or 
regaling with whiskey punch, and certainly not as silent as the grave; while, 
perhaps, as the parties were not accustomed to break up early, the bed might 
not be ready till twelve or one o'clock. I was just about ordering the horses 
head to be turned, and going for the night to **Castle-Willan**, a little town about 
two miles off, when the landlady, not liking to part with a guest, at length 
dismissed a party who she thought had called for as much as they were likely to 
call for, and were now therefore occupying the room unprofitably, and possession was given to me. 


**Slieve Donard** is here a majestic object, rising somewhat more than three 
thousand feet above the level of the sea, which washes its base. The structure of this mountain is singular, being granite with a buttress, as it were, of 
slate on one side. I cannot give this as the result of my own examination, for 
I had neither the time nor means to ascertain it; but I was thus informed by Mr. 
Ryan the miner whom I had seen at **Belfast**, by whom it had been explored. 
He also mentioned another curious circumstance respecting the mountainous 
regions of the county of **Down**; that on the summit of the slate mountains 
which rise above the **Bay of Carlingford**, and which are at some distance from 
the granite **mountains of Mourne**, there lies a vast solitary bolder of granite. 
I found small blocks of granite and schist promiscuously in a little channel 
down the side of the mountain which was then dry, but which is occasionally 
a waterfall; and going along the foot of the mountain the next day, from a 
part of the rock by the road side I got pieces of striated slate.


From **Newcastle** to **Kilkeele**, where I breakfasted the next day, a distance of 
ten miles, the road lies entirely at the base of the **Mourne mountains**, on a 
terrace at no great height above the sea. In clear weather the **Isle of Man** is 
seen very plain for a considerable way in going along this road: unfortunately 
it happened to be as foggy a morning as could annoy a traveller, and I could 
sometimes even scarcely distinguish the sea washing the base of the terrace. 


---

p.167



 
For awhile I was very much afraid that the beautiful scenery of **Rostrevor** on 
the **Bay of Carlingford**, which I was now approaching, would be wholly lost. 
By the time, however, that we quitted **Kilkeele**, where on account of the horse 
a stop of two hours was made, the fog was beginning to clear away, and before 
we reached the **Bay of Carlingford** the sun came out, and the day was delightful.


The road continues to skirt the long range of the Downshire mountains the 
whole way to **Rostrevor** on the **Bay of Carlingford**. Few spots are more beautiful than the little village of **Rostrevor**, and the scenery about it. After having 
continued coasting naked and barren mountains for fifteen or sixteen miles, all 
on a sudden the eye is delighted with the sight of a very high slope wooded 
all over from the very summit to the water's edge. The road continues still 
upon a terrace above the water, and goes directly through this wood. At the 
end of it Rostrevor-quay, as it is called, nearly a mile from the village, 
opens; it is a row of houses at the foot of the wooded hill, with the bay in 
front; and here the entrance to the bay and the main sea being entirely shut 
out from the view, it has all the appearance of lake scenery. After passing the 
quay the road is again carried amid woods up to the village; one of the prettiest villages, surrounded by some of the prettiest scenery, that can be imagined. Nor is it wholly destitute of grand features; behind the village the 
mountains rise to a pretty considerable height, and they are also lofty on the 
other side of the bay. I would earnestly recommend to every body going into 
the North of **Ireland**, instead of following the common high road to **Belfast**, 
to turn off at **Newry** and see **Rostrevor**; he will be amply repaid by the beauty 
of the spot for going a little out of the way, and perhaps it does not add more 
than ten or twelve miles to the distance. A better way I think than I came, 
and certainly a nearer, is to strike directly from **Rostrevor** into the road to 
**Castle-Willan**, not to follow the coast. I found nothing very interesting in 
this coast road, and it lengthens the way very much. 


*From* **Rostrevor** I proceeded along the northern shore of the bay to a place 
called **Narrow-Water**, where the bay is contracted into a river, and where there 
is a ferry. Crossing here I went on to the town of **Carlingford**, which is almost at the entrance of the bay on the south side. This is a very old town, full 
of ruins of ancient castles and monasteries. One of the castles is called **King John's Castle**, and is reputed to have been built in the time of that sovereign. 


---

p.168



 
It stands upon a rock directly above the sea, and some of the walls are eleven 
feet thick. It seems to have been intended as a defence to this narrow pass, 
which, like another Thermopylae, has high and abrupt mountains directly above, 
with an impetuous sea dashing below. There are altogether seven castles, or 
monasteries, of which ruinated fragments are remaining. 


But it was not these remnants of antiquity which attracted me to **Carlingford**; my principal object was to explore an immense quarry of gray limestone 
about a quarter of a mile from the town. And, indeed, I found here many 
very interesting objects of mineralogical research. This quarry lies at the 
foot of a high mountain, and from various appearances there is sufficient 
reason to believe that the upper part of the mountain has a tendency to being 
basaltic; in the quarry itself are two strata, which differ essentially from the 
limestone, which are not fusible, and are accordingly thrown aside by the workmen; by them this is called greenstone, and it certainly has a strong basaltic 
tendency. I had been told that the mine was not only intersected horizontally 
by strata of this stone, but that it was also cut by them vertically; this, however, I could not find to be the case. What confirms the basaltic nature of 
this stone is, that whereas the limestone abounds with traces, casts, and impressions of numerous shells and zoophytes, we may almost say is crowded with 
them, no organic remains are ever found in these strata. The limestone also 
abounds with very brilliant flattened crystallizations of iron pyrites. The zoophytes are of infinitely larger dimensions than common, and exhibit numerous 
transverse partitions which are covered with a minute crystallization, sometimes 
of calcareous and sometimes of siliceous matter. The casts of one species 
of shell, the genus of which does not yet appear to have been determined, but 
having much the character of a Nautilus, were so extremely abundant, that in 
the course of the evening while I was sitting at the inn, several parcels of twenty 
or thirty each were brought by the men and boys offering them for sale. 
They are mostly covered with minute crystallizations. Amygdaloid is also 
common here, as is the case in most districts where calcareous and basaltic 
masses prevail. There is a rock at the mouth of the bay, concerning which I 
was informed that it is partly granitic partly basaltic, but it is not often accessible on account of the excessive surf about it. 


The next day I went on to **Drogheda** through Dundalk, and from **Drogheda**


---

p.169



 
visited the Obelisk, erected in memorial of the ever-memorable battle of the **Boyne** about two miles west of **Drogheda**. It is a hundred and fifty feet in 
height, and stands on a vast mass of granite rock perhaps twenty feet above 
the river, at the edge of which it rises. It is generally said that the obelisk 
rests on the very spot where the **Marshal Duke de **Schomberg**** was killed; but 
considering the mass of rock on which it stands, that cannot be. Indeed it is 
believed by many that the great conflict was half a mile higher up the river, 
and that this station was only fixed on for the obelisk on account of the rock, 
which in adding to its height would at the same time place it out of the reach 
of being injured by persons coming to see it. On the four sides of the pedestal are inscriptions; but they are at too great a height ever to have been well 
seen, and they are now very much defaced by time.


The next day, the 31st of August, about one o'clock I re-entered **Dublin**, 
collecting by the way from a limestone quarry between **Swords** and **Dublin** several very good specimens of organic remains.




---

p.170


**Mr. Kean**'s Benefit, Anecdote respecting it. — Excursion in the County of **Wicklow**. — Rocking-Stones. — Bullock. — The Granite Rocks. — **Newrath-Bridge**. — Rosanna. — The Devil's Glen. — **Glendaloch**. — Legend of St. Kevin. — The Seven Churches. — **Glen Molaur**, Lead-Mines there. — **Rathdrum**. 
 — **Avondale**. — Meeting of the Waters. — Copper Mines of **Cronebawn**. — The beautiful **Vale of Avoca**. — Wicklow Gold-Mine. — **Arklow**. — Wicklow. — The **Scalp**. — Return to **Dublin**.
#### 18


When I came over to **Ireland** my intention was to have directed my course 
to the South as soon as possible after my return from the North. Subsequent 
circumstances made me abandon the idea of visiting the south this year, leaving to the casualties which might arise in future, whether it ever would be visited 
at all; and I determined now to confine my researches to such parts of the 
county of **Wicklow** as I could comprehend within four days, and then depart for England.


Contrary to my expectation when I quitted **Dublin**, I found **Mr. Kean** still 
there at my return, and that his benefit was to take place on the very day of 
my arrival. I mention this circumstance to introduce an anecdote which 
strongly marks the Irish character. Of course it was presumed by every body, 
considering how much he had been a favourite with the public, that his benefit 
would be complimented with an overflowing house. Great applications were 
made at the boxkeeper's office for places; but the reply given to most people 
was, that **Mr. Kean** kept the letting of the boxes in his own hands, that he 
might oblige his particular friends. This was so far from being the truth, that 
when **Mr. Kean** applied himself for a box to oblige a particular friend, he 
was answered that they were all let. What the boxkeeper's aim could be in 
making these contradictory answers is not easy to be guessed, unless, by enhancing the difficulty of getting places, to entice people into giving him a bribe 
to endeavour to accommodate them. The consequence, however, was extremely injurious to **Mr. Kean**; the public at large were exceedingly offended 


---

p.171



 
at the idea of his making such an invidious distinction between them and a 
few private friends; while the private friends who had asked him in vain to procure them places, ascribed his not obtaining them to negligence on his part, 
that he did not choose to give himself any trouble about it. Thus, instead of 
an overflowing house as was expected, it was not in fact by any means a full 
one. Every body present saw this with astonishment, and the question naturally was asked, how could it happen? — The cause, upon inquiry, soon became manifest; and the public indignation was so exceedingly roused against the boxkeeper, that when **Mr. Kean** was to act a few nights after for the last time, a 
number of ardent spirits expressing their feelings upon the occasion to him 
very warmly, asked, de bonne foi, whether he would like that they should make 
a riot, and pull the theatre down. If **Mr. Kean** was gratified by this warmth of 
feeling, and he could not be otherwise, he begged to decline such an expression 
of it. 


On the third of September I set out early in the morning on my circuit about 
the county of **Wicklow**. I directed my course along the southern shore of 
**Dublin Bay**, hitherto known to me no further than **Blackrock**, having much in 
view by taking this coast road to **Bray**, to see a curiosity concerning which 
doubts are entertained whether the thing is natural or artificial. This is one of 
those stones known by the appellation of rocking-stones, a vast mass so poised 
upon a slender basement as visibly to vibrate with the wind, yet never to fall. 
Of these stones there are only a few to be seen, scattered in different parts of 
the country; they are considered by some as remains of Druidical superstition, 
by others they are believed natural productions. To my great disappointment, 
I learnt when I arrived at the spot, and inquired for the rocking-stone, that it 
had been blown up some time before in quarrying stone near it. How much is 
it to be regretted that the men of taste and science in every country, and such 
are not rare in **Ireland**, do not make themselves the guardians of all curiosities 
in their neighbourhood, whether natural or artificial, and prevent their falling in 
such a manner by the untutored hands of ignorance! I afterwards learnt that 
there is a cromlech in a glen near this place, and some remains of a Druidical 
temple, but it was not till too late to see them. Such remains of this superstition being in the neighbourhood gives reason to suppose that the rocking-stone 
was also a Druidical work. Nothing tormented me more in **Ireland** than the 


---

p.172



 
difficulty I found, wherever I went, of learning what there was worth seeing, 
and I often missed objects which I could have wished much to examine, 
from not hearing of them till too late. After I had returned to **Dublin** from 
the North, I found that instead of coming from **Drogheda** by the same route 
that I had gone, I might have varied it and taken a much prettier road, not 
above a mile about, through **Naul**, where are rocks, caves, a glen and a waterfall, to vary the scene, instead of the dull monotony of the high road; but of 
this road I did not know till the time was past when I could avail myself of the 
intelligence.


The town of Bullock stands in a most wild country, scarcely producing any 
thing but the granite-stone used in these parts for such a variety of purposes. 
In some places there is a little soil and herbage, but the prominent feature every 
where is stone, and again stone. This is the whole character of the country in 
going over the heights that form the entrance of **Dublin bay** to the south. In 
arriving at their summits, a fine view opens over the beautiful little **Bay of Killeny** and the fertile country towards **Bray**. I stopped to breakfast with the 
hospitable family at **Ravenswell**, and bid them that disagreeable word Adieu. 
Here I met Mr. Cuthbert returned from his circuit, and received from him a 
great deal of information respecting the country, which enabled me to make the 
most of the short time I could allot to my excursion. I went on that night to 
**Newrath-Bridge**, (Newry-Bridge as it is pronounced), about two miles from 
**Wicklow**, near which is **Rosanna**, once the habitation of **Mrs. Henry Tighe**, 
not less celebrated for her beauty than for her poem of Psyche. This poem 
certainly proves that much elegance of mind was combined in this lady with 
elegance of person: it is not free, however, from a fault, but too common among 
poets, that in parts it is very obscure. It seems indeed almost an idea with some 
who enlist under the banners of the Muses, that they are not poetical unless obscure; in my own opinion, be the subject what it may, or whatever may be the 
diction in which it is clothed, to be clear ought to be the first thing studied, let 
ornament follow, to whatever extent the taste of the author may lead; 
yet surely 
he shows the best taste who restrains himself from a lavish use of it; and perhaps the great fault of modern poets is the hunting too much after it. Psyche is however without doubt a work of great merit. There is nothing very striking 
either in the house (I mean only as to the exterior, for I did not go into it) or 


---

p.173



 
in the grounds, at **Rosanna**; indeed the house may rather be called ugly, built 
of red-brick, and nearly a square. Were it not for the name of Tighe, now associated with the place, scarcely would the attention of any one be directed 
towards it.


The next morning it was my intention to go in the first place to **Cronroe**, 
the seat of Mr. Eccles, two miles from **Newrath-Bridge**, where is a very remarkable rock: but unfortunately taking a wrong turn soon after we left the inn, we 
got quite astray from it, and were not aware of the mistake till the time spent to 
repair it would have cut too deep into the day, and I was forced to abandon it 
entirely. I proceeded therefore to the **Devil's Glen**, the next allotted object of 
the day. Of the numerous beautiful glens with which the county of **Wicklow** 
abounds, this is by far the most so. I thought the **Dargle** beautiful, I thought 
the **Glen of the Downs** beautiful,I thought the Hermitage beautiful, but I found 
them all thrown into complete eclipse by this paradise of the Prince of Darkness: — how his name ever came to be associated with such a spot is wholly incomprehensible. In what the superior beauty of this dell over all the others 
enumerated consists, it is difficult to give an idea by describing it: no more can be 
said, than that it is a dell winding among vast rocks well clothed with wood, with 
a stream in the bottom tumbling over broken masses of rock, forming a number of petty cascades, till at the end of the dell is a fine cascade pouring down 
from the heights above perhaps a hundred and fifty feet. Yet such a description can give but a very imperfect idea of the beauty of the spot; — perhaps it 
may be the forms of the rocks, perhaps the greater breadth and more broken 
nature of the stream; I know not what it is; 
 — the **Devil's Glen** is but a wooded 
dell, and the others are of the same nature, yet there is a charm in this far beyond them all. I was almost tempted, as I wandered through the enchanting scene, 
to perpetrate some evil deed which would render me fit society only for the gentleman after whom it is named, that I might come and take up my abode there. 
Towards the upper end of it we came to a cottage, where we stopped to inquire 
our way to the place at which the car had been directed to meet us. As no 
carriage can go through the glen, that had been sent by a circuit to the heights 
that rise above it on the road to **Glendaloch**, there to wait for us. A woman 
from the cottage said the way was not easy to find, and as we might very likely 
miss it, she offered to accompany us. In our walk falling into conversation 


---

p.174



 
with her, she gave such a detail of the sufferings of herself and her family the 
preceding winter, the severe one of 1814, that I almost ceased to think the spot 
a paradise; indeed, suffering as the family did from cold, they would perhaps 
almost have rejoiced to have found it a Pandaemonium. She said that whenever a heavy fall of snow came, it drifted so much in that confined valley, that 
sometimes for several days together they could not get out at the cottage door 
till her husband was able to remove the snow, and then he had to clear a path 
along the valley in order to get at any other human habitation. If they had not 
been fortunately provided with a very good winter stock of potatoes and turf, 
they would have been in great danger of being starved or frozen to death. Her 
melancholy tale seemed almost an epitome of some of the stories of cottages 
among the Alps buried for many days, nay some even for weeks, beneath a mass 
of snow falling from the mountains. 


Under the convoy of this good woman we rejoined our car, and proceeded 
through what may fairly be called an ocean of mountains, to **Glendaloch**, that 
is, the Valley of the Lakes. Nothing was to be seen the whole way but a series 
of undulations resembling nothing so strongly as the sea when the waves are 
rolling about in mountains. About half a mile from the valley we passed a few 
houses, when a man darting out from one, set off running full speed after us, and 
*soon* coming up with the car, panting for breath, announced himself as the guide 
about **Glendaloch**, whither he supposed we were going. Answering in the affirmative, he began to hold forth very eloquently upon the wonders of the place; 
on which I left him to descant awhile, and then said, "How much do you expect for shewing it?" to which he replied "Only eight-pence a shoe, my lady." 
I must confess his answer somewhat puzzled me, since I saw no immediate connection between a shoe and the curiosities of **Glendaloch**, unless that was honest 
Pat's mode of expressing so much for each person. On asking an explanation, 
it appeared that besides being guide of the place he was by profession a blacksmith, and mistaking the word shewing for shoeing, he thought I was asking how 
much he would charge for shoeing the horse.


Most of the writers upon **Ireland** have remarked, that the greater the distance 
from the capital the more wretched are the habitations of the peasantry. Indeed my observation leads me to say quite otherwise. I found the peasantry in 
the North much more decently housed than in any part of **Ireland** that I saw 


---

p.175



 
while at the entrance of **Glendaloch**, about twenty miles from **Dublin**, were a 
little cluster of five or six cabins miserable beyond any thing that could possibly 
be conceived as intended for human habitations; they would have been thought 
in England almost too wretched for lodging the pigs. It may however be said, 
that in **Ireland** the pig is the member of the family whose comfort seems the 
most attended to; for there is no cabin, however poor, in which a pig is not 
a constituent member of the little community. A gentleman told me, that 
once in a walk he took refuge in the cabin of a peasant during a heavy shower, 
where the family were at dinner; the pig was, as usual, eating potatoes out of 
the same mess with the rest, making himself in other ways extremely free and 
sociable. The gentleman not thinking his company so agreeable as it seemed 
to be thought by the family, said, "I wonder, friend, that you keep the pig 
here, that you don't make him a separate house." "Nay, plase your honour," 
said the man, "I don't see why you think that; I don't see but the pig have 
every convanience here that a pig can want." He seemed to think that the 
gentleman's anxiety referred entirely to the pig, not to its owners.


**Glendaloch** is the site of an ancient city, formerly a bishop's see, which 
under the reign of King John was united with that of **Dublin**, or rather swallowed up in it, since after this union the name of **Glendaloch** as a see was 
wholly lost; the archbishopric remained that of **Dublin** only, the name of its 
suffragan was never added: one of the archdeaconries, however, of St. Patrick's 
cathedral is still called after it. The valley is encompassed with dark and 
gloomy rocks, throwing a shade around which seems to mark it as a proper 
theatre of superstition, and such it ever has been, such it is in some sort even 
at this day. The upper end is occupied by two lakes, whence it has its name. 
The remotest of these is nearly walled in by the rocks. On one side they rise 
abruptly, directly above the water; on the other, having a little more slope, its 
borders may be coasted to the end of the valley. It is closed by an amphitheatre of rocks, down which runs a considerable cascade. Some other streams 
run down the rocks, but none of any consequence. From this lake the valley 
gradually expands, and there is a considerable space of meadow between the 
two lakes. Indeed the first lake is wholly surrounded by meadow, though in 
some places very swampy. The ancient superstitions had peopled this valley 
with evil spirits, and its lakes with devouring serpents. When the Christian 


---

p.176



 
missionaries first began to preach the Gospel, it was expedient to annihilate this 
superstition; and since there is no means so effectual of eradicating one as by 
substituting another, it was resolved to produce a saint whose wonder-working 
hand should destroy these objects, no less those of veneration with the multitude than of terror.


To the saint thus conjured up was given the name of St. Kevin. On the 
origin of this name antiquarians are divided. According to some, Cevn, Kevn, 
or Kevin, was the name given of old to one of the mountains, from which it was 
transferred to the saint who was to hallow the mountain. **Dr. Ledwich** says 
that it was a very common practice in those early times, which were in nothing 
more distinguished than in being prolific of saints, to call a newly-created one 
after the name of some river, mountain, or other remarkable inanimate production of nature. Whatever might be the origin of his name, the saint, once 
produced, was a prodigious worker of miracles; in this respect he was scarcely 
inferior even to St. Patrick or St. Columba. A young man, his relation, who 
was under his tuition, and was exceedingly beloved by him, was attacked by 
a dreadful disease, which seemed likely to prove mortal, when the idea seized 
him that he should be cured by eating an apple, and he earnestly requested 
his patron to procure him one. Unluckily it was now the month of March; 
and it should seem that in those days the art of keeping apples through the 
winter was less understood than it is at present, for not one was to be had. 
Saint Kevin, therefore, addressed his prayers to Heaven, that its mercy might 
be extended to the unfortunate youth; when looking around him he observed 
a willow-tree just by, which had the extraordinary appearance of being full of 
ripe apples. Overjoyed at the sight, he gathered three and carried them to the 
young man, who eating them, found immediate relief from his malady, and in 
a short time was restored to perfect health. The same saint one day in Lent, 
having put his hand out at the window, raising it up piously towards heaven, 
a blackbird perched upon it, and in an instant deposited her eggs there. The 
holy man, in compassion to the bird, neither closed his hand nor drew it in, but 
remained with it stretched out in the same manner till the young birds were 
hatched and able to fly, when quitting their asylum he found himself at length 
released from a situation which certainly was by no means one to be envied. 
Again: Going up a hill one day in a time of dearth, he met a woman carrying 


---

p.177



 
a sack, in which were five loaves of bread. He inquired what she had in the sack, 
to which she answered, "Stones;" — "I pray that they may be so," said the 
saint: and immediately five stones rolled one after the other out of the sack.


But the greatest of all his miracles was the driving away from the valley the 
evil spirits by which it was infested, and chaining fast the serpents that inhabited 
the lakes, to the rocky bottoms beneath. This done, and the place rendered 
habitable for mankind, a city was built under his auspices, which was in nothing so remarkable as in the number of churches it contained. Such is the 
fabulous legend of the origin of this city: at what time or by what race it was 
really built, cannot be ascertained with any certainty; but from the architecture 
observable in the few remains of it now existing, the probability appears that it 
may be dated even as far back as the seventh century. They are certainly 
some of the oldest remains now existing in **Ireland**. The Irish annals relate 
that this city was several times ravaged and plundered by the piratical Ostmen, 
or Danes, while they retained their footing in the island. These depredations, 
however, it appears to have survived, and to date its decay only from its being 
annihilated as a bishop's see. 


From the confined space in which it stood, in a narrow valley bordered on 
three sides by rocks and lakes, it could never have been a place of large extent. The 
only remains now standing are those of the Seven Churches, as they are called, 
and from which the place is much more generally distinguished as The Seven 
Churches, than by its proper appellation of **Glendaloch**. The valley is entered 
from the east, and near the entrance stands The Ivy Church, so named, very appropriately, from the trifling remains that are standing being entirely overgrown 
with ivy. The abbey, of which there are also very inconsiderable remains, was 
according to tradition founded by Saint Kevin in the sixth century: here were 
many sculptures, ample descriptions of which are to be found in Dr. Ledwich's Antiquities, with an explanation of the supposed emblems intended in them; 
some of the figures are dragons and other fabulous animals; but the wolf seems 
the prevailing figure, he is under various forms and variously employed. 


The cathedral is the most conspicuous among these vestiges of remote times. 
The nave is forty-eight feet in length and thirty in breadth; a semicircular 
arch divides it from the body of the church. Round the east window are some 
sculptures representing parts of the legend of Saint Kevin: among them is a 


---

p.178



 
dog devouring a serpent, supposed to be emblematic of the saint's having destroyed the serpents by which the lakes were infested; — but was it quite correct 
to represent the saint under the form of *a dog?* — Below a window on the south 
side of the choir is a tomb with some carving about it, but not having any inscription. It is remarkable that this tomb is of freestone, and so are the sculptures round the window. This is a sort of stone not common in **Ireland**; there 
is a fine quarry of it at **Rosenallis** in the **Queen's County**, said to be nearly if 
not altogether equal to the Portland or Bath stone; none is known of at present nearer to **Glendaloch**, and more than sixty miles was a vast way to have 
transported it, in the rude days when these fabrics must have been constructed. 
The building itself is the granite of the country. 


Saint Kevin's Kitchen is the name given to the most perfect of these ruins. 
The outward walls are nearly entire. It had only one window, which was ornamented with an architrave, and this also was of freestone. The area of this 
church is twenty-three feet in length by fifteen in breadth; the height 
twenty feet, and the walls measure three feet and a half in thickness. At 
the east end is a small archway, which leads to an inner chapel ten feet and 
a half in length and nine feet wide. On the north side of this chapel is a door 
which goes to another chapel, the same length and nearly eight feet wide. The 
chapels are of equal height, twelve feet, and have walls three feet in thickness; 
each has a small window in the centre of the east end. How this building has 
obtained the name of Saint Kevin's Kitchen, I could not learn. The other 
churches are Our Lady's Church, Trinity Church, and Teampall na Skelig, 
that is the Temple of the Desert, called also the Priory of the Rock.


In the cemetery, and near the cathedral, is a stone cross on which are some 
carvings not ill executed; it measures eleven feet in height, and is cut out of one 
stone. A round-tower also stands in the cemetery; it is in good preservation, 
excepting that the conical cap by which all these towers seem to have been terminated is entirely gone. To the Ivy Church, as also to Saint Kevin's Kitchen, 
are attached round-towers, not incorporated with them as if they had been built 
at the same time and intended as a part of them; they are evidently detached 
buildings, either of prior erection to the church and the church added to them, 
which seems the probability; or, as some are of opinion, subsequently erected 
in addition to the church, A third object of notice in the cemetery is the 


---

p.179



 
wreck of an ancient yew-tree, which measures, if I mistake not, thirteen feet in 
the girth. The trunk is entirely hollow, and within it grows a holly, rising in 
three stems, each measuring at least two feet in circumference. Close by is 
a stone, probably once a part of some of the buildings, which has a concavity in 
it that holds water, and the water that lodges in it is an infallible cure for corns. 
There are many other stones lying about which seem to have some wondrous 
virtue in them, since by several there were persons kneeling at their prayers. 


In a rock rising above the further lake, at a considerable height above the 
water, is a cave which is called Saint Kevin's Bed. It is only accessible by a 
steep and narrow path in the rock, just wide enough for one person, and, being 
directly above the water, if the least false step be made, destruction is almost inevitable. Such an accident is recorded to have happened a few years ago to a 
young woman; she slipped, and was precipitated into the lake, nor was ever seen 
more. I did not attempt going up to it; in fact, I could not learn that it was 
worth taking the trouble of ascending to such a height, even if there had been 
no danger. Women visiting it are secured from any danger of dying in childbirth. Between the cathedral and the first lake is a cluster of very large thorns, 
which are said to have been planted by Saint Kevin. On the 3d of June, the 
anniversary of this Saint's death, the people from a great way round flock to 
**Glendaloch** to celebrate the day. A small stream which runs to the north of 
the valley is called Saint Kevin's Keeve. Weak sickly children, if dipped in 
this stream on a Sunday or Thursday morning before sunrise, will gain strength and become healthy and thriving.


The mountains here are a compact variety of schistus approaching in its general character to grey-wacke, abundantly veined with quartz, which is extremely reddened by ferruginous matter, offering to the eye a very beautiful marble-like 
appearance. 


There seems to be some connexion between seven churches and a round-tower, since there are no less than four places in **Ireland** where we find this combination. In the **Bay of Scarriff**, on **Lough Derg**, is a beautiful and fertile island 
on which are the remains of seven churches and a round-tower seventy feet 
high, in extremely good preservation. On an island in the **Shannon**, properly 
**Inis-Catha**, but commonly called **Scattery**, are seven churches and a round-tower. It it said that there were originally eleven churches here but this is 


---

p.180



 
much doubted, since seven are standing, and if ever there were more, all traces 
of them are lost. At Kilmacdaugh, in the county of Galway, are seven churches, 
one, as at **Glendaloch**, a cathedral, and a round-tower; the latter is one hundred and twelve feet high, and is remarkable for inclining seventeen feet from 
the perpendicular, which is four more than the celebrated tower at **Pisa**. There 
are three other places where are seven churches together, but not accompanied by the round-tower. 


From **Glendaloch** I proceeded over a continuation of wild and desolate mountains to **Glen Molaur**. This mountain road is one of several military roads 
made since the rebellion of 1798, over the mountainous parts of the county of **Wicklow**, to facilitate the passage of troops. I have spoken more than once 
of the many beautiful wooded dells, or glens, with which this county abounds, 
I must now speak of one of a very different description. **Glen Molaur** is a valley 
through which runs a stream bordered on each side with a narrow space of meadow, above which rise rude and barren rocks; but for the strips of meadow which 
seem foreign to the spot, it would be a fine scene of wild and savage grandeur. The 
valley runs on for several miles. A road was a few years ago made through it, 
and carried over the lofty amphitheatre of hills, by which it is bounded to the 
west, to form a more ready communication between the eastern and western 
sides of the county of **Wicklow**. At the place where the new military road 
crosses this, barracks have been erected, and they have led to a very good inn 
being established at a little distance. It was kept now by English people. I 
inquired what I could have for dinner; the reply was as usual, Chickens. "Let me have one roasted immediately." — "Very well; but it can't be ready for two hours." — "What do you mean? if 'tis alive now, it may be ready in half that 
time." — "No, 'tis not alive now, but 'tis impossible to get it ready sooner than I said." — "Get me some eggs, then, I won't wait for the chicken." — " They'll 
take us almost as long to do." — "Well, then the horse shall have a feed of corn, and I'll wait for my dinner till I get to **Rathdrum**." — "You'll be very late getting there; and we have very good beds here, you'll be very quiet and comfortable." — "Possibly, but I choose to go to **Rathdrum** to-night." — and away I 
walked, rather angrily, to visit some lead-mines about half a mile from the inn. 
These rocks are schistose, in some places exceedingly steep, almost perpendicular, in others less abrupt, everywhere abounding with quartz; large blocks of 


---

p.181



 
pure quartz were lying in different parts; blocks of mica slate were also scattered 
about, of a remarkably red colour, doubtless the result of oxyd of iron; their external surfaces were entirely covered with gray lichens. The ore is chiefly found 
at a considerable height in the rocks, and shafts are made at the foot of the 
rocks to ascend to them, the same as I had seen at the collieries at **Ballycastle**. 
I collected here foliated galena, or sulphuret of lead, having occasionally an 
earthy character, very good pyramidal crystallizations of quartz, gneiss in a 
state of decomposition, and quartz in a variety of figures. I also got the ore 
in its different stages of preparation; it is esteemed of a very good quality. 
On the other side of the river, nearly opposite the lead-mines, is a waterfall 
down the side of a very abrupt rock; it was now well supplied, and the water 
rushed down with great force.


This glen was in the reign of **Queen Elizabeth** the great asylum of **Hugh O'Birne**, who so long defied the higher powers, and was the scene of a terrible 
catastrophe to a party of English troops sent against him by **Lord Grey**. After a 
toilsome march, as the valley appears then to have been a perfect swamp, **O'Birne** 
and his followers, when the enemy were exhausted, poured down upon them 
from the fastnesses in the rocks among which they were themselves concealed, 
and the whole invading party were cut to pieces. Several officers of distinction 
fell; and the loss of the troops was the greater, from their being veterans long 
trained in these Irish wars, and selected therefore for the service. 
After stopping about an hour at the mines I returned to the inn, where I 
found all things prepared for dinner, and was informed the chicken was quite 
ready if I would please to stop and eat it. Though I was very angry with 
the people for having endeavoured to impose upon me, and make me stop there 
for the night, I did condescend so far as to put my anger in my pocket and eat 
the chicken. This done, I proceeded on to **Rathdrum**. The entrance to the 
valley, by which I was now making my exit, is very pretty; the valley expands, 
the hills gradually slope away, the river assumes a more romantic appearance, 
being wooded at the sides, and in the midst of the woods is a romantic bridge 
making a very pretty subject for a sketch; but I am no sketcher myself, and had 
no one with me to take it; I can only recommend the subject to any one who 
may pursue the same route, possessing the talent in which I am deficient. Soon 
after passing this spot the evening came on, and I saw no more of the road to 


---

p.182


**Rathdrum**: but I have no reason to suppose this was any great loss. At **Rathdrum** I was again annoyed by finding it the time of a fair for wool, flannels, and 
woollen cloths, so that I could not get a bed at the inn; but the people of 
the inn procured me a very comfortable private lodging. At the entrance to 
the town is a large wool-hall, with a spacious area before it, where the fair was 
held. I walked up to this place in the morning, and found people thronging in 
from the country with their manufactures for sale, women as well as men riding 
on horseback between their bales of cloth or flannel. On one horse were, besides 
two large bales of cloth, two very well dressed women, who just before they got 
to the fair alighted, and sitting down by the road side drew on their stockings, 
having hitherto had only shoes. They then remounted their nag, and rode in 
high ceremony into the fair. Every thing brought for sale is deposited in the 
area before the hall, and nothing can be sold till an officer regularly appointed 
for the purpose goes round and measures the goods, giving a ticket of the number of yards each piece contains, and any one attempting to make more of it is subject to a heavy fine.


About two miles from **Rathdrum**, on the road to **Tullow**, there were formerly 
some of the most extensive iron-works in **Ireland**. They are now carried on to 
some extent, but have declined very much from what they once were, owing to 
the scarcity of wood for fuel. From the same cause many other iron-works in 
different parts of **Ireland** have for some years declined, while it is much to be 
feared there is no great disposition in this country to apply a remedy to the 
evil, that we may keep in our hands the supplying **Ireland** with wrought iron of 
all kinds. There is nothing very pretty either in the town of **Rathdrum** or its 
immediate environs, though it stands on the verge of one of the most beautiful 
parts of the county of **Wicklow**. 


About a mile from **Rathdrum** I quitted the car to walk through the beautiful 
grounds of **Avondale**, formerly the seat of Mr. Hayes, by whom, he having no 
heirs of his own, it was bequeathed to the late patriotic **Sir John Parnell**, in 
whose family it now remains. The river **Avonmore**, that is *the great winding 
stream,* meanders through the grounds, having a shallow channel, tumbling over 
broken masses of rock. Its sides are sometimes fringed with close thickets of 
wood, sometimes with fine lawns having majestic forest-trees scattered about; 
in parts the dell is quite inclosed, having only majestic rocks covered with ivy 


---

p.183



 
and rock-plants on each side; then again it expands, forming for three miles the 
most varied and beautiful scenery imaginable. About a mile from the house is 
a rustic cottage delightfully situated in the midst of woods close by the river, on 
the opposite side of which the rocks are very line and majestic. But this charming place was now deserted; the house was shut up, and every thing wore the 
appearance of being neglected, and mourning the desertion of the owner. Yet 
such are the natural charms of **Avondale** that no neglect can render it other than a most enchanting spot.


These grounds terminate at **The meeting of the waters**, a name to which the 
delightful muse of the Anacreon of **Ireland**, **Mr. Moore**, has given a celebrity 
which can never be lost again among the lovers of harmony of poetry or the 
beauties of nature. It is a sort of confluence of several beautiful little valleys, 
through some of which flow clear and limpid streams, and uniting here they form 
the **Avoca**. The principal of these streams are the **Avonmore** and the **Avonbeg** or little Avon. **Mr. Moore** attributes a part of the enchantment he found in 
this scene, and the sweet vale of **Avoca**, to visiting them in the society of friends 
whom he loved and cherished. Assuredly the society of friends, if they are 
friends indeed, adds indescribably to the charm of every spot; we may fairly say 
that every pleasure is at least doubled by being thus shared: but independent 
of every auxiliary, the meeting of the waters is truly a scene of enchantment.


From hence to **Arklow**, a distance of nine miles, is perhaps as beautiful a 
drive as can be seen in any country round the globe. The road lies entirely 
along the vale of **Avoca**, having the river winding through it with the most 
delightful wooded slopes rising on each side. Such is at least the general character of the vale: in one spot the wooded slopes are changed for high 
and naked rocks, where lie the copper mines of **Cronebawn** and **Ballymurtagh** 
on opposite sides of the river. To those of **Cronebawn** I ascended, but the 
rocks are steep and the ascent toilsome. The shafts are at a great height in 
the mountain, and go down to a great depth; there are several now no longer 
worked, the vein of ore having been exhausted, but new veins are continually 
found. I observed some of these neglected shafts having the mouths so much 
overgrown with thistles and brambles, that it was not easy to perceive them; 
and I remarked to the surveyor who was with me, that I thought it very 
dangerous, since a person might easily slip down one unawares. He said he 


---

p.184



 
thought the same, and had many times recommended to have planks laid over 
them. There, however, he added, it was not of so much importance, for very 
few except their own people ever came near the place, and they were all well 
aware of them. But he said he knew an instance in another quarter, where the 
shafts being in a much more frequented part, a gentleman was riding at full 
speed, and not perceiving a shaft in like manner overgrown, he did not think 
of checking the horse. Had the animal perceived it, being an excellent leaper, 
he had probably cleared it; but he slipped in such a way that he threw his rider 
over to the other side, while he himself fell down and was never heard of more.


These rocks are a schist, and abound with the copper pyrites, which occasionally exhibits a pavonine tarnish. The schist is sometimes of a very deep gray 
colour, and is then the most rich in metal; sometimes also it has the green cast 
commonly called verdigris. The ore, when prepared for commerce, is either 
of a dull red or yellowish gray. The prevailing character of the schist is massive and rather of a granular texture, though sometimes it is considerably laminated, showing a smooth fine even surface. A stream strongly impregnated 
with vitriol, of great use in preparing the copper, is afterward suffered to run 
down into the river below, which it really poisons with its deleterious qualities; 
 — this surely ought not to be permitted. I was informed that from the place 
 — where the water is thus contaminated, to where it runs into the sea at 
**Arklow**, 
no fish can live in it, and that the working these mines has totally destroyed a 
very fine salmon-fishery at **Arklow**.


From this place the vale continues running in a southerly direction for some 
way, with the beautiful woods of **Ballyarthur**, the seat of Mr. Symes, skirting 
it. Then suddenly it takes a turn to the west, almost in a right angle: at this 
point there is a view down five different valleys, each, though bearing a general 
resemblance to the other, having its peculiar and distinct character. Here is 
a sort of second meeting of the waters, the **Avoca** being joined by a mountain 
stream pouring from one of the valleys. A road branching off from this point 
leads to the celebrated **Croaghan mountain**, whence came the gold which for a 
short time almost turned the heads of the whole neighbourhood. The precise 
time when the precious metal was first gathered never could be authentically 
ascertained, since those whose fortune it was to make the discovery strenuously endeavoured to conceal it, that the benefit might be reserved to themselves 


---

p.185



 
alone. From the best information that could be obtained, it appeared 
that a peasant lad about fourteen years of age angling in the stream which descends from the mountain, perceived some glittering substance among the sand 
at the bottom of the stream, and dipping for it he brought out a piece of gold. 
Surmising what it was, he was induced to make further search, and from time 
to time finding more treasure, he entered upon a traffic with a goldsmith at 
**Boyne**, to whom each new prize was carried and sold, the purchaser most 
likely taking sufficient care that he himself should not be on the losing side of 
the bargain. At length his frequent visits to the stream grew to be a matter 
of observation among the neighbours, who, rightly conjecturing that there must 
be some motive for them, became inquisitive upon the subject, and soon possessed themselves of the important secret. This was in the autumn of 1795.


The discovery was soon blazed abroad, and in an instant all other occupations 
were laid aside — the spade, the plough, the spinning-wheel, the loom, all, all 
were forsaken in search of the hidden treasures which there was no doubt the 
mountain contained within its bosom.


The tumultuous throngs that assembled here soon called forth the attention 
of the Government: it was judged necessary to subject the whole matter to 
some control; and a detachment of troops was sent to take possession of the 
prize in the name of the Crown, and keep off all other visitants. A grant 
of 1000l. was afterwards made by Government to two gentlemen of the 
neighbourhood, for the purpose of prosecuting scientifically the researches into 
the hidden treasures of the mountain. No mine or vein of gold could, however, upon the most diligent examination ever be discovered: the source 
whence the precious metal is derived still remains a secret; the great deposit 
must lie at a distance from the surface which baffles all research. Indeed it 
should seem as if the genius by whom the treasure is guarded (for it must be 
presumed that it is not without a guardian genius), offended by the intrusions 
attempted on his privacy, now in anger withholds his bounties, since in the 
latter years rarely has any gold been found, and, if any, in very small grains 
indeed. It was during the time when the treasure was open to the public 
that the greatest harvest was collected. Probably the treasures had been gradually accumulating unobserved; but the secret once revealed, not the slightest 
deposit can be made which is not immediately observed and secured. Gold to 
the amount of about 10,000l. was collected during this harvest. It came in 


---

p.186



 
pieces of various forms and sizes, the largest ever gathered weighing twenty-two ounces avoirdupois weight, while some was in grains scarcely larger than 
sand. This large piece has already been mentioned in speaking of the 
**Dublin Society**, in whose museum a model of it is to be seen. It was found by eight 
poor labourers, who united together, agreeing to share fortunes in whatever 
they found. Eighty guineas was the price they received for it. Had my time 
not been very much limited, curiosity would perhaps have led me to see a spot so 
celebrated; though in fact I understand there is nothing to see but a naked mountain, with a little stream running down from it, such as may be seen in a hundred other places. But limited as I was in time, my great object was to catch 
such spots alone as presented something particularly striking.


From the point whence the road to this mountain diverges from the sweet 
vale of **Avoca**, this beautiful vale gradually expands, the hills sloping away till 
on approaching **Arklow** the country becomes nearly a flat. A new road has 
lately been made through this part of the valley, at the foot of the hills, instead 
of going over their summits. It winds through **Lord Carysfort**'s woods, having 
the beautiful woods of **Shelton**, the seat of **Lord Wicklow**, on the other side of 
the river. At the latter place are some of the finest oaks to be found in **Ireland**. 
There is something picturesque in the appearance of the town of **Arklow**, as 
approached on this side, standing on a slope above the river, with a ruined 
castle crowning the eminence, and the long bridge of twenty-one arches over 
the mouth of the river.


Having stopped here a sufficient time to bait the horse, to eat my own dinner, 
and to take a walk upon the beach, which affords nothing particularly worthy of 
remark, I proceeded along the coast to **Wicklow**. The shore for a length of way 
here is a flat sand; but in one spot rises a very remarkable sand-hill, the abode 
of innumerable rabbits. The situation of **Wicklow** is rather fine, lying on the 
slope of the promontory known as **Wicklow Head**, but I saw nothing remarkable in the town as I drove through it. I say drove through it, for that was 
all I did. I had intended stopping there for the night, and the next morning 
exploring some limestone caves at the foot of the Head; but though there was 
no fair here, no races, the town, from what cause I could not understand, was 
so full that not a bed was to be had either at an inn or in a private house, and 
I was obliged, though now dusk, to go on two miles further to my old quarters 
at **Newrath-Bridge**. Thus I not only lost the sight of my limestone caves, but 


---

p.187



 
of the celebrated **Curragh of Wicklow**. This is a vast bank of sand; not absolutely forming the beach, but rising a little way from it, leaving a narrow channel between that and the beach. The sand is so firm, that the races are 
held here. I was informed that very good pebbles of agate and chalcedony 
may often be found upon it.


The next day I proceeded towards **Boyne**, passing through the **Scalp**, a natural curiosity which I had not yet seen. It is a vast gap in the summit of a 
mountain separating the county of **Wicklow** from that of **Dublin**, and has 
every appearance of being a rent made by some terrible convulsion of nature. 
For the two annexed plates of this extraordinary fissure I am indebted to my 
very good friend Mr. C ... , and they will give a much better idea of it than 
can be given by any description. The first is taken at the end of the gap on the 
county of **Dublin** side, with the sugar-loaf mountains seen at a considerable 
distance through it; — the second is taken in the centre of the gap, looking in 
the same direction, and shows the character of the rocks exactly as they appear rising above the road. By these it will be seen, that at bottom the gap is only 
the breadth of the road, and that the rocks slope away from it, so that at the top 
they are a considerable distance asunder. The sides of these slopes are strewn 
all over with immense blocks of the granite of which the mountain is composed. 
More accurate views of the spot I can safely say could not be taken.


That this extraordinary chasm should ever have been supposed to be produced otherwise than by some powerful operation of nature, or the hand which 
directs all nature, mighty in all its works, far beyond all efforts of human industry and ingenuity, I should have conceived scarcely possible. Yet the 
compiler of a work published about two years since, The Travellers Guide through Ireland, suggests a new theory, which I shall give in his own words, 
making two or three remarks upon it, and then leaving others to form their 
own opinions upon its probability or improbability. "This chasm," he says, 
 — is imagined to have been caused by some violent convulsion of nature, which has rent the mountain in twain; but no theorist has ventured to conjecture that the breach might have been effected by dint of human labour, this being the only horizontal communication with the rich and enchanting valleys to the southward of this steep and almost perpendicular mountain, over whose transverse summit the formation of a road was impracticable. If **Ireland** was as much civilized in the remote periods of antiquity as represented in the 


---

p.188



 
legends of Celtic antiquarians, such an effort of art for the attainment of so 
important a purpose would exist a noble memorial of sagacity and industry. 
But whether our progenitors might overlook the advantages derivable from so 
direct a communication, it is not a violation of probability to suppose that this 
stupendous operation might be projected by the eagle-eyed sagacity of the 
Danish conquerors during their sway in **Ireland**; and a recollection of those 
immense mounds, the work of their hands, still existing in this island, corroborates this novel conjecture. The wide aperture of this rent at the apex, diagonally narrowing to the bottom, where it is only wide enough for a road, 
savours more of human art than the majestic grandeur of Nature's operations. 
Thus might this singularity be explained without the intervening agency of a genie, a giant, or a fairy — 
  

*Nec Deus intersit, nisi dignus vindice nodus.’’*

Horace, Ars Poetica

 
Against this theory is to be objected, that it was not impossible to carry a 
road over the mountains, since one is carried over, very near the chasm, to the 
lead-mines. In the next place, if hewn by the hand of man, whence come all 
those enormous broken masses of stone that cover the sides of the chasm — 
and in the third place, a road being made through it is a work of very modern 
date. There are many persons living who remember its being made, and who 
talk of the vast labour employed in removing the broken masses that lay scattered at the bottom of the hollow, so as to level it for making the road. If the 
work is not to be ascribed to the great Architect of the universe, it seems more 
natural to ascribe it, as it is sometimes ascribed, to the opposite agent than to 
the hand of man. Some will have it that this same agent one morning bit this 
piece out of the mountain for his breakfast; and it must be owned that it was 
a breakfast worthy of himself. But this agent is not a very favourite workman 
in **Ireland**, and I believe there are not many votaries to this theory. I scarcely 
ever heard of any great achievements of his: if he did accomplish that in 
question, he seems to have gone after breakfast contentedly to his glen, and 
there remained quiet; indeed he had every reason to be satisfied with his birth. 
The great operators of wonders in **Ireland** are giants, fairies, and saints.


In the afternoon of this day, the fourth from my departure, I re-entered 
**Dublin**, having gone over as much beautiful and grand scenery in the course 
of my excursion as could well be comprehended in so short a space of time.




---

p.189


Departure from **Ireland**. — Passage to **Holyhead**. — The Rope-Bridge. — Custom-House Officers. — The Blind Harper. — Bog-Wood in the Isle 
of Anglesea. — The Mona Passage. — Bangor Ferry. — Tediousness of the Welsh Postillions. — Fall of the Conway. — Lake of Ogwen. — Capel Kerrig. — Glyndyffis. — The beautiful Vale of **Corwen**. — Castle Dinas Bran. — Harper at Llangollen. — Anecdote respecting the Ladies of 
Llangollen. — Stay at Gresford. — Lord Grosvenor's House at Eaton. — Return to London.
#### 19


Three days after my return from rambling about the county of **Wicklow**, 
my residence in **Ireland** was concluded for that year; and I was to bid adieu 
to a country where I had spent three months which will ever be included 
among the pleasantest of my life. I should indeed be extremely wanting in 
gratitude were I not to say, that wherever I went I experienced the most flattering reception, and received the most polite attentions, while at the same time 
the beauties and wonders presented by nature afforded me the highest gratification.


It was about six in the evening when I embarked at the Pigeon-house, and 
the next day at twelve I landed at **Holyhead**. A new scene was now opening 
upon me. To every part of **Wales** I was a perfect stranger: but
  
 
"The shaggy tops of Mona high" 
  

as they present themselves on approaching **Holyhead**, offer nothing interesting 
to the eye; 'tis by the force of imagination alone that they become so. They 
are naked barren rocks, not sufficiently towering to be sublime, nor combined 
in any way with other objects so as to be rendered beautiful. The most striking 
object to me in approaching the coast was the appearance of a rope-bridge, like 
what I had recently seen at **Carrick-a-Rede**, and which I had supposed an unique 
of its kind. **Holyhead**, or The Head, as I found it almost universally called on 
both sides of the water, on the western coast of the ancient Mona, or the island 
of Anglesea, is itself an island, separated from the main partly by a bay or 
estuary of the sea, which runs a considerable way inland, and then by a narrow 


---

p.190



 
channel, over which there is a bridge: this island is again terminated by another island, or insulated rock, forming the most westerly point of the coast, 
and over the chasm which separates the rock is the bridge in question. On the 
rock stands the light-house. Perhaps the bridge had remained unobserved by 
me, as the vessel does not pass very near the rock, had it not been pointed out 
by one of my fellow-passengers, when looking through my glass I found it 
very distinguishable. He told me at the same time that there was an idea of 
throwing this aside, and replacing it by an iron bridge: — that was not done, 
a year after; whether it has been done since, I know not.


I have in my Travels in France had occasion to say a word in favour of 
those generally reviled beings, Custom-House Officers, and I must be indulged in 
again pleading their cause here. As far as I have had any concern with them, 
I never found them other than civil and reasonable. In the present instance 
my packages were not even opened. The officer inquired what they contained; I answered, My clothes and a few books. He asked whether Irish printed books: 
I replied, No, books that I had carried over for my amusement in travelling: 
to which he said, Very well, he would not give me any further trouble, they 
might be taken away. I observed one of the passengers extremely anxious about 
a small cask of whiskey which he had on board the packet: whether he might 
pass as easily at the Custom-house I cannot say. At the hotel I was much 
pleased with a blind harper playing his sweet Welsh airs. To me these wild 
unpolished instruments are far more delightful than the harp under all the refinements of modern fashion.


The remarks made on **Holyhead** and its vicinity will apply nearly to the 
whole island. Were it not for the associations combined with this ancient theatre 
of druidical superstition, the country would appear dull, dreary, and barren, till 
the fine ridge of the Carnarvon mountains begin to show their dark summits, 
when somewhat more than half way between **Holyhead** and **Bangor-Ferry**. In 
ancient times it is to be supposed that the island was well wooded, since groves 
of oak appear to have been inseparable from the druidical mysteries; now 
scarcely is a tree to be seen, at least in such parts of the island as the high 
road passes through; I cannot answer for any thing further. An account of 
the Island of Anglesea, published in the year 1775, from a manuscript in the 
library of Jesus-college, Oxford, intended as a supplement to **Rowlands**' 


---

p.191


Mona Antiqua Restaurata, mentions the low grounds on the western side of the 
island as composed of a good brick turf, which furnishes fuel to the inhabitants. "In digging for this turf," the writer says, "they frequently meet with 
large bodies of trees preserved entire, though several feet under ground; now 
and then only they are found within a foot of the surface. How preserved so 
long in this state of humidity is a problem hitherto unresolved, being supposed 
to have been cut down by the Romans when they invaded the island. The 
wood, however it has happened, is become hard, and black as ebony; the carpenters of the country split it into laths, it being found very durable, and well suited to such purposes." This describes exactly the bog-wood so much and so deservedly esteemed and admired in **Ireland**. It were worth investigating whether it is still to be found: if it is, an admirable accession would here be attained 
to the other valuable productions which within a few years this island is 
known to contain. Besides the rich treasures of ores which have been 
found in the northern part, the Mona marbles, now coming somewhat into use, 
are very beautiful. The green even approaches in beauty to the celebrated 
verd antique of Italy. Fine specimens of these marbles wrought into furniture 
may be seen at Mr. Bullock's in Tenterden-street. Yet perhaps found within 
our own shores, they will never be held in equal estimation with those imported 
from a distance: — such is the general propensity of mankind to disregard what is easily obtained.


Nothing can form a finer contrast than the naked shores on the Anglesea side 
of the **Mona Passage**, and the fine ridge of mountains with the beautiful scenery 
on the Carnarvon side. The light was just such as to show it in the highest 
perfection, the day beginning to decline so as to throw a slight shade over the 
mountains which increased their sublimity, yet not sufficient to prevent any object from being distinguishable. Above them all **Snowdon** reared its majestic 
head. By the time that I had crossed the **Mona Passage** at **Bangor-Ferry** the 
day was closed, and here I stopped for the night The situation of the inn is 
one of the most beautiful imaginable, on a terrace at no great height above the 
water, at the foot of lofty mountains, with sweet little plantations down to the 
water side.


My destination now was to pay a short visit to some relations, three sisters, 
living near Wrexham in Denbighshire, and the question was what route I 


---

p.192



 
should take. I was very much inclined to pursue the old road from London 
to **Holyhead**, over **Penman-maur**; not that I had any idea, like the poor Welshman in the Spectator, of making a lover's leap of it, hut from a love of any stupendous object. However, after inquiries made at the inn, it appeared to me 
that I should find the new mail-coach road upon the whole the most interesting, and on that I determined; nothing doubting, calculating by the rate of travelling to which we are accustomed in England, that I should pass the next 
night, the distance being no more than sixty-five miles, under the roof of my 
relations. The better to secure this point, I set out early from **Bangor-Ferry**; but I soon perceived that the rate of travelling in **Wales** was not to be estimated 
upon the scale of the eastern parts of our island. The first stage, to Capel-Kerrig, a distance of seventeen miles, was accomplished in exactly four hours, 
nor could all my rhetoric, though frequently employed, prevail on the driver for 
one moment to alter the very gentle motion into which he had at first put his 
cavalry. I could have thought many times in the course of this drive that I 
was again in the county of **Wicklow**, so strong a resemblance is there between 
the scenery of the one and the other. For a long way the road continues 
through a fine dell, with stupendous rocks of slate on either side, and the river 
Conway flowing through it. This dell commences at the celebrated slate quarries of Lady Penrhyn, near the city of Bangor, and continues to the great fall of the Conway at Llyn Ogwen. I know not the computed height that the river falls; but including the whole descent, which in several places is interrupted by 
shelvings of the rocks, I should conceive it not less than three hundred feet. 
It is indeed a magnificent object. By the side of it the road ascends, being 
cut out of the slate rock, and guarded on the side of the cascade by a parapet. 
On arriving at the head of the cascade, a lake is presented to the view occupying the breadth of the dell, which is here considerably expanded, still being bordered with abrupt rocks, though of a less height than in the former part. There 
is just a sufficient space for the road between the lake and the rocks. It is a 
spot of as complete solitude as can be imagined. Precisely here did we meet 
the mail-coach; between such an object and the solitude in which it was seen 
there did not appear the most remote connexion. Among these mountains are 
many small tracts of bog exactly similar to the bogs of **Ireland**; and here, as in 
them, was growing abundance of the rush called the cotton-plant.




---

p.193


#### 19


Capel-Kerrig is a little cluster of houses, scarcely to be called a village, but 
in a most romantic situation in a complete dell inclosed with rocks, and behind them towering the majestic **Snowdon**. There is, however, an exceedingly 
good inn. If in the former stage I could not by any entreaty prevail on my driver 
to mend his pace; in the present, to **Kernioge**, the more I remonstrated the more 
*sluggishly* did the son of Jehu, — or perhaps under such circumstances I am wrong 
to apply that appellation to him, — the more sluggishly did he proceed; and I 
believe we were nearly as long now going twelve miles, as in the former instance 
seventeen; the driver constantly asserting that in such a hilly country it was 
impossible to go faster. I was determined, however, to make the experiment, 
and therefore positively refused him the accustomed largess, announcing that it 
should be given to the next driver, in addition to what he might otherwise expect, if he acquitted himself more to my satisfaction. By this means it soon became apparent that it was not the steeds but their riders that had occasion for the 
spur; and the proper one being applied, the desired effect, spite of the hilly country, was produced. I was very ready to make allowance for the hills, but I 
had found hill and dale the same. Between **Kernioge** and **Corwen** is a most 
striking spot, **Glyndyffis**. The road ascends for a considerable height by the 
side of a deep dell, being cut, as at **Llyn Ogwen**, in the hard rock, guarded by 
a parapet till it comes to an angle of the rock where four dells may be said to 
meet, some being wooded, some bordered by naked rocks, and down one a fine 
cascade pouring. Indeed there is something at once formidable and sublime 
in looking down from the height to which the road is carried, on the steep precipice below, or rather confluence of precipices; and notwithstanding the ample 
guard to the road, it is scarcely possible to divest oneself wholly of an awful 
feeling that the carriage might be precipitated to the bottom. Seeing this road, 
one can scarcely afterwards conceive any rock or mountain to exist, over which 
by skill and industry a road may not be made.


And on turning the lofty angle of the rock, what a lovely scene is opened to 
the view along the delicious vale of **Corwen**! Again and again in this day's 
journey could I have fancied myself in the county of **Wicklow**, so much similarity is there in the general character of the scenery. The vale of **Corwen**, 
though it has not been its fate to be so much celebrated as that of **Llangollen**, 
is, in my opinion, its superior in beauty. Through it winds the river **Dee**, upon 
 


---

p.194



 
the bank of which stands the town of **Corwen**, the vale being continued to a 
considerable distance beyond the town. The land is fertile in corn and pasture, well interspersed with wood, and every turn presents some fresh assemblage of objects to be admired. Quitting this vale, the eye is immediately attracted by a new object — a remarkable conic hill, with the ruins of **Castle Dinas Bran** 
crowning its summit. This hill rises just above the town of **Llangollen**.


From the solemn funeral pace I had travelled the former part of the day, 
it was so late before I arrived at **Llangollen** that I found it impossible to get 
on to the end of my journey, fifteen miles further, that night; and here, therefore, I was obliged to stop. The name of **Llangollen** can never be mentioned 
without the idea of the two hermitesses of the vale being immediately present 
to the imagination. If curiosity induced a wish in me to visit their retreat, the 
fear of being intrusive withheld me from making the attempt. I was afterwards told that I need not have been so scrupulous, that they are rather 
pleased at finding their domain an object of attraction to strangers, only there are 
some regulations to be observed. One of these gave occasion to a whimsical circumstance; — about the grounds are a number of inscriptions, which no one is 
allowed to copy. A gentleman visiting the place was apprized of this by the 
gardener; which, in the true spirit of Gay's fable of the Old Hen and the Cock, only made him the more desirous of possessing himself of some of them. 
Good manners, however, withheld him from attempting to infringe the rule; 
but quitting the grounds to take his departure, he observed an inscription on 
the outside of the gate, and being now without the territories he thought his 
honour no longer concerned; but that here he might gratify his curiosity: this 
was the rather excited from the inscription being in Welsh, which he did not 
understand. He accordingly wrote it down, and submitted it to the first person he met whom he thought likely to understand the language, requesting an 
explanation. It was in truth the *mountain in labour*; the inscription meaning 
nor more nor less than *Please to shut the gate;* 
given in Welsh, as being more 
intelligible than English to the people of the country, whom it principally 
concerned.


In the inn at **Llangollen** I was again entertained by a harper, though I did 
not think him so good a performer as that I had heard at **Holyhead**. Had I 
then known an anecdote respecting him which I did not hear till afterwards, I 


---

p.195



 
 should certainly have entered into conversation with him, as a character from 
whom some amusement might have been derived. He had been once harper 
to the ladies of **Llangollen**, but some difference arising between him and them 
he was discharged from his employment. In speaking of this affair afterwards 
to a gentleman, he said he intended to be even with them, for he would set up 
two romantic ladies in opposition to them who should quite put them down. 
Early the next morning I proceeded on my route, and arrived at the hospitable mansion of my relations at Gresford, by breakfast. The country hereabouts, if not so fine and romantic as some I had passed through, has yet many 
beauties to offer. The church of Gresford is a fine old Gothic structure, such as 
is rarely to be seen in a country village, Some of the minute carved work having 
fallen to decay, it has been replaced by ornaments of cast iron, executed so 
true to the pattern of the original work, and coloured so well to resemble it, 
that I should never have been struck with the difference 
; though, when pointed 
out to me, I perceived that it was just distinguishable. The church-yard is full 
of yew-trees, very fine and flourishing; one, however, infinitely surpassing all 
the rest, far the largest tree of the kind I ever saw, exceeding considerably in 
the girth of the trunk the old wreck which has been recorded at Glendaloch. 
It must be of a very great age, yet it looked perfectly healthy and vigorous, not 
bearing the least appearance of decay. 
One of the mornings during my stay here was spent, through the politeness 
of some friends of my friends, in going to see Lord Grosvenor's house at Eaton, 
about seven miles off. There is certainly much to admire in it, yet could I 
riot give it unqualified admiration. The Gothic style of building, unmixed and 
uncorrupted, can never be modelled so as wholly to harmonize with the modern ideas of a house; and wherever the attempt therefore is made to introduce 
it, in order to adapt it in any sort to the present taste, incongruities are suffered 
to thrust themselves in, which assort ill with the general character of the architecture. Instead therefore of the true Gothic window, we have here the Gothic 
mullions it is true, but occupied by fine sash panes of glass, which seem wholly 
foreign to them, and are any thing but Gothic. What struck me besides, as in 
bad taste, were the pillars and other ornaments of painted wood in various parts, 
and under various forms, about the house. There is something very petty, 
very inconsistent with Gothic grandeur, in such kind of ornaments; nothing but 


---

p.196



 
stone appears suited to this style of building, or something that would look so 
like stone as to be scarcely distinguishable from it, as for instance the cast iron 
ornaments mentioned just above,- coloured exactly to resemble the stone. Of 
ornaments of this kind I shall soon have occasion again to speak. I thought 
this pettiness particularly striking in the hall, where even more of grandeur is 
expected than in any other part. This hall wants only stone pillars to be very 
magnificent; it is handsomely paved with different British marbles. In the gravel walks about the grounds I picked up several pebbles which had so much the 
appearance of coming from the sea-shore that I inquired whether this was the 
case or not: I was answered that it was not, that the gravel came from a pit 
belonging to Lord Grosvenor seven miles from the sea; no doubt, however, the 
sea was there in former times. They are principally of calcareous breccia, clayslate, and silex. 
After passing four days at Gresford most agreeably, among a very pleasant 
society, I proceeded to London through Shrewsbury and Oxford, highly pleased 
and gratified with my whole excursion.


COMPRISING A SECOND VISIT TO DUBLIN. — A TOUR ROUND OTHER PARTS OF THE COUNTY OF WICKLOW, AND A TOUR TO KILKENNY, CORK, THE LAKES OF KILLARNEY, LIMERICK, CASHEL, ETC. ETC.
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Second Departure for **Ireland**. — **Warwick** and its Castle. — **Liverpool**. — Remarks on the rapid Rise 
of that Town. — Its present Prosperity. — The Athenaeum. — The Lyceum. — The Botanic Garden. — Charitable Institutions. — The New Gothic Church at **Everton**. — The Theatre. — Disappointments in the Packet sailing. — Determination to go to **Holyhead**. — Passage-Boat up the **Mersey**. — The Blind Harper. — Conway Ferry. — Penman-Maur. — **Holyhead**. — Beautiful Setting-Sun. — Sea-Sickness.
#### 20


Far from being satisfied with what I had already seen of **Ireland**, my first visit only inspired in me an eager wish to become still more acquainted with the country and its inhabitants; and as the summer of 1815 approached, my thoughts were again directed towards it. Some doubts, however, unavoidably 
arose whether my wishes could be gratified or not; but the question was at length resolved in the affirmative; and having fixed upon **Liverpool** again as my place 
of embarkation, I did not, as before, take the route of **Bath** and **Bristol**, but went first to **Warwick**. Here I stopped a day and half with a very pleasant 
family to whom I was recommended, during that time seeing the noble castle, probably one of the most magnificent structures of the kind that the kingdom can 
boast; the beautiful seat of Mr. Greathead, at **Guy's Cliff**, about a mile from 


---

p.197


**Warwick**; and making a pilgrimage to the shrine of **Shakespeare** at **Stratford-upon-Avon**. 


From **Warwick** I proceeded by **Birmingham** to **Liverpool**; and now accomplished the idea which had been abandoned the preceding year, — that of stopping 
awhile to see the town. Though I had never been there, excepting the one 
night previous to my embarkation the year before, it so happened that from 
various circumstances I had many acquaintance among the inhabitants, and I 
was most hospitably received by a son of the gentleman at whose house I had 
been entertained during my stay at **Warwick**. I had not purposed staying more 
than two days; but not finding a packet in equal readiness as the year before, 
my stay was extended to double that time. On inquiring about packets upon 
my arrival, I was informed that the Duke of Richmond was expected in from 
**Dublin** that day, and would sail again the day after her arrival. 
Of all the subjects of research which may occupy the human mind, none can 
be so curious, none can involve such deep interest, as to trace the rise and the 
downfall of states and of towns. To follow them from the original nothing, 
whence they spring up, through the gradual progression by which they rise to 
consequence, to wealth, to grandeur, till arrived at the highest apex allotted 
them in the great Book of Fate, they gradually, since nothing in this world can 
be stationary, decline and fade away, till at length they sink again to their original nothing. To those who see **Liverpool** such as it now is, it is not a little curious to reflect that not till the year 1699 was it a parish of itself, it was 
but a Hamlet, with a Chapel of Ease, to the parish of **Walton**. The population 
of the town was at that time computed at about five thousand souls. In 1710, 
the number of vessels belonging to it was estimated at not more than eighty-four, averaging only about seventy tons burthen each; the trade, however, was 
then in so increasing a state, that it was thought necessary to construct a dock, 
and this was the first constructed.


At present **Liverpool** contains sixteen churches, with twenty-four other places 
of worship, including those for Protestant sectaries of various persuasions, for 
Catholics and for Jews; the population of the town is estimated at a hundred 
thousand, and her quantity of shipping is computed at a twelfth part of the whole 
employed by **Great Britain**. What an extraordinary change in the space of 
very little more than a century! 


---

p.199



 
Would that in admiring this astonishing advance in wealth and prosperity, 
there were no alloy to throw a cloud over the contemplation! — but it must ever 
remain a painful reflection, that so much of this prosperity was acquired by that 
dreadful reproach to humanity the African slave-trade. Eternal praise and 
honour to the exertions of those unwearied philanthropists whose zeal was not 
to be shaken by opposition, who were not to be deterred by ill success on one 
occasion from recurring again and again to the charge, till importunity at length 
obtained what had been denied by justice; — eternal honour to these men! **Liverpool** is now no longer sullied with such a stain; in common with the rest of 
the nation, she is freed from it; while in being thus freed she has learnt that 
even greater wealth and prosperity may be derived from sources untainted with 
the blood and groans of her fellow-creatures. Let us hope that such of her 
merchants as had their hands thus soiled, now awakened to a sense of their guilt, 
look back upon the disgraceful period with shame and remorse, and join to bless 
those by whom their career was arrested, ere remorse was too late. Nor must 
it be supposed that there ever was a moment when all **Liverpool** was to be 
charged as sharing in this guilt; — if many, far, far too many were involved in it, 
yet many also, I believe I may say a majority of the inhabitants, even when the 
impious traffic was carried to its highest extent, not only preserved themselves 
free from contamination, but regarding it with the utmost detestation united 
strenuously in the efforts to accomplish its suppression. High on this list stand 
the revered names of **Roscoe** and of **Rathbone**.


The first coup-d'oeil of the town speaks it at once a place of modern growth, 
nothing like a vestige of antiquity meets the eye. The records of the town 
mention an ancient castle, but of that not a trace remains; on the site of it 
stands the principal church of the town, St. George's. Whole streets, consisting 
of entirely new houses, simple and neat, built without any attempt at grandeur 
or display of architecture, speak a great equality of condition among the inhabitants; nor do we any where see, as is the case in so many towns, one 
particular quarter which seems set apart as the receptacle of poverty, filth, 
and misery. The greatest objection I had to make to the town was, that the 
houses are mostly of red-brick, a material for building of which I have 
already in the course of this work expressed my extreme dislike. Some of 
the public buildings are very handsome, for instance the Town-Hall and Exchange. 


---

p.200



 
The Docks it is needless to mention; every one knows that they 
are some of the finest to be seen not only in **Great Britain**, but in any part of 
the world.


With the increased wealth of the town great taste for literature has arisen; 
there are two excellent literary societies, the Athenaeum, and the Lyceum. At 
the former a news-room below is well supplied with London and country newspapers, reviews, magazines, and other periodical publications. Above is a handsome library containing above eight thousand volumes, some of them rare and 
valuable books. To this there are five hundred subscribers paying an annual 
subscription of two guineas and a half each, which furnishes an ample fund for 
the support of the institution. Books cannot be taken out of the library; but 
the rooms are open the whole day to the subscribers, and any subscriber may 
introduce a friend not a resident in the town. The Lyceum is a much handsomer building in the exterior than the Athenaeum; and it ought to be, since it 
was built at the expense of eleven thousand pounds, whereas the Athenaeum 
cost only four thousand. It consists of a coffee-room furnished with English 
and foreign newspapers, magazines, reviews, &c., and a library containing about ten thousand volumes, which are circulated among the subscribers. Besides 
these there are several other news-rooms.


An Academical Institution for the promotion of Literature, and the Arts and 
Sciences, with professorships attached to it, has long been projected, and a large 
subscription raised for the purpose, which gives promise of its being carried 
into effect. But the Botanic Garden is one of the objects which of all others 
in **Liverpool** best deserves to be honourably mentioned. It stands about a 
quarter of a mile out of the town upon an eminence called **Edge-Hill**, and is 
really one of the most complete things of the kind I have seen; not by any 
means so extensive as that belonging to the **Dublin Society**, but excelling it in the 
construction of the conservatories, and in the collection of exotics by which they 
are occupied. Some of these were growing in such luxuriance, that the roof 
of the building was no longer of sufficient height for them. Among them are 
many very fine plants from the Cape of Good-Hope; and I had familiarized 
myself so much with the productions of that country, from translating **Dr. Lichtenstein**'s Travels in Southern Africa, that I seemed as if among old acquaintance. Nor must the gardener Mr. Shepherd be passed over without a word of 


---

p.201



 
tribute; he is one of the most intelligent men that I ever met with in such a 
situation.


No place can abound more with charitable institutions, as the following list 
will evince. There is a General Infirmary; — An Hospital for Seamen; — A Dispensary for supplying the Sick Poor with Advice and Medicines at their own Houses; — An Asylum for the Blind; — A Blue-coat Hospital, or Freeschool for the Education of Boys and Girls; — A House of Industry; — A House of Recovery, or Fever Hospital; — An Institution for the Recovery of Drowned Persons; — A Lying-in Charity for Women, conducted by the Ladies of the Town; — A Welsh Charity-school; — A Catholic Charity-school; — A School of Industry for the Education of Girls; — A Magdalen Asylum; — A Society 
for the Relief of Debtors confined in the Borough Gaol; — A Society for bettering the Condition of the Poor; — A Bible Society; — several Alms-houses. — Lastly, though not least in merits, a Society called The Stranger's Friend Society. — It is an institution, as the name imports, for relieving objects in distress, 
strangers in the town, who cannot apply for parish relief: there can hardly be 
greater objects of charity and benevolence than people in such a situation. 
**Everton** is a small village just without the town, standing on a terrace above 
the **Mersey**, and having a number of villas belonging to citizens. Hither I 
was carried to see, as one of the lions of the place, a new church, not then 
quite finished, built in the Gothic style, the pillars and all the ornamental work 
being of cast-iron painted stone-colour. They are admirably executed, and 
have so much the appearance of carved stone, that they might very well pass 
for such if not known to be otherwise: what a facility is here opened for 
introducing all the grand effect of the Gothic architecture with a tithe of the 
labour!


The Theatre, with the dresses, decorations, and every thing belonging to 
it, is the handsomest I have seen in any country town; a very large audience may here be accommodated. Through the politeness of Mr. Knight, the 
proprietor, I had the advantage of a seat in his box every evening while I 
staid at **Liverpool**. **Miss O'Neill** was then playing there.


I had every day sent my inquiries down to the harbour for the expected 
Duke of Richmond packet; but everyday, and all day long, received the same 
answer, that she was expected that day, till I began to be rather weary of expectation. At length she did arrive, but I had then been four days in waiting; and my servant told me he was informed at the port, that, whatever 
might be said at the packet-office, he might be very sure they would not 
sail again for three or four days. Moreover, the wind being totally adverse for 
getting out of the river, if I got on board, I might be kept beating about, 
perhaps, for a day or two before the vessel could clear the harbour. Now, 
though I was passing my time very pleasantly among several old friends, and 
several more new ones, it was not reasonable to encroach too far upon them; 
still less did I like the idea of beating about perhaps for two or three days 
without making any progress. I therefore, as if fate had determined that I 
was never to embark from the first port to which my steps were directed, now 
determined on leaving his Grace the Duke of Richmond to pursue his course 
without me, and to go off to **Holyhead**; secure that from thence there would 
be no delay in embarking.


I accordingly set off at two o'clock on Saturday the 29th of July, by a passage-boat, which carries passengers about eight miles up the river, to a place 
where a coach is in waiting to go on to **Chester**, whence another coach goes to 
**Holyhead**. Unfortunately a heavy rain came on just as I got into the boat, 
which never ceased a moment for about twelve hours. Shut up, therefore, in 
a crowded cabin, nothing could be seen of the banks of the river, which I am 
informed are worth seeing. The désagrément of this confinement was however somewhat relieved by a blind harper, who regularly takes his station in 
the boat to entertain the passengers with his music, and endeavours to make it 
charm some little gratuity from their pockets into his own. I found that it 
had the desired effect; there were few who did not give him at least two or 
three halfpence. 


What I disliked in this journey was, that so much of it was performed in the 
dark. It was nearly dusk when we set off from **Chester**, and day-light had 
just come on again when we arrived at Conway-ferry; I could therefore see, 
though I could not examine, the magnificent ruins of Conway-castle; and a 
very bright morning having succeeded to the wet night, they were beautifully 
illumined by the glowing tints which the rosy goddess Aurora threw over them. 
There was something altogether fine and striking in the scene. Early as it was, 
no creature was visible but ourselves and the Charons who were to row us 


---

p.203



 
over, while the water was still and smooth as glass; and since at such an hour 
scarcely is any one ever inclined to conversation, no sound, except the dashing 
of the oars, interrupted the solemn stillness which reigned around. An old 
gentleman only, an officer as I afterwards found, remarked when we arrived on 
the other side of the water, that since the melancholy catastrophe which had 
happened there two or three years before, of the ferry boat being overset and 
so many passengers lost, he could never feel easy till he found himself safe on 
shore again. Indeed, still as the water now was, it is not difficult to conceive 
that it may be rendered very dangerous by a strong wind blowing up the river 
between the rocks that form its entrance. **Penman-maur**, as is often the case 
with objects of which one hears too much, disappointed me. It is grand; but 
I had formed to myself an idea of vast crags hanging over the road, while the 
sea was dashing at a tremendous depth below. But instead of hanging over 
the road, I found the rocks sloping away from it, and its height above the sea 
scarcely more than half what I expected.


It was about twelve o'clock when we arrived at **Holyhead**; and the 
mail coming in half an hour after, preparations for embarking were to be 
made; at two we sailed. The wind, which had been invariably to the 
west for some time, this morning took a sudden turn round to the east, 
presenting a very favourable prospect for our voyage. The day was clear and 
beautiful, the wind just sufficient to carry us over pleasantly, without being 
boisterous, and by eleven at night we anchored in **Dublin Bay**, there to wait till 
morning, when the tide would serve for crossing the bar into the harbour. As 
evening was coming on, most of the passengers went down into the cabin; 
I alone remained upon deck; and here I enjoyed one of the most glorious 
spectacles imaginable. The **Mourne mountains** were then in sight. Above 
them rose a mass of dark cloud, the sun had just set behind them, and illuminated with the brightest golden tints the part of the heavens where it descended, throwing out the dark heads of the mountains with the finest contrast; and 
this glowing landscape was surmounted by the mass of dark cloud, forming as 
it were an arch through which it was seen; nothing could be imagined more 
beautiful; — even the bright sun of Provence could not have produced a happier effect.


As I stood admiring this, the Captain, whom I found a very pleasant, 


---

p.204



 
sensible man, entered into conversation with me, observing that I was a very 
good sailor, that I did not appear at all disposed to be sick. I replied that 
I never found myself so in fine weather when I could be upon deck, but that I 
had suffered very much in rough weather. "However," I said, "I never think 
about it, but always try to amuse myself, and I believe there is something in that." — "I believe," he replied, "you are perfectly in the right; I observed you 
reading, or walking and looking about, not appearing to think of sickness, and 
I said within myself, That lady will not be ill. I have," he continued, "been 
now nine years in this service, constantly going backwards and forwards between **Dublin** and **Holyhead**, and you may imagine that in that time I have 
had the opportunity of seeing and making my observations upon a great variety 
of passengers. Upon an average, I should think not more than one out of five 
escape entirely without sickness, but I believe of the four that are sick not more 
than one need be so. I think three-fourths at least of those that are, work 
themselves up to it from the belief that it must be so. The ladies in particular," he said, "if I may say it without offence, seem to have an idea that 
it would be a want of delicacy if they were not, and even become sick with 
apprehension lest such a want of delicacy should be evinced." I listened with 
attention; — my opportunities of observation had been as nothing in comparison with the Captain's, yet had the same idea more than once struck me. In 
very many instances the effect is beyond all doubt wholly unavoidable; 
as for instance, I met with a common sailor once, who said he had been 
forty years in the service, but whenever he had been on shore for any length of 
time, on going to sea again he was always ill for the first two or three days. 
In this man there could be nothing like affectation. In many instances, however, I have thought the sickness brought on in the way suggested by the Captain. One way of promoting it is, the invariable habit people have of making 
it the great theme of conversation the moment they go on board a vessel. But 
enough on this subject.


The night was passed at anchor in the bay; about five in the morning the 
anchor was weighed, and about six we disembarked at the Pigeon-house.




---

p.205


New Acquaintance. — **Sir William Betham** and his Family. — The late **Joseph Cooper Walker, Esq.** — **Mr. Walker** his Brother. — Excursion to **Howth** to see the Diving-Bell. — **Montpellier**. — Remarkable Anecdote respecting Captain Usher. — Pedigree of the Tyrconnel Family. — Regalia of the Herald at Arms. — **Mr. Kean** and his Second Benefit. — Visit to **Saint Valeri**, the Seat of **Mr. Walker**. — **Loch-Hela**, or **Luggelaw**. — Derivation of the Name. — Lead Mines at **Shankill**. — Village of **Enniskerry**.
#### 21


Once more then I am in **Ireland**, I said within myself as I came on shore, 
and what a multitude of pleasing recollections immediately pressed upon my 
mind! They seemed an assurance that in revisiting the country, far from 
being diminished, a large accession would be added to them; nor were my prophetic visions erroneous. Such indeed was the charm I found in renewing my 
acquaintance with my old friends, and in the acquisition of many new ones, 
that although I came with the fixed intention of not spending more than a 
week at **Dublin**, I stayed three weeks, and only wished at the expiration of 
that time that I could have indulged myself in a much longer stay.


Among my new acquaintance must be particularly mentioned the family of 
**Mr. Walker** at **Saint Valeri** near **Bray**, and that of **Sir William Betham** at 
**Montpellier** near **Dublin**. Though I had occasion in the former part of my 
work to mention the latter gentleman, it was rather by anticipation, for it was 
not till this year that I had the pleasure of knowing him. With his sister **Miss 
Matilda Betham**, the well-known authoress of a biographical work celebrating 
such of her own sex as have at any period of the world particularly distinguished themselves, of some poetical works, and lastly of a very beautiful poem 
entitled the Lay of Marie, — with this lady I had the pleasure of being acquainted, and she obligingly gave me a letter of introduction to her brother and his family, for which I have to acknowledge great obligations to her.


With that elegant scholar, that man of refined and classical taste, the late 


---

p.206


**Joseph Cooper Walker, Esq.** I had been, from some accidental circumstances of a 
literary nature, in the habit of occasional correspondence during the latter years 
of his life. He had repeatedly in his letters expressed the most flattering wish 
that I would come over to **Ireland** and make **Saint Valeri** my residence awhile, 
assuring me that he would introduce me to beauties of nature which were hardly 
any where to be exceeded, and to society in which he doubted not I should 
find my time pass very pleasantly. At that time, how much soever I might wish 
to accept so flattering an invitation, I scarcely thought that it would ever be 
my lot to visit **Ireland**; I could only express my thanks and wishes, without 
being able to add hopes to them; and amid the pleasure I have received during 
my two abodes in this country, one regret has always been mingled, that it was 
too late to become personally acquainted with one whose letters could not but 
give the most pleasing impression of his mind and heart.


This tribute paid to the dead, my warm acknowledgements are now due to 
the living. While I was at **Ravenswell**, the year before, I had more than once 
passed by **Saint Valeri**, which is scarcely so much as two miles from **Bray**, looking towards it with an eye of regret, in the thought that while all its natural beauties were the same, still flourishing, the objects of delight to all 
around, the hand which had contributed so essentially towards forming them 
was cold in the tomb. I inquired who had succeeded to the property, and 
was informed that it was left by the deceased to a sister who had always lived 
with him. I was impressed with a strong wish to make myself known to her; 
but apprehensive of appearing intrusive, I restrained my wishes. When I 
returned from my excursion round the county of **Wicklow** the year before, I 
learnt that **Mr. Samuel Walker**, the brother of the deceased, had been inquiring for me, and I then began earnestly to wish I had been less scrupulous, 
and had made myself known to the family. But it was now too late, I was 
on the verge of my departure, and for that time the thought of answering his 
civilities must of necessity be abandoned. I had now, however, not been more 
than two days in **Dublin** before I was favoured with a call from him, he having 
heard that I was in the country from **Sir William Betham**, who is his brother-in-law, **Lady Betham** and **Mrs. Walker** being sisters — and he obligingly engaged me not to quit the country without visiting **Saint Valeri**. I had however 


---

p.207



 
to regret, amid the pleasure I found from these new acquaintance, the absence of some old ones; Mr. and **Mrs. Weld** and Mr. and **Mrs. Cuthbert** were in the north of **Ireland** with a sister of **Mr. Weld**'s, who is settled there.


Having seen and descanted upon the principal objects that invite the attention of strangers in **Dublin** in the first part of this Narrative, I have little to 
add. I went over one day to **Howth**, in hopes of seeing the diving machine 
at work, which I was informed was used in making the new pier, and that it 
might be seen any day, only observing not to be there before the half ebb tide, 
since it cannot work at high water, or till the tide is about half down. But I 
was very unfortunate in the day I pitched upon; the machinery was to be removed to another part, and the bell was not to go down that day, so that I only 
saw the nature of the process, I did not actually see the men submerged. The 
machine is of cast iron, not in the form of a bell, but of a vast chest or coffer 
having no bottom. In the top are four bulls-eyes to give light, which are in no 
danger of being broken from any pressure of water; and the air pipe is so managed that nothing is to be apprehended from the want of a sufficiency of air, 
or a proper renovation of it; there are seats at each end within the chest. This 
is suspended at a sufficient height above the water, just to admit of a small boat 
going underneath; the men who are to go down are rowed under, when 
they place themselves upon the seats, the boat comes away, and the machine is 
let down by vast ropes over a cylinder turned by winches upon the same principle as a bucket to a well. When they want the machine to be drawn up, they 
strike upon the iron sides, which sends forth a body of sound that cannot fail of 
being heard above. I talked with some of the men who are in the habit of going down, and it was become so familiar to them, the machinery was besides of 
such an improved kind, that they talked of it with perfect unconcern, as of a thing 
not attended with the slightest risk. The object for which it is used is in laying 
the foundation stones for the head of the new pier. The block of stone is first 
lowered into the water, when the men descend and fix it in the proper situation. 
They do not stay below longer than twenty minutes together; the machine is 
sometimes fifteen feet under water. It is a curious idea to think of men working in such a situation; and yet the whole apparatus carried with it such an appearance of security, that I thought I could have gone down myself without apprehension. Indeed it appears much less hazardous than ascending in a balloon.




---

p.208


#### 21


Since the first part of my Narrative was printed off, I learn that the idea of 
this harbour at **Howth** ever being brought to answer the destined purpose is so 
much abandoned, that the making a harbour on the southern shore of the bay is 
determined on; not, however, at **Dalkey Island** which had been so much talked 
of and recommended, but at **Dunleary**. This is nearer to **Dublin** by two miles 
than **Dalkey** would be; there is already a little fishing harbour, which is to be 
enlarged by an additional mole, and at all states of the tide there will be a sufficient depth of water for the packets to come in. Passengers coming by the 
packets very often choose to be rowed up to **Dunleary** and there to land, rather 
than wait for the vessel going into the harbour, while jaunting-cars and jingles 
are in attendance to carry them into the city. 


In the course of my stay at **Dublin** I spent a very pleasant day and night at 
**Sir William Betham**'s house at **Montpellier**, a little beyond **Black-Rock**, in a 
delightful situation having a fine view all over **Dublin Bay**; indeed a particularly advantageous one, since the house stands just so far removed from the 
shore as to lose the tracts of sand which deform the bay when the tide is 
down, and nothing remains to the view but the fine sweep over the water with 
the **Hill of Howth** on the other side. In taking a drive about the neighbourhood before dinner, we passed a house to which **Sir William** directed my attention, as that of Mrs. Usher, the mother of Captain Usher, whose name had 
then recently come so much into public notice from his commanding the vessel 
in which the ex-emperor of the French and his suite were carried to the Island 
of **Elba**. I had been very much acquainted with a young man who was once a 
lieutenant under Captain Usher on board the Undaunted, but obliged to quit 
the service on account of ill health. In talking one day of the French emperor, 
while he was in his prosperity, long before any idea could be entertained of all 
that has happened, this young man said he wished they could take him prisoner on board the Undaunted, they'd teach him another lesson, they'd take 
down his pride, they'd show him the difference between him and an English 
seaman. "No," said a lady in company, "you would not; your captain would 
behave to him as a gentleman ought to behave, he would treat him with all the 
politeness and deference due to his talents and situation; and for the crew, they 
would all contend which should pay him the most respect and attention." 
How singular that Captain Usher should be the very person placed in this situation! 


---

p.209



 
But how well did this lady read the mind of man, and understand the 
involuntary respect which extraordinary talents will always command, even 
among those who are the most desirous to hold the object in aversion; and 
how truly did Captain Usher's conduct justify the opinion she entertained of an 
English naval officer, incapable under any circumstances of deviating from the 
character of a man and a gentleman!


I have mentioned, in speaking of **Shanes-Castle**, the pedigree of the O'Neale 
family which had been made out by **Sir William Betham**, in quality of his function of Herald at Arms, and under his direction so finely written and illuminated. He showed me another of the same kind just finished, of the united families of O'Donnel and Tyrconnel in which was a painting of the celebrated 
relic belonging to the O'Donnel family, mentioned by **Lady Morgan** in her 
excellent novel of O'Donnel, the **Cathach** as it is called, or Casket, in which is 
supposed to be deposited the ancient legend of Saint Columba, or Columbkill. 
Indeed the writing, the illuminations, the binding of the work and every thing 
belonging to it, present admirable specimens of Irish talents and industry. I 
passed a most interesting morning at **Sir William Betham**'s office, by his indulgence, looking over curious old records, books of heraldry and various other objects of curiosity; among which **Sir William**'s own regalia must not be forgotten. 
Those worn as Herald at Arms are very ancient, on the head is a sort of crown 
or diadem; — as attached to the modern knights of Saint Patrick, he has a very 
handsome belt or girdle of modern workmanship. Nor must a sword and part 
of a shield which I saw there be forgotten, which are supposed to have belonged 
to one of the knights of Saint John of Jerusalem when they were in possession of 
the lands of **Kilmainham**. About four or five years ago in digging upon these 
lands, near the river **Liffey**, to make the new military road, a skeleton was found 
with this sword and shield lying by it; and from the handle of the sword being 
cruciform and inlaid with gold, it is obvious that it must have belonged to some 
person of distinction.


I found Mr. and Mrs. Kean again at **Dublin**; **Mr. Kean** enchanting the 
public not less than the former year. Many pleasant hours did I pass in his 
house, in the society of such men of talents as his own talents can never fail to 
draw around him. He had been performing for a fortnight before I arrived, 
and staid about a fortnight after. All people seemed anxious that the reproach 


---

p.210



 
cast upon the city the former year by the failure of his benefit should 
be atoned on the present occasion; and the house was indeed as full as possible. The young men of the College in particular were so eager upon the 
subject, that some of them, in conjunction with two or three other gentlemen, 
took upon themselves the whole management of it: — they let the boxes, they 
distributed the tickets, and on the night stood at the doors themselves to take 
them, that they might assure themselves no fraud or collusion was practised. 
A higher compliment could scarcely have been paid to a person in **Mr. Kean**'s 
situation. I was one of five upon a seat usually appropriated only to four, and 
the whole house was filled in the same way.


On leaving **Dublin**, my course was first directed to **Saint Valeri**, in acceptance of the kind hospitalities to which I had been invited by **Mr. Walker**. I 
was here introduced to **Mrs. Walker**, and to their amiable but suffering sister, 
**Miss Walker**. This lady had been the constant companion and nurse of her 
brother during a long and lingering illness; and perhaps the invalid state into 
which she has fallen almost ever since, is to be traced up to the fatigue of body 
and mind inseparable from so painful an attendance. Though she is the proper owner of **Saint Valeri**, such is her kindness towards the present **Mr. Walker** 
and his family, that the house and place are as much theirs as if they were the 
actual possessors. It is indeed a sweet spot, but it stands in a country where 
every spot is sweet. To a house small when he came to it, the late **Mr. Walker** 
added a very handsome room for a library, which is extremely well filled: it 
is scarcely necessary to say that a collection of rare and choice Italian books 
forms an essential part of it; of such a collection the author of the Historical Memoir on Italian Tragedy, and the Essay on the Revival of the Drama in Italy, must have been possessed.


The situation of the house is extremely good, on a considerable slope, having 
the smallest of the sugar-loaf mountains directly in view of the windows: it 
was at this time most beautifully tinted with a variety of colours from the heath-plants growing about it; the prevailing were a bright purple and a glowing yellow. The **Dargle** is not more than a quarter of a mile from hence; the 
entrance to **Mr. Grattan**'s side of the dell, not the most frequented one, is seen 
from the windows of **Saint Valeri**. Thus near the **Dargle**, I had an opportunity of 
exploring this delightful spot much more completely than before; but I 


---

p.211



 
found nothing particular to add to what has been said of it already. The 
grounds at **Saint Valeri** are not very extensive, but there is a delightful walk 
through a plantation round the base of the slope on which the house stands, 
having the stream which comes from the **Dargle**, and thence pursues its course 
to **Bray**, running at the foot. Very good potter's clay is dug in this slope.


In a plantation at the back of the house, running along the side of the road, 
is an ancient stone cross, of the same kind as that mentioned at **Glendaloch**, 
and of which there are several more remaining in different parts of the country. 
The cross at **Saint Valeri** was brought from a glen at some distance, and stood 
originally in the centre of the little paddock, round which runs the plantation. 
But it became so much an object of devotion among the neighbourhood, that 
paths without number were made over the grass to get at it; and **Mr. Walker** 
found it expedient to remove it into a situation where the devotions might be 
paid without trespassing on his grounds: it stands now so close to the road, 
though just within the fence of the plantation, that any one may kneel down 
and say a prayer en-passant, without turning a step out of the way. In another part of the grounds is a holy well, close by which stands a bush stuck 
all over with little morsels of rag, votive offerings to the saint who presides 
over the spot, though I really do not know who the saint is. I believe the 
water cures all ailments. **Mr. Walker** has made a gate close by the well to 
give free access to it; a sort of little parterre is planted with shrubs and flowers, 
having stone seats ranged about it; and he has chained a drinking-cup by the 
side of the well, to furnish the means of drinking to any one who wishes it. 
Some of the neighbourhood are rather scandalized at his giving so much encouragement to the Romans, (for so the Catholics are universally called) he being himself a Protestant of the Church of England: but I truly believe, that humouring to a certain extent the prejudices in which they have been educated, 
and showing such lenity towards them, is by far the most likely way to lead 
this class of people in the end to renounce their errors. Conciliate their regard 
by kindness, and a vast step is made towards leading them to adopt your opinions. Violence has made many a hypocrite; it never made a sincere convert; kindness has made many a one.


The Romans is so much the appellation by which the Catholics are called in 
Ireland, that some people seem scarcely to have an idea but that it is exclusively 


---

p.212



 
theirs. Once in a large dinner company, when subjects of cookery, as 
happens not unfrequently, occupied a considerable share in the conversation, 
one of the company observed, that the Romans seemed to have made the science of cookery their study very much, that they appeared to have been very 
great eaters. "Well," said a lady in company very eagerly, "so my husband 
says. He dined among a whole heap of 'em the other day, and he says you 
may talk of their fasting as much as you please, but he never saw people eat 
such dinners in his life."


The first morning of my stay at **St. Valeri** was spent in a visit to **Loch Hela**, 
better known by the name of **Luggelaw**, which sprang originally from a corrupt 
pronunciation of the true name. That of **Loch Hela**, the Lake of Hela, is now 
so little known, that it is very commonly called the Lake of **Luggelaw**. I have 
seen it called so under an engraving of the spot; nay, I have seen it spelt **Lugula**. It is about nine or ten miles from **St. Valeri**. After passing the finely 
wooded and cultivated country about **Powerscourt**, the road ascends to a great 
height among the ocean of mountains which occupies so large a part of the 
county of **Wicklow**; and the rest of the way lies entirely among these mountains. It was soon after arriving at this elevation that I saw the head of the 
great waterfall at **Powerscourt**, as mentioned in the former part of my Narrative. After going up and down among these mountains for about five miles, 
coasting round the base of the great sugar-loaf, at length in descending a pretty 
steep declivity at a sharp angle, appears far beneath what looks like a sheet of 
very black mud. This is the lake; but a small part of the expanse is, however, 
then seen, and none of the cultivated scenery around it; nothing but dark 
and naked rocks, which throw such a shade over the water as to deprive it in 
great measure of its aqueous appearance, and give it the semblance of mere 
slime.


In proceeding onwards down the descent, which winds round a high rock, a 
different scene presents itself. These wilds are the receptacle of a vast quantity of game, particularly grouse; and in this recess among the mountains, 
upon the borders of this lake, has **Mr. Peter Latouche**, the proprietor of **Belle-Vue**, and the **Glen of the Downs**, made a very pretty shooting-box. The 
rocks on the side of the lake down which lies the road are granite, sloping 
away considerably from the water. These are now entirely planted; the trees 


---

p.213



 
are in a very thriving state; and a road lies through the plantations to the 
house, which is at the other end of the valley. The lake terminates some way 
before the valley closes: in this part stands the house; and the whole space is 
occupied with meadow-grounds and plantations. The valley closes with a vast 
amphitheatre of rocks, down which pours a water-fall, but not a very ample 
one, forming at the foot a little stream, which winding through the meadows 
runs into the lake. The opposite side of the valley to that on which runs 
the road is bounded by slate-rocks, which rise very abruptly above the lake. 
Such is the beautiful spot which art improving on natural advantages has 
formed in the midst of this wild country. I can conceive no greater surprise 
than any one would experience on being led to it, not having the least idea of 
what he was to expect. Though the water, on descending further into the 
valley, loses much of the black slimy appearance which is at first so striking, 
yet from the local circumstances it always retains a very dark hue. Such is the 
rocky chasm which it occupies, that the water in the centre of the lake is unfathomable. This circumstance, combined with its inclosed situation, and the 
dark slate-rocks rising on one side directly above it, sufficiently accounts for its 
Acherontic tint: when taken out of the lake it looks clear and fine. There is 
a boat, if any one chooses to row upon the water; but the navigation is bad, 
and the lake exposed to sudden squalls of wind through the entrance, which 
are dangerous when they occur, so that not many people venture upon it: indeed it is so small, that the whole surrounding scenery is just as effectually 
seen from the shore. At the foot of the lake is a little extent of beach, of a 
sort of sand or gravel composed of the debris of granite rocks, with some 
pebbles of mica slate intermixed. Abundance of beautiful mosses were growing about.


But it must be remembered, that the borders of this lake were not always 
cultivated; that the whole valley was once naked, dreary, barren: — what then so natural, in the ancient times of superstition, as that this black, dark lake, 
surrounded with dark and barren rocks, should be fixed on as the abode of 
darkness, of DEATH — for such was the Hela of the ancient Danish mythology. 
The lake of Hela, or of Death, was an appropriate title to such a spot, given 
probably by the Danes while they inhabited the island, and handed down from 
them; though this derivation is lost in the corrupted name now so generally 


---

p.214



 
used. I could almost doubt whether the spot is improved in lessening its wild 
horrors, by mingling the grand features, which must be ever unchangeable, 
with the milder beauties bestowed by the hand of cultivation.


The next day I went to visit the lead-mines of **Shankill**, not far from the 
Scalp. These mines lie on the County of **Dublin** side of this chain of mountains; and to reach them from **St. Valeri**, I went by a road directly over the 
summit of the mountain: a plain proof that there was no occasion for the 
Danes to have hollowed out that immense chasm, the Scalp, to establish a 
communication between the counties of **Dublin** and **Wicklow**. The ascent 
is carried in such an oblique direction along the slope of the mountain to the 
summit, that though long it is by no means steep. These mines were formerly 
abundantly productive, and might be so still, but from the little excitement to 
industry held out. The rocks are granite, abounding exceedingly with galena, 
or sulphuret of lead. I also obtained some beautiful specimens of crystallizations of carbonate of lead; others containing sulphate of barytes, others 
with phosphate of lead, and others again with haematite or oxyd of iron. The 
granite every where abounds with mica; in some places is particularly rich in 
it: in one specimen I got, the mica appears (if I may be allowed to use such an 
unmineralogical expression) almost plated over the stone. The granite of the 
Scalp, which is scarcely half a mile from the mines, equally abounds with mica; 
it sometimes assumes the character of a coarse-grained gneiss.


The road from **St. Valeri** to the mines skirts the domains of **Powerscourt**, and 
then passes through the village of **Enniskerry**, which stands very picturesquely 
upon the slope of a steep hill. It is seen to most advantage coming down the 
hill on the other side from the Scalp; the view of it is then remarkably pretty. 
It is one of the neatest villages to be seen in **Ireland**. Above the road, coming 
down from the Scalp side, are lofty sand-banks, things not often to be seen in 
this country. The remainder of my stay at **St. Valeri**, which was extended to 
five days, was spent in driving or walking about, and exploring different parts 
of the neighbourhood: every where it abounds with pleasant walks and drives.




---

p.215


Route to **Cork**. — **Tallagh**. — **Blessington**. — **Poll-a-Phuca**, a Fall of the **Liffey**. — **Ballymore Eustace**. — Ruins of **New-Abbey**. — **Kilcullen Bridge**. — Old **Kilcullen**. — Quaker Village at **Ballytore**. — **Castle-Dermot**, the Ruins there. — **Carlow** and its Ruins. — **Leighlin-Bridge**. — Old **Leighlin**. — **Kilkenny**. — Lord Ormond's Agent, **Mr. Barwis**. — Dr. Ryan. — The Castle at **Kilkenny**. — The Marble Quarries. — Ancient Remains. — The Cathedral. — The Black Abbey. — The College. — **Kilkenny** Theatricals. — **Clonmel**. — **Fermoy**. — **Glanmire**. — Arrival at **Cork**.
#### 22


The first place of my destination on quitting **St. Valeri** was **Kilkenny**. For 
want of a road over that part of the mountains which lies in the way, I was 
obliged to return within three miles of **Dublin**, coasting round the foot of the 
hilly region, till at length I gained the high road at **Tallagh**, five miles from the 
Capital. Here was once a summer residence of the Archbishop of **Dublin**; but 
it has long been deserted, and the house looks old and ruinous. The country 
about is flat and dull. **Blessington**, nine miles further, is a very neat pretty little 
town, belonging almost entirely to the **Marquis of **Downshire****, who has a fine seat 
in the neighbourhood. There is a handsome new church built by the Marquis. 
Here I turned out of the road to see a natural curiosity, the fall of the **Liffey** at 
**Poll-a-Phuca**, as it is called, or The Daemon's Hole. In going thither we pass 
**Russborough**, the seat of the Earl of Miltown, a modern-built house with a 
very handsome front seven hundred feet in length. The house contains a good 
collection of pictures, but I did not stop to see them. **Ireland** abounds every 
where with noblemen's and gentlemen's seats; but these did not excite my curiosity like the natural beauties and wonders of the country. There must inevitably be a kind of sameness in these seats, and when one has seen a few, little 
is to be attained by seeing many more: but in the works of Nature there is an 
unceasing variety which never can pall; they are always presenting something 
new, something to charm, to fill the mind. If copies of the works of Nature 


---

p.216



 
are fine, and fine paintings are undoubtedly very fine things, how much finer 
must be the models from which the copies are made!


I did not therefore stop to see Lord Miltown's seat at **Russborough**; but 
went on to **Poll-a-Phuca**, about two miles beyond it. Approaching the spot 
is a curious ruin of a church, with a small part of a round-tower, and a 
stone cross. I have not found this round-tower mentioned in any enumeration of those now standing, either in whole or in part. While I was in **Dublin** 
I had many times talked of going to see **Poll-a-Phuca**. "Oh dear," says one, "'tis never worth while to give yourself any trouble about that — just a 
bucket of water pouring over a rock; — so I'm told at least, for I never saw it." 
 — "You are quite in the right," says another, "'tis a noble fall, as I hear, and 
well answers going a little out of the way to see it." — "Well, you are indefatigable in hunting after sights," says a third; "but I should have thought that 
by this time you must have seen waterfalls enough, without giving yourself any 
more trouble about them." — But I was determined, though I had seen so many waterfalls, to see one more; and I earnestly recommend to every body who has a taste for the striking features of nature to judge of this for themselves: — the fall at **Powerscourt**, which every body goes to see, is certainly very fine, and they are right to go and see it; but this which scarcely any body seemed to know more than by name is much finer. The annexed Plate gives a very good idea of it: 
the fall is broken by a shelving of the rock, so that there are two distinct rushes 
of water, not together amounting to the height of **Powerscourt**, but exceeding 
it very far in breadth, consequently making a much finer rush and foam. 
One side of the dell for some way below the fall, as well as above it, is bordered 
by abrupt and naked rocks; the other side, the bank being less steep, is cut 
into walks and planted with shrubs, having moss houses and other seats scattered about. This was all done by the late Earl of Miltown for the accommodation of the neighbourhood, who in the summer season often make parties 
hither and bring their dinner to enjoy the delightful scene. At this time there 
were five or six such parties. Mosses in great variety were to be collected here, 
as at **Loch-Hela**. I returned into the road at **Ballymore Eustace**, four miles 
beyond **Blessington**, and there stopped for the night. This is a small town 
standing on the **Liffey** near where it issues from the dell of **Poll-a-Phuca**. There 
 


---

p.217



 
is a handsome bridge over the river, which spreads out to a considerable width, 
though very shallow.


The family of Eustace, after whom this town takes its name, was a very ancient one. It is probable that the proper name of the town is **Bally-Eustace**, that is, the town of Eustace; Bally signifying a town; and that by some accessory circumstance it has been extended into **Ballymore**. Near **Kilcullen-Bridge**, 
five miles further, are the ruins of a castle, formerly the residence of this family; and near them the remains of an abbey, still in its fallen state, retaining 
the name of **New Abbey**, which was founded by a **Sir Rowland Eustace**, in the 
fifteenth century, for Franciscan friars. In the church was a very fine monument to the founder. Both that and the church were well preserved till about 
eighty years ago, when a great part of the church was pulled down to furnish 
materials for building a Roman Catholic chapel in the neighbourhood. **Kilcullen-Bridge** is a town raised upon the downfall of **Old Kilcullen**, which stood 
on a hill about a mile further. The building a bridge here over the **Liffey** was 
the first step which led to the abandonment of the old town; and the situation 
was found so much more advantageous, that it was not long before the town 
was entirely transferred hither. The remains of **Old Kilcullen** now standing 
are very trifling. The walls of a church in tolerable preservation, with part of 
a round-tower close by, placed on the brow of the hill, form conspicuous objects 
some way round. The architecture of the church is that which is called Saxon, 
appearing about the date of the tenth century. The remains of a stone cross 
having some curious sculptures upon it are also to be seen here, some particulars 
respecting which may be found in **Dr. Ledwich**'s Antiquities. The town in its 
prosperity was walled round, and had seven gates: some vestiges of two are 
remaining. Of habitations there is nothing now to be seen but a few very 
poor cabins. The most ancient name of this town was **Killeughly**, as the principal town of the barony in which it stands, which was then so called. It was 
afterwards called **Penkoyle**, or The Church on the Hill, having at length its 
present name, according to some traditions, from being the burial-place of 
St. Caëlan or Colyn; — kill, as I have before remarked, meaning a burying-place. Others give a different derivation of the name. On a hill a little to 
the north is a circular intrenchment, supposed to have been the rath, or fortress, 
of the Mac Kellys, ancient Irish chiefs, and called from them Caër Caëllan, 
 


---

p.218



 
The fort of the Caëllans, or Kellys; whence comes Caëllan, or Cullen, not from the name of any saint. Within this intrenchment **Oliver Cromwell** encamped for one night when he was on his march to the south.


About six miles beyound **Kilcullen**, just out of the road to the right, is an 
assemblage of neat white houses, which cannot fail immediately to catch the 
eye. It is a village inhabited entirely by **Quakers**, and every thing about 
bears the impression of their sect; it is neatness itself. The inclosures are 
surrounded with quickset-hedges, kept in the nicest order, having trees planted 
in them all at regular distances; the fields are like lawns, not a weed is to be 
seen in the orchards and gardens: nothing can exceed the neat and orderly 
appearance of the whole place. The name of the village is **Ballytore**; a little 
river called the Greece winds through it. It is said that **Mr. Burke** received the 
first rudiments of education at a school in this village; it is certain that if he 
did imbibe his A B C ... here, he did not imbibe with them the placidity, calmness, and tranquillity of mind and manners that characterize this remarkable sect.


**Castle-Dermot**, thirty-four miles from **Dublin**, was once a very large fortified town, and the residence of the Dermods kings of **Leinster**, the last of 
whom, Dermod Mac Murrough, was the principal occasion of the conquest of 
the island by Henry the Second. Very large remains of a Franciscan abbey, 
founded about the middle of the thirteenth century by Gerald earl of Kildare, 
are now standing. Part of a round-tower, very much overgrown with ivy, and 
having the appearance of the celebrated round-towers, is incorporated in the 
outward walls, in the manner of a bastion in old fortifications; all the ruins 
are overgrown with ivy, which always gives a picturesque effect. This place 
continued to be of considerable note for a long time after the English conquest: 
so late as the year 1377 a parliament was held here, and there was a mint to 
coin money. What remains of the old parliament-house is now converted into 
an inn.


**Carlow**, five miles further, stands on the river **Barrow**. On an eminence 
directly above the river are the ruins of an old castle erected in the reign of 
**King John**, as a security to the English frontier, which then extended no 
further. In 1397 this castle was taken by Donald Mac-Art, of the family of 
the Kavanaghs, who called himself Mac Murrough king of **Leinster**. It remained 


---

p.219



 
in the hands of him and his descendants till the reign of **Queen Elizabeth**, when it again received an English garrison. There are also some fine ruins of an abbey. **Carlow** is a large town, superior in the neatness of its appearance to most towns. It has one very long street crossed about the middle by 
another not of equal length, and from these principal streets diverge several 
smaller, and many back lanes. A manufacture of woollen cloth is carried on 
here, and the inhabitants are much employed in the collieries of **Castlecomer** in 
the county of **Kilkenny**, which are not more than eight miles off, particularly 
in transporting the coals to different parts of the country. From hence to 
**Leighlin-Bridge** the road is very pleasant, almost all the way along the banks 
of the **Barrow**.


**Leighlin-Bridge** (pronounced Lochlin) is a small town or village like **Kilcullen-Bridge** removed from the old town for convenience of situation. Old **Leighlin** in conjunction with **Ferns** forms a bishop's see. The remains of that 
town are three miles from **Leighlin-Bridge**, among the mountains: besides the 
cathedral and the seat of a Mr. Vigors, there are only a few poor cabins. The 
cathedral is old, but kept in good condition by the bishop. Just without the 
church, at the east end, is a famous well surrounded by tall ash-trees dedicated 
to Saint Lasarien; it is held in great veneration, and much resorted to by the 
people in the neighbourhood. There is something very wild and romantic in 
the situation of these remains. From hence to **Kilkenny**, the extent of my this 
day's journey, is twelve miles; **Kilkenny** being fifty-seven miles from **Dublin**. 
At **Kilkenny** I had an introduction to the Earl of Ormond's agent, an English gentleman, **Mr. Barwis**, and we were not a little surprised on meeting, to 
find that we had been fellow-passengers in the packet from **Holyhead** to **Dublin**. One of my objects here was to collect all the information I could for a 
mineralogical friend of mine respecting the coal of the country, so well known 
under the title of **Kilkenny** coal. But I found that the collieries, though in the 
county of **Kilkenny**, were not very near the town, but at **Castlecomer**, nine miles 
off, and I was obliged to defer going thither till my return from **Cork** and **Killarney**. **Mr. Barwis** very obligingly, on the morning after my arrival, showed me 
the castle, the seat of the earl, now Marquis of Ormond, and accompanied me 
to the marble quarries just without the town; but then being engaged with business 


---

p.220



 
which could not be deferred, he invited me to make the castle my residence 
for a day or two on my return, when I could see any thing left now unseen. He 
besides introduced me to Dr. Ryan, an eminent physician in the place, from whom 
I not only obtained much mineralogical information, but who favoured me with 
some valuable mineralogical specimens. Among these must be particularly mentioned some excellently well defined vegetable impressions found in the senate 
about the veins of coal, consisting principally of ferns and a gigantic species of reed. 
**Kilkenny** stands upon the river **Nore**, one of three rivers that unite to form 
the harbour of **Waterford**; the **Nore** being first joined with the **Barrow**, and 
their united streams afterwards combining with the waters of the **Suir**. Though 
the general name of **Kilkenny** is given to the whole town, it consists of two distinct divisions, Irishtown and **Kilkenny**, which are under separate jurisdictions, the former being governed by a portreeve, the latter by a mayor. Irishtown is one of the oldest towns in the whole island; by the inhabitants it is now 
called **Bally-gaëloch**, or the Town of Gaël on the Lake, the part whereon it 
stands having been formerly a marsh, sometimes so overflowed as to become 
like a lake; it is still very subject to inundations from the river. The first embryo of a town consisted only of a range of cabins, in this marshy ground running along the margin of the river. Such seems to have been the taste of the 
ancient inhabitants in choosing spots for their establishments; this was the case 
with **Dublin**, it was so with **Cork**, it was so with **Limerick**. 
The name of **Kilkenny** is differently derived. As nothing can go forwards 
very well in **Ireland** without the assistance of a saint, we have here one under the 
name of Saint Canice or Kenny. He was brought up in his infant years by a 
cow, whose milk he sucked, but how he came to be consigned to her care does 
not appear. No mention is made of a similar fate to that of Romulus and Remus when the wolf had compassion on them, the fact alone is stated that a cow was his nurse. He was afterwards employed as a shepherd's boy; but here he 
seems to have neglected his flock, for he was continually occupied in making 
little churches cut out of wood, or framed with osier twigs, with all the appendages of altars, crucifixes, &c. &c. This devotional turn constantly increasing 
upon him, when he grew up he entered himself in a monastery, where having 
continued several years, he by consent of the superiors travelled to Rome: here 


---

p.221



 
still distinguishing himself by his extraordinary devotion, he obtained the highest 
renown. He was first buried at **Aghaboe**[24](javascript:footNote('E810001-001/note024.html')), but his remains were afterwards 
transferred to **Kilkenny**, from which time it has been known by its present name, 
signifying the Burial-place of Kenny. Some, however, not satisfied with this derivation, say that the name is derived from the local circumstances attending the 
hill on which now stands the cathedral; in those times it was covered with wood, 
and thence called Coil or Kyle-ken-ui, the woody head, or hill, above the river; 
thence the transition is easy to **Kilkenny**.


The cathedral is a very ancient structure; it was begun about the year 1230 
by **Hugh Mapilton** then bishop of the diocese. It is, like all cathedrals, in the 
form of a cross, the length from east to west being 226 feet, from north to 
south 123. The steeple is broad, but not lofty; it is supported by four very 
massive pillars of the black marble of the country; — of the same marble are the 
pillars which support the roof. But by the strange and absurd taste, or rather 
want of taste, in those who had the guardianship of the church about seventy or 
eighty years ago, they were all whitened over with a lime-wash. The original 
east window was esteemed one of the finest pieces of Gothic architecture ever 
seen in **Ireland**. So highly finished was the workmanship, that when **Rinucini**, 
archbishop and prince of **Fermo** in **Italy**, was in **Ireland** in the year 1645, as 
nuncio from the Pope to the Irish Catholics, he was so much struck with it that 
he would fain have purchased it to carry to **Rome**, offering for it no less than 700l., 
a large sum in those days. The Chapter, however, could by no means be prevailed upon to comply with his wishes. Only five years after, amid the troubles 
of the civil-wars, this window shared the fate of many monuments of art about 
the country, and was demolished. Some fragments of it were subsequently collected by that great scholar and traveller **Dr. Pococke**, when he was bishop of 
the diocese, and are now in the church. The stained glass in it contained the 
history of Jesus Christ from his birth to his ascension. The choir of the cathedral is fitted up with oak varnished, but quite plain without any carved work.




---

p.222


#### 22


That the church is still standing is principally to be ascribed to the great zeal 
and care of **Bishop Pococke**. When he came to the see it was in a very ruinous 
state, having been wholly neglected for a long course of years. He made a 
large subscription in the diocese, to which he himself contributed amply, and 
had it put into complete repair, superintending the workmen himself, often being with them by four o'clock in the morning. In the church is a monument 
to the memory of this distinguished prelate, executed by **Scheemaker**; 
it is of white marble. A whole-length figure representing Piety stands with her head 
reclined upon one hand, which is rested on an urn supposed to contain the ashes 
of the deceased; in the other hand she has a book. The bishop's arms are at 
the end of a long shaft. On the monument is the following inscription: 
  
 
Sacred to the Memory of **Richard Pococke, LL. D.**
  
 
Who from the Archdeaconry of Dublin 
  
 
Was promoted to this See M.DCCLVI. 
  
 
And translated to that of **Meath** M.DCCLXV. 
  
 
Where he died September 15th in the same year. 
  
 
He discharged every duty of the Pastoral and Episcopal Office 
  
 
With prudence, vigilance, and fidelity, 
  
 
Adorning his station 
  
 
With unshaken integrity of heart and of conduct. 
  
 
Attentive to the interests of religion, 
  
 
He caused several parochial churches to be rebuilt 
  
 
Within his Diocese; 
  
 
He promoted and liberally contributed to the repair 
  
 
And to the embellishment of this Cathedral Church 
  
 
Then unhappily falling to decay. 
  
 
A zealous encourager of every useful public work, 
  
 
Especially the Linen Manufacture, 
  
 
He bequeathed a very considerable legacy 
  
 
To the Governors of the Incorporated Society 
  
 
For promoting the united Interests of Industry and 
  
 
Charity, 
  
 
Within this Borough of Saint Canice.


The bishop was not, however, buried here, but at **Ardbraccan** in the county 
of **Meath**. There are a great many monuments and inscriptions about the 
church, most of them very old. A round-tower stands within a few yards of it 


---

p.223



 
on the south side: it is very lofty, and in a state of high preservation. The 
cathedral is dedicated to St. Canice. 


The abbey of St. John was the oldest monastic foundation in **Kilkenny**, and 
was built early in the thirteenth century. It stands on the east side of the river 
Nore. Very extensive remains of it are still existing; but a great part has 
been terribly degraded by being patched up into barracks. The wall of the east 
end of the church, the whole of the south, and part of the north, are standing; 
and at this time it was just determined to add whatever was wanting to complete the building, modelling the work exactly after the old part, and convert 
it into a parish church, — a very laudable undertaking. The abbey of the Dominicans, known as the **Black Abbey**, is on the other side of the river. Most of 
the outward walls of the church, with the Gothic windows, are still standing, 
with two handsome towers. The carved work of the windows is very rich, 
much superior to St. John's. There is an idea of restoring this also as a church, 
and it is much to be wished that it may be prosecuted. This abbey was built 
in the thirteenth century, within a few years after St. John's. The Franciscan 
abbey was very extensive, and showed some equally good specimens of Gothic 
architecture; but a great part of its remains have been converted — shall I not 
say *perverted* — into barracks. 


The castle makes a very grand appearance on entering the town, crowning 
an abrupt and precipitous rock, with the **Nore** running at its base. This rock 
had been previously the site of a Danish fortress, which was finally demolished 
at the conquest of the island by the English. The present castle was built as 
a fortress to supply its place, but who was its original founder is not well authenticated, the credit of it is generally given to **Earl Strongbow**. A very 
high wall of solid masonry runs along the base of the rock, and probably was 
once continued all round the domain; it now only serves to inclose a lawn 
and shrubbery in front of the house. Between the wall and the river is a walk, 
which is a great mall for the gentry of the town. It seems to have been intended that the building should be a square, with a court in the centre, having 
large round turrets at each corner. Only two sides of the square, with three 
towers, were ever completed; but the foundations of the remaining part of the 
building appear. 


The great entrance is by an archway in the centre of one side of the building 


---

p.224



 
which fronts the parade; this leads into the court, where is the entrance to 
the house. The principal front of the house is to the river, looking along its 
course over two bridges, having the lawn directly before it. There is nothing 
of magnificence in the interior; scarcely a single room is regularly shaped, yet 
there is an air of antiquity and nobility about it altogether, that sufficiently 
compensates for its irregularities. The breakfast-room is of the most irregular 
form, running into the principal turret. The walls are of such an immense 
thickness, that each window forms a separate recess, large enough to hold a 
company of six or eight at breakfast. In the room are some good tapestries. 
There are a vast number of portraits in different parts of the house, and some 
other pictures, but none very remarkable. In a gallery 150 feet long are whole-length portraits of Charles the First, Charles the Second, James the Second, 
**King William** the Third, Queen Mary, Queen Anne, and the first Duke of 
Ormond, besides a vast number of others. In an apartment called The Evidence Chamber is a very large collection of papers relating both to the private 
family concerns, and the many important public events in which the family 
have at various times borne a conspicuous part. Among other curious things 
which **Mr. Barwis** showed me, was an old house-keeping account-book of the 
family, from which a general idea might be gathered of the mode of living in 
those times: I think it was about 200 years old. From the top of one of the 
turrets is a fine view over a vast extent of flat country, skirted by mountains, 
some more, some less, elevated. The stables are magnificent; and the kitchen-garden and conservatories good.


Though I could not now go to see the collieries, I saw a noble fire in the 
kitchen made from the produce of them. The coal is of a remarkable quality, 
burning entirely without smoke; having much more the appearance of a fire 
of charcoal than of mineral coal. It is difficult to light it at first, a large foundation of turf must be laid underneath; but when once lighted, it burns for an 
amazing length of time without any addition of fuel. It is a most valuable coal 
for cookery, secure from all danger of things being ever smoked, perhaps the very 
worst fault that cookery can have.


Near the castle, on the opposite side of the river, is a school, or college, 
originally founded and endowed by the Ormond family. The election of 
a master of this school is vested in the provost, fellows, and scholars of Trinity 


---

p.225



 
College, Dublin; but it is thought that the latter description of persons are not 
much consulted by the two former when a vacancy is to be filled up. The 
house is a neat modern one, and there is a spacious play-ground for the boys. 
Over the **Nore** are two handsome bridges; that nearest the castle has three wide 
elliptical arches, the other has seven circular ones. Both are built of the black 
marble of the country. During the thirteenth, fourteenth, and fifteenth centuries, parliaments were frequently held here. A memorable one was that of 
1367, when the old Brehon laws were abolished, and the English laws alone 
substituted in their place. Very high penalties were enacted on this occasion 
upon any Englishman wearing the Irish dress.


The marble quarries are not above a quarter of a mile from the town; they 
are very extensive; the whole mass of rock for a great way seems entirely composed of the marble, differing only in quality, some coarser, some finer; it is 
in fact the stone of the country. The inhabitants of **Kilkenny** boast that they 
have fire without smoke, earth without bog, water without mud, air without 
fog, and that their streets are paved with marble. The first clause is certainly 
very true, as I have testified above; for the second, I can say that I undoubtedly 
did not perceive any bog in the environs of the town; for the third, the water, 
as far as I saw of it, was perfectly clear and pure; for the fourth, I was not 
there a sufficient time to say any thing about it; the last, that the streets are 
paved with marble, is very true. But how paved with marble? Those who 
should expect to walk or ride over beautiful polished marble slabs, would find 
themselves exceedingly mistaken. The marble is, as I have said, the stone of 
the country; the fine slabs taken from the quarries are reserved to be polished, 
and used for the purposes of chimney-pieces and the like, while the coarser 
parts are employed in all the most ordinary uses to which stone is usually applied; 
with this refuse the town is paved, and in walking over the pavement, 
nothing more appears to the eye than as if it was of the most ordinary pebbles; 
nay, if broken, the interior scarcely displays so much beauty as one of the pieces 
of Scotch granite which paves the streets of **London**. For some objects, the 
dark hue of the marble, though beautiful when polished, is unfavourable; as 
for example, to the bridges it gives a sombre funereal appearance, the effect of 
which is far from being good. Some of the poorest houses in the town are in 


---

p.226



 
like manner built of marble, the roads are mended with marble, and some of 
the inclosures are fenced with marble. 


The black, when first polished, is very fine; but, as is too frequently the case 
with the marbles of this country, and of most in the British islands, the intensity of colour is by no means permanent; after a time it becomes gray, and 
exhibits numerous white spots. All does not, however, show an entire black 
at first; indeed, the more prevailing character is to be mottled ab origine, the 
result of the marine exuviae with which all marble abounds. Distinct casts of 
shells are occasionally found in it, but not very frequently. An Italian, who 
was once at **Kilkenny**, seeing a particularly fine slab just then come from the 
polisher's hands, appearing an entire and pure black, was so struck, that he said, 
if they could send a few such to **Italy**, any price would be given for them, for 
that none so pure was produced there. The person to whom he said this was 
obliged to confess, that the beauty he so much admired was not lasting; that 
after being exposed awhile to the air white spots would appear. Such was the 
case with some chimney-pieces of **Kilkenny** marble which I saw at **Mr. Weld**'s at **Ravenswell**: he said they were at first a perfect black; when I saw them 
they had many white spots about them. Crystallized carbonate of lime occasionally mingles itself with the marble.


Very near the quarries is a pit of a dark coarse sand, composed of siliceous 
and calcareous matter, with numerous pebbles of common limestone, generally of 
a dark colour, but sometimes approaching to a cream-colour; nodules of iron-clay also occur occasionally. Whether this sand or gravel is transported to **Dublin** I cannot tell; but it certainly has very much the appearance of the 
dark gravel which I have noticed as used there. The idea did not immediately 
strike me; nor indeed did it till after I left **Ireland**; but certainly no gravel of 
that kind, or of any kind, occurs in the neighbourhood of **Dublin**.


The theatricals of **Kilkenny** were for a long time exceedingly celebrated, but 
they have now for some years ceased entirely. They were carried on by a society of gentlemen, who used to perform for about a month every year, which 
created a sort of jubilee in the town. They had a little theatre of their own, 
and whatever remained of surplus from the receipts at the performances, after 
paying the nightly expenses, was given to different charities in the town. The 


---

p.227



 
dresses were not allowed in the general expenses, they were each person's individual expense, and sometimes very large sums were expended in them. The 
female performers were actresses from the **Dublin** stage. But a thing of this 
kind, however eagerly pursued at first, in time begins to cloy; and after flourishing awhile, the performances gradually became less and less attractive, till at 
length they were entirely dropped; yet, though they ceased from being neglected, 
all persons now talk of them with such regret, that no one hearing it could suppose their failure was owing to such a cause.


A woollen manufactory for blankets and cloths is carried on here to a very 
considerable extent. It was first established by the Ormond family. **Pierce 
earl of **Ormond****, and his wife the **Lady Margaret**, brought over manufacturers 
from **Flanders** expressly for the purpose. There is also a considerable starch 
manufactory. Before the Union, each division of the town returned two members to the parliament; at present the united towns send only one. The population of the town is estimated at about twenty thousand. A **Book Society** has 
of late years been established by subscription, upon the plan of being open to 
the subscribers to go and read there, but the books not to be circulated. It 
has always appeared to me, that half the use of such societies is annihilated by 
not circulating the books, bien entendu, under proper regulations: this the subscribers to the **Kilkenny** library have found so strongly, some of them at least, men of business, whose chief time for reading was in the evening, after the library was shut up, that they were making great exertions to get the inconvenience remedied, and the books put into circulation.


**Clonmel**, twenty-four miles from **Kilkenny**, eighty-one from **Dublin**, is an 
ancient town with a good deal of modern addition to it, standing on the **Suir**, 
one of the rivers that runs to **Waterford** harbour. Over the river is a handsome bridge of twenty arches. A town is believed to have existed here before 
the Danish invasion. In **Oliver Cromwell**'s time **Clonmel** made a longer resistance to his arms than any town in **Ireland**; when it surrendered, he ordered 
the castle and fortifications, which were very strong, to be demolished; few fragments of them now remain. At present the town is much inhabited by **Quakers**, 
who, wherever they go, communicate to a certain extent a spirit of neatness; 
this town consequently, though so ancient, is very clean. A Dominican friary 
was founded here in the year 1260, and a Franciscan friary the same year. 


---

p.228



 
The church of this latter was one of the most magnificent that any monastery 
in **Ireland** could boast; in it was an image of Saint Francis, celebrated for the 
many miracles it performed. The town consists of four streets crossing each 
other at right angles. A very extensive woollen manufacture is carried on here 
principally by the **Quakers**. Not far from the town, on a hill rising above 
the **Suir**, is a spa-spring, formerly in great repute as a remedy for scorbutic 
complaints and other chronic diseases; but the fashion is now over, other 
waters have come into higher repute, and this is entirely neglected. The river 
is navigable from hence to **Waterford**. **Clonmel** was the birth-place of the celebrated **Sterne**, author of Tristram Shandy; assuredly one of the first of wits, 
though it were to be wished that he had not on all occasions so entirely given 
the reins to it, but had tempered it with more of delicacy.


The road does not cross the river here, it continues on the north side seven 
miles further to **Ardfinnan**. This is a very ancient village, where are the ruins 
of an old Gothic castle standing on a rock which overhangs the river. It was 
built by **King John** while he was Earl of Morton. An abbey for regular canons was founded here by Saint Finian the Leper, to which the noted Cormac 
MacQuillenan, archbishop of **Cashel** and king of **Munster**, bequeathed in 
the year 903 his horse, his armour, and some other bequests in gold and silver. 
The town and abbey were sacked and plundered by the English in 1178. 


**Fermoy**, a hundred-and-seven miles from **Dublin**, is one of those striking 
instances not unfrequently to be seen, of what may be accomplished in a very 
short space of time by the intelligence and activity of one man. It stands upon 
the **Blackwater**, and an ancient bridge of thirteen arches here crosses it at a 
weir of the river. Of this bridge the annexed plate gives a view. The whole is 
entirely overgrown with ivy, so that the water pours through green arches down 
the weir; the white foam of the falling water mingling with the green arches 
produces an uncommonly pretty effect. Through the interest of my friend Mr. 
Walker, Captain England, an officer in the barracks at **Fermoy**, was so obliging as to take this sketch for me. But though the bridge is ancient, the town 
is entirely modern. In the year 1791 it was a very poor village, consisting only 
of a few mud cabins. At that time the Government, having determined to erect 
barracks somewhere in this neighbourhood, were in treaty for the purchase of a 
parcel of land from a gentleman, not exactly in this spot, but at a little distance. 
 


---

p.229



 
The owner, however, asked such an enormous sum for his property, 
that a demur was made whether to conclude the bargain or not; when Mr. Anderson, who had some property here, offered what land was wanted at a reasonable price. The bargain was immediately concluded, and a contract was entered into with him for building the barracks. From that time the town has 
rapidly risen, under the auspices of this spirited and active member of the community, to its present flourishing state. A large square is built at the foot of 
the bridge, at the corner of which is a most excellent inn, one of the best I 
found in any part of **Ireland**; also an excellent range of houses along the side 
of the river, and several new streets. Manufactories have been established 
which are in a very flourishing state, and every thing wears the appearance of 
ease and prosperity. The church stands very prettily upon the ascent of a 
hill above the river; the barracks are spacious, and make a handsome appearance. If I could have been tempted to wish for ancient castles with frowning 
battlements rising above the stream, or for the sombre fragments of a fine 
Gothic abbey, as according better than neat spruce modern habitations with the 
ancient bridge overgrown with ivy, yet I forgave these modern houses their 
want of picturesque effect, in consideration of the pleasing associations they afforded, from the idea of the comforts enjoyed by their inhabitants.


**Fermoy** is a name of great antiquity; one of the numerous petty kingdoms of 
Ireland in ancient days was so called, and such is now the name of one of the 
baronies of the county of **Cork**, though not that in which the town of **Fermoy** 
stands. The ancient name of the district was **Fearmuigh**, and the sovereignty 
of it was in the family of the O'Kiefs, or Mac Kiefs, who claimed their descent from the Milesian kings of **Ireland**. The name of **Fearmuigh** is differently derived; some say it signifies simply and humbly grassy plains, this 
being a country rich in pastures. Others, who like to trace all derivations back 
to something of the marvellous, say that Muigh was an eminent Druid of old 
who assisted the king of **Munster** in gaining a great victory over his enemies, 
obtaining by his prayers that the sun should stand still for two or three hours, 
till the forces of the adversary were completely routed. In consequence of this 
service, the district in question was granted to Muigh, who from that time was 
called Fear-muigh, that is Muigh the doer of great deeds, and this name was 
afterwards given to the district.




---

p.230


#### 22


**Rathcormuck** is a neat little town a hundred-and-eleven miles from **Dublin**, 
standing on the river **Bride**, which runs into the **Blackwater**. To the north 
of this town is a range of mountains, the most easterly of which is called 
**Cairn Tierna**, or the Thane's Heap, from one of those Cairns or heaps of 
stones which are so common on the tops of mountains. This hill is a conspicuous object from various parts of the country. The last place to be mentioned, 
before the city of **Cork**, is **Glanmire**. This is a little village in a beautiful and 
romantic situation, with a small stream running through it on which are several mills: from hence it winds through a deep and romantic glen, till it joins 
the Cork river about three miles below the town. After descending the hill of 
**Glanmire**, the road runs by the side of the **Lee** till it enters **Cork**. 




---

p.231


Antiquity of the City of **Cork**. — Origin of the Name. — Ancient and present State of the Town. — The Buildings. — The Bridges. — St. Finbarr. — The **Cork Institution**. — Articles of Commerce. — New Mode of preparing Flax. — Beauty of the Environs of **Cork**. — Urbanity of the Inhabitants. — **Mr. Kean** much admired there. — Anecdote of a Sailor at Drury Lane Theatre. — Mr. Harrison and his Family. — The Mardyke Walk. — **Blarney Castle**. — The Blarney Stone. — **Black-Rock**. — Lady Chatterton and her Family. — Sail about the Harbour. — The different Islands. — Marquis of Thomond's Seat at **Rostellan**. — The Steam-Boat. — Mineralogy. — Barry the Painter. 
#### 23


In speaking of **Cork** it would perhaps be wrong to call it a very ancient city, 
since it exhibits scarcely any remains of antiquity, but in its present appearance 
gives exactly the idea of what it is, a very prosperous and flourishing commercial town. Yet in very remote times there was a settlement here; if not 
before the Danish inroads, certainly during the time of their usurpation. Like 
many other places, the ground on which the city stands was entirely a marsh; 
and such spots being called in the ancient Irish language corcass grounds, hence 
it is believed the town derives its name of **Cork**. To this day among the lower 
classes in those parts of **Ireland** where the original language prevails, marshes 
have the same appellation of corcass grounds. Some, however, believe the 
name is derived from corcach, as the ancient boats made of wattles covered 
with hides were called; and this town being probably at first a settlement of 
fishers, they called their town after their boats. In some ancient documents 
it is called **Corcach**.


The principal part of the city stands on an island formed by the river **Lee**, 
which separates into two branches more than a mile above the town, and unites 
again below it. Formerly the town was intersected by a number of canals; 
cut, as some say, to drain the land, according to others, for purposes of commerce: whatever was the intent of them, they were found, instead of a convenience, a nuisance to the town; the filth from the houses being thrown into 


---

p.232



 
them, and occasioning terrible putrid exhalations. They have, in consequence, 
through the interposition of the magistrates, been all filled up. It is generally 
believed that the Danish city was confined entirely to the island; that it was 
walled round, and well fortified; but since **Cork** has risen into note as a place of 
commerce, it has been extended every way much beyond the limits of the 
island. Nor does any trace of the ancient walls remain; one gate-way only is standing upon the north or main branch of the river; it is used now as the city gaol.


In the time of **Queen Elizabeth** **Cork** was considered as only the fourth 
city in **Ireland**. It is thus described by **Cambden**: — "This city is of an oval 
form, inclosed with walls, and encompassed by the channel of the river, which 
also crosses it, and is not accessible but by bridges, lying along, as it were, in 
one direct street, with a bridge over it. It is a populous little trading town, 
and much resorted to; but so beset with rebel enemies on all sides, that they 
are obliged to keep constant watch, as if the town was continually besieged: 
and they dare not marry out their daughters into the country, but contract 
one with another among themselves, whereby all the citizens are related in 
some degree or other." At that time **Limerick** and **Waterford** were considered 
as the second and third cities in **Ireland**; but the little populous trading town 
has so much increased since the time it was thus described, that it now ranks as 
the second city, and is called the **Bristol** of **Ireland**, while **Limerick** and 
 **Waterford** are thrown each a step lower in the ladder, and become the third 
and fourth.


From the gate now standing a street called the Main-street runs directly 
through the town to the south channel, where was another gate. At each gate 
was a bridge; and these were the only accesses to the town. In 1633 great 
part of the bridge over the north channel was carried away by a flood. It was 
replaced by a wooden bridge; and this again was taken down in 1712, when 
the present, a handsome stone bridge, was erected in its place. Since that 
a drawbridge has also been built over the main channel, more at the east 
end of the town. This is now the principal entrance from **Dublin**. Two 
additional bridges have also been built over the south channel. To the east of 
the main street, where one of the canals from the south channel ran up, is 
a handsome wide street called the Grand Parade; at the end of which runs 
a stone balustrade along the river-side. Just at the centre of the balustrade 


---

p.233



 
stands an equestrian statue of **King George the Second**, but it is a very poor 
one.


There is not much to be said for the architectural beauty of any of the public 
buildings. The Exchange is in a dirty bad part of the town, but has little to 
display if it were in a better. The old Custom-house is ugly; a red-brick building, with white pilasters: but a new one which was begun, is expected to be 
very handsome. The churches have little to boast of, not even the cathedral 
 — half modern, half antique, they have neither the grandeur of the one, nor 
the neatness and prettiness of the other. The town is upon the whole recommendable to the eye only as having a general appearance of comfort and prosperity, not as offering any particular subjects to dwell upon.


The first extension of the city was on the north side of the river. The rocks 
here are steep; but just opposite to the old bridge a sort of dell runs up for 
some way, where lie the principal part of the suburbs on this side. Lately, 
however, extensive barracks have been erected on the heights directly opposite 
the drawbridge, where indeed the ascent is so steep, particularly towards the 
top, that a carriage could with difficulty get up; it should seem as if the idea 
was, that the barracks were to be frequented principally by asses and mules. A handsome street is begun, running along the side of the declivity about a third 
of the way up. It is somewhat extraordinary, considering the city is doubled in 
magnitude within a century and a half, that the number of churches should be 
diminished: there were once eleven; there are now only seven, six parish 
churches and the cathedral. This does indeed seem a scanty provision for a population estimated upon the lowest computation at a hundred thousand: some 
carry it to a hundred and twenty thousand, but that seems generally thought an 
exaggeration. The old cathedral was dedicated to St. Finbarr, a saint who 
flourished, according to tradition, in the seventh century, and by him the church 
was founded. A life of him in manuscript, written in Latin, is to be seen in 
the library of Trinity-college at **Dublin**, which says that his real name was Lachan; that he was so baptized, and that he was a native of Connaught. Finbarr signifies white- or gray-headed, and there are no less than seven of the name 
enumerated among the saints of **Ireland**; but he of **Cork** was the chief of them. 
As a saint is nothing without a miracle, the following is recorded of him: — 
A knight having seized some lands belonging to his see of **Cork**, and sowed them 
 


---

p.234



 
with barley, he went to him, and adjured him in the name of God and all the 
saints to surrender them again. This being refused, he prayed with tears and 
uplifted hands that the seed sown in them might never come to harvest. So it 
happened, for not a grain of the corn was seen to shoot from the earth. The 
knight perceiving this, and finding he could not turn his theft to any account, 
was in a proper situation to repent, which he did, and restored the land. The 
saint then had it sown with wheat, but instead of the wheat a barley crop appeared; upon which, not doubting but if the land was left unsown the next 
year the wheat would come up, he ordered that it should be so; and the event 
proved him not mistaken — a very fine crop of wheat came forth at the proper season. The old cathedral had fallen so entirely to decay, that about a century 
ago it was pulled down, and the present one in the modern taste built. There 
are many charitable institutions in the city, as hospitals, endowed schools and 
others.


A Society has been formed within a few years, called the **Cork Institution**, 
which is now incorporated by charter, for the purpose of directing the application of the sciences to all the most important uses of common life. Having 
among several letters of introduction here, one to **Dr. Willes**, an eminent physician of the town, he obligingly recommended me to **Mr. Davy**, cousin to **Sir Humphry Davy**, who is at the head of the chemical department, and he showed 
me over the whole Institution. Considering that it has not been established 
more than eight or nine years, a great deal has been done: there is a very 
well-selected library, to which additions are constantly made; and a museum, 
at present consisting principally of a good collection of minerals, but where any 
thing rare that circumstances allow of being added is to be deposited. There are 
also a philosophical apparatus, and a very excellent laboratory. Lectures are 
given at certain times of the year in chemistry, experimental philosophy, agriculture, and botany. Just without the town is a botanic garden, which promises 
in a few years to be a very good one.


The great staple article of commerce in this place is the salting provisions 
for sea-stores. The curing season commences about October, and lasts for three 
months, in which about a hundred thousand head of black-cattle are annually 
sacrificed, besides a proportionate quantity of hogs. Raw and prepared hides 
are in consequence a considerable article of trade. Butter and candles for 
the navy are also supplied. There are in the town large manufactories of sailcloth, 


---

p.235



 
coarse woollen cloths, paper, glass, and glue, all which articles are also 
exported. A good deal of flax is grown in these parts, and linen manufactories 
are carried on, but not to the extent they might be. A new discovery had just 
been made in preparing flax, which promised to be of very great importance. 
It was to clear the fibres used for the linen without the process of steeping the 
flax. This was performed by means of machinery. A small piece of the flax 
thus prepared, ready to be spun, was given to me. It is of the most beautiful 
texture imaginable; the fibres delicately fine, and so nearly white, that scarcely 
any bleaching would be required. In delicacy it is indeed almost equal to the 
raw silk, as wound from the cots of the worms. The advantages of this mode 
of preparing the flax, if it can be brought into general use, will be incalculable. 
By avoiding the steeping it in the ditches till it becomes putrid, the flax-countries 
will be relieved from an almost insupportable nuisance. It is impossible to 
conceive any thing more horrible than the effluvia emitted by it when taken 
from the ditches and spread out to be dried. The year before when I was in 
the county of **Antrim**, one of the great linen countries, it happening to be the 
time of preparing the flax, I was sometimes almost made ill with the stench; 
no one who has not been in the way of it can have an idea how offensive it is. 
Besides the removal of so great an evil by the new process, the fibres never 
having been reduced to this putrid state are much stronger, and the linen, instead 
of being of the dark hue which requires such excessive time and labour to bleach 
it, thereby still further weakening the cloth, would scarcely demand the bleaching 
process at all; one which of late years, from the chemical applications used, has 
spoiled many a web.


What progress has been made in bringing this discovery to perfection, or 
whether any, I have not heard; 
probably, if ever perfected, great difficulty will 
be experienced in bringing it into general use; — a new discovery, how manifest 
soever may be the advantages, always has an immense mass of prejudice to 
overcome before it can be finally established; and here the interests of two 
classes of people will be so materially affected, that they will be sure to raise 
every possible obstacle to its success. Imprimis; the linen manufacturers, whose market will be lessened by the superior wear of the linen: and secondly, 
the bleachers, whose trade will be reduced almost to nothing. Since the consumer 


---

p.236



 
is to be the person principally benefited, he will be prevented enjoying 
the benefit as long as it shall be possible.


If much cannot be said of the beauty of **Cork**, as the eye alone is concerned, a great deal may be said as to the beauty of the environs, and the hospitality and urbanity of the inhabitants. The river to the east of the town, going 
down towards the harbour, is bordered on both sides with beautiful villas, each 
of which, in enjoying so many charms of situation itself, contributes to render 
that of their neighbours more charming. The whole way along the north side 
of the river to the village of **Glanmire** already mentioned, is a succession of villas ranged along a rapid slope; the slope coming so nearly to the river that 
there is only the breadth of the road at its foot. This is undoubtedly the most 
beautiful quarter; standing on such an eminence, the houses command a noble 
prospect over to the opposite shore, and down the river to the islands going 
towards the harbour, while at the same time the slopes furnish a prodigious 
advantage in laying out and embellishing the grounds. To a family living at 
one of these villas, that of Mr. Callaghan at **Lota-beg**, about two miles from 
the town, I was favoured with a letter of introduction by my friend **Mr. Walker**. 
They have, indeed, a most charming house and sweet place, where I was very 
obligingly entertained. With another letter of introduction I was less fortunate, to Dr. Gibbon, a physician, celebrated for his hospitality to strangers; unfortunately he was at this time absent. But, indeed, wherever I went in 
Ireland I did not find that many recommendations were necessary; one was sufficient to procure so many acquaintance as to leave only a single subject of regret, — that it was often impossible to accept all the civilities offered.


Again here I met Mr. and Mrs. Kean. **Mr. Kean** had been enchanting the 
society at **Cork**, as much as he had twice enchanted that of **Dublin**, for a fortnight before I arrived. This city from very early times has been noted for its 
love of theatrical amusements, and has been accustomed to them in a style 
superior to most country towns. The theatre is only open in summer, when 
that at **Dublin** is closed; the best of the Dublin company are then engaged, 
with the addition, commonly, of some of the most distinguished performers 
from the **London** theatres. Thus, accustomed to the best exhibitions of the 
kind which can be procured, the frequenters of the theatre are become remarkably 


---

p.237



 
good judges of dramatic merit, nor have I any where seen such judicious criticisms upon **Mr. Kean**'s acting as in the **Cork** papers. But here, as 
at **Dublin** and in **London**, he had a formidable task to encounter, in combating, 
by his natural style of acting, the prejudice long created in favour of the artificial style from seeing it carried to so much perfection by **Mr. Kemble**. Yet 
Nature restored, did triumph, and was acknowledged to be superior to Art, how 
finely soever that art was touched. It was difficult to say whether the theatre was most crowded at night to witness **Mr. Kean**'s performances, or his own 
house in the mornings to compliment him upon them. At his benefit the house 
was so crowded that the treasurer, when he came to give in his account of the 
receipts, said that it was fuller than it could hold. This may be thought to 
savour a little of the country in which it was said; 
it was nevertheless so far 
true, that people crowded themselves together, and put many more into a box 
than the number for which it is usually let.


Yet though a fondness for the drama has always prevailed at **Cork**, there 
was no regular theatre till the year 1736. What was then built was soon 
found to be upon too small a scale, so that in about five-and-twenty years a 
second was established, the same that now exists, and the original one was converted to other purposes. In time of war, when the harbour is commonly full 
of vessels, the present theatre is sometimes found too small. Sailors are generally observed to be exceedingly fond of theatrical amusements, partly perhaps 
that they are always somewhat at a loss how to kill time when they are ashore. 
However, of the modes of killing it offered to their choice, this seems to be 
one for which they have a decided preference. — Once in the pit of Drury-lane 
theatre, when **Mr. Kean** was performing his favourite character of Richard 
the Third, I observed a sailor not far from me uncommonly attentive; every 
look, every word, was eagerly devoured by him, till at last he could contain 
himself no longer, and exclaimed aloud, "God bless the man, I declare he deserves a whole pint of grog." A higher compliment I believe the son of Neptune did not think could be paid, and I never witnessed one that seemed to 
come more truly from the heart.


At **Mr. Kean**'s house, two or three days after my arrival, I oddly enough 
met with, and was introduced to a gentleman, Mr. Harrison, to whom and his 
family, but for an accidental circumstance, I should have had a regular letter of 


---

p.238



 
recommendation. Mrs. Harrison is sister to Mrs. **William Monk Mason**, 
mentioned in the former part of my Narrative; and when I then talked of 
following my tour to the North by one to the South, Mrs. Mason obligingly 
wrote to her sister mentioning me, and recommending me to her notice. 
Mr. and Mrs. Mason were, however, absent from **Dublin** this year when I was 
there, so that nothing more could pass between us upon the subject, and I failed 
of my letter to Mrs. Harrison. But Mr. Harrison recollecting, the moment 
he heard my name, that I had talked of coming the year before, introduced himself to me, and carried me to his house to present me to his family. I found 
them all most pleasant people; two young ladies were among **Mr. Kean**'s most 
enthusiastic admirers. I could not trace any likeness in Mrs. Harrison to her 
sister, though not less handsome.


Mr. Harrison's house is just without the town, on an eminence called Sandy's-well Hill, commanding a fine view over the city. He conducted me to it 
by the great mall of the place, the Mardyke walk: it is an avenue of elm-trees, 
an English mile in length, running between the two branches of the river, terminating near a weir, where they separate. This weir is formed by a vast 
bank of stones, the water pouring down only in two places, where there are 
bridges of planks; here we crossed to ascend the hill.


On inquiry into what among the sights of **Cork** I had and what I had not 
seen, **Blarney-castle** was mentioned; and as I had not been there, the family 
said that we must make a party thither, and we went accordingly a few days 
after. The term *All Blarney,* for *all bounce and rhodomontade,* is so familiar in 
Ireland, nay, even in England, that I should have thought scarcely any one 
could be unacquainted with the name at least of Blarney; yet thus it is mentioned by **Sir John Carr**: 
"About four miles before we reached **Cork**, my compagnon-de-voyage pointed out to me **Blarney-castle**, upon a turret of which 
there is a stone nearly inaccessible, which possesses, it is said, the rare virtue 
of making those for ever happy who touch it." Indeed I believe such a virtue 
was never before or since ascribed to the celebrated Blarney stone. The virtue 
I have always heard ascribed to it is, that whoever kisses it may allow himself 
to run into fiction as much as he pleases, (though Fielding would perhaps say 
that the term run into fiction would be better expressed by a monosyllable of 
three letters,) — no matter, whichever term is to be used, the virtue of the Blarney 
 


---

p.239



 
stone is, that after kissing it, how much soever the kisser may indulge in fiction 
he is certain of being believed; and if afterwards he should plunge into the 
**Shannon**, all may be done without danger of a blush.


To **Blarney** then we went. This was formerly a very strong castle, the seat 
of the Earls of Clancarty, but forfeited by them, with a great deal of other 
property, for their adherence to James the Second. It was afterwards purchased of the crown by **Sir James Jefferys**, in whose family it still remains, though the present possessor was at this time endeavouring to dispose of the 
estate. It is described in old writings as having been in **Queen Elizabeth**'s 
time one of the strongest fortresses in **Munster**, being composed of four large 
piles joined in one. Of the ancient building only one tower remains, a square 
of perhaps twenty or five-and-twenty feet. To this a modern building has been 
added as a dwelling-house; but the place has been entirely deserted for many 
years, and is falling miserably to decay; indeed, the more modern part seems 
very likely to fall before the ancient. Readers, beware! I did not find the 
Blarney stone by any means inaccessible, but perfectly easy of access. It is at 
the highest pinnacle of the old tower, with a very good winding stone staircase 
up to it. I ascended and kissed it; I have warned you of the consequence, 
and again I say, Readers, beware! In the house is a fine original whole-length picture of Charles the Twelfth King of Sweden, brought over by **James Jefferys, Esq.**, son to **Sir William Jefferys**, the purchaser of the estate, who was 
envoy at the court of Sweden. This extraordinary character appears exactly such 
as he is described by **Voltaire** in his most entertaining Life of him; the countenance full of fire, but extremely wild, truly characteristic of the man. Alas! 
this valuable picture is suffering with every thing else from damp and neglect.


No place has greater capabilities of being rendered one of the most enchanting spots in the world. Were the old castle fitted up, and it has walls of 
a thickness which Time itself would with difficulty destroy; between that and 
what has been added, an excellent house might be made; and such are the 
natural advantages of the grounds, that very little would be wanting to render 
them truly beautiful. There have been delightful shrubberies, which might 
easily be restored. The castle stands on a rock, not very high, and below are 
fine meadows, with an ample stream flowing through them: there is plenty of 
wood, and a considerable lake at a short distance from the house, which furnishes 


---

p.240



 
excellent trout: — in short, Nature has left little for Art to supply; and 
yet this charming spot is deserted, abandoned, looking wholly neglected and 
forlorn. Though I kissed the Blarney stone, I am not here exaggerating. The 
country beyond the immediate precincts of the castle is not very good; the 
slopes are pretty, but they are destitute of the greatest ornament to them, — wood. 
This place lies to the north-west of **Cork**.


The ground on the south side of the **Lee** is not so high as on the north side, 
but abounds alike with beautiful villas. Between two and three miles to the 
east, along this side, is **Black-Rock**, a point running down into the river, whence 
there is a very good view of the city. The rock is not lofty. A strong castle 
or fort was built here by the Lord Mountjoy in the reign of James the First, 
for the defence of the city: at present, the harbour being so fortified as to preclude any necessity of fortifications up the river, this is only used as a place of entertainment for parties. The mayor of **Cork** is by his office admiral of the 
harbour, and his courts of admiralty are held here; for which purpose, about 
seventy or eighty years ago, the sum of three hundred pounds was expended by 
the city in repairing the tower and making a handsome room for his use. On 
the first of August a grand entertainment is given at the **Black-Rock** by the city 
to the whole corporation. At a very pretty villa near this spot live **Lady Chatterton** and her daughters: she is the widow of **Sir William Chatterton**, a name much distinguished in his profession, the law. With this lady I had the pleasure of becoming acquainted by meeting her at **Mr. Kean**'s house, and from her I 
received, in conjunction with Mr. and Mrs. Kean, great civilities: she is indeed 
a most pleasing amiable woman, truly a gentlewoman, and has three charming 
daughters, one married and two single. Her house stands very pleasantly, looking directly over the river to the **Small island** as it is called, formed by the river in going down to the harbour. In short, I have seldom in the space of ten days, 
which was the time I stayed at **Cork**, seen a greater variety of pleasant society.


One of these days was spent in a visit to the harbour, in which I accompanied 
Mr. and Mrs. Kean. We went by land to **Monkstown** upon the inner part of 
the harbour, where is a fine old castle standing at the summit of a wooded height 
above the village of **Monkstown**; — that lies directly upon the shore. Mr. and Mrs. Hewett, to whose house we went, had procured for the day a very nice 
schooner belonging to a gentleman at **Monkstown**, in which we had a delightful 


---

p.241



 
sail all over the harbour. It is indeed a most noble one, capable of stowing the 
whole British navy, large as it is. The entrance is narrow, not a mile over, 
lying between **Spike Island** and a point of the main, but beyond this narrow 
entrance a most magnificent basin soon expands itself.


From the mouth of the harbour till past the city of **Cork**, a distance of full 
twelve miles, there is a continuity of islands. **Spike Island**, at the entrance of 
the harbour, is a rock of considerable extent, which has for a long time been 
fortified, but where immense additional works are now carrying on; some of them 
I could not help conceiving to be works of supererogation. A little town almost 
is made at the top of the rock; there are barracks for soldiers and officers, batteries mounted with cannon, vast magazines for military stores, immense reservoirs for water, &c. &c, and all inclosed within a deep ditch excavated in the 
solid rock; but lest the rock should happen to fall, a wall of very strong masonry is built up against it. This really does seem Irish, quite a work of supererogation for an Irish Catholic. Near this island is another, **Hawlbowlin**, 
which assists in breaking any force of winds and waves at the entrance of the 
harbour; and a little further to the west a third very small island or mere rock 
called **Rocky Island**. North of the harbour is a very considerable island five 
miles over, on which stands the town of **Cove**, running picturesquely along the 
declivity of the heights that rise directly from the water. This was formerly a 
poor little fishing-village; but since the great resort which the late wars have 
occasioned to **Cork harbour**, it has grown into a considerable town. The island 
is extremely fertile and well cultivated. It formerly went by the name of **Barrymore's Island**, from being the property of the Barrymore family. It is now 
called the **Great Island**, or **Cove** Island, but more commonly by the former 
name. It is not accessible by land from the western side, there is a ferry to it 
at a place called **Passage**; on the east side, where the channel is much narrower, there is a bridge. Further on is the **Small Island**; and some way further 
still, the island on which stands the city of **Cork**.


At the east end of the harbour, directly at the edge of it, is **Rostellan** the seat 
of the Marquis of Thomond: we sailed very near it. A conspicuous object in 
the grounds is a little temple in the Grecian style, dedicated to Mrs. Siddons. 
It will be remembered that the late Marquis of Thomond, then Earl of 
Inchiquin, married Miss Palmer, niece to **Sir Joshua Reynolds**, and that the 
 


---

p.242



 
uncle and niece were both among the very great admirers of that great actress. 
The Marchioness seems to have inspired her Lord with all her own enthusiasm. 
There are several other noblemen's and gentlemen's seats round the harbour. 
At the south-west comer is a small creek called **Crosshaven**, with good anchorage 
for vessels; it runs behind a hill, which prevents its course being seen from the 
harbour. In the year 1589, **Sir Francis Drake** with five ships of war was 
chased by a very superior Spanish force, when he ran into **Cork harbour**, and 
took refuge in **Crosshaven** creek. The Spaniards sailed up the harbour as far as 
the vessels could go, but to the admiral's great astonishment nothing was to be 
seen of the ships which he had just chased in, and he went away utterly at a 
loss to account for a circumstance so extraordinary. At the head of the creek stood the castle of **Carigoline**, which in ****Queen Elizabeth****'s time was considered 
as impregnable; it is now entirely demolished.


The whole of this day was passed most pleasantly. We had a large company on board; **Mr. Kean** delighted the present audience with his singing, 
scarcely less than he had repeatedly charmed audiences with his acting. Major Hunter, a Scotch officer in garrison at **Cork**, amused us rather at the expense 
of his own countrymen, by many stories of them, and by acting the part of Sir 
Archy McSarcasm, which he did incomparably; he had not unfrequently been 
upon the stage as an amateur performer. We had besides several other very 
pleasant men of the party. The ladies were only Mrs. Kean, Miss Hewet, 
and myself.


The ships of war moor immediately before the town of **Cove**, where is deep 
water at a very little distance from the shore. From the shoaly nature of the 
river no vessels of any considerable size can get up to **Cork**, they unload at 
**Passage**, whence the cargoes are conveyed by small craft to the city. Lately a 
steam-boat has been set up which goes daily from **Cork** to **Cove**, and is found 
to answer extremely well. A scheme was at this time in agitation to work the 
packets which sail regularly between this place and **Bristol** by steam; but I have 
been told by those who have made the experiment, that though the steam-vessels answer very well upon the smooth surface of a river, they are extremely disagreeable upon the rough ocean.


The whole of this region appears to be limestone; the rocks on the north 
side of the river are so; they abound with small particles of iron, and where 


---

p.243



 
the iron is much oxydated a dull red hue is imparted to the stone. **Spike Island** 
is a gray limestone intermingled profusely with opake white crystallizations of 
carbonate of lime. **Rocky Island** is a limestone mass, very much variegated 
with different shades of brown and yellow, according to the greater or less quantity of iron which it contains. The veins of crystalline matter occasionally exhibit 
an efflorescent character. Gems are sometimes found, but the occasions are 
not frequent. I saw in the possession of **Lady Chatterton** an amethyst set as 
a brooch, picked up very near the **Black-Rock** eight years before; nothing 
equal to it had been found since. It was scarcely to be distinguished from a 
foreign gem. But pebbles from the sea-shore may easily lead an inexperienced 
person astray; they are often quite foreign to the parts where they are found. 
I have one somewhat of the nature of blood-stone, picked up on the beach at 
**Cromer** in **Norfolk**; so different from any of the productions of that country, 
that it must have been brought by the waves from some very remote quarter. 
I found no organic remains in any of the rocks I examined hereabouts, nor could 
I learn that they ever exhibit any. **Dr. Smith**, in his History of Cork, says 
that there are marbles at **Middleton**, which is at the north-eastern point of a bay 
running up to the north-east of the great harbour. The county of **Cork** is the 
largest in **Ireland**.


The city of **Cork** has to boast of having been the birth-place of a very extraordinary genius and most eccentric character, the late **Barry** the painter; a man 
of whom it is eternally to be regretted that he suffered notions of independence 
pushed beyond what is compatible with the situation of man in this world, and 
a too tenacious adherence to certain eccentricities, to throw a cloud over genius 
destined, if it had been properly tempered, to carry his art far very far beyond 
what it was ever carried in this country. With this extraordinary man I had 
the pleasure of being much acquainted during the latter years of his life, and I 
can truly say that I never was in his company without retiring from it not less 
instructed than entertained. Never was mind more richly stored, never had 
tongue greater powers of eloquence in pouring forth his knowledge. The series 
of pictures painted by him for the Chamber of Arts, Commerce and Manufactures, in the Adelphi, will live for ages a lasting memorial of his genius to those who see them; — it is much to be regretted that they are not in a more public 
situation, where they would be more seen and their excellence consequently 
 


---

p.244



 
more justly appreciated. Inshrined in a place scarcely ever visited but by the 
members of the Society, their existence is little known to the public at large. If 
many objections may be made to them, and no one can deny that there is much 
room for objection, the defects are amply compensated by the genius they display. The Olympic Games in particular shows a grandeur of conception which 
could only be the result of real greatness of mind. But **Barry** was impetuous 
in his temper, impatient of opposition, and indignant when he found others not 
carrying their ideas of the sublime nature of his art to an equal degree of elevation with his own. Hence arose the unfortunate differences with his brethren of the Academy which clouded his latter days. Could he but have bent 
a little to circumstances, not bowed so low as to degrade his talents, how much 
higher in public estimation would the productions of those talents have risen! 
for, with the public, the estimation of a man's talents will always depend to a certain degree upon the general suavity and urbanity of his manners. All cannot 
persuade themselves to take genius such as it is with the eccentricities usually 
attendant upon it; if it cannot conform partially with the ordinary usages of society, it is too much in danger of being ultimately neglected by society. It were 
perhaps to be wished that this were otherwise; but thus it ever has been, thus it 
probably ever will be.


In the Life and Works of Barry, published after his death, is a letter from 
**Mr. Burke** to him while he was in **Italy**, on the subject of regulating his temper. 
It is as fine a piece of writing as ever flowed from his pen, full of the most 
sound sense and excellent advice. Happy had it been, could the writer have 
applied his forcible precepts to himself, and set the example of what he so ably recommended.




---

p.245


Doubts about the Route on leaving **Cork**. — **Googanebarra**. — Visit to it abandoned. — **Inishonan**. — Valley from thence to **Bandon**. — Town of **Bandon**. — 
**Castle Bernard**. — **Cloghnikelty**. — Irish Funeral. — Sluggish Horse and talkative Driver. — **Ross-Carbery**. — Adventures there. — Talkative Girl at the 
Inn. — Offerings to Bacchus, and their Effects. — St. *Fachnan*. — **Dean Swift** 's Verses on this Coast. — Parish of **Miros**ash; Rocks, Arch, and Caves. — **Glandore Bay**.
#### 23


When I was to leave **Cork**, the question was, which route among numerous 
ones offered to my choice I should pursue. My two great objects were now 
to see **Glengariff** the seat of **Captain White**, brother to **Lord Bantry**, upon 
**Bantry-Bay**, and to visit the Lakes of **Killarney**. Several people at **Cork** had 
talked to me of the lake of **Googanebarra**, the head of the river **Lee**, as a place 
extremely worth seeing, a romantic solitude in the midst of wild mountains; 
earnestly recommending my taking it in the way to **Killarney**, which might 
be done with little deviation from the direct road. I revolved this very much 
in my mind; — the description of the place awakened my curiosity, and I 
began to make more minute inquiries about both that and the access to it. In 
the course of these inquiries I was extremely perplexed, as I had often been 
before, with the contradictory accounts I heard: — of one thing only I could 
fully assure myself, that though talked of by every body, it had scarcely been 
seen by any body. Still further, I found that it lay wide of any high-road, or 
of any town or village where an inn was to be found. At length applying to 
**Dr. Willes**, he said he had never been there himself, but he showed me a painting of the spot done by a brother of his now resident in **London**, which he said 
would give me an idea of what was to be seen. It was indeed the representation of a fine, wild, romantic spot; a lake inclosed by lofty mountains, with 
a woody island in the midst, on which is a hermitage where St. Finbar for 
many years lived a recluse. It is now the not unfrequent resort of devotees, 
from an idea of its sanctity. As to the access to it, **Dr. Willes** told me that 
 


---

p.246



 
from his brother's report he conceived it to be very bad indeed; that no carriage, or even horse, could get nearer than within two miles, from whence the 
walk was over the sides of boggy mountains. This account settled my determination: I had had some experience of walking over boggy mountains, in 
going up **Knock-Laid**; and content with that, I was not very much inclined 
to repeat the walk. Climbing hard rocks, where the footing is firm, is an easy task in comparison with wading over bog; my courage was not equal to the 
undertaking, and I abandoned the idea of visiting **Googanebarra**. 
What route then should I take? — Should I go first to **Killarney**, and thence 
to **Bantry-Bay**, or vice versa? At length I resolved upon going by **Ross-Carbery** and **Skibbereen** to **Bantry** and **Glengariff**, and afterwards to **Killarney**. Accordingly, I departed from **Cork** on the sixth of September, early in the 
morning, intending to get that night to **Skibbereen**. I stopped to breakfast at 
**Inishonan** on the **Bandon** river. This was formerly a walled town of considerable note, but is now reduced to a village, having, however, several very 
pretty houses. An extensive linen manufactory is carried on here, and there 
are large bleach-grounds by the river-side. Above the river and meadows is 
a fine wood, on the declivity of a steep slope, through which are cut many 
pretty walks. It belongs to **Mr. Travers**. Soon after quitting the village is 
a remarkably pretty view, looking back to it along the dell in which it stands. 
In the foreground is a very good bridge over the river, beyond which are the 
steep wooded slopes; and in the back the village church, with a handsome 
tower rising above the trees. The road continues along the dell, by the riverside, winding with the dell and river, all the way to **Bandon**, three miles. In 
one spot is a venerable ruin of an old castle at the edge of the river, with 
a bridge close by, forming an extremely good picture.


**Bandon** is a large town, consisting of a very long street running through it, 
but scarcely containing one tolerable house. The **first Earl of Cork** was the 
great founder of this town: it appears at that time to have been walled, and 
a place of considerable strength, since he writes thus of it to Secretary Cook in 
the year 1632: "Upon conference with the commissioners, I have been desirous to satisfy myself whether the works done by the Londoners at **Derry**, or 
mine at **Bandon-Bridge**, exceed each other. All that are judicial, and have 
carefully viewed them both, and compared every part of them together, do 


---

p.247



 
confidently assert, that the circuit of my new town of **Bandon-Bridge** is more 
in compass than that of **Londonderry**; that my walls are stronger, thicker, and 
higher than theirs, only they have a strong rampier within, which **Bandon-Bridge** wanteth; that there is no comparison between their forts and mine, there 
being in my town three, each containing twenty-six rooms, the castles with 
the turrets and flankers being all platformed with lead and prepared with *ordnance*, and the buildings of my town, both for the number of the houses and 
goodness of building, far beyond theirs. In my town there is built a strong 
bridge over the river, two large session-houses, two market-houses, with two 
fair churches; which churches are so filled every Sabbath day with neat, orderly, 
and religious people, as it would comfort any good heart to see the change, 
and behold such assemblies; no popish recusant or unconforming novelist 
being admitted to live in all the town. The place where **Bandon-Bridge** is situated is upon a great district of the country, and was within the last twenty-four years a mere waste bog and wood, serving for a retreat and harbour to 
wood-kernes, rebels, thieves, and wolves; and yet now, God be ever praised! 
is as civil a plantation as most in England, being for five miles round all in 
effect planted with English protestants. I write not this out of any vainglory; 
yet as I, who am but a single man, have erected such works, why 
should not the rich and magnificent city of **London** rather exceed than fall 
short of such performances?"


Assuredly there is no appearance remaining of a place of so much consideration, excepting the bridge. For a long succession of years not a Catholic 
was suffered to live in this town, nor were the bagpipes allowed to be played 
in it, that having been the music in use among the rebels of those times. 
About a quarter of a mile westward of the town is **Castle Bernard**, originally 
the residence of the O'Mahony family, and called **Castle Mahony**. From 
them it passed into the family of Bernard, since created barons of **Bandon**. 
By them a new house was built in the year 1715. The park is spacious. Between this place and **Cloghnikelty** there are some very good points of view.


**Cloghnikelty**, twenty-two miles from **Cork**, is a small town standing at the 
head of a little bay of the same name. This bay is, however, so choked with 
sand and mud, that it affords no advantages of navigation to the town. On 
the shore of the bay, near the sea, was once a castle called **Arundel-castle**. 


---

p.248



 
The town is built in the form of a cross, and has a good church standing on a 
rising ground, but it is altogether a dirty poor-looking place. It was a flourishing and commercial town, carrying on a great linen-trade before the civil-wars of 1641, but during that period was burnt down, and has never recovered 
the catastrophe. As I was sauntering about here while the horse was taking 
his refreshment, I heard a very strange noise, which I did not understand, and 
saw a great concourse of people coming along the road towards where I was. 
I could not imagine what this meant; and inquiring, I was told that it was a 
funeral. I had often heard of the noise, the sort of yell used by the poorer 
sort of Catholics on these occasions, but had never till now heard it. Indeed 
it is impossible, without hearing it, to form an idea of any thing so dreadfully 
discordant. It is to be presumed that, intended by those who utter it as an 
expression of grief, it is considered by them as extremely plaintive and affecting; 
but to ears unseasoned to it, nothing could appear less so. The coffin was laid 
upon one of the common Irish cars, drawn by one horse, and around was a 
prodigious concourse of people, more women then men, and they seemed very 
much to out-vociferate the men; they were all in long blue cloth cloaks. As 
the funeral proceeds on its way, it is commonly joined by still increasing numbers, and in going through a town or village the noise is redoubled, so that I, 
being in a town, heard it to perfection. I could not perceive any sign of tears, 
or the least symptom of real grief upon the countenance of any person attending.


I found from my first setting out in the morning that my horse, which I had 
hired at **Cork**, was not at all of a high-mettled breed; in truth, I never saw a 
more sluggish animal. The driver was a true specimen of his country; he 
had something to say to every body we met, but being commonly in Irish, I 
could not understand his witticisms: when he had nobody else to speak to, he 
addressed his horse with an incessant exhortation of "Come along, my man!" 
but his exhortations were vain; it was impossible to inspire the animal with any 
greater celerity of motion. Indeed, he appeared so wearied by the time we 
got to **Cloghnikelty**, that if I had seen any thing like a tolerable appearing inn, 
I should have stopped there for the night; but the houses of entertainment 
for travellers, carried with them so little appearance of affording even tolerable comfort, that I determined to go on to **Ross**, six miles further, which I knew to be a city and a bishop's see, and concluded must therefore afford something better.




---

p.249


#### 23


To **Ross** then we proceeded, though I was more than once in doubt whether 
our miserable animal would have got on so far. The approach to this town 
is extremely pretty; the whole coast is broken into innumerable little bays, 
and upon a slope above one of them stands the town with its very very small 
cathedral, looking like a little village church, the spire rising prettily above all 
the surrounding objects. Ross Bay, like the bay of **Cloghnikelty**, is extremely 
choked with sand and mud, so that a causeway has been raised across it, not 
far from the head, leaving only a channel for the water to come up, over 
which there is a bridge; at low water the whole is a muddy strand. Along this 
causeway the town is approached. When we entered the city, and inquired for 
the best inn, our attention was directed to a miserable-looking place, at the 
distance of only a few doors from us, looking many degrees worse than those I 
had despised at **Cloghnikelty**; indeed, it made me think most truly, that it is 
commonly far better 
  
 
" — to bear the ills we have, 
  
 
Than fly to others that we know not of." 
  
 
But there was no remedy; here we must stay for the night: and alighting 
from my car, I walked into the inn. A parlour I quickly saw was a thing entirely out of the question: but I asked whether I could have a bed. The 
landlady hesitated; and at length said, she was afraid none that I should like, 
their best bed-chamber was engaged for the night, and the other was but a 
sorry one; if I would like, however, she would show it to me. There was 
nothing left but to take such as I could get, and I desired to see it: truly it 
was a sorry one; but the landlady began to lay her plans how it could be rendered a little decent and comfortable, when up came the landlord. He said, 
that he thought the lady might have the best bed-chamber, for the gentleman 
who had it the night before, only said when he went away, that he might, perhaps, want it again, and he did not therefore think they were bound to keep it for him; to be sure he had left his portmanteau, as if he thought of coming, 
but then he could never be angry at being put into another room to accommodate a lady. To all this the landlady assented; and it was agreed between 
them that I might be shown to this chamber. Thither then I went; and 
found it much cleaner and more comfortable than the general physiognomy of 
the house and the wretchedness of the staircase up to it gave reason to expect.




---

p.250


#### 23


I took possession, rejoiced at this amendment in my prospect for the night, 
consoling myself with the idea that in case of the other claimant to the room 
making his appearance, possession was nine points of the law. I ordered tea 
and eggs, my usual meal at the end of a day's journey, which were served 
very neatly, with excellent bread and butter, the daughter of the house, a girl 
about twelve years of age, officiating as waiter. When she had arranged every 
thing in nice order, I perceived that she still lingered in the room as if more 
disposed to stay than to retire, and I said that she need not wait. Oh, she 
said, she must stop and fill the teapot, that would be too much trouble for 
me; and drawing nearer she sat herself down on the edge of the bed, and entered into conversation. She supposed I had come along the new road made 
over the strand. I answered that I had. — Wasn't it a very curious thing? 'Twas 
quite admired by every body in the neighbourhood; a great deal more quality 
came that way than used to do; and she supposed there was going to be quite a 
great inn set up just at the end of the road, such as the quality would like to stop 
at. I always found that among the lower classes of the Irish all gentry were 
quality. At this time a number of new roads were made, or in making, over 
various parts of the country, which had been previously very ill provided in this 
respect, and they were the great subject of conversation and admiration with 
every body. My companion was so extremely full of them that *she was* not able 
to refrain from talking upon the favourite theme, and was brim full with visions 
of the extraordinary effects that were to be produced by them. I had been told of 
two remarkable cavities in the rocks upon the sea-shore here, and I next asked 
her about them. Her eloquence had now a new direction, and she poured out a 
number of wonderful stories concerning these caves. They resemble the craters of 
volcanos, but have a communication with the sea below at the foot of the rocks, 
which dashes in with a great noise, while the sound is finely reverberated by the 
echo of the deep cavern. In calm weather a boat may row into them, and 
parties of pleasure are sometimes made for the purpose; but I should conceive 
it always rather a dangerous experiment. A great deal of quality, my lassie 
said, came to see them, but for her part she wondered at them very much. 
Why now, once there was a poor girl fell into one, and though a boat was sent 
in directly to search for her, she was never to be found; people had very odd thoughts about it. — "What do they think?" I inquired. "Why it was very odd 


---

p.251



 
that not a bit of her should ever be found, something must have had her." — 
I could not, however, make out what that something was supposed to be. Any 
where else I should have had no doubt who, or what, the suspected something 
was; in **Ireland**, far from being the parent of sin, it might not improbably be a saint.


Ten o'clock having arrived without hearing any thing of the apprehended 
claimant to the room, I thought myself perfectly secure, and went quietly to 
bed. And here I must observe, that wherever I went in **Ireland**, let the appearance of the inn be ever so poor, there were always nice sheets to the bed, perfectly 
clean and white; so it was here: indeed I must say that my accommodations 
were in every way superior to what could be expected from the first appearance of the house. About twelve o'clock I was awakened first by a violent noise 
below, which gradually ascended the staircase, and then by a lump against the 
chamber door, which I was a little apprehensive must have broken it open; but 
immediately I heard half a dozen voices endeavouring to soothe and pacify the 
invader; some, as I found from what passed, having got hold of him to prevent 
any further manual attacks. It was the gentleman returned; and having been taking 
in potations pottle deep, instead of being inspired with the excess of gallantry, so 
often consequent upon such sacrifices to Bacchus, the very reverse was the case in 
the present instance, since I more than once heard, "I don't care for the lady — 
I will have my room." At length, however, partly by soothing, but rather more I 
believe by main force, he was carried away, and I heard no more of him; only the 
landlady came in the morning with a great many apologies for the disturbance.


The name of a city and cathedral conveys the idea of a place of some consequence; but **Ross**, or **Ross-Carbery**, which is the proper name, though the latter part is commonly sunk, is scarcely more than a village: it stands on a considerable height, directly above the bay, and the new road is carried at its foot, not going through the town. Here were two or three good-looking new houses, 
and here was to be the projected inn. If there is traffic enough to support the 
road and inn, the latter will be a great acquisition to the country. In ancient 
times this town was called **Ross-Alithri**, the Field of Pilgrimage, and was of 
much more importance than at present; it is even said in some of the old chronicles that here was an university, to which all the youth in the south-west part of **Ireland** were sent for education; nay that many even came from England. 


---

p.252



 
The cathedral was founded by Saint Fachnan, a saint held to this day in great 
reverence among the Catholics of the neighbourhood; they celebrate his festival 
on the sixteenth of August with prodigious ceremony. He used to pray daily 
on the side of a hill a little way out of the town, and one day forgetting to 
bring his prayer-book away with him, it remained there all night. In the night 
a great quantity of rain fell, but the book was preserved from injury by angels, 
who built a chapel over it. The same saint is reputed to have founded an abbey at Ross; but if there ever was one, no vestiges of it remain. This see was united to that of **Cork** in 1586.


The next morning I visited the caves or holes, which are really tremendous. 
They are a hundred-and-eighty feet deep, and lie three hundred yards from 
the cliffs, communicating with the sea by cavities under the cliffs. They are 
called East and West Pouladuff. Who can see this coast broken into numberless little bays and promontories, contemplate the vast caves and overhanging cliffs, and listen to the roar of the waters reverberated by the mighty echoes, — who, witnessing these things, and being at the same time acquainted with **Dean Swift**'s beautiful lines, Carberia Rupes in Comitatu Corgagensi apud Hybernicos, can avoid immediately recurring to them? They are so finely descriptive of the scenery, that I trust I shall be excused citing them at length, in the much 
approved translation of **Mr. Dunkin**. 

> 1. Lo! from the top of yonder Cliff that shrouds
>   
> Its airy head amidst the azure clouds
>   
> Hangs a huge fragment; destitute of props
>   
> Prone on the wave the rocky Ruin drops. — 
>   
> With hoarse rebuff the swelling seas rebound,
>   
> From Shore to Shore the Rocks return the sound:
>   
> The dreadful murmur Heaven's high Concave cleaves,
>   
> And Neptune shrinks beneath his subject waves;
>   
> For long the whirling winds and beating tides
>   
> Had scoop'd a vault into its nether sides.
>   
> Now yields the Base, the Summit nods, now urge
>   
> Their headlong course, and lash the sounding surge,
>   
> Not louder noise could shake the guilty world
>   
> When Jove heap'd mountains upon mountains hurl'd
> 
> 
> ---
> 
> p.253
> 
> 
> Retorting Pelion from his dread abode,
>   
> To crush Earth's rebel Sons beneath the load.
>   
> Oft too with hideous yawn the Cavern wide
>   
> Presents an Orifice on either side,
>   
> A dismal Orifice from Sea to Sea
>   
> Extended, pervious to the God of Day:
>   
> Uncouthly join'd, the rocks stupendous form
>   
> An Arch, the victim of some future storm,
>   
> While on the Cliff their nests the Woodquests make
>   
> And Sea-Calves stable in the oozy lake.
>   
> But when bleak Winter with his sullen train
>   
> Awakes the winds to vex the watery plain,
>   
> When o'er the craggy steep without controul,
>   
> Big with the blast, the raging billows roll;
>   
> Not Towns beleaguer'd, not the flaming brand
>   
> Darted from heaven by Jove's avenging hand,
>   
> When oft on impious men his wrath he pours,
>   
> Humbles their Pride, and blasts their gilded Towers
>   
>  — Equal the tumult of this wild uproar,
>   
> Waves rush o'er waves, shore echoes back to shore.
>   
> The neighbouring race though wont to brave the shocks
>   
> Of angry seas, and run along the rocks,
>   
> Now pale with terror as the Ocean foams
>   
> Fly far and wide, nor trust their native homes.
>   
> The Goats, while pendent from the shaggy top
>   
> The wither'd herb improvident they crop,
>   
> Wash'd down the precipice with sudden sweep,
>   
> Leave their meek lives beneath th' unfathom'd deep;
>   
> Th' affrighted Fisher with desponding eyes
>   
> For safety trembling to the harbour flies,
>   
> And to behold the skies again serene
>   
> Wearies with vows the Monarch of the Main.
> 

 


These verses were written in June 1723, the whole of which summer was 
spent by the Dean with a clergyman in the parish of **Miros** in this neighbourhood, when he frequently amused himself with little aquatic excursions. The parish of **Miros** runs along the western side of another of these little inlets of 
the sea called **Glandore Bay**, somewhat to the west of **Ross Bay**. At **Miros** 
is a rocky arch, where he used to embark, and near the entrance of **Castlehaven Bay**, 


---

p.254



 
an inlet still more to the west, are several caves running from the sea under the rocks, into which boats can row; the caves are low at the entrance, but 
the arch is much more lofty in the interior; the swell of the sea within is so 
great as often to close up the arch at the entrance, thus leaving navigators who 
have ventured to trust themselves within, in profound darkness. It is obvious, 
therefore, that it is more adventurous than prudent in any one to penetrate into 
them, since the boat may be thrown up at the low entrance by a sudden swell 
and dashed against the top of the rock to the infinite hazard of every life in it. 
There are said to be numbers of seals, or sea-calves, all along this coast, which 
inhabit these rocks and caves very much.


From the caves I proceeded by the new-made road, indeed an excellent one, 
to **Skibbereen**. We passed along the head of **Glandore Bay**, which is really 
beautiful. It winds so much up from the sea that no outlet appears, so that it 
presents the idea of an inclosed lake. There are fine bold rocks in various parts, 
and directly at the head is some gentleman's seat, though I could never learn 
his name. The house stands almost at the water's edge with wooded slopes 
rising all round it; a little stream which runs into the bay skirts a part of the 
woods; over it is a most picturesque old bridge of one lofty arch, entirely overgrown with ivy. I can scarcely conceive altogether any thing more beautiful; 
it has much the character of the scenery about **Rostrevor** and the **Bay of Carlingford**. A little further on in the road to **Skibbereen** is an exceeding pretty group of five or six small lakes all together, with rocks not lofty, but very picturesquely disposed about them.




---

p.255


**Skibbereen**. — A new Addition to the Miseries of Human Life. — **Black-Rock**, 
the Seat of **Lord Bantry**. — **Whiddy's Island** in the Bay of **Bantry**. — The Town of 
**Bantry**. — **Bantry Bay**. — Great Fisheries. — The French Fleet. — 
**Glengariff**. — More friendly Advice. — Toilsome Route over the Mountains. 
 — **Kenmare Town**. — The **Kenmare River**. — Route from **Kenmare** to **Killarney**. — Valley 
of the **Kenmare River**. — **Glan-Flesk**. — Fila-Down. — Arrival at **Killarney**.
#### 25


**Skibbereen** stands upon the river **Ilen**, which about five miles from thence 
runs into **Baltimore Bay**; it was anciently called **Stapletown**, but what occasioned the change in its name, or when it took place, does not appear. It is a 
town of some extent, and from the number of new houses recently started up, 
appears to be increasing in prosperity; there are, however, whole streets, and 
not very short ones, consisting entirely of the wretched mud cabins of the peasants. The lands about produce a good deal of flax, and manufactories both of linen and woollen are carried on; but the principal objects of commerce in the 
town are corn, butter, and salted fish, of which considerable quantities are exported. The quantity of fish taken in **Baltimore Bay** is prodigious.


From our first setting out in the morning I found my horse very little the better 
for his night's stay at Ross; in short, it now appeared from the driver that he 
was not in the habit of going in a pleasure car, only in the common working 
cars, and was wholly unaccustomed to any other than the crawling foot-pace 
they go; but his master did not suppose I should make long days journeys, 
not above ten or twelve miles a day, so he thought he would answer my purpose 
very well. He should rather have said that he would answer his own purpose 
very well, for as I was to pay by the day for the use of him, he might think ten 
or twelve miles a sufficient day's journey. I thought quite otherwise; and having brought the man to this confession, I should have sent him back to **Cork** from **Skibbereen** could I have hired another: that I could not do, and I was obliged to take him on to **Bantry**, sixteen miles further. What a tedious sixteen 


---

p.256



 
miles did I find it! It occupied six hours; I sometimes doubted whether it 
would be possible to get him on to **Bantry** at all. There, however, we did at 
length arrive, just before dark. The former part of the road was indeed, to add 
to the torment of the thing, very bad, a rocky mountainous cross road; this 
continued for six miles; the remainder of the way was along one of the new-made roads, and an excellent one. In the next edition published of the *Miseries of Human Life*, I will beg the facetious author to enrol among his *Miseries* the being six hours going from **Skibbereen** to **Bantry**, with a tired horse 
scarcely able to set one foot before the other; — I found it a most superlative 
MISERY. The whole way is a continuation of mountain scenery presenting 
some good points of view, but in general rather barren and uninteresting. In 
one place is a very good waterfall, not lofty, but the water rushing in profusion 
down several different channels. About four miles from **Bantry**, from a pretty 
considerable eminence, is a very fine view of the spacious mouth of **Bantry Bay**, with the magnificent rocks by which it is formed.


About two miles from the town the road comes down to the edge of the bay, 
and continues to coast it; along an artificial causeway thrown up at the foot of 
the heights, quite up to the town. About half a mile from the town is **Black-Rock**, the seat of **Lord Bantry**. This is the third **Black-Rock** we have seen in 
different parts of **Ireland**; — near **Dublin**, near **Cork**, and at this place; — not 
one of them answering to the idea which the name seems to present, of dark 
shaggy towering masses. The nature of the rocks in **Dublin Bay** has been noticed; at **Cork** it is a pale limestone rock, at the utmost from twenty to thirty feet above the river; and here at **Bantry**, though a considerable slope, the whole is covered with green meadow and wood. One is at a loss to imagine what has 
given occasion to the name in any of the three places. **Lord Bantry**'s house 
stands upon the slope, not at a great height above the causeway, looking directly 
over a sort of basin which forms the upper part of the bay, being separated from 
the great bay by **Whiddy's Island** stretching nearly across, leaving only a small 
channel on each side; beyond are the fine bold rocks that skirt the bay. Nothing can exceed in grandeur and sublimity the scenery all round this vast inlet of the sea; rocks every where tower to a vast height above the water in a variety 
of forms, tracing a grand wavy outline as far as the eye can reach.


**Whiddy's** is a large island containing a thousand Irish acres. It is the property 


---

p.257



 
of **Lord Bantry**, and was formerly occupied by the deer-park, but is now 
let out into farms. On the island are two lakes very near each other, the one 
of fresh the other of salt water. The soil affords great variety for so small a 
space, exhibiting bog, rocks, sand, and stiff clay. The parts cultivated are remarkable for their fertility; the sheep fed here grow to a great size and become extremely fat, though the sheep of the country in general are very small. There are several smaller islands scattered about, on which is some pasture ground, reckoned very salutary for the recovery of diseased horses, particularly 
for restoring such as have fallen away from too much work. My driver would 
have done well to have left his miserable animal on one of these islands; 
though indeed he did not look lean as if he was starved; his malady was, I 
believe, innate sluggishness of nature — that he had no idea horses were ever 
expected to move faster.


The town of **Bantry**, which stands almost at the head of the bay, is not 
large, but has one good street, with a very comfortable inn. Its ancient 
name was **Ballygobbin**; it was also for a while called the Old Town, another settlement having been made to the north of it, where, in the time of 
**Oliver Cromwell**, **Ireton** had fortifications erected: many people in consequence emigrated from the old to the new establishment. But afterwards, when 
the country was restored to tranquillity, these fortifications were neglected and 
suffered to fall into decay, and the Old Town was found to be more eligibly 
situated from its immediate vicinity to the bay, so that the New Town in its 
turn was deserted, and the old one has ever since flourished under its present 
name. Near it once stood a Franciscan abbey, founded in the fifteenth century by the O'Sullivans, a sept of great distinction in the country, but no trace of it now remains.


The bay is twenty-six miles in length, and in some places nine miles over; 
it is esteemed the finest bay in all **Ireland**; the depth of water in the midst 
is forty fathoms. About fifty or sixty years back the town of **Bantry** carried 
on a great trade in salted herrings and pilchards, from the immense quantities 
taken in the bay; they were principally exported to **Spain**, **Portugal**, and **Italy**. It is a remarkable thing that in these hot countries, where the climate naturally 
produces a great propensity to thirst, the inhabitants seem particularly fond of 
strong thirst-creating kinds of food, such as the salted and dried herrings of our 
 


---

p.258



 
country, the cod of **Newfoundland**, and the anchovies and sardines of their own 
seas; not to mention their caviare, and potargo or poutargue, two of the very 
strongest species of food that can be imagined. We might also instance the 
excessive love of garlick and of high-spiced dishes in hot countries; one should 
have supposed these kinds of food more suited to cold northern climates, and 
such as are of a milder nature to southern latitudes. So great was the fishery 
formerly in **Bantry Bay**, that in the year 1749 a **Mr. Mead** obtained a premium from the **Dublin Society** for having caught and cured within the year 
880,000 fish, reckoning six score to the hundred. Another person, about the 
same period, cured in one year 482,500 herrings and pilchards, and two hundred and thirty-four barrels of sprats. This immense swarm of fish ceased 
soon after; and for many years the numerous stages erected round the bay for 
curing them have been neglected and useless. The bay still yields fish in plenty 
of various kinds, but not in this extraordinary profusion. The O'Sullivans of 
old had a vast property here, and several houses, or palaces as they were called; 
one at a place called **Rinedizart** was demolished by a ship of war in **Cromwell**'s 
time. A very remarkable account is given in **Mr. Weld**'s Killarney of the 
lineal descendant of one branch of this family, who now lives a humble cottager in the mountainous regions of these parts, yet has preserved the pedigree 
of his family, which proves his descent indisputably. Three small rivers run 
into the bay, and at Hungry-hill, the highest point among the rocks that surround it, seven hundred yards above the water, is a cascade, sometimes pouring 
profusely from a vast height down the mountain side, at other times quite dry.


It is needless to remark how much this bay became the subject of public 
notice and eager attention in the year 1796, when a French fleet was for some 
time moored there. I must however observe upon the extreme inaccuracy with 
which this circumstance is mentioned in The Traveller's Guide. It says that 
the fleet was fitted out by the Consulate at the solicitation of the **United Irishmen**. Now at that time the Consulate was not established in **France**, the executive government was in the Directory. Again, it says that the fleet was dispersed in the **Bay of Bantry**; on the contrary, they had quitted the bay before their dispersion. Having waited there in vain for the arrival of the General, 
**Hoche**, who was to command the land forces, and who was to follow the fleet 
in a frigate, but owing to a storm was prevented joining them, they, after expecting 


---

p.259



 
him in vain as long as the admiral judged expedient, sailed off. It 
seems to have been a most ill-chosen spot for the success of their enterprise, 
since the immense rocks, which surround the bay every where, must have presented a natural obstacle, almost insurmountable, to a landing ever being effected. Since that time fortifications have been erected at different parts 
about the bay, particularly on some islands near the entrance; but the breadth 
of water is such that vessels might always, in sailing up, keep out of reach of 
the batteries; the difficulty of landing presents a much more powerful obstacle to invasion from this quarter than can be offered by any fortifications art 
could raise. There is no strand about the bay; the rocks rise in some places 
directly from the water, in others almost close to it.


The first thing to be done on arriving at **Bantry** was to institute an inquiry 
for a horse to proceed with the next day. One was at length procured; but the 
owner said it would be impossible to get from thence to **Killarney** in one day 
as I expected, since, from the mountainous nature of the country, an immense 
circuit must be made. It was determined then, after visiting **Glengariff**, to proceed to **Kenmare** town on the **Kenmare river**, from which place there would be 
an easy journey on the following day to **Killarney**; I might be there by twelve 
or one o'clock. He said that from **Glengariff** we must return full half way to 
get into the road to **Kenmare**, and we should then find it a bad mountain 
road.


In the morning we set off for **Glengariff**, going quite round the head of the 
bay, through a great deal of fine wild mountain scenery. In the bay are several little creeks or inlets; on one of them, where ten years ago was nothing 
but wild and desolate rocks, or bog, has **Captain White** formed almost a paradise. He has built a very pretty house in a spot delightfully sheltered by rocks 
from the north and east winds, open to the south, looking over the basin of 
the sea below. He has converted bogs into rich lawns and meadows, and 
clothed the naked rocks, which in their nudity presented the finest forms, with 
beautiful plantations, all looking extremely thriving and healthy. The house is 
not large, but an exceeding good gentleman's house, handsomely fitted up with 
mahogany doors, window-shutters, and window-frames to the principal rooms. 
The drawing-room opens into a pretty conservatory. **Mrs. White**, I was informed, has a fine collection of old china; but the family were at this time absent; 


---

p.260



 
and it could not be seen. Some handsome pieces were standing as ornaments to the rooms. There is a fine lawn before the house lying in beautiful 
inequalities, with a walk and shrubbery round it at the edge of the rocks 
bordering the sea. Among the shrubs are openings at intervals, to give a view 
of the water: about the more distant rocks are plantations, showing charming 
undulations of green, according to the forms of the rocks. The gardener, in 
walking about with me, pointed out a very fine piece of meadow-ground, which, 
he said, five years before was mere bog; it was now as rich pasture as could be 
seen. Hydrangeas were growing in the greatest luxuriance; but the flowers, 
no doubt from some peculiarity in the soil, had acquired the tint of the lilac, 
or perhaps a shade more inclining to the purple. Very fine myrtles were also 
planted in the grounds, having no other protection in the winter but being 
sheltered towards the north by the high rocks, and being fully exposed to the 
south sun.


The little bay on which this lovely place is formed, is in itself very pretty 
and picturesque, having fine rocks all round it, and an insulated rock not quite 
in the centre, though nearly so, on which is a temple. The gardener said he 
lived near this place when the French fleet was in the bay, and that some of 
the boats would not unfrequently come into the creek, sometimes fishing, sometimes appearing to be taking soundings. He pointed out the part in which the 
fleet was moored, which was nearly off the entrance to the creek. Probably 
here was one of the spots where a landing might have been attempted with 
greater prospect of success than in most. From the western end of this little 
bay runs up a valley for about three miles, which may truly be called the Valley 
of Rocks, though even in this rugged place **Captain White** has succeeded in 
raising a plantation for a considerable way. From all I learnt here and at 
**Bantry**, it appeared to me that **Lord Bantry** and **Captain White** are among 
those truly praiseworthy gentlemen who spend the greatest part of their time 
upon their estates, using every exertion to improve the agriculture of the country, and to excite the industry and promote the comfort of the inhabitants: — these are the people to whom **Ireland** must look up for a hope of its situation ever being rendered such as philanthropy would wish; 
they are the true patriots of the country. When I first began to inquire at **Bantry** about hiring a 
horse, the waiter of the inn said he hardly thought I should be able to get one, 


---

p.261



 
but he was sure, if I would only write a note to **Lord Bantry**, and say how I 
was situated, His Lordship would readily lend me one. To think of such an intrusion was entirely out of the question, but the waiter's idea spoke in very 
strong terms the character this nobleman must have in his neighbourhood for 
liberality and hospitality. Much of the general character a man bears may 
be collected from these trifling circumstances. **Dr. Smith**, in his History 
of **Cork**, written nearly seventy years ago, mentions great attention being paid 
at that time to agriculture, by **Richard White**, Esq. of **Bantry**, particularly the 
draining a bog and converting it into a fine meadow, affording double the quantity of hay that was mown off an equal portion of any other land. If he who makes two blades of 
corn grow where one only had grown before be a true benefactor to his country, he who from a dreary waste draws rich food for the 
cattle — to which man looks up for so much of his nourishment and so many of 
his comforts in life — is not less so.


After having walked about the grounds, returning towards the house I found 
my servant and the driver of the car in earnest conversation with three gentlemen. As I approached, my servant came up to me, and said that those gentlemen had been very much recommending our not going back along the road we had come, and from thence taking the usual road to **Kenmare** town; they 
said it would be much better to pursue our course along the valley, and then 
going over the mountains that close it, we should come into a very good road 
all the way to **Kenmare**. It was, they said, a much shorter route, and we should 
miss an ugly place in the other road called **The Priest's Leap**; they had just 
come from **Kenmare** in a jingle along this road, and could assure me it was 
very safe and good, in one place excepted, where it was rather steep and rocky 
for a few yards; there it would be necessary to have a couple of men to push 
the car up behind, but we should go through a little village just before, and 
could easily get men from thence.


All this sounded so very plausible that I readily listened to it. I inquired, 
however, whether the way was difficult to be found? No, it was such a marked 
track, though not a regular made road, that it was impossible to miss it; indeed, when once over the mountain we must follow the course of the valleys 
into which we should descend. I had heard of **The Priest's Leap**, the driver 


---

p.262



 
talked of it as an ugly place, and seemed very desirous of following the proposed route to miss it: besides, hearing all this from people who had the instant before come this way, in a jingle too, a four-wheeled carriage, much more 
heavy, awkward, and unsuited to bad roads than my car, there seemed no good 
reason for hesitation, and with thanks to the gentlemen for their advice I determined to follow it.


Ascending the car, then, we pursued our course along the valley very prosperously for some way through **Captain White**'s fine plantations, till at length 
we came to complete wild and rocky scenery. The driver expressed much 
satisfaction at missing **The Priest's Leap**, and seemed to think there was great 
reason to felicitate ourselves upon the encounter with the gentlemen. However, as we advanced among the wild rocks, the road at every minute grew worse and worse; and I began to suspect that good roads meant one thing in 
the dictionary of the Kerry mountains, and another in the dictionaries in more 
general use. At length we came to the village talked of. Only one man was 
to be procured to help the car up the steep place, but he said some of the 
boys would do as well as another man; and in an instant we were surrounded 
by some half score ragged urchins, who among them all had scarcely so much 
clothing as would make one efficient suit. We pursued our way; but the further 
we got, the worse did we find this good road. I descended from my car, 
and walked on before; the driver descended and led the horse; my servant 
descended and helped, in conjunction with the man and boys, to push the car 
behind; not at one place only, but every ten or twenty yards: and all this 
time we were still in the valley, we were not yet come to the proper ascent of 
the mountain. The driver for a while seemed still happy at avoiding **The 
Priest's Leap**, and cracked his jokes with great volubility upon the road, and 
the vast broken masses of rock with which the valley was scattered over, encouraging the boys to exert their strength in pushing, or occasionally in holding 
back the car, for there were steep places to descend no less than to ascend. 
In one place was an immense block of stone standing up perpendicularly, probably thirty feet in length, by ten in breadth and height, a cubical parallelogram, almost as regularly formed as if it had been hewn: — "Arrah, by Jasus!" he exclaimed, "if that fellow isn't as fine a mountaineer as ever a man set his 


---

p.263



 
two good-looking eyes upon." The chief of his conversation was, however, carried on in Irish; but it was all probably tinctured with the quaintness of the 
country, since it excited many a hearty laugh among his companions.


At length, after toiling on and on without any amendment of the ways, 
having a terrible steep before us which must be ascended, his spirit began somewhat to be shaken, he became more grave and silent, only now and then wondering how their honours ever could recommend such a road. Indeed I was 
impressed with the same wonder; I should have thought their having come 
over it was a reason rather to warn us against it, than to advise us to follow it. 
To go back was, however, now as bad or worse than to go forward; and the 
man who accompanied us from the village, assured us that when we got to the 
other side of the mountain we should find the road really good, only the descent 
somewhat steep. In the height of his despair the poor driver was at last driven 
to say, "We had much better have gone by **The Priest's Leap** — by 
Jasus 'tis n't above half as bad as this." Till now, that seemed to have been in his idea the 
ultimatum of every thing that was to be deprecated. At length after immense 
toil the summit of the mountain was reached, when indeed a better *prospect* did present itself; it was no longer a scene of shaggy broken rocks like what we had passed over, but a level surface covered with a green turf; the descent was, 
however, at first so steep that I would not remount the car, but waited till we 
got to a more gradual declivity, when I had walked at least five miles. How a 
jingle ever could get along such a road I cannot to this moment comprehend; nor 
how three men could impose the task upon one poor horse to draw them over 
it; or, if they had no humanity towards the horse, how they could endure the 
jolting of the carriage over the blocks of stone which were very often not to be 
avoided.


I had collected some specimens of the rock masses immediately about **Glengariff**, I collected some other pieces in the course of this walk. **Mr. Weld** says, that the prevailing character of the rocks about **Bantry Bay** is an argillaceous schistus, but that he observed a great variety of stones where there was 
any beach, and among them many large boulders of granite; he says also that 
some of the summits of the mountains consist of siliceous rock. Among the 
pieces which I collected were some of a red sandstone, but most were argillaceous schist, some having an appearance of chlorite. **Mr. Weld** also says, that 


---

p.264



 
there is limestone at the head of the bay: — to that I can say nothing. I thought 
our drivers mountaineer looked very like a granite block; but so many lesser 
mountaineers were scattered about, that it was not very easy to get up to him and 
examine him.


The whole remainder of the route, very near to **Kenmare**, was through a wild 
and hilly region; 
but they were chiefly green slopes, with a smooth level 
road. In the midst of these wilds were a number of people, to the amount of 
perhaps nearly a hundred, assembled in one spot. On inquiry what had brought 
them together, I found it was to celebrate the day of some saint to whom a little chapel close by was dedicated. About half a mile before the bridge over 
the **Kenmare river** we came into the direct road from **Cork** to **Kenmare**. The 
approach to the river is very pretty, the road winding down a wooded hill, with 
several good views of the river. This river, as it is called, though it is difficult 
to say why, is another great estuary or arm of the sea, of not much less extent 
than **Bantry Bay**, with the difference, that it gradually contracts till it receives the stream, which alone should properly be called the **Kenmare river**. Over this part is a very picturesque bridge of two lofty arches, in a pretty little village: looking either way from this bridge a fine view presents itself; one way up the valley and mountainous country through which the stream flows, the 
other way looking down this grand estuary with its rocky boundaries. **Kenmare** town lies on the western shore of the bay, about a mile and half from this 
bridge. Our poor horse seemed very much tired; but he was to be forgiven, he 
had had a toilsome day. I do not think he would ever recommend the road 
through the valley of **Glengariff**.


**Kenmare** town has only within a few years been known by that name: it 
was formerly called **Nedheen**, and indeed is now almost universally called so 
by the country-people of the neighbourhood. The town is small, but there 
are some good-looking new houses. A new inn was also nearly finished, built 
rather upon a magnificent scale. This not being yet inhabited, I went to one 
close by, where were very comfortable accommodations. There is nothing 
striking in the country near the town; but in going down the estuary, very fine 
scenery is presented in many places. **Mr. Weld** mentions the **Blackwater** river 
and bridge over it, and gives a beautiful engraving of it; and I have an engraving of a remarkably fine rock which projects into the water. Artists say 


---

p.265



 
that there is no bay on the coast which abounds so much with striking pictures. 
The **Marquis of Lansdowne** has a house at **Kenmare**; a pretty lodge, but nothing more. The prevailing stone of this country is a gray limestone.


The next day I proceeded onwards to **Killarney**. There are two roads, — 
one very mountainous, I suspect not much better than the valley of **Glengariff**; 
the other extremely circuitous, but the road good, and going all the way through 
valleys. For six miles it continues by the side of the **Kenmare river** (the river, 
not the estuary), to a very fine spot which may be called the head of the river, 
since several rills, running down from the mountains in different directions, unite 
to form the stream. Here is a bridge, with the water from these several rills 
tumbling through it over broken masses of rock, while no outlet from the valley 
appears: it seems as if it was closed impenetrably, that its secrets were no further 
to be explored. It is altogether a very fine scene. Yet on a sudden arriving 
at a projecting mass of rock, the road is seen to turn round it; and after a moderate ascent another valley appears running at a direct angle from the former. 
This is much more expanded than that just quitted, being a quarter of a mile 
in breadth between the rocks; the ground is very boggy and marshy. After 
following this for three or four miles further, the road again takes a sudden 
turn and descent, by a rill running down the rocks: this is the head of the 
Flesk river, which runs into the **Lower Lake** of **Killarney**, and from it the 
valley we now entered is called **Glan-Flesk**.


This valley is continued for seven or eight miles, and exhibits great variety 
of character. While on one side still rise abrupt rocks, on the other are 
gentle slopes, along which runs a wood continued for at least two miles. In 
this wood was long concealed one of the great ringleaders of the rebellion of 
1798 in the south. Suspicions were always entertained that he was lurking about 
somewhere in these parts; yet he contrived for a considerable time to elude the 
vigilance of those who were in search of him, till at length he was betrayed by 
one of his associates acquainted with the secret of his retreat. The bottom of 
the valley on each side of the river is a complete marsh, having an immense 
quantity of the plant vulgarly called the Bog-myrtle growing in it. About 
half way through the wood is a cottage, the only house in the twenty-four 
miles from **Kenmare** to **Killarney** where it is possible to stop and bait a 
horse; but corn must be brought for him, there is none to be had on the spot. 
 


---

p.266



 
Here we stopped: I saw that the poor animal was feeling the effect of his fatigues on the former day, and it was necessary to rest him awhile and let him 
feed. I in the mean time strolled about, but there was nothing to collect except mosses. I was told that occasionally, though very rarely, pebbles have 
been found by the side of the **Flesk**, which, when polished, have a lustre little 
inferior to diamonds. I did not learn this till afterwards; 
though, had I known 
it before, the marshy sides of the river would effectually have prevented my 
going in search of them.


After stopping about an hour we proceeded onwards, and soon came to very 
different scenery, the valley being bounded on each side by immense rocks, 
exhibiting the most various and fantastic forms; I never saw wild grandeur 
in higher perfection: the marsh ceases, the soil is firm, and the river runs 
over a fine pebbly bed. I should think it must be here, if in any part, that the 
stones talked of are found. This continues till within about four miles of 
**Killarney**, when on a sudden the valley ceases, the rocks on one side terminate entirely, ending in an abrupt promontory, which runs into a wide-spreading plain. On the other side the mountains turn in a different direction, and 
the rest of the road to **Killarney** is over an uninteresting flat. The plain is 
called Fila-Down. This entrance to **Glan-Flesk** is so striking, that people 
visiting **Killarney** often take a drive hither on purpose to see it.


My poor horse grew at length so weary that he could hardly get on; notwithstanding this, all my most earnest exhortations to the driver could not prevent his eternally whipping him, till I became so vexed and angry with the 
man, and so anxious to relieve the horse, that I flew down from the car, and 
walked for two miles into **Killarney**. Such were the adventures of my cavalry 
between **Cork** and this place. The first made me angry, for he had scarcely 
any but excellent road to go over; I was convinced he was a mere sluggard: 
the second excited only my compassion and remorse; I felt that he had not 
had fair usage in being made to toil through the valley of **Glengariff** and over 
that terrible mountain.




---

p.267


Lake of **Killarney** formerly **Lough Lene**. — When first brought into public Notice. — First Sight of the Lakes. — Anecdote of **Mr. Fox**. — Meaning of the Term PONY in these Parts. — The Mountain of **Mangerton**. — The **Devil's Punch-Bowl** and **Coommacopple**, two remarkable Lakes on its Summit. — Fine View. — Regulations respecting Boats upon the Lakes. — **Ross Castle**. — Embarkation on the **Lower Lake**. — The Echoes between the Lakes. — The **Upper Lake**. — **Ronayne's Island**. — **Kean's Island**. — **Cromiglaun**. — **Dericunihy**. — Irish Songs. — Island of **Innisfalen**. — O'Donoghoe's Prison.
#### 26


*Nations are not only apt to speak with jealousy of the productions and 
climate of other nations, but the same jealousy is felt even by the inhabitants 
of provinces of the same kingdom, and counties of the same provinces. Whether 
this be commendable or not may become others to determine; I own that 
I was in some degree unwilling to be pleased so much with a view of **Lough Lene**, having a strong affection for another part of the kingdom, and some jealousy 
in consequence of that affection: yet beauty prevailed so entirely over 
this disposition in human nature, and so captivated alike my fancy and my 
judgement, that it was impossible not to feel delight, or to withhold admiration.’’*




Such is the testimony of **Dr. Barton** of Trinity-College, Dublin, to the beauty 
of the Lakes of **Killarney**, which he visited in the year 1751, 
 and which were 
then known only by the title he gives them of **Lough Lene**[25](javascript:footNote('E810001-001/note025.html')). He is one of 
the earliest persons who brought them into notice. As a proof of the strong 
impression they made upon him, he drew up an account of them with the 


---

p.268



 
surrounding scenery, addressed to the learned body of which he was a member; 
and published it in a thin quarto pamphlet, expressly for the purpose, as he 
says, of directing the public attention to beauties which he thought had been 
too long neglected. I do not know of any earlier work which professes that 
distinct object; till then this enchanting spot might almost be said
  

*To waste its sweetness in the desert air.’’*

Thomas Gray, Elegy in a Country Churchyard.




**Dr. Barton** did not go into these parts with any particular view of visiting 
the lakes; the purpose of his journey was to examine the gems of the county 
of **Kerry**, and it was in the pursuit of this object that his attention was so much 
attracted by another. Perhaps beauties are never so striking as when they present 
themselves while the mind is wholly unprepared for them. There is one 
feeling which I can scarcely conceive it possible for any person to experience 
on seeing the lakes of **Killarney**, — disappointment. However busy fancy may 
have been in forming to itself beautiful pictures, scarcely can any be imagined 
too line for the reality to satisfy. 
It was not till about four o'clock that I arrived at **Killarney**, consequently too 
late to think of seeing much that evening. From Major Hunter, whom I have 
mentioned at **Cork**, I was favoured with an earnest recommendation to **Mrs. Coffey** the mistress of the principal Hotel, particularly desiring her to provide 
me with a good and civil guide. This she did; and having dined, I inquired 
where I could go and take a general view over the lakes, for something I must 
see, and there was not sufficient daylight remaining to do more. From the 
flatness of the country between **Glan-Flesk** and **Killarney**, and the no less 
flat situation of the town itself, nothing was hitherto to be seen but the tops 
of the surrounding mountains. My guide said that I could walk through **Lord Kenmare**'s grounds, and from the top of a hill there see entirely over the 
**Lower Lake**. Upon this expedition I set out. I had read and studied very 


---

p.269



 
much several different accounts of the Lakes, particularly **Mr. Weld**'s admirable 
one; I had paid great attention to his plan, to his views, and had impressed 
my mind so strongly with all the great leading features of the landscape, that 
when I arrived at the hill and cast my eyes around, I had the feeling not as if 
they were wandering over objects never presented to them before, but as if 
I was renewing an acquaintance of long standing; — every thing seemed perfectly 
familiar to me; I found every thing conformable to the ideas arranged 
in my mind — a strong proof at once of the accuracy of the descriptions given;, 
and of the transcendent beauty of the scene, which thus answered the high expectation 
raised.


I had many times been told that I must not hope to have fine weather at 
**Killarney**; that scarcely did a day pass there without rain: and I had frequently 
heard an anecdote of **Charles Fox**, à-propos to the purpose, cited. 
Some years ago this distinguished character went to spend a few days with **Lord Kenmare**, whose house is just without, or scarcely without, the town of **Killarney**; invited by His Lordship to come and see the beauties of the country. 
He arrived in a heavy rain: he was told it would be but a shower, but it did 
not cease that day. The next was the same, a heavy rain; still he was told 
that it would be but a shower, and soon over. The shower, however, continued 
from day to day; and during five days that he stopped, there was scarcely an 
hour's interval from it: when, tired with hopeless waiting, he gave up the 
matter and took his leave; able to say he had been at the Lakes of **Killarney**, 
not that he had seen them. About three years after, **Lord Kenmare** being in 
**London**, went to visit him, when the first question **Mr. Fox** asked was, "Well, 
my lord, is the shower at **Killarney** over yet?" It was my fortune also to 
enter **Killarney** in a heavy rain, which had come on almost from the moment 
that we quitted **Glan-Flesk**; nor could I fail often to think of **Mr. Fox**. The 
evening was, however, clear and fine.


The assurance of this uncertainty in the weather occasioned me to make one 
determination long before I arrived on the spot; this was, that the first day of 
my stay which afforded any prospect of being clear and fine, I would go up 
the mountain of **Mangerton**, that being the object of all others for which a fine 
day was of the greatest importance. On returning from our walk, the guide 
said, he supposed he might order a boat for the next day, to go upon the lake. 


---

p.270



 
I answered, By no means; I should wait to see what sort of a day it was likely 
to be before I would make any arrangement; and if promising to be fine and 
clear, I would go up **Mangerton**. I saw that he was somewhat disconcerted 
with this answer; he hesitated, and at length said, It was not usual to take 
that the first thing, it was generally the last. — I replied, that it was very immaterial 
to me what was generally done, I should please myself; and, if the day 
was fine, do as I had said. — Well then, he inquired, should he order ponies to 
be ready in the morning? — "No; nothing shall be ordered till I see the appearance of the morning: — you may come at seven o'clock, I shall be able then 
to judge of the weather, and will determine what shall be done." — The evening 
was now clear and beautiful, and I thought the prospect for the next day favourable.


Nor was I deceived. At seven my guide made his appearance: — "Well, 
Ma'am, there isn't the least bit of cloud about any of the mountains; we may 
be sure of a fine day." — I was perfectly of the same opinion; so I gave him 
full authority to hire ponies for the expedition; one for myself, one for my servant, 
and a third for him, which I found also was to be employed as a sumpterhorse; for a basket of provisions, with drink, I soon perceived was an indispensable 
requisite in whatever direction, or upon whatever element, we were to 
go. At eight o'clock the ponies were at the door: I expected to have seen 
little mountaineers not much bigger than donkeys; but to my utter astonishment, 
behold three tall horses, any of them big enough to be driven in a postchaise. 
"Are these your ponies? "I inquired. — "Yes, Ma'am." — "Have you 
none larger?" — The man stared, he seemed not to know what to answer; it 
was an objection to his cavalry wholly unexpected. He looked first at me, 
then at the nag; "I don't know, ma'am," he answered very seriously; "the 
man has but two that will carry ladies at all, and I believe they are much of 
a size; — most ladies think this quite big enough." — "You are sure the other is 
not larger?" — "Yes, ma'am." — "Are you sure it isn't less?" — "I don't 
know, but it may be." — "Because I should like it quite as well, if it wasn't 
above half the size." — The man stared again more eagerly than ever; a new 
light seemed thrown upon the matter; my real objection to the animal burst 
all at once upon his mind; I was surprised it had not done so sooner: he had 
not the usual quickness of his countrymen, or else he was so bewildered with 


---

p.271



 
being put out of the usual routine in showing his lions, that his faculties were 
for a moment wholly suspended. Now, somewhat restored, he acknowledged 
that to be sure the *baste* was rather a tall one for a lady to ride, but I need 
not be afraid; he was very quiet, and would carry me safe over all the mountains 
in the world. That was rather more than I intended to require of him; it was quite sufficient for me if he would carry me up the one mountain of 
**Mangerton**; indeed I would gladly have dispensed with his services even for 
that, could I have got a substitute of a more reasonable size and stature. I 
therefore now began to inquire seriously whether it was not possible to have a 
smaller horse? — To this I received a negative reply — The other *baste* was 
not so big by a good deal, but he was gone out for the day. No remedy 
therefore appearing, I mounted my pony. Never was any one seated upon such a 
hard-going animal: — I should think, like the gentleman from **Cork**, that he was 
rather more accustomed to going in a common car than to any other kind of 
work; that he did not often go out pleasuring. I found here another instance 
in which the Kerry dictionary varies from dictionaries in general. I conclude 
that we should there find the article pony explained, "a horse fifteen hands high".


The mountain of **Mangerton** is not one of those that immediately border the 
lakes. It rises behind the **Turk-mountain**, the prominent feature round the 
middle or **Turk lake**, a long valley running between the two mountains, 
through which is the nearest road to **Kenmare** town. The height of this mountain 
above the level of the lake seems by no means ascertained with any accuracy; it has been many times described as the highest mountain in **Ireland**: it 
is now fully decided not even to be the highest of those in the vicinity of the 
lakes; **Magillicuddy's reeks** are much higher, though the difference between 
them is yet undecided. **Mr. Weld**, who appears to have been anxious to have 
their respective, and consequently their relative heights accurately ascertained, 
is yet obliged to leave the matter in doubt: he seems to think that the highest 
point of the reeks may be estimated at about three thousand five hundred feet: 
according to one computation, **Mangerton** is only seven hundred feet less; that 
is, two thousand eight hundred feet in height: another computation states its 
height at no more than two thousand feet. The ascent is easy, in no part very 
steep, though in some places rather stony. Within three hundred feet of the 


---

p.272



 
summit is the celebrated lake called the **Devils Punch-bowl**. To this we went 
on horseback, but here dismounted.


This **Punch-bowl** is a vast chasm in the top of the mountain, encircled for 
the greater part by almost perpendicular rocks. On the side towards the **Turk-mountain** 
alone is an interval of rock at which the water is accessible, and from 
which it issues out in a small stream; this runs down the side of the mountain, 
generally appearing insignificant, though occasionally swelled to a fine cascade. 
Only one spring is known to feed the lake, the water of which is so extremely 
cold that it is scarcely possible to bear the hand in it; yet this water never freezes. 
The rocks by which the chasm is surrounded rise so directly from the water that 
it is impossible to go round its edge; the only way to make the circuit of it, is 
by the tops of the rocks. The guide inquired whether I would go round; to 
which I replied, By all means. We ascended therefore among blocks of stone 
and coarse herbage, but found nothing difficult in the ascent, and pursued our 
course to the opposite side of the lake. What an extraordinary scene here presented 
itself! Another lake exactly of a similar nature to the **Punch-bowl** appeared, 
the two separated only by a ridge of rock covered with the same coarse 
herbage. I can compare the whole to nothing so well as an enormous bridge 
of a nose with the eyes on each side. How extraordinary that, amidst all the 
accounts I have read of this country, this very striking, very remarkable feature, 
and indeed I think it far from one of the least remarkable, is never mentioned! 
It appears to me so extraordinary, that I sometimes am ready to ask myself, 
Did I dream of what I have related? or why should that so strike me, which no 
one before has thought worthy of remark? — But no: I certainly did walk along 
this ridge running between the **Devils Punch-bowl** and **Coommacopple**, or the 
Horses Glen, — so the guide told me the other lake was called, — at the height 
of three hundred feet above the water on each side; — a ridge with but just the 
breadth of a good footpath at the top. I would recommend every body to come 
so far round the **Punch-bowl** as to see so remarkable a feature. — I would not 
recommend any one who has not very firm nerves to attempt walking along the 
ridge, nor, if the nerves be ever so firm, to go without a guide accustomed to the 
place. How this can have been hitherto unnoticed, is a question I am at a loss 
to resolve. — Of the numbers who have visited **Mangerton**, has nobody ever 
thought of going round the margin of the **Punch-bowl**? — Surely this cannot be 


---

p.273



 
the case; for the guide, in asking whether I would go round it, did not mention it as 
an uncommon thing to be done: and how any one going round could be otherwise 
than exceedingly struck with the scene and remark upon it, is utterly incomprehensible. 
It is not even noticed by **Mr. Weld**, who seems to have explored every 
part of the country so much in detail. He mentions once in a shooting-party 
upon the mountain being lost in a mist, and after wandering a long time coming to 
a deep glen and lake which he calls the **Glen of the Horse**, but never mentions 
it as connected with the **Punch-bowl** in the manner I have described.


After crossing this extraordinary bridge I proceeded round the other side of 
the lake where is a great extent of plain, not absolute bog, but of very soft spongy 
soil overgrown with coarse herbage, extremely fatiguing to walk over. At the 
edge of the precipice is a spot, about half way along the side, where the 
herbage is cleared away in a small circle, and a few loose stones are scattered 
about; this is called the highest point of the mountain. Owing to the extent 
of surface, from no part is the view seen completely round. **Bantry Bay** and 
the **Kenmare river** were visible in their whole length, looking scarcely wider than 
common rivers; but then the lakes were not to be seen, they were too much on 
the other side; and when we came again within sight of the lakes, the two great 
estuaries were lost. So much does this mountain rise above all immediately 
bordering the lakes, that every part of both lakes, with the stream by which 
they are united, lay as in a map at our feet, the stream scarcely appearing wider 
than a line in a map drawn for one. Beyond the lakes was a vast extent of 
country terminated by **Dingle Bay** and the mountains which coast the northern 
side of it. Never was a more favourable day for such an excursion; it was 
beautifully calm and serene, nor was there an object within the compass of the 
eye but was perfectly clear and distinct; not the least cloud or haze intervened 
throughout the whole wide extended horizon. Indeed, it was a glorious spectacle. 
Even the guide, though he evidently could not altogether digest the irregularity 
of the proceeding, confessed that I was quite right not to lose such a day; 
they might not perhaps have such another for weeks. 


It is curious to observe, in all places which are much the resort of travellers, 
the ingenious devices the people about have, each to pluck a feather out 
of the pigeon's wing. I have spoken of guides at the **Giants' Causeway** who 
made their intrusions a pretence to ask for money. In the present instance 


---

p.274



 
we set out from **Killarney** three; by the time we arrived at the top of the mountain 
we were not less than a cavalcade of fifteen or sixteen. A man had followed 
with a bugle-horn, which he blew in different parts about the **Punch-bowl** 
and the other lake, the reverberation of which by the echoes was really fine. Some 
girls from a cottage at the foot of the mountain followed with goats-milk, several 
boys pursued us with offers to relieve the guide from the trouble of the basket 
of provisions, and carry it, none making their offers in pure love, all hoped 
some token in return. When the regularly employed party had finished their 
meal by the side of the **Devil's Punch-bowl**, (not, however, contenting themselves 
with drinking only the punch it offered them,) all the rest sat down to a 
scramble for what remained. In descending the mountain, the guide showed me 
the entrance to the chasm of **Coommacopple**, the **Horse's Glen**; the end of the 
lake was just visible from without the chasm. I did not descend the mountain 
upon my pony, but walked down very near to the foot, which is about four 
miles from **Killarney**. We had stayed so long rambling about that it was five 
before we got back to the town: during the little remainder of daylight I rode 
down to **Ross Castle** at the edge of the **Lower Lake**, — the first near view I had 
yet had of it, — but it is not an advantageous one. I now permitted my guide to 
engage a boat for the next morning; but I saw that he was altogether deranged 
about the matter, and that the order for the boat was not received with 
the entire satisfaction that it would have been the night before.


The boats for company to row upon the lake are provided by **Lord Kenmare**, 
who has placed them under the direction of one man, Commodore or 
Admiral Plunket, to whom applications for one must be made, and they are at 
a fixed price according to the size of the boat, whether it requires six or four 
oars, and whether it is to go to the **Upper Lake** or not; it is, if I recollect rightly, 
half-a-crown more for going thither than for navigating only the Lower or the 
**Turk** . Whether it is a part of **Lord Kenmare**'s regulation I cannot say; 
but it is expected that a freight of provisions and whiskey shall be carried on 
board, or else two shillings a man eating is charged by the day. I suspect this 
to be an illicit charge; but in such a place impositions are regarded as positive 
privileges. **Ross Castle**, to which I had gone the evening before, is the regular 
place of embarkation. This is the remains of an ancient fortress, once 
of considerable strength, and it would now be a very picturesque object, with 


---

p.275



 
its mouldering ivy-crowned fragments frowning at the edge of the water, but 
that a vile barrack is patched upon it, which entirely defaces and deforms every 
thing. If instead of the barracks the old castle were suffered to remain in 
all its grandeur of decay, and near (not so as to interfere with it) a good hotel 
were built, what an acquisition would it be to all who visit **Killarney**! It is 
mortifying, when one would not wish to have the eye a moment detached from 
the exhaustless store of beauty presented to it, to be obliged to take up one's 
quarters in the town, from no part of which any of the lake scenery is visible. 
The whole of this shore is flat, in some parts even boggy. **Ross Island** was 
once but a promontory or peninsula; it was insulated by a channel being cut 
over the isthmus, to open a communication between the parts of the lake to 
the north and south, without going round the point of the island where is always 
a considerable swell of the waters, sometimes as I am informed, and I 
can readily believe it, a dangerous one.


I walked down to the castle, through a part of **Lord Kenmare**'s grounds. We were accompanied by a man with a fiddle and a bugle-horn, a constant 
appendage to all the boat-parties, who sounds his long-drawn notes to the 
echoes, which they reverberate a thousand and a thousand times. The boat is 
also armed with a cannon; perhaps, — no, I don't think it is quite a twenty-four 
pounder, — say a half-pounder, and we shall perhaps be right, — to be levelled 
also at the echo, which she answers in thunders. Thus equipped, we proceeded 
on our voyage. If I had been astonished at the swelling sea I crossed from the 
coast of **Antrim** to the island of **Rathlin**, I was scarcely less astonished at the 
swell of the waters upon this lake. Not that the waves of the lake were at all 
to be compared with the rolling mountains of that northern sea, but it astonished 
me much, on this small receptacle of fresh water, to see any thing that pretended 
to imitate, even at a humble distance, the turbulence of the vast ocean. 
Nor is the imitation so very humble; — the lake is sufficiently subject to sudden 
squalls and gusts, from the eddies about the mountains, to render sailing very 
hazardous, and the use of sails is prohibited by **Lord Kenmare**. This great 
eddy of the waters seems to be principally within a tract forming a sort of triangle 
between **Ross Island**, **Glenaa Point**, and the Island of **Innisfallen**.


Our destination was to the **Upper Lake**. Passing the fine mountain **Glenaa** 
through the bay at its foot, and the pretty little cottage upon the bay, we proceeded 


---

p.276



 
to **Dinis Island**[26](javascript:footNote('E810001-001/note026.html')), where I landed while the boat was pushed up a rapid 
descent of the stream from the **Upper Lake**; and visiting a pretty cottage on the 
island which commands a lovely view over the **Turk Lake**, we re-embarked at 
another part of the island. Hence we proceeded to a bridge called that of 
the Old Weir, where we again landed for the boat to be pushed up the descent 
of the stream, which comes through the bridge with a strong rush very much 
like the rush of water through London-bridge, if small things may be compared 
with great. From hence we continued our course till we had passed the 
**Eagle's Nest**. This is a remarkable rock rising to a great height almost 
perpendicular above the stream, on the summit of which eagles regularly every 
year, probably the same, form their aëries. A little way beyond is reckoned 
the best spot for showing the effect of the echoes. Here we landed; the bugle-horn 
was played, and the cannon was fired. In this instance I felt disappointment, 
I think the effect of the echoes is magnified; the music of a fine band 
may produce a grand and striking effect, but there was something to me of a 
petitesse in the strains of our one solitary bugle-horn player, which seemed ill 
to accord with the grandeur and sublimity of the objects around, Nor were 
the repetitions of sound any thing like what I expected; I never could distinguish 
more than four, — **Mr. Weld** says he has distinguished twelve, — but this I 
am informed depends very much upon the state of the atmosphere; and, as 
the people said, it happened to be an unfavourable day for the reverberation. 
I have no doubt that what **Mr. Weld** says upon this subject is very just: "The 
generality of persons who visit **Killarney** have no opportunity of judging of the 
effect of musical sounds at the **Eagle's Nest**, or other parts about the lakes, as 
the only musicians who reside on the spot are two wretched performers on the 
French-horn and Bugle. Having been fortunate enough myself, each time 
that I visited **Killarney**, to be associated with parties who could command the 
services of a select military band, I can speak from experience of the superior 
advantage to be derived from a number of instruments. The simple notes of 
the bugle alone are indeed pleasing, but the wonders of the echo consist in the 
distinct repetition of a combination of sounds." I had no such opportunity 


---

p.277



 
of judging the effect of music, so it is better to say no more about it. I must 
only add one observation upon the firing of the cannon, that I had heard an 
effect so much more grand and sublime produced, as I have mentioned in the 
 Narrative of my Residence in France, by the firing of a fowling-piece among 
the rocks and woods of the **Sainte Beaume** in Provence, which came unexpected, 
and for which I was wholly unprepared, that this little peteraro, for 
the firing which so much preparation was made, and which I was told I should 
find so exceedingly astonishing, made no impression whatever upon me, or, if 
any, that of its being but child's play. Once again, however, I repeat that 
the people all said the state of the atmosphere was particularly unfavourable 
upon this day: indeed at the moment vapours were gathering about the mountains, 
which soon after descended in a torrent, and showed me very sufficiently 
the sublime effect which could be thus produced in these regions.


There is something very fine and romantic in the whole course of this stream 
which unites the two lakes. The forms of the mountains exhibit great variety, 
and there are in many places rocks in the stream, which exhibit such fantastic 
figures, that fantastic names have been given to them: one, in particular, which 
has a good deal of resemblance to the hulk of a ship, is called the Man of 
War; but such is the rocky nature of the channel, that it requires a person 
well skilled in the navigation to steer the boat right. The entrance to the 
**Upper Lake** is by a narrow pass between two masses of rock, little more than 
the width of the boat. This pass has the name of **Coleman's Eye**: a man by name 
Coleman, as the tradition says, was pursued by some enemy, and in the ardour 
of flight leaped over the pass, leaving the impression of his foot upon the side 
where he alighted. The particulars of this fact are in general very minutely 
related by the boatmen; but as we had the admiral himself on board, who 
came as steersman, I thought the crew were rather in awe at his presence, 
and not so talkative as they would otherwise have been. At first clearing the 
pass, one is not sensible of being in the **Upper Lake**, there are such a number 
of rocks rising above the water, among which the boat still winds. In a short 
time, however, this sublime scene opens full to the view, and most sublime it 
is. The watery expanse is every way bordered by vast mountains; and the 
passage by which it was entered being almost instantly lost to the view, it seems 
completely locked in, as if there were no possibility of quitting it but over 


---

p.278



 
mountains whose steep sides almost forbid the access of human footsteps. 
What heightened the effect exceedingly was, that in a few moments after we 
entered the lake, the summits of the mountains were completely enveloped in 
black clouds, and the rain poured down in torrents. We made immediately 
for **Ronayne's Island**, one of the principal rocks in the lake, on which is a cottage 
inhabited by a family; and here we took shelter, every one nearly wet 
through. Good fires were immediately lighted; and to beguile the time the 
basket of provisions was produced.


Oh, how magnificent was the sight, to watch first the gradual breaking of the 
clouds, and at length their final dispersion, with the bursting forth again of 
the glorious sun! Indeed, they who have not seen the **Upper Lake** of **Killarney** 
under such circumstances, have scarcely half seen it, they have but imperfect 
ideas of its sublimity; it answered well the being wet through. The whole 
lake is spotted over with little rocky islands; not wholly naked, but in general 
clothed with shrubs and trees, among which the arbutus is the most prevailing. 
This tree is indeed to be seen abundantly all about the lakes, though in the 
greatest abundance about the **Upper Lake**. It grows to a size which I never 
saw before: in **Provence** these trees are common, and bear very fine fruit, but 
do not grow to near the size of those about **Killarney**. I have seen also very 
fine ones in the county of **Wicklow**; and there was one at **Newtown Mount 
Kennedy**, a place which I did not see, exceeding much, as I was informed, any 
about **Killarney**: not half of it is, however, now existing. Many people recommend 
the autumn as the best time for going to **Killarney**, because the arbutuses 
are then in flower; but, though beautiful, they are in my opinion such 
a minor consideration in comparison with the nobler features of Nature which 
claim the attention, that I should never make them my particular object, and 
rather say, Go when the days are at the longest, that the shades of night may 
shut the sublime scene from the sight for the shortest space possible.


 **Ronayne's Island** is the largest among the little archipelago of this lake. The 
cottage upon it is one of many built about the lakes by the polite attention of 
**Dr. Smith**, for the accommodation of strangers. In all there are inhabitants, 
so that dinner may be cooked if a party chooses to dine at them; but 
they must carry their own provisions, potatoes excepted, which the tenants can 
always furnish. A gravel-walk from the cottage winds up among the rocks, 


---

p.279



 
and wood with which they are clothed, to the summit of the rock, where is a 
little knoll, forty feet above the level of the water: from hence is a charming 
view over the lake. This island has its name from having been long the reputed 
residence of an Englishman, by name Ronayne, who here passed the 
latter years of his life in complete seclusion. Whether taste or disappointments 
drove him from society, or what course led him into such a seclusion, 
was never known. Such is at least the tradition now affixed to the island: 
if it be a fact, as it really seems to be, that a person by name Ronayne made it 
for many years his retreat, his being an Englishman seems somewhat improbable. 
 **Dr. Smith**, in his History of the County of **Cork**, mentions a place on the 
**Great Island** in **Cork harbour**, called **Ronayne's Grove**, the seat of a family of 
that name. Does it not appear much more probable that the recluse of **Killarney** 
should have been of this family, situated in the very neighbourhood, than 
that he should have crossed the seas to seek such a shelter from the world, or 
from himself?


When the weather had cleared and the provisions were consumed, we returned to the boat, and began the regular survey of the lake. Several islands 
were pointed out to me by the names which they bore, some others were not 
particularized; and inquiring what their names were, I was told they had none. — "How happens that?" I asked. They did not know; the others had been 
named by different parties visiting the lakes, and nobody had had the fancy to 
give them names; if I had no objection, they should like very much to name 
one after me: then pointing to a rock very near us, they said that had no 
name, we might land and christen it. I would not, however, permit my name 
to be given: as the habit of the world has been ever to pronounce it as if it were 
a Plum-tree, I was sure that the island would never be called any thing but 
Plum-tree Island; and a tradition would soon be affixed to it that it was once 
covered with Plum-trees. I therefore declined being godmother, at least so far 
as giving my own name to it was concerned: but the men seemed to have a 
great desire that it should be christened, and begged that I would give it some 
name; any that I fancied. "Very well," I said; "it shall be called Kean's 
Island, after **Mr. Kean** the great actor." — Oh, they had often heard of him; 
they should like that name exceedingly; they wished he would come to **Killarney**. 
We landed then; it was a pretty rock, with some arbutuses and 


---

p.280



 
other shrubs and plants growing upon it: the people were all ranged in a circle, 
in the midst of which the bugle-horn player, who I found was the established 
clergyman upon these occasions, came forward and repeated the proper formulary 
in a jargon of English, Irish, and Latin, perfectly unintelligible to me; 
then applying to me as godmother, I gave the name, which he repeated with 
the addition of a little more jargon; and the ceremony was concluded with 
throwing down upon the rock a bottle of whiskey, which was dashed to pieces. 
This part, I own, surprised me not a little; I should never have expected to see 
a bottle of whiskey thus disposed of; but the island they all said would not have 
been regularly christened without it: Now, they added, it could never have any 
other name than **Kean's Island**, and as such it would be pointed out to all future 
navigators on the lake. I should like much to know whether it ever has 
been so to one. The conclusion was a hope that the crew might have a bowl of 
punch when they got home in the evening, to drink the godmother's health. 
 — I then perfectly understood the general eagerness for the christening.


We now proceeded in the examination of the lake. Its shores are very much 
indented with creeks and inlets formed by streams descending from the mountains. 
That of **Cromiglaun** is the most considerable and the most beautiful. 
The entrance is by a narrow pass between two almost perpendicular rocks; 
when soon an extensive basin opens to the view. Steep craggy cliffs, on which 
are scattered a few straggling trees, border it on one side; on the other are 
masses of dark and naked rock, while in the centre is a wood of oaks, from 
which a river is seen issuing. Proceeding about half a mile up the basin, some 
cottages appear, round which are a few small inclosures, and presently a beautiful 
cascade is seen above the trees pouring down a deep glen. The imagination 
can hardly picture to itself any thing more exquisitely romantic. Here, 
and not on **Ronayne's Island**, if I sought a seclusion among the lakes of **Killarney**, 
would my abode be fixed.


Another charming inlet is that which receives the river of **Dericunihy**. This 
lies round a rock, which, from the resemblance found in it to a coffin, has the 
name of Coffin-point. Here is the most considerable cascade about the **Upper Lake**; it lies embosomed in the depths of a thick wood. The water, where it 
first appears, gushes from among the rocks at a great height up the mountain; 
then, after falling some way, it spreads out to a much wider extent, pouring in 


---

p.281



 
a number of small streams, which are beautifully mingled with the foliage of 
the trees. The rills afterwards unite and form a basin in an excavation of the 
rock, whence again the water rushes through a more contracted channel in the 
midst of the wood down to the river below.


Among a number of persons a diversity of opinions will prevail upon every 
subject; and among the numerous visitors to **Killarney**, great difference of sentiment 
is entertained as to which of the three lakes is to be preferred. I have 
no hesitation on the subject; I think the **Upper Lake** presents indisputably the 
grandest and most beautiful features of the whole circuit; but it should be visited 
and re-visited; one day is very insufficient to explore every part of such 
an extent of scenery, where every part offers something to interest, something 
to charm. I feel that seeing it but once, I have seen it very imperfectly. The 
idea of the bowl of whiskey-punch at night seemed to inspire the boatmen; they 
became talkative and sang several Irish songs as we rowed about. One was in 
praise of the lakes of **Killarney**; the man who sang it had a good voice, and 
gave it with an enthusiasm inspired by the subject, which rendered it very interesting. Another sang an old legend of some saint with great energy and 
action, rather, however, laughable than otherwise.


In returning home we stopped at the island of **Innisfallen**, the largest in the 
**Lower Lake**. It is a beautiful spot, a mile in circuit, covered with meadow-ground 
and trees; a gravel walk runs all round it. Here were the largest hollies 
I ever saw, with trunks really like forest-trees: vegetation does seem extremely 
luxuriant in these parts; the pasture here is esteemed remarkably fine for cattle. 
On the island are some remains of an abbey, one of the most ancient in 
Ireland; they are at the north-eastern end of the island, embosomed in trees, 
which give them a very picturesque appearance. The original foundation of 
this abbey appears to date as far back as the sixth century; and from the rudeness 
of these remains, destitute of sculptured ornaments, of lofty arches, of rich 
windows, they may fairly be supposed to be of the primaeval building. In 
cabins formed among the ruins live the present inhabitants of the island; and 
in a garden behind their humble habitations are trees which are shown as coeval 
with the first establishment of the abbey: a license is, however, allowed to people 
to believe this, or not, as they please. An old man,
  

*The sad historian of the pensive plain,’’*

Oliver Goldsmith, The deserted Village




---

p.282



 
gathered a large piece of wild hop, which was running about the roof of his cabin, 
and begged I would accept it; it would bring me good luck; for the plant 
was originally set there by the monks, and it constantly grew up every year, 
and spread itself about as I saw it. I could not refuse the intended kindness; I 
brought the plant away, and have preserved it, at least as the memorial of a most 
beautiful spot, and a day which I shall ever recall with the sincerest pleasure.


Near these ruins is a small chapel or oratory, covered with ivy, more interesting 
than the ruins of the abbey. The door-case is a round arch, such as is 
usually termed Saxon, and appearing of a date much subsequent to the rest of 
the building. This chapel has been converted into a room of entertainment for 
the numerous parties that frequent the island during the whole summer season. 
And since the gloom of the edifice, such as it stood originally, would ill have 
accorded with the jollity intended to succeed to the pious meditation of which 
in ages past it was the theatre, two modern bow-windows have been added, 
and the whole inside has been smoothly plastered and washed over: — what can be said of the taste which shows so little respect to like venerable relics of antiquity? The shores of this island are on one side steep; on the other the 
rocks shelve down to the water's edge, and continue the same shelving so far 
into the water, that no boat could land here, but for a little stone quay which 
has been thrown up. At this quay, which is very near the ruins, were fishermen, 
who had got a fire, and were broiling slices of salmon from fish just taken 
out of the lake, and which they offered us as we came on shore. 
From hence we passed over to **Ross-Castle**, where we landed just before dark. 
Thus concluded the second day of my stay at **Killarney**.




---

p.283


The **Gap of Dunloh**. — The River **Laune**. — Stream and Lakes in the Gap. — The new Road through it. — The picturesque Bridges. — McCarty More's Country. — The Sept of McCartys. — Family of Mahony. — **Dunloh Castle**. — **Mucruss Peninsula**. — Ruins of **Mucruss Abbey**. — Tomb of the last O'Donoghoe. — Fabulous Stories respecting the Great O'Donoghoe. — Mr. Herbert's Grounds. — Copper Mines there. — Brickeen Bridge, and Island. — **Dinis Island**. — **Turk Lake**. — Excavations in the Rocks that border it. — Turk Cottage — **Turk Mountain**. — **Glenaa Bay**. — **Glenaa Mountain**. — Salmon Fishery. — O'Sullivan's Cascade. — **Ross Island**. — Copper and Lead 
Mines there. — Former and present Appearance of the Island.
#### 27


The next day was devoted to the fine wild **gap of Dunloh**. All mountainous 
regions abound with dells, or glens, or valleys, by whichever term they may be 
called — breaks in the enormous masses of stone of which the mountains are 
composed, assuming various forms and appearances, according to the courses 
of the mountains which they intersect. Sometimes they seem but as breaks 
between masses of stone of different descriptions, which, having no regular 
point of union, leave this gap between them; since it often happens that the 
rocks on one side of such a dell are of one description, and those on the other 
of a very different. This is strikingly exemplified at **Loch Hela** in the county 
of **Wicklow**, one side of which dell exhibits rugged masses of granite, the other 
abrupt rocks of slate. But this is a geological question, and I am to describe 
these dells rather as objects of scenery.


None that I have seen presents more striking scenery than the **gap of Dunloh**. 
The road to it runs north of the lake; not immediately at the water's edge, but 
on rising ground a quarter of a mile above it. The country is dull, consisting of 
inclosures with stone fences, and destitute of trees; but from the road are several 
fine points of view over the lake and the mountains on the opposite shore. 
Two streams are crossed; the **Deanagh**, which runs into the lake, and the 
 **Laune**, the only outlet by which the waters of the Lake communicate with 
 


---

p.284



 
those of the ocean. This stream is in general shallow, but swelling occasionally 
assumes the character of a rapid torrent; it runs into **Dingle Bay**. It seems 
probable that, though now called the **Laune**, it is properly the Lene, so named 
after the lake from which it flows; but the lake having lost its original appellation, 
the name of the river has undergone a change, not a very material one.


From this river the road turns round the head of the lake, and presently the 
entrance to the Gap appears, a vast chasm between immense rocks, having a 
considerable resemblance in the distant view to the Scalp in the county of 
**Wicklow**, though this is lost exceedingly the nearer it is approached; indeed 
all the features are upon a much more grand scale. The valley is reached by 
a considerable ascent; a stream pours down it, which has its course quite 
through the valley, expanding at intervals into lakes of some extent. The mountains 
at the entrance of the valley, and indeed the whole way through, but 
more particularly at the entrance, are very much scattered over with vast broken 
masses of rock, and on the brows are many masses which seem ready to fall at 
every moment; — woe to those who are within reach whenever such a catastrophe may occur! — Formerly the whole valley was so overstrewed with these masses that it was difficult even for a pedestrian to penetrate through it; but since it 
forms a convenient line of communication between the country north of the 
lakes and that bordering on the **Kenmare river**, **Major Mahony**, the proprietor 
of **Dunloh Castle**, has had a regular road made for the convenience of the 
country-people carrying the produce of their farms to the places where they 
find a sale for them. It has been a most laborious, but therefore the more patriotic 
work; at present it is not practicable for any kind of carriage more than 
half way through the gap, the other is still but a horse road; when more prosperous 
times will permit of the undertaking being further prosecuted, a carriage 
road is to be made the whole way: even to make the present, masses of 
solid rock have been in some places cut through. The great difficulty lies in 
conducting it round the lakes, the rocks coming down so much to the edge of 
the water as scarely to allow space for a road wide enough even for a single 
carriage; it has also been necessary, from the winding course of the stream and 
the rocks, frequently to change the side of the stream on which it is carried, 
and cross it by bridges. These bridges contribute very much to the picturesque 


---

p.285



 
effect, a character having been maintained in their construction which harmonizes 
well with the rest of the features; one in particular, at the head of a cascade, 
has almost the appearance of a natural arch in the rocks, the water having 
forced a way underneath.


The gap is three miles in length, lying the whole way in a gentle ascent, so 
that the stream forms numberless little cascades between the lakes; besides 
this, in many places water pours down the sides of the mountains. The gap 
expands very much towards the upper end, forming a vast amphitheatre; and 
the mountains that close it being ascended by a zig-zag road, the head of the 
**Upper Lake** is seen at a vast distance below. **Magillicuddy's reeks** are here 
a very conspicuous feature. One of the tracks for ascending them is from this 
part, but that does not lead to the highest point, **Gheraun-tuel**, a much more 
circuitous route must be taken to reach that. The gap runs between **Tomies mountain** 
and the **Purple mountain**. The guide brought with him a musket 
and some powder, which was fired in different parts of the gap: the echoes are 
fine: still, I think, on this subject too much is said, or else the atmosphere was 
peculiarly unfavourable to them during my stay in the country. The water of 
this stream is some of the most pure, soft, and delicious that I ever tasted.


Returning along our steps, since there was no other way of quitting the gap, 
we proceeded to **Dunloh Castle**, about a mile or mile and half from it. A large 
tract of country here, round the north-west end of the lake, is still called McCarty 
More's country. Before the English conquest, when **Ireland** was divided into 
a number of petty sovereignties, the McCartys, a powerful sept, were sovereigns 
of a large district in the province of **Munster**, then called the kingdom of 
**Desmond**, which in the Irish language signifies South Munster. It comprehended 
the whole of what is now the county of **Cork**, the western part of the 
county of **Waterford**, and great part of the county of **Kerry**. McCarty More 
(which More signifies The Great) was king of **Desmond**, at the time of Henry 
the Second's invasion, and was one of the earliest among these petty sovereigns 
to swear fealty to him, consenting to pay him a yearly tribute. The present 
owner of the lands, which still retain the name of their ancient possessor, **Major Mahony**, is a descendant in the female line of the great Brian Boroimhe; 
the first ancestor of the O'Mahowns, or O'Mahonys, for so they should properly 


---

p.286



 
be called, being a descendant of Kean Mac Moyle More, who married a 
daughter of King Brian.


What is now standing of **Dunloh Castle**, the residence of **Major Mahony**, 
is but a fragment of a much larger pile of building, the original extent being 
yet discernible. All that remains is a square tower, which admits only of one 
room on a floor, and the greater part of the lodging-rooms are in a separate 
building detached from the house. The old part of **Blarney Castle** is just the 
same kind of tower, and so is the tower at **Ross Castle** on the lake. **Dunloh Castle** is deeply embosomed in wood: and, though in the neighbourhood of 
such fine scenery, has no view from the windows: its owner bears a very high 
character in the country. I have to acknowledge the politeness of being invited 
in, to take shelter in the castle during a heavy shower of rain. I had intended 
taking the ruins of **Aghadoe** in my way home; they stand on a hill half 
a mile out of the road. But though the rain had ceased when I quitted **Dunloh Castle**, it soon recommenced with increased violence, so that the lake, the 
mountains, and every other object but those immediately by the road side, were 
wholly shut out from the view: adjourning, therefore, the seeing **Aghadoe** to 
another time, I hastened home, where I arrived about four o'clock, nor could 
stir out any more the rest of the day. On the fourth day, having obtained 
permission to see the grounds of **Mr. Herbert** at **Mucruss**, I went thither 
as my first object. The road was for some way the same that I had taken 
to **Mangerton**, crossing the river **Flesk**, and passing the grounds of another **Mr. Herbert** at **Cahirnane**, on the edge of the lake. The grounds of the two Mr. 
Herberts and of Mrs. Delany occupy so large a part of the shores of the 
**Lower Lake**, that from **Ross Island** to the channel which unites the two lakes, 
they can only be examined from the water, unless special permission be given 
by the owners of these places. Into those of Mrs. Delany and **Mr. Herbert** 
of **Cahirnane** I did not go; but the grounds of **Mucruss** are one of the striking 
features of the **Lower Lake**, and to omit them is to leave half that unseen. 
Yet, if I felt disappointment any where in the scenery, it was in the grounds 
of **Mucruss**; in any other place they would be much more a subject of admiration; but they are only pretty, they have no grand features in them, and here 
we can scarcely be satisfied with any thing that exhibits none; they are surrounded, 


---

p.287



 
it is true, with grand features, but present nothing grand in themselves; 
they run along a flat peninsula which divides the **Lower Lake** from 
**Turk Lake**.


The entrance to the demesne is in a decayed village, where once was a flourishing 
iron-manufactory, but which, like too many other things of the kind in 
Ireland, has failed for want of encouragement. The ruins of the **Abbey of Irrelagh**, or **Mucruss Abbey**, form an important feature in this demesne, presenting 
themselves in several very picturesque points of view as seen from different 
quarters; they stand amidst the shade of tall trees, and are exceedingly 
overgrown with ivy and other plants, which add greatly to their effect. So 
much of the outward walls is standing that the extent of the buildings may 
be very well judged; this is the case, in particular, with the form and dimensions 
of the church. The entrance at the west end is by a lofty pointed arch, 
in good preservation, from which there is a very good view along the church 
to the great east window; this is also well preserved. The length from east 
to west is a hundred feet, the transepts from north to south are sixty; the 
tower is supported by four arches also entire. The cloisters too are well preserved, 
they surround a quadrangular area of forty-six feet every way. In the 
centre of the area is a very remarkable old yew-tree; it rises in one straight stem 
to the height of nearly twenty feet, and then throws out branches which completely 
overshadow the whole area, giving an indescribable additional gloom 
and solemnity to the gloom always inseparable from these kind of monastic 
remains. At two corners of the cloisters are stairs leading to the cells over 
them; but nothing very interesting is to be seen when they are ascended. A 
collection of skulls and other bones are piled together close by the west 
entrance to the church; but I saw none of those revolting spectacles of the 
dead too early disturbed and removed from, what are usually termed, their 
last homes, which have been so severely reprobated by some writers.


**Mr. Weld** says: 
"This abbey is a common and favourite place of burial; 
the limits of the cemetery are small, the depth of the soil inconsiderable. The 
consequence is, that coffins with their mouldering contents are not unfrequently 
removed to make room for others, long before decency can warrant such a 
measure. In a passage leading to the cloister, I once found a head with a 
considerable part of the flesh of the face and nearly the entire hair upon it, 


---

p.288



 
literally rolling under foot; and though the place from time to time is carefully 
cleared, yet the bones, skulls, and coffin-boards that are prematurely dug up, 
quickly accumulate again. The boards are deposited in the vaults, one of 
which, adjoining to the church, is now entirely filled with them to the very 
crown of the arch: the bones and skulls are heaped up in the angle formed by 
the nave of the church and the transept, where many thousands may be seen 
bleached to an extraordinary degree of whiteness by their exposure to the 
weather."


**Sir John Carr** speaks still more strongly. "Whilst I was reading," says he. 
"a pathetic epitaph upon one of the monuments in the abbey, I felt myself 
affected by a putrid effluvia, and upon looking on each side, I observed for 
the first time, some bodies, which might have been interred two or three 
months, in Coffins, the planks of which had started, not half covered with 
mould. Upon quitting the spot, a great collection of skulls and bones promiscuously 
heaped up in niches in the walls, excited melancholy observation." — 
Again: "The soil of the abbey is very thin, and every effort has been made to 
dissuade the lower classes from bringing their dead here, but in vain. It is a 
fact, that those who have been buried six months or a year before, are raised 
and placed on one side to make room for those who are brought for interment 
afterwards. So loaded with contagion is the air of this spot, that every principle 
of humanity imperiously calls upon the indulgent owner to exercise his 
right of closing it up as a place of sepulture in future." Indeed, indeed, I saw 
not these disgusting sights: whether **Mr. Herbert** may have prohibited any 
more interments there, I really cannot say; if the evil was so great, he was 
scarcely justifiable in not doing it. All I can say is, that there certainly were 
skulls and bones lying by the west door of the church, but in nothing like 
the numbers represented, perhaps inspiring some pensive reflections upon the 
frailness of our mortal nature, but in which I could not find any thing to disgust; 
and for the rest, nothing was to be seen of the half uncovered mouldering coffins — nor was the sense of smelling more offended than that of sight. I thought there was something altogether in the ruins of **Mucruss Abbey** very solemn and well worth exploring.


Here is shown the tomb of the last of the O'Donoghoes. I do not recollect 
at what time he was buried, but I think within fifty years. The name of 


---

p.289



 
O'Donoghoe is of the highest distinction in these parts; the original ancestor 
was a sovereign prince, King of **Munster** I believe; but the period when he 
flourished seems by no means accurately determined. That such a prince did 
exist will scarcely admit of a doubt; and descendants of his, at least such as 
bore his name and claimed to be so, were, as appears above, recently alive; 
very possibly more may yet arise, notwithstanding that the tomb of the last of 
the race is shown here. But whatever or whoever the person was that first 
bore this name, the fables recorded of him are endless. He was the best of 
men and of princes, a great warrior, generous and hospitable to excess, a wise 
legislator, a strict adherent to justice, yet tempering his justice with godlike 
mercy. He did not die, but suddenly disappeared; nor was it ever certainly 
known what became of him, but it is much believed that he has now a Court 
and Palace at the bottom of the lake. Thus much is certain, that he is seen 
occasionally to rise out of the lake mounted upon a 
  
 
"milk-white steed 
  
 
Most like a baron bold." 


There are many persons who have worked their imaginations into a positive 
and firm belief that they have seen such a vision: its appearance forebodes 
great good fortune to him who has the happiness of witnessing it. Moon-light 
nights are generally selected by the monarch for this ascent. Among a large 
cluster of islands or rocks between **Ross Island** and **Mucruss**, is one which is 
thought to resemble a horse drinking, and is thence called **Horse Island**; this is 
O'Donoghoe's horse, and when he is seen rising out of the lake on horseback, 
**Horse Island** vanishes. Our hero and his appearance rising from the lake are 
well described in a poem entitled **Killarney**, published about twenty years since 
by **William Porter**, Esq.; a poem which cannot fail to interest every person 
acquainted with the scenes it celebrates. The building **Ross Castle** is often 
ascribed to this renowned potentate. At the mouth of **Ross Bay** is a cluster of 
small islands, the most conspicuous of which is called O'Donoghoe's Prison; 
it is a tabular-appearing rock rising twenty feet above the water. This was 
the place of confinement selected by the prince for his disobedient and rebellious 
subjects. I was told that more than once soldiers from the barracks who 
have incurred punishment have been sent hither for a certain term. This 
may be true, or may not; and if such a punishment was substituted in the place 
 


---

p.290



 
of flogging, praise be to those in whom the idea originated! In severe weather 
there would be some severity in it; in fine weather it seems little liable to objection. 
Punishment must be felt in some way, or it ceases to be what it is 
intended. On the summit of this little insulated pile of rock there is a bog six 
feet in depth.


From the abbey we drove all through the grounds of **Mucruss** to **Brickeen Bridge** where the peninsula terminates, a course of nearly three miles. The 
house makes no show, and is by no means advantageously situated for a view 
any way over the beauties by which it is surrounded. The drive is very pleasantly 
diversified by lawns and shrubberies, but there is no one spot particularly 
striking. The guide carried me to a place which he called a marble quarry 
at the edge of **Turk Lake**; but I could not make any thing more of this marble 
than a coarse-grained limestone exhibiting various shades of gray and reddish 
brown, sometimes regularly striated with these colours, which seemed to pass 
with the guide for the veinings of the marble. In some places the stone assumes 
a slaty character, the calcareous veins uniting in places with a form of clay slate. 
On this peninsula, at the edge of **Turk Lake**, some years ago a copper mine was 
worked, but it has been abandoned many years. The discontinuance of the 
works was owing partly to mismanagement, partly to want of harmony among the 
persons concerned in them. Water had broken into the mine before it was abandoned, but not from the lake, and it was not found to impede the works. **Mr. Weld** says, that in searching among the rubbish about the shaft of this forsaken 
mine he found, besides the copper pyrites, its principal produce, gray copper 
ore, malachite, brown iron-stone, gray and red cobalt ore, besides other mineral 
substances. A hope was once entertained that cobalt might have been found 
in sufficient quantities, and of so good a quality as to become a valuable 
article of commerce; but when some specimens of it were sent to a potter in 
England for trial, he found it too much intermingled with copper and iron to be 
employed in his manufacture. The whole peninsula of **Mucruss** is a pale blue 
limestone; the same stone continues all round the shore of the lake by **Cahirnane** 
to the **Flesk** river, and several of the islands in this part of the lake are 
entirely composed of this stone. The figure of rock likened to a horse drinking 
is formed by the excavations every where common among limestone rocks. 
Another rock near it, called O'Donoghoe's Table, is formed in like manner by 


---

p.291



 
excavations which have left four pillars only as it were standing to support a flat 
piece of rock above.


**Brickeen bridge** unites the peninsula of **Mucruss** with the island of **Brickeen**: 
it is by this channel that boats from the **Lower Lake** commonly enter **Turk Lake**. Brickeen and Dinis islands close the lake to the west, running between 
the peninsula of **Mucruss** to the north and **Turk mountain** to the south. These 
two islands were once connected by a bridge, but that is no longer in existence; 
this channel is never used for entering the **Turk Lake**: boats sometimes go 
through that between **Dinis Island** and **Turk Mountain**; but the passage is narrow, 
the bushes and trees almost closing over it, and the water runs into the lake 
with such a prodigious rush, that the boat is hurried along very disagreeably; 
it is, therefore, rarely used. **Dinis Island** is one of the prettiest spots about 
the lakes to those who seek only for mild and tranquil beauty, but it has no 
grand features to boast. It produces the finest arbutuses hereabouts.


A boat was ordered to meet us at **Brickeen bridge**; and having taken a land 
survey of **Mucruss peninsula**, we now rowed round its southern shore. **Turk Lake** is sometimes called **Mucruss Lake**, from its running along one side of **Mucruss peninsula**, and sometimes the **Middle Lake**, from being in some sort, 
though not absolutely, between the two others; but the most common appellation 
is **Turk Lake**, from the great mountain of the same name bordering it to 
the south. We rowed first along the shore of **Mucruss**; the rocks here are curiously 
excavated, forming in various places arches, resembling exactly vaulted 
cellars, whence they are called O'Donoghoe's Cellars. Parts of the rock are 
sometimes so undermined by the constant attrition of the water, that they separate 
from the mass and are precipitated into the lake. Near the copper 
mines a mass of this kind has fallen, which now abides in the lake, exhibiting 
a most striking and fantastic figure, something like the ruins of an old gateway. 
I wonder that some similitude to this mass has not been found, after which to 
give it a name; but it is yet nameless. **Turk Lake** has not, like the others, its 
archipelago of islands; a single solitary one in the north-east corner is all that 
it can boast. Whether it is considered as a diabolical thing that while the other 
lakes are so rich in islands this should be so destitute, or for what reason I 
cannot tell, but something diabolical there must be about it, for it is distinguished 
as **The Devil's Island**.




---

p.292


#### 27


Having coasted round the north and east shores of the lake, we come to Turk 
Cottage, which stands on a small platform of level surface, between the foot of 
**Turk Mountain** and the lake. A garden and small meadow fill up the platform. 
This cottage is not, like those belonging to **Lord Kenmare**, open for 
the reception of visitors to the lakes; they are only permitted to contemplate 
its beauties at an awful distance from the water, — no profane foot must dare 
attempt to invade the shore. Above is a large plantation of fir and larch, made 
by **Colonel Herbert** upon the slope of the mountain; and by its side runs down 
**Turk Cascade**, supplied by the superfluous water from the **Devil's Punch-bowl**, 
on **Mangerton**. **Turk Mountain** rises boldly and majestically above the lake, 
but does not exhibit any very marked features of broken rock masses, dells, or 
chasms. Nearly the whole side is more or less planted.


After making the complete circuit of the lake, we passed through **Brickeen Bridge**, and crossing over to **Glenaa Bay**, the south-western corner of the 
**Lower Lake**, landed at Glenaa Cottage, delightfully situated on the bay, 
having the beautiful mountain **Glenaa** full in view. Here the bait for the day 
was prepared: — the boatmen had been angling in the lake, and caught some 
little trout, which were broiled, and thus fresh from the water they were really 
delicious. The mountain of **Glenaa** is by no means one of the most lofty hereabouts, 
but may be pronounced one of the most beautiful, whether from the 
wavy outline of its summits, the undulations presented by its slopes, its situation 
directly above the lake, or the green with which its sides are clothed.
  
 
"There was a time, nor is that time long past,"
  
 
when the sides of **Glenaa** were clothed with stately forests, but against the 
want of money not even their sylvan majesty could remain sacred; — to raise 
money, they have all within the last twenty years been laid prostrate. Yet if 
not waving with that luxuriance of foliage by which they were once adorned, 
these declivities are still green, still beautiful: new saplings are springing up, 
which, if not immediately, will ultimately, by their youthful charms and graces, 
throw into oblivion the memory of their noble and illustrious ancestors.


In **Glenaa Bay** is the great salmon-fishery of the lake. The fisheries are 
the property of **Lord Kenmare**, who leases them out, with the restriction that 
the fish are never to be sold in **Killarney** at more than twopence a pound, 


---

p.293



 
and that any person is to be allowed to angle in the lake. After we had returned 
to our boat, we perceived the fisherman going to haul, as the term is, 
and made up to the shore to see the process: this there is no occasion to describe, 
it is known to most people. As they were drawing the nets to the shore, 
several stories were related by the people about of the number of fish often 
taken at a haul; sixty or seventy seemed to be considered as a trifle; and bets 
flew about freely of a glass of whiskey, a fivepenny piece, or some other not very 
heavy bet, whether the number of fish taken should be odd or even. There was 
no difficulty in deciding the matter, nor was any great time required to count 
over the prize, — one appeared. He was, however, a noble fellow, — a trout 
which must have weighed not less than five or six pounds. I suppose the fish 
seeing a stranger, were shy and would not show themselves. Whether the men 
reckoned all fish that came to their net I do not know, but they brought up 
plenty of weed: in deciding the bets, however, this was certainly not allowed 
to reckon as fish. 


From hence we proceeded round **Glenaa Point**, which terminates the bay, 
along the south-western shore of the lake, to O'Sullivan's Cascade. Off **Glenaa Point** is an island which is still called **Darby's Garden**, an old man by name 
Darby having some years ago contrived to cultivate it as a garden. It is now 
well clothed with plants and herbage. The family of O'Sullivan has been mentioned 
as anciently of great distinction in this country. The cascade named 
after them is altogether the finest about the lakes. It is deeply embosomed in 
a wood, which, in preventing its becoming an object in the coup d'oeil of the 
landscape, to which it certainly would add one more beauty, renders it still 
more enchanting as a single feature. There are three distinct falls, each succeeding 
at a short interval to the other; the breaks adding to the beauty rather 
than diminishing it, and the rush of water is very great. This wood and cascade 
are upon the side of **Tomies mountain**; the height which the water descends 
is considerable, I know not at what it is computed.


Passing from this place to **Ross Bay**, we were so near the island of **Innisfallen** 
that I once more stopped there, and walked all round, which I had not 
time to do in my former visit: I was more enchanted than ever; it is indeed 
a delicious spot. Turning round the point of **Ross Island**, which forms the 
entrance into the bay, is a rock with a cavity which presents the appearance 


---

p.294



 
of shelves: — this is called O'Donoghoe's Study. Landing at **Ross Castle**, 
I walked over to the other side of the island, where are very extensive copper 
and lead mines; the former more considerable than the latter. These mines 
were worked in times of a remote date, as appeared by tools found when in 
later times the works were resumed. The former undertakers had pushed their 
excavations too far in the direction of the lake, so that the water broke in, and 
this seems to have been the occasion that they were abandoned. The forsaken 
mines had very much attracted the curiosity and attention of an officer, who 
was for some time on duty at the castle, who came from the land of mines, 
 — **Cornwall**. The observations he then made induced him, in 1804, to form 
a plan for re-opening them; and having engaged some others to join in the 
speculation, a capital was raised sufficient to commence the experiment.


Their first efforts were directed, not to the old shafts, but to a pit which, as 
well as the shafts, was filled by the water which had burst in from the lake. 
By means of the steam-engine,
  


> 1. That giant power, which from earth's deepest caves
>   
> Lifts with strong arm her dark reluctant waves, 
>   
> Each cavern'd rock and hidden den explores, 
>   
> Drags her dark coal, and digs her shining ores: —
> 

 
by means of this giant-power the draining the pit was effected, and a rich vein 
of lead and copper was discovered, which for some time yielded such profit as 
proved an ample return to their expenditure, and the works were pursued with 
great alacrity. My guide had been employed in them for three or four years. 
They failed, however, at length; though the cause of the failure never seemed 
satisfactorily explained, for ore in abundance was still produced. Probably the 
expense of transport was too great, since there was no conveyance by water 
immediately from the lake, the river **Laune** not being navigable. The works 
had now been for some time abandoned, but the steam-engine still remained. 
The rocks are schistose, very much veined with quartz; silex forming a prevailing 
constituent of the common mass. The veins of pyrites are rich, and 
commonly exhibit a play of iridescent colours. Dark-gray copper ore is also 
very conspicuous. The veins of sulphuret ore are found intermixed with the 
copper, mineralized by a similar chemical operation. Veins of calcareous spar 
are frequent, receiving occasionally a greenish tinge, from the copper mingling 


---

p.295



 
itself with the carbonic acid. The metallic schist ultimately passes into a fine-grained slate.


**Ross Island** was once extremely well wooded, and esteemed one of the finest 
spots about the lakes. It is at present one of the least interesting, except as 
an object of mineralogy. Cut off only by a narrow channel from the marshy 
shore to which it was once united, a great part of it is still a marsh, while the 
remainder exhibits nothing but low coppice-wood; and in the most rocky parts 
the rocks rise to no height above the water. The flatness of the whole line of 
shore from the river **Laune** to the **Flesk** could only be compensated by its being 
beautifully wooded. The grand mountain scenery on the other side scarcely 
wants the addition of wood; I could almost think, indeed, that its grandeur 
and sublimity would suffer some diminution from the mountains being more 
clothed. I am not sure that the axe which felled the forests of **Glenaa** is entirely 
to be held in reprobation; but rich forests can alone give grandeur to 
a country on which Nature has not impressed any of her more stately features. 
Such is **Ross Island**: covered with lofty oaks, their towering heads, their spreading 
arms, their waving foliage, would give it grace and dignity in the absence of 
other graces, nor can the ravages here made by the axe be too severely deprecated. 
Upon the whole, though there are some very fine points about the 
**Lower Lake**, I think it, though far the largest, the least beautiful and interesting 
of the three. The exploring the mines of **Ross Island** concluded this day.




---

p.296


Property of **Lord Kenmare** and of **Mr. Herbert** of Mucruss, about the Lakes. — **Lord Kenmare**'s House. — The Deer-Park. — Ruins of **Aghadoe**. — Farewell to the Lakes. — **Spenser** and the Faerie Queene. — Different Routes from **Killarney** to **Limerick**. — Ruins of **Kilmallock**. — **Kerry Head**. — Disappointments 
from bad Weather. — **Tralee**. — **Listowel**. — **Glynn**. — **Adair**. — Ruins there restored. — Tradition respecting the Fitzgerald Family. — Liberal Conduct of **Lord Adair**. — Arrival at **Limerick**.
#### 28


**Lord Kenmare** and **Mr. Herbert** of **Mucruss** are the two great proprietors 
of the Lakes and the country about them. All the islands, with the exception 
of **Dinis**, **Brickeen**, and the **Devil's Island**, in **Turk Lake**, belong to **Lord Kenmare**; the three latter are the property of **Mr. Herbert**. There are more than 
thirty in the Upper and **Lower Lake** that have names; many of these, however, 
are mere small rocks; and there are many more yet unnamed. The form 
of the **Lower Lake** is so extremely irregular, that it is somewhat difficult to say 
in what direction it runs; it is rather from the north-west to the south-east. Its 
utmost length is reckoned at seven miles, its utmost breadth at three. From 
the **Laune** river to the head of the **Upper Lake** forms a sweep, which may not 
improperly be termed a bay of mountains; and the greater part of the coasts of 
the lakes, with this district, belong to **Lord Kenmare**, continuing round nearly 
the whole of the **Upper Lake** as far as **Cromiglaun**, or **Newfoundland**, as it is 
sometimes called. From hence, the range of mountains running along the 
south-eastern side of the channel which unites the lakes, with the whole borders 
of **Turk Lake**, and those of the **Lower Lake**, from **Dinis Island** to **Cahirnane**, are the property of Mr. Herbert; — from the beginning of **Cahirnane** to the Flesk is the property of Mr. Herbert of **Cahirnane**; and then again, **Lord Kenmare** is proprietor of the lands from the north side of the **Flesk** to Prospect-Hall, the utmost point of the **Lower Lake** to the north-east. The remainder of the shores of the lake from Prospect-Hall, round again to the river **Laune**, is 


---

p.297



 
divided into several small properties. This division will be well comprehended 
by consulting **Mr. Weld**'s excellent Plan of the Lakes.


**Lord Kenmare**'s house is at the entrance of the town of **Killarney** from the Kenmare road; that is, the shortest road to **Kenmare** over the mountains, not 
that which I came, through **Glan-Flesk**. It is most extraordinary that the 
houses of both these proprietors, each of whom had such choice of lovely spots, 
should be fixed in a part of their respective domains the most unfavourable for 
seeing the beauties that surround them. **Lord Kenmare**'s house stands on a 
perfect flat, having nothing in front but an avenue of trees, running in a contrary 
direction to the lake. The house makes very little show as to its exterior, nor 
is there, as I am informed, any aim at splendour within; it is a comfortable 
gentleman's house, and no more. I did not go into it. His Lordship has a 
very fine collection of engravings of Irish scenery from every part of the island, 
but he does not permit their being shown when he is absent; and he was at 
this time at Brussels with his brother, who had been dangerously wounded in 
the battle of **Waterloo**. That the house should be placed in such a situation 
is the more extraordinary, since there are many spots in the grounds whence it 
would have commanded a fine view over the lake. The deer-park is half a 
mile out of the town, in a contrary direction, on the road to **Castle Island**; and 
here also fine views over the lakes might have been obtained. Some parts of 
this park are well wooded, and through a fine rocky glen runs the river **Deanagh**, 
whence it pursues its course to the lake through the grounds about **Lord Kenmare**'s house. Walks are made about this glen; and in a grove at the end of 
it are some of the tallest and most erect fir-trees I ever saw; squeezed too 
closely together to admit of their having branches, these trees stand like so 
many masts of ships ready prepared. The dell and grove are the most striking 
features of the deer-park: it was of a very large extent, but a part has been let 
off of late years to Mr. Cronan, who has an estate contiguous to it. This park 
and the ruins of **Aghadoe** were the last two objects that I visited before I bade 
adieu to **Killarney**.


The abbey and cathedral of **Aghadoe** were among the most celebrated of 
ancient days. The ruins of them stand upon the highest ground north of the 
lake, and are conspicuous objects from many points in rowing about it. Here 
was once, as the cathedral denotes, a bishop's see; and it is now distinguished 


---

p.298



 
as one among the Catholics, they having still a titular bishop of **Aghadoe**. 
The abbey is supposed to have been founded as early as the sixth century: in 
a record of the abbey of Innisfallen, dated in the year 1231, it is styled the old 
abbey of **Aghadoe**. The only vestiges that remain are parts of the church, very 
much overgrown with ivy; of these, the best preserved is the arch of the western 
door; it is in the style called Saxon, and resembles very much that to the 
little chapel on the island of **Innisfallen**. A remarkable thing in both is, that 
the door-cases are a red sandstone, a species of stone not known at present to 
be any where near this neighbourhood. I have mentioned finding it about 
**Glengariff**, but that is five-and-twenty or thirty miles distant, computing by the 
nearest route. This, no less than **Mucruss Abbey**, is a favourite place of interment 
among the Catholics, and the graves extend a considerable way from 
the church to the south, even going along the road-side; I suppose, however, 
it is well ascertained that the canoniz'd earth extends thus far.


Very near the church stands a small fragment of a round-tower, scarcely 
twenty feet in height, and appearing in such a state of decay that it will probably 
soon be entirely mouldered away. At a little distance, in a field, is part 
of another tower, called by the people of the country The Pulpit; but, though 
round, of a very different description from the round-tower properly so called. 
It is very similar to what are to be seen in such places of antiquity in England 
as have any remains of their ancient walls. Round Norwich many of these 
towers are still standing, and many more were so within a few years. As 
 **Aghadoe** was certainly a place of great importance in ancient days, might it not 
be walled round, and might not this be a tower of defence in the walls? From 
the hill which is the site of these ruins, there is a good view over the **Lower Lake** and its shores; many people reckon it the best within the circuit: with 
this I do not agree. The hill itself is ugly, having no wood about it, while the 
sides are broken into small inclosures surrounded with stone fences; and over 
this viewless kind of view the eye is first carried before it reaches the lake. As 
a bird's-eye view, none appears to me so good as the spot in **Lord Kenmare**'s grounds, whence I had first an actual survey of those scenes, till then only 
spread before me in imagination.


In visiting **Lord Kenmare**'s deer-park and the ruins of **Aghadoe**, I completed the range of all the leading objects which claim attention in this celebrated spot. 


---

p.299



 
Upon the whole, I had passed five days here, a sufficient time for obtaining a 
general idea of the scenery; — to examine all its beauties in detail, five weeks 
would hardly more than suffice. But to devote any thing like that time to it 
was wholly out of my power; and as I did not perceive that much would be 
gained by only an additional day or two, which was all I could have given, 
I determined to proceed on my way the same afternoon, the sixth from my 
arrival. Indeed, I know not any country where three or four months might 
be spent with greater pleasure and advantage than in exploring this whole southwestern corner of **Ireland**. But it must be by one whose mind is particularly 
attuned to the task; — whose delight in searching out the wonders and beauties of wild nature is superior to feeling the petty hardships and inconveniences 
inevitably attendant upon rambling over a country thinly inhabited, and little 
frequented by travellers; where good inns, or indeed any inns, are not to be 
expected at every ten miles: — not alone about the Lakes of **Killarney**, but in 
many other parts, beauties would probably be discovered of which at present 
no one has any idea. Formerly, visitors to these parts confined themselves 
entirely to the Lakes; their beauties explored, no one thought of extending their 
rambles further. Circumstances have now brought the **Bay of Bantry** much 
into notice, and **Captain White** has shown that it is capable of being made to 
exhibit beauties no way inferior to the Lakes. Indeed, as a single thing, I should 
be tempted to say that there is nothing at the Lakes equal to **Glengariff**; the 
superiority of the Lakes lies in the collected attractions which it presents. Of 
them as a whole, I think it may be said with truth, that their beauties can 
neither be exceeded nor exaggerated; nor is this my own feeling only, I have 
never found any writer who has treated of the subject express disappointment 
on seeing them, how highly soever their expectation had been raised; neither 
did I ever hear any body who mentioned them, evince any feeling to that effect. 
A sentiment so general can hardly be a mistaken one; each by whom it is entertained 
bears testimony to its correctness in his neighbour. **Sir Richard Colt Hoare**, who had been a great traveller, and had therefore strongly the 
power of judging them not only abstractedly, but by the more forcible medium 
of comparison, says: *The collected beauties of this favoured spot are so great, 
so varied, and so superior to any thing I have yet seen either in **Italy**, 


---

p.300


**Switzerland**, or **England**, that they can neither be delineated nor described; to he felt, they must be seen.’’*


**Mr. Weld** thinks that **Spenser** the poet must have been a frequent visitant 
at the Lakes of **Killarney** while he was writing his Faerie Queene, and have had 
its scenery impressed on his imagination in many of the beautiful descriptions 
with which that poem abounds. He was then resident at **Kilcoleman**, a castle 
in the county of **Cork** belonging to the Earls of Desmond, only forty miles 
from **Killarney**, so that the idea seems extremely probable. That **Spenser** was 
very fond of **Ireland** is shown by the motto given in the title-page of this work. 
**Dr. Smith** thinks the scenery about the castle in which he wrote was sufficient 
to inspire him. He says: "Two miles north-west of **Doneraile** is **Kilcoleman**, 
a ruined castle of the Earls of Desmond, but more celebrated for being the residence 
of the immortal **Spenser**, where he composed his divine poem The Faerie Queene. The castle, now almost level with the ground, was situated 
on the side of a fine lake in the midst of a vast plain, terminated by the **Waterford mountains** 
 to the east, by **Ballyhowra hills**, or as **Spenser** terms them 
the mountains of Mole to the north, by the Nagle mountains to the south, and 
to the west by the mountains of **Kerry**; so that the view extended half the 
breadth of **Ireland**. When the adjacent uplands were wooded, it must have 
been a most pleasant and romantic situation, and no doubt **Spenser** drew from it several parts of the scenery of his poem." It is most likely that his descriptions were not borrowed from either solely, but that he was furnished with ideas alike from both.


If it may appear extraordinary that of scenery which presents so many beautiful 
pictures, of which almost every spot is a beautiful picture, I have not given 
a single sketch — I have many reasons to adduce for the omission. In the first 
place, it has rather been my aim to place before the reader, views of objects 
less known, and which have not been so often made subjects for the pencil. 
In the second place, it is not by views of single detached parts that any idea 
can be formed of the Lakes of **Killarney** as a whole; and it is in contemplating 
them as a whole that their beauties appear the most striking; in considering 
how much variety of beauty is comprehended within, comparatively 
speaking, so small a space. In the third place, every thing that the pencil 


---

p.301



 
could do in delineating the beauties of these lakes has been done so ably by 
**Mr. Weld**, that he has scarcely left any thing to be added by those who come 
after him; — they can hardly appear other than his copyists.


Having taken my last look over the lake from the hill of **Aghadoe**, about 
three o'clock I set out for **Tralee**. Three roads go from **Killarney** to **Limerick**, 
not varying much in distance; my only doubt respecting which I should take 
was between the most eastern and the most western; the middle road was 
left entirely out of the question. It runs through **Castle Island**, **Abbeyfeale**, 
and **Newcastle**, over a mountainous country presenting no striking or marked 
features, the inns on the road being very bad. The most eastern passes through 
the town of **Kilmallock**, a place of great curiosity to travellers from the vestiges 
of former greatness which it exhibits, and which have given occasion to 
its being frequently called the *Balbec of Ireland*. Of this town an ample account 
is given in **Sir Richard Colt Hoare**'s Journal, and to that I refer the 
reader, since he saw and examined the ruins, and I did not. A friend of mine, 
when I was coming this second time to **Ireland**, said to me, "I charge you 
do not omit seeing the ruins of **Kilmallock**, there is scarcely any thing in **Ireland** 
so interesting." I pondered, therefore, much upon taking this route: but 
I have said that the striking works of nature in this country, its fine scenery 
and mineralogical productions, were much rather the objects of my researches, 
than the productions of art either ancient or modern, and this it was which 
now determined my choice. In taking the most westerly road I thought I could 
include a visit to **Kerry Head**, the southern point at the mouth of the **Shannon**, 
where a noble scene presents itself. The river is here eight miles over, having 
fine bold rocks at each point of the channel, where it unites with the ocean. 
The force of the waves has excavated vast caverns in the rocks about **Kerry Head**, into which, in stormy weather, the sea beats with such tremendous force, 
that the noise may be heard for some miles. One cave in particular is more 
remarkable than the rest for the amazing roar which the waters make in rushing 
in, and to this is given again the name of **Poll-a-Phuca** or the **Daemon's Cave**. 
Among the rocks about **Kerry Head** are found abundance of the crystallizations 
which are celebrated as Kerry amethysts. Such objects were more attractive 
to me than the ruins of **Kilmallock**, and I resolved to devote a day to them, 


---

p.302



 
going from **Tralee**, which is about fifteen miles from the Head, and returning 
thither again at night.


I had been upon the whole exceedingly favoured by the weather while at 
**Killarney**, and left it in as fine an afternoon as could be seen. On arriving at 
**Tralee**, I made my arrangements for the proposed excursion, not having then 
the least idea of the weather interposing to baffle a scheme on which I had fixed 
my mind rather eagerly. But on the morrow when I awoke, I found the rain 
pouring down in torrents, and the atmosphere so loaded with clouds that little 
hope could be entertained but of its continuance. In deep sadness did I contemplate 
this very unexpected transition. What was to be done? — To go on 
an excursion, in which the principal object was to see a noble view, under circumstances when any object a quarter of a mile distant was completely shut 
out, would be a downright absurdity; and though I was eager to see **Kerry Head**, I did not wish to do a thing very absurd. Should I then wait at **Tralee** 
that day in hopes of better fortune the next? — this was a day in every way completely lost, and I did not wish to waste my time. I waited till ten o'clock, I 
saw no chance of amendment in the weather, and I then determined to give up 
**Kerry Head**, and proceed on the way to **Limerick**.


The road from **Killarney** to **Tralee** is dull and dreary till very near the latter 
town, when the view of it, with the bay on which it stands, gives a little variety to 
the scene. The bay is a very indifferent one, shoaly, and will not admit vessels 
of any size. Vast numbers of herrings are taken in it in the fishing season.


A castle still remains at **Tralee** which was the ancient possession of the 
Earls of Desmond: during the troubles in which that family were involved in 
the reign of **Queen Elizabeth**, and which ended in their final extinction, the 
town suffered very severely. It had originally four strong castles; three have 
been entirely demolished. There was also an abbey here for Dominican friars, 
founded in the thirteenth century, of which no traces remain. The Knights of 
Saint John of Jerusalem had moreover an establishment here. The town suffered 
very severely in the Great Rebellion, and again in the wars of James the 
Second, so that in rising from so much ruin and devastation little appearance 
has been left of the real antiquity which it boasts. Many new houses have recently 
been erected, and I found an extremely good inn, as far as clean and 


---

p.303



 
comfortable apartments were concerned; but one of the most tedious and tormenting 
in all **Ireland** for getting any thing that was wanted: not less than an 
hour elapsed after I had ordered tea and eggs before they appeared; the people 
here practised what had been threatened at **Glen Molaur**. This is considered 
as the principal town of the county of **Kerry**.


The road continued dull and uninteresting, or at least the heavy rain made it 
appear so. **Listowel** is the first stage, a town on the **Feal**, having a handsome 
bridge over that river. It is rather remarkably situated upon a steep eminence, 
rising on a sudden from a wide-extended flat; and the remains of an old castle 
frowning over the brow of the height give it a striking appearance in approaching 
it. This castle once extended a considerable way; the principal part that remains 
is a gateway, a lofty circular arch, between two lofty round-towers. From 
hence we proceeded to **Glynn** on the **Shannon**, where were to be our night quarters. 
For a long way beyond **Listowel** there is a dismal dreary bog without 
an object of any kind to excite interest. At length at Tarbert we came upon 
the bank of the **Shannon**; the rain had by this time ceased, and a gleam of 
tolerable weather afforded an opportunity of seeing the really fine view presented. 
The village is neat and pretty, and opposite to it in the **Shannon**, which 
is here a great width, is a pretty wooded island. The road continues close by 
the river side from hence to **Glynn**: this is rather a pretty town, sloping up from 
the river side; close by it is the castle of the Knight of **Glynn**. An old castle 
once occupied the spot, but now, though retaining the name of a castle, it is a 
modern-built house. 


The weather was not such the next morning as to give me any occasion for 
regret that I had not stopped the day before at **Tralee** to take my chance of a 
more propitious moment for **Kerry Head**. I set out again from **Glynn** in a heavy 
rain, which continued the greater part of the way till we got to **Adair**, a long 
stage of sixteen miles. Having then ceased, I had an opportunity of going over 
some of the numerous ruins for which the place is celebrated. The country here 
is somewhat improved, and just about **Adair** is well wooded. This town was in 
former times of great note, and was among the very large possessions of the 
Desmond family; it is now the property of **Lord Adair**, who has here a house 
*and* very extensive park, but it is much more to the vestiges of former grandeur 


---

p.304



 
that it is indebted for being of any note. There are the remains of four abbeys 
and a castle. Two of the abbeys are in **Lord Adair**'s park, and I did not see 
them. The best preserved is at the entrance of the town from the **Limerick** 
side, it is close to the river **Maig**. Over this river is a bridge of an irregular 
form, making a sort of curve; it brought to my recollection some of the ancient 
bridges in the South of **France** ascribed to the Romans, which form almost an 
angle in the centre. Not that this bridge at **Adair** is of a similar construction; 
its curvature brought them to my mind, yet I scarcely knew why; there is 
hardly sufficient resemblance for the one to recall the other.


The abbey is supposed to have been founded in the year 1315, for Augustine 
friars. Of this there were very large remains, and **Lord Adair** has generously 
given the whole pile to the use of the parish. The church, of which 
the greatest part was left standing, has been fitted up as a parish church; 
every thing that was wanting has been restored in a style perfectly to correspond 
with the ancient work, and the pews are all of fine old oak. All **Ireland** can 
hardly boast so handsome a village church. Another part of the building 
which joined to the cloisters is fitted up for a school-room; the cloisters are in 
good preservation, and are not to be touched. Such is the durable nature of 
the stone, a hard gray limestone, and of the work, that wherever any part of 
the wall is to be pulled down, which is done as sparingly as possible, it is a 
task of labour and difficulty. Over a gateway going into the building converted 
into a school-room, the master workman, who as well as the parish clerk 
walked about with me, putting aside a long pendant mass of ivy, showed me 
the Fitzgerald arms with the crest, a monkey, and the supporters, monkeys, 
and then proceeded to relate the origin of this crest and these supporters; to 
which I listened attentively, though indeed I had heard it before. He said 
that many years ago, a castle belonging to the family being on fire, the people 
were hurrying about in great confusion, endeavouring to save what was most 
valuable. Among these valuables, however, the heir of the family, a child 
in a cradle, was not thought of, and he had been left to perish in the flames 
but for the greater attention of a monkey. He took the child from the cradle 
and ran up with it upon the battlements; the fire had then got such complete 
possession of the interior that it was scarcely any longer safe to venture within, 


---

p.305



 
The people were looking on amazed and confounded, when they perceived the 
monkey holding the child up and showing it to them. They were all thunderstruck 
at finding it had been neglected; when one, more courageous than the 
rest, rushed into the castle again, though all present thought he was hastening 
to inevitable destruction, and making his way up to the battlements 
brought both child and monkey away in safety. In grateful memorial of the 
service rendered by the animal, monkeys had ever since borne the conspicuous, 
place they now hold in the family arms. — The man then directed my attention 
to the remains of an old castle by the river on the other side and a little way 
from the road, and said that some people believed that to be the castle where 
this circumstance had happened, and that it had been in ruins ever since; 
others said that it happened at a castle in the county of **Kildare**. — Whether 
this tradition has its foundation in matter of fact I do not know: it is very 
generally told, and asserted for fact, nor is there any thing in it which offends 
against credibility.


In the centre of the village are the remains of another abbey, the church of 
which **Lord Adair**, with a truly liberal spirit, has given to the Catholics for 
their use; it is all covered in, but the Catholics are poor, and have not the 
means of bestowing much money on their churches, so that the new work is 
mere common masonry; the side to the street and the door of entrance are, 
however, in good preservation, and make a handsome appearance. It were 
much to be wished that **Lord Adair**'s example may be followed in more than 
one point of view; in rising superior to the distinction of Catholic and Protestant, 
and seeing in all around him fellow-creatures and fellow-christians, 
though not exactly agreeing in all points of religious belief; — while it is equally 
desirable to see these ancient remains restored as much as possible to their primitive 
state, and rendered alike objects of ornament and utility in the country. 
Where there are remains wanting so little to restore them as has been found 
necessary at **Adair**, 'tis pity they should not be restored; the objection to 
touching them is, when some vile ordinary piece of patchwork is to be added to 
them in a style wholly foreign to the original building, to employ them perhaps 
for some very vile purpose. The town of **Adair** suffered severely in common 
with all the possessions of the **Earl of **Desmond**** in the conflicts which he 


---

p.306



 
sustained against **Queen Elizabeth**. At the confiscation of this nobleman's 
property, these abbeys being then extremely rich, were granted to **Sir 
Henry Wallop**. In the grant, mention is made of their houses, tenements, 
burgages, parks, gardens, arable and pasture lands, water-mills, fishing-weirs, 
&c. &c.


From hence to **Limerick** the country is well cultivated, but affords no object 
of particular interest or deserving of remark. At **Glynn** the road takes a direction 
distant from the **Shannon**, and that river is seen no more till near **Limerick**. 
The approach to the town presented nothing striking.




---

p.307


Division of the City of **Limerick**. — The Course of the **Shannon**. — **Newtown-Perry**. — The Cathedral. — Sieges sustained by the Town. — Limerick Gloves. — Monastic Institutions. — Bad Weather. — Attack of the Mail-Coach beyond 
**Cashel**. — The **Bog of Allen**. — **Hill of Allen**, the Scene of Ossian's 
Temora. — Number of Ruins in the County of **Tipperary**. — **Kilkenny**. — Visit to a Nunnery there. — Lord Ormond's School. — Cave of **Dunmore**. — **Castlecomer** . — The Collieries. — **Carlow**. — Return to **Dublin**.
#### 29


**Limerick** was a long time considered as the second city in **Ireland**: of late 
years it has been superseded by **Cork**, and thrown one degree lower in the 
scale. It consists of two distinct parts; the English and the Irish town. The 
former stands upon an island of the **Shannon**, and is connected with the latter 
by a bridge, called Baal's Bridge by some, O'Brien's Bridge by others: I know 
not which is its proper name. It has thirteen arches, like all old bridges very 
small. The channel which it crosses is not the main stream of the **Shannon**; 
that runs on the other side of the island, upon which the English town 
stands, while the branch alone passes through **Limerick**. It is, however, of 
sufficient importance to admit vessels of five hundred tons burthen up to the 
town.


The course of the **Shannon** is somewhat remarkable. Its head is **Lough Allen**, in the county of **Leitrim**, so near to **Sligo Bay** that the river almost converts 
into an island all that western part of **Ireland** which lies between the 
above-named bay and the **Shannon** mouth. During the whole of its course, 
which is nearly two hundred miles, it is constantly expanding itself into large 
lakes, or dividing its channel and forming islands. **Lough Allen**, from which 
it issues, is a lake thirty miles in circuit: **Lough Ree**, through which it next 
flows, is fifteen miles in length; and **Lough Derg** is larger than either. The 
**Shannon** has now communication with **Dublin** from two different parts, by 
means of the **Grand Canal** and the **Royal Canal**. If the district by which it 


---

p.308



 
flows were small, it would be called a peninsula; but it is so large, that the 
idea how nearly it is insulated scarcely strikes.


To the two former divisions of **Limerick** a third may now be added, in the 
vast additions made of late years towards the south-west, under the name 
of **Newtown-Perry**. These buildings were begun about fifty years ago, by 
the permission and under the patronage of **Lord Perry**, a part of the old 
walls of the town being thrown down to make way for them. Here the 
streets are wide and regularly built; the houses good, but built of red brick. 
There are as handsome shops as can be seen even in **London**. But the old 
town is one of the most frightful, the most filthy places in all **Ireland**. True, 
I saw it under every possible disadvantage . The rain, which had kept off for 
some hours, began to come on again very soon after I commenced my walk 
about **Limerick**, and the streets were almost ankle deep in mud: this, however, 
would not have been if it were a generally clean town.


My principal object in going into the Old Town was to see the cathedral. 
Indeed it scarcely furnishes any other object worth seeing. This is a fine old 
building, one of the best **Ireland** has to show, at least as far as my knowledge 
goes. It is a Gothic structure of the thirteenth century, built by *Donal* O'Brien, then king of **Limerick**. It has never been suffered to fall into a dilapidated 
state, but has been constantly kept in good condition. Much were it to 
be wished that it were better placed; but it is squeezed into such a poking kind 
of corner, and so beset with miserable buildings patched upon it, that the way to 
it is found with difficulty. The choir is handsomely fitted up. In doing some 
repairs to the roof, not many days before I was in the church, a cannon-ball 
was found deep within one of the spars, which must have lodged there in some 
of the sieges the town has sustained, and was never before discovered. In the 
time of **Oliver Cromwell** it was besieged by **Ireton**, who was repulsed in several 
attacks, and would in all probability have been compelled ultimately to abandon 
the siege, had not the daemon of discord found his way into the town, and 
insinuated himself among the inhabitants: — animosities arose among them: 
some declared in favour of the Pope's Nuncio, some in favour of **King Charles**, 
and some were for surrendering to the English army. A house divided against 
itself cannot stand, — and **Limerick** fell. **Ireton** entered and took possession 
of it: but here ended his career; he died there in a very short time. In 1690 


---

p.309



it was besieged by **King William**; but he found so powerful a resistance, that 
he was obliged to abandon the siege. The next year **General Ginckel** succeeded better, and reduced it to submission.


On the quay is a very handsome custom-house, with docks, at which the 
ships unload their cargoes. There is a house of industry somewhat singularly 
situated, running as it were into the river. Flourishing linen, woollen, and paper 
manufactories are carried on here; and a great deal of ship beef and pork 
is salted. The reputation of this place for gloves is well known; but I found 
that there are many more Limerick gloves manufactured at **Dublin** and at **Cork** 
than in **Limerick**. For my own part, I think their reputation is rather, if I may 
be pardoned a familiar expression, great cry but little wool; I could never find 
in what their great superiority consists. This I know, that at **Cork** I was asked 
five shillings a pair for **Limerick** habit-gloves, while for very excellent ones not 
so called I paid half that price. There is a great manufactory of gloves at 
**Cork**, and most excellent ones; the kid leather very nice, and the work particularly 
good. I suspected them at first to be French, smuggled into sale in 
this way; but I was assured by persons of credibility that they were not so.


There were formerly a great many monastic institutions at **Limerick**. King 
*Donal* O'Brien, who founded the cathedral, founded also a convent for black 
nuns of the Augustine order.  **Edward the Third** took this convent under his 
especial protection. A priory for canons regular of St. Augustine was founded 
in the reign of **King John** by a citizen of the town, **Simon Miner**. It stood near 
**Baal's Bridge**. A sumptuous monastery of Dominicans was founded in 1240 
by another O'Brien, king of **Thomond**, which was endowed with very large 
possessions in and about the city. All these possessions, at the suppression 
of monasteries, were granted to the **Earl of **Desmond****, at a yearly rent of five 
shillings. Another O'Brien, in the reign of  **Henry the Third**, founded a monastery 
of gray-friars. This stood just without the wall of the town; and, with the priory of St. Augustine, was granted by  **Henry the Eighth**, at the suppression of monastic institutions, to  **Edmund Sexton** a citizen of the town, at 
an annual rent of two shillings and sixpence. No vestiges of any of these monasteries remain. There is a convent of nuns now in the town, but not inhabiting 
any of the ancient religious houses. I would have gone to see it, but being Saturday no strangers were admitted. Three other bishoprics, formerly 


---

p.310



 
distinct sees, have been at different times incorporated with this; those of **Inis-Catha**, **Ardfert**, and **Aghadoe**.


Had it not been for the continued bad weather, I believe I should now have gone to **Kilmallock**, and from thence to **Tipperary**; it would only have made a 
circuit of about eight miles in going to the latter place. But such was the morning in which I set off from **Limerick**, and such had been the weather now 
for three days, that I began to think my good fortune in this respect had wholly 
forsaken me, and that nothing remained but to hasten back to **Dublin** as fast as 
possible. I accordingly pursued my route this day through a never-ceasing 
rain from **Limerick** by **Tipperary** to **Cashel**. I will not say any thing of the 
country; it seemed to me the most dreary and dismal imaginable. At **Tipperary** 
I first heard of the disturbances which just now commenced in these parts; 
only two nights before the Mail had been attacked on the other side of **Cashel** 
by a very desperate gang, and a soldier had been killed. I did not, however, 
from this first account at all understand the nature of the attack, but thought 
its object had been to rob the passengers.


On arriving at **Cashel**, I found that the attack had been of a much more serious 
and alarming nature: it took place on the other side of **Littleton**, which 
is about eight miles from **Cashel**; and the object was not so much to get money, 
as arms. Two guards always attend the mails in **Ireland**: there were besides 
at this time two dragoons travelling on the outside of the mail, and two 
sailors, one of whom was for some purpose, I do not recollect what, charged 
with a large sum of money. Very different accounts were given of the number 
of the assailants; the truth was, that in such a scene of terror, tumult, and 
confusion, it was impossible for any one to give a probable guess at their numbers; some estimated them at about fifteen or twenty; others computed them 
at fifty: that they were a strong party was certain. The attack was begun by 
firing at the leading horses, one of which was so desperately wounded that it 
fell immediately, and thus was the coach effectually stopped. A desperate 
conflict then ensued, in which one of the dragoons upon the top of the coach 
was mortally wounded, and one of the guards very severely. The sailor who 
had the money about him seeing the leading horse fall, with astonishing presence 
of mind leaped from the top of the coach, and having an immensely 
strong clasp-knife in his pocket, cut the traces of the leaders, when, giving a severe 


---

p.311



 
lash to that which remained alive, he ran away, dragging after him his 
poor wounded companion. The coachman, thus freed from the embarrassment 
of the fallen horse, whipped on the two remaining ones and set them into a 
gallop, by means of which they soon got clear of the assailants. The sailor 
who had done this important service, amid the scene of confusion stole unperceived 
away, and lying down in a dry ditch under a hedge by the road side, 
there remained awhile till the gang were dispersed; when, creeping into a cornfield, 
he remained concealed there till morning; then thinking himself in safety, 
he went on to **Littleton**, having not only saved himself, but all his money. Till 
his safety was known, the utmost anxiety was experienced by every one on his 
account lest he had fallen into the hands of these desperadoes, which to him 
must have been certain destruction. A reward of fifty pounds was afterwards 
given him by the Government.


It may easily be guessed in what state the whole company in and about the 
mail must be when they arrived at **Littleton**, between two and three miles from 
the scene of action. The wounded dragoon and guard were left there, where 
the dragoon died in a few hours; he had been interred the very morning that I 
was at **Littleton**. No attempt was made by the assailants to demand money; 
they demanded only the surrender of the arms. Such a story was not to be 
heard unmoved; no one could have heard it with indifference two hundred 
miles from the spot where it had happened, and two years after; but to think of 
being then but a few miles from it, that I was the next morning to pass over it, 
that the affair had happened only two nights before, occasioned a feeling not 
to be described. It was not apprehension for my own safety, I did not consider 
that as in any clanger; I was not to travel by night; I had no arms to excite 
the desires of those unhappy wretches: — I know not what it was, but my 
mind was wholly untuned to thinking of any thing else; nothing was present to 
it but the idea of the shocking scene which had passed, and the inevitable consequences 
with which it must be attended. That the situation of the lower 
classes in **Ireland**, and particularly in this part of the country, was very deplorable, 
could not be doubted; but who could witness without deep regret the 
mistaken, the perverted notions they had adopted of the means by which it was 
to be ameliorated? Such violence must be repelled by violence; and the consequence 
ensued, which was reasonably to be expected, that martial law, that 


---

p.312



 
law without law, was soon after proclaimed here. Devoted **Ireland**! are these 
things never to be otherwise? — I came to **Cashel** to see the celebrated rock and 
the venerable remains of antiquity with which it is crowned, but I could now 
see nothing except the increased sufferings which the country had prepared for 
itself; I became indifferent to every thing else, and I thought only of quitting 
scenes which seemed surrounded with nothing but gloom and horror. I saw 
the rock and the ruins at a little distance, as I entered the town, and as I quitted 
it they presented but new ideas of devastation, and I passed on.


Yet for one moment I felt an impulse to stop the carriage and ascend the 
rock. The rain had ceased in the night, the morning was fine, the sun was 
shining upon the mouldering towers and turrets, and they assumed an air of 
magnificence which methought ought not to be passed by. The next moment, 
however, the idea that though the heavens were bright and clear, all was gloom 
in the moral atmosphere, came too forcibly over my mind to be repelled, and I 
pursued my route. At present my feelings upon this occasion seem strange to 
me, they seemed so in a few hours after, but at the moment they were irresistible. 
I have often asked myself since, why I did not see the ruins of **Cashel**, — I could never answer the question satisfactorily.


One thing I must observe, that I was wholly disappointed in the situation of 
these ruins. I expected to have seen them crowning an enormous mass of dark 
towering craggy rock; I had figured to myself something like the towering 
height on which stands the fortress of **Notre Dame de la Garde**, near **Marseilles**; 
I saw what should rather be termed a green knoll than a rock; a smooth 
eminence covered with green sod, the height by no means considerable. It is 
nothing to the hill on which stands the fine old castle at **Norwich**.


At **Littleton** where I breakfasted, every tongue was still occupied with the 
same tale: the funeral of the soldier had just taken place, the wounded guard 
was then in the house, — I saw him not, but I knew he was there; it was impossible 
not to shudder at the situation in which he had been so recently. The 
driver stopped when we came to the spot where the dreadful scene had passed, 
and pointed it out to me; it was just within a sort of lane formed by inclosures, 
at the verge of a wide extent of bog, part of the great **Bog of Allen**. I was glad 
when we had passed it, and tried to think of the thing no more. The only truly 
dismal day that I passed during my two excursions, was that from **Limerick** to 


---

p.313


**Cashel**; the weather was bad, the country dreary, and the latter part of the 
day this story was dwelling on my mind. But enough of it.


The **Bog of Allen** extends over an immense tract of country in the centre of 
Ireland. I never heard any attempt at a computation of the number of acres 
it contains, but it occupies parts of nine different counties; those of **Kildare**, 
**Meath**, **Westmeath**, **Longford**, **Roscommon**, **Galway**, **Tipperary**, and the 
King's and Queen's Counties. What immense forests must have been submerged 
to have formed such a tract! if, as seems the strong probability, all 
these bogs are submerged forests. At the edge of it in the county of **Kildare** 
is the **Hill of Allen**, the scenery of which, at this moment, accords so perfectly 
with what is described in the Temora of Ossian, that many people say, if Ossian 
did not take his descriptions from it, **Macpherson** must. There is in the 
declivity of the hill a natural cave, where the traditions of the country now 
say that Oscar lay after his death guarded by his faithful dog Bran; near the 
cave is a well which is called Oscar's Well, and at the foot of the hill is a stream 
called Dorthula. But **Mr. Laing** in his edition of **Macpherson**'s works says 
that the latter had no other authority for his poem of Temora but an old Irish 
ballad; that all he says of his friends having collected for him in the Highlands 
the broken and scattered fragments of the poem, is so much a flight of imagination, that he might well be supposed to have kissed the Blarney Stone. If 
an Irish ballad was indeed the foundation of the poem, it is not extraordinary 
that the localities, the scene being laid in **Ireland**, should be accurately 
described.


No part of the country that I passed over abounds in ruins like the county 
of **Tipperary**; the eye is perpetually presented with them, there is scarcely a 
moment without some in sight. I am informed, however, that it yields much 
to the county of **Galway**, that there they are even more frequent. The noted 
ruins of **Holy-Cross Abbey** are in the county of **Tipperary**. At a small village 
between **Cashel** and **Kilkenny** is a church, which attracted my attention very 
much as I was walking about while the horses were baiting for half an hour. 
The church is a new built one; but at the west end is an archway extremely 
similar to those of **Innisfallen** and **Aghadoe**, very perfect, but with very little 
of the old wall remaining round it, and against this the new church is built; 
not including the archway in the new wall, but leaving the old part projecting 


---

p.314



 
from the new, strengthened and supported by it, the door-way in the new wall 
being made exactly to correspond in size with the old one, so as to leave that 
the entrance to the church. I could not make out the name of this village; I 
inquired it of the driver, but he spoke so unintelligibly that I could not comprehend 
what he said; it is seven miles from **Kilkenny**.


I arrived at **Kilkenny** about three o'clock, and stopped at the Castle, according 
to my invitation, the remainder of that day and the next. I had the 
pleasure of meeting a large dinner-party on the day of my arrival: I had always 
heard the society of **Kilkenny** represented as exceedingly pleasant, and so I 
found it I went with Miss Ryan the sister of Dr. Ryan, whom I have mentioned 
before, to visit a convent of nuns; the sisters were twelve in number, whose 
time was principally devoted to the education of poor girls. They had a very, 
large school, I think nearly a hundred, who were entirely instructed by them; 
the children were all very industriously employed, and looked clean, healthy, 
and happy. The nuns have a nice and spacious garden, beyond which they 
never stir, and they seemed all perfectly comfortable and happy; none among 
them were very young, they were all forty or upwards. What struck me much 
was, that living thus retired from the world I never saw people more inquisitive 
for news, or more anxious to know what was going forward in the world. At 
**Kilkenny** I saw filberds which I think must have been from trees planted by 
Fin Mac Cool and his giant race, for they were truly giants of their kind. 


From hence **Mr. Barwis** very obligingly accompanied me to the collieries at 
**Castlecomer** , stopping by the way to see the celebrated **Cave of Dunmore**. 
On the subject of this cave the author of The Post-Chaise Companion becomes 
quite poetical. "When you approach the cave," he says, "which is situated 
in the middle of a spacious field, a prodigious flight of birds of different species 
darken the air by their numbers. The passage into it is down a square hole, 
or rather precipice, upwards of sixty feet deep by twelve wide. At the bottom 
thereof is the mouth of the cave, which is but low, arched with rocks, 
seemingly dropped on the head, where from a number of petrifactions, like 
icicles, there falls a vast quantity of drops of limpid water, which also petrify 
into clear crystal lumps upon the rocks whereon they fall; they are white, and 
nearly transparent. On entering the mouth of the cave, a sudden chillness 
seizes all parts of the body, and lights which are brought hither burn red and: 


---

p.315



 
dim as in a thick fog. From this entrance, by the help of flambeaux, you 
turn to the left, and descend over a multitude of rocks, till you come to a 
slippery ascent, where the constant dropping from the earth at top hath 
formed a kind of steps. After you pass the first rising, the shining of the petrified 
waters presents a variety of objects by no means unpleasing, and bearing 
a near resemblance to the works of art; such as organ-pipes, cylinders, inverted 
pyramids, and ten thousand other figures. From hence you proceed 
forward on a slippery footing, to a passage so low and narrow that you must 
creep through it. You then come into a wide open space where the cave is 
prodigiously enlarged, and the roof or top exceedingly high. Your voices 
echo as in a church, to which this part of the cavern bears a striking resemblance; the bottom is smooth, except where some pillars formed by nature 
appear; in many places skulls and human bones are set in the crystalline substance. 
After you have walked a considerable way further, you behold a 
broken and uninterrupted scene, made up of an infinite variety of inequalities 
or rocks over head, some threatening desolation on the spot, whilst others 
seem to be more fixed and secure. This amazing and difficult meander over 
rocks and precipices, leads you on for about a quarter of a mile, when you 
are agreeably entertained by the murmurings of a subterranean river, which 
rolling over tumbling stones, and falling over rocks, forms a strange kind of 
noise in that hollow cavern, but how far it extends none has been so bold as to 
attempt discovering."


 The Traveller's Guide is less diffuse upon the subject: it only says; "Near 
the ruins of **Dunmore Castle** in an open field is a cave which extends more 
than a quarter of a mile, as far as it hath been explored, for no adventurer hath 
yet attempted to penetrate it farther, as the rumbling of a subterraneous current, 
reverberating through the awful silence of terrific gloominess and pitchy 
darkness, gives a solemn warning of approaching peril, and perhaps inevitable 
destruction. It is as remarkable for its petrifactions as for its magnitude." While I was at **Dublin**, I was talking to a gentleman about this cave. "By no means," he said, "ever think of going there:" and he then told me the following 
story. — "Three officers who were quartered in the neighbourhood, having 
heard much about the cave, agreed to go and explore it. They took lights with 
them; but after they had gone some way the lights were in a moment extinguished, 
 


---

p.316



 
 and they were left in utter darkness. At the same moment they heard 
the noise of rushing water. They turned back, as they thought, and attempted 
to grope their way to the entrance of the cavern; but the noise of the water increased 
at every moment, seeming as if it was almost at their feet. In the utmost 
terror they sat down upon a piece of rock which they felt beside them, and 
gave themselves over for lost. In the midst of such impenetrable darkness it 
was impossible to know which way to turn to get out of the cavern, and the 
sound of the water seemed so near, that if they advanced another step, they 
might be precipitated headlong into it. No alternative seemed to remain, but 
either to sit there and be starved to death, or to be lost in the torrent.


"After remaining in this situation a length of time which they had themselves 
no power of computing, but which seemed to them an age, and beginning to 
suffer very much from hunger, they thought they heard the distant sound of 
voices in the cavern; they listened, they felt more and more assured of it, and 
they answered with a loud halloo on their parts; this was replied to with another 
halloo, which they again answered; and in a few minutes after this exchange of 
vocal signals was commenced, they began to discern the glimmering of lights; 
nor was it many minutes longer before they saw five or six men approach carrying 
large torches, to them a most blessed signal of deliverance. Their situation 
was indeed truly perilous; they had been entirely deceived when upon 
their lights being extinguished they supposed they turned back, they had continued 
to advance, having penetrated further than it was ever customary to go, 
and the water was flowing directly at the foot of the rock where they sat. When 
missed at their quarters and inquiry was made after them, no one knew whither 
they were gone, till at length some one among their brother-officers recollected 
that he had heard them talk of going to this cave, and suggested the possibility 
that they might have lost themselves among its turnings and mazes. Some of 
the people in the neighbourhood best acquainted with the cave were accordingly 
sent to search for them, and they were happily extricated. They had been in this 
situation nearly four-and-twenty hours." — "Oh Madam," the gentleman concluded, 
"never think of going into that cave; it is extremely dangerous, I assure 
you, from the damps and vapours; besides, 'tis so slippery, that you may get a 
fall and receive some dreadful injury."


At **Kilkenny** I talked to **Mr. Barwis** about it, and told him my story of the 


---

p.317



 
three officers; on which he observed, as indeed I had thought, that their adventure 
need not deter any body from going in, for it appeared to have been occasioned 
principally by their own folly in going into such a place without experienced 
guides. For the rest, he said, he had never been into it, but he understood 
from those who had, that there was nothing to see except an immense 
gloomy excavation in the rock. However, he added, as we should go very near 
it in our way to **Castlecomer**, we might as well go in and satisfy our curiosity. Bidding adieu then to **Kilkenny**, we set off to see the cave and collieries, 
whence I proposed going to **Athy**, there to stop for the night; the journey then 
the next day to **Dublin** would be only thirty miles. In our way **Mr. Barwis** stopped 
to show me a school instituted by Lord and **Lady Ormond** upon the **Bell** or 
**Lancaster** plan, which indeed appeared extremely well managed. Though the 
school was but in its infancy, some of the children could already read very fairly, 
and they all looked healthy, though ragged. A very good school-house has been 
built at **Lord Ormond**'s expense, which was but just finished. On this side of 
the town, the opposite to that where are the great marble quarries, the marble is 
entirely lost; the stone is a dark gray limestone, abounding very much with 
fragments of imperfectly formed crystals, which give it a glimmering appearance 
like mica.


From hence we went to the cave, where, as at most places of the kind, we 
were presently surrounded by a whole tribe of guides. I wonder how any body 
can ever manage upon such occasions to go without these people; they will in general force themselves into your service:
  
 
"Willy, nilly, they will go with you." 
  
 
Nothing of all The Post-Chaise Companion's poetical flights, or of his flights of 
birds that darken the air on approaching the cave, did I find; not a single 
winged chorister of the air, not a solitary croaking ill-omen'd raven, not a 
screeching owl, whose habitation is in like sombrous recesses — not any of these 
issued forth from the dark abyss, to hail us as welcome visitants, or repel us as 
impertinent intruders. The cave is indeed in the midst of a field, the gaping 
pit which is to be descended to get to its mouth being so level with the rest of 
the surface that it is not seen till arrived almost at its very margin. The descent 
is steep, and somewhat slippery, but by no means dangerous. The candles 


---

p.318



 
were lighted, — but I had soon seen enough, — or rather I returned soon because 
I could not see any thing. The lights did indeed burn red and dim, so 
dim that they were scarcely lights; and instead of the limpid water and beautiful 
petrifactions of which I had read, all around was one dismal black rock, 
and the bottom absolutely a mire. **Mr. Barwis** however proceeded further: I 
charged him, if he found petrifactions, to bring me as many as he could collect, 
or any thing else worth preserving; to look in particular for the skulls and human 
bones set in the crystalline substance. He returned in about half an hour, 
assuring me that I had no loss whatever in not proceeding; he saw nothing of 
the organ pipes, the cylinders, the pillars, the inverted pyramids, no crystallizations, 
no petrifactions, no human bones. That he might not come away empty-handed, 
he brought a small piece of stalactitic incrustation, of which he said 
some occurred in one or two places, but in no quantity; a bone, though not a 
human one set in the crystalline substance, only the cylindrical bone of some 
quadruped, — very likely an unfortunate sheep, who straying in could not find 
its way out again, — and two or three pieces of stone, such as he said covered 
the whole bottom of the cave, almost like a pavement; these were only calcareous 
incrustations of an earthy character. The rock mass about the cave is 
a dark gray limestone very prettily veined, like all limestone, with calcareous 
spar; strontian occurs in it occasionally. Indeed I think all that is said of this 
cave is something like
  

*a tale
  
 
Told by an idiot, full of sound and fury,
  
 
Signifying nothing.’’*

Shakespeare, Macbeth, Act 5, Scene 5


At **Castlecomer** we stopped to bait the horses before we went on to the collieries, 
three miles further: here is a very pretty house and grounds belonging 
to the Dowager **Lady Ormond**, who is the chief proprietor of the collieries. 
The house being on one side of the road, and the principal part of the grounds 
on the other, a subterranean communication has been made between them under 
the road. This place suffered very severely in the commotions of 1798. 
**Lady Ormond**'s house was destroyed, as was a large portion of the town, and 
it has even now scarcely recovered the disaster. The collieries are very extensive; the veins of coal are numerous, but they are not in general found lasting; 
hence a number of shafts are to be seen no longer in use. Some of the coal 


---

p.319



 
lies so near the surface, that instead of shafts being sunk to come at it, it is 
quarried like stone; but this is always an inferior quality of coal to that which 
lies deeper: it is a light kind of mineral, rather of a rhomboidal fracture, and 
has a shining metallic lustre. In some places it abounds with iron pyrites, 
which gives occasion to a variety of tints, particularly yellow and red, the latter 
having sometimes a tarnish resembling copper. The rocks in which the 
veins are found are clay-slate, partially exhibiting those delineations which are 
common in nodules of iron-clay.


I had been desired by the friend who charged me to make inquiries about 
the **Kilkenny** coal, to be particular in informing myself about a species of coal 
which he had heard was found in these parts, resembling very much the Cannel, or, as it is commonly pronounced, Kennel coal of England; he had been told, he 
said, that little boxes and other trifles were frequently made of it, and he desired 
me to get him one of them. I made the inquiry accordingly, but was answered 
that if any person had ever seen little boxes made of Cannel coal at **Kilkenny**, the material had come from England, for no coal of the kind was produced in that neighbourhood; nay, that most likely the workmanship as well 
as the material was English. The **Kilkenny** coal has the quality in common with the Cannel, that no black comes off in touching it with the fingers. I have 
mentioned that vegetable impressions upon the schale are not uncommon. Black 
chalk also occurs. At **Killenaule** and **Coalbrook** in the county of **Tipperary**, 
about seven or eight miles from **Cashel**, are also considerable collieries: I did 
not see them, but a piece of the coal was given me which seems very much the 
same as the **Kilkenny**. The vegetable impressions are more abundant about these veins than about those of **Castlecomer** .


Here I took leave of my polite and well-informed companion **Mr. Barwis**; 
he returned to **Kilkenny**, while I proceeded forward, the driver having been 
directed by him to go to **Athy**. After proceeding somewhat more than a 
mile, the said driver suddenly stopped, and said we could not go to **Athy**, I 
had better go to **Carlow**, that was much nearer, we could get there before dark, 
and we could not get to **Athy**. I told him that I chose to go to the latter place; 
in fact, going to **Carlow** now would have been making an unnecessary circuit of 
seven or eight miles to get to **Dublin**; and as I had travelled that road before, 
I wished to vary my route. He said very sturdily, we could not go to 


---

p.320



 
Athy, the road was so bad. I replied, that I was very sure that was not the case, 
since **Mr. Barwis** had recommended the road, and he would not have recommended 
a bad one, and asked him why be had not made this objection when 
he was first ordered to take the road. He muttered something, and then said 
that there was a steep hill to go down, that the horses had no breechings, and 
it would be impossible they could keep the carriage up. I said I was sure 
this was not true, that he knew it was not, or he would have made his objections 
at once before we had parted with **Mr. Barwis**; and bade him go on as he was ordered.


Muttering and grumbling very much he went on. After proceeding some 
way, I saw a town before us which I knew could not be **Athy**, that we could 
not have got so far; and examining it more minutely, I was pretty sure it was 
**Carlow**, that town being rendered somewhat remarkable by the ruins on the 
edge of the river. I would not, however, speak too soon, lest I should be in 
an error, and determined to wait till we were in the town. When we had 
crossed the bridge I was very certain that I was not mistaken, and I called to 
the driver to ask what he could mean by coming to that place in direct opposition 
to his orders. He answered in a very surly manner, that he was going on 
to **Athy**, but it was impossible to go the road I wanted. I never felt much 
more angry. We were now as far from **Athy** as we had been at **Castlecomer** , 
and had come eight miles for nothing; — since, however, we had come to **Carlow**, 
it was making a great circuit to **Dublin** to go by **Athy**, and I ordered him to stop.


Here, however, a new difficulty arose; the town was full of troops on their 
march to the unfortunate county of **Tipperary**, and not a bed was to be had 
at any of the inns. I was resolved notwithstanding to go no further with this 
driver; and meeting with a very civil landlady at one of the inns, I asked 
whether she could not get me a bed at a private house; — it was indeed now 
growing dark. She said she had a friend over the way who would sometimes 
accommodate her with a bed when she was distressed, and sending there one 
was obtained. I then summoned the driver, and told him that in consequence 
of his ill-behaviour I should not pay him or give him any thing for himself, that 
I should send the money to **Mr. Barwis**, and desire him to settle with his (the 
driver's) master for the chaise; and as for what I should otherwise have given 


---

p.321



 
him, I should desire **Mr. Barwis** to distribute it in charity in the town in any 
manner he judged most proper. The driver did, indeed, seem thunderstruck; 
it was an effort of decision which seemed totally unexpected from a lady; and 
he began to say he was sorry, but the other road was indeed bad and hilly. 
Again I asked him why he had not urged that objection at first? to which he 
could make no answer, only pleaded earnestly for forgiveness. I was however 
inexorable, for he made me completely angry by taking advantage of my servant 
and myself being both strangers to the road to practise this imposition, 
and I dismissed him, saying that I was determined to do as I had said. The 
man's fault must have been very glaring; for I learnt afterwards from my servant 
that even his own class condemned him, and thought the lady had done 
quite right: this indeed was more than I expected. Yet why do I say so? — Why may not they be equally capable with their superiors of distinguishing 
between manifest right and wrong? and here the right and wrong was surely very manifest.


The next morning I proceeded to **Dublin**, and arrived there about two o'clock. I had travelled this road before, and have nothing new to remark upon it. There was a continued march of troops the whole way; we met different divisions at every five or six miles. 




---

p.322


Desultory Hints and Animadversions respecting the Claims of **Ireland** to having enjoyed the Use of Letters at a very remote Period. — Importance of cultivating the Irish Language. — **Mr. Flood**'s Opinion upon this Subject. — 
Errors of **Lord Lyttleton** and **Mr. O'Halloran** respecting the Irish Alphabet. — Poetry the Garb in which the early Records of all Nations are clothed. — 
 — The Ogham Character. — **Dr. Ledwich**'s Doubts respecting the Existence of Saint Patrick. — Candid Opinions of **Dr. Leland**.
#### 30


The claim of the Irish to have been in very remote antiquity a nation of 
letters, and in some sort of civilization while their future conquerors were yet 
in a state of absolute barbarism, is not less eagerly contested on our side of the 
Irish Channel, than it is warmly asserted on theirs. To prove the negative of 
any question is commonly a very difficult task: in this case it is not merely attended with difficulty, it is absolutely impossible; and in a case of so much perplexity nothing remains but to deny the fact, and to treat the arguments brought 
by writers in support of the claim as fable and fiction, having their origin entirely in national vanity. But why should we be so unwilling to admit of this 
claim? — All nations have had their dark and their brilliant periods, their days 
of cloud and their days of sunshine; and why may not **Ireland** too have had 
hers? She has known enough of adversity, of that we have assurance double sure, — why should we be unwilling to allow that she ever knew prosperity?


If indeed pretensions were made by the Irish to their country having in ancient times arrived at as high a point in civilization, and in literature and the 
arts, as prevails at present in **Great Britain** and many other nations of Europe, 
they might not unreasonably be charged with presumption and arrogance. But 
such are not their claims. Civilization is but a term of comparison; and what 
in one age may be justly considered as a high degree, compared with a period, 
more remote, will, when compared with subsequent ages, perhaps be regarded 
but as a small step beyond barbarism; and it appears not much more reasonable to treat with ridicule and contumely the claims the Irish actually do urge, 


---

p.323



 
than it would be in them to carry their claims to the lengths which are by some 
imputed to them. If we may doubt the truth of the line of kings they trace anterior to the Milesian invasion, yet from that time so much authority can be urged 
in support of their having lived for a long succession of years under a regular 
form of government, established by the Milesian conquerors, in whose successors the sovereignty continued, that to doubt this seems almost to shake the 
foundation of all belief in ancient history. That if the Irish did not earlier 
enjoy the use of letters, they were at least brought over by the Milesians, if 
the question be fairly and candidly considered, can scarcely admit of a doubt. 
It should be remembered, that it does not rest upon mere oral evidence, upon 
traditions handed down from generation to generation; it is supported by written testimonies, of the antiquity of which the documents themselves are their 
own best evidence.


The misfortune lies in these writings being disguised in a character and language which has become nearly obsolete; which from circumstances has not only 
been for many ages neglected, but over which it has been the policy to throw 
a veil of ridicule and contempt, as the language but of the vulgar classes of society. But was not the Greek the language of the vulgar as well as of the polished classes? — was it not so with the Roman or Latin? — and though the Irish 
is now confined to the lower classes, was not that once the language of the 
Court and the Great, as well as of the Little? — It is from this great circumstance 
of the Irish language being so lost, that the disbelief in the antiquity of their 
records arises; but if instead of despising the language, people would study it, 
the case might perhaps be very different. Is any one authorized to despise what 
he does not understand? Surely not; for the contempt to be justifiable, the object of it at least ought to be thoroughly understood. Thus much may certainly 
be said in favour of the language and the light to be derived from it, — that the 
few who have devoted themselves to these studies have been uniformly more 
and more interested by them, and more eager to pursue them the further they 
advanced; while the deeper their researches were carried, the more strongly were 
they convinced of the truth and antiquity of the documents to which they had 
thus obtained access. The late **Henry Flood**, Esq. was so earnestly impressed 
with the importance of the ancient Irish language being studied and cultivated, 
that he bequeathed a large property to Trinity College, Dublin, for the purpose 


---

p.324



 
of founding a Professorship expressly for these purposes. Unfortunately 
the validity of his will was contested and a decision given against the College, 
so that these commendable intentions were foiled; but it is no small testimony 
in favour of promoting this particular species of investigation, that it was deemed 
of so much importance by such a man.


The truth is, that at the conquest of the country by the English it became 
the policy of the conquerors to represent the vanquished as a herd of rude barbarians, the better to gloss over their own illicit and unjustifiable procedure. This 
imputation unfortunately gained too much colour from the circumstances under 
which the invasion of **Ireland** was ultimately undertaken. Torn by domestic 
feuds, the assistance of the English monarch was implored by the weaker party, 
and thus was furnished a too plausible pretence for what had before been resolved on; at the same time that too much reason was given for treating as 
barbarous and uncivilized, a people who were thus divided. Yet, if the thing 
be examined with a really philosophical eye, the very nature of those feuds 
showed civilization to a certain point, since they were not the quarrels of barbarians, they savoured much more of those of legitimate monarchies. They 
were the factions which always arise sooner or later in long established governments, not the squabbles of those who had never known what it was to live under a regular system. It was not by utter barbarians that a foreign power would 
have been called in to settle their domestic feuds, this savours much more of 
the apathy and indolence of civilization. Under such influence men feel only 
the present inconvenience; and if a prospect appears of disencumbering themselves from that by the exertions of others rather than their own, they catch at 
it eagerly, regardless of the lessons they might learn from uniform experience. 
 The Horse and the Stag is one of the finest among the many fine moral lessons 
afforded by the Fables of Æsop: but it is the fate of man, individuals no less 
than states, that they can never profit by the experience of others, they must 
purchase it themselves, and dear is the price commonly paid. The Britons, 
long before, had called in the Saxons to assist them against the inroads of their 
fellow-islanders the Picts; and these new guests once introduced into the country did not choose to depart; 
 — they came to assist, they remained to enslave it. The 
Irish, or one faction at least among them, called in the English to aid them in 
supporting their claims to the sovereignty: — the English had long since cast an 


---

p.325



 
eye of desire upon their island, they rejoiced in the opportunity offered of satisfying it; 
 — they went over as auxiliaries, they chose to remain as sovereigns.


Against the imputed advance in civilization among the Irish may be urged 
the rudeness of their habitations at the time of the English conquest — that **Dublin** did not afford any thing beyond houses, or rather cabins, of clay-built 
walls. But it is to be observed, that **Dublin** never was the capital under the 
proper Irish kings; their residence was at **Tara**; there they held their Court; 
thither the assemblies of the nation were convened. **Dublin** had been raised 
to consideration by the Ostmen or Danes; and the English, by whom alone 
these latter were finally expelled *from* the country, found it a more convenient situation for their capital, from its vicinity to the sea, and being directly opposite 
the English coast, than a more inland one. The arts of masonry in **Ireland** 
were then principally bestowed upon the religious seminaries or the castles of 
the chieftains; it is among them we must look for all the architectural remains 
so profusely scattered over the country. Many of these were indeed establishments subsequent to the English conquest. But it is rather in having had for 
so long a succession of years the use of letters and a regular established government, that the superior civilization of **Ireland** is to be looked for, than in their 
advancement in the arts, though that was by no means inconsiderable.


It may again be objected, that of the ancient Irish manuscripts handed down 
to the present time, the greater part are poetry, the fables of the bards of old, 
and in no way to be cited as authority for any thing like historical facts. Yet, 
even if it could be granted that no other ancient Irish manuscripts exist except 
the songs of the bards, is not poetry the almost universal vehicle through which 
the early annals of all countries have been handed down to posterity? Are not 
the very earliest writings we possess in many parts poetic? and do we reject the 
belief of them on that account? — It may be said that these writings were inspired; 
that they are not to be brought as an argument for affording any belief in profane poetry: but can we suppose the Being who inspired them, would have had 
them clothed in a garb which was ever after to be stigmatized as that of falsehood 
and delusion? — This seems an idea scarcely to be entertained for a moment of 
Infinite Wisdom. Turn to the Greeks: Is it not in the divine poems of 
Homer, is it not in the works of Hesiod, that we look not only for the earliest 
accounts of the history of this extraordinary people, but equally for the pictures 


---

p.326



 
of their customs and manners, and for the description of that mythology which 
has rendered them no less celebrated to after ages, than their martial achievements, or the perfection to which they carried the arts and sciences?


True it is, that in these latter years there have been people who have chosen 
to doubt whether such persons as the heroes of Homer ever existed save in the 
fancy of the poet, and whether such an event as the Trojan war ever occurred 
except in his imagination. That Homer has mingled a great deal of fable in 
all he has written I have not the least doubt; as little can I doubt that he had 
some foundation whereon to raise that edifice which was the delight of his own 
time, which ever has been, and probably ever will be, the admiration of posterity. What has been the practice in all epic poesy, but to raise a splendid superstructure of fable upon a slender base of facts? nor has any argument yet 
been adduced, according to my ideas, of sufficient force to overturn the long-established belief that this was the case with the great father of epic poets. 
Till, then, some stronger arguments appear than I have yet heard, to disprove 
the existence of such persons as Priam and Achilles, of Paris and of Hector, 
of such a city as Troy and of such an event as the Trojan war, I must believe 
that illustrious chiefs of such names once flourished in Greece and in Phrygia, 
that such a city as Troy once ornamented the banks of the Simoïs and the Scamander, and that this city endured a long and remarkable siege. Thus much 
I must believe, however largely I may think the poet drew upon his imagination in furnishing out the splendid garb with which his story is decorated.


Turn to the Northern nations, Is not poetry equally the vehicle by which we 
arrive at the earliest ideas to be traced of their history, of their strange and wild 
mythology, and of the customs over which it had so strong an influence? 
Granted, therefore, that it were through the medium of poetry alone the alleged 
antiquity of the Irish nation was to be traced; such testimonies, though to be 
cautiously believed, are not to be wholly rejected. But the Irish claims do 
not rest upon this base alone; laws and statutes of a very remote period are in 
existence, which show that the nation where they were enacted could not have 
been in a state of absolute barbarism — that the use of letters was familiar to it. Manuscripts of these laws and institutions are to be seen: there are several deposited in the library of Trinity College at **Dublin**, with other manuscripts upon 
different subjects, the antiquity of which the most determined sceptic, on seeing 


---

p.327



 
them, I should think could hardly doubt. Many collections are also to be 
found in private hands; I have instanced **Mr. Monk Mason**'s very valuable 
one.


**Lord Lyttleton**, who seems indeed desirous of stating the matter fairly, has yet 
fallen into a great error in saying that the letters of the ancient Irish alphabet, 
called the Beth-Luis-Nion[27](javascript:footNote('E810001-001/note027.html')), are Roman, with but little variation from the originals. **O'Halloran** in his History of Ireland derives them from the Greek. 
He appears to me equally in an error; these letters are evidently of Celtic 
origin, having the utmost affinity, it might almost be said having identity, with 
the ancient Saxon character, as it is found in some old Saxon manuscripts preserved in this country: from these our ancient Black letter is derived; the modern German character, now used in **Saxony**, is properly the Teutonic, though 
the alphabets are but dialects (if I may be allowed the expression) the one of 
the other, in the same manner as the languages. But at the time **Lord Lyttleton** wrote, about the year 1770[28](javascript:footNote('E810001-001/note028.html')), or **Mr. O'Halloran** 1778, scarcely any body 
in this country thought of studying the German language, in any of its dialects;, 
the characters employed in them were of course very little known; and ignorant 
where the true affinity was to be found, these writers were ready to trace it to 
others with which they were familiar. Perhaps the very character in which 
the Irish manuscripts are written, rightly understood, is one of the strongest 
proofs that can be adduced of their antiquity; and if any resemblance is to be 
traced to the Greek characters, the Greeks, not the Irish, were the imitators. 
These are probably the characters which the Scythian nations brought with 
them from Asia when they spread themselves over so large a part of the North of Europe; they are in all probability what were used by the Phoenicians, and 
were carried by them into **Spain**, whence they were brought into **Ireland** by the 
Milesian colony at their conquest of the island.


Let me be allowed to quote a passage from **Lord Lyttleton**, and make a remark 


---

p.328



 
or two upon it. "A colony of Boetica, or any part of the western coasts 
of **Spain**, may have brought into **Ireland** the Punic or Phoenician characters: 
but the alphabet called by the Irish Beth-Luis-Nion, appears to be the Roman 
alphabet differently arranged, and reduced to the number of only eighteen letters[29](javascript:footNote('E810001-001/note029.html')), with the addition of some compounds, and with small variations in the 
forms of some of the letters. One should therefore suppose that it is not very 
ancient; and the rather as no Irish writing, incontestably anterior to Patrick's 
preaching in **Ireland**, has ever yet been published. **Sir James Ware** indeed 
says, that he had in his possession an old manuscript full of secret characters 
called by the ancient Irish Ogum[30](javascript:footNote('E810001-001/note030.html')), in which they wrote what they meant to 
keep hidden or mysterious; but of what age he took the book to be he does 
not inform us, nor how, if it was written in characters different from those 
above-mentioned, that, or others in which this ancient cypher is found, can at 
present be decyphered, or could ever be understood by any modern Irish. One 
may reasonably suppose that, in manuscripts written since that nation received 
the Roman letters from Patrick, some traditional truths recorded before by the 


---

p.329



 
bards in their unwritten poems may have been preserved to our times: yet these 
cannot be separated from many fabulous stories derived from the same sources 
so as to obtain a firm credit; it not being sufficient to establish the authority 
of suspected traditions, that they can be shown to be not so improbable or absurd as others with which they were mixed; since there may be specious as 
well as senseless fictions. Nor can a poet or bard who lived in the sixth or 
seventh century after Christ, if his poem is still extant, be any voucher for 
facts supposed to have happened before the Incarnation; though his evidence, 
allowing for poetical licence, may be received on such matters as come within 
his own times, or the remembrance of old men with whom he conversed. It 
is therefore safest, in writing the ancient history of **Ireland**, to be content 
with those lights which foreign writers have given, till better evidence is produced 
by the Irish themselves; as, in writing that of Britain, the most judicious historians pay no regard to the Welsh or British traditions delivered by **Geoffry of Monmouth**, though it is not impossible that some of these may be true, but 
adhere to the information which cotemporary writers of other countries afford 
concerning the Britons."


A few pages further be says: "Together with the Gospel the British missionaries introduced into **Ireland** the Roman alphabet, and a general knowledge 
of the Latin language. A school was formed at **Armagh**, which soon became 
very famous; many Irish went from thence to teach and convert other nations; 
many Saxons out of England resorted thither for instruction, and brought from 
thence the use of letters to their ignorant countrymen, the same letters which 
Patrick had given to the Irish. We learn from Bede, an Anglo-Saxon, that 
about the middle of the seventh century, numbers both of the nobles and of the 
second rank of English left their country and retired out of England into **Ireland** for the sake of studying theology or leading there a stricter life. And 
all these, he affirms, the Irish, who he calls Scots, most willingly received and 
maintained at their own charge, supplying them also with books, and being 
their teachers without fee or reward. A most honourable testimony not only 
to the learning, but likewise to the hospitality and bounty of the nation."


Now it is of importance to observe, that here the author asserts Patrick to 
have been the person who introduced the Roman alphabet into **Ireland**; and 
though he does not positively say it, we are to understand by implication that 


---

p.330



 
this immediately became the character in general use. The inference, then, is obvious, that any manuscripts which appear in the old Irish character must 
be of a date anterior to St. Patrick's mission to **Ireland**, which is placed in the 
fifth century; and since the manuscripts now in existence, the relics only in 
all probability of much greater numbers scattered over the country, could not 
be supposed all to have been produced within twenty, or even fifty or a hundred years before St. Patrick's arrival, some of them may reasonably be supposed to be the produce of a very remote period indeed.


**Dr. Ledwich** would, however, with one stroke, throw both **Lord Lyttleton**'s 
and my reasoning to the ground, — assuredly I should, at least, fall in good 
company, — for he totally disbelieves that such a person as St. Patrick ever existed. Now, though I am not disposed to be over-credulous, yet I must say 
in this instance, as in the instance of Homer's heroes, that I cannot persuade 
myself such traditions are entire coinages of the imagination. There is, I have 
no doubt, in all these cases a little base of truth, which is almost sunk beneath 
the monstrous weight of fiction pressing upon it: yet there it is still. It seems 
almost as ridiculous wholly to disbelieve the existence of such a personage as 
St. Patrick, as it would be to believe one half of the stories related of him.[31](javascript:footNote('E810001-001/note031.html')) 
It is very immaterial, however, whether the Gospel was first preached in **Ireland** by a person of that name or not; all that bears upon the present question 
is, whether the Roman alphabet was introduced by its preachers, to the exclusion of the characters previously in use? and this is of great importance in determining the antiquity of manuscripts couched in the original character. If 


---

p.331



 
the Celtic character has been disused ever since the fifth century, the manuscripts in that character must be of an older date; and if from them any elucidation is to be obtained of points which at present appear only traditionary, 
here would the Irish authorities desired by **Lord Lyttleton** be obtained. Is it 
not then of some importance, in a literary point of view, that the language in 
which these manuscripts are written should be better understood? The loss of 
a part of the Decades of **Livy** is lamented as a great misfortune to literature: 
perhaps the numerous Irish manuscripts which have been lost might have been 
of more importance in assisting to elucidate periods of remote history now involved in such impenetrable obscurity.


But the dark policy of former ages unfortunately was concerned in devoting 
them to destruction. At the preaching of the Gospel the Christian missionaries 
would of course be earnest to sweep away as much as possible every vestige of 
the religion they came to abrogate; and, since the religions of the world have 
always been incorporated with State affairs, in destroying the vestiges of the 
one the records relative to the other unavoidably fell a sacrifice. In subsequent 
times, at the English conquest, State reasons completed the work of destruction 
religious ones had begun; — the Irish were to be represented as a people wholly 
sunk in barbarism, and whatever would prove the converse must be swept away 
by that fatal besom. The gross compact of iniquity into which the then sovereign 
of England, and the Holy Father of Rome, had entered for the subjugation of 
Ireland, was to have the best colouring put upon it that could be devised: — to 
affix the stigma of entire barbarism upon the devoted nation appeared the most 
plausible, and what therefore might aid to contradict such assertions was to be 
removed out of sight for ever. It is only wonderful that any of these remains 
of antiquity have been preserved amid such destructive moral hurricanes.


I feel that I have not said one half of what might be said upon this occasion; 
I have endeavoured only to throw out some desultory hints upon a subject 
which has struck me rather forcibly. I cannot but think that the Irish claims 
to antiquity are in general too rudely repelled, when the more equitable part 
would be to understand the nature of them, and to examine the grounds on 
which they rest; and this can only be done fairly by cultivating a better knowledge of the language. It is by no means my intention decidedly to pronounce 
the claims worthy of credit, though I very much incline to think them so to 


---

p.332



 
a certain extent: all I mean to advance is, that we are not authorized to treat 
them with contempt while the authorities for them are so little known.


Their own historian, **Dr. Leland**, is the man who seems of all the writers 
upon this subject to consider it in the most fair and impartial point of view 
he neither adopts nor spurns the ancient traditions of the country; their poetic 
fictions, or the writings which treat of their ancient laws and institutions. He 
candidly confesses, that not understanding the language he is little competent 
to decide upon the measure of credit to which the records are entitled; and 
having given a view of the ancient history, such as he collected it from the best 
sources within his reach, he thus sensibly and rationally sums up the whole: *But to the antiquarian I leave it to establish the authenticity of this history. It is only pertinent to my present purpose to observe, that if we suppose that 
the old poets were merely inventors of this whole series of actions and incidents 
so circumstantially detailed, still they must have drawn their pictures from that 
government and those manners which subsisted in their own days, or were remembered by their fathers. So that we may reasonably conclude that the state 
of **Ireland**, for several centuries at least before the introduction of the English 
power, was such as they describe it in these early periods. And this is the 
only conclusion which I am concerned to establish.’’*

Thomas Leland, History of Ireland, Preliminary Discourse, xvii.




---

p.333


Present State of **Ireland**. — **Mr. Hume**'s Libel on the Irish and their Country. — Rebellions in the Time of **Queen Elizabeth**. — The Irish very susceptible of kind Treatment. — Kind and warm-hearted themselves. — **Miss Edgeworth**'s "Ennui." Evils of the great Families absenting themselves from the Country. — Wretchedness of the Cottages, and the Cause of it. — On the Education of the Poor. — Prejudices of the English respecting the Irish. — Irish Fortune hunters. — Resemblance between the Irish and French. — Different Characteristics of the People in the North and South of **Ireland**. — Distinguished literary Characters of **Ireland**.
#### 31


But whatever was the state of **Ireland** previous to the English conquest, its 
state ever since is but too well known. **Hume** says, after giving an account of 
this event, "The low state of commerce and industry, during those ages, made 
it impracticable for princes to support regular armies, which might retain the 
conquered countries in subjection; and the extreme barbarism and poverty of 
Ireland could still less afford means of bearing this expense. The only expedient by which a durable conquest could then be made or maintained, was by 
pouring in a multitude of new inhabitants, dividing among them the lands of 
the vanquished, establishing them in all offices of trust and authority, and thereby transforming the ancient inhabitants into a new people. By this policy the 
Northern invaders of old, and of late the Duke of Normandy, had been able to 
fix their dominion, and to erect kingdoms which remained stable on their foundations, and were transmitted to the posterity of the first conquerors. But the 
present state of **Ireland** rendered that island so little inviting to the English, 
that only a few of desperate fortunes could be persuaded from time to time to 
transport themselves into it; and instead of reclaiming the natives from their 
uncultivated manners, they were gradually assimilated to the ancient inhabitants, and degenerated from the customs of their own nation. It was also 
found requisite to bestow great military and arbitrary powers on the leaders, 


---

p.334



 
who commanded such a handful of men against such hostile multitudes; and 
law and equity became in a little time as much unknown in the English settlements as they had ever been among the Irish tribes. Palatinates were erected 
in favour of the new adventurers; independent authority conferred: the natives, never wholly subdued, still retained their animosities against their conquerors. Their hatred was retaliated by like injuries; and from these causes 
the Irish, during the course of four centuries, remained still savage and untractable. It was not till the latter end of Elizabeth's reign that the island was 
finally subdued; nor till that of her successor that it gave hopes of becoming 
an useful conquest to the English nation."


Indeed, for a philosophical historian this does appear a very unphilosophical 
passage. If **Ireland** was the poor and despicable country **Mr. Hume** would represent it, what was it that made Henry ambitious of adding it to his already 
immense dominions? A sovereign does not usually seek to deprive a brother-sovereign of his possessions, and seat himself in his place, without proposing to 
himself some important acquisition to compensate for the iniquity practised. 
But Henry saw in **Ireland** a most delicious and fertile country; a country abounding with fine forests, with excellent pasturage, capable of producing abundantly 
all the fruits of the earth; watered every where by abundant streams and rivers, 
many of them navigable; concealing treasures of ores within the bosoms of her 
rocks; — all this he saw, all this he coveted: — it was the riches, not the poverty 
of **Ireland**, that made it the object of his ambition and cupidity. Had the inhabitants of **Ireland** been sunk in as low a state of moral degradation as **Mr. Hume** represents them, living in a country so poor and despicable, what, by exciting Henry's hopes, or awakening his fears, could stimulate him to an act of 
so great injustice as he projected? No: he saw this rich country inhabited by 
an ingenious and warlike people: he found them dangerous as neighbours, and 
hoped to find them as subjects a valuable support to his power. But again, I say, 
an act of such outrage must be varnished over; and he thought no gloss so specious as that he threw over it, of depreciating in every way the country he had 
sacrificed his honour and honesty to obtain. The writers of his time, then, 
taking their cue from the court, vilified **Ireland** in every way; and **Mr. Hume**, 
at all times too much disposed to abandon his better judgement when personal 


---

p.335



 
or national prejudices interposed, has, without considering the inconsistency of 
what he says, suffered the impartiality of the historian to be overswayed by their 
designed and wilful misrepresentations. 


And what else could be expected from the scene of rapine and plunder he 
describes but the consequences that did actually follow? This conquest was to 
be secured "by pouring in a multitude of new inhabitants, dividing among them 
the lands of the vanquished, establishing them in all places of trust and authority, 
and thereby transforming the ancient inhabitants into a new people." This was 
indeed the way to transform them into a new people; the worm that is 
trampled on will turn and wound its oppressor: and what could be expected 
from conduct thus lawless on one side, but retaliation on the other? By oppression they were driven to show a sense of injury in copying the evil example 
set them: it was the lawless invaders who assimilated them to their manners; 
it was the ancient inhabitants who degenerated and adopted the manners of 
their conquerors, not the conquerors theirs; they were driven into acts of violence and barbarism, and afterwards condemned as barbarians; — as some good-natured husbands will not unfrequently scold unhappy madam till tears irresistibly flow, and then are angry with her for crying.


For four centuries this scene of animosities continued, this perpetual warfare 
of oppression and of ineffectual resistance; — the English still masters of the 
island, the Irish still kicking against the yoke, till in the latter years of **Queen Elizabeth**'s reign the formidable rebellions which had been attempted were 
quelled, and the country seemed finally subjugated. But was any attempt 
then made to conciliate? No: four revolving centuries had revolved in vain to 
teach lessons of experience to the ruling powers. **Queen Elizabeth** was in 
many respects a great princess; — like the hen, she was a good mother to her 
chickens, but she was too much disposed to peck at those which did not immediately coop under her own wing: 
 — she was fond of power, and could not bear 
to see her power resisted. Thus at the suppression of the Irish rebellion fines 
and confiscations were the order of the day; the heads of the ancient septs, 
shorn of their honours, were doomed to linger out their remainder of life in obscurity or captivity; while the followers, instead of the masters to whom they 
had been accustomed to look up with an attachment little short of veneration, 
were now expected to pay their homage at new shrines, — at shrines which to 


---

p.336



 
their utter grief and dismay they saw decked out with the spoils of those fallen 
ones they had held so dear. The heads of the rebellion were crushed, but 
venom still rankled in the hearts. If in later times these things have been partially corrected; if by degrees something of the jealousy and asperity with 
which this rival sister was regarded has abated, too much has still been retained 
till that be entirely eradicated, **Ireland** can never be other than a diseased limb 
of the body politic.


During my respective residences in this country I mingled very much not 
only among what might be called my own class in society, but I endeavoured 
to search into the character of the inferior classes. To me it ever appeared 
that the Irish are a people uncommonly susceptible of kindness: I have seen 
the countenance sometimes lighted up with such animation at the sound of but 
one kind word, that I have thought to myself, What might not be done with 
these people if they were taken by the hands sincerely as brethren, — if they were 
no longer forced to feel themselves but as a sort of sheep shut on the outside of 
the fold, not suffered to enter the holy of holies within? But the title of the 
wild Irish has once been bestowed upon them: — nothing is so dangerous as 
such an epithet; for it seems as if a determination were formed that they shall 
still be compelled to deserve it. That they are capable of the strongest attachment, their firm and steady adherence to their clans or septs has repeatedly 
manifested; and nothing can be warmer even now than the attachments which 
I have seen manifested in the dependants of a family to the head, when they 
have been a lone time in his service.


In **Miss Edgeworth**'s very fine tale of Ennui (and I know of few things in the 
way of fiction superior to it) I have still had one subject of regret. To give all 
the effect intended to the character of the hero, it was perhaps necessary he should 
experience the strange and complete reverse of fortune which Ellinor's abrupt 
disclosure of his being her son brings upon him: yet much could I have desired that her warm attachment had never been other than that of the foster-mother to the babe she had reared, — than that of the dependant of the sept to 
its master. I wish the author's fine imagination, her thorough acquaintance 
with the character of her countrymen, would exercise itself upon such a subject; — how exquisite a national picture would be added to those with which she has already presented the public!




---

p.337


#### 31


I do most sincerely believe that the disposition of far the greater majority 
of the nation is to attach themselves warmly to the English, to forget all past 
feuds and animosities, to become but one people with them, to let the distinctions 
of this side the water and that side the water be forgotten, — to forget 
even the humiliations they could not but feel attendant upon the Union, if they 
could only see that indeed an union, — not in sound only, but in heart and soul. 
I am sure my own reception, wherever I went, may be adduced as a justification 
of this opinion; I must either think that I saw nothing but hypocrites, or 
believe that the flattering attentions I experienced were of the heart, not merely 
of the head; for worlds I would not think the one; I must believe the other; — I must believe that the Irish are a kind and warm-hearted people, extremely 
disposed to show kindness themselves, and no less feelingly alive to receiving 
it from others.


If I am told of the troubles and commotions by which the country has been 
harassed within the last thirty years, the answer is obvious: — I know that tumults 
have arisen; I know that terrible scenes have passed; I know it has 
appeared too palpably that there were many troubled spirits in the country: 
but I also know that the number of these, compared with the whole population, 
has been trifling. This was particularly manifest in the rebellion of 1798; had 
it not been a very, very small minority of the nation who were engaged in it, 
never would it have been so easily subdued. So futile, indeed, have all attempts 
at insurrection proved, that they have only shown how insignificant was the 
number of the disaffected, how well affected was the majority of the nation towards 
this country. But it is a misfortune arising from the very nature of all 
human affairs, that, as **Dr. Leland** justly observes, *History records the effects arising from dangerous passions, the virtues of private life are not generally made 
the subject of history.’’*

 The world knows how many were concerned in these 
troubles, how many fell sacrifices to them on this occasion, how many on that; 
they will never know of the thousands who remained quiet in their homes, lamenting 
in secret the infatuation of their deluded countrymen; feeling but too 
sensibly that they had great cause of complaint, yet regretting that they had 
recourse to means so mistaken for seeking redress; means which could only 
terminate in an increase of suffering to themselves, and extend the calamity to 
those who were innocent of any participation in the offence.


---

p.338


#### 31


And ought not these good dispositions to receive every possible encouragement? Policy and humanity alike answer, Certainly. But do they? Truth 
compels the answering this in the negative. It cannot be denied but that the 
state of the country calls loudly for some amelioration — that the situation of the 
inferior classes among the Irish is lamentable, is affecting. Justice, however, 
demands that the blame should be principally imputed where it is principally 
due; and in this instance, the Great among the Irish themselves are the class 
of persons most to be condemned. The true source of the calamities of the 
country is in the principal landholders absenting themselves from it, spending 
in foreign climes (for even England is in this respect to **Ireland** a foreign clime) 
the fortunes which ought to be participated with the poor, from the sweat of 
whose brows they are derived. What attachment can the dependants of any 
estate have to an owner of whom they know nothing, but that they must at certain times of the year pay him a certain rent, which their utmost exertions can 
with difficulty scrape together? What influence might not the families of distinction obtain by living as of old on their estates, petty sovereigns among the 
people around? by attending themselves to the promotion of their comforts, by 
introducing a spirit of industry among them, and by furnishing them employment, so that such a spirit might never be suffered to know a moment's abatement? We are told that the Irish are indolent by nature: 
 — alas, they are rather so by compulsion, because they have no means of being otherwise. 
The vast influx of factitious wealth which has of late years flowed into this 
country, which was thought her strength, but which has proved her weakness, 
has been, if possible, even more injurious to **Ireland** than to ourselves. It has 
created not a taste alone, but a craving after luxurious modes of life, which is a 
calamity of the most fatal kind that can afflict a nation: the parliament, which 
used to carry the great families of **Ireland** to **Dublin**, now transferred to **London**, 
they have been obliged to go thither; they have tasted the luxuries of the English 
capital, they are no longer satisfied with their own country, but hold themselves 
still absented from it. Here lies the great evil of the Union to **Ireland**. Yet, 
let me be just: though the country is lamentably deserted by too large a portion of the great, there are yet some righteous remaining in Sodom. There are 
still noblemen living principally upon their estates, — I have instanced several, — 
giving their time and attention to improvements in agriculture and manufactures, 


---

p.339



 
and to ameliorating the situation of the country in a variety of ways: 
these are, I repeat it, the true patriots: let us hope their bright example will 
spread, that the strayed sheep, finding the good effects resulting from their exertions, may be induced to return into the fold, and by redoubled assiduities repair past omissions.


There is one point to which I cannot help more particularly adverting. 
We never cease hearing the wretchedness of the Irish cabins made the subject 
of animadversion; and very wretched indeed they are for the most part: but I 
have not yet found the true cause of their wretchedness explained. The landholders do not, as in England, provide cottages for the poor on their estates, 
each labourer provides his own habitation; — the inevitable consequence of this 
is, that, the means being very slender, it must be built at the least possible expense, — that the whole family, human beings and animals together, must be 
squeezed into the smallest space in which they can be contained: the inevitable 
result is, that they live in a degree of filth which I am confident is no less injurious to the mental than the corporeal health. — What do I say? no less? — 
It is infinitely more injurious. I have seen troops of healthy-looking children 
issue forth from these cabins, but I am sure the moral man cannot live in such 
a way without being exceedingly degraded. The remedy of this evil would be 
a very important step towards introducing more general habits of order and regularity. Is it possible for the infant mind to be impressed with any notion of 
such habits, when at the first dawning of its tender ideas they are presented 
with spectacles so directly opposite? Their ideas must be formed after what 
they do see, they cannot be formed after what they do not see. 
"Train up a child in the way he should go, and when he is old he will not depart from it." 
Let him be accustomed to see nothing but neatness and order around him, 
depend upon it when he grows up he will not sigh for a mud cabin and filth. 
A very laudable spirit seems now to be awakened among the gentry who remain 
at their posts, and attend to the welfare of their poorer neighbours, for educating the children of these classes; but I do think that an indispensable step towards rendering education of any avail, is first to provide the poor with more 
decent homes.


Let me not be understood by any means to disparage the spirit of educating 
the poor, I only wish to see the very laudable desire of ameliorating their *situation*


---

p.340



 
take a still wider range, and extend itself towards the correction of another 
evil which does appear to me of extraordinary magnitude. Most sincerely do 
I wish prosperity to the Society for the education of the poor; — most sincerely 
should I rejoice to hear that a society were set on foot, for providing better cottages for the poor — or perhaps I would rather wish to see the nobility and 
gentry, without any association, adopt the English practice, and provide, each 
one on his own estate, habitations in which they might live with decency and 
comfort. Habit can reconcile the mind to almost any thing, else I should 
wonder how the gentlemen of the country can themselves endure to be surrounded by such abodes of wretchedness: — but they are so accustomed to 
seeing them, that I do not suppose they feel the same impression from 
the sight that is made upon a stranger. Another evil arising from the 
poor being their own builders is, that in case of a family emigrating from one 
place to another, the cottage is deserted, and having no longer any owner is left to fall to pieces, which it does not fail to do in a very short time. Thus 
the number of ruined modern cottages every where to be seen, is even a more 
striking feature in the country than the number of ancient ruined castles and 
abbeys. 
During my first summer's Residence in **Ireland** in 1814, Judge Fletcher, in 
a charge which he delivered to the Grand Jury of the county of **Wexford**, 
touched in so able a manner upon some of these topics on which I have ventured to hazard my opinions, that I must entreat the public indulgence in 
being allowed to quote two or three short passages, not omitting one which 
offers a hint or two to myself as a Tourist in **Ireland**. "For my part, I am at 
a loss to conceive how the permanent absentees can reconcile to their feelings 
or their interests, the remaining supine spectators of the present state of the 
country; that they do not see the remedies which are loudly called for. — 
cannot conceive how they can forbear to raise their voices in behalf of their 
unhappy country, and attempt to open the eyes of our English neighbours, who, 
generally speaking, know about as much of the Irish as they do of the Hindoos. — Does a visitor come to **Ireland** to compile a Book of Travels, what is his 
course? — He is handed about from one country gentleman to another, all interested in concealing from him the true state of the country; he passes from 
squire to squire, each rivalling the other in entertaining their guest, all busy 


---

p.341



 
in pouring falsehoods into his ears touching the disturbed state of the country, 
and the vicious habits of the people. Such is the Crusade of information upon 
which the English traveller sets forward, returning to his own country with all 
his unfortunate prejudices doubled and confirmed, in a kind of moral despair 
of the welfare of such a wicked race, having made up his mind that nothing 
ought to be done for people so lawless and degraded."


Again: "I will tell you what those absentees ought to do; — they ought to promote the establishment of Houses of Refuge, Houses of Industry, and School-Houses, and set the example upon their own estates of building decent cottages, that the Irish peasantry may at least enjoy as much comfort as is enjoyed 
by an English sow — for an English farmer would refuse to eat the flesh of a hog so ill lodged and fed as an Irish peasant." — Once more: "I do not encourage you to expect any immediate amendment or public benefit from the 
plans in agitation for the education of the poor; it is in vain to flatter yourselves that you can improve their minds if you neglect their bodies. Where have you ever heard of a people anxious for education, who had not bread to 
eat or clothes to cover them? I have never known people under such circumstances feel any great appetite for moral instruction."


At the moment of writing this, I am favoured with a pamphlet from **Ireland**, sent me by the author, an Irish barrister, (whose name I suppose I must not mention, as it is not affixed to the work,) upon the subject of educating the 
poor. Most sincerely do I concur with this gentleman's ideas as to the general good likely to result from giving the poor the opportunity of learning the duties of their station upon sound principles; I can never persuade myself but that a 
man must be a better member of the community who is able to inform and enlarge his mind through the medium of books, who has such a resource to 
occupy his hours of leisure, than he who, sunk in ignorance, has no refuge 
but the public-house to fill up his time when the labours of the day are over. 
Yet I wish he had carried his views one step further, and had seen the necessity of providing the poor with more decent lodging, as an essential preliminary to the cultivation of their minds; — had seen how important it is, in order to 
prepare their minds for moral and religious instruction, that in future, when 
their eyes are first opened, when their ideas first begin to expand, they may fall 
upon something better than the wretchedness now presented to them. As they 


---

p.342



 
are circumstanced at present, their minds are too much pre-occupied with revolting ideas before the task of education can begin; their eyes are too much 
accustomed to disgusting spectacles, for instruction to come with the same force 
that it would to minds better prepared. I know a very sensible man who, 
having a large family, has been anxious to store his house with every object that 
can impress upon the youthful mind notions of humanity, of benevolence, of 
refined taste; convinced it is of vast importance that the ideas should be early 
awakened to a sense and feeling of beauty, both mental and corporeal; 
and that this great point is best to be attained by accustoming them from the 
very earliest dawn of reason to the contemplation of objects calculated only 
to excite such ideas. If there be any truth in this reasoning, and it appears to 
me very sound and correct, what can be expected from ideas first formed in an 
Irish cabin? Indeed, indeed, I think these cabins a high national disgrace. 
It is not without great surprise, and much greater regret, that I see still in 
this country such strong prejudices existing, even in the minds of those who on 
most subjects are extremely candid and liberal, against the Irish. It seems 
the serious belief of many, that the lower classes are one and all ferocious and 
turbulent in their natures, always in a state of tumult and disorder, and that it 
is scarcely safe to trust oneself among them. I have not unfrequently been 
asked, "How did you dare to venture upon travelling over a country in such 
a disturbed state?" — Yet my Narrative will show, that it is possible to travel 
many and many miles over this disturbed country in the most perfect quiet. I 
could almost be tempted to call the majority patterns of patient endurance, suffering, but scarcely complaining, almost even kissing the rod by which they are 
scourged. If a disposition to plunder and murder had been prevalent among 
them, I furnished them with sufficient and repeated opportunities to deprive me 
of whatever property I was carrying about, or of my life if they were so inclined, since no one would have been the wiser. What could myself, my servant, and a youth of thirteen as our driver, in the midst of lone mountains or 
wastes, have done against a set of lawless ruffians, if they had abounded in the 
country, as many people seem to suppose? nay, in the county of **Antrim**, I 
trusted myself alone, as I have related, with a peasant of the country in a long 
and solitary walk along the Rock-heads, where there was nothing but his own 
honesty and principle to deter him from any act of plunder or violence. There 


---

p.343



 
are some who I have no doubt will scarcely believe these things possible, yet they are true.


Carrying still further their prejudices, the young men a step higher in the scale of society, who come over here, are too commonly included under one 
general head, and to that head is given the title of fortune-hunters. A lady carried her ideas so far upon this subject, that she positively asserted there was an association formed in **Dublin** for the purpose of fitting out fortune-hunters to England. The plan of it she said was this: — Upon a certain subscription 
paid, the fortune-hunter was supplied with every thing necessary to enable 
him to cut the proper dash in England; his destination being commonly **Bath** or some other dashing-watering place, where he could with more facility insinuate himself into company than in **London**; and he had an unlimited power 
to draw upon the fund for all necessary supplies till the object of his mission 
was obtained, in being blessed with the hand of some wealthy English fair-one. Then, all the money he had received was to be reimbursed to the general fund, with the addition of a certain bonus for the use of it, regulated according to 
the length of time he had been accommodated with the money, and the greater 
or less value of the prize obtained. — Now really those who could believe in so 
absurd a tale, must have a measure of faith fit for the reception of any thing 
 — no fiction of giants or enchanters could be more extravagant. 


That there may be needy young men occasionally, who transport themselves from the other side of the Irish Channel to this, in hopes of making their fortunes among the fair of this country by a good address, by pleasing manners 
and polite attentions, which they prefer as an easier way of establishing themselves in life than drawing on their own industry and application; — that such 
things may occur, is very likely: but it does not follow, because some instances 
of the kind have happened, that an Irishman and a fortune-hunter are synonymous terms. And — let us be just — was such a thing never done by an Englishman? Have none of them spent their little all to enable themselves to cut a 
dash at some public place where females of fortune were to be found, in hopes 
of carrying off one, as the phrase is? Can such a question be answered in the 
negative? I think that is more than any one will venture to do. The truth is, 
that the cases in which this is done are blazoned abroad in the world; they 
are made the topics of public conversation, of public animadversion; while no 


---

p.344



 
one hears of the hundreds of young men who establish themselves respectably 
in the world by the exertion of their own talents, their own industry: — "History 
relates the effects of the dangerous passions, the virtues of private life are not 
recorded by history." Mankind, in the great outlines of character, are very 
much the same in all nations and in all times; a great mixture of good and 
bad. I never could find that such a thing did exist, or ever had existed, as a 
nation wholly virtuous or wholly vicious; they are, and always have been, a 
great mixture of the one and the other. But the case with nations, as with 
individuals, is, that the wallet containing our neighbour's faults is hung before 
us, that which contains our own is behind, it is not seen.


I shall be thought, perhaps, by my countrymen to cast the severest reflection 
that can be cast upon the Irish, when I say that they perpetually reminded me 
of the French. There is a much stronger resemblance in them to the French 
national character than to the English; and this resemblance is equally forcible 
in the lower as in the higher classes of society. Nothing is more comic than 
to observe the difference between an English mechanic and a French or Irish 
one. I once, when travelling in **France**, wanted something done to the lid of 
a trunk, which I thought in some danger of splitting in two. I did not wish, 
however, to be long delayed by the job; and recollecting how an English carpenter or trunk-maker would have chiselled and planed a piece of wood, and 
fitted and fitted it over again before he could have been satisfied to nail it upon 
the trunk, and how much time all this would take, I was rather afraid of submitting my wounded servant to such a process; I thought I should be impatienté at the longueur, and I tried to persuade myself that the case was not of 
a very pressing nature. Yet the more I examined, the more imminent the 
danger appeared; and at length I desired that a carpenter might be sent for, 
stating what I wanted. Veni, vidi, vici, says **Caesar**; and so it was with the 
carpenter: I need not have been so much afraid of delay. He brought with 
him a hammer, a few nails, and a rough spline: the latter was knocked on in 
two minutes, and all was accomplished. It did not look quite so neat as if it 
had come from the hands of an English workman; it held the lid together, 
however, and all was well: but the rapidity with which the whole was performed was amusing and highly characteristic. The same is very much the 
case with the Irish: — ardent in their pursuits, rapid in their movements, they 


---

p.345



 
blaze brilliantly for a while, but the ardour is too apt easily to subside; while with 
the Englishman, who is less alive at catching fire, when the flame within him is 
once lighted, it burns on even and steady, nor is readily exhausted. It is perhaps extraordinary, considering the state of depression in which the Irish have been 
kept for such a lengthened series of years, that they still retain so much of their 
native wit, ardour, and vivacity; but even now an Irishman, like a Frenchman, 
will have his joke if it comes in his way, coute-qui-coute.


A very marked difference is, however, to be observed between the inhabitants 
of the two extremes of **Ireland** which I visited, the north-east or county of 
Antrim, and the south-west, including the counties of **Cork** and **Kerry**, strongly 
supporting the belief that their origin is to be traced to different sources. In 
the south of **Ireland** the people are much darker than in the north; and here 
was the country where the Milesians from **Spain**, according to all the traditions, 
both written and oral, were first established. Now the dark complexion, eyes 
and hair, have been ever, and still are, the distinguishing characteristics of all 
the Southern nations of Europe; as the fair complexion, blue eyes, and light 
hair, sometimes deviating into red, were, and are still, of the Northern. The 
one are bleached by colds and snows, the others darkened by the warmth of 
the sun. Now, every possible presumptive evidence leads to the belief that 
the north of **Ireland**, or perhaps all **Ireland** and **Scotland**, were originally 
peopled from the Northern nations of Europe, the parts which formed the ancient Scandinavia; while the South, if originally peopled by the same, afterwards became the settlement of an Iberian colony, whose descendants remain 
there to this day. A close and constant intercourse has always subsisted between the inhabitants of the north of **Ireland** and **Scotland**, so that they ever 
have been, as it were, one and the same people. In more than one part the 
coasts come so near as within eighteen miles of each other: the distance is no 
more between **Port Patrick** in **Scotland** and **Donaghadee** in **Ireland**, and between 
the **Mull of Cantire** in **Scotland** and the county of **Antrim** in **Ireland**. Indeed 
there can scarcely be a doubt, from the name, that **Port Patrick** was originally 
an establishment of the Irish. It is well known that the Irish are in ancient 
records called Scots; but at the Milesian conquest, these people coming from 
the land of Iberia, one of the leaders also bearing the name of Heber, thence 
the name of Hibernia, afterwards given to the island, was derived; whilst the 


---

p.446



 
natives driven constantly northwards, many of them probably at that time migrating to **Scotland**, transferred thither with themselves the name they bore. There is besides more of the true Irish quickness and vivacity in the south of 
Ireland than in the north; the people of the north partake somewhat of the solemnity of their neighbours the Scots.


To those who are fully convinced that an Irishman cannot speak without a 
bull dropping from his mouth (by the way rather a more inconvenient thing to 
be continually passing through the small orifice of the mouth, than the vipers, 
frogs, and toads of the unfortunate princess in the Contes de ma Mere l'Oie to those who are fully impressed with this belief, and hence infer that the Irish 
are all puzzlepated, I would earnestly recommend that their memories be sometimes directed towards the long catalogue of Irish names which may be cited 
as eminently distinguished in Literature and the Arts and Sciences.[32](javascript:footNote('E810001-001/note032.html')) I will 
not swell my pages with attempting to note all who might be particularized: a 
moment's recollection will suggest a very long list; but I must advert to a few 
of the most distinguished. In the name of **Swift** alone a host is mentioned, 
in more remote times **Archbishop Usher**, one of the most celebrated scholars 
of his day, and that at a period when literature was much less generally diffused 
than it is at present — a succession of Sheridans, **Goldsmith**, certainly a wit and 


---

p.347



 
genius of no common stamp, though it must be confessed that he is not exempt 
from the imputation of his country's sin, bullism; — his going over to **Holland** 
to teach English there, not himself understanding a word of Dutch, was a stroke 
rather seasoned with the spices of his native soil. Then, as a man of extraordinary parts, though his parts were scarcely more extraordinary than was sometimes his misapplication of them, the name of **Burke** must not be omitted; nor 
must we omit those of **Grattan** and **Curran**. These few being particularized 
will instantly suggest the idea of many more. But a female pen must be allowed to advert to some names among her own sex who have distinguished 
themselves, foremost in which list must be placed the name of **Edgeworth**. 
Her pictures of the manners of her own country are those, indeed, of a masterly hand; and a finer piece of wit, humour, and keen satire than her Essay on Irish Bulls will not often be read. As a painter of the manners of her 
own country too, the name of **Lady Morgan** must not be passed over; there are 
some excellent pictures of them in O'Donnel; her character of Mac Rory is inimitable. Let these names suffice to prove that native talent highly cultivated is 
not scarce in **Ireland**; that however the pretensions of the country to having been 
anciently the seat of literature may be disputed, none can deny its claims to a 
great share of distinction in that respect in modern days.




---

p.348


Celebration of the Patron. — The Long Dance. — Anecdote relating to one. — The Querne Cake. — Anecdotes respecting Irish Hospitality. — Instances of the great Family Affection subsisting among the low Irish. — The Funerals and the Funeral Orations of the Keeners. — Tenacity respecting the Places of Interment. — Remedies for Diseases. — Enchantment. — Bonfires on St. Johns Eve. — Marks on the Skin. — Youthful Marriages. — Former Modes of Dress among the Women. — Litigious Dispositions. — Anecdote of a Clergyman — and of an Irish Giant.
#### 32


The veneration for saints so prevalent in all countries where the Catholic 
religion prevails, has been already frequently alluded to, as being very strong 
in **Ireland**. Each parish has its patron saint, whose birth-day was always a 
holiday celebrated with great festivity. These days were called patrons. On 
such occasions, not only the people of the parish but the neighbours far and 
near assembled themselves together, dressed in their very best clothes. The 
older people never failed to go into the church-yard, and offer up prayers for 
the dead, particularly if any among their own connexions happened to be 
interred there. Sometimes, indeed, the whole day was spent in tears and 
lamentations. This was the case particularly among the females; and the 
merry-making ended in a day of sadness. The place where the festivity was 
celebrated was a large common, about which tents were erected; and there 
was plenty of eating and drinking, with a proportionate quantity of fiddling, 
piping, and dancing. In the dancing, each lad dressed in his best clothes 
selected his lass, who was equally adorned in all the finery she could muster. 
A circle was then formed, not a very spacious one, scarcely more than two yards each way; when one of the couples danced a sort of jig within the circle, 
neither of them taking their eyes from the ground the whole time; till at length 
the jig being concluded, the man took the woman round the waist, gave her a 
twirl, and snatched a kiss. Another couple then succeeded, and after them 
another and another, continuing thus till all had taken their turns. But as 


---

p.349



 
the whiskey always went round pretty freely at these meetings, they often ended 
in scenes of riot and disorder, not unfrequently in fighting, when ancient quarrels, which had been slumbering, broke out again. For this reason the patrons 
have, by desire of the Catholic priests themselves, been nearly laid aside.


The above festivities were of a very ancient date. Dances of a different 
kind, by no means so ancient, still continue to be celebrated, principally when 
a number of persons are desirous, for any particular reason, to honour some of 
their superiors; as for instance, the tenants of an estate for any act of favour 
shown them by the landlord, or the like. These they call Long Dances. The 
party is headed by a lad and lass chosen for the occasion as king and queen; the youngest and handsomest are generally selected. They are very much 
dressed with ribbons and other finery. The man is always in a nice clean shirt, 
the sleeves tied round the arms with ribbons, and the woman is in white; they 
carry a garland between them, and walk or dance at the head of the troop. 
When they arrive at the house of the person they intend to honour, they stop 
before the door, and the king and queen standing still, the rest of the dancers 
linked together by handkerchiefs held between each, dance in a long string 
round and round them till they are completely encircled; the company then 
dance back in the same order, till their majesties are entirely disencumbered, 
when they in their turn dance. This done, the king invites any of the ladies belonging to the mansion to come and dance with him, which is seldom refused, as 
such a refusal would be considered a great want of urbanity. The queen then invites any of the gentlemen to dance with her; and this concluded, the whole company dance according to their fancies, or else, which is more commonly the case, 
one of the men offers to amuse the company with a hornpipe. His performance is however any thing else; he twists and twirls himself about, hopping 
and jumping and turning in all directions, making great exertions, and showing 
great dexterity and agility in his motions, though the name of dancing can 
scarcely be applied to it. His countenance remains all the time entirely fixed, 
nor could the world combined make him alter a muscle: this exercise he continues as long as his breath and limbs will hold out; he does not cease till he 
is nearly exhausted. The company then, linked together, once more encircle 
their sovereign, and then untwisting themselves they all dance off in the same 
order that they came. They always expect the lady and gentleman of the house to 


---

p.350



 
furnish them plenty of drink, but do not desire any thing to eat, and very rarely 
will accept money. The company is attended by a man and woman, dressed-up ridiculous figures, who are called the Pickled Herring and his Wife; they 
make grimaces and play anticks something in the style of a Merry Andrew. Many of these frolics took place without the least disturbance ensuing, even at 
the time when the country was considered as in its most disturbed state.


The above account was given me by an Irish lady whom I have the pleasure 
of calling my very good friend, and who, having lived a great deal in a country 
village, has not unfrequently seen these dances, and describes them as really 
a very pretty sight. She added the following relation: "A few years ago 
I had been for some time resident in England; it was at a period when **Ireland** 
was represented as in a state of the utmost disorder and anarchy. Having 
however been warmly pressed by a friend in **Ireland** to return to that country, 
and take up my residence with her, I determined to disregard the terrible 
stories I heard, and accept her invitation. I went accordingly, and received 
from her the most warm and flattering reception. It was the month of April, 
the weather was uncommonly fine, and the new place of my abode looked with 
all the enchantment that could be presented by this delightful season of the 
year, by hanging woods, and a fine stream of water. Soon after my arrival, 
my friend, one day, proposed a walk into a neighbouring wood; thither we 
accordingly went, when we wandered about so long that she at length was 
exceedingly tired, and sat down while I continued my wanderings. Presently 
I was alarmed with hearing such a shout close by, that it almost stunned me; instantly all the terrible stories I had heard in England rushed upon my 
mind, and I thought I was going to see some of them realized. In the utmost 
emotion I hastened back to my friend, whom I found surrounded by a number 
of men; 
yet there was nothing in her countenance or manner that betrayed any 
appearance of alarm, and I perceived that the men were all standing quietly 
with their hats in their hands. They were her tenants, and were desirous of 
doing honour to a gentleman in the vicinity, (who had procured a number of 
them employment during the severity of the winter in a neighbouring town,) by 
planting the maypole before his door: hearing, therefore, that she was in the 
wood, they had followed her thither to ask her permission, as owner of the 
wood, to cut down a tree for the purpose, and they concluded their petition 


---

p.351



 
with three cheers, which was the noise I heard. Their prayer was granted, 
with the proviso that they were to seek for the ranger of the wood to assign 
them a proper tree; and giving three more cheers they set off in search of him. 
He was soon found, a tree was fixed on, three more cheers were given, the axes 
were applied to the root, and in a few moments it was laid prostrate on the 
earth. My friend and I hurried home to see it carried in procession to be 
prepared, painted, and dressed up for the occasion. The men I should think 
were in number about forty, and the tree being very tall they all assisted in 
carrying it upon their shoulders. By the time they passed my friend's house 
they were joined by a piper, who was seated across the tree, and thus borne in 
great state, he playing all the time, while the Pickled Herring danced along at 
the head of the procession. When they came in front of my friend's windows 
the tree was laid down, and she was once more saluted with loud and repeated 
shouts, attended with a request that her honour would permit them to come 
down the next day and have the Long Dance. Her consent obtained to this, 
again she was cheered; and the people resuming their burthen, the piper struck 
up a merry tune, the Pickled Herring resumed his antics, and away they all 
marched with the greatest order and regularity. The next day they did not fail, 
according to the permission, to have their Long Dance."


Another mode of the tenantry complimenting the landlord is, that a small 
quantity of the first wheat cut at the time of harvest is set apart, and instead of 
being thrashed, a person, holding the stalks of the wheat in his hand, beats the 
ears against a cask till the corn is all beaten out: this is called being scutched. 
The grain is then cleared away entirely from the chaff, and kiln-dried, after 
which it is spread out on a cloth or in a dish, and every bit of stone or dirt carefully picked out. This done, it is ground in what is called a querne; that is, it is 
put between two stones, the one convex the other concave, and rubbed till it 
becomes a fine flour, the bran being all ground with it; this is a very tedious 
and laborious process. It is only some farmers who have a querne; those that 
have not carry the wheat to a neighbour who has, and borrow the use of it. 
This flour is presented to the landlord, who has it made into a cake with 
cream and butter; it is baked on a griddle and eaten hot, being considered a great 
treat. When eaten, the lady of the house repeats a sentence in Irish, which 


---

p.352



 
signifies "May we all eat the same together this time twelvemonth!" No luck 
would attend the house if this were omitted.


The Irish hospitality of old so much and so justly celebrated, notwithstanding the alleged state of barbarism of the country, — though indeed I am afraid 
true hospitality is much more to be found among people little advanced in what 
is called civilization than among those who are very much so, — this hospitality, 
though very much upon the decline in **Ireland**, is by no means wholly extinct. 
In the county of **Waterford**, a family of distinction practise it to this day 
in its fullest extent. Their house is constantly open for the reception of 
strangers; — rich and poor are equally welcomed with true kindness of countenance and demeanour, and genuine warmth of heart. The house is consequently always full, always the abode of cheerfulness and happiness; the voice 
of mirth and glee resounding no less in the kitchen than in the parlour. It is 
a fact, which I have from an eye-witness on whose credibility I can safely rely, 
that at one time a cask of wine was always standing in the hall, from which 
any body might at any time draw forth as ample a libation to Bacchus as he 
chose. Yet was this generosity never abused; it was repaid with the proper 
forbearance, and the hall was never disgraced by drunkenness or riot. Part of 
an English regiment being once quartered in a town near this mansion, the wife of a lieutenant who was not very rich, having nothing but his pay to live upon, 
was seized with a dreadful and dangerous illness, a malignant fever, which 
plunged her husband into the deepest distress, not only from the affliction caused 
by her situation, but from his inability to procure her all the comforts and assistance which her situation demanded; indeed, from the nature of her malady, 
it was difficult to find any one who would come near her. The hospitable family in question, hearing of the circumstance, sent their carriage for her, and 
being well wrapped up she was removed to their house, where, through the 
good advice procured for her, and the extraordinary care and attention she experienced, she soon recovered. Most happily the kindness shown was not attended with any disastrous consequences to the family, not one caught the fever. 
Two poor labourers from the county of **Kerry**, who had come into the country 
for harvest work, on their return home were near this mansion plundered by 
robbers of their little earnings, and cruelly beat; they were found in a very 


---

p.353



 
miserable condition, were taken into the house, where they remained till recovered sufficiently to pursue their journey, and were then furnished with money 
to repair their losses and carry them home. — Such was the practice of old in 
all great houses, though now retained by very few.


It is an old saying, that when poverty comes in at the door, love flies out at the window. I believe this to be in part true; that is, as far as it concerns the 
poor rich, who are perhaps in the very worst state of poverty. But it is amazing 
to what lengths family affection is carried in an Irish cabin. This I shall perhaps be told is a refinement of sentiment, which militates strongly against what 
I have before said of the pernicious effect such extreme wretchedness must have 
upon the mind. I can only say, that there cannot be a stronger proof of the 
innate power this sentiment has over the heart, when not chilled by bitter blasts 
from adventitious circumstances, than that it is to be found so strongly in the 
midst of such misery. In one of these wretched abodes, where lived a poor 
labourer with a very large family, one of the sons, a lad about fourteen, fell 
into a consumption, and was obliged to quit a trade to which he was apprenticed and come home to his parents. Nothing could exceed the care and attention shown him by all the family. Two wretched rooms constituted the 
whole of the habitation, and he always had the best place in both; if sometimes 
he was able to walk out a little, and by chance his father or any one had taken 
his seat, the moment he appeared it was given up to him. Though the rest of 
the family lived upon potatoes, the best bread was always procured for him, and 
he had milk daily from the mansion-house in the village, whence also other 
trifles were occasionally sent him which might humour his sickly appetite. One 
of bis brothers, who had not the very best of dispositions, and was a great coxcomb in his way, (if such a term may ever be applied to the inhabitant of an 
Irish cabin;) this lad, overbearing to every body else, was yet kind and gentle 
for the most part towards his unfortunate brother. One day, however, when off 
his guard, he spoke to him harshly; the other, irritable from disease, snatched 
from him an oak stick which he held in his hand, and gave him several 
strokes with all the force his feebleness would permit: this the offender suffered without any attempt at resistance; nay, several times repeating that he 
had been very much in fault, and begged his pardon. Whether the exertion 
And irritation accelerated the poor creature's death it might be difficult to determine, 


---

p.354



 
but he died in two or three days after. The family, far from appearing to think themselves relieved from a heavy burthen, lamented the loss of him 
exceedingly, and in a manner which could leave no doubt as to the reality of their sorrow.


Another remarkable instance of this affection was shown by a mother, who 
having been married some years without children, and wishing for them exceedingly, at length had a son, who unfortunately proved an idiot. Yet this 
mother's fondness for the child was unbounded: it was not the fondness of 
compassion, but her whole soul seemed wrapped up in it; she would clasp it 
to her bosom with looks of the most tender sadness, calling it the core of her 
heart and the apple of her eye; saying that she loved it the more because no 
one else ever would love it. And when at about four years old it died, nothing 
could exceed her grief at being deprived of it, nor ever did grief appear more 
sincere: she never spoke of it but with bitter regrets, and expressions of the 
fondest affection.


The practice of employing hired mourners at funerals, though involving one 
of the most palpable absurdities that can be imagined, has notwithstanding been 
always a very prevailing one. This is carried to a great height in **Ireland**, not 
being by any means confined to the lowest classes, but obtaining equally among 
those several degrees above them. There are men who make it their regular 
employment, and have fixed prices for their services; these are called Keeners: 
the lowest price for the hire of one is five shillings; but the poor will distress 
themselves in any way for other things, rather than omit this tribute of respect 
to a deceased friend. The Keener when hired is informed of the connexions 
and family of the deceased, and the principal circumstances of their lives, that 
they may come properly prepared for what they are to say; and they make 
orations over the body, which are, according to report, at the same time extremely pathetic and truly poetical: they are always in Irish. The corpse is 
set out in the room, and the friends and neighbours are seated round it, leaving 
room at the head for the Keener. He takes his station and begins his lamentations, which are made in a sort of song or recitative, bending his body backwards and forwards, and making many gesticulations, clasping his hands together between every sentence. If the deceased happens to be a young person, 
he pathetically asks, "Why did you leave us? had you not every comfort that 


---

p.355



 
heart could wish? were you not beloved by your parents and your friends? but 
now your house is left miserable and desolate; your poor father, like a blasted 
oak, remains open to every wind of heaven, having lost its finest branches even 
in their early bloom." — Various other questions of a similar kind are put, the 
dress of the deceased is described, the place they used to occupy in the room 
while living; in short, every tender and melancholy recollection possible is conjured up and descanted upon with true pathos, and apparently with the deepest 
feeling, though perhaps, till this moment, the speaker had never heard of the 
person he laments. When his oration is finished, all the friends begin their 
doleful cry, having the hoods of their cloaks thrown over their heads and 
handkerchiefs in their hands. After they have continued this awhile, they 
cease, which is the signal for the Keener to begin again; and he is never at a 
loss for something to say: — thus they go on alternately, till the Keener has given 
the worth of the money he is to receive, when the lamentations cease, the eating and drinking commence, and pipes and tobacco are handed about — they 
are an indispensable part of the ceremony. If there is something almost ludicrous in the idea of the Keener's lamentations, thus called upon to evince a sorrow which he cannot feel, this must be a bitter and harrowing ceremony to the 
near connexions who do feel. It is to be observed that the ceremony is confined to the Catholics.


No person goes singly to purchase things for a funeral, — that is reckoned very 
unlucky, — the coffin in particular; two or three persons must be at the purchase 
of that, or it would be absolutely fatal. It was once a custom, but now nearly 
laid aside, that whenever a funeral passed where four roads meet, every person 
accompanying took up a stone and threw it by the road-side, uttering a prayer 
for the soul of the departed; in time these stones amounted to a large pile, which 
no one ever passed without crossing themselves and repeating a prayer. When 
young unmarried people are interred, a garland of flowers is placed at the head of 
the grave; and this no person on any consideration would think of removing, so 
that the time the deceased has lain there may be judged by how much more or 
less the garlands are faded. The attachment of the Irish Catholics to particular 
places of interment has been noticed: they are so tenacious of these spots that 
they will not on any account suffer a stranger to be intruded into them if the 


---

p.456



 
thing is attempted, they will even take the coffin up, carry it to a proper distance 
from the sacred ground, and there leave it exposed.


Some curious remedies for diseases and accidents are employed by the lower 
class of the Irish. A poor woman was once bit by a dog, which she immediately 
concluded to be mad, though it was not so in reality. She insisted upon the 
owner of the dog killing it, and desired that some of the blood and hair might 
be sent to her to make a plaster for her wound. This the man thought an odd 
remedy, nor could persuade himself but that it must be very pernicious to 
make use in this way of the blood of an animal supposed to be in such a diseased state; yet, desirous of satisfying the woman, he had a chicken killed, 
and sent her some of the blood with some hair which he cut off the dog. The 
woman applied the plaster; and her wound healing soon, she boasted very much of 
what she had done, piquing herself exceedingly upon her sagacity in thinking of 
the application. The trick that had been played was never disclosed to her.


A lady once walking after sunset over a rock which had the reputation of 
being enchanted, sat down awhile to rest herself, not thinking how late it was 
and the danger which might be experienced from the damps. When she got 
up she found a dreadful pain on a sudden dart through her heel, which increased 
so much that she got home with difficulty. She was immediately supposed to 
be fairy-struck, and nothing less than her speedy death was looked for by all the neighbours. The malady proved the erysipelas, from which by the assistance of good advice she soon recovered; on which the people who had been 
so assured of her death concluded her something super-human. The prayers 
of the priest are however in most cases thought of much greater efficacy than 
the medicines of the physician. A nurse to whom the care of a weakly rickety 
child was given, asked the mother's permission to carry it to a priest who lived 
near and get him to say some prayers; she said it was the only thing that could 
do it any good. The mother consented, the child was carried to the priest, he 
said the prayers desired; the child in time grew strong and healthy, and the 
nurse gave the whole credit to her spiritual comforter.


Pleurisies and agues are exceedingly *common* among the lower classes; they 
are indeed the natural result of the damps to which they are continually exposed, 
sometimes unavoidably, and sometimes through their own fault. They will 


---

p.357



 
often, when obliged to wait any where, extend themselves on the ground with 
their faces downward, regardless how damp soever it may be. Their cabins too 
are scarcely ever weather-tight; I have heard a lady say that she had gone 
sometimes into these abodes of wretchedness to visit the sick, and found the bottom (for they are never paved) quite a mire, the patient most likely lying upon a 
bed raised but a few inches from the ground by some pieces of plank. The 
first time after I came to **Ireland**, that I went to stay in the country, I was 
rather amused by seeing a paper stuck upon a wretched cabin in a village, 
half-unrooted, announcing *Dry lodgings to be had here.* It put me in mind of 
the noted Mr. Elwes's room where there was just one dry corner for the 
bed; though I must say that in these dry lodgings I questioned whether there 
was even a corner sheltered from the weather. I afterwards learnt that the 
meaning of dry lodgings, was, that lodging only was to be had, without eating and drinking.


The custom observed in most Catholic countries, of making bonfires on the 
eve of Saint John the Baptist, is still preserved in **Ireland**, though somewhat on 
the decline. An addition to it prevailed here, however, which I never saw abroad, 
that the children and cattle were made to pass through the fire; grown people 
would also not unfrequently do it voluntarily; it is considered a certain preservative against disease or accident. When the fire is dying away, the old women assemble round, and each takes away a burning stick to carry home with her, 
which is to bring a blessing upon the house, and is carefully preserved till the 
next year. It is reckoned very dangerous to be exposed to the air after sunset 
on this day, for the evil-ones are about, and are then endowed with particular 
power to harm any body. At all times it is thought hazardous to be near a wood 
at night, but the risk is never so great as on Saint John's eve! Much the same 
tricks are played among the young people in **Ireland** on Allhallows eve, as 
Burns describes in **Scotland** in his poem upon that subject. If a stranger comes 
into a farm-house where any of the usual occupations are going forward, such 
as making cheese or churning butter, if the visitor omits to say "God bless your work," and the work should afterwards go wrong, it is all ascribed to this omission, and the poor visitor is terribly execrated.


The people have a custom of marking themselves in a manner very much 


---

p.358



 
after the nature of tattooing in the South Sea Islands, only not carried to that 
excess. The women with a needle and thread dipped in strong blue water 
prick themselves, drawing the blue thread through, which leaves a mark that is 
never wholly effaced. They generally make this mark between the thumb and 
fore-finger. The men will also sometimes mark themselves in a similar manner. A friend has told me that she knew a gardener in a family whose arm was marked with the figure of Jesus Christ upon the cross: this had been done when 
he was a child, with the point of a needle dipped in soot water; he was then an 
old man, and the figure was still fresh. These marks are considered as religious. It is a custom of very ancient date.


If a young woman among the class of wealthy farmers, or a rank equivalent, 
has any fortune of her own, it is always judged adviseable by her parents to 
marry her very early, lest any other match should be proposed which they do 
not like and dare not refuse. They therefore look out for a man of good character, to whom she is given, often when not more than fourteen years of age. 
A young creature who was to be thus disposed of, on the morning appointed for the wedding was met on the staircase by her governess, who asked her whither she was going; she answered, To practise her last new lesson on the piano-forte. "My dear," says the governess, "don't you recollect that this is your wedding-day?" — "Oh dear, very true," she replied, "I declare I had quite forgotten 
it." When a young couple are about to be married, they go together to choose 
what is called the living: This is the same as the French trousseau, (the wedding-clothes,) with which the man presents his bride. For a long time after 
they are married, sometimes even for several years, they are never seen walking 
side by side, the husband precedes the wife two or three yards.


Formerly, indeed within the last twenty years, the farming class of women had 
a style of dress peculiar to themselves, which seems to have borne a great resemblance to the dress of the peasantry in some parts of the continent, particularly 
**Switzerland**. Blue stockings and shoes of the same colour with silver clasps, a 
short blue cloth petticoat plaited full all round, and a jacket of the same bound 
with silk twist and laced up the front; short sleeves with cuffs, and a mantle of 
the same colour, or brown bound with the same silk twist as the jacket, and having 
a little scolloped cape. The hair was combed up straight from the neck and forehead, 


---

p.359



 
and fastened in a knot at the crown of the head, round which was pinned 
a piece of broad ribbon of any fine showy colour. Over this was a cap of some 
very thin material through which the ribbon and hair could be seen, having ears 
to fasten under the chin, and a plain border of lace. Over the cap was tied a thin 
muslin or silk handkerchief, but put on so that the ribbon by which the hair was 
fastened might still be seen. Some wore gowns of camblet or crape stuff open 
in front, the sides and bottom of the gown being bordered within, to the depth 
of a finger or more, with a different-coloured stuff. The long blue or gray cloth 
cloak after a time superseded the little mantle, and now the whole costume is 
laid aside, this class imitating the fashions of the great. These women have an 
amazing fondness for rings, she who possesses a good stock of them is looked 
upon as a person of very great consideration. Broad heavy gold rings are those 
which are the most prized. A sort of linen used formerly to be in great request 
which was called band-linen, having that name from the measure by which it was 
sold, termed a handle; it was about the length of three fingers; the cloth was 
very narrow, not more than a handle in width; it used to be sold at about four-pence or five-pence that measure; but rising enormously in price, it is now 
fallen almost entirely into disuse.


The lower class of the men when inspired by whiskey are very apt to get 
quarrelsome; and if this happens at a fair or any kind of meeting where a number are assembled, old quarrels are often renewed, and a broken head or two 
is not unfrequently the consequence. Nothing will then satisfy them but law, 
and they must have recourse to a magistrate. — A man went one day to lay the 
case of one of these whiskey encounters before the justice, and begged he might 
have a little bit of a summons for his neighbour, he only wanted it about so 
big, showing the size he wished. In talking to their superiors these people 
commonly make use, in the style of sovereigns and critics in newspapers, of the 
plural number we, instead of the singular I; We would be very glad always to 
serve your honour; we will certainly do as your honour bids us. It is remarkable that excepting in the matter of shall and will, which are a never-ceasing fund 
of mistake, the common classes in **Ireland** speak better English than the same 
classes in England do. They would never mistake between we and us, or ours, 
as is not unfrequently done in England. I once heard a woman say very eagerly, "I am sure he killed we three pigs" meaning, "he killed three of our pigs."




---

p.360


#### 32


How! write a Tour in **Ireland**, and not give a string of Irish Bulls — that 
seems strangely out of character[33](javascript:footNote('E810001-001/note033.html')), — it would make an excellent termination to 
the present chapter. — To this I readily assent: but indeed I must confess my 
stock to be very scanty. I had minuted down one which I considered, indeed, 
as of the first quality, and by which I hoped to gain great credit among my 
readers; but on referring to **Miss Edgeworth**'s Essay, I find she ascribes the honour of it to England:
  
 
"He who saw these new roads before they were made,
  
 
Will lift up their hands and bless General Wade."
  
 
Now this, which I was given as from an Irish finger-post, she transfers to an 
English one. Disappointed then in my choice morceau, I must make an 
apology for this part of my work being so denue, and conclude with two stories 
vouched for to me as actual facts.


A clergyman going one Sunday some little distance to perform the duties 
of the day, in his ride was so unfortunate as to lose his sermon. In the case 
of such losses it is very common to post an advertisement upon the church-door, 
by which means the article lost is often retrieved. The next day an advertisement to the following effect appeared upon the church-door: "Lost, on such 
a day, between such and such a place, a sermon. Whoever has found it and 
will bring it to such a place, shall receive a suitable reward, it being of no use 
to any body but the owner." It was however nothing more than some memoranda written on a slip of paper, the clergyman being in the habit of preaching extempore.


An Irish giant had the good fortune to captivate three fair sisters at once, 


---

p.361



 
who all took some means of making known to him their tender sentiments. He was exceedingly perplexed — he had himself a decided preference for one; but he did not like to declare it, since that would seem an affront to the others. 
At length he hit upon the following expedient. He went to the top of a very high mountain, announcing that she among the three competitors who should first reach the top and join him, should become his happy bride; but, like many another promoter of a race, he played booty and gave a hint to the object of his choice what she should do. The two others set off upon the race at the utmost stretch of their powers, and had soon completely blown themselves out 
of wind; the third began gently, and kept on an even pace never beyond what she could continue, and by that means in the end passed her exhausted sisters 
and arrived before them at the goal.




---

p.362


Opinions of Travellers on the Beauties of Irish Scenery. — The Bogs of **Ireland**. 
 — Reports of Commissioners concerning them. — The **Bog of Monela**. — The 
Bogs not like the Fens of England. — Fields of Ragwort about **Dublin**. — Process of Hay-making. — Excellence of Irish Butter. — Minerals. — Mill-Stones in the County of **Kilkenny**. — Potatoe, when first introduced into **Ireland**. — The Irish Stirabout. — Particular Species of little Fish in the River **Suir**. — Many Instances of different Places having the same Name. — Saxon Architecture. — Round-towers. — Affecting Lamentation over his Country by an Irish Bard.
#### 33


**Dr. Pococke**, the celebrated bishop of **Ossory**, already more than once 
mentioned, said, that in no country he had visited, through the course of his 
various travels, had he found any thing so beautiful as the seat of Mr. McNamara at **Cong**, on **Lough Corrib**, in the county of **Mayo**. **Sir Richard Colt Hoare**'s testimony to the scenery about the Lakes of **Killarney** being superior 
to any thing he had seen in his various travels, has been noticed. My travels 
have been far less extended than those of either of these gentlemen; 
yet I can 
truly say, that I think **Ireland** affords finer scenery than any I have seen in 
my own island or in **France**; not meaning by this preference to disparage 
either, both affording beauties of no ordinary description. It is an old and 
hackneyed saying of **Ireland** to repeat, yet I must repeat it — that never was 
a country for which nature had done more, and man less. Oh, if industry 
received only half the encouragement there that it receives in England, what 
a country might it be made!


For though the numberless beauties of scenery deserve every eulogium that 
can be bestowed upon them, yet do they form but a small part of the recommendations presented by this island. By many it is believed but a country of 
bogs and of rocks; of swamps in which all soil is drowned, or masses of stone 
that afford no soil. True, **Ireland** does abound with bogs and with rocks; but it is not therefore wholly barren and desolate; these very bogs offer but one 


---

p.363



 
immense field whereon to exercise the industry of the inhabitants, while that 
industry would probably be repaid a hundred-fold. The original formation of 
them is a question which long has perplexed, and will probably long continue 
to perplex, all whose pursuits, whatever they may be, lead to an inquiry into 
the question. For not one branch of knowledge and science alone is concerned 
in it, many are included: the question may almost be considered of equal interest to the antiquarian as to the chemist or the student of philosophy and natural history. It is well known that curious remains of antiquity are perpetually found submerged in them, even at a great depth, such as gold and silver 
ornaments of very good workmanship; ancient weapons and implements of 
various kinds, the use of many of which is unknown to us. Now, since 
among the objects in gold and silver are several wholly different from any with 
which we are acquainted among the antiquities preserved to us of other 
countries, these must either have been of Irish workmanship at a very remote 
period, or they must have been imported from other nations into **Ireland** in 
very ancient times. In the one case, **Ireland** must have made considerable 
advances in the arts in ages long past, longer than our knowledge can carry us 
back, or how could they have executed such works? In the other, she must have 
been a commercial, consequently to a considerable extent a civilised nation, 
to have carried on the intercourse with other countries which would furnish her 
with these things. I could almost call the bogs antiquarian repositories.


In a report made to the commissioners appointed to inquire into the Bogs 
of **Ireland**, it is stated, "That on examination three distinct growths of timber 
are discoverable, immersed below three distinct strata of bog." The commissioners, however, think it a question "Whether the morasses were at first 
formed by the destruction of whole forests, or merely by the stagnation of water 
in places where its current was choked by the fall of a few trees, and accumulations of branches and leaves were carried down from the surrounding hills." — It goes on to state **Sir Humphry Davy**'s opinion, "That in many places 
where forests had been suffered to rest undisturbed, the trees on the outsides, 
from their exposure to the air and sun, had grown abundantly stronger than 
the rest; and when mankind attempted to establish themselves near these 
forests, cutting down the large trees on the borders, those in the interior, which, 
from the want of proper space for expanding themselves, had been drawn up 


---

p.364



 
weak and slender, were laid open to the influence of winds they were too feeble 
to resist, and thus whole forests were easily swept down[34](javascript:footNote('E810001-001/note034.html')); the large timber 
then obstructing the passage of vegetable recrement, and of earth falling towards 
the rivers, the weak soon decayed, and became the food of future vegetation." 
An observation constantly made is, that though the wood found in the bogs is 
perfectly sound, the trunks are entirely stripped of the bark, and the antiputrescent quality of the decomposed bark is considered to be a primary cause 
of the principle for which they are so remarkable, that of preserving such a variety of substances. Yet it is to be observed, that in none of the *substances* ever 
found, and animal are common as well as vegetable, any thing like a process of 
tanning ever takes place.


The **bog of Monela**, in the county of **Tipperary**, is described as exhibiting 
the three distinct strata of forest, arranged in a very palpable and rather 
remarkable manner. Stumps of trees rise in many places above the surface 
of the bog, forming the upper range; at the depth of ten or twelve feet below them is a range of large trunks, lying horizontally; then comes another 
stratum of turf as deep as the former, and below stumps of trees standing perpendicularly like those on the surface. There are traditions of a forest having 
flourished here as lately as the eleventh century. It is remarked that the bogs 
are never very low ground; that of Allen is the highest ground the great canal 
from **Dublin** to the **Shannon** passes through. This speaks strongly for their 
being formed from repeated accumulations of matter. I have mentioned large 
tracts of bog on the summits of the mountains in the county of **Antrim**, but 
I suspect these mountain bogs to be of a different nature from the others which 
occupy so much space in the centre of the island; not formed from forests, 
but from more humble vegetables, such as gorse, ferns, and different heath 
plants. There seems not depth of soil sufficient above the rock to admit the 
idea of a submerged forest; and, as far as I may pretend to judge, they had 
to me the appearance of being more spongy in their nature than those in the 
low parts. The bog on the top of the little rock called O'Donoghoe's Prison, 


---

p.365



 
in the Lake of **Killarney**, could not certainly owe its formation to the relics of a forest.


About thirty years ago was found in a bog, at the depth of seventeen feet 
below the surface, a garment of coarse woollen cloth exactly in the form of 
what has of late years been called a spencer: it was in perfect preservation. 
With it was a razor having a wooden handle, some iron heads of arrows, several large wooden bowls, some in an unfinished state, with various tools 
used in turnery. These were supposed to be the remains of a workshop which 
had stood on the borders of the forest. Now it is curious to observe that in 
the first plate to the interesting and entertaining work of the late **Joseph Cooper Walker, Esq.** On the Dress of the Ancient Irish, there is the figure of a man, 
taken from the stone cross among the ruins of **Old Kilcullen**, who wears exactly such a garment as that described, the perfect resemblance of the modern 
spencer. And since that cross is well known to be of very ancient date, and 
it is to be presumed that the figures carved upon it were in the dress of the 
times, we must presume this garment to have laid some centuries submerged in 
the bog: — what an extraordinary idea this gives of the power of their anti-destructive quality! I have seen the wood raised from the bogs represented as 
fossil-wood, but this is an extremely erroneous idea; it has not the smallest tendency to petrifaction, it is still perfect wood, retaining all the qualities of wood, only is harder than in its original state.


A very mistaken idea is entertained by many people, that the bogs of **Ireland** are of the same nature as the vast fenny tracts in England which occupy so 
large a part of the counties of **Cambridgeshire** and **Lincolnshire**, and extend 
in a smaller degree into some of the neighbouring counties, and imagine that 
they might be rendered cultivable by a similar process of drainage. Nothing 
can, however, be more dissimilar. The fens of England appear evidently to 
be lands from which the sea has retreated, consequently are formed of an alluvious soil, and lie very low. The bogs of **Ireland**, I have observed, are never 
very low land, and are a pure vegetable soil. Whether the bogs of **Ireland** are 
capable of being rendered useful to the country for any other purpose than that 
to which they are at present subservient, the supplying by far the greatest part 
of the fuel used in **Ireland**, is a question on which opinions are divided. That 
small portions of land have been reclaimed and rendered fine meadow has 


---

p.466



 
 
been mentioned; whether the process pursued in these reclamations can be 
extended to a very large scale, experience alone can determine. Thus much, 
however, may fairly be pronounced, that whatever may be their capabilities, 
the first thing to be done is to offer greater encouragements to the industry of 
the people; to raise them from the abject state in which they now feel themselves sunk; to place before them the means of obtaining a larger share of the 
comforts of life, and then stimulate their industry to catch at the golden 
branches held out to them.


Much has been done of late years in the way of improvements in agriculture, 
and many country-gentlemen are now very laudably applying themselves to the 
promotion of plans for further improving the state of the country in various 
ways; but much yet remains to be done. The immediate vicinity of the capital struck me exceedingly, as the part where of all others this spirit seemed 
to be the least awakened. I could not but recur frequently to the very different 
appearance of the vicinity of **London**, and ask myself what should prevent the environs of **Dublin** from wearing an equally flourishing aspect? Not a foot of land 
is to be seen about **London** but in the highest state of cultivation; whereas in 
the neighbourhood of **Dublin** I was perpetually struck with large fields appearing 
totally neglected, overrun with nothing but that frightful plant, the eldest child 
of negligence, the **Ragwort**. Nor can the excuse be urged that it is a barren 
and ungrateful soil, for where due attention is bestowed on it the products 
richly repay the pains bestowed. While there are too many of the desolate 
looking inclosures I have mentioned, there are others yielding as fine and luxuriant pasture as can be seen. The ample returns too of the tracts cultivated as 
gardens, and the excellence of the vegetables, show plainly of what the soil is 
capable. Let the proper stimulus be applied to industry, and there would soon 
not be a plant of **ragwort** remaining.


A singular feature in the husbandry of **Ireland** is the process of making hay. 
After having been spread out in the field for some time, when in England it 
would be considered as dried sufficiently to be finally stacked, instead of that 
it is made up into a number of petty stacks, which are left standing out in the 
field untouched even for weeks before the hay is finally carried in. It is generally asserted that if it were not left thus in small masses for a great length 
of time it would never be sufficiently dried; but gentlemen acquainted with the 


---

p.367



 
English practice say that it might just as well be transferred to **Ireland**, that 
there is no sense whatever in adhering to the present process. The Irish butter 
is always celebrated, and very justly, it is truly excellent; and I was informed 
that it owes its excellence chiefly to the different process in making it: the 
cream is not skimmed off, but the whole cream and milk are put together into 
the churn. Upon the face of the thing it would appear that this ought rather 
to impoverish the butter; but certainly the fact is, that I never met with any 
so sweet and good.


The richness of **Ireland** in mineral productions has been already frequently 
noticed; but her ores are suffered to slumber in her rocks, her marble in her quarries, for want of encouragement to bring them forth into day. As a proof how 
much of this is owing to the jealousy of rivalship in her elder sister, it need only 
be mentioned that the **Hill of Drumdowny**, in the county of **Kilkenny**, furnishes 
a kind of breccia which is found to make excellent mill-stones. Some years 
ago several pairs of these stones were exported to England, but immediately 
so heavy a duty was laid upon their importation into the latter country as to 
occasion an entire cessation of the trade. We have chosen even rather to procure this article from our rival, **France**, than our sister, **Ireland**. These stones 
are transported to various parts of **Ireland**. The vast slate mountains have hitherto been neglected; the slates used for roofing houses are principally imported from **Wales**; — this is indeed carrying coals to **Newcastle**. **Mr. Barwis** 
had a project in view for quarrying the slate upon **Lord Ormond**'s estates, and 
showed me some small pieces prepared for roofing, of a very excellent quality. 
He will, in executing this project, open a great source of wealth to his employer, 
and furnish work to hundreds who stand greatly in need of it. Indeed the supineness of the great with regard to the sources of wealth they actually possess, 
and suffer to lie neglected, is not one of the least striking features among the 
calamities of **Ireland**. By more attention to these things they would enable 
their tenants to pay the high rents which under the present circumstances fall 
so heavy upon them.


It is a singular circumstance, that the great article of food in **Ireland** at the 
present day, the potatoe, should be one which, comparatively speaking, is but 
recently known in the country. The first introduction of this root is ascribed 


---

p.368



 
to **Sir Walter Raleigh**, who brought it from **America**. At the suppression of the **Earl of **Desmond****'s rebellion, in the reign of **Queen Elizabeth**, a very large grant from the lands confiscated on this occasion was made to **Sir Walter**, which 
occasioned him to be much in **Ireland**; and it was in a garden belonging to 
a gentleman at **Youghal**, in the county of **Cork**, (pronounced Yawl,) that the 
roots he brought over were planted. **Sir Walter**, however, not remaining on the spot till they arrived at maturity, to explain what part was to be eaten, 
the gentleman concluded it to be the apple, or seed-pod, and tasted it accordingly; but found it so unpleasant, that he was not disposed to cultivate his new 
acquisition any further; and the piece of ground where the plants were, lay for 
some time wholly neglected. At length the earth being dug, the roots were 
found spread most abundantly; and from their appearance the gentleman 
guessed at the error he had been in, and tasting them, now understood that 
a real treasure was opened to him. From this original stock the whole island 
was subsequently furnished; and in not more than a century it became the 
great nutriment of the poorer classes, while it was no less the delight of the rich. 
This root has now obtained a scarcely less ascendancy in England.


Among the hardships endured by the poorer classes in **Ireland**, some persons 
consider their mode of living with respect to food one of the most grievous. I 
am not disposed to assent to this opinion. That potatoes are a most wholesome and nutritive food will not in these days be disputed; and that they are 
a pleasant food will as little admit of dispute, since the great, amid all their 
luxuries for the palate, think their dinner incomplete without them. The second 
great article of food, known by the appellation of Stir-about, is no less nutritious, though I should think far less pleasant. This is oatmeal boiled with 
water very thick, not like water-gruel, but of the thickness of the barley-meal 
food used for fatting poultry. This is often eaten without any thing to season 
it; but if buttermilk is to be procured, it is mixed up with that, and then 
esteemed a great treat. Of this food the young driver of my car over the north 
of **Ireland** was so fond, that at the inns he would decline meat or other things 
offered him, and only desired to have his mess of Stir-about. It is plain, 
therefore, that he did not find the living upon it a great hardship. This kind 
of food is, I believe, much more prevalent in the north than in the south.




---

p.369


#### 33


The rivers, the lakes, and above all the immense extent of sea-coast round 
Ireland[35](javascript:footNote('E810001-001/note035.html')), furnish an inexhaustible store of food, which might well share with 
potatoes in the sustenance of the Irish: but it is a singular thing, that fish seems 
a species of food never much relished among the lower classes in any country. 
In parts of England, where it is to be had remarkably cheap, I never saw the 
common people disposed to avail themselves of it: in fishing-towns I have seen 
the fish which were thrown aside by the fishermen as unfit for sale, suffered to 
lie and corrupt upon the beach; the poor did not think of gathering them up, 
though one might have supposed they would be an important object to them. 
I am told, however, that in the river **Suir** in **Ireland** there is a species of fish, 
(if fish they may be called, for, according to the description I have heard of 
them, they seem to belong rather to the class of reptiles,) of which the common 
people are particularly fond, and collect them in great quantities. They appear only about the months of June and July, and are to be caught in swarms 
on the banks of the river when the tide is down. They are described as in colour like shrimps, and not much larger, but not having any shell, and are taken 
in the sands with shrimp nets. In the season the banks of the river are crowded 
with women and children catching them; they are boiled, and mixed with butter, pepper, and salt. Many of the gentry also are fond of them. They are 
called universally by some Irish name, but the person from whom I heard this 
could not tell me what it was.


The instances in **Ireland** of different towns bearing the same name are very 
numerous. We have some of the kind in England, as **Newcastle-upon-Tyne**, and **Newcastle-under-Lyne**; but they occur much less frequently, and are 
always distinguished by some addition, defining at once which is to be understood. 


---

p.370



 
But this is not the case in **Ireland** excepting in one instance, the number of Carricks, which have all their proper definitions, as **Carrick-on-Suir**, 
**Carrick-Fergus**, &c .[36](javascript:footNote('E810001-001/note036.html')) Besides the city of **Kilkenny**, already so often mentioned, there is a town of that name in the county of **Westmeath**, which is indeed distinguished as **Kilkenny West**. This was also a place abounding in abbeys, some of them very ancient. There are three Tullamores, in the counties of **Down** and **Kerry** and in the **King's county**; — three Dundrums, in the counties of **Down**, **Dublin**, and **Tipperary**; — two Ballymoneys, in the counties of **Antrim** and of **Wicklow**; — two Ballynahinches, in **Down** and **Galway**; — two Downpatricks, in **Down** and **Mayo**; — two Aghrims, in **Dublin** and **Galway**. — 
These are but a few out of very numerous instances; — there are several Newcastles, none having any particular distinction affixed to them. — With rivers it is the same; there are three called the **Blackwater**, one in the county of **Cork** which runs into **Youghal Bay**, another in the county of **Kerry** which runs into the **Kenmare river**, and a third in the county of **Tyrone** which runs into **Lough Neagh**.


I have several times mentioned, in speaking of the remains of ancient architecture, arches of that round kind which are usually called Saxon; and I have mentioned them in this way, because it appears to me that to ascribe this species of architecture in **Ireland** to the Saxons must be a mistake, since they never at 


---

p.371



 
any period were established in that country. May they not much rather be 
considered as Danish? since the Danes had acquired very large possessions in various parts of the island. The cathedral of **Christchurch** in **Dublin** was in 
part founded by a Danish prince, and here we have one arch of the round kind, though the rest are Gothic, but this mixture is not uncommon. I should think it very probable that some of the remains in England called Saxon, would also be more properly ascribed to the Danes.


But of all the architectural remains in **Ireland**, the Round-towers have been 
for centuries past, and will continue to be perhaps for centuries to come, the 
subject of the greatest curiosity. I have studied them, I have read the opinions of different writers upon the subject; and the conclusion in my mind is, that they ought to be considered as living witnesses (let me be allowed that expression) 
to the great antiquity of the Irish nation. One author, however, I have not 
studied, I have carefully avoided it, **General Vallancey**; he is a writer to whose 
theories such strong objections are made, who is treated as so wild and enthusiastic, that having formed my own ideas I was determined not to be influenced 
by his. At the same time I must observe, that it appears somewhat extraordinary his opinions should have been met by many persons with such sovereign 
contempt. He was not an Irishman, therefore could not be accused of national 
partiality; he had travelled much, he had seen much; above all he had studied 
the Eastern languages, manners, and customs; — was he not therefore a better 
judge, whether in the Irish language, manners, and customs, a resemblance was 
to be found to the Eastern, than those who have never studied either? and such 
is probably the case with three-fourths, nay most likely with nine-tenths of those 
by whom he is condemned. Many things when wholly new to us strike as absurdities, which better known appear in a very opposite light. It is very common to suspect travellers who relate things of other countries wholly different 
from any thing hitherto known, of being addicted to the marvellous, and of 
having a propensity to deviate from absolute fact with a view to embellishing 
their narratives. Such was strikingly the case with **Bruce** and with **Le Vaillant**. 
But at the time when their Travels were published the countries they visited were 
little known; many things therefore related by them appearing wholly strange were rejected as impossible to be true; 
yet every subsequent traveller in the same regions has confirmed their relations and the reputation of one at least, 


---

p.372



 
of **Bruce**, is now fully established. **Le Vaillant** will never have an equal reputation; though the veracity of many things asserted by him, which had been 
doubted, is now ascertained: but there is a kind of coxcombry in his manner 
of writing which will always throw a shade over the real information his Travels 
contain. In like manner if people would become acquainted with the Irish 
language, and study the Irish antiquities, endowed with the same previous 
knowledge that **General Vallancey** possessed, they might possibly have a very 
different opinion of his celebrated work Collectanea de Rebus Hibernicis. However, I repeat that, for the reasons above stated, I never read it.


I must cite a note to **Dr. Smith**'s History of the County of **Cork**. "**Diodorus Siculus**," he says, "in his third book has preserved an account from **Hecateus**, a very ancient author, of a Northern island little less than 'Sicily, situated over-against the Celtae, and inhabited by those whom the Greeks called 
Hyperboreans. It is, says he, fruitful, pleasant, and dedicated to Apollo; 
that God used for the space of nineteen years to come and converse with them; 
and, which is more remarkable, they could show the moon very near them, and 
discover therein mountains, &c. They had a large grove, and temple of a round 
form, to which the priests frequently resorted with their harps, to chant the 
praises of Apollo, their great deity. He says they had a language of their 
own, and that some Greeks had been in the country and presented valuable 
gifts to the temple with Greek inscriptions on them; and that one Abaris, who 
became afterwards a disciple of Pythagoras, went hence into Greece, and contracted an intimacy with the Delians.' The situation of this island opposite to 
the Celtae, who were the inhabitants of Britain or Gallia, its being compared 
with Sicily in size, its being dedicated to Apollo, that is the Sun, which planet 
was certainly worshipped by the Irish, as I have elsewhere shown, the description of their temples, which were round, and the mention of their harps, are 
all so many concurring circumstances which render it probable that no other 
place than **Ireland** could here be meant."


So far says **Dr. Smith**. Now it can scarcely be doubted but that **Ireland** is 
the place here designated: and since it is said that Apollo was worshipped there, 
that the temples were round, that their God used for nineteen years to come 
and converse with them; — and since in no Christian country any thing bearing 
the remotest resemblance to these towers has ever been found, is it not a much 


---

p.373



 
more reasonable conclusion, than supposing them Christian belfries, to consider 
them as remnants of this very ancient superstition? Let the construction of 
them be considered: they are lofty, from about seventy feet high to one hundred and thirty, small in diameter, from twelve to nineteen feet, the walls included, which are three feet in thickness, or in the very tall towers somewhat 
more. The entrance is at a considerable distance from the ground, after the 
manner of the modern Martello towers, some being at the height even of twenty-four feet. A trifling loop-hole or two is the only light they have except at 
the very top, where are four windows in the direction of the four winds. There 
is no appearance of their having been divided into stories, or of ever having 
had a staircase; they are hollow within from top to bottom, without the least 
reason to suppose they ever were otherwise. What then appears so probable 
as that these were places in which the priests of this religion pretended to hold 
converse with the God who was worshipped in the country, Apollo, or the Sun? that they ascended to the top by some temporary means, never suffered to remain 
there but while they were holding their mystical conferences? These towers were 
made lofty that they might approach the nearer to him, and be more out of the 
way of observation; and they had a window to each of the cardinal points, that 
at whatever part of the heavens he was they might face him, or nearly so. The 
entrances were made at such a height that no prying eye might intrude itself 
into the mysteries within. To me this does seem a far more probable conclusion, 
than supposing them to have been built as belfries to the Christian churches, 
or as places of penance for the Christian devotees. Perhaps when in a former 
place I have supposed them appendages to the Druidical superstition, I have 
not gone back far enough; the worship of the Sun was most likely of an anterior date, and the Druids perhaps only grafted their superstitions upon it 
while the Christians afterwards erected their churches by them, from the spots 
being already considered holy. That they were at a future period used as belfries by the Christians is very possible, yet in none that I have seen could I 
perceive any appearance of it. Two of these towers, that at **Swords** and another at **Clunmacnoise**, have their entrances level with the ground; but this 
has not improbably been done in later years, to lay them more open to inspection. That which I visited at **Drumbo** near **Belfast** had the entrance not more 
than three or four feet from the ground, but the tower had the appearance of 


---

p.374



 
having been very much earthed up. There are sixty-four of these structures 
now remaining in different parts of the country.


Let me close the remarks I have been induced to offer upon ancient and 
modern **Ireland** — in which I hope my opinions will not appear to be given arrogantly and dictatorially, or with too much prolixity — by a quotation from 
**Dr. Smith**'s Introduction to his History of Cork, and the Lamentation of a Bard over the fallen State of his Country after the English Conquest. **Dr. Smith** says: "When we shall mind our true interest, in employing and encouraging 
every where all our own idle hands, and afterwards those of other nations who may be induced to settle among us; when our nobility and gentry become examples in these particulars; when we shall thus be induced to inclose and improve every foot of our land, to make the utmost use of our home-growth, above and under ground, and of all our sea-ports, it is very easy to see what an additional lustre this island will be to the diadem of the British empire, both abroad and at home, in beauty, strength, and glory."


This is the reflection of the philosopher. — Thus does the bard pour out the sad emotions of his soul: — "O the condition of our dear countrymen! how feeble are their joys! how pressing are their sorrows! the wrecks of a party ruined! their wounds still rankling! the wretched crew of a vessel, tossed long about, and finally cast away! — Are we not the prisoners of the Saxon nation? the captives of remorseless tyranny? Is not our sentence pronounced, and our destruction inevitable? — Frightful, soul-rending thought! — Power exchanged 
for servitude, beauty for deformity, the exultations of liberty for the pangs of 
slavery, a great and brave people for a servile and desponding race. — How came this transformation? — Shrowded in a mist, which bursts upon you like a deluge, which covers you with successive inundations of evil, ye are not the same people! — Need I appeal to your senses? — But what sensations have you left? — In 
most parts of the island how hath every illicit practice, every unwarranted 
stretch of the strong arm of power, taken place of law and equity! — and what must that situation be, wherein our only security depends upon an intolerable subservience to lawless law? — In truth, our miseries were long ago predicted in the changes these strangers wrought in our country. — They have hemmed in our sporting lawns, the former theatres of glory and virtue, — they have wounded 
the earth, and disfigured with towers and ramparts those fair fields which Nature 


---

p.375



 
bestowed for the support of God's animal creation, — that Nature which we see defrauded, and whose laws are so wantonly counteracted, that this late free **Ireland** is metamorphosed into another **Saxony**. The people enslaved, no longer recognise their common mother, — the mother equally disowns her children; — alas! both have lost their forms; and what do we see but insulting Saxon natives, and native Irish aliens? — Hapless land! thou art a bark through which the sea has burst its way, — scarcely is any trace of you to be discerned in the hands of the plunderer! — Yes, the plunderer hath refitted you for his own 
use! ye are new-modelled for his purposes! — Ye Israelites of Egypt, — ye wretched inhabitants of this foreign land, — is there no relief for you? — Is there 
no Hector left for the defence, or rather for the recovery, of this Troy? — It is thine, O my God! to send us a second Moses! — Thy dispensations are just and unless the children of the Scythian, — the children of Heber the Scot, — return to thee, ancient **Ireland** must never hope to rise from the ashes of modern **Saxony**!




---

p.376


Last Visit to **Saint Valeri**. — Adieu to **Dublin**. — Passage to **Liverpool**. — **Mr. Kean** performing there. — Dr. Parr's flattering Admiration of his Talents, and Attentions to him. — Visit to **Gloucester**. — The Cathedral. — The Coming-up of the Bore. — The new Medicinal Waters. — Organic Remains. — Return to **London** by **Bath**.
#### 34


On returning to **Dublin** from my Southern Tour, nothing remained but to take leave of my Irish friends and depart for England. I had promised not to quit the country without once more visiting **Saint Valeri**; and finding Mr. Walker in **Dublin**, but about to return into the country the same evening, thither I accompanied him for two nights, and then prepared for my departure. I had once thought of not returning to **Dublin** from the south, but going from **Kilkenny** to **Waterford**, and thence crossing to **Milford-Haven**. Many circumstances, however, determined me at length to abandon this idea, and abide by 
the old route of **Liverpool**. I accordingly embarked on the 27th of September, 
at five in the afternoon, on board the very Duke of Richmond packet for which 
I had waited in vain on the other side of the Channel.


The wind was fair and promised a favourable passage, so that we hoped 
to be in **Liverpool** within the twenty-four hours. But unfortunately the next 
morning the wind sunk entirely, and left us in such a dead calm that we made 
no way at all, and as evening came on great doubts were entertained whether 
we could get round the **Black-Rock** (for **Liverpool** too has her **Black-Rock**) 
and into the **Mersey** before the tide was too far down to admit of our passing 
the shoal round the rock point. It did just serve, we turned the rock, and anchored within the river; but though in sight of the town, there we were obliged 
to remain till the return of the tide, before we could get up to it. About five 
in the morning the anchor was weighed, and about seven we landed. In the 
night the wind rose so much that the conclusion of the voyage was through a very boisterous sea.




---

p.377


#### 34


To my great surprise I found Mr. and Mrs. Kean still in the town, and that **Mr. Kean**'s benefit, the last time of his performance, was to be the same evening. I knew that he had been performing at **Liverpool**, but thought his time was expired and that he had left it some days. I mention this circumstance because I wish to record the opinion entertained of this accomplished performer's talents, by perhaps one of the first judges of dramatic merit the country can boast, that distinguished scholar Dr. Parr. He happened at this time to be on a visit to Mr. Roscoe at Allerton, and never having seen **Mr. Kean**, was persuaded to attend his performance of **Richard the Second**. This was before I came to **Liverpool**; but having the great pleasure of mingling much with the same society 
of which he was now the life and ornament, I had the satisfaction of hearing 
that greater admiration of the performance could hardly have been testified; so 
much was he pleased, that he even went into the Green-room at the conclusion 
of the play to compliment **Mr. Kean** himself and assure him of the great pleasure he had received. Nor did he stop here; when the character was to be repeated for **Mr. Kean**'s benefit he went this second time to see it. I was then 
in **Liverpool**; — I was not in the same company with the Doctor at the play, 
but met him after it was over at **Mr. Kean**'s lodgings whither he had gone once 
more to express the warmth of his admiration, and to take his leave of him, as 
**Mr. Kean** was to leave **Liverpool** the next day. Afterwards in talking to me 
upon the subject, he thus emphatically expressed himself: "Madam, there has 
been a frightful chasm in the theatre from **Garrick**'s time till the present, but 
now we can once more boast that we have an actor." I was not a little pleased 
and gratified to find such a confirmation of my own taste.[37](javascript:footNote('E810001-001/note037.html')) 
After again passing four days most agreeably at **Liverpool**, I proceeded to 
**Gloucester** on a visit to my brother and sister, the former being dean of this 


---

p.378



 
cathedral. During eight years that he had been so, this was the first occasion 
when it had been in my power to accept the many kind invitations I had received to be his guest at the deanery. I had often heard **Gloucester cathedral** mentioned as among the finest of our Gothic churches, and so indeed it is for 
the greater part. Nothing can exceed the beauty of the tower, of the east 
window, of the Lady Chapel at the east end of the cathedral, of the cloisters, 
and of almost all the south side of the church: the only thing to be observed 
in the reverse of the picture is, the great difference between the north and 
south sides, they hardly appear as if belonging to the same building. For the 
rest, it is truly a noble structure. There is a very good library belonging to 
the Chapter. I was fortunate in being here just at the full moon and the 
spring-tides, so that I saw one of the great curiosities of the place in very high 
perfection. This is what is called the coming-up of the Bore[38](javascript:footNote('E810001-001/note038.html')), that is, the rush 
of the tide up the river. The effect is very extraordinary, nor did I ever 
see the same in any other tide river. The water does not rise gradually, 
as in most cases, but an immense body rushes forwards, so that in a few 
minutes the river rises several feet; and it seems to come with a force that 
would even bear down a mountain if one stood in its way.




---

p.379


#### 34


I also went and examined some new medicinal waters only lately discovered, of a similar quality to the Cheltenham waters. Several springs have been opened; and a very nice bath-house is built, where are hot and cold 
baths, or where any one may drink the water. Plantations and walks are 
making all about; and when the shrubs and trees are grown up, it will be an 
extremely pretty spot. Small ammonites have been dug up very much in 
turning the ground to search for springs; and I saw at the deanery many organic remains, which had come from the neighbourhood of **Gloucester**; but 
I had not time to go and explore the hills where they are principally found. 
The stone of the country is a pure shelly limestone. From this place I went 
to **Bath**, to visit another sister; and thence returned to **London** after a very 
pleasant excursion.


