

#Lewis Dillwyn's Visit to Waterford, Cork and Tipperary in 1809


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Lewis Dillwyn's Visit to Waterford, Cork and Tipperary in 1809
==============================================================


Author: Lewis Weston Dillwyn
----------------------------


### File Description

Gerard J. LyneElectronic edition compiled and proof-read by Beatrix Färber

Funded by University College, Cork, School of History 1. First draftExtent of text: 16465 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E800005-002Availability [RESTRICTED] 
Available with prior consent of the CELT project for purposes of academic research and teaching only.


#### Notes

We are very grateful to Gerard Lyne, formerly Keeper of Manuscripts at the National Library of Ireland, and the Board of the Cork Archaeological and Historical Society for their kind permission to publish this material in electronic form on CELT.

#### Sources


**Manuscript**2. Trinity College Library, Ms. 967 (Q. 3. 19) [Journal of a tour from Swansea to Cork by L. W. Dillwyn, 1809].
**Literature (including that referred to in annotations)**2. Richard Twiss, A tour in Ireland in 1775 (London: printed for the author, 1776).
3. [Dunn (attributed)], A Description of Killarney (Dublin 1776).
4. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (Dublin 1778). [Available online at CELT.]
5. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom: made in the years 1776, 1777, and 1778. And brought down to the end of 1779. London, printed by H. Goldney, for T. Cadell and J. Dodsley, 1780; Dublin. A new edition by A. W. Hutton, 'Arthur Young's tour in Ireland, 1776–1779', was published 1892 in London.
6. George Taylor and Andrew Skinner, Taylor and Skinner's Maps of the Roads of Ireland, surveyed 1777 (London 1778; Dublin 1783).
7. William Camden, Brittania (...) translated from the edition published in 1607, enlarged by the latest discoveries by R. Gough (London 1789).
8. Caspar Voght, Schilderung von Irland, Bruchstücke aus dem Tagebuche eines Reisenden. Im Herbst 1794, in: August Hennings, Der Genius der Zeit, Bd. 8, (Mai bis August 1796) 566–653. [Available online at CELT.]
9. Horatio Townsend, A general and statistical survey of the county of Cork (...) (Dublin 1810).
10. Jacques Louis de Bougrenet Chevalier de La Tocnaye, A Frenchman's Walk through Ireland 1796–7 (Promenade d'un François dans l'Irlande), translated by John Stevenson (first published Cork 1798; repr. Belfast 1917; Dublin 1984).
11. William Wilson, The postchaise companion (Dublin [1784?? 1806]) [Later editions were known as 'Wilson's Modern Pocket Travelling Map of the Roads of Ireland including all the Post Towns, etc.' or simply 'WILSON'.
12. J. T. Mackay, Systematic catalogue of the rare plants found in Ireland, in Transactions of the Dublin Society 5 (1806) 59–.
13. Sir Richard Colt Hoare, Journal of a Tour in Ireland, AD 1806 (Dublin and London 1807).
14. J. Charles, Modern map of the Roads of Ireland including all the Post Towns (Dublin 1814).
15. Thomas Crofton Croker, Researches in the south of Ireland (London 1824) [available online at CELT].
16. Samuel Lewis, A Topographical Dictionary of Ireland, comprising the several counties, cities, boroughs, corporate, market, and post towns. Parishes, and villages, with historical and statistical descriptions (...) (London 1837). [Available online at http://www.libraryireland.com/topog/index.php].
17. A. Knox, The Irish watering places (...) (Dublin 1845).
18. W. J. O'Neill Daunt, Personal recollections of the late Daniel O'Connell M.P. (London 1848).
19. Charles John Robinson, 'The family of Croker', The Herald and Genealogist 8, edited by J. G. Nichols (London 1874) 377–391.
20. Henry F. Berry, 'The manor and castle of Mallow in the days of the Tudors', Journal of the Cork Archaeological and Historical Society, Ser. 1, Vol. 2, No. 14 (1893) 21–25; Ser. 1, Vol. 2, No. 15 (1893) 41–45.
21. J. Coleman, 'The old castles of south-west Cork', Journal of the Cork Archaeological and Historical Society 27 (1922) 63–66.
22. George Dames Burtchaell and Thomas Ulick Sadleir, Alumni Dublinenses: a register of the students, graduates, professors and provosts of Trinity college in the University of Dublin: 1593–1860 (Dublin 1935).
23. James Blennerhasset Leslie, Raphoe clergy and parishes: being an account of the clergy of the Church of Ireland in the diocese of Raphoe, from the earliest period, with historical notices of the several parishes, churches, etc. (Enniskillen 1940).
24. A. Ó Coindealbhain, 'The walls of Cork', Journal of the Cork Archaeological and Historical Society, 48 (1943) 61–62.
25. H. Butler, 'New Geneva in Waterford', in Journal of the Royal Society of Antiquaries of Ireland 77 (1947) 150–155.
26. Frederick George Hall, The Bank of Ireland 1783–194 (Dublin 1949).
27. Olive C. Goodbody, Guide to Irish Quaker records 1654–1860 ... (Dublin 1967).
28. Eileen M. McCracken, The Irish woods since Tudor times (Newton Abbot 1970).
29. P. J. Sinnott, 'Duncannon', Old Wexford Society Journal 3 (1970–71) 63–80.
30. Evelyn Bolster, A History of Mallow (Cork 1971).
31. Mary Scannell and Donall M. Synnott (comp.), Census catalogue of the flora of Ireland (Dublin 1972).
32. Seán Ó Luing, 'Richard Griffith and the roads of Kerry', Journal of the Kerry Archaeological and Historical Society 8 (1975) 89–113.
33. Mark Bence-Jones, Burke's guide to country houses: Vol I: Ireland (London 1978).
34. Hugo Read, 'The Penroses of Woodhill, Cork: An Account of their Property in the City', in Journal of the Cork Archaeological and Historical Society, 85 (1980) 79–98.
35. E. Keane, P. B. Phaire and T.U. Sadleir (eds), King's Inns admission papers 1607–1867 (Dublin 1982).
36. P. E. Roberts, 'Caravats and Shanavests: Whiteboyism and faction fighting in East Munster, 1802–11', in Samuel Clark and James S. Donnelly Jr (eds), Irish peasants: violence and political unrest1780–1914 (Manchester 1983) 64–101.
37. J. Copps, 'Historic walk through Mallow', Mallow Field Club Journal 1 (1983) 19.
38. Kevin Myers, 'The Mallow spa', Mallow Field Club Journal 2 (1984) 5–17.
39. C. Cooper, 'A note on Mallow spa', Mallow Field Club Journal 2 (1984) 18–19.
40. J. Copps, 'Mallow castle and the Jephson family', in Mallow Journal 3 (1985) 47.
41. C. A. Empey, 'The Norman period 1185–1500', in William Nolan and Thomas G. McGrath, ed., Tipperary: history and society (Dublin 1985).
42. Gerard J. Lyne and M. E. Mitchell (eds), 'A scientific tour through Munster: the travels of Joseph Woods, architect and botanist, 1809', North Munster Antiquarian Journal 27 (1985) 15–61.
43. Gerard J. Lyne (ed), 'Rev. Daniel A. Beaufort's tour of Kerry, 1788', Journal of the Kerry Archaeological and Historical Society 18 (1985) 183–214. [Available online at CELT.]
44. Helena C. G. Chesney, 'The young lady of the lichens: Ellen Hutchins (1785–1815)', in: Mary Mulvihill, Stars, shells and bluebells: women scientists and pioneers (Dublin 1997) 28–39.
45. Donal Synnott, Botany in Ireland, in: John Wilson Foster; Helena C. G. Chesney (eds), Nature in Ireland: a scientific and cultural history (Dublin 1997).
46. Richard S. Harrison, Abraham Abell: member of the Royal Irish Academy and Corkman extraordinary (Skibbereen, Co. Cork 1999). [Abraham Abell, 1789–1851].
47. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
48. Jane O'Hea O'Keeffe, Voices from the Great Houses (Cork: Mercier Press 2013). Includes a section on the Hutchins family.
**Lewis Weston Dillwyn: Life and Works**2. See the Oxford DNB, online edition, at http://www.oxforddnb.com/view/article/7670
3. According to Copac data, Lewis Weston Dillwyn's diaries (36 vols) are fully transcribed by Richard Morris are and available for academic use at https://onedrive.live.com/redir?resid=CA4F28D7770EE036!1042=!ADiCdDHXNUMlAGI=folder%2c
4. Lewis Weston Dillwyn and Dawson Turner, The botanist's guide through England and Wales (London 1805).
5. Lewis Weston Dillwyn, Letters from Lewis Weston Dillwyn 1803, Oct. 15. 1808, Aug. 27, "one to W. Phillips, 1803, and the other to Sir T. F., 1808" (Copac) [=National Library of Wales MS 14005E, ff. 43–45].
6. Lewis Weston Dillwyn, British Confervae; or colored figures and descriptions of the British plants referred by botanists to the genus Conferva (London 1802–9). (Available at Boole Library, UCC, Special Collections.) [Translated into German as 'Grossbritanniens Conferven, nach Dillwyn für deutsche Botaniker bearbeitet von Friedrich Weber und D. M. H. Mohr (Göttingen 1803–1805)].
7. Lewis Weston Dillwyn, A Descriptive Catalogue of Recent Shells, arranged according to the Linnaean method: with particular attention to the synonymy (London 1817).
8. Lewis Weston Dillwyn (ed), Historia sive synopsis methodica Conchyliorum, Martini Lister. Editio tertia, recensuit et indice locupletissimo instruxit L. W. Dillwyn. (Oxonii/Oxford 1823).
9. Lewis Weston Dillwyn, Fauna of Swansea, in: British Fish 1848 [book published between 1848 and 1882, according to Copac data].
10. Lewis Weston Dillwyn, Calendar of the diary of Lewis Weston Dillwyn. Vol. 1. 16 October 1817 to 14 November 1823. Vol. 2. 18 November 1823 to 31 December 1833. Vol. 3. 1 January 1834 to 15 July 1852. 3 vols. (Aberystwyth, National Library of Wales, 19--).
11. Lewis Weston Dillwyn, Contributions towards a history of Swansea (Swansea 1840).
12. Lewis Weston Dillwyn, Hortus Collinsonianus: an account of the plants cultivated by Peter Collinson. (Swansea 1843).
13. Lewis Weston Dillwyn, Materials for a Fauna and Flora of Swansea and the neighbourhood (Swansea 1848).
14. Soranus (=Thomas Williams), Lewis Weston Dillwyn, Esq., of Swansea, The Cambrian Journal (Science and scientific men of Wales) (Tenby 1855).
15. Lewis Weston Dillwyn, The diary of Lewis Weston Dillwyn. (South Wales and Monmouth Record Society Publications; vol. 5) (1963).
16. Ray Desmond and Christine Ellwood, Dictionary of British and Irish botanists and horticulturists ... (London 1977, rev. edn 1994).
**The edition used in the digital edition**2. **Gerard J. Lyne**, Lewis Dillwyn's Visit to Waterford, Cork and Tipperary in 1809 in Journal of the Cork Archaeological and Historical Society, Ed. Diarmuid Ó Murchadha. , Cork, The Society (1986) volume 91page 85–104: 86–104

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pp 86–104 (footnotes on pp 101–104). The editor's short introduction with four footnotes has been left out, covering much the same ground as the introduction to Dillwyn's tour of Kerry. This tour takes place between entries 12 and 13, and is available on CELT in file E800005-001.


#### Editorial Declaration


##### Correction


The text has been checked and proofread twice. Editorial footnotes 5 to end are retained, renumbered at CELT, and take the form note type="auth" n="". Two sources of quotes were identified at CELT. All supplied text is tagged. Text supplied by the editor is marked sup resp="GJL".


##### Normalization


The electronic text represents the edited text. Some abbreviations of titles or botanical terms have been expanded silently.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break or line-break have been placed on the line on which they start.


##### Segmentation


div0= the description; page-breaks are marked pb n=""/.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd. Date values are encoded.


##### Interpretation


Names of people, places and botanical terms are tagged.


#### Canonical References


This text uses the DIV1 element to represent the entry. ### Profile Description


Created: By Lewis Weston Dillwyn (1778–1855)
 Date range: 6 July to 1 August 1809.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Many botanical terms are in Latin.


##### Language: [GA] Some words are in Irish.


##### Language: [FR] A word or two is in French.


### Revision History


* (2014-09-23) Beatrix Färber (ed.)

* File parsed and validated. Provisional SGML and HTML files created.
* (2014-07-14)  (ed.)

* File proofed (2); two quotes identified; more bibliographic details added; footnotes and cross-references renumbered.
* (2014-07-04) BF (ed.)

* File proofed (1), structural and content encoding applied, including personal and place names; footnotes added and encoded; bibliographic details added.
* (2014-07-04) Beatrix Färber (ed.)

* Text converted to XML; TEI header created.
* (2014-07-03) Beatrix Färber (text capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E800005-002


### Lewis Dillwyn's Visit to Waterford, Cork and Tipperary in 1809: Author: Lewis Weston Dillwyn




---

p.86


{MS page 1}After a pleasant Journey in the Mail from **Swansea** **Mr. Leach** & myself reached **Milford** soon after 6 O'clock on the Evening of Thursday, July 6th. We found that the Packet would not sail till next morning & therefore after having dined at Nelsons Hotel we walked to B. Rotchs at Castle Hall and there met **Mr. Woods**. After Tea we returned to **Milford**, & **Mr. Woods** promised to hold himself in readiness to join us as soon as sent for.


Friday July 7th
  

We were called soon after 6 & told that the Packet would sail in an hour & that a Messenger had been sent to Castle Hall for **Mr Woods**. Our luggage having been previously searched by a custom house Officer was sent on board last night & therefore as soon as we had breakfasted we were ready {MS page 2} but we were sadly disappointed by the non-arrival of **Woods** for whom we waited near an hour. At length the Captain of the Packet declared he could wait no longer, & as our luggage was on board we were reluctantly obliged to embark without him. About half an hour *[after]* we had got under weigh we saw a Boat with six Oars & crowding Sail to overtake us. Capt. Jankins civilly laid to till the Boat came up & then **Woods** to our no small satisfaction jumped on board.


Our sail down **Milford Haven** was very fine, & after we had passed St Anns head the numerous small Islands among which we sailed presented some of the wildest rocky cliffs I ever saw, & an immense number of Shags & Guillimots which inhabit them flew around us. We chatted & laughed very merrily on Deck with 4 Irish Gentlemen who were our fellow Passengers till about Noon when it began to rain hard & we were driven into the Cabin. I then became so Seasick that I went to Bed and remained there till the Steward woke me up with the pleasant tidings that we had arrived in Waterford River. It was then 1/2 past 11 & {MS page 3} at 12 we were landed at **Cheek Point**.


After a good deal of clamorous rapping we gained admittance to the Inn which is large & good looking without, but we found the inside so little inviting by either sight or smell that **Woods**'s appetite failed him & he went to Bed. **Leach** & I were too hungry to mind trifles, & we joined two of our fellow Passengers in making a hearty Meal, but I could not help being reminded of the following Story which I heard just before I left **Swansea**. A Gentleman travelling in this Country whilst his Dinner was preparing at a small Inn saw a Child with a dreadfully ulcerated & scald head. Disgusted at the sight he asked her why she didn't wear a Cap. ‘And to be sure’, answered the Child ‘isn't my Mother boiling your pudding in it’.


Our Luggage was all taken & locked up by the Custom house Officers, who told us that it could not be searched or restored till next morning. I begged them to give me a small Leather case, in which I keep my Dressing things & a few other Articles. They were excessively polite a la mode d'Irelande, & begged to know its contents which I told them & among {MS page 4} other things mentioned a pair of Shoes. They asked me if they were new (in which case I find they would have been seizable) & I gave them my word they were half worn out. ‘Och’, says the fellow, ‘I am perfectly satisfied with your word of honor, but I shall be greatly obliged if


---

p.87



you'll just let me look at them’.


Saturday July 8th
  

I rose soon after 5 & whilst our Breakfast was preparing I strolled with **Mr Leach** along the Banks of the River Suire where we found a variety of **Trubo littoralis**[1](javascript:footNote('E800005-002/note001.html')) &c. We with great pleasure left the vile Inn at **Cheek Point** at 1/2 past 7 & were driven over an Excellent Road to **Waterford** which is 7 Irish Miles distant. Eleven Irish are equal to Fourteen English Miles. Our Chaise which we were told is reckoned tolerable in this Country was by far the most miserable I ever saw, but it is impossible for any language to describe the appearance of our Driver. He had a peculiar Hibernian cast in his countenance, & his Cloathes which were apparently the Cast-offs of some English {MS page 5} beggar had never been mended since they came in his possession, & certainly neither they or his Skin had ever been washed since they were made. The want of a middle Rank struck me forcibly as we rode along for we rarely saw any Houses that were not either the Villas of Gentlemen or the most wretched Hovels, & the People were generally either well dressed or clothed in Rags.


On our arrival at **Waterford** as well as at **Cheek Point** we were strangely puzzled about the value of our Money. I changed a one pound Bank of England Note & they gave me a Bank of Ireland Note of the same nominal value together with two Silver tenpenny pieces. An English Shilling which they call a Hog or thirteener passes for 13d & a sixpence which is called a Pig is valued in the same proportion.[2](javascript:footNote('E800005-002/note002.html')) We took up our Quarters at the Commercial Hotel than which I never saw a more elegant commodious or comfortable Inn.


After we had lunched and whilst **Woods** went to see some Relations **Mr Leach** & I took a five hours, {MS page 6} ramble on the Kilkenny side of the River. The Bridge over which we passed is very fine & of great length & is entirely built of wood. It was erected in 1794 by Subscription & till last year paid 10 per Cent since which the Dividend has increased. The Architect is an American named **Cox**, who also built the Bridge at **Londonderry**.[3](javascript:footNote('E800005-002/note003.html'))


On the Rocks by the road side I found **Fumaria claviculata**[4](javascript:footNote('E800005-002/note004.html')) & **Cotyledon umb*ilicu*s**[5](javascript:footNote('E800005-002/note005.html')) *[which]* there grows in profusion more than two feet high. I also found a Plant by the water's edge not in flower & an **Orthotrichum**[6](javascript:footNote('E800005-002/note006.html')) with which I am not acquainted.


We dined capitally in an elegant Room & enjoyed a Bottle of good Claret for which we were charged 7/7. This plan of charging odd Pence & halfpence till reconciled by custom seems very odd to an Englishman. **Woods** was charged Seven Shillings & a halfpenny for a pair of Stockings which much surprized him till he recollected that it is the same as 6/6 English. After Dinner we walked along the Quay which is an English Mile in length & is by far the most {MS page 7} handsome part of the City. The **Suire** is a very fine River & I suppose that opposite **Waterford** it is as wide as the Thames at London Bridge.


We were much struck with the wide difference in the Looks of the Women in the upper & lower Ranks the former of whom frequently appeared as remarkable for Beauty, as the latter are universally for excessive ugliness.


Never before having seen or heard of any thing of the kind I was much diverted by an apparatus which I saw attached to all the Carts for the purpose of catching & preserving the Manure as it falls from the Horse that draws them. About 12 we went to Bed.


Sunday July 9th
  

Yesterday we hired a Chaise, pair of Horses & a Driver for our intended Journey of a Mrs. Murphy, who is the very ugliest of all the Women I ever saw, & the Group of which she formed part would have made a most ludicrous picture. We agreed besides every expense to pay a Guinea a day for the use of the Carriage & to give 3/9 1/2 to our Driver {MS page 8} whose


---

p.88



name is Pat. Pat, tho' not hideously ugly in the Face is tall, thin, raw boned & knock kneed & is totally unlike any Postillion I ever saw in England. We heard an excellent character of his capability to drive & of his civility & fidelity and when we had finished our Bargain an arch looking fellow covered with Dirt & Rags cocked his Chin in my Face & whispered ‘Your honour's in great luck for there isn't such another Driver as Pat in the Nation’. We agreed with Mrs. Murphy that if we didn't like either the Chaise or Horses we should be at liberty to send them back whenever we chose & the same Terence[7](javascript:footNote('E800005-002/note007.html')) as soon as he heard this immediately whispered me ‘I'm sure your Honour'll keep them all the way for the sake of keeping Pat. Och, there isn't such another Driver in the Kingdoms’.


At 1/2 past 4 in the morning I awoke & roused my Companions by reminding them that we were going to **Kill-mac-thomas**. This is the name of a Village at which we intended to Breakfast, but being very hungry we stopped short at a place called **Newtown Inn** where we found that the {MS page 9} only Parlor was occupied by a Gentleman who had before passed us in a Curricle.[8](javascript:footNote('E800005-002/note008.html')) The Landlord told us that he was Counsellor Hobson[9](javascript:footNote('E800005-002/note009.html')) & we found him a truly polite & remarkably pleasant Breakfast table Companion.


As soon as Breakfast was over we went to **Kill Mac Thomas** (2 Miles) where the lofty appearance of the **Monavullagh Mountains** on our right tempted us to ascend them altho', when we left **Waterford**, it was our intention to have gone as fast as possible to **Dungarvan**. We wished our Driver to take us to the foot of the Mountains which were four Miles distant, but he assured us that the Road was ‘not properly navigable for a Carriage’. Pat, however, politely added that we might try, if we chose & he only wished us ‘to see the sense of it’. We therefore set out on foot from **Kill Mac Thomas** & reached the base of the Mountain in about two hours. On our way we found **Pinguicula lusitanica**[10](javascript:footNote('E800005-002/note010.html')) in the Bogs & **Spergulas pentandra**[11](javascript:footNote('E800005-002/note011.html')) among the Corn in great plenty. When we had ascended about half a Mile we separated & each took a different direction, in order that thereby we might explore the Mountain {MS page 10} more thoroughly. **Woods** ascended a sort of Gulley in the expectation of finding a Pool beyond it, whilst I climbed up to a ridge of lofty & broken Craigs on the right. The side of the Mountain was very steep & being entirely covered with Heath made the walk very fatiguing. **Saxifraga umbrosa**[12](javascript:footNote('E800005-002/note012.html')) is extremely plentiful both in the highest Craigs and by the side of a Rill nearly to the foot of the Mountain.[13](javascript:footNote('E800005-002/note013.html'))


We left the foot of the {MS page 11} Mountain about 1/2 past 5 & at 7 reached **Kill Mac Thomas** where at a small Inn we ordered some Mutton Chops, but Pat begged us not to wait for them as it was getting late & the Country was ‘not quite as it ought to be’. We had been before informed that the Counties of **Waterford** & **Tipperary** had not, since the grand Rebellion, been so unsettled as at present,[14](javascript:footNote('E800005-002/note014.html')) & therefore thought it more prudent to content ourselves with some cold half famished Ducks & set off as fast as possible. We washed away our fatigue with a little Whiskey which we tasted for the first time since our arrival in Ireland & thought it excellent. It was after 10 when we reached **Dungarvan** where at the best Inn we ordered Supper. I was kept in a roar of laughter by an old drunken true Hibernian Chamber Maid who came into our Parlor & openly avowed that **Woods** had stole her tender Heart.


Monday July 10th
  

I rose this morning at 6 & employed myself till Breakfast in laying out my Plants See. {MS page 12} — Soon after 10 we took a Boat & crossed the River to an Island called **Conygare** on which **Gladiolus communis**[15](javascript:footNote('E800005-002/note015.html')) is in Gough's Camden[16](javascript:footNote('E800005-002/note016.html')) said to grow but tho' we hunted over every part of the Island we saw nothing like **Gladiolus** nor any other plant which can be considered as at all rare except **Juncus acutus**,[17](javascript:footNote('E800005-002/note017.html'))


---

p.89


**Viola lutea**[18](javascript:footNote('E800005-002/note018.html')) & one Specimen which **Woods** gathered of **Carex divisa**[19](javascript:footNote('E800005-002/note019.html')). **Mr. Leach** found a single Shell of **Venus Pophia**[20](javascript:footNote('E800005-002/note020.html')) & **Mactra lutraria**[21](javascript:footNote('E800005-002/note021.html')) was extremely abundant about high water mark.


**Dungarvan** is a small dirty Sea Port & contains very little to interest a Traveller. It is said in the Post Chaise Companion[22](javascript:footNote('E800005-002/note022.html')) that large quantities of Potato & Birch Brooms are here shipped for Dublin, & they form what is jocosely called a Cargo of Fruit & Timber.


Having taken an early Dinner we ordered our Carriage & at 1/2 past 2 set out for **Youghal**. We first ascended a high hill {MS page 13} which commands a very extensive Prospect but as in all the rest of the Country thro' which we have passed there is a sad deficiency of Woods in the Landscape. The Road was excessively rugged & the Country nearly all the way dreary & uninteresting. We stopped to bait[23](javascript:footNote('E800005-002/note023.html')) near the next village of **Clashmore** & reached the Ferry side opposite to **Youghal** about 7 in the Evening. Here we left our Carriage (which followed us soon after) & crossed the River **Blackwater** which is here about 1/2 a mile wide & divides the Counties of **Waterford** & **Cork** into the latter of which we now entered. We went to a very comfortable Inn called the **York Hotel** & employed ourselves till bed time in writing &c.


Tuesday July 11th
  

I rose about 7. {MS page 14} I was sadly disappointed to find that the Mail arrives every day in the week except Tuesday so that the Letter which I should otherwise have received will not reach this Place till tomorrow & must then be forwarded to me at **Cork**. At 10 we set out & walked for 21/2 hours along the Sea Shore where I gave most of my attention to Shells & collected several of which **Mya truncata**[24](javascript:footNote('E800005-002/note024.html')) is the most rare. **Woods** by the side of a Road which leads to the Sands about a Mile from the Town gathered **Erodeum moschatum**[25](javascript:footNote('E800005-002/note025.html')) & **Mr. Leach** made some discoveries in the **Molluscae**. He shewed me the most elegant **Actineai**[26](javascript:footNote('E800005-002/note026.html')) I ever saw & which he believes is nondescript but its long flower stalk was so securely seated in the Crevice of a Rock that we in vain endeavoured to procure it. On the shore we saw a number of what are called Bathing Boxes, which resemble Bathing Machines except that they have no Wheels & are carried into the Sea by two Poles in the manner of a Sedan Chair.[27](javascript:footNote('E800005-002/note027.html'))


At **Youghal** the Potato is said to have been first introduced into {MS page 15} the British Dominions by **Sir Walter Raleigh** to whom the Town principally belonged. The Inhabitants when the Plant came to maturity imagined that the Apples were the part to be eaten & were of course much disgusted nor was it till they afterwards accidentally turned up the ground that they discovered their mistake.


**Youghal** is a neat & rather large Town pleasantly situated under a Hill close to the Mouth of the River **Blackwater**. The Town hall is a handsome Building & is surrounded by a public walk called the Mall which is built in the River Banks & well planted with Trees.


After an early Dinner we set out for **Cork** about 2 O'Clock. The road as far as **Killeagh** is uninteresting but about that Village the Country is better wooded & becomes more pleasant. We next passed thro' **Castle Martyr**. The Town is small but by far neater than any other thro' which we have yet passed for which it is probably indebted to the **Earl of **Shannon**** who has a fine Seat & extensive Park close adjoining it.[28](javascript:footNote('E800005-002/note028.html')) **Castle Martyr** is about 8 Irish Miles from **Youghal**.


As we drove {MS page 16} along Pat who had never before travelled this Road frequently called out to People whom we met, indiscriminately without any regard to their age, ‘Lad, is this the right Road to **Cork**?’ The answer generally was ‘Aye, right all the way’. Pat then rejoined ‘I see’, & drove on.


After travelling five more Miles we came to **Middleton** where we stopped to feed our Horses. When we had had some Tea **Leach** & **Woods** amused themselves at a Billiard Table



---

p.90



& I took a walk about the Town. I returned to a small House about the Door of which as we passed by we had observed a crowd of Women sitting on the Ground. I heard on enquiry that three Children were just dead of the Small Pox & the fourth & last of the young Family was dying. I was at first pleased with an idea that these poor Wretches were come to condole with the distressed Parents, but on closer inspection I found the utmost indifference painted in their Faces, & they were only waiting till Death had finished his work {MS page 17} to give a Howl. They were all muffled up in Cloaks with the Hoods pulled over their Faces as is customary on such occasions, & went into the House one by one in rotation.


The Protestant Church is kept by far neater than any I had seen in Ireland & is surrounded by stately Trees of which there is also a handsome Avenue from the Entrance of the yard to the Door. It adds much to the beauty of **Middleton** which consists principally of one very wide street & gives title to a Viscount who resides in the immediate neighbourhood.[29](javascript:footNote('E800005-002/note029.html')) Public Houses are by far more numerous in this Country than in England, & at **Middleton** as well as every other Town & Village thro' which we have passed ‘Licensed to sell Spirits & Porter’ is painted over about every third Door. Among the dead[30](javascript:footNote('E800005-002/note030.html')) Letters in the Post Office window I *observed* one with the following singularly vague direction ‘To the Widow Murphy, County of **Cork**, Ireland’. Except Yorkshire, this County is, I believe, the largest in the British Dominions, & is very populous, {MS page 18} We set out from hence a little before 7 & reached **Cork** 12 Irish Miles distant at 1/2 past 10 O'Clock. The road passes thro' the most beautiful country which we have yet seen in Ireland, & the latter part of the way by the Riverside is particularly handsome. The Grounds at **Dunkettle** & **Lota**[31](javascript:footNote('E800005-002/note031.html')) are charming, & command some delightful views. Near the latter place the Road winds close by the edge of a broad Creek between two fine hanging Woods. The entrance into **Cork** is over a handsome new Bridge[32](javascript:footNote('E800005-002/note032.html')) into a very wide street, both bearing the name of St. Patrick, & being well lighted they convey an idea of opulence well suited to such a large commercial City. We drove to **M'Dowells Hotel** which is the principal Inn & as soon as we had supped being well tired we went to Bed.


Wednesday July 12th
  
{MS page 19}
We did not rise till near 8 O'Clock. As soon as we had Breakfasted I went to the Post Office & there found Letters. That from Dr. Stokes[33](javascript:footNote('E800005-002/note033.html')) enclosed introductory Letters to Mr. Hinckes[34](javascript:footNote('E800005-002/note034.html')) & Miss Hutchins.[35](javascript:footNote('E800005-002/note035.html')) The former is lecturer & chief Manager to a Scientific Institution lately established here[36](javascript:footNote('E800005-002/note036.html')) & on him we immediately called but found to our no small disappointment that he was in Dublin & will not return till Monday. We rambled about the City till 12 & then went in our Chaise to the new **Botanic Garden** which is now nearly completed & is under the Direction of **Mr. Drummond**[37](javascript:footNote('E800005-002/note037.html')) to whom we introduced ourselves. The garden which is extensive & judiciously laid out belongs to the above mentioned Scientific Institution for the general purposes of which about £2000 has been subscribed, & a grant to the Society of £2000 a year. **Mr. Drummond** is a long headed {MS page 20} young Scotchman with a broader dialect than I ever before heard, & is an excellent Botanist. Considering that he has been in Ireland but a year his Discoveries have been very numerous & bear ample testimony to his zeal & perseverance. In the Garden he shewed us a Plant which one of the Laborers in the Garden brought him from the neighboring Fields, but which he has since sought for in vain.[38](javascript:footNote('E800005-002/note038.html')) We all united in opinion that it is quite new to the British Flora. He took us to a place called **Black Rock** on the River's side about a Mile from the City.[39](javascript:footNote('E800005-002/note039.html')) {MS page 21} **Mr. Drummond** dined with us at our Hotel, & after Dinner we accompanied him to see the Library & Collections of the Institution which as well as the Gardens are yet in their Infancy. The Society's



---

p.91



house[40](javascript:footNote('E800005-002/note040.html')) adjoins that of **Mr. Hinckes** & we accepted a polite invitation from Mrs. Hinckes[41](javascript:footNote('E800005-002/note041.html')) to drink Tea with her. We afterwards walked with **Mr. Drummond** & young Mr. Hinckes to a place just without the City called **Sundays Well**. We returned home by the Dyke[42](javascript:footNote('E800005-002/note042.html')) which is the finest public walk I ever saw being quite strait, one Mile in length & thickly planted with large Trees on both sides.


**Mr. Leach** this afternoon took a Cork Bank Note for £1-14-1 1/2 which {MS page 22} seems a very strange sum till we recollected that it is equivalent to a Guinea & a half English. These Notes are in common circulation as are also others for three shillings and nine pence halfpenny. We reached our Inn about 1/2 past 10 & in an hour after went to bed.


Thursday July 13th
  

**Mr. Woods** went to Breakfast with some of his Relations & whilst I busied myself with writing **Leach** walked to **Black Rock** where with the assistance of a Ladder he gathered a few Specimens of **Dianthus plumarius**. This being the anniversary of my Wedding I could not help much regretting my absence from the best of Wives, for whom I walked into the City & purchased a trifle as a memorandum of my affectionate remembrance. At 12 I ordered the carriage & went with **Mr. Leach** to the Botanic Garden from whence **Mr. Drummond** accompanied us to some neighbouring Fields where we again sought in vain for the supposed new **Crepis**.[43](javascript:footNote('E800005-002/note043.html')) As some compensation for our trouble we however found **Pimpinella magna**[44](javascript:footNote('E800005-002/note044.html')) growing in great abundance. From here {MS page 23} **Leach** & I drove to **Black Rock Castle**[45](javascript:footNote('E800005-002/note045.html')) which is delightfully situated on a rock that projects into the River **Lea** about 2 Miles below **Cork**. The Banks of the River on both sides are nearly covered with Woods & handsome Villas, & the Scenery which is equally beautiful reminded me of the Thames at Lambeth. A little below the Castle the River widens into a noble Sheet of Water which is called the Lough & is 3 Miles long & 2 wide. **Mr. Drummond** had been informed that **Dianthus plumarius** grows about the Castle but we could not find it. It however certainly grows on the Rocks In the Diamond Quarry, so called from some Chrystals that are found there, on account of which this part of the Rocks is now walled in & no Persons are admitted.


On my return to the City I called on **James Abel**[46](javascript:footNote('E800005-002/note046.html')) at whose House my Father was entertained when he landed here from America. He received me so kindly & so pressingly urged me to dine with him next day, that I regretted it was out of my power to accept his invitation. About 4 **Cooper Penrose**[47](javascript:footNote('E800005-002/note047.html')) called on us & insisted on our accompanying **Mr. Woods** to dine with him at his Villa which {MS page 24} is beautifully situated on the North bank of the City *[sic]* about 1 1/2 Miles from the City. He has a fine collection of Pictures for which he has been building a Gallery as also five other Rooms for Statuary, & they are all very tastily lighted by Cupolas from the Ceiling. We returned to our Inn about 11 O'Clock well pleased with the hospitality & polite attention of **Mr. Penrose** & his Son.


Friday July 14th
  

Cork is a large & handsome City & is said to contain about 80,000 Inhabitants.[48](javascript:footNote('E800005-002/note048.html')) A Street called the Parade, as also St. Patrick's Street, are very wide & handsome & the former is ornamented with an Equestrian Statue of King George 2nd.[49](javascript:footNote('E800005-002/note049.html'))


About 10 we ordered our Bill & found the charges so exorbitant that even any English Tavern Keeper would have blushed to have made them. **Mr. Leach** & I slept in the same Room in two beds scarcely larger than Coffins, for which we were each charged 2s. 8 1/2d. per night. We were charged 4s. 4d. a day for our tiny sitting room, & so enormously high for {MS page 25} all we ate & drank that I shall certainly warn all my Friends who dislike imposition against ever going to Mac Dowels Hotel at **Cork**.




---

p.92


It was not 11 O'Clock when we set out but tho' the distance is only 13 1/2 Irish Miles or about 17 English Miles we did not reach **Bandon** till 4 in the afternoon. Pat, let the Road be ever so good, always drove very slowly but it was here very rough & hilly which annoyed him greatly & he called one part of it ‘The Devil's own half acre’. The country thro' which we passed is uninteresting except about **Innishannon** which is a pretty & neat tho' very small Town. By the Road side about two Miles from **Cork** we gathered **Hypericum calycinum**[50](javascript:footNote('E800005-002/note050.html')) in the spot described to us by Mr. Drummond but I confess myself extremely doubtful whether it has any claim to a place in the British Flora. By the road side we also gathered **Euphorbia hyberna**[51](javascript:footNote('E800005-002/note051.html')) which is extremely common in this Country, but has long since been out of flower.


{MS page 26}I had often heard of the wretchedness of an Irish Cabin but had no idea that any of them were so wretched as are most of those which we passed this day. They are built with Mud roofed turf, & have rarely any window whatever; some of them are without any Chimney & in others the Smoke is let out by a hole cut in the roof. The insides were generally filled with Smoke of which we frequently observed more issuing from the Door than from the Chimney. We were told that these poor Wretches prefer a Room when thus filled, & think it warmer & more comfortable. I never in my life saw so many Blind People as since I came into this country, which may perhaps be attributed to this singular prediliction & in almost all the old people I observed. ‘The Eyes with scalding Reum were galled & red.’[52](javascript:footNote('E800005-002/note052.html')).


While our Dinner was preparing at **Bandon** we walked about the Town which is rather large & very populous. We left it soon after six but tho' the distance is only 9 Irish Miles it was near 10 before we arrived at **Cloghnikilty** where at a small Inn called the Saint {MS page 27} George revived we stowed ourselves for the Night.


Saturday July 15th
  

We rose & breakfasted about 6 & soon after set out to examine the Shores of **Cloghnikilty Bay**. In the Meadows close to the Town & also in several other places we gathered **Bartsia viscosa**,[53](javascript:footNote('E800005-002/note053.html')) which there grows very luxuriantly & we saw **Rubia peregrina**[54](javascript:footNote('E800005-002/note054.html')) in equal abundance. About 9 we left **Woods** on the Banks of the Haven & **Leach** & I continued our walk till we reached the open Bay. From hence we rambled round what is called the Island[55](javascript:footNote('E800005-002/note055.html')) in search after Shells & Insects, & we were more successful than in any of our former Hunts in this Country. **Scarabaeus humens** & **S. Globosus**[56](javascript:footNote('E800005-002/note056.html')) were plentiful on the Sand hills by the Seaside, on which **Viola lutea** grows in great abundance & **Asplenium marinum**[57](javascript:footNote('E800005-002/note057.html')) grows in the Rocks. It seems to be a very good Beach for Shells & I found some with which **Mr. Leach** as well as myself were unacquainted. From **Cloghnikilty Bay** an Arm of the Sea runs up to the Town, but its Banks are tame & the neighbourhood totally devoid of Beauty. The Town {MS page 28} contains very few decent Houses but it is large & very populous as are all the others thro' which we have passed in this Country.


We returned to our Inn about 1 O'Clock at which hour we had ordered Dinner & about 2 set out for **Dunmanway** (11 Miles distant) which Town we reached at 7 O'Clock. The Road was so rocky as in some places to be almost impassable & the Country quite uninteresting. By the Road side all the way we again observed **Bartsia viscosa** & **Euphorbia hyberna** in great abundance. As soon as we had drank some Coffee (which was the namesake of our Landlord) we walked to a range of high rocky hills about a Mile Northward from the Town. On a Bog at the foot of the Hill we gathered **Carex curta**[58](javascript:footNote('E800005-002/note058.html')) & even the Stone Walls by the road side were almost covered with **Saxifraga umbrosa**. We ascended about half up the Hill & remained there till it was too dark to botanize any longer without finding any other Plant which can be {MS page 29} considered as at all



---

p.93



rare *[other]* than **Bryum alpinum**.[59](javascript:footNote('E800005-002/note059.html'))


The wildness of the Scenery & the stillness of the evening interrupted only by the chattering of a Fern Owl tended to tranquillise & dispose the Mind to Meditation. It was near 10 when we reached our Inn, where after having completed our Journals, & drank a bottle of thin Claret, we went to Bed.


Sunday July 16th
  

It is commonly supposed that there are no Bugs in this Kingdom, & that they were all turned out by St. Patrick. If, however, they ever were banished they have returned with a vengeance for in my Life I never was so plagued by them as I have been at **Cork**, at **Cloghnikilty** & at this place. I was also teazed by a large number of the Insects usually called Death watches {MS page 30} & which arranged about my bed beat their monotonous noise all night. In the morning I found them on the walls of my Chamber by Dozens & ascertained that they belong to the Genus **Dermestes** but neither **Mr. Leach** or myself knew the Species.[60](javascript:footNote('E800005-002/note060.html'))


After Breakfast our Landlord was our guide to see a Spa & a Lake which he told us are always visited by Travellers.[61](javascript:footNote('E800005-002/note061.html')) They are both within 1/2 a Mile from the Inn. The former is a small Stream of strong chalybeate water which issues from a Rock, but neither that nor the Lake are worth going an inch to see. If Service had been performed at an early hour in any place of worship that appeared at all decent, it was my intention to have attended but *[I]* found it impracticable without detaining my Companions longer at **Dunmanway** than they would have liked. It is a better tho' not so large a Town as **Cloghnikilty**. At 10 we set out for **Bantry** which by the new Road is about 12 Irish Miles distant; & for the sake of botanizing we {MS page 31} walked a great part of the way. In a deep Valley we passed the Ruins of a large Castle[62](javascript:footNote('E800005-002/note062.html')) & as we approached **Bantry** the Country became more & more mountainous & the Scenery more bold & interesting. From the Summit of a high Hill we enjoyed a grand & impressive view of **Bantry Bay** which is surrounded by wild Mountains many of whose frowning Summits were buried in the Clouds.[63](javascript:footNote('E800005-002/note063.html')).{MS page 32} Several different species of **Tabani**[64](javascript:footNote('E800005-002/note064.html')) flew about in such immense numbers over the Bogs that tho' we killed them by Scores it was impossible to prevent them from settling on & stinging our hands & Faces. We reached **Bantry** about 1/2 past 3 & I went immediately to the Post Office *[at]* which I was much gratified by receiving a letter from my dear Mary.


Soon after our arrival, in the neighbourhood of the Inn to my no small surprize

> 1. a Yell began,
>   
> Redoubled then from House to House it ran.[65](javascript:footNote('E800005-002/note065.html'))
> 




As soon as I reached the Door I found that a Funeral had just entered the Town & that the Noise I heard was an Irish howl. The Body had been brought from the Country & was followed by a Throng of People who made a low doleful noise which tho' intended to mimic Grief most resembled that of a pack of Hounds in full cry. A Bystander who seemed to be a Shopkeeper of the Town told me that the greater part of the Howlers did not even know the name of the Deceased & that ‘the Devil of a wet Eye was there amongst them’. All the lower orders whenever a Funeral passes their Door accompany it for a short distance {MS page 33} & make a Howl — if they did not they think others would not howl when they die & the idea of the horrid Yell that will be made when they are no more sweetens even their Beds of Death. Tho' it was nearly drowned by the Howl yet I heard something like chaunting & was told it proceeded from a woman hired for the purpose who was rehearsing in rhyme the virtues & hospitality of the Deceased.[66](javascript:footNote('E800005-002/note066.html'))


I had an introductory Letter to **Miss Hutchins**[67](javascript:footNote('E800005-002/note067.html')) who is well known by her numerous Discoveries in Natural History, & which I immediately sent by a Messenger to **Ballylickey** about 3 Miles distant. By the return of the



---

p.94



Messenger we received a polite & pressing invitation from her Mother, Brother & Self to spend tomorrow with them. After Dinner we strolled along the Banks of the Bay where in half an hour I left my companions & returned to our Inn having several Plants to lay out as well as a good deal of letter writing & journalising to do which employed me till 1/2 past 11 when I went to Bed.


Monday July 17th
  
{MS page 34}
A younger Brother of Mr. Hutchins's who is now on a visit to his Friends from College[68](javascript:footNote('E800005-002/note068.html')) called on us just as we were getting into our Carriage & conducted us to Breakfast at **Ballylickey**. The House surrounded by a Plantation of Trees is delightfully situated at the head of a small Cove about three Miles North of **Bantry** & commands a beautiful prospect of the Bay & its surrounding Mountains. I busied myself till Noon in looking over a part of **Miss Hutchins**'s extensive & well arranged collection of Algae & we then, accompanied by her younger Brother, embarked on board the Family pleasure Boat for a Sail on the Bay. We landed on rather a large Island called **Whittie** *[Whiddy]* the Shores of which are very Steep & Rocky & I there gathered several Marine Algae which I never saw growing before.[69](javascript:footNote('E800005-002/note069.html')) {MS page 35} Since the French appeared on this Coast the summit of the Island has been strongly fortified as have also many others of the numerous Islands in this heavenly Bay. When we reembarked about three in the afternoon there was a fresh but not favourable Breeze & the different Tacks which we were consequently obliged to make afforded us a delightful variety of views. We returned to **Ballylickey** & after Dinner employed ourselves till 10 O'Clock in examining different Parts of **Miss Hutchins**'s extensive Collections.


The master of the Family at **Ballylickey** is **Mr. Thomas Hutchins** who about 10 years ago lost the use of his Limbs so that he is obliged to be carried from one Room to another, & with him an aged Mother & his Sister reside. The liberality, politeness & hospitality of all these we have great {MS page 36} cause to remember & **Miss Hutchins** amazed me by the extent & depth of her botanical knowledge. She naturally possesses very strong senses & pleasing unaffected manners, & having expected to see something of the Lady Wilson kind,[70](javascript:footNote('E800005-002/note070.html')) I was surprised to find her aged not more than 30,[71](javascript:footNote('E800005-002/note071.html')) & her Person far from ordinary. It was past 11 O'Clock when we got back to our Inn where I was again gratified by receiving another Letter informing me of the welfare of my Family.


(The Kerry portion of Dillwyn's diary which follows at this point is here omitted. *It is available online at CELT in file E800005-001.* The diary resumes as he is leaving Killarney en route to Millstreet.)


Thursday July 27th
  
{MS page 81}
We rose & were ready to start at 6 O'Clock this morning but it was 7 before our Luggage was properly stowed in the car which we had hired for the purpose of conveying it. We then bid good by to **Mr. Woods**[72](javascript:footNote('E800005-002/note072.html')) & our Landlord whose House we all agreed to recommend whenever an opportunity offers. After a sultry & fatiguing walk[73](javascript:footNote('E800005-002/note073.html')) of 6 Irish Miles we reached a wretched Hovel called an Inn which is the only House of Entertainment between **Killarney** & 
**Mill Street**. We expected as it is a regularly licensed Inn that we should have found things tolerably comfortable, but there are only two Rooms one of which is used to cook Victuals, feed Pigs &c. & the other is a Bed Room. We were shown into the latter & there made a Breakfast on new Potatoes, Eggs & Milk which with Water from a neighbouring River are the only Eatables or Drinkables of any kind that the House affords. After **Leach** had bathed & I rested myself nearly an hour we again set out & reached **Mill Street** about 1/2 past 3, but tho' {MS page 82} the distance from **Killarney** is only 15 Irish or about 20 English Miles yet the Weather was so sultry & the Road so excessively dusty that we found ourselves greatly fatigued. The



---

p.95



Road is new & so remarkably straight that it appeared in a Line before us all the way.[74](javascript:footNote('E800005-002/note074.html')) but the most remarkable thing is that all the Bridges are whimsically built as crooked as possible.


The Country through which we passed except in the immediate neighbourhood of **Killarney** is very uninteresting & not a Tree was to be seen altho' it is said that the whole Country was so thickly wooded a Century ago that a Squirrel might pass from **Killarney** to **Cork** by leaping from Bough to Bough.[75](javascript:footNote('E800005-002/note075.html')) I saw no rare Plants except **Bartsia viscosa** & **Euphorbia hyberna** which grow almost everywhere in the Counties of **Cork** & Kerry, & **Utricularia minor**[76](javascript:footNote('E800005-002/note076.html')) which we found in a Bog by the Road side about 2 Miles from **Killarney**.


**Mill Street** is a small Town or rather Village which has nothing to boast of except the best Inn that we have met with in any of the small Irish Towns, & we were told that 50 years ago it was reckoned the best {MS page 83} in the whole Kingdom.[77](javascript:footNote('E800005-002/note077.html')) Here as in every other Town & Village there is a Barrack for two or three Companies of Infantry it having been found that no Law can be at all enforced in Ireland without the assistance of a Bayonet. We were a good deal diverted with the pranks of a recruiting Party, one of whom dressed as a Zany[78](javascript:footNote('E800005-002/note078.html')) chased the Crowd about with a small Cushion which was suspended by a long String from the end of a Stick, & the remainder of the Party were fitted out to Burlesque a Military Band. The Cymbal Man with a pair of Pewter Plates, & the time Drummer with an old Tin Kettle had their faces sooted & were ornamented to imitate the Duke of Yorks Blacks, & the appearance of the rest of the Band was equally ridiculous & absurd. They afterwards made a Dance in the Street but our Boots told me that they got no recruits & added ‘We a'nt gulled so aisy’. In the Evening we dispatched a Messenger to **Mallow** with orders to bring a Chaise tomorrow, & being a good deal fatigued retired to Bed soon after 8.


Friday July 28th
  
{MS page 84}
Such a Flight of Hawks & Pidgeons in the shape of Counsel & their Clients arrived at the Inn on their way from Tralee Assizes that we were obliged to admit three of the former into our Sitting Room, & as the morning was too wet for walking they served to make it pass very pleasantly. The Servant Maid whose arrival at **Killarney** under a Military Escort I have before mentioned also arrived here on her return protected by a Kings Messenger & a party of the 1st. Dragoon Guards.[79](javascript:footNote('E800005-002/note079.html')) She is a pretty young Girl & seemed delighted with the idea that the Murderer on her Evidence would suffer for his crime next morning. He is to be hung with Murphy the murderer of Mr. Tisdall[80](javascript:footNote('E800005-002/note080.html')) who whilst on his Trial struck one of the Evidences from the Dock & appeared so hardened after having received Sentence as to have shocked the whole Court. His Body is to be given for Dissection to the County Hospital which in this Country is dreaded more than hanging & even this Monster has petitioned to be allowed Christian Burial!


The Chaise for which we had sent to **Mallow** arrived soon after 12 & enabled us to proceed on our Journey at 2 O'Clock. The Country thro' which we passed till we {MS page 85} arrived within 4 Miles of **Mallow** is very tame but it then becomes woody & is far more beautiful. The Ruins of a large Castle called **Drumaneene** which is said once to have been very strong forms a handsome object from the Road.[81](javascript:footNote('E800005-002/note081.html')) It was about 1/2 past 6 when we reached **Mallow** & therefore so late when we had finished Dinner that as my Cold was still a good deal troublesome I did not think it prudent to venture out.[82](javascript:footNote('E800005-002/note082.html')) It seems to be a rather large & good Town, but the King*[s]* Arms at which we quartered & which is the first Inn, is not half so clean or comfortable as that at **Mill Street**.


Saturday July 29th
  

**Mallow** is noted for its hot & cold Spa & Mineral Springs & may be considered as the **Cheltenham** of Ireland.[83](javascript:footNote('E800005-002/note083.html')) The People at our Inn told us that the town is full of Visitors & of 



---

p.96



this there is every appearance for in a rather long walk which we took before Breakfast we found the Roads in the neighbourhood thronged with Chaises, Jaunting Cars & Equestrians. We stopt & drank a Glass or two both of the mineral water & of the Spa the former of which **Mr. Leach** thinks is impregnated with Sulphate & the latter with {MS page 86} carbonate of Iron. After Breakfast we rambled in & about the Town for two hours & visited the Ruins of its Castle[84](javascript:footNote('E800005-002/note084.html')) which are very handsome & beautifully situated at the Entrance to the Grounds of **Denham Jephson**,[85](javascript:footNote('E800005-002/note085.html')) Esq. We walked into the Park which is small but pretty & close to the old Castle. I saw a House which from its shabby appearance I mistook for that of his Steward[86](javascript:footNote('E800005-002/note086.html')) but on enquiry found that it is the Mansion of Mr. Jephson himself who appears to be as unpopular as is possible in this his native Country. If report says true he is a sort of Tom Morgan[87](javascript:footNote('E800005-002/note087.html')) who delights to dine with others but very rarely gives a Dinner himself, & I wonder how he got into Parliament for he seems too stingy to purchase & too disliked to obtain a Seat in any other manner. In the neighbourhood of **Mallow** I found no rare Plant besides **Sedum rupestre**[88](javascript:footNote('E800005-002/note088.html')) which grows plentifully about the old Castle.


At 12 we set out for **Mitchelstown** in a Chaise which of all that I had ever seen was the very worst — the Panels were broken — the Lining was {MS page 87} torn to pieces & covered with filth & there were but three instead of four Glasses to the Windows, & only one Door would open. When we had gone a short distance I complained to our Driver & told him that his whole Apparatus would scarcely sell in London for three half pence. An Irishman, especially when he expects to get something by you will never contradict anything, & he therefore said it was likely enough but added ‘and yet wasn't the Carriage all the morning at the Coachmakers to make it aisie for your Honour’. It is true enough that when we complained at **Mallow** of the Chaise not being ready we were told it was repairing but what on Earth the Coachmaker could possibly have done to it I am at a Loss to imagine.


Immediately on leaving **Mallow** the **Gualtee Mountains** *[Galtee Mountains]*[89](javascript:footNote('E800005-002/note089.html')) appear in the Distance, but the Country thro' which we passed was not at all particularly interesting. When we had travelled about eight or nine Miles we passed thro' a small Town or Village called **Kildorery** where we were grieved to see the still smoking Ruins of a long Row of {MS page 88} Houses which had been burnt the preceding Night. The entrance into **Mitchelstown** thro' the extensive & well wooded Demesne of Lady Kingston[90](javascript:footNote('E800005-002/note090.html')) is very handsome, & the Mansion[91](javascript:footNote('E800005-002/note091.html')) which stands on a declivity with the River below commands a fine view of the surrounding Park & of the **Gualtee Mountains**. Whilst our Dinner was preparing we strolled about the Town, which consists principally of one wide Street lined with tolerably good Houses, but I was most pleased with the appearance of a row of rather handsome Tenements at the edge of the Park in the centre of which is a Chapel. They were built by the first Earl of Kingston for the support of 12 decayed gentlemen & as many decayed Ladies each of whom received £ 40 per Annum & a Chaplain also receives a hundred a year for the performance of daily service in the Chapel.[92](javascript:footNote('E800005-002/note092.html')) I thought I never saw a place that appeared more comfortable, or so far as I could judge a set of Inhabitants who appeared more content & happy.[93](javascript:footNote('E800005-002/note093.html')) Till we arrived here there has been no established charge for posting by the Mile but the Landlord makes {MS page 89} as good a Bargain as he can by the Job. From **Mill Street** to **Mallow** which is 17 Miles we were charged £ 1. 14.1/2 & £1.8.2 from thence to this place, of which the distance is 14 Miles. For this last Stage I gave the Driver 4 ten pennies which I was informed is 10 more than he usually receives & for which he thanked me most humbly & wished ‘long life to my Honor’, but added ‘indeed its less than I ever received



---

p.97



before’. I was angry & calling him a Rascal told him he wished to impose on me to which the fellow cooly answered ‘Heaven bless your Honor I'm perfectly satisfied but all you English Travellers are so liberal that I thought to be sure I should have got six shillings’. This is constantly the case with every Irishman & they at every turn try to cheat you but mostly in this civil way, & two Drivers following used almost exactly the same words.


It was our intention to have stopped & ascended the **Gualty Mountain** from this Town, but my Cold was so troublesome & we heard so much of Murders & robbery in the neighbourhood[94](javascript:footNote('E800005-002/note094.html')) that we determined on proceeding without delay to **Clogheen**. Our Chaise {MS page 90} from **Mitchelstown** was still worse than the last & I never before saw such a mass of rags & tatters in the shape of a Carriage. Neither of the Glasses had any String by which they could be pulled up, nor did they at all fit the Windows so that I feared they would fall out, & one of them had scarcely any Frame. Yet tho' there is no Post Horse Duty in Ireland we were charged for this miserable vehicle 16 pence a Mile, & if there had been three of us the charge would have been 19 1/2d.


We passed thro' a small Town called **Ballyporeen**, & saw many handsome Seats by the road side of which that of **Lord Lismore** has the most extensive Grounds.[95](javascript:footNote('E800005-002/note095.html')) When we left **Mitchelstown** the **Gualty Mountains** were near us on the left, & those of **Kilworth** soon appeared at a short distance on the Right, together forming a fine mountainous tract. We arrived at **Clogheen** at 1/2 past seven & were driven to a comfortable & commodious Inn. It is a small but tolerably neat Town, about which we walked till our Tea was ready, & afterwards when we had finished our Journals retired to Bed at 1/2 past 11.


Sunday July 30th
  
{MS page 91}
We were called at 1/2 past 3 & at four set off in a Chaise for **Clonmel**. The Country thro' which we passed was far more interesting than any we had seen since we left **Killarney**, & at the Bridge of **Ardvinnane** *[Ardfinnan]* we admired the Ruins of a Castle situated on the top of a Rock which seemed to be marble.[96](javascript:footNote('E800005-002/note096.html')) When we had gone about 8 Miles we drove by the side of Lord Donoughmore's Grounds[97](javascript:footNote('E800005-002/note097.html')) & from thence to **Clonmel** the Country is truly beautiful. It was scarcely 1/2 past 6 when we reached **Clonmel** where **Mr. Leach** meant to have taken a place in the **Dublin** Mail but he changed his Mind & determined on accompanying me to **Swansea**. We therefore secured places in the **Waterford** Mail which starts at 9 in the morning, & having Breakfasted we strolled about the Town which is I think the largest & the best of any we have seen since we left **Cork**. The Assizes for the County of **Tipperary** were to be held here next day & we saw the Sherriff set out in state to meet the Judges. The Javelin Men cut an odd figure being all wrapped up in large great coats tho' the weather was very hot & dressed in large Livery Cocked Hats turn'd to one side al la {MS page 92} militaire. In consequence of the disordered state of the Country we heard that the Jail is crowded with Felons belonging principally to two hostile Factions called **Caravets** & **Shanavelts** *[sic]* into which the Peasantry are unhappily split, & of these the former wear a large Neckcloth & the latter a ragged Waistcoat as their distinguishing Badges.[98](javascript:footNote('E800005-002/note098.html')) When an Irishman for his *recreation* attends a Fair he always carries a Cudgel with which to break as many heads as possible is his greatest delight; & it was in **Clonmel** Fair that this Feud which has now spread so wide is said to have originated. They frequently murder those who attempt to oppose them as well as one another, & almost every Night they break open some House in search of Arms but whether they collect them for the purpose of attacking each other, or to subvert the Government has not yet, I believe, been clearly ascertained.[99](javascript:footNote('E800005-002/note099.html'))


I saw almost everywhere so many articles of French Manufacture that I am inclined to fear there is too much communication between this



---

p.98



Country & France, & I particularly remarked that an Almanack printed at **Marseilles** for the present Year was nothing at all extraordinary. It appeared to me from their looks that many of the miserable Wretches who we saw prostrate in **Killarney Cathedral**[100](javascript:footNote('E800005-002/note100.html')) at the same {MS page 93} time that they were receiving remission of Sins for the past week were planning others for the next, & that many of them would with less hesitation rob or even commit Murder than omit one superstitious Rite at Mass. Of this I had here some proof, for having given the Clogheen Driver a Guinea from which he was to bring me some change, the Rascal set off & kept out of the way till the Mail, in which he knew I had taken my place, was gone. I sent after him, & he was discovered busy with his Beads at Mass, but tho' the Messenger told him I was just going, he refused to move from his Devotions or restore his Plunder. To their Religion in my opinion at least half the Robberies in Ireland may be attributed for the Rogues with a small part of their Plunder purchase absolution & then keep the remainder without any fear of endangering their Souls hereafter.


The Mail Coach in which we set off for **Waterford** had two Guards & the Coachman told us that he has still three Slugs in his Body which he received from the Blunderbuss of a Robber. **Mr. Leach** preferred riding in the Box & I was stowed in the Inside with the following fellow Passengers — 1st. a Mr. Wilder[101](javascript:footNote('E800005-002/note101.html')) the son of a Revd. Doctor who was travelling for his pleasure & I found {MS page 94} him an extremely pleasant Companion. The second was an American who had served in the English Army in Ireland, but has now settled in Limerick County, & he proved to be well informed & very good humoured. The third was a holy Father with a bloated countenance & scarlet Gills, but who both in loyalty & liberality seemed rather above the common run of his Tribe. Recently committed Atrocities form a general subject for conversation in these parts, & I heard of so many Murders that I began to believe what a Gentleman told me at **Cork** was literally true. On looking over an Irish Paper I had happened to remark what a great number of Atrocities it recorded when he told me that even Murder is so frequent that it is rarely noticed unless the sufferer was a Gentleman, or the perpetration attended with some interesting particulars.


The Road from **Clonmel** to **Carrick** passes thro' a mountainous, well wooded & delightfully diversified country, which is ornamented with numerous handsome Villas. I think it well worth a Traveller's while to go several Miles round rather than miss seeing the beautiful Scenery which this Road every where commands. We stopped to change Horses at **Carrick** which is a large and {MS page 95} straggling but tolerably good Town. It contains an immensely large square plot of bare earth regularly surrounded on all sides with the most wretched Hovels as if intended to burlesque this fashionable mode of erecting Houses. There is also the remains of an old Castle which formerly belonged to the Duke of Ormond, & is now occupied by one of the Family named Butler.[102](javascript:footNote('E800005-002/note102.html'))


The Country between **Carrick** & **Waterford** is very beautiful, & the Road commands some fine Views of the River **Suire** but I do not think these at all equal to those of the last Stage. We passed by the House & fine Park of **Lord Besborough**[103](javascript:footNote('E800005-002/note103.html')) & on the opposite side of the River we saw part of the magnificent Demesnes of **Curraghmore** the Seat of the Marquis of Waterford.[104](javascript:footNote('E800005-002/note104.html'))


We reached **Waterford** at a little after three & the Priest pointed out to us the Ruins of 61 Hovels which formed a Street near the Hall where the Assizes are held. They had been burnt on Friday & the Fire obliged the Judges who were then trying some **Caravats** to quit the Court, but suspecting that it was purposely made to facilitate the Escape of the Prisoners they gave orders for securing them which proved effectual. We were told that



---

p.99



Seven were yesterday condemned & that 40 {MS page 96} more of the deluded Wretches remain in the Jail to be tried by a Special Commission![105](javascript:footNote('E800005-002/note105.html')) Mr. Wilder whom I have before mentioned being on his way to Wales requested to make Party with us, & we together enjoyed an excellent Dinner at the Commercial Hotel which is almost the best Inn I ever met with. One of the Mail Guards who I was fool enough to think honest because at **Clonmel** he had been active in endeavouring to recover my change from the Clogheen Driver here played me a nearly similar trick & set off with four tenpennies which I could not recover! Whilst we were at Dinner a Waterman came in & begged us to let him have the Honor of conveying us in his Boat to **Cheek Point** as he assured us that a Packet would positively sail at 7 O'Clock. We agreed to give him half a Guinea which was what he demanded, on his promising that neither he or his Men should ask for anything more, & then suffered ourselves to be hurried away & were rowed down the River, the Banks & windings of which are very beautiful. About 7 we reached **Cheek Point** & then to our great surprize found there was no Packet in the River! The Boatmen {MS page 97} pretended they had been deceived in **Waterford**, but the fact was that they wanted a Job & neither knew nor cared any thing about the Packet & the People at **Cheek Point** told us it is their common Trick. We hesitated whether we should pay them, & they certainly should not have had a stiver from me, but my Companions yielding to their importunity at length gave them the half guinea accompanied with a good deal of richly merited abuse. The more however that we abused them the more civil the Rascals were, & as soon as they had got the half guinea they exerted all their rhetorick to induce us to give them still more — ‘Just a drop o' something to drink your Honors health’ — till finding us inexorable they suddenly took to their Boat & rowed off. It was no pleasant thing to spend the Night at the vile dirty Inn at **Cheek Point**, but as it began to rain hard we thought it preferable to returning to **Waterford** & therefore making the best of our bad Bargain we ordered some Tea & retired early to Bed.


Monday July 31st 
  

I rose about 5 O'Clock from a horribly hard Straw Mattress, all the better Beds having been preengaged by other Company, & found {MS page 98} that two Packets had just arrived one of which would sail again as soon as the tide served. At 
1/2 past 9 the following passengers embarked on board the Berwick Packet, Capt. Steele — A Conought Lady with her Nursery Maid & 5 Children & her Brother who served as their Escort; a very pleasant rattling young Man of Fortune named Croker from **Mallow**[106](javascript:footNote('E800005-002/note106.html')) with his Servant; a younker on his way to Marlow College;[107](javascript:footNote('E800005-002/note107.html')) our party consisting of Mr. Wilder, **Mr. Leach** & myself. The Vessel immediately dropt down the River, & passed between the two small Towns of **Passage** in **Waterford County**, & **Ballyhack** in the County of **Wexford**, which are prettily situated on the opposite shores of the River. We soon afterwards passed **Duncannon Fort** which is a strong fortification built on a projecting Rock,[108](javascript:footNote('E800005-002/note108.html')) & on the other side of the River we saw **New Geneva Barracks**[109](javascript:footNote('E800005-002/note109.html')) forming an extensive Range of Buildings. Till we had passed the Fort the sailing had been delightful, but the Haven there becomes much wider & the Tide & Wind sitting in opposite directions occasioned a heavy Sea which made the Packet rowl & pitch so terribly that before we passed the Light House {MS page 99} at **Hook Point** every Passenger was Sea Sick except myself. I held out & kept on Decks till after five O'Clock, when the same befell me, & with an emptied Stomach I soon after went to Bed.


Tuesday August 1st 
  

After a comfortable night's sleep I woke about four & was rejoiced to hear from the Steward that we had arrived at the entrance of **Milford Haven**, & soon after 5 O'Clock we were safely landed at the Town. With some difficulty we 



---

p.100



got our Luggage cleared from the Custom House in time for the **Swansea** Mail, in which we set out at 1/2 past 7, & at 8 in the Evening my Journey ended.


### Acknowledgements


I wish to thank the Board of Trustees of Trinity College, Dublin, for permission to publish Dillwyn's manuscript; also Dr Bernard Meehan and the staff of the Manuscripts Department for assistance rendered. Miss Maura Scannell, Head of Herbarium, National Botanic gardens, generously elucidated the numerous botanical references. Dr Kevin Whelan of the National Library, Dr Jim O'Connor and Dr Mark Holmes of the Natural History Museum also helped. The editor, Mr Diarmuid O Murchadha, provided much useful information.














