

#Letter of Florence Mac Carthy to the Earl of Thomond, on the ancient history of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Letter of Florence Mac Carthy to the Earl of Thomond, on the ancient history of Ireland
=======================================================================================


Author: Florence MacCarthy Reagh
--------------------------------


### File Description

Electronic edition compiled by Beatrix Färber

Proof corrections by Beatrix Färber, Kilian Mallon, Janet Crawford, Olan Daly

Funded by School of History, University College, Cork 2. Second draft, with introduction.Extent of text: 18400 words#### Publication


CELT: Corpus of Electronic Texts: a project of the School of History, University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2012) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E600001-030Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Source**2. London, British Library, MS Add. 4793, fo. 18.
3. London, British Library, MS Add. 4821, imperfect transcript of same.
4. Lambeth, (transcript of 1.)
5. Dublin, Trinity College Library, (transcript of 1.)
**Literature**2. John Colgan (ed), Acta Sanctorum Hiberniae (Leuven 1645).
3. Roderic O'Flaherty, Ogygia seu, Rerum Hibernicarum chronologia: Ex pervetustis monumentis fideliter inter se collatis eruta, atque e sacris ac prophanis literis primarum orbis gentium tam genealogicis, quam chronologicis sufflaminata praesidiis. (...) (London 1685). (An English translation by the Reverend James Hely was published in Dublin 1793).
4. Charles Vallancey, Collectanea de rebus Hibernicis. (...) Published from the MSS, vol ii, Antiquities of Irishtown and Kilkenny (Dublin 1786).
5. William Haliday [=Holiday] (ed. & trans.), A complete history of Ireland: from the first colonization of the island by Parthalon to the Anglo-Norman invasion collected and arranged from the most ancient records of Ireland, and from authentic foreign writers, by the Rev. Jeoffrey Keating (Dublin: John Barlow, 1811).
6. Edward Ledwich, The antiquities of Ireland: with additions and corrections. To which is added a collection of miscellaneous antiquities. 2nd ed. (Dublin: J. Jones, 1804.)
7. P. Louis Lainé, Généalogie de la Maison de McCarthy: Anciennement Souveraine des deux Momonies ou de l'Irlande méridionale (...) publié dans le cinquième volume des Archives généalogiques et historiques de la Noblesse de France. (Paris 1839).
8. James Henthorn Todd, The Irish version of the Historia Britonum of Nennius (Dublin 1848).
9. Daniel McCarthy, The life and letters of Florence MacCarthy Reagh: tanist of Carbery, MacCarthy Mor, with some portion of 'The history of the ancient families of the south of Ireland,' compiled solely from unpublished documents in Her Majesty's State Paper Office (London and Dublin 1867).
10. Giraldus Cambrensis, Topographia Hibernica, 1188: J. F. Dimock (ed.), Topographia Hibernica et expugnatio Hibernica, Rolls Series 21. Vol. 5 of Giraldi Cambrensis Opera. London 1867.
11. James Henthorn Todd (ed. & trans.) Cogadh Gaedhel re Gallaibh: The war of the Gaedhil with the Gaill (London 1867).
12. Sir Bernard Burke, Vicissitudes of Families. 2 vols. (London, 1869).
13. Richard Bagwell, Ireland under the Tudors: with a succinct account of the earlier history (3 vols. London 1885–90, repr. 1963).
14. Samuel Trant MacCarthy, The MacCarthys of Munster. (Dundalk 1922).
15. R. B. Wernham, Before the Armada: the growth of English foreign policy, 1485–1588 (London 1966).
16. Alan Harrison, Ag Cruinniú Meala: Anthony Raymond (1625–1726), ministéir Protastúnach agus léann na Gaeilge i mBaile Átha Cliath, (Dublin: Clóchomhar Teoranta 1988). [Illustrates relationship between Dermod O'Connor and Anthony Raymond mentioned in John O'Donovan's footnote 55.]
17. Colm Lennon, Sixteenth Century Ireland: The Incomplete Conquest (Dublin 1995).
18. Nicholas P. Canny, Making Ireland British, 1580–1650 (Oxford 2001).
19. Kenneth W. Nicholls, Gaelic and gaelicised Ireland in the Middle Ages (Dublin 1972, new edition 2003).
20. Emilio Rodríguez Almeida, 'Ad Speculum Britanniae', in: 'Mar Exterior', Actas del Congreso Internacional "El Occidente atlántico en época romana", Pisa, Santa Croce in Fossabanda, 6–9 de noviembre de 2003, M.a Mercedes Urteaga Artigas and María José Noain Maura (eds.), Escuela Esp. de Historia y Arqueología en Roma-CSIC (Rome 2005) 13–19.
21. Fear Feasa ón Cháinti, 'Gluais a litir go Lunndain', for details please see CELT file G402238.
**The edition used in the digital edition**2. **John O'Donovan**, Letter of Florence Mac Carthy to the Earl of Thomond, on the ancient history of Ireland in Journal of the Kilkenny and South-East of Ireland Archaeological Society, n. s.. , Dublin, Royal Society of Antiquaries of Ireland (1856) volume 1page 203–229

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 203–229. The editor's footnotes are numbered in sequence and tagged *note type="auth" n=""*.


#### Editorial Declaration


##### Correction


Text has been proof-read three imes and parsed using SGMLS.


##### Normalization


The electronic text represents the edited text. Editorial notes are integrated and numbered. Name elements are capitalized according to CELT practice. In the body of the letter, the character & has been replaced by and. Text in languages other than the main text is marked. Variation in using the ordinals 2d/2nd and 3d/3rd has been normalized according to modern usage. Apart from that, the 17th-century English spelling of the edition has been unchanged.


##### Quotation


Direct speech is tagged q. Citations are tagged cit. This element contains bibl and qt elements.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the letter; div1=the paragraph. Paragraphs have been numbered in the electronic edition; page-breaks are marked pb n="". MS foliation of the original is not indicated in the printed edition.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


A selection of group-names, place-names and personal names are tagged. Book titles are tagged.


#### Canonical References


This text uses the DIV1 element to represent the paragraph. ### Profile Description


Created: by Florence MacCarthy Reagh (1560–1640)
 (1609) #### Use of language


##### Language: [EN] The text is in seventeenth-century English.


##### Language: [LA] Some words are in Latin.


##### Language: [GA] Some words are in Irish.


##### Language: [GR] Some words (in the editor's annotations) are in Greek.


### Revision History


* (2012-05-13) Beatrix Färber (ed.)

* Header modified, new wordcount made, new SGML and HTML files created.
* (2012-05-10) Beatrix Färber (ed.)

* Introduction proofed (2); more structural and content markup applied.
* (2012-05-04) Olan Daly, Ballincollig (ed.)

* Introduction captured, proofed (1); basic structural markup applied.
* (2012-03-19) Beatrix Färber (ed.)

* Corrections by Janet Crawford integrated.
* (2012-03-19) Janet Crawford (ed.)

* Online proofing of whole file (3).
* (2012-03-05) Beatrix Färber (ed.)

* SGML and HTML files created; online proofing.
* (2012-02-21) Beatrix Färber (ed.)

* File proofed (2); content encoding applied, footnotes numbered and integrated.
* (2012-02-19) Kilian Mallon (ed.)

* File proofed (1); more structural markup applied.
* (2011-11-14) Beatrix Färber (ed.)

* Header created.
* (Beatrix Färber)  (2011-11-08) (data capture)

* Text captured; basic structural markup applied.




---


#### Corpus of Electronic Texts Edition: E600001-030


### Letter of Florence Mac Carthy to the Earl of Thomond, on the ancient history of Ireland: Author: Florence MacCarthy Reagh




---

p.203


### Letter of Florence Mac Carthy to the Earl of Thomond, on the ancient history of Ireland

### Introduction


The following letter, on the ancient history of Ireland, which was written by the celebrated **Florence Mac Carthy** to the **Earl of **Thomond****, about the year 1609, the ninth year of his imprisonment, has been printed from the author's autograph. The original *copy* of it, though stated in an Irish memorandum to be in the writing of **Conor O'Kinga**, is certainly in **Florence**'s own fair handwriting, with only one or two erasures made by himself, and is preserved in the British Museum (Additional MSS. 4793, fol. 18). In the Index to the volume it is referred to as ‘The *copy* of a letter written by **Florence Mac Carthy**.’ But it is no copy (unless by *copy* is meant the original, which was the primary meaning of that word). Every word of it, except the Irish memorandum at the end, is in the handwriting of **Florence Mac Carthy**. In vol. 4821, Additional MSS., there is a transcript of this letter in a different hand, headed ‘A letter of Florence Mac Carthy written (I think) to the Earl of Thomond.’ This copy is not perfectly exact; yet it is valuable, because the original had been much folded, frayed, and mended, and thereby rendered occasion ally, but rarely, illegible. The transcript in the vol. 4821 was evidently made before this damage and restoration took place. There is another copy preserved in a volume at Lambeth, and a fourth in the MS. Library of Trinity College, Dublin; but these are of no value whatever, except as far as they enable us to read the words illegible in the original.


At the end of this letter is the following memorandum in Irish, in the handwriting of **Gillapatrick O'Kinga**, whose relative, **Conor son of Murtough O'Kinga**, had been commissioned by **Florence Mac Carthy** to carry it to the **Earl of **Thomond****, then in Ireland:—


*Tabhradh gach aon léighfios & éistfios no sgríbheochus an trachtadh so rannchuidiugha a nguidhi do'n tí do sgriobh an seanchus sin a dubhramur, & fos tuc leis é go h-Éirinn .i. **Conchubhar mac Muircheartaigh h-i Cionga**, & fós fa Dia do shaoradh **Fhinghin Mé Carrthaigh** ón m-braighdionas & ón ngéibhionn i na bhfuil sé a ttor Lundainn noch do chuir so amach ó thúr. Go ndiongnaidh Dia uile-chumhachtach Grása & trócaire ar a n-anmannaibh araon.
  

Misi **Giollapadruig mac Donnchadha** do ghraifne an becan sin, oidchi S. Frainsias, 1615.’’*




*Let every one who shall read, hear *[read]*, or transcribe this treatise



---

p.204




join to pray for the person who wrote the said history, and who moreover brought it with him to Erin, i. e. **Conor son of Murtough O'Kinga**; and moreover, that God may redeem **Finghin Mac Carthy** from the imprisonment and bondage in which he is *[detained]* in the Tower of London, who put this out first. May God Almighty have mercy on the souls of both.
  
 I am **, son of Donogh**, who wrote this little scrap on the eve of St. Francis's festival.’’*




From this it would appear that this letter was transcribed and carried to Ireland by **Conor O'Kinga**, who seems never to have delivered it to the **Earl of **Thomond****. How it found its way back again to England nothing remains to determine.


**Florence Mac Carthy**, the author of this historical letter to the **Earl of **Thomond****, was considered by the English officials of his day ‘the dangerousest man in all Ireland.’ He was the eldest son of **Sir Donogh Mac Carthy Reagh**, lord or chief of Carbery, who died in 1576. Our author was then fifteen years old, according to an inquisition taken shortly after his father's death, though he himself states in a letter, dated 1624, that he was then above seventy! In other words, the jurors swear that he was born in 1561, and he himself asserts, in his old age, that he was born before 1554. The jury was clearly right, and the memory of the old man, weakened by long imprisonment, wavered. If the inquisition be correct, he was but sixty-three when he asserted he was above seventy.


That our author had some chronicles relating to Ireland, and some MS. lives of Irish saints, we learn from **Carew**, who says, in speaking of the ancient dignity of the Carew family in Munster (Lambeth, 635, fol. 42), ‘the castles of Donnemark, in Bantry, and of Artulloghe, in Mac Finin's country, were builded by Carewe, in anno 1215. This is extracted out of an old chronicle, written in Irish, which **Florence Mac Carthy** hath.’ It was evidently a copy of the old Annals of Innisfallen. **Colgan** says that the most illustrious **Florentius Maccarthy**, of the city of London, had a volume of lives of Irish saints in his possession, from which he had extracts. Well might he have called him of the city of London, for he was never permitted to return to his native country.


The author of Carbriae Notitia, who wrote in 1686, in descanting on the pedigree of the Mac Carthys, says—


*It is likewise evident that Donell Earle of Clancare, dying without issue male, his daughter and heir was married to **Florence mac Donough Mac Carthy Reagh** (whose pedigree shall follow more at large), by virtue of which marriage **Florence** claimed the name and title of Mac Cartymore, which Donell, naturall son of the deceased Earle of Clancare had usurped, and by the help of Tyrone, who was then come into Munster, he was establisht in that name and dignity, and his grandson and heir, Charles, is at this day ownd and stiled Mac Cartymore.’’*

Carbriae Notitia






---

p.205


And again—


*But of all the Mac Cartyes none was ever more famous *then* the aforesaid **Florence mac Donogh**, who was a man of extraordinary stature [being like Saul higher by the head and shoulders than any of his followers] and as great policy *with competent courage,* and as much zeal as any body for what *he falsely imagined true Relligion* and the liberty of his country. He married the heiress of the Earle of Clancare, and, purely by his merrit, dispossessed her bastard brother Daniell, from the name and estate of Mac Cartymore, which he was then possessed of, and gott the same for himself in her right by the joynt suffrage of Tyrone and all the nobility and clergy, which is the more strange, for that in Ireland they allwayes regard the male so much above the female that they often prefer a bastard son before a legitimate daughter, which is upon these two reasons, first that the name and family is thereby preserved (as in the Roman adoptions), and, secondly, the country being most commonly in feuds and wars, it is necessary to have able men to protect every family, and that also is the true reason of the custom of Tanistry.
  
This **Florence** for marrying the Earle of Clancare's daughter without licence of the Queene, or for some other misdemeanours, or perhaps for reasons of state, was imprisoned for eleven years in England, and then being set at liberty, acted in Ireland as you may read at large in the Pacata Hibernia, and was at length again apprehended, and sent to the Tower, where he died.’’*




When we make due allowances for the circumstances of **Florence Mac Carthy** having been by birth a native Irishman; of there having been such a general deficiency of *style* in English prose at the time he wrote; and of the absence, at the same period, of a proper philosophy of history,— his letter, whatever may be its defects, will be sufficient to demonstrate the great injustice of the representations given, in certain quarters, of the old Irish. In 1798, when it was still sufficiently the fashion in those quarters only to countenance a belief of whatever was most uncivilized with respect to the native Irish, an accomplished Englishman, **Dr. Arthur Browne**, Fellow of Trinity College, Dublin, ventured, in his Miscellaneous Sketches, to hint that *some* idea of that people should be formed from their own writings, instead of merely judging of them by the interested productions of their enemies. ‘The Irish in the reign of Elizabeth,’ says he, ‘are represented as quite ignorant and barbarous. Read the letters of their chiefs to the Spaniards, in the Pacata Hibernia and judge.’


The following sketch of the life of **Florence Mac Carthy**, chiefly extracted from the State Papers, has been furnished me by Daniel Mac Carthy, Glas, Esq., who is engaged in writing a life of this remarkable Irish chieftain:—
  


> 
> I greatly rejoice to hear that the name of **Florence Mac Carthy** is going to be once again sounded in the ears of his countrymen. In his
> 
> 
> 
> ---
> 
> p.206
> 
> 
> 
> 
> generation that name was so familiar with the Governors of Ireland, the Prime Ministers, and Privy Council of England; it was so constantly on the lips of all politicians, so incessantly in their despatches, so perseveringly before the eyes of the world for fifty years, that it became a cabinet word, and its owner familiarly called Florence. I have been often surprised considering how large a portion of the State Papers of Elizabeth and James is occupied about **Florence Mac Carthy**, that so little is known concerning him. The writer of the Pacata Hibernia has indeed given us so much of his biography as he thought needful for the glory of **Carew**, but his notices range over no larger a space than sixteen months. The following very meagre sketch will, I trust, supply the information which you pay me the compliment to seek from me.
> 
> 
> **Finin, or Florence Mac Carthy**, was the eldest son of **Sir Donogh Mac Carthy Reagh**, lord, chief, or captain of Carbry, and **Jane, daughter to Morrice of **Desmond****, slain in his rebellion on the 11th of November, 1583. He was fifteen years of age in 1576, in which year his father, **Sir Donogh**, died, as appears from an inquisition held at Cork, on the 1st of June in that year, before **Sir William Drury** and others. In after life **Florence** appears not to have kept very accurate account of the years as they passed over him, for in several of his petitions he represents himself as older than he really was. **Sir Donogh** is styled ‘Miles’, and of **Kilbrittain**. This was the chief residence of Mac Carthy Reagh, and there, probably, was **Florence** born. Being a minor, he fell under the wardship of **Sir William Drury**; but this did not prevent him from assuming ‘the command of his own country and his own people.’ For this command he was pre-eminently qualified by nature and education, being, ‘like Saul, higher by the head and shoulders than any of his followers’ ( Pacat. Hib. p. 179), and being intimately acquainted with the Irish language, literature, and history. He did not, however, as you are aware, succeed to the chieftainship of Carbery; this descending, by usage of Tanistry, to Sir Donogh's next brother Sir Owen, **Florence** was passed over, as his cousin, Donell Pipy, had been, to await his turn of succession, which in due course would fall to him on the death of Sir Owen, his uncle, and Donell, the eldest son of Sir Cormac, the elder brother and predecessor of **Florence**'s father, **Sir Donogh**. You remember the terms in which the Annals of the Four Masters speak of **Sir Donogh**. He had been a firm adherent of the English authorities in Munster; had served with the Lord Deputy Sidney at the siege of Ballimarter, at Glanmoyr, and in all other places where he had occasion to use any forces for her Majesty, where he brought with him more men than any two in Munster, for which services he received her Majesty's own letters of thanks. **Sir Donogh** appears to have added materially to his own inheritance by purchases of lands around him, and to have died very wealthy. He is sworn to have been seised at his death of no less than 20 carucates of land in the county of Cork. To these his eldest son was declared heir; but, either by the generosity of **Florence**, or by well-understood unwritten custom, Donell Moyle, his younger brother, received a large portion of the lands of Carbry.
> 
> 
> Whatever education **Florence** received must have been acquired in early boyhood, or subsequently, after a lapse of seven years from the period of his father's death; for immediately on the demise of **Sir Donogh** he assumed
> 
> 
> 
> ---
> 
> p.207
> 
> 
> 
> the command of his Munster forces, ‘assisted in almost all the journies that were done in her Majesty's service, both under Sir William Pelham, the Lord Grey, the Earl of Ormonde, Mr. John Zouche, Sir George Bourchier, and all such as governed or commanded there,’ until the unfortunate Earl of Desmond perished miserably in the cabin of Glanneginty.
> 
> 
> From 1583 to 1588 **Florence** appears to have divided his time, at pleasure, between his possessions in Munster and the court of Queen Elizabeth, where he made powerful friends, and acquired a knowledge of court influences, which he knew well how to turn to account in his hour of need. Not the less, however, was a keen vigilance exercised upon his conduct during his visits to his native country; and it was soon remarked that ‘he had acquired the Spanish tongue, and greatly affected the company of Spaniards;’ that he had mortgaged portions of his patrimony to enable him to purchase the Old Head of Kinsale, a castle commanding that harbour, so suitable for the reception of an invading force of the foreign enemy.
> 
> 
> In 1588 **Florence** married the daughter and heiress of the Earl of Clancarthy, or Clancare, as it was then rather incorrectly written— a marriage most romantic in all its incidents, and the fruitful source of long and grievous sorrows. The **Lady Ellen Mac Carthy**, the last living descendant of the main line of Mac Carthy Mor, was, by her birth and inheritance, a match the most important then in the British empire. The keen eyes of Elizabeth, the far keener of the English authorities in Munster, were upon her. Sir Warham St. Leger suggested to the Vice-President, **Sir Thomas Norreys**, to offer his hand to the lady, and to apply to the Queen for a grant of succession to her father's country. **Sir Valentine Browne**, who had had various money transactions with the Earl of Clancarthy [Clancare], and who better knew his business, offered, in plain language, to buy the lady for his son, and to buy the consent of the chief officers of the Earl. His offer was accepted; and then arose a loud and angry outcry amongst all the subordinate chieftains of Munster. The Countess, her daughter, and a deputation from those who considered the honour of their blood imperilled, waited upon **Sir Thomas Norreys**, and gave him plainly to understand that a disparagement so odious would not be submitted to. In the meantime, ‘in an old, broken church, in the wilds of Killarney, with a Mass, without license of the bishop, and not in such solemnity and good sort as behoved, and as order of law and her Majesty's injunctions do require,’ the young heiress was married to her cousin **Florence**. Great was the consternation of the Vice-President, great the wrath of the Queen, greatest of all the contempt and ridicule that fell upon the Brownes, and their hatred thenceforth for **Florence**.
> 
> 
> Twelve years of banishment, a portion of them spent within the walls of the Tower of London, was **Florence**'s punishment for this defiance of authority. In 1598 he returned to Ireland. The Earl of Clancarthy [Clancare] was dead, and Donell, his bastard son, had proclaimed himself Mac Carthy Mor. Tirone was in rebellion; James Fitz Thomas, the sougane Earl of Desmond, had reduced the Queen's authority within very small limits in Munster; a Spanish invasion was expected, and it was thought that **Florence** was the only man who could avert some great national
> 
> 
> 
> ---
> 
> p.208
> 
> 
> 
> disaster. He received authority to demand arms from the Queen's stores to arm followers of his own, and bonaghts hired out of Connaught, to recover his own country.
> 
> 
> He did recover it, and from that moment he became ‘the most dangerousest man in all Ireland, no man so fit to be the head of a faction,’ the terror of the English cabinet. Every dispatch that was sent from Munster was occupied with his proceedings, his policy, his ambition, his cunning, his treachery.
> 
> 
> On the 24th of April, 1600, **Sir Carew** was sent to Cork as Lord President of Munster; and he at once decided that **Florence Mac Carthy** must be conciliated or crushed before he could venture to meddle with rebels actually in arms; and then there began between these two men an encounter of wits the most curious, the most ingenious, of which the annals of diplomacy have any record. It was an encounter with weapons of which **Florence** was a most perfect master. **Sir George Carew** entered upon it with great confidence, expressing the uttermost contempt for the intellect of his adversary; but **Sir Robert Cecyll** looked on with some misgiving from the beginning. The sougane Earl of Desmond spoiled the country within sight of the walls of Cork; **Tirone** and **O'Donnell** were mustering their forces to burst upon Munster; the Spaniards were expected daily; and English treasure, to the great grief of the Queen, was streaming from her exchequer into the insatiable gulf of the rebellious kingdom; and there was **Florence Mac Carthy**, with 3000 men of his own followers, occupying all the fastnesses of the land, yet serenely professing unimpeachable loyalty, profound respect for his good friend the Lord President, and regretting the necessity of his presence in the inaccessible wilds of Desmond to keep his people from rebellion; and there was the Lord President suffering discredit from the vicinity of the rebel Geraldines, yet not daring to go forth of the gates of Cork, lest the next move of **Florence** should extinguish the Queen's authority in Munster. Such was the contest of these two astute strategists, whilst time was passing, and rumours of coming Spaniards kept the English cabinet in constant alarm. **Carew** became bewildered; his dispatches to **Cecyll** daily contradicted each other; till, in despair, by an act of shameless treachery, he violated his own safe conduct, and made prisoner of the man whom he found it impossible to outwit.
> 
> 
> **Florence**'s political life was now ended; within a couple of months he crossed the Channel for the last time, and entered again within the gloomy portals of the Tower, and for thirty long years, till death released him, he ate the bitter bread of a state prisoner. It was to while away some of the hours of his wearisome captivity that the letter you are now editing was written, and I am rejoiced that you find its intrinsic merits worthy of the attention of the learned of our own day. I have never been able to consider it otherwise than as connected with his active life, and as a proof of his thorough appreciation of his country's claims to men's esteem, and of his own claims to the supreme rule of south Munster. No others of his writings of a literary nature remain; but a long series of letters, petitions, and remonstrances, extending over forty-two years, are still extant, every one written by his own hand, in characters small, regular, firm, and distinct as print; and we rise from the perusal of them no longer surprised that
> 
> 
> 
> ---
> 
> p.209
> 
> 
> 
> 
> through life he had been able to persuade men to doubt of facts as patent as human evidence could make them; that in the most critical moment of his career he could force even **Carew** to exclaim to **Cecyll**, ‘What to make of **Florence** I protest I know not! I am utterly perplexed!’ To know **Sir George Carew** is to know the depth of **Florence**'s ingenuity.
> 
> 
> At the time this letter was written, **Florence** had been nine years within the Tower! No petitions of his own, no solicitation of his friends at court, no change of ministers, or regard for the altered circumstances of Ireland, had availed to procure him the liberty to pass one day beyond the walls of that gloomy prison. If any man might be expected to feel some compassion for the sufferings of this state prisoner, it would be the **Earl of **Thomond****, for he had been an honourable and open enemy, and mainly instrumental in his overthrow. Of one single touch of pity no one who knew **Carew** could suppose him capable. Had he been the means of throwing open for **Florence** the gates of his prison, it would not have cancelled—nothing ever could—the treachery by which he had placed him there, but it would have evinced some feelings of humanity. Any such act was far remote from his thoughts. Six years afterwards, when there had been a moment of hope for the prisoner, and **Florence** was plaintively petitioning for some freedom, for that his health was perishing, **Carew** sternly refused to help him with a single word! Between **Florence** and the **Earl of **Thomond**** there existed at least the tie of country. To that feeling this letter was a direct appeal, and, to the honour of the **Earl of **Thomond****, it was successful. On the 9th of July, 1614, was registered this following document:—
> 
> 
> ‘Several bonds taken to his Majesty's use, of the parties underwritten, that **Florence Mac Carthy** shall not depart out of the realm of England, without licence from his Majesty, nor travel above one day's journey from the city of London, without licence under the hands of six of his Majesty's Privy Council:—’
> 1. **Florence Mac Carthy** . . . £2000
> 2. **Earl of **Thomond**** . . . £500
> 3. Earl of Clanricard . . . £500
> 4. Sir Patrick Barnewall £500
> 5. Lord Delvin . . . £500
> 6. Sir Randulph McDonnell £250
> 7. Sir Donell O'Brien . . . £250
> 8. Dermott Mac Carthy £250
> 9. David Condon . . . £250
> 10. . . . £5000
> 
> 
> 
> The **Earl of **Thomond**** not only bound himself in the sum opposite to his name above, but he entailed the same obligation upon his son, in case of his own death. The case occurred; but it was not without **Florence**'s return to his prison, and a great struggle, that the humane foresight of the Earl was allowed to avail him. Upon such limited liberty **Florence** was permitted to quit the Tower; and I rejoice that with this first printed copy of his letter shall be recorded the act of his benefactor.
> 
> 
> The letter throughout is distinct, without a blot, and exhibits only 
> 
> 
> 
> ---
> 
> p.210
> 
> 
> 
> two erasures. What minute characters the hand of such a giant could form, and with what certainty and precision it could trace, line after line, in faultless parallels, and with intervals so minute that there seems upon the page but a sharp, slender thread of white around each word, may be judged from the fact, that three pages and twenty-one lines of a sheet, foolscap size, sufficed to contain the whole of this long letter to the Earl of Thomond. The same distinct, regular handwriting, with great similarity to that of Florence, was inherited by the eldest of his surviving sons.
> 
> 
> The capture of **Florence** was the signal for all the harpies of Munster, in authority and out of it, to fall upon his property; but they had yet to learn the resources of this able man, who, from the close confinement of an English prison, could during thirty years carry on a fight, single-handed, with them all. One after another was compelled to give up portions of the plundered property; but the Brownes continued to the last to keep the tightest clutch upon their spoil: through three generations they had clung with determined tenacity to the seigniory of Malahuff *[Molahiff]*; but even over them he triumphed at last. In 1629, an order in Council compelled the grandson of **Sir Valentine Browne** ‘to deliver possession of the said lands to the said Florence, with due consideration of some recompense to be given for the mean profit for the time’ past.
> 
> 
> What was the precise period of **Florence**'s death I have not yet been able to discover. His last petition, though undated, was evidently written in 1631; and a petition of his son, dated in the same year, speaks of his father as still under restraint. He left behind him three sons, one (his eldest) having died in the Tower. History has spared us a short but dark chapter on the early career of the eldest of these surviving sons, who was probably a source of greater sorrows to **Florence** than aught else that clouded his long and unfortunate life.
> 
> 
> 






---

p.210


[1](javascript:footNote('E600001-030/note001.html'))
At your last being in England I understood of your being studious of the antiquities of our nation, wherein (altho' my memory is much decayed in almost 9 years extreme endurance) I would be glad to do any service to so ancient a nobleman of the nation.


And for the opinion that their original came from **Greece**, not only other writers doe so conclude but also themselves call the contrey from whence they came first Sceth iath[2](javascript:footNote('E600001-030/note002.html')) the country of the thorns, for iath is a country and sceth a thorn, which all our ancient writers and others interpret **Greece**, as in the beginning of the 1st book of the Machabees is set down that **Alexander the Great** came out of Terra Cethim[3](javascript:footNote('E600001-030/note003.html')) the country of the thorn, whereby there is no doubt but their original comes out of **Greece**: but what colony of 



---

p.211


**Greeks** they were, what time they came from thence, who was their conductor, where they remained until they came for Ireland, and upon what occasion they came thither, there stands the chiefe question, wherein all the Scottish writers that I have seen and the English in what they borrowed of them are (I think) erroneous: the cause (I believe) is that our nation in Scotland have been first vexed by **Pights**, **Britons** and others, and annoyed afterwards out of this land by the Romans that were very powerful, and much exercised against all warlike nations, neither have they been shortly after quiet with the **Saxons**, nor after them with the **Danes**, nor quiet always with the Kings of England, nor free from civil wars oftentimes; and being joined with **Pights** from the beginning, divers noble houses out of France, England, and other parts came thither since, whose fashion was so imbraced that many or most of the ancient nobility of the Scottish nation disdained and forgot their language and despised and neglected their monuments and antiquities, whereby it seems that some of them that write thereof know not well from whence came the original, nor who was the head and Ancestor of the nation, who in myne opinion is by them erroneously called Gathelus, as appeareth by the **Britons**, who is an ancienter and a nobler nation than what is said of Brutus would make them, for all our ancient books and writers doe conclude that these three kingdoms were first peopled by the colony that was brought out of **Greece** about 500 years after the universall Fludd by Nemeus or Nemhedh mac Agnomhain,[4](javascript:footNote('E600001-030/note004.html')) whose Grandchild Britanus it was that gave the name to his land and nation who being our nearest neighbours and here long before we [**Milesians**] came into Ireland terme us still **Gaedhail**, as we do of our said head and ancestor, Gedhal, which (as it is pronounced) is Gél, who was no son of Caecrops, nor of Argus as they supposed because perhaps they found that he was of the kingdom which was the ancientest of **Greece** except the Sicyonian that Ægialus begun, when Belus began the Asyrian kingdom, where Xerxes their 7th king reigned and Turimachus the 7th also of the Sicionians, Inach begun the kingdom of the Argives in Peloponessus, whose son Phoroneus[5](javascript:footNote('E600001-030/note005.html')) was grandfather to Argus that (after Apis went into **Egypt**) reigned there, whom Creasus succeeded, in whose time when Matnilas the 14th king reigned over the **Assyrians**, and Orthopolis the 12th king over the **Sicyonians**. Moysis was born in **Egypt**, who (according to our writers ledd the **Israelites** from thence before Gaedhal went thither, whereby he could be no son of Argus, for his father, who is called by our writers Nél or Nelus, is by the **Greeks** called Sthe-Nélus,[6](javascript:footNote('E600001-030/note006.html')) and himself which 



---

p.212



we call Gaedhal or Gel) Gelanor,[7](javascript:footNote('E600001-030/note007.html')) which addition proceeds of the alteration of the ancient brief languages used then in **Greece**, that is imported by our writers and differs much from the Greek tongue, which an infinite number, excellently learned in all sciences brought afterwards to the height of perfection, who as they beautified and altered the language, did also beautifye with these additions, the names which they got by Tradition, being destitute of letters in **Greece**, long after Gaedhal or Gelanor[8](javascript:footNote('E600001-030/note008.html')), for whose time ~~&~~ and the cause of his going out of the country our writers agree with the **Greeks**: for **Eusebius** writes that Danaus, called Armeus was driven away by the Egyptians, who created King Ramesses, called Egyptus of whom the country (called before Cerie *[aerie]* ) take the name, and that the Argives expulsed Gelanor son to Sthenelus their 9th king and made Danaus their king.


**Pausanias** that treats more of their controversie writes that Sthenelus was son to Crotopus the son of Agenor, that was brother to Jasus and *2nd* son to Triopas the 7th king of the Argives, and that Danaus came and challenged the kingdom of Gelanor the son of Sthenelus, where after each of them alledged many probable and lawful reasons, the matter being deferred that day, the next morning as the cattel was going to pasture a wolf ran among them, wherewith their Bull fought, which moved the Argives to imagine superstitiously that the bull or conductor of their cattel signified Gelanor, and the wolf, that lives not among men, Danaus, that never before lived with them, and when the Bull was overcome they judged the kingdom to Danaus, whereby Gaedhal or Gelanor was (according to the **Greeks**) driven away, when Amintas the 7th king reigned over the **Assyrians**, and Chorax the 10th king over the Sycionians, and Danaus (in his place) the 10th king over the Argives, and Erichthonio the 4th king over the Athenians, Jesus naue then commanding and judging the **Israelites**. Our ancient writers whose language is so dead and out of use as it is now very hardly understood, write that Gaedhal, or Gelanor[9](javascript:footNote('E600001-030/note009.html')) being in controversie for his kingdom was driven away and went into **Egypt**, whereof I have in the same ancient language written here the beginning, as it was set down (at the request of Mál son to Ugaine Mor, that was king of all the nation in Ireland and Scotland about 2000 years past) by Roighne[10](javascript:footNote('E600001-030/note010.html')) one of our ancient writers, that begins thus:—



---

p.213



> 1. A mec ain Ugaine,
>   
> Co saich do rus ingaibhe
>   
> Scethieth saichset sluaigh ri Senair,
>   
> Snigis Niul Egipt,
>   
> Rersat ré ruidles,
>   
> La Forann fechtaib
>   
> Fonais Niul Scota,
>   
> Co n-epert ar naithre.
> 




By the which repeating first the king's son's demand he signifies that Scethieth, terra Cethim, belonged to Gaedhal or Gelanor's father and G*rand*father, that Gaedhal reached into **Egypt**, was favorably accepted by Pharao and prevailed in the love of Scota, here (as all our writers) he calls the grandfather of Gaedhal (or Gelanor) Féinios, who is by **Eusebius** and **Pausanias** called Crotopus which (proceeding of the several names of one man then) brings to differ often in names those authors that call one by sundrie names, as the Egyptian kings are called by **Eusebius** and many **Greeks** by them both. It (for the time) agrees well with our writers who sette down that Gaedhal or Gelanor being thro' controversies expulsed, went into **Egypt** shortly after Moyse's time, which must be in Jesus naue his time, and that he married Scota the Daughter of Pharao which (as some supposed) could not be Orus that long before succeeded Amenophis, called Memnon whose Image gave some noise at the rising of the sun, but rather Egyptus, unto whom Gaedhal is likelier to have gone, or sought because he expulsed his adversary Danaus of which woman Scota all our ancient books and writers conclude that the nation are called **Scotts** and **Gaedhail** or **Gaedhil** who came not into **Spain** as was also supposed himself and Scota, and their son Esru, having all ended their lives in **Egypt**, but Esru his son Sru[11](javascript:footNote('E600001-030/note011.html')) together with his son Eber Scot came with four vessels 



---

p.214



back into **Greece** where Sru died immediately, his son Ebher Scot attained to be of great degree, who had to his son Beoman, he had Oghamán, he had Taat, he had Adhnomhan, he had Láimhfhinn, he had Ebher Glúnfhinn, he had Adhnamhan Finn, he had Ebhric Glas he had Nenuall, he had Nuadhat,[12](javascript:footNote('E600001-030/note012.html')) he had Alloid, he had Ercada, he had Deaghatha, whose son Bratha or Bractius was the first of the nation that (not very long after the return of the **Greeks** from Troy) brought a colony in seven vessels to the south-west part of **Spaine**, where having by mischance lost some of his men and overthrown in two battles by that country people he came in **Galicia** and into the northeast part of **Portugal** wherein he founded Bracha or **Braga** so called of him and the countrie of him and his people **Galicia** Bracharenes his son Breogan or Breghan founded **Brigancia** which (as divers holde and write) is not St James called **Compostella** but **Corunna**, as some of the ancientest of Spanish writers holde, and ours also who write **Brigancia** to be upon the sea, as St James's is not, nor nere it, and make mention of a tower which he built[13](javascript:footNote('E600001-030/note013.html')) near the city upon the sea, the ruins of which tower that standes within half a mile of **Corunna** down towards the sea on the west side of the haven or bay is called still **Tower of Brighan**. This Brighan, the son of Bracchus, had many sons whereof the eldest Bile or Bilius and his son Miledh[14](javascript:footNote('E600001-030/note014.html')) or Milesius after him were Lords of Biscay, and kept their chief seat upon the river of **Vermeo** in a place called **Mondaca** in which Ireland being then well known, for Echaidh mac Eirc[15](javascript:footNote('E600001-030/note015.html')) the 



---

p.215



last king of the posterity of the sons of Dela, who was the first that gave lawes in Ireland,—had his wife Tailltin from thence, it happened that Ith or Ithius,[16](javascript:footNote('E600001-030/note016.html')) another son of Brighan came to see Ireland, where Mac Cuill*,* Mac Cecht and Mac Gréine, sons to Cermoda of the nation called **Tuatha de Danann**, by whom the posterity of the sons of Dela was *[had been]* long before suppressed, reigned together who were then gone to Oileach[17](javascript:footNote('E600001-030/note017.html')) in the north to divide the goods of Nuada[18](javascript:footNote('E600001-030/note018.html')) that was killed by some of those septentrional corpulent Easterlings called **Fomoiri**[19](javascript:footNote('E600001-030/note019.html')) that of ould vexed these three kingdoms, which they invaded in the times of Brittanus[20](javascript:footNote('E600001-030/note020.html')) and the rest of Nemeus his grandchildren, whereof Britanus or (as is said) Brutus his warrs with the giants was, altho' they were, as the word Fomóir signifies, but corpulent men that under Conaing mac Faebhuir came from the northest parts where to this day the name of a king is Coningc.[21](javascript:footNote('E600001-030/note021.html')) Ithus the son of Brighan, landing then in the west of Munster went thro' the country to Oilech where he found at dissention those three brothers that were kings, who being by them made their arbitrators agreed betwixt them, and he commended the fertility, goodness and temperature of their country which, after his departure, moved them (imagining it dangerous that such a stranger that knew their country and dissension, should go away safe), to follow and kill him, whose son Lughaidh[22](javascript:footNote('E600001-030/note022.html')) escaped into **Spain**, and complained thereof to the sons of Milesius, that were then chiefs of all the nation,



---

p.216



who to revenge that act came with an army for Ireland[23](javascript:footNote('E600001-030/note023.html')) when King David[24](javascript:footNote('E600001-030/note024.html')) reigned over the **Israelites** and Eupalus the 30th king over the **Assyrians** and Archestratus the 3rd king over the **Lacedemonians**, and Trion the *2nd* king over the Corinthians, in the time of the 1st Athenian magistrate, Medon the son of Codrus, their last king. Of the 7 sons of Milesius that came to that expedition 4 lost their lives before any landed in Ireland. Aranán having fallen from his ship mast, whereof he died, and Colpa was lost at lnbher Colpa[25](javascript:footNote('E600001-030/note025.html')) as Donn was upon the rock beyond Dorsies called also **Tech Duinn**,[26](javascript:footNote('E600001-030/note026.html')) and Ir or Irenos one of the best of them, died the night before Ebher or Iberus and Hermon, and Amarginus the other 3 brothers landed at **Inbher Scéine**[27](javascript:footNote('E600001-030/note027.html')) in the west of Munster, from whence having led their forces, after some fighting, at Sliabh Mis[28](javascript:footNote('E600001-030/note028.html')) and other places, the 3 brothers that were kings and they came to fight a battle at Tailtin[29](javascript:footNote('E600001-030/note029.html')) where those 3 brothers and most part of their nation were killed, the rest, but a few that served our nation being driven out of the land whereof (by division) the Princes of south and north Munster with a great part of Leinster and Conaught was allotted to Iberius: the middlemost part called Meath with the rest of Leinster and Connaught to Hermon, and upon their landing Ebher Donn or Iberius the son of Irenis (that died the night before) had the west part of Munster, and afterwards, at the division, the north part of Ireland, but they fell shortly in civill warre, wherein Iberius was killed by his second Brother Hermon which gave occasion to their houses to be most commonly afterwards at wars, as the House of Hermon was also at warrs much with the house of Ireus that were kings of the North or Ulster, of which 3 houses the kings who reigned over all Ireland were descended, 



---

p.217



and all the kings of the nation that reigned in Scotland, which they invaded about 250 years after their coming into Ireland, under the conduct of Eneas King of Ireland called Aengus Ollmhucaidh[30](javascript:footNote('E600001-030/note030.html')) the son of Fiachaidh Labhruinne, of the house of Hermon, by whom the nations that were in Scotland, and in the north parts of this land (as **Pights**, **Britons**, some of the posterity of the sons of Dela,[31](javascript:footNote('E600001-030/note031.html')) and some of them that we [**Milesians**] expulsed) were overthrown in many battles whereby that land was afterwards reduced under our nation, who called it of themselves (or as they called Ireland before) Scotland, where before they had kings there, one king reigned over both countries, and afterwards sometimes, in the names of whose ancient kings and chiefest men, which ordinarily was Eachus, Nateus, Atrius, Diomed,[32](javascript:footNote('E600001-030/note032.html')) or such ancient Greek names, and in their manner of Government, their assemblies at **Tailltin**,[33](javascript:footNote('E600001-030/note033.html')) for the like exercises that the **Greeks** used at **Olympus**, their affection to letters and poetry, and in all their fashions customs and usages they shewed themselves **Greeks**.


It appears by some ancient books that (before any other people of **Greece**) they had in **Egypt** knowledge of letters, which carries some likelihood in respect that Gaedhal, or Gelanor went into **Egypt**, after Moyses, in the time (according to **Eusebius**) of Cath the son of Tresmegistus when (long before **Greece** had any) letters were known in **Egypt**, where he and his son and Grandchild came back into **Greece** spent their tyme, as also that in Ireland at the first they had several sorts that were seen in letters, whereof the one was derived from fis[34](javascript:footNote('E600001-030/note034.html')) which is knowledge and called fisici —



---

p.218



men of knowledge, as philosophers were called, before modesty moved **Pythagoras** to term himself a lover of wisdom, the other was filedh a poet, and another called draoi, wise man, some kind of magician or soothsayer, for the nation was not destitute of the superstitious Idolatrous sacrifices and observations of the **Greeks**, whereunto their king Tighernmus mac Follaigh Grandchild to Irial, Hermon's son being given, thrived as well as **Zoroastres**, for as he did set up an Idol called **Crom Cruach**[35](javascript:footNote('E600001-030/note035.html')) and imitating the oracles of the **Greeks**, allured Demons or Spirits to give answers therein (as hath been done if **Trismegistus** be to be believed) himself and the most part of the people were consumed with fire at **Magh Slecht**, before whose time, which was about one hundred years after their coming into Ireland, the nation was not cautious nor careful of wealth, for they had no coyne stampt nor no plate nor vessels of gould nor silver, nor clothes died with sundrie colours, until his reign, nor had noe skill in ordering or arraying of battles, nor their men reduced into companies, and brought to fight under insegnes until afterwards in the reign of **Enna Airgthech**[36](javascript:footNote('E600001-030/note036.html')) a king of the house of Iberius. It seems that they had a silver mine there, by the name of the place called thereof **Airged-ros**[37](javascript:footNote('E600001-030/note037.html')) by the great store of coin that was stamped there, and by the number of silver shields made there by the King of Ireland — **Enna Aircthech**, the son of Eachus surnamed Mumo[38](javascript:footNote('E600001-030/note038.html')) (of whom Munster took the name Mumonia) whose great Grandfather was Conmaol, Iberius his son.


I did not read as some wrote, that nation had in **Spain**, nor brought into Ireland, any such seat of stone[39](javascript:footNote('E600001-030/note039.html')) as was brought from 



---

p.219



Scotland hither, but I did read that the nation which we *[**Milesians**]* conquered there that were admirable and exceeding magicians[40](javascript:footNote('E600001-030/note040.html')) brought such a seat from the city in the septentrional parts of the East called Failias[41](javascript:footNote('E600001-030/note041.html')) wherein belike they conjured some spirit that (when he that was elected and should prevail to be king was set thereon) gave some noise[42](javascript:footNote('E600001-030/note042.html')) (as the Image of **Amenophis** or **Memnon** did at the rising of the sun), which our nation found there, and used and reigned there where they found it, who sometimes had no absolute king, but every Prince or chief governing his own Province, as they were at the Incarnation of Christ, which was above 2000 years after their coming into Ireland, then had they those that were called curidha,[43](javascript:footNote('E600001-030/note043.html')) Curdi, **Conall Cernach**, **Cuchulainn**, and others that for their agility, strength, and valour were much celebrated; and about 150 years after they had those bands or companies called Fiana[44](javascript:footNote('E600001-030/note044.html')) that for their activity and valour were elected, and chosen out of all the provinces, their chief charge was to watch the havens, and keep the country from sudden invasion, being commanded by **Cumhall mac Trénmoir**, a Leinsterman, and by **Fin*n* mac Cumhaill**, his son, after he was killed at the battle of **Cnuc*h*a** by **Conn Cédcathach**,[45](javascript:footNote('E600001-030/note045.html')) or Conn *[of the hundred battles]*sup> who, being chief of Hermon's 



---

p.220



house, was at mortal war for the chief rule with Moghnuadhat[46](javascript:footNote('E600001-030/note046.html')) or Mowh, heir and chief of the house of Iberius, whereupon all Ireland was between them divided with a great Trench[47](javascript:footNote('E600001-030/note047.html')) from Dublin Ford called **Aahe Clieh** *[i.e. Átha Cliath]*, to the other Aahe clieh of **Mearie** beyond Galway, whereon the South part is ever since called the Half of Mowh and the north the Half of Conn. Shortly after some of the nation began to understand of Christian Religion by ***Brénainn **Birra*****[48](javascript:footNote('E600001-030/note048.html')) called **Brendanus** and others, and about the yeare of our Lord 370 Patricius[49](javascript:footNote('E600001-030/note049.html')) being a youth, was brought a prisoner into Ireland, whose life and literature afterwards purchased him to be by **Celestine** the first imployed thither, where he (accompanied with as many of the Scots nation as he found instructed in the religion) and converted that country people, who for 400 years after[50](javascript:footNote('E600001-030/note050.html')) lived very zealous and liberal to their churches, religious houses, and academies. What their manner of government, wealth and ability was then appears by the number of volumes of good Laws[51](javascript:footNote('E600001-030/note051.html')) made by their kings, by the 



---

p.221



coins stampt for the kings of the Half of Conn at **Ardmach**[52](javascript:footNote('E600001-030/note052.html')) and for the kings of the Half of Mowh at **Cassil**[53](javascript:footNote('E600001-030/note053.html')) whereof some is yet extant; by their great traffic and frequentation of merchants,[54](javascript:footNote('E600001-030/note054.html')) and marts and fairs[55](javascript:footNote('E600001-030/note055.html')) which was such as when (in the time that the **Danes** invaded that country) Counte Olfyn ledd 3 or 4000 **Danes** from Limbrick to rifle or spoile the faire that was on St Peter and Paul's day at **Roscrea**[56](javascript:footNote('E600001-030/note056.html')) in Ely, the numbers of buyers and sellers that were there came in arms against him, and overthrew and killed him and his forces. And what their civility was appears by the numbers of their learned men, and their academies, which were chiefly at **Downe**, **Cassil** and **Ardmacha**, where so many colleges were, that (as appears by an ancient record found of late years at **Oxford**[57](javascript:footNote('E600001-030/note057.html'))) the students of **Ardmacha** being on a time registered, were found to be above 7000, which brought many of that country people to be (for their life and literature) so much esteemed that the Saxon kings of this land intreated **Colum Cille, called Columbus**, to take their children with him thither to be brought up, as **Beda**[58](javascript:footNote('E600001-030/note058.html'))


---

p.222



testifies. Neither will the Germans deny but that **Bonifacius**[59](javascript:footNote('E600001-030/note059.html')) one of the Scotish nation, was their apostle, and when Ferleus[60](javascript:footNote('E600001-030/note060.html')) Foilianus and Ultanus, sons to Aodh *Ben*n*an*, king of the Half of Mowh came in the year of our Lord 650 into France, king Clodoveus[61](javascript:footNote('E600001-030/note061.html')) accepted them favourablie, and gave them their choice of any land there, whereupon they founded **Latiniacum monasterium**,[62](javascript:footNote('E600001-030/note062.html')) as **Columbanus**,[63](javascript:footNote('E600001-030/note063.html')) another of that same house, founded Luxoniense *monasterium*, in **Clotharius** his time, all which Placitus the German testifies.


I omitt to trouble y*ou*r Lordship with divers others that increased religion and learning in Germany, France and England, where they founded **Glastonburie**[64](javascript:footNote('E600001-030/note064.html')) and divers other places, and taught the **Saxons** the use of letters, as appeareth by some of their own best antiquaries,[65](javascript:footNote('E600001-030/note065.html')) and by the Saxon letters which are our characters. 



---

p.223



And for their own country St. Bernard in the life of **Maelmaedhog O'Morgair** called Malachias[66](javascript:footNote('E600001-030/note066.html')) writes what monuments they left, and what a number of learned men have been there, who although their eloquence was great could not keep their unfortunate nobility from civil war, which moved some to threaten and foretell the infinite ruins that within a little happened, for shortly after the year of our Lord 800 Atreus or**Airtri mac Cathail**,[67](javascript:footNote('E600001-030/note067.html')) commanding the Half of Mowh, and **Aodh mac Neill** the Half of Conn, the **Danes** began to invade that country called then of the nation Scotland,[68](javascript:footNote('E600001-030/note068.html')) until the country people calling it Ere (of the wife of **Mac Cuill** that reigned there at our coming[69](javascript:footNote('E600001-030/note069.html'))); the Eastern nations added land[70](javascript:footNote('E600001-030/note070.html')) and so called it Ereland.


These (**Danes**) came first under Turgesius,[71](javascript:footNote('E600001-030/note071.html')) who spoiled **Ardmacha**,



---

p.224



where he settled himself driving away Pharananus the Primate, and all the religious men and students; from thence he came to **Loghrie**, where being taken prisoner with a stratagem by Maelsechlainn[72](javascript:footNote('E600001-030/note072.html')) Prince or chief of Meath, and shortly after drowned at **Logh-Aininn**;[73](javascript:footNote('E600001-030/note073.html')) the **Danes** were overthrown in divers battles by the houses of **Tireconnell**, North Munster, **Tireown**, Meath, and by Olcobhar,[74](javascript:footNote('E600001-030/note074.html')) King of the Half of Mowh: but in the end **Aodh Finnliath**, King of the half of Conn[75](javascript:footNote('E600001-030/note075.html')) deserved the chief praise, by whom (by the help of the chiefs of Meath, Connaught and Leinster, they were driven away, altho' a great fleete and power was brought by Alanus *[Aulavus*[76](javascript:footNote('E600001-030/note076.html')) the King of Denmark's son, who after his repulse supplied *[recruited]* his forces, and came into Scotland, where (coming to fight with the rest of our nation) he was overthrown and killed.


Afterwards in the time of Niall Glundubh[77](javascript:footNote('E600001-030/note077.html')) son to Aodh Finliath aforesaid, Blind Sitrick O'Hiowmar,[78](javascript:footNote('E600001-030/note078.html')) first (by whom Ugaire mac Oilella, the chief, and all the Lords of Leinster were overthrown and killed,) and thereupon the rest of the O'Hiowmars came with a mighty power and took Dublin, where the King, Niall Glundubh, with the forces of Ulster, Meath and Connaught, came to feight with them) was overthrown and himself with the nobility, and above 5000 of theirs killed; but within a while after Donnchadh mac mic Maelsechlainn[79](javascript:footNote('E600001-030/note079.html')) of Meath overthrew their chief forces at **Tech mic n-Echach**, and Congalach mac Maoilmithigh, King of the Half of Conn, overthrew them at **Muine Brocáin**[80](javascript:footNote('E600001-030/note080.html')) where they lost 7000 men; and **Ceallachan**, 



---

p.225



King of the Half of Mowh,[81](javascript:footNote('E600001-030/note081.html')) overthrew them in divers battles by land and by sea at their departure, who having supplied their forces came afterwards to Limberick with a far mightier power under the Hiowhmars, by whom the land was brought again under that barbarous cruel covetous nation, whose Tyranny was to place Lords and petty lords of theirs in every country and barony, seargeants in every town, and another under-officer in every house
[82](javascript:footNote('E600001-030/note082.html')) that had yearly half the goods thereof. Their King's rente was not exacted of lands, cattel or comodities but of men, for every body paid a mark yearly, or had his nose cut off; they destroyed the churches, religious houses, and academies, and led from **Ardmacha** 2000 students into bondage. At the first they burned all the books they found, which afterwards they took away with them.


And as divers helped before to repulse them, so now all was performed by the endeavour and valour of Brien, *2nd* son to Kinedy, or Cinnedi mac Lorcain, chief of north Munster who (after his elder brother was unluckily killed)[83](javascript:footNote('E600001-030/note083.html')) foiled the **Danes** and others that stood in controversie with him and attaining to be King of the half of Mowh overthrew in many battles and expulsed the **Danes**, and was by common consent received King of all Ireland. In his later days Maelmorda mac Murchadha[84](javascript:footNote('E600001-030/note084.html')) chief of Leinster rebelled, and (by the help of a colony of Danish merchants which the King permitted to remain at Dublin) wrought Carolus, Cnutus and Andreas, the King of Denmark's sons, to come with a great army to Dublin, where (when the King of Ireland came) a terrible battle well ordered and arranged was long fought, in the which the **Danes** were overthrown, and their King's three sons, and all the nobility,



---

p.226



and 6700 of those that were in the maine battle, and well nere 4000 of the Dublin men and **Danes** that were mingled with them, and the chief and nobility of Leinster and 3200 of their men were all killed. Of the other side the Prince of Ireland, Murchard, son and heir to the King, and chief commander of the army, who for valour and reputation in arms excelled, and his son, and almost all the nobility of both Munster and Connaught, and above 4000 of their men were all killed. Some few of the **Danes** that fled into the land lighted to the old King's tent, where they were killed, in which broil the King received a wound in his head, with an axe, whereof he died, being 88 years of age,[85](javascript:footNote('E600001-030/note085.html')) after he was 37 years King of the Half of Mowh, *[Leath-Mhogha]* and 12 years King of all Ireland. This battle was fought at **Cluan Tarff** by Dublin *[Clontarf near Dublin]* on Good Friday the 22 of April in the year of our Lord 1014, being the 25th battle wherein he overthrew the **Danes**, who never since attempted to invade that country. His *2nd* son Donnchadh[86](javascript:footNote('E600001-030/note086.html')) succeeded him, who in his latter days, after he raigned above 50 years, went to Terra Sancta, leaving the kingdom to Toirdealbhach,[87](javascript:footNote('E600001-030/note087.html')) son to his *2nd* brother Tadhg, a man of good worth, that reigned 17 years, whose son Muirchertach[88](javascript:footNote('E600001-030/note088.html')) that succeeded him (being for his justice, generosity and valour well beloved and esteemed, and much favoured and affected by the King and the rest of the nation in Scotland, after he reigned 29 years) fell extreme sick at **Ardmacha**, in the year 1115, whereof he died 5 years after, and was the last King of the nation, this King that now is being the first after him, of the nation itself, that reigned over Ireland, of whose ancestors many have been before Kings of all Ireland, who being the first of our nation that reigned over these three kingdoms, altho' all sorts are hard to be pleased in this world, nobody can deny him to be a just King, which is the greatest praise that either King or anie other can have, and to be a man that wants neither sense nor utterance.


Upon Murchards sickness the provinces of Ireland fell to disobedience and dissension, and his *2nd* brother Diarmott took possession of North Munster, whose son Toirdealbhach, that succeeded him therein, was much oppressed by the power of Toirdhealbhach mac Ruaidhri[89](javascript:footNote('E600001-030/note089.html')) chief of Connaught to whose son, Ruadhiri or 



---

p.227



Roderick[90](javascript:footNote('E600001-030/note090.html')) he and the chiefs of Meath and Ulster promised obedience whereby many called him King of Ireland. At which time Dermod Mac Murchard, cheif of Leinster, ravished Dearbhorgaill[91](javascript:footNote('E600001-030/note091.html')) daughter to Murchadh mac Flainn of Meath, and wife to Oroirk L*or*d of Brefny, which incensed against him the said Roderick by whom Leinster was spoiled, McMurchow's house at Fearna[92](javascript:footNote('E600001-030/note092.html')) destroyed, and himself driven out of the land, who went to King Hen*ry* *2nd*, that was then in France, by whom he was favourably used, and dismissed with letters to licence as many as would go here *[in England]* hence with him. In his return he conditioned at Bristol with Richard the son of Gilbert,[93](javascript:footNote('E600001-030/note093.html')) Earl of Stranguel, to give him his daughter Aive and Leinster, after his Decease, and from thence went to the Prince of Wales, Rice Ap Grifine, who inlarged for him out of prison Robert Fitz Stephens, upon promise to follow McMurchow, that went then for Ireland, when he kept secretly until Rob*er*t Fitz Stephens, Maurice Fitz Gerald, and others came with 90 horse and 300 archers, whom the Earl of Stranguel followed at Bartholomew's tide in the year 1170, with 200 horse and a thousand archers, and married the Daughter of Mac Murchow, who brought Leinster under his obedience, and surprised Dublin, whereof, and of the dissensions of the provinces of Ireland when King Henry was advertised he came the 8 of Oc*to*b*e*r in the year 1172 to Waterford, where the Lords of North and South Munster, and afterwards at Dublin the Lords Tirconnell, Brehny, Oiriel and divers others (being all weary of civill war) became subjects to his Majesty, who leaving Hugo de Lacie, his constable there, came for England. After whose departure the Earl of Stranguel behaved himself very irreligiously in burning of churches, unto whom Lacie was not much inferior. How John de Courcie then dispossessed many of their lands and (when he and Lacie were at odds for it) rebelled and how (when King John came hither) Walter de Lacie rebelled, whereby the King was driven to follow him into the north, to make a bridge of his ships over Strangford Haven, and to besiege **Carrick Feargus**, from whence Lacie fled for England; the cause of Rebellions since, and of all the losses that the crown and country sustained thereby, is not so much noted or remembered as the blame is cast generally upon that country people, who although they are 



---

p.228



thought by many fitter to be (as a Scottish Knight said) rooted out than suffered to enjoy their lands, are not so rebellions or dangerous[94](javascript:footNote('E600001-030/note094.html')) as they are termed by such as covete it, nor so rude or wilde as those Sicilians were (that as **Plutarch** writes by continual wars became as savage as beasts) with whom, nor with noe other nation wars continued not so long as with them, wherewith learning being decayed, the most part of those that wrote since did write without good order or agreement, whereby those that wrote before when they were learned, are thought best worthy of credit, together with those that wrote before they embraced Christianity or were so much learned, whose writings is very brief and obscure and language dead,[95](javascript:footNote('E600001-030/note095.html')) out of use, and hard to be understood, which is much written in verse, where their arms and colours is mentioned, by the which it sh*oul*d seem that he that gave this Lyon first in Scotland was of the house of Ulster, but those that were learned who wrote about 1000 or 800 years past, although their language also is now out of use, wrote more copious and elegant, to whose books, if this king were anything affected, I think his Majesty might best have them.[96](javascript:footNote('E600001-030/note096.html'))


This much of the Nation (being all the service that I am able to doe *your Lordship*) I thought fit to acquaint *your Lordship* withal, before I 



---

p.229



end my life in the languishing torture of this close prison, where since my commitment I have bene threese tossed without any matter to chardge me withall,[97](javascript:footNote('E600001-030/note097.html')) and where, so long as God will spare me life, I will rest *your Lordship's* most humble and faithful to be commanded.[98](javascript:footNote('E600001-030/note098.html'))


Florence Mac Carthy.



