

#Letter from Jane Adams, containing a private narrative of the rebellion of 1798


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Letter from Jane Adams, containing a private narrative of the rebellion of 1798
===============================================================================


Author: Jane Adams
------------------


### File Description

Thomas Crofton CrokerElectronic edition compiled by Ruth Murphy, Beatrix Färber

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project. 1. First draft, revised and corrected.Extent of text: 

19,000 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2007) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E790001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript source**2. If and where this letter may be extant today is not known.
**Editions**2. Thomas Crofton, Croker, Researches in the south of Ireland illustrative of the scenery, architectural remains, and the manners and superstitions of the peasantry, with an appendix containing a private narrative of the rebellion of 1798; introduction by Kevin Danaher. Shannon: Irish University Press, 1969.
3. John D. Beatty, Protestant women's narratives of the Irish rebellion of 1798. Dublin: Four Courts, 2001.
**Further reading: A selection**2. Thomas Paine, The age of reason, being an investigation of true and fabulous theology. Paris [i.e. London?] 1794.
3. Sir Richard Musgrave, Memoirs of the different rebellions in Ireland from the arrival of the English, with a particular detail of that which broke out 23 May, 1798. Dublin 1801.
4. Sir Richard Musgrave, (ed.). Memoirs of the different rebellions in Ireland from the arrival of the English: also, a particular detail of that which broke out on 3rd May, 1798; with the history of the conspiracy which preceded it; edited by Steven W. Myers, Delores E. McKnight; with a foreword by David Dickson; indexed by Steven W. Myers, Ryan Taylor. 4th edition. Fort Wayne (Indiana, USA): Round Tower Books 1995.
5. Jim Smyth, 'Anti-Catholicism, conservatism, and conspiracy: Sir Richard Musgrave's Memoirs of the Different Rebellions in Ireland'. Eighteenth Century Life, ns, 22:3 (1998), 62-73.
6. Brian Cleary, 'The Wexford republic of June 1798'. In: Walter Forde (ed.), Shelmalier '98: a history of Castlebridge, Screen and Curracloe in 1798 (Shelmalier Comóradh '98, 1998) 10-18.
7. Jim Smyth (ed.), Revolution, counter revolution and union: Ireland in the 1790s. Cambridge: Cambridge University Press, 2000.
8. Thomas Bartlett; David Dickson; Dáire Keogh; Kevin Whelan (eds.), 1798: A Bicentenary Perspective. Dublin: Four Courts, 2003. [941.507.Bart in Boole Library]
**The edition used in the digital edition**2. Researches in the south of Ireland: illustrative of the scenery, architectural remains, and the manners and superstitions of the peasantry; with an appendix containing a private narrative of the Rebellion of 1798. Thomas Crofton Croker First edition [385 pages] John MurrayLondon (1824)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the appendix, on pages 346–385 of the volume.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text represents the edited text.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section (of which there is one); page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, personal names, and terms are not tagged. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: By Jane Adams Date range: May 1798.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [FR] A few words are in French.


##### Language: [LA] A few words are in Latin.


### Revision History


* (2008-09-24) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2007-11-30) Beatrix Färber (ed.)

* File parsed; SGML and HTML files created.
* (2007-11-29) Beatrix Färber (ed.)

* File proof-read (2); header modified, bibliography constructed.
* (2007-10-04) Ruth Murphy (ed.)

* file proof-read (1), structural and content mark up applied.
* (2007-10-04) Ruth Murphy (ed.)

* Header created.
* (2007-07-09) Beatrix Färber (data capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E790001


### Letter from Jane Adams, containing a private narrative of the rebellion of 1798: Author: Jane Adams




---

p.346


The following Narrative was written without any view to publication, and was transmitted to me by its amiable writer, to whom my thanks are due for the kind and friendly manner in which she granted me permission to insert it in this work.




---

p.347


Summerseat, Co. Wexford, May, 1798.
My dear friend,


I fear we are in a most alarming situation. We have just had dreadful accounts from Naas—the rebels have defeated and killed Captain Swayne, of Youghall. Nancy Owen, in a letter of this day, says, that there are hundreds giving up fire-arms and pikes; but notwithstanding the country wears a most alarming appearance. My father laughs at the idea of danger; but I strongly suspect we are surrounded by rebels and spies. Yesterday, rather a genteel looking man came up the lawn to me, and said he wished much to have the pleasure of instructing a few young ladies in geography, and begged I would allow him to teach my family. I told him my daughters were too young, and that I did not think he was likely to get any pupils in the neighbourhood. This day, as I was walking in the shrubbery near the road, I looked out, on hearing a number of horses, and saw the same young man under an escort going to jail, from information sent to Mr. Boyd by government. There was found upon him a plan of all our houses, the names and number of the inhabitants, and a copy of **Paine**'s Age of Reason. Mrs. Harvey, our near neighbour, has got a guard to sleep at Killeen Castle; we supped with her last night, and an express was sent for the gentleman who commanded the party.—My father is still incredulous!




---

p.348


*Whit-Sunday*.—Just returned from church. In our way there, we met the Wexford cavalry escorting Mr. Colclough (pronounced Cokeley) and Mr. Bagnal Harvey to jail; they are both gentlemen of good fortune in this barony. What a task for Captain Boyd! both men at whose houses he was in habits of intimacy. Where will all this end? I want my father to come to Dublin, but he seems determined to be blind and deaf to what is going on. At church Mr. Bevan hurried over the communion-service, and told us he was not without his fears that we should be surrounded by rebels while at the communion table. I am told the whole country is up. Mr. Bevan saw the smiths openly at work in their forges making pikes, though Whit-Sunday. On our way home we met Mrs. Percival's carriage driving furiously; the coachman would scarcely wait to tell us that he had left some of the children in Wexford, and was returning for his mistress and the rest of the family; as an express had arrived that there were seven thousand rebels within three miles of the town. I will continue to write, and collect all for to-morrow's post. Mrs. Percival and several others are getting off to England, caring little for accommodation, if they can obtain any kind of a boat.—This is truly alarming.—Mr. Percival is high sheriff. The North Cork and the Wexford yeomanry and cavalry are sent for to rout the rebels. In vain do I implore my father even to come to Wexford.


*Whit-Sunday Evening*.—Every moment becomes more frightful. An account has just arrived that the North Cork are all put to death, in an engagement with the rebels. The unfortunate soldiers' wives are screaming through the streets of Wexford; every creature that appears is put under arms: and the thatch is stripped off all the cabins in the suburbs of the town. Enniscorthy is burned, and the inhabitants are pouring into Wexford. Women of fortune, half-dressed, some having neither shoes nor stockings, with their children on their backs and in their arms, are in this state endeavouring to get on board ship. I am told there never was a more dreadful scene than Wexford at this moment exhibits. I am assured that only four out of the North Cork have escaped the fury of the rebels: one hundred have been put to death. Major Lombard, whom I think you knew, has fallen a victim. I am told the post cannot proceed to Dublin; as the roads are all occupied by rebels. Captain Boyd has sent to Waterford for the 13th Regiment. Thank heaven, I wrote to poor Mr. A. and Letty 





---

p.349






Kynaston yesterday; this will a little relieve them; but when I shall again be able to write, God only knows. What dreadful anxiety they must be in!


*Whit-Monday*.—A report to day that the 13th have been taken prisoners by the rebel army, and that Mr. Colclough and Mr. B. Harvey have been sent to the rebel camp to compromise with the rebel leaders—a compromise with rebels seems strange to me! So far I had written last Tuesday—what I have suffered since I cannot describe. On Wednesday the army and all the loyalists fled; we saw them on the hill to the left of our house.—Can you believe it, my father still perseveres in making light of it; ordered his horses, and would have rode into the town, but for some ladies that were flying from it, who assured him the rebels were in full possession! Whilst he was away, I had his bed, what things of value I could collect, and a basket of cold meat, put on a car, and sent to the strand, where Hayes, my father's gardener, went to secure a boat. The servant I had sent with the basket of bread and wine was not allowed to go far before he was knocked down and the basket taken from him.


When my poor father returned, he seemed quite subdued: I told him my plan, that the boat was ready, and that we had a chance of getting on board ship, as several vessels were lying-to. He consented, and we got into a boat, many of the peasantry forcing their way to come with us. When we got off a little, we found it impossible to gain a ship, and were advised by our gardener who rowed us, with another of our servants, (neither of whom had ever rowed before,) to make for an island a few miles distant, and remain there till we could get some further intelligence of affairs in Wexford. Whilst debating on this subject we saw a boat full of men, with green boughs in their hats, and a white handkerchief displayed as a rebel flag. They soon got up to us, and said, ‘if you will go home and turn Christians, you will be safe enough.’ This speech conveyed a great deal; I thought I should have fainted; but was soon roused by their vociferations, to put back—to return directly—that all was peace and liberty—that they had chaired Dr. Jacob[1](javascript:footNote('E790001/note001.html'))—that ‘he was *their* mayor, though *he was your*'s before.’ I begged, however, to prefer the *liberty* of the island till the first fury of the mob abated; but a Mr. and Mrs. Woodcock, who were with us, said 





---

p.350



 



they would return. We soon landed on the island, and there I found many of the peasantry who had made their escape at an earlier part of the day. We had brought plenty of cold provisions with us, and as those poor people had contrived to light a fire, and were boiling their potatoes, I had the comfort of being able to add a large piece of cold roast beef, their enjoyment of which gave me a momentary pleasure. Night was now approaching; where to place my father's bed was my next object: there was scarcely a bush on the island: at length, however, I discovered a friendly thorn-tree, on which I threw temporary curtains over his bed, into which he went with as much devotion as if lying down in his best bedchamber. I put my two dear children at one side of him, and sat at the other to keep the clothes over him; but was soon roused from every thought, except of present danger. I heard the dashing of oars, and a whispering amongst the people on the island: I had hoped we were in security at least till morning, as they all told me no one could land till the tide was full in; but what was my horror when the oars ceased, and, by the dim light, I saw a man walking towards me! he seized hold of my arm, and desired me not to be alarmed. I could scarcely breathe from terror, when poor Hayes said, ‘don't be frightened, Madam! it is I—happy am I that you are here; it was scarcely night when a party of rebels came to Summerseat, insisted on admittance, fired several shots over the hall door, went up to all the bed-rooms in search of arms, and said, if I concealed an Orangeman they would have my life; they then swore me into their gang, broke open the cellar, took away all the wine, and five bacon pigs; such a wreck as they have made of the place, madam! they had six carts with them; I could scarcely prevail on them to let me remain after them.’ You may think how happy I felt at this temporary escape, though almost the moment before I had reproached myself when looking at my dear father asleep on the ground. I begged of our faithful Hayes to return, and try to save what he could, and to come for us in the morning, as I saw the impossibility of remaining where there was no shelter of any kind. ‘I will, Madam, but’—‘But what, Hayes? speak out!’ ‘Why, Madam, they did say, they would come in the morning and burn the house!’ He then pointed out to me many distant fires. I really felt as if my head would burst in considering 





---

p.351



 



what was best to be done: at length I determined on his returning as early as he could. My father did not awaken till six in the morning; his two companions kept pace with him, and slept all night. I told him of Hayes's having been with me, and that I expected his return every moment; that I feared we could do nothing but go back to Summerseat, if it had not shared the same fate with several houses in the country.


All chance of getting a vessel to take us to Wales was over: some of the unfortunate persons who thought themselves happy in making their escape, were brought back to Wexford, and delivered up to the rebels! The large and respectable family of Killeen Castle escaped being put into the common jail only because there was no room for them; but they were put into an old empty house, and a guard placed over them. The first sight that presented itself to them was the Bull-ring (a square in Wexford so called) filled with kitchen tables and carpenters at work making pike handles. Mrs. Cliffe has since told me that the captain's wife came up to her on deck, a little after they had got on board, and said, *she hoped to be up to her knees in protestant blood before night!* that she had a brace of pistols in the belt of her gown, and swaggered up and down, repeating this horrid wish aloud.


But to return to our own distress.—My father bore my intelligence astonishingly, and agreed to return the moment Hayes came for us. The poor fellow lost no time, when the tide answered; and he brought us word the house was safe, and that no one had returned to it.


We got once more into the boat. When we reached the shore near enough to discern objects, we discovered hundreds of rebels, and, on a closer view, saw that they were all armed. I besought Hayes to turn back to the island; and here I must acknowledge it was my impious hope, that the boat might upset, and end all our cares together. But I had soon reason to adore that Providence I had dared for a moment to distrust. The rebels called out to us to land: almost petrified with horror, I looked at my poor father and children, expecting that the moment we landed we should be put to death. Hayes, with a countenance as full of horror as my own, endeavoured to quiet my fears: but what was my surprize, when, the moment I got out of the boat, a man came up and shook hands with me, 





---

p.352






desiring me not to be frightened; that he was *Captain* Butler, and would protect me as long as he could; that he would order a serjeant's guard home with me. ‘I know you very well; I was coachman to Mrs. Percival, and you were very kind to me the last day she went to see you; it was a wet day, and you ordered me a warm drink.’ He then turned round to select our guard from the hundreds that surrounded him. They were all contending for rank, wielding their guns, blunderbusses, and swords, in the most frightful manner. I expected every moment the contents would be fatal to us, from accident if not design; they were all drunk. At length they fixed on the guard to attend us home; one calling himself captain; another saying he was *head* lieutenant; and in mock procession they marched us towards Summerseat; but, before we were half-way, I found myself unable to proceed, and begged to stop at my neighbour's, Mr. Woodcock's, whose family had at first accompanied us to the island, but had returned, depending on the assurance of liberty which had been given them. On our arrival at Mr. Woodcock's, we found the family in the greatest consternation and dismay: they had been up all night, at the mercy of several parties of the rebels, who came repeatedly, and examined every part of the house, possessing themselves of everything they chose to take. The moments Mrs. Woodcock had to herself she employed in hiding flour, and any thing she could collect in the way of food, in the chimneys and roof of the house. Many of the rebels had threatened her, with a pistol at her breast, that if she had arms or Orangemen concealed, she should pay for it with her life. Whilst she was tremblingly recounting this to me, we saw a party, who had joined our guard, approaching towards the house with carts. Mr. Woodcock went out immediately to meet them: they obliged him again to open all his barns and offices, (Mr. W. was a respectable farmer, and a quaker,) out of which they filled their carts with flour, potatoes, &c. Not content with this, they insisted on coming into the house; and crowded up stairs, where Mrs. Woodcock and family, with my poor dear father and children, were waiting in terror their departure. On hearing them approach us, I actually pushed my father and children behind a bed, but by the time the rebels reached the room, I dragged them out again, fearing, had they found them hiding, it would have made 





---

p.353






them more desperate. I stood before them, when again *my friend*, Captain Butler, came up to me and said no harm should happen to me, and begged I would tell his mistress that, as long as he was Captain, he would protect the house; he believed she had got off to England, but he did not know what was become of his master, the high sheriff; however he was done with *that* now. The party examined every wardrobe, chest, and closet in the house; and one of them said, on going away, we have used you very well, but the next party is coming to burn all your houses. With what horror did we hear them! We looked at each other, without the power of utterance for many minutes. At length I said any thing was better than to be burned to death, and that we must do the best we could at the island, at least for a short time, till the fury of the day was over. I helped Mrs. Woodcock to collect as much as we could take with us; and though our own house was within a few fields distance, I was afraid to venture for any thing belonging to us.


With some difficulty we again embarked, and were rowed towards the island, but the tide was not sufficiently in for us to land; and while we were watching with impatience the covering of every rock or pebble, as we lay on our oars, we discovered a boat making fast towards us: as it approached we perceived the men were all armed. Dearest Susan, unconscious of danger, entertained us all by her droll remarks on them;—never was such a child; she really appeared more delightful than ever, and, I am certain, exerted herself to rouse us all from the stupor we were thrown into. At length the boat came near, the men called to us to know what we were doing there. Hayes answered, that we were going to the island, as soon as we could land. They called out, in one voice, ‘go back, go back; if you don't we will sink you: we want the island to put cattle on for our camp.’ Remonstrance was in vain,—‘go home’ (said they) ‘or to jail—take your choice.’ We were obliged to obey; and we arrived at Summerseat in about four hours; there we found every thing in the utmost confusion; all the servants had departed, except one faithful creature, who welcomed us with tears of joy. She had determined to stay till the last moment, and lamented that she had been of so little use. She told me the beds had been taken, the feathers thrown about the yard, and the ticking used as bags to carry off the clothes, curtains, &c. with the greater 





---

p.354






expedition. I observed that my beautiful geraniums were all broken to pieces. Poor Alley turned to me, with a dismal countenance, and said, ‘I wish you had nothing else to be sorry for: they have taken your guitar, and thumped Miss Susan's piano so violently, I was afraid they would break it to pieces; they desired I would get a rope to tie it on a car, but every strap and rope had been taken: to this I owe the safety of the dear child's piano.’—What to do for beds I knew not; but so soon as it was known that we were returned, one of the rebels, who had lived near Summerseat, came to me, and said, ‘Madam, I have four of your beds; God forbid you should sleep without one; I will bring them to you when it's dark: I took them off a cart at the cross-road, and swore I would let no one take them, till I heard you were entirely gone.’ Poor honest creature! he brought them as he promised. In constant dread did we live, with parties riding up at all hours, coming and taking their seat in the drawing-room, sans ceremonie, till the 2d of June, when my faithful Alley burst into the room where I was; she was pale as death. ‘What's the matter, Alley?’ ‘Oh, my dear mistress, I wish I had died the first day I saw you.’ She continued sobbing and clasping me to her, and was a length of time before she could bring herself to tell me there was a party coming to take us to jail. I dropped on the floor, and the first recollection I had of any thing, for some time, was seeing my father and children hanging over me, and hearing them thank God my colour was returning. I jumped up, with a confused idea of what Alley had told me; said I was a little sick, and would go into the air. In a few minutes I saw a large party ride into the lawn: I hurried into the house, to prepare my dear father for what he would too soon hear from these people. I assumed as much composure as I was capable of, and told my father the party coming were to take him to jail, but that no power should separate us; I would go with him, and take my children. He calmly said, ‘was it that made you faint, my dear?’ Then standing up, he put his hand upon his throat, and said, ‘I am ready for them: I am surprized the army has not been sent to our relief; but God's will be done.’ I walked about the house in a state of distraction; but my children behaved with much good sense; when they did speak, endeavouring to comfort me, assisting me as much as they were able, and hiding their own fears to keep up my spirits, which were 





---

p.355






indeed much agitated by this fresh shock. In a few minutes a party of fifty men, armed with blunderbusses and pistols, arrived, and made their way to the room in which my father was. I found him with a large Prayer Book in his hand reading the prayer for the Universal Catholic Church: this had little effect on them, and remonstrance had less. One of them said to me, ‘Mr. Owen has been favoured more than any gentleman in the barony: you should have sent for the priest long ago.’ He wickedly added, that our Saviour's prophecy was now fulfilling, when he said, ‘the first shall be last, and the last shall be first;’ that *we* had been *first* long enough. Fearing that my father might be put into a dungeon without food that he could eat, I had all the eggs I could get boiled hard, and some cheese cut into small pieces, rolled up in separate papers; concealing part about me, and the remainder I slipped into his coat pockets. I asked one of the guard if it were their intention to murder my dear father, and said, if that be your determination, I entreat you put us all to death this moment, and let me have the comfort of knowing that he and my children are at peace before you shoot me. He said, ‘you had better not repeat that, for we might do it if we chose; there is no one would bring us to account for it. Come, come,’ they continued, ‘there is no use in delaying, take him we will.’ I asked them how; as his carriage-horses had been seized, and there was no possible conveyance. They answered, ‘we'll get a cart for him, and you are young enough to walk.’ Another of them objected to taking me; but I said, with some warmth, ‘I hope if any of you have a father or children, you cannot have the heart to separate me from mine’. This seemed to make some impression; and while a few of them went in search of a cart, the rest took my darling Susan into all the rooms, desiring her to be a good child, and shew them where the *guns* were. I went to my faithful Alley, and told her if she heard that we were to be murdered, to come immediately to Wexford, as I had thirty guineas sewed up round my waist, and that I wished her to get it, as a reward for her compassionate feeling towards us. Almost choked with tears, she said, ‘ah! my dear mistress, if you had allowed yourself, my master, and the young ladies to be christened, it would not have come to this.’ She was the only person amongst us who felt the relief of tears; she sobbed aloud; and when they brought the cart to the door for my poor dear father, she insisted on being 





---

p.356






allowed to put a feather bed into it—which desire, after some consultation, they complied with. Never shall I forget the sensation, the freezing horror I felt, at seeing one of those fellows take my dear venerable father by the arm, and place him in his own cart. I put my two little girls by him, and, assuming as much cheerfulness as I could, I said,—‘Well, Sir, the poor Pope had not the comfort of a child and grandchildren to travel with him to prison.’[2](javascript:footNote('E790001/note002.html')) I walked by his side till we came near Wexford, when our guard suddenly stopped, and stood for some time together whispering. My terror of a jail was such, I hoped they were consulting about putting us to death, and at once ridding us of all the horrors we had to contend with. One of them at length came forward, and, with the greatest air of importance, said, ‘You have no right, as prisoners, to wear these green boughs; take them out of your hats.’ I forgot to mention that, previous to our leaving Summerseat, they ornamented our heads with green boughs. So, after taking from us this badge of *liberty*, they proceeded with us to the jail. On our arrival there, the person who opened the door said to me, ‘you must not go in.’ ‘Not go in?—not go in with my father!—no one shall prevent me:’ in an instant they put their pikes before me: I implored them not to separate me from my father: one of them gave me a push, and said, ‘there is no room for women.’ I turned round, almost distracted, and seeing a person amongst the crowd who had the appearance of a gentleman, I implored him not to suffer those fellows to prevent my going with my father into the jail, that he was extremely ill, and I had never been separated from him:—‘I would not leave him for worlds—my children too!—do, dear Sir, let me share his fate—let us at least be together.’ He appeared much affected, and said, ‘certainly, Madam, you shall go in;’ and, after taking my poor father and children out of the cart, handed me in, and, with the utmost concern of countenance, lamented the shocking place he was conducting us to. It was a small front room, and so crowded that there was not room even for a chair. I begged permission to get the feather bed that was in the cart; my request was complied with, and just as I had put it into a corner, and laid my poor father on it, a gentleman came up to me, and lamented very much seeing us in such a situation.—This gentleman was priest of our parish: he apologized for never having 





---

p.357



 



waited on Mr. Owen and myself; that he had heard much of both, and again expressed his concern of first seeing us in such a situation. I said, I had hoped my father's great age would have screened him; that he was not a magistrate, nor had he any thing to do with public affairs; that he was extremely ill; and that I feared the heated and crowded room would prove fatal to him. (It was most fortunate the panes of glass were all broken, or we should have been suffocated.) He very kindly said he would do what he could, and at the same time beckoned to the young gentleman who had evinced so much compassion for me. The priest whispered to him for some time and in about an hour returned with a pass from General Keogh, directed to all United-men, desiring they would suffer Mr. Owen and family to return to Summerseat, and to protect his property. We were immediately liberated. My father asked, if any fees were to be paid? and upon being told there were not, he requested the young gentleman who had taken so much trouble, to accept the few guineas he had in his hand, which he politely, but positively, refused. He took care of us to the door, where we found a party of fifty to guard us home. Upon inquiring for our humble vehicle, we learned that Dr. Jacob had ordered it to the camp with flour for the rebel army: this was the second act of *kindness* I had experienced from him. When we were in the jail, he was on horseback, at the window: I called out to him, and, holding a guinea between my fingers, said, Dr. Jacob, my father has not tasted bread since the rebels have had possession, let me entreat you to order me a crown's worth. He turned from me, and, with the utmost *sang froid*, said he was on suffrage himself, and could procure me none. I had been very anxiously inquiring for Mrs. Harvey and family, when two carts with prisoners came towards us, and I discovered Mrs. Harvey, her respectable mother, four daughters, their governess, and the infant son and heir, with his nurse, packed into two common carts, guarded by a strong party of pikemen. After mutual congratulations, I was lamenting to her that I had no conveyance for my poor father, when one of the guard, a young gentleman, got off his pony, which he assured me was very quiet, and said that he would have great pleasure in accommodating so fine an old gentleman.


Mrs. Harvey had a pass similar to ours, and had only been just released from imprisonment. When we got a short way from Wexford we met, I 





---

p.358






am sure, two thousand of those deluded creatures drawn up, ready to march to the battle of Ross. Overcome with heat and fatigue, I sat down on a heap of stones, and seeing a girl run quickly past with something in her apron, it occurred to me it might perhaps be bread. I called to her, and begged she would let me have a crown's worth: she replied, there was not a bit to be had. I lifted up my eyes, and said, ‘oh! would it not be more charitable to put us at once to death than starve us?’ In an instant, one of the rebels broke from the ranks, and threw a large piece of bread and cheese into my lap, and, with the utmost compassion of countenance, begged I would take it. I endeavoured to slip some money into his hand, when he darted from me, with a significant look, seeming frightened lest he had been observed. He rejected the money. I had not time to ask his name, nor have I ever since seen this noble creature. How unlike Dr. Jacob's conduct! by whose activity for the rebel camp we lost a valuable carriage horse, which, a very few months before, cost my father above forty guineas. When we returned home we met our faithful Alley at the lawn gate; her joy was, indeed, unfeigned. She did every thing possible to keep up my spirits; and when I expressed my fears that we should be all starved, she reminded me that we had a good garden, plenty of vegetables and fruit, and abundance of milk, eggs, and some young pigs; and that God Almighty would send me and her master enough, and never let us want. Thanks to his infinite mercy, he never did let us want!


As we passed on to the house, I met a most respectable farmer with a pike in his hand; on asking him the reason, he looked fearfully about, and, finding that our guard had left us, he told me that he was endeavouring to escape, but was seized, and *sworn*; that they had plundered his house and barns, and he feared Mrs. Parkes (his wife) was at that moment without food. ‘It is owing to my infirmity,’ said he ‘my not being sent farther; I am appointed to guard this place, and see that you don't escape: they found me too feeble for any thing else.’ When I parted from Mr. Parkes, I went into a little garden that Hayes had made for dear Susan, in the shrubbery. There I sat embracing and rejecting hope by turns, till I was roused from reflection by a number of persons walking quickly past. I stood on a garden-seat, and saw them reach the hall-door. I instantly followed, trembling at every step; but before I gained the door, I distinctly 





---

p.359






saw them in the drawing-room with lights, passing and repassing. I hurried on, and after entreating my father to remain with the children in the breakfast parlour, I went up stairs. On entering the room I was accosted by a hideous, fierce-looking man, who was half drunk; there were above twenty armed with pikes. At the end of the room stood a gigantic looking figure, with a hat and feathers, a muslin gown richly trimmed with lace, and a cloak of the same, looking over the music books. On approaching nearer I found that this strange-looking person was a man dressed in woman's clothes, no doubt some of the plunder of the day, and most valuable it was, being deep and fashionable Brussels lace. The fellow standing near him had a brace of pistols and a blunderbuss: he took hold of me, and said, ‘I *wants* a book I saw here yesterday—it was a great big one, and the cover will serve me for a saddle.’ I begged, most *quietly*, he would take any thing he wanted; upon which he lifted up a folio edition of the History of London, with fine engravings of the different buildings, which dear Susan had been copying. Recollecting that she had been in the habit of putting her copies with the leaf she drew from, I begged he would allow me to shake the book: and, can you believe it? with some of her drawings there fell on the floor the party song of Croppies lie down. I snatched it up, and put it in my pocket unperceived. Can I ever sufficiently thank my God? I have since heard that an entire family lost their lives by a similar circumstance. One of the rebels found this song on a drawing-room table, and they were all so outrageous, they put the family to death. I believe this is recorded in Sir Richard Musgrave's account of the rebellion. One of the party came up to me, and said, ‘it was I that took your big fiddle, or Jar,[3](javascript:footNote('E790001/note003.html')) as the maid called it: we cannot make music *in it*, but we will come for you soon to play for us; we want music greatly in the camp; but we are going a great way off to-morrow.’ Next day a large party rode up to the door, at a very early hour, and called for me: I sickened almost to fainting, thinking it was this man that had encouraged them to come and take me to the camp. Poor faithful Alley intreated them not to disturb her master, who was asleep; and begged of them to go, but they would not be dissuaded from their purpose, and insisted on having me out. When I 





---

p.360






came, they desired I would get breakfast for them directly. I assured them there was no provision of any kind in the house; that every thing had been taken the night we were at the island. They then said, ‘well, give us the whiskey, till we drink success!’ Upon my producing a bottle of what we had brought from the island with us, one of the men advanced, and desired I would drink some myself; that they had got an order not to take any thing from *us* without our previously tasting it; upon which another advanced, and said, he would take the first glass himself—‘the gentlewoman was above any *such works*.’ It instantly occurred to me, that should this man or any of the party get sick, the rest might come and revenge it on me; I therefore called for a glass of water and put some whiskey in it, took some myself, and made each of the children do so; they were then satisfied, and, after finishing the bottle, rode off. I now began to consider what I could do for my poor father's breakfast; a bit of bread or flour I had not, nor could I get any to buy. I sent to Mrs. Woodcock, to beg she would give me a little of either for him. She told the servant she had none; but begged I would contrive to go over to her. Her house was within two fields of us—I went directly—and, on her seeing me, she, with an air of mystery, beckoned me into her house closet, from a loft over which she pulled down a small bag of flour, telling me, that she had hid all she had in different places; that she did not like to acknowledge, even to my servant, she had any, lest her house might again be searched. Delighted with my prize of a few pounds of flour, I hurried home, and made it into biscuits for my poor father. My children and I breakfasted on potatoes, previous to his breakfast time, fearing he should know to what we were reduced. As to myself, I never knew what hunger was the whole time of the rebellion. I was continually sipping milk and water to cool my lips, which were actually parched: I believe I was in a fever the whole time.


My father's usual habit was, immediately after breakfast, to inquire into the state of the larder. On this day he said, ‘I suppose, my dear, we have nothing for dinner!—What can we have?’ I was shocked, and said I would consult with Alley. She told me she knew of nothing but a roasting pig, if she had any one to kill it. After some difficulty we were able to get Hayes, to whom I told our distress: he was a handy creature, and said that he would kill and prepare it as well as he could for 





---

p.361






cooking. I then thought of the farmer's wife, (a most respectable woman, whose husband I mentioned as being placed to guard the lawn gate;) I sent to request she would come and partake of the pig at four o'clock. She was much delighted, and when dinner was over, returned me thanks for having given her the first quiet meal she had eaten since the commencement of the rebellion. She told me that every thing her husband possessed had been taken by the rebels; that, with a pistol at her breast, they desired her to confess if there were any Orangemen in her house or in the neighbourhood; that what she suffered the night we fled, was not to be described; that the rebels broke in on her every hour, and behaved in the most violent manner. She expressed her fears to me, that her husband would be forced to an expected battle at Ross, and that she did not think he could live to go half the way. Next day Hayes came to me, and, after hesitating some time, begged I would not ask Mrs. Parkes again; that it was talked much of at the Cross,[4](javascript:footNote('E790001/note004.html')) (the rendezvous of the rebels;) that they said we could not forget old times; that we could not live without company; but they would shew *us* we had no *right* to make use of any thing without leave. A few days after, when I wanted him to kill a pig of about eight months old, (a few of which were the only food left us,) he said, it was as much as his life was worth to touch them without leave from the Committee, but he would try and come at night. He did so: and after killing the pig hid it in a cellar, and put loose stones at the door, in hopes they would not examine it. He told me the insurgents intended coming for the cows, but that John prevented them, swearing they should never take or *harm* the cows, that *she* (meaning me) had so often fed his family with; and while he had life he would protect both them and me. I shall ever have reason to love the poor Irish for the many proofs of heart they have shewn during this disturbed season; particularly as they were all persuaded into a belief that they were to possess the different estates of the gentlemen of the country; and that they had only to draw lots for their possessions. One day a large party of rebels rode through the meadow of the lawn; the priest, whom I have before mentioned, was sitting with my father; he went out to expostulate with them for spoiling the meadow, and one of them said, ‘faith, we ought to take care of it, for we don't know to whose *turn* it will come to, to have it for 





---

p.362



. 



himself.’ My father continued very low and ill: I had not a drop of wine, or any proper nourishment for him. Poor Hayes, who saw my distress, mentioned it to one of the rebels, and next evening he came to me with a bottle of excellent claret—never was I more overjoyed. I do believe it saved his life; it was at least a comfort he had not had since our escape to the island. All this time we were very uneasy about my brother and his large family. His living was near **Eniscorthy**, and of course he was in the midst of the rebellion. The first question I used to ask Hayes every night, on his return from the rebel camp, was, ‘have you heard any thing of my brother or Mrs. Owen?’ One night I was obliged to repeat the question, and, on looking at Hayes, I evidently saw his countenance marked with visible concern, and he appeared not to like to answer my question. I felt terrified, and desired he would not keep me in suspense—I guessed all—‘they are murdered, I suppose.’ ‘No, Madam, not so bad; but Mr. Owen has been taken prisoner, at the head of 500 of his parishioners. He was brought into the rebel camp, and from thence marched into the jail of Gorey; and indeed, Madam, I am afraid he is a little *light* in his head.’ At once it flashed across me that the strong sense of his situation, his wife, (who was near being confined,) and that of his eight children, had deprived him of his senses. This so completely overpowered me, I fell against a table, and was for some time insensible. When I recovered a little, all that I had suffered felt light compared to his malady. I charged Hayes to keep this melancholy intelligence a secret from my poor father and children. How often did I thank Heaven that my dear mother had not lived to come to the county of Wexford, where she had planned so much happiness for herself and family.—What blind creatures are we! How often did I wish my dear father laid quietly by her, so much did I dread his being murdered. Oh, how impious it is to despair! But to return to my poor brother. Hayes begged of me not to suffer his master to go out on the road, as they were so exasperated against Mr. Owen for avowing himself an Orangeman, that he heard them talk of coming again to send his master back to jail. I asked where my brother was, and what had become of his family. He assured me he did not know. My fears that he had been put to death were soon relieved: in about an hour after Hayes's information, I received an open note written in his hand, but in such an agitated manner I could scarcely 





---

p.363






read it; it ran thus—‘My dear Jenny, I never was merrier or happier in my life—Nancy, the children and money are gone off I know not where—come and see me—bring me some vegetables and cucumbers—Wexford Jail.’ It was eight in the evening when I received this note. I called for Hayes, to consult about what was to be done; he was gone to the camp; it was too late to think of going that night, but I determined on going early next morning. How to frame an excuse for my absence to my poor father I knew not; and to tell him I dared not venture; indeed my fears were, that I should be seized on, and put into jail, with this intended victim, of their ferocity. It is impossible to give an idea of the ills I foreboded for my poor father, myself, and children, but all was overcome by the hope of saving my brother; and humbly trusting in the protection of Heaven I was on the point of setting out, when Hayes returned from the camp. I told him where I was going: he started, and said, ‘I beg, Madam, you'll not be so mad—it is but five o'clock—the roads are crowded with the rebels relieving guard, and if they found out you were taking part with Mr. Owen you will bring troubles on yourself and my master; and, madam, if you won't be too much troubled at hearing it, he is quite out of his senses: it was that that saved his life, for he was dancing through the streets of Wexford, singing out that he was an Orangeman, and feared no one.—They were taking him to jail, and indeed he was every way in a bad condition; I would have put my own coat and hat on him but for fear of my life, for there were above two hundred guarding him.’ Instead of poor Hayes's zeal for me awakening my fears, it more strongly determined me to risk every thing to get my brother to Summerseat, and I told him nothing could dissuade me from my purpose. He again entreated me not to go, as Mr. Owen was to be tried by the Committee at twelve o'clock. This only added wings to my impatience; I lost not a moment, and thought every pebble impeded my speed. My dearest Susan cried so violently at my leaving her I turned back and brought her with me; my poor Letitia (who, you know, is nine years older) I left to take care of my father, and I own when I kissed her at the door I thought it was for the last time. When I got to Wexford (a distance of three miles, which I was obliged to walk, having neither coachman or horses left me) I knew not to whom I could apply to get me into the jail. The streets exhibited the most frightful appearance—the 





---

p.364






church was shut up, though it was Sunday—a ragged little boy beat the large drum belonging to the unfortunate North Cork Militia—thousands of pikemen marched in the middle of the street—not a female was in it but myself and child. Terrified at this, I involuntarily stopped and stood motionless, till I observed myself the object of universal attention, and heard one of them say, ‘She is a spy!’—‘Who the devil is she?’ a third said, ‘she would make a good wife for the camp.’ Had I seen one amongst the hundreds who passed me, that had the slightest appearance of a gentleman, I would have implored his protection for myself and child; but they were all drunken ill-looking fellows. In this distress I saw with joy, at the opposite side of the street, our friendly priest who had got us liberated from jail; I called to him to cross over to me, being afraid to break through the multitude that were marching; but, to my utter amazement, he turned from me, though he evidently saw me, and walked faster than the rebels marched, to avoid me. In this dilemma it occurred to me, if I walked up and down before the jail I possibly might see my brother, as the room we had been put into looked towards the street; I soon found this impossible, the crowds of pikemen passing and repassing prevented my getting near; and they looked so horridly at me, and pushed me about so savagely, I was afraid to speak, or make any inquiry. Seeing the impossibility of effecting my purpose, I returned to Summerseat.


At home I found my poor father very ill and unable to get up. Such were the scenes that pressed on my imagination, I should have rejoiced at seeing him sinking into a quiet *natural* death. I told him the confusion I had found Wexford in prevented my seeing my brother, but that I hoped to be more fortunate to-morrow. He violently opposed my going again. I told Alley of my disappointment about the priest, and desired her to prevail on him to come to me, as I wanted to speak with him. When she returned from his house, I saw that she wished to say something she hesitated about; I begged she would speak openly to me, and asked, would the priest come to me? ‘Yes, madam, but don't be angry.’ I assured her I believed her perfectly in my interest, and could not be angry with any thing so faithful a creature might say. ‘Well, Madam—if you would allow Father O'Connor to christen my master, the young ladies, and yourself, it might be the saving of you all.’ I quickly answered, he may do any thing if he will 





---

p.365






assist me in getting my brother out of jail. The priest promised to meet me at a Mrs. Moore's, in Wexford, an old lady of my acquaintance, who had been overlooked in the hurry, and, I believe, was the only person not visited by the rebels. Delighted at the accomplishment of my wishes, I again set out without having closed my eyes, or lain on a bed since the night before; but I felt as if nothing had power to tire me; I could not eat a bit, and my thirst was not to be satisfied. When I had reached the distance of half a mile, I heard some one running violently after me; on stealing a look round, I perceived it was Alley, who had followed me with a message from the priest, to request, should I see him in the street, not to appear to know him—that he found he was most unwillingly obliged to retract his promise, as it would ruin him in the eyes of *the people*. This frightened me so much, I questioned myself, was it not temerity to proceed? but I soon rejected the idea, and trusting in that Almighty Power that had hitherto spared me, I told Alley nothing should deter me, were I only to gratify my poor brother by seeing him! But I own I was not without my fears that it was rashly exposing myself to the fury of a mob, and perhaps the unfortunate object of my anxiety to their greater vengeance, by my interference. I felt, however, a something in me that impelled me forward, in spite of all the dangers that fancy had conjured up.


When I got to Wexford, I was as much at a loss as ever to whom to apply for admittance to the jail. I saw a great crowd of rebels running in confusion, and saying, ‘make haste to parade, General Keogh is gone.’ It immediately occurred to me to follow at a distance, and that this general might be of a superior order to those common, ill-dressed men, who passed in such numbers I thought they would never cease. At length they all got into an immense field, where General Keogh paraded them for above an hour; during which time I stood at a distance, under the most parching sun I ever felt; yet my blood ran cold when I saw their numerous pikes, and understood their murderous purpose. When the parade broke up, I took the opportunity of addressing General Keogh. He was dressed in full uniform, green and gold, with a cocked hat trimmed with gold lace; he strove to avoid me, but I courageously called to him to stop for one moment. I told him in as few words as possible the situation of my brother, and presented him a letter, which he refused to take. He added, 





---

p.366






that he knew it well and lamented it; but that he had no longer the charge of the prisoners—that department had been taken from him, and Mr. Kearney had the care of them at present (this General Keogh had been a captain in the King's army for years.[5](javascript:footNote('E790001/note005.html'))) I then made inquiries about Mr. Kearney's residence, and was not long in search of him; in him I met with a man of great humanity, though a rank rebel. He was much affected at my account of my brother's situation. When I told him he was married and had eight children solely depending on him, he turned to a cradle in the room where he sat, in which there was a beautiful infant asleep, and said, ‘Innocent creature! you are happily ignorant of the state your father is in and the scene around you.’ (I believe at this time they were fearful of not succeeding.) He turned to me with tears rolling down his face, and said, ‘My wife was obliged to fly in the revolution from France, it will be hard if the same fate attends her here.’ I scarcely listened to him, I was so impatient to see my brother; but he went on talking, and said, ‘I suppose you know the park near Dublin, it is full of *our* encampments; *we* suffer no provisions into the city, *our* army possessing themselves of every thing that comes near it; they have the canals, and have stopped the entrance of the shipping.’ This unexpected intelligence was a new source of wretchedness—if my dear friends in Dublin were in such danger, I cared little for my own safety, though I hoped the account was exaggerated. I endeavoured to interest him about my brother, and promised most solemnly if he could get him out of prison, even for a few days. I would myself watch him, and be answerable with *my life* that he should be forthcoming when sent for. I begged he would allow me to see him, with which he complied, and walked with me to the jail; he desired me to go to the front window and he would have him brought there, which was all he could do; but advised me to come next day and he would try to interest the Committee in his favour. He said he would himself give him the vegetables and cold meat I had brought in a napkin: he then took his leave, and I with difficulty made my way to the window; the panes of glass were fortunately all broken, as when I was in that abode of wretchedness; this enabled me to look in. I soon saw some person coming towards me held by two men, from whom he was 





---

p.367






endeavouring to force forward. Shall I ever forget the sight that then presented itself! My brother almost flew when he saw me, stretched out his burning hand through the bars, and strove to force out his head to kiss dear Susan. He had on him an old flannel waistcoat, neither shoes nor stockings; his beard an inch long; his hair cut close to his head, one side of which was bleeding, where the rebels had put a pitch plaster, which he had torn off. I was obliged to hold the bars of the window to prevent my falling. I reached him a leaf of cherries and a cucumber, which he devoured.—‘Don't be afraid, Jenny! I have sent an express to Lord Castlereagh, and to the Bishop of Ferns, and I shall desire one of them to buy a harp for dear Susan. How is my friend Jemmy Boyd?’ (Mr. Boyd was an active magistrate, and had a corps, with which he was obliged to fly the day the rebels entered Wexford.) The moment they heard my brother inquire for Mr. Boyd, I had twenty pikes raised over my head, I believe with the intention to put me to death; but one less savage than the rest restrained them. I assured them most solemnly I was not acquainted with Mr. Boyd, nor had I seen him since I came to Summerseat. My brother, not knowing what they were saying, called aloud to me, ‘Jenny, Jenny, my dear, have you seen my friend Haydon?’[6](javascript:footNote('E790001/note006.html')) He started back and repeated ‘Haydon, Haydon,’—his face became quite convulsed, and when he could utter, he said, ‘excellent man! these villains have murdered him.’ Then clasping his hands together, he looked up and said, ‘Oh my God, the dead bodies of thy servants have they given to the fowls of the air, and the flesh of thy saints to the beasts of the land! Oh let the vengeance of thy servants' blood that is shed be openly shewed upon the heathen in thy sight—Oh let the sorrowful sighing of the prisoners come before thee!’ He was agitated beyond description—he said he must go and read prayers for the poor people up stairs. I could bear his madness no longer; I endeavoured to restrain my feelings before him, but finding it no longer possible, I walked from the window and went into the first house I found open; there I burst into the most frightful fit of screaming, which I had not power to restrain, and it so agitated me I was wholly deprived of 





---

p.368






the use of my limbs for above an hour. When I could look round, I found I was in a common ale-house, four women were sitting in a corner of the room at breakfast, all this time unmoved, though my darling Susan repeatedly begged of them to give her mamma a glass of water; but to the disgrace of our sex, she called in vain, till two men came into the house and rendered me every assistance in their power, and scolded *Judy* for not asking the lady to take a cup of tea. I continued so long ill, I dreaded being obliged to remain in this house, but in about an hour the numbness of my limbs abated, and I crept as far as Mrs. Moore's, where I got some hartshorn and water, which relieved me so much that I was soon able to walk about the room; and at length a violent flood of tears tended more to my recovery than medicine could. I told her my poor brother's melancholy state, and she kindly promised to send him breakfast every morning. When able, I returned to Mr. Kearney, who politely assured me he would himself take my brother his breakfast. Disappointed at the little I had effected, compared to the risks I had run, I again reluctantly turned my steps towards home. It was by this time six in the evening, and I was wretched at the uneasiness I knew my father and Letitia would suffer at my long stay. Overcome with fatigue I sat down about a mile from town, on a small bridge, over, a rivulet, distracted at the idea of our situation. I had not been long there, when I saw a party of pikemen coming towards me. I started up, and my first idea was to hide my darling child under the arch; but they came too quickly to enable me to do any thing but stand at their mercy. They saw terror in my countenance, and humanely, and in a gentle voice, called to me ‘not to fear.’ One of the men knew me, though I had not the most remote knowledge of him. They all advised me not to venture so far from home lest I might meet strangers. I trembled so violently I could scarcely walk, and was obliged to take an arm of one of the men to enable me to proceed, which the man perceiving, desired me to be of good heart, he would take care of me; ‘no one shall harm you, madam. If you wish we will try to sleep about at Summerseat.’ There was an honesty of manner in those poor deluded creatures that precluded a possibility of doubting the sincerity of their intentions; I thanked them, and gratefully accepted a service offered with such humane warmth. They left me safe at home, and promised to return at night. How to tell 





---

p.369






night. How to tell my father the melancholy state I left my brother in I knew not; nor could I bring myself to tell him the complete bondage we were in. How often did I thank God that the Bishop of Ferns refused to ordain Charles!—he had been promised the curacy of Ross, but the Bishop objected to his not being the proper age for ordination. The curate of that place had been put to death at the commencement of the rebellion, and though the insurgents kept us as much as they could in the dark about their proceedings, it was plain they wished to annihilate all the protestant clergy. They continued to treat me with great kindness. Many of them, to whom I was a stranger, used to send in for me, and after looking mysteriously about, would lay a bottle of wine and some bread down by me, and say, ‘I know you'll be glad of that for Mr. Owen.’ But how inconsistent! the same persons were quite abusive to my faithful Alley for smoothing some muslin handkerchiefs of mine, and asked her did she still think herself my servant? that she ought to make me change places with her,—she had the *right* to command me. This shewed how impressed they were with the idea that they were really to *change places*, as they said, and all to become gentlemen. My excellent Alley burst into tears, and said she would die before she would *command* me. At night the men who had escorted me home were true to their promise; four of them came to sleep at Summerseat, and I felt such confidence in their protection that, for the first time since the rebellion, I went into bed, where I slept most soundly till four o'clock in the morning; when I was awoke by the galloping of horses up the avenue, which was succeeded by a violent knocking at the hall door. I was terrified lest it should be some more dreadful account of my brother. I flew down stairs, and impatiently asked what was the matter, entreating them not to awaken my father with their noise. They swore violently and called for the men who were in the house—saying, they should be punished, and sent to Vinegar Hill, for leaving their posts.


As soon as I was a little recovered from this scene of terror and confusion, I prepared for my third walk to Wexford. Alley offered to walk there with me, and said she never was afraid to let me go before. I forgot to mention that, when the priest called on me, I told him that Alley had expressed the greatest anxiety that we should all be christened by him; he answered, ‘Madam, that is between you and your God; I should be sorry to influence





---

p.370






any one, though many have come to me for that purpose.’ I said I was sure he would have but a bad opinion of any one who could so suddenly, and through fear, change their religion. I gave him great credit for his answer to me. I was, however, afraid to take my faithful servant, as I should have been miserable about my father and Letitia, without her protection, and at six o'clock in the morning again set out with my dear little companion Susan to brave all danger: the hope of getting my brother to Summerseat, and this interesting creature's sensible conversation, cheered me till I arrived at Mr. Kearney's house. What was my disappointment, when Mr. Kearney told me he could give me no answer till the next day! But when this humane man saw my extreme agitation, he kindly said he would go out for a little and see to a *certainty* what I had to depend on. I sat in fearful expectation for more than an hour, when he returned with a positive assurance that to-morrow my brother should be sent to Summerseat, but under a strong guard, and that I must be answerable with my life for his safe keeping—desired I would not let him out of my sight, and that I must pledge my solemn assurance I would give him up if sent for by the Committee—that a few days was the extent of the leave he had been able to procure for him. I was too happy to get my brother even for that short time, not to promise every thing required of me. His mind was so very much disturbed, I dreaded his not quietly submitting to a guard over him, and, when a great distance from the town, returned to request Mr. Kearney would allow our coachman to be one of the party; this he kindly promised, and it proved a great comfort to my brother, as he kept him in conversation about us. The moment I could get from home I set out to meet him; but though previously to his coming, I had him shaved and sent him a suit of my father's clothes, I had forgot a hat; and when I met him he looked such an object, I dreaded my father's seeing him. The clothes, much too large and long, were hanging on him; his head still bleeding and exposed to the sun, appeared a tacit reproach to my forgetfulness. Nor would he allow me to tie my veil round his head. He walked so fast, the guard told me it was with difficulty they could keep up with him. We met my dear father at the gate impatiently looking out for us. You may judge what a sight to him, and how much he was shocked, when in a moment my brother's conversation betrayed the state of his mind. He talked incoherently, and took off his 





---

p.371






coat before the guard, to shew the wounds those rascals (as he called them) had given him with their blunt pikes. My father, conceiving it was the men who were with him, turned on them with violence; and, forgetting his age and weakness, would have knocked the man down who was nearest to him, when he perceived his old coachman, and was satisfied. I told him I had got Matthew by special favour; and he was to be one of the guard to remain at Summerseat.


Matthew gave me a pass which he had received to protect him, and I inclose it to you, as it may be considered curious hereafter:— 




> 
> Let Rev. Mr. Owen pass to Summerseat, & remain there a prisoner.— *June* 19, 1798. 
>   
> Will. Kearney
>   
>  
> 
> On the back it was directed, ‘To all United Men.’
> 
> 
> 




He could give no account of Mrs. Owen or his children; but that they had got off, he knew not where. While we were sitting at dinner, I was called out of the room, and on looking towards the yard, I saw a large party of pikemen, and Alley, almost in a state of distraction, talking to them. I went into the yard and asked the occasion of it. ‘Oh my dear mistress! I knew what trouble you would bring on yourself and my master: my mother has just told me they say, unless you give up Mr. Owen to them, the house will be burned this night.’ All this time the rebels were consulting at the coach-house door. I implored her to be calm—she was in fits of tears and quite hysterical—I went over to the men—they called out, ‘Produce Mr. Owen, or we will tear the house down.’ I endeavoured to excite their compassion by assuring them he was quite out of his senses; that if he was with me a few days it would calm him, and he would be the better able to stand his trial; they said, he had owned himself an Orangeman, and have him they would. I then took Mr. Kearney's pass out of my pocket, and read it to them; after which I said, (with a resolution I am at this moment amazed at,) ‘*At your peril* lay a finger on him!’ never can I forget their look of astonishment; while, as if with one consent, they marched out of the yard, muttering, ‘this night the house shall be burned.’ On my return to the dining parlour, I found my father and brother in such deep conversation that they had not missed me. Again Alley made her appearance at the door. She told me the men who left the yard had met her mother and told her to send for 





---

p.372






her daughter, for that this night Summerseat House should be burned, as I would not give up the Orangeman in it. She implored me not to sacrifice her master and the young ladies; but when she found I was determined, she desired the people who were bringing down her trunk to take it to her mother, and tell her she had not the heart to leave me. I did all in my power to make her go, but it was to no purpose.


I found it very difficult to keep my brother quiet—he was incessantly talking—told me he never loved Nancy so well as when she dressed the boys in orange ribbons, and sent them to fight those villains; but he did not know where they now were. He also said, the first bed he had lain on was the one I had left for him in jail, and which that good man, Mr. Kearney, had settled for him on the floor. He repeatedly said, I know nothing of the boys, but I sent them to their mother. (The eldest of them was not thirteen.) We could not depend on any thing he said; but he recollected that Mrs. Harvey, his sister-in-law, and Mrs. Cliffe, his wife's mother, lived at Killeen Castle, within a few fields of us, and he insisted on going to see them. In vain I told him I was under a solemn promise not to let him leave the house; but he burst from me, reproaching me for my cowardice, and said he would go. I was obliged to send Matthew and another of the guard after him, who with difficulty overtook and brought him back. I then got Matthew to go and tell Mrs. Harvey and Mrs. Cliffe what had happened, and request they would try and venture to see him. They did come with difficulty. Never was any thing more affecting than Mrs. Cliffe's inquiries about her daughter and grandchildren, to which my brother returned but incoherent answers. They soon left us, and I then tried to prevail on him to go to bed; he did not appear in the least fatigued, and it was near one before I could get him to consent. The guard insisted on staying in the room. He soon fell into a disturbed sleep, quoting different lines from *Shakespeare*, one or two of which I recollect—*Come, let's away to prison,’’*

**William Shakespeare** King Lear. Act 5 Scene 3

—*This tempest would not give me leave to ponder.’’*

**William Shakespeare** King Lear. Act 3 Scene 4

—*Take physic, pomp, &c.’’*

**William Shakespeare** King Lear. Act 3 Scene 4

 In this manner he went on till morning; but though his sleep was much disturbed, I had the comfort to see him more composed next day. Every moment that I could venture to leave his room, I employed myself in carefully examining the outside of the house and out-offices, to see if the rebels had left any combustible matter about, to put their threats in execution. 





---

p.373






I was standing talking to my brother at his bed-side, endeavouring to prevail on him not to get up, when I saw a large party gallop towards the house; I closed the shutters, and said I would get his breakfast. By the time I had reached the hall door, they were about to dismount, when I requested them not to come into the house, as my brother was asleep. This party were chiefly composed of gentlemen; one of whom said, that two only should alight, but that they *must* search the house for Mr. Boyd. I assured them in the most solemn manner, that Mr. Boyd had not been inside the doors of Summerseat since we came there. They politely bowed and ordered the party to turn round as quietly as they could. They then went to Killeen castle; and Mrs. Harvey has since told me they searched every wardrobe, and even an empty hogshead; but this may be accounted for, as Mr. Boyd was married to a near relation of Mrs. Harvey. When my brother had breakfasted, he insisted on going to Killeen castle—he said he must dine and spend the day there. I remonstrated at the imprudence of his going, and caught hold of his arm, which he wrested from me and leapt over the fence. I was obliged to send the guard after him, who soon brought him back; but he was extremely angry at my silliness, as he called it. Poor fellow! he little knew the risk I ran, and the danger we were all exposed to, at having an avowed Orangeman and a Protestant clergyman in the house; nothing could have saved him but the insane state they all saw him in.


We were under great uneasiness about our faithful Hayes, who had been four days absent, and we were afraid he had been killed. At ten o'clock at night there came into the house two horrid looking fellows; they told me they were come for Mr. Owen—he must go to jail. Whilst I was remonstrating with them, several rushed in and called the guard that had charge of my brother; I entreated them to leave Matthew with me, but the men who came for them said, ‘we are all too little—the roads must be doubly guarded.’ Had I understood from this, want of men, it would have given me some comfort; I have since heard they had received intelligence that the King's army were marching towards the town. My brother providentially escaped for that night—they were in too great a hurry to call for him again.


The next day they brought a written order for him, which I could not dispute; but I detained them as long as I could, much against his will. 





---

p.374






He had no fear, and vowed he would go with them. Mr. Kearney sent me an assurance that nothing should happen to him. To this delay, under the providence of God, does he owe his life; whilst he was on the road, a party went to the jail to put the prisoners to death. Mr. Owen, the protestant clergyman, was the first they called for; not finding him, they took out seventy-five prisoners, and were taking them to the bridge of Wexford, in the opposite direction to the road my brother travelled, when Mr. Kearney (and may God for ever bless him for it!) went to meet him, and desired the guard to follow the crowd, and he would take care of their prisoner: they eagerly ran off. Can I ever cease to be thankful to God! had my brother been ten minutes sooner, nothing could have saved him; he must have shared the fate of those unfortunate victims, the murder of whom must ever disgrace this country. The rebels went on murdering their prisoners with the most barbarous ferocity, till a priest (whose name I forget) on his knees implored them to desist, ‘that surely they had blood enough for that night.’ A Mr. Cox, after receiving the most dreadful pike wounds, made a strong effort to save himself by leaping over the bridge, when they fired at him till he sunk. At this time we were most fortunately ignorant of all that was passing at Wexford, but I determined on going there next day, to try and bring my brother back.


About nine o'clock that night I found the servants in the greatest consternation, messages coming to the house every moment. As soon as it was daylight, I saw a large ship outside the harbour, and rebels riding with great fury back and forward towards the coast. We began to hope this vessel had brought troops to our assistance; but the rebels gave out it was their friends, the French, who were coming to join them. They knew nothing to a certainty till a boat was sent out. I kept watching at the drawing-room window, and plainly saw firing from the vessel, and at last the boat was brought to its side. This was a boat the rebels had sent out to their *friends*, the French! but they were soon made prisoners, and this confirmed our hopes that there were troops on board; but even this hope was accompanied with fear; the shores and hills were crowded with pikemen, that we dreaded a small body of our troops landing amidst such a ferocious multitude.


I was preparing to go to Wexford when our faithful Hayes made his appearance, 





---

p.375






after an absence of some days. He looked miserably, and was scarcely able to walk. Susan flew to him and leapt into his arms, kissed him, and burst into tears. He was scarcely able to hold her. Poor fellow! he was greatly attached to her, and the day before he went away he seemed very melancholy; she asked him what ailed him, and if the rebels had ordered him to kill her. He started up, and took hold of the sword that was lying by him and broke it to pieces, swearing that he would never lift his arm but in his own defence, and turning towards her, said, ‘Kill you, my dear child! God forbid I should live to see the day that any one would attempt it—if they did it should be through my heart, while it is in me to protect you.’


This honest creature had, I suppose, heard of the intention of putting all the Protestants to death, and was fearful that he might have been ordered to be one of the executioners. You cannot wonder at this angelic child's delight at poor Hayes's return; indeed we were all happy to see him, and anxious to get him what refreshment we could—his clothes were almost torn to pieces—he shewed us his hat perforated with balls while he was lying concealed in a ditch; he told us that the man who lay near him was shot dead—that never was such a fight—the dead were lying in heaps, and he thought there could not be less than ten miles of the road covered with the King's troops. He was so overpowered with gratitude at our anxiety about him, he said it made amends for all he had suffered. What joyful news had he brought us! but my suspense about my brother made me fearful of indulging hope. Hayes concluded his history by saying, ‘What could we expect, madam! the generals (that is, the priests who are generals) desired us not to fear, for as fast as the red hot balls were fired, *they* would catch them in their hands and they would not allow them to injure us. There were many who believed it; but I am sure I saw hundreds drop as fast as the balls were fired from the cannon.’ Though this account was dreadful, yet it gave us an assurance that the army were coming to our relief; my terror however lest the jail should be set fire to, determined me on going to Wexford; but just as I was ready to set out, our friendly priest rode up to the house in great agitation, saying, ‘the King's troops have taken possession of Wexford without firing a shot.’ I instantly asked, was the jail safe? he looked shocked at the question— 





---

p.376






‘Pray, for God's sake tell me, do you know any thing of my brother?’ He said, ‘I hope he's safe; but there were dreadful doings on the bridge last night.’ I ran out of the room, calling for Hayes to follow me; when I reached the hall I heard a horse furiously galloping to the door, and in a moment my dear brother had his arms about me. He was so much agitated, and indeed we were all in such a state of joy and gratitude to Heaven for our deliverance, that we were some time incapable of doing anything but repeating ‘Good God be praised!’ Never can I forget the sensations of that moment! In a little time we saw the rebels flying in all directions; at night one of them came to me with his wife and six children, and implored me to give them protection—that he must fly—that his cabin would be burned, and that his wife brought her blankets with her. He was in such distraction I assured him I would take care of them if they could sleep in the coach-house—‘any place, madam, withinside your walls.’ I ordered potatoes and milk for the children (the only food in my possession); the poor fellow was quite overcome; I desired him to stay, but he would not venture, and the poor woman prepared her straw bed with such confidence in me as produced a most pleasurable feeling. Removed so suddenly from the terrors of my own situation, I could scarcely believe it was in my power to give protection to any one. When I left her and turned into the yard, I found it crowded with men, women, and children, who implored me to give them shelter. They were in a state of distraction, being sure they were all to be put to death. I did every thing in my power to quiet them, and assured them I would write to the commanding officer in the morning, and that meantime I would have cards nailed on all the cabins within reach of me, to certify their good conduct to my family, and refer them to Summerseat for a further account of those who had behaved well. This appeased the poor deluded creatures, who were most of them forced into this dreadful business. As night approached, all the offices and yard became crowded with rebels, entreating me to allow them to remain till morning. They besought me to let them lie in the walks of the garden, such as could not find room, any where else. Next day, when the proclamation was issued for their pardon on returning to their allegiance, they thought it was only to seduce them into the town to be shot. Many gave up their pikes and arms to my father. Two days after the army had 





---

p.377



 



come to our relief, a young priest requested to speak to me—he was disguised in the dress of a peasant. After entreating secrecy, he told me who he was, and begged I would give him leave to administer the sacrament to a young man to whom I had given protection—that he was in a desperate state with a ball in his arm that all who were found wounded were shot without trial, and that soldiers had been sent through the country to search for them. In vain I endeavoured to convince him that the King's free pardon would be given to all those who would give up their arms, and return to their allegiance.


This poor young man was in so much pain, that I had placed him in one of the spare rooms. I brought the priest, and they remained together more than an hour. When the priest had concluded his duties, I went to the young man and entreated him to let me send for Dr. Johnston, who would extract the ball, and that he would get well directly; but, great as the agony he suffered was, I could not prevail on him, so strong was his impression that he would be shot if discovered. Whilst I was endeavouring to give him confidence in the King's proclamation, a person desired to speak to me whom I found to be this lad's mother. I desired her to be shewn up, and really dreaded the scene that I thought must have ensued; but she strutted into the room with an air of effrontery that astonished me, and turning to him with more command than tenderness said, ‘what signifies your arm, if you suffer death it is in the *good cause*—your Saviour suffered for you.’ I was shocked at her countenance, but assured her he was in no danger, except from his wound, and urged her to let me send for Doctor Johnston, which she refused very bluntly, and desired her son to take her arm and come home, that ‘all was not over with *them* yet.’ This horrid woman frightened me so much that I most gladly saw her departure, and pitied extremely the poor young man, whom I offered to keep till he was better. When I found we could again *take the liberty* of asking any one to dine, I wrote to our friendly priest, and told him how happy my father and I would be to have his company at dinner, and that he should have a bed. He wrote to thank us, but was afraid to venture out of his house, not having a protection, and that he would be extremely obliged to me if I could procure him one. I wrote in my father's name to the commanding officer, stating the humane conduct of the priest, and was delighted at immediately





---

p.378






getting a protection, which I sent him. He lost no time in coming—he told me he had no fear of the gentlemen of the country, but owned he had not the same confidence in the soldiery.


After dinner my dearest Susan and I sang the Sicilian Hymn to the Virgin, which he said had more power to compose him than he could have imagined. We repeated it twice for him, and you may judge my joy and *thanks* at being able once more to sing with this beloved child. It is impossible to describe this angelic creature's feeling—if her lot be not fortunate it will be a short life to her; she is all soul and heart, and though in the time of our greatest fear, she made every lively effort to keep up my spirits, she was evidently overwhelmed with our great change of situation, and her spirits appeared no longer what they had been while endeavouring to support mine: indeed, both my dear children were a treasure to me, though I trembled for them, and often wished them any where but here. Next morning I received a letter from the Mayor; which, on opening, I found enclosed one from my son Charles!—it was dated from Ross. He expressed his joy, his gratitude to Heaven, in the most lively terms, to find that we had escaped. He had but just heard of our safety: although he had been within nine miles of our house a few nights before—his mind tortured with suspense about us—yet he dared not visit us.


I knew not whether to rejoice or lament at this intelligence; for though in apparent safety, yet reports were such as continually to keep alive our fears. With Charles's letter my father received an order from the High Sheriff to have all the pike handles in his possession cut into pieces of a foot long, before an hour. This made me very unhappy about Charles; I fancied him in the field of battle against his countrymen—what a dreadful idea! I did hope he had been in Jersey; but his regiment was ordered over in consequence of the state of Ireland. This was an additional weight upon my mind. The order from the Sheriff made me fear we were not so secure as we at first hoped: and the speech which the woman made when I was trying to give her comfort about her son, nearly confirmed me in this opinion.


So soon as I could venture to send a messenger on the road, I sent most anxiously to inquire after Mrs. Bevan, whose husband had been exerting himself amongst the peasantry and his parishioners previous to the rebellion





---

p.379



 



breaking out, endeavouring to convince them of the madness of their conduct in not going into Wexford, as prescribed by the High Sheriff; we heard he had made his escape to Wales. Mrs. Bevan gladly accepted my invitation, and brought her children; her eldest boy, about eight years old, affected me greatly by asking whenever he found me disengaged, where his papa was; and was I sure the rebels had not killed him? Poor Mrs. Bevan's eyes filled with tears whenever she looked at the children; she began to despair of ever seeing their father again, as I had a letter from Wales, and his name was not mentioned in it. The day after she came to us, Mr. Harvey and Mr. Colclough were taken on an island called the Saltees. She received a letter from Mr. Colclough, requesting she would come immediately to Wexford, to give evidence for him. She complied with his desire, though she had nothing to communicate that could serve him. He and Mr. Harvey were condemned, and hanged next day—they were both men of fortune.


On her return to me, she endeavoured to describe the horrid scene she had been witness to in the court-house, but so great was her agitation I could scarcely understand her. There she had seen three of her most intimate friends, without a hope of escaping an ignominious death! She was in an agony of tears when I brought her into the lawn for a little air; we were not there three minutes before she screamed out, ‘Here's Bevan! Here's Bevan!’ We saw him almost flying towards us with two of his children in his arms, the other two clinging by the skirt of his coat. The mixture of happiness and gratitude to God his features expressed, I can never forget; the little boy's eyes were fixed on his as if afraid of losing him again did they turn on any other object. Poor Mrs. Bevan could only sob out, ‘Bevan! Bevan! where have you been—how did you escape!’ I shook him heartily by the hand and turned from them—I thought such a meeting should be sacred. I partook silently of their happiness. His account was, that on Wednesday morning (the day the rebels took possession of Wexford) he intended, as usual, to ride about his parish and harrangue the peasantry, though they appeared so sulky he despaired of doing any good. Upon riding to his own forge, he saw the smith openly at work making pikes, and a heap of them piled up in a corner of the forge. He galloped off to Wexford to give information, when to his utter astonishment he found the town evacuated by the loyalists, and every one who 





---

p.380






could, endeavouring to get on board ship. To return through the country alone, would have been certain death—rebels in all directions; he was therefore obliged to choose the heart-breaking alternative of leaving his wife and children in a remote part of the county, where his house was, or brave a danger which must have been fatal; the clergymen being objects of the greatest hatred to the rebels.


The Sunday after his return, he read prayers in our drawing-room; we collected all the protestants living near us, and never did I observe a set of people pray with more real devotion or gratitude; but though there were strong encampments of the King's army all round us, I found amongst the peasantry murmuring at a protestant clergyman again performing his duty.


They did not speak out, but I saw discontent and disappointment very visible; and I believe many were far from thinking that the day (to use their own language) would not yet be their own; some of them openly said so, with the King's pardon in their pocket.


The Sunday following we once more ventured to Mr. Bevan's Church, which is quite in a remote corner of the barony, but not I own without fear and trembling, though he refused accepting a guard of soldiers—his confidence was too strong in that divine power who had so miraculously restored him to his family, and preserved them in the midst of such peril. Poor Mrs. Bevan had suffered a vast deal; but we were too happy to allow ourselves to dwell on the past. I got very unhappy about Charles, as we had constant accounts of marauding parties doing much mischief in the country, which was by no means quiet, though at first I thought all danger was over when our army took possession. After we returned from Church, Mr. Bevan called me out of the room and desired me not to be alarmed, he would shew me a person I was not a little anxious about. I was so much agitated, notwithstanding his precaution, that I was really near falling on the stairs. He assured me nothing was the matter, but that Charles was in the stable, afraid to come in suddenly. Think of my joy at seeing this dear fellow, after all the dangers he had been in, and my misery about him. He was completely accoutred—a brace of pistols in his bosom, two in his belt, and two in his holsters, with abroad sword at his side. He rode from Kilkenny at great risk, but his impatience was not longer to be restrained. Sir Charles Asgill did not like giving him leave, but kindly told 





---

p.381






him he would expect to see him in three days on parade. He had a journey of more than a hundred miles to perform. At night, when all the family were in bed but myself and him, I could not resist the desire I felt of shewing him to my poor rebel friends whom I had concealed; I made above twenty of them come in when he was sitting after supper. He poured out a large glass of whiskey and water, and reaching out his hand to them, said, ‘Well my lads, won't you drink the King's health?’ and almost in one voice they answered, ‘yes faith, and your's too:’ then, looking at his uniform, sneered and said, ‘our *liberty* uniform is handsome, but 'tis not so grand a dress as that—but we could fight in our own *ould* clothes for all that!’ Charles knew several of them whom he recollected having seen on Lacken Hill a few nights before, and they remembered him. How were matters changed; a week before I should have trembled to see him amidst so many rebels.


He remained with us but two days, and when he was gone I felt very differently at Summerseat; the reports which continually reached us, kept us in a constant state of alarm; and when the post failed coming in (which was frequently the case) we fancied the worst, and thought all our miseries were to be renewed. I was most anxious to get to Dublin; but it was impossible to travel in safety. I proposed to my father to go by sea; which, after resisting my entreaties for a fortnight, he consented to. Every person who could get room in the wretched traders to Dublin and elsewhere, were hurrying off. We took our passage in one, and were content to remain on deck, there not being any accommodation for passengers. I had a bed placed in the best way I could for my father; and when I looked at him and my dear children, and knew we were on our way to Dublin, I felt happiness I never expected;—but it was soon clouded—the pilot was drunk; he struck us on the bar of Wexford harbour, and it was impossible we could get over till the next tide. We had three officers of the Queen's Regiment, and some passengers on board. The officers proposed to them to go to Wexford till the tide came about—they also proposed it to me, but I was afraid to say a word to my father, lest if he once went on shore I should not be able to get him back, and that the disappointment might determine him to run all risks and go by land—I therefore remained on board.


Soon as the boat was out of sight, and we were left with only the 





---

p.382






soldiers and people belonging to the ship, the pilot came on deck, and in the most insolent manner asked if I was one of the passengers. He swore at me and said he would make me sorry for not giving him a crown when I came on board; and that he had struck the vessel on purpose to be revenged of us all. There was no one near me but Susan—my father and Letitia were asleep at the end of the deck—I stood trembling before him; at length I got courage, and called out to one of the soldiers to stand near me, and not allow him to talk to me in such a manner; the soldier came up, and said he would throw the pilot overboard. I called aloud for the captain—the pilot sneeringly asked me what I thought he cared for the captain—that he had no controul when the pilot was on board. They now became so abusive to each other I called again for the captain, when an ill-looking fellow came on deck; his eyes were half closed with sleep and *whiskey*. I really felt more dead than alive; and had it not been for the soldiers who were on board, I could never have supported myself. After a few painful hours I saw the boat returning from Wexford; and when the officers and passengers came on board, I told them of the insolence of the pilot, and that he had said he would strike us again if he chose it, and keep us as long as he liked in the harbour.


Mr. Stringer, an Enniscorthy gentleman, declared the pilot should not take in the boat; that he would go back to Wexford, and complain to the commanding officer; and desired him not at his peril to sail till he brought back a Mr. Grey, a protestant pilot. The captain remonstrated—said the man had been drunk, but was now quite sober, and would take us safe; but Mr. Stringer was steady: he and two gentlemen went for the pilot—I begged that one of the gentlemen would remain on board, to protect us from further insult; which Mr. Turner, of the Queen's Regiment, politely offered to do.


To this charming young man (under protecting Heaven) I am certain we owe our lives. In a few hours the gentlemen returned with the pilot they had sought for. We soon got over the bar, and all the dangerous navigation; the pilot then took leave. We had a fine evening, and fair wind; but at the fall of the tide, between one and two in the morning, we struck upon a rock. This threw us all into great consternation; Mr. Stringer, a gentleman who had suffered greatly at Enniscorthy, added to 





---

p.383






our alarm by asserting aloud, that the captain did it designedly. In a moment all was bustle and confusion. You may imagine how much I was shocked, when the three officers came to me and requested I would keep their swords under my great coat, as they must all go and try to get the vessel off; they desired me to stand close to the hold of the ship, and call out to them if any one from below attempted to come on deck, as they suspected there were arms on board; that we were just under Glascarick Hill, the rendezvous of all the retreating rebels; Mr. Stringer said he was certain it was the captain's plan to give us up to them. Mr. Turner insisted on getting out the boat and put six of his men to work the windlas, and said he would shoot the first man belonging to the ship that put a hand to a rope without his orders. I heard Mr. Stringer whisper him to take care they did not slip the cable, and he was scarcely in the boat when he called out to know who the rascal was that slipped the cable, and desired they would put out another, or he would go on board and his men should lash to the masts every man belonging to the ship. All this time the vessel was thumping so violently against the rocks I gave myself up to despair, till my attention was called off by my angelic Susan's saying, ‘Dearest mamma, dont be afraid—did not God Almighty save us from the rebels!’


Mr. Turner remained a long time rowing round the ship, in hopes of getting her off; he found it in vain till the tide came about, but endeavoured to quiet our fears by assuring us the night was so calm we were in no danger. Every thump the vessel gave filled me with horror; and every noise made me fear the rebels were coming out in boats from the shore. In no period of the rebellion were my fears equal to those of this night. I do think I should have lost my senses but for Mr. Turner. The passengers wanted to have the corn thrown overboard, which Mr. Turner opposed, saying, it might be the ruin of the owner—that it did not belong to the captain; and he convinced them it would be of little consequence towards moving the vessel. It is impossible to say too much of this charming young man, who, in the few hours of my acquaintance with him, displayed steadiness, bravery, activity, and humanity. When my fears were a little abated, I could not help telling him, I envied the mother who had such a son to boast of.


The ship continued violently agitated for several hours; during which 





---

p.384






time hope and despair alternately took possession of me. My dear child's religious reflection made me blush at doubting one moment that Being's mercy in whom she so piously expressed her confidence. I felt at times perfectly resigned, and even that did the worst happen, we were spared from the more bitter death of murder; and could the ship not be saved, we were not likely, one of us, to be uncertain of the other's fate; but my self-reproach at prevailing on my dear father to come by sea, was my most painful feeling: I accused myself of being accessary to his death, and this idea was indeed intolerable. At length the joyful cry of, ‘She's off! she goes!’ was echoed through the deck. So sudden was this delightful news, that I was really stunned, and yet felt such a confusion of recollection (if I may be allowed the expression) it was a length of time before they could make me understand that the ship was in full sail, and that every thing favoured our speedy and safe passage to Dublin, where we arrived without further obstacle.


We found hackney coaches on the quay, into one of which we joyfully got; indeed, our sensations were not to be described. We looked at each other without being able to utter a word, except dear Susan, who asked me were we really in Dublin and away from the rebels? Going through York Street, I saw my beloved dear Doctor Hartigan's carriage at the door of some patient. I entreated my father to allow me to get into it, and that he and the children would precede us, to our hospitable destination, the Doctor's house; my father consented, and into his carriage I joyfully went. At length the hall door was opened, and in the same moment the footman let down the step for his master—but what was my dear Willy's surprise when I threw my arms about him—‘Jenny! Jenny! is it possible!’ I continued embracing him without uttering a word, till he saw a gentleman nodding and laughing at him, he drew the string and beckoned him to the carriage; till that moment we neither of us recollected the extraordinary exhibition we both made in a public street; he introduced me, and told him I was the dear relation he had so often heard him lament as in the hands of the rebels, and of whose fate he was for such a length of time uncertain. We were soon at his house and were received with joy unutterable by dear Mrs. Hartigan, and many friends. Poor Mr. Adams went to the upper room in the house, actually unable to see us till he could command 





---

p.385



 



his feelings. I pray God I may never lose sight of his infinite mercy to me—He gave me strength not my own—can I ever be sufficiently grateful?


I have written every thing that occurred without embellishment, the incidents followed exactly as I have stated them. This is a narrative of facts relating to ourselves, but gives little of the general features of the rebellion. To you my dear friend it will be interesting—you who suffered so much about us when our fate was doubtful.


As ever, 
  


Affectionately, your's 
  


August, 1798. Jane Adams.





