

#His Majesty's Castle of Dublin


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


His Majesty's Castle of Dublin
==============================


Author: Caesar Litton Falkiner
------------------------------


### File Description

Electronic file compiled by Beatrix FärberProofed by Beatrix Färber and Benjamin Hazard

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project. 1. First draft, revised and corrected.Extent of text: 

17000 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2007) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E900000-002Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Further Reading**2. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
3. Giraldus Cambrensis (Gerald de Barri), Topographia Hibernica et expugnatio Hibernica, Rolls Series 21. Vol. 5 of Giraldi Cambrensis Opera. (London 1867).
4. James Henthorn Todd (ed.), Cogadh Gaedhel re Gallaibh: The War of the Gaedhill with the Gaill, or, the invasions of Ireland by the Danes and other Norsemen. The original Irish text edited, with translation and introduction (Rerum Britannicarum Medii Aevi Scriptores, 48). (London: Longmans, Green, Reader, and Dyer, ). Reprinted by Kessinger Publishing, LLC, 2006.
5. Roger de Hoveden [=Roger of Howden], Chronica magistri Rogeri de Hovedene, ed. W. Stubbs, 4 vols., Rolls Series, 51 (1868–71); especially vol. 2.
6. H. S. Sweetman, G. F. Handcock, (eds.), Calendar of documents relating to Ireland, 1171–1307. 5 vols. 1875–86; esp. 1172–1251.
7. Sir John Thomas Gilbert (ed.), Historic and municipal documents of Ireland, A.D. 1172–1320, from the archives of the city of Dublin, etc. (Rerum Britannicarum Medii Aevi Scriptores, 53) 1870.
8. James Hardiman (ed.). 'A statute of the fortieth year of King Edward III, enacted in a parliament held in Kilkenny, A.D. 1367, before Lionel, duke of Clarence, lord lieutenant of Ireland'. In Tracts relating to Ireland, 2 (Dublin, 1843): see especially Acts of Parliament at Trim, 1478. Act 12.
9. Walter Harris, Voyage of Sir Richard Edgcumbe into Ireland in the year 1488, in: Hibernica, (Dublin 1747).
10. William Monck Mason, The history and antiquities of the collegiate and cathedral church of St Patrick near Dublin, from its foundation in 1190 to the year 1819. (Dublin 1820).
11. Sir William Betham, Dignities, feudal and parliamentary, and the constitutional legislature of the United Kingdom: the nature and functions of the aula regis, the magna concilia, and the communia concilia of England, and the history of the parliaments of France, England, Scotland, and Ireland, investigated and considered with a view to ascertain the origin, progress and final establishment of legislative parliaments and of the history of a peer or lord of parliament (Dublin and London, 1830). [No more volumes published. A revised edition, 'The origin and history of the constitution of England and of the early parliaments of Ireland', was published in 1834.]
12. H. C. Hamilton, E. G. Atkinson, R. P. Mahaffy, Calendar of the state papers relating to Ireland in the reigns of Henry VIII, Edward VI, Mary, and Elizabeth, 1509–1603. 11 vols. 1860–1912; see esp. State Papers of Henry VIII. vol. 2. pt. 3, p. 169.
13. James Morrin (ed.), Calendar of the patent and close rolls of chancery in Ireland, of the reigns of Henry VIII, Edward VI, Mary, and Elizabeth. 1: 6 Hen. VIII-18 Eliz. I; 2: 16 and 18-45 Eliz. I. 2 vols. (Dublin, 1861-62).
14. John Derricke, The Image of Irelande (London 1581).
15. Richard Stanihurst, De Rebus in Hibernia gestis (Antwerp 1584).
16. Luke Gernon, A Discourse of Ireland, anno 1620, in: Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed.) (London: Longmans Green, and Co., New York, Bombay 1904), 345–362. [Online at CELT as file E620001.]
17. Travels of Sir William Brereton in Ireland, 1635, in: Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed.), Longmans Green, and Co. London, New York, Bombay (1904), 363–407. [Online at CELT as file E630001.]
18. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by Thomas Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). [=A translation of portions of "Les voyages et observations du sieur de la Boullaye Le Gouz ..." Paris, 1653.] [The translation is online at CELT as file T100076.]
19. Richard Cox, Hibernia Anglicana; or the History of Ireland from the Conquest thereof by the English to this present Time. With an Introductory Discourse touching the Ancient State of that Kingdom; and a new and Exact Map of the same, 2 vols. (London: H. Clark and Joseph Watts, 1689–90).
20. William Knowler (ed.). The Earl of Strafforde's letters and despatches with an essay towards his life by Sir George Radcliffe ... (1739).
21. T. Carte (ed.), Ormonde Papers ... 2 vols. (1739).
22. The manuscripts of the Marquis of Ormonde, preserved at the castle, Kilkenny. Historical Manuscripts Commission, (London 1895–99).
23. Arthur Collins (ed.), Letters and memorials of state: in the reigns of Queen Mary, Queen Elizabeth, King James, King Charles the First, part of the reign of King Charles the Second, and Oliver's usurpation, written and collected by Sir Henry Sidney ... Sir Philip Sidney and his brother Sir Robert Sidney; together with letters of the other ministers of state, with whom they held a correspondence ... Collected from records, their last wills and testaments, original papers, authentick manuscripts, and our most approved historians ... transcribed from the originals at Penshurst Place in Kent ... and his Majesty's office of papers and records. 2 vols. 1746.
24. Walter Harris, The History and Antiquities of the City of Dublin (1766). [Chapter 2, containing a short decription of the Castle of Dublin, is available online at http://www.chaptersofdublin.com/books/Harris/chapter2.htm.]
25. John Lodge (ed.), Desiderata curiosa Hibernica, or a select collection of state papers; consisting of royal instructions, directions, dispatches and letters ... to which are added some historical tracts. 2 vols. Dublin, 1772.
26. James Simon, Simon's essay on Irish coins. 2nd edn. Dublin, 1810.
27. P. F. Moran, Cardinal (ed.), Spicilegium Ossoriense: being a collection of original letters and papers illustrative of the history of the Irish church from the reformation to 1800. 4 vols. Dublin, 1874; especially 'Some documents connected with Dr Creagh, archbishop of Armagh, with notice of his life', Spicilegium Ossoriense, 1 (1874) 40–58.
28. Sir John Thomas Gilbert, A history of the viceroys of Ireland. With notices of the castle of Dublin and its chief occupants in former times. (Dublin and London 1865).
29. Sir John Thomas Gilbert, Calendar of Ancient Records of Dublin, vols. 8-18, (Dublin 1889–1922).
30. Raphael Holinshed, The ... chronicles of England, Scotlande, and Irelande ... 4 pts. in 2 vols. (1577}.
31. Raphael Holinshed, Holinshead's Irish chronicles [The historie of Ireland from the first inhabitant thereof unto the year 1509]; continued till the yeare 1547 by Richarde Stanyhurst. Edited by Liam Miller and Eileen Power. Atlantic Highlands, New Jersey (USA) 1979.
32. A prose version of Regan's Chronicle, &c., was printed in Dublin, 1747 by Walter Harris in 'Hibernica' from an abstract by Sir George Carew. The chronicle, or rather poem, has since been edited by Mr. Goddard H. Orpen, under the title of 'The Song of Dermot and the Earl' (Oxford, 1892). [Available at CELT in file T250001-001].
33. John O'Donovan, Annals of the Four Masters vol 1., A.D. 840. Dublin 1849. [Available at CELT].
34. Pipe Roll of 19 Henry III., Irish Record Office.
35. John Gillingham, 'The travels of Roger of Howden and his views of the Irish, Scots and Welsh'. Anglo-Norman Studies, 20 (1998) 151–169.
36. John Barry, 'Richard Stanihurst's De Rebus in Hibernia Gestis'. Renaissance Studies, 18:1 (2004), 1–18.
**The edition used in the digital edition**2. Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed), First edition [xvii + 426 pages] Longmans Green, and Co.London, New York, Bombay (1904)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 3–38 of the volume.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text represents the edited text. Footnotes are included and tagged note, or integrated into the bibl elements inside citation tags. Non-standard spellings of names are regularised using the reg attribute within the XML/SGML tags. Encoding is subject to revision.


##### Quotation


Direct speech is tagged q. Citations are tagged cit. This element contains qt and bibl elements.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section; back back matter containing one appendix. Page-breaks are marked pb.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd, and tagged.


##### Interpretation


Place-names, personal and group names, titles (of books etc.) and terms are tagged and regularised. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: By C. Litton Falkiner (c. 1904) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words and phrases are in Latin.


### Revision History


* (2008-07-30) Beatrix Färber (ed.)

* File updated.
* (2007-10-31) Beatrix Färber (ed.)

* Items added to bibliography; header completed.
* (2007-08-27) Beatrix Färber (ed.)

* Provisional header created; second proofing; more content markup applied.
* (2007-07-07) Benjamin Hazard (ed.)

* First proofing; some structural and content markup added.
* (2007-07-07) Benjamin Hazard (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E900000-002


### His Majesty's Castle of Dublin: Author: Caesar Litton Falkiner




---

p.3


His Majesty's Castle of Dublin
------------------------------


The earliest mention of the fortified stronghold of English power, so often referred to in the Irish State Papers of the **Plantagenets** as ‘his Majesty's **Castle of Dublin**,’ is to be found in the records of the reign of **King John**, and is just seven centuries old. Whether the actual site of the Castle had been occupied by a fortress, and had served as the seat of government prior to the year 1204, it is now impossible to determine. How far the Plantagenet castle can be fairly identified with the earlier stronghold known to have been erected by the Danish sovereigns of Dublin is one of those questions which, since they can never be positively answered, it is profitless to discuss. On this point all that can be affirmed is, that the probabilities of the case favour the supposition that the site of both edifices was the same. That the walls of the mediaeval city were first raised in the Dark Ages by the founders of the Scandinavian kingdom of Dublin, is a point not open to controversy. The physical configuration of the rising ground to the south-east of the city walls, must at all times have suggested that eminence as the most suitable site for the guardian fortress of the city. And all authorities are agreed that a fort was erected by the Danes,[1](javascript:footNote('E900000-002/note001.html')) about the middle of the ninth century, in close proximity to the walls. Thus it may well be that the ‘battlements of the watch tower,’ from which **King Sitric** followed the varying fortunes of the fight at **Clontarf**, rose from the self-same spot from which for seven





---

p.4






centuries his Majesty's **Castle of Dublin** has been the sentinel of royal authority in Ireland.[2](javascript:footNote('E900000-002/note002.html'))


But if the Danish fortress had once occupied the site, it no longer stood there in 1170, when, at the bidding of **Strongbow**, **Myles De Cogan** and his comrades first entered Dublin. It had been destroyed after the **Battle of **Clontarf****, and no new building seems to have replaced the old in the interval that parted the exit of the Dane from the coming of the Norman. The accounts of the taking of Dublin by **Strongbow**'s followers are silent as to any such protracted stand as must have been expected of its defenders, had a fortified citadel barred the eastern entrance to the city against the Norman knights. And there is no mention of any such stronghold in the narrative of the negotiations between **Earl Richard** and **King Roderic O'Conor** when, a few months after its capture, the city was blockaded by that monarch and his allies. When, therefore, **Henry II.**, arriving in Dublin in November 1171, built, as **Roger de Hoveden** tells us, *a royal palace roofed with wattles after the fashion of the country’’*

Roger de Hoveden's Chronicle. (Rolls Series), ii. p. 32.

 in which to spend his Christmas, he occupied in all probability the deserted site of the dismantled Danish stronghold. **Henry**'s palace was situate, according to the chronicler, *near the **Church of St. Andrew the Apostle**, without the city of Dublin.’’*

 As the old **Church of St. Andrew** stood close to the eastern corner of the modern **Palace Street**, hard by the entrance to what is now the Lower Castle Yard, the king must thus have fixed his quarters as nearly as possible on the actual spot on which thirty years later his son caused the Castle to be built.


Up to this point the history of the Castle, or rather of its site, rests only upon conjectures which are necessarily inconclusive. The chronicles of the first thirty years of Norman rule add nothing to our knowledge. **Richard I.** cared little for a country which had become the appanage





---

p.5






of his younger brother, and there is nothing to connect the prisoner of **Durrenstein** with the **Castle of Dublin**. But with the opening of **King John**'s reign the story can be placed on the firm basis of authentic record. An entry in the Close Roll for the year 1204 is the first extant document in which the Castle is mentioned. It contains the King's directions to his deputy or justiciary in Ireland, in response to a representation by the Viceroy of the lack of any depository for the safe custody of the royal treasure, and its most important passage runs as follows: — *The King to his trusty and well-beloved Meiller, the son of **Henry, Justiciary of Ireland**, greeting: You have represented to us that you have no place wherein treasure can be safely kept; and forasmuch as for this as well as for sundry other reasons we are in need of a strong fortress in Dublin, we desire you to cause a castle to be built in such place as you may judge to be most suitable both for the administration of justice and, if need be, for the defence of the city. You are to make it as strong as possible, with substantial fosses and strong walls. But you are first to build a tower to which a castle and keep can afterwards be conveniently added at leisure.’’*

Close Roll, 6 John, m. 18. Printed in Historic and Municipal Documents of Ireland. (Rolls Series), p. 61.

 The mandate, after permitting the Justiciary to appropriate a sum of three hundred marks, then due to the Crown, to the initial expenditure on the building, directed him to require the citizens, if necessary by force, to strengthen the defences of Dublin. It may be that the establishment of a fair at Donnybrook, sanctioned by the King in the same document, was intended as a set off or compensation for the military outlay thus charged on the city.


**Meiller Fitz-Henry** to whom this document was addressed was at this time the representative of the Crown in Ireland. He was a first cousin in blood to the Sovereign, and had been among the most distinguished of the friends and followers of **Strongbow**. *Indomitus domitor totius gentis Hiberniae’’*

**Cox**'s Hibernia Anglicana. , p. 48.

, so ran the concise epitaph in which his career is





---

p.6






epitomised. Of his appearance and character, his relative **Giraldus Cambrensis** has left a vivid description,[3](javascript:footNote('E900000-002/note003.html')) in which affectionate admiration of **Fitz-Henry**'s valour is not unmixed with discriminating censure of his lack of discretion. No one, however, could have been better qualified to exercise the latitude left him in the royal letter as to the choice of a site for a castle intended for the defence of the capital. For the soldier whose prowess at the raising of the siege of Dublin thirty years before is commemorated by **Maurice Regan** as the most admirable among many exhibitions of martial valour[4](javascript:footNote('E900000-002/note004.html')) must have been thoroughly acquainted with the military needs of the city. **Fitz-Henry** had been appointed justiciary at **King John**'s accession in 1199, and he held the post until 1208. His tenure of authority thus lasted long enough to have enabled him, had he been expeditious, to commence the building of the Castle, though it can scarcely have permitted of his making substantial progress with the work. Most probably he confined himself to the erection of the tower which **John** had desired him to begin with. Though neither tradition nor record now connects the name of **Meiller Fitz-Henry** with any part of the actual structure, it is evident that to him belongs at least the honour of having selected the site; even though the chief fame of the actual building of the Castle is rightly assigned to another of **John**'s justiciaries, the well-known ecclesiastic, **Henri de Londres, Archbishop of **Dublin****.


But by whichever of **King John**'s representatives the foundation stone was actually laid, it is plain that the building of the Castle was a matter of serious interest and concern to the Sovereign, and that to no one can the title of founder be more properly ascribed than to **King John**


---

p.7






himself. The instructions to **Meiller Fitz-Henry** indicate the active interest of the monarch in a building with the surroundings of which his own early residence in Ireland had made him familiar. And within a very few years of these instructions the exigencies of Irish affairs gave **John** an opportunity of observing for himself how far his orders had been fulfilled, and of personally directing the further progress of the building. In 1210, for the first time since his accession, the King visited Dublin. There is nothing to show whether it was within the precincts of his intended fortress that the King received the submission of the Irish chiefs who attended in the capital to do him homage. But his attention must necessarily have been drawn to the desirability of pushing on the work, and it is certain that the royal visit had not long concluded before **Henri de Londres** was vigorously proceeding with the building.


Of the active part played by this eminent prelate and Viceroy in the construction of the Castle we get not a few glimpses in the records of his government. The State Papers show that **Ware** does not at all exaggerate in attributing to the Archbishop a principal share in the erection of the building, and they prove that the attention of the Archbishop was not so wholly engrossed with the constitution of the Cathedral Chapter of St. Patrick's as to leave no time to the Viceroy to superintend the building of the King's principal residence. **Ware**'s account is that **Henri de Londres** *caused the **Castle of Dublin** to be builded, some say at his own proper costs,’’*

**Ware**'s Annals (1705) p. 27.

 and he elsewhere states that *the same year that **Henry Londres** died, being the year 1228, the **Castle of Dublin** was builded: I mean the walls four-square or quadrangle-wise, but the four turrets and the other afterwards.’’*

**Ware**'s Bishops, p. 5.

 The State Papers show that, on his appointment to be justiciary in 1213, the Archbishop received a patent for the custody of the King's **Castle of Dublin** during pleasure.[5](javascript:footNote('E900000-002/note005.html')) Though no details are given of





---

p.8






the works executed by **Henri de Londres**, their importance is indicated by sundry grants[6](javascript:footNote('E900000-002/note006.html')) made to him in compensation for damage done to the Archbishop's churches in Dublin in fortifying the Castle;[7](javascript:footNote('E900000-002/note007.html'))—while the completion of the walls in accordance with the tradition preserved by **Ware**, as well as the actual appropriation of the fortress to defensive purposes, is evidenced by an inventory of military stores kept in the building in 1224.[8](javascript:footNote('E900000-002/note008.html')) The last indication of the Archbishop's interest in the Castle, which the State Papers disclose, is one more appropriate to his ecclesiastical character. There can be little doubt that the nomination, in 1225, of **William de Radeclive** *to minister as chaplain in the King's **Castle of Dublin**, and to receive of the King's gift during pleasure fifty shillings yearly,’’*

Sweetman's Calendar, 1172-1251, p. 198.

 was not made without the recommendation or concurrence of the masterful ruler of the see of Dublin.
Whatever the solicitude of the Archbishop in these matters may have owed to the initiative of **King John**, these latter proofs of it were of course given not in John's reign, but in that of his more ecclesiastically minded successor. Though **Henry of Winchester** found no time in his long reign for a visit to Ireland, he appears more than once to have contemplated such a journey; and several of the State Papers of his reign prove that he was far from indifferent to the becoming equipment of his only Irish residence. In 1237 the King gave elaborate directions to prepare for his coming into Ireland.[9](javascript:footNote('E900000-002/note009.html')) And in 1243, while in France, where the presence in his army of a very large Irish contingent may have turned his thoughts towards his Irish dominions, **King Henry** wrote from **Bordeaux** to his Justiciary and Treasurer in Ireland, directing them *that out of the King's profits they cause to be constructed in the **Castle of Dublin**


---

p.9






a hall one hundred and twenty feet in length, and eighty in breadth, with glazed windows after the manner of the hall of Canterbury, and that they cause to be made in the gable beyond the dais a round window thirty feet in diameter.’’*

Sweetman's Calendar, 1172-1251, p. 389.

 They were further directed ‘to cause to be painted beyond the dais’ the King and Queen sitting with their baronage, and to make a ‘great portal’ at the entrance of the hall; the whole to be completed by the King's arrival.
But by far the most characteristic memorials of this Sovereign's connection with the Castle are those which are associated with the chapel. The entries under this head supply fresh illustrations of the splendours of Henry's munificence to the Church, and of the sincerity of the devotion to the memory of **Edward the Confessor**, which marked the pious builder of **Westminster Abbey**. Not only were directions repeatedly given to the Archbishop of Dublin to make more suitable provision for the Castle chaplain by attaching a benefice to the office, but express instructions were given by the King as to the services to be held.[10](javascript:footNote('E900000-002/note010.html')) The chapel was dedicated to the Confessor, and in 1240 the Feast of St. Edward (January 7) was ordered to be celebrated with eight hundred lighted tapers *as well in the Saint's Chapel in the King's **Castle of Dublin**, as in the Churches of **St. Thomas the Martyr** and of the **Holy Trinity**.’’*

Ibid. p. 373.

 The Castle was ordered to be filled on the same occasion with poor people, who should be fed. Two years later the Treasurer received directions to cause glass windows to be made for the chapel,[11](javascript:footNote('E900000-002/note011.html')) and the King gave orders that Divine Service of St. Edward and of the Blessed Virgin should be daily celebrated. The orders regarding the chapel were perhaps carried out at once, since the piety of the King would probably have enforced them; but the hall was still unfinished in 1246, when Henry peremptorily required its completion in view of an immediate visit. The Mayor of Dublin was called on in the same year, and in view of the same occasion, to supply water to the Castle from the city conduit.[12](javascript:footNote('E900000-002/note012.html'))


---

p.10


Judged by the proper standards of kingly greatness **Henry III.** scarcely ranks high in the roll of English monarchs. But no other sovereign has had anything approaching either to his knowledge of architecture or to his love of it. However fortunate for the realm the change from his pious aestheticism to the vigorous authority of the great man of action who succeeded him, the archaeological interest of **Dublin Castle** certainly owes nothing to **Henry**'s son. The **Hammer of the Scots** cared little for the sculptor's mallet. And although for at least eighteen years before his accession **Edward I.** had held the title of Lord of Ireland and absorbed its surplus revenues, he never found time to attend to its affairs. Thus the interest in the royal residence which **Henry**'s care had aroused in his subordinates was naturally not exhibited by the ministers of his son. In what manner the chapel and hall so splendidly designed were ultimately erected it is now impossible to ascertain. But it seems at least clear that they were not completed according to **Henry**'s plan. It was one of the charges brought against **Stephen Fulburn, Bishop of Waterford**, in 1286, that during his tenure of the office of justiciary he had carried off the pillars of marble from the King's hall in **Dublin Castle** to enrich **Dunbrody Abbey**.[13](javascript:footNote('E900000-002/note013.html')) A few years earlier the building had suffered some damage and the gate tower had been burned by **Hubert de Burgh**, and some others who were confined in the fortress as prisoners; whilst the defences had been altogether neglected. When, therefore, a few years after the accession of **Edward II.** the troubles of the **Bruce** invasion made it necessary to look to the defences of the Castle, the building already stood in much need of repair. So imminent was the peril that it was found necessary to take down the belfry of the closely adjacent church of **St. Mary le Dame** to provide stones for fortifying the Castle, and the citizens of Dublin were called on to find lead for the roof of the towers.[14](javascript:footNote('E900000-002/note014.html')) When the danger was over some care seems to have been taken to





---

p.11






restore the edifice to a more seemly condition, and the considerable sum of £700 was spent on the Castle in 1321, particularly in *repairing handsomely the great hall.’’*

Close Roll, 14 Ed. II., Irish Record Office.


For fifty years from the Bruce invasion the King's **Castle of Dublin** received little of the attention of its royal owners; and indeed for a full century and a half from the accession of **Edward III.** it was 'toward Namancos and Bayona's hold' rather than to their realm of Ireland, that the looks of the English sovereigns were chiefly bent. Towards the close of his reign, however, **Edward III.** was able to spare time from his French enterprises to the necessities of Ireland, and to note how seriously his dominions had been shrinking at home, while he sought to extend them abroad. His son **Lionel, Duke of Clarence**, entered in 1361 on the viceroyalty which was made memorable by the **Statute of Kilkenny**. The advent of a prince of the blood royal did something to arrest the rain which was fast overtaking the monuments of **Henry III.**'s zeal and piety. A considerable expenditure was sanctioned for putting the Castle in order, and for restoring the chapel, and providing it with the equipment adequate to a becoming ritual.[15](javascript:footNote('E900000-002/note015.html')) But the improvements of **Lionel** were not limited to these restorations. Not only do they seem to have included a number of alterations designed to make the dwelling more commodious, but in the language of King Edward, **Clarence** *caused to be made divers works agreeable to him, for sports and his other pleasures, as well within the **Castle of Dublin** as elsewhere.’’*

Gilbert's History of the Viceroys of Ireland, with Notices of the **Castle of Dublin**, pp. 219, 544-546.


It is disappointing that the records of the only sovereign prior to **Victoria** who ever came twice to Ireland as a reigning monarch are silent as to the visits of **Richard II.** to his **Castle of Dublin**. Neither the Roll of the Proceedings





---

p.12






of the King's Council in Ireland for the sixteenth year of Richard's reign, nor such records as remain of that unhappy monarch's second stay in Ireland, make any direct mention of **Dublin Castle**, though the Council must have sat within its precincts, and though the extensive repairs ordered, as we have just seen, in the time of the King's uncle, Lionel, ought to have left the building in fair order for his residence. It is doubtful, however, whether much had been effected by Clarence. ‘Because our **Castle of Dublin** through the negligence of our servants, who should have repaired the same, is so destroyed and wasted, and in many places threatened with very great ruin that our Deputy of Ireland cannot hold our great Council there, nor can he entertain our Parliament summoned for the morrow of All Souls' Day, nor can our Records be safely preserved there.’ So runs an entry in the Close Roll for the fourth year of Richard's reign. But though it is doubtful whether the orders issued to remedy this state of things in 1381 were more effective than those of the preceding reign, the great hall had been sufficiently renovated in 1385 to enable **Sir John Stanley** to be sworn in there, in presence of a distinguished company, as Deputy of **Robert de Vere**, ‘**Earl of Oxford, Marquis of Dublin, and Duke of Ireland**,’ who had just been appointed Lord-Lieutenant.


The records of the Lancastrian kings are as barren as those of their immediate predecessors. Their all but total silence betokens the neglect which the few stray entries that appear attest. Early in 1427 it was ordered that an ancient silver seal found in the treasury, ‘being cancelled and of no use to the King,’ should be sold, and the money accruing from the sale laid out on the repairs of the ruined windows of the hall of the Castle, and five years later twenty marks were allocated to the same purpose.[16](javascript:footNote('E900000-002/note016.html')) Even so much as this could not be spared in the remainder of this reign, and the dilapidations were rapidly aggravated. Down to the middle of the reign of **Henry VI.** the Deputy and his Council still met within the





---

p.13






Council Chamber in the Castle. But at the conclusion of the **Wars of the Roses** all the interior buildings of the Castle had gone to wrack and ruin, while even the massive walls erected by **Henri de Londres** had begun to suffer from persistent neglect, and showed the wear and tear of over two hundred winters.[17](javascript:footNote('E900000-002/note017.html')) On the accession of **Edward IV.** the disrepair could not longer be overlooked. An Act of Parliament, after reciting that *Whereas the Castle of the King our Sovereign Lord of his City of Dublin, in which the Courts of our said Sovereign are kept, is ruinous and like to fall, to the great dishonour of our said Sovereign Lord,’’*

Statute 2 & 3 Ed. IV. cap. 4.

 provided that certain moneys out of the profits of the Crown should be delivered yearly to the clerk of the works for the repair of the same. The same Act further directed that *all the leads of the isles of the hall of the said Castle be sold by the Treasurer of Ireland to make and repair the said hall.’’* This Act, however, remained inoperative until, twelve years later, a further enactment made better financial provision for the needful works. But it is doubtful whether any restoration had been effected ere, not long afterwards, considerable injury was done the Castle in the course of an insurrection promoted by the followers of the Earl of Kildare. An Act of the Irish Parliament at **Trim** gives as the last reference to the Castle which the statutes or records of the Plantagenet kings contain. Reciting that **James Keating, Prior of Kilmainham**, had fortified the Castle, of which he was constable, against **the King's Viceroy, Henry Lord Grey**, and the better to defend himself had destroyed the drawbridge, it directs the Prior to repair the damage before the ensuing Christmas on pain of forfeiture of his office.[18](javascript:footNote('E900000-002/note018.html'))
The earliest Tudor reference to **Dublin Castle** is to be found in the diary of the Voyage of Sir Richard Edgcumbe into Ireland in the year 1488,[19](javascript:footNote('E900000-002/note019.html')) and occurs in connection





---

p.14






with the ecclesiastic just mentioned. **Keating** had been among the most prominent of the Irish supporters of the pretender **Lambert Simnel**, the troubles arising out of whose imposture were the principal occasion of **Edgcumbe**'s mission. **Sir Richard** seems to have thought, not unnaturally, that one who had twice gone into rebellion was no fit guardian for his master's principal fortress in Ireland. He accordingly ‘refused to take either homage or fealty of **Justice Plunkett** and **the Prior of Kilmainham**, who were specially noted amongst all other chief causes of the rebellion.’ And although the importunities of the **Earl of Kildare** prevailed on **Edgcumbe** to pardon Keating's comrade in disloyalty, he could not be persuaded to overlook the Prior's repeated offences. At a meeting of the Lords Spiritual and Temporal held in ‘the Church called **our Lady of the Dames**,’ in the immediate vicinity of the Castle, he answered their entreaties for mercy, according to the Chronicle, with ‘right sharp words ... And ere that he departed unto his lodging, he took with him divers judges and other noblemen, and went into the **Castle of Dublin**, and there put in possession **Richard Archiboll, the King's servant**, into the office of the Constable of the said Castle, which the King's grace had given unto him by Letters Patent; from the which office the said **Prior of Kilmainham** had wrongfully kept this said Richard for the space of two years or more.’[20](javascript:footNote('E900000-002/note020.html')) The fact that during his stay in Ireland **Edgcumbe** lodged at the **Monastery of the Black Friars**, on the opposite side of the river, where now the Four Courts stand, and that the consultations with the Irish Council were held not in the Castle, but in the neighbouring Church of **St. Mary le Dame**, is eloquent of the disrepair into which the royal residence had fallen.


For nearly fifty years, from the visit of **Sir Richard Edgcumbe** in 1488, to the rising of Silken Thomas in 1533, the records are silent as to episodes of interest in the story of **Dublin Castle**. For the greater part of this period the government was in the hands of the **Earls of Kildare**, who





---

p.15






were more concerned for the safety of their own strongholds in the adjacent country than for the security of the nominal seat of their government. So weak were the defences that the **O'Byrnes**—those continual scourges of the southern borders of the Pale—could enter the Castle by night and carry off a number of prisoners.[21](javascript:footNote('E900000-002/note021.html')) It was ominous of the rising that not long afterwards occurred that in 1533 the Deputy conveyed all the King's ordnance out of the Castle into his own country, and fortified all his castles and fortresses with them. ‘What this should mean,’ wrote the priest who sent this intelligence to England, ‘I know not as yet, but I think no good; for it is a shrewd likelihood.’[22](javascript:footNote('E900000-002/note022.html')) It proved fortunate for the safety of Dublin in the ensuing insurrection that the Deputy omitted to take away the ammunition at the same time. As **John Alen, the Irish Master of the Rolls**, wrote to **Thomas Cromwell** at a critical period of the siege by **Silken Thomas**, ‘the rebel, which chiefly trusteth in his ordnance, which he hath of the King, hath in effect consumed all his shoot, and except he winneth the Castle of Dublin he is destitute of shoot, which is a great comfort and advantage for the King's Army.’[23](javascript:footNote('E900000-002/note023.html'))


It might naturally be supposed that the formal assumption by **Henry VIII.** of the title of King of Ireland, and his resolution to assert the authority of the English Crown throughout the country, must have led almost of necessity to a renovation of the Castle, and a revival of the tarnished glories of the early Plantagenet age. But this was so far from being the case, that the period immediately succeeding marks perhaps, the nadir of the splendours of the Castle as a royal residence. The Tudor viceroys do not appear at any time to have taken kindly to their quarters. It is obvious from the preceding narrative that upon many occasions in its later mediaeval history the Castle can have been in no fit state to accommodate a royal or viceregal Court. Although at no time in its long annals did the Castle cease to be the centre of authority, and though in theory at least it was always





---

p.16






regarded as the principal official dwelling of the deputies, the representatives of **Henry VII.** and his successor took every opportunity of residing elsewhere. The deputies of **Edward VI.** never lodged within its walls. Towards the close of the fifteenth century the Abbey of **St. Thomas the Martyr** in Thomas Court began to be used, as has been seen, for the meetings of the Viceroy and his Council. By the time of **Sir Richard Edgcumbe**'s visit[24](javascript:footNote('E900000-002/note024.html')) it had been thus used so often that the principal room had acquired the name of the King's Chamber. The dissolution of the monasteries struck a heavy blow at the prestige of **King John**'s Castle. The **Priory of Kilmainham**, becoming vested in the Crown, was at once recognised as a convenient appanage of the Sovereign, and was utilised accordingly for the principal State functions. The dissolution of the Cathedral Chapter of **St. Patrick's** by **Edward VI.** provided an opportunity, which was quickly seized, to find more desirable lodgings than either Castle or Priory appears to have afforded. The Chapter having been suppressed, it was evident that the Dean had no further need of his residence. This was accordingly assigned to the Archbishop of Dublin, who was desired to evacuate the **Palace of St. Sepulchre's**, which became a place of lodging for the Lord Deputy. And although in a very few years this arrangement was upset, under **Queen Mary**, by the restoration of the Cathedral and its dignitaries to their former status, the Deputies were slow to surrender the footing they had acquired in the archiepiscopal palace. Sussex, Sidney, and others of the deputies of both **Mary** and **Elizabeth**, were so fond of coming to **St. Sepulchre's** that an Archbishop of Dublin, who found their visits inconvenient, is said to have actually fired his palace ‘that the Deputies should not have so good liking to his house.’[25](javascript:footNote('E900000-002/note025.html'))


Whether on account of this summary process of the Archbishop, or because with the final confirmation of the Cathedral in its position by **Elizabeth** it became difficult





---

p.17






any longer to ignore ecclesiastical rights, the accession of **Elizabeth** was quickly followed by the return of the Viceroys to the Castle, and its consequent restoration to a condition of appropriate magnificence. In 1558 **Sussex** received directions to take in hand the repair of the Castle. But this Viceroy had been succeeded by **Sir Henry Sidney** before any effective steps had been taken, and it is to the latter statesman that the honour of repairing and enlarging the Castle has been properly assigned by **Ware**. ‘The **Castle of Dublin**, which before his coming was ruinous, foul, filthy, and greatly decayed, he repaired and re-edified, and made a very fair house for the lord deputy and the chief governor to reside and dwell in.’[26](javascript:footNote('E900000-002/note026.html')) Such is **Stanihurst**'s account of a restoration of which the Deputy appears to have been not a little proud. **Sidney**'s improvements took several years to effect, and were on a considerable scale. They were crowned in the eyes of the citizens of Dublin by the putting up of a conspicuous clock, perhaps the first public clock erected in Ireland (though others were placed almost contemporaneously over the **Ostman's gate** and at **St. Patrick's Cathedral**); and in **Sidney**'s, by a Latin inscription over the gateway, in which the restoration was suitably recorded.[27](javascript:footNote('E900000-002/note027.html'))

The stone containing **Sidney**'s verses has been long since





---

p.18






defaced and removed, though the verses themselves have been preserved for us by **Stanihurst**. But the letters of **Strafford** contain a very charming reference to them, and attest the admiration felt by the most powerful of Stuart Viceroys for the most eminent among his Tudor predecessors.[28](javascript:footNote('E900000-002/note028.html'))


Of the actual outward appearance of the Castle in early times it is difficult to form an accurate conception. **Sir John Gilbert** justly observes that no precise details have been transmitted to us of its architectural design; nor have any of the older historians or antiquaries given us, otherwise than parenthetically, any glimpse of its interior. To attempt to reconstruct the Castle from the stray references which are to be found scattered through the State Papers and other documentary sources would be an exercise of the historical imagination in which fancy must needs play a larger part than fact.[29](javascript:footNote('E900000-002/note029.html')) There exists, however, one document which defines with some detail the condition of the towers of the Castle, and the accommodation provided within them, in the time of **Sir John Perrot**'s government, or about twenty years after the extensive improvements effected by **Sir Henry Sidney**. From this paper, which was probably drawn up in connection with the rearrangements which **Perrot** designed to carry out but did not effect, a good deal may be learned as to the defences of the Castle in the reign of **Elizabeth**.[30](javascript:footNote('E900000-002/note030.html'))




---

p.19


The walls, described by **Ware** and other authorities as standing foursquare and built very strongly, had in **Perrot**'s time a strong tower at each corner. Besides these there was a fifth, much smaller than the rest, in the middle of the south wall. The entrance gate, which opened into Castle Street, was flanked on each side by a tower less strong than the others, but of considerable proportions. The gateway, defended by a portcullis, opened on to a drawbridge which when drawn up left this building entirely cut off from the adjacent city. A moat, or gripe, which ran by the walls completely surrounded the Castle, following perhaps on the south and west walls the course of the **Poddle River**. Of the four principal towers, two, the north-east and south-west, seem to have contained five rooms each. The south-east and north-west towers had each three rooms, and in the middle tower on the south side there were a like number. The gate towers contained but two rooms each. The towers do not seem to have been very well lighted. There were several rooms with no windows other than the ‘spicks,’ or loopholes, intended for defensive purposes. The north-east tower in which the Deputy seems to have had his private rooms, was the only room in which the windows were at all numerous. There were at least eight windows among the five rooms in this tower. But in the south-east tower there were no more than two. On the other hand ‘spicks’ were fairly numerous, and the total of the windows and spicks in the whole Castle was at that time above fourscore.[31](javascript:footNote('E900000-002/note031.html'))


But **Sidney**'s improvements, though they were evidently considerable, and seem to have provided the actual official accommodation which sufficed for the Viceroys for above a century from his time, do not seem to have remedied the most serious inconveniences of the building. By the end of **Elizabeth**'s reign matters were nearly as bad as they had been before his time. When **Robert Devereux, Earl of Essex**, in an unhappy moment for himself, was designated Viceroy, directions were given to prepare the Castle for the





---

p.20






fitting reception of one whom the Queen, at that time, still delighted to honour. But considerable difficulty was experienced in providing becoming accommodation. The truth is that the Castle at this time was utilised for several purposes of public utility little consonant with the amenities of a viceregal residence.


It has been justly remarked by **Walter Harris**, in the excellent account of the Castle with which his History of Dublin opens, that the building is to be considered in a threefold aspect: as a fortress erected for the defence of the city; as the royal seat of Government; and as the place where the courts of justice and High Court of Parliament were wont to be held. But this description of the triple function served by the Castle down to Tudor and even Stuart times is far from exhaustive. Within its precincts room was found in addition for the Exchequer and Treasury of Ireland, and for the Mint of Dublin, as well as for the State records of which the Castle so long remained the principal, if not the sole, depository. And it further served the purpose, more easily associated with a feudal fortress, of a prison for offenders against the State.[32](javascript:footNote('E900000-002/note032.html')) However successful **Sidney** may have been in providing actual house accommodation, he had been unable to make any fundamental alterations in the structure. His work was a restoration in the strict sense of the term. Even in the reign of **James I.** , forty years after **Sidney**'s improvements, the great exterior walls and towers erected by **Henri de Londres** still preserved their original appearance. An accurate observer, in that reign noted that ‘the circuit of the Castle was a huge and mighty wall, foursquare and of incredible thickness,’[33](javascript:footNote('E900000-002/note033.html')) which dated from **King John**'s time. In **Sidney**'s day, as we learn from the grimly realistic plates in **Derricke**'s Image of Ireland, the battlements were still garnished with the grinning heads of decapitated chieftains. And the gaol, known as the Grate, was thoroughly insanitary. A prisoner's recollections of his place of confinement are of





---

p.21






course apt to be coloured by ineffaceable resentment; but there is no reason to question the substantial accuracy of the description given of the Grate by **Dr. Creagh**, the Roman Catholic Primate, who was confined there in 1564. The prison, according to this authority, was *a hole where, without candle, there is no light in the world, and with candle (when I had it) it was so filled with smoke thereof, chiefly in summer, that had there not been a little hole in the next door to draw in breath with, my mouth set upon it, I had been perhaps shortly undone.’’*

Spicilegium Ossoriense, i. p. 49. 

 After **Sidney**'s time **Perrot** was authorised, in 1583, to remove both the courts of law and the prison from the Castle, but he seems to have found it impossible to procure the necessary accommodation elsewhere.[34](javascript:footNote('E900000-002/note034.html')) And the same difficulty was experienced in the time of Essex. It is not surprising therefore to find the Castle described in 1607 as ‘somewhat noisome in the summer time by reason of the prison.’[35](javascript:footNote('E900000-002/note035.html')) Constant representations were made by the Deputies as to this unpleasantness, and also as to the danger caused to the courts of law, which had been restored to the Castle under **Sidney**, by reason of these being situate immediately above the store of ammunition; and a very serious explosion of gunpowder which occurred on the adjacent quay in 1596 caused great and general alarm. In 1610, as appears by the surveyor's accounts at the Irish Record Office, a summer house was built in the gardens and the great hall repaired against a marriage feast, held in January of that year. It was not, however, until 1611 that **Sir Arthur Chichester**, the vigorous Deputy of **James I.**, procured the erection of an exterior gaol for ordinary criminals, the principal State offenders being still confined in the Castle, but separated from the Deputy's lodging. Through the instrumentality of the same Deputy the courts were removed about the same time. But the Castle still remained the of the meetings of Parliament. In 1613 the Hall





---

p.22






was fitted up for the meeting of the two Houses.[36](javascript:footNote('E900000-002/note036.html')) But although the Castle was put in order again for the benefit of **Sir George Carew**, who came over to report on the state of affairs in Ireland in 1611, no real improvement was effected, in spite of an expenditure of 600£. **Chichester** after several vain attempts to procure an improvement in the domestic accommodation—the mending of holes in the roof in **Lady Chichester**'s bedchamber is one of the items in an account of expenditure by **Samuel Molyneux**, Clerk-General of the Works in 1616—had declined any longer to reside within the precincts, and had taken up his abode in the recently built Cary's Hospital, which later gave place to the Parliament House.
The next to take in hand the work of restoration was the **Deputy Falkland**, father of the gallant **Lucius Cary**. In 1620 this Viceroy apprised the Council ‘that of late part of the Castle and the roof of the Council Chamber and several lodgings over it’[37](javascript:footNote('E900000-002/note037.html')) had fallen to the ground. Four years later, ‘on May 1, in the morning, a day of great expectation of a universal massacre, one of the two greatest towers of the Castle fell down to the ground, with the ordnance mounted on it,’ and shook to its foundations a great part of the wall. **Falkland** succeeded in getting authority to carry out repairs, and an expenditure of 1,000£ was sanctioned to restore the tower. His reforms were considerable.[38](javascript:footNote('E900000-002/note038.html')) In a letter to his successor, **Strafford**, he takes full credit for them, calling on **Strafford** for ‘the performance of your promise you made me that when you found how much less a prison the Castle was through the benefit of a gallery I built, not more for the King's honour than for your ease and delight, you would acknowledge that you did owe my act commendation and due thanks for the service.’[39](javascript:footNote('E900000-002/note039.html'))


---

p.23






Of this gallery a picturesque description survives in the Travels of **Sir William Brereton**, whose diary of a visit to Dublin in 1635 supplies one of the few detailed notices of the appearance and accommodation of the Castle in early Stuart times which remain extant.[40](javascript:footNote('E900000-002/note040.html'))


**Strafford**, however, does not seem to have been so much impressed as **Falkland** expected. In one of his earliest letters from Dublin he described the building as in great decay, and urgently calling for repair. One of the groat towers had to be taken down, lest it should fall, as another had done shortly before **Strafford**'s arrival, while **Lord Chancellor Loftus** was in residence as a Lord Justice; four or five of whose grandchildren it would have ‘infallibly killed,’ had it fallen either an hour sooner or an hour later. In a vigorous representation to the English Council of the pressing need for repair and improvement **Strafford** draws for us the most detailed picture we possess of the interior of the Castle precincts at this time:—‘I have bought as much more ground about the Castle as costs one hundred and fifty pounds, out of which I will provide the House of a Garden and out Courts, for fuel and such other necessaries belonging to a family, whereof I am altogether unprovided, the bake house at present being just under the room where I now write, and the wood rack put full before the gallery windows; which I take not to be so courtly nor to suit so well with the dignity of a King's deputy; and thus I trust to make this habitation easeful and pleasant as the place will afford. Whereas now by my faith it is little better than a very prison.’[41](javascript:footNote('E900000-002/note041.html'))


Of the alterations made by **Strafford** no record is known to remain, and for nearly half a century little information is available from English sources. For though **Arthur Capel, Earl of Essex**, who was Viceroy for several years, seems to have made important alterations, nothing is known of their extent. It is curious that for such contemporary as are extant of the appearance of the Castle from





---

p.24






the Rebellion of 1641 to the Revolution of 1688 we are indebted mainly to foreign observers. From these, however, it would seem that at least an outward show of splendour was maintained, and that in appearance and equipment the Castle was not unworthy. **Boullaye le Gouz**, who was received at the Castle in 1644 during the first Viceroyalty of the great Duke, then Marquis, of Ormond, describes the Castle as ‘indifferently strong, without any outworks, and pretty well furnished with guns of cast metal;’[42](javascript:footNote('E900000-002/note042.html')) and though he does not describe the interior, it may be inferred from the magnificence of the ceremonial displayed by the Viceroy in going to St. Patrick's on a Sunday, that the decorations were sufficiently sumptuous. Another Frenchman, **Jorevin de Rocheford**, who was a visitor at the Court of the same Viceroy a few years after the Restoration, gives more positive evidence to the like effect:—‘The Castle,’ he wrote, ‘is strong, enclosed by thick walls, and by many round towers that command the whole town; on them are mounted a good number of cannon. The court is small, but the lodgings although very ancient are very handsome, and worthy of being the dwelling of a Viceroy.’[43](javascript:footNote('E900000-002/note043.html')) A few years after this judgment was passed, the interest of the Castle as a relic of the Middle Ages suffered the most serious blow that had yet befallen it. In April 1684, while **Lord Arran** was in residence as Deputy for his father the **Duke of Ormond**, an alarming fire occurred, which only the promptitude of **Arran** prevented from ending in the destruction of the whole building. The fire broke out at two in the morning in **Lord Arran**'s dining-room, and raged for three hours. To prevent the fire from reaching the powder magazine, **Lord Arran**, who acted with great personal vigour and courage, and subsequently received the thanks of the city and corporation for his exertions,[44](javascript:footNote('E900000-002/note044.html')) was obliged to blow up the long gallery built by **Falkland** communicating with the north-east tower. The damage done on this occasion has been graphically described in a letter from **Sir Patrick





---

p.25






Dun** to Doctor, afterwards **Archbishop, King**. ‘The dining room,’ he says, ‘was burnt and blown up, the new building, built by the **Earl of Essex**, my lord's closet and the long gallery, and all betwixt the new building and the tower on which the clock stood.’[45](javascript:footNote('E900000-002/note045.html')) **Arran**, thus burnt out of the Castle, took refuge in the recently acquired ‘King's House’ at **Chapelizod**. Possibly it was by the existence of this alternative that the Treasury justified their refusal to expend money on the repair of the Castle. For there seems to have been an intention at the time to abandon the Castle as a residence. ‘His Majesty has lost nothing’ (so wrote **Arran** to the King) ‘but six barrels of powder, and the worst Castle in the worst situation in Christendom.’ The **Duke of Ormond**, however, lost effects to the value of 10,000£.[46](javascript:footNote('E900000-002/note046.html')) It was proposed to build a palace elsewhere, perhaps on the site of **Ormond**'s intended mansion where now the **Royal Barracks** stand, and a King's letter authorising the sale of the site and materials of the Castle was actually drafted.[47](javascript:footNote('E900000-002/note047.html')) Two years after the fire little or nothing had been done to make good the damage. ‘As for the Castle,’ wrote **Ormond**'s successor in 1686, ‘I can only tell you that as it is the worst lodging a gentleman ever lay in, so it will cost more to keep it in repair than any other. Never comes a shower of rain but it breaks into the house, so that there is a perpetual tiling and glazing.’ No gentleman in Pall Mall, added **Clarendon**, was worse lodged than he was.[48](javascript:footNote('E900000-002/note048.html'))


To continue the history of **Dublin Castle** beyond the date at which the building ceased to be a castle in any real sense of the term would hardly be found of much interest. Down to the Restoration the Castle had continued to be, as truly as in **King John**'s time, the citadel of a metropolis which still presented many of the characteristics of a mediaeval town. Situate at the south-eastern corner of the walls of Dublin, at





---

p.26






the top of the rising ground which commanded the seaward approaches to the city, it occupied for military purposes the point of vantage in any attack which could be attempted. As late as the middle of the seventeenth century the low-lying land to the east of College Green was almost entirely unbuilt on, save for so much of it as was occupied by the precincts of Trinity College, and the population resided almost exclusively either within the city walls or in the southern districts comprised within the parishes adjacent to **St. Patrick's Cathedral**. During the struggles of **Ormond** to maintain the royal authority in Ireland, and again during the Cromwellian occupation, the Castle still remained the military key of Dublin. But with the Restoration all this was changed. The metropolis rapidly expanded, and the Castle, no longer overlooking the sea, as it had done a generation earlier when **Falkland** could descry from it the appearance of two Spanish ships of war in the bay of Dublin,[49](javascript:footNote('E900000-002/note049.html')) became shut in on all sides, so that its defensive value to the inhabitants against the attack of an invader became insignificant. When **James II.** came to Dublin the Castle was hurriedly fitted up by **Tyrconnel** for his reception, but no care whatever was spent on the defences of the building. These had indeed been pronounced worthless very shortly before by the Master-General of the Ordnance, who, in recommending the erection of a citadel ‘on the hills of St. Stephen's Green,’ described the condition of the ancient fortress as being ‘all in rubbish by the late fire,’[50](javascript:footNote('E900000-002/note050.html')) and incapable in any event of securing his Majesty's stores of war without danger of destruction from fire, through being ‘so pestered up with houses’ that the approaches to it were entirely blocked up.


Worthless as a fortress, and undesirable as a residence, the Castle, from the departure of **James II.**, ceased to be of any service save as the seat of the principal public offices. Of the Viceroys of **William III.** none took the trouble to reside for any time in Ireland, and some never came over to





---

p.27






their government. The Lords Justices who governed in their behalf preferred the rustic surroundings of the King's House at **Chapelizod** to the dismal interior of the half-mined edifice whose glories had departed. In **Queen Anne**'s reign, under the administration of the **second Duke of Ormond**, some attempt was made to improve the approaches to the Castle. In 1711 the destruction by fire of the Council Chamber necessitated a consideration of the whole question of the adequacy of the existing accommodation for the public departments connected with the Castle. This was the beginning of radical structural alterations, which, extending through a period of above a century, only closed with the erection of the present Castle chapel in 1814 by the **Duke of Richmond**. In the course of these alterations the King's principal residence in Ireland was entirely transformed from a mediaeval structure into the unimposing group of modern buildings which it now presents.[51](javascript:footNote('E900000-002/note051.html'))


### Appendix I

It seems appropriate to the plan of this attempt to recall the historical associations of the **Castle of Dublin** prior to its eighteenth century vicissitudes, to tell something of the story of the relations of the Castle to the numerous purposes of state, other than those of official residence and seat of government, which in early times the building was made to subserve.
### Note A: The Castle as Parliament House


Besides being the seat of government and the residence of the Deputy, the Castle was also the Parliament House. The early Parliaments of Ireland were of course, like those of England, not necessarily held in the capital. Several of the most celebrated assemblies of the Lords and Commons of Ireland were held at Kilkenny, Trim, Drogheda, and elsewhere, according to the convenience or exigency of the moment. But in general the Parliament met in Dublin. And when it met in Dublin, it met, in early times at least, in **Dublin Castle**, no doubt in the great Hall





---

p.28






so often mentioned in the State Papers.[52](javascript:footNote('E900000-002/note052.html')) In Tudor times, of course, the same reasons that drove the Deputies to **Kilmainham** and **St. Sepulchre's** made it impossible for the Parliament to meet in the Castle. The Abbey of **St. Thomas**, the Carmelite Monastery in Whitefriars Street, and the Cathedral of Christ Church thus became successively the scene of its migratory sittings.[53](javascript:footNote('E900000-002/note053.html')) The first Parliament of **Elizabeth** in 1559 was held by Sussex in the last-named building. But after the renovations carried out by **Sidney**, the Castle again accommodated the High Court of Parliament. The Parliaments of **James I.** and **Charles I.**—probably the later Parliaments of **Elizabeth** also— were there held in spite of the serious explosion of gunpowder which partially ruined the hall in 1596.[54](javascript:footNote('E900000-002/note054.html')) The letter of **Sir Christopher Plunket**, describing the celebrated Parliament called by **Sir Arthur Chichester** in 1613, gives a graphic picture of the scene at its opening,[55](javascript:footNote('E900000-002/note055.html')) on which occasion both Houses were accommodated in the great hall of the Castle which had been specially fitted up for the purpose.


**Strafford**'s Parliaments were also held within the Castle, which continued to be the seat of the Legislature until the Rebellion. A description of the appearance of the two Houses during the Parliament which sat in 1635 has been left by **Sir William Brereton**.[56](javascript:footNote('E900000-002/note056.html')) But the Parliament of 1640 was the last to meet there. After the Restoration the Duke of Ormond changed the place of assembly to Chichester House, the predecessor of the Parliament House in College Green. And with the exception of the Parliament of **James II.**, which was held at the King's Inns, 





---

p.29






formerly the Black Friars, on the site of the present Four Courts, and of those held at the King's Hospital (the Blue Coat School) in 1738-9 during the building of the Parliament House, all Parliaments were held in College Green from the Restoration to the Union.


### Note B: The Castle as the Seat of the Law Courts


The relation of the Castle to the law courts was always intimate. As the language of **King John**'s instructions to **Meiller Fitz-Henry** shows, it was from the first intended that the Castle should be the chief seat of legal administration, and so it continued to be, almost without interruption, down to **Stuart** times. No doubt the Hall of Justice suffered with the rest of the Castle in the early years of the **Tudors**. It appears that a representation was made to **Henry VIII.** by **Alan, Archbishop of Dublin and Lord Chancellor**, that the Chancery within the Castle was ‘no better than a pigsty,’ and orders were given in 1531 ‘for the rebuilding of the Castle Halls where the law is kept, lost the Majesty of the Law should perish, and the Judges be obliged to administer the law on the hills, as it were Brehons or Wild Irishmen.’[57](javascript:footNote('E900000-002/note057.html')) In 1548 the courts were transferred for a brief period to **St. Patrick's**,[58](javascript:footNote('E900000-002/note058.html')) during the suppression of the cathedral chapter. But on the reconstitution of the Cathedral they were restored to the Castle, where they occupied the great Hall or Parliament Chamber. This arrangement, however, was not found convenient, and **Elizabeth** ‘frequently desired that the terms should be removed out of the Castle,’[59](javascript:footNote('E900000-002/note059.html')) where the situation of the courts over the powder magazine was in her time a source of natural apprehension to the justices. Instructions to this effect were given in 1585 to **Sir John Perrot**, who may have desired to utilise the hall in which the courts sat for the Parliament summoned in that year. Nevertheless, it was not until 1607 that the removal of the courts from the Castle was finally ordered. In that year **James I** directed that they should be held in the deserted Monastery of the Black Friars;[60](javascript:footNote('E900000-002/note060.html')) the site of the old King's Inns, and of the modern Four Courts. But, frightened no doubt by the estimate of the cost of equipping the old Dominican Abbey for the purpose designed, his Ministers





---

p.30






were unable to carry out this order. Though made use of as the King's Inns and the headquarters of the Bar, it was not until after a lapse of close on two centuries that the Black Friars site was appropriated to the full use for which **King James** had designed it; and, meantime, his Majesty's Four Courts found accommodation in a ‘sumptuous fabric’[61](javascript:footNote('E900000-002/note061.html')) in the precincts of Christ Church,[62](javascript:footNote('E900000-002/note062.html')) to which they were transferred in 1610.


### Note C: The Castle as Exchequer and Mint


We have seen that the Castle was from the first intended to be the stronghold in which the King's treasure should be guarded, and that in general it was the actual seat of the Exchequer and of the Mint. The Court of Exchequer, however, and perhaps the Treasury itself, was not originally within the Castle precincts. ‘Among other monuments,’ says **Stanihurst**, ‘there is a place in that lane, called now Collets Inn, which in old time was the Exaxar, or Exchequer.’[63](javascript:footNote('E900000-002/note063.html')) And the chronicler goes on to tell in a familiar paragraph the story of a raid by the Irish, in the course of which ‘they ransacked the prince his treasure, upon which mishap the Exchequer was from thence removed.’ The separate Exchequer building can be traced back at least as far as **Henry III.**'s time, and the Pipe Roll for the thirteenth year of that reign has an entry of the expenditure of ten shillings ‘in glass for windows of the Exchequer.’[64](javascript:footNote('E900000-002/note064.html')) It may perhaps have been during the Bruce trouble that the incident commemorated by **Stanihurst** occurred, for from a direction to the Treasurer in 1313 to ‘reside in **Dublin Castle** with the treasure,’ and from the fact that the Castle was in that year repaired and strengthened, it would seem as though the Treasury had previously been situate without the precincts. Thenceforward, at any rate, the Exchequer remained within the walls, though **John de Wilton** is mentioned as late as 1345 as guardian of the works of **Dublin Castle** and of the houses of the Exchequer.[65](javascript:footNote('E900000-002/note065.html'))


The Castle was also long the seat of the **Royal Mint**. From the first establishment of an Irish Mint by **King John** in 1210,





---

p.31






when mints were founded not only in Dublin but in Waterford and Limerick, to their abolition in **Elizabeth**'s reign, the Dublin coinage seems to have been usually struck within the Castle. Several Acts of Parliament in the reigns of **Henry VI.** and **Edward IV.** contain enactments affecting the coinage, and direct the coins to be made in the **Castle of Dublin**. In 1425 John Cobham was granted the office of Master of the Coinage to be made in **Dublin Castle**, with the provision that ‘all the money to be made there should be of the same weight, alloy and assay as the silver money which is made in London.’[66](javascript:footNote('E900000-002/note066.html')) An Act of **Edward IV.**, passed at Wexford in 1463, recites the appointment of one **Germyn Lynch**, of London, goldsmith, to be ‘Warden and Master of our moneys and coins within our **Castle of Dublin** and within our **Castle of Trym**,’ and authorises him to make all the royal coinage. **Lynch**, who was no doubt a Galway man, had previously been permitted to make coins in that city as well as in **Reginald's Tower** at Waterford. Drogheda and Carlingford were also the seats of **Royal Mints** at this period.[67](javascript:footNote('E900000-002/note067.html')) By an Act passed in 1473 **Lynch** was formally appointed Master of the Mint, and it was ordered that ‘the King's coin be struck for the time to come within the **Castle of Dublin** only and in no other place in Ireland.’ A later Act, passed in 1475, while ordering that coins made in Cork, Youghal and Limerick ‘be utterly damned and taken in no payment,’ recognised the Drogheda and Waterford Mints as still legitimate. **Lynch**'s appointment was however revoked, and the profits of the Mint granted to **Gerald, Earl of Kildare**. Coins were still struck in the Castle Mint as late as **Edward VI.** 's time, and **Elizabeth** certainly intended to reopen the Dublin Mint. In 1561 directions were given to the Lords Justices for the erection of a mint in Dublin, which is perhaps the ‘Irish Mint House’[68](javascript:footNote('E900000-002/note068.html')) referred to by **Fynes Moryson**.[69](javascript:footNote('E900000-002/note069.html')) If so, the Mint in **Moryson**'s time still occupied its old quarters, the Lords Justices designating ‘the Castle of Dublin, with the help of the chapel next without the gate’ (St. Andrew's) as the fittest place for the Mint. But, though the prospect of reviving the Dublin Mint was still entertained in **Sidney**'s time, nothing was done to give effect to it either by **Elizabeth** in the remainder of her reign or by her successor. There is some evidence that **Charles I.** intended to restore the Mint, and **Charles II.**, at the instance of the Duke of Ormond,[70](javascript:footNote('E900000-002/note070.html')) certainly gave a patent to coin silver in Ireland. But the Irish Mint was never





---

p.32






re-established, and except for the familiar brass money of **James II.** no coins have ever issued from a royal mint in Ireland since the time of **Edward VI.**


### Note D: The Castle as a State Prison


The most characteristic feature of the Castle as a mediaeval fortress was that it served as the State prison. From the days of **Strongbow** to those of **Strafford**, what is now called Cork Hill was the Tyburn of the Irish capital, and the **Bermingham Tower** was its Tower prison from an early date. It cannot have been from the Castle, but was perhaps from some city gate, that the body of Donnell, son of Annad, was suspended with his feet upwards, and his head placed over the door in 1172, ‘as a miserable spectacle for the Gaedhill.’[71](javascript:footNote('E900000-002/note071.html')) But from the first building of the Castle its battlements were utilised to strike terror into the enemies of the State by the exhibition of the heads of traitors from above its walls. Of this barbarous practice of the Middle Ages there are plenty of examples in the history of the Castle. In 1358 one William Vale, having slain several Irish chieftains in Carlow and its neighbouring districts, ‘brought their heads to the **Castle of Dublin** to be there put up’[72](javascript:footNote('E900000-002/note072.html')); and in the picture of the Castle in the illustrations to **Derricke**'s Image of Ireland the heads of decapitated chieftains appear suspended from the battlements of the Gate Tower.


In early times the prison within the Castle was in the lower rooms of the **Bermingham Tower**, and so continued till the seventeenth century, when it was transferred to the Gate House. The prisons were of course in the immediate custody of the Constable, who, like the Constable of the Tower of London, had the privilege of charging for the keep of provisions and hostages at a higher rate than the Constables of other castles. The earliest mention of the Castle prison to be met with in the State Papers is in 1282, when a sum of two shillings was paid for gyves[73](javascript:footNote('E900000-002/note073.html')); but no doubt the Castle was from the first the State prison, and in general it seems to have also been the gaol for ordinary malefactors.


The inconvenience of making the Castle the common gaol was the subject of frequent remonstrances on the part of the representatives of the Crown during the sixteenth century. For notwithstanding that the new gate of the city had been equipped as a





---

p.33






prison in **Richard III.**'s time,[74](javascript:footNote('E900000-002/note074.html')) the Castle seems to have remained the chief place of detention, and it was not until the reign of **James I** that any steps were taken to alter this arrangement. In that year the King, ‘in consideration of divers inconveniences attendant on the keeping of the common gaol within the **Castle of Dublin**,’[75](javascript:footNote('E900000-002/note075.html')) directed that it should be removed to some other suitable place in the city. But it was judged desirable that the Castle should still be used for the custody of State prisoners, and accordingly, to lessen the inconvenience to the Deputies, it was ordered that a wall should be built ‘separating such persons from the part reserved for the lodging of the Lord Deputy.’ But the cost of making these alterations was found too heavy for the grudging treasury of James to sanction, and though the prisoners were transferred to apartments in the Gate Tower, the work was badly done, and the inconvenience was soon as great as ever. It does not indeed appear precisely at what period the Castle ceased to be regarded as a fitting ward for offenders against the State. As lately as 1715 the Gate Tower of the Castle seems still to have been used for the custody of prisoners. But no doubt, after the erection of the eighteenth century Newgate built in 1773 on the Little Green on the north side of the city, it was no longer found necessary to trespass on the scanty accommodation of the Castle for this purpose.[76](javascript:footNote('E900000-002/note076.html'))


### Note E: The Castle as Record Office


No more interesting associations are attached to the Castle than those which connect it with the guardianship of the records of the State. From very early times, and probably from its foundation, the Castle was utilised for this purpose. In 1304 the Treasury accounts record that the sum of four pence was paid for ‘mending the lock and key of the great vault in the **Castle of Dublin** where the rolls are preserved.’[77](javascript:footNote('E900000-002/note077.html')) Ten years or so later, in the height of the **Bruce** scare, anxiety seems to have been felt for the safety of the archives. Directions were issued to **Walter de Islip**, the Treasurer of Ireland, ‘to observe the ordinance made by the King's Council, whilst the King's clerk John de Hotham was in Ireland, that the Treasurer should reside in **Dublin Castle** with the rolls and other memoranda touching his office.’[78](javascript:footNote('E900000-002/note078.html'))




---

p.34


Of the exact date of the transference of the records from the great vault just mentioned to the **Bermingham Tower** there is no precise evidence; but it is certain that they were kept in the last-named place from the middle of the sixteenth century at least. An elaborate memorandum, drawn up by **John Alan**, Master of the Rolls,[79](javascript:footNote('E900000-002/note079.html')) not long after the suppression of the rebellion of **Silken Thomas**, contains an important recommendation in regard to the safe-keeping of the records; and shows that the most culpable laxity had previously prevailed with regard to them: ‘And, for conclusion, because there is no place so meet to keep the King's treasure as is His Grace's **Castle of Dublin** in the tower called **Brymmyniames Tower**—and where in times past the negligent keeping of the King's records hath grown to great losses to His Highness, as well concerning his lands as his laws, for that every keeper for his time, as he favoured, so did either embezzle, or suffered to be embezzled, such muniments as should make against them or their friends, so that we have little to show for any of the King's lands or profits in these parts; it is therefore necessary that from henceforth all the rolls and muniments to be had be put in good order in the aforesaid tower, and the door thereof to have two locks ... and that no man be suffered to have loan of any of the said muniments from the said place, nor to search, view or read any of them there, but in the presence of one of the keepers aforesaid.’[80](javascript:footNote('E900000-002/note080.html'))


No attention seems to have been paid to **Alan**'s recommendation, for in 1551 the law courts having been removed, as already stated, to **St. Patrick's**, an order was made by the Privy Council for the transference ‘to the late library of the late Cathedral Church of **St. Patrick's**’ of ‘the records and muniments of his Highness's Chancery,’[81](javascript:footNote('E900000-002/note081.html')) on the ground that the tower within his Majesty's **Castle of Dublin** was both ruinous and too distant





---

p.35






from the courts. What effect was given to this order we have no means of knowing. But from the brief stay of the courts in **St. Patrick's** it is unlikely that it was acted on. And it would seem from the terms of the order that in any case only legal records were intended to follow the courts. At any rate the Order in Council specifically directed that the tower should remain the general State Paper repository.


No adequate arrangements were made under **Edward VI.** or **Queen Mary** for the protection of the documents in the tower; and the only effect of the order just referred to seems to have been that the records were disturbed and disordered, and their safety imperilled. When **Sir Henry Sidney** entered on his government he found them, according to **Collins**, ‘in an open place, subject to wind, rain, and all weather, and so neglected that they were taken for common uses.’[82](javascript:footNote('E900000-002/note082.html')) It is to **Sidney**'s admirably efficient administration that we are principally indebted for the preservation of a great portion of the State Papers, and we unquestionably owe to him the establishment of the earliest Irish Record Office. In 1566 he directed **Henry Draycott, then Master of the Rolls and Chancellor of the Exchequer**, to undertake the ‘perusing, sorting and calendaring’ of her Majesty's records, which he had previously ‘well laid up in a strong chamber of one of the towers of **Dublin Castle**.’[83](javascript:footNote('E900000-002/note083.html')) He also appointed, as Stanihurst remarks, ‘a special officer with a yearly fee for the keeping of them.’ **Thomas Cotton, the Deputy Auditor-General**, was the first to hold this office.[84](javascript:footNote('E900000-002/note084.html')) The salary of this earliest Deputy Keeper of the Records was fixed at 10£ per annum. At this modest figure it remained down to the year 1715, when it was enlarged to the more substantial figure of 500£ a year for the benefit of no less distinguished a personage than **Joseph Addison, then Chief Secretary to the Lord-Lieutenant**, and it so continued down to the constitution of a Public Record Office by Statute in 1817.[85](javascript:footNote('E900000-002/note085.html'))


In 1635 **Strafford** drew attention to ‘the want of Treasuries for His Majesty's Records of his Four Courts,’ and his recommendation that a proper office should be built resulted in the provision of a Rolls Office.[86](javascript:footNote('E900000-002/note086.html')) In a vigorous minute **Strafford** pointed out that the legal records having been latterly kept for want of proper custody in the house of the Master of the Rolls, many records had been lost, and more recently burned in a fire which had consumed

 



---

p.36






that official's residence. From this time probably dates the definite separation of the legal records of the country from the State Papers properly so called.[87](javascript:footNote('E900000-002/note087.html'))


### Note F: The Office of Constable of Dublin Castle


From the very earliest times until late in the eighteenth century the Castle was governed by a Constable, an officer of considerable dignity, who was responsible for the security of its defences, and for the safe custody of the prisoners committed to the Grate. The office appears to have been at all times one of high consideration. Like the Constable of the Tower of London, its holder was entitled, as already noted, to demand higher fees for the maintenance of prisoners and hostages than were chargeable in other castles in the kingdom. The earliest express mention of a Constable by name is that of **Simon Muredoc**,[88](javascript:footNote('E900000-002/note088.html')) who in 1245 was directed to give formal possession of the Castle to **Henry III.**'s newly appointed **Justiciary, John Fitz-Geoffrey**. But it would appear that, in 1226, **Theobald Walter**,[89](javascript:footNote('E900000-002/note089.html')) the ancestor of the **Ormond family**, had the custody of the Castle, and may have been its first Constable. One **Hugo de Lega** was Keeper of the Castle in 1235, but the office of Keeper was then, as well as in later times, distinct from that of Constable. The salary of the Constable, exclusive of fees, was twenty pounds Irish, and it seems to have remained at this modest figure as late as the Restoration, when an allowance of ten shillings a day was added.[90](javascript:footNote('E900000-002/note090.html')) At the accession of **George II.** it was again raised, the ‘ancient fee of twenty pounds’ being augmented by an addition of 345£, thus bringing up the full emoluments to a pound a day. But the perquisites must at all times have been valuable. The privilege of residence within the Castle seems to have been highly valued, if we may judge from the petition of **Jaques Wingfield**, who, about 1560, ‘bilded an handsome lodging for himself at his own proper charge.’[91](javascript:footNote('E900000-002/note091.html')) And the Ormonde Papers contain an agreement for the sale of beer 

 



---

p.37






within the Castle on terms which must have been very profitable to the Constable.[92](javascript:footNote('E900000-002/note092.html'))


The defensive establishment of the Castle seems to have varied from time to time, but four gunners and fourteen warders seem to have been the normal complement. The city in early times seems to have been called on to contribute to the cost of defending the Castle, as appears from a fine inflicted in 1312 on **John le Usher**, then Constable, who, having been allowed the cost of maintaining twelve extra men, over and above the ordinary garrison, who were to receive their pay out of the city dues, neglected, ‘contrary to his oath and in deceit of the King and Court,’ to maintain the additional men. The city was likewise called upon about this time to supply the Constable of **Dublin Castle** with ‘twelve good arbalists, with fitting gear and ten thousand bolts’; and in 1315 the Mayor and Sheriffs provided a quantity of munition for defence of the Castle.[93](javascript:footNote('E900000-002/note093.html')) In 1537, **Alan**, the Master of the Rolls, in calling attention to the necessity for the repair of the Castle, recommended that ‘for the custody thereof, and many other dangers, the Constable of the same be an Englishman of England born, whose dwelling shall be continually within the said Castle without appointing of a deputy, and he to be associated with four gunners, of the which number two shall always be present.’[94](javascript:footNote('E900000-002/note094.html'))


### A List of the Constables of Dublin Castle (Compiled from the Liber Munerum Hibernice, the State Paper Calendars, and other sources.)

1. 1226. **Theobald Walter**.
2. 1245. **Simon Muredoc**.
3. 1276. **Henry de Ponte**.
4. 1278. **Peter de Condon**.
5. 1280. **William Burnel**.
6. 1285. **Philip Keling, Junior**.
7. 1293. **John Wodelok**.
8. 1296. **Henry le Waleys**.
9. 1302. **Simon de Ludgate**.
10. 1302. **John le Usher**.
11. 1325. **Henry de Badowe**.
12. 1352. **James, Earl of Ormond**.
13. 1371. **Roger Ocley**.
14. 1377. **John Davenport** and **Richard Ocley**.
15. 1381. **Roger de Levenes**.
16. 1383. **John Barnolby**.
17. 1399. **William le Scrope**.
18. 1399. **William Rye**.
19. 1401. **Jenico Dartas**.
20. 1427. **Christopher Plunkett**.
21. 1450. **Giles Thorndon**.
22. 1453. **Sir Henry Bruen**.
23. 1454. **John Bonnet**.
24. 1467. **Thomas Alfray**.
25. 1474. **Gerald Fitzgerrot**.
26. 1486. **Richard Archbold**.




---

p.38


1. 1533. **Sir John White**.
2. 1543. **John Parker**.
3. 1561. **Robert Tucker**.
4. 1566. **John Bettes**.
5. 1566. **William Denham**.
6. 1566. **Jaques Wingfield**.
7. 1575. **Silvester Cooley**.
8. 1587. **Stephen Segur or Segrave**.
9. 1588. **John Maplesden**.
10. 1591. **Michael Kettlewell**.
11. 1600. **Tristram Eccleston**.
12. 1607. **Henry Piers or Persse**.
13. 1611. **Roger Davys**.
14. 1617. **Roger Davys** and **Robert Branthwaite**.
15. 1628. **Roger Davys** and **Samuel Dargas**.
16. 1635. **Mathew Mainwaring** .
17. 1644. **Mathew** and **Dudley Mainwaring**.
18. 1660. **Sir John Stephens**.
19. 1673. **Col. John Jeffreys**.
20. 1680. **Arthur Turner**.
21. 1681. **James Clarice**.
22. 1684. **James** and **William Clarke**.
23. 1708. **John** and **William Pratt**.
24. 1727. **Thomas Hatton** .
25. 1767. **Henry Seymour Conway**.[95](javascript:footNote('E900000-002/note095.html'))
