

#Guide to Killarney and Glengariff


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Guide to Killarney and Glengariff
=================================


Author: George Newenham Wright
------------------------------


### File Description

Electronic edition compiled by Beatrix Färber

Funded by University College, Cork and  
The Writers of Ireland II ProjectProof corrections by Beatrix Färber

 1. First draft, revised and corrected.Extent of text: 
34000 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland —http://www.ucc.ie/celt

 (2009) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E830001-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

From the preface it is clear that Wright was only responsible for the part of this work dealing with Killarney. Other parts were updated from previous editions by the editors, but the names of the author(s) are not given.

#### Sources


**Descriptions of Ireland**2. Sir William Brereton, 'Carrickfergus visited in 1635'; edited by E. Hawkins. Carrickfergus & District Historical Journal, 4 (1988–89) 11–16.
3. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). [=A translation of portions of 'Les voyages et observations du sieur de la Boullaye Le Gouz ...' Paris, 1653.]
4. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman. Dublin 1846.
5. Thomas Dinely, Observations on a Tour through the Kingdom of Ireland in 1681, Dublin 1858. Reprinted by E. P. Shirley (ed.) as 'Observations in a voyage through the kingdom of Ireland, 1680', Journal of the Kilkenny and South-East of Ireland Archaeological Society, new ser., 1 (1856–1857), 143–146, 170–188; new ser., 2 (1858–1859), 22–32, 55–56; new ser., 4 (1862–1863), 38–52, 103–109, 320–338; new ser., 5 (1864–1866), 40–48, 268–290, 425–446; new ser., 6 (1867), 73–91, 176–204.
6. Charles Smith, The antient and present state of the county and city of Cork: in four books. I. Containing, the antient names of the territories and inhabitants, with the civil and ecclesiastiscal division therof. II. The topography of the county and city of Cork. III. The civil history of the county. IV. The natural history of the same ... Published with the approbation of the Physico-historical society. Dublin: Printed by A. Reilly for the author, 1750. Reprinted Dublin 1774. Reprinted by the Cork Historical and Archaeological Society, with the addition of numerous original notes, etc., from the mss. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W.A. Copinger. Cork 1893–1894.
7. Richard Pococke, A Tour in Ireland in 1752; ed. by George T. Stokes, as 'Bishop Pococke's tour in Ireland in 1752'; Dublin and London 1891.
8. John Mitchell, The present state of Great Britain and North America, with regard to agriculture, population, trade, and manufactures, impartially considered (...). London: printed for T. Becket and P.A. De Hondt, 1767.
9. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1774. Reprinted Dublin/Cork: Mercier Press 1979).
10. Charles Smith, The ancient and present state of the county and city of Waterford: containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1773; 1774).
11. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom: made in the years 1776, 1777, and 1778. And brought down to the end of 1779. London, printed by H. Goldney, for T. Cadell and J. Dodsley, 1780; Dublin, printed by George Bonham, for Messrs. Whitestone, Sleater, Sheppard, Williams, Burnet, Wilson Jenkin, Wogan, Vallance, White, Beatty, Byrn, and Burton, 1780.
12. Charles Vallancey, Collectanea de Rebus Hibernicis. Dublin 1786.
13. George Holmes, Sketches of some of the southern counties of Ireland ... during a tour in the autumn of 1797. London 1797.
14. Sir Richard Colt Hoare, Journal of a Tour in Ireland, AD 1806. London/Dublin 1807.
15. J. C. Curwen, Observations on the state of Ireland, principally directed to its agriculture and rural population; in a series of letters, written on a tour through that country. Printed for Baldwin, Cradock, and Joy. 2 vols. London 1818.
16. Caesar Otway, Sketches in Ireland, Dublin 1827.
**Secondary literature**2. Pádraig Ó Maidín, Pococke's tour of south and south-west Ireland in 1758. Journal of the Cork Historical & Archaeological Society, 2nd ser., 63 (1958) 73–94; 64 (1959) 35–56; 65 (1960) 130–141.
3. Richard Pococke, Richard Pococke's Irish tours; ed. John McVeigh [=McVeagh]. Dublin: Irish Academic Press 1995.
4. Maureen Hegarty, Dr Richard Pococke's travels in Ireland, England and Wales. Old Kilkenny Review: Journal of the Kilkenny Archaeological Society 3 (1987) 388–398.
5. John McVeagh, "Romantick" Ireland: Pococke's tour of Cork and Kerry, 1758. Éire-Ireland, 25:2 (1990) 69–95.
6. Thomas Carte, The life of James, Duke of Ormond: containing an account of the most remarkable affairs of his time, and particularly of Ireland under his government [...] 6 volumes (Oxford 1851).
7. John McVeagh (ed.), Irish Travel Writing. A Bibliography. (Dublin 1996).
**The edition used in the digital edition**2. Guide to Killarney and Glengariff, with six engravings, chiefly from the desgins of G. Petrie, Esq., and a map. George Newenham Wright New edition [133 pages] William Curry Jun. and Company,; Harry Drew, Grand Parade, CorkDublin/Cork (1834)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 1–133. 


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


Some unorthodox spellings have been allowed to stand. Encoding is subject to revision.


##### Quotation


Direct speech is tagged q. Quotations from written sources are tagged cit and may contain qttags. Where the quotation source is identified, it contains bibl tags.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section; div2= the subsection; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd, and tagged.


##### Interpretation


Place-names, personal names, titles (of books etc) and terms are tagged. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: By one or more authors, among them George Newenham Wright (1833) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some quotes from poetry and occasional short phrases are in Latin.


##### Language: [FR] A few phrases are in French.


### Revision History


* (2009-04-06) Beatrix F�rber (ed.)

* SGML and HTML files created.
* (2009-03-26) Beatrix F�rber (ed.)

* Whole file proofed (1); content markup applied. Header modified; file parsed; bibliography compiled.
* (2009-03-23) Beatrix F�rber (ed.)

* Provisional header created.
* (2009-03-18) Beatrix F�rber (data capture/ed.)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E830001-001


### Guide to Killarney and Glengariff: Author: George Newenham Wright


### Preface




---

p.iii


If a traveller look westward from Cape Clear, he may obtain an unimpeded prospect, for fifty miles along a steep and ironbound range of coast, equally imposing for its bold promontories, and for the deep and landlocked bays which stretch far within their mountainous and craggy ranges. Of these latter, four are more remarkable—Baltimore, Dunmanus, and Bantry bays, and Kenmare river, which lie beyond each other westward, in the order of our enumeration. Nearly northward of the last, at the distance of eleven miles, lies Killarney, with all its well-known wonders; thus forming a small angle of this vast mountain country, which nature, regardless of our territorial demarcations, has made *one* in beauty and scenic magnificence. A new line of road, yet in the progress of formation, will unite the several parts of this, and disclose to the tourist a region of natural beauty, which may, in a manner, be called hitherto unknown.


For those who desire to avail themselves of this


---

p.iv



advantage, we offer an outline of the whole tour; indicating, so far as they are yet ascertained, the lines of road, and sketching the more prominent scenes which have any peculiar attraction. To perform this task on a minuter scale would be the subject of no small volume. The splendid mountain and sea views the picturesque glens and vallies the objects of historical or legendary interest are numerous, beyond the scope of the ordinary tourist. These particulars will present themselves variously to the traveller according to his time, and emerge into distinct notice as the country grows familiar. In a few seasons the O'Sullivans, aboriginal lords of Bear and Bantry, may become as renowned in the tourist's tale as their traditionary brethren of Killarney; the geologist's hammer will have echoed from the argillaceous schistus of every valley, and struck sparks from the flint of every summit. In the mean time, the characteristic features of the district the splendid sterility of the mountain side the rude cultivation of the vale the earthbuilt hovel, the real Kerry cow, which (by a peculiarly appropriate Iricism) is only to be found in the mountains of Cork and the flock of goats, forming no mean feature of the upland scene will have told their own tale to the most careless eye.


In drawing up this additional matter, our resources



---

p.v



have been much limited, by the exceeding meagreness of all that has been hitherto published. We have been much indebted to an intelligent gentleman, resident in Bantry; and have, indeed, to regret that his MS. only reached us in time to be available for the purpose of correction, as, owing to the lateness of the season, it became necessary to print without delay. Our best obligations are, however, to a work, which it forms pare of our duty to recommend, as a most valuable accession to the tourist, in every part of Ireland which offers any attraction to curiosity or taste we mean the Sketches in Ireland; a book which may very justly be ranked among the very best which have proceeded from the pen of any traveller in any country. It should be in the hand of all tourists not as a guide but as the spirited companion, and characteristic interpreter; to supply what no guide has yet been found competent to undertake; the refined commentary on nature—the suggestion of thought and feeling appropriate to every varied scene, with all their historic, legendary, and poetical associations: and this in the most effective style, without that small pedantry and trite common place which appear to be peculiar to writers of guide books. From this we have in some measure disencumbered the previously published part of the following pages; and it is our trust, that in addition to the accuracy



---

p.vi



for which this work has been long esteemed, it will be found much improved by the judicious omissions which have been made of notices, too cursory for the uninformed, and too superficial for the instructed. In this remark, we have no design to imply any censure on the writer of those portions which belonged to the former editions. Experience alone could have fully shewn what species of suggestion would be most generally acceptable. And the same experience, which has ascertained the inutility of details, at the same time so scanty and minute, has not less confirmed the laborious accuracy and useful fidelity of the Rev. G. N. Wright.


It is just to add, that this gentleman is in no way responsible for any part of the present edition, except those parts which belong strictly to Killarney. Of this portion much has been cancelled; but though objectionable phrases have been altered, nothing has been substantially added.


ROAD FROM CORK
--------------


In accommodating these notices to the two-fold direction to which the attention of the tourist will henceforth be attracted; it may be observed, that to a certain stage his route must continue nearly the same, to whatever part of this superb region his intent shall happen to be directed. Supposing, then, that the traveller has reached Cork by the usual mode of conveyance, the mail; he will then find a coach ready to start at a quarter past nine the following morning[1](javascript:footNote('E830001-001/note001.html')) for Tralee, by way of Killarney. The town of Killarney is but forty-five miles and one furlong from Cork, and as the coach starts at so early an hour, the journey is made totally in daylight. The intervening country does not possess many attractions of a picturesque description, but acquires much interest from its vicinity to the 



---

p.2



splendid scenery of Lough Lein; at every step, some remarkable remnant of the strength, or ancient splendour, of the feudal castles, and many a venerable monastic pile, excite attention and awaken curiosity. At the distance of four miles and six furlongs from Cork, upon the south side, stands the castle of Ballincollig; it is a large square building, on the summit of a natural eminence of rock, rising perpendicularly in the centre of an extensive plain, in which not another hill, mound, or elevated spot of any sort is to be seen. From its situation it must have been impregnable; the outworks and flanking towers, besides much of the castle, are in a tolerable state of preservation.; The Barretts, an ancient and illustrious family, were the proprietors of this noble castle; the last of these, William Barrett, being concerned in the Earl of Desmond's rebellion, submitted to the mercy of Queen Elizabeth, in the year 1600. Its estimation, as a place of strength, may be gathered from this, that Cromwell constantly kept troops here, and it was also garrisoned in the wars in James the Second's time. Within a short distance of Ballincollig, stand the Castle and Abbey of Kilcrea; the former is in a ruinous condition, but the abbey and steeple are still sufficiently perfect to gratify curiosity, the barbicans, platform, and fosse, still remaining. The monastery was founded in the year 1456, under 



---

p.3



the invocation of St. Brigid, by Cromac McCarthy, the Great Prince of Desmond, who was murdered by his brother Owen, and was interred in the centre of the choir, in 1494, as the inscription on his monument testifies.[2](javascript:footNote('E830001-001/note002.html')) The quantity of human skulls and bleached bones, strewn among the ruins, sufficiently declare the veneration in which the abbey grounds have always been held as a cemetery. The nave and choir are still standing, and there is a very beautiful arcade of three pointed arches, supported by massive pillars of marble, still remaining on the south side of the nave. In the choir are several tombs of the Clancartys and Barretts, whose families have always resisted the total demolition of the castle and abbey. The steeple is only eighty feet in height, nor does it appear to have been more lofty; it stands between the nave and choir, and rests on pointed arches.


The approach to the abbey is really terrific and appalling. A long narrow passage is enclosed by high walls, entirely composed of human skulls and bones, cemented by moss; the gloom and desolalation are increased by the shade of a range of lofty oaks, which are at a sufficient distance to produce an awful gloominess, without relieving the



---

p.4



deadly, melancholy despondence, by the contrast even of vegetable life. There is an old wooden cross, at the termination of the avenue, which has not yielded to the pelting of the pitiless storm during a lapse of two centuries and upwards. This valley of death is watered by the river Bride, which, flowing tranquilly by the abbey, winds towards the north, and falls into the Lee. At the dissolution of religious houses in Ireland, the lands of this abbey were granted to Lord Muskerry, but, after the wars of 1641, Oliver Cromwell bestowed them upon the Lord Broghill. In these wars the castle and abbey were much injured, but were afterwards repaired by Captain Wm. Bayley. Ware says, the Roman Catholics repaired the abbey in 1604. Near the junction of the Bride and Lee stand the Church and Village of Ovens.[3](javascript:footNote('E830001-001/note003.html')) Here is an extraordinary cave, beneath a limestone arch; in some places it is upwards of twenty feet high, in others, not more than six; there are numerous diverging corridors within about twenty yards from the entrance, some of them returning back into the cave, and others continuing to a length as yet unascertained. Strangers should be extremely cautious of venturing into this Cretan labyrinth, without such a clue as Ariadne gave to Theseus,



---

p.5



for the guides are not at all acquainted with the intricacies of this subterranean wonder. The sides and roof are covered with a stalactical matter, or gypsum, which is a most efficacious cement. Persons are said to have proceeded for a quarter of a mile, or upwards, into this grotto in safety, and the peasantry about the village assert, that it reaches as far as Gill-Abbey, near Cork. The next village of consequence is Macroom, fourteen miles two furlongs, from Ballincollig, and nineteen from Cork. The Castle of Macroom, the seat of R. Hedges Eyre, Esq. is a stately building, modernized. It was at first built by the Carews, shortly after the English conquest, though its erection is also attributed to the Daltons. It was repaired and beautified by Teig Macarty, who expired there in 1563, and who was father of the celebrated Lord Muskerry mentioned by Camden. The late Earls of Clancarty rebuilt and altered it, after its destruction by fire in the wars of 1641. When Dean Swift visited this country, he expressed the warmest admiration of this castle and demesne. In one of its apartments was born the famous Admiral Sir William Pen.[4](javascript:footNote('E830001-001/note004.html')) The Roman Catholic Chapel of Macroom is also worth visiting.




---

p.6


At a little distance to the south is seen the Castle of the Two Views; farther on, Drishane Castle, the seat of Captain Wallace; and Mount Leader, the seat of —— Leader, Esq. Mill-street, the next post town, is ten miles and two furlongs from Macroom; it consists of but one street, and could afford but wretched accommodation to travellers. From Mill-street to Killarney, sixteen miles two furlongs, the road winds through a dreary desolate wild of heath and moss. At last, however, the approach to the town of Killarney perceptibly increases in interest, in beauty, and in grandeur, at every step; Mr. Colesman's castle, in a most conspicuous and commanding situation, first attracts the attention; and Mr. Cronan's (the Park) is a very beautifully situated demesne. By the arrangement lately adopted, the coach from Cork arrives at Killarney for dinner.


ROAD TO BANTRY
--------------


We are now to suppose the tourist actuated by a more expansive curiosity, and desirous to avail himself of the new lines of communication, which are at present in the progress of completion. A new road between Killarney and Kenmare, soon to be extended to Glengariff, will fully open to the traveller the whole of this world of scenic



---

p.7



beauty, hitherto but partially known. What may hereafter be the precise order of place observed in visiting this district, must be settled by the experience of a few years: at present, we may consider Bantry as a central stage, from which the many objects of interest in its immediate vicinity are to be visited. A new line of road from this to Glengariff, shortly to be commenced, will complete the whole line to Killarney, offering, through the entire, an unrivalled succession of picturesque objects; and henceforth removing the only defect by which this southern tour has hitherto sustained a disadvantageous comparison with the most splendid scenery in the world; by making it as extensive as it has been always admitted to be beautiful.


Meanwhile, the routes at present most convenient are, either by the mail coach from Cork to Bantry, a distance of seventy-two miles (by Skibbereen); or, if he prefer a private vehicle, and a more picturesque and shorter way, he may take the road already described, so far as Macroom. From this point it will not be necessary to accompany him further on his way, as we shall have presently to notice the principal objects which call for a nearer and more detailed observation, and demand the notice of another day. After passing Inchageela—a village half-way between Macroom and *Gougane* Barra—the



---

p.8



river Lee suddenly expands into the fair Lough Allua. This lake is about three miles in length and a mile in its greatest breadth. From this the nearest prominent object, worthy of detailed attention would be the Lake of Gougane Barra; this, however, lies sequestered from the traveller's eye in the concealment of its lofty hills, and will by and by occur in its order. We may, for the present, therefore, leave our tourist to the comfortable accommodation of Godson's hotel—‘to-morrow to fresh fields, and pastures new.’


BANTRY,
-------


Anciently Ballygobbin, from Gobbin the traditionary founder, and afterwards Bantry from some other equally apocryphal person, is a poor and inconsiderable town upon the eastern shore, and near the bottom of Bantry bay. It contains about five thousand inhabitants. Somewhat more than half a century ago, it was the thriving seat of a prosperous fishery; but the pilchards and some other species of fish having ceased to frequent the bay, the town has fallen into a state of poverty and decay. The principal inns are those of Godson and Marony. Here boats and ponies can be obtained on moderate terms, as also a few cars: this accommodation is not yet as abundant as is



---

p.9



to be desired. Lord Bantry is uniformly obliging to strangers, whom he frequently accommodates with the use of his boat.


VIEWS OF THE BAY
----------------


Before the tourist is introduced to the nearer and more detailed view of this magnificent bay, he will most probably desire to observe its splendid effect as a feature of the surrounding scenery. There are for this purpose many favourable sites. One of the best is on the eastern height of Knuc-na-fiach,[5](javascript:footNote('E830001-001/note005.html')) which hangs immediately over the town, from which, at the same moment, may be seen the two bays of Dunmanus and Bantry. One of the best southern views is from a hill directly before Rindonegan-house. The modern fort behind Gurtenroe-house affords the best central prospect of the bay. Of the general effect of such views, no adequate notion can be conveyed by description: there are, nevertheless, few tourists who may not feel the interest of the scene to be heightened by the perusal of the following masterly sketch. ‘The road from Dunmanus Bay brings you over another parallel mountain-ridge; and after



---

p.10



a tedious ascent, you crown the summit, and at once see the whole panorama of Bantry Bay under your feet; I challenge the British Empire to show such a harbour, or such fine land and sea scenery. Nothing I have yet seen in Wales, or England, or Ireland, is at all comparable to it; perhaps Lough Swilly comes near it but it must yield the palm. It is inferior in climate, mountain outline, and expanse of harbour. Besides, Bantry Bay holds that beautiful gem, Glengariff, within the setting of its wide and gorgeous ring.’


‘As I stood on the southern ridge of mountain, and looked across on a fine clear March day—to the east, in the far blue distance, rose Mangerton, in dark and lofty massiveness: to the left of it, M'Gillicuddy's Reeks, their points piercing the cumulo stratus of the clouds, and leaving you to guess at their mysterious altitudes; nearer still to the north-west, Hungry Mountain rising like an embattled wall before you, and down the mural descent, as relieved from its black ground, fell the cataract of Adrigoll, in a perpendicular column of 800 feet!—nearer still, facing the north, the Sugarloaf mountain, almost as white in its silicious quartzose formation, as if it were chrystalized quartzose sugar; directly under my feet was the inner harbour of Bantry, protected and divided from the outer bay by the green island of Whiddy; and up and down on that placid water were studded isles



---

p.11



and islets, one crested with an ancient castle, another crowned with a modern battery—here a Martello tower, there the ruins of a fishing palace;[6](javascript:footNote('E830001-001/note006.html')) and to finish the setting of this rich jewel, the trees, woods, hills, and fine mansion-house of Lord Bantry, his green and highly dressed lawn, sweeping down in easy undulations to the very water's edge. I cannot say how much I was struck with this delightful tout ensemble. And certainly, as was exemplified here, any thing that is admirable is made much more so by contrast. I had for miles travelled over a dull and dreary way—bare, desolate, unsatisfactory—rocky elevations, or gloomy moors, crowded with miserable huts, a population evidently and fearfully increasing, amidst difficulties and privations altogether insufficient to check its monstrous progress; and I had read Malthus's convincing but gloomy book; and war, pestilence, and famine, terribiles visu formae, rose up in necessary association, as summoned to feast on and make prey in future of this teeming population. It therefore was a pleasant relief, coming down from this district, to rest on the sweet green shores of Bantry Bay, to feast the eye on the wooded hills, with all their herds and deer, of the wooded hills, with all their herds and deer, of Lord Bantry's park, hanging as it does in umbrageous



---

p.12



verdure over this noble sheet of water; and to add to the full keeping of the fine landscape, a large West Indiaman rode in all the quiet repos of the secure and land-locked anchorage.’


BANTRY BAY
----------


This capacious harbour is twenty six miles in length, and in breadth from six to eight—its depth varies from ten to forty fathoms. Its entrance lies between Sheephead point and the mountains of Beerhaven. It contains several islands, of which the principal are Bear Island and Whiddy. Whiddy is nearest to the town: it presents a surface of gentle inequalities, covered by a highly fertile soil. It is about three miles in length, and from one to a quarter of a mile in breadth, and maintains about four hundred and fifty inhabitants. Besides some excellent springs, it has two considerable lakes, one of fresh and the other of salt water, the latter of which abounds with large eels. On this island are three batteries, erected subsequent to the attempted invasion of the French in 1796. It contains the remains of an ancient castle of the O'Sullivans,[7](javascript:footNote('E830001-001/note007.html')) to whom the whole of this district once



---

p.13



belonged. The present proprietor is the Earl of Bantry.


Near the entrance of the harbour, Bear Island lifts its rude, wild cliffs against the south-western storms, affording a shelter, which is not likely to be undervalued by any one who has witnessed the inconceivable fury and mountain volume with which the waves of the Atlantic rush against these rocky barriers. This island is about six miles long, and one in distance from the western shore, forming an interval which is called Beerhaven harbour, on the mainland side of which is the little town of Beerhaven. Beerhaven was formerly defended by a strong castle. It was a place of no small importance in the fifteenth and sixteenth centuries, when the Irish chiefs maintained a frequent intercourse with Spain. The other islands which lie near the town are, Chapel, Horse, Hog, and Rabbit Islands. In exploring this Bay, the informed tourist will find its interest heightened by many traditionary and historical recollections. He will hear or recollect, with a smile, the antiquarian dreams of the venerable visionary **Keating**, according to whom



---

p.14



the antidiluvian Beth landed here, and first took possession of the green island, with three men and fifty women. Here, on a small island, his attention will be directed to the site of a fortress belonging to that consummate statesman and leader, **Carew, Lord President of Munster** in the days of Elizabeth. Here also he will recollect the descent of a French fleet in 1789, under the command of **Monsieur Perrault**, which was only saved from the English fleet under Herbert by the unfavourable state of the wind, which did not permit more than a partial attack. And here also, last not least, he will *recall* the more formidable event of 1796; when this island was providentially rescued, by a hurricane of unparalleled fury, from the most formidable fleet that ever left the shores of France, bearing a force which there was no preparation to repel.[8](javascript:footNote('E830001-001/note008.html'))




---

p.15


Connected with this recollection, and strikingly conspicuous as a feature of the surrounding scenery, appear the fortress and tower, built at considerable expense after this invasion. Of these the best that may be said is, that they add much to the picturesque beauty of the scene; and although they cannot offer the slightest obstacle to future invaders, they may yet add much to the harmless romance of the Vallanceys and O'Briens of remoter generations.


SEACOURT,
---------


The dwelling and demesne of the Earl of Bantry, is within less than a mile from the town. The house contains an excellent collection of pictures. The park, in which it occupies a well selected site, stretches its green and wooded declivity down to the shore. On the opposite side, at the distance 



---

p.16



of about six miles, over a beautiful and lake-like expanse, interspersed with islands,
  

*that like to rich and various gems inlay
  

The unadorned bosom of the deep,’’*

John Milton: Comus, A Mask


  

may be seen the woods of Glengariff, rich with the promise of to-morrow's pleasure; and beyond these a range of mountainous elevations, stretching in grey distance into Kerry. The ancestors of the family of Bantry are said to have entered this country in the middle of the seventh century. The present lord, whose family name is White, was created baron in 1797. In 1800 he was advanced in the peerage by the title of viscount; and in 1816, was created earl of Bantry and Viscount Beerhaven. He is honourably distinguished for his brave and patriotic activity in the troubles of 1796.


DUNEMARC
--------


Half a mile further is the clear but rushing water of Moyalla, the nearest of three streams which run into the northern extremity of the bay. A shaded path from the left of the road will conduct the tourist to the fall of Dunmarc. It may be visited, and that perhaps to most advantage, in the tour of the bay; in which case it must



---

p.17



be approached at highwater, in a row-boat, as the passage to the fall is both narrow and impeded. It lies within the immediate vicinity of the basin, and may be reached in a few minutes row.


The tourist enters through a small cove, between two wooded hills, into a winding channel, on either side of which, the overhanging rocks are richly clothed with heath and tangling ivy, seapink and saxifrage in all the various and luxuriant vegitation of these southern coasts, and deriving encreased brilliancy and freshness from the eternal dews of the Moyallah, where it falls with all its waters in one leap from a height above twenty feet into the sea. On the land approach, Ardnagaschil, the seat of Mr. A. Hutchins, is equally attractive for its graceful and rich lawn scenery; and for the striking points of view which look out over the bay and distant hills, from its fresh lawns and well-shaded acclivities. Westward, along the coast, between this and the river Ouvane, occur in order—Bonnymare, Gurtnaroe, Rindonigan, and Ballylicky cove. From Dunemarc nothing will detain the visiter till he gains Rindonigan lake, on the opposite side of which the height of Carrignachiantau affords one of the best prospects over the bay. On the opposite bank of the Ouvane stands the ruin of Rindisart castle, the stronghold of Sir Owen O' Sullivan,



---

p.18



who erected it to preserve by force the territory which he gained by treachery. It was by **Ireton**'s order demolished by the fire of a ship of war.


Following the coast, the tourist next reaches the little estuary which receives the waters of Coorloum river, where it enters the bay at Snaire. This river is the best supplied of any in the barony with trout and salmon. It offers a marked contrast to Ballylicky cove, in the bold, naked steep which encloses its narrow and winding recess, which penetrates nearly a mile into the country. The peculiar effect of this place is its loneliness and seclusion of aspect. Into this the Coorloum (foam of the desolate) pours, from the dark and rocky labyrinth of its steep banks rising on each side, and almost intermatted above with luxuriant copsewood. About four miles from Bantry, on the river Ouvane, stands the ruin of the castle of Carriganass. In it Daniel O'Sullivan kept garrison in the time of Elizabeth; but, after the conquest of Dunboy, it was surrendered to the queen's forces. It was a high tower with a square court, and flanked with four round towers.


PRIEST'S LEAP
-------------


From this immediate district there are but two outlets into the neighbouring county of Kerry.



---

p.19



Of these, one is well known by the name of the Priest's Leap—a rugged and dangerous mountain pass, through which runs a road leading over Mangerton. This place may be taken on the way to the Pass and Gougane Barra, but is not of itself sufficiently remarkable to demand separate notice. A good road, up the right bank of the river, passes by it; and after a few minutes, the traveller comes upon a narrow glen, from which a sudden turn, round a projecting rock, discloses a deep and narrow defile, winding wildly between mountain cliffs, which appear rent asunder on either side. And he enters the
  


PASS OF COOLEAGH,
  

Remarkable alike for its formidable aspect and terrific associations. Flight, fear, and concealment—lurking rebellion, with its fearful and guilty train, plunder and devastation—shed their frowning and desolate expression around its magnificently stern defiles. This striking scene is so well described by the writer of the Sketches in Ireland, that we cannot hope to offer any thing so true and expressive of its characteristic effect.


‘This deep and extraordinary chasm, which nature has excavated through these mountains, and which, within these last ten years, has been



---

p.20



taken advantage of, in order to make an excellent road between Macroom and Bantry, is really one of the most picturesque things in Ireland. It is well worth a journey to see its rocks and precipices: its cliffs clothed with ivy, and here and there interspersed through the masses of rock, old holly and yew trees, and occasionally an arbutus:—and then its strange and sudden windings. You look back, and you cannot find out how you got in—before you, and you cannot imagine how you are to get forward. You might imagine that the spirit of the mountain had got you into his strong hold, and here you were impounded by everlasting enchantment. Then the surpassing loneliness of the place—’
  

*I never
  

So deeply felt the force of solitude.
  

High over head the eagle soared serene,
  

And the grey lizard on the rocks below
  

Basked in the sun.’’*




‘And now I had arrived at one part of the Pass where an immense square castellated rock, a keep of nature's own construction, seemed to stop up the road for ever. The sides of this natural fortress were clothed and garnished with ivy, maiden hair, feathery ferns, and London pride; and on the very top of the crag, as if its warder, on the very extreme beetling point, a goat, a high-horned shaggy fellow, stood—and how he stood I



---

p.21



could not explain, or scarcely imagine—but there he was in all bearded solemnity. **Salvator Rosa** would have painted for a month gratis, to be indulged with an opportunity of fixing such a characteristic scene, and such accompaniments, on his canvass.’


In the troubled winter of 1822, the Rockites found in this wild and difficult pass a lurking place and stronghold, from which they spread nightly terror and devastation around the country. Here they were with equal bravery and incautiousness pursued by a party, consisting of forty gentlemen, headed by Lord B—y, and accompanied by a party of the 39th regiment of foot, who narrowly escaped being destroyed by the Rockite ambuscade. The story is told with romantic effect by the writer whom we have so often cited;[9](javascript:footNote('E830001-001/note009.html')) but it would be much too long for our present purpose.


GOUGAN BARRY
------------


From this wild pass, a rocky and difficult road turns to the left, and, after a mile and a half of slow and jolting progress, the tourist is struck by the sudden appearance of the lake of Gougan Barry, or hermitage of St. Finbar. This is about seventeen miles from Bantry; and as there is no



---

p.22



inn, the tourist is advised to start early, and not without due provision for the wants of his internal man. This lake is about a mile in length and half a mile in breadth. It lies in a deep circular valley, opening to the east, and on every other point shut in by the precipitous and rocky barriers of the mountains Dereen, Maolagh, Nadanuillar and Faoultena Gouganne. These wild elevations lift up their steep and rugged barriers perpendicularly from the border of the still and solitary water which reflects them from beneath. To convey the awful impression of this wild spot by words, would be a hopeless effort. But if—as is most likely—the reader has seen a small but exquisitely finished painting exhibited by the Royal Hibernian Academy in 1834, he may form some notion of Gougan Barry. In describing the spot, we cannot do better than to avail ourselves of this striking and, we fear not to say, unique picture. The reader may imagine himself looking nearly westward over the lake. Under him, and around his feet, lies a broken and craggy surface, tinged with the red, purple, and yellow tints of moss, heath, briar, and lichen; and glowing with the bright and delicate tracery of the minute objects of a variegated foreground. Beyond this, over a gentle swell of crag and heather, drawn picturesquely across its nearer surface, the lake of Gougan



---

p.23



Barry expands its liquid mirror in placid but stern repose. Overhead the grey and awful forms of the surrounding mountains, project their dark broad sides, half hidden, half revealed, through the transparent drapery of a vast cloud, which has for the last half-hour been suspended over the darkened water. In the middle distance, upon a little wooded islet, one dark object attracts the tourist—it is the ancient hermitage of Finbar; and just while he is gazing, in doubt whether he is awake or asleep, and unwilling by a breath to disturb the strange, lovely dream; from a dazzling cleft in the overhanging mass of purple darkness, a solitary column of silvery light comes down, pure, transparent, and etherial, upon the agitated waters beyond, flooding, as from the cataracts of heaven, a brilliant waterline, against which the antique ruin casts its venerable form, and stands like a picture within its magnificent frame of clouds and crags. Further still, clear but shadowy, dark but coloured with the massive streaks of heather and rock, and softly fading away in airier indistinctness, cliff after cliff recedes into the purpling gloom; through which, here and there, shooting from some polished surface upon the heights, a gleam of arrowy sunshine, quivers through the misty air. The tourist now, good easy man, convinced that it can be nothing more or less than a dream, and resolved to have his nap out, is settling



---

p.24



to another hour of staring somnambulism, when a voice is heard at his ear, cursing the obtusity of that little heedless member, and urging him forward to explore the island retreat of the ancient Hermit. By this time, however, the cloud that obscured the mountains has withdrawn its heavy volume from their giant sides, and they stand revealed in their savage grandeur and rugged repose, grouped in wild variety around—bare, and broken into grey craggy masses, intermingled with wild patches of shrubby copse, or marbled with rocky veins, the geology of which the tourist may settle for himself.


In the mean time, the island is gained. Here are many objects which will attract attention, but which require no explanation, and may be left to tell their own stories. A holy well will explain its uses by its votive rags; and the primitive materials and rude masonry will tell at first glance that centuries must have passed over the ruins of St. Finbar's dwelling, with remains of which the isle is covered. Here the anchorite flourished (as old books say) some time or other before Cork was built, as he is said to be the founder of that city and its cathedral. A long succession of venerable anchorites occupied his dwelling and imitated his virtues; of whom the last was Father Denis O'Mahony. There is an annual patron held in this island, and it is, or has been, the frequent



---

p.25



quent resort of pilgrimages. The Roman Catholic clergy have latterly discountenanced these superstitious practices.


Near the lake is the little village of Rosalucha, consisting of a few poor huts, which relieve without breaking the solitude of the vale. West of the lake may be seen a narrow recess—it is the entrance to a little valley, which we recommend to particular notice. ‘The Ethiopian valley,’ says the author of the Sketches, ‘that Johnson, in all the richness of his language, describes as the abode of Rasselas, was scarcely more inapproachable on every side. The little level vale lay before me, a lovely green meadow, a comfortable farm-house, with all its offices and homesteads, cows, and horses, scattered depasturing about—a flock of sheep grouped on a little green knoll—a herd of goats on the accessible parts of a ravine, that conveyed a tumbling torrent from the western side of the mountain. Eastwards, from about the centre of the precipice, as from the heart of the hill, flowed the fountain of the river Lee—it came welling, as if from the entrails of the mountain: and northward, on an inaccessible ledge, was an eagle's nest, and one of those lordly birds towering on poised wing in his 'pride of place,' challenged, with shrill and echoing voice, the honours of his sovereignty.’




---

p.26


GLENGARIFF
----------


A pleasant drive of about eleven miles from Bantry, round the bay, will bring the traveller to the bay of Glengariff, (the rough glen.) Across Bantry Bay the distance is about nine miles. It has an excellent inn, with guides, ponies, arid boats in abundance.


Many have laboured to describe Glengariff—among these the writer of Sketches in Ireland has alone so far succeeded, as to have caught, and in some degree conveyed, the spirit of the scene. But it must be felt, and that in proportion to the competency of the observer, how inadequate all description must be, to communicate a just impression of this unique spot. Bays and wooded glens, lakes and mountains, have just so much general resemblance to each other, that to any one who has ever looked on the doings of nature, a few words may convey a sufficient idea of most of her varieties. A peculiar effect may be happily hit by some new and well-combined sentence—a novel combination may be described, a characteristic feature happily seized on, so as to conjure up to the mind's eye, as it were by the magic of a word, a whole chain of picturesque associations. But who can enumerate the features of Glengariff—what pen can sum into a sentence the singular



---

p.27



and wild effect of all the wonders of a spot which has no scenic parallel, and which can be only wronged by comparison? To conceive, without actual observation, some remote impression of this strangely beautiful wilderness of rocks and woods, the reader must first imagine the vast waves of some universal earthquake, by which the primeval world may have been rocked to ruin, suddenly to have been suspended at their height; and while the rest of nature was composed into the smooth undulations of hill and valley, left as an eternal monument, to speak of what has been, and bear a terrific impression of that hand in which the world is as dust in the balance. This, however, conveys no adequate idea—it is but half a thought. The scene is not more terrific than beautiful—not more rude than adorned by art—not more bearing the aspect of primeval ruin than the fresh, green, wild variety of sylvan life. ‘And now suppose,’ writes the Sketcher, ‘that in every hole, indenture, crevice, and inflection of these rocks, grew a yew or holly: there the yew with its yellower tinge; and here the arbutus, with its red stem, and leaf of brighter green, and its rough, wild, uncontrouled growth, adorning, and at the same time disclosing the romantic singularity of the scene.’


It is with just discrimination observed by the same admirable describer, that ‘the family of



---

p.28



 
Glengariff castle[10](javascript:footNote('E830001-001/note010.html')) have shown admirable judgment in simply giving a helping hand to nature. All that was wanting was to turn morass into good soil, and heath into a carpet of green grass to lay out walks through woods, under banks, and around precipices: and taste has directed, and money executed all this; and thus the most interesting lawn in Ireland (as I apprehend) has been formed:
underneath, the bay studded with islands, on one of which the government has been graciously pleased to erect a most picturesque Martello tower. One would think that Mr. W——, if such a thing were possible, had bribed the engineer who located these fortresses, to build here, just by the way of keeping in awe the herring fishermen—but in good truth to crown a prospect.’


The Bay of Glengariff is shut in by a small island, ornamented, as mentioned in the above description, with a tower. From this it receives the appearance of a lake—far more beautiful than any lake in effect. Around this, projecting their rough masses, or receding into distant air, appear mountains, ‘of all forms, elevations, and outlines. Hungry Mountain, with its cataract of eight hundred feet falling from its side; Sugar-loaf, so conical, so bare, so white in its quartzose formation; Slieve Ghoul, the pathway of the fairies; and Esk



---

p.29



Mountain, over which I was destined to climb my toilsome way: every hill had its peculiar interest, and each, according to the time of the day or the state of the atmosphere, presented a picture so mutable—or bright or gloomy, or near or distant—valleys laughing in sunshine, or shrouded in dark and undefined masses of shade; and so deceptive, so variable, were the distances and capabilities of prospect, that in the morning you could see a hare bounding along on the ranges of those hills, that, at noonday, were lost in the grey indistinctness of distant vision.’


The road winding round this bay presents at every moment some new combination. We would recommend the tourist to proceed to Coolranny bridge, every furlong of which offers some peculiar variety of mountain magnificence or sylvan richness.[11](javascript:footNote('E830001-001/note011.html')) The ascent up Ghoul Mountain will repay him by another of those vast perspective views of mountain and marine scenery, of which we have already given some specimens, as he may from thence obtain an unimpeded prospect over mountains and bays, till his vision is



---

p.30



arrested by the shadowy blue outline of Cape Clear in the western distance. A footpath by the river offers an astonishing variety of picturesque combinations, which shift with magical effect at every turn along its fantastic windings. Lord Bantry's lodge is situated on a little islet within this river. The rustic bridge by which it is entered is built from the timber of a French ship, belonging to the fleet of 1796. Two miles beyond this cottage is the Eagle's Nest; it must be approached on foot or horseback. The cliff on which the eagle builds rises to an elevation of about five hundred feet. The interest of this spot is heightened by a romantic story.


‘After the sack of his strong hold, O'Sullivan, with his wife, children, retainers, and cattle, took shelter in the woods of Glengariff. Tyrrel and O'Connor Kerry held communication with him along the ridges of Slievelogher. Eugene M'Egan, the Apostolic Vicar, was in the centre of the McCarthys of Carbery. But the Lord President was not to be withstood; and his Lieutenant, **Sir Charles Wilmot**, who was as good a guerilla as Tyrrel, and who knew the fastnesses of Slievelogher and Desmond, as well as if he were the son of a Sullivan, surprised the O'Sullivans in Glengariff. The Prince of Bear and Bantry, amidst his own rocks, bogs, and woods, fought in the face of his wife, children, and people;—the battle was



---

p.31



for the defence of the cattle, their only subsistence—their all. Through the whole Munster war, never was a field so desperately contested. From rock to rock, and ridge to ridge, the Irish suffered the assault of the English; and still the well-armed and fearless assailants carried one position after another, until the O'Sullivans gave way, and scattered over the hills, like sheep, leaving their herds a prey to the spoiler.’


‘And now Tyrrel, finding the left of his position on Slievelogher turned by Wilmot—perceiving the game was up in Munster, and hopeless of farther Spanish aid, with the decision and despatch for which he was so notorious, retreated along the eastern parts of Kerry, through Limerick, Ormond, Ely O'Carrol, until he reached in safety, with all his partisans, his own country. O'Sullivan still clung with craving hope to his native rocks; but winter coming on, famine stared him and all belonging to him in the face—for **Wilmot** had wasted all Bear, Bantry, and the whole of Kerry—not a cow, garrane, goat, or sheep did he leave from Slieumiss to Glenflesk. O'Sullivan, therefore, consigning his wife and children to the care of his faithful gossip, Gorrane McSwiney, determined to follow Tyrrels example, and retreat to the confederates that still held out in Breffny and Ulster. He, therefore, trusting in God and the Catholic cause, set out in company with William



---

p.32



Burke, O'Connor Kerry, and one hundred faithful and veteran Bonnaughts.’


‘Gorrane, whose whole soul was in his charge, returned with them to a boolie he had set up under the foot of the Eagle's Precipice at Glengariff. This boolie or hut was so contrived that Wilmot and his Saxon devils, (as Gorrane called them,) might scour the mountain over and never see it, or suspect that there was in such a desert, a human habitation. It was erected against the face of a rocky ridge, the roof sloping down till it touched the moor, was covered with scraws and sods of heath, so that the place was undistinguishable from the shelving slope of the mountain, and the entrance a long, distant, and winding passage in the rock, and charcoal burned on the hearth for fire—it was secure from suspicion. But how was the princess of Bear and Bantry to be supported—not a cow was there to give milk, no corn, nor root, nor pulse. Gorrane had one salted salmon wrapped up in a cow's hide; that was all his provision when they entered the boolie, and where to go to seek for food, Gorrane knew not under heaven—famine had spread over the land: as Spencer says, ‘the people of Munster were brought to such wretchedness, that even a heart of stone would have rued to see the same; for out of every corner of the woods and glynnes they came creeping forth on their hands and knees, for



---

p.33



their legs could not bear them; they looked like anatomies of death; they spake like ghosts crying out of their graves; they did eat the dead carrion, happy were they when they could find them; yea, and one another, sometime after; insomuch that the very carcases they spared not to scrape out of their graves, and if they found a plot of watercresses or shamrock, there they flocked as to a feast.’’


‘In this extremity of desolation was the southwest of Cork and Desmond, when Gorrane took home his charge to his boolie, and the poor fosterer knew not what to do—all his trust was that God was good, and the Virgin Mother, his protectress, would not fail him in the hour of his need. And as thus one morning he was ruminating, he rambled under the precipice where, year after year, the eagles of the valley had nested and reared their young; and, looking up, he saw one of these huge birds sailing, on steady wing, with a hare within its talons, and now it alighted on its rocknest, and anon the young eagles were shrieking with triumph over the divided prey. ‘Arrah, now, is it not the greatest pity in life that these young hell birds, that look for all the world like the childer of these cramming beef-eating devils, the Saxon churls—my heavy curse light upon them all—that these greedy guts should be after swallowing the game that nobody has any right



---

p.34



to, but O'Sullivan; and my sweet mistress, and her little ones, all the while starving. Now, it's I that have a thought in my head, which no living soul but the Virgin herself could have put into it, and it's myself knows what I will do.’ So home Gorrane went, and all day long he was seen busy twisting firmly, with all his might, a rope made from the fibres of bog-fir, and, towards evening, he took out from his store his salmon, and gave the greater part to be broiled for supper, and, long before the following day-break, Gorrane got up from his bed of heath, and he awoke Phadrig his son, a boy of about fourteen years old: ‘Phadrig, avich, get up; come along with me.’ The boy, light and active, was beside him in an instant, and out they both started—the father with his wooden rope in his hand. Just as the day was breaking, they came to the brink of the mountain ridge that ascends from the precipitous valley, where the eagles build their nest; and just as they arrived at the verge of the chasm, they saw the old eagles soaring away to meet the sun and to seek for their prey over land and sea. ‘Phadrig, a cushla, look down there,’ says the father, ‘look down below, and see that bird's nest—down there you must go, by the help of this rope, if you have any regard for the life of the mother that bore you, and of the sweet mistress, for whom we are bound to live or spend our blood and die.’’




---

p.35


‘‘You must go down, by the help of this rope, and tie these straps that I will give you round the necks of yonder gaping greedy guts; don't choak them for the life of you, but just tie their ugly necks so tight that not one morsel can they swallow.’ ‘And now, father, sure it's I myself that would desire no better sport than to get down and wring their necks off, and bring them up to you; but sure, father, the Lady O'Sullivan must be cruel hungry when she would eat eagles.’ ‘O, that would not do at all at all, Phadrig, jewel; that would be the spoiling without cure of the whole thing—no, my honey, handle them gently, treat the nasty things as if they were your mother's daughters—only do, Phadrig, just as I bid you.’ ‘Well, father, mind you hold tight, and I will do your bidding.’ So Gorrane fastened well the rope about the boy's waist and between his legs, and down he lowered him, in the name of God and all the saints. The youth soon got to the nest—as he was bid, tightened well the necks of the young eaglets, so that they could not swallow, and then he was safely drawn up. For an hour or two the father and son waited near the nest, and at length were gratified with seeing the old ones come soaring down the wind, one with a rabbit, another with a grouse in his talons, which they deposited in the nest, and, after a time, flew away.’




---

p.36


‘‘Now, Phadrig, avourneen, down with you again, and, to be sure, it's I that will hold you tight; gut the game, throw the garbage to the young ones it's right and nathral they should have it and bring up, under your two arms, O'Sullivan's rightful property.’ All this the boy did, with address and expedition; and in this manner were the family in the boolie fed, until the English retreated from the country, and the wife of O'Sullivan and her faithful followers could reach a place of more plenty and security.’ Beyond this, Ghoul (or Sugar Loaf) is about two miles.


HUNGRY HILL
-----------


The next place which calls for separate notice is the waterfall of Hungry Hill. This is in a direct line across the bay, about fourteen miles from Bantry. The waterfall issues from a small lake on the summit of the hill, which is said to be two thousand feet above the level of the bay. Something is to be deducted from this height for the elevation from which the hill may be considered as rising; but the unimpeded fall of a prodigious column of water down a precipice of seven hundred feet from the summit, needs no addition of height to place it among the wonders of the natural



---

p.37



world. After this, the water comes into collision with the craggy projections of the mountain side, and thunders on its impetuous course—a broad torrent of foam, and mist, and refracted sunbeams—from height to height, till it gains the declivity at the mountain base, from which it tumbles into the bay.


GLANNMORE, CAHA, &c.
--------------------


A few miles north of this, in the valley of Glannmore, is a lake, which is by some thought to be superior in beauty and picturesque effect to any other of the western lakes. North-west of Lord Bantry's lodge, are the lakes of Caha—of which there is one for every day in the year—famous for their legendary associations. Of these one is also observable for its scenic attractions.


These last mentioned places may be all visited from Glengariff, and will require about three days. Of these the first may be given to the Glen, including Mr. White's demesne; the Eagle's Nest, Ghoul, and the Lakes of Caha, the second; and Hungry Hill, with Glannmore, the third.




---

p.38


BEARHAVEN, DUNBOY
-----------------


From Glengariff and Hungry Hill the tourist's attention will turn, with eager impatience, to Killarney; and we may now suppose him once more directing his attention to the Pass. In the meantime, it will not be unacceptable to him to learn, that if he had been led to pursue his progress along the bay, he would find little to repay him for the added fatigue and delay. On the mainland, opposite the Island of Bear, stands the old town of Castledermot, south-east from which stood the celebrated fortress of Dunboy, which was taken by **Sir George Carew**, in 1602, after an obstinate resistance—an event of no small interest in the deeply discoloured thread of Irish history, as leading to the immediate termination of the barbarous and exterminating warfare of which that period and these wild scenes were the place and time. In conducting the traveller through this portion of his route, we have purposely abstained from those lengthened separate notices of traditionary personages, in whose half legendary existence no one on earth feels any interest, save that which it derives from the ornamental addition of romance. Of this we acknowledge the mysterious charm, and would most gladly contribute our mite to the traditionary



---

p.39



interest of the country of the O'Sullivans, by the recital of a few veracious histories of our own especial invention, but that, upon reflection, it occurs to us, that a few additional sheets, and a few additional shillings, could add but little to the appropriate character of our little book—namely, its established credit for strict veracity. It is a fault but too often committed by the guide, to interlard his pages with notices of this nature, too brief to convey any information or excite any interest. For such notices of the history of this district as can add any thing to its local interest, we must refer to our worthy coadjutor, the author of Sketches in Ireland. Nor can we imagine that the little less ingenious historian, **Mr. Crofton Croker**, to whom the fairies of Kerry are so everlastingly indebted, will fail, in due time, to earn the like meed of approbation from the fairies of Cork. In the meantime, the curious reader may be referred to our own Irish History of the Fairies,—a work which we are now preparing, or intending to prepare, for the press—as we have for some time anxiously awaited to see to what extent the idea of our magnum opus is to be anticipated by Mr. Moore's forthcoming history.




---

p.40


ROUTE TO KILLARNEY
------------------


We may now suppose the tourist bound for Killarney, to which he may have a choice of routes. He may return to Macroom, in which case he can have the advantage of the mail, which leaves Bantry every morning at six. By this way the distance would be about sixty miles; or he may shorten his way by twenty-six miles, by going to Kenmare by Priest's Leap, upon a road which, though it has been of late repaired, must always remain incommodious, on account of its rocky surface. Or lastly, he may select the line by Esk Mountain, a medium distance of forty-six miles. This, which is the new line between Glengariff and Kenmare, has much to arrest the eye, though little which calls for detailed description. The traveller's curious notice will be awakened by the perforation of a tunnel, of a hundred yards, through the side of Esk Mountain. This forms a portion of the range, along the summit of which is the boundary line between the two counties of Cork and Kerry.


KENMARE, OR NEDEEN,
-------------------


Is a neat little town on the banks of Kenmare river, which runs into a bay called by the same



---

p.41



name. Here a metal bridge will be passed, the building of which cost about two thousand pounds. The bay is about twenty miles in length, and three across. This town is eleven miles and a half from Killarney.


From Kenmare the road increases in interest at every mile, as the loftier ranges of the Kerry mountains swell into more imposing elevation, and expand the prominent outlines of their broad and craggy masses to the approaching eye. A view across the Upper Lake is soon gained. The new road, turning to the right, winds its picturesque way from one enchanting prospect to another, between the mountains and the lakes, for a circuit of nearly ten miles. Thus effecting, in the act of travelling alone, half the tour of the lakes, and adding a day of no small enjoyment to the period of the tourist's visit. The course of this new road lies by Mr. Hyde's cottage, between the Denycunehy mountains and the Upper Lake, and between Turk mountain and Turk lake. Having passed this latter about half a mile, it turns northward by Castlelough bay, and over the Flesk river into Killarney. In this route most of the objects which particularly attract notice, are the same which are noticed in their places in our further progress. We may, therefore, pass at once to the town; for the blue smoke of which, rising over the trees of the Earl of Kenmare's



---

p.42



demesne, will, for a few hours, suggest other thoughts than belong to cold water and blue mountain scenery.


TOWN OF KILLARNEY
-----------------


The town of Killarney consists of two principal streets, called the Old and New streets; it was first brought into notice, as a place of trade, by the iron works in its vicinity; and the improvements effected by the encreased expenditure, while the mines were worked, are still obvious in the comfortable appearance of the town in general.


There are three tolerable inns, two in the main street, nearly opposite the church, and the Kenmare Arms in New-street. Of these one is agreeably situated, immediately opposite to the church. Near this inn is a public reading room, to which strangers are politely invited, by a singular advertisement upon the door, stating, that ‘None but Members, or Strangers, are admitted.’ The church contains a few handsome monuments, has a pretty specimen of stained glass in the eastern window, and is in excellent repair. The exterior has been so much altered from the original elevation, that it is a continued succession of contradictions to all the laws of architecture.




---

p.??




---

p.??




---

p.43


The Roman Catholic chapel stands in Newstreet, and beside it is the residence of the titular bishop. Shaded by a screen of arbutus, laurels, and jessamines, trained against the chapel wall, is a very attractive inscription, upon a beautifully designed, and well executed monument. A marble urn, partly concealed by a funeral pall, rests upon a sarcophagus, on the pannel of which is a beautiful and pathetic epitaph, on a Roman Catholic bishop of Kerry, written by a clergyman of the Established Church. There is a nunnery also in this street, and a very numerous school of poor children in that by which the Cork mail enters.


The hall of Kenmare house is flagged with very beautiful marble, raised on the lands of Cahernane, and at either end are busts of his Grace the Duke of Wellington, and Field Marshal Blucher. The ball room is the largest apartment in the house; the walls are hung with tapestry of rather inferior merit to that at Kilkenny castle, or Tyrone house, in Dublin; in this room is a table made of a single plank of yew, more than three feet broad. Over the chimney piece is an admirable painting of Apollo crowning Handel. On the principal staircase stands an admirable bust of the late Henry Grattan, by Turnerelli, and another of George II. In the attic story is a private chapel for the celebration of divine service, according



---

p.44



to the rights of the Roman Catholic church.


The gardens, which are separated from the lawn by the Mucruss road, are new, and in excellent order, but derive no advantage from their vicinity to the enchanting scenery of Lough Lein.


The first thing to be resolved upon, on arriving at the inn, is the route that is to be adopted for the following day. If it be the gap of Dunloe, horses are to be provided, which are to be had here on much more reasonable terms than in Westmoreland; but if the intention be to visit the Lake, the cockswain who steers the boat, the bugle-man, gunner, &c., are to be sent for, and directed to be in readiness. And here, certainly, the most disgraceful circumstance connected with a visit to the Lakes of Killarney is discovered: the hire of a boat is a very extravagant sum in the first instance, but this the cockswain or boatmen cannot interfere with, the boats being the property of Lord Kenmare, from one of whose stewards they are procured; but, in addition, the boatmen and cockswain (five persons at least) are to be paid two shillings each for their labour, a bottle of whiskey a man, with dinner for the entire party, including a bugleman and fisherman. How different from the modest charges of Derwent and Windermere! The boats are large,



---

p.45



convenient, and in excellent order, but without cushions.


The greatest inconvenience, however, chargeable upon Killarney, is the distance of the town from the Lake. It was not possible to have fixed, in all the neighbourhood, upon a worse situation for the site of a village; the backs of the houses are turned towards the Lake, the view of which is totally excluded by Lord Kenmare's woods, and but for the supply yielded by a few wells, there would not be any fresh water in the village, although there are rivers at a short distance on every side. It is very unpleasant to have a mile of uninteresting road to pass every morning before reaching Ross bay; but this is actual pleasure compared with the annoyance of having the same road to return at night, after the fatigue of ten or twelve hours exercise, and, probably, drenched by the breakers, if the weather should be stormy. Here, again, the English lakes have the advantage in accommodation for travellers, which he who has visited Coniston Head, the Ferry House, or Lowood upon Windermere, will acknowledge.


LOWER LAKE—ROSS ISLAND,
-----------------------


Which is the most considerable of those in the Lower Lake, containing about eighty plantation



---

p.46



acres, is connected, by a causeway and bridge, with the main land: in summer, the morass, separating the island from the continent, is completely dry; but in winter, Ross becomes again perfectly insulated. On this island, or rather peninsula, stands Ross castle, which held out so obstinately, under Lord Muskery, in 1652, against the English, commanded by General Ludlow.


Upon the 26th of July, in that year, at Knockniclachy, in the county of Cork, a battle was fought between Lord Muskery, at the head of the Irish, and the **Lord Broghil**, commander of the English forces, in which the former were defeated with great slaughter, and Colonel Mac-Gillicuddy, a native of Kerry, and greatly beloved by the Irish, slain. Upon this defeat, Lord Muskery withdrew to Ross castle, whither he was followed by **General Ludlow**, with a body of four thousand foot and two hundred horse.[12](javascript:footNote('E830001-001/note012.html')) This experienced officer and upright statesman thus describes the siege of Ross castle:—‘In this expedition I was accompanied by the **Lord Broghil**, and **Sir Hardress Waller**,[13](javascript:footNote('E830001-001/note013.html')) major-general of the foot. Being arrived at this place, I was informed that the enemy received continual supplies from those parts that lay on the other side, and were covered with woods


---

p.??




---

p.??




---

p.47



and mountains; whereupon I sent a party of two thousand foot to clear those woods, and to find out some convenient place for erecting a fort, if there should be occasion. These forces met with some opposition, but at last they routed the enemy, killing some, and taking others prisoners; the rest saved themselves by their good footmanship. Whilst this was doing, I employed that part of the army which was with me in fortifying a neck of land, where I designed to leave a party to keep in the Irish on this side, that I might be at liberty, with the greatest part of the horse and foot, to look after the enemy abroad, and to receive and convoy such boats, and other things necessary, as the commissioners sent us by sea. When we had received our boats, each of which was capable of containing one hundred and twenty men, I ordered one of them to be rowed about the water, in order to find out the most convenient place for landing upon the enemy; which they perceiving, thought fit, by a timely submission, to prevent the danger that threatened them; and, having expressed their desires to that purpose, commissioners were appointed on both parts to treat.’


The garrison of Ross castle was greatly intimidated, and urged to a surrender, by the appearance of an armed vessel floating on lough Lein; for there was a prophecy amongst the inhabitants,



---

p.48



that the castle would not be taken until a vessel of war was seen to swim upon the Lake. The fact is, that nothing would have been more improbable than that a ship of war should ever have appeared upon the Lake of Killarney; and had it not been for the unerring energy of Ludlow, in the discharge of his trust, the long boats, sent by the parliament to Castlemain, had never been hauled up shallow streams, and carried over rugged tracts of land.


The surrender of this castle terminated hostilities in Munster, and induced about five thousand of the Irish to lay down their arms. The conditions of the treaty of Ross castle were accurately fulfilled by parliament, by which **Lord Broghil** was granted one thousand pounds yearly, out of the estates of Lord Muskery. The castle, which was built by the family of O'Donoghoe-Ross,[14](javascript:footNote('E830001-001/note014.html')) is now an important ruin, standing upon a rock: it consists of a lofty, square building, with embattled parapets, formerly enclosed by a curtain wall, having round flankers at each corner, the ruins of which are yet visible. The interior possesses some extremely well proportioned apartments; and from the battlements may be had a most extensive panoramic view of



---

p.49



Mangerton, Turk, Glenà, and all the surrounding scenery. A small building has been erected against one of the side walls of the castle, for the accommodation of an officer and a company of men, which does not harmonize very well with the general character of the scene, and is particularly hurtful to the eye, in looking from Inisfallen towards Mangerton. There is a governor also on the establishment of Ross castle; and a garrison was kept here in 1690, in the wars between William and James. (See Articles of Limerick.)


The Island of Ross is of considerable extent, and though the woods were cut down in 1803, they have sprung up again sufficiently high to upbraid their destroyer and delight the admirer of the beauties of nature. On Ross island are to be found great varieties of trees and plants, oaks, yews, &c. Amongst the plants are the spleenwort, the true-love, or one berry, which the peasantry make use of as an excellent specific in malignant fevers; the tutsan, or park leaves, which is supposed to possess healing powers: the raspberry-tree; the common mother-thyme; the service-tree, &c.


Here lead and copper are to be had in great abundance; and though the working of the mines is discontinued, yet it is rather for want of capital in the proprietors, than from a deficiency of ore.



---

p.50



These mines were worked at a very early period, and some of the rude implements used for breaking down the ore, are to be found on the island; they are large oval stones, quite smooth, and round the centre of each is a mark, evidently caused by the fastening on of a convenient handle: they are called, by the country people, **Dane hammers**, a belief still existing that they were formerly used by those invaders. Besides the various ores, there is a vein of tolerably rich marble in the centre of the island, used frequently by the peasantry for tomb-stones, which they seldom omit placing over the remains of their relatives.


The shores of Ross island are beautiful and interesting in the extreme, being deeply indented, and possessing endless variety of commanding promontory, and retiring bay; the rocks along its margin are worn into the most fanciful shapes, for every group of which the helms-man is supplied with an appropriate appellation; the most aptly denominated are those to be seen in passing from Ross bay to Inisfallen, called the Books.


Immediately opposite the little wharf, erected for convenience of strangers embarking, is Lord Kenmare's boat-house, where a number of large boats, in excellent order, are sheltered and preserved for the public use, the deep water, at that side of the bay, being the most desirable for this



---

p.51



purpose. Near the boat-house is a spot from whence the effect of a bugle, with the mouth directed to Ross castle, infinitely exceeds any other echo to be met with about the Lakes; the first echo is returned from the castle, the second from the ruined church of Aghadoe, the third from Mangerton, and, afterwards, innumerable reverberations are distinguished, which appear like the faded brilliancy of an extremely multiplied reflexion, lost by distance and repetition.


Besides having the advantage of an expanse of water, with a tranquil surface, such as Lough Lein possesses in a mild summer's evening, the castle is situated in the *centre* of an amphitheatre of mountains. For these reasons it is, that the return of sound from Ross castle, at evening time, will be found more curious than in any other situation about the Lakes, contrary to the general belief, and of this the tourist can satisfy himself by experiment.


O'DONOHOE'S PRISON
------------------


Leaving Ross bay, the lower Lake expands itself in glorious majesty; the promontories of Ross castle to the left of the fore-ground, O'Donohoe's Prison and Inisfallen to the right; and immediately opposite, but at a distance of about 
 


---

p.52



two miles, Tomies and Glenà mountains rise, in the most abrupt, bold, precipitous manner, from the surface of the waters, having their bases thickly wooded with oaks and hollies. O'Donohoe's Prison is a perpendicular rock, thirty feet above the general surface of the waters; it does not appear to be covered by a coat of earth sufficient to give nutriment to the smallest plant, yet, upon its very summit, shooting from the fissures of the rock, the arbutus, ash, and holly, may be seen, adorned with the most luxuriant foliage.


The tradition relative to O'Donohoe states him to have been a man of gigantic stature, warlike boldness, and great bodily strength: upon this rock the most obstinate of his enemies were doomed to perish by cold or famine, or were bound in fetters until they acknowledged submission to his will. His native historians relate, that, being pursued by a number of enemies, upon one occasion, his charger, in attempting to cross a morass, sunk below the saddle bow, upon which the herculean rider dismounted, and, placing a stone under each of his feet, pulled his gallant steed completely out by the ears. The shade of O'Donohoe,[15](javascript:footNote('E830001-001/note015.html')) says his traditionary biographers, still haunts the scenes of his former greatness, and



---

p.53



is seen moving on the surface of the waters at particular periods; the memory of his snow-white steed is perpetuated by a rock, not unlike a horse drinking, near the shores of Mucruss, which preserves the name of O'Donohoe's horse.


To the north of O'Donohoe's Prison are Herron and Lamb islands, and to the west, Brown or Rabbit island: this last is only remarkable for its quarries of limestone, which are worked for the purposes of manuring land: latterly the trees have grown up so much on this once desolate waste, that it considerably relieves the monotonous character of the northern extremity of the Lake. Not far from Ross island, and between it and Inisfallen, is a little rock, crowned with rich foliage, which, from its diminutive appearance, is called Mouse island.


INISFALLEN ISLAND
-----------------


More to the west is seen the island of Inisfallen, a fertile and enchanting spot, containing eighteen acres of land, and richly clothed with wood. There are only two landing places, although the shore is indented by numerous sinuosities, owing to the shallows on one side, and the bold rocks on the other; however, a convenient mole for disembarking has been erected at one of them, and



---

p.54



nature has provided accommodation for the visiter at the other. The view of Inisfallen, on the approach from any side, is of a totally different character from that of any other island on the lake; it impresses the visiter with an idea of luxuriance, comfort, and tranquillity; the surface of the glebe is spread with the brightest verdure, over which flourish, in rich foliage, the greatest possible varieties of trees and shrubs. Groups of lofty oaks fling their arms over the sward beneath, and the intervals between them are generally occupied by various shrubs, so that only an occasional glimpse is permitted, through the woods, of the Lake and distant mountains; occasional openings are left, where the richest imaginable pasture is unfolded, beautified by an undulating surface, and embosomed in sylvan scenery. In walking round the island, the variety to be met with, in so small compass, almost exceeds belief, and delights the admirer of the soft, the beautiful, and the gentle in nature, to ecstacy. Here a forest scene, in whose centre stands the royal oak; a little farther, trees of less commanding, but not less beautiful aspect, present themselves. The loftiest trees enclose and shelter occasional lawns, affording the richest pasturage, while the smaller shrubs crowd so closely together, as to form an impenetrable barrier. In some places gleams of light pour through the thickening shade, and enliven



---

p.55



the retirement of the interior; and, again, an opening to the Lake *recalls* the idea of the watery boundaries, which here seclude us so completely from the scenes of the busy world, and induce us to reflect upon our remoteness from the haunts of men. The very trees, in their rarity of species and form, appear to rival the surface of the island itself; a gradually ascending hill sinks into a pleasing vale, and this swelling and undulation of the surface, which art has never been able to effect, exists in such pleasing variety, that the imagination of the artist could not conceive, nor his pencil execute, more varied slopes, more gently falling declivities, or more pleasing inequalities on the face of a landscape.


Oak, ash, alder, holly, both bald and prickly, with the arbutus, grow spontaneously and luxuriantly in every part of the island; the service (or Sorbus) tree, is also to be found here. **Smith** (in his History of Kerry) seems to think that these trees were planted by the monks of Inisfallen, contrary to the general opinion of the natives, who, finding them to be the production of *every other island* equally, conclude they are the natural product of the soil.


In one part of the island a holly is shown, the circumference of whose stem measures fourteen feet; in another place, a large hawthorn has made its way completely through the centre of a monumental



---

p.56



stone in the vicinity of the monastery. At the northern extremity of the island stands a crab-tree, in the trunk of which is a large oblong aperture, called the ‘eye of the needle;’ the guide, who points out this phenomenon, never fails to recommend ladies through it, in consequence of a certain charm which he assures them this adventure will call into action. At the most remote extremity of the island, a projecting rock overshadowed by an aged yew, is designated the ‘bed of honour.’[16](javascript:footNote('E830001-001/note016.html'))




---

p.57


Not far from the harbour, where visiters generally land, are the ruins of an ancient monastery, founded by St. Finian Lobhar, (or the Leper,) the son of Alild, King of Munster, and disciple of St. Brendan, towards the close of the sixth century. In the year 640, St. Dichull was abbot, who, with his brothers Munissa and Nerlugis, were worshipped by the votaries at Inisfallen, and the island was then called Inis-Nessan, or Inis-Mac-Nessan, 



---

p.58



i. e. the island of the sons of Nessan, from Nessan, the father of Dichull. The name Inis-Nessan has been rejected for its present very appropriate designation, Inisfallen, *the beautiful or healthy island*, or Inisfaithlen, *the island in the beautiful lake;* this lake is called by Colgan, Lough Lein, and the Lake of Desmond, indiscriminately. The latter name was borrowed from the Earls of Desmond, once petty princes in Kerry, but whose greatness has long since gone by.


After the abbacy of Dichull, a considerable *hiatus* occurs in the annals, and neither abbot nor occurrence is registered until 1180, if we except the name of one abbot, Flannan: ‘at this period,’ says Archdall, ‘this abbey being ever esteemed a paradise and a secure sanctuary, the treasure and most valuable effects of the whole country were deposited in the hands of its clergy; notwithstanding which, the abbey was plundered by Maolduin, son of Daniel O'Donaghoe—many of the clergy were slain, and even in their cemetery, by the McCarthys: but God soon punished this act of impiety and sacrilege, by bringing many of its authors to an untimely end.’


It is said, that a collection of bones were discovered beneath the threshold of the oratory hanging over the river, which Weld supposes to have been the bones of the clergy slain by the 



---

p.59



O'Donaghoes in 1180; but why not suppose them to be rather of more recent date, viz. 1652, when the vicinity of Lough Lein was wasted by fire and sword, by **Ludlow** and the parliament's army?


The annals are continued uninterruptedly down to 1320, but do not contain any matter of interest. In 1320, Dermod M'Carthy, King of Desmond, who was murdered at Tralee, was interred here. The writer of the early part of the annals of Inisfallen, lived only to the year 1215, from which period to 1320 they are continued by another historian. These annals contain a history of the world from the creation to the year 430, after which they treat solely of Irish history: a perfect copy of them is preserved in the library of the Duke of Chandos, according to Bishop Nicholson, and there is an imperfect copy in the manuscript-room in the University of Dublin. The Dublin Society possess a copy of **Sir James Ware**'s MSS of these annals, translated by **Walter Harris**, the Irish antiquarian.


By an inquisition, taken the eighteenth of August, in the thirty-seventh year of Elizabeth, the monks of Inisfallen appeared to be possessed of one hundred and twenty acres of arable land, with four town and three plough lands, together with extensive church patronage in the county of Limerick; all which, besides the abbey of Irrelagh 



---

p.60



 (Mucruss) and its possessions, were granted to **Robert Collan**, for ever, in fee farm by fealty only, in common soccage, at an annual rent of seventy-two pounds, three shillings, sterling.


The ruins of the abbey are very inconsiderable, and the workmanship of what still remains, extremely rude; indeed, there can be but little hesitation in pronouncing the remains of the monastery, now pointed out, not to have been part of the *original* building. There was a garden attached to the monastery, and a few plum-trees are shown close to the ruined walls, which, it is supposed, were planted by the religious inhabitants of the island; from one of the walls of the cloister a very picturesque yew shoots up. The only trace of the ancient edifices erected on this island, which possesses the character of the architecture of those times, is an oratory, standing on a projecting cliff, at the south-eastern extremity of the island, on either side of which are the coves where strangers land. The door-case is a Saxon arch, enriched with chevron ornament, one side of which is quite perfect, and very beautiful; but the soft stone of which it was composed has yielded to the decay of a lapse of centuries. This little oratory has been fitted up by Lord Kenmare, as a banquetting room: in one side is placed a large bay-window, from which a delightful view may be had of Ross island, Mucruss shore, Mangerton, 



---

p.61



Turk, and Glenà. Some have thought the oratory profaned by being repaired in its present manner; but the truth is, that had it not been converted into its present purpose, it would, like the adjacent mouldering walls of the monastery, have now been nearly level to the ground. It is not upon this point the tourist can complain of the noble proprietor, for in this he has endeavoured to preserve some remnants of the ancient greatness of Inisfallen, and to accommodate the visiter also; but it is greatly to be regretted, that the complaints of so many travellers, of the neglected state of the *walks* and *lawns* of the island, should be so totally despised as they have hitherto been. The scenery of Inisfallen is of the soft, gentle, and civilized character, in which a degree of neatness is necessary to beauty; there are scenes of wildness, sublimity, and command, where the very ruggedness of neglect, and want of cultivation, compose the principal and noblest features of the view; but here the walk through the grass should be cleaned and strewn with gravel taken from the shore; the briars and brambles, that are daily choking up the natural evergreens,
should be removed, and *sheep alone* permitted to pasture on the lawns.




---

p.62


O'SULLIVAN'S CASCADE
--------------------


Leaving the island of Inisfallen, and sailing out into the broad expanse of waters, a grand mountain view presents itself; Tomies and Glenà directly opposite, the group of hills closing up the entrance to the Upper Lake adjacent to them, and Turk and Mangerton to the south. Owing to the low, swampy grounds to the east and north of the Lower Lake, and the complete absence of mountains, the remaining prospect quite fails in exciting that interest which the visiter will expect to find created by every scene in the neighbourhood of Killarney. The rising grounds of Aghodoe afford a rest for the eye, but they are too insignificant to form a back-ground to the view. The mountains of Tralee are seen at a distance, but too remote to produce any effect, save at noon or evening, when a distant outline harmonizes beautifully with the character and colouring of the scene. Here, then, is the most extensive sheet of uninterrupted water amongst all the enchanting Lakes; and here the only danger in boating on them is to be apprehended, chiefly originating in the difficulty of getting under shelter with sufficient expedition, when a hurricane sweeps down the mountains' side, and rages over the surface of the waters; whereas, in any other part of the



---

p.63



Lakes, islands are so numerous, that it is hardly possible to be many minutes' sail direct from land.


Steering towards Tomies mountains, which is about one mile and a half from Inisfallen, the eye is delighted by the never-ending variety and change of scenery, momentarily occurring; at first, Tomies and Glenà appear rising abruptly from the water, half clothed with hanging woods, and rearing their naked summits to the skies; upon a nearer approach, they hide their rugged heads, and present a range of forest, nearly six miles in length, and apparently occupying the entire face of the mountains. Reaching the base of Tomies, a little bay is perceived, where is a small quay, of rude workmanship, completely characteristic of the scene: on landing, a rugged pathway, along the bank of a foaming torrent, and winding through an almost impenetrable forest, conducts to the famous waterfall, called O'Sullivan's Cascade. The roaring of the torrent, dashing with violent agitation from rock to rock, kindles expectation to the highest, and the waterfall retires so far into the deep bosom of a wooded glen, that, though almost deafened by its roar, you do not catch even a glimpse, until it bursts at once upon the view.


The cascade consists of three distinct falls; the uppermost, passing over a ridge of rock, falls



---

p.64




about twenty feet perpendicularly into a natural basin beneath, then, making its way between two hanging rocks, the torrent hastens down a second precipice into a similar receptacle, from which second depository, concealed from the view, it rolls over into the lowest chamber of the fall.


Beneath a projecting rock, overhanging the lowest basin, is a grotto, with a seat rudely cut in the rock.


*Fronte sub adversa scopulis pendentibus antrum
  

vivoque sedilia saxo.’’*

Virg. Aeneid, i. 170.




From this little grotto the view of the cascade is peculiarly beautiful and interesting: it appears a continued flight of three unequally elevated foamy stages. The recess is encompassed by rocks, and overshadowed by an arch of foliage, so thick as to interrupt the admission of light; the height of the cascade is about seventy feet, and the body of water so considerable, that the noise soon becomes intolerable. Such a combination of circumstances can hardly fail to produce the effect of grandeur and sublimity in a very striking manner. The stranger not unfrequently sits down to rest within the grotto of O'Sullivan, to contemplate and reflect upon the beauties and the works of



---

p.65




nature, and, unless his nerves be of considerable strength, he may chance to be somewhat startled by the sudden appearance of visiters on each side of him; these are the inhabitants of the glens and valleys in the mountain's bosom, who, perceiving the boat making for the shore, hasten to greet the stranger in the rustic cave, and present him with the wild fruit of their happy vales.


The appellation of ‘O' Sullivan’ is bestowed upon this fall, from an illustrious family of the name, who were proprietors of the barony of *Dunkerron*, formerly called O'Sullivan's country, and were styled princes by the Irish.


Embarking at the rude, unfinished causeway, before mentioned, and coasting along the base of Tomies and Glenà, the scene increases in picturesque effect with every effort of the rowers: the woods of Tomies are not so luxuriant as those of Glenà, being interspersed with birch, while the oak and arbutus in the woods of Glenà enrich the view with colouring of a deeper dye.


In this voyage the deepest water is sailed over, at the bottom of which the peasantry, inhabiting the borders of the Lake, assert that a species of precious stone, called a carbuncle, is to be seen in clear weather. O'Flaherty mentions that pearls have been found in this Lake, *Et in eo stagno margaritae multae reperiuntur, quas ponunt reges in auribus suis;’’*

 latterly but few have been found



---

p.66



in the Lake itself, but several in the river Laune.[17](javascript:footNote('E830001-001/note017.html')) Amethysts have been frequently found in the county of Kerry; the Earl of Shelbourne had some very valuable stones of this description gathered here; and the Countess of Kerry presented a necklace and ear-rings of amethysts, found near Kerry Head, to Caroline, Queen of George II.


In coasting along the bases of the majestic Tomies and Glenà, towards the Upper Lake, several islands are passed, particularly Stag and Burnt islands, near Glenà Point, under which a narrow channel is formed by an island called Darby's Garden. The cockswain generally informs visiters, that this island was so called from an angler of that name, who addressed Lord Kenmare, as he passed in his yawl to the Upper Lake, and besought the commonage of this rock from his lordship: but the stranger will find that much more trifling occurrences have been the occasions of naming the islands of Killarney.


Leaving Castle-Lough bay, studded with islands, and Mucruss promontory, to the left, the



---

p.67



usual course is under the woods of Glenà; perhaps there is scarcely any thing in the sublime, the horrible, the picturesque, and beautiful, that is not illustrated in the bay of Glenà;—the majestic Turk, the gloomy Mangerton, with a continued chain of dark and lofty mountains behind them; then the entrance to Turk Lake, and the channel to the upper, possessing beauty and variety; with the bay of Glenà, sheltered by a lofty hill, possessing the scenic character of both the others. The summit of Glenà is bare, naked, barren, wild, and rugged, while the base is clothed with a deep mass of unbroken wood, of rich and varied shades, almost dipping their foliage in the water. On the western shore of Glenà bay stands a most singular phenomenon, thus described by **Bush**, in his Hibernia Curiosa, *I have seen an oak, an ash, an hazel, a birch, and a thorn, so incorporated into the trunk of an old lively holly, that they appeared to grow out of its very body, and to exist by feeding on its vitals.’’*

Bush, 145.

 **Holmes**, 126.


In the bay of Glenà will be found a most pleasing echo, from the impending mountains, which is much increased in strength and distinctness of articulation by the auditor being stationed at a considerable interval from the origin of the sound. This may be readily accomplished, and to the best possible advantage, by a party, attended



---

p.68



tended by two boats, having placed the bugleman in one of them, in the best position for producing an echo, and then rowing away some distance. This echo, like all others, is much improved by the stillness of evening.


In the bay of Glenà is an excellent fishery of salmon, trout, and perch, but there are no pike in the Lake. Parties intending to dine at Glenà cottage are tolerably secure of being provided with a salmon, taken for the occasion, and drest in a very peculiar manner. The salmon fishery is let for an annual sum, on condition that the persons taking it supply the market of Killarney at the rate of two pence per pound. The cottage of Glenà is situated at the base of the mountain of that name, sheltered by a hanging wood of oak, ash, holly, &c. and close to the margin of the lake. The most romantic disposition of mind cannot conceive, nor the most picturesque fancy sketch, a scene more beautiful, more animating, or more captivating; the cottage in the wood, at a little distance, produces ideas of comfort, neatness, beauty, and happiness, but, upon a nearer approach, the visiter must prepare to see, in a state of extreme neglect, a residence capable of being made one of the most enchanting cottages in the universe. The peasant who resides here has a comfortable little hut behind the cottage, and receives every stranger with courtesy and 



---

p.69



 
good nature; and although the decorations of Glenà cottage are poor and miserable, yet many happy days have been spent beneath its roof, for its visiters are so enamoured of the natural beauties of the scene, that the embellishments of art are quite forgotten.


Here the salmon, taken alive from the lake, are dressed in a most extraordinary mode, and which though not very prepossessing in appearance, will be found much so in reality. The salmon is split from head to tail, and cut into junks; these are pierced with skewers, made of arbutus wood, stuck perpendicularly into a sod, and is thus roasted at a turf fire: the arbutus is supposed to impart a very peculiar flavour to the salmon, and the tourist should not condemn it without trial.


Before we conduct the reader beyond the confines of Glenà bay, the joys of a stag hunt should be described. Amongst the various phenomena, beauties, amusements, &c. to be witnessed or enjoyed at the Lakes of Killarney, tourists seem to estimate the stag hunt as the most interesting of all. The joys of the chase were always attractive to the ancient Irish, and Bede calls Ireland, *an Island famous for staff hunting;* but the sport thus alluded to was of a much more manly, arduous, and warlike character, than the effeminate task of participating in the prepared pageantry



---

p.70



of a Killarney stag hunt. Few visiters have the good fortune to be present at these amusing exploits, although any person who pleases to encounter the expense attendant upon the preparations for the hunt, need not be apprehensive of being refused permission to indulge himself and his friends with the agreeable spectacle.


After leave is granted, a considerable number of persons are employed to conduct the hounds to the appointed rendezvous, from whence they are liberated at an appointed time; some beat the wood and rouse the stag from his retreat in the thicket, while others ascend the heights to prevent his escaping to the mountain's top, although this is not much to be feared, as deer seldom run against a hill. In the mean time the spectators assemble in boats upon the Lake, and row backwards and forwards, directed by the echoes of the hunters' horns, and the baying of the hounds; during the chase amongst the woods, the pursuers submit to much fatigue, without enjoying equal gratification, as the closeness of the trees seldom gives them an opportunity of seeing the stag pursued by the dogs. Meanwhile the patience of the aquatic hunter is put to the test, being frequently obliged to remain several hours on the water, in expectation of ultimately seeing the poor tired creature leap into the Lake, and seek for shelter in a distant island: the number and experience



---

p.71



 of the hunters seldom fail to conclude the chase in the expected manner, and the stag, leaping into the Lake, and trying to make the opposite shore, is surrounded by the sportsmen in boats, and borne triumphantly to land.[18](javascript:footNote('E830001-001/note018.html'))


The species of deer, inhabiting the woods of Killarney, is called the stag or red deer; it was introduced into England from France, but appears to be an old inhabitant of this country: and although the red deer continue wild in the Highlands of Scotland, yet those in the woods about Lough Lein are the only remaining part of the great herds that were to be found in the forests which once covered the face of this country; the few remaining in England are confined to the moors that border on Cornwall and Devonshire. Various animals are much pleased by harmonious tones, but none are so completely overcome by their influence as the large stag, or red deer, as a proof of which take the following interesting anecdote from Playford's History of Music: ‘As I travelled, some years since, near Royston, I met a herd of stags, about twenty, on the road, following



---

p.72



a bagpipe and violin, which, while the music played, they went forward, when it ceased they all stood still; and in this manner they were brought out of Yorkshire to Hampton Court.’


The wolf, once a well-known and dreaded inhabitant of Ireland, has been totally extirpated: first his retreats were destroyed, next a reward offered for his head, and the last ever taken in this kingdom was caught in these woods. Edgar was so resolved upon destroying this hateful species of animal, that he commuted the punishments for certain crimes, upon the production of a certain number of wolves' tongues. This determined conduct soon cleared England of these bloodthirsty animals, while Ireland still continued to be oppressed and inconvenienced by their depredations; and even so late as 1710, a presentment was laid before the Grand Jury of the County of Cork, for the destroying of wolves.


TURK LAKE
---------


Leaving Glenà cottage and bay, the islands of Dinis and Brickeen invite our attention; these islands separate Turk from the Lower Lake, and form narrow passages, or canals, by which alone Turk Lake can be entered. There are passages on *both sides of Dinis* island, and a third under


---

p.??




---

p.??




---

p.73



Brickeen bridge. This bridge unites the extremity of the promontory of Mucruss with Brickeen island; it consists of one gothic arch, whose altitude is seventeen feet, and span twenty-seven, and was built by the late Colonel Herbert. The most desirable entrance is by the Glenà side of Dinis island, which, though more circuitous to navigate, is much the most beautiful, and of the most novel character. The passage is like a river, enclosed by rich and verdant banks, crowned with the most luxuriant groves of various trees, close to the water's edge: it is a sylvan and aquatic scene of the most delicate and pleasing character, without any mixture whatever of the sublime or grand, but confined to the beautiful solely, and of such beauty as the eye loves to dwell upon.


After being enclosed for some short time in this enchanting and retired scene, Turk Lake suddenly appears, through a narrow vista, and produces a very singular effect by the extreme abruptness with which the view of the expanse of water breaks in upon you. The visiter should land, however, on the banks of the wooded canal, upon Dinis island, and wander through the lawns and groves of flowing arbutus, which enrich and beautify this little Eden. The taste of the colonel was too chaste, and his judgment too discerning, to neglect this happy little spot, so much adorned by nature; and, having cut walks through the



---

p.74




woods, he erected a large and comfortable cottage on a sloping lawn, looking towards Mangerton and Turk cottage. Here parties frequently dine, and are very comfortably accommodated, and treated with that politeness which is characteristic of the inhabitants of this neighbourhood. The banquetting room commands a view of the Lake from one extremity to the other, with Turk and Mangerton mountains, and the cottage of Turk, with its improved pleasure grounds. Here, also, the visiter will have his salmon—which is, perhaps, some of the finest in the south of Ireland—dressed upon arbutus skewers, as at Glenà. While the passengers are engaged in wandering over the island, or refreshing within the cottage, the boat is generally rowed to the front of the cottage in Turk Lake, where it awaits at the foot of the gently sloping bank. Coasting along the south side of the Lake, Turk mountain appears particularly sublime, having acquired, by proximity, that apparent height which its neighbour Mangerton denies it at a greater distance. The precipitous brow of Turk appears thickly wooded to a considerable height, and down to the very water; the Lake itself, which multiplies its forests, at the same time receives a dark and gloomy colouring from the reflection of the impending height. The opposite shore forms a striking contrast to this: there the peninsula of Mucruss is extended, elevated



---

p.75



but a little above the Lake, and consisting of a bed of mouldering and excavated rocks, thickly covered with wood. At the remote or eastern extremity of the Lake, stands Turk cottage, a private retreat of Mr. Herbert; it contains several small, neat apartments, with a library of miscellaneous books. The pleasure-grounds around are highly improved, and carefully attended to.


Behind the cottage, at the distance of about a furlong, in a chasm between Turk and Mangerton Mountains, is Turk Cascade, a fall of about sixty feet, which, in rainy seasons, exhibits one continued sheet of foam, from the stage whence it shoots to the natural basin below: it is supplied from a small lake, formed in the hollow of the summit of Mangerton, called the Devil's Punch Bowl, and the rivulet is thence denominated ‘The Devil's Stream’. This cataract, after falling into a deep and gloomy reservoir below, hurries impetuously along the bottom of a rocky glen, and, passing beneath a small bridge of Gothic arches, mingles its waters with those of the lake. One side of the glen is completely perpendicular, and richly clothed with larch and fir, planted by Colonel Herbert. Owing to the extreme perpendicularity of the sides of the glen, immediately near the waterfall, the men employed in planting the firs, were obliged to be lowered by ropes from



---

p.76




the top, carrying the young trees with them, and seeking for a bed of earth of sufficient depth to protect their root; and in this tedious, expensive, and dangerous manner, Turk Cascade has been so improved by human aid, that the majority of strangers would prefer it to O'Sullivan's Cascade on the Lower Lake, or Derry-Cunnihy Waterfall on the Upper.


There is a bridle road leading from Turk cottage to Mucruss house and abbey, which is not very interesting, being overhung by the bleak brow of Mangerton; and visiters have an infinite advantage by viewing the surrounding scenery from the lake. Rowing round the eastern extremity, there is an uninterrupted prospect of the whole of Turk Lake, which is about two miles long, and one broad; then, sailing by a little embayment, in the very centre of which is a small island, the course is along the rugged shores of Mucruss peninsula. Devil's island and bay particularly demand notice. The island is a mass of rock, of considerable elevation, having some shrubs upon its summit, and appears to have been thrown off from the shore of Mucruss by some convulsive shock of nature.


Coasting along the northern shore of Turk Lake, pass Brickeen bridge, and return to the cottage on Dinis island. A walk round this little richly wooded spot will amply compensate the



---

p.77



tourist, by the endless variety of scenery presented at every change of place or position, and the foliage on this island is the most luxuriant imaginable.


PASSAGE TO THE UPPER LAKE
-------------------------


Entering the river again, the navigation against the current is found very difficult; and though the visiter is completely enraptured by the pleasing character of the scenery to be met with in this watery defile connecting the Lakes, the boatmen are occupied in a very different manner, being obliged to put forth all their energies to overcome the violence of the stream. In the most rapid part of the river, not far from Old Weir Bridge, an eddy is shown, usually called O' Sullivan's Punch Bowl; it is extremely like these whirlpools near Bangor Ferry, called the Swillies. The company generally disembark, and walk along the banks, while the boatmen draw up the boat, by a rope attached to the prow. The interest of the scene is rather increased by this little interruption, and the difficulty of pushing the boat through one of the arches of Old Weir Bridge heightens it still farther. The bridge, which consists of two arches of equal dimensions, is thrown across the stream where there is a rapid



---

p.78



of great violence; and in returning from the Upper Lake, it is necessary to undergo the ceremony of shooting the arch, which persons of weak nerves should not attempt; for any confusion amongst the passengers, would destroy the equilibrium of the boat, and most probably cause it to strike against a rock. But although accidents migh occur, it is also certain that scarcely any serious injury has ever been sustained in passing either up or down the current. Pursuing the voyage along this natural and serpentine canal, various small islands and grotesque rocks are pointed out. Miss Plummer's island is soon passed, and, shortly after, a large mass of rock, called the Man of War, presents itself; it is exceedingly like the work of art, to which the cockswain compares it, and the analogy is farther preserved by a large yew upon its summit, whose stem and branches are the representatives of the mast and sails. The Eagle's Nest is the next important object in the passage. It is placed in a hanging crag, near the summit of an almost perpendicular rock, of a pyramidal form, and twelve or thirteen hundred feet in height. When viewed from a distance, this much celebrated rock, so frequently the subject of the painter and the poet, appears quite contemptible, from the superior height of the adjacent mountains; but the approach to its


---

p.??




---

p.??




---

p.79



base, by the river, is picturesque and sublime in the highest degree, since the river runs directly to its foot, and there turns off abruptly, so that the rock is seen from its base to the summit, without interruption; and the projecting masses of huge broken fragments in the centre, tend to complete the magnificence of the object. The base is covered with wood, and a few shrubs appear scattered over the face of the rock, up to the very apex of the pyramid.


It is from this sublime and stupendous rock the sound is returned in so miraculous a manner, that it is considered one of the most singular phenomena in existence. A small hillock, on the opposite side of the river, usually called the ‘Station for Audience’, is used as the resting place of a paterara, which is carried in the boat from Killarney: the gunner is placed on one side of the hillock, and the auditor on the other, and upon the discharge of the piece, a roaring is heard in the bosom of the opposite mountain, like a peal of thunder, or the discharge of a train of artillery, and this echo is multiplied a number of times, after which it gradually fades away, like the rolling of distant thunder. The exact residence of the eagle may be distinguished by a black mark near the vertex of the rock, and the noble inhabitant is frequently seen soaring above the heads of passengers on the river, and directing



---

p.80




their admiring gaze towards his inaccessible retreat. The sound of a musical instrument produces reverberations of quite a different character from that of the musket or small cannon. The only instrument that can be procured at Killarney is a bugle, which is peculiarly appropriate for the production of echoes.


Leaving the Eagle's Nest, rocks and islands succeed in endless variety of form. Holly island, the Four Friends, &c. and the mountain denominated Newfoundland, begin now to appear southward. The river winds even more than at its northern entrance, and, at the precise opening to the Upper Lake, narrows so much, that there appears no egress from the last basin of the river.


In sailing along the channel of communication between the Lakes, many sublime mountain views may be had, particularly at the northern extremity of the Man-of-war rock, looking towards Lord Brandon's Tower, and again near the rocks called the Cannon and Balls.


The passage is generally considered to be about three miles in length, and, in point of beauty, extent, and situation, is quite unique in mountain scenery, neither Wales, Wicklow, nor the English Lakes, possessing any thing of a similar description. It is bounded on the north-west by Glenà and the *Long Range* mountains, and on the southeast by the Drooping mountain, (Cromiglaun,)



---

p.81




and the base of Turk. In the summer season the rocks enclosing the channel of the river are much disfigured by the falling of the waters; being of a cellular nature, the soft slime and mud carried down by the wintry torrents, are deposited in the inequalities of the rocky substance; and, on the falling of the surface of the lakes in dry weather, a dark water-mark remains, extremely unpleasant to the eye.


The entrance into the Upper Lake is contracted into a narrow passage, of about thirty feet in breadth, usually called Coleman's Leap, from a tradition that a person of this name once leaped across the chasm; and on the west side may be seen the impression of the adventurer's feet in the solid rock.[19](javascript:footNote('E830001-001/note019.html')) The contraction in this place is occasioned by a peninsula, called Coleman's Eye, which strikingly represents the form of the human eye, when viewed upon a map.


Here the boatmen, having given several violent pulls of the oars, are compelled to ship them altogether, trusting to the impulse given by their



---

p.82




efforts for being able to pass the gap, for it is not of sufficient breadth to permit the oars to ply. Coleman's Leap once passed, you are upon the Upper Lake.


UPPER LAKE
----------


The character of the Upper Lake, which has frequently been compared with the Derwent Water, in Cumberland, is quite distinct from that of Turk or the Lower Lake. It is entirely encompassed by mountains; and, on looking back, the pass by which you entered upon its surface, is 



---

p.83




totally lost in the confusion of hill, promontory, and bay. In this retreat from the busy scenes of life, the beautiful and the sublime are exquisitely united; the expanse of water is no where very great, except near the entrance, by Coleman's Leap; but the number of islands is very considerable.


To the south, Cromiglaun mountain rises from the very water, behind which is *Esknamucky,* from which runs a considerable stream, falling into the Lake, in a bay parallel to the passage between the Lakes, and possessing a beautiful fall, called Esknamucky Cascade. To the west of Cromiglaun, or the Drooping mountain, is Derrycunehy; in a glen to the west of which is a pretty little cottage and demesne, belonging to the Rev. Mr. Hyde, in the vicinity of the beautiful fall called after the mountain itself. Mr. Hyde's cottage is a private residence; therefore, although the politeness of the proprietor permits the approach of strangers to his cottage, they should not expect or wish for permission to disturb this gentleman's domestic retirement. The cockswain should inform his party, that this cottage is not intended as a banquetting room, and that permission to walk through these grounds is a special favour. To the west of Derrycunehy mountain, and separated by the river *Kavoge,* is Derrydimna mountain, one of whose sides is clothed with a



---

p.84




rich wood. The *Coombui* mountains are seen in the distance, towards the south-west point, and *Barnasna* more westerly. In the west also are seen *Baum*, with its coni-formed summit, and Mac Gillycuddy's Reeks, with their lofty, shattered, and shelving tops. These hills, the highest in Kerry, are composed of a sort of stone which is easily shivered by the storms after winter, and slides down the steep precipitous face of the mountains, nor rests until it reaches the deep ravines at the foot of these almost inaccessible cliffs, so that it may, perhaps with some reason, be concluded, that their height is somewhat diminished in the lapse of time. The nearest of the Reeks to the Lake is called Ghirmeen, or Gheramine.[20](javascript:footNote('E830001-001/note020.html')) At the foot of Ghirmeen is the entrance to the wild and beautifully sequestered valley of Comme Duff. The river which waters this enchanting vale, is navigable as far as the boat-house of Lord Brandon, where is a place for disembarking, whence a pathway leads to the cottage of his lordship, totally embosomed in wood.


In the centre of the garden attached to the cottage, on the summit of a little eminence, stands



---

p.??




---

p.??




---

p.85




a round tower, about forty feet high, erected by his lordship, probably in imitation of the ancient towers in Ireland, of which it is an exact resemblance; the situation, too, being not unlike that of the tower of Glendalough, in the county of Wicklow, is precisely such as the ancient projectors of these extraordinary edifices would have selected. There is a ladder inside, (rather inconvenient on account of its extreme perpendicularity,) by which you may ascend the summit, where is an extensive prospect of the unexplored valley and lakes of Comme Duff, the sides of the prodigious mountains closing up the vale, and the islands of the Upper Lake, with the always obtruding Turk, which appears of a perfectly different form and outline in this situation from its general shape and appearance. Perhaps it would not be proper to direct the tourist to the cottage of Gheramine, and to Lord Brandon's tower, as being indiscriminately accessible to the ‘foe and the stranger,’ since an introduction to his lordship is thought necessary.


North of the Lake are Ghirmeen and the Purple mountain, at a distance; the Long Range, backed by the Purple mountain, Tomies, and Glenà. The Purple mountain is very properly so denominated, from the purple hue it possesses when seen from almost any quarter, and by any light. This extraordinary colour is attributed by



---

p.86



most tourists to the heath, *‘or rather to a little nameless plant, bearing a purpleflower, that covers the surface of the mountain;’* but this is certainly a mistake, and the cause of its continuance was the want of originality in the writers who described the beauties of Killarney, and who took up this idea without sufficient examination, merely because it was current before. When the sun shines strongly upon the summit of this mountain, a quantity of loose stones, shivered on its surface, may be seen, which reflect a purple colour, and to which the hue of the mountain is to be attributed; this opinion is also adopted by that accomplished, judicious, and learned tourist, **Sir R. C. Hoare**.


The islands in the Upper Lake are very numerous, and many of some importance; they generally consist of a green stone, which, close to the water, assumes a dark, muddy hue. This does not occur in the Lower Lake, nor in Turk, to the same extent, the islands in them being of limestone, which admits of such varieties of fantastic forms.


And here, as in all her works, nature has proved herself the most accomplished artist, in adapting the light and airy tints of the limestone rock to the gay and luxuriant shores of Glenà and Mucruss; and the more dingy shadows to the bold, terrific, and savage features of the Upper Lake.




---

p.87


This exposure of the rocky bases of the islands, and stony strands, which occurs in the Lakes of Kerry, forms a distinguishing character between these and the English Lakes, where the green sod always confines the apparently overflowing waters, producing the idea of eternal plenitude.


The most prominent of the islands, upon entering the Upper Lake, is Oak isle, or Rossburkie, a very beautiful object, rising from a rocky base, and crowned with wood; from its shores is a splendid and majestic view of the loftiest mountains, grouped in the most varied manner. The Reeks, Sugar Loaf, and Purple mountain, are the most striking and grand, and Turk, which is now left behind, assumes a totally different aspect. The space between this and Turk is occupied by the fantastic promontory of Newfoundland, overhanging the inlet into which the Esknamucky falls. A walk along the banks of this last-mentioned stream will surprise and delight the tourist; but such little expeditions can be undertaken and enjoyed only by one who has a longer period at his disposal than visitors generally bestow upon the Lakes.


Doubling Coffin Point, the headland sheltering the bay or inlet of Derrycunehy, the waterfalls in the river Kavoge are approached; these are more numerous, and generally better supplied, than any amongst the Lakes, and embosomed in the most



---

p.88



enchanting sylvan scenery. From Coffin Point is a commanding view of the Long Range, Ghirmeen, and Mac Gillicuddy's Reeks. Coasting along the shores of Derrycunehy and Derrydimna mountains, a little archipelago is entered, containing seven islands.


Passing Eagle's Island the visiter is surprised at the sight of a solitary cottage on one of these little water-girt isles, more lofty than the rest. It was built by Mr. Ronan, a gentleman of independent fortune, who usually spent two or three months in each year, in this secluded spot, devoting most of his time to shooting and fishing. In the summer of 1821, Ronan's cottage was in a state of wretchedness and ruin. Parties, sometimes, bring their provisions from Killarney and dine here; but owing to the miserable accommodation, the cottages of Glenà, Dinis, and Inisfallen, are generally preferred. The island is thickly wooded with oak, arbutus, &c. and is accessible only in one spot, close to the cottage. A path winding round the island conducts at last to an eminence about thirty feet above the surface of the Lake, whence there is a very extensive prospect towards Carriguline, Derrycunehy, and all the surrounding mountains. The surface of this island is covered with infinite strata of decayed leaves and brambles. Those at a great depth are bound and united in such a manner, as to form



---

p.89




one continued mass of putrefied matter, becoming, in proportion to its depth from the surface, darker in colour, until at the bottom, where the dissolution is most perfect, and the pressure greatest, it is one continued black turf. This fact may tend to explain how many of the bogs in Ireland may have been formed; for it is perfectly ascertained, that most of the mountains, and even a great portion of the plains, were once thickly covered with forest trees.[21](javascript:footNote('E830001-001/note021.html'))


The same combination is also discoverable in other islands in the Lakes, but is most obvious upon Ronan's.


Leaving Ronan's island, and pursuing a westerly course, Stag island next presents itself, of a similar character to the others in this Lake, its rocks crowned with rich foliage. Beyond this, the valley between Ghirmeen and Barnasna lies expanded before you, and in the centre the stately tower of Lord Brandon is seen rising above the woods. The other islands in this cluster are called M'Carthy's, Duck, and Arbutus. The



---

p.90



channels between them open to new and varied scenes, which, combined with panoramic views of rock, wood, and mountain, produce one of the most awfully sublime pictures in nature. The northern shore affords equal beauty and variety of prospect; and, after sailing under the Long Range, conducts back once more to the singularly contracted entrance at Coleman's Leap.


The stream now carries the boat along so pleasantly, that the assistance of the oar is hardly necessary. The former views along the passage are transposed, and Turk is hardly recognised, appearing so black and shapeless.


The navigation of this natural canal is peculiarly delightful at evening time: the smoothness of the water, in which are seen reflected the woods and hills; the stillness of the atmosphere, so appropriate to the production of echoes beneath the Eagle's Nest, the meandering of the river, and the exuberance and luxuriance of the arbutus, yews, and hollies, which clothe the banks, produce the most delightful feelings.


It is quite absurd to point out particular stations where advantageous views may be had, for the precise spot can seldom be discovered; and, besides, every tourist finds the greatest pleasure in making such discoveries for himself; and stations would be multiplied ad infinitum, if all those that are worth mentioning were pointed out here:



---

p.91



yet general hints may sometimes be given with advantage. In visiting the Upper Lake, the stranger ought to endeavour to ascend Cromiglaun, from whose summit is a most agreeable bird's-eye view of the Lake and islands; for, in consequence of their irregular disposition, a person merely sailing round the Upper Lake, carries away a very imperfect idea of its shape or magnitude.


The Upper Lake is about *two miles and a half in length,* but its breadth is irregular. The rocks and islands are inhabited by hawks, ospreys, eagles, and other birds of prey. In a tour through Ireland, made in the year 1797, by **Mr. Holmes**, is the following very just estimate of the comparative picturesque merits of the three Lakes of Killarney, and the serpentine river which connects them: ‘I should distinguish the Upper Lake as being the most sublime; the Lower the most beautiful; and Turk, or Mucruss, the most picturesque: the winding passage, leading to the Upper, contains a surprising combination of the three, and, probably, is not to be exceeded by any spot in the world.’


Mr. Curwen, whose taste and feeling as a tourist are acknowledged and admired, and whose admiration of the beauties of nature is sufficiently testified by his residence on Windermere, institutes a very just comparison between the Lakes 



---

p.92




of Killarney and those in the north of England. ‘As a landscape for casual contemplation,’ says Mr. Curwen, ‘I should prefer Killarney; as a permanent residence, I should choose Windermere.’


MUCRUSS ABBEY
-------------


Leaving the village of Killarney to the north, and directing our course towards Mangerton, several gentlemen's seats are passed: Woodlawn Cottage, on the river Flesk; Cahernane, the seat of R. T. Herbert, Esq.; Lord Headly's Lodge, on the opposite side of the road; and Castle Lough demesne, the seat of Dr. Lawler. The demesne of Cahernane is extensive and interesting, although the ground is perfectly flat, and Castle Lough formerly boasted a strong but small fortress, built upon a rock, which, having surrendered to Colonel Hieromè Sankey, was so totally demolished by the Parliament's army, under Ludlow,[22](javascript:footNote('E830001-001/note022.html')) that scarcely a trace of it can now be discovered. A broad and level road, over-shaded by full-grown limes, leads from Flesk bridge to the village of Cloghereen, a distance of about two miles from Killarney. Here is the



---

p.??




---

p.??




---

p.93



entrance to the beautiful and romantic demesne of Mucruss.


On entering the village, a small mean gateway on the right admits to Mucruss grounds; just within the gate is an old building, formerly occupied by the miners employed on the peninsula. Crossing a little stream, and stretching a short distance across a beautifully sloping and verdant lawn, the steeple of [23](javascript:footNote('E830001-001/note023.html')) Irrelagh, or Mucruss Abbey, rears its venerable head amongst the lofty limes and ashes.


According to Archdall this abbey was founded by Donald, son of Thady M'Carthy, in 1440,[24](javascript:footNote('E830001-001/note024.html')) for conventual Franciscans, and further improved and repaired by him in 1468, a few months before his death. In 1602 it was re-edified by the Roman Catholics, but was soon after suffered to go to ruin.


The abbey consisted of a nave, choir, transept, and cloisters, with every apartment necessary to render it a complete and comfortable residence for the venerable inmates who once dwelt there. It is even now so perfect, that, were it more so, the ruin would be less pleasing. The entrance is



---

p.94



by a pointed door-way, ornamented with an architrave, highly enriched by an infinity of plain mouldings. The interior of the choir is awful, gloomy, and solitary, heightened almost to the terrific by the indecent custom of piling the melancholy remains of mortality in every corner; and so familiar is the care-taker with these sad relics, that he has even had the indelicacy and hardihood to group them here and there in fantastic forms. Sir John Carr speaks of this in very strong language: ‘So loaded with the contagion is the air in this spot, that every principle of humanity imperiously calls upon the indulgent owner, to exercise his right of closing it up as a place of sepulture in future. I warn every one who visits Killarney, as he values life, not to enter this abbey. Contrast renders doubly horrible the ghastly contemplation of human dissolution, tainting the surrounding air with pestilence, in a spot which nature has enriched with a profusion of romantic beauty.’ This statement is rather overcharged, and the request here made of closing the cemetery totally impracticable in a country where religious superstition prevails so strongly.


This abbey, says Archdall, has continued to be the cemetery of the M'Carthys. Donald, Earl of Clancare, and Patrick, Lord Kerry, the earl's nephew, who died in 1600, lie entombed here. In the floor of the choir is a large marble flag, bearing the arms of the McCarthy Mores.




---

p.95


Many valuable relics were said to be preserved in this Abbey. An image of the Virgin Mary, of miraculous powers, was also said to belong to it. The landed property, amounting to four acres, two orchards, and one garden, estimated at 16s. per annum, was granted to Captain Robert Collam, upon the dissolution of religious establishments throughout the kingdom, in the 37th of Elizabeth; but from the date of the inscription on the northern wall of the choir (1626) it is obvious the monks continued to inhabit it some time after. A large stone in one angle of the choir, of rather modern date, bears the following extraordinary inscription:
  

 T. S. D. mc: m: Rahily: oRh
  

There is a small chapel branching from the choir, entered by a handsome pointed doorway enriched with plain mouldings. The steeple once contained a bell, which, not many years ago, was found in the lough, and recognised, by the inscription upon it, as the former property of Mucruss Abbey.


The cloister is even more perfect than the steeple or choir. In the centre of the cloister stands a majestic yew, whose stem rises perpendicularly to the height of about thirty feet, and whose sheltering branches are flung across the battlements, so as to form a perfect canopy. The gloominess of the cloister is so much increased by this curious



---

p.96



circumstance, that some persons have not nerves sufficiently strong to endure a lengthened visit within its precincts. The guide generally recommends visiters to beware of injuring this sacred tree; and a story is gravely narrated of a soldier who having the impious audacity to strip a small piece of the bark with his pen-knife, instantly expired on the spot where this sacrilege was committed. Beneath this gloomy shade four tombs, devoid of inscription, and of recent date, are discovered, probably belonging to persons of the religious order. On the ground-floor is a long narrow room, but imperfectly lighted, called the cellar; the ceiling, which is an arch of stone, is rather a subject of curiosity, as showing most clearly the manner in which arches were thrown or turned by the masons of ancient days. A frame of wicker-work, tolerably strong, was covered with a thick coat of mud or *marl,* and, being reduced into the required shape, used as the mould to build upon; the wicker work being removed, the marl adhered to the arch, and is still perfectly obvious. The floor of the wine-cellar exhibits a spectacle shocking to humanity; lids of coffins, with their commemorating inscriptions, skulls and bones, which have not yet lost the odour of putrefaction, lie strewn upon the ground. In a small closet, near the wine-cellar, myriads of coffin boards are stowed in, so that all entrance is


---

p.97




prevented. At Ardfert and Lislaghtin, in this county, the same abominable practice is also permitted.


Over the cellar is the kitchen of the monks, with its floor perfect, but without a roof, and there John Drake, a pilgrim, lived for the space of twenty years, and withdrew secretly after this long penance. Next to the kitchen is the refectory, preserving a chimney-piece, or rather fireplace, and might have been a very comfortable apartment. The dormitory is also tolerably complete, and was a long narrow room, capable of accommodating a number of persons of humble habits of life. A second pilgrim took up his abode in the upper chambers of the Abbey, but his devotion was not so sincere as that of his predecessor; for after a lapse of two years, he thought proper to retire. The Festival of St. Francis, the patron saint, is celebrated here in the month of July, upon which occasion the peasantry assemble in great numbers, to receive the benedictions of their pastors, and make their confessions amongst the tombs and ruined walls of this venerable building. The cemetery on the south of the Abbey is crowded with tombs and monuments. Persons of property generally hollow out a rock, and throw an arch over, which permits the coffins to be pushed in at one end, and is afterwards closed by a large block of stone in which a ring is



---

p.98



inserted; but the poorer classes are laid in the earth, seldom more than twelve inches below the surface.


The variety of trees and plants around the walls of the Abbey, is probably greater than in any other spot in the neighbourhood; limes, elms, ash, sycamore, horse-chesnut, &c. besides one plant, the wild hop, which is met with only here. There is one more circumstance connected with this Abbey, which, though not more peculiar to it than to other favourite burying places in Ireland, yet, from the frequency of its occurrence here, and the scene where it may be witnessed, is interesting to a stranger, and is quite characteristic of the Irish nation,—I mean the ‘Irish Cry.’


MUCRUSS DEMESNE
---------------


This beautiful and extensive demesne belongs to Mr. Herbert, and was part of an enormous grant of lands, made by Elizabeth, to sir William Herbert of St. Julians, in the county of Monmouth, whose daughter and heiress married Lord Herbert of Cherbury, created Lord of Castle Island in this county, by letters patent, dated Dec. 31st, 22nd of James I; and by Charles I, a peer of England, by the title of Lord Baron of Cherbury in the county of Salop, 7th of May, in



---

p.99



the fifth year of his reign. The first of the Herberts who settled in this county was Thomas Herbert, of Kilcow, esq. of which lands and others he was enfeoffed by Edward Lord Herbert of Cherbury and Castle Island, April 18th 1656, from whom the present possessor of Mucruss is descended.[25](javascript:footNote('E830001-001/note025.html'))


The demesne includes a large tract of land on the borders of the Lower, and Mucruss Lakes, extending from Castle Lough to the foot of Turk, together with the Peninsula of Mucruss, which separates these Lakes. After visiting the Abbey, a pleasing walk through the woods leads to the summit of a hill called ‘Drumaouk’;[26](javascript:footNote('E830001-001/note026.html')) from this rising ground is seen the house of Mucruss, with its verdant lawn enclosed by a wood which fringes the Lake, and continues along the entire peninsula to the point of Cammillan, a distance of nearly three miles. On the opposite side of the Lake, Tomies and Glenà rise from the water with incredible magnificence, and possess a soft and gentle outline, while the Eagle's Nest exhibits a bold, broken, and savage aspect. Here it is, then, that the flat, swampy grounds about Killarney are enabled to contribute to the beauty of the scenery,



---

p.100



by the contrast they afford to the opposite shore. The house of Mucruss is old and tasteless, and the gardens are remarkable for possessing more rock than earth, from which spring the most delicate shrubs, and in the most luxuriant manner. A road cut through the wood leads to a marble quarry, from which green, red, black, and variously coloured marbles have been raised. The quarry is a broken, bold shore, surrounding a small bay, and ornamented with the most beautiful shrubs, scattered amongst the crags, and growing apparently in the fissures of the rocks.


In passing along this winding, irregular path, occasional glimpses are caught of the Lake, sparkling through the thick foliage; and sometimes an opening amongst the trees permits a view of the lower Lake, and the lowlands near Killarney on the right; while Turk Mountain, hanging over the intervening Lake, is seen to the left. The shafts of a copper mine are also to be met with on the peninsula, but the mine has not been worked for some years. When the works were discontinued, about twenty-five thousand pounds worth of ore had actually been sold. Besides marble and copper, this peninsula also contains iron ore, a quantity of which was also raised.


In pursuing the tour of this peninsula, several beautiful bays are discovered, one in particular, whose rocky arms, which embrace it, are crowned



---

p.101



with arbutus and holly. The promonory of Dindog is another beautiful and interesting object; but it would be quite impossible to describe the infinite variety of scenes the pedestrian will discover in wandering along the shores of this extended peninsula.


Having reached the extreme end of the promontory, a bridge of one Gothic arch affords a passage to Brickeen island; and it was the intention of Col. Herbert, at whose expense this arch was thrown across, to continue the communication between Brickeen and Dinis islands; and thus, by means of Old Weir bridge, the upper Lake might be visited, either by the pedestrian or by a rider mounted on a shelty.


MANGERTON MOUNTAIN
------------------


From the little village of Cloghereen a road leads to the base of Mangerton, which, considering its height, is the easiest to ascend of any hill to be met with in a mountainous region. It was for many years considered the highest in Ireland, and set down in the old maps and surveys, as being 2,470 feet in height. But many valuable improvements have been made in the mode of measuring the heights of mountains, by which this error, with many others of a similar description,



---

p.102



have been detected. It is now ascertained by the measurement of **Mr. Nimmo**, that the height of Mangerton is 2,550 feet, while that of Carran Tùal is 3,410.


Near the village a guide, provided with a horn, is generally in attendance, and conducts you by the easiest path towards the summit. Here, however, the tourist is subject to great annoyance, arising from the number of men and boys, who run on every side of him, without uttering a syllable, but merely keeping up with his horse. Entreaties to desist from this undertaking, as one would be sufficient to point the way and tell the names of distant objects, are of no avail; one says, ‘No gentleman ever prevented *him* from ascending the mountain’; a second avers, ‘That he is the Man of the Mountain’; and a third declares his resolution of not quitting the party till their return to the village: it is useless to resist, and the visiter has often six or eight guides forced on him, whatever may be his inclination. After an ascent of about half an hour, an elevation, equal to that of the summit of Turk, is reached, from which a most perfect bird's eye view of the lakes, speckled with islands, is obtained, and an idea of their relative positions afforded. At every step after this the view becomes more and more commanding. Keeping to the east of the mountain, the Devil's Punch Bowl is reached, without 



---

p.103



the trouble or necessity of once dismounting from your shelty. This celebrated pool is of an oval form, and perhaps two furlongs in diameter; its waters are very dark and cold; on one side the mountain rises very precipitously over it, while the other is protected by an elevation merely sufficient to confine its waters.[27](javascript:footNote('E830001-001/note027.html')) Weld mentions an anecdote of Mr. Fox, whom he states as having swam round this pool, but I should think the experiment hardly practicable; for although with respect to distance it might be done by a person of great bodily strength, and experience in the art of swimming, yet the cold would most likely produce cramps that would either endanger life or compel the resignation of so hardy an attempt. It has generally been considered that the Devil's Punch Bowl is the crater of an extinct volcano, but there are, at this day, no remains discoverable around the mountain to justify this conclusion. There is a path leading round the Bowl, and to the very summit of Mangerton, 



---

p.104



from which there is a most extensive and sublime panoramic view in clear weather. The most beautiful object is the river of Kenmare, an arm of the sea, insinuating itself amongst the recesses between the mountains. The coast towards Bantry is also extremely grand; but the most commanding and attractive objects are the Reeks and Sugar-loaf; to the north-west Castlemain and Dingle bays, Miltown bay, and the Tralee mountains are seen. While on the edge of the Punch Bowl, the Guide places his auditors behind a rock, and descending to the edge of the bowl, blows his horn in a tremulous manner, which produces a most singular effect. This experiment was first suggested by Miss Plumtree.


There are several plants to be found on Mangerton, although its surface appears waste and barren in most places. Very near the top the London-pride, which is in England a garden flower, grows in great abundance. Close to the Punch Bowl grows the narrow-leaved mountain golden rod, besides the upright fir-moss, the fingered hart's-tongue, the cypress or heath-moss, the fenane-grass, the mountain millet-grass, and the mountain fern.


On Mangerton is found a species of whetting stone, whose grit is extremely fine; it is used by the peasantry for razor hones: when found upon the mountains, it is of a light olive colour; but 



---

p.105



the process of preparation, by boiling it in oil, changes the colour to a darker shade, and makes it assume a more close, smooth, and compact texture.


From the Devil's Punch Bowl flows a well-supplied stream, the chief feeder of Turk Cascade.


After surveying the grand spectacle from the top of Mangerton, there is a descent by a different route, which the guide is unwilling to be at the trouble of showing you, but which is much more interesting than the path by which the ascent was made; it is that by the Glen of the Horse, called by the inhabitants of the mountain, ‘GLEANNA CAPULL’. This Glen is divided from the Punch Bowl, by a lofty ridge or shoulder of the hill; its sides are quite precipitous, and a descent is, except in a few places, quite impracticable, and even in these not unattended with danger. One side consists entirely of broken craggy rocks, the habitation of the eagle alone; the bottom is occupied by two small dark loughs, on whose banks a few sheep and goats are enabled to procure subsistence for some months in the year. In this solitary region of desolation, which the man of the world would turn from with fear and trembling, human beings are known to spend part of their wretched existence: their dwellings are in the dark and dismal caverns in the rocks, and their only companions the wild birds that



---

p.106




scream over their heads, and the cattle which their time is employed in tending.


The easiest entrance to this secluded glen, is by the narrow opening through which the overflowing of the pool discharges itself. The name is derived from the circumstance of a horse having fallen down its steep rocky side in winter. The effect of the horn or bugle in this glen is even more extraordinary than in the Punch Bowl, the buz or hum being louder and more tremulous.


From the separating ridge between *Gleanna Capull* and the Punch Bowl, other pools or loughs are discovered; one, Lough Na-maragh-narig, in a very elevated situation, and Lough Kittane, about two miles in length and one in breadth, in the Glan Flesk mountain. The view towards Glan Flesk, Filadavne, the Paps, &c. is waste and dreary: that part, usually called O'Donohoe's country, is particularly desert, wild, and desolate. And although at a remote period it was the lordly demesne of a petty prince, as O'Donohoe's castle, still raising its ruined tower in the centre of this barren waste, sufficiently indicates, yet it is now almost ungrateful to the eye to rest upon.


The descent of Mangerton is more readily accomplished on foot than on horseback, and is equally easy, pleasant, and interesting, as the



---

p.107



ascent: on the way visiters are generally met by a few children, with bowls of goat's whey in their hands; and although they do not request the stranger to notice them, they expect he will taste uninvited: these are the least troublesome, the easiest satisfied, and, after the fatigue of climbing the mountain, the most welcome intruders met with at Killarney.


The horses are generally led, by one of the many attendants the tourist is compelled to employ, to a convenient place of rendezvous, from whence the ride to Killarney, by Cloghereen, is extremely agreeable and sheltered. Between Killarney and Mucruss, on the opposite side of the road, is a small ruined chapel, on the very summit of a rath, from whence an extensive and distinct view of the Lower Lake might be taken, but it does not differ much from that seen from the top of Drumarouk hill.


AGHADOE
-------


The road north of Killarney leads to the ruined church and tower of Aghadoe, about two miles and a half distant. Within the deer park of Lord Kenmare, the entrance to which is on this road, is a very pleasing view, and one in which the whole detail of the landscape can be minutely and satisfactorily



---

p.108



gazed upon, from a green mound in his lordship's park, called ‘Kneckriar Hill’. Proceeding towards Aghadoe, we leave Prospect Hall, the seat of G. Cronin, Esq., on the right: from the lawn of this demesne is a fine panoramic view of the Lower Lake, precisely the same as that from Aghadoe, except that the latter is more distant from the different objects. From hence the road is bleak, dreary, and uninteresting for some miles, particularly when the mountain view on the left happens to be intercepted by walls, trees, or hedge-rows. At the end of the second mile a narrow road leads to Aghadoe church, situated on the top of a long, low, green hill. The lane is impassable for carriages of any sort; but the visiter will not regret the trouble of walking, if the day be fine, and the weather clear, as at every step the view increases in extent, richness, and sublimity.


The church of Aghadoe is a venerable, ancient building, originally of but rude workmanship, measuring, probably, between eighty and ninety feet in length, and about thirty in breadth; the whole length is separated by a thick wall, in which traces of a door-way are discoverable. The chancel was lighted from the east by two long lancet loop-holes, but the whole is, at this day, in such a dilapidated condition, that but a very imperfect idea can be formed of what it originally



---

p.109




might have been. The door-way is a very masterly specimen of the excellence of the art of sculpture in those days; six successive mouldings, of different patterns, chevron, or zig-zag, and others, ornament its architrave; and though carved in an exceedingly soft species of stone, are all perfect and beautiful specimens of a master's hand.


The date of the foundation of this abbey has not yet been ascertained.


The present appearance of the ruin and cemetery is extremely disgusting, and the smell frequently offensive: skulls, bones, and coffin-lids, are scattered every where, in the same horrible manner as at Mucruss, Ardfert, and Lislaghtlin; and although divested of the gloomy accompaniments of long dark aisle and shady yew, still appear chilling and terrific. The number interred here exceeds that at Mucruss, partly because this is considered a more ancient cemetery, and partly because it is free from charge for burial.


Near the church are the ruins of an old round castle, usually called the Pulpit, the interior diameter of which is twenty-five feet; its height, at present, is about thirty feet, nor does it appear to have been much more lofty. It evidently consisted of but two stories, of which the lower or basement was lighted by one window, the second by three. The ascent was by a staircase, constructed



---

p.110



within the wall. Round castles are rather uncommon in Ireland; there are two others, however, nearly of the same height and diameter as this of Aghadoe, existing, the one at Waterford, called ‘Reginald's Tower’, the other in the county of Tipperary, called ‘Nenagh Round’. Dolbadern Castle, in the vale of Llanberris, in North Wales, is extremely like this at Aghadoe, which must have been a place of defence, as appears from the fosse and mound encompassing it.


In the Collectanea de Rebus Hibernicis may be seen a plate of a stone in the walls of Aghadoe Cathedral, on which is cut an inscription in the Ogham character. This mysterious hieroglyphical letter, whose powers are now totally lost, was used by the ancient Irish or Indo-Scythians. The inscriptions are merely horizontal, or perpendicular lines, intersected at right angles by a number of parallel lines, or darts, of unequal lengths. The learned Mr. Pelham supplied **General Vallancey** with many instances of such inscriptions in the county of Kerry, which have been published in the sixth volume of the Collectanea.


As to the meaning or translations of these mystical writings, the antiquarian should conjecture with caution; one instance from many may indicate the propriety of this advice. In the catalogue of inscribed stones, in the sixth vol. of the



---

p.111


Collectanea, is one mentioned as being found in the county of Kilkenny by Mr. Tighe, and said to bear an inscription in the Pelasgic letter, which in Roman characters would be
  

BELI DI UOSE.
  

This, after much learned disquisition, **General Vallancey** has sagaciously translated thus: ‘To Belus, God of Fire,’ whereas, had it occurred to these learned gentlemen, who really were an ornament and benefit to their country, to turn the inscription upside down, they would have found, in plain English, the following name and date: ‘E. CONID, 1731,’ it having since been found to be the fact, that it was cut by a stone-mason of that name, who lived in the neighbourhood.


One subject yet remains to be spoken of, before we quit the antiquities of Aghadoe, viz. the Round Tower, within a few yards of the church. The remains of this building are rather insignificant, not exceeding twenty feet in height, and completely filled with rubbish; it was built of brown stone, trimmed on the exterior surface.


DUNLOE CASTLE
-------------


The road from Aghadoe to Laune bridge continues along a flat country, unvaried by improvements. Near the bridge the Castle of Dunloe



---

p.112



appears raising its head amongst the forest trees, and having its gloomy outline relieved on the surface of the still gloomier mountains behind. The castle, the residence of Major Mahony, is an ancient hold, modernised in a comfortable manner; the floors are of yew wood, more beautiful than the closest mahogany, and the apartments extremely commodious. Owing to the extraordinary thickness of the woods, the views from the walks are interrupted, but from the embattled summit of the walls it is very commanding. This castle was frequently the retreat of the Kerry chieftains in the wars, during the reign of Elizabeth, and under the Commonwealth government.


A small well-made mountain road leads from Dunloe into a defile in the mountains between Tomies and M'Gillycuddy's Reeks, called the Gap of Dunloe. The hill on one side of the entrance is called the Holly mountain, that on the other the Bull mountain, but both are mere shoulders or projections of the larger hills. The entrance to the gap is very narrow, and the mountains quite perpendicular on each side. In a little wild romantic glen, a short distance from the entrance, is a small lake, whose waters assume a particularly dark hue, from the reflexion of the enormous mountain which hangs so immediately over it. On penetrating into the defile, our admiration of the wild scenery is gradually exchanged



---

p.113



for a feeling of awe and an impression of fear, until a pass is reached, so narrow that there is space merely for the scanty road and the little dark, gloomy, lake beside it; the hills on either side ascend in steep, perpendicular, precipitous crags; masses of enormous bulk lie tossed about in all the terrific sublimity of chaos, and instances have been known of persons, who, when they have arrived at this spot, were so paralysed with terror, that no earthly inducement could persuade them to advance, dreading that the mountain might fall and overwhelm them. Two small bridges are thrown across the stream which runs through the defile, in the narrowest parts of the channel; yet, from the simplicity of their structure, these do not interrupt the character of the scenery. In one particular part of the pass, the road runs along the margin of a black pool, and is so unprotected, as to inspire the equestrian traveller with fears, that, should his horse trip, he might be precipitated into the lake. But a scene of this description defies the address of the most expert tourist, and the pencil of the ablest master; it must be seen to be understood. Those who have visited the passes of Borrowdale, in Cumberland, may form a faint idea of the chilling, dreary grandeur of Dunloe; but the pass of Llanberris, in North Wales, bears a still greater resemblance, and he who has seen the Gap of Dunloe, will not



---

p.114



be overawed by the sublimity of Llanberris, nor will the deep rooted image of Dunloe be eradicated by the combined beauty and grandeur of Borrowdale.


From the entrance of the Gap to the farther end, opening into the vale of Comme Duff, thence to Gheramine, the seat of Lord Brandon, is about four miles; the road from the outlet of the Gap to his lordship's cottage is in a rude, unfinished state, but improvements are daily making. Here a long-extended valley is opened to the view; at the western extremity of which is a very considerable lough, called the Red Trout Lake. Nearly opposite the termination of the Gap is a beautiful waterfall, of considerable height, and always plentifully supplied; the waters of this fall flow into a succession of small lakes, occupying the whole length of the valley. In some are small islands bearing shrubs upon their surface, and others are decorated with water lilies. A visit to this valley would occupy only one day, and would richly compensate the visiter. The overflow of the three lakes of Comme Duff discharges itself into the upper lake at Cariguline.




---

p.115


[28](javascript:footNote('E830001-001/note028.html'))ASCENT OF CARRAN TUAL
---------------------


The youthful traveller seldom quits the scene of inquiry without ascending the highest mountain and penetrating the deepest glen. In all mountainous districts there is always one peak famed for its extraordinary elevation and difficulty of access. In the vicinity of Lough Lein, Carràn Tuàl is the cloud-capped summit, marked out as the highest. Mangerton was formerly considered higher, but the late measurements of Mr. Nimmo have shownCarràn Tuàl to be three thousand, four hundred and ten feet above the level of the sea, while Mangerton is only two thousand, five hundred and fifty.


Having taken horse at Killarney, pursue the Aghadoe road, and so pass over the Laune bridge, by Dunloe gate; then, turning to the right, at the distance of a mile, is a little village, at the very foot of the Reeks. Here a guide, who understands the shortest routes up the hill, and is, consequently, better qualified than any person from Killarney, may be had for a trifling sum. Being properly equipped for an arduous and laborious pedestrian excursion, direct your course towards



---

p.116




the mountain, either leaving your horses at the guide's cottage until you return, or, which is a much more advisable plan, sending them back to Killarney, having previously directed a boat to meet you, at Lord Brandon's boat-house, at the extremity of the Upper Lake.


The mountain bridle-road leads from the village, over a low range of hills, to Mr. Blennerhasset's shooting lodge, on the banks of the river Giddah, a considerable mountain torrent, flowing into the Laune. On Lishbaun mountain is the first view of Dingle bay; and, crossing the Gaddah river, and passing a gradually sloping vale of moss and rock, (very fatiguing to the pedestrian whose feet are not protected by very strong shoes,) the *Hag's Glen* is entered. To the right a lofty green mountain, called Konnock à Brianihn, i. e. the hill of the sheep-raddle, darkens the valley, and opposite is the beetling brow of the lower reeks, perfectly inaccessible to all but the wild birds which nestle in their fronts.


The Hag's Tooth is a small conical projection from the mountain, resembling the flying buttress of some mouldering edifice. Around and above are seen small black lakes, whose tints are borrowed from the impending crags, called the Devil's Lough and the Hag's Lough, &c. the latter having a small island in the centre. While



---

p.117



gazing on the ruinous prospect which surrounds on every side, except the path by which this sequestered excavation is entered, the visiter forgets for a moment the task to be accomplished; but the suggestion of the guide that the sun delays not his daily course, quickly recals him to a sense of the voluntary labour he has undertaken. To the query of ‘which way?’ the guide only raises his cudgel, and points to a cleft in the face of the mountain, formed by a rill that occasionally forces its way down in rainy weather. A feeling of vanity, natural to pedestrians, prevents any observation upon the manifest difficulty and even danger of the ascent, and the attack is generally begun in silence and determination. For about a quarter of a mile the path continues up the steep, through rocks, stones, long grass, moss, and shingle; whenever a steady footing is obtained for a moment, you are induced to turn and enjoy the scenery; but from the deep retreat in which the pathway is embosomed, the view is greatly contracted, and altogether interrupted towards the west. This steep pass once overcome, the difficulties vanish, but are succeeded by ideas of danger. The way to the highest peak lies along the summit of a ridge, something like the red ridge on Snowdon, the top of which is narrow, convex, and covered with grass, so short and slippery that it can hardly be walked over in dry



---

p.118



weather, unless in stocking feet. The tops of the reeks are composed of a species of shingle, which, after heavy falls of snow, loosens and unbinds, and glides down the mountain's breast in the thaw; for this reason naturalists say the height of the reeks may have been sensibly diminished in the lapse of time. The principal stone to be found upon the reeks is sand-stone, and the plants are the same as those on Mangerton, London-pride growing in great abundance.


The view from the top is most commanding towards the west. From hence are visible Dingle and Castlemain bays, the Tralee mountain, &c.; to the south, Bantry bay, and the indented coast of Kerry.


The remaining reeks appear like so many inclined planes, whose angles of inclination are all equal, so that they appear to lie in parallel strata. On the tops of several are small loughs, like those on Mangerton and the high mountains in the range.


The view to the south-west presents a mountainous scene of the boldest description, the Glencar and M'Gillicuddy's mountains, with an endless succession of immeasurably extended wilds.


The descent into the valley of Comme Duff is tedious, but not difficult; the inclination is rather too precipitate to permit comfortable walking, and



---

p.119



this renders it extremely fatiguing. Having reached the valley, there is a rugged, stony path, winding along through little deserted hamlets and barren wastes, which, after pursuing it for about four miles, brings you to the destined place of rendezvous—Lord Brandon's boat-house. In a few minutes the anxious cockswain conveys the traveller to the cottage on Ronan's island, where, after a journey of at least fourteen hours, the first opportunity of taking rest and refreshment is afforded. The lateness of the hour will not now admit of much delay, and Killarney will hardly be reached before eleven at night; supposing that five in the morning was the hour of departure.


DIRECTIONS FOR TOURISTS
-----------------------


The following directions are drawn up in such a manner as to be serviceable to visiters under any circumstances. It sometimes happens that while one traveller is exceedingly limited in time, a second may be desirous of finding different routes for a succession of days. To the former of these, the most economic distribution of time—to the latter, abundance of diversified amusement, is pointed out.




---

p.120


### Route by which the Lakes and Beauties of Killarney may be seen in the space of a single day


Taking horses at Killarney, and being attended by a bugleman, also mounted, start at five o'clock in the morning for Dunloe Gap; two miles and a half from Killarney, turn up a narrow road, to the light, and visit the ruined tower and cathedral of Aghadoe. Arriving at the bridge over the Laune river, cross and ride a few hundred yards farther to the gate of the demesne of Dunloe castle; here there is not much to detain the traveller who is in haste, except the view from the battlements. Leaving Dunloe castle, the seat of Major Mahony, about three quarters of a mile farther, enter the Gap of Dunloe. Here let the bugle be kept in constant employment. Halt in the narrowest part of the rocky defile, and observe the extraordinary effects of the bugle; ride through the pass, and reach the valley of Comme Duff: here it will be necessary to send back the ponies, having desired guide-boys from Killarney, the night before, to meet you at that place for the purpose. The remaining part of the vale must be traversed on foot as far as Gheramine, the seat of Lord Brandon. Here ask permission to ascend the tower in the garden, from the top of which is a very commanding prospect. Direct your cockswain



---

p.121



swain and boatmen, the night previous, to have a boat, with a supply of provisions, to meet you near Lord Brandon's boat-house. Sail down the river into the Upper Lake, land on Ronan's island, dine and rest in the cottage; after which, ascend the peak, and view the amphitheatre of hills enclosing the lake. After taking refreshment, sail through the archipelago of the seven islands, and then direct your course towards Derrycunnihy; visit the waterfall, and Mr. Hyde's cottage; coast along the base of Cromiglaun mountain. Time will not permit a visit to Esknamucky waterfall and glen. Entering Coleman's Leap, sail down the passage between the Long Range and Newfoundland, until you reach the Eagle's Nest. Here disembark, and take a station which the cockswain will not fail to point out, while the swivel is discharged by the boatmen from the most advantageous situation for the production of echoes.


Embarking again, continue your course with the stream, remembering to employ the bugle frequently along the passage between the lakes. The next object of surprise is the old Weir bridge: here the unpleasant ceremony of shooting the bridge is to be submitted to. Arrived at Dinis Island, pass into Turk Lake, coast the base of Turk mountain, and visit Turk cottage and waterfall; there leave the boat, directing the cockswain to meet you again below the house of



---

p.122



Mucruss, in Castle Lough Bay; ascend Mangerton, still accompanied by the bugle, and arriving at the Devil's Punch Bowl, try its extraordinary effects. The Glen of the Horse cannot be visited upon this route. Descending to the village of Cloghereen, visit Mucruss abbey, and, passing on to the shores, embark once more upon the lake in Castle Lough Bay: sail round Ross Island to Inisfallen, thence to Ross Castle, where the guide-boys generally have a mode of conveyance ready to carry the traveller to Killarney.


In this route, many interesting objects are necessarily neglected, and others but imperfectly seen, at the same time that a very extensive and delightful tour has been accomplished in a wonderfully short space of time. The personal fatigue of this journey is great, and the arrangements require to be made with judgment. A six-oared boat should be employed, also excellent ponies, and active boys to rendezvous at the appointed places.


### Two Days' Tour


The following directions will enable the tourist to economise time so far, that the lakes may be satisfactorily seen in the short space of two days,



---

p.123



by a strict adherence to the arrangements here laid down:—


Having despatched a messenger, the preceding evening, to Mucruss House, or Cahernane, with a note requesting permission to visit the Abbey, and having obtained this favour, leave the inn at five in the morning, mounted on a strong shelty, attended by a guide-boy and a bugleman: cross the Flesk River, pass Cahernane, Castle-Lough, and Mucruss Demesnes, and leaving the village of Cloghereen behind, ride up the front of Mangerton Mountain: try the effect of the bugle at the Punch-bowl; walk round the edge of the Bowl, along the summit of the ridge dividing the Devil's Punch-bowl from Gleanna Capull,[29](javascript:footNote('E830001-001/note029.html')) and let the bugleman descend a short distance down the steep side of the glen, while the tourist remains on the top. The effect of the bugle in this situation is very extraordinary. [See Mangerton.]


Let the guides conduct the shelties to the foot of the mountain, and there await the party, who will find it more practicable to walk than ride down from the Punch-bowl. Having again reached the village of Cloghereen, visit the Abbey of Mucruss and the peninsula, and walk along the shore to Castle-Lough Bay. Take notice of the rock called O'Donohoe's Horse. Have the boat



---

p.124




in waiting near the shores of Mucruss peninsula, and coast along to Brickeen bridge. Here enter Turk Lake, and coast still along the Mucruss shore, passing the Devil's Island, and thence row to Turk Cottage.


Disembark at Turk Cottage, and penetrate the wooded glen behind, in order to visit Turk Cascade, which flows from the punch-bowl. Returning to the boat, sail close under Turk Mountain to the Cottage on Dinis Island. Here dinner can be dressed in a very comfortable manner, and great civility will be met with from the cottagers. If the day should not be far advanced, refreshment may be postponed until the party reaches Glenà, or perhaps Inisfallen Island. After walking through the woods on Dinis Island, sail out of Turk Lake by the passage between Dinis and the mainland, into that leading to the Upper Lake. The rapidity of the current will soon carry the boat into Glenà Bay. The cottage of Glenà will afford an agreeable place for rest and refreshment; but this should be regulated also according to the time of day: leaving Glenà Cottage and Bay, sail close under Glenà Mountain, and try the effect of the bugle. Double Glenà point, and coast the base of Tomies to the river flowing from O'Sullivan's Cascade. Here disembark, and visit the cascade. Returning to the boat, steer a little to the north, and make Inisfallen by a circuitous



---

p.125



direction. This is the most desirable spot to dine at, and there is no danger to be apprehended in returning to Ross Bay at night-fall, the intermediate water being scarcely ever in a disturbed state.


Returning to Ross Castle, along the shores of the island, at Lord Kenmare's boat-house, a delightful and surprising echo will be found from the castle. Arrived at the quay beneath the castle, ponies from the inn are generally in readiness to convey the visiters to Killarney. So ends the first day.


At an early hour the second day, after breakfast, take shelties, and ride to Aghadoe; enjoy the view of the Lower Lake from the church-yard, and see the ruins of a round tower and castle. Proceed along the road at the foot of the hill, to the bridge over the Laune; cross the bridge, and visit Dunloe Castle: this should occupy but a short space. Proceed to the Gap of Dunloe; ride through the pass, remembering to keep the bugle constantly employed. Arriving at the termination of the pass, keep the left pathway down the valley of Comme Duff to Gheramine, the seat of Lord Brandon. Seek permission to ascend the tower in his Lordship's garden. The ponies should be sent back to Killarney with the runners, from the termination of the pass.


The boat should be in waiting at Lord Brandon's



---

p.126



boat-house to convey the party to Ronan's Isle. Dine in the cottage, and row about amongst the islands. Steer for Coffin Point, and, entering the little sheltered haven, disembark, and visit the cottage and waterfall of Derry-Cunnihy. Embarking again, and coasting the southern shore, visit the waterfall and Glen of Esknamucky. Returning to the boat, and doubling the headland, make your exit from the Upper Lake by Coleman's Leap. Sailing down the passage, or river, stop nearly opposite the Eagle's Nest, and land for a few minutes to hear the extraordinary echoes produced by the firing of a small cannon, which is carried in the boat for this purpose.


Sailing with the current, by the Cannon Rock, Man-of-War Rock, &c., the next adventure is the shooting of old Weir bridge. The current is here very rapid; and the little boat is hurried swiftly by O'Sullivan's Punch-bowl, and Dinis Island, into Glenà Bay. Here again the effect of the bugle is delightful. Coasting along Glenà Mountain, pass between Glenà Point and Darby's Garden, and, crossing the Lower Lake to Ross Island, land at the usual place of disembarkation in Ross Bay. So ends the second day.


Although it is practicable to see the beauties, curiosities, &c. around Lough Lein, in the exceedingly short space of time mentioned in the preceding directions, yet that can be accomplished



---

p.127



only by very expert and active tourists, and will necessarily subject even them to much personal fatigue. Those who are not so restricted in time, may of course visit the numerous interesting objects near Killarney, not only in a less laborious, but also in a more perfect and satisfactory manner. Extend the tour to three days, and the time may be advantageously disposed of in the following manner.


### Three Days' Tour


The first day will be entirely occupied in visiting Mucruss demesne and Abbey, Mangerton, the Punch Bowl, Gleanna Capull (the Glen of the Horse.) The Glen of the Horse is inaccessible at every point but one, viz. the egress of the rivulet from the two interior lakes. The tourist will have ample leisure to make an excursion into Filadaune, visit Lough Kittane, and enter the Glen of the Horse. A lazy guide always endeavours to deter the visitor from this last excursion, but the tourist will be richly rewarded for his trouble.


The second day may be devoted to visiting the Lower Lake; first, however, the demesne, house, park, and gardens of Lord Kenmare ought to lie viewed, and Kneckriar Hill, in his Lordship's



---

p.128



park, ascended, from which there is a very commanding view. Embarking at Ross Castle, row to Inisfallen, which will take some time to see perfectly: thence, directing your route northward, come round to O'Sullivan's Cascade, on Tomie's Mountain: thence to Castle-Lough Bay; see the Drinking Horse, which was also seen the day before, from the shores of Mucruss. Enter Turk Lake, under Brickeen bridge, and, rowing across the lake, visit the cottage and cascade of Turk. Leaving Turk Cottage, coast the base of the mountain to the outlet of the lake, between Dinis Island and the Mountain; land on Dinis Island, and wander about amongst the woods and thickets, while the boat is rowed down the stream, and reaches O'Sullivan's Punch-bowl, near which it generally awaits the passengers. The cottage of Dinis affords tolerable accommodation, provided the party bring the materiel with them.


From Dinis Island sail with the stream into Glenà Bay. If the cottage of Dinis be not found sufficiently attractive to induce the party to take refreshment there, Glenà Cottage most probably will. Here a salmon is usually taken out of the lake, in presence of the party, and dressed on arbutus skewers for their dinner. Coast the base of Glenà Mountain; pass Darby's Garden, and cross the water to Ross Island. The bugle should be kept in constant employment in Glenà Bay; and,



---

p.129



near Ross Castle, let the boatmen rest upon their oars, while the bugle sounds a few interrupted notes, directing the mouth of the instrument towards the castle. Landing at Ross Castle, return by means of shelties to the inn, and so complete the second day's tour.


At an early hour on the morning of the third day, but remembering to take a hearty breakfast first, mount your shelty, and ride to Aghadoe Church. See the Round Tower, the Round Castle, called by the peasantry the Pulpit, and the stone bearing an Ogham inscription. Returning to the high road, pursue the road to Laune or Beaufort bridge, and, crossing the river, visit the Castle of Dunloe. After a short stay in the demesne, keep the mountain road to the Gap, and proceed, by slow and measured steps, through the Pass to the farther end in the vale of Comme Duff. The bugle should be kept in unceasing employment all through the Pass, but particularly under the castellated cliff hanging over the pool in which the guide asserts there is an enormous serpent.


Entering the valley of Comme Duff, visit the Waterfall, the best supplied cascade in the whole country. See the islands on the Comme Duff Lakes, and following the stony bed of a little mountain torrent, arrive at Gheramine, the seat of Lord Brandon. See the cottage and tower, and



---

p.130



embark at his lordship's boat-house, where the boat from Killarney will be found waiting. Row to Rona's Island, and having landed, take refreshment in the cottage; then ascend the eminence on this island, and take a view of the seven islands.


From Ronan's Island row to Derrycunnihy; see Mr. Hyde's cottage and the cascade. Keeping the southern shore by Coffin Point, direct your course between Cromiglaun and Coleman's Eye, and row to the extremity of the little inlet into which the Esknamucky river falls; disembarking here, walk along the banks of the river, as far as the cascade. On the way will be met some of the most retired habitations imaginable, in the very heart of the wild forests.


Embarking once more, double the headland, and pass through Coleman's Leap into the natural canal connecting the Upper and Lower Lakes. Observe the variously formed rocks, viz. the Man-of-War and Cannon Rocks, &c. along the banks of this passage, and, arriving under the Eagle's Nest, it will be necessary to disembark for a few minutes, while the paterara is discharged against the front of the rock. The echo, however, is not returned from the Eagle's Rock, but from the deep bosom of the mountain adjacent to it. The rapidity of the stream, and the inclination and skill of the boatmen, it being now late, will speedily urge the oar-impelled bark to the old



---

p.131



Weir bridge; should the water be tolerably high, the ceremony of shooting the bridge is attended with rather agreeable sensations, and little danger; but if otherwise, the boat will run considerable risk of striking against a rock, in its rapid progress, and in all likelihood be materially injured. The cockswain, however, never permits his company to remain in the boat when there is any danger.


From old Weir bridge the passage meanders through extremely beautiful sylvan scenery. O'Sullivan's Punch Bowl is quickly passed; Dinis and Brickeen Islands, the entrance to Turk Lake, and, ultimately, the bay of Glenà, are all soon left behind.


The southern shore now possesses the greatest novelties to the visitor, (having coasted the northern before,) and, passing Brickeen bridge, let the cockswain steer due east, beneath the woods of Mucruss Peninsula. Sail then amongst the islands called O'Donohoe's Table, Alexander's Rock, Cow Island, Jackdaw Island, Yew Island, and Rough Island, to the northern extremity of Ross. Doubling the point, enter Ross Bay, and land under the castle, as before. This terminates the third day; and if the weather should have been favourable, and the party early risers, the beauties of Killarney will have been satisfactorily visited. Such a coincidence, however, is not



---

p.132



always to be found, nor is such speed required by all tourists: those who have sufficient leisure will occupy an entire week to visit the places mentioned in the three days' tour.


The Gap of Dunloe requires one day; Mangerton and Filadaune a second; Mucruss abbey and demesne, with Turk cascade and cottage, a third; the Lower Lake, Inisfallen, and O'Sullivan's cascade, &c. a fourth; Turk and the Upper Lake will more than occupy the fifth; and the ascent of Carràn Tuàl is assuredly one day's employment for the most active tourist in Britain.


A LIST OF THE ISLANDS IN THE DIFFERENT LAKES
--------------------------------------------


### Lower Lake


1. Ross Island
2. O'Donohoe's Prison
3. Cherry Island
4. Inisfallen Island
5. Mouse Island
6. Heron Island
7. Lamb Island
8. Rabbit Island
9. Rough Island
10. Yew Island
11. Cow Island
12. Jackdaw Island
13. Osprey Island
14. Drinking Horse
15. Pigeon Island
16. Crow Island
17. O'Donohoe's Table
18. Alexander's Rock
19. Friar's Island
20. Tom Cole's Rock
21. Currigahocca Rock
22. Oak Island
23. Gunnet Rock
24. Gun Rock
25. Darby's Garden
26. Burnt Island
27. Brickeen Island
28. Dinis Island
29. Miss Plummer's Island
30. The Three Friends &c.
31. Sugar Island
32. Coarse Island
33. Ash Island



1. There is but one, the Devil's Island





---

p.133


1. Rossburkie, or Oak Island
2. Arbutus Island
3. Eagle's Island
4. Knight of Kerry's Island
5. M'Carthy's Island
6. Ronan's Island
7. Duck Island
8. Stag Island, &c. &c.



The cascades in the neighbourhood of the lakes are—O'Sullivan's, Comme Duff Falls, Filadaune, Turk, Esknamucky, Derrycunnihy.





| *Mountain* | *Height in ft* |
| --- | --- |
| Carran Tual (the highest ofg the Reeks) | 3410 |
| Mangerton | 2550 |
| Purple Mountain | 2280 |
| Slieve Meesh | 2200 |
| Tomies | 2150 |
| Glenà | 2090 |
| Turk | 1900 |
| Lake above the level of the sea | 50 |
| Dunloe Heads (these are Bull and Holly Mountains) | 1100 |









| *Mountain* | *Height in ft* |
| --- | --- |
| Crohaune Mountain (over Filadaune) | 2175 |
| Paps (higher of the two) | 2280 |
| Cahirbarna | 2000 |
| Gortavehy | 1500 |
| Knock Claragh (near Mill-street) | 1385 |








