

#Early Irish Population-Groups: Their Nomenclature, Classification, and Chronology


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Early Irish Population-Groups: Their Nomenclature, Classification, and Chronology
=================================================================================


Author: [unknown]
-----------------


### File Description

Eoin MacNeillElectronic edition compiled and proof-read by Beatrix Färber

Funded by University College, Cork, School of History 1. First draft.Extent of text: 23550 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2012) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E900000-003Availability [RESTRICTED] 
Available with prior consent of the CELT project for purposes of academic research and teaching only.


#### Notes

#### Sources


**Internet availability**2. This paper is available in pdf format on www.archive.org.
3. Many manuscripts referred to in this paper, such as the
 Book of Ballymote (Dublin, RIA, 536 olim 23 P 12) and the Book
 of Lecan (Dublin, RIA, 535 olim 23 P 2), are available as
 digitized images on the website of the ISOS Project, School of
 Celtic, Dublin Institute for Advanced Studies. (See
 www.isos.dias.ie).
**Literature mentioned in the text (selection)**2. John O'Donovan (ed), Leabhar na gCeart (Book of Rights), (Dublin 1847). [Re-edited as Lebor na Cert by Myles Dillon, ITS 46 (Dublin 1962). His edition is online at CELT in files G102900 (Irish text) and T102900 (his English translation), with further bibliographic details.]
3. John O'Donovan, Three Fragments of Irish Annals (Dublin 1860).
4. Eugene O'Curry, Lectures on the manuscript materials of ancient Irish history (Dublin and New York 1861; repr. Dublin 1878; repr. Dublin 1995).
5. Edward O'Reilly, An Irish-English dictionary : with copious quotations from the most esteemed ancient and modern writers [...] (Dublin 1817, reissued 1821). New edition, with supplement by John O'Donovan (Dublin 1864).
6. Edmund Hogan (ed): now for the first time published from a manuscript preserved in Clongowes-Wood College (Dublin 1878).
7. Philip's Handy Atlas of the Counties of Ireland, constructed by John Bartholomew; revised by P.W. Joyce, London 1882.
8. Henri D'Arbois de Jubainville, Cours de Littérature Celtique (Paris: A. Fontemoing, 1883–1902).
9. Whitley Stokes, The Tripartite Life of Patrick, with other documents relating to that Saint. Edited with translations and indexes. D.C.L., L.L.D., Rolls Ser. 8vo, London. Part I. cxcix + 267 [8] pp. facs. Part II. 269–676, 1887.
10. W. M. Hennessy & B. Mac Carthy, Annala Uladh: Annals of Ulster otherwise Annala Senait, Annals of Senat: a chronicle of Irish affairs from A.D. 431 to A.D. 1540. 4 vols. (Dublin 1887–1901).
11. John Healy, Ireland's ancient Schools and Scholars (Dublin 1890).
12. Geoffrey Keating, The History of Ireland [...], Part 1, ed. David Comyn, (London: Irish Texts Society 1902).
13. Eoin MacNeill, 'Moccu, maccu', Ériu 3 (1907), 42–49.
14. Eoin MacNeill, 'The Irish Ogham Inscriptions: 'notes on the distribution, history, grammar and import of the Irish ogham inscriptions', Proceedings of the Royal Irish Academy (C), 27 (1908–09), 329–370.
15. Eoin MacNeill (ed), Duanaire Finn, ITS volume 7 (London 1908).
16. Alfred Anscombe, 'The Longobardic Origin of St. Sechnall', Ériu 4 (1908), p. 74–90.
17. Edmund Hogan, Onomasticon Goedelicum: locorum et tribuum Hiberniae et Scotiae; an index, with identifications, to the Gaelic names of places and tribes (Dublin 1910). [A version prepared by the LOCUS project in UCC is vailable online at http://publish.ucc.ie/doi/locus.]
18. Alfred Holder, Alt-celtischer Sprachschatz, Sprachschatz. 3 vols, Leipzig 1891–1913.
19. Ernst Windisch (ed), Die altirische Heldensage Táin Bó Cúalnge nach dem Buch von Leinster, in Text und Übersetzung mit einer Einleitung [und Wörterverzeichniss]. Gedruckt mit Unterstützung der kgl. sächsischen Gesellschaft der Wissenschaften (Leipzig 1905).
20. Kuno Meyer, Fianaigecht. Todd Lecture Series 16 (Dublin 1910).
21. Rudolf Thurneysen, Handbuch des Alt-irischen: Grammatik, Texte und Wörterbuch (Heidelberg: Winter 1909).
22. Eoin MacNeill, 'An Irish Historical Tract dated A.D. 721', Proceedings of the Royal Irish Academy (C), vol. 28 (1910) 123–48.
**Further reading (selection)**2. Julius Pokorny, 'Beiträge zur ältesten Geschichte Irlands (3. Érainn, Dári(n)ne und die Iverni und Darini des Ptolomäus)', in Zeitschrift für celtische Philologie 12 (1918) 323–57.
3. John [= Eoin] MacNeill (ed and trans), 'Poems by Fland Mainistrech on the dynasties of Ailech, Mide and Brega', Archivium Hibernicum 2 (1913) 37–99.
4. Edmund Hogan, 'The Tricha Cét and related land-measures' in PRIA 28 (1928–29) (C), August 1928, 148–235.
5. Toirdhealbhach Ó Raithbheartaigh (ed), Genealogical Tracts I: Anmand na n-Athachthuath (Dublin 1932) 107–116.
6. T. F. O'Rahilly, Early Irish History and Mythology (Dublin 1946).
7. Francis Xavier Martin, 'The Writings of Eoin MacNeill', Irish Historical Studies 6:21 (March 1948) 44–62.
8. Francis John Byrne, Francis Xavier Martin (eds), The scholar revolutionary: Eoin MacNeill, 1867–1945, and the making of the new Ireland (Dublin 1973).
9. Paul MacCotter, 'The cantreds of Desmond', Journal of the Cork Historical and Archaeological Society 105 (2000) 49–68.
10. Paul MacCotter, Medieval Ireland: territorial, political and economic divisions (Dublin 2008).
**Internet availability:**2. http://www.archive.org/details/papersirishacad00macnuoft.
**The edition used in the digital edition**2. **Eoin MacNeill**, Early Irish Population-Groups: Their Nomenclature, Classification, and Chronology in Proceedings of the Royal Irish Academy, Ed. [Royal Irish Academy]. , Dublin, Royal Irish Academy (April 1911) volume 29 section C no 4 page 59–109

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The text covers pages 59–109; the index (110–114) has not been captured. Editorial footnotes are integrated into the electronic edition. Any
 footnotes or corrections added at CELT are marked
 *resp="BF"* within the XML tags. Some contriutions
 have been incorporated by an unknown corrector in the hardcopy used for scanning.


#### Editorial Declaration


##### Correction


Text has been checked and proofread twice. All corrections and supplied text are tagged. Text supplied by the editor to the original is marked sup resp="EMN".


##### Normalization


The electronic text represents the edited text.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break or line-break have been placed on the line on which they start.


##### Segmentation


div0=the article; div1=the section; page-breaks are marked pb n=""/.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd. (There are no dates in the text.)


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: Article written by Eoin (=John) MacNeill (d. 1945)
 (1911) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] Many group names and quoted text passages are in Old
 and Middle Irish.


##### Language: [LA] Many words and phrases are in Latin.


##### Language: [FR] Some words and phrases are in French.


##### Language: [GR] A few words and phrases are in Greek.


### Revision History


* (2012-11-23) Beatrix Färber (ed.)

* Bibliographic details compiled.
* (2012-11-20) Beatrix Färber (ed.)

* Proofing finsihed; encoding revised and extended. Bibliographic details compiled.
* (2012-11-04) Beatrix Färber (ed.)

* Header created; more proofing; more encoding added.
* (2011-03-22) Beatrix Färber (ed.)

* File proofing (1) started; structural and content encoding applied.
* (2011-03-02) Beatrix Färber (text capture)

* Article captured by scanning.




---


#### Corpus of Electronic Texts Edition: E900000-003


### Early Irish Population-Groups: Their Nomenclature, Classification, and Chronology: Author: [unknown]




---

p.59


Plural Names
------------


¶1] Among the continental Celts, each distinct population-group bore a plural name, e.g. Haedui. The singular form denoted an individual member of the community, e.g. Haeduus. This system of nomenclature, very general in ancient Europe, might be expected to exist in the oldest Irish traditions. In **Ptolemy**'s description of Ireland, the sixteen peoples named all bear names of this order.


¶2] Most of the names given by **Ptolemy** lack identification in the native Irish tradition. The absence of these from Irish writings may be accounted for in more than one way. Some of the names may have been inaccurately recorded by **Ptolemy**. Some may have been corrupted beyond recognition by his copyists. Some may have designated peoples whose identity became forgotten through conquest and dispersion, for there is ample evidence that the period between **Ptolemy**'s time (c. A.D. 150) and the beginning of contemporary records in Ireland was marked by great commotion, involving widespread changes in distribution and relative status of the older elements of the population.


¶3] The Ogham inscriptions, as I have shown in an article on the word Moccu (Ogham mucci) in Ériu, vol. 3, part 1, sometimes record names not only


---

p.60



 
of persons but of peoples. The people-names, however, chiefly belong not to the class discussed above, but to a subordinate class, as will be seen. It is therefore unnecessary here to consider the question of the earliest date of the extant Oghams. Between **Ptolemy** and the oldest probable manuscript records in Ireland there is a gap of at least three centuries. The names **Scotti** and **Atecotti**, known through Latin writings of the fourth century, are probably of a general application, not designative of special groups. **Orosius** gives one people-name not mentioned by **Ptolemy**, the **Luceni**, whom he places on the southern coast over against Spain; they have not been identified in Irish tradition. (Is **Luceni** a copyist's error for **Iuerni**?)


¶4] In Christian Ireland, from the fourth century onward, the plural formula for people-names exists only as a survival. The Ulidian tales, which are held to embody very ancient traditions, assign indeed a prominent part to peoples with plural names, the **Ulaid**, the **Lagin**, the **Galeoin**, the **Érainn**, but not a more prominent part than to the **Connachta**, whose name belongs to quite a different order. As the phrase teora Connachta shows, this name, though plural, is the plural not of a word denoting an individual, but of a collective noun. Already in the pre-Christian period such collective nouns have for the most part displaced the older formula, tending to obliterate it largely from traditional memory, since among the hundreds of collective names on record only a small proportion are known to originate from an earlier group bearing a plural name.


¶5] The obsolescence of the earlier order of names is further exemplified in the complete absence, so far as my observation goes, of any instance of the use of the singular to denote an individual. The only approach to such usage in my knowledge is the occurrence of a few names like **Cormac Gaileng**, **Ailill Érann**, **Mugdorn Dub**, etc., for persons who in the genealogical lore stand as eponymous ancestors to the **Gailing**, the **Erainn**, the **Mugdoirn**, etc.


¶6] In the Christian period, the surviving plural names (except in genealogical writings) tend more and more to become dissociated from population-groups, and to attach themselves in ordinary usage to geographical areas, e.g. **Laigin**, usually meaning the country Leinster, or the people of Leinster, of whom the original **Laigin** were only one section.


¶7] The following names from Irish MS. sources appear to belong to what may be called the first order, i.e. to the Haedui-type[1](javascript:footNote('E900000-003/note001.html')):


¶8] ***Arai**, dat. pl. **Araib**. Middle Irish **Ara Thíre**, **Ara Chliach**.




---

p.61


¶9] ***Coraind**, ***Corrind**, dat. pl. **Corannaib**, **Correndaib**, **Windisch**, Táin Bo Cuailngi, index. In the **Boyne** valley, corresponding to **Ptolemy**'s **Coriondi**. Compare **Corcu Cuirnd**, **Cuirenrige**.


¶10] **Cruithni**, gen. pl. **Cruithne**, acc. pl. **Cruithniu**, but in composition Cruithen-tuath, Cruithen- chlár. **MacFir Bisigh**, Book of Genealogies, R.I.A. copy, p. 54, quotes a poem on the **aithechtuatha**, with the couplet (eight and seven syllables):
  


> 1. **Clann Chathraighe** a ccriochaibh Cruithent
>   
> or chin Cairbre Cinn Cait cruaidh.
> 


The correct reading is probably **Cruithen**, *t* from the familiar **Cruithentuath** being added by **MacF.** or some earlier scribe. The early stem should have been *Qretino-, *Qreteno-, and perhaps the Greek form Prettano- may have been influenced by **Brittani**. **Cruithni**, **Cruithne**, may represent an early secondary formation in -io-, or may be merely a late development like **Érnai**, **Mugdornai**. Such a development could arise from acc. pl. **Cruithniu**, dat. pl. **Cruithnib**, which would be common to both forms, and even a nom. pl. ***Cruithin** could easily become **Cruithni** in transcription.


¶11] **Éli**, gen. pl. **Éle**.


¶12] **Érainn**, gen. pl. **Érann** (not gen. sg. as in Onomasticon Goedelicum), acc. pl. **Érna** (= **Érnu**), dat. pl. **Érnaib**, = **Iérni**, **Iverni**, ‘**Hiberni**’. Probably a secondary formation from an older ***Ivéri**, whence ***Ivériu**, **Ériu**, **Iwerddon**. In the Ulidian tales, the **Érainn** are frequently called **Clanda Dedad**, and in the genealogies they have, besides Ailill Érann, an eponymous ancestor Iar macc Dedad. The group of tales centring in Conaire Mór are the heroic legend of this race, and Conaire's father is called Eterscél (also Eterscéle) moccu Iair. Macc Iair is a personal name, not an ordinary patronymic: hence the sept-name Ui Maicc Iair and the Ogham Maqi Iari. **Windisch** (T.B.C. index) cites Iarna as a duplicate form of Érna. We may suppose the double base ér, iar, to have arisen from a coexisting pair iér-, ivér-. Compare Ierne, **Ptolemy**'s Iernos potamos, Iernis polis, contemporary with **Iuverna**, **Iuerna**, **Hibernia**.


¶13] Féni, gen. pl. Féne, as **Meyer** has shown ( Fianaigecht, p. viii), may be an ancient people-name, not the name of a class as has been supposed.


¶14] ***Fothairt**, gen. pl. **Fothart**.


¶15] ***Galing**, gen. pl. **Galeng**.


¶16] **Galiúin**, **Galeoin**, gen. pl. **Galian**, **Galion**.


¶17] **Lagin**, gen. pl. **Lagen**.




---

p.62


¶18] **Manaig** or **Monaig**, dat. pl. **Manachaib**, but derivative Manchaig. Compare **Manapii**.


¶19] **Maugdoirn**, **Mugdoirn**, gen. pl. -dorn, acc. pl. -dornu. Compare **Ptolemy**'s **Darini**.


¶20] **Sogain**, gen. pl. **Sogan**. Compare **Sograige** (?), **Corcu Sogain**, **Corcu Suigin** (Sogain here being gen. sg. of the eponym, as in moccu Sogin, Ogham mucoi Sogini).


¶21] **Ulaid**, gen. pl. **Uloth**, acc. pl. **Ultu**. The earlier nom. pl. must have been **Uluti** or **Oluti**, and one may surmise that **Ptolemy**'s **Ouolountioi**, whose location well corresponds to that of the **Ulaid** around **Emain**, is a scribal corruption of **Oulouti** = **Uluti**, perhaps through the influence of the Latin voluntas.


¶22] Vellabori (**Ptolemy**), **Velabri** (**Orosius**) seems to have left a trace in the place-name **Luachair Fellubair** (LL 23 a 17). This name occurs in a poem which aims at accounting for the distribution of the peoples said to be descendants of Fergus Mac Roig. Wherever Rudraige, the Ulidian king of Ireland, won a battle, his grandson Fergus planted a colony of his own race. 

> 1. Cech rói reraig corruadchathaib cen chridenas
>   
> cotgab iar fír roslín Fergus dia fhinichas.
> 

 Of these colonies were **Ciarraige Luachra** (in North Kerry) and **Ciarraige Cuirche** (**Kerrycurrihy** barony, co. Cork), and the victories of Rudraige which led to them are thus recited:

> 1. Fich cath Curchu cath Luachra laechdu Fellubair
>   
> secht catha i Cliu intochtmad friu i nGlendamain.
> 


**Ptolemy** clearly indicates the **Vellabori** as inhabiting the south-western corner of Ireland, and **Orosius** speaks of the **Velabri** as looking towards Spain. In the verse cited, we should expect gen. pl. Fellabor = *Vellabron, but the word may be used eponymically in gen. sg. like Dedad in Luachair Dedad, another name for the same district.


¶23] In the absence of examples of the singular, it seems likely that **Aidni**, **Luaigni**, **Luigni**, **Uaithni** belong to this order rather than to the collectives in -ne.


¶24] **Dési** is to be classed apart, being the plural of a common noun déis ensemble de vassaux. Aire désa, lord of a vassal tenantry. See **D'Arbois de Jubainville**, Cours de Littérature Celtique, vol. viii, p. 204. In the story of the migration of the **Dési** (ed. **Meyer**, Ériu 3, p. 141), the narrator is at pains to explain (lines 215–219) that the derogatory term dési is not applicable properly to **Dál Fiachach**, the dominant people of **Dési** Muman:




---

p.63


¶25] ‘Coica toirgi[2](javascript:footNote('E900000-003/note002.html')) laisna Déisi. A cuic fichet dib tarthatar raind, a cuic fichet aile nach tarthatar ocus is dona toirgib [sin] is ainm Déisi. Ar itt e fil fo deisis ocus dligud ocus bodagas dona flathaib .i. do Dail Fiachach Suigde ocus ni hainm doib-side Déisi.’ ‘The **Dési** had fifty migrations (i.e. consisted of fifty migratory peoples). Twenty-five got a share (of the conquered land), another twenty-five got no share, and to these migratory peoples the name **Dési** belongs. For it is they who are under (**deisis**) vassal-tribute[3](javascript:footNote('E900000-003/note003.html')) and law and **bodagas** to the rulers, i.e. to **Dál Fiachach Suigdi**, and **Dési** is not a name for the latter.’


¶26] The story professes to give a list of the migratory peoples who assisted **Dál Fiachach** in the campaign. The list names forty-seven peoples, not fifty. The first three are mentioned twice in immediate succession, and so may have been counted as six by the compiler of the list, who doubtless aimed at collecting fifty names and ceased to extend his list when it seemed to reach that number. These migratory bodies are described by a term (**loinges**, l. 103), indicating that they were already landless. The account of the **aithechtuatha**, BB 255a, has two lists, of which the first, ending on the line 18, contains 46 names. Most of these correspond to the names in the Dési story, and the list was doubtless extracted from a version of the story. These premisses fully sustain the interpretation of **déis** given by **D'Arbois de Jubainville**.


¶27] ***Airgéill** is given by **Hogan** on the authority of the index to **Stokes**'s Tripartite Life. The gen. pl. is **Airgiall**, but the nom. pl. in Middle Irish texts, as noted by me, is only **Airgialla**. The name seems to be of comparatively late formation, and cannot be classed with the old order of plural people-names.


¶27a] **Mac Fir Bhisigh** ( Genealogies, p. 54) quotes a poem on the **aithechtuatha**, which include ‘**Absdanaigh** for iarthar Erenn, for **Luachair** **Chairbrighe**.’ Further it is stated that the ‘**Absdanaigh** iarthair Erenn’ are of the **Fir Bolg**. See also Onomasticon Goedelicum Since **Cairbrige** is said to be an older name for **Ciarraige Luachra** (perhaps for the territory, from a people supposed to have anciently possessed it), the locality indicated is **Luachair** in western **Munster**.


¶28] As in **Airgialla**, so in several other plural names with o-stem, Middle Irish usage substitutes a strengthened nominative: **Araid** for ***Arai**, gen. pl. **Arad**, acc. pl. **Arada**; **Érna**, **Érnai** for **Erain**; **Fotharta**, **Gailenga**, **Mugdorna**, **Mugdornai**. The added syllable is occasionally maintained in gen. pl., e. g. septem genera **Gailinga**. Compare what has been said above on **Cruithni**, ***Cruithin**.




---

p.64


Collective Names
----------------


¶29] Already, before the earliest documentary period, a new formula has come into general use, that of collective singular names. Of such names there are five varieties:—
  

1. Dál followed by genitive eponym, e.g. **Dál Cais**.
2. Corcu followed by genitive eponym, e.g. **Corcu Duibne**.
3. Eponym compounded with -rige, e.g. **Boonrige**.
4. compounded with -ne, e.g. **Cuircne**.
5. Eponym compounded with -acht, e.g. **Cianacht**.


Loigis (Mid. I. Laigis, modern I. **Laoighis**, English **Leix**), gen. sg. Lóigse, may be a sixth variety.


¶30] Until the eighth century, this class of people-names, which I would call the second order, though long established, had not become stereotyped as in later usage. They were to some extent interchangeable. **Korku Reti** (Adamnan) = **Dál Riatai**. **Corcu Sai** (L. Arm.) = **Sairige**. **Dál Musca** = **Muscraige**. **Dál nEogain**, **Dál Cein** = **Eoganacht**, **Cianacht**. This interchangeable character shows that the different forms were felt to belong to one order or system of nomenclature, which is also proved by the applicability to all of the personal name-formula in moccu (Ogham mucoi, maqi mucoi), which becomes obsolete in the eighth century.


¶31] The eponym is occasionally feminine. From this and other indications, I have formed the opinion that the eponymous ancestor may be a divine or mythological personage. Many of the stories in which the genealogists relate the origin of these early groups bear a strong mythological character.


¶32] Dál is explained by the **Venerable Bede**, in reference to the **Dalreudini** (i.e. **Dál Réti**, **Dál Riata**), as meaning pars, and this among various senses of the word seems best suited to its usage in people-names: **Dál Réti**, Réte's division or section of the **Érainn**. The eponym may be often, if not always, the name of a divine ancestor.


¶33] Corcu (later Corco, Corca) appears as an indeclinable noun.[4](javascript:footNote('E900000-003/note004.html')) A
 possible connexion with coirce is suggested to me by **Professor Marstrander**: compare the use of Síl in later group-names, e.g. Síl Muiredaig.
  

The genealogists, ignoring the obvious fact that Corcu is a common generic term equivalent to Dál, supply an eponymous ancestor Corc for several of the peoples named in this form.




---

p.65


¶34] Dál is found before the following eponyms:—
  

{column 1}
2. Aengusa Musca
3. Airde
4. nAisci (Naisci?)
5. Araidi
6. Auluim
7. Oluim
8. Uluim
9. Baiscinn
10. Bardeni
11. Bairdine
12. Beccon
13. Birnd
14. Buachalla
15. Buain
16. Buinne
17. Bundruini
18. Cabail
19. Cabula
20. Cauala
21. Cairbri
22. Coirpri
23. Cais
24. Calathbuig
25. Cathula
26. Cealtru
27. Ceata
28. Céin
29. Céte
30. Ceide
31. Cethirnn
32. Codaid
33. Conchubuir
34. Condad[5](javascript:footNote('E900000-003/note005.html'))
35. Condaid
36. Condaith
37. Confinn
38. Congaile
39. Conluain
{column 2}
41. Connaig
42. Conrach
43. Corb
44. Cormaic
45. Cualni
46. Cuinn
47. Cuirb
48. Cuirc[6](javascript:footNote('E900000-003/note006.html'))
49. Cula
50. Dairine
51. Dalláin[7](javascript:footNote('E900000-003/note007.html'))
52. Damail
53. Didil
54. Ditil
55. Druithne
56. Duach
57. Duibne
58. Duluim
59. Echach
60. Eogain
61. Fiachach
62. Fiatach
63. Foichidh
64. Gabla
65. Gailline
66. Gella
67. Idnu
68. Imdae
69. nIochair
70. Luigne
71. Luigni
72. Luiscni
73. Luiscin
74. Macon
75. Meacon
76. Mecon
77. Maic Con
78. Mic Con
{column 3}
80. Maic Cuirp
81. Maic Néth
82. Maigin
83. Maigne
84. Maignen
85. Maignenn
86. Maithe
87. Maitti
88. Mathar
89. Math[8](javascript:footNote('E900000-003/note008.html')) Lego
90. Math[9](javascript:footNote('E900000-003/note009.html')) Lobha
91. Mathra
92. Mathrach
93. Matrach
94. Metrach
95. Maugnae
96. Mechon
97. Mochon
98. Menda
99. Meandach
100. Mendad
101. Mendato
102. Mendet
103. Mennaid
104. Medruad
105. Mendraide
106. Messe Corb
107. Mas Corb
108. Mes Corb
109. Messin Corb
110. Mos Corp
111. Mocoirp
112. Mo Dala
113. Mo Dola
114. Mo Dula
115. Moga
116. Moga Ruith
117. Muaigh
{column 4}
119. Mude
120. Mudine Indae
121. Mugaide
122. Mugaidithi
123. Mugith
124. Muigid
125. Muine
126. Muindi
127. Muisge
128. Muith
129. Musca
130. Na Cethre nArad
131. Nat Corp
132. Niad Corb
133. Niath Lega
134. [Niath Lobha]
135. Nimde
136. Nuidne
137. Nuidine
138. Nuisce
139. Nuiscidi
140. nOich
141. Riatai
142. Riata
143. Riada
144. Ruitne
145. Runtair
146. Runtir
147. Sailni
148. Seille
149. Tidil
150. Tidilli
151. Tri Conall
152. nUlad
153. nUlaim
154. Uoig
155. Urcon





---

p.66


¶35] Corcu is found before the following eponyms:—
  

{column 1}
2. Achland
3. Achlann
4. Athchlann
5. Achrach
6. Acrach
7. Adain
8. Adaim
9. Aengusa
10. hAibligh[10](javascript:footNote('E900000-003/note010.html'))
11. Ainge
12. Airtbe
13. Airtbind
14. Airtgein
15. Aland[11](javascript:footNote('E900000-003/note011.html'))
16. Andsae
17. Aola
18. Arad
19. Athrach
20. Ethrach
21. Auloim
22. Auniche[12](javascript:footNote('E900000-003/note012.html'))
23. Bairdni
24. Baiscinn
25. Bibuir
26. Bill
27. Birn
28. Bruidhi[13](javascript:footNote('E900000-003/note013.html'))
29. Caela[14](javascript:footNote('E900000-003/note014.html'))
30. Chaelraigi
31. Caullain
{column 2}
33. Ce[15](javascript:footNote('E900000-003/note015.html'))
34. Cede
35. Chéin
36. Cluain
37. Choemne[16](javascript:footNote('E900000-003/note016.html'))
38. Coilgenn
39. Comne
40. Condlaigen
41. Condluain
42. Chroissine
43. Croisin
44. Cuilend
45. Cuirn
46. Chuirnd
47. Culla
48. Dain[17](javascript:footNote('E900000-003/note017.html'))
49. Dálann
50. Dallan
51. De
52. Deala
53. Dega
54. Dene
55. Díne
56. Dimoena
57. Doine
58. Dome
59. Din
60. Ditha
61. Dithechtai
62. Condithechtai
{column 3}
64. Druithne
65. Duib[18](javascript:footNote('E900000-003/note018.html'))
66. Duibe
67. Duibne
68. Duibindi
69. Duibne
70. Duichne
71. Duin[19](javascript:footNote('E900000-003/note019.html'))
72. Duithne
73. Dula
74. Echlann
75. Echrach
76. Ela
77. Ele[20](javascript:footNote('E900000-003/note020.html'))
78. Ethrach
79. Echach
80. Ethach
81. Eoluim
82. Faimnia
83. Fásaigh
84. Ferai
85. Fiachach
86. Fiachrach
87. Fir Tri[21](javascript:footNote('E900000-003/note021.html'))
88. Irtri
89. Foche = Oche
90. Foduib[22](javascript:footNote('E900000-003/note022.html'))
91. Fuindche
92. Gaola
93. Iche
{column 4}
95. Inmend
96. Inomain
97. Itha
98. Laege
99. Láige
100. Loegde
101. Laegde
102. Laigde
103. Luigde
104. Luachra
105. Luigdech
106. Luigne
107. Ma
108. Maigh
109. Maighe
110. Maige Locha
111. Maigen
112. Maigne
113. Maradh
114. Mogha
115. Moda
116. Moncho
117. Mu Druad
118. 'Mdruad
119. 'Mruad
120. Muichet
121. Muichi
122. Muinche
123. Muinchi
124. Nechtae


---

p.67


{column 1}
128. Ochland
129. Oiche
130. Oche
131. Oirce
132. Oircthe
133. Oirchen
134. Oircthen
135. Olchind[23](javascript:footNote('E900000-003/note023.html'))
136. Reti
137. Riada
138. Righe[24](javascript:footNote('E900000-003/note024.html'))
{column 2}
140. Rinn
141. Rinne
142. Roeda
143. Roide
144. Raeda
145. Raeidhe
146. Raide
147. Raighe
148. Roeada
149. Ruaid
150. Ruisen
{column 3}
152. Sechlaind[25](javascript:footNote('E900000-003/note025.html'))
153. Selcind
154. Sochlend
155. Sogain
156. Suigin
157. Sodhain
158. Soilcind
159. Thede = Dál Céte
160. Themne
161. Temrach
162. Tened
{column 4}
164. Thened
165. Tethba
166. Timine
167. Tine
168. Toilgenn
169. Uais
170. hUiblig
171. hUiniche
172. Ulad
173. Ulum[26](javascript:footNote('E900000-003/note026.html'))



¶36] -rige has dative singular *rigiu.* Though I have no instance establishing the gender as neuter, still the ending is to be identified with the neuter noun *rige* ‘kingship’. Hence it would appear that groups of this order originally formed petty states each under its king. Historically, some of these groups are large enough to form several petty kingdoms, while others must have been mere village communities.


¶37] In these compounds rígion = ríge becomes[27](javascript:footNote('E900000-003/note027.html')) -rige. If the eponym retains a second syllable ending in a vowel, -rige suffers syncope, e.g. **Nechtarge** (eponymous in *moccu Nechtae*), **Osseirge**, later by metathesis or analogy, *Nechtraige, **Osraige***. The close correspondence between the territory of **Osraige** (diocese of Ossory, but anciently also extending much farther westward) and the place assigned by **Ptolemy** to the **Ousdiai** makes it likely that the names also are closely associated (Osse *-rge* = *Osdia-rígion? Should we not expect Uisserge?). When the eponymic element ends in *r* preceded by a consonant, only one r appears in writing: **Gabraige** = *Gabrorígion (eponym *Fer Dá Gabar*), **Bibraige** = **Corcu Bibuir**, **Odraige** also **Odorrige**. This arises from a usage in spelling, compare *gobann, Goibniu.*


¶38] In Middle Irish, there is an increasing tendency to substitute *-raige* for *-rige,* and the later MSS. show a strong preference for *-raide.* In the following list add *-rige, raige,* where the hyphen appears:
  

{column 1}
2. Ai-?
3. Aib-
{column 2}
5. Airb-[28](javascript:footNote('E900000-003/note028.html'))
6. Alt-
{column 3}
8. Allt-
9. Aman-[29](javascript:footNote('E900000-003/note029.html'))
{column 4}
11. Arb-
12. Art-


---

p.68


{column 1}
16. Au-
17. Baen-
18. Belt-
19. Bend-
20. Benn-
21. Bent-
22. Bendt-
23. Bennt-
24. Bib-
25. Biurraidh?
26. Bidb-
27. Bid-
28. Blad-
29. Blath-
30. Blae-
31. Blai-
32. Blod-
33. Blodh-
34. Boend-
35. Boand-
36. Boind-
37. Bocc-
38. Bodb-
39. Bolg-
40. Bonand-
41. Bond-
42. Bonn-
43. Bon-
44. Boon-
45. Borb-
46. Brecc-
47. Bresc-
48. Brocenn-
49. Brod-
50. Brug-
51. Bru-
52. Brui-
53. Cael-
{column 2}
55. Caen-
56. Cae-
57. Cai-
58. Cailt-
59. Cairb-
60. Cair-
61. Calb-
62. Cal-
63. Call-
64. Carb-
65. Cas-
66. Cath-
67. Cat-
68. Catt-
69. Cecht-
70. Cel-
71. Cell-
72. Cerd-
73. Cer-
74. Ciar-
75. Clom-
76. Cloth
77. Cnam-
78. Co-[30](javascript:footNote('E900000-003/note030.html'))
79. Coc-
80. Coil-
81. Coen-
82. Coin-
83. Coirp-
84. Coith-
85. Cond-
86. Con-
87. Corb-
88. Corbet-
89. Corc-
90. Corp-
91. Cort-
92. Cosc-
{column 3}
94. Coth-
95. Crec-
96. Creg-
97. Crech-
98. Crobert-
99. Crot-
100. Cuart-
101. Cuilen-
102. Cuin-
103. Cuir-
104. Cuiren-
105. Culindt-
106. Cup-
107. Cu-
108. Cur-
109. Curand-
110. Cuth-
111. Dart-
112. Dub-
113. E-?
114. Eigin-
115. Em-
116. Emen-
117. Eoch-
118. Erc-
119. Herc-
120. Fed-
121. Forb-
122. Frad- [31](javascript:footNote('E900000-003/note031.html'))
123. Gab- [32](javascript:footNote('E900000-003/note032.html'))
124. Gael-
125. Gail-
126. Gaman-
127. Garb-
128. Geg-
129. Glas-
130. Glunn-
131. Grafimin-
{column 4}
133. Grac-
134. Grag-
135. Graic-
136. Gran-
137. Grec-
138. Greg-
139. Gregi-
140. Gruth-
141. Gub-
142. Gubt-
143. Inninn-
144. Ladh-
145. Lagh-
146. Lam-
147. Lath-
148. Lat-
149. Latt-
150. Luad
151. Lubart-
152. Lubu*t*
153. Luch-
154. Lud-
155. Luid-
156. Luff-
157. Lug-
158. Luig-
159. Lus-
160. Man-
161. Mann-
162. Mas-
163. Masc-
164. Maugin-
165. Mughan
166. Med-
167. Meg-
168. Men-
169. Mend-
170. Menn-


---

p.69


{column 1}
174. Molt-
175. Musc-
176. Naind-
177. Necht-
178. Nechta-
179. Nos-
180. Nois-
181. Noth-
182. Nud-
183. Nudh-
184. Nuidh-
185. Nut-
186. Nuth-
{column 2}
188. Odor-
189. Od-
190. Orb-
191. Osse-
192. Ossa-
193. Os-
194. Pap-
195. Pab-
196. Part-
197. Rath-
198. Rech-
199. Ros-
200. Roth-
201. Roith-
{column 3}
203. Sai-
204. Saith-
205. Sciath-
206. Scorb-
207. Scot-
208. Sed-
209. Sem-
210. Semon-
211. Snob-
212. Sob-
213. Sub-
214. Sogh-
215. Sord-
{column 4}
217. Sort-
218. Sorth-
219. Suob-
220. Tac-[33](javascript:footNote('E900000-003/note033.html'))
221. Taec-
222. Tec-
223. Teoc-
224. Teoch-
225. Torc-
226. Trat-
227. Trad-
228. Tread-
229. Treg-
230. U-



¶39] The suffix -ne, dat. sg. -niu, points to a collective ending -inion. In Middle Irish, when the preceding consonant resists palatalisation, -ne becomes -na. In the following list, doubtless, many names are included which do not denote population-groups, since the suffix has a much wider application. The instances which are known to be people-names are indicated by (k).[34](javascript:footNote('E900000-003/note034.html'))
{column 1}
2. Mag Aibne
3. Aidne
4. Ailbine
5. Loch Aillinne
6. Loch Aindinne
7. Cluain Airdne
8. Airene
9. Cul Aisne
10. Mag Argarni
11. Belach mBarnini
12. Bechlarna
13. Beltine
14. (k) Blaitine
15. Blaittine
16. Blárna
17. Bogaine
{column 2}
19. Brefne
20. Brebne
21. Brestine
22. Loch Bricerne
23. Bruachairne
24. (k) Buaigni
25. Buichne
26. Cabcenne
27. Cluain Caichne
28. Cascene
29. Cúl Caissine
30. Mag Cargamni
31. Cattene
32. Cerne
33. Dún Cermna
34. Mag Cétni
{column 3}
36. Ath Coirthine
37. Coirtene
38. Dún Coistinne
39. (k) Conaille
40. Aes Conchinne
41. Mag Conchinne
42. (k) Conchuburne
43. Coningne
44. (k) Conmaicne
45. Creidne
46. (k) Cremthanna
47. Cremthinne
48. Ard Crimne
49. Crinua
50. Ard Cróinne
51. (k) Tuath Cruadhluinde
{column 4}
53. Cuairne
54. Cuerne
55. Mag Cualgerne
56. Áth Cuillne
57. (k) Cuircne
58. Ros Cuissine
59. Tráig Culcinne
60. Daimine
61. Dáimne
62. (k) Dáirine
63. Damhairne
64. Es Danainne
65. (k) Delbna
66. Delmne
67. Delna
68. Deoninne


---

p.70


{column 1}
72. Dergne
73. Dún Detchine
74. Detnae
75. Cúl Dreimne
76. Drebne
77. Drebine
78. Dún Dreimne
79. Mag Drithne
80. Duichni
81. Sliab Eblinne
82. Edne
83. Eilne
84. Eilbine
85. Cúl Emni
86. Loch Érne
87. Ernine
88. Etarbainne
89. Fertene
90. Findine
91. Benn Foibne
92. Ros Foichne
93. Foidne
94. Fuaithniu
95. Ard Gabreni
{column 2}
97. (k) Gailine
98. Gailinne
99. Gebtine
100. Gobnine
101. Goistine
102. Gratine
103. Greftine
104. Gruitini
105. Domnach Iarlainne
106. Áth Inroine
107. Inber Labrainne
108. Loch Labrainne
109. (k) Lathairne
110. Latharna
111. (k) Ligmuine
112. Locharna
113. (k) Luaigni
114. (k)**Luguirne**[35](javascript:footNote('E900000-003/note035.html'))
115. (k) Luigni
116. Mag Luidni
117. Mairtine
118. Áth Cliath Mairgene
119. Áth Liac Margini
120. Cuan Manainne
{column 3}
122. Tír Marcceini
123. Metine
124. Muscraige Mitaine
125. Midbine
126. Cluain Moescnae
127. (k) Tuath Mochtaine
128. Tuath Mochthuinne
129. Dún Muairne
130. Ailech Muirinne
131. Nemeni
132. Glenn Nemthinne
133. Ochaine
134. Oichene
135. (k) Ochmaine
136. Oicne
137. Caill Oichni
138. Oinmine
139. Ollbine
140. (k) Plaitine
141. Raigne
142. Raimhne
143. Saidni
144. Saimni
145. (k) Saithni
{column 4}
147. Scédni
148. Sceinni
149. Segene
150. (k) Semaine
151. Semoni
152. Semuine
153. Semne
154. Cúl Siblinne
155. Cúl Sibrinne
156. Dún Sraibtine
157. Dún Sraiftine
158. Dún Sraiptine
159. Taelcoine
160. Taiblene
161. Mag Taidcni
162. Talcainne
163. Talindi
164. Cluain Tibrinne
165. (k) Tretherne
166. Tuath Uindsinde
167. Mag Uaidni
168. (k) Uaithni



¶40] Interchange of formulae:—
1. **Dál Aengusa Musca** = **Dál Musca** = **Muscraige**
2. **Dál Auluim** = **Corcu Auloim**
3. **Dál Bardeni** = **Corcu Bairdni**
4. **Dál Baiscinn** = **Corcu Baiscinn**
5. **Dál Birnd**[36](javascript:footNote('E900000-003/note036.html')) = **Corcu Birn** = **Osraige**
6. **Dál Buain** = **Boonrige**
7. **Dál Céin** = **Corcu Chéin** = **Cianacht**
8. **Dál Céte**, compare **Corcu Cede**
9. **Dál Conchubuir** = **Conchubuirne**[37](javascript:footNote('E900000-003/note037.html'))
10. **Dál Conluain** = **Corcu Condluain**
11. **Dál Cormaic** = **Corcu Cormaic Lagen**
12. **Dál Cuinn** = **Connachta**
13. **Dál Cuirb**, compare **Corbraige**
14. **Dál Cuirc**, compare **Cuircne**


---

p.71

17. **Dál Druithne** = **Corcu Druithne**
18. **Dál Duibne,**, compare **Corcu Duibne**
19. **Dál Echach**, compare **Corcu Echach**
20. **Dál Eogain** = **Eoganacht**
21. **Dál Fiachach** = **Corcu Fiachach**
22. **Dál Luigne** = **Corcu Luigne**
23. **Dál Maigen**, compare **Corcu Maigen**
24. **Dál Maigne**, compare **Corcu Maigne**
25. **Dál Maugnae**, compare **Mauginrige**
26. **Dál Me Druad** = **Corcu Mu Druad**, **Corcumruad**
27. **Dál Mo Dula**, compare **Corcu Dula**
28. **Dál Moga**, compare **Corcu Moga**
29. **Dál Riatai** = **Korku Reti**, **Corcu Riada**
30. **Dál Ulad**, compare **Corcu Ulad**
31. **Corcu Bibuir**, compare **Bibraige**
32. **Corcu Cuirn**, compare **Cuirenrige**
33. **Corcu Dálann** = **Dál Dálann**
34. **Corcu Duib** = **Dubrige**
35. **Corcu Loegde**, also named **Dáirine**
36. **Corcu Och(a)e**, compare **Ochaine**
37. **Corcu Luachra** = **Orbraige Droma Imnocht**
38. **Corcu Nechtae**, compare **Nechtarge**, **Nechtraige**
39. **Corcu Ruisen** = **Tuath Ruisen**
40. **Corcu Sai** = **Sairige**
41. **Corcu Themne** = **Temenrige**
42. **Saithrige**, compare **Saithne**
43. **Semraige**, **Semonrige** = **Semaine**, **Semoni**, **Tuath Semon**



¶41] Of collective names in -acht, I have only three certain instances, all very prominent in history, **Cianacht**, **Connachta**, **Eoganacht**. The plurals **Cianachta**, **Eoganachta** are also frequent, especially when more than one subdivision of these groups is in question. Of the singular Connacht I have no example; but the phrase ‘teora Connachta’ shows that here, too, we have a collective noun. These instances may be added to ‘Bibracte’ cited by **Thurneysen** ( Altirische Grammatik, paragraph 262) in support of his view that the abstract nouns in -acht were originally collectives. Other possible examples are Ailech Esrachtae, Ard Cánachta, Cluain Cuallachta, Crích Cugennachte.


¶42] In my paper on the Moccu-formula ( Ériu, vol. 3), I brought together a number of instances to show that this formula, which was used as a kind of surname until the eighth century, had relation to the people-name, the eponym in the latter being extracted, so to speak, and its genitive preceded by moccu being used to form the surname or gens-name of the individual. I 


---

p.72



also showed that moccu in Old Irish was represented by mucoi or maqi mucoi in the Ogham inscriptions, and that the corresponding people-name, where it could be identified, belonged to the class of collective names which I have ventured in this paper to designate as the second order. With a view to testing these deductions more fully, I have brought together all the examples of mucoi and moccu which since then I have been able to collect. The result has been to confirm the deductions of my paper in Ériu. I have found no conflicting instance. In many cases, the corresponding people-name has not yet been discovered; but since it appears fairly certain that the formula always testifies to the existence of an ancient population-group whose name must have embodied the eponym found after mucoi or moccu, I give here the whole list of examples.


¶43] If I am correct in referring **moccu Elich** to **Éli**, and **moccu Echach (Echdach)** to **Dál Echach** = **Fothairt**, these instances, together with **moccu Baird**, appear to indicate that the formula was also applicable in the case of people-names of the first order. The rarity of the instances is a matter of course, considering that but few names of the first order were preserved, and that of these few a number, like **Érainn**, **Lagin**, comprised subdivisions of the second order. It is even probable, as **Corcu Sogin** beside Sogin suggests, that the collective formula could be applied to the older names treated as eponyms.


¶44] Eponyms following MUCOI and its variants in Ogham inscriptions:[38](javascript:footNote('E900000-003/note038.html'))
1. 1. ANAdo
2. 69. ALLDATO compare **Altraige**[39](javascript:footNote('E900000-003/note039.html'))
3. 76. BIDANI
4. 1902 p. 5. BRECI compare **Breccraige**
5. 162. CALLITTI compare **Cailtrige**
6. 183. CORIBIRI compare **Dál Coirpri**[40](javascript:footNote('E900000-003/note040.html'))
7. 126. CUNAVA*LI* compare **Conaille**[41](javascript:footNote('E900000-003/note041.html'))
8. 229. CUNIA
9. 246. DONmxI[42](javascript:footNote('E900000-003/note042.html'))
10. 18. DOVVINIAS **Corcu Duibne**[43](javascript:footNote('E900000-003/note043.html'))


---

p.73

13. 20. DOV   
[*...*]
14. 31. DOVINIA
15. 32. DOVINIA
16. 189. GLUNLEGGET
17. 211. IVODACCA
18. 214. LITOS
19. 212. LUGA
20. 247. LUGUNI compare **Dál Luigni**[44](javascript:footNote('E900000-003/note044.html'))
21. 1899 p. 427. LUGUNI **Luigne**[45](javascript:footNote('E900000-003/note045.html'))
22. 1895 p. 359. MACORA
23. 213. MACORBO op. **Dál Mocoirp**.[46](javascript:footNote('E900000-003/note046.html'))
24. 223. MaCoRBo
25. 196. MAQI EURI[47](javascript:footNote('E900000-003/note047.html'))
26. 3. MAQI MEQ [o . . .
27. 220. MEDALO compare **Dál Mo Dala**.
28. 1898 p. 397. MOITINI/ MEUTINI
29. 208. NETA SEGAMONAS[48](javascript:footNote('E900000-003/note048.html'))
30. 225. NETA SEGAMONAS
31. 231. NETA *SEGAM*ONAS
32. 237. ODARREA compare **Odrige**, **Odorrige**.[49](javascript:footNote('E900000-003/note049.html'))


---

p.74

35. 79. QERAI Cerrige, later **Ciarraige**.[50](javascript:footNote('E900000-003/note050.html'))
36. 160. QRITTI compare **Crothraige**
37. 218. ROTTAIS compare **Rothraige**, **Roithrige**.[51](javascript:footNote('E900000-003/note051.html'))
38. 198. SOGINI compare **Sogain**, **Corcu Sogain**, **Corcu Suigin**.
39. 88. TOICAXI
40. 89. TOICACI
41. 91. TOICAC
42. 149. TORIANI
43. 1903 p. 76. TREnAluGGo
44. 1896 p. 129. TRENAQITI
45. 109. TUCACAC[52](javascript:footNote('E900000-003/note052.html'))
46. 107. UDDAMI
47. 242. VALUVI
48. 139. VIRAGNI
49. 243. VIRI QORB



¶45] As applied to contemporaries, the quasi-surnames in moccu become obsolete in the eighth century. The latest instance I have found is that of **Luccreth moccu Ciara**, the author of a poem commencing Cú-cen-máthair maith in chland, which is found with the **Eoganacht** genealogy in the Books of Ballymote and Lecan and in Rawlinson B 502. From internal evidence this poem appears to have been composed early in the eighth century. In the Book of Leinster and later documents moccu is misunderstood as an equivalent of macc hui, filius nepotis, and commonly represented by mc. h., m.h., macc ua, etc. Abbreviations in the following list: MD (with date in calendar) = Martyrology of Donegal; LL, BB (with page of facsimile) = Book of Leinster, Book of Ballymote; Ad = Adamnan's Vita Columbae, Reeves, index; Onom = **Hogan**'s Onomasticon Goedelicum; Arm = **Hogan**'s Glossary to Book of Armagh; AU (with year of annal) = Annals of Ulster; SL = Stokes's Lives of the Saints from Book of Lismore, index.


¶46] . Eponyms following Moccu:—
1. LL 368 Ultan m. h. Aignich; see Eignich below
2. LL 368 Mo Boe m. h. Aldae[53](javascript:footNote('E900000-003/note053.html'))
3. BB 212 Mo Bhi qui dicitur me. h. Alla
4. BB 225 Brenaind me. h. Alta[54](javascript:footNote('E900000-003/note054.html')); **Altraige**


---

p.75

7. Brendenus mocu Alti; **Altraige**
8. 367 *367 changed to 931 on hardcopy by unknown corrector* Colman m*acc* Cuansi; compare **Corcu Andsae**
9. 368 Odran mc. h. Araide; **Dál Araidi**
10. BB 228 Odran me. h. Araide; **Dál Araidi**
11. Ad Comgellus mocu Aridi[55](javascript:footNote('E900000-003/note055.html')); **Dál Araidi**
12. MD Jun. 7 Mo Cholmocc mac ua Arta; **Artraige**
13. BB 225 Colum me. h. Arte; **Artraige**
14. LL 359 Nechtan m. h. in Baird[56](javascript:footNote('E900000-003/note056.html')) **Longo-Bardi**
15. MD Apl. 22 Neachtain mac ua Baird; **Longo-Bardi**
16. MD Aug. 30 Usaille mac ua Baird[57](javascript:footNote('E900000-003/note057.html')); **Longo-Bardi**
17. Ériu iv. p. 75 Sechnall macc ui Baird[58](javascript:footNote('E900000-003/note058.html')); **Longo-Bardi**
18. BB 226 Colman mc. h. Bairdine[59](javascript:footNote('E900000-003/note059.html')); **Dál Bardeni**
19. LL 367 Colman m. h. Bairddeni; **Dál Bardeni**
20. LL 356 Mo Cholmoc m. b. Beona
21. LL 373 Nem m. h. Birn; Dál (or Corcu) Birn[60](javascript:footNote('E900000-003/note060.html'))
22. MD Jun.14 Nem mac ua Birn; **Dál Birn** (or **Corcu Birn**)
23. Onom, p. 197 Cell macu Birn; **Dál Birn** (or **Corcu Birn**)
24. LL 368 Setna Dromma m. h. Blai; **Blairige**
25. Onom. Druim mic ua Blae; **Blairige**
26. Ad Lugbeus mocu Blai; **Blairige**
27. Arm Miliucc maccu Booin; **Boonrige**, **Dál Buain**
28. BB 226 Caindech mc. h. Buachalla; **Dál Buachalla**
29. LL 367 Cainnech m. h. Buachalla; **Dál Buachalla**
30. LL 368 Oidrine m. h. Buachalla; **Dál Buachalla**
31. Onom, p. 197 Cell maccu Buadáin
32. MD Oct. 4 Fionocc maccu Cha; compare **Cairige**, **Caraige**
33. LL 356 Ecca m. h. Chae; compare **Cairige**, **Caraige**
34. BB 227 Mo Laisi mc. h. Caidi; compare **Catrige**
35. LL 368 Mo Lasse m. h. Cáte; compare **Catrige**
36. LL 368 Mo Beoc m. h. Cati; compare **Catrige**
37. BB 227 Mo Beoc mc. b. Chaiti; compare **Catrige**
38. BB 227 Mo Laisi mc. h. Carraigi
39. LL 368 Mo Lasse m. h. Caisrige
40. LL 367 Colman mc. h. Chais[61](javascript:footNote('E900000-003/note061.html')); **Dál Cais**


---

p.76

43. BB 226 Column mc. h. Chais; **Dál Cais**
44. Ad Mater virorum mocu Ceiin; **Cianachta**
45. Ad Chonrii mocu Cein; **Cianachta**
46. Ad avia To Cummi mocu Cein; **Cianachta**
47. LL 368 Mo Chummae m. h. Chein; **Cianachta**
48. BB 227 Mo Chuma mc. h. Chen; **Cianachta**
49. BB 226 Comgall mc. h. Cein; **Cianachta**
50. LL 327 Comgall m. h. Chéin; **Cianachta**
51. LL 327 Findlug m. h. Chéin; **Cianachta**
52. BB 227 Fintan mc. h. Chen[62](javascript:footNote('E900000-003/note062.html')); **Cianachta**
53. BB 228 Mo Gobboc m. h. Chein; **Cianachta**
54. LL 368 Mo Gobboc m. h. Chein; **Cianachta**
55. Ad To Channu mocu Fir Cetea; **Dál Céte**
56. BB Lucreth macu Ciara; **Ciarraige**
57. LL 357 Lucill m. h. Chiara; **Ciarraige**
58. MD Jan. 31 Caindeach mac ui Chil; **Celrige**
59. BB 227 Fintan mc. h. Chind——
60. LL 290 Díl mc. hú Chrecga; **Creccraige**
61. LL 367 Colman mc. h. Coirtged[63](javascript:footNote('E900000-003/note063.html'))
62. BB 226 Colman mc. h. Coirtged[64](javascript:footNote('E900000-003/note064.html'))
63. LL 355 Cilline m. h. Colla compare **Corcu Culla**
64. *LL* 362 Ultan m. h. Conchob*uir*[65](javascript:footNote('E900000-003/note065.html')); Dál Conchobuir
65. AU Obitus Ultain moccu Choncobair; **Dál Conchobuir**
66. 662 Ultan moccu Chonchobair quievit; **Dál Conchobuir**
67. BB 228 Ultan mc. h. Conchubair; **Dál Conchobuir**
68. LL 368 Mo Lasse m. h. Chonna; compare **Dál Condad**
69. Arm Ad insolas Maccu Chor; compare **Cuirrige**
70. LL 367 Mo Chua mc. h. Choraig
71. BB 227 Mo Chua mc. h. Choraig
72. MD Mar. 16 Abban mac ua Corbmaic[66](javascript:footNote('E900000-003/note066.html')); **Dál Cormaic**
73. BB 123 Aban maccua Cormaic; **Dál Cormaic**
74. LL 357 Abbain m. h. Chormaic; **Dál Cormaic**
75. LL 364 Abban m. h. Chormaic; **Dál Cormaic**
76. MD Dec. 27 Fiacha mac ua Chorbmaic; **Dál Cormaic**
77. AU 663 Baetan moccu Cormaicc; **Dál Cormaic**
78. AU 690 Cronan moccu Chualne; **Dál Cualni**


---

p.77

81. MD Feb. 7 Mellan mac ui Cuinn; **Dál Cuinn**[67](javascript:footNote('E900000-003/note067.html'))
82. MD Sept. 10 Seighin mac ui Chuinn; **Dál Cuinn**
83. MD Oct. 9 Aedhan mac ui Chuind; **Dál Cuinn**
84. LL 362 Aedan m. h. Cuind; **Dál Cuinn**
85. BB 226 Colman m. h. Cuind; **Dál Cuinn**
86. LL 367 Colman m. h. Cuind; **Dál Cuinn**
87. BB 227 Mo Chua mc. h. Chuind; **Dál Cuinn**
88. LL 367 Findlug m. h. Chuind; **Dál Cuinn**
89. FM Ultan mac hui Cunga
90. AU 664 Ultan mac Caunga
91. Onom moccu Daimene; compare **Daimine**
92. Ad Cainnechus mocu Dalon[68](javascript:footNote('E900000-003/note068.html')); **Corcu Dalann**
93. BB 226 Caindech me. h. Dalann; **Corcu Dalann**
94. BB 227 Mo Laisi me. h. Dartada; compare **Dartraige**
95. LL 368 Mo Lasse m. h. Dartada; compare **Dartraige**
96. MD May 21 Inis mac ua Dartadha; compare **Dartraige**
97. AU 653 Colman epscop moccu Delduib[69](javascript:footNote('E900000-003/note069.html'))
98. LL 367 Colman m. h. Dulduil[70](javascript:footNote('E900000-003/note070.html'))
99. Ad Ercus[71](javascript:footNote('E900000-003/note071.html')) mocu Druidi
100. LL 362 Neman m. h. Duib; Dubrige, **Corcu Duibne**
101. MD Sep. 13 Naomhan mac ua Duibh; **Corcu Duibne**
102. MD Apl. 8 Aedhan mac ua Dhuibhne; **Corcu Duibne**
103. LL 358 Aedan m. h. Duibni; **Corcu Duibne**
104. MD Feb. 20 Colgu mac ua Duineachda; **Corcu Duibne**
105. AU 602 Quies Finntain filii nepotis Echdach[72](javascript:footNote('E900000-003/note072.html')); compare **Dál Echach**
106. Onom 539 Fintan maccu Echtach; compare **Dál Echach**
107. Onom 539 Fintan maccu Echtach; compare **Dál Echach**
108. Onom 539 (Fintan) moccu Edagur; compare **Dál Echach**
109. BB 228 Ultan mc. h. Eignich; compare **Eiginrige**
110. MD Apl. 9 Aedhac*h*[73](javascript:footNote('E900000-003/note073.html')) mac ua Elich; compare **Éli**
111. LL 358 Aedach in. h. Elich; compare **Éli**
112. LL 362 Finnio m. h. Fiatach; **Dál Fiatach**
113. AU 578 Quies Vinniani episcopi me. nepotis Fiatach; **Dál Fiatach**


---

p.78

116. BB 226 Findbarr mc. h. Fiatach; **Dál Fiatach**
117. LL 367 Findbarr mc. h. Fiatach; **Dál Fiatach**
118. MD Jan. 11 Suibne maccu Ir Tri; **Corcu Fir Tri**
119. BB 226 Colman m. h. Forgtech[74](javascript:footNote('E900000-003/note074.html'))
120. LL 367 Colmanm. h. F*or*tgech
[75](javascript:footNote('E900000-003/note075.html'))
121. LL 364 Mo Cholmoc m. h. Gualae *no*
h. Gáili[76](javascript:footNote('E900000-003/note076.html'))
122. Lecan 455 Eterscel Mor macu Iair[77](javascript:footNote('E900000-003/note077.html')); **Érainn**
123. BB 227 Mo Laisi me. h. Imdae; **Dál Imde**
124. LL 368 Mo Lasse m. h. Imda; **Dál Imde**
125. AU 638 Do Laissi maccu Imde; **Dál Imde**
126. BB 227 Mo Chua mc. h. Lapae
127. LL 367 Mo Chua m. h. Loppae
128. LL 368 Mo Gobboc mc. h. Laime; compare **Lámraige**
129. BB 227 Mo Gobboc in. h. Laime; compare **Lámraige**
130. AU 637 Cronan moccu Loegdae; **Corcu Loegde**
131. LL 367 Mo Chua in. h. Laigde; **Corcu Loegde**
132. BB 227 Mo Chua me. h. Laidgi; **Corcu Loegde**
133. BB 228 Mo Rioc me. h. Laigdi; **Corcu Loegde**
134. LL 368 Mo-Rióc m. h. Laigde; **Corcu Loegde**
135. ? Ad Columbauus mocu Loigse[78](javascript:footNote('E900000-003/note078.html')); **Lóigis**
136. MD May 16 Colman mac ua Laoighse; **Lóigis**
137. LL 360 Colman m. h. Laigsi; **Lóigis**
138. LL 356 Oenu m. h. Laigsi[79](javascript:footNote('E900000-003/note079.html')); **Lóigis**
139. LL Oenu in. h. Laigsi; **Lóigis**


---

p.79

142. SL 275 Enna maccu Laigsi; **Lóigis**
143. LL 368 Mo Shinu me. h. Lugair; **Luguirne**
144. BB 228 Mo Shinu me. h. Lugair; **Luguirne**
145. BB 224 Mo Caemo me. h. Lugair; **Luguirne**
146. Arm Dubthoch mc. h. Lugir; **Luguirne**
147. AU 789 Comotatio reliquiarum Mo Chua moccu Lugedon
148. Ériu 3, 138 Moccu Luigdech; compare **Corcu Luigdech**
149. Arm Muirchu maccu Machtheni; compare **Tuath Mochtaine**[80](javascript:footNote('E900000-003/note080.html'))
150. MD Jun. 8 Murchu mac ua Maichtene; compare **Tuath Mochtaine**
151. MD Jun. 8 Meadhran mac ua Maichtene; compare **Tuath Mochtaine**
152. BB 227 Loman mc. h. Maigni; compare **Dál Maigin**, Maigni
153. LL 367 Lonan m. h. Maigen; compare **Dál Maigin**, Maigni
154. LL 367 Mo Chua m. h. Manche
155. BB 227 Mo Chua mc. h. Manchi
156. BB 226 Fintan me. h. Milbae
157. LL 367 Fintan m. h. Milbai
158. Ad Lugbeus mocu Min; compare **Menraige**
159. Ad Lugneus mocu Min; compare **Menraige**
160. BB 228 Mo Shinu mc. h. Muind; compare **Menraige**
161. LL 368 Mo Sinu mc. h. Mind; compare **Menraige**
162. AU cxxxiii Mosinu Maccumin; compare **Menraige**
163. SL 335 Lugna maccu Moga Laim
164. Ad Laisranus mocu Moie
165. BB 227 Mo Laisi mc. h. Naithre
166. LL 368 Mo Lasse m. h. Naratha
167. LL 356 Mo Lassi m. h. Nechti; **Nechtarge**, **Corcu Nechtae**
168. LL 356 Mo Lasse m. h. Nechtai; **Nechtarge**, **Corcu Nechtae**
169. BB 227 Mo Laisi mc. h. Neachta; **Nechtarge**, **Corcu Nechtae**
170. MD Jan. 19 Mo Laissi maccua Nechte; **Nechtarge**, **Corcu Nechtae**
171. Onom 540 Moccu Necthin
172. Ériu 3, 138 Moccu Nemongin
173. MD Jun. 9 Cruimther mac ua Nesse
174. Ad Oisseneus mocu Neth Corb; **Dál Niath Cor**
175. AU cxxxiii. Mo Cuaroc maccu Neth Semon[81](javascript:footNote('E900000-003/note081.html')); **Semonrige**, **Semaine**
176. AU 584 Abb Cluana moccu Nois; compare **Noisrige**
177. LL 368 Mo Lóce m. h. Noise; compare **Noisrige**
178. BB 228 Mo Locae mc. h. Noise; compare **Noisrige**


---

p.80

181. BB 223 Colman mc. h. Nuadchon
182. AU 608 Quies Lugdach moccu Ochae[82](javascript:footNote('E900000-003/note082.html')); **Corcu Oche**
183. AU 677 Daircill moccu Retai; **Dál Riatai**
184. Ad Mailodranus mocu Rin[83](javascript:footNote('E900000-003/note083.html')); compare Corcu Rinn
185. Ad Erneneus mocu Fir Roide; **Corcu Roide**
186. LL 365 Tua m. h. Roida; **Corcu Roide**
187. LL 368 Tua m. h. Roda; **Corcu Roide**
188. LL 368 Mo Gobboc mc. h. Ruain
189. BB 228 Mo Gobboc mc. h. Ruain
190. Ad. Trenanus mocu Runtir; **Dál Runtir**
191. Ad. Colmanus mocu Sailni[84](javascript:footNote('E900000-003/note084.html')) **Dál Sailni**
192. Ad. Nemaidon (gen.) mocu Sogin; **Sogin**, **Corcu Sogin**
193. AU 548 Finnio moccu Telduib[85](javascript:footNote('E900000-003/note085.html'))
194. LL 367 Finnian m. h. Thelluib
195. BB 226 Finna mc. h. Tellduib
196. SL 335 Fidnian maccu Tellaig
197. MD Feb. 8 Colman mac ui Thealduibh
198. MD Dec. 12 Colman mac ui Thelduibh
199. BB 226 Colman mc. h. Tuilduib
200. Ad Luguid mocu Themne; **Temenrige**
201. AU 663 Comgan macu Teimne; **Temenrige**
202. MD Feb. 27 Commán macua Theimhne; **Temenrige**
203. MD Apl. 8 Luighthighern macua Trato[86](javascript:footNote('E900000-003/note086.html')); **Tratraige**
204. LL 359 Luchthigern maccu Tratho; **Tratraige**



¶47] The collective names do not always appear to contain a personal or ancestral eponym. In **Corcu Fásaig**, **Corcu Luachra**, **Corcu Maige Locha**, **Corcu Temrach**, **Corcu Tethba**, the determining word is a place-name, so that these names are referable to a usage in which corcu is still a common noun in general use.


¶48] The eponyms which are found with moccu prove that the eponyms supplied by the genealogists cannot always be accepted as representing an



---

p.81



accurate tradition. Thus the genealogists tell us that the **Ciarraige** are the descendants of Ciar, son of Fergus MacRoig, but the Ogham form Mucoi Qerai (MS. Moccu Ciara) shows that the true eponym should have been Ciara in Middle Irish. The **Artraige** are said to descend from a male ancestor Art, while the moccu formula has genitive Arta, Arte. That Corc Duibfind, as ancestor of **Corcu Duibne**, is a mere fiction of the genealogists would be sufficiently obvious if we had not the Ogham examples of **Mucoi Dovinias** and the MS. **moccu Duibne**. Láma, son of Conchobor macc Nessa, is the genealogical ancestor of the **Lámraige**, but the lists of saints have Mo Gobbóc moccu Laime. Laigsech Cennmór is the genealogical head of the **Lóigse**; Adamnanus has mocu Loigse. Neachtain [*...*] a quo **Neachtraide**, Lecan 453; Nemangein mac Neachtain do Uaithnib diata **Neachtraidi**, ib.; but **moccu Nechti**, Nechtai, Nechte, Neachta, and **Corcu Nechtae**. Fergus Oiche qui et Fogai, BB 169 b, Fergus Fogo, BB 218 c, Focha, ib. is ancestor of **Corcu Oche** and of S. Mo Lua = Luguid moccu Ochae, AU 608. If the genealogists have not lost the genuine tradition, they must have deliberately substituted masculine for feminine eponyms.


¶49] Adamnanus, in mocu Fir Cetea, mocu Fir Roide, introduces ‘fer’ (‘husband of’) before a feminine eponym. Cp. Conall mac Fhir Cheiti meic Deda meic Sin a quo Dal Ceiti la Mumain, Lecan 455.


¶50] Names in -rige appear sometimes to have the name of an animal for eponym. It is curious if **Bibraige** (compare **Corcu Bibuir**) contains the name of the beaver (compare **Bibracte**), for **Dr. Scharff** tells me that so far no remains of the beaver are known to have been found in Ireland, though it is known to have existed in Britain. Other instances are Bocc-, Catt-, Con-. Dart- (with moccu Dartada), Gabr-, Gaman-, Luch-, Molt-, Torc-. We cannot assert that the animal, even personified, was regarded as the ancestor, for the adoption of animal names (e.g. Conall Cú, Ailill Molt) was not rare. Moreover, as instances like **Ciarraige** show, the eponym may really have been a fuller form of the element which is retained in the people-name.


¶51] Some of the collective names appear to be based on the occupations of the people. Thus the **Semonrige**, **Tuath Semon**, or **Semmuine**, i.e. people of rivets, belonged to the coppermining district of the **Dési**, and the distinctive element in their name was not thought capable of forming an eponym; hence moccu Neth Semon = of the race of the Champion of the Rivets. In Bérre, Béarra, another mining district, were the **Cerdraige**. With this class of names we may perhaps connect **Tuatha Taiden** or **Fir Taiden**, people of mantles, and **Fir Bolg**, people of leathern bags. That **Fir Bolg**, commonly used as a name for the older subjugated race or races, was an extension of the genuine name of an historical people may be judged from the instances of **Bolgthuath**


---

p.82



and **Bolgraige** in Onomasticon Goedelicum[87](javascript:footNote('E900000-003/note087.html')) All these peoples with what seem to be ccupation-names belonged to the aithechtuatha; and their vassal-rents may have been paid in the products of the industries indicated by their names. Cp. also **Corbraige**, **Corbetrige**, **Sciathraige**, **Tuath Chathbarr**.


SEPT-NAMES
----------


¶52] A third order, arising out of the second or it may be out of the first, and no doubt later in time, consists of sept-names in which the genitive of the eponym is preceded by the word Aui, Ui, ‘grandsons, descendants’, e.g. **Ui Néill**, **Ui Fidgente**. Indeed that this class of name belongs to a later fashion of nomenclature than the collective names appears from the fact that, while all the collective names originate in a purely traditional period, the origin of at least a proportion of the early names in Ui can be assigned to the beginning of the documentary period.


¶53] In the genealogies, but not in general usage, there is a partial revival of sept-names in Ui, probably in the eleventh century, perhaps due to professional familiarity with the early nomenclature. In popular usage the only such instance at present known to me is **Íbh Laoghaire**, which seems to be the surname Ua Laoghaire, dative plural, belonging to a family of the western **Muscraige**. It is now the name of a district in the west of co. Cork. Surnames in Ua commence to be used in the tenth century: AU 914—Ua Maelsechnaill, 918 Ua Cléirig, 946 Ua Canannáin. As titles, without the fore-name, Ua Ciarda 953, Ua Ruairc 953, 964, 998. Over 40 other such surnames are found in this century. The statement adopted by **O'Curry** ( Ms. Materials, p. 214) that this usage was established by an ordinance of Brian Boroimhe, apart from the fact that regal decrees of the kind are unknown in Ireland before the Norman Invasion, is thus shown to be without foundation.


¶54] As in the case of the collective names, so in the case of sept-names in Ui, the eponym is sometimes feminine. Cp. **Ui Bairrche**, **Ui Brigte**, **Ui Duibne** (compare **Corcu Duibne**), **Ui Ercae**, **Ui Ferba** (beside **Ui Firb**), **Ui Ochrae**, **Ui Taisce**.


¶55] In my paper on the Irish Ogham Inscriptions, R.I.A. Proceedings vol. xxvii., p. 368, I adopted **Barry**'s view that the Ogham avi points to the sept-ancestor. Of sixteen instances there collected, five appear to be followed by feminine names; in two others the gender is doubtful. Hence apparently the proportion of feminine eponyms for septs named in the Ui-formula was much larger in early times than in the later MS. record.




---

p.83


¶56] I know no instance of a sept-name derived from a female ancestor within the documentary period. Hence I think that the feminine sept-eponyms had a religious, not a genealogical, import. Op. **Ui Brigte** and ‘Brigit banfile ingen in Dagda’ (BB 34 b 30), **Ui Ercae** and the forenames Macc Ercae = Maqi Ercias, Dar Erca, Ercavicas.


¶57] In the same paper, p 369, I suggested that ‘Anavlamattias mucoi Maqi Euri [Iari?] avi Axeras’ should be interpreted ‘Anblomaith of the **tuath** of Macc Iair and of the sept [thereof] Aui Acher.’ The sept-name has since then turned up: ‘Ac Ailill Fland Beacc comraices Hi Aicher & Mec Carrthaich .i. rigda [= rig] Desmuman’, Lecan 454. ‘At Ailill Flann Becc [the pedigrees] of Hui Aicher & the MacCarthaighs, Kings of Desmond, unite.’ The genitive Aicher = Axeras seems to indicate an Irish r-stem outside of the nouns importing the family relation.


¶58] In **Dál Niad Corb**, to which most of the Christian kings of Leinster belonged, the eponyms of the principal septs appear in the genealogies as sons of Cathair Mór: Ros Fáilge (**Ui Fáilge**) Dáire Barrach (**Ui Bairrche**), Bresa Enechglas (**Ui Enechglais**), Cétach (**Ui Cétaig**), Fergus Luascán (**Ui Luascáin**) Crimthannán (**Ui Crimthannáin**), Eochaid Timine (**Ui Timine**), Fiachu Ba Aiccid (**Ui Baicceda**), Dercmossach (**Ui Dercmossaig**), etc. The instance of **Ui Bairrche**, mentioned earlier, warns us that we do not stand here on any ground of solid strict historical tradition. Least of all need we expect to find even an approximately true chronology. In **Gilla Coemain**'s reckoning Cathair Mór should have been king of Ireland from A.D. 123 to 149. But in the Synchronism of 721, his reign requires to be placed quite a century later. Even this date appears too early, judged by genealogies.


¶59] The pedigree of Crimthann king of Leinster in St. Patrick's time (c. 450), is traced thus: 1. Cathair. 2. Fiacchu Baiccid. 3. Bresal Belach. 4. Labraid. 5. Enda Cennselach. 6. Crimthann. Allowing three generations to a century, the **floruit** of Cathair should thus be placed quite at the close of the third century. The Four Masters give 435 as the death-date of Bresal Bélach son of Fiacha Aicidh son of Cathair Mór. AU concurs. The most that can be said is that the majority of witnesses assign Fiachu, ancestor of Ui Baicceda, to the fourth century. In his line sept-names in Ui continue to be formed for several generations. From Labraid son of Bresal Bélach are named **Ui Labrada**; from Dúnlaing son of Énda Nia son of Bresal, **Ui Dúnlainge**; from Énda Cennselach son of Labraid, **Ui Cennselaig**. **Hui Maele Tuile**, from Mael Tuile son of Ronan s. o. Colmán s. o. Coirpre s. o. Ailill s. o. Dúnlaing, supply a late instance. Mael Tuile should have lived in the latter half of the sixth century. See LL 315 c.




---

p.84


¶60] The chief septs of the **Eoganachta** are traced to two sons of Ailill Flann Becc; Luguid and Dáire Cerba. 


*The Genealogical table of the Eoghanachta is reproduced in gentab1.pdf.*


¶61] The **Eoganacht** of **Cashel**, the suzerain line, do not appear to have taken any sept-name in Ui. The pedigree of Oengus (killed in 489, AU) is given as follows: 1 Ailill Flann Becc, 2 Luguid, 3 Corc, 4 Nat Fróich, 5 Oengus. According to the genealogical account, Ui-names among the **Eoganachta** arise from ancestors two generations older than Oengus, and continue to arise until an ancestor is reached two generations later than Oengus. The eponyms would appear to date from about the beginning of the fifth until the middle of the sixth century. Of course it is to be borne in mind that a sept-name in Ui is at least two generations later than its eponym, so that with the **Eoganachta**, septs continued to be named afresh under this formula until the end of the sixth century.


¶62] In **Dál Cuinn**, the starting-point of all the septs is Cairbre Lifechar. From Fiachu Sraiftine son of Cairbre descend the **Ui Néill** and the **Connacht** septs **Ui Briúin**, **Ui Fiachrach**, **Ui Ailello**, and **Ui Fergusso**. From Eochu Doimlén son of Cairbre descend the **Airgialla** and **Ui Maine**.


¶63] In the genealogies, Niall, Brian (Brión), Fiachra, Ailill, and Fergus are sons of Eochu Mugmedoin. Their period is the close of the fourth 



---

p.85



century and the beginning of the fifth. Lóiguire son of Niall was king of Ireland at St. Patrick's coming in 432, and died in 462 ( AU). Eogan son of Niall died in 465 ( AU), Conall Cremthainne son of Niall in 480. Nathi son of Fiachra succeeded Niall and preceded Lóiguire as king of Ireland.


¶64] The uncertainty of the genealogical tradition at this period is exemplified by the following counterstatements (Lecan 454):—
  

‘Sunt qui dicunt Fiachrach [read Fiachra] Brian Maine tri m*ei*c Domnaill m*ei*c Fiachrach Sraif*tini*. Sunt qui dicunt tri meic Fhiachrach Fhir Da Giall m*ei*c Cairp*ri* Lifeochair .i. na tri Cholla .i. Cotta Uas & Colla Mend & Colla da Crich a n-anmand.’


¶65] The **Ui Néill** do not subdivide into further septs named in this formula. Under **Ui Briún** (BB 89) arise **Hui Chanann** from Cano son of Brión; **Hui Du[i]b Dumach** from Dull Dumach s. o. Annad s. o. Fothad, s. o. Conall s. o. Brión ; **Hui Baeithin** from Baeithin s. o. Dui Galach s. o. Brión. **Hui Cormaic** from Cormac s. o. Fergus Cnoc s. o. Dui Galach. The eponyms in this line belong to the fifth and sixth centuries.


¶66] Under **Ui Fiachrach** (BB 107) arise **Ui Amalgada** (Amolngado) from Amolngid s. o. Fiachra; **Ui Echach Muaide** from Eachaid (recte Eochu) s. o. Nathí s. o. Fiachra; **Ui Suanaig** were a subsept of **Ui Echach**, but I have not found their pedigree. Excluding Suanach, the eponyms in this line belong to the fifth century. I have no account of subsepts named in the Ui-formula under **Ui Ailello** and **Ui Fergusso**.


¶67] Hence it appears, so far as has been investigated, that in the **Connacht** and Meath branches of **Dál Cuinn**, sept-names in Ui arise from eponyms referable generally to the fifth century.


¶68] **Airgialla** (BB 118): **Ui Tuirtre** from Fiachra Tort s. o. Erc s. o. Colla Uais s. o. Eochu Doimlén. 
**Hui Echach** from Eochu s. o. Feidlimid s. o. Fiachra s. o. Colla Da Chrích. **Hui Bresail** from Bresal s. o. Feidlimid aforesaid. **Hui Sinaig** from Sinach, fifth in descent from Feidlimid. **Hua Nialláin** from Niallán s. o. Fiacc s. o. Feidlimid. **Hui Cruind** from Crond s. o. Feidlimid. **Hui Méith** from Muredach Méith s. o. Imchad s. o. Colla Da Chrích. **Hui Fiachrach** from Fiachra s. o. Erc s. o. Eochu s. o. Colla Uais. **Hui Segain** from Segán s. o. Tuathal s. o. Feidlimid. **Hui Maicc Cairthinn** from Macc Cairthinn s. o. Eichen s. o. Fiachra Tort. **Hui Maine** from Maine Mór s. o. Eochu Fer Da Giall s. o. Domnall s. o. Imchad s. o. Colla Focrich (= Da Crích). **Ui Cormaic Maenmaige** from Cormac s. o. Bresal s. o. Maine. **Hui Duach** from Duach (Dui, Daui) s. o. Dallán s. o. Bresal s. o. Maine.


¶69] At 513 ( AU) is recorded the death of Cairpre Daim Argit, king of the **Airgialla**, s. o. Eochu s. o. Crimthann s. o. Fiac s. o. Daig Duirn s. o. Reochaid



---

p.86



s. o. Colla Da Crích. Colla should have flourished about two centuries earlier, i.e. at the beginning of the fourth century, and this date accords with the time usually assigned for the conquest of Mid Ulster by the three Collas. The eponyms of **Ui Sinaig** and **Ui Duach** are two generations farther than Cairpre Daim Argit from the common ancestor, and should belong to the latter part of the sixth century.


¶70] The septs of **Dál Cuinn**, the **Eoganachta**, and **Dál Niad Corb** were predominant throughout nearly all Ireland from St. Patrick's time until the Norman Invasion. Hence one may suppose that their traditions were more minutely recorded in the early MS. period than the traditions of less prominent groups; also that, so far as chronological checks were available, they were more operative in the history of these dominant lines. But it is evident that, even in their case, no anterior limit can be placed to the use of the Ui-formula except to say that it appears to mark a later classification than the collective names.


¶71] The Ui-formula is succeeded by one in which **cenél** precedes the eponym. This is conspicuous and of early occurrence in the case of the **Ui Néill**.


¶72] **Cenél Conaill**, **Cenél** , **Cenél Loiguiri**, **Cenél nEogain**, **Cenél Fiachach**, **Cenél Máini**, **Cenél nÉndai**, **Cenél nOengusso** take their names from sons of Niall, and their origin therefore from about the middle of the fifth century.


¶73] From sons of Eogan, **Cenél Muredaig**, **Cenél mBindig**, **Cenél Fergusso**, **Cenél nOengusso**, **Cenél nDalláin**, **Cenél Cormaic**, **Cenél Feidlimthe**, **Cenél nAilello**, **Cenél nEichein**, **Cenél nIllainn**, **Cenél nEchach**.


¶74] From sons of Muredach, **Cenél Feradaig**, **Cenél Tigernaig**, **Cenél Moain**. From Forggus s. o. Baetán s. o. Muirchertach s. o. Muredach, **Cenél Forgusso**. Muirchertach died about 530 (533 AU, 527 FM, 531 Chron. Scot.), Baetán in 571 ( AU), and a son of ‘Fergus’[88](javascript:footNote('E900000-003/note088.html')) son of Baetán in 619 ( AU). Hence we may regard the Ceneél formula in the **Ui Néill** line as based on fifth, sixth, and seventh century eponyms.


¶75] In the **Eoganacht** line, the symmetrical numbers of 24 sons and 24 daughters are assigned to Oengus s. o. Nat Fróich, (BB 172 b). Eithne Uathach, the woman-chief of the Dési, was mother of three of the sons, and hence their posterity is called **Cenél nEithne** (sic line 26). From Cennlán sixth in descent from Oengus, is **Cenél Cennláin**. **Cenél Fíngein** from 



---

p.87



Fíngen, of whose son Maenach, king of **Munster**, the death is recorded at 661 ( AU). There, as in the genealogies (BB 175), Fíngen's pedigree represents him as fourth in descent from Oengus. **Cenél Conaill** (BB 176) from Conall eighth in descent from Oengus; and **Cenél Caellaide** (ib.) from Caellaide s. o. Conall. **Cenél Cormaic** (ib.), eponym fourth from Oengus. **Cenél nDallain** (177), eponym third from Eochu Liathán. **Cenél mBuiric** (ib.), from a son of Eochu. Apparently the eponyms in this group range from the fourth to the eighth century.


¶76] The **Cenél** formula does not seem to have become customary in **Dál Niad Corb**. Two instances occur in the genealogy, BB 126 a, **Cenél nAengusa** and **Cenél Croichni**. Of **Cenél nAengusa** we learn only that they belonged to **Hui Maenaig**. At 127 a 36, it is stated that **Cenél Cruaicni** (= **Cenél Cróichni**) were of the **Eoganacht**.


¶77] Cenél in turn gives way to a number of terms, **cland**, **muinter**, **sil**, **slicht**, **teglach, tellach**, used contemporaneously.


¶78] In AU, the earliest contemporary instance of Cland is **Cland Chathail**, 912. At the obit of Cathal, 734, ‘a quo **Clann Cathail**’ is of course a late gloss. At 617, muinter (Blatini) and síl (Mescain) are probably common nouns not fixed in the names. The next instances of **muinter** are **Muinter Gerudain**, 1159, **Muinter Eolais**, 1169. **Síl Dluthaig** 633 ; **Síl Cathail**, 815. **Tellach Dunchadha**, 1258; **Tellach Echach**, 1298 (both indexed under Telach = Tulach). Dúnchad's death, 822 AU. Eochu, his brother (BB 91, cols. 1, 2).


¶79] **Clann** and **muinntear** are still used to form sept-names from surnames e.g. Clann Chon Ceanainn, Muintear Mheachair.


¶80] Although, then, there is considerable overlapping in date, there is a quite definite order of succession in the formulae, as exemplified in the following table:
  

1. Plural names (origin prehistoric): Laigin -- (unknown) -- (unknown)
2. Collective names (origin prehistoric): Dál Niad Corb -- Eoganacht -- Dál Cuinn
3. Sept-names in Ui (partly of historical origin): Ui Cennselaig -- Ui Liatháin -- Ui Néill
4. Cenél-names (from fifth century mainly): Cenél nAengusa -- Cenél nDallain -- Cenél
5. Gland, Muinter, etc. (from sixth century): Clann Maelighra -- Clann Chárthaigh -- Clann Cholmáin (Colman died 587)





---

p.88


¶81] We find the term **tuath** variously handled by modern translators. In the Annals of Ulster, Dr. Mac Carthy regularly gives ‘territories’ as the English of **tuatha**. Others render **tuath** by ‘tribe’, a conveniently vague word which covers everything from an ancient subnation like the **Ulaid** to a comparatively modern sept like **Clann Aodha Buidhe**. It is true that by a familiar figure of speech, **tuath** is often used of a territorial area, just as Norfolk, which once meant the North-folk, came to mean the district they occupied. By a different transference of idea, **tuath** came to signify the laity in contradistinction to **eclais** the ecclesiastical body or **cliar** the clergy, and still retains that meaning side by side with the meaning of ‘the country’ in contradistinction to the town. In both cases, tuath represents the ancient native tradition and the native order existing under the Irish civil law **dliged tuaithe**, whereas the Church lived under its own law, and the towns inherited in a modified form the municipal law of Rome.


¶82] Anciently **tuath** from *tóta, touta (teuta) appears to have denoted a civil community, a people united under one government, a **civitas**. In Ireland and Britain such communities retained the early form of kingly rule in an almost patriarchal shape. The petty states of Gaul and Galatia, before their subjugation by Rome, appear to have been for the most part republics, each ruled by a senate. The Irish **tuath**, then, must at one time have been a petty kingdom, but at the beginning of the documentary period a new order has already widely spread. Powerful families, aristocratic septs, have entered on a career of conquest. The scope of their operations being practically limited to Ireland, — for the only known exceptions are the temporary Irish acquisitions in western Britain and permanent conquest of Scotland by the **Dál Riada**, — the consequence was the substitution of ascendant dynasties for the older petty states throughout the greater part of Ireland. Thus the dynastic septs of **Dál Cuinn**, comprising the **Ui Néill**, **Ui Briúin**, **Ui Fiachrach**, and **Airgialla**, have acquired permanent authority over nearly all the northern half of the island. In **Munster**, the **Eoganacht** septs, **Ui Fidgente**, **Ui Liatháin**, **Ui Echach**, etc., and in Leinster, the septs of **Dál Niad Corb**, especially the **Ui Cennselaig**, have achieved a like position. All these families have set up many new kingdoms or petty states. Beside these states, and in a position of inferiority marked by the payment of tribute and furnishing of armed forces to them, a considerable number of small peoples remained, enjoying internal freedom under the government of their own dynasties. This is the condition of things described in the Book of Rights, and it will be noted there that, except in the north-eastern province, where the old order was less disturbed,



---

p.89



nearly all the free, i.e., non-tributary, states are known by the names of septs or families, and nearly all the tributary states by collective names or the older plurals.


¶83] In **Munster**, the free states are **Eoganacht Chaisil**, **Ui Liatháin**, **Raithliu** = **Ui Echach Muman**, **Eoganacht Locha Léin** = **Ui Coirpri Chruithnecháin**, **Ui Chonaill Gabra**, **Ui Coirpri Aebda**, **Eoganacht Glennamnach**,[89](javascript:footNote('E900000-003/note089.html')) Dál Cais. The tributary states are **Dési Muman** = **Dál Fiachach**, **Muscraige**, **Dáirine** or **Corcu Loegde**, **Ciarraige**, **Corcu Baiscinn**, **Arai**, **Uaithni**, **Éli**, **Corcumruad**, **Corcu Duibne**, **Orbraige**, the Sechtmad.


¶84] In **Connacht** the free states are: **Ui Fiachrach**, **Ui Briúin**, and their subdivisions. The tributary states are: **Umall**, **Grecraige**, **Conmaicne**, **Ciarraige**, **Luigne**, **na Corca**, **Delbna**, **Ui Maine**.


¶85] It is to the older groups especially that the term **tuath** is applied in early usage. Used with the name of a sept, e.g., **Tuath Ua nAengusa**, as the majority of the instances in Onomasticon Goedelicum clearly show, **tuath** denotes no longer a people, but a territory. In the list of vassal-communities **aithechtuatha** (BB 255 a Lecan 354), only two instances, **Tuath Ua Cathbarr** and **Tuath Ua Carra**, contain names of septs, and there are alternative readings which omit Ua, perhaps correctly, since Cathbarr seems to be genitive plural. In most of the rest, tuath is followed by a collective name, in some by a plural people-name.


¶86] In Gaul 44 **civitates** are named by Caesar. Subdivisions of these, or of certain of them, existed and are called by him **pagi**. He speaks of the **pagi** of the Helvetii, the Morini, and the Arverni. The Helvetii consisted of four **pagi**, of which Caesar names two, the pagus Tigurinus and the pagus Verbigenus. He also uses the plural Tigurini of the people of the **pagus**.


¶87] The fourfold subdivision of a Celtic people is also exemplified by the **Galati** of Asia Minor. Each of the three nations which formed the confederate republic of the **Galati** contained four subdivisions which the Greeks called tetrarchíai, and each of these was separately administered under its own chief or tetrarch. Instances occur in Ireland. The Lagin comprise cethri prímsloinnte, **Dál Niad Corb**, **Dál Messe Corb**, **Dál Corbmaic**, and **Dál Coirbbri**, the four eponymous ancestors being sons of Cú Corb.[90](javascript:footNote('E900000-003/note090.html')) The **Arai** comprise four divisions na cethri hAraid .i. **Tratraidi** (recte **Toeccraige**) & **Artraidi** & **Descert Cliach** & **Hui Fidban**, Lecan 451a.




---

p.90


¶88] The poem Caisil atcondarc ane, H. 3. 17, p. 724, has this quatrain:—
  


> 1. Ceithre Partraighe im Bri Ois,
>   
> ceithre Gailinga o cis Chais,
>   
> ceithre Cianacht cairde cneis,
>   
> ceithre Delbna dal chis Cais.
> 




¶89] A smaller subdivision among the Gauls is known to us by the Latin name **vicus**. Caesar, who captured a written census among the spoils of the Helvetii, says that this people, numbering in all 368,000, comprised 400 **vici**, so that each **vicus** averaged 920 inhabitants. The phrase vicani Segorigienses found in an inscription of the Prussian Rhine-Province, seems to point to a **vicus** named Segorigion. The Irish equivalent would be Segr(a)ige, which may be actually represented in the late Middle-Irish spelling Sedraige, one of the vassal-peoples named in the Book of Ballymote. Nevertheless, it is hardly likely that the Irish names in *-rige* and the other collective names of co-ordinate import originated as designations of a population so small as that of the Gaulish **vicus**. Rather it is fairly obvious that the continental *-rigion*, which must have once meant a people governed by a king, had degenerated in usage.


¶90] We may probably best regard the Irish group bearing a collective name as corresponding to the so-called **pagus** among the Gaulish peoples. There are sufficient indications that the collectively-named groups arose as subdivisions of nations bearing plural names. The instances of the **Lagin** and the **Arai** have already been noticed.


¶91] The **Cruithni** in Ireland included **Dál Araidi**, **Conaille**, **Lóigis**, and **Sogain**. ‘Do Chruithnibh Erenn do **Dhál Araidhe** na seacht **Laighsi** Laighen & seacht **Soghain** Erenn & gach **Conuille** fil in Erinn’ (**Mac F.** Genealogies unpaged, evidently a quotation from some early writer).


¶92] The **Érainn** included **Muscraige**, **Corcu Baiscinn**, **Corcu Duibne**, **Dál Riatai**, etc.


¶93] The **Galeoin** comprised three **tuatha**, **Tuath Fidga**, **Tuath Ochmaine**, and **Tuath Aithechda**.


¶94] The **Mugdoirn** **included Dubraige** or **Corcu Duib**, **Papraige**, **Ciarraige**, **Sortraige**, **Artrige**, **Corcu Inomain**, **Suobraige**. ‘Seacht maic Mu*g*doirn Duib .i. Dubh a quo Dubhraidhi oc Imleach Corco Duib Papa a quo Papraighi la Creamthanna Ciaro a quo Ciarraidhe Sort a quo Sortraige la Crimthanna a quibus Espoc Ibair mac Luighne Lasar ainm a mathar duna Deisib Art mac Mugdhoirn a quo Artrighe la Ullto Inomon a quo Corco Inomhain la Laighniu de quibus Lochene in sui irero drocaidh Sues dubh a quo Suobraidhe la Mugdornu a quibus Espoc Ethern i nDomnach Mor Maic Laifthi sed cuius filius Mugdorn Dub d'Ulltaib ignoratus (ignoratur).’ BB 110 a 38.




---

p.91


¶95] The **Papraige** here mentioned and the **Partraige** are the only known instances of peoples in Ireland whose name has P for initial. Note that the **Mugdoirn** were of unknown race. The **Partraige**, too, were regarded as aborigines. ‘Donab Partrigib annso. Par*traige* in Locha forsata Mag Thuireadh Cunga & Partraige Cheara & Par*traige* Clainde Fiach*rach* & Par*traige* Sleibhe .i. o **Cruaith** co **Loch nOirbsen** & Par*traige* Midhe forsambí Oilill & Meadhbh & do claind Genainn doib.’ H. 3. 17, p. 724. A poem on the same page, already quoted, pretends that they were descended from Art son of Oengus, king of **Cashel** in the fifth century, but no son of the name is assigned to Oengus in the genealogies. ‘Partraidi Cera, cid re Cloinn Diallaid (la Claind Fiachrach?), ni dib doib, acht is do Sen-Chondachtaib .i. do Chloind Genainn m*ai*c Deala m*ai*c Loith. Partraidi in Locha, ait ita Mag T*ui*read & Cunga, do Cloind Sreing m*ai*c Sengaind doib. Partraidi Shlebi .i. o **Cruaich** co **Loch nOirpsen**, & do Cloind Conaill Airisin m*ai*c Briain doib. Genel*ach* Partraidi annso. Radnall m. Aeda m. Mail Ruan*ada* m. Conaill m. Echach m. Diarmada in Lacha m. Domnaill na Tri Tuath .i. na tri Partraidi m. Setna otait Hi Setna .i. taisich Partraidi m. Conaill Oirisin m. Briain m. Ech*ach* Muidmedeoin.’ Lecan 458 a. This genealogy is not authentic. Brian (Brion), being a brother of Niall Noigiallach, must have lived about A.D. 400. Ragnall would accordingly have lived about A.D. 700; but since he bore a name adopted from the Norse, this date is out of the question. Accordingly it is natural to find that the Ui Briuin genealogies, though they mention Conall Oirisen, do not give the pedigree quoted above and do not include the Partraige or their chiefs among the Ui Briuin.


¶96] In the following passage the **tuath** is regarded as a chief subdivision of a people whose early name was remembered in the plural formula: ‘Attiadso na tuatha asa fail an **Gaileoin** hi cuigiud Lagen Tuath-Gabair. Teora fodla foraib .i. **Tuath Egdha** ocus **Tuath Ochmain** ocus **Tuath Aithechda**.’ ‘These are the **tuatha** whereof the **Gaileoin** in the Fifth of Leinster North of Gabair consist, **Tuath Fidga** and **Tuath Ochmain** and **Tuath Aithechda**.’ (H. 3. 17, p. 740.)


¶97] For variants in the foregoing quotation see Duanaire Finn, Introduction, p. lvii. That **Lagin Tuath-Gabair** and **Lagin Des-Gabair** constituted two of the ancient ‘Five Fifths of Ireland’ is clearly the ancient Ulidian tradition as told in Cath Ruis na Ríg, p. 22. The dividing locality was perhaps **Gabair Lagen**, which seems to be the valley between **Sliab Mairge** and the **Wicklow Mountains**, i.e. the southern part of Co. Kildare. **Osraige**, part of **Lagin Des Gabair**, anciently extended westward of the **Suir**. **Airmuma**, **Ormond**, i.e. *East-*Munster, lay to the west of the **Suir**. Ancient **Munster**, bounded on the east by the **Suir** and on the north by the **Shannon** estuary, was much too small to have included two of the ‘Fifths’, and the ‘Dá 



---

p.92



Chúigeadh Mumhan’ must belong to a comparatively late tradition. Hence no doubt the varying accounts of the twofold division of **Munster**. In one version the dividing line runs north and south, in another east and west. Neither version can be fitted into the story which makes **Uisnech** in the middle of Ireland the meeting-point of the five Fifths. A synonym for Cóiced Lagen Tuath-Gabair is Cóiced Coirpri Niath Fer. Coirpre is king of Tara and north Leinster in the Ulster cycle, his brother Find being king of south Leinster.


¶98] **Keating** ( Forus Feasa, ed. Comyn, p. 214) says that **tuath** is equivalent to **tighearnas**, and the proverb ‘is treise tuath ná tigherna’ shows that this interpretation is correct — at least as regards later usage. **Keating** also (ib., p. 112) speaks of a **tuath** as smaller in extent than a **triocha céad**. The Glens of Antrim, i.e. the baronies of Upper Glenarm, Lower Glenarm, and Cary, are called seacht dtuatha na nGlinne in nearly modern documents. Each of these **tuatha** would occupy a square of about five or six miles. But I find no indication that the **tuath** in early usage at all corresponded to the population of such an area. It was in fact a division of people — not of land — and must have been very variable in extent.


¶99] That the whole population was regarded as made up of **tuatha** may be inferred from the words of Fiacc's Hymn, ‘tuatha adortais side’, though again the same poem speaks of the Irish as one **tuath**, ‘for tuaith Hérenn bai temel.’ The former phrase may have reference to a particular worship in each **tuath**, and that each of them venerated special gods is evident from the oath-formula ‘tongu na tongat mo thuath’, ‘tongu do dia toinges mo thuath.’ This formula also shows that the **tuath** was the chief population-group with which the individual felt himself to be associated. Further instances of the use of the term follow here.


¶100] ‘**Corco Athrach** ainm na tuaithi ara fhuil Caisil ocus ise seo a fad .i. o **Thibraid Foraind** ac **Mainistir Uachtair Lamand** co **Duma nDresa** don taib bothuaid do **Chnoc Grafand** ocus do sil Aimirgin meic Mil*ed* Espaine di.’ Lecan,
p. 458. ‘**Corco Athrach** is the name of the **tuath** on which **Cashel** is, and this is its extent, from **Tipra Foraind** at **Holy Cross Abbey** to **Duma Dresa** on the northern side of **Cnoc Grafann**, and it is of the race of Amergen son of Mil of Spain.’


¶101] This is an important passage, confirming the tradition that **Cashel** was a comparatively late seat of the **Eoganachta**. Not only was the name of the **tuath** previously in possession remembered, but this **tuath** is spoken of as a contemporary people, whose ancestry has to be accounted for. Apparently the territory of this ancient people is still represented by the barony of Middlethird, of which the most northern point is at **Holy Cross**, and the most southern point near **Cnoc Grafann** about two miles north of **Cahir**. All this 



---

p.93



territory anciently belonged to the **Osseirge** or **Osraige**, since their bounds also extended to **Duma Dresa** and to **Grian** = **Pallasgreen**, co. Limerick, and the story of the **Dési** settlement represents the **Osseirge** as having been driven eastward across the river **Andobor** (**Anner**). The plantation of the **Dési** may be regarded as a concomitant of the occupation of **Cashel** by the **Eoganachta**. The **Dési** were settled partly in the baronies of **Slieve Ardagh** and **Iffa-and-Offa East**, thus forming, as it were, a buffer-state between the **Eoganacht of **Cashel**** and the dispossessed **Osseirge**.


¶102] Three grades of **tuatha** can be distinguished in early documents: (1) **Soerthuatha**, not subject to tributes; (2) **Fortuatha**, retaining internal autonomy but tributary to an external overking; (3) **Aithechtuatha**, vassal communities paying rent to local chiefs of free race. Genealogically, the **fortuatha** were held to be outside of the kindred of the overking and his people, and therefore subject to them; the **aithechtuatha** were regarded as of unfree race descended from the pre-Gaelic inhabitants.


¶103] The genealogical doctrine, however, must be taken as often expressing political status rather than racial origin. For this fact, which otherwise might be inferred from a study of the genealogies, we have the testimony of **Gilla in Chomded Hua Cormaic**, a twelfth-century poet (LL 144 a 24): —
  


‘Failet se muid sain mebair     cummaiscit craeb ngen*elaig*
  

totinsma daerchland ic dul     i-lloc saerchland re slonnud
  

Torrchi mogad mod mebla     ocus dibad tigerna
  
 
serg na saerchland étig uath     la forbairt na n-aithechthuath
  

Míscribend do gné eolais     do lucht uilc in aneolais
  

nó lucht ind eolais ni ferr     gníit ar múin miscribend.
  

Six ways there are of special note that confound the tree of genealogy:
  

intrusion of base stocks usurping the place of free stocks by name;
  

migrations of serfs, a way of shame; and decay of lords;
  

withering of the free races, dreadful horror; with overgrowth of the vassal folks;
  

miswriting, in the guise of learning, by the unlearned of evil intent,
  

or the learned themselves, no whit better, who falsify the record for lucre.’


¶104] The three discrepant origins — two importing free descent — assigned to the **Partraige** exhibit one instance, from many that could be cited, of this process of ‘confounding the tree of genealogy.’ By ‘migrations of serfs’ we may understand that, in time of conquest, unfree populations were enlisted among the invading forces and were rewarded with the possession of lands under 



---

p.94



free tenure, thus themselves rising to free status. In the very ancient and as yet unprinted story of how Conaire Mór became king of Ireland (BB 139 b), a great army comes unexpectedly to Conaire, who leads them to Tara and is chosen king. Thereupon (140 a 1) ‘gabt(h)air gabail lais dia slogaib’ ‘he makes a settlement of lands for his forces.’ So Eithne, the woman leader of the **Dési**, gathers a force of every landless people known to her in Ireland (‘nach loinges rofitir Eithne hUathach la Heirind’) for the war of conquest against Ossory, and twenty-five of these peoples obtain a land settlement (‘a cuic fichd dib tarthatar rand’) in the conquered territory ( Ériu 3, p. 138, 140). The right of migration was denied to vassal peoples by their lords, as is indicated in the story of the migration of the Sons of Úmór.


¶105] The following passage (Lecan, 450) indicates a people adscripti glebae: ‘**Catraidi** ata fogal fuirri (= fodal forru) .i. ata fogail ar aroile dib [is]in **Sechtmad** aroile dib isna **Deisib** aroile dib i **Cnamros** ni lecar asuidi[u] sin ac rig **Caisil** do gres ised bid.’ ‘The **Cattraige** are subdivided, i.e. some of them are distributed in the **Sechtmad**, others of them in the **Dési**, others of them in **Cnamros**. They are not allowed [to depart] thence. With the king of **Cashel** always they remain.’


¶106] The **Sechtmad**, ‘the Seventh,’ was a tributary state of east Munster, possibly better known by some other name. Its precise location has not been determined by **O'Donovan** in his edition of the Book of Rights or by **Dr. Hogan** in Onomasticon Goedelicum. In LL 382, col. 6, Arbura is said to be the ancestor of the **Sechtmad**, and as he is also ancestor of the chief sept of **Dál Coirpri**, whose chiefs in later times bore the surname Ua Duibidir, ‘O'Dwyer’, we may fairly identify the Sechtmad with O'Dwyer's country, the two baronies of **Kilnamanagh**, especially since this territory is not otherwise accounted for in the Book of Rights. See **Dr. Hogan**'s State of Ireland, Anno 1598, p. 208, footnote, where a quotation erroneously speaks of ‘O'Duire, descended from the O'Briens.’ **Dál Coirpri** was one of the ‘four chief stocks of the **Lagin**’, and its location, like the traditions of the **Dési** settlement, bears evidence of the early predominance of the **Lagin** and **Osseirge** in the part of **Munster** now called Co. Tipperary. **Cnamros** is perhaps identical here with **Cnámchoill** near Tipperary town. The **Cattraige** are included among the allies of the **Dési** in the war against **Ossory**.


¶107] ‘Atait da chenel deg soc*h*enelac*h* la Gaedealo a se dib a **Leith Cuind** .i. **Dal Cuind** **Dal Cein** **Dail nAraide** qui et **Cruithnig** **Dal Fiatach** qui et **Ulaid** **Dal Riata** **Dal Nat Corp**> qui et **Laigin**. A se aile a **Leith Moga** .i. **Dal n[E]ogain** **Dal Fiachach** **Dal Fiatach** **Dal Ceide** **Dal mBardine** **Dal Cais**. Ate sin saerthuatha Erend.’ H. 3. 17, p. 790). ‘The Irish have twelve kindreds of noble race. Six of them in Conn's Half, viz. **Dál Cuinn**, **Dál Céin**, 



---

p.95


**Dál Araidi** who are the **Picts**, **Dál Fiatach** who are the **Ulaid**, **Dál Riatai**, **Dál Nat Corp** who are the **Lagin**. Other six in Mug's Half, viz. **Dál Eogain**, **Dál Fiachach**, **Dál Fiatach**, **Dál Céte**, **Dál Barddeni**, **Dál Cais**. These are the free tuatha of Ireland.’


¶108] The foregoing statement is of great antiquity. Apart from the spelling, which has changed in transcription, the few distinctive forms belong to the Old Irish period, and are consistent with even the oldest written usage. Compared with the tenth-century account of the free and tributary states in the Book of Rights, this is evidently much earlier.


¶109] **Dál Céin** = **Cianachta**. It may also possibly include **Luigne**, **Gailing**, and **Saithne**, all claiming descent from Tadg son of Cian. In the Book of Rights, these states are tributary to **Dál Cuinn**, i.e. to the **Ui Neill** and **Ui Briuin**, the superior states of Ailech, Meath, and **Connacht**. In this respect they are on a level with **Umall**, **Grecraige**, **Conmaicne**, **Ciarraige **Connacht****, **Delbna**, **Dési Breg**, **Cuircne**. In the early annals, **Cianachta Breg** are evidently a very strong state, often hostile to the kings of Meath and Brega. Cp.  AU 534, 776, 816, 849, 850.


¶110] The inclusion of **Dál Nat Corp** (**Neth Corb**, **Niath Corb**, **Niad Corb**) in Conn's Half reflects the traditional claim of **Dál Cuinn** to the **Bórama** tribute from Leinster. **Dál Niad Corb** was the ruling race over Leinster during most of the early documentary period. **Leth Moga** in the passage cited is synonymous with **Munster** alone.


¶111] **Dál Eogain** = **Eoganachta**. **Dál Fiachach** was the dynastic people of **Dési Muman**. I can find no **Dál Fiatach** in southern Ireland, and take it to be a mistake for **Dál Fiachach Éle**, also called **Corcu Echach (i.e. Fhéchach) Éle**. There is frequent confusion between the genitives *échach*, of Eochu, and *[fh]échach*, of Féchu, Fiachu, in genealogies, etc. The conventional writing of silent f *(f)* is not customary before the ninth century. A twofold pedigree of **Dál Fiachach Éle** = **Corcu Echach Éle** (Lecan 457) illustrates this confusion: — ‘G*ene*lach Ele Descirt annso. Duineochaich mac Echach Ele c*uius* f*rater* Cellach m. Dungaile m. Beicci
  


m. Cermada
  

m. Bleidine
  

m. Enna
  

m. Bresail Milairi
  

m. *Maic* Cairthinn
  

m. Conaill
  

m. Nendtacair
  

m. Aililla 
  

m. Echach
  

m. Feidlimid Rechtmair
  

Nó Conall
  

m*ei*c Airt
  

m. Fiacha*ch*
  

m. Neill Naigiall*aich*
  
’


¶112] The most interesting names in the list of the free **tuatha** of Ireland are **Dál Céte** and **Dál Barddeni**. Neither is even mentioned in the Book of Rights. Of the location of **Dál Barddeni**, we only learn that it was at 



---

p.96


**Dún Cermna**, the **Old Head of Kinsale**, and there is no indication that this people held any considerable power or territory during the documentary period. Of the habitat of **Dál Céte**, **Dr. Hogan** has only been able to find that it was somewhere in **Munster**, and I am unable to supplement his information. The latest evidence of the contemporary existence of **Dál Céte** is the name of To Channu mocu Fir Cetea mentioned by St. Adamnan. All this tends to show that the list of twelve free **tuatha** is of great antiquity, probably not later than the eighth century, possibly even earlier.


¶113] Traditional corroboration of the early celebrity of these two peoples is afforded by the fact that, in the genealogies of the **Érainn** (the race of Conaire Mór BB 139), which occupy 10 1/2 pages of the Book of Ballymote, the first place is given to the **Érainn** of **Dún Cermna**, **Dál Barddeni**, and **Dál Céte**. The pedigrees give only three or four generations of the descendants of ‘Cather by whom **Dún Cermna** was made.’ The accompanying legend says:—
  

‘En aicme dec do **Dail Bairrdene**, .i. Sil Aengusa m*ei*c Echach m*ei*c Bairrdene meic Rigbaird ditat **Martene** iarna ndilgiund do **Leith Cuind** ar ba lethrann da **Dal Cede** & do **Dal Bairrdene** co sin ar is .x. catha ro mebaig re n-**Ernaib** for **Ulltu** & .uiii. catha fri h-**Ulltu** for **Ernu**.’ ‘**Dál Bardeni** (i.e. the race of Aengus son of Eochu s. o. Bairrdene s. o. Rígbard, from whom are the **Martene**) consisted of eleven septs after their extermination from (or by) Conn's Half, for until then it was an equal division (sc. of Ireland) between **Dál Céte** and **Dál Barrddeni**, for it is ten battles that the **Érainn** won over the **Ulaid**, and eight battles that the **Ulaid** won over the **Érainn**.’


¶114] ‘**Dál Araidi** qui et **Cruithnig**. **Dál Fiatach** qui et **Ulaid**.’ Cp. BB 170 b 15: ‘. . . na h-**Airgialla**, *{R. 143a 13}* **Dail nAraigi** fri suide anair, ainm ele doib **Cruthnich**. **Hulaith** fri suide anair. Ind **Ulaich** seo tra asbertar. **Dal Fiatach** indsin, do cloind Con Rai m*ai*c Daire m*ai*c Deadad a Coiced Con Rai la **Mumain**, is as a mbunad in **Dal Fiatach** so qui et **Ulaith** hodie dicuntur. Is *{Ba}* dib Aed Ron ocus Fiachna.’ ‘The **Airgialla**; **Dál Araidi** to the east of these, another name for them is **Cruthnich**. The **Ulaid** to the east of these. These **Ulaid**, **Dál Fiatach** they are called, of the posterity of Cú Rúi son of Dáire son of Dedu from Cú Rúi's Fifth in **Munster**, thence is their origin, this **Dál Fiatach** qui et **Ulaith** hodie dicuntur. Of them are Aed Róin and Fiachna.’


¶115] The foregoing passage is from a brief general description of the ruling races of northern Ireland, obviously written by a southern writer. It probably dates from a time not long subsequent to the reigns of Aed Roin and Fiachna his son, who were kings of the **Ulaid**, and whose pedigree is given under **Dál Fiatach**. Aed Róin fell in battle with the **Ui Néill** in 735. With him 



---

p.97



was slain Conchad, king of Cuib, i.e. of **Ui Echach Cobo**, the most prominent sept of **Dál Araidi**. In Fragments of Irish Annals, an. 732, Conchad is called ‘king of the **Cruithni**.’ ( AU 734, editor's note.) ‘Fiachnae mac Aedho Roen, rex Ulad, mortuus est’, AU 788.


¶116] The following ‘kings of the **Cruithni**’ in AU are found in the pedigrees of **Dál Araidi**: Eochaid Iarlaithe (died 665), Cú Cuaran (died 707), Cathusach son of Ailill (died 748). The genealogist in BB (168 col. 1) makes this Cathusach father of Cú Cuaran who preceded him. The father of Cú Cuaran must have been Cathusach son of Mael Dúin and king of the **Cruithni** (died 681 ( AU).


¶117] I do not find a genealogy of **Dál Fiatach** from Cú Rúi or from Dedu, but their descent is traced to Sen, father of Dedu, and thence by the same line as the **Érainn**, Cú Rúi's people, up to Oengus Tuirmech and the line of Éremon.


¶118] The passage above quoted from BB is followed by a comment of a contradictory character: ‘Ite fir-Ulaich im*morro* .i. **Dál nAraide** ota Mael Breasail mac Ailella hi Conall Cernach arisesedar ocus im Iriel Glunmáir i ngenelaich **Dal Araide**.’ ‘The true Ulaid, however, are **Dál Araidi**, of whom comes Mael Bressail son of Ailill. In Conall Cernach they originate, and in Iriel Glúnmar, in the genealogy of **Dál Araidi**.’


¶119] ‘Mael Bresail mac Ailello Cobo, rex **Dal Araide**, moritur, AU824.’ The text of the passage in BB was probably written between the death of Aed Róin, 735, and the death of Fiachna, 789, or not long after the latter event; the comment during or soon after the reign of Mael Bressail. arisesedar = *ara-sissetar. The relative form *ara* of *air, ar* seems obsolescent in the Milan glosses (see **Thurneysen**, Handbuch 387, 4).


¶120] The Irish **Cruithni** of **Dál Araidi** are called **Cruithni** for the last time in AU at 773 (= 774). Half a century or so later, the claim is set up for them that they are not only **Ulaid**, descendants of Conall Cernach, but that they are ‘the true Ulaid’, as if in protest against the belief that they are **Picts**. This claim was extended to all the leading branches of the Pictish race in Ireland (see section 91). Rather, I think, we can trace the claim as originating with another branch, the **Conaille**.


¶121] The chief section of the **Conaille**, forming the state of **Conaille Muirthemne** under their native kings, occupied a territory closely associated with the great hero of the **Ulaid**, ‘Cú Chulainn Muirthemne.’ It is not surprising that they sought to connect their own tradition with the epic tradition of the **Ulaid**. Accordingly we find in the genealogies, BB 152, under a section entitled in the margin, De peritia Conaille M*ur*th*emne*, two conflicting accounts of their descent. Their eponymous ancestor Conall Anglonnach is first described as a son of Dedu, and from the pedigree of their king Cinaed on



---

p.98



the next page it appears that this Dedu is the son of Sen, i.e. the same from whom the **Érainn** of **Munster**, **Clanda Dedad**, trace their descent. But in the first pedigree appended Conall Anglonnach becomes son of Fiacc son of Russ son of Fachtna son of Senchad of the Ulidian hero-group. At the end of the pedigrees of their kings (153, col. 1), many of whose names can be identified in the annals, comes the statement: ‘Do chloind Conaill Cernaich araili dib .i. in rigraid’, ‘Of the posterity of Conall Cernach are some of them, i.e. the royal line,’ in contradiction of the pedigrees that precede. On p. 169 there is a further chapter headed, G*ene*l*ach* Conailli Murtheimni, probably taken from another source. Here the eponymous ancestor is called Conall Casdamail, and he is made out to be seventh in descent from Conall Cernach. Thus, as **Gilla in Chomded** says, ‘the tree of genealogy is confounded.’ Conall Cernach supplied a tempting eponym to the **Conaille**, a Pictish race, and having been adopted by them was adopted by other Pictish kindreds, **Dál Araidi**, the **Sogain**, and the **Lóigse** of Leinster (BB 164 a 2).


¶122] Wherever the **Ulaid** are mentioned in vol. i. of the Annals of Ulster, they are the people of the **Dál Fiatach** dynasty, quite distinct from **Dál Araidi** and **Conaille**, often at war with one or the other. The **Ulaid** occupied the seaboard of Co. **Down**. The **Picts** of **Dál Araidi** occupied the interior of that county as well as a large part of Co. **Antrim**.


¶123] ‘Ag Conn tra fogailter (= fodailter) clanda Cuinn ocus it fortuatha **Sil Cuind** cach aen na berar genilaig [*read* genelach] co Conn *eter* naem ocus cleir*ech* amail ata Lugaid [*read* **Luigne**] ocus **Dealbna** ocus Gailinde [*read* **Gailing**] ocus **Cianachta**. Ag Cathair di*diu* fogailter saerc*h*landa Laigean ocus it fortuatha coicid Cathair can [*read* cach] aen na berar co Cathair amail atait secht Laissi [*read* **Lóigsi**] ocus secht **Fotharta**. Ag Ailill Olom fogailter saerc*h*landa Mumhan: can [*read* cach] aen na berar g*ene*l*ach* go Ailill, it fortuatha **Sil Eachach Mumo** amail atait Eirna [*read* **Érainn**] ocus **Ciarraige**.’ (H. 3. 17, p. 774.)
  

‘At Conn the [pedigrees of] **Clanda Cuinn** are divided, and all [in Leth Cuinn] whose pedigree is not traced to Conn, not excluding even saint and cleric, are **fortuatha** of the race of Conn, for example the **Luigne**, **Delbna**, **Gailing**, and **Cianachta**. At Cathair [Mór] are divided the free races of Leinster; all who are not traced to Cathair are **fortuatha** of Cathair's Fifth, as are the seven **Loigsi** and the seven **Fothairt**. At Ailill Olom are divided the free races of **Munster**; all whose pedigree is not traced to Ailill are **fortuatha** of the race of **Eochu Mumo**, as are the **Érainn** and the **Ciarraige**.’


¶124] The same statement occurs more briefly in the Book of Lecan, p. 459:—
  

‘Ag Cund Cetchathach m*a*c Feidlimid Rechtmair fodailter saerclanna **Leithi



---

p.99



Cuind** ocus it **forthuatha** [*read* fortuatha] **Sil Cuind** acht sin nama. Ac Cathair Mor m*a*c Feidlimid Fhir Urglais fodlas saerclanda **Laigen** uili ocus it fortuatha **Laigin** acht sin nama beo*us*. Ag Ailill Olum mac Moga Nuadad fodailter saerclanda na **Muman** ocus it forthuatha [*read* fortuatha] acht sin.’


¶125] In the lists of **aichechtuatha**[91](javascript:footNote('E900000-003/note091.html')) by far the larger part of the names are collectives in Dál, etc. The remainder are in various forms, e.g., **Tuath Raisen** or Ruisen, **Tuath Fer Morc**, **Tuath mac nUmoir**. Two, **Tuath Ua Cathbarr** and **Tuath Ua Carra**, exhibit the later nomenclature of septs, but even these have variants omitting Ua.


¶126] Instances occur of the application of the term **tuath** to population-groups with plural names, not in a vague and general way like tuath Hérenn = the Irish,  **Dé** = God's people, the Israelites, but apparently as a customary and appropriated designation of local groups.


¶127] **Bolgthuath**: There are two groups so named. **Bolgthuath Badbgna** of **Sliab Badbgna** or Bodbgna (**Slieve Baune**, co. **Roscommon**), and **Bolgthuath Echtge** of **Sliab Echtge** (**Slieve Aughty**, co. **Galway**). Cp. **Bolgraige**, an **aithechtuath** in **Tír Conaill**. **Mac Fir Bhisigh** ( Genealogies, p. 54) quotes among the branches of the **Fir Bolg**, besides ‘**Bolgthuath Bagna** for airther **Connacht**’ and ‘**Bolgraighe** for criochaibh Conaill’, ‘**Fir Bolg** for **Mhagh Nia Benntraighe**’ and ‘**Fir Bolg** ar Mhagh Luirg.’ As all these names occur in what is evidently a consecutive list of the **aithechtuatha** of **Connacht**, the **Magh Nia** in question is the plain also called **Mag Tuired Cunga**, at **Cong**, co. **Mayo**. It is evident that **Fir Bolg** (= **Bolgthuath**, **Bolgraige**) was the name of a known historical population existing in various parts of **Connacht** and in north-western **Ulster**. Its location and its vassal status, importing early conquest, as well as the traditions of its existence in Ireland before the **Góedil**, show clearly that the **Fir Bolg** must not be equated with the historical **Belgae**. The name was extended in the Irish history-legend at an early period so as to denote the whole or main population of Ireland before the **Góedil**.[92](javascript:footNote('E900000-003/note092.html'))


¶128] **Cruithentuath**: This seems to be a general name for the **Picts** in Ireland and in Scotland. But it is also used as a special name for the **Picts** of **Dál Araidi**, ‘Cú Chuaráin rí **Ulad** & **Cruthentuaithe**,’ ( Onomasticon Goedelicum, p. 312 ; for Cú Cuaráin see section 116), and for **Tuath Chruithnech**, a Pictish vassal people ‘round Cruachain,’ the old capital of the **Connachta**. There was also a vassal people or rather a scattered population so named ‘in the country of the Ulaid and in Mag Cobo’ and ‘between **Sídán Slébe in Chairn** and **Loch Febal** and between **Bernas Tíre Aeda** and the **Bann**’ ( Onomasticon Goedelicum 650), these four places



---

p.100



being merely the ancient extremities of the large territory of the **Airgialla**. **Tuath Chruithnech** is thus assigned to a region equal to modern **Ulster** except the counties of **Donegal**, **Antrim**, and **Cavan**.


¶129] **Tuath Fer nDomnann** or **Tuath Domnann**, a vassal people throughout **Ui Fiachrach** and **Ui Amalgada** in northern **Connacht**.


¶130] **Tuath Fer Morc** or **Tuath Morcc**, a vassal people in **Ui Conaill Gabra** (in co. Limerick); ‘.i. fir mora batar immon Luachair nDedad thíar.’ (LL 269 a.)


¶131] **Tuath Fer Ruisen** or **Tuath Ruisen** (Resen, Raisen), in **Cera** (bar. **Carra**, co. **Mayo**) and from **Ath Moga** (**Ballymoe** = **Bél Átha Moga**, on the river **Suck**) to the sea. Also **Raissin** separately, ‘cath Raissen in **Connacht**’, Onomasticon Goedelicum s.v. raisse (recte Raissin). Cp. also **Sliab Raissen** or Rusen
= **Slieve Rushen**,[93](javascript:footNote('E900000-003/note093.html')) bar. **Knockninny**, co. **Fermanagh**. Cp. **Corcu Ruisen**.


¶132] **Tuath Sen-Érann**, a vassal people at **Sliab Luachra** in west **Munster** ‘Sen-Erna mor [*read* Sen-Érainn Móir ?] na **Muman** ar slicht Heir meic Eibir Find meic Miled Espaine.’ (Lecan 349.)


¶133] These instances, with **Corcu Ulad**, **Dál Ulad**, **Corcu Sogain** or **Suigin**, **Corcu Ele**, **mucoi Sogini**, **mocu Sogin**, **moccu Elich**, seem to indicate that the various collective formulae might be applied to ancient peoples named in the plural formula, perhaps chiefly when these had not subdivided into groups bearing collective names.


¶134] **Tuatha Forc** ocus Iboth: ‘Na tri Fothaid .i. Fothad Aircteach Fothad Cairpteach Fothad Canand. Tri m*ai*c Fainche ingine Nair m*ai*c Irmora d'**Aruib Cliach**. Berid Fainche eamnu t*er* (trí ?) f*er*m*a*cu. D' Ibdachaib di Ulltaib a mbunad .i. da m*a*c[94](javascript:footNote('E900000-003/note094.html')) Irel Glunmair Forc ocus Iboth. Dos-fagaib Rechtaig Rigderg i nAlbain oro (=coro) muigedar catha remhaib consealgadar cricha mara i nAlbain comdar fasa. Giallsat Fir Alban do Rechtaid Rigderg comba ri Erenn ocus Alban. Is de atait Tuatha Forc ocus Iboth allai do lodar iiii. l. f*er*m*a*caib for longeas tairis anall for gabail ro gabsat Cluchriu ocus ni fortad *{fortaat}* gabsat crich Maine ocus crich Fiachrach Aidhne gabsat Baisgind a comarbus a seanmathar Uaithne ingean Eachach m*ai*c Luchta. Tir ele *{nEile}* ota Sinaind siar ocus D*er*c; fo thuaid conadh de anmannaib na mban dingart*er* a cenel ocus a ngenelaiche ar luidh indara nai go Caela Rigderg .i. Eli conid de gairt*er* Eli luid araile cu Fergus Foltlebur .i. Uaithne conid de gairt*er* Uaithne ocus robadar na ceatraimid[95](javascript:footNote('E900000-003/note095.html')) do cl*aind* Uaithne .i. Uaitnia ocus Druithnia ocus Cainnia ocus Decnia. Tri brait*hr*i .i. Uaithnia ocus Druithnia ocus Cain*n*nia.’ Sunt qui dicunt Macnia .i. athair na m*a*c .i. na F*h*othad m*a*c Cairbri m*ai*c Corm*ai*c m*ai*c



---

p.101



Mesi Suad m*ai*c Mesin Fuirc m*ai*c Mesin Fuircill m*ai*c Cairbri m*ai*c Iboth. Alii dicunt tri Fot*h*aid .i. tri m*ai*c Feidlimthe m*ai*c M*ai*c-Niat*h* *maic* Gnathail m*ai*c Erc m*ai*c Cairbri Niath Fer m*ai*c Feidlimthe Foltcaim. Is de ata Le*cht* Gli*n*d Erc is de ata ro ced no orabi rig-domna bad mo Erc m*a*c Feidlimte .i. i loc ro baite. Huc us*que* de Salterio Caisil.


Aliter cland C*h*onaill C*h*ernaich .i. Eogan ocus Oil*il*l ocus Fen F*er* Tl*acht*ga Caithnia ocus Druithnia *ocus* Uaithnia .i. Uaithni Thire ocus Uaithni Cliach q*uod* fortasi u*er*ius. (BB 164b.)


‘The Three Fothads, i.e. Fothad the Silvern, Fothad the Chariot-rider, and Fothad Canann, three sons of Fainche daughter of Nár son of (Fer Mora?) of the **Arai of Cliu**. Fainche gives birth to three manchildren at one birth. Of the **Ibdaig** of the **Ulaid** was their origin, i.e. Forc and Iboth were two sons of Irial Glúnmár. Rechtaid Red-arm leaves them in Alba and they won battles and utterly wasted great territories. The Men of Alba submitted to Rechtaid Red-arm, so that he became king of **Ériu** and **Alba**. Hence are the **Tuatha Forc** and Iboth (on the other side?). They came with four times fifty manchildren on a voyage across from that side to settle on lands. They occupied **Cluchri**,[96](javascript:footNote('E900000-003/note096.html')) and they no longer dwell there. They occupied the country of (Ui) Maine and the country of (Ui) Fiachrach Aidne. They occupied (Corcu) Baiscinn in succession from their grandmother Uaithne daughter of Eochu son of Luchta. (They occupied) another territory westward from the Shannon and northward from (Loch) Derg. So that by the names of the women are distinguished, their kindreds and their genealogies. For one of them went to Caela Red-arm, to wit Eli, and hence the Eli are named. Another went to Fergus Longhair, to wit Uaithne, and hence the Uaithni are named. And there were four champions (?) of the family of Uaithne, namely Uaithnia, Druithnia, Caínnia, and Decnia. Uaithnia, Druithnia, and Caínnia were three brothers. Sunt qui dicunt Macnia, father of the boys, i.e. of the Fothads, son of Cairbre s.o. Cormac s.o. Mes Suad s. o. Mes Fuirc s. o. Mes Fuircill s. o. Cairbre s. o. Iboth. Alii dicunt, the Three Fothads, three sons of Feidlimid s. o. Macnia s. o. Gnáthal s. o. Erec s. o. Cairbre Nia Fer and Fedelm Foltcoem.[97](javascript:footNote('E900000-003/note097.html')) Hence is [named] Lecht Glinn[e] Erc. Of him it was sung (?), ‘there was no (?) prince of the royal line greater than Erc, Fedelm's son.’ That is, where they were drowned (is the Grave of the Glen of Erc). Huc usque de Psalterio Caisil.’


‘Aliter the children of Conall Cernach, i. e. Eogan and Ailill and Fen Fer Tlachtga (or Fénfer 'Fian-man' of Tlachtga), (also named)



---

p.102



Cathnia, Druithnia and Uaithnia, i.e. (the ancestors of) Uaithni Thíre and Uaithni of Cliu, quod fortasse uerius (est).’


¶135] With **Tuatha Forc** compare **Insi Orc**. **Tuatha Iboth** are doubtless the old traditional inhabitants of the **Hebrides**, **Ebudae Insulae**. **Ibdaig** = *Ebudaci.[98](javascript:footNote('E900000-003/note098.html')) They are said here to be of the **Ulaid**. Iubdán (= *Ebudagnos) in the Death of Fergus, Silva Gadelica, is king of an oversea country of dwarfs.


¶136] Uaithnia, Druithnia, and Cainnia appear to be artificial eponyms of the **Uaithni** (hence the baronies of "**Owney**" in Tipperary and Limerick), **Dál Druithne** in Ui Maine (‘west of the Shannon and north of Loch Derg’), and **Caenraige** (hence "**Kenry**" barony, co. Limerick). These Irish **Ibdaig**, like the Irish **Picts**, have Conall Cernach assigned to them as ancestor. Their traditional habitat (Kenry, Owney, Aidni, Ui Maine, Corcu Bascinn seems to correspond with the position of the **Auteni** or **Auteini** (= Uaithni?) in **Ptolemy**'s account.


The Tricha Cét = Thirty Hundreds
--------------------------------


¶137] The term **tricha cét** in late usage denotes a certain measure of territory. **Keating** ( Forus Feasa, ed. Comyn, p. 112) gives the extent of the provinces of Ireland in this measure as follows: Meath proper (an Mhidhe féin), 13; Breagha, 5; Cúigeadh **Connacht**, including Clare, 30; Cúigeadh Uladh extending southward to the **Boyne**, (35 or) 36; Cúigeadh Laighean, 31; Cúigeadh Eochaidh (sic), i.e. eastern Minister, 35; Cúigeadh Con Raoi, i.e western Munster, 35. Total 185.


¶138] **Keating** adds (p. 128) that **Ulster** at one time contained only 33, the other three having been ceded by **Leinster** in the time of the Pentarchy (aimsear na gCúigeadhach), i.e. in the Ulidian heroic period. There is evidently a cross-division somewhere; and the total of 185 must be excessive. The **Ulster** and **Leinster** fifths meet at the **Boyne**, so that these provinces must include the five tricha-céts of **Brega**. **Mide**, too, i.e. central Ireland exclusive of **Brega**, is traditionally a province of late origin, and there must be an overlap in its case also.


¶139] The whole account suggests an ancient (perhaps theoretical) division of Ireland into five provincial kingdoms, each fifth (cóiced, cúigeadh) containing thirty-five tricha-céts.


¶140] The thirtieth part of a tricha-cét, says **Keating**, is a **baile** or 




---

p.103


**baile biataigh**. Since **tricha cét** means ‘thirty hundreds’, the **baile** must represent the hundred. This at once suggests the Germanic hundred and the Latin **centuria**, as divisions of the people. The original Roman **populus** contained thirty **curiae**. The principle of organization appears to have been at once genealogical and religious, each **curia** having its own rites presided over by a priest called **curio**. The thirty **curiones** formed a priestly college of the whole state. Traces of a similar unity of the genealogical and religious principles are also indicated in ancient Ireland (see section 56). The female eponyms in Ireland have their analogue too in the Roman **curiae**, some of which were said to have derived their names from the Sabine women who were the mothers of the Roman people.


¶141] The Roman centuries, forming the comitia centuriata, were a civil organization on a military basis. This, we shall see, was also the original character of the Irish **tricha cét**. It denoted not only the civil organization of the people, and the corresponding division of the territory, but also the armed levy of each state.


¶142] There are many ancient statements bearing on this point which still require to be collected. For the present, one passage in Táin Bo Cuailngi will serve as a locus classicus. It occurs at the episode in which Medb takes note of the smart discipline and warlike efficiency of one section of her allies, the **Galians** of Leinster. Their superiority to her own troops evokes in her mind only a jealous dismay, and she decides to order a treacherous massacre of the **Galians**. Her Ulster comrade, Fergus, resolutely opposes this design, and threatens to lead the allies against Medb if she persists in it. This argument prevails, and Medb contents herself with separating the **Galians** into small troops and distributing them throughout the army.


¶143] ‘By the truth of my conscience,’ said Fergus, ‘no man shall do death to them but the man who will do death to me.’ ‘Thou, Fergus, must not say that to me,’ said Medb, ‘for I am strong enough in numbers to slay and overwhelm thee with the thirty-hundred of the **Galians** around thee. For I have the seven Maines with their seven thirty-hundreds, and the Sons of Magu with their thirty hundred, and Ailill with his thirty-hundred, and I too have a like force. There we are, strong enough to slay and overwhelm thee with the thirty-hundred of the **Galians** around thee.’


‘It is not fitting to tell me so,’ said Fergus. ‘For I have here the seven petty kings of the **Munstermen** with their seven thirty-hundreds. There are here the thirty hundred of the best fighting men of **Ulster**. There are here the best of the fighting men of Ireland, the thirty-hundred of the **Galians**. I am their security, their guarantee, and their safeguard from the day they left 



---

p.104



their own native territory, and by me they will stand on the day thou challengest.’


¶144] The allied forces under Medb thus consisted of nineteen separately organized bodies, each under a local king and each consisting of thirty hundred men. Thirty hundred, in fact, was the traditional complement of the army of a petty state.


¶145] The technical name of the whole levy of 3,000 men was **cath**. Where the Annals of Ulster (1222) have the entry: ‘ro thinolsat **Gaill **Erenn**** cethri catha fichet co Delgain, co táinic Aedh O Neill ocus Mac in Uga cethri catha na n-aghaidh’, the D text says: ‘numerati 24 completa bella, qui faciunt Hibernica numeratione 72 millia armatorum   
[*...*]  
 12 millibus armatorum, numeratione suprascripta.’


¶146] The Irish **cath** or **tricha cét** has its exact counterpart in the **legio**, originally the whole army or normal military levy of the Roman state. The Roman tradition was that under Romulus, i.e. in the earliest times, Rome had but one legion, and this legion numbered 3,000 men, i.e. 100 men from each of the thirty tribes.


¶147] The Romans divided their fighting population into two classes, **juniores** and **seniores**. It seems clear that they originally regarded the young men as forming the normal fighting strength of the population, and the older men as forming a reserve which might be called out to meet an emergency. **Juventus** is an habitual term for the folk of age to serve in arms. Precisely the same usage is found in Irish. In the passage cited above from Táin Bó Cuailngi, the word which I have twice translated ‘fighting men’ is **óic** = (juvenci) juvenes, juniores, juventus, and numerous examples of this usage could easily be collected.


¶148] As the Romans grew into a great military power, they did not abandon the ancient constitution of their army, but retained and developed it. Instead of expanding their army indefinitely with the growth of their state, they could only think of forming additional bodies on the model of their primitive army of 3,000, and this they continued to do even under the Caesars.


¶149] In the Spartan army, we can trace the same tradition. The army consisted of six mórai, and the móra at one period numbered 500 men, giving a total of 3,000 men. Each of the three Dorian tribes of Sparta before Cleomenes contained ten wbaí, making thirty wbaí in all. In Athens, in the age of Theseus, each fratría contained thirty g[eacgr ]nh.


¶150] ‘The phalanx soldiers in the army of Alexander amounted to 18,000 and were divided   
[*...*]  
 into six divisions, each named after a Macedonian province from which it was to derive its recruits.’[99](javascript:footNote('E900000-003/note099.html')) Each province would thus



---

p.105



correspond to the Irish **tricha cét** and the army of each province to the Irish **cath** of 3,000 men.


¶151] The century remained the theoretical basis of the Irish military organization until the final overthrow of the Celtic system at the battle of Kinsale, Christmas Eve, 1601. In the proclamation issued in that year by **O'Neill**, it is ordered that ‘the constable of the hundred shall have eighty-four men on the strength, allowing an abatement of sixteen men, and this abatement shall be expended as follows: the constable of the hundred shall have the wage of ten men thereof, and the marshal of the territory shall have the pay of five men, and the lord's galloglach shall have the pay of one man.’[100](javascript:footNote('E900000-003/note100.html'))


¶152] The facts here brought together appear to establish that the Irish **tricha cét**, its thirtieth part the **baile**, and the Irish military organization embodied a tradition common to many peoples of ancient Europe, and going back to a time when these peoples formed one community or a group of neighbouring communities. I trust that this superficial examination may lead to a more thorough investigation at competent hands into the earliest traditional form of the civil and military organization among the various branches of the Indo-European race.


¶153] **Keating** says that, ‘ according to the ancient record (do réir an tseanchusa), the **baile** contained 12 **seisreacha**, and the **seisreach** 120 acres.’ The word for ‘acre’, **acra**, is not of Irish origin, and must have replaced some older term. Later on, **Keating** says that ‘the acre of Irish measure is twice or thrice greater than the acre of the present foreign measure.’ ‘The acre of the present foreign measure’ probably means the Irish ‘Plantation acre’, which is greater than the statute acre in the ratio 196:121. Ireland is said to contain 20,819,928 statute acres, equivalent to 12,853,114 Plantation acres. According to **Keating**'s statement, the 185 tricha-céts should be equal to 7,992,000 acres of (the older) Irish measure. But since his total of 185 is too much by at least 5, probably by more than 5, his total of acres must also be reduced. Moreover, by the statement ‘twice or thrice greater’ we are to suppose, not that **Keating** was unable or neglected to give a more exact ratio, but that in fact the Irish measure varied according to the nature of the land. The Irish tradition of land-measurement, still by no means obsolete, was based on the quantity of live stock that a given area could support. 



---

p.106



Hence no doubt the extent of the **tricha cét** was variable according to the fertility and population of the district.


¶154] The rise of the great septs, about the commencement of the Christian period in Ireland, must have greatly changed the older political subdivision of the country, sometimes dividing and sometimes combining the more ancient petty states. In some instances the **tricha cét** appears to have survived as a petty state. In others, it is divided between two distinct political organisations. In others as many as ten **tricha céts** form the kingdom of a single sept. There may well have been instances in which the early territorial state was split into fragments, though there is a visible tendency down to the seventeenth century, when the baronies of the English regime were marked out, to adhere to remotely ancient territorial delimitations. The following passage (Lecan, 460), describing the territories possessed by **Dál Cuinn**, is instructive:


¶155] ‘Cland Chuind andso fo Erind .i. Fir Breg ocus Fir Midi ocus Fir Thulach ocus Corco Rocada a n-ingnais a buil do deoradaib acu. Is iadso iadside .i. Luigne ocus Gailenga ocus na Saidne ocus H*ui* Aeda Odba ocus na scacht nDealbna ocus l*eth*-tricha cét Cuircne ocus l*eth*-tricha chet Teallaig Modaran ocus tricha chet Fear mBile. Cland Chuind .i. fiche baili na Colaman ocus tricha chid[101](javascript:footNote('E900000-003/note101.html')) Fini Gall ocus Airgialla[102](javascript:footNote('E900000-003/note102.html')) im*orro* seacht tricha chet dec indti[103](javascript:footNote('E900000-003/note103.html')) ocus deich tricha Cen*iuil* Eogain ocus deich tricha Cen*iuil* Conaill ocus leith-tricha Cen*iuil* nEnda ocus leith-tricha Cen*iuil* nAengusa ocus leith-tricha Fer Tulach ocus deich trichaid cét Breifni ocus deich tricha H*ua* Maine acht tri tuatha nama .i. **Sodain** ocus **Dal nDruithne** ocus **M*uin*t*er* Mail Findain**. Sil Muireadaig Muilleathain ocus Sil Briain m*ei*c Each*ach* Muigmedoin in cach du itait ocus in da Chairpri .i. Cairpri Mor Droma Cliab la cloind Fhiachrach m*ei*c Echach Muidmedoin ocus Cairpri O Ciarda la Firu Midi. Sil Dathi o clad Chonachla co Codnaich Cloindi Pui*n*t. Muinter Murchada cona coibnesaib ocus Cland Coscraig. Fir Umaill cona ngablanaib.’


¶156] ‘Sil Fiachach Sui*g*di m*ei*c Feidlimid Rechtmair .i. Corcortri la Corand i Condachtaib dia mbai Diarmaid H*ua* Duibne ocus H*ui* Chuind cona fineadaib .i. uirrig Corcorthri cor dichuirsed cland Taidc m*ei*c Cein m*ei*c Ailill*a* Ulaim a Mu*m*i*n* ocus is do Corcortri H*ui* Dobailean scus H*ui* Duindchaichig ocus H*ui* Ail*ell*a dia roibi **Mac Liag** .i. in fili. Na Deisi im*orro* do cloind Fiachach Sui*g*di .i. deich tricha-cet intib cona fochenelaib i n-egmais Semaine .i. leith-tricha cet ita ar slicht Semuine m*ei*c Cechai*n*g m*ei*c Celtair *nó* Semaine m*ei*c Cealtc*h*air m*ei*c Uitheochair dia ndeachaid ar cend Cealtchair diaid marbtha 



---

p.107



Blai Brugad do Cealtchair tre et na dun ocus na Deisi Breg cen airem andsin. Fir Bili ocus Fir Asail is do cloind Fiacha*ch* Sui*g*di atat.’


¶157] ‘Fotharta dochodur co Laigniu do chloind Echach Find Fuath nAirt m*ei*c Feidlimid Recht*mair* .i. na .uii. Fotharta in cach baili itait.’


¶158] ‘The following are Conn's race throughout Ireland: Fir Breg and Fir Midi (the men of Brega and Meath), and Fir Thulach and Corcu Roide, apart from what they have of immigrants. The latter are these: Luigni and Gailing and the Saithni and Ui Aeda of Odba and the seven Delbnai and the half tricha cét of Cuircne and the half **tricha cét** of Tellach Modaran and the **tricha cét** of Fir Bili.[104](javascript:footNote('E900000-003/note104.html')) The race of Conn, [to resume]: the twenty townlands (hundreds) of the Colamain, and the **tricha cét** of Fine Gall, and the Airgialla moreover, containing seventeen **tricha céts**, and the ten **tricha céts** of **Cenél nEogain**, and the ten **tricha céts** of Cenél Conaill, and the half **tricha cét** of Cenél nÉndai, and the half **tricha cét** of Cenél nAengusa, and the half **tricha cét** of **Fir Tulach**[105](javascript:footNote('E900000-003/note105.html')) and the ten **tricha céts** of **Breifne**, and the ten **tricha céts** of **Ui Maini**, except three tuatha, namely **Sogain** and **Dál Druithne** and **Muinter Mail Findáin**. The race of Muiredach Muillethan and the race of Brian son of Eochu Muigmedóin wheresoever they are, and the Cairbres, namely Cairbre Mór of Druim Cliab belonging to the Ui Fiachrach maic Echach Muigmedóin and Cairbre Ua Ciarda belonging to the Men of Meath. The race of Dathi from Clad Conachla to Codnach of Cland Puint. Muinter Murchada with their kinsfolk, and Cland Choscraig. The Men of Umall with their branches.’


¶159] ‘The race of Fiachu Suigde son of Feidlimid Rechtmar, namely: **Corcu Fir Tri** at **Corann** in **Connacht**, of whom was Diarmaid Ua Duibne, and the **Ui Chuinn** with their families, *formerly* petty kings of **Corcu Fir Tri** until the race of Tadg son of Cian son of Ailill Aulom from **Munster** dispossessed *them*: and of **Corcu Fir Tri** are the **Ui Dobailén** and **Ui Duinnchaichig** and **Ui Ailella**, of whom was **Mac Liag** the poet. The **Dési**, moreover, are of the race of Fiachu Suigde; they, with their under-septs, contain ten **tricha céts**, not reckoning the **Semaine**, i.e., a half **tricha cét** who are descended from Semuine son of Cechang son of Celtar or from Semaine son of Celtchar son of Uithechar[106](javascript:footNote('E900000-003/note106.html'))
when the consequence of slaying Blai Brugaid through jealousy in his fort went against Celtchar; and the **Dési of Brega** are not reckoned therein i.e. in the ten **tricha céts**). Fir Bili and Fir Asail are of the race of Fiachu Suigde.’




---

p.108


¶160] ‘The **Fothairt** who went to **Leinster** are of the race of Eochu Find Fuath nAirt, i.e. the seven **Fothairt** in every place where they are.’[107](javascript:footNote('E900000-003/note107.html'))


¶161] Compared with the account in **Keating**, the foregoing contemplates a much smaller extent of the **tricha cét**. **Cenél Conaill**, **Cenél nEogain**, and
**Airgialla** comprise 37 **tricha céts**. These occupy much less than the modern **Ulster**, as they do not comprise the counties of **Antrim**, **Down**, and **Cavan**. The ancient **Ulster** of **Keating**'s account, somewhat larger than the modern province, contains only thirty-six **tricha céts**.


¶162] We can assign a period to the Lecan statement. It is earlier than the Norman occupation of **Meath** at the close of the twelfth century, and later
than the death of **Mac Liag** in 1016. It is likely that the **tricha cét** varied according to the population at different periods, and that **Keating**'s account is referable to a time when the country was less populous than in the eleventh and twelfth centuries.


¶163] Two modern baronies retain the name tricha, **Trough** (**an Triúcha**, **Trícha Cét Cladaig**), 37,377 statute acres, in co. **Monaghan**, and **Trughanacmy**
(**T. an Aicme**), 195,282 statute acres, in Kerry.


¶164] Other instances from Onomasticon Goedelicum are:—
1. **Trícha Baguine** = baronies Boylagh and Banagh, co. Donegal.
2. **Cairbri** = barony Carbury, co. Sligo.
3. **Trícha cét Cera**, apparently somewhat larger than barony Carra, co. Mayo.
4. **Trícha cét Cianachta** = ancient kingdom of Cianacht Breg.
5. **Trícha cét Cualnge**, perhaps = kingdom of Conaille.
6. **Trícha cét Énna mic Neill** = trícha Énna = two baronies of Raphoe, co. Donegal.
7. **Trícha cét Fer nArda** = baronies of Corcomroe and Burren, co. Clare = ancient kingdom of Corcu Mu Druad.
8. **Trícha cét Mugdorn**, perhaps = barony Cremorne (Crích M.), co. Monaghan.
9. **Trícha cét na nOilén** = barony Islands, co. Clare.
10. **Trícha cét na Soillse** = barony Lecale, co. Down.
11. **Tricha Eogain** = two baronies Inishowen, co. Donegal.
12. **Trícha Luigdech** = barony Kilmacrenan, co. Donegal.
13. **Trícha Medónach** = barony Barryroe, or part thereof, co. Cork.



¶165] **O'Donovan**'s Supplement to O'Reilly's Dictionary, has: ‘Rig: 'rí rig', rex regulorum, a chief whose authority was recognized by seven petty chieftains. 



---

p.109




H. 3. 18, p. 14.’ Rií rig here seems to be an etymological gloss on **ruiri** = ro + rí. For ‘ chief’ and ‘chieftains’, read ‘king’ and ‘kings’.


¶166] The tradition that suzerainty over seven petty kings conferred a special grade is elsewhere exemplified. Cp. section 143, above, where, besides the sons of Magu who were chiefs of the vassal Fir Domnann, the seven Máines of **Connacht** are subject to Medb, and in **Munster** also there are seven **uirrig**. The earlier and lesser **Munster** of the **Érainn** is here implied. In the defeat of the **Irish Picts** by Ui Néill at **M�in Daire Lothair** (an. 562 AU), when the **Picts** lost their territory west of the **Bann**, their king Aed Brecc is spoken of as leading seven other Pictish kings. In the Book of Rights, Ireland is divided into seven chief kingdoms, whose kings have no suzerain except the king of Ireland. This division seems to represent an ideal rather than an actuality, for as far as one can judge from other evidences, the kings of **Osraige**, **Tuadmuma**, **Breifne**, and **Cenél Conaill**, perhaps also the kings of **Iarmuma** (**Eoganacht Locha Léin**) and **Brega**, were quite as independent as the seven chief kings in the Book of Rights. In **O'Maelconaire**'s Munster Annals (R. I. A. copy), the kings of **Cashel** are usually called kings of **Cashel** and **Desmond**, indicating that they were not suzerains of west and north Munster. From an early period in the ninth century the Airgialla seem to have admitted the suzerainty of **Cenél nEogain**: ‘Airgialla .i. daergialla **Cenél nEogain** rocuirsead fo dairchis iad o cath Leithe Caim amach’ (BB 249 b 15, H. 3. 18, page 580, and see AU 826). Hence perhaps the absence of any statement of tributes due to the king of Airgialla in the Book of Rights. **Flann Mainistrech**, in his poem quoted by me ( R. I. A. Proceedings, xxvii, C. 6, p. 138), names seven chief kings in his time. Six of these accord with the Book of Rights. For the seventh he omits **Airgialla** and substitutes **Brega**. (**Cuán Ó Lothcháin**, referring to the alleged contents of the Psalter of Tara, says that it tells of ‘seven chief kings of Ireland,’ who are ‘the five kings of the Fifths, the king of Ireland and her high king (subking)’ BB 351 b 3 (orr*ig* is a marginal amendment of airdri). Perhaps the peculiar designation, in Sechtmad, ‘the Seventh,’ applied to one of the petty kingdoms of **Munster**, had its origin in this way (see section 106)














