

#An Historical Apology for the Irish Catholics


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


An Historical Apology for the Irish Catholics
=============================================


Author: William Parnell
-----------------------


### File Description

Funded by School of History, University College, CorkElectronic edition compiled by Beatrix Färber

Proofread by Beatrix Färber

Funded by University College, Cork, School of History 1. First draftExtent of text: 35320 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2012) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E800004-001Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

#### Sources


**Works by William Parnell**2. William Parnell, Julietta, or, The Triumph of Mental Acquirements over Personal Defects (London 1802).
3. William Parnell, An Inquiry into the Causes of Popular Discontents in Ireland (London 1804, reprinted 1805; 1806).
4. William Parnell, Observations explanatory and critical, on a pamphlet entitled, 'An inquiry into the causes of popular discontents in Ireland' (London/Dublin 1806).
5. [Anon.], Maurice and Berghetta, or, The Priest of Rahery (London 1819); second edition published with Parnell's name (London/Dublin/Boston 1825) reprinted Ballinlough: Belser Wissenschaftlicher Dienst, 2009.
**Further reading**2. A Treatice of Ireland, by John Dymmok. Now first published from a MS. preserved in the British Museum, with Notes, by the Rev. Richard Butler,
A. B., M. R. I. A., in: Tracts relating to Ireland, vol. 2 (Dublin 1843) 1–85.
3. Historiae Catholicae Iberniae compendium: domino Philippo Austriaco III, Hispaniarum, Indiarum, aliorum regnorum atque multarum ditionum regi Catholico monarchaeque potentissimo dicatum a D. Philippo O'Sullevano Bearro, Iberno (Lisbon 1621).
4. Matthew J. Byrne (ed and trans), Ireland under Elizabeth: Chapters towards a history of Ireland in the reign of Elizabeth, being a portion of the history of Catholic Ireland by Don Philip O'Sullivan Bear (Dublin 1903; repr. New York 1970).
5. Thomas Stafford, Pacata Hibernia: Ireland appeased and reduced, or a historie of the late warres of Ireland [...] (London 1633). Re-edited, in 2 vols., with an introduction and notes by Standish Hayes O'Grady, as 'Pacata Hibernia: or, A history of the wars in Ireland during the reign of Queen Elizabeth, especially within the province of Munster under the government of Sir George Carew, and compiled by his direction and appointment.' (Dublin 1896).
6. Richard Cox, Hibernia Anglicana; or the History of Ireland from the Conquest thereof by the English to this present Time. With an Introductory Discourse touching the Ancient State of that Kingdom; and a new and Exact Map of the same, 2 vols. (London: H. Clark and Joseph Watts 1689–90).
7. Ferdinando Warner, History of Ireland (London 1763).
8. Patrick Finglass, 'Breviate of the getting of Ireland, and of the decaie of the same', in: Walter Harris (ed), Hibernica, or, Some antient pieces relating to Ireland (Dublin 1770).
9. Thomas Leland, History of Ireland (Dublin 1773).
10. Charles Maclean, An excursion in France and other parts of the continent of Europe: from the cessation of hostilities in 1801 to the 13th of December 1803: including a narrative of the unprecedented detention of the English travellers in that country [... ] (London 1804).
11. R. Johnston, Parnell and the Parnells: a historical sketch (London/Dublin 1888).
12. Philipp O'Sullivan Beare, Ireland under Elizabeth, (ed. M. Byrne), (London, 1903).
13. D. B. Quinn, 'Ireland and 16th century European expansion', Historical Studies 1 (1958).
14. D. B. Quinn, 'The Munster Plantation: problems and opportunities', Journal of the Cork Historical and Archaeological Society 71 (1966).
15. Aidan Clarke, The Old English in Ireland, 1625–42 (London 1966).
16. J. H. Andrews, 'Geography and government in Elizabethan Ireland', in N. Stephens & R. Glasscock (eds), Irish Geographical Studies (Belfast 1970).
17. Kenneth W. Nicholls, Gaelic and Gaelicised Ireland (London 1972).
18. Kenneth W. Nicholls, Land, Law and Society in sixteenth-century Ireland (O'Donnell Lecture, 1976).
19. Nicholas P. Canny, The Elizabethan conquest of Ireland (Hassocks, 1976).
20. Hans S. Pawlisch, Sir John Davies and the conquest of Ireland: a study in legal imperialism (Cambridge 1985).
21. Michael MacCarthy-Morrogh, The Munster Plantation: English migration to southern Ireland, 1583–1641 (Oxford 1986).
22. Brian C. Donovan & David Edwards (eds), British sources for Irish history, 1485–1641: a guide to manuscripts in local, regional and specialised repositories in England, Scotland and Wales (Irish Manuscripts Commission, Dublin 1997).
23. Hiram Morgan, Political ideology in Ireland, 1541–1641 (Dublin 1999).
24. Patrick J. Duffy, David Edwards, & Elizabeth FitzPatrick (eds), Gaelic Ireland, c.1250–c.1650: land, lordship, and settlement (Dublin, 2001).
25. Katherine Mullin, DNB entry on 'Parnell, William (c.1780–1821)', Oxford Dictionary of National Biography, Oxford University Press, Sept 2004.
26. Alan Ford and John Mc Cafferty (eds), The origins of sectarianism in early modern Ireland (Cambridge 2005).
27. Sir John Davies, 'Of the Lawes of Irelande', ed. from MS Ellesmere 7042 byHiram Morgan, The Irish Jurist 31 (Dublin 1995–96), 307–312.
**The edition used in the digital edition**2. An Historical Apology for the Irish Catholics. William Parnell First [1 volume; i + 147pp] H. Fitzpatrick Dublin (1807)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition covers the dedication and pp 1–147.


#### Editorial Declaration


##### Correction


The text has been proofed twice.


##### Normalization


The electronic text corresponds to the 1807 edition. Some outdated spellings, such as shew, chuse, etc. have been allowed to stand. Typos have been corrected, marked corr sic="" resp="BF".


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (and subsequent punctuation mark) crosses a line break, the break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section. Page-breaks are marked pb n="".


##### Interpretation


Words and phrases from languages other than English are marked.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: 1807#### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words are in Latin.


##### Language: [GA] Some words are in Irish (including Irish in anglicised spelling).


### Revision History


* (2012-11-05) Beatrix Färber (ed.)

* Preliminary SGML and HTML files created. Keywords added; file validated; new word-count made; online proofing (2); new version uploaded.
* (2012-11-05) Beatrix Färber (ed.)

* File proofed (2), More markup added.
* (2012-11-05) Beatrix Färber (ed.)

* File parsed.
* (2012-10-28) Beatrix Färber (ed.)

* Header created; file proofed (1), structural and light content markup added.
* (2012-10-27) Beatrix Färber (data capture)

* Text scanned.




---


#### Corpus of Electronic Texts Edition: E800004-001


### An Historical Apology for the Irish Catholics: Author: William Parnell




---

p.i


### To The Duke of Bedford




---

p.3


My Lord,
In inscribing this work to your Grace, it is with difficulty that I suppress those sentiments of private esteem, which if I were to give them utterance would appear more warm than the occasion would justify.


I confine myself to the expression of that gratitude for your Grace's wise and conciliating Administration, and that regret for its termination, which I feel in common with every Irishman.


Avondale, April, 1807. W. Parnell


---

p.4




---

p.v


### Preface


This little work was written with no view of promoting party interests, nor from any consideration of the circumstances of the day, but with the humble hope that it might afford some instruction on those general topics of political science, which have at all times sufficient importance to deserve attention.


The Author makes no apology for literary defects, which he has not been very anxious to avoid; he is not exposed to the ridicule of failure in a point where he has attempted nothing.


His sole object has been to produce conviction; his motive—to give security to every Irishman in his Person and Property, both of which must be exposed to risk, as long as any civil distinctions are inflicted on so numerous a body as the Irish Roman Catholics.


In point of Historical proofs, he has not been unfaithful from the want of anxiety to avoid being so: In principle, he has certainly not been partial to the Catholics; as he has quoted entirely from Protestant writers; and if he has fallen into any misrepresentation in the detail, it must be considered, that in bringing so many proofs, in exposing so large a surface, it is difficult, with the best intentions, not to have left 



---

p.vi



much liable to cavil, and something perhaps to merited reprehension.


Yet, as he never will enter into literary controversy, he is anxious to anticipate some sources of misrepresentation which he foresees, and which would be peculiarly unjust, as they would receive countenance from the very care he has taken to be correct.


He has always quoted from the earliest authorities, and when possible, from eye-witnesses; whereas an opponent might quote, in contradiction, from later and more bigoted authorities, and yet derive credit; because the sources of Irish History exist in such obscurity, that the public would regard the earlier and later authorities without any preference.


Thus, in many instances, where he has quoted from **Fynes Moryson**, and **Sir George Carew**, who were eye-witnesses of the events they describe, a plausible contradiction might be produced from the authority of **Sir R. Cox**, although he wrote much later, and derived his information respecting the events of these times, from **Moryson** and **Sir George Carew** themselves.


Thus, the Author has produced the authority of **Sir J. Davis**, for his description of the Brehon laws of property; as **Sir J. Davis** was alive at the time those laws existed; and yet the authority of **Sir James Ware**, might be produced to contradict this description, and might influence those who do not know that **Sir James Ware**


---

p.vii



wrote long after **Sir J. Davis**, and when the old laws and customs of the Irish had fallen into obscurity.


He is aware that many people will take offence at the sincere and strong terms of reprobation with which he has marked the conduct of the English Government in Ireland; but, unless we should see that conduct again adopted, the censure will scarcely be applied by any one to the present times.


On the contrary, he hopes the description he has given, will serve as a contrast, to make the blessings of an improved government more dear to the feelings of the Irish nation.


He has drawn a picture in which the distant view is gloomy and dark; but the vast ruins, the desolated landscape, and the storm, passing sullenly away, will give more brilliancy to the scenes of peace and happiness, with which the pencil of the future historian may enrich the foreground.


Religious concord will not always be banished from Ireland.


The cause of the Irish Catholics rests not only on the clear dictates of reason, justice, and humanity, but on very imperious demands of policy.


It is true it has two very formidable opponents; dullness and malignity: but as stupidity perplexes the efforts of rancour, and ill-nature makes folly odious; the opposition to the Catholic claims will become ineffectual in the progress of its own exertions.




---

p.viii


If it is true that the Catholics have thrown impediments in their own way; if, notwithstanding their general good sense, they have exposed themselves to the charge of intemperance, it has arisen from being placed at so great a distance from the seat *of* political action, that it is almost impossible to form a just and clear judgment of passing events. They must necessarily see through an intervening medium, which may often present objects in a false point of view.


The Protestants, who felt all the clanger of the delicate situation in which the Catholics were placed, with so much to wound their feelings, to inflame their resentments and precipitate their measures, cannot be too grateful for their late disinterested forbearance; and must rejoice that, at the time so great a shock was given to their just and honourable expectations, they met with a friend so sincere, and an adviser so judicious as Lord Ponsonby.


If the Author might also obtrude his advice to the Catholics, although he is sensible there is very little occasion for it, it would be contained in one short maxim: ‘Be angry, and sin not.’




---

p.1


Historical Apology for the Irish Catholics
------------------------------------------


The pleasure which is derived from accurate and conclusive argument, is still farther encreased when each link of reasoning has its separate support in appropriate and striking facts; and it is exalted to the highest degree which can affect a refined and humane mind, when the theory and facts produce a conclusion in which the benevolent and gentle feelings may deeply sympathize.


An argument may be correct, but it will never be really interesting if deficient in striking facts, or if its conclusions are repugnant to the amiable sentiments of the heart.


This appears to be the reason why metaphysical speculations have never become generally interesting;



---

p.2



because, from the nature of the subject, the facts which support them are scanty and trite.


In the same manner, when Buffon produces a series of very curious facts to prove the existence of blunder, defect and malignity, in place of skilful and benevolent contrivance in the plan of created beings, we feel no pleasure in the melancholy discovery, and take no interest in the triumph of the pragmatical naturalist.


The following argument in favour of the Irish Catholics, has so far a right to some claim on the public attention; the facts which support it are new and striking, and its result is favourable to the moderate and benevolent affections.


The general conclusion which we shall attempt to prove, is simply this: That religious sentiment, however perverted by bigotry or fanaticism, has always a tendency to moderation, if not indifference; that it seldom assumes any great portion of activity or enthusiasm, except from novelty of opinion, or from opposition, contumely and persecution, when novelty ceases: That a government has little to fear from any religious sect, except while the sect is new; give a government only time, and provided it has the good sense to treat folly with forbearance, it must ultimately prevail. When, therefore, we find a sect, after a long lapse of years ill-disposed to the government, we may be certain that government 



---

p.3



has protracted its union by marked distinctions, has roused its resentment by contumely, or supported its enthusiasm by persecution.


The particular conclusion we shall attempt to prove, is, that the Catholic religion, in Ireland, had sunk into torpor and inactivity, till government roused it with the lash; that even then from the respect and attachment which men are always inclined to pay to government, there still remained a large body of loyal Catholics, that these only decreased in number from the rapid encrease of persecution; and that after all, the effect which the resentment of the Roman Catholics had in creating rebellions, has been very much exaggerated.


On these grounds we close with the adversaries of the Catholic claims. *They* say, it is the nature of the religion which makes the Catholics disaffected, and therefore the religion must be suppressed. *We* say, that even allowing that the principle of the religion is bad; still, that if it were left alone, it would become indolent and innocuous; that it is the principle of persecution adopted against the religion which makes the Catholics zealous and disaffected, and that therefore the persecution should be dropped.


It is difficult to know whether the facts that are to be produced in support of this opinion, will bring conviction to the mind of the reader, but at all events they are neither trite nor important *(sic)*.




---

p.4


The first difficult fact those writers (who attribute Irish rebellions solely to the antipathy of Catholics to a Protestant government) have to encounter, is, that rebellions were just as frequent while the government was Catholic, as when it became Protestant; and that the most formidable rebellion which ever shook the English power in Ireland, broke out thirty years *before* the reformation, and continued with little intermission, until the aera of the reformation.


In the reign of Henry VII. 1504, a general confederation of the Irish princes took place, headed by Ulrick Burke, **Turloh O'Brien**, **Melrony O'Carrol**, &c. &c. who collected the greatest army that had been in Ireland since the conquest. They fought a bloody and hard contested battle with the Lord Deputy Kildare, at Knocklow *i. e. Cnoc-Tuagh*, in Connaught.


In Henry VIII.'s reign, *before* the reformation, the English were defeated at Monetrar *i. e. Moin na m-brathar(?)*, by an army under the command of the Earl of Desmond's son, **Tirlagh O'Brien**, and McWilliam. (Ann. 1510.).


In the year 1513, McWilliam took the Castle of Dunluse, and we read that ‘the Irish met with very little opposition this winter: they ravaged the country as they pleased, but that they paid dear for it next Spring.’


In 1514, we find the Deputy attacking the Irish, chieftains, O'Moor and O'Reyly.




---

p.5


In 1516, the Deputy slew Shane O'Tuathal, besieged Lemevan Castle, took Clonmel, invaded Ulster, took the Castle of Dundrum, conquered Fylemy McGennis, and (as it was technically termed in those days) *preyed* Tyrone. The citizens of Dublin were likewise defeated in Imale.


In 1519, Con O'Nial invaded Meath.


In 1521, we find mention of the Byrnes being in rebellion.


The same year a confederate army of the O'Mordris, O'Connors, and O'Carrols, defeated the English.


In 1523, the Earl of Desmond, meditating a rebellion, applied to the French King for assistance.


In 1523, O'Nial was in rebellion.


In 1528, we find the English power so reduced, that they paid tribute (called black rents) to the Irish chieftains, for protection. O'Connor invaded even the Pale; the Lord Deputy was too weak to revenge the injury, but withheld O'Connor's pension; O'Connor, in return, took the Deputy prisoner.


In 1529, Kildare, by means of his daughter, Lady Slane, raised a great confederacy among the Irish chieftains.




---

p.6


In the same year, a negociation between the Emperor Charles V. and the Earl of Desmond, only proved ineffectual by the Earl's death.


Fresh insurrections of the O'Tuathals, O'Connors and O'Carrols succeeded, and were closed by the great rebellion of Lord Thomas Fitzgerald; which brings us to the period of the reformation.


Here then we present a considerable difficulty to our opponents, who have attributed all the succeeding rebellions solely to the antipathy of Catholics to a Protestant government; for they are bound to shew that the causes which produced these rebellions, previous to the reformation, ceased to operate, before they can reasonably assign the whole effect of succeeding rebellions to the influence of religion. Unless they can plainly make this appear, they must have grossly exaggerated the supposed influence of religion in producing these unfortunate events; and it is even very possible that this influence, which they attribute to religion, did not at the time exist.


Now, we maintain this is the very fact; that the influence of the Roman Catholic religion in producing insurrections, has been without measure exaggerated; that it had no such influence until long after the reformation; and that when it did acquire that influence, it was because it was persecuted, and not because it wished to persecute.




---

p.7


To place this in a clearer light, we will examine the relation which the Catholic religion had with events in Ireland from the period immediately before the reformation, to the great rebellion in the reign of Charles I.; we will endeavour to shew how little connection it had with rebellions, until its animosity was awakened by the intemperate and injurious conduct of the Protestants, and to draw from numerous and striking facts, a fresh proof (if fresh proofs are wanting) that humanity, justice, toleration and gentleness, are the wisest means which a Government can use in correcting the religious errors of its subjects.


Prior to the Reformation in Ireland, the Roman Catholic religion, stimulated neither by scepticism, contradiction or persecution, had long ceased to have any influence on political events. It was regarded by the mass of the people with a stupid acquiescence approaching to indifference. The clergy, like all long established clergy, neglected their duties, and so far from inspiring the enthusiastic attachment which they now do, were considered as an oppressive incumbrance. We have the authority of Archbishop Brown for stating, that their ignorance was extreme; and that they were frequently incapable of performing the common offices of religion.




---

p.8


If we except the excommunication of the adherents of Warbeck and Simnel by the Pope, we meet with no instance of the political influence of the Roman Catholic religion immediately before the Reformation.


Indeed, so complete seems to have been its insignificance, that **Sir James Ware**, though the most indefatigable of antiquaries, and possessed of every facility of research, could not ascertain accurately the names of bishops before this period.


For instance, ‘One Thomas was consecrated Bishop of Down and Connor. (Ann. 1456.)’


‘One Thady was advanced to these Sees. (1469.)’


‘One Richard Wolsely seems to have been Bishop. (Ann. 1502.)’


‘One Tiberius succeeded next. (1526.)’


‘One Thaddeus, a Franciscan Friar, is said to have been provided to the Bishoprick of Dromore. (1511).’


‘Lawrence O'Galchor, Bishop of Raphoe, was proceeded against for incontinence and other enormous crimes.’


‘One Donald sat in the See of Derry in 1423. I am of opinion he resigned his See, being made uneasy in it; for Archbishop Swain called him to



---

p.9



task for incontinence and other crimes, which being proved on him, he was obliged to do penance.’


‘Donald was succeeded by John, against whom a citation issued for homicide and other crimes.’


These specimens are sufficient to shew that the Roman Catholic religion, like all religions left alone, was far more inclined to sink into lethargy than rise to political importance.


If the contrary were the case—if we suppose that the Catholic religion was even at this period possessed of that inimical spirit of bigotry which has been represented as incompatible with submission to any authority that it cannot influence, what must have taken place upon the event of the reformation? A great and new cause of disaffection being added to former causes of notorious *activity*, more frequent and more inveterate rebellions would have arisen.


But was this the case? No—quite the reverse: For it was immediately after the reformation that the Irish chieftains submitted to the English government; that the English power was acknowledged as legal, and that a degree of peace and good order took place, which had been unknown since the first invasion of the English. What then must we conclude from this fact?—what was really the state of 



---

p.10



the case: that there was no such feeling as Catholic bigotry at this period.


The truth is, that Irish rebellions and Irish submissions, had not at this period, nor until long after, any connection with religious opinions. Later historians have ascribed their own feelings to these times; and because religion made a prominent feature in the rebellions of their own days, they imagined it must have been a cause of rebellion from the first date of religious schism. But co-temporary writers never mention religion as a cause of rebellion, till a long period after the reformation: we plainly perceive to what cause they attributed the disaffection of the natives; their fears are always expressed against the Irishry, not against the Papists; they found the greatest opposition in national pride, not in religion.


We shall be more candid than our opponents; according to their mode of reasoning, we might alledge the submission of the Irish chieftains in the reign of Henry VIII. as a proof of Catholic loyalty; but neither had their rebellions nor their submissions any connection with religion. The cause of these submissions is curious. It was simply the assumption of the title of King, in place of Lord of Ireland, by Henry VIII.


The title of Lord of Ireland was not calculated to inspire the regal descendants of Milesius with 



---

p.11



much respect; it was inferior to their own. Fortunately for the English power, the divisions of the Irish septs had suspended the election of a native King of Ireland, to whom before the coming of the English, the Irish princes had been accustomed to pay allegiance. The title had long been in abeyance, but as soon as Henry revived it in his own person, the Irish chieftains were led by their very prejudices, and by a natural association of ideas, to pay him homage.


The Irish princes resisted the feudal supremacy of Henry, while neither his rank nor his force was much greater than their own; but when he assumed the title to which their feudal allegiance had always been paid, and when he asked for nothing more than feudal allegiance, they readily submitted.


Is it not then exaggeration, and extreme perverseness, to represent popish feelings as having any considerable influence at this time, when if they had, more general and more exasperated rebellions would have annihilated the insignificant force of the English? Where is that bond of union—where that identity of purpose—where that indefatigable zeal, and unmitigated hate, which we are told ever marks the conduct of Papists towards Protestants?


On the contrary, objects which were never achieved before by invasion, rapine and destruction, were now accomplished almost without an effort. 



---

p.12



O'Connor, O'Donnel, O'Doyne, McMahon, O'Moor, McWilliam, O'Rorke, McArty More, McArty Reagh, McCormick, O'Sullivan, McDonnough, O'Callaghan, O'Byrne, O'Brien, all independent princes, and governing their several petty nations, acknowledged Henry as their liege Lord, and did not hesitate to renounce the Pope's usurpations, and to own the King's supremacy.


**Sir Richard Cox** tells us, that there was not a single chieftain who, did not acknowledge Henry's supremacy in Church, as well as State; and quotes from **Sir John Davis** with great naiveté, for a violent bigot, that the Irish made no difficulty in renouncing the Pope, when they had once resolved to obey the King. This involuntary testimony of an opponent is sufficient to prove that religious feelings were at this time of very secondary influence.


If the Catholic religion possessed any immunity from the sedative influence which prosperity has on all establishments—if after long habits of indifference, it could, on the first alarm, rouse the minds of its votaries to that zeal, which in general only arises from the *long* endurance of persecution—if it was the *nature* of popish feelings to produce rebellions, this would have been the time when they would have shewn their most marked influence; when the government openly opposed the claims of the Sovereign pontiff, and usurped his titles—when it dispossessed popish prelates, seized on church lands, and 



---

p.13



and demolished reliques; what plots and rebellions must not necessarily have followed!


Instead of this we find the Irish making every submission that the English government felt it reasonable to require; when once the civil claims between the contending parties were satisfactorily arranged, we find the religious claims thrown in (to use a vulgar phrase) as a mere whet to the bargain; we find the Irish princes, even the great O'Neil, accepting titles from the *King* of Ireland, which they had always despised when offered by the *Lord* of Ireland. Peace was for the first time universal: the French King offered his assistance to the Irish Princes in vain, and in vain excited them to revolt. The English government for once appeared in a creditable alliance with its Irish vassals—the army reduced at home, and an Irish army assisting the English King at Calais. **Leland** characterises the loyalty of the times as even outrageous.


When, therefore, the adversaries of the Catholics tell us that it is the *nature* of that religion to produce rebellions under a Protestant government; and yet we find that at the time when the whole nation were Catholics—when they were particularly uncivilized, and consequently bigoted; that an open and unprecedented attack—an unceremonious reversal of every thing held sacred, was followed no immediate commotion; and that a very 



---

p.14



short period after, an unheard-of degree of peace and loyalty succeeded, must we not conclude that they have *exaggerated* the effects of Catholic principles, or rather that no disloyalty flows necessarily from such principles, but that the disloyalty which has since been considered as a characteristic of the Catholics, has arisen from the very unwarrantable and very unwise severity with which the Catholics have been treated?


So far it is clear that in Henry the Eighth's reign, religion had no important influence in producing rebellions: yet it was not to be expected that, however lax the ancient religion might have become, it could be suddenly assailed in its fundamental tenets, without producing a revulsion in the minds of a very ignorant people. Even if a general commotion had taken place, we should by no means be justified in arguing that rebellion against the civil power was a necessary effect of Catholic dogmas. In similar circumstances any sect might fly to arms, as the Protestants under the reign of James II., but it is singular, how little resistance was made to the reformation in Ireland. This resistance was virtually confined to a single individual, Archbishop Cromer.


The great majority of the prelates and of the parliament, either favoured or made no opposition to the reformation. The general ignorance of the nation was the greatest obstacle to its progress; yet that it gained ground is evident, from the alarm felt by the See of Rome, who, thought it necessary 



---

p.15



to send over a private commission to Cromer, and to excite the northern dynast, O'Neil, to commence hostilities.


To suppose that *no* opposition would be given to a great revolution in the national religion, would be extravagant; the clergy of course were interested to oppose it. Principle, as well as habit, would influence many of the laity to oppose it: but all things considered the opposition was inconsiderable; it might have been entirely obviated by judicious management; certainly it was not conducted with that intemperance, which argues a peculiar tendency in the Catholic religion to produce a rebellion against a Protestant government.


In fact the Reformation during the reign of Henry the Eighth was conducted with very little violence towards the Catholic *laity*; there consequently was very little reaction from resentment or bigotry, and though late historians describe the Priests as flying from city to city to animate their flocks to rebellion, yet as we find no *facts* to support the assertion, we must conclude they described what they thought *probable*, not what really was the case.


We are now bound to shew what *was* the cause of the rebellion which followed the submission of the Irish princes. This cause we imagine was a clear infraction on the part of Henry, of the terms on which the submissions of the Irish were grounded; 



---

p.16



and a well-founded apprehension that their power and independence were in danger of fresh encroachments.


The Irish Chieftains had acknowledged Henry the Eighth as their liege lord; but in their very indentures of submission their own prerogatives were acknowledged and remained untouched. Thus O'Sullivan, ‘suae nationis primus;’ Mac Donough, de Allow, ‘suae nationis caput.’ Donaldus O'Calaghan, ‘nationis suae primus.’


In these indentures are only reserved the usual services or tribute payable to the liege lord; these Chieftains were neither required to pay taxes, to submit to the English or perform any one duty of subjects. They retained undisputed, the privilege of making war or peace among their several nations, of raising troops, of levying taxes, and the elective succession to their petty thrones.


Under these stipulations, they freely promise to annihilate the Pope's authority, and every thing that supports it.[1](javascript:footNote('E800004-001/note001.html'))


So far was the English government, at that time, from assuming any right of actual sovereignty over the Irish Princes, that the legality of the appointment of Tanists (or elective successors) was tacitly acknowledged



---

p.17



by the Parliament of 1543, which enacts that the fines of petty larceny, shall be paid to the tanist of the country.


It had, however, long been the policy of the Irish government to take every opportunity of diminishing the power of the Irish chieftains, and Henry was of too arbitrary a temper to brook the independence of these petty sovereigns. As yet, however, the English force had not been sufficiently strong to aim openly at their subjection; and therefore those artifices, which power stoops to use when it cannot compel, were adopted.


Henry, or his agents in Ireland, saw the advantage that would accrue from getting the Irish Princes to appeal to his decisions; and had an excellent excuse in their numerous and violent dissentions, which seemed to point out the necessity of an arbitrator. The Irish chieftains were aware of the snare; and said, ‘It is true we want arbitrators, but if you please, we will name them ourselves’: accordingly, we find regular arbitrators appointed, mostly bishops, but particular stress laid that the Earl of Desmond should be one; who, being in the equivocal station of a revolted English subject, possessed of all the princely prerogatives of an Irish chieftain, would be particularly on his guard against the encroachments of the English power, and the invasion of these Irish prerogatives, on which his own consequence had been entirely founded.




---

p.18


On these terms the Irish chieftains submitted without any scruple respecting religion. ‘But they soon resumed their arms’—it is true, but not on account of religion, but because all these terms were violated or trampled on by the English government. If we can shew this to have been the case, is it not sufficient? why multiply causes unnecessarily? why be at the pains to conjure up the Pope, where he would not naturally make his appearance?


On the contrary, Theobald de Boys was sent to Ireland as ambassador, to make a league with the Irish chieftains, and met with no success: a small Irish army attended the King at Calais; every thing remained tranquil; until when? until Sir Anthony St. Leger, (as a Protestant historian expresses it) finding the kingdom quiet, determined to *keep it so.*


Of those whom he suspected, he imprisoned some, and obliged others to give hostages; but these measures were calculated to produce only partial disaffection: he proceeded to another measure which was certain to excite every Irish chieftain in opposition to the English Government.


Let us hear the account of this transaction from the mouth of **Sir Richard Cox** himself, the apologist for every bad action performed by a Lord Deputy.




---

p.19


‘Sir Anthony St. Leger made it his business to break the dependancies of the Irish, and to that end upon all references to him, he took care that the weaker party might depend on the government for protection; and that he should not rely upon, or be under the subjection of any other; and particularly on the 14th of July, he made an award between O'Neil and O'Donnel, whereby O'Donnel was freed from depending on O'Neil.’


We shall not enquire whether this was good policy or not; its immediate effect must have been, to alarm and irritate the principal Irish chieftains. These, it is true, acknowledged Henry as liege Lord: but, by the same rule, they were liege Lords themselves in their own kingdoms, and had each their dependent princes, over whom their power was much greater than that of the King of England over them. They drew their revenues principally from the chieftains dependant on them, and therefore they could not see, without great jealousy, a system adopted by the English government which aimed directly at the diminution of their power, and the impoverishment of their treasures.


The system was itself unjust; it was exactly the same as if Buonaparte, immediately after a solemn treaty of peace, was to declare Hanover independent of the King of England


It was also perfidious, because it had been expressly provided in the indentures of submission, 



---

p.20



that, not the English government, but that certain bishops and the Earl of Desmond were to be the arbitrators of differences arising between the Irish chieftains. True, it is said, that the Lord Deputy made the award on a reference to him; but it is plain, that the reference was made only by the one party; by the weaker who knew he should be supported, not by the stronger who knew he should be crushed. Would it alter the case, if Hanover was to make a reference to Buonaparte?


We repeat again, that we are not considering the policy of the measure; it is sufficient for our argument that it would appear most unjust and vexatious to the most powerful of the Irish chieftains; and, therefore, that the rebellion which followed was attributable to this circumstance, and not to religion; for, we read immediately after, that, ‘now the spirit of rebellion had again seized the Irish, and O'Neal, (the victim of the Lord Deputy's policy) O'Donnel, O'Doherty, and O'Callock, made overtures to the French King.’


This appears to be a clear and sufficient reason for the disturbances in Ireland at the end of Henry the Eighth's reign; we are at least informed of no other; nor should we hesitate to adopt it, because it has been overlooked and disregarded by historians of later times; for their heads were so occupied with religious animosity, that they referred every effect to that cause, whether it had any relation to it or not.




---

p.21


Edward VI.
----------


There is scarcely a pretext for supposing that the disturbances in Ireland during the reign of Edward VI. proceeded from the influence of the Roman Catholic religion. The English Lord Deputies made use of no precipitate measures of violence against the Roman Catholics; and, in consequence, the Reformation proceeded without exciting any marked public discontent. Later Protestant writers could not conceive this to have been the case, and have given florid descriptions of the prejudice and terror, with which the nation surveyed the progress of heresy and innovation. But when we examine into facts, we find only one solitary instance on which all this fiction is founded, namely, the opposition of Archbishop Dowdal to the translation of the liturgy. Is there then any wonder that an Archbishop should be found to stickle for doctrinal mystery? Is it not rather surprising that only *one* was found? We read of no chieftain rebelling on account of religion, nor even making it a pretext for rebellion—we see no apprehension of any thing of the kind entertained by the government; and we must be convinced that historians are guilty of an 



---

p.22



anachronism when they attribute the fear of popery (a prodigy of much later growth) to these times. A decisive proof that the government had no reason to dread popery, and that the temper of the times was rather indifferent to either side of the question, is, that the same year produced bishops of both, sorts, for, on the 10th of May, 1550, Arthur Magennis was, by provision of the Pope, constituted Bishop of Dromore; and on the 3d day of September, Thomas Lancaster, a Protestant, *was* made Bishop of Kildare. In the remote provinces of Ireland all the Bishops were Catholics; nor was the opposition of Dowdal punished by removal from his See, until he voluntarily abandoned the kingdom. So little idea was there of rebellion on account of religion, that Cusack, in his letter to the Duke of Northumberland, mentions this as a period of the greatest tranquillity, highly favourable to the legal reformation of the kingdom.


Yet, though government gave no general cause of discontent to the Catholics, there were many particular severities and insults which laid the grounds of religious animosity. Archbishop Brown made war against images and reliques, with more zeal than prudence. The garrison of Athlone, no very conciliating reformers, were allowed to pillage the celebrated church of Clonmaccanaise, and to violate the shrine of a great favourite of the people, St. Kieran. The valuable furniture of the churches was every where seized and exposed to sale, so that the Catholics might very well suspect that the low estimation 



---

p.23



estimation which the Protestants entertained for the sacred uses of church decorations, arose from a keener sense of their pecuniary value.


However, the time was not yet arrived when religious bigotry had added its terrible influence to the other evils which wasted Ireland, The causes of the disturbances in the reign of Edward VI. were the same as those in Henry VIII. with the important addition of extensive confiscations.


The same policy was adopted, the same attempts to acquire a right to interfere in, and to regulate the concerns of the Irish chieftains.


We have seen that in the reign of Henry VIII. the territories and revenues of the powerful house of O'Neil were curtailed, by *ordering* O'Donnel to be independent of him. This naturally produced discontent, but as the head of the sept was a man of feeble character, no war ensued: Of course another encroachment was made; and in the reign of Edward VI. Macguire, Roe O'Neil, and several other chieftains, were declared independent of O'Neil, and the tribute (**Bonnaught**) paid to him, was seized on by the English government!


O'Donnel, too, who had been declared independent of O'Neil, found, like the horse who craved assistance from the man, that a too powerful ally is not easily shaken off; for his dependants were also declared independent. The interference of the 



---

p.24



English government seemed now to be generally dreaded, for in this instance the dependants were *forced* into their independence, *both* parties being obliged to obey the order on pain of forfeiting their estates.


This system of breaking the dependencies, as it was called, of the Irish chieftains, was a very obvious means of lessening their power, and converting the nominal sovereignty, which the English held over them, into an actual one. Other means were also adopted.


Upon the death of a chieftain, the English took every opportunity of imposing their own rule of hereditary descent, in place of the Irish mode of election. By thus obtaining the power for a dependant of their own, they could either exercise an absolute dominion over him, or make him an instrument to oppose a more powerful rival.


Thus, on the death of Murrogh O'Brien, Earl of Thomond, the Baron of Ibracken, the next in succession by blood, was obliged by the sept to nominate a Tanist. Daniel O'Brien was appointed to this dignity, but was obliged to relinquish it by the interference of the English; and **Leland** relates that this was the cause (not because he was a Catholic) of the sanguinary and successful war which he afterwards waged against the English.




---

p.25


An attempt was made by the English government to undermine the power of another dynasty by the same means.


The great Con O'Neil had been persuaded by Henry VIII. to accept an English title, the Earldom of Tirowen, which the English chose to consider as a species of enlisting, that ever after made the chieftain subject to military discipline. The title and the principality were entailed on an illegitimate son. This, of course, was a very obnoxious proceeding to the legitimate sons, and to the whole sept, and the power of the bastard, Matthew, rested entirely on the support of the English. He, feeling this, in order to pay his court, turned informer against his father, who was seized and imprisoned. Shane O'Neil, the legitimate son, invaded the bastard's territory. The latter, supported by the Lord Deputy, took the field; the armies met, and Shane O'Neil obtained a complete victory. Yet the deep enmity which Shane ever after retained against the English, has seriously been brought as a proof of the bigotry of the Catholic religion!


It is plain that the resentment and jealousy of the Irish chieftains on account of these encroachments, must have been in exact proportion to their power and independence. The only right which the English could claim so to interfere, was either from force or from custom. That they did not possess a force adequate to the object is clear. The military strength of the English, at the beginning of the reign
 


---

p.26



of Edward VI. does not appear to have exceeded 3000 men, and these were almost entirely Catholics. The real dominion the English possessed was contemptible, being confined to the little district of the Pale, and a few sea-port towns; for, we read, that **Sir Edward Bellingham** was the first man since the time of Edward III. that enlarged the English territory beyond the Pale; so that the English government, from the time of Edward III. till the reign of Edward VI. had not even the right to the monarchy of Ireland which flows from possession, but were like the rest of the chieftains, merely Lords of a provincial district.


Neither could the English claim from custom any right of controlling the different interests of the Irish chieftains. For even these encroachments were made under indirect pretences, while apparently the Irish princes, and even the degenerate English chieftains, were left in a prescriptive enjoyment of their savage independence, and their mutual feuds. What can be a more striking proof than that they retained the right of making war, peace and treaties, without any dread or expectation of the Lord Deputy's interference? not to go farther back than the present reign for instances, we find that ‘Manus O'Donnel fought a pitched battle with Calvagh O'Donnel, in Ulster, on the 7th of February, 1547.’


‘In Lower Delvin, Mac Maklin and Fally, with their united forces, invaded the country of the McCoughlans.’




---

p.27


‘The Earl of Thomond was at open war with his uncle, notwithstanding the Lord Deputy had used his good offices to unite them.’


‘Richard Burke was at variance with the sons of Thomas Burke: Richard was taken prisoner, and many of his men slain.’


‘Nor were the contests less violent between Richard Earl of Clanricarde, and John Burke. The Earl besieged John's castle, but Daniel O'Bryan came to John's relief, and forced the Earl to raise the siege.’


From these circumstances it is plain, that the Irish chieftains in the reign of Edward VI. could not be expected, either from motives of prudence or right to esteem themselves *subjects* to the English; and **Leland** is guilty of a gross misapplication of modern ideas to former times, when he talks of the *disloyalty* of the Irish chieftains. They were not at that time subjects either *de jure* or *de facto*.


Their submission was merely feudal, and nominal; and consequently when the English wilfully perverted this nominal acknowledgment of sovereignty into an actual enforcement of subjection— when they proceeded to interfere with the internal arrangement of each chieftain's petty empire—to release his actual subjects from their allegiance—to abolish his revenues, and alter or abrogate the laws of his nation, and particularly the laws of succession,



---

p.28



can we not see sufficient reasons for his opposing the English (or if you will call it so, rebelling) without referring to a cause which does not appear to have existed, namely, the Catholic hatred of Protestantism?


The English practised towards the Irish chieftains exactly that species of fraud which is frequent in bargains, when one party enforces his own sense of the terms, although he is aware that the other party never understood the terms in that sense.


The Irish chieftains submitted as feudal princes; the English knew that they did so, but they *chose* to understand that the Irish submitted as subjects. Like all men, conscious of duplicity, they acted with inconsistency. Though they began to call the Irish chieftains rebels, they felt they were not so; and whenever these chieftains were induced to submit, their submission was always received as a compliment, not as a matter of right, and was rewarded by titles and very considerable grants of land. Nothing essential was asked of them in return. **Leland** acknowledges that all their princely possessions and rights were guaranteed to them; and says, that ‘so little did they apprehend that their present engagements would produce any essential regulation of their territories, that they still governed their followers by the usual course of Brehon law.’




---

p.29


However unwarrantable by any prior right, this interference was, and however calculated to rouse the resistance of the Irish chieftains, still it might at last have produced the general reformation of Ireland, by establishing the English constitution and laws, in place of the barbarous usages of the Irish, if such had been the real object of the English.


But the English of those days, if they regarded the welfare of Ireland at all, regarded it with a malignant eye; their objects were to gratify their avarice as well as pride, to pillage as well as to tyrannize.


When they invaded the independent privileges of the Irish princes, and chose to consider their resistance as rebellion; had they contented themselves with abolishing the power and exactions of these princes, and extended to their wretched vassals, the protection, the security, and perfect freedom of the English constitution and English law; had they given them that interest in their lands which arises from the rule of lineal descent, instead of the barbarous mode established by the Irish Brehon laws they would have fairly won from these chieftains, the devotion of their subjects, and might have despised the resentment of these ancient dynasties, when bankrupt in the affection of their followers.


But intent only on pillage, their usurpation was so ruinous, that it gave to the native tyrannies grievous as they were, a preference which animated 



---

p.30



every heart and hand in their defence, and from this aera, the animosity of the Irish became more general and more virulent.


For the English not only invaded the privileges of the native princes, but they *confiscated the lands of their vassals.* Though the Irish chieftains exacted much from their wretched followers, still it was under the authority of certain laws, and something was left; the English swept away every thing.


This gave the Irish clans a clear interest in supporting their chieftains, this was the impulse that began, this gave the energy that supported the succeeding rebellion. What idle misrepresentation is it, to suppress a cause so intelligible—so powerful, and to ascribe its effect to religion!


It was in the reign of Edward the VI. that the solid foundation of the succeeding rebellion was first laid, by the confiscation of the lands of Leix and Offalia, now the Queen and King's counties.


This important event is thus briefly related by historians.


Upon the accession of Edward VI. O'Moor, prince of Leix, and O'Connor, prince of Offalia, drew the sword on pretence of some injury received. The lord deputy defeated them, ravaged their territory, 



---

p.31



seized on the lands, and drove out the old inhabitants. The chieftains themselves were induced to surrender and to attend the deputy to England, under the tacit promise not only of pardon, but the grant of the same favors and honors which Henry VIII. had bestowed on the chieftains who surrendered to him. Instead of this they were thrown into prison, their lands (i. e. the lands of the whole sept) were declared forfeited and granted to the very officers who had induced them to surrender. O'Moor died in prison, O'Connor attempting to escape was subjected to a strict and severe confinement. The new proprietors established their settlements by fire and sword, the most powerful members of these great septs were enlisted into the army in England, while the insurrections of the poorer proprietors were *chastised* by the forces quartered in the country.


Two whole counties disposed of in this cavalier manner, two principalities extinguished at a blow, and two tribes reduced to beggary, were sufficient causes to produce a general alarm among every sept, as well as all the chieftains in Ireland.


These circumstances appear sufficient to prove that a very small part of the origin of these wars is to he ascribed to religion which, if we except the petty insurrection of the family of Fitz-Eustace (and this is not a very clear case) seems to have had very little influence on events during this reign. But we must be allowed to dwell a little longer on the subject; 



---

p.32



for where a person advances new principles, to account for historical events of distant date, he cannot be too copious in adducing his illustrations.


Let it then be considered, that this invasion of the rights of the Irish chieftains, and the resistance which it is here alledged to have produced, were not events peculiar to Ireland, but had in fact flowed from a general crisis of political improvement, which had taken place successively through every state in Europe. In feudal times every nobleman enjoyed the prerogatives, and in several countries the title of king. Their dependance on their sovereign was for a long time merely feudal and nominal, while their power over their vassals was arbitrary and exclusive. As the power of the crown encreased, a struggle necessarily took place, which was the cause of wars throughout the whole of Europe. This was strictly the case between the English government and the old chieftains of English race, who had become independent in Ireland. It was nearly the same with respect to the Irish chieftains, only with less appearance of right upon the part of the English, as these chieftains could at no time have ever been considered in the light of subjects, their surrender to Henry II. being of the same nature as their surrender to Henry VIII. merely feudal, reserving to themselves all their princely prerogatives; like the bequest of Lewis XI. to the virgin Mary, of the whole and entire of his county of Boulogne, saving and excepting the *revenues*.




---

p.33


What was the case at the same aera in France?
 No one can attentively read the history of the celebrated league, without perceiving how much more influence the ambition of the nobility had on events than religion. For even long after Henry IV. changed his religion, when this pretext was removed, the Duke of Montpensier proposed to him, in the name of the principal French nobility, that he should resign to the governors of the provinces, the property of their governments with an *hereditary* right to them, requiring nothing from them but a feudal allegiance.[2](javascript:footNote('E800004-001/note002.html')) This shews the temper of the times, which ran entirely in favour of aristocratic independence; the encreasing power of the Crown appeared a novelty and encroachment, and was every where resisted with as much enthusiasm as the invasion of a foreign enemy. It only appears more conspicuous in Ireland, because the extreme weakness of the English colony had allowed not only the Irish chieftains, but its own subjects, to acquire an independence that had now gained the sanction of prescription.




---

p.34


Mary
----


There is a very remarkable and conclusive proof that popish bigotry had no great influence on the transactions of these times in Ireland, which is this; that when Mary, a popish princess, was called to the throne, and the Catholic religion restored, rebellions continued just as frequent as ever.


**Sir Richard Cox** allows the fact, but is so blinded by the idea, that every rebellion must have arisen from religion, that he professes himself at a loss to account for it


The following chieftains were engaged in reiterated insurrections: O'Connor, O'Neil, O'Carrol, Cavenagh, O'Madden, O'Molloy, O'Doyne, Mac Coughlan, Mac Geoghan, Fylemy Duff, O'Reilly, the Earl of Desmond, and Daniel O'Brien.


These very chieftains who had acknowledged Henry's supremacy in Church and State, revolted and agitated the whole country under the reign of the most zealous friend of the Catholic religion. 




---

p.35


Surely, attachment to the Catholic religion was hot the ruling motive to which we must refer the events of these times.


A still more striking proof that the Irish Roman Catholics in Queen Mary's reign, were very little infected with religious bigotry, may be drawn from their conduct towards the Protestants, when the Protestants were at their mercy.


Were we to argue from the representations of the indelible character of the Catholic religion, as pourtrayed by its adversaries, we should have expected that the Irish Catholics would have exercised every kind of persecution which the double motives of zeal and retaliation could suggest. The Catholic laity, in all the impunity of triumphant bigotry, hunting the wretched Heretics from their hiding places—the Catholic clergy pouring out the libation of human blood at the shrine of the God of Mercy, and acting before high Heaven those scenes which make the angels weep.


But on the contrary. Though the religious feelings of the Irish Catholics, and their feelings as men, had been treated with very little ceremony during the two preceding reigns; they made a wise and moderate use of their ascendancy. They entertained no resentment for the past; they laid no plans for future domination.




---

p.36


Even **Leland** allows that the only instance of popish zeal, was annulling grants which Archbishop Brown had made, to the injury of the See of Dublin, and certainly this step was full as agreeable to the rules of law and equity, as to popish zeal.


The assertors of the Reformation during the preceding reigns, were every way unmolested, or as the Protestant historian chooses to term it, were allowed to sink into obscurity and neglect.


Such, was the general spirit of toleration, that many English families, friends to the Reformation, took refuge in Ireland, and there enjoyed their opinions and worship without molestation.


The Irish Protestants, vexed that they could not prove a single instance of bigotry against the Catholics, in this their hour of trial, invented a tale, as palpably false as it is childish, of an intended persecution, (but a persecution by the English government, not by the Irish Catholics) and so much does bigotry pervert all candour and taste, that even the Earl of Cork, Archbishop Usher, and in later times, **Dr. Leland**, were not ashamed to support the silly story of Dean Cole and the Knave of Clubs.


How ought these perverse and superficial men to blush, who have said that the Irish Roman Catholics must he bigots and rebels, from the very nature of their religion, and who have advanced this falsehood, 



---

p.37



in the very teeth of fact, and contrary to the most distinct evidence of history.


The Irish Roman Catholics bigots! The Irish Roman Catholics are the only sect that ever resumed power, without exercising vengeance. 


Shew a brighter instance, if you can, in the whole page of history. Was this the conduct of Knox or Calvin, or of the brutal Council of Edward VI. who signed its bloody warrants with tears? Has this been the conduct of the Irish Protestants?


Had the Irish Roman Catholics, when they gained the ascendancy, debarred you of the rights of property, of the benefits of education, of the enjoyment of social worship, of the security of your domestic peace, of all that makes life grateful, by making it respectable; O! how would you not have bewailed your unmerited sufferings—how would you not have adjured the detestation of God and man on such monstrous oppression!


How strangely does bigotry cramp the heart and understanding! who could have thought that so obvious and splendid a proof of the original virtues of the Irish Roman Catholics, as this, should have been slurred over, and almost effaced by the wilful blindness of Protestant writers!


So natural is it that lions should be always represented as vanquished when men are the painters.




---

p.38


The Catholic religion, certainly could have no effect in producing rebellions during Mary's reign, yet we have shewn that rebellion still existed.


The causes of it were still the same.


‘The old Irish inhabitants of Leix and Offalia, or the King and Queen's Counties, could not patiently resign their claims and possessions to the new settlers. They were ever spiriting up their friends and followers to resist, what they deemed an injurious usurpation of their lands, and thus brought down the vengeance of government upon their heads. Numbers of them were cut off in the field, or executed by martial law, and the whole race of them would have been thus utterly extirpated, had not the Earls of Kildare and Ormond interceded with the Queen, and become sureties for the peaceable behaviour of some survivors!!—of *some* survivors!’


What a narrative delivered by the respectable **Leland** without comment or deduction!


Yet, as if the actual commission of unqualified confiscation, was not sufficient to spread alarm, and excite resistance; the English government made an unequivocal demonstration of their intention of possessing themselves of the whole kingdom.


The Chancellor was empowered to direct a commission for viewing all the towns, villages, and waste 



---

p.39



grounds of the kingdom, and reducing them to counties, shires, and hundreds.[3](javascript:footNote('E800004-001/note003.html'))


This was a direct blow at the independence of the Irish chieftains, and the government were very well aware of the effect this measure was likely to produce, for it provided that this commission might be suspended at any time in seven years, in case it created too much opposition.


Yet such is the inconsistency, such the wavering irresolution of conscious injustice; that at the very time the English government prepared, under the mask of law, to possess themselves of the lands of the native septs; they acquiesced in the constitution, and the lawful title of the Irish dynasties.


‘Owen Macgennis, on the 6th of December, 1553, was admitted by the lord deputy to be chief of his sept.’


Kevanagh, head of the great Leinster family of McMarchad, was created a peer of the realm by the title of Baron Balyan, but by the same patent was nominated chief of his sept or nation; exercising the ancient jurisdiction over all his followers.


So little did the Irish chieftains acknowledge any actual right of sovereignty in the English government,



---

p.40



that they still carried on their mutual wars, governed, their several nations, elected their tanists or successors, without any deference to the lord deputy.


Yet his interference was sufficient to support the alarm which seems at this time to have spread pretty generally through the Irish chieftains. The first object of the English government was to entail the Irish principalities on the eldest son; which was considered as a submission to the English yoke. The son in this case owed his appointment to the English, and would naturally be subservient to them; whereas when the chieftain was elected by his nation, the English government having no influence in his appointment, could have no presence to consider him as a dependant.


Happily there is one instance of the nature and effects of this species of interference, which may be pretty clearly made out, from such incidental mention as is made of it by historians; and will serve as a specimen of all the rest. This is the extinction of the principality of Thomond.


Murrogh O'Brien, king of Thomond, swore fealty to Henry VIII. and accepted of the title of Earl of Thomond, which earldom was entailed on his son Connor. Murrogh O'Brien retained all his prerogatives, and the title only was entailed; the English government purposely confounded the earldom with the principality, and because the one was 



---

p.41



entailed, chose to consider the other was entailed also. It is not improbable that Murrogh himself, little suspecting the farther encroachments the English would make, if suffered to achieve this first step, was flattered with the idea of his principality being changed from an elective to an hereditary title.


His subjects, however, must have regarded the change with indignation; their prejudices must have been violently shocked at the idea of the old custom of election being violated, and their pride must have been sensibly wounded at the entire loss of influence which they would suffer when the throne was no longer filled by the man of their choice.


Upon the death of Murrogh, his son Connor, who probably had been chosen tanist during his father's life-time, succeeded.


The sept then proceeded to chuse a tanist or successor to him, and their choice fell upon his brother Daniel, in preference to his son.[4](javascript:footNote('E800004-001/note004.html')) This was agreeable to an old Irish custom, which always preferred the brother to the nephew.


Upon this the English government, in Mary's reign, interfered, and insisted upon the son being chosen tanist. A war ensued, in which Connor lost his life, 



---

p.42



and the English succeeded in establishing his son by force of arms, to the exclusion of Daniel, who was the lawful successor.


In this instance we see the advantage which they reaped by setting up a rival to the legal chief. For the son feeling himself entirely dependant on the English government, consented to hold his lands as an English subject, and to renounce the title of the O'Brien. This was regarded by the sept, not as the conduct of a *rebellious* subject reclaimed to loyalty, but as a dereliction of every honourable, sacred, and legal principle. This is the description the Irish analysts of the time give of it: ‘He accepted,’ they say, the title of earl, but gave up the dignity of Dalkais, to the astonishment and indignation of the, descendants of Heber, Heremon, and Ith.


Here, the designs of the English government, in their anxiety to make the Irish sovereignties hereditary, were plainly betrayed. Their interference became generally suspected, and was always strenuously opposed.


We scarcely need insist, that the war which Daniel O'Brien waged during the reigns of Mary and Elizabeth, was to maintain his right, and not from attachment to his religion.


The insurrection of Shane O'Neil arose from similar motives.




---

p.43


We have seen that the English government, in a moment of power, had caused Matthew, the bastard of Con. O'Neil, to be appointed his successor, and entailed the principality on the heirs male of Matthew.


But upon the death of Con. O'Neil, his legitimate son, Shane O'Neil, was formally invested with the sovereignty, by the sept; and supported his just rights by arms, against his bastard brother and the English government.


It is plain that the conduct of Con. O'Neil, in allowing the succession to the principality to be regulated by the English, was extremely odious to the whole sept; as his son Shane appeared justified in throwing him into prison, and increased his own popularity by doing so.


A few years after the lord deputy, **Sir Henry Sydney** paid the most abject court to Shane, by going to him, and standing God-father to his child, (which was considered by the Irish as a stronger tie than affinity,) at the very time that Shane was in open arms.


At this ceremony a conversation took place between the lord deputy and Shane; which proves clearly that we have stated correctly the feelings and opinions of the Irish chieftains.


**Sir Henry Sydney** expostulated with Shane, on account of his insurrection, and his opposition to 



---

p.44



Matthew's title. Attend to Shane's answer, which is, pregnant with information:


He replied, ‘that in the first place, Matthew was a bastard; that anyhow, he could not derive a title from their father Con O'Neil's surrender to Henry VIII. for that Con's surrender was void, because he had but an estate for life in his principality; nor could have more by the law of tanistry, nor could surrender but by consent of the lords of his country; and that even by the English laws, the letters patent were void, because there was no inquisition taken before they were past, nor could there be any inquisition till the country of Tyrone was made shire ground. That he was elected O'Neil by the nation, according to custom; that he was the legitimate son and heir of his father, and lastly, that his title to, all he claims is by *prescription.*’


Such are his words as related by **Sir Richard Cox**, and yet the man who could reason thus has since been described as a stupid brute and a rebel.


To a statement so reasonable, **Sir Henry Sydney** had nothing to reply, and during his government Shane O'Neil was unmolested.


So far religion had little influence on events in Ireland, and the reign of Mary closed, unstained by the crimes of any holy persecutor in Ireland.




---

p.45


We must also do the Irish Protestants the justice to say, that they were free from all spirit of intolerance. That came from England.


The Irish Protestants had undergone no persecution, they consequently neither increased in zeal or numbers. In England, the Protestants had suffered much persecution; their numbers in consequence had multiplied, and their zeal become excessive.


One would imagine that the horrors of Mary's reign in England, would have impressed on the most callous heart, and the dullest understanding, how futile is the barbarity, and how sad the folly of religious intolerance. Yet, so perverse are the feelings of the vulgar, that the English Protestants seemed to rise from under the wheel of persecution, with renewed vigour, to persecute. Every instance of popish bigotry has been recorded, not to deter from bigotry, but to justify a similar indulgence in depraved and malignant passions, under the specious pretexts of retaliation and precaution.


True it is, there is no more difficult task than to suppress those feelings of vengeance which may arise from a natural source, but would be mischievous if generally indulged. Yet, what else is the meaning of virtue? what else the advantage of liberal education, but that the crude and impetuous suggestions of first impressions, should be disciplined and regulated, by the calm conclusions and enlarged views of moral utility?




---

p.46


Elizabeth
---------


The Irish rebellions in Queen Elizabeth's reign, have been generally ascribed to the influence of Roman Catholic zeal; and this opinion has been maintained both by Catholic and Protestant writers.


This circumstance might appear fatal to our argument, but this concurrence of opinion may be readily accounted for, even supposing the fact to have been otherwise.


For, those authors who have been most positive in ascribing these rebellions to religious principle, wrote in later times, when religious animosity had acquired its greatest rancour; and attributed the feelings of their own breasts to the times that had past; while the Protestant writers endeavoured to fix a stigma on the Roman Catholic religion, by setting it forth as the cause of these rebellions, the Roman Catholic writers, with a zeal equally eager, but less judicious, boast of these rebellions as an index of the fervency of the Catholic faith.




---

p.47


The wretched bigot, O'Sullivan, records a murder committed by Sir John of Desmond, on a Protestant, to whom he was much indebted, as ‘preclarum facinus.’[5](javascript:footNote('E800004-001/note005.html')) The Protestant bigot, **Sir Richard Cox**, relates as a very meritorious action, that Lord Mountjoy reduced the Irish papists to the necessity of eating one another.


We must turn from these writers, who can never be trusted in their studied representations, but only when they involuntarily betray the truth, to the cotemporary writers, who saw the scenes which they describe. These, on the contrary, make little or no mention of any existing animosity on the score of religion, and so far from considering it as a cause of rebellion, they do not give the Catholics credit for it, even when they professed it was so, but expressly declare it was never more than a pretext.


Though the hasty words of such a man as the **Earl of **Essex**** cannot be pledged as historical fact, yet we may quote them with great reliance, as expressive of his feelings and the feelings of the times, when he replied to Hugh O'Neil, ‘Thou talk of a free exercise of religion! thou carest as much for religion as my horse.’


The Earl of Desmond's rebellion has also been ascribed to his zeal for the Catholic religion. Let us hear what he says himself, and collect the degree



---

p.48



of his religious enthusiasm from the very words of this redoubted polemic.


It was made a condition by the Lord Deputy, that the Earl should promote the reformed religion in his territory. Desmond replies, ‘That as to the furtherance of religion in Munster, having no knowledge in *learning*, and being ignorant what was to be done in this behalf, he would aid and maintain whatever should be appointed by commissioners nominated for this purpose!’


As far as this rebellion is concerned, the testimony of **Sir Richard Cox** is decisive who, if he could have referred it to any thing like popery, would certainly have done so. He expressly allows that this rebellion arose from ‘the distaste of the old Irish potentates, and old English settlers, who had been dispossessed of their sovereign rights, and that religion was only made a *pretence* for rebellion.’


**Moryson** gives the same account of the origin of the insurrection under O'Neil. ‘About this time, the northern chieftains conspired to defend the Romish religion; (for now, first among them, religion was made the *cloak* of rebellion,) *to admit no English sheriffs,* and to defend their liberties and rights against the English.’


Those who have acquired from writers of later date an exaggerated idea of the fanaticism of the 



---

p.49



Irish Roman Catholics during the reign of Elizabeth, will be surprised to hear that there were no recusants till the reign of James I. This is a most important fact—a decisive proof that the growth of religious animosity in the Irish Catholics was gradual—that it did not arise from the establishment of a Protestant government, but from the intolerance of that government. This singular circumstance has escaped the attention and candour of every Irish historian, and is only casually mentioned by **Sir Richard Cox**; his words are, ‘it must be observed that till this time (Ann. 1604) the papists generally did come to church, and were called church papists.’


Another fact, scarcely less decisive in proving that rebellions arose, not from Catholic zeal, but from Protestant intolerance, is, that during the reign of Elizabeth, (when in Ireland intolerance was yet young) the Roman Catholics of the Pale, who considered themselves as of English descent, invariably fought against the Roman Catholics without the Pale, whom they considered as *mere* Irish. Roman Catholic and Protestant had not yet become the badges of a party. It was the English and the Irish-English, without distinction of Protestant and Catholic, waging war against what were termed, the mere Irish, and the degenerate English. It was on one side, a powerful government, possessed with the spirit of rapine, invading 



---

p.50



property and privileges not its own; it was, on the other side, a band of feeble, but lawful princes, fighting without hope, yet with pertinacity, because they fought for power and independence.


Religion, in fact, was nothing to the purpose. The English never mentioned it; the Irish only appealed to it as a known means of acquiring money and supplies from the Pope and the King of Spain. To lay stress upon religion, where passions and interests so much nearer to the human heart were at work, reminds me of a bon vivant who swallowed all manner of good things till he was fifty, and then attributed an attack of the gout, to eating too plentifully of water cresses.


There is no reason to believe that a single respectable Roman Catholic of the Pale, engaged in any rebellion, from attachment to his religion, during Queen Elizabeth's reign; on the contrary, they fought against the Irish, notwithstanding their common faith, with as much zeal as they had done for the four preceding centuries. O'Sullivan, a bigoted papist, reproaches them for doing so. Speaking of the reign of James I. he says, ‘And now the eyes even of the English-Irish (*i. e.* the Catholics of the Pale) were opened, and they cursed their former folly for helping the heretic.’




---

p.51


The English government were so sensible of the loyalty of the Irish-English Catholics, that they entrusted them, as usual, with the most confidential services. The Earl of Kildare was the principal instrument in waging war against the chieftains of Leix and Offaly. William O'Bourge, another Catholic, was created Lord Castle Connel for his eminent services; McGilly-Patrick, a priest, was the state spy.


The English government never betrayed any apprehensions on account of popery, but attributed the rebellions entirely to national feelings. In almost every letter of instructions to a Lord Deputy or a general, strong fears and jealousy are shewn of the *Irishry*, but never of the *papists.* The Queen herself perpetually remonstrated on the impolicy of employing Irishmen in the army, and after the defeat of Marshal Bagnell, gave directions that it should be cleared of them; but never mentions Catholics as objects of suspicion.


When Sir Henry Hannington was defeated by the O'Briens, Pierce Walsh was suspected of treachery executed, because he was an Irishman, as it is said, not because he was a Catholic.


The Lord Deputy speaking of Sir Conn McTeige, of Muscry, says, that ‘for his loyalty and civil disposition, he was the rarest man that ever was born of the Irishry.’ Every where we find that 



---

p.52



the being Irish, not the being Catholic, was supposed incompatible with loyalty.


To these facts we have to add the testimony of another cotemporary, and certainly a man of penetration, **Sir George Carew**. In his letter to **Sir Robert Cecil**, he takes pains to prove, that ambition, not religion, was the cause of the rebellions—that the chieftains of English race fought to maintain the independent Sovereignty they had been permitted to acquire; that the Irish fought to maintain or recover their monarchy and provincial kingdoms, which they inherited from their ancestors.


Thus far the Roman Catholic religion must stand acquitted of being necessarily a disturber of the public peace, under a Protestant government; and thus far we have refuted those superficial and uncandid writers who have attributed the great rebellions during Elizabeth's reign, to the factious spirit of popery. But to leave no doubt upon the subject, it may be desirable to produce the real causes of these rebellions, and to prove that they are sufficient to account for these calamities, without any reference to religion.


These, it will appear, were nearly the same as what produced similar effects in the preceding reigns.


1st, The general aversion which every nation has to be governed by a foreign country.




---

p.53


2ndly, The particular hatred conceived by the Irish against the English, on account of injurious usage.


3rdly, The confiscations of property which had taken place, to the ruin of entire septs.


4thly, The intention manifested by the English government, of quelling the usurped power and princely independence of the chieftains of English descent.


5thly, The hostility of the English government to the Irish princes, and the intention openly avowed, of destroying all their sovereign rights.


The first cause assigned is so generally felt, that it requires no particular comment, though its influence must at all times, and is unfortunately even to this day, very considerable.


Of the second cause, a multitude of instances might be brought, but very few leading points will be sufficient. **Sir John Davis** relates, that it was held no crime to kill a *mere* Irishman, and mentions two or three instances of the murderer being acquitted, on its being proved, that the sufferer had not been naturalized. The property also of the Irish, was placed without the pale of law, and the moral of the most part of the military history of the English, is getting *a great prey of cows.* The treatment of the Irish hostages, being generally the sons 



---

p.54



or near relations of chieftains, was particularly severe; and whenever these unhappy chieftains themselves fell into the hands of the English, their murder, for it can be called nothing else, was too generally the consequence. O'Rourke, the great chieftain of Leitrim, was delivered up by the king of Scotland, and hanged by Elizabeth in London. The treatment of McMahon we shall notice presently; these executions must have been regarded with particular horror by the Irish, as they themselves had no capital punishments, and such was their veneration for the persons of their chieftains, that when Hugh O'Neil, (who had learnt the custom in England,) ordered Hugh Gavelock's head to be cut off for informing against him; he could not find an executioner among his own subjects.


There is a fine reply of an old chieftain, who when brought to Dublin, was brutally shewn his son's head fixed on a pole: ‘My son,’ said he, turning from the horrid spectacle, ‘my son has many heads.’


Wherever the Irish were mentioned in the acts of parliament, it was to mark them out not merely as enemies, (though that was their appellation,) but as something wholly out of the contemplation of the common rules of law and morality.




---

p.55


Baron Finglas, in his Breviate of Ireland, gives several plans for the *improvement* of that country; one of them is, that no merchant do send any manner of wares among Irishmen, to be sold, on pain of forfeiture of the same.


Yet there appears nothing in the character of the Irish, to justify this excess of hostility and cruelty. Until the reign of Charles I. when religious persecution had soured their disposition, they seem to have maintained a very marked superiority over the English, in point of humanity and generosity; and this appears more striking, when we consider, that the principal historians are Englishmen who would naturally favor their own countrymen, and disparage the Irish; yet while they record the most atrocious actions committed by the English, such as the *assassinations* of Lord Mountjoy, and **Sir G. Carew**, they mention no instances of retaliation, or of similar brutality on the part of the Irish.


The Irish in fact possessed the virtues, as well as the vices which flow from elective monarchy.


While in their contest for their petty thrones, every species of violence and bloodshed was made use of, and seemed justified by established usage; in their private characters, they possessed that generosity, humanity, and affability, which was necessary to conciliate the affections of their sept.




---

p.56


A very amiable trait appears early in the Irish character, which has been very little noticed. Oh the first invasion of the English, we are told by **Leland**, that a synod of the church was held, to consider what national sin it was which had brought Upon their heads this terrible visitation. It was unanimously resolved, that it arose from the traffic which at that time was carried on in *English slaves,* and with a generous compunction which has since been very ill requited, this *slave trade* was abolished. A people who could reason thus, were certainly no barbarians; and when we consider the extreme humanity of their laws, which in no instance allowed the shedding of blood; we may conceive with what abhorrence they must have beheld that licentious system of English cruelty, which has been so minutely detailed by the principal instrument of its exercise, the author of die Paccata Hibernica. 


The third cause is of all, the most important.


It has already been explained, that if the English government had extended the protection of its laws to the different septs, it would have found no difficulty in overturning the power of the Irish chieftains without shedding a drop of blood. This power was founded upon customs and laws so destructive to the property and security of the wretched vassals, that they would gladly have transferred their ill requited allegiance to the fostering controul of English law; certainly when once they had submitted to it, and 



---

p.57



tasted the sweetness of an impartial administration of justice, of the secure possession of property, and the valuable privilege of transmitting it to their children; they never would have revolted, to submit to a slavery which had no recommendation from interest, or personal security.


But when the government, by a most cruel and absurd implication, confounded the sept with the chieftain, and because *he* resisted, confiscated their property; they took from them more than they could ever make a recompense for, and gave them a common interest with their tyrant, whom it otherwise would have been more natural for them to desert, when the enjoyment of a more lenient government, was within their reach.


But in fact, the object of the English government at that time, was plunder, and confiscation; they despised the natives too much to consider them as objects of care or civil improvement; they were only solicitous to improve every pretext for making forfeitures.


We have seen that the territories of Leix and Offaly, were confiscated under Edward VI. and the septs, as well as their leaders, banished or destroyed. This circumstance had given rise to frequent rebellions under Mary; and as well as we can collect, the septs, viz. the O'Moors, and O'Connors, had succeeded in a certain degree in recovering part of their possessions by force of arms. 




---

p.58


The reign of Elizabeth began ominously for Ireland. Her first instructions to Lord Sussex were, for ‘the distribution of Leix, Offaly, together with Iry, Glanmacaliry, and Slemergie.’ By the memorial of **Sir J. Perrott**, we find that all these *lands were made estates in tail to Englishmen.*


We have seen that the English government had influenced the chieftain Con. O'Neil, to surrender his territory, and take back a grant of it, with remainder to his bastard son Matthew, and his issue, instead of his legitimate son, Shane O'Neil. This policy exactly resembled what the English government has practised in later times in India; they raised a person to the throne, in violation of the customary mode of succession, who depended for his station on their power, who was strictly a dependant, and might be set aside whenever a favorable opportunity occurred. Upon the death of the father, Shane O'Neil was elected chieftain according to ancient usage. The English made war against him as an usurper; he is slain by treachery; and his territory, which in the eye of the English government itself, could not, by its own act, be considered as belonging to him, but to the issue of the bastard Matthew, was confiscated for his supposed rebellion; and the issue of Matthew, who had been guilty of no rebellion, were left destitute! So that in order to divert Shane, the territory was reputed Matthew's; and in order to get rid of Matthew's claim, the territory was confiscated as Shane's.




---

p.59


But in fact it belonged to neither. It was the great province of Ulster, which the chieftain possessed as a king, not as a landlord, and drew his revenue from various imports on the gross produce of the territory, and not from the territory itself.


The lands in fact belonged to the sept, and were held by them in joint tenantcy. To talk of confiscating the lands of Shane O'Neil, was the same as if the emperor of Austria was to confiscate the lands of the elector of Bavaria, to dispossess every old proprietor, and let every acre of ground to undertakers. To confiscate the most flourishing quarter of Ireland was even then much more easy to decree, than effect; and though this monstrous exploit was perpetrated in the end, yet for the present, it was more within the measure of the cupidity of the English government, than its power.


Yet the confiscation was decreed, and Elizabeth, with all the rapaciousness of a land pirate, took a share in the adventure.


The account is curious.


On the 9th of July, 1573, the Queen granted the **Earl of **Essex**** the half of the signories of Clanneboy and Ferny, &c. &c. The Earl was to go thither with 200 horse, and 400 foot, and maintain



---

p.60



them for two years. Afterwards the Queen and Earl were to keep an equal military force at their several expence, for the defence of their respective shares. Each was to bear an equal charge for erecting fortifications. Afterwards, division was to be made by commissioners, and then each might for twenty years build on her or his respective share, as they pleased: each might dispose of five thousand acres as they pleased; the Earl was to be Captain-general for seven years, and was to plant his part, as well as the Queen hers, until there should be a thousand English inhabitants in each moiety.


The royal and lordly robbers took their measures with the duplicity of conscious villainy. The Lord Deputy, Sir William Fitzwilliams, was instructed to give out that Essex came to repel the Scots, and not to hurt the *Irish.* In consequence he was joined by Bryan Mac Phelemy; who soon deserted him, probably on discovering his real views. The expedition failed, as likewise did another fitted out by Sir Thomas Smith, who sent his natural son to make a plantation in the Ardes. As if these measures were not sufficient to force the miserable natives to take up arms, fresh instructions were sent to let Leix and Offaly to English undertakers.


Can we be surprised to read in the next page that ‘The Lord Deputy found Ulster in a flame?’
or 



---

p.61



are we to allow that the flame was kindled by Catholic zeal?


The rebellions of the Cavenaghs, of the Knight of the Glynns, and of the Seneschal of Imokilly, arose from the same cause. Barry of Barryscourt was despoiled of his territory merely on a *complaint* being preferred against him by Raleigh. Sir Peter Carew set up an antiquated claim to half the kingdom of Cork, which was supported by the Lord Deputy and Council, although they were sufficiently aware of its probable effects, as, ‘Peter was advised not to *alarum* the Irish by beginning with them first.’[6](javascript:footNote('E800004-001/note006.html')) But the claims of the Queen, who seems to have had an eager spirit for rummaging into the ragged title deeds of the Irish, were more formidable. If priority of possession could make a good title, the Irish had the best in the world, as their genealogical tree was full of fruit before the other nations of Europe had thought of planting one.


But this title the English maintained was destroyed by the confiscations which took place after the successes of the English arms. The Irish might have replied by the same rule, when they re-conquered the lands that had been confiscated (which they had done,) the right derived by the English from 



---

p.62



from confiscation, should merge in superior right of conquest. But unluckily the Irish, according to their own proverb, had to go to law with the devil when the court was held in hell. We find directions from the Queen to escheat granted lands; to escheat lands which chieftains had surrendered, and which had been regranted to them, if the Queen or any other person could shew a title to them; which must always have been the case, as a previous confiscation was always held to be a title, and there was scarce an acre of land in Ireland but what had been confiscated.


After the defeat of the Earl of Desmond, and the confiscation of that quarter of Ireland called Munster, the Queen advanced a step farther in the destruction of every security of property.


There were some men of property who had sense enough neither to care about the Earl of Desmond or the Queen—who had not taken arms, and whose property could not be decently confiscated. The Queen thought they might be inconvenient in her plan of making a colony in Munster; and therefore required them to prove their titles; which if they could not do to the satisfaction of her commissioners, they were turned out; and which, if they could do, why they were turned out too; only they were to be insulted by a compensation, allotted by these same commissioners, Mr. Smith, and Mr. Meagle, ‘meet men, and apt in the profession of the law.’




---

p.63


Are we to be surprised, that a fresh rebellion[7](javascript:footNote('E800004-001/note007.html')) broke out? or is this too to be ascribed simply to the effect of Popish zeal?


The fourth cause we have assigned for the rebellions in Elizabeth's reign, is the intention shewn by Elizabeth to reduce the old chieftains of English blood who had become independent, and exercised princely prerogative, to the rank of mere subjects.


This was a difficulty which the English government had created for itself. It gave away the lands of the Irish with such liberality to its own subjects and dependants, that it made them too great for subjects.


Ulster (a whole province) was given to John de Courcy; the county of Meath to Hugh Lacy. The kingdom of Cork was granted to Cogan and Fitzstephens, the kingdom of Limerick to William de Braosa; Sir Thomas de Clare obtained a grant of Thomond, Ottho de Grandison of Tipperary, Robert De la Poer of Waterford, and William Fitzadlem of a large portion of Connaught. But a more material grant was the licence allowed to these robbers and their descendants, to raise troops, and take by force as much more territory as they were able. In consequence of these drains upon the sources of pillage, the crown had no more to bestow; every inch 



---

p.64



of land which had been obtained, or which it was possible to obtain by force, was engrossed by the chieftains of English blood.


This event had taken place even as early as Edward III's reign so completely, that in order to satisfy the voracity of a horde of disappointed adventurers, who had been drawn to Ireland on the speculation of new confiscations and grants, Edward was obliged to resume the grants made in his and his father's reigns. This invidious measure gave rise to the distinction of English by birth and English by blood, which afterwards produced so much animosity. The succession of English born in England, who passed over into Ireland to obtain civil employments or grants of land, were generally connected with some court influence, and obtained every thing worth having. While the old English by blood, born in Ireland, gradually lost their connection with the government, and degenerated, as it was phrased, into mere Irish.


Independent of the great property they had acquired, there was another foundation for the power of the English and Irish chieftains. Till the reign of Elizabeth, the English government was too weak at home to spare any great force for the protection of its colony in Ireland.[8](javascript:footNote('E800004-001/note008.html')) The defence of the pale rested entirely with Irish-English chieftains who were constantly inured to war, and from their knowledge 



---

p.65



of the natives and of the country, knew best the mode of warfare that was adopted.


The English government was also extremely necessitous, and hence the means and burthen of raising and maintaining a military force, were left entirely to these chieftains. It is not surprising that they soon began to esteem themselves independent of a power which would at any time have ceased to exist but for their protection.


They adopted the customs and prerogatives of the Irish princes whom they had dispossessed.


They not only levied armies, waged war, and made peace like other potentates, as the whim seized them, but they drew their revenues according to the Irish mode of taxation, partly from tribute paid by dependant chieftains, partly by imposts, called Bonnaught, Cutting, Coyne and Livery, Karnety, &c.


To mark still stronger their total secession from the controul of English jurisprudence, they adopted the Brehon law, they submitted their property, and that of their dependants to the custom of Gavelkind, as it has been improperly termed, more properly speaking, hodge podge; and their rank of chieftain descended according to the law of tanistry. All this the English government put up with very good humouredly, whenever it stood in need of these chieftains for defence against the native Irish; but whenever it occasionally gained a little strength, it was sure



---

p.66



to lay claim to its renegade subjects; and a continual source of jealousy and bickering, and ultimately of very serious and sanguinary wars arose to England, exactly in proportion to the rapine and ravage she had committed in Ireland.


It is of no consequence to our present enquiry whether the English government, or its degenerate subjects were in the wrong; we shall only observe, that the English-Irish chieftains had obtained a right by prescription to their independence, as far as lapse of time, and long possession could establish it: and as this is the firmest foundation of all right, there must have been great apparent hardship in requiring these chieftains to descend at once from the rank of princes, to that of mere subjects, at least it must have appeared so to them; which is sufficient for our purpose, as we wish only to prove that this sense of injury, and not religion, was the cause of their rebellions.


A short account of the rise and fall of the house of Desmond, will be sufficient to shew the real causes of the rebellion of its last earl under the reign of Elizabeth.


At the time of Edward II. the English power in Ireland only maintained a passive existence from the voluntary services of Maurice Fitz-thomas of Desmond. He was sufficiently brave, but extremely poor; and receiving no supplies from England, he was obliged to adopt the Irish custom of Coyne and 



---

p.67



livery, or free quarters, for the support of his army. This measure had its usual effect; the inhabitants of Kerry, and of the counties of Limerick, Cork and Waterford, who were exposed to it, were either murdered, or so harrassed by extortions, that they left their possessions to seek a temporary security, where the country was not desolated by a protecting army. Desmond, his kinsmen, allies and retainers, entered into these possessions, and appropriated the lands to themselves. Desmond took what he liked for his own private property, and reserved an Irish seignory or the right of Bonnaught cuttings, &c. over the rest. So that he raised his income from one thousand marks per annum, to ten thousand pounds per annum; an enormous sum in those days.


From this time the Earls of Desmond assumed all the prerogatives of independent princes, refusing to attend parliament, levying taxes, making wars, and as they could find no precedent for their conduct in English law, they very naturally adopted the old Irish usages which were quite consonant to their views.


Their example was followed by nearly all the English families of considerable property, by the Burkes, Birminghams, Dexons, Geraldines, Butlers, Condrons, &c. who, in the stile of Irish royalty, assumed a fictitious sirname in place of the title of prince. Such as McWilliam Eighter; McYoris, McCostelo, McMorris, McGibbon, McPheris, &c. 



---

p.68



They all had their particular nations and their tributaries; they levied taxes according to the Irish usages, and made wars when they pleased, and with whom they pleased. They met with very little interruption from the English government, which either regarded this assumption of independence with indifference, or was too weak to prevent it. Whenever it acquired a momentary strength, the lord deputy would catch hold of an earl of Desmond, and try and attach him to the court, or hang him; which only served to keep the jealousy of these degenerate chieftains against the English government alive. No steady or efficacious system was adopted to reduce their power, till it had acquired almost the sanction of prescription.


This was the state of things when Elizabeth ascended the throne, when every cause, which had so long repressed the natural energy of the English government of that solid and spirited force which arises from wise and equal laws, was removed; while the Irish had not advanced a step from the weak and impoverished state which had been engendered by tyrannical habits and absurd laws. Elizabeth felt the difference, and knew her power, and proceeded to reduce these long established dynasties to the rank of subjects. These unfortunate chieftains were too ignorant to comprehend what the power of England was, they only recollected how weak it had been. They had been in the habit of treating the threats of the English government with scorn, they had been successful in throwing off its controul and repelling its aggressions by force. 



---

p.69



 
Is there any thing miraculous, that when fresh threats were held out, and fresh aggressions prepared, they should again have recourse to force? What has this to say to religion?


Take the particular instance in this reign of Garet, he last earl of Desmond. The lord deputy summoned him to resign all the princely prerogatives which had been transmitted to him through a long line of ancestors. He consults his relations and feudatories, who unanimously advise him to resist so *unreasonable* a demand, and promise to maintain their advice by force of arms, against the deputy or any other that *will covet the said earl's inheritance.* Not one word of religion. The Earl of Desmond had always been considered as the leader of the English-Irish chieftains; he was the most powerful and wealthy, and stood most forward on the canvass. As long as his privileges were untouched, theirs remained secure, when he was attacked, their welfare was in jeopardy till the contest was ended.


On this head there was no doubt of the intentions of Elizabeth; and consequently as soon as a small force of Spaniards landed at Smerwick, the Earl of Desmond and all his feudatories, turned their arms against the lord deputy.


But the Irish had at length to learn the difference between the force of a government, founded on wise laws, and the power of their dynasties which rested on principles, repugnant to justice, and common 



---

p.70



sense. The forces of the earl of Desmond were defeated, dispersed, annihilated; all compromise denied to him, because, as it was admitted, his possessions were of too princely an extent to be rescued from forfeiture. The wretched old man was hunted like a wild beast, from his forests and his caverns; he was surprised at length in a miserable hut; his head was cut off; and out of compliment to the queen, was conveyed to her, and impaled on London bridge.


All the Earl of Desmond's property was confiscated, and as it was convenient for the English government to construe the sovereignty he held over a large territory into property also, the estates of his clan, and his feudatories, were also confiscated. That is, nearly the whole province of Munster.


Hence we may trace the cause of the succeeding rebellion, without having recourse to that which has been made a saddle for all horses—religion.


The fifth cause for the rebellions under Elizabeth was the plan adopted by the English government, of destroying the power and privileges of the Irish princes.


When we consider, that at the commencement of Elizabeth's reign, there were more than sixty independent chieftains in Ireland, of whom the greater part were in fact kings, and possessed of unlimited power over their subjects, when we know the attempts that had been made, and were at this period 



---

p.71



absolutely making, to reduce this band of sovereigns, who traced their descent from the most remote antiquity to the condition of subjects; instead of looking for imaginary causes of rebellion, one is surprised, that rebellions were not more frequent, and conducted with more unanimity. Why, during the early reign of Elizabeth, when the English force was insignificant, when the reign of a woman could not appear formidable to men who excluded women from their own petty thrones; why, when the whole province of Ulster was confiscated; when the name of O'Neil was abolished, when the laws of tanistry were pronounced treasonable by the English law; why was there not a general union, and a prompt resistance of all the Irish chieftains, to an aggression, which aimed at the very foundation of all their princely rights?


The English government was in fact not so inimical to the Irish chieftains as it appeared; it was too conscious of the injustice and weakness of its pretentions to act up to them. In the very act which pronounces the prerogatives of the Irish princes an usurpation, and abolishes them as such, a power was vested in the Lord Deputy to re-grant the same by letters patent, with much greater privileges than the chieftain possessed by the rules of the Irish law.[9](javascript:footNote('E800004-001/note009.html'))




---

p.72


A chieftain possessed by the Brehon law, no property in the territory over which he ruled, except his patrimonial lands; he possessed the throne only as a life tenant; the succession did not necessarily descend to his son; on the contrary, his successor was generally elected by the sept during his life, and in some degree divided with him, the influence of government.


Whereas if he agreed to hold his petty empire by letters patent from the English government, immense advantage accrued to him. All the duties and exactions customary by the Brehon law, were continued to him; and in addition, the lands of the whole sept (by a most extravagant stretch of injustice) were made absolutely his private property, and what was still more gratifying, he was released from the interference of an elected successor, and his ancient prerogative and his new possessions were strictly entailed on his eldest son.


From this statement, one might be surprised that every chieftain did not immediately submit to hold his territory by English tenure. But there were several causes to produce hesitation. Pride strongly combated interest; and as the objects of interest are, after all, of no value except as they contribute to the gratification of pride, it is no wonder that in many instances the end was preferred to the means; and that the princely descendants of a line of kings preferred an honourable dominion, conferred by the free choice of their subjects, to a more lucrative 



---

p.73



grant bestowed by an overbearing and foreign power. Besides, the design of the English government was, at all events, to acquire a nominal supremacy over the Irish chieftains; and this once established, to overthrow, when the opportunity offered, those prerogatives which were suffered to remain. This could not entirely escape the jealousy of the chieftains, and made them cautious how they surrendered for any momentary advantage their ancient title to their sovereignty, which was too strong in prescription to be questioned.


Yet the snare had to a certain degree succeeded; and though few of the Irish chieftains had consented to hold their territories by English tenure, yet their suspicions were lulled, and their animosities were disarmed, till the designs of the English government became too glaring to be mistaken.


This event took place on Sir William Fitzwilliam being appointed deputy, Ann. 1589. We are informed by **Fynes Morrison**, (a bitter enemy of the Irish,) that previous to Sir William's arrival, the kingdom was in the best state it had been a long time; any chieftain readily attended, when summoned by the lord deputy, none of them were discontented; the country was plentiful in corn, cattle, and all manner of victuals. This state of things was completely reversed by the outrages committed by the lord deputy against the Irish lords, McTuathel and O'Dogherty, and the Irish chieftain McMahown.




---

p.74


Sir William had received information, that part of the treasure on board the ships belonging to the Spanish armada, wrecked on the coast of Ireland, had fallen into the hands of the Irish in Munster.


He entered the country, but being disappointed of his booty, he seized on McTool, and O'Dogherty, who of all the Ulster lords, had been most faithful to the English, and put them into prison.


The first refusing to pay for his enlargement, continued prisoner till Sir William Russel's government, who in pity discharged him; but the old lord's heart was first broken, so that he shortly after died. The second was released, after two years imprisonment, not without paying for his liberty, as the Irish say.


‘And at this hard usage, all the great men of the Irish, (especially in the northern parts,) did much repine.’


But the murder of McMahon, prince of Monaghan, at length opened the eyes of the Irish chieftains to the designs of the English government, and shewed them that the sword afforded better security for their rights, than an English patent.


McMahon, chieftain of Monaghan, had surrendered his country to Elizabeth, and, as was the custom, received a re-grant of it to him and his heirs male, and in default of such issue, to his brother Hugh.




---

p.75


He died without issue, and Hugh took possession. The lord deputy Fitzwilliam, proceeded to Monaghan, under pretence of giving McMahon security in his possession. But as soon as he arrived there, he raised an accusation against McMahon, for having two years before recovered some rent due to him by force of arms. This by the law of the English pale was treason, but McMahon had never stipulated to be subject to the English law; on the contrary, the patents by which their territories were re-granted to the Irish princes, either formally acknowledged the validity of the Irish Brehon law, or tolerated it by a silence equally expressive.


The unhappy McMahon, for an offence committed before the law which declared it capital, was established in his country, was tried, condemned by a jury formed of private soldiers, and executed in two days, to the horror and consternation of his subjects and the rest of the Irish chieftains. His territory was distributed to Sir H. Bagnall and other English adventurers. Four only of the sept saved their property.


This event was well calculated to decide the Irish chieftains in taking up arms. ‘Certain it is,’ says **Morrison**, ‘that upon Mac Mahon's execution, heartburnings and loathings of the English government began to grow in the northern lords against the state, and they shunned, as much as they could, to admit any sheriffs, or any English to live among them.’




---

p.76


The minds of the Irish princes had already been sufficiently inflamed. English garrisons were forced on them under different pretences, which, removed from any responsibility, pillaged and laid waste the surrounding country. The English sheriffs were a yoke no less grievous: Established under pretence of introducing a more equitable administration of justice, as soon as they were firm in their seats, their extortions and exactions, with less appearance of right, became more intolerable than those of the native dynasts. In the instructions to Lord Grey and to **Sir John Parot**, the abuses committed by the English garrisons appear to have been notorious. The dread of an English sheriff had become so great in the Irish territories, though at first they were thankfully accepted, that his life was not secure. When Fitzwilliam proposed to Mac Guire, Prince of Fermanagh, to send a sheriff into his district, Mac Guire replied: ‘Your sheriff shall be welcome, but let me know his Erick, that if my people cut off his head, I may levy it on the country.’


A creature of the Lord Deputy, named Willis, was sent as sheriff, who according to **Moryson** and Lee, ‘harrassed the country with three hundred of the very rascal and scum of the kingdom, which did rob and spoil that people, ravish their wives and daughters, and make havoc of all.’


**Moryson** himself particularizes the tyranny of English sheriffs as a leading cause of the succeeding confederation of the Irish dynasts; and in their remonstrance 



---

p.77



to Wallop and Gardiner, who were appointed to confer with them, they insist upon being exempted from garrisons and sheriffs. Even had the English garrisons and sheriffs committed no abuses, the eagerness with which the English government seized every pretence to introduce them, must have worn a very equivocal appearance to the Irish chieftains; it might have proceeded from a wish to promote tranquillity and law, but it might also proceed from a design of subverting the prerogatives of the Irish dynasts, and seizing on their territories.


This being the fact, it was difficult for men so immediately interested, to be entirely unaware of their danger, and the period fast approached when it became necessary for them to forget their mutual feuds in their common peril, and make a last struggle for their independence, their power, and their property.


The period was favourable, as far as common injuries could give union and vigour to their exertions.


The sept of Mac Mahon, equally regretting their murdered chieftain, and abhorring the seneschal set over them, were ripe for action. Mac Guire roused to arms, by the indignity he had suffered from sheriff Willis, was only repressed by Hugh O'Neil, who had not yet thrown off the mask.




---

p.78


The O'Connors, and O'Moores had bravely contested the possession of their native territories, Leix and Ophalia, and were now in great force.


The chieftains of the De Burghes, originally English, but who had long enjoyed the independence and absolute prerogatives of Irish princes, had resisted the attempt of **Sir Richard Bingham**, to reduce them to the state of subjects; alarmed for their independence, and grievously harrassed (as we are told) by Wallop, by the late introduction of sheriffs, their defeat was only productive of forced submission.


O'Rorke, who had been driven from his petty principality by **Sir Richard Bingham**, had taken possession of Leitrim, and bid defiance to the lord deputy.


Shane McBrian O'Neil had taken arms to recover an island and a barony wrested from him by the **Earl of **Essex****, who had imprisoned him till he surrendered them.


The inhabitants of Munster, driven from their possessions by the English undertakers, had collected in force, and only waited an opportunity to recover their properties; they soon after elected James Fitzthomas, commonly called the sugan earl of Desmond for their chieftain. He had the command of eight thousand men, as we learn from the Pacata Hibernia, he was elected agreeable to the law of 



---

p.79



tanistry, on condition of doing homage to O'Neil, and was in every respect, a prince contending for power, and not a bigot striving to establish a domineering religion.


But the most formidable support of the Irish war, (for it is quite impossible to call it a rebellion, where there were more than sixty kings of acknowledged right, though possessed of trivial territory, fighting for the existence of their power) were the talents and courage of two principal chieftains O'Donnel, and O'Neil.[10](javascript:footNote('E800004-001/note010.html')) O'Donnel was a hero. O'Neil was something still better. With equal courage and perseverance, he knew how to bend to circumstances, and to supply by address, the immense inferiority of force, which did not deter him from the daring attempt to release his country from a foreign yoke.


These men, whose characters have been basely traduced by historians, too bigoted to be generous; wanted only a more splendid sphere of action, to have ranked with the greatest characters that great events have produced. However, granting it otherwise, it does not affect the present argument, which tends to shew, not that the Irish chieftains were heroes, but simply that they were not bigots.


Hugh O'Neil was the son of the bastard Matthew, and in opposition to the Irish usage of tanistry (as we have already shewn) the dynasty and foe of Ulster was vested in him on his father's death, by 



---

p.80



letters patent under the great seal. He committed no act to forfeit his right, but because Shane O'Neil rebelled, to whom in the eye of the English law Ulster did not belong, it was confiscated to the queen's use; and Hugh O'Neil suffered the penalty for another person's treason, and that person his opponent. The queen, however, was not then sufficiently powerful to take possession, and to compleat the inconsistency, she acquiesced in the election of another chieftain Tyrlogh Lynogh.


On his death, Hugh O'Neil was inaugurated by a better title than the queen had to bestow, the free election of the whole sept, who from time immemorial had appointed their chieftains. O'Neil was too well acquainted with the English court, and knew he could only maintain his rights by force. After he had endeavoured to supply his inadequacy in military strength by that policy which can alone give the weak the advantage against the strong; he took the field, and gained a decisive victory at Blackwater.


Hugh O'Donnel shared with him in the glory of the day; their ancestors had always been enemies, it was an O'Neil who in Henry VII's reign, wrote to Hugh Roe O'Donnel. ‘Cur hoom mi keesh no monna Curhir!’ i. e. ‘Send me my tribute, or if you don't!’—To which O'Donnel replied, ‘Neel keesh a gut urm, agus da beh,’ i. e. ‘I owe you no tribute, and if I did!’




---

p.81


We have seen in the reign of Henry VIII. the Lord Deputy declaring O'Donnel independent of O'Neil; but when the Lord Deputy proceeded to declare O'Donnel's dependants also independent, it seems to have opened his eyes, for we hear of no more disputes between the O'Donnels and the O'Neils.


The wrongs of Hugh O'Neil, a worldly and politic man, are not calculated to excite interest, but those of the open, generous and spirited O'Donnel will move any feelings but those of a bigot. The father of Hugh O'Donnel, the powerful Prince of Tyrconnel, refused to admit an English sheriff in his territory. The English government were too conscious of the villainy of the attempt, and their want of any plea of right, to enforce it by arms. They had recourse to means which would appear incredible, if the truth of the fact was not well authenticated. What must have been the general conduct of the English, when Sir John Perrott, who was *accused* of favouring the Irish, and who was beloved by the Irish, as comparatively a just and humane deputy, when he contrived and boasted of the following project:


A merchant of Dublin was instructed to feign himself a Spaniard, and to sail up by Donegal into the territory of Tyrconnel, to shew an extraordinary courtesy to the natives, to invite and feast them in his ship.—If the old chieftain or his son came on board, to intoxicate them, secure them under the 



---

p.82



hatches, and convey them to Dublin. The stratagem succeeded, and Hugh O'Donnel was the victim. And what was his treatment afterwards when policy could not point out any reason for farther cruelty? Take the account from Lee's memorial to the Queen:


‘After the obtaining of him, his manner of usage was most dishonourable and discommendable, and neither allowable before God nor man. My reasons are these: He being young, and being taken by this stratagem, having never offended, was imprisoned with great severity, and many irons laid upon him, as if he had been a notable traitor and malefactor.’


His imprisonment would have lasted for life, had he not found means to make his escape with the two sons of Shane O'Neil and O'Reily. Hugh O'Donnel and Arthur O'Neil were hotly pursued; they were obliged to conceal themselves in a fastness without food, and exposed to the cold of a severe winter. In this situation they remained four days, when they were discovered by their friends. Young O'Neil was expiring.


Hugh O'Donnel, deprived of the use of his limbs by the severity of the cold, was weeping bitterly over his friend, and endeavouring to preserve his life by sheltering him with his own body. Arthur O'Neil died. O'Donnel regained Tyrconnel, and swore eternal enmity to the English. His father 



---

p.83



resigned his power to him, and he was solemnly invested with the principality of Tyrconnel by the suffrages of his sept.


Upon the defeat of the English at Blackwater, every Irish chieftain took arms. **Morrison** gives a list of them and of their forces, which is alone sufficient to prove that the English government could not, with any propriety, consider them as subjects; directed by O'Neil and O'Donnel, they defeated the best appointed army which had ever been sent from England; and Essex, who commanded it, returned to England disgraced. This was the only time that the fortune of Ireland seemed to gain the ascendant. O'Neil, with an inferior force, had baffled the English by address; he had now the superiority, and his success appeared certain. Every chieftain, whether of Irish or English extraction, saw that they could only hope to maintain their prerogatives and independence by force of arms, and their natural courage was instigated by every spur of pride and self-interest. The assistance of Spain was hourly expected. The ablest of the English generals were cut off, and the Queen's army thought only of defending the Pale.


Lord Mountjoy was appointed Deputy in the room of Essex, and every thing was reversed. Lord Mountjoy, under an effeminate exterior, possessed all the qualities necessary for conquest; courage, promptitude, cunning, unshackled by probity; severity unalloyed by compassion. He made 



---

p.84



every means subservient to his end, and opened his way by the cruellest perfidy and the most horrible and undiscriminating havoc. His object was to take off the Irish chieftains by assassination, and to reduce the country by famine. His success was complete: but to make the reverse of all their fortune as bitter as possible to the Irish, a seeming certainty of success immediately preceded their complete ruin. Don Juan de Aguila landed at Kinsale with a large body of Spaniards. O'Neil and O'Donnel collected their armies, and Lord Mountjoy, with an inferior force, was hemmed in on all sides. Don Juan intended to attack the Lord Deputy: in vain O'Neil urged the want of discipline in his troops, and the certainty there was of reducing the Lord Deputy by cutting off his supplies. The fate of Ireland was decreed. The attack was determined, the design was betrayed, the Spaniards did not act in concert, and O'Neil and O'Donnel were entirely vanquished.


O'Donnel, and with few exceptions the whole body of Irish chieftains, disdaining to live as subjects where they had ruled as kings, passed over into Spain, where they were received with all the respect due to their rank, and all the tenderness that could alleviate misfortune. O'Neil, confident in his resources, maintained a short and fruitless struggle, and then followed their example. This is one of the most singular, and yet least noticed, revolutions that ever took place in any country.




---

p.85


Sixty princes, independent, and exerting kingly prerogatives from time immemorial, after a contest of five centuries, were in the course of six years swept from the face of their country by the superior energy of an ambitious woman. They fought long and they fought bravely, and though vanquished they did not yield. This was clearly a contest of power, not of religion. We cannot refuse our sympathy to their wrongs, their courage, and their misfortunes; but it is the ideotism of fanaticism, to applaud them for their piety, or to censure them for their bigotry. Religion was never appealed to by them, but as a pretext calculated to gain them money and ammunition from Spain and the Pope, and to throw an additional stigma on the name of Englishmen.


Yet, since we find the Catholic religion assuming a considerable degree of consequence, as a principle of discontent in the succeeding reign; there can be no doubt that it had gained considerable hold of men's minds during the reign of Elizabeth. It is true, that at the beginning of the war, the being a papist was no cause of suspicion; all the towns were peopled with Catholics and remained loyal; the Queen's army consisted mostly of Catholics, and was generally commanded by Catholic officers; yet latterly apprehensions were entertained of the loyalty of the cities and towns at the same time this 



---

p.86



is mentioned as a matter of surprise. **Sir R. Cox** says ‘the very cities and towns were staggering, and so frightened by the threats of the clergy, that no trust would be reposed in them.’ O'Sullivan mentions it as a subject of regret, that only a few of the papists in the Queen's army revolted. Yet this shews that there was a certain degree of disaffection connected with religion. **Camden** also relates, that many of the papists, who had been loyal, sent to Rome for a dispensation of this *crime.* When the young Earl of Desmond was sent by Elizabeth to Ireland, the people of Munster at first received him with congratulations, but deserted him on discovering that he was a Protestant.


These are the most material instances we collect of the progress of Catholic bigotry during Elizabeth's reign, which prove that it existed in no great degree, yet that it did exist and had encreased.


The reasons for this encrease appear to be these:


First. The Protestant religion having met with no persecution in Ireland, made no progress. The native Irish to a man remained Catholics, while the Protestants consisted entirely of English. Hence English and Protestant became synonimous terms, and by a natural association of ideas, the hatred entertained by the Irish to the English was continually transferring itself to the religion of the English; and, by the reverse cause, their attachment to 



---

p.87



the Roman Catholic faith encreased, from its being the badge and peculiarity of their own body.


Secondly. In the war which they were waging, the chieftains derived the most important advantages from professing and inculcating in their followers the most devoted attachment to the see of Rome. O'Neil, though indifferent to religion himself, was too politic to forego so favourable a pretext, and declared himself the champion of the Roman Catholic religion: in consequence, supplies of money and men were obtained from the Pope and the King of Spain. Vicars and Jesuits were sent over to Ireland, who, by the customary arts of zealots, awakened religious fanaticism; and gave effect to a bull of excommunication issued against Elizabeth by the Pope. Mac Egan, the Pope's Vicar, never allowed any Irish papist that served the Queen to be pardoned when taken prisoner. The Irish chieftains, however, were never infected with this theological spirit; we hear of no murders or massacres of Protestants, as such, though they afterwards shed such horror over the rebellion of 1641. Yet men, the most indifferent to the meaning of their own professions, will insensibly be influenced by the constant repetition of them.


Though at first the Irish chieftains espoused the Pope's quarrel from policy, there is no doubt they became attached to it from principle, and the misfortunes they suffered while engaged in its cause, 



---

p.88



gave it that hold on their hearts which it never would have gained on their understandings.


The last reason seems to have been the distinctions drawn between Catholic and Protestant by the laws: these distinctions were comparatively trifling during the time of Elizabeth, and may be seen in the acts of the 2nd of her reign. But nothing is trifling that wounds the vanity or pride of men, motives which influence their conduct much more than grosser interests. They gave to O'Neil an opportunity of repeatedly demanding the free exercise of the Catholic religion, which claim (as is usual) was refused with a pertinacity equal to its insignificance.


This was sufficient.


The practical persecution, however, which was felt or feared by the Roman Catholics, was of greater extent.


In the pardon granted to the province of Munster by **Sir G. Carew**, he himself tells us (in the Paccata Hibernia) that Priests and Romish religious persons were excepted. The Priests were always murdered in cold blood, whenever a town or garrison was taken. Sir C. Wilmot, when he took the Lord of Lixnaw's castles only spared the Priest's life, to get possession of the Lord of Lixnaw's child. **Edmund Spencer** speaking of the state of religion in Ireland, of which he had been an eye witness, 



---

p.89



delivers this just and admirable sentiment, which shews that practical persecution did exist: ‘In planting religion, thus much is needful to be observed, that it be not sought forcibly to be impressed in them, *with terror and sharp penalties, as is now the manner,* but rather delivered and intimated with mildness and gentleness, so that it may not be hated before it be understood.’


This maxim, however, was so little congenial to English jurisprudence, that on the contrary, Valentine Brown calmly recommended the extirpation of the Irish papists, as the best means of advancing the Reformation. These reasons appear sufficient to account for the degree of Roman Catholic bigotry which appeared at the conclusion of Elizabeth's reign. But, as I imagine, that at this time was also formed that sanguinary character which henceforth marks the Irish, and the Popish religion in Ireland. I shall plead no excuse for digressing to point out its cause. This was the extreme ferocity with which this war of Elizabeth was carried on, against the Irish and the Irish chieftains.


Superiority and impunity are the only conditions necessary to develope the natural barbarity of the human heart, when its object is power. What we despise we appear to have a right to oppress. Hence, the nations which are themselves the most free, prove the greatest tyrants to their dependants. Hence the contempt which the white men in the West Indies feel for the black, may be considered 



---

p.90



as partly the cause, as well as the effect, of the oppression of the latter.


While the Irish were able to maintain a pretty equal struggle with the English colony, that is, till the reign of Elizabeth, the common usages and laws of war (unless they were very unsuccessful) were preserved towards them. But when the power and pride of the English became so highly exalted under Elizabeth, the Irish were considered as a sort of rebel savages, clearly excluded from the contemplation of the laws of God and man, the violation of whose rights formed no precedent that could affect civilized nations; and it did not follow that a man who should spoil and murder them might not be possessed of an upright and gentle heart; as the owner of a privateer may be a very honest merchant, or a butcher a very tender husband.


Not to weary the attention with a repetition of cruelties, which would become monotonous in spite of their singular atrocity, we will confine our remarks to the policy and conduct of the Lord Deputy Mountjoy. He adopted the plan for reducing Ireland, pointed out, though not practiced, by the **Earl of **Essex****: this was by the sword and by famine. That there might be no cessation to military execution, the armies were kept on foot during the winter; sallies were made from forts and garrisons, to prevent the sowing of corn; every exertion was made to capture or destroy the cattle, and in summer, the soldiers were employed to cut down the 



---

p.91



corn in the well-affected parts of the country, as well as the territories belonging to the chieftains in arms; no quarter was given in the battle, and prisoners taken in garrisons were murdered in cold blood. Whole districts, from the smallest pretence were delivered up to the sword.


Because the Queen's troops could not kill fast enough, no Irishman was pardoned, unless he undertook to murder his nearest friend or relation. Lord Mountjoy's secretary relates that, ‘Lord Mountjoy never received any to mercy but such as had so drawn blood on their fellow rebels.’ Thus Mc. Mahon and Mac Artmoyle offered to submit, but neither could be received without the other's head.


‘I have,’ it seems, says Lord Mountjoy, ‘made some of them put themselves *in blood* already; I hear that Lord Mountgarrett's sons have killed some of Cloncares and some of Tyrrill's followers: since I contested with their father, about somewhat I heard suspicious of them.’[11](javascript:footNote('E800004-001/note011.html'))


A singular account may be seen in the Paccata Hibernia, related by **Sir G. Carew** himself, of the attempt he made to assassinate the Sugan Earl, and his brother, by means of their friend Nugent. The plot failed, but it had the effect of sowing mistrust among the chieftains; and as they never retaliated 



---

p.92



on the Lord Deputy or Lord President, it became a received tactic in the warfare of those days.


And now came the triumph of power.


‘The multitude, (as **Sir J. Davis** informs us) being brayed, as it were in a mortar, with the sword, pestilence, and famine, altogether became admirers of the crown of England.’


‘No spectacle, says **Morrison**, was more frequent in the ditches of towns, and especially in wasted countries, than to see multitudes of these poor people dead, with their mouths all coloured green, by eating nettles, docks, and all things they could rend above ground.’


The very commanders, with some degree of inconsistency, had to hang a parcel of old women, convicted of being cannibals, after they had reduced them to the necessity of becoming so. At length **Sir Arthur Chichester** was eye witness to three children feeding upon the dead body of their mother; and some compunction seems to have arisen in the breasts of the English when they found nature outraged by the effect of their measures.


The Queen exclaimed, that she feared the same reproach might be made to her which was formerly made by Batto to Tiberius: ‘It is you, you that are to blame for these things, who have committed your flocks, not to shepherds, but to wolves.’




---

p.93


Even Lord Mountjoy, the author of this system of coercion, saw its folly and repented of it. In his letters to the English lords of council, he advises sincere and perfect forgiveness to be granted to the Irish, complete toleration of religion, and great tenderness and liberality, in treating with the old Irish chieftains.


So that after all the waste of life and money, Lord Mountjoy had not advanced a step, but now equally felt the necessity of those wise and conciliatory measures which, if adopted at first, would have made the war unnecessary.


The Lord Verulam, in a letter to Secretary Cecil, inculcates the same policy; and, with his usual good sense, objects to the too much letting of blood, (the panacea, so readily adopted by statesmen of cold hearts, and muddy understandings) and insists on the necessity of religious toleration.


It is quite terrible (and it is still more shocking that the observation should have become trite and common-place) how odious human nature appears in the recorded transactions of governments. There seem to have no humanity, not even good nature, and their errors seem to spring just as much from a spirit of oppression and revenge, as from folly. Elizabeth was certainly a highly gifted princess, yet if she had never been known but by her administration in Ireland, she might fairly have been 



---

p.94



ranked among the most oppressive and vindictive tyrants that have insulted the feelings and outraged the interests of mankind.


James I.
--------


If desolation can be called tranquillity, tranquillity was the effect of Elizabeth's measures; yet the state of peace which continued, with very trifling interruptions, during the whole reign of James, must, in justice, be ascribed to the policy of this prince himself. It is true he exasperated and encreased the new causes of rebellion, and some of the old; namely, those which arose from religion and confiscations; but at the same time, he removed the principal and most momentous spring of disturbance, by effectually reducing the power of the old Irish and old English chieftains. This, for the time, was the most material point; independence and liberty were well disciplined topics and well understood, which upon any favourable opportunity could move the whole island to arms; whereas the natives had yet to learn the more refined and metaphysical 



---

p.95



feelings, which bleed and fester from the endurance of distinctions and privations on account of religion. It is therefore no wonder, that although James, in fact, laid as sure a ground-work as any of his predecessors for *future* rebellions, his own reign was comparatively tranquil.


His first object was to destroy, not only the power but the very existence of the old Irish and old English chieftains, and this he accomplished with admirable wisdom. He espoused the cause of their oppressed subjects against their chieftains. He held out to them the blessing of equal law, of the inviolability of their persons, of the secure possession of their properties, and its descent to their children. He strengthened defective titles, and abolished all distinctions between English and Irish; ‘whereupon, says **Sir John Davis**, such comfort and security was bred in the hearts of all men, as ensured the calmest and most universal peace that ever was seen in Ireland.’ We do not think there can be a more delightful, a more glorious contemplation, than to see a nation, a whole people, rescued from ignorance, poverty, faction and war, and installed in all the blessings of knowledge, wealth and peace, by the operation of a single measure, and this after the same effect had been in vain attempted by force, and its necessary attendant, havoc.


This was perfected in Ireland by the too little celebrated Act of Oblivion, published by proclamation under the great seal; by this all offences against



---

p.96



the crown; and all particular trespasses between subject and subject, done at any time before his Majesty's reign, were pardoned; remitted; and utterly extinguished, never to be revived or called in question. And by the same proclamation all the Irish (who hitherto had been left under the tyranny of their lords and chieftains) were received into his Majesty's protection. The oppressive exactions of the Irish chieftains on their subjects, their bonnaught, their coyne, and livery, cuttings and cosherings, were abolished. Instead of granting to a chieftain, who surrendered his chiefry, the whole territory of the sept in perpetuity, as had hitherto been done; he was only allowed his patrimonial property, which was generally very small, and a compensation in money for the tributes, exactions, and services due to him. 


‘The common Irish were studiously instructed that they were free subjects to the kings of England, and not slaves or vassals to their respective chiefs; that the tributes and extortions exacted from them were not lawful, and that they should no longer pay them; they gave a willing ear to these lessons and therefore, says Davis, the greatness and power of these Irish lords over the people suddenly fell and vanished, when their oppressions and extortions were taken away, which did maintain their greatness, insomuch, as divers of them who formerly made themselves owners of all by force, were now, by the law, reduced to this point; that wanting means to defray their ordinary charges, they resorted to 



---

p.97



the Lord Deputy, and petitioned for a competent maintenance. But some of them being impatient of this diminution, fled out of the realm to foreign countries; whereupon we may well observe, that as extortion did banish the old English freeholder, who could not live but under the law, so the law did banish the Irish Lord, who could not live but by extortion.’


This enlarged policy, which destroyed the Irish chieftains, as if by magic—this system, at once so simple and so effectual, never entered into the contemplation of James's predecessors. When they seized on the possessions of a conquered chieftain, they confiscated also the whole property of his subjects; in order to win only a seeming dependance, and to procure a nominal surrender of his authority, they regranted to him not only his own lands, but the lands of all his subjects, leaving him in full possession of all his ancient tyranny, tribute and exactions. When they sought to destroy a chieftain, they raised up and supported a rival, by which they tacitly acknowledged the legality of those petty sovereigns—thus Queen Elizabeth had her O'Donnel, her O'Neil, her Maguire, her O'Reilly. Wherever they interfered, they made the condition of the Irish worse than before. They held the Irish in too much contempt to have any interest in their welfare; and this good effect at least arose from the desperate resistance made by the Irish against Elizabeth, that they gained a certain degree of respectability, which seemed to entitle them to the solicitude of government.



---

p.98



James rescued them from oppression, and raised them from the station of the slaves of petty despots, to the highest rank of men, free British subjects.


If a dog were treated with barbarity, one would feel an inclination to take his part. One cannot but pity the misfortunes of the Irish chieftains, and sometimes one must admire the virtues which those misfortunes called forth; one cannot but detest the mean perfidy, the rapacity and cruelty of their oppressors; yet as far as we can judge from the scanty annals of the country, they were the scourge of their own subjects, and Ireland stands deeply indebted to England for their overthrow.


James conferred a still greater benefit on Ireland the abolition of the Brehon laws of property.


After reading every account of Irish history, one great perplexity appears to remain: How does it happen, that from the first invasion of the English till the reign of James I. Ireland seems not to have made the smallest progress in civilization or wealth?


That it was divided into a number of small principalities, which waged constant war on each other; or that the appointment of the chieftains was elective, do not appear sufficient reasons, although these are the only ones assigned by those who have been at the trouble of considering the subject; neither are the confiscations of property quite sufficient to account 



---

p.99



for the effect; there have been great confiscations in other countries, and still they have flourished; the petty states of Greece were quite analogous to the chiefries (as they were called) in Ireland; and yet they seemed to flourish almost in proportion to their dissentions. Poland felt the bad effects of an elective monarchy more than any other country, and yet in point of civilization, it maintained a very respectable rank among the nations of Europe; but Ireland never, for an instant, made any progress in improvement till the reign of James I.


It is scarcely credible that in a climate like that of Ireland, and at a period so far advanced in civilization as the end of Elizabeth's reign, the greater part of the natives should go naked. Yet this is rendered certain by the testimony of an eye-witness, **Fynes Moryson**: ‘In the remote parts,’ he says, ‘where the English laws and manners are unknown, the very chief of the Irish, as well men as women, go naked in the winter time, only having their privy parts covered with a rag of linen, and their bodies with a loose mantle. This I speak of my own experience; yet remember that a Bohemian Baron, coming out of Scotland to us by the north parts of the wild Irish, told me in great earnestness, that he, coming to the house of O'Kane, a great lord amongst them, was met at the door by sixteen women all naked, excepting their loose mantles, whereof eight or ten were very fair, with which strange sight his eyes being dazzled, they led him



---

p.100



into the house, and then sitting down by the fire with crossed legs, like tailors, and so low as could not but offend chaste eyes, desired him to sit down with them. Soon after O'Kane, the lord of the country, came in all naked, except a loose mantle and shoes, which he put off as soon as he came in; and entertaining the Baron after his best manner in the Latin tongue, desired him to put off his apparel, which he thought to be a burthen to him, and to sit naked.’


‘To conclude, men and women at night going to sleep, lye thus naked in a round circle about the fire, with their feet towards it. They fold their heads and their upper parts in woollen mantles, first steeped in water to keep them warm; for they say that woollen cloth, wetted, preserves heat, (as linen, wetted, preserves cold) when the smoke of their bodies has warmed the woollen cloth.’


The cause of this extreme poverty, and of its long continuance, we must conclude, arose from the peculiar laws of property, which were in force under the Irish dynasties. These laws have been described by most writers as similar to the Kentish custom of gavel-kind, and indeed so little attention was paid to the subject, that were it not for the researches of **Sir J. Davis**, the knowledge of this singular usage would have been entirely lost.




---

p.101


The Brehon law of property, he *tells* us, was similar to the custom (as the English lawyers term it) of hodge podge. When any one of the sept died, his lands did not descend to his sons, but were divided among the whole sept; and for this purpose the chief of the sept, made a new division of the whole lands belonging to the sept, and gave every one his part according to seniority. So that no man had a property which could descend to his children; and even during his own life, his possession of any particular spot was quite uncertain, being liable to be constantly shuffled and changed by new partitions. The consequence of this was, that there was not a house of brick or stone among the Irish, down to the reign of Henry VII.; not even a garden or orchard, or well fenced or improved field, neither village or town, or in any respect the least provision for posterity.[12](javascript:footNote('E800004-001/note012.html')) This monstrous custom, so 



---

p.102



opposite to the natural feelings of mankind, was probably perpetuated by the policy of the chiefs. In the first place, the power of partitioning being lodged in their hands, made them the most absolute of tyrants, being the dispensers of their property, as well as of the liberty of their subjects. In the second place, it had the appearance of adding to the number of their savage armies, for where there was no improvement or tillage, war was pursued as an occupation.


In the early history of Ireland we find several instances of chieftains discountenancing tillage, and so late as Elizabeth's reign, **Moryson** says, that ‘Sir Neal Garve restrained his people from ploughing, that they might assist him to do any mischief.’[13](javascript:footNote('E800004-001/note013.html'))


If it were not foreign to our present purpose, we could wish to dwell longer on this subject; it is fertile in profitable contemplation to every Irishman; for at the same time that we would not let a fault pass uncensured in the vile system of government practised by the English in Ireland, we would still maintain its superiority over the barbarous tyrannies it displaced. We wish to repress the headlong and unmethodised desire for a separate and national government which pervades Ireland, and suggest a doubt whether modern chieftains would not be as liable to make as fatal errors in their civil code, as these which have been pointed out in the Brehon laws, and which Irishmen still attempt to extenuate and affect to admire. From the specimens left by 



---

p.103



the leaders of late rebellions, we have little doubt they would, and less doubt that the consequence would be a proportionate return to the degraded level of industry, morals, and manners, which, existed during the savage independence of Ireland.


James enforced the laws of England throughout Ireland, extended the protection of government to the lower orders, and secured every man in possession of his property. These measures at once put an end to the power of the Irish chieftains, and extinguished the immediate cause of rebellions.


James himself enjoyed a tranquil reign, but unfortunately for his successor, he created or inflamed other causes of rebellion, which proved more inveterate than the animosity of the old chieftains. These consisted in enormous confiscations of property; and a decided hostility commenced against the Roman Catholics.


Upon the flight of the Earls of Tyrone and Tyrconnel, 500,000 acres (which by the bye did not belong to them, but to their vassals) were confiscated; and to this cause may be fairly ascribed the share which Sir Phelim O'Neil took in the rebellion in the succeeding reign. However, to do James justice, he avoided several errors which had been committed in former distributions of confiscated lands. He included a large proportion of native Irish in the grants, and gave to none of the undertakers those large proportions which engendered 



---

p.104



petty despots, and gave them a consequence that disdained the controul of laws. James, as a planter, saw the expediency of toleration, and exempted his Roman Catholic tenants from taking the oath of supremacy.


Sixty-six thousand acres were seized on between the men of Arklow and the Slane; three hundred and eighty-five thousand acres in the counties of Leitrim, Longford, Westmeath, Leix and Offaly; and by regranting large proportions to the old inhabitants on permanent tenures, these measures were carried with apparent tranquillity. So far James seems to have been actuated by a colonizing Quixotism; and though his view of objects was false, his intention was liberal and good. But at the latter end of his reign he was gradually led from confiscating people's property for their interest, to confiscate for his own; and had recourse to an outrage which for its practical villainy, and its disastrous consequences, can scarcely be paralleled.


James's revenue in Ireland fell short sixteen thousand pounds per annum, in those days thought a terrible deficiency. To supply this he had recourse to the following device, which was aimed at the inhabitants of an entire province:


The Lords and gentlemen of Connaught, including the County of Clare, had surrendered their estates on composition to Elizabeth, but had neglected to take out the letters patent for the re-grant 



---

p.105



of them, as was the custom. This defect was supplied by James in his better days, who issued new patents for re-conveying their lands to them and their heirs. These patents received the great seal, but by neglect of the officers concerned, were not enrolled in chancery, although the proprietors had paid three thousand pounds for the enrolments.


Advantage was now taken of this involuntary omission. The titles were pronounced defective, and the lands vested in the crown. Though an act of state, during Lord Grandison's government, had declared the titles valid, though the wrong was evident, and the most pathetic remonstrances were made to the King, he would not retract, till the desperation of a province, inhabited by an active and spirited people, became alarming. Influenced by this fear, and his immediate necessities, James consented to sell a new confirmation of the patents, on consideration that the rents were to be doubled, and that a fine should be given him equivalent to the sum that was computed would arise from a new plantation of the province. To these hard terms the proprietors agreed.


Surely if to these reasons for discontent we add the regret which many of the chieftains or their heirs must have retained for their princely prerogatives, and that natural feeling which inspires one nation to resist the domination of another, a great part of the odium of the succeeding rebellion should in justice be removed from the supposed influence 



---

p.106



of the Catholic religion. Yet there is no doubt that this influence which, as we have seen, had but a very partial effect during Elizabeth's reign, took a very decided character at the latter end of James's life.


The point then, next to be considered, is whether this disaffection was a necessary consequence of the Catholic religion itself, or whether it was excited by the injuries inflicted on those who professed this religion.


The Roman Catholics of the Pale, and of the towns and cities, had fought Elizabeth's battles, and hitherto had considered the distinction of English and Irish as paramount to that of Protestant and Catholic. During the whole of Elizabeth's wars, the Catholics of the English Pale had always sided with the Protestants of the English Pale against the Irish enemy, though Catholics. Yet in return, they had been treated with considerable contumely as Catholics, and in consequence finding their religion made a mark to separate them from the English Protestants, that same religion became a common interest, which drew them to an union with their ancient enemies, the Catholics of Irish race.


On the accession of James, who had been known to have tampered with the court of Rome, they resumed the public exercise of their religion as a thing of course; but James, who had measures to keep with the puritans, and who was very tenacious 



---

p.107



of his ecclesiastical supremacy, prohibited the celebration of the mass. This was the first of those sad follies which sacrificed the interests of the fairest island in the world to the senseless visions of self-sufficient bigots. This was the first *insult* which made the most important part of the Catholics feel that they had a separate interest from the government.


The next step was still more brutal, and proportionably stupid. The Catholics were required to attend the Protestant churches. Upon their refusal, the magistrates and chief citizens of Dublin were fined and committed to prison. This spread a general feeling of anger among the Catholics, and an immense concourse presented a remonstrance against the illegality of the imprisonment, when the utmost severity of the law, obsolete from the time of its enactment, only authorised a fine; and at the same time, petitioned for the free exercise of their religion.


Unfortunately for that system of conciliation, which the vast importance, and hitherto known loyalty of the Catholics of English descent tended to suggest to James's counsellors, the news of the Gunpowder Plot was received on the very day this petition was presented; and though there appeared no reason afterwards to suppose any connection between the English and Irish Catholics, yet this coincidence was productive of every ill effect at the moment. The Irish government was alarmed, the chief petitioners were confined in the Castle of Dublin, 



---

p.108



and Sir Patrick Barnwell, their principal agent, was, by the King's command, sent prisoner into England.


But what contributed more, even than all these reasons, to alienate the minds of the Catholics of the Pale and of the towns, was, their removal from all places of trust and emolument.


To appreciate the effect which these measures had upon the minds of the Catholics, we must make ourselves familiar with their situation in these times, and judge of them from what they were then, not from what they are now. This point is very little understood. The Catholics of the Pale and towns had, at the beginning of James's reign, exactly the same habitual *ascendancy* over the mere Irish, which the Protestants have now over the Catholics. They occupied every situation of importance under government, all offices in the law, in the magistracy; they filled the ranks and officered the army; they had long been in the habit of considering the English government in Ireland as owing its existence to their courage, their loyalty, and not unfrequently to the assistance of their private fortunes. It had always been considered as a matter of course that their lords should be consulted on every important measure taken by government. So circumstanced, the character of the Catholics of those days was quite the reverse of what it was afterwards. Not habituated to degradation, their sense of honour was lively and resentful; above suspicion, their 



---

p.109



conduct was frank, manly, and in justification, bordered on defiance; their minds unbroken by adversity, and unsapped by the effeminancy of superstition, were liberal, enlarged, rich in the natural luxuriance of talent, and grateful to culture. The hereditary practice of arms had impressed upon them the best qualities of a soldier—moral and physical courage, disinterestedness and promptitude. We see in their conduct nothing paltry, wavering, or selfish.


We are not to imagine that because the Catholics long felt very little interest about their emancipation from degradation, that the Catholics then felt very little upon entering on it; on the contrary, just that degree of rage and indignation which the Irish Protestants spoiled by power, would now feel, if their churches were shut up, if they were compelled to go to mass, if they were declared incapable of holding any office of trust and emolument, if they were driven from the privy council; just that degree must the old English colonists have felt when, for the first time, discountenanced and persecuted by the government.


We omit to dwell upon the condemnation of Lalor, a poor popish ecclesiastic, whom government sought to dignify with a martyrdom; and upon the expulsion of the popish regulars from the kingdom; as far as direct insults could justify the resentment of the Roman Catholics, we have said enough. An indirect attack was made upon them, 



---

p.110



more fatal to their interests and to those of the country at large, which well merits our consideration, for we now pay the penalty for it:


James, finding it possible that there might be a majority of Roman Catholics in the House of Commons, *created a large number of boroughs* from towns so inconsiderable, that they and their representatives would be certain to be dependant on government. Here was accomplished the ruin of the Catholics; here was perpetuated the distraction of the country; here commenced the corruption of the constitution; this measure, to which the Protestants were base accessaries, has been visited upon their descendants with poetical justice, by the Union, which was effected by purchasing the corrupt owners of these identical rotten boroughs. To this measure the Catholics gave all the resistance which spirit and talents could prompt. In vain. A tyrant might have yielded from fear; a wise king would have retracted from conviction; but the obstinacy and conceit of a pedant were invincible.


Yet James had sense enough to stoop to conciliation when he had carried his point. No new measures were proposed against popery; the oath of supremacy was tacitly excused, and, when a bill was proposed by Sir Oliver St. John for keeping the fifth of November as a religious anniversary, it was silently got rid of.




---

p.111


A government may, with safety to itself, essentially infringe the interests of its subjects, if it has the condescension to manage their pride. This was exemplified in the case of James. Although he had prepared the ruin of the Catholics, yet as soon as he assumed a moderate tone and gentle usage towards them, they vied with the Protestants in expressions of loyalty, and, what was more substantial, in granting subsidies.


Thus stood the question of disaffection when James died: Among the lower ranks, there was a legendary record of English barbarities; the power of the old Irish, and of the old English chieftains, had been destroyed by the wisdom of James; yet, among these septs, there were many who valued the direct gratification of pride, afforded by princely consequence, to the indirect gratification of pride which is acquired through the medium of property: who preferred to be poor tanists, elected by their clan, rather than rich landlords dependant on law. The title of Monarch of Ireland was still cherished by the O'Neils, and that it was still allowed, at least by the northern Irish, is evident from the great power acquired by **Sir Phelim O'Neil**, in the great rebellion under Charles I. James's confiscations, but particularly the attack made on the titles of the province of Connaught, the practice known to be a favourite one with him, even to a systematical degree, kept men's minds in an uneasy state of suspense for what was to come, and rage for what had past.




---

p.112


The persecution of the Catholics had, for the first time, produced a resistance on the part of the old English Catholics of the Pale, hitherto the most efficient supporters of the English power; it had alienated their minds—it had detached their sympathy from the ancient object of their love, the English government; and gradually attached it to the ancient object of their detestation, the Irish enemy. That this was the effect, not of religion, but of the persecution of the religion, is clear. Had it been the effect of the religion it would have commenced in Henry VIII's time with the Reformation, which it did not; it would have been apparent in Edward VI.'s time, which it was not; it would have proved fatal to the English power in Elizabeth's wars; yet at that time there was little or no apprehension of it. But on the contrary, it did not exist before the persecution began; it originated with the persecution, and it grew and waxed strong, as the persecution encreased.




---

p.113


Charles I.
----------


We now approach a period of Irish history, when increased civilization gave a more distinct order, and a clearer light to the transactions of the times.


The records of these days are copious, and may be relied on with certainty; and this copiousness and certainty are entirely in favour of our argument.


We shall still pursue the same arrangement, pointing out the causes which generated rebellion, and distinguishing the effects produced by the injurious treatment of the professors of the Catholic religion, from the influence of the religion itself, until that influence being roused and exasperated by persecution, acquired a force from its continual struggles, which swept before it every obstacle of prejudice and reason, of oppression and law.


Independent of this new influence of religion, which now rapidly encreased, we are to consider, that many previous causes of discontent continued to exist. We are not to omit, the unappeased



---

p.114



hatred, which the Irish subjects bore to their English conquerors. The injuries done to individuals by confiscations and plantations, particularly those of Ulster. The regrets of the descendants of the Irish chieftains for the loss of their principalities, and the ever wakeful ambition of the house of O'Neil. The more effect these causes had in producing the succeeding rebellion, the less must be ascribed to the Catholic religion.


That these causes had a principal effect, and produced the rebellion of 1641, though they did not entirely supply its force, is very clear, from the following account of its commencement, extracted from **Leland**:
  

Roger Moor, was the head of that powerful family who had possessed the dynasty of Leix, now called the Queen's county. They were his ancestors, who in the reign of Mary, had been expelled from their princely possessions, by violence and fraud; the sept had been almost exterminated by military execution. Those that remained, were distinguished by an hereditary hatred of the English. In the progress of an obstinate contest, they had re-possessed themselves of a great part of the territories, and fought under the O'Moor, of Elizabeth's reign, with great resolution and perseverance, but were ultimately defeated, and again driven from their possessions.


Roger O'Moor possessed all the qualities of the heroic, character, talents, promptitude, courage, and love of his country; his person was remarkably



---

p.115



graceful, his aspect dignified, his manners courteous. The old Irish beheld the gallant representative of one of their kings with an extravagance of rapture and affection, and stimulated his spirit by the expectations they attached to him. It was a proverbial expression ‘Our dependence is on God, our Lady and Roger O'Moor.’ He was tenderly attached to young O'Neil, the son of the great Hugh O'Neil; with him he dwelt on the calamities of their fathers, their brave efforts in the cause of their countrymen, and the hopes of still reviving the ancient splendor of their families. With such interests to nerve his purpose, with such passions to fire his imagination, is there any necessity to suppose, that religious bigotry was his inducement, to devote himself to one brave effort for the independence of his country.


It was upon the same feelings he relied, for gaining associates; he spoke to the Ulster Irish, of the severities inflicted on them by Elizabeth, and of the plunder of their property by James.


To Mac Guire, whose father was chieftain of Fermanagh, he represented the ancient power and splendor of his family, pathetically lamented his present difficulties, and pointed bis anger against the English, who had despoiled the old and rightful possessors of the island, and planted a race of aliens and foreigners on their property. With the same representation he wrought upon Mac Mahon, Reily, 



---

p.116



Byrne,[14](javascript:footNote('E800004-001/note014.html')) Tyrlogh, and Phelim O'Neil, whose ancestors had, within a no very distant date, been possessed of sovereign power.


These were the men who planned, these the motives that urged and stimulated the country to rebellion; whatever access it afterwards received from different causes, these must be considered as the principal, from these, and these alone, it began; had these not existed, it is problematical, whether the rebellion itself would ever have existed.


Another material cause of the rebellion, which had no connection with religion, was Lord Stafford's resumption of the plan for confiscating the province of Connaught.


The unfortunate landed proprietors had already twice purchased their titles from the crown, yet Stafford did not hesitate to outrage every feeling of humanity, and every rule of justice, by subverting them a third time.


This transaction may not perhaps be the most infamous that ever occurred, but certainly the most infamous act of oppression, that was ever perpetrated by a plea of law, under the sanction of juries. It is uncomfortable to dwell on so abominable an outrage, it is sufficient to observe, that it was in part carried 



---

p.117



by violence, by fining the sheriffs, imprisoning jurors, and fining them to the amount of 4000l. each, by the terrors of Star Chamber, and the presence of the Lord Deputy; yet in the end, the haughty and intemperate spirit of Stafford was forced to bend to the tempest he himself had raised, and the apprehension of a rebellion put a stop to the project.


The king deduced his claim from an aera so distant as the reign of Henry the third, and when we consider that the attempt had now been thrice repeated, and that upon pretences equally antiquated, the property of the O'Byrnes in Wicklow had lately been confiscated; we must not be surprised, that none of the Irish, or old English, felt secure in their possessions.


Let us now consider, how far religion may be considered as a cause of the rebellion.


We have already seen that in James's reign the Catholic religion had assumed a very decided influence on men's minds; in Charles's reign, this continued to encrease; in both reigns it was adverse to the government. In James's reign, we proved, that this arose from the injuries sustained by the professors of that faith, not from the faith itself; let us see if there are any grounds to support the same conclusion during the reign of Charles.




---

p.118


The first important injustice which tended to alienate the minds of the Roman Catholics, was the perfidy of Charles, with regard to the celebrated **Graces**. The Catholics[15](javascript:footNote('E800004-001/note015.html')) had offered to pay one hundred and twenty thousand pounds for the enactment of certain laws, for the security of toleration, property, and equitable justice; the king accepted their offer, and gave his royal promise, that these laws should be passed. He took their money, and broke his word in the most cruel and insulting manner; and not one of these graces, though they were so reasonable and wise, that the monarch ought to have been obliged to the subject for suggesting them, was ever granted.


Thus, in addition to the indignation which the Catholics already felt, on account of the penal laws, was added, resentment for the loss of their money, and that bitter vexation, which is always felt by persons conscious of having been duped.


The Catholics felt this treatment more sensibly, because, from the supposed partiality of Charles, to the Popish religion, they had expected protection, countenance, and favour.


Charles, with that policy, at the same time ungenerous and fruitless, which is ever the resource of tottering power, sacrificed his friends, in hopes of 



---

p.119



appeasing his enemies. The new English and the Puritans in Ireland, were courted and advanced to every office of trust, while the old English, (mostly Catholics,) who had been in the habit of influencing every affair of moment, were driven from the court with every expression of contumely and contempt. The invidious fine on Catholics, for not frequenting Church on Sundays, was perpetually threatened to be imposed, and at length was made a source of revenue, and was commuted by Lord Stafford, for the sum of 20,000l. Still more unfortunately, Sir William Parsons was appointed Lord Chief Justice, and the Catholics could no longer entertain any doubt, but that the Puritans would acquire the same ascendancy in Ireland, which they had already done in England.


To calculate the impression which this conviction must have produced on the minds of Catholics, we ought to look back to the language held by the Puritans of those days, and the sentiments they avowed, when speaking of the Catholics; the insolence of political superiority intoxicated them, the pride of fanaticism hardened their hearts; their power was commensurate with their hate; with one hand they signed the law, with the other they raised the sword that was to exterminate the Papists, whom they called bloody.


All this time, while the English government prepared the ground, the court of Rome was industriously sowing the seeds of rebellion.




---

p.120


Jesuits and priests were sent from Spain and Rome, who knew how to turn these preposterous mistakes of government, to the best account; they knew how to enflame men's passions by their pride, how to mould their opinions by their interests, and how to urge religion to fanaticism, by the sharp incentive of injuries and insults. Hence the Catholic religion, which in Ireland had till now been characterised by a native mildness, a spirit of toleration, and a composure peculiar to old establishments, acquired an illiberal, enthusiastic, and sanguinary spirit.


Yet, so difficult is it even for oppression to eradicate from men's minds, the habits of loyalty and submission to government, that the religious principle appears to have had little influence in originating the rebellion. Even when the stronger feelings of injured interest, and outraged pride, had urged the native Irish to take up arms, the Catholics of the pale advanced forward in support of government. They were received with a severe suspicion, by the puritan chief justice; and instead of being as of old, looked up to as the solid support of government, (which probably would have made them continue so) a very scanty supply of arms was delivered to them. At length, on the progress of the rebellion, they were entirely deprived of arms.


This was the full measure of folly, and completed that series of insults and injuries, which 



---

p.121



broke the strong bands of habitual loyalty which had hitherto attached the Catholics of the pale to the English government, with a fidelity that had never been suspected through five successive reigns.


The Catholic lords and gentlemen of the pale, when their loyalty was made incompatible with their honour, reluctantly had recourse to resistance, and sooner than surrender their arms, turned them against the government.[16](javascript:footNote('E800004-001/note016.html'))


The Catholics of the pale hitherto the most determined enemies of the native Irish, now joined in their rebellion.


This is the event with which the train of our argument closes.


Before this it is impossible to call the rebellions of the Irish, Catholic rebellions, when they were in fact principally opposed by Catholics; but after this it would be idle to deny that Catholic bigotry had a very large share in exciting and prolonging the rebellions



---

p.122



in Ireland. That writer would be an injudicious defender of the Catholics, who should deny the fact; when perhaps there is not a more lamentable instance of the weakness of the human mind, when subservient to religious bigotry, than the absurdity and intemperance with which the Catholics acted when they surrendered their interests to the influence of the **Nuncio Ranuncini**, and in fact sold their country to the Pope.


But if it is certain that the Catholics became bigots and rebels, it is no less certain that their bigotry and rebellions arose entirely from the injuries and insults inflicted on them; and if we have made this clear so far, it is unnecessary to carry the argument further, as this persecution was *encreased* to a degree which future ages will scarcely believe, or believing, will wonder how it could be born.


To the Protestants these arguments are addressed, and if they have no other effect than to make them re-consider the *policy* of maintaining the present political inferiority of the Catholics, they will not have been urged in vain.


In our anxiety to produce conviction, we have already been guilty of too much repetition. Instead, therefore, of recapitulating our arguments, we will take a short view of the impolicy of continuing the present restrictions, and briefly state their practical effect.




---

p.123


We will not argue the question of right. In this age of mere mercantile feelings, to speak from the heart, is not to speak to the head; we must prove the Catholic restrictions to be a losing speculation, or we prove nothing.


At this present moment, the whole soul of England is bent on reducing the power of the French within reasonable bounds. For this they are profuse of their blood, and their very means of subsistence; yet to this they will not sacrifice their bigotry. If England had possessed any day these last three months, a disposable army of 60,000 men, to act on the continent; she might have struck a decisive blow; she might have destroyed Boulogne, she might easily have become mistress of Italy; or she might have hung upon the whole line of French dominion, and held those armies in suspense, which now pour into Poland with such uninterrupted celerity. Yet double this force might have been raised in Ireland, if the minds of its inhabitants had been conciliated by a constitutional grant of civil and religious freedom.


At present, the Roman Catholic peasantry enlist with the greatest reluctance, because government sets their religious faith, and their military duty, at variance, and the circumstance of there being no Catholic officers in the army, destroys that inclination 



---

p.124



to enlist, which always arises from serving under officers of the same sect as themselves. The same injudicious intolerance makes the *peasantry* disaffected; what follows: you cannot trust in the militia, for they are Catholics. The yeomanry are too few in numbers; and as they, from the same infection of intolerance, are partisans, in calling in their aid, you run the risk of exciting a civil war.


You are forced then, in order to prevent the bad effects of your system of government, to bring an army from England. Then comes the fear of invasion, and your difficulties multiply an hundred fold. You want an additional army to keep down the peasantry, you want an army to awe the militia, you want an army to restrain the intemperate zeal of the yeomanry, you want an army to oppose the enemy. This is no very inaccurate statement of the military necessities of the English government in Ireland, which arise entirely from the want of wisdom in their political measures. An army without any facility of recruiting; a people for your enemy; a militia that you place no confidence in; a yeomanry whose very assistance is accompanied with the risk of injuring you; and a foreign enemy, ready to take the first opportunity of turning your mistakes to his own profit.




---

p.125


But for a moment reverse your measures; treat the Protestants and Catholics without any discrimination, assuage the wounded pride of the country, by some modification of the union, and the hearts of the Irish, naturally loyal and affectionate, will yield with delight to the sentiments of zeal and duty towards the government.


Who, that sympathised in the expansion of honest gratulation which broke forth on the Duke of Bedford's arrival in Ireland, can doubt it!


What would be the effect, the yeomanry strengthened by the accession of all the wealthy, and more respectable Catholics, and without any apprehension of internal insurrection, would be quite sufficient to defend the country from any sudden invasion, on a small scale. The militia might be sent on foreign service, together with the English army, at present locked up in Ireland, or kept in England from the apprehension of danger in Ireland.


The recruiting service, assisted with the influence of Catholic officers, would go on with rapidity, and produce an annual supply, far beyond what is imagined. By these means, an army of at least 60,000 men might be made disposable, and be brought to act against the most vulnerable parts of the French empire, let its losses be ever so great, the means of recruiting it would be nearly inexhaustible; and it is no great presumption, after what we have seen 



---

p.126



done by a combined army of Irish and English at Egypt, and at Maida, to say, that it would consist of the bravest, and most formidable troops in, Europe.


To this desirable and decisive increase in national strength, there is but the one obstacle, a kind of nursery terror of the Pope, which still clings to our maturer reason.


It is by the extreme of this terror that our opponents are blinded, or they would perceive that we have the same object in view with them, only that we pursue it by very different means.


They wish to secure the forfeited properties to their present owners; so do we. They wish to put an end to Catholic rebellions; so do we. They wish to curb the bigotry and intolerance of the Catholic religion; so do we. What means have they adopted to effect this purpose, and have they succeeded? No. Why then should you be so averse to try an opposite mode of proceeding?


You were possessed of every instrument of influence, of restriction, of terror, and you made ample use of them; yet the Roman Catholics, like the Israelites of old, multiplied under the oppression of their task-masters. If interest has failed to gain one single convert from the most corrupt of the Roman Catholics, the desire of political importance from the most ambitious, fear from the most timid, certainly 



---

p.127



the severe and disqualifying system is radically wrong. On the contrary, it has become a received axiom in modern policy, that sects gain force and numbers by being stigmatized and oppressed, but by being assimilated and adopted by government, their union is relaxed, and their numbers diminished. **Voltaire** was a deist, his testimony must, therefore, be considered as impartial; Mrs. Barbauld is a dissenter, her evidence is the confession of an enemy.[17](javascript:footNote('E800004-001/note017.html')) Both agree that sects only flourish from the distinctive marks and disqualifications which governments attach to them, because no honourable man would quit a discountenanced sect, as his desertion would not be supposed to arise from a change of opinion, but from motives of fear or mean interestedness. But when nothing is lost by remaining attached to a sect, and nothing gained by quitting it, its adherents will listen to persuasion, or will yield to fashion, and will naturally adopt that form of religion which is most consonant to truth, or most suitable to the manners of the world.


In this age when scepticism is affected as a mark of talents, and religious policy enters very little into the usual intercourse of the world, even the Protestant religion, divested of many aukward articles of faith, and of all the rigour of church discipline, is lamentably on the decline. We cannot suppose that the doctrines and ceremonies of the Catholic religion 



---

p.128



are more consonant with reason, or more agreeable to the strong impulse of manners; surely, then, its flourishing state must be the effect of the political causes to which it is subjected; of that irritation which prevents indifference; of those distinctions which make adherence amenable to public opinion; of those privations which make apostacy base.


The present union and formidable dimension of the Catholic body, arise from the injudicious repulsion of government; as a political party, they could never hold together merely by their own weak attraction.


What can be a stronger proof of the truth of this reasoning, than the fluctuation of religious zeal in France. The Roman Catholic religion had there been long established under the monarchy, and had gradually dwindled into a mere state ceremonial. Persecuted, during the violence of the revolution, it recovered the enthusiasm of primitive Christianity; tolerated under the consulate, its zeal abated. Once more established under the imperial house, it has ceased to be an object of interest, and the churches are once more abandoned.[18](javascript:footNote('E800004-001/note018.html'))


It is not from the efforts of the established church, from its charter-schools, and the aid of penal laws, that the Catholics have any reason to apprehend a diminution of numbers, but from a *sect,* and that 



---

p.129



sect the methodists. A very obvious fact will sometimes remain unnoticed, and yet when once pointed out, will be generally acknowledged. This we imagine to be the case with the hitherto unnoticed progress the Methodists are making in Ireland against the Roman Catholic religion. Their eloquence, their zeal, and astonishing industry in employing the most minute means to propagate their tenets; above all the judicious use they make of the power of the press, has produced an impression which has evidently alarmed the Catholic priesthood. We are very doubtful whether it is an event to be wished: whether the Catholic religion is not better adapted to the cheerful temper of the Irish peasantry, than the proud and sullen spirit of methodism; yet we have not the least doubt, that if the Catholic clergy were paid by government, and if the practice and principle of religious restrictions were abandoned, in the course of a few years, a very large portion of the Irish peasantry would be converted to methodism.


At present, the methodists only succeed in cutting off supplies from the established church, and have reduced it to an insignificance, which, compared with its revenues, is quite ridiculous.


What then, in the name of consistency, can make the enemies of popery so violent in their opposition to the only measures which can check the influence of the Catholic religion? That which will ever make the opinion of the multitude an absurd one, 



---

p.130



on abstruse subjects; the want of capacity and inclination to examine farther than the *apparent* effects of circumstances; which makes them believe, that scarcity is the effect of regrators and monopolists; that protecting duties bring home-manufactories to perfection; that the sun revolves round the earth, or any error which it requires a *chain* of reasoning to refute.


But whence can arise the Opposition of government to the emancipation of the Catholics? are we seriously to be referred to his Majesty's coronation oath, to his Majesty's scruples of conscience!


There is at least as much truth in the maxim that the King never dies, as that the King can do no wrong; and if the former means any thing, it is that the constitution solely regards the King in a political, never in a personal light: his life is a political life, and knows no dissolution; his acts are considered only as acts of state, for which, not the King, but ministers are responsible; his oath is not his own personally, he is not responsible even for its violation, but his ministers are; it is an act of state, it is a pledge given to the legislature; the performance of which they only can exact, they only can remit, and which an act of theirs clearly *can* remit.


There has been of late years, a great, an alarming, and a treasonable inroad made upon the constitution, by a set of men, who perpetually introduce 



---

p.131



the idea of the King's personality; of which the wisdom of our constitution has foreseen the danger, and has guarded against it with the most anxious care. For, if that fatal hour shall ever come when the King of England shall be the leader of a party —when he shall be nominally King, and virtually minister—when to the prerogative of the veto, he shall add the power of the initiative—that sacred fiction, that the King can do no wrong, will gradually disappear before the force of imperious circumstances, and responsibility will gradually attach itself to the idea and the person of the King.


This revolution we believe to be far, very far distant; nor are we of that class of alarmists who instantly believe the existence of whatever they apprehend. But foreseeing the calamities that would flow from such a change, we cannot think ourselves too anxious in protesting against the too frequent introduction of the idea of the King's private feelings and interference on great political questions.


We shall, therefore, with more decency and more in the spirit of the constitution, consider only the scruples of conscience which may arise in the breasts of his Majesty's ministers, or the two houses of Parliament, from any inconsistency between the coronation oath, and the repeal of the restrictions on the Roman Catholics.




---

p.132


There appears nothing in the literal sense of the oath hostile to the removal of any religious disqualifications imposed upon any sect, when they are found to be detrimental to the empire. But as words may be construed into almost any meaning, we will not stand upon these grounds; but suppose that Catholic emancipation is inconsistent with the tenor of the coronation oath.


We will now ask, can any obligation, any oath be valid in the eye of religion and morality, which is grounded on a violation of an engagement more solemn and sacred? There can be no doubt of the reply: Certainly not.


Then we ask, how can the government plead the coronation oath to perpetuate measures that were enacted in violation of the solemn treaty of Limerick?


That treaty remains a monument of the most flagrant perfidy that ever disgraced a nation; upon the faith of it, the Irish Catholics gave up that power and influence, which you neither will, nor can restore to them. And till that treaty is fulfilled in its most liberal sense, no ingenuity can remove the stain of deliberate perjury from the character of the English nation.


Surely it is a conscience which will strain at gnats and yet swallow camels, which stickles for an oath of ceremony, doubtful even in the meaning, of the 



---

p.133



animus imponentis; and yet will be content to violate a compact so important as the treaty of Limerick, for which you have received your consideration, and on which millions rested their confidence and their interests.


Surely, the conscience of ministers might be affected by the violation of those pledges given to the Catholics at the time of the Union, (it signifies not whether expressed or implied) surely they might feel compunction at betraying a nation to dishonour, and then with-holding from her the paltry recompense that bribed her to her disgrace.


The men who perpetuate a crime, commit it; and as long as the present or any ministry continue the restrictions on the Irish Roman Catholics, they are deeply responsible for a gross and dishonoraole breach of common faith and honesty. It is in vain they attempt to shelter themselves under the plea of the King's personal feelings. It will not be readily supposed that his Majesty, whose principal glory will hereafter rest on the repeal he has made of the severer penal statutes in Ireland, who has seen the happiest effects, in promoting wealth, and the security of property, flow from that repeal, it will not be readily supposed that he can be actuated by the illiberal spirit which his self-named friends, but real enemies, charge to his account.[19](javascript:footNote('E800004-001/note019.html'))




---

p.134


Though we are not inclined in general to violent measures, yet we think that impeachment and imprisonment in the Tower, would be too gentle a punishment for those secret advisers who have not only unhinged the most delicate springs of the constitution to serve their private views, but have done their best to cast obloquy and contempt on the name of the King—a name which ought never to be compromised on any topic whatever—ought never to be exposed to the common handling of public disquisition.


With what flagrant and impudent misrepresentations must these men have poisoned the King's ear, if they have succeeded in making him perversely hostile to the Irish Roman Catholics—a body of men who (let Protestant bigots say what they will) have the strongest devotion and attachment not only to his Majesty's political, but to his personal character, and who would set a value on his Majesty's countenance and favour, only inferior to that which they would attach to the benignity of their God.[20](javascript:footNote('E800004-001/note020.html'))




---

p.135


We are anxious before we conclude, to give the public the means to form a just estimate of the hardship of the privations which the Irish Catholics experience, the extent of which is not generally understood, and from the supposed insignificance of which, an argument is sometimes drawn against their repeal.


The Catholics, by being excluded from all offices of trust and emolument, lose all political consequence in the country; so that a Protestant of seven hundred a year is more looked up to than a Catholic of seven thousand a year.


By being excluded from sitting in Parliament, they are deprived of the most precious and most effective guarantee of civil liberty.


This disqualification, in fact, shuts them out from the subordinate offices which the law permits them to hold; for all these are placed more or less at the disposal of the Irish members of Parliament, in order to secure their attachment to ministers.


Thus Catholics, through the greater part of Ireland, are still virtually excluded from the offices of Justice of Peace, and Grand Juror; and where they are admitted, it is because they have a sufficient 



---

p.136



number of votes to be an object to the county member.


A gentleman's consequence in Ireland consists very much at present in being a Justice of the Peace, a Grand Juror, and a Captain of a yeoman corps. From these situations the Catholics are, for the most part, in fact excluded, and in consequence exist in a very painful degree of insignificance.


From the same cause the middling class of Roman Catholics are excluded from the very desirable employments of the revenue, the excise, and all petty municipal offices. So complete is the monopoly of civil employments in Ireland, that to be a Protestant is almost sufficient to be secure of a competence.


But the Catholics may have recourse to trade. It is true; but under great comparative disadvantages. They are excluded from all corporations, and are debarred by law from being Directors of the Bank.


It is very plain that this oppressive restriction, subversive of the freedom of trade as well as of civil liberty, must have a very pernicious effect on the industry of the Catholics; and if Catholic tradesmen and artizans should be found more addicted to idle and irregular habits than the Protestants, it may fairly be ascribed to this very intelligible cause, rather than to the nature of their religion.




---

p.137


Another immediate injury, which the present penal statutes inflict on the Catholics, is a great insecurity of property and person, and extreme uncertainty of redress from the laws of their country.


Catholics cannot be Sheriffs, or Sub-sheriffs; Juries are of course Protestant, and on any trial, where party feelings can interfere, a Catholic is generally judged unfairly.


It is grown into a proverb among the common people in Ireland, that there is no law for a Catholic.


But a still more vexatious train of injuries flow from the influence which these penal statutes have in forming habits and opinions inimical to the Catholics.


Government in fact, is the great leader of the ton, and its caprices and absurdities are adopted by the public, with all the rage and servility of fashion.


The English government manifest by their tenaciousness of the penal laws, that they mistrust and dislike the Catholics.


First come the Bank Directors of Ireland, who, not having the good sense to feel, that as their profession is naturally sordid and selfish, it ought to be counteracted by liberality of sentiment, pass a law, 



---

p.138



that no Catholic shall be employed in any office belonging to the Bank, the number of which is very considerable.


Protestant families will not in general take Catholic servants, every news-paper contains advertisements for servants; signifying, that they must not be Catholics.


In yeoman corps, with very few exceptions, no Catholics are admitted.


Upon the last rebellion, the principal Roman Catholics in Dublin, were anxious to enrol themselves in yeoman corps; they were black-beaned to a man, by the merchant's corps, and in general by all others, and were only admitted into the lawyer's corps.


In the country corps of yeomanry, the bigotry of the captains generally excludes Catholics, and even when the captains would wish, for the appearance of their corps, to mix a few stout comely Catholics in it, the bigotry of the privates interferes to prevent it; as in most instances, they would resign to a man, if such a measure was persisted in.


In many towns of Ireland, there are convivial societies, among whom it is a rule to exclude all Catholics.




---

p.139


In many counties, Protestants will not visit a Catholic, and it is the fashion to speak of them in the most injurious and degrading terms.


Yet the Irish Protestants are not so much to be blamed for these ridiculous and disgraceful habits of domestic dissention; they suffered in fact much by a rebellion which they imagined sprung from Catholic bigotry. They suffered still more in apprehension.


They were too much under the influence of alarm to enquire calmly into the causes of the insurrection, or to consider that a popular commotion, excited by contumely, could not be appeased by a continuance of injurious usage.


But the British cabinet, safe and at a distance, cannot reasonably urge the danger of the present moment, as an excuse for continuing a system of insult towards the Catholics, blind to all its future consequences.


We may disapprove, yet we may still view with some scruples of allowance, the institution of Orange Lodges, those great political blunders of the Protestant gentry. But the government cannot be excused for countenancing the public celebration of the 1st, and 12th of July, and the 4th of November; which every year give rise to the most fatal outrages on the part of the Protestants; which are notoriously 



---

p.140



intended by the one party, and felt by the other, as a parade of insulting domination.


It requires no great spirit of prophecy to foretel, that if the English cabinet go on preparing every year, more materials for a civil war in Ireland, the public celebration of one of those days, will afford the trifling cause, the little spark, which is ever wanting to make the train of mischief explode.[21](javascript:footNote('E800004-001/note021.html'))


Will the English cabinet never perceive the important circumstances on which all political events are now turning?


Will they not open their eyes to that incalculable encrease of personal pride, which has taken place in the British islands?


Can they not see that every effort of modern habits, is directed to the gratification of pride and vanity; and to secure, under some shape or other, the esteem and regard of society?


Will they never abandon those Scotch principles of policy, which only regard the vulgar interests of men, and neglect the feelings of the human mind, to which the strongest interest is after all entirely subservient?




---

p.141


Of what value is wealth, and all the principles of economy on which it is supported, but as it assists the gratification of personal pride.


What kind of policy then is this, which would scruple to plunder the Roman Catholics of their wealth, which is of no value, but as a means to gratify their personal pride, and yet will not hesitate to make a direct attack on that personal pride in its most delicate and most irritable organs?


If there is a political maxim established by experience, it is, that it is safer to injure men in their interests, than to wound their pride.


The most disagreeable circumstances which the Catholics are exposed to, are these testimonies of contempt inflicted on them by their fellow-countrymen, which would not take place, did not the government of the country declare the Catholics to have forfeited its sympathy, and to be unworthy of its confidence.


You may say, that this want of confidence is merely nominal, that government in fact, places as much confidence in Catholic soldiers and sailors, as in Protestants.


Allow, (which is not the case,) that this want of confidence is merely nominal, still when a government calls names, whether good or bad, they become in fact, very grave realities. 




---

p.142


Government calls a man a lord. This is only a name; but do not the most substantial effects of consequence and superiority flow from it?


But the reverse of any proposition that is true, is true also in the reverse; and if government, by attaching nominal honours to men, really invests them with superiority and grandeur; so by attaching nominal dishonours to men, it stamps upon them inferiority and disgrace.


It is not, therefore, for the sake of political emoluments alone, (though these are fair objects of honorable ambition) it is not merely to represent the insignificance of their country in parliament, that the Catholics look for an equality with the Protestants; this is not the emancipation which informs them with one soul, one interest, one purpose; what they may not, what they will not resign, is an emancipation from national contempt, from public ignominy, from domestic depredation.


A Catholic suffers the three most poignant feelings, that can touch the human heart.


The government of his country passes a vote of censure on him.


His fellow-citizen expresses his contempt for him, and expresses it with impunity.




---

p.143


The child of his affection blushes for him, and mourns for himself, when he learns that he necessarily inherits from his father a blot and a reproach, which no private virtues, or mental endowments, can obliterate or conceal.


How can we torture with this refined barbarity?


Do not we shrink back at the sight of a limb being cut off, and feel it in our own marrow Can we not feel, because the sufferer is a Catholic?


O hearts of barbarians, of zealots, of Protestants! the flames which made the name of Bonner accursed: the hideous night of St. Bartholomew are not so great a disgrace to the character of man, as your cold contriving bigotry.


They at least had the excuse, the varnish of religious feeling; they sprung not from selfishness, but from a visitation of fanaticism, as inscrutible as physical insanity. These men merely made a mistake; they worshipped a demon, and thought him God.


But you, with perfect possession of your faculties, with a calm pulse, and minds unaffected by the slightest emotion, perpetuate statutes, to gall the best and most honourable feelings of many millions of men, whose sensations of pleasure and pain are exactly of the same nature with those from which your own happiness or misery is derived.




---

p.144


The Catholics can feel; and do suffer.


The very peasantry acutely feel the stigma cast by government upon their sect and their religion. The lowest order even suffer most. The wealthy Catholics acquire a degree of consideration and legal security from their property, but the peasantry are left naked to the pelting of the storm, to all the jibes and jobs of Protestant ascendancy.


Not only a Protestant lord looks down upon a Catholic lord, and a Protestant gentleman on a Catholic gentleman, but a Protestant peasant on a Catholic peasant; and in proportion as the degrading scale descends, the expression of contempt becomes more marked and gross.


Now, let any man say, can such disqualifications be perpetuated with justice or humanity; or can they be born with patience?


Can we then find too strong terms to expose to Europe, every where else enlightened and liberal, the dull and malignant conduct of the Irish and English Protestants.


Can we find words to express our astonishment, that the English cabinet should become an echo, not to ravings of Bedlam, but to a cento of every thing that is gross, vulgar, and perverse; Dublin guilds, common council-men, aldermen, corporations; fat fools, that have been hitherto non-descripts 



---

p.145



in the classes of science, literature, and good sense.


Can we too warmly deprecate the disingenuousness with which every variety of rebellion in Ireland is attributed to the Catholic religion, without ever taking into consideration, the injustice with which the professors of that religion have been treated?


The Protestants, in their terror of persecution, have become persecutors; their alarm at Catholic atrocities, has made them atrocious; to hear them speak, one would imagine that they had been the patient and uncomplaining sufferers, from the reign of William till George the Third; that they had born this long and cruel test of loyal resignation; that they had been deprived of property, of arms, of every legal and honourable right.


No, it is not suffering, but it is power, it is the pride of artificial ascendancy, it is the jealousy of exclusive privilege, that corrupts the understanding, and hardens the heart.


The ridicule of this outcry, which the Protestants make against the Catholics, at the very time they oppress them; and indeed our whole train of argument, cannot be better illustrated, than by an old fable and moral, which we make no apology for delivering in the very words of Sir R. L'Estrange.




---

p.146



> 
> As a Wolf was lapping at the *head* of a fountain, he spied a Lamb paddling at the same time, a good way off *down* the stream. The Wolf had no sooner the prey in his eye, but away he runs open mouthed to it. ‘Villain, says he, how dare you lie muddling the water that I am drinking?’
> 
> 
> ‘Indeed, says the poor Lamb, I did not think that my drinking here *below*, could have fouled your water so far above.’
> 
> 
> ‘Nay, says the other, you will never leave your chopping of logic, till your skin's turned over your ears, as your father's was a matter of six months ago, for prating at this saucy rate. You remember it full well, sirrah.’
> 
> 
> ‘If you will believe me, Sir, quoth the innocent lamb, with fear, and trembling, I was not come into the world then.’
> 
> 
> ‘Why, how now then, Impudence, cries the Wolf, hast thou neither shame nor conscience *but it runs in the blood of your whole race, sirrah, to hate our family,* and therefore, since fortune has brought us together so conveniently, you shall e'en pay some of your fore-fathers scores, before you and I part; so without any more ado, he leapt at the throat' of the miserable helpless lamb, and tore him to pieces.’
> 
> 
> 






---

p.147


MORAL


‘Pride and cruelty never want a pretence to oppress; the plea of not guilty goes for nothing against power; for accusing is proving, where malice and force are joined in the prosecution.’


‘When innocence is to be oppressed by might, arguments are foolish things; nay the very merits of the person accused, are improved to his condemnation. The Lamb itself shall be made malicious.’


‘And what is this now, but the lively image of a perverse reason of state, set up in opposition to truth and justice, but under the august name and pretence of both. As loyalty, for the purpose, shall be called rebellion; decency of religious worship shall be made superstition; tenderness of conscience shall be called fanaticism, singularity, and faction.’


‘The cause of the innocent must be remitted at last to that great and final decision, where there is no place for passion, partiality, or error, But as to the business of this world, when Lambs are the accused, and Wolves the judges, the injured must expect no better quarter; especially when the heart's blood of the one is the nourishment and entertainment of the other.’


FINIS.













