

#An account of Philaretus during his Minority


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


An account of Philaretus during his Minority
============================================


Author: Robert Boyle
--------------------


### File Description

Thomas BirchFunded by University College, Cork and  
School of HistoryElectronic edition compiled by Beatrix Färber

 1. First draft, revised and corrected.Extent of text: 20847 words#### Publication


CELT: Corpus of Electronic Texts: a project of the History Department, University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2011) (2013) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E650001-100Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript source**2. London, Royal Society, RB/1/37/39. [Thanks to Library Manager Rupert Baker from the Royal Society for this information.]
**Editions and select bibliography**2. Thomas Birch (ed): see details below. A photomechanical reprint of his edition was published in 1966 by Olms.
3. Eustace Budgell (ed), Memoirs of the life and character of the late earl of Orrery and of the Boyles (London 1732; the third edition was published as 'Memoirs of the lives and characters of the illustrious family of the Boyles', London 1737).
4. R. E. W. Maddison, Studies in the Life of Robert Boyle F.R.S.; Part 1: Robert Boyle and some of his foreign visitors, Notes and Records of the Royal Society of London, vol. 9 no. 1, Ocober 1951, 1–35, esp. 22–29.
5. G. H. Turnbull, 'Samuel Hartlib's Influence on the Early History of the Royal Society', in: Notes and Records of the Royal Society of London, 10/2 (April 1953) 101–130.
6. Roger Pilkington, Robert Boyle : father of chemistry (London: J. Murray 1959).
7. Anna Maria Crinò, Un principe di Toscana in Inghilterra e in Irlanda nel 1669 (Roma: Edizioni di storia e letteratura 1968) (esp. 119–121: A visit to Robert Boyle].
8. Nicholas Canny, The upstart earl. A study of the social and mental world of Richard Boyle first earl of Cork 1566–1643. (Cambridge: Cambridge University Press, 1982).
9. Rose-Mary Sargent, 'Robert Boyle's Baconian Inheritance', Studies in History and Philosophy of Science 17 (1986) 469–86.
10. Rose-Mary Sargent, The diffident naturalist: Robert Boyle and the philosophy of experiment. (Chicago: University of Chicago Press, 1995).
11. Peter R. Anstey, The philosophy of Robert Boyle. (London; New York: Routledge, 2000).
12. Michael Hunter and Edward B. Davis (eds), The Works of Robert Boyle (London 1999–2000).
13. Michael Hunter, Antonio Clericuzio and Lawrence M. Principe (eds), The Correspondence of Robert Boyle, 1636–1691. (London; Brookfield, VT: Pickering & Chatto, 2001).
14. Hiro Hirai, 'Anatomizing the Sceptical Chymist: Robert Boyle and the Secret of his Early Sources on the Growth of Metals', Early Science and Medicine 10:4 (2005) 453–477.
15. Michael Hunter, Boyle: between God and science. (New Haven: Yale University Press, 2009).
16. For a full bibliography see the website of the Robert Boyle Project at http://www.bbk.ac.uk/boyle/researchers/boyle\_bibliography.htm.
**Internet resources**2. The Robert Boyle Project based at Birkbeck College, University of London, directed by Professor Michael Hunter, has an extensive website at http://www.bbk.ac.uk/boyle/ where a selection of the Boyle papers can be viewed online.
3. The Waterford County Library webpages on Robert Boyle at http://www.waterfordcountylibrary.ie/localstudies/waterfordscientists/robertboyle1627-1691/.
4. The Royal Society Libary (http://royalsociety.ac.uk/library/) holds Robert Boyle's manuscripts.
**The edition used in the digital edition**2. **Thomas Birch**, An account of Philaretus during his Minority in The works of the Honourable Robert Boyle, in five volumes; to which is prefixed the life of the author [...]. , London, Printed for A. Millar, opposite Catharine-Street, in the Strand (1744) volume 1 page 6–25

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 6–25 of volume 1.


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed.


##### Normalization


The electronic text represents the edited text. The spelling has been left as it was; however a number of minor modifications have been made to punctuation; these are marked. Text supplied by the editor is marked sup resp="TBi". The editor's notes have been incorporated. Some further explanatory notes (marked resp="BF") have been added by the CELT editor. A selection of personal names and dates are tagged. Encoding is subject to revision.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the document. div1=the section. Section 1 covers Robert Boyle's autobiography, section 2 the biography compiled by Thomas Birch. Page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Dates are tagged. A selection of personal names and place-names are encoded.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: Section 1 by Robert Boyle; section 2 by Thomas Birch
 Date range: c.1648–1649; c.1743.#### Use of language


##### Language: [EN] The text is in seventeenth-century English, edited by an eighteenth-century editor.


##### Language: [FR] Some words and phrases are in French.


##### Language: [LA] Some words and phrases are in Latin.


### Revision History


* (2014-09-19, 2014-10-31) Beatrix Färber (ed.)

* Items added to bibliographical details.
* (2013-12-07) Beatrix Färber (ed.)

* More names encoding added, new wordcount made, file reparsed.
* (2012-05-23) Beatrix Färber (ed.)

* Addition made to bibliographic details; header modified.
* (2011-03-31) Beatrix Färber (ed.)

* File proofed (2); SGML and HTML file created.
* (2011-03-30) Beatrix Färber (ed.)

* TEI header created; file parsed.
* (2011-03-26) Beatrix Färber (ed.)

* File proofed (1); structural and content encoding applied; notes added.
* (2011-03-23) Gunnar Bonneß (text capture)

* Text scanned in.




---


#### Corpus of Electronic Texts Edition: E650001-100


### An account of Philaretus during his Minority: Author: Robert Boyle




---

p.6


An Account of Philaretus, *[i. e. Mr. R. Boyle,]* during his Minority
---------------------------------------------------------------------


Not needlessly to confound the herald with the historian, and begin a relation by a pedigree, I shall content myself to inform you, that the immediate parents of our **Philaretus** were, of the female sex, *[Catharine, daughter of Sir Geoffry Fenton]* a woman, that wanted not beauty, and was rich in virtue, and on the father's side, that **Richard Boyle, earl of **Corke****, who, by God's blessing on his prosperous industry, from very inconsiderable beginnings, built so plentiful and so eminent a fortune, that his prosperity has found many admirers, but few parallels.


He was born the 14th child of his father (of which five women, and four men, do yet survive) in the year 1626–7, upon St. Paul's conversion day[1](javascript:footNote('E650001-100/note001.html')), at a country-house of his father's, called **Lismore**, then one of the noblest seats and greatest ornaments of the province of **Munster**, in which it stood; but now so ruined by the sad fate of war, that it serves only for an instance and a lecture of the instability of that happiness, that is built upon the uncertain possession of such fleeting goods, as itself was.


To be such parents' son, and not their eldest, was a happiness, that our Philaretus would mention with great expressions of gratitude; his birth so suiting his inclinations and designs; that, had he been permitted an election, his choice would scarce have altered God's assignment. For as on the one side, a lower birth would have too much exposed him to the inconveniences of a mean descent, which are too notorious to need specifying; so on the other side, to a person, whose humour indisposes him to the distracting hurry of the world, the being born heir to a great family is but a glittering kind of slavery, whilst obliging him to a public entangled course of life, to support the credit of his family, and tying him from satisfying his dearest inclinations, it often forces him to build the advantages of his house upon the ruins of his own contentment.


A man of mean extraction is seldom admitted to the privacy and secrets of great ones promiscuously, and scarce dares pretend to it, for fear of being censured saucy, or an intruder; and titular greatness is ever an impediment to the knowledge of many retired truths, that cannot be attained without familiarity with meaner persons, and such other condescentions, as fond opinion, in great men, disapproves and makes disgraceful.


But now our Philaretus was born in a condition, that neither was high enough to prove a temptation to laziness, nor low enough to discourage him from aspiring. And certainly to a person, that affected so much an universal knowledge, and arbitrary vicissitudes of quiet and employments, it could not be unwelcome to be of a quality, that was a handsom stirrup to preferment, without an obligation to court it, and which might at once both protect his higher pretensions from the guilt of ambition, and secure his retiredness from contempt.


When once Philaretus was able, without danger, to support the incommodities of a remove, his father, who had a perfect aversion for their fondness, who use to breed their children so nice and tenderly, that a hot sun, or a good shower of rain, as much endangers them, as if they were made of butter, or of sugar, sends him away from home, and commits him to the care of a country nurse, who by early inuring him, by slow degrees, to a coarse but cleanly diet, and to the usual passions of the air, gave him so vigorous a complexion, that both hardships were made easy to him by custom, and the delights of conveniences and ease were endeared to him by their rarity.


Some few years after this, two great disasters befel Philaretus; the one was the decease of his mother, whose death would questionless have excessively afflicted him, had but his age permitted him to know the value of his loss; for he would ever reckon it amongst the chief misfortunes of his life, that he did never know her, that gave it him, her free and noble spirit (which had a handsom mansion to reside him) added to her kindness and sweet carriage to her own, making her so hugely regretted by her children, and so lamented by her husband, that not only he annually dedicated the day of her death to solemn mourning for it, but burying in her grave all thoughts of after marriage, he rejected all motions of any other match, continuing a constant widower till his death.


The second misfortune, that befel Philaretus, was his acquaintance with some children of his own age, whose stuttering habitude he so long counterfeited, that at last he contracted it; possibly a just judgment upon his derision, and turning the effects of God's anger into the subject matter of his sport. Divers experiments, believed the probablest means of cure, were tried with as much successlessness as diligence; so contagious and catching are men's faults, and so dangerous is the familiar commerce of those condemnable customs, that being imitated but in jest, come to be learned and acquired in earnest.


But to show, that these afflictions made him not less the object of heaven's care, he much about this time escaped a danger, from which he owed his deliverance wholly to providence, being so far from contributing to it himself, that he did his endeavour to oppose it: for waiting on his father up to **Dublin**, there to expect the return of his eldest brother (then



---

p.7



landed out of England, with his new wife, the earl of Cumberland's heir)[2](javascript:footNote('E650001-100/note002.html')) as they were to pass over a brook, at that time suddenly by immoderate showers swelled to a torrent, he was left alone in a coach, only with a foot-boy, where a gentleman of his father's very well horsed accidentally espying him, in spite of some others and his own unwillingness and resistance, (they not believing his stay dangerous) carried him in arms over the rapid water, which proved so much beyond expectation both swift and deep, that horses with their riders were violently hurried down the stream, which easily overturned the unloaded coach, the horses (after by long struggling they had broke their harness) with much ado saving themselves by swimming.


As soon as his age made him capable of admitting instruction, his father by a Frenchman, and by one of his chaplains, had him taught both to write a fair hand, and to speak French and Latin, in which, especially the first, he proved no ill proficient, adding to a reasonable forwardness in study a more than usual inclination to it.


This studiousness observed in Philaretus endeared him very much unto his father, who used highly to commend him both for it and his veracity, of which latter he would often give him this testimony, that he never found him in a lie in all his life-time. And indeed lying was a vice both so contrary to his nature, and so inconsistent with his principles, that as there was scarce any thing he more greedily desired than to know the truth, so was there scarce any thing he more perfectly detested, than not to speak it: which brings into my mind a foolish story I have heard him jeered with by his sister my **lady Ranelagh**, how she having given strict order to have a fruit-tree preserved for his sister-in-law, the lady Dungarvan, then big with child, he accidentally coming into the garden, and ignoring the prohibition, did eat half a score of them, for which being chidden by his sister Ranelagh, (for he was yet a child) and being told by way of aggravation, that he had eaten half a dozen plumbs, ‘Nay truly, sister,’ (answers he simply to her) ‘I have eaten half a score.’ So perfect an enemy was he to a lie, that he had rather accuse himself of another fault, than be suspected to be guilty of that. This trivial passage I have mentioned now, not that I think, that in itself it deserves a relation, but because as the sun is seen best at his rising and his setting, so men's native dispositions are clearliest perceived, whilst they are children, and when they are dying. And certainly these little sudden accidents are the greatest discoverers of men's true humours; for whilst the inconsiderateness of the thing affords no temptation to dissemble, and the suddenness of the time allows no leisure to put disguises on, men's dispositions do appear in their true genuine shape, whereas most of those actions, that are done before others, are so much done for others; I mean most solemn actions are so personated, that we may much more probably guess from thence, what men desire to seem, than what they are; such publick format acts much rather being adjusted to men's designs, than flowing from their inclinations.


Philaretus had now attained, and somewhat past the eighth year of his age, when his father (who supplied what he wanted in scholarship himself, by being both a passionate affecter, and eminent patron of it) ambitious to improve his early studiousness, and considering, that great men's children breeding up at home tempts them to nicety, to pride, and idleness, and contributes much more to give them a good opinion of themselves, than to make them deserve it, resolves to send over Philaretus in the company of Mr. F. B.[3](javascript:footNote('E650001-100/note003.html')) his elder brother, to be bred up at Eton college near Windsor, whose provost at that time was **Sir Henry Wotton**, a person, that was not only a fine gentleman himself, but very well skilled in the art of making others so, betwixt whom and the earl of Corke an ancient friendship had been constantly cultivated by reciprocal civilities. To him therefore the good old earl recommends Philaretus, who having laid a week at **Youghall** for a wind, when he first put to sea, was by a storm beaten back again, not only a taste, but an omen of his future fortune. But after eight days further stay, upon the second summons of a promising gale, they went aboard once more, and (though the Irish coasts were then sufficiently infested with Turkish gallies) having by the way touched at **Ilford-combe**, and **Minehead**, at last they happily arrived at **Bristol**.


Philaretus, in the company of his brother, after a short stay to repose and refresh themselves at **Bristol**, shaped his journey directly for Eton college, where a gentleman of his father's, sent to convey them thither, departing, recommended him to the especial care of **Sir Henry Wotton**, and left with him, partly to instruct, and partly to attend him, one R. C. one that wanted neither vices, nor cunning to dissemble them; for though his primitive fault was only a dotage upon play, yet the excessive love of that goes seldom unattended with a train of criminal retainers; for fondness of gaming is the seducingest lure to ill company, and that the subtlest pander to the worst excesses. Wherefore our Philaretus deservedly reckoned it, both amongst the greatest and the unlikeliest deliverances he owed providence, that he was protected from the contagion of such precedents; for though the man wanted not a competency of parts, yet perverted abilities make men but like those wandring fires, philosophers call ignes fatui, whose light ssrves not to direct, but to seduce the credulous traveller, and allure him to follow them in their deviations. And it is very true, that during the minority of judgment, imitation is the regent in the foul, and those, that are least capable of reason, are most swayed by example. A blind man will suffer himself to be led, though by a dog, or a child.




---

p.8


Not long our Philaretus staid at school, ere his master, Mr. Harrison, taking notice of some aptness, and much willingness, in him to learn, resolved to improve them both by all the gentlest ways of encouragement; for he would often dispense from his attendance at school, at the accustomed hours, to instruct him privately and familiarly in his chamber. He would often as it were cloy him with fruit and sweetmeats, and those little dainties, that age is greedy of, that by preventing the want, he might lessen both his value and desire of them. He would sometimes give him unasked play-days, and oft bestow upon him such balls, and tops, and other implements of idleness, as he had taken away from others, that had unduly used them. He would sometimes commend others before him, to rouse his emulation, and oftentimes give him commendations before others, to engage his endeavours to deserve them. Not to be tedious, he was careful to instruct him in such an affable, kind, and gentle way, that he easily prevailed with him to consider studying, not so much as a duty of obedience to his superiors, but as the way to purchase for himself a most delightsom and invaluable good. In effect, he soon created in Philaretus so strong a passion to acquire knowledge, that what time he could spare from a scholar's task, which his retentive memory made him not find uneasy, he would usually employ so greedily in reading, that his master would sometimes be necessitated to force him out to play, on which, and upon study, he looked, as if their natures were inverted. But that, which he related to be the first occasion, that made him so passionate a friend to reading, was, the accidental perusal of Quintus Curtius, which first made him in love with other than pedantick books, and conjured up in him that unsatisfied appetite of knowledge, that is yet as greedy, as when it first was raised. In gratitude to this book, I have heard him hyperbolically say, that not only he owed more to Quintus Curtius, than Alexander did; but derived more advantage from the history of that great monarch's conquests, than ever he did from the conquests themselves.


Whilst our youth was thus busied about his studies, there happened to him an accident, that silence must not cover: for being one night gone to bed, somewhat early, whilst his brother was conversing with some company by the fire-side, without giving them the least warning or summons to take heed, a great part of the wall of their chamber, with the bed, chairs, books, and furniture of the next chamber over it, fell down, at unawares, upon their heads. His brother had his band torn about his neck, and his coat upon his back, and his chair crushed and broken under him; but by a lusty youth, then accidentally in the room, was snatched from out the ruins, by which Philaretus had, in all probability, been immediately oppressed, had not his bed been curtained by a watchful providence, which kept all heavy things from falling on it; but the dust the crumbled rubbish raised was so thick, that he might there have been stifled, had not he remembred to wrap his head in the fleece, which served him as a strainer, through which none but the purer air could find a passage. So sudden a danger, and hasty an escape, Philaretus would sometimes mention, with expressions both of gratitude and wonder. To which he would add the relation of divers other almost contemporary deliverances: of these, one was, that, being fallen from his horse, the beast ran over him, and trod so near his throat, as within less than two inches of it to make a hole in his band, which he long after reserved for a remembrancer. Another was, that riding through a town, upon a nag of his own, whose starting quality he never observed before, his horse, upon a sudden fright, rose bolt upright upon his hinder feet, and falling rudely backward with all his weight against a wall, had infallibly crushed his rider into pieces, if, by a strange instinct, he had not cast himself off at first, and was quit of it for a slight bruise. The last was, Philaretus being newly recovered of a flux, the doctor had prescribed him a refreshing drink: the fellow, that should administer it, instead of it, brings him a very strong vomit, prepared and intended for another. Philaretus was that morning visited by some of his school-fellows, who (as he was not ill beloved amongst them) presented him with some sweet-meats, which having eaten, when afterwards he would have eaten his breakfast, his stomach, whether out of squeamishness, or divination, forced him to render it again. To which lucky accident the physician ascribed his escape from the apothecary's error; for in the absence of those, that tended him, his physick cast him into hideous torments, the true cause of which he never dreamed of, and remained long unconjectured, until the effects betrayed it; for after a long struggling, at last the drink wrought with such violence, that they feared, that his life would be disgorged together with his potion. This accident made him long after apprehend more from the physicians, than the disease, and was possibly the occasion, that made him afterwards so inquisitively apply himself to the study of physick, that he might have the less need of them, that profess it. But Philaretus would not ascribe any of these rescues unto chance, but would be still industrious to perceive the hand of heaven in all these accidents; and indeed he would profess, that in the passages of his life, he had observed so gracious and so peculiar a conduct of providence, that he should be equally blind and ungrateful, should he not both discern and acknowledge it.


Philaretus having now for some two years been a constant resident at Eton (if you except a few visits, which, during the long vacations, he made his sister my **lady Goring**[4](javascript:footNote('E650001-100/note004.html')) at Lewes in Sussex) when about Easter he was sent for up to **London** to see his eldest brother the **lord Dungarvan**, where being visited with a tertian ague, after the queen's and others doctors remedies had been successlessly assayed, at last he returned again to Eton to derive that health from a good air and diet, which physic could not give him. Here to divert his melancholy, they



---

p.9



made him read the state adventures of Amadis de Gaule, and other fabulous and wandring stories, which much more prejudiced him, by unsettling his thoughts, than they could have advantaged him, had they affected his recovery; for meeting in him with a restless fancy, then made more susceptible of any impressions by an unemployed pensiveness, they accustomed his thoughts to such a habitude of roving, that he has scarce ever been their quiet master since, but they would take all occasions to steal away, and go a-gadding to objects then unseasonable and impertinent; so great an unhappiness it is for persons, that are born with such busy thoughts, not to have congruent objects proposed to them at first. It is true, that long time after Philaretus did in a considerable measure fix his volatile fancy, and reclaim his thoughts, by the use of all those expedients he thought likeliest to fetter, or at least to curb the roving wildness of his wandring thoughts. Amongst all which the most effectual way he found to be the extraction of the square and cube roots, and especially those more laborious operations of algebra, which both accustom and necessitate the mind to attention, by so entirely exacting the whole man, that the smallest distraction, or heedlessness, constrains us to renew our trouble, and rebegin the operation. Six weeks had Philaretus been troubled with his ague, when he was freed from it by an accident, which is no slender instance of the force of imagination; for the physician having lent him a purge, to give (as he said) the fatal blow to the disease, our Philaretus had so perfect an aversion to all physic, and had newly assayed it so unsuccessfully, that his complaints induced the maid servants of the house he lodged in (partly out of complaisance to him, and partly out of a belief, that physic did but exasperate his disease) unknown to him, to pour out the portion, and fill the vial with syrup of stewed prunes, a liquor so resembling it, that Philaretus (see the force of fancy!) swallowed it with the same reluctancy, and found the taste as loathsome as if it had been the purge; but being after acquainted with the cousenage, whether it was, that his sickness (as having already reached its period) would have expired of itself, or that his mirth dispatched it, I pretend not to determine; but certain it is, that from that hour to this, agues and he have still been perfect strangers, and he had much ado to refrain from laughter, when going to thank and reward the doctor for his recovery, he found it wholly ascribed to the efficacy of the portion he had never swallowed, but in imagination.


He had now served well near half an apprenticeship at school, when there arrived intelligence of his father's being landed in England, and gone to **Stalbridge**, a place in Dorsetshire then newly purchased by him. Thither Philaretus accompanies his sister the **countess of **Kildare**** to wait upon him. The good old earl welcomed him very kindly, for whether it were to the custom of old people (as Jacob doted most on Benjamin and Joseph) to give their eldest children the largest proportions of their fortunes, but the youngest the greatest share of their affections; to a likeness observed in Philaretus, both to his father's body and his mind; or, as it seems most likely, to his never having lived with his father to an age, that might much tempt him to run in debt, and take such other courses to provoke his dislike, as in his elder children he severely disrelished; to which if these causes the effect is to be ascribed, it is not my talk to resolve, but certain it is, that from Philaretus's birth, untill his father's death, he ever continued very much his favourite. But after some weeks enjoyment of the summer diversions at **Stalbridge**, when his father removed to **London**, he left him by the way at Eton college, from whence at his return in the West, some few months after, he took him absolutely away, after Philaretus had spent in that school (then very much thronged with young nobility) not much beneath four years, in the last of which he forgot much of that Latin he had got, for he was so addicted to more solid parts of knowledge, that he hated the study of bare words naturally, as something, that relished too much of pedantry to consort with his disposition and designs; so that by the change of his old courteous schoolmaster for a new rigid fellow, losing those encouragements, that had formerly subdued his aversion to verbal studies, he quickly quitted his Terence and his grammar, to read in history their gallant acts, that were the glory of their own, and the wonder of our times. And indeed it is a much nobler ambition to learn to do things, that may deserve a room in history, than only to learn, how congruously to write such actions in the gown-men's language.


As soon as Philaretus was arrived at **Stalbridge**, his father assigned the care of teaching him to one Mr. W. Douch, then parson of that place, and one of his chaplains; and, to avoid the temptations to idleness, that home might afford, made him both lodge and diet where he was taught, though it were not distant from his father's house above twice a musket-shot. This old divine instructing our youth both with care and civility, soon brought him to renew his first acquaintance with the Roman tongue, and to improve it so far, that in that language he could readily enough express himself in prose, and began to be no dull proficient in the poetic strain; which latter he was naturally addicted to, resenting a great deal of delight in the conversation of the Muses, which nevertheless he ever since that time forbore to cultivate; not out of any dislike or undervaluing of poetry, but because in his travels having by discontinuance forgot much of the Latin tongue, he afterwards never could find time to redeem his losses by a serious study of the ancient poets. And then for English verses, he said, they could not be certain of a lasting applause, the changes of our language being so great and sudden, that the rarest poems within few years will pass for obsolete; and therefore he used to liken the writers in English verse to ladies, that have their pictures drawn with the



---

p.10



clothes now worn, which, though at present never so rich, and never so much in fashion, within a few years hence will make them look like anticks. Yet did he at idle hours write some few verses, both in French and Latin, and many copies of amorous, merry, and devout ones in English; most of which, uncommunicated, the day he came of age, he sacrificed to Vulcan, with a design to make the rest perish by the same fate, when they came within his power, though amongst them were many serious copies, and one long one, amongst the rest, against wit profanely or wantonly employed; those two vices being ever perfectly detested by him in others, and religiously declined in all his writings.


About this time also Philaretus began to be taught some skill in the music, both of the voice, and hand; but the discouragement of a bad voice quickly persuaded him to desist. It was now the spring of the year, when news was brought to **Stalbridge** of the approach of his sister, the **lady Goring**, and in her company two of his brothers, the lords of **Kinelmeaky**[5](javascript:footNote('E650001-100/note005.html')) and of **Broghill**[6](javascript:footNote('E650001-100/note006.html')), then newly returned from their three years*'* travels. In their company arrived one **Mr. Marcombes**, a French gentleman, who had been their governor, and behaved himself so handsomly in that relation, that the old earl removed Philaretus (his brother lying sick at a doctor's house) to his own house again, and intrusted his whole education with this gentleman. He was a man, whose garb, his mien, and outside, had very much of his nation, having been divers years a traveller and a soldier; he was well fashioned, and very well knew, what belonged to a gentleman. His natural were much better than his acquired parts, though divers of the latter he possessed, though not in an eminent, yet in a very competent degree. Scholarship he wanted not, having in his greener years been a professed student in divinity; but he was much less read in books than men, and hated pedantry as much as any of the seven deadly sins. Thrifty he was extremely, and very skilful in the flights of thrift; but less out of avarice, than a just ambition, and not so much out of love to money, as a desire to live handsomly at last. His practical sentiments in divinity were most of them very sound; and if he were given to any vice himself, he was careful by sharply condemning it, to render it uninfectious, being industrious, whatsoever he were himself, to make his charges virtuous. Before company he was always very civil to his pupils, apt to eclipse their failings, and set off their good qualities to the best advantage; but in his private conversation he was cynically disposed, and a very nice critick both of words and men; which humour he used to exercise so freely with Philaretus, that at last he forced him to a very cautious and considerate way of expressing himself, which after turned to his no small advantage. The worst quality he had was his choler, to excesses of which he was excessively prone; and that being the only passion, to which Philaretus was much observed to be inclined, his desire to shun clashing with his governor, and his accustomedness to bear the sudden sallies of his impetuous humour, taught our youth so to subdue that passion in himself, that he was soon able to govern it habitually and with ease; the continuance of which conquest he much acknowledged to that passage of St. James, *For the wrath of man worketh not the righteousness of God.’’*

James 1. 20.

 And he was ever a strict observer of that precept of the apostle, ‘Let not the sun go down upon your wrath;’ for continued anger turns easily to malice; which made him, upon occasion of this sentence of St. Paul, to say, that anger was like the Jewish manna, which might be wholesom for a day or two, but if it were kept long, it would breed worms, and corrupt. With this new governor our Philaretus spent the greatest part of the summer, partly in reading and interpreting the Universal History, written in Latin, and partly in familiar kind of conversation in French, which Philaretus found equally diverting and instructive, which was as well consonant to the humour of his tutor as his own.


About this time his eldest brother, the lord of Dungarvan, having at his own charges raised a gallant troop of horse for the king's service in the Scotch expedition, his father sent two other of his sons, **Kinelmeaky** and **Broghill**, to accompany him in that service, and designed Philaretus for the same employment; but the sickness of his next elder brother, **Mr. F** whom he was to go along with in that voyage, defeated all our young man's greedy hopes. During his stay at **Stalbridge** all that summer, his father, to oblige him to be temperate, by freely giving him the opportunity to be otherwise, trusted him with the keys of all his gardens and orchards.


And indeed Philaretus was little given to greediness, either in fruits or sweetmeats; in the latter he was almost abstemious, and in the former he was very moderate; so valuing such niceties and dainties, that though he enjoyed them with delight, he could want them without the least regret. During this pleasing season, when the intermission of his studies allowed Philaretus leisure for recreations, he would very often steal away from all company, and spend four or five hours alone in the fields, and think at random, making his delighted imagination the busy scene, where some romance or other was daily acted; which, though imputed to his melancholy, was in effect but an usual excursion of his yet untamed habitude of roving, a custom (as his own experience often and sadly taught him) much more easily contracted, than destroyed.


Towards the end of this summer, the kingdom having now attained a seeming settlement by the king's pacification with the Scots, there arrived at **Stalbridge** **Sir Thomas Stafford**, gentleman usher to the queen, with his lady, to visit their old friend, the earl of Cork, with whom, ere they departed, they concluded a match betwixt his fourth son, Mr. F. B. and E. K*illegrew* daughter to my **lady Stafford** by Sir — K. and then a maid of honour, both young and handsom. To make his addresses to this lady, Mr. F. was sent (and Philaretus in his



---

p.11



company) before up to **London**, whither within few weeks they were followed by the earl and his family, of which a great part lived at (the **lady Stafford**'s house) the Savoy; the rest (for his family was much encreased by the accession of his daughters, the **countess of **Barrimore**** and the **lady Ranelagh**, with their lords and children) were lodged in the adjacent houses, but took their meals in the Savoy, where the old earl kept so plentiful a house, that in months his accompts for bare house-keeping exceeded [*gap: extent: one word*] pounds.


Not long after his arrival, Philaretus's brother having been successful in his addresses to his mistress, was, in the presence of the king and queen, publickly married at court, with all that solemnity, that usually attends matches with maids of honour. But to render this joy as short as it was great, Philaretus and his brother were within four days after commanded away for France, and after having kissed their majesty's hands, they took a differing farewel of all their friends; the bridegroom extremely afflicted to be so soon deprived of a joy, which he had tasted but just enough of to encrease his regrets, by the knowledge of what he was forced from; but Philaretus as much satisfied to see himself in a condition to content a curiosity, to which his inclinations did passionately addict him. With these differing resentments of their father's commands, accompanied by their governor, two French servants, and a lacquey of the same country, upon the end of October, 1638, they took post for **Rye** in **Sussex**, where the next day hiring a ship, though the sea were not very smooth, a prosperous puff of wind did safely by the next morning blow them into France.


After a short refreshment at **Dieppe**, they travelled through **Normandy** to the chief city of it, **Rouën**; but by the way received advertisement of a robbery freshly committed in a wood, they must traverse by night; but judging the fear of being apprehended would deter the robbers from a sudden return to the same place, after so recent a crime, the company quietly continued on their journey to **Rouën**, and arrived safely at it; where, amongst other singularities, Philaretus took much notice of a great floating bridge, which rising and falling as the tide-water does, he used to resemble to the vain amorists of outward greatness, whose spirits relent all the floods and ebbs of that fortune it is built on. From **Rouën** they passed to **Paris**, and having spent some time in visiting that vast chaos of a city, they shaped their course for **Lyons**, where, after nine days unintermitted travel, they arrived, having by the way (besides divers considerable places) passed by the town of **Moulins** (here famed enough for the fine tweezes it supplies us with) a part of the French Arcadia, the pleasant **Pays de Forest**, where the marquis d'Urfé was pleased to lay the scene of the adventures and amours of that Astrea, with whom so many gallants are still in love, so long after both his and her decease: being also by the way usefully diverted by the company of two Polonian princes, who had as well a right unto that title by their virtue and their education, as their birth.


After some stay at **Lyons** (a town of great resort, and no less trading, but fitter for the residence of merchants than of gentlemen) they traversed those lofty mountains, that formerly belonging to the duke of Savoy, were now by stipulation (in exchange of the marquisate of **Saluzzo**) devolved to the French king; and having by the way beheld that famous place, where the swiftest and one of the noblest rivers of Europe, the **Rhosne**, is so streightned betwixt two neighbour rocks, that it is no such large stride to stand on both his banks, the third day after their departure from Lyons, they arrived safely at **Geneva**, a little commonwealth, which their early embracing and constant profession of the reformed religion, together with that peculiar care of providence, in so long and so unlikely a preservation, has rendred very much the theme, not only of discourse, but some degree of wonder.


Philaretus's instructions commanding him a long stay in this place, his governor (having both a wife and children in the town) provided him lodgings and entertainment in his own house, and at set hours taught him both rhetoric and logic, whose elements (not the expositions) Philaretus wrote out with his own hand; though afterwards he esteemed both those arts, as they are vulgarly handled, not only unseasonably taught, but obnoxious to those inconveniences, and guilty of those defects, he does fully particularize in his Essays. After these slighter studies, he fell to learn the mathematics, and in a few months grew very well acquainted with the most useful part of arithmetic, geometry, with its subordinates, the doctrine of the sphere, that of the globe, and fortification; in all which being instructed by a person, that had a greater regard for his scholar's proficiency, than the gains he might derive from the common tedious and dilatory way of teaching, he quickly grew so enamoured of those delightful studies, that they very often proved both his business and his diversion in his travels, and he afterwards improved his opportunities to the attainment of a more than ordinary skill in divers of them. He also frequently conversed with a voluminous, but excellent French book, called, Le Monde, which so judiciously informs its readers, both of the past and present condition of all those states, that now possess our globe, and by a delectable and instructive variety not only satisfies men's curiosity, but so copiously supplies them with matter, both of curious and serious discourse, that he used to say of that book, that it was worth its title, which means, The World.


But to employ his body, as well as his mind, because Philaretus's age was yet unripe for so rude and violent an exercise as the great horse, he spent some months in fencing, and ten or twelve in learning to dance, the former of which exercises he ever as much affected, as he contemned the latter. His recreations, during his stay at **Geneva**, were sometimes mall[7](javascript:footNote('E650001-100/note007.html')),



---

p.12



tennis, (a sport he ever passionately loved) and, above all, the reading of romances, whose perusal did not only extremely divert him, but (assisted by a total discontinuance of the English tongue) in a short time taught him a skill in French somewhat unusual to strangers. In effect, before he quitted France, he attained a readiness in the language of that country, which enabled him, when he made concealment his design, to pass for a native of it, both amongst them that were so, and amongst foreigners also; and in all his writings, whilst he was abroad, he still made use of the French tongue, not out of any intention to improve his knowledge in it, but because it was that he could express himself best in.


But during Philaretus's residence at **Geneva**, there happened to him an accident, which he always used to mention as the considerablest of his whole life. To frame a right apprehension of this, you must understand, that though his inclinations were ever virtuous, and his life free from scandal, and inoffensive, yet had the piety he was master of already so diverted him from aspiring unto more, that Christ, who long had lain asleep in his conscience (as he once did in the ship) must now, as then, be waked by a storm. For at a time, which (being the very heat of summer) promised nothing less, about the dead of night, that adds most terror to such accidents, Philaretus was suddenly waked in a fright with such loud claps of thunder (which are oftentimes very terrible in those hot climes and seasons) that he thought the earth would owe an ague to the air, and every clap was both preceded and attended with flashes of lightning so frequent and so dazzling, that Philaretus began to imagine them the sallies of that fire, that must consume the world. The long continuance of that dismal tempest, where the winds were so loud, as almost drowned the noise of the very thunder, and the showers so hideous, as almost quenched the lightning, ere it could reach his eyes, confirmed Philaretus in his apprehensions of the day of judgment's being at hand. Whereupon the consideration of his unpreparedness to welcome it, and the hideousness of being surprised by it in an unfit condition, made him resolve and vow, that if his fears were that night disappointed, all his further additions to his life should be more religiously and watchfully employed. The morning came, and a serener cloudless sky returned, when he ratified his determination so solemnly, that from that day he dated his conversion, renewing, now he was past danger, the vow he had made, whilst he believed himself to be in it; that though his fear was (and he blushed it was so) the occasion of his resolution of amendment, yet at least he might not owe his more deliberate consecration of himself to piety to any less noble motive, than that of its own excellence.


Thus had this happy storm an operation upon Philaretus, resembling that it had upon the ground; for the thunder did but terrify, and blasted not; but with it fell such kind and genial showers, as watered his parched and almost withered graces, and reviving their greenness, soon rendered them both flourishing and fruitful. And though his boiling youth did often very earnestly solicit to be employed in those culpable delights, that are usual in, and seem so proper for that season, and have repentance adjourned till old age; yet did its importunities meet ever with denials, Philaretus ever esteeming, that piety was to be embraced, not so much to gain heaven, as to serve God with. And I remember, that being once in company with a crew of mad young fellows, when one of them was saying to him, what a fine thing it were, if men could sin securely all their life time, by being sure of leisure to repent upon their death-beds; Philaretus presently replied, that truly for his part he should not like sinning, though on those terms, and would not all that while deprive himself of the satisfaction of serving God, to enjoy so many years fruition of the world. In effect it is strange, that men should take it for an inducement to an action, that they are confident, that they shall repent of it. But Philaretus himself having sufficiently discoursed that point of early piety, in the sixth treatise of his Christian Gentleman, I shall at present not only add to the arguments you may find there alledged, that he used to say, that it was a kind of meanness in devotion, to consider the very joys of the other life more as a condition, than a recompense. But (as when in summer we take up our grass-horses into the stable, and give them store of oats, it is a sign, that we mean to travel them) our P. soon after he had received this new strength, found a new weight to support; for spending some of the spring in a visit to Chambery, the chief town of Savoy; Aix famed for its baths; Grenoble, the head town of Dauphiné, and residence of a parliament, his curiosity at last led him to those wild mountains, where the first and chiefest of the Carthusian abbies does stand seated; where the devil taking advantage of that deep raving melancholy, so sad a place, his humour, and the strange stories and pictures he found there of Bruno, the father of that order, suggested such strange and hideous thoughts, and such distracting doubts of some of the fundamentals of Christianity, that, though his looks did little betray his thoughts, nothing but the forbiddenness of self-dispatch hindered his acting it. But after a tedious languishment of many months in this tedious perplexity, at last it pleased God, one day he had received the sacrament, to restore unto him the withdrawn sense of his favour. But though since then Philaretus ever looked upon these impious suggestions, rather as temptations to be suppressed, than doubts to be resolved; yet never after did these fleeting clouds cease now and then to darken the clearest serenity of his quiet, which made him often say, that injections of this nature were such a disease to his faith, as the tooth-ach is to the body; for though it be not mortal, it is very troublesom. And however, as all things work together to them that love



---

p.13



God Philaretus derived from this anxiety the advantage of groundedness in his religion: for the perplexity his doubts created obliged him, to remove them, to be seriously inquisitive of the truth of the very fundamentals of Christianity, and to hear what both Turks, and Jews, and the chief sects of Christians could alledge for their several opinions; that so, though he believed more than he could comprehend, he might not believe more than he could prove, and not owe the stedfastness of his faith to so poor a cause, as the ignorance of what might be objected against it. He said (speaking of those persons, that want not means to enquire, and abilities to judge,) that it was not a greater happiness to inherit a good religion, than it was a fault to have it only by inheritance, and think it the best, because it is generally embraced, rather than embrace it, because we know it to be the best. That though we cannot always give a reason for what we believe, we should be ever able to give a reason why we believe it. That it is the greatest of follies to neglect any diligence, that may prevent the being mistaken, where it is the greatest of miseries to be deceived. That how dear soever things taken up on the score are sold, there is nothing worse taken up upon trust than religion, in which he deserves not to meet with the true one, that cares not to examine whether or no it be so.


And now Philaretus having spent one and twenty months in **Geneva**, about the middle of September 1641 departed towards Italy, and having traversed Swi*t*zerland, and by the way seen **Lausanne** (an academy seated upon the great Genevan lake), **Zurich**, and **Soleurre**, the heads of Cantons wearing the same name, and wandered seven or eight days amongst those hideous mountains, where the **Rhosne** takes it source, and he saw the Rhine but a brook; he at length arrived at the Valtollina, a spacious valley walled round with the steep Alpes, but so delicious, and (especially in that season) so crowned with all that Ceres and Bacchus are able to present, that it deserved to be the motive, but not the stage of those late wars it has occasioned betwixt the rival crowns of France and Spain. There Philaretus had the curiosity to visit, the place on which stood Piur, a pleasant little town, once esteemed for its deliciousness, but now much more and more meritedly famous for its ruin, which happened some two dozen of years hence, by the sudden and unexpected fall of a neighbouring hill upon it, which struck the whole town so deep into the ground, that no after-search by digging has ever prevailed to reach it. Having visited the singularities of this earthly paradise, Philaretus and his company began to climb that mountain of the Alpes, which denominated from a town, that is seated upon its foot, is usually called, La montagna di Morbegno. The hill was eight miles in ascent, and double that number downwards. It was then free from snow; but all the neighbouring hills, where store of crystal is digged, like perpetual penitents, do all the year wear white. Upon the top of this hill, which is entirely uninhabited, Philaretus had the pleasure to see the clouds, which they passed through in their descent, beneath them darkning the middle of the mountain, while on the top they had a clear serenity. But notwithstanding the fairness of the day, they spent it all in traversing this hill, at the height of which they left the Grisons territory, and at the bottom entered a village belonging to that of the Venetians; but having passed through such a purgatory as the Alpes to their Italian paradise, I cannot but suppose them somewhat weary, and so my pen obliged to let them and itself take some short rest.


Philaretus being thus entred into the vast and delicious plains of Lombardy, traversed the greatest part of that rich province, and having stayed the stomach of his curiosity with the observables of Bergamo, Brescia, Verona, Vincenza, and Padua (a famous university, but more peculiarly devoted to Aesculapius than Minerva's arts) he gave it a full meal at Venice, where the great concourse of foreign nations numerously resorting thither for trade or nobler business, presents the senses with a no less pleasing than constant variety. From Venice returning through Padua, and passing through Bologna and Ferrara (towns, whose names allow me to spare their characters) he at last arrived at Florence, with a determination (having disposed of the horses he rode on from **Geneva** thither) to pass the winter there. Florence is a city, to which nature has not grudged a pleasing situation, and in which architecture has been no niggard either of cost or skill, but has so industriously and sumptuously improved the advantages liberally conferred by nature, that both the seat and buildings of the town abundantly justify the title the Italians have given it of Fair. Here Philaretus spent much of his time in learning of his governor (who spake it perfectly) the Italian tongue, in which he quickly attained a native accent, and knowledge enough to understand both books and men; but to speak and express himself readily in that language was a skill, he ever too little aspired to acquire. The rest of his spare hours he spent in reading the modern history in Italian, and the new paradoxes of the great star-gazer **Galileo**, whose ingenious books, perhaps because they could not be so otherwise, were confuted by a decree from Rome; his highness the Pope, it seems, presuming, and that justly, that the infallibillity of his chair extended equally to determine points in philosophy, as in religion, and loth to have the stability of that earth questioned, in which he had established his kingdom. Whilst Philaretus lived at Florence, this famous **Galileo** died[8](javascript:footNote('E650001-100/note008.html')) within a league of it, his memory being honoured with a celebrating epitaph, and a fair tomb erected for him at the publick charges; but before his death being long grown blind, to certain friers (a tribe, whom for their vices and impostures he long had hated) that reproached him with his blindness, as a just punishment of



---

p.14



heaven incensed for being so narrowly pried into by him, he answered, that he had the satisfaction of not being blind, till he had seen in heaven what never mortal eyes beheld before. But to return to Philaretus, the company of certain Jewish rabbins, who lodged under the same roof with him, gave him the opportunity of acquainting himself with divers of their arguments and tenets, and a rise of further disquisitions in that point. When carnaval was come (the season, when madness is so general in Italy, that lunacy does for that time lose its name) he had the pleasure to see the tilts maintained by the Great Duke's brothers, and to be present at the gentlemen's balls. Nor did he sometimes scruple, in his governor's company, to visit the famousest Bordellos, whither resorting out of bare curiosity, he retained there an unblemished chastity, and still returned thence as honest as he went thither, professing, that he never found any such sermons against them, as they were against themselves; the impudent nakedness of vice clothing it with a deformity, description cannot reach, and the worst of epithets cannot but flatter. But though Philaretus were no fuel for forbidden flames, he proved the object of unnatural ones; for being at that time in the flower of youth, and the cares of the world having not yet faded a complexion naturally fresh enough, as he was once unaccompanied diverting himself abroad, he was somewhat rudely pressed by the preposterous courtship of two friers, whose lust makes no distinction of sexes, but that, which its preference of their own creates, and not without difficulty and danger forced a scape from those gowned Sodomites, whose goatish heats served not a little to arm Philaretus against such people's specious hypocrisy, and heightened and fortified in him an averseness for opinions, which now the religieux discredit as well as the religion.


Philaretus having thus spent the winter in Florence, towards the end of March began his journey to Rome; and having passed thorough and seen the singularities of Sienna, Montefiascone, and some other remarkable places in his passage, at the end of five days he safely arrived at that imperious theme of fame, which destinated to some kind or other of universal monarchy, is now no less considerable by its present superstition, than formerly by its victorious arms; the modern Popes bringing it as high a veneration as the ancient Caesars, and the Barberine bees flying as far as did the Roman eagles. The more conveniently to see the numerous rarities of this universal city, Philaretus, to decline the distracting intrusions and importunities of English Jesuits, passed for a Frenchman, which neither his habit nor language much contradicted. Under this notion he delightfully payed his visits to what in Rome and the adjacent villages most deserved them, and amongst other curiosities and antiquities had the fortune to see the Pope at chapel, with the Cardinals, who severally appearing mighty princes, in that assembly looked like a company of common friers. Here Philaretus could not chuse but smile to see a young churchman, after the service ended, upon his knees carefully with his feet sweep into his handkerchief the dust, his holiness's gouty feet had by treading on it consecrated, as if it had been some miraculous relick. Nor was Philaretus negligent to procure the Latin and Tuscan poems of this Pope, whose name Urbanus his actions did not belie, he having more of the gentleman in him, than his pontifical habit would seem to let him wear. A poet he was, and a [*...*]


[*...*] He never found the Pope less valued than in Rome, nor his religion fiercelier disputed against than in Italy; and sometimes added, that he ceased to wonder, that the Pope should forbid the sight of Rome to protestants, since nothing could more confirm them in their religion.


Philaretus having in a short time surveyed the principal rarities of this proud mistress of the world, was unwillingly driven thence by his brother's disability to support the encreasing heats, which there prove often insupportable to strangers, the neighbouring country being very scorched, and barren, and uninhabited. Wherefore he took his way back towards Florence, by that delicious valley that ennobles Perugia, and passing by Pistoia came to Florence, where, after a short repose, they descended the river Arno into Pisa, and from thence to Livorno, where in a Felucca, with a good wind, they ventured, for expedition*'s* sake, some fifteen or sixmiles into the sea, and coasting along the country, still near the shore for fear of sudden storms, they each night lay in some town, drawing their boat ashore (which was not uneasy in regard of the inconsiderable tides of the Mediterranean there) and soon, though not without danger, reached proud Genoa. [*...*]


[*...*] The next day Philaretus prosecuted his journey, and passing by Monaco (a very strong place, then newly betrayed by the prince to the French) and by Meatone, a little principality belonging to the same prince, and stopping a while at Nizza, a place extremely and meritoriously famous for that strength, which nature and art have emulously given it, by night they landed at Antibe, one of the towns of France, that most approaches Italy.


The morning, that succeeded Philaretus's arrival at Antibe, he left it to cross the country to Marseilles, but he was welcomed into France, by an accident, which was very hazardous, and might have proved tragical. During the whole time of his being a traveller, or resident in Italy, Philaretus had religiously adhered to his [*...*]


[*...*] English gentlemen thinking it as much better as safer to take off their hats, than to venture their heads, complimented with the crucifix; but Philaretus, without the least act of superstition, though not without ill words, and worse menaces, ventured and past boldly thorough them all, as ever resolving, that the soul should not more transcend the body in its own value, than in his esteem. This danger thus happily escaped, Philaretus continues his



---

p.15



way to Marseilles, where the third day he arrived, with intent there to expect bills of exchange promised to be then sent thither, to enable him to prosecute his future travels. His detention here was shortned by his visits of so excellent a harbour for gallies and small vessels. [*...*] Town every night like it assured with lock and key. Here Philaretus had the pleasure to see the French king's fleet of gallies put to sea, and about two thousand poor slaves tug at the oar to row them.


HERE unfortunately Mr. Boyle's manuscript memoirs break off abruptly, which I shall endeavour to continue from such lights, as his other papers afford me.


During his travels, he pursued his studies with great vigour; and his brother Francis, afterwards lord Shannon, used to say, that even then he would never lose any vacant time; for if they were upon the road, and walking down a hill, or in a rough way, he would read all the way; and when they came at night to their inn, he would still be studying till supper, and frequently propose such difficulties, as he met with in his reading, to his governor.


In Italy he read over the lives of the ancient philosophers with the utmost attention. The sect, which then struck him most, was that of the Stoics; and he tried his proficiency in their philosophy; by enduring a long fit of the tooth-ach with great unconcernedness. At Marseilles, he and his brother Shannon were obliged to wait for bills of exchange, in order to prosecute their journey; but, instead of that supply, they received from their father, in May 1642, a sad relation of the general rebellion in Ireland, with this account, that it was with great difficulty he had procured for them two hundred and fifty pounds, to supply their expences in their return home. But this money being intrusted with one Perkins, a citizen of **London**, who was esteemed a man of considerable substance, to be sent them in bills of exchange, he proved unfaithful, so that they never received the least part of it. Being thus left destitute in a strange country, seven or eight hundred miles from home, they were by means of **Mr. Marcombes** their governor brought to **Geneva**, till supplies could be received to enable them to return; where, by reason of the dreadful confusion of affairs in Ireland and England, they fruitlessly waited for about two years; during all which time having no money, either to discharge **Mr. Marcombes**, or to return homewards, they were obliged to live at a great expence, and to run in debt to him on that account. ‘At length,’ adds Mr. Boyle ‘though I could not receive any supply at all from my friends, yet being unable to subsist any longer, I was forced to remove thence; and having upon his *Mr. Marcombes's* credit made shift to take up some slight jewels at a reasonable rate, we made sale of them from place to place, and by their help, at last, by God's assistance, we got safe into England towards the middle of the year 1644, where we found things in such confusion, that although the manor of **Stalbridge** were, by my father's decease, descended unto me, yet it was near four months before I could get thither.’


Upon his return to England, which was unexpected to all his relations, he went immediately to his beloved sister **Catharine, viscountess Ranelagh**, a lady remarkable for her uncommon genius and knowledge, in whose house he lodged four months and an half. It was by accident, that he found her out, but such an accident, as he frequently afterwards, with great thankfulness to the providence of God, used to ascribe a good part of his future happiness to. For had he not been so detained, he had gone into the army, where though there were, besides ‘the excellent king himself, divers eminent divines, and many worthy persons of several ranks; yet the generality of those he would have been obliged to converse with, were very debauched, and apt, as well as inclinable, to make others so;’ whereas by staying in **London** in a family, that was strictly religious, his early years were seasoned with such principles of piety and virtue, as never forsook him during the rest of his life. He reaped also a collateral advantage by it, which was, that a sister-in-law of lady Ranelagh, who was with them in the house, and was wife of one of the principal members of the then house of commons, brought him into the acquaintance and friendship of some great men of that party, which was then growing, and soon after victorious; by whose means he got early protection for his English and Irish estates. However it is probable from a letter of his to his brother **lord Broghill**, dated from **London**, Aug. 25th, 1645, which begins thus, ‘The necessities of my affairs calling me away (according to the leave the parliament has given me) into France,’ that he went abroad again, possibly to settle his accounts with **Mr. Marcombes**, who, as is already observed, had advanced money, and engaged his credit for him. But he did not continue long out of England; for he was at Cambridge for a short time in December following. In March, 1645–6 he retired to his manor at **Stalbridge**; where he resided for the most part till May 1650; and upon his arrival there wrote the following letter to his sister, the **lady Ranelagh**, which will shew his talent in the epistolary style, even at that early age.


> Sister,
> If the busy idleness of receiving senseless visits (whose continuance, if otherwise unavoidable, were capable, in my opinion, to justify the retiredness of an hermit) had not so totally taken up my leisure, you should not so long have had a reprieve from the importunity of my letters. But now at last, to make you amends for my fault (if at least 
> 
> 
> 
> ---
> 
> p.16
> 
> 
> 
> the amends itself be not a fault) I will present you with a piece of a real romance in the story of my peregrination hither. The morning I had the unhappiness to take my leave of you and my lady Molkin, I bid farewel to the city, and began my journey upon a courser. Him I rid to dinner to Egham; and at the end of the town, there it was my good fortune (as we are pleased to miscall it) to overtake an express sent from the parliament to the general, making ceremonies with his horse, whether of them two should lead the way. I quickly put an end to their difference, by making Roger take the honour upon him; and we had not rid far, before we met with some carriers, that had lately left Andover, who assured us, that the way was very secure; though presently after we came to discover, that those youngsters would not have been very sorry, that we had been snapped by some of their party, and been made to take Oxford in our way to **Stalbridge**; for we were no sooner come to Bagshot, but we met a carrier coming the way we were going, who assured us, that the cavaliers had eased them at Basingstoke of all their superfluous moveables, and were advanced as far as Hartley-row, the very village, that I had designed for that night's lodging. So believing, that our quarters would be already taken up, we called a council of war to advise and resolve what to do. It was Roger's opinion, to stay where we were, till the passage were made secure (strange, that so well-armed an head should be fearful!) but the messenger easily persuaded us to go to Farnham (though both that and all the country in the way were smartly alarmed) assuring Roger, that in case of danger he could strike into a way, out of the way, to bring us to the place we went to. As we went along, we met divers little parties, with whom we exchanged fears, and found, that the malignant humours, that were then abroad, had frighted the country into a shaking ague, till we came to Farnham, which we found empty and unguarded, all the townsmen being gone out to oppose the king's party, and chusing rather to have their houses empty, than replenished with such guests, as otherwise they were necessarily to expect. There invited by the coolness of the evening, and the freshness of the garden I was walking in, I almost lost myself in meditating, how foolishly rash were our controlments of, and repinings at the wise contrivances of that all-swaying providence, whose proceedings should be as far above our censures, as they are above our reach. How apt are we, upon the least thwarting of our designs, to murmur against providence, and in a pettish humour throw the helve after the hatchet, le manche apres la coignée, and give ourselves for gone, when, had we had our will in the means, we should have been frustrate in our expectation of the end! Whereas that superlative wisdom, that we grumble at for thwarting us in the means, by crossing us in the way, brings us the sooner to our journey's end. With divers contemplations upon this subject, I went to supper, and thence to bed, not without some little fear of having our quarters beaten up by the cavaliers that night; when lo! to second my apprehensions, about the dead of my sleep, and that night, I heard a thundering at the door, as if they meant to fright it out of the hinges, and us out of our wits. I presently leaped out of my bed, in my stockings and clothes (my usual night-posture, when I travel;) and while Roger was lighting a candle, got my bilboa and other instruments from under my pillow: whereupon Roger opening the door, saw it beset with musketeers, who no sooner saw us, but said aloud, that we were not the men they looked for; and being intreated to come into the chamber, refused it, and he, that brought them thither, excused their troubling us, with as transcendent complements as the brown bill could afford. I wondered at their courtesy, till I knew, that it was the town-constable, that, making a search for some suspicious persons, and coming by my chamber, that wanted a lock, either had a mind to make us take notice of so considerable an officer, or no mind that we should sleep, whilst our betters watched; and for his not coming in, some accents of fear, that fell from him, made me suspect I was obliged for that to myself; and I remember, that just at the opening of the door, he peeping in, espied me drawing a pistol out of one of my holsters, which, I believe, made him so niggardly of his company. Well, away went my gentleman in prosecution of his search, and I e'en took my bows and arrows, and went to sleep. The next day we dined at Winchester, and ever and anon, by the trembling passengers we met, were as nicely catechized concerning our ways, as if we were to be elected in the number of the new lay elders. From thence we reached Salisbury that night, though before we came thither, we were fain to pass in the dark through a wood, where we had warning given us, that about an hundred woodmen (we have got wild English too now) lay leiger, where these night-birds used to exercise their charity in easing weary travellers of such burthensom things as money and portmanteaus. There was nothing in all my journey vext me so much as the gravity of my steed; for though he were none of the freest of his legs, yet he kept my body in a restless agitation, which was none of the pleasantest in the world neither; and if now and then I did solicit his sides, to persuade him to gallop (a dialect, that his feet were utterly unacquainted with) it should be short itself, and both ushered in and epilogized with so long and so jolting a trot, that the trouble of it was far greater than the ease. At Salisbury I overtook my trunks I had sent thither before; and the next morning took them along with me over the plain; where when we had gone about half the way, we were
> suddenly environed with a party of horse (beyond whom we might discover a body of foot) who came poudering so furiously upon us, that they scarce gave us leisure to draw; but coming nearer, and knowing the state's messenger (as he called himself) they durst not
> 
> 
> 
> ---
> 
> p.17
> 
> 
> 
> meddle, neither with us, nor with my trunks, which they eyed though very lovingly; and had not we been there, would, I believe, have opened to search for malignant letters, such as use to be about the King's picture in a yellow boy. The foot we saw were poor pressed countrymen, whom this party of horse were sent, not to convey, but to guard. Amongst them I saw one poor rogue, lacqueyed by his wife, and carrying a child upon his shoulders. A pretty device, methinks, to make those, who have no goods, to fight for their wives and children! Good God! that reasonable creatures, that call themselves Christians too, should delight in such an unnatural thing as war, where cruelty at least becomes necessity, and unprocured poverty becomes a crime; and a man with his whole family must be subject to be unavoidably undone, because the violence perhaps of those very soldiers, that press him, had made him poor. At last on Saturday night I arrived, God be praised, at **Stalbridge**, and found by experience the truth of that senseless proverb, the longest way about is the nearest way home. And here the fair weather, that had been my constant companion from **London** hither, as soon as it saw me housed, took leave of me; in whose absence winter weather has always so fully and uninterruptedly domineered, that we all suspect the almanack-maker of a mistake, in setting down March instead of January. It confines me to my chamber, and is so drooping, that it dulls me to all kinds of useful study, and (which is worst of all) it renders me obnoxious to these country visits (or visitations rather) which, you know, use to supply with their length what they want in their goodness. As soon as the weather will give me leave, I intend to take Marston Bigot in my way to **Bristol**, to put some end or other to the business —— I am loaded with civil language and fair promises; but I have always observed, that in the trooper*'*s dictionary the pages are so close and thick written with promises, that there is no room left for such a word as performance.
> 
> 
> My Ethics[9](javascript:footNote('E650001-100/note009.html')) go very slowly on; neither have I been possibly able to do any other business, save to make my brother's sixty trees bear him some golden fruit, of which, (though I did my uttermost endeavour to ripen it) I must gather but one third at May-day next, the other at &c.
> 
> 
> My stay here, God willing, shall not be long, this country being generally infected with three epidemical diseases (besides that old leiger sickness, the troop-flux) namely the plague, which now begins to revive again at **Bristol** and Yeovil six miles off, fits of the committee, and consumption of the purse; to which so violent expulsives, if so potent an attractive, as a letter from you, were but added, it would both extremely sweeten the stay, and accelerate the departure of,
> 
> 
> My dearest sister,
> your most affectionate brother, and humble servant,
> 
> 
> Robert Boyle
>   
> **Stalbridge**,
> 
> 
> March 30, 1646




During his retirement at **Stalbridge**, he applied himself with great vigour to his studies of various kinds, particularly those of natural philosophy and chemistry. Nor did he neglect to keep up a correspondence with his friends by letters, some of which are extant of so early a date as the year 1646, wherein he not only gives an account of his studies, but likewise discovers a great penetration, and a very solid judgment, concerning men and things, far above his age. And though he meddled as little as possible with politics, yet his interest, his good nature, and his piety, would not suffer him to be an unconcerned spectator of those miseries, under which his country groaned; and in some of his remarks on men's presages concerning the consequences of the war, and their expectation of a settled peace, he passed a true judgment, founded on wise and solid reasons, and verified by the event. For however many of his friends flattered themselves with an happy issue of the war, he had all along different apprehensions of it. I shall insert therefore some extracts of the letters, according to these dates of them. The first was written to **Mr. Marcombes**, October 22, 1646, from **London**, where he then was.


> Monsieur,
> Since discountenance of the practice of your language has robbed me of that little readiness your converse had taught me in it, I shall take the liberty to make use of is mine, which I know you understand equally with your own.
> 
> 
> In my last I promised you a more full account of sundry particulars, I had then the leisure but to touch at; and for my disengagement I shall tell you, that we are in a very doubtful condition for the present, though in all probability a few days will determine either our hopes or our fears. In England the great and uninterrupted successes have transcended as well their own hopes, as their opposers*'* fears. In England there is not one malignant garison untaken, and in Wales but two or three rocky places hold out for the King, and these too so inconsiderable, that they more advantage their enemies forces, by keeping them
> 
> 
> 
> ---
> 
> p.18
> 
> 
> 
> from idleness, than they are able to prejudice them by their opposition. The Scots being now to quit the kingdom, the parliament had compounded with them for all their arrears, upon whose payment they are to deliver up their garisons, and retire into their own country. The sum total, being in all 300,000 *l.* is already agreed upon; but the first payment is yet in debate. His majesty is still at Newcastle, both discontenting and discontented; and the Scots will now, upon their departure out of England, be forced some way or other to dispose of his person, which the houses have here voted to remain at the disposition of both houses of parliament. The greater part of men in these parts are pleased to flatter themselves with the hopes of a speedy settlement of things; but for my part, that have always looked upon sin as the chief incendiary of the war, and yet have by careful experience observed the war to multiply and heighten those sins, to which it owes its being, as water and ice, which by a reciprocal generation beget one another, I cannot without presumption expect a recovery in that body, where the physic, that should cure; but augments the disease. And this opinion of mine is over and above grounded upon such politic considerations, (though known to very few besides my self) that in this I must even wish to have less reason on my side. Those, that appear for the King in Scotland, are bodied in an army of above 8000 men; a power so formidable in that country, that certainly, if by the Scots ill usage to his Majesty it be provoked, it will be able, if not to conquer, at least to ruin that beggared kingdom.
> 
> 
> As for Ireland, the news of my **lord of Ormonde**'s peace with the Irish, together with the articles, upon which it was concluded, have, I am confident, reached **Geneva** long ere this. But our latest intelligence out of those parts informs us, that peace is very likely to produce its contrary amongst them that made it, not only by dividing betwixt the Irish and themselves, for not only the Irish attempted, though vainly, to surprise my **lord of Ormond**, and cut off his party, whilst they were in their quarters; but the best general, and most numerous army, together with divers of their greatest towns, have positively declared against the peace; to which the old English or catholic lords of the English pale, (so we call the counties about **Dublin**) with many others, have submitted; so that these two flints are striking such sparks, as are like to kindle a fine bonefire for the English, if they have the wit but to lay hold on the opportunity, and blow these private discontents into a civil war. Now this relation, however it seem not to carry with it any great probability, I am the more apt to believe, because it is credited by the knowledge of the Irish interests; for the lords of the pale, though by manners and inclination Irish, yet being English by descent, do with reason suspect, that if they give way to a total expulsion or extirpation of the English, their turn will come next to drink out of the same cup; and therefore are very willing, by assenting to this peace, to secure themselves from that fear, and from the manifest danger, that threatned them from their nearness to **Dublin**, in the protestants hands, and the most considerable place of the kingdom. On the other side, the mere natives promised themselves for the general, by this rebellion, to exchange the throne of England for St. Peter's chair; or at least to shake off the English yoke for that of some foreign prince of their own religion; and in particular the nobility had already devoured in their greedy hopes all the protestants estates; upon whose presumed accession they built strange and imaginary castles in the air. And the clergy, the main firebrand of this rebellion, expected no less than to be reinstated into their ancient possessions; so that both these latter parties being thus frustrated of their hopes, endeavour to foment among the people (very fit tinder to catch at such a fire) a dislike of the present peace, which the former oppose by their authority, and the latter by thundering out excommunications against all those, that do act; a course, that has a strange influence upon that kind of people, whose superstition makes them believe a reality of force in those scare-crow-thunderbolts, that derive all their power only from the people's weakness, and are terrible for nothing, but because they are pleased to fear them.
> 
> 
> This day with kingly state was buried the great **earl of **Essex****, having 400 officers, not one so low as a captain, the house of peers, the house of commons, the city, and the assembly of divines, for his mourners, and all the other parting compliments of honour, that ever subject could aspire unto. His sickness was an apoplexy, which did not long make him linger; and thus he, that had escaped so many mutinies, at last perished by a mutiny of the humours. But I have usually observed, that in these great funeral solemnities, the pageantry of sorrow has eaten up the reality; and the care of the blaze diverted men from mourning. Besides these costly flatteries of the dead (with neglect of the poor, whom that charge might keep alive) seem to endeavour to make them guilty of prodigality in their very graves, whilst it wastes that upon a senseless carkass, that is to it as useless, as it is needless; whereas it were much better for them to procure the prayers of the living, than their admiration.
> 
> 
> My **lord of **Inchiquin****'s absence from **Munster**, the greater part of this summer, by leaving my brother **Broghill** the sole command of his army, gave him an opportunity to manifest to the world his gallantry, which he did with an unwonted success; and that no less constant than it was great. But his own wants at home at last reduced him to that starving condition, that when he prayed for his daily bread, his request reached at least as far as his expectation. He is now there soliciting for supplies for distressed **Munster**, which, though 
> 
> 
> 
> ---
> 
> p.19
> 
> 
> 
> very liberally voted, are so slow in their dispatch, that many think they have just cause to apprehend, that the physic will not get thither, before the patient be dead. His actions have hereby gained him a general esteem; and he has (if he were not my brother, I durst say deservedly) acquired the repute of none of the least wits of the time. He and I within these ten days intend, God willing, for the West, in order to his journey to **Munster**, whither he is now to carry over, under his own command, a gallant brigade of 4000 effective foot and 1500 horse, for the parliament, in that province, till the ensuing spring enable them to transport thither a more considerable power.
> 
> 
> The presbyterian government is at last settled (though I scarce think it will prove long lived) after the great opposition of many, and to their no less dislike; though it seemed very high time unto others, that some established and strict discipline should put a restraint upon the spreading impostures of the sectaries, which have made this distracted city their general rendezvous, which entertains at this present no less than 200 several opinions in point of religion, some digged out of those graves, where the condemning decrees of primitive councils had long since buried them; others newly fashioned in the forge of their own brains; but the most being new editions of old errors, vented with some honourable title and modern disguisements; so that certainly if the truth be any where to be found, it is here sought so many several ways, that one or other must needs light upon it*.* But others, that justly pretend to a greater moderation, suspect, that our dotage upon our own opinions makes us mistake many for impostures, that are but glimpses and manifestations of obscure or formerly concealed truths, or at least our own pride and self-love make us aggravate very venial errors into dangerous and damnable heresies. The parliament is now upon an ordinance for the punishment of many of these supposed errors; but since their belief of their contrary truths is confessedly a work of divine revelation, why a man should be hanged, because it has not yet pleased God to give him his spirit, I confess, I am yet to understand. Certainly to think by a halter to let new light into the understanding, or by the tortures of the body to heal the errors of the mind, seems to me like the applying a plaister to the heel, to cure a wound in the head; which doth not work upon the seat of the disease.
> 
> 
> My brother **Broghill** continues very much your friend, and, I am confident, will be very ready upon occasion to realize his professions; and the like I dare boldly affirm of my sister **Ranelagh**. An employment fit for you we cannot yet procure, because all our nobility stands at a gaze, to see whether the issue of the treaties now in debate will be either peace or war; in either of which cases it is probable, that a good many of them will make visits to foreign climates.
> 
> 
> The sadness of your condition I very much resent, and would offer you my assistance to sweeten it, if I did not think the proffer superfluous; but truly I believe it would less afflict you, if you were a spectator of our miseries here, where every day presents us with much more unusual dispensations of providence, where I myself have been fain to borrow money of servants, to lend it to men of above 10,000 *l.* a year.
> 
> 
> I was yesterday in company with our Irish St. Austin, the archbishop of Armagh; and having told him, that you unfolded his mystery of the Incarnation in French, he seemed very willing, that you should publish it, upon the assurance I gave him of the fidelity of its translation. [*...*]
> 
> 
> And now it is high time I should give you some account both of myself and of my condition; which truly hath been chequered with a great deal of variety of fortune, and a great many vicissitudes of plenty and want, danger and safety, sickness and health, trouble and ease; wherein I were guilty of an ingratitude great as the favour I have received, if I did not acknowledge a great deal of mercy in God's dispensation towards me; which truly hath been so kind, as oftentimes to work my good out of those things I most feared the consequences of, and changed those very dangers, which were the object of my apprehension, into the motives of my joy. I was once a prisoner here upon some groundless suspicions, but quickly got off with advantage. The roguery of Tom Murray gave me a great deal of trouble to discover and prevent; but I thence reaped the benefit of making further discoveries into oeconomical knowledge, than ever otherwise I should have done. I turned him away last year, to let him know, that I could do my business very well without him; but now, having attained to a knowledge of my own small fortune beyond the possibility of being cheated, I am likely to make use of him again, to shew my father's servants, that I wish no hurt to the man, but to the knave.
> 
> 
> I have been forced to observe a very great caution, and exact evenness in my carriage, since I saw you last, it being absolutely necessary for the preservation of a person, whom the unfortunate situation of his fortune made obnoxious to the injuries of both parties, and the protection of neither. Besides I have been forced to live at a very high rate, (considering the inconsiderableness of my incomes) and, to furnish out these expences, part with a good share of my land, partly to live here like a gentleman, and partly to perform all that I thought expedient in order to my Irish estate, out of which I never yet received the worth of a farthing.
> 
> 
> As for my studies, I have had the opportunity to prosecute them but by fits and snatches, as my leisure and my occasions would give me leave. Divers little essays, both in verse and
> 
> 
> 
> ---
> 
> p.20
> 
> 
> 
> prose, I have taken the pains to scribble upon several subjects; some of the least bad of which I shall venture to send you over, as soon as my next vacation spares me time to lick them into some less imperfect shape.
> 
> 
> The Ethics hath been a study, wherein I have of late been very conversant, and desirous to call them from the brain down into the breast, and from the school to the house. I have endeavoured to make it not only a lanthorn, but a guide, in a just, though a brief treatise, that I am writing of it; having already with much trouble in some sixteen chapters travelled through the most difficult part of it, and that wherein I saw others deficient, I believe I shall leave the rest to be compleated by those, who enjoy more leisure.
> 
> 
> The other humane studies I apply myself to, are natural philosophy, the mechanics, and husbandry, according to the principles of our new philosophical college, that values no knowledge, but as it hath a tendency to use. And therefore I shall make it one of my suits to you, that you would take the pains to enquire a little more thoroughly into the ways of husbandry, &c. practised in your parts; and when you intend for England, to bring along with you what good receipts or choice books of any of these subjects you can procure; which will make you extremely welcome to our **invisible college**, which I had now designed to give you a description of, but a gentleman, whom I have been forced to keep talk with all the while I was writing this, together with the fear of having too much already trespassed upon your patience, call upon me to end your trouble and this letter together.
> 
> 
> 




He was likewise at **London** in February 1646–7, whence he wrote the following letter, dated the 20th of that month, to Mr. Francis Tallents, then fellow of Magdalen college in Cambridge.


> Sir,
> I should venture to apologize for my silence, if I thought it not less guilty than meritorious; since to reprieve you from the importunity of my letter, I have hitherto denied myself that happiness, that your civility makes me confident I might have enjoyed by the receiving of yours. I have been every day these two months upon visiting my own ruined cottage in the country; but it is such a labyrinth this **London**, that all my diligence could never yet find the way out on't, and hath but just now put me in a probability of leaving it within these two or three days. The best on't is, that the corner-stones of the invisible, or (as they term themselves) the **philosophical college**, do now and then honour me with their company, which makes me as sorry for those pressing occasions, that urge my departure, as I am at other times angry with that solicitous idleness, that I am necessitated to during my stay; men of so capacious and searching spirits, that school-philosophy is but the lowest region of their knowledge; and yet, though ambitious to lead the way to any generous design, of so humble and teachable a genius, as they disdain not to be directed to the meanest, so he can but plead reason for his opinion; persons, that endeavour to put narrow-mindedness out of countenance, by the practice of so extensive a charity, that it reaches unto every thing called man, and nothing less than an universal good-will can content it. And indeed they are so apprehensive of the want of good employment, that they take the whole body of mankind for their care.
> 
> 
> But lest my seeming hyperbolical expressions should more prejudice my reputation than it is able any ways to advantage theirs, and I be thought a liar for telling so much truth, I will conclude their praises with the recital of their chiefest fault, which is very incident to almost all good things; and that is, that there is not enough of them.
> 
> 
> For news, I believe you do not ignore, what a stream of success the parliament, since I had the honour to see you, has had. I will only now take the freedom to tell you, that I am greatly afraid, most men flatter themselves in their prognostications of peace, which are calculated rather to the meridian of their desires, than to that of their reason. And though I must confess, the traveller seems to be very near the inn, yet I know not why the horse may not stumble at the threshold; for I am somewhat unapt to persuade myself, that the judgment will cease, while the cause continues; but am rather very ready to apprehend, that while adversity makes some obstinate, and others wanton, though the war perhaps may die, the judgment will be kept alive. The pulpits were never more adorned with excellent divines, than they now are here, but with so unsuitable a success in many of the people, that I can sometimes think it no breach of charity to believe, that the small-pox has stricken inward, and many of them have but banished their vices from the body into the heart. For my part, the excellency of the ministry, since waited on by such an improficiency, increases my presaging fears of the approaching misery of the people; for I shall easily be drawn to suspect that horse to be very sick, that thrives not in so plentiful a pasture. And truly, methinks, it is but a very sad symptom, when the physic augments the disease. For matter of sects, it seems, that most of those at Amsterdam have been returned us over by bill of exchange, which our English searchers have been so industrious to improve, that there are few days pass here, that may not justly be accused of the brewing or broaching of some new opinion. Nay, some are so studiously changling in that particular, they esteem an opinion as a diurnal, after a day or two scarce worth
> 
> 
> 
> ---
> 
> p.21
> 
> 
> 
> the keeping. If any man have lost his religion, let him repair to **London**, and I'll warrant him, he shall find it: I had almost said too, and if any man has a religion, let him but come hither now, and he shall go near to lose it. Pray God, it fare not with religion amongst those novelties, as it does sometimes with a great commander, when he is taken prisoner by a company of common soldiers, who every one tugging to have him for himself, at last pull him to pieces, and so each get a limb, but none enjoys him whole. For my part, I shall always pray to God to give us the unity of the spirit in the bond of peace, and desire you to believe, that, amongst all the apostasies of the time, I shall be the least capable of being seduced by that, that may oppose my being and continuing so,
> 
> 
> Your most affectionate friend and faithful servant,
> 
> 
> Robert Boyle.




Mr. Tallents, to whom this letter was written, had been, while he was an under-graduate, sub-tutor to several sons of the earl of Suffolk (one of whose daughters was married to **lord Broghill**,) being removed from Peter house to Magdalen college, for that purpose; and about the year 1642 travelled abroad with them as their tutor. After his return, he became senior fellow and president or vice-master of his college; and having spent near twenty years in the university, was settled of St. Mary's in Shrewsbury, whence he was ejected for nonconformity in 1662. In the year 1670 he went a second time as tutor to two young gentlemen, Mr. Bascawen and Mr. Hamden. In the last part of his life he was pastor to a congregation of protestant dissenters at Shrewsbury, where he died April 11th, 1708, in the 89th year of his age. He was author of the Chronological Tables.


Mr. Boyle returned to **Stalbridge** soon after his writing the abovementioned letter to Mr. Tallents, as appears from one to his sister, the **lady Ranelagh**, dated there Feb. 27, 1646-7, in which he writes as follows:

> 
> [*...*]As to my **Dublin** business, I must expect from your speedy information (I now beg of you) of their names, to whom the parliament has given power to oblige me there, directions both how to frame, and to whom to address my request. I must acknowledge to you, amongst God's mercies of the first magnitude, both my **lord of **Ormonde****'s unexpected coming in, and the parliament's less expected dispatch; though both very consonant to the wonted method of that gracious providence, that we find then oftentimes the nearest for our rescue, when that is furthest from our expectations. For my part, I am bold to believe, had we no other arguments to prove a providence, yet the strange revolutions, of which in so short a time our ruined country has been the unhappy scene, were more than sufficient to demonstrate that truth, to which alone I shall allow a greater infallibility, than to that other most certain one of my being, 
> 
> 
> Sister, your most truly affectionate brother and humblest servant,
> Robert Boyle.




His next letter, dated from the same place, March 6, 1646-7, shews, that he was then entering upon his chemical studies.

> 
> [*...*]‘That great earthen furnace, says he, whose conveying hither has taken up so much of my care, and concerning which I made bold very lately to trouble you, since I last did so, has been brought to my hands crumbled into as many pieces, as we into sects; and all the fine experiments, and castles in the air, I had built upon its safe arrival, have felt the fate of their foundation. Well, I see I am not designed to the finding out the philosophers stone, I have been so unlucky in my first attempts in chemistry. My limbecks, recipients, and other glasses have escaped indeed the misfortune of their incendiary, but are now, through the miscarriage of that grand implement of Vulcan, as useless to me, as good parts to salvation without the fire of zeal. Seriously, madam, after all the pains I have taken, and the precautions I have used, to prevent this furnace the disaster of its predecessors, to have it transported a thousand miles by land, that I may after all this receive it broken, is a defeat, that nothing could recompence, but that rare lesson it teaches me, how brittle that happiness is, that we build upon earth.’
> 
> 
> 




His acquaintance with **Mr. Samuel Hartlib** began very early. The father of that gentleman was a very considerable merchant in Poland, but obliged, on account of his attachment to the protestant religion to retire to **Elbing** in **Prussia**. His two first wives were Polish ladies, of noble extraction, and his third, the mother of **Mr. Samuel Hartlib**, had two sisters, both of whom were very honourably married, one to Mr. Clarke, the son of a lord mayor of **London**, afterwards to Sir Richard Smith, a privy counsellor, and at last to Sir Edward Savage; and the



---

p.22



other to Mr. Peake, a younger brother of a good family. Mr. Hartlib, Mr. Boyle's friend, came to England about the year 1630; and soon distinguished himself by his great zeal for the improvement of natural knowledge, and making it useful to human life. For which purpose, besides what notices he could procure at home, he entertained a constant correspondence with the **virtuosi** in most other parts of Europe; and **Milton**, in his Tractate of Education, which he addressed to him, speaks of him, as ‘a person rent hither by some good providence from a far country, to be the occasion and the incitement of great good to this island.’ He observes likewise himself in his letter to **Dr. Worthington** abovecited, that ‘as long as he had lived in England, he had spent yearly out of his own betwixt three and four hundred pounds sterling. And when,’ says he, ‘I was brought to publick allowance, I have had from the parliaments and councils of state a pension of three hundred pounds sterling a year, which as freely I have spent for their service and the good of many.’ But notwithstanding the eminent advantages, which the public had reaped from his writings, and the assistances he had given to those of other men, he was reduced, after the Restoration, to very necessitous circumstances, as appears from the letters of **Dr. Worthington** to him, published at the end of that divine's Miscellanies, and from a petition of Mr. Hartlib to the house of commons, that ‘he might find from their goodness and bounty some relief in his distressed condition, by being freed from his debts, and put in a capacity to continue his service to the public, to advance in his generation the best objects for the use of mankind in all kinds.’


The first letter I find of Mr. Boyle to him was dated from **Stalbridge**, March 19, 1646-7.


> Dear Mr. Hartlib,
> I need a great deal of rhetoric to express to you, how great a satisfaction I received in the favour of your letter, both for the sake of the theme, and more for that of the author. But my contentment was greatly qualified by the miscarriage of the general writing (which should be stiled the Universal Truchman, or General Interpreter, if I were to be godfather) you were pleased to send me; for the commendations you give it are too great not to make me very sensible of its loss. If the design of *the Real Caretaker* take effect, it will in good part make amends to mankind for what their pride lost them at the tower of Babel. And truly, since our arithmetical characters are understood by all the nations of Europe the same way, though every several people express that comprehension with its own particular language, I conceive no impossibility, that opposes the doing that in words, that we see already done in numbers. As for the **pneumatical engine**, that I use to call a wind-gun, which you mention in your letter as presented to the king, and forbidden by him to have any companions, sure the artist, that received the command, was more ingenious than obedient; for I remember very well to have seen one of them not exceeding in bigness, nor differing much in shape from an ordinary carabine, which being charged by the sole impression of the air, would, by violence of the contracted Boreas, send forth a leaden bullet, just the caliber, with force to kill a man at twenty five or thirty paces distance from him. This wind-gun I saw both charged and discharged; and now it comes into my mind, I read, not long since, in a late mechanical treatise of the excellent **Mersennus**, both the construction and the use of this engine; and amongst the uses one, whose stratagem obliged me to take of it particular notice; and it was, how by the help of this instrument to discover the weight of the air; which, for all the prattling of our book-philosophers, we must believe to be both heavy and ponderable, if we will not refuse belief to our senses. Your Imago Societatis, and your Dextera Amoris, I have great longings to peruse; and though with a deep sense of my insufficiency, I shall very freely express my obedience in delivering the opinion of
> 
> 
> Your humble servant,
> Robert Boyle.




The next letter extant to that gentleman is of the 8th of April, 1647.


> Dear Mr. Hartlib,
> I hope I shall need none other apologies for my last week's silence, than my absence hence, when your letters arrived here. Your Imago Societatis with a great deal of delight I have perused, but must beg some leisure to acquaint you with my opinion of it, which now were almost impossible for me to do, I having already presented it to a person of quality, with whom if it take suitably to my wishes, it may thence have no obscure influence upon the public good, concerning which I have lately traced a little dialogue in my thoughts, which my unceasing domestic distractions will by no means as yet permit me to blot paper with. The epistle prefixed to the Imago is both pithy and to the purpose. And truly I am extremely glad to see a person of **Mr. Hall**'s years employ, in attempts of this nature, that 
> 
> 
> 
> ---
> 
> p.23
> 
> 
> 
> youth, which the most of those, that are as little indebted to time as he, think too good for their Maker, though they think it not too good to be squandered away. **Campanella**'s Civitas Solis[10](javascript:footNote('E650001-100/note010.html')), and that same Respublica Christianopolitana[11](javascript:footNote('E650001-100/note011.html')), which he mentions, will both of them deserve to be taught in our language. Of the Utopia he is modelling, though I cannot judge, before it sees the light, yet my expectations will be none of the smallest, if I proportion them to the ingenuity of the author. And for the Divine Emblems, that he makes us hope for, I must reserve my sense of them for their perusal, since the opinions I embrace, both about the nature and the teaching of virtue, will doubtless appear as paradoxical to others, as they seem probable to me. For those designs of **Mr. Hall**'s Tutor, which you have so appropriatingly christened, I believe the requests of the excommunicated petition now on foot in the army will scarce receive a slower satisfaction; for the particulars, in which he requires it, do not only ask a profound knowledge and solid judgment (qualities of themselves not very epidemical) but likewise a leisured and a great multiplicity of reading, and so an intimacy as well with authors as with things; qualities, that in this stirring and necessitous age (where men are forced to court don Plutus and my lady Fortune with more of assiduity than the Muses) make very unfrequent matches in the self-same person: besides that the dissenting opinions of the Ptolemeans, the Tychonians, the Copernicans, (to which I was once very much inclined,) and the other novelists, are both so irreconcilable among themselves, and leave a man so little latitude of neutrality, that it will be perhaps but one remove from impossible, precisely to declare, what has been hitherto both perfectly demonstrated and confessedly on all sides; the one taking that (as I have known by experience, when I studied that problem of the earth's peregrination) for an undeniable demonstration, which the other will either absolutely reject as a paralogism, or at least call in question, as no more than a bare probability.
> 
> 
> Your Common Writing (for which you have my humble thanks) is at last come safe to my hands; but my occasions have not yet allowed the leisure to fix my thoughts upon it: only if the dictionary (whose edition, had my wishes the power to swiften it, should be very sudden) do not over-swell and disease it of a tympany, methinks the bulk of the grammar is very reasonable in reference to what the title promises, which I was well pleased to fee so, apprehending (nor are my fears yet entirely suppressed) lest that this way of saving the labour of learning a language should prove like a new device, I have lately seen, to perform all the operations of arithmetic by the help of an instrument, where I found it much more difficult to learn the uses of the instrument, than the rules of the art.
> 
> 
> That in my last I took no notice of **Mr. Dury**'s excellent discourse of teaching logic, was not at all my neglect, but the treacherousness of my memory; for which meaning to apologise to the author himself, I shall for this time add no more to your trouble, but an humble request to assure him, that I am his, and yourself, that I am
> 
> 
> Your most really affectionate friend and humble servant,
> ROBERT BOYLE.




The letter, which he wrote on the 3d of May, 1647, to **Mr. John Dury**, famous for his attempts to reconcile the Lutherans and Calvinists, will shew Mr. Boyle's moderation, at that time, with respect to differences in religious opinions.


‘It has been long,’ says he, ‘as well my wonder, as my grief, to see such comparatively petty differences in judgment make such wide breaches and vast divisions in affection. It is strange, that men should rather be quarrelling for a few trifling opinions, wherein they dissent, than to embrace one another for those many fundamental truths, wherein they agree. For my own part, in some two or three and forty months, that I spent in the very town of **Geneva**, as I never found that people discontented with their own church-government (the gallingness of whose yoke is the grand scare-crow, that frights us here;) so could I never observe in it any such transcendent excellency, as could oblige me either to bolt heaven against, or open Newgate for all those, that believe they may be saved under
another. Wherefore I must confess, it would be extremely my satisfaction, if I could see, by God's blessing, your pious endeavours of twisting our froward parties into a moderate and satisfactory reconcilement, as successful, as I am confident they will be prudent and unwearied. As for our upstart sectaries (mushrooms of the last night's springing up) the worst part of them, if not exasperated by, instead of lighting them into the right way with the candle, flinging the candlestick at their heads, like Jonah's gourd, smitten at the root with the worm of their irrationality, will be as sudden in their decay, as they were hasty in their growth; and indeed perhaps the safest way to destroy them is rather to let them die, than attempt to kill them.’


On the 8th of the same month he wrote the following letter to Mr. Hartlib.



---

p.24



> Dear Mr. Hartlib,
> It was very needless in your last to make apologies for the glad parliamentary news you began your letter with; for besides that its goodness authorises its nature, and were able to prefer so pleasing a disobedience to the most exact compliance with my desires; besides this, I say, you interest yourself so much in the **Invisible College**, and that whole society is so highly concerned in all the accidents of your life, that you can send me no intelligence of your own affairs, that does not (at least relationally) assume the nature of *Utopian*. And truly, Sir, for my particular, had you been to coin and shape news, not so much to inform, as to delight me, you could scarce have made choice of any, that were more welcome, either to my wishes for their own particular satisfaction, or for those, that I dedicate to the good of the public, which can acknowledge your merits with no advantage, that has not a direct tendency to its own, and which, by the highest expressions of gratitude for your service to it, does but enable your zeal to multiply and continue them. The phrases of the ordinances (which these alone of yours have brought me into charity with again) were indeed extremely civil in respect of those, that framed them; and yet but barely just in regard of him, for whom they were designed. Certainly the taking notice of, and countenancing men of rare industry and publick spirit, is a piece of policy as vastly advantageous to all states, as it is ruinously neglected by the most. And therefore we may evidently observe those commonwealths (as the Hollanders and the Venetian) to be the most happy and the most flourishing, where ingenuity is courted with the greatest encouragements. **Mr. Hall**'s unmerited elogium of me I must in justice ascribe rather to his civility, than to his opinion; to the former of which I am also redevable for a very handsom complimental letter, he was lately pleased to honour me with, to which I shall request a speedy conveyance of the inclosed (though unsuitable) answer, and a belief, that I list it not amongst the least of your favours, to procure me the acquaintance of a person, that treading antipodes to the strain of his contemporaries, has September in his judgment, whilst we can scarce find April upon his chin.
> 
> 
> My sense of his propositions concerning the College I must necessarily suspend, till a more exquisite information of the particulars of his whole design. Only by the by I shall take the freedom to tell you, that though I esteem **Mr. Hall** very moderate in the point of pecuniary duties, you can scarce be too tender in tasking young collegiates as to the duties of the brain, since they being all of them to be persons of quality and voluntiers, will hardly support with alacrity any thing, that favours of constraint; besides that the gallantry and nobleness of their own principles will carry them on unimposedly to do much more, than your strictest constitutions can reasonably enjoin them. The expedients you propose to **Mr. Hall**'s tutor are not at all unlikely to take; and the applications you counsel him to make to those three famous mathematicians, can promise a great deal of probability for their success: especially **Gassendus**, a great favourite of mine, I take to be a very profound mathematician, as well as an excellent astronomer, and one, that has collected a very ample treasury of numerous and accurate observations of all, that belongs to the abstruse science of those sublimer bodies.
> 
> 
> I find you very happy, or rather very judicious, in the nominating of the persons, **Mr. Hall**'s tutor is by you addressed to; and am confident, as well as you, that those elevated spirits will not prove half so costive and so pedantical, as the great scholarians of our colleges, whom yet I am apt enough to pardon, in consideration of the usefulness (for the most part) of the knowledge they conceal, which perhaps being admired but as long as kept in a mystery, an imparting discovery would depreciate.
> 
> 
> The rise you have now to resume your former correspondencies with the great **Mersennus**, I hope you will greedily embrace, he being a man truly incomparable in his own way, and the mechanics he transcends in as greatly beneficial as little understood. The Englishing of, and additions to **Oughtred**'s Clavis Mathematica[12](javascript:footNote('E650001-100/note012.html')) does much content me, I having formerly spent much study on the original of that algebra, which I have long since esteemed a much more instructive way of logic, than that of Aristotle. No body has yet been charitable enough to send me either the long desired Office of Address[13](javascript:footNote('E650001-100/note013.html')), or **Mr. Dury**'s wished for discourse concerning Accommodation, though my longings for their sight have been very suitable to the contentments I expect from their perusal. I have written a long letter to **Mr. Dury**, by the same post, that is to deliver you this; and it shall not be the neglect of my improving my rhetoric to the uttermost, that shall impede my prevailing with him, by exemplifying his rules, to clothe with flesh and skin his excellent sceleton of the Art of Reasoning.
> 
> 
> For your bedfellow's receipt for the stone (which certainly wants a parallel, if it be not more easy than effectual) I beseech you to return her (together with the present of my humble service) most humble thanks, which I mean very shortly, God willing, to pay you in an epistle I have drawn up to persuade men to communicate all those successful receipts, that relate either to the preservation or recovery of our health, to which (if you will pardon me a clinch) I shall add, as to the disease last named (so cruel in its tortures, and so fatal in its catastrophe) that they must have their hearts more hard than a very stone, that can refuse a sanative remedy for the stone.
> 
> 
> 
> 
> ---
> 
> p.25
> 
> 
> As for me, during my confinement to this melancholy solitude, I often divert myself at leisure moments in trying such experiments, as the unfurnishedness of the place, and the present distractedness of my mind, will permit me; which when once my vacant intervals of time will give me leave to blot paper with, and make some short discourses and reflections upon, you may (with all the services you shall be pleased to command their author) confidently expect from,
> 
> 
> Sir, your most affectionate friend and humble servant,
> Robert Boyle.














