

#Against Home Rule: the case for the Union


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Against Home Rule: the case for the Union
=========================================


Author: Arthur J. Balfour (et al.)
----------------------------------


### File Description

Electronic edition compiled by Aoife O'Brien, Beatrix Färber

proofread by Audrey Murphy, Aoife O'Brien, Beatrix Färber

 2. Second draft, revised and corrected.Extent of text: 104100 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2006) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E900031Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Literature**2. Pamphlets: A list of pamphlets relating to Home Rule is available on the following webpage maintained by the London School of Economics: http://www.lse.ac.uk/library/pamphlets/IssuesinBritishHistory/IssuesinBritishHistoryPamphlets/home\_rule\_for\_ireland\_scotland\_and\_wales.htm
3. Home government for Ireland: being a series of articles reprinted from "The Cork examiner", by John Francis Maguire. 1872.
4. Isaac Butt, Address to the people of Ireland. 1873.
5. Isaac Butt, Home government for Ireland. Irish federalism! Its meaning, its objects, and its hopes. (3rd ed. Dublin 1870; 4th ed. Dublin 1874).
6. Isaac Butt's speech proposing Home Rule, 30 June 1874, Hansard iii vol 220 700–717.
7. Proceedings of the Home Rule Conference held at Dublin on 18th, 19th, 20th and 21st November 1873 ... (Dublin, 1874).
8. H. de F. Montgomery, Correspondence with Mr. Gladstone and notes on the pamphlet, "Gladstone & Burke". 1884.
9. Thomas Maguire. England's duty to Ireland, as plain to a loyal Irish Roman Catholic. 1886.
10. A.V. Dicey. England's Case Against Home Rule (London 1886), reprinted 1986.
11. J. Middleton. An Englishman's plea for Home Rule. 1886.
12. Isaac Butt, Facts for Mr. Parnell's Bill: a speech delivered in the House of Commons, on 21st September, 1886. 27 pp.
13. W.R. Young. Arguments in support of Home Rule. 1893.
14. "The Economist" on the Irish government bill of 1893: a series of articles dealing with the financial aspect Home Rule (Dublin: The Irish Unionist Alliance, 1893). [Reprinted from "The Economist" Feb. 18th to May 6th, 1893.]
15. An examination of the Home rule bill of 1893: With an appendix containing the full text of the measure itself. (Dublin: Liberal union of Ireland, 1893.)
16. John E. Redmond. Historical and political addresses 1883–1897. 1898.
17. T.W. Russell. England's opportunity in Ireland. 1902.
18. Alice Effie Murray, A History of the Commercial Relations between Great Britain and Ireland, London 1903, 1907. (Reprinted New York 1970).
19. The ABC of home rule in three parts, 1911, Unionist Association of Ireland.
20. Erskine Childers. The Framework of Home Rule. 1911.
21. Aspects of Home Rule, selected from the speeches of Arthur Balfour. 1912
22. Is Ulster right? A statement of the question at issue between Ulster and the Nationalist Party ... by an Irishman. (London: John Murray 1913).
23. William O'Brien. Grattan's Home Rule, Gladstone's, and Asquith's: an answer to a boast. 1915.
24. W.E. Gladstone, speech introducing the First Home Rule Bill, 8 April 1886 (Hansard iii vol. 304 1036 ff, reprinted in A.Tilney Bassett Gladstone: Speeches, Descriptive Index and Bibliography (London 1916).
25. Sir Horace Plunkett, Home Rule and conscription (Dublin: Talbot, 1918).
26. T. M. Healy, Letters and leaders of my day (2 vols, London 1928).
27. Godfrey Vincent de Clinton Parmiter. Roger Casement. London: A. Barker, 1936.
28. J. L. Hammond, Gladstone and the Irish Nation (London 1938).
29. Terence de Vere White, The road to excess (Dublin 1946).
30. Hugh Shearman, Anglo-Irish relations. London: Faber, 1948.
31. Gerard Anthony Hayes-McCoy. 'Robert Louis Stevenson and the Irish question'. Studies; an Irish quarterly review, 39 (1950).
32. Harford Montgomery Hyde. Carson: the life of Sir Edward Carson, Lord Carson of Duncairn. London: Heinemann, 1953.
33. Conor Cruise O'Brien, Parnell and his party, 1880–90 (Oxford 1957).
34. Lawrence John McCaffrey. 'Isaac Butt and the Home Rule movement: a study in conservative nationalism'. Review of Politics 22 (1960).
35. Lawrence John McCaffrey, 'Irish Federalism in the 1870's: a study in conservative nationalism', Transactions of the American Philosophical Society, NS, 52 (1962), Part 6.
36. F. S. Leland Lyons, The fall of Parnell, 1890–91 (London 1960).
37. L. P. Curtis, Coercion and conciliation in Ireland, 1880–1892: a study in conservative unionism (Princeton NJ 1963).
38. David Thornley, Isaac Butt and Home Rule (London 1964).
39. A. T. Q. Stewart, The Ulster crisis: resistance to Home Rule, 1912–1914 (London 1967), repr. Belfast 1997.
40. F. S. Leland Lyons. 'The two faces of home rule'. In Nowlan, Kevin Barry, The Making of 1916: studies in the history of the Rising (Dublin: The Stationery Office, 1969).
41. J. C. Beckett, 'Carson: unionist and rebel', in his Confrontations: studies in Irish history (London 1972).
42. Patrick Buckland, Irish Unionism, 1885–1923: a documentary history (Belfast 1973).
43. Ian Dalton. 'Southern Irish Unionism: a study of Cork Unionists, 1884–1914'. Transactions of the Royal Historical Society, 5th ser., 23 (1973).
44. F. S. Leland Lyons, Charles Stewart Parnell (London 1977).
45. R. A. Cosgrove, 'The relevance of Irish history: the Gladstone-Dicey debate about home rule, 1886–87'. Éire-Ireland, 13:4 (1978).
46. MacDonagh, Oliver. 'The last bill of pains and penalties: the case of Daniel O'Sullivan, 1869'. Irish Historical Studies, 19:74 (1974), 136–55.
47. Robert Fitzroy Foster. 'Parnell and his people: the ascendancy and home rule'. Canadian Journal of Irish Studies, 6 (1980).
48. Owen Dudley Edwards. 'Divided treason and divided loyalties: Roger Casement and others'. Transactions of the Royal Historical Society, 5th ser., 32 (1982)
49. James Loughlin, Gladstone, Home Rule, and the Ulster Question, 1882–93 (Dublin 1986)
50. Alan O'Day, Parnell and the first Home Rule episode 1884–87 (Dublin 1986).
51. William Michael Murphy, The Parnell myth and Irish politics 1891–1956 (New York 1986).
52. Paul Bew, Conflict and conciliation in Ireland, 1890–1910: Parnellites and radical agrarians (Oxford 1987).
53. Gearóid Ó Tuathaigh. 'From United Kingdom to divided island: aspects of the Irish experience, 1850–1922'. In: Thomas Bartlett ; Chris Curtin; Riana O'Dwyer; Gearóid Ó Tuathaigh (eds.), Irish studies: a general introduction (Dublin: Gill & Macmillan, 1988) 126–151.
54. Alan O'Day, Irish Home Rule, 1867–1921 (Manchester 1998).
55. Isaac Butt on Rome Rule. Hansard 3 (commons), 3rd series, ccxx, 30th June 1874, in: A. Mitchell & P. Ó Snodaigh (eds.), Irish Political Documents 1869–1916. (Dublin 1989).
56. Gordon Lucy, (ed.). The Ulster covenant: a pictorial history of the 1912 Home Rule crisis. Belfast: Ulster Society, 1989.
57. B. M. Walker. Ulster politics: the formative years, 1868–1886. Belfast, 1990.
58. Alan O'Day. 'Home rule and the historians'. In: David George Boyce; Alan O'Day, (eds.), The making of modern Irish history: revisionism and the revisionist controversy (London and New York: Routledge, 1996).
59. Michael Foy. 'Ulster Unionist propaganda against Home Rule 1912–14'. History Ireland, 4:1 (1996).
60. Derry Kelleher, Home rule as Rome rule: the unspoken unionist and loyalist case (Justice Books, 7). Greystones, County Wicklow: Justice Books, 1997.
61. Margaret O'Callaghan, 'Franchise reform, "first past the post" and the strange case of Unionist Ireland'. Parliamentary History, 16 (1997), 85–106. Publisher: Sutton; Edinburgh University Press.
62. Jeremy Smith. Britain and Ireland: from home rule to independence (Seminar Studies in History). Harlow: Longman, 2000
63. Carla King. 'Defenders of the union: Sir Horace Plunkett'. In Boyce, D. George; O'Day, Alan (ed.), Defenders of the union: a survey of British and Irish unionism since 1801 (London and New York: Routledge, 2001),
64. Gary Peatling. British opinion and Irish self-government, 1865-1925: from unionism to liberal Commonwealth. 2001.
65. Alan Megahey, '"God will defend the right": the protestant churches and opposition to home rule'. In Boyce, D. George; O'Day, Alan (ed.), Defenders of the union: a survey of British and Irish unionism since 1801 (London and New York: Routledge, 2001).
66. Gary Peatling, British opinion and Irish self-government, 1865–1925: from unionism to liberal Commonwealth (Dublin and Portland, Oregon: Irish Academic Press, 2001).
67. David Fitzpatrick, 'The Orange Order and the border'. Irish Historical Studies, 33:129 (2002), 52–67.
68. Brian Girvin, From union to union: nationalism, democracy and religion in Ireland—Act of Union to EU. Dublin: Gill & Macmillan, 2002.
69. Thomas C. Kennedy, 'Tory radicalism and the Home Rule crisis, 1910–1914: the case of Lord Willoughby de Broke'. Canadian Journal of History, 37:1 (2002), 23–39.
70. David George Boyce, 'Ireland and British politics, 1900–1939'. In Wrigley, Christopher John (ed.), A companion to early twentieth-century Britain (Blackwell Companions to British History) (Oxford: Blackwell Publishers, 2003), 102–17.
71. Catriona Burness, 'Strange associations': the Irish question and the making of Scottish unionism, 1886–1918. East Linton: Tuckwell, 2003.
72. Dan Jackson, '"Friends of the Union": Liverpool, Ulster, and Home Rule 1910–1914'. Transactions of the Historic Society of Lancashire & Cheshire, 152 (2003), 101–32. Publisher: Historic Society of Lancashire and Cheshire.
**The edition used in the digital edition**2. Against Home Rule: the case for the Union by Arthur J. Balfour; J. Austen Chamberlain ... (et al.) with an introduction by Sir Edward Carson and preface by A. Bonar Law, M.P.. S. Rosenbaum (ed), first edition [347 pp. Preface 11–14; Contents 15–16; Introduction 17–38; Historical 39; Critical 79; Constructve 223.] Frederick Warne & Company Ltd.London and New York (1912)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


This electronic edition comprises pp 11–14 and 17–347, omitting the Table of Contents on 15–16.


#### Editorial Declaration


##### Correction


Text has been proof-read three times and parsed using Emacs.


##### Normalization


The electronic text represents the edited text. Italicized sections of the text are tagged emph unless they refer to quotes, foreign phrases, names, or titles.


##### Quotation


Direct speech is tagged q. Quotations from written sources are tagged qt and may be included in cit tags. Longer extracts from written sources are treated as embedded texts.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the political tract, div1=the section, div2=the essay, div3=the subsection. Chapters are numbered; page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Names are tagged. This tagging is subject to revision.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: by Arthur J. Balfour et. al.
 (1912) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [FR] Some words and phrases are in French.


##### Language: [GA] Some words and phrases are in Irish.


##### Language: [DE] An occasional word is in German.


### Revision History


* (2010-08-03) Beatrix Färber (ed.)

* File updated, conversion script run, more encoding added; new wordcount made, new SGML and HTML files created.
* (2008-10-15) Beatrix Färber (ed.)

* Header modified, keywords added, file validated.
* (2006-05-15) Beatrix Färber (ed.)

* Remaining tables/graphics inserted; file re-parsed.
* (2006-04-05) Beatrix Färber (ed.)

* File proofed (3); more content markup added; tables/graphics inserted; file parsed; header created; bibliography inserted.
* (2006-01) Aoife O'Brien (ed.)

* Bibliography compiled.
* (2005-10-20) Aoife O'Brien (ed.)

* Text proofed (2), more structural markup added.
* (1997) Audrey Murphy (ed.)

* Text proofed (1), some structural markup applied.
* (1997) Audrey Murphy (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E900031


### Against Home Rule: the case for the Union: Author: Arthur J. Balfour (et al.)




---

p.11


### Preface by the **Right Hon. A. Bonar Law, M.P.**


This book, for which I have been asked to write a short preface, presents the case against Home Rule for Ireland. The articles are written by men who not only have a complete grasp of the subjects upon which they write, but who in most cases, from their past experience and from their personal influence, are well entitled to outline the Irish policy of the Unionist Party.


Ours is not merely a policy of hostility to Home Rule, but it is, as it has always been, a constructive policy for the regeneration of Ireland.


We are opposed to Home Rule because, in our belief, it would seriously weaken our national position; because it would put a stop to the remarkable increase of prosperity in Ireland which has resulted from the Land Purchase Act; and because it would inflict intolerable injustice on the minority in Ireland, who believe that under a Government controlled by the men who dominate the **United Irish League** neither their civil nor their religious liberty would be safe.


To create within the United Kingdom a separate Parliament with an Executive Government responsible to that Parliament would at the best mean a danger of friction. But if we were ever engaged in a great war, and the men who controlled the Irish Government took the view in regard to that war which was taken by the same men in regard to the Boer War; if they



---

p.12



thought the war unjust, and if, as under the last Home Rule Bill they would have the right to do, they passed resolutions in the Irish Parliament in condemnation of the war, and even sent embassies carrying messages of goodwill to our enemy, then this second Government at the heart of the Empire would be a source of weakness which might be fatal to us.


The ameliorative measures originated by **Mr. Balfour** when he was Chief Secretary, and which culminated in the Wyndham Purchase Act, have created a new Ireland. **Mr. Redmond**, speaking a year or two ago, said that Ireland "was studded with the beautiful and happy homes of an emancipated peasantry." It is a true picture, but it is a picture of the result of Unionist policy in Ireland, a policy which **Mr. Redmond** and his friends, including the present Government, have done their best to hamper. The driving power of the agitation for Home Rule has always been discontent with the land system of Ireland, and just in proportion as land purchase has extended, the demand for Home Rule has died down. The Nationalist leaders, realising this, and regarding political agitation as their first object, have compelled the Government to put insurmountable obstacles in the way of land purchase, not because it had not been successful, but because it had been too successful.


The prosperity and the peace of Ireland depend upon the completion of land purchase, and it can only be completed by the use of British credit, which in my belief can and ought only to be freely given so long as Ireland is in complete union with the rest of the United Kingdom. In the present deplorable position of British credit the financing of land purchase would be difficult; but it is not unreasonable to hope that the return to power of a Government which would adopt sane financial methods



---

p.13



would restore our credit; and in any case, the object is of such vital importance that, what ever the difficulties, it must be our policy to complete with the utmost possible rapidity the system of land purchase in Ireland.


It will also be our aim to help to the utmost, in the manner suggested in different articles in this book, in the development of the resources of Ireland. The Nationalist policy, which is imposed also on the Radical Party, is in fact more politics and less industry. Our policy is more industry and less politics. The strongest objection, however, and, in my opinion, the insurmountable obstacle to Home Rule, is the injustice of attempting to impose it against their will upon the Unionists of Ulster. The only intelligible ground upon which Home Rule can now be defended is the nationality of Ireland. But Ireland is not a nation; it is two nations. It is two nations separated from each other by lines of cleavage which cut far deeper than those which separate Great Britain from Ireland as a whole. Every argument which can be adduced in favour of separate treatment for the Irish Nationalist minority as against the majority of the United Kingdom, applies with far greater force in favour of separate treatment for the Unionists of Ulster as against the majority of Ireland.


To the majority in Ireland Home Rule may seem to be a blessing, but to the minority it appears as an intolerable curse. Their hostility to it is quite as strong as that which was felt by many of the Catholics of Ireland to **Grattan**'s Parliament. They, too, would say, as the Catholic Bishop of Waterford said at the time of the Union, that they "would prefer a Union with the Beys and Mamelukes of Egypt to the iron rod of the Mamelukes of Ireland."




---

p.14


The minority which holds this view is important in numbers, for it comprises at the lowest estimate more than a fourth of the population of Ireland. From every other point of view it is still more important, for probably the minority pays at least half the taxes and does half the trade of Ireland. The influence and also the power of the minority is enormously increased by the way in which its numbers are concentrated in Belfast and the surrounding counties.


The men who compose this minority ask no special privilege. They demand only and they will not demand in vain that they should not be deprived against their will of the protection of British law and of the rights of British citizenship.




---

p.41


HISTORICAL
----------


### A Note on Home Rule

### By the Right Hon. **A. J. Balfour, M.P.**


The greater part of the present volume is devoted to showing why this country should not adopt Home Rule; but it is perhaps worth while for the ordinary British citizen to ask himself a preliminary question, namely, why he should be pressed even to consider it. That the establishment of an Irish Parliament must involve doubtful and far-reaching consequences is denied by no one. What then is the prima facie case which has induced many Englishmen and Scotchmen to think that it ought to be seriously debated? If we could erase the past and approach the problem of framing representative institutions in their most practicable shape for the inhabitants of the United Kingdom, who would think it wise to crowd into these small Islands two, or, as some would have it, three, four, or five separate Parliaments, with their separate elections, their separate sets of ministers and Offices, their separate party systems, their divergent policies? Distances are, under modern conditions, so small, our population is so compact, the interests of its component parts are so intimately fused together, that any device at all resembling Home Rule would seem at the best cumbersome, costly, and ineffective; at the worst, perilous to the rights of minorities, the peace of the country, and the unity of the Kingdom. If, then, these common-sense considerations are thrust on one side by so many well-meaning persons, it must surely be because they think that for the destruction of our existing system there is to be found a compelling justification in the history of the past.




---

p.42


I am well aware that many of the persons of whom I am thinking profess to base their approval of Home Rule on purely administrative grounds. The Parliament of the United Kingdom, they say, is overweighted; it has more to do than it can manage; we must diminish its excessive burdens; and we can only do so by throwing them in part upon other and subordinate assemblies. But this, if it be a reason at all, is certainly a most insufficient one. Would any human being, anxious merely to give relief to the House of Commons, adopt so illogical a scheme as one which involves a provincial Parliament in Ireland, and no provincial Parliaments anywhere else; which puts Ireland under two Parliaments, and left the rest of the country under one; which, if Irishmen are to be admitted to the Imperial Parliament, would give Ireland privileges and powers denied to England and Scotland, and, if they are to be excluded from the Imperial Parliament, would deprive Ireland of rights which surely she ought to possess?


Again, if the *administrative* argument was really more than an ornament of debate, would any one select Ireland as the administrative district in which to make trial of the new system? Would any one, in his desire to relieve the Imperial Parliament of some of its functions, select as an area of self-government a region where one part is divided against another by passions, and, if you will, by prejudices, more violent, and more deeply-rooted than those which afflict any other fraction of the United Kingdom, choose that other fraction where, and how, you will?


I take it, then, as certain that in the mind of the ordinary British Home Ruler the justification for Home Rule is not administrative but historical. He pictures Ireland before the English invasion as an organised and independent State, happy in the possession of a native polity which Englishmen have ruthlessly destroyed, now suffering under laws and institutions forced upon her by the conquerors, suitable it may be to men of Anglo-Saxon descent, but utterly alien to the genius and temper of a Celtic population. To him,



---

p.43



therefore, Home Rule presents itself as an act of National restitution.


Personally, I believe this to be a complete misreading of history. It is not denied—at least I do not deny—that both the English and British Governments, in their dealings with Ireland have done many things that were stupid, and some things that were abominable. But among their follies or their crimes is not to be counted the destruction of any such State as I have described; for no such State existed. They did not uproot one type of civilisation in order to plant another. The Ireland with which England had to deal had not acquired a national organisation, and when controversialists talk of *restoring* this or that institution to Ireland, the only institutions that can possibly be *restored*  are in their origin importations from England.


This does not, of course, mean that the English were a superior race dealing with an inferior one. Indeed, there is, in my view, no sharp division of race at all. In the veins of the inhabitants of these Islands runs more than one strain of blood. The English are not simply Teutonic—still less are the Irish Celtic. We must conceive the pre-historic inhabitants both of Britain and of Ireland as subject to repeated waves of invasion from the wandering peoples of the Continent. The Celt preceded the Teuton; and in certain regions his language still survives. The Teuton followed him in (as I suppose) far greater numbers, and his language has become that of a large fraction of the civilised world. But in no part of the United Kingdom is the Teutonic strain free from either the Celtic or pre-Celtic strain; nor do I believe that the Celtic strain has anywhere a predominance such as that which, speaking very roughly, the Teutonic strain possesses in the East of these Islands, or the pre-Celtic strain in the West.


There is, therefore, no race frontier to be considered, still less is there any question of inferiority or superiority. The Irish difficulty, historically considered, arises in the main from two circumstances. The first of these, to which



---

p.44



I have just referred, is that when England began to intervene in the welter of Irish inter-tribal warfare, she was already an organised State, slowly working its way through feudal monarchy to constitutional freedom. The second is that while the religious revolution of the sixteenth century profoundly and permanently affected the larger Island, it left the smaller Island untouched. The result of the first of these has been that Irish institutions, Irish laws, Irish forms of local government, and Irish forms of parliamentary government are necessarily of the English type. The result of the second has been that while no sharp divisions of race exist, divisions of religion have too often taken their place; that in the constitutional struggles of the seventeenth century Ireland was not the partner but the victim of English factions; and that civil war in its most brutal form, with the confiscations and penal laws which followed in its train, have fed, have indeed created, the bitter fiction that Ireland was once a *nation* whose national life has been destroyed by its more powerful neighbour.


To all this it will perhaps be replied that even if the general accuracy of the foregoing statement be admitted (and nothing about Ireland ever *is* admitted), it is quite irrelevant to the question of Home Rule; because what is of importance to practical statesmanship is not what did actually happen in the past, but what those who live in the present suppose to have happened. If, therefore, to the imagination of contemporary Irishmen, Ireland appears a second Poland, statesmen must act as if the dream were fact.


In such a contention there is some element of truth, But it must be observed in the first place that dreams, however vivid, are not eternal; and, in the second place, that while this particular dream endures it supplies a practical argument against Home Rule, the full force of which is commonly under-rated. For what are the main constitutional dangers of creating rival Parliaments in the same State? They are—friction, collision of jurisdiction, and, in the end, national disintegration. Of these, friction



---

p.45



is scarcely to be avoided. I doubt whether it has been wholly avoided in any State where the system, either of co-equal or of subordinate Parliaments, has been thoroughly tried. It certainly was not avoided in the days past when Ireland had a Parliament of its own. It is incredible that it should be avoided in the future, however elaborate be the safeguards which the draughtsman's ingenuity can devise. But friction, in any case inevitable, becomes a peril to every community where the rival assemblies can appeal to nationalist sentiment. The sore gets poisoned. What under happier conditions might be no more than a passing storm of rhetoric, forgotten as soon as ended, will gather strength with time. The appetite for self-assertion, inherent in every assembly, and not likely to be absent from one composed of orators so brilliantly gifted as the Irish, will take the menacing form of an international quarrel. The appeal will no longer be to precedents and statutes, but to patriotism and nationality, and the quarrel of two Parliaments will become the quarrel of two peoples. What will it avail, when that time comes, that in 1912 the Irish leaders declared themselves content with a subordinate legislature? It is their earlier speeches of a very different tenour that will be remembered; and it will be asked, with a logic that may well seem irresistible, by what right Irish ‘nationality’ was ever abandoned by Irish representatives.


On these dangers I do not in this brief note propose to dwell, though it seems to me insane either to ignore them or to belittle them. The point on which I desire to insist is that they arise not from the establishment of a subordinate Parliament alone, nor from the existence of a ‘nationalist’ sentiment alone, but from the action and reaction of the sentiment upon the institution, and of the institution upon the sentiment.


Let me conclude by asking whether Irish history does not support to the full these gloomy prognostications. The Parliament that came to an end at the Union was a Parliament utterly antagonistic to anything that now goes by the name of Irish Nationalism. In every sphere, except



---

p.46



the economic sphere, it represented the forces, political and religious, which the Irish Nationalist now regards as English and alien, and against which, for many years, he has been waging bitter warfare. Yet this Parliament, representing only a small minority of the inhabitants of Ireland, found its position of subordination intolerable. It chose a moment of national disaster to assert complete equality, and so used its powers that at last the Union became inevitable. It is surely no remedy for the ancient wrongs of Ireland—real, alas! though they were—that we should compel her again to tread the weary round of constitutional experiment, and that, in the name of Irish Nationalism, we should again make her the victim of an outworn English scheme, which has been tried, which has failed, which has been discarded, and which, in my judgment, ought never to be revived.




---

p.47


### Historical Retrospect

### By J.R. Fisher

#### Author of The End of the Irish Parliament Editor of Northern Whig)


When **Pitt** commended his proposals for the Union to ‘the dispassionate and sober judgment of the Parliament of Ireland,’ he argued that such a measure was at once ‘transcendently important’ to the Empire, and ‘eminently useful’ to the true interests of Ireland. **Lord Clare**, as an Irishman, naturally reversed the order, but his compelling points were the same:—To Ireland the Union was a ‘vital interest,’ which at the same time ‘intimately affected the strength and prosperity of the British Empire.’ From that day to this the two fundamental arguments for the Union of Great Britain and Ireland have remained unchanged, and they apply with ever-growing force to the existing situation at home and abroad. But the argument from history has, perhaps, been a little neglected of late, and calls for at least a passing notice.


Popular oratory will have it that England has always been keen and aggressive in regard to the incorporation of Ireland within the Empire, but as a matter of fact, the very opposite has been the case. From the time of **Pope Adrian**'s Bull, Laudabiliter, in 1154, which granted to **Henry II.** the Lordship of Ireland, but which Henry left unemployed for seventeen years, to that of the Irish petition for a legislative Union in 1703, which remained unanswered for nearly a century, vacillation and hesitation rather than eagerness for aggression have been the characteristic marks of English policy in Ireland. Far-sighted statesmen could point out the benefits to Ireland from such a connection,



---

p.48



but as a rule it was the presence of actual foreign danger that forced the British Parliament to act. For four centuries the Lordship of the English Kings over Ireland was largely nominal. It was only when the religious quarrels of the sixteenth century became acute that the Tudors already alarmed at the action of the Irish Parliament in recognising and crowning a pretender in Dublin Castle found themselves compelled to assert direct Kingship.


From that time till the legislative Union every enemy of England could safely count on finding a foothold and active friend, in Ireland. It is much too late in the day to indulge in any recriminations on this score. The issues were the most tremendous that have divided Europe; each side was passionately convinced of the rightness and justice of its cause. There were, in **Pitt**'s words relating to a later day, ‘dreadful and inexcusable cruelties’ on the one side, and ‘lamentable severities’ upon the other, just as there were all over Europe. But in the case of Ireland every evil was exaggerated and every danger intensified by the system of dualism which encouraged resistance from within and invited interference from without. For England and English liberty it was more than once a question of existence or extinction, and the knowledge of the constant danger from the immediate west did not tend to sweeten the situation.


In Elizabeth's time the menace was from Spain; Spanish forces twice succeeded in effecting a landing on the Irish coast, and were welcomed by the inhabitants. Spain was then the most powerful enemy of England and of civil and religious liberty all the world over; Elizabeth was declared by the Pope to have forfeited the crown of England, and if the Armada had been successful at sea, the Spanish army in England would have found enthusiastic supporters in Ireland. Later on it was in Ireland, and by the aid of subsidies from an Irish Parliament, that Strafford raised 10,000 men to invade Scotland and England in support of Charles I. against his Parliament, and, incidentally, to drive the Scottish settlers out of Ulster. As the Articles of Impeachment put it, his object in raising the Irish army



---

p.49



was ‘for the ruin and destruction of England and of his Majesty's subjects, and altering and subverting the fundamental laws and established Government of this Kingdom.’ Strafford fell, but the insurrection and massacre of 1641 were the natural result of his intrigues with the Irish Parliament and the Irish chiefs. It was under the impression of this manifest danger that **Cromwell**—a century and a half before his time—abolished the Dublin Parliament and summoned Irish representatives to the first United Parliament at Westminster.


As the power of Spain declined, France came to be the chief menace to England and to the peace of Europe. Again Ireland instinctively allied herself with the enemy. Tyrconnel now played the part of Strafford, and with the aid of French troops and French subsidies, and a sympathetic Irish Parliament, endeavoured to destroy the Ulster Plantation, and make Ireland a jumping-off place for the invasion of England. The Irish Parliament, in the meantime, did its part by confiscating the estates of the settlers, driving out the Protestant clergy, and outlawing English sympathisers by name in *the hugest Bill of Attainder which the world has seen.’’*

J. R.Green, Short History,. chap. ix. sec. 8.

 It was the successful defence of Derry and Enniskillen by the Scotch and English colonists that saved Ireland and gave King William and his troops the foothold that enabled them to save England, too, in the Irish campaign of the following year.


Not the least remarkable instance of the use to which separate Parliaments within the Kingdom could be put for the ruin of England occurred during the activity of James the Second's son, the so-called ‘Old Pretender.’ In 1723 his chief adviser, the Earl of Mar, presented to the Regent of France a memorial setting out in detail a project for betraying Britain into the power of France by dismembering the British Parliament.[1](javascript:footNote('E900031/note001.html')) The Irish Parliament, in close alliance with a restored Scottish Parliament, was to be used to curb the power of England. ‘The people of Ireland and



---

p.50



Scotland,’ according to Mar, ‘are of the same blood and possess similar interests,’ and they should thus always be allied against England and oppose their ‘united strength’—backed, of course, by that of France—to any undue growth of the English power. The scheme came to nothing, but if the Pretender had possessed a little more energy and capacity; if the French Court had been in earnest, and if Ireland and Scotland had each possessed a separate Parliament, ‘with an executive responsible to it,’ and with the control of a national militia, the story of 1745 might have ended differently.


It is necessary that these facts should be kept in mind when complaint is made of the oppressive and demoralising Irish Penal Code. That Code no one defends now, although it was lauded at the time by **Swift** as a bulwark of the Church against the Catholics on the one hand, and the Presbyterians on the other. It was the product of a cruel and bigoted age, and at its worst it was less severe than similar laws prevailing against Protestants in those parts of the Continent where the Roman Church held sway.[2](javascript:footNote('E900031/note002.html')) Spain and France were at that time vastly more powerful, populous, and wealthy countries than England: England was never free from the dread of foreign invasion, and to the would-be invader Ireland always held a guiding light and an open door.


Finally, it must also be remembered that at a time when the chances seemed fairly even, as between **William** and England on the one hand, and **James** and France on the other, the Prince of Orange, accustomed to the German way of settling such differences, had made formal offer to Tyrconnel of a working compromise—the free exercise of their religion to the Irish Catholics: half the Churches of the Kingdom: half the employments, civil and military, if they pleased, and even the moiety of their ancient properties. ‘These proposals,’ says the Chevalier Wogan, Tyrconnel's



---

p.51



nephew and confidant, who is our informant, ‘though they were to have had an English Act of Parliament for their sanction, were refused with universal contempt.’ In other words, the party which with the assistance of France still hoped to obtain all, refused to be content with half. It is true that Wogan, in the letter from which we have quoted,[3](javascript:footNote('E900031/note003.html')) after stating that the exiles, ‘in the midst of their hard usage abroad, could not be brought to repent of their obstinacy,’ justifies their refusal by the way in which the Articles of Limerick were afterwards disregarded by the Irish Parliament. But this is evidently an argument of retrospective invention, and it may fairly be argued that the position would have been very different if peace on equal terms had been made on the direct authority of the King before Aughrim rather than by his deputies after Limerick.


#### The Eighteenth Century


And if the separatist theory has involved, as we have seen, such external dangers to the Empire, the case for the old Irish Parliament from the point of the ‘vital interests ’ of Ireland itself is even weaker. By it the bulk of the Irish people were treated for a century in a fashion described by an Irish Chief Secretary as ‘ingrafting absurdity on the wisdom of England and tyranny on the religion that professes humanity.’ It was conspicuous for its corruption even in a corrupt age, and, as was inevitable, it involved Ireland in constant conflicts with England, conflicts that were vexatious and injurious to both countries. **Swift**, who, amongst those who have not read his works, passes for an Irish patriot, is at his savagest when inveighing against this sham Parliament.[4](javascript:footNote('E900031/note004.html'))

> 1. Its members are, he says—
>   
> ... three hundred brutes
>   
> All involved in wild disputes,
>   
> Roaring till their lungs are spent
>   
> Privilege of Parliament!
> 






---

p.52



And if only the Devil were some day to come ‘with poker fiery red,’ and—

> 1. When the den of thieves is full,
>   
> Quite destroy the harpies' nest,
>   
> How might then our Isle be blest!
> 





Capable observers, from **Swift** to **Arthur Young**, bear continuous testimony to the systematic and habitual corruption of the Irish Parliament. Offices were multiplied and were distributed among clamorous applicants on the ground of family or personal influence, or political support—never by any chance on the ground of merit or capacity. Public money was squandered for private purposes. **Sir George Macartney**, himself an Irishman and a Member of Parliament, in his Account of Ireland, speaking of the year 1745, says—

*The House of Commons now began to appropriate a considerable part of the additional duties to their own use. This was done under pretence of encouraging public works such as inland navigation, collieries, and manufactories of different kinds; but the truth is that most of these public works were private jobs carried on under the direction and for the advantage of some considerable gentlemen in the House of Commons.’’*

 Life of Macartney. , vol. ii., p. 136.




**Arthur Young**, whose careful and impartial study of the state of affairs in Ireland under the Dublin Parliament has become a classic, speaks of the same class of transaction. 

*The members of the House of Commons at the conclusion of the sessions met for the purpose of voting the uses to which this money should be applied: the greater part of it was amongst themselves, their friends or dependents, and though some work of apparent use to the public was always the plea, yet under the sanction there were a great number of very scandalous jobs.’’*

 Tour in Ireland,. vol. ii., p. 123 ff.




Young admits that some useful public work was done, but that most of the money was misappropriated was



---

p.53



matter of common report. After a reference to the construction of a certain canal he adds— 

*Some gentlemen I have talked with on this subject have replied, 'It is a job: 'twas meant as a job: you are not to consider it as a canal of trade, but as a canal for public money!' . . .Sorry I am to say that a history of public works in Ireland would be a history of jobs.’’*

 Tour in Ireland,. vol. ii., p. 123 ff.




Money was voted, he says elsewhere, for—

*Collieries where there is no coal, for bridges where there are no rivers, navigable cuts where there is no water, harbours where there are no ships, and churches where there are no congregations.’’*

 Tour in Ireland,. vol. ii., p. 123 ff.




And when the Union was finally on its way, Hamilton Rowan, one of the founders of the United Irishmen, then in exile in America, wrote home to his father: *I congratulate you on the report which spreads here that a Union is intended. In that measure I see the downfall of one of the most corrupt assemblies, I believe, that ever existed.’’*

Hamilton Rowan's Autobiography. , p. 340


It is little wonder that men of good will in Ireland prayed to be delivered from such a Parliament. Molyneux, the first of the Irish Parliamentary patriots, whose book, The Case of Ireland's being Governed by Laws made in England Stated, was burnt by the common hangman, pleaded indeed for a reformed and independent Parliament, but only because fair representation in the English Parliament was at the time ‘a happiness they could hardly hope for.’ And a few years later the Irish House, in congratulating Queen Anne on the Union of England and Scotland, added, ‘May God put it into your royal heart to add greater strength and lustre to your Crown by a yet more comprehensive Union.’


The English Parliament, through sheer lethargy and carelessness, missed at this time an opportunity which would have peacefully launched Ireland on her career on an equality with Scotland and England, and must have profoundly modified the relations of the two countries. Immediate prosperity, in the case of a land wasted by a century



---

p.54



of strife and bloodshed, was not indeed to be hoped for any more than in the case of Scotland, which had still two armed rebellions, and much bickering and jealousy in store before settling down to peaceful development. But if Ireland had been granted her petitions for Union in 1703 and 1707, and had thus secured equal laws and equal trading privileges, she would at any rate have emerged from her period of trial and discord not later than Scotland, and would have anticipated the economic and social advantages predicted by **Adam Smith**, when he says—

*By a union with Great Britain, Ireland would gain, besides the freedom of trade, other advantages much more important, and which would much more than compensate any increase of taxes that might accompany that union. By the union with England, the middling and inferior ranks of people in Scotland gained a complete deliverance from the power of an aristocracy which had always before oppressed them. By a union with Great Britain, the greater part of the people of all ranks in Ireland would gain an equally complete deliverance from a much more oppressive aristocracy, an aristocracy not founded, like that of Scotland, in the natural and respectable distinctions of birth and fortune, but in the most odious of all distinctions, those of religious and political prejudices. ... Without a union with Great Britain, the inhabitants of Ireland are not likely, for many ages, to consider themselves as one people.’’*

 Wealth of Nations. , Book V., Chap. III


**Pitt**, who was proud to proclaim himself the pupil of **Adam Smith** in politics and in economics, found himself, a quarter of a century after these words were written, in a position to carry out, in face of great difficulties and dangers at home and abroad, the beneficent reform advocated by his great master— a reform which, as we have seen, could have been carried a century earlier without any difficulty whatever. But the century that had been wasted involved many concurrent miseries and misfortunes: social and economic stagnation, an intensification of religious and racial bitterness, conspiracy, and invasion; savage outbreaks savagely repressed. When the time comes to measure up the rights and wrongs of those dark days, the judgment on



---

p.55



England will assuredly be that her fault was not the carrying of the Union, but the delaying of that great measure of reform and emancipation until it was almost too late.


The story of the Union has been told and retold in the utmost detail throughout the century. The present writer has attempted quite recently to summarise it, [5](javascript:footNote('E900031/note005.html')) and there is little to add. The charge that it was carried by corruption is simply another way of saying that it had, constitutionally, to be passed through the Dublin Parliament, that body which, from the days of **Swift**'s invective to those of its final condemnation, lived and moved and had its being solely in and by corruption. As **Lord Castlereagh**, who had charge of the Bill in the Irish House of Commons, put it, the Government was forced to recognise the situation, and its task was ‘to buy out and secure to the Crown forever the fee simple of Irish corruption, which has so long enfeebled the power of Government and endangered the connection.’


#### The Union


The Irish Parliament had run its course, and had involved the unhappy country in chaos, bankruptcy, revolution, and bloodshed. **Lord Clare**—a late and reluctant convert to the policy of the Union—said in the Irish House of Lords (Feb. 10, 1800)—

*We have not three years of redemption from bankruptcy or intolerable taxation, nor one hour's security against the renewal of exterminating civil war. Session after session have you been compelled to enact laws of unexampled rigour and novelty to repress the horrible excesses of the mass of your people: and the fury of murder and pillage and desolation have so outrun all legislative exertions that you have been at length driven to the hard necessity of breaking down the pale of municipal law, and putting your country under the ban of military government—and in every little circle of dignity and independence we hear whispers of discontent at the temperate discretion with which it is administered. ... Look to your civil and religious dissensions. Look to the fury of political faction and the torrents of human blood that stain the face of your



---

p.56



country, and of what materials is that man composed who will not listen with patience and good will to any proposition that can be made to him for composing the distractions and healing the wounds and alleviating the miseries of this devoted nation?’’*


**Lord Clare**'s words—unanswered and unanswerable then and now—constitute a sufficient comment on the foolish fable of later invention, that Ireland was a land of peace and harmony, of orderly government and abounding prosperity, when a wicked English minister came and ‘stole away the Parliament House’—since which all has been decay and desolation. The halcyon period is generally made to coincide with that of ‘**Grattan**'s Parliament’—of the semi-independent and quite unworkable Constitution of 1782, which had been extorted from England's weakness when Ireland was denuded of regular troops, and at the mercy of a Volunteer National Guard, when **Cornwallis** had just surrendered at Yorktown, and Spain and France were once more leagued with half Europe for the destruction of the British Empire.


It is quite true that the latter part of the eighteenth century was, on the whole, a time of considerable prosperity to certain classes in Ireland—a prosperity varied by periods of acute depression and distress. But that prosperity, such as it was, neither began with **Grattan**'s Parliament nor ended with it—had, indeed, no more connection with the Irish Parliament in any of its phases than had the Goodwin Sands with Tenterden steeple. With the exception of the respite between the Treaty of Versailles and the outbreak of the French Revolution, England was almost constantly at war, or feverishly preparing for war. Simultaneously came the unprecedented increase of urban industry, following on the invention of the steam-engine and spinning machinery. The result was an enormous and growing demand for corn, beef, and pork, sailcloth, stores of all kinds for our armies and fleets, a demand which England, owing to the growth of her town population and the consequent growth of the home demand, was unable adequately to meet.




---

p.57


Ireland reaped the benefit. As a largely agricultural country, she was as yet little influenced by the discoveries of Watt, of Hargreaves, of Arkwright, or of Crompton. But her long-rested soil could produce in apparently unlimited quantities those very products of which the British forces stood most in need. The fleets were victualled and fitted out at Cork, and 'they carried thence a constant stream of supplies of all sorts for our armies in the field. Indeed, so keen was the demand that it was soon discovered that not only our own troops, but those of the enemy, were receiving Irish supplies, and smugglers on the south and west coasts reaped a rich harvest.


The result was obvious. Cattle graziers and middlemen made enormous profits, rents were doubled and trebled. Dublin, Cork, Waterford, Limerick and Belfast flourished exceedingly on war prices and war profits. But there is no evidence that the mass of the people in their degraded and debased condition shared to any extent in this prosperity. It was at this very period that Arthur O'Connor spoke of them as ‘the worst clad, the worst led, the worst housed people in Europe.’ Whiteboyism, outrage and lawlessness spread over the face of the country, and, as **Lord Clare** reminded Parliament,‘session after session have you been compelled to enact laws of unexampled rigour and novelty to repress the horrible excesses of the mass of your people.’ It has been made a charge against the Union that during some disturbed periods of the nineteenth century the United Parliament had to pass ‘Coercion’ Acts at the rate of nearly one every session. The complainants should look nearer home and they would find from the records of the Irish Legislature that during the ‘halcyon’ days of ‘**Grattan**'s Parliament’—the eighteen years between 1782 and the Union— no less than fifty-four Coercion Acts were passed, some of them of a thoroughness and ferocity quite unknown in later legislation. The close of the nineteenth century and the opening of the twentieth were, in reality, in spite of a certain amount of agrarian crime, organised and subsidised from abroad, a period of much greater peace and



---

p.58



more widespread prosperity than the bloodstained years that marked the close of the eighteenth century—and of the Irish Parliament.


Another fiction regarding the Union may perhaps be worth notice. It has sometimes been suggested that it was carried by a venal oligarchy in opposition to the will of the great mass of the population, of the Roman Catholic population in particular. This is precisely the reverse of the truth. The oligarchy controlled the Parliament, and it therefore followed that the uniformly corrupt traditions of the Irish Parliament had to be observed in carrying the Union as in carrying every other Government Bill throughout the century. But, so far from the Act of Union being carried by landowners and Protestants against the will of the Catholics, it was, as a matter of fact, carried with the ardent and unanimous assent and support of the Catholic hierarchy, and against the embittered opposition of the old ascendancy leaders, who feared the loss of their influence of power.


The evidence on this point is documentary and precise. Indeed, no one thought of doubting or challenging it at the time; **Grattan** contented himself with denouncing the Catholic Bishops as ‘a band of prostituted men.’ **Dr. Troy, Archbishop of **Dublin****, was, as his correspondence shows, a warm, consistent and active supporter of the Union. **Dr. Dillon, Archbishop of **Tuam****, wrote in September, 1799, that he had had an opportunity during his recent visitation ‘of acquiring the strongest conviction that this measure alone can restore harmony and happiness to our unhappy country.’ His neighbour, **Dr. Bodkin, Bishop *of* **Galway****, wrote that the Union was the only measure to save ‘poor infatuated Ireland’ from ‘ruin and destruction.’ **Dr. Moylan, Bishop of **Cork****, was equally emphatic. ‘I am perfectly satisfied,’ he says, ‘that it is impossible to extinguish the feuds and animosities which disgrace this Kingdom, nor give it the advantages of its natural local situation, without a Union with Great Britain. God grant that it may soon take place!’




---

p.59


As for the feeling of the rank and file of the electors—under a very widely extended franchise—two examples will suffice. In two cases—in the County of Kerry and the borough of Newry—both open constituencies—by-elections occurred during the passing of the Union legislation. In both instances the Roman Catholic vote predominated, and in both the feeling was so strong in favour of the Union that no opponent dared to face the poll. In after years **Mr. Maurice Fitzgerald, the Knight of **Kerry****, recounted his experiences. ‘Having accepted office,’ he says, ‘as a supporter of the Union, I went to two elections pending the measure and was returned without opposition in a county where the Roman Catholic interest greatly preponderated, and a declaration almost unanimous in favour of the Union proceeded from the County of Kerry. One of my most strenuous supporters in bringing forward that declaration was **Mr. Mauric O'Connell**, uncle of **Mr. Daniel O'Connell**, and my most active partisan was **Mr. John O'Connell**, brother of **Mr. Daniel O'Connell**.’


In Newry an attempt was made to put up an anti-Unionist candidate, but the **Roman Catholic Bishop, Dr. Lennan**, met and repulsed the intruder in militant fashion. ‘Mr. Bell,’ he reports to **Archbishop Troy**,‘ declined the poll, and surrendered yesterday. The Catholics stuck together like the Macedonian phalanx, and with ease were able to turn the scale in favour of the Chancellor of the Exchequer.’


To the Irish Catholic at the time of the Union, the Dublin legislature was, indeed, in the words of **Mr. Denys Scully**, a leading Catholic layman, ‘not our Parliament, for we had no share in it, but their Club-house.’


The summing up of the whole matter is perhaps best expressed in the measured judgment of **Mr. John Morley** in his study of the life of **Edmund Burke**. Burke, in an evil moment for himself and for Ireland, had lent himself in 1785 to what **Mr. Morley** called the ‘factious’ and ‘detestable’ course of Fox and the English Whig leaders in destroying **Pitt**'s Commercial Propositions.




---

p.60


‘ Had it not been for what he himself called the delirium of the preceding session’ (writes Burke's biographer).[6](javascript:footNote('E900031/note006.html')) ‘he would have seen that **Pitt** was in truth taking his first measures for the emancipation of Ireland from an unjust and oppressive subordination and for her installation as a corporate member of the Empire—the only position permanently possible for her. ... A substantial boon was sacrificed amid bonfires and candles to the phantom of Irish Legislative Independence. The result must have convinced **Pitt** more firmly than ever that his great master, **Adam Smith**, was right in predicting that nothing short of the Union of the two countries would deliver Ireland out of the hands of her fatuous chiefs and of their too worthy followers.’


What would **Mr. John Morley**, the historian who wrote those words in the prime of his intellectual strength and judgment, have said if any one had told him that in his old age **Lord Morley**, the politician, would have been actively engaged in assisting another generation of ‘fatuous chiefs’ and still more worthy followers to sacrifice the true interests of Ireland in the pursuit of ‘the phantom of Irish Legislative Independence’?


#### After The Union


That the Union to some extent failed in the beneficent effects which it was calculated to produce in Ireland is only another instance of the working of the ‘curse of mischance’ which has so often, before and since, interposed to thwart the intentions of statesmen in their dealings with the two countries. **Pitt**, **Castlereagh**, and **Cornwallis**, the three men chiefly concerned in planning the change, were all agreed in explaining that the Union was not a policy complete in itself, but was only the necessary foundation upon which a true remedial policy was to be based. As **Lord Cornwallis** said at the time, ‘the word ‘Union’ will not cure the ills of this wretched country. It is a necessary preliminary, but a great deal more remains to be done.’ Catholic Emancipation, a series of parliamentary, educational, financial, and economic reforms, and the



---

p.61



abolition of the Viceroyalty, the visible symbol of separatism and dependence, were all essential portions of **Pitt**'s scheme. But **Pitt** was destined to sink into an early grave without seeing any of them materially furthered. Treacherous colleagues and the threatened insanity of the King blocked the way of some of them: England's prolonged struggle for existence against the power of Napoleon, involving as it did financial embarrassment and a generation of political reaction, accounted for the rest.


**Pitt** and **Castlereagh** resigned on the King's refusal to accept their advice, ‘and so,’ as **Lord Rosebery** says,[7](javascript:footNote('E900031/note007.html')) ‘all went wrong.’ It was ‘like cutting the face out of a portrait and leaving the picture in the frame. The fragment of policy flapped forlornly on the deserted mansions of the capital.’ A generation of agitation, strife, and discontent was to pass before Emancipation was carried, and the reforms had to wait still longer. Meanwhile a wonderful change of front had taken place. The leading opponents of the Union—**Plunket**, **Foster**, **Beresford**—even **Grattan** himself—came to accept it, and, in some cases, figured as its warmest defenders. And the Catholic Party, whom we have seen so strongly supporting the Union, gradually grew into opponents. **Daniel O'Connell**, whose brother and uncle were the leading supporters of the Union candidate for Kerry, started a formidable agitation first for Emancipation and then for Repeal of the Union. In the former he succeeded because enlightened public opinion in both countries was on his side: in the latter he failed utterly, both parties in Great Britain and a large section in Ireland being inflexibly opposed to any such reactionary experiment. In the end **O'Connell** died disillusioned and broken-hearted, and the Repeal movement disappeared from the field of Irish politics till revived many years later in the form of Home Rule.


But whilst recognising the fact that the Union, owing to the causes stated, failed partially, and for a time, to respond to all the anticipations of its authors, readers must be warned



---

p.62



against accepting the wild and woeful tales of decay and ruin that were recklessly circulated for propagandist purposes by **O'Connell** and the Repealers. Many people who are content to take their facts at second hand have thus come to believe that the legislative Union changed a smiling and prosperous Kingdom into a blighted province where manufactures and agriculture, commerce and population fell into rapid and hopeless decline. Needless to say, things do not happen in that way: economic changes, for better or for worse, are slow and gradual and depend on natural causes, not on artificial. Ireland has not, as a whole, kept in line with nineteenth-century progress, and her population, after a striking increase for over forty years, showed under peculiar causes an equally striking decrease; but to assert that her course has been one of universal decay and of decay dating from the Union is to say what is demonstrably untrue.


It was inevitable that a city of very limited industry like Dublin should suffer from the disappearance of its Parliament, which brought into residence for some months in every year some hundreds of persons of wealth and distinction. It was also inevitable that the mechanical inventions to which we have already alluded—the steam-engine, the ‘spinning jenny,’ and the ‘mule’—which revolutionised the world's industry, should have their effect in Ireland also. Under primitive conditions, with lands almost roadless and communications slow, difficult and costly, the various districts of any country had of necessity to produce articles of food and clothing to satisfy their requirements, or they had to go without. With the progress of invention, and with the opening up of the world by roads and canals, a totally different state of things presents itself. Industries tend to become centralised—the fittest survive and grow, the unfit wither away. This is what occurred in many districts of England and Scotland, and the course of events was naturally the same in Ireland.


When we read of small towns now lying idle, which in the eighteenth century produced woollen cloth, linen, cotton,



---

p.63



fustian, boots, hats, glass, beer, and food products, it simply means that a more highly organised system of industry has in its progress left such districts behind in the race. The woollen manufacture has centred in Yorkshire, cotton in Lancashire, linen in Belfast, and so forth—one district dwindled as others advanced and tended to monopolise production, without the legislature having anything to say to it. To say that this or that manufacture is not so prosperous in Ireland as it was a century ago before power looms, spindles, steamships, and railways came to revolutionise industry, is simply to say that Ireland, like other countries, has had its part, for better or for worse, in the great world-movement of nineteenth-century industry.


The figures of Irish exports and imports lend no countenance to the story of decay setting in with the Union. Taking the two decennial periods, before and after the Union, the figures are as follows:[8](javascript:footNote('E900031/note008.html'))



| Period | Total value of imports | Total value of exports |
| --- | --- | --- |
| 1790–1801 | £ 49,000,000 | £ 51,000,000 |
| 1802–1813 | £ 74,000,000 | £ 63,000,000 |
| Increase | £ 25,000,000 | £ 12,000,000 |






An increase of over fifty per cent in imports, and over twenty-three per cent in exports in the ten years after the Union as compared with the ten years before it.


Taking single years the result is similar. The amalgamation of the two Exchequers and the financial re-arrangements that followed, put an end to the accurate record of exports and imports until quite recently, but the increase during the early years of the Union and also over the whole country is unmistakable. The average annual value of Irish exports at the time of the Union was, according to **Mr. Chart**,[9](javascript:footNote('E900031/note009.html')) £ 4,000,000. In 1826 they had increased to £ 8,000,000, a corresponding increase being recorded in



---

p.64



imports. Coming down to the period of the Financial Relations Commission (1895), that very cautious and painstaking statistician, the late **Sir Robert Giffen**,[10](javascript:footNote('E900031/note010.html'))
 roughly estimated Irish imports at £ 25,000,000 and exports at £ 20,000,000. Since that time the Irish Agricultural Department has been created, and has undertaken the collection and tabulation of such statistics. Turning to their latest report we find that the imports had in 1910 attained the relatively enormous figure of £ 65,000,000, and the exports £ 65,800,000, a total of over £ 130,000,000 in place of nine or ten millions, at the very outside, of the time of the Union. And it is worth noting in addition that, for the first time in these recorded tables, Ireland's exports exceed her imports.


But we are assured with triumphant and invincible despondency that population has decreased alarmingly. The movements of population since the time of the Union have been, it may be admitted, very remarkable, but the figures are double-edged and require a more careful handling than they generally receive. If we are to assume, as the prophets of gloom will have it, that increase and decrease of population are an infallible test of a country's growth or decay, then Ireland for nearly half a century after the Union must have been the most prosperous country in



---

p.65



Europe. The population of Ireland, which in 1792 was estimated at £ 4,088,226, had increased in 1814 to £ 5,937,856, in 1821 to £ 6,801,827, and in 1841 to £ 8,196,597. In other words, the population, like the trade, of the doomed island had more than doubled since the Union. We doubt if any European country could say as much.


Then came the great disaster, the potato famine of 1846–47, which, undoubtedly, dealt a stunning blow to Irish agriculture. It was not the first, nor the worst, of Irish famines—there is evidence that the famines of 1729 and 1740 were, proportionately, more widespread and more appalling in their effects. But, occurring as it did, in the middle of the nineteenth century, with the press of the world as witnesses, it attracted immense attention, and the nations, whom England, then high and mighty in the undisputed supremacy of the doctrines of laissez faire and free trade, were not slow in retorting on their mentor. The State, it was laid down dogmatically by the economists, must not do anything to feed the starving people, because that would interfere with the principle of private enterprise; and as there was naturally no private enterprise in wide stretches of country where landlord and tenant, shopkeeper and labourer, were involved in common ruin, the people starved. For the same reason, the sufferers must not be paid to do useful work, so they were set to make roads that led to nowhere—and that have been grass-grown ever since—and to build walls that had to be pulled down again.


It was a ghastly specimen of doctrinaire dogmatism run mad, and though it was not the fault of the Government so much as of the arid doctrines of ill-understood economics which then prevailed in the schools, it did more than anything to embitter the relations between the Irish people and the Imperial Government. The death-rate from famine and famine-fever was appalling. The poor law system—then a new experiment in Ireland—broke down hopelessly, and agitators were not slow to improve the occasion by denouncing the ‘callousness’ of the Imperial Government.




---

p.66


Nations, as a rule, recover from such calamities as famine, war, and pestilence with surprising quickness; but there were certain incidents connected with the famine of 1846–47 that intensified and perpetuated the evil in the case of Ireland. We have already referred to the high-and-dry doctrines of laissez faire then in the ascendant, and any real or permanent recovery of Irish agriculture was rendered practically impossible by England's adhesion to the doctrine of free imports, by the abolition of the Corn Laws, and by the crushing increase of taxation under **Mr Gladstone**'s budgets of 1853 and the succeeding years.


Ireland was entitled under the Act of Union to ‘special exemptions and abatements’ in taxation, in consideration of her backward economic condition. All Chancellors of the Exchequer till **Mr. Gladstone**'s time respected these exemptions, and although no one could suggest, in view of Ireland's recent progress, that she could have been permanently exempted from the burdens imposed on the British taxpayer, it will be admitted that the time chosen by **Mr. Gladstone** for abruptly raising the taxation of Ireland from 14s. 9d. per head to 26s. 7d. was inopportune, not to say ungenerous.


**Sir David Barbour**, in his minority report on the Financial Relations Commission, perhaps the most carefully thought out and the most practical of all the many reports emanating, from that heterogeneous body, gives a table of the ‘estimated true revenue’ extracted from Great Britain and Ireland respectively from 1819 to 1894. This table shows that the revenue raised from Ireland was increased between 1849–50 and 1859–60 from £ 4,861,465 to £ 7,700,334 and he adds: ‘It will be observed that a great and rapid rise took place in the taxation of Ireland during the decade 1850–1860. This great increase was due to the equalisation of the spirit duties in the two countries, and the extension of the Income Tax to Ireland. The special circumstances of Ireland do not appear to have received due consideration at this time. Many arguments of a general character might be employed to justify the equalisation of



---

p.67



the spirit duties, and the imposition of an Income Tax, but Ireland was entitled under the Act of Union to such exemptions and abatements as her circumstances might require, and the time was not opportune for imposing additional burdens upon her.’


Irish Agriculture was thus almost simultaneously struck down by the greatest famine of the century, which swept away two million of the population, disabled for resuming the competition by the free admission of foreign grain, which in the long run rendered successful corn-growing in Ireland impossible, and saddled with an additional two and a quarter millions of taxation. When remonstrated with **Mr. Gladstone** retorted flippantly that he could not see that it was any part of the rights of man that an Irishman should be able to make himself drunk more cheaply than the inhabitant of Great Britain. The taunt would have possessed more relevance if whisky had been an article of importation. Seeing, however, that it was an article of manufacture and export, employing directly or indirectly much capital and labour, the injury to Irish industry was very serious, many distilleries and breweries being obliged to close their doors.


As **Miss Murray** says in her masterly work on Irish commerce[11](javascript:footNote('E900031/note011.html')):—

*Just as the country was thoroughly exhausted from the effects of the famine, the whole financial policy adopted towards Ireland changed, and Irish taxation began to be rapidly assimilated to British at a time when great prosperity had come to Great Britain, and the reverse to Ireland. The repeal of the Corn Laws had stimulated the commercial prosperity of Britain; large cities were expanding, railways were developing, and the foreign trade of the country was increasing by leaps and bounds. But Ireland had just passed through the awful ordeal of famine: her population had suddenly diminished by one fourth, there had been a universal decline in Irish manufactures, the repeal of the Corn Laws had begun the destruction of the Irish export trade in cereals, and the extension



---

p.68



of the Poor Law system to Ireland had greatly increased the local rates. Just as the famine subsided the results of free trade began to take effect. Wheat-growing decayed; local industries were destroyed by the competition of large manufacturing towns in Great Britain; every class of Irish producers saw ruin staring him in the face, while landlords and farmers were further impoverished by the huge poor-rates, which sometimes reached 20s. in the £. The misery and poverty of the country could hardly have been greater, and to us at the present day it seems extraordinary that just at this inopportune time the Government should have thought fit to go back from the conciliatory fiscal policy which had existed since 1817.’’*


It is not to be wondered at that Gladstonian finance was ever after looked at with well-grounded suspicion in Ireland.


Another circumstance that has had a serious and lasting effect on Irish population has still to be mentioned. At first the emigration movement was largely a flight from starvation, a movement that would have come to an end under normal circumstances with the end of the famine crisis. But as we have seen, the conditions were not normal; the crisis was artificially protracted by injurious financial legislation. And, in addition, although many of them perished by the way owing to the abominably insanitary conditions of the coffin ships employed for the journey, the emigrants arriving at New York or Boston soon found conditions unexpectedly favourable for the class of labour which they were best qualified to supply. America was just then opening up and turning to the new West, and the demand for unskilled labour for railway work was unlimited. The Irish emigrant seldom or never takes to the land when he goes to America, and navvy work just suited him. To a man accustomed to sixpence a day the wages offered seemed to represent unbounded wealth, and as the news spread in Ireland the move to America, which at the first seemed hopeless exile, presented itself as a highly desirable step towards social betterment. Emigration is now the result of attraction from America rather than of repulsion from Ireland, a fact which explains



---

p.69



the failure of more than one well-meant attempt to check the movement by action on this side of the Atlantic.


#### Ulster Development


A word should perhaps be given to the position of the industrial portion of Ulster, which has flourished so remarkably since the Union. This of itself affords sufficient proof that that Act, whatever its defects, cannot be held accountable for any lack of prosperity that may still exist in other parts of Ireland. It is sometimes stated that Ulster was favoured at the time when the commercial jealousy of certain English cities succeeded in securing a prohibition of the Irish woollen industry. The southern wool, it is alleged, was checked, and the Belfast linen was favoured—hence the prosperity of the northern capital. This is a really curious perversion of quite modern history. The linen industry was at the time in question in no sense confined to the North and was by no means prominent in Belfast. It was distributed over many districts of Ireland, for whilst **Louis Crommelin** was sent to Lisburn to look after the French colony settled there, and to improve and promote the industry, his brother William was sent on a similar errand to Kilkenny, and stations were also started at Rathkeale, Cork and Waterford. When, later on, the Irish Parliament distributed bounties through the Linen Board, the seat of that Board was in Dublin, and its operations included every county in Ireland.


At the time of the Union, indeed, the linen manufacture was almost unknown in Belfast, the ‘manufacturers’ or handloom weavers in the North, as elsewhere, living mostly in the smaller country towns and bringing their webs in for sale on certain market days. From **Benn**'s History of the Town of Belfast, published early in the century, we learn that at that time the principal manufacture of the town was ‘cotton in its various branches.’ This industry had been introduced in 1777, we are told, to give employment in the poorhouse, but it caught on and spread 



---

p.70



amazingly. ‘In many of the streets and populous roads in the suburbs of the town, particularly at Ballymacarrett, the sound of the loom issues almost from every house, and all, with very few exceptions, are employed in the different branches of the cotton trade. In the year 1800 this business engaged in Belfast and its neighbourhood 27,000 persons.’ In 1814 there were eight cotton mills at work with steam power driving 99,000 spindles. On the other hand, ‘there is very little linen cloth woven in this town or parish. In 1807 Belfast contained 723 looms, only four of which were for weaving linen.’


The story of the sudden change from cotton to linen is an instructive one. Cotton appears to have forced itself to the front because cotton spinning could be carried on by machinery whilst the linen weavers were still dependent on the spinning wheel for their yarn. It was **Andrew Mulholland**, the owner of the York Street cotton mill, who first took note of the fact that while the supply of hand-made linen yarn was quite insufficient to justify the manufacture of linen on a large scale in Belfast, quantities of flax were shipped from Belfast to Manchester to be spun there and reimported as yarn. Mulholland determined to try if he could not spin yarn as well as the Manchester people, and accordingly in 1830, ‘the first bundle of linen yarn produced by machinery in Belfast was thrown off from the York Street mill.’ That, and not legislation nor any system of State bounties or State favour, was the beginning of the Belfast linen industry in which the York Street mill still maintains its deserved pre-eminence. When the critical moment arrived, as it does in the case of all industries, when manufacturers must adapt themselves to new methods or succumb, the Belfast leaders of industry rose to the occasion and secured for themselves the chief share in the linen trade. In the rest of Ireland, it is true, the manufacture dwindled and disappeared, but whatever may have been the cause of that disappearance, it was certainly not the Act of Union.




---

p.71


#### The Land Question


The agrarian problem has caused more trouble in Ireland than any other, and statesmen have long recognised that on its definite settlement depends the hope of permanent peace and progress over the greater part of the country. It is not, and never has been, the real cause of rural depopulation, for, as we have seen, the increase of the rural population was most rapid at the time when agrarian conditions were at their very worst, whilst on the other hand emigration continues almost unchecked in counties where the question has been virtually settled. And in 1881 the late **Mr. J. H. Tuke** discovered by an analysis of the census returns that the only ‘townlands’ in which the rural population was actually increasing were those scattered along the western sea-board of Ireland, where the tenure and the conditions of existence seemed most hopeless. But, as the Devon Commission announced in 1845, it was an essentially defective system of land tenure that lay at the root of the perennial discontent with which Ireland was troubled, and things went from bad to worse until the Party organised for the defence of the Union and the social betterment of Ireland took up the task of settling the question by the transfer on fair terms of the ownership of the soil from the large land-owners to the tenants.


The system of land tenure in England has been the growth of custom gradually hardening into law; in Ireland the traditional custom was suddenly abolished, and English law substituted in its place. The English law was no doubt a better law, and one more fitted to a progressive community; but in Ireland it violently upset the traditional law of the country, and, consequently, was met with sullen and unremitting hostility. By Irish law, the tribe was owner; the tribesmen were joint proprietors, and the forfeiture of the chief did not involve the forfeiture of the land occupied by the tribesmen. By English law, however, these latter, such of them as were not expelled or exiled, suddenly found themselves transformed from joint-owners into tenants at



---

p.72



will. Further, the difficulty of dealing direct with tenants, experienced by landlords who were in very many cases absentees, led to the abominable ‘middleman’ system by which the owner leased great stretches of land to some one who undertook to ‘manage’ it for him, and who in turn sub-let it in smaller patches at rack-rents to those who, to get back their money, had to sub-let again at still higher rents. The result was, as an official report in the eighteenth century states: ‘It is well known that over the most part of the country, the lands are sub-let six deep, so that those who actually labour it are squeezed to the very utmost.’ And **Lord Chesterfield**, when Viceroy, complained of the oppression of the people by ‘deputies of deputies of deputies.’ The eighteenth-century policy of checking or suppressing the industrial enterprises of the English colony aggravated the evil until, as **Lord Dufferin** expressed it: ‘Debarred from every other industry, the entire nation flung itself back upon the land, with as fatal an impulse as when a river whose current is suddenly impeded, rolls back and drowns the valley it once fertilised.’


In time the middleman tended to die out, but the evil results of the system in preventing direct and friendly and helpful relations between landlord and tenant remained. Here and there, even in **Arthur Young**'s time, enterprising and devoted landlords had established something like the ‘English system’ on their estates, but, as a rule, the landlord remained a mere rent charger. The report of the Devon Commission says:—

*It is admitted on all hands that, according to the general practice in Ireland, the landlord neither builds dwelling-houses nor farm offices, nor puts fences, gates, etc., in good order before he lets his land to a tenant. The cases where a landlord does any of these things are the exception. In most cases, whatever is done in the way of building or fencing is done by the tenant, and in the ordinary language of the country, dwelling-houses, farm buildings, and even the making of fences, are described by the general word, ‘improvements’, which is thus employed to denote the necessary adjuncts of a farm without which in England or Scotland no tenant would be found to rent it.’’*




---

p.73


In a word, as one who owned land both in England and in Ireland put it, ‘In England we let farms, in Ireland we let land.’ And by law an unjust landlord had the power at any moment to expel a tenant or a group of tenants, although no rent was owing, and without giving any compensation for the ‘improvements’ which were the sole work of the tenant. Most landlords acted reasonably and equitably in such matters, but, especially among the new class of purely mercantile purchasers who came in under the Landed Estates Court after the great famine of 1846, there were too many who insisted on their extreme legal rights, thus disturbing the peace of the country and producing the Irish Land Question in an acute form that called for State interference.


The systems of ‘compensation for improvements’ (1870), and of rent fixing by itinerant tribunals (1881), were tried in turn, but each was found to raise more difficulties than it settled, until finally **Mr. Parnell** and his Land League set the whole country in a flame, and produced a series of strikes against the payment of any rent. For some years it is hardly too much to say that the law of the League, with its purely revolutionary propaganda, supplanted the law of the land and reduced large areas to a condition of chaos, the decrees of the ‘village ruffians,’ who ruled the situation, being enforced by systematic outrage and assassination.


The first statesman who made a really serious attempt to meet this appalling state of things was **Mr. Arthur Balfour**, who, as Chief Secretary for Ireland, resolutely took up the task, first of repressing crime and enforcing the law, and then of recasting the whole land system in such a way that the tenant, transformed into an owner, would for the first time feel it his interest to range himself on the side of the law and of orderly government. At the same time, a systematic attempt was made to deal with the question of perennial poverty in the extreme West of Ireland in what came to be known as the ‘Congested Districts.’ The construction of railways and piers, the draining of land, and the



---

p.74



provision of instruction in agriculture, fisheries, etc., speedily gave promise of a new era in the economic history of a hitherto helpless and hopeless population.


All this was done by **Mr. Balfour** and his successors in spite of opposition and obstruction of a kind such as no Chief Secretary had ever before had to encounter. Formerly, all through the centuries, whenever a Viceroy or Chief Secretary was face to face with an organised outbreak of crime and sedition in Ireland, both British parties united in supporting and strengthening the hands of the executive as representing the Crown. **Mr. Gladstone**'s extraordinary reversal of policy and principle in the winter of 1885–86 put an end to all this, and gravely increased the difficulties of the Irish Government.


When **Mr. Gladstone** was first confronted with the demand for, even in the mild and constitutional form advocated by **Mr. Isaac Butt**, and his Home Government Association, founded in the autumn of 1870, he promptly declared, like **Mr. John Morley**, that legislative Union with Great Britain was the only position permanently possible for an island situated as Ireland is. In a speech at Aberdeen he indignantly asked— 

*Can any sensible man, can any rational man, suppose that at this time of day, in this condition of the world, we are going to disintegrate the great capital institutions of this country for the purpose of making ourselves ridiculous in the sight of all mankind and crippling any powers we possess for conferring benefits on the country to which we belong.’’*

Sept. 26, 1871.


And for fifteen years, in power or in opposition, **Mr. Gladstone** preached and acted upon the same doctrine. When the Land League was founded he denounced it as an organisation whose steps were ‘dogged with crime,’ and whose march was ‘through rapine to the dismemberment of the Empire.’ The League was finally ‘proclaimed’ by his Government as a criminal conspiracy and its members, from **Mr. Parnell** downwards, arrested and imprisoned



---

p.75



without trial as being ‘reasonably suspected’ of criminal practices.


This continued until in an unfortunate moment for himself **Mr. Gladstone** discovered, in November, 1885, that the votes of **Mr. Parnell** and his eighty-six colleagues were necessary for his own return to power as Prime Minister, whereupon he entered into negotiations which resulted, on the one hand, in his securing the necessary votes, and on the other in his accepting the principles and the policy of those whom until then he had denounced and imprisoned as instigators to crime and sedition. He rightly recognised that there was no half-way house, and that he could not become a Home Ruler without accepting and defending the actions of the Home Rulers. He worshipped what he had formerly burnt, and he burned what he had hitherto worshipped. The result was that for several years England beheld for the first time the scandalous spectacle of men who had held high office under the Crown openly defending—and even instigating—lawlessness and disorder, shielding and excusing criminals, proved such before the courts, and thwarting, misrepresenting, and obstructing those whose duty it was to restore order and legality in Ireland.


Such were the difficulties that confronted **Mr. Arthur Balfour** as Chief Secretary for Ireland from 1887 to 1891, difficulties which he surmounted with such resolution and such statesmanship that he retired from an office that has been called ‘the grave of reputations’ with a reputation so much enhanced as to ensure him the leadership of his party and the gratitude of Irishmen of all classes for generations to come. And yet his method was a supremely simple one—to reassert the supremacy of the law, to neglect, almost ostentatiously, all merely political cries, and to set himself seriously to deal with the real Irish question, that of conferring some measure of security and prosperity on a population which over wide districts had known too little of such things.


Occupying ownership of Irish land by means of State credit was not, of course, a new policy in **Mr. Balfour**'s day.



---

p.76



The Bright clauses (1869) had introduced the principle into the Statute-book, and **Lord Ashbourne**'s Act (1885) had carried it several steps further. But it was **Mr. Arthur Balfour** and his successors, **Mr. Gerald Balfour** and **Mr. George Wyndham**, who carried it by a series of boldly conceived steps almost within sight of completion. So thorough was the success of this policy of land purchase, and so marked was the cessation of crime and outrage and seditious agitation in every district into which it was carried, that those who made their living by agitation grew alarmed, and did all in their power to stop the working of the Purchase Acts. One Nationalist member declared that the process had gone ‘quite far enough,’ and that he wished it could be stopped. The farmers who had purchased their holdings were declared to have become selfish, and ‘as bad as the landlords.’ In other words, they had become orderly and industrious, and had ceased to subscribe for the upkeep of the **United Irish League** and its salaried agitators.


The unhappy result of this outcry on the part of those whose occupation would be gone, and who would be compelled to resort to honest industry should Ireland become peaceful and prosperous, was the passing of **Mr. Birrell**'s ‘amending’ Bill, which has practically stopped for the present the beneficent working of the Wyndham Act of 1903. Under the various purchase Acts over 180,000 Irish farmers have become the owners of their holdings, thanks to over one hundred millions of public money advanced on Imperial credit for the purpose. The first task of a Unionist government, when again in power, must be the resumption of this policy of State-aided land-purchase—the only completely and unquestionably successful and pacifying piece of agrarian legislation in the history of English rule in Ireland.


Other writers will give, later on, a more detailed account of various branches of Unionist practical policy in Ireland. The story of the Congested Districts Board, **Mr. Arthur Balfour**'s special work, is a romance in itself. So well, in fact, has it accomplished its immediate task that the time has probably come when it could with advantage be merged



---

p.77



in the later created Department of Agriculture and Technical Instruction. This department, which has been linked up with the County or Borough Councils, by the legislation of **Mr. Gerald Balfour**, has done an immense amount of educational and practical work in connection with agriculture in all its branches, including dairying, poultry rearing, fruit-growing, and other rural industries, not to speak of technical instruction in matters suited for artisans and town workers. These remarkable achievements, the work of successive Unionist Governments from 1896 to 1906, have revolutionised the face of the country, and are bringing about a new Ireland. The chief danger now lies in the intrigues of discredited politicians, whose object is to divert the eyes of the people from practical, remedial, and constructive legislation, and to keep them fixed upon what **Mr. John Morley** has called ‘the phantom of Irish legislative independence.’




---

p.81


CRITICAL
--------


### The Constitutional Question

### By **George Cave, K.C., M.P.**


#### Introductory


Few things are more remarkable in the Parliamentary history of the movement than the complete absence from the counsels of the English advocates of any definite and settled policy as to the form of self-government to be offered to Ireland, and their consequent oscillation between proposals radically differing from one another. Since the ‘new departure’ initiated by **Davitt** and **Devoy** in 1878,[12](javascript:footNote('E900031/note012.html')) it has been the deliberate practice of Irish Nationalists to abstain from defining the Nationalist demand and to ask in general terms for ‘self-government,’ doubtless with the object of attracting the support of all who favour any change which could be described by that very elastic term. Such a policy has its advantages. But confusion of thought, however favourable to popular agitation, is a disadvantage when the moment for legislation arrives; and uncertainty as to the aim goes far to explain the vacillation in Home Rule policy.


**Mr. Gladstone**'s Bill of 1886 would have given to Ireland the substance of ‘responsible’ or colonial self-government, subject only to certain reservations and restrictions, the value of which will be considered later in this chapter, and would have excluded the Irish members and representative peers from the Parliament of the United



---

p.82



Kingdom. By the Bill of 1893 the reservations and restrictions were increased, and representatives of Ireland were to be permitted to sit at Westminster—by the Bill as introduced for some purposes, and by the Bill as passed by the House of Commons for all purposes.


After the defeat of this second Bill, a ‘cold fit’ appears to have seized the Liberal Party. **Lord Rosebery**, in 1894, declared that before Home Rule could be carried England, as the predominant partner, must be convinced. **Sir Edward Grey** in 1905 declared that his party on its return to power would ‘go on with **Sir Anthony MacDonnell**'s policy,’ which he rightly described as a policy of large administrative reforms; and **Mr. Asquith** ‘associated himself entirely and unreservedly with every word’ of **Sir Edward Grey**'s speech.[13](javascript:footNote('E900031/note013.html')) Accordingly the Irish Council Bill proposed by **Mr. Asquith**'s Government in 1907 was purely a measure of devolution, certain administrative functions only being put under the control of an Irish Council, subject to the veto of the Lord Lieutenant, and the whole legislative power remaining in the Parliament of the United Kingdom. This proposal, having been condemned by a National Convention at Dublin, was incontinently withdrawn.


In the years succeeding this fiasco the Liberal policy for Ireland appeared to be at the mercy of shifting winds. For some time Liberal speakers contented themselves with vague declarations in favour of Federalism or ‘Home Rule all round’:—phrases which may mean much or little according to the sense in which they are used. More recently an able writer,[14](javascript:footNote('E900031/note014.html')) while admitting that ‘there is no public opinion in Ireland as to the form of the Irish Constitution,’ has argued in a work of 350 pages in favour of the grant to Ireland of full legislative, administrative and financial autonomy; while a member of the Government [15](javascript:footNote('E900031/note015.html')) has declared that fiscal autonomy for all practical purposes



---

p.83



means separation and the disintegration of the United Kingdom. In a publication recently issued by a committee of Liberals, comprising several members of the present Government,[16](javascript:footNote('E900031/note016.html')) two views directly contrary to one another are put forward, one writer arguing for a devolution to an Irish body of ‘definite and defined powers only,’ and another for the grant of the widest possible form of and the exclusion from Westminster of all Irish representation. The latest official pronouncements indicate that the Government have it in their minds to revert to the Gladstonian form of Home Rule; but even now [17](javascript:footNote('E900031/note017.html')) no one outside the Cabinet, and possibly few inside that inner circle, would venture on a confident prophecy even as to the broad lines of the measure which in a few days may be submitted to Parliament as representing the urgent and considered demand of public opinion.


**Franklin** said truly that—

*those who govern, having much business on their hands, do not generally like to take the trouble of considering and carrying into execution new projects.’’*

 

But surely on a question of such vital moment to the Empire as the revision of the constitution of the United Kingdom, the bases, if not the details, of the contemplated change are deserving of prolonged consideration and even of some public and ordered discussion. The British North America Act, 1867, by which the relation of the Dominion of Canada to its provinces is regulated, was the result, not only of years of preliminary debate in the provincial Legislatures and elsewhere, but of a formal conference at Quebec in 1864, followed by the appointment of delegates to confer with the Imperial Government on the matter. In Australia the proposal for union, agitated at intervals since 1846, was canvassed in every detail at inter-colonial Conferences or Conventions in 1883, in 1891, and in 1897–8, as well as in the several colonial Legislatures, before it was embodied in



---

p.84



the Australia Constitution Act, 1900. And although in the case of South Africa, owing to the urgency of the question of union, the time occupied in the discussion was less than in the other great dominions, yet in the Convention of 1908–9 the best brains in the country were occupied for months in considering every detail of the proposal for union before it was submitted to the Colonial and Imperial Parliaments for their sanction.[18](javascript:footNote('E900031/note018.html')) And yet in the Mother Country, where centuries of military and political conflict have given us the Union, it is considered that a few weeks' consideration by a committee of the Cabinet, without advice from independent constitutional experts,[19](javascript:footNote('E900031/note019.html'))and without formal consultation even with the Government's own supporters outside the Ministry, is sufficient to determine both the general form and the details of a proposal for its dissolution.
In the confusion so engendered it may be useful to consider in some detail the different proposals which have been or may be made under the name of Home Rule, their special qualities and dangers, and the results to which they may severally lead.


#### Responsible Government


A proposal to give to Ireland full ‘responsible’ government, without any other limitations than such as are imposed on our self-governing Colonies, would find few supporters in this country. Under such a constitution an Irish Government would have power to forbid or restrict recruiting for the Imperial forces in Ireland, and to raise and train a force of its own. It might establish or subsidise a religion, make education wholly denominational, levy customs duties on imports from Great Britain and give fiscal advantages to a foreign power, confiscate or



---

p.85



transfer property without payment, and deprive individuals of nationality, franchise, liberty, or life without process of law. However improbable some of these contingencies may appear, it is right on a matter of so much moment to consider possibilities and not probabilities only. Such powers as these could not without serious risk be conceded to any part of the kingdom, and in the case of Ireland there would be a special danger in granting them to a popularly elected body.


In the first place, the national safety would be involved. Englishmen were at one time too fond of saying that the great Colonies might, if they chose, sever the link which binds them to the Mother Country. Happily, in their case, no such catastrophe need now be considered. But it would be folly to shut our eyes to the fact that to many Irishmen national independence appears to be the only goal worth striving for. If the concession of full responsible government should be followed (at whatever interval) by an assertion of complete independence, we may assume that Great Britain would follow the example of Federal America and re-establish the Union by force of arms, but at how great a cost! Those who deny the possibility of a serious movement towards separation would do well to remember **Mr. Gladstone**'s reference[20](javascript:footNote('E900031/note020.html')) to the position of Norway and Sweden, then united under one crown:—

*Let us fool: to those two countries, neither of them very large, but yet countries which every Englishman and every Scotchman must rejoice to claim his kin—I mean the Scandinavian countries of Sweden and Norway. Immediately after the great war the Norwegians were ready to take sword in hand to prevent their coming under the domination of Sweden. But the Powers of Europe undertook the settlement of that question, and they united those countries upon a footing of strict legislative independence and co-equality.   
[*...*]  
 And yet with two countries so united, what has been the effect? Not discord, not convulsions, not danger to peace, not hatred, not aversion, but a constantly growing sympathy; and every man who knows their condition knows that I speak the truth when I say that



---

p.86



in every year that passes the Norwegians and the Swedes are more and more feeling themselves to be the children of a common country, united by a tie which never is to be broken.’’*


The tie was broken within twenty years.


It may be that the Nationalist leaders, or some of them, do not desire separation; but it by no means follows that a concession of their demands would not lead to that result. **Franklin**, in 1774, had an interview with **Chatham**, in which he says—

*I assured him that, having more than once travelled almost from one end of the continent (of America) to the other, and kept a great variety of company, eating, drinking, and conversing with them freely, I never had heard in any conversation from any person, drunk or sober, the least expression of a wish for a separation, or a hint that such a thing would be advantageous to America.’’*

Quoted in The True History of the American Revolution. , by S.G. Fisher (Lippincott, 1903).


And yet independence came within ten years.


In the case of the United Kingdom there is no need to consider in detail how serious would be the effects—naval, military, and economic—of separation, for the gravity of such a contingency is admitted by all. **Admiral Mahan**, the American naval expert, writes that—

‘the ambition of the Irish separatists, realised, might be even more threatening to the national life of Great Britain than the secession of the South was to that of the American Union.   
[*...*]  
 The instrument for such action in the shape of an independent Parliament could not safely be trusted even to avowed friends.’


Some Home Rulers are able to— 

‘rise superior to the philosophy, as fallacious in fact as it is base and cowardly in purpose, which sets the safety of a great nation above the happiness and prosperity of a small one,’ [21](javascript:footNote('E900031/note021.html')) 

but to less lofty souls it appears that the safety of the nation is paramount, and that upon it depends the prosperity of each of its component parts.




---

p.87


In the next place, in considering whether complete ‘colonial’ self-government can be conceded to Ireland, it must not be forgotten that the island is bi-racial, that the two races differ widely in character, in politics, and in religion, and that the differences are apt to find vent in violent conflict or secret attacks. Further, Ireland has for generations been the scene of a revolt against one particular species of property, the ownership of land; and although under the operation of the Land Purchase Acts this cause of conflict tends to abate, it still breaks out from time to time in the form of cattle drives and attacks on ‘land grabbers’ [22](javascript:footNote('E900031/note022.html')) Hitherto we have, broadly speaking, kept the peace. That we should now forsake this duty, and, washing our hands of Ireland, leave the Protestant and the landowner, great or small, to his fate is unthinkable.


In connection with the question last-mentioned it may be necessary at some time to consider how far it is the constitutional right of this country to impose upon the minority in Ireland the new obligations implied in a grant to whole island of colonial Home Rule. It may be that the Imperial Parliament can disallow the claim of a section of the population of Ireland to remain subject to its own control. But it is one thing to reject the allegiance of a community, it is quite another thing forcibly to transfer that allegiance to a practically independent legislature; and this is especially the case when the transfer may involve the use against a loyal population of coercion in its extreme form.


#### Checks And Safeguards


In every formal proposal for in Home Rule Ireland, weight has been given to the above considerations, and attempts have been made to meet them by qualifying the grant of responsible Government. The qualifications suggested have taken the form of (a) the reservation of certain



---

p.88



powers to the Imperial Parliament, or (b) the restriction of the powers granted to the Irish legislature by prohibiting their exercise in certain specific ways, or (c) the provision of some form of Imperial veto or control. It is important to consider whether and how far such checks or ‘safeguards’ are likely to prove effective and lasting.


The ‘safeguards’ proposed by the Government of Ireland Bill, 1886, were somewhat extended by the Bill of 1893; and the proposals shortly to be submitted to Parliament, so far as they can be gathered from recent speeches of Ministers, will not in this respect differ materially from those contained in the latter Bill. It will therefore be convenient to take as a basis for discussion the provisions of the Bill of 1893, as passed by the House of Commons.


The Bill of 1893, after stating in a preamble that it was ‘expedient that without impairing or restricting the supreme authority of Parliament an Irish Legislature should be created for such purposes in Ireland as in this Act mentioned,’ proposed to set up in Ireland a Legislature[23](javascript:footNote('E900031/note023.html')) consisting of the Sovereign and two Houses, namely a Legislative Council of 48 members to be returned under a restricted franchise by the Irish counties and the boroughs of Dublin and Belfast, and a Legislative Assembly of 103 members to be returned by the existing parliamentary constituencies in Ireland. A Bill introduced into the Irish Legislature was to pass both Houses; but in the event of disagreement the proposals of the Legislative Assembly were to be submitted, after a dissolution or a delay of two years, to a joint Session of the two Houses. The executive power was to remain in the Crown, aided and advised by an Irish Ministry (called an Executive Committee of the Privy Council of Ireland), and the assent of the Crown to Irish legislation was to be given or withheld on the advice of this Executive Committee subject to any instructions given by the Sovereign.




---

p.89


The specific reservations and restrictions were contained in clauses 3 and 4 of the Bill, which were as follows:
1. The Irish Legislature shall not have power to make laws in respect of the following matters or any of them:—
2. The Crown, or the succession to the Crown, or a Regency: or the Lord Lieutenant as representative of the Crown; or
3. The making of peace or war or matters arising from a state of war; or the regulation of the conduct of any portion of Her Majesty's subjects during the existence of hostilities between foreign States with which Her Majesty is at peace, in respect of such hostilities; or
4. Navy, army, militia, volunteers and any other military forces, or the defence of the realm, or forts, permanent military camps, magazines, arsenals, dockyards, and other needful buildings, or any places purchased for the erection thereof; or
5. Authorising either the carrying or using of arms for military purposes, or the formation of associations for drill or practice in the use of arms for military purposes; or
6. Treaties or any relations with foreign States or the relations between different parts of Her Majesty's dominions, or offences connected with such treaties or relations, or procedure connected with the extradition of criminals under any treaty; or
7. Dignities or titles of honour; or
8. Treason, treason-felony, alienage, aliens as such, or naturalisation; or
9. Trade with any place out of Ireland; or quarantine, or navigation, including merchant shipping (except as respects inland waters and local health or harbour regulations); or
10. Lighthouses, buoys, or beacons within the meaning of the Merchant Shipping Act, 1854, and the Acts amending the same (except so far as they can consistently with any general Act of Parliament be constructed or maintained by a local harbour authority); or
11. Coinage; legal tender; or any change in the standard of weights and measures; or
12. Trade marks, designs, merchandise marks, copyright, or patent rights.
13. Provided always, that nothing in this section shall prevent the passing of any Irish Act to provide for any charges imposed by Act



---

p.90



of Parliament, or to prescribe conditions regulating importation from any place outside Ireland for the sole purpose of preventing the introduction of any contagious disease.
14. It is hereby declared that the exceptions from the powers of the Irish Legislature contained in this section are set forth and enumerated for greater certainty, and not so as to restrict the generality of the limitation imposed in the previous section on the powers of the Irish Legislature.
15. Any law made in contravention of this section shall be void.
16. The powers of the Irish Legislature shall not extend to the making of any law—
17. Respecting the establishment or endowment of religion, whether directly or indirectly, or prohibiting the free exercise thereof; or
18. Imposing any disability, or conferring any privilege, advantage, or benefit, on account of religious belief, or raising or appropriating directly or indirectly, save as heretofore, any public revenue for any religious purpose, or for the benefit of the holder of any religious office as such; or
19. Diverting the property, or, without its consent, altering the constitution of any religious body; or
20. Abrogating or prejudicially affecting the right to establish or maintain any place of denominational education, or any denominational institution or charity; or
21. Whereby there may be established or endowed out of public funds any theological professorship, or any university or college in which the conditions set out in the University of Dublin Tests Acts, 1873, are not observed; or
22. Prejudicially affecting the right of any child to attend a school receiving public money without attending the religious instruction at that school; or
23. Directly or indirectly imposing any disability or conferring any privilege, benefit, or advantage upon any subject of the Crown on account of his parentage or place of birth, or of the place where any part of his business is carried on, or upon any corporation or institution constituted or existing by virtue of the law of some part of the Queen's dominions, and carrying on operations in Ireland, on account of the persons by whom or in whose favour, or the place in which any of its operations are carried on; or
24. Whereby any person may be deprived of life, liberty, or



---

p.91



property without due process of law in accordance with settled principles and precedents, or may be denied the equal protection of the laws, or whereby private property may be taken without just compensation; or
25. Whereby any existing corporation incorporated by Royal Charter or by any local or general Act of Parliament may, unless it consents, or the leave of Her Majesty is first obtained on address from the two Houses of the Irish Legislature, be deprived of its rights, privileges, or property without due process of law in accordance with settled principles and precedents, and so far as respects property without just compensation. Provided nothing in this sub-section shall prevent the Irish Legislature from dealing with any public department, municipal corporation, or local authority, or with any corporation administering for public purposes taxes, rates, cess, dues, or tolls, so far as concerns the same. Any law made in contravention of this section shall be void.



The power to impose taxation other than duties of custom and excise was to be transferred, subject to a short delay as to existing taxes and to a special provision in respect of taxes for war expenditure, to the Irish Legislature (clause II). Two judges of the Supreme Court in Ireland, to be called ‘Exchequer Judges,’ were to be appointed under the Great Seal of the United Kingdom, and to be removable only on an address from the Imperial Parliament; and proceedings relating to the reserved powers or to the customs or excise duties were to be determined by such judges (clause 19). Appeals from the Courts in Ireland were to lie to the Judicial Committee of the Imperial Privy Council (clause 21), and any question as to the powers of the Irish Legislature could be referred to the same Committee (clause 22). The Royal Irish Constabulary and Dublin Metropolitan Police Force were gradually to disappear, and police matters to be regulated by the Irish Legislature and Executive (clause 29). The Irish Legislature was to be prohibited from passing land legislation for a period of three years (clause 34).


As to these proposals the first observation that occurs is that, in addition to the matters proposed to be reserved, there are others in which legislative uniformity throughout



---

p.92



the kingdom is greatly to be desired. To mention but a few such matters, questions of status, contract and succession, of international trade and navigation, of the regulation of railways and of industrial labour, and of the criminal law, should not be differently determined in different parts of the kingdom; and as life becomes more complex, the number of subjects in which diversity of laws is a hindrance continues to increase.


In the next place, it is to be noted that the checks proposed affect legislation only and not administration. If the Bill of 1893 or any similar Bill should become law, the whole executive power in Ireland will be in an Irish Ministry responsible to an Irish Assembly; and it is obvious that many of the wrongs against which the restrictive clauses of the Bill were directed may be inflicted by administrative act or omission as effectively as by legislation. To quote a work of authority [24](javascript:footNote('E900031/note024.html'))—

*An independent Irish Executive will possess immense power. It will be able by mere administrative action or inaction, without passing a single law which infringes any restriction to be imposed by the Irish Government Act, 1893, to effect a revolution. Let us consider for a moment a few of the things which the Irish Cabinet might do if it chose. It might confine all political, administrative, or judicial appointments to Nationalists, and thus exclude Loyalists from all positions of public trust. It might place the bench, the magistracy, the police, wholly in the hands of Catholics; it might by encouragement of athletic clubs where the Catholic population were trained to the use of arms, combined with the rigorous suppression of every Protestant association suspected, rightly or not, of preparing resistance to the Parliament at Dublin, bring about the arming of Catholic, and the disarming of Protestant, Ireland, and at the same time, raise a force as formidable to England as an openly enrolled Irish army. But the mere inaction of the executive might in many spheres produce greater results than active unfairness. The refusal of the police for the enforcement of evictions would abolish rent throughout the country. And the same result might be attained by a more moderate course. Irish Ministers might in practice draw a distinction between ‘good’ landlords and ‘bad’



---

p.93



landlords, and might grant the aid of the police for the collection of ‘reasonable’, though refusing it for the collection of ‘excessive’ rents.’’*


Irish Ministers might even refuse actively to oppose the ‘moral claim’ of the Irish Catholics to the use of the cathedrals and of the accumulated capital of the Irish Church.[25](javascript:footNote('E900031/note025.html'))


To contemplate the possibility of action or calculated inaction of the character above described is not to attribute to Irishmen any special measure of original sin. In every case where the executive power is divorced from the ultimate legislative authority such divergencies are likely to recur; and more than one instance may be found in our own recent history. In 1859 the Canadian Government warned the Home Government that any attempt to interfere with the customs policy of the Dominion was inadmissible, unless the home authorities were prepared to undertake the responsibility of administering the whole government of Canada. The Home Government gave way.[26](javascript:footNote('E900031/note026.html')) In 1878 the Governor of Cape Colony proposed to place the colonial forces under the control of the officer commanding the Imperial forces. The Cape Government resisted, and refused to resign; and eventually the Governor, on the advice of the Home Government, dismissed his ministers. In this case a change of government occurred after the general election, but in the end the claim put forward by the Imperial authorities had to be withdrawn.[27](javascript:footNote('E900031/note027.html')) In 1906 the Natal Government proclaimed martial law, and ordered the execution of twelve natives on charges of murder. The Imperial Government intervened, and suggested the suspension of the order pending further consideration. The Natal Ministry immediately resigned; and as there was no chance of the formation of a new Government, the Imperial authorities hastily withdrew.[28](javascript:footNote('E900031/note028.html'))




---

p.94


Differences have arisen even on so grave a matter as the succession to the throne. The union of England and Scotland in 1707 was preceded and hastened by the so-called Act of Security, by which the Scottish Estates asserted the right to name a successor to the throne of Scotland, who should not (except under certain specified conditions) be the person designated as sovereign by the English law. And during the illness of King George III. in the year 1788, **Grattan**, in defiance of the views of **Pitt** and of the majority in both Houses of the Imperial Parliament, carried in the Irish Parliament an address to the Prince of Wales, calling upon him (without waiting for a Regency Bill) to assume the Government of the Irish nation, ‘and to exercise and administer all legal power, jurisdiction and prerogatives to the Crown and Government thereof belonging’ —words borrowed from the address by which in the Revolution of 1688 **William of Orange** was requested to assume the Crown. Happily, the Viceroy declined to present the address, and a deputation sent from Ireland to present it found on their arrival that the king had recovered, but the incident might have led to a conflict upon a matter so important as the exercise of the royal power.


The fact is that the word ‘supremacy,’ so often used in this controversy, is one of ambiguous meaning. Parliament is supreme in the United Kingdom, Parliament is likewise supreme in New Zealand; but the two supremacies are of widely different kinds. Supremacy consists of two ingredients—authority to enact and power to enforce; and without the latter the former is little more than a legal figment, which may have no more practical importance than the theoretical right of veto which is retained by the Crown. **Mr. Balfour**, speaking on the second reading debate of the 1893 Bill, referred to this matter as follows:

*Legally, of course, the Imperial Parliament would be supreme: no one has doubted it. But what layman takes the slightest interest



---

p.95



in these paper supremacies? For my part I take no more interest in the question of whether the Imperial Parliament is on paper superior to the Irish Parliament, than I do as to the order of precedence at a London dinner party. The thing is of no public interest or importance whatever. What we want to know is where the power lies. Who is going to exercise supremacy? Who is going to be the de facto ruler of Ireland?’’*


Special importance attaches to these considerations owing to the heavy liabilities undertaken by this country in respect of land purchase in Ireland. At the present time many millions of British money are sunk in Irish land, and the amount may increase to a sum approaching two hundred millions. The tenants now pay their annuities because, in the last resort, the Government can turn them out. Under Home Rule the powers of Government would rest with men who have led ‘no rent’ agitations in the past, and who would be dependent upon the votes of those personally interested in repudiating the debt. The British Treasury can hardly run such a risk; and some sort of concurrent control, with all its evils and risks, seems to be necessary. And yet financial independence is the first essential to genuine autonomy.


But, it may be said, if the Irish Government go beyond the law, the Irish Courts may be asked to interfere; and in the event of their refusal, the Bill provides an appeal to the Judicial Committee in London. No doubt it does, but in practice the person aggrieved might have very great difficulty in making the remedy effective. He must obtain a decision in his favour from the Judicial Committee of the Privy Council, at no small cost of money and personal odium; and the decision of that ‘alien’ tribunal (as it would be called) must then be enforced under the jurisdiction of a Government which (on the hypothesis which we are considering) would be unfriendly, by judges and executive officers appointed and perhaps removable by that authority, and in the midst of a population hostile to ‘foreign’ interference. Is it extravagant to suppose that the complainant would not gain much by his appeal to Caesar?




---

p.96


And even if we suppose the Irish Legislature and Executive to confine themselves within the letter of the Act, are the checks of any real value? The Irish Parliament might still interfere with contracts, or might validate contracts now held to be void as contrary to public policy. They might defeat the Mortmain Acts. They might deal as they thought fit with internal trade; and the great industries of Belfast and its neighbourhood might find their views on trade questions of no avail. The Irish Legislature might create new offences and institute new tribunals; and the reference in the Bill to ‘due process of law’ would not necessarily secure trial by jury or by an impartial tribunal.[29](javascript:footNote('E900031/note029.html'))


It is said that legislation of this character would be subject to the veto of the Crown. But that veto is to be exercised on the advice of the Irish Ministry subject to any instructions given by the Sovereign; and so long as an Irish Legislature is entitled to withhold Irish supply, a veto against the advice of the Irish ministry would surely tend to become impossible.


Again, it is said that an unjust law passed by the Irish Parliament might be repealed by the Imperial Parliament. Doubtless the technical right would exist, as in the case of the Colonies; but no one dreams that, with ‘responsible’ government existing in Ireland and Irish representatives at Westminster, it would in practice be used. The Imperial Government has never been known to interfere with the legislation of a self-governing colony except where Imperial interests are concerned, or where a fraud on the colony can be established;[30](javascript:footNote('E900031/note030.html')) and the same rule would obtain in the case of Ireland.


Lastly, it is said that in the last resort there is the British Army. But if the civil power in Ireland does not call in the military force, how can the latter be used to enforce the law? Are the forces to be controlled from England, and what is this but a counter revolution? It



---

p.97



is hardly worth while to liberate Ireland from the peaceful rule of the Imperial Government in order to govern her by military force.


But in fact the so-called ‘safeguards’ would not last. Professor Dicey[31](javascript:footNote('E900031/note031.html')) and Professor Morgan,[32](javascript:footNote('E900031/note032.html')) writing from opposite sides of the controversy, agree in holding that no colony would tolerate them for a moment; and it is incredible that Ireland, with a Parliament of her own, would submit to them for more than a few years.[33](javascript:footNote('E900031/note033.html')) Suppose the majority of the Irish Legislature to grow weary of the ‘safeguards,’ and to demand their repeal. The Imperial ministry might refuse, but the reply of the Irish ministry (if in command of a majority in the Irish House of Commons) would be to resign and to make the government of Ireland impossible except by force. And if Ireland were still represented in the Imperial Parliament, the new ‘sorrows of Ireland’ would find eloquent and insistent expression there. What, then, would England do? What could she do, except, after a futile struggle, to give way? The truth is, that if you part with the executive power, all checks and ‘safeguards’ are futile. **Mr. Redmond**,[34](javascript:footNote('E900031/note034.html')) eagerly ‘accepts every one of them,’ and will accept others if desired; for he knows that they must prove ineffective. ‘If,’ said **Lord Derby** in 1887, ‘Ireland and England are not to be one, Ireland must be treated like Canada or Australia. All between is delusion or fraud.’


#### Irish Representation at Westminster


The hybrid form of government proposed in the Bills of 1886 and 1893 gave rise to a further difficulty, and one which went far towards wrecking them both.



---

p.98



Should Ireland under Home Rule be represented at Westminster by its members and representative peers? Under a system of Gladstonian Home Rule there appear to be only three possible answers to this question. The Irish representatives may be excluded altogether, they may be retained altogether, or they may be retained in diminished numbers and with some limitation on their voting powers.


The total exclusion clause in the Bill of 1886 was one of the most unpopular parts of an unpopular Bill. It was immediately urged that this arrangement was virtually equivalent to separation, and **Mr. Gladstone** admitted [35](javascript:footNote('E900031/note035.html')) that the argument had force. Since 1886 public sentiment has advanced in the direction of a closer Imperial unity, and it is unlikely that the country will recur in 1912 to a proposal which in 1886 was admitted to be intolerable. Moreover, if the British Parliament is to retain control of the whole foreign policy of the kingdom, and—what is likely to be of enormous importance in the future—of its whole fiscal policy, it would be manifestly unjust to deny to Ireland a voice and vote in such matters. How would it be possible, for instance, to discuss the effect upon agriculture of a Tariff Reform Budget in the absence of competent representatives of the Irish farmers, or to consider the yearly grant to be made (as it is said) in aid of Irish finance without the assistance of any representatives of Ireland?


A recognition of the difficulties in the way of total exclusion led **Mr. Gladstone** to propose, in 1893, what was known as the ‘popping-in-and-out clause,’ under which Irish members would have sat at Westminster, but would have voted only on Imperial measures. The best criticism of this attempt to distinguish between local and Imperial matters was supplied on another occasion by **Mr. Gladstone** himself:—

‘I have thought much, reasoned much, and inquired much with regard to that distinction, but I have arrived at the conclusion that it cannot be drawn. I believe it passes the wit of man.’




---

p.99


To distinguish between matters which might and those which could not affect Ireland was impossible to the ordinary man, and the device of committing all matters of special difficulty to the decision of **Mr. Speaker** had not then its present vogue. Further, it was obvious that under such a system a British Ministry might have on one day, when English or Scottish affairs were under discussion, a commanding majority; but on the next, when a vote possibly affecting the sister island was in question, might find itself labouring in the trough of the sea; while on the third day, that vote having been disposed of and the Irish members having taken their leave, it might rise once more on the crest of the wave. The proposal was too ludicrous to be long defended. The sense of humour of the House prevailed over **Mr. Gladstone**'s earnestness, and he fell back on inclusion for all purposes.


But inclusion for all purposes had its own difficulties. Under the Gladstonian system the Imperial Parliament would have considered, not only matters affecting the whole kingdom, but also purely English or purely Scottish affairs; and to give to the Irish representatives the control in their own Parliament of purely Irish affairs, and also a voice at Westminster on matters affecting England or Scotland only, was obviously unjust. Such a power would have been used, not for the benefit of England or Scotland, but as an instrument for wresting further concessions for Ireland.


‘I will never be a party,’ said **Mr. Gladstone** at one time, ‘to allowing the Irish members to manage their own affairs in Dublin, and at the same time to come over here and manage British affairs. Such an arrangement would not be a Bill to grant self-government to Ireland, but one to remove self-government from England; it would create a subordinate Parliament indeed, but it would be the one at Westminster, and not that in Dublin.’ [36](javascript:footNote('E900031/note036.html'))


The problem seems insoluble because, under a hybrid (or Gladstonian) system of Home Rule, it is insoluble. If



---

p.100



a clear line is taken, there is no difficulty under this head. If full ‘responsible’ or colonial government is granted, clearly representation in the Imperial Parliament (I do not now speak of a federal assembly) is an anomaly. On the other hand, if nothing more is in question than the extension of local government generally known as Devolution, then adequate representation in the Imperial Parliament is a matter of course. If a federal government is established, each member of the Federation must needs be represented in the federal Parliament; but in that case there must be no attempt to entrust to the same assembly both the duties of the federal Parliament and those of a Legislature for one of the federating states. It was this attempt to treat the Imperial Parliament as the local or state Legislature for Great Britain, and also as the federal Parliament for Great Britain and Ireland, which was fatal to **Mr. Gladstone**'s proposals.


#### Federalism


These considerations bring us face to face with Federalism, or, to use the phrase which to so many perplexed Liberals has seemed to point the way to safety, ‘Home Rule all round.’ The expression covers a wide field, and before any opinion can be pronounced upon the proposal, it is essential to know what its advocates in fact desire.


To some the phrase means nothing less than Gladstonian Home Rule ‘all round,’ in other words that we should meet the objections to dissolving the legislative and executive Union with Ireland by dissolving also the older Union with Scotland, and even (for some do not shrink from the reductio ad absurdum) the yet older unity of England and Wales. Consider what this means. For more than two hundred years the English and Scottish races have been united by a constitutional bond strengthened by mutual respect and good feeling, and Scotsmen, like Englishmen, have taken their part in the government of these islands. If in the division of labour and of honours there has been



---

p.101



a balance of advantage, it has not been against the virile Scottish race, from which have sprung so many of our great soldiers and administrators, so many leaders of the nation. And such a combination is to be broken up, and Scotland to become a colony, because Ireland, unwilling to bear her share in the duties of government, desires to be reduced to that status! To such a proposal **Mr. Gladstone**'s phrase about applies in all its force:— 

*Can any sensible man, can any rational man, suppose that at this time of day, in this condition of the world, we are going to disintegrate the great capital institutions of this country for the purpose of making ourselves ridiculous in the sight of all mankind, and crippling any power we possess for bestowing benefits through legislation on the country to which we belong?’’*



The proposal would be incredibly stupid, if it were not recklessly mischievous.
But to most advocates of the federal system the word means less than this; and the conception, usually vaguely expressed, is that the relations of England, Scotland, and Ireland, should be something like those of the communities which make up (to quote instances commonly given) the German Empire, the Swiss Federation, the United States of America, or the British self-governing dominions of Canada, Australia, and South Africa. So expressed, the aspiration for a federal union deserves respectful consideration.


In the first place, it must not be forgotten that no proposal of this nature has yet been put forward, even in general terms, by any English or Irish Party. **Mr. John Redmond**, the leader of the Irish Nationalists, has indeed said that he and his friends ‘were only asking what had already been given in twenty-eight different portions of the Empire:’ [37](javascript:footNote('E900031/note037.html')) and a speaker usually more careful in his language [38](javascript:footNote('E900031/note038.html')) lately suggested to his audience that they should

‘ask the twenty-eight Parliaments if the Empire would be split in pieces if there were a twenty-ninth.’ 



---

p.102



But in order to make up the number of Parliaments and Legislatures within the Empire to twenty-eight it is necessary to include in one category the Parliament of the United Kingdom, the colonial Parliaments of Newfoundland and New Zealand, the federal Parliaments of Canada and Australia, the provincial or state Legislatures (widely differing from one another in their constitution and powers) comprised in those Federations, the Union of South Africa and its constituent provinces, and the tiny assemblies surviving in the Channel Islands and the Isle of Man. From a reference so vague and confused no inference as to the real meaning or desire of either speaker can safely be drawn.[39](javascript:footNote('E900031/note039.html'))


But let us put aside, with the foreign confederacies (which have in most cases been achieved or maintained by armed conflict), the practically independent Parliaments within the British Empire, and confine ourselves to the Federations of Canada and Australia, and to the Union (sometimes incorrectly called a Federation) of South Africa.


In the first place, it is not immaterial to observe that each of the Legislatures here referred to resulted, not from the dissolution of an existing union, but from the voluntary assumption by communities formerly independent of one another of a closer bond. In other words, there was in each case a real foedus or treaty, not imposed by the Imperial power, but having a local origin and springing from the need of common action. The operative force was centripetal and as the force continues to operate, the tendency of the mass is towards a chemical in lieu of a mechanical fusion.[40](javascript:footNote('E900031/note040.html')) But in the case of the United Kingdom a change from organic union to Federation would be the beginning of dissolution; and the centrifugal force, once set motion, might lead further in the same direction.


Again, there can be no true federation without (1) provincial



---

p.103



legislatures and executives, (2) a central Parliament and executive, (3) a careful definition of the powers of each, and (4) a federal court to which should be entrusted the duty of determining questions arising between the federal and provincial governments and legislatures. If, therefore, provincial or state Governments are created for Ireland and for Scotland, a like Government should logically be created for England. Are we prepared to see four (or, if Wales be added, five) legislatures, and four (or five) executives, in these islands? Have we considered the possible effect on our whole system of government, on the theory of Cabinet responsibility to Parliament, on the powers of the House of Commons over grievance and supply? Must not each unit in a Federation be put as regards financial matters upon a like footing; and, if so, can Ireland bear her share? Is federation consistent with the predominance of one state, England, in wealth and population? These questions are vital, and none of them have received consideration. By declaring in general terms for Federalism you go but a little way.


And if we treat the proposal for Federation as indicating a desire to adopt a constitution under which the relations of the United Kingdom to each of its constituent parts would be as the relation of some one of the three self-governing Dominions to the states or provinces of which it is composed, the question remains, which of those Dominions should be adopted as a model? For they differ not only in form but in essence.


Under the British North America Act, 1867, and the amending statutes, there is ‘one Parliament for Canada’ (sect. 17), while each province has its Legislature. Each provincial Legislature is empowered exclusively to make laws in relation to certain specified subjects (including property and civil rights and the administration of justice), and also in relation to ‘all matters of a merely local or private nature in the province’; while the Dominion Parliament may ‘make laws for the peace, order, and good government of Canada in relation to all matters not



---

p.104



coming within’ the classes of subjects assigned exclusively to the provincial Legislatures. The division of functions has given rise to much confusion and litigation; but, speaking generally, the trend of judicial decision has been towards a wide interpretation of the provincial powers. The ‘residuary powers’ are in the Dominion Parliament.


The constitution of the Commonwealth of Australia, as defined by the Commonwealth of Australia Constitution Act, 1900, is of a different character. The Federal Parliament is entrusted with power to make laws with respect to a number of subjects divided into no less than 39 classes (sect. 51); the State Legislatures have concurrent powers of legislation, but in case of conflict the law of the Commonwealth is to prevail over the State law (sect. 109). The ‘residuary powers’ are in this case left to the States. There is power to alter the Constitution with the consent of a majority of the electors in a majority of the States and of a majority of the electors of the Commonwealth (sect. 123)—a power which has been freely used.


The case of South Africa is sometimes cited as a precedent for loosening the bonds in the United Kingdom. It is a strong precedent for closer union. The South Africa Act, 1909, created in fact as well as in name, not a Federation but a true Legislative Union. Under the Act, the South African colonies were ‘united in a legislative union under one government under the name of the Union of South Africa’ (sect. 4). The legislative power is vested in the Parliament of the Union (sect. 19), which has full power to make laws for the peace, order, and good government of the Union (sect. 59). In each province (formerly a colony) there is an administrator appointed by the Governor-General of the Union in Council (sect. 68), and a Provincial Council (sect. 70); but the powers of the Provincial Councils are confined within narrow limits (sect. 85), and their ordinances (they are not called laws) have effect within the province as long as and so far as they are not repugnant to any Act of the Union



---

p.105



Parliament (sect. 86). The Supreme Courts of the old colonies become provincial divisions of the Supreme Court of South Africa (sect. 98), and the colonial property and debts are transferred to the Union (sects. 121-124). In fact, in South Africa, where, as in Ireland, the distinction in the past has been racial and not territorial, Union and not Federation has gained the day. It is safe to prophesy that the coming proposals of the Government will not follow the South African plan.


#### Devolution


The South African precedent leads naturally to a few observations on the proposals for the extension of local self-government, usually classified under the head of Devolution. These proposals differ, not in degree only but in kind, from schemes for the granting of responsible government, or Gladstonian Home Rule. Under all devolutionary schemes, properly so-called, the central Parliament and executive remain the ultimate depositaries of power; and the powers entrusted to local bodies are administrative only, and can be resumed at will. The Acts by which County Councils were set up, first in Great Britain and afterwards in Ireland, were steps in this direction. The Welsh Intermediate Education Act, 1889, was another. The establishment by the Agriculture and Technical Instruction (Ireland) Act, 1899, of a Council of Agriculture, as Agricultural Board, and a Board of Technical Instruction, was a third. By these statutes wide powers are delegated to representative bodies directly or indirectly elected by popular vote; but in each case the delegated powers are strictly defined, their exercise is made subject to central control, and the right of Parliament to modify or withdraw any of them is absolute and unquestioned. The appointment by the House of Commons of a Grand Committee for Scottish Bills is another experiment of a similar character, though on different lines. Such delegations of power are consistent with the maintenance in its entirety of the



---

p.106



Union of the Kingdom, and there is no reason whatever why further progress should not be made in the same direction. The events of 1907 are evidence that Devolution, regarded merely as a means of satisfying the political cry for Home Rule, is indeed ‘dead.’ But when the din of political battle has once more passed by, it may be possible to obtain consideration for a moderate and clearly defined scheme of delegation which, if applied not exclusively to Ireland, but to the whole country, might relieve the House of Commons of much of its work, and strengthen the habit of local self-government throughout the United Kingdom.




---

p.107


### Home Rule Finance

### By the Right Hon. J. Austen Chamberlain, M. P.


The financial problems connected with the grant of in 1912 are among the most complicated that call for solution, and differ fundamentally from those which faced the Governments of 1886 and 1893. And by common consent, the problems are not merely different; they are immensely more difficult. No clauses in the earlier Bills lent themselves more readily to destructive criticism; and though the provisions of the new scheme are still shrouded in mystery, it is inherent in the conditions under which it must be framed that the financial clauses will prove to be even less defensible on the grounds of logic or equity than those of either of its predecessors.


Since the first Bill was introduced the interests of Ireland— social, economic, industrial, and political—have become increasingly identified with those of the other parts of the United Kingdom. The commercial, banking, and railway systems of Ireland are intimately associated with those of the greater and more firmly established systems of Great Britain. Irish railways are so largely controlled at the present time by British concerns, and there exist so many agreements and understandings between them and British companies as to facilities and rates, that they might be regarded as part of the same network of communications. Hardly less close are the relations which now exist between British and Irish banks.


It is not, however, on the commercial side only that greater intimacy and more firmly established relations exist now than formerly. Irish industries are agricultural, dairying and manufacturing. In each of these branches the



---

p.108



country is increasingly dependent on the markets of England and Scotland; while reciprocally the products of the factories and workshops of Great Britain find in Ireland one of their most important markets. We do not always sufficiently realise that on the other side of the St. George's Channel lies a country whose annual imports amount to sixty-five millions sterling. Even less do we realise that one-half (thirty-two millions sterling) is the value of the imports of manufactures, mainly British, into Ireland. This trade in manufactured goods is not only already enormous; it is rapidly growing. It has increased by more than four millions in four years. Any ill-considered legislative measure which interfered with or disturbed this great volume of trade would no doubt cause serious loss to Ireland; but it would bring bankruptcy and disaster to many British firms and their workmen.


It is, nevertheless, in respect of the political changes and the legislative measures passed in the last quarter of a century that the most serious obstacles will be found in the way of framing any satisfactory scheme for financing a measure of Home Rule. The Irish Local Government system, framed on the British model by the Act of 1898, the Congested Districts Board, and the Department of Agriculture, have hitherto depended financially, either wholly or in part, on Imperial grants in aid. Local taxation payments alone from the Imperial Exchequer amounted in 1910–11 to £1,478,000. The financial scheme under Home Rule must obviously contemplate and provide for the continuance of those grants. Land Purchase schemes have been enacted which have already had the effect of converting a quarter of a million tenants into owners under a contingent liability of 120 millions sterling guaranteed by the Imperial Exchequer. No financial scheme can ignore the fact that the earliest of the annuities created under the Wyndham Act will not expire before 1972, So that the Imperial liability for the payment of the bulk of the annuities already created will continue for at least seventy years more.


Finally, we are faced with the fact that in the last twenty-five years the relations of the State to its citizens



---

p.109



have been completely reformed and extended. Social reform is now in the programme of all parties. Education costs several times as much as in 1885. The aged poor have been provided with pensions by the State, and the Insurance Act of last year will shortly call for additional subventions from the Imperial Treasury.


In addition to the new duties thus undertaken by the State, the cost of Defence and of the Civil Services has grown by leaps and bounds. We need not look too closely into the apportionment of these charges whilst we remain partners in a United Kingdom, but if the partnership is to be dissolved at the suit of Irish Nationalism, a new balance must be struck, and on any fair basis the contribution of Ireland under present-day conditions should far exceed the amount under either of the schemes for which **Mr. Gladstone** made himself responsible. Both schemes recognised the equity of some contribution for these services from Ireland, and it must be assumed that the same broad principles will be applied in any scheme which may be framed hereafter.


By way of introduction to any adequate discussion of the possible financial proposals of any measure, it is desirable to set out in some detail the existing financial relations of Ireland and Great Britain. The Treasury calculations on this subject are embodied in two White Papers which have been prepared and published annually during the last eighteen years. It is true that doubts have from time to time been cast on the accuracy of these calculations and of the methods by which the materials on which they are based have been collected. As to this, it is only necessary to say that the information in the possession of the Treasury officials is infinitely more voluminous and likely to be more accurate than any in the possession of private individuals; and there is no reason to suppose the succession of eminent public servants, who have been in turn responsible for the preparation of these returns have been moved in one direction or the other by prepossessions or bias. Their one attempt has been throughout to present a statement, as accurate as it is possible to make it, on the



---

p.110



one hand of the cost of the existing administration in Ireland and the expenditure incurred there, and on the other of the revenue derived from persons or property living or situated in that country. As the Prime Minister said on November 27 of last year—

*The utmost pains have been taken to make the estimates of ‘true’ revenue approximately correct, and it is believed that the total revenue as given in the revised returns approximates closely to the facts.’’*

See Parliamentary Debates.


So long as Ireland is an integral part of the United Kingdom, such an investigation has mainly an academic interest. The State is a homogeneous entity; the taxes imposed on individuals similarly circumstanced are the same (with some trifling exceptions—all in favour of Ireland) in whatever quarter of the United Kingdom the individual resides. But the case is wholly different when a proposal is made to split up the State into its constituent parts. It then becomes necessary to inquire if there is any prospect that the constituent parts will have resources sufficient for the various services, commitments and liabilities—present and contingent—which do or will belong to them. And the beginning of any such inquiry is, as has been already said, the present Irish revenue and expenditure.


The essential figures for such an investigation are contained in the following statement. This shows separately the expenditure on the various items which have been the subject of discussion or special mention in the different financial schemes proposed in connection with Home Rule. On the revenue side the effect of the delayed collection of duties under the Budget of 1909–10 has been eliminated by taking the average revenue in the two years in certain items. The figures of expenditure relate to the year 1910–11. The corresponding figures for both collection and contribution are set out in this table in consequence of the suggestion made in some quarters that we should revert to the Gladstonian proposal of 1886 and credit Ireland with the




---

p.111





| Source of Rev. | Rev. as coll in £ | Rev. as contrib. in £ | Source of Exp. | Expenditure in £ |
| --- | --- | --- | --- | --- |
| 1. Customs * | 2,922,000 | 2,866,000 | 1. Civil List and misc. charges | 118,500 |
| 2. Excise * | 4,872,200 | 2,952,000 | 2. Lord-Lieutentant's salary | 20,000 |
| 3. Licence Duties * | 284,000 | 284,000 | 3. Local Taxation Payments | 1,477,500 |
| 4. Estate, etc. * | 914,000 | 914,000 | 4. Public Works | 415,500 |
| 5. General Stamps * | 310,000 | 333,000 | 5. Civil Service Departments | 289,500 |
| 6. Income Tax * | 1,106,000 | 1,307,000 | 6. Department of Agriculture | 415,000 |
| 7. Postal Services | 1,155,000 | 1,155,000 | 7. Police | 1,464,500 |
| 8. Miscellaneous | 139,000 | 139,000 | 8. Judiciary, etc. | 924,000 |
|  |  |  | 9. Education, etc. | 1,805,000 |
|  |  |  | 10. Old Age Pensions | 2,408,000 |
|  |  |  | 11. Superannuation, etc. | 103,000 |
|  |  |  | 12. Ireland Development Grant | 191,500 |
|  |  |  | 13. Miscellaneous | 12,000 |
|  |  |  | 14. Revenue Departments | 298,000 |
|  |  |  | 15. Postal Services | 1,404,500 |



* Average of two years, 1909–10 and 1910–11.




---

p.112


full revenue as collected. Though any such proposal is patently absurd it is mentioned here for the sake of completeness.


The first striking fact in the foregoing statement is the large difference between ‘contributions’ and ‘collections,’ i.e. between the ‘true’ revenue derived from Ireland and the sums merely collected there. During the last two financial years this difference amounted to an average of £1,752,000. The excise collections alone represent an excess of £1,920,000 over the actual contribution. This, of course, arises from the movements of duty-paid spirits and beer between different parts of the United Kingdom. The last Report of the Commissioners of Customs and Excise (Cd. 5827) gives the amount of home-made spirits on which duty has been paid in Ireland at 5,209,000 proof gallons, whereas the quantity retained for consumption was only 2,776,000 proof gallons. A similar but smaller difference exists in the case of beer. To credit Ireland with the full amounts of the duties collected in Ireland, as was done by **Mr. Gladstone** in 1886, and as is now proposed in some quarters, would, in effect, amount to a gift from the British Exchequer of £1,750,000 a year. And there is obviously no security that the Irish Exchequer could rely on this boon being continued for more than a short time. There would be nothing to prevent the British spirit merchant from removing his spirits to this country in bond and paying the duty here after arrival. It is obvious that the Treasury would be compelled to grant facilities for this course. The present system is merely one of book-keeping and administrative convenience, but as the withdrawal of this sum from the British Exchequer to which it properly belongs would have to be made good from other British sources, there would be every inducement for the British merchant to effect such slight changes of method as would transfer the whole of this sum from the Irish to the British Exchequer. Having regard to the fact that on the other sources of revenue the collections in Ireland are estimated to fall short of the actual contributions by nearly £200,000,



---

p.113



and that these are in the main direct taxes paid by the individuals concerned, it is not unlikely that a scheme which gave to Ireland the full benefit of her revenues as collected would in a short time be converted from a gain of some £1,700,000 to a loss of £100,000 to £200,000 to the Irish taxpayer. Stability in the tax system and reliability upon the realisation of the estimated revenue could not be assumed if ‘collections’ instead of ‘contributions’ were to be made the basis of any financial arrangements.


Turning next to the contributed revenue upon which alone an Irish Parliament could rely, we note first the large proportion of the revenue represented by Customs and Excise. Contrasted with the figures for Great Britain, it is seen by the following table that whereas in Ireland the revenue from Customs and Excise amounts to 60 per *cent* of the total, in Great Britain the proportion was not more than 36 per cent.


Percentage of Revenue from different sources contributed by Ireland and Great Britain respectively in two years ending March 31, 1911.[41](javascript:footNote('E900031/note041.html'))



| *Source of Revenue* | Ireland per cent | Britain per cent |
| --- | --- | --- |
| Customs | 29 | 18.5 |
| Excise (ex. licences) | 30 | 17.5 |
| Estate, etc., duties | 9 | 14.5 |
| Income tax | 13 | 23.5 |
| Postal, etc. | 11 | 15 |
| Other sources | 8 | 11 |
| *Total* | 100 | 100 |






Exclusive of the licence duties the average yield (contribution) of Customs and Excise in Great Britain amounted in the last two years to £55,900,000, or at the rate of £1 7s. 5d. per head; in Ireland the average yield was £5,800,000, or at the rate of £1 7s. 10d. per head. The incidence of our consumption taxes is thus seen to be at the present time practically the same in Ireland as in Great Britain; and the much larger proportion of the Irish revenue obtained from them is due to the smaller relative



---

p.114



yield of direct taxes. Ireland being mainly an agricultural country, income tax, death duties, and stamps yield much less per head of the population there than in Great Britain. Such conditions are highly suggestive of inelasticity. An Irish Chancellor of the Exchequer will find no such fiscal reserves in direct taxes as does his more fortunate British colleague. This conclusion should give pause to those who think that if the Customs and Excise continued to be controlled from Westminster, it would be still possible to extract the larger revenue needed for the growing expenditure of Ireland by higher rates of income tax and death duties. Such a course would increase the burdens of the direct taxpayers of Ireland, but it would not fill the Irish Treasury. On the other hand, it is clear that there is no chance of relief being afforded to the Irish indirect taxpayer under Home Rule, supposing Customs and Excise were handed over to the Irish Parliament. Yet whenever a British Chancellor of the Exchequer has found it necessary to increase any of the taxes on consumption, the protests from the Irish benches have been invariably both loud and vehement. Irish members have pointed to the low wages earned in Ireland, the greater addiction of the people to tea and spirits, and the higher toll of their earnings consequently extracted by the Exchequer. The yield of existing taxes, therefore, whether direct or indirect, is not elastic in Ireland. Neither of them afford sufficient resources to meet the necessities of an Irish Parliament.


There are, of course, other reasons why there should be no delegation of the power to impose Customs and Excise. The constitutional objections to such a course are overwhelming. It would involve the abandonment of the plea that for Ireland was the prelude to all round; in other words, that separation was the condition precedent to federalism. In every federal system in the world the control of Customs and Excise has been retained by the central authority. This is true not only of the quasi-federations within the British Empire; it is



---

p.115



equally true of the United States, Germany, and Switzerland. One can scarcely be surprised at the emphatic repudiation which such a proposal received at the hands of the Parliamentary Secretary to the Board of Trade (Mr. **J. M. Robertson**) when, on February 7, 1912, in a speech at Lincoln, he said—

*There was, however, just one thing that must remain one for three kingdoms, and that was the fiscal system, Customs and Excise. *It was a federal union we want, a federal state.* If they were to do as some of his unreflecting friends, Irish and English, have done, and demand that Ireland should not only have power to lay taxes but to fix Customs and Excise then they had no State left at all.’’*


Another obvious objection to such a course is that it necessitates the erection of a Customs barrier between Ireland and Great Britain. Tariff Reformers are ready to admit that the present fiscal system is at least as injurious to Ireland as to other portions of the United Kingdom. The power to impose Customs duties on British goods—and the proportion of British total imports is so large that if this power were limited to foreign goods it would be financially valueless—would no doubt provide the Irish Exchequer with considerable funds and might be used to develop her prosperity. But the separation of the Customs systems for the purpose of enabling Ireland to impose tariffs in her own interests would necessarily be followed by a demand for treaty-making powers such as have been successfully claimed and are now enjoyed by British Dominions overseas. Under a general tariff for the United Kingdom the same advantages would accrue to Ireland without any corresponding damage to British or Imperial interests.


Thus, whether Customs and Excise are handed over to the Irish Parliament or retained by the Imperial Parliament, the consequences are equally embarrassing. In the one case Ireland would be deprived of the control of some 60 per *cent* of her present revenue, and of all power of expansion; in the other, British trade with Ireland might be gravely injured by hostile legislation, and the union of the three



---

p.116



kingdoms in financial and commercial policy would be destroyed. But this is not federation, nor is it a step towards it. It is separation pure and simple. Unless we are prepared to accept separation as the end of our policy the control of Customs and therefore of Excise, must remain an Imperial affair.


There can, therefore, be no justification for taking the control of the Customs and Excise from the Imperial Parliament. The Irish Parliament would thus be left with some 40 per *cent* of present revenue under her own control. But the power to raise further revenue within the limits legally reserved to the Irish Parliament would be even less than this figure would imply. For of the £4,100,000 of revenue other than Customs and Excise, nearly £1,200,000 comes from the Postal Services; and even if these services were controlled by Ireland, it may be taken that the rates charged will be the same as in Great Britain. Of the remaining £2,900,000 nearly one-half comes from income tax. It has already been pointed out that its yield cannot be materially increased. There are only two ways by which an Irish Chancellor might attempt such a task. He might raise the rate of income tax or he might lower the exemption limit. The former course would almost certainly be followed by two equally undesirable results. So far as the tax continued to be paid in Ireland it would fall with crushing force on the already heavily-burdened agricultural industry. Still, from the point of view of the Exchequer, there might be some additional revenue on this account. On the other hand, there would be a check to the investment of capital in Ireland—and no country needs capital more—and a powerful temptation to transfer it where the tax would be lower. It may be seriously questioned, therefore, whether any increase in the income tax above the British rate is practicable. The other alternative, namely, the lowering of the exemption limit, would be so unpopular that no Irish Chancellor is ever likely to consider it seriously.


Passing from the consideration of revenue it is necessary to examine the relation of present revenue to present



---

p.117



expenditure. The first table in the present article shows that the ascertainable expenditure for Irish purposes in 1910–11 was about £1,400,000 more than the revenue. To this expenditure must be added about £300,000 for the State Share of the benefits under Part I. of the National Insurance Act, about £50,000 in respect of Part II., and about £100,000 for cost of administration of both parts, increasing the immediate deficit to about £1,550,000. This calculation, moreover, includes no charge against Irish revenue on account of Imperial Services—navy and army; National Debt, interest and management; the diplomatic services, and so forth. The equity of such payments has been consistently recognised in the two Bills and the three financial schemes submitted by **Mr. Gladstone**. However moderate the scale of contribution it would in the present case double or treble the margin between Irish revenue and Irish expenditure for local purposes. If, for example, the precedent of the 1886 Bill were followed, and Ireland charged with a contribution for Imperial services in proportion to the estimated relative taxable capacities, the additional charges on the Irish Exchequer would amount to not less than about £4,000,000 on the 1910–11 figures if the taxable capacity of Ireland be taken at one-twenty-fifth, and to nearly £3,500,000 if it be taken at one-thirtieth.


It may be worth while here to refer to the amazing statement that Great Britain has made a large ‘profit out of the Union.’ At the last meeting of the British Association, **Prof. Oldham** affected to prove that Ireland ‘in the course of one hundred years ... had sent across the Channel as her contribution to the British Exchequer a clear net payment of about 330 millions sterling.’ The same contention has been urged by **Lord MacDonnell**. This calculation ignores the fact that even the Irish Parliament between 1782 and 1800 acknowledged its obligation to contribute to Imperial services, and voted contributions for Imperial purposes, besides raising and maintaining in Ireland a force of 12,000 to 15,000 men, some of whom were available for foreign service. It makes no allowance also for the debt



---

p.118



which Ireland brought into the Union when the Exchequers were amalgamated in 1817. The importance of the last item may be judged from the fact that if the whole of the so called contribution to Imperial services, i.e. the excess of true revenue over local expenditure, had been employed since 1817 in paying interest at 3 per *cent* on the old Irish debt and the whole of any balance remaining after payment of interest had been used for redemption of the capital, this debt would only have been extinguished in 1886. If a contribution of only 1 per *cent* to the cost of Imperial services had been previously charged against this excess, there would be a large balance of the Irish debt still outstanding. As a matter of fact, in the same period that Ireland is said to have contributed £330,000,000, Great Britain may be shown by a precisely similar calculation to have contributed no less than £5,800,000,000 for Imperial purposes. The measure of ‘injustice to Ireland’ meted out by unsympathetic Britons in respect to the Imperial contribution extracted from Ireland may be seen from the following comparison for different dates in the last century.


#### Ratios of Populations and Contributions to Imperial Services of Ireland and Great Britain at Decennial Intervals





| *Period* | Ratio of British to Irish Populations | Ratio of British to Irish Contributions |
| --- | --- | --- |
| 1819–20 | 2.1 | 12.7 |
| 1829–30 | 2.1 | 10.9 |
| 1839–40 | 2.3 | 11.5 |
| 1849–50 | 3.2 | 17.6 |
| 1859–60 | 4.0 | 9.8 |
| 1869–70 | 4.8 | 12.3 |
| 1879–80 | 5.7 | 16.3 |
| 1889–90 | 7.0 | 22.6 |
| 1899–*1900* | 8.9 | 46.5 |
| 1909–10 | 9.3 | * |






*[42](javascript:footNote('E900031/note042.html'))


The truth is that from a financial point of view Ireland has no valid complaint to make on the score of her contributions for Imperial purposes. Between 1820 and 1840 the Irish population was a little less than one-half of the



---

p.119



population of Great Britain; her contribution for Imperial Services varied from one-eleventh to one-thirteenth. In 1899-1900 the British contribution was 46.5 times the Irish, though the population was less than nine times as large. If any contribution for Imperial Services from Ireland is justified, and **Mr. Gladstone** at least acknowledged it, no one can say that the contribution actually taken from Ireland has been excessive.


As already stated we are still without any information as to the financial proposals to be included in the Bill of 1912. The Government have appointed a Committee to advise them upon this subject. Though the cost of the Committee has been met out of public funds, and sources of information were laid open to them which are not readily available to the public, the Prime Minister has steadily refused to supply to Parliament any information as to the results of their labours.[43](javascript:footNote('E900031/note043.html')) The terms of reference to the Commission: the witnesses examined by them the information placed at their disposal; the character of the conclusions and recommendations, these have, all alike, been refused to the House of Commons. But while Parliament has been denied this information, there is every reason to believe that the leaders of the Nationalist Party have been taken fully into the confidence of the Government. We do not know whether, for example, the Customs or Excise or both will be imposed and collected by the future Irish Parliament. We do not know whether any contribution will be required for the Irish share of Imperial services. We are equally uncertain whether any and what purely Irish services will be retained by the Imperial Parliament, and charged on the Imperial Exchequer. And lastly, the intentions of the Government in regard to the payment of a subsidy from the Imperial Exchequer to the Irish Parliament, with which rumour is busy, are as yet unrevealed.


In spite of this lamentable paucity of information as to



---

p.120



the Government plan, I think it can be safely said that no scheme even remotely resembling any of those presented in connection with the two previous Bills can be put forward now. Each of those schemes would involve the Irish Parliament in a huge deficit from the very outset. Even if the schemes were adapted to the changed modern conditions the same impassable gap between available revenue and certain expenditure remains. Those schemes presumably embodied principles which the Governments of 1886 and 1893, and the Nationalist parties of those dates regarded as adequate. It would be strange if it were otherwise, seeing that an examination and comparison of the separate schemes can discover no other consistent principles except the solitary one of juggling with the revenues, expenditures, and contributions in such manner as would start the Irish Parliament with a small surplus. In view of the importance of these earlier attempts to secure an approximation to financial equilibrium, it appears desirable to examine how Ireland would fare in modern conditions under each of them.


The essential features of the 1886 scheme were as follows:

1. Customs and Excise to be under the complete control of the Imperial Parliament.
2. Irish Parliament to have power to levy any other taxes.
3. Ireland to contribute annually to the Consolidated Fund of the United Kingdom.
4. £1,466,000 for interest and management of Irish share of National Debt.
5. £1,466,000 for contribution to Imperial Defence.
6. £110,000 for contribution to Imperial Civil Services.
7. £1,000,000 for Irish Constabulary.
8. Contributions 3 (a) to 3 (d) were not to be increased for thirty years, but might be diminished.
9. Irish share of National Debt to be reckoned at £48,000,000, and Irish Sinking Fund to begin at £360,000, increasing by amount of interest released on redeemed portion of debt.


---

p.121

12. Contribution to Imperial Defence and Civil Services not to exceed one-fifteenth of the total cost in any year.
13. Irish contribution to be credited with receipts on account of Crown Revenues in Ireland.
14. If expenditure on Constabulary fell below £1,000,000, contribution 3 (d) to be correspondingly reduced.
15. Customs and Excise *collected* in Ireland were to be subject to following charges:
16. Cost of collection, not more than 4 per cent.
17. Contributions to Consolidated Fund of the United Kingdom.
18. Payments to National Debt Commissioners.
19. Any sums required under the Land Act of that Session the balance being paid over to the Irish Government.
20. The Lord Lieutenant's salary not to fall on the Irish Exchequer.



Broadly the scheme gave to the Irish Government credit for the Customs and Excise *collected* in Ireland and charged it with annual payments of £4,502,000 in addition to the cost of collection. It is clear that **Mr. Gladstone**, at the time when the Irish population was about one-eighth of the United Kingdom, assumed Ireland to have a taxable capacity of one-fifteenth. If such a scheme were introduced at the present moment it is obvious that, owing to the further decline in the population of Ireland, a smaller figure for taxable capacity must be taken. What that figure should be it is difficult, if not impossible, to decide satisfactorily. It is generally assumed that on the basis of the calculations made by the Financial Relations Commission in 1896, the present relative taxable capacity for Ireland would be about one-twenty-fifth that of the United Kingdom. In the last two financial years the Irish contribution to Income Tax has been one-twenty-eighth, and the contribution to Estate Duties one-twenty-sixth of the total collection in the United Kingdom. These proportions, taken as measures of taxable capacity must be exceptionally favourable to Ireland, where the proportion of Income Tax



---

p.122



payers and of persons possessing property paying Death Duties is relatively to the total population smaller than in the United Kingdom as a whole. If, therefore, for the sake of the present calculations the mean of two proportions—i.e. one-twenty-seventh deducible from the Income Tax and Death Duty contributions is assumed, we employ a figure exceptionally favourable to Ireland. The financial statement on the next page showing the 1886 scheme applied to present conditions has been drawn up on this basis. The revenue is here assumed to come in at the average rate of the last two years (1909–10 and 1910–11) and the expenditure is taken as that of 1910–11.


The state of the Irish Exchequer under the foregoing scheme would be indeed a parlous one. It would start with a deficit of £3,200,000, and with a prospective immediate increase by about £450,000 on account of the Insurance Act. The actual budget deficit would thus be about £3,650,000. The Imperial Parliament would collect about £7,794,000, and after deducting £5,346,000 would hand back to the Irish Exchequer the difference of £2,458,000. The revenues upon which the Chancellor in the Irish Parliament could rely would be, therefore, £6,366,000. Out of this all expenditure of £9,562,000 would have to be met. The postal services would probably not stand any increased charges, there is left, therefore, only £5,211,000 of free revenue, and only £2,753,000 under the unrestricted control of the Irish Parliament. With such resources it would be obviously impossible to make good a deficit of £3,206,000 by any increase of taxation. It must not be overlooked, also, that the effect of crediting Ireland with Customs and Excise as ‘collected’ instead of as ‘contributed’ is practically to make the Irish Parliament a further free gift of nearly £2,000,000.


A totally different scheme accompanied the Bill of 1893 as introduced. The principal features of the new scheme were as follows: 



---

p.123


*The table on SchemeA.pdf attached here illustrates the list on p. 120–21.*


---

p.124


1. Customs, excise, and postage to be imposed by the Imperial Parliament.
2. Excise and postage to be collected and managed by the Irish Parliament.
3. Customs to be collected and retained by the Imperial Parliament in view of contribution to Imperial services.
4. Excise duties collected in Ireland on articles consumed in Great Britain to be handed over to Imperial Exchequer.
5. If Excise duties be increased the yield of the excess duties to be handed over to the Imperial Exchequer.
6. If Excise duties be reduced and Irish revenue diminished, the deficiency to be made good to Irish revenue.
7. Two-thirds of the cost of the Constabulary to be repaid to the Imperial Exchequer.



Some of the provisions of this scheme are of exceptional interest. If it had ever been in operation the plan, for example, of adjusting the payments from one exchequer to the other in the event of changes being enacted by the Imperial Parliament in the Excise duties must have been fruitful of difficulties and created much friction. It the duties had been reduced there might have been an increased consumption. Who can say how much of the revenue lost to the Irish Exchequer in the event of a reduction of duties would have been due to the reduced rates of duty, and how much had been regained by increased consumption. Again, if the Excise duties had been increased, as in the Budget of 1909, to such a degree that the total revenue at the higher duty was less than the total revenue from the lower duty, who could have determined whether this was a case requiring a payment from the Irish to the British Exchequer, or from the British to the Irish Exchequer.


Perhaps the most striking novelty of the first scheme of 1893 was the retention of the Customs duties in lieu of Ireland's contribution to Imperial Services. At that time the estimated value of the Customs contributed by Ireland was £2,400,000, and seeing that in 1886 her reasonable share of liability on account of Imperial Services was put at £4,600,000, the very large gift to Ireland represented by this scheme may be readily imagined. Even with the full advantage of this gift the estimated Irish surplus was put



---

p.125



at £500,000. During the discussions of the Bill an error in the Excise contributions, reducing the revenue available to the Irish Exchequer by £356,000 was discovered. The reduced surplus of £144,000 was regarded by **Mr. Gladstone** as ‘cutting it too fine,’ and the financial scheme was completely recast. Before explaining the third scheme it might be well to examine as before how the original scheme of 1893 would work out at the present time. This is shown in the following balance sheet.


#### Scheme B (Based On Bill Of 1893, as Introduced)





| Revenue | £ |
| --- | --- |
| 1. Excise (true revenue ex. licenses)  | 2,952,000 |
| 2. Local Taxes: (a) Stamps | 333,000 |
| 2. Local Taxes: (b) Death Duties | 914,000 |
| 2. Local Taxes: (c) Income Tax | 1,307,000 |
| 2. Local Taxes: (d) Excise licenses | 284,000 |
| 3. Postal Revenue | 1,155,000 |
| 4. Miscellaneous | 150,000 |
| *Sub-total* | 7,095,000 |
| Deficit | 2,535,000 |
| *Total* | 9,630,000 |









| Expenditure | £ |
| --- | --- |
| 1. Civil Government charges (ex. Constabulary and Lord Lieutenant's salary) | 6,952,000 |
| 2. Collection of Ireland Revenue, etc. | 298,000 |
| 3. Postal Services | 1,404,000 |
| 4. Contribution to Constabulary (two thirds of £1,464,500) | 976,000 |
| *Total* | 9,630,000 |






The narrow surplus of £144,000 has disappeared, and instead there is on present-day figures the substantial deficit of £2,535,000. Here again it may be observed that the Excise duties are fixed by the Imperial Parliament, and the Postal charges are presumably also invariable. The first Budget deficit would, as before, be not less than £3,000,000. The taxes within the absolute control of the Irish Parliament would have been producing a revenue of £2,838,000. It is within this range of taxation, or by the imposition of new direct taxes, that the Irish Chancellor of the Exchequer would have been compelled to raise an additional £3,000,000 in order to make the two sides of his account balance. Owing to the mistake already referred to, **Mr. Gladstone** prepared and presented a third scheme, whose principal features were as follows:



---

p.126


1. Ireland's contribution to Imperial expenditure to be one-third of the true revenue of taxes levied in Ireland.
2. Ireland to be credited with miscellaneous receipts and surplus (if any) arising from postal services.
3. Ireland to pay out of revenues credited to her, two thirds of the cost of the Constabulary, all Civil Government charges and any deficit on postal services.
4. The Customs and Inland Revenue duties and the rates for Postal charges to be fixed and collected by Imperial Parliament.
5. After six years (1) Irish contribution to Imperial Services to be revised; (2) the collection of Inland Revenue duties to be undertaken by Irish Government; (3) Irish legislation to impose the stamp duties, income tax, and excise licences. The financial clauses as thus remodelled and simplified were expected to produce a surplus of £512,000. The characteristic feature of this arrangement was the provision for handing over to the Imperial Exchequer one-third of the Irish true tax revenue as Ireland's payment on account of Imperial Services. How matters would stand if this arrangement were applied to the present financial situation in Ireland may be seen from
the following table.



#### Scheme C (Based On Bill Of 1893, As Amended)





| Revenue | £ |
| --- | --- |
| 1. Customs | 2,866,000 |
| 2. Excise (ex. license duties) | 2,952,000 |
| 3. Stamps | 333,000 |
| 4. Death duties | 914,000 |
| 5. Licence duties |  284,000 |
| 6. Income Tax | 1,307,000 |
| 7. Crown Lands, etc. | 25,000 |
| *Sub-total* | 8,681,000 |
| 8. Two thirds of £ 8,965,000 | 5,787,000 |
| 9. Miscellaneous Receipts | 115,000 |
| *Sub-total* | 5,902,000 |
| Deficit | 2,275,000 |
| Total | 8,177,000 |









| Expenditure | £ |
| --- | --- |
| 1. Civil Government Charges | 6,952,000 |
| 2. Constabulary (two thirds of £1,464,000) | 976,000 |
| 3. Estimated deficit on Postal Services | 249,000 |
| Total | 8,177,000 |








---

p.127


The main Irish objection to a scheme of this description is that, whatever tax be imposed, the amount taken from the Irish taxpayer would be 50 per *cent* greater than the amount going into the Irish Exchequer. It is easy to foresee that such an arrangement would have led to much friction and difficulty, and that it could not have lasted even the six years for which it was provisionally fixed. If applied to the present situation Ireland would have been contributing less than £3,000,000 for Imperial services, although a very moderate estimate of what her contribution should be would require her to pay at least £5,000,000. In spite of this modest payment, however, this scheme would have confronted the Irish Chancellor of the Exchequer with a deficit of more than £2,250,000 rising at once to £2,700,000 in consequence of the Insurance Act.


In reviewing the three financial schemes which have previously seen the light, the following facts stand out clearly:
1. Some contribution was expected from Ireland for Imperial services in each scheme.
2. The rates of customs, excise, and postage were in all cases to be controlled by the Imperial Parliament.
3. The customs were in every case to be collected by officers of the Imperial Exchequer.
4. In the two schemes of 1893 ‘true’ revenue and not ‘collected’ revenue was the basis of the financial arrangement.
5. Each of these schemes would involve the Irish Parliament from the outset in a huge deficit.



In view of these facts it is certain that any arrangement which pretended to give a Budget surplus to the Irish Parliament would involve, overtly or covertly, the payment of a large subsidy to Ireland out of the Imperial Exchequer. Such a contingency is not likely to make Home Rule more acceptable, or the path of any Bill, through Parliament more easy.




---

p.128


### Home Rule and the Colonial Analogy

### By **L. S. Amery, M.P.**


There is no argument in favour of Home Rule for Ireland which is more frequently used *today* than that which is based on the analogy of our Colonial experience. In the history of every one of our Colonies—so runs one variant of the argument—from **Lord Durham**'s report on Canada down to the grant of responsible government to the Transvaal, ‘Home Rule’ has turned disaffection into loyalty, and has inaugurated a career of prosperity. Why should we then hesitate to apply to Irish discontent the ‘freedom’ which has proved so sovereign a remedy elsewhere? Again, if our Dominions have been able to combine local Home Rule with national unity—so runs another variant—why should a policy which works successfully in Canada or Australia not work in the United Kingdom? Another suggestion freely thrown out is that Home Rule is only the beginning of a process of federalisation which is to bring us to the goal of Imperial Federation. In one form or another the Colonial Analogy occupies the foreground of almost every speech or article in favour of Irish Home Rule. The ablest, as well as the most courageous, piece of Home Rule advocacy which has so far appeared, **Mr. Erskine Childers**'s Framework of Home Rule, is based from first to last on this analogy and on little else.


That the argument is effective cannot be gainsaid. It is the argument which appeals most strongly to the great body of thoughtful Liberals who from every other point of view look upon the project with unconcealed misgiving. It is 



---

p.129



the argument which has appealed to public opinion in the Dominions, and has there secured public resolutions and private subscriptions for the Nationalist cause. In one of its forms it appealed to the imagination of an Imperialist like **Cecil Rhodes**. In another it has, undoubtedly, in recent years attracted not a few Unionists who have been prepared to approach with, at any rate, an open mind the consideration of a federal constitution for the United Kingdom. And, indeed, if the analogy really applied, it would be difficult to resist the conclusion. If Ireland has really been denied something which has proved the secret of Colonial loyalty and prosperity, what Englishman would be so short-sighted as to wish to deprive her of it for the mere sake of domination? If Home Rule were really a steppingstone towards Imperial Federation, how insincere our professions of ‘thinking Imperially,’ if we are not prepared to sacrifice a merely local sentiment of union for a great all-embracing ideal!


But, as a matter of fact, there is no such analogy bearing on the question which, here and now, is at issue. On the contrary the whole trend of Colonial experience confirms, in the most striking fashion, the essential soundness of the position which Unionists have maintained throughout, that the material, social and moral interests, alike of Ireland and of Great Britain, demand that they should remain members of one effective, undivided legislative and administrative organisation.


The whole argument, indeed, plausible as it is, is based on a series of confusions, due, in part, to deliberate obscuring of the issue, in part to the vagueness of the phrase ‘Home Rule,’ and to the general ignorance of the origin and real nature of the British Colonial system. There are, indeed, three main confusions of thought. There is, first of all, the confusion between ‘free’ or ‘self-governing’ institutions, as contrasted with unrepresentative or autocratic rule, and separate government, whether for all or for specified purposes, as contrasted with a common government. In the next place there is the confusion between the status of



---

p.130



a self-governing Dominion, in its relations to the Imperial Government, and the status of a Colonial state or provincial government towards the Dominion of which it forms a part. A truly inimitable instance of this confusion has been provided by **Mr. Redmond** in a declaration made on more than one occasion that all that Ireland asks for, is, ‘What has already been given to twenty-eight different portions of the Empire.’ [44](javascript:footNote('E900031/note044.html')) Considering that the ‘portions’ thus enumerated include practically sovereign nation states like Canada, provinces like those of the South African Union, with little more than county council powers, and stray survivals, like the Isle of Man, of an earlier system of government, based on the same principle of ascendancy and interference as the government of Ireland under Poynings's Act, it is difficult to know which to admire most, **Mr. Redmond**'s assurance, or his cynical appreciation of the ignorance or capacity for deliberate self-deception of those with whom he has to deal. The third confusion is that between Imperial functions and national or Dominion functions, due to the fact that the two are combined in the United Kingdom Parliament, which is also, under present conditions, the Imperial Parliament, and to the consequent habitual use of the word ‘Imperial’ in two quite different senses. It is this last confusion which makes such a declaration as **Mr. Asquith**'s about safeguarding ‘the indefeasible authority of the Imperial Parliament’ a mere equivocation, for it affords no indication as to whether the supremacy retained is the effective and direct control maintained by Canada over Ontario, or the much slighter and vaguer supremacy exercised by the United Kingdom over the Dominions, It is this same confusion, too, which is responsible for the notion that the problem of creating a true Imperial Parliament or Council by a federation of the Dominions would be assisted, either by creating an additional 



---

p.131



Dominion in the shape of Ireland, or by arranging the internal constitution of the United Kingdom, as one of the federating Dominions, on a federal rather than on a unitary basis.


The confusion of ideas between self-government and separate government pervades the whole argument that the granting of ‘Home Rule’ to Ireland would be analogous to the grant of responsible institutions to the Colonies. The essence of Home Rule is the creation of a separate government for Ireland. The essence of our Colonial policy has been the establishment of popular self-government in the Colonies. That this self-government has been effected through local parliaments and local executives, and not by representation in a common parliament, is a consequence of the immense distances and the profound differences in local conditions separating the Dominions from the Mother Country. It is an adaptation of the policy to peculiar conditions, and not an essential principle of the policy itself.


This is obvious from any consideration of the circumstances under which the policy of Colonial self-government originated. Under the old Colonial system which preceded it, the Governor not only controlled the executive government, whose members were simply his official subordinates, but also controlled legislation through a nominated Upper Chamber or Legislative Council. The object of this restrictive policy was not interference with local affairs, but the supposed necessity of safeguarding general Imperial interests. Local affairs were, in the main, left to the local government. But the peculiar constitution of that government rendered it almost inevitable that the practical control of those affairs should fall into the hands of a narrowly limited class, clustering round the Governor and his circle, and by its privileges and prejudices creating in those excluded from that class a spirit of opposition, which extended from its members to the whole Imperial system which they were supposed to personify. In each of the North American Colonies a small oligarchy, generally known as the ‘Family



---

p.132



Compact,’ was able to ‘monopolise the Executive Council, the Legislative Council, the Bench, the Bar, and all offices of profit.’ It was against this system, and not against the Imperial connection or even against undue interference from England, that the Canadian rebellion of 1837 was directed. In 1838 **Lord Durham** made his famous report in which he attributed the troubles to their true cause, the disregard of public opinion, and proposed that the Governor should in future govern, in local affairs, in accordance with the advice given by Colonial Ministers enjoying the confidence of the popular Assembly. A few years later his policy was put into execution by **Lord Elgin** in Canada, and rapidly extended to other Colonies. Five years ago the same system of government was applied to the Transvaal and to the Orange River Colony.[45](javascript:footNote('E900031/note045.html'))


From the foregoing brief summary, it is sufficiently clear that the really vital feature of the policy inaugurated by **Lord Durham** was the acceptance of responsible popular government in local affairs, and not the separation of Colonial government from Imperial control. The policy did not involve the setting up of new legislative machinery or a new definition of Imperial relations. For an existing system of separate government in local affairs, which created friction and discontent, it simply substituted a new system which has, in the main, worked smoothly up to the present. From the success of this policy, what possible direct inference can be drawn as to the effect of setting up in Ireland, not a similar system of government, for Ireland already enjoys political institutions as fully representative as those of any 



---

p.133



Colony, or of any other portion of the United Kingdom, but a separate centre of government?


At the same time the success of responsible government in the Colonies is, on closer examination, by no means without bearing on the problem of Ireland. That system of Colonial responsible government which seems to us so simple and obvious is, on the contrary, one of the most artificial systems the world has ever known, based as it is upon conditions which have never been present before in the world's history, and which are now rapidly disappearing, never, perhaps, to recur. That a popular assembly in complete control of the executive, should respect an unwritten convention limiting its powers and rights to purely local affairs, and submit to a purely external control of its wider interests and destinies, seemed to most of **Lord Durham**'s contemporaries almost unthinkable. Not only those who opposed the policy, but many of those who advocated it, were convinced that it would lead to complete separation. Nor were their fears or hopes by any means ill-grounded. That they were not justified by the event was due to an altogether exceptional combination of factors. The first of these was the overwhelming supremacy of the United Kingdom in commerce and naval power, and its practical monopoly of political influence in the outer world. Sheltered by an invincible navy, far removed from the sound of international conflict, the Colonies had no practical motive for concerning themselves with foreign affairs, or with any but purely local measures of defence. Even when, as in 1854, they were technically involved by the United Kingdom in war with a great Power, they were not so much as inconvenienced. The United Kingdom, on the other hand, incurred no serious expenditure for their defence beyond what was in any case required for the defence of its sea-borne commerce, nor was its foreign policy at any time seriously deflected by regard for Colonial considerations. Even when the Colonies encroached on the original limits set them, and began to establish protectionist tariffs against the Mother Country, British manufacturers could afford to disregard a handicap 



---

p.134



of which they were at first scarcely sensible, while British statesmen smiled condescendingly at the harmless aberrations of Colonial inexperience. Another factor was the very fact that it was colonies that the United Kingdom was dealing with, new countries where every other interest was secondary to that of opening up and developing the untamed wilderness, to creating the material framework which, in fulness of time, might support a complete national life. There was consequently little real interest in external policy in the Colonial assemblies, little leisure for criticism of the Imperial authorities, little desire to assert any particular point of view. Last, but not least, was the factor of distance, interposing a veil of obscurity between the different communities in the Empire; mitigating minor causes of friction, keeping Colonial politics free from being entangled in the British Party system.


The British system of Colonial self-government has so far proved workable because of the exceptional circumstances in which it originated. But its success cannot be regarded as wholly unqualified. The failure to provide any direct representation of Colonial interests and aspirations in the Imperial Parliament may not have mattered as far as foreign policy and defence were concerned. But it did affect the colonies most seriously from the economic point of view, for it precluded them from pressing with any effect for the development of inter-Imperial communications, or from resisting the abolition of the system of preferential trade which meant so much to their prosperity. Under the influence of a narrowly selfish and short-sighted policy, inspired by English manufacturing interests, Canada saw the stream of commerce and population pass by her shores on its way to the United States. The relative progress of the British Colonies and of the United States since the abolition of preference is some measure of the economic weakness of a political system which has no common trade policy. In any case the British Colonial system, as we have known it, is inevitably moving towards its crisis. The conditions under which it originated are fast disappearing. 



---

p.135



The commercial and political expansion of Europe, of America, of Asia, are bringing the Dominions more and more into the arena of international conflict. The growth of foreign navies is forcing them to realise the necessity of taking a larger part in their own defence. Their growing national self-consciousness demands not only that they should cease to be dependent on the Mother Country for their safety, but also that they should exercise control over the foreign policy of which defence is merely the instrument. There are only two possible solutions to the problem which is now developing: the one is complete separation, the other is partnership in an Imperial Union in which British subjects in the Dominions shall stand on exactly the same footing, and enjoy the same powers and privileges in Imperial affairs, as British subjects in the United Kingdom.


The conditions—geographical, economic, political— which, in the Colonies, made the grant of free institutions, unaccompanied by some form of political federation or union, even a temporary success, were, indeed, exceptional. None of them were present in the circumstances of Ireland before the Union. They are not present *today*. Geographically the United Kingdom is a single compact island group, of which Ireland is by no means the most outlying portion. No part of Ireland is *today*, or ever was, as inaccessible from the political centre of British power as the remoter parts of the Highlands, not to speak of the Shetlands or Hebrides. Racially, no less than physically, Ireland is an integral part of the United Kingdom, peopled as it is with the same mixture of racial elements as the main island of the group. The blend of Celt with Dane, with Normans and English of the Pale, with English citizens of the seaports and Cromwellian settlers, which constitutes Celtic Ireland, so-called, is less Celtic both in speech and in blood than either Wales or the Highlands. Religion alone has maintained a difference between a predominantly Celtic and a predominantly Teutonic Ireland which would otherwise have disappeared far more complete than the difference between Celtic and Teutonic Scotland. Economically,



---

p.136



the connection between Ireland and Great Britain, always close, has become such that *today* Ireland subsists almost wholly upon the English market. In these respects, at least, there is no resemblance between the conditions of Ireland and that of any of the Colonies.


On the other hand, politically, Ireland was for centuries treated as a colon— ‘the first and nearest of the Colonies,’ as **Mr. Childers** puts it. The difficulties and defects of early Colonial government were intensified by the great conflict of the Reformation, which made Ireland a centre of foreign intrigue, and by the long religious and constitutional struggle of the seventeenth century, which fell with terrible severity upon a population, which had throughout espoused the losing cause. **Cromwell**, realising that ‘if there is to be a prosperous, strong and United Kingdom there must be one Parliament and one Parliament only,’ freed Ireland from the Colonial status. Unfortunately, his policy was reversed in 1660, and for over a century Ireland endured the position of ‘least favoured Colony’—least favoured, partly because, with the possible exception of linen, all her industries were competitive with, and not complementary to English industries, and so were deliberately crushed in accordance with the common economic policy of the time, partly because the memories of past struggles kept England suspicious and jealous of Irish prosperity. Every evil under which the old colonial system laboured in Canada before the rebellion was intensified in Ireland by the religious and racial feud between the mass of the people and the ascendant caste. The same solvent of free government that **Durham** recommended was needed by Ireland. In view of the geographical and economic position of Ireland, and in the political circumstances of the time, it could only be applied through union with Great Britain. Union had been vainly prayed for by the Irish Parliament at the time of the Scottish Union. Most thoughtful students, not least among them **Adam Smith**,[46](javascript:footNote('E900031/note046.html')) had seen in it the only cure for the evils which afflicted the hapless island.




---

p.137


Meanwhile, in I782, the dominant caste utilised the Ulster volunteer movement to wrest from Great Britain, then in the last throes of the war against France, Spain, and America, the independence of the Irish Parliament. Theoretically co-equal with the British Parliament, **Grattan**'s Parliament was, in practice, kept by bribery in a position differing very little from that of Canada before the rebellion. Still the new system in Ireland might, under conditions resembling those of Canada in 1840, have gradually evolved into a workable scheme of self-government. But the conditions were too different. A temporary economic revival, indeed, followed the removal of the crippling restrictions upon Irish trade. But, politically, the new system began to break down almost from the start. Its entanglement in English party politics, which geography made inevitable, lead to deadlocks over trade and over the regency question, the latter practically involving the right to choose a separate sovereign. The same geographical conditions made it impossible for Ireland to escape the influence of the French Revolution. The factious spirit and the oppression of the ruling caste did the rest. There is no need to dwell here on the horrors of the rising of 1798, and of its repression, or on the political and financial chaos that marked the collapse of an ill-starred experiment. England, struggling for her existence, had had enough of French invasion, civil war, and general anarchy on her flank. The Irish Parliament died, as it had lived, by corruption, and **Castlereagh** and **Pitt** conferred upon Ireland the too long delayed boon of equal partnership in the United Kingdom.


The mistakes which, for a century, deprived the Union of much of its effect—the delay in granting Catholic emancipation, the folly of Free Trade, acquiesced in by Irish members, by which agrarian strife was intensified, and through which Ireland again lost the increase of population which she had gained in the first half century of Union—need not be discussed here. The fact remains that *today* Ireland is prosperous, and on the eve of far



---

p.138



greater prosperity under a sane system of national economic policy. What is more, Ireland is in the enjoyment of practically every liberty and every privilege that is enjoyed by any other part of the United Kingdom, of greater liberty and privilege than is enjoyed by Dominions which have no control of Imperial affairs. The principle which in the case of the Colonies was applied through separate governments has, in her case, been applied through Union. It could only have been applied through Union in 1800. It can only be applied through Union *today*. Railways and steamships have strengthened the geographical and economic reasons for union; train-ferries and aircraft will intensify them still further. Meanwhile the political and strategical conditions of these islands in the near future are far more likely to resemble those of the great Napoleonic struggle than those of the Colonial Empire in its halcyon period.


In one aspect, then, the Union was the only feasible way of carrying out the principle which underlay the successful establishment of Colonial self-government. In another aspect it was the last step of a natural and, indeed, inevitable process for which the history of the British Colonies since the grant of self-government has furnished analogies in abundance. It has furnished none for the reversal of that process. It is only necessary to consider the reasons which, in various degrees, influenced the several groups of independent Colonies in North America, Australia, and South Africa to unite under a single government, whether federal or unitary, thus wholly or partially surrendering the ‘Home Rule’ previously enjoyed by them, in order to see how close is the parallel. The weak and scattered North American Colonies were at a serious disadvantage in all political and commercial negotiations with their powerful neighbour, the United States, a fact very clearly emphasised by the termination of **Lord Elgin**'s reciprocity treaty in 1864. None of them was in a position to deal with the vast territories of the North-West, undeveloped by the Hudson's Bay Company,



---

p.139



and in imminent danger of American occupation. A common trade policy, a common railway policy, and a common banking system were essential to a rapid development of their great resources, and only a common government could provide them. In Australia the chief factor in bringing about federation was the weakness and want of influence of the separate Colonies in dealing with problems of defence and external policy, impressed upon them by German and French colonial expansion in the Pacific, and by the growth of Japan. In South Africa, on the other hand, the factors were mainly internal. The constant friction over railway and customs agreements, continually on the verge of breaking down, embittered the relations of the different Colonies and maintained an atmosphere of uncertainty discouraging to commercial enterprise. Four different governments dealt with a labour supply mainly required in one colony. Four agricultural departments dealt with locusts and cattle plagues, which knew no political boundaries, and which could only be stamped out by the most prompt and determined action. Four systems of law and four organisations for defence secured, as **Lord Selborne** pointed out in a striking Memorandum ( Blue Book Cd. 3564) a minimum of return for a maximum of expense. A native rising in Natal warned South Africans that the mistake of a single Colony might at any moment set the whole of South Africa ablaze with rebellion. In the absence of larger issues local politics in each Colony turned almost exclusively on the racial feud. A comprehensive union alone could bring commercial stability and progressive development, mitigate race hatred, and pave the way to a true South African nationality.


All the weakness in external relations, all the internal friction and impediment to progress, all the bitterness and pettiness of local politics, which marked the absence of union among neighbouring colonies, also characterised the relations of Great Britain and Ireland in the eighteenth century. But there was this difference: the immense disproportion in wealth and power, and the political control exercised by



---

p.140



the greater state, caused all the evils of disunion to concentrate with intensified force upon the smaller state. To undo the mischief of eighteenth century disunion required at least a generation. A series of political mistakes and mischances, and a disastrous economic policy, have left the healing task of union incomplete after a century. But renewed disunion *today* would only mean a renewal of old local feuds to the point of civil war, a renewal of old economic friction, in which most of the injury would be suffered by the weaker combatant, the indefinite postponing for Ireland of the prospect, now so hopeful, of national development and social amelioration, a weakening of the whole United Kingdom for diplomacy or for defence. It is a policy which no Dominion in the Empire would dream of adopting— a policy which every Dominion would most certainly resist by force, just as the United States resisted it when attempted, with more than a mere pretext of constitutional justification, by the Southern States.


Now for the ‘exception which proves the rule’: there is one Colonial analogy for what would be the position of Ireland under Home Rule, namely, the position of Newfoundland outside the confederation of the other North American Colonies.[47](javascript:footNote('E900031/note047.html')) The analogy is only partial, for this reason, that whereas Ireland is almost wholly dependent economically on Great Britain, Newfoundland has little direct trade with Canada, and moreover enjoys a virtual monopoly of one particular commodity, namely codfish, by which it manages to support its small population. Nevertheless, no one can doubt that with its favoured geographical position, and with its great natural resources, Newfoundland would have been developed in a very different fashion if for the last forty years it had been an integral part of the Dominion. Nor is the loss all on the side of Newfoundland, as the history of 



---

p.141



even the last few years has shown. In 1902, Newfoundland negotiated a commercial Convention with the United States which, in return for a free entry for Newfoundland fish into the United States, practically gave the Newfoundland market to American manufacturers, and explicitly forbade the granting of any trade preference to the United Kingdom or to Canada. When, fortunately, the American Senate rejected the Convention, Newfoundland embarked on a course of legislative reprisal against American fishing. But this involved the Imperial Government in a diplomatic conflict which, but for the excellent relations subsisting with the United States, might easily have led to a grave crisis. The inconveniences and dangers which Irish trade policy might lead to under Home Rule can easily be inferred from this single example, all the more if Irish policy should be influenced, as Newfoundland's policy certainly was not, by a bias of hostility to the Empire.


So much for the first confusion, that which would base the case for a *separate government* in Ireland on the success of *free institutions* in the Colonies, entirely ignoring the whole movement for union, which has made every geographical group of Colonies follow the example of the Mother Country. We must now deal with the second confusion, that which is based on a hazy notion that Home Rule is only a preliminary step to endowing the United Kingdom as a whole with a working federal constitution like that of Canada or Australia. Ireland, in fact, so runs the pleasing delusion, is to be set up as an experimental Quebec, and the other provinces will follow suit shortly. Not all Home Rulers, indeed, are obsessed by this confusion. **Mr. Childers**, for instance, makes short work of what he calls the ‘federal chimera,’ dismissing the idea as ‘wholly impracticable,’ and pointing out that Home Rule must be ‘not merely non-federal, but anti-federal.’ But the great majority of Liberals *today* are busy deluding themselves or each other, and the Nationalists are, naturally, not unwilling to help them. in that talk, with the idea of Home Rule for Ireland followed by ‘Home Rule all round.’




---

p.142


The new Home Rule Bill has not yet appeared, but certain main features of it can be taken for granted. It will be a Bill which, save possibly for a pious expression of hope in the preamble, will deal with Ireland only. It will set up in Ireland an Irish legislature and executive responsible for the ‘peace, order, and good government’ of Ireland, subject to certain restrictions and limitations. It will assign to Ireland the whole of the Irish revenues, though probably retaining the control of customs and excise, and in that case retaining some Irish representatives at Westminster. So far from fixing any contribution to Imperial expenditure from Ireland, it will, apparently, include the provision of an Imperial grant in aid towards Land Purchase and Old Age Pensions. Any such measure is wholly incompatible with even the loosest federal system. A federal scheme postulates the existence over the whole confederation of two concurrent systems of government, each exercising direct control over the citizens within its own sphere, each having its legislative and executive functions, and its sources of revenue, clearly defined. The Home Rule Bill will certainly not set up any such division of government and its functions in Great Britain. Nor will it, in reality, set up any such effective double system of government in Ireland. What it will set up will be a national or Dominion government in Ireland, separate and exclusive, but subject to certain restrictions and interferences which it will be the first business of the Irish representatives, in Dublin or Westminster, to get rid of. Long before Scotland or Wales, let alone England, get any consideration of their demand for Home Rule, if demand there be, the last traces of any quasi-federal element the Bill may contain will have been got rid of.


In a federation every citizen, in whatever state or province he resides, is as fully a citizen of the federation as every other citizen. He not only has the same federal vote, and pays the same federal taxes, but he has the same access to the federal courts, and the same right to the direct protection of the federal executive. In what sense are any 



---

p.143



of these conditions likely to be true of, let us say, an Irish landlord under this Home Rule Bill? Again, federalism implies that all the subordinate units are in an equal position relatively to the federal authority. Is this Bill likely to be so framed that its provisions can be adapted unchanged to Scotland, Wales, or England? And if they could, what sort of a residuum of a United Kingdom government would be left over? Take finance alone: if every unit under ‘Home Rule all round’ is to receive the whole product of its taxation, what becomes of the revenue on which the general government of the United Kingdom will have to subsist? The fact is that the creation of a federal state, whether by confederation or by devolution of powers, must be, in the main, a simultaneous act. Additional subordinate units may subsequently join the confederation under the conditions of the federal constitution. Backward areas which are unable to provide for an efficient provincial expenditure, over and above their contribution to federal expenditure, may be held back as territories directly controlled by the federal authorities till they are financially and in other respects ripe for the grant of provincial powers. If a federal scheme were really seriously contemplated by the present Government they would have to adopt one of two courses. They would either have to establish it simultaneously for the whole United Kingdom, and in that case limit the powers and functions of the provinces so narrowly as to make it possible for Ireland to raise its provincial revenue without undue difficulty, the rest of Ireland's needs being met by a substantial federal expenditure carried out by federal officials. Or else they might begin by the creation of a federal constitution with considerable provincial powers for England, Scotland, and Wales, keeping back Ireland as a federal territory till its economic and social conditions justified the establishment of provincial institutions. The converse policy of treating the case of Ireland as *prior in point of time and urgency,’’*

**Mr. Asquith** at St. Andrews, Dec. 7, 1910.

 of giving the poorest and most backward portion of the United Kingdom the whole of its 
 


---

p.144



revenue and a practically unfettered control of its territory, is, indeed, ‘not merely non-federal, but anti-federal.’
The truth is that the federal element in this Home Rule Bill, as in that of 1893, will be merely a pretence, designed to keep timid and hesitating Home Rulers in line—a tactical manoeuvre of much the same character as the talk about a reformed Second Chamber which preceded the Parliament Act, and found due burial in the preamble to that Act. In essence the Bill will set up Ireland as an entirely separate state subject to certain restrictions which the Government have no serious intention of enforcing, and the Irish every intention of disregarding, or abolishing as the outcome of further agitation. For this policy of pretence there is one admirable parallel in our Colonial history—the policy by which ‘Home Rule’ was ‘given’ to the Transvaal after Majuba. It was the same policy of avoiding expense and trouble, political or military—the policy, in fact, of ‘cutting the loss’—tricked out with the same humbug about ‘magnanimity’ and ‘conciliation,’ about trust in Boer (or Nationalist) moderation when in power, the same contemptuous passing over of the loyalists as persons of ‘too pronounced’ views, or as ‘interested contractors and stock-jobbers.’ [48](javascript:footNote('E900031/note048.html')) It was embodied in a Convention by which the ‘inhabitants of the Transvaal territory’ were ‘accorded complete self-government, subject to the suzerainty of Her Majesty’ under a series of limitations which, if enforced, would have implied a measure of British control in many respects greater than that exercised over a self-governing Colony, and with a number of guarantees to protect the loyalists. The Government was able to ‘save its face,’ while its hesitating followers were able to quiet their consciences, by the reassuring phrases of the Convention. The Boer Volksraad frankly declared itself still dissatisfied, but ratified the Convention, ‘maintaining all objections to the Convention   
[*...*]  
 and for the purpose of showing to everybody that the love of peace and unity 



---

p.145



inspires it, for the time being, and provisionally submitting the articles of the Convention to a practical test.’ If any Nationalist Convention in Dublin should accept the new Home Rule Bill, we can take it for granted that it will be in exactly the same spirit, and possibly in almost the same phraseology.[49](javascript:footNote('E900031/note049.html'))


From the first the limitations of the Convention were disregarded. Short of armed intervention there was no machinery for enforcing them, and the Boers knew perfectly well that there was no real desire on the part of an embarrassed Government to raise a hornet's nest by making the attempt. The British resident, with his nominally autocratic powers, was a mere impotent laughing stock. The ruined loyalists left the country, or remained to become the most embittered enemies of the British Government. In three years a new Convention was drafted—an even greater masterpiece of make-believe than the first—which could be expounded to Parliament as a mere modification of certain unworkable provisions, but which the Boers took as a definite surrender of all claims to suzerainty, and as a definite recognition of their position as an ‘independent sovereign state,’ bound temporarily by the provisions of a treaty, which could have no permanent force in ‘fixing the boundary to the march of a nation.’ So far from being reconciled they were only emboldened to embark on a policy of aggression, which in 1881 involved the British Government in military measures costing nearly as much as would have been required to suppress the whole rising in 1881. For the time being the stagnation and chronic bankruptcy which followed the removal of British rule and the exodus of the loyalists limited Transvaal ambitions. The gold discoveries both increased that ambition by furnishing it with revenue, and at the same time brought about a close 



---

p.146



economic intercourse with the neighbouring colonies which, under the political conditions of disunion, was bound to create friction. In the end the policy of make-believe and ‘cutting the loss’ had to be redeemed at the cost of 20,000 lives and of £200,000,000. Reconciliation, in large measure, has come since. But it has only come because British statesmen showed, firstly, in the war, their inflexible resolution to stamp out the policy of separation, and secondly, after the war, their devotion to the real welfare of South Africa in a policy of economic reconstruction, and in the establishment of those free and equal British institutions under which— by the final dying out of a spurious nationalism based on racial prejudice and garbled history— South Africa may become a real, living nation.


The reservations and guarantees which this Home Rule Bill may contain cannot possibly constitute the framework of a federal constitution. All they can guarantee is a period of friction and agitation which will continue till Ireland has secured a position of complete separation from the United Kingdom. At the best the Home Rule experiment would then reduce Ireland to the position of another Newfoundland; at the worst it might repeat all the most disastrous features of the history of ‘Home Rule’ in the Transvaal. At the same time it may be worth inquiring how far there would really be any valid Colonial analogy for the introduction of a federal system of ‘Home Rule all round’ if such a scheme had been honestly contemplated. The first thing to keep in mind is that the internal constitution of the Dominions presents a whole gradation of constitutional types. There is the loose federal system of Australia, in which the Commonwealth powers are strictly limited and defined, and all residuary powers left to the States. There is the close confederation of Canada in which all residuary powers are vested in the Dominion. There is the non-federal unitary government of South Africa with a system of provincial local governments with somewhat wide county council powers. There is, lastly, the purely unitary government of the two islands of New Zealand. Each of 



---

p.147




these types is the outcome of peculiar geographical, economic, and historical conditions. To understand the federal system of Australia it is essential to remember that till comparatively recent times Australia consisted, to all intents, of four or five seaport towns, each with its own tributary agricultural and mining area, strung out, at distances varying from 500 to 1300 miles, along the southern and eastern third of a coast line of nearly 9000 miles looped round an unexplored and reputedly uninhabitable interior. Each of these seaports traded directly with the United Kingdom and Europe in competition with the others. With economic motives for union practically non-existent, with external factors awakening a general apprehension rather than confronting Australia with any immediate danger, it was impossible to find the driving power to overcome local jealousies sufficiently to secure more than a minimum of union. The Commonwealth Constitution is a makeshift which, as the internal trade of Australia grows and as railway communications are developed, will inevitably be amended in the direction of increasing the power of the Commonwealth and diminishing that of the States. In Canada the economic link between Canada proper and the Maritime Provinces was, before Confederation, almost as weak as that of Australia. British Columbia, which it was hoped to include in the Confederation, was then separated by a journey of months from Eastern Canada, and was, indeed, much nearer to Australia or New Zealand. Quebec, with its racial and religious peculiarities, added another problem. That the Confederation was nevertheless such a close and strong one was due both to the menace of American power in the south, and to the terrible example of the weakness of the American constitution as made manifest by the Civil War. Yet even so, Sir John Macdonald, the father of Confederation, frankly declared the federal constitution a necessary evil: 

*As regards the comparative advantages of a Legislative and a Federal Union I have never hesitated to state my own opinions.   
[*...*]  



---

p.148



I have always contended that if we could agree to have one government and one Parliament   
[*...*]  
 it would be the best, the cheapest, the most vigorous, the strongest system of government we could adopt .’’*


This also was the view of the framers of the South African Union. The circumstances of South Africa enabled them to carry it into effect. For all its extent, South Africa is geographically a single, homogeneous country with no marked internal boundaries. It is peopled by two white races everywhere intermixed in varying proportions and nowhere separated into large compact blocks. The immense preponderance and central position of the Rand mining industry makes South Africa practically a single economic system. The very bitterness of the long political and racial struggle which had preceded intensified the argument for really effective union.


If we compare the conditions in the United Kingdom with those of the Dominions it is obvious at once that there is no possible analogy with the conditions of Canada or Australia, but a considerable analogy with South Africa and New Zealand. The British Isles are but little larger than the New Zealand group, and much more compact and homogeneous. Their close economic intercourse, the presence of two races with a history of strife behind them, but compelled by their inextricable geographical blending to confront the necessity of union, are reproduced in the conditions of South Africa. In so far then as the Colonial analogy bears upon the question at all, it cannot be said to be in favour of Federal Home Rule any more than of Separatist Home Rule. The most it can fairly be said to warrant is the establishment of provincial councils with powers akin to those of the South African Councils. For such councils, built up by the federation of adjoining counties and county boroughs, carrying out more effectively some of the existing powers of those bodies, and adding to them such other powers, legislative or administrative, as it may be convenient to bestow on them, a very strong case may be made on the grounds of the congestion of 



---

p.149



Parliamentary business. But that has nothing to do with Home Rule, either Separatist or Federal.


But if the congestion of Parliamentary business might be appreciably relieved by some such provincial bodies— larger ‘national’ bodies would only duplicate work, not relieve it—the true remedy for the confusion of principles and objectives which, rather than the mere waste of time, is the chief defect of our Parliamentary system, lies in a proper separation of the local affairs of the United Kingdom from the general work of the Empire, in other words, in some form of Imperial federation. What is needed is not the creation of separate parliaments *within* the United Kingdom, but the creation of a separate Parliament for the United Kingdom, a Parliament which should deal with the affairs of the United Kingdom considered as one of the Dominions, leaving the general problems of Imperial policy to a common Imperial Parliament or Council equally representative of the citizens of every Dominion. No form of Home Rule can in any sense advance that desirable solution of our Imperial problems. The creation of an additional Dominion in the shape of Ireland would merely add one to the number of units to be considered, and would be contrary to the spirit of the resolution passed at the 1897 Conference, that it was desirable ‘wherever and whenever practicable, to group together under a federal union those Colonies which are geographically united.’ The problem would be no more affected by the setting up of a federal constitution for the United Kingdom, than it would be if South Africa decided, after all, to give her provinces federal powers, or Australia carried unification by a referendum. The notion that the Dominions could simply come inside the United Kingdom federation, though it sometimes figures in Home Rule speeches, is merely a product of the third form of confusion of ideas previously referred to, and is a sheer absurdity. The terms and conditions of a United Kingdom federation would necessarily differ in almost every respect from those of an Imperial Federation, and a constitution framed for the one object would be unworkable



---

p.150



for the other. Nor would it ever be acceptable to the Dominions, which regard themselves as potentially, if not actually, the equals of the United Kingdom as a whole. From their point of view the United Kingdom might almost as well be asked to step inside the Australian Commonwealth on the footing of Tasmania, as that they should be asked to join in, in the capacity of an additional Ireland, Scotland, or Wales, under any scheme of ‘Home Rule all round.’


It should be sufficiently clear from the foregoing analysis that the vague and confused claim that the success of British colonial policy is an argument for the Home Rule Bill has no shadow of justification. It has been shown, first of all, that the factor of success in our Colonial policy was not the factor of separatism implied in Home Rule, but the factor of responsible government already secured for Ireland by the Union. It has been shown, secondly, that the experience of the Colonies since the establishment of responsible government has in every case forced union upon them, and union in the closest form which the facts of trade and geography permitted of. Colonial experience is thus no argument even for a federal scheme of ‘Home Rule all round,’ if such a scheme could possibly result from an Irish Home Rule Bill, which it cannot. The disadvantages and dangers of the contrary policy of disunion have been shown, in their least noxious form in the case of Newfoundland, which has simply remained outside the adjoining Dominion, and in their deadliest form in the case of the Transvaal, where ‘Home Rule’ was given in 1881, as it would be given to Ireland *today*, if the Government succeeded, not from conviction and wholeheartedly, but as a mean-spirited concession, made to save trouble, and under the most disingenuous and least workable provisions. Lastly, it has been made clear that Home Rule cannot possibly assist, but can only obscure and confuse, the movement for the establishment of a true Imperial Union. Unionists and Imperialists can choose no better ground for their resistance to Home Rule than the wide and varied field of Colonial experience.




---

p.151


But Colonial experience can give us more than that. It can provide us not only with an immense mass of arguments and instances against disruption, but with invaluable instances of what can be done to strengthen and build up the Union against all possible future danger of disruptive tendencies. The confederation of Canada was accomplished in the teeth of all the geographical and economic conditions of the time. Canadian statesmanship thereupon set itself to transform geography, and to divert the course of trade in order to make the Union a reality. The Intercolonial Railway, the Canadian Pacific, the Grand Trunk Pacific, the proposed Hudson Bay Railway, and the Georgian Bay Canal schemes, all these have been deliberate instruments of policy, aiming, first of all, at bridging the wilderness between practically isolated settlements scattered across a continent, and creating a continuous Canada, east and west; and, secondly, at giving that continuous strip depth as well as extension. Hand in hand with the policy of constructing the internal framework of transportation, which is the skeleton of the economic and social life of a nation, went the policy of maintaining a national tariff to clothe that skeleton with the flesh and blood of production and exchange, and, as far as possible, to clothe it evenly. Australia, too, is waking, though somewhat hesitatingly, to the need of transcontinental railways, for the protection of new industries and for the even development and filling up of all her territories. In South Africa the economic process preceded the political. It was the dread of the breakdown of a temporary customs union already in existence that precipitated the discussion of union. And it was the development of the Rand as the great internal market of South Africa, and the competitive construction of railway lines from the coast, that really decided the question of legislative union against federation. All three instances lead to the same conclusion that union to be really effective and stable needs three things: firstly, a developed system of internal communications reducing all natural barriers to



---

p.152



social, political, and commercial intercourse to the very minimum; secondly, a national tariff, protective or otherwise, sufficient at least to encourage the fullest flow of trade along those communications rather than outside of them; thirdly, a deliberate use of the tariff and of the national expenditure to secure, as far as possible, the even development of every portion of the national territory.


In the United Kingdom all these instruments for making the Union real are still unutilised. The system of laisser faire in the matter of internal communications has allowed St. George's Channel still to remain a real barrier. A dozen train-ferries, carrying not only the railway traffic between Great Britain and Ireland, but enabling the true west coast of the United Kingdom to be used for transatlantic traffic, would obliterate that strip of sea which a British minister recently urged as an insuperable objection to a democratic union.[50](javascript:footNote('E900031/note050.html')) To construct them would not be doing as much, relatively, as little Denmark has long since done, by the same means, to unite her sea-divided territory. The creation of a tariff which shall assist not only manufactures, but agriculture and rural industries, is another essential step. In view of Ireland's undeveloped industrial condition the giving of bounties to the establishment in Ireland of new industries, such as the silk industry, would be a thoroughly justifiable extension of the Unionist policy carried out through the Congested Districts Board and the Department of Agriculture. The diversion to Ireland of a larger part of the general national and Imperial expenditure, whether by the establishment of a naval base, or the giving out of battleship contracts, or even only of contracts for Army uniforms, would also be of appreciable assistance to Ireland and to the Union. Ireland suffers *today* economically and politically, from the legacy of political separation in the eighteenth century, and of economic disunion in the nineteenth. It is the business of Unionists not only to maintain the legal framework of the Union, but to give it a vitality and fullness of content which it has never possessed.




---

p.153


### The Control of Judiciary and Police

### By the Right Hon. **J. H. Campbell, K.C., M.P.**


The various forecasts, inspired and uninspired, of the new Home Rule Bill which have been given to us, have shed little light upon the future of the Irish Judiciary and Police. The two previous Bills contemplated the handing over of the control of the whole administration of justice in Ireland to the Irish Executive after an interval, in the first case of two years, and in the later Bill, of six years. We may assume that, whatever period of grace may be allowed to us under the coming measure, it will propose to vest this control in the Irish Government within six years. The interposition of any interval at all will probably be regarded by Ministers as a concession to Unionist fears and as one of the ‘safeguards’ in which the minority will be urged to place its trust. It must be realised at once that, so far from this interval making the transition from British justice to Irish intrigue easier and more safe, it may have precisely the contrary effect. Once the Irish police are convinced that they are about to be delivered into the hands of the secret organisations who have been the most successful and relentless enemies of public order in Ireland, a paralysis must fall upon the force. During the closing years of the transition, at all events, the Royal Irish Constabulary will be given nominal responsibility for the peace of the country without any opportunity effectually to preserve it. It would be fairer and better to cast upon puppet nominees of the **Ancient Order of Hibernians** and the **Irish Republican Brotherhood** the responsibility and odium of controlling the passions that they have helped to



---

p.154



raise. The present judges would of course continue to do their duty without fear or favour, but it is impossible that the sentence passed upon them and the system of law and government for which they stand could leave their authority unimpaired. We have recently seen in England how easy it may be to stir up popular clamour against judges who administer the law without regard to the prejudices of any political party. Directly the Irish Courts sought to translate the paper safeguards of the Home Rule Bill into practical effect, they would be faced by the violent hostility of an ignorant and excitable assembly stimulated by an irresponsible and inexperienced executive. The result would be recriminations and friction which must deplorably injure and lower the reputation and prestige of both the Executive and the Judiciary.


The first thing necessary for securing public and private liberty in a country like Ireland, where party feeling runs high and internal disputes have a bitterness from which more fortunate countries are free, is a strong independent and impartial administration of the law. This can only be secured by freeing the Courts from any kind of interference or control on the part of the Executive, and by ensuring that the whole armed forces of the Executive should be at the disposal of the Courts for executing and enforcing their decrees. Let us only assume a case to arise after the statutory period had elapsed, such as is now of frequent occurrence in the Irish Courts. The Land Judge, for instance, or the Judge of the Court of Bankruptcy, finds it necessary to order the arrest of the chairman and secretary of a local branch of the **United Irish League** for interfering by gross intimidation with a sale under the order of his Court. The case excites a good deal of local feeling and the arrests can only be effected by the employment of a large force of armed police. The question is raised on a motion for adjournment in the Irish House of Commons. The majority of the members owe their seats to the intervention of the **United Irish League**, many of them—perhaps most—have themselves been in similar conflicts with the 



---

p.155



Court. The result is that Ministers have to choose between a refusal of the police and expulsion from office. Once the Government could decide which decrees of the Judiciary it would enforce and which it would not, the technical immovability of the Judges would be irrelevant, since the real control of justice would be vested, not in the courts but in the executive Ministers in Dublin Castle. The very existence of the limitations and safeguards foreshadowed in the coming Home Rule Bill would naturally tempt the Irish Government to adopt a policy which would reduce to a minimum the effective power of these restraints upon the popular will. The most obvious way of attaining this result would be to keep the police, and with them the judicature, in a position of greater dependence upon the Executive than is consistent with the supremacy of law and the safety of private rights and individual freedom.


We must remember that the men who would have the control of the new Irish Government would be those who have spent the greater part of their lives in violent conflict with the attempts of the Irish Courts to secure respect for the elementary rights of property and of personal freedom in Ireland. Power which has been won by the open violation of every principle of English law, is not likely either to assert the authority it has lived by defying to maintaining the independence of the courts and institutions which have been its deadliest opponents. The corruption of judicial authority and prestige in Ireland will be accomplished by entrenching the Executive behind large and shadowy discretionary powers, and also by manipulating the personnel and jurisdiction of the judges and magistracy throughout the country. The most deplorable movement in modern Nationalism is the attempt to introduce into Irish politics the worst methods of American political corruption. There have recently sprung into prominence in Ireland two societies which are in some respects the most sinister, the most immoral, and the most destructive of those which have corrupted and infected public life in the country.



---

p.156



These two—the **Ancient Order of Hibernians** and the **Irish Republican Brotherhood**— have in common the secrecy of their operations and the destructiveness of their aims. Their influence is marked not only by despotic and tyrannical government, but, what may be even more mischievous from the point of view of the community, by the deliberate persecution and suppression of all independent thought. Those who have watched the proceedings of the Dublin Corporation have felt the increasing strength of an influence proceeding from Belfast—an influence which is threatening to control the whole course of Nationalist politics in Dublin and the south. The forces of influence, combination, and intimidation which forced the Budget on a reluctant Ireland and routed the Roman Catholic Hierarchy over the Insurance Bill will not be disbanded under Home Rule. On the contrary, they are now being exercised so as to enable the Board of Erin to absorb the older organisations and to place in the hands of its leaders —or rather in those of a single man—the nomination of most, if not all, the representatives of the Nationalist party in Ireland. **Mr. Joseph Devlin**, who seeks to build this vast power, is a politician of American ideals and sympathies, and under the guidance of his organisation politics in Ireland would be shaped after the model of Tammany Hall rather than that of St. Stephen's. The party which appoints the municipal officers of Dublin in secret caucus, meeting for reasons which are never avowed and after debates which are never published, is only waiting to extend its operations. Even now it is notorious that the magistrates' bench in Ireland is regularly and systematically ‘pecked’ whenever licensing or agrarian cases are under discussion. The scandalous inaction of the present Irish Executive in reference to cattle driving and other forms of organised intimidation, the failure to enforce the law and the absolute immunity which the present Chief Secretary has persistently allowed to Nationalist Members of Parliament and paid organisers in incitement to outrage and intimidation, have paralysed the administration of justice



---

p.157



and disheartened and disgusted the Judiciary, the Magistrates, and the Police. But under Home Rule the measure of protection which is still afforded by a strong and independent Bench would be removed. The Resident Magistrate would be as much under the heel of the caucus as the local justice; the Recorder's Bench and even the High Court would be constantly subjected to influences of a mischievous and incalculable kind. Whatever may be said against the present occupants of the Judicial Bench, their integrity and fairness have never been seriously questioned. Since the days when the Irish judges issued a writ of habeas corpus for the release of Wolfe Tone, while the Irish Rebellion was actually in progress, they have consistently held an even balance between the two parties. Their learning, their impartiality and their wit have rightly made Irish judges respected throughout the world. Their reputation and their services alike demand that they shall not be set aside wantonly or without consideration. But there is no doubt that Home Rule must mean the end of the Irish Bench as we have seen it in history. The men who have been proud to represent the British Crown would resent with indignation the idea that they should become the tools of the Hibernian caucus. They realise that the judges who oppose the lawless will of popular ministers will have to face obloquy and perhaps direct attack in the Irish Parliament. Even if the concurrence of both Houses in the Irish Parliament were made necessary for the removal of judges, it would not adequately safeguard their independence. The lower House would be composed of the men whom Nationalist constituencies already return to Parliament—excitable, fierce partisans, always ready to subordinate private convictions to the exigencies of party discipline. Nor would there be in Ireland under Home Rule any power or influence, either of property or station, sufficiently strong to furnish a constituency which would return a senate representing interests, opinions, or desires substantially distinct from those of the more powerful House elected upon the wider suffrage.




---

p.158


The situation has been strongly complicated by the promulgation of the Motu Proprio decree, and the refusal of the authorities of the Roman Catholic Church to say definitely whether it applies to Ireland or not. We may assume that, if Archbishop Walsh could have given a categorical denial to the statement that the decree must operate in Ireland under Home Rule, he would have done so. The decree Motu Proprio forbids any Roman Catholic to bring his priest or bishop into court under pain of excommunication. The Roman Catholic Church has made many similar efforts during history to oust the jurisdiction of the ordinary courts, and each attempt has had to be sharply and sternly resisted by the civil authorities of Roman Catholic countries. We need not discuss how much there may be said from a theological standpoint for the decree; we are only concerned to show that it raises pretensions which no State can possibly permit to be recognised. There have been too many attempts, successful and unsuccessful, to oust the jurisdiction of the King's Courts in Ireland, for this new attempt to be viewed with equanimity. The **United Irish League** has set up courts which try men for imaginary offences committed during the exercise of their ordinary civil rights, and pass illegal sentences and inflict illegal punishments. Under the reign of Liberal Governments the writ of these courts runs where the King's writ cannot run, and the law of the League has been allowed in great measure to supersede the law of the land. We have also an increasing force in Irish Nationalism which seeks to paralyse the government of Ireland by means of the general or sympathetic strike. This organisation seeks to establish courts in Ireland in opposition to the ordinary law courts, and to enforce their decrees by means of illegal intimidation and outrage. The people of Ireland have therefore been familiarised with the idea of courts competing in authority with those of the King's Government. Supposing under Home Rule the Judiciary proved less pliable than was expected or desired, the development of such competing authorities would be facilitated by a



---

p.159



complaisant Cabinet in Dublin. But of all attempts to override the authority of law this conspiracy to exempt ecclesiastical persons from its scope is the most insidious and dangerous. The existence of a class of men answerable for their actions, not to any domestic tribunal, but to a foreign ecclesiastical court, cannot now be tolerated by any self-respecting Government. Yet it is not easy to see how an Irish Cabinet could refuse to make, by executive if not by legislative action, what is now the law of the Church eventually the law of Ireland. Against this danger no safeguards can be devised. If the Administration refuses to put the law into effective operation against a certain class of offender or abuses the prerogative of mercy in his favour, there is no power in the constitution to coerce it. A few years ago we saw in Ireland the extraordinary spectacle of persons being prosecuted for cattle-driving and similar offences, while those who openly incited them to crime escaped with impunity. We saw judges from the Bench complaining in vain that the real offenders were not brought before them, and criticising openly the negligence and partiality of the Crown. If the Nationalists, whose influence then paralysed the aims of the Government, ever get supreme control of the Executive, we are certain to see these abuses revived on a still more shocking scale. The operation of the new decree places the Roman Catholic minister or law officer who is called upon to administer justice under the terms of his oath in a position of cruel embarrassment. As a law officer it might be his duty to order the prosecution of some clerical offender; as a Roman Catholic compliance with his duty to the State must entail the awful consequences of excommunication. It needs no elaboration to show that what may be a grave embarrassment under the rule of impartial British Ministers, must under a local Irish Government develop into a danger to the State. A case recently tried at the Waterford Assizes establishes a precedent which may prove most mischievous. Recent illustrations in Ireland of the working of the Temere decree have secured for it a sort of quasi-legality and provided a



---

p.160



great argument to those devout Churchmen who, under Home Rule, would naturally desire to carry the process a further step.


We have proceeded on the assumption that the Irish Parliament would—formally, at least—confine itself within the limits prescribed by the law of its creation. But it is necessary at least to contemplate the possibility that it would prove less complaisant. The safeguards and limitations inserted in any Act of the kind must of necessity be couched in general terms. The constitutional history of the United States and other countries is full of cases showing how difficult it is to define in practice where the border line between intra and ultra vires comes. It is the custom of all Governments, if there is any possible room for debate as to their competence to take any particular line of action, to give themselves the fullest benefit of the doubt, and the Irish Government is unlikely to prove any exception to the rule. When the Judicature and all the forces of Executive Government, except the direct command of troops, is in their hands, the laws passed by the Irish Parliament could be put in force in Ireland. The British Government could not intervene except by acts which would amount to open war between the two countries. We must remember that this enforcement of Irish laws by Irish police in spite of the decisions of a ‘foreign’ Government at Westminster is openly advocated and contemplated by the large and active section of the Nationalists who have adopted as their watchword the motto ‘Ourselves alone’ (Sinn Fein). Nothing could be more futile than the idea that the judgements of the Judicial Committee of the Privy Council would ever be accepted as final by the Nationalist majority, or that the royal assent could ever be withheld from an Act constitutionally passed by the Irish Legislature, without precipitating a crisis. The result of applying the veto of the House of Lords in England to the measures of Liberal Ministers was the agitation for removing the veto. The Nationalists took part in that agitation and have learned its lesson. Directly the British Government asserts its



---

p.161



technical right of veto, a similar agitation to get rid of all obnoxious restraints would arise in Ireland.


If anything could increase the danger of friction, it would be the scheme favoured by **Mr. Erskine Childers** and other Liberals of submitting constitutional questions to the decision of the British Privy Council reinforced by Irish judges. Either these judges would concur in verdicts given against the pretensions of the Irish Parliament or they would not. If they did concur, there would be a fierce outcry against the right of judges appointed under the Union Government to nullify Acts of the Irish Legislature. But if they did not concur, the patriotic indignation with which a decision over the heads of the Irish representatives would be received is easy to foresee. It would be a matter of the greatest difficulty to enforce any such decision when the Irish Government, supported by an agitation in the country, refused to be bound by it. The situation thus created has no parallel in the case of the colonies. In Canada or Australia, where the legislative power is divided between federal and provincial Parliaments, a decision that the one legislature is incompetent affirms the competence of the other. Both legislatures have on the spot proper means of enforcing, by judicial and executive authority, decisions which are within their powers. The case of Ireland is fundamentally different. There can be no half-way house between keeping Ireland a partner in all our legislative and judicial activities, or giving to her with a separate Executive uncontrolled and unchecked rights of internal sovereignty.




---

p.162


### The Ulster Question

### By the Marquis of Londonderry, K.G.


In the Home Rule controversy *today* Ulster occupies the place of public interest. **Lord Rosebery** upon one occasion committed himself to the opinion that, before Home Rule was conceded by the Imperial Parliament, England, as the predominant member of the partnership of the three kingdoms, would have to be convinced of its justice.[51](javascript:footNote('E900031/note051.html')) He did not foresee that the party of which he was then the leader would, under duress, abandon even the pretence of consulting the ‘predominant partner,’ much less be guided by its wishes. But it has come to pass: and Ulster alone remains the stumbling-block to the successful issue of the plot against the Constitution. By Ulster we do not mean, as **Mr. Sinclair** points out, the geographical area, but the district which historical events have made so different in every respect from the rest of Ireland. In the Act of Union I have a personal interest from family connection. I am convinced that **Lord Castlereagh** was absolutely right on both Imperial and Irish grounds. I feel that so far as Ireland is concerned the conditions and position of Ulster *today* afford ample confirmation: and of Ulster I may claim to have some knowledge. I represented County Down in the Imperial Parliament at Westminster before it was divided into constituencies, and in my later days I have maintained my close interest in Ulster. At the least, then, I may say that the temperament, the political and religious convictions, and the character of Ulster Unionists are not unknown to me.




---

p.163


I often read of ‘the Ulster bogey;’ and I believe **Mr. John Redmond** once devoted an article in a Sunday paper to elaborate statistical calculations from which he drew the deduction that there was no Ulster question. Other Home Rulers, by an expert use of figures, show that there is a Home Rule majority in Ulster itself. To those who know Ulster their efforts fail to carry the slightest conviction. Figures, however skilfully chosen, articles in the press, however cleverly written, cannot destroy the facts of Ulster Unionist opposition to Home Rule, the intensity and seriousness of which is, I believe, only now beginning to be appreciated by His Majesty's Ministers.


I hear of ‘Ulster bigots,’ ‘Ulster deadheads,’ and assertions made that the opposition only proceeds from a few aristocratic Tory landlords. Hard words do us no harm; but abusive epithets will not lessen Ulster opposition. Indeed the more we are reviled by our opponents, the more we believe they recognize the futility of persuading us to accept Home Rule.


We read of the intense anxiety of Irish Nationalists on English platforms lest even the suspicion of intolerance should cloud their administration and legislation under Home Rule, with interest but without respect. We do not believe in these sudden repentances, and we have heard these professions time and again when the exigencies of the moment demanded them.


The spirit of change has even affected the Government. At first Ulster was to be ignored; now it is to be conciliated. There is no safeguard that they will not insert in the Bill at our request. The First Lord of the Admiralty has a list already prepared; and they will welcome additions. **Mr. Redmond** accepts them all; and the fact that he does it readily raises our suspicions of their worth. Has not **Mr. John Dillon** said that artificial guarantees in an Act of Parliament were no real protection,[52](javascript:footNote('E900031/note052.html')) and for once it is possible to agree with him. Why should ‘bigots’ be conciliated; or ‘deadheads’ 



---

p.164



receive so much consideration? Why should the opposition of aristocratic Tory landlords be thought worthy of respect? Whenever have they been treated in this manner before by the Government in their schemes of legislation?


That our views receive so much attention is indeed the proof of the falsity of these hard names. Opposition to Home Rule in Ulster proceeds not from ‘bigots’ or ‘deadheads,’ not from ‘Tories,’ or ‘aristocrats,’ or ‘landlords’ exclusively. It is neither party question, nor class question. It has destroyed all differences between parties and classes. I doubt if there are any more democratic organizations than those of the Ulster Unionist Council, the Unionist Clubs, and the Orangemen. Nor are the religious bodies less popularly organized— the Church of Ireland, the Presbyterians, and other Protestant denominations have no class restrictions in their government. And as for party distinctions, those of us who took part in the old political contests before Home Rule became an urgent danger are now side by side in this greater fight for our very existence.


What stronger evidence that opposition to Home Rule in Ulster is no party question is to be found than in the disappearance of the Liberal Party. I can remember when it was powerful; but it has vanished before the threat of Home Rule. All attempts to resuscitate the corpse have failed, and a Liberal Party, independent of the Nationalists, representing Ulster constituencies in the House of Commons, in spite of repeated efforts, does not exist.


Let me impress upon the people of Great Britain that Ulster opposition to Home Rule is no party matter. It is an uprising of a people against tyranny and coercion; against condemnation to servitude; against deprivation of the right of citizens to an effective voice in the government of the country. **Mr. Birrell** said recently at Bristol that Ulster would be right to fight if it were oppressed in its religion or despoiled of its property. We welcome his conversion. When he pleads for Ulster to wait until it is plain that oppression has come, we recall to mind the phrase so often on Liberal lips,



---

p.165



‘Eternal vigilance is the price of liberty,’ and we say that we should be false to ourselves and to our trust if we were unprepared for what the future will bring under Home Rule.


For our opposition to Home Rule we are condemned by the Irish Nationalists as the enemies of our country. We believe ourselves to be its best friends. We believe Home Rule to be the greatest obstacle to Irish progress and prosperity. Irish Nationalists have made Home Rule their only idol and denounce every one who will not worship at its shrine. Every reform, unless they thought that it tended to advance Home Rule or magnify their powers, has received their hostility, sometimes open and avowed, at other times secret and working through devious ways.


No one who reads the history of Ulster can doubt that its inhabitants have not as much love of Ireland and as much wish to see her prosperous as the Nationalists, They indeed attribute all Irish shortcomings to the Union. Ulstermen, bearing in mind their own progress since the Union, not unnaturally decline to accept so absurd an argument. The Union has been no obstacle to their development: why should it have been the barrier to the rest of Ireland? Ulstermen believe that the Union with Great Britain has assisted the development of their commerce and industry. They are proud of the progress of Belfast and of her position in the industrial and shipping world. Without great natural advantages it has been built up by energy, application, clearheadedness and hard work. The opposition to Home Rule is the revolt of a business and industrial community against the domination of men who have shown no aptitude for either. The **United Irish League**, the official organization of the Home Rule Party, is, as a Treasurer once confessed, remarkably lacking in the support of business men, merchants, manufacturers, leaders of industry, bankers, and men who compose a successful and progressive community.[53](javascript:footNote('E900031/note053.html')) In the management of their party funds, their impending bankruptcy but 



---

p.166



a few years ago, the mad scheme of New Tipperary, and the fiasco of the Parnell Migration Company there is the same monotonous story of failure. Can surprise be felt that the Ulstermen refuse to place the control of national affairs in the hands of those who have shown little capacity in the direction of their own personal concerns. What responsible statesman would suggest that the city of London, Liverpool, Manchester, Sheffield, Newcastle, or any advancing industrial and commercial centre in Great Britain should be ruled and governed and taxed, without the hope of effective intervention, by a party led by **Mr. Keir Hardie** and **Mr. Lansbury**? Yet Home Rule means much like that for Ulstermen, and the impossibility of the scheme is emphasized in the example of Ireland by religious differences which have their roots in Irish history.


Ulster's opposition to Home Rule is no unreasoning hate. It proceeds not from the few; it is not the outcome of political prejudice; it is the hostility of a progressive and advancing people who have made their portion of the country prosperous and decline to hand it over to the control of representatives from the most backward and unprogressive counties.


They are actuated by love of their country. They yield to no one in their patriotism and their desire for Ireland's welfare. They have always given their support to movements which have had for their objects the improvement of Irish conditions and the increase of Irish well-being. Their sympathies are with Irish social reform—and the sympathies of many of them with social reform of an advanced character. Contrast their attitude with that of the **Irish Nationalist Party** in respect of reforms which have proceeded from the Imperial Parliament and movements within Ireland herself.


Take the Irish Land Act of 1903, accepted by both political parties in Great Britain as affording the real solution of the Irish agrarian problem. What has been the Irish Nationalist attitude? Praise for it on platforms in the United States when it was essential to reach the pockets 



---

p.167



of subscribers by recounting a record of results gained from the expenditure of American donations; but in Ireland itself opposition to its effective working. Read Nationalist speeches and there is always running through them the fear that the Act by solving the land question would remove the real motive power which made Home Rule a living issue. Hence the interference to prevent landlords and tenants coming to an agreement over sales without outside assistance. So *today* Irish Nationalists are still endeavouring too keep alive the old bad feeling between landlord and tenant which they so successfully created in the seventies and eighties. What better proof of this deliberate attempt to prevent the success of a great reform is to be found than the frank utterance of **Mr. John Dillon** at Swinford.[54](javascript:footNote('E900031/note054.html')) ‘It has been said,’ he declared, ‘that we have obstructed the smooth working of the Act. I wish to heaven we had the power to obstruct the smooth working of the Act more than we did. It has worked too smoothly—far too smoothly to my mind.   
[*...*]  
 Some men have complained with the past year that the Land Act was not working fast enough. For my part I look upon it as working a great deal too fast, and at a pace which has been ruinous to the people.’ What have the Ulster people done which can compare with this opposition to a measure that has admittedly effected a beneficial revolution in Irish agrarian life? Yet **Mr. Dillon** is acclaimed as a true Irish patriot and we are denounced as the enemies of our country!


What greater blow to the continuance of land purchase than the Birrell Act of 1909. Granted that some revision of the law was necessary in respect of finance; yet, the Act of 1909 went far beyond finance. Any one with a knowledge of land purchase law knows that the measure of 1909 contained innumerable provisions of a technical character calculated to make the free sale between landlord and tenant difficult, and in respect of a large portion of Ireland impossible. No wonder it was welcomed by the **Irish



---

p.168



Nationalist Party**, since it did so much to restore them to their self-elected position of counsellors and arbiters in the affairs of the tenants. And Ulster Unionists for declining to accede to this re-establishment of the old supremacy of the agitators are regarded as the opponents of liberty and freedom!


The same sad story of Nationalist opposition to Irish progress meets the student of the co-operative movement at every period of its existence. No one who knows **Sir Horace Plunkett** will believe for a moment that he was actuated by other than the sole desire to do something for Ireland's benefit. From the leaders of the Nationalist Party he has had no assistance, although they claim to be the only workers for Irish progress, and the co-operative, movement was intended to complete the agrarian revolution. In more recent times the hostility of the Nationalist leaders has become bolder as they found a ready instrument in **Mr. T. W. Russell** in his official capacity as Vice-President of the Department of Agriculture.


The co-operative movement is flourishing in spite of the opposition of the Nationalist leaders. From Ulster it has received considerable support for the reason that Ulstermen believed it to be for the benefit of Irish agriculture. Their support, unlike Nationalist hostility, has not arisen from political motives. They do not believe that **Sir Horace Plunkett** has given a moment's thought to politics in their relation to the co-operative movement, and they have appreciated his movement either as co-operators or as supporters and members of the Irish Agricultural Organization Society. Contrast the Ulster welcome with the Nationalist opposition, and ask why we should be denounced as bad Irishmen and the Nationalists receive praise as true lovers of Ireland.


The co-operative movement has brought into existence another movement which has for its object the prosperity of Irish industries. The Industrial Development movement which seeks to bring before the people of Ireland and the Irish public bodies the excellence of Irish manufactures



---

p.169



is as yet in its infancy. It has no political character, yet I should hesitate to say that official Irish Nationalism gives it hearty support. In Belfast, however, it has made great strides. It gains its support in Ulster not for any political reason, but simply and solely because the North of Ireland thinks that the industrial movement is to Ireland's advantage. Where in these instances is our ‘bigotry’ or our hostility to Irish progress? Does not the balance of credit when the comparison is made with the Nationalists come on the side of Ulster? The Nationalists show their unreasoning opposition by proclaiming that they would rather see Ireland in rags and poverty than abate their demand for Home Rule. Ulster Unionists desire to see Ireland prosperous and contented. For that reason they welcome all reforms and movements from whatever quarter which have this excellent end in view. They intend to offer the strongest and most unrelenting opposition to Home Rule not as political partisans for party gain, but as Irishmen determined to resist so reactionary a measure which they firmly believe will prove of the greatest evil to their unhappy country.




---

p.170


### The Position of Ulster

### By the Right Hon. **Thos. Sinclair**


By Ulster, I mean the six counties, Antrim, Down, Londonderry, Armagh, Tyrone, Fermanagh, with the important adjacent Unionist sections of Monaghan, Cavan, and Donegal, in all of which taken together the Unionist population is in an unmistakable majority, and in which the commercial and manufacturing prosperity of the province is maintained by Unionist energy, enterprise, and industry.


The relation of Ulster to a separate Irish Parliament with an Executive responsible to it, is a question which demands the most serious consideration on the part of English and Scotch electors. The Ulster Scot is not in Ireland *today* upon the conditions of an ordinary immigrant. His forefathers were ‘planted’ in Ulster in the troublous times of the seventeenth century. Although at the end of the reign of Queen Elizabeth peace had been secured all over Ireland, war was renewed in the Northern province early in the seventeenth century. The uprising was speedily crushed, and the lands of several of the rebellious nobles forfeited to the Crown. In order to prevent a repetition of lawlessness, the forfeited estates were entrusted to undertakers, on whom the obligation rested of peopling them with settlers from Great Britain. This scheme was devised in the hope that through the industry, character, and loyalty of the new population, the Northern province at all events should enjoy peace and prosperity, and become an attached portion of the King's dominions; and that eventually its influence would be usefully felt throughout the rest of Ireland. This policy was carried 



---

p.171



out under the rule of an English king, himself a Scot— James VI. of Scotland and I. of England. Large numbers of settlers were brought over to Ulster, many of them English, but the majority Scotch. We Ulster Unionists who inhabit the province *today*, or at least the greater number of us, are descendants of these settlers. The overwhelming majority are passionately loyal to the British Throne and to the maintenance of the integrity of the United Kingdom.


These things being so, it seems to Ulster Unionists that a grave responsibility rests on their English and Scottish fellow-citizens, with regard to our position, should any constitutional changes be imposed upon our country. We are in Ireland as their trustees, having had committed to us, through their and our forefathers, the development of the material resources of Ulster, the preservation of its loyalty, and the discharge of its share of Imperial obligations.


It cannot be denied, on an examination of the history of the last three centuries, and especially of that of the one hundred and ten years since the establishment of the Legislative Union, that, through good report and ill report, and allowing for all our shortcomings, we have not unsuccessfully fulfilled our trust. Our forefathers found a province, the least favoured by nature of the four of which Ireland consists, and it is *today* the stronghold of Irish industry and commerce. Its capital, Belfast, stands abreast of the leading manufacturing centres in Great Britain; it contains the foremost establishments in Europe, in respect of such undertakings as linen manufacturing, ship-building, rope-making, etc. It is the fourth port in the United Kingdom in respect of revenue from Customs, its contributions thereto being £2,207,000 in 1910, as compared with £1,065,000 from the rest of Ireland. Ulster's loyalty to the British King and Constitution is unsurpassed anywhere in His Majesty's dominions.


The North of Ireland has contributed to Imperial service some of its greatest ornaments. England owes to Ulster Governors-General like **Lord Dufferin** and **Lord Lawrence**;



---

p.172



soldiers like **John Nicholson** and **Sir George White**; administrators like **Sir Henry Lawrence** and **Sir Robert Montgomery**; great judges like **Lord Cairns** and **Lord Macnaghten**. At the recent Delhi Durbar the King decorated three Ulster men, one of them being **Sir John Jordan**, British Ambassador at **Pekin**. Ulster produced **Sir Robert Hart**, the incomparable Chinese administrator, who might also have been our Ambassador to China had he accepted the position.


The Ulster plantation is the only one which has fulfilled the purpose for which Irish plantations were made. The famous colonisation on both sides of the Shannon by **Cromwell** entirely failed of its design, the great proportion of its families having, through inter-marriage, become absorbed in the surrounding population.


Ulster Unionists, therefore, having conspicuously succeeded in maintaining the trust committed to their forefathers, and constituting as they do a community intensely loyal to the British connection, believe that they present a case for the unimpaired maintenance of that connection which is impregnable on the grounds of racial sentiment, inherent justice, social well-being, and the continued security of the United Kingdom and of the Empire. They cannot believe that their British fellow-citizens will, at this crisis, turn a deaf ear to this claim. Three or four decades after the Ulster plantation, when, in the midst of the horrors of 1641, the Scotch colony in Ulster was threatened with extermination, it appealed for help to its motherland. It did not appeal in vain. A collection for its benefit was made in the Scottish churches, supplies of food and several regiments of Scottish soldiers were sent to its aid, and its position was saved. We are confident that the descendants of these generous helpers will be no less true to their Ulster kith and kin *today*.


The history and present condition of Ulster throw an important light on what is currently described as the national demand of Ireland for Home Rule. There is no national Irish demand for Home Rule, because there never has been and there is no homogeneous Irish nation. On the contrary,



---

p.173



as **Mr. Chamberlain** long ago pointed out, Ireland *today* consists of two nations. These two nations are so utterly distinct in their racial characteristics, in their practical ideals, in their religious sanctions, and in their sense of civic and national responsibility that they cannot live harmoniously side by side unless under the even-handed control of a just central authority, in which at the same time they have full co-partnership. Ireland, accordingly, cannot make a claim for self-government on the ground that she is a political unit. She consists of two units, which owe their distinctive existence, not to geographical boundaries, but to inherent and ineradicable endowments of character and aims. If, then, it is claimed that the unit of Nationalist Ireland is to be entitled to choose its particular relation to the British Constitution, the same choice undoubtedly belongs to the Unionist unit.


But **Mr. Birrell**, for example, would tell us that the Nationalist unit in Ireland is three times as large as the Unionist unit, and that therefore the smaller entity should submit, because, as he has cynically observed, ‘minorities must suffer, for that is the badge of their tribe.’ But a minority in the United Kingdom is not to be measured by mere numbers; its place in the Constitution is to be estimated by its contribution to public well-being, by its relation to the industries and occupations of its members, by its association with the upbuilding of national character, by its fidelity to law and order, and by its sympathy with the world mission of the British Empire in the interests of civil and religious freedom. Tried by all these tests, Ulster is entitled to retain her full share in every privilege of the whole realm. Tried by the same tests the claim of 3,ooo,ooo Irish Nationalists to break up the constitution of the United Kingdom, of whose population they constitute perhaps one-fifteenth, is surely unthinkable.


Other writers in this volume have discussed Home Rule as it affects various vital interests in Ireland as a whole. It remains for me briefly to point out its special relation to the Northern province—




---

p.174


#### 1. Home Rule, in the judgement of Ulster, would degrade the status of Ulster citizenship by impairing its relationship to Imperial Parliament.


This would be effected both by lessening or extinguishing the representation of Ulster in that Parliament, and by removing the control of Ulster rights and liberties from Imperial Parliament and entrusting it to a hostile Parliament in Dublin. Ulstermen would thus stand on a dangerously lower plane of civil privilege than their fellow-citizens in Great Britain. To place them in this undeserved inferiority, they hold to be unjust and cruel.


####  2. Home Rule would gravely imperil our civil and religious liberties


Ireland is pre-eminently a clerically controlled country, the number of Roman Catholic priests being per head greater than that of any country in Europe. Her staff of members of religious orders, male and female, is also enormous, their numbers having increased during the last fifty years 150 per *cent*, while the population has decreased 30 per cent. It is undeniable, therefore, that in a Dublin Parliament, the overwhelming majority of whose members would be adherents of the Roman Catholic faith, the Roman ecclesiastical authority, which claims the right to decide as to what questions come within the region of faith and morals would be supreme. Great stress has lately been laid in Nationalist speeches from British platforms on the tolerant spirit towards Protestants which animates Irish Roman Catholics. We gladly acknowledge that in most parts of Ireland Protestants and Roman Catholics as regards the ordinary affairs of life, live side by side on friendly neighbourly terms. Indeed, that spirit, as a consequence of the growing prosperity of Ireland, had been steadily increasing, till the recent revival of the Home Rule proposal, with its attendant fears of hierarchical ascendancy as illustrated by the promulgation of the Ne Temere decree, suddenly interrupted it. But the fundamental fact of the case is, that in the last resort, it is not with their Roman Catholic neighbours, or even with their hierarchy, that Irish Protestants have to reckon; it is rather with the Vatican,



---

p.175



the inexorable power behind them all, whose decrees necessarily over-ride all the good-will which neighbourly feeling might inspire in the Roman Catholic mind. The Ne Temere decree affords a significant premonition of the spirit which would direct Home Rule legislation. It is noteworthy that no Nationalist member has protested against the cruelties of that decree as shown in the M'Cann case, and **Mr. Devlin, M.P.**, even defended what was done from his place in Parliament. This action is all the more significant in view of the fact that during the Committee stage of the 1893 Home Rule Bill **Mr. Gladstone**, **Mr. Redmond**, and his Irish Nationalist colleagues voted against, and defeated, an Ulster amendment which proposed to exempt marriage and other religious ceremonies from the legislative powers of the Dublin Parliament. It would be intolerable that such litigation as in the Hubert case at present in progress in Montreal, arising out of the Marriage Law of the Province of Quebec, should be made possible in Ireland. No paper safeguards in a Home Rule Bill could prevent it.


Again, a most serious peril has just been disclosed in the publication of the Motu Proprio Papal Decree, under which the bringing by a Roman Catholic layman of a clergyman of his Church into any civil or criminal procedure in a court of law, whether as defendant or witness, without the sanction previously obtained of his bishop, involves to that layman the extreme penalty of excommunication. The same penalty appears to be incurred ipso facto by any Roman Catholic Member of Parliament who takes part in passing, and by every executive officer of the Government who takes part in promulgating, a law or decree which is held to invade the liberty or rights of the Church of Rome. This is a matter of supreme importance in our civil life. It was one of the questions which, in Reformation times, led to the breach between Henry VIII. and the Pope. In a Dublin Parliament no power could resist the provisions of this decree from becoming law. As a matter of fact, the liberty of speech and voting attaching to every member of the Roman Catholic majority in a Dublin Parliament would be under



---

p.176



the absolute control of their hierarchy. Each Roman Catholic member would be bound to act under the dread of excommunication if he voted for or condoned any legislation contrary to the asserted rights of his Church, or which conflicted with its claims. Not only would the legislative independence of a Dublin Parliament be thus destroyed, but the administration of justice would be affected on every Bench in the country, from the Supreme Court of Appeal down to ordinary petty sessions. A grievous wrong would be inflicted on Roman Catholic judges and law officers, some of whom are unsurpassed for integrity and legal ability. It is contrary to every principle of justice to place these honourable men in a position in which they would have to choose between their oath to their king and their duty—arbitrarily imposed upon them—to their Church. Jurymen and witnesses would be equally brought under the sinister influences of the decree, and confidence in just administration of the law, which is at the root of civil well-being, would be fatally destroyed.


#### 3. Home Rule would involve the entire denominationalising, in the interests of the Roman Catholic Church, of Irish education in all its branches.


To secure this result has long been the great educational aim of the Irish hierarchy. How they have succeeded as regards higher education **Mr. Birrell**'s Irish Universities Act (1908) gives abundant evidence. The National University of Ireland, created by that Act, which on paper was represented to Nonconformists in England as having a constitution free from religious tests, is now, according to the recent boast of Cardinal Logue, thoroughly Roman Catholic, in spite of all paper safeguards to the contrary. Persistent attempts have been made to sectarianise the Irish primary National School system, founded seventy years ago, and which now receives an annual State endowment of £1,621,921, with the object of safeguarding the faith of the children of minorities, on the principle of united secular and separate religious instruction. That system worked so satisfactorily through many decades that **Lord O'Hagan**, the eminent first Roman Catholic Lord Chancellor of Ireland, declared that under it, up till his



---

p.177



time, no case whatever of proselytism to any Church had occurred. But gradually a sectarian system of education under the Roman Catholic Church was developed through the teaching order of Christian Brothers, whose schools are now to be found all over Ireland, and which in many places now supplant the non-sectarian schools of the National Board. The strongest efforts were made to bring these sectarian schools into the system of the National Board, and thus entitle them to a share of the State annual endowment. There is no greater peril to the religious faith of Protestant minorities in the border counties of Ulster and elsewhere in Ireland than the sectarianising of primary schools by Roman Catholics. A few years ago a Protestant member of a public service was transferred upon promotion from Belfast to a Roman Catholic district, in which his boys had no available school but that of the Christian Brothers, and his girls none but that of the local convent. I shall never forget the expression of that man's face or the pathos in his voice while he pressed me to help him to obtain a transfer to a Protestant district, as otherwise he feared his children would be lost to the faith of their fathers. Given a Parliament in Dublin, the management of education would be so conducted as gradually to extinguish Protestant minorities in the border counties of Ulster and in the other provinces of Ireland. It is here that a chief danger to Protestantism lies.


#### 4. Home Rule will seriously injure Ulster's material prosperity—industrial, commercial, agricultural


The root of the evil will lie in the want of credit of an Irish Exchequer in the money markets of the world. The best financial authorities agree that if Ireland should be left to her own resources, there would be, on the present basis of taxation, and after providing for a fair Irish contribution towards Imperial defence, an annual deficit in the Irish Exchequer of £3,000,000 to£4,000, 000. An Irish Government in such circumstances—consols themselves being now some £23 under par—could not borrow money at any reasonable rate of interest. Even if the British taxpayer


---

p.178



were compelled to provide for the deficiency, either by an annual grant or by payment of a divorce penalty of £15,000,000 to £20,000,000, or by both, a prudent investor would fear that the annual dole might at any moment be withdrawn should, for instance, John Bull become irritated by the action of a Dublin Parliament, say, in declaring enlisting in His Majesty's forces a criminal act; or that the capital gift would soon be frittered away in the interests of agitators and their friends. He would simply refuse to invest in Irish stock.


Now, a fundamental condition of commercial and industrial well-being is financial confidence. If the Public Exchequer of a country lacks confidence, it is a truism to say that consequently commercial confidence must be gravely impaired. The magnates of Lombard Street and Wall Street would view their Irish clients with unpleasant reserve. Irish bankers would in turn restrict advances to their customers, and these again would limit the credit of those with whom they transacted business. Curtailment of industrial enterprise, the shutting down of many manufacturing concerns, with consequent depreciation of buildings and plant, as well as increase of unemployment, would follow. Already, since the present Home Rule crisis has become acute, the handwriting on the wall has been made evident in the depreciation of leading Irish stocks to the extent of 15 to 20 per cent. Every one in trade would suffer from the diminution of purchasing power, capital would shrink, income and wages decrease, and the incentives to emigration, which is already depriving our population of some of its most hopeful elements, would be dangerously increased.


All these tendencies would be stimulated by the social disorganisation which would certainly follow Home Rule. Unionist Ulster, from the Ulster Convention of 1892, to the Craigavon demonstration of 1911, has been consistent in her loyal determination that no Parliament but the Imperial Parliament shall control her destinies. It is an ignorant mistake to say that she is weakening in this



---

p.179



resolve. The steadily increasing Unionist majorities in contested Ulster seats at both elections in 1910 conclusively prove that she is more staunch than ever in her Unionist faith. She would certainly resist the decrees of a Dublin Parliament and refuse to pay its taxes. The result of its passive resistance would be civil disorder, which would certainly gravely injure her industrial welfare, especially that of her artisan hard working population. But Ulstermen ask, What is industrial prosperity without freedom? And if, in defence of freedom, they should suffer disaster, the responsibility would lie with their fellow-citizens in Great Britain who would impose a hostile yoke upon them.


Under Home Rule, agricultural Ulster would also suffer. Very many Ulster farmers are now occupying owners. But a large number have not yet succeeded in purchasing, and these eagerly desire the privilege of doing so. **Mr. Birrell**'s 1909 Act has already practically strangled further land purchase in Ireland, and if he intends that its completion should be the work of a Home Rule Parliament, the Ulster tenants ask where would the £75,000,000 to £100,000,000 necessary to accomplish the process, come from? [55](javascript:footNote('E900031/note055.html')) They know that the procuring of such a sum from an Irish Government would be hopeless, for they are aware that Englishmen have better judgment than to allow their Parliament to lend further money to a country over which they had relinquished direct Parliamentary authority, and whose Exchequer would be bankrupt. Home Rule would thus permanently relegate the agricultural population, not only of Ulster, but of Ireland generally, into two classes living side by side with each other—one consisting of occupying owners, the other of rent-payers without hope of ownership. The evil results in discontent, friction, deterioration of agricultural methods and lessened production would inflict serious injury on Ulster prosperity.


Again, Home Rule would involve Ulster industry and commerce in excessive taxation. No one who is aware of the passionate desire amongst Irish agitators and their 



---

p.180



friends for lucrative jobs, of the efforts that would be made to subsidise industries with Government funds, of the determination of the clergy to have their monastic, Christian Brothers', monastic and convent schools largely supported by the State, and of the impossibility, in view of the social disorder all over Ireland that would follow Home Rule, of reducing further the police force or the Judiciary, entertains any doubt that retrenchment in Irish expenditure would be impossible. On the contrary, Irish taxation would increase, and as recent legislation has placed upon Irish farmers imposts greater than they think they can bear, the additional revenue would be sought for mainly from the industrial North. But with business disorganised, incomes decreased and unemployment increased, the yield of taxation would be much reduced, and the rate must therefore be made higher. All this would fortify Ulster in her determined refusal to pay Home Rule taxation, and the bankruptcy of the Dublin Exchequer would be complete.


It is from having regard to considerations such as I have outlined, and of the validity of which she is profoundly convinced, that Ulster has registered the historic Convention declaration, ‘We will not have Home Rule.’ Her position is plain and intelligible. She demands no separation from her Nationalist countrymen. On the contrary, she wishes, under the protection of the Legislative Union, to live side by side with them in peaceful industry and neighbourly fellowship, with the desire that they and we may in common partake of the benefits conferred on Ireland by generous Imperial legislation and repay it by sympathetic and energetic contribution to the service of the Empire.


But if Home Rule legislation should be passed contrary to Ulster's earnest and patriotic pleading, then she claims— not a separate Parliament for herself, but that she may remain as she is in the unimpaired enjoyment of her position as an integral portion of the United Kingdom and with unaltered representation in Imperial Parliament. She wishes to continue as an Irish Lancashire, or an Irish Lanarkshire. In this relationship to Great Britain she is



---

p.181



confident she will best preserve, not only her own interests, but also those of her fellow loyalists, Roman Catholic as well as Protestants, whose lot is cast in the other provinces and whose welfare will always be her responsible and earnest concern.


But if this demand—based on loyalty to the King and Constitution, and founded on the elementary right of British citizens to the unimpaired protection of Imperial Parliament—be refused, then the only alternative is the Ulster Provincial Government, which will be organised to come into operation on the day that a Home Rule Bill should receive the Royal Assent; and under that Provisional Government we shall continue to support our king, and to render the same services to the United kingdom and to the Empire as have characterised the history of Ulster during the past three hundred years.




---

p.182


### The Southern Minorities

### By **Richard Bagwell, M.A.**


At the present moment no county or borough in the three southern provinces of Ireland returns a Unionist member. There are substantial minorities in many places, but very few in which there would be any chance of a successful contest. The University of Dublin sends two conspicuous Unionists to Parliament, who represent not only a constituency of graduates, but the vast majority of educated and thinking people. The bearing of the question on religious interests will be dealt with by others, but it may be said here that the Protestant community is Unionist. The exceptions are few, and are much more than counterbalanced by the Roman Catholic opponents of Home Rule, who for obvious reasons are less outspoken, but are quite as anxious to avert the threatened revolution.


The great bone of contention has always been the land, the cause of various wars and of ceaseless civil disputes. **Parnell** saw and said that purely political Nationalism was weak by itself, and he took up the land question to get leverage. For many years it has been evident that the only feasible solution was to convert occupiers into owners, and a very long step was made by the Purchase Act of 1903. Progress has now been arrested, for the Act of 1909 does not work. The vendors or expropriated owners, whichever is the more correct term, are expected to take a lower price and to be paid in depreciated paper. The minorities to be most immediately affected by legislation consist of landlords who are unable, though willing, to sell, and of tenants who are unable but very anxious to buy. The present



---

p.183



deadlock is disastrous, for many tenants think they ought not to pay more than their neighbours, and demand reductions of rent without considering that the owner has received no part of his capital and dares not destroy the basis on which he hopes to be ultimately paid. It has been an essential part of the purchase policy that the instalment due by the occupier to recoup the State advance should be less than the rent. This has been made possible by the magic of British credit, and if that is withheld the confusion in Ireland will be worse than ever. The Exchequer has lost little or nothing, and even at much greater cost it would be the cheapest money that England ever spent. More than half the tenanted land has now passed to the occupiers, and it would be the most cruel injustice to leave the remaining landlords without power either to sell their property or to collect rents judicially fixed and refixed. They would fare badly with an Irish legislature and an Irish executive. They are, for the most part, poor but loyal men, and have exercised a great civilising influence. Are they to be deserted and ruined to keep an English party in place by the votes of men who have never pretended to be anything but England's enemies?


Irish Unionists laugh at the idea of a local Parliament being kept subordinate. It will have the power of making laws for everything Irish, that is, for everything that immediately concerns those that live in Ireland. There will be ceaseless efforts to enlarge its sphere of action, and if Irish members continue to sit at Westminster they will be as troublesome as ever there. If there are to be no Irish members Ireland will be a separate nation. Even candid Home Rulers confess that statutory safeguards would be of none effect. Hedged in by British bayonets the Lord Lieutenant may exercise his veto, built upon whose advice will he do it? If on that of an Irish Ministry the minority will have no protection at all, and does any one suppose it possible to go back to the practice of the seventeenth century, when all Irish Bills were settled in the English Privy Council, and could not be altered in a Dublin



---

p.184



Parliament? Orators declaim about our lost legislature, but they take good care not to say what it was. In the penultimate decade of the eighteenth century the trammels were taken off, and a Union was soon found necessary. During the short interval of Independence there were two French invasions and a bloody rebellion. Protestant ascendancy, though used as a catchword, is a thing long past. Roman Catholic ascendancy would be a very real thing under Home Rule. The supremacy of the Imperial Parliament alone makes both the one and the other impossible.


If a legislature is established it must be given the means of enforcing its laws. We do not know what the present Government propose to do with the Irish police, but whatever the law says in practice, they will be under the local executive. Unpopular people will not be protected, and many of them will be driven out of the country. Parliamentary Home Rulers draw rosy pictures of the future Arcadia; but they will not be able to fulfil their own prophecies. Apart from the agrarian question, there is the party of revolutionists in Ireland whose headquarters are in America. They have furnished the means for agitation, and will look for their reward. The Fenian party has less power in the United States than it used to have, but there will be congenial work to do in Ireland. A violent faction can be kept in order where there is a strong government, but in a Home Rule Ireland it would not be strong for any such purpose. Appeals to cupidity and envy would find hearers, and there could be no effective resistance. The French Jacobins were a minority but they swept all before them. In the end better counsels might prevail but the mischief done would be great, and much of it irreparable.


The justice dealt out by the superior courts in Ireland is as good as it is anywhere. A judge in the last resort has the whole force of the State behind him, and no one dreams of resistance. With an Irish Parliament and an Irish Executive this would hardly be the case. The judges would 



---

p.185



still be lawyers, but their power would be greatly impaired. In Ireland popular feeling is always against creditors, and it would be very hard indeed either to execute a writ of ejectment or a seizure of goods. If the sanction of the law is weakened, public respect for it is lessened, and the result will be a general relaxation of the bonds which draw society together. There is nothing in the antecedents of the Home Rule Party to make one suppose that it contains the materials of a good and impartial government.


Home Rule politicians are talkative and pertinacious. As members of Parliament they are of course listened to, while Unionists outside Ulster make little noise; it is, therefore, constantly said that they acquiesce in the inevitable change. Unrepresented men cannot easily make themselves heard, but they have done what they could. An enormous meeting has been held in Dublin, and the building, which contains some 7000, was filled in a quarter of an hour. There has since been a large gathering of young men who wish to remain full citizens of the Empire in which they were born, and others are to follow. In rural districts it is almost impossible to collect people in winter. Days are short and distances are long. Unionist farmers cannot forget the outrages that prevailed some years ago, and are not yet unknown. In the native land of boycotting and cattle-driving it is not surprising that they do not wish to be conspicuous. The difficulty extends to the towns, in many of which it would be almost impossible to hire a room for Unionist purposes. Hotel keepers object to risking their business and their windows, for a mob is easily excited to riot on patriotic grounds. Shopkeepers also have to be cautious in a country which has been wittily described as a land of liberty where no one can do as he likes, but where every one must do exactly what everybody else likes. In the summer people can meet in the open air, and there will, no doubt, be abundant protests from Southern Unionists. There will then be something definite to talk about.




---

p.186


It is often said that the County Councils have done well, and that therefore there is no danger in an Irish Parliament, but the two things are different in kind. County or District Councils, or Boards of Guardians, are constituted by Acts of the Imperial Parliament to administer Acts of the same, and are subject to constant supervision by the Local Government Board, and to the peremptory action of the King's Bench. A Parliament is by nature supreme within its sphere of action, and its constant effort would be to enlarge that field. The men who aim at independence would have the easy part to play, for no one in or out of Ulster, former Unionist or confirmed Nationalist, would have any interest in opposing them. In the meantime local councils have taught us what is likely to happen. Minorities are virtually excluded from them and from paid places in their gift. Of Protestants holding local office the great majority are survivals from the old Grand Jury system. Political discussions are frequent, but they are all among Nationalists. Intolerance of independent opinion and impatience of criticism are everywhere noticeable, and the Corporation of Dublin does not show a good example. It is intolerance of this kind rather than any approach to religious persecution that Protestants suffer from in the present and fear for the future.


Men who have something to lose dread the idea of Home Rule, including farmers who have bought their holdings, but as yet this has not been allowed time to work. There is a long way between not caring to support a Nationalist and voting for a Unionist. The chief employers of labour are mostly for the Union, but few are in a position to help the Unionist cause effectively, for they have to deal with strike makers and possible boycotters. When Labour troubles come, Nationalist politicians try to make out that they are caused by English agitators, and that there would be none under Home Rule. The probability is all the other way. There could be nothing in the existence of an Irish Parliament to prevent English Socialists from crossing the Channel, and some Labour leaders in England are Irish.



---

p.187



We have heard a great deal lately about the union of the two democracies, and that is the point where they would unite. Passing from labour to land, which is after all the great interest of Southern and Western Ireland, the danger is even greater. With the loss of British credit it would be almost impossible to carry out the plan of occupying ownership without the grossest injustice, and the mischief would not stop there. An Irish Government would be poor, but would be expected to do all and more than all that the united government has done. At first the gap might be stopped by extravagant super-income tax, by half-compensated seizures of demesne land, and by penalising the owners of ground rents and town property. Confiscation is not a permanent source of wealth, for it soon kills the goose that laid the golden egg. Then the turn of the large farmer would come.


Most Unionists, and many who call themselves Home Rulers, are satisfied with the form of government they now have. The country has prospered wonderfully, and it will continue to prosper if the land purchase system is carried out to the end in a liberal spirit. The worst danger comes from the check given to the process by the present Ministry. But the national feelings of Ireland must not be ignored. Her far-back history, bad in itself, but represented worse by unscrupulous writers, makes it necessary to maintain an impartial power above the warring elements. In a pastoral country people have much time on their hands, and are apt to spend it in brooding over bygone wrongs. But over the past not Jove himself hath power, and it is for the future that we are responsible. From Wellington onwards Ireland has given many great soldiers to the British Army, and it is the classes from which they spring that it is now proposed to abandon. Under Home Rule the flag would be a foreign emblem, useless to protect the weak in Ireland, and perhaps available to oppress them. England would have cast off her friends and gained none in exchange. Nothing will conciliate the revolutionary faction in Ireland, and there is every reason to think that it would become the strongest. 



---

p.188



Modern Ireland is the creation of English policy, and many wrong things were formerly done, but for a long time amends have been making. If England, from weariness or for the sake of Party advantage, abandons her supporters, they will have no successors. Ireland will be more troublesome than ever, and the crime will receive its fitting punishment.




---

p.189


### Home Rule and Naval Defence

### By **Admiral Lord Charles Beresford, M.P.**


Ireland under Home Rule must, in the event of war, be regarded as a potentially hostile country.


In this statement resides the dominant factor of the situation viewed from the naval and military point of view. It is not asserted that the government of Ireland would be disloyal; but it is asserted that the authorities charged with the defence of his Majesty's dominions cannot afford to take risks when the safety of the country is at stake. That such risks must exist under the circumstances indicated, is obvious to all those who have studied the speeches of the leaders of the **Irish Nationalist party**, in which they have unequivocally declared their intention to rid Ireland of English rule, and in which they extol as heroes such men as **Theobald Wolfe Tone**, who intrigued with France against England in order to achieve Irish independence, and who took his own life rather than receive the just reward of his deeds. That some among the Irish Nationalist leaders have recently professed their devotion to the British Empire cannot be regarded by serious persons as a relevant consideration. The demand for Home Rule is in fact a demand for separation from the United Kingdom or it is nothing. Naval officers are accustomed to deal with facts rather than with words.


In the great sea-wars of the past, Ireland has always been regarded by the enemy as providing the base for a flank attack upon England. Had **King Louis XIV.** rightly used his opportunities, the army of **King William** would have been cut off from its base in England, and would have been destroyed by reinforcements arriving from France to



---

p.190



assist **King James II.** There is no more concise presentment of the case than the account of it given by **Admiral Mahan** in The Influence of Sea Power upon History, 1660-1783[56](javascript:footNote('E900031/note056.html')).
*The Irish Sea, separating the British Islands, rather resembles an estuary than an actual division; but history has shown the danger from it to the United Kingdom. In the days of Louis XIV., when the French navy nearly equalled the combined English and Dutch, the gravest complications existed in Ireland, which passed almost wholly under the control of the natives and the French. Nevertheless, the Irish Sea was rather a danger to the English—a weak point in their communications—than an advantage to the French. The latter did not venture their ships-of-the-line in its narrow waters, and expeditions intending to land were directed upon the ocean ports in the south and west. At the supreme moment the great French fleet was sent upon the south coast of England, where it decisively defeated the allies, and at the same time twenty-five frigates were sent to St. George's Channel, against the English communications. In the midst of a hostile people the English army in Ireland was seriously imperilled, but was saved by the battle of the Boyne and the flight of **James II.** This movement against the enemy's communirations was strictly strategic, and would be just as dangerous to England now, as in 1690.’’*


*There can be little doubt that an effective co-operation of the French fleet in the summer of 1689 would have broken down all opposition to James in Ireland, by isolating that country from England, with corresponding injury to **William**'s power.’’*


*The battle of the Boyne, which from its peculiar religious colouring has obtained a somewhat factitious celebrity, may be taken as the date at which the English crown was firmly fixed on **William**'s head. Yet it would be more accurate to say that the success of **William**, and with it the success of Europe, against **Louis XIV.** in the war of the League of Augsburg, was due to the mistakes and failure of the French naval campaign in 1690; though in that campaign was won the most conspicuous single success the French have ever gained at sea over the English.’’*
Every great naval power has gone to school to **Admiral Mahan**; and this country can hardly expect again to profit by those mistakes in strategy which the gifted American writer has so lucidly exposed.




---

p.191


Ireland, lying on the western flank of Great Britain, commands on the south the approaches to the Channel, on the west the North Atlantic, and on the east the Irish Sea, all sea-roads by which millions of pounds' worth of supplies are brought to England. On every coast Ireland has excellent harbours. There are Lough Swilly on the north, Blacksod Bay on the west, Bantry Bay, Cork Harbour and Waterford Harbour on the south, Kingstown Harbour and Belfast Lough on the east— to name but these—besides numerous lesser inlets which can serve as shelter for small craft and destroyers. It should here be noted that Belfast Harbour, owing to the enterprise of the Harbour Board, now possesses a channel and dock capable of accommodating a ship of the Dreadnought type.[57](javascript:footNote('E900031/note057.html'))


There is no necessity to presuppose an actively hostile Ireland; but an Ireland ruled by a disloyal faction would easily afford shelter to the warships of the enemy in her ports, whence they could draw supplies, where they could execute small repairs, and could coal from colliers despatched there for the purpose or captured. Thus lodged, a fleet or a squadron would command the main trade routes to England; and might inflict immense damage in a short time. Intelligence of its position could be prevented from reaching England by the simple method of destroying wireless stations and cutting cables.


These considerations would necessarily impose upon the Navy the task of detaching a squadron of watching cruisers charged with the duty of keeping guard about the whole of Ireland.


Is the Admiralty prepared to discharge this office in the event of war?


If not, there falls to be considered the further danger of the invasion of Ireland. That such a peril is not imaginary, is proved by the fact that Ireland has been invaded in the past.


The attempt of **Hoche** and **Grouchy** to land in Bantry Bay in 1796 failed ignominiously; and the next expedition
 



---

p.192



designed to invade Ireland was defeated at Camperdown. But in 1798, the year of the Great Rebellion in Ireland, three French frigates evaded the British cruisers, and on August 22 dropped anchor in Killala Bay. General of Brigade, **Jean Joseph Amable Humbert**, landed with his second in command, **General Sarazin**, several rebel Irish leaders, 1700 men and 82 officers.


On August 27 **Humbert** defeated the British troops at Castlebar ‘Races.’ On September 8, his forces surrendered at Ballinamuck to **Lord Cornwallis**. **General Humbert** was carried to England; and it is worth noting that while he was on his way, **Admiral Bompard** set sail from Brest with a ship of the line and three frigates, carrying 2587 men and 172 officers, commanded by **General Hardy** and the notorious **Wolfe Tone** (called General Smith for the occasion). **Bompard** was turned back by an English fleet of forty-two sail. The obvious conclusion of the whole matter is that the fleet can stop an invasion, always provided that the ships thereof are the right number in the right place at the right time.


The Irish Rebellion of 1798 is often discussed as though it was wholly bred of the corruption of Ireland itself. The fact was, of course, that it was an offshoot of the French Revolution, and that the condition of Ireland at the time was no more than a contributory cause. My Lords **Cornwallis**, **Castlereagh**, and **Clare**, in combating the forces of the Rebellion, were actually in conflict with the vast insurrections of the French nation. The design of the Irish rebels was to enlist the mighty destructive force of France to serve their own ends.


**Wolfe Tone** and his colleague **Lewens**, in 1796, had succeeded in persuading **Carnot** and the French Directory to embrace the cause of Ireland. When the Rebellion of 1798 broke out, **Lewens** wrote to the Directory reminding them that they had promised that France should postulate the conferring of independence upon Ireland as the condition of making peace with England, and specifying five thousand troops of all arms, and thirty thousand muskets 



---

p.193



with artillery and ammunition, as sufficient to ensure the success of the Rebellion.


The attitude of the Directory is defined in the despatch addressed to **General Hardy** (upon whom the supreme command of the Humbert expedition at first devolved) by **Bruix, Minister of Marine**, dated July 30, 1798.


*The executive Directory is busily engaged in arranging to send help to the Irish who have taken up arms to sever the yoke of British rule. It is for the French Government to second the efforts of a brave people who have too long suffered under oppression.’’*


In other words, the Directory regarded the achievement of her independence by Ireland as an enterprise incidental to the greater scheme of the conquest of England and of Europe.


It was further laid down in the despatch that *it is most important to take every possible means to arouse the public spirit of the country, and particularly to foster sedulously its hatred of the English name.   
[*...*]  
 There has never been an expedition whose result might more powerfully affect the political situation in Europe, or could more advantageously assist the Republic.’’*


Irish conspirators have never risen to play any part higher than the office of cat's-paw to a foreign nation. Today, they are content—at present—to bribe with votes a political party in England. But it is none the less essential to remember that, as in 1688 and as in 1798 a great and militant foreign Power used the weapon of Irish sedition against England, so in 1912 the same instrument lies ready to hand. For the Home Rule conspiracy of *today* is nothing but the lees of the evil heritage bequeathed by the French Revolution.


It is the business of the naval officer, who is not concerned with party politics, to estimate the posture of international affairs solely in relation to the security of the State. The condition of Ireland at this moment, when the Home Rule issue has been wantonly revived, would, in the event of a war occurring between Great Britain and a



---

p.194



foreign Power, involve the necessity of regarding Ireland as a strategic base of essential value, a part of whose inhabitants might combine with the hostile forces by giving them shelter and supplies, and even by inviting them to occupy the country. Elsewhere in these pages, **Lord Percy** has pointed out that the necessity of holding a disaffected Ireland by garrisoning the country would totally disorganise our military preparations for war—such as they are.


These considerations must materially affect strategical dispositions in the event of war, involving the establishment and maintenance of a separate force of cruisers charged with the duty of patrolling the sea routes which converge upon Ireland, and of watching the harbours of her coasts. As matters stand at present, such a force does not exist.


It may, of course, be urged that a strategical plan designed for the double purpose of surveying the movements of a hostile battle-fleet and of guarding the trade-routes, must of necessity cover the coasts of Ireland, on the principle that the greater includes the less. The argument, however, omits the essential qualification that a part of the Irish population cannot be trusted. It is this additional difficulty which has been introduced into the problem of naval defence by the revival by politicians of the agitation of 1798, under another name.




---

p.195


### The military disadvantages of Home Rule

### By the **Earl Percy**


The Problems of Imperial defence have become of late years extremely complex, owing to the rise of a great European naval power, and also to the predominance of Japan in the Pacific. These two factors, combined with the invention of the Dreadnought type of ship which is now being built by other powers whose navies we could formerly afford to ignore, have rendered our position in the world more precarious, more dependent upon foreign alliances and ententes, and have rendered combination for defence far more essential. No Home Rule scheme can be judged without taking into consideration what its effect will be on this situation. It is proposed to consider it first in the light of the more pressing European danger, and next to examine how it will affect the wider problem of the future, namely, the co-operation of all parts of the British Empire for defence.


But first it is of course necessary to find out what Home Rule means, and what the internal state of Ireland will be if it passes. On this point there is at present no certainty. We can dismiss at once **Mr. Redmond**'s picture of a serenely contented and grateful Ireland, only desirous of helping her benefactor, and, under a strong and incorruptible government, engaged in setting its house in order. The presence of a strong Protestant community, the history of the Roman Catholic Church in all countries, and the deliberate fostering of separatist national ideals preclude the possibility of anything but a prolonged period of unrest, which, on the most favourable hypothesis, can only cease



---

p.196



altogether when the present generation has passed away. This unrest may take two forms; either civil war, or a condition where the rousing of old animosities, religious and otherwise, leads to internal disturbances of all kinds. It is not proposed to deal here with the consequences involved by the calling in of troops to suppress by force of arms an insurrectionary movement against the Government of Ireland. In view of the present state of affairs in Ulster, such an event seems extremely probable, but the disastrous results of passing Home Rule in face of it are so patent to all that it is unnecessary to enlarge upon them here. We have, therefore, to consider a condition of things in which old mutual hatreds have re-awakened, in which Ireland will be governed by men who have up till now preached sedition, have done their best to check recruiting, who have deliberately set up an ideal of ‘complete separation’ as their ultimate goal, and whose motto has always been ‘England's difficulty is Ireland's opportunity.’


It is conceivable, of course, though it is extremely improbable, that these aims and ideals may be abjured in course of time, but the gravity of these risks must be taken into account in examining Ireland's position in any scheme of national and Imperial defence both now and in the future. And in this connection it may be remarked that an almost exact analogy to the situation which will probably result from this measure may be seen in the events which preceded the Boer war, and it seems somewhat remarkable that those who endeavour to justify Home Rule by the supposed Colonial analogy should overlook a warning so evident and so recent in the history of our oversea dominions.


A Separatist party in Ireland would be enabled to work for ultimate independence as did **President Kruger**, and by the same methods, the same secret acquisition of arms and implements of war, the same building of fortresses with a view to a declaration of independence when a suitable opportunity arrived; and this would be all the more likely to occur if Ulster were exempted from a Home Rule Parliament. In this case Ulstermen would occupy exactly the 



---

p.197



same position as did the Uitlanders from 1895 to 1899. The same arguments for granting independence to Ireland are used now, the same talk of injustice towards those who are disloyal with equal disregard of the loyalist section, and the results will be the same. Would independence have been granted to the Transvaal or Orange Free State had their use of it been foreseen? Taking the factors in both cases into account, is there anything to justify the doubt that a repetition of that situation will occur, with the only difference that eventual rupture will probably entail the dismemberment of the Empire?


It is universally acknowledged that this country is at present faced with a more critical European situation than any we have experienced for a hundred years. It has tied our fleet to home waters, and has induced a very large and influential section of our people to advocate the necessity of compulsory military service. Our military organisation is on the face of it a makeshift, and the makeshift is not even complete, for in the Territorial Army and the Special Reserve alone there is a shortage of more than 80,000 men.


Now, our foreign policy of ententes and the needs of our oversea territories have necessitated a military organisation, the foundation of which is readiness to undertake an oversea expedition as well as to provide for home defence. The critical situation in Europe especially will demand the instant despatch of our Expeditionary Force on the outbreak of war, in which case there will be left in these islands the following forces after deducting 10 per *cent* for casualties:— 
 1. About 55,000 Regulars, of whom 30,000 will be under 20 years of age.
2. About 30,000 Reservists. These will be required to reinforce the Expeditionary Force.
3. About 60 000 Special Reservists. Some 30,000 of these are under 20. This force is to be used to reinforce the troops abroad.
4. About 245,000 Territorials. 72,000 of these are under 20.


In all there are some 400,000 men, of whom 130,000 are boys and 60,000 will leave the country soon after war 



---

p.198



breaks out. This will leave some 210,000 men to provide for the defence of England, Scotland, and Ireland, supplemented by 130,000 boys. These troops will be deprived of practically all Regular and even Reserve officers, and will have to provide for coast defence, for the security of law and order, and for the numbers required for a central field force. By means of juggling with figures, by the registration of names in what is called the National Reserve, but has no organisation or corporate existence, and by similar means, the seriousness of this situation has been concealed to some extent, but it is generally recognised as being little short of a national scandal, and would not be tolerated were it not for the general ignorance of our people concerning the exigencies of war and their blind belief in the omnipotence of the navy. This defencelessness has two dangers: firstly, the chance of a successful raid or invasion. As long as our navy is not defeated, no invading force of more than 70,000 men is supposed to be capable of landing. The second danger is that the mere fear of such an event will prevent the despatch of the Expeditionary Force and the fulfilment of our oversea obligations.


It must be obvious that in the precarious state of our national defence anything which renders either of these dangers more probable should be avoided at all costs. If, for instance, the condition of Ireland should demand the maintenance of a larger garrison in that country, the whole of our present organisation for defence falls to pieces. Looking only at the present foreign situation, and the evergrowing menace of increasing armaments, if the passing of Home Rule should require the retention of a single extra soldier in Ireland, it is perfectly certain that nothing could justify the adoption of such a measure. It is not intended to convey the impression that there is any fear of Ireland repeating the history of 1796 and welcoming a foreign invasion, although it is impossible to ignore the anti-English campaign of agitation, or to say to what length it will go; but the mere fact of internal dissension in that country will give an enemy exactly the chance he looks for. Many of 



---

p.199



those best qualified to judge are of opinion that Germany is only waiting to free herself of an embarrassing situation, until one power of the Triple Entente is for the time being too much occupied to intervene in a Continental struggle. We have had one warning when, in September, 1911, a railway strike at home coincided with a foreign crisis. Are we deliberately to take a step which will almost certainly involve us in a similar dilemma?


This is the more immediate danger, but, apart from this, the strategical value of Ireland will be profoundly affected by its separation from England, and this constitutes a grave source of weakness, even if internal trouble be avoided, and a comparatively loyal government be installed. Ireland lies directly across all the trade routes by which nearly all our supplies of food and raw material are brought, and it covers the principal trade centres of the Midlands and the South of Scotland. In any attack by an enemy on our commerce, Ireland will become of supreme importance. There are two stages in every naval war: first, the engagement between the two navies; second, the blockade or destruction of the ships of the beaten side. This was the method by which we fought Napoleon, but even then we could not prevent the enemy's ships escaping from time to time; and even after we had destroyed their navy at Trafalgar, the damage to our oversea commerce was enormous. Nowadays, torpedoes, submarines, and floating mines have rendered blockade infinitely more precarious, and consequently we have to take into account the extreme probability, and indeed, certainty, of hostile cruisers escaping and menacing our oversea supplies. This danger will be increased ten-fold if Germany has been able to defeat France, and use French, Dutch, and Belgian ports for privateering purposes. In the second, if not in the first, stage of European war, therefore, the closest co-operation between the governments of Ireland and England will be essential. In this case, Queenstown and Lough Swilly will be the bases for our own protecting cruisers, and on their success will depend the issues of life and death for our people. As the West of



---

p.200



Ireland is the nearest point in these islands to America, it is probable that cargoes destined for English ports will reach them via Ireland to avoid the longer sea-transit. **Lord Wolseley** has even gone so far as to minimise the dangers of blockade, because the Irish coast offered such facilities for blockade-running. It is certain that in our greatest need Ireland might well prove our salvation, provided we had not absolutely lost command of the sea, and this advantage a Liberal Government is prepared to jeopardise for reasons, which, compared with the interests at stake, are little less than sordid.


But even if Ireland be less directly affected by war than in this case, and even if its internal condition should give little anxiety, the very nature of its resources should prevent us taking a step which may deprive us of them in emergency or, at least, render them less readily available. Not only do we draw a number of our soldiers from there, out of all proportion to the quotas provided by the populations of England and Scotland, but we are absolutely dependent for our mounted branches on Irish horses. For our supplies in time of stress, for our horses, and for a great and valuable recruiting area, we shall be forced to rely on a government whose future is wrapped in the deepest obscurity, and which at the best is hardly likely to give us enthusiastic support.


Our whole military organisation is becoming more decentralised and more dependent on voluntary effort; it is devolving more and more upon Territorial Associations and local bodies of all kinds. We do not possess the reserves of horses and transport which continental nations hold ready for use on mobilisation, and, as a substitute, we have had to fall back on a system of registration which demands care, zeal, and energy on the part of these civilian bodies. How will an Irish Government and its officials fulfil a duty which will be distorted by every Nationalist into an attempt to employ the national resources for the sole benefit of England?


War is a stern taskmaster, demanding long years of 



---

p.201



preparation and combination of effort for one end. The political separation of the two countries does not alter the fact that they are, in the military sense, one area of operations and of supply, and, at a time like the present, when the mutual dependence of all parts of the Empire is gradually being realised; when the dominions are building navies, and all our dependencies are co-operating in one scheme of defence for the whole; when the elaboration of the details of this scheme are the pressing need of the hour, the dissolution of the Union binding together the very heart of the Empire, is a strategic mistake, the disastrous significance of which it is impossible to exaggerate. For it must be remembered that here is no analogy to a federation of semi-independent provinces as in Canada, where national defence is equally the interest of the whole. Ireland has never recognised this community of interest with England. Quebec, it is true, stands aloof and indifferent to the ideals of the sister provinces; but there is no bitter religious hatred, no fierce, anti-national aims fostered by ancient traditions, life-long feuds and unscrupulous agitation, and every Canadian knows that Quebec would fight to the last against American aggression, if only to preserve her religious independence. There is no such bond here— or, at least, the Irish Nationalist has refused to acknowledge it.


The year 1912 has opened amid signs of unrest and change, the meaning or the end of which no man can know. In the Far East and the Near East political and religious systems are disappearing, and chaos is steadily increasing. In Europe the nations have set out on the march to Armageddon, and there is no staying the progress of their armaments. In Great Britain alone the question of preparation for war is shirked on the plea that it is one for experts, and even soldiers and sailors, drawn into the political vortex, make light of our necessities, believing in the hopelessness of ever convincing the people of the truth until ‘a white calamity of steel and iron, the bearing of burdens and the hot rage of insult,’ fall upon us. It is for this reason that we see the extraordinary phenomenon of men denying the



---

p.202



necessity for becoming a nation in arms, and yet urging our Government to contract no friendships abroad, and to interfere on behalf of every petty princedom oppressed by a powerful neighbour, and every downtrodden subject of some foreign power. It is these same men who wish to dissolve the Union, and to impose obligations at home upon an inadequate army which would leave us powerless abroad. And the longer war delays in coming, the greater will be the danger when it comes. With the increase in armaments, this country must undergo a proportionate sacrifice. If compulsory service should be adopted, it must apply to Ireland as well as the United Kingdom. But how will an independent government in Dublin view the compulsory enrolment of the manhood of Ireland, two-thirds of which have been taught to regard England as the national and hereditary enemy? The Irish are, above all, a military race. Had we been able to enforce such service within the Union, whatever temporary opposition it might have encountered, it might ultimately have proved an indissoluble bond of friendship.


The future is very dark, and it is all important that we should face it with open eyes. War cannot long be delayed, and there is too little time left to put our house in order. Even if Home Rule could be shown to be an act of justice due to a wronged people who have proved themselves capable of self-government, even then it could not be justified in the present crisis abroad. But it is not so. Ulster will fight for the same cause as did the Northern States of America, and may well show the same self-sacrifice. It will be civil war in a country peculiarly adapted to the movements of irregular troops, well acquainted with its features; it will be accompanied by atrocities which will be remembered for centuries. And this is the tremendous risk we are deliberately running, when we only possess six divisions of regular troops to support our allies on the continent and to safeguard the interests of the whole British Empire.


It is for the British people to decide whether the thin 



---

p.203



red line is to be still thinner in the day of battle, and whether those who should be fighting side by side shall be embittered and divided, or whether they will rather believe the words of the greatest naval expert living *It is impossible for a military man or a statesman with appreciation of military conditions, to look at the map and not perceive that the ambition of the Irish separatists, realised, would be even more threatening to the national life than the secession of the South was to that of the American Union.’’*

Admiral Mahan.




---

p.204


### The religious difficulty under Home Rule

### (1) The Church View

#### By the Rt. Rev, C. F. D'Arcy, Bishop of Down


Irish Unionists are determined in their opposition to Home Rule by many considerations. But deepest of all is the conviction that, on the establishment of a separate legislature and executive for Ireland, the religious difficulty, which is ever with us here, would be increased enormously. Occasionally, in English newspapers and in Irish political speeches, there occur phrases which imply that the Protestant ascendancy, as it was called, still exists in Ireland. Those who know Ireland are well aware that this is not merely false: it is impossible. Even in Belfast, as a recent controversy proved, Roman Catholics get their full share of whatever is to be had. There are no Roman Catholic disabilities. The majority has every means of making its power felt. At the present moment, the most impossible of all things in Ireland is that Roman Catholics, as such, should be oppressed or unfairly treated.


It used to be imagined that when this happy condition was attained there would be no more religious disagreement in Ireland. But events have shown the exact opposite to be the case. There never was a time when there was in the minds of Irish Protestants so deep a dread of Roman aggression, and so firm a conviction that the object of that aggression is the complete subjection of this country to Roman domination. Recalling very distinctly the events and discussions of 1886 and 1893, when Home Rule for Ireland seemed so near accomplishment under **Mr. Gladstone**'s 



---

p.205



leadership, the writer has no hesitation in saying that the dread of Roman tyranny is now far more vivid and, as a motive, far more urgent than it was at those epochs. Protestants are now convinced, as never before, that Home Rule must mean Rome Rule, and that, should it be forced upon them, in spite of all their efforts, they will be face to face with a struggle for liberty and conscience such as this land has not witnessed since the year 1690. That such should be the conviction of one-fourth of the people of Ireland, and that fourth by far the most energetic portion of its inhabitants, is a fact which politicians may well lay to heart.


Approaching this subject as one whose duties give him the spiritual oversight of more than 200,000 of the Protestants of Ireland—members of the Church of Ireland, and who has had twenty-seven years of experience as a clergyman in Ireland, both in the north and in the south, the writer may venture to speak with some confidence as to the mind of the people among whom he has worked for so long. In doing so, he feels at liberty to say that he is one who has always avoided religious controversy, and who has ever made it his endeavour to be tolerant and considerate of the feelings and convictions of others. He has a deep regard for his Roman Catholic fellow-countrymen, and recognises to the full their many excellent qualities and the sincerity of their religion.


It is possible to bring to a single point the reasons which make Irish Unionists so apprehensive as regards the religious difficulty under Home Rule. Their fears are not concerned with any of the special dogmas of the Roman Church. But they recognise, as people in England do not, the inevitable tendency of the consistent and immemorial policy of the Church of Rome in relation to persons who refuse to submit to her claims. They know that policy to be one of absolute and uncompromising insistence on the exacting of everything which she regards as her right as soon as she possesses the power. They know that, for her, toleration is only a temporary expedient. They know that professions and promises made by individual Roman Catholics and by 



---

p.206



political leaders, statements which to English ears seem a happy augury of a good time coming, are of no value whatever. They do not deny that such promises and guarantees express a great deal of good intention, but they know that above the individual, whether he be layman or ecclesiastic, there is a system which moves on, as soon as such movement becomes possible, in utter disregard of his statements. At the time when Catholic emancipation was in view, high Roman authorities gave the most emphatic guarantees that the position of the then Established Church in Ireland would never be endangered, so far as their Church and people were concerned. But when the time came, such promises proved absolutely worthless. Whether the disestablishment of the Irish Church was a good thing or not, is not the question here. The essential point, for our present purpose, is that the guarantees of individual Roman Catholics, no matter how positively or how confidently stated, are of no account as against the steady age-long policy of the Roman Church.


It is well known to all students that, while other religious bodies have, both in theory and in practice, renounced certain old methods of persuasion, the Roman Church still formally claims the power to control states, to depose princes, to absolve subjects from their allegiance, to extirpate heresy. She has never accepted the modern doctrine of toleration. But there are many who think that these ancient claims, though not renounced, are so much out-of-date in the modern world that they mean practically nothing. Such is the opinion of the average Englishman, and the mild and cultivated form of Romanism which is to be met with usually in England lends colour to the opinion. In Ireland we know better.


The recent Papal Decree, termed Ne Temere, regulating the solemnisation of marriages, has been enforced in Ireland in a manner which must seem impossible to Englishmen. According to this Decree, ‘No marriage is valid which is not contracted in the presence of the (Roman) parish priest of the place, or of the Ordinary, or of a priest deputed



---

p.207



by them, and of two witnesses at least.’ This rule is binding on all Roman Catholics.


It is easy to see what hardship and wrong must follow the observance of this rule in the case of mixed marriages.


As a result, it is now the case that, in Ireland, marriages which the law of the land declares to be valid are declared null and void by the Church of Rome, and the children of them are pronounced illegitimate. Nor is this a mere academic opinion: such is the power of the Roman Church in this country that she is able to enforce her laws without deference to the authority of the State.


The celebrated **McCann** case is the most notable illustration. Even in the Protestant city of Belfast we have seen a faithful wife deserted and her children spirited away from her, in obedience to this cruel decree. And we have seen an executive afraid to do its duty, because Rome had spoken and justified the outrage. Those who know intimately what is happening here are aware of case after case in which husband or wife is living in daily terror of similar interference, and also know that Protestants married to Roman Catholics, and living in the districts where the latter are in overwhelming majority, often find it impossible to stand against the odium arising from a bigoted and hostile public opinion. Nor does such interference stop here. Only a few weeks ago the kidnapping of a young wife by Roman Catholic ecclesiastics was prevented only by the brave and prompt action of her husband. In this case a sworn deposition, made in the presence of a well-known magistrate and fully attested, has been published, and no attempt at contradiction or explanation has been made. Let none imagine the Ne Temere question is extinct in Ireland. It is at this moment a burning question. Under Home Rule it would create a conflagration. And surely there is reason for the indignation of Protestants. Here we see the most solemn contract into which a man or woman can enter broken at the bidding of a system which claims supreme control over all human relations, public and private; and this, not for the maintenance of any moral principle, but 



---

p.208



to secure obedience to a disciplinary regulation which is regarded as of so little moral value that it is not enforced in any country in which the Government is strong enough to protect its subjects.


As if to define with perfect clearness, in the face of the modern world, the traditional claim of the Roman See, there has issued from the Vatican, within the last few weeks, a Decree which sets the Roman clergy above the law of the land. This ordinance, which is issued motus proprio by the Pope, is the re-enactment and more exact definition of an old law. It lays down the rule that whoever, without permission from any ecclesiastical authority, summons any ecclesiastical persons to a lay tribunal and compels them to attend publicly such a court, incurs instant excommunication. The excommunication is automatic, and absolution from it is specially reserved to the Roman Pontiff. This fact adds enormously to the terror of it, especially among a people like the Irish Roman Catholics. Great discussion has taken place as to the countries in which this Decree is in force. No one was surprised to hear that Germany was exempt. Archbishop Walsh, the Roman Catholic Archbishop of Dublin, in an elaborate discussion, gives the opinion that the Decree is abrogated under British law by the custom of the country, which has in the past rendered impossible the observance of the strict ecclesiastical rule in this matter, but is careful to add that this is only his opinion as a canonist, and is subject to the decision of the Holy See. When this plea is examined, it is found to mean simply this, that the law is not strictly observed in case of necessity. That this is the meaning of Archbishop Walsh's plea is proved by a quotation which he makes from **Pope Benedict XIV**. The principle laid down by **Pope Benedict** is that when it became impossible to resist the encroachment of adverse customs, the Popes shut their eyes to what was going on, and tolerated what they had no power to prevent. It is exactly the principle of toleration as a temporary expedient. The re-enactment of the law by the present Pope means surely, if it means anything, that such toleration 



---

p.209



is to cease wherever and whenever the law can be enforced. But, be it observed, this necessity is entirely dependent on the strength of the authority which administers the civil law. The moment the civil authority grows weak in its assertion of its supremacy, the plea of necessity fails, and the ecclesiastical law must be enforced. Those who know Ireland are well aware that this is exactly what would happen under Home Rule. Here is the crowning proof of the truth that, above all the well-intentioned persons who give assurances of the peace and goodwill that would flourish under Home Rule, there is a power which would bring all their good intentions to nothing.


But what of the Church of Ireland under Home Rule? Formerly the Established Church of the country, and as such occupying a position of special privilege, she still enjoys something of the traditional consideration which belonged to that position, and is more than ever conscious of her unbroken ecclesiastical descent from the Ancient Church of Ireland. Her adherents number 575,000, of whom 366,000 are in Ulster. As part of her heritage she holds nearly all the ancient ecclesiastical sites and the more important of the ancient buildings which still survive. These possessions, thus inherited from an immemorial past, were secured to her by the Act of Disestablishment. For the rest, the endowments which she enjoys at the present time have been created since 1870 by the self-denial and generosity of her clergy and laity. Under British law, her position is secure. But would she be secure under Home Rule? Those of her advisers who have most right to speak with authority are convinced that she would not. The Bishop of Ossory, in an able and very moderate statement made at the meeting of the Synod of that Diocese, last September, showed that both the principal churches and the endowments now held by the Church of Ireland have been claimed repeatedly by prominent representatives of the Church of Rome. It is stated that the Church sites and buildings belong to the Roman Communion in Ireland because, on Roman Catholic principles, that communion



---

p.210



truly represents the ancient Irish Church, and no lapse of time can invalidate the Church's title; and that the endowments belong to the same communion because they ‘represent moneys derived from pre-Disestablishment days, which were, in their turn, the alienated possessions of the Roman Church’ (see Bishop of Ossory's Synod Address, p. 7). As regards this last statement, it must be noted that the only sense in which it can be truly said that the endowments represent moneys derived from pre-Disestablishment days is that the foundation of the new financial system was laid by the generosity of the clergy in office at the time. They entrusted to the Representative Body of the Church the capitalised value of the life-interests secured to them by the Act. The money was their private property, and their action one which involved great self-denial, for they gave up the security offered by the State. The money was so calculated that the whole should be exhausted when all payments were made. By good management, however, it yielded considerable profit, and meanwhile formed a foundation on which to build. It was, however, in no sense an endowment given by the State, nor was it a fund on which any but the legal owners (i.e. the clergy of the time) had a justifiable claim.


The Bishop of Ossory's statement excited much discussion, but, though many Roman Catholic apologists endeavoured to laugh away his fears as groundless, not one denied the validity of his argument. The fact that, as he showed, the Church of Ireland holds her churches by exactly the same title as that by which the English Church holds Westminster Abbey, and that, for the Irish Church, there is the additional security of the Act of 1869, count for nothing in the eye of Roman Canon Law. In an Ireland ruled by a Parliament of which the vast majority would be Roman Catholics, devout and sincere, representing constituencies peopled by devout and sincere persons who believe that the laws of the Vatican are the laws of God, with a clergy lifted above the civil law by the operation of the recent Motu Proprio Decree, an Ireland in



---

p.211



which even the school catechisms (see the Christian Brothers' Catechism, quoted by the Bishop of Ossory, op. cit. p. 8) teach that an alien Church unlawfully excludes ‘the Catholics’ from their own churches, how long would it be before a movement, burning with holy zeal and pious indignation, against the usurpers, would sweep away every barrier and drive out ‘the heretics’ from the ancient shrines?


Irish Churchmen who know their country are aware that even the most stringent guarantees would be worthless in such a case, as they proved worthless in the Act of Union, and at the time of Catholic emancipation.


Some English Liberals imagine that Home Rule would be followed by an uprising of popular independence which would destroy the power of the Roman Church in Ireland. Let those who think this consider that the more independent spirits among the Irish Roman Catholics go to America, and let them further consider what has happened in the Province of Quebec in Canada. The immense strength of the bonds—religious, social, and educational—by which the mass of the people in the South and West of Ireland are held in the grip of the Roman ecclesiastical system, and the power which would be exerted by the central authority of that system by means of the recent decrees, make it certain that clerical domination would, from the outset, be the ruling principle of an Irish Parliament.


There is no desire nearer to the hearts of the clergy and people who form the Church to which the writer belongs than that they should be enabled to live at peace with their Roman Catholic fellow-countrymen, and work in union with them, for the good of their country and the promotion of that new prosperity which recent years have brought. They dread Home Rule, because they know that, instead of peace, it would bring a sword, and plunge their country once again into all the horrors of civil and religious strife.




---

p.212


### The Religious Difficulty Under Home Rule

### (2) The Nonconformist View

####  By Rev. Samuel Prenter, M.A., D.D. (Dublin),

##### *Moderator of General Assembly of Presbyterian Church in Ireland in 1904–5.*


For obvious reasons, the Religious Difficulty under Home Rule does not receive much attention on the political platform in Great Britain. But in Ireland a religious problem flames at the heart of the whole controversy. This religious problem creates the cleavage in the Irish population, and is the real secret of the intense passion on both sides with which Home Rule is both prosecuted and resisted. Irishmen understand this very well; but as Home Rule, on its face value, is only a question of a mode of civil government, it is almost impossible to make the matter clear to British electors. They say, What has religion got to do with Home Rule? Home Rule is a pure question of politics, and it must be solved on exclusively political lines. Even if this were so, might not Englishmen remember that the Nationalist Members of Parliament have been controlled by the Church of Rome in their votes on the English education question? I mention this to show that under the disguise of pure politics ecclesiastical authority may stalk in perfect freedom through the lobbies of the House of Commons. Is it, then, an absolutely incredible thing that what has been done in the English Parliament in the name of politics may be done openly and undisguised in the name of politics in a Home Rule Parliament? That such will be the case I shall now attempt to show.


Let us begin with the most elementary facts. According 



---

p.213



to the official census of 1911 the population of Ireland is grouped as follows: 




|  |  |
| --- | --- |
| Roman Catholics | 3,238,656 |
| Irish Church | 575,489 |
| Presbyterians | 439,876 |
| Methodists | 61,806 |
| All other Christian denominations | 57,718 |
| Jews | 5,101 |
| Information refused | 3,305 |






I beg the electors of Great Britain to look steadily into the above figures, and to ask themselves who are the Home Rulers and who are the Unionists in Ireland. Irish Home Rulers are almost all Roman Catholics, and the Protestants and others are almost all stout Unionists. Does this fact suggest nothing? How is it that the line of demarcation in Irish politics almost exactly coincides with the line of demarcation in religion? Quite true, there are a few Irish Roman Catholics who are Unionists, and a few Protestants who are Home Rulers. But they are so few and so uninfluential on both sides that the exception only serves to prove the rule. These exceptions, no doubt, have been abundantly exploited, and the very most has been made of them. But the great elementary fact remains, that one-fourth of the Irish people, mostly Protestant, are resolutely, and even passionately, opposed to Home Rule; and the remarkable thing is that the most militant Irish Unionists for the past twenty years have not been the members of the Irish Church who might be suspected of Protestant Ascendency prejudices, but they are the Presbyterians and Methodists who never belonged to the old Protestant Ascendency party. It is of Irish Presbyterians that I can speak with the most intimate knowledge. Their record in Ireland requires to be made perfectly clear. In 1829 they were the champions of Catholic Emancipation. In 1868 they supported **Mr. Gladstone** in his great Irish reforms. They have been at all times the advocates of perfect equality in religion, and of unsectarianism in education. They stand firm and staunch on these two principles still. But they are the sternest and



---

p.214



strongest opponents of Home Rule, and their reason is because Home Rule spells for Ireland a new religious ascendancy and the destruction of the unsectarian principle in education.


I ask on these grounds that English and Scottish electors should pause for a moment, and open their minds to the fact that there is a great religious problem at the heart of Home Rule. Irish Presbyterians claim that they know what they are doing, and that they are not the blind dupes of religious prejudice and political passion. It is for a great something that they have embarked in this conflict; they are determined to risk everything in this resistance, and in proportion as the danger approaches, in like proportion does their hostility to the Home Rule claim increase.


What, then, is the secret of this determination? It lies in a nutshell. A Parliament in Dublin would be under the control and domination of the Church of Rome. Two facts in Irish life render this not only likely and probable, but inevitable and certain. The first fact is that three-fourths of the members would be Roman Catholic, and the second fact is that the Irish people are the most devoted Roman Catholics at present in Christendom. No one disputes the first fact, but the second requires to be made clear to the electors of Great Britain. Let no one suppose that I am finding fault with Irishmen for being devoted Roman Catholics. What I wish to show is that the Church of Rome would be supreme in the new Parliament, and that she is not a good guardian of Protestant liberties and interests. Ireland has been for the last two generations brought into absolute captivity to the principles of ultramontanism. When Italy asserted her nationality, and fought for it in 1870, Ireland sent out a brigade to fight on the side of the Pope. When France, a few years ago, broke up in that land the bondage of Ecclesiasticism, the streets of Dublin were filled Sunday after Sunday for weeks with crowds of Irishmen, headed by priests, shouting for the Pope against France. The Church first, nationality afterwards, is the creed of the ultramontane; and it is the



---

p.215



avowed creed of the Irish people. But this would be changed in an Irish Parliament, British electors affirm. Let us hear what **Mr. John Dillon, M.P.**, says on the point. Speaking about a year ago in the Free Trade Hall in Manchester, **Mr. Dillon** said—
*I assert, and it is the glory of our race, that we are *today* the right arm of the Catholic Church throughout the world   
[*...*]  
 we stand *today* as we have stood throughout, without abating one jot or tittle of that faith, the most Catholic nation on the whole earth.’’*


What **Mr. Dillon** says is perfectly true. The Irish Parliament would be constituted on the Roman model. If there were none but Roman Catholics in Ireland, Ireland would rapidly become a ‘State of the Church.’ But how would Protestants fare? Just as they fared in old Papal days in Italy under the temporal rule of the Vatican. But it may still be said that Irishmen themselves would curb the ecclesiastical power. This is one of the delusions by which British electors conceal from themselves the peril of Home Rule to Irish Protestants. They forget that Irishmen are, if possible, more Roman than Rome herself. I take the following picture of the Romanised condition of Ireland from a Roman Catholic writer—

> 
> **Mr. Frank Hugh O'Donnell**, who ‘believes in the Papal Church in every point, who accepts her teaching from Nicaea to Trent, and from Trent to the Vatican,’ says, ‘While the general population of Ireland has been going down by leaps and bounds to the abyss, the clerical population has been mounting by *cent* per *cent* during the same period ...’ A short time ago, when an Austrian Cabinet was being heckled by some anti-clerical opponents upon its alleged encouragement of an excessive number of clerical persons in Austria, the Minister replied, ‘If you want to know what an excessive number of the clergy is like go to Ireland. In proportion to their population the Irish have got ten priests and nuns to the one who exists in Austria. I do not prejudge the question. They may be wanted in Ireland. But let not honourable members talk about over-clericalism in Austria until they have studied the clerical statistics of Ireland.’ A Jesuit visitor to Ireland, on returning to his English acquaintances, and being asked how did he find the priests
> 
> 
> 
> ---
> 
> p.216
> 
> 
> 
> in Ireland, replied, ‘The priests in Ireland! There is nobody but priests in Ireland. Over there they are treading on one another's heels.’ While the population of Ireland has diminished one-half, the population of the Presbyteries and convents has multiplied threefold or more. Comparisons are then instituted between the Sacerdotal census of Ireland, and that of the European Papal countries. I shall state results only. Belgium has only one Archbishop and five Bishops; but if it were staffed with prelates on the Irish scale it would have nine or ten Archbishops and some sixty Bishops. I suppose the main army of ecclesiastics in the two countries is in the same grossly incongruous proportions—ten or twelve priests in Ireland for every one in Belgium! The German Empire, with its 21,000,000 Roman Catholics, has actually fewer mitred prelates than Ireland with its 3,000,000 of Roman Catholics. The figures of Austria-Hungary with its Roman Catholic population of 36,000,000 are equally impressive. It has eleven Archbishops, but if it were staffed on the Irish scale it would have forty-eight. It has forty Bishops, but if it were like Ireland it wouldhave 288. **Mr. O'Donnell** goes on: ‘This enormous population of Churchmen, far beyond the necessities and even the luxuries of religious worship and service, would be a heavy tax upon the resources of great and wealthy lands. That must it be for Ireland to have to supply the Episcopal villas, the new Cathedrals, and handsome Presbyteries, and handsome incomes of this enormous and increasing host of reverend gentlemen, who, as regards five-sixths of their number, contribute neither to the spiritual nor temporal felicity of the Island? They are the despotic managers of all primary schools, and can exact what homage they please from the poor serf-teachers, whom they dominate and whom they keep eternally under their thumb. They absolutely own and control all the secondary schools, with all their private profits and all their Government grants. In the University what they do not dominate they mutilate. Every appointment, from dispensary doctors to members of Parliament, must acknowledge their ownership, and pay toll to their despotism. The County Councils must contribute patronage according to their indications; the parish committees of the congested districts supplement their pocket-money. They have annexed the revenues of the industrial schools. They are engaged in transforming the universal proprietary of Ireland in order to add materials for their exactions from the living and the moribund. I am told that not less than £5,000,000 are lifted from the Irish people every year by the innumerable agencies of clerical suction which are at work upon all parts of the Irish body, politic 
> 
> 
> 
> ---
> 
> p.217
> 
> 
> 
> and social. Nor can it be forgotten that the material loss is only a portion of the injury. The brow-beaten and intimidated condition of the popular action and intelligence which is necessary to this state of things necessarily communicates its want of will and energy to every function of the community.’
> 
> 
> 




Of course **Mr. F. H. O'Donnell** has been driven out of public life in Ireland for plain speaking like this; and so would every man be who ventured to cross swords with his Church. It aggravates the situation immensely when we take another fact in Irish life into account.


In quite recent months **Mr. Devlin, M.P.**, has brought into prominence a society called the **Ancient Order of Hibernians** (sometimes called the Molly Maguires) which, according to the late **Mr. Michael Davitt**, is ‘the most wonderful pro-Celtic organisation in the world.’ This is a secret society which at one time was under the ban of the Church; but quite recently the ban has been removed, and priests are now allowed to join the order. The present Pope is said to be its most powerful friend. It has branches in many lands, and it is rapidly gathering into it all the great mass of the Irish Roman Catholic people. This is the most wonderful political machine in Ireland.


**Mr. William O'Brien, M.P.**, has recently given an account of this society which has never been seriously questioned. 
*The fundamental object of the Hibernian Society is to give preference to its own members first and Catholics afterwards as against Protestants on all occasions. Whether it is a question of custom, office, public contracts, or positions on Public Boards, Molly Maguires are pledged always to support a Catholic as against a Protestant. If Protestants are to be robbed of their business, if they are to be deprived of public contracts, if they are to be shut out of every office of honour or emolument, what is this but extermination? The domination of such a society would make this country a hell. It would light the flame of civil war in our midst, and blight every hope of its future prosperity.’’*


And now we reach the core of the question. It is perfectly clear that Home Rule would create a Roman Catholic



---

p.218



ascendancy in Ireland, but still it might be said that the Church of Rome would be tolerant. On that point we had best consult the Church of Rome herself. Has she ever said that she would practise toleration towards Protestants when she was in power? Never; on the contrary, she declares most clearly that toleration of error is a deadly sin. In this respect the Church of Rome claims to differ toto coelo from the churches of the Reformation. In Ireland she has passed through all the stages of ecclesiastical experience from the lowest form of disability to the present claim of supremacy. In the dark days of her suffering she cried for toleration, and as the claim was just in Protestant eyes she got it. Then as she grew in strength she stretched forth her hands for equality, and as this too was just, she gradually obtained it. At present she enjoys equality in every practical right and privilege with her Protestant neighbours. But in the demand for Home Rule there is involved the claim of exerting an ecclesiastical ascendancy not only over her own members but over Irish Protestants, and this is the claim which is unjust and which ought not to be granted. **Green**, the historian, points out that **William Pitt** made the Union with England the ground of his plea for Roman Catholic emancipation, as it would effectually prevent a Romish ascendancy in Ireland. Home Rule in practice will destroy the control of Great Britain, and, therefore, involves the removal of the bulwark against Roman Catholic ascendancy.


The contention of the Irish Protestants is that neither their will nor their religious liberties would be safe in the custody of Rome. In an Irish Parliament civil allegiance to the Holy See would be the test of membership, and would make every Roman Catholic member a civil servant of the Vatican. That Parliament would be compelled to carry out the behests of the Church. The Church is hostile to the liberty of the Press, to liberty of public speech, to Modernism in science, in literature, in philosophy; is bound to exact obedience from her own members and to extirpate heresy and heretics; claims to be above Civil Law, and the right to enforce Canon Law whenever she is able, There are



---

p.219



simply no limits even of life or property to the range of her intolerance. This is not an indictment, it is the boast of Rome. She plumes herself upon being an intolerant because she is an infallible Church, and her Irish claim, symbolised by the Papal Tiara, is supremacy over the Church, supremacy over the State, and supremacy over the invisible world. Unquestioning obedience is her law towards her own subjects, and intolerance tempered with prudence is her law towards Protestants. It is a strange hallucination to find that there are politicians *today* who think that Rome will change her principles at the bidding of **Mr. Redmond**, or to please hard-driven politicians, or to make Rome attractive to a Protestant Empire. Rome claims supremacy, and she tells us quite candidly what she will do when she gets it.


Here is our difficulty under Home Rule. Irish Protestants see that they must either refuse to go into an Irish Parliament, or else go into it as a hopeless minority, and turn it into an arena for the maintenance of their most elementary rights; in which case the Irish Parliament would be simply a cockpit of religio-political strife. But it would be a great mistake to suppose that the religious difficulty is confined to Irish Protestants. It is a difficulty which would become in time a crushing burden to Roman Catholics themselves. The yoke of Rome was found too heavy for Italy, and in a generation or two it would be found too heavy for Ireland. But for the creation of the Papal ascendancy in Ireland, the responsibility must rest, in the long run, on Great Britain herself. England and Scotland, the most favoured lands of the Reformation, by establishing Home Rule in Ireland, will do for Rome what no other country in the world would do for her. They would entrust her with a legislative machine which she could control without check, hand over to her tender mercies a million of the best Protestants of the Empire, and establish at the heart of the Empire a power altogether at variance with her own ideals of Government, fraught with danger, and a good base of operations for the conquest of England. Can this be done with impunity? Can Great Britain divest herself of a



---

p.220



religious responsibility in dealing with Home Rule? Is there not a God in Heaven who will take note of such national procedure? Are electors not responsible to Him for the use they make of their votes? If they sow to the wind, must they not reap the whirlwind?


In brief compass, I hope I have made it quite clear what the Religious Difficulty in Ireland under Home Rule is. It is not a mere accident of the situation; it does not spring from any question of temper, or of prejudice, or of bigotry. The Religious Difficulty is created by the essential and fundamental genius of Romanism, Her whole ideal of life differs from the Protestant ideal. It is impossible to reconcile these two ideals. It is impossible to unite them in any amalgam that would not mean the destruction of both. Under Imperial Rule these ideals have discovered a decently working modus vivendi. **Mr. Pitt**'s contention that the union with Great Britain would be an effectual barrier against Romanism has held good. But if you remove Imperial Rule *then* you create at a stroke the ascendancy of Rome, and under that ascendency the greatest injustice would be inflicted on the Protestant minority. Questions of public situations and of efficient patronage are of very subordinate importance indeed. **Mr. Redmond** demands that Irish Protestants must be included in his Home Rule scheme, and threatens that if they object they must be dealt with ‘by the strong hand,’ and his Home Rule Parliament would be subservient to the Church of Rome. Does any one suppose that a million of the most earnest Protestants in the world are going to submit to such an arrangement? Neither Englishmen nor Scotsmen would be willing themselves to enter under such a yoke, and why should they ask Irishmen to do so?


It is contended, indeed, that the power of the priest in Ireland is on the wane. This is partly true and partly not true. It is true that he is not quite the political and social autocrat that he once was. But it is not true that the Church of Rome is less powerful in Ireland than she was. On the contrary, as an ecclesiastical organisation Rome was



---

p.221



never so compact in organisation, never so ably manned by both regular and secular clergy, never so wealthy nor so full of resource, never so obedient to the rule of the Vatican, as at the present moment. Give her an Irish Parliament, and she will be complete; she will patiently subdue all Ireland to her will. Emigration has drained the country of the strong men of the laity, who might be able to resist her encroachments. **Dr. Horton** truly says: ‘The Roman Church dominates Ireland and the Irish as completely as Islam dominates Morocco.’ By Ireland and the Irish **Dr. Horton**, of course, means Roman Catholic Ireland. Are you now going to place a legislative weapon in her hand whereby she will be able to dominate Protestants also? It is bad statesmanship; bad politics; bad religion. For Ireland it can bring nothing but ruin; and for the Empire nothing but terrible retribution in the future.




---

p.225


CONSTRUCTIVE
------------


### Unionist Policy in Relation to Rural Development in Ireland

### By the Right Hon. **Gerald Balfour**


‘For the last two and twenty years, at first a few and now a goodly company of rural reformers with whom I have been associated, and on whose behalf I write, have been steadily working out a complete scheme of rural development, their formula being better farming, better business, better living.’ —**Sir H. Plunkett**, letter to the Times, December, 1911.


*Ireland would prefer rags and poverty rather than surrender her national spirit.’’*

—**Mr. John Redmond**, speech at Buffalo, September 27, 1910.


It should never be forgotten that the maintenance of the legislative Union between Ireland and Great Britain is defended by Unionists no less in the interests of Ireland than in that of the United Kingdom and of the Empire. That the ills from which Ireland has admittedly suffered in the past, and for which she still suffers, though in diminished measure, in the present, are economic and social rather than political, is a fundamental tenet of Unionism. Unionists also believe that economic and social conditions in Ireland can be more effectively dealt with under the existing political constitution than under any form of Home Rule. Ireland is a poor country, and needs the financial resources which only the Imperial Parliament can provide. She is, moreover, a country divided into hostile camps marked by strong racial and religious differences. As **Sir George Trevelyan** long ago pointed out, there is not one Ireland, there are two Irelands; and only so far as Ireland



---

p.226



continues an integral part of a large whole can the antagonism between the two elements be prevented from forming a dangerous obstacle to all real progress.


Nationalist politicians, of course, diagnose the situation very differently. Apply suitable remedial measures, say the Unionists, to the social and economic conditions of the country, and it is not unreasonable to hope that political discontent— or, in other words, the demand for Home Rule— will gradually die away of itself. Give us Home Rule, say the Nationalists, and all other things will be added to us.


The main object of the present paper is to give a bird's eye view of Unionist policy in relation to rural development in Ireland during the eventful years 1885–1905. It does not pretend to deal with the larger issue raised between Unionism and Nationalism; but incidentally, it will be found to throw some interesting side lights upon it.


The Irish Question in its most essential aspect is a Farmers' Question. The difficulties which it presents have their deepest roots in an unsatisfactory system of land tenure, excessive sub-division of holdings, tend antiquated methods of agricultural economy.


**Mr. Gladstone** endeavoured to deal with the system of land tenure in the two important Acts of 1870 and 1881; but the system of dual ownership which those Acts set up introduced, perhaps, as many evils as they removed. It became more and more evident that the only effectual remedy lay in the complete transference of the ownership of the land from the landlord to the occupying tenant. The successful application of this remedy with anything like fairness to both sides absolutely demanded the use of State credit on a large scale. The plan actually adopted in a succession of Land Acts passed by Unionist Governments, beginning with the Ashbourne Act of 1885, and ending with the Wyndham Act of 1903, is broadly speaking as follows: The State purchases the interest of the landlord outright and vests the ownership in the occupying tenant subject to a fixed payment for a definite term of years.




---

p.227


These annual payments are not in the nature of rent: they represent a low rate of interest on the purchase money, plus such contribution to a sinking fund as will repay the principal in the term of years for which the annual payments are to run. The practical effect of this arrangement is that the occupier becomes the owner of his holding, subject to a terminable annual payment to the State of a sum less in amount than the rent he has had to pay heretofore.


The successful working of the scheme obviously depends on the credit of the State, in other words, its power of borrowing at a low rate of interest. In this respect the Imperial Government has an immense advantage over any possible Home Rule Government: indeed, it is doubtful whether any Home Rule Government could have attempted this great reform without wholesale confiscation of the landlords' property. Here then in Land Purchase and the abolition of dual ownership, we have one of the twin pillars on which, on its constructive side, the Irish policy of the Unionist party rests. But to solve the problem of rural Ireland— which, as I have said, is *the* Irish problem— more is required than the conversion of the occupying tenant into a peasant proprietor. The sense of ownership may be counted on to do much; but it will not make it possible for a family to live in decent comfort on an insufficient holding; neither will it enable the small farmer to compete with those foreign rivals who have at their command improved methods of production, improved methods of marketing their produce, facilities for obtaining capital adequate to their needs, and all the many advantages which superior education and organised co-operation bring in their train.


Looking back *today*, the wide field that in these directions was open to the beneficent action of the State, and to the equally beneficent action of voluntary associations, seems evident and obvious. It was by no means so evident or obvious twenty years ago. At that time the traditional policy of laisser faire had still a powerful hold over men's minds, and to abandon it even in the case of rural



---

p.228



Ireland was a veritable new departure in statesmanship. The idea of establishing a voluntary association to promote agricultural co-operation was even more remote; and, as will be seen in the sequel, it was to the insight and devoted persistence of a single individual that its successful realization has been ultimately due.


So far as State action was concerned, a beginning was naturally made with the poorest parts of the country. **Mr. Arthur Balfour** led the way with two important measures. One of these was the construction of light railways in the most backward tracts on the western seaboard. These railways were constructed at the public expense, but worked by existing railway companies, and linked up with existing railway systems. The benefits conferred on those parts of the country through which they passed have been great and lasting.


**Mr. Balfour**'s second contribution to Irish rural development was the creation of the Congested Districts Board in 1891. The ‘congested districts’ embraced the most poverty-stricken areas in the western counties, and the business of the Board was to devise and apply, within those districts, schemes for the amelioration of the social and economic condition of the population comprised in them. For this purpose, the Board was invested with very wide powers of a paternal character, and an annual income of upwards of 40,000 was placed at their free disposal, a sum which has been largely increased by subsequent Acts.


The experiment was an absolutely novel one, but no one who is able to compare the improved condition of the congested districts *today* with the state of things that prevailed twenty years ago can doubt that it has been amply justified by results.


Every phase of the life of the Irish peasant along the whole of the western seaboard has been made brighter and more hopeful by the beneficent operations of the Board. Its activities have been manifold, including the purchase and improvement of estates prior to re-sale to the tenants;



---

p.229



the re-arrangement and enlargement of holdings; the improvement of stock; the provision of pure seeds and high class manures; practical demonstration of various kinds, all educational in character; drainage; the construction of roads; improvement in the sanitary conditions of the people's dwellings; assistance to provide proper accommodation for the livestock of the farm, which too frequently were housed with the people themselves; the development of sea fisheries; the encouragement of many kinds of home industries for women and girls; the quarrying of granite; the making of kelp; the promotion of co-operative credit; and many other schemes which had practical regard to the needs of the people, and have contributed in a variety of ways to raise the standard of comfort of the inhabitants of these impoverished areas.


It will be noticed that among the other activities of the Congested Districts Board, I have specially mentioned the work of promoting co-operative credit by means of village banks managed on the Raffeisen system. The actual work of organising these co-operative banking associations has not been carried out directly by the Board, but through the agency of the Irish Agricultural Organisation Society (generally known by the shorter title of the I.A.O.S.), to which the Board has for many years past paid a small subsidy which might well have been on a more generous scale, having regard to the immense advantages which co-operation is capable of conferring on the small farmer.


The I.A.O.S. is a voluntary association of a strictly non-political character. ‘Business, not politics,’ has been its principle of action; and partly, perhaps, for this very reason it may claim to have contributed more than any other single agency towards the prosperity of rural Ireland. To its work I now turn.




---

p.230


#### The I.A.O.S.


The movement which the I.A.O.S. represents was started by **Sir Horace Plunkett**, and he has remained the most prominent figure in it ever since. **Sir Horace Plunkett** bears an honoured name wherever the rural problem is seriously studied; but, like other prophets, he has received perhaps less honour in his own country than elsewhere. At all events, in the task to which he has devoted his life he has had to encounter the tacit, and indeed at times the open opposition, of powerful sections of Nationalist opinion. Happily he belongs to the stamp of men whom no obstacles can discourage, and who find in the work itself their sufficient reward.


**Sir Horace Plunkett**'s leading idea was a simple one and has become *today* almost a commonplace. He compared the backward state of agriculture in Ireland with the great advance that had been made in various continental countries, where the natural conditions were not dissimilar to those of Ireland, and asked himself the secret of the difference. That secret he found in the word *organization* and he set himself to organize. The establishment of co-operative creameries seemed to afford the most hopeful opening, and it was to this that **Sir Horace Plunkett** and a few personal friends, in the year 1889, directed their earliest missionary efforts. The difficulties to be overcome were at first very great. ‘My own diary,’ writes Sir Horace, ‘records attendance at fifty meetings before a single society had resulted therefrom. It was weary work for a long time. These gatherings were miserable affairs compared with those which greeted our political speakers.’


The experiences[58](javascript:footNote('E900031/note058.html')) of another of the little band of devoted workers, **Mr. R. A. Anderson**, now Secretary of the I.A.O.S. throw an interesting light upon the nature of some of the obstacles which the new movement had to encounter.




---

p.231


*It was hard and thankless work. There was the apathy of the people, and the active opposition of the Press and the politicians. It would be hard to say now whether the abuse of the Conservative Cork Constitution, or that of the Nationalist Eagle of Skibbereen, was the louder. We were ‘killing the calves,’ we were ‘forcing the young women to emigrate,’ we were ‘destroying the industry.’ **Mr. Plunkett** was described as a ‘monster in human shape,’ and was abjured to ‘cease his hellish work.’ I was described as his ‘man Friday,’ and as ‘Roughrider Anderson.’ Once when I thought I had planted a creamery within the town of Rathkeale, my cooperative apple-cart was upset by a local solicitor, who, having elicited the fact that our movement recognised neither political nor religious differences so that the Unionist-Protestant cow was as dear to us as her Nationalist-Catholic sister gravely informed me that our programme would not suit Rathkeale. ‘Rathkeale,’ said he pompously, ‘is a Nationalist town—Nationalist to the backbone—and every pound of butter made in this creamery must be made on Nationalist principles, or it shan't be made at all.’ This sentiment was applauded loudly, and the proceedings terminated.’’*


Eventually, however, the zeal of the preachers, coupled with the economic soundness of the doctrine, prevailed over all difficulties. By 1894 the movement had outgrown the individual activities of the founders, and the Irish Agricultural Organisation Society was established in Dublin in order to promote and direct its further progress. That progress has been rapid and continuous, and *today* the co-operative societies connected with the I.A.O.S. number nearly 1000, with an annual turnover of upwards of 2.5 millions. They extend over the length and breadth of the land, and include creameries, agricultural societies (whose main business is the purchase of seeds and manure for distribution to the members), credit societies (village banks), poultry keepers' societies (for the marketing of eggs), flax societies, industries societies, as well as other societies of a miscellaneous character.


In 1892 the Liberal Party came into power. During their three years' tenure of office a Home Rule Bill was introduced and passed through the House of Commons, but 



---

p.232



little or nothing was attempted by the Government for the economic regeneration of the country.


The Unionist Party came back with a large majority in 1896, and the attention of the new Irish Government, in which the post of Lord Lieutenant was held by **Lord Cadogan** and that of Chief Secretary by the present writer, was from the first directed to the condition of the Irish farmer. The session of 1896 was largely devoted to the passing of a Bill for amending the Land Acts, and for further facilitating the conversion of occupying tenants into owners of their holdings. Time, however, was also found for a new Light Railways Act, under the provision of which railway communication has been opened up at the expense of the State in the poorest parts of north-west Ireland.


It was in the following year that the first attempt was made to establish an Irish Department of Agriculture. The Bill was not carried beyond a first reading, because it was ultimately decided that a Local Government Act should have precedence of it. But the project was only put aside for a time, and it was always looked upon by me as an integral part of our legislative programme. In framing the Bill of 1897, and also the later Bill of 1899, which passed into law, we received the greatest assistance from the labours of a body known as the Recess Committee, concerning which a few words must now be said.


#### The Recess Committee


To be the founder of agricultural co-operation in Ireland was **Sir Horace Plunkett**'s first great achievement; the bringing together of the Recess Committee was his second. He conceived the idea of inviting a number of the most prominent men in Ireland, irrespective of religious or political differences, to join in an inquiry into the means by which the Government could best promote the development of the agricultural and industrial resources of Ireland. This idea he propounded in an open letter published in August, 1895. The proposal was a bold one— how bold



---

p.233



no one unacquainted with Ireland will easily realise. Amongst Nationalist politicians the majority fought shy of it. **Mr. Justin McCarthy**, the leader of the party, could only see in **Sir Horace**'s letter ‘the expression of a belief that if your policy could be successfully carried out, the Irish people would cease to desire Home Rule.’ ‘I do not feel,’ he added, ‘that I could possibly take part in any organisation which had for its object the seeking of a substitute for that which I believe to be Ireland's greatest need—Home Rule .’ Fortunately, then as now, the Irish party was divided into two camps, and **Mr. Redmond**, at the head of a small minority of ‘Independents,’ was at liberty to take a different line. ‘I am unwilling,’ he wrote, ‘to take the responsibility of declining to aid in any effort to promote useful legislation in Ireland.’


Ultimately, **Sir Horace Plunkett**'s strong personality, his manifest singleness of purpose, and the intrinsic merits of his proposal carried the day, A committee, truly representative of all that was best in Irish life, was brought together, and commissioners were despatched to the Continent to report upon those systems of State aid linked with voluntary organisation which appeared to have revolutionised agriculture in countries not otherwise more favoured than Ireland itself. A large mass of most valuable information was collected. In less than a year the committee reported. The substance of the recommendation was

*That a Department of Government should be specially created, with a minister directly responsible to Parliament at its head. The Central Body was to be assisted by a Consultative Council representative of the interests concerned. The Department was to be adequately endowed from the Imperial Treasury, and was to administer State aid to agriculture and industries in Ireland upon principles which were fully described.’’*

 Ireland in the New Century. , p. 220.


With the general policy of these recommendations the Irish Government were in hearty sympathy, and the Bill of



---

p.234




1897, already referred to, was a first attempt to give effect to it. But in the absence of popularly elected local authorises an important part of the machinery for carrying out the proposals was wanting.


#### Irish Local Government Act


A reform of local government in Ireland had long been given a place in the Unionist programme, but the magnitude of the undertaking and the pressure of other business had hitherto stood in its way. It was now decided to take up this task in earnest, on the understanding that other measures relating to Ireland should be postponed in the meantime. The Irish Local Government Bill was accordingly introduced and passed in the following session (1898).


Of this Act, which involved not merely the creation of new popular Authorities, but also an entire rearrangement of local taxation, and some important changes in the system of poor relief, I will only say here that it must be counted as another of the great remedial measures which Ireland owes to the Unionist Party, and which it would have been difficult, if not impossible, to carry out in a satisfactory manner without assistance on a generous scale from the ample resources of the Imperial Exchequer.


#### Irish Department of Agriculture and Technical Instruction


The way was now open for the measure to which I had looked forward from the first moment of my going to Ireland, and which was to constitute the final abandonment of the old laissez faire policy in connection with Irish agriculture and industries. Great care and labour were devoted to the framing of the new Bill, and I was in constant touch throughout with members of the Recess Committee. It contained clauses dealing with urban as well as rural industries, but these lie outside my present subject, and I shall not refer to them further here.



---

p.235



On the side of rural development the Bill embodied a novel experiment in the art of government— novel at all events in British or Irish experience, though something like it had already been tried with conspicuous success various countries on the Continent. It was the continental example which had inspired the Report of the Recess Committee, and it was the recommendations of the Recess Committee which in their turn suggested the main features of the Bill of 1899.


There was indeed one body in Ireland whose functions corresponded in some degree with those of the Authority it was now proposed to set up. This body was the Congested Districts Board; and it might be said with some approximation to the truth that the object we had in view was to do for the rest of Ireland, mutatis mutandis, what the Congested Districts Board was intended to do for the poverty-stricken districts of the West. But there was this very important difference. The operations of the Congested Districts Board were carried out, and necessarily carried out, on strictly ‘paternal’ lines; the dominant note in the new departure was to be the encouragement of self-help. This difference carried with it an equally important difference in the constitution and methods of the administering Authority.


Out of a total endowment of £166,000 a year, a sum of over £100,000 was placed at the disposal of the Department to be applied to the ‘purposes of agriculture and other rural industries.’ These ‘purposes’ are defined in the Act as including—

*the aiding, improving, and developing of agriculture, horticulture, forestry, dairying, the breeding of horses, cattle, and other *livestock* and poultry, home and cottage industries, the preparation and cultivation of flax, inland fisheries, and any industries immediately connected with and subservient to any of the said matters, and any instruction relating thereto, and the facilitating of the carriage and distribution of produce,’’*


This part of the Endowment Fund was, in short, a grant to the Department to be applied to what may be described



---

p.236



as rural development in the widest sense of the term. As to the methods, little or no restriction was imposed upon the scope of its powers and in the expenditure of the money it was to be as free from Treasury control as the Congested Districts Board itself.


On the other hand, the Congested Districts Board was not only free from Treasury control, it was free from any control whatever. It was an unpaid Board, and it could spend its money where it pleased and how it pleased, and there was nobody to say it nay. True, its members were appointed by Government, and the Chief Secretary was *ex-officio* a member of the Board; but he had no greater authority given to him than any of his colleagues, and in case of any difference of opinion the decision was that of the majority of the Board. No singe member of the Board could be held responsible for any of its acts; and accordingly, although the vote for the Board came annually before Parliament, of real Parliamentary responsibility there was none.


Such an arrangement was not without its disadvantages even as regards the Congested Districts Board itself: its adoption in the case of the Authority to be created under the Agriculture and Industries Bill would have been open to yet greater objection.


A further point was this. The Congested Districts Board was an unpaid body. An unpaid body consisting of busy men cannot be in perpetual session. The Congested Districts Board, as a matter of fact, met only once a month and in the intervals of its meeting there was no one with full authority to act on its behalf.


The problem, then, in connection with the expenditure of the Endowment Fund was to provide for its administration by an efficient and promptly-acting executive, responsible to Parliament on the one hand, and on the other hand brought by the very nature of its administrative machinery into the closest possible touch with the new local Authorities, as well as with the voluntary organisations which were now springing up all over the country.




---

p.237


In order to satisfy these requirements, the Bill provided that the control of the Endowment Fund should be vested not in a Board attached to the new Department, but in the Department itself; that is to say, in a Minister appointed by the Government of the day. The Chief Secretary was to be the titular head of the Department, but it was not intended that he should intervene in its ordinary administrative business. The real working head was to be the Vice-President, a new Minister with direct responsibility to Parliament. So far as related to certain powers and duties transferred from existing departments of the Irish Government, and similar to the powers and duties of the English Board of Agriculture, the new Minister was to have complete executive authority. But as regards the administration of the Endowment Fund, a different arrangement was proposed—an arrangement without precedent, so far as I know, in any previous legislation in this country.


In order to bring the Department into close touch with local bodies, the Bill attached to it a ‘Council of Agriculture’ and an ‘Agricultural Board.’ One-third of the members of each of these bodies were to be nominated by the Department, and the intention was that in making these nominations due regard should be had to the representation of voluntary organisations. The remaining two-thirds were to be elected in the case of the ‘Council of Agriculture’ by the newly created County Councils, in the case of the ‘Agricultural Board’ by the ‘Council of Agriculture,’ divided for this purpose into four ‘Provincial Committees.’ In addition to the functions of an electoral college thus entrusted to its four provincial committees, the business of the ‘Council of Agriculture’ as a whole was to meet together, at least once a year, for the discussion of questions of general interest in connection with the provisions of the Act; but its powers were only advisory. The ‘Board,’ on the other hand, was more than an advisory body: for it was given a veto on any expenditure of money out of the Agricultural Endowment Fund. The application of the Endowment Fund was thus made



---

p.238



dependent on the *concurrence* of the ‘Agricultural Board’ and of the minister in charge of the Department an entirely novel plan which, although it might clearly result in a deadlock as regards any particular application of money from the fund, has nevertheless, I believe, worked extremely well, and answered the purpose for which it was devised of reconciling ministerial and executive responsibility with a reasonable power of control given to local bodies.


Finally, with a view to stimulating local effort and the spirit of self-help, a provision was inserted in the Bill to which I attached the greatest importance. Power was given to the Council of any county or of any urban district, or to two or more public bodies jointly, to appoint committees composed partly of members of the Local bodies and partly of co-opted persons, for the purpose of carrying out such of the Department's schemes as were of local rather than of general interest. But in such cases, it was laid down that

*the Department shall not, in the absence of any special considerations, apply or approve of the application of money . . . to schemes in respect of which aid is not given out of money provided by local authorities, or from other local sources.’’*


To meet this requirement, the local authorities were given the power of raising a limited rate for the purposes of the Act.


That the Act of 1899 has in the main answered the expectations formed of it by those who were responsible for its introduction there can, I think, be no doubt. The Act itself, as well as the methods of administration adopted in carrying out its provisions, have been the subject of a full inquiry by a Departmental Committee which reported in 1907. Their report must be regarded as on the whole eminently favourable. In one point only has any important change been recommended. The Committee suggest that the post of Vice-President of the Department should not be held by a Minister with a seat in Parliament, nor yet by a



---

p.239



regular civil servant, but should be an office sui generis tenable for five years with power of reappointment. No effect has so far been given to this proposal by legislation.


#### The Unionist Attitude


In this brief sketch of the measures passed by Unionist Governments since 1886 with the object of promoting the material prosperity of Ireland, many points of interest have been necessarily omitted; but what has been said will suffice to show how baseless is the assertion, so frequently urged as an argument for Home Rule, that the Imperial Parliament is incapable of legislating successfully for Irish wants.[59](javascript:footNote('E900031/note059.html')) Nothing could be more futile than to represent Irish problems, and especially the problems of Irish rural life, as so unique that only a Parliament sitting in Dublin can hope to solve them satisfactorily. As a matter of fact, the rural question in Ireland is, in most of its essential features, very similar to the rural question in other 



---

p.240



countries, of which Denmark is perhaps the best example; and the methods which have been successful there are already proving successful here. Single ownership of the land by the cultivator; State aid, encouraging and supplementing co-operation and self-help; co-operation and self-help providing suitable opportunities for the fruitful application of State aid—these are the principles by which Unionist legislation for Ireland has been guided, and they are the principles which any wise legislation must follow, whether it emanate from an Irish or from the Imperial Parliament. Indeed, if there is anything ‘unique’ in the Irish case, it is the deep division of sentiment inherited from the unhappy history of the country and reinforced by those differences of race and creed to which I have already alluded as making two Irelands out of one. But the remedy for this is not to cut Ireland adrift and leave the two sections to fight it out alone, but rather to maintain the existing constitution as the best guarantee that the balance will be held even between them.


**Sir Horace Plunkett** has well summed up the real needs of rural Ireland in the formula ‘better farming, better business, better living.’ He has himself done more than any other single man to bring the desired improvement about. I am not ashamed to acknowledge myself his disciple, and in the measures for which I was responsible during my time in Ireland, I ever kept the practical objects for which he has striven steadily in view. In a speech which I made shortly after taking office I used the phrase ‘killing Home Rule with kindness.’ This phrase has been repeatedly quoted since, as if it had been a formal declaration on the part of the incoming Irish Government that to ‘kill Home Rule’ was the Alpha and the Omega of their policy. What I really said was that we intended to promote measures having for their object an increase in the material prosperity of the country; that if we could thereby kill Home Rule with kindness, so much the better; but that the policy stood on its own merits, irrespective of any ulterior consequences.




---

p.241


In my view that is the only true attitude for a Unionist Government to take up. But in our efforts to improve material conditions and to remove grievances, how small is the encouragement or help that we have received from leaders of the Nationalist Party! ‘Their aim,’ said **Goldwin Smith** long ago, ‘has always been to create a Nationalist feeling, which would end in political separation, not the redress of particular wrongs and grievances, or the introduction of practical improvements.’ I should imagine that there has seldom, if ever, been an important political party which has exhibited so little constructive ability as the Irish Parliamentarians. Their own legislative proposals during the last thirty years have been a negligible quantity; and I think I am justified in saying that there is not one of the great measures passed by Unionist Governments since 1886 which has not been either opposed by the accredited leaders of the Party, or, at best, received with carping and futile, rather than helpful, criticism. I must personally acknowledge— and I do so gladly— that I received useful assistance and valuable criticism from the Messrs. Healy in conducting the Local Government Bill through the House of Commons; and credit must also be given to **Mr. John Redmond** for the part he took in aiding to bring together the Recess Committee. But the Messrs. Healy have always acted independently; and **Mr. John Redmond** was, at the time referred to, leader of only a small minority of the Irish Nationalists. The feeling of the majority, and certainly of the leaders of the majority, was reflected, as we have seen, in the refusal of **Cllr. Justin McCarthy** to have anything to do with the movement.


**Mr. Dillon** in particular has shown a disposition to regard minor political grievances, and even poverty and discontent, as so much fuel wherewith to stoke the lagging engine of Home Rule. Remedial measures short of Home Rule seem to take in his eyes the character of attempts to deprive the Irish Party of so many valuable assets. Nor is this spirit of tacit or open hostility confined to acts of the legislature. Of all the social and economic 



---

p.242



movements in Ireland during the recent years, the spread of agricultural co-operation has been without doubt among the greatest and the most beneficial. It has never found a friend in **Mr. Dillon**. In the movement itself and in the Irish Agricultural Organisation Society, founded expressly to promote it, he can only see a cunning device of the enemy to undermine Nationalism. In this matter **Mr. Dillon**'s attitude is also the official attitude of the Irish Party. Thus **Mr. Redmond** (now reconciled with **Mr. Dillon** and become leader of the main body of Nationalists), in a letter to **Mr. Patrick Ford**, dated October 4, 1904, does not scruple to say of **Sir Horace Plunkett**'s truly patriotic work;—
*I myself, indeed, at one time entertained some belief in the good intentions of **Sir Horace Plunkett** and his friends, but recent events have entirely undeceived me; and **Sir Horace Plunkett**'s recent book, full as it is of undisguised contempt for the Irish race, makes it plain to me that the real object of the movement in question is to undermine the National Party and divert the minds of our people from Home Rule, which is the only thing that can ever lead to a real revival of Irish industries.’’*


Those who have read **Sir H. Plunkett**'s Ireland in the New Century will hardly know which most to wonder at in these words, the extraordinary misdescription of the whole spirit of his book, or the total failure to realise the absolute necessity to Irish farming of a movement which not only has its counterpart all over the Continent of Europe, but has since inspired similar action in the United States, in India, and quite recently in Great Britain as well.


#### Nationalist Hostility


Nationalist hostility to the I.A.O.S. has not been confined to words. When the Agriculture and Technical Instruction Bill was passing through the House of Commons, **Mr. Dillon** endeavoured to secure an undertaking from me that public moneys should not be employed to subsidise the work of the Society. I naturally refused to give any such


---

p.243



undertaking.[60](javascript:footNote('E900031/note060.html')) I had followed the efforts of the Society very closely; I was deeply impressed with the value of the results which it had accomplished; but its field of activity was limited by the narrowness of its resources. In my opinion, a subsidy to the Society from the Endowment Fund of the Department would be a useful and proper application of public money. At the same time I pointed out that if the Agricultural Board, which in the main represented the popularly-elected local authorities, thought differently, they had a power of veto and could use it in this case.


**Sir Horace Plunkett** held the position of Vice-President of the Department of Agriculture and Technical Instruction from 1899 to 1907, and during his tenure of office, as I had always expected and intended, there was close co-operation between the Department and the I.A.O.S. During that period a sum amounting in all to less than £30,000 was paid by the Department to the I.A.O.S., of which more than half was for technical instruction, while the balance represented contributions to the work of co-operative organisation.[61](javascript:footNote('E900031/note061.html'))


When **Sir Horace Plunkett** was replaced by **Mr. T. W. Russell**, the pressure of the Irish Parliamentary Party immediately began to make itself felt. The new vice-president informed the Council of Agriculture that he had made up his mind to withdraw the subsidy, but he undertook to continue a diminishing grant for three years, £3000 for the first year, £2000 for the second year, and £1000 for the third. The I.A.O.S. were not seriously opposed to the gradual withdrawal of the subsidy, the loss of which they hoped to be able to cover in course of time by increased voluntary subscriptions.




---

p.244


The opposition of the Nationalist Party was, however, not yet exhausted. In the Freeman's Journal of January 21, 1908, there appeared a letter from **Mr. John Redmond** enclosing a copy of a letter from **Mr. T. W. Rolleston** to a correspondent at St. Louis. **Mr. Rolleston** accompanied his letter with a copy of a speech by **Sir Horace Plunkett**. In his letter he remarked plainly upon the antagonism displayed by the Irish Nationalists to the co-operative movement. Although **Sir Horace Plunkett** declared that he had nothing whatever to do with the letter, the Irish Parliamentarians professed to find in it abundant proof of an intention to destroy Nationalism. ‘That correspondence,’ said **Mr. T. W. Russell**, [62](javascript:footNote('E900031/note062.html')) ‘compelled me to take action. **Mr. John Redmond** made it imperative upon me by his letter— I mean a public letter to the Press— and as so much was involved, I took the precaution of convening a special meeting of the Agricultural Board.’ The Board decided that the subsidy should be withdrawn at the end of the year 1908.


The last act in this drama of hostility to **Sir Horace Plunkett** and all his works is still in the course of being played. Under the provisions of the Development Fund Act of 1909, the Development Commissioners were empowered to make advances for the organisation of co-operation, either ‘to a Government Department or through a Government Department to a voluntary association not trading for profit.’ During the Report stage of the Development Fund Bill, **Mr. Dillon** tried to get a ruling from the Solicitor-General that the I.A.O.S. would be excluded from receiving grants from the fund, thus repeating the manoeuvre which he had already unsuccessfully attempted in connection with the Agriculture and Technical Instruction (Ireland) Bill of 1899.


In accordance with this provision, the three Agricultural Organisation Societies for England, Scotland, and Ireland, each applied for a grant in aid. The applications were 



---

p.245




referred in due course for report to the Government Departments concerned— that is to say, to the Board of Agriculture and Fisheries for the English and Scottish applications, and to the Department of Agriculture and Technical Instruction for that from the I.A.O.S. The Board of Agriculture and Fisheries reported favourably, and the British and Scottish Organisation Societies are to have their grant. But the I.A.O.S. had to reckon with **Mr. T. W. Russell**, behind whom stood **Mr. Dillon** and the politicians. The report of the Irish Department on the Irish application was adverse, but the Commissioners do not appear to have found the reasons given convincing. Much delay ensued, but, ten months after the application was sent in, the matter was submitted to the Council of Agriculture.


The machinery of the **United Irish League** was brought into action to influence the votes of this body. **Mr. Russell** delivered an impassioned harangue, and eventually the Council was induced to endorse his action by a majority of 47 to 33.


Any grant in aid of agricultural co-operation is to be administered, if **Mr. Russell** has his way, not by the society which has already been instrumental in establishing nearly a thousand co-operative associations in Ireland, and has served as a model on which the corresponding English and Scottish Organisation Societies, now in the enjoyment of a State subsidy, have been founded, but by the Department, which has hitherto had no experience whatever of such work. Moreover, the co-operation promoted by the Department is to be ‘non-competitive,’ by which I suppose is meant, that it is not to affect any existing trading interest. It is safe to say that agricultural co-operation, which has *no* effect upon any trading interest, will have very little effect upon the farmers' interests either. So far as I know, the Development Commissioners have not decided what course to take in this strange situation. It may be that Ireland will lose the grant altogether; but in any case I can well believe that they must hesitate to reverse the 



---

p.246




policy already approved for England and Scotland, and in the face of all experience commit the work of organising agricultural co-operation to a State Department rather than to a voluntary association possessing such a record as the I.A.O.S. has placed to its credit.


If now we ask what are the grounds of the hostility of the Nationalist Party to the most hopeful Irish movement of recent years, the answer appears to be twofold. The first is economic, or purports to be economic: the second is frankly political.


1. Co-operation, it is urged, injures the middleman and the small trader.


To encourage farmers to do well and economically for themselves what is now done indifferently and expensively for them by the middleman, must of course act injuriously on some existing interests. This is not disputed. But the change is absolutely necessary for the regeneration of rural Ireland, and this objection cannot be allowed to stand in the way. Looked at in its broader and more enduring aspects, co-operation is bound to stimulate and improve general trade by increasing the spending power of the farmers. The Chambers of Commerce of Dublin and Belfast have not been slow to perceive this, and have warmly endorsed the Society's application for a grant from the Development Commissioners.


2. The political objection to the movement, so far as it takes the definite form of charging the I.A.O.S. with being a propagandist body aiming under the mask of economic reform at the covert spread of Unionist opinions, will not stand a moment's examination. There is not a particle of evidence in support of such a charge, and the presumption against it is overwhelming. To mix political propagandist with organisation would be the certain ruin of the movement. The Committee of the I.A.O.S. consists of men of all shades of political faith. These men could never have joined hands except on the basis that politics should be rigidly excluded from the work of the Society. The members of the co-operative societies founded by the



---

p.247




I.A.O.S. number nearly 100,000. Probably at least three fourths of these are Nationalists.


In order, however, that all doubt on the subject might be finally removed, the I.A.O.S. issued a circular to all its societies, in which the following question was directly put:—
*Has the I.A.O.S., as a body, or the Committee acting for it, done, in your opinion, any act in the interest of any political party, or any act calculated to offend the political principles of any section of your members?’’*


The answers received have been published and form very interesting reading. Not a single society, of the many hundreds that have replied from all parts of Ireland, has been found to assert that politics have ever been mentioned by the agents of the parent association.


The hostility of the politicians to the co-operative movement rests, it is safe to surmise, upon some other foundation than these flimsy charges against the I.A.O.S.


In itself the movement is vital to the prosperity of rural Ireland. The disfavour shown to it arises from apprehensions respecting its *indirect* bearing upon the great issue between Unionism and Nationalism. Home Rulers who oppose the co-operative movement find themselves in this dilemma: either they hold that nothing in the way of material improvement could affect the demand for Home Rule, or else they are really afraid lest ‘better farming, better business, and better living’ should weaken the attractions of their own political nostrum. In the former case, they are left without a shadow of justification for their attitude towards the I.A.O.S.; in the latter, they tacitly admit that the interests of the farming classes must suffer in order that the cause of Home Rule may be promoted.


Unionists are in no such difficulty. Our policy is clear and consistent. Improvement in the social and economic condition of the people must be our first object. It is an end to be pursued for its own sake, whatever the indirect consequences may be. But the indirect consequences need 



---

p.248




cause us no anxiety. Increased material prosperity, and the contentment which inevitably accompanies it, whatever their other effects may be, are not likely to strengthen the demand for constitutional changes. Successful resistance to Home Rule at the present crisis may well mean the saving of the Union for good and all.




---

p.249


### The Completion of Land Purchase

###  By the Right Hon. **George Wyndham, M.P.**


The case for resisting all attempts at impairing the Union between Great Britain and Ireland can be made unimpeachable without reference to the Irish Land Question. It would be our duty to defend the Union as a bulwark of national safety, an instalment of Imperial consolidation, and a protection to the freedom of minorities in Ireland, even if it could be shown that agriculture, the chief industry of Ireland, had little to gain under the Union and nothing to lose under Home Rule. Fortunately, this cannot be alleged except by those who shut their eyes to the results of State-aided Land Purchase in Ireland, and refuse to consider the consequences of tampering with the mainspring of that beneficent operation: I mean the credit of a joint exchequer under one Parliament for both countries. ‘England's Case against Home Rule’ coincides with Ireland's need for retaining the prosperity that has come to her, after long waiting, under, and because of, the Union. It is, therefore, fitting that a place should be found in this book for a brief account of what Irish agriculture may hope from the Union and must fear from Home Rule.


The history of Irish Agriculture until recent years differed from the history of English Agriculture at many points, and always to the marked disadvantage of Ireland. Dynastic and religious controversies which—if we except the suppression of monasteries and the exile of a few Jacobites— left English countrysides untouched, in Ireland carried with them the confiscation of vast territories and the desolating influence of Penal Laws. Changes in economic theory



---

p.250




contributed even more sharply to the decay of Irish enterprise. When England favoured Protection Irish industry was handicapped out of manufactures. When England adopted Free Trade Irish agriculture, on which the hopes of Ireland had perforce been fixed, suffered in a greater degree. The doctrine of laisser faire wrought little but wrong when applied by absentee buyers of bankrupt estates to tracts hardly susceptible of development by capital, amid a peasantry wedded to continuity of tenure, and justified in that tradition by the fact that they and their forbears had executed nearly all the improvements on their holdings. Most of the nation were restricted to agriculture under conditions that spelt failure, and imposed exile as the penalty for failure, since other avenues to competence were closed. The climax of misfortune was reached a generation after the triumph of Free Trade. Ireland, being almost wholly an agricultural country, suffered as a whole, whereas England, an industrial country, suffered only in districts from the collapse of agricultural prices in 1879. That catastrophe in rural life precipitated **Mr. Gladstone**'s Land Law Act (Ireland), 1881. Being precluded by his political tenets from protecting Irish agriculture against foreign competition, or assisting it with the resources of the State, **Mr. Gladstone** aimed at alleviating the distress due to the decadence of a national industry by defining with meticulous nicety the respective shares which the two parties engaged in agriculture—landlord and tenant—were to derive from its dwindling returns. He believed that the proportion of diminishing profits due to the landlord, because of the inherent capabilities of his property, and to the tenant because of his own and his predecessors' exertions, could be thoroughly determined by a few leading cases in the Land Court; and, further, that landlords and tenants throughout Ireland would conform to such guidance as these decisions might afford. In this anticipation he ignored the vital function of agriculture in Irish life, and the effect which the growing stringency of agricultural conditions would have on a population that loved the land and rejoiced in litigation.



---

p.251




He created dual-ownership throughout Ireland, and this led, as **Lord Dufferin** and other far-seeing statesmen had foretold, to the land being starved of both capital and industry. Irish agriculture was brought to the brink of ruin. The misery of those involved in that pass was exploited to engineer an attack on the fabric of social order, and the lawlessness so engendered was adduced as an argument for dissolving the Union under which such tragedies could occur.


The leaders of the Conservative Party, when confronted with this situation, determined that their duty, in accordance with the spirit of the Act of Union, demanded some use of the resources of a joint exchequer for ministration to the peculiar needs of Ireland. They decided that the credit of the State should be employed to effect the abolition of dual-ownership by converting the occupiers of Irish farms into owners of the soil. Let it be granted that this policy had been advocated by **John Bright** and enshrined in the Land Law Acts of 1870 and 1881. It must be added that these pious intentions remained a ‘dead letter’ until adequate machinery for giving them effect was provided by the Land Purchase Acts, commonly called the Ashbourne Acts, of 1885 and 1889. The method pursued was as follows. Any individual landlord could agree with any individual tenant on the price which he would accept for the extinction of his interest in that tenant's holding. The State facilitated the transaction by advancing that amount to the landlord in cash whenever the holding offered sufficient security, and accepting from the tenant an undertaking to pay an instalment of £4 a year for every £100 advanced over a period of forty-nine years. The instalment comprised £3 for interest, 2s. 6d. for expenses, and 17s. 6d. for sinking fund. The loan from the exchequer was secured against individual failures to pay by the realisable value of the holdings.


The salient features in this procedure were that the landlord received cash and that the tenant paid interest at the then existing rate on Consols, viz. 3 per cent. Both these



---

p.252




features are important. A payment in cash, or its equivalent, is preferable for such transactions to a payment in stock, with a fluctuating value, because, if the stock appreciates the landlord gets more than he bargained for, and this, by arousing the suspicions of other would-be tenant-purchasers, produces a disinclination on their part to buy. Again, if the stock depreciates, the landlord cannot carry out contemplated redemptions of mortgages on his property, and this produces a disinclination on the part of other landlords to sell. In the second place it is difficult to persuade Irish tenants that the State is assisting them if they, the poor, are asked to pay higher interest for the State's credit than the State pays for the credit of the rich. The chief defect in this procedure lay in its restriction to separate bargains in respect of single holdings. It made a patchwork, whereas the untoward results of the historic and economic causes on which I have touched demanded the wholesale treatment of convenient areas.


Under these Acts, in the course of six years, more than 27,000 tenants became owners by virtue of advances which amounted to over £10,000,000. The largest number of applications for purchase in any one year was 6,195 for £2,271,569 in 1887, and the average price for all the holdings bought under these Acts was £396.


When the sums provided by the Ashbourne Acts were exhausted, **Mr. Arthur Balfour** carried the Act of 1891, subsequently amended by the Act of 1896. Under these Acts the landlord was paid in stock instead of cash. The tenant still paid an instalment of £4. which was, ultimately divided into £1 5s. for sinking fund and £3 15s. for interest. This large sinking fund, £1 5s. instead of 17s. 6d., was retained after interest had been reduced to the rate on Consols 2 3/4 per *cent*, chiefly to avoid a discrepancy in the total of annual instalments as between purchasers under the Act of 1891 and purchasers under the Ashbourne Acts. Difficulties were feared if the earlier purchasers were to pay £4 and the later purchasers only £3 15s. for each £100 advanced, so the spare five shillings was put in the sinking fund. This 



---

p.253




speculative difficulty was afterwards discounted in order to deal with one of a more practical character. Under **Mr. Gladstone**'s Land Law Act of 1881, which dealt with rent-fixing, statutory rents were revised every fifteen years, and the second term rents, beginning in 1896, seemed certain to reveal considerable reductions on the rents payable during the first period. It was felt that the security for the earlier advances would be endangered if rents throughout Ireland fell below the level of the purchase-instalments, and that purchase would be retarded if the purchaser did not obtain immediate relief by agreeing to buy. To meet this practical difficulty **Mr. Gerald Balfour**, in 1896, permitted the purchaser to write off the amount repaid by sinking fund during the first and two successive periods of ten years. These ‘decadal reductions’ were optional. If the purchaser forewent them he paid £4 per £100, and extinguished his debt in 42 1/2 years. If he availed himself of them he paid £3 8s. 7d. per £100 after the first ten years, and continued to pay, with two further reductions in prospect, till the debt was extinguished in a period undefined, but estimated at about 72 1/2 years. But this privilege was made retrospective, so that purchasers under the Ashbourne Acts could also reduce their instalments of £4 to £3 11s. 10d.


The salient features in the procedure of the Acts of 1891 and 1896 were that, (1) the landlord was paid in stock instead of cash. But owing to the rise in the value of gilt-edged securities, Irish Land Stock, with a face value of £100, became at one moment worth as much as £114 ; the purchaser's interest was at two and three quarters per *cent* i.e. the existing rate on Consols; but (3) his instalment, prospectively fined down by decadal reductions, enabled him to offer an acceptable price and yet pay far less to the State, by way of instalment, after purchase than was due to his landlord, by way of rent, before purchase. The operation of purchase was still confined, almost wholly, to single bargains. But in **Mr. Arthur Balfour**'s Act of 1891 a new departure was authorised which, after development in **Mr. Gerald Balfour**'s Act of 1896, has led to important and far-reaching consequences.




---

p.254


The Congested Districts Board was established to deal with scheduled areas in the West of Ireland that comprised a large number of holdings at once too limited in area, and too poor in soil, for any one of them to support a family by farming or to afford security to the State, under existing facilities for purchase, in the event of the occupier wishing to become the owner. A select committee of the House of Commons, so long ago as in 1878 (No. 249, pp. 4 and 5), when **Disraeli** was Prime Minister, had recommended that a properly constituted body should be empowered to purchase, not single farms, but whole estates, and to re-sell them after amalgamating, enlarging, and re-distributing what are now called ‘uneconomic’ holdings. Provisions to this end had been inserted in earlier Acts, but, in the absence of administrative machinery and financial resources they remained abortive. It had for long been evident that the small, impoverished holdings, which had supported a dense population before the famine, stood in need of fundamental remodelling if they were to support even a largely reduced population. The efforts made by wealthy Irish landlords in this direction were arrested by the Land Law Act of 1870 and rendered impossible by the Land Law Act of 1881. With the Purchase Acts of 1891 and 1896 a beginning was made.


Another feature must be noted. In addition to the value of any one holding, as a security against individual failure, a further security was provided against the risk of a combined refusal to repay. The Exchequer was empowered to retain grants due for various purposes in Ireland and to recoup itself in proportion to the defalcation in any county. It should be added that individual failures have been rare to the point of insignificance, and that no combined refusal has been attempted, or advocated, even during periods of agricultural unrest.


Under the Acts of 1891 and 1896 in the course of just over twelve years more than 44,000 tenants became owners by virtue of advances which amounted to over £13,000,000. Here we must note that the success of these Acts coincided



---

p.255




with, and depended on, a rise in the price of gilt-edged securities. The number of applications rose from 1503 in the year ending March 31, 1896, to 6911 in the year ending March 31, 1900. But, with the fall in the price of stock land purchase showed signs of coming to a standstill. By 1902 it was evident that new legislation was needed, and in the next year the Irish Land Act of 1903 was carried.


The Irish Land Act of 1903 was not, as some suggest, a short cut to the millennium, evolved on the spur of the moment, and translated into fantastic finance. It had two bases, the one practical, the other moral. In the first place, it was founded on the ripe experience garnered during eighteen years from the operation of preceding purchase Acts. In the second place, it was founded on the historic agreement spontaneously arrived at in 1902 by accredited representatives of Irish landlords and tenants. They resolved that dual ownership ought to be abolished throughout Ireland, and that this primary policy should be accompanied by effective remedies for the uneconomic conditions prevalent in the West, but existing elsewhere, though sporadically, to a limited extent. This agreement, in itself unprecedented, was rendered the more remarkable by the fact that the signatories assumed the responsibility of telling the Government how the first object could be achieved. They advised that landlords could not be expected to sell, as a class, unless the price paid to them in cash would yield from sound securities 90 per *cent* of their income in terms of a rent that had been twice revised under the Land Law Act of 1881; and that tenants could not be expected to buy, as a class, unless their instalments due to the Treasury after purchase were from 15 per *cent* to 25 per *cent* less than such rents so revised. They invited the Government to give effect to that agreement. The Government accepted and, in the Act of 1903, tendered the costly but, under the circumstances, not extravagant imprimatur of the Treasury on a political treaty thence forward to be binding on all three contracting parties: landlords, tenants, and the State. The Nationalist members, as



---

p.256




spokesmen for the tenants, and the representatives of the landlords, subscribed to the provisions offered, and the reports of the Estates Commissioners prove that these have been fulfilled so exactly that, in the case of second term rents, landlords and tenants have obtained average incomes and reductions that differ only by a decimal from the mean advocated at the Conference.


The objects of the Irish Land Act were, in conformity with the conclusions of the Conference, to abolish dual ownership rapidly and, at the same time, to deal systematically with ‘agricultural slums.’ Its salient features fall under four heads.


A. *State assistance to voluntary bargaining.* For this purpose it was provided that (1) cash payments should be resumed to the landlords; (2) that the tenants' instalments should be £3 5s. for each £100 advanced, divided into £2 15s. (2 per *cent*) for interest and 10 s. for sinking fund. This was not, as the able and well-informed special correspondent of the Times suggests (February 9, 1912) a sudden departure from an instalment of £4. ‘Decadal reductions’ under the Act of 1896 had, as I have said, diminished the instalments of purchasers under the Act of 1891 to £3 8s. 7d. after ten years with further prospective diminutions, and subjected the instalments of purchasers under earlier Acts to a similar process. A wholesale expansion of purchase was impossible unless would-be purchasers were offered terms comparable to those accorded to their predecessors. For this reason the tenantry of Ireland were offered repayment at £3 5s. per £100 for a period of about 62 years, in lieu, under the Act of 1896, of repayment at £3 8S. 9d., with further reductions, for about 72 1/2 years, and their representatives accepted the offer. They would certainly have refused, and rightly, the offer substituted by **Mr. Birrell** in the Act of 1909, Viz. an instalment of £3 10s. with the same sinking fund—10s.—and interest increased to £3. The third feature to be noted under this head is, that the terms agreed to by representatives of landlords and tenants at the conference could



---

p.257




not be ratified unless the State added some help by way of cash to the assistance of its credit. It was agreed by all parties that £12,000,000 should be available to bridge the gap, at the rate of 12 per *cent* on the amount advanced, with the right to revise that rate after five years, but *only for the purpose of extending the bonus*— it was called—*to all future transactions*. It was an integral part of a solemn covenant that the bonus should not be diverted to any object other than the abolition of dual ownership and the remedy of ‘congestion.’


B. *The substitution of speedy purchase for dilatory litigation*. To all members of the Conference of 1902 and of the House of Commons in 1903, with, I believe, the exception of **Mr. Dillon**, who was away in America while the Conference sat, it was evident that, if dual ownership was to be abolished, our choice was confined to two courses. We could, on the one hand, pursue, under the guise of purchase, the metaphysical and costly distinctions between landlord-right and tenant-right, which **Mr. Gladstone** had established under the guise of rent-fixing, or else, as the only alternative, we had ‘to cut the cackle’ and get to business. Under this head the House of Commons—**Mr. Dillon** inseminating dissent—decided in so far as landlords and tenants were concerned, two things: (1) It was agreed that where the tenant-purchaser's instalment, after purchase, was substantially less than his statutory rent revised at great cost—over £140,000 a year for Land Courts—then, in those cases the State needed not to inquire at further cost and delay into either its own security in the holding, or the metaphysical distinction between value due to the landlord's ownership of the soil and value due to the tenant's improvement of the soil. This close approximation to unanimity will not surprise those who grasp that every landlord and tenant was to make a voluntary bargain on precisely those terms which the representatives of their classes had combined to obtain from the State. The alternative method of delay and litigation had been further discounted, for everybody except **Mr. Dillon**, by the fact



---

p.258




that in the classic case—*Adams v. Dunscath*—tried out in accordance with **Mr. Gladstone**'s panacea, Adams, after repeated lawsuits, improved his financial position by an infinitesimal sum per annum without becoming an owner of his farm. It was also agreed that the Estates Commissioners appointed to administer the Act, should be administrative officials under the Government, and not amateur judges. This was essential, not only to substitute cheap speed for costly delay, but also to ensure that the benefits offered by the State should not be absorbed, say, in the rich province of Leinster to the detriment of the poorer province of Connaught, or—for who knows what may happen in Ireland?—absorbed in the Home Rule province of Connaught to the detriment of the Unionist province of Ulster.


C. *Dealing with Estates as a whole instead of with single holdings*. This process, till then applied tentatively in the congested districts of the West, became the general method throughout Ireland, and was assisted by the provision of working capital for carrying out necessary amalgamations and improvements before resale.


D. *Increase in the borrowing power and funds of the Congested Districts Board*, for the purpose of dealing systematically with ‘agricultural slums.’


The features of the Irish Land Act (1903), founded, as they were, on experience and the consent of all parties concerned, became widely popular in Ireland. But, by **Mr. Birrell**'s Act of 1909, they were all distorted or destroyed. A solemn treaty, framed in the interest of Ireland, was torn up to deck with its tatters the triumph of **Mr. Dillon**'s unholy alliance with the British Treasury. The effect of this betrayal on the prospects of Irish agriculture will appear from a recital of the changes made by **Mr. Birrell**'s Act, followed by a comparison of the results obtained under the two Acts. From that comparison I shall proceed to an examination of the reasons alleged for the breach of faith, and a statement of the Unionist party's pledge to continue their policy of 1903. I shall



---

p.259



then conclude by inviting all who care for Ireland to weigh the prospects of Irish Agriculture under the Union against its prospects under Home Rule.


*Changes made by the Act of 1909*.—(1) Instead of cash payments landlords are to receive stock at three per *cent* issued on a falling market, and this stock cannot appreciate because, owing to the embarrassment of Irish estates, about half of each issue must be thrown back on the market for the redemption of mortgages; a result fatal to land purchase and detrimental to the credit of the State. (2) Instead of paying £3 2s. per £100, tenants are to pay £3 10s. without any reduction in the period of repayment. The sinking fund remains at 10s. and the interest £3 is, for the first time since land purchase was attempted, placed at a higher rate than in the preceding Purchase Act, whilst the whole instalment of £3 10s. is raised, not only above the rate of the Act of 1903, but also above the rates, diminished by decadal reductions, of purchasers under still earlier Acts. This again, in view of these reductions and of periodic revisions of *rent* under the Land Law Act of 1881, is fatal to purchase. (3) The bonus of £12,000,000—on the application of which all parties agreed in 1903—was diverted from the unanimous policy of that year and brought in aid of **Mr. Dillon**'s hobby, which all parties then rejected. **Mr. Dillon** is at liberty to rejoice over the ruin of one landlord more than over the salvation of 99,000 tenants. The laws of lunacy do not, and ought not to, touch him. But there is no reason why taxpayers should minister to his peculiar pleasure, with the result of postponing indefinitely any settlement of the Irish land question. (4) By reverting to inspection for security delay is substituted for speed, and speed is necessary in the conclusion of bargains that are themselves the result of prolonged negotiations; the more so when, as now, owing to the substitution of stock for cash, the seller cannot know what his bargain will turn out to be; and the buyer, owing to the block in agreements under the Act of 1903, cannot know when his bargain will take effect. In most cases



---

p.260




it will not do so for from six to eight years, which must be added to the period of repayment, although his instalment has been increased. (5) The reversion to attempts at defining the metaphysical rights of the landlords and tenants revives the social poison of litigation of which, in 1903, every one but **Mr. Dillon** was weary. (6) The revival of litigation in respect of single holdings defeats the policy of dealing with convenient areas. (7) By transforming the Estates Commissioners, much I imagine to their disgust, from administrative officers into amateur judges, a further premium is put on litigation and delay, whilst the interests of one province as against the interests of another, are left without protection from the State. (8) Although more than half the holdings of Ireland are valued at less than £10 a year, a presumption is created that all holdings below that value are to be deemed ‘uneconomic’. The whole of Connaught with the counties of Donegal and Kerry and part of County Cork are branded as ‘congested,’ and the Board, charged with conducting purchase in that area, is swollen to unmanageable size, whilst three commissioners are held sufficient for the rest of Ireland, which is twice as large.


To these eight changes, all inimical, and, as I believe, fatal to the abolition of dual ownership, two have been added of a more insidious effect. Compulsion has been adopted. This of itself checks voluntary purchase. It kills it when, as under this Act, compulsory purchases are to be paid for in cash and voluntary purchases in depreciated stock. Finally, the Act contemplates diverting the resources, applied under the treaty of 1903 to the abolition of dual ownership and the remedy of congestion, to a new purpose, for which Ireland can make no special claim. I mean the creation, over all Ireland, of new tenancies, to be sold to new men, who have never suffered from dual ownership or uneconomic conditions, and may be presumed to be ignorant of farming. This new policy amounts to a repeal of the policy sanctioned by all, viz. of giving special State aid to meet the peculiar needs of Ireland.




---

p.261


*A comparison of the results obtained under the Acts of 1903 and 1909.*—In order to gauge the respective efficacy of these two Acts for the purpose of abolishing dual ownership, it is necessary to distinguish between applications for purchase, and advances actually made in respect of completed transactions. The applications exhibit the comparative popularity and convenience of the two Acts. The advances exhibit only the readiness of the Government to proceed with purchase. They pertain to the financial, rather than the political, aspect of the problem, and may be examined later together with the reasons alleged for the delay of its solution. The fact of the delay appears from the following figures:—


Under the Irish Land Act (1903) the number of purchase agreements lodged in respect of direct sales by landlords to tenants was 217,299 in the course of less than six years from November 1, 1903, to September 15, 1909. To these should be added proposed purchasers in other categories, viz. in respect of estates sold to the Land Commission for subsequent re-sale, or to the Congested Districts Board, or in the Court of the Land Judge, or in respect of offers to evicted tenants. These bring the total of potential purchasers up to 248,109. Under the Act of 1909, in two years from December 3, 1909, to December 1, 1911, the number of applications in respect of direct sales stands at 8,992. In the other categories the number of potential purchasers amounted to 373 up to March 31, 1911. Since then tentative negotiations have been essayed, under the threat of compulsion and the menace of Home Rule, which suggest a far larger figure. But these transactions— to which I shall return— are of an eminently dubious character. We are on safe ground if we compare the number of tenants who were ready under the two Acts to acquire their holdings. After discounting whatever may be claimed on the score that the operation of the Act of 1903 was expedited by the fear of its destruction, a comparison of 217,299 would-be purchasers in six years with 8,992 in two years demonstrates that the abolition of dual ownership has been thrown back



---

p.262



to the conditions which called for the Treaty of 1903. Furthermore, it is proper to discount, in turn, even the meagre total of 8,992. For it includes the remainders of estates, other parts of which had been sold under the Act of 1903 and the spurt of applications expedited, in this case, by the revolution of last August. To the over-sanguine and the over-timid this seemed to foreshadow the rapid passage of Home Rule, and, bad as are the terms of the Act of 1909, they are estimated to be better than any obtainable after the Union has been thrown on the scrap-heap of the Constitution. One other comparison may be noted. It was part of the Treaty of 1903 that landlords should be encouraged to remain in their native land by assistance in the repurchase of their demesnes—that is, homes—after selling their properties. Under the Act of 1903 the advances on resale to owners sanctioned by the Land Commission numbered 205. Under the Act of 1909 they number two.


It will readily be inferred, even by those unacquainted with Ireland, that a process for healing ancient wounds has been turned into a process for exasperating future conflicts. A blister has been substituted for a poultice on the sores of centuries. Existing agreements are blocked. Future agreements—for this is their appropriate, if cynical—designation, are relegated to a future which few can foresee. Landlords who have contracted to sell are threatened with bankruptcy by the foreclosure of mortgages. Tenants who have contracted to buy see their hopes deferred with sick hearts. Whilst to owners and occupiers who have not completed their bargains ‘no hope comes at all.’ The newly won prosperity of Ireland is doomed because the Nationalist party and British Government have not kept faith; and with prosperity peace is departing. The environment that breeds agrarian disorder and crime has been restored, and agitators, in expectation of Home Rule, are already at ‘their dirty work again.’ A new plan of campaign menaces the peace of Ireland in those districts whose past records are most darkly stained.


*Examination of the reasons alleged for tearing up the



---

p.263




Treaty of 1903*.—The Government defended their reversal of the policy of 1903, and departure from their pledges to carry out that policy, by making two assertions. They asserted (1) that the size of the problem, which all parties undertook to solve, would exceed by far the speculative estimate put forward in 1903; (2) that the credit of the British Exchequer, which they have depressed, would prove unequal to the burden foreshadowed by the new dimensions, which they have assigned. (1) *Size of the problem*. The first assertion, that much nearer £200,000,000 than £100,000,000 must be borrowed in order to complete purchase, is based on two assumptions explicitly stated in the Return presented to Parliament (Cd. 4412 of 1908) as follows: 
*It will be observed that the purchase money of the agricultural land not yet brought before the Commissioners for sale under the Land Purchase Acts has been estimated *on the assumption that it will be all sold and that it will be sold on an average at the price for which lands had been sold up to 30th April last, under the Irish Land Act* (1903).’’*

 The assumptions on which the Government proceeded are not, therefore, in doubt, but the validity of those assumptions, on which the whole case of the Government depends, is refuted by the ascertained facts of Irish agriculture. The census shows that the number of agricultural holdings in Ireland is about 490,000, including nearly 19 million acres. The whole area of Ireland includes some 21 million acres, apportioned to 3 1/2 million acres under crops, 6 million acres of waste, and 11 1/2 million acres under grass. The Return to which I have referred (Cd. 4412 of 1908) cavils at the figures given in the census on the ground that the 490,000 ‘holdings’ are more accurately 490,000 ‘land-holders,’ since a tenant holding ‘half a dozen farms in the same county is returned as having a single holding.’ But it is right to take ‘holders’ when, as under the Act of 1903, the limit on advances applies to the person who receives them. Again, the Return throws over the census for figures supplied by the Department of Agriculture. But it is wrong to use these figures, for they include holdings not exceeding one acre, of which there are 80,000 in Ireland,



---

p.264




and many more that cannot be described as ‘in the main agricultural or pastoral.’ No special pleading on the part of the Government can alter the fact that the 490,000 holdings given by the census include all the lands under crops and grass and two-thirds of the waste. They embrace 19 million acres, and more than cover the ground. For the purpose of an estimate it is an outside figure, the more so since, in respect of grass lands the value of a single farm may exceed the limit of any one advance, and it is not uncommon for a large grazier to rent many grass farms. If the Government, by conferring a judicial status on the Estate Commissioners, surrendered their control over the amounts of single advances; and again, if the Government, at the dictation of **Mr. Dillon**, embarked on a new policy of creating tenancies in grass land and selling them to new men, they are debarred from increasing the estimate to cover their own misfeasance. In tendering the speculative estimate of 1903, it was clearly laid down that the amount of one advance was only to be increased in rare cases, and the sub-division of permanent pasture was denounced as a ‘form of economic insanity.’ It was also explained that deductions must be made from the 490,000 holdings in respect of small town plots, accommodation plots, and market gardens; nor are these insignificant, for to the 80,000 holdings not exceeding one acre we must add 62,000 of from 1 to 5 acres. In the face of these facts, the assumption that ‘all agricultural land’—as defined in the Return—will be sold, is not only unsound but preposterous.
The second assumption, that the average price of future transactions will equal that of past transactions is opposed to the presumption that better, and therefore dearer farms, came onto the market before worse and therefore cheaper farms. I am not referring to the number of years' purchase offered, a point on which I have never expressed an opinion but to the value of the property which passes. It is with farms as with oranges, the good ones go first. The pertinence of this maxim to land purchase is proved by the reports of the Estates Commissioners. These contradict the Government's



---

p.265




second assumption, for they exhibit a steady and continuous decline in the average of advances that have been made. The average amount of advances under the Act of 1903 to March 31, 1908, was in round numbers 361. On some such figures the second assumption rests. I ventured at the time to assert that the average in the future would not exceed £300. This estimate has been confirmed, for the average advances from March 31, 1908, to September 15, 1909—when the Act ceased to operate— was £287. A further reduction may be confidently expected, since the progress of purchase in the richer provinces has by far exceeded its progress in Connaught. In Leinster over 53,000 agreements have been lodged at an average price of over £481; in Munster over 58,000 at an average of over £420; in Ulster over 84,000 at an average of over £226; whilst in Connaught only some 26,000 at an average of just under £200.


The reasons alleged in defence of the Act of 1909 failed to justify, or even to explain, the changes it imposed. An explanation must be sought in the real reasons, and they are not far to seek. The first was that the old methods of litigation and delay, abjured by all parties in 1903, were substituted for the new methods of speed and ease, because **Mr. Dillon** so willed it; and the second, that the policy of abolishing dual ownership, to which **Mr. Redmond** stood pledged, had to be ousted, again at **Mr. Dillon**'s dictation, to make way for the folly of creating new tenancies, of symmetrical size, throughout all Ireland. The Treaty was torn up because **Mr. Dillon**, acting as deputy for **Mr. Birrell** (whose main argument for Home Rule is that it bores him to be Chief Secretary), ordered **Mr. Redmond** to eat his words.


From this examination of the reasons for destroying the Act of 1903, the true size and nature of the financial problem emerges. From the total of some 490,000 holdings substantial reductions must be made in respect of waste lands, grasslands, and accommodation plots, and, again, in view of the limitation on the amount that may be advanced to one person.



---

p.266




We ought probably to deduct 20 per *cent*, but if, to be on the safe side, we deduct only 15 per *cent*, 416,000 are left. These, however, include some 80,000 sold before the Act of 1903, or under the Land Commissioners as distinct from the Estates Commissioners. In respect of the 336,500 remaining, 257,474 agreements have been lodged under all categories in the Acts of 1903 and 1909. Indeed, a larger number have been lodged, for in most cases our information is only to March 31, 1911, leaving less than 79,000 holdings that may still come into the market. This is an outside figure, provided always that the policy of 1903 be adhered to, viz. that advances are made to *occupiers* and not to new men, except as under the Act of that year (sect. 2 (1) *b* and *d*, and sect. 75) in rare cases, rigidly defined, of the sons of tenants and of evicted tenants.


If the average price remains at the figure for the period March 31, 1908, to September 15, 1909—viz. £287—a further sum of £22,673,000 may be required in excess of £84,099,818 already required under the Acts of 1903 and 1909; making £106,772,818. This total includes nearly £1,000,000 for re-sales to owners and some provision for evicted tenants. Under these heads it will not expand in a greater relative degree. It includes, also, purchase of whole estates and of untenanted land by the Estates Commissioners and Congested Districts Board, and these may involve larger sums than were originally contemplated. I promised to return to that point, and will now do so. Since the Return under these heads up to March 31, 1911, tentative negotiations have been made for the purchase of a number of estates and for supplying more evicted tenants with holdings. But this does not increase the money size of the problem by much, because many of these estates—if sold to the new Congested Districts Boards—are subtracted from business that would have been done by the Estates Commissioners; again, it is, as we know, impossible to spend much money, or move many migrants, or even enlarge many holdings, in one year. If the new Congested Districts Board attempts to handle some millions' worth of land in a



---

p.267



hurry, one of two things must happen, either their work will be indefinitely delayed, or else they will sell off ‘uneconomic’ holdings without amending their defects. The business will not cost more. It will only be scamped, or shirked. I doubt if the additions, which do not conflict with the policy of 1903, will increase the amount to be borrowed in the market, though they may increase the sums needed for working capital. Let us add for these expansions, which are strictly limited by physical impediments, £2,000,000 or even twice that amount. It still remains obvious that, even after expansions, good, bad, or indifferent, of the policy of 1903, the total sum to be borrowed cannot exceed from £110,000,000 to £113,000,000, as the outside figure that need be contemplated, provided we refrain from the ‘economic insanity’ of distributing eleven million acres of permanent pasture among shopkeepers and ‘Gombeen’ men. This figure of £113,000,000, indeed, exceeds what may reasonably be expected. The average of advances fell from £426 on the earliest agreements, to £361 on all agreements to March 31, 1908, and to £287 on agreements between that date and September 15, 1909. We may count on a continuation of that fall until the average approaches £200, the price for Connaught, where purchase has proceeded most slowly. But let the total stand at £113,000,000. That sum neither warrants the breach of faith of which the Government and the Nationalist party have been guilty, nor does it present an insoluble problem to the resources of a united Exchequer. £41,097,939 has already been borrowed in the market, and advanced, in less than eight years.


The policy to which the leaders of the Unionist party stand pledged may now be re-stated in the words which I was authorised to use by **Mr. Arthur Balfour** and **Lord Lansdowne** after consultation with their colleagues. Speaking on July 9, 1909, I said—

*Our attitude is, that it is necessary to deal effectively with the block of pending agreements, but in dealing with that block it is not necessary to prejudice the interests either of the landlords or tenants,



---

p.268




who may come to terms on some future agreements. We think that the spirit of the Act of 1903 must be observed in the case of pending agreements, but it must not be departed from in the case of future agreements.’’*

— Hansard. , 1909, vol. vii. No. 93, cols. 1542, 1543.


**Mr. Bonar Law** confirms this pledge. He instructs me to say that the Unionist party will resume the land policy of 1903, and pursue the same objects by the best methods until all have been fully and expeditiously achieved.


The prospects of Irish agriculture under the Union include a return to the land policy of 1903, with its fair hopes of reconciliation between classes and creeds, and its accomplished result of abounding prosperity. What are the prospects of Irish agriculture under Home Rule? Of what Home Rule may mean in this, as in other respects, we have been told so little that we are driven to consider its effect on Irish agriculture in the light of two contingencies. It may be that the extremists, with whom **Mr. Dillon** invariably ranges himself, as a preliminary to dragging **Mr. Redmond** after him, will have their way. In that case Ireland will exact complete fiscal autonomy from a Government which invariably surrenders to **Mr. Dillon**'s puppet. Should this occur, land purchase will cease abruptly in the absence of credit for borrowing the sums it requires. Take the other alternative, hazily outlined by **Mr. Winston Churchill** at Belfast. We glean from his pronouncement that the Government intend—if they can—to refuse fiscal autonomy, and to preserve control over land purchase. Can it be expected that this attempt, even if it succeeds, will produce better results for land purchase than the pitiable failure of the Act of 1909? Is it not certain that less money will be raised in England, for Ireland, after Home Rule? And if raised in driblets, on what will it be spent? Obviously, not on the policy of 1903, but on the policy substituted by **Mr. Dillon** in 1909. It will be spent on expelling landlords and graziers to make room for subscribers to the propaganda of extremists. We must judge of what will happen to agriculture after Home Rule by



---

p.269




what has happened since the Treaty of 1903 was repudiated. Nor must we forget that **Mr. Dillon**'s destructive activity has ranged beyond land purchase. That policy could have achieved little but for the untiring and generous patriotism of **Sir Horace Plunkett**. He established the Department of Agriculture and converted his countrymen to co-operation, in the absence of which no system of small ownership can succeed. He, too, based his efforts on a conference—the Recess Committee. How has he been met? **Mr. Redmond**, a member of that Committee, as later of the Land Conference, has, here again, succumbed to **Mr. Dillon**, who seeks to defeat co-operation between farmers, in the interests of his disciples; whilst **Mr. Russell**, with the hectic zeal of a pervert, has refused Ireland's share of the new Development Grant in order to spite **Sir Horace Plunkett**.


Such signs of the times are read in Ireland more quickly than in England, and in several ways. To this man they spell speedy triumph for the form of economic insanity in which he vindictively believes; to that man, the retention of an office won by recanting his opinions. But there are others in the saddest districts of Ireland who must also be taken into account. To the few—for they are few—who thrive by deeds of darkness whenever the Union is attacked, these signs of coming change suggest a more tragic interpretation, from which the fanatic and the place-hunter would recoil—when too late. The blatant publican who strangles a neighbourhood in the toils of usury and illicit drink, and the bestial survivor of half-forgotten murder-rings take note of these signs. The atavism of cruelty returns. Emboldened by **Mr. Birrell**'s bland acquiescence in milder prologues to Home Rule, a new plan of campaign is, even now, being devised, charged with sinister consequences from which all men in 1903 trusted that Ireland would be for ever absolved. The prospects of Irish Agriculture under Home Rule include the return, after a brief chapter of ‘hope, and energy the child of hope,’ to the old cycle of bitterness and listlessness and despair.




---

p.270


A consideration of these alternatives leads to this dilemma. If the Government concede fiscal autonomy Land Purchase ends. If they refuse it, and **Mr. Redmond** accepts a ‘gas-and-water’ Bill, that compromise, so accepted, will receive from **Mr. Dillon** the treatment accorded to the recommendations of the Recess Committee and of the Land Conference. The compromise will be repudiated and the millions already advanced for purchase will be used as a lever to extort complete autonomy. The lever is a powerful one. All depends upon who holds the handle.


It may be said in conclusion that the Unionist policy of Land Purchase vindicates the Union, and that the treatment it has received demonstrates the futility, and the tragedy of granting Home Rule.




---

p.271


### Possible Irish Financial Reforms under the Union

### By **Arthur Warren Samvees, K.C.**


#### The Constitutional Position


The best possible system for Irish financial reform is adherence to the principles of the Act of Union. The constitution, as settled by the Act of Union and the Supplementary Act for the amalgamation of the Exchequer, contemplated that each of the three Kingdoms should contribute by ‘equal taxes’ to the Imperial Exchequer. ‘Equal taxes’ were to be those which would press upon each country equitably in proportion to its comparative ability to bear taxation. These taxes were to be imposed subject to such exemptions and abatements as Scotland and Ireland should from time to time appear to be entitled to. If their circumstances should so require, they should receive special consideration.


All the revenues of England, Scotland and Ireland, wherever and however raised, when paid into the common Exchequer, form one consolidated fund. The Act for the consolidation of the Exchequers directs that there shall be paid out of the common fund ‘indiscriminately’ under the control of Parliament all such moneys as are required at any time and in any place for any of the public services in England, Scotland, Ireland or elsewhere in the Empire.[63](javascript:footNote('E900031/note063.html')) Such payments are to be made without consideration of anything but necessity. They are to be without differentiation on the ground of the locality of the expenditure, or of the relative amount of the contributions to the common



---

p.272



chest of England, Scotland or Ireland. All expenditure is alike ‘common’ whatever its object may be, civil, naval or military or foreign, it is all alike ‘Imperial,’ and all of it is under the constitution ‘indiscriminate.’ The whole United Kingdom forms one domain, and but one area for the purposes of expenditure. As long as the Act of Union lasts no one of the three Kingdoms can be said to be ‘run’ either ‘at a loss’ or ‘at a profit.’ They are all run together as one incorporate body. The common revenue balances the common expenditure, and they bear together one another's burden and the weight of Empire.


#### The Vice-Treasurership of Ireland


The Act for the amalgamation of the Exchequers of Great Britain and Ireland contained provisions for the continued representation of Ireland in fiscal matters at the Exchequer and in Parliament. Power was given to His Majesty by Letters Patent under the Great Seal of Ireland to appoint a Vice-Treasurer of Ireland. The Vice-Treasurer could sit in Parliament, and appointment to the office did not vacate a seat in the House of Commons. This office has been allowed to fall into abeyance. The Exchequer is only represented in Ireland by a Treasury Remembrancer. Most persons who know Ireland would concur in the view that the existing arrangement is not satisfactory, and that it would be of great advantage to Great Britain, as well as to Ireland, to have in Parliament a Minister specially responsible for Irish finance, acting under the Chancellor of the Exchequer. The Vice-Treasurership should be revived and the occupant of it should be a member in touch with Irish opinion, understanding Ireland and her real wants, which are often very different from the demands upon the Exchequer that are most loudly proclaimed. The restoration of the office would facilitate business, and tend to remove many misunderstandings, and prevent many mistakes. personal interviews in Ireland with such a Minister would be worth reams of correspondence, and would save weeks of time Promptitude, economy and efficiency would be secured.




---

p.273


#### Irish Interests under Tariff Reform


For the purposes of a system of Tariff Reform, the revival of the Irish Vice-Treasurership is expedient. The peculiar circumstances, conditions, aptitudes, and requirements of Ireland must be regarded, inquired into, discussed and weighed. Her commercial, industrial, and agricultural interests must be specially considered. They vary in many particulars from those of Scotland and England. This can only be done satisfactorily by a responsible Irish Minister charged with the duty of protecting and securing her interests and harmonising them with those of the sister Kingdoms in the framing of a scientific scheme of Tariff Reform.


If Irish interests are properly provided for, she should gain greatly under Tariff Reform. The effect of the Whig finance, inaugurated by **Gladstone** in 1853, accompanied by a rigid application of the Ricardian theories of political economy, and the continuous narrowing of the basis of indirect taxation, told against Ireland most severely, depleted her resources and retarded her progress. **Sir Stafford Northcote** thus addressed the House of Commons after twelve years' experience of the Gladstone Budget:—

*The upshot of our present system of taxation has been to increase the taxation of the United Kingdom within the last ten or twelve years by 20 per *cent*, and they would find that whereas the taxation of England had increased by 17 per *cent*, that of Ireland had increased no less than 52 per *cent* between 1851 and 1861. This disproportion had been brought about by laying upon Ireland the burden of the Income-tax and by heavily increasing the spirit duties, making use at the same time of these two great engines of taxation to relieve the United Kingdom, but more especially England, of particular fiscal impositions ... Taxation in these two parts have pressed so heavily on Ireland, it was incumbent upon the people of England to take into account the necessity of relieving Ireland in any way they could.’’*

 Hansard. , Feb. 27, 1865, vol. 177, p. 813.




---

p.274


This plea of a great Conservative financial authority for that special consideration for Ireland to which she is entitled in fiscal matters under the Act of Union was not carried into effect until the Unionist administration of **Lord Salisbury**, in 1886. Then began, under the Chief Secretaryship of **Mr. Arthur Balfour**, that practical application of the ‘Exemptions and Abatements’ clause of the Act of Union in the policy of Constructivism which has fructified so magnificently, and which, if allowed to continue uninterrupted by Home Rule, will lead Ireland to affluence.


The **Lloyd George** Budget penalised Ireland still further by exaggerating those methods of Whig finance which persistently narrowed the basis of indirect taxation and heaped up disproportionate imposts on a few selected article(s) which are either very largely produced or very largely consumed in Ireland. The effect of **Gladstone**'s Budget of 1853 was to reduce the area under barley in Ireland by 134,000 acres in six years; the **Lloyd George** Budget has reduced the Irish barley crop by 10,000 acres in one year. Therefore in the framing of the Tariff Reform Budgets of the future, Ireland's equitable claim under the Act of Union should be recognised and given effect to.


#### Reform Of Agricultural Land Taxation


Agricultural land in the hands of the farmers who have bought their holdings under the Irish Land Acts has been made liable to extravagant burdens by the **Lloyd George** Budget. These peasant purchasers are treated as if they were ‘Dukes’. When they discover their real position, their resentment will be bitter. Form IV. has not yet been circulated among them. It has been kept back deliberately It would not suit **Mr. Redmond** or the Ministry, should the Irish farmer discover what the actual working of the new Land taxes means while the legislative logs are still being rolled by the Radical-Socialist-Nationalist combination. When Home Rule is defeated Unionist finance should provide that the burden imposed by these taxes on agricultural



---

p.275




progress and national prosperity shall be removed, and that the benefits conferred by the great Unionist policy of State purchase on the peasant proprietors shall not be allowed to be filched away by the Socialist budget, though it was by that very Irish party, whose first duty should have been to protect them, that the Irish farmers' interests have been betrayed.


#### Constructivism


It was found by the Financial Relations Commission that Ireland contributed a revenue in excess of her relative capacity. **Mr. Childers**, in his draft report, suggested that practical steps might possibly be taken to give Ireland relief or afford her equitable compensation in three different ways—



*(1) By so altering the general fiscal policy of the United Kingdom as to make the incidence of taxation fall more lightly on Ireland, it was suggested that the taxation upon tea, tobacco, and spirits, which weigh more heavily on Ireland in proportion to her relative capacity, because of the habits of the people, and the larger proportion in Ireland of the poorer classes, might be reduced and a part of the burden transferred to other commodities. It was, however, felt, he said, that this would open up questions of such magnitude—like Free Trade and the incidence of taxation as between different classes—that it would be inexpedient to urge it, when the object in view was the solution of a pressing difficulty with regard to Ireland taken apart from the rest of the United Kingdom. But that difficulty will be removed under Tariff Reform—one-sided Free Trade is no longer a sacrosanct fetish—and the case of Ireland must be taken not as apart from, but as part of, the United Kingdom. Irish interests, Agricultural and Industrial, can be far better promoted, furthered, and secured under a scientific tariff system than under the so-called free trade system, which insists on the fallacy that identity of imposts means equality of burden, and concentrates its pressure on the great Irish industries of brewing, distillery, and tobacco manufacturing; a system which taxes heavily tea—the great article of consumption—and has brought peculiar disaster on agriculture. Therefore, the remedy which **Mr. Childers** thought impracticable in 1896 will become eminently practicable with a Tariff Reform Ministry in power.’’*




---

p.276


(2) The second suggestion then made was that there should be a policy of distinct customs and excise for Ireland as apart from Great Britain. This would involve a customs barrier between the two islands. The inconvenience of such a course would be immeasurable and disastrous under modern conditions. It would certainly come sooner or later under Home Rule, but it would be a reversal of the policy of the Union.’’

- 

*(3) The third method which most strongly recommended itself to **Mr. Childers** was to give compensation to Ireland by making an allocation of revenue in her favour, to be employed in promoting the material prosperity and social welfare of the country.’’*


- Financial Relations Report. , 1896, c. 8262, vol. iii. p. 194.

This is the course which has been pursued by Unionist statesmen, and finds practical expression in their Constructive policy. The results cannot be better proved than by the fact that within the six years from 1904, during which the statistics of Irish Export and Import trade have been kept, her commerce has increased in money value by more than twenty-seven millions. At least four-fifths of that great increase represents a corresponding increase in British trade with Ireland.


**Mr. Childers** wrote in 1896—

*Apart from the claim of Ireland to special and distinct consideration under the provisions of the Act of Union, and upon the ground that she has for many years been, and now is, contributing towards the public revenue a share much in excess of her relative taxable capacity; I think that Great Britain as a manufacturing and trading country would in the course of time be amply repaid by the increase of prosperity and purchasing power in Ireland for any additional burdens which this annual grant to Ireland might involve. Looked at simply as a matter of good policy, it would be that often advocated with regard to Crown Colonies of Imperial expenditure with a view to the development of a backward portion of the Imperial estate. Ireland is so much nearer to and more exclusively the customer of the trading and manufacturing districts of Great Britain than any Colony, that this argument in her case should have redoubled weight. It is at least probable that, if in place of the fitful method of casual loans and grants hitherto pursued, there was a steady, persevering, and well-directed application of public money by way of free annual grant towards increasing the productive power



---

p.277



of Ireland, the true revenue derived from that country might in time be no longer in excess of its relative taxable capacity.’’*

1896, c. 8262, p. 194.


The wisdom of this Liberal Chancellor of the Exchequer makes a strange contrast with the folly of the Radical Chief Secretary, who tells England to ‘cut the loss’ at the moment of Ireland's rapid progress because Irish Old Age Pensions have exceeded in number the reckless anticipation of the Right Hon. **Mr. Lloyd George**.


#### A Suggestion for State Transit of Home-Grown Produce


The present writer ventures to suggest that under a general scheme of Tariff Reform, the home-grown food supply of the United Kingdom might be generally increased and cheapened, and Ireland, along with the other agricultural districts of the United Kingdom greatly developed, by an extension of the principle of the Parcel Post, and the constitution of a great Home-Grown Commodity Consignment Service worked through arrangements between the Post Office, the Railway Companies, the Agricultural Departments and Farmers' Co-operative Associations. The railways already provide special rates for farm produce. But if the system were organised by the State in connection with the Railways and Agricultural Associations, and the parcel post expanded from the carriage of parcels of eleven pounds weight to the carriage of consignments of a tonnage limit to be delivered on certain days at depots in the large cities and centres of population, great national interests might be served.


The value of proximity to the Home Markets which has been so depreciated in favour of foreign supplies by modern transit methods and quick sea passages, would be restored to the British and Irish farmer. If this were accompanied by a tariff system which would secure a preference for home-grown cereals such as oats and barley, a direct 



---

p.278



effect in stimulating agriculture, and an indirect effect in increasing winter dairying, cattle feeding and poultry rearing, would be produced. The country would become more self-sustaining. The peace food supply would be cheapened and the food supply in time of war augmented. The defensive power of the realm would be increased. If, under the new Tariff system, it seems not inexpedient to re-impose the small registration duty on imported foreign as contrasted with colonial wheat and flour, the revenue thus produced might, without exactly earmarking it, be applied partly towards encouraging and advancing agriculture in the United Kingdom, and partly towards financing such a Commodity Post as above suggested. This subvention to domestic, agricultural and pastoral industries would balance the tariff on foreign manufactured goods, and the farmer of England, Scotland and Ireland would share amply in the stimulus of a new fiscal policy. Tariff Reform may assist the manufacturer and artisan by imposing duties at the ports, and the farmer and agricultural laborer by cheapening transit and encouraging food production within the United Kingdom.


#### Equivalent Grants in Aid


In 1888 a system was inaugurated by which Grants in Aid of Local Purposes have been made in the Three Kingdoms on the basis that England should get 80 per *cent*, Scotland 11 per *cent*, and Ireland 9 per *cent*, when such subventions are given from the Imperial Exchequer. The Legislation sanctioning this proportional allocation began with the English Local Government Act of 1888, when Grants in Aid were made out of the Probate Duties, and has been carried into several other Statutes relating to England, Scotland and Ireland. These proportions have become to a large extent stereotyped in the allocation of such grants. The new basis of contribution was originated by **Mr. Goschen** and was stated by him to depend upon the amount of the assumed contribution of each country to the 



---

p.279



Revenue for Common purposes. The method of calculation, he said, was a very complex one.[64](javascript:footNote('E900031/note064.html'))


It was pointed out at the time that under the new system the party that would probably require the largest amount of the grant would be the poorest country, and yet the richer country would get the larger proportionate grants.[65](javascript:footNote('E900031/note065.html')) The method of segregation is as follows. The Revenue and Expenditure Returns divide public expenditure into four clauses: *(a)*, ‘Imperial or Common Services,’ *(b)* ‘English Services,’ *(c)* ‘Scottish Services’ and *(d)* ‘Irish Services’; and having treated the three latter as ‘local services’ and charged the particular outlay on them against each of the three countries, they estimate the balance left in cash as ‘the Contribution’ of England, Scotland and Ireland to the ‘Imperial’ Expenditure. It is admitted that this division is absolutely arbitrary. It has no sanction by any Act of Parliament. It is opposed to the system of Finance under the Act of Union. All the revenues of England, Scotland or Ireland are contributed for ‘Common’ purposes, and in which all expenditure of any kind in any portion of the United Kingdom is alike ‘Common’ or ‘Imperial.’. The details of the division were never disclosed, when the proportions were originally fixed. The segregation of the services classified as ‘Imperial’ is open to serious objections. The method of computation is empirical and unconstitutional, and if carried to its logical conclusion would now result in depriving Ireland of any share whatever in future Equivalent grants, as her contribution to the services thus classified as ‘Imperial’ is practically a minus quantity, though the revenue actually raised in Ireland is much higher than it ever has been before. This method of Distribution of Grants in Aid has been condemned by a succession of the highest financial authorities. **Lord Ritchie**, as Chancellor of the Exchequer, said, 'he did not think it possible really to defend in all its details distribution by contribution.' [66](javascript:footNote('E900031/note066.html'))




---

p.280


**Mr. Wyndham** said—

*It leads to results which all must hold to be illogical, and results which everybody in Ireland holds to be unjust because the greater the increase of taxation the less is the proportion that comes from Ireland, the poorer partner in the business, and so the less is the equivalent grant. As the evil increases the remedy diminishes, and you have only to force up taxation sufficiently high to extinguish the remedy altogether.’’*

 Parl. Deb.. , vol.120, p. 823.


**Mr. Asquith** said—

*A more confused and illogical condition of things it is impossible to imagine. The House ought really to take the opportunity of threshing out the principle upon which these equivalent grants ought to be distributed between the three countries.’’*

 Parl. Deb.. , vol.175, p. 1088.


**Lord St. Aldwyn** said—

*That he always had a very strong objection to the system of Equivalent Grants, because when they had to make a grant for certain purposes to England, they were obliged to make proportionate grants to Ireland and Scotland quite irrespective of whether they needed them or not.’’*

 Parl. Deb.. , May 31, 1903.


Neither the ‘Imperial’ contribution basis nor the ‘Population’ basis, which has in some instances been resorted to for grants in aid, is satisfactory, nor is the method desirable of setting aside a certain fund raised by some particular tax to finance a particular service. For instance, the subvention of Education in Ireland out of the ‘Whisky money’ recently broke down owing to the diminution of the Revenue from this source. The more sober Ireland became, the less she got for Education. Chaos was imminent, and finally, after much friction, a special grant had to be made from the Treasury to save the situation. There are numerous instances in which great complications have been caused in dealing with local 



---

p.281



authorities owing to these methods of making grants in aid, and the system should be reformed. The true basis is the basis of each Kingdom's need. [*...*] England has her needs, let them be supplied. Scotland has hers, let them be supplied. Ireland has hers, and having regard to her present comparative poverty, let them be supplied ‘not grudgingly or of necessity,’ but by the Chancellor of the Exchequer ‘as a cheerful giver.’ This is the constitutional principle under the Act of Union, and the soundest financial principle to observe for the United Kingdom.




---

p.282


### The Economics of Separatism

### By **L. S. Amery, M.P.**


The history of Ireland for the last two centuries and more is a continuous exposition of the disastrous consequences of political and economic separatism within an area where every natural condition, and the whole course of historical development, pointed to political and economic union. Geographically, racially and historically an integral part of a single homogeneous island group, Ireland has never really been allowed to enjoy the full advantages of political and economic union with the adjoining main island. Almost every misfortune which Ireland has suffered is directly traceable to this cause. In spite of this, it is now seriously proposed to subject her once again to the disadvantages of political separation, and that on the very eve of an inevitable change of economic policy, which, while it would restore real vitality and purpose to political union, would also once more intensify all the injury which economic disunion has inflicted upon Ireland in the past.


In the long constitutional struggle of the seventeenth century her position as a separate political unit made Ireland a convenient instrument of Stuart policy against the English Parliament. **Cromwell**, with true insight, solved the difficulty by legislative union with England. But his work was undone at the Restoration, and for another 122 years Ireland remained outside the Union as a separate and subordinate state. Her economic position was that of a Colony, as Colonies were then administered. But it was that of a ‘least favoured Colony.’ This was due, in part, to a real fear of Ireland as a danger to British constitutional liberty



---

p.283



and British Protestantism[67](javascript:footNote('E900031/note067.html')) which long survived the occasion which has seemed to justify it. But what was a more serious and permanent factor was the circumstance that Ireland's economic development could only be on lines which competed with England, and not like Colonial development on lines complementary to English trade. One after another Irish industries were penalised and crippled by being forbidden all part in the export trade. A flourishing woollen industry, a prosperous shipping, promising cotton, silk, glass, glove making and sugar refining industries were all ruthlessly repressed,[68](javascript:footNote('E900031/note068.html')) not from any innate perversity on the part of English statesmen, or from any deliberate desire to ruin Ireland, but as a natural and inevitable consequence of exclusion from the Union under the economic policy of the age. Whatever outlet Irish economic activity took there was always some English trade whose interests were prejudicially affected, and which promptly exercised a perfectly legitimate pressure upon the Government to put a stop to the competition. The very poverty of Ireland, as expressed in the lowness of Irish wages, was an ever convenient and perfectly justifiable argument for exclusion. The linen industry alone received a certain amount of toleration, and even encouragement. These regulations were so little animated by direct religious or racial antipathy that it was upon the Protestant Scotch and English settlers that they fell with the greatest severity, driving them into exile by thousands, to become, subsequently, one of the chief factors in the American Revolution. But if the direct economic effect of political



---

p.284



separation weighed less heavily upon the Catholic majority they suffered all the more from the utter paralysis of all industry and enterprise consequent upon the Penal Laws. These laws, monstrous as they seemed even to **Burke**, were in their turn a natural outcome of a political separation which made the security of Protestantism in Ireland rest upon the domination of a narrow oligarchy in instant terror of being swamped. Under Union they would never have been devised, or could certainly never have endured.


The revolution by which the Irish Parliament, in 1782, asserted its constitutional equality with the British Parliament, subject only to the power of bribery, direct or indirect retained by the Crown, brought out in still more glaring relief the utter unsoundness of the existing political structure under separation. After eighteen years of ferment within Ireland and friction without, British and Irish statesmen, face to face with civil war and French invasion, realised that the sorry farce had to come to an end. Meanwhile the immediate economic effect of liberation from the direct restrictions on Irish foreign trade, already conceded in 1779 and helped in various directions by judicious bounties, was undoubtedly to give a new impetus to production in Ireland. The first ten years of **Grattan**'s Parliament were, on the whole, years of growing prosperity. Whether, even apart from Civil war and increasing taxation, that prosperity would have continued to increase, if the Union had not come about, is, however, a more doubtful matter. The immense industrial development of England during the next half-century would probably, in any case, have crushed out the smaller and weaker Irish industries, while the existence of a separate tariff in Great Britain would have been a serious obstacle to the development of Irish agriculture. A full customs union, with internal free trade, was undoubtedly the best solution of the difficulty. But **Pitt**'s Commercial Propositions of 1785 failed, partly, indeed, owing to political intrigues, but still more owing to the fundamental impossibility of securing an effective customs union without some form of political union.




---

p.285


When finally Ireland entered the Union it was with the severe handicap of an industrial system artificially repressed for over a century. The removal of the last traces of internal protection in 1824 only accelerated the process, inevitable in any case, by which Irish industries, with the exception of linen, were submerged. But manufacturing industry was at the best a small matter in Ireland compared with agriculture. And to Irish agriculture the Union meant an immense development in every direction. Unfortunately the inheritance of the preceding century, a vicious agrarian system and a low standard of living, was not easily to be eliminated, and little attempt was made to eliminate it. The great increase of agricultural production was accompanied, not by a progressive and well-diffused rise in the standard of national well-being, but by high rents and extravagance on the one side, and, on the other, the rapid multiplication of a population living on the very margin of subsistence. The terrible year of famine was a warning to British statesmanship of the need of a constructive and Conservative policy for the reorganisation of Irish agricultural life and for the broadening of the economic basis in Ireland by the deliberate encouragement of new industries. Under a true conception of Union, political and economic—and there were not wanting men like **Lord George Bentinck** and **Disraeli** who entertained it—Ireland might within a generation have been levelled up to the general standard of the United Kingdom.


But the evil effects of political and economic separatism in the eighteenth century were still unremedied when the whole economic policy of Union was abandoned. The very principle and conception of Free Trade is, inherently, as opposed to the maintenance of national as of Imperial Union. Ireland was deprived of that position of advantage in the British market which was one of the implied terms of the Union, and was not allowed to protect her own market. Incidentally, and as a consequence of the new fiscal policy, Ireland was saddled with a heavy additonal burden of taxation which only handicapped her yet further



---

p.286



in the struggle to recover from the famine and to meet foreign competition. The full severity of that competition was, however, not experienced till towards the end of the seventies, when the opening up of the American West coupled with the demonetisation of silver, brought down prices with a run. A series of bad harvests aggravated the evil. The same conditions were experienced all over Europe, and were everywhere met by raising tariffs to the level required to enable agriculture to maintain itself. Even in England ‘Fair Trade’ became a burning issue. Given normal agrarian conditions in Ireland the Irish vote would have gone solid with the Fair Traders, and the United Kingdom would in all probability have reverted to a national system of economics a generation ago. As things were, landlords and farmers in Ireland, instead of uniting to defend their common interest, each endeavoured to thrust the burden of the economic debacle on the other. The bitterness of the agrarian struggle which ensued was skilfully engineered into the channel of the Home Rule agitation. In other words, the evils of economic separatism aggravated by the social evils surviving from the separatism of an earlier age, united to revive a demand for the extension and renewal of the very cause of these evils.


Since then the underlying conditions of Irish economic life have undergone a complete transformation. The wealth and credit of the United Kingdom have been used to inaugurate a settlement of the agrarian question. The productive and competitive efficiency of Irish agriculture has been enormously increased both by Government advice and assistance and by patriotic private effort. Old Age Pensions have alleviated the burden of an excessive residue of older persons, and irrigated the poorer districts with a ream of ready money. In every direction there is a deliberate effort to raise the economic standard of Ireland to the British level. Last, but by no means least, the exclusion of all foreign *livestock* from the United Kingdom though originally designed only as a precautionary measure against cattle disease, has in effect protected one most



---

p.287



important branch of Irish agriculture and given it a vital interest in the maintenance of the Union. On the eve of the revival of a national policy of economic development Ireland stands on a far sounder basis, and in a far better position to take advantage of that development, than in 1800. The standard of life is rising, and will of itself put a check on a mere multiplication of beings living on the margin of subsistence. For the natural increase of population, which will once more come about, there will be provision not only through more intensive cultivation and in rural industries, but also in a real, though possibly gradual, development of new manufacturing industries, Incidentally the establishment of a protective tariff for The United Kingdom will, by lowering the excessive duties on tea and tobacco which weigh so heavily upon Ireland, increase still further the local excess of Government expenditure over revenue and facilitate the local accumulation capital, already so noticeable a feature of recent years, and thus provide an essential factor in stimulating new enterprise, whether agricultural or industrial. Nor would it be in any way inconsistent with a national economic policy for the United Kingdom as a whole to devote special sums, through bounties and in other ways, towards the opening up of new fields for the economic activities of the Irish people. For the first time in her history Ireland will have a fair start, and, under the Union, the twentieth century may yet prove Ireland's century just as Canadians claim that it will prove Canada's century.


Now let us turn to the other side of the picture. The establishment of Home Rule, in other words of politcal separatism, must inevitably be followed by active economic separatism, i.e. by the creation of a completely separate fiscal system in Ireland. The idea that an Irish Chancellor of the Exchequer can carry on in dependence on a British Budget, which may at any moment upset all his calculations of revenue, is absurd. So is the idea that there can be separate tariffs with mutual Free Trade, or a common tariff without a common government to frame it. If Free Trade,



---

p.288



indeed, were to be maintained in England, fiscal separation would be no disadvantage to Ireland. On the contrary, she would continue to enjoy the same access to the British market while giving her own industries such protection as might be convenient. It is one of the glaring weaknesses of the policy of Free Imports that it actually puts a premium on separatism. But it is impossible to discuss the future on that assumption. Whatever the fate of the Home Rule Bill may be it is certain that Free Trade is doomed, and that the United Kingdom, whether united or divided, will revert to a policy of national protection and national development.


What will be the effect upon Ireland? Assuming mutual good will, assuming that the Irish Government will be ready to grant a substantial preference to British trade over foreign trade, there can be no doubt that Great Britain would respond and give to Irish products the same preference as might be extended to Canadian or Australian products. But the first duty of the British Government would be to British producers. While Empire-grown wheat, and possibly meat, would come in free, the British farmer would receive a measure of protection against the rest of the Empire in dairy products and poultry, in barley and oats, in hops, tobacco, sugar beet, vegetables and fruit, in all those crops, in fact, in which the British production could meet the British demand without an undue effect upon prices.


Now, it is precisely by these intensive forms of production that Ireland stands to gain most under Union. Under Home Rule she would lose this advantage and have to compete on an equality with the rest of the Empire both in respect to these products and in respect to wheat and meat. It is extremely doubtful, too, whether her special privileges with regard to store cattle would long survive. They could no longer be defended, as against Canada, by the arguments now used, and as a piece of pure protectionism there would be no reason for Great Britain to give them a separate fiscal entity. And if the hopes of Irish agriculture would be severely checked, still



---

p.289



more would that be true of those hopes of new industries already referred to. Even the great linen industry might find a small duty enough to transfer a large part of its production within the British tariff zone. On the other hand, it is doubtful whether any tariff that Ireland could Impose, consistently either with preference or with reasonable prices in so small a market and on so small a scale of production, could be of much effect against the competition of British industries, strengthened and made aggressive under the stimulus of a national trade policy.


This is the most favourable hypothesis. But it is at least conceivable that a Nationalist Government, whether actuated by a laudable desire to hurry on Irish industrial development, or influenced by the tradition of animosity which still plays so strong a part in Nationalist politics, may refuse to enter upon the policy of Imperial preference. It might even be tempted by various considerations to give a preference to the United States or to Germany. Germany is a large importer of foodstuffs. The establishment of a British tariff may prove a serious blow to her manufacturing interests. A trade agreement with Ireland might be a very useful temporary business expedient from the German point of view. Incidentally a large increase of German merchant shipping in Irish harbours might, in the case of possible hostilities, be of no little service in providing commerce destroyers with a most convenient excuse for being in the most favourable area for their operations. Any fiscal excursions of that sort would inevitably be visited upon Ireland by severe economic reprisals of one kind or another on the part of Great Britain, from which Ireland would receive permanent injury far outweighing any temporary advantage which might be secured from foreign countries.


In other words, Ireland under Home Rule would be in almost every respect thrust back into her eighteenth century position of ‘least favoured Colony.’ She would, at the best, be handicapped in the British market in respect of those products by which she could profit most, and in those which she is less fitted to produce would have to compete



---

p.290



with the virgin soil and competitive energy and organisation of the great Dominions. At the worst, her fiscal policy might invite reprisals and make her ‘least favoured’ not only by her circumstances but by the intention of those who would frame the British tariff. It is true that the British Government would no longer dream of directly interdicting Irish exports. But in that respect modern organised capital has an influence to promote or kill almost as great as that of governments in former times. And the influence of British capital, under such circumstances, would certainly not tend to be directed towards the economic development of Ireland.


But the use of the customs tariff is by no means the only great instrument of a national economic policy, To promote the flow of trade in national channels, to secure the fullest development of the national territory and resources, the removal of natural internal barriers is often even more important than the setting up of artificial external barriers. Statesmen who have had to face the task of giving strength and solidity to weak political unions have always aimed at the development of internal communications. Washington's first concern after the success of the American War of Independence was to endeavour to create a system of internal river and canal navigation in order to help to bind the loosely allied States into a real union. Bismarck used the Prussian railways as well as the Zollverein to build up German unity. In the making of Canada the Intercolonial railway and the Canadian Pacific were essential complements to the national tariff. Railways forced South Africa into union, and will gradually give Australia real cohesion and unity. In the United Kingdom there has been no national policy with regard to communications, least of all any nationally directed or stimulated effort to cement the political union of 1800. But such a policy is essential to the reality of the Union. To get rid, as far as possible, of the barrier which the St. George's Channel presents *today* both to the convenience of passenger traffic and to the direct through



---

p.291



carriage of goods between internal points in the two islands should be one of the first objects of Unionist policy in the future. In the train-ferry, which has bridged the channels of sea-divided Denmark, which in spite of the Baltic, has made Sweden contiguous with Germany, which for the purposes of railway traffic, has practically abolished Lake Michigan, modern developments have provided us with the very instrument required. To Irish agriculture the gain of being put into direct railway communication with all England and Scotland would be immense. From the tourist and sporting point of view Ireland would reap a doubled and trebled harvest. More than that, the bridging of St. George's Channel will for the first time enable the west coast of Ireland to become what it ought to be, the true west coast of the United Kingdom, the starting point of all our fast mail and passenger services across the Atlantic.


But all this implies the Union, the existence of a single Government interested in the development of the United Kingdom as a whole. Separate governments in Great Britain and Ireland would not have the same inducement to give financial encouragement to such schemes. Irish manufacturers and British farmers alike might protest against being taxed to facilitate the competition of rivals in their own markets. An Irish Government would have neither sufficient money nor sufficient interest to give the subsidies necessary to secure a three days' service across the Atlantic. A British Government would naturally develop one of its existing ports, or some new port on the west coast of Scotland, rather than build up a new source of revenue and national strength in a separate State. No one could blame it, any more than we could blame the Canadian Government for wishing to subsidise a fast service from Halifax or some other port in the Dominion rather than one from St. John's, Newfoundland. In the seventeenth and eighteenth centuries the Navigation Acts deliberately destroyed Irish shipping. A policy of laisser faire in matters of national communication has hitherto prevented its revival. To-day new ideas are in the air. Those ideas



---

p.292



can be applied, either from the standpoint of the Union or from that of separatism. In the one case Ireland has the prospect of becoming, what her geographical position entitles her to be, the eastern bridge-head of the North Atlantic. In the other the immense power of the larger capital and larger subsidies of Great Britain will be as effective as any navigation laws of the past in leaving her a derelict by the wayside, continuing to wait idle and hungry, with empty harbours, while the great streams of commerce flow past her to north and south.


And if the theory of laisser faire is rapidly dying out in matters of trade and communications, it has already been largely superseded in regard to social questions. The duty of the State to expend money in order to level up the standard of life of its citizens, or to prevent their sinking below that standard, is *today* universally recognised. The methods by which that object is aimed at are various. There is the crudest form, that of direct money relief, such as is involved in Old Age Pensions. There is the subsidising of socially desirable economic operations, such as insurance against sickness or the acquisition of freehold by tenants. There is the expenditure of money on various forms of education, in the scientific assistance of industry and agriculture, in promotion of forestry, drainage, or the improvement of local communication. There is the enforcement of innumerable regulations to safeguard the health and safety of the working population. Nowhere has this conception of the duty of the State exercised a greater influence than in Ireland during the last twenty years. The Congested Districts Board, the Department of Agriculture, the Land Purchase Scheme, illustrate one phase of its carrying into effect. Old Age Pensions, cheap Labourers' cottages, sickness insurance illustrate another. All these have been provided out of the United Kingdom exchequer. They could not be provided out of Irish revenues. Still less could Irish revenues provide for a continuous extension of this policy in order to keep on a level with English conditions.


It has been stated by **Mr. Churchill** that under the



---

p.293



Government scheme of Home Rule, Land Purchase and Old Age Pensions will be paid by Great Britain. Even if that were a workable arrangement it only covers a small part of the field. For the rest Home Rule would mean the complete abandonment of the attempt to level up the social conditions of Great Britain and Ireland to a common standard, The Irish Government would never have the means to carry out the same programme of social legislation as will be carried out in Great Britain. Handicapped in competition with British industries it would, moreover, naturally be disinclined, even apart from the question of cost, to apply any legislation or any regulations which might tend to raise the cost of production. There will thus not only be an inevitable falling back for want of means, but, in addition, a continual temptation to the weaker and more backward State to meet superior industrial efficiency by the temporary cheapness, of inferior social conditions.[69](javascript:footNote('E900031/note069.html'))


But such a policy would not only be disastrous in itself in its ultimate effect upon Irish national life. It would at once provide a fresh and valid excuse for effective fiscal differentiation against Ireland in Great Britain. Once again, as in the eighteenth century, Ireland would be penalised for being a poor and ‘sweated’ country.


So far the discussion of the economic results of separation has been confined to Ireland, because Ireland would undoubtedly be the chief sufferer. Her dependence on the English market, the smallness of her home market, her backward social condition, would all be insuperable obstacles to a really healthy development on independent lines. Great Britain, on the other hand, would suffer relatively much less from Home Rule. The immediate shrinkage of trade with Ireland, even with an Irish tariff to overcome, might not be very great. The real loss would be not so much



---

p.294



any actual decrease of trade, as the loss judged by the standard of the possibilities of Irish development under the Union. The essence of the situation after all is that the United Kingdom is a single economic area. The exclusion of one part of that area from the political and economic life of the rest, while injurious to the rest, must prove disastrous above all to the part excluded. After centuries of alternate neglect and repression Ireland has at last been brought to a condition in which she is capable of taking the fullest advantage of a new era of progress and development for the United Kingdom as a whole. And this is the time which is chosen for seriously suggesting that she should once again be excluded from all the benefits of partnership in the United Kingdom and driven out into the wilderness of poverty and decay. The plea for this folly is an unreal sentiment which is itself merely the survival of the mistaken political or economic separatism of the past, and which is nothing to the real and justifiable sentiment of bitterness which would be roused in Ireland if the plea were accepted.




---

p.295


### Private Bill Legislation

### By the Right Hon. **Walter Long, M.P.**


The argument so often and so plausibly presented in favour of Home Rule, which urges that the Imperial Parliament is overburdened with local affairs, contains an element of truth. It would, however, be more in accordance with the facts to put the case the other way round: for localities are much more seriously inconvenienced in certain respects by the necessity of referring local business to the Imperial Parliament, than the Imperial Parliament is inconvenienced by the transaction of such business, which, if we are to believe the Chancellor of the Exchequer, it neglects (videfrn> Nash's Magazine, February, 1912). At the same time, to affirm that, in order to remedy what is no more than a defect in administration, it is necessary to overturn the British Constitution, and to build on its ruins four semi-independent Legislatures and one supreme Parliament, is merely to exemplify the cynical imposture of partisan misrepresentation: what **Mr. Balfour** described as ‘the dream of political idiots.’


There is no impartial person who does not clearly recognise that to constitute a separate Parliament for Ireland (to say nothing of England, Wales, and Scotland) must necessarily result, not in the more efficient despatch of legislative and administrative business, but in perpetual friction, clogging the mechanism alike of the subordinate and the predominate body. Ireland enjoyed—or endured—an independent Parliament during eighteen years, from 1782 to 1800; and, in the result, the greatest statesmen both in Ireland and in England were forced to acknowledge that



---

p.296



the system had in practice failed utterly; and that there remained no alternative but the Union. To that view of the situation the great majority of the Irish people, irrespective of race or creed, were converted within a year before the passing of the Act, an event which was hailed with rejoicing. The experience of 112 years, fraught as they have been with occasional calamity and burdened with many blunders, has not produced a single valid objection to the principle of the Union, unless the survival among a diminishing section of the population of the old bad tradition of hatred towards England and its deliberate exploitation by pledge-bound politicians is to be regarded as a reason for sacrificing the welfare and the prosperity of both countries. The framers of the Act of Union did not, and indeed could not, provide for every contingency. It is therefore the business of those who are determined to maintain the Union, to adjust its machinery to modern requirements. An omission of capital import was the failure to provide for the efficient promotion of private Bills. The matter was, indeed, actually considered by the authors of the Act of Union. The **Duke of Portland** wrote to **Lord Cornwallis, Lord Lieutenant of **Ireland****, under date December 24, 1798, as follows:

*One of the greatest difficulties, however, which has been supposed to attend the project of union between the two kingdoms, is that of the expense and trouble which will be occasioned by the attendance of witnesses in trials of contested elections, or in matters of private business requiring Parliamentary interposition. It would therefore, be very desirable to devise a plan (which does not appear impossible) for empowering the Speaker of either House of the United Parliament to issue his warrant to the Chairman of the Quarter Sessions in Ireland, or to such other person as may be thought more proper for the purpose, requiring him to appoint a time and a place within the County for his being attended by the agents of the respective parties, and reducing to writing in their presence the testimony (for the consents or dissents, as the case may be) of such persons as, by the said agents, may be summoned to



---

p.297



attend, being resident within the County (if not there resident a similar proceeding should take place in the County where they reside), and such testimony so taken and reduced into writing may, by such Chairman or by the Sheriff of the County, be certified to the Speaker of either House, as the case may be. It seems difficult to provide a detailed Article of the Union for the various regulations which such a proceeding may require, but the principle might perhaps be stated there, and the provisions left to be settled by the United Parliament.’’*


According to **Lord Ashbourne**'s Life of **Pitt**, the Prime Minister himself framed a scheme for constituting a Court of Appeal in Ireland, with power to examine evidence and certify all preliminaries and other matters respecting private Bills. Why the provision was not included in the Act of Union is not clear. The fact of its omission, however, proves that the necessity of resorting to the Imperial Parliament for the transaction of private business was not an objection that hindered the passage of the Act of Union, although *today* the same omission is absurdly used as an argument in favour of the repeal of that measure. At the same time, it is true that the requirements have immensely increased in proportion as the resources of the country have been developed since 1800. The introduction of railways, telegraphs, telephones and electric appliances, together with the grant of compulsory powers to municipalities, has involved the promotion of numerous private Bills at vast expense to Ireland. **Mr. A. W. Samuels, K.C.**, who contributed a paper on the subject to the Statistical and Social Inquiry Society of Ireland in November, 1899, quoted some instances of the cost of private Bill legislation in Ireland:—
  

*The ratepayers of Dublin, of Rathmines, of Pembroke, of Clontarf, and other suburbs of the city, long will feel the burden added to their rates by the London litigation of the Session that has passed. The Dublin Boundaries Extension Bill of 1899 has cost the city, as I am informed on reliable authority, between £12,000 and £13,000. There were twenty-four separate sets of opponents. The cost to Rathmines of its opposition approaches, I am informed, £8,000. To meet it about one shilling in the pound must be added 



---

p.298



to the taxation of that township. The costs of Pembroke cannot be far short of the same sum. If we add those of the oppositions of Kilmainham, Drumcondra, Clontarf, and of the County of Dublin and of private persons and public bodies, the total expense to the inhabitants and ratepayers of the city and its suburbs will not fall short of £45,000.’’*


**Mr. Pope, Q.C.**, stated before the Committee which considered the Irish Railways Amalgamation Scheme of last Session, that the Bill at hearing was costing £5 per minute. A high authority conversant with the proceedings in this case has informed me that this was an under-estimate rather than an over-estimate, having regard to the fact that there were twenty-seven separate oppositions. The Bill occupied twenty-seven working days of four hours each; and its cost to the shareholders of the promoting Company were calculated to amount to about £400 per day. What the loss was to the shareholders of other Companies, and to the ratepayers represented by public bodies, it would be impossible to say. The Bill probably cost at least £50,000. There was a Belfast Corporation Bill. There was an Armagh and Keady Railway Bill. There were several other Irish Bills before the Houses, exhausting thousands more of Irish capital, and diverting it from the material development of the country. So abnormal was the waste of Irish money on the Railway Bill that it excited general attention even in England, and became the subject of comment in Parliament. **Mr. J. H. Lewis**, the member for Flint Burghs, speaking on the 24th July, 1899, on the third reading of the Scotch Private Legislation Procedure Bill, said 'I am sure everybody must have regarded with great dissatisfaction the enormous expenditure to which certain Irish Railway Companies were put during the last few weeks within the walls of the House. Surely a better system can be devised than that which drags over from different parts of the United Kingdom a host of witnesses, who could be examined on the spot. I am sure all honourable members deeply regret this great waste of public money.'’’

- 

These disabilities have been the subject of frequent representations. Resolutions advocating reform have been repeatedly passed by the Irish Chambers of Commerce, by the Incorporated Law Society, and by local bodies. Leaders of the Unionist party have constantly urged the necessity of a provision for expediting and cheapening Private Bill procedure. In 1896 a deputation from the Dublin Chamber



---

p.299



of Commerce laid the matter before **Mr. Gerald Balfour**, who was then Chief Secretary for Ireland. He expressed a hope that the Government would introduce a reform. In the Queen's speech of February, 1897, it was announced that Bills for amending the procedure with respect to Private Bills coming from Scotland and Ireland had been prepared. The opportunity for laying these measures before Parliament did not arise.


But in 1899 a Bill amending the procedure of Scottish Private Bill Legislation was passed into law. The measure forms the precedent for future legislation. In the year 1900, **Mr. Atkinson (now Lord Lord Atkinson**), speaking for the Government, said that the Government were—
*most favourable to the introduction and passing of a Bill dealing with private Bill legislation for Ireland. He thought the real and substantial difficulty was the creation of the tribunal which was to sit locally and to inquire into these matters. The Irish Government thought it wise to wait until they should see what would be the effect of the operation of the Scotch Act.’’*


Subsequent experience has proved that the Legislation Procedure (Scotland) Act of 1899 may taken for the model of a similar measure designed to apply to Ireland. The Scottish Act substituted for procedure by means of a Private Bill, procedure in the first instance by means of a Provisional Order. Instead of applying to Parliament by a petition for leave to bring in a Private Bill, any public authority or persons desirous of obtaining parliamentary powers now proceed by presenting a petition to the Secretary for Scotland,
*praying him to issue a Provisional Order in accordance with the terms of a draft Order submitted to him, or with such modifications as shall be necessary.’’*


Before the Secretary for Scotland proceeds with the Provisional Order, the draft Order is considered by the Chairman of Committee of the House of Lords, and the Chairman of Ways and means in the House of Commons;



---

p.300



and they report to the Secretary for Scotland whether or not the matters proposed to be dealt with by the draft Order, or any of them, should be dealt with by Provisional Order or by Private Bill. Should the Chairmen report that these matters, or any of them, should be dealt with by a Private Bill, the Secretary for Scotland, without further inquiry, refuses to issue the Provisional Order so far as it is objected to by the Chairmen; but the advertisements and notices already given by the promoters of the scheme are regarded as fulfilling (subject to Standing Orders) the necessary conditions to be observed prior to the introduction of a Private Bill. Should the Chairmen report that the Provisional Order, or a part of it, may proceed, the procedure is as follows. If there is no opposition, the Secretary for Scotland may at once issue the Provisional Order, which is then embodied in a Confirmation Bill for the assent of Parliament. If there is opposition, or in any case where he thinks inquiry necessary, the Secretary for Scotland directs an inquiry, and the Order is then considered by the tribunal described below; and if passed by that tribunal, with or without modifications, it is brought up in a Confirmation Bill for the assent of Parliament.


It follows that in the case of unopposed schemes brought in under the Act, there is a great saving of time and expense as compared with the former system.


With regard to schemes which are opposed, the judicial functions of a Parliamentary Committee dealing with Private Bills were transferred by the Act of 1899 to a special tribunal, composed of two Panels, a Parliamentary Panel and an Extra-Parliamentary Panel, whose members shall have no local or personal interest in the questions at issue. From these is formed a Commission of four members.


**Mr. A. W. Samuels, K.C.**, thus describes the constitution of the Commission:—
 
*‘‘In the first instance it is provided that the members shall be taken—two from the Lords and two from the Commons. In the



---

p.301



event of that being found impossible, three may be taken from one House and one from the other. In the next resort all may be from the same House. Finally—if members cannot be procured to serve—the extra Parliamentary Panel can be called upon, and the Commission manned from it.’’*
‘‘The next great reform introduced by the measure is, that the inquiry is to be held at such place, in Scotland, as may be convenient. The inquiry is to be localised as far as possible. It is to be held in public. The Commissioners are to settle questions of locus standi—they can decide upon the preamble before discussing clauses—and persons having a locus standi can appear before them in person or by counsel or agent.’’


‘‘When they have heard the evidence the Commissioners are to report to the Secretary of Scotland, and they can recommend that the Provisional Order should be issued as prayed for, or with such modifications as they may make. If there is no opposition to the Provisional Order as finally settled by the Commissioners, it is embodied in a Confirmation Bill by the Secretary of Scotland and passed through Parliament.’’


‘‘If there is opposition a petition must be presented to Parliament against the Order, and then, on the second reading of the Confirmation Bill, a member can move that the Bill be referred to a Joint Committee of both Houses of Parliament, and if the motion is carried in the House a Joint Committee of Lords and Commons shall sit, at the peril of costs to the opponents, to hear and take evidence and decide upon the measure in the same way as in the case of a Private Bill.’’

 - (Private Bill Procedure, pp. 9 and 10.)



In 1904, the Select Committee appointed to consider the provisions of a similar measure to be applied to Wales, reported that in practice the Scottish Act had proved a success, which they attributed largely to the supervision of the Provisional Orders conducted by the Scottish Office.


There would seem, then, every reason to believe that a measure framed upon the lines of the Scottish Act, to apply to Ireland, would be equally successful.


The remarkable increase in the prosperity of Ireland,which has occurred during the last twenty years, demonstrates the necessity for providing every means of encouraging the further development of the country.




---

p.302


All the available statistics amply confirm and corroborate the evidence of this prosperity, which is known to every man with the smallest direct acquaintance of Ireland in recent years. The figures of savings, bank deposits, external trade, all alike show the exceptional advances in prosperity now enjoyed by Ireland.


The progress of Ireland under the Union thus indicated, was inaugurated by **Mr. Balfour**, the best Chief Secretary Ireland ever had; to this day his name is always mentioned with respect and gratitude by the people of Ireland, especially by the residents in the South and West, where his policy produced splendid and lasting results. Insufficient credit has been given to the work of agricultural and commercial development steadily pursued by **Mr. Gerald Balfour**; the results upon which we rejoice *today* are mainly due to the policy adopted by **Mr. Balfour** and his brother. This policy, coupled with the restitution of sales under the Land Act of 1903, is the one which Unionists intend resolutely to pursue.


The figures on the next page show that the increase of population in some important centres in the south and west is very small, and that in other centres there is a decrease. Ireland being mainly an agricultural country, the population tends to decrease owing to emigration, although of late years, owing to the rise in prosperity, the tendency is rather to remain stationary. At the same time, the increase of the population in the provincial towns is not commensurate with the increase of material wealth in the country.


With regard, for instance, to the increase in the number of tourists visiting Ireland, both private persons and local bodies desire to extend existing inducements and to improve the means of transit and to raise the standard of accommodation. It is clear that, under a reformed method of procedure in respect of Private Bill Legislation, enterprise would be freed from the restrictions which at present hinder its free exercise, and a substantial and a steadily increasing benefit would accrue to Ireland.




---

p.303


Increase and Decrease of Population of Cities and Towns In Ireland having In 1901 a Population Exceeding 10,000. (Census of Ireland 1911.)




| Cities, towns, etc. | Percentage of increase since 1901 | Cities, towns, etc. | Percentage of decrease since 1901 |
| --- | --- | --- | --- |
| Rathmines and Rathgar | 17.1 | Newry* | 5.2 |
| Portadown | 16.2 | Newry | 3.6 |
| Pembroke | 13.4 | Drogheda | 2.6 |
| Belfast | 10.4 | Galway* | 2.0 |
| Belfast* | 10.1 | Galway | 1.3 |
| Dublin | 6.4 | Kilkenny* | 1.0 |
| Lisburn | 6.2 | Kingstown | 0.9 |
| Ballymena | 4.5 | Kilkenny | 0.9 |
| Lurgan | 3.0 | Waterford* | 0.4 |
| Sligo | 2.7 |  |  |
| Dublin* | 2.6 |  |  |
| Wexford | 2.6 |  |  |
| Waterford | 2.5 |  |  |
| Cork* | 2.3 |  |  |
| Londonderry* | 2.3 |  |  |
| Limerick* | 1.2 |  |  |
| Clonmel | 1.1 |  |  |
| Cork | 0.7 |  |  |
| Limerick | 0.7 |  |  |
| Dundalk | 0.4 |  |  |






Those marked (*) are Parliamentary Boroughs.




---

p.304


### Irish Poor Law Reform

### By **John E. Healy** (Editor of the Irish Times)


An article on Irish Poor Law Reform written within the limits assigned to me can only be constructive in the broadest sense. It is a serious and tangled problem: the existing system has developed in a haphazard fashion; there is about it hardly anything that is logical, much that is anomalous, some things that are tragic. The present conditions of the Irish Poor Law system are set forth in the reports of various Royal and Viceregal Commissions. The most important are those of the Viceregal Commission on Poor Law Reform in Ireland (1906), the Departmental Commission on Vagrancy, the Royal Commission on the Care and Control of the Feeble-minded, and the Royal Commission on the Poor Laws (Majority Report). The study of all these reports is a rather distracting business. They establish between them an urgent need for reform; on the methods, and even principles, of reform there are wide differences of opinion. I propose to set out here, so far as may be possible, a summary of those reforms on which the various reports and Irish public opinion are nearly, or quite, unanimous. Such a summary may at least help to acquaint the rank and file of the Unionist Party with the primary conditions and necessities of a work which, for historical, moral, social and political reasons, must receive the Party's early and practical attention when it returns to power.


The Unionist Party, as representing the best elements in British Government, owes in this matter a great act of reparation to Ireland. The present Poor Law system is based on the most fatal of all blunders— the deliberate



---

p.305



disregard of educated opinion in Ireland. The story, a very remarkable and suggestive one, is told in the Viceregal Commission's report. The Royal Commission of 1836 came to the conclusion that the English workhouse system would be unsuitable for Ireland. The Irish Royal Commissioners, including the famous **Archbishop Whately**, made two sets of recommendations. One set involved a compulsory provision for the sick, aged, lunatic and infirm. The other proposed to attack poverty at the root by instituting a large series of measures for the general development of Ireland. Looking back over nearly eighty years of Irish history, we must be both humbled and astonished by the almost inspired precision and statesmanship of these proposals. They included reclamation of waste land and the enforcement of drainage; an increased grant to the Board of Works; healthy houses for the labouring classes; local instruction in agriculture; the enlargement of leasing powers with the object of encouraging land improvement, and the transfer of the fiscal powers of Grand Juries to County Boards. Here we have in embryo the Irish Labourers Acts from 1860 to 1906, the Department of Agriculture and Technical Instruction, the Irish Land Acts from 1860 to 1903, the Local Government Act of 1898—reforms which Ireland owes almost entirely to the statesmanship (though it seems a rather belated statesmanship) of Unionist Governments. These Irish recommendations were ignored by the Government of the day. It sent an English Poor Law Commissioner (**Mr. Nicholls**) to Ireland. He spent six weeks in the country. On his return he recommended the establishment of the English Poor Law system there, and it was accordingly established.


The first Poor Law Act for Ireland was passed on July 31, 1838. Between that year and 1851 one hundred and sixty-three Poor Law Unions were created. The number is at present one hundred and fifty-nine, and they are administered by elected and co-opted Poor Law Guardians to the number of more than eight thousand. In every Union there is a workhouse, and in that workhouse all the



---

p.306



various classes of destitute and poor persons are maintained. They include sick, aged and infirm, legitimate and illegitimate children, insane of all classes, sane epileptics, mothers of illegitimate children, able-bodied male paupers, and the importunate army of tramps. The mean number of such inmates in all the workhouses on any day is about 40,000, of whom about one-third are sick, one-third aged and infirm, one-seventh children, one-twentieth mothers of illegitimate children, and one-twelfth insane and epileptic. This awful confusion of infirmity and vice, this Purgatory perpetuating itself to the exclusion of all hope of Paradise, presents the vital problem of Irish Poor Law Reform.


A radical solution must be found for it. On that point the reports of all the Commissions are unanimous. They differ, where they do differ, only as regards means to the end.


The supreme reform which must be undertaken by any Government that seeks to remove this great blot on Irish administration is the abolition of the present workhouse system on some basis which, while effective, will make no addition to the rates. The two chief reports (those of the Viceregal Commission and the Royal Commission on the Poor Laws) are in agreement, not merely as to this necessity, but as to the guiding principles of reform. They recommend classification, by institutions, of all the present inmates of the workhouses—the sick in hospitals, the aged and infirm in almshouses, the mentally defective in asylums. Appalling evidence was given before the Viceregal Commission and the Royal Commission on the Care and Control of the Feeble-minded with regard to the present association of lunatics, epileptics, and imbeciles with sane women and children in the workhouse wards. The latter Commission recommended the creation of a strong central authority for the general protection and supervision of mentally defective persons.


The reforms do not contemplate the amalgamation of Unions and the complete closing of only a certain number of workhouses. They suggest rather the bringing together



---

p.307



into one institution of all the inmates of one class from a number of neighbouring workhouses, and the closing of all workhouses as such. The sick should be sent to existing Poor Law or County Hospitals, strengthened by the addition of Cottage Hospitals in certain districts. Children should be boarded out. The bulk of the remaining inmates, classified with regard to their defects and infirmities, should be segregated according to counties or other suitable areas. On the treatment of able-bodied paupers there are different opinions. It is suggested by the Philanthropic Reform Association, which includes some of the most earnest and disinterested philanthropists in Ireland, that the well-conducted of this class should be placed in labour colonies, and the ill-conducted in detention colonies—both classes of institutions to be maintained and controlled by the State, and not by the County authorities.


The areas and resources of the existing Unions are in most cases too limited, and the numbers of necessitous persons too small, to warrant the present Boards of Guardians in erecting as many types of institutions as there are classes of inmates. The break-up of the workhouse system involves, of necessity, the establishment of larger areas of administration. It is clear that the County must be substituted for the Union in any radical scheme of reform. On this point the Royal Commissioners and the Viceregal Commissioners are agreed. County rating must take the place of Union rating, since the inmates of the different institutions would be drawn from all parts of each County or County Borough. Substantial economies in administration might be expected from this plan. Hospitals should be brought into a County Hospital System, with the County Infirmary as the central institution, and nurses should be trained there for the County District Hospitals (now Workhouse Infirmaries).


About such a general scheme of decentralised reform there is little or no disagreement. There is, however, a good deal of disagreement concerning the control of the new institutions. The Viceregal Commission advocates the



---

p.308



retention by the Poor Law Guardians of many of their existing functions. It suggests, for instance, that County Hospitals should be managed by a Committee consisting of all members of the present District Hospital Committees, strengthened by nine members appointed by the County Council; and that the Chairman of the Board of Guardians should be the Chairman of the District Hospital Committee. The Royal Commission, on the other hand, votes boldly for the abolition of the Boards of Guardians. It argues that, if we are to have a County system of institutions maintained by a County rate, we must adopt the logical consequence that the County Council which strikes and collects the rate should have the direct or indirect management of the institutions. It proposes that the Council should appoint a statutory Committee (one-half to be taken from outside its own members), to be called the Public Assistance Authority, and that this Authority should manage and control all the institutions in the County. The Philanthropic Reform Association, which has given much study to this question suggests a via media between the two official schemes. It recommends that all the institutions should be controlled by the County Council, through Committees directly responsible to it, to which persons of experience from outside should be added. Such committees need not be elected by the Poor Law Guardians, as recommended by the Viceregal Commission, or by the Statutory Committee of the County Council, as recommended by the Royal Commission. The Association desires, and it has a large volume of Irish opinion behind it in this, to minimise the existing powers, and reduce the numbers, of the Poor Law Guardians. It is also very earnestly impressed with the need of bringing women into the Poor Law administration. In this it is absolutely right. The Women's National Health Association and the United Irishwomen have demonstrated triumphantly the value of women's services in improving the social, economic, and sanitary conditions of rural life in Ireland. A recent Act of Parliament qualifies women for election to the Irish County and Borough Councils. No



---

p.309



great reform of the Poor Law system can be effective without their aid. The Unionist Party will only be acting consistently with its social ideals if it encourages, by every means within its power, an Irish feminist movement, full of hope for the country and wholly dissociated from party politics.


Any thorough reform of the Irish Poor Law system will demand an increased expenditure of Imperial funds. The growing severity of Irish taxation under recent Radical budgets forbids the possibility of addition to the ratepayer's burdens. The anomalous distribution of the grants in aid of Irish local taxation has done much to complicate the Poor Law question. The Royal Commission reported that ‘no account whatever is taken of the burden of pauperism, the magnitude of the local rates, or the circumstances of the ratepayers and their ability to pay rates in the different areas.’ Under this system the minimum of relief is extended to the districts in which the weight of taxation is most oppressive. The Commission proposed a scheme by which the old Union grants within each county would be pooled and credited to the common fund in aid of the poor rate in that county. The Viceregal Commission also complained of inequality of expenditure, and advised a reapportionment of the grants in aid of local taxation, on the basis of the recommendations of the minority of the Royal Commission on Local Taxation (1902). That Commission was unanimous in recommending increased grants for Poor Law service in Ireland. The distribution of such new grants would be a matter for discussion; of the necessity for them there is no doubt. The Unionist Party must not rest content with reforming the Irish Poor Law system; it must help the reformed system to pay its own way. No fair-minded Englishman who reads **Sir George O'Farrell**'s evidence as to the distribution of the Irish Church surplus (Report of the Royal Commission on the Care and Control of the Feeble-minded, page 468) will dispute his country's obligations in this matter. The cost of Irish Poor Law Reform is one of the strongest arguments against Home



---

p.310



Rule. The Unionist Party's full and generous recognition of its duty to Ireland in this respect will establish a new argument for the Union.


One vital factor in Poor Law Reform remains to be considered—the Poor Law Medical service. The 740 Dispensary districts of Ireland are now administered by a little more than 800 Medical Officers. The salaries of these doctors, amounting in all to nearly £100,000 per annum, are paid as to one half by the Poor Law Guardians, and as to the other half out of the Local Taxation (Ireland) account. Most of the doctors, in addition to their public duties as servants of the poor, engage in private practice, of which, in most of the rural areas, their offical position gives them a monopoly. A large—perhaps, a surprisingly large—number of the Dispensary doctors are earnest and self-sacrificing men; but the system is corrupted by one radical defect. Owing to the security of private practice involved, there is a fierceness of competition for these appointments out of all proportion to their financial value. The elections are made by the Guardians, and it is a fact so notorious as even to be acknowledged by **Mr. Birrell** that flagrant canvassing and bribery are a common feature of these elections. Candidates have been known to distribute sums of £400 or £500 to Guardians, in order to secure appointments of £150 or £160 a year. Another serious and extending feature of the present system is the boycotting by the Guardians of all candidates who have not graduated at the new Roman Catholic University. The most highly qualified men from the University of Dublin have now practically abandoned competition for these Dispensary offices outside the Protestant counties of Ulster. Moreover, throughout the whole country local candidates are consistently preferred to superior men from outside. Both the Viceregal and Royal Commissions recognise the necessity of radical reform in this system, but they suggest different remedies. The Royal Commission proposes that the election and control of all the Dispensary Medical Officers of a County shall be vested in the Public Assistance Authority for that



---

p.311



County; and that little or no change be made in the present financial basis of the payment of salaries. The Viceregal Commission suggests a bolder and more drastic remedy. It advocates the establishment of a State Medical service on the lines of the existing services in Egypt and India. This would require the payment by the State of the whole, instead of half, of the salaries of Medical Officers. The Commission regards it as proper and equitable that such a service should be, in the beginning, at any rate, restricted to candidates educated in Ireland. A representative Medical Council should elect the candidates by competitive examination, and deal with all important questions of promotion, removal and superannuation. The Commission maintains that the creation of a State Medical service in Ireland would mean a very small increase in the Parliamentary grant in comparison with the benefits involved. This I believe to be the ideal system, but one must recognise that its accomplishment is confronted with many difficulties. The Irish Local Authorities would not willingly relinquish a privilege which is a primary element in their influence and prestige. Irish medical opinion is acutely divided on the question, which is now further complicated by the prospect that the medical benefits under the National Insurance Act may soon be extended to Ireland. It would be outrageous to expect the Dispensary Officers to add the heavy medical duties under the Act to their present responsibilities without adequate payment. Indeed, the extension of the medical benefits to Ireland would make inevitable an early reform of the whole Poor Law system. This is one reason why the Unionist Party, when it returns to office, should be ready to tackle the subject without delay. To no department of the work will it be asked to apply greater sympathy, knowledge, tact and firmness, than to the problems of the Poor Law Medical service.


During the last three years the Irish Unionist Party has made three vain attempts to bring the reform of the Irish Poor Law before Parliament. Its Bill, which now stands in the name of **Sir John Lonsdale**, asks for the



---

p.312



appointment (as recommended by the Viceregal Commission) of a body of five persons with executive powers to carry out the recommendations made by that Commission. These temporary Commissioners would have authority to draft all necessary schemes, to consolidate or divide existing institutions, and generally to reform the whole administration of the Irish Poor Law service. The Bill assigns to them an executive lifetime of five years—hardly, perhaps, an adequate time for the establishment of reforms which, in their making, must affect nearly every aspect of Irish life, and, in their operation, may reconstitute the basis of Irish society. It is to be supposed that, when the whole Unionist Party addresses itself seriously to the question, it will give further and careful attention to the principles of reform before setting up this, or some other, executive machinery. I can think of no more thirsty or fruitful field in Ireland for the exercise of the highest constructive statesmanship that the Party may possess. The need is urgent, the time is ripe, all the circumstances are favourable. The Old Age Pensions Act and the Insurance Act, if not vitiated by further increases in Irish taxation, will greatly simplify the task of Poor Law Reform. The former Act has reduced the number of old inmates in the workhouses; the Insurance Act should lead to a reduction in expenditure on outdoor relief. Moreover, it may be hoped that the infirm and pauper classes will be henceforward, like the old age pensioners, a diminishing fraction of the population of Ireland. They are, to a large extent, flotsam and jetsam over the sea of Ireland's political troubles. Land agitation, with its attendant vices of restlessness and idleness, the emigration of wage-earners, the discouragement of industry under Governments indifferent to the administration of law and the development of national resources, have all contributed to the Dantean horrors of the Irish workhouse system. These poor people are an excrescence on the body of Ireland which good government, if it does not wholly remove, may reduce nearly to vanishing point. Hitherto the chief rewards and blessings of British 



---

p.313



administration in Ireland have gone to the hard voters and to the strong agitators. It is time for the Unionist Party to think of the hapless, the helpless, the voteless, and, therefore voiceless, elements in Irish life. Ireland, as she becomes better educated, gives more thought and truer thought than formerly to her social and economic problems. Her gratitude and loyalty will go in abundant measure to those who take counsel with her about these problems and help her to solve them. The Government which cleans up many sad relics of the past by a complete reform of the Irish Poor Law system will put all Irishmen and Irishwomen under a deep sense of obligation to it. Policy, not less than duty, should give this reform a place in the forefront of the Unionist Party's constructive programme for Ireland.




---

p.314


[70](javascript:footNote('E900031/note070.html'))
### Irish Education under the Union

### By **Godfrey Locker Lampson, M.P.**


Education is probably the most sorrowfully dull of all dull subjects. It is difficult to repress a yawn when the word is mentioned. Yet we owe everything to it that we value most. Through it we become emancipated citizens of the world. Through it we are able to appreciate what is beautiful and what is ugly, what is right and what is wrong, what is permanent and what is merely transitory. If the people of a country can make it their boast that they are truly educated, they need boast of little else, for all the rest will have been added unto them.


It will be found next to impossible to draw any argument for Home Rule from the history of Irish Education during the last decade. Indeed, if a Nationalist Parliament were now to be established in College Green, it is more than probable that the progress made by educational reformers since 1900 would be largely thrown away, and the prospects of still further improvement endangered and perhaps destroyed.


What has been done in the domain of Irish Education, and what still remains to be done? Leaving out of account the problem of the Universities, which, so far as can be seen, has at any rate been temporarily solved—and solved, let it be marked, under the Legislative Union, with the participation and consent of the Nationalist party—there are two broad branches of the educational tree which every year are growing in volume and putting forth finer leaves and fruit. 



---

p.315



Primary and Secondary Education, by far the most important parts of the Irish Educational system, if only allowed to continue their development, tended with care by those who have the interests of the younger generation at heart and left unmolested by the poisonous creepers of political prejudice, will be found to do more for the increase of Irish prosperity and the establishment of national and religious concord than any device for legislative separation that the wit of man can frame. Not that educational reform is not sorely needed. Far from it. There are few aspects of Irish life where reform is more urgently required. But let it be reform, as far as possible, along existing lines of progress, and in full recognition of religious susceptibilities and of certain stubborn facts which may be deplored, but which it would be unwise to ignore. Let it be reform undertaken and pursued on the advice of those who understand this question and are in sympathy with its peculiar difficulties, and let not the Treasury turn a deaf ear to the demands of reason, when a few extra thousand pounds might make all the difference between failure and success. Above all, let it be reform unembittered by the strife of creeds warring for supremacy in an Irish House of Commons. Let it reap the advantages of a continuous policy undisturbed by the rise and fall of local Ministries and the lobbying and log-rolling of sects and factions. Treat it, as it is being treated *today*, in a calm spirit of inquiry and recommendation, and the richest blessing of the Legislative Union will be an Ireland at peace within herself, honoured for her learning, distinguished by her refinement, and intellectually the equal of any nation upon earth.


[71](javascript:footNote('E900031/note071.html'))
#### Primary Education.


The National Board which presides over Primary Education has shown itself, under the Union, singularly free from prejudice, either political or religious. During the last few years it may be said to have changed the face 



---

p.316



of the National schools in Ireland, and in a large part of the country has contributed to make primary education what it ought to be—not a mere glut of random scraps of knowledge, not a mere conglomerate of facts, dates, and figures, undigested and unassimilated, of no practical use to the pupil in his later life, and stifling any constructive powers of thought with which he might have been born, but a system of self-development and self-expression, with the future of the pupil as a citizen in view, rather than his mere monetary value in the shape of school fees. This in itself is a remarkable stride in advance, which the Separatist will find difficult to explain away. Who will be so bold as to calculate the harm which was inflicted by the arid and artificial system of ‘cram,’ introduced in 1871, but now fortunately abandoned in the National Schools, which had only one object in view—the money grant that was made proportionate to the output of heterogeneous lumber that could be retained by the pupil until called for by the examiner? Surely, the great aim of education should be self-culture, the development of the mind, body, and character of the pupil, consideration being had to the career he is likely to pursue in the future. This the National Board has realised in time, and it is owing to its efforts and the co-operation of men and women of all shades of opinion who labour in the schools that such signal improvement has taken place during the last few years.


Apart from this larger question, there are various other features of the National Schools that ought not to be excluded from this brief review. Some of them are evidence of progress made, others of grievances which still require redress. No one will deny that, taking Ireland as a whole, the structural character of the school buildings has been greatly improved in recent years, and that the cleanliness of school premises, which still leaves a good deal to be desired, is attended to with far more care than it used to be. In days gone by, the Board could grant only two-thirds of the estimated cost of a new building of the cheapest and shabbiest description. The result was that, for a whole 



---

p.317



generation, a low standard of school-house was stereotyped, and the requirement of a local contribution entirely prevented the erection of new school-houses in poor districts where they were most needed. The new plans, on the other hand, are designed according to the most modern ideas, and as a local contribution is not insisted upon in impecunious districts, where valuation is low, the Board can grant the whole of the cost where necessary. It is easy to appreciate what a difference this important reform must make, not merely to the landscape or to the comfort and health of the children, but to the general efficiency of pupils and teachers alike. There is, however, still much room for improvement. The grants hitherto given have been sadly inadequate, and in order to provide suitable school buildings, even in those cases alone where the present structures are actually a danger to the health of the children, it would be necessary to make grants at the rate of about £100,000 a year for the next 4 or 5 years, after which they might be reduced to £50,000.


Another satisfactory development is the increase of teachers' salaries which has taken place during the last two decades. In 1895, the average income from State sources of principal teachers in primary schools was £94 in respect of men, and £79 in respect of women. By 1910, it had risen to £112 and £90 respectively. Notwithstanding this, their financial position, especially in large and important schools in centres where the cost of living is high, is not yet as good as it ought to be, if it be compared with that of similarly situated teachers in England and Scotland. As for the incomes of assistant teachers, they also have risen in the same period from £61 for men, and £49 for women, to £81 and £68 respectively, and the money, though still insufficient, is now being paid for a better article. Re-adjustment of numbers in the higher grades of national teachers is also required, so as to enable all efficient teachers who have complied with the conditions of service to receive the increases of salary to which they are entitled.The cost of such a readjustment would be about £1,000 a year 



---

p.318



for the present, but the expense would gradually increase, and might ultimately amount to £18,000 per annum. For the convenience of the profession, it is also desirable that salaries should be paid monthly, instead of quarterly, to the teaching staffs of the schools. The expenditure (non recurring) required under this head would be about £280,000, with an additional yearly sum of £5,000, due to increased cost of administration. That a Dublin Parliament would welcome or even less be able to satisfy these various demands upon its purse without further taxation is extremely improbable, especially in view of **Mr. Birrell**'s warning that the finances of Home Rule would be a very ‘tight fit.’


Since 1900, a period of training has been required from the principals, and this rule has recently been extended to assistant masters. In fact, the qualifications demanded of national teachers in Ireland are much higher than in England. When all the foregoing changes are considered, it will be quite evident that not only must the teachers benefit from them, but that the children cannot fail to benefit as well. Indeed, it is these various reforms which, in all probability, have conduced to a better school attendance than could be boasted of in the past. Many an educational reformer has had cause to wring his hands over the meagreness of attendance in days gone by. Even today it is not as it should be. It is lower than in England and in Scotland, but it has steadily risen, and continues to rise, and stands now at about 71 per *cent*, an advance of between 30 or 40 per *cent* upon what it was less than 40 years ago; a fact which is certainly remarkable, when the poverty of the population and its scattered character are taken into account.


Another evil which the Board has had to fight has been the mushroom-like multiplication of small schools. It is hardly necessary to emphasise what must be a manifest disadvantage for any authority which is trying to raise the standard of educational efficency in a country. This multiplication was largely due to the fact that Protestant 



---

p.319



Schools were accustomed to receive grants when they could maintain an average attendance of 20 pupils, quite irrespective of how many other schools of the same or a similar denomination there might be in the immediate vicinity, and whether they were really wanted or not. How far these grants were conducive to unnecessary multiplication may be gauged from the fact that, whilst there were 6,500 schools in operation in 1871, when the population of Ireland was five and a half millions, there were 8,692 in 1901, or 2,000 more, when the population was a million less. This vast and unprofitable growth in the numbers of educational establishments could be stayed only by drastic regulation. Where neighbouring mixed Catholic or Protestant schools cannot show an average attendance of 25, they are now obliged to amalgamate, and the same result has to follow if neighbouring boys' and girls' schools fall below an average attendance of 30. These regulations have had the desired effect, and no less than 300 superfluous schools have been absorbed in this manner during the last five years.


Before leaving the details of the National Schools, some mention should be made of the conspicuous improvement in the curriculum which has taken place in the first decade of the new century. Formerly, it was hidebound, bloodless, unintelligent, and useless. Now, it does what it can to cater for the practical side of the pupil's future life, and is designed with the object of helping him to think out problems for himself and of equipping him with any knowledge of the historic past which may serve him, not as a collection of antiquities, but as example and precept. During the last twelve years an astonishing advance has been made. In 1899, Hand and Eye training (including Kindergarten) was taught in 448 schools, in 1910 it was taught in 6,010.In 1899, Elementary Science was taught in 14 schools only, in 1910 it was taught in 2,400. In the former year Cookery was taught in 925 schools, in the latter year in 2,665. In 1899, Laundry Work was taught in 11 schools, in 1910 in 691. If this is not progression—and progression under 



---

p.320



the Legislative Union—to what can the predicate be more truthfully applied? Statistics are apt to be barren and uninforming and can be adapted, with almost equal plausibility, to support the arguments of either side; but these figures are eloquent and speak for themselves. They embody a large and vital portion of the history of Irish Primary Education, and are a proof of the interest which is being taken in it and of the activity of the architects behind the scenes. Long may this spirit of progress flourish and enlighten the generations that are yet to come!


It is only fair to say that, amid a good deal of discouragement and not always intelligent criticism, the National Board has proved itself broad-minded and open to argument wherever the interests of Irish Education have been concerned. Although nominated by the Lord Lieutenant, and therefore not an elected body, it has never lagged behind public opinion. In the teaching of the Irish language, for example, it has shown itself peculiarly sympathetic. In fact, the experience of the Board has been, that the Irish parents are not quite so anxious that their children should be taught Irish as the Gaelic League would have us suppose. Indeed, the difficulty of the Board has been to maintain sufficient interest in the subject. Nevertheless, it has done its best. In 1899, teaching in Irish was provided in 105 schools for 1,825 children. In 1911, it was provided for 180,000 children in 3,066 schools, and during the same time bilingual instruction has been introduced into some 200 schools.


In spite of what has been, and is being done, further reforms in primary education are still unquestionably required, and can, moreover, be easily effected without any of the convulsions of a constitutional revolution. The salaries of principals and assistants, especially in large and important schools, ought to be increased. In particular, the Pensions Act needs modification, for, under the present Act, teachers who retire before reaching the age qualifying for a pension receive gratuities considerably less than the Old Age Pensions. Even those who qualify for 



---

p.321



pensions are very shabbily treated if they retire before sixty years of age. Building grants also should be increased, so that the constant applications for the rebuilding of bad premises could be met.[72](javascript:footNote('E900031/note072.html')) The teaching of infants, greatly improved by the institution of junior assistant mistresses by **Mr.Walter Long** during his Chief Secretaryship, can be still further improved and brought up to the English standard; and the efficiency of primary education generally can be promoted in the direction of sympathetic appreciation of the real needs of the children, regarded from the point of view of thinking human beings, and not merely as recording machines.


The following desirable improvements may also be mentioned:—

1. (a) Encouragement of the teaching of gardening in connection with country schools for boys, at a cost of about £2000 a year.
2. (b) Provision for instruction in wood-work for pupils of urban districts, at central classes in technical schools, at a cost of about £4000 a year.
3. (c) The provision of medical inspection and the treatment of school children, which would cost about £30,000 a year, and dental inspection and clinics, which would cost another £50,000. This expense should be defrayed largely out of the local rates, one third, say £25,000, to come out of the estimates. There would also be the cost of supervision, etc., by the Education Department, amounting to about £5000 a year. Committees, as for school attendance, composed partly of representatives of school managers and partly of local authorities, could be formed for administration.
4. (d) A considerable impetus might be given to Evening 



---

p.322



Continuation Schools, on which about £10,000 a year is at present spent. A beginning could be made of compulsory attendance, and the amount of the grant doubled.



Much might be done in all these directions. Much has been accomplished already. The worst that can happen is that a separate legislature should be set up in Dublin, devoid of the requisite means, as it would most certainly be (unless, indeed, it had recourse to the rates, or the taxpayer) of financing Irish Education; swayed from side to side by the exigencies of the party programme of the moment; and temperamentally unable to look at the educational problem from the standpoint alone of the needs of the country in the way that it is now regarded. At present, under the Union, Irish Education is fortunately liberated from all appeals to party passion, and organised with but one end in view, the upbringing of the infant race whose possession is the future.


#### Secondary Education


The need for reform is more urgent and, in many respects, better defined in the system of Secondary than in that of Primary Education in Ireland. But the two ought to be closely interconnected, and in discussing one at least of the more important changes which it is desirable to introduce, the National Schools have as good a claim to be heard in the matter as their elder brethren.


Since 1900 great efforts have been made by the Intermediate Board to promote the interests of Secondary Schools and to supply the educational needs of those who want to equip themselves for the struggle of life in its various departments. In 1900, the Board of Intermediate Education was empowered to appoint inspectors, but it was not until quite recently, after many fruitless applications and under a threat of resignation by the Board, that inspection was placed on a business-like footing and a permanent staff of six inspectors appointed. But this, after all, is a comparative detail, and 



---

p.323



reform will have to strike deep indeed if the secondary schools in Ireland are to take their place as a living part of a living body.


The question of reform may be dealt with under three principal heads: (1) the abolition of the examination tests, (2) the inter-relationship between the Primary and Secondary systems, and (3) the position of teachers. Although there are other matters which will be briefly referred to, these are the three cardinal difficulties that beset the Intermediate Board *today* and obstruct the most public-spirited efforts to convert the Irish educational system into one organic whole.


(1) Although the mischievous principle of fees by results has disappeared for ever from the National Schools, it still clings to Intermediate Education, numbing and constricting, like some remorseless ivy limb, the growth and free exercise of the central stem and its branches, and preventing the natural sap from rising and vitalising the whole. It is not as though the rest of the world had set the seal of its approval upon this kind of examination. The contrary is the fact. Almost every country in the world has rejected this system as wholly pernicious, injurious for the pupil, demoralising for the teacher, and wasteful for the State. To regard the youth of the Secondary Schools merely as the geese that lay the golden eggs when the examinations occur, is to destroy the true aims of education and pervert the principle of rational development. In fact, payments to Intermediate Schools ought to depend largely on the results of inspection, and much less on written examinations, a change which would involve the appointment of a larger number of inspectors than at present exist. It is all important that this alteration should be undertaken without delay. The mechanical agglomeration of lifeless snippets of information which characterises the present method is an absurd and antiquated remnant of the bad old times, and the sooner this part of the system is hewn down the better it will be for the conscientious discharge of the teacher's duties and the self-respect of all concerned.




---

p.324


(2) As for any proper official relationship between the Primary and Secondary systems, it may be said as yet to be practically non-existent. That co-ordination of the two is essential—nay, vital—if Irish education is to be placed on a sound footing, may be appreciated from the fact that a large proportion, or 57 per *cent* of the membership of Intermediate Schools is recruited from the schools of the National Board. There seem to be only two ways in which this co-ordination can be satisfactorily effected. Either the pupils must transfer from the National to the Secondary Schools at an age when they will be young enough to profit by Secondary instruction, or some sort of higher instruction must be given in the National Schools so as to fit the children, when they leave the latter at rather a later age, for the curriculum awaiting them in the Secondary system. It is the Treasury at the present moment, and the Treasury alone, that blocks the way to this reform. Since 1902 it has been asked to sanction the establishment of higher grade schools in large centres; the National Board also has repeatedly pleaded for the institution of a ‘higher top,’ or advanced departments, in connection with selected Primary Schools in rural districts. But all these requests, founded though they have been on intimate knowledge of the requirements of Irish Education and a ripe experience ranging over many years, have been brushed aside by the officials at the Exchequer, although the cost would be only about £25,000 a year, on the very insufficient ground that the Development Grant has been depleted to defray the loss of flotation of stock for the purposes of land purchase. What, in the name of common sense, has land purchase to do with education? What indissoluble relationship is there between the two that the expenditure upon the one should be made dependent upon the requirements of the other? This niggardly and short-sighted attitude is hardly worthy of one of the richest countries in the world. It is but a matter of a few thousands, and surely the efficient training of the youth of Ireland is quite as important as buying out the Irish landlords and placing the Irish tenant in possession of



---

p.325



the soil. The result of the present want of co-ordination is that the clever pupil is now kept far too long in the lower school. There he remains, kicking his heels until he is sent up to the Intermediate School at 15 or 16 much too late an age at which to begin the study of languages. The Primary teachers are, of course, only too pleased to retain the clever boys as long as possible in the National Schools, but it is unfair to the children, and is robbing the community of services which might be rendered to it by these pupils in the future if fair opportunities were afforded them of training themselves while there was yet time. Without higher grade schools, without scholarships, without at least some system of a ‘higher top’ in connection with the Primary Schools, there can never be proper co-ordination of administration, and education in Ireland will never be able to progress beyond a certain point. The Christian Brothers have set the Treasury a good example in this matter. In their schools there is close co-ordination of primary and intermediate education. Promising boys in the fifth standard are removed when they are 11 or 12 years of age into the higher schools and thus given an opportunity, at the most receptive period of their lives, of acquiring knowledge which they will be able to turn to good account in after life. Over and over again has the National Board attempted to persuade the Treasury to adopt a similar system, but hitherto without avail. The crust of the official mind has been impervious to every appeal. There seems, indeed, to be now some chance of the establishment of scholarships for pupils in primary schools, but unless an intelligent mind is brought to bear upon it, and the scholarships limited, as in England and Scotland, to pupils under 12 or 13 years of age, the same unfortunate result will follow, as in the case of the Society for Promoting Protestant Schools and other similar bodies, where the scholarships have turned out to be a practical failure. An exception, however, as suggested by **Dr. Starkie**, and as allowed in Scotland, might be made in favour of the best Primary Schools. That is to say, where satisfactory Secondary teaching is given at a Primary School, the pupil



---

p.326



might be relieved of one or two of the three years he is obliged to spend in the Secondary School before he can compete for the Intermediate Certificate which is awarded at 15 years of age.


The argument is sometimes used that the establishment of higher grade schools would lead to unfair competition with the Intermediate Schools already in existence. No one desires to do this. Where the Intermediate Schools already hold the field, such overlapping can easily be avoided by proper administrative co-ordination between the National and Secondary systems. Where, on the other hand, there is a dearth of Intermediate Schools, as in Connaught and Kerry, higher grade schools can, and should be established without any risk either of overlapping or competition. They would supply a want which is deplored by all educational reformers, and make their influence felt far outside the mere circle of the schoolroom. A private commercial school has already been founded in Kerry and has continued for some time without State help, but, through want of encouragement, it has recently been compelled to adopt the programme of the Intermediate Board, which is entirely unsuited to its particular aims. Surely, private enterprise of this kind ought not only to be welcomed, but stimulated by a State grant, and everything possible done to encourage schools to develop along their own lines. At the present moment, they are bound hand and foot by the examination rules of the Intermediate Board, and it is quite impossible for any central authority, however eagle-eyed and sympathetic, to appreciate the peculiar atmosphere and wants of every locality. In such cases, local initiative is far more valuable than red tape, and more likely to result in an intelligent interest in his pupils and subject on the part of the teacher.


(3) The position of the Secondary teachers, especially of lay assistant teachers, cries aloud for reform. In fact, their case is an acknowledged scandal. How can any one expect that the training of the youth in the Secondary Schools can be really satisfactory when the teachers 



---

p.327



are so miserably underpaid, when the elements of self-respect are given no room in which to develop, and the whole profession are treated rather as beasts of burden than as a noble and responsible body to whom is entrusted much of the destiny of the race? The question of reform is here largely a question of money. There are signs that this fact is becoming more appreciated as the years go by, and it is devoutly to be hoped that before long the teaching profession in the Secondary Schools will have no more to complain of than the Primary teachers, or than is usual in even the most cared-for and prosperous professions in this our imperfect world. Salaries, pensions, a register, security of tenure, opportunities of proper training—these may be said to embody the chief requirements of Secondary teachers at the present moment. In existing circumstances there is no attraction for competent men and women to enter the teaching profession so far as Intermediate education is concerned. The most incompetent crowd into it, although there are many exceptions, and teaching is regarded as a stop-gap during periods of impecuniosity rather than as a permanent career to be proud of and to be worked for. The salaries are beggarly—considerably lower than the incomes of the teachers in the Primary Schools. In 1908, the average salaries of principals in the Primary Schools were £112 for men and £90 for women, and in the County Boroughs £163 and £126 respectively, whilst in the Secondary Schools lay assistants were paid about £80 per annum. In view of this, surely the demand that is being made on behalf of highly qualified Secondary teachers is not exorbitant, namely, salaries of £100 to £300 for men and of £80 to £220 for women. If the maximum rate were £150 for men and £100 for women the cost would be £220,000 a year. Where is the money to come from? Will a Nationalist Parliament be prepared to find it, and if so, from what source? Ireland is a comparatively poor country and is not in a position to bear much more taxation. The Intermediate Board, with its present resources, cannot



---

p.328



afford to step into the breach, and the only solution seems to be that the British Exchequer should come to the rescue and that the Board should be granted the means of dealing with this all-important matter, the neglect of which is having a most injurious effect upon the efficiency of the Intermediate Schools. It has been suggested that a half-way house might be found, that the Treasury should grant £60 for each assistant master and £40 for each assistant mistress, and that the remainder should be raised by the authorities of the schools under the direction of the Board. This alternative scheme would cost the State about £88,300 a year, but, like all makeshifts, would not effect a real settlement of the difficulty, creating, as it would, a patchwork system of payment which might break down at any moment. On the other hand, let the settlement be a generous one, and the return will be a hundredfold in added efficiency, a higher sense of duty, and an increased personal interest on the part of the teacher in the class of which he has charge.


In close connection with the question of salaries are those of pensions and security of tenure. The pensions of the Primary teachers, inadequate though they be, would be looked upon as a provision of the most munificent kind by the poor men and women who enter service under the Intermediate system. The Primary teachers, moreover, can call back upon subsidiary occupations if they find that their salaries are insufficient for their maintenance. They can run a little farm or keep a shop or do other remunerative work, but the assistants in Secondary Schools are debarred from these methods of supplementing their exiguous wage. Those terrible words might, without any extravagance, be inscribed for them over the doors of their schools: *All hope abandon ye who enter here.’’*

 Something must be done. A starvation wage, with an adequate pension to follow, might be tolerable, a decent wage, without any pension, might be borne, but starvation at both ends is a disgrace to the Treasury while it lasts and one of the things which should be taken in hand without any further delay.


---

p.329


Security of tenure is equally important. How can a teacher be expected to devote the whole of his mental energies to his scholastic duties, how can any one expect him to throw himself heart and soul into his work, if there is always lurking in his mind the haunting fear of dismissal through no fault of his own? It is unreasonable to suppose that any human being can give of his best under these distracting conditions. In the National Schools a system of appeal has been in force for some time, and has been carried out with fairness on the part of those in authority and to the apparent satisfaction of the teaching profession. The dismissal order of every Roman Catholic manager has to be countersigned by the Bishop of the Diocese, and in the case of all teachers an appeal is now allowed to the Board itself, and is often utilised by Protestants. In fact, so far as the National Schools are concerned, the tenure of the Primary teachers during good behaviour is practically secured. Why cannot similar safeguards be introduced into the Intermediate system? An appeal to the Board in this case is not proposed by those who know all the circumstances best; but teachers in Roman Catholic schools might have the right of appeal, in the case of Diocesan Colleges, to the Bishop of the Diocese, or in the case of schools under religious orders to the Provincials or Generals, and Protestant teachers might be allowed to appeal to the Board of Governors of their schools, or they might sign an agreement, providing for a referee, such as the No. 3 and 4 agreements under the National Board.


A register of teachers is also required. Every existing teacher in the Intermediate Schools who satisfies the tests of efficiency should be placed upon it without delay. As far as future appointments are concerned, qualifications might be adopted similar to those which now obtain in the Scotch Department, e. g. (a) a degree in a University, or its equivalent; (b) a diploma following professional training for one year; and (c) two probationary years in a good school. Special terms would probably be demanded for 



---

p.330



those who, like Nuns, are precluded by their calling from attending Lectures at a University.


These are some of the reforms which could, and should be introduced to make the teaching profession more efficient, more attractive for competent and clever men and women, and more of a permanent and honourable career than it has been in the past. Once again, it is not unreasonable to ask—How will a Dublin Parliament be able to provide the necessary funds? An extra annual sum of roughly £300,000 is required, in addition to a further sum of about £330,000 to meet non-recurring expenditure. These are, admittedly, moderate estimates. The matter, anyway, is now ripe for settlement, and procrastination can only aggravate the financial difficulty. So far as the educational problem is concerned, it is a manifest obligation upon the Nationalist Party to outline their proposals for the redress of these grievances, and to indicate the means by which they can be carried out, before a separate Legislature is set up for the people of Ireland.


Within the scope of these few pages it is not possible to comprise all the aspects of modern Irish Education which are worthy of discussion. What are most urgently needed *today* are the necessary funds to continue the good work which is being done, and to introduce the reforms that have been sketched above. Parsimony in educational matters is the most wasteful of all misplaced thrift. Let the reformers be dealt with wisely and generously, and the harvest will exceed even the expectations of those who are working most hopefully upon the problem. Withhold the funds on some niggardly and mistaken principle of petty economy, and the present progress will be discouraged and the educational tree become stunted in its growth. From an administrative point of view, nothing, finance apart, would contribute more to the efficiency of Irish Education than the amalgamation of the National and Intermediate systems, as well as of the Technical work at present administered by the Department of Agriculture and 



---

p.331



Technical Education, under one Board. The method of examination by the Department is far sounder than that which is forced upon the Intermediate Board by the Acts of Parliament under which it works. In the case of science, the two are to be seen working *today* side by side in the Secondary Schools, to the undoubted benefit of the scientific course, which enjoys a double subsidy from the State, and is subject to the superior method of examination by the Department, being treated as a detached subject and the candidates being passed en bloc. On the other hand, the obsolete method of examination by the Board tends to the serious disadvantage of the classical curriculum, the grants being made on the unprofitable results of a general examination of individual candidates, the class not being regarded as a whole, as is the case with the Department. By the repeal of the Intermediate Acts, and by the amalgamation of the various Boards into one, these anomalies would rapidly disappear, and for the first time a genuine system of co-ordination could be introduced into Irish Education, which would knit together the strength of all the parts and overcome many of the prevailing weaknesses, making the whole system what it ought to be, a living, growing, pulsating organism, developing and shaping itself with the life of the nation.


Is it conceivable that all this can be accomplished if the Union between the countries is rent asunder? What chance will there be of effecting this great settlement, which requires money and, above all, requires peace, when Ireland is plunged once again into the old internecine struggles of the eighteenth century? The warning is writ very large upon the wall, so that he who runs may read. The best hope for education in Ireland are the resources of Great Britain and a uniform policy undisturbed by party feuds. Neither of these can be looked for under a separate Parliament. Under the Union Ireland can have both, for the welfare of her children and the building of a noble history.




---

p.332


### The Problem of Transit and Transport in Ireland

### By an Irish Railway Director


Any scheme giving self-government to Ireland must seriously affect the problem of local transit and transport, by rail and water, which all parties in Ireland agree to be pressing and important. Nor is it merely a local question. As recent returns show, the trade between Ireland and Great Britain has of late years enormously increased, to the great advantage of both; for if Irish farmers profit by the export of beef, mutton, milk, eggs, butter, bacon and other articles, Great Britain has the benefit of a near food supply within the United Kingdom. Nor does any one doubt that this trade is capable of enormous increase. The improvement of Irish agricultural methods, the growth in England of a town population, the increased price of the necessaries of life, are some of the factors pointing in this direction.


If this trade is to expand, Irish traffic routes and facilities with Great Britain must be improved and increased, especially as the articles carried are largely of a perishable kind. Moreover, the internal traffic of Ireland by rail, waterways, and canals is capable of and needs great development, as witness the recent Reports of the Viceregal Commission on Irish Railways, and of the Royal Commission on Canals and Waterways [73](javascript:footNote('E900031/note073.html')) The problem of inland navigation is again intimately bound up with that



---

p.333



of arterial drainage, as the Commissioners have reported. It is then strange to find, that on these pressing questions of first importance, there is an almost absolute silence on the part of those who advocate Home Rule in and out of Parliament.


#### Solution of Transit Problem impossible inder Home Rule


It is true that the nationalisation of the Irish railways has in past years found the keenest advocates amongst individual members of the Home Rule Party; that the Majority Report of the late Viceregal Commission favouring State purchase of the Irish railways was formally approved of by the Parliamentary Party, and that **Mr. Redmond** has named ‘transit’ as one of the special matters that should be left to be dealt with by an Irish Legislature. But there the matter ends. We are not given the slightest inkling what is proposed to be done on this matter, or how it will be done, or the slightest proof that under any system of Home Rule, the financial difficulties of the problem can be solved at all.


The Reports of both the Commissions referred to are based, first on the continuance of the present system of laws and government, and secondly, on the use of Imperial credit to the tune of many millions. Yet amongst the shoals of literature on Home Rule problems and finance, I can find no enlightenment as to how the transit problem is to be solved under the new conditions; i.e. how any Home Rule Government, whether it has control of Customs and Excise or not, and however it economises, is to find the money necessary to buy out the Irish railways and canals. A Government that is faced with the problems of poverty and congestion, of housing, of increased educational grants, of afforestation, and of arterial land drainage, will have an almost impossible task in raising money for these purposes alone. And, let those who can, inform us how an Irish Parliament and Executive (with all else they will 



---

p.334



have in hand), will be able to raise even the £5,000,000 necessary to improve the Irish Light Railway System; not to speak of the sum at least tenfold greater which will be required for a complete purchase scheme.


So far we are without that information. The Irish Parliamentary leaders have not touched upon the point. The pamphleteers are almost equally silent. **Professor Kettle**, in his ‘Home Rule Finance,’ mentions the ‘Nationalisation of Railways’ in one line of print, merely stating that ‘the project will have to be financed by loans and not out of annual revenue’ (p. 41); and he further remarks, generally (p. 72), ‘that for the development of any future policy, approved by her own people, Ireland relies absolutely on her own fiscal resources.’ What fiscal resources, and under what conditions are they obtainable?


In the volume entitled ‘Home Rule Problems’ issued by the Liberal Home Rule Committee, with a preface by **Viscount Haldane**, not one word is said on the subject, though there are chapters on Irish finance, and on Irish commercial and industrial conditions. Neither has **Mr. Stephen Gwynn** a single word on the subject in his Case for Home Rule, though he makes the large assertion that ‘there is no country in the world where resources are more undeveloped than those of Ireland.’


**Mr. Erskine Childers** [74](javascript:footNote('E900031/note074.html')) merely refers to the Irish railway problem as one that is ‘obvious and urgent,’ ‘which no Parliament but an Irish Parliament can deal with, and which calls aloud for settlement.’


#### Details of Railway Transit Problem


Let us now look at the problem in more detail; and first is the question of the railways. The property to be dealt with consists of 3411 miles of railway, representing a total capital of £45,163,000, of which, at the date of the Report of the Commission, £2,873,000 paid no dividend;



---

p.335



the gross annual receipts of the whole system being £4,255,000 and the net receipts £1,690,000, representing a return on the whole capital of 3.77 per cent.[75](javascript:footNote('E900031/note075.html'))


Of these lines, the railways constructed under the Tramways and Light Railways Acts cover 603 miles, of which 322 are narrow gauge, involving a liability on various baronies which have guaranteed interest on capital to the amount of £36,000 per annum. To bring these light railways up to a proper standard and equipment; to widen the gauge in many cases; to provide new sheds, stations, and rolling stock, and redeem the guarantees, a sum of about £5,000,000 would probably be necessary. In addition, projects for no less than eighty-three new railways were brought before the Commission[76](javascript:footNote('E900031/note076.html')) and it is admitted on all hands, and the Commission find, that practically none of these railway extensions would be undertaken by private enterprise, and that these developments need the credit, help, and direction of the State. Even the necessary improvement of the existing light railways cannot now be undertaken, for under the system of legislation under which they were constructed, there is no means of raising new capital.[77](javascript:footNote('E900031/note077.html'))


Now, what is advocated by the Majority Report is the—

*compulsory purchase by the State of these railway systems great and small, to be then worked and managed by an Irish elected authority as one concern, mainly with a view of developing Irish industries by reduction of rates and otherwise, and not strictly on commercial principles.’’*

Final Report, pp. 76-83.


This was the scheme supported by the Parliamentary Party, written up unceasingly by the Freeman's Journal, and held out under the term ‘Nationalisation of Railways,’ as one of the special boons which Home Rule will bring to Irish traders and farmers.


But mark how the operation is to be carried out. The



---

p.336



Commission reported that the sum required should be raised by a railway stock charged primarily on the Consolidated Fund of the United Kingdom, with recourse to Irish rates to make up possible deficiencies, and further, that there should be an annual grant from the Exchequer of not less than £250,000 to the Irish railway authority. Seeing that the Commissioners refer to ‘the financial terms prescribed by the Act of 1844’ (Regulation of Railways Act, 7 & 8 Vict. c. 85, ss. 2-4), and that a *cash* payment to shareholders was provided for by that Act, it is to be presumed that the Commissioners intended Irish shareholders to be paid in cash. The Act of 1844 provided for payment to the companies of a sum in cash equal to twenty-five years' purchase of the previous three years' annual profits; but this was the minimum only, for it was provided that the companies could, under arbitration, claim additional payment in respect of future ‘prospects.’


Now twenty-five years' purchase of the divisible profits, which at the date of the Commission, were £1,690,000, would amount to over £42,000,000, and if in addition sums had to be raised for ‘prospects,’ purchase of lines paying no dividend, special provision for prior stocks standing at a premium, redemption of guarantees, and the large sums required for the extensions and improvements we have mentioned, a sum not less than £50,000,000, and probably nearer £55,000,000, would be required.[78](javascript:footNote('E900031/note078.html'))


From the beginning to the end of the inquiry there was no suggestion that this immense operation could be carried out except by the use of Imperial credit, involving the two conditions: (1) that the Consolidated Fund of the United Kingdom be charged, and (2) that the British public be asked, and should be willing to find the money. Although



---

p.337



the Majority Report contemplated an Irish elected authority to work the railways so purchased and amalgamated, it was never suggested that any such Irish authority could raise the necessary purchase capital, or, indeed, any portion of it. The whole scheme from beginning to end pre-supposed the continuance of the Union, with its advantages of credit and capital. Upset that Union, establish an Irish Parliament working out its own salvation, financially and otherwise, and the basis of the whole scheme of railway nationalisation vanishes.


That the British Government should allow its credit to be used to the tune of fifty millions, after full legislative executive and taxing powers were handed over to an Irish Parliament, is too fantastic to be considered seriously. Whether an Irish or English authority controlled the working of the railways would under such circumstances make little difference, with the Courts of Law, the Executive, and Police in other hands than that of the Government guaranteeing the interest. The security for the advance would be imperilled; and, indeed, it is doubtful whether a tenth of the money required would be advanced, even in London, on those terms. For a similar reason any formal pledge of Irish rates and taxes, to make up deficiencies in working, would be illusory. At any rate, if Irish Land Purchase is to be continued under British credit (and it certainly will be a prior claim and charge), it is idle to expect Parliament to undertake the vast additional obligations involved in Irish railway nationalisation. Parliament would pay the piper but could not call the tune.


#### Irish Credit not Sufficient


There remains the alternative of the new Irish Parliament financing the operation. This it must do by means of payment in cash to the selling shareholders, for reasons which will be hereafter stated, unless it wishes to start its career by a scheme of spoliation, which would not merely rob the shareholders (who are mostly Irish), but would 



---

p.338



destroy the credit of the Irish Government. **Mr. Redmond** has recently acknowledged that a large number of Irish railway shareholders are good Nationalists; and it is certain that a great portion of the ordinary stock is held by Irish farmers and traders; and much of the preference and debenture stocks are also held by Irish charities, convents, diocesan trustees, and monastic institutions. These persons will expect, and justly expect, cash on a compulsory purchase, on basis of market value, or capitalisation of dividend, so as to secure the same return of interest.


Could the Irish Government borrow £50,000,000, and at what rate? To borrow at a higher rate than the present return on Irish railway capital, namely, 3.77 per cent, would be to incur a loss on working the railways, from the outset, which Irish ratepayers or taxpayers would have to make up. The net receipts, at the time of the Commission's Report, were, in round figures, £1,600,000, and thus to borrow £50,000,000, even at 4 per cent, would mean an annual loss of £300,000 a year, even if there were no sinking fund. A 10s. per cent sinking fund would increase the total annual loss to £550,000.


But, could an Irish Government Guaranteed Railway Stock be issued at 4 per *cent*? Would Ireland's credit stand better than that of Hungary, whose 4 per *cent* gold *rentes* stand at 92, or of the Argentine, which has to borrow at nearly 5 per *cent*? There are grave doubts whether the large sum required would be subscribed at all, at even 4.25 per *cent* or 4.5 per *cent* basis. It is not likely that English investors would take up such a loan, seeing that they have consistently fought shy of Irish investments, and they are not likely to change their views upon the break up of the Union.


It may be said that the sum required could be raised in Ireland— that patriotic feeling would stimulate the operation, and the large sum of money (over £50,000,000), lying on deposit at the Irish banks may be referred to as available. Patriotism that has not financed the Irish Parliamentary Party will not be likely to finance a gigantic



---

p.339



railway loan. Nor is the large sum appearing as banking deposits really free money available for investment. With increase of deposits, the items of loans and advances in banking accounts have also correspondingly increased, and they largely balance each other. Not only is the money deposited by one customer lent to another, and therefore already utilized, but, to a large extent well known to bankers, the deposits, i.e. the credits to particular accounts, represent money lent to the persons having these accounts, and are not, in fact, their own free balances. So also credits in the accounts of one bank, figure as debits on the balance sheet of another bank. There probably has been in recent years considerable saving in Ireland, but it is also certain that those savings have largely gone, and will continue rightly to go in improvements of farms, which the Land Acts and Land Purchase Acts have made worth improving for their possessors. Those who have not saved enough borrow, and the bank advances represent largely the capital required by farmers and traders. The deposits, therefore, are being well used, and are not dead money. Divert them to any large extent to another purpose, and there will probably be a contraction of banking credit, which Irish farming and industry will be the first to feel.


#### Purchase by State Paper


It may be said that the nationalisation of railways could be carried out, not by a cash payment, but by a paper exchange of existing Railway Stocks into newly created Irish Government Stock, the amount of the existing net receipts being guaranteed. But, unless the Irish Government could actually borrow in cash the sum required, at a rate equal to that nominally put on the new stock, the shareholders would be robbed of a capital sum equal to the amount of the discount on the stock, i.e. the amount of the market quotation below par, or issue price. There will be sellers of the new stock from the beginning, and what the public will give for it, and not the nominal figure



---

p.340



put upon it by the Irish Government, will be its real value. The Irish Government may issue the Railway Stock at 3.5 per *cent*, but if they could borrow the sum required only at 4.5 per *cent*, the new stock will at once find its level at about 77 instead of 100, and the capital value of Irish railways will be reduced from, say, £45,000,000 to £35,000,000, and the difference, £10,000,000, would come out of the pockets of Irish shareholders. The Irish Government would be, however, in this unpleasant dilemma, that if they issued the stock at a rate per *cent* nominally higher than the present return in railway capital, namely, 3.77 per *cent*, the annual charge for interest would be greater than the net receipts, and so from the beginning there would be an annual loss; and the fact of this annual loss would be another factor tending to depreciate the new Railway Stock. The alternatives before an Irish Prime Minister, pressed to carry out a ‘Nationalisation’ policy, are not enviable. He will either have to provide by taxation for the annual loss involved in taking over the railways on a fair basis, or to deprive the most thrifty and industrious classes of his fellow-countrymen of a large slice of their savings and investments. In either event, the new Government will have received a serious blow to its credit at the outset of its career.


#### Effect of Reduction of Railway Rates


There is, moreover, a special reason why such a stock, from its inception, would tend to depreciate in value; namely, that from the moment the Irish Government or their nominees became the owners, there would be almost irresistible pressure put upon them to reduce the railway rates, and generally (as indeed the Majority Report recommends) to work the railways on other than commercial lines[79](javascript:footNote('E900031/note079.html')). A reduction of rates has been held out as the great resulting boon of nationalisation ever since the Irish Parliamentary Party specifically raised the



---

p.341



question in Parliament in 1899. A 25 per *cent* reduction in rates and fares (suggested by Nationalist witnesses) would involve an annual diminution of net receipts to the Government of over £1,000,000 per annum, and if the reduction were in goods rates alone, the loss would be £568,000 per annum. It would be years, if ever, before such a loss could be recouped, however the traffic was increased. Experience has shown that in recent years running expenses tend to increase nearly parallel with the gross receipts, and a large increase in gross traffic would involve enormous capital outlay for rolling stock, engines, sidings, etc. It is unnecessary to comment upon the suggestion that the railways should not be run on ‘commercial principles.’ The Irish ratepayers and taxpayers, who would have to bear the loss, would loudly call out for business management when it was too late.


It is hardly necessary to add that another result of such an operation would be to prevent the Irish Government raising the very large sum necessary for improving and standardising the light railways and for extensions, except at an unremunerative rate of interest. Even if shareholders be put off with State paper, contractors will have to be paid with cash. Moreover the creation of such a large amount of debt at the beginning of the new régime would render it difficult, if not impossible, for the Irish Government to raise sums necessary for other public works and services of a pressing character, arterial drainage, canals, education, and other objects, not to speak of migration, congestion, and land purchase. The conclusion, in fact, is inevitable, that without the security of the United Kingdom, and the market of British investors willing to lend, it is idle to think that either State purchase of railways, or any other of the boons mentioned, are reasonably possible. **Mr. Erskine Childers**, though a Home Ruler, does not fail to perceive, to use his own words, ‘that financial independence will now mean a financial sacrifice to Ireland.’ [80](javascript:footNote('E900031/note080.html'))




---

p.342


#### Effect of Nationalisation on Trade Relations


There are other important considerations which confirm the view that, if the control of Irish railways were taken away from the Imperial Parliament, and placed under a Parliament sitting in Dublin, and if the general code of railway legislation now binding on both countries could be altered by a Home Rule legislature, results disastrous to the trade between the two countries would probably follow, whether ‘Nationalisation’ were carried out or not.


The Majority Report recommends, as one of the chief objects of ‘Nationalisation’ under an Irish authority, the reduction of *export* rates, both local and through rates, on the Irish railways, as ‘essential to the development of Irish industry,’ and this seems the pet project of a large number of witnesses, and of Irish local authorities. Import and export railway rates are now the same for the same classes of produce, and no Irish railway company could now differentiate between them, without being pulled up by the Railway Commission at the suit of British traders, or British railway companies. The policy suggested is practically to use railway rates as a system of local protection, similar to the existing practice and policy on the continental, and notably the Prussian State Railways. It is easy to see that without any Customs barrier between the two countries, such a policy would inaugurate practically a tariff war between Ireland and Great Britain, which would be disastrous to both. That such a policy should be subscribed to by Free-traders, and that a Free-trade Government should advocate a change in the relations between the two countries, under which such a system could be possible, is indeed surprising. To use Imperial credit for such a purpose would be midsummer madness. Even without any scheme of nationalisation, the establishment of a separate Executive and Legislature in Ireland might have sinister effects on traffic arrangements between Great Britain and Ireland and on the harmonious administration of the railways.




---

p.343


#### The Right Solution


The truth of the matter, and the inference to be drawn from the above considerations and the whole trend of modern trade, is that to break up the railway systems of Great Britain and Ireland into two rival and hostile systems of transit, working for different objects and by different methods, would be to stop a natural and healthy process of uniform working and harmony, which has enormously advanced in the last decade, to the great advantage of Ireland.


Almost every scheme of amalgamation in Ireland has been connected with the opening or development of a new cross-Channel route, as the history of the Fishguard and Rosslare and the new Heysham routes fully shows. As part of this process, English companies, like the Midland and the Great Western, are either acquiring Irish lines or making special traffic arrangements with them. Enormous sums have been spent on harbours and steamers by English companies for the purpose of developing traffic with Ireland, and the increased interchange of goods has been of great advantage to both countries. The ideal put forward by advocates of railway nationalisation and Irish independence, that in respect of trade and traffic Ireland should be a sort of watertight compartment, self-supporting and self-contained, is, I submit, a mischievous delusion which, if put into practice, would undo much of the good progress Ireland has recently made. Such an ideal would also be the exact contrary of the line of national development as based on transit and transport followed in almost every other civilized country. In Germany, Canada, the United States, and Australia, we see the policy consistently pursued of amalgamation, consolidation, and facilities for long-distance traffic, so that between all parts of each State and Empire there shall be the freest and most perfect interchange of traffic. Canada and the United States have been so far inspired by this principle as to spend countless millions first on East and West (and now on



---

p.344



North and South) lines, even before there was traffic to carry, and in order to create traffic; and the principle has been justified in its results.


From this point of view St. George's Channel and the Irish Sea should be a means of communication, constant and in every direction, between the two Islands, and not a sort of boundary ditch to be deepened and rendered difficult of passage.


If Ireland wishes to share England's prosperity she must not build up a wall against the credit, trade, and special products of her richer sister. If England wishes to have and to foster a magnificent source of food supply, well and strategically secured against continental foes, she also must do all that can be done to encourage intercourse. To develop traffic between Great Britain and Ireland is the policy which both experience and theory point to as advantageous to both countries; to subvert this policy and make Ireland's commerce local and self-sufficing, seems to be the narrow and mistaken ideal of Nationalist aspirations.


#### Unionist Policy


It follows that the Unionist Party must oppose any plan for ‘nationalising’ the Irish railways, whether by the credit of the United Kingdom, or otherwise. The policy we advocate is to be found in the Minority Report of the Viceregal Commission, signed by **Sir Herbert Jekyll**, **Mr. W. M. Acworth**, and **Mr. John Aspinall**, not as politicians, but experts; and in the Report of the Royal Commission on Canals and Inland Navigation dealing with the question of canals and water transport in Ireland.


In the case of railways, the aim should be to amalgamate them into two or three large companies to standardise as far as possible the light railways, and level them in respect of gauge, gradients, works, and rolling stock with the larger companies. Unquestionably many of the smaller railways to be amalgamated, though not light railways, need large expenditure for the purpose of duplication of running lines,



---

p.345



straightening of curves, stations, stores, and conveniences, and many extensions and cross-lines will also be needed to connect them with the trunk lines, and to open out districts now unprovided with railway facilities. Many of these projects, though industrially remunerative to Ireland and advantageous to England also as tapping new sources of food supply, would not be, in strictness, commercially remunerative in the sense of giving fair return on capital over working expenses, and it is idle to expect that private capital will ever be subscribed for these purposes. They can only be undertaken either directly by State funds, or by money provided by the State, and lent to the large amalgamated lines at low interest. This is the policy inaugurated by **Mr. Arthur Balfour**, which has been of untold benefit to many districts in Ireland. Probably a public grant of, say, £2,000,000, and loanable money available to the extent of £8,000,000, would largely solve the problem. For the reasons already given it is only by Imperial credit, and under the aegis of a united Parliament and Government, that capital on this large scale can be available for these purposes.


#### Canals and Navigation


The problem of canals and inland navigation in Ireland is a minor one, but the same principles largely apply. The Royal Commission[81](javascript:footNote('E900031/note081.html')) recommended that all the chief waterways, canals, and rivers necessary for inland transport should be purchased and remain under the control of the State, the controlling authority, however, not themselves, to become carriers on any waterways. At the same time, they strongly urged that the problem of arterial drainage and relief from floods should not be treated separately, but that the control of drainage works should be under the same central authority as that which is to control waterways and navigation.




---

p.346


It is not necessary to refer in detail to the Report. Apart from the sum necessary to buy out the existing owners of canals and waterways, towards which £2,451,346 had been contributed from private sources, the Commissioners contemplated a further expenditure of about £200,000 on new works. In addition the sum of £500,000 would be required, on a moderate estimate for drainage and the prevention of floods. The pressing nature of the latter problem is once more emphatically evidenced by the wholesale injury to property and the public health by the recent flooding of the basins of the Shannon, Barrow, Bann, and other rivers. Here, again, we have problems which it is idle to expect an Irish Parliament to solve satisfactorily for years to come, or, indeed, ever. Ways and means must be an effectual bar. Drainage and navigation form only one problem out of a dozen facing a Home Rule Government needing the raising of enormous capital. Probably the Commissioners conducting the Canals inquiry, who were persons of all shades of political opinion, were well aware that only under the present system of State credit could the financial difficulties be overcome. According to their report, the State (i.e. the Government of the United Kingdom) were to acquire the control, which was to be carried out by an Act of Parliament, naming the Waterways Commissioners, ‘who should be persons disassociated from party politics.’


The one dissentient out of twenty-one signatories, **Lord Farrer**, significantly adds that he does not favour a ‘charge on the public purse and new Boards of Management *until a purely Irish elected authority has agreed to pay for them*.’ Precisely; **Lord Farrer** has looked ahead. Will an Irish elected authority agree to pay for these boons, and will they be able to pay? That is a question which will cause some searching of hearts amongst all interested in Ireland's welfare— in these pages we have attempted to give an answer.




---

p.347


#### Conclusion


The conclusion is in fact inevitable. Ireland cannot have it both ways. She cannot have financial independence and financial dependence at the same time. No Colony has ever claimed or been granted these inconsistent conditions. If Colonial precedents are cited, their essential limitations should also be borne in mind. Colonial loans are not charged on the Consolidated Fund. Nor have Colonial railways been nationalised with the money and credit of the United Kingdom, in order to favour local exports at the expense of imports from England.


Our examination of the question brings us to the clear conclusion that it is only under the existing system of a single Parliament and Executive for the United Kingdom that the problems of transit and transport in Ireland, or between Great Britain and Ireland, can be satisfactorily solved, whether from the point of view of finance, justice to shareholders, or advantage to the trade and convenience of both countries.


Note.—It has been suggested, since the above was written, that the balance in the Irish Post Office Savings Banks (now about £12,500,000) might be available to the new Irish Government, for advances to farmers and other public purposes. The suggestion involves the applicability of such advances for the purchase or amalgamation of the Irish railways under an Irish public authority. Such a proposal will not bear close examination.


It is an essential condition of the existence of Savings Bank deposits that the deposits should be always available on the call of depositors; and this condition would no longer be fulfilled if the balances were locked up in Irish railways. In fact, if there was any suggestion that these balances should be used for the purpose of enabling the Irish Government to run the railways on uncommercial principles, the deposits would very soon diminish or disappear—and this apart from the question whether under Home Rule, the deposits would in any event remain at anything like their present high figure.


