

A Visit to Lecale, in the County of Down, in the year 1602–3


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Visit to Lecale, in the County of Down, in the year 1602–3
============================================================


Author: Sir Josias Bodley
-------------------------


### File Description

William Reevestranslated by William Reeves 

Electronic edition compiled by Beatrix Färber 

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project. 2. Second draft, revised and corrected.Extent of text: 

8900 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2007) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T100074Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. Descriptio Itineris ad Lecaliam in Ultonia: British Library, Add. MS. 4784, folio. 87.
3. Descriptio Itineris ad Lecaliam in Ultonia: Oxford, Bodleian Library, Tanner MS. 444.
4. Descriptio Itineris capitani Iosiae Bodleij Lecaliam in Ultonia: Oxford, Bodleian Library, MS don b 8 (Personal miscellany of Sir William Haward), pp 140–155.
5. Descriptio Itineris ad Lecaliam in Ultonia: Transcript of British Library Add. MS. 4784, Trinity College, Dublin, MS. 734.
**Editions/Translations**2. William Reeves, A Visit to Lecale, in the County of Down, in the year 1602–03 (English translation of Latin text from TCD Library copy of BL Add. MS. 4784), Ulster Journal of Archaeology 1854, vol. ii, 73–99.
**Further reading: A selection**2. J. J. N. McGurk, 'Bodley, Sir Josias (c. 1550–1617)', Sept 2004, Oxford Dictionary of National Biography [online at www.oxforddnb.com].
3. Edmund Hogan (ed.), The description of Ireland & the state thereof as it is at this present in anno 1598. (Dublin 1878).
4. Anthony M. Wilson, 'A visit to Lecale by Josias Bodley in 1602', Lecale Miscellany 13 (1995) 18–27.
5. Barnaby Rich, New description of Ireland (London 1610).
6. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
7. John Dymmok, 'A treatice of Ireland. Edited by Richard Butler', Tracts relating to Ireland 2, 1–90, Irish Archaeological Society (Dublin 1843). Available on CELT.
8. Luke Gernon, 'A discourse of Ireland, anno 1620'. In: C. L. Falkiner (ed.), Illustrations of Irish history and topography, mainly of the seventeenth century. (London, New York, Bombay 1904) 345–362. (Available on CELT).
9. William Lithgow, The totall discourse of the rare adventures & painefull peregrinations of long nineteene years travayles from Scotland to the most famous Kingdomes in Europe, Asia and Affrica. Glasgow, 1906.
10. William Lithgow, Rare adventures and painful peregrinations of long nineteen years travayles (1632). Reprint, edited with an introduction by Gilbert Phelps. (London 1974).
11. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). (Available on CELT) [=A translation of portions of "Les voyages et observations du sieur de la Boullaye Le Gouz ..." Paris, 1653.].
12. Albert Jouvin, de Rochefort, Description of Ireland after the Restoration. [This is an extract from vol. vi, pp 472–493 of Albert Jouvin, de Rochefort, Le Voyageur d'Europe: où sont les Voyages de France, d'Italie et de Maltre, ... Paris 1672.] The English translation is taken from Francis Grose and Thomas Astle (eds.), Antiquarian Repertory: A Miscellaneous Assemblage of Topography, History, Biography, Customs, and Manners (1775?–)1779; reprinted London 1807–1809 for Edward Jeffery; reprinted again in In: C. L. Falkiner (ed.), Illustrations of Irish history and topography, mainly of the seventeenth century. (London, New York, Bombay 1904) 409–426. (Available on CELT).
13. Thomas Dinely, Observations on a tour through the kingdom of Ireland in 1681. Dublin 1858. Reprinted by E. P. Shirley (ed.) as 'Observations in a voyage through the kingdom of Ireland, 1680', Journal of the Kilkenny and South-East of Ireland Archaeological Society, new ser., 1 (1856–1857), 143–146, 170–188; new ser., 2 (1858–1859), 22–32, 55–56; new ser., 4 (1862–1863), 38–52, 103–109, 320–338; new ser., 5 (1864–1866), 40–48, 268–290, 425–446; new ser., 6 (1867), 73–91, 176–204.
14. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman. (Dublin 1846).
15. Anthony à Wood, Athenae oxonienses: an exact history of all the writers and bishops who have had their education in the University of Oxford. To which are added the Fasti, or Annals of the said University. London: 1813–1820, 4 vols. (vol. 2 covers 1500–1640).
16. Walter Harris, The antient and present state of the County of Down. Containing a chorographical description, with the natural and civil history of the same ... With a survey of the new canal; as also, a new and correct map of the County. Dublin, Printed by A. Reilly, for Edward Exshaw 1744. Reprinted Ballinahinch 1979.
17. William Reeves, Ecclesiastical Antiquities of Down, Connor and Dromore (Dublin 1847).
18. King James I of England, A Counterblaste to Tobacco, (first published London 1604.) ed. by Edward Arber (London 1869). (A digital copy is available at htp://www.la.utexas.edu/research/poltheory/james/blaste/index.html.
19. Agnes Strickland, Lives of the Queens of England, from the Norman conquest ... A new edition, revised and greatly augmented. London: Colburn & Co., 1851 iv. p. 709.
20. P. W. Joyce, A Social History of Ancient Ireland (New York, London, and Bombay 1903). 2 volumes.
21. Richard Bagwell, Ireland under the Tudors: with a succinct account of the earlier history. 3 vols. (London 1885–1890). (A digital copy is available at www.archive.org.)
22. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
23. John McVeagh (ed.), Irish Travel Writing. A Bibliography. (Dublin 1996).
24. Hiram Morgan, The Battle of Kinsale (Bray 2004).
25. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed), First edition [xvii + 426 pages] Longmans, Green, and Co.London, New York, Bombay (1904)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 328–344 of the volume. C. Litton Falkiner's introduction is included.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Interpretation


Words and phrases from languages other than English are marked.


##### Normalization


The electronic text was translated and published by William Reeves in the Ulster Journal of Archaeology, 1854, and reprinted in the Illustrations of Irish History by C. Litton Falkiner, from which it is taken. Footnotes by Falkiner are included in note tags.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, personal and organisation names, and terms are tagged. Words and phrases from languages other than English are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: Translation by William Reeves

 (c.1853) #### Use of language


##### Language: [EN] The editor has modernized Fynes Moryson's Elizabethan idiom.


##### Language: [GA] A few words are in Irish.


##### Language: [FR] A word is in French.


##### Language: [LA] A few words in Latin are retained.


### Revision History


* (2010-07-18) Beatrix Färber (ed.)

* Conversion script run, header updated; additions to bibliographic details made; more encoding added; new wordcount made; file parsed; new SGML and HTML versions created.
* (2008-10-19) Beatrix Färber (ed.)

* Keywords added, file validated; minor modifications to header.
* (2007-04-02) Beatrix Färber (ed.)

* Second proofing; SGML and HTML files created.
* (2007-03-29) Beatrix Färber (ed.)

* Header created including bibliography; file proof-read (1); structural and content markup applied.
* (2007-03-19) Benjamin Hazard (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: T100074


### A Visit to Lecale, in the County of Down, in the year 1602–3: Author: Sir Josias Bodley




---

p.326


### A Visit to **Lecale**, in the County of **Down**, in the year 1602-3

### by **Sir Josias Bodley**


The intrinsic interest of this humorous narrative of the holiday excursion of a knot of English officers in Ulster in the last days of **Elizabeth**'s reign derives an extrinsic attraction from the fact that its author was a brother of the famous founder of the Bodleian Library. **Sir Josias Bodley** was the youngest of **Sir Thomas Bodley**'s four brothers. Not much is known of his early life, but **Anthony Wood**'s statement that he spent some time at Merton College, **Oxford**, is confirmed by the evidence of classical reading which the narrative of his Irish tour affords. After serving some years in the **Netherlands**, **Bodley** came to **Ireland** in 1598, and seems to have spent his remaining years in that country. His earliest experience of the country was gained in the war with **Tyrone**. He served under **Essex** and **Mountjoy**, and is frequently mentioned by **Fynes Moryson** in his account of the Irish wars as holding considerable commands in various parts of **Ireland**. In March 1604 he was knighted by **Mountjoy**. After the pacification of **Ireland** he was appointed to superintend the Castles of **Ireland**. In 1609 **Bodley** was selected to survey the Ulster Plantation, and in recognition of this work received the appointment of director-general of the fortifications of **Ireland**, a post which he held until his death. **Bodley**, who died August 19, 1617, was buried at Christ Church, Dublin, August 26, 1617 (**Finlayson**'s Monumental Inscriptions in Christ Church Cathedral, Dublin, p. 72). Transcripts of the Descriptio Itineris ad Lecaliam in Ultonia are among the manuscripts at the British Museum (Add. MS. 4784, f. 87) and at the Bodleian Library (Tanner MS. 444). The transcript from which the version here printed is translated was copied by **Bishop Reeves** from that at the British





---

p.327




Museum, and is in the Library of Trinity College, Dublin (MS. No. 734). This translation is also by **Bishop Reeves**, by whom it was published in the Ulster Journal of Archaeology for 1854 (vol. ii. pp. 73–99). Comparison with the manuscript in the Bodleian, and with a further copy formerly in the Phillipps collection which has recently been acquired by the University of Dublin, shows the British Museum version from which **Dr. Reeves** took his transcript to be less accurate than the others.




---

p.328


An Account of a Journey of **Captain Josias Bodley** into **Lecale**, in **Ulster**, in the Year 1602–3
-------------------------------------------------------------------------------------------------------


Good God! What have I taken on me to do?[1](javascript:footNote('T100074/note001.html')) Truly I am an ass, otherwise I would never have undertaken so





---

p.329




heavy a burthen; but no matter, I shall do what I can, like Coppinger's dog, who always took her own way.


I have taken in hand to recount what happened in a journey which **Captain Caulfeild**[2](javascript:footNote('T100074/note002.html')), **Captain Jephson**[3](javascript:footNote('T100074/note003.html')), and I made to **Lecale**, to visit our friend **Sir Richard Morrison**[4](javascript:footNote('T100074/note004.html')) and divert ourselves there. And I shall narrate everything in due order; for order is a fair thing and all love it, except the Irish men-at-arms, who are a most vile race of men, if it be at all allowable to call them ‘men’ who live upon grass, and are foxes in their disposition and wolves in their actions. But to our business.


The aforesaid **Master Morrison** sent very kind letters to us, inviting us to keep the Nativity (which the English call ‘Christmas’) with him, but, as **Sir Arthur Chichester**, the





---

p.330






serjeant-major of the whole army, had convoked us with all our companies at that very moment to fight with **Tyrone**, who was then in the woods of **Glenconkein**[5](javascript:footNote('T100074/note005.html')) with much cattle and few fighting men, we could not go at that time to **Lecale**, but joined the said **Sir Arthur**, and remained with him for sixteen or seventeen days in the field, without doing much harm to **Tyrone**; for that **Tyrone** is the worst rascal, and very wary and subtle, and won't be beaten except on good terms. However, we fought him twice in the very woods, and made him run to his strongholds. So after leaving about that place a well-provided garrison, we each departed, with full permission and goodwill.


We now remembered the said invitation of **Sir Richard**, and after deliberation (for in the commencement of affairs deliberation should be used by those adventuring bold attempts, as **Seneca** says), we thought it good to go thither, although it was now eight days after the Nativity, because we did not doubt our being welcome though it had been Lent. This was resolved on in the city of **Armagh**, where there is a Governor,[6](javascript:footNote('T100074/note006.html')) a very honest fellow with a black beard, who uses every one well according to his poor ability, and would use them much better if he had more of the thing the English call ‘means’.


We set out from that city for the town commonly called **Newry**,[7](javascript:footNote('T100074/note007.html')) which was one day's journey. There, to speak truth, we were not very well entertained, nor according to our qualities, for that town produces nothing but lean beef, and very rarely mutton, the very worst wine, nor was there any bread, except biscuits, even in the Governor's house. However, we did our best to be merry and jocund with the bad wine, putting sugar in it (as the senior lawyers are used to do with Canary wine), with toasted bread, which in English is called ‘a lawyer's nightcap.’ There we found





---

p.331


**Captain Adderton**,[8](javascript:footNote('T100074/note008.html')) an honest fellow and a friend of ours, who, having nothing to do, was easily persuaded to accompany us to **Lecale**.


So the next morning we four take horse and set out. We had no guide except **Captain Caulfeild**, who promised he would lead us very well. But before we had ridden three miles we had lost our way and were compelled to go on foot, leading our horses through bogs and marshes, which was very troublesome, and some of us were not wanting who swore silently between our teeth, and wished our guide at a thousand devils. At length we came to some village of obscure name where, for two brass shillings, we brought with us a countryman who might lead us to the island of **Magennis**,[9](javascript:footNote('T100074/note009.html')) ten miles distant from the town of **Newry**, for **Master Morrison** had promised he would meet us there.


The weather was very cold, and it began to roar dreadfully with a strong wind in our faces when we were on the mountains, where there was neither tree nor house; but there was no remedy save patience. **Captain Bodley** alone had a long cloak with a hood, into which he prudently thrust his head, and laughed somewhat into himself to see the others so badly armed against the storm.


We now came to the island of **Magennis**, where, alighting from our horses, we met **Master Morrison** and **Captain Constable**,[10](javascript:footNote('T100074/note010.html')) with many others, whom, for the sake of brevity, I pass by. They had tarried there at least three hours expecting our arrival, and in the meantime drank ale and





---

p.332


**usquebaugh** with the Lady Sara,[11](javascript:footNote('T100074/note011.html')) the daughter of **Tyrone**, and wife of the aforesaid **Magennis**; a truly beautiful woman; so that I can well believe these three hours did not appear to them more than a minute, especially to **Master Constable**, who is by his nature very fond not of women only, but likewise of dogs and horses. We also drank twice or thrice, and after we had duly kissed her we each prepared for our journey.[12](javascript:footNote('T100074/note012.html'))


It was ten or twelve miles from that island to **Downpatrick**, where **Master Morrison** dwelt, and the way seemed much longer on account of our wish to be there. At length, as all things have an end, and a black pudding two (as the proverb hath it), we came by little and little to the said house. And now began that more than Lucullan entertainment, which neither **Cicero**, whose style in composition I chiefly imitate (although **Horace** says, *O imitatores, servum pecus!’’*

Horace, Epistulae I 19.19.

) nor any other of the Latin or Greek authors, could express in suitable terms.


When we had approached within a stone's-throw of the house, or rather palace, of the said **Master Morrison**, behold! forthwith innumerable servants! Some light us with pinewood lights and torches because it is dark; others, as soon as we alight, take our horses and lead them into a handsome and spacious stable, where neither hay nor oats are wanting. **Master Morrison** himself leads us by wide stairs into a large hall, where a fire is burning the height of our chins, as the saying is, and afterwards into a bed-chamber prepared in the Irish fashion.


Here, having taken off our boots, we all sit down and converse on various matters: **Captain Caulfeild** about supper and food, for he was very hungry; **Captain Constable** about hounds, of which he had there some excellent ones, as he himself asserted; and the rest about other things. **Master Morrison** ordered a cup of Spanish wine to be brought, with burnt sugar, nutmeg, and ginger, and made us all drink a





---

p.333




good draught of it, which was very grateful to the palate, and also good for procuring an appetite for supper if anyone needed such.


In an hour we heard some one down in the kitchen calling with a loud voice, ‘To the dresser.’ Forthwith we see a long row of servants decently dressed, each with dishes of the most select meats, which they place on the table in the very best style. One presents to us a silver basin with the most limpid water, another hands us a very white towel; others arrange chairs and seats in their proper places. *Denique quid verbis opus est? spectemur agendo’’*

**Ovid**, Metamorphoses. , Liber 13.

 (as Ajax says in **Ovid**). Grace having been said, we begin to fix our eyes intently on the dishes whilst handling our knives; and here you might have plainly seen those Belgian feasts, where *In principio erat silentium, in medio stridor dentium, et in fine rumor gentium.’’*




For at first we sat as if rapt and astounded by the variety of meats and dainties—like a German I once saw depicted standing between two jars, the one of white wine, the other of claret, with this motto: ‘I know not which way to turn.’ But after a short time we fall to roundly on every dish, calling now and then for wine, now and then for attendance, everyone according to his whim. In the midst of supper **Master Morrison** ordered to be given to him a glass goblet full of claret, which measured (as I conjecture) ten or eleven inches roundabout, and drank to the health of all and to our happy arrival. We freely received it from him, thanking him, and drinking, one after the other, as much as he drank before us. He then gave four or five healths of the chief men and of our absent friends, just as the most illustrious lord, now Treasurer of **Ireland**,[13](javascript:footNote('T100074/note013.html')) is used to do at his dinners. And it is a very praiseworthy thing, and has perhaps more in it than anyone would believe; and there was not one





---

p.334




among us but did pledge him and each other without any scruple or gainsay, which I was very glad to see, for it was a proof of unanimity and assured friendship.


For there are many (a thing I can't mention without great and extreme sorrow) who won't drink healths with others, sitting, nevertheless, in the company of those who do drink, and not doing as they do, which is of all things the most shameful. And since I have now happened upon this discourse on drinking I will say something, by way of digression, on the subject. Not long ago I was in company with some boon companions who were drinking healths in **usquebaugh**, when one was present who wished to appear more abstemious than the rest, and would not drink with them, to whom one of them, who could not speak Latin as well as I do, said these words: ‘Si tu es plus sapientis [sic] quam nos sumus, tu es plus beholden to God Almighty quam nos sumus,’ which was most nobly said and very apposite. And I saw with my own eyes, when I was in **Poland**, a certain person sitting at table with many others, and refusing to drink as they drank, thrust out of doors by the head and shoulders with great disgrace, and made almost unfit for all civilised society. For at table he who does not receive whatsoever healths may be proposed by another does so, either because he likes not the proposer, or him to whom they drink, or the wine itself. Truly I would not willingly have any dealings with him who undervalues either me or my friend, or, lastly, wine, the most precious of all things under heaven.


But if any such person thinks he should go excused because he cannot bear wine, owing to the weakness of his brain, he may depend on it that it happens through his own fault; to wit, because he does not sufficiently accustom himself to wine; for by a daily and frequent use of wine he will so easily familiarise himself to it (for custom, according to **Galen**, is second nature) that he may quaff as many cups as he pleases, not only without injury, but even with the greatest pleasure and delight. But if he abstains from potations because he thinks that from them arises the cause,





---

p.335




sometimes of quarrels, sometimes of mischief, let him understand that such things happen not from wine but from the vicious natures of men, from which it is rather to be deduced that, by a continual habit of drinking, we may avoid, when drunk, those vices we endeavour to avoid when sober. And for my part I have ever thought the abstemious are self-conscious of some great crime, which they fear they would betray if drunk. For wine is the father of Ebriety, but Ebriety is the mother of Truth, although some say that Truth is the daughter of Time; but they think so because wine is always drunk in good time, and it requires time to make a man drunk.


But I think I hear some severe **Cato**—such as they are who place their greatest happiness in long and ‘well got-up’[14](javascript:footNote('T100074/note014.html')) beards—I say I think I hear him saying, *Dost thou to us praise drunkenness, which enervates not only the powers of the body, but enfeebles the spirit and dulls the sharpness of the intellect?’’*

 Silence, I prithee, my good **Cato**, unless you first of all explain to US what drunkenness is; for he who well explaineth teacheth well. There are certain gradations of drunkenness; there are certain limits; nor can he be in reality styled a drunkard who is occasionally conquered by wine; but he who so indulges that, neglecting all other business, he hath always his nose in the cup, without regard to the place where, the persons with whom, or the time when, he drinketh.


For I maintain that being drunk is nothing else than being sometimes rationally mad, just as if one should take any medicine that intoxicates the brain, or produces perhaps nausea, vomiting, or sleep; of which there are many, as **antimony**, **nux vomica**, **opium**, **mandrake**, and such like, and yet which may subsequently expel some disease, and conduce to health. Even **Hippocrates** himself, the prince of physicians, recommends amongst other things that contribute to health, an immoderate potation of wine at least once a month. And I remember having heard that a certain most learned physician, when he was asked by a friend 





---

p.336




why he drank so much wine himself, and was almost daily drunk, although to others he preached abstinence from wine, whereby they might prolong their life, replied that he lived more in one day by living his own way and according to his own will, than if he had lived a whole year according to the laws of physic. And certainly there are more old drunkards than old physicians, as **Rabelais** says.


I could, indeed, adduce in corroboration of my opinion, almost innumerable instances of illustrious and learned men who were wont to get drunk after the manner I have mentioned. But what need is there for particular examples when so many countries on the globe are so addicted to potations that you would suppose they did scarcely anything else than drink—to wit, **Flanders**, **Germany**, **Poland**, **Denmark**, **Sweden**, **Norway**, with many others, now too tedious to particularise. Much more could be said on this point, but I wish not to amplify farther, for the thing is as clear in itself as the day. I will therefore conclude with these lines of **Horace**, which are worthy of being inscribed in letters of gold on every table: 


> 1. Quid non ebrietas designat? Aperta recondit;
>   
> Spes jubet esse ratas: in prelia trudit inermem,
>   
> Sollicitis animis onus eximit; addocet artes;
>   
> Foecundi calices quem non fecere disertum?
>   
> Contracta quem non in paupertate solutum?
> 


[15](javascript:footNote('T100074/note015.html'))


Let us now return to **Lecale**, where the supper (which, as I have said, was most elegant) being ended, we again enter our bedroom, in which was a large fire (for at the time it was exceedingly cold out of doors) and benches for sitting on, and plenty of tobacco, with nice pipes, was set before us. The wine also had begun to operate a little on us, and every one's wits had become somewhat sharper; all were gabbling at once, and all sought a hearing at once, like what **Sir Roger Williams**,[16](javascript:footNote('T100074/note016.html')) of worthy memory, used to call





---

p.337




‘his academy’, to wit, where all were speakers and no listeners. And it is not true what some say, ‘When wine is in wit is out’, unless they mean thereby, that when anyone is full of wine, then his wit, which was previously hidden and unknown, exhibits itself openly and plainly. For if any sober person had been present at that time in any corner of the room, I doubt not that he would have heard very remarkable and witty things, which I cannot now recollect.


I remember, however, that we conversed profoundly about things political, economical, philosophical, and much else; and amongst other things we said that the time was now happily different from when we were before **Kinsale** at Christmas of last year,[17](javascript:footNote('T100074/note017.html')) when we suffered intolerable cold, dreadful labour, and a want of almost everything, drinking the very worst whiskey.[18](javascript:footNote('T100074/note018.html')) We compared events, till lately unhoped for, with the past, and with those now hoped for. Lastly, reasoning on everything, we conclude that the verse of **Horace** squares exceedingly well with the present time namely, 


> 1. Nunc est bibendum, nunc pede libero
>   
> pulsanda tellus.
> 






---

p.338


Therefore, after a little, **Captain Jephson** calls for **usquebaugh**, and we all immediately second him with one consent, calling out ‘**Usquebaugh**, **usquebaugh**!’ for we could make as free there as in our own quarters.


Besides it was not without reason we drank **usquebaugh**, for it was the best remedy against the cold of that night, and good for dispersing the crude vapours of the French wine; and pre-eminently wholesome in these regions, where the priests themselves—who are holy men, as the Abbot of **Armagh**, the Bishop of **Cashel**, and others, and also noble men, as **Henry Oge Mc Mahon McHenry**, and men and women of every rank—pour **usquebaugh** down their throats by day and by night, and that not for hilarity only which would be praiseworthy, but for constant drunkenness which is detestable.


Therefore after everyone had drank two or three healths, still discoursing between each health on grave affairs relating to the State (amongst which many things concerning **Marius** and **Sylla**, concerning **Caesar** and **Pompey**, and also about **Marcus Coriolanus**, were most learnedly handled and most keenly argued) we all at once agree to go to bed. For, what because of the assailing fumes of the wine which now sought our heads and, by reason of the coolness of our brains, diffused themselves over our eyes, what because of the fatigue from the previous day's journey, and what because of the hour itself, when the sun had advanced from the east to the meridian line of the other hemisphere, fifteen degrees, six minutes, five seconds and four-thirds, we thought it right (as I have said) to rest for some hours. And behold now the great kindness that **Master Morrison** shows towards us! He gives up to us his own good and soft bed, and throws himself upon a pallet in the same chamber, and would not be persuaded by anything we could say to lie in his own bed; and the pallet was very hard and thin such as they are wont to have who are called ‘Palatine’ of great heroes.


I need not tell how soundly we slept till morning, for that is easily understood, all things considered—at least, if





---

p.339




the old syllogism be true, ‘He who drinks well sleeps well.’ We did not, however, pass the night altogether without annoyance, for **Captain Constable**'s dogs, which were very badly educated (after the northern fashion), were always jumping on the beds, and would not let us alone, although we beat them ever so often, which the said **Constable** took in dudgeon, especially when he heard his dogs howling; but it was all as one for that, for it is not right that dogs, who are of the beasts, should sleep with men who are reasoning and laughing animals, according to the philosophers.


When the sun, on the line of the ecliptic, over the poles of the Zodiac, had already made almost the fourth part of his daily journey above our horizon, and the domestics, knowing that it was time for us to rise, came in to light the fire, we all suddenly awoke, and saluted each other as is the custom with the well-educated. Before we get out of bed they bring to us a certain aromatic of strong ale compounded with sugar and eggs (in English, ‘caudle’), to comfort and strengthen the stomach; they also bring beer (if any prefer it), with toasted bread and nutmeg to allay thirst, steady the head, and cool the liver; they also bring pipes of the best tobacco to drive away rheums and catarrhs.


We all now jump quickly out of bed, put on our clothes, approach the fire, and, when all are ready, walk abroad together to take the air, which in that region is most salubrious and delightful, so that if I wished to enumerate all the advantages of the place, not only powers (of description) but time itself would be wanting. I shall therefore omit that, as being already known, and revert to ourselves, who, having now had a sufficient walk, returned to our lodgings as dinner time was at hand.


But how can we now tell about the sumptuous preparation of everything? How about the dinners? How about the suppers? How about the dainties? For we seemed as if present (as you would suppose) at the nuptial banquet to which some **Cleopatra** had invited her **Antony**; so many varieties of meat were there; so many kinds of condiments, about every one of which I would willingly say something,





---

p.340




only that I fear being tedious. I shall therefore demonstrate from a single dinner what may be imagined of the rest. There was a large and beautiful collar of brawn with its accompaniments, to wit, mustard and Muscadel wine; there were well-stuffed geese (such as the Lord Bishop is wont to eat at **Ardbraccan**),[19](javascript:footNote('T100074/note019.html')) the legs of which **Captain Caulfeild** always laid hold of for himself; there were pies of venison and of various kinds of game; pasties also, some of marrow with innumerable plums, others of it with coagulated milk, such as the Lord Mayor and Aldermen of **London** almost always have at their feasts; others, which they call tarts, of divers shapes, materials, and colours, made of beef, mutton, and veal. I do not mention, because they are reckoned vulgar, other kinds of dishes, wherein **France** much abounds, and which they designate quelq'-choses. Neither do I relate anything of the delicacies which accompanied the cheese, because they would exceed all belief. I may say in one word that all things were there supplied to us most luxuriously and most copiously.


And lest anyone might think that God had sent us the meat but the devil the cook (as the proverb says), there was a cook there so expert in his art that his equal could scarce be found; and I shall now say one big (superbum) word— I believe that Master Robert, the cook who presides over the kitchen of the Lord Deputy (with pardon be it spoken) is not a much better cook, or more skilled in his art than he —and his name is Philip. And truly this may suffice as to the dishes and dainties, for a word is enough to the wise.


If you now inquire whether there were any other amusements besides those I have related, I say an infinite number and the very best. For if we wished to ride after dinner you would have seen forthwith ten or twelve handsome steeds





---

p.341




with good equipments and other ornaments, ready for the road. We quickly mount; we visit the Well and Chair of St. Patrick,[20](javascript:footNote('T100074/note020.html')) the ancient fort, or any other place according to our fancy, and at length returning home, cards, tables, and dice are set before us, and amongst other things, that Indian tobacco (of which I shall never be able to make sufficient mention) and of which I cannot speak otherwise; whereas there are many who loathe it as not at all pleasant or necessary; and they do not so, like others who unnaturally and from antipathy dislike certain foods, just as Captain Morris hates eels, Captain Sydney cheese, Captain Windsor[21](javascript:footNote('T100074/note021.html')) mutton chops, and **Captain Bodley** **usquebaugh**, nevertheless, admitting these things to be good in themselves, and freely allowing them to others; whereas those good fellows (of whom I speak) not only contemn tobacco themselves but also advise others against it.


And I have now, for twelve years and more, been expecting some sound reason from them to confirm that opinion, but have, as yet, heard none (that is worth a farthing), nor shall I ever hear one. Almost all have but one argument, that would make a dog laugh and a horse break his halter, saying that neither our sires nor grand-sires took tobacco, yet they lived I know not how long. So, indeed, they lived until they died, despite of tobacco; but who knows if they might not have lived longer had they used tobacco? And if one who now uses tobacco die of any disease, who knows if he might not have died sooner if he had abstained from tobacco?


And do not reject as ridiculous and entirely false that some tobacconists, being dissected after death, have been found to be black inside, because (if such hath ever happened) it proceeds from the vitiation or corruption of the blood, or from the superabundance of the atrabilious





---

p.342






humour, or, lastly, from the **morbus Gallicus**, or any other indisposition of the body; for physicians very well know, and with their opinion I agree, that tobacco, nevertheless, may contain in itself something divine, and may conduce wonderfully to our health.


Whence, I prithee, could I bring stronger or surer testimony than that so many noble and, at the same time, wise men (besides countless others) delight in it extremely? And from the time it was first discovered it hath maintained the same repute for so many years; nor hath it ever had an enemy except the ignorant, who, either on account of the cost (for it is sold dear) or because he imagined himself awkward in properly or skilfully imbibing it, was deterred, as it were, on the very threshold. Indeed, from my experience, I have so much in view its innumerable and unspeakable benefits, that I might even venture to say (with the poet): *Cur moriatur homo qui iumat in ore tobacco?’’*

[22](javascript:footNote('T100074/note022.html'))


And now once more to our **Lecale**, where, amongst other things that contributed to hilarity there came one night after supper certain maskers of the Irish gentry, four in number, if I rightly remember. They first sent in to us a letter marked with ‘the greatest haste’ and ‘after our hearty commendations,’ according to the old style, saying that they were strangers just arrived in these parts, and very desirous of spending one or two hours with us; and leave being given, they entered in this order: first a boy, with lighted torch; then two beating drums; then the maskers, two and two; then another torch. One of the maskers carried a dirty pocket-handkerchief with ten pounds in it, not of bullion, but of the new money lately coined, which has the harp on one side and the royal arms on the other. They were dressed in shirts with many ivy leaves sewn





---

p.343




on here and there over them, and had over their faces masks of dog-skin with holes to see out of, and noses made of paper; their caps were high and peaked (in the Persian fashion) and were also of paper, and ornamented with the same leaves.


I may briefly say we play at dice. At one time the drums sound on their side, at another the trumpet on ours. We fight a long time a doubtful game; at length the maskers lose, and are sent away, cleaned out (vacui). Now whoever hath seen a dog struck with a stick or a stone run out of the house with his tail hanging between his legs would have (so) seen these maskers going home, without money, out of spirits, out of order, without even saying ‘Farewell’; and they said that each of them had five or six miles to go to his home, and it was then two hours after midnight.


I shall now tell of another jest or gambol which amongst many the domestics of **Master Morrison** exhibited for us. Two servants sat down after the manner of women (with reverence be it spoken) when they ‘hunker,’ only that they (the servants) sat upon the ground; their hands were tied together in such a manner that their knees were clasped within them, and a stick placed between the bend of the arms and the legs, so that they could in no way move their arms; they held between the forefinger and thumb of either hand a small stick almost a foot in length and sharp at the farther end. Two are placed in this way: one opposite the other at the distance of an ell. Being thus placed they engage, and each one tries to upset his opponent by attacking him with his feet, for being once upset he can by no means recover himself, but presents his rear to his upsetter for attack with the aforesaid small stick,[23](javascript:footNote('T100074/note023.html')) which





---

p.344






made us laugh so for an hour that the tears dropped from our eyes, and the wife of Philip, the cook, laughed, and the scullion, who were both present. You would have said that some barber-surgeon was there, to whom all were showing their teeth. But enough of these matters; for there would be no end of writing were I to recount all our grave and merry doings in that space of seven days. I shall therefore make an end both of the journey and of my story. For on the seventh day from our arrival we departed, mournful and sad; and **Master Morrison** accompanied us as far as **Dundrum**,[24](javascript:footNote('T100074/note024.html')) to whom each of us bidding farewell, and again farewell, and shouting the same for a long way, with our caps raised above our heads, we hasten to our quarters, and there we each cogitate seriously over our own affairs.




