

#A Treatise on Fevers


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Treatise on Fevers
====================


Author: [unknown]
-----------------


### File Description

Lilian Duncanedited and translated by Lilian Duncan

Electronic edition compiled by Beatrix Färber

Funded by School of History, University College, Cork 1. First draft.Extent of text: 14320 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2017) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T600020Availability [RESTRICTED] 
Available with prior consent of the CELT project for purposes of academic research and teaching only.


#### Sources


**MS sources for Irish version**- Dublin, Trinity College Dublin, MS 1299 (olim H 2 8). *Digital scans and a catalogue description of this manuscript are available on the ISOS Project, Dublin Institute for Advanced Studies, see: http://www.dias.ie/isos/.*- Dublin, Trinity College Dublin, MS 1302 (olim H 2 12 (i)). A medical treatise, 15th to 16th century. Seven folios. 'A treatise on diseases, particularly fevers. Beginning 'Morbus est cum membra actionis sui (sic) naturalis temperamenta egrediuntur'; imperfect. Agrees with a tract mentioned in TCD MS 1299, p25b.' (TCD Library M& ARL Online Catalogue). *Digital scans and a more detailed catalogue description of this manuscript are available on the ISOS Project, Dublin Institute for Adyanced Studies, see: http://www.dias.ie/isos/.***Texts mentioned**2. Aristotle, Physics, translated by R. P. Hardie and R. K. Gaye; available online at http://classics.mit.edu/Aristotle/physics.html.
3. Aristotle, On Generation and Corruption, translated by H. H. Joachim; available online athttp://classics.mit.edu/Aristotle/gener\_corr.html.
4. Hippocrates of Cos, Prognostic. Regimen in Acute Diseases. The Sacred Disease. The Art. Breaths. Law. Decorum. Physician (Ch.1). Dentition. Volume II. Translated by W.H.S. Jones, Loeb Classical Library, 148 (Harvard: University Press 1923). (Note that this is a direct translation from Greek into English.)
5. Hippocrates of Cos. Epidemics 2, 4-7. Volume VII. Edited and translated by Wesley D. Smith. Loeb Classical Library 477. Cambridge, MA: Harvard University Press, 1994. (Note that this is a direct translation from Greek into English.)
6. Hippocrates of Cos, The Aphorisms of Hippocrates, with a translation into Latin, and English, by Thomas Coar, London 1822 (available online at www.archive.org).
7. Galen. On the Constitution of the Art of Medicine. The Art of Medicine. A Method of Medicine to Glaucon. Edited and translated by Ian Johnston. Loeb Classical Library 523. Cambridge, MA: Harvard University Press, 2016. (=De Febribus) (Note that this is a direct translation from Greek into English.)
8. Avicenna, Canon Medicinae: quo universa medendi scientia pulcherrima, et brevi methodo planissime explicatur. Venetiis 1595. [=Avicennae Arabum medicorum principis: Ex Gerardi Cremonensis versione, & Andreae Alpagi ... castigatione. A Ioanne Costaeo, & Ioanne Paulo Mongio annotationibus iampridem illustratus. Nunc vero ab eodem Costaeo recognitus, & novis alicubi observationibus adauctus ... Vita ipsius Avicennae ex Sorsano ... a Nicolao Massa Latine scripta ... Additis nuper etiam librorum Canonis oeconomiis, nec non tabulis isagogicis in universam medicinam ex arte Humain, id est Ioannitii Arabis. Per Fabium Paulinum Utinensem. Cum indicibus quattuor ...Canon Medicinae ] A digital version of the Latin translation edited in 1595 is available at http://reader.digitale-sammlungen.de/de/fs1/object/display/bsb10147921\_00018.html.
9. Isaac Israeli ben Solomon (Isaac Judaeus), Repertorium cap. libri febrium Ysaac, in: Omnia opera Ysaac in hoc volumnine contenta. Jean de La Place for Barthélemy Trot, Lyon 1515. Available online at Bayerische Staatsbibliothek, Digitale Sammlungen: http://reader.digitale-sammlungen.de/de/fs1/object/display/bsb10942596\_00001.html (fol cciii-ccxxiiii)
**The edition used in the digital edition**2. **Lilian Duncan**, A Treatise on Fevers in Révue Celtique, Ed. J. Loth and E. Ernault and M.-L. Sjoestedt and J. Vendryes . Volume 49, Paris, Libraire Ancienne Honoré Champion (1932) page 1–90

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text represents Duncan's English translation, covering pp. 57–87. 


#### Editorial Declaration


##### Correction


Text has been checked and proofread twice.


##### Normalization


The electronic text represents the edited text. Where the hardcopy uses italics to denote expansions in the electronic text ex tags are used instead.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break or line-break have been placed on the line on which they start.


##### Segmentation


div0=the whole text; div1=the section. Paragraphs are numbered in line with the printed edition, page-breaks are marked pb n=""; milestones are marked mls unit="MS folio" n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


#### Canonical References


This text uses the DIV1 element to represent the Section. ### Profile Description


Created: The text in MS 1299 was translated by an unnamed Irish physician. The translation into English is by Lilian Duncan
 (1932) #### Use of language


##### Language: [EN] The translation is in English.


##### Language: [LA] Some terms and quotes are in Latin.


### Revision History


* (2017-05-15) Beatrix Färber (ed.)

* File proofed (2). Parsed and validated. SGML and HTML files created.
* (2017-04-24) Beatrix Färber (ed.)

* File captured; file encoded in accordance with CELT standards: encoding and numbering of page-breaks, milestones, divisions, subdivisions and headings. Limited amount of content encoding applied for personal names and book titles; some typos corrected.




---


#### Corpus of Electronic Texts Edition: T600020


### A Treatise on Fevers: Author: [unknown]




---

p.57


{TCD 1299 page and line 25b26}
Morbus ...etc. Disease is when the members depart from moderation and from the natural composition of action and function, and **Galenus** says here that diseases are of three kinds, i.e. the first kind which is called {TCD 1299 page and line 26a1} universal disease. The second kind, simple disease. The third kind, compound disease. And universal disease is the disease which affects the whole body, such as fever. And simple disease is disease which is created in the body by one quality such as heat or cold or humidity or dryness. From the quality of heat, namely hectic or ephemeral fever, which is caused by the heat of the sun or by labour. From the quality of coldness, namely congelacio or spasm, which is caused by the coldness of the air or by snow alone. And compound disease is disease caused by the composition of the qualities or humours. From the composition of the qualities, namely heat and dryness, heat and humidity, coldness and humidity, coldness and dryness. From heat and dryness, namely that which is called erysipelas. From heat and humidity, namely that which is called phlegmon. From cold and humidity, namely oedema. From cold and dryness, namely that which is called sclerosis. From the composition of the humours namely dropsy, caused by the moist, viscous humours, and epilepsy and apoplexy and the like are similarly caused. From the composition of the humours, heat with dryness, namely elefancia and cancer and the like.




---

p.58


{TCD 1299 page and line 26a21} And since fever affects the whole body, it is of that we should wish to speak first here. And **Galenus** says in this book that fever is a disease caused by an unfavourable hot complexion which affects the whole body. And other doctors say that fever is unnatural heat which proceeds from the heart and from the arteries to all the members, hindering the natural functions, and one gets this attack according to the course of the fever, i.e. according to the heat, and not from the accidental ailments which accompany the fever, though some of the old people said that fever is simply the accidental ailments which follow heat, and they said too that fever is the same as rigor or fotigacio, i.e. an accidental ailment one gets after labour or fatigue or headache. And **Hippocrates** said in the book entitled Epidemion that fever is simply natural heat moving outside the natural course. And he said in the same book that fevers are of three sorts, one which begins in the spirits and proceeds to the heart, so that it acquires heat, and from the heart to the arteries, and from the arteries to all the members of the body, and this kind is called ephemera. The second sort is a fever caused by the humours, and which begins gently from those to the members near them, and from the members to the heart, and from the heart to the arteries, and from the arteries to the members again, so that thus it goes round the whole body, and this fever is called putrid fever, i.e. fever caused by the corruption of the humours. The third sort is formed in the strong members and in the fundamental fluids, and begins from those to the heart, and from the heart to the arteries, and from the arteries to all the members, and this fever is called hectic fever. And **Galenus** says here that the whole matter consists simply of these three sorts we have mentioned, namely, ephemera, putrita and etica, and the cause is, as **Galenus** says: Three matters are the seat of fever in the body, namely the spirits, the humours and the members. And **Galenus** puts ten fevers here including the heat of the fevers we have mentioned, i.e., the heat of ephemeral fever, namely flatulence compounded with heat. And the heat of putrid fever, like the heat of water boiled in a closed vessel.


---

p.59



And the heat of hectic fever like a vessel heated when empty and cold water poured in. And **Galenus** says here that ephemeral fever lasts twenty-four hours, or else forty-eight hours, or seventy-two hours. Putrid fever is fever which comes from the corruption of the four humours, and there are five matters causing corruption in the humours, i.e. the first matter, the humours offending as to quantity. The second matter, the thickness and density of the humours. The third matter, the closing of the pores. The fourth matter, the viscosity of the humours. The fifth matter, vapour kept in the body from the closings we have mentioned. And **Galenus** says that there are many kinds of putrid fevers, i.e., simple fever and compound fever. Simple fever such as the fever caused by the corruption of one humour, e. g. tertian from the corruption of reddish bile, and sinocha from the corruption of red blood, and quartana from the corruption of black bile, and quotidian from the corruption of phlegm. And **Galenus** says there are two kinds of fever caused by the corruption of the humours, continued fever and intermittent fever, and continued fever is one which corrupts inside the vessels such as the arteries and the veins, and intermittent fever is when it corrupts outside the vessels, as in tertiana interpolata. And **Galenus** says that there are twelve hours in the access of true tertian. And twenty-tour hours in the access of true quartana. And eighteen hours in the access of ephemera. And eighteen hours in the access of quotidian. Since we have alluded to the access of fevers:


{TCD 1299 page and line 26b30} Let it be asked whether there are four periods in every fever, i.e., beginning, increase, status, and decrease; it seems there are not, for **Galenus** says there are illnesses which are usually in one state, as **Hippocrates** says in this canon: ‘Quibus ... etc.’, according to that, the four periods do not occur in every fever. This is opposed, according to **Aristotle**, who says there are four periods in every fever. And note that those four periods are understood in two ways, i.e. completely and partially. And the complete periods are those that continue throughout the illness. And the partial periods 


---

p.60



of the illness are the periods of the access. And the complete periods are divided in two manners, i.e. first with respect to the digestion of the matter, and secondly with respect to the non-digestion. According to that the beginning of the illness is the point at which the symptom of digestion is not evident, as **Avicenna** says in the first canon that the beginning of the illness is when the natural heat is suppressed by the matter of the disease, until the symptom of digestion is evident. And the increase is the period in which the symptom of digestion clearly begins, as **Avicenna** says, that the increase is simply the period when the natural heat is moved to contend with the matter of the illness, revealing the symptom of digestion or non-digestion. And the status, according to **Avicenna**, is when it reaches the definite end of the unfavourable accidental ailments, together with the digestion of the matter, or with its non-digestion, if it be a mortal illness. And **Avicenna** says in the first book that the status is simply a vehement fight between nature and the illness. And the decrease is when the matter begins to {TCD 1299 page and line 27a1} undergo digestion and expulsion, and it is about that **Avicenna** says: ‘Principium ...’ i.e. The beginning is — as we have said. And the increase is when the unfavourable accidental ailments are much strengthened. And the status is when the unfavourable accidental ailments are very violent. And the decrease is when the unfavourable accidental ailments visibly diminish. And the partial periods that are in the paroxysm only are divided with regard to the accidental ailments. And the beginning of the paroxysm is when the heat turns from the heart to the external members. And the increase of the paroxysm is when the heat turns from the other members to the heart. And its status is when the heat is dispersed completely through all the members. And the decrease of the paroxysm is when the heat is diminished and lessened. We answer this question according to **Avicenna** who says that every illness from which one recovers has four periods in general. And **Avicenna** says that mortal illnesses have not four periods in general, and this conclusion is affirmed according to **Galenus** in the book De Crisi, who says that one does not die in the


---

p.61



decrease of an illness, accordingly, there are not four periods in a mortal illness, though **Avicenna** says that a certain mortal illness has four periods partially, as we said above.


{TCD 1299 page and line 27a22}
Let it be asked here from which of the following the cure should commence, i.e. from the accidental ailment of the fever, or from the cause of the fever, or from the fever itself. It seems one should cure the cause of the fever first, as **Galenus** ssays in the book De ingenio sanitatis these words: ‘Ante ... ’ i.e. before everything the physician should be careful of the cause of the disease, according to that the cause of the fever should be cured first. Then **Galenus** says in the same book that the fever will continue if the cause continues, so the cause should be cured first. Then the same man says, when unfavourable complexion and cause and matter exist together, one should begin from the cause, and after it from the bad complexion, and then from the disease, so the cure should be begun from the cause. Then **Galenus** says in the commentary of the first *section* of the Aphorisms: ‘Medicus ... ’ i.e. the physician is the instrument of nature and should imitate it in every way, and so, since nature begins from the cause, as is clear is these words: ‘Natura’ i.e. nature first digesting and then dividing and afterwards expelling, as **Avicenna** says in the fourth *section* of the Aphorisms in this canon: ‘Incipientibus ... ’, so the cure should begin from the cause. Then **Galenus** says in De ingenio sanitatis ‘Omine ... ’ i.e. what **Galenus** says in this proverb is: O physician if you increase the cause, and lessen the fever, you do not cure the fever, so the cure should begin from the cause as **Hippocrates** said in this canon, ‘Digesta ... ’. Then **Avicenna** says in the fourth book in the chapter on putrid fever this saying: ‘Si uirtus ... ’ i.e. if the energy is strong the matter should be expelled first without moving the unfavourable complexion, for **Galenus** says the energy is strong in acute illnesses during two or three days, and so beginning should be made from the cause. Then **Avicenna** says in the fourth book these words: ‘Prius ...’ {TCD 1299 page and line 27b1}i.e. **Avicenna** says here the cure should begin


---

p.62




with everything that cures ephemera and everything that follows it such as the cause and the fever, for **Avicenna** says, if the fever be cured and the cause continue, that the fever returns again, and if the cause is cured the fever is cured, so the cause should be cured first. Then **Avicenna** says in the fourth book these words: ‘Impossibile ... ’ i.e. it is impossible to expel the fever unless the cause be expelled, so beginning should be made from the cause. Then **Galenus** says De ingenio sanitatis this distinction that the cause is sometimes stronger and more vigorous than the disease, and at other times the disease is stronger than the cause, and at that time one should begin from the disease, and when the cause is stronger one should begin from it. This distinction is opposed according to **Galenus** who says there is no effect (?) of the thing which comes (perhaps ‘which does not come’). From a thing stronger than the thing itself, accordingly since the disease comes from the cause, as fever comes from corruption, the cause is stronger than the disease. Then it seems the fever is not stronger than the cause and the cause is not stronger than the fever, for **Galenus** says that fever injures only when the cause continues, and the cause injures only when the fever continues, so neither of them is stronger than the other. This is opposed on the authority of **Aristotle** who says these words: ‘Quod ultimum ... ’ i.e. everything which is last in composition is first in dissolution, so, since fever is later than the cause, the cure should begin from the fever. Then **Galenus** says in De ingenio sanitatis: ‘Febris sequitur ... ’ i.e. the fever follows the cause and the accidental ailment follows the fever, so the physician should begin first from the accidental ailment, and afterwards from the illness, and last from the cause. Then **Galenus** says in the tenth book of De ingenio sanitatis these words: ‘Si materiam ... ’ i.e. if we cure the cause first and the fever continue, the fever and the patient die together, so the cure should begin from the fever and not from the cause. Then **Galenus** says in De ingenio sanitatis these words: ‘In omne ... ’ i.e. in every fever let the cure begin from the unfavourable complexion, and **Galenus** says in the 


---

p.63




same passage that the unfavourable complexion is identical with the disease or the fever, so the cure begins from the fever or from the disease and not from the cause. Then **Galenus** says the cure should begin from everything which first and most injures the natural functions, and fever injures nature more than the cause of the fever does, so the cure should begin from the fever. Then **Galenus** says in the second book of Techne these words: ‘Cura debetur ... ’ i.e. the illness should be cured and the cause should be preserved, so the beginning should be from the fever. Then **Galenus** says in every illness which is throughout the body while the cause is local, beginning should be made with the illness and not with the cause, and that is how it is with fever, i.e. its cause local and itself universal, as is clear in intermittent fever the cause of which can be in the stomach or in the intestines, and in causon fever, for the cause of this fever is in the veins of the heart and of the liver, so one should begin with the fever and not with the cause. Then **Galenus** says in the twelfth book of De ingenio sanitatis, if the fever is due to fullness (or a humour), as synochus, and syncope ensues, the cure of this accidental ailment first is ordered, and then the fever, for **Galenus** says in the first canon these words: {TCD 1299 page and line 28a1} ‘Accidens ... ’ i.e. The accidental ailment tries to cure itself leaving the disease and the cause, as is clear in colica and ilica, for we should cure the pain first in these and leave the constrictions causing the pain, so the cure should begin from the accidental ailment. Then **Galenus** says in the ninth book of De ingenio sanitatis these words: ‘Curato ... ’ i.e. if the disease be cured the accidental ailment is cured, so the cure should begin from the disease and not from the accidental ailment. Then **Galenus** says that the one cure serves disease and the accidental ailment, so since the accidental ailment departs through the cure of the disease, the cure should begin from the disease and not from the accidental ailment. Then **Galenus** says medicine is not good except in an illness from which one recovers, and every illness from which one recovers has its cause decreasing until the status and the illness increasing, as **Hippocrates** says in the Aphorisms


---

p.64




in this canon: ‘In quo antibus ... ’ and in this other canon: ‘Circa principio ... ’ so on account of that one should begin not from the cause but from the illness itself. We answer that question and say that corruption is the cause of fever, and one must examine three things with regard to the corruption, as **Galenus** says, quantity, motion and poisonous quality. Great or small quantity of the corruption; motion, namely the poisonous matter going from member to member; quality of the corruption is simply ebullition caused by corruption in the veins, so that on that account **Galenus** says here that the cause and the fever are equal with respect to the quality we mentioned, for if the ebullition of the corruption we have mentioned be very acute and violent, the fever will continue likewise, and, if the fever be violent, the quality of the corruption must be strong in the veins as we said, and it is not so with respect to quantity and motion, for the corrupting matter can be moving (recte dangerous) as to quantity and not dangerous as to quality. And **Galenus** says that matter like that does not easily prepare for its status, and the illness is chronic and the strength endangered by the length of the illness. And **Galenus** says the quantity of the corruption can be great as to action and not acute as to quality as **Hippocrates** says in the first book of Aphorisms: ‘Febribus ... ’ for it is thus **Galenus** understands **Hippocrates** here, that the matter of the fever can be great and the fever itself weak. And **Galenus** says here that the matter (omit) the motion we have mentioned can be dangerous and the unfavourable complexion not dangerous in the one fever, as **Galenus** says in the commentary of this aphorism: ‘In uallde ... ’ i.e. the quality indeed injures greatly through excessive ebullition in the veins, and this ebullition **Galenus** calls cauma incendium as is clear in pestilential fevers, as **Galenus** says pestilential fever is mild, gentle and not dangerous in the beginning as regards appearance, though it kills without delay through the dangerous character of the unfavourable complexion which is in it. The accidental ailment, indeed, for **Galenus** says it is of two kinds. The first kind, i.e. an accidental ailment which follows the nature of the



---

p.65



disease and is like the cause of the discase, as an unfavourable quality engendered in the body after illness, and in the case of this accidental ailment, according to **Galenus**, cure should be given only with respect to the unfavourable quality from which it was engendered. The second kind, i.e. {TCD 1299 page and line 28b1} when the accidental ailment follows the nature of the disease, and after this disease the accidental ailment continues and is itself the cause of a disease, such as syncope, extreme pain, insomnia, light-headedness, and the like, and this accidental ailment demands a cure not needed by the disease, and the physician is compelled to cure these accidental ailments first and to leave the fever during that time. We answer this question and say the physician should begin from the cause when the fever does not weaken the strength, and when the fever is stronger, weakening the strength, than the cause, then one should begin from the fever, and we say the same with respect to the accidental ailment, and so we leave this question.


{TCD 1299 page and line 28b12}Let it be asked here whether the one cure is suitable for the fever and for the cause and for the accidental ailment; it seems it is not, for **Galenus** says in the second book of Techne: ‘Causa debetur ...’ i.e. digestion and evacuation should be for the cause, and digestion is hot and dry, and evacuation likewise, as **Galenus** says in the eleventh book of De ingenio sanitatis in the fifth chapter, and in the commentary to Prognosticorum in the first book, and in the commentary to Regimenta acutorum in the third book, every digestive and purgative cure should be hot and dry, and every cure suitable for the fever itself should be cold and moist as it is itself hot and dry, as **Hippocrates** says in the Aphorisms: ‘Humidi diete ...’ that for that reason the same cure is unsuitable for fever and cause. Then **Aristotle** says these words: ‘Quod contrarium ...’ i.e. the contrary is not easy in dissimilar things, and fever and the cause of fever are dissimilar and diverse, so the same cure is not suitable for them. Then **Galenus** says a transmuting digestive cure should be given for the cause of the fever, and a purgative cure should be given for the



---

p.66



fever itself, if so, since these are dissimilar, the same cure should not be given for cause and for fever. Then **Galenus** says in De ingenio sanitatis, if syncope comes from the fever, hot things should be given for the syncope, such as pure wine, and cold things for the fever, such as an infusion of barley, so the same cure should not be given for the accidental ailment and for the fever. Then the same man says that, if a flux comes from the fever, styptic things must be given for the flux, and purgative things for the fever, so a similar cure is not to be given for accidental ailment and fever. Then **Avicenna** says in the fourth book in the chapter on putrid fever these words: ‘Causa febris ... ’ i.e. the cause of the fever is increased by the consumption of food, and **Galenus** says in the commentary on Aphorisms, when the unfavourable ailments are dispersing the strength and weakening it, food should be given then, and especially in the status, so the same cure is not to be used for cause and fever. Then **Galenus** says in the sixth book of De ingenio sanitatis these words: ‘In cura ... ’ i.e. in illness of the stomach the same cure serves for cause and illness, and it is not so for other illnesses such as fever and the like, so the one cure does not serve for fever and cause. This is opposed in the book Techne according to **Galenus** who says the cause of the fever and the fever itself are identical, and every cure which serves for the cause is suitable for the fever, so the one cure should be given for cause and fever. Then it seems the one cure serves for the cause and for the fever itself, for **Aristotle** says these words: ‘Unum quoque ... ’ i.e. the property of every cold thing is to transmute and thicken, and **Galenus** says in the commentary of the second *section* of Aphorisms: ‘Omnis digestio ... ’, {TCD 1299 page and line 29a1} i.e. every digestive proceeds to coagulation, and every coagulation goes to coldness, so that the one cure fits fever and cause. Then **Galenus** says that phlebotomy is suitable in fever for it evacuates the cause and cools the body, and every thing that cools the body is suitable for fever, and everything by which proper evacuation is made is suitable for the cause of the fever, so, since phlebotomy does those things in



---

p.67



fever and in the cause of the fever, it should be done in each of them, so the same cure should be used for fever and cause. Then **Avicenna** says in the fourth book that syrup of vinegar and vinegar itself are suitable in fever and in the cause of the fever for they digest and transmute and nourish, and everything that does this is suitable in fever and in the cause, so the one cure should be used for the fever and for the cause. Then he says in De ingenio sanitatis These words: ‘Omne quod ... ’, i.e. everything which expels the cause expels the effect of the cause, so everything which expels the cause expels the effect of the cause i.e. the fever, so the one cure serves for each of them. Then it seems that the same cure serves for the cause and for the accidental ailment, for he says the fever is the matter of the accidental ailment and everything by which the fever is cured cures the accidental ailment, so the one cure serves for cause and accidental ailment. Then **Galenus** says in the book de Accidente et Morbo that the accidental ailment follows the disease as the shadow follows the body, so the accidental ailment is cured by everything that cures the disease. We answer this and say that the cure in respect to the fever is understood in two ways i.e. directly and indirectly; directly when the fever is expelled by cold, moist things as **Hippocrates** said ‘Humidi dicte etc. ’; indirectly i.e. when true tertian is cured by rhubarb which is hot and dry, for when reddish bile which is the matter of tertian is evacuated, tertian is then cured. Understand that the accidental ailments of fever are classed in two ways, i.e. the ailment which accompanies the fever, and the ailment which comes after the fever; the ailment which accompanies the fever such as redness of the checks in peripneumonia, and the darkness and blackness of the tongue in causon and in true tertian, and we say that when these attacks are cured the accidental ailments are cured; and the ailments that come after the fevers, such as syncope and abdominal flux and colic, passion (?) and insomnia, light-headedness and the like, we say that these ailments are not cured by the cure of the fever. And we say that cure is divided in three ways, i.e. in general, specially, and by



---

p.68



number. In general, such as everything cured by its opposite, as **Galenus** says in the second Techne: ‘Omnis cura ... ’, i.e. every illness being cured by its contrary in equal degrees. Specially, further divided into four (recte three) parts, i.e. its quality and its quantity and its substance. Its quality, such as heat and moisture, cold and dryness, heat and dryness, cold and moisture. Quantity, such as fullness and emptiness. Its substance, such as thickening and attenuation and cutting and cleaning and the like. From the number, indeed, such as the illness in the fourth degree which should be given a contrary cure corresponding to that degree.


{TCD 1299 page and line 29a49} Let it be asked here whether nature is helped by the cure externally or internally; it seems it is not, for **Galenus** says in the third book of De ingenio sanitatis: ‘Natura non ... ’ i.e. nature is not deficient in anything, so nature is not relieved by the cure externally or internally. Then **Aristotle** says in the first book of De generacionis that there is no reaction between the corporeal and the incorporeal, and nature is incorporeal and the cure corporeal, {TCD 1299 page and line 29b1} so there is no reaction between them, and, since there is not, nature is not relieved by the cure. Then **Galenus** says in De ingenio sanitatis the words: ‘Nil inuenitur ... ’ i.e. there is nothing which helps nature but injures nature first, and **Galenus** says that no cure helps nature more than a digestive, and digestion does not injure nature according to **Galenus**, so nature is not relieved by any cure. Then **Galenus** says in the first De interioribus: ‘Natura non ... ’ i.e. nature does not need the help of the cure except when it cannot of itself overcome the illness, or when the illness is greater than nature, and, when the illness is stronger than nature, then it is mortal, so nature is not relieved by the cure, for **Galenus** orders that the cure should not be given in mortal illnesses. Then **Galenus** says in the commentary of the second book of *the*  Aphorisms, that nature is not relieved by anything outside of nature, and the cure is against nature, so nature is not relieved by the cure. Then **Galenus** says that if any cure helps nature it is digestion, and everything that is ready for corruption does not help nature, and the qualities



---

p.69




of digestion are ready for corruption i.e. heat, moisture, so nature is not helped by the cure. Then **Aristotle** says in the third book of fisicorum[1](javascript:footNote('T600020/note001.html')) that the cure does not work in the human body until the natural heat acts in the cure, so since the natural heat must work against the cure, nature is weakened by the cure. This is opposed according to all the doctors. Then it seems it is not suitable to give a digestive in every continuous putrid fever such as synocha, for **Galenus** says it is not suitable to give a digestive in this fever. Then it seems that a digestive should not be given at all, for **Hippocrates** says in this canon: ‘Si ex ... ’, i.e. that Phlebotomy should be used when the four humours increase together, and the humour-cure should be given when one humour errs alone, if so, **Avicenna** says that digestion is simply the preparation of the matter that is not ready for expulsion on account of coagulation and viscosity, and, when the four humours increase together, digestion is not needed but evacuation by the vein, as we have said, and when one humour errs, it should be purged by a humour-cure likewise, so it is not suitable to give a digestive at all. Then **Galenus** says a digestive should not be given in mortal illnesses such as colic and synocha and frenzy and quinsy and anthrax, as **Hippocrates** says in the first *section* and in the fourth *section* of the Aphorisms, so a digestive is not suitable in every fever. Then a digestive is not suitable in a fever from reddish bile, for **Galenus** says in the ninth book of De ingenio sanitatis, every digestive is hot, and it is not suitable to give hot things in a fever from reddish bile, so a digestive should not be given in every fever. This is opposed, for **Galenus** says it is suitable to give a digestive in sinoca inflatiua, and there is no fever in which a digestive should less be given than in synocha, so a digestive is suitable in every fever. Then **Galenus** says that every fever ending in crisis must be given a digestive, for the function of nature in the crisis is first to digest, then to disperse and finally to expel, so a digestive should be given in every fever. Then **Avicenna** says in the fourth book that an illness begins only from the degree of digestion, so a digestive should be given in every illness. Then **Galenus** says it is a sign of immediate



---

p.70




health in every illness to see the sign of proper digestion, so since the signs of digestion are natural, the physician should give a digestive in every illness. We answer that and say that it is suitable to give a digestive in every corrupt fever.


{TCD 1299 page and line 29b54} Let it be asked here whether all digestion works through heat and dryness; it seems to be so, for **Hippocrates** says that cold is an enemy of nature, and digestion is its friend, so every {TCD 1299 page and line 30a1} digestive is hot and dry. Then **Galenus** says in De ingenio sanitatis these words: ‘Illud quod ... ’ i.e. everything that injures people in health, injures still more sick people, and cold injures people in health, so it injures still more sick people, if so, since digestion relieves well and sick, it is understood to be by heat. Then **Avicenna** says in the chapter on energies these words: ‘Frigidum non ... ’, i.e. cold does not enter into natural operations, and that is not the case in operations of the digestion, for it much benefits nature, so every digestive works by heat. This is opposed according to **Galenus** in De ingenio sanitatis, who says every digestive is contrary to the matter for which it is given, if so, since fever is hot and dry, the digestive for fever should be cold and moist. Then **Avicenna** says in the same chapter these words: ‘Aqua frigida ... ’ i.e. cold water helps digestion in subtle choleric matter, so digestion is caused by cold. Then **Haly** says in the first book of Techne that hot matter is digested by cold, so digestion is not caused by heat. Then **Galenus** says in De ingenio sanitatis that the compound called oxisacra should be given to digest the thick matter, and it is clear that oxisacra itself is cold, so digestion does not work by heat. Then **Galenus** says in the tenth book of De ingenio sanitatis these words: ‘Aquam frigidam ... ’ i.e. cold water induces perspiration and abdominal flux, so since the function of a digestive is to prepare the matter for expulsion, and since cold water does those things we have said, it is understood that digestion is not caused by heat. We answer this question and say that there are two conditions the physician must examine for digestion, i.e. the closeness or openness of the pores through which 


---

p.71




the matter is expelled, and the viscosity or obstinacy of the matter to be expelled. And we say that in the former of these every digestive cure should be hot, for the function of heat is to open and to widen, and the function of cold is to close and narrow naturally, and we say similarly that a hot digestive should be given in corruption. The second condition i.e. viscosity and obstinacy of the matter, and we say that the digestive should be compounded then of hot things and bitter, acid things i.e. the bitter things cutting the viscous matter, and the hot things opening the pores, and so we leave that question.


{TCD 1299 page and line 30a39} Let it be asked here whether one can die in acute fevers after the digestion of the matter: it seems one can according to **Galenus** in the book On crises, for he says one can die in the decrease of the illness, and the decrease is after the digestion of the matter, so one can die after the digestion of the material in acute fevers. Then **Constantinus** says in the book of Theriace[2](javascript:footNote('T600020/note002.html')) that he himself saw many die in the status of acute fevers, and the digestion is completed in the status according to **Galenus**, so one can die in acute fevers after the digestion of the matter. Then **Galenus** says that death comes from weakness and decrease of strength, and the decrease of the illness is the period in which the strength is weakest, and the decrease follows the digestion of the matter, so one can die after the digestion of the matter in acute fevers. Then **Galenus** says in the second book of Prognosticorum, in the signs of peripneumonia, that the matter can be digested in this illness, and that it cannot be expelled, and he says there are two things which must be examined in illnesses from which one recovers, i.e. the digestion of the matter and the strength of nature for its proper expulsion, and one can die through the non-expulsion of the matter even though it be digested, as is clear in peripneumonia, so one can die in acute fevers after the digestion of the matter. This is opposed according to **Galenus** in the book De Crisi who says he never saw anyone die who had the complete signs of digestion. We answer that question and say one cannot die in the natural course after the digestion of the



---

p.72



matter, and one can from the accidental ailment. And that accidental ailment can come from three things .i.e. through disregard of the physician, or from another illness succeeding the first, or from error concerning the energies, for **Galenus** says, if the physician and attendant of the patient be mistaken, that prepares one for death even though the matter be digested, and **Galenus** says, if an illness come during the decrease, even though it be slight, it induces death from the error about the energies, for **Galenus** says, if the natural expelling energy and the animal energy be confused in operation, that one can die from that confusion


{TCD 1299 page and line 30b17} Let it be asked here whether a digestive should be given in the increase of the illness; it seems it should not, for **Galenus** says the digestive is given to diminish the matter of the illness, and it cannot be diminished in the increase, so a digestive should not be given in the increase. Then **Galenus** says a digestive should not be given when the unfavourable accidental ailments are very strong, so since the unfavourable accidental ailments are very strong in the increase, a digestive should not be given then. Then digestives are not used except when the natural heat is powerful to act in them, and the natural heat is being turned into fierce heat in the increase, so a digestive should not be given in the increase of the illness. Then **Constantinus** says the increase is simply the perfecting of digestion, so since the digestion is completed in it, a digestive should not be given in it. This is opposed, and we say on the authority of **Galenus** that a digestive should be given in the beginning and the increase of the illness. We answer that and say that digestives are divided in three ways, i.e. evident digestion, obscure digestion, and perfected digestion, and we say that the obscure digestion is in the beginning of the illness, and it is evident in the increase, and it is perfected in the status, and this distinction is made for a curable illness.


{TCD 1299 page and line 30b38} Let it be asked here if food causes digestion of the matter of the illness; it seems it does not, for **Galenus** says in the book De Causis that digestion is simply transmuting the matter of the illness, and food, as such, does not 


---

p.73




transmute thus, but increases the matter it finds in the body, as **Hippocrates** says in this canon: ‘Non pura ... ’ i.e. that impure bodies are injured by nourishment, so food does not digest the matter of the illness. Then **Hippocrates** says in the commentary of the Aphorisms these woods: ‘Natura impetitur ... ’ i.e. nature is hindered from digesting the illness through the consumption of food, so the matter of the illness is not digested by food. Then **Galenus** says in the commentary of Regimenta acutorum these words: ‘Eadem est ... ’ i.e. the physician should have the same intention in giving food to healthy people and to sick people, and food is not given to healthy people to digest the matter, so it should not be given to sick people to digest the matter. Then **Galenus** says in De ingenio sanitatis that the matter is thickened and the constrictions are increased by the consumption of food, so the matter is not digested hy food. That is opposed according to **Haly** in the commentary to Techne who says that labour and consumption of food digest the matter of the illness, so food works towards the digestion of the matter of the illness. Then **Hippocrates** says in the first book of Regimenta acutorum these words ‘Ptisana est... ’ i.e. I have found no food whatever better for sick people than an infusion of barley, for it expels corruption and digests the matter of the illness. Then **Hippocrates** says in the fourth book of Aphorisms in this canon: ‘Oportet ad ... ’, i.e. the body should be prepared by moderate foods before the purgative called **hellebore**, and it is for the digestion of the matter **Hippocrates** orders that, so digestion of the matter is caused by food. Then **Avicenna** says in the fourth book these words: ‘Cibus moderatus ... ’ i.e. moderate food relieves the energy and natural heat, and since digestion is simply the functioning of the natural heat it is understood that digestion is caused by moderate food. We answer that according to **Galenus** in the commentary to this canon: ‘ad eliborus’,[3](javascript:footNote('T600020/note003.html')) who says there are two ways in which food is given to sick people, i.e. food as food, and food as food and cure; food as food has the property of increasing, fattening and nourishing the substance of the body, and digests the matter



---

p.74



 
only incidentally by strengthening the energies and the members. Food as food and cure digests directly and transmutes the offending matter if it be of an opposite kind to it. And note that in every material fever there are initial cause, antecedent cause and connective cause, so that on that account


{TCD 1299 page and line 31a27} Let it be asked here for which of these causes digestion is suitable; it seems it is for the connective cause, for **Haly** says in the commentary to Techne, ‘Causa antecedenti ... ’, i.e. the antecedent cause should have evacuation, and the connective cause a digestive. Then the same man says that digestion is simply a change that hinders corruption, and corruption is simply the connective cause, so a digestive should be given in the connective cause. This is opposed, for **Galenus** says (the connective cause) makes no delay after the status in disappearing, so since the connective cause is in the status, a digestive should not be given for it. Then **Galenus** says digestion should check corruption, and the connective cause is not checked until the status, and digestion is not needed in the status, so a digestive should not be used for the connective cause. We answer that and say that digestives should be given for the antecedent and connective causes.


{TCD 1299 page and line 31a42} Let it be asked here whether phlebotomy is suitable in any fever; it seems it is not, for **Galenus** says the physician should imitate nature and follow its operations, and the proper work of nature is to expel everything excessive and injurious, and there is no fever in which nature expels the blood, so the physician should not practise phlebotomy in any fever. Then **Galenus** says blood should not be let when it evacuates good blood along with bad blood, for the evacuation of the good blood along with the bad blood injures more than it relieves, and the vein could not be opened in fevers without expelling the good blood in it, so phlebotomy should not be practised in fevers. Then **Galenus** says that the (opening of the) vein evacuates only the humour that offends inside the veins, and the matter of intermittent fever is outside the veins, and **Avicenna** says 


---

p.75




these words: {TCD 1299 page and line 31b1}: ‘Venole exicate ... ’ i.e. when the veins are evacuated they attract to themselves crude humours, and continuous intermittent *fever* is created then, so phlebotomy is not suitable in any fever. Then phlebotomy is not suitable in chronic illnesses, for **Galenus** says light diet should not be given in chronic illnesses, as **Hippocrates** says in this canon: ‘In diurna ... ’, since light diet is a sort of purgative, blood-letting is still more a sort of purgative, so it is not suitable in chronic illnesses. And **Galenus** says phlebotomy is not suitable in fever accompanied by great heat, and no fever is without heat, so blood should not be let in any fever. Then **Avicenna** says when the energy is weak blood should not be let, and it should not be let when the energy is powerful as **Hippocrates** says in this canon: ‘Ea corum ... ’, so blood should not be let in any fever. This is opposed according to **Galenus** in the nineteenth book of De ingenio sanitatis, for he says not only is phlebotomy suitable in sinoca inflatiua, but it is suitable in every corrupt fever unless the energy or age of the patient prevent it. Then **Galenus** says there are two things which come from phlebotomy in fevers, i.e. the lowering of the excessive heat and the expulsion of the corruption, so phlebotomy is suitable in every fever. Then **Galenus** says in the commentary to the Aphorisms in this canon: ‘Dolores oculorum’ Speaking of curing the eyes, for he says there when many humours offend together, blood should then be let, and many humours offend in corrupt fevers, so blood should be let in them. We answer that according to **Galenus** who says whenever the energy be relieved by blood-letting, even though the fever be the greater for it, it should be let, for **Galenus** advises blood-letting to strengthen the energy, and humour-cure to expel the matter of corrupt fever.


{TCD 1299 page and line 31b27} Let it be asked here which is more profitable in fevers, the humour-cure or phlebotomy. It seems the humour-cure is more profitable, for the humour-cure expels only the offending matter, and it is not so of phlebotomy, for it evacuates offending and harmless matter, so the humour-cure is more profitable in fevers than phlebotomy. Than **Galenus** says the evacuation caused by the humour-cure is natural 


---

p.76



and scientific *(vide H, 2. 12)*, and evacuation caused by bloodletting is scientific only, so the evacuation due to nature and science is more beneficial than phlebotomy. Then **Galenus** says the evacuation which least expels natural heat and spirits is most beneficial in fevers, and it is clear that heat and spirits are less expelled by the humour-cure than by evacuating the blood, so the humour-cure is more profitable in fevers than evacuation of the vein. Then **Galenus** says the evacuation which most frees the constrictions is most profitable in fevers, and the humour-cure frees the constrictions more than phlebotomy, so the humour cure is more beneficial in fevers than phlebotomy. This is opposed according to **Galenus** who says bloodletting evacuates only the amount the physician wishes, and it is not so of the humour-cure, for it evacuates the humours excessively at times against the physician's wish, so bloodletting is more beneficial in fevers than humour-cure. Then **Galenus** says all humour-cures are in the nature of poison and inimical to nature, and that is not so of evacuation of the vein according to **Galenus**, so phlebotomy is more profitable in fevers than the humour-cure. We answer that and say that the humours offend in two ways, i.e. sometimes in quality and sometimes in quantity, and when they offend in quantity blood should then be let, and when they offend in quality the humour-cure should then be used.


Let it be asked here should blood be let in the {TCD 1299 page and line 32a1} beginning of fevers. It seems it should not on the authority of **Avicenna** in the first book saying: ‘Phlebotomia ... ’, i . e. the blood should not be let before the digestion of the matter, so it should not be let in the beginning of fevers. Then **Galenus** says the physician should follow the natural operations, and nature does not expel any part of the illness at its beginning, so the physician should not expel it, as **Hippocrates** says in this canon: ‘Incipientibus ... ’. Then **Avicenna** says there are two things preventing the humour-cure and phlebotomy in fevers, i.e. the strength of the unfavourable accidental ailments and the crudeness and thickness of the matter, and it is of the strength of the unfavourable ailments **Hippocrates** spoke in this canon: ‘Digesta ... ’, so 



---

p.77



either phlebotomy nor humour-cure should be used in the beginning of fevers. Then **Avicenna** says that one must wait for the digestion of every matter that is in one place before expelling, and the matter of intermittent fever is in one place outside the veins, so blood should not be let in the beginning of these fevers. Then **Galenus** says in the first *book of* De Crisi that the cause of ulcers and of fever is the same from the point of view of evacuation, and the matter in an ulcer should not be evacuated till the status, so purgatives should not be given in fever till the matter be digested. Then **Galenus** says nature should be relieved when it needs relief, and **Galenus** says nature does not need relief in the beginning of the illness, so blood should not be let in the beginning of fevers. This is opposed in the eighth book of De ingenio sanitatis, for **Galenus** says one should do all that prepares and hastens the matter towards digestion, and **Galenus** says phlebotomy in the beginning of fever hastens the matter towards digestion, so phlebotomy is suitable in the beginning of fevers. Then **Galenus** says in the chapter on sinoca inflatiua that one should not wait for the digestion of the matter nor for the crisis without letting blood, so blood should be let in the beginning of fevers. Then **Avicenna** says blood should be let when energy is strongest, for the physician should not let blood during weakness of energy, so since there is none of the four periods of the fever in which the energy is stronger than in the beginning, it is then blood should be let. Then **Avicenna** says that, whenever nature is strong and the matter plentiful, blood should then be let, and the matter is plentiful and nature strong at the beginning of fever, so blood should be let in its beginning. We answer that and say according to **Avicenna** in the fourth book that there are three classes in which evacuation is given with regard to the cause (or ‘from the vein’), i.e. hora electa expediens et eiroina; hora electa, i.e. the chosen, proper time, and the number of days and the prohibited times should not be examined for this if the energy is strong and the invalid in need of it. Expediens indeed, i.e. when evacuation benefits nature more than it injures it. Eiroina, i.e. when the illness is increased by the evacuation and the natural heat decreased.




---

p.78


 {TCD 1299 page and line 32a45} Let it be asked here should baths be given in every fever; it seems not, for **Galenus** says in the second book of Remedia acutorum, that one should not bathe with a phlegmatic fever, and the reason of that is that it disperses the light matter and leaves the heavy matter undispersed, so baths should not be taken in every fever. Then **Galenus** says that everything that increases the corruption and preserves it should not be done, and **Galenus** says corruption is increased and preserved by bathing, so it should not be done in fevers. Then **Galenus** says in the commentary of the fourth *section* of Aphorisms that one should not bathe in hot water in a fever accompanied by ulcers, so bathing is not suitable in every fever. Then **Galenus** says bathing expels only the excess of the third digestion, and the matter between flesh and skin, and the matter of continuous fever is not there but internal in the veins, so bathing is not suitable in every fever. Then **Galenus** says in the commentary of this aphorism: ‘Sub cane ... ’,[4](javascript:footNote('T600020/note004.html')) and **Aristotle** says these words: ‘Balneum ... ’ i.e. bathing in fevers is opposed to the evacuation of the matter, so bathing is not suitable in fevers. This is opposed according to **Galenus** in the eighth book of De ingenio sanitatis for he says bathing is suitable in ephemeral fever, and in the tenth book that it is suitable in hectic fever, and in the eleventh book that it is suitable in putrid fever, so bathing is suitable in every fever. Then **Galenus** says in the tenth book of De ingenio sanitatis that everything that cools the body and moistens it is suitable in corrupt fever, and bathing cools and moistens the body, so it should be given in putrid fever. Then **Galenus** says that everything which digests the offending matter and expels it and cools the body is suitable to give in fevers, and **Galenus** says bathing in sweet water does those things, so it should be given in every fever. We answer that and say that bathing is serviceable in ephemeral fever in every period, and it should not be given in hectic fever, for there are three reasons for hindering it in the hectic, i.e. because it is dispersing, and because it is hot, and because it is purgative, for those three things are directly opposed to hectic fever. The giving of baths in putrid fever is 



---

p.79



understood in two ways, i.e. with regard to the accidental ailment and with regard to the fever itself. With regard to the ailments, there are six conditions for hindering bathing. The first condition, i.e. a bath should not be given if the fever patient has abdominal flux, for if the flux is checked, the matter is drawn to the principal members and causes then an increase of the injury. The second condition, i.e. a bath should not be given if the fever patient suffers from constipation, for it would make the body diseased (or ‘too dry’?). The third condition, i.e. if the energy is weak, a bath should not be given. The fourth condition, a bath should not be given to people who suffer habitually from nausea and vomiting. The fifth condition, people in choleric delirium (?)[5](javascript:footNote('T600020/note005.html')) should not be put in a bath. The sixth condition, i.e. people with a flux of blood, or ready for it, should not be put in a bath.


 {TCD 1299 page and line 32b35} Let it be asked here should cold moist diet be given in fevers; it seems not, for **Avicenna** says the food given to fever patients should be easily digested, and, penetrating, and laxative, and cold moist diet is not so, so it should not be given in fevers. Then **Galenus** says in De ingenio sanitatis that the diet should be given with regard to the complexion and not with regard to the fever, so, if a man of reddish bile surfers from tertian fever, a diet to increase reddish bile should then be given, if so, cold moist diet should not be given in fevers. Then **Galenus** says there are three things to be examined in giving diet in fevers, i.e. age and complexion and habit, so cold moist diet should not be given in fevers. Then **Galenus** says in the commentary to the Aphorisms that humidity is the mother of corruption, and Isaac says the same thing in the book on fevers: ‘Omne quod ...’ i.e. everything that takes to corruption is moist, so cold moist diet should not be given in fevers. Then Isaac says in the book on fevers these words: ‘Frigidum auget ...’ i.e. coldness increases the constrictions, and the constrictions are the matter of corruption, so cold moist diets are not suitable to give in fevers. This is opposed according to **Hippocrates** who says fever patients should have cold moist diet.




---

p.80


 {TCD 1299 page and line 32b55} Let it be asked here whether sleep injures more in the beginning of the paroxysm than in the other periods; it seems it does more in the beginning, for **Galenus** says that every injury done in the beginning of the paroxysm {TCD 1302 fol col and line fol 6a2line2} continues throughout the three other periods, so sleep does more harm in the beginning of the paroxysm than in every other period of it. This is opposed according to **Galenus** in the second *section* of Aphorisms saying that if sleep injures in the decrease it is a sign of death, and it is not so in the beginning, so sleep does more harm in the decrease of the paroxysm than in its beginning. We answer that and say that there are three classes of sleep, i.e. sleep which is altogether natural, unnatural sleep, and sleep which is neither natural nor unnatural. And sleep which is altogether natural is as **Avicenna** says: ‘Maximus ...’, i.e. great sleep which is called maximus, and deep sleep which is called profundus, and extensive deep which is called multus. And unnatural sleep is as subeth[6](javascript:footNote('T600020/note006.html')) and the like. And sleep neither natural nor unnatural is as the sleep one has after walking or great labour or work, for **Galenus** says this sleep is neither natural nor unnatural. And **Galenus** says sleep is understood in two ways, i.e. directly and indirectly, and **Avicenna** gives this conclusion, that direct sleep is altogether natural and beneficial, and accidental sleep is injurious and unprofitable. And **Galenus** says the sleep taken in the decrease of the illness injures more than in every other period of the paroxysm.


 {TCD 1302 fol col and line fol 6a2line22} Let it be asked here whether crude humours are generated from food given in the paroxysm. It seems they are not, for **Galenus** says in the aphorism of paroxysm that the ebullition is strongest then, and when the ebullition is greatest it is then easiest to boil and digest the food, so for that reason crude humours are not generated from the food given in the paroxysm. **Constantinus** opposes this, for he says if food is given in the paroxysm at the time of these three faults (or for ‘cailed’, ‘qualities’), namely frigus, rigor and oripilacio, that crude humours are generated from them and one is in danger from those humours, so 



---

p.81



crude humours are generated from food given in the paroxysm. And crude humours are formed from two causes, i.e. from weakness of the natural heat, from winch an increase of phlegm is created in the complexion by a humour leaving its own measure and becoming immoderate, as reddish bile offending in quantity, and black bile likewise. We answer chat and say that crude viscous humours are generated by the food given in the paroxysm.


 {TCD 1302 fol col and line fol 6a2line36} Let it be asked here whether food should be given more in the beginning of acute illnesses than in every other period. It seems food should not be given at the beginning, for **Hippocrates** says in the first book of Remedia acutorum that food should not be given to pleurisy patients until the nutritiveness and moisture of the lips is evident, and **Galenus** says that that sign {TCD 1302 fol col and line fol 6b1line1} is not evident until after the digestion of the matter in the increase or in the status, so food should not be given to patients in acute illnesses at the beginning. Then **Hippocrates** says in the first book of Remedia acutorum that barley water should be given at the beginning of the illness and *the* solid part should be given in the increase and in the other periods, so food should not be given in the beginning of acute illnesses. Then **Galenus** says in De ingenio sanitatis that wine should not be given in acute illnesses until the matter be digested, from that it is understood that more solid food than wine should not be given till the matter be digested, and the matter is not digested in the beginning of acute illnesses, so food should not be given in the beginning. Then **Galenus** says that food should least be given at every period where the burden and labour of nature is greatest, and the period where the labour and burden of nature is greatest is when the matter is undigested, so since the matter is undigested in the beginning of the illness food should not be given then. Then **Avicenna** says in the chapter of synocha, in the kind called epacmastic, that food should not be given in the beginning, for it is a fever that is habitually decreasing, and the unfavourable ailments are stronger at the beginning than in every other period of it, so food should not be given at the beginning of acute illnesses. 


---

p.82


**Hippocrates** opposes that in this canon: ‘Quibus est ...’ We answer these questions and say according to **Galenus** that there are two static periods in every acute illness, i.e. a status of the matter, and a status of the accidental ailment. The status of its matter, indeed, i.e. every time the matter is completely digested we call it the status of the illness then, as Galenus says in the first *[book of]* De Crisi. The status of the accidental ailment, indeed, i.e. every time the accidental ailments are strongest is called the status of the illness as is evident in pleurisy patients, for every time the pain is greatest, and the breathing most difficult, and the cough hardest, we say the the pleurisy is at the status, and this status can be at the beginning of the pleurisy according to **Galenus**. Note that the unfavourable ailments can be violent and the matter digested at the same time. And understand that the digestion and expulsion can be at the same time, as is evident in pleurisy patients, and in other ulcers expelled by obscure dispersion, {TCD 1302 fol col and line fol 6b2line1} and we say the unfavourable ailments are diminished then by the digestion of the matter. And **Galenus** says there are other illnesses and when the matter is digested it is increased by them, until it be expelled along with the disease, as is evident in the ulcers that break of themselves. And diet is divided likewise, i.e. complete and partial diet. Complete diet is the diet ordered from the beginning of the illness till the day it ends. Partial diet is diet ordered in the four periods of the illness. And **Galenus** says that, every time the energy is strong and uncorrupted from the beginning of acute illnesses to the status, food should not be given then until the status, and, when the energy is weak and the unfavourable ailments violent in the beginning of the illness, food should be given then to
maintain the energy.


 {TCD 1302 fol col and line fol 6b2line13} Let it be asked here whether continuous fever is created by internal ulcers, or intermittent fever. It seems it is continuous fever, for **Galenus** says there are three matters of disease in the ulcer alone, i.e. unfavourable complexion, and offending matter, and continuous dispersal, and **Galenus** says continuous fever can be caused by the unfavourable 


---

p.83



 

complexion alone, if so, it can the more be caused with the other two it is continuons fever which is created by internal ulcers. Almusor opposes this and says oripilacio is the sole cause there, and oripilacio occurs only in intermittent fever, and an ulcer is formed only outside the veins in the pores of the members, the proper place of intermittent fever, so it is intermittent fever which is created from internal ulcers. And apostema is the swelling (?) of a member unnaturally due to flatulence or an offending humour, and apostema is created from two causes, i.e. when a strong member expels its excess to a weak member forming an ulcer in the member, and **Avicenna** calls this condition apostema direuaciones i.e. an ulcer which comes from the diverting of the excess of a strong member to a weak member. The second cause, when nature leaves an excess of nourishment in a member without evacuating it, it stays viscously bound in the member, and from that are generated unfavourable complexion and continuous dispersal, and after that the ulcer called apostema congestiones, i.e. an ulcer caused by choking and viscosity ot the matter. We answer this question and say that every corrupt ulcer in the neighbourhood of the heart must cause continuous fever, for that ulcer sends horrible corrupt vapours {TCD 1302 fol col and line fol 7a1line1} to the heart, and the heart moves to expel that vapour, and that movement inflames the natural heat causing continuous fever. And Isaac says in the book of fevers, when the ulcer is on the spleen intermittent fever is created by it, and its access occurs from the fourth day on as in quartana. And he says in the same place that ephemeral fever is created by an ulcer of the internal members, and again by an ulcer of the external members, and so we leave that question.


 {TCD 1302 fol col and line fol 7a1line8} Let it be asked here whether the coming of rigor and bleeding from the nose are a good symptom in causon. It seems the coming of rigor at first is a good symptom, for **Hippocrates** says in the fourth *section* of Aphorisms this canon: ‘Quabsone ...’ i.e. that causon is cured when rigor ensues.[7](javascript:footNote('T600020/note007.html')) Nose-bleeding coming in it is a good symptom according to **Avicenna**, who says if vomiting, or delirium (?),



---

p.84



or nose-bleeding, or perspiration come in causon, the causon is cured by them, so the coming of rigor and nose-bleeding is a good symptom in causon. Isaac opposes this in the fourth chapter of the book of fevers, saying that the coming of rigor in causon is a bad symptom. And causon is a fever caused by choleric blood in the veins adjoining the principal members. Then Isaac says causon is a continuous fever created by reddish bile or salt phlegm in the veins of the whole body, and especially in the veins adjoining the heart and stomach and liver. And rigor according to **Avicenna** is a bad disposition of the whole body together with inordinate movement and trembling. We answer these questions and say that, if rigor comes in causon, without the coming of nose-bleeding, the sign of digestion is evident and its coming on the day of crisis announces recovery according to **Avicenna** in the chapter of rigor. Then Isaac says in the book De febribus, if nose-bleeding come in causon on the day of crisis it announces recovery without doubt. And **Galenus** says, if rigor come contrary to those conditions we have mentioned, it announces death.


 {TCD 1302 fol col and line fol 7a1line31} Let it be asked here can disease be contagious. It seems it cannot, for **Aristotle** says these words: ‘Accidens autem ...’, i.e. the accident does not pass from subject to subject, and disease is an accident, so it does not affect one person from another. **Avicenna** opposes this in the first canon, and **Hippocrates** in the sixth *section* of Aphorisms and **Avicenna** in the twenty-seventh canon, saying {TCD 1302 fol col and line fol 7a2line1}) ‘arteitica ...’ i.e. arthritis and gout are hereditary contagious diseases, so disease can be contagious, as **Gordonius** says these words: ‘Antrax...’, these are the contagious diseases: Anthrax, i.e. an ulcer caused by a mixture of the three humours red blood, reddish bile and black bile, so that it has these three colours, red, yellow and black, and on account of the violence of the matter making it, it is contagious . ‘Lipa’ i.e. a disease of the eyes; ‘lepra’ i.e. leprosy. ‘Frenisis’ i.e. madness, and these give contagion to another, and **Galenus** says here one should not dwell in the neighbourhood of people suffering from the contagious diseases we have mentioned, 



---

p.85



and especially pestilence patients. And he says too not to associate with them in confined places. And the same man says further one should avoid people who die in these attacks, and especially in pestilence, and the air round them should be avoided, and the herbs which grow in graveyards where these bodies are buried should be avoided by people and animals, tor the philosopher says these words: ‘Virtus pabili ...’. And the same man says one should avoid every evil odour in a time of plague, and one should avoid the fruits of trees and herbs likewise, the body should be given plenty of food and drink and frequent evacuation as is fitting. We answer that and say a similar or dissimilar disease can be created from imitation (?), as **Galenus** says paralysis and syncope and epilepsy are formed from reddish bile, and peripneumonia, pleurisy, and lethargy from frenzy, and leprosy and albus from morfea. And **Avicenna** says the accidental ailment of an illness causes a complete disease in a member, such as frenzy causing headache. And the same man says that just as a disease is generated by a disease, so a disease is cured by another disease, as is clear in the fever that comes after spasm, and in quartana coming from melancholy. Then **Avicenna** says there are certain waters and herbs creating contagious disease directly, such as euphorbia and acosinne, and it is created likewise from a change in the direction of the weather, and the illnesses we have mentioned are cured by that {TCD 1302 fol col and line fol 7b1line1} change. And the same man says that disease *is created* from the thoughts, by the movement of the animal (?) energy, as is evident in people who are nauseated by seeing sour fruits being eaten, such as crab apples and the like.


 {TCD 1302 fol col and line fol 7b1line5} Let it be asked here what diet should be given in chronic fevers. It seems it should be heavy diet, for **Galenus** says in the commentary to the Aphorisms that fish and eggs and flesh should be given in chronic fevers and these constitute heavy diet according to **Avicenna**, so heavy diet should be given in chronic fevers. Then **Avicenna** says in the chapter on quartana that piglets' brains roasted, and cocks' genitals, and thick infusion, should be given to quartana

 


---

p.86



patients, and these are reckoned as heavy diet, so heavy diet should be given in chronic fevers. Then **Avicenna** says the energy should be maintained in chronic illnesses and the same man says energy is not maintained by light diet, so heavy diet should be given in chronic levers. This is opposed on the authority of Isaac, for he says heavy diet should be given to healthy people, and a diet contrary to that of healthy people is ordered for invalids, so light diet should be given to patients in chronic fevers. And **Avicenna** says chronic illnesses are divided in two ways i.e. simple illness and compound illness; simple illness, i.e. an illness that comes from one humour as tertian comes from reddish bile and quotidian from phlegm; compound illness, i.e. illness caused by a mixture of humours such as anthrax and the like. Then again these illnesses are divided in two ways, i.e. a group of them called acuta, and a group called chronica, i.e. acute illness and chronic illness. And acuta is divided in three ways, i.e. acuta, peracuta, and acutissima. And acuta is a fever terminating on the seventh day. Peracuta terminating on the fourth day. Acutissima i.e. an illness terminating on the second or third day. And there is another acute illness called acuta absoluta terminating on the ninth day. Acuta non absoluta terminates on the twentieth day. And there is another acuta, i.e. acuta residiuaciones i.e. an acute illness with relapse which terminates in a month. And there is acuta chronica terminating on the thirty-first day, or the thirty-fourth day, or in forty days, as **Aristotle** says they are chronic from that out. And diet too is {TCD 1302 fol col and line fol 7b2line1} divided in three ways i.e. light diet and heavy diet and a mean diet, and light diet is the offering (?) of suitable food and drink *according to* time and order and number, and heavy diet is ..... healthy, and mean diet is partial diet helping (?) each of them as ..... infusion and cold moist pottage as ..... woodbine and the like. And ... feet and snouts of piglets and little wild birds and soft ... and small fish ... and white bread soaked in cold water and mellicratum and the like. And **Avicenna** says the habit of people should be studied in giving diet i.e. people accustomed to 



---

p.87



food twice or thrice in health, should have it the same number of limes in illness, as **Hippocrates** says. And diet is given with respect to the energy from two causes, i.e. to maintain the energy for fear it should decrease. The second cause *[is]* to stir up nature against the matter of the disease. And there is another diet which stirs up nature and maintains *[it]* at the same time, and this diet should be given in illnesses terminating on the seventh day, such as acuta, and these constitue that diet, namely mellicratum and julep and refined infusion ... and the like. We answer this question and say every chronic illness due to a humour should have light diet and every chronic illness due to evacuation should have heavy diet.


 {TCD 1302 fol col and line fol 7b2line22} Let it
 be asked here should diet be given to people near death. It
 seems it should as **Avicenna**
 says food should be given to spasm patients when it is due to
 ... that this spasm is mortal, so diet should be given to people
 near death. Then .... de
 Interioribus these words: ... i.e. **Galenus** said .... and those *understood* here are .... a
 suitable cure for them .... Then **Galenus** says .... to be given in the
 third class of hectic fever, and it is clear ... as Platearius
 says and many other .... diet should be given to people near
 death. **Galenus** opposes
 this in the Aphorisms[8](javascript:footNote('T600020/note008.html'))
 and says ... i.e. people near death should make their
 confession. And **Galenus**
 says the same thing in the tenth book of De
 ingenio sanitatis ‘Ne recipiam ...’
 i.e. he says ... *End of
 fol. 7*














