

#A Treatise of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Treatise of Ireland
=====================


Author: John Dymmok
-------------------


### File Description

Richard ButlerElectronic edition compiled by Beatrix Färber

Proof corrections by Beatrix Färber, Janet Crawford, Donal Whelan

Funded by University College Cork, School of History 1. First draft.Extent of text: 32680 words#### Publication


CELT: Corpus of Electronic Texts: a project of the History Department, University College Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2012) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E590000-001Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only. The text on which this electronic edition is based is in the public domain. 


#### Sources


**Manuscript source**2. London, BL, Harley 1291. Butler describes it as "a small quarto, on paper, written about the year 1600".
**Internet availability**2. The text is available in .pdf format at http://www.archive.org.
**Works mentioned by Butler**2. Richard Stanihurst, 'Description of Ireland', in: Raphael Holinshed, Holinshed's Chronicles (London 1577).
3. William Camden, Topographia Hiberniae (Frankfurt 1602).
4. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
5. Fynes Moryson, An itinerary, containing his ten yeeres travell through the twelve dominions of Germany, Bohmerland, Sweitzerland, Netherland, Denmarke, Poland, Italy, Turky, France, England, Scotland & Ireland. (London 1617).
6. O'Sullivan Beare, Historiae Catholicae Iberniae Compendium (Lisbon 1621). (Available in .pdf format on www.archive.org.)
7. Meredith Hanmer, Edmund Campion, & Edmund Spenser, The historie of Ireland, collected by three learned authors [...]. (Dublin 1633).
8. Thomas Hearne (ed), Guilielmi Camdeni Annales rerum Anglicarum et Hibernicarum regnante Elizabetha: tribus voluminibus comprehensi: e codice praeclaro Smithiano, propria auctoris manu correcto [...] (Oxford 1717).
9. Bede, Historia ecclesiastica gentis Anglorum (Ecclesiastical History of the English People). Issued by John and George Smith (Cambridge 1722). [It is not clear which edition Butler used.]
10. Fynes Moryson, A History of Ireland from the year 1599 to 1603: with a short narration of the state of the kingdom from the year 1169; to which is added a description of Ireland. 2 vols. Dublin 1735. [A reprint of part 2 and 3, Book 3, chapter 5 of the *Itinerary*. The *Description* is at the end of volume 2].
11. Edmund Spenser, A view of the state of Ireland as it was in the reign of Queen Elizabeth: written by way of dialogue between Eudoxus and Ireneus [...] to which is prefix'd the author's life, and an index added (Dublin 1763).
12. Bede, Historia ecclesiastica gentis Anglorum (Ecclesiastical History of the English People). Edited by Joseph Stevenson (London 1838). [It is not clear which edition Butler used.]
**Further reading**2. Barnaby Rich, New description of Ireland (London 1610).
3. Edmund Spenser, A View of the present State of Ireland. (Online at https://celt.ucc.ie/published/E500000-001/index.html), with further bibliographic details.
4. Sir Henry Piers, 'A Chorographical description of the County of Westmeath, written A.D. 1682 by Sir Henry Piers, of Tristernaght, Baronet,' in: Charles Vallancy, Collectanea de rebus Hibernicis, vol. 1. (Dublin: Thomas Ewing) 1770.
5. Robert Payne, 'A Briefe description of Ireland: made in this year, 1589', in: Aquilla Smith (ed), Tracts relating to Ireland, printed for the Irish Archaeological Society, vol 1 (Dublin 1841) 3–14. (online at https://celt.ucc.ie/published/E590001-007/index.html).
6. John O'Donovan (ed), Annals of the Four Masters, vol 6 (Dublin 1848–51, re-issued 1856) 2125–2133.
7. Henry Docwura, A Narration of the services done by the army ymployed to Lough-Foyle [...], ed. John O'Donovan, Miscellany of the Celtic Society, vol. 1 (Dublin 1849) 233–286.
8. Charles Hughes, Shakespeare's Europe. Unpublished Chapters of Fynes Moryson's Itinerary: being a Survey of the Condition of Europe at the end of the Sixteenth Century. With an Introduction and an Account of Fynes Moryson's Career. London: Sherratt & Hughes 1903 [for chapters on Ireland see especially pp 185–260; 285–289; 481–486].
9. Aidan Clarke, Pacification, Plantation and the Catholic Question, in: T.W. Moody, F.X. Martin and F.J. Byrne (eds.), A New History of Ireland, Vol. 3: Early Modern Ireland, 1534–1691 (Oxford 1976; 1989).
10. Nicholas P. Canny, Reformation to Restoration: Ireland 1534–1660 (Dublin 1987).
11. Graham Kew (ed), The Irish sections of Fynes Moryson's unpublished itinerary, Dublin: Irish Manuscripts Commission 1998 [first published in Analecta Hibernica 37 (1995/1996) 1–137].
12. David Edwards, (eds), Regions and rulers in Ireland, 1100–1650: Essays for Kenneth Nicholls (Dublin 2004).
13. Paul MacCotter, Medieval Ireland: territorial, political and economic divisions (Dublin 2008).
14. John A. Murphy and Emer Purcell, The Desmond Survey. Electronic edition, online at https://celt.ucc.ie/published/E580000-001/index.html), with further bibliographic details (Cork 2009).
15. Katherine Simms, 'Gaelic military history and the later Brehon Law commentaries', in: Cathal G. Ó Háinle and Donald E. Meek (eds.), Unity in Diversity: Studies in Irish and Scottish Gaelic Language, Literature and History, Trinty Irish Studies, No. 1, 51–67.
**The edition used in the digital edition**2. **Richard Butler**, A Treatice of Ireland, by John Dymmok. Now first published from a MS. preserved in the British Museum, with Notes, by the Rev. Richard Butler,
A. B., M. R. I. A. in Tracts relating to Ireland. , Dublin, University Press, Graisberry and Gill (1843) volume 2page 1–85

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the editor's introduction (pp 1–4) and pp 5–85; the editor's endnotes on pp. 54 to end are incorporated into the electronic text as footnotes. 


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed. 


##### Normalization


The electronic text represents the edited text; the hardcopy editor has not modernised the late sixteenth-century spelling. Place names are capitalized silently in line with CELT practice, however, since there is a great deal of variation in spelling at present they have not been normalized, regularized, or tagged. Such tagging is envisaged in a future edition. Latin or Neolatin citations in the editor's footnotes are given without the diacritical marks formerly in use. The editor's use of O Sullevan was changed to O'Sullevan.


##### Quotation


Direct speech is marked q. 


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark). 


##### Segmentation


div0=the tract; div1=the section; div2=the sub-section. Paragraphs are marked; page-breaks are marked pb n="". 


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd. 


##### Interpretation


Names of persons (given names), places and group names are not tagged. 


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: by John Dymmok
 (1599) #### Use of language


##### Language: [EN] The text is in late sixteenth-century English.


##### Language: [LA] Some phrases in the text and editorial footnotes are in Latin.


##### Language: [FR] There is some French.


### Revision History


* (2012-08-28) Beatrix Färber (ed.)

* Bibliographic detail completed, SGML and HTML files created.
* (2012-08-27) Donal Whelan (ed.)

* Footnotes proofed online (2); corrections communicated.
* (2012-07-19) Janet Crawford and Donal Whelan (ed.)

* Footnotes proofed online (2); corrections and suggestions communicated.
* (2012-07-07) Beatrix Färber (ed.)

* File proofing (1) finished, more structural and content markup applied, footnotes integrated and encoded; file parsed.
* (2012-06-29) Janet Crawford (ed.)

* First half of file proofed online (2); corrections and suggestions communicated.
* (2012-06-27) Beatrix Färber (ed.)

* File proofing (1) continued, structural and content markup applied, footnotes integrated and encoded; file parsed.
* (2012-06-22) Beatrix Färber (ed.)

* Header created.
* (2012-06-06) Beatrix Färber (ed.)

* File proofing (1) started; structural markup applied.
* (Beatrix Färber)  (2012-06-05) (data capture)

* Text scanned.




---


#### Corpus of Electronic Texts Edition: E590000-001


### A Treatise of Ireland: Author: John Dymmok


### Advertisement


The Manuscript from which this tract has been printed, is No. 1291 of the Harleian Collection, in the British Museum. It is a small quarto, on paper, written about the year 1600, and from the mistakes in Irish names it is evident that it was transcribed by some person not familiar with this country.


Of the author, John Dymmok, nothing has been ascertained, but it is probable that he was an Englishman in attendance upon Essex, when he was Lord Lieutenant of Ireland. The very interesting Jornall Relation of the Principall Accidents which have happened in the kingdom of Ireland from the x of Maye until the ix of September, 1599 (p. 30), was evidently written by an eyewitness of most of the events recorded in it, while the Brief Relation of the Defeat in the Corleus (p. 44), inserted in the "Jornall," is given as the author "hard it related."


For the superintendance of the printing of the text of this "Treatice," and its collation with the original in London, the Society is indebted to Mr. J. O. Halliwell.


Mr. George Smith, of College-green, Dublin, has kindly allowed the Editor to enrich the Appendix with a curious paper, of which the Manuscript is in his possession, entitled The Rate of Wages of the Galloglass as they be paid in Money and Victualls, rated after their own Confession before Sir Thomas Cusack and Mr. Secretary.


R. B.
ST. PATRICK'S, TRIM, August 22.


---

p.3


### A Treatice of Ireland, by John Dymmok




---

p.4


### To the Moste Honorable Knight

Sir Edmunde Carye.

Sir,
I present vnto you in the sincearnes of affection these rude leaves in their fullnes of imperfection, affirminge withall that as I have deformed them (beinge abortiuelye brought forth in an other shape) so doe I likewise reteine the power to transforme my selfe into any lykeness that you shall deuise wherin I may doe you seruice, at which I reste


Moste affectioned
  

and deuoted


John Dymmok.


---

p.5


The realme of Irelande conteineth, from the south forelande to the northe pointe called Thorach,[1](javascript:footNote('E590000-001/note001.html')) about 300 myles, and in breadthe, from Dublin to Saint Patriks mounte and the sea beating alongst Connaught, 140 miles Irish, which are somwhat larger then our Engleshe myles. 


The cuntry lyeth very low, and therefore watrish, and full of marishes, boggs, and standing pooles, even in the highest mowntaynes, which causeth the inhabitants, but specially the sojoners there, to be very subiect to rhewmes, catarrs, and flixes, for remedy whereof they drinke great quantyty of hott wynes,[2](javascript:footNote('E590000-001/note002.html')) especially sackes, and a kinde of aqua vitae, more dryinge, and lesse inflamynge, then that which is made in Englande. 


The ayre is thicke, and nothinge soe piercynge as here in Englande.


The soile is generally fertill, but litle and badly manured, by reason of the great exactions of the lordes vpon their tenants. For the tenant dothe not holde[3](javascript:footNote('E590000-001/note003.html')) his lands by any assurance for tearme of yeares, or lyfe, but onely ad voluntatem domini, so that he never buildeth, repareth or enclosethe the grownde; but whensoever the lord listeth, is turned out, or departeth at his most advantage, which besides the great want of graine to suffice that cuntrye, breadeth also a generall weakenes, for want of inhabiting and plantynge the people in places certain, beinge of themselves geven to a wanderinge and idle lyfe. 


The cuntry yeeldeth great store of beeffes and porkes,[4](javascript:footNote('E590000-001/note004.html')) excellent horses of fine feature and wonderfull swyftnes, and are thought to be a kinde of the race of the Spanish Genetts.[5](javascript:footNote('E590000-001/note005.html')) 




---

p.6


There ar many and those very good hawkes,[6](javascript:footNote('E590000-001/note006.html')) but yt aboundeth cheefly in fysh and fowle, some store of sheepe,[7](javascript:footNote('E590000-001/note007.html')) but small, and those bearinge a longe course fleze, whereof the rugges are made. Great plenty of woode, except in Leinster, where for the great inconveniences finding them to be ready harboures for the Irish rebell, they have beene cutt downe. 


There are also many mynes, especially iron and lead, and some copper, but of what richnes and goodnes I finde not. 


The cheeffe thinge wantinge in that cuntrye is cyvillitye, and dutyfull obedience of the people to their soveraigne, which groweth partly throughe a desyre in the principall kindreds and septes to shake of all forreine obedience, and to governe accordinge to their owne lawes, which is their owne willes, partly throughe the inclination of the common sorte to wildenes, being ledd by the superiours vpon whose willes they must of force depend; but generally for lacke of execution of such good lawes as tende to the preservation of the Englishrye, in restreyninge them from marryinge, fosteringe,[8](javascript:footNote('E590000-001/note008.html')) and allyinge with the Irish, and takinge of coynye and lyvery, which hath beene, and yet is, the only cause of weakninge the English pale, and of so many degenerate English at this present. 


The people are[9](javascript:footNote('E590000-001/note009.html')) of nature very glorious, francke, irefull, good horsemen, able to endure great paynes, delighted in warr, great hospitallitye, of religion for the most parte Papists, great gluttons, and of a sensuall and vitious lyfe, deepe dissemblers, secret in displeasure, of a crewell revenginge minde, and irreconsiliable. 


Of witt they are quicke and capable, kinde harted where they take, and of exceedinge love towardes their foster bretheren. 


Of complexion they are cleare, and welfavored, both men and weomen, tall and corpulent bodies, and of themselves careles and bestiall. 


Theire principallitie or inheritance descendeth not to them by succession, but they atteine therevnto by election, makinge choice of one out of the principall famylies or septes, amongst whome he that hath shewed himselfe most valiant in all barbarous creweltie, shall sonest be preferred, first to be Thamist,[10](javascript:footNote('E590000-001/note010.html')) which is lieuetenant generall, and next in succession, and is followed of the captaynes and forces of the cuntry. And this custome remayneth yet to this daye amonge the Irish, where no man is lorde of his owne any longer then he can defend yt against others. 


The Government of the Irish is neither polliticke nor cyvill, but meare tyrannicall, as may appeare by their auncient lawes, as Brehon law, Coyny, Lyuery, 



---

p.7



&c. which had course there before the conquest. For the prince or lorde vse at their pleasure their tenantes, spend vpon them with their traynes, rule after their owne lustes, commaundinge all, and not to be gaynesaide by any; so that the mightiest oppresse the porest, and justice is ministred accordinge to the affection they beare to the partyes offendinge or offended. 


The inhabitantes generally are of fowre sortes. English Irish, meer Irish, degenerate Englesh, and wilde Scotts. 


The meer Irish, degenerate English, and Scott are growen into one faction, by reason of the devision of the English race, contynewinge till within these few yeares: by which meanes the Irishrye grew to such strength, that the Englesh, for their owne defence, were gladd to ally themselves with the Irish of contrary factions, to make them to be followed after the Irish order, and so became wholly Irish, or at the least scant good Englesh. 


Theire forces[11](javascript:footNote('E590000-001/note011.html')) consist of thre sortes, Horsemen, Galloglass, and Kerne.


The horsemen are armed with headpeeces, shirtes of mayle or jackes, a sworde, a skayne, and a speare. They ryde *upon* paddes,[12](javascript:footNote('E590000-001/note012.html')) or pillowes without styrvps, and in this differ from ours; that in joyninge with the enemy, theye beare not their staves or launces vnder arme, and so put it to the reste, but takinge yt by the midle, beare yt aboue arme, and soe encounter. 


Every Horsman hath two or thre horses, and to euery horse a knave: his horse of service is allwaies led spare, and his knave, which caryeth his harness and speare, rydeth vpon the other, or els upon a hackeney. 


The Galloglass ar pycked and seelected men of great and mightie bodies, crewell without compassion. The greatest force of the battell consisteth in them, chosinge rather to dye then to yeelde, so that when yt cometh to handy blowes they are quickly slayne or win the feilde. They are armed with a shert of maile, a skull, and a skeine: the weapon they most vse is a batle axe, or halberd, six foote longe, the blade whereof is somewhat like a shomakers knyfe, and without pyke; the stroake whereof is deadly where yt lighteth. And beinge thus armed, reckoninge to him a man for his harnesse bearer, and a boye to carry his provision, he is named a spare of his weapon so called, 80 of which spares make a battell of Galloglass. 


The kerne is a kinde of footeman, sleightly armed with a sworde, a targett of woode, or a bow and sheafe of arrows with barbed heades, or els 3 dartes, which they cast with a wonderfull facillity and nearnes, a weapon more noysom to the 



---

p.8



enemy, especially horsemen, then yt is deadly; within theise few yeares they have practized the muskett[13](javascript:footNote('E590000-001/note013.html')) and callyver, and are growne good and ready shott. 


Some will have the Dalonyes[14](javascript:footNote('E590000-001/note014.html')) or horsboyes to be a fourthe sorte, for that they take them into the fight: they are the very skumme, and outcaste of the cuntrye, and not lesse serviceable in the campe for meatinge and dressinge of horses, then hurtfull to the enemy with their dartes. 


The Seruices of the Irishrie due to Her Maiesty, the Severall Exactions leuied by the Irish Lords upon their Tenants, and of what Nature and Quallityes they be
---------------------------------------------------------------------------------------------------------------------------------------------------------------


The Irish taxes or services are of two sortes, either made vnto the queene by the gentlemen towards their defence and mayntenance of her forces in the cuntrye, as Risingeout, Bonaght, and Soren, or els by the lord upon his tenant, as Coynye, Lyuerye, Cashery,[15](javascript:footNote('E590000-001/note015.html')) and Soren, Teignie, Cuddy, Blackrents, &c. 


Of the first sortes, Risingout, is a certain number of horsmen and kerne, which the Irishrie and Engleshrye are to finde in her majesties service, at euery generall hostinge, for defence of the cuntrye against any forreine enemy, or other invadors, which numbers are also to be vittelled by them for certen daies, some more, some lesse. 


Bonaght is of two sortes: Bonaght bonny, and Bonaght beg. 


Bonaght bonny is a certen payment or allowance made vnto her Maiesties Galloglasse, or Kerne, by the Irishry onelye, who are severally bounde to yeeld a yearely proportion of victualls and money, of their findinge, euery one accordinge to his abillitye, so that the Kerne and Galloglasse are kept all the yeare by the Irishry, and devided at tymes among them. 


Bonaght beg, or litle bonagh, is a proportion of mony, ratably charged vpon every plowland, towardes the findinge of the Galloglasse. 


Soren[16](javascript:footNote('E590000-001/note016.html')) is a kinde of allowance over and above the bonaght, which the Galloglass exact vpon the pore people, by waye of spendinge monye, viz. 2s. 8d. for a daye and a night, to be devided betweene three spares, for their meat, drinke, and lodginge. And as the Bonaght is fownde by the lordes for the Queenes service, so also every particuler lorde hath a certen number for their owne defence, some more, some lesse, and are maynteyned vpon their tenants. 


Of the second sorte, Coynye[17](javascript:footNote('E590000-001/note017.html')) is as much to saye as a placinge of men and boyes upon the cuntrye, vsed by a prerogatyve of the Brehon law, whereby



---

p.9



they are permitted to take meate, drinke, **aqua vitae** and money of their hostes, without paye-makinge therefore. As many as keepe idle men, take yt owtragiously where they come, and by the custome of the cuntry yt was lawfull to place themselves vpon whome they would. It is the beggeringe of the cuntry and an intollerable evill without measure. 


Lyvery is horsemeat, exacted for the horses of those which take coyny, or otherwyse send them to the pore tenants to be fedd. The tenant must finde the horses and boyes and geve them as much corne and sheaffe otes wheat and barley as they will have, and yf there be two or thre boyes to a horse as sometymes there be, the pore tenant must be content therewith and yet besydes rewarde the boyes with mony. 


Joye is when their idle men require meat and drinke out of meale tymes, or where they take mony for their coynye of the hoste to goe a begging to their neighbour, it is as much to saye as a benevolence. The contynuance of these and other Irish exactions is the very roote and fowndacion of the rebellions which have beene from tyme to tyme in that cuntry, both for that yt geveth a meane to the lord to mainteine so many idle persons in armes to attempt any villany at his comaunde, and also for that yt draweth the obedience of the subiect from his prince, vnto the capten, and maketh the common sorte to stande in awe or know no other superiors then their Irish captaynes which thus exacte upon them. 


Cashery[18](javascript:footNote('E590000-001/note018.html')) is certeine feastes which the lorde vseth to take of his tenants after Easter, Christmas, Whitsontyde, Michaelmas and all other tymes at his pleasure; he goeth to their howses with all his trayne and idle men of his cuntrye, and leaveth them not till all they have be spent, and consumed, and holdeth on this course till he have visited all his tenants one after other. 


Teignie[19](javascript:footNote('E590000-001/note019.html')) is reare-suppers and chamber drinkinges which they bestow of their lords and other guestes in their chambers after dinner or supper. It is ever vsed by the mer Irish and English Irish wheresoever they be in the cuntrye. And so when they come to any gentlemans howse they are served before dynner or supper with a kinde of refreshing by the name of Teignie. 


Blackrents[20](javascript:footNote('E590000-001/note020.html')) (as I take yt) are in this sorte, when a murder or fellony or other trespasse is committed, the party offendinge being brought before the Lo: Brehon or Judge, is alloted to paye to the wyfe or childe of the party murdered, or to the party agreeved, a kinde of satisfaction, termed by them an Iriach: moreover the Judge awardeth to the lo: of the soyle or cuntry where any such outrag is 



---

p.10



com*m*ytted by way of a fyne a certeine number of kowes, or corne &c. and to himselfe a porcion for his judgment, what the lord reapeth hereby is called a blackrent; by this custom many murthers and thefts ar committed boldly and smothered without due execution of Justice. 


The Present Gouerment of that Cuntry
------------------------------------


For the present gouerment of that cuntry, yt is devided into three partes, Ecclesiasticall, Martiall and Cyvill or Justiciall. 


The Ecclesiasticall estate is composed of fowre Archbushoppes and 29 Bushopps, disposed into severall cuntries in every province, besydes Deanes, Suffragans and Parsons. 


Archbushop of Dublin and Glandalon, Primate of Irland:
  

Bushop of Kildare.
  

Bu: of Leighlin.
  

Bu: of Ossory.
  

Bu: of Ferne. 


Archb: of Toam:
  

Bu: of Dua.
  

Bu: of Alade.
  

Bu: of Elfine.
  

Bu: of Killmakou.
  

Bu: of Clonfert. 


Archb: of Cassell.
  

Bu: of Emely vnited to Cassell.
  

Bu: of Waterford and *Lismor*.
  

Bu: of Cork and Clone.
  

Bu: of Ross.
  

Bu: of Ardagh.
  

Bu: of Laom alias Killalo.
  

Bu: of Lymrik.
  

Bu: of Fimabor. 


Archb: of Armagh, Primate of all Ireland.
  

Bu: of Meath.
  

Bu: of Ardakan.
  

Bu: of Dromory.
  

Bu: of Down and Connor.
  

Bu: of Dere.
  

Bu: of Rapaton.
  

Bu: of Turbrunen.
  

Bu: of Clohu. 




---

p.11


The martiall gouerment is distributed into thre partes of that cuntrye. The lo. Deputy is lieutenant generall over the whole, assisted by two presidents for his more ease, as well in the true administracion of Justice, as for the ready repressing of such disorders as might happen in the upland cuntry; one of them placed in Munster, the other in Connaught, and both corresponde with the lo: Deputy, residing at Dublin for the moste parte. 


The martiall gouerment is not of yt selfe alone, but mixed with cyvill, (vntill such tyme as the cuntrye may be reduced vnto that obedience, as Justice may haue course of yt selfe with out forces to suport yt) and the lo: Deputy assisted with a counsell of the moste choyce and seelect men for their knowledge and experience in the affayres of that cuntrye. Eche of the presidents have also a particular counsell appointed vnto them for the decydinge and determyning of matters in their chardge, and are chiefly dyrected from the lo: Deputy and counsell at Dublin as they are directed from tyme to tyme by her Maiestie and counsell in Englande. 


The cyvill goverment (for that which is meere civill as where the law and Justice onely have course) is of two sortes. First the high cortes which are named the courtes of Justice, as the King's Bench, Com*m*on Pleas, the Chancery, the Excheequer, and the Star Chamber. For courte of wards there is none yet established theare, but the recept is chargable vpon the auditor, and their landes certefyed by the shriffes and exchetors: and these courtes are kept ordinarylie at Dublin fowre tearmes in the yeare according to the course held in England; and all causes decidable by lawe, are in these courtes, according to their severall natures and quallities, decided and determyned. 


The second sorte comprehendeth in yt the pollycy and goverment of citties, townes, burrowes, and corporations. These for the moste parte stretch no further then their owne particuler prescinctes or liberties, and are chiefly busyed in ordering particuler causes betweene theire burghers, and to supply the common wants of their townes, or els how to conteine those over whome they have chardge in dutyfull obedience by punishing offenders and supporting such as lyve orderly, against the mallice and injury of the disordered sorte. Of this nature also are court Barons court Leetes and court hundreds. All these are greatly holpen by the circiuts of the principall officers of the highe courtes, which every yeare twice are to ryde in visitation about the cuntry to keepe sessions and assises, according to the manner of Englande. 




---

p.12


Of the Devision of that Cuntry
------------------------------


That cuntry yet to this present reteineth that auncient dyvision[21](javascript:footNote('E590000-001/note021.html')) as yt did before the conquest, savinge that those provinces which heretofore were divided into Cantreds and Betaghs townes[22](javascript:footNote('E590000-001/note022.html')) euery one conteininge 960 acres of arrable lande besydes woodds, boggs, and pastures, and to euery cantred 30 betaghes townes; are now devided into severall counties and Englesh shires. 


The Provinces are Leinister, Munster, Connaght, Vlster and Meathe, so called as lyinge in the midest of the cuntry, and composed of a parte of euery Province, or els for that yt conteyneth but 18 cantreds, whereas the other contein 34 and 35 apiece. 


### Leimster


The Province of Leimster conteyneth all that portion of lande which was first conquered by our nation, includinge all that grownde from Dublin southwarde to the ryver of Suyre and the Cytty of Waterforde, which parteth yt from Munster. The ryver of Shenin in Mac Couglians[23](javascript:footNote('E590000-001/note023.html')) cuntry devideth the west parte from Connaght and Meath; northward yt endeth with the Barony of Balrothry and the ryver Boyne, and on the east syde is bownded with the sea. It is devided into seaven shires. The county of Dublin, Kildare, Catherlogh, Wexforde, Kilkenny, King's County and Queenes County. 


They have gone about of late to add two other shires the counties of Wiclo,[24](javascript:footNote('E590000-001/note024.html')) and Fernes; but bycause these two shires are yet vnperfett, not having sufficient freholders and gentlemen to chose shriffes and other principall officers or to make a jury for the Queene, they may be well omytted. 


### The County of Dublin


The county of Dublin conteyneth all the lande from Balrothery neare the province of Meath to Arcklo, a principall castle of the earle of Ormonds, which is the length of the shire, and includeth the growndes called the Kinges landes, the mowtaines of the Obirnes, O'Tooles, and Banilagh,[25](javascript:footNote('E590000-001/note025.html')) called **Pheagh Mac Hugh**'s cuntry, also Shilogh, Ferderrogh and the crosse of the cuntry which is the liberty of the Archb: of Dublin, also his Ilandes of Lambaye, Eye and Dalky.


It bowndeth, East, on the sea; West, County Kildare; North, County Caterlogh; South East, Meath. 




---

p.13


### The County of Kildare


The county of Kildare is placed betweene the counties of Dublin, Catherlogh, the Kinges and Queenes county, and Meath, yt hath not in yt many townes of importance, but dyvers proper villages which lye scattered about the cuntry. 


It bowndeth, East, Dublin; West, K*ing's* and Queens County; No. Meath; So: Carlogh. 


### The County of Caterlogh


This county is a long slipp of grownde lyinge for the moste parte betweene the two ryvers of the Slane and the Barrow. It conteineth dyvers baronyes anciently inhabited by the Engleshe and after gotten from them by the Cauenaghs. It hath in yt certeine highe mountaines vpon the easte parte, the rest of the cuntry is more playne, and a third parte of the whole, accounted to belong to the Erle of Ormond, and Sir Edmund Butler; one Barony called Idron, belonginge to Sir Dudley Bagnoll. 


It bowndeth, West, on Wexforde; North, Kildare; South, Kilkenny; East, the Queene's County.. 


### The County of Wexford


The county of Wexford was the first cuntry where the Englesh sett footinge and conquered. This shire is the largest of any one in that Province of Leimster, and one parte thereof inhabited still with the auncient Irish, which was the cause that Sr Hen. Sidney, and Sr Will. Drury would have made two other shires within yt. The north parte should have beene called Fernes, and that to the southe neare Dublin, Wiclo; but findinge that there were not sufficient, and sewer gent*lemen*, to be shriffes, nor freeholders to make a Jury for her Maiestie, yt hath beene let fall. The south parte as the more cyvill is conteined within a ryver called Pill, where the auncientest gentlemen descended of the first conqueror doe inhabite. The other without the ryver is inhabited by the originall Irish, viz. the Cavonaghs, Murroghs and Kusclighs[26](javascript:footNote('E590000-001/note026.html')) who possesse the woddy parte of the cuntry. 


It bowndeth, East, the ocean; So: County Dublin;[27](javascript:footNote('E590000-001/note027.html')) No: river Barow; West, Caterlogh. 


### The County of Kilkenny


This county hath the moste of cyvillity[28](javascript:footNote('E590000-001/note028.html')) of any other the border counties, 



---

p.14



beinge well replenished with fayre castles, howses and seates, with Englesh manner of enclosinge their groundes. This cuntry thoughe yt conteine in yt both the vpper and neather Ossery, yet such mortall mislyke there is betweene them of the county of Kelkenny and Mac Gilpatrik, lo: of the vpper Ossory, that he will not suffer any tryalls of his cuntry to be made in that county, but in the Queene's county[29](javascript:footNote('E590000-001/note029.html')) and holdeth himselfe to be a member thereof. 


It bowndeth, East, river Barow; South, ryver Suyre; North, Queene's County; West, county Tipperary. 


### The Queene's Countye


This county conteineth in effect, all the landes betweene ye ryver Barow and Ormond, including all that which did belonge to More Odowen, vpper Ossory, and Slynarg. The soile is fruitfull and exceeding pleasant. It is watred on the one syde with the ryver Barow. The ryver Neor runneth through another parte of it. It is well sorted with woodes and playnes. This cuntry was planted by the erle of Sussex with a mixt people of Englesh and Irish, and in the tyme of Kinge Phillip and Q. Mary, gaue yt to name the Queenes county, and the cheeff towne Maryburrow. The inhabitants haue beene contynewally molested with the first inhabitors the O'Mores that yt hath in manner wasted the whole cuntrye vpon them and at this daye are growne to stronge numbers and very daungerous. 


It bowndeth, East, Barrow; So: Kilkenny; No: Kings co. and mountayn Sliboam; West, Tipperary. 


### The Kinge's County


This county beinge aunciently called Ophaly, was inhabited by the O'Connors a wicked and rebellious people, who for their sundrye treasons and rebellions,
were by the erle of Sussex in the tyme of Queene Mary banished and disherited their cuntry converted to shire grounde and called the King's county, and the cheiffe towne thereof, Phillipstowne.[30](javascript:footNote('E590000-001/note030.html')) The shire conteyneth all the grounde betweene the county of Kildare and the ryver Shenin includinge Claneboye and O'Dempsies cuntry on both sydes the Barrow, also Ballinies and Ferall which is lykewise O'Dempsies cuntry, the Shenogh or Foxes cuntrye, and Phelim Mac Couglians cuntry, to the brinke of Shenin neare Mellike. This cuntry in the beginning of her Maiesties reigne was very well quieted by a proscription of the 



---

p.15



O'Connors made by the erle of Kildare, who in manner wholly did extirp that race, yet of late they have increased to such numbers as they have beene able to make stronge forces in this last rebellion. 


It bowndeth, East, Kildare; West, Shenin; So:
Que., county; No: Meath. 


### Elye


This small terrytory or compas of grownde hath beene counted parcell of Munster, as belonginge to ye county of Tipperarye, but for that O'Carrell who is lo. of this cuntry and his ancestors would never yeeld to be of that cuntry as for that he and his father did allwaies consent to be vnder the Englesh goverment, viz. under the lieuetenant of the Kings county, and yeeldeth now by composition vnto her Maiestie £100 per ann*um* and to be ordered by the Queenes lieute*nant* of the Kings county in all controversies so as yt is accounted parcell thereof, and so of Leimster. 


It bowndeth with Ossory and a part of the Qu: county to the south; with Ormond to the west; with de la Mac Coghan to the North; and with the mowntaine Slibown[31](javascript:footNote('E590000-001/note031.html')) to the Easte. It hath small piles of litle importance, the chiefest whereof is Limwaddon. 


### Meathe


This Province hath his name of Medium, the midle parte of the cuntrye, and conteyneth properlye but one shire, vnder the name of Meath,[32](javascript:footNote('E590000-001/note032.html')) being in the beginning a porcion appointed for the Kinges demeines: But being since devyded into many Baronyes and cuntries, and now lately in the tyme of K. Hen. 8. made and devided into two shires or counties Eastmeath and Westmeath. And by cause the two other Irish cuntries, the one belonginge to the O'Reilies, the other to the O'Farrals be now converted to shire grownde by the names of the county of Cavan and of Longforde, I hold yt not amisse to laye these two counties vnto Meath, and so conteine them all fowre in this midle province, althoughe the county of Cavan be held of many to belonge to ye province of Vlster. These counties haue many goodly Loughes and meares of fresh water especially Westmeath, whereof the greater parte fall into the Shenin aboue Athlone, the rest into ye ryver Broschenagh, which also falleth into the Shenin beneath Athlone, neare Mellike. These waters make the cuntry besydes the fertillity of the soyle to abound in great store of very good fishe. 




---

p.16


### Eastemeath


Eastmeath conteyneth all the lande betwene Balrothery in the County of Dublin and the ryver of Boyne near **Droghdagh** and then not far from Droghdagh extendeth yt selfe over that ryver and conteineth all the lande to the border of Cavan and to the halfe Barony of Fower, and from thence yt breadeth to the Kinges county and the countie of Kildare. 


It bowndeth, East, the sea; West, Cavan; So:, King's county; No:, Louth. 


### Westmeath


The county of Westmeath conteineth all the landes from the Redmore beyond Aboy to the ryver of Shenin, and in bredth from the Kings county to the county of Longforde comprehendinge mac Coughlan, Mac Gall[33](javascript:footNote('E590000-001/note033.html')), and also Omylaghlins cuntrye. 


It bowndeth, East and South, Kings county; North, Cavan; West, Shenin. 


### The County of Longforde


This county is a large quantity of grownde possessed by a people called O'Farralls,[34](javascript:footNote('E590000-001/note034.html')) and was in tymes paste devided betweene two of the strongest of that name, the one which possesseth the south parte thereof is called O'Farrall Buy, which signifyeth yellow O'Faroll; the other O'Farrall Ban, which is white O'Farrall, both which sir names doe yet holde the cuntrye, so as both conjoyned togeather doe make the county of Longforde. 


It bowndeth, East and South, Westmeath; West, county Letrim; North, County Cavan. 


### The County of Cavan


This county conteyneth all the lands called heretofore, O'Reilies cuntry alias the Breny, which beinge vnder one capten heretofore, and called the East Breny, and the West Breny, was devided into seaven baronies, who have their severall freeholders, no one of them dependinge on the other, but all imediatly from the Queene. They are a stronge nation able to make of their owne sirname 400 horse; they are sayd to be aunciently descended from the Ridleys of England. This cuntry conteyneth 30 miles in length and 30 in breadth. 


It bowndeth, East and North, Fermanagh; West, County Letrim; South, Westmeath. 




---

p.17


### Munster


The Province of Munster conteineth all that cuntry from the ryver of Suyre, westwarde alonge the sea vnto the mouth of Shenon, and bowndeth on the east syde vpon Kilkenny on the west, and south side, the mayne ocean; and on the north syde, with the ryver of Shenin, which devideth yt from Connaght. It is the most commodious of all the other Provinces in soile, good havens, ryvers and townes. This Province accordinge to the ancient distribution is devided into three partes, Desmond, Thomond, and Ormonde; but Thomond beinge now annexed vnto the goverment of Connaght, the reste at this present is devided into fyve counties, viz. Waterford, Corke, Limrike, Typerary and Kyrrye. 


### The County of Waterforde


The county of Waterford conteineth all the lande betweene the ryver Suyre which falleth into the sea beneath Waterford, and the ryver Yoghall called the great water. It includeth[35](javascript:footNote('E590000-001/note035.html')) all the cuntry called the Denes, the Bishoprick of *Lismore* vnited to the sea of Waterford, Prendergast's lande, who was one in the first conquest and a moste famous capten; The white Knightes cuntry called Glangibbon. 


It bowndeth, East, ye ocean; North, Yoghall; South, County Corke; West, Lymerik[36](javascript:footNote('E590000-001/note036.html')). 


### The County of Cork


The county of Cork[37](javascript:footNote('E590000-001/note037.html')) conteineth all the lande adjoyning to the sea, from the ryver of Yoghall to the baye of Dingle and the ryver of Maigne, the cuntry of Kerrywherry, Kilaloa, Barry-Roes cuntry, the Bishoprike of Ross, the cuntry *or* Carbrye on both sydes the leape, O'Mahons and *O'Driscoll's* cuntry. The Bantry, O Siluian bent, O Siluian more and all Desmond; all which by alongst ye coaste. In the midle of the shire lyeth Muskry, devided betweene Sir Cormoc and Sir Dermot mac teig Clancark, allso O'Challagon, O'Heift, Mac Auly, Mac Donoho, followers of the erle of Clenear, and includeth the landes of the two vicounts Barry and Armoy. 


It bowndeth, East and South, the ocean; West, ountaine Shilogher; North, Lymerik. 




---

p.18


### The County of Lymrike


The county of Lymrike conteyneth all the lande from the mowntaines neare the Redsherd ioyning to the county of Corke, vnto the Shenin, as well above Lymryche as beneath, in a manner as farr as Carigfoyle, and from the farthest parte of Mac Bryan Ogannoghs cuntry and comprehendeth in yt Glanwillim[38](javascript:footNote('E590000-001/note038.html')), Canolokerry, alias the knight of the vallyes cuntry, and Cosmoy. 


It bowndeth, East, Typperary; West, Shilogher; South, Cork; North, Shenin. 


### The County of Tipperary


This county beinge devided into two, the one the crosse of Tipperary, the other the county Pallatyne,[39](javascript:footNote('E590000-001/note039.html')) is a large circuite of lande and hath two shriffes, that of the crosse is under the Archb: of Cossell, and hath large liberties, but not lyke the county Pallatyne belonginge to the erle of Ormond. In the crosse the Queene maketh the shriff her head officer. The Pallatyne is gouerned by sceneshall Justice, a shriffe, and dyvers other meaner officers, which two countyes lye onelie by observation and custom. The whole cuntry conteineth all the landes in manner from the towne of Callane in the County of Kilkenny to Mac O'Brien O'Gannoghs cuntry in the county of Lymrike, O'Mulreans cuntrey Mac Bryan Ara, O'Downies cuntry, vpper and nether Ormond, Constinagh, Cosehi, Muskry whirke, a great part of Harlow, and by auncient devision O'Carralls cuntry Elye, thoughe he disclame from yt. 


It bowndeth, East, Kilkenny; So:, Lymrik; We:, Shenin: No:, Ki. County. 


### The County of Kerry


The county of Kerry conteineth the landes which lyeth betweene the ryver of Maigne and the Shenin, and includeth the moste parte of the mowntayne Shilogher, which is the moste easterly parte of the cuntry. This cuntry was a Pallatyne to the Erle of Desmond, the lyberties and royalties whereof (he beinge a man of small discretion) caused him to grow insolent aboue measure, forbidding the lord President and counsell of the Province to have any dealinges in his jurisdiction, which was the very originall grownde and cause of his rebellion and overthrow. 


It bowndeth, West, ye Sea; East, Corke; No:, Shennin; So:, River Maigne. 




---

p.19


### Connaght


This Province hath been otherwise devided then now it is, by reason the O'Reilies cuntrye (now county of Cavan) and O'Faralls cuntry (now the county of Longford) were held parcell of yt and Thomond or the county of Clare was accounted of Munster. The word Thomond signifieth north Munster, and was in the commission of the presidents of Munster in Sr. Warham Sentligers, Sr. John Perotts, and Sr. Will. Druries tyme. But Sr. Hen. Sidney consideringe the notable bownde yt hath from the rest of Munster, did establish yt under the goverment of Connaght, as yt is at this present. The Province conteineth all the lands circuited with the great ocean, betweene the ryver of Erne nere Asserow[40](javascript:footNote('E590000-001/note040.html')) in O'Donells cuntry, and the ryver of Shenin where yt falleth into the sea, beneath Lymryke. It is in manner an Iland, bycause to the north and the west, yt hath the sea, to the south and easte the Shenin, and to the northeast the loughe and ryver of Erne, onely one small slipp of grounde betweene the Shenin and the Erne leaveth that parte vninclosed. It is devided at this present into sixe countyes. Clare, Sligo, Mayo, Gallwaye, Roscommon and Letrim. 


### The County of Clare


This county of Clare alias Thomond beareth ye name of the Castle of Clare now belonginge to the erle of Thomond. It conteineth 6 baronyes and hath in yt 2 small bishoprickes, Kilmakoa and Killaloa, the one vnder the archb: of Cassell, the other vnder the archbp. of Toam. 


It bowndeth, East and North, Shenin; West, the Sea; South, Gallway. 


### The County of Sligo


Sligo conteyneth all the grounde betweene ye ryver of Erne and the playnes of Connaght by the skirtts of the Mowntaynes of **Benbulham** [41](javascript:footNote('E590000-001/note041.html'))and Corleus to the ryver and lough of Boyle in Mac Dermons cuntry, and from thence northeast by the ryver of [*gap: defective in MS.*] which devideth the county Mayo from the county of Sligo. 


It bowndeth, West, Mayo; East, the Earn; Nor:, the Ocean; So:, county Roscommon. 




---

p.20


### The County of Mayo


This county conteineth all the lands and cuntrye of Mac Willim Ervter,[42](javascript:footNote('E590000-001/note042.html')) and the landes of the O'Mayles, Mac Donnell, Mac Morrice, Mac Jordan, Mac Gustelo. This country hath certaine Ilandes both fertill and commodious for fishinges, for which purpose both Englesh marchaunts and strangers have great entercourse and trafficke there. 


It bowndeth, East, County Sligo; West and North, ye Ocean; South, Gallway. 


### The County of Gallwaye


This countye conteineth a great quantitie of lande, lying in manner square, betweene Mayo and Thomond. It hath heretofore had many ancient noblemen descended of English ancestors, but by the revolucion of tyme, duringe the cyvill dissentions in England, they turned into wilde Irish, and with their manners they have also changed their names. The 2 principall byshoprikes of Connaught lye within this county the archb: of Toam, and the bush: of Clonfert. The thre Islands of Arran are counted parcell of this county and lye within a kennynge of Gallway town. 


It bowndeth, East, Shenin; West, the sea; North, Mayo; South, Clare. 


### The County of Roscommon


The county of Roscommon conteyneth all the playnes of Connaght, beginning at Munster Boyle neare the mountaynes of Corleus, and stretcheth alonge by the Shenin to the ryver of Suce. This cuntry is under the diocesse of the Bushopp of Elfine. 


It bowndeth, East, Shenin; West, Mayo; North, Gallway; South, Sligo. 


### The County of Letrim


This county counteineth all O'Rurkes cuntry called the breny O'Rurke, also yt conteineth parte of Mac Guynies landes lying vpon the west syde of the Loughe Erne, and Mac Glanes cuntry lyinge on Bondroies. It hath no other
principall person inhabitinge there but O'Rurk and other of his name and freholders wholly depending upon him. O'Rurk and O'Connor Dun of the county of Roscommon, haue in their severall antiquities beene kings of Irelande.



---

p.21



Therefore they reteininge the memory of their former greatnes, doe aspire and conspire with all lewd disposed persons, O'Rurke hath beene allwayes a reteyner of Scotts in all rebellions. It hath in yt no townes or castles of any worth but onely Leitrim. 


It bowndeth, North, county Sligo; West, Shenin; South, county Longford; East, county Cavan. 


### Vlster


The Province of Vlster lyeth in the farthest north parte of Irelande. It is devided from Meath by the ryver Boyne on the southe east parte, with the Breny which is O'Reilies cuntry on the south part, and southwest parte it bowndeth vpon Connaght, namely vpon O'Rurks cuntry and O'Connor Sligo. The rest is altogeather environed with the sea and conteineth in it 9 countyes, Louthe, Downe, Antrim, Monahan, Fermanagh, Tyrone, Dun*n*egall, Colvan,[43](javascript:footNote('E590000-001/note043.html')) and Armagh. Some attribute the county of Cavan for a tenth. 


### The County of Louth


This county beinge anciently called Iriell, lyeth betweene the ryver of Boyne and the haven of Carlingforde; this county hath the moste daungerous borderers and neighbors of any county, for it lyeth on the Mac Mahons in the
county of Monahan, vpon the O'Neiles of the Teenes[44](javascript:footNote('E590000-001/note044.html')) and O'Hanlons of the county of Armagh. By meanes of whose incursions the cuntry nearest vnto them lyeth waste. It is part of the English pale and beareth in all contributions and cesses a part with the rest of the provinces. 


It bowndeth, East, the sea; West, the Breny; Nor:, Armagh; Sou:, Meath. 


### The County of Douwne


This cuntry conteineth all the landes betweene the haven of Carlingford to the Bay of Knockfergus, viz. Litle Ards which lyeth on the north syde of the ryver of Strangford, it is a fertill champion cuntry of the inheritance of the lo: Savadge. Great Ards, belonginge to Con mac Neile og. South Claneboy which reacheth from the Duffrin to the ryver of Knockfergus Kilulto, lyinge vpon Lough Eaghe and Cranbraselo. Before the Barons warrs in England yt was well inhabited by Englesh, and there still remayneth an olde decayed castle bearing the name of one Sr. Nicholas Tracy. Killwarlen which is Mac Roris cuntry,



---

p.22



the Duffrin which in times paste was the inheritance of the Mandevillles, and now belonging to the Whites, Neromy also Newry,[45](javascript:footNote('E590000-001/note045.html')) and Maurice Eagh, both the inheritance of Sr. Hen: Bagnall whose father Sr. Niclas at his cominge thither fownde yt waste and Shane O'Neill dwelling within halfe a myle, robbyng and spoylinge so as no man could travell safely; he builded the Newry through which the country was brought to more cyvillity. Maurice Eaugh was then governed by Sr. Hugh mac Guinies who was brought by Sr. Nic: Bagnoll from being O'Neiles Bonaght, to take his landes to him and to his heires males from her Maiestie and to depend onely vpon her so as in this place of Vlster onely, the rude manner of Thomiship[46](javascript:footNote('E590000-001/note046.html')) was taken awaye. He is of late revolted and at this present in Rebellion. 


It bowndeth, East, the sea; West, Armagh; Nor:, Lough Eaugh; Sou:, Carlingford. 


### The County of Antrim


This cuntry comprehendeth all the land betweene the baye of Knockfergus and the ryver of Ban conteyninge North Clanneboy, the Route, the Glynnes, Iland Maggi and Bryan mac Carraughs cuntrye North Clanneboy is devided
into two partes; the ryver of Kellis being the meare bownde. The south parte thereof was geven for a rent to the sonnes of Brian Mac Phelim O'Neile who were all pencioners in Ireland to her Maiestie and the eldest Shane mac Bryan yet livinge was cheeffe. The north part beyond Kellis to the ryver
of Ban, by Loughe Eaugh was assigned to the sonnes of Hugh mac Phelim elder brother to Sr. Bryan whose eldest sonne and cheife of that parte is Hugh Og mac Hugh. 


The Route is properly the inheritance of one Mac Willi descended from a Welsh ancestor in the tyme of the first conquest. This cuntry is pleasant and fertill. The Scotts were once banished, but since these late rebellions permitted agayne so as the ancient inhabitors being ye O'Harries and the O'Guines pay servises and rent to the Scotts and depend of them, of which Surilly buy is chiefe. 


The Glynnes so called by reason of the rocky and woody dales both neare to the iles of Raughlines and the iles of Ira and Iura, yt beginneth from the haven of Olderfleet to the Route stretching in length 24 miles, being backed on the one syde with very steepe boggy mowntaynes, and the other syde with the sea;



---

p.23



where yt hath many small creekes, betweene the rockes and the thicketts where the Scotts gallies doe comonly lande on either ende are very strayte and narrow passages into this cuntry, which be opposite to Kentire in Scotland which is 18 miles distant. It was aunciently the land of one Misset an English gentleman, whose daughter one of the Clandonnels an ancestor of Angus mac Con*n*ell of Kentire maried, and so clameth the inheritance. They were once all banished and expelled, but since by instructions from her maiestie yt was devided by Sr. John Perrot, betyeene Angus mac Connell cheife of his name and Sourly Buy his uncle bysides the land in the Route. The ile of glimes conteyneth seaven Baronyes of which the Raughlines beinge six miles, is counted half a barony, the rest are Larnparke, Glanan, Redbay, Lade, Carye and Mowbray. These people having continuall supplies out of Scotland, have beene and are causers of great vnquietnes and disloyaltie in Ireland, and better followed by the weaker septes, (for that they are lesse spent upon and better defended) then by the Irish or English. 


Iland Magi is a porcion of land invironed with sea, thre miles from Knockfergus, the headland whereof maketh Olderfleet haven; it is fyve myles long, and but a myle broade, very fertill and without woode, but wasted: it is the inheritance of the now erle of Essex. 


Bryan Mac Carvughs cuntry was parcell of north Clanboy, won from him by a bastard kinde of Scotts the Clandonnels, it is a stronge piece of grownde lyinge on the North syde of the Ban: it is very hard to hurt him, by reason of the fastnes of his cuntry, having frendes on either side the Ban, which maketh him so obstynate and carelesse, as he would never appeare, but yeeldeth what releeffe he can to the Scotts, he stayeth onely vpon his owne strength, the cuntry is the fastest and safest grownde in Ireland. 


### The County of Monahan


This county was anciently called Iriell, geven at the conquest tyme to one Gerald Fitzvrsus[47](javascript:footNote('E590000-001/note047.html')) or Bearsonne supposed to be one of the 4 knights that slew sanct Thomas of Canterbury. His ofspringe are become meare Irish, calling themselves mac Mahons which signifieth the sonne of a beare, Mahon in Irish being a beare. It conteyneth the cuntries of Iriel, Bartry[48](javascript:footNote('E590000-001/note048.html')) and Ferny, which are held by 3 capt. of his owne sirname, of which the last bordereth vpon the 



---

p.24



 
county of Louth, and being parcell of ye auncient inheritance of the crowne was geven to Water erle of Essex the title whereof remayneth in the now erle. 


It bowndeth, East, South West, Loghearne; No:, Armagh; So:, Cavan. 


### The County of Fermanagh


This cuntry com*m*only called Mac Guyres cuntrye lyeth vpon the east syde of the great Loghe Earne and stretcheth northwards to O'Donels cuntry called Terconnell, Mac Guyre is one of O'Neils Vraughts,[49](javascript:footNote('E590000-001/note049.html')) he hath not any of name vnder him, but his owne kindred: he is under the bushop of Clohn[50](javascript:footNote('E590000-001/note050.html')) in the county of Tyrone. This cuntry is very stronge of woodes and boggs especially neare the great Loughe Earne. 


It bowndeth, East and North, Tyrone; West, O'Rurks cuntry; So:, Mac Mahon. 


### The County of Tyrone


The county of Tyrone conteineth all the lande betweene the Blacke Water and the ryver of Liffer. This was the porcion assigned to Turlogh Lenogh O'Neil in the treatye betweene him and Water erle of Essex, who before had commaund over all the landes southward to the English pale. 


It bowndeth, East, county Colran; West, Mac Guyre; No:, Fermanagh; Sou:, Armagh. 


### The County of Dun*n*egall


The county of Dunegall conteineth all Terconnell, which belongeth to O'Donell, and that sirname, and O'Dogherties cuntrye from the ryver of Fyn northward to the sea, and from the easte sea to the ryver of Earne neare the county of Slygo. It is the largest shire in all the province of Vlster. O'Donell is capten and governor of the cuntry, whose strength lyeth in the sept of the O'Chaloganes[51](javascript:footNote('E590000-001/note051.html')) and Mac Swynes stronge nations of Galloglass. O'Doherties cuntry is a promontory almoste environed with sea, namely with Loughe Swilly and Lough Foyle on the north parte. It is governed by a capteine called Sr . John O'Doghertye, who beinge not able to defend himselfe is forced to contribute to O'Donell and O'Neile, alternis vicibus. His cuntry lyinge vpon the sea neare the ilands Ira and Jura of Scotlande, is continually invaded from thence, and thereby forced to be at their pleasure. 


It bowndeth, North and East, the ocean; West, Lough earne; South, ryver Fyn. 




---

p.25


### The County of Colran


This county beareth the name of the castle of Colran in the north syde of the Ban, and not of the abbey of Colran which is in the route. It conteineth all the lands betweene the river Ban, and Loughfoyle alongst the sea coste. The capteine thereof is O'Chane and no other of that name in yt but himselfe savinge his freeholders vnder him. O'Chane is cheefest of O'Neils Vraughts, and createth him O'Neile by castinge a shooe[52](javascript:footNote('E590000-001/note052.html')) over his heade, vpon a hill[53](javascript:footNote('E590000-001/note053.html')) in the county of Tyrone, a place allwaies assigned for that purpose. 


It bowndeth, East, the sea; West, co. Tyrone; No: Loughfoyle; So: Ban. 


### The County of Armaghe


This county conteyneth all the landes betweene the ryver of Dondalke and the Blackewater, savinge a small porcion called Conray lyinge neare to Carlingford, which is parcell of the county of Louthe. It is devided into these cuntryes, Oriagh, which is O'Hanlons cuntry,[54](javascript:footNote('E590000-001/note054.html')) Clanbraselo, Clancane, Clanowle, Muckro, Tyragh, Fewes, and Oneilon, moste of these have severall captaynes. 


O'Hanlon's cuntry reacheth from the Newry to Armagh, for the moste parte without woode. 


Clanbraselogh is a very boggy and wooddy cuntry, lyinge vpon the syde of the Loughe Earne. 


 Clancane alias Clancumcane is a very stronge cuntry allmoste all wood and bogge and two deepe ryvers, the one called the Blacke Water, the other the litle Ban, both which doe fall in this cuntry into the Loughe Earne. 


Clanowlo, lyeth betweene Armagh and the Blackewater near to the ryver. It is boggy and wooddye, but the reste towards Armagh is champion and fertill: upon that parte of the cuntry was the bridge and forte of Blackewater.[55](javascript:footNote('E590000-001/note055.html')) Muckro and Tragh, lyeth betweene Armagh and Mac Mahons cuntry. 


Fewes bordereth vpon the Englesh pale, within 3 miles of Dundalke; it is a strong cuntry of woode and bogge; the captayne thereof is Turlogh Mac Henry O'Neile, brother to the erle of Tyrone. 


Oneilon is likewise a wooddy lande lyinge betweene Armagh and Clancane. 


It bowndeth, East, county Monahan; West, ryver of Newry; North, Blackwater; South, county Louth. 




---

p.26


A Perticuler of Such Strengths and Fastness of Woode and Bogge as are in every Province of Irelande
---------------------------------------------------------------------------------------------------


### In Leinster


Glandilore,[56](javascript:footNote('E590000-001/note056.html')) a fastnes in Pheagh mac Hughes cuntry. 


Shiloghe, in the county of Dublin. 


The Duffrin, in the county of Wexford. 


The Dromes and Leverogh in the county of Caterloghe. 


The great bogge in the Kinges county called the Tougher. 


The Fewes in the county of Kildare. 


The woodes and boggs of Munsterevan, Gallin and Slymarge, in the Queene's county. 


The Roure near St. Mollines. 


Parte of Consteragh joyninge vpon Kylkenny. 


### In Munster


Glan garuf, in O'Siliuan Mores cuntry. 


Glanrug, and Leanmore, in Desmond. 


Olinglaskilmore, in the county of Lymerike. 


Dromfinien,[57](javascript:footNote('E590000-001/note057.html')) in the county of Corke on Blackwater. 


Arelow, and Muskry quish, in Tipperary. 


Kilhuggi in Typperary, bordringe on Lymrike. 


### In Connaght


The woodds and Boggs of Kylbigher.


Kilcallon in mac Williams cuntry.


Killaloa in the county of Letrim.


The woodes and boggs near the Corleus. 


### In Vlster


The woodds and boggs of Clanbraselogh.


Clancane in the county of Armagh.


The woods and boggs of Kilvlto, Kilwarlen, Kiloutry, South Claneboye, in ye county of Downe.




---

p.27


[58](javascript:footNote('E590000-001/note058.html'))A Perticular of the Rebells Forces of Horse and Foote ordinarilye imployed in the Rebellion, 28 April 1599.
-----------------------------------------------------------------------------------------------------------


### In the province of Leinster


1. *Dublin.* The mountayne rebells, viz. the O'Birnes, O'Tooles and ye Cavenaghs within the county of Dublin . . . 480 foote; 20 horse
2. *Kildare.* James Fitzpierce a Geraldine. The Bastard Geraldines, 2 base brothers to the late erle of Kildare. One of the De la Hides. Glasne O'Dempsie. Lisagh O'Dempsi with the rest of the O'Dempsies. Certein of the Eustacies[59](javascript:footNote('E590000-001/note059.html')) 
of kindred with the late vicount Baltinglass attaynted . . . 230 foote; 20 horse
3. *Caterlogh and Wexforde*. The Cauenaghs the chief of which is Donell Spaniagh[60](javascript:footNote('E590000-001/note060.html')) with his followers . . . 750 foote 50 horse
4. *Quee. Cou*n*ty.* The O'Mores with their sept and followers . . . 
570 foote; 30 horse
5. *Kings Cou*n*ty.* The O'Connors, the O'Moloyes, the O'Donies.[61](javascript:footNote('E590000-001/note061.html'))
440 foote; 12 horse
6. *Kilkenny.* The vicount Montgarret with his bretheren and followers, the O'Carrolls . . . 130 foote; 20 horse
7. Summa totalis in Leimster, foote 2600, horse 152, in all 2752.
8. There are of strangers within Leinster adherents to the rebells,
9. With Pheag mac Hughes sonnes ye Clamoles with . . . 80 foote
10. With Murrogh ma Edmonds sonnes of Scotts under Donogh Ganco 30 foote
11. Of Vlster men under Con the bastard . . . 800 foote



### In Meath


1. The O'Molaughlines, some Nugents, some Giraldines . . . 140 foote; 20 horse
2. Capten Tyrrell[62](javascript:footNote('E590000-001/note062.html')) . . . 200 foote
3. The O'Reilies with their sept, and strangers . . . 100 foote; 20 horse
4. Summa in Meath, foote 440, horse 40, in all 480.



### In Munster


1. The lo: Barren of Cayre, James Butler his brother, with their followers . . . 300 foote; 12 horse
2. *Tipperary.* 
 Edmund Fitz Gibbon alias the white knight[63](javascript:footNote('E590000-001/note063.html')) with his followers . . . 400 foote; 30 horse


---

p.28

5. Richard Pursell,[64](javascript:footNote('E590000-001/note064.html')) baron of Laughline with his followers . . . 200 foote 60 horse
6. Calluc Mac Shane,[65](javascript:footNote('E590000-001/note065.html')) Glassi O'Mulrean and his sept . . . 300 foote; 60 horse
7. Keidagh O'Magher . . . 60 foote; 30 horse
8. Edmund Buck[66](javascript:footNote('E590000-001/note066.html')) pretending himselfe Baron of Leighgranen and his
bonaghs . . . 300 foote; 20 horse
9. *Ormond.* Bryan og O'Keneday, Hugh O'Keneday, with the rest of
ye O'Kenedaies in Ormond . . . 500 foote; 20 horse
10. William Burke Fitz John with ye rest of the Burkes of Clanwillim . . . 200 foote; 40 horse
11. James Fitzthomas,[67](javascript:footNote('E590000-001/note067.html')) calling himself erle of Desmond . . . 250 foote; 30 horse
12. The Lord Roche,[68](javascript:footNote('E590000-001/note068.html')) Patrick Condon . . . 200 foote; 28 horse
13. *Cork.* Donogh mac Cormok[69](javascript:footNote('E590000-001/note069.html')) lo: of Dowallogh. O'Kyff, Ball O'Hane . . . 200 foote; 80 horse
14. Barry Og and the barrons brother John in the Muskry . . . 120 foote; 30 horse
15. *Kerrye.* In Carebeg with David Burk 500 foote
16. The lo: Fitzmorrice,[70](javascript:footNote('E590000-001/note070.html')) Thomas Og, John Delahide Toghe, with his followers and strangers . . . 500 foote; 30 horse
17. *Desmond.* O'Swilly man Beare,[71](javascript:footNote('E590000-001/note071.html')) Dermond Mac Owen, calling himselfe Mac Arty More[72](javascript:footNote('E590000-001/note072.html')) . . . 500 foote; 60 horse
18. Of strangers assistants with horse . . . 100
19. Summa in Munster, foote 4730, horse 568, in all 5298.



### In Connaght


1. *Roscomo*n*. O'Connor Dun, mac Dermon, O'Brien, O'Hanlye, O'Flamergan, the mac Swynes, mac Hugh, Duff Dalie, O'Kellye . . . 500 foote; 30 horse*
2. Mac Lanigh, O'Doole,[73](javascript:footNote('E590000-001/note073.html')) O'Harry Buy, O'Harte, mac Donogh, O'Garrye . . . 300 foote; 30 horse
3. O'Rurk[74](javascript:footNote('E590000-001/note074.html')) with his followers in Leitrim . . . 600 foote; 60 horse
4. *Mayo.* Mac William and his followers . . . 600 foote; 60 horse
5. *Gallway.* The sonnes of Edward Scobe, uncle to the erle of Clanricchard . . . 300 foote;
6. *Sligo.* The 4 sonnes of Owen O'Madden[75](javascript:footNote('E590000-001/note075.html')) whose father was killed lately in action . . . 50 foote;
7. The Joyes, mac Donogh, O'Flaherties[76](javascript:footNote('E590000-001/note076.html')), in Tercon*n*ell . . . 140 foote;
8. *Clare.* Teig the erle of Thomonds brother, with other of the O'Briens, mac Nemekawes[77](javascript:footNote('E590000-001/note077.html')) and their followers . . . 600 foote; 50 horse
9. Summa in Connaght, foote 3090, horse 230, in all 3220.





---

p.29


### In Vlster


1. Neil mac Bryan Ferto of the Upper Clanneboy . . . 80 foote; 30 horse
2. Shane Mac Bryan of the lower Clanneboy . . . 80 foote; 50 horse
3. The Whites cuntry, called the Duffrye . . . 20 foote;
4. Mac Artens cuntry, and Sleught mac O'Neils . . .100 foote; 20 horse
5. Mac Rory of Killwarlen . . . 60 foote; 10 horse
6. Hugh mac Murtogh of the Feagher beyond the Mynwater . . . 40 foote;
7. Shane mac Bryan Carragh, and his cuntry joynyng on the Bansyde . . . 50 foote; 10 horse
8. James mac Surly buy,[78](javascript:footNote('E590000-001/note078.html')) and his 2 brothers Neece and Randoll in the cuntry of Towany (being the Route) together with ye Glimes . . . 400 foote; 100 horse
9. Mac Mahon[79](javascript:footNote('E590000-001/note079.html')) with Ferny and Glancarvell, Patrick Macarty Moyle, being a competitor to ye cou*n*ty of Monahan . . . 500 foote; 160 horse
10. Edmund Reagh of ye Breny . . . 500 foote; 100 horse
11. O'Chane[80](javascript:footNote('E590000-001/note080.html')) with his cuntrye . . . 500 foote; 200 horse
12. Sleught Art, Sr. Art O'Neiles cuntry . . . 300 foote; 60 horse
13. Henry Og mac Shane . . . 200 foote; 40 horse
14. Turlogh mac Henry of ye Fewes brother to ye erle of Tyrone . . . 300 foote; 60 horse
15. O'Haggan and his cuntry . . . 100 foote; 30 horse
16. The Donnelaghs cuntry betwixt the ryver of Fin and Lough Swilly possessed by Con O'Donnell's sonnes and mac Hugh Duff . . . 100 foote; 60 horse
17. Mac Connagh . . . 100 foote; 12 horse
18. Lord Savadg[81](javascript:footNote('E590000-001/note081.html')) of litle Ardes . . . 30 foote; 10 horse
19. Mac Guyre in the cou*n*ty of Fermanagh . . . 500 foote; 80 horse
20. O'Hanlan . . . 200 foote; 40 horse
21. O'Quin . . . 80 foote; 20 horse
22. The erle of Tyrone hath for his own retynew *com*m*only* attending about him. . . 700 foote; 200 horse
23. Cormoc mac Barron, the erls brother . . . 300 foote; 60 horse
24. Iragh mac Guynies[82](javascript:footNote('E590000-001/note082.html')) . . . 300 foote; 40 horse
25. Sr. John O'Dogherty and his cuntry joyning vpon Lough Foyle . . . 300 foote; 40 horse
26. In the Mac Swynes cuntry . . . 500 foote; 30 horse
27. O'Boyle and his cuntry . . . 100 foote; 20 horse
28. O'Donell and his cuntry of Dunegall . . . 200 foote; 60 horse


---

p.30

31. O'Gallogher . . . 200 foote; 40 horse
32. Sleught Rories cuntry . . . 100 foote; 50 horse
33. Summa in Ulster, foote 6940, horse 1652, in all 8592.
34. Summa totalis of the Rebells whole forces in Irelande, foote 17800, horse 11552, in all 29352.[83](javascript:footNote('E590000-001/note083.html'))



A Perticuler of such Horse and Foote as the Erle of Tyrone hath very lately Plotted to be Cessed and Waged by the Severall Captaynes and Lords of Cuntries in ye Province of Vlster
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


1. The erle of Tyrone and his creat is to beare . . . 2000 foote; 120 horse
2. Cormoc mac Baron . . . 100 foote; 40 horse
3. Henry Og O'Neile . . . 50 foote; 30 horse
4. O'Hanlon . . . 50 foote; 40 horse
5. Art mac Baron . . . 30 foote; 20 horse
6. Bryan mac Art cessed vpon Clanneboy . . . 300 foote; 60 horse
7. Mac Guynies and his cuntry . . . 300 foote; 60 horse
8. All the Mac Mahons . . . 500 foote; 200 horse
9. Mac Guyre . . . 400 foote; 60 horse
10. Art Og O'Neiles sonne . . . 400 foote; 50 horse
11. O'Chane . . . 300 foote; 100 horse
12. James mac Surly buy . . . 300 foote; 60 horse
13. O'Donell with all his cuntry . . . 3000 200 horse
14. O'Rurk . . . 500 foote
15. Shane mac Bryan . . . 200 foote
16. Th*u*rlogh mac Henry ye erls brother . . . 30 horse
17. The Breiny findeth ye erle . . . 60 horse
18. Summa totalis, foote 8430, horse 1130, in all 9560.



A Jornall Relation of the Principall Accidents which have Happened in the Kingdom of Ireland from the X. of Maye vntill the IX. of September, 1599
--------------------------------------------------------------------------------------------------------------------------------------------------


After the lo: lieutenant and governor generall of Ireland had rested certen daies at Dublin for establishinge the state of that kingdome, and for makinge his necessary provision for the warr, his lordshipp departed from thence towards 



---

p.31



the champion feildes betweene the villages of Killrush and castle Martine, in which place he appoynted to meete him 27 ensignes of foote and 300 horse which his lordship devided there into Regiments appoyntyng colonells to the same.


The daye followinge, the rebell shewed himselfe in small numbers deliveringe some few shott out of the woods and ditches vpon our vaunte-curriers but without any hurte. This night the army lodged a myle from Athye which hath beene a great markett towne, but brought by these late wars into the state of a pore village.


Athie is devided into two partes by the ryver of Barrow, over the which lyeth a stone bridge, and vpon yt a castle occupied by James Fitzpierce, a gentleman of the famylie of the Geraldines, who so soone as our army approached the castle yeelded himselfe to the mercy of the lord lieutenant, as dyvers also the same daye, viz. the vicount Montgarret and the lorde of Cayre (both Butlers) who were presented unto the Lord Lieutenant, by the Erle of Ormond,[84](javascript:footNote('E590000-001/note084.html')) who in that place ioyned his forces to our army.


The lord lieutenant havinge put a guard in the castle of Athye, passed his forces over the Barrow by the bridge of the castle, which ryver beinge not otherwyse fordable but with difficultie, and the bridg thereof the onely waye which leadeth into the Queenes County, the importance of this enterpriz easely appeareth (without any amplifycation) vnto every ignorant sence. At Woodstocke[85](javascript:footNote('E590000-001/note085.html')) (a village scituate vpon Barrow) his lordship expected victualls a daye or two for the reliefe of Maryburge, a forte of great importance in the Queenes County which his lordship now hasted, not permittinge other staye in his jorney then necessity gave cause. Durynge the tyme that our army incamped at Woodstock, the rebells attempted the stealinge of some of our horses, which being perceived by Sr. Christofer Sentlaurence,[86](javascript:footNote('E590000-001/note086.html')) (sonne to the Lord of Hoth) he passed the ryver naked, and beinge followed by his men reskewed the praye and returned with the heade of a rebell.


About the same tyme the rebells presented themselves 200 stronge to the sight of the castle Rheban[87](javascript:footNote('E590000-001/note087.html')), distant a myle from Woodstok, where a parte of the army then laye; but vpon sight of the erle of Southampton, who hasted towards them in most soldier lyke order with a small troope of horse and foote they retyred themselves to their boggs and from thence to their woods.


So soone as the lord Lieutenant was provided of vittells he marched with his



---

p.32



army towarde the forte of Mariborow in the Queenes countye, at which tyme the rebell shewed himselfe by a passage called Blackeforde, through which his lordship marched in such excellent order, that yt terryfied him not alone to attempt vpon any parte of the army, but even to approach neare unto the same.


His lordship havinge vittelled the forte, and encreased the garrison, and bestowed the order of knighthood on the capten thereof Frauncis Rush, (who had constantly held the same, being dryven with all his company to eate horsflesh the space of 20 dayes before) he lodged that night at the foote of a very highe hill colled Croshy Duff, the generall Ratehill[88](javascript:footNote('E590000-001/note088.html')) of the province of Leinster, where the rebell Ony mac Rury O'More[89](javascript:footNote('E590000-001/note089.html')) shewed himselfe with 500 foote and about 40 horse two myles from our campe, renewing that night and contynewinge the next morninge a challeng which he had made a few daies before, to fight 50 of his with 50 of ours with sworde and target, which was consented vnto by the lorde lieutenant, but the rebell never came to performe yt.


The lord lieutenant havinge from the topp of Croshi Duff viewed the cuntry rownde about, and particulerly the way of that dayes march, led his army towards a passage called Cashells, halfe a myle from that nights quarter. The nature of the passage[90](javascript:footNote('E590000-001/note090.html')) is such through a thicke woode[91](javascript:footNote('E590000-001/note091.html')) a myle long, leadeth a highe waye, in moste places ten going paces broade, which in the midst was traversed with a trench and the woode plashed vpon both sydes from behinde which the rebell might with facillyty gaule our men in their passage. To the other two sydes of the woode are adjoyned 2 boggs which served the rebell for a secure retreat from all force of our armye; but upon an elevated porcion of grownde betweene the woode and the bogge on the lefte hande was a village, from behinde which the rebell might safely sallye and returne agayne to his strength at his pleasure. His Lordship, to make his way through this passage with security devided his army into thre battells. Before the vantguarde marched the forelorn hope consisting of 40 shott and 20 shorte weapons, with order that they should not discharge, vntill they presented theire peeces to the rebells breasts in their trenches, and that sooddenly the shorte weapons should enter the trenches pell mell vpon eyther syde[92](javascript:footNote('E590000-001/note092.html')) of the vauntguarde (which was observed in the batle and reareguarde) marched wings of shott, enterlyned with pikes, to which were sent secondes, with as much care and diligence as occasion required. The baggage, and a parte of the horse marched before the battell, the rest of the horse troopes fell in before the rearewarde, except 30 which in the head of the rearelorne



---

p.33



hope, conducted by Sr. Hen: Danvers, made the retreit of the whole army. The vanguard havinge by provident order of march gayned the ende of the passage, where discovered yt self a large champion and comaunded to make Alt in that place till the horse and whatsoever else was vnprofitable in the strayte were advaunced the playne, which order of march providently appoynted by the lord Lieutenant not being observed in all partes of the army with lyke dilligence, there was loste in the retreyte of the dexter winge of the forlorne hope, capten Boswell and lieutenant Gardner, who dyed with so much bravery and resolucion that yt must be confessed by all who were witnesses of their deathes that their eies have not seene more valiant gentlemen.


His Lordship was this daye in all places, flyinge lyke lightninge from one parte of the army to another, leadinge, directinge, and followinge in the vanguarde batle and reareguard. The small losse we susteyned in this place was multiplied upon the rebell by our quarter and skoutmasters, who accompanied with divers gentlemen made a good slaughter of certeine rebells which assayed to force the quarter; among these were of especiall note, Alexander Don*n*ell, and Donnell Knaghy, a man of base birth, but (for the proofe of his darynge and skill in their millitary discipline) of especiall esteeme with Tyrone. In this conflict Edward Bushell, gentleman, received a hurt in his brest with a pyke.


The daye followinge, the Lord Lieutenant observinge the former of marche led his army throughe the passage called Ballyregate of a castle belonging to the vicount Montgaret where we founde the rebells so few in number, and so tymerous in attempting, as their behaviour prooved that the other dayes march was terrible vnto them.


These passages thus overcom to no small terror of the enemy and admyration of the soldior, his Lordship went to Kilkennye[93](javascript:footNote('E590000-001/note093.html')) (a cytty where the Erle of Ormond is resident) where he was received with as much ioye of the cytizens as could be expressed, either by lyvely orations or by sylent strowinge of the streetes with greene hearbes and rushes with which ceremonyes of gladnes he was lykewise welcomed not many dayes after at Clonmell.


The citizens of Clonmell, had beene longe tyme hindred in their traffique to Waterforde, by the castle of Darenclare, scituate vpon the ryver Suyre, which althoughe yt were very defensible, and that yt had some yeares paste endured the force of an armye, yet was yt at this tyme vpon the Lord Lieutenants com*m*inge before yt presently yeelded to his mercye.




---

p.34


In the midest of the ryver Suyre (5 miles from Clonmell) lyeth an Iland the same a naturall rocke, and vpon yt a castle which althoughe yt be not built with any great arte, yet is the scite such by nature that yt may be said to be inexpugnable. Of this castle which is called Cayre,[94](javascript:footNote('E590000-001/note094.html')) is the lord of Cayre entytuled baron, which beinge helde by James Butler his younger brother, the Lord Lieutenant sent the Lord of Cayre to parly with him, and with him Sr. Hen. Danvers, whome he advised duringe the parly to observe as much as was possible for him, the nature of the place, who returninge with the lord of Cayre (evill satisfyed that his brother would not yeeld his castle) related the scite and strength of the place, to be such as is mencioned.


This night his Lordship reviewed the place himselfe in person and caused the same to be don*n* by the Lord Marshall and sergeant major, com*m*aunding after a dilligent review, that the approaches (takinge the advantages by the way of olde ditches and walls) should be that night carryed to the board of the counterscarp, one day beinge intermitted without doing any thinge, for want of the artillery, which could not aryve in shorte tyme, the same being drawne onely by force of men; there passed a daye or two before the battery was com*m*enced.


The same night that the cannon was planted, his lordship sent the lord Marshall and segeant Maior, with 300 men, to occupye a garden which adioyneth to the castle upon ye south west parte, althoughe this passage to this garden were such as that a very small number might have made fronte to an army, yet did these beastes first quit that passage, and presently after they abandoned the castle (except 8 persons) to the relieffe of which wer sent early in the morninge 100 kerne, by the whyte knight. In the beginninge of the night, Sr. Christopher St. Lawrence was sent with 300 men to possess an Iland which lyeth from the castle towards the northeast not more then halfe an hargubuz shott, to breake up two bridges, one of which leadeth from the Iland to the mayne, and the other from the same Iland to the castle.


The rebells seinge themselves in the morninge secluded from that reliefe which they howerly expected from Desmond and from the white knight: at night they conveyed themselves with as much stillnes as was possible out of the castle, which yet being perceived by dyvers of our guardes, they fell presently to execution, and entred as well the castle without resistance as direction, by which accident was repossessed for her Maiesty, with the slaughter of 80 rebells, one of the strongest places by nature in all Irelande.




---

p.35


Duringe this siege capten Brett was shott in the body with a hargubuze, as was also capten Georg Carye[95](javascript:footNote('E590000-001/note095.html')) through both cheekes and throughe the body, the bullet entringe above the lefte shoulder and passinge forthe vnder the opposite arme hole which hurtes were myraculous, for that there were onely three shotts made and his boddy in all places covered with an armor of muskett proofe. These two worthy capteines havinge in this siege, and in many other services, made honorable proofes of their vertu after a few dayes chainged this lyfe for a better. His Lordship havinge repared the breaches of the castle, and placed such a garrison in the same as might anoy the fronteringe rebells, his sicke men beinge sent to Clonmell he arryved by easy jorneyes at Lymricke, where he was enterteyned with two Englesh orations,[96](javascript:footNote('E590000-001/note096.html')) in which I know not which was more to be discommended, words, composition, or orators, all of them having their particuler excellencies in barbarisme, harshnes, and rusticall both pronounce and action.


The army, which had endured much as well by fowle waies as unseasonable weather, being well refreshed by the relieffe they received from Lymrik, was conducted by his Lordship to Adare. In a ruyned Abbey of which village, his lordship lodged a regiment of foote, passinge the same over the ryver of Adare by a narrow bridge; which was well perceived by the rebells Desmond and Lacy, who never made shew to prohibit the passage, althoughe they had not much more then muskett shott from the same, aboute 1200 foote under 5 ensignes, and 2 cornetts of horse eather appearinge to be at least 100. Those were rayned in sight of our army, devided from yt by an infordable ryver, and a bogge, and in such disorder as yt rather seemed a morris daunce by their trippinge after their bagpipes then any soldiorlyke exercise, they conveyinge themselves after a while in a ringe daunce into a wood which they had close at their backes, and from whence they have not departed further at any tyme since the armye entred Munster, then an olde hunted hare doth from her covert for relieffe.


Earely in the morninge the army passed the ryver and marched towardes a passage halfe a myle from Adare which had on eyther syde a woode, but under that on the right hande a bogge, by the head of which extended yt selfe the woode on the lefte hande. The passag laye over the bogge, which was very difficult both for many naturall sloughis which we founde in the same and for plashin[97](javascript:footNote('E590000-001/note097.html')) made that morninge by ye rebell. At the entrance into the passage



---

p.36



betweene the woods the dexter winge, beinge not so farr advanced as the forelorne hope, the Lo. Lieutenant being in the heade of the Troopes to direct them, had delivered vpon him close at hand and from reste, a vollye of at leaste a 100 shott, which were instantly repelled by some troopes, which his Lordship caused to be drawen forth of the vantguard, comaunded that daye by the erle of Thomond. His Lordship havinge with slaughter of more then a 100 (not loosinge a man of his owne) put the rebell to retreat on that parte, possessed himselfe of the passage, placinge on either syde thereof a regiment that might assure the same, and that dun he returned to geve order to the reare guard, where he was in like daunger as before in the vantguard, overcomyng the same by the lyke order, but not altogether with so much slaughter.


The rebell thus repelled by providence in his lordship, the whole troopes marched through the passage, not alone without losse, but without difficultie. On the left hand of the passage was Plunkett lodged with 300 rebells, who makinge onely that daye eccho in the woode with the reporte of 30 or 40 shott, was constreyned the next daye to geve pledges to Desmond for the assurance of his faith.


From the passage his Lordship conducted his army towards Aischeton,[98](javascript:footNote('E590000-001/note098.html')) which castle was then somthinge distressed by the rebell, who intercepted the passage in such sorte, that till this tyme yt could not conveniently receive any relieffe from Lymricke, from whence it was now vitelled by his lordshipp; the rebell neither hinderinge his lordship to passe or repasse his army over the ryver Doyle upon which Ayscheton is scituate, where a small number might have made heade to a copious army, nor endeavored any notable offence, in any other place, where they might have prooved their forces with much advantage.


His Lordship with purpose (as I conjecture) to geve the rebell an inexcusable provocation, directed his jorney towards castle Conan in the county of Corke, Desmonds cheefe howse, at which tyme passinge betweene woodes close by Pheniters towne[99](javascript:footNote('E590000-001/note099.html')) which flancqued the army on either syde within muskett shott, his lordship peradventure to lett the rebell know the vertu of his men, and their owne weakenes, enterteyned skyrmysh with them in theire owne strength, forcynge them to abandon the same without other losse, then that Sr. Hen. Norris presenting a charg with his troope of horse, had his legge broken with a bullet, which hurt was after certen weekes languishment the end of his lyfe. The Lord Lieutenant was this day in as good hazard as any pryvate
 


---

p.37



 
man, so was lykewise the erle of Southampton in. much daunger whiles he expected in the head of his troopes (all the tyme of the skirmysh) oportunyty to charge the rebells. The lord Graye havinge that daye the vauntguarde of horse gave chace with 1 2 of his troope to a doble number of the rebells forcing them into the wood to their foote, where capt. Franscis Markham a gentleman of knowne valour was shott throughe the right cheeke with a bullet. There dyed of the rebells clan Donnell and one of the Burks both comaunders, and of ours Sir Henry Norris and capten Fennyngs.


Not many dayes after the army still marchinge towards castle Conan was enterteyned in skirmish from the skert of a woode called Barney Cowlagh by Mac Cartes men, where Sir Henry Danvers, endeavouring to save certen straglers which had indiscreetly ingaged themselves, was shott in the face, the bullet passing to the roote of the lefte eare, where yt still resteth, but without any anoyance, he beinge allready perfetly recured.


Desmond insteade of defendinge his castle, raced the same, by which and throughe his whole cuntry the army marched without any offence, althoughe he might have presented himselfe in our way in many places of exceedinge advantage, so that without any impeachment of the rebells his lordship aryved (notwithstandinge great braggs made by Desmond) unfought withall, at Waterforde, where his lordship was received with as much joyfull congratulation of the people as in any other towne in Ireland. During his lordships aboad in Waterforde, he reviewed with carefull diligence, the harborow, as also the forte of Dun Canon which guardeth the same. The seite and fabrycature of which (both in his lordshipps judgment and opynion of others skillfull in fortification) declare Sr. John Norris[100](javascript:footNote('E590000-001/note100.html')) (by whose approbation that was chosen and this allowed) as judiciall an ingener as his other acts have enoblished him for a most worthy soldior. For the seite it is so overtopped by an emynent height not distant from yt more then 150 paces, that no man can stand secure in the piazza of the forte. And as for any arte of fortyfication whereof this place should participate and whereby skilfull inginers are accustomed to render places more defencyble, yt was held by his Lo: judgment (as I said before) an insufficient intrenchment, and consequently a moste defective fortresse, as whose spalto affordeth a secure lodginge under it to an enemy, coverynge him from all offences of the parapett, and yet the same not raysed to such height as may secure the defendants in the strada coperta, whose ditch is narrow and shallow, 



---

p.38



whose rampart and parapett are low and slender, whose defences are a forbici and imbarba, and that which is worse their correspondency hindered by the cassamates in the ditch, whose piazza is narrow affordinge no place for retreat, when that rampart which is, shall either be beaten or zapped, all which imperfections are fownde in that parte which reguardeth the mayne. That part of the forte towards the water, althoughe yt hath not so many defects as the former, yet hath yt as grosse errors as any are mencioned. The two platformes being both of them so skant, that they are not alone uncapable of such a number of peeces as may serve to command the water, but that they which are allready there, have not place sufficient for their recoyle, the defects of which platformes are suted by answerable parapetts, which being slender, and of stone, they promisse instead of securyty, death to as many as shall in necessytye present themselves to defence.


From Waterforde to Dublin (whether the Lo: Lieutenant was now in returne with his army) leadeth a doble waye. The one throughe the Glynnes which denyeth passage to horse and carriages; the other alonge the sea shoare, by which his lordship conducted his army as well peradventure for the com*m*odity of the passage as to visit in his waye the garrysons of Enerscorfy, Arclo, Wicklo, and Newcastle: untill the army had passed Enescorfy the rebell never shewed himselfe, for all the former daies marches were throughe a playne champion, where he never trusteth to himselfe. But before that the army was advaunced to the mydwaye from Eniscorfy to Arcklow, the rebells (ayded with the oportunytie of woodes and bogges) presented themselves in our waye, for the preservinge of certen villages all which (and onely which) his lordship caused to be consumed with fyer in despyte of them.


About three myles from Arcklo the army was to passe a forde, where the rebell presented himselfe, with opynion (as may be conjectured) yf not to prohibitt yet to troble the army in the passage; the skirmish was for the space of an howre hotely maynteyned on both partes, either parte contendinge to force the other by fresh supplies out of their grosses which they had hard at hande. The Lord Lieutenant thinkinge to enclose the enemy betweene the horse and foote com*m*aunded the lord of Southampton (who was now passing the foarde) to take the first oportunyty to charge, but the rebells (whose dread of our horse causeth him to observe dilligently all their motions) perceiving the erle of Southampton to advance with his troope, retyred him selfe into his strength, a parte



---

p.39



of them casting away their armes for lightnes, which yet escaped not altogeather the execution of the lo: Marshall who directed the foote on that parte. The rebell was to passe in his retreit to his strength, through 2 small fields, enclosed with highe hedges, through the end of the second of which laye a highe waye vnto a neighbor woode, which the lo: Lieutenant a while observinge (envited by the oportunyty of the place which gave excellent commoditie to close the rebell betweene his horse and foote) sent vnto an Irish comaunder of horse willinge him to charge who obeyed instantly, but yett com*m*ytted therin a doble error, the one for that he sent not 20 or 30 horse before his troope that might have broken the rebells and received their first vollye; the other that for about 12 shott which were delivered upon his troope at his first approach, he turned heade when his trompett sownded a charge, geving lyfe thereby to more then 200 rebells which stoode at his mercye.


In the meane tyme while these things were in hande the whole troopes were passed the foarde, and his lordship began to contynew his march towards Arklow, laying in a village upon the waye an ambuscado of about 40 horse, which might cut of the rebell yf (which his Lordship suspected) he should approach to offend the rearguard. But the rebell (who is not easely surprysed by ambuscadoes) either perceivinge or suspectinge deceit made an Alt with his troopes, which howsoever yt seeme contemptible, yet is yt sufficient to fight in the trenches of his cuntry, with fyve such armyes as ours. His Lordship perceiving the rebells staye, called his horse to their place, and the cuntry beinge to appearance a playne and firm champion, the whole army seemed to promise to itselfe securytie, and the rebell not purseivinge, every man attended onely to hasten to the quarter in a speedy march, whereby the army was distracted into an excessive length, and brought thereby althoughe into no disorder, yet into some unreadiness, whiles the army marched; his Lordship beinge allwaies vigilant to observe the order of his owne troopes in their march ascended for this purpose the topp of a hill, whose height discovered the whole playne, and perceivinge from thence, that the rebell prepared to gene vpon the reare of the sinister winge of the vantguard led by Marmaduk Constable ensigne to capt. Ellis Jones, he comaunded the erle of Southampton (to whome gathered suddenly a few stragling horse) to haste to their succors; in the meane tyme while the erle of Southampton was occupied in assuringe the foote, and endeavoring to drawe the rebell (which held him in his strength of woode and bogge) upon



---

p.40



firm grownde, the lord Lieutenant not attended upon by more then 6 or 7 horse, presented a charge to the rebells grosse of horse and foote, which was now making towards the lord of Southampton, whome they see to be engaged, and upon a grownd disadvantagious for horse; but perceiving the resolucion of the lord Lieutenant who constantly expected them upon the syde of a bogge which laye betweene him and them they made an Alt, about which tyme the Lord of Southampton, having increased the number of his horse to about 24, seeing yt lost tyme to endevor to draw the rebell from their strength resolved to charge them at all disadvantage, which was performed with that suddennes and resolucion, that the rebell being before dispersed in skirmish had not tyme geven him to put himselfe in order, so that through the oportunity of occasion taken by the erle of Southampton, and vertu of those which followed him (who were moste of them noble) there was made a notable slaughter of the rebells; such as escaped the horse, were intercepted from their grosses (to which they labored to retyre) by the foote, which were sent thither by ye Lord lieutenant for releefe of the hors, many of which by the too much forwardnes of their ryders were there imbogged by which misfortune Sethcockes a gentleman (whose industry had adorned him with much both science and language) died in that place, and Capt. Willim Constable after a doble wound, saved himselfe by his owne vertue. That which the foote did in this parte was not lesse comendable then that of the horse, there beinge a stande made by Sr. Hen. Poore, Capt. Courtney, and ensigne Constable with a 100 men, aganst at least 400 rebells: but that which hindred ye coming downe of the rebells, was the presence of the lord lieutenant who stoode in a place fitt to offend both by direction and number, havinge a litle before ioyned vnto him the rearguard of foote and horse.


The rebells Donnell, Spaniah,[101](javascript:footNote('E590000-001/note101.html')) and Phelim mac Pheagh, mooved either with the slaughter of theirs, whereof died more then a 100, fyve of which were com*m*aunders, or terryfied with ye order, readiness and vertu of our men, withdrew themselves, and desyred by Sr. Hen. Danvers (who com*m*aunded that day the rearguard of horse) to com in vnto his lordship vpon protection, which his lordship denyed as a course vnfitt for rebells, refusing to receive them upon other tearmes, then upon submission to her Majesties mercy.


His Lordship had before his entrance into this jorney of Munster, and Leimster, with provident care secured by sufficient garrisons all the frontiers of the English pale, leavinge at Dundalke the Lord Cromwell, at Ardee, Sr. St. John 



---

p.41



Shelton, at Kelles, the Lord Audley, garrisoning in lyke manner under the government of other com*m*aunders, the townes of Mollingar, Trym, Aboy, and Ballymore in Westmeath. In the King's county, Dyngan,[102](javascript:footNote('E590000-001/note102.html')) in the Queene's county, Maryburg; in the county of Carlogh, Caterlogh; in the county of Wexford, Enescorty, and in the county of Dublin, in the Birnes cuntry, Wicklow, where was left Sr . Hen. Harrington[103](javascript:footNote('E590000-001/note103.html')) with the comaund of Sr. Alexan. Ratcliffs regiment.


Not above seaven myles from Wicklow is that part of the Glynnes called Banilagh,[104](javascript:footNote('E590000-001/note104.html')) the strength of which cuntry, although yt is exceedinge greate by nature, yet hath yt lately beene much encreased by the industry of Phelim mac Pheagh, who at this daye usurpeth the possession of the same. Sir Hen. Harrington partly mooved with a desyre to take a view of Phelim mac Pheaghs new workes, and partely drawne by an opynion to exercise his soldiors, which were all rawe men and vndisciplined, departed from Wicklow towardes the Banilagh with 450 foote under the comaund of their captaynes, Wardman, Mallory, Linley, Loftus, and Ratcliff, to which he added capt. Montacute with his troope of 50 horse, and 15 horse of so many Irish gentlemen who offered themselves voluntarylie to this service. It was marched that daye within a myle of Banilagh where yt was encamped by the side of a bogge, not of necessitie (for this jorney was meerly voluntarye) but either of judgment or necligence, which maketh as well his error inexcusable who made choice of this place, as his who approved the same. The rebells takinge the oportunytie of that advantage which was geven them by this unsoldior lyke encampinge, never ceased to disquiet our men, the whole night longe, deliveringe sometimes entier vollies of shott in their market place.


The next morninge (which he had also don the daye before at his first cominge to this quarter) Sr. Hen: Harrington, attended onely with the horse, went towardes the Banilaghe, returninge eftsoone without makinge any memorable discovery of the place, which yet was the occasion of his drawing forth[105](javascript:footNote('E590000-001/note105.html')) presently upon his returne to the quarter, havinge received intelligence that the rebells had assembled themselves in grosse, he gave order to march which the rebells perceivinge (they being then in sight) hasted after, and com*m*encyng skirmish with their loose shott, maynteyned the same for the space of two myles, when our men having passed a small brooke by a forde and lodged 10 musketteires



---

p.42



in a ditch which might with excecdinge advantage have expected the pursewers from Rest, fled shamefully at the sight of 4 or 5 naked raskalls, suffryng themselves to be knocked downe with the stockes of their pieces. Capt. Wardma*n* endeavouringe to reforme this disorder, and assisted (as they saye) in his frustrate, but honorable paynes, by the rest of his ranke, left his dead bodye in that unfortunate place, for an occular testymony of his corage and vertu of whose infortune Capt. Henry Aderton, sergeant maior to the regyment, being an emulous witnes, never turned his face from the rebells, but the rest flyinge was (lyke another Cocles) both to them and to himselfe a buckler, vntill he was relieved by captein Montacute.


Of the pryvate men escaped by flight, but more hidd themselves lyke fearefull hares in the furres, all which were by a martiall courte condemned to dye, which sentence was yet mittigated by the Lord Lieutenants mercy, by which they were onely decimated by lott, soone after his Lordships returne to Dublin; the capts. were accused in a martiall courte of cowardize and omission of their duties, where as I have heard they discharged themselves honorably, but Welsh, lieutenant to Capt. Adam Loftus, was founde culpable of either error, and therefore sentenced to be shott.


The lord Lieutenant had not sooner refreshed his army after the painfull jorney of Munster, but he led a parte of the same into Ophaly,[106](javascript:footNote('E590000-001/note106.html')) now called the Kinges countye: but before his Lordship departed himselfe from Dublin, he sent the Lord Marshall with a sufficient force into the Queenes county to vitle the forte of Mariburge, and as I supose to suppresse as much as was possible, the insolency of the O'Mores, which are the capitall rebells of that cuntrye. He sent lykewise at the same tyme the sergeant major into Ophaly, whome his Lordship overtooke not far from Phillips towne, the head towne of that shire, which his lordship supplied with munition and vittles, viewing in the waye the grownde, which not many daies before Capt. William Williams, sallyinge forth of the towne with 300 men to recover a pray taken that morninge by the rebells, loste 60 of his men, which fell improvidently betweene three enemies ambuscados.


The next morninge after the Lord Lieutenant had joyned to him the sergeant major, his Lordship conducted his forces, which exceeded not the number of 1200 foote, and 200 horse, out of the Kinges county into the county of Westmeath 



---

p.43



 
making his waye over a trench strengthned with a duble ditch, where the rebells presented no resistance, although they were in sight 600 stronge, and had such advantage of grownde both for wood and bogge, as they might have made our passage very difficult, yf not altogether prohibited the same.


But although they abandoned the advantage which was presented them in the morninge, yet omitted they not to take their opportunitie in the afternoone, enterteyniug with contynuall skirmish the sinister winges of our army, which for 4 myles togeather were flancqued both with woode and bogge, which advantage of grownd turned to their disadvantage in prooffe, for they being made bold thereby, lost this daye one of the Connors, a principall comaunder amongst them, and about 40 pryvate men, we receiving no losse and almoste no hurte.


A porcion of the county of Ophalye is called Fergall, a place so stronge as nature could devise to make yt by wood and bogge, with which yt is environed, which for the naturall strength thereof, the rebells in those partes have ever since the begininge of these warres made a storehowse for all their prayes, peaceably enjoyinge there without molestacion what they had injuriously robbed from other parties. In Fergall from Derrow[107](javascript:footNote('E590000-001/note107.html')) (whether the lord Lieutenant parposed to conduct his army) leadeth awaye throughe a thick woode, and over two fordes, both of them (besydes their naturall difficulties) entrenched and plashed in such manner, (as his Lordship was perswaded by them to whome the cuntry was well knowen) to leave the accustomed waye, and to passe the ryver Derrow by a bridge which his Lordship caused to be made, to which worke the rebell gave no impediment; although that for the advantage of the place, he might with a very small number and without any losse have defeated the passage. The army aryved that night late at Ballycowen, halfe a mile from which is Ardenegroffe, whether Sr. Conyers Clifford, governor of Connaght, was come with 9 companies of foote, according to direction which the lo: Lieutenant had geven him by his letters not many dayes before: Sr . Conyers Clifford was sore fought with all his entrance into Fergall having 10 men slayne and 40 hurte, which losse was by the vertu of his men dobled vpon the rebell of whome were slayne and hurt about 100. In this skirmish, was of singular note the vertu of Sr. Griffin Markham whome the governor comended to the Lord Lieutenant for having made demonstracion of his forwardnes, even to the undertakynge of the duty of a sergeant.




---

p.44


In the morninge after the Lo: Lieutenant had a while enterteyned the governor in pryvate, his lordship devided his forces into 3 partes, sending into the woodes whether the rebells wer retyred with their cowes, 500 choice men under the conduct of Sr. John Mac Coughlin,[108](javascript:footNote('E590000-001/note108.html')) and Sr. Theobald Dyllon, and as many another way under the comaund of Sr. Christopher St. Lawrence; his Lordship with the rest of his forces of hors and foote took the fittest places, from whence he might either second or serve for a retreit to the rest in any extremytye. The enemies fearinge to loose his cowes, entred skirmish with us, but yet so fearfully (seing the Lo: Lieutenant ready for any advantage) and with so small resystance, as their lives seemed more precious unto them then their cowes, upon which Sr. Christofer S. Lawrence fell, who with a great slaughter of the rebells returned with 500 cowes and 60 garrans; the lyke fortune had Sr. John Mac Coughlin and the rest with him. This attempt was made with such resolucion in the soldiers and discretion in the leaders, that yt bredd such a terror in the rebell as after that daye he never durst appear in sight, but hid himselfe from place to place in the woods from whence he could not easely be chased. The Lord Lieutenant seinge yt but lost tyme[109](javascript:footNote('E590000-001/note109.html')) to hunt after them, the yeare spending faste, and the weather being unseasonable, having dispatched away Sr. Con: Clifford into Connaght, returned by easy jorneyes not many dayes after to Dublin, where his Lordship was certefyed of the unfortunate defeat and loss of Sr. Con: Clifford in the Corleus, the manner whereof, as I hard yt related, was in this manner.


A Brief Relation of the Defeat in the Corleus the 15. of August 1599
--------------------------------------------------------------------


Sr. Conyers Clifford,[110](javascript:footNote('E590000-001/note110.html')) governor of Connaght, going to the releefe of Connor Sligo with 1900 men vnder 25 ensignes and about 200 English and Irish horse, came to the entrance of the Corleus the moste dangerous passage in Connaght the 15 of August, about 4 a clocke in the afternoone, being then highe tyme to lodge his men after a paynefull jorney, where understanding that the rebells had not possessed that passage, he resolved to march thorow the same night; whereupon putting his troops in order, the vanguard was conducted by Sr. Alexander Ratclif; the Lord of Dunkellin sonne to the erle of Clanricchard followed with the battell, and Sr. Arthure Savadg brought up the reare guarde. The horse (where also the baggage was left,) had directions to stand betweene the abbey 



---

p.45



of Boyle, and the entrance into the passage, under the com*m*aund of Sr. Griffin Markham, until the same should be freed by the foote about a quarter of a myle from the mowth of the passage, had the rebells traversed the same with a barri*[ca]*do with doble flancks, in which and in other places of advantage thereabouts were lodged about 400 of them, contrary to that which was advertised to the governor. They which possessed the barricadoes, at the approach of our vantguard, delivered a small volly of shott upon them, abandoninge the same allmoste without any force, which the governor possessing made yt passible by openyng the midst, and placed guardes upon the same, appoyntinge to the angle of the sinister flancke Rogers, lieutenant to Sr. Hen. Carye, to the angle of ye Dexter flancke, Rafe Constable (a gentleman deservedly esteemed of the governor for his vertu) and not much distant from him upon the same flancke, Capt. Water Fludd and Capt. Windsore gevinge to them 40 men a piece, with comaundement that they should not abandon their places untill they heard further from himself. Thinges being thus ordered, the vantguard, followed by the batle and rearguard, advanced in short tyme by a narrow waye betwixt 2 large boggs to the syde of a woode halfe a myle broade, through which lyeth a highe waye so broade as yt geveth liberty for 12 men to march in front, the same rysinge equally and gently untill yt have passed the woode where yt is caryed upon the syde of a high hill, which yt leaveth on the left hand and ye hill and grownde adjoyninge being a mayne bogg, vpon the right hand lyeth a thicke woode not more than muskett shott from the same, in either of which places, although the rebell from their contynuall practiz, have exceeding advantage of our men, yet have they more advantage upon the bogge, which they well knowinge made at this tyme choice thereof, and even thither were followed by Sr. Alex. Ratcliff,[111](javascript:footNote('E590000-001/note111.html')) who although he were in the beginninge of the skirmish shott in the face, yet he ever contynewed to spend all his powder upon them; and no supply coming unto him, prepared to charge them with a small number of such choice pikes as would either voluntarylie follow him or were by him called forth by name from of the body of the vantguard; but before he could come to joyne with them, he had the use of a legg taken from him with the stroake of a bullet, by which ill fortune he was forced to retyre, susteyned upon the armes of 2 gentlemen, one of which receivinge the lyke hurte, died in the place, as did also himselfe, soone after, being shott throughe the boddy with a bullet. 



---

p.46



There was with Sir Alex: Ratcliff in the head of the vantguard Capt. Henry Cozbye, whome at his goinge to chardge he invited to accompany him; and perceivynge him slacke, ‘well, Cozsby,’ said he, ‘I see I must leave thee to thy basenes, but I must tell the before my departure, that yt were much better for the to dye in my company by the hands of thy countrymen, then at my returne to perish by my sworde;’ but Cosby, which is the generall disposition of all tru cowards, yeelding to have the terme of his lyfe a while deferred upon any condition, stood fyrme with at least a third parte of the vantguard untill he see the adversyty of this noble knight, when by example of his turninge heade the vanguarde fled in such route, that yt discomfited the batle with ye sight of which (not abiding any impression,) was broken the rearguard, the whole forces being almost without any enemyes force in a moment put all in confusion, which disorder the governor endeavouringe (but in vaine) to reforme, whilest he had any strength left in him, was after much fruitless travell, susteyned breathless upon the armes of Sr. John Mac Swine and Capt. Olyver Burkes lieutenant, who perceivinge the disordered flight of the whole army (disparing to save their lyves by other meanes) perswaded him to retyre himselfe with them; when he reproovinge the basenes of his men replyed Romane lyke, that he would not overlyve that daies ignomynye. But that affection which mooved Sr. John Me. Swyne to vse intreatyes, perswaded him now to practiz force, by which they caryed him from the pursewing rebells some few paces, where enraged with a consideration of the vildenes of his men which he often repeated, brake from them in a fury, and turning head alone, alone made head to the whole troopes of pursewers in the midst of whome after he was stroake through the body with a pyke, he dyed fighting, consecrating by an admyrable resolucion the memory of his name to imortallitye, and leaving the example of his vertu to be intytuled by all honorable posterities. There died lykewyse Godred Tirwhit, brother to Mr. Robert Tyrwhit of Ketleby in Lincolnshire, fighting by the syde of Sr. Alex. Ratcliff, of whome cannot be sayde lesse, then that he hath left behinde him an eternall testemony of the noblenes of spiritt, which he had deryved from an honorable famylye. But these went not alone, for they were accompanied to the gates of death by dyvers worthy, both lieutenants and ensignes, who were followed, (for that they were not followed by them to fight) by 200 base and cowardlye raskalls. The rest which els had all perished were



---

p.47



saved by the vertu of Sr. Griffin Markham,[112](javascript:footNote('E590000-001/note112.html')) who chardginge the pursewers in the head of my Lo: Southamptons troope gave securitie to this ignominious flight, having in his chardge the smaller bone of his right arme broken with the stroake of a bullett, and that which addeth moste to the com*m*endation of his chardge is, that it was presented upon the narrow waye between the two boggs before mencioned, and forced with the losse of some both men and horses into the bogg vpon the right hand, where the rebells followed eagerly the execution of our men, untill the feare they apprehended vpon the sight of our horses, caused them to stay their pursuite and to thinke upon their owne safetye.


This defeat was geven by O'Rvrke[113](javascript:footNote('E590000-001/note113.html')) and mac Dermon O'Donell being there but came not to fight, to whome the governors head was sent that night for a present; his bodye was conveyed to a monastery not far from thence, as appeareth by mac Dermons letter to the constable of Boyle, which is censured by Sr. John Harrington (from whom I received a coppy of yt) to be barbarous for the Latyn but cyvill for the sence. For confirmacion of whose judgment the letter yt selfe is contented by my hand for justyfication of his barbarisme to appeare before as many as will vouchsafe to read yt.



> Conestabulario de Boyle salutem:
> Scias quod ego traduxi corpus gubernatoris ad monasteriu*m* Sancte Trinitatis propter ejus dilectionem, et alia de causa, si velitis mihi redire meos captiuos ex predicto corpore, quod paratus sum ad conferendum vobis ipsum; alias, sepultus erit honeste in predicto monasterio et sic vale, scriptu*m* apud Gaywash 15 Aug. 1599: interim pone bonu*m* linteamen ad predictum corpus, et si velitis sepelire omnes alios nobiles, non impediam vos erga eos.
> 
> 
> Mac Dermon.




By this lettre is too truly interpreted a troublesome dreame of the governors, which he had about a yeare before this defeat, when being wakened by his wife out of an unquiet sleepe, he recounted unto her, that he thought himselfe to have beene taken prisoner by O'Donell, and that certen religious men (of compassion) conveied him into their monastery where they concealed him, and so indeed as he dreamed or rather prophesied the monastery hath his boddye, the worlde his fame, and his frends the want of his vertu.




---

p.48


A brief Relation of what happened in the Expedition of the Lord Lieutenant Generall of Ireland Towards the North Parte of that Kingdom, from the 28 of August untill the ix. of September 1599.
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


No rebell in Ireland being able to contynew long without holdinge correspondency with Tyrone,[114](javascript:footNote('E590000-001/note114.html')) and receyving of ayde from him, I cannot thinke they erre, who are of opinion that he (before any other rebell) were by her Maiesties forces first to be taught his obedience, which no doubt hath beene and is the judgment of the Lord Lieutenant Generall[115](javascript:footNote('E590000-001/note115.html')) of Irelande. But that kingdome, being at his lordships first landinge, either wholly entred into rebellion, or inclyninge to favor them which were allready in action, the northern frontiers being (besides their naturall sterillity) soe wasted by Tyrone, that they denyed meanes not to susteine men but catle, and which is of as great consequence as any other consideration, his lordships army being then raw and unexperienced, yt seemeth to my weake sence to have beene agreable to all pollicy both of state and warr to have first visited ye weaker rebells, against whome his lordship having performed so much as hath beene declared in my former relations; and assured the south and west frontiers of ye English pale, by sufficient garrisons. He departed from Dublin towards castle Kerran,[116](javascript:footNote('E590000-001/note116.html')) a village not farr from Kelles in Eastmeath, where he mustred 2700 foote and 300 horse, conducting them by the shortest way towards Donnemaine in Ferny,[117](javascript:footNote('E590000-001/note117.html')) purposing to plant there a garrison; for that from that place might be offended com*m*odiously all the rebells bordering upon Blackwater. In this jorney his lordship visited Louth, which towne (althoughe yt stande conveniently to receive a garrison,) yet bycause yt could not be fortefied without much chardge, tyme and travell, his lordship repayred Ishleragh, a village neare Louth, placing in the same two dayes after seaven companyes of foote, and a troope of horse. Whilest this worke was in hand, Sr. William Warren obtayned leave of his lordship that he might treate with Tyrone (who laye then encamped not above thre myles from vs, with ten thowsand foote and a thowsand horse) for the deliuerye of Capt. John More, taken prisoner not many daies before in Ophaly. Tyrone professinge to Sr. William Warren to have had a long tyme a great desyre to make his submission, and entreated the Lord Lieutenant by him that he would be pleased to receive a message from him by Henry Agen his constable; who being permitted to have accesse unto



---

p.49



his Lordship that night, entreated that his lordship would vouchsafe to parly with his master the next daye, to which the Lord Lieutenant said that he would in the morning draw forth into the field and be readdy by ten a clocke to parly with him, with his sword in hand, and that Tyrone might know him he comanded to be shewed to Agen his horse and armes, sayinge that he would send to Tyrone to know the markes lykewise of his, to the end they should not mistake one the other in the field, where sayd he to Agen, yf thy master have any confidence either in the justnes of his cause, or in the goodnes and number of his men, or in his owne vertu, of all which he vaynelye glorieth, he will meet me in the field so far advanced before the head of his kerne as myselfe *shall be* separated from the front of my troopes, where we will parlie in that fashion which best becometh soldiors; which sayd, he licensed him to departe.


Early in the morninge the Lo: Lieutenant havinge appointed a sufficient number both of foote and horse, which he ordered in forme of a Saltier or Sanct Andrews cross, placing upon eche flancque (which served for winges,) 100 hors, appoyntinge lykewise to follow the army not much behynde the rearwarde an entier grosse of 100 horse, that out of the same might both be sent out seconds to any distressed parte, and also that in a generall adversytye yt might stand to make the retreat of the whole army. In this order his lordship marched through an open champion, untill he came within a myle, or thereaboutes, of Tyrones camp, which (besydes the naturall strenth thereof) was so strongly fortefyed by arte and industrye, as yt appeared to them, who had scene the woorkes, impossible to be forced by twenty tymes our number.


When the Lord Lieutenant had expected in this place some howres in battell, a small number of Tyrone's horsmen shewed themselves a farr off from our troopes, one of which callinge to ours tould them that Tyrone desyred much to speake with his lordship, and humbly entreated the same. But that tyme and place he thought not fitt, for that their parlye might be a cause to bringe the troopes to blowes, which he studyinge by all meanes to prevent, had purposely conteined himselfe with his whole forces within the lystes of his campe; which so soone as the lord Lieutenant understoode (making his reare the vantguard) he returned to his campe in his first order. Tyrone beinge resolved not to fight upon equall grownde, and the Lord Lieutenant not having sufficient forces to attempt his campe, he resolved by the advice of his counsell, to returne backe



---

p.50



into Meath, and directing his march accordingly the next mornynge towards Nabber,[118](javascript:footNote('E590000-001/note118.html')) which his Lordship had perposed to fortefye and to plant a Garrison, he was overtaken by Hen: Agen, who having don his dutye to his Lordship, he lett him understand (speaking so lowd as all might heare that were present) that Tyrone desyred the Queenes mercy, and intreated to speake with his Lordship concerninge the manner of making his submission, addinge further that Tyrone attended his Lordships pleasure at a forde called Bellaclyne,[119](javascript:footNote('E590000-001/note119.html')) not halfe a myle out of the waye of the army upon the right hand of the march, which being instantly viewed by such as his Lordship sent thither, they fownde the place convenient and Tyrone attendinge there unaccompanied, to whome his Lordship hasted, but not before he had sett a guard upon the baggage, and put both foote and horse in perfect order to fight; bycause that tymes of treaties and parlies have ever beene held for moste suspected.


Before the Lord Lieutenant was fully aryved at the foarde Tyrone tooke of his hatt[120](javascript:footNote('E590000-001/note120.html')) and enclyninge his body did his duty unto his Lordship with very humble ceremony, contynewynge the same observancy the whole tyme of the parlye. It was first emparled betweene themselves in pryvate, and then before six on either partye. With the Lord Lieutenant were[121](javascript:footNote('E590000-001/note121.html')) the earle of Southampton, Sr. Georg Bourchier,[122](javascript:footNote('E590000-001/note122.html')) Sr. Warham St. Leger, Sr. Henry Danvers, Sr. William Constable, Sr. William Warren. On Tyrones parte were Cormoc mac Baron, mac Guinies, Evard mac Cowleye, mac Guyre, Henry Ovengton and Richard Owen; where yt was concluded that there should be a cessation from armes for six weekes, and the warr to be renewed at the Lord Lieutenants pleasure, gevinge 14 dayes warninge. It was further agreed, that yt should be lawfull for all them that were now in action, to participate of the benefyte of this cessation, which if any refused or neglected, they should be lefte by Tyrone and all his adhearents, to be prosecuted by her Maiesties army. For performance of which agreement the Lord Lieutenant bownd himselfe in the honor of his woorde, and Tyrone tyed himselfe by oath taken the next daye followinge by 4 comyssioners, Sr. Warham Senleger, Sr. William Constable, Sr. William Warren and Henry Wootton, secretary to the Lord Lieutenant, of whome he is as worthely esteemed for his rare quallities as he is deservedly loved of all others for his vertues, and therefore thought the onely man in the armye fittest among the rest of the commissioners, that by the weight of his judgment, might be counterpoyzed



---

p.51



the sharpnes of Hen. Ovengtons witt, Tyrones cheefest counsellor. There were sent with the com*m*issioners for their guarde, certeine troopes of horse, with whome remayned as pledge untill the returne of the com*m*issioners, Evard mac Cowlye, Hen. Agen and Shane mac Donnell; Henry Ovengton (without whome Tyrone deliberateth of no matter of moment) was nomynated for the fourth pledge, but Tyrone intreated the com*m*issioners *that* they would rest satisfied with the others, and that Ovengton myght remayne with himselfe.


If there be either fayth in Tyrone or truth in them that are most of his counsell, he desyreth nothing more then peace, which at this tyme had beene concluded, but that he resteth bownde to the Spaniarde by oathe to contynew in armes, yf the Spaniard shall lande such forces in England as might possesse and holde any place in that kingdome; which not succeedinge by the end of this moneth, he hath faythfully promysed to the Lord Lieutenant to submitt himselfe to the Queenes mercy. Of the performance of which promise there is more hope for some important reasons, then for any truth which hath beene fownd in himselfe. For, first, his yeares (which are drawinge to three score) may moove him to desyre quiet; next the establishment of his greatnes in his posterytye, which he can not doe by the custome of Tamistrye, if he should dye and leave his children yonge. Thirdly, the feare which he may conceive of her Maiesties power, if she shall once resolve to presse him in dyvers partes at the same instant. And lastly, a desyre which he may have to preserve that infinite masse of wealthe, which he hath by injustice and rapine heaped togeather, which els *will be* in shorte tyme exhausted, by the maynteyninge of his Bonaghs, and susteyninge them whom he hath robbed.


So soone as this conclusion was made with Tyrone, the Lord Lieutenant dissolved his army, and havinge lodged his men in such garrisons as served beste to preserve the subject, he retyred himselfe to Droghedagh, from whence after some few dayes he returned to Dublin. 














