

A Philosophical Survey of the South of Ireland [...]


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Philosophical Survey of the South of Ireland [...]
====================================================


Author: Thomas Campbell
-----------------------


### File Description

Electronic edition compiled by Beatrix Färber

Funded by University College, Cork and  
School of HistoryProof corrections by Beatrix Färber

 1. First draft, revised and corrected.Extent of text: 
95940 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland —http://www.ucc.ie/celt

 (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E770001-002Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

#### Sources


**Editions**2. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (London 1777).
3. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (Dublin 1778).
4. [Thomas Campbell,] Philosophische Uebersicht von Süd-Irrland, in Briefen an Johann Watkinson (Breslau: Gottlieb Löwe 1779). (Online at https://www.deutsche-digitale-bibliothek.de/item/MYEUO4HDZGL6RLWCRCB62I4CIY7T7K53) [Nach dem Vorbericht des Uebersetzers auf der Leipziger Ostermesse 1779 vorgestellt.]
**Further reading**2. Richard Stanihurst, 'Description of Ireland', in: Raphael Holinshed, Holinshed's Chronicles (London 1577).
3. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
4. Sir John Davies, A discoverie of the true causes why Ireland was never entirely subdued [...] (London 1612) [republished in 1613, with slightly differing title, followed by later reprints].
5. Alexander B. Grosart (ed.), The complete works in verse and prose of Edmund Spenser. (London 1882). (Spenser's *View* is online, in CELT file E500000-001). The Fairy Queene is online at http://spenserians.cath.vt.edu/.
6. James Ussher, Veterum epistolarum hibernicarum sylloge quae partim ab Hibernis, partim ad Hibernos partim de Hibernis vel rebus Hibernicis sunt conscriptae. Iacobvs Vsserivs ... collegit & recensuit. (Dublin, 1632). [Materials about Ussher are online at the Ussher Project at http://www.edwardworthlibrary.ie/The-Ussher-Project].
7. Gerard Boate, Ireland's Naturall History (London 1652. Reprinted as 'Gerard Boate's natural history of Ireland', edited, with an introduction, by Thomas E. Jordan, New York 2006).
8. Isaac Newton, Philosophiae Naturalis Principia Mathematica (London: 1687). (The full text is online at http://www.newtonproject.sussex.ac.uk/view/texts/diplomatic/NATP00077).
9. Richard Cox, Hibernia Anglicana; or the History of Ireland from the Conquest thereof by the English to this present Time. With an Introductory Discourse touching the Ancient State of that Kingdom; and a new and Exact Map of the same, 2 vols. (London: H. Clark and Joseph Watts 1689–90).
10. Gilbert Burnet, The ill effects of animosities among Protestants in England detected: and the necessity of love unto, and confidence in one another, in order to withstand the designs of their common enemies, laid open and enforced (London [1688]).
11. Richard Blome, Britannia, or, A geographical description of the kingdoms of England, Scotland, and Ireland (London 1673).
12. Gilbert Burnet, The history of the Reformation of the Church of England [...] Second edition, corrected. (London, 1681–1715).
13. Sir William Petty, The political anatomy of Ireland ... to which is added .. an account of the wealth and expences of England. London: Printed for D. Brown and W. Rogers 1691. [Reprinted as 'The political anatomy of Ireland: with the establishment for that kingdom, and verbum sapienti', introduction by J. O'Donovan. (Shannon: IUP 1970)].
14. Edward Lhuyd, Archaeologia Britannica, giving some account additional to what has been hitherto publish'd, of the languages, histories and customs of the original inhabitants of Great Britain: [...], Vol. 1., Glossography (Oxford: 1707).
15. George Berkeley, A Treatise Concerning the Principles of Human Knowledge (Dublin 1710).
16. Gottfried Wilhelm Leibniz, Illustris viri Godofr. Guilielmi Leibnitii Collectanea etymologica: illustrationi linguarum, veteris Celticae, Germanicae, Gallicae, aliarumque inservientia [...] vol. 1. (Hanoverae 1717).
17. Philip Ronayne, A Treatise of Algebra, in two Books (London 1717).
18. Robert Molesworth, Some Considerations for the Promoting of Agriculture and Employing the Poor (Dublin 1723).
19. Francis Hutcheson, Inquiry into the Ideas of Beauty and Virtue (London 1725).
20. Francis Hutcheson, An essay on the Nature and Conduct of the Passions and Affections (London 1728).
21. Sir Isaac Newton, Chronology of Ancient Kingdoms Amended [...] (London 1728). [Online at http://www.newtonproject.sussex.ac.uk/catalogue/viewcat.php?id=THEM00183.]
22. Thomas Innes, A Critical Essay on the Ancient Inhabitants of the Northern Parts of Britain or Scotland. Containing an Account of the Romans, of the Britains betwixt the Walls, of the Caledonians or Picts, and particularly of the Scots. With an Appendix of ancient manuscript pieces, 2 vols. (London 1729).
23. Arthur Dobbs, An essay on the trade and improvement of Ireland (Dublin 1729-31).
24. George Berkeley, Alciphron, or The Minute Philosopher ( London 1732).
25. James de la Cour [=Dalacourt], The Prospect of Beauty (Dublin: Faulkner 1732).
26. Patrick Delany, Revelation examin'd with candour: Or, a fair enquiry into the sense and use of the several revelations expresly declared, or sufficiently implied, [...] (London 1732).
27. James de la Cour [=Dalacourt], A Prospect of Poetry: address'd to the Right Honourable John, Earl of Orrery. [...] (Dublin 1734 [1733?]).
28. Patrick Delany, Fifteen Sermons Upon Social Duties (1744).
29. Charles Smith, The antient and present state of the county and city of Cork: in four books. I. Containing, the antient names of the territories and inhabitants, with the civil and ecclesiastiscal division thereof. II. The topography of the county and city of Cork. III. The civil history of the county. IV. The natural history of the same (. . .) (Dublin 1750. Reprinted Dublin 1774. Reprinted by the Cork Historical and Archaeological Society, with the addition of numerous original notes, etc., from the MSS. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W. A. Copinger (Cork 1893–1894).
30. Inigo Jones and William Stukeley, A concise account of the most remarkable antiquity of Great Britain, vulgarly called, Stonehenge, and, the barrows round it with views plan and elevation of the whole structure [...] according to Inigo Jones, Dr. Stukely, etc.; with their opinions concerning it [...] (Salisbury [1750?])
31. John Leland (1691–1766), A view of the principal deistical writers that have appeared in England with observations upon them. (London 1754).
32. John Rutty, An essay towards a natural, experimental and medicinal history of the mineral waters of Ireland (...) (Dublin 1757).
33. Abbé James MacGeoghegan, Histoire de l'Irlande ancienne et moderne: tirée des monuments les plus authentiques, 3 vols. (Paris 1758–62); translated into English, The history of Ireland, ancient and modern: taken from the most authentic records, and dedicated to the Irish brigade (Dublin 1844).
34. [Protestants], An alarm to the unprejudiced and well-minded Protestants of Ireland: or, seasonable queries upon the rise, danger, and tendency of the White-Boys (Cork 1762).
35. Charles O'Conor, Dissertations on the history of Ireland. To which is subjoined, a dissertation on the Irish colonies established in Britain. With some remarks on Mr. MacPherson's translation of Fingal and Temora. Second edition (Dublin 1766).
36. Sir James Caldwell, Debates relative to the affairs of Ireland in the years 1763 and 1764: taken by a military officer; to which are added, An inquiry how far the restrictions laid upon the trade of Ireland, by British acts of Parliament, are a benefit or disadvantage to British dominions in general, and to England in particular, for whose separate advantage they were intended, with extracts of such parts of the statutes as lay the trade of Ireland under those restrictions. (London 1766).
37. William Molyneux, The Case of Ireland being bound by Acts of Parliament in England (1698, reprinted London 1770, with a new preface).
38. William Guthrie, A new Geographical Historical, and Commercial grammar; and present state of the several kingdoms of the world [...] (London 1770).
39. [Dr. John Curry and Charles O'Conor], Observations on the Popery Laws (Dublin 1771).
40. Richard Woodward, An Argument in support of the Right of the Poor in Ireland to a national Provision (Dublin 1772).
41. [Various authors,] Baratariana: A select collection of fugitive political pieces, published during the administration of Lord Townshend in Ireland, (Dublin 1772, second ed. 1773; third ed. 1777).
42. Thomas Leland, History of Ireland (Dublin 1773).
43. Charles Vallancey, An Essay on the antiquity of the Irish language; being a collation of the Irish with the Punic language. With a preface proving Ireland to be the Thule of the Ancients. [Published in the Collectanea] (Dublin 1772).
44. Sylvester O'Halloran, An introduction to the study of the history and antiquities of Ireland: in which the assertions of Mr. Hume and other writers are occasionally considered, illustrated with copper-plates (Dublin 1772).
45. Richard Woodward, An Address to the Public on the Expediency of a regular Plan for the Maintenance and Government of the Poor (Dublin 1775).
46. Robert Nugent, Verses addressed to the Queen, with a New Year's Gift of Irish Manufacture. By Lord Clare (London 1775).
47. Robert Jephson, Braganza: a tragedy (Dublin 1775).
48. [Samuel Johnson,] A Journey to the Western Islands of Scotland (London 1775).
49. Patrick Duigenan, Pranceriana: A select collection of fugitive pieces, published since the appointment of the present Provost of the University of Dublin (Dublin 1775).
50. Richard Twiss, A tour in Ireland in 1775 (London: printed for the author, 1776).
51. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom in 1776–78, (London [etc.] 1887). Available online at CELT. [A translation into German, 'Reisen durch Irrland', was published in Leipzig in 1780.]
52. [Thomas Campbell], A view of the present state of Ireland, containing observations ... intended for the consideration of Parliament, on the approaching enlargement of the trade of that kingdom : to which is added, A sketch of some of the principal political characters in the Irish House of Commons ... (London 1780).
53. Alexander Neckham, De Naturis Rerum Libri duo. With the poem of the same author, De Laudibus Divinae Sapientiae, edited by Thomas Wright (London 1863).
54. Samuel Lewis, A Topographical Dictionary of Ireland, comprising the several counties, cities, boroughs, corporate, market, and post towns. Parishes, and villages, with historical and statistical descriptions (...) (London 1837). [Available online at http://www.libraryireland.com/topog/index.php].
55. Edward E. Freeman, Aetius and Boniface, The English Historical Review 7 (July 1887) 417-465. [On the 'Groans of the Britons'.]
56. P. L. Prendeville, 'A Select Bibliography of Irish Economic History. Part Two: The Seventeenth
and Eighteenth Centuries', *The Economic History Review*, 3/3 (April, 1932) 402–416.
57. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
58. Donal T. Flood, The Decay of Georgian Dublin, Dublin Historical Record 27/3 (June 1974) 78–100.
59. Joseph Leerssen, 'On the edge of Europe: Ireland in search of oriental roots, 1650–1850, Comparative Criticism 8 (1986) 92–112.
60. Stuart Piggott, Ancient Britons and the Antiquarian Imagination (London 1989).
61. Mary Jaeger, 'Cicero and Archimedes' Tomb', Journal of Roman Studies 92 (2002) 49–61.
62. Kevin Mummy, 'The Groans of the Britons: Toward the British Civitates Period ca. 406–455 C.E.', Ex Post Facto 11/2002, 65–79. (Online at http://userwww.sfsu.edu/epf/journal\_archive/volume\_XI,\_2002/mummey\_k.pdf).
63. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson. Thomas Campbell First edition [1 volume; xvi+478 pp: 1–468 letters; 469–478 appendix, two plates.] Printed for W. Whitestone et al. Dublin (1778)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the advertisement and pages 1–467. Two kinds of footnotes are contained (a) authorial, marked *resp="TC"* (b) editorial, by Beatrix Färber, marked *resp="BF"*; all within the TEI-XML encoding.


#### Editorial Declaration


##### Correction


The text has been proofread twice.


##### Normalization


The electronic text represents the edited letters. Errata listed on the last page of the Table of Contents are integrated. Obvious typographical errors are also corrected marked corr sic="" resp="BF". In many cases pronunciation/spelling differs from the usage of today, for example, antient, batchelor, centinel, choiristers, chuse, cieling, controul, enow, ile, landskip, mirrour, nitches, scenick, shew, topick etc. are used for ancient, bachelor, sentinel, choristers, choose, ceiling, control, enough, aisle, landscape, mirror, niches, scenic, show, topic etc. This has been allowed to stand.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the letter; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


A selection of place-names, personal names, group names, and titles of books, periodicals, poems etc. has been tagged. Words and phrases from languages other than English are tagged.


#### Canonical References


This text uses the DIV1 element to represent the Letter. ### Profile Description


Created: By Thomas Campbell (1733–1795)
 Date range: July to December 1775.#### Use of language


##### Language: [EN] The text is in 18th-century English.


##### Language: [FR] Some words and phrases are in French.


##### Language: [LA] Many words and phrases are in Latin.


##### Language: [IT] Some words and phrases are in Italian.


##### Language: [GR] Some words and phrases are in Greek.


##### Language: [GA] A few words and phrases are in Irish, including those in anglicized spelling.


### Revision History


* (2014-04-28) Beatrix Färber (ed.)

* Personal names encoding enhanced.
* (2014-03-06) Beatrix Färber (ed.)

* Queries resolved; some bibliographical details added; SGML and HTML files created.
* (2014-01-17) Beatrix Färber (ed.)

* Appendix proofed (1) and encoded; second proofing of file; persons mentioned in the text identified, more content encoding and bibliographical details added.
* (2013-12-13) Beatrix Färber (ed.)

* Scanning continued; first proofing; structural and content encoding of pp 411–467 finished; file parsed and validated. SGML and HTML files created.
* (2013-11-27) Beatrix Färber (ed.)

* Scanning continued; first proofing; structural and content encoding of pp 281–410 finished; file parsed and validated.
* (2013-10-31) Beatrix Färber (ed.)

* Scanning continued; first proofing; structural and content encoding of pp 101–280 finished; bibliographical detail added; file parsed and validated.
* (2013-09-30) Beatrix Färber (ed.)

* First proofing; structural and content encoding of pp 1–100 finished; provisional header created.
* (2013-05-03) Beatrix Färber (data capture)

* Scanning begun.




---


#### Corpus of Electronic Texts Edition: E770001-002


### A Philosophical Survey of the South of Ireland [...]: Author: Thomas Campbell




---

p.


### Advertisement"


There is, perhaps, no country dependent on the British Crown, which Englishmen know less of than Ireland; and yet it may safely be affirmed, there is none which has a fairer and a stronger claim to their attention.


If civilization has not there been carried to that degree of perfection, which it has attained in England; if commerce does not flourish; — if manufactures do not thrive; — if agriculture be yet in a rude state; — if a spirit of discontent and emigration prevails; — in a word, if the connection between the two islands has



---

p.



not been productive of the greatest mutual advantages, it can only be imputed to a general want of information, and to those mistaken politics, which have, inconsequence, influenced the councils of this nation.


But the time seems to be approaching, when the value of Ireland will be better understood, and when the maxims, on which it is now governed, will be found to be too narrow, it not illiberal. To hasten that period is the design of the following letters, and the favourite political wish of the Writer,


  
**London**,


May 14, 1777.


---

p.1


MY DEAR FRIEND,


  
**Dublin**,


July 17th, 1775.
On the 2d instant, I landed on George's Quay in **Dublin**, after a passage of near thirty hours, which is sometimes made in eight, and generally in less than twelve.


The sea was so calm, that though we went aboard at seven in the morning, darkness only made us lose sight of the Head. Before night I grew sickish, and therefore retired to my bed; but for the last seven or eight hours, I was free from every complaint except hunger, which I felt more keenly than I had done for some years before. This I considered as a good omen; and my health, I trust, is verging towards a re-establishment, by following your judicious advice.



---

p.2



The sun shone bright as we entered the bay of **Dublin**; which was beyond comparison the finest view I had ever seen. It is a spacious amphitheatre, bounded mostly by a high shore. The country all round is spangled with white villas, which being then highly burnished by the sun, had a glorious effect. The city is not seen to advantage from the water, yet the landskip was upon the whole highly picturesque; being horizoned in some places by mountains, exactly conical, called the Sugar-loaf Hills. I am persuaded you would not grudge a journey hither for this single prospect. It must, however, be owned, that the full enjoyment of it is precarious, since it depends on a number of circumstances, which can seldom concur, as the season of the year, the time of the day, and the clearness of the sky, when you enter the bay; and above all, a freedom from pain.


The magnitude of this city is much greater than I imagined; I conclude it to be nearer a fourth, than a fifth of that of **London**. Viewing it from any of its towers, it seems to be more; but from walking the streets, I should take it to be less. To correct these contrary impressions of sense, some certain 



---

p.3



standard is necessary. I have reduced Sayer's pocket-map of **London**, and a map of **Dublin**, prefixed to its Directory, to the same scale, and from thence it appears, that **Dublin** is half as long as **London**; if therefore their figures were similar, the latter would be exactly four times larger than the former; but **London** is more protended in length, **Dublin** being nearly circular. On the other hand, to compensate for the dissimilarity of figures, there is a larger proportion of ground unoccupied by houses in the map of **Dublin**, than in that of **London**.


In the year 1754, the return of houses in this city was 12,857, in 1766 it was 13,194: so that however rapidly it may have increased since, we cannot suppose it to have above 13,500 houses at this day, which falls far short of one-fourth of the number of houses in **London**. Yet I should think there is not such a disproportion in the number of inhabitants, since, according to Dr. Price, ‘651,580 are very probably much *greater,* but cannot be *less,* than the true number of inhabitants in **London**.’


In the year 1731, the numbers of each house were carefully taken by **Dr. Tisdal**,



---

p.4



in two parishes within the city, and two in the suburbs of **Dublin**; from which he computed, at a medium, 12 1/12 to each house; adding, that seventy persons have been known to live in one house. In this respect, the present state of **Dublin** resembles the antient state of **London**. For you know that the annual christenings and burials, in the ninety-seven parishes within the walls, have been reduced at least to one half within a century; formerly, several families were crowded together, and those classes of men, who contented themselves with one house, must now have two.


We may then suppose that the number of families is near double the number of houses, and reckoning six to a family, or twelve to a house, there will be above 160,000 souls in **Dublin**; but say five to a family, and the number will be 135,000. The general computation here, is 150,000; but they, who allow but four and a half to a house, will say, that, instead of being under, I am far above the truth. Let it however be considered, that I go not upon mere technical calculation; I have one
grand *datum,* the actual numbers in four parishes.




---

p.5


Though the bills of mortality kept here are not without their uses, yet from them alone, we can form no just estimate of the numbers at large. A vast majority of the inhabitants are papists; and of the protestants, the dissenters are not the least numerous; consequently, the children of all, except those of the establishment, being baptised privately, the christenings cannot be supposed to be registered regularly; and the Roman catholics burying in old cemeteries without the city, their numbers cannot be ascertained in the bills.


**Dublin** is seen to great advantage from any of its steeples, the blue slating having a finer effect than you can imagine. The best view of it that I have had from its environs, was from the Phoenix Park. This is the Hyde Park of **Dublin**, but much more extensive than that of **London**; and would be exquisitely beautiful, if dressed and planted; but, except some thorns, and the clumps of elm planted by lord Chesterfield in 1745, there are very few trees upon it. Whence it got the name of Phoenix I cannot learn; however, his lordship, in conformity to the name,



---

p.6



name, raised in one part of it a handsome column of free stone, fluted, with a phoenix at top, expiring in a blaze. The inscription on the die informs you that he erected the column, and embellished the park, at his own expence, for the recreation of the citizens of **Dublin**. His name is still held in veneration among them.


The bulk of this city is like the worst parts of St. Giles's; but the new streets are just as good as ours. They have finished one side of a square, called Merion's Square, in a very elegant style. Near it is a square called Stephen's Green, round which is a gravel walk of near a mile: here, genteel company walk in the evenings, and on Sundays, after two o'clock, as with us in St. James's Park. This square has some grand houses, and is in general well built. The great inequality of the houses instead of diminishing, does, in my opinion, add to its beauty. The situation is cheerful, and the buildings around it multiply very fast.


Almost all the tolerable houses, and streets, have been built within forty years. Since the year 1685, the increase has been amazing. **Sir William Petty** relates, that



---

p.7



there were then but 6,400 houses; it must, however, be observed, that Sir William varies prodigiously in his accounts: ‘Memorandum, says he, that in **Dublin**, where there are but four thousand families, there are 1,271 alehouses and brewhouses;’ near a third of the whole: yet, in other places, he says, there are near 7000 families.


The quays of **Dublin** are its principal beauty; they lie on each side the river, which is banked, and walled in, the whole length of the city; and at the breadth of a wide street from the river on each side, the houses are built fronting each other, which bas a grand effect. When these quays are paved like the streets of **London**, we shall have nothing to compare with them.


The **Liffey** runs for about two miles almost straight through the city, and over it are thrown five bridges; two of which, Essex and Queen's Bridges, are newly built. The former, has raised foot-paths, alcoves, and balustrades, like Westminster; the latter, is exceedingly neat, and like the other, of a white stone, coarse but hard, which is



---

p.8



found near the city. The remaining three are as poor structures as you can conceive.


Essex Bridge fronts Capel-street, one of the largest in town, to the north, and Parliament-street, a new and exceedingly neat trading street, to the south: at the end of which, is nearly finished an Exchange, a most
elegant structure, which does the merchants who conduced the building of it great honour; the expence being mostly defrayed by lotteries. The whole is of white stone, richly embellished with semicolumns of the Corinthian order, a cupola, and other ornaments.


Near this, on a little eminence, stands his Majesty's castle, the residence of the chief governor; consisting of two large courts, called the upper and lower castle-yard: In the lower is the treasury, and some other public offices. Though there is little grandeur in the appearance of either, yet, upon the whole, this castle is far superior to the palace of St. James's, in the exterior, as well as in the size, and elegance of the rooms within. Over the gates, leading to the upper yard, are two handsome statues, one of Justice, the other of Fortitude; these,



---

p.9



with an equestrian statute of William III. in College Green, another of George II. in the centre of Stephen's Green, and a third of George I. in the Mayoralty Garden, make up the sum total of the statuary, I could either see or hear of, in **Dublin**; unless we reckon the two upon the Tholsel (the Guildhall of **Dublin**) which I don't know whether to call monarchs or lord mayors.


But to expect many works of the fine arts in a country, but just recovering from an almost uninterrupted warfare of near six hundred years, would be to look for the ripe fruits of autumn in the lap of spring. Even **London** cannot boast of many, considering its mighty opulence. A single church, on the continent, is sometimes decorated with more statues, than are to be seen in the greatest city of Europe.


There are but few public buildings here of any note; some, however, there are. The parliament-house is truly a most august pile, and admirably constructed in all its parts. The house of lords is beautiful; the house of commons capacious and convenient. The front is a grand portico,



---

p.10



in form of the Greek PI, supported by lofty columns of Portland stone; behind this, and over the house of commons, is raised an oblate dome, which not appearing from the street, gives a heaviness to the perspective, and the want of statues over the portico increases it; but, could it be viewed in its geometrical elevation, it would appear
a very light structure.


Near the parliament-house stands the university, consisting of two squares; in the whole of which are thirty-three buildings, of eight rooms each. Three sides of the farther square are of brick, the fourth is a most superb library, which, being built of very bad stone, is unfortunately mouldering away. The inside is, at once, beautiful, commodious, and magnificent; embellished with the busts of several antient and modern worthies. A great part of the books on one side were collected by **archbishop Usher**, who was one of the original members of this body, and without comparison the most learned man it ever produced. The remainder on the same side were the bequest of a Dr. Gilbert, who, it is said, collected them for the purpose to which they are now applied.



---

p.11



Since his time, which is above forty years, their number has not been much increased, though there are many vacant shelves on the other side. Of course the modern publications in this library are very few; yet I am told there is a sufficient fund for purchasing every thing that comes out.


If this be true, there is some ground for the severity of the following little epigram, written upon the rebuilding the front of the college:

> 1. Our Alma mater, like a whore.
>   
> Worn out with age and sin.
>   
> Paints, and adorns herself the more.
>   
> The more she rots within.
> 





The new square, three sides of which have been built within these twenty years, by parliamentary bounty, and from thence, called Parliament Square, is of hewn stone, of a coarse grain, but so hard, that it may bid defiance to the corroding tooth of Time. The front of it next the city, is ornamented with pilasters, festoons, &c. but upon the whole there is nothing very striking in its appearance.




---

p.12


The provost's house, in the same line, has an elegant little front, entirely of Portland stone; yet altogether I cannot say that it pleases my eye. It is a close copy of a house in **London**, one side of which looks into Cork Street, and the other into Burlington Street; but the architect, like other servile imitators, not knowing how to avail himself of his original, nor considering that its depth, which exceeded its length, was screened at both ends by the contiguous houses, left the end of this naked and unadorned, without even a range of windows to interrupt the deformity; so that; seen diagonally from College Green, it produces a most aukward effect; for the façade and gable, though joined together, are evidently not of a piece.


The chapel is as mean a structure as you can conceive; destitute of monumental decoration within, it is no better than a Welsh church without. The old hall, where college exercises are performed, is in the same range, and built in the same style. The new hall, indeed, where they dine, is a fair and large room. In their museum are but few objects which could long detain your curiosity, except



---

p.13



a set of figures in wax, representing females in every state of pregnancy. They are done upon real skeletons, and are the labours of almost the whole life of a French artist. You may remember they were exhibited several years ago in **London**. My Lord Shelburne purchased them, and made a present of them to this university. 


The number of students is very variable; it is said to fluctuate upon the tide of peace and war. About forty years ago, the numbers were pretty nearly the same they are now, that is about 400. At the close of the last war, the numbers upon their books were less than 300. And so few went into the ministry at that period, that curates were wanting for the service of country parishes. It was therefore judged expedient to ordain upon Scotch degrees, which are obtained for the attendance of as many months, as years in **England** or Ireland. At present, few gentlemen of fortune who have not either the advowson of a living in their family, or some peculiar episcopal or parliamentary connection, chuse to dedicate their sons to the church; as the education is too expensive for a curacy of fifty



---

p.14



pounds a year. Yet, they tell you, these few years of peace have produced such a redundancy of candidates for orders, that a nomination is not procured without some difficulty.


As this seminary was founded and endowed by Queen Elizabeth, you will be astonished to hear that they have neither statue, bust, nor picture of their benefactress. The original foundation consisted of a provost, three fellows, and three scholars; which has from time to time been augmented to twenty-two fellows, seventy scholars, and thirty sizers. Of the fellows, seven are called seniors, and in them is lodged the government of the whole body, subject nevertheless to the provost's controul, without whose consent, as sovereign, no act of theirs is valid. The other fifteen are of course called juniors. By their standing they become seniors, and consequently there is no incentive to emulation among them: the instruction of the youth, both in humanity and the arts, falls within their province.


The scholars are elected at three years standing, according to their proficiency



---

p.15



in the classics, by a majority of the seven seniors, and hold their scholarships only for four years; that is, till the standing of master of arts. The fellows are eligible, at the beginning of any Trinity term, after they have obtained a batchelor's degree, by the majority of seniors also, for their proficiency in the learned languages, history, logic, and the sciences. But though all the seven should agree in the choice of both scholars and fellows, the provost can chuse whatever candidate he will, without a concurring voice: this mode of election, they call *nomination.* The prerogative, however, is but rarely exercised.


The fellows hold their places, while they chuse to live unmarried; the income of a senior fellow is supposed to be, *communibus annis,* above seven hundred pounds; but, as it depends upon the renewal of leases, it is uncertain. The emoluments of the junior fellows are their commons, and forty pounds a year, besides lectureships, which together amount to a hundred: and if they be industrious and popular, they get so many pupils, that some of them have very large incomes. The provostship is supposed



---

p.16



to be worth near three thousand pounds a year.


Among the students are three distinct ranks, fellow-commoners, pensioners, and sizers. The first are so called from dining with the fellows; for which privilege, however, they pay little more than the pensioners, who dine by themselves, according to their classes. The great difference is in the rate of tuition; yet, as they get degrees a year sooner than pensioners, there is, upon the whole, little difference in the expence. The sizers, or servitors, pay nothing for their board; they carry up the dishes to the fellows table, which they attend, and afterwards dine upon what comes from it. These wear black gowns, of coarse stuff, without sleeves. Pensioners wear gowns of the same form, but of fine stuff, with hanging sleeves and tassels. Commoners wear gowns of the same shape and stuff, but with sleeves and velvet collars. Noblemen, knights, and sons of noblemen, wear gowns of the same shape with commoners, but with gold and silver tassels.


Though I have a deal more to say of this great town, I shall at present lay down



---

p.17



the pen out of pure mercy to you; for though you like travelling over such grounds as I have carried you, yet I imagine you would rather go by short stages.


Adieu.

  
**Dublin**


After the state of population given in my last, you may, perhaps, be surprised to hear, that there are but twenty parishes in the city of **Dublin**; but consider how few there are in the city and liberties of Westminster; and that the inhabitants of the seventeen parishes without the walls of the city of **London**, outnumber those of the ninety-seven within, almost in the proportion of three to one. The number of parishes is no certain index of the number of people, either here or there. A very obvious reason presents itself, why churches should be comparatively few, where the majority of the people are Roman catholics, and near half the protestants are dissenters.




---

p.18


People are much divided about the proportion which protestants bear to papists in **Dublin**. According to some inaccurate returns, the number of houses belonging to each denomination is nearly equal; yet it is generally thought, that there are two papists for one protestant; most of the poorer sort, and all the servants, being of the former class; and among them chiefly it is, that so many families are crowded into one house.


Over and above the parish churches, are two cathedrals, Christ Church and St. Patrick's; both of them mean Gothic buildings. There is, indeed, more elegance in any one of the six churches in the little borough of Stamford, than in all the churches of this great city put together. For except in the front of three or four of their steeples, external embellishment has been little studied; all that seems to have been aimed at, was neatness and convenience within. But they are generally destitute of all monumental decorations; and, what may seem extraordinary, is very true, they have but one set of choiristers in the whole city; which serves in the 



---

p.19



morning at one cathedral, and in the evening at the other.


In the cathedrals is to be seen, whatever of the monumental kind is worthy *[of]* observation. On the north side of the choir, in Christ Church, is a very superb monument, of the Kildare family, executed in white marble. The late Earl, afterwards **Duke of **Leinster****, and his sister, are represented, mourning over the body of their father.


In the nave is a monument of lord Bowes, late high chancellor of Ireland. It represents Justice, large as life, in a pensive attitude, looking at a medallion, with his lordship's head in relief, which she holds in her hand, weeping over it. The thought is a good one, and well expressed.


Near to this is another, every way elegant, erected to the memory of the founder of the **Dublin Society**. Under his bust stand two boys, one pointing to a *basso relievo* of Industry and Agriculture, the other to a representation of Minerva, leading the arts towards Hibernia. Beneath, on a semicircular tablet, is the following inscription,



---

p.20



written by **Berkeley**, the famous bishop of **Cloyne**:

> 
> Memoriae Sacra
>   
> 
> THOMAE PRIOR,
>   
> 
> Viri siquis unquam alius de Patria
>   
> 
> Optime meriti;
>   
> 
> Qui, cum prodesse mallet quam conspici,
>   
> 
> Nec in senatum cooptatus,
>   
> 
> Nec consiliorum aulae particeps,
>   
> 
> Nec ullo publico munere insignitus,
>   
> 
> Rem tamen publicam
>   
> 
> Mirifice auxit et ornavit
>   
> 
> Auspiciis, consiliis, labore indefesso;
>   
> 
> Vir innocuus, probus, pius;
>   
> 
> Partium studiis minime addictus,
>   
> 
> De re familiari parum solicitus,
>   
> 
> Cum civium commoda unice spectaret,
>   
> 
> Quicquid vel ad inopiae levamen,
>   
> 
> Vel ad vitae elegantiam, facit,
>   
> 
> Quicquid ad desidiam populi vincendam,
>   
> 
> Aut ad bonas artes excitandas, pertinet,
>   
> 
> Id omne pro virili excoluit.
>   
> 
> SOCIETATIS DUBLINIENSIS
>   
> 
> Auctor, Institutor, Curator.
>   
> 
> Quae fecerit
>   
> 
> Pluribus dicere haud refert;
> 
> 
> 
> ---
> 
> p.21
> 
> 
> 
> Quorsum narraret marmor
>   
> 
> Illa quae omnes norunt?
>   
> 
> Illa quae civium animis insculpta
>   
> 
> Nulla dies delebit.
> 
> 
> 




In St. Patrick's the monuments are more in number, but none of such curious workmanship; for, though executed by the same hand with the two last, I cannot admire those massy columns of Italian marble reared to the memory of the late archbishop of **Dublin**; brother to a doctor Smyth, who has been long at the head of your profession here. The epitaph, you may suppose, is very classical, when I tell you it was written by Dr. Lowth, bishop of Oxford.


Opposite to it is a plain monument of **Dr. Marsh**, a quondam archbishop of this see, who left a nobler memorial of himself than stone, a valuable library; which together with part of his estate, for the maintenance of a librarian, he bequeathed to the public. This library, which contains some curious manuscripts, and many rare books, is always open to the studious.


In the same nave are three inscriptional slabs of black marble, one to the memory



---

p.22



of a faithful servant of **Swift**; another lately erected to that of Mrs. Johnson, his Stella and the third over himself, with an epitaph very expressive of that habit of mind, which his own disappointments, and the oppressions of his country, had produced. It concludes with these words, ‘ubi saeva indignatio cor ulterius lacerare nequit.’


In the choir are several monuments of an older date; the principal is that of the family of Boyle. In the chapter room, is a black slab over the duke of Schomberg, who fell at the battle of the **Boyne**, with an inscription by **Swift**; concluding with a severe stricture upon his relations, who refused to raise any sepulchral monument to his name, ‘plus potuit fama virtutis apud alienos quam sanguinis proximitas apud suos.’


West of the town, stands the hospital of Kilmainham, answering to our Chelsea. In the building there is nothing remarkable, but the situation is charming, and affords a comfortable retreat for time-worn veterans. No wonder it was chosen for the seat of their priory, by the knights templars of St. John of Jerusalem.




---

p.23


As the winds on this coast are mostly westerly, they are but little annoyed by smoke from the city, or fogs from the sea; the air is so pure, that one would have thought it might have invited the gentry to extend the town this way, instead of intercepting the merchants from the sea. The hospital is said to furnish many instances of longevity; at present there are three men in it above 100, one of whom is 112.


On the opposite side of the river stands the Barrack, the largest building in the British dominions. It is capable of containing 3000 foot, and 1000 horse. The whole is of rough stone, ornamented with cornices, and window cases of cut stone. Some additions lately made, are not without sufficient elegance of architecture. Indeed the new houses of **Dublin** are exceedingly neat, and in general highly finished in the inside.


You may conceive what the style of building was here formerly, when I tell you, that the mansion-house of the Lord Mayor is a brick house of two stories, with five windows of but two panes breadth in each.



---

p.24



There are, however, some magnificent structures of modern date; the **duke of **Leinster****'s is a very august pile, not unworthy the premier peer of any country. By the way, the family of Kildare has been longer ennobled, than any other now in his Majesty's dominions.


**Lord Charlemont**'s cannot be called a great house, but nothing can be more elegant, and the situation is most delightful; it stands upon a little eminence, exactly fronting Mosse's Hospital, and between them lie those beautiful gardens, where the genteel company walk in summer evenings, and have concerts of vocal and instrumental music thrice a week. His lordship is not only a patron of the arts, but also a great proficient in them; his house is of his own planning. And I have seen, at his beautiful gardens at Marino, near town, a temple of his design; of which a print has been lately struck off in **London**.


There are two or three houses more of hewn stone in **Dublin**, but those I have mentioned, are most worthy notice; and, upon reflection, it is amazing how few of that fort we have even in **London**.


Farewell.




---

p.25


  
**Dublin**


In my last, I mentioned to you Mosse's Hospital; which, I think, deserves particular notice, whether we consider it as a specimen of architecture, or, as an example to prove, that every principle of our nature may be rendered subservient to the interests of humanity.


As a building, it is magnificent, and, being the most faultless I ever beheld, is a lasting monument of the abilities of **Mr. Castels**, who was also the designer of the duke of Leinster's, and the Parliament House. In other respects, the structure must do eternal honour to the founder, Dr. Mosse, a physician of this city; who, by the mere effort of his own genius, in defiance of avowed opposition, and contempt of popular clamour, erected this stately fabric, for the purpose of relieving lying-in-women; the first charity of the kind in these kingdoms, and in which, above 10,000 poor females have been delivered within 



---

p.26



twenty years. His only resources were lotteries, and the emoluments arising from the concerts and gardens. The benevolence of the public was at length awakened; the king gave stability to the institution by a charter, and parliament bestowed a bounty on the widow of him, who had devoted his life to the service of his fellow-creatures.


The present master of this hospital, is a Doctor Jebb, a gentleman of fine parts; whose acquaintance, I am sure, you would be pleased with. He tells me, that except some beds given, and endowed by private donors, the fund for support of this charity, is raised from musical entertainments, and from subscriptions to a right of walking in the gardens at all times. They have lately built a large circular room, called the Rotunda, of an area, as I guess, about a third of that of Ranelagh, but without any pillar in the centre. Here they have an organ and orchestra for concerts, in the wet evenings of summer, and for balls in winter. So that, upon the whole, this is the Vauxhall, Ranelagh, and Pantheon of **Dublin**.




---

p.27


Nay, it is something more than all these, it is a polite place of public resort on Sunday evenings. Whether this entertainment be strictly defensible, in a religious point of view, I shall not determine; but, if the goodness of the end may in any instance be pleaded in justification of the means, I think it may in this. However, it seems rather a matter of wonder, that **London**, so fond of amusement, and so ready to adopt new fashions of dissipation, has not struck out something similar, for passing those hours, which on some people sit so heavy; and which may, after all, be spent in a much worse manner.


On these nights, the rotunda and gardens are prodigiously crowded, and the price of admission being only sixpence, every body goes. It would perhaps benefit the charity, if the price were doubled, for though it might exclude a great many, it would, I think, bring more money. On the other hand, it must be confessed, that the motley appearance gives an air of freedom; for the best company attends, as well as those to whom another sixpence might be an object.




---

p.28


There are twelve other hospitals in **Dublin**, of great public utility, all of which are carefully and skilfully attended; a particular account of these, could give little entertainment even to you; one thing, however, in which they differ from those of **London**, I must remark to you; the physicians and surgeons are not elected by the governors, as with us; but when a vacancy happens, it is filled up by a majority of the faculty, who belong to the hospital.


Almost every parish in the city has schools, supported by charitable donations, collected principally in the churches at charity sermons. And to evince the national humanity, parliament grants an annual sum to a Poor-house, for receiving, and supporting foundlings from every part of the kingdom. To this house, I have been assured that they send children even from **Wales**, and the western coast of **England**.


Upon the whole, **Dublin** is no contemptible city; and we should rather wonder, that, considering its limited trade, it is as well as it is, than that it is not better. It must, however, be acknowledged, that 



---

p.29



except the new streets, which are paved and flagged like those of **London**, it is abominably dirty. In this rainy weather, I see the gentlemen of the army, and others, of the younger sort especially, generally booted; from which I suppose that boots are the ton here.


I, who you know always speak and write from present feeling, cannot describe to you how much I was hurt by the nastiness of these streets, and by the squalid appearance of the canaille. The vast inferiority of the lower ranks in **Dublin**, compared even with those of the country towns in **England**, is very striking. Seldom do they shave, and when they do, it is but to unmask the traces of meagreness and penury. In a morning, before the higher classes are up, you would imagine that half the prisons in Europe had been opened, and their contents emptied into this place. What must it have been then, even within three years, when near 2000 wretches, much worse, of course, than any now to be seen, exercised the unrestrained trade of begging? I am told that the nuisance was risen to such a pitch, that you could scarcely


---

p.30



get clear of any shop you entered, without the contamination of either ulcers or vermin, from the crowd of mendicants, who beset the door.


**Dublin**, by the bye, is indebted to one of our countrymen, a **Doctor Woodward**, who has a deanery in the country, and a parish in the city, for its riddance of this pest. He, with a laudable and unremitting perseverance, so vanquished the national prejudice on this head, that he at length prevailed to have a poor bill passed, free from all those errors that experience had discovered in the English poor laws.


In **London**, one can rarely want amusement, the very streets are an inexhaustible source of it. There is something refreshing in that variety of cheerful objects, which they perpetually exhibit. There is such a cleanness in the streets, such a richness in the shops, such a bustle of business, such a sleekness of plenty, such a face of content, and withal, such an air of pleasure, as infuse the most delicious sympathies. Here, we see but little to cheer, or exhilarate reflection, but much to sadden and depress the spirits. There is, indeed,



---

p.31



a motion, but it is such, as when the pulse of life begins to stagnate, or like that of the wheel of some great machine, just *before* the power which impelled it, ceases to act. Here, to be sure, you meet some splendid equipages, and a large suite of lackeys after a sedan chair; you see a fair range, or two, of houses, and some rich shops; and you frequently meet faces fair enough to make Circassia gaze; but all these scarcely compensate for the painful
sensations produced by the general mass.


Yet the women say, that the social pleasures are more easily obtained here than in **London**. They argue, that the English are generally so intent upon business, that they will not spare time for *their* company, and are consequently devoid of all sentimental attachment; that, matrimony being less the fashion among them, they are for obtaining the favours of the fair, by speedier methods than those of attentions and respects, which, when reciprocal, are among the choicest sweets of life; and that public amusements being less frequent here, domestic entertainments are more in use. These are points I shall not dispute with



---

p.32



the ladies, though I am not convinced of the truth of their arguments. I cannot help remarking, however, that the English are not so addicted to the bottle, which is as great an enemy to sentiment and the graces, as either business or pleasure.


Adhering strictly to your advice, I am every day on horseback, and find vast benefit from it. At first, I felt myself fatigued after riding ever so little; now, after repeated essays, like half-fledged birds, fluttering before they fly, I make excursions of some miles, without being weary. But the roads near the city are very bad, and the streets are so slippery, that I am obliged to have my horse led out of town.


Yesterday I went down the North Strand, catching the sea-breezes as I rode along. Summer-hill, the suburb leading to it, affords one of the most charming prospects in the world. Before you, is the sea, covered with ships; on the left of the bay, is a country beautifully varied, and sufficiently dressed by art, to enrich the landskip; to the right, the conical mountains of Wicklow terminate your view. The river Liffy,



---

p.33



and part of the city compose the fore-ground of this exquisite piece.


Summerhill, as well for the beauty of the situation, as purity of the air, is become the residence of several persons of fortune. I was led to it a few days since, to see one of the most pleasing collections of pictures, I have almost any where observed; and you will be the more surprised when I tell you, that they are all copies; but they are copies of a very peculiar sort. One of them taken from the Galatea of Raphael, they now consider as an original; the original being almost defaced. They were the property of a Mr. Moore, who, during a long residence at Rome, had them painted by Albano, and others, the best masters, from the chef d'oeuvres in that imperial city.


I have seen another collection here, far more valuable, as composed of originals belonging to a Mr. Stewart, whose son was married to a daughter of lord Hertford; among them is a capital piece, of Christ in the manger, by Rubens.




---

p.34


Though an amateur of the fine arts, I cannot think that catalogues of pictures are either worth your reading, or my writing, especially as they are not the productions of this country. You, I know, will be better pleased with pictures of life and manners; and were I a moral painter, I should be glad to gratify you. A sketch, however, I shall attempt of the quondam owner of the former collection, which, if highly finished, would exhibit a very extraordinary picture of human nature.


Born to a good estate, after receiving the best education this kingdom could give, he made the tour of Europe; but Rome had such attractions, that it became his home for several years. There he engaged in such connections, as rendered him for ever after estranged to his native country, and enthusiastically devoted to the house of Stuart, whose interests he not only maintained in conversation, but supported by his purse.


Upon his return to Ireland, too refined, perhaps, by Italian *virtuosoship,* for the relish of his country neighbours, he avoided their company, though fond of society, and confessedly one of the finest gentlemen in the kingdom. He 



---

p.35



therefore found himself unable to take that lead, to which his large fortune, and high accomplishments, gave him such just pretensions; his estate too lying in one of those northern counties, where whiggism was prevalent, he became at length almost sequestered from the world: his table was frequented by few, except mere toad-eaters, though he lived in a style of magnificence till then unknown in that country.


But his ruling attachment marked every action of his life. He was returned to parliament for a borough, but would not take his seat for several years, to avoid taking the oaths; till at length a rule of the house, pointing at him, was made, that whoever did not take their seats before a certain day, should be expelled.


Instead of following nature, in ornamenting his demesne, he took up the whimsical thought of cutting it into the form of a *thistle.* I have it from a gentleman, who has often seen the park, that he cut a deep and wide trench, of a mile in circumference for the bulb of the *flower,* with double ramparts from thence, forming the petals, with clumps of trees representing the down; the avenue to his



---

p.36



house was for the stalk, and the several fields branching from thence, and from each other, delineated the leaves. This indeed was madness, but you must allow there *was method in it.*


To the famous Dr. King of Oxford, he committed the education of his son; who, instead of imbibing from his tutor, the principles of his father, became an admired character in the court of **England**; which so enraged his unnatural parent, that he withdrew that scanty maintenance he had before allowed him. What could the young man do? He was obliged to relinquish for ever all title to an estate of above 4000l. a year, for an annuity of about 800l. This transaction so crushed his spirits, that he soon after died of a broken heart.


The old gentleman had three daughters of distinguished accomplishments. The first gentlemen of the kingdom had asked, and had been refused, their hands; for no reason that could be discovered, but that the political principles of the suiters were different from those of Mr. M—e. The eldest at length listened to the addresses of a gentleman in every respect her equal, a knight



---

p.37



of a shire, and of a most respectable character; whose only fault was, that he was descended of an old whig family. From that instant the father disclaimed her as a child, and settled his estate upon one of his younger daughters, who had issue. Here you'll say there was no great harm done, but mark the sequel.


In the neighbourhood of Mr. M—e lived a Mr. St—t, an old batchelor of small fortune derived from his ancestor, who settled there in the reign of James I. to whom he is said to have been a near kinsman. This gentleman did not fail to pay his constant assiduities, during the last years of Mr. M——e's life; and had the good, or rather indeed ill fortune, to insinuate himself thoroughly into his good graces. It became the established opinion of this now doating old man, that Mr. S——t was the next rightful heir to the crown of **England**, failing the Pretender and his issue. Accordingly, about six weeks before his death, in the eighty-fourth year of his age, being attacked by a palsy, which would have injured an understanding even hitherto unimpaired, he altered his will in favour of Mr. S—t, and disinherited all his own children and grandchildren.




---

p.38


The heirs at law, however, did not acquiesce under this testament, so repugnant to the principles of equity, and the common feelings of humanity. They litigated it under the plea of an unsound mind in the testator, and of undue influence in the legatee. They had, indeed, no other; for the heir had used every precaution, that the will should be drawn, and perfected,according to all due solemnities and legal formalities. Chancery sent it to be tried by a jury in the King's Bench.


After a trial of twenty-four hours, the jurors divided in opinion, eight being for the will, and four against it; a juror was therefore withdrawn, and consequently there was then no issue. In a few terms after, it was decided by the same judges, and another jury, who were unanimous against the will. And thus, for once, triumphed over the vain ordinances of man, that eternal law of nature, which is the law of God.


I am, &c.




---

p.39


  
**Dublin**


I am growing very fond of **Dublin**; I shall not be able to leave it without regret. My letters of credit and recommendation have procured me full as many invitations as I could have wished. It is customary for almost every gentleman, who dines with our friend, to ask you for a day; nay, they will sometimes invite the whole company to be of your party. This hospitable custom is still very prevalent, though not so much, I am told, as it has been.


With respect to drinking, I have been happily disappointed; the bottle is circulated freely, but not to that excess we have heard it was, and I of course dreaded to find. Common sense is resuming her empire; the practice of cramming guests is already exploded, and that of gorging them is daily losing ground. Wherever I have yet been, I was always desired to do just as I would chuse; nay, I have been at some tables, where the practice of drinking healths, at dinner, was entirely laid aside.



---

p.40



Let the custom originate whence it may, it is now unnecessary; in many cases it is unseasonable, and in all superfluous.


The tables of the first fashion are covered just as in **London**; I can see scarcely any difference, unless it be that there is more variety here. Well-bred people, of different countries, approach much nearer to each other in their manners, than those who have not seen the world. This is visible in the living of the merchants of **London** and **Dublin**; with these, you never see a stinted dinner, at two o'clock, with a glass of port after it; but, you find a table, not only plentifully, but luxuriously spread, with choice of wines, both at dinner, and after it; and, which gives the highest zeal to the entertainment, your host receives you with such an appearance of liberality, and indeed urbanity, as is very pleasing. Here, they betray no attention to the counter, discover no sombrous gloom of computation, but display an open frankness and social vivacity of spirit.


I have been more than once entertained with a history of the *good-fellowship* of this



---

p.41



country, by persons who look back with horror on the scenes of their youth; when there was no resisting the torrent of fashion. They tell you, that a large goblet called a *constable,* used to be placed on the table *in terrorem,* which he who flinched his glass, was obliged to drink. They have recounted with rueful countenances, what constables have been swallowed, what doors have been locked, what imprisonments have been endured, before they were *finished,*i. e. *sent away like fleckered darkness, reeling before the sun's path, and Titan's burning wheels.* I am for **Horace**'s rule,
  


> 
> Siccet inequales calices conviva solutus[1](javascript:footNote('E770001-002/note001.html'))
>   
> 
> Insanis legibus, seu quis capit acria fortis[2](javascript:footNote('E770001-002/note002.html'))
>   
>  
> Pocula, seu modicis humescit laetius.[3](javascript:footNote('E770001-002/note003.html'))
> 
> 
> 




The toping part of the world may, however, defend itself upon the authority of the Grecian laws of drinking, reported and approved by Cicero. 
*Lex est quae in Graecorum conviviis obtinetur, aut bibat aut abeat. Et recte. Aut enim fruatur aliquis pariter cum aliis voluptate potandi; aut ne sobrius in violentiam vinolentorum incidat ante discedat.’’*

Marcus Tullis Cicero, Tusculanarum Disputationum Liber Quintus, 41.






---

p.42


Hospitality is unquestionably a virtue, yet I suspect, that what is commonly so called, is not the characteristic virtue of a very civilized, certainly not of any trading nation. **Dublin** is, I suppose, the least hospitable part of Ireland. In some parts of the kingdom, which I purpose visiting, I am told that a beggar comes in, sits down, and fares as the rest of the family; and that ‘green grow the grass before your door,’ is their most malicious imprecation.


If **London** be less hospitable than **Dublin**, it should be considered that a stranger is a greater rarity here than there. Wherever the means of accommodation are universally at hand, there the reason of gratuitous entertainment ceases. Indeed, if a person be in a country where the comforts of life are not to be purchased, and if he be taken in and entertained, this should be called humanity. True hospitality is quite another thing; and this my fond partiality leads me to think is still to be found, in as high a degree in **England**, as in any other country.


The old Britons were as hospitable as the old Milesians, yet the want of this endearing



---

p.43



quality is objected to them by **Scaliger**, among his other reproaches of the English nation. As to the hospitibus feros Britannos, it does not refer to this disposition, but to that asperity with which they treated the Romans, who invaded their country. In those parts of **England**, where they subsist less by commerce than agriculture, this antient virtue is still to be found: and even in Ireland, we must go to the remote parts, if we would see it in perfection. Wherever the spirit of commerce has taken full possession, there hospitality is quite excluded; they cannot exist together; the one goes out as the other comes in. Is there such a word as *hospitality* in a Dutch dictionary? If there is, it must be marked as obsolete.


Though I, and other English who come here, should be losers, I wish most heartily that this country were less hospitable than it is, for then I should hope to see it in a sphere above such little attentions. And though I very highly prize the character, I cannot help thinking that the Irish pride themselves too much upon it. They should reflect, if hospitality has continued longer among them than us, that was only because



---

p.44



they were longer oppressed by a feudal government: which gave birth to a custom here called *coshering;* the source of the most grievous exactions. The lord of the soil came with his retinue, and lived with his vassals as long as they could supply him with subsistence. All things became in common, and the oppressed slave thought himself honoured in being reduced to beggary, by giving his meat and drink with a good grace and cheerful countenance. These manners survived after their cause was happily removed.


If you prefer the men of this country for their hospitality, and the women for their beauty, you are likely to live well with them. The ladies are, I believe, full as handsome as ours, yet it was sometime before I could bring myself to think so. I have been several times at the New Gardens, the only place of public resort at present; the first time I was there, I should have been a very niggard in my praise of Irish beauty; the second time, I thought better of it, and could pick out many pretty faces; now I have not the smallest doubt, but that personal perfections 



---

p.45



are distributed here, in as full measure and proportion, as on our side the channel.


We should not be precipitate in our decisions upon questions of this nature; I was at first deceived merely by the different modes of dress. Feathers, and other ornaments, have not yet made their way hither. It must, however, be confessed, that the middle ranks here want that art of setting off their beauty, and displaying their charms, that they have in **London**. But ladies of fashion are just as you see them there, with all that exact and finished neatness, which enters into the character of English females.


They are said not to walk as well as with us. If the fact be so, I should rather attribute it to the badness of the streets, than to any wrong conformation of limbs. A stranger may be easily deceived in this respect, as there is a numerous class of women, who walk the streets of **London**, that is almost unknown here. So that it is difficult to form a true estimate. In another generation, when the sides of these streets are flagged, the ladies of **Dublin** may



---

p.46



be as much praised, for their walking, as those of **London**.


It is deemed almost a reproach for a gentlewoman to be seen walking these streets. An old lady of quality told me last night, when speaking on this subject, that for her part, truly she had not once walked over Essex Bridge, since she was a girl. Now Essex Bridge is the grand pass here, as Charing Cross is in **London**. As she had nearly lost the use of her limbs, I suppose she thought her consequence was proportionably enhanced in my eyes.


If it were not for dancing, of which they are passionately fond, the poor girls must all become cripples. It is impossible they should excel in what they do not practise; but, if they walk ill, they certainly dance well. For last night, you must know, I was at a ball, and never enjoyed one more in my life. There is a sweet affability and sparkling vivacity in these girls, which is very captivating.


I am, &c.




---

p.47


  
**Dublin**


The theatres being now shut, I can say nothing of them that you don't know; for as **Dublin** has long been our seminary for players, there is scarce any thing relative to it, we are better acquainted with, than the history of its stage. Let me then introduce two articles, which will at least have novelty to recommend them, I mean the *wheel car,* and the *noddy*.


The former is a machine drawn by a single horse, generally lean as Rosinante, and is composed of two shafts, with three or four transums behind the horse, supported by wheels of solid timber, of about two feet and a half in diameter. This is a general substitute for the waggon in the country, and for the cart in town; and therefore cannot fail of conveying an idea of poverty, to one just come from **England**. It might, however, be very useful to the English farmer, upon many occasions; and in **London**, it might serve for the carriage of small parcels, where two



---

p.48



horses are not necessary, and where the porters wooden horse is not sufficient.


The other vehicle called a *noddy,* which plies the streets here, is no more than a single horse chaise, with a seat for the driver upon the shafts; so that the rump of the horse is at his mouth, and his rump at the mouth of the person in the chaise; than which nothing can be more indelicate. It is used, however, only by the lowest orders of citizens, who hire carriages. It has its name, I suppose, from the nutation of its motion.


From the general badness of the streets, hackney-coaches are mare frequent in proportion than in **London**, and sedan chairs are *every* where as common as about St. James's. From this circumstance, one would argue for the opulence of the city of **Dublin**; but it only proves that many families of distinction reside here. As you may make a barometer of any fluid, so may you estimate the wealth of a nation from various phenomena.


One pretty sure sign of poverty is, that, though there are Jews here, there are not enow to form a constant and regular synagogue.



---

p.49



Another which solicits your attention as you walk the streets, is the wretched harridans who ply for hire. These, covered with tattered weeds, are the most horrid miscreants that ever degraded human nature. With vociferations that would startle deafness, and execrations that would appal blasphemy, they celebrate their midnight orgies, to the reproach of magistracy, the scandal of decency, and the terror of sobriety.


Leagued with these strollers, are the bands of robbers who infest this ill-policed city, and render it dangerous to the passenger who walks at night. My banker recommended to me a lodging in Capel-Street, near Essex-Bridge, assigning this reason, that as it was the most public part of the town, I was in less danger of being robbed coming home late: for it seems, that even two chairmen are not a sufficient protection. Newgate is now full of these ruffians, and it is thought that few of them can escape the sentence of the law; but many complain, that through an ill-judged lenity, reprieves are too frequently sought, and too easily obtained. It were, however, devoutly to be wished, that some


---

p.50



other punishment than the gallows could be thought of for such malefactors. To them slavery would be more terrible than death. Policy unites with humanity, in pleading for the lives of all, except of those who have imbrued their hands in blood.


The hawkers of news, and cleaners of shoes, fill up the measure of apparent poverty in **Dublin**. The filth of their bodies is offensive, and their manners shocking; their outrages upon decency disgust you at every corner; and their several cries, infinitely more sonorous than ours, tingle in your ears, with all the enraging variations of the brogue.


The street leading to the cathedral of St. Patrick is so noisome, that it is necessary to stop one's nose in passing through it. No wonder that poor **Swift** was so chagrined with his situation as dean of St. Patrick's; it was a sad reverse from the zenith of favouritism in the court of **England**. To spend those talents upon the sorry subject of copper coin, which had been employed upon the state of Europe; and in withstanding the corruptions of an Irish ministry, to waste the evening of a life, the meridian



---

p.51



of which had given lustre to the councils of **Britain**, was enough to sour a temper more meek than the Dean's. He has been heard to say, ‘I am not of this vile country;’ yet he, of all her sons, seems to have loved her the best.


In this extensive city, are but seven or eight coffee-houses, and they are resorted to for tea and coffee only, not as those in **London** for dinners and suppers. The first day I spent here, I dined at a chop-house in Essex-street, where I found a variety of the best things, and the charges nearly as in **London**. There are, I am told, three or four more of these equally good; yet such places are novel in **Dublin**. Their Hotels have been all set up within a few years, some of which are said to be elegant; I lay the first night in that of Liffey Street, it being next to me; and found it very tolerable.


But you are tired with these unimportant details, which I only set down to impress you more strongly with an idea of the place I write from. Let me then conclude with some account of my expedition to Tarah; which, by a little variation of its old name



---

p.52



Teamor into Temorah, has given title to one of the heroic poems of Ossian, son of Fingal.


This famous hill, situate above eighteen miles from **Dublin**, was at a distance too great for me to ride to it with pleasure, so I took a post-chaise, accompanied by a gentleman, whose extensive knowledge, and communicative temper, rendered the jaunt very pleasant.


After reading the pompous accounts of the triennial conventions at Tarah, where the monarch, provincial kings, and subordinate toparchs, solemnly assembled to adjust rights, enact laws and promulge them, one would naturally expect that there might still remain at least some mouldering heap of that vast edifice wherein the States-general met. The very same expectation is raised by the etymologist, who assures you that Teamor is, literally interpreted, *the great house.*


How then must you be surprised to hear, that there is not even the vestige of a palace to be traced; nay, that the very hill itself is evidence enough to prove, that there never could have been a considerable 



---

p.53



house of stone and lime upon it. The circular forts indeed still remain, in which the several chiefs used either to pitch their tents, or to erect other temporary sheds; but these very intrenchments evince, that stone buildings were not so much as thought of for this eminence.


I will not pretend to deny that the monarch might have had for his own residence, a stone house, somewhere near this hill; perhaps at the foot of it, where the earl of Meath's house now stands. But even this is problematical, especially when we consider, that the palace, in which king John entertained the Irish kings, in this very city, was reared by himself, and made of hurdles. From the description of Pembroke Castle, built ex virgis & cespite tenui by Arnulphus de Montgomery, son of the great earl of Shropshire, it is plain that stone buildings were unusual among the Britons about the same period.


Tarah rises majestic in a most extensive plain, north-west of **Dublin**. From the bottom to the summit, where the royal assembly sat, it is said to be at least a mile in length; but the acclivity is so very gentle,



---

p.54



that it does not appear to be of any great height. In some directions, the eye reaches to an immense distance, and the prospect is upon the whole very pleasant, though by no means rich; the country being mostly under stock, with but few gentlemen's seats, two steeples, and one town to embellish the landskip.


Farewell.

  
**Dublin**


Since my last, I have been to see some of the beautiful scenes of the county Wicklow; which is truly a charming country, abounding with romantic views, very like the good parts of **Wales**. The Glin of the Downs, Dargle, and Water-fall of Powerscourt, are celebrated; but such subjects appear to me much fitter for the pencil than the pen.


I have been also at **Carton**, the seat of the duke of Leinster, in the county **Kildare**. Of this nobleman, it may, I believe be said, that he is the best appointed of any in Europe, both for a town and country house. Near it is **Castletown**, the seat of



---

p.55


**Mr. Conolly**, the greatest commoner in the kingdom; whose house is fitted up in the most elegant modern taste, and whose mode of living is in the highest style of hospitality. He has a public news or coffee-room, for the common resort of his guests in boots, where he who goes away early may breakfast, or who comes in late may dine, or he who would chuse to go to bed, may sup before the rest of the family. This is, almost, princely.


All the outlets of **Dublin** are pleasant, but this is superlatively so which leads through **Leixlip**, a neat little village, about seven miles from **Dublin**, up the **Liffey**; whose banks being prettily tufted with wood, and enlivened by gentlemen's seats, afford a variety of landskips, beautiful beyond description. Near the village is a venerable old house, seated on an eminence, where **lord Townshend** spent his summers, while chief governor; and which the late Lord Primate used as his country-seat.


**Stone** was a man of considerable abilities, but more of the politician than the prelate, he devoted his life to the supporting 



---

p.56



a party in the Irish parliament. It is said that when he went over to **London**, to consult the gentlemen of your faculty on his state of health, he very candidly said to them, ‘Look not upon me as an ordinary churchman, or incident to their diseases, but as a man who has injured his constitution by sitting up late, and rising early to do the business of government in Ireland.’


They consider his death an aera in the polity of this kingdom; for had he lived till now, he would have been always one of the Lords Justices, with the power of the whole; and of course business would have been concluded in the usual way. Administration would have continued to throw all its power into his hands; who made so proper a use of it, that the perpetual residence of viceroys would not have been thought necessary.


In this nation are three or four grandees, who have such an influence in the house of commons, that their coalition would, at any time, give them a clear majority upon any question. It has, therefore, always been a maxim of government to disunite these factious chiefs. And, still farther to disable



---

p.57



opposition, it has been thought expedient to disengage as much as possible, the followers from their leaders. This was attempted by lord Chesterfield, so early as the year 1745; but his stay was too short to effect it.


Formerly, these principals used to stipulate with each new Lord Lieutenant, whose office was biennial, and residence but for six months, upon what terms they would carry the king's business through the house; so that they might, not improperly, be called undertakers. They provided, that the disposal of all court favours, whether places, pensions, or preferments, should pass through their hands, in order to keep their suite in an absolute state of dependence upon themselves. All applications were made by the leader, who claimed, as a right, the privilege of gratifying his friends in proportion to their numbers.


Whenever such demands were not complied with, then the measures of government were sure to be crossed and obstructed; and the faction of parliament became a constant struggle for power, between the heads of parties; who used to force themselves



---

p.58



into the office of Lord Justice, according to the prevalence of their interest.


On **lord Townshend** devolved the arduous task of dissolving these factions, so frequently turbulent in the Irish parliament. He set out with an action so popular, that the mob took the horses from his coach, and drew him from the Parliament House to the Castle. This deed so pleasing to the people, was giving the royal assent to a bill, brought in, by the famous patriot **Dr. Lucas**, for limiting the duration of parliaments to eight years. But they now begin to think that this favourite law is of no other use, but to increase the value of boroughs; a single seat in one of which sells for 2000l. at least.


But his Lordship's popularity did not last long. By diverting the channel of court favour, or rather by dividing it into a multitude of little streams, the gentlemen of the House of Commons were taught to look up to him, not only as the source, but as the dispenser of every gratification. Not even a commission in the revenue, worth above 40l. a year, could be disposed of without his approbation. Thus were the



---

p.59



old undertakers given to understand, that there was another way of doing business than through them. It was not, however, without much violence on both sides, that he at length effected his purpose. The immediate sufferers did not fail to call this alteration in the system of governing, an innovation; and, under various pretences, to spirit up the people to adopt their resentments.


The contest produced a series of political letters in the public prints, replete with wit and humour, inferior, perhaps, to nothing of the kind, except the letters of Junius. They are now bound up in one volume, under the title of Baratariana; from allusion to the island of Barataria, of which Sancho was made governor by Don Quixot.


**Lord Harcourt** now finds the parliament of Ireland full as obsequious as that of Great Britain; and from that courteous deportment, which, every where pleasing, is here particularly engaging, he is as popular as any man can well be expected to be in his station, which is of such a ticklish nature, that odium effugere est triumphus.




---

p.60


Having now, I flatter myself, given you a tolerable notion of **Dublin** and its environs; I purpose setting out in a day or two to visit the principal places in the south of the kingdom. I prefer a southern to a northern tour, not only as the climate must be better; but because the north is in a thriving state of manufacture, and therefore cannot be supposed to differ so widely from **England**, as a country where neither manufactures nor agriculture flourish.


A slight sketch of the geography of this country, may enable you the better to trace me without a map. Ireland is divided into four provinces, **Ulster**, **Conaught**, **Leinster**, and **Munster**. The last is to the S. and the first to the N. **Leinster** is to the E. and **Conaught** to the W.


**Leinster** (in which is **Dublin**, about midway removed from either extremity of the kingdom) is the most level, and best cultivated; **Ulster** the most barren and mountainous, but the most thriving and populous; **Munster** the most fertile, yet the least thriving upon the whole; the increase of people in her cities not compensating her internal depopulation: **Conaught** is said to increase in numbers,



---

p.61



by introducing the linen trade into the parts bordering upon **Ulster**; though its capital is declining, and its most fertile parts, like those of **Munster**, are verging to depopulation.


Let me hear from you soon, and direct to me at Mr. B—— 's, **Corke**. My future progress will, I hope, furnish materials of more importance, or, at least, of more novelty; for hitherto I have moved in a very beaten path. I shall write from every great town in my route.


Vive & vale.

  
Kildare,


August 21, 1775.
I set out this morning from **Dublin**, with only half a dozen shirts in my portmanteau, to leave room for such books, relative to Ireland, as seemed the fittest to prepare me for a local inspection. **Sir John Davies**'s Historical Relations and **Spencer**'s View are my pocket companions; enow, I presume, to fill up the vacant intervals at an inn.


I purpose giving you sketches of the country through which I travel, that you



---

p.62



may have some idea of its present state, whether natural or improved. But lest they should seem overcharged with still life, I shall heighten the prospect with human figures as they present themselves; and to vary the scenery, retrospective views of manners, customs, and arts shall be interspersed.


You are not to expect either order or method in the arrangement of my observations; I shall set them down as they occur, without much attention to time, place, or other accident. All I shall promise is, fidelity in reporting facts. And if I should sometimes miss my way in tracing causes from their effects, candour will suggest to you in extenuation, how difficult it is for one who is a stranger, and alone, to come in a short time at the knowledge of many things, which the natives might wonder how any one could be ignorant of. There are indeed certain characteristics in this country, which he that runs may read: yet I do not find that any traveller has been at the pains to point them out. I begin to wish I had set out earlier, for my tour must now be limited by the season, and I must either forego



---

p.63



the sight of some places I would wish to see, or spend too little time in each to get any satisfactory information.


My object is not only to see the face of the country, and learn its present state, but also to compare this state, with what it has been, and what it might be. And in judging of national character, I would be for making a careful discrimination, between physical and moral causes, between the operations of nature and the influence of government.


This is but a poor town, consisting of a few scattered houses; the inn however is a very good one. The country for several miles on this side **Dublin** is flat, like that round **London**; but it is not like it either in the multitude or magnitude of the trees, and still less so in the appearance of the houses on the road side. The first village I passed through, about seven miles from **Dublin**, **Rathcool** I think they call it, was mostly composed of clay huts, which are sometimes, you know, both warm and neat; but these were so aukwardly built, and so irregularly arranged, that even **Wales** would have been ashamed of them. It hurt me



---

p.64



to see them so near the capital, where the landskip was so prettily chequered by abundance of little white villas, spangling the country all around, and rendering it upon the whole very delightful.


**Naas**, fourteen miles from **Dublin**, is but a shabby looking place for a borough and shire town. But there are some pleasant seats near it, and the grounds begin to swell into gentle undulations, which gives a sweet variety to that rich corn country.


On the road hither is the ruin of a magnificent house, begun, but never finished, by **Earl Strafford**, when Lord Lieutenant. Near this, about thirty of our miles from **Dublin**, is the **Curragh** of **Kildare**, where all great matches are run. It is the Newmarket of Ireland: and the sportsmen tell you that the turf is equal to any in **England**, it is a spacious common and sheep-walk. Government gives annually two prizes of one hundred pounds each to be run for here. These were originally given at the suggestion of **Sir William Temple**; who, among other schemes for the improvement of Ireland, recommended this with a view of mending the breed of horses.




---

p.65


As this ground was famous for horseracing long before kings plates were established here, I vainly flattered myself that it took its name from its being a horsecourse, and that it was called **Curragh** from the Latin word curro, or rather from some Celtic word of like found and import. Thus you see me delving for the roots of Irish names, though I believe there are few people more thoroughly convinced that etymology is frequently but the excrescence of literature. It degenerates even in the hands of **Sir Isaac Newton**, for he identifies persons and things, which have nothing in common, but a letter or two of their names.


Certain it is, the most useful things may be abused. But sceptical as I am with respect to etymology, the information I have received inclines me to think that every town and tract of country, nay almost every hill in Ireland, is denominated, either from some history of the place, or some quality of the soil; some virtue of the water, or some property of the air; some accident of the ground without, or from some mineral within; in a word, that each name contains 



---

p.66



a brief history, or marks out some curiosity of nature or of art.


Several instances of this I have been favoured with by **Colonel Vallancey**, a gentleman whose acquaintance alone is worth a journey to Ireland. And you will not be displeased when I tell you, that he is our countryman, was bred at Eton, and is now engineer-general of Ireland. At an age when words and other materials of knowledge are generally collected, he betook himself to the study of the Irish language, with a diligence so successful that he soon outstripped his teachers. To him we are indebted for the best grammar of this language, indeed the only one which deserves the name. So that the Irish nation may with little variation apply to him what **Cicero** says of himself, upon finding out the tomb of Archimedes: *Ita nobilissima Graeciae civitas, quondam vero etiam docissima, sui civis unius acutissimi monumentum ignorasset, nisi ab homine Arpinate didicisset.’’*

Cicero, Tusculan Disputations.




At the end of his grammar he has brought to light some very old Irish manuscripts; among the rest one, intitled, Lessons for a Prince. It was addressed to that celebrated



---

p.67



monarch of Ireland, Brien Boiromhe, who exterminated the Danes at the battle of **Clontarf**. The style, which is not unlike the Proverbs of Solomon, marks the very high antiquity of it, and the fine moral and political spirit which animates the whole piece, sufficiently evinces that civilization had made a considerable progress here before the invasion of our second Henry.


This learned soldier had before favoured the world with an essay on the antiquity of the Irish language; wherein, from a collation of the Irish with the Punic, he shews it to have a strong admixture of the old Phoenician. His mode of proceeding is very satisfactory: he takes that scene of **Plautus**, wherein a Carthaginian slave is introduced speaking in his mother-tongue; and comparing it verbum verbo with the Irish, which is now generally acknowledged to be the purest dialect of the Celtic, shews the agreement between the two languages; which is indeed so striking, that even a person who understands neither may perceive it, by a bare inspection of the words.


And from this close affinity of language he furnishes a strong presumptive, if not



---

p.68



decisive proof, that literature was very early introduced here by the Tyrians, either through the medium of that trade which was carried on with all parts of the world then known, or through that colony which migrated hither from **Spain**; and from which the old natives are so proud of being called Milesians.


It has been the doctrine of the Irish writers, that they derived their learning from the Phoenicians: their bards tell you of one Phenius a-fear-Saidhe, i. e. Phenius the Sidonian man, who taught them letters. The truth, divested of its poetical obscurity, appears to be, that the man who taught them letters was a Phoenician or Sidonian, Tyre being the daughter of Sidon.


**O'Connor**, who has published some ingenious dissertations upon the history of Ireland, brings a reinforcement of arguments from **Newton**'s Chronology[4](javascript:footNote('E770001-002/note004.html')), which wonderfully corroborate this matter. He gives you a table where, in one view, you may see the coincidence of the Irish accounts with the Newtonian amendment. The parallel is very striking.




---

p.69


**Spencer** thinks that the Irish had their letters from the nation which migrated from **Spain**; which, as he proves from **Strabo**, used the Phoenician letters very early. He is not however decisive on this head, but he says, ‘It is certain that Ireland had the use of letters very anciently, and long before **England**.’


*How comes it then, asks he, that they are so unlearned still, being so old scholars?* To which inquiry, as he returns no answer, I shall perhaps in future risk some conjectures respecting it. For without having recourse to any physical incapacities, the dreams of intoxicated speculation, several causes might be specified, which have necessarily obstructed the progress of the arts in this country. In one word, a provincial government has in itself impediments enow, to prevent the attainment of perfection in every department, where the strongest exertion of the human powers is to be called forth. But a full discussion of this question I shall defer till I have more thoroughly digested my thoughts; for the answer is, periculosae plenum opus aleae.




---

p.70


Perhaps you did not know that **Spencer** spent a great part of his life in Ireland: they tell me the house is still standing wherein he wrote his Fairy Queen; if it comes at all in my line I should be glad to visit it: there is a pleasure which we cannot account for in the sight of such places. I never was in **Stratford** that I did not feel an unusual emotion, at sight of that little wooden house, which gave our **Shakespear** birth. By the way, what think you could have inspired **Shakespear**, with that odd-looking epitaph?


> 1. Good friend, for Jesus sake! forbear
>   
> To dig the dust inclosed here;
>   
> Blest be the man that spares these stones,
>   
> And curst be he that moves my bones.
> 





The Old man, you know, spent the last years of his life at **Stratford**, where it was the custom to gather all the bones, sculls in particular, and pile them in heaps. The largest collection in **England** is still to be seen in the vaults and steeple of that very church, where **Shakespear** lies interred. It seems more than probable, that it was this,



---

p.71



to him offensive, practice which suggested the thought in the above lines.


Good night.

  
Kildare


Having, in my last, conveyed myself to **Stratford** and **Shakespear**, let me, in this, return to **Kildare** and **Spencer**. This poet tells us, that he once meditated a treatise upon the antiquities of Ireland. Pity that he never put it in execution! Under the hands of such a master it would have grown into a piece of entertainment, a quality so rarely to be found in works of that complexion.


The opinion, however, he has given, on this particular subject, should be sufficient to excite the curiosity of an antiquarian. It has, I own, disposed me to give a more impartial hearing to whatever can be offered, in favour of the antiquities of this country, than otherwise I mould have been inclined to do. ‘All the customs, says he, of the Irish, which I have noted and compared with what I have read, would minister occasion of a most ample discourse of the original



---

p.72



of them, and the antiquity of that people; which in truth I think to be more ancient than most that I know of in this end the world. So that, if it were in the handling of some men of sound judgment and plentiful reading, it would be most pleasant and profitable.’


There must surely be some foundation in truth, for that high antiquity the Irish plume themselves upon; if not, would **Tacitus** have said, that ‘the ports and harbours of Ireland were better known by trade and commerce than those of **Britain**.’[5](javascript:footNote('E770001-002/note005.html')) And if this same antiquity be a thing so chimerical, as some would represent it, how comes it, That when the ambassador of Henry the Fifth claimed precedence at the Council of Constance, he founded his title upon his matter's being lord of Ireland?


Orpheus tells us expressly, that the Argonauts sailed near the island ***Ierne**;* a testimony prior to any which imperial Rome can produce in favour of her antiquity. **Hibernia** is comparatively but a modern name. **Ireland** is the ancient **Scotia**. In later days, **Caledonia**, or rather Albania, which had been for many centuries ruled



---

p.73



by the descendants of Fergus, brother to the monarch of Ireland, began to be called Scotia minor, or nova. But this was not till the eleventh century, and Ireland retained the name of Scotia, with the addition of major, or vetus, till so late as the fifteenth. All which **archbishop Usher** *incontestably* proves, and he gives it as his opinion, that no writer, before the eleventh century, can be produced, who ever pointed out Albany by the name of **Scotland**.


It is near two hundred years since the learned primate gave this sort of challenge, and during that space, no writer has attempted to answer him; but on the contrary, **Camden**, **Scaliger**, **Stillingfleet**, **Dupin**, **Prideaux**, **Rapin**, **Warner**, **Whitaker**, and all other writers on the subject, except two or three of **Scotland**, confirm his opinion. It was an attack made upon the antiquities of his native country, which probably excited **Usher** to treat of them with such copious precision.


**Dempster**, a Scotchman, under the ambiguity of the name, had laboured to confound the matter. He sent **Philip Ferrarius** a collection of Scottish worthies, to enrich


---

p.74




the Roman martyrology. But this learned and candid Italian betimes discovered the snare, and published an advertisement prefixed to his book, wherein he warned the reader; ‘that taking other writers for his guide, he had made some of the Irish saints natives of **Scotland**. The cause of which, was his being deceived in the name, Ireland being in old times called **Scotland**, and the Irish Scots; as we learn from Orosius, Prospero, **Isidore**, Cogitosus, Adamnanus, Jonas the Abbot, all antient writers; together with Bede, St. Bernard, and others who have written the lives of Irish Saints. For who does not know that the Saints Brigid, Brendan, Columb-cill, Columban, Gall, Fiacre, **Virgil**, Kilian, Rumoldus, Dympna, Fuscus, Malachy, and others, were Irish? who, notwithstanding are called Scots, and said to be born in **Scotland**; of which I thought proper to admonish you, that you may be aware of certain *Saint-stealers.*.’ By which coarse character he branded **Dempster**. And the only harsh expression in **Usher**'s book, is vented against this man. *Tam suspectae fidei hominem illum suisse comperimus & toties 



---

p.75



tesseram fregisse, ut oculatos nos esse testes oporteat, & nisi quod videmus nihil ab eo acceptum credere.’’*




**Nicolson**, whom, as the author of the Historical Libraries, we may suppose a competent judge in this affair, and as an Englishman, impartial, is so convinced of **Dempster**'s dishonesty, that in one place, he calls him ‘the northern rover, who had kidnapped whole scores of Irish saints;’ and in another place, he takes notice of ‘the good services done this kingdom, by **Thomas Dempster**'s robbing it of its saints, and transplanting them into his own Albanian territory. Which raised a just resentment in the antiquaries of Ireland, who forthwith betook themselves to arms, for the recovery of their stolen goods, and proved clearly that the Scots of antient times, famed for sanctity and learning, were all of them *Irishmen.*’


But all the Scotch writers before **Dempster**, are so far from denying the Irish extraction of the present Scots, that they seem to glory in it. ‘It is by many arguments certain, says **John Major**, that we owe our origin to the Irish. This we learn



---

p.76



from the language, for even at this day, one half of **Scotland** speaks Irish; and a few years ago, a much greater proportion spoke the same language. The Scots brought their speech from Ireland into **Britain**, as our annals testify; the writers of which, have shewn a laudable diligence in these matters. I say, therefore, that from whomsoever the Irish draw their origin, the Scotch derive from the same; not immediately indeed, but as a grandson from a grandsire.’


King James I. in one of his speeches, boasts of the Scottish dynasty being derived from that of Ireland. ‘I have two reasons to be careful of the welfare of that people; first as king of **England**, by reason of the long possession the crown of **England** hath had of that land; and also as king of **Scotland**, for the *antient kings of **Scotland** are descended of the kings of Ireland.*’. Conformably to which, Slaytyr, in his Palai-Albion, compliments this monarch upon his *Irish* pedigree,

> 1. At quoniam, Arctoo Scotico rex noster ab orbe,
>   
> Nec minus occiduis, perhibent, Scotus ortus Hibernis,
>   
> Qui Britonum parent sceptris; mihi pauca recensens,
>   
> Musa age, et Ogygios Iernes reserato colonos.
> 






---

p.77


From the above authorities, one would think this question was fairly decided; for, in points of antiquity, authority is the principal, if not the only argument which can be adduced. Yet, up starts another Scotchman still more hardy, who finding no authorities, either at home or abroad, to support the darling antiquity of his native country, is for annihilating all authorities against it; and vainly dares to obtrude upon us, for true history, the inverted sonnets of Hibernian bards,


> 1. Whence issued forth at great M'Pherson's call,
>   
> That old new epic pastoral Fingal.
> 




This learned gentleman very gravely tells us, that ‘Fordun was the first who collected the fragments of Scotch history, which escaped the brutal policy of Edward I. —— that he, possessed of all the national prejudice of the age, was unwilling that his country should yield in point of antiquity to **England**; and that, destitute of annals in **Scotland**, he had recourse to Ireland, *which, according to the vulgar errors of the times, was reckoned the first habitation of the Scots.*— That the writers who succeeded



---

p.78



Fordun, implicitly followed his system; that as they had no new lights, and were,equally with him, unacquainted with the traditions of their country, their histories contain little information concerning the origin of the Scots. — That even **Buchanan** himself, except the elegance of his style, has very little to recommend him. It therefore appears that little can be collected from their own historians, concerning the first migration of the Scots into **Britain**.’


Thus you see the authority of all Scotch historians is torn up from the very root. Aristotle, they say, destroyed the works of all his predecessors to make way for his own. But in the name of wonder, where were the songs of Ossian, when Fordun's national prejudice had recourse to Ireland, to supply the want of materials in **Scotland**? Would not his filial zeal have gladly laid hold of them for the same purpose with our modern man of antiquity?


In the dissertations before Fingal and Temora, we are told, that ‘as the custom of retaining Bards and Senachies was common to both nations; so each, no doubt, 



---

p.79



had formed a system of history, it matters not how much soever fabulous, concerning their respective origin.’ Now let me ask, if each had formed their systems, wherefore did Fordun adopt the Irish system? And if ‘it was the natural policy of the times, to reconcile the traditions of both nations together, and if possible to deduce them from the fame original stock;’ why does the following paragraph insinuate that the system was not concerted, but that the Scots were imposed upon?


‘For the Irish, who for some ages before the conquest by Henry II. had possessed a competent share of that kind of learning, which then prevailed in Europe, found it no difficult matter to impose their own fictions upon the ignorant Highland Senachies. By flattering the vanity of the Highlanders with their long list of Heremonian kings and heroes, they without contradiction assumed to themselves the character of being the mother-nation of the Scots of **Britain**. At this time, *certainly* was established that *Hibernian system* of the original of the Scots, which afterwards, 



---

p.80



for want of any other, was universally received.’


It is here, you see, dogmatically laid down, that the Hibernian system was the fiction of the thirteenth century; and it is also admitted, that it was universally received, for this good reason, that *there was none other.* This ample concession really looks as if the writer had a mind to arrogate to himself the original invention of the Caledonian system; but his candour should have confessed that it was the happy thought of the last century. The whole state of the case is briefly this:


In the fourteenth century, Fordun *did* collect such remains of antiquity as had escaped the ravages of Edward; and it is agreed, on both sides, that scarce any escaped, except those in the monastery of **Hy Columb-cil**. In the fifteenth century, **bishop Elphinstone**, chancellor of **Scotland**, after making the strictest search for old records, lays so little stress upon what he found, that he fairly refers you ad antiquos Hiberniae scriptores. We have seen what the opinion of **John Major** was



---

p.81



in the beginning of the sixteenth century, towards the close of which **Hector Boetius** wrote his fabulous history, adhering closely to his predecessors in tracing the origin of the Scots. **Buchanan** follows him, rejecting his glaring incongruities, and supporting the Hibernian system by the collateral authority of foreign testimonies. To his contemporary **Dempster**, was reserved the innovating invention of the Caledonian system.


But **Sir George M'Kenzie** scorned to follow him; even he who thought it his duty, as advocate general of **Scotland**, to impugn certain parts of Irish history, in order to lengthen out the royal line, and to prove, for the honour of his Majesty, that his pedigree was derived from sovereign princes, rather than provincial kings. **Sir George** admits that *the Scots of **Britain** came last from Ireland;* and so doth **Innys**, whose more learned labours tend to shorten rather than lengthen the catalogue of Caledonian kings.


What then remains to support the credit of a system, exploded *universally* abroad, and *generally* at home, but the genius, style, 



---

p.82



and learning of Mr. M———n? Which, after all, betray his distrust of it, and cannot secure him from manifest self-contradictions. First, ‘the Hibernian system is concerted between the two nations;’ next, ‘the one was imposed upon by the other,’ then it was neither concerted nor imposed, but ‘the true Caledonian system was handed down by tradition; though a few ignorant Senachies might be persuaded out of their opinion, by the smoothness of an Irish tale, it was impossible to eradicate from the bulk of the people, their own national traditions.’


He sometimes attempts to entrench himself in verbal criticism, a sort, in which, one would have thought, he would have been impregnable; but even a person who knows nothing of the Irish language, may, with very little attention, perceive the improbability of what he advances. He asserts, what is universally denied by the Irish, that they call their language Caëlic-Erinach. They say, that the Irish of both the **Scotland**s, the old and the new, have all along called their language Gaëlic without any addition.




---

p.83


Now to be convinced that this is the truth of the matter, let us only ask ourselves, to what purpose should a mark of distinction be added to the same language, though spoken by different nations? We use no addition, to discriminate the language of **England**, from that now commonly spoken in Ireland. No! we call both the English. And when we talk of the Latin tongue being generally spoken, at such or such a period, we do not say the Latin of **France**, or the Latin of **Germany**, but simply, and emphatically, the Latin. An epithet is indeed necessary to distinguish the people of a colony, from those of the mother-country; as to distinguish the descendents of the Saxons in **England**, we call them Anglo-Saxons. Accordingly we find, that in the Irish or Gaëlic, a Scotchman is called Albanach Gaël, i. e. a Scoto-Hibernian; but an Irishman is called emphatically Gaël.


Another circumstance there is, which tends to throw some light upon this matter; the songs of Ossian are as familiar to the original natives of Ireland, as



---

p.84



they are represented by Mr. M'—n to be in **Scotland**. And it is reasonable they should be so. Ossian is mentioned by **Keating**, **Flagherty**, and all the other historians of this country, as an Irish chieftain; but no notice is taken of him by any Scotch historian. Nor is there any mention made by them of Fingal, father to Ossian; yet all the Irish histories are replete with his exploits. Fin-mac-Comhal (pronounced Finmacoal) i. e. Fin the son of Comhal is the great hero, to whom, as a Hercules, the common Irish assimilate all strong and gallant men.


So much, indeed, is virtually admitted by the publisher of Fingal; and to usher his work with greater plausibility into the world, he takes notice of an advertisement, which had appeared in the Irish newspapers, notifying that a translation of the *Irish Fingal* would soon make its appearance, and requesting the Public, to suspend the purchase of the Scotch translation, as being full of errors, &c. A blunder was sure to be inserted, to make the thing more probable, and go down the better;



---

p.85



for what more natural, than for Irish sagacity to spy out the errors of a work it had not seen?


But, from all the inquiries I have made, I never could learn that such translation was ever meditated. **Colonel Vallancey**, who knows every *Irish scholar* in this kingdom, tells me, he never heard of any such work being in agitation. He says, Ossian's poems are all short ballads, not yet collected, to his knowledge, by any one. So you may guess the quarter from whence the blundering advertisement originated.


Yet it has been reported, and by great names too, that the first four books of Fingal were to be seen in the Isle of Sky, written in a fair hand on vellum, and bearing date in the year 1403. But this report proves ill authenticated. **Dr. Johnson** made the most diligent researches in the Isle of Sky, and elsewhere, for these supposed manuscripts; but the result of all inquiries issued in this conclusion, that there not only were no such manuscripts in existence, but that it was impossible there should be any such: for that the Erse had



---

p.86



never been a written language, till within a century.


In short, the forgery committed in the publications of Fingal and Temora, is so clearly detected by the sagacious and learned author of the Journey to the Western Isles, that to oppose the evidence of such fictitious works, to that of established history, would be to persist in a most audacious insult upon the understandings of mankind. There are, we know, original poems ascribed to Ossian. Mr. M——n may have taken their images and sentiments, may have adopted their manner and spirit, but he has so changed the matter and order of the narration, by putting in, and leaving out, and other metamorphosing methods, that his work may be called any thing rather than a translation.


That this is the very method, which Mr. M——n has pursued, he in some measure acknowledges; for when he recommends it to the Irish to give a translation of their Ossian's poems, ‘he hopes that the translator will chuse to leave something in the obscurity of the original.’ Now it is to



---

p.87



be presumed, that he has too much candor to offer that advice to another, which he would not himself follow.


It is curious enough to see so learned a man as **Lord Kaims**, a man too, who in other respects seems divested of prejudice, such an advocate for the authenticity of the poems of Ossian in English. But I cannot think this agreeable writer in earnest. For while he tortures his ingenuity to give them a plausibility, which contradicts all his own systematic principles, he seems almost willing to compound for them as a forgery. But the glory of the antient Caledonians is at any rate to be supported; therefore, rather than it should sink, he is even for recurring to miracle. And upon this ground, he seems ultimately to rest his cause; a ground, which I thought he never would have chosen.


The refinement of sentiment in Ossian's characters, is so subversive of all that he had been for establishing, that he is utterly at a loss to account for it. ‘Had the Caledonians,’ says he, ‘made slaves of the women, and thought as meanly of them as savages commonly do, it could never have



---

p.88



entered the imagination of Ossian to ascribe to them those numberless traces that exalt the female sex, and render many of them objects of pure and elevated affection. Without the *aid of inspiration,* such refined manners could never have been conceived by a savage.’


Now is it not a fact of notoriety, that at this very day, the Highland women are employed in the most servile offices, even in carrying out manure like beads of burden? Yet, our truly curious fact collector, after some strictures on Ruffian manners, triumphantly asks, ‘can one suppose that the *ladies* and *gentlemen* of Ossian's poems, ever amused themselves after the age of twelve, with hide and seek, questions and commands, or such like childish play.’


Is not this to furnish laughter with a sneer at Highland manners? Does not **Lord Kaims**, *arguing for the aid of inspiration,* virtually betray that system he would support? Let those celebrated epics then be at best considered, but as ingenious Centos culled from Irish Bards; garbled and transposed, curtailed and interpolated, they are certainly not originals, and consequently



---

p.89



they are not Ossian's. Perhaps they are better. If so, let **Scotland** glory in them; but, detected as they are by **Dr. Johnson**, betrayed by **Lord Kaims**, and self-condemned throughout, they must remain only a monument of the ingenuity of the Editor.

> 1. Ossian sublimest, simplest bard of all,
>   
> Let English infidels McPherson call.
> 




  
Kildare


It is an opinion pretty general, on our side the water, that the Irish had not any buildings of stone and mortar, before they were raised by the English; but I will enclose you the sketch of one, above 130 feet high, which was certainly built antecedent to that period; for **Gyraldus Cambrensis**, secretary to Henry II. and afterwards bishop of St. David's, describes those round towers, among the wonderful things of Ireland, and calls them *turres ecclesiasticas, quae more patrio arctae sunt necnon & rotundae.’’*






---

p.90


This writer was by no means partial in favour of the Irish nation; when therefore he says, that those towers were built *after the fashion of the country,* we cannot agree with those who suppose them to have been erected by the Danes. There are no such structures now in **Denmark**, nor in any other part of Europe, that I hear of, except in **Scotland**; where there are two of a small size, one at **Abernethy** in **Perthshire**, the other at **Brechin** in **Angus**. Which, by the bye, among other circumstances, tends to decide the descent of the Scots from Ireland, for we may easily conceive, that those Scottish towers were built by the posterity of the Irish, who went over with Fergus, in the manner of those of their own country, where they are so numerous.


The learned, however, are not agreed about the particular use, to which these edifices were applied. Some say they were places of penance; others, that they were belfries, the very name of them in Irish Cloghahd importing a steeple with a bell; but the prevailing opinion now seems to be, that they were anchorite pillars, such as Simon Stylites used to sanctify himself upon.


---

p.unnumbered




---

p.unnumbered




---

p.91



upon. They tell you, that in order to preserve the appearance of piety in the Abbey, and augment the fame of the monks, one of them, most celebrated for his austerity, used to watch and pray, in an extraordinary manner; thus removed from the earth, and its low cares, and, as it were, holding nearer converse with the Deity.


I shall not presume to decide upon a question of such *moment;* yet I cannot help inclining to the second opinion, not only from the name given them by the indigenal natives, but from the following considerations: Over great part of the east, they have tall round steeples, called *minarets,* with balconies at top, whence a person calls the people to public worship at stated hours. As the Irish had their arts from **Phoenicia**, we may fairly suppose, that from thence also came the model of these towers, which served as the minarets of the east do at present, till bells came into use; for narrow as they are, (about ten feet in the clear, at the base) they might hold a bell large enough to summon the auditory, as effectually as the shouts of a man.




---

p.92


Not far from the tower, they shew the ruins of a convent, of the nuns of St. Brigid; who, according to **Gyraldus**, makes Kildare illustrious by her unextinguishable fires, the ashes of which have never increased. The very oak under which she delighted to pray, has given a name to the place. Brigid, you must know, was the Virgin Saint of the land, and, after the Blessed Virgin and St. Patrick, held in the highest adoration by the Irish catholics. She was worshipped like Vesta, with unextinguished fires, kept burning by the nuns in their convent; which was therefore called the fire-house.

> 1. Ignis inexctincti Dariae, quis crescere novit
>   
> Ævis tot lapsis, Brigida virgo, cinis?
> 




The ladies of Ireland are too wise to imitate this patroness of virginity in making the vow; celibacy being, perhaps, more uncommon here than in any other country. Yet, the chastity of the women, and the bravery of the men, are traits of the national character, on which these people, not without justice, pique themselves.




---

p.93


Among the higher ranks, the indiscretions of the fair sex are, probably, as uncommon as any where else, and certainly more so than in many other places. In a circle so small, that not to know every body is to be unknown, trespasses in this way can never escape observation, and therefore ceasure must be armed with double terrors.


But whatever strictness guards decorum in the polite world, they tell you that infamy does not long attend female frailty, in the lower walk of life. There a young woman may make the young squire a father, and marry her sweet-heart the very next year, who values his bride the more, as such a connection is supposed to enhance her dowry.


As it is doubted whether courage is natural or artificial, so it has been disputed, whether chastity originates from constitution or education. But is there not a firmness of nerves? Is there not a happy temperament? Poeta nascitur non fit, is not a true proposition, but it is more true than poeta fit non nascitur. Away then with the mighty examples from **Hawkesworth**'s Voyages, which have been adduced to shew, that chastity is not an instinctive virtue.




---

p.94


Let it not be argued that the ages of chivalry and romance over-rated female virtue, and that the present age, of polish and refinement, is bringing it back to its original value: nor let it be prophesied, that in this untainted isle, the morality of some future age will, like the religion of the present, unkalendar St. Brigid.


Adieu.

  
**Kilkenny**, 


August 30, 1775.
My last was from a little town which had its name from St. Brigid's cell of the Oak; this is written from the best inland town in the kingdom, denominated from the cell of St. Kenny. It is sweetly situated on the river **Newre**, covering two little hills; on one of which stands the cathedral, and on the other the old castle of the Ormond family. Near the cathedral is one of those round towers, I gave you a sketch of from **Kildare**. There are, besides, three towers of ruinous abbies, which still rear their heads aloft, and give a figure of some consequence to the town.




---

p.95


But before I make you better acquainted with **Kilkenny**, let me give you some account of the way to it. From Kildare to Castle-Dermot the country is in general pleasant, and in some places adorned with plantations. Castle-Dermot is a very poor town ~~for a borough~~, not even a ruin remaining of that castle whence it was called. That it was once a place of some note, is however evident from the remains of religious houses. One of its monasteries has been magnificent; two of the ailes, with one of its windows, still preserve the outlines of grandeur and elegance. The town was sacked and plundered by Bruce in 1316, yet a parliament was held there in 1377.


On this side Castle-Dermot the country grows less pleasant, and the road being one extended right line for several miles, becomes more fatiguing to the rider than to the horse. There, for the first time, I saw their sewel, with us called *peat,* but with them *turf;* piled up in prismatical heaps, like the mortars at Woolwich, upon the margin of those pits, from whence they are dug. They are cut by an instrument called



---

p.96



a *slane,* which is nothing more than a spade of about four inches broad, with a steel blade of the same breadth, standing at right angles to the edge of the spade. So that each turf is a parallelepiped, of about ten inches by a square of four. From this instrument, Mr. Read, an ingenious cutler of **Dublin**, has borrowed the form of a knife, for delving into cheese, which they also call a slane.


As you approach Carlow, the scene alters; the country seeming to be entirely occupied by gentlemen's parks, walled in, and recently planted; which will appear most delightful when the trees are full grown. The town itself is pleasantly situated on the Barrow, and makes a very cheerful appearance, from the number of white houses scattered up and down; nor are you at all disappointed when you enter it, there being a cleanness and neatness in the streets, I had not hitherto seen on this road. There was a good flesh-market, and every thing wore the appearance of a good English village. Such are the happy effects of a little trade! For here they have a manufacture of the coarsest kind of woollen cloths, and are concerned 



---

p.97



in supplying the neighbourhood with coals from **Kilkenny**. They have a horse-barrack; and on an eminence, overhanging the river, stands an old castle, of an oblong square area, with large round towers at each angle; which has a fine effect.


Up the river from **Carlow**, the landskip is highly picturesque; and downward, for eight miles along its banks, to Leighlin-Bridge, the ride is delightful. At a due distance, the grounds swell gradually into mountains, which, from their feet to their midsides, are covered with woods; and, to enliven the prospect, the interjacent tract is interspersed with several little white villas, neatly planted around. From **Leighlin-Bridge** hither, the country is naturally cheerful; but let me reconduct you to **Kilkenny**, in **Spencer**'s poetic barge, down the **Newre**, one of those three renowned brethren,

> 1. Which, that great giant, Blomius, begot
>   
> Of the fair nymph Rheusa, wandring there,
>   
> One day, as she, to shun the season hot,
>   
> Under Slew-Bloome, in shady grove was got;
>   
> This giant found her, and by force deflower'd;
>   
> Whereof conceiving, she in time brought forth
>   
> These three fair sons, which being thenceforth pour'd.
>   
> In three great rivers ran, and many countries scour'd.
> 
> 
> ---
> 
> p.98
> 
> 
> The first the gentle **Shure**, that making way,
>   
> By sweet **Clonmel** adorns rich **Waterford**;
>   
> The next, the stubborn ***Newre**,* whose waters grey,
>   
> By fair ***Kilkenny**,* and Ross-ponte board,
>   
> The third the goodly **Barrow.** ——
> 




There are but two churches in this large town, or rather city, consisting of between two and three thousand houses; but there are several mass-houses, each of which has congregations, vastly more numerous than both the churches. The cathedral is a Gothic edifice, so venerable, that whoever sees it must lament, that a spire, at least, had not been added to the stumpy steeple. From the Bishop's palace to the church, is a long and double colonnade, in the modern style. The nave is divided from the ailes, by massy columns of black marble, crusted over with a dirty lime white-wash. It is, however, a consolation, that the scaffolding is now rearing for the purpose of embellishing this ancient pile.


In the ailes are several ancient monuments of armed knights, and mitred bishops, some in horizontal, and some in praying postures, and one modern monument of white marble,



---

p.99



finely executed; the device is Piety, with a book in her hand, leaning in a mournful posture over an urn. These, altogether, would have given a due solemnity to the place, were it not that its slovenly condition rather inspired a painful melancholy;


The hill on which the cathedral stands, is called the Irish Town, as that whereon the castle is, goes by the name of the English Town, and each of them send two members to parliament. The former is mostly composed of sorry houses, and poor huts; the latter is generally well built. The castle was founded by Randolph III. earl of Chester, but built, as it now stands, by the Butlers, ancestors of the dukes of Ormond. In the English town is the church of St. Mary, no contemptible structure, with several old monumental decorations; there also are the town-hall, jail, and market-house.


I mentioned to you the towers of three monasteries, these are St. John's, St. Francis's, and the Black Abbey. St. John's has great elegance, and amazing lightness in the



---

p.100



style of the building. The Abbey-church of **Bath** is, I think, called the lanthorn of **England**; but this is more windowed still; for about fifty-four feet of the south side of the choir yet entire, the whole seems to be one window. I send you a sketch of it. The east window is sixteen feet wide, and about forty high, as I guess. Belonging to this Abbey are the remains of several old monuments, almost buried in the ruins.


St. Francis's has little remaining except the tower. But the Black Abbey is a magnificent remain; the windows are exquisitely curious; not unlike many you have seen; the architraves in the outside cornice under the parapet, are very expressive of their origin. Of this spacious ruin, two of the steeples are almost entire.


One of the old churches is converted into a mass-house, as the courts of two of the abbies are changed into barracks; St. Francis's for horse, and St. John's for foot. How different are the establishments of different potentates, at different periods! The Pope's barracks in Ireland were once filled with old fellows, with shaven crowns, 


---

p.unnumbered




---

p.101



and without shirts, but clothed in long sweaty gowns, of black, and white, and grey. The king now fills his convents with young fellows, wearing long hair, linen shirts, and scarlet jackets lined with all the colours of the rainbow.


The castle, whose magnificence was heightened by the sublimity of its situation, has been gradually falling into decay, since the attainder of the late duke of Ormond. It was in his time a spacious square, two sides of which only are now standing: one they are rebuilding, and the other two they are putting into repair; but in a taste too modern for a building of such antiquity, and too frippery for one of such magnitude.


In a gallery of 150 feet in length, but very disproportioned in breadth, they shew you several old portraits; among these, in full length, are the whole Stuart race who reigned in **England** from Charles I. inclusive, together with William III. who is said to have dined here, on his march to the siege of **Limerick**, soon after the battle of the **Boyne**. But the most remarkable piece is a three quarter length of **earl Strafford**, 



---

p.102



said to be taken but a few days before his catastrophe; to which is contrasted, the picture of the same person, taken in the full career of his ambition. The different situations of life are strongly marked in the countenance of each.


In the room called the Presence Chamber, or at least in that next it, for I already forget, are the four elements in tapestry, finely executed, and in high preservation; the gloss of newness seems fresh upon them. In another apartment is a suit of hangings, representing the story of Decius, in the attitudes of taking leave of his friends, receiving the high priest's benediction, &c. &c. and at length devoting himself. These tapestries, though not so glowing in their colours as the seasons, are nevertheless admirable in other respects. Pity that they should be exhibited to so little advantage! They are hung up in a room, the shape of which is so inordinate, that I question whether any two sides of it are parallel, and it is illuminated diagonally from a window, in a segment of one of the round flankers. One of the largest pieces is folded 



---

p.103



round the mixed angle at the window, so that the part of it on the concave surface has a glaring light, while that on the plain is almost in darkness. This room affords too many beautiful views of nature from without, to require the sacrifice of so much art within.


The servant, who shewed the house, told me the situation was very like that of Windsor. I cannot say the likeness would have struck me, though there is at both places a town, a castle, and a river. However, let not Windsor fastidiously disdain the comparison. For though the country round **Kilkenny** is not improved like that round the most princely of the royal palaces, yet the site of this castle is at once bold and beautiful, with almost every advantage that could be wished to decorate the scene.


It stands upon a precipice, overhanging the bend of a deep and rapid river, with two stately bridges full in view: the more distant, and up the stream, is composed of seven arches, that next the castle has but three; but of a very wide span, of hewn



---

p.104



marble, in fine elliptical proportions. The sides of the river are well planted, and the subjacent town looks as if it had been built merely to be looked at; for every thing in it worth seeing, bears upon the castle, whilst every thing dissightly is, somehow or other, screened from the view. The horizon is closed, in one limb, by mountains, placed at a due distance, to give variety without horror; and if any thing is wanting to render the prospect inchanting, it is that the middle distances are destitute of that richness of cultivation, and that embellishment of country-seats, which is the capital beauty of Windsor. But **Kilkenny** is far more picturesque.


Windsor castle looked at, is august and venerable, but when you look from it, there is nothing to inspire those ideas. Not Eton's spires, not Cooper's classic hill, not Cliveden's gay alcove, nor Glo'ster's gayer lodge, can furnish such a lavish variety to the landskip-painter, as these Hibernian scenes. There Nature has painted with her most correct pencil, here she has dashed with a more careless hand. This is the fanciful



---

p.105



and fiery sketch of a great master, that the touched and finished work of a studious composer. Without either mountain or sea, no landskip can, in my conception, be perfect; it wants the grand attribute of sublimity. Windsor Forest was a theme exactly level to the tame genius of Mr. Pope, whose lines are not more harmonious than the subject; but it was such a rude original as this, which ravished Milton into that brilliant description.

> 1. Straight mine eyes hath caught new pleasures,
>   
> Whilst the landskip round it measures,
>   
> Russet lawns, and fallows grey,
>   
> Where the nibling flocks do stray;
>   
> Mountains, on whose barren breast,
>   
> The labouring clouds do rest;
>   
> Meadows trim with daisies pied,
>   
> Shallow brooks, and rivers wide:
>   
> Towers and battlements it sees,
>   
> Bosom'd high in tufted trees.
>   
> Towers and battlements it fees,
>   
> Bosom'd high in tufted trees.
> 






---

p.106


  
**Kilkenny**.


Having heard a great deal of the cave of Dunmore, I went this morning to see it. Even beauties too highly extolled, before you see them, seldom answer your expectations. I will not, however, rank this among beautiful objects, for to me it had nothing to recommend it. After riding some miles over a very rough road, they shewed me a knoll, or swelling ground, in a green field, which they said was the cave's mouth, but I could see no cavity, till I came to the very lip.


The aperture was lined with a few stunted shrubs, intertwined with ivy. The descent was apparently easy, but after I got fairly in, it became very difficult, from the damp and slippery footing; I therefore soon made my way back again, and took my turn of holding the horses, that my servant might gratify his curiosity. He stayed a great while in it, and, when he came up, lamented that I had not gone farther, and begged of me to go down again. If there



---

p.107



are any sparry incrustations there, it ought to have been viewed by candle-light. But I cannot conceive that the exhibition would reward the trouble.


Do not however imagine I lost my day with this bawble, for in my way I passed through the fine old park of Dunmore, and farther on, I saw the coal mines, which are well worth seeing. The pits are principally at **Castle-comber**, the estate of lord Wandesford, who is said to clear 10,000l. a year by them. If the grand canal were finished to the Barrow, he would then probably make much more, for that would open a communication with **Dublin**. But hills interpose, which must be pierced through for that purpose.


One would, however, think that even a canal could not much lower their price, considering the following extraordinary fact. The carriers pay 5d. per hundred weight, and sell them for 1s. 8d. in **Dublin**, which is above 80 English miles from the pits. Each car draws but seven hundred weight, which with 9d. for turnpike, makes the load cost 3s. 8d. and it sells for 11s. 8d. So that for six days travelling charges of a



---

p.108



man and horse, there is but 8s. to say nothing of the labour of both, and the wear and tear of the car. They are said to be laid down in the most remote parts of the kingdom, at a price so low, that it puzzles calculation to make out how the wretched carriers can subsist.


These coals are universally prized for drying malt with; because they emit no smoke. A fire made of them yields a very intense heat; it does not blaze but glow, looking like lumps of red hot iron; the vapour is very dangerous, except in a room well ventilated. The other elements have, it is said, their peculiarities at **Kilkenny**; but these are not so well founded upon truth. It is true that their streets are paved with marble, for I believe they have no other stone. Their marble is black, variegated with white, and takes a very high polish. It is much used for chimney pieces all over the kingdom. The only manufactory here is for coarse cloths and fine blankets.


**Kilkenny** values itself upon its superior gentility and urbanity. It is much frequented by the neighbouring gentry as a



---

p.109



country residence, has a stand of nine sedan chairs, and is not without the appearance of an agreeable place. I went last night to their weekly assembly, and was soon given to understand, by one of my partners, that **Kilkenny** has always been esteemed the most polite and well-bred part of the kingdom.


Knowing so little of this country, I am not furnished with any arguments from either reason or authority, to dispute this pretension. My partner was so beautiful a woman, and so striking an example of the doctrine she taught, that she led me away an easy captive to her opinion . For which I can see the justest grounds. This was the seat of the old Ormond family, here the last duke kept a court, as several of his predecessors had done, in a style much more magnificent than any of the modern viceroys. The people imbibed the court manners, and manners remain long after their causes are removed.


At present, the inheritor of the castle and some of the appendant manors, a Roman catholic gentleman, affects the state of his ancestors; his wife receives company as, 



---

p.110



I am told, the old Ormond ladies used to do; she never returns visits; and people seem disposed to yield her this pre-eminence.


The cook belonging to this inn, the Sheaf of Wheat, wears ruffles; and though an old man, is as full of vivacity as politeness. He brings me every day, after dinner, some delicious pears, and says he keeps a few for the quality who resort to the house; and that he has done so for thirty years.


I am not singular in remarking that the peasants of this country are a most comely breed of men. They are generally middle sized, and have almost universally dark brown hair, and eyes of the same colour. Their complexions are clear, their countenances grave, and their faces of that oval character, which the Italian painters so much admire.


Adieu.




---

p.111


  
**Kilkenny**.


The endowed school here is called a college; and certainly no seat of learning could wish for a situation more cheerful, or more healthful. Such stagnating floods as we have seen round Magdalen-walks, Merton-fields, and Christ-church meadows, could never annoy this charming spot. The city itself would be something like Oxford, if we could suppose Oxford dilapidated of its towers and pinnacles.


Many people in **Dublin** expressed to me an earnest desire, that **Kilkenny** should be made the seat of a learned society; hoping by that means to prevent so many from going to **Scotland**, in quest of education. Others again hinted, that if **Armagh** in the north was to divide with **Kilkenny** in the south, the emoluments of Trinity-College **Dublin**, it would be more conducive to the interests of literature and virtue.




---

p.112


Discipline is, at present, attended to with the utmost exactness, and every possible care taken to enforce obedience to the statutes. Greater strictness is certainly observed than with us at Oxford. The gates are regularly attended, and no student can be in the city, without the knowledge of the porters. Defaulters undergo pecuniary mulcts, at the discretion of the Dean and a board of Fellows. Nevertheless, frequent and enormous outrages are committed. One of the gownsmen was lately killed in a riot with the watchmen; yet it is believed, that, in general, the poor watchmen are *more sinned against than sinning.*


The Lord Mayor's jurisdiction extends to the college; and it has been exercised, but not without tumult and disorder. From this principle, a perpetual feud is kept up with the inferior officers of magistracy, those obnoxious restrainers of natural liberty.


But there is a political evil in the constitution of this corporate body, which brings on a periodical fever, the crisis of which is generally violent. You already



---

p.113



see, I mean the election of representatives. This never fails to breed abundance of ill blood, convulsing the whole system, and dissolving every principle of health within.


Nor is its malignant influence confined to the college walls. It not only sets the tutor against the pupil, and the pupil against the tutor, but it sets the father against the son, and the son against the father: and, what is still worse, it places self-advantage against general interest; at once overturning what **Cicero** and Cumberland are for establishing in the halls.


Old age is but too prone to adopt the sordid maxims of worldly wisdom; but this, alas! prematurely wrinkles the mind, and brings early decrepitude on private virtue and public spirit. But let every influence be far and for ever removed from our schools, which, instead of expanding the affections to the sphere of human happiness, contract them to the narrow focus of self-interest: which should always be considered, but as a particle, in the mass of universal good.


Unhappily for this society, the power of returning members is lodged, principally in the hands of boys; for of ninety electors, 



---

p.114



seventy are scholars, one half of whom are probably not of age. From the Provost's prerogative of *nomination,* which I have already explained to you; it is evident that he can, in seven years, as with a plastic hand, mould this society into the arbitrary form of his wishes; for in that period, between seventy and eighty of the whole may be of his own creation.


A new Provost indeed coming in, at the eve of an election, may find many refractory, and some rebellious subjects in his dominions. He should not therefore endeavour, all at once, to drive them into allegiance; he should only gradually lead them into compliance. And he has, in the plenitude of his power, such a magazine of resources, as cannot fail to operate powerfully on the majority.


If universities must have representatives in parliament, it would be well for that of **Dublin**, if its Fellows only had been vested with the privilege of freeholders, and that the Provost had here, as in other cases, the power of nomination; for reasons, obvious from what I have already said.




---

p.115


Scarce a week passes without the appearance of some satirical production, either in prose or verse, pointed at the highest in station, and the most eminent for abilities of the whole body. No less than two volumes of these have been already collected, under the title of Pranceriana; which, however they may discover great talents for wit and humour, in the young gentlemen who wrote them, sufficiently evince the unfortunate political system of this learned republic.


Adieu.




---

p.116


  
**Cashel**,


September 8th, 1775.
On leaving **Kilkenny**, I was in doubt whether I should make my route by **Waterford**; it being a very thriving city, with the finest Quay in Ireland. But, the season being so far advanced, **Cork**, **Limerick**, and **Galway**, must suffice for the great cities. From them I hope to acquire some idea of the state of trade; and, by making this zigzag through the midland region, I shall have a better opportunity of noting indigenal manners, and the unmixed influence of the pastoral life.


I breakfasted at **Callen**, which withstood **Cromwell**'s united forces for some days in 1649, now a poor dirty town, interspersed with the numerous ruins of old castles and religious houses. The prevalence of interest, in this paltry borough, has been long contested both in the courts of law, and in the fields of honour. They cross the seas to dispatch each other, by the pistol or the sword. The feud is become hereditary,



---

p.117



and not likely to be extinguished by the death of one of the principals.


Duelling, it is argued, may in some cases be considered as a necessary evil; but if its tendency be to refine manners, the frequency of it, in this kingdom, is a certain sign of imperfect civilization. The contagion of it infects all ranks.


The first place I stopped at in the province of **Munster**, was a little village called **Killynaul**; where the country assumed a very different appearance from what I had before observed. The inauspicious operation of pasturage became, however, visible before I left **Leinster**. For ten or twelve miles on this side of **Kilkenny**, the soil was far from rich, it was rather indeed poor; yet it was pretty well cultivated, the fields were enclosed with hedges and ditches, and the country embellished with houses and plantations. But, as the ground improves, on approaching the borders of **Munster**, agriculture ceases, and not a house, not a hedge, not a ditch is to be seen. The country is abdicated by the human species, and peopled with sheep.




---

p.117


Nor was the change less evident in the manners of the people. There was nothing in them, however, that could remind you of the golden age; no resemblance of that simplicity attributed by poets to the shepherd state; nothing like that surly awkwardness of our English clowns, who have one general answer, *I dont know,* to almost every question a stranger asks. These peasants have no sheepishness about them, are under no embarrassment when you speak to them, seem never at a loss, but are blessed with an abrupt and sudden promptitude of reply.


It may not, perhaps, be difficult to account for this obvious contrast. Our peasantry, intent upon their own proper affairs, are not at the expence of thinking upon other subjects; whereas these poor men, having neither labour nor trade to engage their attention, are more occupied with other people's affairs than their own; excussi propriis aliena negotia curant.[6](javascript:footNote('E770001-002/note006.html'))


In ridicule of their passion for news, my companion **Spencer** tells the following story, ‘A Frenchman, who having been



---

p.118



sometime in Ireland, and there marked their great enquiry for news, and meeting afterwards in **France** an Irishman, whom he knew in Ireland, first saluted him, and afterwards said merrily, O, Sir, pray you tell me of courtesy, have you heard any thing of the news, that you so much inquired for in your country?’


It is not necessary to assign so many causes, for this vain curiosity, as **Spencer** does; for idleness comprizes them all. Wherever a people have but little employment, and have, at the same time, quick and lively imaginations, they will of course be garrulous and inquisitive. The very same property, we find St. Paul ascribing to the Athenians, ‘who, spent their time in nothing else, but either to tell or hear something new.’


My host was very courteous, for on my declining to go into his house, the exterior of which was not very inviting, and on telling him that I only meant to feed my horses; he replied with an air of frankness and civility: ‘Ah! by my shoul, you're welcome to the best room in my house,



---

p.119



suppose you neither eat nor drink.’ I then stepped in, and he became not less communicative than he was inquisitive. He supposed that I was a lawyer, and that I came from **Dublin**; and seemed astonished that I knew so little of the country, and that I never had been there before.


Upon my supposing, in my turn, that the clear fire before me was of Kilkenny coal, his answer was somewhat indignant, yet fraught with information. ‘Arrah no! my dear jewel, for by Shasus we have as good coal as **Kilkenny** ourselves, ay and better too. The devil an inch you rode today but upon coal pits. Sure it is we that serve all **Munster** with coals, and **Connaught** too. Did not the Dutch Boors offer to their countryman, king William, that, if he would let them live by the laws of Holland, that they would make meadow ground of the whole bog of Allen, and carry the coals of **Killinaul**, through their canals, all over Ireland, ay and **England** too. For you see, that our coal is the hottest coal in the universe, and the only coal for drying malt with, because it has no



---

p.121



 
smoke, and therefore gives the beer neither taste nor smell.’


He then touched upon the affair of the White-boys, to whom he was no friend. He said they had been in that town the very night before. You have heard of these **banditti**. I am not yet in possession of the true state of their case. For it is so variously represented in this country, that one must listen with attention, and assent with caution. But the whole country round **Killinaul** bears upon the very face of it, an evident and sufficient cause for their insurgency; if insurgency it may be called, where each housekeeper disclaims all connection with the wretches concerned.


Cashel is a good town, but a poor city; it consists, as I guess, of between five and six hundred houses, some of which are very decent, and look as if inhabited by persons of condition. It must have been formerly a place of the first consequence in Ireland, for here Henry II. held a synod.


There is somewhat still venerable in the ruins of the churches and monasteries in



---

p.122



this ancient city. *Quocunque ingredimur in aliquam historiam vestigium ponimus.’’*

Cicero, De Finibus 5,5: quacumque enim ingredimur, in aliqua historia vestigium ponimus [retrieved from http://www.thelatinlibrary.com/cicero/fin5.shtml ].

 The sight of the cathedral alone is a full compensation for the loss I may have sustained in passing by **Waterford**. It is at once the largest and most ancient in the kingdom. I took a perspective of it this morning, from a room in the Archbishop's house. It is, as you see, built upon a rock, and the whole is usually called the *Rock of Cashel.*


The dimension of the nave and choir, from east to west, is about 200 feet, as I computed by stepping through nettles, and over-tumbling fragments of stone and mortar. The steeple is in the centre of the cross; near the east angle of the north ile is a round tower, to which leads a subterraneous passage from the church. Tradition says it is the oldest structure upon the rock, which seems more than probable from a trifling circumstance; all the buildings upon the rock, which is limestone or marble, are built of the same material, except the tower, which is of freestone. It may, therefore, be at least presumed, that the practice of quarrying was not then very common.




---

p.123


**Sir James Ware** says, this cathedral was built, about the time of the arrival of the English under Henry II.; but a learned clergyman, whom I met in **Dublin**, assures me, that in this the knight was mistaken; for it appears from an inquisition made in the second  of Henry IV. that the donation of certain lands, by the founder Donald O'Brien, was confirmed by letters patent of king John. Now Donald was brother to Morough More, king of **Munster**, A. D. 1086, and this authentic record is to be seen Rot. Pat. ii. T. i. 3 pt. D.


Cormac's chapel, which you may observe in the angle, on the south of the choir, is near two centuries older than the church for Cormac was king of **Munster** A. D. 901: This chapel, fifty feet by eighteen in the clear, is a very curious structure, and of a style totally different from the church. Both on the outside and inside, are columns over columns, better proportioned than one could expect, from either the place or the time. The cieling is vaulted, and the outside of the roof is corbeled so as to form a pediment pitch. At the angles of the east end



---

p.124



are two small towers, one of which you may distinguish in my sketch.


It may not be unworthy observation, that the chapel is not parallel to the church, as it tends to confirm the greater antiquity of the chapel; for had the church been the older building, it is probable they would have accommodated the chapel to it, though, on the contrary, they would not have adapted the church to the chapel. As the first builders of churches were religiously exact in placing them due east and west, the deviation of the chapel from the true line, we may presume, was corrected in the church.


If we could be certain that due attention was given to the meridian, at founding each of these structures, then the want of parallelism[7](javascript:footNote('E770001-002/note007.html')) in them would become a datum for ascertaining the difference of their



---

p.125



 
dates. For we know that the equinoxes move in antecedentia, one degree in seventy-two years; therefore, by turning the angle, which these two buildings make with each other, into years, we have the interval between their respective foundations.


If this angle, the measurement of which I leave to some future traveller, be three degrees, it would answer nearly to the supposed difference. But the angle was apparently much greater; say nine degrees, and then it will bring the foundation of the chapel, to the middle of the fifth century. And it is more than probable that it was erected by Cormac, upon the very foundation of that church, originally built here by St. Patrick.


That there was an edifice of lime and stone here in the fifth century, Colonel Vallancey shews to be highly credible; for the name of the place is mentioned in the acts of the life of St. Patrick, and that name, *Cas-iol*, signifies literally a house of lime and stone. As this was the seat of the kings of **Munster**, we may naturally suppose, that the castle upon the rock was their residence, before the introduction of



---

p.126



Christianity, as it continued to be after, Cormac was not only king, but Archbishop. Rex Anius, rex idem hominum Phoebique sacerdos.


Having now given you, Doctor, a full dose of *learned* disquisition, I shall conclude this epistle, with the quaint epitaph of an Archbishop of Cashel, who was a great favourite of queen Elizabeth. Bedrid for two years before his death, which happened in his hundredth year, he had the inscription deeply cut on a plate over his monument; which is placed on a high basis in the south side of the choir, with his effigy in *alto relievo*.



> Mileri Magrath Archiepiscopi Casheliensis ad viatorem carmen.1. Venerat in Dunum primo sanctissimus olim
>   
> Patricius, nostri gloria magna soli.
>   
> Huic ego succedens, utinam tam sanctus ut ille.
>   
> Sic Duni primo tempore praesul eram.
>   
> Anglia, lustra decem, sed post, tua sceptra colebam,
>   
> Principibus placui, marte tonante, tuis.
>   
> Hic, ubi sum positus, non sum, sum ubi non sum;
>   
> Sum nec in ambobus, sum sed utroque loco.
>   
> Dominus est qui me judicat.
>   
> Qui stat caveat ne cadat.
> 






---

p.127


  
Cashel.


As the Rock of Cashel overlooks the town, and at the same time a great extent of country, the most fertile in the kingdom, it is no wonder that it was chosen for the residence of the kings of **Munster**. It has, however, lost its rank of importance among the cities, for want of a navigable river. This would have more availed it at present, than that it was once the throne of kings.


Such a tract of country as is seen from the Rock, if in **England**, or even under the hands of common industry, would be as beautifully rich as any in the British empire. From thence you have an extended horizon, except where the **Gaultees** interpose; and this long chain of lofty hills gives a most picturesque contour in many places. The interjacent grounds, fertile as avidity itself could wish, are not a dead level, but gently diversified by lively undulations.




---

p.128


After all, the prospect is far from being pleasant. It requires an abstraction of adventitious circumstances to perceive its natural beauty: with a total neglect of cultivation, there is scarce a tree to be seen. The country is intersected with walls of dry stone, and ditches that never have been quicked. The squire's country seat, the rich farm house, or even the warm cottage, are here looked for, but looked for in vain. If there be an habitation, it is that of the face-ground shepherd, whose sordid hovel serves but to call a deeper shade upon the gloom of depopulation. Your philanthropy would sicken at the forlorn state of this goodly tract.


In the town is a large and comfortable See-house, built within half a century. The old episcopal seat was the building you may see, on the west end of the cathedral. But this was battered in the rebellion of 1641, by Lord Inchiquin, who put all the priests to death he found in it, as they were the principal part of the garrison, which defended the fortress.


The present Archbishop has a house upon his own estate, where he lives. You



---

p.129



will be surprised when I tell you that there is not even a roofed church in this metropolis; the service being performed in a sorry room, where country courts are held. The choir of the cathedral was kept in repair, and used as a parish church, till within thirty years; but the situation not being accessible enough, — which, however, 20l. would have rendered so;— the roof was wantonly pulled down, an act of parliament and a grant of money being first obtained, to change the site of the cathedral, from the rock to the town. A new church of ninety feet by forty-five, was accordingly begun, and raised as high as the wall plates. But in that state it has stood for near twenty years.


You would be amazed, considering how thinly the country is inhabited, at the number of Romanists I saw on Sunday assembled together. Round the altar were several pictures, which, being at the distance of a very long nave of an old monastery, I went round to the door of one of the transepts, in order to see them more distinctly. The people made way for me, and some of them offered to conduce me to where the 



---

p.130


*quality* sat; but this I declined. While I stood at the door, a woman came up, and asked for some holy water, of a man who stood at the font; he reached her some in the hollow of his hand, and with the remainder he besprinkled me. He took me, I suppose, for an heretic, and therefore was sure I stood in need of lustration. I thought it, however, time to go, lest my not joining in the ceremonies might look particular.


The priest was very decently habited, in vestments of party-coloured silk, with a large cross embroidered, on the outside a garment, which hung down behind. He muttered the service, and frequently turned round to the altar and kissed it, after having first bowed to it. On the altar burned two candles; just emblem of their superstition! The dim light of tapers held forth in the blaze of day! Yet, even here, it is possible, that God may be worshipped in spirit and in truth; for ‘he dwelleth not in temples made by hands, as if he needed any thing.’[8](javascript:footNote('E770001-002/note008.html'))


This argues not, however, that true religion should let her temples fall into ruin



---

p.131



and decay. Much, very much, depends upon a decent exterior. What else has the church of Rome to support herself upon? Even that beggarly display of outward elements, exhibited in this old abbey of Cashel, has somewhat to engage the imagination, and even to mend the heart.


It is true, that telling of beads, saying Ave marias, crossing of the breast and forehead, being sprinkled with salt and water, and abstaining from flesh and labour, upon certain days, are as indefensible on the spiritual principles of the Gospel, as on the ground of philosophy. But I ask, where is the majority of any denomination of Christians, that can distinguish the letter from the spirit of the gospel? What multitude is philosophical? What vulgar is rational? The bulk of all persuasions believe they know not what, and practise they know not why.


One of the causes, assigned by **Spencer**, for the obstruction of due reformation in Ireland, is the neglect of the churches; which, he complains, ‘lie for the most part even with the ground; and of those lately repaired some are so unhandsomely patched,



---

p.132



and thatched, that men do even shun the places for the uncomeliness thereof.’


After quitting the abbey, I went to the court-leet room to hear, and, I own, to see the service of God performed, according to the usage of the church of **England**. And there I found a thin congregation, composed of some well-dressed women, some half-dozen boys, and perhaps half a score of foot soldiers. For there is a school and a barrack in the town.


How differently is the state of the diocese of **Armagh** represented? It is said, that the archbishop of that see has not only decorated his cathedral, given it an organ, and fixed a choir there, but that he has built one of the best houses in the kingdom, a real palace, suited to his elevated rank.


It was originally intended that bishops should reside in cities. Lord Coke is of opinion that the very residence of a bishop constitutes a city. His Grace therefore, with ideas truly episcopal, would have **Armagh** a city not only of courtesy but in reality; and to effect it, he makes it a condition with his tenants, that they shall all build good houses, and slate them. Inventa



---

p.133



lateritia, marmorea linquenda. Nor has he stopped here. He, at his own expence, has built and endowed a sumptuous diocesan library; and by his influence and contribution he has erected a magnificent hospital, a college, and even a barrack. His clergy are all following his steps; and new houses, new churches, and spired steeples are everyday rising through every quarter of his diocese.


Dr. Garnet, bishop of Clogher, had been long pursuing the same plan. He has improved his cathedral and palace, built churches where they have been wanting, and scarce a parish in his diocese is without a good new parsonage-house.


Still farther north, **Hervey**, brother to Lord Bristol, is following their examples. And, all together, they are rendering **Ulster**, the most mountainous and barren quarter of the kingdom, as eminently superior to the other provinces, in the ecclesiastical department, as it had been before in the civil.


But you must be tired with a subject which cannot appear at a distance, of such importance, as to one on the spot.


Good night.




---

p.134


  
Cashel.


My short stay here has afforded me frequent opportunities of conversing with the common people; who, having observed me measuring one of the monasteries, would sometimes follow me at a distance, and sometimes throw themselves in my way, in order to get or give information.


Their native humour was entertaining, and their remarks upon men and manners shrewd and sagacious; but nothing could be more ridiculous and absurd than their traditional tales. Asking them for the reason of the name of the Hore Abbey, they told me, that one of their queens, who in her youth had been a great *whore,* founded it for the salvation of her poor *soul.*


Their curiosity was strong to know whence I came, and where I was going, and what could be my motive for taking the dimensions of such old walls. It contributed not a little to remove their reserve towards me, that I was unknown by every body yet they did not, without an artful



---

p.134



and wily address, discover their sentiments as to the White-boys. They always took care to say, that they were wrong in what they were about, at the very time they were insinuating that others were more in fault than they.


Yesterday there was a horse-race, and at night an assembly. Too busy for the course in the morning, I was glad of an opportunity to change the solitude of an inn, for such gaiety in the evening. And never was I more surprised than at the multitude and politeness of the company. Some nobility, and all the gentry from far and near, were collected together. We had no less than two sets of dancers, and three or four card tables. The ladies were not only well but elegantly dressed, in the ton of a winter or two since in **London**.


Of what extremes is this country composed? Here every thing wore the face of festivity and pleasure; it looked as if Amalthea had emptied her horn in this spot. I had heard of vivacity, and I had seen it in individuals, but never, till last night, did I see it universally pervade so large a mass.




---

p.136


The women vied with the men in the display of animal powers.


You have seen Stubbs's picture of the Chariot of the Sun; and you may remember how the wheels blaze, and how the horses are maned with flame; every thing seems in the nascent state of conflagration. It was just so here. You would have said they breathed fire. We frog-blooded English dance as if the practice were not congenial to us; but here they moved as if dancing had been the business of their lives. The Rock of Cashel was a tune which seemed to inspire particular animation.


These people have quick and violent spirits, betraying them sometimes into sudden starts of indecorum, which the severity of punctilio would not fail to censure, while candour would only consider them as the venial flashes of mirth and good-humour. I have seen the whole room in a convulsion of laughter at a false step made by one of the dancers. Nor does penury repress these ebullitions among the lower ranks; for though four centinels, with their bayonets



---

p.137



fixed, were stationed at the door, the mob rushed in, and rendered the room very offensive.


How different are the effects of the same sensibility in another line? I had been strolling through the market, in order to see what commodities were sold, and to observe the humours of the people; when I remarked a poor woman, who had lost her purse, containing but two or three shillings. The poor creature wept aloud, and the women, about her, joined in the lamentation which had such an effect, that a general outcry was the consequence, so piteous and so doleful, that the men themselves could not refrain the sympathetic tear.


In this market I observed a great number of little bags, which men carried in upon their shoulders, and set down for sale. Upon examination, I found them filled with wheat; some of them contained ten or twelve pounds, some a stone and a half, some more and some less. It is hardly necessary to review the face of the country, in order to learn the state of its agriculture; this single fact reflects it as a mirror.




---

p.138


Were I to devise an emblematical figure of Ireland, in her present state, it should not be a Minerva-like figure, with her spear and harp; nor should it be a Diana with her wolf dogs coupled, and the moose deer in the thicket of the back ground. For that species of deer has been extinct here longer than the records of Irish history reach; the wolves too being all destroyed, and the dogs therefore useless, it looks as if nature intended that their species should fail also, for I never could see one of them. But my picture of Ireland should be mulier formosa superne, a woman exquisitely beautiful, with her head and neck richly attired, her bosom full, but meanly dressed, her lower parts lean and emaciated, half covered with tattered weeds, her legs and feet bare, with burned shins, and all the *squalor* of indigent sloth.


But to return to our assembly; where, though unknowing and unknown, I met an instance of that civility to strangers, for which this country is so justly famed. I had indeed hitherto withdrawn myself from all possible occasions of meeting with it, as I had little time to spare for this purpose, 



---

p.139



and was rather desirous to learn the true state of the country and people in other respects; their character for hospitality being already sufficiently established. But as this was the first opportunity I ever took, of experimenting in this way, I cannot in justice to true politeness pass it over.


A gentleman, whom I since learn to be a physician, seeing me a stranger, accosted me in a manner which bespoke the liberality of literature and travel; and after offering all his services in conducing me to whatever might gratify my curiosity in his country, he asked me whether I would chuse to dance or play cards, that he might introduce me, &c. I need not tell you which I chose. He got me an agreeable partner for one set, and the next I chose for myself. Their conversation was as spirited as their dancing. One of them had a person that would be gazed at in St. James's. These people were upon the whole so free, so easy, and so engaging, that I cannot help feeling myself interested in their national prosperity.




---

p.140


My new acquaintance the Doctor, whose name is Carrol, made me known, or rather indeed he made several gentlemen known to me; for as yet, he did not know my name. Several polite invitations were the consequence; one of which I accepted from a gentleman, who, as my conductor, the Doctor tells me, is son to a Roman catholic of large property and great influence, descended from the once royal family of the Macarty's. This will be a scene of novelty. I shall not forget to let you know all that shall befal me, among these descendants of Hibernian kings.


Farewell.

  
**Tipperary**,


September 20, 1775
Since my last, I have spent some days most agreeably at Mr. Macarty's of Springhill; where hospitality was displayed in its best manner, divested of those qualities, which of old tarnished the lustre of that virtue in Ireland. There was no constraint in the article of wine, nor indeed in



---

p.141



any other. There was as much ease as in the house of an English Duke.


However, lest from the little I have seen, so repugnant to what I have heard on this subject, I might lead to a misconception of the ruling manners at present, I must observe, that this ancient family have seen much of the world. The eldest daughter is married to a colonel in the Imperial service, who is also an officer of state at court; the eldest son, whom I met at the assembly, is an officer in the same service, and Miss Macarty is but lately returned from visiting her sister. You will not be displeased to hear, she preferred **England** to every other country she had seen; which to me still more endeared her, 
  

who had every grace, and every charm
  

To win the wisest, and the coldest warm. 


Here we were at meals, even on Sunday, regaled with the bag-pipe, which, to my uncultivated ear, is not an instrument so unpleasant as the lovers of Italian music represent it. After supper, I for the first



---

p.142



time drank whisky punch, the taste of which is harsh and austere, and the smell worse than the taste. The drinkers of it say it becomes so palatable, that they can relish no other; which may very possibly be the case, for I suppose that claret is not relished by any palate at first.


The spirit was very fierce and wild, requiring not less than seven times its own quantity of water to tame and subdue it. They told me there was a sort much stronger, distilled with aromatic substances, at a guinea a bottle, called **usque-bagh**, which is literally **eau-de-vie**; as whisky or **uisge** is emphatically the water.


This was the **liqueur**, which the Czar Peter the Great was so fond of, that he used to say, ‘of all wines, *Irish wine* was the best.’


Here I met with **Mr. Baker**, a clergyman, and a man of letters, who gave me a cordial invitation to his house, promising to introduce me to **Mr. Armstrong**, minister of **Tipperary**; a gentleman curious in the antiquities of his country, and furnished with one of the best libraries in the kingdom. I had no difficulty in accepting this 



---

p.143



invitation, but that it separated me from the agreeable family at Spring-hill.


In **Mr. Baker**, I found a young-looking man, but of ancient plainness, and simplicity of manners. His words were few, but those were correct, and all his sentiments shewed that he thought for himself. His wife, of an elegant person, was rather under the common size, but the stature of her mind was of the first magnitude. She is sister to Mr. Jephson, author of Braganza, which had such a run the last winter. If this lady writes as well as she speaks, she would certainly figure in the Belles-Lettres. She has such a purity of diction, such elegance of sentiment, and such warmth of imagination as would amaze you. Yet these shining qualities serve only to shed a lustre upon the goodness of her heart; those make her an admirable, this renders her an amiable, woman.


**Tipperary** is a small, but thriving village, with little or no manufacture. An effort has been made to establish the linen manufacture, and for this purpose a colony of northern weavers was settled there about forty years ago. But this proved ineffectual; 



---

p.144



for the children of those weavers, like the other natives, neither weave nor spin; and in every thing but religion, are undistinguishable from the general mass. Such is the resiliency of all nature to its original state.


General and inveterate habits of sloth, must be removed upon systematic principles, before a way can be made for the introduction of the arts of industry; a few examples are not sufficient to excite an imitation of better things. We are all by nature abhorrent of labour, for labour gives pain. Sloth must prevail, till the incentives to diligence overpower the propensity to idleness: which can never be the case, till artificial wants become, at least, as numerous as those which are really natural. If an Irishman feels no inconvenience from walking barefoot, he will hardly be induced to work for the price of brogues.


The manner in which the poor of this country live, I cannot help calling beastly. For upon the same floor, and frequently without any partition, are lodged the husband and wife, the multitudinous brood of children, all huddled together upon straw



---

p.145



or rushes, with the cow, the calf, the pig, and the horse, if they are rich enough to have one.


Their houses are of several sorts; but the most common is the sod-wall, as they call it. By sods you are to understand the grassy surface of the earth, or the **cespes** of the Latins. Some build their houses of mud, as we do: others use stone without mortar, for two or three feet from the ground, and sod or mud for two or three on the top of that; their side-walls being seldom above five or six feet high.


Sometimes you may see an ingenious builder avail himself of the side of a ditch, which serves for a sidewall, and parallel thereto, he rears a wall in one or other of the modes I have described, as his own fancy, the facility of the method, or abundance of materials may lead him.


Another will improve upon this plan, and make the grip or fosse of the ditch, serve for the area of his habitation, by a little paring to widen the space; he being thus saved the labour of erecting side-walls, and having only the trouble to build his



---

p.146



gables; for the which his prompt invention has a noble succedaneum in the hip roof.


Their mode of roofing is not less ingenious. They take the branches of a tree, the largest of which they use as principals and purlins, and the remainder they lay parallel to the principals, for support of a thin paring of the grassy surface of meadow ground, like the sods, only much broader, tougher, and thinner. These they call scraws, meaning to be sure scrolls, seeing they are rolled up in that form, as they are pared. But they would be better called *hides,* for they are flayed off the earth. With these, however, they cover the small branches or wattles, and over all, they fasten a coat of straw, or, in default of straw, they cover with rushes or the haum of their beans or potatoes, and in mountainous tracts with heath.


Sometimes they have a hole in the roof to let out the smoke, and sometimes none. For to have a chimney, would be a luxury too great for the generality. The consequence is a house full of smoke, at least in the upper region, where it floats in thick clouds, the lower part being pretty clear



---

p.147



of it. To avoid the acrimony of which you are obliged to stoop down, and the poor man of the house immediately offers you a low stool, that you may be, what he calls, out of the smoke. And this is, probably, the only stool in the house; for the children nestle round the fire almost naked, with their toes in the ashes. Even the women, though not so naked, sit upon their hams in the same way. But in spite of their general adhesion to the ground, the old people are, for the most part, blear-eyed, with pale and sooty faces.


The only solace these miserable mortals have, is in matrimony; accordingly, they all marry young. Most girls are, one way or another, mothers at sixteen; and every house has shoals of children. Not that, I suppose, women are by nature more prolific here than in **England**, yet their early marriages, and necessary temperance, furnish more frequent instances of foecundity.


Nor is this country without instances of extreme longevity. Mr. Russel of Cloneen died, April 1770, at the age of 145. But such are not found in the sooty[9](javascript:footNote('E770001-002/note009.html')) cabbins, whose wretched owners do not grow



---

p.148



to the size of well-fed men, and consequently cannot extend their lives to the natural term. People may say what they please about the wholesomeness of a mere potatoe diet; but shew me a set of men, with such a rosy hue of health as the butchers of **England**.


From the promiscuous way these people lie together, a suspicion naturally arises in a stranger's mind, that incest is unavoidable amongst them. Yet upon the strictest inquiry, I find the fact to be otherwise. They are bred up in such an abhorrence of the turpitude of this crime, that I am inclined to think it as infrequent here, as among more civilized nations. The better sort of people seemed rather surprised that I should entertain such an opinion; which only shews, that what we see practised from our infancy, though ever so unnatural, makes no impression.


A little reflection, however, will remove even the grounds of suspicion. Bred up from childhood together, their wonted and innocent familiarity is carried on step by step, without impure emotions being excited. One of these poor souls is no more



---

p.149



inflamed by the nude bosom of a sister, than in a more affluent state he would be on seing it covered with gauze.


There is no indecency in mere nakedness. Would drapery add to the modesty of the Medicean Venus? The chastest eye may gaze upon the naked figures of the Graces; but emotions will arise on seeing *the lady stepping over the style;* yet nothing is seen that our Madonas do not disclose. It is the imagination too dainty, from mistaken refinements, that annexes modesty or immodesty to dress, or to the want of it.


There are certain adjuncts peculiar, neither to the concealment nor display of beauty, capable of exciting ideas either gross or refined. And as the artist, by availing himself of these associations, may paint modesty naked, and lewdness wrapped up, so the nakedness of savage nations may not tend to immorality, whilst the dress of civilized people may be panders to sensuality. Was there not an ancient legislator, who, in order to lessen the influence of women over the men, exposed them naked?



---

p.150



It was far otherwise in the Hate of innocence and pure love,—
  


> 1. Then was not guilty shame, dishonest shame
>   
> Of Nature's works; honour dishonourable!
>   
> Sin-bred! How have ye troubled all mankind,
>   
> With shews instead, mere shews of seeming pure;
>   
> And banished from man's life, his happiest life.
>   
> Simplicity, and spotless innocence?
>   
> So pass'd they naked on, nor shun'd the sight
>   
> Of God or Angel, for they thought no ill.
> 

[10](javascript:footNote('E770001-002/note010.html'))


  
Tipperary


I generally spend my mornings here in riding to such places as my kind conductors think most worthy observation; I have been to see a large unfinished house of Lord Milton's at Shrone-hill, and other places of less note. But the only building worthy any remark, is the Abbey of ***Holy Cross*** the architecture of which, more than ordinarily elegant for this country, sufficiently rewarded the fatigue of a long ride.


I learn, from **Mr. Armstrong**, that this Abbey was founded in the twelfth century, by Donald O'Brien, whose monument is 



---

p.151



still to be seen near the high altar. In the south aile is the shrine, wherein some pieces of the cross were supposed to be preserved; both of which are more highly embellished than any other Gothic remain I had seen in Ireland.


From what I have said in a former letter, you may conceive that agriculture is at a very low ebb in this country; I need not add that you may ride for miles, in the most fertile part of it, without seeing an acre of ploughed ground; except where potatoes had been, a year or two before. This is a subject I do not understand, but the process of cultivation, generally adopted by the poor, I hear, is this: the first year they plant potatoes upon the ley, the next they sow bere, the third wheat, and the fourth oats.


Their manner of planting potatoes is the following: after cutting the potatoe into several pieces, each of which must have what they call an *eye,* they spread these sets on the ridges of about four or five feet wide, which they cover with mould, dug from furrows on each side, of about half the breadth of the ridge. In Autumn,



---

p.152



when they dig out their potatoes, they sow the ridge, immediately before digging, with
bere; and the same operation serves for gathering in their potatoes, and for covering
the new sown seed. This method, you'll say, is facile enough; yet such is the fertility of the soil, that their crops are most abundant from it.


The above method, however, is not universal, for sometimes they do not dig out their potatoes, till the frost sets in; and as hard frosts are very rare in this climate, some dig only as they want them. Whence it happens, that if a nipping frost should chance to surprise them, many lose their whole crop, their chief subsistence; and then famine is sure to *cling their bones* the ensuing summer. Such are the effects of having little to do, that people become indolent and will do nothing.


The little culture, which is carried on, is exercised by the very dregs of the people, upon one acre or two, in the worst manner, subservient only to their immediate support, without any farther prospect. Their very implements of labour are of the most awkward and ineffectual forms.




---

p.153


When I tell you the price of lands here, you will perhaps suspect I report upon hasty information; yet be assured that 40s. an acre is the common rent of good lands, and that the best are rated at two guineas, which are 2l. 5s., and 6d. of this currency. It is true, that the Irish acre is larger than the English, in the proportion of the squares of the perches, viz. 7 and 5 1/2.


**Mr. Armstrong**, the rector of this very parish, has just taken a perpetuity of 280 acres, at 2l. per acre. And, upon my supposing to him, that his inducement to give so much, was a very good house and offices upon the grounds, he told me, that the same rent could have been had from a grazier, but that the owner made him a compliment of the bargain; and he at the same time assured me, that a great part of **Tipperary** and **Limerick** gave two guineas.


The rents are made almost entirely by grazing, and every care is taken to improve the breed of cattle. They bring over, at the peril of forfeiting both ship and cargo,



---

p.154



Lincolnshire rams; and the race of these are sold from five to twenty, and sometimes thirty guineas a ram.


The landlord, who gets his rent without trouble, and the grazier, who thrives upon depopulation, will tell you the lands of **Munster** are so rich, that they are injured by cultivation.


This, however, scarcely requires a serious answer; for, if their lands were as fruitful as Arabia Felix, industry would improve them; but they have many spaces that demand perpetual culture. Their meadows, mostly in their lowest and wettest grounds, have never been drained, manured, or sowed with grass seeds. If we add to this, what ground might be saved, by feeding their flocks with turnips, peas, beans, carrots, cabbages, &c. it will be evident that the same farms, now occupied by brutes principally, would maintain the same numbers still, together with farmers and manufacturers five-fold.


There is, I am told, a statute, unrepealed, enjoining the cultivation of not less than five acres out of each hundred, under



---

p.155



the penalty of 40s. But this act is as dead as the letters of it; for all the rich are delinquents, and none but the impotent poor are left to enforce the performance of it. Besides, the quantity to be tilled was inadequate to the purpose of population, and the penalty was too small for a sanction, if the quantity had been sufficient.


It may, after all, be questioned, whether any internal regulation, in favour of agriculture, can counterbalance the ill effects which result from the external embargo. Nothing could so effectually remedy these evils, as an open sea, and a free exportation. For, upon a dispassionate review of this matter, I am inclined to think that neither landlord, nor tenant, nor both together, are *entirely* in fault.


As the matter now stands, we take from hence when we are pinched, and possibly when it can be but ill spared; then, when we have served ourselves, we shut up their ports. This desultory mode cannot answer any great purpose, either to them or us; whereas, if Ireland were suffered to export, at all times, it would soon be allured to a



---

p.156



systematic industry, and become a perpetual granary to our manufacturing country.


Farewell.

  
**Tipperary**


In **Mr. Armstrong**'s library, I have found great entertainment, not only from the books, but from some antique curiosities, found in the neighbouring bogs; and from a catalogue of others, not now in his possession. These are of such importance to the forming just ideas of the ancient state of Ireland, that I would transmit you a catalogue of them, only I find governor **Pownall** has published, from the same original I have seen, a copy in the miscellaneous tracts of the Antiquarian Society[11](javascript:footNote('E770001-002/note011.html')).


I send you, however, a sketch of a little *crown* of silver, lately found near Cashel; the diameter of which is 2 1/2, and the height 3 1/2 inches. It must, I conjecture, have belonged to some image of the virgin,



---

p.157



or rather child, either in the cathedral, or some of the monasteries of Cashel.


I give you also, by way of illustration, a rough draft of a **tumulus** near this town, amidst hillocks nearly of the same shape, and overhanging a glassy lake. These **tumuli** are mounds of earth thrown up, as sepulchral monuments, in form of a truncated cone; and of dimensions different, I presume, according to the dignity of the deceased,
  


> 1. — fuit ingens monte sub alto
>   
> Regis Dercenni terreno ex agere bustum.
> 

[12](javascript:footNote('E770001-002/note012.html'))


Such monuments could be raised only for persons of the first quality. And from a line in **Lucan** one would think they were appropriated to kings.
  


> 1. Et regum cineres extructo monte quiescunt.
> 

[13](javascript:footNote('E770001-002/note013.html'))


But Plutarch, relating the death of Demaratus, the Corinthian, upon a visit he paid to Alexander the Great, says, ‘That he had a most magnificent funeral, the whole army raising him a monument of earth, four-score cubits high, and of a vast circumference.’


These monuments are vulgarly called Danes-mounts. Yet, wherever they have



---

p.158



been opened, urns have been found in them; a circumstance, which alone disproves their being Danish. For the practice of burning the dead was disused long before the Danes possessed themselves of Ireland, or rather of the maritime towns; for I do not find that their dominion extended to the internal parts.


Had these mounts been thrown up by the Danes; from the odium in which, even to this day, the memory of those invaders is held, the Irish would not have failed to demolish such memorials of their own disgrace, as soon as they had expelled the authors of it. But, so far are they from destroying them, that they hold them in veneration, and it would be difficult to find a labourer hardy enough to violate the sacred earth, with a spade.


**Herodotus** speaking of the tombs, raised by the Scythians for their kings, says, ‘they laboured to raise as high a mount of earth for them as possible.’[14](javascript:footNote('E770001-002/note014.html')) These artificial hills then must be attributed to the Scythian origin of this people. I was surprised to find the ingenious Mr. Molineux ascribing them to the Danes, especially



---

p.159



as he mentions two coins of the emperors Theodosius and Valentinian, being found in that famous Tumulus, at New Grange, near Drogheda. This, though not a decisive evidence, is certainly a presumptive one, that these sepulchres were anterior to the Danes in Ireland; and the rather, as those coins are described to be sharp and unworn.


Such mounts, however, are not peculiar to Ireland: I have seen some of the same kind in **Scotland**, and there are no less than six in a line, within a mile or two south of the little village of Stevenage in Hertfordshire.


I send you as exact a drawing as I could make, of a brass sword, found in a bog near **Cullen**, which is twenty-six inches in length, and weighs near two pounds. **Mr. Armstrong** says, he has seen twenty-two others of nearly the same construction, found in the same place. The catalogue, to which I have referred you, mentions that above 300 have, from time to time, been found in this quarter.


What makes these brazen swords such a valuable remnant to the Irish antiquarian, is, they serve to corroborate the opinion,



---

p.160



that the Phoenicians had footing in this kingdom. For the sword-blades so lately-found upon the plains of **Cannae**, were of the same metal and construction; and being used by the Carthaginians, who were originally Tyrians, they establish the certainty, that these brass weapons were Phoenician also. Consequently, somewhat more than presumption arises, that Ireland had its arts, and letters, from the country of Cadmus; as her traditions uniformly report.


With **Mr. Baker**, I saw eleven old coins, lately found at **Marseilles**, which, though in no wise relative to this country, yet being somewhat curious to me, a mere novice in medals, I cannot help giving you some account of them. They have each a Diana's head, and on the reverse, a bull in the act of butting. The legend under the bull is MASSALIHTWN. Thus far they all agreed, yet they had been all struck from different dies, and at different periods; for some were very neat, and others in a very coarse manner; which seems to point out a regular gradation of refinement in the arts, from the striking of the first to the last. Each of them has


---

p.unnumbered




---

p.unnumbered




---

p.161



different figures over the Bull; one a blazing star, another a bow, a heart, a wreath of laurel, a crescent, &c. And there was a Mercury, on the wing, exceedingly well executed.


But I had almost forgot to mention to you a circumstance relative to the brass sword: **Lord Townshend** liked its form so much, that he told **Mr. Armstrong** he would adopt it in his regiment of artillery. For you must know, that when this nobleman was Lord Lieutenant of Ireland, he took a tour to learn the state of the country, and passing this way, he outrode his *suite,* and overtook **Mr. Armstrong**. They fell into conversation, and our worthy parson hearing that the representative of Majesty was to sleep at **Tipperary**, lamented the badness of the inn; and that he could not presume to offer a bed to so great a guest. But, Sir, says he, taking him for an Aid-de-camp, I shall be happy in giving you a bed and supper too, when you can disengage yourself from your attendance on his Lordship. I live not far from the town, and any body will shew you the house of



---

p.162


**Mr. Armstrong** the minister of the parish.


This adventure must have been doubly pleasing to our facetious viceroy, when he alighted at **Tipperary**, and had a prospect of the wretched entertainment, to which he must have submitted in a dirty ale house. He, however, finessed no longer, but sent down his compliments to **Mr. Armstrong**, with a message, that **Lord Townshend** would take a bed with him. And so well pleased was he with his host, that he took the first opportunity of promoting his son, who was an officer in the army. This I relate to the mutual honour of both parties.


In this neighbourhood lives the descendant of him who gave the last and fatal stroke to the unhappy **Charles**. He had been a common dragoon in **Cromwell**'s army; and for this service, the usurper rewarded him with a captain's double debenture.


I spend my evenings still more pleasantly than my mornings. **Mr. Baker**, and **Mr. Armstrong** live so near each other, that we



---

p.163



are always together; and the latter, having a very large family of daughters and nieces, I have been prevailed on to play at cards. The game, however, is one which requires neither skill nor attention, and is rather a supplement to the pauses of chat, than an interruption to cheerful conversation.


As the events of chance were never important enough to engage my attention, I used to hate cards; I never could see any amusement in being plundered by my adversary, brow-beat by my partner, and laughed at by the standers-by. But now I am grown very fond of them; and such excellent lessons do the ladies give, that I flatter myself with becoming an adept.


Though Mr. Hoyle has laid down no rules for the game *we* play, it is worth all he ever taught put together. It is of so very social a kind, that the number of players is limited only by the number of cards in the pack. It does not impose silence like *whist,* but affords a pleasant exercise for the tongue, and is more philosophical than even that Pythagorean game; for the initiated may



---

p.164



see in it, as in a mirror, an exact image of the great play of life.


As in our game, one only can get the pool; so in the world one only can arrive at the pinnacle of fortune, in the same line of ambition, quia plures excellere nequeunt.


As at each deal one must lose, and another win, the utmost skill being sometimes useless, whilst a total want of it proves successful; so in life, some are born to large estates, or obtain them without diligence or address, whilst others toil on unsuccessfully, and are baffled at last, in spight of all the efforts of human wisdom.


Again, it often happens that a junto of young people who sit together, play into one another's hands, and of course one of them wins the pool; so in life, friends and relations, by mutual partialities, lead one another to fortune's goal, whilst the best laid schemes, of those who stand single and play fair, turn out abortive: something like an invincible necessity prevailing to determine, in all cases, the winnings and the losings, and to reprobate the maxim, quisque suae fortunae faber.




---

p.165


To-morrow I shall set out for **Cork**, where I hope to find a letter from you, I with pleasure tell you that air and exercise have dispelled that dejection of spirits which was wont to oppress me; and the society I have enjoyed here, hath so attached me to the place, that I shall not leave it without reluctance: I already sigh at the thoughts of parting with such friends, whom I shall probably never see, or perhaps hear of more.


Adieu.

  
**Cork**,

 October 4th, 1775.
After parting with my agreeable and learned friends at **Tipperary**, I soon ascended the **Gaultees**, and then descended into a valley, called the **Glin of Agherlow**, whence the opposite ridge seemed stupendous. That which I passed, not without fatigue, was comparatively as the cock-boat to a first-rate man of war. The ridge just crossed, was for some miles to the right hand, skirted with oak woods, which at best were of small growth, but they became gradually stunted more and



---

p.166



more, as they climbed the steep, till at length they dwindled into mere shrubs; and left the summit bare.


This is the universal order of nature, and I wish gentlemen, who are so fond of circular clumps on the tops of hills, in hilly countries, would attend to it. Sitting now, after a very good dinner, and having nothing to observe of the place, but that coming in late, I with difficulty got a bed in any of the inns, and that I must soon retire to an ordinary bed, and a dirty chamber, I shall employ the interval, in setting down my reflections upon this
subject, confirmed by what I observed to-day.


It will not, I believe, be controverted, that the most beautiful countries are those which are gently varied with hill and dale; equally removed from the roughness of the mountain, or the deadness of the flat. If mountains are introduced to embellish the scenery, they must be placed at a due distance, else their ruggedness is deformity. It should then be the planter's object to reduce the landskip to the happy medium of being neither too hilly nor too level. And



---

p.167



in this picturesque mixture of hill and dale, few countries are, I suppose, more happy than Ireland; it wants nothing but plantation, and cultivation.


If a country is generally level, and if a spot should swell above the rest, then you are by all means to encourage the undulation. You are by planting it with the loftiest forest trees, to give it boldness and variety, for in so doing, you relieve it from that tiresome uniformity which creeps along a dead flat.


On the other hand, if the country is too hilly, you are, as far as in you lies, to reduce it nearer to a plain; not by that expensive, artless, and generally ineffectual mode of removing earth, but by planting the valley, or along the feet of the hills: for, by this means, you deduct the height of the plantation from the height of the hill, and, as it were, level the hill by apparently raising the valley; and thus approach nature's varied medium, the very essence of beauty.


By planting on great eminences, instead of correcting, you exaggerate the deformity of your grounds. Trees are in themselves



---

p.168



so beautiful, that I am always glad to see them wherever they are, especially in this naked country, but the summits of her hills are not the place for them. Sed nunc non erat his locus. There is one case, and only one, where they are not, there, misplaced, and that is in regions uncultivated, to shew that they are not quite deserted by the human species.


I have put this case, yet it is one barely possible; for the tops of hills are generally so barren, and universally so exposed, that trees are with difficulty reared, and never thrive upon them. Let us then attend to the workings of nature, and we shall find her disclaiming trees on the tops of hills, by denying them vegetation; let us consult the feelings of taste, and we shall find them displeasing to our sense of beauty.


Even the circular figure of these clumps, is of all others the most artless, for of isoperimetrals the circle is the most capacious. Consequently, instead of displaying your trees to the best advantage, you in effect hide a great proportion of them; whilst you make an ostentation of art, both in the choice of the figure and of the situation. 



---

p.169



But let us *naturalize* art, instead of *artilizing* nature. Plantations upon exposed elevations, are the utmost solecisms in improvement, both in respect of beauty and utility.


There is between **Cashel** and **Tipperary**, a park the largest and bed planted in this kingdom; containing, it is said, above 1500 Irish acres, or near 2000 English; and abounding with droves of red, and other deer, proportioned to its extent. The **Gaultees** are set at such a due distance, that they are the finest termination for the prospect a painter could desire; the lands are rich, and the trees the best grown I have seen in Ireland. Here are all the *capabilities* for a terrestrial paradise; and yet one thing is wanting that mars the whole. Every violence, that she is capable of suffering, has been done to Nature.


Behind the house is a square parterre of flowers, with terraces thickly studded with busts and statues; before it, a long and blind avenue, planted with treble rows of well-grown trees, extends its awkward length. In the centre of this, and on the acclivity of the hill, terminating the vista, are little



---

p.170



fish ponds, pond above pond. The whole park is thrown into squares and parallelograms, with numerous avenues fenced and planted; where if a hillock dared to interpose its little head, it was cut off as an excrescence, or at least cut through; that the roads might be every where as level, as they are straight. Thus was this delightful spot, treated by some *Procrustes* of the last age.


I own to you I felt more pain than pleasure in this demesne. I could not help wishing, that instead of torturing the place to the plan, they had accommodated the plan to the place. Indeed, all predisposed plans for laying out grounds are dangerous; for every place has within itself a plan, from which true taste can never deviate. Nature may be improved, but never changed to advantage. Levelling hills and raising mounds, at a vast expence of money, is like the custom of the Indians, who, at the expence of their blood, slit their ears, and gash their faces, to improve their beauty.


I breakfasted at **Mitchelstown**, a very poor village in the county of **Cork**, fourteen Irish, but near eighteen English miles from



---

p.171


**Tipperary**. And here, for the first time, I felt enough of that wretchedness I had so often heard of in Irish inns. But, it was not to be expected that such good accommodations should be met with, in a cross road, as in the direct ones from the capital.


In all this way, though the grounds were generally fertile and pleasant, I saw but one gentleman's seat. This one was well wooded, and situated on the brow of a hill, overhanging a little stream which meandered through the valley, near which were several old ruins of religious houses, at a place called **Gaul-Bally**, i. e. the town of the Gauls or Celts. I then doubled the southern ridge of the **Gaultees**, which was terminated by what at a distance seemed a sugar loaf, but at its base a promontory.


This long chain of hills, which fences in the **Glin of Agherlow** on one side, disputes with **Mangerton**, in the county of Kerry pre-eminence of altitude. [15](javascript:footNote('E770001-002/note015.html')) Yet, in this



---

p.172



respect they are not to be compared to **Snowdon**, or even others of the Welch mountains. But they are of forms the most beautiful, fantastic, and picturesque, that can be imagined. First they rise from little hills, till at length they swell into mountains, acclivity above acclivity, shade above shade; some piercing the clouds in spiral lines, some conically acuminated, and some overhanging the rest, in horrible magnificence.


Between two cliffs, I saw what at first I took for smoke; but at a height too great, and in a spot too craggy for human approach, I soon perceived that it did not rise from fire, but from its opposite element: It proceeded from a small stream, which falling perpendicularly, was checked by a brisk gale, then blowing in a contrary direction, and raised up with such force, that it was rarefied into vapour as subtile as smoke.




---

p.173


From **Mitchelstown**, the country becomes unspeakably dreary for seven or eight miles. The greatest part of it was an unvaried waste, without either hill or dale, bog or mountain, arable or pasture; for though it was high, it was level; and though black, it was hard; too stony for the plough, and too barren for grass. The jaded eyes felt some refreshment at sight of the plantations round **Kilworth**; which, though a poor village, looked opulent after **Mitchelstown**.


From **Kilworth** hither, the cottages grow more frequent, and less wretched than those in the fruitful vales of **Tipperary**. The country is, however, generally naked, except sweet little spot called **Fermoy**, on the **Black-water.** Here I was delighted at seeing a good large nursery of trees; for I promised myself, from this phaenomenon, better things on my approach to **Cork**. But I was sorely disappointed, for except at **Rathcormac**, a poor borough, near which is a pleasant residence, the whole country is almost treeless. The sorry inclosures being planted with furze or goss, and the inclosed grounds being very much overrun



---

p.174



with them also, adds double darkness to this gloomy region. Yet the land from **Kilworth** is rich enough, and with proper cultivation would produce excellent crops.


But I must bid you good night. Tomorrow I purpose to spend in reconnoitring the city and its environs; of which, as my arrival was late, after a ride of above fifty miles, I have not yet got even the perspective.


  
**Cork.**


This is a city large and extensive, beyond my expectation. I had been taught to think worse of it, in all respects, than it deserves; it was described as the magazine of nastiness. And as it is the great shambles of the kingdom, I was predisposed to credit these reports; but it is really as clean, in general, as the metropolis. The
slaughter-houses are all in the suburbs, and there, indeed, the gale is not untainted; but in the city, properly so called, all is tolerably clean, and consequently sweet. If sufficient care were taken, even the suburbs



---

p.175



might be purged of every thing offensive, either to the sight or smell; for they stand upon the declivity of hills, and down each street there is a copious flow of water, perpetually washing down the filth, from the door of each slaughter-house into the river, which surrounds the town. The city is situated, as **Spencer** graphically describes it, in his marriage of the Thames and Medway.
  


> 1. The spreading Lee, that like an island fair,
>   
> Encloseth Cork, with his divided flood.
> 

[16](javascript:footNote('E770001-002/note016.html'))


This island is intersected with several canals, either natural or artificial, which, being banked and quayed in, bring up ships almost to every street. The city, however, is mostly composed of lanes, cutting the main streets at right angles, and so narrow, that one of them, which is but ten feet wide, is called Broad-lane. The houses are old, and far from being elegant in their appearance. On the new quays, indeed, there are some fair looking buildings; which they are obliged to weather slate. And this



---

p.176



they do in a manner so neat as to render it, almost, ornamental.


There are two large stone bridges, one to the north, and the other to the south, over the grand branches of the Lee, besides several small ones, and some draw-bridges thrown over the lesser branches or canals. There are seven churches, an exchange, a custom-house, a barrack, several hospitals, and other public structures, yet none of them worth a second look. I have not seen a single monument of antiquity in the whole town, nor heard a bell in any of the churches, too good for the dinner-bell of a country squire. But here is something infinitely better. Here is the busy bustle of prosperous trade, and all its concomitant blessings; here is a most magnificent temple, erected to plenty, in the midst of a marsh. For that it was originally such, if there were no other evidence, the very name imports: the word Cork or Corrach signifying palus or fen, as I learn from **Lhuid**'s dictionary.


A bookseller here has put this, and other tracts into my hands, which have been useful to me in my researches. **Smith**'s
 


---

p.177



history of **Cork**, quoting **Stanihurst**, reports that 120 years ago, **Cork** was but the third city in **Munster**, now it is the second in the kingdom, and therefore called the Bristol of Ireland.


Except in the article of linen, its exports are more considerable than those of **Dublin**. The balance of Trade, I should conceive, to be against **Dublin**, the trade of which, chiefly, consists in the importation of luxuries; whereas **Cork** deals almost entirely in exporting the necessaries of life, beef, pork, butter, hides, tallow, &c.


All the wealth of **Munster** and **Connaught** passes through two or three cities, which may be said to have eaten up the surrounding country, where the wretched peasant never tastes the flesh of the cattle which he feeds; but subsists upon potatoes, generally without butter, and sometimes without milk.


What proportion the trade of this city bears to that of Bristol, I have not *data* to form an estimate. If we were to judge from the richness of the shops, there is here a vast inferiority. In some other respects,



---

p.178


**Cork** appears to be the greater city. In 1754 the return of houses in **Cork** was 7445, in 1766 it was 8113; if we suppose them to have increased at the same rate since, they are now 8614. This is placing them low, for there are great numbers of the poor legally exempted from paying hearth-money; and it is not the interest of the collectors to exceed in their returns. In Bristol, and three miles round it, there are said to be but 9000 houses; if so, the houses in the city alone, are probably not so numerous as those of **Cork**.


In the reign of Edward IV. there were eleven churches in **Cork**; now there are but seven. Yet it has ever since that time been esteemed a thriving city, and in the memory of man it is said to have been doubled. But we have already seen that the state of population cannot be ascertained from the number of churches; if our ancestors had not more religion than we have, they were certainly more addicted to building religious houses.


To see the reason, why the number of churches has decreased with increasing population,



---

p.179



we should recollect, that in the time of Edward IV. they had but one religion, that now they have many; and that
the catholics outnumber all other denominations, seven to one at least.


As the Romanists adhere religiously to all their old institutions, in the number and division of parishes, and as they have now but seven mass-houses in so large and populous a city, we may fairly suppose that there were no more parishes in Edward's time; though there might have been eleven churches, reckoning in that number the chapels belonging to the four monasteries, which were then in **Cork**, viz. St. Dominick's, St. Francis's, the Red Abbey, and the **Cill Abbey**.


It must too be observed, that though the monasteries are destroyed, the Monks remain to this day, and have regular service in their distinct houses, as in the parish mass-houses. In all of which they have a succession of services, on Sundays and holy-days, from early in the morning, till late at night, for the accommodation of their numerous votaries.




---

p.180


Beside these eleven mass-houses, there are four dissenting meeting-houses, belonging to Presbyterians, Anabaptists, Quakers, and French Protestants. The prevalence of the Popish interest in **Cork**, may be argued
from the following trivial *circumstance*: bidding a fellow whom I had picked up for my ciceroni to conduct me from the cathedral to the bishop's house, he asked me *which bishop?* The same conclusion I drew at **Kilkenny**, from another trifle; I there heard the titular bishop greeted in the style of his dignity.


On Sunday morning early, I stepped into one of their mass-houses, and a spacious one it was. The priest had just finished the celebration of mass. On the altar stood six candles. A servitor came in, after the priest had withdrawn, and, kneeling before the altar, he entered the rails like those of our chancels; and, after kneeling again, he snuffed out two of the candles; then he kneeled again, and snuffed out two more; he kneeled a fourth time, and extinguished the fifth; the sixth he left burning.




---

p.181


There were several elegant carriages standing before the door when I entered, and a prodigious crowd of people in the street; as motley an assemblage of human creatures as I had ever seen. There was a multitude of beggars imploring alms in the Irish language, some in a high, and some in a low key. Some of them measured out tones as if singing; but in accents the most unmusical that ever wounded the human ear. They were worse than all the tones in **Hogarth**'s Enraged Musician. ——If this be a bull, consider that I am in Ireland.


Had this Rabelais of the pencil introduced an Irish beggar, he would have set Pasquali mad. In the most perfect of human compositions, there is, you know, something still wanting to render it complete. Pity that the influence of a Cork mendicant should be wanting, to fill up the measure of discord, and thereby render one human production perfect.


Not content with what I saw at mass, I afterwards went to church, the steeple of which exactly answered **Shakespear**'s description in *sloping to its foundation:* which



---

p.182



argues the fenny bottom, whereon it stands. I was, however, delighted with the contrast I found here. The service was, throughout, performed with the utmost decency and propriety; they had a good organ, and the singing was remarkably good. The embellishments of the church were neither rich, nor studied; but they were neat and plain; and the audience had, truly, as much the air of opulence and elegance, as most of the congregations in the city of **London**.


After service they generally betake themselves to a public walk, called the Mall; which is no more than a very ill-paved quay upon one of their canals, with a row of trees on one side, and houses on the other. It is a pleasure, however, to see that they are filling up this canal, and several others, where the water, having no current, must have become noxious to the air in hot weather. On a bridge, thrown over this canal, is an equestrian statue of his late Majesty, executed in bronze by an artist of **Dublin**. This with a pedestrian of Lord Chatham, of white marble, and



---

p.183



one in plaister of Paris, of king William III. in the Mayoralty-house, are the only statues in this large city.[17](javascript:footNote('E770001-002/note017.html'))


Is this street were well paved, and the Mall slagged, it would be as ornamental to the town, as agreeable to the ladies. There is another public walk, called the Redhouse walk, west of the city, cut through very low grounds, for a mile in length, planted on each side, where the lower fort walk and on leaving the Mall, I found it crowded with people, in general, very decently dressed.


Farewell.




---

p.184


  
**Cork**.


My time here I spend not unpleasantly. I am on horseback every day, and dine mostly with gentlemen of the army. One of the coffee-houses is conducted somewhat like those in **London**. The taverns are pretty good, and very cheap; port-wine is better here than any where else I have been, and porter is more common than in any part of **England**, out of **London**. This article alone costs Ireland a prodigious sum; I have heard above 40,000l. yearly. By means of the *draw-back*, this liquor is sold as cheap abroad as at home. Ought it not to be the policy of the legislature of this kingdom, to lighten, or even take off the duty on beer, in order to encourage their own breweries?


You may guess that **Cork** is a considerable city, from its having, as they tell me, a stand of fifty sedan chairs. They have a neat theatre, built by Barry, wherein the **Dublin** company exhibits during summer. The only public amusement at present is a



---

p.185



weekly Drum, where the company play cards, or chat, or dance, as they choose.


I was at one of these on Thursday last, and though there was no dancing, I found it very entertaining, as I was not constrained to play cards. The ladies being perfectly well-bred, and therefore accessible to strangers, we had a very unrestrained interchange of sentiments. It was not, I conclude, without good reason, that Mr. Derrick says, in one of his letters, that ‘he had seen a greater number of pretty women in **Cork**, than ever he had seen *together* in any other town.’


But whoever considers this matter dispassionately, will not find any *strong* temptation for a preference, in favour of any one place of the same kingdom, or of the one kingdom above the other. All natural endowments seem dispensed to each in very equal proportions.


It must, at the same time, be evident to the most superficial observer, that beauty is more diffused in **England**, among the lower ranks of life; which may, however, be attributed to the mere modes of living. There the meanest cottager is better fed,



---

p.186



better lodged, and better dressed, than the most opulent farmers here, who, unaccustomed to what our peasants reckon the comforts of life, know no luxury but in deep potations of **aqua vitae**.


From this circumstance, we may account for a fact reported to me, by the officers of the army here. They say, that the young fellows of Ireland, who offer to enlist, are more generally below the given height, than in **England**. There can be no appeal from their testimony, for they were Irish, and the standard is an infallible test.


I can see no reason why the causes which promote, or prevent the growth of other animals, should not have similar effects upon the human species. In **England**, where there is no stint of provisions, the growth is not checked, but on the contrary it is extended to the utmost bound of nature's original intention; whereas in Ireland, where food is neither in the same quantity, nor of the same quality, the body cannot expand itself, but is dwarfed, and stunted in its dimensions.


The gentlemen of Ireland are full as tall as those of **England**; the difference then, between



---

p.187



them and the commonalty can only proceed from the difference of food. The following case may, perhaps, tend to illustrate this matter, which, however, I only give upon uncertain authority. In the Anatomy-house of Trinity College, **Dublin**, is a human skeleton, of between seven and eight feet high. They told me, it belonged to one Magrath, an orphan, in this county, somewhere near Cloyne. The child fell into the hands of the famous **Berkeley**, then bishop of that see. This subtile doctor, who denied the exigence of matter, was as inquisitive in his physical researches, as he was whimsical in his metaphysical speculations. When I tell you, that he had well nigh put an end to his own exigence, by experimenting what are the sensations of a person dying on the gallows, you will be more ready to forgive him for his treatment to the poor foundling, whose story I am now to finish.


The bishop had a strange fancy to know whether it was not in the power of art to increase the human stature. And this unhappy orphan appeared to him a fit subject for trial. He made his essay according to



---

p.188



his preconceived theory, whatever it might be, and the consequence was, that he became seven feet high in his sixteenth year. He was carried through various parts of Europe for the last years of his life, and exhibited as the prodigious *Irish giant*. But so disproportioned were his organs, that he contracted an universal imbecility both of body and mind, and died of old age at twenty. His under-jaw was monstrous, yet the skull did not exceed the common size. But they shew a skull there, which, if the other members symmetrized, does certainly bespeak a stature more than Patagonian. It was the skull of one O'Dowd, a gentleman of **Connaught**, whose family, now extinct, were all above the common size.


In the same place, I saw the skeleton of one Clark, a native, of this city, whom they call the *ossified man*. Early in life his joints stiffened, his locomotive powers were lost, and his very jaws grew together. They were obliged, for his sustenance, to pour liquids into his mouth by a hole perforated through his teeth. He lived in this state for several years, leaning against a wall, till at length the very organs of life were converted



---

p.189



into bone. Account for this, Doctor, if you can.


**Cork** has produced some eminent men of your faculty. Dr. O'Connell wrote upon epidemical diseases in general, and upon those of **Cork** in particular. He is called by Gaubius, the Irish Sydenham; and his book is commended by Dr. Mead, both for the matter and the purity of the style. Speaking of the air, he says, Dublinii tusses catarrhales multo frequentiores & magis epidemicae sunt hyeme & autumno, imo et aliis omnibus anni temporibus, quam Corcagiae. Which he attributes to the air of **Dublin** being more impregnated with fuliginous particles.


Dr. Rogers has wrote in English on the same subject, and his work, I am informed, has considerable merit. **Sir Edward Barry**, now of **Bath**, the author of several medical tracts, particularly one on the consumption of the lungs, is a native of this place.


Smith mentions a **Dr. Lyne**, whose case was very extraordinary. For the last fifty years of his life he never glazed a window in his house; four of which he had in his bed-chamber, two on each side his bed. It



---

p.190



is remarkable, that, in all that time, nobody died in the house, till he his self was carried off, by the small-pox, at the age of eighty-five. After the windows were glazed by his son, Death became a frequent visitor.


On Sunday, I saw, dressed in his gown, a Mr. Delacour, whose appearance attracted attention. He seemed like the men of former times, and every thing about him bespoke somewhat out of the common line. Upon enquiry, I found he had in his youth, been author of several poetical pieces, which had been well received; particularly The Prospect of Beauty and The Progress of Poetry; the latter of which has undergone many impressions.


Farewell.

  
**Cork**.


The outlets of **Cork** are cheerful and pleasant; the country around the city, on both sides the river, is hilly, like that round Bath. The rides to Passage and Glanmire are charming, the acclivities being decorated with a variety of handsome seats.




---

p.191


The harbour called the Cove is one of the best in the world; the entrance is safe; and the whole navy of **England** may ride in it secure from every wind that blows. Ships of burden, however, are obliged to unload at Passage, about five miles from town, the channel not admitting vessels of above 150 tons.


It is argued, that the situation of **Cork** cannot be healthful, as it is built upon a marsh, intersected with canals, and surrounded by a large river. Yet the bills of mortality, and even the antecedent reason of the thing, prove the contrary; for the waters in these canals are never stagnant, but always rapid in their current, which communicates motion to the air, and brushes off all noxious vapours that might be supposed to arise.


The island was formerly walled in to defend it against the incursions of the neighbouring Septs, with whom it was in a perpetual warfare; it having been originally built by the Danes, whom the native Irish, to this very day, hold in detestation.


The high lands, which, on both sides the river, command the town, forbid it to 



---

p.192



be a place of any defence against cannon. Accordingly we find that after a siege of but five days, and with little or no loss, but that of the Duke of Grafton, the garrison was obliged to surrender prisoners of war, to Churchill, afterwards Duke of Marlborough, whom King William sent over upon his return to **England**, after his repulse at **Limerick**.


But if **Cork** is ill placed for resisting the calamities of war, it is happily situated for obtaining the blessings of peace, by universal commerce. It is evidently most convenient for the western world, and, what to some may appear paradoxical, it lies more advantageously for the East Indies than any of the English ports. From this fortunate situation, **Cork** has grown into such importance, as to be, one of the third-rate cities in the British empire.


If so considerable then without the aid of manufactures, what would it be with their accession? It is not, it cannot be any peculiar indolence of nature; it must be from certain ill-judged restrictions of policy that these people are not industrious. Industry is a quality almost unknown in the 



---

p.193



nascent state of rude societies; necessity calls it forth gradually as states advance in civilization. If the Americans are produced as an example to the contrary, let it be considered that those colonies never were in the ordinary state of infancy; they were, like Minerva, born adults.


Before **Lord Strafford**'s administration in this kingdom, the Irish indraped their own wool, not only for home consumption, but for the foreign market. At that time, it became the policy of **England** to make the woollen manufacture her staple; for even so late as the reign of Elizabeth, she was supplied from the Hans Towns. It was a dispute with them about certain duties, which provoked the Queen to prohibit the importation of their cloths, and thus of course set the English looms at work.


In the infancy of the manufacture, it was perhaps justifiable, upon the principles of expediency, to suppress all competition as much as possible. But, if by tying up the hands of the Irish, we have only employed those of the French; if, instead of monopolizing the market, we have furnished them with materials to supplant us at it, ought not the



---

p.194



same motives of self-interest, which prompted a prohibition of the manufacture of wool in Ireland, now prevail to encourage it?


The fact is, we have totally lost the Turkey woollen trade, and the French have got it. The French are dispossessing us of the Portugal trade also; their provisions being cheaper, they can afford double the price for Irish wool that we can, and yet undersell us. Nay, such is their demand for these raw wools, that their price is enhanced beyond the reach of the Irish manufacturer.


Till of late they used to export from hence, in spite of all prohibitions, considerable quantities of coarse camblets and other stuffs to Lisbon; but now that business is entirely over, the French having got their wool, have also got possession of the market.


It is observed, by the best writers on this subject, that the woollen manufacture in **France** rose upon the ruins of that of Ireland: her workmen, whose trade and religion were reprobated at home, betaking themselves where both found protection and encouragement. The propagation of the



---

p.195



French manufacture was doubly indebted to the decline of the Irish, first for the hands, and then for the material; it being admitted, that the French cannot work up their own wools for foreign markets, without an admixture of one-third, at least, of a different staple.


France then must have Irish wool, almost at any price; which is such a temptation to smuggling, that not all the navy of **England** can prevent it; especially, when the wool of this country is first conveyed publicly to **England**, and thence clandestinely to **France**. But what force can never atchieve, a relaxation of the navigation laws would soon effect. The Irish would then work up that wool they now export, and, by thus withdrawing the material, would speedily stop the exportation of French woollens.


Such were the considerations which suggested those excellent lines, in a late letter to the Queen, by Lord Clare; the truth of whose painting, and the force of whose reasoning, none can sufficiently admire who have seen Ireland, and weighed this subject.




---

p.196



> 1. And O! might poor IERNE hope,
>   
> In sober freedom's liberal scope,
>   
> To ply the loom, to plough the main,
>   
> Nor see Heaven's bounties pour'd in vain;
>   
> Where starving hinds, from fens and rocks
>   
> View pastures rich with herds and flocks;
>   
> And only view forbid to taste;
>   
> Sad tenants of a dreary waste.
>   
> For other hinds our oxen bleed;
>   
> Our flocks for happier regions feed.
>   
> Their fleece to Gallia's looms resign.
>   
> More rich than the Peruvian mine;
>   
> Her fields with barren lilies strown,
>   
> Now white with treasures not her own.
>   
> In vain IERNE's piercing cries
>   
> Plaintive pursue the golden prize;
>   
> While all aghast the Weaver stands,
>   
> And drops the shuttle from his hands.
>   
> Barter accurst! but mad distress
>   
> To ruin flies from wretchedness,
>   
> Theirs be the blame, who bar the course
>   
> Of commerce from her genuine source.
>   
> And drive the wretch his thirst to slake
>   
> With poison, in a stagnant lake.
> * Hence ports secure from ev'ry wind.
>   
> For trade for wealth, for power design'd
>   
> Where faithful coasts and friendly gales,
>   
> Invite the helm and court the sails,
>   
> A wide deserted space expand.
>   
> Surrounded with uncultur'd land.
>   
> Thence POVERTY, with haggard eye,
>   
> Beholds the British streamers fly;
> 
> 
> ---
> 
> p.197
> 
> 
> Beholds the merchant doom'd to brave
>   
> The treacherous shoal, and adverse wave,
>   
> Constrain'd to risk his precious store,
>   
> And shun our interdicted shore.
>   
> Thus BRITAIN works a SISTER'S woe;
>   
> Thus starves a friend, and gluts a foe,
> 




It will, I know, be argued, that, by enlarging the woollen manufacture of Ireland, **France** may lose, but **England** cannot gain, for instead of one competitor, she will have two, which is only making bad worse.


But granting it to be equal to **England**, whether she is undersold by **France** or Ireland; it is not equal to her, whether or no she recover those markets she has lost. And it is as demonstrable as any political proposition can be, that no measure can be so effectual to re-establish her at them, as admitting Ireland to manufacture her own wools. I argue thus—


Ireland can only be supposed to work up the wool she would otherwise smuggle to **France**, which is one-third of the French manufacture for exportation, and without which the other two parts could not be used for that purpose. Who then shall supply this deficiency to foreigners? Not



---

p.198



the French, for the material being withdrawn, they will be disabled to export any, consequently it will devolve on **England** to furnish the other two parts. **France** will lose the whole three, **England** regain two of them, and Ireland get but one.


To invalidate this conclusion, it will be objected, that the French may get wool elsewhere, of the same quality as the Irish. But, though this might safely be denied, we shall suppose it to be *possible;* still, it must be admitted, that they must purchase it at a higher price than at present, for if they could get it cheaper any where else, they would not deal with Ireland. Consequently, raising the price of the material to the French, will bring them more upon a level with the English manufacturer.


Thus far we have argued, as if the interests of **France** and Ireland were perfectly equal to **England**. But it should be considered, that what the Irish get, we are so far from losing, that the bulk of it finally centres with ourselves. Ireland would be as a sieve, through which the flour would pass to **England**, and the bran only remain. A distinction should be made between a



---

p.199



natural friend, and a natural enemy: for, surely, there is some difference, whether the dominions of George III. or Lewis XVI. abound with artificers, soldiers, and sailors, I name not money; for men, not money, constitute the wealth of a nation, and the strength of a crown.


The French are not only competitors, but enemies, who would first supplant us in our trade, and then annihilate us as a people. Whatever they gain is a double loss, by exalting **France** in the same proportion that it depresses **England**. In the day of distress, it may possibly be felt which is the best policy, to engage this country in manufactures, civilize it by trade, and attach it by affection, or load it with such chains of civil and religious restrictions, that the body of the people, having nothing to lose, may *hope* for better, but can *fear* nothing worse.


It was formerly the custom to allow each sailor to carry with him woollen goods, to the value of 40s. and each officer, to the value of 5l. but even this privilege is now taken away, and no resource left for industry.




---

p.200


It will be said, that there is a sufficient field for industry in Ireland, if she would but manufacture her own home-consumption, which she now imports. This, however, is, I believe, said without mature deliberation. Her home consumption is not a sufficient stimulus. The genius of trade sickens at the very thoughts of restriction, and it dies upon actual restraint. Had Ireland been prohibited the exportation of her *linens,* she would not, at this day, have manufactured sufficient for her own people: her gentry would have still depended upon Hamburgh and Holland for their shirts and shifts, as they did within the last forty years. Nay, we may venture to pronounce that if any embargo were laid upon the exportation of woollens from **England**, it would so damp the spirit of trade, that, within a century, English gentlemen would be clothed in foreign cloths.


The Irish are, however, very culpable in this affair, but the fault falls not upon the manufacturer, but the consumer. The woollen manufacture, in despite of all efforts to annihilate it, has flourished in the



---

p.201



city of **Dublin**, while it has languished every where else. But, as if the natives wished to conspire with other agents, in banishing it thence also; they scorn to wear a home-spun coat. Even an attorney's clerk must be dressed in English cloth. And such is the contempt of Irish woollens in Ireland, that it is common with the drapers to sell for English, those which are really Irish. It is the pride of the seller to deceive the buyer, and the frequency of the deception affords him flattering proofs, that the preference given to English cloth, is merely owing to the prejudice of his countrymen. And certainly the superior perfection to which they have brought poplins, some of which, called *tabinets,* have all the richness of silk, does not discover any want of genius in this line.


At first view, one might imagine this *honest* deceit to be advantageous to the woollen manufacture of **Dublin**; and it evidently must be so to that of fine cloths; yet the trade at large suffers. For instead of working up their own excellent wools into



---

p.202



frizes, ratteens, serges, and coarse broad cloths, they export their raw wool; and are supplied with those coarse goods from the north of **England**; and to complete the measure of their misconduct, they import yearly, between twenty and thirty thousand pounds value of Spanish wool, for the manufacture of superfines.


But nothing, surely, can be more injudicious, than to affect the higher, and neglect the lower branches. The same value of Irish wool, with that imported from **Spain**, would employ, at least, thrice the number of hands, and bring five times the neat profit to the kingdom. This, I conceive, should be attended to by the **Dublin Society**. That useful body, instead of giving premiums for the finest sort, should only give them for those of an inferior quality; into whose composition Spanish wool is not supposed to enter.


Upon the whole, it is hard to say, whether foreign or domestic causes operate most powerfully in wasting this fruitful country. Which, by removing unnatural prohibitions, would not only be enabled to furnish



---

p.203



a grand proportion of the supplies; but, by increasing the number of its inhabitants, would become of vast importance by reciprocal trade, and by furnishing a breed of able-bodied men for manning out fleets, and recruiting our armies.


To-morrow, I purpose setting out for **Limerick**, 


and am, &c.  
Charleville,


October 16, 1775.
This is a poor borough, about forty miles from **Cork**, and said to be midway between that and **Limerick**. The inn, though very ordinary, is reckoned a good one. It would rather indeed be wonderful if it were good, in a small town, without manufactures, situated in a country without agriculture, and where the resort of travellers cannot be great.


But *not to be worst, stands in some rank of praise,* compared to one I had just passed through, **Charleville** had an air of opulence. The village I mean is **Buttevant**, finely situated in a fine country. Here was a collection



---

p.204



of the vilest cribs, raised of dry stones, not six feet high, interspersed with the antique towers of battered castles, and august remains of ruined monasteries.


My communicative fellow-traveller **Spencer** tells me, that **Buttevant** was demolished, in the reign of Edward IV. by Murrough O'Brien, who breaking forth from Thomond, at the head of the discontented Irish, like a sudden tempest, over-ran, and laid waste **Connaught**, **Munster**, and **Leinster**; whilst O'Neil was doing the like in **Ulster**. He soon created himself king, and was called king of all Ireland, as Bruce of **Scotland** had done in the reign of Edward II.


From **Cork** to Mallow there is very little natural or artificial decoration, except in the neighbourhood of a poor village, where the ruins of a spacious Abbey in a valley, and of a proud little castle on the brow of a hill, are still to be seen. There some venerable oaks stretch their long arms across the road, and from thence wind down a romantic glin, in view of a new house of a good appearance.


The situation of Mallow is charming, it lies on this side of the Blackwater, the



---

p.205



other side being mostly occupied by gentlemen's seats, richly planted, and neatly dressed. At the end of the town is an old castle, which, with the town, belongs to a Mr. Jephson, kinsman to my kind hostess at **Tipperary**. It is a borough-town, the balcony windows of which, betray all the symptoms of decay. Without manufactures, it subsists by the precarious trade of letting lodgings. It has a tepid spring, which is said to be a sovereign restorative; but of late years it has been deserted in favour of Bristol, where if the waters are not better, it must be allowed that the accommodations are.


When at **Mallow** I was within thirty miles of **Killarney**, which by all accounts is one of the finest scenes in Europe. Volumes have been written in its praise, but the subject seems to be inexhaustible. I saw at **Mr. Baker**'s, in a manuscript ready for the press, a very poetical description of it, though in prose, and it has lately been celebrated in verse by a Mr. Leslie.


You will say, I am dead to curiosity that could pass it by; but consider, my dear friend, that the season is now far advanced,



---

p.206



that travelling is not here as in **England**, that roads little frequented, but by curiosity, though said to be much improved, can neither be very good, nor the beds free from dampness, which of all things most sensibly affects a valetudinarian.


I am even unmoved by the consideration, that this is the landskip month; especially in this country, where the leaves stick longer on the trees than more eastward. I shall content myself with Mr. Fisher's views. My object being not so much to see places and things, as men and manners.


On this road I met an Irish funeral, one or two of which I had seen before, but this one might have proved fatal to me, for I met it unexpectedly in turning a corner, and no sooner did the mourners see me, than they set up a yell which frightened my horse not a little. The cry, however, which had been originally raised on my account, ceased at sight of my danger; but the girls, who set it up, could not help laughing at my situation.


It is the custom of this country to conduct their dead to the grave in all the parade they can display; and as they pass 



---

p.207



through any town, or meet any remarkable person, they set up their howl. A gentleman and his servant were, it seems, thought to deserve this compliment.


Being now out of danger, I can calmly inquire into the antiquity of this custom. **Spencer**, so often mentioned, says that it is heathenish, and proceeds from a despair of salvation. But, whether the custom originates from hope or despair, it is certainly very antient, and has been praised by the Hebrews, Greeks, and Romans. ‘Call for the mourning women, that they may come,’ — ‘man goeth to his long home, and the mourners go about the streets,’ — ‘we have mourned unto you, but ye have not lamented,’ say the inspired writers.


It was formerly usual to have a bard to write the elegy of the deceased, which contained an enumeration of his good qualities, his genealogy, his riches, &c. the burden being, *O why did he die?* As thus, *O, why did he die!* who was so worthy to live? He who sprung from the noble blood of Heber, the son of Gallum, that gallant chief! — *O why did he die* who



---

p.208



was blessed with a wife, fairest of the daughters of Scota, a wife who lives only to deplore his loss! *O why did he die* before he could see his sons glorious in the field, and his daughters happy in their loves! *O why did he die* who had every means of life; whose numerous beeves browsed on the lawn, and whose sheep whitened the hills! *O why did he die* who was lord of the golden vale! O ye, the objects of his bounty, his vassals loving and beloved, why — why did ye not snatch him from death, who so often led you to glory, and brought you home laurelled by the hand of victory! &c. &c. The women then took up the rueful ditty, and sung it with lamentable accents, which, from imitation of the sounds, are sometimes called Oghunano, and Hullaloo, and from the repetition of *O why did he die,* Ogh-agus (*Agus* signifying *and*). It is also called Keenagh, but for what reason I do not know.


As these elegies are now composed by unlettered men, they must appear ridiculous enough. Though the band of criers which I heard, made no very musical dirge of it, it was certainly calculated to inspire



---

p.209



melancholy. That the custom may be ennobled by a more elevated strain, the last book of Homer must evince; where, we see around the corpse of Hector, his wife, his mother, and his sister, who, as the natural mourners, alternately speak his several praises, while the artificial mourners act the second part.



> 1. A melancholy choir attend around,
>   
> With plaintive sighs, and music's solemn sound;
>   
> Alternately they sing, alternate flow
>   
> The obedient tears, melodious in their woe.
>   
> While deeper sorrows groan from each full heart,
>   
> And Nature speaks at every pause of art.
> 




The *conclamatio* among the Romans coincides with the *Irish cry*. The *mulieres praeficae* exactly correspond with the women who lead the Irish band, and who make an outcry too outrageous to be the effect of real grief;

> 1. Ut qui conducti plorant in funere, dicunt
>   
> Et faciunt prope plura dolentibus ex animo —
> 




That this custom was Phoenician, we may learn from **Virgil**, who was very correct in the *costume* of his characters. The  over the Phoenician Dido, as



---

p.210



described by him, is similar to the Irish cry.

> 1. Lamentis gemituque &: foemineo ululatu
>   
> Tecta fremunt. —
> 




The very word *ululates,* or *hulluloo,* and the Greek word of the same import, have all a strong affinity to each other.


The series of ceremonies used on the night, or nights, that the corpse remains unburied, is what they call a *wake*. At these wakes the Criers, or Keenaghers, sit round the corpse, which is stretched on a bed or board, covered with white linen; a plate of salt being placed over the heart. The salt, I suppose, they consider as the emblem of the incorruptible part, the body itself being the type and subject of corruption.


These wakes are meetings of merriment and festivity, to which they resort from far and near. The old people amuse themselves in smoking tobacco, drinking whiskey, and telling stories in the room with the corpse; whilst the young men, in the barn, or some separate apartment, exhibit feats of activity; or, inspired by their sweethearts, dance away the night to the



---

p.unnumbered




---

p.unnumbered




---

p.211



melodious *pleasing* of a bagpipe; — thus enjoying as solid pleasures as their betters at courtly balls or midnight masquerades. I am, however, sorry to add, that such is their passion for carousals, on these occasions, that the survivors have been sometimes beggared by the expence.


I have heard of an old woman, who, having gathered a few guineas, chose to beg rather than break in upon this sum, which she had hoarded up, in order, as she expressed it, to have herself buried *decently*. This decency for which she was so anxious, was, that the neighbours might be regaled, with plenty of whiskey and tobacco. So much for the Irish cry!


  
**Limerick**,

 October 20, 1775.
Leaving **Buttevant**, I thought the ne plus ultra of human wretchedness was then passed, but **Kilmallock** was before me. Had such scenes presented themselves on leaving **Dublin**, curiosity might have proved too weak an incentive to proceed;



---

p.212



I should have turned back again, to avoid the sight of misery, which I could not but feel, without being able to remove.


I had been told at **Charleville**, that the next stage was **Bruff**, and there I purposed to breakfast; but after riding a few miles, and staring at a sight so unusual as a well planted park, I unexpectedly turned through an arch, under an old castle, into a spacious street, composed of houses, which, though magnificent, were windowless and roofless.


An inn was a found unknown here; I got, however, a stable for my horses, and a room for myself, where, I suppose, a fire had not been kindled since the last election; for these ruins send two members to parliament. Sheds were raised, within these noble structures, too nasty for the habitation of English pigs. Happy would it be for Ireland, if her corporate towns were divested of the privilege of returning representatives to the great council of the nation; for it becomes the selfish policy of the lord of the soil to impoverish the voters into compliance.




---

p.213


**Kilmallock** must be a place of high antiquity. It is reported to have been a walled town before the English got footing here. **Sir James Ware** relates, that an Abbey of Dominicans, or Black Friars, was built there in the thirteenth century by the sovereign, brethren, and commonalty. It formerly gave title to an Earl, and preserves a greater share of magnificence, even in its ruins, than any thing I had yet seen in Ireland. I call it the Irish **Balbeck**.


There was something so picturesque in the perspective of this place, that I could not help attempting to delineate it. I send you my essay done, as you see it, in less than an hour; I must, however, remark to you that I began upon a scale too large for my paper, and was not able to take in the whole town.


There is but one street now standing entire; but from some scattered piles, and from the foundation of others, there is reason to suppose that there have been more. The walls round the town, which in many places still remain, are of an oblong square. At each angle has been a castle, like those under which the traveller passes, at the ends



---

p.214



of the remaining street, and which you may trace in my sketch. One of these is the jail of the city. What must you think of the jail of **Kilmallock**, which is itself the most dreary of all prisons? The religious houses which you may remark in the foreground have been stately,

> 1. Where my high steeples whilom used to stand.
>   
> On which the lordly Faulcon wont to towre,
>   
> There now is but an heap of lime and land.
>   
> For the screech-owl to build her baleful bowre.
> 

[18](javascript:footNote('E770001-002/note018.html'))


This town was abandoned by the Irish, during the last siege of **Limerick**, and fitted up by the English as a magazine for stores. It is conjectured, that *Kil-malech* was the original name. **Bochart** speaking of the Tyrian Hercules, or Melcartus, says, that Malech-cartha, signifies the king of the city, and **O'Connor** says, that Mal-Kathrach is of the same import in Irish.


As you approach **Limerick**, the grounds grow rich, and exquisitely beautiful. Several thorn-hedges, and some plantations of forest trees, were a greater luxury to my eye, than any other part of **Munster**: yet the lands were mostly occupied by black cattle, as **Tipperary** was by sheep.




---

p.215


Within a century, **Limerick** was reckoned the second city in Ireland. At present it does not seem to be half as large as **Cork**. It has lost its rank, not because it thrives less, but because **Cork** thrives more for it is in so flourishing a state, that it has taken the lead of **Galway** and **Waterford**.


**Boate**, who wrote about a hundred years since, arranges the Irish cities in the following order: **Dublin**, **Galway**, **Waterford**, **Limerick**, **Cork**, and **Londonderry**. As to the other towns, he says, the best of them, which are **Drogheda**, **Kilkenny**, **Belfast**, &c. are hardly comparable to those market-towns which are to be found in all parts of **England**. But how greatly must this order be now deranged, when it is universally believed, that the third town, in trade and consequence, is **Belfast**. In extent also, it comes next to **Cork**, for it has 5295 houses, **Limerick** but 3859, and **Waterford** 2628. It is remarkable, that **Newry**, a town not so much as named by **Boate**, has now more trade, houses, and people, than **Galway**.


**Limerick** is composed of what is called the Irish and the English town. The latter



---

p.216



stands upon a piece of ground called the King's Island, formed by the **Shannon**, which divides itself a little above the city. Both towns, in their ancient state, consisted of one long wide street, well built, cut at right angles by many narrow lanes, in form of a comb with a double row of teeth. I wish it less resembled the comb unbrushed.


The English and Irish town seem pretty much alike in their buildings, and are united together by an old bridge, called Baal's. On the same arm of the river, communicating with the quays and the new streets, is an elegant bridge, lately built, of three arches; the middle one, of a span of forty feet, admits boats under sail. The third bridge, thrown over the greater arm of the river, is called Thomond's, and, though consisting of fourteen arches, is said to have been built for *thirty* pounds. Thomond's and Baal s together are not as wide as the fourteen arches of Westminster-bridge. It must therefore be far below **Limerick** that this rapid river can answer the description given of it by **Spencer** —

> 1. The spacious **Shannon** spreading like a sea.
> 

[19](javascript:footNote('E770001-002/note019.html'))




---

p.217


The narrowness of the streets must, I suppose, be attributed to its being an old fortress; and that it was a strong one, the repulse which King William met with there in 1690, and the honourable capitulation it made the year following, incline me to believe. Notwithstanding, **Lausun**, to whom King James intrusted the conduct of his army in Ireland, to the great prejudice of his own interests in the court of **France**, declared, upon viewing the fortifications, that his master would take it with roasted apples; and accordingly withdrew his men from it, as untenable: yet **Sarsfield**, the Irish general, undertook its defence, and held it out against the victorious army of the **Prince of Orange**.


But it is a place fortified by nature; for, without the annoyance of circumjacent hills, it is built upon an island, encircled by a strong barrier, the arms of the **Shannon**. It is now happily dismantled, and scarce a trace of its old walls and seventeen gates are to be seen. The substitution of spacious quays and commodious houses, in place of lofty battlements and massive bastions, has given it a thorough and healthy ventilation. **Limerick**,



---

p.218



like **London**, was formerly and frequently visited by the plague; but the effect has here also been removed by the removal of the cause.


They are under great obligations to their present representative **Mr. Pery**, who has obtained several large sums from parliament, for building quays, and for other improvements of the city; and they are not ungrateful, for he is held in high respect among them, as indeed he is in every other place where I have heard him spoken of, he being esteemed one of the ablest Speakers that ever sat in the chair of the Irish house of commons.


I can easily believe that the women here deserve their celebrated character for beauty; for I have seen great numbers of pretty faces in the streets and public walks, in general, the common people, too, are of a very comely personage. The streets are always crowded with them; having no staple manufacture to employ them, they walk about, like the sluggard, *with their hands in their bosom.* They once had a manufacture of serges, but that is nearly extinct. They are, however, famous for making



---

p.219



gloves; and some northern soldiers, who have been discharged here, are giving birth to the weaving of linen.


A few years ago the town stood on sixty-four acres of ground; now it covers one hundred, equal to 160 of our measure. The ships in this port trading to **London** are increased from one to twelve in number and the revenues have been augmented from 16, to 40,000 pounds yearly. By cutting canals opposite to the shallows and rocks in the river, it will be rendered navigable to **Carrick**, in the county of **Leitrim**, a space of ninety miles up the river, which will open a conveyance for grain, timber, iron, coals, turf, &c. and must at length turn the channel of trade in those parts hither. The good effect of a very short cut, made near the town, is already sensibly felt; for sea-coal, which was formerly their fuel, is so disused, that its price is much lowered; turf, the material and *manufacture* of which is all their own, now supplying their hearths.


This navigation of near 200 English miles in length, by communicating with that leading from **Dublin**, through the Bog



---

p.220



of Allen, must, in time, make **Limerick** one of the most considerable places for importation in the kingdom. Such large tracts of country on both sides the river, cannot fail of creating a large demand. The same cause may operate upon the exports, by rendering so easy the conveyance of beef, butter, hides, tallow, grain, &c. to the seaport. Though the town is sixty miles from the sea, ships of 500 tons come up to the quays.


You may judge of the state of agriculture, in this neighbourhood, from a prevailing maxim, that their lands are so rich, they are obliged to throw their dung into the **Shannon**. I wish, however, they would throw it any where out of the streets. The old Milesian manners prevail more here, than in any place I have yet visited. At night, as you pass along, you may hear the bagpipe squeaking in every alehouse. And from the number of backgammon tables to be seen at the coffee-houses, one may conjecture what are the amusements of these good citizens.


Colonel Parr, commander of the garrison here, a very accomplished gentleman, from



---

p.221



whom I have received great civilities, remarked to me, that in **Spain**, where he spent a considerable time, he observed many customs which put him in mind of his native country; and that now **Limerick** reminds him of **Spain** more than any other place.


There are here three churches. The cathedral is a massive Gothic pile, with a good ring of bells, and some monumental decorations. The custom-house is a very elegant modern structure; the pediment is supported by fluted pilasters; the front has but five windows in a row, yet including the colonnades, the whole elevation is near two hundred feet.


Our accomplished and facetious friend, Day, of the Middle Temple, is the son of an eminent physician of this city. I hope he will have obtained, before I return, that fine appointment in the East Indies, which is laid out for him; and which, I am sure, he will fill with much credit to himself and advantage to the company.


This country, though reckoned the dampest part of the kingdom, furnishes as 



---

p.222



many instances of longevity as any other. Near **Glin** is now living one Kelly, aged 120, who is said to be so upright and straight in his limbs, as to walk several miles every day. They mention a woman much older at **Shanagoldin**, whole eyesight is so good, that she employs herself in knitting; and of an habit so lively, that she danced lately at the wedding of one of her great-grandchildren. They give you the names of women who bear children after the age of three-score. But the truth of these accounts I neither affirm nor deny. May we live happily whilst we live; for 

> 1. Aetatem Priamique Nestorisque
>   
> Longam qui putat esse, Martiane,
>   
> Multum decipiturque, falliturque.
>   
> Non est vivere, sed valere, vita.
> 

[20](javascript:footNote('E770001-002/note020.html'))




---

p.223


  
**Limerick**.


The morning after I came here I called on **Mr. O'Halloran**, who, to an established reputation for his writings on *Amputation*, adds a commendable zeal for the honour of his native country. Upon the antiquities of which he has published a quarto, and is now engaged in something farther upon the same subject.


Ireland has a very just claim to the most remote antiquity, which is sometimes called in question by being stretched too far. People are apt to reject even truth, when they see it so intermixed with falsehood, that it requires labour to separate them. The polite and hospitable reception, I met with from this learned gentleman, interests me in the success of his work; and therefore I cannot help expressing a wish, that he may make a nice discrimination between the unknown, the fabulous, the obscure, the enlightened, and the historical times.




---

p.224


Though Mr. O'Halloran and I could not perfectly agree in all points, his conversation was of advantage to me, and his books were of great use in my disquisitions upon certain remains of antiquity, which had fallen in my way. My first object of research was a Druid temple, on this side of Bruff, on the road hither, of which fort there are many still remaining in Ireland.


Druidism was the religion here before St. Patrick, who is said to have burned near two hundred books of it in one fire. The Druid temples were circles of unhewn stones, set on end, varying in their size and number according to the diameters of the circles. That which I saw had but twelve, and the stones were from five to eight feet high, in a circle of twenty feet diameter. But we are not to infer any extraordinary want of civilization from the uncouthness of the idol. The origin of all idolatry is almost the same. The old Greek Mercury was not that winged herald now represented, but a square stone: nor was Bacchus more shapely. Before Dedalus, unhewn stones were worshipped by all **Greece**. He it was



---

p.225



who first divided the block into members and limbs; and, because he formed statues with legs, it was feigned that he imparted to them life and motion.


Long after carved images were common among other nations, the Persians adhered to their old mode of worship, and ridiculed the Greeks, for supposing the Gods to be of human shape. Maximus Tyrius says, that the Arabians worshipped he knew not what God, for all the statue he saw of him, was a square stone; and, according to him, the Paphian Venus was represented by a whitish pyramid. If then the transcendent beauty of the Medicean Venus, and the more than human of the Belvidere **Apollo**, do somewhat dignify the modern idolatries of **Greece**, this should rather be ascribed to the perfection of art, than to the refinement of worship.


The same may be said of Rome, the original idols of which must have been unchiseled stones, for it was an oath there, Per Jovem lapidem. When a plague raged in the consular army, and when the more dreaded Hannibal spread a panic to the very heart of the Imperial city, it was found, in 



---

p.226



the books of the Sybils, that a plague might be stayed and a foreign enemy expelled **Italy**, if the *Idean Mother* were brought from Pessinus. The Pythian **Apollo** confirmed the Sybilline oracles. A pompous embassy is dispatched to Asia, and, as the Romans had no social cities there, the intercession of Attalus, King of Pergamus, is, by the advice of the Tripod, requested and obtained. This great King goes to Pessinus, succeeds in his suit, and delivers the mighty boon; — a rude stone, which the natives called the Mother of the Gods: Lapis erat quem matrem Deorum incolae dicebant, accepit Scipio Nasica, vir optimus a Senatu judicatus.


The destruction of Corinth, to be sure, brought into disrepute these stony symbols of Divinity; for, after that event, we hear the Roman patriots wishing, that their fine new Gods may prove as propitious as their old ill-shapen ones. It is not however to be doubted, but that they had some clumsy statues before that aera; which only serves to shew the progression of idolatry, from rough to hewn stones, and from hewn stones to images, formed ad unguem. But it is more to our purpose to remark, that Pessinus, being a city of Galatia, derived this



---

p.227



superstition from the Celtae. Druidism seems to have been co-extended, if not with all the Gaulish race, at least with all who retained the dialect.


But the worship of rude stones was not confined to the Celts, or their descendants; for **Pausanias** relates, that round the idol of Mercury, ‘there were thirty stones, each of which the Pharii worshipped and called Gods.’[21](javascript:footNote('E770001-002/note021.html')) **Pliny** supposes, that the Druids were masters of the Persian Magi; and magic in the Irish language is called *Druidion*. Herodian, describing the worship of Heliogabalus, at **Emesa** in **Phoenicia**, says, ‘that he saw no kind of image fashioned by man's hands, but a great stone, roundish at bottom, and diminishing towards the top in a conic form.’ In my rides through this country, I have seen two of those stones, in form of a truncated cone, answering in all respects to this description. Thus it should seem, that the Irish had Druidism handed down to them both by their Celtic and Phoenician ancestors. And from **Hector Boetius** we may learn, that the Scots had it, in like manner, from the Irish: for he relates, ‘that the son of Fergus set up



---

p.228



great stones for temples, and one in the midst for an altar.’[22](javascript:footNote('E770001-002/note022.html'))


Those concentrical circles of stupendous rough stones in Salisbury Plain, are nothing more than a Druid temple, upon a great scale. It is curious enough to hear **Inigo Jones** labouring to prove **Stonehenge** to be a Roman structure; and it is equally so, to hear **Geoffrey of Monmouth** report, that the **Stonehenge** obelisks were transported there from Ireland. Yet on this tradition does **Alexander Necham**, a poet of the middle age, ground the following lines.

> 1. Hoc opus ascribit Merlino garrula fama,
>   
> Filia figmenti fabula vana refert.
>   
> Illa congerie fertur decorata fuisse
>   
> Tellus quae mittit tot Palamedis aves,
>   
> Hinc tantum munus suscepit Hibernia gaudens.
> 


[23](javascript:footNote('E770001-002/note023.html'))
The moral of this fable, if it has any, seems to be, that Druidism was introduced into Ireland from Scythia, and into **Britain** from Ireland. One of the first colonies which peopled Ireland was called Belgae, and Salisbury Plain is in the country of the Belgae. From hence, one would think, that the Irish Belgae were older than the British.


Near these Druid temples generally stands an odd sort of altar, called Crom-liagh, or



---

p.229



Inclined stone. The height of the cover stone is seven feet, the length of the inclined side ten, and its circumference twenty-eight feet. How this stone could, without the aid of mechanic powers, be raised upon the six pillars that support it, is not easy to be conceived; yet this difficulty vanishes when compared with that of raising the transverse blocks of ***Stonehenge**,* or the cover-stone of a Crom-liagh described by **Chevreau**. *La pierre levée de Poitiers a soixante pieds de tour, & elle est posée sur cinque autres pierres, sans qu'on sache non plus, ni pourquoi, ni comment.’’*

Chevreau, Mem. a Angl. 380 ap. Toland

 Now, supposing them to be similar figures, the Irish is not an eighth of the French; and, which is remarkable, this stone is called by the natives *Clogh-togle,* that is, pierre levée, the Lifted stone.


A whimsical circumstance relative to these Crom-liaghs I cannot omit. They are called by the ignorant natives *Granie's beds*. This Granie is fabled to be the mother of Finmacoal, or Fingal; and of her, as well as of her son, they have wonderful traditions. I have heard songs in her praise, and was shewn, in a stone, the mark of her foot, and have heard an huge rock called Finmacoal's finger-stone. The source however of the appellation of Granie's bed, I conceive to



---

p.230



be a corruption of the original Irish name of these altars. Grineus is, we know, a classical name for **Apollo**. In **Camden**'s Lauden, we meet with an inscription, "Apollini Granno:" and Grian is a common name for the Sun in Irish.


Another sort of Druid remain, which I have heard described, but have never seen, is called the *Rocking Stone,* and served as an oracle.[24](javascript:footNote('E770001-002/note024.html')) A stone was so placed, on the top of another, that the smallest force would shake it; and it was supposed to be self-moved at the presence of a guilty person. This was one of those delusions by which the Druids kept the people in awe, and acquired that amazing influence which they had over them. They affected to wrap every thing in the veil of mystery, and had their most solemn meetings shrouded from the public eye. The depths of caves were their secret haunts; and the brown horror of oaken groves cast an awful shade on their public exhibitions. The badges of their



---

p.231



profession too, the white linen robe, the straight wand, the long flowing beard, all contributed to inspire a reverence, which their knowledge of calculating eclipses effectually confirmed. They were supposed to have immediate intercourse with the stars, and to be the only interpreters of the will of Heaven. This credit gave them high pretensions. They became not only priests but prophets; and to both was added the judges office.


To keep up their character with the vulgar, ever born to be duped, they used this rocking-stone; which, like other oracles, would not give responses displeasing to the priest — of the Oak — whose wand could give it the seemingly spontaneous motion. Yet we find, that all the address of the order was unable to screen their impostures from the public eye; and there were not then wanting some who appealed from the Arch-Druids infallibility, as now from the Pope's.


The influence of the Druids being founded not on power but authority, not on property but opinion, the preaching of St. Patrick soon demolished their credit; and



---

p.232



therefore the Irish writers boast, that the conversion of this country was not, as elsewhere, sealed with the blood of martyrs.


It is not strange that many Druid remains should still exist; but it is a little extraordinary that some of their customs should still be practised. They annually renew the sacrifices that used to be offered to **Apollo**, without knowing it. On Midsummer's eve, every eminence, near which is a habitation, blazes with bonfires; and, round these, they carry numerous torches, shouting and dancing, which affords a beautiful sight, and at the same time confirms the observation of **Scaliger**, *En Irlande, ils sont quasi tous Papistes, mais c'est Papautè meslée de Paganisme, comme partout.’’*


Though historians had not given us the mythology of the Pagan Irish, and though they had not told us expressly that they worshipped Beal, or Bealin, and that this Beal was the Sun, and their chief god, it might nevertheless be investigated from this custom, which the lapse of so many centuries has not been able to wear away.




---

p.233


The Sun was propitiated here by sacrifices of fire: One was on the first of May, for a blessing on the seed sown; the next, at Midsummer, for ripening the fruits of the earth; and a third, on the last day of October, as a thanksgiving for harvest home. The first and the last of these are entirely dropped; but that on Midsummer's eve is, as I have said, duly celebrated to this very hour. I have, however, heard it lamented, that the alteration of the style had spoiled these exhibitions; for the Roman Catholics light their fires by the new style, as the correction originated from a Pope; and, for the very same reason, the Protestants adhere to the old.


The first of May is called, in the Irish language, La Beal-tinne; that is, the day of Beal's fire. **Vossius** says, it is well known, that **Apollo** was called Belinus; and for this he quotes Herodian, and an inscription at **Aquileia**, *Apollini Belino.* The gods of **Tyre** were Baal, Ashtaroth, and all the Host of Heaven, as we learn from the frequent rebukes given to the back-sliding Jews for following after Sidonian idols: and the Phoenician Baal, or Baalam, like the



---

p.234



Irish Beal or Bealin, denotes the Sun, as Astharoth does the Moon.


**Mr. Wood**, an ingenious writer of this country, is of opinion that **Balbeck** in Coelo-Syria, of which he has given the ruins, is the same with **Heliopolis**. He argues not only from the situation, but the name; **Balbeck**, according to him, signifying, the temple or city of the Sun. And he thinks, that the Syrian Belus, the Heliopolitan Jupiter, and the Delphic **Apollo**, are one and the same deity.


From the fire-worship of Beal several places in Ireland have got their names, as Bealtine, **Mullaghtine**, **Bealtinglass**, &c. And the highest mountains have generally, on their summits, prodigious conical heaps of stones, called *Carns*. That these heaps were altars, on which the fires were burned, seems probable from the manner in which the Celts paid their adorations to this god. 


> 1. Dum pius Arcitenens incensis gaudet acervis.
> 

[25](javascript:footNote('E770001-002/note025.html'))
**Virgil** puts this matter in the clearest light, for he shews us how the Sabines, a people descended from the Celts, worshipped **Apollo**,



---

p.235



their chief god, upon the mountain Soracte, by fires burned on stone heaps, 

> 1. Summe Deum, sancti custos Soractis, **Apollo**
>   
> Quem primi colimus, cui pineus ardor acervo
>   
> Pascitur —
> 



From the close affinity of customs between kindred tribes, there is scarce room to doubt, that the Celts of Ireland made the same use of these Carns as their brethren in **Italy**. This hypothesis is confirmed by the following considerations.



Kárneios was an epithet of **Apollo**; but whence he obtained it is not agreed among the critics. It is probable that it was a Celtic, and consequently barbarous, word, introduced into the Greek language, at the same time that the Carnea were introduced into **Greece**. These Carnea, we know, were **Apollo**'s festivals in May, which month was called Carnius. What makes this argument of moment is, that Berosus, the Chaldean, says, the Greeks borrowed their learning, and their very letters from the Gauls: and **Diogenes Laertius**, who, in the body of his work, is for making the Greeks inventors of all arts and sciences,



---

p.236



admits, in his proem, that the Druids taught their barbarous theology and philosophy anterior to them.


There is something in the very situation of these Carns which favours the argument of their being altars for sacrifices to **Apollo**. For the most lofty eminences were originally chosen for the celebration of religious rites, and therefore we find in scripture so many rebukes given to the Idolatries in *high places.* Homer commends Hector for his many sacrifices on Mount Ida; and **Tacitus** gives the reason why such situations were fittest, as being nearest to heaven; ‘Montes maxime caelo appropinquari, precesque mortalium a Deo nusquam proprius audiri.’


But you begin to say, whither does this *farrago* of quotation tend? I want to shew you, that the Irish are still in posession of certain customs utterly relinquished by the other nations of Europe; which peculiarities, being coeval with the earliest written memorials of mankind, confirm the opinion of **Spencer**, that they are at least among the most ancient people in this end of the world.


Good Night.




---

p.237


  
**Limerick**.


What is it that makes one nation more antient than another? Is it any thing more than this, that the present race of inhabitants have been longer in possession of their country, than the others have been of theirs? And it cannot be argued that any nation is more antient than that which has so long occupied its present territory, that no time can be pointed out in which it was not in possession. In this predicament stands Ireland. No man can point out the period when the present race was not in possession.


The zealous champions of Ireland may perhaps think, that I pay her but an ill compliment in proving her antiquity, from her adherence to certain heathenish customs. Antiquities, however, of whatever sort, ought carefully to be gleaned up, especially where they are the chief materials for the history of the most early periods. There 



---

p.238



can be no other, except tradition, before the use of letters.


The authority of tradition, according to **Sir Isaac Newton**, is not to be depended upon for above 100 years. At what time letters were first introduced here, cannot, I conceive, be ascertained. The learned **Mr. O'Connor** admits, that the writing upon vellum was not in use till the time of St. Patrick. All antecedent transactions were inscribed, in very aukward characters, upon tables of wood, called *taible filea*.


It does not add to the credit of the antient history of Ireland, that it dwells so circumstantially upon the migrations of the Gadelians, from Scythia, through **Egypt**, **Greece**, **Spain**, &c. and yet touches so lightly upon the events of the subsequent periods. The accounts of the times preceding the Irish apostle, are but copious genealogies, or, at best, meagre annals. They tell you, indeed, that a battle was fought in such a spot, and thousands slain; that such a prince, slew such a king, and reigned in his stead; and this is all the information



---

p.239



they give. There is no variety of events, no consecutive series of action, no motives to war, or inducements to peace, but the adultery of some queen, the rape of some virgin, or the murder of some chief. In fine, there is no exemplary morality, no colour of just history.


However, therefore, the indigenal antiquarians of Ireland may declaim on the refinement, politeness, and civilization of their ancestors, candour must make great abatements, upon the review of facts. When we read of the castles of their kings, and the number of Nobles and Knights they entertained in their halls, with their long suite of Bards, Genealogists, and Musicians, we are astonished with an idea of magnificence; but on a nearer approach, these castles — raised like those in romance — shrink into occasional structures of hurdles and scrolls.


It is true, that antiquity and stone buildings are not necessarily connected. Yet it is hard to conceive how written monuments could have been *well* preserved without them. The several *Psalters,* as they call them, which contain the most early



---

p.240



and authentic documents of Irish story, were all denominated from the houses in which they were preserved. **Scotland** would at this day be without a written monument of antiquity, antecedent to the ravages of Edward I.*,* if some remnant had not been saved in the Abbey of **Hy Columbcill**.


It is no disgrace to any country, that the early periods of its history are involved in obscurity; nor are the Irish singular in having discoloured theirs with fable. The French have forged their Francus, as the founder of their name and nation; the Danes their Danus, the Saxons their Saxo, and the Britons their Brutus. Olaus the father wrote two whole folios to prove that Scandinavia was the original globe, where the first men, and the golden apples of the Hesperian gardens grew, with guardian dragons[26](javascript:footNote('E770001-002/note026.html')). Olaus the son has employed a good quarto, in shewing that the Lappish tongue may be traced up to the Hebrew; and that the country is, at this day, the most comfortable portion of the globe to live in, as producing *honester men,* and *better strawberries,* than the finest parts of **Italy**.




---

p.241


The historians of this country should follow the example of **Livy**, who fairly owns, that he can say nothing with certainty, of the origin of the Romans. By magnifying their antiquities, and by dwelling chiefly upon a *millennium,* at least, before the vulgar aera, they bring in question, narrations of a more modern date, with such as have neither time nor patience to discriminate truth from falsehood.


On the other hand, the readers of Irish history should not rashly involve it all under the same censure. There is truth in the histories of Arcadia and Attica, though the people of one country boasted of being earth-born, and of the other, that they were prior to the moon. We must not disbelieve that **Calisthenes** sent agronomical observations from **Babylon** of above nineteen hundred years standing, because the Chaldeans vaunted of having observed the stars for 47,300 years. Nor must we doubt that the Chinese are a very antient people, because they vainly reckon many thousand years before the Mosaic aera of creation. The degree of credit due to the traditional songs of the Bards, may be measured from the following story, told by **Gibson, bishop of **London****, who translated **Camden**'s 



---

p.242


Britannia. *A blind harper sung to his instrument an Irish song, which the bishop of Derry, curious to learn the meaning; of, got translated into English. It announced, that in a certain place was buried the body of a prodigious giant, on whose breast was a broad plate of pure gold, and rings on each finger of the same metal. The bishop had resolution enough to try if there was any truth in the narration, when, lo! upon opening the ground described, the body of a man of common size was found, reduced to ashes, with a small plate of gold which had been on his breast, but there were no rings to be seen.’’*

 It is pretty remarkable that the body of our Arthur was found almost in the same manner.
As the Irish had the use of letters, long before they wrote upon vellum, it is not to be doubted, that the reigns of their kings were exactly enough registered, before that improvement in the fifth century. The whole texture of their history shews the utmost attention to their genealogies; the **Gavelkind**, or Law of inheritance, absolutely requiring an exact knowledge of descents. An order of men, called *Senachies* were set apart for this study, and had certain lands assigned for their support. **Camden** enumerates several officers of each chief,



---

p.243



who enjoyed such hereditary demesnes. 
  

*Habent enim hi magnates suos Juridicos, quos Brehones vocant; Medicos, Poetas, quos Bardos vocant, & Citharaedos. Et certae & singulae familiae, viz. Brehones unius stirpis & nominis, historici alterius, & sic de caeteris, suos liberos, sive cognatos, in sua qualibet arte, erudiunt, & semper suos successores habent quibus singulis sua praedia assignata sunt.’’*


This is no ideal institution, for, long after the English got possession here, it was in full vigour; and several acts have been made, from time to time, to abolish the establishment, and thereby annihilate the influence of the Bards; who, by their songs, were supposed to stir the people up to rebellion. The following translation of an Irish poem, minutely describing the *etiquette* of the monarch's court at Teamor, may not be unworthy your perusal.

> 1. Ten royal officers for use and state,
>   
> Attend the court, and on the monarch wait.
>   
> A *nobleman,* whose virtuous actions grace
>   
> His blood, and add new glories to his race.
>   
> A *judge,* to fix the meaning of the laws,
>   
> To save the poor, and right the injur'd cause.
>   
> A grave *physician,* by his skilful care,
>   
> To ease the sick, and weaken'd health repair
>   
> A *poet,* to applaud, or boldly blame.
>   
> And justly give, or infamy, or fame,
> 
> 
> ---
> 
> p.244
> 
> 
> For without him, the freshest laurels fade.
>   
> And vice to dark oblivion is betray'd.
>   
> The next attendant, was an holy *priest,*
>   
> Prophetic fury roll'd within his breast:
>   
> Full of his God, he tells the distant doom,
>   
> Of kings unborn, and nations yet to come;
>   
> Daily he worships at the sacred shrine,
>   
> And pacifies the Gods with rites divine;
>   
> With constant care the sacrifice renews.
>   
> And anxiously the panting entrails views.
>   
> To touch the harp, the skill'd *musician* bends,
>   
> And o'er the strings his nimble hands extends.
>   
> The sweetest sounds flow from each trembling string,
>   
> Soft as the breezes of the breathing spring.
>   
> 'Tis music's lot the passions to controul,
>   
> And tune the harsh discordance of the soul.
>   
> The *antiquary,* by his skill reveals,
>   
> The race of kings, and all their offspring tolls.
>   
> The spreading branches of the royal line,
>   
> Traced out by him, in lasting records shine.
>   
> *Three officers* in lower order stand.
>   
> Who, when he dines, attend the king's command.
> 




The very texture of this poem shews it to have been written in the days of Paganism, for the priest therein described is a Druid. They fix the date of it in the reign of Cormic O'Conn, father-in-law to Finn, the son of Comhal, who re-established the *Fes of Tarah,* in the beginning of the third century.


There is yet another remnant of antient heathenism, which, belonging to the subject



---

p.245



of antiquities, I must not pass over. If a person dies accidentally upon the road side, or in the field, the place is held desecrated, and every passenger throws a stone upon the spot, till they mount into a heap. These heaps they call *Carns,* as well as those I described to you in my last. Such heaps, we find, were, like the *tumuli,* used as sepulchral monuments; for the book of Judges relates that they raised a great *heap of stones* over the body of Achan, who had purloined "the accursed thing." The same is reported to have been done to the robber, whose epitaph is ascribed to **Virgil**,
  

Monte sub hoc lapidum tegitur Balista sepultus.
  

Persons eminent for their virtues, as well as their vices, are represented as having had these heaps raised to their memory. Homer, describing Hector's funeral, tells us, that, over all, they heaped stones for a monument; and we read, that ‘they took Absalom, and cast him into a pit, and laid a very great heap of stones upon him.’[27](javascript:footNote('E770001-002/note027.html')) 


Both the *carns* and *tumuli* were not only raised as Mausoleums, where the ashes of the



---

p.246



dead were actually buried, but they have been also raised as *Cenotaphs* to their memory, or as obsequies to appease their shade. This we may learn from the present Irish custom, with respect to the *carn;* and with respect to the *tumulus,* it will be evident from the following consideration. The souls of those deprived of the honours of burial were obliged, you know, to wander a hundred years before they could cross the Styx. Therefore, we find Palinurus so earnest with Aeneas, to pay him this last tribute,
  


— tu mihi terram
  

Injice, namque potes. —
  


and for the same reason, the Trojan hero raises a *Cenotaph* to the ghost of Deiphobus,
  


Tunc egomet *tumulum,*, Rhaeteo in littore, *inanem*
  

Constitui, & magna *manes* ter voce vocavi.


To the same custom it is, which **Horace** alludes in his ode to Archytas,


> 1. Quanquam festinas, non est mora longa, licebit
>   
> Injecto ter pulvere curras.
> 


[28](javascript:footNote('E770001-002/note028.html'))


I mentioned to you that the *tumuli* were falsely ascribed to the Danes, and called *Danes-mounts*. There is another piece of



---

p.247



antiquity, with equal impropriety, attributed to the same people, and called *Danes-raths*. They are circular intrenchments thrown up on the tops of hills, sometimes with two or three, but more frequently with a single ditch. Rath signifies literally a surety, and therefore these fortresses are generally called *Forts.* The use of them is so obvious, that Nature herself must have pointed it out to a people always at war among themselves. I can therefore see no reason why they should be attributed solely to the Danes[29](javascript:footNote('E770001-002/note029.html')). On the contrary, there is positive proof, in the Lives of St. Patrick that they were in Ireland some centuries before the Danes set foot in it, for Down-Patrick was originally called ***Rath Keltair** munimentum Keltarii filii Duachi*, and it obtained its present name from being the burying-place of the Irish apostle.


Adieu.




---

p.248


  
**Limerick**.


Of all the events which the sight of this city recals to our memory, the most conspicuous is that treaty, concluded in 1691, which put an end to the wars of Ireland, and an everlasting barrier to the hopes of the Stuart race. But though this treaty, better known by the title of the Conditions of Limerick, put an end to the wars, it did not put an end to the woes of Ireland. For, however honourable to the besieged these conditions might have been held, they were at the best but hard ones, and hard as they were, the Romanists were not long allowed to enjoy any benefit from them.


By the first article of these conditions, it was stipulated that the Roman Catholics should enjoy such privileges, in the exercise of their religion, *as they did enjoy in the reign of king Charles II.* And their Majesties promise, as soon as their affairs will permit them, to summon a parliament in this kingdom, *to procure them such farther



---

p.249



security, as may preserve them from any disturbance on account of their religion.*


This, and the other articles, were reilgiously adhered to by King William, in contempt of the invectives against them from the pulpit, which he prohibited, and of the clamours of the press, which he could not silence. But this phlegmatic prince had imbibed toleration in his native country.


To see the reasons why different maxims were adopted by his successor Anne, we must recur to the history of her reign. This retrospect will shew a Queen without issue, and a great part of these nations looking wistfully to her brother, as the natural, and therefore, as they conceived, rightful heir to the crown. It will shew this nation once devoted to the declining cause of James, because a papist, still suspected of a readiness to risk all for his son. It will not, however, discover any plot contrived, or act attempted, by the papists at this period. The factions of whig and tory were embittered against each other; and their tempers flaming with animosity, breathed nothing but mutual vengeance. The triumphant party, under perpetual alarms of a popish successor, in providing for self-defence, mistook rigour for



---

p.250



justice, and persecution for expedience. In this ferment of zeal, the articles of **Limerick** were repealed, if not violated.


Did the same causes still subsist to ruffle the surface of men's minds, as well might we bid the storm to cease, or the sea to be calm, as speak peace to their passions. But after so long a sunshine in the political sky, succeeding the coruscations of that meteor, the Pretender, we may now examine the matter upon the principles of reason and candour.


All hopes of a popish revolution being removed from the mind of every rational papist, all fears should be removed from every rational protestant. The benefit of a treaty, unforfeited by any infraction on their parts, should be restored to them; national justice cries aloud for it, and self-interest recommends it. I shall confine myself to the last of these considerations.


No great improvement of this country can be rationally expected, when the body of the people derive no advantage from that improvement, and when the penal statutes amount not only to a discouragement, but a prohibition of industry. Even the best laws cannot operate in favour of agriculture, when



---

p.251



five to one of those who should be employed in it, can have no interest in the ground they till. Property, stable property, is what alone can make the *sleep of a labouring man sweet.*


By one law of the penal code, if a papist have a horse worth fifty, or five hundred, pounds, a protestant may become the proprietor, upon paying him down five. By another of the same code, a son may say to his father, Sir, if you don't give me what money I want, I'll turn *discoverer,* and in spite of you and my elder brother too, on whom, at marriage, you settled your estate, I shall become heir. It is needless to comment upon the spirit of such laws —the very recital chills with horror.


Let it not be argued that these laws are seldom put in execution. Is property, is parental authority to depend upon the courtesy of an avaricious malignant neighbour, or the gratitude of a profligate abandoned child? But where[30](javascript:footNote('E770001-002/note030.html')) sons are not 



---

p.252



found impious enough to turn *discoverers,* there are not wanting some who are so base as to avail themselves of a flaw in the title of a Papist.


But granting that these advantages are rarely taken, the idea of security is of more influence, than security itself without the idea. Damocles was perhaps safe enough under the suspended sword of Dionysius, but the apprehension of danger scared away those visions of happiness, which he had seen in the envied pomp of tyranny.


Is not intolerance the worst badge of popery? Are they not virtually Papists, who oppose the principles of toleration? Are they not inimical to their country, who would stifle liberty of conscience? What introduced so many good arts in a short space of time into **England**, but the intolerance of **France**? What, but toleration, at once peopled the fens of



---

p.253



Holland, and rendered it an emporium of trade, the dread of its neighbours, and the wonder of the universe? What but intolerance has wasted **Spain**, **Italy**, and many other countries? Now **France** is become tolerant, and therefore the most thriving nation in Christendom.


When I thus argue for the rights of human nature, as a friend to the community at large, and consequently to the crown of **England**, they tell me that this is very well in theory, but that no Englishman can conceive the virulence of Irish popery. My general reply to which is, that popery is the same every where, and if it has a worse aspect here, than elsewhere, that is owing to the more general ignorance of its professors.


We keep the Irish dark and ignorant, and then we wonder how they can be so enthralled by superstition; we make them poor and unhappy, and then we wonder that they are so prone to tumult and disorder; we tie up their hands, so that they have no inducements to industry, and then we wonder that they are so lazy and indolent.




---

p.254


It is in vain to say that these severe laws restrain the Catholics within the bounds of allegiance, and clip those wings, which, if fully fledged, would be hatching new rebellions: for the very contrary seems to be their tendency; they are a restraint, not from doing evil, but from doing good; they keep alive an habitual hostility, and prepare the people's minds for the most desperate enterprizes. No wonder that it should be part of the Irish character, that they are careless of their lives, when they have so little worth living for.


Ingenuity itself could not have devised a more effectual method of cherishing popish disaffection, than that very code made to annihilate it. For what is it, that the protestant proprietor so horribly dreads? Is it not the claims of the old great families, and quondam proprietors of his estate, upon the almost impossible contingency of a revolution? By depressing all papists equally, he preserves unabated the influence and ascendancy of the old great families; he keeps their claim of right alive in their *blood,* without any barrier between himself and them. Whereas by giving the papist



---

p.255



a right to purchase, the plebeian, but industrious Catholic may soon become seized of an estate, once forfeited by some Popish Baron; and then, having a common interest with the protestant purchaser, he will be as violent an enemy to the old Popish claimant as the Protestant himself. The Papist becomes a guarantee to the Protestant, and as staunch a supporter of the present establishment; because that establishment alone secures him his civil rights. So that, come what will of his religious orthodoxy, his civil orthodoxy is secure.


Thus far the prosperity of the kingdom, and the happiness of human nature, demand that Papists should be indulged in this Popish country, but no farther. They never should be allowed to hold any civil employments, or to have votes as freeholders; and entirely to remove all apprehensions of leading men among them acquiring an influence in the state, it may be provided, that their purchases shall be subject to the Gavel Act, i. e. to an equal division among the natural heirs of the purchaser.


If the Catholics of Ireland could be withdrawn from their blind allegiance to the



---

p.256



Pope, there could not be the slightest pretext for refusing them an unrestrained exercise of their religion. How far this is possible, even in their present state of superstition, you may in some measure guess from the following fact, which to me seems well authenticated.


A few years since, **Dillon, the Archbishop of **Narbonne****, originally of this country, interested himself in behalf of the Papists of Ireland. He endeavoured to engage, in their service, the leading members of both houses of Parliament; and to prepare the way, he prevailed on the Titular Primate to convene a council of the Bishops, to devise some mode of giving government the most convincing test of their loyalty.


An oath of allegiance was agreed to unanimously. But an express abjuration of the Pope's supremacy in temporals being insisted upon by the Narbonne party, it was rejected by a third part of the members.


What makes this decision the more remarkable is, the Bishops, who voted for a renunciation of the authority of the Pope in temporals, had been all elected out of the secular clergy; whereas those who



---

p.257



were against it, had been originally regulars, the Pope's body-guards.


From this circumstance one would conclude, that a great majority of the Popish clergy, and consequently of the people, are disposed to give government every possible assurance of a dutiful demeanor. The sense of these people can only be collected from that of their priests, by whom they are governed. And why a man may not be a Romanist, without being a Papist, in Ireland as well as in **France**, I can see no reason. We know, that the Gallican church has been long emancipated from the thraldom of the Roman pontiff. However, the good intentions of the Archbishop turned out ineffectual, for he could not find any member, in either house, hardy enough to move for a repeal of these laws.


In an Act passed a session or two since, a *test* has been drawn up, which the principal *gentlemen* of the South have taken, through the influence of the titular Archbishop of Cashel; who is of a noble family, and has written a pamphlet to recommend it: notwithstanding the oath is said to be condemned by the Pope, as one clause of



---

p.258



it is by construction forced to imply that the king de facto is also the king de jure. This has staggered many who would be willing to give any test of their allegiance, that could not be suspected of an approbation of revolution principles.


This very scrupulosity is an argument in their favour, evincing that they have a due sense of the sacred obligation of an oath, and that they do not adopt that cursed Jesuitical doctrine, that faith is not to be kept with heretics. For, if the case were otherwise, instead of labouring under those penalties inflicted upon them, they might avail themselves of the temporal advantages of the oath, and yet violate it without remorse.


As things now stand, the conversion of the Irish Catholics is what zeal may hope for, but knowledge never can expect. Of the inefficacy of the penal laws for that purpose long experience may convince the most sceptical. It is now above seventy years since they were enacted. Yet in all that time little more than four thousand converts have been made out of a million and a half of people seventy times told.




---

p.259


How then is this stubborn error to be vanquished? Or rather how is the mischief arising from it to be mitigated? Is it by keeping its votaries in endless night? Is it by steeping them in poverty to the very lips? Whilst they are thus poor, they must necessarily be intellectually dark; and whilst they grope in darkness will they not, like other blind, stretch out their hands to those, who, though they scarcely see farther than themselves, will nevertheless audaciously profess the trade of leading them? No zeal for religion, no argument of reason, can produce a real conversion of any ignorant person. For what artillery in all the magazines of wisdom can make any impression on ignorance, intrenched over the head in prejudice, and guarded by such watchful centinels as the Romish clergy.


But the happiness of a date does not depend upon uniformity of opinion; that is established on another and a broader foundation, the common interest of the subject. When the Catholic has got an interest in the state, one might as well suppose, that a voluntary agent should act against the strongest motive, as that he will act against 



---

p.260



his own interest. The more comfortable his existence becomes, the more strongly will that attachment be riveted. Property, acquired by honest *industry,* will produce quite another sort of subjects from that which is inherited by *blood,* under the old *Brehon laws.* The industrious application of talents in the gaining a competency, or establishing a property, will civilize and reclaim them from their savage customs, barbarous manners, and uncertain life. Fixed property, which every man may attain, will become an hostage to the state, an inviolable pledge of loyalty. Add to this—
  


Property will necessarily introduce and diffuse knowledge, which will enlarge the mind, and make it susceptible of rational impressions. Some daring spirits will of course emerge from the profound abyss, whose example and conversation will have greater influence over their own persuasion, than all the penal laws that policy can devise. Even a little scepticism might open the way to candid disquisition and free enquiry, and thus soften the rigours, and smooth the asperities of Popery. At present,



---

p.261



there are few leading people among the Romanists but interested priests, whose maintenance depends upon the number of their followers.


An avowed and general recantation of profession is not, therefore, to be expected; yet a generation or two may produce a general renunciation of sentiment. And though Popery can never become Protestantism, the professors of Popery may nevertheless become Protestants in principle. They may be brought to see, that God is no respecter of persons, but that *in every nation he that doth righteousness, and he only, is righteous and accepted of him.*


The same religion is now established in **France**, that was at the massacre of St. Bartholomew; but does it breathe the same spirit now, that it did then? Will any man, who knows the world, say that such a scene could, now, be acted over again in Paris? Even the writings of **Voltaire** have not been without their advantage; ‘Do not,’ says he, ‘deprive yourselves of useful subjects, useful in your manufactures, your marine, your agriculture. What though their creed be somewhat different from yours, you



---

p.262



want their labour and not their catechism.’ In **France**, Popery is still nominally the same, but it is virtually reformed.


It is not necessary for the peace and prosperity of a nation that all the individuals, of any persuasion, should be adepts in the reason of religion: sufficient is it, for those purposes, if the first classes are well, and middle classes tolerably informed. An army is not the less sufficient because the centinel and pioneer do not possess all the knowledge of their general officers.


Let us, then, indulge the prejudices of these people for the present. By allowing them to acquire landed property, a more enlightened generation will spring up, who will bring about the wished-for revolution of principle. They who are authorised, by the verities of their religion, to place persecution among the *beatitudes,* will not readily forego those countervailing rewards, which, their artful teachers assure them, are reserved for their obstinate perseverance. But, taught moderation by our example, they will, in due time, see not only the temporal, but the spiritual advantages of our happy constitution.


Adieu.




---

p.263


  
**Athlone**,


Oct. 26th, 1775.
It was my purpose, originally, to make my tour by **Galway**; but I begin to be tired of wretched villages, and uncultivated wastes. A curiosity, too, is growing upon me to hear the speakers in the Irish parliament, which is now sitting. I am, I own, predisposed to think well of the Orators of this country, not only from their general character, and from the specimens of them we have seen in both our houses, but also from my own speculations upon the natural genius of the people, in which there seems to be a fire and imagination, well calculated to animate a popular harangue.


The country on this side **Limerick** is more disfigured with turf bogs than on the other. But, disagreeable as their appearance is, they are not the least profitable grounds; and, when the canals are finished, they will become still more beneficial, by lowering the price of fuel. The spinning of flax, which is a sedentary business, employing



---

p.264



only one hand and one foot, could not be carried on without them in this kingdom, so destitute of wood and so unable to purchase coals. Whereas the spinning of wool, by giving exercise to the whole body, does not stand so much in need of fires; and therefore seems to be the only manufacture which can succeed, where fuel is not abundant.


A great share of the country I rode through hither was rough, and, in some places, mountainous, yet it afforded greater pleasure than the most fertile parts; for it shewed incomparably more cultivation, and more signs of population. The houses, I remarked, grew more frequent, and less wretched, wherever the grounds were bad. For not being fit for pasturage, they are obliged to till them; tillage requires human creatures, who must share some pittance of their own labours. The bog and the mountain is reclaimed for a scanty subsistence, the rich soils are eat up by sheep and bullocks, and the famished shepherd is made the very scape-goat of human nature.


Nenagh, the last town I passed through in **Munster**, was a neater village than usual 



---

p.265



in that province. Agriculture seemed to revive, and some fallowed fields appeared as I approached **Leinster**. There stands the ruins of an old castle of the *Butlers,* called **Nenagh Round**, which held out against **General Ginkell** with 1500 men, for twenty-four hours, in the last war of Ireland. The whole county of Tipperary was once a Palatinate, under the separate jurisdiction of the Ormond family.


I intended to have slept at **Birr**; but finding I could not do so without riding in the night, I stopped at a little house, near a Church, called **Modrenny**, where I expected but sorry entertainment; but in this I was agreeably disappointed, for I found a good bed, and the utmost decency and cleanliness in every thing that was served up.


**Birr**, in the **King's county**, formerly called **Leix**, where I breakfasted, is a good village, without any thing remarkable, but a statue of the late duke of Cumberland, placed on a very high pillar. Its castle was besieged by **Sarsfield**, general of the Irish, but relieved by General Kirk. The country all around has a tolerable appearance of cultivation.




---

p.266


From thence to this place, the country is chequered by the **Bog of Allen**, which crosses several counties, and which would not be offensive to the eye, as it looks like a russet lawn, if the edges of it were not generally indented with turf holes, and heaps of turf piled on the banks. It is, however, a pleasure to see them coming into the custom of sowing rape on these bogs, and other unprofitable grounds. This culture is owing to the **Dublin Society**, which gives yearly premiums for its encouragement. The great advantage of rape is, that it operates as a manure, and reclaims grounds, originally unable to yield oats, to such a degree, that they will afterwards give crops of barley and wheat.


**Athlone** is beautifully situated on both sides of the **Shannon**. The part on the **Leinster** side is called the English town, as that on the **Connaught** side is called the Irish town. Both betray equal symptoms of decay; for without any manufacture, but that of woollen hats, they have scarce any trade but for turf; of which commodity I see great plenty in boats, along their quay.




---

p.267


The views of this town, from both sides the **Shannon**, are excessively picturesque, though the country is almost denuded of trees. The lands are every where sufficiently fertile, but little progress has been made in tillage, till within a few years; and they attribute the advancement of late to the erection of Flour-mills; the want of which, I conceive, must be a great impediment to agriculture. For in many parts of Ireland, very capable of growing wheat, and where the consumption of bread is very considerable, they nevertheless import their flour.


In the war of 1641, the castle of **Athlone** was blocked up, by the Irish, for near six months; nor were all the Protestant forces of Ireland able to relieve it till supplies came from **England**. At length four regiments, one of which was commanded by **Cromwell**, marched with other forces from **Dublin**, under command of the duke of Ormond, and raised the siege.


After the return of the duke, the Protestants, though delivered from the blockade, were still harassed by the superior



---

p.268



numbers of the Irish. They resolved, therefore, to abandon **Athlone**, and if possible, march to **Dublin**. But hic labor hoc opus erat. The wife of the governor of the castle, daughter to the earl of Cork, made her way to **Dublin**, upon the faith of a safe convoy, and there, having audience of the state, she did so pathetically paint the distressed state of the English at **Athlone**, that she prevailed to have such succours sent to their relief, that their miscarriage would have hazarded the loss of **Dublin**, and consequently of the whole kingdom.
  

‘— quid forma & facundia possit
  

Tunc patuit.’[31](javascript:footNote('E770001-002/note031.html'))


This reinforcement, not being suspected by the Irish, reached **Athlone**, without molestation. The main body of the Irish was at this time posted at **Rath-connal**. This pass, of about 100 yards breadth, between two morasses, took its name from the Conal so celebrated in the poems of Ossian, and sirnamed Cearnagh in the Irish histories. But it was rendered still more famous by an old prophecy, that a battle was to be there



---

p.269



fought between the English and the Irish; and that whichever party should win the battle, should also win Ireland.


This prediction, now apparently on the eve of completion, raised the expectations of a great concourse of people, who flocked together to see whose fatal scale was to kick the balance. **Preston**, the Irish general, had not trusted to the strength of the castle, which stood in the pass, or to the natural advantage of the grounds: he caused redoubts and breastworks to be thrown up quite across the neck, in order to oppose the passage of the English, under **Sir Richard Grenville**. Numbers and situation were on the side of the Irish, but discipline, and the alternative of life or death, were on the side of the English. The post was long and gallantly maintained. **Preston** did all a general could: but English steadiness prevailed, and cut itself a bloody passage through this well disputed station, **Preston** falls. A general rout succeeds. Sad omen to the Irish of their future success!


Good night.




---

p.270


  
**Athlone**.


**Athlone**, or the Ford of **Luan**, which, from its central situation, has been called the Nave of Ireland, is the great pass between **Connaught** and **Leinster**. The parts of the town on each side the river, are in different parishes; with but one church, and that on the **Leinster** side; built, as I learn from an inscription in it, by a grant of parliament; whence you may judge of the poverty of the place. Yet here they print a news-paper twice a week.


On the **Connaught** side is the old castle, a barrack for a regiment of dragoons, and a charter school for twenty boys, and as many girls. I was surprised to hear, from the master and mistress of this school, that none but the children of Protestant parents are admitted into it. I had conceived, that as the original object of these schools was the conversion of Papists, none would be received but the children of Papists.




---

p.271


The institution of these schools has all the aspect of benevolence, and zeal for the interests of religion. Yet, with the utmost deference to the national opinion, it may be questioned whether they are calculated to answer the well-meant purpose of converting the Catholics of Ireland; even granting that the children of Papists *only* were admitted into them.


From the state of the fact, placed in its most favourable light, there have been at a medium, four from each county in the kingdom placed out apprentices each year, since the commencement of the scheme in 1733. And it is argued that those, who are thus apprenticed, have been reclaimed from Popery. But if the children of Protestants, even from **Wales** and **England**, be received upon this foundation, is it not probable that the above is too high an estimate?


The children of Protestants are, I presume, received for want of other candidates; for I am assured, that a Papist would suffer any loss, except that of his child, rather than send it to one of these schools. Such is the bigotry of these deluded people, that nothing but absolute want could prevail



---

p.272



on them to suffer their children to receive an education, which, as they conceive, endangers their salvation.


It cannot be supposed that any system of religion taught in any school, especially in one, which pride might think a reproach, can be as firmly rooted, as under the shelter of a parent's wing. Can we then imagine that principles imbibed in these charter schools, will be proof against the seductions of Popery, which environ them in this popish country? As the eyes of the vigilant priests are never off these seminaries, are not relapses, and even conversions to Popery to be apprehended?


But far be it from me to arraign the wisdom of this institution upon the whole. All I would insinuate is, that these schools are very insufficient engines for the reformation of Irish popery. This is an evil that must be eradicated by more powerful instruments.


If we look upon these schools as seminaries of arts and industry, where the children of the poor receive useful instruction, which they could not otherwise obtain, they are institutions highly commendable,



---

p.273



and reflect great honour upon their patronizers; who conduct them as free of abuses, as the nature of human things is capable of.


I cannot, however, help remarking, that in this school, I saw the girls working lace, an employment not more easy than spinning, and certainly not so useful to themselves, or the community. Is it necessary to instruct the lower orders of society in arts, which are rather ornamental than useful? Ought they not rather to be taught the rudiments of the linen or woollen manufactures? Ought those, who subsist entirely on alms, to be initiated into any arts, but such as may, in future, enable them to earn an honest and laborious livelihood?


I have observed here, as well as in the other parts of Ireland, that the people seem extremely affectionate to each other; for even the men salute one another with kisses: and the girls shew *nothing loth* to give hearty embraces in the streets. Curious to learn their sentiments, as well as manners, I have entered into conversation with them as often as possible; and I could not find them so much attached to the house of *Stuart* as I apprehended. They have frequently spoke of James II. with indignation.



---

p.274



He called the Irish *cowards,* and said that all was lost through their fault at the battle of the **Boyne**[32](javascript:footNote('E770001-002/note032.html')). This they have not forgot, and do not fail to recriminate; they brand him with a name the most opprobrious in their language, and expressive of the most dastardly cowardice. Some of them have said to me, ‘We expert little good from any of the race of *Sheemas-a-caccagh,* i. e. Sh——n James.’


The Irish troops I find lie under the imputation of generally behaving ill at home. And therefore **Voltaire** classes Ireland among those nations which seem formed for subjection, while he admits that ‘her troops behave well abroad.’ This lively, but inaccurate writer, could not have forgot, that, at the battle of **Blenheim**, **Lord Clare**'s dragoons alone were victorious on the side of the French, having cut to pieces a German regiment, commanded by **Colonel Goore**,—that like glory attended them at **Ramillies**,—-and that the Irish regiments 



---

p.275



of **Dillon** and **Burke** saved, not only **Cremona**, but the whole French army in **Italy**.


This action was of such *eclat,* that it was said in the British House of Commons, that the Irish abroad had done more mischief to the allies than they could have done at home, by being repossessed of their estates. They tell you it was Ligonier's horse, to a man Irish, which preserved the king's person, and thereby gained the battle of **Dettingen**. Many other cases are adduced to the same purpose[33](javascript:footNote('E770001-002/note033.html')). It was, probably,



---

p.276



reflections of this nature which produced the following lines of **Swift**:

> 1. Her matchless sons, whole valour still remains,
>   
> On French records, for twenty long campaigns
>   
> Yet from an Empress, now a captive grown,
>   
> She saved Britannia's rights, and lost her own.
> 


After all, what is meant by behaving ill at home? Is it any thing more than to say, that the frequent insurrections of a divided people, whose war was undisciplined, as their peace was uncivilized, were always suppressed, by the regular forces of a great and powerful nation? If the Irish had tamely acquiesced under that submissive paction struck between some of their chiefs and Henry II. there might have been some grounds for the censure of **Voltaire**.


**Sir John Davies**, among the many causes assigned why Ireland was not brought under obedience to the crown of **England**, before the reign of James I. every where commends the prowess, and other natural endowments of the people. A struggle, though unsuccessful for liberty, almost uninterrupted for above 400 years, is certainly no symptom of a country formed for subjection.



---

p.277



But this struggle lasted much longer, and had **Sir John** come later into life, he would have seen, that Ireland was at that time far from being subdued. The being subdued does not argue the being formed for subjection. The Britons were completely subdued by the Romans, and if **Britain** had been formed for subjection, we could not, at this day, boast of being the most free people in Europe. In the history of this country, I do not find any period in which it discovered such despondence, as our ancestors did in that humiliating letter, *The groans of the Britons to the Consul Aetius.*[34](javascript:footNote('E770001-002/note034.html'))


But be this as it may, the behaviour of the Irish *at home;* even in the last war, was far from contemptible. They were routed, it is true, at the **Boyne**, in their first general engagement, by the best generals, and the best troops then in Europe; their king, in whose cause they bled, standing at a distance, and shewing himself thereby unworthy of wearing any longer that crown, for which he contended.


At the conclusion of the war, ‘during the treaty of **Limerick**, a saying of **Sarsfield** deserves to be remembered, for it was much talked of, all Europe over. He asked 



---

p.278



some of the English officers if they had not come to a better opinion of the Irish, by their behaviour during this war? And whereas they said that it was much the same that it had always been, Sarsfield answered,— Though low as we are now,
change but kings, and we will fight it over again with you[35](javascript:footNote('E770001-002/note035.html')).’


This was that brave Irish general, who undertook the defence of **Limerick**, when despaired of by the French general, and who gave the Prince of Orange, flushed with victory at the **Boyne**, such a repulse, that he was obliged to raise the siege.


But this very neighbourhood furnishes a scene, where the Irish displayed a steadiness worthy a better cause. The field of **Aghrim** is but a few miles hence, where king James's army, under the conduct of St. Ruth, was upon the point of gaining a complete victory, through the dint of good behaviour, when the fall of their general turned the scale, and established king William on the throne of **England**.


The historiographer of these wars, relates several instances of the superstition of the Irish, in regard to prophesies. And from



---

p.279



his own attestation of the completion of one of them, he seems to have had some faith in them. I shall set them down only as they mark the manners of the place and time.


‘I have heard,’ says this writer,—who was chaplain of an English regiment —‘some of the Irish tell us, before we got thither, that we should not succeed in the first siege of **Limerick**. And they had no other grounds for it, but because one of their prophesies said so.’ —He adds, that Colonel Gordon O'Nial, and several other officers, who were taken prisoners at **Aghrim**, made mention of a dubious prophesy, pronouncing that a great battle was to be fought there, and that in climbing up the hills, the English should find their coats too heavy for them.


He alludes to two other prophesies mentioned by the historians of the periods to which they point. One of them is vouched by Lord Broghill, who defeated the Irish, when **Ireton** lay before **Limerick**, in the very spot predicted. The fact is circumstantially related by **Cox**: ‘Lord Broghill passed the river early in the morning, and met with some Irish gentlemen, under his



---

p.280



protection; who told him, they came thither out of curiosity, because of a prophesy amongst them, *that the last battle in Ireland should be at **Knocknaclashy**.* Whereupon the Lord Broghill asked them who was to have the victory by their prophesy? They shook their heads and said, *the English.* It is, however, to be remarked, that the Irish maintained the field long with undaunted bravery, and though disordered by a finesse of Lord Broghill, they rallied, and bid fair to recover the day.’


The other prophesy alluded to, the same writer says, pointed out the spot near **Kinsale**, where the Spaniards landed in the Elizabethian war, and also the ground where the great O'Nial was defeated; it having been shewn to Lord Montjoy, several days before. But **Moryson**, who was secretary to that lord, and who wrote the history of that war, tells the story somewhat differently. He says, ‘that an old written book was shewed to the Lord Deputy, wherein was a prophesy naming the ford and the hill, where this battle was given, and foretelling a great overthrow to befal the Irish in that place.’




---

p.281


I do not find that witches have ever engaged the superstition of this country; on the contrary, I have heard it boasted, that an *Irish Witch* was never heard of. But the Fairy Mythology is swallowed with the wide throat of credulity. Every parish has its green, and its thorn, where these *little people* are believed to hold their merry meetings, and dance their frolic rounds. Those forts and mounts I have described to you, are all regarded as fairy land, where the pigmy grandees keep their moon-shine courts, and star-light assemblies.


It would be difficult to tempt any common labourer, and some could not be tempted, to apply their spade to these sacred remains; for they would be certain that some evil must befal either themselves, or their family, or their cattle, before the expiration of a year. I have seen one of those elf-stones— like a thin triangular flint, not half an inch diameter,—with which they suppose the fairies destroy their cows. And when these animals are seized with a certain disorder, to which they are very incident, they
say they are elf-shot.


But I have given you more than enough of this trash.


Adieu.




---

p.282


  
**Athlone**.


As the Irish in foreign services are reckoned among the best troops in Europe, I should have thought it needless to say more on that subject, if certain peevish reflections, thrown out by **Harrington** and others, had not been lately retailed. To these reflections I shall beg leave to oppose the testimony of **Spencer**, which, I believe, is as just as it is honourable. ‘I have heard, says he, some great warriors say, that in all the services which they had seen abroad in foreign countries, they never saw a more comely man than the Irishman, nor that cometh on more bravely to his charge.’ If they have failed at home, can we attribute this to anything but want of discipline? Their conduct at **Aghrim**, contrasted to that at the **Boyne** but a year before, shews that, in a very short time, they can acquire steadiness even at home.


It should not be forgotten, that the Inniskilliners, and defenders of **Londonderry**,



---

p.283



were Irish, as well as their opponents. And if these betrayed an inferiority when opposed to men free and accustomed to arms, it only shews what slavery and a disuse of arms will effect. ‘Etiam fera animalia, si clausa teneas, virtutis obliviscuntur.’


As to the personal courage of the individuals of this country, I have never heard it disputed. National reflection rather brands it with a hardihood of spirit. **Shakespear**, who of all men had the deepest insight into human nature, has left us a portrait of the Irish character in this line, as like as if they had sat for the picture but yesterday. The likeness is so very striking that I cannot refrain giving an extract. — Captain Fluellin, the Welchman, wanting to send the duke some hints relative to the conduct of the siege of Harfleur, is told by *Gower,* that

> **Gower**
> The duke of Gloucester is altogether directed by an *Irishman,* a very valiant gentleman i'faith.
> 
> 
> **Flu.**
> It is Captain *Macmorris,* is it not? By *Cheshu* he is an ass as in the world; I will verify as much in his beard. He has no more directions in the true disciplines of
> 
> 
> 
> ---
> 
> p.284
> 
> 
> 
> the wars, look you, of the *Roman* disciplines, than is a puppy-dog.
> 
> 
> ****Enter Macmorris and Captain Jamy.****
> 
> **Flu.** 
> Captain Macmorris, I beseech you now, will you vouchsafe me, look you, a few disputations with you, as partly touching or concerning the discipline of the war, the Roman wars, in the way of argument, look you, and friendly communication partly, to satisfy my opinion, and partly, look you, for the satisfaction of my mind as touching the direction of the military discipline, that is the point.
> 
> 
> **Jamy.**
> It sall be very gud, gud feith, gud Captains bath. And I sall quit you with gud love, as I may pick occasion; that sall I, marry.
> 
> 
> **Mac.**
> It is no time to discourse, so Chrish save me: the day is hot, and the weather, and the wars, and the king, and the duke; it is no time to discourse; the town is beseech'd, and the trumpets call us to the breach, and we talk, and by Chrish do nothing?, 'tis a shame for us all; so God sa' me; 'tis a shame to stand still; it is shame by
> 
> 
> 
> ---
> 
> p.285
> 
> 
> 
> my hand; and there is throats to be cut, and works to be done, and there is nothing done, so Chrish sa' me law.
> 
> 
> **Jamy.**
> By the mass, ere these eyes of mine take themselves to slomber, aile do gud service or aile ligge i'th' ground for it; ay, or go to death; and aile pay it as valorously as I may, that sall I surely do the breff and the long; marry, I wad full fain heard some question between you tway.
> 
> 
> **F'lu.**
> Captain Macmorris, I think, look you, under your correction, there is not many of your nation——
> 
> 
> **Mac.** 
> Of my nation? What ish my nation? Ish a villain and a bastard, and a knave and a rascal? — What is my nation? Who talks of my nation?
> 
> 
> **Flu.**
> Look you, if you take the matter otherwise than is meant, Captain Macmorris, peradventure I shall think you do not use me with that affability as in discretion you ought to use me, look you; being as good a man as yourself, both in the disciplines of the wars, and in the derivation of my birth and in other particularities.
> 
> 
> 
> 
> ---
> 
> p.286
> 
> 
> **Mac.**
> I do not know you so good a man as myself: so Chrish save me, I will cut off your head.
> 
> 
> **Gower.**
> Gentlemen both, you mistake each other.
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 
> 




I write you this from the Connaught side of the **Shannon**, from that county, particularly, which gave birth and title to **Dillon, Lord Roscommon**; in whose panegyric **Pope** seems to have contended with Dryden,

> 1. The Muses empire is restored again
>   
> In Charles's reign, and by Roscommon's pen.
> 

Dryden.

> 1. To whom the wit of **Greece** and Rome were known.
>   
> And every author's merit, but his own.
> 


**Pope**.


But this county boasts of a still greater honour, the birth of the much lamented **Oliver Goldsmith**. I have learned a very curious anecdote of this extraordinary man, from the widow of a Doctor Radcliffe, who had been his Tutor in Trinity College Dublin. She mentioned to me a very long letter from him, which she had often heard her husband read to his friends, upon the 



---

p.287



commencement of **Goldsmith**'s celebrity. But this, with other things of more value, was unfortunately lost by accidental fire, since her husband's death.


It appears, that the beginning of his career was one continued struggle against the waves of adversity. Upon his first going to **England** he was in such distress, that he would have gladly become an usher to a country school; but so destitute was he of friends to recommend him, that he could not, without difficulty, obtain even this low department. The master of the school scrupled to employ him, without some testimonial of his past life. **Goldsmith** referred him to his tutor, at college, for a character; but, all this while, he went under a feigned name. From this resource, therefore, one would think, that little in his favour could be even hoped for. But he only wanted to serve a present exigency — an ushership was not his object.


In this streight, he writes a letter to Dr. Radcliffe, imploring him, as he tendered the welfare of an old pupil, not to answer a letter which he would probably receive, the same post with his own, from the



---

p.288



schoolmaster. He added, that he had good reasons for concealing, both from him and the rest of the world, his name, and the real state of his case: every circumstance of which he promised to communicate upon some future occasion. His tutor, embarrassed enough before to know what answer he should give, resolved at last to give none. And thus was poor **Goldsmith** snatched from between the horns of his present dilemma, and suffered to drag on a miserable life for a few probationary months.


It was not till after his return to London, from his rambles over great part of the world, and after having got some sure footing on this slippery globe, that he at length wrote to Dr. Radcliffe, to thank him for not answering the schoolmaster's letter, and to fulfil his promise of giving the history of the whole transaction. It contained a comical narrative of his adventures from his leaving Ireland to that time: His musical talents having procured him a welcome reception wherever he went. My authority says, her husband admired this letter more than any part of his works. But she would not venture to trust her memory in detailing 



---

p.289



particulars. Which, after all, could not appear very interesting, but from his own manner of stating them.


Adieu.

  
**Dublin**,


Nov. 7, 1775.
From **Athlone**, I took the stage-coach to **Dublin**, as well to gratify my curiosity in seeing the manners of the Irish in this vehicle, as from the apprehension of an approaching change of weather. I must remark, by the bye, that our weather has turned out more favourable than I expected; the roads were dusty all the last week of October, and except on the 19th, that day so fatal to thousands at sea, my expedition was not once incommoded by rain.


I never enjoyed a frolic more than my passage in the stage. Our company consisted of an elderly lady of some fashion and her maid, the son of a nobleman, a young buxom lass from Roscommon, and a country squire from Galway. Well-bred people are the same everywhere. So that variety was only to be found in the two last mentioned of my fellow-travellers.



---

p.290



The girl could not be above eighteen. She was dressed in a plain riding-habit, with a hat and feather. You would rather praise the neatness than the richness of her dress. But for her person, that indeed was rich in all the gifts of nature; it was of the middle size, but of shape the most correct. Her face had the rosy virgin tint of innocence and health. It was that florid bloom which the painted Dolls, who haunt our scenes, affect, but never can acquire: or rather, it was that young and purple light of love, which Reynolds may conceive, but cannot paint. Her features were all turned to the softest harmony. And though embarrassed, she was never awkward. If a mauvaise honte sometimes suffused her cheeks, her sensibility added grace to her blushes.


Our squire, you may suppose, was not without feelings, but he was devoid of sentiment. He was that very Hibernian I had so often heard of, but never noticed before. They were utter strangers to each other; and her loveliness excited his curiosity to know her connections. He asked her a thousand questions to extract the secret; I



---

p.291



suppose, Madam, says he, you know such and such people, &c. &c. At length, he happened to hit on some of their common friends. This naturally led our hero to display all his talents to captivate this innocent girl. And his manners, conformable to her own, gave him an unrivalled preference.


What most evidently prevailed, absit invidiam and what betrayed her into all the *Chesterfieldian* indecorums of laughter, was his addressing her in Irish. And when he had a mind to be tender, beyond expression in plain prose, he would accost her with an Irish song; which he sang with great softness. The gentleman was perfectly good-humoured, and had a high flow of animal spirits. You could not have been displeased with the display of this native character. I was delighted with it, for it was original, and I had hitherto seen only the copy. It gave me also an opportunity of observing, that the Irish language spoken by this pair was far from being disagreeable; it was very different from that which I had heard from the vulgar in the streets; and nothing could be more melodious than it was when sung.




---

p.292


The country from Athlone to **Dublin** gradually improves in cultivation through **Westmeath**, **Meath**, and **Kildare**, notwithstanding the two former are principally grazing counties. We lay a night on the road, at a good inn in a small town called **Kinnigad**, where several stages put up as well as ours. We passed through several villages, not one of which indicated the exercise of any manufacture except **Kilcock**, which has a thriving aspect: and here, I was told, that the women spin their own flax, and that the men were chiefly employed in day-labour, for the neighbouring farmers, who are here the most skilful and wealthy in the kingdom. But the towns on this road were happily diverted of that distressing appearance of sordid penury, which the **Munster** villages of the same size generally wore; and the inns were universally good.


And now having finished my little tour through two provinces of Ireland, and ruminating upon what I have seen, I must say, and I cannot say it in words so authoritative as those of **Sir John Davies**, ‘I have observed the good temperature of the air,



---

p.293



the fruitfulness of the soil, the pleasant and commodious seats for habitation, the safe and large ports and havens, lying open for traffic into all the western parts of the world, the long inlets of many navigable rivers, and so many great lakes and fresh ponds within the land, as the like are not to be seen in any part of Europe; and lastly, the bodies and minds of the people endued with extraordinary abilities of nature.’


After considering all this, yet seeing at the same time that the greater, and certainly the best part of what I have seen, instead of being in a progressive state of improvement, is verging to depopulation; that the inhabitants are either moping under the sullen gloom of inactive indigence, or blindly asserting the rights of nature in nocturnal insurrections attended with circumstances of ruinous devastation and savage cruelty, must we not conclude that there are political errors somewhere?


Cruelty is not in the nature of these people more than of other men, for they have many customs among them, which discover uncommon gentleness, kindness and affection. Nor are they singular in their



---

p.294



hatred of labour; **Tacitus**'s character given of the Germans, applies to them, and all mankind in a rude state, *mira diversitate naturae, cum iidem homines sic ament inertiam, sic oderint quietem.’’*

**Tacitus**, Germania, ch. 15.

 At present their hands are tied up, and they have neither the activity of a savage, nor the industry of a civilized people. There is no necessity for recurring to natural disposition, when the political constitution obtrudes upon us so many obvious and sufficient causes of the fad effects we complain of.
The first is, the suffering avarice to convert the arable lands into pasture. The evils arising from this custom in **England**, were so grievous, that **Lord Bacon** tells us, in the reign of Henry VII. a statute was enacted to remedy them. But the mischief still increasing, Henry VIII. revived all the antient statutes, and caused them to be put in execution. Yet, notwithstanding this care, so great was the discontent of the people, from poverty occasioned by decay of tillage and increase of pasturage, that they rose in actual rebellion in the reign of Edward VI., and sharpened by indigence



---

p.295



and oppression, demolished in many counties the greatest part of the inclosures.


Here you see an exact prototype of the present disturbances in **Munster**, carried on by the rabble, originally called **Levellers** from their levelling the inclosures of commons, but now **White Boys**, from their wearing their shirts over their coats, for the sake of distinction in the night. There it was a rebellion, here it is only a star-light insurrection, disavowed by every body; and the impotence of those engaged to do any thing effectual, drives them into wanton and malignant acts of cruelty on individuals. Hopeless of redress, they are provoked to acts of desperation.


The rebellion in **England** did not remove the evil; it was not, however, altogether fruitless; a commission was appointed to enquire into the cause of it, and from a proclamation thereupon issued, it appears, that government became possessed of the true state of the case. It is so remarkably apposite to the present state of the south of Ireland, that I cannot forbear citing an extract or two from it. It sets forth, ‘that the king, and the rest of the privy council



---

p.296



were put in remembrance by divers pitiful complaints of the poor subjects, as well as by other wise and discreet men, that of late, by enclosing arable ground, many had been driven to extreme poverty, and compelled to leave the places where they were born, and seek their livings in other countries; in so much, as in times past, where ten, twenty, yea in some places, two hundred people have been inhabiting, there is nothing now but sheep and bullocks. All that land which was heretofore tilled and occupied by so many men, is now gotten, by the insatiable greediness of men, into one or two men's hands, and scarcely dwelt upon by one poor shepherd, so that the realm is thereby brought into marvellous desolation, &c.’


Something more was attempted by Queen Elizabeth, but little or nothing was accomplished. And can we wonder that little could be accomplished, when the interests and prejudices of the Great were against tillage; and when so able a man as **Sir Walter Raleigh** insisted upon the impossibility of making grain a staple commodity in **England**. But a much greater man than



---

p.297


**Raleigh**, the immortal **Bacon**, supported the declining cause of agriculture, upon the principles of sound philosophy, and consistent policy. Yet, so undistinguishing was the ignorance of those times, that his lessons were unheeded, and scarcity prevailed for the two succeeding reigns.


The case of Ireland is now like that of **England** then. Every man, connected with the interests of graziers, or swayed by their prejudices, will tell you, very dogmatically, that tillage can never succeed in Ireland. It is indeed visible, from the sorry implements of labour still in use, that agriculture never has arrived at any high degree of perfection; yet it is equally visible, from the vestiges of the plough, and from the evidence of history, that **Munster** was once as well cultivated, and as populous as any part of this kingdom.


But to return to *White-Boyism;* what measures have been taken for laying this spirit? None that I hear of, but that of offering rewards for apprehensions and discoveries. Yet I have heard it remarked, as part of the Irish character, that no reward has been ever found sufficient to tempt the accomplices, in this 



---

p.298



or any other misdemeanor, to betray each other. Some of these wretched culprits have, however, been found guilty and executed, but no inquiry has been made into the real cause of the insurgency, no commission has been issued as in **England**. This evil must, nevertheless, originate from some other cause than mere depravity of nature; for to suppose that a set of people should conspire to run the risque of being hanged and gibbeted, for the mere pleasure of doing mischief to their neighbours, would argue a degree of diabolism, not to be found in the human heart.


Some would insinuate that Popery is at the bottom of what they call this dark affair; and to give their opinion an air of probability, they tell you, that the first rising of these deluded people was in the very year that **Thurot** made a landing in the north of Ireland, and that **Constans** was to have attempted the like in the south. But I can find no evidence that the French king employed any agents, at this time, to practise on the discontents of the rabble of **Munster**. It is indeed more than probable, that some of their wrong-headed priests



---

p.299



might have secretly wished to serve the cause of **France**, and to co-operate with any Popish invader. Yet even that could only be the thought of some ignorant zealots. The only priest, charged with fomenting these disorders, suffered for his folly, if he were guilty; but from what I have both heard and[36](javascript:footNote('E770001-002/note036.html')) read upon this question, I am inclined to credit his own declarations before death, that he was innocent of the crime for which he was to suffer.


But granting the disaffection of the Roman Catholics of Ireland were as malignant, as it is represented to be by their well-meaning Protestant neighbours, is not that a sufficient reason for altering a conduct towards them, which experience has proved so ineffectual to reclaim them? Can they expect cordial affection in return for legal interdicts? Can partial laws command more than partial obedience? If a yoke be heavy, will it not gall? If chains are iron, will they not sometimes rattle? Loose these 



---

p.300



chains, throw off this yoke, and repeal these laws; confer benefits, expect affection, and receive gratitude. Before you hope for the duties of loyal subjection, impart the blessings of an equal dominion. Before you think of reaping the fruits, sow the seeds of *true* self-interest. Make people happy, and you may make them loyal.


Among the many causes assigned by **Sir John Davies**, why Ireland was never entirely brought under obedience to the crown of **England**, until the reign of James I. the capital one seems to be the defect of civil polity. He shews, that, ‘for the space of three centuries and a half at least, after the conquest was first attempted, the benefit of the English laws was never communicated to the Irish, though they earnestly sought the same. For as long as they were out of the protection of the English law, so as every Englishman might oppress, spoil, nay kill them, without controulment, how was it possible they should be other than outlaws, and enemies to the crown of **England**?—If the king would not admit them to the condition of subjects, how could they learn to acknowledge and obey him as their



---

p.301



sovereign? When they might not converse, or commerce, with any civil men, nor enter into any town or city, without peril of their lives, whither should they fly, but into the woods and mountains, and there live in a wild and barbarous manner? If the Irish be not permitted to purchase estates of freeholds of inheritance, which might descend to their children, according to the course of our common law, must they not continue their own customs, and live in confusion, barbarism, and incivility?’


This excellent reasoning of the Knight, may, *mutatis mutandis* be extended to the present times. For to this day, the Irish have not the entire benefit of the English laws. They, to be sure, are no longer absolute outlaws, and enemies, but they are in many respects *aliens.* And Roman Catholics, who are the body of the people, can never be zealous friends of government, whilst they despair of reciprocal acts of friendship and protection.


Some gentlemen seem alarmed at the mode now adopted, of recruiting our army, out of the Catholics of this country. But, as long as the officers are Protestants, I can



---

p.302



apprehend no danger, from mingling even an equal number of both persuasions together; nay, it might contribute to wear off mutual prejudices, and effect that coalition of sentiment, which is so desirable. The case would be very different, if whole regiments, both officers and men, were to consist of Romanists. In their present temper of mind, a French invasion might prove a perilous test of their loyalty.


By being composed *entirely* of Papists, their habitual discontents might be so fomented, that their internal union might possibly turn them against the state that employs them. Their causes of discontent should be removed, for some time, before they can have acquired new attachments; and, consequently, before arms should be trusted in their hands, as distinct bodies of troops. They must *see that it is their interest* to support the present constitution, before *they will support it* upon a principle, in which we can repose sufficient
confidence.


Adieu.




---

p.303


  
**Dublin**


I had been taught to believe that the state of the Irish parochial clergy had been universally comfortable, if not affluent. But the case in **Munster** is mostly otherwise. It is indeed scarcely to be conceived, that in a country so uncultivated, a parish of moderate extent, should yield sufficient for the liberal support of a parson. Accordingly, unions of large districts are here common; which after all give but a scanty subsistence. In the north, which is said to be very populous, and in the parts of **Leinster**, which are cultivated, the case is different. There a small parish affords a decent maintenance. But in the south and west, where industry, and consequent population, is by every means discouraged, the situation of these gentlemen is rather to be pitied than envied. It requires a large income indeed, to compensate for the want of houses, and markets, and those other comforts which the English clergy everywhere enjoy.




---

p.304


The original cause of the rising of the White-Boys was this: ‘Some landlords in Munster set their lands to cottiers far above their value; and, to lighten their burden, allowed commonage to their tenants, by way of recompence: afterwards, in despite of all equity, contrary to all compacts, the landlords inclosed these commons, and precluded their unhappy tenants from the only means of making their bargains tolerable[37](javascript:footNote('E770001-002/note037.html')) Too ignorant to know the law, and too poor to bear the expence of it, they betook themselves to violence, as their only resource. As mobs seldom rise without suffering some grievance, and never



---

p.305



subside without doing some injury; so these insurgents, having no prospect of redress, began to direct their vengeance against the clergy. The deluded rabble, smarting under the galling load of oppression, fled every where for relief, but where they ought. And, in order to divert their attention from themselves, it became the policy of the landlord and grazier to cherish, or at last connive at, the spirit of curtailing the church of its pittance.’


In some places they will not suffer the parson to have any assistant in letting his tithes. And if any one be so hardy as to lend his aid, he risques the loss of his ears, or his nose, or both. In other places, they refuse absolutely to pay those dues the law specifies. And in all, they pay with grudging and ill blood. So that the case of the clergy in this province is deplorable. For how can a man of liberal sentiment submit to the low drudgery of chaffering and dodging with each parishioner, most of whom would use every art chicane can devise, to outwit and deceive him? If the parson gives up to each demand, his income is frittered down to nothing; and if he



---

p.306



does not, he must study all the little tricks of bargain-making, and so degrade himself to the level of a tithe-dealer. And sunk so low, he inevitably loses all that influence wherewith the fanctity of his character had invested him, and which a propriety of conduct would have infallibly secured.


There is another cause which immediately tends to distress the clergy, and remotely to stop the progress of agriculture. The House of Commons in one of those frantic fits, to which all popular assemblies are incident, passed a vote, some twenty or thirty years ago, whereby, any lawyer was declared an enemy to his country, who should appear as council for the recovery of a due called *Agistment* or Herbage, which had ever been payed in lieu of the tithe of grass. But as this vote had the sanction of only one branch of the legislature, it could neither assume the form of a law, nor be binding upon those who passed it, but during their political existence as a parliament. It has, nevertheless, to all intents and purposes, acquired the force of a law; for the claim is totally relinquished.




---

p.307


Now if the parson alone had suffered by this most iniquitous decision, one might be brought to believe that no great harm had been done by it. But this very vote contributes to repress industry, and to waste the country. Whereas, if the parson had been allowed to receive that herbage to which he was intitled, agriculture might have been revived, and depopulation restrained. Herbage would have aded as a premium upon tillage, by being a tax upon pasturage.


Thus you may observe, that a rich grazier, who pays perhaps ten thousand pounds a year rent, may not be subject to as much tithe, as a wretched cottier, who holds but ten acres of land. No wonder then, that both the clergy and the poor should be equally distressed. And as little wonder, that insurrection should rear its head in this ill-fated country; the first landlords of which are absentees, the second either forestallers or graziers, and where the only tiller of the ground stands in a third, and sometimes in a fourth degree from the original proprietor. Something should be thought of, something done, to restore the rights of



---

p.308



human nature, in a country almost usurped by bullocks and sheep.


Ought not an *Agrarian* law to be passed, which would effectually prevent one man from occupying more than a certain number of acres, unless one half, or a third, or even a fourth were under the plough? **England** was once in a similar situation, and had lis *Levellers,* who, aggrieved by the monopoly of farms, rebelliously asked. 

> 1. When Adam delved, and Eve span.
>   
> Where was then your Gentleman?
> 




As they have the example of **England** before them, ought they not to apply like remedies to like evils. ‘The device of Henry VII. says **Lord Bacon**, was profound and admirable, in making farms and houses of a standard; that is, maintained by such a proportion of land to them, as may breed a subject in convenient plenty and no servile condition.’ And in the preceding reign it was enacted, ‘That no person should keep above 2000 sheep, nor hold more than *two* farms.’


As the several risings of **Oak Boys**, **Steel Boys**, and **White Boys**, have made some



---

p.309



noise on our side of the water, it may not be amiss to give you a distinct view of them; for they are, in general, so little understood, that they are frequently confounded together.


The high-ways in Ireland were formerly made and repaired by the labour of the housekeepers. He who had a horse, was obliged to work six days in the year, himself and horse: he who had none, was to give six days labour. It had been long complained, that the *poor* alone were compelled to work; that the *rich* had been exempted; that instead of mending the *public* roads, the sweat of their brows had been wasted on *private* roads, useful only to the overseers. At length, in the year 1764, in the most populous, manufacturing, and consequently civilized part of the province of **Ulster**, the inhabitants of one parish refused to make more, of what they called *job* roads. They rose almost to a man, and from the oaken branches which they wore in their hats were denominated ***Oak Boys***. The discontent being as general as the grievance, the contagion seized the neighbouring parishes. From parishes it flew to baronies, and from baronies to counties,



---

p.310



till at length the greater part of the province was engaged.


The many-headed monster being now roused, did not know where to stop, but began a general redress of grievances, whether real or imaginary. Their first object was the overseers of roads; the second the clergy, whom they resolved to curtail of their personal and mixed tithes; the third was the landlords, the price of whose lands, particularly of turf bogs, they set about regulating. They had several inferior objects, all which only discovered the frenzy of insurrection.


In the mean time, the army was collected from the other provinces; for till then, the province of **Ulster** was deemed so peaceful, that scarcely any troops were quartered in it. The rabble fled as soon as fired upon; and thus was this tumult quelled for the time, in five or fix weeks after its commencement, with the loss of only two or three lives. In the next session, parliament took the matter into consideration, and very wisely repealed the old Road Act and provided for the future repair of the roads by levying an equal tax off the lands of both



---

p.311



poor and rich. The cause of discontent being thus happily removed, peace and quiet have returned to their old channels.


The rising of the ***Steel Boys*** was not so general, but it was more violent, as proceeding from a more particularly interesting cause. The source of it was this. An absentee nobleman, who enjoys one of the largest estates in this kingdom, instead of letting it, when out of lease,--which it happened to be altogether about five or six years ago,--for the highest rent, which is the usual way in Ireland, adopted a new mode, of taking *large* fines and *small* rents. It is asserted, that those fines amounted to such a sum, that the want of the usual circulating cash, carried away to **England**, severely affected the linen markets of that country. But, be this as it may, the occupier of the ground, though willing to give the highest rent, was unable to pay the fines, and therefore dispossessed by the wealthy *undertaker*, who, not contented with moderate interest for his money, racked the rents to a pitch above the reach of the old tenant.


Upon this, the people rose against the *forestallers,* destroying their houses, and



---

p.312



maiming their cattle, which now occupied their *quondam* farms. When thus driven to acts of desperation, they knew not how to confine themselves to their original object, but became, like the ***Hearts of Oak**,* general reformers. The army however easily dispersed them, and two or three, who were made prisoners, having suffered by the hands of the executioner, the country was soon restored to its pristine tranquillity.


Both these insurrections, being in the North, the most opulent, populous, and civilized part of the kingdom, we may observe, have no similitude to that of the ***White Boys**,* in the South, either in their causes or effects, except in the general idea of oppression. The cause which generated the one being removed, and the cause of the other being only temporary, the duration of neither was long. The rise and fall of each was like that of a mountain river, which, swelled by a broken cloud, at once overwhelms all around, and then shrinks down as suddenly into its accustomed bed.


Whereas in the South, where the cause is permanent, without any appearance of redress, the effect remains. The poor, deprived



---

p.313



of their right of commonage, driven from the good grounds, obliged to pay five or six guineas for an acre to set their potatoes in, and having no resources from manufactures, as in the North, they become constant enemies to the state; *the state not being their friend, nor the state's law.*


It is in vain to urge, that fanaticism and superstition were the original sources of these evils. If the majority, engaged in the North, were Presbyterians, and in the South Papists, it is, because the body of the poor are of those persuasions in those places. And, it should be attended to, that the oppression of the poor in the South, proceeds very much from the Papists themselves, as the graziers who engross the farms, are mostly Romanists; which incontestibly proves the necessity of an *Agrarian law.* Till some step is taken in favour of tillage and the poor, *Whiteboyism* will probably remain, in defiance of all the *severities* which the legislative power can devise, or the executive inflict.


But you may possibly ask, why may not these people make as much of the ground by tillage, as the grazier by pasturage?



---

p.314



The reason is this, their poverty is so extreme, and their ignorance of tillage so great, that they could not occupy it to the greatest advantage. Farming is an art which requires much experience, and much expence. And, though perhaps they might make as much of it, yet the grazier pays his rent with less trouble to the landlord, who is generally an absentee. The grazier cannot make so much of a few acres as the farmer; but, by a light profit from thousands, he amasses a fortune, without adding to the improvement of the country. Whereas, if an Agrarian law were to take place, the present grazier would be obliged to use the plough, to make the most of a small farm or two. He would be forced to cultivate with artificial grasses, peas, beans, turnips, &c. to make from a less quantity of land with labour, as much as he formerly made from a greater without it. Thus you may perceive, that the same farms would feed as many sheep and bullocks as at present, and of human creatures, five times the number.


In the north and some other parts like it, the tenant makes his rent, not by his



---

p.315



land, but his industry, and the spinning of his wife and family. He must have some land for his potatoes and his cow, for which he gives whatever the landlord asks. But sometimes the landlord is not at the trouble of asking; he sets up his land to the best bidder, and receives written proposals. And thus it frequently happens, that the wretched tenant, to whom long possession gives no preference, is driven from his little dwelling, unless he outbids every other proposer. Upon such hard conditions, you may see it is morally impossible that this country can be improved successfully; for the tenant is persuaded, that every improvement he makes, will but enhance the difficulty of renewing his lease.


This may explain to you what an Englishman can scarcely conceive. We, in general, imagine that a twenty-one years lease is a very good one, and so it is with us, where the present occupier is supposed to have a *tenant-right;* and where the tenant is allowed to make three times what he pays for his land, — one share for his rent, another for the support of his family, and a third for contingencies. But here there



---

p.316



is no such allowance made, for if the tenant can pay his rent, and exist upon potatoes and butter-milk, his landlord thinks he has a good enough bargain. And though in some places, rents are as high in Ireland, as in **England**, yet they do not yield half the produce, —the tenant starves, and the landlord has almost the whole value.


When I speak thus, I would not be understood to comprehend all Irish landlords, under the above description. There are many good landlords; if there were not, this nation would soon cease to exist as a people; for till the breaking out of the present troubles in **America**, they migrated in such numbers from this kingdom, that the price of lands fell one-third of their former rate; but this spirit being now checked, lands begin to rise again.


When upon this topick, it would be injustice to pass over in silence, the conduct of that excellent person, **Sir George Savile**; which I have so often heared extolled in this city; the only part of the kingdom I have seen, indeed, where the rights of human nature seem in the least attended to. That exemplary landlord has, it seems,



---

p.317



an estate in one of the northern counties of this kingdom. A few years ago, when the leases were expired, he paid a visit to it, that he might learn all its local circumstances. He found the majority of the occupiers groaning under the most piteous oppression. The tenantry, who held large tracts immediately from him, had under them a numerous set of cottagers, who paid exorbitant rents. **Sir George** resolved at once to emancipate them. He announced, that every cottier might become his tenant, —and desired them to make, each man, his proposal for what he then possessed. This was not received, as he expected, with joy and gladness, but with gloom and dejection of spirit. Unaccustomed to acts of mercy, they doubted whether such a principle existed in the human heart. The character of **Sir George** was unknown to them. It was infused into their minds, that, like other landlords, he only wanted to raise his estate, and they like the *Helots,* were afraid of the lash of their accustomed masters. It was some time before they could be prevailed upon to make any proposals. At length, they proposed to pay him what they then payed the *undertakers:*


---

p.318



they thought it would be in vain to offer less. The issue of the whole was, that **Sir George** gave these poor vassals leases at a much less rent than they proposed, yet doubled at the same time, the income of his estate. This you'll say was a sufficient sacrifice; but you will agree with me, that the favour of it must ascend to heaven, when you hear, that he might have had, without any trouble, from a single undertaker,—and with as good security as the Bank of **England**,—even more than he would accept from his tenants.


Farewell.

  
**Dublin**.


In this kingdom, so divided, both in religious and political sentiments, you can scarcely find two persons of the same opinion; and no general plan for its improvement, gives any party content. It must, nevertheless, be a plan of the most comprehensive nature, which can answer all the purposes of universal good. Particular interests



---

p.319



must be disregarded, particular prejudices should be despised. The interests of graziers are against an *Agrarian* law; and the ruling prejudice is against any relaxation of the penal code. In my last, I pleaded the cause of the poor against the rich; let us now consider the objections against *toleration,* unawed by authority, unbiassed by prejudice, and unswayed by interest.


It is urged, that popery is of a spirit so intolerant, that it ought not be tolerated, in this country especially, where the very rivers have been stained with the blood of Protestants, whose ghosts have often cried, aloud, for vengeance on their fell destroyers. You may perhaps, Doctor, think that this is a visionary representation of my own; but it is not, it is the real representation of ignorant zeal. Among the many affidavits of the barbarities committed by Papists, in the war of 1641, are some, equally authenticated, wherein the deponents set forth, that they heard the apparitions *shriek vengeance,* as they glided along the ***Bann**;* a river in the north, into which they had been driven. Which only evinces,



---

p.320



that entire credit is not to be given to the affidavits, and histories of those times. But let us listen to more serious arguments.


It is objected, that if Popery were tolerated, it would exhibit the same scenes over again which it did then; its lust of dominion being so inordinate, that wherever it can, it will reign alone. Let it, however, be remembered that it has now undergone a long quarantine from power, by a peaceable subjection of above seventy years. Let it be considered, that the influence of the Pope is now lost in some Popish countries, and that it is diminished in all. The Jesuits are suppressed, the world is enlightened, **France** is tolerant! Would it not be safer to allow a Roman Catholic seminary at home; where, even from emulation, some real and solid learning might be acquired, which would necessarily beget moderation; —than suffer their priests to go in quest of a beggarly education to foreign universities, where they glean up nothing but the quibbles of sophistry, and the babblements of casuistry; and then come home again replete with foreign prejudices, and all their native imperfections on their head?




---

p.321


These arguments, dispassionately weighed, might suffice to answer all objections against the toleration of Irish Papists. But still it is asked, How did they behave when they were tolerated? To which I must answer by another question, At what time were they tolerated? It is said, and it is written that they were in the full enjoyment of the same privileges with Protestant subjects at the breaking out of the rebellion in 1641; but let us examine into the foundation of this assertion, by taking up the matter from the beginning.


In the reign of Queen Elizabeth, at a time when the English was a tongue almost as much unknown in Ireland as the Latin, and consequently when the Liturgy was scarce more understood than the Mass-book, a penalty of a shilling a Sunday was exacted from all such as refused to conform to the worship of the church of **England**. James, by proclamation, commanded all the popish clergy to depart the kingdom in a limited time; and upon non-compliance, they were thrown into prison by the Lord Deputy. That royal pedant would have had no objection to a religion, which preaches up passive



---

p.322



obedience, if the Pope had not arrogated a fight to *dethrone and decrown Kings.* When King of **Scotland** *only* he had been treating with the Pope; and the Irish Papists were thence taught to believe that he favoured them in his heart, which may account for their indiscretions at that period.


It was not, however, without good reason that they rose in a flame at their clergy being thus illegally imprisoned; they argued justly, that the crime of recusancy had its penalty ascertained by the statute of Elizabeth[38](javascript:footNote('E770001-002/note038.html')). The King therefore found it expedient, to recommend to his deputies here, the gentler mode of instruction and exhortation, for reclaiming the papists. And happy had it been for this nation, if that method had been invariably pursued in that and the succeeding reign; but so it happened, that the governors of Ireland had such an aversion to Popery, that, under Charles, fifteen Romish chapels were shut up in one day.


Was this toleration of religion? Certainly not. Were their temporal rights



---

p.323



better secured? Worse, if possible. The
great **O'Nial, earl of **Tyrone****, was attainted upon the sole evidence of an anonymous letter, dropped in the privy-council chamber. By his imputed guilt, six whole counties in Ulster escheated to the crown; with which the King gratified his kinsfolk and dependants of **Scotland**. And as if
these were not enough, a Court of Inquisition upon titles was set up; whose decisions were so unjust, that neither the laws of nature, nor of custom, nor even possession for centuries, could preserve to Roman Catholics the estates of their ancestors. It did not use even the ostensible pretext of religious criminality, or civil delinquency; its only object was defect of title, and every title was adjudged defective, for which a deed, or grant of conveyance from the crown, could not be produced, or at least proved. Upon this *finesse* of law, what estate could be secure? Prescription became of no use, and the oldest tenures were in greatest danger from the ruins of time, or the injuries of accident: even the new might have perished in such a series of war and confusion, when private houses and



---

p.324



public offices were every day plundered and in flames.


Every governor of Ireland under Charles pursued the same detestable measures: **Earl Strafford** figured in the van. This insolent Lord Deputy confiscated many unforfeited estates, and seized them in the name of the Crown. His master behaved with his wonted duplicity; he promised the Irish what he called his graces, similar to our petition of right, but never granted them, holding them still out as a lure for a new subsidy, with a threat to streighten them if they refused to comply. Indeed, when that unhappy prince tottered on his throne, when the conduct of his favourite had co-operated to render him odious; but above all, when he wanted the assistance of an Irish army against the English parliament, then, and not till then, did he transmit his consent to the act of Limitation, relinquishing all farther inquiry into titles. But by that time the sovereignty had passed from Charles, and the parliament was paramount. The sceptre of Ireland was by them committed to the hands of two Lords Justices, **Parsons** and **Borlace**, men of narrow, puritanical



---

p.325



principles; whose interest it became, as much as it had been of the decollated **Strafford**, to provoke farther escheats. They eluded the King's intention, by adjourning the parliament in the year 1641, contrary to his Majesty's order and interest, and to the great discontent of the commons and all pacific reasonable men. Thus were the sacred rights of justice and humanity trampled under foot by sordid avarice, goaded on by fanatical zeal.


Had the King's intention been honest, they would have frustrated it, in opposition to his interest; but as the passing the act of Limitation would have secured the property of so many Popish families, they defeated it, in subservience to their own. In short, they did every thing they could devise, to exasperate these poor people, and precipitate them into the rebellion, which they had repeated intimations was kindling in Ulster, without taking a single step to extinguish the embriotic flame.


A rebellion at length broke out on the 23d of October 1641, which, after the massacre of Paris, on the eve of St. Bartholomew, furnished as many tragic scenes as 



---

p.326



any in civil or ecclesiastical history. But the Irish affair was a work of mercy to that of **France**. There, superstition, for I cannot call it religion, operated alone. Here, religious zeal was sharpened by oppression both spiritual and temporal; the enormities committed were perpetrated by the scum and dregs of the people; and even these were exaggerated in a tenfold proportion: whereas the most elevated ranks in Paris were personally engaged, and their hands stained in the blood of their nearest relations. The murderers of Paris were the ruling and triumphant party, and therefore, we may suppose their case is represented in the most favourable light. Whereas the Irish accounts come all, or moslty, from the governing and successful side. In the Roman history, the Carthaginians are ever and anon stigmatised as perfidi, crudeles, foedifragi; and therefore Carthago delenda est. But let us, despising declamation, advert to facts.


If **Sir William Petty** had prejudices, it is evident they could not be in favour of the Irish, for he was one of the great gainers by their supposed guilt, and consequent forfeitures. Yet after demonstrating that the



---

p.327



number of Protestants destroyed in the whole war by the Papists was not one-fourth of what it was reported to be, he goes on to shew, that, before the war, there were in the whole realm, but three thousand landed Papists, of whom, as appears by eight hundred judgments of the court of claims, which sat anno 1663, upon the innocence and effects of the Irish, there were not above a seventh part guilty of the rebellion. And after assigning some motives for the Irish entering into this war, he concludes his chapter with these most remarkable words: ‘But upon the playing of this game or match upon so great odds, the English won, and have, among and besides other pretences, a gamester's right at least to their estates. But as for the bloodshed in the contest, God best knows who did occasion it.’[39](javascript:footNote('E770001-002/note039.html'))


Adieu.




---

p.328


  
**Dublin**


I have now before me a book, intitled, The Case of Ireland, being bound by acts of parliament made in **England**, stated; written by **Mr. Molyneux**, who speaking of **Mr. Locke**'s Treatise on Government, calls the author his excellent friend. It was natural to expect, that an intimacy should have subsisted between such congenial cotemporaries.


The design of this book is to shew, that Ireland is *of right* free as **England**, and may not therefore be bound by English acts of parliament. In order to demonstrate these propositions, the writer sets out with shewing, that Ireland cannot be called a conquered country, even in the sense that **England** is said to be so, by the Conqueror: for William obtained **England** by a bloody fight at **Hastings**, whereas Henry received not the least opposition in Ireland. Henry came over and made large concessions of she same laws and liberties enjoyed by the



---

p.329



people of **England**, and the Irish came in peaceably, and accepted the proffered terms.


After inquiring what title conquest gives, the author proves, from the laws of nature and of nations, that an *unjust* conquest can give no title at all; and that even a *just* one can give no right over the property or posterity, but only over the liberties and lives, of actual opposers; consequently, that it can give none over those who did not concur in the opposition, and still less, if possible, over those who assisted in the conquest.


He next maintains, that, even granting it had been conquered, and justly too, Ireland recovered its independence under John, whom Henry created King of Ireland; which was thereby set apart from **England** and continued a distinct kingdom, until **England** descended to John, a space of about twenty-two years; during which divers grants and charters to his Irish subjects were made, and are still in being. ‘Volumus, quod, in signum fidelitatis vestrae tam praeclarae, tam insignis, libertatibus, regno nostro Anglicae a patre nostro & nobis concessis, de gratia nostra & dono, in regno Hiberniae gaudeatis, vos et vestri haeredes in perpetuum.’




---

p.330


This grant was confirmed by Henry III. in the Irish Magna Charta. And from that time **England** and Ireland have had separate jurisdictions, and remained independent kingdoms, under one head, without any subordination of the one to the other.


In the reign of Henry IV. it was enacted in the Irish parliament, that no statutes made in **England** should be in force in Ireland before they were allowed and published in the parliament of this kingdom. In the succeeding reigns several English statutes were thus authorized in Ireland; till at length, in the reign of Henry VII. all the English statutes were grafted upon the Irish stock.


He endeavours to answer objections to the claims since made of English acts binding Ireland, where Ireland is particularly named. He shews, that when those acts were made, Ireland was in such confusion that she could not assemble parliaments of her own, but sent her representatives to **England**; and that the very same thing was done even so late as Cromwell's usurpation. As to the law passed in **England**, during Charles the First's tyranny, for levying



---

p.331



money in Ireland, that, he says, was made of no force by the acts of settlement and explanation, passed here in the reign of Charles II.


From these premises he infers, that so far are we from finding precedents antecedent to the restoration, for **England**'s parliament binding Ireland, that there is prescription for the parliament of Ireland repealing an act passed in **England**, relative to the affairs of Ireland. But, however speciously this writer may argue for the independence of his country de jure, it is to all intents and purposes bound de facto by English acts. The navigation ad expressly names and binds Ireland; for it compels all ships belonging thereto, importing goods from our plantations, to touch first at **England**. The acts too, prohibiting the exportation of wool, raw or manufactured, to any country except **England**, are firmly binding; by the first, it is made highly penal, by the last, felony of death.


After all this, would you not be amazed to hear a people thus shackled, talk of their liberties, their privileges, and their constitution? Yet this language is held here pretty



---

p.332



generally. Talk to an Irishman of a union with **England**, and he almost takes fire, what! — bereave us of our parliament, and then onerate us with taxes!


I once thought that the Irish constitution was formed upon the English model, and that it consisted simply of king, lords, and commons; but if it were originally so framed, it is now totally altered, for at present it consists of five branches at least. By an act managed by a Lord Deputy, called **Poining**, in the reign of Henry VII. it was provided, that no bill should appear before either house of parliament, which had not been approved of in **England**. If a member wishes for an act, he brings in what he calls *the heads of a bill,*— which heads, if approved of in his house, must next undergo the scrutiny of the Irish Privy Council where all matters suspected of being offensive to government are generally strangled in their birth. For the members of this council are put in, and turned out, at the royal discretion. But if the matter of the bill passes this board, it must next suffer a revision in **England**, from whence it is transmitted, if approved; or never more heard



---

p.333



of, if disliked. The *heads* returned from **England**, are again brought into the house where they originated, under the form and name of *a bill,* which house,— if unaltered, — it passes, and so on to the other two members of the legislature, as with us.


The English and Irish constitutions are, you may observe, fundamentally different. The Privy Council of **England** is the most potent branch; next to that the Privy Council of Ireland; lords and commons are mere ostensible forms, except to grant money. For though bills apparently take their rise, in one or other of their houses, they all, virtually, originate in the Crown;—the other branches have only negatives.


But if we enter a little farther into this matter, we shall find, that the legislature of Ireland may be said to consist of six parts; for the King and council refer the *heads of each bill* to the examination of *two men,* the attorney, and solicitor-general; and if they report them to be prejudicial to the trade, or derogatory to the dignity of **England**, they are either altered or detained.


When the crown lawyers have made such alterations in the deliberations of this nation



---

p.334


*as they think fit,* then they are returned under the great seal, and must be either passed, or rejected, in the very form in which they now stand.


Such is the constitution of Ireland, about which her patriots make such a pother! Yet to see the galleries agitated, as they are, by the harangues in the House of Commons, is almost incredible. You would think from their anxiety, that national salvation depended on the fate of a question; upon which, let it go as it may, there are so many other checks and controuls, that it seems astonishing how people can be thus duped every other year.


If this kingdom ever had a free legislature, it has been long lost, and therefore it is full time to give it a new one; for to restore it to its first principles, is morally impossible, and if it were possible, it is not desirable. The Irish should be glad to accept, and the English ready to impart to them, the benefits of our equal constitution. I should not take up this imperative style, if all our writers upon the subject, for the last half century, had not pressed home the same matter in the strongest terms.




---

p.335


As the grand remedy for the decline of foreign trade, **Sir Matthew Decker** proposes ‘to unite Ireland, and to put all the subjects of these three kingdoms on the same footing in trade.’ **Sir Josiah Child** recommends the same measure. **Dr. Campbell** says, that the main drift of his Political Survey was, to open men's eyes on the ‘importance of uniting in the firmest, closest, and most effectual manner, all the parts of the British territories, as being at once the only natural and certain means of establishing the grandeur, procuring the safety, and fixing the permanency of the British Empire; a triple alliance, or rather strict union between **England**, **Scotland**, and Ireland, being the only league necessary to make his Britannic Majesty the most potent monarch of Europe.’


This, one would think, is pretty strong language; and yet, when I once conversed with him on this subject, he told me he had only given hints, being unwilling to speak out, considering the prejudices on both sides the water. **Dean Tucker** speaks the same language, and every where insists upon the advantages that would accrue



---

p.336



from this measure. **Sir William Petty** saw it in its true light, at a very early period, and points out, as ‘the first impediment to **England**'s greatness, that the territories thereto belonging are divided into so many kingdoms, and several governments, viz. there be the three legislative powers in **England**, **Scotland**, and Ireland, the which instead of uniting together, do often cross upon one another's trades, not only as if they were foreigners to each other, but sometimes as enemies.’


If authorities were necessary, I could produce many more to the same purpose but authorities may be silent, where reason speaks so loud. From the union of **England** and **Scotland**, we have had the experience of consequences mutually happy in every respect. Can we doubt of still greater advantages from annexing Ireland to the other two? Since the soil, climate, and extent of Ireland are so superior to those of **Scotland**. Far from being an objection, the insular form of Ireland is much in its favour, by giving it a more extensive coast, 800 miles in circumference. It is worthy observation, that this kingdom, though



---

p.337



consisting of near 2000 square miles, is not, one place with another, above twenty-four miles from the sea; and when the canals, now making, are finished, three or four counties only of the whole will be without an inland navigation. As well might we suppose that **England**, if subdivided as under the Saxon Heptarchy, would not lose her consequence among the States of Europe, as that she would not become more wealthy, vigorous, and flourishing, by having Ireland joined with her under the same legislature. Vis unita fortior.


If we could suppose another Yorkshire, or Lancashire, or both, to be superadded to **England**,— or that the channel were converted into dry land, and Ireland become part and parcel of **England**, will any body be so sceptical to doubt, whether such an accession of territory would augment the influence of the British crown? Are our European dominions of such an unwieldy bulk, that we never stand in need of men to recruit our fleets and our armies? Are not numbers of people, the riches, the bulwark of a state? It would only argue ignorance



---

p.338



of the fact, to object that Ireland could not be so well improved, nor consequently as populous as Yorkshire, Lancashire, or any other of our shires. The most northerly counties of Ireland are asserted to be as populous as the best parts of **England**; yet they are the worst lands in the kingdom, and within a century were the most thinly inhabited.


There was a time when it was the language of our hot-headed politicians,— happy would it be for **England**, if Ireland were sunk in the bottom of the sea! Even so late as the usurpation of Cromwell, it was proposed by the author of Oceana, ‘to exterminate the natives, and repeople with Jews; for that the English planted there, whether from the faults of the soil, or vices of the air, had always degenerated.’ But a short interval has reprobated the principles of that splenetic republican. It is now pretty well understood that Ireland is one of the brightest jewels in our imperial diadem. And to recur to physical causes, for political effects, is among the reveries of a crazy brain. **Sir William Petty**, Harrington's contemporary, who, having



---

p.339



spent much of his time upon the spot, Is certainly a far better authority, saw this matter in another light: discoursing of the natives, he writes thus: ‘For their shape, stature, and complexion, I see nothing in them inferior to any other people: their laziness seems to proceed rather from want of employment, and encouragement to work, than from the constitution of their bodies; for what need they to work, who can content themselves with potatoes, whereof the labour of one man can feed forty?And why should they breed more cattle, since it is penal to export them to **England**? Why should they raise commodities, since there are not merchants sufficiently stocked to take them? And how should merchants have stock, since trade is prohibited, and fettered by the statutes of **England**?’[40](javascript:footNote('E770001-002/note040.html')) 


Though Ireland traces her antiquity up to Japhet, she is not, at this day, four-score years old in the line of improvement. Till the reign of James I. our laws never had the shadow of obedience, out of what was called the English pale. The rebellion of 1641 soon followed, and the war of



---

p.340



1688 closed the scene of blood. Before the revolution there was no permanent tenure of peace, and to repair the necessary devastations of almost continual warfare, we must deduct many of those peaceful years.


It must, however, be related to the praise of Ireland, that within this short period she has established one of the greatest manufactures in the world, and that too in the most northern, mountainous, and barren part of the kingdom; whilst the internal, southern, and fruitful parts, with scarce a remnant of manufacture, are verging to depopulation. A very singular phenomenon this, that the prosperity and happiness of a people should be inversely as the fertility of the districts they occupy!


Adieu.




---

p.341


  
**Dublin**


That a thorough incorporation of **Britain** and Ireland, under one legislature, with a perfect community of privileges, would be mutually advantageous, appears to me an intuitive, rather than a demonstrative, truth: therefore, without entering into any deep detail, which would only perplex the subject, I shall enumerate a few of the many advantages that might be derived from such a union.


The British empire in Europe being thus embodied, and, as it were, knit together by affection and interest, would become a more firm, vigorous, and weighty counterpoise, for its extensive and united dominions in America. An accession of 17,000,000 of acres, fourteen of which in fertility are not inferior to **England**, and in extent equal to **Scotland**[41](javascript:footNote('E770001-002/note041.html')), would be a new field for the extension of that tillage, which we complain 



---

p.342



is declining at home; and of course would become a nursery for that class of men which is failing in **England**. For if there be any truth in political arithmetic, our people have decreased near a million and a half since the year 1690, notwithstanding the increase of **London**, **Norwich**, **Liverpool**, **Manchester**, **Birmingham**, and other great towns; the loss having fallen principally on the inhabitants of cottages. But however this fact may be disposed of, certain it is, we cannot have too many people at home; and, if Ireland were fully peopled, we need at no time have recourse to foreign mercenaries.


The return of houses in Ireland for the year 1754, was 395,439, and for the year 1766, it was 424,046; supposing therefore the numbers to have increased at the same rate in the nine succeeding, that they did in the twelve preceding years, the number of houses at this day would be 445,501. Which, allowing five to a family, will make the number of souls in Ireland 2,227,505. But as the return of houses by hearth-collectors is rather under than above the truth, and as there are many families in every



---

p.343



parish of this poor country, who are by law excused from that tax, and therefore probably not returned[42](javascript:footNote('E770001-002/note042.html')), the number of souls in Ireland, upon a moderate estimate, will be 2,500,000.


As no part of the kingdom, except some northern counties, is fully peopled, and as the fruitful parts of the south might, if properly cultivated, easily support five times as many as now live there, without diminishing the numbers of sheep and bullocks, it is manifest, that the whole island might not only supply our deficiency of 1,500,000, but might even support double its present numbers. The island of Java is less than Great Britain, yet it is said to contain 32,000,000 of inhabitants.


**England** would gain by encouraging tillage in Ireland; for that would enable her to cheapen her fabrics at foreign markets. If we would keep down the exorbitant price of provisions, instead of prohibiting the exportation of corn from this country, we



---

p.344



should permit it, not only to all places, but at all times, except when the value exceeds a given standard. Would not the importation of grain from Ireland be more easy and expeditious than from America?


**England** would gain, *immediately,* by suffering Ireland to indrap her own wool; for she would recover two parts of that share of woollen trade she has lost abroad, by permitting this kingdom to gain the other third; as I think has been already proved in my letter from Cork. And she would gain, *mediately,* by weakening those competitors, who are at present beating her out of the market, both in the Levant and Portugal. If the English and the Irish were the only nations who could carry on any considerable woollen manufacture, it might perhaps be expedient in the former to tie up the hands of the latter. But if it cannot be confined to English territories, and if we are to be undersold, would it not be more politick to resign the market to the Irish than to the French? The wealth of Ireland is as much ours, as that of Cornwal or Northumberland.




---

p.345


**England** would gain by the taxation of Ireland, which in time would be able to bear a part of the burden, proportioned to her extent. At present, indeed, she is able to bear but a small share; being, as is said, taxed more heavily already, in proportion to her ability, than **England**. For it must be considered, that Irish absentees, who enjoy the most valuable landed properties in the kingdom, contribute not a shilling to the support of that government which protects them. An attempt was made a few years ago, to lay some very light tax upon them, but this was defeated by the cabals of faction. A land tax, if it were raised as a substitute for others, which oppress the poor, would be a desirable thing in this country, as it would oblige the absentee to pay something. If on the other hand it should fall ultimately on the tenant, it would serve only to fill up the measure of oppression.


A tax upon land is of all others the most equal; for if fairly laid, the rich pay it, and it does not fall, as most others do, upon the industry of the poor; an acre when cultivated, not paying more than the same



---

p.346



in the state of nature. I pretend not to define either the mode or measure of taxation. But if a union of the two kingdoms should at any time take place, the necessity of taxing this country lightly at first will be evident; little or no advantage could be reaped from it in the beginning. The increase of taxation should be gradual, and keep a cautious pace with the augmentation of trade; of which the legislature, for the time being, will be best able to judge.


**England** need not be afraid that any encouragement given to Ireland would make a sudden alteration; enthralled by evil habits, perfect freedom would not at once emancipate her. Manners have a greater influence than laws. It would require much time, and a fostering hand to rear industry, though planted ever so carefully. Before it would bear the rich fruits of arts and commerce, a long series of years would pass away. You have seen a horse who has been thrown, and bound to have some operation performed on him, yet continuing to lie still, after being loosed from all his cords. Just so would it be with Ireland.



---

p.347



A considerable portion of time would elapse, before she would begin to exert the powers she possessed. ‘**England** would be profited, says **Decker**, by opening the trade of Ireland. Which country being too poor to give it the extent it is capable of, it must therefore be carried on, for years to come, by English stocks. Consequently, a great part of the profits of it must fall into the hands of the English merchant.’


The vintage may grow in Ireland, but, if not pressed there, it will certainly be drank in **England**. The seat of empire will ever be surrounded by the vain, the affluent, the ambitious, and all who affect distinction. But so much must still remain, as to put the lower classes of the people almost above the envy of the present race of scare crows, who guard the bullocks and the sheep, in the enjoyment of these fertile plains.


Where then would be the harm, if it could be so managed, that in another age, Ireland could be weaned from that habitual idleness we so much and so unjustly blame? Could we be injured, if instead of indigent and insurgent, she should become opulent and civilized? Would it not be profitable



---

p.348



to turn as many hands as possible to industry? Do we not universally complain of want of labourers and manufacturers? Would not the population of Ireland supply these? Is **England** a country of such enormous size, that it would be more weakened by an extension of territory at home than abroad? If the resources of **England** could be increased, in the same proportion with this enlargement of her boundaries, would it not more than compensate for the defection of America, which now seems not more removed in distance, than estranged in affection from the parent country?[43](javascript:footNote('E770001-002/note043.html'))


And even granting that a reconciliation between Great Britain and America should take place, does not every encouragement given to the latter, tend to the immediate depopulation, and consequent ruin of these nations? Place but America upon the footing it was a few years ago, and they will migrate thither in thousands, and ten thousands, from both these islands.


We must at length see that it is not our wisdom to aggrandise America, at the expence of more domestic interests. By



---

p.349



granting a bounty upon American hemp, we effectually prohibited the importation of it from Ireland, and put a stop to the growth of that necessary article, in a country so generally fit for it. By relaxing the navigation laws of Ireland upon non-enumerated[44](javascript:footNote('E770001-002/note044.html')) commodities, we at once put 150,000 l. year into the pockets of the Americans; but by compelling the Irish to land their sugars, and other numerated articles in **England**, we teach them to smuggle, and carry on a clandestine trade with the French. We must blame ourselves, that an extent of so fine a country is not of more advantage to us. Private interests and public jealousies, are the grand obstacles to its prosperity and our own greatness.


Instead then of cramping, we ought to enlarge the trade of Ireland, and invest her with all our privileges. It is our interest to impart to her every advantage of a free constitution, as we have done to **Wales** and **Scotland**. It is not to be expected that she should obtain such terms of taxation as **Scotland** did; which, in that respect, is much better off than even **England**. Her taxes can never rise above a given sum,



---

p.350



though her wealth, and consequently her ability to bear a much greater burden, is every day increasing. But there were good reasons, then subsisting, why **Scotland** made
so advantageous a bargain.


Farewell.

  
**Dublin**.


From the general view I have taken of the mutual advantages resulting from a union, you must, I flatter myself, be inclined to think that nothing could more directly tend to the future aggrandisement of the British Empire at large. It will, however, be vain to plead for it, unless it can be demonstrated, that a measure so generally beneficial, would not prove detrimental to those who have the influence and power to obstruct it. There are violent popular prejudices on both sides the water against it; which very opposition of sentiment furnish a presumptive argument in its favour. But let us examine the most material of these objections.


Some of our merchants allege, that if we put the on an equal footing with



---

p.351



ourselves, they will at once monopolize our trade; the situation of their island being better, with respect to commerce; their havens safer, and their ports more numerous.


Our manufacturers cry out, we shall be undone, for the Irish, who can live upon potatoes, will be able to undersell us at every market.


The farmer urges, if you let the Irish export their corn, we shall not be able to pay our rents; and the landlord concludes, that of course the value of lands will fall.


The politician argues, by admitting into our legislature such a number of additional peers and commoners, we throw a dead weight in the scale of government, and so overturn the just balance of our constitution.


And the populace exclaim with clamorous voice, — What! Denizen the whole Irish nation, and convey the birth-right of Englishmen to above two millions of bogtrotters; Liverpool, Bristol, and all the sea-ports on the western coast instruct their representatives;



---

p.352



Birmingham, Sheffield, and other inland towns *memorial* government, not to execute a scheme, so big with ruin to the manufactures, the commerce, and the liberties of old **England**.


Audi alteram partem. The merchant need not be alarmed for his trade, for trade cannot be carried on without stock, and stocks the Irish have not; and if they had, they have neither the habits, nor the knowledge of commerce. No sensible alteration can possibly happen for this generation, unless our merchants should open warehouses in the Irish ports, and then they would profit themselves without injuring their native country. This method is already adopted in the linen trade of Ireland, which owes much of its success to the English capitals which are embarked in it. One would think that political wisdom might, at this day, be old enough among us to be convinced that no trade can be overstocked in a free country, if all the departments are fitly arranged. Trade begets trade, as merchant begets merchant; arts produce arts, and inventions pullulate from inventions. There will be room enough, at all times, for the full exercise



---

p.353



of all the industry of both countries, without any clashing. The fisheries, the carrying business, &c. are all open and monopolized by the Dutch. Does London thrive the less, because Liverpool and Glasgow grow wealthy? Mistaken maxims, and selfish policies so mix themselves in public councils, that the most certain and weighty interests of the community are frequently sacrificed to the most doubtful and trivial private advantages.


Birmingham and Sheffield may sleep secure upon their smoky pillows; for Ireland imports her coals from **England**, and, therefore, will not heat a furnace more for half a century, though an union should take place to-morrow. They need not fear being undersold, though the Irish at present drag on a miserable life upon potatoes. They should consider, that their Vulcanian sons could not subsist upon such spare and meagre diet. If Ireland, or any part of it, should ever ply the anvil, her *Cyclops* must live like those of **England**, the fledge must be wielded by force of beef and pudding. Brought upon a level in the article of subsistence, there is no reason why she should



---

p.354



supplant them, but every reason to the contrary. It is demonstrable, and it has been demonstrated by **Dr. Tucker**, that a poor nation can never carry away from a rich one, those manufactures, the cheapness of which depends chiefly on large capitals, and complicated machinery. The Scotch live not more expensively than the Irish, yet experience proves that no English manufacture has been injured by their competition since the union.


The only manufacture now prohibited, which could in a short time avail the Irish, is that of coarse woollen drapery, which we have already shewn would be the most sure buttress, and firm support of **England**'s declining trade in that article; as will be made still more evident by what we are going to say in answer to the objections of the farmers, and their landlords.


The one thinks that he keeps up the price of his grain, and the other of his lands, by discouraging Irish agriculture; but they should at the same time consider that trade is the source of the high value both of lands and provisions. Whatever promotes the general trade of a country, raises the 



---

p.355



price of lands by the greater demand for its produce, and consequent influx of cash. The granting this country a liberty of exporting grain at all times, would more contribute to raise the rate of lands, by an increase of commerce, than to lower them by diminishing the price of their productions. The abundance of provisions permits the manufacturer to sell his fabricks cheap abroad; and a multiplication of consumers enables the farmer to pay his rent at home.


A redundancy of the necessaries of life is the last thing to be dreaded in a manufacturing and trading country. The Hollander sees this, and therefore sets no bar against the importation of provisions, come from whence they may. And therefore, never feeling scarcity, he is ever able to undersell his neighbours. The high rate of provisions abridges the consumption of manufactures, and of course beggars the manufacturer. Accordingly we may every day perceive an increasing poverty among our labourers, journeymen, and lower mechanicks; who must therefore migrate into other countries, where the means of living



---

p.356



are more easily earned. Whether the decrease of our lower people proceeds from this or other causes, the fact is, that the dearness of provisions has been the complaint for several years past. As a remedy for this evil, ought not these idle hands to be employed? By encouraging Irish agriculture, we shall have more convenient supplies for our manufactures than from America; and whilst we are repairing the wastes made by pasturage here, we shall be filling up the gap made in our numbers at home.


But our political objector is still to be answered. And he argues from the remote sources of ancient history. He tells you that the Roman constitution was impaired by the incorporation of the Italian States, and destroyed by the enfranchisement of their other conquests. Now, though the empire did decline after the last of these aeras, it does not follow that its declension proceeded from that cause.


Besides, the union of the States in **Italy**, and out of it, are separate questions; neither of which properly apply to the case in



---

p.357



point, as the learned must easily see. The empire became a body too unwieldy for the government of one head, and was overset, not by foreign voters, but by foreign mercenaries. Had **Italy** borne a larger proportion to its conquests, it would have been much safer, as it would have had more internal strength to command obedience. The vicinity of Ireland makes me consider it, in a political view, as part of **Britain**, the junction of which would increase the power of the latter to govern its foreign dependencies.


The giving the right of Roman citizens to foreigners, no doubt was sufficient to overturn the balance of power in the little republic of Rome; but the republic of Rome, and the Roman empire are very different objects. When Rome and its conquests were under the government of one man, its security depended on the firm union of its European territories. The want of this union divided the eastern from the western empire, and at length subdivided both into their original number of States.


If a parallel is to be drawn between Rome and **Britain**, as to a union with 



---

p.358



their dependencies, we should consider Ireland in relation to **Britain**, as one of the Italian States in respect to Rome; and America as the African and Asiatick territories. Yet I question whether any just parallel can be drawn even this way; so different are the manners of the people, and the spirit of antient and modern government. Be that, however, as it may, it cannot be conceived that a member from each county in Ireland, and from three or four of its best towns, with twelve or fourteen Irish peers, could endanger the liberties of **England**. Nay it is evident, that if the universal happiness of the people be the perfection of government, this measure seems absolutely necessary to complete our constitution. For how can that assembly, whose decisions regulate the whole, deliberate equitably on the interests of the several parts without information? And can information come with such truth and propriety as from representatives?


As to popular objections, they are as infinite as they are nugatory, and therefore I shall bid both them and you farewell.




---

p.359


  
**Dublin**.


That a political and commercial union of Great Britain and Ireland would be mutually advantageous, I have endeavoured to shew. **England**, like an old merchant, by admitting a young one into partnership, would not only increase her capital, but would be eased of much labour, to which she is become unequal; and Ireland, as the new one, would not only get customers, but knowledge and ability to apply her capital to the best advantage.


Yet the objections against the measure are full as numerous in the meridian of Dublin, as in that of London. If a candidate for any county were supposed capable of favouring such a destructive scheme, it would be sufficient to defeat his election. It is hung up to the fearful multitude, as a bugbear, by ambitious men, who solemnly promise to use all their eloquence and interest against it. One would, however, think there could be nothing so formidable to



---

p.360



Ireland, in being invested with all the privileges of old **England**.


The people are industriously misled in their opinions on this subject. Every corporate town in the kingdom has the ruling and interested party to sound the alarm; for as they would all lose the right of returning members to parliament, and of course their consequence, they represent every plan of incorporation as pregnant with dishonour and ruin. The first magistrate, aldermen, and burgesses, who share the emoluments of the borough every eighth year, declaim loudly against it, at their city feasts, and corporation dinners.


The capital in all countries takes the lead in fashions of every sort; and that it should be the fashion to talk against a union in Dublin, is not unnatural. Dublin is not like Cork, as you might suppose, a city supported entirely by commerce; it is very much upheld by being the winter's residence of people of fashion, especially during the sessions of parliament. It would therefore be as popular to decry the waters at Bath, to recommend a union in Dublin. The 



---

p.361



 
subject is, however, so little understood, that I should not be amazed, if the whole body of woollen weavers,— the very persons who would be the first and greatest gainers by the scheme,— were to take up arms against the promoters of it. The newspapers are generally stuffed with inflammatory declamation against it; they lead the cry, and the rest of the kingdom hark in, without looking farther, and thus confound the interest of Dublin with the interests of Ireland.


People accustomed to the pomp and pageantry of state begin to value them, and become unwilling to part with them. There will be always some particularly fond of magnificence, parade, and show; castle levees, castle balls, and battle-ax-guards. When the Lord Lieutenant goes to give the royal assent to their bills, the streets are lined with foot soldiers from the Castle to the Parliament-house, and a squadron of horse escorts him, with all the other insignia of royalty. A lady with whom I was sitting in a window, to view the last of these exhibitions, could not help asking me in a sort of exultation, — raised perhaps by the



---

p.362



trumpet and the drum, — Whether we had any thing like that in London?


But the Irish are not singular in their attachment to such matters. It was provided by a clause, added to the articles of the union of **Scotland**, that their crown and other regalia should remain at Holyrood-house. And such was the popular prejudice against the union, that while the treaty was in negociation at Edinburgh, it became necessary to call in the army to protect the houses and persons of those who were supposed to favour the measure. Yet every body knows that **Scotland** was the principal gainer by the bargain. Every prejudice, except that of religion, prevails here that did there, but upon a worse foundation.


Let us, however, endeavour to answer the most weighty of those objections raised by the Irish. They assert, that Ireland is already taxed higher than **England**, in proportion to her trade: one half of the national income being carried off by pensioners and absentees. And that, as she could not reap any immediate advantages



---

p.363



from a free trade, she would not be able to bear any additional tax at present. By way of reply to the first of these objections, we must observe that Ireland is rather unequally, than heavily taxed; for resident gentlemen pay but little, and absentees pay nothing towards the expences of government. An equitable taxation, therefore, can only be expected from an incorporation with **England**.


To the second objection it may be answered, that no tax, except upon land, should be levied, till Ireland shall have felt the commercial advantages of a union. It should be considered that the Irish parliament may at any time impose a land-tax, without stipulating for any compensation, by enlargement of trade; and that the burden may be made to fall on the tenant alone; whereas, if the tax were laid by the British parliament, care would be taken that it should fall on the landlord, as in **England**.


The drain from absentees is the only plausible argument that an Irishman, who means well to this country, can urge



---

p.364



against a union. Yet the additional expenditure from thence would not be so great as is apprehended. At present, almost all the great incomes are spent in **England**; men of small estates must live where the comforts of life are attainable at a rate suitable to their rent-rolls. Absenteeship would no otherwise affect Ireland, than it does the distant parts of **England**; which are now pretty much deserted for the town residence. But if commerce should once get footing, it would be here as in **England**; the absence of the gentry would not be so much regretted.


In a country so poor as this, the employment given to labourers by resident gentlemen, is a grand object; but if the country had the benefits of tillage and manufacture, it would scarcely be deemed an object at all. For suppose that a gentleman's park of five hundred, or a thousand acres, were possessed by fifty, or a hundred families of industrious spinners and weavers, would not the community be profited? In one case ten or twenty idle servants are supported, in the other several hundreds of useful mechanicks. A gentleman of two



---

p.365



or three thousand pounds a year, will probably not spend half his income in his country residence; and of what is spent there, how small a proportion is laid out on the products of Ireland? The butler wears English cloth, as well as the master and his sons; and it is well if the lady of the house content herself with English manufactures; she and her daughters are probably dressed in French silks. It is perfectly indifferent whether English woollen, or Irish linen, is worn in **England** or Ireland; so that in the article of dress, Ireland only avails itself of the liveries; and as to the table, she only furnishes the necessaries of life; all the rest are foreign luxuries, tea, sugar, spices, wines, &. &c. From the necessaries of life, no great advantage is received by the neighbourhood; the ground, however, which produces them might, as I have shewn, be very usefully employed. It is not here as in **England**, where they depend on the next market for their meat; here are no flesh markets, except in their best towns; every resident gentleman is obliged to kill his own beef and mutton.




---

p.366


Do not be surprised when I tell you there are so few markets; for where there are few buyers, there will be but few sellers; nor suppose that if the gentry did reside here there would be markets; there might be a butcher who would undertake to supply three or four gentlemen in a neighbourhood, but this would no more make a market, than the consumption of their liveries would create the weaving of wool. Nothing but wealth diffused by manufactures, agriculture, and commerce, can produce a regular supply of provisions in country towns. The demesnes of the lords and squires, well peopled with industrious mechanicks, subsisting by free trade, would more contribute to the markets, and other good national purposes, than the residence of them and all the absentees ten times told.


It should be considered that a mere circulation of cash can scarcely be reckoned beneficial to a country, but such a circulation as produces industry. Money, if it generates idleness, is an evil, not a good. The silver of Peru, and the gold of Mexico, have not made **Spain** rich, because they



---

p.367



did not make her industrious. An influx of money, from the residence of gentry, is seldom of important use; nay, I should imagine that it frequently does harm; for it creates a certain number of retainers and publicans, who depend on that alone for their support, which being withdrawn, they are reduced to helpless indigence. Accordingly, we in general find more beggary near the habitations of the great than elsewhere.


No town was ever enriched by a barrack; the money spent does not at all compensate for the idleness and debauchery it produces among the lower people. A town may subsist, but can never grow wealthy by letting of lodgings. If the springs were to dry up, Bath would return to its original nothingness. It would not be so with Dublin, upon the event of a union, because she has other resources than mere letting of lodgings: she would continue to be a considerable trading city; and the seat of government, and of the courts of justice. At present the centre of national amusements, it would still take the lead, in all the politer arts. Other towns would improve,



---

p.368



but it would not decline. I argue thus:
  

A free and unrestrained exportation would so increase the demands for Dublin manufactures, that it would be the first place in the kingdom to feel the advantages of an open sea. The interests of the comber, the spinner, the weaver, the dyer, the presser, the clothier, would more than counterbalance the losses of the milliner, the taylor, and the hair-dresser. The very trade of *poplins,* which are so universally prized, would become prodigious. Besides, the silk manufacture, which is solely confined to Dublin, would soon flourish; and the city would become a school, to which they would flock, from all other parts of the kingdom, for instruction in the principles of the mechanick and commercial arts. And there would be no danger of overstocking the several branches with artisans as at present.


There is one objection still behind, which being the only one common both to the English and the Irish, deserves particular notice. They generally agree, that as the linen manufacture meets with sufficient encouragement,



---

p.369



it might suffice to employ all the idle hands in the kingdom. But this objection, though plausible, can have but little weight with those who understand the state of the country. That business can never get footing, but where there is a plentiful supply of fuel; and though Ireland does in some places superabound with peat, yet I am told that about half the kingdom is destitute of it. So that however disagreeable the bogs of Ireland may appear, they are the prime sources of its wealth, for without them the linen manufacture could not so much as exist.


The linen trade, though in a condition so thriving, as to export two millions value yearly, is by no means co-extended with its turf-bogs; and farther, it never can be carried, except where coal is in great abundance. It must be observed, that there are other requisites beside fuel, and flax, and spinners, and weavers; the last hand is to be put to it by the bleacher. The bleacher cannot work without water, and falls of water, which are rarely to be met with, except in hilly countries: near the one half of Ireland said to be levels consequently,



---

p.370



the linen manufacture can never be thoroughly established in above one half the kingdom: and therefore, without the freedom of working up her own wool, she must remain, as it were, paralytic on one side.


But it would be well if one half were employed; for in districts susceptible of the business, it is still in its infancy. **Mr. Dobbs**, a writer of this country, computes, that in the year 1731, not above five counties were embarked in making linens. Let us suppose that there are now eight, and even then it will be established but over one-fourth of the whole.


From this view, one can scarce help upbraiding these people for their tardy progress in this trade. I have frequently done so from the impulse of feeling, but now correct myself by considering how much has been done, and how difficult it is to eradicate old habits, and acquire new ones.


At the conclusion of last war, this kingdom was in a more flourishing condition than at present. The high rents raised such a spirit of discontent, that ever since the



---

p.371



peace, so advantageous to America, they have been migrating thither, in such numbers, that the price of lands is said to have fallen near a third. The exports of linen too have decreased in the same proportion, the emigrants being mostly weavers. For the two last years, indeed, the disturbances in America having checked this roving disposition, the trade has revived, and the rents have risen. But how must both for ever languish, if upon the resettlement of affairs, America should improve her civil constitution?


This, and every other consideration, should make us think betimes of putting this country upon such a footing, that it may turn out to our greatest advantage, by letting every quarter of it exercise a trade best suited to its local circumstances, and by preventing it from wasting its days in the sombrous gloom of unjoyous indolence, and under all the pressures of hopeless and unpitied poverty. And it should be the policy of every Irish patriot, instead of opposing, to use his utmost endeavours to effect an incorporation of the two kingdoms.




---

p.372


It seems indeed rather a matter of surprise, that government has not long ago interposed to make it palatable to both nations. For, however prejudices may prevail on both sides, right reason and self-interest should direct all parties to bring it about as soon as possible; that so valuable a part of the empire may become as famous for arts and industry, as it is now infamous for the want of them; and that thus losing its evil habits, and its very name, it be no more Ireland, but West **England** or Little Britain, and that the stile of our Sovereign be *Britanniarum Rex.*


  
**Dublin**.


Your news-papers have thrown us all into a panick: They would make us believe that a sort of plague is raging in London, as well as in Paris. The good people here expect that it will be their turn next; for, they say, they feel every malady which affects **England**; flattering themselves at the same time, that it loses



---

p.373



much of its virulence in crossing the channel.


But let them say what they will about the malignity of infection degenerating before it reaches them, I am persuaded that this influenza, which they call the tail of an eastern plague, has already plumed many a hearse in this western isle.


A book put into my hand, shews that the return of this disorder, if not periodical, is at least frequent; for it appeared no less than four times during the forty years preceding that publication. The faculty are much indebted to the labours of the industrious author, whose name is **Rutty**. He was the first who methodized a history of the mineral waters of Ireland; and who gave histories of the weather, seasons, and diseases of Dublin; with a comparative view of the climate of Ireland, **England**, and other countries.


His observations are made on the forty years immediately preceding 1770, and he grafts them upon an estimate of the numbers which died in Dublin, of each disorder, during the antecedent period of forty



---

p.374



years, which he took from **Dr. Brian Robinson**, a name, like that of Helsham, celebrated in this country for physical and mathematical knowledge.


From the facts laid down in his comparative view, he infers that the general state of the climate, and diseases of Ireland, are pretty much the same as that of **England**, — with this difference, that neither heat nor cold are in such extremes here as there; which he accounts for from the situation of Ireland being farther out in the ocean, and from its nearer approach to the vapours wafted upon the wings of the W. and S. W. especially the former, which he shews, from the diaries, are more frequent here than in **England**.


From hence he deduces the salubrity of the climate of Ireland, — he shews also from the fact, that the inhabitants are as healthy, and extend the term of life as long as any other people. He confesses that this country has not unjustly acquired the appellation of *Matula Jovis*, from its redundant moisture; yet he holds it to be an error, that a humid atmosphere is inimical



---

p.375



to longevity. Though, says he, ‘we live in a constant *balneum vaporis,* yet the moisture and temperate quality of the air is a great advantage to us. For it not only secures us from the pernicious effects of heat and drought, but it likewise defends us from the ill effects of excessive cold and dryness; all which are productive of more acute, and violent inflammatory disorders than are found here; as appears from repeated observations. The watery vapours serve in some measure to correct the crisping and drying quality of E. N. and N. E. winds, and at the same time yield a constant fomentation to the fibres, and being imbibed by the cutaneous pores, dilute the blood.’


In confirmation of this theory, he observes, that the malignity of all epidemic diseases, which originate eastward, is mitigated here; there being something in the state of the air which resists the propagation of diseases, as well as of poisonous animals; and that the plague, which did so often and so cruelly infest **England**, was wonderfully rare in Ireland.



---

p.376



He shews that the weather is more variable, and the changes more sudden, than in ether countries; yet he argues, that these changes are not so considerable, nor so prejudicial to health, as the daily changes in warmer climates. Fahrenheit's thermometer never varies in the year more than from twenty-seven to seventy-five degrees; whereas, in South Carolina, a difference of 30 degrees in twenty-four hours, has sometimes been observed; the range of variation there being 83 degrees.


He lays down a table of the comparative heat of the seasons in London and Dublin, estimated by that curious observer **Dr. B. Robinson**.





| London | Dublin |
| --- | --- |
| Winter, 1.00 | 1.45 |
| Spring, 3.00 | 2.14 |
| Summer, 5.00 | 4.68 |
| Autumn, 3.00 | 3.80 |
| 12.00 | 12.07 |






From this greater warmth of air than is common in so northern a situation, he accounts for the perspiration of the human body being greater in Ireland than in **England**,



---

p.377



and nearly as great in Cork as in **Italy**; as it appears to be from the following medium estimate for the years 1721, and 1744:


Dublin, 0.980
  

Cork, 1.472
  

England, 0.817
  

Italy, 1.480


From a review of the bills of mortality for forty years in Dublin, he shews that the number of persons buried was remarkably greatest in dry years. All which, he says, is agreeable to Wintringham's observations of the moist seasons being more natural and healthful in **England**. From the concurring testimonies of the late English writers, compared with similar observations made here, it appears, that the seasons, wherein the *hygrometer* was most sensibly shortened, were remarkably free from all epidemic diseases; and that storms, the usual concomitants of rain, are also found, in both places, to be attended with more health, and less sickness, than calm weather; as dissipating the vapours, which by stagnation might prove dangerous.




---

p.378


He does not deny but that excessive and long continued rains, and moisture, are also unwholsome; and he admits that three out of four, in a long series of such years, turn out epidemick and mortal; but then he argues, that they have this effect, not primarily, but consequentially, as they corrupt and spoil the fruits of the earth.


As these conclusions are all drawn from experience, that great baffler of speculation, they seem very satisfactory. And what wonderfully corroborates them is, that from the observations made on the watermen of **London** and **Holland**, it appears, that this class of men, though perpetually inhaling aqueous humours, are as remarkable for health and longevity as any other people in the countries to which they belong.


Those bogs wherewith Ireland is in some places overgrown, are not injurious to health, as is commonly imagined: the watery exhalations from them are neither so abundant, nor so noxious, as those from marshes; which become prejudicial from the various animal and vegetable substances



---

p.379



which are left to putrify as soon as the waters are exhaled by the sun. During the overflowing of the Nile, **Egypt** is comparatively healthy; when the waters subside, putrefaction takes place, and the plague returns. Bogs are not, as one might suppose from their blackness, masses of putrefaction; but on the contrary, they are of such a texture, as to resist putrefaction above any other substance we know of. I have seen a shoe, all of one piece of leather, very neatly stitched, taken out of a bog some years ago, yet entirely fresh; — from the very fashion of which there is scarce room to doubt that it had lain there some centuries. I have seen butter called *rouskin*, — which had been hid in hollowed trunks of trees so long, that it was become hard, and almost friable, yet not devoid of unctuosity. That the length of time it had been buried was very great, we learn from the depth of the bog, which was ten feet, that had grown over it. But the common phaenomenon of timber trees dug out of these bogs, not only found, but also so embalmed as afterwards to defy the injuries of time, demonstrates the antiseptic quality of them.



---

p.380



That pair of horns of the moose deer, which you see in the British Museum, and by the way, I have here seen a pair much larger, — must have lain many centuries in a bog; for the Irish histories do not recognize the exigence of the animal whereon they grew.


They tell me that human bodies have, in many places, been dug up, incrusted some feet high with this substance, and yet entire. A case in point is reported in the Philosophical Transactions, No. 434., which is briefly this. — ‘Two persons lost in a great snow on the Moor of Derbyshire, January 14th, 1674, and not being found until the 3d of May following, they then smelt so strong, that the coroner ordered them to be buried on the spot. — They lay in the peat-moss twenty-eight years nine months, — when some countrymen having observed the extraordinary quality of this kind of soil, in preserving dead bodies from corruption, were curious enough to open the ground, to see if these persons had been so preserved, and found them no way altered; the colour of their skin being fair, and natural, and their flesh soft as that of



---

p.381



persons newly dead. They were afterwards exposed to sight twenty years, though they were much changed in that time, by being so often uncovered. In the year 1716, Dr. Bourne of Chesterfield was there, who gave this account of the state they were then in, viz. the man perfect, his beard strong, and about one-fourth of an inch long, the hair of his head short, his skin hard, and of a tanned leather colour; he had on a broad cloth coat, which he tried to tear a skirt off, but could not. Dr. Balguy, who communicated this account, after enumerating other particulars, concludes by saying, — the thing is very remarkable, as there are no means, I believe, of preserving dead bodies so well.’


I have, in the above accounts, always alluded to the growth of these bogs, as a known thing. Their growth, however, is variable in different places, from the variety of conditions in the situation, soil, humidity, and quantity of vegetable food; in some places it is very rapid, in others very slow; and therefore their altitudes cannot afford any certain measure of time. I have been at some pains to learn their theory, and



---

p.382



I flatter myself I am in possession of it. But, as I fancy you have got enough of them, I shall not attempt to explain it; all I shall venture to pronounce of them is, that they are *vegetable accretions.* If those who argue from definition should ask me, Are they organized bodies? I should answer, that they are as much so, as many fungous substances we see growing on trees, and elsewhere. But be this as it may, the state of the atmosphere is so far from being injured, that it seems to be meliorated by such masses of vegetation. Since, according to **Dr. Priestley**'s theory, the vegetable creation, instead of vitiating the air, reverses the effects of breathing and of animal and vegetable putrefaction, restoring to putrid air its original and vital purity. It seems a most rational system, that as putrid matter yields food for the roots of plants, so putrid air should afford nourishment for their leaves; which inhale the tainted particles, and keep the remainder of the air sweet and wholesome.


In the manufacturing counties of the north, I am told peat fuel is become so scarce that turbary lets from five to eight 



---

p.383



guineas an acre. In some places they are so eradicated, that there does not remain a trace of them; the ground being now converted into rich meadows, or sweet pastures. This explains what history delivers of our own country, that it was once over-run with bogs: Herodian reports that one half of **England** was full of them, and that the Romans employed their armies in draining them.


If we were to trust authorities, we must conclude, that Ireland was not originally inferior to **England**, either in the fertility of the soil, or salubrity of the climate. **Tacitus** says, there is very little difference, **Orosius**, that Ireland is less in extent than **Britain**, but more happy in the temperature of the air and soil. — **Isidore** and **Bede** speak to the same purpose. — **Cox**, an English writer of the last century, whose history discovers violent prejudices against the nation, has these words: ‘that Ireland is healthier than **England**, may be argued hence, that seldom any pestilential disease rages there, and no part of that kingdom is so unhealthy as the fens of Huntington,



---

p.384



Lincoln, and Cambridgeshires, the hundreds of Essex, and the wilds of Kent.’


I have seen an ecclesiastical constitution of Canterbury, dispensing with the non-residence of the clergy, on account of the unwholesome damps of that diocese. And I have it from a concurrence of testimonies, that the poor, who go over from this country yearly, to work at harvest in **England**, are generally seized with agues; which are very infrequent in any part of Ireland. The reason of which I conceive to be, there are here no considerable tracts of level marshy ground, the lands being generally diversified with hill and dale, and such of them as are flat are not swampy, but of a gravelly bibulous soil; so that after rain is over, there is scarce a vestige of it to be seen in most places. What we call clay ground is most rare, as far as I have observed. And we have seen that winds purify the air, by keeping it in almost perpetual motion, and by removing those noxious vapours that impregnate a stagnant atmosphere. Winds are infrequent in flat countries, mountains being the source of rivers, and the parent of storms.




---

p.385


Those sudden changes, and frequent winds, which render this climate so disagreeable to our feelings, are nevertheless the agents which purge and refine the air. We make the same complaints of our own climate, but this is still more mutable. The atmosphere is generally clearer in cold weather than in hot, and it is observable, that the dryness of air is sooner effected by the action of the wind, than of the sun; for the sun exhales vapour, but does not dissipate it; whereas, if the winds raise moisture, they also dispel it. Accordingly, fogs are more rare in hilly than level countries. I never saw any thing like a fog, during my tour through the country parts of Ireland.


‘Humida solstitia & hyemes orate serenas,’ was the precept of **Virgil**. Here he would have found both; where neither the scorching heats of Cancer drive men to the shade, nor the piercing colds of Capricorn compel them to the fire. But had the poet lived in Ireland, he would not have prayed for a wet Summer; for the history of this climate gives almost quotidian showers, for two months after the sun has passed the Summer



---

p.386



tropic. This must retard vegetation, and by combining this cause with that of the greater heat of **England** in Spring and Summer, may we account for the seasons being so much later here than there. For as to latitude, that can make no great difference, part of the county of **Cork** being more southward than **London**, and no part of Ireland being so northerly as some parts of **England**. But if the Spring does not set in so early, the Autumn tarries proportionably later; if the trees do not bud so soon, the leaves stick on longer; in November, not October, is the fall of the leaf. The reason of all which is evident from *the table* of the different degrees of heat and cold in the two kingdoms, in the same seasons; the superior heat of Ireland in Autumn and Winter, being more than a counterbalance for the greater heat of **England** in Spring and Summer.


Upon the whole, from what I have read, heard, and seen, I must join issue with **Cambrensis**, that ‘Nature has looked with a more favourable eye than usual upon this kingdom of the Zephyrs.’ And if a spirit of industry could be infused into the



---

p.387



people, by a just policy, their country would not be inferior to any other on the globe, under the same parallel. Till within the last century, there being a perpetual warfare between the native and the last comer, it became the barbarous policy of the times to encourage, instead of restraining, the growth of bogs. These stopped the progress of the English, and served as fortresses for their own habitations. And by thus consulting each his private safety, they abandoned that of the public. ‘Dum singuli pugnant universi vincuntur,’ is the remark of Tacitus on the like conduct of the Britons; for they, as well as the Gauls and Germans, betook themselves to their paludes, bogs, or fens, as a refuge to shelter themselves from the conquering Romans.


Similar causes must ever produce similar effects. Wherever a savage people are invaded and worsted, they will retire to their only fastnesses, bogs or mountains, and there prefer barbarism and wretchedness, to civility and abundance. Such is the inborn love of liberty! Bogs are, however, in my eye, a certain badge of slavery. Batavia was the most marshy, and boggy part



---

p.388



of Europe, till she shook off the Spanish yoke; **England**, after all the Romans had done and taught, continued in many places in her original state, till the alienation laws of Henry VII. These diffused landed property, and created a yeomanry, who soon asserted that charter of equality, and consequent independence, to which Nature had originally entitled them, and wherewith the spirit of their laws had now invested them. When each man could enjoy the fruit of his own labours, and transmit it to his son; when the poor and oppressed vassal became the thriving happy tenant; then, and not till then, **England** became what her and fancy's darling child describes, ‘another Eden, a demi paradise.’


Adieu.

  
**Dublin**


It would, I presume, be difficult to assign any reason, a priori, for that property in the climate of Ireland so baneful to poisonous animals. One might conjecture that the same temperature, which is unfriendly



---

p.389



to the orange and the vine, may be the agent which kills the adder, the toad, and the mole. But this reasoning would not apply to Crete; and Crete, they say, has the same property.

> 1. Cui Deus, & melior rerum nascentium origo,
>   
> Jus commune dedit cum Creta, altrice tonantis,
>   
> Noxia ne nostris diffundant sibila in oris.[45](javascript:footNote('E770001-002/note045.html'))
> 




It would be equally difficult perhaps to determine, admitting the fact, whether, and how far, climate has any effect in mollifying the muscular system, and producing that pliability of limbs, and activity of body, which has characterized the Irish nation[46](javascript:footNote('E770001-002/note046.html')). It seems, however, not unphilosophical to suppose, that, as the operations of the intellect depend so intimately on the texture of the brain, the same organization which generates agility of body, may conduce to a corresponding vivacity of mind.




---

p.390


But be this theory applicable to the Irish or not, it must be admitted that there was a time, when they possessed a greater share of learning than any other nation in the west. This we must allow, if we give any credit to history; I do not mean that written by the Irish themselves, but that supported by the concurring testimony of foreign writers. **Bede** speaks of Ireland, as the *great mart of literature,* to which they resorted from all parts of Europe. **Camden** says, "it abounded with men of splendid genius in the ages when literature was rejected every where else; that it is frequently related by our writers, in praise of a person's education, *Amandatus est ad disciplinam in Hiberniam. Et in Sulgeni vita qui ante sexcentos annos floruit legitur,*

> 1. Exemplo patrum commotus amore legendi
>   
> Ivit ad Hibernos, sophia mirabili claros.
> 




It was not therefore without sufficient reason that **the younger Scaliger** says, ‘Du temps de Charlemagne & 200 ans apres omnes fere docti etoient d' Irlande.’


As Ireland got the appellation of *Sacra* from its ante-venefic property, so it got that



---

p.391



of *Sancta*, from its being the nursing mother of many learned and pious men. Now they affect to call it *Insula sacro-sancta.* According to **Camden** and others, **Luxieu** Abbey in Burgundy, **Roby** in **Italy**, **Witzburg** in Frankland, **St. Gall** in Switzerland, **Malmsbury** and **Lindisfern** in **England**, and **Jona**, or **Hy**, in **Scotland**, were founded by Irish Monks. Bede relates, that Oswald, the Anglo-Saxon king, applied to Ireland for learned men to instruct his people in the principles of christianity. And **Rapin** has this remarkable observation: — ‘It is surprisingly strange that the conversion of the English should be ascribed to Austin; rather than to Aidin; to Finian, to Colman, to Cedd, to Diumna, to Furseus; and other Irish or Scots Monks,[47](javascript:footNote('E770001-002/note047.html')) who undoubtedly laboured much more than he. But here lies the case; these last had not their orders from Rome, and therefore must not be allowed any share in the glory of this work.’




---

p.392


Ireland did not become absolutely *popish* till after the English got possession of it; and thence may we discern the reason why the Pope was so liberal in his gift of it to Henry II.


*John Scotus Erigena*[48](javascript:footNote('E770001-002/note048.html')) was the first who wrote against transubstantiation, and the whole spirit of the church of Ireland militated against the encroachments of papal tyranny, till a temporal dominion made them bow the neck to a spiritual yoke. I have seen a folio volume in five books by him, intitled De divisione naturae, written in a style that would not be despised at this day. He must be distinguished from *Duns Scotus,* who figured in the 13th century; and for the honour of whose birth, these three nations have contended as eagerly as the seven cities did about that of Homer.


If you wish to see specimens of Irish composition in the middle ages, I would refer you to **Usher**'s Sylloge epistolarum Hibernicarum, which will abundantly gratify your curiosity, and perhaps reward your pains. The poems of Columb-cil may



---

p.393



perhaps savour of monkish quaintness, but his prose is replete with found sense, clothed in good Latin. He was of the blood royal of Ireland, the apostle of the Picts, and founder of the Abbey of **Hy**.


**Virgilius, sirnamed Solivagus**, a native of Ireland, and bishop of **Saltzburg**, must have been a man of more than ordinary erudition, for the eighth century; he ventured to assert the heretical doctrine of the Antipodes, ad of other planets besides the earth: which his infallible holiness thus interprets, — if Virgil maintains that there is another world, another sun, another moon, and that this earth is round, so that there is another sky opposite to our sky, and other men with their feet opposite to our feet, *Anathema esto.* **Galileo** was not the first philosopher whom the court of Rome threw into darkness, for attempting to enlighten the world.


The first professors in the University of Paris were from Ireland, and they tell you, that our Alfred brought professors to his newly-founded College of Oxford, from the same country. At this day, the patron saints of several nations on the continent, are acknowledged to be Irish. *Armagh* is 



---

p.394



said to have had several thousands of students at the same time; and there were other seats of learning not less famous. 

> 1. *Lismore,* long since the muses darling seat.
>   
> Of piety and learning the retreat,
>   
> Her *alma mater* shone as bright at noon,
>   
> As Oxford, Cambridge, or the great Sorbonne.
>   
> Time shifts the scene, — no longer now she boasts
>   
> Her churches, colleges, and learned hosts;
>   
> Nature, propitious to the favourite soil,
>   
> Restored her losses by the birth of *Boyle.*
>   
> Centred in him, her antient glory shone,
>   
> Who made all arts and sciences his own.
> 




  
**Dublin**


Having somewhat prepared the way, I come at length to hazard those conjectures I promised, by way of answer to **Spencer**'s question; *how comes it then that they are so unlearned still, being so old scholars?*


The fond advocates for the honour of Ireland would persuade us, that she has enjoyed a degree of illumination equal to any other country on the face of the earth while **David Hume** says, that ‘the Irish, 



---

p.395



from the beginning of time, had been buried in the most profound ignorance, — and that the incursions of the Danes and Normans, which had spread barbarism in other parts of Europe, tended rather to improve them.’


Neither of these representations are just; that is panegyrick, this invective. The monkish illumination of Ireland is not of a kind to be compared with that of countries, whose antient brightness is still reflected in their august remains of the fine arts; yet it is sufficient to prove that Mr. Hume's caricature is like the illusions of perspective, which vanish on the spectator's nearer approach.


Learning, which dawned in the remotest east, has hitherto moved westward, like the great luminary of day; we may still mark its progress from the Indies, through **Chaldea**, **Egypt**, **Phoenicia**, **Greece**, **Sicily**, **Italy**, **Gaul**, and **Britain**. It would be anticipating the ordinary course of human knowledge, to suppose that Ireland has passed her zenith; it should rather encourage her sons, that she has not yet come to her meridian.




---

p.396


We have not *data* to prove that Ireland, when most famed for learning, was a very civilized nation. Her scholars, being shut up in cloisters, and sequestered from the world, were not the fittest instruments to soften manners, and refine the arts of civil life. It is the genius of monastic, and indeed of every other superstition, to narrow, instead of enlarging, the mind, and to leave large spaces of *terra incognita* in the map of human knowledge. But the influence of the political constitution was even worse than that of the ecclesiastical, as may be seen from the slightest sketch of it.


Each province of Ireland had an elective king, under whom were several tributary *kinglings,* and over all ruled the monarch, eligible only from the four provincial kings. At the election of any monarch, king, or chief, it was customary to appoint a chieftain, next in dignity, as his successor, without much respect to primogeniture. Him they called *Thanist,* and the custom *Thanistry.* In the choice of a Thanist, the brother was commonly preferred to the son of the deceased, and even the next cousin was chosen rather than either, if



---

p.397



thought more worthy. The only fixed rule was, that the election should be confined to the same kindred or *sept.* The spirit and intention of which was plainly this, — to preclude from the succession, persons insufficient to lead them to battle; and to prevent the alienation of inheritance to strangers, who might have stepped in, during a minority, or an adult imbecillity, and wrested it from the lineal heir. But however well calculated it might have been to curb despotism, and preserve the martial dignity of family, it was very defective in all the attributes of an equal government and peaceful establishment: it breathed nothing but intrigue and cabal, discord and turbulence, violence and blood. The fact justifies this account, for the history of Ireland presents little else than scenes of civil war, or the sanguinary concussions of domestic faction. The following Laconick epistles display the true spirit of those times:


O'Nial to O'Donnel. —
  

Pay me your tribute, or if you don't —
  

O'Nial.—


O'Donnel to O'Nial.—
  

I owe you no tribute, and if I did —
  

O'Donnel.




---

p.398


The government of **Scotland** was originally formed upon the model of that of Ireland. And however it may have been improved latterly, by ceasing to be elective, we find that Harrington, whose purport was to render monarchy odious, selects that of **Scotland** as a specimen of the worst form of kingly government that ever exited; scarcely one out of three of its kings dying a natural death.


Under such turbulent systems, it is evident that the arts of peace could make but little progress. Some, however, they did make in Ireland, before the ravages of the Danes, and the invasion of the English; but none, that I can hear of, in **Scotland**, at the same period. Nay, if the Irish were disposed to recriminate, they might challenge Mr. Hume to produce a writer of modern **Scotland**, *i. e. Scotia minor* before the fifteenth century, equal to the writers of Ireland in the sixth and seventh.


I am aware that some of my hospitable friends in Ireland may not be satisfied with this mode of defence. They are not pleased with **Spencer** for asking the question, and they may be still less so with me for my



---

p.399



answer. I shall, however, say with him, *I stand not in fear of any undeserved dislikes.* But it should plead some indulgence, for him at least, that if he exposes evil customs, it is but in order to reform them; and that he spares neither the men nor manners of his own country, ‘which, he admits, was what Ireland is now, rude and barbarous, every corner having a Robin-Hood in it, for it is even the other day since **England** grew civil.’


But are we certain that **Spencer** would ask the same question still, if he were to revisit the earth? For certain it is that the face of things is much altered since his time; order and government have succeeded anarchy and confusion; schools have been opened; a university has been founded; and many natives of Ireland have adorned the republic of letters.


On the other hand, it must be considered that there have been two civil wars since **Spencer**'s time; — that if schools have been opened, these are but few in number, and so expensive as to be above the common pitch;— that if a university has been endowed, it admits but of a small number of students, compared to the whole



---

p.400



kingdom; —that of the two millions and a half of souls in Ireland, four to one at least are Papists, who, precluded from all constitutional advantages, have no temptation to literature, even if they had access to it; — and that, according to the booksellers of Dublin, 500 copies of any work, except of a novel or political pamphlet, overstocks the market.


From all which it is not necessary to decide, whether **Spencer**'s question might still be asked. It will be more agreeable to my inclination to combine these with other circumstances, in order to vindicate the genius of the nation; and to shew, from the fact, that since his time she has produced literate men, not disproportioned to her numbers and advantages, taken together.


In this whole kingdom, there are but 2293 parishes. In the diocese of Lincoln, there are near 1400, beside perpetual curacies; but there are said to be more clergy in that single diocese than in all Ireland, owing to the union of livings here. In one county where there are seventy-six parishes, it is asserted, there are but fourteen churches.




---

p.401


The disproportion between the numbers in the other two learned professions, I should conceive, must be greater still, in consequence of the general poverty and desolation of this country.


In the universities of Oxford and Cambridge, there are, besides halls, forty colleges, some of which have a number of students, equal to the college of Dublin. In our universities, there are between eight and nine hundred fellows and professors, whereas the sum total of those in T. C. D. is, as we have seen, but twenty-two; fourteen of which have full employment in the instruction of pupils; the whole care of undergraduates devolving upon the junior fellows.


In **Scotland** there are four universities, each of which have as many professors, as that of Dublin. But it is not so much their numbers, as their different ceconomy, which has produced effects so widely different. Their foundations, originally narrow, they have widened by industry, and what was wanting in royal favour, they have supplied by care and attention; the
very subsistence of their professors depending



---

p.402



upon a display of superior excellence in their several lines. Edinburgh has been, for some years, the first seminary in the British dominions, for all the branches of physick. Glasgow has been the first school of ethicks, from the ingenious **Hutcheson**, to the sagacious **Reid**. Scarce a year passes that the world is not either amused or instructed by some literary production of **Scotland**. And if these do not all bear equally the stamp of genius, few of them are without erudition, and none devoid of marks of industry and application.


I am not ignorant that the eminence of Scotch professors may be attributed to another cause, than the constitution of their universities, seeing that their eminence is novel, though their relation to those learned bodies has been always the same. It will be argued, that writing of books is now become a trade, and that a poor nation will use its diligence to supply a wealthy one, become too indolent to stock its own market.


Upon this principle it may be asked, Why does not the same cause operate in Ireland? And it must be answered, that



---

p.403



though the nation is comparatively poor, the literate part of it is rich. After admission, the fellows rise gradually to all offices and emoluments, merely by seniority: and it is scarcely to be expected, that men, who have a certainty of ample preferment, without any toilsome effort, should forego that cheerful society, which a great city so amply furnishes, for the precarious prospect of future fame, and the certain return of present censure,


> 
> — Quod non desit habentem
>   
> 
> Quae poterunt unquam fatis expurgare cicutae,
>   
> 
> Ni melius dormire putem quam scribere?
> 
> 




The primary intention, however, of an university, is not so much to write herself, as to form writers. And for this purpose, the plan of education here, for the first four years, is well calculated; the examination of undergraduates being an admirable institution. But then instruction goes no farther than the rudiments. One teaches logick in the hall this year, Greek the next, astronomy the third, and morality perhaps the fourth. All which must, in the ordinary course of things, be but superficially



---

p.404



known, and imperfectly taught. Such a constitution seems not only unfriendly, but hostile to excellence; and I cannot help thinking, if the Scotch universities were similar in this respect, that their professors would not, at this day, vie with her better endowed neighbours.


I have granted that the university of Dublin is well calculated for conveying general instruction, and I will add, perhaps better than any other; but I am persuaded that she is by no means framed for supporting, augmenting, or extending the character of national literature. I do not speak thus, because the fact argues for me, but I say so, because the reason of the thing evinces, that, without a miracle, the fact cannot be otherwise. And sure no Irish gentleman can take it amiss that I should labour to wipe off a national reproach, at the expence of statutes drawn up by **Archbishop Laud**.


But here the national prejudice recoils upon us, that a fellow of T. C. D. must, from the necessary qualifications for admission, be a man of profound erudition, and fully adequate to support the dignity



---

p.405



of literature. I shall most readily grant, that the young men who get fellowships, may be as diligent as industry itself, and that they have read a very general course yet how is it possible, that in a year or two after taking a batchelor's degree (that is at five or fix years standing), they can make themselves masters of the whole circle of arts, sciences, and classicks, viz. Logick, Mathematicks, Astronomy, Physicks, Ethicks, Chronology, History, Hebrew, Greek, and Latin. The attention thus distracted by all, if collected on one, would render a boy just come from school, but competently skilled even in that. The memory may be loaded with words, when the understanding is not stored with ideas.


The business of answering for a fellowship, is said to be so mechanical, that some tutors, who have a particular interest at heart, are at the pains to set down the rolls of questions asked by each particular examiner, and that then they prepare their pupils accordingly. A youth of five years standing, thus assisted, may answer better than one of learning and abilities much superior, without that advantage. **Newton** would appear in a more unfavourable light



---

p.406



here, than he did when examined at Cambridge.


To avoid this evil, from the courses of each examiner becoming known, they sometimes interchange courses, and the *Fellow* who examined Mathematicks last year, will examine Morality the next. And from this veering of the courses, it is as difficult to conceive, how they can examine with ability, as that they should be answered with judgment. The whole is an unnatural talk imposed on the examiner, and a mere effort of memory in the examined.


But let us recapitulate what we have said. We have shewn that there are more clergy in one diocese of **England**, than in Ireland; which are not supposed to be 1200, while the numbers in all **England** are 12,000 at least, — that the disproportion is still greater in the law and physick lines, — that the number of fellows in T. C. D. are but twenty-two, — that the number of fellows and professors in our two universities are between eight and nine hundred, — and that the general numbers in **England** are three for one in Ireland. From all which it follows, that the advantages of



---

p.407


**England** over Ireland, in the attainment of learned excellence, is *caeteris* paribus merely, in point of numbers, in a ratio made up of these several proportions.


There is one disadvantage still behind, under which Ireland labours, which outweighs all the rest, and that is her provincial government, which as effectually represses her literary as commercial efforts. *Habet subjectos tanquam suos, viles ut alienos,* is not peculiar to any people, or to any time; it is a spirit resulting from certain relations. Here, however, it removes all that might rouse ardor, or excite emulation. If any rise above the common level, it is through mere dint of genius, without the temptation of reward, or the allurement of approbation. **Swift** was outrageous, that the Irish, — whose loyalty he taxes as a foible, — should be generally set aside, or that their pittance should be,


> 1. The leavings of a church distrest,
>   
> A hungry vicarage at best;
>   
> Or some remote inferior post,
>   
> Worth forty pounds a year at most.
> 




Preferment of all sorts runs here in a channel very different from that of merit;



---

p.408



which indeed is becoming pretty much the case in **England**. But in a country such as ours is, and Rome was, abilities will necessarily emerge, and signalize themselves, till the very instant that blind corruption shall become the Sampson of the constitution.


Many favourable circumstances must concur, before any individual can conspicuously emerge. A genius seldom stands alone. He may be a liar of the first magnitude, but still he is one of a constellation. The collision of different sentiments strikes out the rival sparks of wit. Hence we may remark particular aeras of illumination, from before the Augustan, down to the present age.


It fares with nations as with individuals. There must be some happy tide of events to swell one nation above the level of its neighbours, either in arts or arms, especially in the former. In a great nation, the genius of individuals will participate of the national greatness — it will in some measure be buoyed above itself. Whereas in a subordinate one, it will be depressed to the low level of the national fate. If **Edmund Burke**


---

p.409



had exerted his talents to the utmost in his native country, he would never have been compared to the orators of antiquity. And if **Dr. Johnson** had spent his life in the same place, we should not now look up to him, as the *Colossus* of literature.


Adieu.

  
**Dublin**


After reviewing the many, and almost unsurmountable obstacles to literary eminence in Ireland, it is rather to be wondered, that she has produced so many, than so few writers of distinction. **Usher** was a scholar, second to none these islands can boast of, unless we except **Selden**. In mere science, the Biographia Britannica furnishes not a fourth comparable to **Lord Bacon**, **Newton**, and **Boyle**[49](javascript:footNote('E770001-002/note049.html')).


**Berkeley, bishop of Cloyne**, was a writer of very superior talents. He has been called the Irish **Plato**. His Minute Philosopher is among the standards of the English language. His essay on vision has extended the boundaries of science; and however



---

p.410



whimsical his Treatise on the Principles of Human Knowledge may appear, it is unanswerable, except on the principles of common sense. I cannot help admiring his Siris however it may have been ridiculed for *beginning* with the properties of Tar, and *ending* with those of the Godhead.


The advocates for **Newton**'s principles, affect to decry his scientifick abilities, because he would persuade infidels in religion not to swallow the doctrine of fluxions, as an article of *faith*. So high a respect have I for the genius of **Sir Isaac Newton**, that it approaches towards veneration. My submission, however, to his authority, is not so resigned as that of the Pythagoreans to their master, whose *ipse dixit* was not to be controverted. The passion people have *to account for every thing*, disposes them to a ready acquiescence in some general principle, which for every *why* shall give a *wherefore*. The hypotheses of Thales, Anaxagoras, Heraclitus, Democritus, &c. have prevailed in their turns. Aristotle pulled down the fanciful fabricks raised by his predecessors. **Lord Verulam** rose against this tyrant of the schools. At length all were swallowed up in the *vortices*


---

p.411



of **Des Cartes**. Now the system of that great man is exploded as a *philosophical* romance. And may not the day come, when the *principles* of a still greater shall be called a *mathematical* romance? I cannot help thinking it far beyond the pitch of human understanding to reach the cause, second to the first, which moves the planets in their orbs; and therefore will venture to ask, — Why should it be assumed, that in quantities infinitely small, an arch, its chord, and tangent, shall be considered as equals?


The relation of lines to each other is unalterable, however the dimension of those lines may be altered; no matter whether the arch be said to be nascent or evanescent, still it bears the same proportion to its chord as if extended to a great circle of the heavens. Quantity is still quantity, call it infinitesimal, or what you will, and must consequently be subject to its laws, relations, and proportions. But an arch can never be related to its chord, in the proportion of equality, for that would impugn the principle, that a right line is the shortest that can be drawn between any



---

p.412



 
two points. Yet upon this foundation is the whole system of the mathematical philosophy built, as may be seen from **Sir Isaac Newton**'s own words; *Iisdem positis dico quod ultima ratio arcus, chordae & tangentis ad invicem est ratio aequalitatis.’’*

Newton, Philosophiae Naturalis Principia Mathematica, De Motu Corporum Liber Primus, sect. 1, Lemma VII.


I have placed this matter in a light somewhat different from the *Analyst;* and for my pains, you among the rest will call me *Sciolist.* But I am contented, since they have called him a Pseudo-mathematician. Let him, however, be right or wrong in his speculative opinions, he was certainly an ingenious man, and according to **Pope**, a good one too.


> 1. Even in a Bishop he can spy desert;
>   
> Seeker is decent, Rundel has a heart;
>   
> Manners with candour are to Benson given.
>   
> To ***Berkeley*** every virtue under Heaven.
> 




**King, Archbishop of **Dublin****, was a less fanciful, but a more consistent philosopher than **Berkeley**. His book upon the *origin of evil* is a masterpiece. He was a man of wit, and of a sarcastic vein. Between him and **Swift**, strict intimacy always subsisted, and in their familiar letters we find him



---

p.413



frequently pressing **Swift** to turn his pen to grave subjects, and reminding him that his talents were not suited to such important trifles, as sometimes engaged them.


It is related of him, that when **Boulter** was raised over his head, to the primacy of all Ireland, under the pretext that *he* was too old, he was so piqued, that he neglected to pay the usual complimentary visit. But, as he was so respectable a personage, the Primate, dispensing with *etiquette,* went to see him. **King** received him with great courtesy, except in not getting up to meet his grace, humorously excusing himself by saying, that he was *grown too old to rise.* He was the son of a poor miller in the county of **Tyrone**.


**Dr. Dodwell**, the famous Camden professor of history in the university of Oxford, was of this country, and bred in T. C. D. He was a man of universal erudition, but of an enthusiastick turn of mind. It was his opinion that the soul of man was naturally mortal, but that it received its principle of immortality at baptism. The dogma now maintained by **Dr. Priestley**, is not unlike this on the philosophical side,



---

p.414



however different it may be on the theological.


**Leslie** of Glaslough was a man of great reading, prodigious memory, and voluminous composition. His Short and easy method with the Deists is esteemed one of the best pieces extant on the subject. An odd story is recorded of a disputation held by this gentleman, with a titular bishop of Clogher, in the reign of James II. who had given a challenge to all the protestant clergy. The issue of which was, that both sides claimed the victory; for a Mr. Stewart, who had been a Papist, turned Protestant, and one who had been a Protestant turned Papist.


**Toland** was a writer of opposite principles. A popish priest originally, he became a Deist in religion, and a Republican in politicks. His scholarship has been arraigned by his antagonists, but he is commended by **Mr. Locke** as a man of parts and learning.


**Clayton, bishop of **Clogher****, wrote an Essay on spirit; an analysis of the works of **Lord Bolingbroke**, and other books. He was a disciple of Dr. Clarke, to whom



---

p.415



they say, he owed his preferment. His essay was answered by **Dr. M'Donnel** , once fellow of the college of Dublin, and a celebrated preacher.


Irish writers upon controversy have been numerous, but they are chiefly to be found in the popish church, and in popish countries. **Peter Walsh** is a name well known. **Burnet** says, ‘He was a learned and an able man, much practised in the intrigues and methods of the Jesuits, yet honest, and in points of controversy almost a Protestant.’ This, however, is an uncouth track, nor is the prospect much brightened in exploring the regions of antiquity. Yet Ireland has her Camden in **Ware**, and the Ogygia of **Flaherty** seems learned. He would synchronize the kings and transactions of Ireland, with those of the other parts of the world, down from the deluge. The consequence is, that great part of his book is almost as applicable to any other country as to Ireland.


There are other writers of some note in the same line, viz. **Lynch**, author of Cambrensis Eversus. M'Mahon of the Jus Armacanum[50](javascript:footNote('E770001-002/note050.html')), **Peter Lombard**, **Mr. Harris**, **Dr. Raymond**, 



---

p.416


**Mr. Simon**, **Luke Wadding**, **Cusack**, **White**, **Stanihurst**, and the **Abbe Geoghegan**, who wrote the history of Ireland in French. The fabulous **Keating** is well known to every body. It was reserved for **Dr. Leland** to give the form of history to the transactions of Ireland, since it became dependant on the crown of **England**.


I mentioned to you in a former letter, **Mr. Molyneux**, the friend of **Mr. Locke**, and champion for the independence of his native country. I now speak of him as a philosopher and mathematician, for he was reckoned among the first of that scientifick age. His Dioptricks are highly commended by **Dr. Halley**. As his character seems to me well drawn upon his monument in St. Audeon's church, I shall give you an extract from it.

> 1. Familiae eruditae famam
>   
> Per universam Rempublicam litterariam
>   
> Latius sparsit.
>   
> Abditis Matheseos penetratis
>   
> Geometriam, Astronomiam, Dioptricam, Algebramque
>   
> Multis auxit inventis.
>   
> Philosophiae verae ac utilis incrementa
>   
> Studiis & impensis strenue promovit.
> 
> 
> ---
> 
> p.417
> 
> 
> Patriae jura quae putavit, noto tibi, viator, libello 
>   
> 
> Propugnavit.
>   
> Nec moribus minus quam scientia insignis
>   
> Tam supra plebem vixit quam sapuit.
> 




**Dr. Helsham** published an elegant and learned Course of lectures, upon the several branches of physics and mechanics. **Dr. Brian Robinson** wrote *an essay* upon that ethereal fluid, to which **Newton** alludes in his queries: and also a treatise on the animal oeconomy, in which he appears happily to have applied his great mathematical knowledge to the extension of medical science. You know every thing relative to **Sir Hans Sloane**, more remarkable for his museum than his genius. Yet upon these principally must we rest the national character in the line of natural philosophy. Nor can I hear of any other mathematician of this country, except **Mr. Ronayne**, author of a Treatise of Algebra, and the present **Dean of **Armagh****; who from a consideration of the *Cone*, has immediately deduced the properties of the *Sections*. His demonstrations are perspicuous and well arranged. He has also published those ingenious philosophical essays, which I have heard you speak so well of.




---

p.418


In this class, however, we may arrange the works of **Dr. Macbride**, who has so successfully applied the theory of *fixed air* to practice, in the cure of the sea-scurvy.


**Dr. Sullivan**'s treatise on the feudal law, and constitution of **England**, is making its way in the good opinion of the world notwithstanding this avenue to same had been pre-occupied by **Dr. Blackstone**'s Commentaries.


**Mr. Hutcheson** is the principal ethick writer of this country. Whilst a teacher of an academy in Dublin, he wrote his books on the *origin of our ideas of beauty, and on the passions.* These raised his reputation so high, that he was invited to accept the *moral chair* in the university of Glasgow which he filled with such celebrity, as to lay the foundation for that fame which Glasgow now enjoys as an Ethick school. He it was who first used the term *moral sense,* for that principle which approves the To Kalon of **Plato**, and the pulchrum et honestum of **Cicero**.


Two of the ablest divines of this country were dissenters from the established church,



---

p.419


**Mr. Abernethy** and **Dr. Leland**. The sermons of the former upon the *attributes,* are held to be one of the best systems of natural theology. They are taught and recommended in several Universities, and translated into French. The Author was founder of a sect called, **The New Light** whose distinguishing tenets are *Arianism* in doctrine, and *independence* in discipline. **Mr. Abernethy** was endowed with great powers of speech. His admirers say, that he united the precision of **Clarke**, the abundance of **Barrow**, and the perspicuity of **Tillotson**. He was deputed by the Dissenters of Ulster to address the Duke of Ormond, in a tour he made when Lord Lieutenant; and his grace was afterwards heard to say, that, of all the men who ever approached him on like occasions, he was most pleased with ‘the young man of Antrim.’


**Dr. Leland**'s View of Deistical Writers and other works, are well known. Of principles different from **Mr. Abernethy**, he was an *independent* in discipline, but an *Athanasian* in doctrine. He is sometimes confounded with the Author of the History



---

p.420



of Ireland, whose Lectures upon Oratory, in T. C. D. — wherein he overthrows some opinions of Dr. Warburton, —and his defence of them against Dr. Hurd, have obtained him a very high rank among the writers of Ireland.


**Dr. Duchal** wrote Presumptive arguments in favour of Revelation, and several Volumes of sermons, which have been well received. And **Mr. Boyce**, another dissenting Minister, published sermons *on the Four last Things*, which I have heard commended. He was father to **Boyce** the Poet, author of a Pantheon, and other works.


You cannot expect a large catalogue of eminent preachers in the established church of Ireland, for the reasons I have already given; yet I must say, that the **Dublin** pulpits, are just as well filled as those of **London**. The Writers who have done the nation most honour in the divinity line are, **Synge**, **Story**, **Brown**, **Delany**, **Lawson**, **Orr**, and **Skelton**.


**Bishop Synge** is said to have been a man of great parts and learning, he was author of the Religion of a Gentleman. 



---

p.421


**Story, Bishop of **Kilmore****, published only some occasional sermons, but in his Treatise on the Priesthood; deep erudition and Christian moderation are equally conspicuous.


**Brown, Bishop of **Cork****, published some volumes of sermons; he is however more celebrated for his delivery than his composition. It is related of him, that when he preached before Queen Anne upon the text, *no man ever spoke like this man,* the Queen applied those words to the Preacher. They have another anecdote of him: Being a violent *tory,* he wrote a book to prove, that drinking memories was a species of idolatry, in order to abolish a custom then prevalent among the *whigs* of Ireland, of drinking the *glorious* memory of King William. But instead of cooling, he only inflamed their rage for the toast, to which they afterwards tacked, *‘and a f--t for the Bishop of Cork.’*


**Delany**'s Sermons on the Social Duties are excellent. He was not however free from enthusiasm: He wrote a book to prove, that eating of blood was a crime equal to a breach of the decalogue. Lord Bolingbroke remarks, that he always argues as if



---

p.422



he were preaching before an *Irish* congregation. Yet I have heard one of the best judges on our side the water say, that his Introduction to Revelation examined with candour, was one of the finest pieces of declamation in the English language.


**Dr. Lawson** was a most celebrated preacher. His sermons, which, by the bye, were published contrary to his directions on his death-bed, are elegant compositions. His lectures upon Oratory, which he delivered in Trinity College Dublin, he gave to the world himself; they shew a nice classical taste, a fine poetical vein, and a thorough knowledge of the art of preaching.


**Mr. Orr** published a *volume of sermons,* which procured him the friendship of **Hoadly, bishop of **Winchester****; they discover a free and original cast of thought, and are composed in a manly, nervous style. The present bishop of **Clogher**, has the honour of promoting him to an Archdeaconry, when he governed the see of **Ferns**. And to the same excellent prelate **Mr. Skelton** owes his preferment.




---

p.423


This gentleman, though ungraduated, but as Batchelor, by any of the universities, is the living glory of the Irish church. He has published five volumes, mostly in defence of revelation, which, though ably written, shed but a secondary lustre on the character of this excellent person, to whom I have had the happiness of being introduced. His learning is almost universal, and his language uncommonly fluent and vigorous nature formed him a poet, but a bishop prematurely ordained him a divine; and no sooner did he assume this function, than his feeling heart was penetrated by the nicest sense of duty. He resigned himself wholly to the service of his master. Such a servant could not long escape notice; he became eminent; he was followed in **London** as a preacher. He dedicated two volumes of sermons to the citizens of that metropolis, at a time when he languished upon a curacy of forty pounds a year. But then he was as rich as he is now; for he knows no use of money but to relieve distress. In one of those seasons of calamity, which neglect of tillage in this country renders so frequent, he sold his books, his only worldly goods, and the



---

p.424



only worldly goods wherein he took delight, to buy bread for the poor.


He is now advancing towards seventy; yet he preserves an uncommon share of vivacity. If he sometimes descends into the ludicrous, his flashes of wit and humour keep the table. in a roar. His powers of description are beyond what I could have conceived; he has a stock of imagination sufficient to set up ten modern tragic poets. Had he been educated and lived in **England**, a stage little enough for his great abilities, he would have long since obtained the first nitch in the temple of fame; now he is known only in Ireland, and by a few inquisitive men elsewhere.


The chief miscellaneous Irish writers of the present century, that I hear of, are, **Parnell**, the very deliciae musarum, of whose poetry, above all others, it may be said decies repetita placebit — **Burke**, *on the sublime &c.* — **Lord Molesworth** — **Lord Orrery** — **Lord Clare** **Mr.** and **Mrs. Millar** — **Dr. Arbuckle**, writer of Hibernicus's Letters &c. — Molloy, author of a periodical paper in **London**, called Common Sense, &c. 



---

p.425


**Ogle**, who modernized Chaucer's Tales — **Dr. Dunkin**, author of a quarto collection of humorous poems, some of which are in three languages, Greek, Latin, and English —**Wood**, who published Ruins of Palmyra and Balbeck and an Essay on the Genius and Writings of Homer — **Sterne, bishop of **Clogher****, author of a book de visitatione infirmorum — **Sterne**, author of Tristram Shandy, *&c.* — **Webb**, who inquired into the Beauties of paintings &c — **Pilkington**, who published a Dictionary of Painters[51](javascript:footNote('E770001-002/note051.html')) — **Cunningham**, author of several poetical pieces — **Starrat**, who wrote on the Doctrine of projectiles and some of the songs in Allan Ramsay's collection — **Canning**, writer of an Epistle from Lord Russel to Lord Cavendish &c. — **Derrick**, of letters and poems — **Dr. Clancy**, author of the Templum Veneris, &c — **Bush**, of Socrates, 
**Johnston**, author of Chrysal — **Brooke**, of the Farmers Letters, Fool of Quality — the learned **Mr. Maclaine**, now of the Hague. **Dr. Sheridan**, in whose family genius seems as hereditary as the name. To these, I might add, list of female writers, **Mrs. Sheridan**, **Mrs. Pilkington**, **Mrs. Grierson**, **Mrs. Barber**, **Mrs. Davies**,



---

p.426


**Mrs. Griffith**, &c — Nor should we forget the truly comical **G. A. Stevens**. There are several other [52](javascript:footNote('E770001-002/note052.html')) living writers, who are not publici juris as their works are anonymous; such as the author of Longsword Earl of Salisbury, Polite Philosopher, &c.


As **Swift** was a writer, cujus gloriae neque profuit quisquam laudando, nec vituperando obfuit, I should only have mentioned his name, had I not seen a letter of his[53](javascript:footNote('E770001-002/note053.html')), never published, which entirely acquits him of that breach of hospitality, laid to his charge from some passages in his Hamilton's Bawn. The letter was written to that Dr. *Jenny* represented in the poem as looking so like a *ninny*. The purport of it is to acquaint the Doctor (then rector of **Armagh**, in the neighbourhood of which he spent the Summer), how he passed his time. Among other amusements, he mentions that of writing this very poem, the motives which excited him to it, and the effects



---

p.427



it produced. And so far was it from giving umbrage to the lady, or jealousy to the knight, that every addition he made at night came up with the bread and butter, as part of the entertainment next morning, and all parties expressed the utmost satisfaction. One of the misrepresentations of this affair, among others, gave occasion to the following epigram, written by the curate of **Lord Orrery**'s own town of Caledon.

> 1. A sore disease this scribbling itch is!
>   
> His lordship, in his Pliny vein.
>   
> Turns Madam Pilkington in breeches.
>   
> And now attacks our patriot Dean.
> 2. What! Libel his friend when laid in ground:
>   
> Nay, good Sir, you may spare your hints,
>   
> His parallel, at last, is found.
>   
> For what he writes, George Faulkner prints.
> 3. Had Swift provok'd to this behaviour,
>   
> Yet after death resentment cools,
>   
> Sure his last act bespoke his favour;
>   
> He built an hospital for — Fools.
> 




This alludes to St. Patrick's Hospital for lunaticks and idiots, for the founding of



---

p.428



which **Swift** bequeathed his fortune — or to use his own words:


> 1. He left the little wealth he had.
>   
> To build a house for fools and mad,
>   
> And shew'd, by one satiric touch.
>   
> No nation wanted it so much.
> 




  
**Dublin**


If Ireland should still appear deficient in mere scholarship, a review of those impediments I have pointed out may, perhaps, contribute to vindicate her genius, however it may have been aspersed of late: and it must be confessed, that some of our countrymen are too apt to sling national reproaches.


**Swift**, shrunk from a court-favourite into the head of a chapter, became easily irritated against the ruling men and manners here, and led the way in abusing the place. **Pope**, seeing the Dean's humour, took up, in his Dunciad, what



---

p.429



fell from him, and complimented the man at the expence of his country:
  

From thy Boeotia now her power retires.


He has been followed by all the witlings since. **Smart**, whose greatest praise, you know, arose from a prize or two he obtained at Cambridge, for his verses on the attributes, paid a visit to Ireland, against which, from a domestic cause, he conceived such a resentment, that his vengeance dictated a poem called, The Temple of Dulness, wherein he graphically lays down the College of Dublin.


Yet it has been remarked to me, that in another poem, where he is painting the terrors of the British fleet, and its Captains as Demi-Gods, he unfortunately selects Warren, a native of the county of Meath, as the glory of the English Admirals. The gentleman who mentioned this to me, pointing at a countryman of ours[54](javascript:footNote('E770001-002/note054.html')) who is here at present, could not help using these words, though he has a very high respect for our nation. ‘No



---

p.430



sooner (says he) do some Englishmen set foot on Irish ground, than they assume a self-created importance, very unsuitable to their real consequence at home. Fraught with *plebeian* prejudices, they look at every thing through a false medium, make faults where they do not find them, and then applaud their own sagacity. Not without reason biaised towards their own country, some think themselves as much superior to any individual Irishman, as **England** is superior to Ireland. A man of this cast *puts the whole nation into his own person, and so gives the matter out.*’


But let us turn into the field of imagination, which is certainly the walk of Irish genius. Poetry, as we have seen, had an early establishment here. But the same causes, which have been inauspicious to learning in general, have prevented the songs of the Bards from being collected. It were to be wished that these, as well as the antient Irish manuscripts in T. C. D. and elsewhere, were printed and translated, while there yet remains a *scholar* to undertake and superintend the work. For in



---

p.431



another century the Irish language, like that of Cornwall, will probably be extinct. **Leibnitz**[55](javascript:footNote('E770001-002/note055.html')) was of opinion, that the knowledge of it was a necessary introduction to Celtic literature.


This country is certainly indebted to **Mr Macpherson** for his animated exhibition of the spirit of Ossian, one of the oldest bards of Ireland, in his Fingal and Temora; and for that honourable testimony he has given in favour of their genius, however he may depreciate the *Fiona*, or poems which treat of the exploits of *Finn*, the son of Comhal. ‘On other subjects,’ says he, ‘the Bards of Ireland have displayed a genius worthy of any age or nation. It was *alone in matters of antiquity that they were monstrous in their fables.* Their love sonnets, and their elegies, on the death of persons worthy and renowned, abound with such a beautiful simplicity of sentiment, and wild harmony of numbers, that they make an atonement



---

p.432



for their errors in every other species of poetry.’


**Spencer**, after describing the abuses to which their poetry was turned by their bards, in dignifying vice, instead of adorning virtue, puts this question in his dialogue: ‘Have they any art in their compositions? or be they any thing witty or well favoured, as poems ought to be? And he answers. Yea, truly. I have caused divers of them to be translated unto me, that I might understand them: and surely they savoured of sweet wit and good invention, but skilled not of the goodly ornaments of poetry; yet, were they sprinkled with some pretty flowers of their natural device, which gave good grace and comeliness to them.’


**Mr Macpherson** was, however, much better qualified to decide on this subject, as he not only understood the originals, but as he had seen the poems of Ireland written in its best times. Those which **Spencer** describes were, I suppose, like one I have seen, written in latter times by **O'Gnive** the poet of O'Nial a specimen



---

p.433



of which may not prove unworthy your perusal.


‘Oh! wretched condition of our dear countrymen! Thin remains of a once happy people; wallowing in blood, and drenched in slaughter! vain struggle for liberty! Ye are the hapless crew of a vessel, long tempest-tost, and finally cast away. What! are we not wrecked on our own shore? Are we not the prisoners of the Saxon [56](javascript:footNote('E770001-002/note056.html')) race? Is not our sentence passed? Is not our very excision fore-doomed? How are we fallen from the antient glories of our native land! Our power is degraded into weakness, our beauty into deformity, our freedom into slavery, our songs of triumph into doleful elegies. Our forefathers would not know — or, if they knew, they would disclaim their sons. Turn not thy eyes, immortal *Gallum,* on thy recreant sons! — *Nial of the nine hostages,* look not down upon us, lest thou blush for thy captive Gadhelians!— *Conn of the hundred battles,*


---

p.434



sleep in thy grass-grown tomb, and upbraid not our defeats with thy victories! Propitious night, shroud us in thy dunnest cloud! — let not the sun shed his reproachful light on our ignominy! Whence this fatal transformation? From your tame submission to *strangers,* — from your mean subservience to the *Saxon* laws. Since you departed from the equity of the *Brehons,* clouds of evil have burst upon you, — deluges of misery have overwhelmed you. The purposes of Heaven are changed, — your sporting lawns are paled in, —your sun gilt hills are disfigured with ramparts, and frightful with towers. — The laws of nature are violated, — that land, once the theatre of virtue and honour, is metamorphosed into another *Saxony.* Slaves! we no longer know our own country, and our country disowns us,— we are both equally distorted, — we see but two monsters, a *Saxon* denizen, and an *Irish* alien. Hapless land! Ye besieged of Troy, without a Hector to defend you! Ye Israelites of **Egypt**, without a Moses to conduct you! — But thy decrees, O Lord! are just. Unless the children of *Eber-Scot* the Scythian, repose all their trust in thee, New-Saxony



---

p.435



must, like a Phoenix, rise out of the ashes of Old Ireland.’


This poem must have been the production of the fifteenth, or beginning of the sixteenth century: and it shews that the many laws made to suppress the Bards had not damped their spirit, however they might have weakened their influence. After the forfeiture of O'Nial, under James I. poetry took another turn; for, even so far back as his reign, we find this country furnishing pieces for the stage. And it must be owned that she has, at every period since, discovered a strong propensity, if not capacity, for the drama. She has not only embellished it with several favourite stock plays, but she has brought forth some of the first-rate actors, **Wilks**, **Quin**, **Sheridan**, **Barry**, **Mossop**, **Macklin**, **Havard**, **O'Brien**, **Brown**, **Woffington**, **Clive**, **Fitzhenry**, &c. and she now produces a catalogue of scenick writers, some of whom ‘sunt clari hodie & qui olim nominabuntur’; but as it depends upon futurity to allot them their respective nitches in the temple of Fame, I shall only give an alphabetical list of such as occur to me: **Brooke**,



---

p.436


**Bickerstaff**, **Dobbs**, **Griffith**, **Howard**, **Jephson**, **Kelly**, **Murphy**, **Macklin**, **O'Hara**, **the Sheridans**, **West**, &c.


Of her late Writers in this line are some, whose names are not yet forgotten, and others, whose works shall last as long as the English stage shall hold the mirrour up to nature: Earl of Orrery; N. Tate; Concannen; John Kelly, author of the Married Philosopher, &c.; Dr. Madden, of Themistocles, &c. , Jones, of The Earl of Essex, &c.; Morgan, of Philoclea; Hartson, of The Countess of Salisbury, &c.; A. Phillips; Mrs. Centlivre; Sir R. Steel; **Farquhar**; and **Southerne**.


*Nor must we, Denham, e'er forget thy strain,
  

Whilst Cooper's hill commands the neighb'ring plain.’’*


When the Sophy came out, it was said by **Waller**, of the Author, ‘That he broke out like the Irish rebellion, three-score thousand strong, when nobody in the least expected it.’ **Southerne** may, perhaps, be placed immediately after **Shakespeare** and Otway. A late French writer gives him a very distinguished place among the



---

p.437



English tragic Poets. He selects Oroonoko[57](javascript:footNote('E770001-002/note057.html')) as the most striking example of that truth, in painting pathetic scenes of deep distress, in which, he owns, it is difficult to dispute precedence with the English. The same author says, the Conscious Lovers[58](javascript:footNote('E770001-002/note058.html')) is the best comedy in our language. It may be questioned whether we have any plays, except of Shakespeare, more abounding with true humour than those of **Farquhar**. I know that his humour has been called *low*, but time seems adding to his reputation what it is detracting from that of **Congreve**.


It would perhaps be injurious to the memory of **Dr. Goldsmith**, to draw his poetical character from his theatrical pieces, though they are replete with the true vis comica. His fame must be founded upon his Traveller, Deserted Village, and Vicar of Wakefield. But his shade may rest in peace; his tomb is to be inscribed by the[59](javascript:footNote('E770001-002/note059.html')) Author of the Rambler, 




---

p.438



which is more honourable to the Bard than if his ashes had been deposited in the cemetery of Kings.

> 
> Olivarii Goldsmith,
>   
> 
> Poetae, Physici, Historici,
>   
> 
> qui nullum fere scribendi genus
>   
> 
> non tetigit,
>   
>  
> nullum quod tetigit non ornavit;
>   
> 
> Sive risus essent movendi,
>   
> 
> sive lacrimae;
>   
> 
> Affectuum potens, at lenis, dominator;
>   
> 
> Ingenio sublimis, vividus, versatilis,
>   
> 
> Oratione grandis, nitidus, venustus;
>   
> 
> Hoc monumento memoriam coluit
>   
> 
> Sodalium amor,
>   
> 
> Amicorum fides,
>   
> 
> Lectorum veneratio.
>   
> 
>  *** in Hibernia natus,
>   
> 
> Eblanae litteris institutus,
>   
>  
> Londini obiit MDCCLXXIV.
> 
> 
> 






---

p.439


  
**Dublin**


The imitative arts are, at best, plants of a slow growth; they require not only a genial soil, but the careful cultivation of opulence and peace. The causes, which I have shewn to be inimical to letters, are hostile to them. Poetry and Music may arrive at a certain degree of perfection amidst tumult and commotion, but Painting requires security and fixed establishment. The implements of poetry are few, and always at hand, and the exercise of them is not altogether incompatible with any state of a mind disposed that way. Public calamity, and private misery, whilst they furnish the fitted poetical subjects, kindle, at the same time, indignation, revenge, anguish, despair, and other passions, which sometimes prove the strongest incentives to the poetic furor.


It is far otherwise with the arts of design. Those pictures which exist in the mind of a man of genius, and which may



---

p.440



be soon sketched and coloured in words, require a very laborious, extensive, and uninterrupted practice of imitation, before they can be embodied on the canvass. It should not therefore be wondered at, that those efforts of ingenuity which we, perhaps, too highly prize in other countries, have but lately discovered themselves in Ireland. Yet I have seen some very good portraits here. Those of **Latham** are admirable, far superior to those of **Mr. Jervaise**; who was of this country, and whose celebrity he principally owes to the partiality of **Mr. Pope**. There is a good picture by **Bindon** in the Poor-house. The present **Hunter** has done some capital portraits, and **Mr. and Mrs. Trotter** have both great merit in that way.


But Landskip is the line in which all the painters of Ireland set out, and in which some of them have arrived at the greatest eminence. You know the works of **Barret**. There is a **Roberts** at present, a very young man, whose works are fine. **Mr. Fisher** too, **Ashford**, **Coy**, and others, deserve great praise. I have seen a picture by **Butts**; whose fame here is above that of all others, though his death was premature. If I were to assign a reason for this general excellence of Irish



---

p.441



artists in Landskip, I should ascribe it to the beautiful face of the country, which abounds with scenery the most *picturesque.*


The highest branches of painting can never flourish, except where the patronage of the opulent concurs with other favourable circumstances. This country is too indigent for sufficient encouragement. Till within a very few years, **England** herself could not boast of many eminent artists. Her progress, however, within the last twenty years has been rapid, beyond the example of other places, and former times. She has already evinced the futility of their speculations, who attribute to *climate* an omnifick influence upon the fine arts. What would the Abbé du Bos now say, if he heard his own countrymen admit, that **London** has at this day more capital painters than **Paris**. Though the latter had no less than 6100 artists and students in design, A. D. 1771.




|  |  |
| --- | --- |
| L'Academie Royale, Eleves | 200 |
| L' Academie de S. Luc | 150 |
| Ecole aux Gobelins | 50 |
| Ecole gratuite sous l'inspection du Lieutenant de Police | 1500 |
| Ecole gratuite des freres dans les paroisses | 1200 |
| Il y a outre cela 600 artistes donnant leçon pour
de l' argent, conter a chacun 4 eleves | 3000 |
| [nbsp ] | 6100 |








---

p.442


Public establishments for cultivating the polite arts in the different nations of Europe, are not very antient: the oldest of the kind being that by the **Duke of **Milan****, under the guidance of **Leonardo da' Vinci**; which was dissolved, on the duke's being made prisoner, long before the academy of **Florence** was founded in the year 1562. St. Luke's at **Rome** was established by Gregory XIII. and, nearly at the same time, the celebrated school of the Carraches was opened at **Bologna**. The royal academy of **Paris** was founded in 1648. Junius, in his book de pictura veterum, published ten years before this period, occasionally mentions an academy at *Arundel-house* in London, in which were exposed to public view, a capital collection of drawings, &c. belonging to the noblemen of that title. The royal academy in **London** was not founded until 1768. So that the earliest public establishment in **England** is that of the Society for the encouragement of arts, manufactures, and commerce, instituted in 1753; which was posterior by some years, to a similar institution in Ireland, under the name of the **Dublin Society**.




---

p.443


This truly patriotic body, with a view of advancing the polite arts, erected an academy, furnished with living models, and calls from the antique statues, under the direction of **Mr. West**, who was not only the best draftsman of his time in this country, but perhaps in Europe. In this school a considerable number of painters have been bred, some of whom have obtained a considerable degree of reputation both in Rome and London. But, whether it was that **Mr. West**, though superlatively qualified as far as he went, being neither a painter nor a sculptor, but a mere draftsman, and consequently limited in his views, *drawing* and the *clear-obscure* were cultivated as an end, and not as the means to something still greater, and far beyond such narrow boundaries — Or, whether it was that the **Dublin Society** wanted either the knowledge, or ability, to strike out ways of employing those they had formed, and thereby of advancing the arts to that perfection they are capable of — I say, from which ever of these, or from what other cause soever, it has so happened, that most of those bred here have gone over to **England**; where, from want of patrons or friends interested in their success, many of them have been 



---

p.444




unavoidably driven into the inferior walks of art; in which, however, they are outdone by none. **Dixon** has brought mezzotintos to a degree of perfection, unexpected in that species of engraving. And there have been many others eminent in the same line; Brooke, Burke, Chambers, Fisher, Frye, Gwynn, Houston, M'Ardell, Purcell, Spooner, Watson, &c.


The genius of Ireland then has not been dormant of late, and if the **Dublin Society** has been unsuccessful in forming, or rather finishing, the most eminent characters in this art, she has, however, multiplied inferior artists, and refined the taste of those employed in manufactures; both which tend vastly to soften manners, and humanize society.


Notwithstanding such institutions, if properly managed, might, as I conceive, be converted to the most exalted purposes; yet if we examine the effects produced by those of a similar kind, we shall find, that, if that of Dublin has failed, it has failed in common with those on the continent, where a concurrence of more favourable circumstances, than could possibly meet in a dependent country, might



---

p.445



have afforded a better prospect of success. Out of that multitude of artists instructed by the munificence of the grand monarch, not one has yet arisen comparable to **Le Brun**, **Le Soeur**, or **Poussin**. And, as if in mockery of human wisdom, all the great masters of **Italy** were formed, either before, or independent of, the several academies in that country; so that the highest attainments in the arts are not to be expected from a multitude of novices.


This very country furnishes a striking example of this assertion. Mr. Barry never had a master, as I am informed. Nay, he obtained a first premium from the **Dublin Society** for history painting, when a boy, before he had ever seen a picture of the kind. His Inquiry into the obstruction of the arts, &c. first led me to his name. There it was easily seen that his penetration had founded the very bottom of his art. I was surprised that an artist of such learning had not arrested the attention of the Public; and still more so, when, on examining his works, I found them conceived in the grandest style, and executed in the best manner; his drawings of the *nud* being correct to the utmost truth of nature. However



---

p.446



imprudently this rising genius may have invited the attacks of criticism, by his strictures on established characters, he must be allowed a place among the first artists of the present age; and perhaps the next will wonder how this could have been so long blind to his merit.


The history of the arts furnishes abundance of other examples of masters being formed almost magistra natura, in countries where there was *not a deficiency of models* for imitation. When we consider this, together with the natural propensity of all children to drawing, and besides, the almost innumerable difficulties that are to be surmounted before perfection can be attained, and that nothing can carry the artist successfully on, but a peculiar cast of thought, and[60](javascript:footNote('E770001-002/note060.html')) uncommon vigour of mind,



---

p.447



the energy of which nothing can baffle, it is easily seen how preferable it would be to fix the prize at the end, rather than at the beginning of the race. The public patronage would, in **England** at least, be more advantageously, and less expensively employed, in contriving means for calling out the abilities, for great exertion, of those characters which are already formed. Might not the age and nation derive credit from employing the first artists of **England** in painting St. Paul's, and other churches which want decoration? This enlightened age is far enough removed from fanaticism, to charge such ornaments with the weakness of superstition. But lest you should say to me ‘ne sutor ultra crepidam’


I shall bid you good night.




---

p.448


  
**Dublin**


The antiquarians of this country contend, that Ireland is pointed out by **Diodorus Siculus** under the name of BELEPION, i. e. the Erin of the God Beal. He described it as being about the bigness of **Sicily**, and being over-against the **Celtae**, as fruitful and pleasant, abounding with large groves, and round temples, wherein the Priests, or Druids, sung to their harps the praises of **Apollo**. He reports, that the God used to converse with the natives, and that in nineteen years they could bring the moon so near as to discover her mountains and vallies. From whence they would infer it to have been intimated, that the Irish were acquainted with the cycles of both sun and moon, and that they had made some progress in astronomy by the help of glasses. Be this, however, as it may, there is a concurrence of so many circumstances, in this passage, applicable to Ireland, that it amounts to an exact description.



---

p.449



The name ***Erin***, the situation, the size of the island, the Druids with their harps, the harp sacred to **Apollo**, and at this very day the ensign armorial of the kingdom.


But it is not necessary to recur to dubious authorities for proof that the Irish were, in a very early period, addicted to music. The fact is supported by the most unexceptionable evidence; a sketch of which I cannot refrain from giving you, though I must confess that I never so much as learned the gamut. I shall not therefore pretend to write as a musician, but as an antiquarian — and you will allow me to be, like some other antiquarians, very fond of what I do not understand.


We have already seen that the Druids, Bards, Musicians, &c. of Ireland had portions of land assigned them for their maintenance. It may be well supposed that the musicians had this legal ettablishment, not only as they were officers of the court, but as they were ministers in the public worship of the Gods. The high honours and emoluments, attendant on this art, must naturally have produced eminence in



---

p.450



many of its numerous professors. Accordingly, **Cambrensis**, who scarcely allows the Irish any other good quality, confesses their transcendancy in music. He strains his style to such a pitch, in order to express this peculiar excellence, that it is almost impossible to translate him. ‘In musicis solum &c.’ ‘I can only praise their excellence in instrumental music, in which they are skilled incomparably above any other nation I have seen. — Their instruments are the harp, the pipe, and the timbrel.’ **Polydore Virgil** holds the same language, ‘Hiberni sunt musicae peritissimi.’ And the Welch chronicles affirm, that ‘Griffith Ap-Conon, King of **North Wales**, being of Irish lineage by his mother, and also born in Ireland, carried with him from thence divers cunning musicians into **Wales**, who revised in a manner, all the instrumental music used there. Which appears as well by the books written in the same, as also by the names of the tunes and measures used among them to this day.’


The *Cognoscenti*, I think, allow that Ireland is a school of music. Ellen-a-Roon


---

p.451



has always been esteemed as one of the finest melodies of any country; Langolee and Kindu-Deelas are of the same cast. **Pasquali** used to play the first of these with variations; which, they say, only weakened its original force. Though nothing can be more lively than their common jig tunes, their finest airs are of a plaintive turn, and supposed to have been those set to the elegies for renowned warriors, or to the sighs of complaining lovers. Of the latter sort are those I have named, as is evident from the titles[61](javascript:footNote('E770001-002/note061.html')); and in the same line is that charming melody, Molly-a-Store; for which **Mr. Ogle, knight of the Shire** for the county of **Wexford**, has written some beautiful stanzas.


They talk of a wonderful master they had of late, called **Carolan**, who, like Homer, was blind, and like him, went about singing and playing his rhapsodies. His poetry was in Irish, and not much praised, but his music is celebrated. From an early disappointment in love he is said to have attuned his harp to the elegiac



---

p.452



strain. I have heard one of these compositions played, and to me the sounds were as expressive of such a situation of mind, as the words of a love-sick elegy. The history of one of his famous compositions, called [62](javascript:footNote('E770001-002/note062.html')) *Tiarna-Mayo,* — which was somewhat in the dirge style, — is said to be this: The musician had offended Lord Mayo by some witty sarcasms, of which he is reported to have been very liberal, and was forbid his house. After some time he prevailed to be heard, and he sang this *palinode* in concert with his harp at dinner; with which, Orpheus-like, he so charmed the powers of resentment, that he was presently restored to his Lordship's favour. I have heard divers others of his tunes called *Planxties,* which are in the convivial strain, and evidently calculated to inspire good humour, and heighten the jollity of the festive hour. They go by the names of those gentlemen, for whose entertainments they were composed, as Planxty-Connor, Planxty-Johnston, Planxty-Jones, &c. The last of these has been



---

p.453



dignified by better words than those of the Bard, by Mr. Dawson, late Baron of the Exchequer, and is now called *Bumper Squire Jones.*


They tell me, that in his latter days he never composed without the inspiration of whiskey, of which at that critical hour, he always took care to have a bottle beside him.


*Ennius ipse pater, nunquam nisi potus, ad arma
  

Profiluit dicenda —’’*


His ear was so exquisite, and his memory so tenacious, that he has been known to play off, at first hearing, some of the most difficult pieces of Italian music, to the astonishment of Geminiani.


The name of Mr. Poeckridge ought not to be lost to the lovers of harmony, as he has enriched the art by the invention of the *musical glasses* now improved into the *harmonica;* an instrument, if not of the greatest force, yet certainly of the sweetest tones in the compass of melody. He was born to a good estate in the county of **Monaghan**, but more attached to music



---

p.454



than oeconomy, he, like many other men of genius, outlived the possession of it, and was obliged, in his old age, to make out a precarious subsistence by the exercise of his art: he lost his life but a few years since, in an accidental fire in Cornhill.


From what has been now observed relative to the distinguished excellence of the Irish musicians, particularly in ancient times, compared with what has been proved, in former letters, that *Ireland* was the old *Scotia,* it will not, I flatter myself, be difficult to trace the origin of what is now called, and justly enough, the *Scots* music. We have seen that there is proof positive, from their own chronicles, that the Welch received their instrumental music from Ireland, let us now see whether there be not proof presumptive, the strongest which the nature of the thing is capable of, that the British Scots borrowed their music also from the same quarter.


It is in vain to say, as is generally said, that David Rizzio was author of the Scots music. There is an internal evidence against such a supposition; the wild and pastoral singularity of the Scots melodies is



---

p.455



incompatible with the grave and learned compositions of **Italy**. And there is an external evidence still more strong: Rizzio was Secretary, not Musician, to the Queen of **Scotland**. His father had been a musician by profession, but we do not find that he was one himself. That he might, however, have played, improved, and collected the Scots airs, is very probable; but that a young dissipated Italian,— busied in the intrigues of a court, and attendance on a Queen so fair, and so condescending as Mary, — could in a few years have disseminated such multifarious compoistions through a nation, which despised his manners, and hated his person, is utterly incredible.


Nor can this invention be ascribed to the Abbey of Melross. For where is the likelihood that a set of cloistered monks should either invent or propagate a national music? The most that could be expected from such a lazy tribe would have been a *jubilate* on the nativity of their founder, or some ascetick of their order. For what have such places ever produced, but meagre annals of the church, superstitious lives of



---

p.456



ficticious saints, or some wretched Latin rhimes? Monasteries have, to be sure, been the conservators of literature, but rarely the inventors of any thing laudable.


Nor is it to be believed, what is still more credible, that **James the First of **Scotland**** was the author of the Scots tunes, though **Buchanan** does say, ‘that he excelled in music more than became a King,’ and though Tassoni relates that he composed sacred hymns, in which he was imitated by a prince of Venosa. As well might we suppose, that his descendant, James the Sixth, was author of the literature of **England**, because he was a very learned clerk, and wrote the Basilikon Doron.


The honour then of inventing the Scots music must be given to this country, the antient *Scotia*, so renowned for music in old times; from whence, as we have incontrovertibly proved, the present *Scotia* derived her name, her extraction, her language, her poetry, &c. I have said *incontrovertibly;* but what will not be controverted, as well as advanced? **Mr. Guthrie**, the geographer, among other excellencies of his native country, would persuade us that it



---

p.457



was of old famous for cookery, for this reason, that minced collops is a *Scotch* dish. The learned writer, however, must have forgot that Macbeth had said, when he found that, though Banquo was murdered, Fleance was still alive, and fled,

> 
> We have *scotched* the snake, not killed him.
> 
> 
> 




The *scotch* is, to this day, in universal use in Ireland for that operation of mincing or bruising their flax, whereby they separate the pith from the stalk; and for which, I am told, they have scatching mills. We may, therefore, venture to restore that savoury dish *scotch'd collops* to Old **England**, and the *Scots* tunes, as well as the songs of *Ossian,* to Old Ireland.


But farewell! I hope still to eat my Christmas pye with you, &c.

   
**Dublin**


In a former letter I have hinted, that I shortened my tour westward, on purpose to hear the debates in Parliament. But,



---

p.458



this being a very quiet session, I have had very little to say upon that subject. In the ordinary course of business, there are but few questions debated in this assembly, of sufficient importance to dignify eloquence. It is not enough, that speakers have fluency of speech, precision of intellect, and fertility of imagination; they must also have an argument, in some degree, commensurate to their abilities. The extent of the subject is apt to enlarge the powers of the speaker, and even stretch them beyond their natural limits. On the contrary, a narrow subject, though capable of ornament, refuses grandeur, and without sublimity, *speaking* is not oratory. Twopence a gallon, more or less, upon ale or spirits, can neither awaken ardour, nor rouse attention. The charter of a corporation is of more moment, yet a debate upon it can only animate those who are interested. Whereas a great national question will call forth all the energies of the speaker, and agitate every feeling of the hearer.


I have frequently attended the house, and had but once an opportunity of hearing any great exertions. This was upon the affair of supply, which naturally brought on the 



---

p.459



question of the present state of the nation. And it was amazing, how differently that state was represented by the different parties. On one side of the house, it was held forth as the most flourishing of any country under heaven, and that nothing was wanting to make the people the most happy in the universe, but a contented resignation to the present measures of administration. On the other side, you might have heard it represented as the most injured nation on the earth, despised as an alien, insulted by pensions, oppressed by taxes, and fettered in commerce. So feelingly did Mr. Ogle paint the miseries of the common people, that their cries almost tingled in my ears.


**Mr. Flood** spoke, for the first time, on the opposite side of the question; but he confined himself to calculation, and affected rather to demonstrate than persuade. But there was no spark of that flame remaining, wherewith he is said to have set the galleries in a blaze, whenever he spoke — and when he was so mighty a favourite, that they preferred him to their Burkes, and their Barrés. It would, to be sure, have been extremely embarrassing for him, to have played the orator in behalf of measures,



---

p.460



which, for a series of years, he had employed every art of rhetoric to stamp with infamy.


Mr. H. H—n has a mellifluous voice, and pleasing elocution. His exordium gave me hopes of great matters, but his oratory is of that wordy, ostentations kind, which must sometimes disappoint your expectations. He is here called *Prancer*[63](javascript:footNote('E770001-002/note063.html')) from some similitude they find in him to a horse in the manege, curvetting at the height of his mettle, without making any progress forward.


Mr. Scott, the solicitor-general, is the most powerful among the supporters of government. He does not affect making long speeches, though one of the ablest advocates of the bar; for declamation, in favour of court measures, is but ill heard in any country. His talent lies in promptitude of reply, in dilution of objections, and in turning the arguments of his adversaries against themselves.


Mr. Hussey Burgh is a first-rate speaker in the opposition, his expression is clear, his



---

p.461



language flowing, his action graceful, and his manner persuasive. Mr. Yelverton is vehement and forcible. But the greatest pleasure I received, was from a very young man, a Mr. Daly, whose sentiments were such as became a country gentleman, and whose manner was vastly engaging. He was clear, he was manly, he was copious. His invective against the Secretary was so keen, and so poignant, that **Demosthenes**, at his age, would not have been ashamed of it. He lifted up his voice, he said, in behalf of his oppressed country, which he had just heard represented in such an opulent condition. I who had so recently seen the scenes he so *pathetically* bewailed, could not help going along with him in every thing he said, that was not personal. Yet, what was advanced by the friends of administration, was in some degree true; the kingdom being certainly, upon the whole, in a progressive state of improvement. What must it then have been, if things are so much mended?


Among other good stories of a late member, Mr. Harwood, they tell you a reply he made to a speech of the late Dr. Andrews, a very eloquent and ingenious man; who



---

p.462



had been at some pains to collect all, that could speciously be said, in favour of the opulent state of the kingdom, its export of provisions from the south, of linen from the north, the magnificence of the capital, and the sumptuous entertainments everywhere given, &c. &c. The old barrister is represented as rising up slowly, and standing up for some time, shifting his cloak from shoulder to shoulder, without articulating a word but — *Mr. Speaker* — and at length measuring out, in *teigueish* accents, a laboured panegyric upon his honourable friend's powers of speech. He congratulated the house upon such a senator, the university upon such a president, and the kingdom upon such an advocate, who had proved it, all at once, to be so very rich, from being of late so very poor — ‘As to myself, says he, it would be the utmost ingratitude if I did not return the gentleman my particular thanks for the pleasure he made me feel during his very *long,* yet very *short* oration; for he persuaded me that every halfpenny in my pocket was turned into a guinea; nor am I convinced that the thing may not be so still; wherefore



---

p.463



let me examine.’ — Then pulling some money out of his pocket, he turned round to the house, and concluded with these words: — ‘Ah! no, my dear friends, I find I was deceived, for the halfpence are but halfpence still.’


There is, as you know, a volume of the speeches, delivered in one session only, collected by **Sir James Caldwell**; which certainly does credit to the recollection of that ingenious baronet; yet they do not allow here that it reflects any honour on the nation. For they say that justice is not done to any of the speakers, except those of the middle class; the third class being made to speak too well, but the first not well enough. We, however, thought that, upon the whole, it placed Irish oratory in a very favourable point of view.


It is, on all hands, agreed that the dignity of the long robe has always been supported here with great credit. The opinion of the Attorney-general is reckoned almost infallible; and they talk of old Malone as a prodigy, but he is now past seventy, and seldom speaks in the house, though his powers are not diminished at the bar.




---

p.464


The first-rate lawyers look down upon a seat on the bench. A seat in parliament is a sufficient passport to a puisny Judge's place; and till of late, all the chief Judges were English; now, administration rewards parliamentary services with those offices. The only English judge, at present, is the lord Chancellor, and he gives universal satisfaction. Business is almost entirely conducted by *lawyers* in the house of commons; and in the house of lords very little is done, but merely passing of bills.


It is remarked, that whatever fashion prevails in London, is generally followed in Dublin. No sooner were your medical wigs laid aside, than an attempt was made to do the like here. But in vain! the faculty were not yet ripe enough for this *capital* improvement in the practice of physic. A consultation of the whole college was held upon it, and it was carried by the authority of the seniors, rather than a majority of the fellows, in favour of the prescriptive honours of the head.


Old Malone has given another instance of the clearness of his head, by disencumbering



---

p.465



it of this load of barbarism. And a more venerable figure my eyes never beheld, than this great lawyer in his silver locks. But nobody durst follow his example, though he is the prince of his profession. The Irish judges, however, do not wear such immense volumes upon the breast as those of **England**. I am persuaded that such tortuous wreaths, of horse tails, and goats beards, do not inspire that reverence which they might once perhaps have done; they give the person rather a burlesque air, and take off from that venerable aspect which their natural locks gave to Coke and Verulam.


But let me not waste my paper, and your patience, with such trivial reflections which, however I may make them, I only give you as the last strokes of that sketch I have attempted of the present state of Ireland; which state reflects, as a mirror, the true spirit of its political constitution. And having now touched upon almost every subject worthy the attention of an Englishman, it is full time that we close our correspondence, which has been protracted



---

p.466




to an uncommon length; especially as the *utilitas juvandi* has all along been preferred to the *gratiae placendi.*


If rejecting the common *sentimental* aids, I have been sometimes dull, and often tedious, you are partly to blame, for you tell me I have made you see some things in a new light, and express a wish that I had said more even upon *turf-bogs.* *Laudari a laudato viro* is, you must confess, an animating consideration. I do not know how I may have communicated my ideas relative to this country, but I know they are very different from what they were when I saw you last; and I am persuaded, that in **England** we know less of Ireland, than of the more remote parts of the empire. We look upon it as a spot over-run with lakes and bogs, where nothing is worth notice but a **Giant's-causeway**, a **Killarney**, a **Dargle**, or a **Salmon-leap**. If such objects had fallen in my way, I should only have considered them as not unworthy observation: As a citizen of the world, *altiora peto.* I look upon Ireland as one of the most important political objects which an Englishman can behold, who at once wishes



---

p.467



the aggrandisement of the British empire, and the happiness of human nature at large. We frequently squander much blood and treasure in the extension of territory, while we neglect to improve, to the best advantage, that territory we possess; as individuals purchase new estates, without taking care to cultivate their old ones.


Farewell, my dear Watkinson, till I see you; and again farewell.




---

p.470


Appendix 1
----------


### APPENDIX

### An Account of some antique Curiosities found in a small Bog near **Cullen**


Horns large enough to have a circle of about three feet diameter described on each palm.


1731, A brazen vessel containing two gallons and an half, which had four legs, a broad bumped bottom, growing narrow to the neck, and from thence wider towards the brim, and weighed nineteen pounds.


1732, A poor woman, taking up a black slimy stuff, which lies very deep, to dye wool, found three pieces of bright metal of equal size, and in shape of heaters used for smoothing, which, weighing seven pounds and an half, she sold as brass. Same year, a labourer found a piece of gold, like the frustum of a spheriod, less than half a small egg, which weighed three ounces four pennyweight seven grains.


1738, Seven arrows of brass, about five inches long each, two inches of which formed a 



---

p.470



socket of three-fourths of an inch diameter, in each of which was a shaft of rotten wood, about nine inches long — from the socket to the point they were two-edged and tapered; on either side was a beard, one inch and an half long from the point. Thirteen spears of the same metal, ten inches long, four of which formed a socket of about one inch and three-fourths in diameter, at the entrance of the handle near the socket the blades were broad, but gradually grew acute to the point; the handles of each seemed sound and of quartered ash, about six feet, but on taking them they soon mouldered away; they all weighed six pounds and an half.


1739, A boy found a circular plate of beaten gold, about eight inches in diameter, lapped up in a triangular form, wherein were inclosed three ingots of gold, weighing about a pound.


1742, A thin plate of gold, in the form of an ellipsis, the transverse diameter about two inches and a quarter, and the conjugate less than an inch; weight eighteen pennyweight fifteen grains.


1744, A golden cup in almost the form of a wine glass, the handle of which was hollow, and about one inch and an half long, of the thickness of a goose quill; it was chased, and contained about a thimblefull; the bottom was flat, and about the breadth of a six-pence, 



---

p.471



weight twenty-one pennyweight twelve grains. A tube of four inches long, and as thick as the stem of a tobacco-pipe, which weighed one ounce seven pennyweight twenty grains.


1745, A quadrangular vessel of bright yellow metal, each side of which about ten inches long at the brim, and from the brim to the bottom eight inches; five inches from the brim was entirely flat, the remainder was semiglobular; on either side was an handle, like those on common metal pots. This the poor woman who found it sold to a tinker for a shilling. N. B. *The common Irish, at this day, have a vessel, not unlike this, of solid timber, excavated, which they call a* Mather; *the only difference is, that the mather is not so wide, and all the sides are flat, and the mouth is somewhat wider than the bottom. In a cabbin where I entered with **Mr. Baker**, they offered us cream in a mather to drink.*


1748, A brass weapon, two feet seven inches long, which was two-edged from the hilt to the point. These edges very much resembled the fin which proceeds out of both sides of an eel, from the navel to the top of the tail. It seemed to have been cast in that form and never whetted. It was one inch and three-fourths broad near the hilt, from which, for four inches, it was diminished to an inch and a quarter. From thence to the middle it increased an inch and an half; and from thence it grew narrower to



---

p.472



the termination in an acute point. The blade was near half an inch thick; the part taken for the hilt was about five inches, near an inch broad in the middle, but less toward the blade and the pommel; in it were six rivets, each of which was about three-fourths of an inch long, and on one of them hung a thin piece of gold, which weighed twelve pennyweight nine grains.


1747, A girl found a thin plate of gold rolled up, which extended, was fourteen inches long, and about a quarter broad — another of the same kind, in a sod of turf, as she made the fire.


1749, A plate of gold, round, and ten inches in diameter. There was a gold wire inlaid round the rim, and about three inches towards the centre there was gold twist sowed in and out, and by it another plate of four inches diameter was fastened within — for the larger had a hole in the middle wherein the lesser was concentrically fitted. Three tubes like goose quills split open.


1750, A small plate of gold, in the form of an equilateral triangle, of one inch shand three-fourths each side. The finder sold it to a pedlar without weighing for 2l. 12 s. — And



---

p.473




his wife found, the same year, in a sod of turf, a piece of gold which weighed eleven pennyweight sixteen grains — a ring like a ring-dial, one ounce three pennyweight twelve grains.


1751, Such another weapon as that found in 1748, on the rivets of which was a plate of gold which covered one side; at the end of which was a thing like the pommel of a small sword, with three links of a chain hanging out of it: all the gold together weighed three ounces three pennyweight eleven grains.


A plate of gold five inches broad at one end, and four on the other, and almost six long, beautifully chased and engraved. The goldsmith, to whom it was sold, said he supposed it to have been part of a crown. It weighed one ounce twenty pennyweight sixteen grains.


A piece of hollow gold in form of the *mucro* of a scabbard of a small sword, which weighed one ounce twenty-three pennyweight seventeen grains.


A weapon of the same form of that described in 1748, but that the metal of this was more refined. A goldsmith upon trial found there was gold in it. Close to the hilt on the thick part was engraved an oblong square, about one inch and an half long, inlaid with pewter and copper.




---

p.474


A small hollow cylindrical piece of brass, two inches and an half long, and about three-fourths of an inch diameter, open at one end; the other end resembled a *finder* used by coopers in cleaving twigs.


A gold vessel in the form of our chalice, but with a handle naturally curved. The cup was cracked and bulged, but opened to its full capacity would contain almost a pint. The bottom was not found. The cap and handle were chased and engraved, and weighed ten ounces twelve pennyweight twenty-three grains.


Two thin leaves of gold, folded in each other like the hats of babies, each about three inches in diameter; the crown of one of them was in the form of a cone and smooth. **John Damer**, Esq; of Shronehill, gave for them their weight in coin, *viz.* one guinea and an half.


A piece of gold almost in form of a large scollop-shell. **Mr. Damer** gave for this also its weight in coin, *viz.* fourteen guineas and an half.


Two pieces of gold, one like a man's thumb and hollow, the other an oblong square, about three inches long and one broad, both weighed three ounces nine penny-weight twenty-one grains, and about two grains of gold wire. A



---

p.475



lump of coarse brass of about a pound weight, which seemed to have remained in the ladle after casting. A piece of gold two inches long, as thick as a child's finger, and that seemed to have been cut off a larger piece, on the edge of an anvil; it weighed one ounce seven grains.


Something in the form of a bow, about six inches long, of black heavy wood, but gritty like a stone: on either end was a thin plate of gold which entirely covered about half an inch of it, through which passed a small screw which fastened the plate, and from which appended a little gold chain. The plates and chain were (without being weighed) sold for two guineas. The wood is in the possession of **Mr. Damer**.


1753, Twenty-two of the brass swords, pretty much as before described, some of which were an inch more, and some so much less than two feet — and three only fourteen inches.




---

p.476


Fig. I. Plate facing last page, represents a very extraordinary piece of plated gold, which Thomas Foresyth, Esq; shewed me: it was found by his servant, cutting turf in a bog in the county of **Tyrone**. The crescent, if completed, would form a circle of about eight inches and a half diameter; — the distance between the horn or extremities of the crescent is two inches; — the diameter of the hollow five inches; — the greatest breadth of the plate, three inches; — at the end of the horns were two plates, cutting the other at right angles, each of which was larger than a six pence, but less than a shilling. What use it had been applied to I pretend not to determine, but conjecture it to have been a sort of gorget worn either by a Priest or a Judge. It was of so elastic a temper, that though the horns approached so near each other, it would open so as to receive a neck of moderate thickness.


**Keating** mentions a *miraculous collar,* called *Jadh Morain,* first worn by *Fearaidach Fionfachtah*[64](javascript:footNote('E770001-002/note064.html')), so called from his love of strict justice, in the beginning of the first century. This collar, he tells us, was endowed with a most surprising property, for if it was tied about the neck of an unjust Judge, who intended to pronounce false sentence, it would immediately *shrink,* and contract itself close so as



---

p.477



almost to stop the breath; but if the Judge who wore it changed his resolution, and resolved to be just in his decision, it would instantly enlarge itself, and hang loose about the neck. This *Jadh Morain* was likewise used to try the integrity of witnesses in judicial affairs; and if it were put round the neck of a person who designed being a false witness, it continued closing, till it had either throttled him or extorted the truth. Such is the account of the *wonderful collar* given by the father of Irish history! Whether that we have seen is one of them, I leave the reader to judge.


Fig. 2. is a representation of a piece of gold now in the possession of **Sir Capel Molyneux**. It is about three inches diameter. What the use of it was, I dare not so much as guess. It has been conjectured, yet without much warrant even from the shape, that it had been used as a fibula for the old Irish mantle; but the **Rev. Mr. Archdall** shewed me casts in lead of several of them, which had been in the possession of **Dr. Pocock, Bishop of **Ossory****, some of which were so small that the little cups or bell-like figures at the ends touched each other; and he had some without cups at all; which plainly proves that they never could have been intended for *fibulas*. Mr. Foresyth told me he had seen one, found in his neighbourhood, above



---

p.478



twice the size; and a goldsmith assured me he had melted no less than four of them, some of which had been larger and some smaller than this one; and that he had heard of many more being sold, by the persons who found them, to other goldsmiths.


I must observe too, that **Mr. Archdall** shewed me a drawing of a plate of gold, in all respects like that represented Fig. 1. only that it had not the two little transverse plates at the ends of the horns.


The End