

#A History of the Franciscan Order in Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A History of the Franciscan Order in Ireland
============================================


Author: Donagh Mooney
---------------------


### File Description

English translation by "L"

Electronic edition compiled by Natasha Dukelow

Proof corrections by Beatrix Färber, Malgorzata Krasnodebska-D'Aughton

Funded by University College, Cork, School of History 1. First draft.Extent of text: 
20,250 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland —http://www.ucc.ie/celt

 (2019) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T300002-002Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

This text was donated to CELT by Natasha Dukelow (2019).

Donatus Mooney, OFM was elected Provincial of the Irish Franciscan Province in 1615 and in that capacity he conducted a vistitation of Francisan houses in Ireland between 1615 and 1616. He wrote his account in Louvain between 1617 and 1618. The work was bound by Anthony Purcell, OFM, who in 1617 was a young student at St Anthony's College, Louvain. The English translation of the text appeared in the Franciscan Tertiary (1894–1896); the translator of this text is signed as "L" but a full name is not recorded in the journal. A full Latin edition of the text was published by Brendan Jennings, OFM in 1934.

#### Sources


**Manuscript Source**2. Brussels, Royal Library (olim Burgundian Library); Ms 3947 (referred to as 'MS vii. (3195)' by the editor), large folio (8 x 13.5 inches), 101 leaves, written in 1617 by Donatus (Donagh) Mooney, bound by Anthony Purcell.
**Sources**2. Francisco de Gonzaga, De origine seraphicae religionis Franciscanae ... Opus in quattuor partes divisum [On the History of the Seraphic Order] 2 vols. (Romae 1587).
3. Mervyn Archdall, Monasticon Hibernicum, or, An History of the Abbies, Priories and Other Religious Houses in Ireland. (Dublin: Printed for Luke White, 1786).
4. Richard Butler (ed.), The Annals of Ireland by Friar John Clyn and Thady Dowling (Dublin 1849) 1–46. Online at CELT.
5. William Maziere Brady, Clerical and Parochial Records of Cork, Cloyne and Ross taken from diocesan and parish registries, MSS. in the principal libraries and public offices of Oxford, Dublin, and London, etc. (London: Longmans & Co., 1864).
6. John Clyn, The Annals of Ireland, ed. Bernadette Williams (Dublin: Four Courts Press, 2007).
7. Giraldus Cambrensis, The History and Topography of Ireland, ed. John J. O'Meara. (Harmondsworth, Middlesex: Penguin Books, 1988) i.e. Topographia Hibernica, 1188: J. F. Dimock (ed.), Topographia Hibernica et expugnatio Hibernica, Rolls Series 21. Vol. 5 of Giraldi Cambrensis Opera. (London 1867).
8. Journal of the Cork Historical and Archaeological Society. Vol. 3, No. 33 (1894).
9. Journal of the Cork Historical and Archaeological Society. Vol. 4, No. 34 (1894).
10. John O'Donovan, Annals of the Kingdom of Ireland by the Four Masters, from the Earliest Period to the Year 1616. (Dublin: Hodges, Smith and Co., 1856. Reprinted Dublin 1990). Online at CELT.
11. Luke Wadding, Annales Minorum seu Trium Ordinum a S. Francisco Institutorum: Vols. 1–32 (Florence: Ad Claras Aquas (Quaracchi), 1931–64).
12. James Ware, De Scriptoribus Hiberniae Libri Duo. Prior Continet Scriptores, in Hibernia Natos, Posterior, Scriptores Alios, qui in Hibernia Munera aliqua Obierunt. (Dublin: Ex Typographia Societatis Bibliopolarum, 1639).
13. Brendan Jennings, 'Donatus Moneyus: De provincia Hiberniae S. Francisci', Analecta Hibernica, Vol. 6, 1934, 12–138. Available at http://www.jstor.org/stable/25510938. -- A key article, with a copy of edited text.
**The edition used in the digital edition**2. **"L"**, A History of the Franciscan Order in Ireland in The Franciscan tertiary: a Monthly Journal of the 3rd Order, Ed. Unknown. , Dublin, Freeman's Journal Linited, Printers (1893–1996) Vol 4; 5; 6number 10–12; 1–6 pages 289–97; 321–327; 353–358.

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text represents the text translated by L in The Franciscan Tertiary. In the spelling of personal names, O without a space before the surname has been silently amended and written with apostroph according to modern usage.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section; div2=the subsection; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd, and tagged.


##### Interpretation


Place-names, personal names, titles (of books etc) and terms are tagged. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV2 element to represent the Subsection. ### Profile Description


Created: Written by Donatus Mooney
 (1617) #### Use of language


##### Language: [EN] The text has been translated into English.


##### Language: [LA] Some short phrases are in Latin.


### Revision History


* (2019-05-12) Beatrix Färber (ed.)

* Corrections integrated.
* (2019-05-12) M. Krasnodebska-D'Aughton (ed.)

* File proofed (2); corrections and additions to header communicated.
* (2019-05-10) Beatrix Färber (ed.)

* File parsed and validated.
* (2019-04-26) Beatrix Färber (ed.)

* Two files worked into one; further proofing; structural encoding at div1 level modified; content encoding modified/added, including names of persons and places.
* (2019-04-24) Beatrix Färber (ed.)

* File 2 proofed, proprietary characters replaced, structural/content encoding modified and added to.
* (2019-04-23) Beatrix Färber (ed.)

* File 1 proofed, header details inserted; file parsed.
* (2019-04-16) Natasha Dukelow (ed.)

* Provisional header created; bibliographic details compiled.
* (2019-04-10) Natasha Dukelow (scanning)

* Text scanned.
* (2019-03-16) Natasha Dukelow (ed.)

* Text converted to txt.
* (2019-03-) Natasha Dukelow (ed.)

* Text proofed in MS word format.




---


#### Corpus of Electronic Texts Edition: T300002-002


### A History of the Franciscan Order in Ireland: Author: Donagh Mooney




---

p.289


{journal issue 4:10}
### A History of the Franciscan Order in Ireland.

By very Rev. Donagh Mooney
 
Introduction


Among the many treasures of priceless value to Ireland, which rest on the shelves of the Burgundian library *i.e. the Royal Library* in Brussels is a manuscript entitled: ‘ A History of the Franciscan Order in Ireland’. It is numbered vol. vii. (3195),*Number 3195 is given by L, but the MS number is 3497.* and contains one hundred and one leaves, large folio, closely written on both sides. It appears to have been written by **Father Anthony Purcell**, a learned professor in the College of **Louvain**, from notes supplied by **Father Donagh Mooney**. The latter was for many years Provincial of the Irish Franciscans, and devoted what time he could spare from his duties to the collection of materials for a history of the Order in his native land. He visited **Louvain** in 1617, and confided the precious records to **Father Purcell**, with instructions to prepare them for publication. This manuscript was the result.[1](javascript:footNote('T300002-002/note001.html'))


It cannot be called with accuracy, a ‘ History of the Franciscan Order in Ireland’, as it is styled in the catalogue. It is rather a sketch of the different convents, and their



---

p.290



disastrous fate in the sixteenth century, with brief notices of members of the Order, eminent for learning or sanctity. The details are often meagre. It could not well be otherwise, considering the circumstances under which **Father Mooney** gathered his information. A violent persecution raged, and woe betide the friar who fell into the hands of the soldiers of **Queen Elizabeth** or James. ‘Hold me excused,’ the good Father pathetically writes, ‘that I have not done better. But Church and State have been brought to ruin in this unhappy land, and I had to hurry through my visitation, surrounded by the alarms of persecution, so that I was unable to collect more than the fragments of what is necessary for such a work as this.’ Imperfect as it may be, every lover of the Franciscan Order and of Ireland must be deeply grateful to the venerable priest for rescuing from destruction, under such difficulties and dangers, so many memorials of the past, which would otherwise have perished.


**Father Mooney**'s manuscript has never been translated into English. It forms, indeed, the ground-work upon which **Father Meehan** has elaborated his charming book, The Rise and Fall of the Irish Franciscan Monasteries. But in writing that work he has only culled from our author those incidents and descriptions which pleased his fancy or suited his purpose, while he has introduced a large amount of material from other sources.


I am confident that the readers of the Tertiary will be pleased to have the graphic scenes and life-like pictures of this interesting manuscript placed before them. There are few counties in Ireland in which the ruins of a Franciscan monastery may not be found. Some almost perfect in their simple grandeur, needing, it would seem, but a roof to fit them once more for the abode of some pious brotherhood. Such are Quin, Timoleague, and many others which will occur to the minds of our readers. Of others there remain but crumbling walls and scattered stones, 



---

p.291



as Donegal, around which cling, closer than the ivy, so many memories of the work done for Ireland. Some, alas! have been perverted into places of Protestant worship, and the bald religion of Henry VIII. is preached within those walls which once echoed to the living words of the children of St. Francis. While not a few, thank God, have never been wrested, or but for a time, from the possession of the Order. In Clonmel the square tower, erected six hundred years ago by the pious munificence of the people of the town, casts even to-day its protecting shadow over a church worthy of the ancient glory of the Irish Province. Cromwell stabled the horses of his troopers in the church of Wexford. Now the successors of the Franciscans whom he martyred preach the faith which he would have extinguished in blood in the very spot that he desecrated. The pages of Fr. Mooney give life to these venerable monuments of the past, and we rise from their perusal with a new interest in the vivid ruins of which he has so much to tell of.


I have added a few notes, which seem necessary for the elucidation of the text. These are signed L.


This book was composed by Br. Antony Purcell, in obedience to the command of the Very Rev. Father, Br. Donagh Mooney, Provincial Minister, of the Friars Minor, of the Regular Observance, in Ireland, on the 2nd of November, 1617, in the College of the Irish Friars at **Louvain**. Pious reader, in charity, pray for his soul.


The Very Rev. Donagh Mooney arranged the following particulars regarding the Franciscan Province of Ireland, while he was Provincial, and had come here to set in order the affairs of the College of St Antony.
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------




---

p.292


[2](javascript:footNote('T300002-002/note002.html'))


---

p.293




---

p.294




---

p.295




---

p.296




---

p.297


[3](javascript:footNote('T300002-002/note003.html'))


---

p.321


[4](javascript:footNote('T300002-002/note004.html'))


---

p.322




---

p.323


The Divisions of the Kingdom of Ireland
---------------------------------------


#### 1


The Kingdom of Ireland consists of one island, the largest of the ocean, except Great Britain, which includes



---

p.324



England and Scotland. It was formerly divided into territories corresponding to the divisions of the various races which occupied its soil at different times. The government was always monarchical, but there were a number of subordinate kings, each of whom ruled in his own district. In ancient times there were two divisions of Ireland of special importance. By the first of these the island was divided into two almost equal parts. The southern half called **Leath-Mogha**, comprised Leinster, the two Munsters,[5](javascript:footNote('T300002-002/note005.html')) and a part of Connaught. The northern half, called **Leath-Cuinn**, included Ulster, Meath, the greater portion of Connaught and a small extent of Leinster. By the other it was divided into five provinces, and the territory of Meath, which belonged of right to the reigning king, and was not looked upon as a province. Ulster is situated towards the north, Connaught towards the west, the two provinces at Munster, called East and West Munster, towards the south-west; Leinster towards the south-east, while Meath occupies the centre of the island, bordering on the five provinces, and reaching to the sea on the eastern side.


Another division has recently been made by the English, who have appointed royal officers to preside over certain localities. Thus Munster and Connaught are each governed by a president, and the whole kingdom has been divided into a large number of districts, each of which has been committed to the charge of an officer called a sheriff. These divisions are generally known by the name of counties.


Thus Meath has been divided into two counties, East and West Meath. The official business of the former is transacted in the Franciscan convent at **Trim**, and of the latter in the Dominican Convent at **Mullingar**.


Ulster has been divided into the County of the Town of **Drogheda**, the counties of **Louth**, the court of which sits at 



---

p.325


**Ardee**, **Armagh**, **Monaghan**, **Antrim**, **Down**, **Derry**, **Donegal**, and **Fermanagh**.


The following counties belong to Connaught: — **Sligo**, **Leitrim**, **Cavan**.[6](javascript:footNote('T300002-002/note006.html')) In these the official business is transacted respectively in the Dominican Convent of **Sligo** and the Franciscan Convents of **Creevlea** and **Cavan**; **Roscommon**, **Mayo** and **Galway**. In this last the court is held in the very choir of the Franciscan church, and the judges sit on the high altar itself. How like unto the abomination of desolation set up in the holy places. The county of the town of **Galway**, the court of which is held in the town hall and **Clare**,[7](javascript:footNote('T300002-002/note007.html')) the court of which is held in the Franciscan Convent of **Ennis**.


The two Munsters comprise the following counties: — The **County of the City of Limerick**, **Limerick**, **Kerry**, **Cork**, the **County of the City of Cork**, **Waterford**, the **County of the City of **Waterford****, **Tipperary**, or the **County Palatine of Ormond** as it is sometimes called, and the **County of the Cross-lands of Tipperary**, which had been lately formed. Before the spread of heresy this district was subject to the Archbishop of Cashel, whose officials exercised judicial powers within its borders. The English have now deprived the Archbishop of all jurisdiction, and erected the cross-lands into a county.


The following are the counties of **Leinster**: — **Kilkenny** and the **County of the City of Kilkenny**. The official business of the former is transacted in the Dominican Church of that city, and of the latter in the town hall; **Carlow**, the court of which holds its sittings at **Ross**; **Wexford**, the official assemblies of which meet in the Franciscan Convent at **Enniscorthy**; **Wicklow**, the court of which sits in the Franciscan convent of that town; **Kildare**, the court sitting 



---

p.326



at **Naas**; **King�'s County**, the court sitting at **Dangan**;[8](javascript:footNote('T300002-002/note008.html')) **Queen�'s County**, the court at **Fort-Leix**;[9](javascript:footNote('T300002-002/note009.html')) **Dublin**, the court at **Kilmainham**; and the County of the City of Dublin, the court of which is held in the City Hall.


Thus the whole kingdom has been divided into counties, in accordance with the English mode of government. It is worthy of note that, where at all convenient, the official assemblies and courts of law, where all criminal cases are tried, even murder, and others in which the punishment is death, are held in the churches, those of St. Francis and St. Dominic being especially selected for profanation in this and other ways.


The Four Archdioceses of Ireland and their Suffragan Sees
---------------------------------------------------------


The Archbishop of **Armagh** has his seat in Ulster and bears the title of Primate of all Ireland. The ecclesiastical province of which he is the head includes the whole of Ulster and Meath, with a considerable part of Connaught, and contains the following dioceses, some of which however, have been united: —
  

1. **Armagh**. The last Archbishop, Edmond MacGauran, was martyred on the 3rd of July, 1593. His successor, Peter Lombard, yet lives.
2. **Dromore**, in Ulster, now united to Armagh.
3. **Meath**, embracing East and West Meath.
4. **Clonmacnoise**, which the Protestants have united to Meath without any pontifical authority. The last bishop was Peter Wall, a Franciscan.
5. **Clogher**, in Ulster.
6. **Down**, in Ulster.
7. **Connor**, in Ulster. These two have been united by provision of the Holy See. The last bishop was Conor



---

p.327



O�'Devany, a Franciscan, who gained the glorious crown of martyrdom, by order of Arthur Chichester, in Dublin on the 1st February, 1612, according to the old style then in use in that part of Ireland.
8. **Derry**, in Ulster. The last bishop was Redmond O'Gallagher, who was martyred on the 8th of March, 1609. He was then far advanced in years, and was considered to have been the oldest bishop in Europe, counting from the time of consecration.
9. **Raphoe**, in Ulster. The last bishop was Neil O'Boyle, who died on the 6th of February, 1611. His predecessor was Malachy MacCongail.
10. **Ardagh**, in Connaught (sic), comprising the county Longford.
11. **Kilmore** in Connaught (sic). The last bishop was Nicholas MacBrady, a Franciscan, of whome I will speak later on. He was a holy man, and died full of years in 1607.



ERRATA — In last month�'s issue, p. 291, line 17, for ‘vivid,’ read ‘ivied,’ and line 18, for ‘tell of,’ read ‘tell us.’




---

p.353


{journal issue 4:12}The Province of Dublin
----------------------


The Archbishop of **Dublin** is called Primate of Ireland. The ecclesiastical province comprises the whole of Leinster, and does not extend beyond its borders. The dioceses are as follow: —
1. **Dublin** and
2. **Glendalough**, which are now united. The last archbishop was Matthew de Oviedo, a member of our Order. The see at present occupied by his Grace Eugene Matthew, a man of distinguished life and learning worthy to have filled that high position in more prosperous times. He lives at present in Ireland, eluding, by God�s help, the many snares set for him by the heretics. He labours unceasingly for the welfare of his diocese, which he watched over from his hiding-place with pastoral vigilance.
3. **Kildare**. The last bishop was Thomas Leverous.
4. **Leighlin**. The last bishop was a Franciscan, Francis de Ribera. He built at his own expense the infirmary of our convent at Antwerp. Being unable to reach Ireland, he lived there for many years until his death.
5. **Ferns**. I have no knowledge of the bishops of this diocese.


---

p.354

8. **Ossory**. The Chief residence of the bishop is at Kilkenny. The last Bishop was ... [10](javascript:footNote('T300002-002/note010.html'))



The Province of Cashel
----------------------


The ecclesiastical province of **Cashel** comprises Ormond, Desmond, and that part of Connaught which is called Thomond. It contains the following dioceses—
1. **Cashel**.
2. **Emly**.[11](javascript:footNote('T300002-002/note011.html')) These two are now united. Whether in perpetuity of for a time I know not. The present archbishop is David Kearney, who lives in Ireland, His predecessor was Dermot O�Hurley, who was crowned by a glorious martyrdom in the month of May, 1584, by the orders of the Lord Justice, Sir Henry Wallop.
3. **Waterford**.
4. **Lismore**. These two have been united for a long time.
5. **Cork**. These two have also been united for many years. The last bishop was Dermot MacCraghe, a man of great prudence and most skilful in the administration of affairs. I saw him about the year 1599, and he lived for some time afterwards.
6. **Ross**. Boetius[12](javascript:footNote('T300002-002/note012.html')) Egan was Bishop of this diocese. He was a member of our Order, and most active in the promotion of the Catholic cause. He was put to death in 1650, a noble martyr of the Faith.
7. **Ardfert**.
8. **Kilfenora**. The last bishop was a Franciscan, Hugh MacClanchy.


---

p.355

11. **Limerick**.
12. **Killaloe**. Conor Ryan was lately bishop of this acre. He belonged to our order, and lived about the year 1615.



The Province of Tuam
--------------------


The ecclesiastical province of Tuam contains part of Connaught only, two dioceses of which belong to Armagh, and two to Cashel. The episcopal sees are as follow: —
1. **Tuam**.
2. **Mayo**.
3. **Annaghdown**, near Galway. These three have been united for a long time. The last bishop of mayo was Patrick O�'Hely, of whom mention is made in the chronicles of the Order. He received the glorious crown of martyrdom, along with his companion, Conor O�'Rorke, also a Franciscan, at Kilmallock, in Munster, in 1570, by orders of **William Drury, Lord Justice of **Ireland**** under **Queen Elizabeth**. We will have occasion to speak of this hereafter. The present Archbishop of Tuam is **Florence Conry**, also a member of our Order. He was formerly Provincial of Ireland. We will also speak of him later on.
4. **Clonfert**. The last bishop was Teige O�'Farrell, a Dominican. He died at Kinsale, in 1601, while the Spanish troops, whom he and the Archbishop of Dublin were mainly instrumental in having sent to Ireland, to assist in carrying on the war for the Catholic faith, were closely besieged in that town by the English.
5. **Killala**.
6. **Achonry**. The last bishop was Own O�'Hart, who assisted at the Council of Trent. I met him in 1597. He was then far advanced in years, but withal, full of vigour.
7. **Elphin**.[13](javascript:footNote('T300002-002/note013.html')) I know nothing of this diocese.


---

p.356

10. **Kilmacduagh**. The last bishop was Malachy O�'Molony, who died about 1610, at an advanced age. He had ruled his diocese for many years in times of persecution, and had suffered imprisonment and other outrages at the hands of the Protestants.[14](javascript:footNote('T300002-002/note014.html'))



Thus far I have jotted down what occurs to my memory regarding the dioceses of Ireland. Others may add facts of more importance. I do not presume on the extent of my knowledge, but can safely say that I have written nothing but what I have ascertained to be true.


I will now give the number and names of the convents of our Order in Ireland, pointing out the province, according to the ancient division of the country, and the county, according to the new, as well as the dioceses in which each is situated. I will then describe their condition in this present year, 1617, and set forth what particulars I have been able to collect regarding the founders and date of foundation of each. Let me first place before you the account of the province given by **Bartholomew de Pisis** in his Liber Conformitatum. Lib. Primus. Fructus et conformitas.[15](javascript:footNote('T300002-002/note015.html')) Many of the names, as it will be seen, are given in corrupt form. These I have corrected.


The province of Ireland is divided into five custodies. In the custody of Dalbinensis (Dublin) are the following convents: Dubina (Dublin), Kaldaria (Kildare), Clana (Clane), De Mortoto (Stradbally)[16](javascript:footNote('T300002-002/note016.html')), Deserti (Castledermot), Bachilo (Wicklow), Veiesercfordia (Wexford).




---

p.357


In the custody of Cashel are the convents of Casello (**Cashel**), **Bullienia** (I do not know to what place he refers unless it be **Kilkenny**[17](javascript:footNote('T300002-002/note017.html'))), Jochil (**Youghal**), **Ross**, Vacripordia (**Waterford**) and **Clonmel**.


In the custody of Cork are those of Cortigia ( **Cork**), Ardach ( **Ardfert**), Bachonia ( **Buttevant**), Luecia (Ath—[18](javascript:footNote('T300002-002/note018.html'))) and **Timoleague**.


The following convents belong to the custody of Nenagh: Venath ( **Nenagh**), Clararoi (**Clare-Galway**[19](javascript:footNote('T300002-002/note019.html'))), **Killeigh**, **Galway**, Clonramada (**Ennis**), Blessivia (I do not know this place; I think it is **Cavan**[20](javascript:footNote('T300002-002/note020.html'))) and **Armagh**.


The following belong to the custody of Drogheda: De Ponte (**Drogheda**), Trun (**Trim**), Dundava (**Dundalk**), Malifarnam (**Multifernam**), Dunri (**Down**), Occagfregis (**Carrickfergus**).


I have thought it well to quote **Pisanus** thus far to show that these convents had been founded in his time, but he does not mention all. I will prove later on that he has omitted some which existed at that date, or has written their names in such a corrupt form that they cannot be identified. We can easily understand how scanty his information on the subject must have been.


I quote the following also from **Pisanus**: — ‘In this province of Ireland rest the remains of **Nicholas de Gaulford** (Waterford), who foretold the day of his death to his brethren� and **John de Vassordia** (Wexford), at whose grave the sick were restored to health, and the slain to life.’


I find in an old manuscript[21](javascript:footNote('T300002-002/note021.html')) written by **Fr. John Clyn**, 



---

p.358



that at the Provincial Chapter held at **Clane** in 1345, four custodies only were allotted to Ireland. At the same time the convents of **Kilkenny** and **New Ross** were annexed to the custodies of Dublin.


This **Fr. John Clyn** belonged to the Conventual branch of the Order, and was guardian[22](javascript:footNote('T300002-002/note022.html')) of the convent of **Carrick-on-Suir**, which was given to us by **James Butler, first Earl of **Ormond****, in 1336. **Fr. Stephen de Barry** was then Provincial, and **William Naish**, Custos. This was many years before the reform had been introduced.


I will now give as complete a list of the convents of our Order in Ireland as my information allows, assigning each to the province in which it is situated.
1. ULSTER.
  
There are eight Franciscan Convents in Ulster: — **Drogheda**, **Dundalk**, **Monaghan**, **Armagh**, **Carrickfergus**, **Downpatrick**, **Donegal** and **Lisgoole**.
2. CONNAUGHT.
  
There are twelve convents in Connnaught: — **Ballyrourke**, called in Latin, **Petra Patritii**[23](javascript:footNote('T300002-002/note023.html')); **Cavan**, **Elphin**, **Moyne**, **Rosserilly**, **Baile-an-Chlair**[24](javascript:footNote('T300002-002/note024.html')), **Galway**, **Kilconnell**, **Meelick**, **Kinalekin** and **Ennis**.[25](javascript:footNote('T300002-002/note025.html')).
3. MUNSTER.
  
There are twenty convents in the two Munsters: — **Limerick**, **Adare**, **Asketin**, **Lislaghlin**, **Ardfert**, **Bantry**, **Sherkin Island**, **Irrelagh**,[26](javascript:footNote('T300002-002/note026.html'))**Timoleague**, **Kilcrea**, **Cork**, **Buttevant** or **Kilnamulla**, **Youghal**, **Gallbally-Aherlow**, **Clonmel**, **Carrick-on-Suir**, **Waterford**, **Cashel**, **Roscrea**, and **Nenagh**.
4. LEINSTER.
  
There are twelve convents in Leinster: — **New Ross**, **Kilkenny**, **Enniscorthy**, **Wexford**, **Castledermot**, **Stradbally**, **Killeigh**, **Kildare**, **Kilcullen**, **Clane**, **Dublin**, **Wicklow**, and **Monasteroris**.[27](javascript:footNote('T300002-002/note027.html'))
5. MEATH.
  
There are only three convents in **Meath**: — **Trim**, **Multifernam**, and **Athlone**.

 
Thus the convents belonging to the Franciscan Province of Ireland number fifty-six.[28](javascript:footNote('T300002-002/note028.html')) To these must be added the College of **St. Anthony** at **Louvain**.




---

p.353


The Convents of the Province of Munster
---------------------------------------

Limerick
--------


The Convent of **Limerick** occupies a delightful position, on an island in the **Shannon** — a river, upon the beauties and excellencies of which I would wish to dilate, were it not beside the purpose. It stands on the bank of the river, close to the city walls, towards the east, having the Monastery of **Holy Cross** to the south, and that of **St. Dominic** to the north. The orchards and other possessions join those of the Dominicans and extend from the gate nearest their convent to the gate nearest to that of **Holy Cross**. The space thus enclosed would be quite sufficient for a new convent, for the roof of the old one has fallen in. The walls, which still stand, show it to have been of good size and well proportioned, but the building materials were of an inferior description, and the edifice is now threatened with ruin. It is said that the first founder was the **Baron of Castleconnell**, or some one of his family, which



---

p.354



of them I have been unable to discover, nor do I know the date of foundation. It was certainly the burial place of that noble family, though none of them have been interred within its walls for many years, for the place has been not only profaned, but has become the receptacle of the filth and refuse of the neighbourhood. A Protestant named **Sexton**, who had been secretary to the late **Lord Deputy Chichester**, now holds possession of our property, and has erected a tannery in the very monastery. No trace of the records, or precious movables remains. At present a few friars live in the city in a rented house, and give all the assistance possible to the people in their spiritual necessities. I preached there last year, and made three visitations of the place as Vicar and Provincial.


**Adare**
---------


The Convent of **Adare**[29](javascript:footNote('T300002-002/note029.html')) was one of the most celebrated in Munster. It is in the diocese of Limerick, about twelve miles west of that city, and stands on the bank of the **Maige**, about three miles from its junction with the **Shannon**.


I have found the following particulars relating to this convent in the book, which, according to the constitutions of the Order, as well as of the Province, should be read, in presence of the community, on each Friday of the year, that the memory of our departed benefactors might not be forgotten. This book is at present in possession of an old man named **James Hickey, who had been Syndic of the convent**: — ‘The Church of the Friars Minor at **Adare** was dedicated in honour of St. Michael the Archangel, on the 19th November, 1464, the Feast of St. Pontianus, Martyr, and St. Elizabeth, Widow, **Thomas Earl of **Kildare****, and his wife **Johanna, daughter of **James, Earl of **Desmond******, built the church and a fourth part of the cloister at their own expense. They also furnished the windows of the church with glass, and presented the bell and two silver chalices. The convent was



---

p.355



accepted, on behalf of the Order, at the Provincial Chapter, held at **Moyne**, on the Feast of the Apostles SS. Peter and Paul, in the same year, and the brethren of the Family of the Observance entered into possession on the Feast of All Saints following. The church was consecrated in honour of St. Michael the Archangel, on his feast, in the year 1466. The following places, outside the church, were also consecrated that they might be used for the burial of the dead. The whole circuit of the cloister, inside and outside, both sacristies, and the entire cemetery, except a portion at the south, which was set aside for those who might die without the right to Christian burial.’


‘The other parts of the edifice were built by the following: — The bell-tower, by **Conor O'Sullivan**, a pious and devout stranger who had settled amongst us (so the ancient book described him.) He also presented us with an excellent chalice, gilt with gold. **Margaret Fitzgibbon**, wife of **Cunlaid O'Daly** erected the great chapel. One of the small chapels was built by **John, son of the Earl of **Desmond****; the other by **Leogh de Tulcostyn**, and **Margaret, wife of **Thomas Fitzmaurice****. **Donough O'Brien, son of **Bryan Duv, of **Ara****** and his wife built the dormitory. We owe another fourth part of the cloister to a Tertiary, **Rory O'Dea**, who also gave us a useful silver chalice. Another Tertiary, **Marianus O'Hickey**, erected the refectory, and the wooden choir at the north side. He entered the Order later on, and lived in this convent, having spent a most holy life. **Donald, the son of O'Dea** and **Sabina, his wife**, finished another fourth of the cloister. **Edmond Thomas, Knight of the Glen**, and his wife, **Honora Fitzgibbon**, erected the infirmary. The latter died on the 13th May, 1503. **Johanna O'Loughlin**, widow of Fitzgibbon, added ten feet to the sanctuary, under which she directed a burial place to be formed for herself. **Conor O'Sullivan**, who built the belfry, died on the16th January, 1492; **Margaret Fitzgibbon**, who built the Lady Chapel, on the 23rd January, 1483; **Donough O'Brien, son of **Bryan Duv**** who constructed the dormitory, on the vigil of St. Francis, 1502; **Thomas Earl of **Kildare****, founder of the convent, on the 25th March, 1478; his wife, **Johanna**, on the



---

p.356



Feast of St. Antony of Padua, 1486. The first to receive the habit in this convent was **Theoderic Fitzmaurice**, who died on the 18th June, 1484. There lived here also another lay brother named Quirke, who was held in great esteem for his sanctity. He died on the 13th December, 1532. **John, Prior of **Holy Cross**, **Limerick****, who was the ‘Ordinary Protector’ of the Fathers of Adare, died on the 2nd August, 1531.’


The **Most Rev. Raymond de Burgo**, who was a member of the Observantine branch of the Franciscan Order, and Bishop of Emly, died on the 29th July, 1562, and was buried in **Adare**. It is believed that he was the last Bishop of that diocese. Some of the precious possessions of this Convent are yet in existence. There are at present in Cork, under the custody of **Fr. Thomas Geraldine**, a **ciborium** for the Blessed Sacrament, gilt with gold and of good workmanship; a silver processional cross, and six or seven chalices, some of which are also gilt with gold. The register is among the other registers of the Province. I have, also, seen a list of the sacred vestments, and was much surprised at the large number, but all these have perished under the decaying hand of time. The friars were driven from **Adare** during the war between the **Earl of **Desmond**** and **Queen Elizabeth**. The convent, which up to that time had been kept in excellent repair, was allowed to go to ruin. At present the roof has fallen in, but the walls stand, and the glass even is uninjured in some of the church windows.


Such is the meagre account I am able to give of **Adare**, but so great was the celebrity of this convent for the strict life and religious observance of its inmates, as well as for the beauty of its buildings and the piety of the people who dwelt in the neighbourhood, that I am convinced I could have collected many more circumstances worthy of record if I had had leisure to continue my investigations.


**Lis-Laghtin**
---------------


This Convent stands on an island in the **Shannon**,[30](javascript:footNote('T300002-002/note030.html')) and was



---

p.357



founded[31](javascript:footNote('T300002-002/note031.html')) for the Family of the Observantines. It has not been occupied by the friars for a long time. I have met an old lay brother who was professed there, but have never been in the place, and know nothing more about it, except that it is said that the situation is solitary and surrounded by woods.


**Askeaton**
------------


The Convent of **Askeaton**[32](javascript:footNote('T300002-002/note032.html')) is said to have been built; by the **Earl of **Desmond****. It has not been inhabited by the friars for many years. In the war against the **Geraldines** of Munster the inmates were treated in a most barbarous manner by the English under **Sir Nicholas Malby**. Some of them were put to death for the faith. Among these martyrs of Christ was **Father John Conor**, whose remains were buried in the chapter-room. I have been unable to ascertain the names of the others.


{journal issue 6:1}


---

p.1


**Timoleague**
--------------


The convent of **Timoleague** is situated near the sea, in a maritime town of little importance, in the diocese of Ross and county of Cork. It was founded by **Lord de Barry** for the family of the Observance, on the site of one of his castles. I have been unable to ascertain the date.[33](javascript:footNote('T300002-002/note033.html')) It was the burial place of almost all the nobles of that country. The buildings are still standing, but in great need of repair. The cells in the dormitory have been broken down, and the materials removed. The floor of this portion of the house was supported on beams of carved oak. These, too, have been carried off, but the spoiler did not escape unpunished.




---

p.2


In the year 1596 **Dr. Hanmer**[34](javascript:footNote('T300002-002/note034.html')) an English Minister, obtained permission from the Royal Council to make use of this wood-work in the erection of a house. He came to **Timoleague**, tore down the cells of the dormitory, and placed the beams he coveted on board a vessel in the harbour. He was about setting sail when a violent storm suddenly rose and overwhelmed the ship with all its cargo. This was the more remarkable from the fact that the port was well protected from the winds, and a shipwreck in its calm waters unknown. No wonder the people who had witnessed, or heard of the occurrence deemed it a signal manifestation of the Divine anger, on account of the sacrilege.


Some time before this **Lyon**,[35](javascript:footNote('T300002-002/note035.html')) the Protestant Bishop of Cork, who yet lives, set about building a mill. He required some iron for the machinery. The friars' mill was convenient. He broke it open and removed all the material he needed. Shortly afterwards a fierce flood rushed down the river, and swept away the Bishop's new mill. There were not a few who recognised in this the power of St. Francis, for they well



---

p.3



knew that he has often inflicted exemplary punishment upon those who have profaned, or plundered what has been dedicated to his service. Others held that it was a mere accident. These, however, had cause to change their minds before many weeks had passed. The Bishop came to the place fully determined to rebuild the mill. He ordered what remained of the machinery and the very mill stones belonging to the friars to be removed to the site he had fixed upon for the new building. He hired labourers and set them to work, but scarcely had they commenced, when he was stricken with such terror that he told them to desist. He afterwards publicly confessed, that he was impelled to this, not by any feeling of compassion for the friars, whose property he had taken possession of, but by a sudden fear that if he continued the work, some great evil would surely befall him. He was convinced, he said, that the flood which had swept away the mill on a former occasion was an effect of the power of St. Francis, and he dared not proceed further with his designs lest something worse should happen to him. He then went his way and left the mill unfinished. After this there *were* few indeed who did not look upon the whole circumstance as a miraculous interposition of Divine Providence.


On another occasion, in the year 1612, the same **Dr. Lyon** resolved to surprise, and capture if possible, the friars, and the multitude of devoted people whom he knew would assemble in the church of **Timoleague** for the celebration of the Divine service on Christmas night. He lived in the city of Cork, eighteen miles distant. It was therefore necessary to set out on the preceding day. This he determined to do, notwithstanding the remonstrances and entreaties of many of his friends, who expressed their belief that such deeds never pass unpunished. He mounted his horse, surrounded by a number of miscreants, whom he had selected to be his partners in this impiety and sacrilege. He had scarcely started on his journey when he was seized by a pain in the stomach, so violent that he had of necessity to alight and wrap himself in warm flannels. The pain passed away, and the warning from on High was unheeded. He muffled himself in heavier clothes, and again took his seat in the saddle. He had gone




---

p.4



but a little distance outside the city when another access of pain forced him to dismount a second time. He found relief after some delay, but even then, in opposition to the advice of his followers, he persisted in his wicked design. Having ridden for three or four miles the agony was renewed, and he found it impossible to advance another step. He then acknowledged that the hand of God was in these repeated attacks, and that it was in vain for him to contend against the Lord and St. Francis. Retracing his steps to Cork, he grew better and better as he approached the city — that is, as to his body, for as to his soul or as to sorrow for his sins, no improvement resulted from the bitter lesson. Some say, however, that he was less rabid in his persecution of the Franciscans from that time.


The following incident happened in **Timoleague** during the late war. A company of English soldiers consisting of one hundred foot and fifty horse, was marching in that direction. They approached the village, and saw with astonishment the elegantly built convent and well furnished church, the stained-glass windows, and beautiful paintings round the altars. The fury of the bigots was roused at the sight. They destroyed the paintings, broke the statues to pieces, and smashed the glass in the windows with stones. The carpenter, who had general charge of the repairs of the building, was present. Carried away by indignation and zeal, he broke out into the following appeal to St. Francis. — ‘Holy Father,’ he exclaimed, ‘thy power is great before the Lord, and thou canst obtain whatsoever thou desirest. Now I swear that I will never work a single day in this your convent, nor help its inmates in any way unless you take vengeance on the sacrilegious ruffians who have profaned your church.’ The soldiers having wrecked the church and monastery proceeded on their march the following day. They had not advanced far when they encountered **Donnell O'Sullivan**, a noble Irishman, who was then carrying on war against the English, in alliance with the other Catholic princes. He had somewhat less than eighty foot soldiers with him, yet he bravely charged the enemy, who numbered, as I have said, one hundred and fifty. His



---

p.5



victory was complete. Of the whole company but one escaped from the battlefield.[36](javascript:footNote('T300002-002/note036.html'))


In this convent repose the remains of the holy martyr, the **Rev. Owen MacEgan**, who, while acting as chaplain to the Catholic army in 1602, was mortally wounded and left for dead on the field. He expired shortly afterwards with sentiments of great zeal and charity, in presence of the priests and doctors who attended him. These have declared, and confirmed their declaration by oath, that as he breathed forth his soul, an extraordinary brightness filled the place so that the light of the lamp was obscured, and a great joy gladdened their hearts. He was buried in the cloister, near the north-western angle. A small cross in the wall marks his resting-place.


Many were the excellent and devoted religious who lived and died in the Convent of **Timoleague**, but time, the great destroyer, has blotted out the memory of almost all. The following miracle is recorded of one of them, a holy and simple-minded priest, named **Maurice O'Hickey**. In the year 1595 a certain man lay ill unto death, without any hope from human aid. He sent for **Fr. O'Hickey**, and besought him to bless some water for him. He blessed it, and it was changed into most sweet and excellent milk. The sick man drank of it, and recovered his health in a marvellous manner. He lived for more than twenty years, until 1619. In the first year of my provincialship (1615) I made inquiry into the truth of this miracle, and ascertained that the man who had been cured had on several occasions borne witness to the fact, before a large number of people.


There are now but two friars in **Timoleague**, and even these have oftentimes to fly from the fury of their persecutors.


{journal issue 6:2}


---

p.33


**Ardfert**
-----------


The convent of **Ardfert**,[37](javascript:footNote('T300002-002/note037.html')) in the episcopal city of that name, in the county Kerry, was founded by the **Baron of **Lixnaw**, otherwise called Fitzmaurice **Kerry****. The place has not been inhabited by the friars for many years, and the buildings are now in ruin.


It is the burial place of the present baron, as it was of his ancestors. On this account he promised me to purchase the grounds from the Englishman who has possession of them at present and to rebuild the convent. At his earnest and oft-repeated request I engaged to send him two members of the Order who would take up their residence in the ruined abbey. This I did the more willingly on account of the great zeal of the noble baron.




---

p.34


**Bantry**
----------


I have never been in this convent[38](javascript:footNote('T300002-002/note038.html')), or the vicinity. It is at present unoccupied by the friars, and I know nothing regarding it worthy of relation. There is no doubt, however, that it was a convent of our Order, and I am sure many interesting details would be brought to light if inquiry were made. I unhappily, have not leisure to do so.


**Irrelagh**
------------


The convent of **Irrelagh**.[39](javascript:footNote('T300002-002/note039.html')) occupies a most solitary position in a recess of **Slievelogher**,[40](javascript:footNote('T300002-002/note040.html')) near to **Lough Lein**.[41](javascript:footNote('T300002-002/note041.html')) Before the late war the buildings, including the ceilings and the glass in the windows were in an excellent state of preservation. Nothing seemed wanting. But at present it is partially in ruins, and has not been inhabited by the friars for many years. Great numbers are buried in the precincts, and a multitude of people yet assemble there for purposes of devotion, for it is remote from the inhabited districts, and seldom disturbed by incursions of the English heretics.


The structure is small but well built. There is an abundance of fish, and the friars own a weir on the river flowing



---

p.35



from **Mangarsach**.[42](javascript:footNote('T300002-002/note042.html')) An Englishman having obtained a grant of this convent from the king, the people of the neighbourhood offered to purchase it from him and rebuild it. To encourage them in this laudable undertaking, I appointed two friars to the place, and nominated a holy priest to act as Syndic.


The founder was the **Prince of **Desmond**, MacCarthy More** (If I mistake not). It is in the diocese of **Ardfert**.


**Innis-Sherkin**
-----------------


The convent of **Innis-Sherkin** stands on an island in the sea at the entrance of **Baltimore harbour**. The **O'Driscolls**, who have a castle close beside, were its founders.[43](javascript:footNote('T300002-002/note043.html')) Its position in the open sea was of advantage in many ways, but, at the same time, most dangerous. The supply of fish and other products of the ocean were abundant. Indeed, the inmates could cast the line while walking in the garden, and catch fish in large numbers. On the other hand, it lay open to the ravages of pirates and marauders of all sorts. In fact, the first object of such gentry was the capture of this island, for the anchorage of **Baltimore** afforded them small security while an enemy occupied **Innis-Sherkin**. This exposed position of the convent led finally to its destruction.


On one occasion certain merchants from the city of **Waterford** entered the port, and were detained there for some time by contrary winds. The **O'Driscoll** was absent, and the garrison of the Castle, believing them to be pirates, or pretending to believe so, that they might have a pretext for plunder, attacked them and carried off some of their goods. They then allowed them to depart with their ships and what remained of their property. No sooner had the merchants returned to **Waterford** than the citizens armed a



---

p.36



number of vessels, and set sail for **Innis-Sherkin**. They stormed the island, destroyed the castle and convent, and returned to their own city with all the booty they could lay hands on. I do not know how they treated the Friars in person, but I have no doubt that they carried away everything of value they could find. In 1613 a citizen of **Waterford**, whose paternal grandfather had taken part in this expedition, gave up to me the great bell of the convent, which I handed over to the syndic of the friars in that city, who has it still in his possession. Having carried off the bell, it is not probable that they spared the chalices and other effects of the convent. But I found no trace of anything but the bell.


Since that time the convent has remained a ruin, and was never afterwards occupied by the friars. It is the common belief of the people of **Waterford** that none of those who took part in this act of sacrilege ever prospered in their undertakings, and that they either died without children or left them paupers.[44](javascript:footNote('T300002-002/note044.html'))


**Kilcrea**
-----------


The convent of **Kilcrea** is built on the bank of the **Bride**, in the territory of **Muskerry**, and diocese of Cork, from which city it is distant seven Irish miles. It was founded by the Lords of **Muskerry**. I am not certain of the date, but it does not appear to be of great antiquity.[45](javascript:footNote('T300002-002/note045.html')) The structure, though small, is admirably adapted for a monastic establishment. The buildings have been preserved in complete repair to the present day, and lack nothing but the presence of the friars who are prevented from occupying the place, not alone by 



---

p.37



the general persecution of the heretics, but more especially because **Cormac M'Dermott, Lord of **Muskerry****, bound himself under legal penalties in 1614 not to suffer them to dwell in their ancient abode. They have not, however, deserted the district, and four Franciscans live in the vicinity of the convent, and impart what spiritual graces they find possible to the people of the surrounding country. The majority of the nobility of **Muskerry** have their burial places in **Kilcrea**, and are most careful in preserving the church and convent from injury. They are, indeed, worthy and generous benefactors of our Order, and have been so since we came among them.


Of the records of this convent I have been able to recover but these few. In the year 1584 a company of English soldiers passing through the district entered the church and commenced to pull down and hack to pieces the statues and paintings. Two of them climbed up to the place where an image of the crucifixion stood. It was a beautiful work of art, having on each arm of the cross an exquisite medallion wrought in gold and silver, representing one of the evangelists, and was of great value on account of the precious metal it contained, as well as of the skill of the artist. Each struggled to reach and seize upon the coveted spoil before the other. They finally came to blows, and both fell mortally wounded. One died that night, the other on the following day. Their fate was considered by all present a just retribution of Divine Providence.


The English soldiers made another attack on the convent in 1599. Their arrival was unexpected, and **Father Matthew O'Leyne**, a venerable priest, about 67 years of age, was on the premises. He fled from the Monastery to escape their violence, but was overtaken while crossing the **Bride**, and fell pierced by their lances. He died, without doubt, a martyr's death for he was slain in hatred of the Faith.


Here also lived in the odour of sanctity a priest named **Felim M'Carthy**. Before entering religion he had been a member of the Third Order, and was remarkable for his hospitality, his charity to the poor, and his attention to the sick and wounded during the war. He quarrelled one day with



---

p.38



 
his step-brother, and in a moment of passion, hurled at him a large knife which he held in his hand. It struck the unfortunate man and killed him on the spot. Anxious to do penance for his crime, he determined to leave the world, and having obtained a dispensation from the irregularity which he had incurred by the murder, he besought our, brethren at **Kilcrea** to admit him into their community. He urged his petition with such perseverance and earnestness that he, at last, obtained his request. From the day he entered the monastery his life was spent in penance and tears, serving God in all humility, and weeping day and night for his sins. The Lord vouchsafed to declare his complete reconciliation with him by two wonderful signs. In his extreme old age the joints of his fingers, except the index, became so stiff and contracted that he could not extend or make any use of them. This and the thumb of both hands, with which he offered the Holy Sacrifice of the Mass, and touched the Adorable Sacrament, retained their full strength and flexibility. All who observed this strange fact came to the conclusion that the hand which had shed human blood had lost its strength by a just judgment, and that the first fingers retained their power by virtue of the Unbloody Sacrifice which they had so often assisted in offering. The other sign of God's mercy was this. While the holy man lay dying in the infirmary, the people of the surrounding country beheld the convent light up as if it were in flames. A crowd gathered from all sides. There was no sign of fire, but the man of God had died at the very time in which they had seen the flames rise up towards heaven. They returned to their homes glorifying the Lord, who had deigned to show forth by this marvellous sign how pleasing to Him had been the life of His servant.


Inside the cloister, at the entrance of the chapter room, rests the body of the venerable **Father Teige O'Sullivan**, who died on the 17th of December, 1597. He was a distinguished preacher, and had been most successful in his missionary labours throughout a great part of Ireland, especially in those districts which were more difficult of access on account of the forests, and therefore more lawless, and frequented by robbers and abandoned women. Many of these outcasts were brought 



---

p.39



back to the paths of virtue by his admonitions and exhortations so that the light of his good example shone through all the kingdom. He was the faithful adviser of **Dr. Mac Creagh, Bishop of **Cork****, who undertook nothing of importance without his counsel.


Many were the plots hatched against his life and liberty by the Protestants. They were offered a reward for his capture. On this account a number of evil-minded men were constantly on the watch to seize him and hand him over to the English authorities. One day, while travelling through the County Cork, he was suddenly surrounded by a number of these ruffians. Now that they had met him, they changed colour, as if they feared to execute their wicked design. ‘Friends,’ he said ‘consider well what you have come here to do. Carry out your purpose if you so determine, I am ready, if such be the will of God.’ They were astounded at his words, believing that he had come to the knowledge of their project by divine revelation and not daring to lay hands on the holy man, suffered him to proceed unmolested.


On another occasion he was pursued, in the same county, by a company of English troopers. Approaching a cross on the wayside he besought God that through the virtue of *His Holy Cross* those enemies might not be permitted to pass that sacred sign. Wonderful to relate, when the horsemen reached the cross they could not advance a step beyond it. They saw object of their pursuit a short distance in front, but try as they would they found it impossible to proceed. Thus the servant of God escaped their hands.


**Fr. O'Sullivan** died at a distance from the convent of **Kilcrea**, in a place where he had been labouring for the edifices of the people. The whole country was then so devastated by war, that the public roads could scarcely be traced by daylight. The Catholics, among whom he had died, determined to bury him with his brethren. They dared not attempt this in an open manner, so, when night fell, the body was placed upon a horse, and accompanied by the best guides in the locality, the funeral party set out on their journey. The darkness was intense, and after a short time the way was lost. They knew not what direction to turn or what course to take.



---

p.40



After a long and painful delay one of them said, ‘Let the horse go on and choose his own path. He bears the body of a saint, and by his guidance will doubtlessly lead us alright.’ The horse walked on, and turning neither to the right nor left, made straight for **Kilcrea**, where they arrived about midnight. While the sacred remains were being consigned to the grave, a number of persons at a distance, who perhaps, were acting as sentinels in the different castles, beheld a strange and wonderful light radiating from the convent and adjoining grounds. Having afterwards heard of the death of this holy man, and that he was being buried just then, they were convinced that the signs in the heavens which they had seen, proceeded from no natural cause, but were the work of the Most High, declaring the sanctity of His servant.


{journal issue 6:3}


---

p.65


**Cork**
--------


The Convent of **Cork** was situated in the northern suburb of the city. It was sometimes called the Convent of **Shandon**, from a castle of that name belonging to **Viscount Barry**, which stood close at hand. This nobleman was the founder.[46](javascript:footNote('T300002-002/note046.html'))


---

p.66



 
It is at present inhabited by an English Protestant, who has erected a dwelling house within the precincts. All the buildings, except the walls of the church, have been knocked down, and are now a heap of ruins. A salmon weir in the river to the west of the city belonged to the convent. For some years past the friars have lived in the city itself, in a rented house, where they labour assiduously, in the things which are of God, according to the circumstances of the times. I know nothing regarding the antiquity or foundation of this convent.


Youghal
-------


The Convent of **Youghal**, in the sea-port town of that name, in the County of **Cork** and the Diocese of **Cloyne**, was founded by **Lord Fitzgerald**, from whom are descended the illustrious Earls of Desmond and the other **Geraldines** of Munster.


It is said to be one of the oldest, if not in fact, the most ancient in the Province. I cannot find, however, the date of its foundation.[47](javascript:footNote('T300002-002/note047.html')) It was among the most flourishing of our convents, and our brethren dwelt there in security, under the protection of the **Geraldines** till about 1583. But when, as happened, at that time, their power was broken, and the success of the heretics assured, the sacred pile was profaned 



---

p.67



reduced to ruins, while the friars were expelled, or crowned with martyrdoms. In the year 1596[48](javascript:footNote('T300002-002/note048.html')) (if my information regarding the date be correct) Fr. Daniel O'Doilean[49](javascript:footNote('T300002-002/note049.html')) was put to the torture, which he bore with wonderful fortitude. Captain Dundall with his troop by orders of the **Viceroy, Lord Arthur Grey**, subjected him to the cruellest torments. They dragged him to Trinity Gate, as it is called, and there having tied his arms behind his back, and fastened heavy stones to his feet, drew him up three times to the top of the tower, where they left him hanging in the air on each occasion. At length after many insults and tortures he was suspended by the feet with his head downwards, at the mill near the convent. He was left in this position for a long time. In all his sufferings he never uttered an impatient word but like a good Christian, recited prayers without ceasing, sometimes aloud, at other times in a low voice. Finally the soldiers were ordered to shoot him, and he was placed as a target, at which they might practice. That his agony might be the longer and more cruel it was agreed that they were to aim at the less vital parts of the body, and carefully avoid striking the head or heart. Having been wounded in many places, one of the company, moved by a grim compassion, loaded his gun with two balls, and shot him through the heart. Thus he passed away, crowned by a glorious martyrdom, on the 22nd of April in the year aforesaid.[50](javascript:footNote('T300002-002/note050.html')) Here also, near the right hand side of the High Altar, rest, according to tradition, the remains of a holy friar who worked many miracles.


The whole convent, except the walls of the church and some of the out-offices, is now in ruins. After the suppression of the monasteries certain Englishmen took up their abode there, one after another, profaned the house of God, by forcibly seizing upon it, and converting it to secular purposes. But some of them escaped the visitation of Divine Providence. Some were disturbed by visitations, others were even beaten with whips and bludgeons, while not a few were overtaken by a premature



---

p.68



death. And poverty, famine, and evils of various sorts fell upon those who had been wealthy, and who had dared to make the sacred spot their dwelling-place. All were compelled to fly from the place, and taught by their sufferings confessed that the hands of God and St. Francis were all that had happened to them.


Some silver chalices which belonged to this convent are still in existence and I have seen them in possession of the old Syndic of this place. This is detailed more fully in the Registry of the Province. There are also some books, especially a large **Graduale**, complete for the year which is very beautiful. All the others have perished, I have been told by an old father who was professed here, and who survives to the present day, that many of the moveables belonging to this convent were transferred to the castle of **Dromana** for safety, and that chalices, various ornaments, reliquaries, and the great cross of cold which was purchased for the friars by Lord James ... are preserved there. The old father said that it would be well to make an effort to recover them, but I fear it would be in vain.


{journal issue 6:4}


---

p.97


**Galbally-Aherlagh**
---------------------


This convent is situated in a country town in the diocese of **Emly**. I know nothing regarding its foundation,[51](javascript:footNote('T300002-002/note051.html')) antiquity, except the following remarkable occurrence. In 1570 when the **Viceroy, Lord Henry Sydney**, was making incursions through this district three of our friars suffered martyrdom at **Galbally**. One of them was a priest called **Dermot O'Mulroney**. I have been unable to discover the names of the others. He had fled with his companions from that country convent to **Clonmel**, to escape the fury of the 



---

p.98



persecution then raging. After a short stay he resolved to retrace his steps, God, perhaps, so disposing that he might gain the palm of martyrdom. He returned therefore to his convent, believing he could do so in safety. One day the English soldiers appeared. So sudden was the raid that all means of flight were cut off. **Father O'Mulroney** and his two companions took refuge in the bell-tower, and drew up the portable ladder after them. The soldiers determined to burn the church and tower, and applied fire to them for the purpose. To prevent this sacrilege the holy man came down of his own accord. He lowered the ladder, and placing his foot on the first step, fortified himself with the sign of the Cross. He then commenced to recite the Psalm ‘Misereri Mei’ as he descend. The soldiers, in their fury, received him with blows and wounds, and finally struck off his head. Then was seen this miracle. Not a drop of blood flowed from the body from which the head had been severed. The soldiers astonished at the marvel, hacked the body to pieces, but failed to force the smallest quantity of blood from the wounds. I could obtain no details of the death of the other two beyond the fact of their martyrdom. This convent is now in ruins the walls alone standing.


**Buttevant**
-------------


The convent of **Buttevant**, or **Kilnamulla**, as it is called in Irish, was founded by **Lord Viscount de Barry**.[52](javascript:footNote('T300002-002/note052.html')) How long since I do not know. The church, which still stands is large. It is roofed with pieces of wood, shaped like tiles, and contains the burial places of many of the nobility. The buildings though ample in size, were not well proportioned. Of its records, which must have contained many entries worthy of note, I have no information. At present two friars live in the town, who assist at funerals. They dare not take up their residence at the convent, because **Lord John de Barry**, who 



---

p.99



holds it from the king, is bound by the heretics, under a heavy fine, to prevent them from occupying it. He is a Catholic, and well disposed towards us, so far as it is possible for him. **Buttevant** is on the high way from Cork to Limerick. It is about equally distant from both. It was formerly a large town, but is now much decayed. About half-ways farther towards Limerick and within the limits of the district attached to the convent of that city, is **Killmallock**. Here two martyrs of our Order, the Most Rev. **Lord and Father Brother Patrick O'Healy, Bishop of **Mayo****, and **Brother O'Rourke**, of the illustrious family of the Princes of Brefny, entered upon a glorious fight for the Faith, and bore away the palm of victory. **Gonzaga** speaks of them in his work on the rise and progress of the Seraphic Institute. A relation of their martyrdom is also given in the fourth book of the French Chronicles of the Order. I will pass on at present, as I intend to write a detailed account of their lives when I have collected the necessary information. They suffered in 1578, under **William Drury, Viceroy of **Ireland****.


**Nenagh**
----------


The convent is situated in the diocese of **Killaloe** and territory of **Ormond**. The town of **Nenagh** belonged in ancient times to the **O'Kennedys**, who are believed to have been the founders.[53](javascript:footNote('T300002-002/note053.html')) It is now in possession of the Earls of **Ormond**. Nothing remains of the building but the walls. This is one of the convents which never accepted the reform, and so remained under the jurisdiction of the Conventuals until the suppression; on this account some property was attached to it. I have no information regarding its former inmates. Its great antiquity may be inferred from the fact that it is mentioned by **Bartholomew de Pisis** in his work entitled Liber Conformitatum. It was then the head of the Custody to which it gave its name.[54](javascript:footNote('T300002-002/note054.html')) Almost all the inhabitants of the 



---

p.100



surrounding country are good and generous Catholics, as I know by experienced, for I have sometimes preached among them.


**Roscrea**
-----------


The convent of **Roscrea** is also in the diocese of **Killaloe** and territory of **Ely**. It was founded little more than hundred years ago by **Lord Mulrony O'Carroll**, called the Great, a powerful and religious man. The record of the foundation was inscribed on a marble block, inserted in one side of cloister.[55](javascript:footNote('T300002-002/note055.html')) I have at present no certain remembrance of the date, for I had no intention of writing these sketches when I was there. The roofs of all the buildings have fallen in, but the walls still stand, and some panes of glass remain in the windows. The convent, though small, was elegantly proportioned, and could be easily rebuilt. The country round is rich and fertile and ‘the harvest is great indeed, but the labourers few.’


One of the friars who were professed there, lives to this day. At the time of the Suppression the convent was occupied by the Conventuals, some of whom fell away. Among them was one **Teig Daly**, who fled to Limerick, resolving to betake himself across the seas but was captured before he could effect his purpose. When put to the question, he stood firm in the Confession of the Faith, and rejected life and the many rewards offered to him if he would join himself to the heretics, preferring rather a glorious death. ‘Thus being made perfect in a short space, he fulfilled a long time.’ I do not know under whom he suffered or in what year. The Brother was unable to give me these particulars.[56](javascript:footNote('T300002-002/note056.html')) This same Brother was the companion of the holy martyr in his flight and imprisonment. He was then a young priest, and very simple-minded.



---

p.101



When danger presented itself he abandoned his role, and having received some gifts, apostatized from the Order, and thus obtained his temporal liberty. Having returned to his native place, he settled down to a secular life in the neighbourhood of his former convent. Here he lived till 1611. In that year I was Vicar Provincial, and was preaching during Lent in that district. I often visited a place of pious pilgrimage, just a mile from the convent called ‘The Island of the Living’,[57](javascript:footNote('T300002-002/note057.html')) for the purpose of exhorting, as far as some lay, the people assembled there, to repentance. One day this Brother, now an old man, approached me. I did not know him even by appearance. He related the circumstances of his life, and humbly besought me to receive him again into the bosom of the Order. Having made inquiries, and found the matter to be as he said, I was touched with pity and appointed a certain time in which he was to come to me. I kept him with me some days, and then sent him to one of our convents, where he might spend the remainder of his life with the brethren, and do penance for his sins. I did wish him however, to make profession of the rule according to the constitutions of the Observantines, unless perhaps, on the approach of death should he so desire. He still survives and I hope his death will be better than the life he led such a length of time.


{journal issue 6:5}


---

p.129


**Cashel**
----------


This convent is situated in the metropolitan city of **Cashel**, but outside the walls. A strong fence surrounds the grounds on every side. It was formerly occupied by the Conventuals, who possessed some wood lands and other property. And was commonly called **Hackett's Monastery**. I am not aware of the reason, nor have I been able to ascertain the name of the founder, or the date of foundation.[58](javascript:footNote('T300002-002/note058.html'))


The street within the city, which leads towards the convent, was known by the name of Friar-street, perhaps because all that ground, or the greater portion of it, as it is generally believed



---

p.130



belonged to the friars. A great number have burial places in the precincts, and some of the monuments are of polished marble. I have utterly failed in my attempt to learn anything of the friars, who formerly occupied the place. All the roofs have fallen in, through the decay of time. The walls are still standing. The convent was not very well built, except the church, which was of ample size, though of simple architectural style. The great aqueduct by which the water is brought into the city, from a distance of two miles, is said to have been constructed by the friars. For the truth of this I cannot vouch, but vestiges of the channels by which the water entered the monastery may yet by seen in some of the out-offices.


A Catholic named Cooney, who is nephew to the Archbishop,[59](javascript:footNote('T300002-002/note059.html')) has at present possession of the convent. His father, **Denis Cooney**, bought it from a person who held it without any just title. He was a wealthy man, and left a rich inheritance to his son, who has so mismanaged affairs that he is now poor and needy. However, thanks be to God, he remains a Catholic, and a man of good character. The archbishop himself, in conversation with me on this matter, expressed his decided conviction that the poverty had fallen upon him because he held possession of the friars' property, and this although he does so without scruple of conscience, and therefore it may be without guilt before God. For this reason the Archbishop requested me to condone our rights, and to allow him to keep possession of the place so long as it remained possible for us to occupy it. I answered that as far as in me lay (I was then Provincial) I would willingly forego our claim, and grant the required permission, but the dominion of our property was vested in the Holy Roman Church, and not in ourselves, and that, therefore, I could do nothing. There was, however, I added, a Syndic appointed for us, who had authority from the Apostolic See in such matters, and I would, as a mark of respect for the Archbishop, recommend him, not in an authorative way, but as an act of charity, to consent to this application 



---

p.131



on the following conditions — that Cooney himself should apply for such consent; that he should renounce the usurped title by which he now held the grounds; and that he should give security that he would not, by himself or others, directly or indirectly, seek to hinder us from enjoying full possession of the monastery and all its appurtenances, whenever the Royal Authority should so permit. I have not yet seen any petition from Cooney, and suspect, not without sufficient reason, that he has been inducted by other ecclesiastics to refuse these conditions, and to rest content with a dispensation from the Jesuits or other who lay claim to this privilege. For faculties have been given viva voce to certain person in Ireland, for the salvation of souls and to allay scruples of conscience, to dispense, during the schism, with those who hold ecclesiastical property, on the condition of their distributing each year, in pious uses, a certain amount of alms, according to the judgement of their confessor. There are prudent men who consider that this confession holds good only when the true owners, or their representatives are unable themselves to dispense of their property, and that in such cases the alms is to be expanded in their use and support. But there are others, who having nothing of their own to lose, are more liberal in disposing of the goods of others, and extend this faculty to the Episcopal and Parochial property, to the possessions of Abbeys, no matter of what dignity, and of monasteries, even when the true owners are present, and enter their protest. So some think, but I hold to the former opinion.


**Clonmel**
-----------


The convent of **Clonmel**, in the diocese of **Waterford** and **Lismore**, occupies a delightful position on the bank of the **Suir**, in an angle formed by the walls. The Earl of Desmond is said to have been the founder but the citizens claim that honour for themselves. At the dissolution of the monasteries the Earl of Ormond obtained possession of the convent and buildings belonging to it, while the church, cemetery, and sacristy were granted to the citizens. The church is still in good repair, and holds the burial places of many illustrious personages.



---

p.132



Among others that of the Baron of Cahir, whose monument, constructed of marble, and embellished with images and statues, rises high in the centre of the choir. In my time a heretic, who held the office of magistrate in the town, and who was an notorious priest hunter, selected a burial-place for himself in the church, and was actually interred beside the seat of the priest and sacred ministers, close to the high altar. Certain Jesuits and other ecclesiasts residing in the town were consenting parties to this and connived at the profanation. Even the friars made no protest, being prevented, from the machinations of the others. Thus through their carelessness the sacred place, which had hitherto escaped pollution, was desecrated. For they permitted this burial to take place, or, at least, as they themselves confess, remained silent, fearing a great evil, whereas if they had spoken even once it would not have been done. When I was on my *visitation* of the Province in 1615, I had the body exhumed by night, and removed to consecrated ground. I then purified the place with *Holy Water*, having first sought permission from the Archbishop.[60](javascript:footNote('T300002-002/note060.html'))


The church is much frequented by the citizen, who there meet in prayer. On Sundays and festivals the magistrates, as well as the people assemble with great devotion, and make the *Station*, as they call it, when offerings or alms are contributed for the souls of the dead. These are received by persons appointed for the purpose who afterwards expend them in the preservation of the church buildings, and in support of the priests and the poor. This custom has existed from time immemorial, but the distribution of the portion of the offerings among the priests and the poor is believed to have commenced with the introduction of the Heresy, for before that time the clergy had property of their own and even now it is given them in a private way. It is therefore easy of belief that this pious custom was originally instituted for the purpose of keeping the conventual buildings in repair or for the benefit of the friars themselves. This is the reason why these 



---

p.133



other ecclesiastics are unwilling to have the Franciscans take up again their residence in the town. For twice, in my recollection, members of the Order were appointed to **Clonmel**, and were refused admittance by the citizens, acting, it is thought, under their influence. The Jesuits have even alleged that they had obtained a grant of the convent from the Pope, but this attempt has been frustrated, and will be frustrated again if renewed.


It is thought with much probability that all the buildings from **Kilsheelan Street**, as it is called, to the way known by name of **Suir-Quay-Gate-Street**, belonged to the convent, and that the secular houses along these streets were built by the permission of the friars. This can be reasonably inferred from the position of the houses round the convent; also from the fact that some of the workshops of the monastery, as the bakery and such like, are found among these buildings. Again, the foundation deed of one of the houses which overlooks the cemetery, contains a clause guaranteeing free access and passing from the street to the cemetery and monastery; moreover, these houses have neither garden or court-yards, but stand round the precincts of the monastery between the streets and the convent grounds.[61](javascript:footNote('T300002-002/note061.html')) The mill at the gate and the bakery close by also formed part of the possession of the friars. These were called the Earl's mill and fishery. The large house near the convent, known by the name of the **Earl's Court**,[62](javascript:footNote('T300002-002/note062.html')) is also supposed to have been their property. For it



---

p.134



was customary among the Irish nobles to erect edifices of this sort as places of retreat, within the bounds of monasteries of which they were the founders, and hand them over to the friars, that they might be always kept in the readiness for their reception. Some, however say that this house never belonged to the monastery.


All the buildings except those mentioned above, as being in possession of the citizens, and the cloister, have fallen into ruin. The **Earl of **Ormond**** has put in repair, a rather small portion of what was formerly the infirmary, which he has for a dwelling-house with the garden adjoining. This has fallen to the share of **Helen de Barry**, widow of the late Earl of Ormond, and now married to **Sir Thomas Somerset**. I went to her with the request that she would bestow the place on the friars, but she refused to hear me, acting it may be on some such opinion, as I have alluded to when treating of **Cashel**. Mass is sometimes celebrated and sermons preached in the church. A citizen, notwithstanding my opposition, has constructed a burial place for himself in one of the chapels, in the very spot where stood a wooden Altar, on which I have often seen the holy sacrifice offered. I promised to keep fast memory of this, that in happier times the brethren may know what ought to be done.


A statue of St. Francis was preserved in the sacristy for a long time after the destruction of the images in the church. It was remarked, and proved by many miracles, that if anyone swore falsely, by St. Francis, in presence of this statue, God immediately made known the truth by some sign. I heard this from many trustworthy persons. A certain matron of **Clonmel** made oath before me that she was present when a women suspected of having stolen some article of dress, was brought before the statue, and there swore the charge was false. At that moment it dropped from her in the sight of all the by-standers. Repenting of her theft and perjury she confessed her guilt, and publicly declared that she had concealed the garment in a place far distant, and that it was only by the Divine Power that it could have been carried hither.




---

p.135


I have no information regarding the friars of **Clonmel**, except that I have read in an ancient manuscript that they took possession of the convent in 1269. A priest named Maurice, who was put to death for the faith by the heretics in **Clonmel** in 1589, was interred here. His relics were placed at the back of the Altar.


{journal issue 6:6}


---

p.161


**Carrig-on-Suir**
------------------


The convent was built near the river **Suir**. On the opposite bank stands the town of **Carraig-on-Suir**, which contains the chief residence of the Earl of Ormond. It is said, on what authority I know not, that this house of the Earl was erected on the monastery of St. Clare. Our convent is on the other side of the river, and was never entirely finished. At first the friars lived in a castle belonging to **James Butler, the Earl of **Ormond****, who received the title from Edward III, King of England, in 1328. He granted this residence to the Conventual Franciscans in 1336. They entered into possession that same year, on the feast of SS. Peter and Paul. **Brother Stephen de Barry** was then Provincial, **Brother William Naish**, Custos, and **Brother John Glya**, Guardian, The last was the author of the Chronicle[63](javascript:footNote('T300002-002/note063.html')) which bears his



---

p.162



name, and from which I have taken the above particulars. The friars built a church, dormitory, and cloister which were of no great size. The other buildings were never completed. The tower[64](javascript:footNote('T300002-002/note064.html')) of the ancient castle still stands. Some fields in the neighbourhood belonged to the convent, but now all have fallen into the hands of the Earl of Ormond.


**Waterford**
-------------


The convent of **Waterford** is situated near the wharf, where the ships are moored. The church is still intact, and it is the burial place of many illustrious families. Mass is sometimes celebrated within the walls and sermons delivered. But the grounds which once surrounded the convent, and the garden are sadly changed, and the solitude devoted, in former days, to religious contemplation, has become the most densely populated portion of the city. The monastic buildings have been turned into secular purposes, the gardens cut up into streets, and houses erected on all sides. The owner of these houses are Catholics, yet they have never sought our permission to hold them. Perhaps, because they have been told by other ecclesiastics that they could do so with a safe conscience.


Some citizens have raised a superstructure in the church extending over all the nave and adjoining chapel. Here they have established an asylum for the poor, in which sixty old and decrepit people, unable to earn a living, have beds. The building is divided into two distinct parts, one for the men and the other for the women. Alms for their support is collected through the city. It is called the Hospital of the Holy Ghost ...[65](javascript:footNote('T300002-002/note065.html')) Numbers of the citizens visit the Asylum on Sundays and festivals. They make offerings and supports as I have described when treating of **Clonmel**. In **Waterford** however, all the alms is expended on the poor. I do not know if this custom existed before the institution of the Hospital.


At present a few of the friars live in the city, in lodgings, as best they may. The inhabitants, who belong to **Waterford** by 



---

p.163



birth, are pious and devout, and generous and well-disposed towards us. They are politic and shrewd in their conduct, but withal steadfast in the Faith.


I do not know when the convent was built, nor who was the founder, but I found the following words in the fragment of a MS. — ‘At the right-hand corner of the High Altar is the tomb of **Sir Hugh Purcell, Knight**, who was the founder of this convent.’This is not entirely conclusive. He may have been only a benefactor, nor is the day or year given.[66](javascript:footNote('T300002-002/note066.html')) It is probable that Brother Nicholas[67](javascript:footNote('T300002-002/note067.html')) of **Gauthforda**, who foretold his death to his brethren, as **Pisanus** related in his Liber Conformitatum, rests here. We may also conclude that this is the ancient convent which the same **Pisanus** calls **Vasordia**, and which he says belonged to the custody of **Cashel**; for the corrupt forms, which the names of places assume among foreigners, do not change or multiply the places themselves.














