

A Discovery of the true causes why Ireland was never entirely subdued (...)


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Discovery of the true causes why Ireland was never entirely subdued (...)
===========================================================================


Author: Sir John Davies
-----------------------


### File Description

Henry MorleyElectronic edition compiled by Beatrix Färber

Funded by University College, Cork, School of History 1. First draft.Extent of text: 45150 words#### Publication


CELT: Corpus of Electronic Texts: a Department of History Project at University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2016) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E610003Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Selected further reading**2. Richard Butler (ed), The Annals of Ireland. By Friar John Clyn, of the Convent of Friars Minors, Kilkenny; and Thady Dowling, Chancellor of Leighlin. Together with the Annals of Ross (Dublin 1849). Online at CELT. A new edition and translation was published by Bernadette Williams, The Annals of Ireland by Friar John Clyn (Dublin 2007).
3. Patrick Baron Finglas of Westpalstown, Discourse of the Decay of Ireland (c. 1534?) [=Of the Getting of Ireland and of the Decay of same, printed in W. Harris, Hibernica (Dublin 1747).]
4. Sir John Davies, A Discovery of the True Causes Why Ireland Was Never Entirely Subdued [and] Brought Under Obedience of the Crown of England Until the Beginning of His Majesty's Happy Reign, ed. James P. Meyers (London, 1612;Washington, D.C.: 1969). [A critical edition].
5. James L. Sanderson, Sir John Davies. (Boston 1975).
6. Hans S. Pawlisch, "Sir John Davies, the Ancient Constitution, and the Civil Law", Historical Journal 23 (1980): 689–702.
7. Hans S. Pawlisch, Sir John Davies and the Conquest of Ireland: A Study in Legal Imperialism (Cambridge 1985).
8. James P. Myers, "Early English Colonial Experience in Ireland: Captain Thomas Lee and Sir John Davies", Éire-Ireland 23 (1988): 8–21.
9. Hiram Morgan (ed.), Sir John Davies, Of the Lawes of Irelande, The Irish Jurist 31 (1995-96) 307–312. Online at CELT.
10. Clare Carroll, Vincent Carey (eds), Solon his Follie, or, A politique discourse touching the reformation of common-weales conquered, declined or corrupted (New York 1996).
11. Steven G. Ellis, Ireland in the Age of the Tudors, 1447–1603: English Expansion and the End of Gaelic Rule (Harlow 1998).
12. Eugene Flanagan, "The Anatomy of Jacobean Ireland: Captain Barnaby Rich, Sir John Davies and the Failure of Reform", in: Political Ideology in Ireland, 1541–1641, ed. Hiram Morgan (Dublin 1999) 158–80.
13. D. Alan Orr, "From a View to a Discovery: Edmund Spenser, Sir John Davies, and the Defects of Law in the Realm of Ireland", Canadian Journal of History 38 (2003): 395–408.
14. Jean R. Brink, "Sir John Davies: Lawyer and Poet", in: Ireland in the Renaissance, c. 1540–1660, ed. Thomas Herron and Michael Potterton (Dublin 2007) 88–104.
15. Valerie McGowan-Doyle, The Book of Howth: Elizabethan Conquest and the Old English (Cork 2011).
16. D. Alan Orr, "Sir John Davies's Agrarian Law for Ireland", Journal of the History of Ideas, 75:1 (January 2014) 91–112.
**The edition used for the digital edition**2. **Henry Morley**, Sir John Davies A Discovery of the true causes why Ireland was never entirely subdued nor brought under obedience of the Crown of England until the Beginning of His Majesty's happy Reign (...) 1612 in Ireland under Elizabeth and James the First. , London, Routledge (1890) page 217–342

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Editorial Declaration


##### Correction


Text has been checked and proof-read once.


##### Normalization


The electronic text represents the edited text. Typographical errors are marked corr sic="" resp="BF". 


##### Quotation


There are no quotations.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break have been placed on the line on which they start.


##### Segmentation


div0=the whole text.


##### Interpretation


A small number of personal names and terms has been tagged. Words and phrases in languages other than English have been tagged.


### Profile Description


Created: (1612) #### Use of language


##### Language: [EN] The text is in seventeenth-century English, but has been modernized. (Some 3rd p. sing. forms in -eth occur.)


##### Language: [LA] Many phrases and quotations are in Latin.


##### Language: [FR] A number of words is in French.


##### Language: [GA] One word is an anglicized Irish.


##### Language: [OFR] A number of quotstions is in Old French.


##### Language: [IT] One phrase is in Italian.


### Revision History


* (2016-12-07) Beatrix Färber (ed.)

* SGML and HTML files created.
* (2016-11-07) Beatrix Färber (ed.)

* File proofed (2), TEI header constructed; file parsed.
* (2016-10-28) Beatrix Färber (ed.)

* File proofed (1); structural and basic content markup applied.
* (2016-10-27) Beatrix Färber (capture)

* Data capture.




---


#### Corpus of Electronic Texts Edition: E610003


### A Discovery of the true causes why Ireland was never entirely subdued (...): Author: Sir John Davies




---

p.217


During the time of my service in Ireland, which began in the first year of His Majesty's reign, I have visited all the provinces of that kingdom in sundry journeys and circuits; wherein I have observed the good temperature of the air; the fruitfulness of the soil; the pleasant and commodious seats for habitation; the safe and large ports and havens lying open for traffic into all the west parts of the world; the long inlets of many navigable rivers and so many great lakes and fresh ponds within the land, as the like are not to be seen in any part of Europe; the rich fishings and wild-fowl of all kinds; and lastly, the bodies and minds of the people endued with extraordinary abilities of nature. The observation whereof hath bred in me some curiosity to consider what were the true causes why this kingdom, whereof our kings of England have borne the title of sovereign lords for the space of four hundred and odd years, a period of time wherein divers great monarchies have risen from barbarism to civility, and fallen again to ruin, was not in all that space of time thoroughly subdued and reduced to obedience of the 



---

p.218




Crown of England, although there hath been almost a continual war between the English and the Irish; and why the manners of the mere[1](javascript:footNote('E610003/note001.html'))Irish are so little altered since the days of King Henry the Second, as appeareth by the description made by Giraldus Cambrensis, who lived and wrote in that time, albeit there have been since that time so many English colonies planted in Ireland as that, if the people were numbered at this day by the poll, such as are descended of English race would be found more in number than the ancient natives.


And, truly, upon consideration of the conduct and passage of affairs in former times, I find that the state of England ought to be cleared of an imputation which a vulgar error hath cast upon it in one point; namely, that Ireland long since might have been subdued and reduced to civility if some statesmen in policy had not thought it more fit to continue that realm in barbarism. Doubtless this vulgar opinion or report hath no true ground, but did first arise either out of ignorance or out of malice. For it will appear by that which shall hereafter be laid down in this discourse, that ever since our nation had any footing in this land the state of England did earnestly desire, and did accordingly endeavour from time to time, to perfect the conquest of this kingdom, but that in every age there were found such impediments and defects in both realms as caused almost an impossibility that things should have been otherwise than they were.


The defects which hindered the perfection of the conquest of Ireland were of two kinds, and consisted, first, in the faint prosecution of the war, and next in the looseness of the civil government. For the husbandman must first break the land before it be made capable of good seed; and when it is thoroughly broken and manured, if he do not forthwith cast good seed into it, it will grow wild again and bear nothing but weeds. So a barbarous country must be first broken by a war before it will be 



---

p.219



 

capable of good government; and when it is fully subdued and conquered, if it be not well planted and governed after the conquest, it will eftsoons return to the former barbarism.


Touching the carriage of the martial affairs from the seventeenth year of King Henry the Second, when the first overture was made for the conquest of Ireland — I mean, the first after the Norman conquest of England — until the nine-and-thirtieth year of Queen Elizabeth, when that royal army was sent over to suppress Tyrone's rebellion, which made in the end an universal and absolute conquest of all the Irishry, it is most certain that the English forces sent hither or raised here from time to time were ever too weak to subdue or master so many warlike nations or septs of the Irish as did possess this island; and, besides their weakness, they were ill paid and worse governed. And if at any time there came over an army of competent strength and power, it did rather terrify than break and subdue this people, being ever broken and dissolved by some one accident or other before the perfection of the conquest.


For that I call a perfect conquest of a country which doth reduce all people thereof to the condition of subjects; and those I call subjects which are governed by the ordinary laws and magistrates of the sovereign. For though the Prince doth bear the title of sovereign lord of an entire country, as our kings did of all Ireland, yet if there be two-third parts of that country wherein he cannot punish treasons, murders, or thefts unless he send an army to do it; if the jurisdiction of his ordinary courts of justice doth not extend into those parts to protect the people from wrong and oppression; if he have no certain revenue, no escheats or forfeitures, out of the same, I cannot justly say that such a country is wholly conquered.


First, then, that we may indulge and discern whether the English forces in Ireland were at any time of sufficient strength to make a full and final conquest of that land, let us see what extraordinary 



---

p.220




armies have been transmitted out of England thither, and what ordinary forces have been maintained there, and what service they have performed from time to time since the seventeenth year of King Henry the Second.


In that year MacMurrough, Lord of Leinster, being oppressed by the Lords of Meath and Connaught and expelled out of his territory, moved King Henry the Second to invade Ireland, and made an overture unto him for the obtaining of the sovereign lordship thereof. The King refused to undertake the war himself, to avoid the charge, as King Henry the Seventh refused to undertake the discovery of the Indies for the same cause, but he gave license by his Letters Patents that such of his subjects might pass over into Ireland as would at their own charge become adventurers in that enterprise.


So as the first attempt to conquer this kingdom was but an adventure of a few private gentlemen. Fitzstephen and Fitzgerald first brake the ice with a party of three hundred and ninety men. The Earl Strongbow followed them with twelve hundred more, whose good success upon the sea-coasts of Leinster and Munster drew over the King in person the next year after, cum quingentis militibus, as Giraldus Carnbrensis reporteth, who was present in Ireland at that time; which, if they were but five hundred soldiers, seemeth too small a train for so great a Prince. But admit they were five hundred knights, yet because in those days every knight was not a commander of a regiment or company, but most of them served as private men, sometimes a hundred knights under a spear, as appeareth by the lists of the ancient armies, we cannot conjecture his army to have been so great as might suffice to conquer all Ireland, being divided into so many principalities, and having so many hydras' heads as it had at that time.


For, albeit Tacitus in the Life of Agricola doth report that Agricola, having subdued the greatest part of Great Britain, did 



---

p.221



 

signify to the Senate of Rome that he thought Ireland might also be conquered with one legion and a few aids, I make no doubt but that if he had attempted the conquest thereof with a far greater army he would have found himself deceived in his conjecture. For a barbarous country is not so easily conquered as a civil, whereof Caesar had experience in his wars against the Gauls, Germans, and Britons, who were subdued to the Roman Empire with far greater difficulty than the rich kingdoms of Asia. And, again, a country possessed with many petty lords and states is not so soon brought under entirely as an entire kingdom governed by one prince or monarch. And, therefore, the late King of Spain could sooner win the kingdom of Portugal than reduce the states of the Low Countries.


But let us see the success of King Henry the Second. Doubtless his expedition was such as he might have said with Caesar, ‘Veni, vidi, vici.’ For upon his first arrival his very presence, without drawing his sword, prevailed so much as all the petty kings or great lords within Leinster, Connaught and Munster submitted themselves unto him, promised to pay him tribute, and acknowledged him their chief and sovereign lord. Besides the better to assure this inconstant sea-nymph, who was so easily won, the Pope would needs give her unto him with a ring, conjugio jungam stabili, propriamque dicabo. But as the conquest was but slight and superficial, so the Pope's donation and the Irish submissions were but weak and fickle assurances. For, as the Pope had no more interest in this kingdom than he which offered to Christ all the kingdoms of the earth, so the Irish pretend that by their law a tanist might do no act that might bind his successor, But this was the best assurance he could get from so many strong nations of people with so weak a power; and yet he was so well pleased with this title of the lordship of Ireland as he placed it in his royal style before the Duchies of Normandy and Aquitaine. And so, being advertised of some stirs raised by his 



---

p.222




unnatural sons in England, within five months after his first arrival he departed out of Ireland without striking one blow or building one castle or planting one garrison among the Irish; neither left he behind him one true subject more than those he found there at his coming over, which were only the English adventurers spoken of before, who had gained the port towns in Leinster and Munster and possessed some scopes of land thereunto adjoining, partly by Strongbow's alliance with the Lord of Leinster and partly by plain invasion and conquest.


And this is that conquest of King Henry the Second so much spoken of by so many writers, which though it were in no other manner than is before expressed, yet is the entire conquest of all Ireland attributed unto him.


But the truth is, the conquest of Ireland was made piece and piece by slow steps and degrees, and by several attempts in several ages. There were sundry revolutions as well of the English fortunes as of the Irish, somewhiles one prevailing, somewhiles the other, and it was never brought to a full period till His Majesty that now is came to the crown.


As for King Henry the Second, he was far from obtaining that monarchy royal and true sovereignty which His Majesty who now reigneth hath over the Irish; for the Irish lords did only promise to become tributaries to King Henry the Second. And such as pay only tribute, though they be placed by Bodin in the first degree of subjection, are not properly subjects but sovereigns. For, though they be less and inferior unto the Prince to whom they pay tribute, yet they hold all other points of sovereignty; and having paid their tribute which they promised, to have their peace, they are quit of all other duties, as the same Bodin writeth. And therefore, though King Henry the Second had the title of sovereign lord over the Irish, yet did he not put those things in execution which are the true marks and differences of sovereignty.




---

p.223


For, to give laws unto a people, to institute magistrates and officers over them, to punish and pardon malefactors, to have the sole authority of making war and peace, and the like, are the true marks of sovereignty, which King Henry the Second had not in the Irish countries, but the Irish lords did still retain all these prerogatives to themselves.


For they governed their people by the Brehon law; they made their own magistrates and officers; they pardoned and punished all malefactors within their several countries; they made war and peace one with another without controlment; and this they did not only during the reign of King Henry the Second, but afterwards in all times, even until the reign of Queen Elizabeth. And it appeareth what manner of subjects these Irish lords were by the concord made between King Henry the Second and Roderick O'Connor, the Irish King of Connaught in the year 1175, which is recorded by Hoveden in this form: ‘Hic est finis et Concordia, inter Dominum regem Angliae Henricum, filium Imperatricis, et Rodoricum Regent Conactae, scilicet, quod Rex, etc. Angliae concessit praedicto Roderico Ligeo homini suo, ut sit Rex sub eo paratus ad servitium suum, ut homo suus, etc.’ And the commission whereby King Henry the Second made William Fitz-Adelme his Lieutenant of Ireland hath this direction: ‘Archi-episcopis, Episcopis, Regibus, Comitibus, Baronibus, et omnibus fidelibus suis in Hibernia, Salutem.’ Whereby it is manifest that he gave those Irish lords the title and style of kings.


King John likewise did grant divers charters to the King of Connaught, which remain in the Tower of London. And afterwards, in the time of King Henry the Third, we find in the Tower a grant made to the King of Thomond in these words: ‘Rex Regi Tosmond salutem. Concessimus vobis terram Tosmond quam prius tenuistis, per firmam centum et triginta marcarum; Tenendum de nobis usque ad aetatem nostram.’ And in the Pipe-Rolls 



---

p.224




remaining in Bremigham's Tower,[2](javascript:footNote('E610003/note002.html')) in the Castle of Dublin, upon sundry accounts of the seneschal of Ulster, when that earldom was in the King's hands, by reason of the minority of the Earl, the entry of all such charges as were made upon O'Neill for rent-beeves, or for aids towards the maintenance of the King's wars, are in this form: ‘Oneal Regulus 400 vaccas pro arreragio reddit; Oneal Regulus, 100 li. de Auxilio Domini Regis ad guerram suam in Wasconia sustinendam.’ And in one roll, the 36th of Henry the Third, ‘Oneale Rex, 100 li. de auxilio domini Regis ad guerram suam in Wallia sustinendam’ Which seemed strange to me, that the King's civil officer should give him that style upon record, unless he meant it in that sense as Maximilian the emperor did when speaking of his disobedient subjects. ‘The title,’ said he, ‘of Rex Regum doth more properly belong to me than to any mortal prince, for all my subjects do live as kings; they obey me in nothing, but do what they list.’ And truly in that sense these Irish lords might not unfitly be termed kings. But to speak in proper terms, we must say with the Latin poet, ‘Qui Rex est, Regem, Maxime non habeat.’ But touching these Irish kings, I will add this note out of an ancient manuscript, the Black-book of Christ Church in Dublin: ‘Isti Reges non fuerunt ordinati solemnitate alicuius ordinis, nec unctionis Sacramento, nec Jure haereditario, vel aliqua proprietatis successione, sed vi et armis quilibet Regnum suum obtinuit;’ and therefore they had no just cause to complain when a stronger king than themselves became a king and lord over them. But let us return to our purpose, and see the proceeding of the martial affairs.


King Henry the Second, being returned into England, gave the lordship of Ireland unto the Lord John, his youngest son, surnamed before that time Sans Terre; and the Pope, confirming 



---

p.225



 

that gift, sent him a crown of peacock's feathers, as Pope Clement the Eighth sent the feather of a phoenix, as he called it, to the traitor Tyrone. This young Prince, the King's son, being but twelve years of age, with a train of young noblemen and gentlemen, to the number of three hundred, but not with any main army, came over to take possession of his new patrimony; and being arrived at Waterford, divers Irish lords, who had submitted themselves to his father, came to perform the like duty to him. But that youthful company using them with scorn because their demeanours were but rude and barbarous, they went away much discontented, and raised a general rebellion against him; whereby it was made manifest that the submission of the Irish lords and the donation of the Pope were but slender and weak assurances for a kingdom.


Hereupon this young Lord was revoked and Sir John de Courcy sent over, not with the King's army, but with a company of voluntaries, in number four hundred or thereabout. With these he attempted the conquest of Ulster, and in four or five encounters did so beat the Irishry of that province as that he gained the maritime coasts thereof from the Boyne to the Bann, and thereupon was made Earl of Ulster. So as now the English had gotten good footing in all the provinces of Ireland; in the first three provinces of Leinster, Munster, and Connaught, part by the sword and part by submission and alliance; and, lastly, in Ulster by the invasion and victories of Sir John de Courcy.


From this time forward until the seventeenth year of King John, which was a space of more than thirty years, there was no army transmitted out of England to finish the conquest. Howbeit, in the meantime, the English adventurers and colonies already planted in Ireland did win much ground upon the Irish; namely, the Earl Strongbow, having married the daughter of MacMurrough, in Leinster; the Lacys in Meath; the Geraldines and other adventurers in Munster; the Audleys, Gernons, Clintons, 



---

p.226




Russells, and other voluntaries of Sir John de Courcy's retinue in Ulster; and the Bourkes, planted by William FitzAdelme, in Connaught. Yet were the English reputed but part owners of Ireland at this time, as appeareth by the commission of the Pope's Legate in the time of King Richard the First, whereby he had power to exercise his jurisdiction in Anglia, Wallia, ac illis Hibernia partibus, in quibus Johannes Moretonii Comes potestatem habet et dominium as it is recorded by Matthew Paris.


King John, in the twelfth year of his reign, came over again into Ireland, the stories of that time say with a great army, but the certain numbers are not recorded. Yet it is credible, in regard of the troubles wherewith this King was distressed in England, that this army was not of sufficient strength to make an entire conquest of Ireland; and if it had been of sufficient strength, yet did not the King stay a sufficient time to perform so great an action, for he came over in June and returned in September the same year. Howbeit, in that time the Irish lords for the most part submitted themselves to him, as they had done before to his father, which was but a mere mockery and imposture. For his back was no sooner turned but they returned to their former rebellion, and yet this was reputed a second conquest. And so this King, giving order for the building of some castles upon the borders of the English colonies, left behind him the Bishop of Norwich for the civil government of the land, but he left no standing army to prosecute the conquest; only the English colonies which were already planted were left to themselves to maintain what they had got, and to gain more if they could.


The personal presence of these two great Princes, King Henry the Second and King John, though they performed no great thing with their armies, gave such countenance to the English colonies, which increased daily by the coming over of new voluntaries and adventurers out of England, as that they enlarged their 



---

p.227



 

territories very much. Howbeit, after this time the Kings of England, either because they presumed that the English colonies were strong enough to root out the Irish by degrees, or else because they were diverted or disabled otherwise (as shall be declared hereafter), never sent over any royal army or any numbers of men worthy to be called an army into Ireland until the thirty-sixth year of King Edward the Third, when Lionel, Duke of Clarence, the King's second son, having married the daughter and heir of Ulster, was sent over with an extraordinary power in respect of the time (for the wars betwixt England and France were then in their heat), as well to recover his earldom of Ulster, which was then overrun and possessed by the Irish, as to reform the English colonies, which were become strangely degenerate throughout the whole kingdom.


For though King Henry the Third gave the whole land of Ireland to Edward the Prince, his eldest son and his heirs, Ita quod non separetur a corona Angliae; whereupon it was styled the land of the Lord Edward, the King's eldest son, and all the officers of the land were called the officers of Edward, Lord of Ireland; and though this Edward was one of the most active Princes that ever lived in England, yet did he not, either in the lifetime of his father or during his own reign, come over in person or transmit any army into Ireland; but, on the other side, he drew sundry aids and supplies of men out of Ireland to serve him in his wars in Scotland, Wales, and Gascogne. And again, though King Edward the Second sent over Piers Gaveston with a great retinue, it was never intended he should perfect the conquest of Ireland, for the King could not want his company so long a time as must have been spent in the finishing of so tedious a work.


So then, in all that space of time, between the twelfth year of King John and the thirty-sixth year of King Edward the Third, containing a hundred and fifty years or thereabouts, although 


---

p.228




there were a continual bordering war between the English and the Irish, there came no royal army out of England to make an end of the war. But the chief governors of the realm, who were at first called Custodes Hiberniae and afterwards Lords-Justices, and the English lords who had gotten so great possessions and royalties, as that they presumed to make war and peace without direction from the State, did leave all their forces within the land. But those forces were weakly supplied and ill-governed, as I said before — weakly supplied with men and money, and governed with the worst discipline that ever was seen among men of war. And no marvel, for it is an infallible rule that an army ill-paid is ever unruly and ill-governed. The standing forces here were seldom or never reinforced out of England, and such as were either sent from thence or raised here did commonly do more hurt and damage to the English subjects than to the Irish enemies by their continual cess and extortion; which mischief did arise by reason that little or no treasure was sent out of England to pay the soldiers' wages. Only the King's revenue in Ireland was spent, and wholly spent, in the public service; and therefore in all the ancient Pipe-Rolls in the times of Henry the Third, Edward the First, Edward the Second, and Edward the Third, between the receipts and allowances there is this entry, ‘In Thesauro nihil.’ For the officers of the State and the army spent all, so as there was no surplusage of treasure, and yet that all was not sufficient. For in default of the King's pay, as well the ordinary forces which stood continually as the extraordinary, which were levied by the chief governor, upon journeys and general hostings, were for the most part laid upon the poor subject descended of English race; howbeit this burden was in some measure tolerable in the time of King Henry the Third and King Edward the First; but in the time of King Edward the Second, Maurice Fitz-Thomas of Desmond, being chief commander of the army against the Scots, began that wicked extortion of coigny and livery and pay; that is, 



---

p.229



 

he and his army took horse-meat and man's-meat and money at their pleasure, without any ticket or any other satisfaction. And this was after that time the general fault of all the governors and commanders of the army in this land. Only the golden saying of Sir Thomas Rookesby, who was Justice in the thirtieth year of King Edward the Third, is recorded in all the annals of this kingdom, that he would eat in wooden dishes, but would pay for his meat gold and silver. Besides, the English colonies, being dispersed in every province of this kingdom, were enforced to keep continual guards upon the borders and marches round about them; which guards consisting of idle soldiers were likewise imposed as a continual burthen upon the poor English freeholders, whom they oppressed and impoverished in the same manner. And because the great English lords and captains had power to impose this charge when and where they pleased, many of the poor freeholders were glad to give unto those lords a great part of their lands, to hold the rest free from that extortion; and many others, not being able to endure that intolerable oppression, did utterly quit their freeholds and returned into England. By this means the English colonies grew poor and weak, though the English lords grew rich and mighty; for they placed Irish tenants upon the lands relinquished by the English; upon them they levied all Irish exactions; with them they married, and fostered, and made gossips; so as within one age the English, both lords and freeholders, became degenerate and mere Irish in their language, in their apparel, in their arms and manner of fight, and all other customs of life whatsoever.


By this it appeareth why the extortion of coigny and livery is called in the old statutes of Ireland a damnable custom, and the imposing and taking thereof made high treason. And it is said in an ancient Discourse of the Decay of Ireland *[By Baron Finglas of Wespalstown.]*, that though it were first invented in hell, yet if it had been used and practised there as it hath been in Ireland, it had long since destroyed 



---

p.230




the very kingdom of Beelzebub. In this manner was the war of Ireland carried before the coming over of Lionel Duke of Clarence.


This young Prince, being Earl of Ulster and Lord of Connaught in right of his wife, who was daughter and heir of the Lord William Bourke, the last Earl of Ulster of that family, slain by treachery at Knockfergus. was made the King's Lieutenant of Ireland, and sent over with an army in the thirty-sixth year of King Edward the Third; the roll and list of which army doth remain of record in the King's Remembrancer's Office in England, in the press, De Rebus tangentibus Hiberniam, and doth not contain above fifteen hundred men by the poll; which, because it differs somewhat from the manner of this age, both in respect of the command and the entertainment, I think it not impertinent to take a brief view thereof.


The Lord Lionel was General, and under him, Ralph Earl of Stafford, James Earl of Ormond, Sir John Carew, Bart, Sir William Winsore, and other knights were commanders.


The entertainment of the General upon his first arrival was but 6s. 8d. per diem for himself; for five knights, 2s. a-piece per diem; for sixty-four esquires, 1s. a-piece per diem; for seventy archers, 6d. a-piece per diem. But being shortly after created Duke of Clarence, which honour was conferred upon him being here in Ireland, his entertainment was raised to 13s. 4d. per diem for himself, and for eight knights 2s. a-piece per diem, with an increase of the numbers of his archers, viz., 360 archers on horseback out of Lancashire at 6d. a-piece per diem, and twenty-three archers out of Wales at 2d. a-piece per diem.


The Earl of Stafford's entertainment was, for himself, 6s. 8d. per diem; for a baronet, 4s. per diem; for seventeen knights, 2s. a-piece per diem; for seventy-eight esquires, 1s. a-piece per diem; for one hundred archers on horseback, 6d. a-piece per diem. Besides, he had the command of twenty-four archers out of 



---

p.231




Staffordshire, forty archers out of Worcestershire, and six archers out of Shropshire, at 4d. a-piece per diem.


The entertainment of James Earl of Ormond was, for himself, 4s. per diem; for two knights, 2s. a-piece per diem; for twenty-seven esquires, 1s. a-piece per diem; for twenty hobblers armed (the Irish horsemen were so called because they served on hobbies), 6d. a-piece per diem; and for twenty hobblers not armed, 4d a-piece per diem.


The entertainment of Sir John Carew, Bart., was, for himself, 43. per diem; for one knight, 23. per diem; for eight esquires, 1s. a-piece per diem; for ten archers on horseback, 6d. a-piece per diem.


The entertainment of Sir William Winsore, was, for himself, 2s. per diem; for two knights, 2s. a-piece per diem; for forty-nine squires, 1s. a-piece per diem; for six archers on horseback, 6d. a-piece per diem.


The like entertainments, ratably, were allowed to divers knights and gentlemen upon that list, for themselves and their several retinues, whereof some were greater and some less, as they themselves could raise them among their tenants and followers.


For in ancient times the King himself did not levy his armies by his own immediate authority or commission, but the lords and captains did by indenture covenant with the King to serve him in his wars with certain numbers of men for certain wages and entertainments, which they raised in greater or less numbers as they had favour or power with the people. This course hath been changed in later times upon good reason of State; for the barons and chief gentlemen of the realm, having power to use the King's prerogative in that point, became too popular, whereby they were enabled to raise forces even against the Crown itself, which since the statutes made for levying and mustering of 



---

p.232




soldiers by the King's special commission they cannot so easily perform, if they should forget their duties.


This Lord-Lieutenant, with this small army, performed no great service, and yet, upon his coming over, all men who had land in Ireland were by proclamation remanded back out of England thither, and both the clergy and laity of this land gave two years' profits of all their lands and tithes towards the maintenance of the war here; only he suppressed some rebels in Low Leinster and recovered the maritime parts of his earldom of Ulster. But his best service did consist in the well-governing of his army, and in holding that famous Parliament at Kilkenny wherein the extortion of the soldier and the degenerate manners of the English, briefly spoken of before, were discovered, and laws made to reform the same, which shall be declared more at large hereafter.


The next Lieutenant transmitted with any forces out of England was Sir William Winsore, who in the forty-seventh year of King Edward the Third undertook the custody, not the conquest, of this land, for now the English made rather a defensive than an invasive war, and withal to defray the whole charge of the kingdom for £11,213, 6s. 8d., as appeareth by the indenture between him and the King remaining of record in the Tower of London. But it appeareth by that which **Froissart** reporteth, that Sir William Winsore was so far from subduing the Irish as that himself reported that he could never have access to understand and know their countries, albeit he had spent more time in the service of Ireland than any Englishman then living.


And here I may well take occasion to show the vanity of that which is reported in the story of Walsingham touching the revenue of the Crown in Ireland in the time of King Edward the Third; for he, setting forth the state of things there in the time of King Richard the Second, writeth thus: ‘Cum Rex Anglia illustris, Edwardus tertius illic posuisset Bancum suum atque Judices, cum 



---

p.233




Scaccario, percepit inde ad Regalem Fiscum annuatim triginta millia librarum; modo propter absentiam ligeorum, et hostium potentiam, nihil inde venit; sed Rex per annos singulos, de suo marsupio, terra defensoribus soluit triginta millia marcarum, ad regni sui dedecus et fisci gravissimum detrimentum.’


If this writer had known that the King's Courts had been established in Ireland more than a hundred years before King Edward the Third was born, or had seen either the Parliament Rolls in England or the records of the receipts and issues in Ireland, he had not left this vain report to posterity. For both the Benches and the Exchequer were erected in the twelfth year of King John. And it is recorded in the Parliament Rolls of the twenty-first year of Edward the Third remaining in the Tower, that the Commons of England made petition that it might be inquired why the King received no benefit of his land of Ireland, considering he possessed more there than any of his ancestors had before him. Now, if the King at that time, when there were no standing forces maintained there, had received £30,000 yearly at his Exchequer in Ireland, he must needs have made profit by that land, considering that the whole charge of the kingdom in the forty-seventh year of Edward the Third, when the King did pay an army there, did amount to no more than £11,200 per annum, as appeareth by the contract of Sir William Winsore.


Besides, it is manifest by the Pipe-Rolls of that time, whereof many are yet preserved in Bremingham's Tower, and are of better credit than any monk's story, that during the reign of King Edward the Third the revenue of the Crown of Ireland, both certain and casual, did not rise unto 10,000 li. per annum, though the medium be taken of the best seven years that are to be found in that King's time. The like fable hath Holinshed touching the revenue of the earldom of Ulster, which, saith he, in the time of King Richard the Second was 30,000 marks by the year; whereas in truth, though the lordships of Connaught and Meath, 



---

p.234




which were then parcel of the inheritance of the Earl of Ulster, be added to the account, the revenue of that earldom came not to the third part of that he writeth. For the account of the profits of Ulster yet remaining in Bremingham's Tower, made by William Fitzwarren, seneschal and farmer of the lands in Ulster, seized into the King's hands after the death of Walter de Burgo, Earl of Ulster, from the fifth year of Edward the Third until the eighth year, do amount but to nine hundred and odd pounds, at what time the Irishry had not made so great an invasion upon the earldom of Ulster as they had done in the time of King Richard the Second.


As vain a thing it is that I have seen written in an ancient manuscript touching the customs of this realm in the time of King Edward the Third, that those duties in those days should yearly amount to 10,000 marks, which, by mine own search and view of the records here, I can justly control. For upon the late reducing of this ancient inheritance of the Crown, which had been detained in most of the port towns of this realm for the space of a hundred years and upwards, I took some pains, according to the duty of my place, to visit all the Pipe-Rolls wherein the accounts of customs are contained, and found those duties answered in every port for two hundred and fifty years together, but did not find that at any time they did exceed a thousand pounds per annum; and no marvel, for the subsidy of poundage was not then known and the greatest profit did arise by the cocquet of hides, for wool and wool-fells were ever of little value in this kingdom.[3](javascript:footNote('E610003/note003.html'))


But now, again, let us see how the martial affairs proceeded in Ireland. Sir William Winsore continued his government till the latter end of the reign of King Edward the Third, keeping, but not enlarging, the English borders.




---

p.235


In the beginning of the reign of King Richard the Second the State of England began to think of the recovery of Ireland; for then was the first statute made against absentees, commanding all such as had land in Ireland to return and reside thereupon upon pain to forfeit two-third parts of the profit thereof. Again, this King, before himself intended to pass over, committed the government of this realm to such great lords successively as he did most love and favour; first to the Earl of Oxford, his chief minion, whom he created Marquis of Dublin and Duke of Ireland; next to the Duke of Surrey, his half-brother; and, lastly, to the Lord Mortimer, Earl of March and Ulster, his cousin and heir-apparent.


Among the Patent-Rolls in the Tower the ninth year of Richard the Second we find five hundred men-at-arms at 1s. a-piece per diem, and a thousand archers at 6d. a-piece per diem, appointed for the Duke of Ireland, Super conquestu illius terrae per duos annos, for those are the words of that record; but for the other two Lieutenants, I do not find the certain numbers whereof their armies did consist. But certain it is that they were scarce able to defend the English borders, much less to reduce the whole island. For one of them, namely, the Earl of March, was himself slain upon the borders of Meath, for revenge of whose death the King himself made his second voyage into Ireland in the last year of his reign. For his first voyage in the eighteenth year of his reign, which was indeed a voyage royal, was made upon another motive and occasion, which was this. Upon the vacancy of the empire this King, having married the King of Bohemia's daughter, whereby he had great alliance in Germany, did, by his ambassadors, solicit the Princes-Electors to choose him Emperor; but another being elected and his ambassadors returned, he would needs know of them the cause of his repulse in that competition. They told him plainly that the Princes of Germany did not think him fit to command the empire, who was neither able to hold 



---

p.236




that which his ancestors had gained in France, nor to rule his insolent subjects in England, nor to master his rebellious people of Ireland. This was enough to kindle in the heart of a young Prince a desire to perform some great enterprise. And, therefore, finding it no fit time to attempt France, he resolved to finish the conquest of Ireland; and to that end he levied a mighty army, consisting of four thousand men-at-arms and thirty thousand archers, which was a sufficient power to have reduced the whole island if he had first broken the Irish with a war, and after established the English laws among them, and not have been satisfied with their light submissions only, wherewith in all ages they have mocked and abused the State of England. But the Irish lords, knowing this to be a sure policy to dissolve the forces which they were not able to resist for their ancestors had put the same trick and imposture upon King John and King Henry the Second as soon as the King was arrived with his army, which he brought over under St. Edward's banner, whose name was had in great veneration amongst the Irish, they all made offer to submit themselves. Whereupon the Lord Thomas Mowbray, Earl of Nottingham and Marshal of England, was authorised by special commission to receive the homages and oaths of fidelity of all the Irishry of Leinster. And the King himself having received humble letters from O'Neill, wherein he styleth himself Prince of the Irishry in Ulster, and yet acknowledgeth the King to be his sovereign lord, perpetuus Dominus Hiberniae, removed to Drogheda, to accept the like submissions from the Irish of Ulster. The men of Leinster, namely, M'Murrough, O'Byrne, O'Moore, O'Murrough, O'Nolan, and the chief of the Kinshelaghs, in an humble and solemn manner did their homages and made their oaths of fidelity to the Earl Marshal, laying aside their girdles, their skeins, and their caps, and falling down at his feet upon their knees, which when they had performed, the Earl gave unto each of them osculum pacis.




---

p.237


Besides, they were bound by several indentures, upon great pains to be paid to the Apostolic Chamber, not only to continue loyal subjects, but that by a certain day prefixed they and all their swordmen should clearly relinquish and give up unto the King and his successors all their lands and possessions which they held in Leinster, and taking with them only their movable goods, should serve him in his wars against his other rebels; in consideration whereof the King should give them pay and pensions during their lives, and bestow the inheritance of all such lands upon them as they should recover from the rebels in any other part of the realm. And thereupon a pension of eighty marks per annum was granted to Art' MacMurrough, chief of the Cavanaghs, the enrolment whereof I found in the White-book of the Exchequer here. And this was the effect of the service performed by the Earl-Marshal by virtue of his commission. The King in like manner received the submissions of the Lords of Ulster, namely, O'Neill, O'Hanlon, M'Donnel, M'Mahon, and others, who with the like humility and ceremony did homage and fealty to the King's own person. The words of O'Neill's homage as they are recorded are not unfit to be remembered: ‘Ego Nelanus Oneal Senior tam pro meipso, quam pro filiis meis, et tota Natione mea et Parentelis meis, et pro omnibus subditis meis devenio Ligeus homo vester, etc.’ And in the indenture between him and the King, he is not only bound to remain faithful to the Crown of England, but to restore the bonaght[4](javascript:footNote('E610003/note004.html')) of Ulster to the Earl of Ulster, as of right belonged to that earldom, and usurped among other things by the O'Neills.


These indentures and submissions, with many other of the same kind — for there was not a chieftain or head of an Irish sept but submitted himself in one form or other — the King himself caused to be enrolled and testified by a notary public, and delivered



---

p.238




the enrolments with his own hands to the Bishop of Salisbury, then Lord Treasurer of England, so as they have been preserved, and are now to be found in the office of the King's Remembrancer there.


With these humilities they satisfied the young King, and by their bowing and bending avoided the present storm, and so brake that army which was prepared to break them. For the King, having accepted their submissions, received them in osculo pacis, feasted them, and having given the honour of knighthood to divers of them, did break up and dissolve his army, and returned into England with much honour and small profit, saith **Froissart**. For though he had spent a huge mass of treasure in transporting his army, by the countenance whereof he drew on their submissions, yet did he not increase his revenue thereby one sterling pound, nor enlarged the English borders the breadth of one acre of land; neither did he extend the jurisdiction of his courts of justice one foot farther than the English colonies, wherein it was used and exercised before. Besides, he was no sooner returned into England but those Irish lords laid aside their masks of humility, and scorning the weak forces which the King had left behind him, began to infest the borders; in defence whereof the Lord Roger Mortimer, being then the King's Lieutenant and heir-apparent of the crown of England, was slain, as I said before. Whereupon the King, being moved with a just appetite of revenge, came over again in person, in the twenty-second year of his reign, with as potent an army as he had done before, with a full purpose to make a full conquest of Ireland. He landed at Waterford, and passed from thence to Dublin, through the waste countries of the Murroughs, Kinshelaghs, Cavanaghs, Byrnes, and Tooles. His great army was much distressed for want of victuals and carriages, so as he performed no memorable thing in that journey; only in the Cavanaghs' country he cut and cleared the paces, and bestowed the honour of knighthood 



---

p.239




upon the Lord Henry, the Duke of Lancaster's son, who was afterwards King Henry the Fifth, and so came to Dublin, where entering into counsel how to proceed in the war, he received news out of England of the arrival of the banished duke of Lancaster at Ravenspurg, usurping the regal authority and arresting and putting to death his principal officers.


This advertisement suddenly brake off the King's purpose touching the prosecution of the war in Ireland, and transported him into England, where shortly after he ended both his reign and his life. Since whose time until the thirty-ninth year of Queen Elizabeth there was never any army sent over of a competent strength or power to subdue the Irish, but the war was made by the English colonies only to defend their borders; or if any forces were transmitted over, they we're sent only to suppress the rebellions of such as were descended of English race, and not to enlarge our dominion over the Irish.


During the reign of King Henry the Fourth the Lord Thomas of Lancaster, the King's second son, was Lieutenant of Ireland, who for the first eight years of that King's reign made the Lord Scroope and others his deputies, who only defended the marches with forces levied within the land. In the eighth year that Prince came over in person with a small retinue; so as, wanting a sufficient power to attempt or perform any great service, he returned within seven months after into England. Yet during his personal abode there he was hurt in his own person within one mile of Dublin upon an encounter with the Irish enemy. He took the submissions of O'Byrne of the mountains, M'Mahon, and O'Reilly 
by several indentures, wherein O'Byrne doth covenant that the King shall quietly enjoy the manor of Newcastle; M'Mahon accepteth a state in the Ferny for life, rendering ten pounds a year; and O'Reilly doth promise to perform such duties to the Earl of March and Ulster as were contained in an indenture dated the eighteenth of Richard the Second.




---

p.240


In the time of King Henry the Fifth there came no forces out of England; howbeit the Lord Furnival, being the King's Lieutenant, made a martial circuit or journey round about the marches and borders of the Pale, and brought all the Irish to the King's peace, beginning with the Byrnes, Tooles, and Cavanaghs on the south, and so passing to the Moores, O'Connors, and O'Farrels in the west, and ending with the O'Reillys, Mac-Mahons, O'Neills, and O'Hanlons in the north. He had power to make them seek the King's peace, but not power to reduce them to the obedience of subjects; yet this was then held so great 
and worthy a service as that the lords and chief gentlemen of the Pale made certificate thereof in French unto the King, being then in France, which I have seen recorded in the White-book of the Exchequer at Dublin. Howbeit his army was so ill-paid and 
governed as the English suffered more damage by the cess of his soldiers (for now that monster, coigny and livery, which the statute of Kilkenny had for a time abolished, was risen again from hell) than they gained profit or security by abating the pride of their enemies for a time.


During the minority of King Henry the Sixth, and for the space of seven or eight years after, the Lieutenants and Deputies made only a bordering war upon the Irish with small and scattered forces; howbeit, because there came no treasure out of England to pay the soldier, the poor English subject did bear the burthen of the men of war in every place, and were thereby so weakened and impoverished as the state of things in Ireland stood very 
desperate.


Whereupon the Cardinal of Winchester, who after the death of Humphrey Duke of Gloucester did wholly sway the State of England, being desirous to place the Duke of Somerset in the Regency of France, took occasion to remove Richard Duke of York from that government and to send him into Ireland, pretending that he was a most able and willing person to perform 



---

p.241




service there, because he had a great inheritance of his own in Ireland, namely, the earldom of Ulster and the lordships of Connaught and Meath, by descent from Lionel Duke of Clarence. We do not find that this great Lord came over with any numbers of waged soldiers, but it appeareth upon what good terms he took that government by the covenants between the King and him which are recorded and confirmed by Act of Parliament in Ireland, and were to this effect:
1. That he should be the King's Lieutenant of Ireland for ten years.
2. That to support the charge of that country he should receive all the King's revenues there, both certain and casual, without account.
3. That he should be supplied also with treasure out of England in this manner; he should have 4000 marks for the first year, whereof he should be impressed 2000 li. beforehand; and for the other nine years he should receive 2000 li. per annum.
4. That he might let to farm the King's lands, and place and displace all officers at his pleasure.
5. That he might levy and wage what numbers of men he thought fit.
6. That he might make a Deputy and return at his pleasure.



We cannot presume that this Prince kept any great army on foot, as well because his means out of England were so mean, and those ill-paid, as appeareth by his passionate letter written to the Earl of Salisbury, his brother-in-law, the copy whereof is registered in the story of this time; as also because the whole land except the English Pale and some part of the earldom of Ulster upon the sea-coasts were possessed by the Irish; so as the revenue of the kingdom which he was to receive did amount to little. He kept the borders and marches of the Pale with much ado; he held many parliaments, wherein sundry laws were made for erecting of castles in Louth, Meath, and Kildare to 



---

p.242




stop the incursions of the Irishry. And because the soldiers for want of pay were cessed and laid upon the subjects against their wills, upon the prayer and importunity of the Commons this extortion was declared to be high treason. But to the end that some means might be raised to nourish some forces for defence of the Pale, by another Act of Parliament every twenty pound land was charged with the furnishing and maintenance of one archer on horseback.


Besides, the native subjects of Ireland, seeing the kingdom utterly ruined, did pass in such numbers into England as one law was made in England to transmit them back again, and another law made here to stop their passage in every port and creek. Yet afterwards the greatest parts of the nobility and gentry of Meath passed over into England, and were slain with him at Wake field in Yorkshire.


Lastly, the State of England was so far from sending an army to subdue the Irish at this time as among the articles of grievances exhibited by the Duke of York against King Henry the Sixth this was one, that divers lords about the King had caused His Highness to write letters unto some of his Irish enemies whereby they were encouraged to attempt the conquest of the said land, which letters the same Irish enemies had sent unto the Duke, 
marvelling greatly that such letters should be sent unto them, and speaking therein great shame of the realm of England.


After this, when this great Lord was returned into England, and making claim to the crown, began the war betwixt the two houses, it cannot be conceived but that the kingdom fell into a worse and weaker estate.


When Edward the Fourth was settled in the kingdom of England, he made his brother, George Duke of Clarence, Lieutenant of Ireland. This Prince was born in the Castle of Dublin during the government of his father, the Duke of York; yet did he never pass over into this kingdom to govern it in person, though he held 



---

p.243




the Lieutenancy many years. But it is manifest that King Edward the Fourth did not pay any army in Ireland during his reign, but the men of war did pay themselves by taking coigny and livery upon the country; which extortion grew so excessive and intolerable as the Lord Tiptoft, being Deputy to the Duke of Clarence, was enforced to execute the law upon the greatest Earl in the kingdom, namely, Desmond, who lost his head at Drogheda for this offence. Howbeit, that the State might not seem utterly to neglect the defence of the Pale, there was a fraternity of men-at-arms called the Brotherhood of St. George, erected by Parliament the fourteenth of Edward the Fourth, consisting of thirteen of the most noble and worthy persons within the four shires. Of the first foundation were Thomas, Earl of Kildare, Sir Rowland Eustace, Lord of Port Lester, and Sir Robert Eustace for the county of Kildare; Robert, Lord of Howth, the Mayor of Dublin, and Sir Robert Dowdall for the county of Dublin; the Viscount of Gormanstown, Edward Plunket, Seneschal of Meath, Alexander Plunket, and Barnaby Barnewale for the county of Meath; the Mayor of Drogheda, Sir Lawrence Taaffe, and Richard Bellewe for the county of Louth. These and their successors were to meet yearly upon St. George's Day, and to choose one of themselves to be captain of that brotherhood for the next year to come, which captain should have at his command 120 archers on horseback, forty horsemen, and forty pages to suppress outlaws and rebels. The wages of every archer should be sixpence per diem, and every horseman fivepence per diem, and four marks per annum. And to pay these entertainments and to maintain this new fraternity there was granted unto them by the same Act of Parliament a subsidy of poindage out of all merchandises exported or imported throughout the realm, hides and the goods of freemen of Dublin and Drogheda only excepted. These 200 men were all the standing forces that were then maintained in Ireland; and as they were natives of the kingdom, so the 



---

p.244




kingdom itself did pay their wages without expecting any treasure 
out of England.


But now the wars of Lancaster and York being ended, and Henry the Seventh being in the actual and peaceable possession of the kingdom of England, let us see if this King did send over a competent army to make a perfect conquest of Ireland. Assuredly, if those two idols or counterfeits which were set up against him in the beginning of his reign had not found footing and followers in this land, King Henry the Seventh had sent neither horse nor foot hither, but left the Pale to the guard and defence of the fraternity of St. George, which stood till the tenth year of his reign. And thereupon, upon the erection of the first idol, which was Lambert the priest's boy, he transmitted no forces, but sent over **Sir Richard Edgecombe** with commission to take an oath of allegiance of all the nobility, gentry, and citizens of this kingdom; which service he performed fully, and made an exact 
return of his commission to the King. And immediately after that the King sent for all the lords of Parliament in this realm, who, repairing to his presence, were first in a kingly manner reproved by him; for among other things he told them that if their King were still absent from them, they would at length crown apes; but at last entertained them, and dismissed them graciously. This course of clemency he held at first. But after, when **Perkin Warbeck**, who was set up and followed chiefly by the Geraldines in Leinster and the citizens of Cork in Munster, to suppress this counterfeit the King sent over **Sir Edward Poyning** with an army, as the histories call it, which did not consist of a thousand men by the poll; and yet it brought such terror with it as all the adherents of **Perkin Warbeck** were scattered, and retired for succour into the Irish countries. To the marches whereof he marched with his weak forces, but eftsoons returned and held 
a Parliament, wherein, among many good laws, one Act was made, that no subject should make any war or peace within the 



---

p.245




land without the special license of the King's Lieutenant or Deputy — a manifest argument that at that time the bordering wars in this kingdom were made altogether by voluntaries, upon their own head, without any pay or entertainment, and without any order or commission from the State. And though the lords and gentlemen of the Pale, in the nineteenth year of this King's reign, joined the famous battle of Knockroe in Connaught, 
wherein Mac William, with 4000 of the Irish and degenerate English were slain, yet was not this journey made by warrant from the King or upon his charge, as it is expressed in the Book of Howth, but only upon a private quarrel of the Earl of Kildare; so loosely were the martial affairs of Ireland carried during the reign of King Henry the Seventh.


In the time of King Henry the Eighth the Earl of Surrey, Lord Admiral, was made Lieutenant; and though he were the greatest captain of the English nation then living, yet brought he with him rather an honourable guard for his person than a competent army 
to recover Ireland. For he had in his retinue two hundred tall Yeomen of the King's Guard, but because he wanted means to perform any great action, he made means to return the sooner; yet in the meantime he was not idle, but passed the short time he spent here in holding a Parliament and divers journeys against the rebels of Leinster, insomuch as he was hurt in his own person upon the borders of Leix. After the revocation of this honourable personage, King Henry the Eighth sent no forces into Ireland till the rebellion of the Geraldines, which happened in the twenty-seventh year of his reign. Then sent he over **Sir William Skeffington** with five hundred men only to quench that fire, and not to enlarge the border or to rectify the government. This Deputy died in the midst of the service, so as the Lord Leonard Grey was sent to finish it; who, arriving with a supply of two hundred men or thereabouts, did so prosecute the rebels as the Lord Garret, their chieftain, and his five uncles submitted

 


---

p.246




themselves unto him, and were by him transmitted into England.


But this service being ended, that active nobleman, with his little army and some aids of the Pale, did oftentimes repel O'Neill and O'Donnel attempting the invasion of the civil shires, and at last made that prosperous fight at Belahoo, on the confines of Meath, the memory whereof is yet famous, as that he defeated well-nigh all the power of the north, and so quieted the border for many years.


Hitherto, then, it is manifest that since the last transferation of King Richard the Second the Crown of England never sent over either numbers of men or quantities of treasure sufficient to defend the small territory of the Pale, much less to reduce that which was lost or to finish the conquest of the whole island.


After this Sir Anthony St. Leger was made chief governor, who performed great service in a civil course, as shall be expressed hereafter. But Sir Edward Bellingham, who succeeded him, proceeded in a martial course against the Irishry, and was the first Deputy, from the time of King Edward the Third till the reign of King Edward the Sixth, that extended the border beyond the limits of the English Pale, by beating and breaking the Moores and Connors and building the forts of Leix and Offaly. This service he performed with six hundred horse, the monthly charge whereof did arise to 770 li., and four hundred foot, whose pay did not amount to 446 li. per mensem, as appeareth upon the Treasurer's account remaining in the office of the King's Remembrancer in England. Yet were not these countries so fully recovered by this Deputy but that Thomas Earl of Sussex did put the last hand to this work, and rooting out these two rebellious septs, planted English colonies in their rooms, which in all the tumultuous times since have kept their habitations, their loyalty, and religion.


And now we are come to the time of Queen Elizabeth, who 



---

p.247




sent over more men and spent more treasure to save and reduce the land of Ireland than all her progenitors since the conquest.


During her reign there arose three notorious and main rebellions which drew several armies out of England; the first of **Shane O'Neill**, the second of Desmond, the last of Tyrone; for the particular insurrections of the Viscount Baltinglass and Sir Edmund Butler, the Moores, the Cavanaghs, the Byrnes, and the Bourkes of Connaught were all suppressed by the standing forces here.


To subdue **Shane O'Neill** in the height of his rebellion, in the year 1566, Captain Randall transported a regiment of 1000 men into Ulster and planted a garrison at Lough Foyle; before the coming of which supply, viz., in the year 1565, the list of the standing army of horse and foot, English and Irish, did not exceed the number of 1200 men, as appeareth by the Treasurer's account of Ireland now remaining in the Exchequer of England. With these forces did Sir Henry Sidney, then Lord Deputy, march into the farthest parts of Tyrone, and joining with Captain Randall did much distress, but not fully defeat, O'Neill, who was afterwards slain upon a mere accident by the Scots, and not by the Queen's army.


To prosecute the wars in Munster against Desmond and his; adherents there were transmitted out of England at several times three or four thousand men, which, together with the standing garrisons and some other supplies raised here, made at one time an army of six thousand and upwards, which, with the virtue and valour of Arthur Lord Grey and others the commanders, did prove a sufficient power to extinguish that rebellion. But that being done, it was never intended that these forces should stand till the rest of the kingdom were settled and reduced; only that army which was brought over by the Earl of Essex, Lord Lieutenant and Governor-General of this kingdom in the thirty-ninth year of Queen Elizabeth, to suppress the rebellion of Tyrone, which was spread 



---

p.248




universally over the whole realm that army, I say (the command whereof, with the government of the realm, was shortly after transferred to the command of the Lord Mountjoy, afterwards Earl of Devonshire, who, with singular wisdom, valour, and industry, did prosecute and finish the war), did consist of such good men of war and of such numbers, being well-nigh 20,000 by the poll, and was so royally supplied and paid and continued in full strength so long a time as that it brake and absolutely subdued all the lords and chieftains of the Irishry and degenerate or rebellious English. Whereupon the multitude, who ever loved to be followers of such as could master and defend them, admiring the power of the Crown of England, being brayed, as it were, in a mortar with the sword, famine, and pestilence altogether, submitted themselves to the English Government, received the laws and magistrates, and most gladly embraced the King's pardon and peace in all parts of the realm with demonstration of joy and comfort, which made, indeed, an entire, perfect, and final conquest of Ireland. And though upon the finishing of the war this great army was reduced to less numbers, yet hath His Majesty, in his wisdom, thought it fit still to maintain such competent forces here as the Law may make her progress and circuit about the realm, under the protection of the sword, as Virgo, the figure of Justice, is by Leo in the zodiac, until the people have perfectly learned the lesson of obedience and the conquest be established in the hearts of all men.


Thus far have I endeavoured to make it manifest that from the first adventure and attempt of the English to subdue and conquer Ireland until the last war with Tyrone, which, as it was royally undertaken, so it was really prosecuted to the end, there hath been four main defects in the carriage of the martial affairs here. First, the armies for the most part were too weak for a conquest; secondly, when they were of a competent strength, as in both the journeys of Richard the Second, they were too soon 



---

p.249




broken up and dissolved; thirdly, they were ill-paid; and 
fourthly, they were ill-governed, which is always a consequent of 
ill-payment.


But why was not this great work performed before the latter 
end of Queen Elizabeth's reign, considering that many of the 
Kings her progenitors were as great captains as any in the world 
and had elsewhere larger dominions and territories? First, who 
can tell whether the Divine Wisdom, to abate the glory of those 
Kings, did not reserve this work to be done by a Queen, that it 
might rather appear to be His own immediate work, and yet for 
her greater honour made it the last of her great actions, as it 
were to crown all the rest? And to the end that a secure peace 
might settle the conquest and make it firm and perpetual to posterity, caused it to be made in that fulness of time when England 
and Scotland became to be united under one imperial crown, and 
when the monarchy of Great Britain was in league and amity with 
all the world. Besides, the conquest at this time doth perhaps 
fulfil that prophecy wherein the four great prophets of Ireland 
do concur, as it is recorded by Giraldus Cambrensis, to this 
effect, that after the first invasion of the English they should 
spend many ages in crebris conflictibus, longoque certamine et multis coedibus;[5](javascript:footNote('E610003/note005.html')) and that, Omnes fere Anglici ab Hibernia turbabuntur: 
nihilominus orientalia maritima semper obtinebunt; sed vix paulo 
anti diem Judicii plenam Anglorum populo vicioriam compromittunt; Insula Hibernica de mari usque ad mare de toto subacta et 
incastellata.[6](javascript:footNote('E610003/note006.html')) If St. Patrick and the rest did not utter this prophecy, certainly Giraldus is a prophet who hath reported it. To 
tins we may add the prophecy of Merlin, spoken of also by Giraldus, ‘Sextus moenia Hiberniae subvertet, et regiones in Regnum 



---

p.250




redigentur,’[7](javascript:footNote('E610003/note007.html')) which is performed in the time of King James the Sixth, in that all the paces are cleared and places of fastness laid open, which are the proper walls and castles of the Irish, as they were of the British in the time of Agricola, and withal, the Irish countries being reduced into counties, make but one entire and undivided kingdom.


But to leave these high and obscure causes, the plain and manifest truth is, that the Kings of England in all ages had been powerful enough to make an absolute conquest of Ireland if their whole power had been employed in that enterprise, but still there arose sundry occasions which divided and diverted their power some other way.


Let us, therefore, take a brief view of the several impediments which arose in every King's time since the first overture of the conquest, whereby they were so employed and busied as they could not intend the final conquest of Ireland.


King Henry the Second was no sooner returned out of Ireland but all his four sons conspired with his enemies, rose in arms, and moved war against him, both in France and in England.


This unnatural treason of his sons did the King express in an emblem painted in his chamber at Winchester, wherein was an eagle with three eaglets tiring[8](javascript:footNote('E610003/note008.html')) on her breast, and the fourth pecking at one of her eyes. And the truth is, these ungracious practices of his sons did impeach[9](javascript:footNote('E610003/note009.html')) his journey to the Holy Land, which he had once vowed vexed him all the days of his life, and brought his grey hairs with sorrow to the grave. Besides, this King having given the lordship of Ireland to John, his youngest son, his ingratitude afterwards made the King careless to settle him in the quiet and absolute possession of that kingdom.




---

p.251


Richard the First, which succeeded Henry the Second in the kingdom of England, had less reason to bend his power towards the conquest of this land, which was given in perpetuity to the Lord John, his brother; and therefore went he in person to the 
holy war, by which journey, and his captivity in Austria, and the heavy ransom that he paid for his liberty, he was hindered and utterly disabled to pursue any so great an action as the conquest of Ireland; and after his delivery and return hardly was he able to maintain a frontier war in Normandy, where by hard fortune he lost his life.


King John, his brother, had greatest reason to prosecute the war of Ireland, because the lordship thereof was the portion of his inheritance given unto him when he was called John Sans-Terre. Therefore he made two journeys thither; one when he was Earl of Morton, and very young, about twelve years of age; the other when he was King, in the twelfth year of his reign. In the first, his own youth, and his youthful company, Roboam's counsellors, made him hazard the loss of all that his father had won; 
but in the later he showed a resolution to recover the entire kingdom, in taking the submissions of all the Irishry and settling the estates of the English, and giving order for the building of many castles and forts, whereof some remain until this day. But he 
came to the crown of England by a defeasible title, so as he was never well settled in the hearts of the people, which drew him the sooner back out of Ireland into England, where shortly after he fell into such trouble and distress; the clergy cursing him on the one side, and the barons rebelling against him on the other; as he became so far unable to return to the conquest of Ireland, as besides the *forfeiture* of the territories in France he did in a manner lose both the kingdoms. For he surrendered both to the Pope, and took them back again to hold in fee-farm, which brought him into such hatred at home and such contempt abroad as all his lifetime after he was possessed rather with fear 



---

p.252




of losing his head than with hope of reducing the kingdom of Ireland.


During the infancy of Henry the Third the barons were troubled in expelling the French, whom they had drawn in against King John. But this Prince was no sooner come to his majority but the barons raised a long and cruel war against him.


Into these troubled waters the bishops of Rome did cast their nets, and drew away all the wealth of the realm by their provisions and infinite exactions, whereby the kingdom was so impoverished as the King was scarce able to feed his own household 
and train, much less to nourish armies for the conquest of foreign kingdoms. And albeit he had given this land to the Lord Edward, his eldest son, yet could not that worthy Prince ever find means or opportunity to visit this kingdom in person; for from the time he was able to bear arms he served continually against the barons, by whom he was taken prisoner at the battle of Lewes. And when that rebellion was appeased he made a journey to the Holy Land (an employment which in those days diverted all Christian Princes from performing any great actions in Europe), from whence he was returned when the crown of England descended upon him.


This King Edward the First, who was a Prince adorned with all virtues, did in the managing of his affairs show himself a right good husband, who, being owner of a lordship ill-husbanded, doth first enclose and manure his demesnes near his principal house before he doth improve his wastes afar off. Therefore, he began first to establish the commonwealth of England by making many excellent laws and instituting the form of public justice which remaineth to this day; next he fully subdued and reduced the dominion of Wales; then by his power and authority he settled the kingdom of Scotland; and lastly, he sent a royal army into Gascogne to recover the Duchy of Aquitaine. These 




---

p.253




four great actions did take up ail the reign of this Prince. And therefore we find not in any record that this King transmitted any forces into Ireland; but, on the other side, we find it recorded both in the annals and in the Pipe-Rolls of this kingdom, that three several armies were raised of the King's subjects in Ireland, and transported one into Scotland, another into Wales, and the third into Gascogne, and that several aids were levied here for 
the setting forth of those armies.


The son and successor of this excellent Prince was Edward the Second, who much against his will sent one small army into Ireland, not with a purpose to finish the conquest, but to guard the person of his minion, Piers Gaveston, who, being banished out of England, was made Lieutenant of Ireland, that so his exile might seem more honourable.


He was no sooner arrived here but he made a journey into the mountains of Dublin, brake and subdued the rebels there, built Newcastle in the Byrnes' country, and repaired Castlekevin, and after passed up into Munster and Thomond, performing everywhere great service with much virtue and valour. But the King, who could not live without him, revoked him within less than a year. After which time the invasion of the Scots and rebellion of the barons did not only disable this King to be a conqueror, but 
deprived him both of his kingdom and life. And when the Scottish nation had overrun all this land under the conduct of Edward le Bruce, who styled himself King of Ireland, England was not then able to send either men or money to save this kingdom. 
Only Roger de Mortimer, then Justice of Ireland, arrived at Youghal, cum 38 milit. saith **Friar Cliun** in his Annals.


But Bremingham, Verdon, Stapleton, and some other private gentlemen rose out with the commons of Meath and Vriell, and at Fagher, near Dundalk, a fatal place to the enemies of the Crown of England, overthrew a potent army of them. ‘Et sic,’ saith the Red-book of the Exchequer, wherein the victory was briefly recorded,



---

p.254




‘per manus communis populi, et dextram dei, deliberatur populus dei a servitute machinata et praecogitata.’


In the time of King Edward the Third the impediments of the conquest of Ireland are so notorious as I shall not need to express them; to wit, the wars which the King had with the realms of Scotland and of France, but especially the wars of France, which were almost continual for the space of forty years. And, indeed, France was a fairer mark to shoot at than Ireland, and could better reward the conqueror; besides, it was an inheritance newly descended upon the King, and therefore he had great reason to bend all his power and spend all his time and treasure in the recovery thereof. And this is the true cause why Edward the Third sent no army into Ireland till the thirty-sixth year of his reign, when the Lord Lionel brought over a regiment of 1500 men, as is before expressed, which that wise and warlike Prince did not transmit as a competent power to make a full 
conquest, but as an honourable retinue for his son, and withal to enable him to recover some part of his earldom of Ulster, which was then overrun with the Irish. But, on the other part, though the English colonies were much degenerate in this King's time and had lost a great part of their possessions, yet lying at the siege of Calais he sent for a supply of men out of Ireland, which were transported under the conduct of the Earl of Kildare and 
Fulco de la Freyn in the year 1347.


And now are we come again to the time of King Richard the Second, who for the first ten years of his reign was a minor, and much disquieted with popular commotions, and after that was more troubled with the factions that arose between his minions and the Princes of the blood. But at last he took a resolution to finish the conquest of this realm, and to that end he made two royal voyages hither. Upon the first he was deluded by the 
feigned submissions of the Irish; but upon the later, when he was fully bent to prosecute the war with effect, he was diverted 



---

p.255



 

and drawn from hence by the return of the Duke of Lancaster into England and the general defection of the whole realm.


As for Henry the Fourth, he being an intruder upon the Crown of England, was hindered from all foreign actions by sundry conspiracies and rebellions at home, moved by the House of Northumberland in the north, by the Dukes of Surrey and Exeter in the south, and by Owen Glendower in Wales; so as he spent his short reign in establishing and settling himself in the quiet possession of England, and had neither leisure nor opportunity to undertake the final conquest of Ireland. Much less could King Henry the Fifth perform that work, for in the second year of his reign he transported an army into France for the recovery of that kingdom, and drew over to the siege of Harfleur the Prior of Kilmainham with 1500 Irish, in which great action this victorious Prince spent the rest of his life.


And after his death the two noble Princes, his brothers, the Dukes of Bedford and Gloucester, who during the minority of King Henry the Sixth had the government of the kingdoms of England and France, did employ all their counsels and endeavours to perfect the conquest of France; the greater part whereof being 
gained by Henry the Fifth, and retained by the Duke of Bedford, was again lost by King Henry the Sixth a manifest argument of his disability to finish the conquest of this land. But when the civil war between the two houses was kindled, the Kings of England were so far from reducing all the Irish under their obedience 
as they drew out of Ireland, to strengthen their parties, all the nobility and gentry descended of English race; which gave opportunity to the Irishry to invade the lands of the English colonies, and did hazard the loss of the whole kingdom. For, 
though the Duke of York did, while he lived in Ireland, carry himself respectively towards all the nobility, to win the general love of all, bearing equal favour to the Geraldines and the Butlers, as appeared at the christening of George Duke of Clarence, who 



---

p.256




was born in the Castle of Dublin, where he made both the Earl of Kildare and the Earl of Ormond his gossips; and having occasion divers times to pass into England, he left the sword with Kildare at one time, and with Ormond at another, and when he lost his life at Wakefield there were slain with him divers of both those families; yet afterwards those two noble houses of Ireland did severally follow the two royal houses of England, the Geraldines adhering to the House of York, and the Butlers to the House of Lancaster; whereby it came to pass that not only the principal gentlemen of both those surnames, but all their friends and dependents, did pass into England, leaving their lands and possessions to be overrun by the Irish. These impediments, or rather impossibilities of finishing the conquest of Ireland, did continue till the wars of Lancaster and York were ended, which was about the twelfth year of King Edward the Fourth.


Thus hitherto the Kings of England were hindered from finishing this conquest by great and apparent impediments, Henry the Second by the rebellion of his sons; King John, Henry the Third, and Edward the Second by the barons' wars; Edward the First by his wars in Wales and Scotland; Edward the Third and 
Henry the Fifth by the wars of France; Richard the Second, Henry the Fourth, Henry the Sixth, and Edward the Fourth by domestic contention for the crown of England itself.


But the fire of the civil war being utterly quenched, and King Edward the Fourth settled in the peaceable possession of the crown of England, what did then hinder that warlike Prince from reducing of Ireland also? First, the whole realm of England was miserably wasted, depopulated, and impoverished by the late civil dissensions; yet as soon as it had recovered itself with a little peace and rest this King raised an army and revived the title of France again; howbeit this army was no sooner transmitted and brought into the field but the two Kings also 



---

p.257



 

were brought to an interview. Whereupon, partly by the fair and white promises of Lewis the Second, and partly by the corruption of some of King Edward's minions, the English forces were broken and dismissed, and King Edward returned into England, where shortly after, finding himself deluded and abused 
by the French, he died with melancholy and vexation of spirit.


I omit to speak of Richard the Usurper, who never got the quiet possession of England, but was cast out by Henry the Seventh within two years and a half after his usurpation.


And for King Henry the Seventh himself, though he made that happy union of the two houses, yet for more than half the space of his reign there were walking spirits of the House of York as well in Ireland as in England, which he could not conjure down without expense of some blood and treasure. But in his later times he did wholly study to improve the revenues of the Crown in both kingdoms, with an intent to provide means for some great action which he intended, which doubtless, if he had lived, would rather have improved a journey into France 
than into Ireland, because in the eyes of all men it was a fairer enterprise.


Therefore King Henry the Eighth in the beginning of his reign made a voyage-royal into France, wherein he spent the greatest part of that treasure which his father had frugally reserved, perhaps for the like purpose. In the latter end of his 
reign he made the like journey, being enriched with the revenues of the Abbey lands. But in the middle time between these two attempts, the great alteration which he made in the state ecclesiastical caused him to stand upon his guard at home, the Pope having solicited all the Princes of Christendom to revenge his 
quarrel in that behalf. And thus was King Henry the Eighth detained and diverted from the absolute reducing of the kingdom of Ireland.


Lastly, the infancy of King Edward the Sixth and the coverture



---

p.258




of Queen Mary, which are both non-abilities in the law, did in fact disable them to accomplish the conquest of Ireland.


So as now this great work did remain to be performed by Queen Elizabeth, who, though she were diverted by suppressing the open rebellion in the north, by preventing divers secret conspiracies against her person, by giving aids to the French and States of the Low Countries, by maintaining a naval war with Spain for many years together; yet the sundry rebellions, joined with foreign invasions upon this island, whereby it was in danger to be utterly lost and to be possessed by the enemies of the Crown of England, did quicken Her Majesty's care for the preservation thereof; and to that end, from time to time during her reign she sent over such supplies of men and treasure as did suppress the rebels and repel the invaders. Howbeit, before the transmitting of the last great army, the forces sent over by Queen Elizabeth were not of sufficient power to break and subdue all the Irishry and to reduce and reform the whole kingdom. But when the general defection came, which came not without a special providence for the final good of that kingdom though the second causes thereof were the faint prosecution of the war against Tyrone, the practices of priests and Jesuits, and the expectation of the aids from Spain then the extreme peril of losing the kingdom, the dishonour and danger that might thereby grow to the Crown of England, together with a just disdain conceived by that great-minded Queen that so wicked and ungrateful a rebel should prevail against her who had ever been victorious against all her enemies, did move and almost enforce her to send over that mighty army, and did withal inflame the hearts of the subjects of England cheerfully to contribute towards the maintaining thereof a million of sterling pounds at least, which was done with a purpose only to save and not to gain a kingdom; to keep and retain that sovereignty which the Crown of England had in Ireland, such as it was, and not to recover a more absolute 



---

p.259




dominion. But, as it falleth out many times that when a house is on fire the owner, to save it from burning, pulleth it down to the ground, but that pulling down doth give occasion of building it up again in a better form, so these last wars, which to save the kingdom did utterly break and destroy this people, produced a better effect than was at first expected. For every rebellion, when it is suppressed, doth make the subject weaker and the Prince stronger; so this general revolt, when it was overcome, did produce a general obedience and reformation of all the Irishry, 
which ever before had been disobedient and unreformed; and thereupon ensued the final and full conquest of Ireland.


And thus much may suffice to be spoken touching the defects in the martial affairs and the weak and faint prosecution of the war, and of the several impediments or employments which did hinder or divert every King of England successively from reducing Ireland to their absolute subjection.


It now remaineth that we show the defects of the civil policy and government which gave no less impediment to the perfection of this conquest.


The first of that kind doth consist in this, that the Crown of England did not from the beginning give Laws to the Irishry, whereas to give laws to a conquered people is the principal mark and effect of a perfect conquest. For albeit King Henry the Second, before his return out of Ireland, held a Council or Parliament at Lismore, ‘Ubi leges Angliae ab omnibus sunt gratanter 
receptae, et juratoria cautione praestita confirmatae,’[10](javascript:footNote('E610003/note010.html')) as Matthew Paris writeth.




---

p.260


And though King John, in the twelfth year of his reign, did establish the English laws and customs here, and placed sheriffs and other ministers to rule and govern the people according to the law of England, and to that end, ‘Ipse duxit secum viros discretes et legis peritos, quorum communi consilio statuit et praecepit leges Anglicanas teneri in Hibernia,’ &c.,[11](javascript:footNote('E610003/note011.html')) as we find it recorded among the Patent-Rolls in the Tower, 11 Henry 3, m. 3; though, likewise, King Henry the Third did grant and transmit the like charter of liberties to his subjects of Ireland as himself and his father had granted to the subjects of England, as appeareth by another record in the Tower, 1 Hen. 3, Pat. m. 13; and afterwards, by a special Writ, did command the Lord-Justice of Ireland, ‘Quod convocatis Archiepiscopis, Comitibus, Baronibus, etc. Coram eis legi faceret Chartam Regis Johannis; quam ipse legi fecit et jurari a Magnatibus Hiberniae, de legibus et Constitutionibus Angliae observandis, et quod leges illas teneant et observent,’[12](javascript:footNote('E610003/note012.html')) 12 Hen. 3, claus. m. 8. And after that again the same King, by Letters Patent under the Great Seal of England, did confirm the establishment of the English laws made by King John, in this form: ‘Quia pro communi utilitate terrae Hiberniae, ac unitate terrarum, de Communi Consilio provisum sit, quod omnes leges et consuetudines qua in regno Angliae tenentur, in Hibernia teneantur, eadem terra ejusdem legibus subjaceat, ac per easdem regatur, sicut Johannes Rex, cum illuc esset, statuit et firmiter mandavit; ideo volumus quod omnia brevia de Communi Jure, quae currunt in Anglia, similiter currant in Hibernia, sub novo sigillo nostro, etc. Teste meipso apud Woodstock’ &c.;[13](javascript:footNote('E610003/note013.html')) which confirmation is found 



---

p.261



 

among the Patent-Rolls in the Tower, Anno 30, Hen. 3. Notwithstanding, it is evident by all the records of this kingdom that only the English colonies and some few septs of the Irishry which were enfranchised by special charters were admitted to the benefit and protection of the laws of England, and that the Irish generally were held and reputed aliens, or rather enemies to the Crown of England, insomuch as they were not only disabled to bring any actions, but they were so far out of the protection of the law as it was often adjudged no felony to kill a mere Irishman in the time of peace.


That the mere Irish were reputed aliens appeareth by sundry records wherein judgment is demanded, if they shall be answered in actions brought by them, and likewise by the Charters of Denization which in all ages were purchased by them.


In the Common Plea Rolls of the twenty-eighth of Edward the Third, which are yet preserved in Bremingham's Tower, this case is adjudged. Simon Neill brought an action of trespass against William Newlagh for breaking his close in Claudalkin, in the county cf Dublin; the defendant doth plead that the plaintiff is ‘Hibernicus et non de quinque sanguinibus’[14](javascript:footNote('E610003/note014.html')) and demandeth judgment, if he shall be answered. The plaintiff replieth: ‘Quod ipse est de quinque sanguinibus, viz., De les O' Neils de Ultonia, qui per 
concessionem progenitorum Domini Regis, Libertatibus Anglicis gaudere debent et utuntur, et pro liber is hominibus reputantur’[15](javascript:footNote('E610003/note015.html')) The defendant rejoineth that the plaintiff is not of the O'Neills of Ulster, ‘Nec de quinqe sanguinibus;’and therefore they are at 



---

p.262




issue. Which being found for the plaintiff, he had judgment to recover his damages against the defendant. By this record it appeareth that five principal bloods or septs of the Irishry were by special grace enfranchised and enabled to take benefit of the laws of England, and that the nation of O'Neills in Ulster was one of the five. And in the like case the third of Edward the Second, amongst the Plea Rolls in Bremingham's Tower, all the five septs or bloods, ‘Qui gaudeant lege Anglicana quoad brevia portanda,’ are expressed, namely, O'Neil de Ultonia, O'Molaghlin de Midia, O'Connoghor de Connacia, O'Brien de Thotmonia, et MacMurrogh de Lagenia. And yet I find that O'Neill himself long after, viz., in the twentieth of Edward the Fourth, upon his marriage with a daughter of the House of Kildare, to satisfy the friends of the lady, was made denizen by a special Act of Parliament, 20 Ed. 4, c. 8.


Again, in the twenty-ninth of Edward the First, before the Justices in Eyre, at Drogheda, Thomas de Botteler brought an action of Detinue against Robert de Almain for certain goods. The defendant pleadeth: ‘Quod non tenetur ei inde respondere eo, quod est Hibernicus, et non de libero sanguine. Et praedictus Thomas dicit, quod Anglicus est, et hoc petit quod inquiratur per patriam, ideo fiat inde jurat, etc. Jurat' dicunt super sacrament' suum, quod praedict' Thomas Anglicus est, ideo consideratum est quod recuperet,’ &c.[16](javascript:footNote('E610003/note016.html'))


These two records, among many other, do sufficiently show that the Irish were disabled to bring any actions at the Common Law. Touching their denizations, they were common in every king's reign since Henry the Second, and were never out of use till His Majesty that now is came to the crown.


Among the pleas of the Crown, fourth of Edward the Second, we 



---

p.263



 

find a confirmation made by Edward the First of a Charter of Denization granted by Henry the Second to certain Oostmen, or Easterlings, who were inhabitants of Waterford long before Henry the Second attempted the conquest of Ireland: ‘Edwardus Dei gratia, etc., Justitiario suo Hiberniae, Salutem: Quia per inspectionem Chartae Dom. Hen. Reg. filii Imperatricis quondam Dom. Hiberniae, proavi nostri nobis constat, quod Ostmanni de Waterford legem Anglicorum in Hibernia habere, et secundum ipsam legem Judicari et deduci debent: vobis mandamus quod Gillicrist MacGilmurrii Willielmum et Johannem MacGilmurrii et alios Ostmannos de civitate et comitatu Waterford, qui de predictis Ostmannis praedict. Dom. Henr. proavi nostri originem duxerunt, legem Anglicorum in partibus illis juxta tenorem Chartae praedict. habere, et eos secundum ipsam legem, quantum in nobis est, deduci faciatis, donec aliud de consilio nostro inde duxerimus ordinand. In cuius rei, etc. Teste mcipso apud Acton Burnell, 5 Octobris anno regni nostri undecimo.’


Again, among the Patent-Rolls of the first of Edward the Fourth remaining in the Chancery here, we find a Patent of Denization granted the thirteenth of Edward the First, in these words: ‘Edwardus Dei gratia, Rex Angliae, Dom. Hiberniae, Dux Aquitaniae, etc. Omnibus Ballivis et fidelibus suis in Hibernia, Salutem: Volentes Christophero filio Donaldi Hibernico gratiam facere specialem, concedimus pro nobis et haeredibus nostris, quod idem Christopherus hanc habeat libertatem, viz., Quod ipse de caetero in Hibernia utatur legibus Anglicanis, et prohibemus ne quisquam contra hanc concessionem nostram dictum Christopherum vexet in aliquo vel perturbet. In cuius rei testimonium, etc. Teste meipso apud West., 27 die Junii anno regni nostri 13.’


In the same roll we find another Charter of Denization granted in the first of Edward the Fourth, in a more large and beneficial form: ‘Edw. Dei gratia, etc. Omnibus Ballivis, etc., Salutem. Sciatis quod nos volentes Willielmum O Bolgir capellanum de Hibernica natione existentem, favore prosequi gratioso, de gratia 



---

p.264




nostra speciali, etc. Concessimus eidem Willielmo quod ipse liberi sit status, et liberae conditionis, et ab omni servitute Hibernica liber et quietus, et quod ipse legibus Anglicanis in omnibus et per omnia uti possit et gaudere, eodem modo quo homines Anglici infra dictam terram eas habent et iis gaudent et utuntur, quodque ipse respondeat, et respondeatur, in quibuscumque curiis nostris; ac omnimod. terras, tenementa, redditus, et servitia perquirere possit sibi et haeredibus suis in perpetuum, etc.’


If I should collect out of the records all the charters of this kind, I should make a volume thereof; but these may suffice to show that the mere Irish were not reputed free subjects nor admitted to the benefit of the Laws of England until they had purchased Charters of Denization.


Lastly, the mere Irish were not only accounted aliens but enemies, and altogether out of the protection of the law, so as it was no capital offence to kill them; and this is manifest by many records. At a gaol delivery at Waterford, before John Wogan, Lord-Justice of Ireland, the fourth of Edward the Second, we find it recorded among the pleas of the Crown of that year: ‘Quod Robertus le Wayleys rectatus de morte Johannis filii Ivor Mac-Gillemory felonice per ipsum interfecti, etc. Venit et bene cognovit quod praedictum Johannem interfecit: dicit tamen quod per eius interfectionem feloniam committere non potuit, quia dicit, quod praedictus Johannes fuit purus Hibernicus, et non de libero sanguine, etc. Et cum Dominus dicti Johannis (cuius Hibernicus idem Johannes fuit) die quo interfectus fuit, solutionem pro ipso Johanne Hibernico suo sic interfecto petere voluerit, ipse Robertus paratus erit ad respondend' de solutione praedict. prout justitia suadebit. Et super hoc venit quidam Johannes le Poer, et dicit pro Domino Rege, 
quod praedict. Johannes filius Ivor MacGillemory, et antecessores sui de cognonime praedict. a tempore quo Dominus Henricus filius Imperatricis, quondam Dominus Hiberniae, Tritavus Domini Regis nunc, fuit in Hibernia, legem Anglicorum in Hibernia usque ad hunc 



---

p.265




diem habere, et secundum ipsam legem judicari et deduci debent.’ 
And so pleaded the Charter of Denization granted to the Oostmen recited before; all which appeareth at large in the said record, wherein we may note that the killing of an Irishman was not punished by our law as manslaughter, which is felony and capital, for our law did neither protect his life nor revenge his death, but by a fine or pecuniary punishment which is called an **ericke** according to the Brehon or Irish law.


Again, at the gaol-delivery before the same Lord-Justice at Limerick, in the roll of the same year, we find that ‘Willielmus filius Rogeri rectatus de morte Rogeri de Canteton felonice per ipsum interfecti, venit et dicit, quod feloniam per interfectionem praedictam committere non potuit, quia dicit quod praedict. Rogerus Hibernic. est, et non de libero sanguine; dicit etiam quod praedict. Rogerus fuit de cognomine de Ohederiscal et non de cognomine de Cantetons, et de hoc ponit se super patriam, etc. Et jurati dicunt super sacram. suum quod praedictus Rogerus Hibernicus fuit et de cognomine de Ohederiscal et pro Hibernico habebatur tota vita sua. Ideo predict. Willielmus quoad feloniam praedict. dict, quietus. Sed quia praedictus Rogerus Ohederiscal fuit Hibernicus Domini Regis, praedict. Willielmus recommittatur gaolae quousque plegios invenerit de quinque marcis solvendis Domino Regi pro solutione praedicti Hibernici.’


But, on the other side, if the jury had found that the party slain had been of English race and nation, it had been adjudged felony, as appeareth by a record of the twenty-ninth of Edward the First, in the Crown Office here: ‘Coram Waltero Lenfant et sociis suis justitiariis itinerantibus apud Drogheda in Comitatu Louth. Johannes Laurens indictat. de morte Galfridi Dovedal venit et non dedicit mortem praedictam: sed dicit quod praedict. 
Galfridus fuit Hibernicus, et non de libero sanguine, et de bono et malo ponit se super patriam, etc. Et jurat, dicunt super sacram. suum quod praedict. Galfridus Anglicus fuit, et ideo praedict. 



---

p.266




Johannes culpabilis est de morte Galfridi praedict. Ideo suspend. Catalla 138 unde Hugo de Clinton, Vicecom. respondet.’


Hence it is that in all the Parliament Rolls which are extant from the fortieth year of Edward the Third, when the Statutes of Kilkenny were enacted, till the reign of King Henry the Eighth, we find the degenerate and disobedient English called rebels; but the Irish, which were not in the King's peace, are called enemies (Statute Kilkenny, c. i. 10 and 11; 11 Hen. 4, c. 24; 10 Hen. 6, c. 1, 18; 18 Hen. 6, c. 4, 5; Edw. 4, c. 6; 10 Hen. 7, c. 17). All these Statutes speak of English rebels and Irish enemies, as if the Irish had never been in condition of subjects, but always out of the protection of the law, and were, indeed, in worse case than aliens of any foreign realm that was in amity with the Crown of England. For by divers heavy penal laws the English were forbidden to marry, to foster, to make gossips with the Irish, or to have any trade or commerce in their markets or fairs; nay, there was a law made no longer since than the twenty-eighth year of Henry the Eighth, that the English should not marry with any person of Irish blood, though he had gotten a Charter of Denization, unless he had done both homage and fealty to the King in the Chancery, and were also bound by recognisance with sureties to continue a loyal subject. Whereby it is manifest that such as had the government of Ireland under the Crown of England did intend to make a perpetual separation and enmity between the English and the Irish, pretending no doubt that the English should in the end root out the Irish; which the English, not being able to do, did cause a perpetual 
war between the nations, which continued four hundred and odd years, and would have lasted to the world's end if in the end of Queen Elizabeth's reign the Irishry had not been broken and conquered by the sword, and since the beginning of His Majesty's reign had not been protected and governed by the law.


But perhaps the Irishry in former times did wilfully refuse to be 



---

p.267



 

subject to the laws of England, and would not be partakers of the benefit thereof though the Crown of England did desire it, and therefore they were reputed aliens, outlaws, and enemies. Assuredly the contrary doth appear, as well by the Charters of Denization purchased by the Irish in all ages, as by a petition preferred by them to the King, anno 2 Edward the Third, desiring that an Act might pass in Ireland whereby all the Irishry might be enabled to use and enjoy the laws of England without purchasing of particular denizations. Upon which petition the King directed a special Writ to the Lord-Justice, which is found amongst the Close-Rolls in the Tower of London in this form: [17](javascript:footNote('E610003/note017.html')) ‘Rex dilecto et fideli suo Johannis Darci le Nepieu Justic., suo Hiberniae, Salutem. Ex parte quorundam hominum de Hibernia nobis extitit supplicatum, ut per Statutum inde faciendum concedere velimus quod omnes Hibernici qui voluerint legibus utatur Anglicanis, ita quod necesse non habeant super hoc chartas alienas a nobis impetrare: nos igitur 
certiorari volentes si sine alieno praejudicio praemissis annuere valeamus, vobis mandamus quod voluntatem magnatum terr. illius in proximo Parliamento nostro ibidem tenendo super hoc cum diligentia perscrutari facias: et de eo quod inde inveneritis una cum consilio et advisamento nobis certificetis,’ &c. Whereby I collect that the great lords of Ireland had informed the King that the Irishry might not be naturalised without damage and prejudice either to themselves or to the Crown.


But I am well assured that the Irishry did desire to be admitted to the benefit of the law, not only in this petition exhibited to King Edward the Third, but by all their submissions made to King Richard the Second and to the Lord Thomas of Lancaster before the wars of the two houses, and afterwards to the Lord Leonard Grey and Sir Anthony Saint Leger, when King Henry the Eighth began to reform this kingdom. In particular, the Byrnes of the mountains, in the thirty-fourth



---

p.268




of Henry the Eighth, desire that their country might be made shire-ground and called the county of Wicklow; and in the twenty-third of Henry the Eighth, O'Donnell doth covenant with **Sir William Skeffington**, ‘Quod si Dominus Rex velit reformare Hiberniam,’ whereof it should seem he made some doubt that he and his people would gladly be governed by the laws of England. Only that ungrateful traitor Tyrone, though he had no colour or shadow of title to that great lordship but only by grant from the Crown and by the law of England, for by the Irish law he had been ranked with the meanest of his sept, yet in one of his capitulations with the State he required that no sheriff might have jurisdiction within Tyrone, and consequently that the laws of England might not be executed there; which request was never before made by O'Neill or any other lord of the Irishry when they submitted themselves, but, contrariwise, they were humble suitors to have the benefit and protection of the English laws.


This, then, I note as a great defect in the civil policy of this kingdom, in that, for the space of 350 years at least after the conquest first attempted, the English laws were not communicated to the Irish, nor the benefit and protection thereof allowed unto them, though they earnestly desired and sought the same. 
For, as long as they were out of the protection of the law, so as every Englishman might oppress, spoil, and kill them without controlment, how was it possible they should be other than outlaws and enemies to the Crown of England? If the King would not admit them to the condition of subjects, how could they learn to acknowledge and obey him as their Sovereign? When 
they might not converse or commerce with any civil men, nor enter into any town or city without peril of their lives, whither should they fly but into the woods and mountains, and there live in a wild and barbarous manner? If the English magistrates would not rule them by the law which doth punish treason and 



---

p.269



 

murder and theft with death, but leave them to be ruled by their own lords and laws, why should they not embrace their own Brehon law, which punisheth no offence but with a fine or **erick**? If the Irish be not permitted to purchase estates of freeholds or inheritance, which might descend to their children, according to the course of our Common Law, must they not continue their custom of tanistry, which makes all their possessions uncertain, and brings confusion, barbarism, and incivility? In a word, if the English would neither in peace govern them by the law, nor could in war root them out by the sword, must they not needs be pricks in their eyes and thorns in their sides till the world's end, and so the conquest never be brought to perfection?


But, on the other side, if from the beginning the laws of England had been established, and the Brehon or Irish law utterly abolished, as well in the Irish countries as the English colonies; if there had been no difference made between the nations in point of justice and protection, but all had been governed by one equal, just, and honourable law, as Dido speaketh in Virgil, ‘Tros, Tyriusve, mihi nullo discrimine habetur;’ 
if upon the first submission made by the Irish lords to King Henry the Second, ‘Quem in regem et dominum receperunt,’ [18](javascript:footNote('E610003/note018.html')) saith Matthew Paris; or upon the second commission made to King John, when, ‘Plusquam viginti reguli maximo timore perterriti homagium ei et fidelitatem fecerunt,’ [19](javascript:footNote('E610003/note019.html')) as the same author writeth; or upon the third general submission made to King Richard the Second, when they did not only do homage and fealty, but bound themselves by indentures and oaths, as is before expressed, to become and continue loyal subjects to the Crown of England: if any of these three Kings, who came each of them twice in 



---

p.270




person into this kingdom, had, upon these submissions of the Irishry, received them all, both lords and tenants, into their immediate protection, divided their several countries into counties; made sheriffs, coroners, and wardens of the peace therein; sent justices-itinerants half-yearly into every part of the kingdom, 
as well to punish malefactors as to hear and determine causes between party and party, according to the course of the laws of England; taken surrenders of their lands and territories, and granted estates unto them to hold by English tenures; granted them markets, fairs, and other franchises, and erected corporate 
towns among them — all which hath been performed since His Majesty came to the crown — assuredly the Irish countries had long since been reformed and reduced to peace, plenty, and civility, which are the effects of laws and good government. They had built houses, planted orchards and gardens, erected townships, and made provision for their posterities; there had been a perfect union betwixt the nations, and consequently a conquest of Ireland. For the conquest is never perfect till the war be at an end, and the war is not at an end till there be peace and unity; and there can never be unity and concord in any one kingdom but where there is but one King, one allegiance, and one law.


True it is that King John made twelve shires in Leinster and Munster, namely, Dublin, Kildare, Meath, Uriel, Catherlough, Kilkenny, Wexford, Waterford, Cork, Limerick, Kerry, and Tipperary; yet these counties did stretch no farther than the lands of the English colonies did extend. In them only were the English laws published and put in execution, and in them only did the itinerant judges make their circuits and visitations of justice, and not in the countries possessed by the Irishry, which contained two-third parts of the kingdom at least. And therefore King Edward the First, before the Court of Parliament was established in Ireland, did transmit the Statutes of England in this form: 



---

p.271



 

‘Dominus Rex mandavit Breve suum in haec verba: Edwardus Dei gratia, Rex Angliae, Dominus Hiberniae, etc. Cancellario suo Hiberniae, Salutem. Quaedam statuta per nos de assensu Praelatorum, Comitum, Baronum et Communitat. regni nostri nuper apud Lincolne et quaedam alia statuta postmodum apud Eborum facta, quae in dicta terra nostra Hiberniae ad communem utilitatem populi nostri ejusdem terrae observari volumus, vobis mittimus sub sigillo nostro, mandantes quod statuta illa in dicta cancellaria nostra custodiri, ac in rotulis ejusdem cancellariae irrotulari, et ad singulas placeas nostras in terra nostra Hiberniae, et singulos commitatus ejusdem terrce mitti faciatis ministris nostris placearum illarum, et Vicecomitibits dictorum Comitatuum: mandantes, quod statuta illa coram ipsis publicari et ea in omnibus et singulis articulis suis observari firmiter faciatis. Teste meipso apud Nottingham,’ &c. By which Writ, and by all the Pipe-Rolls of that time, it is manifest that the laws of England were published and put in execution only in the counties which were then made and limited, and not in the Irish countries, which were neglected and left wild, and have but of late years been divided in one-and-twenty counties more.


Again, true it is that by the Statute of Kilkenny, enacted in this kingdom in the fortieth year of King Edward the Third, the Brehon law was condemned and abolished, and the use and practice thereof made high treason. But this law extended to the English only, and not to the Irish; for the law is penned in this form: ‘Item, Forasmuch as the diversity of government by divers laws in one land doth make diversity of liegeance and debates between the people, it is accorded and established that hereafter no Englishman have debate with another Englishman but according to the course of the Common Law; and that no Englishman be ruled in the definition of their debates by the March Law or the Brehon Law, which by reason ought not to be named a law, but an evil custom, but that they be ruled as right is, by the 



---

p.272




Common Law of the land, as the lieges of our Sovereign Lord the King; and if any do to the contrary, and thereof be attainted, that he be taken and imprisoned and lodged as a traitor, and that hereafter there be no diversity of liegeance between the English born in England, but that all be called and reputed English, and the lieges of our Sovereign Lord the King,’ &c. This law was made only to reform the degenerate English, but there was no care taken for the reformation of the mere Irish; no ordinance, no provision made for the abolishing of their barbarous customs and manners. Insomuch as the law then made for apparel and riding in saddles after the English fashion is penal only to Englishmen, and not to the Irish. But the Roman State, which conquered so many nations both barbarous and civil, and therefore knew by experience the best and readiest way of making a perfect and absolute conquest, refused not to communicate their laws to the rude and barbarous people whom they had conquered; neither did they put them out of their protection after they had once submitted themselves. But, contrariwise, it is said of Julius Caesar, ‘Qua vicit, victos protegit ille, manu;’[20](javascript:footNote('E610003/note020.html')) and again, of another Emperor —
  

‘Fecisti patriam diversis gentibus unam,
  

Profuit invitis te dominante capi;
  

Dumque offers victis proprii consortia juris,
  

Urbem fecisti, quod prius orbis erat.’[21](javascript:footNote('E610003/note021.html'))
  


And of Rome itself 

‘Haec est, in gremium victos quae sola recepit,
  

Humanumque genus communi nomine fovit,
  



---

p.273



 

Matris, non dominae, ritu; civesque vocavit,
  

Quos domuit, nexuque pio longinqua revinxit.’[22](javascript:footNote('E610003/note022.html'))


Therefore, as Tacitus writeth, Julius Agricola, the Roman general in Brittany, used this policy to make a perfect conquest of our ancestors, the ancient Britons. They were, saith he, rude and dispersed, and therefore prone upon every occasion to make war, but to induce them by pleasure to quietness and rest, he exhorted them in private, and gave them helps in common, to build temples, houses, and places of public resort. The noblemen's sons he took and instructed in the liberal sciences, &c., preferring the wits of the Britons before the students of France, as being now curious to attain the eloquence of the Roman language, whereas they lately rejected that speech. After that the Roman attire grew to be in account and the gown to be in use among them; and so by little and little they proceeded to curiosity and delicacies in buildings and furniture of household, in baths and exquisite banquets; and so being come to the height of civility, they were thereby brought to an absolute subjection.


Likewise our Norman Conqueror, though he oppressed the English nobility very sore, and gave away to his servitors the lands and possessions of such as did oppose his first invasion, though he caused all his Acts of Counsel to be published in French, and some legal proceedings and pleadings to be framed and used in the same tongue, as a mark and badge of a conquest; yet he governed all, both English and Normans, by one and the same law, which was the ancient Common Law of England long before the Conquest. Neither did he deny any Englishman that submitted himself unto him the benefit of that law, though it 




---

p.274




were against a Norman of the best rank and in greatest favour, as appeared in the notable controversy between Warren, the Norman, and Sherborne of Sherborne Castle in Norfolk. For the Conqueror had given that castle to Warren; yet when the inheritors thereof had alleged before the King that he never bore arms against him, that he was his subject as well as the other, and that he did inherit and hold his lands by the rules of that law which the King had established among all his subjects, the King gave judgment against Warren, and commanded that Sherborne should hold his lands in peace. By this means himself obtained a peaceable possession of the kingdom within few years; whereas, if he had cast all the English out of his protection and held them as aliens and enemies to the Crown, the Normans perhaps might have spent as much time in the conquest of England as the English have spent in the conquest of Ireland.


The like prudent course hath been observed in reducing of Wales, which was performed partly by King Edward the First, and altogether finished by King Henry the Eighth. For we find by the Statute of Rutland made the twelfth of Edward the First, when the Welshmen had submitted themselves, de alto et basso, to that King, he did not reject and cast them off as outlaws and enemies, but caused their laws and customs to be examined, which were in many points agreeable to the Irish or Brehon law. ‘Quibus diligenter auditis et plenus intellectis, quasdam illarum,’ saith the King in that ordinance, ‘consilio procerum delevimus, quasdam permissimus, quasdam correximus, ac etiam quasdam alias adjiciendas et fadend. decrevimus;’[23](javascript:footNote('E610003/note023.html')) and so established a commonwealth among them, according to the form of the English government. After this, by reason of the sundry insurrections of the barons, the wars in France, and the dissension between the two 



---

p.275



 

Houses of York and Lancaster, the State of England neglected or omitted the execution of this Statute of Rutland, so as a great part of Wales grew wild and barbarous again. And therefore King Henry the Eighth, by the Statutes of the twenty-seventh and thirty-second of his reign, did revive and recontinue that noble work begun by King Edward the First, and brought it indeed to full perfection. For he united the dominion of Wales to the Crown of England and divided it into shires, and erected in every shire one borough, as in England, and enabled them to send knights and burgesses to the Parliament, established a Court of Presidency, and ordained that justices of assize and gaol-delivery should make their half-yearly circuits there as in England; made all the laws and statutes of England in force there, and, among other Welsh customs, abolished that of gavelkind, whereby the heirs-females were utterly excluded and the bastards did inherit as well as the legitimate, which is the very Irish gavelkind. By means whereof that entire country in a short time was securely settled in peace and obedience, and hath attained to that civility of manners and plenty of all things as now we find it not inferior to the best parts of England.


I will, therefore, knit up this point with these conclusions: First, that the Kings of England, which in former ages attempted the conquest of Ireland, being ill advised and counselled by the great men here, did not, upon the submissions of the Irish, communicate their laws unto them, nor admit them to the state and condition of free subjects. Secondly, that for the space of two hundred years at least after the arrival of Henry the Second in Ireland the Irish would gladly have embraced the laws of England, and did earnestly desire the benefit and protection thereof, which being denied them, did of necessity cause a continual bordering war between the English and the Irish. And lastly, if, according to the examples before recited, they had reduced as well the Irish countries as the English colonies under one form 



---

p.276




of civil government, as now they are, the meres and bounds of the marches and borders had been long since worn out and forgotten for it is not fit, as Cambrensis writeth, that a King of an island should have any marches or borders but the four seas both nations had been incorporated and united, Ireland had been entirely conquered, planted, and improved, and returned a rich revenue to the Crown of England.


The next error in the civil policy which hindered the perfection of the conquest of Ireland did consist in the distribution of the lands and possessions which were won and conquered from the Irish. For the scopes of land which were granted to the first adventurers were too large, and the liberties and royalties which they obtained therein were too great for subjects, though it stood with reason that they should be rewarded liberally out of the fruits of their own labours, since they did miltare propriis stipendiis,[24](javascript:footNote('E610003/note024.html')) and received no pay from the Crown of England. Notwithstanding there ensued divers inconveniences, that gave great impediment to the conquest.


First, the Earl Strongbow was entitled to the whole kingdom of Leinster, partly by invasion and partly by marriage. Albeit he surrendered the same entirely to King Henry the Second, his Sovereign, for that with his license he came over, and with the aid of his subjects he had gained that great inheritance; yet did the King regrant back again to him and his heirs all that province, reserving only the city of Dublin and the cantreds next adjoining, with the maritime towns and principal forts and castles. 
Next, the same King granted to Robert Fitzstephen and Miles Cogan the whole kingdom of Cork, from Lismore to the sea. To Philip le Bruce he gave the whole kingdom of Limerick, with the donation and bishoprics and abbeys, except the city and one 



---

p.277



 

cantred of land adjoining; to Sir Hugh de Lacy all Meath; to Sir John de Courcy all Ulster; to William Burke Fitzadelm the greatest part of Connaught. In like manner, Sir Thomas de Clare obtained a grant of all Thomond; Otto de Grandison of all Tipperary: and Robert le Poer of the territory of Waterford, the city itself and the cantred of the Oostmen only excepted. And thus was all Ireland cantonised among ten persons of the 
English nation. And though they had not gained the possession of one-third part of the whole kingdom, yet in title they were owners and lords of all, so as nothing was left to be granted to the natives. And therefore we do not find in any record or story for the space of three hundred years after these adventurers first arrived in Ireland that any Irish lord obtained a grant of his country from the Crown, but only the King of Thomond, who had a grant but during King Henry the Third his minority; and Roderick O'Connor, King of Connaught, to whom King Henry the Second, before this distribution made, did grant, as is before declared, ‘Ut sit Rex sub eo;’[25](javascript:footNote('E610003/note025.html')) and, moreover, ‘Ut teneat terram suam Conactiae ita bene et in pace, sicut tenuit antequam Dominus Rex intravit Hiberniam.’[26](javascript:footNote('E610003/note026.html')) And whose successor, in the twenty-fourth of Henry the Third, when the Bourkes had made a strong plantation there, and had well-nigh expelled him out of his territory, he came over into England, as Matthew Paris writeth, and made complaint to King Henry the Third of this invasion made by the Bourkes upon his land, insisting upon the grants of King Henry the Second and King John, and affirming that he had duly paid a yearly tribute of five thousand marks for his kingdom. Whereupon the King called unto him the Lord Maurice Fitzgerald, who was then Lord-Justice of Ireland and President in the Court, and commanded him that he should root out that unjust plantation 



---

p.278




which Hubert Earl of Kent had in the time of his greatness planted in those parts, and wrote withal to the great men of Ireland to remove the Bourkes, and to establish the King of Connaught in the quiet possession of his kingdom. Howbeit, I do not read that 
the King of England's commandment or direction in this behalf was ever put in execution. For the truth is, Richard de Bargo had obtained a grant of all Connaught after the death of the King of Connaught then living, for which he gave a thousand 
pounds, as the record in the Tower reciteth, the third of Henry 3, claus. 2. And, besides, our great English lords could not endure that any Kings should reign in Ireland but themselves; nay, they could hardly endure that the Crown of England itself should 
have any jurisdiction or power over them. For many of these lords to whom our Kings had granted these petty kingdoms did, by virtue and colour of these grants, claim and exercise jura regalia within their territories, insomuch as there were no less than eight Counties Palatines in Ireland at one time.


For William Marshal, Earl of Pembroke, who married the daughter and heir of Strongbow, being Lord of all Leinster, had royal jurisdiction throughout all that province. This great Lord had five sons and five daughters. Every of his sons enjoyed that seigniory successively, and yet all died without issue. Then this great lordship was broken and divided, ,and partition made between the five daughters, who were married into the noblest houses of England. The county of Catherlough was allotted 
to the eldest, Wexford to the second, Kilkenny to the third, Kildare to the fourth, the greatest part of Leix, now called the Queen's County, to the fifth. In every of these portions the co-partners severally exercised the same jurisdiction royal which 
the Earl Marshal and his sons had used in the whole province. Whereby it came to pass that there were five Counties Palatines erected in Leinster. Then had the Lord of Meath the same royal liberty in all that territory, the Earls of Ulster in all that 



---

p.279



 

province, and the Lord of Desmond and Kerry within that county. All these appear upon record, and were all as ancient as the time of King John; only the Liberty of Tipperary, which is the only Liberty that remaineth at this day, was granted to James Butler, the first Earl of Ormond, in the third year of King Edward the Third.


These absolute Palatines made Barons and Knights, did exercise high justice in all points within their territories, erected courts for criminal and civil causes and for their own revenues, in the same form as the King's Courts were established at Dublin; made their own judges, seneschals, sheriffs, coroners, and escheators, so as the King's Writ did not run in those counties, which took up more than two parts of the English colonies, but only in the Church lands lying within the same, which were called the Cross, wherein the King made a sheriff. And so in each of these Counties Palatines there were two sheriffs, one of the Liberty and another of the Cross; as in Meath we find a sheriff of the Liberty and a sheriff of the Cross; and so in Ulster; and so in Wexford. And so at this day the Earl of Ormond maketh a sheriff of the Liberty, and the King a sheriff of the Cross, of Tipperary. Hereby it is manifest how much the King's jurisdiction was restrained and the power of these Lords enlarged by these high privileges. And it doth further appear by one Article among others preferred to King Edward the Third touching the reformation of the state of Ireland which we find in the Tower, in these words: ‘Item les francheses grantes in Ireland, que sont Roialles, idles come Duresme et Cestre, vous oustont cybien de les profits, come de graunde partie de obeissance des persons enfrancheses; et en quescun franchese est Chancellerie, Chequer et Conusans de Pleas, cybien de la Coronne, come autres communes, et grantont auxi charters de pardon; et sont souent per ley et reasonable cause seisses envostre main, a grand profit de vous; et leigerment restitues per maundement hors de Engleterre,



---

p.280




a damage’ &c. Unto which Article the King made answer: ‘Le Roy voet que les francheses que sont et serront per juste cause 
prises en sa main, ne soent my restitues, avant que le Roy soit certifie de la cause de la prise de icelles’ (26 Ed. 3, claus. m. 1). Again, these great undertakers were not tied to any form of plantation, but all was left to their discretion and pleasure; and although they builded castles and made freeholders, yet were there no tenures or services reserved to the Crown, but the Lords drew all the respect and dependency of the common people unto themselves. Now let us see what inconveniences did arise by these large and ample grants of lands and liberties to the first adventurers in the conquest. 


Assuredly by these grants of whole provinces and petty kingdoms those few English Lords pretended to be proprietors of all the land, so as there was no possibility left of settling the natives in their possessions, and by consequence the conquest became impossible without the utter extirpation of all the Irish, which these English Lords were not able to do, nor perhaps willing if they had been able. Notwithstanding, because they did still hope to become lords of those lands which were possessed by the 
Irish, whereunto they pretended title by their large grants, and because they did fear that if the Irish were received into the King's protection and made liegemen and free subjects, the State of England would establish them in their possessions by grants 
from the Crown, reduce their countries into counties, ennoble some of them, and enfranchise all, and make them amenable to the law, which would have abridged and cut off a great part of that greatness which they had promised unto themselves, they 
persuaded the King of England that it was unfit to communicate the laws of England unto them; that it was the best policy to hold them as aliens and enemies, and to prosecute them with a continual war. Hereby they obtained another royal prerogative and power, which was to make war and peace at their pleasure in 



---

p.281




every part of the kingdom, which gave them an absolute command over the bodies, lands, and goods of the English subjects here; and, besides, the Irish inhabiting the lands fully conquered and reduced, being in condition of slaves and villains, did render a greater profit and revenue than if they had been made the King's free subjects.


And for these two causes last expressed they were not willing to root out all the Irishry. We may not, therefore, marvel that when King Edward the Third, upon the petition of the Irish, as is before remembered, was desirous to be certified, ‘De voluntate magnatum suorum in proximo Parliamento in Hibernia tenend. si sine alieno praejudicio concedere possit, quod per statut. inde fact. Hibernici utantur legibus Anglicanis, sive chartis Regiis inde impetrandis,’[27](javascript:footNote('E610003/note027.html')) that there was never any Statute made to that effect; for the truth is, that those great English Lords did to the uttermost of their power cross and withstand the enfranchisement of the Irish for the causes before expressed, wherein I must still clear and acquit the Crown and State of England of negligence or ill policy, and lay the fault upon the pride, covetousness, and ill counsel of the English planted here, which in all former ages have been the chief impediments of the final conquest of Ireland.


Again, those large scopes of land and great liberties, with the absolute power to make war and peace, did raise the English Lords to that height of pride and ambition as that they could not endure one another, but grew to a mortal war and dissension among themselves, as appeareth by all the records and stories of this kingdom. First, in the year 1204 the Lacys of Meath made war upon Sir John Courcy, who, having taken him by treachery, sent him prisoner into England. In the year 1210 King John, coming over in person, expelled the Lacys out of the kingdom 

 


---

p.282




for their tyranny and oppression of the English; howbeit, upon payment of great fines, they were afterward restored. In the year 1228, that family being risen to a greater height for Hugh de Lacy the younger was created Earl of Ulster after the death of Courcy without issue there arose dissension and war between that House and William Marshal, Lord of Leinster, whereby all Meath was destroyed and laid waste. In the year 1264 Sir Walter Bourke, having married the daughter and heir of Lacy, whereby he was Earl of Ulster in right of his wife, had mortal debate with Maurice FitzMaurice the Geraldine for certain lands in Connaught; so as all Ireland was full of wars between the Bourkes and the Geraldines, say our annals. Wherein Maurice FitzMaurice grew so insolent, as that, upon a meeting at Thistledermot, he took the Lord-Justice himself, Sir Richard Capel, prisoner, with divers Lords of Munster being then in his company. In the year 1288 Richard Bourke, Earl of Ulster, commonly called the Red Earl, pretending title to the lordship of Meath, made war upon Sir Theobald de Verdun, and besieged him in the Castle of Athlone. Again, in the year 1292 John FitzThomas the Geraldine, having by contention with the Lord De Vesci gotten a goodly inheritance in Kildare, grew to that height of imagination, saith the story, as he fell into difference with divers great noblemen, and among many others with Richard the Red Earl, whom 
he took prisoner and detained him in Castle Lea; and by that dissension the English on the one side, and the Irish on the other, did waste and destroy all the country.


After, in the year 1311, the same Red Earl, coming to besiege Bonratty in Thomond, which was then held by Sir Richard de Clare as his inheritance, was again taken prisoner, and ail his army, consisting for the most part of English, overthrown and cut in pieces by Sir Richard de Clare. And after this again, in the year 1327, most of the great Houses were banded one against another, viz., the Geraldines, Butlers, and Breminghams on the 



---

p.283



 

one side, and the Bourkes and Poers on the other, the ground of the quarrel being none other but that the Lord Arnold Poer had called the Earl of Kildare Rhymer; but this quarrel was prosecuted with such malice and violence as the counties of Waterford and 
Kilkenny were destroyed with fire and sword, till a Parliament was called of purpose to quiet this dissension.


Shortly after, the Lord John Bremingham, who was not long before made Earl of Louth for that notable service which he performed upon the Scots between Dundalk and the Faber, was so extremely envied by the Gernons, Verdons, and others of the ancient colony planted in the county of Louth, as that in the year 1329 they did most wickedly betray and murder that Earl, with divers principal gentlemen of his name and family, using the same speech that the rebellious Jews are said to use in the Gospel, ‘Nolumus hunc regnare super nos.’[28](javascript:footNote('E610003/note028.html')) After this the Geraldines and the Butlers, being become the most potent families in the kingdom (for the great lordship of Leinster was divided among co-partners, whose heirs for the most part lived in England; and the earldom of Ulster, with the lordship of Meath, by the match of Lionel Duke of Clarence, at last descended upon the Crown) had almost a continual war one with another. In the time of King Henry the Sixth, saith Baron Finglas in his Discourse of the Decay of Ireland, in a fight between the Earls of Ormond and Desmond, almost all the townsmen of Kilkenny were slain, And as they followed contrary parties during the wars of York and Lancaster, so after that civil dissension ended in England these Houses in Ireland continued their opposition and feud still, even till the time of King Henry the Eighth, when by the marriage of Margaret Fitzgerald to the Earl of Ossory, the Houses of Kildare and Ormond were reconciled, and have continued in amity ever since.


Thus these great estates and royalties granted to the English 



---

p.284




lords in Ireland begat pride, and pride begat contention among themselves, which brought forth divers mischiefs, that did not only disable the English to finish the conquest of all Ireland, but did endanger the loss of what was already gained, and of conquerors, made them slaves to that nation which they did intend to conquer. For whensoever one English lord had vanquished another, the Irish waited and took the opportunity, and fell upon that country which had received the blow, and so daily recovered some part of the lands which were possessed by the English colonies.


Besides, the English lords, to strengthen their parties, did ally themselves with the Irish, and drew them in to dwell among them, gave their children to be fostered by them, and having no other means to pay or reward them, suffered them to take coigny and livery upon the English freeholders; which oppression was so intolerable as that the better sort were enforced to quit their freeholds and fly into England, and never returned, though many laws were made in both realms to remand them back again; and the rest which remained became degenerate and mere Irish, as is before declared. And the English lords, finding the Irish exactions to be more profitable than the English rents and services, and loving the Irish tyranny, which was tied to no rules of law or honour better than a just and lawful seigniory, did reject and cast off the English law and government, received the Irish laws and customs, took Irish surnames, as MacWilliam, MacFeris, MacYoris, refused to come to the Parliaments which were summoned by the King of England's authority, and scorned to obey those English knights which were sent to command and govern this kingdom; namely, Sir Richard Capel, Sir John Morris, Sir 
John Darcy, and Sir Ralph Ufford. And when Sir Anthony Lucy, a man of great authority in the time of King Edward the Third, was sent over to reform the notorious abuses of this kingdom, the King, doubting that he should not be obeyed, directed a 
special writ or mandate to the Earl of Ulster and the rest of the 



---

p.285



 

nobility to assist him. And afterwards, the same King, upon good advice and counsel, resumed those excessive grants of lands and liberties in Ireland, by a special ordinance made in England, which remaineth of record in the Tower in this form:[29](javascript:footNote('E610003/note029.html')) ‘Quia plures excessive donationes terrarum et libertatum in Hibernia ad subdolam machinationem petentium factae sunt, etc. Rex delusorias huiusmodo machinationes volens elidere, de consilio peritorum sibi assistentium, omnes donationes terrarum et libertatum praedict. duxit revocandas, quousque de meritis donatariorum et causis ac qualitatibus donationum melius fuerit informat. et ideo mandatum 
est Justiciario Hiberni quod seisiri faciat,’ &c. Howbeit, there followed upon this resumption such a division and faction between the English of birth and the English of blood and race, as they summoned and held several Parliaments apart one from the other. Whereupon there had risen a general war betwixt them, to the utter extinguishing of the English name and nation in Ireland, if the Earl of Desmond, who was head of the faction against the English of birth, had not been sent into England, and detained there for a time. Yet afterwards, these liberties being restored by direction out of England the twenty-sixth of Edward the Third, complaint was made to the King of the easy restitution; whereunto the King made answer as is before expressed: so as we may 
conclude this point with that which we find in the annals published by Master Camden: ‘Hibernici debellati et consumpti fuissent, nisi seditio Anglicorum impedivisset’[30](javascript:footNote('E610003/note030.html')) Whereunto I may add this note, that though some are of opinion that grants of extraordinary honours and liberties made by a King to his subjects do no more diminish his greatness than when one torch lighteth another, for it hath no less light thanrit had before — ‘Quis vetat apposito lumen de lumine sumi?’ —yet many times inconveniences do arise thereupon; 



---

p.286




and those Princes have held up their sovereignty best which have been sparing in those grants. And truly as these grants of little kingdoms and great royalties to a few private persons did produce the mischiefs spoken of before, so the true cause of the making of these grants did proceed from this, that the Kings of England, being otherwise employed and diverted, did not make the conquest of Ireland their own work, and undertake it not royally at their own charge; but as it was first begun by particular adventurers, so they left the prosecution thereof to them and other voluntaries who came to seek their fortunes in Ireland, wherein if they could prevail, they thought that in reason and honour they could do no less than make them proprietors of such scopes of land as they could conquer, people, and plant at their own charge, reserving only the sovereign lordship to the Crown of England. But if the lion had gone to hunt himself, the shares of the inferior beasts had not been so great. If the invasion had been made by an army transmitted, furnished, and supplied only at the King's charges and wholly paid with the King's treasure, as the armies of Queen Elizabeth and King James have been, as the conquest had been sooner achieved, so the servitors had been contented with lesser proportions.


For, when Scipio, Pompey, Caesar, and other generals of the Roman armies, as subjects and servants of that State, and with the public charge, had conquered many kingdoms and commonwealths, we find them rewarded with honourable offices and 
triumphs at their return, and not made lords and proprietors of whole provinces and kingdoms which they had subdued to the Empire of Rome. Likewise, when the Duke of Normandy had conquered England, which he made his own work and performed it in his own person, he distributed sundry lordships and manors unto his followers but gave not away whole shires and countries in demesne to any of his servitors whom he most desired to advance. Only he made Hugh Lupus County Palatine of 



---

p.287



 

Chester, and gave that earldom to him and his heirs, to hold the same, ‘Ita libere ad gladium, sicut Rex tenebat Angliam ad coronam;’ whereby that earldom indeed had a royal jurisdiction and seigniory, though the lands of that county in demesne were possessed for the most part by the ancient inheritors.


Again, from the time of the Norman Conquest till the reign of King Edward the First many of our English lords made war upon the Welshmen at their own charge. The lands which they gained they held to their own use, were called Lords Marchers, and had royal liberties within their lordships. Howbeit these particular adventurers could never make a perfect conquest of Wales.


But when King Edward the First came in person with his army thither, kept his residence and Court there, and made the reducing of Wales an enterprise of his own, he finished that work in a year or two, whereof the Lords Marchers had not performed a third part with their continual bordering war for two hundred years before. And withal, we may observe that though this King had now the dominion of Wales in jure proprietatis, as the Statute of Rutland affirmeth, which before was subject unto him, but in jure feodali; and though he had lost divers principal knights and noblemen in that war yet he did not reward his servitors with whole countries or counties but with particular manors and lordships; as to Henry Lacy, Earl of Lincoln, he gave the lordship of Denbigh, and to Reignold Gray the lordship of Ruthen, and so to others. And if the like course had been used in the winning and distributing of the lands of Ireland, that island had been fully conquered before the continent of Wales had been reduced. But the truth is, when private men attempt the conquest of countries at their own charge commonly their enterprises do perish without success; as when, in the time of Queen Elizabeth, Sir Thomas Smith undertook to recover the Ardes, and Chatterton to reconquer the Fues and Orier. The one lost his 



---

p.288




son, and the other himself, and both their adventures came to nothing. And as for the crown of England, it hath had the like fortune in the conquest of this land as some purchasers have who desire to buy land at too easy a rate; they find those cheap purchases so full of trouble as they spend twice as much as the land is worth before they get the quiet possession thereof.


And as the best policy was not observed in the distribution of the conquered lands, so I conceive that the first adventurers, intending to make a full conquest of the Irish, were deceived in the choice of the fittest places for their plantation. For they sat down and erected their castles and habitations in the plains and open countries, where they found most fruitful and profitable lands, and turned the Irish into the woods and mountains, which, as they were proper places for outlaws and thieves, so were they their natural castles and fortifications; thither they drave their preys and stealths; there they lurked and lay in wait to do mischief. These fast places they kept unknown by making the ways and entries thereunto impassable; there they kept their creaghts or herds of cattle, living by the milk of the cow, without husbandry or tillage; there they increased and multiplied unto infinite numbers by promiscuous generation among themselves; there they made their assemblies and conspiracies without discovery. But they discovered the weakness of the English dwelling in the open plains, and thereupon made their sallies and retreats with great advantage. Whereas, on the other side, if the English had built their castles and towns in those places of fastness, and had driven the Irish into the plains and 
open countries, where they might have had an eye and observation upon them, the Irish had been easily kept in order and in short time reclaimed from their wildness; there they would have used tillage, dwelt together in townships, learned mechanical arts and sciences. The woods had been wasted with the English habitations, as they are about the forts of Marlborough and 



---

p.289



 

Phillipstown, which were built in the fastest places in Leinster, and the ways and passages throughout Ireland would have been as clear and open as they are in England at this day.


Again, if King Henry the Second, who is said to be the King that conquered this land, had made forests in Ireland, as he did enlarge the forests in England (for it appeareth by Charta de Foresta that he afforested many woods and wastes, to the grievance of the subject, which by that law were disafforested), or if those English lords amongst whom the whole kingdom was divided had been good hunters, and had reduced the mountains, bogs, and woods within the limits of forests, chases, and parks, assuredly the very Forest Law, and the law de malefactoribus in parcis, would in time have driven them into the plains and countries inhabited and manured,[31](javascript:footNote('E610003/note031.html')) and have made them yield up their fast places to those wild beasts which were indeed less hurtful and wild than they. But it seemeth strange to me that in all the records of this kingdom I seldom find any mention made of a forest, and never of any park or free-warren, considering the great plenty both of vert and venison within this land, and that the chief of the nobility and gentry are descended of English race; and yet at this day there is but one park stored with deer in all this kingdom, which is a park of the Earl of Ormond's near 
Kilkenny. It is, then, manifest, by that which is before expressed, that the not communicating of the English laws to the Irish; the over-large grants of lands and liberties to the English; the plantation made by the English in the plains and open countries, leaving the woods and mountains to the Irish, were great defects in the 
civil policy, and hindered the perfection of the conquest very much. Howbeit, notwithstanding these defects and errors, the English colonies stood and maintained themselves in a reasonable good estate as long as they retained their own ancient laws and customs, according to that of Ennius, ‘Moribus antiquis res stat 



---

p.290




Romana virisque.’ But when the civil government grew so weak and so loose as that the English lords would not suffer the English laws to be put in execution within their territorities and seigniories, but in place thereof both they and their people 
embraced the Irish customs, then the estate of things, like a game at Irish, was so turned about as the English, which hoped to make a perfect conquest of the Irish, were by them perfectly and absolutely conquered, because ‘Victi victoribus leges dedere,’[32](javascript:footNote('E610003/note032.html')) a just punishment to our nation, that would not give laws to the Irish when they might; and therefore now the Irish gave laws to them. Therefore, this defect and failing of the English justice in the English colonies, and the inducing of the Irish customs in lieu thereof, was the main impediment that did arrest and stop the course of the conquest, and was the only mean that enabled the Irishry to recover their strength again.


For, if we consider the nature of the Irish customs, we shall find that the people which doth use them must of necessity be rebels to all good government, destroy the commonwealth wherein they live, and bring barbarism and desolation upon the richest 
and most fruitful land of the world. For, whereas by the just and honourable law of England, and by the laws of all other well-governed kingdoms and commonweals, murder, manslaughter, rape, robbery, and theft are punished with death, by 
the Irish custom, or Brehon Law, the highest of these offences was punished only by fine, which they called an **ericke**. Therefore, when Sir William Fitzwilliams, being Lord-Deputy, told Maguire that he was to send a sheriff into Fermanagh, being lately before made a county, ‘Your sheriff,’ said Maguire, ‘shall be welcome to me; but let me know his **ericke**, or the price of his head, aforehand, that if my people cut it off I may cut the **ericke** upon the country.’ As for oppression, extortion, and other trespasses, the weaker had never any remedy against the stronger; 



---

p.291



 

whereby it came to pass that no man could enjoy his life, his wife, his lands or goods in safety if a, mightier man than himself had an appetite to take the same from him. Wherein they were little better than cannibals, who do hunt one another, and he that hath most strength and swiftness doth eat and devour all his fellows.


Again, in England and all well-ordered commonweals men have certain estates in their lands and possessions, and their inheritances descend from father to son, which doth give them encouragement to build and to plant and to improve their lands, and to make them better for their posterities. But by the Irish custom of tanistry the chieftains of every country and the chief of every sept had no longer estate than for life in their chiefries, the inheritance whereof did rest in no man. And these chiefries, though they had some portions of land allotted unto them, did consist chiefly in cuttings and cosheries and other Irish exactions, whereby they did spoil and impoverish the people at their pleasure; and when their chieftains were dead their sons or next heirs did not succeed them, but their tanists, who were elective and purchased their elections by strong hand. And by the Irish custom of gavelkind the inferior tenantries were partible amongst all the males of the sept, both bastards and legitimate; and after partition made, if any one of the sept had died, his portion was not divided among his sons, but the chief of the sept made a new partition of all the lands belonging to that sept, and gave every one his part according to his antiquity.


These two Irish customs made all their possessions uncertain, being shuffled and changed and removed so often from one to another by new elections and partitions, which uncertainty of estates hath been the true cause of such desolation and barbarism in this land as the like was never seen in any country that professed the name of Christ; for though the Irishry be a nation of great antiquity and wanted neither wit nor valour, and though 



---

p.292




they had received the Christian faith above twelve hundred years since, and were lovers of music, poetry, and all kind of learning, and possessed a land abounding with all things necessary for the civil life of man, yet, which is strange to be related, they did never build any houses of brick or stone, some few poor religious houses excepted, before the reign of King Henry the Second, though they were lords of this island for many hundred years 
before and since the conquest attempted by the English. Albeit, when they saw us build castles upon their borders they have only, in imitation of us, erected some few piles for their captains of the country; yet I dare boldly say that never any particular person, either before or since, did build any stone or brick house for his private habitation but such as have lately obtained estates according to the course of the law of England. Neither did any 
of them in all this time plant any gardens or orchards, enclose or improve their lands, live together in settled villages or towns, nor make any provision for posterity, which, being against all common-sense and reason, must needs be imputed to those unreasonable customs which made their estates so uncertain and transitory in their possessions.


For who would plant or improve or build upon that land which a stranger whom he knew not should possess after his death? For that, as Solomon noteth, is one of the strangest vanities under the sun. And this is the true reason why Ulster and all the Irish countries are found so waste and desolate at this day, and so would they continue till the world's end if these customs were not abolished by the law of England.


Again, that Irish custom of gavelkind did breed another mischief, for thereby every man being born to land, as well bastard as legitimate, they all held themselves to be gentlemen; and though their portions were never so small and themselves never 
so poor — for gavelkind must needs in the end make a poor gentility — yet did they scorn to descend to husbandry or merchandise



---

p.293




or to learn any mechanical art or science. And this is the true cause why there were never any corporate towns erected in the Irish countries. As for the maritime cities and towns, most certain it is that they were built and peopled by the Oostmen or Easterlings, for the natives of Ireland never performed so good a work as to build a city. Besides, these poor gentlemen were so affected unto their small portions of land as they rather chose to live at home by theft, extortion, and coshering than to seek any better fortunes abroad, which increased their septs or surnames into such numbers as there are not to be found in any kingdom of Europe so many gentlemen of one blood, family, and surname as there are of the O'Neills in Ulster, of the Bourkes in Connaught, of the Geraldines and Butlers in Munster and Leinster. And the like may be said of the inferior bloods and families. Whereby it came to pass in times of trouble and dissension that they made great parties and factions adhering one to another with much constancy because they were tied together vinculo sanguinis; whereas rebels and malefactors which are tied to their leaders by no band, either of duty or blood, do more easily break and fall off one from another; and, besides, their cohabitation in one country or territory gave them opportunity suddenly to assemble and conspire and rise in multitudes against the Crown. And even now, in the time of peace, we find this inconvenience, that there can hardly be an indifferent trial had between the King and the subject, or between party and party, by reason of this general kindred and consanguinity.


But the most wicked and mischievous custom of all others was that of coigny and livery, often before mentioned, which consisted in taking of man's-meat, horse-meat, and money of all the inhabitants of the country at the will and pleasure of the soldier, who, as the phrase of Scripture is, ‘did eat up the people as it were bread,’ for that he had no other entertainment. This extortion was originally Irish, for they used to lay bonaght upon 



---

p.294




their people and never gave their soldier any other pay. But when the English had learned it they used it with more insolency and made it more intolerable; for this oppression was not temporary or limited either to place or time, but because there was everywhere a continual war, either offensive or defensive, and every lord of a country and every marcher made war and peace at his pleasure, it became universal and perpetual, and was indeed the most heavy oppression that ever was used in any Christian or heathen kingdom. And therefore, vox oppressorum, this crying sin did draw down as great or greater plagues upon Ireland than the oppression of the Israelites did draw upon the land of Egypt; for the plagues of Egypt, though they were grievous, were but of a short continuance, but the plagues of Ireland lasted four hundred years together. This extortion of coigny and livery did produce two notorious effects. First, it made the land waste; next it made the people idle. For when the husbandman had laboured all the year, the soldier in one night did consume the fruits of all his labour, longique perit labor irritus anni. Had he reason then to manure the land for the next year? Or rather might he not complain as the shepherd in "Virgil:" —


> 1. Impius haec tam culta novalia miles habebit?
>   
> Barbarus has segetes? En, quo discordia cives
>   
> Perduxit miseros! his nos consevimus agros![33](javascript:footNote('E610003/note033.html'))
> 




And hereupon of necessity came depopulation, banishment, and extirpation of the better sort of subjects, and such as remained became idle and lookers-on, expecting the event of those miseries and evil times; so as this extreme extortion and oppression hath been the true cause of the idleness of this Irish nation, and that rather the vulgar sort have chosen to be beggars 



---

p.295



 

in foreign countries than to manure[34](javascript:footNote('E610003/note034.html')) their own fruitful land at home.


Lastly, this oppression did of force and necessity make the Irish a crafty people; for such as are oppressed and live in slavery are ever put to their shifts, Ingenium mala saepe movent;[35](javascript:footNote('E610003/note035.html')) and therefore in the old comedies of Plautus and Terence the bond-slave doth always act the cunning and crafty part. Besides, all the common people have a whining tune or accent in their speech, as if they did still smart or suffer some oppression. And 
this idleness, together with fear of imminent mischiefs which did continually hang over their heads, have been the cause that the Irish were ever the most inquisitive people after news of any nation in the world; as St. Paul himself made observation upon the people of Athens, that they were an idle people, and did nothing but learn and tell news. And because these news-carriers did by their false intelligence many times raise troubles and rebellions in this realm, the Statute of Kilkenny doth punish news-tellers, by the name of skelaghes,[36](javascript:footNote('E610003/note036.html')) with fine and ransom.


This extortion of coigny and livery was taken for the maintenance of their men of war; but their Irish exactions, extorted by the chieftains and tanists by colour of their barbarous seigniory, were almost as grievous a burthen as the other, namely, cosherings, which were visitations and progresses made by the lord and his followers among his tenants, wherein he did eat them, as the English proverb is, out of house and home; cessings of the 
kern, of his family, called kernety, of his horses and horse-boys, of his dogs and dog-boys, and the like; and lastly, cuttings, tallages, or spendings, high or low, at his pleasure; all which made the lord an absolute tyrant and the tenant a very slave and villain, 
and in one respect more miserable than bond-slaves. For commonly



---

p.296




the bond-slave is fed by his lord, but here the lord was fed by his bond-slave.


Lastly, there were two other customs proper and peculiar to the Irishry, which being the cause of many strong combinations and factions, do tend to the utter ruin of a commonwealth; the one was fostering, the other gossipred, both which have ever been of greater estimation among this people than with any other nation in the Christian world. For fostering, I did never hear or read that it was in that use or reputation in any other country, barbarous or civil, as it hath been and yet is in Ireland, where they put away all their children to fosterers, the potent and rich men selling, the meaner sort buying, the alterage[37](javascript:footNote('E610003/note037.html')) of their children. And the reason is because in the opinion of this people fostering hath always been a stronger alliance than blood, and the foster-children do love and are beloved of their foster-fathers and their sept more than of their own natural parents and kindred, and do participate of their means more frankly, and do adhere unto them in all fortunes with more affection and constancy. And though Tully in his book of Friendship doth observe that children of Princes being sometimes, in cases of necessity, for saving of their lives, delivered to shepherds to be nourished and bred up, when they have been restored to their great fortunes have still retained their love and affection to their fosterers, whom for many years they took to be their parents; yet this was a rare case, and few examples are to be found thereof.


But such a general custom in a kingdom, in giving and taking children to foster, making such a firm alliance as it doth in Ireland, was never seen or heard of in any other country of the world besides.


The like may be said of gossipred or compaternity, which though by the Canon Law it may be a spiritual affinity, and a juror 



---

p.297



 

that was gossip to either of the parties might in former times have been challenged as not indifferent by our law, yet there was no nation under the sun that ever made so religious account thereof as the Irish.


Now, these two customs, which of themselves are indifferent in other kingdoms, became exceeding evil and full of mischief in this realm by reason of the inconveniences which followed thereupon. For they made, as I said before, strong parties and factions, whereby the great men were enabled to oppress their inferiors and to oppose their equals and their followers were borne out and countenanced in all their lewd and wicked actions. For fosterers and gossips, by the common custom of Ireland, were to maintain one another in all causes lawful and unlawful, which, as it is a combination and confederacy punishable in all well-governed commonweals, so was it not one of the least causes of the common misery of this kingdom.


I omit their common repudiation of their wives; their promiscuous generation of children; their neglect of lawful matrimony; their uncleanness in apparel, diet, and lodging; and their contempt and scorn of all things necessary for the civil life of man.


These were the Irish customs which the English colonies did embrace and use after they had rejected the civil and honourable laws and customs of England, whereby they became degenerate and metamorphosed like Nebuchadnezzar, who, although he had the face of a man, had the heart of a beast; or like those who had drunk of Circe's cup, and were turned into very beasts, and yet took such pleasure in their beastly manner of life as they would not return to their shape of men again; insomuch as within less time than the age of a man they had no marks or differences left amongst them of that noble nation from which they were descended. For, as they did not only forget the English language and scorn the use thereof, but grew to be ashamed of their very English names, though they were noble and of great antiquity, and took Irish 



---

p.298




surnames and nicknames. Namely, the two most potent families of the Bourkes in Connaught, after the House of the Red Earl failed of heirs-males, called their chiefs MacWilliam Eighter and Mac-William Oughter. In the same province, Bremingham, Baron of Athenrie, called himself MacYoris; Dexecester, or De'exon, was called MacJordan; Dangle, or De Angulo, took the name of MacCostelo. Of the inferior families of the Bourkes, one was called MacHubbard, another MacDavid. In Munster, of the great families of the Geraldines planted there, one was called MacMorice, chief of the House of Lixnaw; and another MacGibbon, who was also called the White Knight. The chief of the Baron of Dunboyne's house, who is a branch of the House of Ormond, took the surname of MacFeris. Condon, of the county of Waterford, was called MacMaioge; and the Archdeacon of the county of Kilkenny, MacOdo. And this they did in contempt and hatred of the English name and nation, whereof these degenerate families became more mortal enemies than the mere Irish. And whereas the State and Government, being grown weak by their defection, did, to reduce them to obedience, grant them many protections and pardons, the cheapness whereof in all ages hath brought great dishonour and damage to this commonweal, they grew so ungrateful and unnatural as in the end they scorned that grace and favour, because the acceptance thereof did argue them to be subjects, and they desired rather to be accounted enemies than rebels to the Crown of England.


Hereupon was that old verse made which I find written in the White-book of the Exchequer, in a hand as ancient as the time of King Edward the Third: —


> 1. By graunting charters of peas
>   
> To false English, withouten leas,
>   
> This land shall be mich undoo.
>   
> But gossipred, and alterage,
>   
> And leesing of our language,
>   
> Have mickly holp theretoo.
> 




---

p.299



 

And therefore, in a Close-Roll in the Tower, bearing this title, Articuli in Hibernia observandi we find these two articles among others — 
1. Justiciarius Hiberniae non concedat perdonationes de morte hominis, nec de Roberiis, seu incendiis, et quod de caetero certificet dominum regem de nominibus petentium. 2. Item, Quod nec Justiciarius nec aliquis Magnas Hiberniae concedat protectiones alicui contra pacem Regis existent.[38](javascript:footNote('E610003/note038.html')) &c. But now it is fit to look back and consider when the old English colonies became so degenerate, and in what age they fell away into that Irish barbarism, rejecting the English laws and customs. Assuredly, by comparing the ancient annals of Ireland with the records remaining here and in the Tower of London, I do find that this general defection fell out in the latter end of the reign of King Edward the Second and in the beginning of the reign of King Edward the Third. And all this great innovation grew within the space of thirty years, within the compass of which time there fell out divers mischievous accidents, whereby the whole kingdom was in a manner lost. For, first, Edward de Bruce invaded Ireland with the Scottish army, and prevailed so far as that he possessed the maritime parts of Ulster, marched up to the walls of Dublin, spoiled the English Pale, passed through Leinster and Munster as far as Limerick, and was master of the field in every part of the kingdom.


This happened in the tenth year of King Edward the Second, at what time the Crown of England was weaker and suffered more dishonour in both kingdoms than it did at any time since the Norman Conquest. Then did the State of England send over John de Hotham to be Treasurer here, with commission to call the great lords of Ireland together, and to take of them an oath of association, that they should loyally join together in life and 



---

p.300




death to preserve the right of the King of England and to expel the common enemy. But this Treasurer brought neither men nor money to perform this service.


At that time, though Richard Bourke, Earl of Ulster, commonly called the Red Earl, was of greater power than any other subject in Ireland, yet was he so far stricken in years as that he was unable to manage the martial affairs, as he had done during all the reign of King Edward the First, having been General of the Irish forces, not only in this kingdom, but in the wars of Scotland, Wales, and Gascogne. And therefore Maurice Fitz-Thomas of Desmond, being then the most active nobleman in this realm, took upon him the chief command in this war, for the support whereof the revenue of this land was far too short, and yet no supply of treasure was sent out of England.


Then was there no mean to maintain the army but by cessing the soldiers upon the subject, as the Irish were wont to impose their **bonaght**. Whereupon grew that wicked extortion of coigny and livery spoken of before, which in short time banished the greatest part of the freeholders out of the county of Kerry, Limerick, Cork, and Waterford; into whose possessions Desmond and his kinsmen, allies, and followers, which were then more Irish than English, did enter and appropriate these lands unto themselves, Desmond himself taking what scopes he best liked for his demesnes in every country, and reserving an Irish seigniory out of the rest. And here, that I may verify and maintain by matter of record that which is before delivered touching the nature of this wicked extortion called coigny and livery, and the manifold mischiefs it did produce, I think it fit and pertinent to insert the preamble of the Statute of the tenth of Henry the Seventh, c. 4, not printed, but recorded in Parliament Rolls of Dublin, in these words: ‘At the request and supplication of the Commons of this land of Ireland, that where of long time there hath been used and exacted by the lords and gentlemen of this land many and 



---

p.301



 

divers damnable customs and usages, which being called coigny and livery and pay; that is, horse-meat and man's-meat, for the finding of their horsemen and footmen; and over that 4d. or 6d. daily to every of them to be had and paid of the poor earth-tillers and tenants, inhabitants of the said land, without anything doing or paying thereof; besides many murders, robberies, rapes, and other manifold extortions and oppressions by the said horsemen and footmen, daily and mightily committed and done; which being the principal causes of the desolation and destruction of the said land, and hath brought the same into ruin and decay, so as the most part of the English freeholders and tenants of this land being departed out thereof, some into the realm of England, and other some to other strange lands; whereupon the foresaid lords and gentlemen of this land have intruded into the said freeholders' and tenants' inheritances, and the same keepeth and occupieth as their own inheritances, and setting under them in the same land the King's Irish enemies, to the diminishing of Holy Church's rites, the disherison of the King and his obedient subjects, and the utter ruin and desolation of the land: For reformation whereof be it enacted, that the King shall receive a subsidy of 26s. 8d. out of every hundred and twenty acres of 
arable land manured,’ &c.


But to return to Maurice Fitz-Thomas of Desmond; by this extortion of coigny and livery he suddenly grew from a mean to a mighty estate; insomuch as the Baron Finglas, in his Discourse of the decay of Ireland, affirmeth that his ancient inheritance being not one thousand marks yearly, he became able to dispend every way ten thousand pounds per annum.


These possessions, being thus unlawfully gotten, could not be maintained by the just and honourable law of England, which would have restored the true owners to their land again. And therefore this great man found no means to continue and uphold his ill-purchased greatness but by rejecting the English law and 



---

p.302




government, and assuming in lieu thereof the barbarous customs of the Irish. And hereupon followed the defection of those four shires containing the greatest part of Munster from the obedience of the law.


In like manner, saith Baron Finglas, the Lord Tipperary, perceiving how well the House of Desmond had thrived by coigny and livery and other Irish exactions, began to hold the like course in the counties of Tipperary and Kilkenny, whereby he got great scopes of land, especially in Ormond, and raised many Irish exactions upon the English freeholders there, which made him so potent and absolute among them as at that time they knew no other law than the will of their Lord. Besides, finding that the Earl of Desmond excluded the ordinary ministers of justice, under colour of a Royal Liberty which he claimed in the counties of Kerry, Cork, and Waterford, by a grant of King Edward the First, as appeareth in a Quo warranto? brought against him, anno 12, Edward the First, the record whereof remaineth in Bremingham's Tower, among the Common Plea Rolls there, this Lord also, in the third of Edward the Third, obtained a grant of the like Liberty in the county of Tipperary, whereby he got the law into his own hands and shut out the Common Law and justice of the realm.


And thus we see that all Munster fell away from the English law and government in the end of King Edward the Second his reign, and in the beginning of the reign of King Edward the Third. Again, about the same time, viz., in the twentieth year of King Edward the Second, when the state of England was well-nigh ruined by the rebellion of the Barons, and the government of Ireland utterly neglected, there arose in Leinster one of the Cavanaghs named Donald MacArt, who named himself MacMurrough, King of Leinster, and possessed himself of the county of Catherlough, and of the greatest part of the county of Wexford. And shortly after, Lisagh O' Moore called himself O'Moore, 



---

p.303



 

took eight castles in one evening, destroyed Dunamase, the principal house of the Lord Mortimer in Leix, recovered that whole country, ‘de servo dominus, de subjecto princeps effectus’[39](javascript:footNote('E610003/note039.html')) saith **Friar Clynne** in his annals.


Besides, the Earl of Kildare, imitating his cousin of Desmond, did not omit to make the like use of coigny and livery in Kildare and the west part of Meath, which brought the like barbarism into those parts. And thus a great part of Leinster was lost and fell away from the obedience of the Crown near about the time before expressed.


Again, in the seventh year of King Edward the Third the Lord William Bourke, Earl of Ulster and Lord Connaught, was treacherously murdered by his own squires at Knockfergus, leaving behind him ‘unicam et unius anni filiam’,[40](javascript:footNote('E610003/note040.html')) saith **Friar Clynne**. Immediately upon the murder committed, the Countess with her young daughter fled into England, so as the government of that country was wholly neglected until that young lady being married to Lionel Duke of Clarence, that Prince came over with an army to recover his wife's inheritance and to reform this kingdom, anno 36 of Edward the Third. But in the meantime what became of that great inheritance both in Ulster and Connaught? Assuredly, in Ulster the sept of Hugh-Boy O'Neill, then possessing Glaucoukeyn and Killeightra in Tyrone, took the opportunity, and passing over the Bann did first expel the English out of the Barony of Tuscard, which is now called the Rout, and likewise out of the glynnes and other lands up as far as Knockfergus, which country or extent of land is at this day called the Lower Clan Hugh-Boy. And shortly after that they came up into the Great Ardes, which the Latin writers call ‘Altitudines Ultoniae’, and was then the inheritance of the Savages, by whom they were valiantly resisted for divers years; but at last, for 



---

p.304




want of castles and fortifications — for the saying of Henry Savage mentioned in every story is very memorable, that a castle of bones was better than a castle of stones — the English were overrun by the multitude of the Irishry. So as about the thirtieth of King Edward the Third, some few years before the arrival of the Duke of Clarence, the Savages were utterly driven out of the Great Ardes into a little nook of land near the river of Strangford, where they now possess a little territory called the Little Ardes; and their greater patrimony took the name of the Upper Clan Hugh-Boy from the sept of Hugh-Boy O'Neill, who became invaders thereof.


For Connaught, some younger branches of the family of the Bourkes being planted there by the Red Earl and his ancestors, seeing their chief to be cut off and dead without heir-male and no man left to govern or protect that province, intruded presently into all the Earl's lands, which ought to have been seized into the King's hands by reason of the minority of the heir. And within a short space two of the most potent among them divided that great seigniory betwixt them, the one taking the name of MacWilliam Oughter and the other of MacWilliam Eighter, as if the Lord William Bourke, the last Earl of Ulster, had left two sons of one name behind him to inherit that lordship in course of gavelkind. But they well knew that they were but intruders upon the King's possession during the minority of the heir; they knew those lands were the rightful inheritance of that young lady, and, consequently, that the law of England would speedily evict them out of their possession; and therefore they held it the best policy to cast off the yoke of English law and to become mere Irish, and according to their example drew all the rest of the English in that province to do the like, so as from thenceforth they suffered their possessions to run in course of tanistry and gavelkind. They changed their names, language, and apparel, and all their civil manners and customs of living. Lastly, about 



---

p.305



 

the twenty-fifth year of King Edward the Third, Sir Richard de Clare was slain in Thomond, and all the English colonies there utterly supplanted.


Thus in that space of time which was between the tenth year of King Edward the Second and the thirtieth year of King Edward the Third (I speak within compass), by the concurrence of the mischiefs before recited, all the old English colonies in Munster, Connaught, and Ulster, and more than a third part of Leinster became degenerate and fell away from the Crown of England; so as only the four shires of the English Pale remained under the obedience of the law; and yet the borders and marches thereof were grown unruly and out of order too, being subject to black-rents and tribute of the Irish, which was a greater defection than when ten of twelve tribes departed and fell away from the Kings of Judah.


But was not the State of England sensible of this loss and dishonour? Did they not endeavour to recover the land that was lost and to reduce the subjects to their obedience?


Truly, King Edward the Second, by the incursions of the Scottish nation and by the insurrection of his barons, who raised his wife and his son against him, and in the end deposed him, was diverted and utterly disabled to reform the disorders of Ireland. But as soon as the Crown of England was transferred to King Edward the Third, though he were yet in his minority, the State there began to look into the desperate estate of things here, and finding such a general defection, letters were sent from the King to the great men and prelates requiring them particularly to swear fealty to the Crown of England.


Shortly after, Sir Anthony Lucy, a person of great authority in England in those days, was sent over to work a reformation in this kingdom by a severe course, and to that end the King wrote expressly to the Earl of Ulster and others of the nobility to assist him, as is before remembered. Presently upon his arrival he 



---

p.306




arrested Maurice Fitz-Thomas, Earl of Desmond, and Sir William Bremingham, and committed them prisoners to the castle of Dublin, where Sir William Bremingham was executed for treason, though the Earl of Desmond was left to mainprise, upon condition he should appear before the King by a certain day and in the meantime to continue loyal.


After this, the King being advertised that the over-large grants of lands and liberties made to the lords of English blood in Ireland made them so insolent as they scorned to obey the law, the magistrate did absolutely resume all such grants, as is before declared. But the Earl of Desmond above all men found himself grieved with this resumption or repeal of liberties, and declared his dislike and discontent, insomuch as he did not only refuse to come to a Parliament at Dublin summoned by Sir William Morris, Deputy to the Lord John Darcy, the King's Lieutenant; but, as we have said before, he raised such dissension between the English of blood and the English of birth as the like was never seen from the time of the first planting of our nation in Ireland. And in this factious and seditious humour, he drew the Earl of Kildare and the rest of the nobility, with the citizens and burgesses of the principal towns, to hold a several Parliament by themselves at Kilkenny, where they framed certain articles against the Deputy, and transmitted the same into England to the King.


Hereupon Sir Ralph Ufford, who had lately before married the Countess of Ulster, a man of courage and severity, was made Lord-Justice, who forthwith calling a Parliament, sent a special commandment to the Earl of Desmond to appear in that great Council; but the Earl wilfully refused to come. Whereupon the Lord-Justice raised the King's standard, and marching with an army into Munster, seized into the King's hands all the possessions of the Earl, took and executed his principal followers, Sir Eustace le Poer, Sir William Grant, and Sir John Cotterell; enforced



---

p.307




the Earl himself to fly and lurk, till twenty-six noblemen and knights became mainpernors[41](javascript:footNote('E610003/note041.html')) for his appearance at a certain day prefixed; but he making default the second time, the uttermost advantage was taken against his sureties. Besides, at the same time, this Lord-Justice caused the Earl of Kildare to be arrested and committed to the Castle of Dublin, indited and imprisoned many other disobedient subjects, called in and cancelled such Charters as were lately before resumed, and proceeded every way so roundly and severely as the nobility, which were wont to suffer no controlment, did much distaste him; and the commons, who in this land have ever been more devoted to their immediate lords here, whom they saw every day, than unto their Sovereign Lord and King, whom they never saw, spake ill of this governor as of a rigorous and cruel man, though in truth he were a singular good Justicer, and if he had not died in the second year of his government, was the likeliest person of that age to have reformed and reduced the degenerate English colonies to their natural obedience of the Crown of England.


Thus much, then, we may observe, by the way, that Maurice Fitz-Thomas, the first Earl of Desmond, was the first English Lord that imposed coigny and livery upon the King's subjects, and the first that raised his estate to immoderate greatness by that wicked extortion and oppression; that he was the first that rejected the English laws and government, and drew others by his example to do the like; that he was the first peer of Ireland that refused to come to the Parliament summoned by the King's authority; that he was the first that made a division and distinction between the English of blood and the English of birth.


And as this Earl was the only author and first actor of these mischiefs which give the greatest impediment to the full conquest 



---

p.308




of Ireland, so it is to be noted that, albeit others of his rank afterwards offended in the same kind, whereby their houses were many times in danger of ruin, yet was there not ever any noble house of English race in Ireland utterly destroyed and finally rooted out by the hand of justice but the House of Desmond only, nor any peer of this realm ever put to death — though divers have been attainted — but Thomas Fitz-James, the Earl of Desmond, only; and only for those wicked customs brought in by the first Earl and practised by his posterity, though by several laws they were made high treason. And therefore, though in the seventh of Edward the Fourth, during the government of the Lord Tiptoft, Earl of Worcester, both the Earls of Desmond and Kildare were attainted by Parliament at Drogheda for alliance and fostering with the Irish, and for taking coigny and livery of the King's subjects, yet was Desmond only put to death, for the Earl of Kildare received his pardon. And albeit the son of this Earl of Desmond who lost his head at Drogheda was restored to the earldom, yet could not the King's grace regenerate obedience in that degenerate house, but it grew rather more wild and barbarous than before. For from thenceforth they reclaimed a strange privilege, that the Earls of Desmond should never come to any Parliament or Grand Council or within any walled town but at their will and pleasure. Which pretended privilege James Earl of Desmond, the father of Gerald, the last Earl, renounced 
and surrendered by his deed in the Chancery of Ireland in the thirty-second of Henry the Eighth. At what time, among the mere Irishry, he submitted himself to Sir Anthony Saint-Leger, then Lord-Deputy, took an oath of allegiance, covenanted that he would suffer the law of England to be executed in his country and assist the King's judges in their circuits, and if any subsidies should be granted by Parliament, he would permit the same to be levied upon his tenants and followers. Which covenants are as strange as the privilege itself spoken of before. But that which 



---

p.309




I conceive most worthy of observation upon the fortunes of the House of Desmond is this, that as Maurice Fitz-Thomas, the first Earl, did first raise the greatness of that house by Irish exactions and oppressions, so Gerald, the last Earl, did at last ruin and reduce it to nothing by using the like extortions. For certain it is that the first occasion of this rebellion grew from hence, that when he attempted to charge the Decies in the county of Waterford with coigny and livery, black-rents and cosheries, after the Irish manner, he was resisted by the Earl of Ormond, and upon an encounter overthrown and taken prisoner, which made his heart so unquiet as it easily conceived treason against the Crown and brought forth actual and open rebellion, wherein he perished himself and made a final extinguishment of his house and honour. Oppression and extortion did maintain the greatness, and oppression and extortion did extinguish the greatness, of that house. Which may well be expressed by the old emblem of a torch turned downwards with these words, ‘Quod me alit, extinguit.’[42](javascript:footNote('E610003/note042.html')) Now let us return to the course of reformation held and pursued here after the death of Sir Ralph Ufford, which happened in the twentieth year of King Edward the Third; after which time, albeit all the power and counsel of England was converted towards the conquest of France, yet was not the work of reformation altogether discontinued. For, in the twenty-fifth year of King Edward the Third, Sir Thomas Rookeby, another worthy governor whom I have once before named, held a Parliament at Kilkenny, wherein many excellent laws were propounded and enacted for the reducing of the English colonies to their obedience, which laws we find enrolled in the Remembrancer's Office here, and differ not much in substance from those other Statutes of Kilkenny which not long after, during the government of Lionel Duke of Clarence, were not only enacted but put in execution. This noble Prince, having married the daughter and heir of Ulster, and being likewise



---

p.310




a copartner[43](javascript:footNote('E610003/note043.html')) of the county of Kilkenny, in the thirty-sixth year of King Edward the Third came over the King's Lieutenant, attended with a good retinue of martial men, as is before remembered, and a grave and honourable counsel as well for peace as for war. But because this army was not of a competent strength to break and subdue all the Irishry, although he quieted the borders of the English Pale and held all Ireland in awe with his name and presence, the principal service that he intended was to reform the degenerate English colonies and to reduce them to obedience of the English law and magistrate. To that end, in the fortieth year of King Edward the Third, he held that famous Parliament at Kilkenny wherein many notable laws were enacted, which do show and lay open (for the law doth best discover enormities) how much the English colonies were corrupted at that time, and do infallibly prove that which is laid down before, that they were wholly degenerate and fallen away from their obedience. For first, it appeareth by the preamble of these laws that the English of this realm, before the coming over of Lionel Duke of Clarence, were at that time become mere Irish in their language, names, apparel, and all their manner of living, and had rejected the English laws and submitted themselves to the Irish, with whom they had many marriages and alliances, which tended to the utter ruin and destruction of the commonwealth. Therefore, alliance by marriage, nurture of infants, and gossipred with the Irish are by this Statute made high treason. Again, if any man of English race should use an Irish name, Irish language, or Irish apparel, or any other guise or fashion of the Irish, if he had lands or tenements, the same should be seized till he had given security to the Chancery to conform himself in all points to the 



---

p.311



 

English manner of living; and if he had no lands, his body was to be taken and imprisoned till he found sureties as aforesaid.


Again, it was established and commanded that the English in all their controversies should be ruled and governed by the Common Law of England, and if any did submit himself to the Brehon Law or March Law he should be adjudged a traitor.


Again, because the English at that time made war and peace with the bordering enemy at their pleasure, they were expressly prohibited to levy war upon the Irish without special warrant and direction from the State.


Again, it was made penal to the English to permit the Irish to creaght or graze upon their lands; to present them to ecclesiastical benefices, to receive them into any monasteries or religious houses, or to entertain any of their minstrels, rhymers, or news-tellers. To impose or cess any horse or foot upon the English subjects against their wills was made felony. And because the great liberties or franchises spoken of before were become sanctuaries for all malefactors, express powers were given to the King's sheriffs to enter into all franchises, and there to apprehend all felons and traitors. And lastly, because the great lords, when they levied forces for the public service, did lay unequal burdens upon the gentlemen and freeholders, it was ordained that four wardens of the peace in every county should set down and appoint what men and armour every man should bear according to his freehold or other ability of estate.


These and other laws tending to a general reformation were enacted in that Parliament. And the execution of these laws, together with the presence of the King's son, made a notable alteration in the state and manners of this people within the space of seven years, which was the term of this Prince's Lieutenancy.


For all the discourses that I have seen of the decay of Ireland do agree in this, that the presence of the Lord Lionel and these statutes of Kilkenny did restore the English government in the 



---

p.312




degenerate colonies for divers years. And the Statute of the tenth of Henry the Seventh, which reviveth and confirmeth the Statutes of Kilkenny, doth confirm as much. For it declareth, that as long as these laws were put in use and execution, this land continued in prosperity and honour; and since they were not executed, the subjects rebelled and digressed from their allegiance and the land fell to ruin and desolation. And, withal, we find the effect of these laws in the Pipe-Rolls and Plea-Rolls of this kingdom; for, from the thirty-sixth of Edward the Third, when this Prince entered into his government, till the beginning of Richard the Second his reign, we find the revenue of the Crown, both certain and casual, in Ulster, Munster, and Connaught accounted for; and that the King's Writ did run and the Common Law was executed in every of these provinces. I join with these laws the personal presence of the King's son as a concurrent cause of this reformation; because the people of this land, both English and Irish, out of a natural pride, did ever love and desire to be governed by great persons. And therefore I may here justly take occasion to note, that the absence first of the Kings of England, and next the absence of those great lords who were inheritors of those mighty seigniories of Leinster, Ulster, Connaught, and Meath, have been main causes why this kingdom was not reduced in so many ages.


Touching the absence of our Kings, three of them only since the Norman Conquest have made royal journeys into this land; namely, King Henry the Second, King John, and King Richard the Second. And yet they no sooner arrived here but that all the Irishry, as if they had been but one man, submitted themselves, took oaths of fidelity, and gave pledges and hostages to continue loyal. And if any of those kings had continued here in person a competent time, till they had settled both English and Irish in their several possessions, and had set the law in a due course throughout the kingdom, these times wherein we live had 



---

p.313




not gained the honour of the final conquest and reducing of Ireland. For the King, saith Solomon, ‘dissipat omne malum intuitu suo.’[44](javascript:footNote('E610003/note044.html')) But when Moses was absent in the mount the people committed idolatry, and when there was no King in Israel every man did what seemed best in his own eyes.


And therefore, when Alexander had conquered the East part of the world and demanded of one what was the fittest place for the seat of his empire, he brought and laid a dry hide before him, and desired him to set his foot on the one side thereof: which being done, all the other parts of the hide did rise up; but when he did set his foot in the middle of the hide, all the other parts lay flat and even. Which was a lively demonstration that if a Prince keep his residence in the border of his dominions, the remote parts will easily rise and rebel against him; but if he make the centre thereof his seat, he shall easily keep them in peace and obedience. 


Touching the absence of the great lords, all writers do impute the decay and loss of Leinster to the absence of the English lords who married the five daughters of William Marshal, Earl of Pembroke, to whom that great seigniory descended, when his five sons, who inherited the same successively, and during their times held the same in peace and obedience to the law of England, were all dead without issue, which happened about the fortieth year of King Henry the Third. For, the eldest being married to Hugh Bigot, Earl of Norfolk, who in right of his wife had the Marshalship of England; the second to Warren de Mountchensey, whose sole daughter and heir was matched to William de Valentia, half-brother to King Henry the Third, who by that match was made Earl of Pembroke; the third to Gilbert de Clare, Earl of Gloucester; the fourth to William Ferrers, Earl of Derby; the fifth to William de Bruce, Lord of Brecknock, 



---

p.314




these great lords, having greater inheritances in their own right in England than they had in Ireland in right of their wives — and yet each of the coparceners had an entire county allotted for her purparty,[45](javascript:footNote('E610003/note045.html')) as is before declared — could not be drawn to make their personal residence in this kingdom, but managed their estates here by their seneschals and servants. And to defend their territories against the bordering Irish they entertained some of the natives, who pretended a perpetual title to those great lordships; for the Irish, after a thousand conquests and attainders by our law, would in those days pretend title still, because by the Irish law no man could forfeit his land. These natives, taking the opportunity in weak and desperate times, usurped those seigniories; and so Donald MacArt Cavanagh, being entertained by the Earl of Norfolk, made himself lord of the county of Catherlough; and Lisagh O'Moore, being trusted by the Lord Mortimer, who married the daughter and heir of the Lord Bruce, made himself lord of the lands in Leix in the latter end of King Edward the Second's reign, as is before declared.


Again, the decay and loss of Ulster and Connaught is attributed to this, that the Lord William Bourke, the last Earl of that name, died without issue male, whose ancestors, namely, the Red Earl and Sir Hugh de Lacy, before him, being personally resident, held up their greatness there and kept the English in peace and the Irish in awe. But when those provinces descended upon an heir-female and an infant, the Irish overran Ulster and the younger branches of the Bourkes usurped Connaught. And, therefore, the ordinance made in England the third of Richard the Second against such as were absent from their lands in Ire-land, and gave two-third parts of the profits thereof unto the King until they returned or placed a sufficient number of men to defend the same, was grounded upon good reason of State; which ordinance was put in execution for many years after, as appeareth 



---

p.315




by sundry seizures made thereupon in the time of King Richard the Second, Henry the Fourth, Henry the Fifth, and Henry the Sixth, whereof there remain records in the Remembrancer's Office here. Among the rest the Duke of Norfolk himself was not spared, but was impleaded upon this ordinance for two parts of the profits of Dorburies Land and other lands in the county of Wexford in the time of King Henry the Sixth; and afterwards, upon the same reason of State, all the lands of the House of Norfolk, of the Earl of Shrewsbury, the Lord Barkly, and others, who, having lands in Ireland, kept their continual residence in England, were entirely resumed by the Act of Absentees made in the twenty-eighth year of King Henry the Eighth.


But now again let us look back and see how long the effect of that reformation did continue which was begun by Lionel Duke of Clarence in the fortieth year of King Edward the Third, and what courses have been held to reduce and reform this people by other Lieutenants and governors since that time..


The English colonies, being in some good measure reformed by the Statutes of Kilkenny, did not utterly fall away into barbarism again till the wars of the two houses had almost destroyed both these kingdoms; for in that miserable time the Irish found opportunity, without opposition, to banish the English law and government out of all the provinces, and to confine it only to the English Pale. Howbeit, in the meantime, between the government of the Duke of Clarence and the beginning of those civil wars of York and Lancaster, we find that the State of England did sundry times resolve to proceed in this work of reformation..


For, first, King Richard the Second sent over Sir Nicholas Dagworth to survey the possessions of the Crown and to call to account the officers of the Revenue. Next, to draw his English subjects to manure and defend their lands in Ireland, he made that ordinance against absentees spoken of before. Again, he, 



---

p.316




showed an excellent example of justice upon Sir Philip Courtney, being his lieutenant of that kingdom, when he caused him to be arrested by special commissioners, upon complaint made of sundry grievous oppressions and wrongs which during his government he had done unto that people.


After this the Parliament of England did resolve that Thomas Duke of Gloucester, the King's uncle, should be employed in the reformation and reducing of that kingdom; the same whereof was no sooner bruited in Ireland but all the Irishry were ready to submit themselves before his coming; so much the very name of a great personage, specially of a Prince of the blood, did ever prevail with this people. But the King and his minions, who were ever jealous of this Duke of Gloucester, would not suffer him to have the honour of that service. But the King himself thought it a work worthy of his own presence and pains, and thereupon himself in person made those two royal journeys mentioned before. At what time he received the submissions of all the Irish lords and captains, who bound themselves both by indenture and oath to become and continue his loyal subjects; and withal laid a particular project for a civil plantation of the mountains and maritime counties between Dublin and Wexford, by removing all the Irish septs from thence, as appeareth by the covenants between the Earl Marshal of England and those Irish septs, which are before remembered, and are yet preserved and remain of record in the King's Remembrancer's Office at Westminster. Lastly, this King, being present in Ireland, took special care to supply and furnish the courts of justice with able and sufficient judges; and to that end he made that grave and learned judge, Sir William Hankford, Chief-Justice of the King's Bench here, who afterwards for his service in this realm was made Chief-Justice of the King's Bench in England by King Henry the Fourth, and did withal associate unto him William Sturmy, a well-learned man in the law, who likewise came out of England 



---

p.317



 

with the King, that the legal proceedings, which were out of order too, as all other things in that realm were, might be amended and made formal, according to the course and precedents of England. But all the good purposes and projects of this King were interrupted and utterly defeated by this sudden departure out of Ireland and unhappy deposition from the Crown of England.


Howbeit, King Henry the Fourth, intending likewise to prosecute this noble work in the third year of his reign, made the Lord Thomas of Lancaster, his second son, Lieutenant of Ireland, who came over in person, and accepted again the submissions of divers Irish lords and captains, as is before remembered; and held also a Parliament, wherein he gave new life to the Statutes of Kilkenny and made other good laws tending to the reformation of the kingdom. But the troubles raised against the King his father in England drew him home again so soon, as that seed 
of reformation took no root at all; neither had his service in that kind any good effect or success.


After this the State of England had no leisure to think of a general reformation in this realm till the civil dissensions of England were appeased and the peace of that kingdom settled by King Henry the Seventh.


For, albeit in the time of King Henry the Sixth, Richard Duke of York, a Prince of the blood, of great wisdom and valour, and heir to a third part of the kingdom at least, being Earl of Ulster and Lord of Connaught and Meath, was sent the King's Lieutenant into Ireland to recover and reform that realm, where he was resident in person for the greatest part of ten years, yet the truth is he aimed at another mark, which was the Crown of England. And therefore he thought it no policy to distaste either the English or Irish by a course of reformation, but sought by all means to please them, and by popular courses to steal away their hearts, to the end he might strengthen his party when he should set on 

 


---

p.318




foot his title, as is before declared. Which policy of his took such effect as that he drew over with him into England the flower of all the English colonies, specially of Ulster and Meath, whereof many noblemen and gentlemen were slain with him at Wakefield, as is likewise before remembered. And after his death, when the wars between the houses were in their heat, almost all the good English blood which was left in Ireland was spent in those civil dissensions, so as the Irish became victorious over all without blood or sweat. Only that little canton of land called the English Pale, containing four small shires, did maintain a bordering war with the Irish and retain the form of English government.


But out of that little precinct there were no lords, knights, or burgesses summoned to the Parliament; neither did the King's Writ run in any other part of the kingdom; and yet upon the marches and borders, which at that time were grown so large as. they took up half Dublin, half Meath, and a third part of Kildare and Louth, there was no law in use but the March Law, which in the Statutes of Kilkenny is said to be no law, but a lewd custom.


So as upon the end of these civil wars in England the English law and government was well banished out of Ireland, so as no footstep or print was left of any former reformation.


Then did King Henry the Seventh send over Sir Edward Poynings to be his Deputy, a right worthy servitor both in war and peace. The principal end of his employment was to expel **Perkin Warbeck** out of this kingdom; but that service being performed, that worthy Deputy, finding nothing but a common misery, took the best course he possibly could to establish a commonwealth in Ireland; and to that end he held a Parliament no less famous than that of Kilkenny, and more available for the reformation of the whole kingdom. For, whereas all wise men did ever concur in opinion that the readiest way to reform Ireland is to settle a form of civil government there conformable to that of 



---

p.319



 

England, to bring this to pass **Sir Edward Poynings** did pass an Act whereby all the Statutes made in England before that time were enacted, established, and made of force in Ireland. Neither did he only respect the time past, but provided also for the time to come. For he caused another law to be made, that no Act should be propounded in any Parliament of Ireland but such as should be first transmitted into England and approved by the King and Council there as good and expedient for that land, and so returned back again, under the Great Seal of England. This Act, though it seemed prima facie to restrain the liberty of the subjects of Ireland, yet was it made at the prayer of the Commons upon just and important cause.


For the governors of that realm, specially such as were of that country birth, had laid many oppressions upon the commons; and amongst the rest they had imposed laws upon them, not tending to the general good, but to serve private turns, and to strengthen their particular factions. This moved them to refer all laws that were to be passed in Ireland to be considered, corrected, and allowed, first by the State of England, which had always been tender and careful of the good of this people, and had long since made them a civil, rich, and happy nation if their own lords and governors there had not sent bad intelligence into England. Besides this, he took special order that the summons of Parliament should go into all the shires of Ireland, and not to the four shires only; and for that cause specially he caused all the Acts of a Parliament lately before holden by the Viscount of Gormanstown to be repealed and made void. Moreover, that the Parliaments of Ireland might want no decent or honourable form that was used in England, he caused a particular Act to pass that the lords of Ireland should appear in the like Parliament robes as the English lords are wont to wear in the Parliaments of England. Having thus established all the Statutes of England in Ireland and set in order the great Council of that realm, he 

 


---

p.320




did not omit to pass other laws as well for the increase of the King's revenue as the preservation of the public peace.


To abundance[46](javascript:footNote('E610003/note046.html')) the profits of the Crown, first he obtained a subsidy of 265. 8d. out of every six score acres manured, payable yearly for five years; next he resumed all the Crown land which had been aliened, for the most part, by Richard Duke of York; and lastly, he procured a subsidy of poundage out of all merchandises imported and exported, to be granted to the Crown in perpetuity.


To preserve the public peace he revived the Statutes of Kilkenny. He made wilful murder high treason. He caused the Marchers to book their men for whom they should answer; and restrained the making war or peace without special commission from the State.


These laws, and others as important as these, for the making of a commonwealth in Ireland, were made in the government of **Sir Edward Poyning**. But these laws did not spread their virtue beyond the English Pale, though they were made generally for the whole kingdom. For the provinces without the Pale, which during the war of York and Lancaster had wholly cast off the English government, were not apt to receive this seed of reformation, because they were not first broken and mastered again with the sword. Besides, the Irish countries, which contained two-third parts of the kingdom, were not reduced to shireground, so as in them the laws of England could not possibly be put in execution. Therefore these good laws and provisions made by **Sir Edward Poyning** were like good lessons set for a lute that is broken and out of tune, of which lessons little use can be made till the lute be made fit to be played upon.


And that the execution of all these laws had no greater latitude than the Pale is manifest by the Statute of the thirteenth of Henry the Eighth, c. 3, which reciteth that at that time the 



---

p.321



 

King's laws were obeyed and executed in the four shires only; and yet then was the Earl of Surrey Lieutenant of Ireland, a governor much feared of the King's enemies and exceedingly honoured and beloved of the King's subjects. And the instructions given by the State of Ireland to John Allen, Master of the Rolls, employed into England near about the same time, do declare as much; wherein, among other things, he is required to advertise the King, that his land of Ireland was so much decayed that the King's laws were not obeyed twenty miles in compass. Whereupon grew that byword used by. the Irish, viz., that they dwelt by-west the law which dwelt beyond the river of the Barrow, which is within thirty miles of Dublin. The same is testified by Baron Finglas in his discourse of the decay of Ireland, which he wrote about the twentieth year of King Henry the Eighth. And thus we see the effect of the reformation which was intended by **Sir Edward Poynings**.


The next attempt of reformation was made in the twenty-eigthth year of King Henry the Eighth by the Lord Leonard Gray, who was created Viscount of Gamy in this kingdom, and held a Parliament wherein many excellent laws were made. But to prepare the minds of the people to obey these laws, he began first with a martial course; for, being sent over to suppress the rebellion of the Geraldines, which he performed in a few months, he afterwards made a victorious circuit round about the kingdom, beginning in Ofaly against O'Connor, who had aided the Geraldines in their rebellion; and from thence passing along through all the Irish countries in Leinster, and so into Munster, where he took pledges of the degenerate Earl of Desmond; and thence into Connaught, and thence into Ulster; and then concluded this warlike progress with the battle of Belahoo in the borders of Meath, as is before remembered.


The principal septs of the Irishry being all terrified, and most of them broken in this journey, many of their chief lords upon 



---

p.322




this Deputy's return came to Dublin and made their submissions to the Crown of England, namely, the O'Neills and O'Reillys of Ulster, MacMurrough, O'Byrne, and O'Carrol of Leinster, and the Bourkes of Connaught.


This preparation being made, he first propounded and passed in Parliament these laws which made the great alteration in the State Ecclesiastical, namely, the Act which declared King Henry the Eighth to be supreme head of the Church of Ireland; the Act prohibiting appeals to the Church of Rome; the Act for first-fruits and twentieth part to be paid to the King; the Act for faculties and dispensations; and lastly, the Act that did utterly abolish the usurped authority of the Pope. Next, for the increase of the King's revenue, by one Act he suppressed sundry abbeys and religious houses, and by another Act resumed the lands of the absentees, as is before remembered.


And for the civil government a special Statute was made to abolish the black-rents and tributes exacted by the Irish upon the English colonies; and another law enacted that the English apparel, language, and manner of living should be used by all such as would acknowledge themselves the King's subjects. This Parliament being ended, the Lord Leonard Gray was suddenly revoked and put to death in England, so as he lived not to finish the work of reformation which he had begun; which, notwithstanding, was well pursued by his successor, Sir Anthony Saint-Leger, unto whom all the lords and chieftains of the Irishry and of the degenerate English throughout the kingdom made their several submissions by indenture: which was the fourth General Submission of the Irish made since the first attempt of the conquest of Ireland, whereof the first was made to King Henry the Second, the second to King John, the third to King Richard the Second, and this last to Sir Anthony Saint-Leger in the thirty-third of Henry the Eighth.


In these indentures of submission all the Irish lords do acknowledge



---

p.323



 

King Henry the Eighth to be their Sovereign Lord and King, and desire to be accepted of him as subjects. They confess the King's supremacy in all causes, and do utterly renounce the Pope's jurisdiction, which I conceive to be worth the noting, because when the Irish had once resolved to obey the King they made no scruple to renounce the Pope. And this was not only done by the mere Irish, but the chief of the degenerate English families did perform the same; as Desmond, Barry, and Roche in Munster, and the Bourkes, which bore the title of Mac William, in Connaught.


These submissions being thus taken, the Lord Deputy and Council for the present government of those Irish countries made certain ordinances of State not agreeable altogether with the rules of the law of England, the reason whereof is expressed in the preamble of those ordinances: ‘Quia nondum sic sapiunt leges et jura, ut secundum ea iam immediate vivere et regi possint;’[47](javascript:footNote('E610003/note047.html')) The chief points or articles of which orders registered in the Councilbook are these: That King Henry the Eighth should be accepted, reputed, and named ‘King of Ireland’ by all the inhabitants of the kingdom; that all archbishops and bishops should be permitted to exercise their jurisdiction in every diocese throughout the land; that tithes should be duly set out and paid; that children should not be admitted to benefices; that for every manslaughter and theft above 14d. committed in the Irish countries the offender should pay a fine of 40 li. to the King, and 20 li. to the captain of the country; and for every theft under 14d. a fine of 5 marks should be paid, 46s. 8d. to the captain and 20s. to the tanister; that horsemen and kern should not be imposed upon the common people to be fed and maintained by them; that the master should answer for his servants and the father for his children; that cuttings should not be made by the lord upon his 



---

p.324




tenants to maintain war with his neighbours, but only to bear his necessary expenses, &c.


These ordinances of State being made and published, there were nominated and appointed in every province certain orderers or arbitrators, who, instead of these Irish Brehons, should hear and determine all their controversies. In Connaught, the Archbishop of Tuam, the Bishop of Clonfert, Captain Wakeley, and Captain Ovington; in Munster, the Bishop of Waterford, the Bishop of Cork and Ross, the Mayor of Cork, and Mayor of Youghal; in Ulster, the Archbishop of Armagh and the Lord of Louth. And if any difference did arise which they could not end, either for the difficulty of the cause or for the obstinacy of the parties, they were to certify the Lord Deputy and Council, who would decide the matter by their authority.


Hereupon the Irish captains of lesser territories, which had ever been oppressed by the greater and mightier some with risings out, others with bonaght, and others with cuttings and spendings at pleasure did appeal for justice to the Lord Deputy, who, upon hearing their complaints, did always order that they should all immediately depend upon the King, and that the weaker should have no dependency upon the stronger.


Lastly, he prevailed so much with the greatest of them, namely, O'Neill, O'Brien, and MacWilliam, as that they willingly did pass into England and presented themselves to the King, who thereupon was pleased to advance them to the degree and honour of Earls, and to grant unto them their several countries by Letters Patents. Besides, that they might learn obedience and civility of manners by often repairing unto the State, the King, upon the motion of the same Deputy, gave each of them a house and lands near Dublin for the entertainment of their several trains.


This course did this governor take to reform the Irishry, but withal he did not omit to advance both the honour and profit of the King. For, in the Parliament which he held the thirty-third 



---

p.325



 

of Henry the Eighth, he caused an Act to pass which gave unto King Henry the Eighth, his heirs and successors, the name, style, and title of ‘King of Ireland’; whereas before that time the Kings of England were styled but Lords of Ireland; albeit, indeed, they were absolute monarchs thereof, and had in right all royal and imperial jurisdiction and power there as they had in the realm of England. And yet, because in the vulgar conceit the name of King is higher than the name of Lord, assuredly the assuming of this title hath not a little raised the sovereignty of the King of England in the minds of this people. Lastly, this Deputy brought a great augmentation to the King's revenue by dissolving of all the monasteries and religious houses in Ireland, which was done in the same Parliament, and afterward by procuring Min and Cavendish, two skilful auditors, to be sent over out of England, who took an exact survey of all the possessions of the Crown, and brought many things into charge which had been concealed and subtracted for many years before. And thus far did Sir Anthony Saint-Leger proceed in the course of reformation, which, though it were a good beginning, yet was it far from reducing Ireland to the perfect obedience of the Crown of England. For all this while the provinces of Connaught and Ulster and a good part of Leinster were not reduced to shire-ground: and though Munster were anciently divided into counties, the people were so degenerate as no justice of assize durst execute his commission amongst them. None of the Irish lords or tenants were settled in their possessions by any grant or confirmation from the Crown, except the three great Earls before named, who, notwithstanding, did govern their tenants and followers by the Irish or Brehon Law, so as no treason, murder, rape, or theft committed in those countries was inquired of or punished by the law of England; and, consequently, no escheat, forfeiture, or fine, no revenue, certain or casual, did acrue to the Crown out of those provinces.




---

p.326


The next worthy governor that endeavoured to advance this reformation was Thomas Earl of Sussex, who, having thoroughly broken and subdued the two most rebellious and powerful Irish septs in Leinster, namely, the Moores and O'Connors, possessing the territories Leix and Ofaly, did by Act of Parliament third and fourth Philip and Mary, reduce those countries into two several counties, naming the one the King's and the other the Queen's County, which were the first two counties that had been made in this kingdom since the twelfth year of King John, at what time the territories then possessed by the English colonies were reduced into twelve shires, as is before expressed.


This noble Earl, having thus extended the jurisdiction of the English law into two counties more, was not satisfied with that addition, but took a resolution to divide all the rest of the Irish countries unreduced into several shires; and to that end he caused an Act to pass in the same Parliament authorising the Lord Chancellor, from time to time, to award commissions to such persons as the Lord Deputy should nominate and appoint to view and perambulate those Irish territories, and thereupon to divide and limit the same into such and so many several counties as they should think meet; which being certified to the Lord Deputy and approved by him, should be returned and enrolled in the Chancery, and from thenceforth be of like force and effect as if it were done by Act of Parliament.


Thus did the Earl of Sussex lay open a passage for the civil government into the unreformed parts of this kingdom, but himself proceeded no further than is before declared.


Howbeit, afterwards, during the reign of Queen Elizabeth, Sir Henry Sidney, who hath left behind him many monuments of a good governor in this land, did not only pursue that course which the Earl of Sussex began in reducing the Irish countries into shires and placing therein sheriffs and other ministers of the law: for first he made the Annaly, a territory in Leinster, possessed 



---

p.327



 

by the sept of O'Farrels, one entire shire by itself, and called it the county of Longford; and after that he divided the whole province of Connaught into six counties more; namely, Clare, which containeth all Thomond, Gal way, Sligo, Mayo, Roscommon, and Leitrim. But he also had caused divers good laws to be made, and performed sundry other services tending greatly to the reformation of this kingdom. For, first, to diminish the greatness of the Irish lords, and to take from them the dependency of the common people, in the Parliament which he held eleventh of Elizabeth, he did abolish their pretended and usurped captainships and all exactions and extortions incident thereunto. Next, to settle their seigniories and possessions in a course of inheritance according to the course of the Common Law, he caused an Act to pass whereby the Lord Deputy was authorised to accept their surrenders and to regrant estates unto them, to hold of the Crown by English tenures and services. Again, because the inferior sort were loose and poor and not amenable to the law, he provided by another Act that five of the best and eldest persons of every sept should bring in all the idle persons of their surname to be justified by the law. Moreover, to give a civil education to the youth of this land in the time to come, provision was made by another law that there should be one free school, at least, erected in every diocese of the kingdom. And lastly, to inure and acquaint the people of Munster and Connaught with the English government again, which had not been in use among them for the space of two hundred years before, he instituted two Presidency Courts in those two provinces, placing Sir Edward Fitton in Connaught and Sir John Perrot in Munster.


To augment the King's revenue in the same Parliament, upon the attainder of **Shane O'Neill** he resumed and vested in the Crown more than half the province of Ulster; he raised the customs upon the principal commodities of the kingdom; he reformed the abuses of the Exchequer by many good orders and 

 


---

p.328




instructions sent out of England; and lastly, he established the composition of the Pale, in lieu of purveyance and cess of soldiers.


These were good proceedings in the work of reformation, but there were many defects and omissions withal; for though he reduced all Connaught into counties, he never sent any justices of assize to visit that province, but placed commissioners there, who governed it only in a course of discretion, part martial and part civil. Again, in the law that doth abolish the Irish captainships, he gave way for the reviving thereof again, by excepting such as should be granted by the Letters Patents from the Crown, which exception did indeed take away the force of that law. For no governor during Queen Elizabeth's reign did refuse to grant any of those captainships to any pretended Irish lord who would desire and with his thankfulness deserve the same. And again, though the greatest part of Ulster were vested by Act of Parliament in the actual and real possession of the Crown, yet was there never any seizure made thereof, nor any part thereof brought into charge, but the Irish were permitted to take all the profits without rendering any duty or acknowledgment for the same. And though the name of O'Neill were damned by that Act, and the assuming thereof made high treason, yet after that was Tirlagh Leynnagh suffered to bear that title and to intrude upon the possessions of the Crown, and yet was often entertained by the State with favour. Neither were these lands resumed by Act of eleventh of Elizabeth neglected only, for the abbeys and religious houses in Tyrone, Tyrconnel, and Fermanagh, though they were dissolved in the thirty-third of Henry the Eighth were never surveyed nor reduced into charge, but were continually possessed by the religious persons, until His Majesty, that now is, came to the Crown. And that which is more strange, the donations of bishoprics being a flower of the Crown which the Kings of England did ever retain in all their dominions when the 



---

p.329



 

Pope's usurped authority was at the highest, there were three bishoprics in Ulster, namely, Derry, Rapho, and Clogher, which neither Queen Elizabeth, nor any of her progenitors did ever bestow, though they were the undoubted patrons thereof. So as King James was the first King of England that did ever supply those sees with bishops; which is an argument either of great negligence or of groat weakness in the State and governors of those times. And thus far proceeded Sir Henry Sidney.


After him, Sir John Perrot, who held the last Parliament 'in this kingdom, did advance the reformation in three principal points. First, in establishing the great composition of Connaught, in which service the wisdom and industry of Sir Richard Bingham did concur with him; next, in reducing unreformed parts of Ulster into seven shires, namely, Armagh, Monaghan, Tyrone, Colerain, Donegal, Fermanagh, and Cavan; though in his time the law was never executed in these new counties by any sheriffs, or justices of assize, but the people left to be ruled still by their own barbarous lords and laws. And lastly, by vesting in the Crown the lands of Desmond and his adherents in Munster, and planting the same with English, though that plantation were imperfect in many points.


After Sir John Perrot, Sir William Fitzwilliams did good service in two other points. First, in raising a composition in Munster, and then settling the possessions both of the lords and tenants in Monaghan, which was one of the last acts of State tending to the reformation of the civil government which was performed in the reign of Queen Elizabeth.


Thus we see by what degrees and what policy and success the governors of this land from time to time, since the beginning of the reign of King Edward the Third, have endeavoured to reform and reduce this people to the perfect obedience of the Crown of England. And we find that before the civil wars of York and Lancaster they did chiefly endeavour to bring back 



---

p.330




the degenerate English colonies to their duty and allegiance, not respecting the mere Irish, whom they reputed as aliens or enemies of the Crown. But after King Henry the Seventh had united the Roses, they laboured to reduce both English and Irish together, which work to what pass and perfection it was brought in the latter end of Queen Elizabeth's reign hath been before declared.


Whereof sometimes when I do consider, I do in mine own conceit compare these later governors who went about to reform the civil affairs in Ireland unto some of the Kings of Israel, of whom it is said that they were good Kings, but they did not cut down the groves and high places, but suffered the people still to burn incense and commit idolatry in them. So Sir Anthony Saint-Leger, the Earl of Sussex, Sir Henry Sidney, and Sir John Perrot were good governors, but they did not abolish the Irish customs nor execute the law in the Irish countries, but suffered the people to worship their barbarous lords and to remain utterly ignorant of their duties to God and the King.


And now I am come to the happy reign of my Most Gracious Lord and Master King James, in whose time, as there hath been a concurrence of many great felicities, so this, among others, may be numbered in the first rank, that all the defects in the government of Ireland spoken of before have been fully supplied in the first nine years of his reign, in which time there hath been more done in the work and reformation of this kingdom than in the 440 years which are past since the conquest was first attempted.


Howbeit, I have no purpose in this discourse to set forth at large all the proceedings of the State here in reforming of this kingdom since His Majesty came to the Crown, for the parts and passages thereof are so many as to express them fully would require a several treatise. Besides, I, for my part, since I have not flattered the former times, but have plainly laid open the negligence and errors of every age that is past, would not willingly



---

p.331



 

seem to flatter the present by amplifying the diligence and true judgment of those servitors that have laboured in this vineyard since the beginning of His Majesty's happy reign.


I shall therefore summarily, without any amplification at all, show in what manner and by what degrees all the defects which I have noted before in the government of this kingdom have been supplied since His Majesty's happy reign began, and so conclude these observations concerning the state of Ireland.


First, then, touching the martial affairs I shall need to say little, in regard that the war which finished the conquest of Ireland was ended in almost the instant when the crown descended upon His Majesty; and so there remained no occasion to amend the former errors committed in the prosecution of the war. Howbeit, sithence His Majesty hath still maintained an army here, as well for a seminary of martial men as to give strength and countenance to the civil magistrate, I may justly observe that this army hath not been fed with coigny and livery or cess, with which extortions the soldier hath been nourished in the times of former Princes, but hath been as justly and royally paid as ever Prince in the world did pay his men of war. Besides, when there did arise an occasion of employment for this army against the rebel O'Dogherty, neither did His Majesty delay the reinforcing thereof, but instantly sent supplies out of England and Scotland; neither did the martial men dally or prosecute the service faintly, but did forthwith quench that fire whereby themselves would have been the warmer the longer it had continued, as well by the increase of their entertainment as by booties and spoil of the country. And thus much I thought fit to note touching the amendment of the errors in the martial affairs.


Secondly, for the supply of the defects in the civil government these courses have been pursued since His Majesty's prosperous reign began.


First, albeit upon the end of the war whereby Tyrone's universal



---

p.332




rebellion was suppressed the minds of the people were broken and prepared to obedience of the law, yet the State, upon good reason, did conceive that the public peace could not be settled till the hearts of the people were also quieted by securing them from the danger of the law, which the most part of them had incurred one way or other in that great and general confusion.


Therefore, first by a general Act of State, called the Act of Oblivion, published by proclamation under the Great Seal, all offences against the Crown and all particular trespasses between subject and subject done at any time before His Majesty's reign were, to all such as would come in to the justices of assize by a certain day and claim the benefit of this Act, pardoned, remitted, and utterly extinguished, never to be revived or called in question. And by the same proclamation, all the Irishry, who for the most part in former times were left under the tyranny of their lords and chieftains, and had no defence or justice from the Crown, were received into His Majesty's immediate protection. This bred such comfort and security in the hearts of all men as thereupon ensued the calmest and most universal peace that ever was seen in Ireland.


The public peace being thus established, the State proceeded next to establish the public justice in every part of the realm; and to that end, **Sir George Cary**, who was a prudent governor and a just, and made a fair entry into the right way of reforming this kingdom, did in the first year of His Majesty's reign make the first sheriffs that ever were made in Tyrone and Tyrconnel, and shortly after sent Sir Edmund Pelham, Chief Baron, and myself thither, the first justices of assize that ever sat in those countries; and in that circuit we visited all the shires of that province. Besides, which visitation, though it were somewhat distasteful to the Irish lords, was sweet and most welcome to the common people, who, albeit they were rude and barbarous, yet did they quickly apprehend the difference between the tyranny 



---

p.333




and oppression under which they lived before and the just government and protection which we promised unto them for the time to come.


The law having made her progress into Ulster with so good success, Sir Arthur Chichester, who with singular industry, wisdom, and courage hath now for the space of seven years and more prosecuted the great work of reformation, and brought it well near to an absolute perfection, did in the first year of his government establish two other new circuits for justices of assize, the one in Connaught and the other in Munster. I call them new circuits, for that, although it be manifest by many records that justices itinerant have in former times been sent into all the shires of Munster and some part of Connaught, yet certain it is that in two hundred years before — I speak much within compass — no such commission had been executed in either of these two provinces. But now, the whole realm being divided into shires, and every bordering territory whereof any doubt was made in what county the same should lie being added or reduced to a county certain; — among the rest, the mountains and glynnes on the south side of Dublin were lately made a shire by itself, and called the county of Wicklow, whereby the inhabitants, which were wont to be thorns in the side of the Pale, are become civil and quiet neighbours thereof; the streams of the public justice were derived into every part of the kingdom, and the benefit and protection of the law of England communicated to all, as well 
Irish as English, without distinction or respect of persons; by reason whereof the work of deriving the public justice grew so great as that there was ‘Magna messis, sed operarii pauci.’[48](javascript:footNote('E610003/note048.html')) And therefore the number of the judges in every Bench was increased, which do now every half-year, like good planets in their several spheres or circles, carry the light and influence of justice round about the kingdom; whereas the circuits in former times went 



---

p.334




but round about the Pale, like the circuit of the Cynosura about the Pole —
  


‘Qua cursu nitentiore, brevi convertitur orbe.’


Upon these visitations of justice, whereby the just and honourable law of England was imparted and communicated to all the Irishry, there followed these excellent good effects: —
  


First, the common people were taught by the justices of assize that they were free subjects to the Kings of England, and not slaves and vassals to their pretended lords; that the cuttings, cosheries, cessings, and other extortions of their lords were unlawful, and that they should not any more submit themselves thereunto, since they were now under the protection of so just and mighty a Prince as both would and could protect them from all wrongs and oppressions. They gave a willing ear unto these lessons; and thereupon the greatness and power of those Irish lords over the people suddenly fell and vanished when their oppressions and extortions were taken away which did maintain their greatness. Insomuch as divers of them, who formerly made themselves owners of all by force, were now by the law reduced to this point, that, wanting means to defray their ordinary charges, they resorted ordinarily to the Lord Deputy, and made petition that by license and warrant of the State they might take some aid and contribution from their people, as well to discharge their former debts as for competent maintenance in time to come. But some of them, being impatient of this diminution, fled out of the realm to foreign countries. Whereupon we may 
well observe, that as extortion did banish the old English freeholder who could not live but under the law, so the law did banish the Irish lord who could not live but by extortion.


Again, these circuits of justice did, upon the end of the war, more terrify the loose and idle persons than the execution of the martial law, though it were more quick and sudden; and in a 



---

p.335



 

short time after did so clear the kingdom of thieves and other capital offenders as I dare affirm that for the space of five years last past there have not been found so many malefactors worthy of death in all the six circuits of this realm, which is now divided into thirty-two shires at large, as in one circuit of six shires, namely, the western circuit in England. For the truth is, that in time of peace the Irish are more fearful to offend the law than the English or any other nation whatsoever.


Again, whereas the greatest advantage that the Irish had of us in all their rebellions was our ignorance of their countries, their persons, and their actions; since the law and her ministers have had a passage among them, all their places of fastness have been discovered and laid open, all their paces cleared, and notice taken of every person that is able to do either good or hurt. It is known not only how they live and what they do, but it is foreseen what they purpose or intend to do; insomuch as Tyrone hath been heard to complain that he had so many eyes watching over him as he could not drink a full carouse of sack but the State was advertised thereof within few hours after. And, therefore, those allowances which I find in the ancient Pipe-Rolls, ‘Pro guidagio et spiagio,’ may be well spared at this day. For the under-sheriffs and bailiffs-errant are better guides and spies in the time of peace than any were found in the time of war.


Moreover, these civil assemblies at assizes and sessions have reclaimed the Irish from their wildness, caused them to cut off their glibs and long hair, to convert their mantles into cloaks, to conform themselves to the manner of England in all their behaviour and outward forms. And because they find a great inconvenience in moving their suits by an interpreter, they do for the most part send their children to schools, especially to learn the English language; so as we may conceive an hope that the next generation will in tongue and heart and every way else become English, so as there will be no difference or distinction but the 



---

p.336




Irish Sea betwixt us. And thus we see a good conversion and the Irish game turned again.


For heretofore the neglect of the law made the English degenerate and become Irish; and now, on the other side, the execution of the law doth make the Irish grow civil and become English.


Lastly, these general sessions now do teach the people more obedience and keep them more in awe than did the general hostings in former times. These progresses of the law renew and confirm the conquest of Ireland every half-year, and supply the defect of the King's absence in every part of the realm, in that every judge sitting in the seat of justice doth represent the person of the King himself.


These effects hath the establishment of the public peace and justice produced since His Majesty's happy reign began.


Howbeit, it was impossible to make a Commonweal in Ireland without performing another service; which was, the settling of all the estates and possessions, as well of Irish as English, throughout the kingdom. For, although that in the twelfth year of Queen Elizabeth a special law was made which did enable the Lord Deputy to take surrenders and regrant estates unto the Irishry, upon signification of Her Majesty's pleasure in that behalf, yet were there but few of the Irish lords that made offer to surrender during her reign; and they which made surrenders of entire countries obtained grants of the whole again to themselves only and to no other, and all in demesne. In passing of which grants there was no care taken of the inferior septs of people inhabiting and possessing these countries under them, but they held their several portions in the course of tanistry and gavelkind, and yielded the same Irish duties or exactions as they did before. So that upon every such surrender and grant there was but one freeholder made in a whole country, which was the lord himself; all the rest were but tenants at will, or rather tenants in villeinage, 



---

p.337



 

and were neither fit to be sworn in juries nor to perform any public service; and by reason, of the uncertainty of their estates, did utterly neglect to build or to plant or to improve the land. And therefore, although the lord were become the King's tenant, his country was no whit reformed thereby, but remained in the former barbarism and desolation.


Again, in the same Queen's time there were many Irish lords which did not surrender, yet obtained Letters Patents of the captainships of their countries, and of all lands and duties belonging to those captainships; for the Statute which doth condemn and abolish these captainries usurped by the Irish doth give power to the Lord Deputy to grant the same by Letters Patents. Howbeit, these Irish captains, and likewise the English which which were made seneschals of the Irish countries, did by colour of these grants, and under pretence of government claim an Irish seigniory and exercise plain tyranny over the common people. And this was the fruit that did arise of the Letters Patents granted of the Irish countries in the time of Queen Elizabeth, where before they did extort and oppress the people only by colour of a lewd and barbarous custom, they did afterwards use the same extortions and oppressions by warrant under the Great Seal of the realm.


But now, since His Majesty came to the crown, two special Commissions have been sent out of England for the settling and quieting of all the possessions in Ireland, the one for accepting surrenders of the Irish and degenerate English, and for regranting estates unto them according to the course of the Common Law; the other for strengthening of defective titles. In the execution of which commissions there hath ever been had a special care to settle and secure the under-tenants, to the end there might be a repose and establishment of every subject's estate, lord and tenant, freeholder and farmer, throughout the kingdom.


Upon surrenders, this course hath been held from the beginning.



---

p.338




When an Irish lord doth offer to surrender his country his surrrender is not immediately accepted, but a Commission is first awarded to inquire of three special points; first, of the quantity and limits of the land whereof he is reputed owner; next, how much himself doth hold in demesne and how much is possessed by his tenants and followers; and thirdly, what customs, duties, and services he doth yearly receive out of those lands. This inquisition being made and returned, the lands which are found to be the lord's proper possessions in demesne are drawn into a particular, and his Irish duties, as cosherings, cessings, rents of butter and oatmeal, and the like, are reasonably valued and reduced into certain sums of money, to be paid yearly in lieu thereof. This being done the surrender is accepted, and thereupon arrant passed, not of the whole country, as was used in former times, but of those lands only which are found in the lord's possession, and of those certain sums of money as rents issuing out of the rest. But the lands which are found to be possessed by the tenants are left unto them respectively, charged with these certain rents only in lieu of all uncertain Irish exactions.


In like manner, upon all grants which have passed by virtue of the Commission for defective titles, the Commissioners have taken special caution for preservation of the estates of all particular tenants.


And as for grants of captainships or seneschalships in the Irish countries, albeit this Deputy had as much power and authority to grant the same as any other governors had before him, and might have raised as much profit by bestowing the same if he had respected his private more than the public good, yet hath he been so far from passing any such in all his time as he hath endeavoured to resume all the grants of that kind that have been made by his predecessors, to the end the inferior subjects of the realm should make their only and immediate dependency upon the Crown. And thus we see how the greatest part of the possessions,



---

p.339



 

as well of the Irish as of the English, in Leinster, Connaught, and Munster, are settled and secured since His Majesty came to the crown; whereby the hearts of the people are also settled, not only to live in peace, but raised and encouraged to build, to plant, to give better education to their children, and to improve the commodities of their lands, whereby the yearly value thereof is already increased double of that it was within these few years, and is like daily to rise higher, till it amount to the price of our land in England.


Lastly, the possessions of the Irishry in the province of Ulster, though it were the most rude and unreformed part of Ireland, and the seat and nest of the last great rebellion, are now better disposed and established than any the lands in the other provinces which have been passed and settled upon surrenders. For, as the occasion of the disposing of those lands did not happen without the special providence and finger of God, which did cast out those wicked and ungrateful traitors who were the only enemies of the reformation of Ireland; so the distribution and plantation thereof hath been projected and prosecuted by the special direction and care of the King himself; wherein His Majesty hath corrected the errors before spoken of committed by King Henry the Second and King John in distributing and planting the first conquered lands. For, although there were six whole shires to be disposed, His Majesty gave not an entire country or county to any particular person; much less did he grant Jura Regalia or any extraordinary liberties. For the best British undertaker had but a proportion of 3000 acres for himself, with power to create a manor and hold a Court Baron; albeit many of these undertakers were of as great birth and quality as the best adventurers in the first conquest. Again, His Majesty did not utterly exclude the natives out of this plantation with a purpose to root them out, as the Irish were excluded out of the first English colonies, but made a mixed plantation of British and Irish, that they might 



---

p.340




grow up together in one nation; only, the Irish were in some places transplanted from the woods and mountains into the plains and open countries, that, being removed, like wild fruit-trees, they might grow the milder and bear the better and sweeter fruit. 
And this, truly, is the masterpiece and most excellent part of the work of reformation, and is worthy indeed of His Majesty's royal pains. For when this plantation hath taken root and been fixed and settled but a few years, with the favour and blessing of God 
for the Son of God Himself hath said in the Gospel, ‘Omnis plantatio, quam non plantavit pater meus, eradicabitur’[49](javascript:footNote('E610003/note049.html')) it will secure the peace of Ireland, assure it to the Crown of England for ever, and, finally, make it a civil and a rich, a mighty and a flourishing, kingdom.


I omit to speak of the increase of the revenue of the Crown, both certain and casual, which is raised to a double proportion, at least, above that it was, by deriving the public justice into all parts of the realm, by settling all the possessions both of the Irish and English, by re-establishing the compositions, by restoring and resuming the customs, by reviving the tenures in capite and knights-service, and reducing many other things into charge which by the confusion and negligence of former times became concealed and subtracted from the Crown. I forbear likewise to speak of the due and ready bringing in of the revenue, which is brought to pass by the well-ordering of the Court of Exchequer and the authority and pains of the Commissioners for Accounts.


I might also add hereunto the encouragement that hath been given to the maritime towns and cities, as well to increase their trade of merchandise as to cherish mechanical arts and sciences, in that all their charters have been renewed and their liberties more enlarged by His Majesty than by any of his progenitors since the conquest. As likewise the care and course that hath been taken to make civil commerce and intercourse between the 



---

p.341



 

subjects newly reformed and brought under obedience, by granting markets and fairs to be holden in their countries, and by erecting of corporate towns among them.


Briefly, the clock of the civil government is now well set, and all the wheels thereof do move in order. The strings of this Irish harp which the civil magistrate doth finger are all in tune; for I omit to speak of the State Ecclesiastical; and make a good harmony in this Commonweal. So as we may well conceive a hope that Ireland, which heretofore might properly be called the Land of Ire, because the irascible power was predominant there for the space of four hundred years together, will from henceforth prove a Land of Peace and Concord. And though heretofore it hath been like the lean cow of Egypt in Pharaoh's dream, devouring the fat of England, and yet remaining as lean as it was before, it will hereafter be as fruitful as the land of Canaan; the description whereof in the eighth of Deuteronomy doth in every part agree with Ireland, being,[50](javascript:footNote('E610003/note050.html')) ‘Terra rivorum, aquarumque, et fontium; in cuius campis, et montibus, erumpunt fluviorum abyssi; terra frumenti, et hordei; terra lactis, et mellis; ubi absque ulla penuria comedes panem tuum, et rerum abundantia perfrueris.’


And thus I have discovered and expressed the defects and errors as well in the managing of the martial affairs as of the civil, which in former ages gave impediment to the reducing of all Ireland to the obedience and subjection of the Crown of England. I have likewise observed what courses have been taken to reform the defects and errors in government and to reduce the people of this land to obedience since the beginning of the reign of King Edward the Third till the latter end of the reign of Queen Elizabeth.




---

p.342


And, lastly, I have declared and set forth how all the said errors have been corrected and the defects supplied under the prosperous government of His Majesty. So as I may positively conclude in the same words which I have used in the title of this discourse, that until the beginning of His Majesty's reign Ireland was never entirely subdued and brought under the obedience of the Crown of England. But since the crown of this kingdom, with the undoubted right and title thereof, descended upon His Majesty, the whole island from sea to sea hath been brought into His Highness's peaceable possession, and all the inhabitants in every corner thereof have been absolutely reduced under his immediate subjection. In which condition of subjects they will gladly continue without defection or adhering to any other Lord or King, as long as they may be protected and justly governed without oppression on the one side or impunity on the other. For there is no nation of people under the sun that doth love equal and indifferent justice better than the Irish, or will rest better satisfied with the execution thereof, although it be against themselves; so as they may have the protection and benefit of the law when upon just cause they do desire it.












